(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.mermaid = factory());
})(this, function() {
  var _a, _b;
  "use strict";
  function dedent(templ) {
    var values2 = [];
    for (var _i6 = 1; _i6 < arguments.length; _i6++) {
      values2[_i6 - 1] = arguments[_i6];
    }
    var strings = Array.from(typeof templ === "string" ? [templ] : templ);
    strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
    var indentLengths = strings.reduce(function(arr, str2) {
      var matches = str2.match(/\n([\t ]+|(?!\s).)/g);
      if (matches) {
        return arr.concat(matches.map(function(match) {
          var _a2, _b2;
          return (_b2 = (_a2 = match.match(/[\t ]/g)) === null || _a2 === void 0 ? void 0 : _a2.length) !== null && _b2 !== void 0 ? _b2 : 0;
        }));
      }
      return arr;
    }, []);
    if (indentLengths.length) {
      var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
      strings = strings.map(function(str2) {
        return str2.replace(pattern_1, "\n");
      });
    }
    strings[0] = strings[0].replace(/^\r?\n/, "");
    var string2 = strings[0];
    values2.forEach(function(value2, i2) {
      var endentations = string2.match(/(?:^|\n)( *)$/);
      var endentation = endentations ? endentations[1] : "";
      var indentedValue = value2;
      if (typeof value2 === "string" && value2.includes("\n")) {
        indentedValue = String(value2).split("\n").map(function(str2, i3) {
          return i3 === 0 ? str2 : "" + endentation + str2;
        }).join("\n");
      }
      string2 += indentedValue + strings[i2 + 1];
    });
    return string2;
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  var dayjs_min = { exports: {} };
  (function(module2, exports2) {
    !function(t, e) {
      module2.exports = e();
    }(commonjsGlobal, function() {
      var t = 1e3, e = 6e4, n = 36e5, r = "millisecond", i2 = "second", s = "minute", u = "hour", a = "day", o = "week", c2 = "month", f2 = "quarter", h = "year", d = "date", l = "Invalid Date", $ = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y2 = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ordinal: function(t4) {
        var e3 = ["th", "st", "nd", "rd"], n2 = t4 % 100;
        return "[" + t4 + (e3[(n2 - 20) % 10] || e3[n2] || e3[0]) + "]";
      } }, m = function(t4, e3, n2) {
        var r2 = String(t4);
        return !r2 || r2.length >= e3 ? t4 : "" + Array(e3 + 1 - r2.length).join(n2) + t4;
      }, v = { s: m, z: function(t4) {
        var e3 = -t4.utcOffset(), n2 = Math.abs(e3), r2 = Math.floor(n2 / 60), i3 = n2 % 60;
        return (e3 <= 0 ? "+" : "-") + m(r2, 2, "0") + ":" + m(i3, 2, "0");
      }, m: function t4(e3, n2) {
        if (e3.date() < n2.date())
          return -t4(n2, e3);
        var r2 = 12 * (n2.year() - e3.year()) + (n2.month() - e3.month()), i3 = e3.clone().add(r2, c2), s2 = n2 - i3 < 0, u2 = e3.clone().add(r2 + (s2 ? -1 : 1), c2);
        return +(-(r2 + (n2 - i3) / (s2 ? i3 - u2 : u2 - i3)) || 0);
      }, a: function(t4) {
        return t4 < 0 ? Math.ceil(t4) || 0 : Math.floor(t4);
      }, p: function(t4) {
        return { M: c2, y: h, w: o, d: a, D: d, h: u, m: s, s: i2, ms: r, Q: f2 }[t4] || String(t4 || "").toLowerCase().replace(/s$/, "");
      }, u: function(t4) {
        return void 0 === t4;
      } }, g = "en", D2 = {};
      D2[g] = M;
      var p = "$isDayjsObject", S2 = function(t4) {
        return t4 instanceof _2 || !(!t4 || !t4[p]);
      }, w2 = function t4(e3, n2, r2) {
        var i3;
        if (!e3)
          return g;
        if ("string" == typeof e3) {
          var s2 = e3.toLowerCase();
          D2[s2] && (i3 = s2), n2 && (D2[s2] = n2, i3 = s2);
          var u2 = e3.split("-");
          if (!i3 && u2.length > 1)
            return t4(u2[0]);
        } else {
          var a2 = e3.name;
          D2[a2] = e3, i3 = a2;
        }
        return !r2 && i3 && (g = i3), i3 || !r2 && g;
      }, O = function(t4, e3) {
        if (S2(t4))
          return t4.clone();
        var n2 = "object" == typeof e3 ? e3 : {};
        return n2.date = t4, n2.args = arguments, new _2(n2);
      }, b = v;
      b.l = w2, b.i = S2, b.w = function(t4, e3) {
        return O(t4, { locale: e3.$L, utc: e3.$u, x: e3.$x, $offset: e3.$offset });
      };
      var _2 = function() {
        function M2(t4) {
          this.$L = w2(t4.locale, null, true), this.parse(t4), this.$x = this.$x || t4.x || {}, this[p] = true;
        }
        var m2 = M2.prototype;
        return m2.parse = function(t4) {
          this.$d = function(t5) {
            var e3 = t5.date, n2 = t5.utc;
            if (null === e3)
              return /* @__PURE__ */ new Date(NaN);
            if (b.u(e3))
              return /* @__PURE__ */ new Date();
            if (e3 instanceof Date)
              return new Date(e3);
            if ("string" == typeof e3 && !/Z$/i.test(e3)) {
              var r2 = e3.match($);
              if (r2) {
                var i3 = r2[2] - 1 || 0, s2 = (r2[7] || "0").substring(0, 3);
                return n2 ? new Date(Date.UTC(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2)) : new Date(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2);
              }
            }
            return new Date(e3);
          }(t4), this.init();
        }, m2.init = function() {
          var t4 = this.$d;
          this.$y = t4.getFullYear(), this.$M = t4.getMonth(), this.$D = t4.getDate(), this.$W = t4.getDay(), this.$H = t4.getHours(), this.$m = t4.getMinutes(), this.$s = t4.getSeconds(), this.$ms = t4.getMilliseconds();
        }, m2.$utils = function() {
          return b;
        }, m2.isValid = function() {
          return !(this.$d.toString() === l);
        }, m2.isSame = function(t4, e3) {
          var n2 = O(t4);
          return this.startOf(e3) <= n2 && n2 <= this.endOf(e3);
        }, m2.isAfter = function(t4, e3) {
          return O(t4) < this.startOf(e3);
        }, m2.isBefore = function(t4, e3) {
          return this.endOf(e3) < O(t4);
        }, m2.$g = function(t4, e3, n2) {
          return b.u(t4) ? this[e3] : this.set(n2, t4);
        }, m2.unix = function() {
          return Math.floor(this.valueOf() / 1e3);
        }, m2.valueOf = function() {
          return this.$d.getTime();
        }, m2.startOf = function(t4, e3) {
          var n2 = this, r2 = !!b.u(e3) || e3, f3 = b.p(t4), l2 = function(t5, e4) {
            var i3 = b.w(n2.$u ? Date.UTC(n2.$y, e4, t5) : new Date(n2.$y, e4, t5), n2);
            return r2 ? i3 : i3.endOf(a);
          }, $2 = function(t5, e4) {
            return b.w(n2.toDate()[t5].apply(n2.toDate("s"), (r2 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e4)), n2);
          }, y3 = this.$W, M3 = this.$M, m3 = this.$D, v2 = "set" + (this.$u ? "UTC" : "");
          switch (f3) {
            case h:
              return r2 ? l2(1, 0) : l2(31, 11);
            case c2:
              return r2 ? l2(1, M3) : l2(0, M3 + 1);
            case o:
              var g2 = this.$locale().weekStart || 0, D3 = (y3 < g2 ? y3 + 7 : y3) - g2;
              return l2(r2 ? m3 - D3 : m3 + (6 - D3), M3);
            case a:
            case d:
              return $2(v2 + "Hours", 0);
            case u:
              return $2(v2 + "Minutes", 1);
            case s:
              return $2(v2 + "Seconds", 2);
            case i2:
              return $2(v2 + "Milliseconds", 3);
            default:
              return this.clone();
          }
        }, m2.endOf = function(t4) {
          return this.startOf(t4, false);
        }, m2.$set = function(t4, e3) {
          var n2, o2 = b.p(t4), f3 = "set" + (this.$u ? "UTC" : ""), l2 = (n2 = {}, n2[a] = f3 + "Date", n2[d] = f3 + "Date", n2[c2] = f3 + "Month", n2[h] = f3 + "FullYear", n2[u] = f3 + "Hours", n2[s] = f3 + "Minutes", n2[i2] = f3 + "Seconds", n2[r] = f3 + "Milliseconds", n2)[o2], $2 = o2 === a ? this.$D + (e3 - this.$W) : e3;
          if (o2 === c2 || o2 === h) {
            var y3 = this.clone().set(d, 1);
            y3.$d[l2]($2), y3.init(), this.$d = y3.set(d, Math.min(this.$D, y3.daysInMonth())).$d;
          } else
            l2 && this.$d[l2]($2);
          return this.init(), this;
        }, m2.set = function(t4, e3) {
          return this.clone().$set(t4, e3);
        }, m2.get = function(t4) {
          return this[b.p(t4)]();
        }, m2.add = function(r2, f3) {
          var d2, l2 = this;
          r2 = Number(r2);
          var $2 = b.p(f3), y3 = function(t4) {
            var e3 = O(l2);
            return b.w(e3.date(e3.date() + Math.round(t4 * r2)), l2);
          };
          if ($2 === c2)
            return this.set(c2, this.$M + r2);
          if ($2 === h)
            return this.set(h, this.$y + r2);
          if ($2 === a)
            return y3(1);
          if ($2 === o)
            return y3(7);
          var M3 = (d2 = {}, d2[s] = e, d2[u] = n, d2[i2] = t, d2)[$2] || 1, m3 = this.$d.getTime() + r2 * M3;
          return b.w(m3, this);
        }, m2.subtract = function(t4, e3) {
          return this.add(-1 * t4, e3);
        }, m2.format = function(t4) {
          var e3 = this, n2 = this.$locale();
          if (!this.isValid())
            return n2.invalidDate || l;
          var r2 = t4 || "YYYY-MM-DDTHH:mm:ssZ", i3 = b.z(this), s2 = this.$H, u2 = this.$m, a2 = this.$M, o2 = n2.weekdays, c3 = n2.months, f3 = n2.meridiem, h2 = function(t5, n3, i4, s3) {
            return t5 && (t5[n3] || t5(e3, r2)) || i4[n3].slice(0, s3);
          }, d2 = function(t5) {
            return b.s(s2 % 12 || 12, t5, "0");
          }, $2 = f3 || function(t5, e4, n3) {
            var r3 = t5 < 12 ? "AM" : "PM";
            return n3 ? r3.toLowerCase() : r3;
          };
          return r2.replace(y2, function(t5, r3) {
            return r3 || function(t6) {
              switch (t6) {
                case "YY":
                  return String(e3.$y).slice(-2);
                case "YYYY":
                  return b.s(e3.$y, 4, "0");
                case "M":
                  return a2 + 1;
                case "MM":
                  return b.s(a2 + 1, 2, "0");
                case "MMM":
                  return h2(n2.monthsShort, a2, c3, 3);
                case "MMMM":
                  return h2(c3, a2);
                case "D":
                  return e3.$D;
                case "DD":
                  return b.s(e3.$D, 2, "0");
                case "d":
                  return String(e3.$W);
                case "dd":
                  return h2(n2.weekdaysMin, e3.$W, o2, 2);
                case "ddd":
                  return h2(n2.weekdaysShort, e3.$W, o2, 3);
                case "dddd":
                  return o2[e3.$W];
                case "H":
                  return String(s2);
                case "HH":
                  return b.s(s2, 2, "0");
                case "h":
                  return d2(1);
                case "hh":
                  return d2(2);
                case "a":
                  return $2(s2, u2, true);
                case "A":
                  return $2(s2, u2, false);
                case "m":
                  return String(u2);
                case "mm":
                  return b.s(u2, 2, "0");
                case "s":
                  return String(e3.$s);
                case "ss":
                  return b.s(e3.$s, 2, "0");
                case "SSS":
                  return b.s(e3.$ms, 3, "0");
                case "Z":
                  return i3;
              }
              return null;
            }(t5) || i3.replace(":", "");
          });
        }, m2.utcOffset = function() {
          return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
        }, m2.diff = function(r2, d2, l2) {
          var $2, y3 = this, M3 = b.p(d2), m3 = O(r2), v2 = (m3.utcOffset() - this.utcOffset()) * e, g2 = this - m3, D3 = function() {
            return b.m(y3, m3);
          };
          switch (M3) {
            case h:
              $2 = D3() / 12;
              break;
            case c2:
              $2 = D3();
              break;
            case f2:
              $2 = D3() / 3;
              break;
            case o:
              $2 = (g2 - v2) / 6048e5;
              break;
            case a:
              $2 = (g2 - v2) / 864e5;
              break;
            case u:
              $2 = g2 / n;
              break;
            case s:
              $2 = g2 / e;
              break;
            case i2:
              $2 = g2 / t;
              break;
            default:
              $2 = g2;
          }
          return l2 ? $2 : b.a($2);
        }, m2.daysInMonth = function() {
          return this.endOf(c2).$D;
        }, m2.$locale = function() {
          return D2[this.$L];
        }, m2.locale = function(t4, e3) {
          if (!t4)
            return this.$L;
          var n2 = this.clone(), r2 = w2(t4, e3, true);
          return r2 && (n2.$L = r2), n2;
        }, m2.clone = function() {
          return b.w(this.$d, this);
        }, m2.toDate = function() {
          return new Date(this.valueOf());
        }, m2.toJSON = function() {
          return this.isValid() ? this.toISOString() : null;
        }, m2.toISOString = function() {
          return this.$d.toISOString();
        }, m2.toString = function() {
          return this.$d.toUTCString();
        }, M2;
      }(), k = _2.prototype;
      return O.prototype = k, [["$ms", r], ["$s", i2], ["$m", s], ["$H", u], ["$W", a], ["$M", c2], ["$y", h], ["$D", d]].forEach(function(t4) {
        k[t4[1]] = function(e3) {
          return this.$g(e3, t4[0], t4[1]);
        };
      }), O.extend = function(t4, e3) {
        return t4.$i || (t4(e3, _2, O), t4.$i = true), O;
      }, O.locale = w2, O.isDayjs = S2, O.unix = function(t4) {
        return O(1e3 * t4);
      }, O.en = D2[g], O.Ls = D2, O.p = {}, O;
    });
  })(dayjs_min);
  var dayjs_minExports = dayjs_min.exports;
  const dayjs = /* @__PURE__ */ getDefaultExportFromCjs(dayjs_minExports);
  const LEVELS = {
    trace: 0,
    debug: 1,
    info: 2,
    warn: 3,
    error: 4,
    fatal: 5
  };
  const log$1 = {
    trace: (..._args) => {
    },
    debug: (..._args) => {
    },
    info: (..._args) => {
    },
    warn: (..._args) => {
    },
    error: (..._args) => {
    },
    fatal: (..._args) => {
    }
  };
  const setLogLevel$1 = function(level = "fatal") {
    let numericLevel = LEVELS.fatal;
    if (typeof level === "string") {
      level = level.toLowerCase();
      if (level in LEVELS) {
        numericLevel = LEVELS[level];
      }
    } else if (typeof level === "number") {
      numericLevel = level;
    }
    log$1.trace = () => {
    };
    log$1.debug = () => {
    };
    log$1.info = () => {
    };
    log$1.warn = () => {
    };
    log$1.error = () => {
    };
    log$1.fatal = () => {
    };
    if (numericLevel <= LEVELS.fatal) {
      log$1.fatal = console.error ? console.error.bind(console, format$1("FATAL"), "color: orange") : console.log.bind(console, "\x1B[35m", format$1("FATAL"));
    }
    if (numericLevel <= LEVELS.error) {
      log$1.error = console.error ? console.error.bind(console, format$1("ERROR"), "color: orange") : console.log.bind(console, "\x1B[31m", format$1("ERROR"));
    }
    if (numericLevel <= LEVELS.warn) {
      log$1.warn = console.warn ? console.warn.bind(console, format$1("WARN"), "color: orange") : console.log.bind(console, `\x1B[33m`, format$1("WARN"));
    }
    if (numericLevel <= LEVELS.info) {
      log$1.info = console.info ? console.info.bind(console, format$1("INFO"), "color: lightblue") : console.log.bind(console, "\x1B[34m", format$1("INFO"));
    }
    if (numericLevel <= LEVELS.debug) {
      log$1.debug = console.debug ? console.debug.bind(console, format$1("DEBUG"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("DEBUG"));
    }
    if (numericLevel <= LEVELS.trace) {
      log$1.trace = console.debug ? console.debug.bind(console, format$1("TRACE"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("TRACE"));
    }
  };
  const format$1 = (level) => {
    const time2 = dayjs().format("ss.SSS");
    return `%c${time2} : ${level} : `;
  };
  var dist = {};
  (function(exports2) {
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sanitizeUrl = exports2.BLANK_URL = void 0;
    var invalidProtocolRegex = /^([^\w]*)(javascript|data|vbscript)/im;
    var htmlEntitiesRegex = /&#(\w+)(^\w|;)?/g;
    var htmlCtrlEntityRegex = /&(newline|tab);/gi;
    var ctrlCharactersRegex = /[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim;
    var urlSchemeRegex = /^.+(:|&colon;)/gim;
    var relativeFirstCharacters = [".", "/"];
    exports2.BLANK_URL = "about:blank";
    function isRelativeUrlWithoutProtocol(url) {
      return relativeFirstCharacters.indexOf(url[0]) > -1;
    }
    function decodeHtmlCharacters(str2) {
      var removedNullByte = str2.replace(ctrlCharactersRegex, "");
      return removedNullByte.replace(htmlEntitiesRegex, function(match, dec) {
        return String.fromCharCode(dec);
      });
    }
    function sanitizeUrl(url) {
      if (!url) {
        return exports2.BLANK_URL;
      }
      var sanitizedUrl = decodeHtmlCharacters(url).replace(htmlCtrlEntityRegex, "").replace(ctrlCharactersRegex, "").trim();
      if (!sanitizedUrl) {
        return exports2.BLANK_URL;
      }
      if (isRelativeUrlWithoutProtocol(sanitizedUrl)) {
        return sanitizedUrl;
      }
      var urlSchemeParseResults = sanitizedUrl.match(urlSchemeRegex);
      if (!urlSchemeParseResults) {
        return sanitizedUrl;
      }
      var urlScheme = urlSchemeParseResults[0];
      if (invalidProtocolRegex.test(urlScheme)) {
        return exports2.BLANK_URL;
      }
      return sanitizedUrl;
    }
    exports2.sanitizeUrl = sanitizeUrl;
  })(dist);
  function ascending$1(a, b) {
    return a == null || b == null ? NaN : a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function descending$1(a, b) {
    return a == null || b == null ? NaN : b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function bisector(f2) {
    let compare1, compare2, delta;
    if (f2.length !== 2) {
      compare1 = ascending$1;
      compare2 = (d, x2) => ascending$1(f2(d), x2);
      delta = (d, x2) => f2(d) - x2;
    } else {
      compare1 = f2 === ascending$1 || f2 === descending$1 ? f2 : zero$1;
      compare2 = f2;
      delta = f2;
    }
    function left2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) < 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function right2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) <= 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function center2(a, x2, lo = 0, hi = a.length) {
      const i2 = left2(a, x2, lo, hi - 1);
      return i2 > lo && delta(a[i2 - 1], x2) > -delta(a[i2], x2) ? i2 - 1 : i2;
    }
    return { left: left2, center: center2, right: right2 };
  }
  function zero$1() {
    return 0;
  }
  function number$3(x2) {
    return x2 === null ? NaN : +x2;
  }
  const ascendingBisect = bisector(ascending$1);
  const bisectRight = ascendingBisect.right;
  bisector(number$3).center;
  const bisect = bisectRight;
  class InternMap extends Map {
    constructor(entries2, key = keyof) {
      super();
      Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key } });
      if (entries2 != null)
        for (const [key2, value2] of entries2)
          this.set(key2, value2);
    }
    get(key) {
      return super.get(intern_get(this, key));
    }
    has(key) {
      return super.has(intern_get(this, key));
    }
    set(key, value2) {
      return super.set(intern_set(this, key), value2);
    }
    delete(key) {
      return super.delete(intern_delete(this, key));
    }
  }
  function intern_get({ _intern, _key }, value2) {
    const key = _key(value2);
    return _intern.has(key) ? _intern.get(key) : value2;
  }
  function intern_set({ _intern, _key }, value2) {
    const key = _key(value2);
    if (_intern.has(key))
      return _intern.get(key);
    _intern.set(key, value2);
    return value2;
  }
  function intern_delete({ _intern, _key }, value2) {
    const key = _key(value2);
    if (_intern.has(key)) {
      value2 = _intern.get(key);
      _intern.delete(key);
    }
    return value2;
  }
  function keyof(value2) {
    return value2 !== null && typeof value2 === "object" ? value2.valueOf() : value2;
  }
  const e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
  function tickSpec(start2, stop, count) {
    const step = (stop - start2) / Math.max(0, count), power = Math.floor(Math.log10(step)), error = step / Math.pow(10, power), factor = error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1;
    let i1, i2, inc;
    if (power < 0) {
      inc = Math.pow(10, -power) / factor;
      i1 = Math.round(start2 * inc);
      i2 = Math.round(stop * inc);
      if (i1 / inc < start2)
        ++i1;
      if (i2 / inc > stop)
        --i2;
      inc = -inc;
    } else {
      inc = Math.pow(10, power) * factor;
      i1 = Math.round(start2 / inc);
      i2 = Math.round(stop / inc);
      if (i1 * inc < start2)
        ++i1;
      if (i2 * inc > stop)
        --i2;
    }
    if (i2 < i1 && 0.5 <= count && count < 2)
      return tickSpec(start2, stop, count * 2);
    return [i1, i2, inc];
  }
  function ticks(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    if (!(count > 0))
      return [];
    if (start2 === stop)
      return [start2];
    const reverse = stop < start2, [i1, i2, inc] = reverse ? tickSpec(stop, start2, count) : tickSpec(start2, stop, count);
    if (!(i2 >= i1))
      return [];
    const n = i2 - i1 + 1, ticks2 = new Array(n);
    if (reverse) {
      if (inc < 0)
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i2 - i3) / -inc;
      else
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i2 - i3) * inc;
    } else {
      if (inc < 0)
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i1 + i3) / -inc;
      else
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i1 + i3) * inc;
    }
    return ticks2;
  }
  function tickIncrement(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    return tickSpec(start2, stop, count)[2];
  }
  function tickStep(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    const reverse = stop < start2, inc = reverse ? tickIncrement(stop, start2, count) : tickIncrement(start2, stop, count);
    return (reverse ? -1 : 1) * (inc < 0 ? 1 / -inc : inc);
  }
  function max$3(values2, valueof) {
    let max2;
    if (valueof === void 0) {
      for (const value2 of values2) {
        if (value2 != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
          max2 = value2;
        }
      }
    } else {
      let index2 = -1;
      for (let value2 of values2) {
        if ((value2 = valueof(value2, ++index2, values2)) != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
          max2 = value2;
        }
      }
    }
    return max2;
  }
  function min$3(values2, valueof) {
    let min2;
    if (valueof === void 0) {
      for (const value2 of values2) {
        if (value2 != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
          min2 = value2;
        }
      }
    } else {
      let index2 = -1;
      for (let value2 of values2) {
        if ((value2 = valueof(value2, ++index2, values2)) != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
          min2 = value2;
        }
      }
    }
    return min2;
  }
  function range$2(start2, stop, step) {
    start2 = +start2, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start2, start2 = 0, 1) : n < 3 ? 1 : +step;
    var i2 = -1, n = Math.max(0, Math.ceil((stop - start2) / step)) | 0, range2 = new Array(n);
    while (++i2 < n) {
      range2[i2] = start2 + i2 * step;
    }
    return range2;
  }
  function identity$5(x2) {
    return x2;
  }
  var top = 1, right$1 = 2, bottom = 3, left$1 = 4, epsilon$3 = 1e-6;
  function translateX(x2) {
    return "translate(" + x2 + ",0)";
  }
  function translateY(y2) {
    return "translate(0," + y2 + ")";
  }
  function number$2(scale) {
    return (d) => +scale(d);
  }
  function center$1(scale, offset) {
    offset = Math.max(0, scale.bandwidth() - offset * 2) / 2;
    if (scale.round())
      offset = Math.round(offset);
    return (d) => +scale(d) + offset;
  }
  function entering() {
    return !this.__axis;
  }
  function axis(orient, scale) {
    var tickArguments = [], tickValues = null, tickFormat2 = null, tickSizeInner = 6, tickSizeOuter = 6, tickPadding = 3, offset = typeof window !== "undefined" && window.devicePixelRatio > 1 ? 0 : 0.5, k = orient === top || orient === left$1 ? -1 : 1, x2 = orient === left$1 || orient === right$1 ? "x" : "y", transform = orient === top || orient === bottom ? translateX : translateY;
    function axis2(context) {
      var values2 = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues, format2 = tickFormat2 == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments) : identity$5 : tickFormat2, spacing2 = Math.max(tickSizeInner, 0) + tickPadding, range2 = scale.range(), range0 = +range2[0] + offset, range1 = +range2[range2.length - 1] + offset, position2 = (scale.bandwidth ? center$1 : number$2)(scale.copy(), offset), selection2 = context.selection ? context.selection() : context, path2 = selection2.selectAll(".domain").data([null]), tick = selection2.selectAll(".tick").data(values2, scale).order(), tickExit = tick.exit(), tickEnter = tick.enter().append("g").attr("class", "tick"), line2 = tick.select("line"), text2 = tick.select("text");
      path2 = path2.merge(path2.enter().insert("path", ".tick").attr("class", "domain").attr("stroke", "currentColor"));
      tick = tick.merge(tickEnter);
      line2 = line2.merge(tickEnter.append("line").attr("stroke", "currentColor").attr(x2 + "2", k * tickSizeInner));
      text2 = text2.merge(tickEnter.append("text").attr("fill", "currentColor").attr(x2, k * spacing2).attr("dy", orient === top ? "0em" : orient === bottom ? "0.71em" : "0.32em"));
      if (context !== selection2) {
        path2 = path2.transition(context);
        tick = tick.transition(context);
        line2 = line2.transition(context);
        text2 = text2.transition(context);
        tickExit = tickExit.transition(context).attr("opacity", epsilon$3).attr("transform", function(d) {
          return isFinite(d = position2(d)) ? transform(d + offset) : this.getAttribute("transform");
        });
        tickEnter.attr("opacity", epsilon$3).attr("transform", function(d) {
          var p = this.parentNode.__axis;
          return transform((p && isFinite(p = p(d)) ? p : position2(d)) + offset);
        });
      }
      tickExit.remove();
      path2.attr("d", orient === left$1 || orient === right$1 ? tickSizeOuter ? "M" + k * tickSizeOuter + "," + range0 + "H" + offset + "V" + range1 + "H" + k * tickSizeOuter : "M" + offset + "," + range0 + "V" + range1 : tickSizeOuter ? "M" + range0 + "," + k * tickSizeOuter + "V" + offset + "H" + range1 + "V" + k * tickSizeOuter : "M" + range0 + "," + offset + "H" + range1);
      tick.attr("opacity", 1).attr("transform", function(d) {
        return transform(position2(d) + offset);
      });
      line2.attr(x2 + "2", k * tickSizeInner);
      text2.attr(x2, k * spacing2).text(format2);
      selection2.filter(entering).attr("fill", "none").attr("font-size", 10).attr("font-family", "sans-serif").attr("text-anchor", orient === right$1 ? "start" : orient === left$1 ? "end" : "middle");
      selection2.each(function() {
        this.__axis = position2;
      });
    }
    axis2.scale = function(_2) {
      return arguments.length ? (scale = _2, axis2) : scale;
    };
    axis2.ticks = function() {
      return tickArguments = Array.from(arguments), axis2;
    };
    axis2.tickArguments = function(_2) {
      return arguments.length ? (tickArguments = _2 == null ? [] : Array.from(_2), axis2) : tickArguments.slice();
    };
    axis2.tickValues = function(_2) {
      return arguments.length ? (tickValues = _2 == null ? null : Array.from(_2), axis2) : tickValues && tickValues.slice();
    };
    axis2.tickFormat = function(_2) {
      return arguments.length ? (tickFormat2 = _2, axis2) : tickFormat2;
    };
    axis2.tickSize = function(_2) {
      return arguments.length ? (tickSizeInner = tickSizeOuter = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeInner = function(_2) {
      return arguments.length ? (tickSizeInner = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeOuter = function(_2) {
      return arguments.length ? (tickSizeOuter = +_2, axis2) : tickSizeOuter;
    };
    axis2.tickPadding = function(_2) {
      return arguments.length ? (tickPadding = +_2, axis2) : tickPadding;
    };
    axis2.offset = function(_2) {
      return arguments.length ? (offset = +_2, axis2) : offset;
    };
    return axis2;
  }
  function axisTop(scale) {
    return axis(top, scale);
  }
  function axisBottom(scale) {
    return axis(bottom, scale);
  }
  var noop$2 = { value: () => {
  } };
  function dispatch() {
    for (var i2 = 0, n = arguments.length, _2 = {}, t; i2 < n; ++i2) {
      if (!(t = arguments[i2] + "") || t in _2 || /[\s.]/.test(t))
        throw new Error("illegal type: " + t);
      _2[t] = [];
    }
    return new Dispatch(_2);
  }
  function Dispatch(_2) {
    this._ = _2;
  }
  function parseTypenames$1(typenames, types) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name = t.slice(i2 + 1), t = t.slice(0, i2);
      if (t && !types.hasOwnProperty(t))
        throw new Error("unknown type: " + t);
      return { type: t, name };
    });
  }
  Dispatch.prototype = dispatch.prototype = {
    constructor: Dispatch,
    on: function(typename, callback) {
      var _2 = this._, T2 = parseTypenames$1(typename + "", _2), t, i2 = -1, n = T2.length;
      if (arguments.length < 2) {
        while (++i2 < n)
          if ((t = (typename = T2[i2]).type) && (t = get$3(_2[t], typename.name)))
            return t;
        return;
      }
      if (callback != null && typeof callback !== "function")
        throw new Error("invalid callback: " + callback);
      while (++i2 < n) {
        if (t = (typename = T2[i2]).type)
          _2[t] = set$3(_2[t], typename.name, callback);
        else if (callback == null)
          for (t in _2)
            _2[t] = set$3(_2[t], typename.name, null);
      }
      return this;
    },
    copy: function() {
      var copy2 = {}, _2 = this._;
      for (var t in _2)
        copy2[t] = _2[t].slice();
      return new Dispatch(copy2);
    },
    call: function(type2, that) {
      if ((n = arguments.length - 2) > 0)
        for (var args = new Array(n), i2 = 0, n, t; i2 < n; ++i2)
          args[i2] = arguments[i2 + 2];
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    },
    apply: function(type2, that, args) {
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (var t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    }
  };
  function get$3(type2, name) {
    for (var i2 = 0, n = type2.length, c2; i2 < n; ++i2) {
      if ((c2 = type2[i2]).name === name) {
        return c2.value;
      }
    }
  }
  function set$3(type2, name, callback) {
    for (var i2 = 0, n = type2.length; i2 < n; ++i2) {
      if (type2[i2].name === name) {
        type2[i2] = noop$2, type2 = type2.slice(0, i2).concat(type2.slice(i2 + 1));
        break;
      }
    }
    if (callback != null)
      type2.push({ name, value: callback });
    return type2;
  }
  var xhtml = "http://www.w3.org/1999/xhtml";
  const namespaces$1 = {
    svg: "http://www.w3.org/2000/svg",
    xhtml,
    xlink: "http://www.w3.org/1999/xlink",
    xml: "http://www.w3.org/XML/1998/namespace",
    xmlns: "http://www.w3.org/2000/xmlns/"
  };
  function namespace(name) {
    var prefix = name += "", i2 = prefix.indexOf(":");
    if (i2 >= 0 && (prefix = name.slice(0, i2)) !== "xmlns")
      name = name.slice(i2 + 1);
    return namespaces$1.hasOwnProperty(prefix) ? { space: namespaces$1[prefix], local: name } : name;
  }
  function creatorInherit(name) {
    return function() {
      var document2 = this.ownerDocument, uri = this.namespaceURI;
      return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name) : document2.createElementNS(uri, name);
    };
  }
  function creatorFixed(fullname) {
    return function() {
      return this.ownerDocument.createElementNS(fullname.space, fullname.local);
    };
  }
  function creator(name) {
    var fullname = namespace(name);
    return (fullname.local ? creatorFixed : creatorInherit)(fullname);
  }
  function none() {
  }
  function selector(selector2) {
    return selector2 == null ? none : function() {
      return this.querySelector(selector2);
    };
  }
  function selection_select(select) {
    if (typeof select !== "function")
      select = selector(select);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function array$1(x2) {
    return x2 == null ? [] : Array.isArray(x2) ? x2 : Array.from(x2);
  }
  function empty() {
    return [];
  }
  function selectorAll(selector2) {
    return selector2 == null ? empty : function() {
      return this.querySelectorAll(selector2);
    };
  }
  function arrayAll(select) {
    return function() {
      return array$1(select.apply(this, arguments));
    };
  }
  function selection_selectAll(select) {
    if (typeof select === "function")
      select = arrayAll(select);
    else
      select = selectorAll(select);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          subgroups.push(select.call(node2, node2.__data__, i2, group));
          parents2.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, parents2);
  }
  function matcher(selector2) {
    return function() {
      return this.matches(selector2);
    };
  }
  function childMatcher(selector2) {
    return function(node2) {
      return node2.matches(selector2);
    };
  }
  var find$3 = Array.prototype.find;
  function childFind(match) {
    return function() {
      return find$3.call(this.children, match);
    };
  }
  function childFirst() {
    return this.firstElementChild;
  }
  function selection_selectChild(match) {
    return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
  }
  var filter$1 = Array.prototype.filter;
  function children() {
    return Array.from(this.children);
  }
  function childrenFilter(match) {
    return function() {
      return filter$1.call(this.children, match);
    };
  }
  function selection_selectChildren(match) {
    return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
  }
  function selection_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function sparse(update2) {
    return new Array(update2.length);
  }
  function selection_enter() {
    return new Selection$1(this._enter || this._groups.map(sparse), this._parents);
  }
  function EnterNode(parent, datum2) {
    this.ownerDocument = parent.ownerDocument;
    this.namespaceURI = parent.namespaceURI;
    this._next = null;
    this._parent = parent;
    this.__data__ = datum2;
  }
  EnterNode.prototype = {
    constructor: EnterNode,
    appendChild: function(child) {
      return this._parent.insertBefore(child, this._next);
    },
    insertBefore: function(child, next2) {
      return this._parent.insertBefore(child, next2);
    },
    querySelector: function(selector2) {
      return this._parent.querySelector(selector2);
    },
    querySelectorAll: function(selector2) {
      return this._parent.querySelectorAll(selector2);
    }
  };
  function constant$5(x2) {
    return function() {
      return x2;
    };
  }
  function bindIndex(parent, group, enter2, update2, exit2, data) {
    var i2 = 0, node2, groupLength2 = group.length, dataLength = data.length;
    for (; i2 < dataLength; ++i2) {
      if (node2 = group[i2]) {
        node2.__data__ = data[i2];
        update2[i2] = node2;
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (; i2 < groupLength2; ++i2) {
      if (node2 = group[i2]) {
        exit2[i2] = node2;
      }
    }
  }
  function bindKey(parent, group, enter2, update2, exit2, data, key) {
    var i2, node2, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength2 = group.length, dataLength = data.length, keyValues = new Array(groupLength2), keyValue;
    for (i2 = 0; i2 < groupLength2; ++i2) {
      if (node2 = group[i2]) {
        keyValues[i2] = keyValue = key.call(node2, node2.__data__, i2, group) + "";
        if (nodeByKeyValue.has(keyValue)) {
          exit2[i2] = node2;
        } else {
          nodeByKeyValue.set(keyValue, node2);
        }
      }
    }
    for (i2 = 0; i2 < dataLength; ++i2) {
      keyValue = key.call(parent, data[i2], i2, data) + "";
      if (node2 = nodeByKeyValue.get(keyValue)) {
        update2[i2] = node2;
        node2.__data__ = data[i2];
        nodeByKeyValue.delete(keyValue);
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (i2 = 0; i2 < groupLength2; ++i2) {
      if ((node2 = group[i2]) && nodeByKeyValue.get(keyValues[i2]) === node2) {
        exit2[i2] = node2;
      }
    }
  }
  function datum(node2) {
    return node2.__data__;
  }
  function selection_data(value2, key) {
    if (!arguments.length)
      return Array.from(this, datum);
    var bind = key ? bindKey : bindIndex, parents2 = this._parents, groups = this._groups;
    if (typeof value2 !== "function")
      value2 = constant$5(value2);
    for (var m = groups.length, update2 = new Array(m), enter2 = new Array(m), exit2 = new Array(m), j = 0; j < m; ++j) {
      var parent = parents2[j], group = groups[j], groupLength2 = group.length, data = arraylike(value2.call(parent, parent && parent.__data__, j, parents2)), dataLength = data.length, enterGroup = enter2[j] = new Array(dataLength), updateGroup = update2[j] = new Array(dataLength), exitGroup = exit2[j] = new Array(groupLength2);
      bind(parent, group, enterGroup, updateGroup, exitGroup, data, key);
      for (var i0 = 0, i1 = 0, previous2, next2; i0 < dataLength; ++i0) {
        if (previous2 = enterGroup[i0]) {
          if (i0 >= i1)
            i1 = i0 + 1;
          while (!(next2 = updateGroup[i1]) && ++i1 < dataLength)
            ;
          previous2._next = next2 || null;
        }
      }
    }
    update2 = new Selection$1(update2, parents2);
    update2._enter = enter2;
    update2._exit = exit2;
    return update2;
  }
  function arraylike(data) {
    return typeof data === "object" && "length" in data ? data : Array.from(data);
  }
  function selection_exit() {
    return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
  }
  function selection_join(onenter, onupdate, onexit) {
    var enter2 = this.enter(), update2 = this, exit2 = this.exit();
    if (typeof onenter === "function") {
      enter2 = onenter(enter2);
      if (enter2)
        enter2 = enter2.selection();
    } else {
      enter2 = enter2.append(onenter + "");
    }
    if (onupdate != null) {
      update2 = onupdate(update2);
      if (update2)
        update2 = update2.selection();
    }
    if (onexit == null)
      exit2.remove();
    else
      onexit(exit2);
    return enter2 && update2 ? enter2.merge(update2).order() : update2;
  }
  function selection_merge(context) {
    var selection2 = context.selection ? context.selection() : context;
    for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Selection$1(merges, this._parents);
  }
  function selection_order() {
    for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
      for (var group = groups[j], i2 = group.length - 1, next2 = group[i2], node2; --i2 >= 0; ) {
        if (node2 = group[i2]) {
          if (next2 && node2.compareDocumentPosition(next2) ^ 4)
            next2.parentNode.insertBefore(node2, next2);
          next2 = node2;
        }
      }
    }
    return this;
  }
  function selection_sort(compare) {
    if (!compare)
      compare = ascending;
    function compareNode(a, b) {
      return a && b ? compare(a.__data__, b.__data__) : !a - !b;
    }
    for (var groups = this._groups, m = groups.length, sortgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, sortgroup = sortgroups[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          sortgroup[i2] = node2;
        }
      }
      sortgroup.sort(compareNode);
    }
    return new Selection$1(sortgroups, this._parents).order();
  }
  function ascending(a, b) {
    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function selection_call() {
    var callback = arguments[0];
    arguments[0] = this;
    callback.apply(null, arguments);
    return this;
  }
  function selection_nodes() {
    return Array.from(this);
  }
  function selection_node() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length; i2 < n; ++i2) {
        var node2 = group[i2];
        if (node2)
          return node2;
      }
    }
    return null;
  }
  function selection_size() {
    let size2 = 0;
    for (const node2 of this)
      ++size2;
    return size2;
  }
  function selection_empty() {
    return !this.node();
  }
  function selection_each(callback) {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          callback.call(node2, node2.__data__, i2, group);
      }
    }
    return this;
  }
  function attrRemove$1(name) {
    return function() {
      this.removeAttribute(name);
    };
  }
  function attrRemoveNS$1(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant$1(name, value2) {
    return function() {
      this.setAttribute(name, value2);
    };
  }
  function attrConstantNS$1(fullname, value2) {
    return function() {
      this.setAttributeNS(fullname.space, fullname.local, value2);
    };
  }
  function attrFunction$1(name, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.removeAttribute(name);
      else
        this.setAttribute(name, v);
    };
  }
  function attrFunctionNS$1(fullname, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.removeAttributeNS(fullname.space, fullname.local);
      else
        this.setAttributeNS(fullname.space, fullname.local, v);
    };
  }
  function selection_attr(name, value2) {
    var fullname = namespace(name);
    if (arguments.length < 2) {
      var node2 = this.node();
      return fullname.local ? node2.getAttributeNS(fullname.space, fullname.local) : node2.getAttribute(fullname);
    }
    return this.each((value2 == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value2 === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value2));
  }
  function defaultView(node2) {
    return node2.ownerDocument && node2.ownerDocument.defaultView || node2.document && node2 || node2.defaultView;
  }
  function styleRemove$1(name) {
    return function() {
      this.style.removeProperty(name);
    };
  }
  function styleConstant$1(name, value2, priority) {
    return function() {
      this.style.setProperty(name, value2, priority);
    };
  }
  function styleFunction$1(name, value2, priority) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.style.removeProperty(name);
      else
        this.style.setProperty(name, v, priority);
    };
  }
  function selection_style(name, value2, priority) {
    return arguments.length > 1 ? this.each((value2 == null ? styleRemove$1 : typeof value2 === "function" ? styleFunction$1 : styleConstant$1)(name, value2, priority == null ? "" : priority)) : styleValue(this.node(), name);
  }
  function styleValue(node2, name) {
    return node2.style.getPropertyValue(name) || defaultView(node2).getComputedStyle(node2, null).getPropertyValue(name);
  }
  function propertyRemove(name) {
    return function() {
      delete this[name];
    };
  }
  function propertyConstant(name, value2) {
    return function() {
      this[name] = value2;
    };
  }
  function propertyFunction(name, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        delete this[name];
      else
        this[name] = v;
    };
  }
  function selection_property(name, value2) {
    return arguments.length > 1 ? this.each((value2 == null ? propertyRemove : typeof value2 === "function" ? propertyFunction : propertyConstant)(name, value2)) : this.node()[name];
  }
  function classArray(string2) {
    return string2.trim().split(/^|\s+/);
  }
  function classList(node2) {
    return node2.classList || new ClassList(node2);
  }
  function ClassList(node2) {
    this._node = node2;
    this._names = classArray(node2.getAttribute("class") || "");
  }
  ClassList.prototype = {
    add: function(name) {
      var i2 = this._names.indexOf(name);
      if (i2 < 0) {
        this._names.push(name);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    remove: function(name) {
      var i2 = this._names.indexOf(name);
      if (i2 >= 0) {
        this._names.splice(i2, 1);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    contains: function(name) {
      return this._names.indexOf(name) >= 0;
    }
  };
  function classedAdd(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.add(names[i2]);
  }
  function classedRemove(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.remove(names[i2]);
  }
  function classedTrue(names) {
    return function() {
      classedAdd(this, names);
    };
  }
  function classedFalse(names) {
    return function() {
      classedRemove(this, names);
    };
  }
  function classedFunction(names, value2) {
    return function() {
      (value2.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
    };
  }
  function selection_classed(name, value2) {
    var names = classArray(name + "");
    if (arguments.length < 2) {
      var list2 = classList(this.node()), i2 = -1, n = names.length;
      while (++i2 < n)
        if (!list2.contains(names[i2]))
          return false;
      return true;
    }
    return this.each((typeof value2 === "function" ? classedFunction : value2 ? classedTrue : classedFalse)(names, value2));
  }
  function textRemove() {
    this.textContent = "";
  }
  function textConstant$1(value2) {
    return function() {
      this.textContent = value2;
    };
  }
  function textFunction$1(value2) {
    return function() {
      var v = value2.apply(this, arguments);
      this.textContent = v == null ? "" : v;
    };
  }
  function selection_text(value2) {
    return arguments.length ? this.each(value2 == null ? textRemove : (typeof value2 === "function" ? textFunction$1 : textConstant$1)(value2)) : this.node().textContent;
  }
  function htmlRemove() {
    this.innerHTML = "";
  }
  function htmlConstant(value2) {
    return function() {
      this.innerHTML = value2;
    };
  }
  function htmlFunction(value2) {
    return function() {
      var v = value2.apply(this, arguments);
      this.innerHTML = v == null ? "" : v;
    };
  }
  function selection_html(value2) {
    return arguments.length ? this.each(value2 == null ? htmlRemove : (typeof value2 === "function" ? htmlFunction : htmlConstant)(value2)) : this.node().innerHTML;
  }
  function raise() {
    if (this.nextSibling)
      this.parentNode.appendChild(this);
  }
  function selection_raise() {
    return this.each(raise);
  }
  function lower() {
    if (this.previousSibling)
      this.parentNode.insertBefore(this, this.parentNode.firstChild);
  }
  function selection_lower() {
    return this.each(lower);
  }
  function selection_append(name) {
    var create2 = typeof name === "function" ? name : creator(name);
    return this.select(function() {
      return this.appendChild(create2.apply(this, arguments));
    });
  }
  function constantNull() {
    return null;
  }
  function selection_insert(name, before) {
    var create2 = typeof name === "function" ? name : creator(name), select = before == null ? constantNull : typeof before === "function" ? before : selector(before);
    return this.select(function() {
      return this.insertBefore(create2.apply(this, arguments), select.apply(this, arguments) || null);
    });
  }
  function remove() {
    var parent = this.parentNode;
    if (parent)
      parent.removeChild(this);
  }
  function selection_remove() {
    return this.each(remove);
  }
  function selection_cloneShallow() {
    var clone2 = this.cloneNode(false), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_cloneDeep() {
    var clone2 = this.cloneNode(true), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_clone(deep) {
    return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
  }
  function selection_datum(value2) {
    return arguments.length ? this.property("__data__", value2) : this.node().__data__;
  }
  function contextListener(listener) {
    return function(event) {
      listener.call(this, event, this.__data__);
    };
  }
  function parseTypenames(typenames) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name = t.slice(i2 + 1), t = t.slice(0, i2);
      return { type: t, name };
    });
  }
  function onRemove(typename) {
    return function() {
      var on = this.__on;
      if (!on)
        return;
      for (var j = 0, i2 = -1, m = on.length, o; j < m; ++j) {
        if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
        } else {
          on[++i2] = o;
        }
      }
      if (++i2)
        on.length = i2;
      else
        delete this.__on;
    };
  }
  function onAdd(typename, value2, options2) {
    return function() {
      var on = this.__on, o, listener = contextListener(value2);
      if (on)
        for (var j = 0, m = on.length; j < m; ++j) {
          if ((o = on[j]).type === typename.type && o.name === typename.name) {
            this.removeEventListener(o.type, o.listener, o.options);
            this.addEventListener(o.type, o.listener = listener, o.options = options2);
            o.value = value2;
            return;
          }
        }
      this.addEventListener(typename.type, listener, options2);
      o = { type: typename.type, name: typename.name, value: value2, listener, options: options2 };
      if (!on)
        this.__on = [o];
      else
        on.push(o);
    };
  }
  function selection_on(typename, value2, options2) {
    var typenames = parseTypenames(typename + ""), i2, n = typenames.length, t;
    if (arguments.length < 2) {
      var on = this.node().__on;
      if (on)
        for (var j = 0, m = on.length, o; j < m; ++j) {
          for (i2 = 0, o = on[j]; i2 < n; ++i2) {
            if ((t = typenames[i2]).type === o.type && t.name === o.name) {
              return o.value;
            }
          }
        }
      return;
    }
    on = value2 ? onAdd : onRemove;
    for (i2 = 0; i2 < n; ++i2)
      this.each(on(typenames[i2], value2, options2));
    return this;
  }
  function dispatchEvent(node2, type2, params) {
    var window2 = defaultView(node2), event = window2.CustomEvent;
    if (typeof event === "function") {
      event = new event(type2, params);
    } else {
      event = window2.document.createEvent("Event");
      if (params)
        event.initEvent(type2, params.bubbles, params.cancelable), event.detail = params.detail;
      else
        event.initEvent(type2, false, false);
    }
    node2.dispatchEvent(event);
  }
  function dispatchConstant(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params);
    };
  }
  function dispatchFunction(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params.apply(this, arguments));
    };
  }
  function selection_dispatch(type2, params) {
    return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type2, params));
  }
  function* selection_iterator() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          yield node2;
      }
    }
  }
  var root$2 = [null];
  function Selection$1(groups, parents2) {
    this._groups = groups;
    this._parents = parents2;
  }
  function selection() {
    return new Selection$1([[document.documentElement]], root$2);
  }
  function selection_selection() {
    return this;
  }
  Selection$1.prototype = selection.prototype = {
    constructor: Selection$1,
    select: selection_select,
    selectAll: selection_selectAll,
    selectChild: selection_selectChild,
    selectChildren: selection_selectChildren,
    filter: selection_filter,
    data: selection_data,
    enter: selection_enter,
    exit: selection_exit,
    join: selection_join,
    merge: selection_merge,
    selection: selection_selection,
    order: selection_order,
    sort: selection_sort,
    call: selection_call,
    nodes: selection_nodes,
    node: selection_node,
    size: selection_size,
    empty: selection_empty,
    each: selection_each,
    attr: selection_attr,
    style: selection_style,
    property: selection_property,
    classed: selection_classed,
    text: selection_text,
    html: selection_html,
    raise: selection_raise,
    lower: selection_lower,
    append: selection_append,
    insert: selection_insert,
    remove: selection_remove,
    clone: selection_clone,
    datum: selection_datum,
    on: selection_on,
    dispatch: selection_dispatch,
    [Symbol.iterator]: selection_iterator
  };
  function d3select(selector2) {
    return typeof selector2 === "string" ? new Selection$1([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$1([[selector2]], root$2);
  }
  function selectAll(selector2) {
    return typeof selector2 === "string" ? new Selection$1([document.querySelectorAll(selector2)], [document.documentElement]) : new Selection$1([array$1(selector2)], root$2);
  }
  function define2(constructor, factory, prototype) {
    constructor.prototype = factory.prototype = prototype;
    prototype.constructor = constructor;
  }
  function extend$1(parent, definition2) {
    var prototype = Object.create(parent.prototype);
    for (var key in definition2)
      prototype[key] = definition2[key];
    return prototype;
  }
  function Color$2() {
  }
  var darker = 0.7;
  var brighter = 1 / darker;
  var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
  var named = {
    aliceblue: 15792383,
    antiquewhite: 16444375,
    aqua: 65535,
    aquamarine: 8388564,
    azure: 15794175,
    beige: 16119260,
    bisque: 16770244,
    black: 0,
    blanchedalmond: 16772045,
    blue: 255,
    blueviolet: 9055202,
    brown: 10824234,
    burlywood: 14596231,
    cadetblue: 6266528,
    chartreuse: 8388352,
    chocolate: 13789470,
    coral: 16744272,
    cornflowerblue: 6591981,
    cornsilk: 16775388,
    crimson: 14423100,
    cyan: 65535,
    darkblue: 139,
    darkcyan: 35723,
    darkgoldenrod: 12092939,
    darkgray: 11119017,
    darkgreen: 25600,
    darkgrey: 11119017,
    darkkhaki: 12433259,
    darkmagenta: 9109643,
    darkolivegreen: 5597999,
    darkorange: 16747520,
    darkorchid: 10040012,
    darkred: 9109504,
    darksalmon: 15308410,
    darkseagreen: 9419919,
    darkslateblue: 4734347,
    darkslategray: 3100495,
    darkslategrey: 3100495,
    darkturquoise: 52945,
    darkviolet: 9699539,
    deeppink: 16716947,
    deepskyblue: 49151,
    dimgray: 6908265,
    dimgrey: 6908265,
    dodgerblue: 2003199,
    firebrick: 11674146,
    floralwhite: 16775920,
    forestgreen: 2263842,
    fuchsia: 16711935,
    gainsboro: 14474460,
    ghostwhite: 16316671,
    gold: 16766720,
    goldenrod: 14329120,
    gray: 8421504,
    green: 32768,
    greenyellow: 11403055,
    grey: 8421504,
    honeydew: 15794160,
    hotpink: 16738740,
    indianred: 13458524,
    indigo: 4915330,
    ivory: 16777200,
    khaki: 15787660,
    lavender: 15132410,
    lavenderblush: 16773365,
    lawngreen: 8190976,
    lemonchiffon: 16775885,
    lightblue: 11393254,
    lightcoral: 15761536,
    lightcyan: 14745599,
    lightgoldenrodyellow: 16448210,
    lightgray: 13882323,
    lightgreen: 9498256,
    lightgrey: 13882323,
    lightpink: 16758465,
    lightsalmon: 16752762,
    lightseagreen: 2142890,
    lightskyblue: 8900346,
    lightslategray: 7833753,
    lightslategrey: 7833753,
    lightsteelblue: 11584734,
    lightyellow: 16777184,
    lime: 65280,
    limegreen: 3329330,
    linen: 16445670,
    magenta: 16711935,
    maroon: 8388608,
    mediumaquamarine: 6737322,
    mediumblue: 205,
    mediumorchid: 12211667,
    mediumpurple: 9662683,
    mediumseagreen: 3978097,
    mediumslateblue: 8087790,
    mediumspringgreen: 64154,
    mediumturquoise: 4772300,
    mediumvioletred: 13047173,
    midnightblue: 1644912,
    mintcream: 16121850,
    mistyrose: 16770273,
    moccasin: 16770229,
    navajowhite: 16768685,
    navy: 128,
    oldlace: 16643558,
    olive: 8421376,
    olivedrab: 7048739,
    orange: 16753920,
    orangered: 16729344,
    orchid: 14315734,
    palegoldenrod: 15657130,
    palegreen: 10025880,
    paleturquoise: 11529966,
    palevioletred: 14381203,
    papayawhip: 16773077,
    peachpuff: 16767673,
    peru: 13468991,
    pink: 16761035,
    plum: 14524637,
    powderblue: 11591910,
    purple: 8388736,
    rebeccapurple: 6697881,
    red: 16711680,
    rosybrown: 12357519,
    royalblue: 4286945,
    saddlebrown: 9127187,
    salmon: 16416882,
    sandybrown: 16032864,
    seagreen: 3050327,
    seashell: 16774638,
    sienna: 10506797,
    silver: 12632256,
    skyblue: 8900331,
    slateblue: 6970061,
    slategray: 7372944,
    slategrey: 7372944,
    snow: 16775930,
    springgreen: 65407,
    steelblue: 4620980,
    tan: 13808780,
    teal: 32896,
    thistle: 14204888,
    tomato: 16737095,
    turquoise: 4251856,
    violet: 15631086,
    wheat: 16113331,
    white: 16777215,
    whitesmoke: 16119285,
    yellow: 16776960,
    yellowgreen: 10145074
  };
  define2(Color$2, color, {
    copy(channels2) {
      return Object.assign(new this.constructor(), this, channels2);
    },
    displayable() {
      return this.rgb().displayable();
    },
    hex: color_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: color_formatHex,
    formatHex8: color_formatHex8,
    formatHsl: color_formatHsl,
    formatRgb: color_formatRgb,
    toString: color_formatRgb
  });
  function color_formatHex() {
    return this.rgb().formatHex();
  }
  function color_formatHex8() {
    return this.rgb().formatHex8();
  }
  function color_formatHsl() {
    return hslConvert(this).formatHsl();
  }
  function color_formatRgb() {
    return this.rgb().formatRgb();
  }
  function color(format2) {
    var m, l;
    format2 = (format2 + "").trim().toLowerCase();
    return (m = reHex.exec(format2)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) : l === 3 ? new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, (m & 15) << 4 | m & 15, 1) : l === 8 ? rgba$2(m >> 24 & 255, m >> 16 & 255, m >> 8 & 255, (m & 255) / 255) : l === 4 ? rgba$2(m >> 12 & 15 | m >> 8 & 240, m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, ((m & 15) << 4 | m & 15) / 255) : null) : (m = reRgbInteger.exec(format2)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format2)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) : (m = reRgbaInteger.exec(format2)) ? rgba$2(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format2)) ? rgba$2(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) : (m = reHslPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
  }
  function rgbn(n) {
    return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
  }
  function rgba$2(r, g, b, a) {
    if (a <= 0)
      r = g = b = NaN;
    return new Rgb(r, g, b, a);
  }
  function rgbConvert(o) {
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Rgb();
    o = o.rgb();
    return new Rgb(o.r, o.g, o.b, o.opacity);
  }
  function rgb(r, g, b, opacity) {
    return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
  }
  function Rgb(r, g, b, opacity) {
    this.r = +r;
    this.g = +g;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Rgb, rgb, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    rgb() {
      return this;
    },
    clamp() {
      return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
    },
    displayable() {
      return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
    },
    hex: rgb_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: rgb_formatHex,
    formatHex8: rgb_formatHex8,
    formatRgb: rgb_formatRgb,
    toString: rgb_formatRgb
  }));
  function rgb_formatHex() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
  }
  function rgb_formatHex8() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
  }
  function rgb_formatRgb() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
  }
  function clampa(opacity) {
    return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
  }
  function clampi(value2) {
    return Math.max(0, Math.min(255, Math.round(value2) || 0));
  }
  function hex(value2) {
    value2 = clampi(value2);
    return (value2 < 16 ? "0" : "") + value2.toString(16);
  }
  function hsla(h, s, l, a) {
    if (a <= 0)
      h = s = l = NaN;
    else if (l <= 0 || l >= 1)
      h = s = NaN;
    else if (s <= 0)
      h = NaN;
    return new Hsl(h, s, l, a);
  }
  function hslConvert(o) {
    if (o instanceof Hsl)
      return new Hsl(o.h, o.s, o.l, o.opacity);
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Hsl();
    if (o instanceof Hsl)
      return o;
    o = o.rgb();
    var r = o.r / 255, g = o.g / 255, b = o.b / 255, min2 = Math.min(r, g, b), max2 = Math.max(r, g, b), h = NaN, s = max2 - min2, l = (max2 + min2) / 2;
    if (s) {
      if (r === max2)
        h = (g - b) / s + (g < b) * 6;
      else if (g === max2)
        h = (b - r) / s + 2;
      else
        h = (r - g) / s + 4;
      s /= l < 0.5 ? max2 + min2 : 2 - max2 - min2;
      h *= 60;
    } else {
      s = l > 0 && l < 1 ? 0 : h;
    }
    return new Hsl(h, s, l, o.opacity);
  }
  function hsl(h, s, l, opacity) {
    return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
  }
  function Hsl(h, s, l, opacity) {
    this.h = +h;
    this.s = +s;
    this.l = +l;
    this.opacity = +opacity;
  }
  define2(Hsl, hsl, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    rgb() {
      var h = this.h % 360 + (this.h < 0) * 360, s = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
      return new Rgb(
        hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
        hsl2rgb(h, m1, m2),
        hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
        this.opacity
      );
    },
    clamp() {
      return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
    },
    displayable() {
      return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
    },
    formatHsl() {
      const a = clampa(this.opacity);
      return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
    }
  }));
  function clamph(value2) {
    value2 = (value2 || 0) % 360;
    return value2 < 0 ? value2 + 360 : value2;
  }
  function clampt(value2) {
    return Math.max(0, Math.min(1, value2 || 0));
  }
  function hsl2rgb(h, m1, m2) {
    return (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1) * 255;
  }
  const radians = Math.PI / 180;
  const degrees$1 = 180 / Math.PI;
  const K = 18, Xn = 0.96422, Yn = 1, Zn = 0.82521, t0$1 = 4 / 29, t1$1 = 6 / 29, t2 = 3 * t1$1 * t1$1, t3 = t1$1 * t1$1 * t1$1;
  function labConvert(o) {
    if (o instanceof Lab)
      return new Lab(o.l, o.a, o.b, o.opacity);
    if (o instanceof Hcl)
      return hcl2lab(o);
    if (!(o instanceof Rgb))
      o = rgbConvert(o);
    var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b = rgb2lrgb(o.b), y2 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x2, z;
    if (r === g && g === b)
      x2 = z = y2;
    else {
      x2 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
      z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
    }
    return new Lab(116 * y2 - 16, 500 * (x2 - y2), 200 * (y2 - z), o.opacity);
  }
  function lab(l, a, b, opacity) {
    return arguments.length === 1 ? labConvert(l) : new Lab(l, a, b, opacity == null ? 1 : opacity);
  }
  function Lab(l, a, b, opacity) {
    this.l = +l;
    this.a = +a;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Lab, lab, extend$1(Color$2, {
    brighter(k) {
      return new Lab(this.l + K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    darker(k) {
      return new Lab(this.l - K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    rgb() {
      var y2 = (this.l + 16) / 116, x2 = isNaN(this.a) ? y2 : y2 + this.a / 500, z = isNaN(this.b) ? y2 : y2 - this.b / 200;
      x2 = Xn * lab2xyz(x2);
      y2 = Yn * lab2xyz(y2);
      z = Zn * lab2xyz(z);
      return new Rgb(
        lrgb2rgb(3.1338561 * x2 - 1.6168667 * y2 - 0.4906146 * z),
        lrgb2rgb(-0.9787684 * x2 + 1.9161415 * y2 + 0.033454 * z),
        lrgb2rgb(0.0719453 * x2 - 0.2289914 * y2 + 1.4052427 * z),
        this.opacity
      );
    }
  }));
  function xyz2lab(t) {
    return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0$1;
  }
  function lab2xyz(t) {
    return t > t1$1 ? t * t * t : t2 * (t - t0$1);
  }
  function lrgb2rgb(x2) {
    return 255 * (x2 <= 31308e-7 ? 12.92 * x2 : 1.055 * Math.pow(x2, 1 / 2.4) - 0.055);
  }
  function rgb2lrgb(x2) {
    return (x2 /= 255) <= 0.04045 ? x2 / 12.92 : Math.pow((x2 + 0.055) / 1.055, 2.4);
  }
  function hclConvert(o) {
    if (o instanceof Hcl)
      return new Hcl(o.h, o.c, o.l, o.opacity);
    if (!(o instanceof Lab))
      o = labConvert(o);
    if (o.a === 0 && o.b === 0)
      return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
    var h = Math.atan2(o.b, o.a) * degrees$1;
    return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
  }
  function hcl$1(h, c2, l, opacity) {
    return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c2, l, opacity == null ? 1 : opacity);
  }
  function Hcl(h, c2, l, opacity) {
    this.h = +h;
    this.c = +c2;
    this.l = +l;
    this.opacity = +opacity;
  }
  function hcl2lab(o) {
    if (isNaN(o.h))
      return new Lab(o.l, 0, 0, o.opacity);
    var h = o.h * radians;
    return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
  }
  define2(Hcl, hcl$1, extend$1(Color$2, {
    brighter(k) {
      return new Hcl(this.h, this.c, this.l + K * (k == null ? 1 : k), this.opacity);
    },
    darker(k) {
      return new Hcl(this.h, this.c, this.l - K * (k == null ? 1 : k), this.opacity);
    },
    rgb() {
      return hcl2lab(this).rgb();
    }
  }));
  const constant$4 = (x2) => () => x2;
  function linear$1(a, d) {
    return function(t) {
      return a + t * d;
    };
  }
  function exponential(a, b, y2) {
    return a = Math.pow(a, y2), b = Math.pow(b, y2) - a, y2 = 1 / y2, function(t) {
      return Math.pow(a + t * b, y2);
    };
  }
  function hue(a, b) {
    var d = b - a;
    return d ? linear$1(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant$4(isNaN(a) ? b : a);
  }
  function gamma(y2) {
    return (y2 = +y2) === 1 ? nogamma : function(a, b) {
      return b - a ? exponential(a, b, y2) : constant$4(isNaN(a) ? b : a);
    };
  }
  function nogamma(a, b) {
    var d = b - a;
    return d ? linear$1(a, d) : constant$4(isNaN(a) ? b : a);
  }
  const interpolateRgb = function rgbGamma(y2) {
    var color2 = gamma(y2);
    function rgb$1(start2, end2) {
      var r = color2((start2 = rgb(start2)).r, (end2 = rgb(end2)).r), g = color2(start2.g, end2.g), b = color2(start2.b, end2.b), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.r = r(t);
        start2.g = g(t);
        start2.b = b(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    }
    rgb$1.gamma = rgbGamma;
    return rgb$1;
  }(1);
  function numberArray(a, b) {
    if (!b)
      b = [];
    var n = a ? Math.min(b.length, a.length) : 0, c2 = b.slice(), i2;
    return function(t) {
      for (i2 = 0; i2 < n; ++i2)
        c2[i2] = a[i2] * (1 - t) + b[i2] * t;
      return c2;
    };
  }
  function isNumberArray(x2) {
    return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
  }
  function genericArray(a, b) {
    var nb = b ? b.length : 0, na = a ? Math.min(nb, a.length) : 0, x2 = new Array(na), c2 = new Array(nb), i2;
    for (i2 = 0; i2 < na; ++i2)
      x2[i2] = interpolate$1(a[i2], b[i2]);
    for (; i2 < nb; ++i2)
      c2[i2] = b[i2];
    return function(t) {
      for (i2 = 0; i2 < na; ++i2)
        c2[i2] = x2[i2](t);
      return c2;
    };
  }
  function date$1(a, b) {
    var d = /* @__PURE__ */ new Date();
    return a = +a, b = +b, function(t) {
      return d.setTime(a * (1 - t) + b * t), d;
    };
  }
  function interpolateNumber(a, b) {
    return a = +a, b = +b, function(t) {
      return a * (1 - t) + b * t;
    };
  }
  function object(a, b) {
    var i2 = {}, c2 = {}, k;
    if (a === null || typeof a !== "object")
      a = {};
    if (b === null || typeof b !== "object")
      b = {};
    for (k in b) {
      if (k in a) {
        i2[k] = interpolate$1(a[k], b[k]);
      } else {
        c2[k] = b[k];
      }
    }
    return function(t) {
      for (k in i2)
        c2[k] = i2[k](t);
      return c2;
    };
  }
  var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
  function zero(b) {
    return function() {
      return b;
    };
  }
  function one$1(b) {
    return function(t) {
      return b(t) + "";
    };
  }
  function interpolateString(a, b) {
    var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i2 = -1, s = [], q = [];
    a = a + "", b = b + "";
    while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
      if ((bs = bm.index) > bi) {
        bs = b.slice(bi, bs);
        if (s[i2])
          s[i2] += bs;
        else
          s[++i2] = bs;
      }
      if ((am = am[0]) === (bm = bm[0])) {
        if (s[i2])
          s[i2] += bm;
        else
          s[++i2] = bm;
      } else {
        s[++i2] = null;
        q.push({ i: i2, x: interpolateNumber(am, bm) });
      }
      bi = reB.lastIndex;
    }
    if (bi < b.length) {
      bs = b.slice(bi);
      if (s[i2])
        s[i2] += bs;
      else
        s[++i2] = bs;
    }
    return s.length < 2 ? q[0] ? one$1(q[0].x) : zero(b) : (b = q.length, function(t) {
      for (var i3 = 0, o; i3 < b; ++i3)
        s[(o = q[i3]).i] = o.x(t);
      return s.join("");
    });
  }
  function interpolate$1(a, b) {
    var t = typeof b, c2;
    return b == null || t === "boolean" ? constant$4(b) : (t === "number" ? interpolateNumber : t === "string" ? (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString : b instanceof color ? interpolateRgb : b instanceof Date ? date$1 : isNumberArray(b) ? numberArray : Array.isArray(b) ? genericArray : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object : interpolateNumber)(a, b);
  }
  function interpolateRound(a, b) {
    return a = +a, b = +b, function(t) {
      return Math.round(a * (1 - t) + b * t);
    };
  }
  var degrees = 180 / Math.PI;
  var identity$4 = {
    translateX: 0,
    translateY: 0,
    rotate: 0,
    skewX: 0,
    scaleX: 1,
    scaleY: 1
  };
  function decompose(a, b, c2, d, e, f2) {
    var scaleX, scaleY, skewX;
    if (scaleX = Math.sqrt(a * a + b * b))
      a /= scaleX, b /= scaleX;
    if (skewX = a * c2 + b * d)
      c2 -= a * skewX, d -= b * skewX;
    if (scaleY = Math.sqrt(c2 * c2 + d * d))
      c2 /= scaleY, d /= scaleY, skewX /= scaleY;
    if (a * d < b * c2)
      a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
    return {
      translateX: e,
      translateY: f2,
      rotate: Math.atan2(b, a) * degrees,
      skewX: Math.atan(skewX) * degrees,
      scaleX,
      scaleY
    };
  }
  var svgNode;
  function parseCss(value2) {
    const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value2 + "");
    return m.isIdentity ? identity$4 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
  }
  function parseSvg(value2) {
    if (value2 == null)
      return identity$4;
    if (!svgNode)
      svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
    svgNode.setAttribute("transform", value2);
    if (!(value2 = svgNode.transform.baseVal.consolidate()))
      return identity$4;
    value2 = value2.matrix;
    return decompose(value2.a, value2.b, value2.c, value2.d, value2.e, value2.f);
  }
  function interpolateTransform(parse2, pxComma, pxParen, degParen) {
    function pop(s) {
      return s.length ? s.pop() + " " : "";
    }
    function translate(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push("translate(", null, pxComma, null, pxParen);
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb || yb) {
        s.push("translate(" + xb + pxComma + yb + pxParen);
      }
    }
    function rotate(a, b, s, q) {
      if (a !== b) {
        if (a - b > 180)
          b += 360;
        else if (b - a > 180)
          a += 360;
        q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "rotate(" + b + degParen);
      }
    }
    function skewX(a, b, s, q) {
      if (a !== b) {
        q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "skewX(" + b + degParen);
      }
    }
    function scale(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push(pop(s) + "scale(", null, ",", null, ")");
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb !== 1 || yb !== 1) {
        s.push(pop(s) + "scale(" + xb + "," + yb + ")");
      }
    }
    return function(a, b) {
      var s = [], q = [];
      a = parse2(a), b = parse2(b);
      translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
      rotate(a.rotate, b.rotate, s, q);
      skewX(a.skewX, b.skewX, s, q);
      scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
      a = b = null;
      return function(t) {
        var i2 = -1, n = q.length, o;
        while (++i2 < n)
          s[(o = q[i2]).i] = o.x(t);
        return s.join("");
      };
    };
  }
  var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
  var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
  function hcl(hue2) {
    return function(start2, end2) {
      var h = hue2((start2 = hcl$1(start2)).h, (end2 = hcl$1(end2)).h), c2 = nogamma(start2.c, end2.c), l = nogamma(start2.l, end2.l), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.h = h(t);
        start2.c = c2(t);
        start2.l = l(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    };
  }
  const interpolateHcl = hcl(hue);
  var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f2) {
    setTimeout(f2, 17);
  };
  function now$2() {
    return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
  }
  function clearNow() {
    clockNow = 0;
  }
  function Timer() {
    this._call = this._time = this._next = null;
  }
  Timer.prototype = timer.prototype = {
    constructor: Timer,
    restart: function(callback, delay, time2) {
      if (typeof callback !== "function")
        throw new TypeError("callback is not a function");
      time2 = (time2 == null ? now$2() : +time2) + (delay == null ? 0 : +delay);
      if (!this._next && taskTail !== this) {
        if (taskTail)
          taskTail._next = this;
        else
          taskHead = this;
        taskTail = this;
      }
      this._call = callback;
      this._time = time2;
      sleep();
    },
    stop: function() {
      if (this._call) {
        this._call = null;
        this._time = Infinity;
        sleep();
      }
    }
  };
  function timer(callback, delay, time2) {
    var t = new Timer();
    t.restart(callback, delay, time2);
    return t;
  }
  function timerFlush() {
    now$2();
    ++frame;
    var t = taskHead, e;
    while (t) {
      if ((e = clockNow - t._time) >= 0)
        t._call.call(void 0, e);
      t = t._next;
    }
    --frame;
  }
  function wake() {
    clockNow = (clockLast = clock.now()) + clockSkew;
    frame = timeout$1 = 0;
    try {
      timerFlush();
    } finally {
      frame = 0;
      nap();
      clockNow = 0;
    }
  }
  function poke() {
    var now2 = clock.now(), delay = now2 - clockLast;
    if (delay > pokeDelay)
      clockSkew -= delay, clockLast = now2;
  }
  function nap() {
    var t02, t12 = taskHead, t22, time2 = Infinity;
    while (t12) {
      if (t12._call) {
        if (time2 > t12._time)
          time2 = t12._time;
        t02 = t12, t12 = t12._next;
      } else {
        t22 = t12._next, t12._next = null;
        t12 = t02 ? t02._next = t22 : taskHead = t22;
      }
    }
    taskTail = t02;
    sleep(time2);
  }
  function sleep(time2) {
    if (frame)
      return;
    if (timeout$1)
      timeout$1 = clearTimeout(timeout$1);
    var delay = time2 - clockNow;
    if (delay > 24) {
      if (time2 < Infinity)
        timeout$1 = setTimeout(wake, time2 - clock.now() - clockSkew);
      if (interval)
        interval = clearInterval(interval);
    } else {
      if (!interval)
        clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
      frame = 1, setFrame(wake);
    }
  }
  function timeout(callback, delay, time2) {
    var t = new Timer();
    delay = delay == null ? 0 : +delay;
    t.restart((elapsed) => {
      t.stop();
      callback(elapsed + delay);
    }, delay, time2);
    return t;
  }
  var emptyOn = dispatch("start", "end", "cancel", "interrupt");
  var emptyTween = [];
  var CREATED = 0;
  var SCHEDULED = 1;
  var STARTING = 2;
  var STARTED = 3;
  var RUNNING = 4;
  var ENDING = 5;
  var ENDED = 6;
  function schedule(node2, name, id2, index2, group, timing) {
    var schedules = node2.__transition;
    if (!schedules)
      node2.__transition = {};
    else if (id2 in schedules)
      return;
    create$1(node2, id2, {
      name,
      index: index2,
      // For context during callback.
      group,
      // For context during callback.
      on: emptyOn,
      tween: emptyTween,
      time: timing.time,
      delay: timing.delay,
      duration: timing.duration,
      ease: timing.ease,
      timer: null,
      state: CREATED
    });
  }
  function init$1(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > CREATED)
      throw new Error("too late; already scheduled");
    return schedule2;
  }
  function set$2(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > STARTED)
      throw new Error("too late; already running");
    return schedule2;
  }
  function get$2(node2, id2) {
    var schedule2 = node2.__transition;
    if (!schedule2 || !(schedule2 = schedule2[id2]))
      throw new Error("transition not found");
    return schedule2;
  }
  function create$1(node2, id2, self2) {
    var schedules = node2.__transition, tween;
    schedules[id2] = self2;
    self2.timer = timer(schedule2, 0, self2.time);
    function schedule2(elapsed) {
      self2.state = SCHEDULED;
      self2.timer.restart(start2, self2.delay, self2.time);
      if (self2.delay <= elapsed)
        start2(elapsed - self2.delay);
    }
    function start2(elapsed) {
      var i2, j, n, o;
      if (self2.state !== SCHEDULED)
        return stop();
      for (i2 in schedules) {
        o = schedules[i2];
        if (o.name !== self2.name)
          continue;
        if (o.state === STARTED)
          return timeout(start2);
        if (o.state === RUNNING) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("interrupt", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        } else if (+i2 < id2) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("cancel", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        }
      }
      timeout(function() {
        if (self2.state === STARTED) {
          self2.state = RUNNING;
          self2.timer.restart(tick, self2.delay, self2.time);
          tick(elapsed);
        }
      });
      self2.state = STARTING;
      self2.on.call("start", node2, node2.__data__, self2.index, self2.group);
      if (self2.state !== STARTING)
        return;
      self2.state = STARTED;
      tween = new Array(n = self2.tween.length);
      for (i2 = 0, j = -1; i2 < n; ++i2) {
        if (o = self2.tween[i2].value.call(node2, node2.__data__, self2.index, self2.group)) {
          tween[++j] = o;
        }
      }
      tween.length = j + 1;
    }
    function tick(elapsed) {
      var t = elapsed < self2.duration ? self2.ease.call(null, elapsed / self2.duration) : (self2.timer.restart(stop), self2.state = ENDING, 1), i2 = -1, n = tween.length;
      while (++i2 < n) {
        tween[i2].call(node2, t);
      }
      if (self2.state === ENDING) {
        self2.on.call("end", node2, node2.__data__, self2.index, self2.group);
        stop();
      }
    }
    function stop() {
      self2.state = ENDED;
      self2.timer.stop();
      delete schedules[id2];
      for (var i2 in schedules)
        return;
      delete node2.__transition;
    }
  }
  function interrupt(node2, name) {
    var schedules = node2.__transition, schedule2, active, empty2 = true, i2;
    if (!schedules)
      return;
    name = name == null ? null : name + "";
    for (i2 in schedules) {
      if ((schedule2 = schedules[i2]).name !== name) {
        empty2 = false;
        continue;
      }
      active = schedule2.state > STARTING && schedule2.state < ENDING;
      schedule2.state = ENDED;
      schedule2.timer.stop();
      schedule2.on.call(active ? "interrupt" : "cancel", node2, node2.__data__, schedule2.index, schedule2.group);
      delete schedules[i2];
    }
    if (empty2)
      delete node2.__transition;
  }
  function selection_interrupt(name) {
    return this.each(function() {
      interrupt(this, name);
    });
  }
  function tweenRemove(id2, name) {
    var tween0, tween1;
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = tween0 = tween;
        for (var i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name) {
            tween1 = tween1.slice();
            tween1.splice(i2, 1);
            break;
          }
        }
      }
      schedule2.tween = tween1;
    };
  }
  function tweenFunction(id2, name, value2) {
    var tween0, tween1;
    if (typeof value2 !== "function")
      throw new Error();
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = (tween0 = tween).slice();
        for (var t = { name, value: value2 }, i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name) {
            tween1[i2] = t;
            break;
          }
        }
        if (i2 === n)
          tween1.push(t);
      }
      schedule2.tween = tween1;
    };
  }
  function transition_tween(name, value2) {
    var id2 = this._id;
    name += "";
    if (arguments.length < 2) {
      var tween = get$2(this.node(), id2).tween;
      for (var i2 = 0, n = tween.length, t; i2 < n; ++i2) {
        if ((t = tween[i2]).name === name) {
          return t.value;
        }
      }
      return null;
    }
    return this.each((value2 == null ? tweenRemove : tweenFunction)(id2, name, value2));
  }
  function tweenValue(transition, name, value2) {
    var id2 = transition._id;
    transition.each(function() {
      var schedule2 = set$2(this, id2);
      (schedule2.value || (schedule2.value = {}))[name] = value2.apply(this, arguments);
    });
    return function(node2) {
      return get$2(node2, id2).value[name];
    };
  }
  function interpolate(a, b) {
    var c2;
    return (typeof b === "number" ? interpolateNumber : b instanceof color ? interpolateRgb : (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString)(a, b);
  }
  function attrRemove(name) {
    return function() {
      this.removeAttribute(name);
    };
  }
  function attrRemoveNS(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant(name, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttribute(name);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrConstantNS(fullname, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttributeNS(fullname.space, fullname.local);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrFunction(name, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value2(this), string1;
      if (value1 == null)
        return void this.removeAttribute(name);
      string0 = this.getAttribute(name);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function attrFunctionNS(fullname, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value2(this), string1;
      if (value1 == null)
        return void this.removeAttributeNS(fullname.space, fullname.local);
      string0 = this.getAttributeNS(fullname.space, fullname.local);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function transition_attr(name, value2) {
    var fullname = namespace(name), i2 = fullname === "transform" ? interpolateTransformSvg : interpolate;
    return this.attrTween(name, typeof value2 === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i2, tweenValue(this, "attr." + name, value2)) : value2 == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i2, value2));
  }
  function attrInterpolate(name, i2) {
    return function(t) {
      this.setAttribute(name, i2.call(this, t));
    };
  }
  function attrInterpolateNS(fullname, i2) {
    return function(t) {
      this.setAttributeNS(fullname.space, fullname.local, i2.call(this, t));
    };
  }
  function attrTweenNS(fullname, value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolateNS(fullname, i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function attrTween(name, value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolate(name, i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function transition_attrTween(name, value2) {
    var key = "attr." + name;
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    var fullname = namespace(name);
    return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value2));
  }
  function delayFunction(id2, value2) {
    return function() {
      init$1(this, id2).delay = +value2.apply(this, arguments);
    };
  }
  function delayConstant(id2, value2) {
    return value2 = +value2, function() {
      init$1(this, id2).delay = value2;
    };
  }
  function transition_delay(value2) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value2 === "function" ? delayFunction : delayConstant)(id2, value2)) : get$2(this.node(), id2).delay;
  }
  function durationFunction(id2, value2) {
    return function() {
      set$2(this, id2).duration = +value2.apply(this, arguments);
    };
  }
  function durationConstant(id2, value2) {
    return value2 = +value2, function() {
      set$2(this, id2).duration = value2;
    };
  }
  function transition_duration(value2) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value2 === "function" ? durationFunction : durationConstant)(id2, value2)) : get$2(this.node(), id2).duration;
  }
  function easeConstant(id2, value2) {
    if (typeof value2 !== "function")
      throw new Error();
    return function() {
      set$2(this, id2).ease = value2;
    };
  }
  function transition_ease(value2) {
    var id2 = this._id;
    return arguments.length ? this.each(easeConstant(id2, value2)) : get$2(this.node(), id2).ease;
  }
  function easeVarying(id2, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (typeof v !== "function")
        throw new Error();
      set$2(this, id2).ease = v;
    };
  }
  function transition_easeVarying(value2) {
    if (typeof value2 !== "function")
      throw new Error();
    return this.each(easeVarying(this._id, value2));
  }
  function transition_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Transition(subgroups, this._parents, this._name, this._id);
  }
  function transition_merge(transition) {
    if (transition._id !== this._id)
      throw new Error();
    for (var groups0 = this._groups, groups1 = transition._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Transition(merges, this._parents, this._name, this._id);
  }
  function start$1(name) {
    return (name + "").trim().split(/^|\s+/).every(function(t) {
      var i2 = t.indexOf(".");
      if (i2 >= 0)
        t = t.slice(0, i2);
      return !t || t === "start";
    });
  }
  function onFunction(id2, name, listener) {
    var on0, on1, sit = start$1(name) ? init$1 : set$2;
    return function() {
      var schedule2 = sit(this, id2), on = schedule2.on;
      if (on !== on0)
        (on1 = (on0 = on).copy()).on(name, listener);
      schedule2.on = on1;
    };
  }
  function transition_on(name, listener) {
    var id2 = this._id;
    return arguments.length < 2 ? get$2(this.node(), id2).on.on(name) : this.each(onFunction(id2, name, listener));
  }
  function removeFunction(id2) {
    return function() {
      var parent = this.parentNode;
      for (var i2 in this.__transition)
        if (+i2 !== id2)
          return;
      if (parent)
        parent.removeChild(this);
    };
  }
  function transition_remove() {
    return this.on("end.remove", removeFunction(this._id));
  }
  function transition_select(select) {
    var name = this._name, id2 = this._id;
    if (typeof select !== "function")
      select = selector(select);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
          schedule(subgroup[i2], name, id2, i2, subgroup, get$2(node2, id2));
        }
      }
    }
    return new Transition(subgroups, this._parents, name, id2);
  }
  function transition_selectAll(select) {
    var name = this._name, id2 = this._id;
    if (typeof select !== "function")
      select = selectorAll(select);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          for (var children2 = select.call(node2, node2.__data__, i2, group), child, inherit2 = get$2(node2, id2), k = 0, l = children2.length; k < l; ++k) {
            if (child = children2[k]) {
              schedule(child, name, id2, k, children2, inherit2);
            }
          }
          subgroups.push(children2);
          parents2.push(node2);
        }
      }
    }
    return new Transition(subgroups, parents2, name, id2);
  }
  var Selection = selection.prototype.constructor;
  function transition_selection() {
    return new Selection(this._groups, this._parents);
  }
  function styleNull(name, interpolate2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name), string1 = (this.style.removeProperty(name), styleValue(this, name));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
    };
  }
  function styleRemove(name) {
    return function() {
      this.style.removeProperty(name);
    };
  }
  function styleConstant(name, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = styleValue(this, name);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function styleFunction(name, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name), value1 = value2(this), string1 = value1 + "";
      if (value1 == null)
        string1 = value1 = (this.style.removeProperty(name), styleValue(this, name));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function styleMaybeRemove(id2, name) {
    var on0, on1, listener0, key = "style." + name, event = "end." + key, remove2;
    return function() {
      var schedule2 = set$2(this, id2), on = schedule2.on, listener = schedule2.value[key] == null ? remove2 || (remove2 = styleRemove(name)) : void 0;
      if (on !== on0 || listener0 !== listener)
        (on1 = (on0 = on).copy()).on(event, listener0 = listener);
      schedule2.on = on1;
    };
  }
  function transition_style(name, value2, priority) {
    var i2 = (name += "") === "transform" ? interpolateTransformCss : interpolate;
    return value2 == null ? this.styleTween(name, styleNull(name, i2)).on("end.style." + name, styleRemove(name)) : typeof value2 === "function" ? this.styleTween(name, styleFunction(name, i2, tweenValue(this, "style." + name, value2))).each(styleMaybeRemove(this._id, name)) : this.styleTween(name, styleConstant(name, i2, value2), priority).on("end.style." + name, null);
  }
  function styleInterpolate(name, i2, priority) {
    return function(t) {
      this.style.setProperty(name, i2.call(this, t), priority);
    };
  }
  function styleTween(name, value2, priority) {
    var t, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t = (i0 = i2) && styleInterpolate(name, i2, priority);
      return t;
    }
    tween._value = value2;
    return tween;
  }
  function transition_styleTween(name, value2, priority) {
    var key = "style." + (name += "");
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    return this.tween(key, styleTween(name, value2, priority == null ? "" : priority));
  }
  function textConstant(value2) {
    return function() {
      this.textContent = value2;
    };
  }
  function textFunction(value2) {
    return function() {
      var value1 = value2(this);
      this.textContent = value1 == null ? "" : value1;
    };
  }
  function transition_text(value2) {
    return this.tween("text", typeof value2 === "function" ? textFunction(tweenValue(this, "text", value2)) : textConstant(value2 == null ? "" : value2 + ""));
  }
  function textInterpolate(i2) {
    return function(t) {
      this.textContent = i2.call(this, t);
    };
  }
  function textTween(value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && textInterpolate(i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function transition_textTween(value2) {
    var key = "text";
    if (arguments.length < 1)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    return this.tween(key, textTween(value2));
  }
  function transition_transition() {
    var name = this._name, id0 = this._id, id1 = newId();
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          var inherit2 = get$2(node2, id0);
          schedule(node2, name, id1, i2, group, {
            time: inherit2.time + inherit2.delay + inherit2.duration,
            delay: 0,
            duration: inherit2.duration,
            ease: inherit2.ease
          });
        }
      }
    }
    return new Transition(groups, this._parents, name, id1);
  }
  function transition_end() {
    var on0, on1, that = this, id2 = that._id, size2 = that.size();
    return new Promise(function(resolve, reject) {
      var cancel = { value: reject }, end2 = { value: function() {
        if (--size2 === 0)
          resolve();
      } };
      that.each(function() {
        var schedule2 = set$2(this, id2), on = schedule2.on;
        if (on !== on0) {
          on1 = (on0 = on).copy();
          on1._.cancel.push(cancel);
          on1._.interrupt.push(cancel);
          on1._.end.push(end2);
        }
        schedule2.on = on1;
      });
      if (size2 === 0)
        resolve();
    });
  }
  var id$m = 0;
  function Transition(groups, parents2, name, id2) {
    this._groups = groups;
    this._parents = parents2;
    this._name = name;
    this._id = id2;
  }
  function newId() {
    return ++id$m;
  }
  var selection_prototype = selection.prototype;
  Transition.prototype = {
    constructor: Transition,
    select: transition_select,
    selectAll: transition_selectAll,
    selectChild: selection_prototype.selectChild,
    selectChildren: selection_prototype.selectChildren,
    filter: transition_filter,
    merge: transition_merge,
    selection: transition_selection,
    transition: transition_transition,
    call: selection_prototype.call,
    nodes: selection_prototype.nodes,
    node: selection_prototype.node,
    size: selection_prototype.size,
    empty: selection_prototype.empty,
    each: selection_prototype.each,
    on: transition_on,
    attr: transition_attr,
    attrTween: transition_attrTween,
    style: transition_style,
    styleTween: transition_styleTween,
    text: transition_text,
    textTween: transition_textTween,
    remove: transition_remove,
    tween: transition_tween,
    delay: transition_delay,
    duration: transition_duration,
    ease: transition_ease,
    easeVarying: transition_easeVarying,
    end: transition_end,
    [Symbol.iterator]: selection_prototype[Symbol.iterator]
  };
  function cubicInOut(t) {
    return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
  }
  var defaultTiming = {
    time: null,
    // Set on use.
    delay: 0,
    duration: 250,
    ease: cubicInOut
  };
  function inherit(node2, id2) {
    var timing;
    while (!(timing = node2.__transition) || !(timing = timing[id2])) {
      if (!(node2 = node2.parentNode)) {
        throw new Error(`transition ${id2} not found`);
      }
    }
    return timing;
  }
  function selection_transition(name) {
    var id2, timing;
    if (name instanceof Transition) {
      id2 = name._id, name = name._name;
    } else {
      id2 = newId(), (timing = defaultTiming).time = now$2(), name = name == null ? null : name + "";
    }
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          schedule(node2, name, id2, i2, group, timing || inherit(node2, id2));
        }
      }
    }
    return new Transition(groups, this._parents, name, id2);
  }
  selection.prototype.interrupt = selection_interrupt;
  selection.prototype.transition = selection_transition;
  const pi$2 = Math.PI, tau$2 = 2 * pi$2, epsilon$2 = 1e-6, tauEpsilon$1 = tau$2 - epsilon$2;
  function append$1(strings) {
    this._ += strings[0];
    for (let i2 = 1, n = strings.length; i2 < n; ++i2) {
      this._ += arguments[i2] + strings[i2];
    }
  }
  function appendRound(digits) {
    let d = Math.floor(digits);
    if (!(d >= 0))
      throw new Error(`invalid digits: ${digits}`);
    if (d > 15)
      return append$1;
    const k = 10 ** d;
    return function(strings) {
      this._ += strings[0];
      for (let i2 = 1, n = strings.length; i2 < n; ++i2) {
        this._ += Math.round(arguments[i2] * k) / k + strings[i2];
      }
    };
  }
  let Path$1 = class Path {
    constructor(digits) {
      this._x0 = this._y0 = // start of current subpath
      this._x1 = this._y1 = null;
      this._ = "";
      this._append = digits == null ? append$1 : appendRound(digits);
    }
    moveTo(x2, y2) {
      this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}`;
    }
    closePath() {
      if (this._x1 !== null) {
        this._x1 = this._x0, this._y1 = this._y0;
        this._append`Z`;
      }
    }
    lineTo(x2, y2) {
      this._append`L${this._x1 = +x2},${this._y1 = +y2}`;
    }
    quadraticCurveTo(x1, y1, x2, y2) {
      this._append`Q${+x1},${+y1},${this._x1 = +x2},${this._y1 = +y2}`;
    }
    bezierCurveTo(x1, y1, x2, y2, x3, y3) {
      this._append`C${+x1},${+y1},${+x2},${+y2},${this._x1 = +x3},${this._y1 = +y3}`;
    }
    arcTo(x1, y1, x2, y2, r) {
      x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
      if (r < 0)
        throw new Error(`negative radius: ${r}`);
      let x0 = this._x1, y0 = this._y1, x21 = x2 - x1, y21 = y2 - y1, x01 = x0 - x1, y01 = y0 - y1, l01_2 = x01 * x01 + y01 * y01;
      if (this._x1 === null) {
        this._append`M${this._x1 = x1},${this._y1 = y1}`;
      } else if (!(l01_2 > epsilon$2))
        ;
      else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$2) || !r) {
        this._append`L${this._x1 = x1},${this._y1 = y1}`;
      } else {
        let x20 = x2 - x0, y20 = y2 - y0, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi$2 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
        if (Math.abs(t01 - 1) > epsilon$2) {
          this._append`L${x1 + t01 * x01},${y1 + t01 * y01}`;
        }
        this._append`A${r},${r},0,0,${+(y01 * x20 > x01 * y20)},${this._x1 = x1 + t21 * x21},${this._y1 = y1 + t21 * y21}`;
      }
    }
    arc(x2, y2, r, a0, a1, ccw) {
      x2 = +x2, y2 = +y2, r = +r, ccw = !!ccw;
      if (r < 0)
        throw new Error(`negative radius: ${r}`);
      let dx = r * Math.cos(a0), dy = r * Math.sin(a0), x0 = x2 + dx, y0 = y2 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
      if (this._x1 === null) {
        this._append`M${x0},${y0}`;
      } else if (Math.abs(this._x1 - x0) > epsilon$2 || Math.abs(this._y1 - y0) > epsilon$2) {
        this._append`L${x0},${y0}`;
      }
      if (!r)
        return;
      if (da < 0)
        da = da % tau$2 + tau$2;
      if (da > tauEpsilon$1) {
        this._append`A${r},${r},0,1,${cw},${x2 - dx},${y2 - dy}A${r},${r},0,1,${cw},${this._x1 = x0},${this._y1 = y0}`;
      } else if (da > epsilon$2) {
        this._append`A${r},${r},0,${+(da >= pi$2)},${cw},${this._x1 = x2 + r * Math.cos(a1)},${this._y1 = y2 + r * Math.sin(a1)}`;
      }
    }
    rect(x2, y2, w2, h) {
      this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}h${w2 = +w2}v${+h}h${-w2}Z`;
    }
    toString() {
      return this._;
    }
  };
  function responseText(response) {
    if (!response.ok)
      throw new Error(response.status + " " + response.statusText);
    return response.text();
  }
  function text$4(input, init2) {
    return fetch(input, init2).then(responseText);
  }
  function parser$x(type2) {
    return (input, init2) => text$4(input, init2).then((text2) => new DOMParser().parseFromString(text2, type2));
  }
  var svg$2 = parser$x("image/svg+xml");
  function formatDecimal(x2) {
    return Math.abs(x2 = Math.round(x2)) >= 1e21 ? x2.toLocaleString("en").replace(/,/g, "") : x2.toString(10);
  }
  function formatDecimalParts(x2, p) {
    if ((i2 = (x2 = p ? x2.toExponential(p - 1) : x2.toExponential()).indexOf("e")) < 0)
      return null;
    var i2, coefficient = x2.slice(0, i2);
    return [
      coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
      +x2.slice(i2 + 1)
    ];
  }
  function exponent(x2) {
    return x2 = formatDecimalParts(Math.abs(x2)), x2 ? x2[1] : NaN;
  }
  function formatGroup(grouping, thousands) {
    return function(value2, width2) {
      var i2 = value2.length, t = [], j = 0, g = grouping[0], length2 = 0;
      while (i2 > 0 && g > 0) {
        if (length2 + g + 1 > width2)
          g = Math.max(1, width2 - length2);
        t.push(value2.substring(i2 -= g, i2 + g));
        if ((length2 += g + 1) > width2)
          break;
        g = grouping[j = (j + 1) % grouping.length];
      }
      return t.reverse().join(thousands);
    };
  }
  function formatNumerals(numerals) {
    return function(value2) {
      return value2.replace(/[0-9]/g, function(i2) {
        return numerals[+i2];
      });
    };
  }
  var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
  function formatSpecifier(specifier) {
    if (!(match = re.exec(specifier)))
      throw new Error("invalid format: " + specifier);
    var match;
    return new FormatSpecifier({
      fill: match[1],
      align: match[2],
      sign: match[3],
      symbol: match[4],
      zero: match[5],
      width: match[6],
      comma: match[7],
      precision: match[8] && match[8].slice(1),
      trim: match[9],
      type: match[10]
    });
  }
  formatSpecifier.prototype = FormatSpecifier.prototype;
  function FormatSpecifier(specifier) {
    this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
    this.align = specifier.align === void 0 ? ">" : specifier.align + "";
    this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
    this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
    this.zero = !!specifier.zero;
    this.width = specifier.width === void 0 ? void 0 : +specifier.width;
    this.comma = !!specifier.comma;
    this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
    this.trim = !!specifier.trim;
    this.type = specifier.type === void 0 ? "" : specifier.type + "";
  }
  FormatSpecifier.prototype.toString = function() {
    return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
  };
  function formatTrim(s) {
    out:
      for (var n = s.length, i2 = 1, i0 = -1, i1; i2 < n; ++i2) {
        switch (s[i2]) {
          case ".":
            i0 = i1 = i2;
            break;
          case "0":
            if (i0 === 0)
              i0 = i2;
            i1 = i2;
            break;
          default:
            if (!+s[i2])
              break out;
            if (i0 > 0)
              i0 = 0;
            break;
        }
      }
    return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
  }
  var prefixExponent;
  function formatPrefixAuto(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1], i2 = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
    return i2 === n ? coefficient : i2 > n ? coefficient + new Array(i2 - n + 1).join("0") : i2 > 0 ? coefficient.slice(0, i2) + "." + coefficient.slice(i2) : "0." + new Array(1 - i2).join("0") + formatDecimalParts(x2, Math.max(0, p + i2 - 1))[0];
  }
  function formatRounded(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1];
    return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
  }
  const formatTypes = {
    "%": (x2, p) => (x2 * 100).toFixed(p),
    "b": (x2) => Math.round(x2).toString(2),
    "c": (x2) => x2 + "",
    "d": formatDecimal,
    "e": (x2, p) => x2.toExponential(p),
    "f": (x2, p) => x2.toFixed(p),
    "g": (x2, p) => x2.toPrecision(p),
    "o": (x2) => Math.round(x2).toString(8),
    "p": (x2, p) => formatRounded(x2 * 100, p),
    "r": formatRounded,
    "s": formatPrefixAuto,
    "X": (x2) => Math.round(x2).toString(16).toUpperCase(),
    "x": (x2) => Math.round(x2).toString(16)
  };
  function identity$3(x2) {
    return x2;
  }
  var map$2 = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
  function formatLocale$1(locale2) {
    var group = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$3 : formatGroup(map$2.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$3 : formatNumerals(map$2.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "−" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
    function newFormat(specifier) {
      specifier = formatSpecifier(specifier);
      var fill = specifier.fill, align = specifier.align, sign2 = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width2 = specifier.width, comma = specifier.comma, precision = specifier.precision, trim2 = specifier.trim, type2 = specifier.type;
      if (type2 === "n")
        comma = true, type2 = "g";
      else if (!formatTypes[type2])
        precision === void 0 && (precision = 12), trim2 = true, type2 = "g";
      if (zero2 || fill === "0" && align === "=")
        zero2 = true, fill = "0", align = "=";
      var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
      var formatType = formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
      precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
      function format2(value2) {
        var valuePrefix = prefix, valueSuffix = suffix, i2, n, c2;
        if (type2 === "c") {
          valueSuffix = formatType(value2) + valueSuffix;
          value2 = "";
        } else {
          value2 = +value2;
          var valueNegative = value2 < 0 || 1 / value2 < 0;
          value2 = isNaN(value2) ? nan : formatType(Math.abs(value2), precision);
          if (trim2)
            value2 = formatTrim(value2);
          if (valueNegative && +value2 === 0 && sign2 !== "+")
            valueNegative = false;
          valuePrefix = (valueNegative ? sign2 === "(" ? sign2 : minus : sign2 === "-" || sign2 === "(" ? "" : sign2) + valuePrefix;
          valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign2 === "(" ? ")" : "");
          if (maybeSuffix) {
            i2 = -1, n = value2.length;
            while (++i2 < n) {
              if (c2 = value2.charCodeAt(i2), 48 > c2 || c2 > 57) {
                valueSuffix = (c2 === 46 ? decimal + value2.slice(i2 + 1) : value2.slice(i2)) + valueSuffix;
                value2 = value2.slice(0, i2);
                break;
              }
            }
          }
        }
        if (comma && !zero2)
          value2 = group(value2, Infinity);
        var length2 = valuePrefix.length + value2.length + valueSuffix.length, padding2 = length2 < width2 ? new Array(width2 - length2 + 1).join(fill) : "";
        if (comma && zero2)
          value2 = group(padding2 + value2, padding2.length ? width2 - valueSuffix.length : Infinity), padding2 = "";
        switch (align) {
          case "<":
            value2 = valuePrefix + value2 + valueSuffix + padding2;
            break;
          case "=":
            value2 = valuePrefix + padding2 + value2 + valueSuffix;
            break;
          case "^":
            value2 = padding2.slice(0, length2 = padding2.length >> 1) + valuePrefix + value2 + valueSuffix + padding2.slice(length2);
            break;
          default:
            value2 = padding2 + valuePrefix + value2 + valueSuffix;
            break;
        }
        return numerals(value2);
      }
      format2.toString = function() {
        return specifier + "";
      };
      return format2;
    }
    function formatPrefix2(specifier, value2) {
      var f2 = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
      return function(value3) {
        return f2(k * value3) + prefix;
      };
    }
    return {
      format: newFormat,
      formatPrefix: formatPrefix2
    };
  }
  var locale$1;
  var format;
  var formatPrefix;
  defaultLocale$1({
    thousands: ",",
    grouping: [3],
    currency: ["$", ""]
  });
  function defaultLocale$1(definition2) {
    locale$1 = formatLocale$1(definition2);
    format = locale$1.format;
    formatPrefix = locale$1.formatPrefix;
    return locale$1;
  }
  function precisionFixed(step) {
    return Math.max(0, -exponent(Math.abs(step)));
  }
  function precisionPrefix(step, value2) {
    return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3 - exponent(Math.abs(step)));
  }
  function precisionRound(step, max2) {
    step = Math.abs(step), max2 = Math.abs(max2) - step;
    return Math.max(0, exponent(max2) - exponent(step)) + 1;
  }
  function initRange(domain, range2) {
    switch (arguments.length) {
      case 0:
        break;
      case 1:
        this.range(domain);
        break;
      default:
        this.range(range2).domain(domain);
        break;
    }
    return this;
  }
  const implicit = Symbol("implicit");
  function ordinal() {
    var index2 = new InternMap(), domain = [], range2 = [], unknown = implicit;
    function scale(d) {
      let i2 = index2.get(d);
      if (i2 === void 0) {
        if (unknown !== implicit)
          return unknown;
        index2.set(d, i2 = domain.push(d) - 1);
      }
      return range2[i2 % range2.length];
    }
    scale.domain = function(_2) {
      if (!arguments.length)
        return domain.slice();
      domain = [], index2 = new InternMap();
      for (const value2 of _2) {
        if (index2.has(value2))
          continue;
        index2.set(value2, domain.push(value2) - 1);
      }
      return scale;
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), scale) : range2.slice();
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    scale.copy = function() {
      return ordinal(domain, range2).unknown(unknown);
    };
    initRange.apply(scale, arguments);
    return scale;
  }
  function band() {
    var scale = ordinal().unknown(void 0), domain = scale.domain, ordinalRange = scale.range, r0 = 0, r1 = 1, step, bandwidth, round = false, paddingInner = 0, paddingOuter = 0, align = 0.5;
    delete scale.unknown;
    function rescale() {
      var n = domain().length, reverse = r1 < r0, start2 = reverse ? r1 : r0, stop = reverse ? r0 : r1;
      step = (stop - start2) / Math.max(1, n - paddingInner + paddingOuter * 2);
      if (round)
        step = Math.floor(step);
      start2 += (stop - start2 - step * (n - paddingInner)) * align;
      bandwidth = step * (1 - paddingInner);
      if (round)
        start2 = Math.round(start2), bandwidth = Math.round(bandwidth);
      var values2 = range$2(n).map(function(i2) {
        return start2 + step * i2;
      });
      return ordinalRange(reverse ? values2.reverse() : values2);
    }
    scale.domain = function(_2) {
      return arguments.length ? (domain(_2), rescale()) : domain();
    };
    scale.range = function(_2) {
      return arguments.length ? ([r0, r1] = _2, r0 = +r0, r1 = +r1, rescale()) : [r0, r1];
    };
    scale.rangeRound = function(_2) {
      return [r0, r1] = _2, r0 = +r0, r1 = +r1, round = true, rescale();
    };
    scale.bandwidth = function() {
      return bandwidth;
    };
    scale.step = function() {
      return step;
    };
    scale.round = function(_2) {
      return arguments.length ? (round = !!_2, rescale()) : round;
    };
    scale.padding = function(_2) {
      return arguments.length ? (paddingInner = Math.min(1, paddingOuter = +_2), rescale()) : paddingInner;
    };
    scale.paddingInner = function(_2) {
      return arguments.length ? (paddingInner = Math.min(1, _2), rescale()) : paddingInner;
    };
    scale.paddingOuter = function(_2) {
      return arguments.length ? (paddingOuter = +_2, rescale()) : paddingOuter;
    };
    scale.align = function(_2) {
      return arguments.length ? (align = Math.max(0, Math.min(1, _2)), rescale()) : align;
    };
    scale.copy = function() {
      return band(domain(), [r0, r1]).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align);
    };
    return initRange.apply(rescale(), arguments);
  }
  function constants(x2) {
    return function() {
      return x2;
    };
  }
  function number$1(x2) {
    return +x2;
  }
  var unit$1 = [0, 1];
  function identity$2(x2) {
    return x2;
  }
  function normalize(a, b) {
    return (b -= a = +a) ? function(x2) {
      return (x2 - a) / b;
    } : constants(isNaN(b) ? NaN : 0.5);
  }
  function clamper(a, b) {
    var t;
    if (a > b)
      t = a, a = b, b = t;
    return function(x2) {
      return Math.max(a, Math.min(b, x2));
    };
  }
  function bimap(domain, range2, interpolate2) {
    var d0 = domain[0], d1 = domain[1], r0 = range2[0], r1 = range2[1];
    if (d1 < d0)
      d0 = normalize(d1, d0), r0 = interpolate2(r1, r0);
    else
      d0 = normalize(d0, d1), r0 = interpolate2(r0, r1);
    return function(x2) {
      return r0(d0(x2));
    };
  }
  function polymap(domain, range2, interpolate2) {
    var j = Math.min(domain.length, range2.length) - 1, d = new Array(j), r = new Array(j), i2 = -1;
    if (domain[j] < domain[0]) {
      domain = domain.slice().reverse();
      range2 = range2.slice().reverse();
    }
    while (++i2 < j) {
      d[i2] = normalize(domain[i2], domain[i2 + 1]);
      r[i2] = interpolate2(range2[i2], range2[i2 + 1]);
    }
    return function(x2) {
      var i3 = bisect(domain, x2, 1, j) - 1;
      return r[i3](d[i3](x2));
    };
  }
  function copy$1(source, target) {
    return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown());
  }
  function transformer() {
    var domain = unit$1, range2 = unit$1, interpolate2 = interpolate$1, transform, untransform, unknown, clamp = identity$2, piecewise, output, input;
    function rescale() {
      var n = Math.min(domain.length, range2.length);
      if (clamp !== identity$2)
        clamp = clamper(domain[0], domain[n - 1]);
      piecewise = n > 2 ? polymap : bimap;
      output = input = null;
      return scale;
    }
    function scale(x2) {
      return x2 == null || isNaN(x2 = +x2) ? unknown : (output || (output = piecewise(domain.map(transform), range2, interpolate2)))(transform(clamp(x2)));
    }
    scale.invert = function(y2) {
      return clamp(untransform((input || (input = piecewise(range2, domain.map(transform), interpolateNumber)))(y2)));
    };
    scale.domain = function(_2) {
      return arguments.length ? (domain = Array.from(_2, number$1), rescale()) : domain.slice();
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), rescale()) : range2.slice();
    };
    scale.rangeRound = function(_2) {
      return range2 = Array.from(_2), interpolate2 = interpolateRound, rescale();
    };
    scale.clamp = function(_2) {
      return arguments.length ? (clamp = _2 ? true : identity$2, rescale()) : clamp !== identity$2;
    };
    scale.interpolate = function(_2) {
      return arguments.length ? (interpolate2 = _2, rescale()) : interpolate2;
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    return function(t, u) {
      transform = t, untransform = u;
      return rescale();
    };
  }
  function continuous() {
    return transformer()(identity$2, identity$2);
  }
  function tickFormat(start2, stop, count, specifier) {
    var step = tickStep(start2, stop, count), precision;
    specifier = formatSpecifier(specifier == null ? ",f" : specifier);
    switch (specifier.type) {
      case "s": {
        var value2 = Math.max(Math.abs(start2), Math.abs(stop));
        if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value2)))
          specifier.precision = precision;
        return formatPrefix(specifier, value2);
      }
      case "":
      case "e":
      case "g":
      case "p":
      case "r": {
        if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start2), Math.abs(stop)))))
          specifier.precision = precision - (specifier.type === "e");
        break;
      }
      case "f":
      case "%": {
        if (specifier.precision == null && !isNaN(precision = precisionFixed(step)))
          specifier.precision = precision - (specifier.type === "%") * 2;
        break;
      }
    }
    return format(specifier);
  }
  function linearish(scale) {
    var domain = scale.domain;
    scale.ticks = function(count) {
      var d = domain();
      return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
    };
    scale.tickFormat = function(count, specifier) {
      var d = domain();
      return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
    };
    scale.nice = function(count) {
      if (count == null)
        count = 10;
      var d = domain();
      var i0 = 0;
      var i1 = d.length - 1;
      var start2 = d[i0];
      var stop = d[i1];
      var prestep;
      var step;
      var maxIter = 10;
      if (stop < start2) {
        step = start2, start2 = stop, stop = step;
        step = i0, i0 = i1, i1 = step;
      }
      while (maxIter-- > 0) {
        step = tickIncrement(start2, stop, count);
        if (step === prestep) {
          d[i0] = start2;
          d[i1] = stop;
          return domain(d);
        } else if (step > 0) {
          start2 = Math.floor(start2 / step) * step;
          stop = Math.ceil(stop / step) * step;
        } else if (step < 0) {
          start2 = Math.ceil(start2 * step) / step;
          stop = Math.floor(stop * step) / step;
        } else {
          break;
        }
        prestep = step;
      }
      return scale;
    };
    return scale;
  }
  function linear() {
    var scale = continuous();
    scale.copy = function() {
      return copy$1(scale, linear());
    };
    initRange.apply(scale, arguments);
    return linearish(scale);
  }
  function nice(domain, interval2) {
    domain = domain.slice();
    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], t;
    if (x1 < x0) {
      t = i0, i0 = i1, i1 = t;
      t = x0, x0 = x1, x1 = t;
    }
    domain[i0] = interval2.floor(x0);
    domain[i1] = interval2.ceil(x1);
    return domain;
  }
  const t0 = /* @__PURE__ */ new Date(), t1 = /* @__PURE__ */ new Date();
  function timeInterval(floori, offseti, count, field) {
    function interval2(date2) {
      return floori(date2 = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date2)), date2;
    }
    interval2.floor = (date2) => {
      return floori(date2 = /* @__PURE__ */ new Date(+date2)), date2;
    };
    interval2.ceil = (date2) => {
      return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
    };
    interval2.round = (date2) => {
      const d0 = interval2(date2), d1 = interval2.ceil(date2);
      return date2 - d0 < d1 - date2 ? d0 : d1;
    };
    interval2.offset = (date2, step) => {
      return offseti(date2 = /* @__PURE__ */ new Date(+date2), step == null ? 1 : Math.floor(step)), date2;
    };
    interval2.range = (start2, stop, step) => {
      const range2 = [];
      start2 = interval2.ceil(start2);
      step = step == null ? 1 : Math.floor(step);
      if (!(start2 < stop) || !(step > 0))
        return range2;
      let previous2;
      do
        range2.push(previous2 = /* @__PURE__ */ new Date(+start2)), offseti(start2, step), floori(start2);
      while (previous2 < start2 && start2 < stop);
      return range2;
    };
    interval2.filter = (test) => {
      return timeInterval((date2) => {
        if (date2 >= date2)
          while (floori(date2), !test(date2))
            date2.setTime(date2 - 1);
      }, (date2, step) => {
        if (date2 >= date2) {
          if (step < 0)
            while (++step <= 0) {
              while (offseti(date2, -1), !test(date2)) {
              }
            }
          else
            while (--step >= 0) {
              while (offseti(date2, 1), !test(date2)) {
              }
            }
        }
      });
    };
    if (count) {
      interval2.count = (start2, end2) => {
        t0.setTime(+start2), t1.setTime(+end2);
        floori(t0), floori(t1);
        return Math.floor(count(t0, t1));
      };
      interval2.every = (step) => {
        step = Math.floor(step);
        return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval2 : interval2.filter(field ? (d) => field(d) % step === 0 : (d) => interval2.count(0, d) % step === 0);
      };
    }
    return interval2;
  }
  const millisecond = timeInterval(() => {
  }, (date2, step) => {
    date2.setTime(+date2 + step);
  }, (start2, end2) => {
    return end2 - start2;
  });
  millisecond.every = (k) => {
    k = Math.floor(k);
    if (!isFinite(k) || !(k > 0))
      return null;
    if (!(k > 1))
      return millisecond;
    return timeInterval((date2) => {
      date2.setTime(Math.floor(date2 / k) * k);
    }, (date2, step) => {
      date2.setTime(+date2 + step * k);
    }, (start2, end2) => {
      return (end2 - start2) / k;
    });
  };
  millisecond.range;
  const durationSecond = 1e3;
  const durationMinute = durationSecond * 60;
  const durationHour = durationMinute * 60;
  const durationDay = durationHour * 24;
  const durationWeek = durationDay * 7;
  const durationMonth = durationDay * 30;
  const durationYear = durationDay * 365;
  const second = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds());
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationSecond);
  }, (start2, end2) => {
    return (end2 - start2) / durationSecond;
  }, (date2) => {
    return date2.getUTCSeconds();
  });
  second.range;
  const timeMinute = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationMinute);
  }, (start2, end2) => {
    return (end2 - start2) / durationMinute;
  }, (date2) => {
    return date2.getMinutes();
  });
  timeMinute.range;
  const utcMinute = timeInterval((date2) => {
    date2.setUTCSeconds(0, 0);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationMinute);
  }, (start2, end2) => {
    return (end2 - start2) / durationMinute;
  }, (date2) => {
    return date2.getUTCMinutes();
  });
  utcMinute.range;
  const timeHour = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond - date2.getMinutes() * durationMinute);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationHour);
  }, (start2, end2) => {
    return (end2 - start2) / durationHour;
  }, (date2) => {
    return date2.getHours();
  });
  timeHour.range;
  const utcHour = timeInterval((date2) => {
    date2.setUTCMinutes(0, 0, 0);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationHour);
  }, (start2, end2) => {
    return (end2 - start2) / durationHour;
  }, (date2) => {
    return date2.getUTCHours();
  });
  utcHour.range;
  const timeDay = timeInterval(
    (date2) => date2.setHours(0, 0, 0, 0),
    (date2, step) => date2.setDate(date2.getDate() + step),
    (start2, end2) => (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationDay,
    (date2) => date2.getDate() - 1
  );
  timeDay.range;
  const utcDay = timeInterval((date2) => {
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step);
  }, (start2, end2) => {
    return (end2 - start2) / durationDay;
  }, (date2) => {
    return date2.getUTCDate() - 1;
  });
  utcDay.range;
  const unixDay = timeInterval((date2) => {
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step);
  }, (start2, end2) => {
    return (end2 - start2) / durationDay;
  }, (date2) => {
    return Math.floor(date2 / durationDay);
  });
  unixDay.range;
  function timeWeekday(i2) {
    return timeInterval((date2) => {
      date2.setDate(date2.getDate() - (date2.getDay() + 7 - i2) % 7);
      date2.setHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setDate(date2.getDate() + step * 7);
    }, (start2, end2) => {
      return (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationWeek;
    });
  }
  const timeSunday = timeWeekday(0);
  const timeMonday = timeWeekday(1);
  const timeTuesday = timeWeekday(2);
  const timeWednesday = timeWeekday(3);
  const timeThursday = timeWeekday(4);
  const timeFriday = timeWeekday(5);
  const timeSaturday = timeWeekday(6);
  timeSunday.range;
  timeMonday.range;
  timeTuesday.range;
  timeWednesday.range;
  timeThursday.range;
  timeFriday.range;
  timeSaturday.range;
  function utcWeekday(i2) {
    return timeInterval((date2) => {
      date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i2) % 7);
      date2.setUTCHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setUTCDate(date2.getUTCDate() + step * 7);
    }, (start2, end2) => {
      return (end2 - start2) / durationWeek;
    });
  }
  const utcSunday = utcWeekday(0);
  const utcMonday = utcWeekday(1);
  const utcTuesday = utcWeekday(2);
  const utcWednesday = utcWeekday(3);
  const utcThursday = utcWeekday(4);
  const utcFriday = utcWeekday(5);
  const utcSaturday = utcWeekday(6);
  utcSunday.range;
  utcMonday.range;
  utcTuesday.range;
  utcWednesday.range;
  utcThursday.range;
  utcFriday.range;
  utcSaturday.range;
  const timeMonth = timeInterval((date2) => {
    date2.setDate(1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setMonth(date2.getMonth() + step);
  }, (start2, end2) => {
    return end2.getMonth() - start2.getMonth() + (end2.getFullYear() - start2.getFullYear()) * 12;
  }, (date2) => {
    return date2.getMonth();
  });
  timeMonth.range;
  const utcMonth = timeInterval((date2) => {
    date2.setUTCDate(1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCMonth(date2.getUTCMonth() + step);
  }, (start2, end2) => {
    return end2.getUTCMonth() - start2.getUTCMonth() + (end2.getUTCFullYear() - start2.getUTCFullYear()) * 12;
  }, (date2) => {
    return date2.getUTCMonth();
  });
  utcMonth.range;
  const timeYear = timeInterval((date2) => {
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setFullYear(date2.getFullYear() + step);
  }, (start2, end2) => {
    return end2.getFullYear() - start2.getFullYear();
  }, (date2) => {
    return date2.getFullYear();
  });
  timeYear.every = (k) => {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval((date2) => {
      date2.setFullYear(Math.floor(date2.getFullYear() / k) * k);
      date2.setMonth(0, 1);
      date2.setHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setFullYear(date2.getFullYear() + step * k);
    });
  };
  timeYear.range;
  const utcYear = timeInterval((date2) => {
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCFullYear(date2.getUTCFullYear() + step);
  }, (start2, end2) => {
    return end2.getUTCFullYear() - start2.getUTCFullYear();
  }, (date2) => {
    return date2.getUTCFullYear();
  });
  utcYear.every = (k) => {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval((date2) => {
      date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k) * k);
      date2.setUTCMonth(0, 1);
      date2.setUTCHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setUTCFullYear(date2.getUTCFullYear() + step * k);
    });
  };
  utcYear.range;
  function ticker(year, month, week, day, hour, minute) {
    const tickIntervals = [
      [second, 1, durationSecond],
      [second, 5, 5 * durationSecond],
      [second, 15, 15 * durationSecond],
      [second, 30, 30 * durationSecond],
      [minute, 1, durationMinute],
      [minute, 5, 5 * durationMinute],
      [minute, 15, 15 * durationMinute],
      [minute, 30, 30 * durationMinute],
      [hour, 1, durationHour],
      [hour, 3, 3 * durationHour],
      [hour, 6, 6 * durationHour],
      [hour, 12, 12 * durationHour],
      [day, 1, durationDay],
      [day, 2, 2 * durationDay],
      [week, 1, durationWeek],
      [month, 1, durationMonth],
      [month, 3, 3 * durationMonth],
      [year, 1, durationYear]
    ];
    function ticks2(start2, stop, count) {
      const reverse = stop < start2;
      if (reverse)
        [start2, stop] = [stop, start2];
      const interval2 = count && typeof count.range === "function" ? count : tickInterval2(start2, stop, count);
      const ticks3 = interval2 ? interval2.range(start2, +stop + 1) : [];
      return reverse ? ticks3.reverse() : ticks3;
    }
    function tickInterval2(start2, stop, count) {
      const target = Math.abs(stop - start2) / count;
      const i2 = bisector(([, , step2]) => step2).right(tickIntervals, target);
      if (i2 === tickIntervals.length)
        return year.every(tickStep(start2 / durationYear, stop / durationYear, count));
      if (i2 === 0)
        return millisecond.every(Math.max(tickStep(start2, stop, count), 1));
      const [t, step] = tickIntervals[target / tickIntervals[i2 - 1][2] < tickIntervals[i2][2] / target ? i2 - 1 : i2];
      return t.every(step);
    }
    return [ticks2, tickInterval2];
  }
  const [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute);
  function localDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
      date2.setFullYear(d.y);
      return date2;
    }
    return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
  }
  function utcDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
      date2.setUTCFullYear(d.y);
      return date2;
    }
    return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
  }
  function newDate(y2, m, d) {
    return { y: y2, m, d, H: 0, M: 0, S: 0, L: 0 };
  }
  function formatLocale(locale2) {
    var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
    var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
    var formats = {
      "a": formatShortWeekday,
      "A": formatWeekday,
      "b": formatShortMonth,
      "B": formatMonth,
      "c": null,
      "d": formatDayOfMonth,
      "e": formatDayOfMonth,
      "f": formatMicroseconds,
      "g": formatYearISO,
      "G": formatFullYearISO,
      "H": formatHour24,
      "I": formatHour12,
      "j": formatDayOfYear,
      "L": formatMilliseconds,
      "m": formatMonthNumber,
      "M": formatMinutes,
      "p": formatPeriod,
      "q": formatQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatSeconds,
      "u": formatWeekdayNumberMonday,
      "U": formatWeekNumberSunday,
      "V": formatWeekNumberISO,
      "w": formatWeekdayNumberSunday,
      "W": formatWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatYear,
      "Y": formatFullYear,
      "Z": formatZone,
      "%": formatLiteralPercent
    };
    var utcFormats = {
      "a": formatUTCShortWeekday,
      "A": formatUTCWeekday,
      "b": formatUTCShortMonth,
      "B": formatUTCMonth,
      "c": null,
      "d": formatUTCDayOfMonth,
      "e": formatUTCDayOfMonth,
      "f": formatUTCMicroseconds,
      "g": formatUTCYearISO,
      "G": formatUTCFullYearISO,
      "H": formatUTCHour24,
      "I": formatUTCHour12,
      "j": formatUTCDayOfYear,
      "L": formatUTCMilliseconds,
      "m": formatUTCMonthNumber,
      "M": formatUTCMinutes,
      "p": formatUTCPeriod,
      "q": formatUTCQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatUTCSeconds,
      "u": formatUTCWeekdayNumberMonday,
      "U": formatUTCWeekNumberSunday,
      "V": formatUTCWeekNumberISO,
      "w": formatUTCWeekdayNumberSunday,
      "W": formatUTCWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatUTCYear,
      "Y": formatUTCFullYear,
      "Z": formatUTCZone,
      "%": formatLiteralPercent
    };
    var parses = {
      "a": parseShortWeekday,
      "A": parseWeekday,
      "b": parseShortMonth,
      "B": parseMonth,
      "c": parseLocaleDateTime,
      "d": parseDayOfMonth,
      "e": parseDayOfMonth,
      "f": parseMicroseconds,
      "g": parseYear,
      "G": parseFullYear,
      "H": parseHour24,
      "I": parseHour24,
      "j": parseDayOfYear,
      "L": parseMilliseconds,
      "m": parseMonthNumber,
      "M": parseMinutes,
      "p": parsePeriod,
      "q": parseQuarter,
      "Q": parseUnixTimestamp,
      "s": parseUnixTimestampSeconds,
      "S": parseSeconds,
      "u": parseWeekdayNumberMonday,
      "U": parseWeekNumberSunday,
      "V": parseWeekNumberISO,
      "w": parseWeekdayNumberSunday,
      "W": parseWeekNumberMonday,
      "x": parseLocaleDate,
      "X": parseLocaleTime,
      "y": parseYear,
      "Y": parseFullYear,
      "Z": parseZone,
      "%": parseLiteralPercent
    };
    formats.x = newFormat(locale_date, formats);
    formats.X = newFormat(locale_time, formats);
    formats.c = newFormat(locale_dateTime, formats);
    utcFormats.x = newFormat(locale_date, utcFormats);
    utcFormats.X = newFormat(locale_time, utcFormats);
    utcFormats.c = newFormat(locale_dateTime, utcFormats);
    function newFormat(specifier, formats2) {
      return function(date2) {
        var string2 = [], i2 = -1, j = 0, n = specifier.length, c2, pad2, format2;
        if (!(date2 instanceof Date))
          date2 = /* @__PURE__ */ new Date(+date2);
        while (++i2 < n) {
          if (specifier.charCodeAt(i2) === 37) {
            string2.push(specifier.slice(j, i2));
            if ((pad2 = pads[c2 = specifier.charAt(++i2)]) != null)
              c2 = specifier.charAt(++i2);
            else
              pad2 = c2 === "e" ? " " : "0";
            if (format2 = formats2[c2])
              c2 = format2(date2, pad2);
            string2.push(c2);
            j = i2 + 1;
          }
        }
        string2.push(specifier.slice(j, i2));
        return string2.join("");
      };
    }
    function newParse(specifier, Z) {
      return function(string2) {
        var d = newDate(1900, void 0, 1), i2 = parseSpecifier(d, specifier, string2 += "", 0), week, day;
        if (i2 != string2.length)
          return null;
        if ("Q" in d)
          return new Date(d.Q);
        if ("s" in d)
          return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
        if (Z && !("Z" in d))
          d.Z = 0;
        if ("p" in d)
          d.H = d.H % 12 + d.p * 12;
        if (d.m === void 0)
          d.m = "q" in d ? d.q : 0;
        if ("V" in d) {
          if (d.V < 1 || d.V > 53)
            return null;
          if (!("w" in d))
            d.w = 1;
          if ("Z" in d) {
            week = utcDate(newDate(d.y, 0, 1)), day = week.getUTCDay();
            week = day > 4 || day === 0 ? utcMonday.ceil(week) : utcMonday(week);
            week = utcDay.offset(week, (d.V - 1) * 7);
            d.y = week.getUTCFullYear();
            d.m = week.getUTCMonth();
            d.d = week.getUTCDate() + (d.w + 6) % 7;
          } else {
            week = localDate(newDate(d.y, 0, 1)), day = week.getDay();
            week = day > 4 || day === 0 ? timeMonday.ceil(week) : timeMonday(week);
            week = timeDay.offset(week, (d.V - 1) * 7);
            d.y = week.getFullYear();
            d.m = week.getMonth();
            d.d = week.getDate() + (d.w + 6) % 7;
          }
        } else if ("W" in d || "U" in d) {
          if (!("w" in d))
            d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
          day = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
          d.m = 0;
          d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
        }
        if ("Z" in d) {
          d.H += d.Z / 100 | 0;
          d.M += d.Z % 100;
          return utcDate(d);
        }
        return localDate(d);
      };
    }
    function parseSpecifier(d, specifier, string2, j) {
      var i2 = 0, n = specifier.length, m = string2.length, c2, parse2;
      while (i2 < n) {
        if (j >= m)
          return -1;
        c2 = specifier.charCodeAt(i2++);
        if (c2 === 37) {
          c2 = specifier.charAt(i2++);
          parse2 = parses[c2 in pads ? specifier.charAt(i2++) : c2];
          if (!parse2 || (j = parse2(d, string2, j)) < 0)
            return -1;
        } else if (c2 != string2.charCodeAt(j++)) {
          return -1;
        }
      }
      return j;
    }
    function parsePeriod(d, string2, i2) {
      var n = periodRe.exec(string2.slice(i2));
      return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortWeekday(d, string2, i2) {
      var n = shortWeekdayRe.exec(string2.slice(i2));
      return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseWeekday(d, string2, i2) {
      var n = weekdayRe.exec(string2.slice(i2));
      return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortMonth(d, string2, i2) {
      var n = shortMonthRe.exec(string2.slice(i2));
      return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseMonth(d, string2, i2) {
      var n = monthRe.exec(string2.slice(i2));
      return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseLocaleDateTime(d, string2, i2) {
      return parseSpecifier(d, locale_dateTime, string2, i2);
    }
    function parseLocaleDate(d, string2, i2) {
      return parseSpecifier(d, locale_date, string2, i2);
    }
    function parseLocaleTime(d, string2, i2) {
      return parseSpecifier(d, locale_time, string2, i2);
    }
    function formatShortWeekday(d) {
      return locale_shortWeekdays[d.getDay()];
    }
    function formatWeekday(d) {
      return locale_weekdays[d.getDay()];
    }
    function formatShortMonth(d) {
      return locale_shortMonths[d.getMonth()];
    }
    function formatMonth(d) {
      return locale_months[d.getMonth()];
    }
    function formatPeriod(d) {
      return locale_periods[+(d.getHours() >= 12)];
    }
    function formatQuarter(d) {
      return 1 + ~~(d.getMonth() / 3);
    }
    function formatUTCShortWeekday(d) {
      return locale_shortWeekdays[d.getUTCDay()];
    }
    function formatUTCWeekday(d) {
      return locale_weekdays[d.getUTCDay()];
    }
    function formatUTCShortMonth(d) {
      return locale_shortMonths[d.getUTCMonth()];
    }
    function formatUTCMonth(d) {
      return locale_months[d.getUTCMonth()];
    }
    function formatUTCPeriod(d) {
      return locale_periods[+(d.getUTCHours() >= 12)];
    }
    function formatUTCQuarter(d) {
      return 1 + ~~(d.getUTCMonth() / 3);
    }
    return {
      format: function(specifier) {
        var f2 = newFormat(specifier += "", formats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      parse: function(specifier) {
        var p = newParse(specifier += "", false);
        p.toString = function() {
          return specifier;
        };
        return p;
      },
      utcFormat: function(specifier) {
        var f2 = newFormat(specifier += "", utcFormats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      utcParse: function(specifier) {
        var p = newParse(specifier += "", true);
        p.toString = function() {
          return specifier;
        };
        return p;
      }
    };
  }
  var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
  function pad$1(value2, fill, width2) {
    var sign2 = value2 < 0 ? "-" : "", string2 = (sign2 ? -value2 : value2) + "", length2 = string2.length;
    return sign2 + (length2 < width2 ? new Array(width2 - length2 + 1).join(fill) + string2 : string2);
  }
  function requote(s) {
    return s.replace(requoteRe, "\\$&");
  }
  function formatRe(names) {
    return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
  }
  function formatLookup(names) {
    return new Map(names.map((name, i2) => [name.toLowerCase(), i2]));
  }
  function parseWeekdayNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.w = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekdayNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.u = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.U = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberISO(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.V = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.W = +n[0], i2 + n[0].length) : -1;
  }
  function parseFullYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 4));
    return n ? (d.y = +n[0], i2 + n[0].length) : -1;
  }
  function parseYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i2 + n[0].length) : -1;
  }
  function parseZone(d, string2, i2) {
    var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string2.slice(i2, i2 + 6));
    return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i2 + n[0].length) : -1;
  }
  function parseQuarter(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.q = n[0] * 3 - 3, i2 + n[0].length) : -1;
  }
  function parseMonthNumber(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.m = n[0] - 1, i2 + n[0].length) : -1;
  }
  function parseDayOfMonth(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseDayOfYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.m = 0, d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseHour24(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.H = +n[0], i2 + n[0].length) : -1;
  }
  function parseMinutes(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.M = +n[0], i2 + n[0].length) : -1;
  }
  function parseSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.S = +n[0], i2 + n[0].length) : -1;
  }
  function parseMilliseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.L = +n[0], i2 + n[0].length) : -1;
  }
  function parseMicroseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 6));
    return n ? (d.L = Math.floor(n[0] / 1e3), i2 + n[0].length) : -1;
  }
  function parseLiteralPercent(d, string2, i2) {
    var n = percentRe.exec(string2.slice(i2, i2 + 1));
    return n ? i2 + n[0].length : -1;
  }
  function parseUnixTimestamp(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.Q = +n[0], i2 + n[0].length) : -1;
  }
  function parseUnixTimestampSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.s = +n[0], i2 + n[0].length) : -1;
  }
  function formatDayOfMonth(d, p) {
    return pad$1(d.getDate(), p, 2);
  }
  function formatHour24(d, p) {
    return pad$1(d.getHours(), p, 2);
  }
  function formatHour12(d, p) {
    return pad$1(d.getHours() % 12 || 12, p, 2);
  }
  function formatDayOfYear(d, p) {
    return pad$1(1 + timeDay.count(timeYear(d), d), p, 3);
  }
  function formatMilliseconds(d, p) {
    return pad$1(d.getMilliseconds(), p, 3);
  }
  function formatMicroseconds(d, p) {
    return formatMilliseconds(d, p) + "000";
  }
  function formatMonthNumber(d, p) {
    return pad$1(d.getMonth() + 1, p, 2);
  }
  function formatMinutes(d, p) {
    return pad$1(d.getMinutes(), p, 2);
  }
  function formatSeconds(d, p) {
    return pad$1(d.getSeconds(), p, 2);
  }
  function formatWeekdayNumberMonday(d) {
    var day = d.getDay();
    return day === 0 ? 7 : day;
  }
  function formatWeekNumberSunday(d, p) {
    return pad$1(timeSunday.count(timeYear(d) - 1, d), p, 2);
  }
  function dISO(d) {
    var day = d.getDay();
    return day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
  }
  function formatWeekNumberISO(d, p) {
    d = dISO(d);
    return pad$1(timeThursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p, 2);
  }
  function formatWeekdayNumberSunday(d) {
    return d.getDay();
  }
  function formatWeekNumberMonday(d, p) {
    return pad$1(timeMonday.count(timeYear(d) - 1, d), p, 2);
  }
  function formatYear(d, p) {
    return pad$1(d.getFullYear() % 100, p, 2);
  }
  function formatYearISO(d, p) {
    d = dISO(d);
    return pad$1(d.getFullYear() % 100, p, 2);
  }
  function formatFullYear(d, p) {
    return pad$1(d.getFullYear() % 1e4, p, 4);
  }
  function formatFullYearISO(d, p) {
    var day = d.getDay();
    d = day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
    return pad$1(d.getFullYear() % 1e4, p, 4);
  }
  function formatZone(d) {
    var z = d.getTimezoneOffset();
    return (z > 0 ? "-" : (z *= -1, "+")) + pad$1(z / 60 | 0, "0", 2) + pad$1(z % 60, "0", 2);
  }
  function formatUTCDayOfMonth(d, p) {
    return pad$1(d.getUTCDate(), p, 2);
  }
  function formatUTCHour24(d, p) {
    return pad$1(d.getUTCHours(), p, 2);
  }
  function formatUTCHour12(d, p) {
    return pad$1(d.getUTCHours() % 12 || 12, p, 2);
  }
  function formatUTCDayOfYear(d, p) {
    return pad$1(1 + utcDay.count(utcYear(d), d), p, 3);
  }
  function formatUTCMilliseconds(d, p) {
    return pad$1(d.getUTCMilliseconds(), p, 3);
  }
  function formatUTCMicroseconds(d, p) {
    return formatUTCMilliseconds(d, p) + "000";
  }
  function formatUTCMonthNumber(d, p) {
    return pad$1(d.getUTCMonth() + 1, p, 2);
  }
  function formatUTCMinutes(d, p) {
    return pad$1(d.getUTCMinutes(), p, 2);
  }
  function formatUTCSeconds(d, p) {
    return pad$1(d.getUTCSeconds(), p, 2);
  }
  function formatUTCWeekdayNumberMonday(d) {
    var dow = d.getUTCDay();
    return dow === 0 ? 7 : dow;
  }
  function formatUTCWeekNumberSunday(d, p) {
    return pad$1(utcSunday.count(utcYear(d) - 1, d), p, 2);
  }
  function UTCdISO(d) {
    var day = d.getUTCDay();
    return day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
  }
  function formatUTCWeekNumberISO(d, p) {
    d = UTCdISO(d);
    return pad$1(utcThursday.count(utcYear(d), d) + (utcYear(d).getUTCDay() === 4), p, 2);
  }
  function formatUTCWeekdayNumberSunday(d) {
    return d.getUTCDay();
  }
  function formatUTCWeekNumberMonday(d, p) {
    return pad$1(utcMonday.count(utcYear(d) - 1, d), p, 2);
  }
  function formatUTCYear(d, p) {
    return pad$1(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCYearISO(d, p) {
    d = UTCdISO(d);
    return pad$1(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCFullYear(d, p) {
    return pad$1(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCFullYearISO(d, p) {
    var day = d.getUTCDay();
    d = day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
    return pad$1(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCZone() {
    return "+0000";
  }
  function formatLiteralPercent() {
    return "%";
  }
  function formatUnixTimestamp(d) {
    return +d;
  }
  function formatUnixTimestampSeconds(d) {
    return Math.floor(+d / 1e3);
  }
  var locale;
  var timeFormat;
  defaultLocale({
    dateTime: "%x, %X",
    date: "%-m/%-d/%Y",
    time: "%-I:%M:%S %p",
    periods: ["AM", "PM"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
  });
  function defaultLocale(definition2) {
    locale = formatLocale(definition2);
    timeFormat = locale.format;
    locale.parse;
    locale.utcFormat;
    locale.utcParse;
    return locale;
  }
  function date(t) {
    return new Date(t);
  }
  function number(t) {
    return t instanceof Date ? +t : +/* @__PURE__ */ new Date(+t);
  }
  function calendar(ticks2, tickInterval2, year, month, week, day, hour, minute, second2, format2) {
    var scale = continuous(), invert2 = scale.invert, domain = scale.domain;
    var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
    function tickFormat2(date2) {
      return (second2(date2) < date2 ? formatMillisecond : minute(date2) < date2 ? formatSecond : hour(date2) < date2 ? formatMinute : day(date2) < date2 ? formatHour : month(date2) < date2 ? week(date2) < date2 ? formatDay : formatWeek : year(date2) < date2 ? formatMonth : formatYear2)(date2);
    }
    scale.invert = function(y2) {
      return new Date(invert2(y2));
    };
    scale.domain = function(_2) {
      return arguments.length ? domain(Array.from(_2, number)) : domain().map(date);
    };
    scale.ticks = function(interval2) {
      var d = domain();
      return ticks2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
    };
    scale.tickFormat = function(count, specifier) {
      return specifier == null ? tickFormat2 : format2(specifier);
    };
    scale.nice = function(interval2) {
      var d = domain();
      if (!interval2 || typeof interval2.range !== "function")
        interval2 = tickInterval2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
      return interval2 ? domain(nice(d, interval2)) : scale;
    };
    scale.copy = function() {
      return copy$1(scale, calendar(ticks2, tickInterval2, year, month, week, day, hour, minute, second2, format2));
    };
    return scale;
  }
  function time$1() {
    return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute, second, timeFormat).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
  }
  function colors(specifier) {
    var n = specifier.length / 6 | 0, colors2 = new Array(n), i2 = 0;
    while (i2 < n)
      colors2[i2] = "#" + specifier.slice(i2 * 6, ++i2 * 6);
    return colors2;
  }
  const d3schemeTableau10 = colors("4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab");
  function constant$3(x2) {
    return function constant2() {
      return x2;
    };
  }
  const abs$1 = Math.abs;
  const atan2 = Math.atan2;
  const cos = Math.cos;
  const max$2 = Math.max;
  const min$2 = Math.min;
  const sin = Math.sin;
  const sqrt = Math.sqrt;
  const epsilon$1 = 1e-12;
  const pi$1 = Math.PI;
  const halfPi = pi$1 / 2;
  const tau$1 = 2 * pi$1;
  function acos(x2) {
    return x2 > 1 ? 0 : x2 < -1 ? pi$1 : Math.acos(x2);
  }
  function asin(x2) {
    return x2 >= 1 ? halfPi : x2 <= -1 ? -halfPi : Math.asin(x2);
  }
  function withPath(shape) {
    let digits = 3;
    shape.digits = function(_2) {
      if (!arguments.length)
        return digits;
      if (_2 == null) {
        digits = null;
      } else {
        const d = Math.floor(_2);
        if (!(d >= 0))
          throw new RangeError(`invalid digits: ${_2}`);
        digits = d;
      }
      return shape;
    };
    return () => new Path$1(digits);
  }
  function arcInnerRadius(d) {
    return d.innerRadius;
  }
  function arcOuterRadius(d) {
    return d.outerRadius;
  }
  function arcStartAngle(d) {
    return d.startAngle;
  }
  function arcEndAngle(d) {
    return d.endAngle;
  }
  function arcPadAngle(d) {
    return d && d.padAngle;
  }
  function intersect$1(x0, y0, x1, y1, x2, y2, x3, y3) {
    var x10 = x1 - x0, y10 = y1 - y0, x32 = x3 - x2, y32 = y3 - y2, t = y32 * x10 - x32 * y10;
    if (t * t < epsilon$1)
      return;
    t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
    return [x0 + t * x10, y0 + t * y10];
  }
  function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
    var x01 = x0 - x1, y01 = y0 - y1, lo = (cw ? rc : -rc) / sqrt(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x0 + ox, y11 = y0 + oy, x10 = x1 + ox, y10 = y1 + oy, x00 = (x11 + x10) / 2, y00 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D2 = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt(max$2(0, r * r * d2 - D2 * D2)), cx0 = (D2 * dy - dx * d) / d2, cy0 = (-D2 * dx - dy * d) / d2, cx1 = (D2 * dy + dx * d) / d2, cy1 = (-D2 * dx + dy * d) / d2, dx0 = cx0 - x00, dy0 = cy0 - y00, dx1 = cx1 - x00, dy1 = cy1 - y00;
    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1)
      cx0 = cx1, cy0 = cy1;
    return {
      cx: cx0,
      cy: cy0,
      x01: -ox,
      y01: -oy,
      x11: cx0 * (r1 / r - 1),
      y11: cy0 * (r1 / r - 1)
    };
  }
  function d3arc() {
    var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant$3(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context = null, path2 = withPath(arc);
    function arc() {
      var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi, a1 = endAngle.apply(this, arguments) - halfPi, da = abs$1(a1 - a0), cw = a1 > a0;
      if (!context)
        context = buffer = path2();
      if (r1 < r0)
        r = r1, r1 = r0, r0 = r;
      if (!(r1 > epsilon$1))
        context.moveTo(0, 0);
      else if (da > tau$1 - epsilon$1) {
        context.moveTo(r1 * cos(a0), r1 * sin(a0));
        context.arc(0, 0, r1, a0, a1, !cw);
        if (r0 > epsilon$1) {
          context.moveTo(r0 * cos(a1), r0 * sin(a1));
          context.arc(0, 0, r0, a1, a0, cw);
        }
      } else {
        var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon$1 && (padRadius ? +padRadius.apply(this, arguments) : sqrt(r0 * r0 + r1 * r1)), rc = min$2(abs$1(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t02, t12;
        if (rp > epsilon$1) {
          var p0 = asin(rp / r0 * sin(ap)), p1 = asin(rp / r1 * sin(ap));
          if ((da0 -= p0 * 2) > epsilon$1)
            p0 *= cw ? 1 : -1, a00 += p0, a10 -= p0;
          else
            da0 = 0, a00 = a10 = (a0 + a1) / 2;
          if ((da1 -= p1 * 2) > epsilon$1)
            p1 *= cw ? 1 : -1, a01 += p1, a11 -= p1;
          else
            da1 = 0, a01 = a11 = (a0 + a1) / 2;
        }
        var x01 = r1 * cos(a01), y01 = r1 * sin(a01), x10 = r0 * cos(a10), y10 = r0 * sin(a10);
        if (rc > epsilon$1) {
          var x11 = r1 * cos(a11), y11 = r1 * sin(a11), x00 = r0 * cos(a00), y00 = r0 * sin(a00), oc;
          if (da < pi$1) {
            if (oc = intersect$1(x01, y01, x00, y00, x11, y11, x10, y10)) {
              var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin(acos((ax * bx + ay * by) / (sqrt(ax * ax + ay * ay) * sqrt(bx * bx + by * by))) / 2), lc = sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
              rc0 = min$2(rc, (r0 - lc) / (kc - 1));
              rc1 = min$2(rc, (r1 - lc) / (kc + 1));
            } else {
              rc0 = rc1 = 0;
            }
          }
        }
        if (!(da1 > epsilon$1))
          context.moveTo(x01, y01);
        else if (rc1 > epsilon$1) {
          t02 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
          t12 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
          context.moveTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc1 < rc)
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r1, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), !cw);
            context.arc(t12.cx, t12.cy, rc1, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);
        if (!(r0 > epsilon$1) || !(da0 > epsilon$1))
          context.lineTo(x10, y10);
        else if (rc0 > epsilon$1) {
          t02 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
          t12 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);
          context.lineTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc0 < rc)
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r0, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), cw);
            context.arc(t12.cx, t12.cy, rc0, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.arc(0, 0, r0, a10, a00, cw);
      }
      context.closePath();
      if (buffer)
        return context = null, buffer + "" || null;
    }
    arc.centroid = function() {
      var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi$1 / 2;
      return [cos(a) * r, sin(a) * r];
    };
    arc.innerRadius = function(_2) {
      return arguments.length ? (innerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : innerRadius;
    };
    arc.outerRadius = function(_2) {
      return arguments.length ? (outerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : outerRadius;
    };
    arc.cornerRadius = function(_2) {
      return arguments.length ? (cornerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : cornerRadius;
    };
    arc.padRadius = function(_2) {
      return arguments.length ? (padRadius = _2 == null ? null : typeof _2 === "function" ? _2 : constant$3(+_2), arc) : padRadius;
    };
    arc.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : startAngle;
    };
    arc.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : endAngle;
    };
    arc.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : padAngle;
    };
    arc.context = function(_2) {
      return arguments.length ? (context = _2 == null ? null : _2, arc) : context;
    };
    return arc;
  }
  function array(x2) {
    return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
  }
  function Linear(context) {
    this._context = context;
  }
  Linear.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default:
          this._context.lineTo(x2, y2);
          break;
      }
    }
  };
  function curveLinear(context) {
    return new Linear(context);
  }
  function x$1(p) {
    return p[0];
  }
  function y$1(p) {
    return p[1];
  }
  function line$1(x2, y2) {
    var defined = constant$3(true), context = null, curve = curveLinear, output = null, path2 = withPath(line2);
    x2 = typeof x2 === "function" ? x2 : x2 === void 0 ? x$1 : constant$3(x2);
    y2 = typeof y2 === "function" ? y2 : y2 === void 0 ? y$1 : constant$3(y2);
    function line2(data) {
      var i2, n = (data = array(data)).length, d, defined0 = false, buffer;
      if (context == null)
        output = curve(buffer = path2());
      for (i2 = 0; i2 <= n; ++i2) {
        if (!(i2 < n && defined(d = data[i2], i2, data)) === defined0) {
          if (defined0 = !defined0)
            output.lineStart();
          else
            output.lineEnd();
        }
        if (defined0)
          output.point(+x2(d, i2, data), +y2(d, i2, data));
      }
      if (buffer)
        return output = null, buffer + "" || null;
    }
    line2.x = function(_2) {
      return arguments.length ? (x2 = typeof _2 === "function" ? _2 : constant$3(+_2), line2) : x2;
    };
    line2.y = function(_2) {
      return arguments.length ? (y2 = typeof _2 === "function" ? _2 : constant$3(+_2), line2) : y2;
    };
    line2.defined = function(_2) {
      return arguments.length ? (defined = typeof _2 === "function" ? _2 : constant$3(!!_2), line2) : defined;
    };
    line2.curve = function(_2) {
      return arguments.length ? (curve = _2, context != null && (output = curve(context)), line2) : curve;
    };
    line2.context = function(_2) {
      return arguments.length ? (_2 == null ? context = output = null : output = curve(context = _2), line2) : context;
    };
    return line2;
  }
  function descending(a, b) {
    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function identity$1(d) {
    return d;
  }
  function d3pie() {
    var value2 = identity$1, sortValues = descending, sort2 = null, startAngle = constant$3(0), endAngle = constant$3(tau$1), padAngle = constant$3(0);
    function pie2(data) {
      var i2, n = (data = array(data)).length, j, k, sum2 = 0, index2 = new Array(n), arcs = new Array(n), a0 = +startAngle.apply(this, arguments), da = Math.min(tau$1, Math.max(-tau$1, endAngle.apply(this, arguments) - a0)), a1, p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)), pa = p * (da < 0 ? -1 : 1), v;
      for (i2 = 0; i2 < n; ++i2) {
        if ((v = arcs[index2[i2] = i2] = +value2(data[i2], i2, data)) > 0) {
          sum2 += v;
        }
      }
      if (sortValues != null)
        index2.sort(function(i3, j2) {
          return sortValues(arcs[i3], arcs[j2]);
        });
      else if (sort2 != null)
        index2.sort(function(i3, j2) {
          return sort2(data[i3], data[j2]);
        });
      for (i2 = 0, k = sum2 ? (da - n * pa) / sum2 : 0; i2 < n; ++i2, a0 = a1) {
        j = index2[i2], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {
          data: data[j],
          index: i2,
          value: v,
          startAngle: a0,
          endAngle: a1,
          padAngle: p
        };
      }
      return arcs;
    }
    pie2.value = function(_2) {
      return arguments.length ? (value2 = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : value2;
    };
    pie2.sortValues = function(_2) {
      return arguments.length ? (sortValues = _2, sort2 = null, pie2) : sortValues;
    };
    pie2.sort = function(_2) {
      return arguments.length ? (sort2 = _2, sortValues = null, pie2) : sort2;
    };
    pie2.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : startAngle;
    };
    pie2.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : endAngle;
    };
    pie2.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : padAngle;
    };
    return pie2;
  }
  class Bump {
    constructor(context, x2) {
      this._context = context;
      this._x = x2;
    }
    areaStart() {
      this._line = 0;
    }
    areaEnd() {
      this._line = NaN;
    }
    lineStart() {
      this._point = 0;
    }
    lineEnd() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    }
    point(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0: {
          this._point = 1;
          if (this._line)
            this._context.lineTo(x2, y2);
          else
            this._context.moveTo(x2, y2);
          break;
        }
        case 1:
          this._point = 2;
        default: {
          if (this._x)
            this._context.bezierCurveTo(this._x0 = (this._x0 + x2) / 2, this._y0, this._x0, y2, x2, y2);
          else
            this._context.bezierCurveTo(this._x0, this._y0 = (this._y0 + y2) / 2, x2, this._y0, x2, y2);
          break;
        }
      }
      this._x0 = x2, this._y0 = y2;
    }
  }
  function bumpX(context) {
    return new Bump(context, true);
  }
  function bumpY(context) {
    return new Bump(context, false);
  }
  function noop$1() {
  }
  function point$6(that, x2, y2) {
    that._context.bezierCurveTo(
      (2 * that._x0 + that._x1) / 3,
      (2 * that._y0 + that._y1) / 3,
      (that._x0 + 2 * that._x1) / 3,
      (that._y0 + 2 * that._y1) / 3,
      (that._x0 + 4 * that._x1 + x2) / 6,
      (that._y0 + 4 * that._y1 + y2) / 6
    );
  }
  function Basis(context) {
    this._context = context;
  }
  Basis.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 3:
          point$6(this, this._x1, this._y1);
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasis(context) {
    return new Basis(context);
  }
  function BasisClosed(context) {
    this._context = context;
  }
  BasisClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x2, this._y2);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
          this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x2, this._y2);
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x2 = x2, this._y2 = y2;
          break;
        case 1:
          this._point = 2;
          this._x3 = x2, this._y3 = y2;
          break;
        case 2:
          this._point = 3;
          this._x4 = x2, this._y4 = y2;
          this._context.moveTo((this._x0 + 4 * this._x1 + x2) / 6, (this._y0 + 4 * this._y1 + y2) / 6);
          break;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisClosed(context) {
    return new BasisClosed(context);
  }
  function BasisOpen(context) {
    this._context = context;
  }
  BasisOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          var x0 = (this._x0 + 4 * this._x1 + x2) / 6, y0 = (this._y0 + 4 * this._y1 + y2) / 6;
          this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0);
          break;
        case 3:
          this._point = 4;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisOpen(context) {
    return new BasisOpen(context);
  }
  function Bundle(context, beta) {
    this._basis = new Basis(context);
    this._beta = beta;
  }
  Bundle.prototype = {
    lineStart: function() {
      this._x = [];
      this._y = [];
      this._basis.lineStart();
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, j = x2.length - 1;
      if (j > 0) {
        var x0 = x2[0], y0 = y2[0], dx = x2[j] - x0, dy = y2[j] - y0, i2 = -1, t;
        while (++i2 <= j) {
          t = i2 / j;
          this._basis.point(
            this._beta * x2[i2] + (1 - this._beta) * (x0 + t * dx),
            this._beta * y2[i2] + (1 - this._beta) * (y0 + t * dy)
          );
        }
      }
      this._x = this._y = null;
      this._basis.lineEnd();
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  const curveBundle = function custom(beta) {
    function bundle(context) {
      return beta === 1 ? new Basis(context) : new Bundle(context, beta);
    }
    bundle.beta = function(beta2) {
      return custom(+beta2);
    };
    return bundle;
  }(0.85);
  function point$5(that, x2, y2) {
    that._context.bezierCurveTo(
      that._x1 + that._k * (that._x2 - that._x0),
      that._y1 + that._k * (that._y2 - that._y0),
      that._x2 + that._k * (that._x1 - x2),
      that._y2 + that._k * (that._y1 - y2),
      that._x2,
      that._y2
    );
  }
  function Cardinal(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  Cardinal.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          point$5(this, this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          this._x1 = x2, this._y1 = y2;
          break;
        case 2:
          this._point = 3;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinal = function custom(tension) {
    function cardinal(context) {
      return new Cardinal(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalClosed(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalClosed = function custom(tension) {
    function cardinal(context) {
      return new CardinalClosed(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalOpen(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalOpen = function custom(tension) {
    function cardinal(context) {
      return new CardinalOpen(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function point$4(that, x2, y2) {
    var x1 = that._x1, y1 = that._y1, x22 = that._x2, y22 = that._y2;
    if (that._l01_a > epsilon$1) {
      var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
      x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
      y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
    }
    if (that._l23_a > epsilon$1) {
      var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m = 3 * that._l23_a * (that._l23_a + that._l12_a);
      x22 = (x22 * b + that._x1 * that._l23_2a - x2 * that._l12_2a) / m;
      y22 = (y22 * b + that._y1 * that._l23_2a - y2 * that._l12_2a) / m;
    }
    that._context.bezierCurveTo(x1, y1, x22, y22, that._x2, that._y2);
  }
  function CatmullRom(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRom.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          this.point(this._x2, this._y2);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRom = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomClosed(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomClosed = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomOpen(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomOpen = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function LinearClosed(context) {
    this._context = context;
  }
  LinearClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._point)
        this._context.closePath();
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point)
        this._context.lineTo(x2, y2);
      else
        this._point = 1, this._context.moveTo(x2, y2);
    }
  };
  function curveLinearClosed(context) {
    return new LinearClosed(context);
  }
  function sign(x2) {
    return x2 < 0 ? -1 : 1;
  }
  function slope3(that, x2, y2) {
    var h0 = that._x1 - that._x0, h1 = x2 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
    return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
  }
  function slope2(that, t) {
    var h = that._x1 - that._x0;
    return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
  }
  function point$3(that, t02, t12) {
    var x0 = that._x0, y0 = that._y0, x1 = that._x1, y1 = that._y1, dx = (x1 - x0) / 3;
    that._context.bezierCurveTo(x0 + dx, y0 + dx * t02, x1 - dx, y1 - dx * t12, x1, y1);
  }
  function MonotoneX(context) {
    this._context = context;
  }
  MonotoneX.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
        case 3:
          point$3(this, this._t0, slope2(this, this._t0));
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      var t12 = NaN;
      x2 = +x2, y2 = +y2;
      if (x2 === this._x1 && y2 === this._y1)
        return;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          point$3(this, slope2(this, t12 = slope3(this, x2, y2)), t12);
          break;
        default:
          point$3(this, this._t0, t12 = slope3(this, x2, y2));
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
      this._t0 = t12;
    }
  };
  function MonotoneY(context) {
    this._context = new ReflectContext(context);
  }
  (MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x2, y2) {
    MonotoneX.prototype.point.call(this, y2, x2);
  };
  function ReflectContext(context) {
    this._context = context;
  }
  ReflectContext.prototype = {
    moveTo: function(x2, y2) {
      this._context.moveTo(y2, x2);
    },
    closePath: function() {
      this._context.closePath();
    },
    lineTo: function(x2, y2) {
      this._context.lineTo(y2, x2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._context.bezierCurveTo(y1, x1, y2, x2, y3, x3);
    }
  };
  function monotoneX(context) {
    return new MonotoneX(context);
  }
  function monotoneY(context) {
    return new MonotoneY(context);
  }
  function Natural(context) {
    this._context = context;
  }
  Natural.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = [];
      this._y = [];
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, n = x2.length;
      if (n) {
        this._line ? this._context.lineTo(x2[0], y2[0]) : this._context.moveTo(x2[0], y2[0]);
        if (n === 2) {
          this._context.lineTo(x2[1], y2[1]);
        } else {
          var px = controlPoints(x2), py = controlPoints(y2);
          for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
            this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x2[i1], y2[i1]);
          }
        }
      }
      if (this._line || this._line !== 0 && n === 1)
        this._context.closePath();
      this._line = 1 - this._line;
      this._x = this._y = null;
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  function controlPoints(x2) {
    var i2, n = x2.length - 1, m, a = new Array(n), b = new Array(n), r = new Array(n);
    a[0] = 0, b[0] = 2, r[0] = x2[0] + 2 * x2[1];
    for (i2 = 1; i2 < n - 1; ++i2)
      a[i2] = 1, b[i2] = 4, r[i2] = 4 * x2[i2] + 2 * x2[i2 + 1];
    a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x2[n - 1] + x2[n];
    for (i2 = 1; i2 < n; ++i2)
      m = a[i2] / b[i2 - 1], b[i2] -= m, r[i2] -= m * r[i2 - 1];
    a[n - 1] = r[n - 1] / b[n - 1];
    for (i2 = n - 2; i2 >= 0; --i2)
      a[i2] = (r[i2] - a[i2 + 1]) / b[i2];
    b[n - 1] = (x2[n] + a[n - 1]) / 2;
    for (i2 = 0; i2 < n - 1; ++i2)
      b[i2] = 2 * x2[i2 + 1] - a[i2 + 1];
    return [a, b];
  }
  function curveNatural(context) {
    return new Natural(context);
  }
  function Step(context, t) {
    this._context = context;
    this._t = t;
  }
  Step.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = this._y = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (0 < this._t && this._t < 1 && this._point === 2)
        this._context.lineTo(this._x, this._y);
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      if (this._line >= 0)
        this._t = 1 - this._t, this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default: {
          if (this._t <= 0) {
            this._context.lineTo(this._x, y2);
            this._context.lineTo(x2, y2);
          } else {
            var x1 = this._x * (1 - this._t) + x2 * this._t;
            this._context.lineTo(x1, this._y);
            this._context.lineTo(x1, y2);
          }
          break;
        }
      }
      this._x = x2, this._y = y2;
    }
  };
  function curveStep(context) {
    return new Step(context, 0.5);
  }
  function stepBefore(context) {
    return new Step(context, 0);
  }
  function stepAfter(context) {
    return new Step(context, 1);
  }
  function Transform(k, x2, y2) {
    this.k = k;
    this.x = x2;
    this.y = y2;
  }
  Transform.prototype = {
    constructor: Transform,
    scale: function(k) {
      return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
    },
    translate: function(x2, y2) {
      return x2 === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x2, this.y + this.k * y2);
    },
    apply: function(point2) {
      return [point2[0] * this.k + this.x, point2[1] * this.k + this.y];
    },
    applyX: function(x2) {
      return x2 * this.k + this.x;
    },
    applyY: function(y2) {
      return y2 * this.k + this.y;
    },
    invert: function(location2) {
      return [(location2[0] - this.x) / this.k, (location2[1] - this.y) / this.k];
    },
    invertX: function(x2) {
      return (x2 - this.x) / this.k;
    },
    invertY: function(y2) {
      return (y2 - this.y) / this.k;
    },
    rescaleX: function(x2) {
      return x2.copy().domain(x2.range().map(this.invertX, this).map(x2.invert, x2));
    },
    rescaleY: function(y2) {
      return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
    },
    toString: function() {
      return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
    }
  };
  Transform.prototype;
  /*! @license DOMPurify 3.0.9 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.0.9/LICENSE */
  const {
    entries,
    setPrototypeOf,
    isFrozen,
    getPrototypeOf,
    getOwnPropertyDescriptor
  } = Object;
  let {
    freeze,
    seal,
    create
  } = Object;
  let {
    apply: apply$2,
    construct
  } = typeof Reflect !== "undefined" && Reflect;
  if (!freeze) {
    freeze = function freeze2(x2) {
      return x2;
    };
  }
  if (!seal) {
    seal = function seal2(x2) {
      return x2;
    };
  }
  if (!apply$2) {
    apply$2 = function apply2(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }
  if (!construct) {
    construct = function construct2(Func, args) {
      return new Func(...args);
    };
  }
  const arrayForEach = unapply(Array.prototype.forEach);
  const arrayPop = unapply(Array.prototype.pop);
  const arrayPush$1 = unapply(Array.prototype.push);
  const stringToLowerCase = unapply(String.prototype.toLowerCase);
  const stringToString = unapply(String.prototype.toString);
  const stringMatch = unapply(String.prototype.match);
  const stringReplace = unapply(String.prototype.replace);
  const stringIndexOf = unapply(String.prototype.indexOf);
  const stringTrim = unapply(String.prototype.trim);
  const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
  const regExpTest = unapply(RegExp.prototype.test);
  const typeErrorCreate = unconstruct(TypeError);
  function unapply(func) {
    return function(thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return apply$2(func, thisArg, args);
    };
  }
  function unconstruct(func) {
    return function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return construct(func, args);
    };
  }
  function addToSet(set2, array2) {
    let transformCaseFunc = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : stringToLowerCase;
    if (setPrototypeOf) {
      setPrototypeOf(set2, null);
    }
    let l = array2.length;
    while (l--) {
      let element2 = array2[l];
      if (typeof element2 === "string") {
        const lcElement = transformCaseFunc(element2);
        if (lcElement !== element2) {
          if (!isFrozen(array2)) {
            array2[l] = lcElement;
          }
          element2 = lcElement;
        }
      }
      set2[element2] = true;
    }
    return set2;
  }
  function cleanArray(array2) {
    for (let index2 = 0; index2 < array2.length; index2++) {
      const isPropertyExist = objectHasOwnProperty(array2, index2);
      if (!isPropertyExist) {
        array2[index2] = null;
      }
    }
    return array2;
  }
  function clone$2(object2) {
    const newObject = create(null);
    for (const [property2, value2] of entries(object2)) {
      const isPropertyExist = objectHasOwnProperty(object2, property2);
      if (isPropertyExist) {
        if (Array.isArray(value2)) {
          newObject[property2] = cleanArray(value2);
        } else if (value2 && typeof value2 === "object" && value2.constructor === Object) {
          newObject[property2] = clone$2(value2);
        } else {
          newObject[property2] = value2;
        }
      }
    }
    return newObject;
  }
  function lookupGetter(object2, prop) {
    while (object2 !== null) {
      const desc = getOwnPropertyDescriptor(object2, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }
        if (typeof desc.value === "function") {
          return unapply(desc.value);
        }
      }
      object2 = getPrototypeOf(object2);
    }
    function fallbackValue() {
      return null;
    }
    return fallbackValue;
  }
  const html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
  const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
  const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
  const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
  const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
  const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
  const text$3 = freeze(["#text"]);
  const html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
  const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
  const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
  const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
  const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
  const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  const TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
  const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
  const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
  const IS_ALLOWED_URI = seal(
    /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
    // eslint-disable-line no-useless-escape
  );
  const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  const ATTR_WHITESPACE = seal(
    /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
    // eslint-disable-line no-control-regex
  );
  const DOCTYPE_NAME = seal(/^html$/i);
  var EXPRESSIONS = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    MUSTACHE_EXPR,
    ERB_EXPR,
    TMPLIT_EXPR,
    DATA_ATTR,
    ARIA_ATTR,
    IS_ALLOWED_URI,
    IS_SCRIPT_OR_DATA,
    ATTR_WHITESPACE,
    DOCTYPE_NAME
  });
  const getGlobal = function getGlobal2() {
    return typeof window === "undefined" ? null : window;
  };
  const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
    if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
      return null;
    }
    let suffix = null;
    const ATTR_NAME = "data-tt-policy-suffix";
    if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
      suffix = purifyHostElement.getAttribute(ATTR_NAME);
    }
    const policyName = "dompurify" + (suffix ? "#" + suffix : "");
    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML(html2) {
          return html2;
        },
        createScriptURL(scriptUrl) {
          return scriptUrl;
        }
      });
    } catch (_2) {
      console.warn("TrustedTypes policy " + policyName + " could not be created.");
      return null;
    }
  };
  function createDOMPurify() {
    let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
    const DOMPurify = (root2) => createDOMPurify(root2);
    DOMPurify.version = "3.0.9";
    DOMPurify.removed = [];
    if (!window2 || !window2.document || window2.document.nodeType !== 9) {
      DOMPurify.isSupported = false;
      return DOMPurify;
    }
    let {
      document: document2
    } = window2;
    const originalDocument = document2;
    const currentScript = originalDocument.currentScript;
    const {
      DocumentFragment: DocumentFragment2,
      HTMLTemplateElement,
      Node,
      Element,
      NodeFilter,
      NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
      HTMLFormElement,
      DOMParser: DOMParser2,
      trustedTypes
    } = window2;
    const ElementPrototype = Element.prototype;
    const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
    const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
    const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
    const getParentNode = lookupGetter(ElementPrototype, "parentNode");
    if (typeof HTMLTemplateElement === "function") {
      const template = document2.createElement("template");
      if (template.content && template.content.ownerDocument) {
        document2 = template.content.ownerDocument;
      }
    }
    let trustedTypesPolicy;
    let emptyHTML = "";
    const {
      implementation,
      createNodeIterator,
      createDocumentFragment,
      getElementsByTagName
    } = document2;
    const {
      importNode
    } = originalDocument;
    let hooks = {};
    DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
    const {
      MUSTACHE_EXPR: MUSTACHE_EXPR2,
      ERB_EXPR: ERB_EXPR2,
      TMPLIT_EXPR: TMPLIT_EXPR2,
      DATA_ATTR: DATA_ATTR2,
      ARIA_ATTR: ARIA_ATTR2,
      IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
      ATTR_WHITESPACE: ATTR_WHITESPACE2
    } = EXPRESSIONS;
    let {
      IS_ALLOWED_URI: IS_ALLOWED_URI$1
    } = EXPRESSIONS;
    let ALLOWED_TAGS = null;
    const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text$3]);
    let ALLOWED_ATTR = null;
    const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
    let CUSTOM_ELEMENT_HANDLING = Object.seal(create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));
    let FORBID_TAGS = null;
    let FORBID_ATTR = null;
    let ALLOW_ARIA_ATTR = true;
    let ALLOW_DATA_ATTR = true;
    let ALLOW_UNKNOWN_PROTOCOLS = false;
    let ALLOW_SELF_CLOSE_IN_ATTR = true;
    let SAFE_FOR_TEMPLATES = false;
    let WHOLE_DOCUMENT = false;
    let SET_CONFIG = false;
    let FORCE_BODY = false;
    let RETURN_DOM = false;
    let RETURN_DOM_FRAGMENT = false;
    let RETURN_TRUSTED_TYPE = false;
    let SANITIZE_DOM = true;
    let SANITIZE_NAMED_PROPS = false;
    const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
    let KEEP_CONTENT = true;
    let IN_PLACE = false;
    let USE_PROFILES = {};
    let FORBID_CONTENTS = null;
    const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
    let DATA_URI_TAGS = null;
    const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
    let URI_SAFE_ATTRIBUTES = null;
    const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
    const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    let NAMESPACE = HTML_NAMESPACE;
    let IS_EMPTY_INPUT = false;
    let ALLOWED_NAMESPACES = null;
    const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
    let PARSER_MEDIA_TYPE = null;
    const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
    const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
    let transformCaseFunc = null;
    let CONFIG = null;
    const formElement = document2.createElement("form");
    const isRegexOrFunction = function isRegexOrFunction2(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };
    const _parseConfig = function _parseConfig2() {
      let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      if (CONFIG && CONFIG === cfg) {
        return;
      }
      if (!cfg || typeof cfg !== "object") {
        cfg = {};
      }
      cfg = clone$2(cfg);
      PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
      SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;
      transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
      ALLOWED_TAGS = objectHasOwnProperty(cfg, "ALLOWED_TAGS") ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = objectHasOwnProperty(cfg, "ALLOWED_ATTR") ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, "ALLOWED_NAMESPACES") ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
      URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, "ADD_URI_SAFE_ATTR") ? addToSet(
        clone$2(DEFAULT_URI_SAFE_ATTRIBUTES),
        // eslint-disable-line indent
        cfg.ADD_URI_SAFE_ATTR,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = objectHasOwnProperty(cfg, "ADD_DATA_URI_TAGS") ? addToSet(
        clone$2(DEFAULT_DATA_URI_TAGS),
        // eslint-disable-line indent
        cfg.ADD_DATA_URI_TAGS,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = objectHasOwnProperty(cfg, "FORBID_CONTENTS") ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = objectHasOwnProperty(cfg, "FORBID_TAGS") ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = objectHasOwnProperty(cfg, "FORBID_ATTR") ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = objectHasOwnProperty(cfg, "USE_PROFILES") ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
      ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
      RETURN_DOM = cfg.RETURN_DOM || false;
      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
      FORCE_BODY = cfg.FORCE_BODY || false;
      SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
      SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
      KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
      IN_PLACE = cfg.IN_PLACE || false;
      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
      CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }
      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }
      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }
      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, text$3);
        ALLOWED_ATTR = [];
        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html);
        }
        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }
      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone$2(ALLOWED_TAGS);
        }
        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }
      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone$2(ALLOWED_ATTR);
        }
        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }
      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }
      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone$2(FORBID_CONTENTS);
        }
        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }
      if (KEEP_CONTENT) {
        ALLOWED_TAGS["#text"] = true;
      }
      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
      }
      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ["tbody"]);
        delete FORBID_TAGS.tbody;
      }
      if (cfg.TRUSTED_TYPES_POLICY) {
        if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
        }
        if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
        }
        trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
        emptyHTML = trustedTypesPolicy.createHTML("");
      } else {
        if (trustedTypesPolicy === void 0) {
          trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
        }
        if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
          emptyHTML = trustedTypesPolicy.createHTML("");
        }
      }
      if (freeze) {
        freeze(cfg);
      }
      CONFIG = cfg;
    };
    const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
    const HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
    const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
    const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
    const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);
    const _checkValidNamespace = function _checkValidNamespace2(element2) {
      let parent = getParentNode(element2);
      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: NAMESPACE,
          tagName: "template"
        };
      }
      const tagName = stringToLowerCase(element2.tagName);
      const parentTagName = stringToLowerCase(parent.tagName);
      if (!ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return false;
      }
      if (element2.namespaceURI === SVG_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "svg";
        }
        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        }
        return Boolean(ALL_SVG_TAGS[tagName]);
      }
      if (element2.namespaceURI === MATHML_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "math";
        }
        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
        }
        return Boolean(ALL_MATHML_TAGS[tagName]);
      }
      if (element2.namespaceURI === HTML_NAMESPACE) {
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return true;
      }
      return false;
    };
    const _forceRemove = function _forceRemove2(node2) {
      arrayPush$1(DOMPurify.removed, {
        element: node2
      });
      try {
        node2.parentNode.removeChild(node2);
      } catch (_2) {
        node2.remove();
      }
    };
    const _removeAttribute = function _removeAttribute2(name, node2) {
      try {
        arrayPush$1(DOMPurify.removed, {
          attribute: node2.getAttributeNode(name),
          from: node2
        });
      } catch (_2) {
        arrayPush$1(DOMPurify.removed, {
          attribute: null,
          from: node2
        });
      }
      node2.removeAttribute(name);
      if (name === "is" && !ALLOWED_ATTR[name]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node2);
          } catch (_2) {
          }
        } else {
          try {
            node2.setAttribute(name, "");
          } catch (_2) {
          }
        }
      }
    };
    const _initDocument = function _initDocument2(dirty) {
      let doc = null;
      let leadingWhitespace = null;
      if (FORCE_BODY) {
        dirty = "<remove></remove>" + dirty;
      } else {
        const matches = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches && matches[0];
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
      }
      const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_2) {
        }
      }
      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, "template", null);
        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
        } catch (_2) {
        }
      }
      const body = doc.body || doc.documentElement;
      if (dirty && leadingWhitespace) {
        body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }
      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
      }
      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };
    const _createNodeIterator = function _createNodeIterator2(root2) {
      return createNodeIterator.call(
        root2.ownerDocument || root2,
        root2,
        // eslint-disable-next-line no-bitwise
        NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
        null
      );
    };
    const _isClobbered = function _isClobbered2(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
    };
    const _isNode = function _isNode2(object2) {
      return typeof Node === "function" && object2 instanceof Node;
    };
    const _executeHook = function _executeHook2(entryPoint, currentNode, data) {
      if (!hooks[entryPoint]) {
        return;
      }
      arrayForEach(hooks[entryPoint], (hook) => {
        hook.call(DOMPurify, currentNode, data, CONFIG);
      });
    };
    const _sanitizeElements = function _sanitizeElements2(currentNode) {
      let content2 = null;
      _executeHook("beforeSanitizeElements", currentNode, null);
      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      const tagName = transformCaseFunc(currentNode.nodeName);
      _executeHook("uponSanitizeElement", currentNode, {
        tagName,
        allowedTags: ALLOWED_TAGS
      });
      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);
        return true;
      }
      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        if (!FORBID_TAGS[tagName] && _isBasicCustomElement(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) {
            return false;
          }
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) {
            return false;
          }
        }
        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          const parentNode = getParentNode(currentNode) || currentNode.parentNode;
          const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
          if (childNodes && parentNode) {
            const childCount = childNodes.length;
            for (let i2 = childCount - 1; i2 >= 0; --i2) {
              parentNode.insertBefore(cloneNode(childNodes[i2], true), getNextSibling(currentNode));
            }
          }
        }
        _forceRemove(currentNode);
        return true;
      }
      if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }
      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
        content2 = currentNode.textContent;
        arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
          content2 = stringReplace(content2, expr, " ");
        });
        if (currentNode.textContent !== content2) {
          arrayPush$1(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content2;
        }
      }
      _executeHook("afterSanitizeElements", currentNode, null);
      return false;
    };
    const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value2) {
      if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value2 in document2 || value2 in formElement)) {
        return false;
      }
      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName))
        ;
      else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName))
        ;
      else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if (
          // First condition does a very basic check if a) it's basically a valid custom element tagname AND
          // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
          _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
          // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value2) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value2))
        )
          ;
        else {
          return false;
        }
      } else if (URI_SAFE_ATTRIBUTES[lcName])
        ;
      else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value2, ATTR_WHITESPACE2, "")))
        ;
      else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value2, "data:") === 0 && DATA_URI_TAGS[lcTag])
        ;
      else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value2, ATTR_WHITESPACE2, "")))
        ;
      else if (value2) {
        return false;
      } else
        ;
      return true;
    };
    const _isBasicCustomElement = function _isBasicCustomElement2(tagName) {
      return tagName !== "annotation-xml" && tagName.indexOf("-") > 0;
    };
    const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
      _executeHook("beforeSanitizeAttributes", currentNode, null);
      const {
        attributes
      } = currentNode;
      if (!attributes) {
        return;
      }
      const hookEvent = {
        attrName: "",
        attrValue: "",
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      let l = attributes.length;
      while (l--) {
        const attr = attributes[l];
        const {
          name,
          namespaceURI,
          value: attrValue
        } = attr;
        const lcName = transformCaseFunc(name);
        let value2 = name === "value" ? attrValue : stringTrim(attrValue);
        hookEvent.attrName = lcName;
        hookEvent.attrValue = value2;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = void 0;
        _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
        value2 = hookEvent.attrValue;
        if (hookEvent.forceKeepAttr) {
          continue;
        }
        _removeAttribute(name, currentNode);
        if (!hookEvent.keepAttr) {
          continue;
        }
        if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value2)) {
          _removeAttribute(name, currentNode);
          continue;
        }
        if (SAFE_FOR_TEMPLATES) {
          arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
            value2 = stringReplace(value2, expr, " ");
          });
        }
        const lcTag = transformCaseFunc(currentNode.nodeName);
        if (!_isValidAttribute(lcTag, lcName, value2)) {
          continue;
        }
        if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
          _removeAttribute(name, currentNode);
          value2 = SANITIZE_NAMED_PROPS_PREFIX + value2;
        }
        if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
          if (namespaceURI)
            ;
          else {
            switch (trustedTypes.getAttributeType(lcTag, lcName)) {
              case "TrustedHTML": {
                value2 = trustedTypesPolicy.createHTML(value2);
                break;
              }
              case "TrustedScriptURL": {
                value2 = trustedTypesPolicy.createScriptURL(value2);
                break;
              }
            }
          }
        }
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name, value2);
          } else {
            currentNode.setAttribute(name, value2);
          }
          arrayPop(DOMPurify.removed);
        } catch (_2) {
        }
      }
      _executeHook("afterSanitizeAttributes", currentNode, null);
    };
    const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
      let shadowNode = null;
      const shadowIterator = _createNodeIterator(fragment);
      _executeHook("beforeSanitizeShadowDOM", fragment, null);
      while (shadowNode = shadowIterator.nextNode()) {
        _executeHook("uponSanitizeShadowNode", shadowNode, null);
        if (_sanitizeElements(shadowNode)) {
          continue;
        }
        if (shadowNode.content instanceof DocumentFragment2) {
          _sanitizeShadowDOM2(shadowNode.content);
        }
        _sanitizeAttributes(shadowNode);
      }
      _executeHook("afterSanitizeShadowDOM", fragment, null);
    };
    DOMPurify.sanitize = function(dirty) {
      let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      let body = null;
      let importedNode = null;
      let currentNode = null;
      let returnNode = null;
      IS_EMPTY_INPUT = !dirty;
      if (IS_EMPTY_INPUT) {
        dirty = "<!-->";
      }
      if (typeof dirty !== "string" && !_isNode(dirty)) {
        if (typeof dirty.toString === "function") {
          dirty = dirty.toString();
          if (typeof dirty !== "string") {
            throw typeErrorCreate("dirty is not a string, aborting");
          }
        } else {
          throw typeErrorCreate("toString is not a function");
        }
      }
      if (!DOMPurify.isSupported) {
        return dirty;
      }
      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }
      DOMPurify.removed = [];
      if (typeof dirty === "string") {
        IN_PLACE = false;
      }
      if (IN_PLACE) {
        if (dirty.nodeName) {
          const tagName = transformCaseFunc(dirty.nodeName);
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
          }
        }
      } else if (dirty instanceof Node) {
        body = _initDocument("<!---->");
        importedNode = body.ownerDocument.importNode(dirty, true);
        if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
          body = importedNode;
        } else if (importedNode.nodeName === "HTML") {
          body = importedNode;
        } else {
          body.appendChild(importedNode);
        }
      } else {
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
        dirty.indexOf("<") === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }
        body = _initDocument(dirty);
        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
        }
      }
      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }
      const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body);
      while (currentNode = nodeIterator.nextNode()) {
        if (_sanitizeElements(currentNode)) {
          continue;
        }
        if (currentNode.content instanceof DocumentFragment2) {
          _sanitizeShadowDOM(currentNode.content);
        }
        _sanitizeAttributes(currentNode);
      }
      if (IN_PLACE) {
        return dirty;
      }
      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);
          while (body.firstChild) {
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }
        if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
          returnNode = importNode.call(originalDocument, returnNode, true);
        }
        return returnNode;
      }
      let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
      if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
      }
      if (SAFE_FOR_TEMPLATES) {
        arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
          serializedHTML = stringReplace(serializedHTML, expr, " ");
        });
      }
      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };
    DOMPurify.setConfig = function() {
      let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      _parseConfig(cfg);
      SET_CONFIG = true;
    };
    DOMPurify.clearConfig = function() {
      CONFIG = null;
      SET_CONFIG = false;
    };
    DOMPurify.isValidAttribute = function(tag, attr, value2) {
      if (!CONFIG) {
        _parseConfig({});
      }
      const lcTag = transformCaseFunc(tag);
      const lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value2);
    };
    DOMPurify.addHook = function(entryPoint, hookFunction) {
      if (typeof hookFunction !== "function") {
        return;
      }
      hooks[entryPoint] = hooks[entryPoint] || [];
      arrayPush$1(hooks[entryPoint], hookFunction);
    };
    DOMPurify.removeHook = function(entryPoint) {
      if (hooks[entryPoint]) {
        return arrayPop(hooks[entryPoint]);
      }
    };
    DOMPurify.removeHooks = function(entryPoint) {
      if (hooks[entryPoint]) {
        hooks[entryPoint] = [];
      }
    };
    DOMPurify.removeAllHooks = function() {
      hooks = {};
    };
    return DOMPurify;
  }
  var purify = createDOMPurify();
  const lineBreakRegex = /<br\s*\/?>/gi;
  const getRows = (s) => {
    if (!s) {
      return [""];
    }
    const str2 = breakToPlaceholder(s).replace(/\\n/g, "#br#");
    return str2.split("#br#");
  };
  const setupDompurifyHooksIfNotSetup = (() => {
    let setup = false;
    return () => {
      if (!setup) {
        setupDompurifyHooks();
        setup = true;
      }
    };
  })();
  function setupDompurifyHooks() {
    const TEMPORARY_ATTRIBUTE = "data-temp-href-target";
    purify.addHook("beforeSanitizeAttributes", (node2) => {
      if (node2.tagName === "A" && node2.hasAttribute("target")) {
        node2.setAttribute(TEMPORARY_ATTRIBUTE, node2.getAttribute("target") || "");
      }
    });
    purify.addHook("afterSanitizeAttributes", (node2) => {
      if (node2.tagName === "A" && node2.hasAttribute(TEMPORARY_ATTRIBUTE)) {
        node2.setAttribute("target", node2.getAttribute(TEMPORARY_ATTRIBUTE) || "");
        node2.removeAttribute(TEMPORARY_ATTRIBUTE);
        if (node2.getAttribute("target") === "_blank") {
          node2.setAttribute("rel", "noopener");
        }
      }
    });
  }
  const removeScript = (txt) => {
    setupDompurifyHooksIfNotSetup();
    const sanitizedText = purify.sanitize(txt);
    return sanitizedText;
  };
  const sanitizeMore = (text2, config2) => {
    var _a2;
    if (((_a2 = config2.flowchart) == null ? void 0 : _a2.htmlLabels) !== false) {
      const level = config2.securityLevel;
      if (level === "antiscript" || level === "strict") {
        text2 = removeScript(text2);
      } else if (level !== "loose") {
        text2 = breakToPlaceholder(text2);
        text2 = text2.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        text2 = text2.replace(/=/g, "&equals;");
        text2 = placeholderToBreak(text2);
      }
    }
    return text2;
  };
  const sanitizeText$5 = (text2, config2) => {
    if (!text2) {
      return text2;
    }
    if (config2.dompurifyConfig) {
      text2 = purify.sanitize(sanitizeMore(text2, config2), config2.dompurifyConfig).toString();
    } else {
      text2 = purify.sanitize(sanitizeMore(text2, config2), {
        FORBID_TAGS: ["style"]
      }).toString();
    }
    return text2;
  };
  const sanitizeTextOrArray = (a, config2) => {
    if (typeof a === "string") {
      return sanitizeText$5(a, config2);
    }
    return a.flat().map((x2) => sanitizeText$5(x2, config2));
  };
  const hasBreaks = (text2) => {
    return lineBreakRegex.test(text2);
  };
  const splitBreaks = (text2) => {
    return text2.split(lineBreakRegex);
  };
  const placeholderToBreak = (s) => {
    return s.replace(/#br#/g, "<br/>");
  };
  const breakToPlaceholder = (s) => {
    return s.replace(lineBreakRegex, "#br#");
  };
  const getUrl = (useAbsolute) => {
    let url = "";
    if (useAbsolute) {
      url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
      url = url.replaceAll(/\(/g, "\\(");
      url = url.replaceAll(/\)/g, "\\)");
    }
    return url;
  };
  const evaluate = (val) => val === false || ["false", "null", "0"].includes(String(val).trim().toLowerCase()) ? false : true;
  const getMax = function(...values2) {
    const newValues = values2.filter((value2) => {
      return !isNaN(value2);
    });
    return Math.max(...newValues);
  };
  const getMin = function(...values2) {
    const newValues = values2.filter((value2) => {
      return !isNaN(value2);
    });
    return Math.min(...newValues);
  };
  const parseGenericTypes = function(input) {
    const inputSets = input.split(/(,)/);
    const output = [];
    for (let i2 = 0; i2 < inputSets.length; i2++) {
      let thisSet = inputSets[i2];
      if (thisSet === "," && i2 > 0 && i2 + 1 < inputSets.length) {
        const previousSet = inputSets[i2 - 1];
        const nextSet = inputSets[i2 + 1];
        if (shouldCombineSets(previousSet, nextSet)) {
          thisSet = previousSet + "," + nextSet;
          i2++;
          output.pop();
        }
      }
      output.push(processSet(thisSet));
    }
    return output.join("");
  };
  const countOccurrence = (string2, substring) => {
    return Math.max(0, string2.split(substring).length - 1);
  };
  const shouldCombineSets = (previousSet, nextSet) => {
    const prevCount = countOccurrence(previousSet, "~");
    const nextCount = countOccurrence(nextSet, "~");
    return prevCount === 1 && nextCount === 1;
  };
  const processSet = (input) => {
    const tildeCount = countOccurrence(input, "~");
    let hasStartingTilde = false;
    if (tildeCount <= 1) {
      return input;
    }
    if (tildeCount % 2 !== 0 && input.startsWith("~")) {
      input = input.substring(1);
      hasStartingTilde = true;
    }
    const chars = [...input];
    let first = chars.indexOf("~");
    let last2 = chars.lastIndexOf("~");
    while (first !== -1 && last2 !== -1 && first !== last2) {
      chars[first] = "<";
      chars[last2] = ">";
      first = chars.indexOf("~");
      last2 = chars.lastIndexOf("~");
    }
    if (hasStartingTilde) {
      chars.unshift("~");
    }
    return chars.join("");
  };
  const isMathMLSupported = () => window.MathMLElement !== void 0;
  const katexRegex = /\$\$(.*)\$\$/g;
  const hasKatex = (text2) => {
    var _a2;
    return (((_a2 = text2.match(katexRegex)) == null ? void 0 : _a2.length) ?? 0) > 0;
  };
  const calculateMathMLDimensions = async (text2, config2) => {
    text2 = await renderKatex(text2, config2);
    const divElem = document.createElement("div");
    divElem.innerHTML = text2;
    divElem.id = "katex-temp";
    divElem.style.visibility = "hidden";
    divElem.style.position = "absolute";
    divElem.style.top = "0";
    const body = document.querySelector("body");
    body == null ? void 0 : body.insertAdjacentElement("beforeend", divElem);
    const dim = { width: divElem.clientWidth, height: divElem.clientHeight };
    divElem.remove();
    return dim;
  };
  const renderKatex = async (text2, config2) => {
    if (!hasKatex(text2)) {
      return text2;
    }
    if (!isMathMLSupported() && !config2.legacyMathML) {
      return text2.replace(katexRegex, "MathML is unsupported in this environment.");
    }
    const { default: katex2 } = await Promise.resolve().then(() => katex$1);
    return text2.split(lineBreakRegex).map(
      (line2) => hasKatex(line2) ? `
            <div style="display: flex; align-items: center; justify-content: center; white-space: nowrap;">
              ${line2}
            </div>
          ` : `<div>${line2}</div>`
    ).join("").replace(
      katexRegex,
      (_2, c2) => katex2.renderToString(c2, {
        throwOnError: true,
        displayMode: true,
        output: isMathMLSupported() ? "mathml" : "htmlAndMathml"
      }).replace(/\n/g, " ").replace(/<annotation.*<\/annotation>/g, "")
    );
  };
  const common$1 = {
    getRows,
    sanitizeText: sanitizeText$5,
    sanitizeTextOrArray,
    hasBreaks,
    splitBreaks,
    lineBreakRegex,
    removeScript,
    getUrl,
    evaluate,
    getMax,
    getMin
  };
  const Channel = {
    /* CLAMP */
    min: {
      r: 0,
      g: 0,
      b: 0,
      s: 0,
      l: 0,
      a: 0
    },
    max: {
      r: 255,
      g: 255,
      b: 255,
      h: 360,
      s: 100,
      l: 100,
      a: 1
    },
    clamp: {
      r: (r) => r >= 255 ? 255 : r < 0 ? 0 : r,
      g: (g) => g >= 255 ? 255 : g < 0 ? 0 : g,
      b: (b) => b >= 255 ? 255 : b < 0 ? 0 : b,
      h: (h) => h % 360,
      s: (s) => s >= 100 ? 100 : s < 0 ? 0 : s,
      l: (l) => l >= 100 ? 100 : l < 0 ? 0 : l,
      a: (a) => a >= 1 ? 1 : a < 0 ? 0 : a
    },
    /* CONVERSION */
    //SOURCE: https://planetcalc.com/7779
    toLinear: (c2) => {
      const n = c2 / 255;
      return c2 > 0.03928 ? Math.pow((n + 0.055) / 1.055, 2.4) : n / 12.92;
    },
    //SOURCE: https://gist.github.com/mjackson/5311256
    hue2rgb: (p, q, t) => {
      if (t < 0)
        t += 1;
      if (t > 1)
        t -= 1;
      if (t < 1 / 6)
        return p + (q - p) * 6 * t;
      if (t < 1 / 2)
        return q;
      if (t < 2 / 3)
        return p + (q - p) * (2 / 3 - t) * 6;
      return p;
    },
    hsl2rgb: ({ h, s, l }, channel2) => {
      if (!s)
        return l * 2.55;
      h /= 360;
      s /= 100;
      l /= 100;
      const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      const p = 2 * l - q;
      switch (channel2) {
        case "r":
          return Channel.hue2rgb(p, q, h + 1 / 3) * 255;
        case "g":
          return Channel.hue2rgb(p, q, h) * 255;
        case "b":
          return Channel.hue2rgb(p, q, h - 1 / 3) * 255;
      }
    },
    rgb2hsl: ({ r, g, b }, channel2) => {
      r /= 255;
      g /= 255;
      b /= 255;
      const max2 = Math.max(r, g, b);
      const min2 = Math.min(r, g, b);
      const l = (max2 + min2) / 2;
      if (channel2 === "l")
        return l * 100;
      if (max2 === min2)
        return 0;
      const d = max2 - min2;
      const s = l > 0.5 ? d / (2 - max2 - min2) : d / (max2 + min2);
      if (channel2 === "s")
        return s * 100;
      switch (max2) {
        case r:
          return ((g - b) / d + (g < b ? 6 : 0)) * 60;
        case g:
          return ((b - r) / d + 2) * 60;
        case b:
          return ((r - g) / d + 4) * 60;
        default:
          return -1;
      }
    }
  };
  const channel$2 = Channel;
  const Lang = {
    /* API */
    clamp: (number2, lower2, upper) => {
      if (lower2 > upper)
        return Math.min(lower2, Math.max(upper, number2));
      return Math.min(upper, Math.max(lower2, number2));
    },
    round: (number2) => {
      return Math.round(number2 * 1e10) / 1e10;
    }
  };
  const lang = Lang;
  const Unit = {
    /* API */
    dec2hex: (dec) => {
      const hex2 = Math.round(dec).toString(16);
      return hex2.length > 1 ? hex2 : `0${hex2}`;
    }
  };
  const unit = Unit;
  const Utils = {
    channel: channel$2,
    lang,
    unit
  };
  const _ = Utils;
  const DEC2HEX = {};
  for (let i2 = 0; i2 <= 255; i2++)
    DEC2HEX[i2] = _.unit.dec2hex(i2);
  const TYPE = {
    ALL: 0,
    RGB: 1,
    HSL: 2
  };
  class Type {
    constructor() {
      this.type = TYPE.ALL;
    }
    /* API */
    get() {
      return this.type;
    }
    set(type2) {
      if (this.type && this.type !== type2)
        throw new Error("Cannot change both RGB and HSL channels at the same time");
      this.type = type2;
    }
    reset() {
      this.type = TYPE.ALL;
    }
    is(type2) {
      return this.type === type2;
    }
  }
  const Type$2 = Type;
  class Channels {
    /* CONSTRUCTOR */
    constructor(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type = new Type$2();
    }
    /* API */
    set(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type.type = TYPE.ALL;
      return this;
    }
    /* HELPERS */
    _ensureHSL() {
      const data = this.data;
      const { h, s, l } = data;
      if (h === void 0)
        data.h = _.channel.rgb2hsl(data, "h");
      if (s === void 0)
        data.s = _.channel.rgb2hsl(data, "s");
      if (l === void 0)
        data.l = _.channel.rgb2hsl(data, "l");
    }
    _ensureRGB() {
      const data = this.data;
      const { r, g, b } = data;
      if (r === void 0)
        data.r = _.channel.hsl2rgb(data, "r");
      if (g === void 0)
        data.g = _.channel.hsl2rgb(data, "g");
      if (b === void 0)
        data.b = _.channel.hsl2rgb(data, "b");
    }
    /* GETTERS */
    get r() {
      const data = this.data;
      const r = data.r;
      if (!this.type.is(TYPE.HSL) && r !== void 0)
        return r;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "r");
    }
    get g() {
      const data = this.data;
      const g = data.g;
      if (!this.type.is(TYPE.HSL) && g !== void 0)
        return g;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "g");
    }
    get b() {
      const data = this.data;
      const b = data.b;
      if (!this.type.is(TYPE.HSL) && b !== void 0)
        return b;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "b");
    }
    get h() {
      const data = this.data;
      const h = data.h;
      if (!this.type.is(TYPE.RGB) && h !== void 0)
        return h;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "h");
    }
    get s() {
      const data = this.data;
      const s = data.s;
      if (!this.type.is(TYPE.RGB) && s !== void 0)
        return s;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "s");
    }
    get l() {
      const data = this.data;
      const l = data.l;
      if (!this.type.is(TYPE.RGB) && l !== void 0)
        return l;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "l");
    }
    get a() {
      return this.data.a;
    }
    /* SETTERS */
    set r(r) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.r = r;
    }
    set g(g) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.g = g;
    }
    set b(b) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.b = b;
    }
    set h(h) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.h = h;
    }
    set s(s) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.s = s;
    }
    set l(l) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.l = l;
    }
    set a(a) {
      this.changed = true;
      this.data.a = a;
    }
  }
  const Channels$1 = Channels;
  const channels = new Channels$1({ r: 0, g: 0, b: 0, a: 0 }, "transparent");
  const ChannelsReusable = channels;
  const Hex = {
    /* VARIABLES */
    re: /^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,
    /* API */
    parse: (color2) => {
      if (color2.charCodeAt(0) !== 35)
        return;
      const match = color2.match(Hex.re);
      if (!match)
        return;
      const hex2 = match[1];
      const dec = parseInt(hex2, 16);
      const length2 = hex2.length;
      const hasAlpha = length2 % 4 === 0;
      const isFullLength = length2 > 4;
      const multiplier = isFullLength ? 1 : 17;
      const bits = isFullLength ? 8 : 4;
      const bitsOffset = hasAlpha ? 0 : -1;
      const mask = isFullLength ? 255 : 15;
      return ChannelsReusable.set({
        r: (dec >> bits * (bitsOffset + 3) & mask) * multiplier,
        g: (dec >> bits * (bitsOffset + 2) & mask) * multiplier,
        b: (dec >> bits * (bitsOffset + 1) & mask) * multiplier,
        a: hasAlpha ? (dec & mask) * multiplier / 255 : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}${DEC2HEX[Math.round(a * 255)]}`;
      } else {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}`;
      }
    }
  };
  const Hex$1 = Hex;
  const HSL = {
    /* VARIABLES */
    re: /^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,
    hueRe: /^(.+?)(deg|grad|rad|turn)$/i,
    /* HELPERS */
    _hue2deg: (hue2) => {
      const match = hue2.match(HSL.hueRe);
      if (match) {
        const [, number2, unit2] = match;
        switch (unit2) {
          case "grad":
            return _.channel.clamp.h(parseFloat(number2) * 0.9);
          case "rad":
            return _.channel.clamp.h(parseFloat(number2) * 180 / Math.PI);
          case "turn":
            return _.channel.clamp.h(parseFloat(number2) * 360);
        }
      }
      return _.channel.clamp.h(parseFloat(hue2));
    },
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 104 && charCode !== 72)
        return;
      const match = color2.match(HSL.re);
      if (!match)
        return;
      const [, h, s, l, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        h: HSL._hue2deg(h),
        s: _.channel.clamp.s(parseFloat(s)),
        l: _.channel.clamp.l(parseFloat(l)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { h, s, l, a } = channels2;
      if (a < 1) {
        return `hsla(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%, ${a})`;
      } else {
        return `hsl(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%)`;
      }
    }
  };
  const HSL$1 = HSL;
  const Keyword = {
    /* VARIABLES */
    colors: {
      aliceblue: "#f0f8ff",
      antiquewhite: "#faebd7",
      aqua: "#00ffff",
      aquamarine: "#7fffd4",
      azure: "#f0ffff",
      beige: "#f5f5dc",
      bisque: "#ffe4c4",
      black: "#000000",
      blanchedalmond: "#ffebcd",
      blue: "#0000ff",
      blueviolet: "#8a2be2",
      brown: "#a52a2a",
      burlywood: "#deb887",
      cadetblue: "#5f9ea0",
      chartreuse: "#7fff00",
      chocolate: "#d2691e",
      coral: "#ff7f50",
      cornflowerblue: "#6495ed",
      cornsilk: "#fff8dc",
      crimson: "#dc143c",
      cyanaqua: "#00ffff",
      darkblue: "#00008b",
      darkcyan: "#008b8b",
      darkgoldenrod: "#b8860b",
      darkgray: "#a9a9a9",
      darkgreen: "#006400",
      darkgrey: "#a9a9a9",
      darkkhaki: "#bdb76b",
      darkmagenta: "#8b008b",
      darkolivegreen: "#556b2f",
      darkorange: "#ff8c00",
      darkorchid: "#9932cc",
      darkred: "#8b0000",
      darksalmon: "#e9967a",
      darkseagreen: "#8fbc8f",
      darkslateblue: "#483d8b",
      darkslategray: "#2f4f4f",
      darkslategrey: "#2f4f4f",
      darkturquoise: "#00ced1",
      darkviolet: "#9400d3",
      deeppink: "#ff1493",
      deepskyblue: "#00bfff",
      dimgray: "#696969",
      dimgrey: "#696969",
      dodgerblue: "#1e90ff",
      firebrick: "#b22222",
      floralwhite: "#fffaf0",
      forestgreen: "#228b22",
      fuchsia: "#ff00ff",
      gainsboro: "#dcdcdc",
      ghostwhite: "#f8f8ff",
      gold: "#ffd700",
      goldenrod: "#daa520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#adff2f",
      grey: "#808080",
      honeydew: "#f0fff0",
      hotpink: "#ff69b4",
      indianred: "#cd5c5c",
      indigo: "#4b0082",
      ivory: "#fffff0",
      khaki: "#f0e68c",
      lavender: "#e6e6fa",
      lavenderblush: "#fff0f5",
      lawngreen: "#7cfc00",
      lemonchiffon: "#fffacd",
      lightblue: "#add8e6",
      lightcoral: "#f08080",
      lightcyan: "#e0ffff",
      lightgoldenrodyellow: "#fafad2",
      lightgray: "#d3d3d3",
      lightgreen: "#90ee90",
      lightgrey: "#d3d3d3",
      lightpink: "#ffb6c1",
      lightsalmon: "#ffa07a",
      lightseagreen: "#20b2aa",
      lightskyblue: "#87cefa",
      lightslategray: "#778899",
      lightslategrey: "#778899",
      lightsteelblue: "#b0c4de",
      lightyellow: "#ffffe0",
      lime: "#00ff00",
      limegreen: "#32cd32",
      linen: "#faf0e6",
      magenta: "#ff00ff",
      maroon: "#800000",
      mediumaquamarine: "#66cdaa",
      mediumblue: "#0000cd",
      mediumorchid: "#ba55d3",
      mediumpurple: "#9370db",
      mediumseagreen: "#3cb371",
      mediumslateblue: "#7b68ee",
      mediumspringgreen: "#00fa9a",
      mediumturquoise: "#48d1cc",
      mediumvioletred: "#c71585",
      midnightblue: "#191970",
      mintcream: "#f5fffa",
      mistyrose: "#ffe4e1",
      moccasin: "#ffe4b5",
      navajowhite: "#ffdead",
      navy: "#000080",
      oldlace: "#fdf5e6",
      olive: "#808000",
      olivedrab: "#6b8e23",
      orange: "#ffa500",
      orangered: "#ff4500",
      orchid: "#da70d6",
      palegoldenrod: "#eee8aa",
      palegreen: "#98fb98",
      paleturquoise: "#afeeee",
      palevioletred: "#db7093",
      papayawhip: "#ffefd5",
      peachpuff: "#ffdab9",
      peru: "#cd853f",
      pink: "#ffc0cb",
      plum: "#dda0dd",
      powderblue: "#b0e0e6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#ff0000",
      rosybrown: "#bc8f8f",
      royalblue: "#4169e1",
      saddlebrown: "#8b4513",
      salmon: "#fa8072",
      sandybrown: "#f4a460",
      seagreen: "#2e8b57",
      seashell: "#fff5ee",
      sienna: "#a0522d",
      silver: "#c0c0c0",
      skyblue: "#87ceeb",
      slateblue: "#6a5acd",
      slategray: "#708090",
      slategrey: "#708090",
      snow: "#fffafa",
      springgreen: "#00ff7f",
      tan: "#d2b48c",
      teal: "#008080",
      thistle: "#d8bfd8",
      transparent: "#00000000",
      turquoise: "#40e0d0",
      violet: "#ee82ee",
      wheat: "#f5deb3",
      white: "#ffffff",
      whitesmoke: "#f5f5f5",
      yellow: "#ffff00",
      yellowgreen: "#9acd32"
    },
    /* API */
    parse: (color2) => {
      color2 = color2.toLowerCase();
      const hex2 = Keyword.colors[color2];
      if (!hex2)
        return;
      return Hex$1.parse(hex2);
    },
    stringify: (channels2) => {
      const hex2 = Hex$1.stringify(channels2);
      for (const name in Keyword.colors) {
        if (Keyword.colors[name] === hex2)
          return name;
      }
      return;
    }
  };
  const Keyword$1 = Keyword;
  const RGB = {
    /* VARIABLES */
    re: /^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 114 && charCode !== 82)
        return;
      const match = color2.match(RGB.re);
      if (!match)
        return;
      const [, r, isRedPercentage, g, isGreenPercentage, b, isBluePercentage, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        r: _.channel.clamp.r(isRedPercentage ? parseFloat(r) * 2.55 : parseFloat(r)),
        g: _.channel.clamp.g(isGreenPercentage ? parseFloat(g) * 2.55 : parseFloat(g)),
        b: _.channel.clamp.b(isBluePercentage ? parseFloat(b) * 2.55 : parseFloat(b)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `rgba(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)}, ${_.lang.round(a)})`;
      } else {
        return `rgb(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)})`;
      }
    }
  };
  const RGB$1 = RGB;
  const Color = {
    /* VARIABLES */
    format: {
      keyword: Keyword$1,
      hex: Hex$1,
      rgb: RGB$1,
      rgba: RGB$1,
      hsl: HSL$1,
      hsla: HSL$1
    },
    /* API */
    parse: (color2) => {
      if (typeof color2 !== "string")
        return color2;
      const channels2 = Hex$1.parse(color2) || RGB$1.parse(color2) || HSL$1.parse(color2) || Keyword$1.parse(color2);
      if (channels2)
        return channels2;
      throw new Error(`Unsupported color format: "${color2}"`);
    },
    stringify: (channels2) => {
      if (!channels2.changed && channels2.color)
        return channels2.color;
      if (channels2.type.is(TYPE.HSL) || channels2.data.r === void 0) {
        return HSL$1.stringify(channels2);
      } else if (channels2.a < 1 || !Number.isInteger(channels2.r) || !Number.isInteger(channels2.g) || !Number.isInteger(channels2.b)) {
        return RGB$1.stringify(channels2);
      } else {
        return Hex$1.stringify(channels2);
      }
    }
  };
  const Color$1 = Color;
  const change = (color2, channels2) => {
    const ch2 = Color$1.parse(color2);
    for (const c2 in channels2) {
      ch2[c2] = _.channel.clamp[c2](channels2[c2]);
    }
    return Color$1.stringify(ch2);
  };
  const change$1 = change;
  const rgba = (r, g, b = 0, a = 1) => {
    if (typeof r !== "number")
      return change$1(r, { a: g });
    const channels2 = ChannelsReusable.set({
      r: _.channel.clamp.r(r),
      g: _.channel.clamp.g(g),
      b: _.channel.clamp.b(b),
      a: _.channel.clamp.a(a)
    });
    return Color$1.stringify(channels2);
  };
  const rgba$1 = rgba;
  const channel = (color2, channel2) => {
    return _.lang.round(Color$1.parse(color2)[channel2]);
  };
  const channel$1 = channel;
  const luminance = (color2) => {
    const { r, g, b } = Color$1.parse(color2);
    const luminance2 = 0.2126 * _.channel.toLinear(r) + 0.7152 * _.channel.toLinear(g) + 0.0722 * _.channel.toLinear(b);
    return _.lang.round(luminance2);
  };
  const luminance$1 = luminance;
  const isLight = (color2) => {
    return luminance$1(color2) >= 0.5;
  };
  const isLight$1 = isLight;
  const isDark = (color2) => {
    return !isLight$1(color2);
  };
  const isDark$1 = isDark;
  const adjustChannel = (color2, channel2, amount) => {
    const channels2 = Color$1.parse(color2);
    const amountCurrent = channels2[channel2];
    const amountNext = _.channel.clamp[channel2](amountCurrent + amount);
    if (amountCurrent !== amountNext)
      channels2[channel2] = amountNext;
    return Color$1.stringify(channels2);
  };
  const adjustChannel$1 = adjustChannel;
  const lighten = (color2, amount) => {
    return adjustChannel$1(color2, "l", amount);
  };
  const lighten$1 = lighten;
  const darken = (color2, amount) => {
    return adjustChannel$1(color2, "l", -amount);
  };
  const darken$1 = darken;
  const adjust$1 = (color2, channels2) => {
    const ch2 = Color$1.parse(color2);
    const changes = {};
    for (const c2 in channels2) {
      if (!channels2[c2])
        continue;
      changes[c2] = ch2[c2] + channels2[c2];
    }
    return change$1(color2, changes);
  };
  const adjust$2 = adjust$1;
  const mix = (color1, color2, weight = 50) => {
    const { r: r1, g: g1, b: b1, a: a1 } = Color$1.parse(color1);
    const { r: r2, g: g2, b: b2, a: a2 } = Color$1.parse(color2);
    const weightScale = weight / 100;
    const weightNormalized = weightScale * 2 - 1;
    const alphaDelta = a1 - a2;
    const weight1combined = weightNormalized * alphaDelta === -1 ? weightNormalized : (weightNormalized + alphaDelta) / (1 + weightNormalized * alphaDelta);
    const weight1 = (weight1combined + 1) / 2;
    const weight2 = 1 - weight1;
    const r = r1 * weight1 + r2 * weight2;
    const g = g1 * weight1 + g2 * weight2;
    const b = b1 * weight1 + b2 * weight2;
    const a = a1 * weightScale + a2 * (1 - weightScale);
    return rgba$1(r, g, b, a);
  };
  const mix$1 = mix;
  const invert = (color2, weight = 100) => {
    const inverse = Color$1.parse(color2);
    inverse.r = 255 - inverse.r;
    inverse.g = 255 - inverse.g;
    inverse.b = 255 - inverse.b;
    return mix$1(inverse, color2, weight);
  };
  const invert$1 = invert;
  const mkBorder = (col, darkMode) => darkMode ? adjust$2(col, { s: -40, l: 10 }) : adjust$2(col, { s: -40, l: -10 });
  const oldAttributeBackgroundColorOdd = "#ffffff";
  const oldAttributeBackgroundColorEven = "#f2f2f2";
  let Theme$4 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#fff4dd";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i6, _j, _k;
      this.primaryTextColor = this.primaryTextColor || (this.darkMode ? "#eee" : "#333");
      this.secondaryColor = this.secondaryColor || adjust$2(this.primaryColor, { h: -120 });
      this.tertiaryColor = this.tertiaryColor || adjust$2(this.primaryColor, { h: 180, l: 5 });
      this.primaryBorderColor = this.primaryBorderColor || mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = this.secondaryBorderColor || mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = this.tertiaryBorderColor || mkBorder(this.tertiaryColor, this.darkMode);
      this.noteBorderColor = this.noteBorderColor || mkBorder(this.noteBkgColor, this.darkMode);
      this.noteBkgColor = this.noteBkgColor || "#fff5ad";
      this.noteTextColor = this.noteTextColor || "#333";
      this.secondaryTextColor = this.secondaryTextColor || invert$1(this.secondaryColor);
      this.tertiaryTextColor = this.tertiaryTextColor || invert$1(this.tertiaryColor);
      this.lineColor = this.lineColor || invert$1(this.background);
      this.arrowheadColor = this.arrowheadColor || invert$1(this.background);
      this.textColor = this.textColor || this.primaryTextColor;
      this.border2 = this.border2 || this.tertiaryBorderColor;
      this.nodeBkg = this.nodeBkg || this.primaryColor;
      this.mainBkg = this.mainBkg || this.primaryColor;
      this.nodeBorder = this.nodeBorder || this.primaryBorderColor;
      this.clusterBkg = this.clusterBkg || this.tertiaryColor;
      this.clusterBorder = this.clusterBorder || this.tertiaryBorderColor;
      this.defaultLinkColor = this.defaultLinkColor || this.lineColor;
      this.titleColor = this.titleColor || this.tertiaryTextColor;
      this.edgeLabelBackground = this.edgeLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.nodeTextColor = this.nodeTextColor || this.primaryTextColor;
      this.actorBorder = this.actorBorder || this.primaryBorderColor;
      this.actorBkg = this.actorBkg || this.mainBkg;
      this.actorTextColor = this.actorTextColor || this.primaryTextColor;
      this.actorLineColor = this.actorLineColor || "grey";
      this.labelBoxBkgColor = this.labelBoxBkgColor || this.actorBkg;
      this.signalColor = this.signalColor || this.textColor;
      this.signalTextColor = this.signalTextColor || this.textColor;
      this.labelBoxBorderColor = this.labelBoxBorderColor || this.actorBorder;
      this.labelTextColor = this.labelTextColor || this.actorTextColor;
      this.loopTextColor = this.loopTextColor || this.actorTextColor;
      this.activationBorderColor = this.activationBorderColor || darken$1(this.secondaryColor, 10);
      this.activationBkgColor = this.activationBkgColor || this.secondaryColor;
      this.sequenceNumberColor = this.sequenceNumberColor || invert$1(this.lineColor);
      this.sectionBkgColor = this.sectionBkgColor || this.tertiaryColor;
      this.altSectionBkgColor = this.altSectionBkgColor || "white";
      this.sectionBkgColor = this.sectionBkgColor || this.secondaryColor;
      this.sectionBkgColor2 = this.sectionBkgColor2 || this.primaryColor;
      this.excludeBkgColor = this.excludeBkgColor || "#eeeeee";
      this.taskBorderColor = this.taskBorderColor || this.primaryBorderColor;
      this.taskBkgColor = this.taskBkgColor || this.primaryColor;
      this.activeTaskBorderColor = this.activeTaskBorderColor || this.primaryColor;
      this.activeTaskBkgColor = this.activeTaskBkgColor || lighten$1(this.primaryColor, 23);
      this.gridColor = this.gridColor || "lightgrey";
      this.doneTaskBkgColor = this.doneTaskBkgColor || "lightgrey";
      this.doneTaskBorderColor = this.doneTaskBorderColor || "grey";
      this.critBorderColor = this.critBorderColor || "#ff8888";
      this.critBkgColor = this.critBkgColor || "red";
      this.todayLineColor = this.todayLineColor || "red";
      this.taskTextColor = this.taskTextColor || this.textColor;
      this.taskTextOutsideColor = this.taskTextOutsideColor || this.textColor;
      this.taskTextLightColor = this.taskTextLightColor || this.textColor;
      this.taskTextColor = this.taskTextColor || this.primaryTextColor;
      this.taskTextDarkColor = this.taskTextDarkColor || this.textColor;
      this.taskTextClickableColor = this.taskTextClickableColor || "#003163";
      this.personBorder = this.personBorder || this.primaryBorderColor;
      this.personBkg = this.personBkg || this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || this.tertiaryColor;
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.specialStateColor = this.lineColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210, l: 150 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      if (this.darkMode) {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 75);
        }
      } else {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 25);
        }
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      const multiplier = this.darkMode ? -4 : -1;
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (5 + i2 * 3) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (8 + i2 * 3) });
      }
      this.classText = this.classText || this.textColor;
      this.fillType0 = this.fillType0 || this.primaryColor;
      this.fillType1 = this.fillType1 || this.secondaryColor;
      this.fillType2 = this.fillType2 || adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = this.fillType3 || adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = this.fillType4 || adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = this.fillType5 || adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = this.fillType6 || adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = this.fillType7 || adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -10 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -10 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -20 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -10 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i6 = this.xyChart) == null ? void 0 : _i6.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#FFF4DD,#FFD8B1,#FFA07A,#ECEFF1,#D6DBDF,#C3E0A8,#FFB6A4,#FFD74D,#738FA7,#FFFFF0"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this.gitBranchLabel0 = this.gitBranchLabel0 || this.branchLabelColor;
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.branchLabelColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.branchLabelColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || this.branchLabelColor;
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.branchLabelColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.branchLabelColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.branchLabelColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$4 = (userOverrides) => {
    const theme2 = new Theme$4();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$3 = class Theme {
    constructor() {
      this.background = "#333";
      this.primaryColor = "#1f2020";
      this.secondaryColor = lighten$1(this.primaryColor, 16);
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = invert$1(this.background);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#1f2020";
      this.secondBkg = "calculated";
      this.mainContrastColor = "lightgrey";
      this.darkTextColor = lighten$1(invert$1("#323D47"), 10);
      this.lineColor = "calculated";
      this.border1 = "#81B1DB";
      this.border2 = rgba$1(255, 255, 255, 0.25);
      this.arrowheadColor = "calculated";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#181818";
      this.textColor = "#ccc";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#F9FFFE";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "calculated";
      this.activationBkgColor = "calculated";
      this.sequenceNumberColor = "black";
      this.sectionBkgColor = darken$1("#EAE8D9", 30);
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "#EAE8D9";
      this.excludeBkgColor = darken$1(this.sectionBkgColor, 10);
      this.taskBorderColor = rgba$1(255, 255, 255, 70);
      this.taskBkgColor = "calculated";
      this.taskTextColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = rgba$1(255, 255, 255, 50);
      this.activeTaskBkgColor = "#81B1DB";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#E83737";
      this.critBkgColor = "#E83737";
      this.taskTextDarkColor = "calculated";
      this.todayLineColor = "#DB5757";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "calculated";
      this.errorBkgColor = "#a44141";
      this.errorTextColor = "#ddd";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i6, _j, _k;
      this.secondBkg = lighten$1(this.mainBkg, 16);
      this.lineColor = this.mainContrastColor;
      this.arrowheadColor = this.mainContrastColor;
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.edgeLabelBackground = lighten$1(this.labelBackground, 25);
      this.actorBorder = this.border1;
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.mainContrastColor;
      this.actorLineColor = this.mainContrastColor;
      this.signalColor = this.mainContrastColor;
      this.signalTextColor = this.mainContrastColor;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.mainContrastColor;
      this.loopTextColor = this.mainContrastColor;
      this.noteBorderColor = this.secondaryBorderColor;
      this.noteBkgColor = this.secondBkg;
      this.noteTextColor = this.secondaryTextColor;
      this.activationBorderColor = this.border1;
      this.activationBkgColor = this.secondBkg;
      this.altSectionBkgColor = this.background;
      this.taskBkgColor = lighten$1(this.mainBkg, 23);
      this.taskTextColor = this.darkTextColor;
      this.taskTextLightColor = this.mainContrastColor;
      this.taskTextOutsideColor = this.taskTextLightColor;
      this.gridColor = this.mainContrastColor;
      this.doneTaskBkgColor = this.mainContrastColor;
      this.taskTextDarkColor = this.darkTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#555";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#f4f4f4";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.cScale1 = this.cScale1 || "#0b0000";
      this.cScale2 = this.cScale2 || "#4d1037";
      this.cScale3 = this.cScale3 || "#3f5258";
      this.cScale4 = this.cScale4 || "#4f2f1b";
      this.cScale5 = this.cScale5 || "#6e0a0a";
      this.cScale6 = this.cScale6 || "#3b0048";
      this.cScale7 = this.cScale7 || "#995a01";
      this.cScale8 = this.cScale8 || "#154706";
      this.cScale9 = this.cScale9 || "#161722";
      this.cScale10 = this.cScale10 || "#00296f";
      this.cScale11 = this.cScale11 || "#01629c";
      this.cScale12 = this.cScale12 || "#010029";
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-10 + i2 * 4) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-7 + i2 * 4) });
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i6 = this.xyChart) == null ? void 0 : _i6.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#3498db,#2ecc71,#e74c3c,#f1c40f,#bdc3c7,#ffffff,#34495e,#9b59b6,#1abc9c,#e67e22"
      };
      this.classText = this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = lighten$1(this.secondaryColor, 20);
      this.git1 = lighten$1(this.pie2 || this.secondaryColor, 20);
      this.git2 = lighten$1(this.pie3 || this.tertiaryColor, 20);
      this.git3 = lighten$1(this.pie4 || adjust$2(this.primaryColor, { h: -30 }), 20);
      this.git4 = lighten$1(this.pie5 || adjust$2(this.primaryColor, { h: -60 }), 20);
      this.git5 = lighten$1(this.pie6 || adjust$2(this.primaryColor, { h: -90 }), 10);
      this.git6 = lighten$1(this.pie7 || adjust$2(this.primaryColor, { h: 60 }), 10);
      this.git7 = lighten$1(this.pie8 || adjust$2(this.primaryColor, { h: 120 }), 20);
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || lighten$1(this.background, 12);
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || lighten$1(this.background, 2);
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$3 = (userOverrides) => {
    const theme2 = new Theme$3();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$2 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#ECECFF";
      this.secondaryColor = adjust$2(this.primaryColor, { h: 120 });
      this.secondaryColor = "#ffffde";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.background = "white";
      this.mainBkg = "#ECECFF";
      this.secondBkg = "#ffffde";
      this.lineColor = "#333333";
      this.border1 = "#9370DB";
      this.border2 = "#aaaa33";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#e8e8e8";
      this.textColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.taskTextClickableColor = "calculated";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.todayLineColor = "calculated";
      this.sectionBkgColor = rgba$1(102, 102, 255, 0.49);
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#fff400";
      this.taskBorderColor = "#534fbc";
      this.taskBkgColor = "#8a90dd";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "#534fbc";
      this.activeTaskBkgColor = "#bfc7ff";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
      this.updateColors();
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i6, _j, _k;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(7 + i2 * 5) });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      if (this.labelTextColor !== "calculated") {
        this.cScaleLabel0 = this.cScaleLabel0 || invert$1(this.labelTextColor);
        this.cScaleLabel3 = this.cScaleLabel3 || invert$1(this.labelTextColor);
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.labelTextColor;
        }
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.textColor;
      this.edgeLabelBackground = this.labelBackground;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.signalColor = this.textColor;
      this.signalTextColor = this.textColor;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || adjust$2(this.tertiaryColor, { l: -40 });
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -20 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -40 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: -40 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -40 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -90, l: -40 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -30 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i6 = this.xyChart) == null ? void 0 : _i6.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#ECECFF,#8493A6,#FFC3A0,#DCDDE1,#B8E994,#D1A36F,#C3CDE6,#FFB6C1,#496078,#F8F3E3"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.labelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || darken$1(invert$1(this.git0), 25);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$2 = (userOverrides) => {
    const theme2 = new Theme$2();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$1 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#cde498";
      this.secondaryColor = "#cdffb2";
      this.background = "white";
      this.mainBkg = "#cde498";
      this.secondBkg = "#cdffb2";
      this.lineColor = "green";
      this.border1 = "#13540c";
      this.border2 = "#6eaa49";
      this.arrowheadColor = "green";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.tertiaryColor = lighten$1("#cde498", 10);
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.primaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#333";
      this.edgeLabelBackground = "#e8e8e8";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "#333";
      this.signalTextColor = "#333";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "#326932";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "#6eaa49";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#6eaa49";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "#487e3a";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i6, _j, _k;
      this.actorBorder = darken$1(this.mainBkg, 20);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.taskBorderColor = this.border1;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -30 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { h: 40, l: -40 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -50 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -50 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -50 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i6 = this.xyChart) == null ? void 0 : _i6.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#CDE498,#FF6B6B,#A0D2DB,#D7BDE2,#F0F0F0,#FFC3A0,#7FD8BE,#FF9A8B,#FAF3E0,#FFF176"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$1 = (userOverrides) => {
    const theme2 = new Theme$1();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme {
    constructor() {
      this.primaryColor = "#eee";
      this.contrast = "#707070";
      this.secondaryColor = lighten$1(this.contrast, 55);
      this.background = "#ffffff";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#eee";
      this.secondBkg = "calculated";
      this.lineColor = "#666";
      this.border1 = "#999";
      this.border2 = "calculated";
      this.note = "#ffa";
      this.text = "#333";
      this.critical = "#d42";
      this.done = "#bbb";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "white";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "calculated";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.critBorderColor = "calculated";
      this.todayLineColor = "calculated";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i6, _j, _k;
      this.secondBkg = lighten$1(this.contrast, 55);
      this.border2 = this.contrast;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.text;
      this.actorLineColor = this.lineColor;
      this.signalColor = this.text;
      this.signalTextColor = this.text;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.text;
      this.loopTextColor = this.text;
      this.noteBorderColor = "#999";
      this.noteBkgColor = "#666";
      this.noteTextColor = "#fff";
      this.cScale0 = this.cScale0 || "#555";
      this.cScale1 = this.cScale1 || "#F4F4F4";
      this.cScale2 = this.cScale2 || "#555";
      this.cScale3 = this.cScale3 || "#BBB";
      this.cScale4 = this.cScale4 || "#777";
      this.cScale5 = this.cScale5 || "#999";
      this.cScale6 = this.cScale6 || "#DDD";
      this.cScale7 = this.cScale7 || "#FFF";
      this.cScale8 = this.cScale8 || "#DDD";
      this.cScale9 = this.cScale9 || "#BBB";
      this.cScale10 = this.cScale10 || "#999";
      this.cScale11 = this.cScale11 || "#777";
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this["cScaleLabel0"] = this["cScaleLabel0"] || this.cScale1;
      this["cScaleLabel2"] = this["cScaleLabel2"] || this.cScale1;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.text;
      this.sectionBkgColor = lighten$1(this.contrast, 30);
      this.sectionBkgColor2 = lighten$1(this.contrast, 30);
      this.taskBorderColor = darken$1(this.contrast, 10);
      this.taskBkgColor = this.contrast;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = this.text;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.gridColor = lighten$1(this.border1, 30);
      this.doneTaskBkgColor = this.done;
      this.doneTaskBorderColor = this.lineColor;
      this.critBkgColor = this.critical;
      this.critBorderColor = darken$1(this.critBkgColor, 10);
      this.todayLineColor = this.critBkgColor;
      this.transitionColor = this.transitionColor || "#000";
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f4f4f4";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.stateBorder = this.stateBorder || "#000";
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#222";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pie12 = this.pie0;
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i6 = this.xyChart) == null ? void 0 : _i6.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#EEE,#6BB8E4,#8ACB88,#C7ACD6,#E8DCC2,#FFB2A8,#FFF380,#7E8D91,#FFD8B1,#FAF3E0"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = darken$1(this.pie1, 25) || this.primaryColor;
      this.git1 = this.pie2 || this.secondaryColor;
      this.git2 = this.pie3 || this.tertiaryColor;
      this.git3 = this.pie4 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.pie5 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.pie6 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.pie7 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.pie8 || adjust$2(this.primaryColor, { h: 120 });
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || this.labelTextColor;
      this.gitBranchLabel0 = this.branchLabelColor;
      this.gitBranchLabel1 = "white";
      this.gitBranchLabel2 = this.branchLabelColor;
      this.gitBranchLabel3 = "white";
      this.gitBranchLabel4 = this.branchLabelColor;
      this.gitBranchLabel5 = this.branchLabelColor;
      this.gitBranchLabel6 = this.branchLabelColor;
      this.gitBranchLabel7 = this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables = (userOverrides) => {
    const theme2 = new Theme();
    theme2.calculate(userOverrides);
    return theme2;
  };
  const theme = {
    base: {
      getThemeVariables: getThemeVariables$4
    },
    dark: {
      getThemeVariables: getThemeVariables$3
    },
    default: {
      getThemeVariables: getThemeVariables$2
    },
    forest: {
      getThemeVariables: getThemeVariables$1
    },
    neutral: {
      getThemeVariables
    }
  };
  const defaultConfigJson = {
    "flowchart": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "subGraphTitleMargin": {
        "top": 0,
        "bottom": 0
      },
      "diagramPadding": 8,
      "htmlLabels": true,
      "nodeSpacing": 50,
      "rankSpacing": 50,
      "curve": "basis",
      "padding": 15,
      "defaultRenderer": "dagre-wrapper",
      "wrappingWidth": 200
    },
    "sequence": {
      "useMaxWidth": true,
      "hideUnusedParticipants": false,
      "activationWidth": 10,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "actorMargin": 50,
      "width": 150,
      "height": 65,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "mirrorActors": true,
      "forceMenus": false,
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "showSequenceNumbers": false,
      "actorFontSize": 14,
      "actorFontFamily": '"Open Sans", sans-serif',
      "actorFontWeight": 400,
      "noteFontSize": 14,
      "noteFontFamily": '"trebuchet ms", verdana, arial, sans-serif',
      "noteFontWeight": 400,
      "noteAlign": "center",
      "messageFontSize": 16,
      "messageFontFamily": '"trebuchet ms", verdana, arial, sans-serif',
      "messageFontWeight": 400,
      "wrap": false,
      "wrapPadding": 10,
      "labelBoxWidth": 50,
      "labelBoxHeight": 20
    },
    "gantt": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "barHeight": 20,
      "barGap": 4,
      "topPadding": 50,
      "rightPadding": 75,
      "leftPadding": 75,
      "gridLineStartPadding": 35,
      "fontSize": 11,
      "sectionFontSize": 11,
      "numberSectionStyles": 4,
      "axisFormat": "%Y-%m-%d",
      "topAxis": false,
      "displayMode": "",
      "weekday": "sunday"
    },
    "journey": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "leftMargin": 150,
      "width": 150,
      "height": 50,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "taskFontSize": 14,
      "taskFontFamily": '"Open Sans", sans-serif',
      "taskMargin": 50,
      "activationWidth": 10,
      "textPlacement": "fo",
      "actorColours": [
        "#8FBC8F",
        "#7CFC00",
        "#00FFFF",
        "#20B2AA",
        "#B0E0E6",
        "#FFFFE0"
      ],
      "sectionFills": [
        "#191970",
        "#8B008B",
        "#4B0082",
        "#2F4F4F",
        "#800000",
        "#8B4513",
        "#00008B"
      ],
      "sectionColours": [
        "#fff"
      ]
    },
    "class": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "arrowMarkerAbsolute": false,
      "dividerMargin": 10,
      "padding": 5,
      "textHeight": 10,
      "defaultRenderer": "dagre-wrapper",
      "htmlLabels": false
    },
    "state": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "dividerMargin": 10,
      "sizeUnit": 5,
      "padding": 8,
      "textHeight": 10,
      "titleShift": -15,
      "noteMargin": 10,
      "forkWidth": 70,
      "forkHeight": 7,
      "miniPadding": 2,
      "fontSizeFactor": 5.02,
      "fontSize": 24,
      "labelHeight": 16,
      "edgeLengthFactor": "20",
      "compositTitleSize": 35,
      "radius": 5,
      "defaultRenderer": "dagre-wrapper"
    },
    "er": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "diagramPadding": 20,
      "layoutDirection": "TB",
      "minEntityWidth": 100,
      "minEntityHeight": 75,
      "entityPadding": 15,
      "stroke": "gray",
      "fill": "honeydew",
      "fontSize": 12
    },
    "pie": {
      "useMaxWidth": true,
      "textPosition": 0.75
    },
    "quadrantChart": {
      "useMaxWidth": true,
      "chartWidth": 500,
      "chartHeight": 500,
      "titleFontSize": 20,
      "titlePadding": 10,
      "quadrantPadding": 5,
      "xAxisLabelPadding": 5,
      "yAxisLabelPadding": 5,
      "xAxisLabelFontSize": 16,
      "yAxisLabelFontSize": 16,
      "quadrantLabelFontSize": 16,
      "quadrantTextTopPadding": 5,
      "pointTextPadding": 5,
      "pointLabelFontSize": 12,
      "pointRadius": 5,
      "xAxisPosition": "top",
      "yAxisPosition": "left",
      "quadrantInternalBorderStrokeWidth": 1,
      "quadrantExternalBorderStrokeWidth": 2
    },
    "xyChart": {
      "useMaxWidth": true,
      "width": 700,
      "height": 500,
      "titleFontSize": 20,
      "titlePadding": 10,
      "showTitle": true,
      "xAxis": {
        "$ref": "#/$defs/XYChartAxisConfig",
        "showLabel": true,
        "labelFontSize": 14,
        "labelPadding": 5,
        "showTitle": true,
        "titleFontSize": 16,
        "titlePadding": 5,
        "showTick": true,
        "tickLength": 5,
        "tickWidth": 2,
        "showAxisLine": true,
        "axisLineWidth": 2
      },
      "yAxis": {
        "$ref": "#/$defs/XYChartAxisConfig",
        "showLabel": true,
        "labelFontSize": 14,
        "labelPadding": 5,
        "showTitle": true,
        "titleFontSize": 16,
        "titlePadding": 5,
        "showTick": true,
        "tickLength": 5,
        "tickWidth": 2,
        "showAxisLine": true,
        "axisLineWidth": 2
      },
      "chartOrientation": "vertical",
      "plotReservedSpacePercent": 50
    },
    "requirement": {
      "useMaxWidth": true,
      "rect_fill": "#f9f9f9",
      "text_color": "#333",
      "rect_border_size": "0.5px",
      "rect_border_color": "#bbb",
      "rect_min_width": 200,
      "rect_min_height": 200,
      "fontSize": 14,
      "rect_padding": 10,
      "line_height": 20
    },
    "mindmap": {
      "useMaxWidth": true,
      "padding": 10,
      "maxNodeWidth": 200
    },
    "timeline": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "leftMargin": 150,
      "width": 150,
      "height": 50,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "taskFontSize": 14,
      "taskFontFamily": '"Open Sans", sans-serif',
      "taskMargin": 50,
      "activationWidth": 10,
      "textPlacement": "fo",
      "actorColours": [
        "#8FBC8F",
        "#7CFC00",
        "#00FFFF",
        "#20B2AA",
        "#B0E0E6",
        "#FFFFE0"
      ],
      "sectionFills": [
        "#191970",
        "#8B008B",
        "#4B0082",
        "#2F4F4F",
        "#800000",
        "#8B4513",
        "#00008B"
      ],
      "sectionColours": [
        "#fff"
      ],
      "disableMulticolor": false
    },
    "gitGraph": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "diagramPadding": 8,
      "nodeLabel": {
        "width": 75,
        "height": 100,
        "x": -25,
        "y": 0
      },
      "mainBranchName": "main",
      "mainBranchOrder": 0,
      "showCommitLabel": true,
      "showBranches": true,
      "rotateCommitLabel": true,
      "parallelCommits": false,
      "arrowMarkerAbsolute": false
    },
    "c4": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "c4ShapeMargin": 50,
      "c4ShapePadding": 20,
      "width": 216,
      "height": 60,
      "boxMargin": 10,
      "c4ShapeInRow": 4,
      "nextLinePaddingX": 0,
      "c4BoundaryInRow": 2,
      "personFontSize": 14,
      "personFontFamily": '"Open Sans", sans-serif',
      "personFontWeight": "normal",
      "external_personFontSize": 14,
      "external_personFontFamily": '"Open Sans", sans-serif',
      "external_personFontWeight": "normal",
      "systemFontSize": 14,
      "systemFontFamily": '"Open Sans", sans-serif',
      "systemFontWeight": "normal",
      "external_systemFontSize": 14,
      "external_systemFontFamily": '"Open Sans", sans-serif',
      "external_systemFontWeight": "normal",
      "system_dbFontSize": 14,
      "system_dbFontFamily": '"Open Sans", sans-serif',
      "system_dbFontWeight": "normal",
      "external_system_dbFontSize": 14,
      "external_system_dbFontFamily": '"Open Sans", sans-serif',
      "external_system_dbFontWeight": "normal",
      "system_queueFontSize": 14,
      "system_queueFontFamily": '"Open Sans", sans-serif',
      "system_queueFontWeight": "normal",
      "external_system_queueFontSize": 14,
      "external_system_queueFontFamily": '"Open Sans", sans-serif',
      "external_system_queueFontWeight": "normal",
      "boundaryFontSize": 14,
      "boundaryFontFamily": '"Open Sans", sans-serif',
      "boundaryFontWeight": "normal",
      "messageFontSize": 12,
      "messageFontFamily": '"Open Sans", sans-serif',
      "messageFontWeight": "normal",
      "containerFontSize": 14,
      "containerFontFamily": '"Open Sans", sans-serif',
      "containerFontWeight": "normal",
      "external_containerFontSize": 14,
      "external_containerFontFamily": '"Open Sans", sans-serif',
      "external_containerFontWeight": "normal",
      "container_dbFontSize": 14,
      "container_dbFontFamily": '"Open Sans", sans-serif',
      "container_dbFontWeight": "normal",
      "external_container_dbFontSize": 14,
      "external_container_dbFontFamily": '"Open Sans", sans-serif',
      "external_container_dbFontWeight": "normal",
      "container_queueFontSize": 14,
      "container_queueFontFamily": '"Open Sans", sans-serif',
      "container_queueFontWeight": "normal",
      "external_container_queueFontSize": 14,
      "external_container_queueFontFamily": '"Open Sans", sans-serif',
      "external_container_queueFontWeight": "normal",
      "componentFontSize": 14,
      "componentFontFamily": '"Open Sans", sans-serif',
      "componentFontWeight": "normal",
      "external_componentFontSize": 14,
      "external_componentFontFamily": '"Open Sans", sans-serif',
      "external_componentFontWeight": "normal",
      "component_dbFontSize": 14,
      "component_dbFontFamily": '"Open Sans", sans-serif',
      "component_dbFontWeight": "normal",
      "external_component_dbFontSize": 14,
      "external_component_dbFontFamily": '"Open Sans", sans-serif',
      "external_component_dbFontWeight": "normal",
      "component_queueFontSize": 14,
      "component_queueFontFamily": '"Open Sans", sans-serif',
      "component_queueFontWeight": "normal",
      "external_component_queueFontSize": 14,
      "external_component_queueFontFamily": '"Open Sans", sans-serif',
      "external_component_queueFontWeight": "normal",
      "wrap": true,
      "wrapPadding": 10,
      "person_bg_color": "#08427B",
      "person_border_color": "#073B6F",
      "external_person_bg_color": "#686868",
      "external_person_border_color": "#8A8A8A",
      "system_bg_color": "#1168BD",
      "system_border_color": "#3C7FC0",
      "system_db_bg_color": "#1168BD",
      "system_db_border_color": "#3C7FC0",
      "system_queue_bg_color": "#1168BD",
      "system_queue_border_color": "#3C7FC0",
      "external_system_bg_color": "#999999",
      "external_system_border_color": "#8A8A8A",
      "external_system_db_bg_color": "#999999",
      "external_system_db_border_color": "#8A8A8A",
      "external_system_queue_bg_color": "#999999",
      "external_system_queue_border_color": "#8A8A8A",
      "container_bg_color": "#438DD5",
      "container_border_color": "#3C7FC0",
      "container_db_bg_color": "#438DD5",
      "container_db_border_color": "#3C7FC0",
      "container_queue_bg_color": "#438DD5",
      "container_queue_border_color": "#3C7FC0",
      "external_container_bg_color": "#B3B3B3",
      "external_container_border_color": "#A6A6A6",
      "external_container_db_bg_color": "#B3B3B3",
      "external_container_db_border_color": "#A6A6A6",
      "external_container_queue_bg_color": "#B3B3B3",
      "external_container_queue_border_color": "#A6A6A6",
      "component_bg_color": "#85BBF0",
      "component_border_color": "#78A8D8",
      "component_db_bg_color": "#85BBF0",
      "component_db_border_color": "#78A8D8",
      "component_queue_bg_color": "#85BBF0",
      "component_queue_border_color": "#78A8D8",
      "external_component_bg_color": "#CCCCCC",
      "external_component_border_color": "#BFBFBF",
      "external_component_db_bg_color": "#CCCCCC",
      "external_component_db_border_color": "#BFBFBF",
      "external_component_queue_bg_color": "#CCCCCC",
      "external_component_queue_border_color": "#BFBFBF"
    },
    "sankey": {
      "useMaxWidth": true,
      "width": 600,
      "height": 400,
      "linkColor": "gradient",
      "nodeAlignment": "justify",
      "showValues": true,
      "prefix": "",
      "suffix": ""
    },
    "block": {
      "useMaxWidth": true,
      "padding": 8
    },
    "theme": "default",
    "maxTextSize": 5e4,
    "maxEdges": 500,
    "darkMode": false,
    "fontFamily": '"trebuchet ms", verdana, arial, sans-serif;',
    "logLevel": 5,
    "securityLevel": "strict",
    "startOnLoad": true,
    "arrowMarkerAbsolute": false,
    "secure": [
      "secure",
      "securityLevel",
      "startOnLoad",
      "maxTextSize",
      "maxEdges"
    ],
    "legacyMathML": false,
    "deterministicIds": false,
    "fontSize": 16
  };
  const config$3 = {
    ...defaultConfigJson,
    // Set, even though they're `undefined` so that `configKeys` finds these keys
    // TODO: Should we replace these with `null` so that they can go in the JSON Schema?
    deterministicIDSeed: void 0,
    themeCSS: void 0,
    // add non-JSON default config values
    themeVariables: theme["default"].getThemeVariables(),
    sequence: {
      ...defaultConfigJson.sequence,
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      noteFont: function() {
        return {
          fontFamily: this.noteFontFamily,
          fontSize: this.noteFontSize,
          fontWeight: this.noteFontWeight
        };
      },
      actorFont: function() {
        return {
          fontFamily: this.actorFontFamily,
          fontSize: this.actorFontSize,
          fontWeight: this.actorFontWeight
        };
      }
    },
    gantt: {
      ...defaultConfigJson.gantt,
      tickInterval: void 0,
      useWidth: void 0
      // can probably be removed since `configKeys` already includes this
    },
    c4: {
      ...defaultConfigJson.c4,
      useWidth: void 0,
      personFont: function() {
        return {
          fontFamily: this.personFontFamily,
          fontSize: this.personFontSize,
          fontWeight: this.personFontWeight
        };
      },
      external_personFont: function() {
        return {
          fontFamily: this.external_personFontFamily,
          fontSize: this.external_personFontSize,
          fontWeight: this.external_personFontWeight
        };
      },
      systemFont: function() {
        return {
          fontFamily: this.systemFontFamily,
          fontSize: this.systemFontSize,
          fontWeight: this.systemFontWeight
        };
      },
      external_systemFont: function() {
        return {
          fontFamily: this.external_systemFontFamily,
          fontSize: this.external_systemFontSize,
          fontWeight: this.external_systemFontWeight
        };
      },
      system_dbFont: function() {
        return {
          fontFamily: this.system_dbFontFamily,
          fontSize: this.system_dbFontSize,
          fontWeight: this.system_dbFontWeight
        };
      },
      external_system_dbFont: function() {
        return {
          fontFamily: this.external_system_dbFontFamily,
          fontSize: this.external_system_dbFontSize,
          fontWeight: this.external_system_dbFontWeight
        };
      },
      system_queueFont: function() {
        return {
          fontFamily: this.system_queueFontFamily,
          fontSize: this.system_queueFontSize,
          fontWeight: this.system_queueFontWeight
        };
      },
      external_system_queueFont: function() {
        return {
          fontFamily: this.external_system_queueFontFamily,
          fontSize: this.external_system_queueFontSize,
          fontWeight: this.external_system_queueFontWeight
        };
      },
      containerFont: function() {
        return {
          fontFamily: this.containerFontFamily,
          fontSize: this.containerFontSize,
          fontWeight: this.containerFontWeight
        };
      },
      external_containerFont: function() {
        return {
          fontFamily: this.external_containerFontFamily,
          fontSize: this.external_containerFontSize,
          fontWeight: this.external_containerFontWeight
        };
      },
      container_dbFont: function() {
        return {
          fontFamily: this.container_dbFontFamily,
          fontSize: this.container_dbFontSize,
          fontWeight: this.container_dbFontWeight
        };
      },
      external_container_dbFont: function() {
        return {
          fontFamily: this.external_container_dbFontFamily,
          fontSize: this.external_container_dbFontSize,
          fontWeight: this.external_container_dbFontWeight
        };
      },
      container_queueFont: function() {
        return {
          fontFamily: this.container_queueFontFamily,
          fontSize: this.container_queueFontSize,
          fontWeight: this.container_queueFontWeight
        };
      },
      external_container_queueFont: function() {
        return {
          fontFamily: this.external_container_queueFontFamily,
          fontSize: this.external_container_queueFontSize,
          fontWeight: this.external_container_queueFontWeight
        };
      },
      componentFont: function() {
        return {
          fontFamily: this.componentFontFamily,
          fontSize: this.componentFontSize,
          fontWeight: this.componentFontWeight
        };
      },
      external_componentFont: function() {
        return {
          fontFamily: this.external_componentFontFamily,
          fontSize: this.external_componentFontSize,
          fontWeight: this.external_componentFontWeight
        };
      },
      component_dbFont: function() {
        return {
          fontFamily: this.component_dbFontFamily,
          fontSize: this.component_dbFontSize,
          fontWeight: this.component_dbFontWeight
        };
      },
      external_component_dbFont: function() {
        return {
          fontFamily: this.external_component_dbFontFamily,
          fontSize: this.external_component_dbFontSize,
          fontWeight: this.external_component_dbFontWeight
        };
      },
      component_queueFont: function() {
        return {
          fontFamily: this.component_queueFontFamily,
          fontSize: this.component_queueFontSize,
          fontWeight: this.component_queueFontWeight
        };
      },
      external_component_queueFont: function() {
        return {
          fontFamily: this.external_component_queueFontFamily,
          fontSize: this.external_component_queueFontSize,
          fontWeight: this.external_component_queueFontWeight
        };
      },
      boundaryFont: function() {
        return {
          fontFamily: this.boundaryFontFamily,
          fontSize: this.boundaryFontSize,
          fontWeight: this.boundaryFontWeight
        };
      },
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      }
    },
    pie: {
      ...defaultConfigJson.pie,
      useWidth: 984
    },
    xyChart: {
      ...defaultConfigJson.xyChart,
      useWidth: void 0
    },
    requirement: {
      ...defaultConfigJson.requirement,
      useWidth: void 0
    },
    gitGraph: {
      ...defaultConfigJson.gitGraph,
      // TODO: This is a temporary override for `gitGraph`, since every other
      //       diagram does have `useMaxWidth`, but instead sets it to `true`.
      //       Should we set this to `true` instead?
      useMaxWidth: false
    },
    sankey: {
      ...defaultConfigJson.sankey,
      // this is false, unlike every other diagram (other than gitGraph)
      // TODO: can we make this default to `true` instead?
      useMaxWidth: false
    }
  };
  const keyify = (obj, prefix = "") => Object.keys(obj).reduce((res, el) => {
    if (Array.isArray(obj[el])) {
      return res;
    } else if (typeof obj[el] === "object" && obj[el] !== null) {
      return [...res, prefix + el, ...keyify(obj[el], "")];
    }
    return [...res, prefix + el];
  }, []);
  const configKeys = new Set(keyify(config$3, ""));
  const defaultConfig$2 = config$3;
  const sanitizeDirective = (args) => {
    log$1.debug("sanitizeDirective called with", args);
    if (typeof args !== "object" || args == null) {
      return;
    }
    if (Array.isArray(args)) {
      args.forEach((arg) => sanitizeDirective(arg));
      return;
    }
    for (const key of Object.keys(args)) {
      log$1.debug("Checking key", key);
      if (key.startsWith("__") || key.includes("proto") || key.includes("constr") || !configKeys.has(key) || args[key] == null) {
        log$1.debug("sanitize deleting key: ", key);
        delete args[key];
        continue;
      }
      if (typeof args[key] === "object") {
        log$1.debug("sanitizing object", key);
        sanitizeDirective(args[key]);
        continue;
      }
      const cssMatchers = ["themeCSS", "fontFamily", "altFontFamily"];
      for (const cssKey of cssMatchers) {
        if (key.includes(cssKey)) {
          log$1.debug("sanitizing css option", key);
          args[key] = sanitizeCss(args[key]);
        }
      }
    }
    if (args.themeVariables) {
      for (const k of Object.keys(args.themeVariables)) {
        const val = args.themeVariables[k];
        if ((val == null ? void 0 : val.match) && !val.match(/^[\d "#%(),.;A-Za-z]+$/)) {
          args.themeVariables[k] = "";
        }
      }
    }
    log$1.debug("After sanitization", args);
  };
  const sanitizeCss = (str2) => {
    let startCnt = 0;
    let endCnt = 0;
    for (const element2 of str2) {
      if (startCnt < endCnt) {
        return "{ /* ERROR: Unbalanced CSS */ }";
      }
      if (element2 === "{") {
        startCnt++;
      } else if (element2 === "}") {
        endCnt++;
      }
    }
    if (startCnt !== endCnt) {
      return "{ /* ERROR: Unbalanced CSS */ }";
    }
    return str2;
  };
  const frontMatterRegex = /^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s;
  const directiveRegex = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const anyCommentRegex = /\s*%%.*\n/gm;
  class UnknownDiagramError extends Error {
    constructor(message) {
      super(message);
      this.name = "UnknownDiagramError";
    }
  }
  const detectors = {};
  const detectType = function(text2, config2) {
    text2 = text2.replace(frontMatterRegex, "").replace(directiveRegex, "").replace(anyCommentRegex, "\n");
    for (const [key, { detector: detector2 }] of Object.entries(detectors)) {
      const diagram2 = detector2(text2, config2);
      if (diagram2) {
        return key;
      }
    }
    throw new UnknownDiagramError(
      `No diagram type detected matching given configuration for text: ${text2}`
    );
  };
  const registerLazyLoadedDiagrams = (...diagrams2) => {
    for (const { id: id2, detector: detector2, loader: loader2 } of diagrams2) {
      addDetector(id2, detector2, loader2);
    }
  };
  const addDetector = (key, detector2, loader2) => {
    if (detectors[key]) {
      log$1.error(`Detector with key ${key} already exists`);
    } else {
      detectors[key] = { detector: detector2, loader: loader2 };
    }
    log$1.debug(`Detector with key ${key} added${loader2 ? " with loader" : ""}`);
  };
  const getDiagramLoader = (key) => {
    return detectors[key].loader;
  };
  const assignWithDepth = (dst, src, { depth = 2, clobber = false } = {}) => {
    const config2 = { depth, clobber };
    if (Array.isArray(src) && !Array.isArray(dst)) {
      src.forEach((s) => assignWithDepth(dst, s, config2));
      return dst;
    } else if (Array.isArray(src) && Array.isArray(dst)) {
      src.forEach((s) => {
        if (!dst.includes(s)) {
          dst.push(s);
        }
      });
      return dst;
    }
    if (dst === void 0 || depth <= 0) {
      if (dst !== void 0 && dst !== null && typeof dst === "object" && typeof src === "object") {
        return Object.assign(dst, src);
      } else {
        return src;
      }
    }
    if (src !== void 0 && typeof dst === "object" && typeof src === "object") {
      Object.keys(src).forEach((key) => {
        if (typeof src[key] === "object" && (dst[key] === void 0 || typeof dst[key] === "object")) {
          if (dst[key] === void 0) {
            dst[key] = Array.isArray(src[key]) ? [] : {};
          }
          dst[key] = assignWithDepth(dst[key], src[key], { depth: depth - 1, clobber });
        } else if (clobber || typeof dst[key] !== "object" && typeof src[key] !== "object") {
          dst[key] = src[key];
        }
      });
    }
    return dst;
  };
  const assignWithDepth$1 = assignWithDepth;
  var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
  const freeGlobal$1 = freeGlobal;
  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root = freeGlobal$1 || freeSelf || Function("return this")();
  const root$1 = root;
  var Symbol$1 = root$1.Symbol;
  const Symbol$2 = Symbol$1;
  var objectProto$i = Object.prototype;
  var hasOwnProperty$g = objectProto$i.hasOwnProperty;
  var nativeObjectToString$1 = objectProto$i.toString;
  var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function getRawTag(value2) {
    var isOwn = hasOwnProperty$g.call(value2, symToStringTag$1), tag = value2[symToStringTag$1];
    try {
      value2[symToStringTag$1] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString$1.call(value2);
    if (unmasked) {
      if (isOwn) {
        value2[symToStringTag$1] = tag;
      } else {
        delete value2[symToStringTag$1];
      }
    }
    return result;
  }
  var objectProto$h = Object.prototype;
  var nativeObjectToString = objectProto$h.toString;
  function objectToString(value2) {
    return nativeObjectToString.call(value2);
  }
  var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
  var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function baseGetTag(value2) {
    if (value2 == null) {
      return value2 === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value2) ? getRawTag(value2) : objectToString(value2);
  }
  function isObject$1(value2) {
    var type2 = typeof value2;
    return value2 != null && (type2 == "object" || type2 == "function");
  }
  var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
  function isFunction(value2) {
    if (!isObject$1(value2)) {
      return false;
    }
    var tag = baseGetTag(value2);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
  }
  var coreJsData = root$1["__core-js_shared__"];
  const coreJsData$1 = coreJsData;
  var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  var funcProto$2 = Function.prototype;
  var funcToString$2 = funcProto$2.toString;
  function toSource(func) {
    if (func != null) {
      try {
        return funcToString$2.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  var funcProto$1 = Function.prototype, objectProto$g = Object.prototype;
  var funcToString$1 = funcProto$1.toString;
  var hasOwnProperty$f = objectProto$g.hasOwnProperty;
  var reIsNative = RegExp(
    "^" + funcToString$1.call(hasOwnProperty$f).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative(value2) {
    if (!isObject$1(value2) || isMasked(value2)) {
      return false;
    }
    var pattern = isFunction(value2) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value2));
  }
  function getValue(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  function getNative(object2, key) {
    var value2 = getValue(object2, key);
    return baseIsNative(value2) ? value2 : void 0;
  }
  var nativeCreate = getNative(Object, "create");
  const nativeCreate$1 = nativeCreate;
  function hashClear() {
    this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
    this.size = 0;
  }
  function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  var objectProto$f = Object.prototype;
  var hasOwnProperty$e = objectProto$f.hasOwnProperty;
  function hashGet(key) {
    var data = this.__data__;
    if (nativeCreate$1) {
      var result = data[key];
      return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$e.call(data, key) ? data[key] : void 0;
  }
  var objectProto$e = Object.prototype;
  var hasOwnProperty$d = objectProto$e.hasOwnProperty;
  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate$1 ? data[key] !== void 0 : hasOwnProperty$d.call(data, key);
  }
  var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
  function hashSet(key, value2) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate$1 && value2 === void 0 ? HASH_UNDEFINED$1 : value2;
    return this;
  }
  function Hash(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  Hash.prototype.clear = hashClear;
  Hash.prototype["delete"] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
  }
  function eq(value2, other) {
    return value2 === other || value2 !== value2 && other !== other;
  }
  function assocIndexOf(array2, key) {
    var length2 = array2.length;
    while (length2--) {
      if (eq(array2[length2][0], key)) {
        return length2;
      }
    }
    return -1;
  }
  var arrayProto = Array.prototype;
  var splice$1 = arrayProto.splice;
  function listCacheDelete(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      return false;
    }
    var lastIndex = data.length - 1;
    if (index2 == lastIndex) {
      data.pop();
    } else {
      splice$1.call(data, index2, 1);
    }
    --this.size;
    return true;
  }
  function listCacheGet(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    return index2 < 0 ? void 0 : data[index2][1];
  }
  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  function listCacheSet(key, value2) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      ++this.size;
      data.push([key, value2]);
    } else {
      data[index2][1] = value2;
    }
    return this;
  }
  function ListCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype["delete"] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  var Map$1 = getNative(root$1, "Map");
  const Map$2 = Map$1;
  function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash(),
      "map": new (Map$2 || ListCache)(),
      "string": new Hash()
    };
  }
  function isKeyable(value2) {
    var type2 = typeof value2;
    return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value2 !== "__proto__" : value2 === null;
  }
  function getMapData(map2, key) {
    var data = map2.__data__;
    return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
  }
  function mapCacheDelete(key) {
    var result = getMapData(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  function mapCacheSet(key, value2) {
    var data = getMapData(this, key), size2 = data.size;
    data.set(key, value2);
    this.size += data.size == size2 ? 0 : 1;
    return this;
  }
  function MapCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype["delete"] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  var FUNC_ERROR_TEXT = "Expected a function";
  function memoize(func, resolver2) {
    if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    var memoized = function() {
      var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache = memoized.cache;
      if (cache.has(key)) {
        return cache.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result) || cache;
      return result;
    };
    memoized.cache = new (memoize.Cache || MapCache)();
    return memoized;
  }
  memoize.Cache = MapCache;
  function stackClear() {
    this.__data__ = new ListCache();
    this.size = 0;
  }
  function stackDelete(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
  }
  function stackGet(key) {
    return this.__data__.get(key);
  }
  function stackHas(key) {
    return this.__data__.has(key);
  }
  var LARGE_ARRAY_SIZE$1 = 200;
  function stackSet(key, value2) {
    var data = this.__data__;
    if (data instanceof ListCache) {
      var pairs2 = data.__data__;
      if (!Map$2 || pairs2.length < LARGE_ARRAY_SIZE$1 - 1) {
        pairs2.push([key, value2]);
        this.size = ++data.size;
        return this;
      }
      data = this.__data__ = new MapCache(pairs2);
    }
    data.set(key, value2);
    this.size = data.size;
    return this;
  }
  function Stack(entries2) {
    var data = this.__data__ = new ListCache(entries2);
    this.size = data.size;
  }
  Stack.prototype.clear = stackClear;
  Stack.prototype["delete"] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;
  var defineProperty = function() {
    try {
      var func = getNative(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  const defineProperty$1 = defineProperty;
  function baseAssignValue(object2, key, value2) {
    if (key == "__proto__" && defineProperty$1) {
      defineProperty$1(object2, key, {
        "configurable": true,
        "enumerable": true,
        "value": value2,
        "writable": true
      });
    } else {
      object2[key] = value2;
    }
  }
  function assignMergeValue(object2, key, value2) {
    if (value2 !== void 0 && !eq(object2[key], value2) || value2 === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value2);
    }
  }
  function createBaseFor(fromRight) {
    return function(object2, iteratee, keysFunc) {
      var index2 = -1, iterable = Object(object2), props = keysFunc(object2), length2 = props.length;
      while (length2--) {
        var key = props[fromRight ? length2 : ++index2];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object2;
    };
  }
  var baseFor = createBaseFor();
  const baseFor$1 = baseFor;
  var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
  var Buffer$1 = moduleExports$2 ? root$1.Buffer : void 0, allocUnsafe = Buffer$1 ? Buffer$1.allocUnsafe : void 0;
  function cloneBuffer(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length2 = buffer.length, result = allocUnsafe ? allocUnsafe(length2) : new buffer.constructor(length2);
    buffer.copy(result);
    return result;
  }
  var Uint8Array$1 = root$1.Uint8Array;
  const Uint8Array$2 = Uint8Array$1;
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$2(result).set(new Uint8Array$2(arrayBuffer));
    return result;
  }
  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }
  function copyArray(source, array2) {
    var index2 = -1, length2 = source.length;
    array2 || (array2 = Array(length2));
    while (++index2 < length2) {
      array2[index2] = source[index2];
    }
    return array2;
  }
  var objectCreate = Object.create;
  var baseCreate = function() {
    function object2() {
    }
    return function(proto) {
      if (!isObject$1(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object2.prototype = proto;
      var result = new object2();
      object2.prototype = void 0;
      return result;
    };
  }();
  const baseCreate$1 = baseCreate;
  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var getPrototype = overArg(Object.getPrototypeOf, Object);
  const getPrototype$1 = getPrototype;
  var objectProto$d = Object.prototype;
  function isPrototype(value2) {
    var Ctor = value2 && value2.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$d;
    return value2 === proto;
  }
  function initCloneObject(object2) {
    return typeof object2.constructor == "function" && !isPrototype(object2) ? baseCreate$1(getPrototype$1(object2)) : {};
  }
  function isObjectLike(value2) {
    return value2 != null && typeof value2 == "object";
  }
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments(value2) {
    return isObjectLike(value2) && baseGetTag(value2) == argsTag$3;
  }
  var objectProto$c = Object.prototype;
  var hasOwnProperty$c = objectProto$c.hasOwnProperty;
  var propertyIsEnumerable$1 = objectProto$c.propertyIsEnumerable;
  var isArguments = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value2) {
    return isObjectLike(value2) && hasOwnProperty$c.call(value2, "callee") && !propertyIsEnumerable$1.call(value2, "callee");
  };
  const isArguments$1 = isArguments;
  var isArray = Array.isArray;
  const isArray$1 = isArray;
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  function isLength(value2) {
    return typeof value2 == "number" && value2 > -1 && value2 % 1 == 0 && value2 <= MAX_SAFE_INTEGER$1;
  }
  function isArrayLike(value2) {
    return value2 != null && isLength(value2.length) && !isFunction(value2);
  }
  function isArrayLikeObject(value2) {
    return isObjectLike(value2) && isArrayLike(value2);
  }
  function stubFalse() {
    return false;
  }
  var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
  var Buffer = moduleExports$1 ? root$1.Buffer : void 0;
  var nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0;
  var isBuffer = nativeIsBuffer || stubFalse;
  const isBuffer$1 = isBuffer;
  var objectTag$4 = "[object Object]";
  var funcProto = Function.prototype, objectProto$b = Object.prototype;
  var funcToString = funcProto.toString;
  var hasOwnProperty$b = objectProto$b.hasOwnProperty;
  var objectCtorString = funcToString.call(Object);
  function isPlainObject(value2) {
    if (!isObjectLike(value2) || baseGetTag(value2) != objectTag$4) {
      return false;
    }
    var proto = getPrototype$1(value2);
    if (proto === null) {
      return true;
    }
    var Ctor = hasOwnProperty$b.call(proto, "constructor") && proto.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
  }
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$1 = "[object Function]", mapTag$6 = "[object Map]", numberTag$3 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$6 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$4] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$6] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$6] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray(value2) {
    return isObjectLike(value2) && isLength(value2.length) && !!typedArrayTags[baseGetTag(value2)];
  }
  function baseUnary(func) {
    return function(value2) {
      return func(value2);
    };
  }
  var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports = freeModule && freeModule.exports === freeExports;
  var freeProcess = moduleExports && freeGlobal$1.process;
  var nodeUtil = function() {
    try {
      var types = freeModule && freeModule.require && freeModule.require("util").types;
      if (types) {
        return types;
      }
      return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {
    }
  }();
  const nodeUtil$1 = nodeUtil;
  var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  const isTypedArray$1 = isTypedArray;
  function safeGet(object2, key) {
    if (key === "constructor" && typeof object2[key] === "function") {
      return;
    }
    if (key == "__proto__") {
      return;
    }
    return object2[key];
  }
  var objectProto$a = Object.prototype;
  var hasOwnProperty$a = objectProto$a.hasOwnProperty;
  function assignValue(object2, key, value2) {
    var objValue = object2[key];
    if (!(hasOwnProperty$a.call(object2, key) && eq(objValue, value2)) || value2 === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value2);
    }
  }
  function copyObject(source, props, object2, customizer) {
    var isNew = !object2;
    object2 || (object2 = {});
    var index2 = -1, length2 = props.length;
    while (++index2 < length2) {
      var key = props[index2];
      var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue(object2, key, newValue);
      } else {
        assignValue(object2, key, newValue);
      }
    }
    return object2;
  }
  function baseTimes(n, iteratee) {
    var index2 = -1, result = Array(n);
    while (++index2 < n) {
      result[index2] = iteratee(index2);
    }
    return result;
  }
  var MAX_SAFE_INTEGER = 9007199254740991;
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function isIndex(value2, length2) {
    var type2 = typeof value2;
    length2 = length2 == null ? MAX_SAFE_INTEGER : length2;
    return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint.test(value2)) && (value2 > -1 && value2 % 1 == 0 && value2 < length2);
  }
  var objectProto$9 = Object.prototype;
  var hasOwnProperty$9 = objectProto$9.hasOwnProperty;
  function arrayLikeKeys(value2, inherited) {
    var isArr = isArray$1(value2), isArg = !isArr && isArguments$1(value2), isBuff = !isArr && !isArg && isBuffer$1(value2), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value2), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value2.length, String) : [], length2 = result.length;
    for (var key in value2) {
      if ((inherited || hasOwnProperty$9.call(value2, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
      (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
      isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
      isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
      isIndex(key, length2)))) {
        result.push(key);
      }
    }
    return result;
  }
  function nativeKeysIn(object2) {
    var result = [];
    if (object2 != null) {
      for (var key in Object(object2)) {
        result.push(key);
      }
    }
    return result;
  }
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$8 = objectProto$8.hasOwnProperty;
  function baseKeysIn(object2) {
    if (!isObject$1(object2)) {
      return nativeKeysIn(object2);
    }
    var isProto = isPrototype(object2), result = [];
    for (var key in object2) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty$8.call(object2, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  function keysIn(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2, true) : baseKeysIn(object2);
  }
  function toPlainObject(value2) {
    return copyObject(value2, keysIn(value2));
  }
  function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
    if (stacked) {
      assignMergeValue(object2, key, stacked);
      return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
      var isArr = isArray$1(srcValue), isBuff = !isArr && isBuffer$1(srcValue), isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);
      newValue = srcValue;
      if (isArr || isBuff || isTyped) {
        if (isArray$1(objValue)) {
          newValue = objValue;
        } else if (isArrayLikeObject(objValue)) {
          newValue = copyArray(objValue);
        } else if (isBuff) {
          isCommon = false;
          newValue = cloneBuffer(srcValue, true);
        } else if (isTyped) {
          isCommon = false;
          newValue = cloneTypedArray(srcValue, true);
        } else {
          newValue = [];
        }
      } else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
        newValue = objValue;
        if (isArguments$1(objValue)) {
          newValue = toPlainObject(objValue);
        } else if (!isObject$1(objValue) || isFunction(objValue)) {
          newValue = initCloneObject(srcValue);
        }
      } else {
        isCommon = false;
      }
    }
    if (isCommon) {
      stack.set(srcValue, newValue);
      mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
      stack["delete"](srcValue);
    }
    assignMergeValue(object2, key, newValue);
  }
  function baseMerge(object2, source, srcIndex, customizer, stack) {
    if (object2 === source) {
      return;
    }
    baseFor$1(source, function(srcValue, key) {
      stack || (stack = new Stack());
      if (isObject$1(srcValue)) {
        baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
      } else {
        var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : void 0;
        if (newValue === void 0) {
          newValue = srcValue;
        }
        assignMergeValue(object2, key, newValue);
      }
    }, keysIn);
  }
  function identity(value2) {
    return value2;
  }
  function apply$1(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  var nativeMax$2 = Math.max;
  function overRest(func, start2, transform) {
    start2 = nativeMax$2(start2 === void 0 ? func.length - 1 : start2, 0);
    return function() {
      var args = arguments, index2 = -1, length2 = nativeMax$2(args.length - start2, 0), array2 = Array(length2);
      while (++index2 < length2) {
        array2[index2] = args[start2 + index2];
      }
      index2 = -1;
      var otherArgs = Array(start2 + 1);
      while (++index2 < start2) {
        otherArgs[index2] = args[index2];
      }
      otherArgs[start2] = transform(array2);
      return apply$1(func, this, otherArgs);
    };
  }
  function constant$2(value2) {
    return function() {
      return value2;
    };
  }
  var baseSetToString = !defineProperty$1 ? identity : function(func, string2) {
    return defineProperty$1(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant$2(string2),
      "writable": true
    });
  };
  const baseSetToString$1 = baseSetToString;
  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }
  var setToString = shortOut(baseSetToString$1);
  const setToString$1 = setToString;
  function baseRest(func, start2) {
    return setToString$1(overRest(func, start2, identity), func + "");
  }
  function isIterateeCall(value2, index2, object2) {
    if (!isObject$1(object2)) {
      return false;
    }
    var type2 = typeof index2;
    if (type2 == "number" ? isArrayLike(object2) && isIndex(index2, object2.length) : type2 == "string" && index2 in object2) {
      return eq(object2[index2], value2);
    }
    return false;
  }
  function createAssigner(assigner) {
    return baseRest(function(object2, sources) {
      var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : void 0, guard = length2 > 2 ? sources[2] : void 0;
      customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        customizer = length2 < 3 ? void 0 : customizer;
        length2 = 1;
      }
      object2 = Object(object2);
      while (++index2 < length2) {
        var source = sources[index2];
        if (source) {
          assigner(object2, source, index2, customizer);
        }
      }
      return object2;
    });
  }
  var merge$2 = createAssigner(function(object2, source, srcIndex) {
    baseMerge(object2, source, srcIndex);
  });
  const merge$3 = merge$2;
  const ZERO_WIDTH_SPACE = "​";
  const d3CurveTypes = {
    curveBasis,
    curveBasisClosed,
    curveBasisOpen,
    curveBumpX: bumpX,
    curveBumpY: bumpY,
    curveBundle,
    curveCardinalClosed,
    curveCardinalOpen,
    curveCardinal,
    curveCatmullRomClosed,
    curveCatmullRomOpen,
    curveCatmullRom,
    curveLinear,
    curveLinearClosed,
    curveMonotoneX: monotoneX,
    curveMonotoneY: monotoneY,
    curveNatural,
    curveStep,
    curveStepAfter: stepAfter,
    curveStepBefore: stepBefore
  };
  const directiveWithoutOpen = /\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const detectInit = function(text2, config2) {
    const inits = detectDirective(text2, /(?:init\b)|(?:initialize\b)/);
    let results = {};
    if (Array.isArray(inits)) {
      const args = inits.map((init2) => init2.args);
      sanitizeDirective(args);
      results = assignWithDepth$1(results, [...args]);
    } else {
      results = inits.args;
    }
    if (!results) {
      return;
    }
    let type2 = detectType(text2, config2);
    const prop = "config";
    if (results[prop] !== void 0) {
      if (type2 === "flowchart-v2") {
        type2 = "flowchart";
      }
      results[type2] = results[prop];
      delete results[prop];
    }
    return results;
  };
  const detectDirective = function(text2, type2 = null) {
    try {
      const commentWithoutDirectives = new RegExp(
        `[%]{2}(?![{]${directiveWithoutOpen.source})(?=[}][%]{2}).*
`,
        "ig"
      );
      text2 = text2.trim().replace(commentWithoutDirectives, "").replace(/'/gm, '"');
      log$1.debug(
        `Detecting diagram directive${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      let match;
      const result = [];
      while ((match = directiveRegex.exec(text2)) !== null) {
        if (match.index === directiveRegex.lastIndex) {
          directiveRegex.lastIndex++;
        }
        if (match && !type2 || type2 && match[1] && match[1].match(type2) || type2 && match[2] && match[2].match(type2)) {
          const type22 = match[1] ? match[1] : match[2];
          const args = match[3] ? match[3].trim() : match[4] ? JSON.parse(match[4].trim()) : null;
          result.push({ type: type22, args });
        }
      }
      if (result.length === 0) {
        return { type: text2, args: null };
      }
      return result.length === 1 ? result[0] : result;
    } catch (error) {
      log$1.error(
        `ERROR: ${error.message} - Unable to parse directive type: '${type2}' based on the text: '${text2}'`
      );
      return { type: void 0, args: null };
    }
  };
  const removeDirectives = function(text2) {
    return text2.replace(directiveRegex, "");
  };
  const isSubstringInArray = function(str2, arr) {
    for (const [i2, element2] of arr.entries()) {
      if (element2.match(str2)) {
        return i2;
      }
    }
    return -1;
  };
  function interpolateToCurve(interpolate2, defaultCurve) {
    if (!interpolate2) {
      return defaultCurve;
    }
    const curveName = `curve${interpolate2.charAt(0).toUpperCase() + interpolate2.slice(1)}`;
    return d3CurveTypes[curveName] ?? defaultCurve;
  }
  function formatUrl(linkStr, config2) {
    const url = linkStr.trim();
    if (!url) {
      return void 0;
    }
    if (config2.securityLevel !== "loose") {
      return dist.sanitizeUrl(url);
    }
    return url;
  }
  const runFunc = (functionName, ...params) => {
    const arrPaths = functionName.split(".");
    const len = arrPaths.length - 1;
    const fnName = arrPaths[len];
    let obj = window;
    for (let i2 = 0; i2 < len; i2++) {
      obj = obj[arrPaths[i2]];
      if (!obj) {
        log$1.error(`Function name: ${functionName} not found in window`);
        return;
      }
    }
    obj[fnName](...params);
  };
  function distance(p1, p2) {
    if (!p1 || !p2) {
      return 0;
    }
    return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
  }
  function traverseEdge(points) {
    let prevPoint;
    let totalDistance = 0;
    points.forEach((point2) => {
      totalDistance += distance(point2, prevPoint);
      prevPoint = point2;
    });
    const remainingDistance = totalDistance / 2;
    return calculatePoint(points, remainingDistance);
  }
  function calcLabelPosition(points) {
    if (points.length === 1) {
      return points[0];
    }
    return traverseEdge(points);
  }
  const roundNumber = (num, precision = 2) => {
    const factor = Math.pow(10, precision);
    return Math.round(num * factor) / factor;
  };
  const calculatePoint = (points, distanceToTraverse) => {
    let prevPoint = void 0;
    let remainingDistance = distanceToTraverse;
    for (const point2 of points) {
      if (prevPoint) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            return prevPoint;
          }
          if (distanceRatio >= 1) {
            return { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            return {
              x: roundNumber((1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x, 5),
              y: roundNumber((1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y, 5)
            };
          }
        }
      }
      prevPoint = point2;
    }
    throw new Error("Could not find a suitable point for the given distance");
  };
  const calcCardinalityPosition = (isRelationTypePresent, points, initialPosition) => {
    log$1.info(`our points ${JSON.stringify(points)}`);
    if (points[0] !== initialPosition) {
      points = points.reverse();
    }
    const distanceToCardinalityPoint = 25;
    const center2 = calculatePoint(points, distanceToCardinalityPoint);
    const d = isRelationTypePresent ? 10 : 5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    return cardinalityPosition;
  };
  function calcTerminalLabelPosition(terminalMarkerSize, position2, _points) {
    const points = structuredClone(_points);
    log$1.info("our points", points);
    if (position2 !== "start_left" && position2 !== "start_right") {
      points.reverse();
    }
    const distanceToCardinalityPoint = 25 + terminalMarkerSize;
    const center2 = calculatePoint(points, distanceToCardinalityPoint);
    const d = 10 + terminalMarkerSize * 0.5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    if (position2 === "start_left") {
      cardinalityPosition.x = Math.sin(angle + Math.PI) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle + Math.PI) * d + (points[0].y + center2.y) / 2;
    } else if (position2 === "end_right") {
      cardinalityPosition.x = Math.sin(angle - Math.PI) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle - Math.PI) * d + (points[0].y + center2.y) / 2 - 5;
    } else if (position2 === "end_left") {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2 - 5;
    } else {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    }
    return cardinalityPosition;
  }
  function getStylesFromArray(arr) {
    let style = "";
    let labelStyle = "";
    for (const element2 of arr) {
      if (element2 !== void 0) {
        if (element2.startsWith("color:") || element2.startsWith("text-align:")) {
          labelStyle = labelStyle + element2 + ";";
        } else {
          style = style + element2 + ";";
        }
      }
    }
    return { style, labelStyle };
  }
  let cnt$2 = 0;
  const generateId$2 = () => {
    cnt$2++;
    return "id-" + Math.random().toString(36).substr(2, 12) + "-" + cnt$2;
  };
  function makeRandomHex(length2) {
    let result = "";
    const characters2 = "0123456789abcdef";
    const charactersLength = characters2.length;
    for (let i2 = 0; i2 < length2; i2++) {
      result += characters2.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
  }
  const random = (options2) => {
    return makeRandomHex(options2.length);
  };
  const getTextObj$3 = function() {
    return {
      x: 0,
      y: 0,
      fill: void 0,
      anchor: "start",
      style: "#666",
      width: 100,
      height: 100,
      textMargin: 0,
      rx: 0,
      ry: 0,
      valign: void 0,
      text: ""
    };
  };
  const drawSimpleText = function(elem, textData) {
    const nText = textData.text.replace(common$1.lineBreakRegex, " ");
    const [, _fontSizePx] = parseFontSize(textData.fontSize);
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.style("text-anchor", textData.anchor);
    textElem.style("font-family", textData.fontFamily);
    textElem.style("font-size", _fontSizePx);
    textElem.style("font-weight", textData.fontWeight);
    textElem.attr("fill", textData.fill);
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    const span = textElem.append("tspan");
    span.attr("x", textData.x + textData.textMargin * 2);
    span.attr("fill", textData.fill);
    span.text(nText);
    return textElem;
  };
  const wrapLabel = memoize(
    (label, maxWidth, config2) => {
      if (!label) {
        return label;
      }
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", joinWith: "<br/>" },
        config2
      );
      if (common$1.lineBreakRegex.test(label)) {
        return label;
      }
      const words = label.split(" ");
      const completedLines = [];
      let nextLine = "";
      words.forEach((word, index2) => {
        const wordLength = calculateTextWidth(`${word} `, config2);
        const nextLineLength = calculateTextWidth(nextLine, config2);
        if (wordLength > maxWidth) {
          const { hyphenatedStrings, remainingWord } = breakString(word, maxWidth, "-", config2);
          completedLines.push(nextLine, ...hyphenatedStrings);
          nextLine = remainingWord;
        } else if (nextLineLength + wordLength >= maxWidth) {
          completedLines.push(nextLine);
          nextLine = word;
        } else {
          nextLine = [nextLine, word].filter(Boolean).join(" ");
        }
        const currentWord = index2 + 1;
        const isLastWord = currentWord === words.length;
        if (isLastWord) {
          completedLines.push(nextLine);
        }
      });
      return completedLines.filter((line2) => line2 !== "").join(config2.joinWith);
    },
    (label, maxWidth, config2) => `${label}${maxWidth}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}${config2.joinWith}`
  );
  const breakString = memoize(
    (word, maxWidth, hyphenCharacter = "-", config2) => {
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 0 },
        config2
      );
      const characters2 = [...word];
      const lines = [];
      let currentLine = "";
      characters2.forEach((character2, index2) => {
        const nextLine = `${currentLine}${character2}`;
        const lineWidth = calculateTextWidth(nextLine, config2);
        if (lineWidth >= maxWidth) {
          const currentCharacter = index2 + 1;
          const isLastLine = characters2.length === currentCharacter;
          const hyphenatedNextLine = `${nextLine}${hyphenCharacter}`;
          lines.push(isLastLine ? nextLine : hyphenatedNextLine);
          currentLine = "";
        } else {
          currentLine = nextLine;
        }
      });
      return { hyphenatedStrings: lines, remainingWord: currentLine };
    },
    (word, maxWidth, hyphenCharacter = "-", config2) => `${word}${maxWidth}${hyphenCharacter}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  function calculateTextHeight(text2, config2) {
    return calculateTextDimensions(text2, config2).height;
  }
  function calculateTextWidth(text2, config2) {
    return calculateTextDimensions(text2, config2).width;
  }
  const calculateTextDimensions = memoize(
    (text2, config2) => {
      const { fontSize = 12, fontFamily = "Arial", fontWeight = 400 } = config2;
      if (!text2) {
        return { width: 0, height: 0 };
      }
      const [, _fontSizePx] = parseFontSize(fontSize);
      const fontFamilies = ["sans-serif", fontFamily];
      const lines = text2.split(common$1.lineBreakRegex);
      const dims = [];
      const body = d3select("body");
      if (!body.remove) {
        return { width: 0, height: 0, lineHeight: 0 };
      }
      const g = body.append("svg");
      for (const fontFamily2 of fontFamilies) {
        let cHeight = 0;
        const dim = { width: 0, height: 0, lineHeight: 0 };
        for (const line2 of lines) {
          const textObj = getTextObj$3();
          textObj.text = line2 || ZERO_WIDTH_SPACE;
          const textElem = drawSimpleText(g, textObj).style("font-size", _fontSizePx).style("font-weight", fontWeight).style("font-family", fontFamily2);
          const bBox = (textElem._groups || textElem)[0][0].getBBox();
          if (bBox.width === 0 && bBox.height === 0) {
            throw new Error("svg element not in render tree");
          }
          dim.width = Math.round(Math.max(dim.width, bBox.width));
          cHeight = Math.round(bBox.height);
          dim.height += cHeight;
          dim.lineHeight = Math.round(Math.max(dim.lineHeight, cHeight));
        }
        dims.push(dim);
      }
      g.remove();
      const index2 = isNaN(dims[1].height) || isNaN(dims[1].width) || isNaN(dims[1].lineHeight) || dims[0].height > dims[1].height && dims[0].width > dims[1].width && dims[0].lineHeight > dims[1].lineHeight ? 0 : 1;
      return dims[index2];
    },
    (text2, config2) => `${text2}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  class InitIDGenerator {
    constructor(deterministic = false, seed) {
      this.count = 0;
      this.count = seed ? seed.length : 0;
      this.next = deterministic ? () => this.count++ : () => Date.now();
    }
  }
  let decoder;
  const entityDecode = function(html2) {
    decoder = decoder || document.createElement("div");
    html2 = escape(html2).replace(/%26/g, "&").replace(/%23/g, "#").replace(/%3B/g, ";");
    decoder.innerHTML = html2;
    return unescape(decoder.textContent);
  };
  function isDetailedError(error) {
    return "str" in error;
  }
  const insertTitle = (parent, cssClass, titleTopMargin, title2) => {
    var _a2;
    if (!title2) {
      return;
    }
    const bounds2 = (_a2 = parent.node()) == null ? void 0 : _a2.getBBox();
    if (!bounds2) {
      return;
    }
    parent.append("text").text(title2).attr("x", bounds2.x + bounds2.width / 2).attr("y", -titleTopMargin).attr("class", cssClass);
  };
  const parseFontSize = (fontSize) => {
    if (typeof fontSize === "number") {
      return [fontSize, fontSize + "px"];
    }
    const fontSizeNumber = parseInt(fontSize ?? "", 10);
    if (Number.isNaN(fontSizeNumber)) {
      return [void 0, void 0];
    } else if (fontSize === String(fontSizeNumber)) {
      return [fontSizeNumber, fontSize + "px"];
    } else {
      return [fontSizeNumber, fontSize];
    }
  };
  function cleanAndMerge(defaultData, data) {
    return merge$3({}, defaultData, data);
  }
  const utils$1 = {
    assignWithDepth: assignWithDepth$1,
    wrapLabel,
    calculateTextHeight,
    calculateTextWidth,
    calculateTextDimensions,
    cleanAndMerge,
    detectInit,
    detectDirective,
    isSubstringInArray,
    interpolateToCurve,
    calcLabelPosition,
    calcCardinalityPosition,
    calcTerminalLabelPosition,
    formatUrl,
    getStylesFromArray,
    generateId: generateId$2,
    random,
    runFunc,
    entityDecode,
    insertTitle,
    parseFontSize,
    InitIDGenerator
  };
  const encodeEntities = function(text2) {
    let txt = text2;
    txt = txt.replace(/style.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/classDef.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/#\w+;/g, function(s) {
      const innerTxt = s.substring(1, s.length - 1);
      const isInt = /^\+?\d+$/.test(innerTxt);
      if (isInt) {
        return "ﬂ°°" + innerTxt + "¶ß";
      } else {
        return "ﬂ°" + innerTxt + "¶ß";
      }
    });
    return txt;
  };
  const decodeEntities = function(text2) {
    return text2.replace(/ﬂ°°/g, "&#").replace(/ﬂ°/g, "&").replace(/¶ß/g, ";");
  };
  var COMMENT = "comm";
  var RULESET = "rule";
  var DECLARATION = "decl";
  var IMPORT = "@import";
  var KEYFRAMES = "@keyframes";
  var LAYER = "@layer";
  var abs = Math.abs;
  var from = String.fromCharCode;
  function trim(value2) {
    return value2.trim();
  }
  function replace(value2, pattern, replacement) {
    return value2.replace(pattern, replacement);
  }
  function indexof(value2, search2, position2) {
    return value2.indexOf(search2, position2);
  }
  function charat(value2, index2) {
    return value2.charCodeAt(index2) | 0;
  }
  function substr(value2, begin, end2) {
    return value2.slice(begin, end2);
  }
  function strlen(value2) {
    return value2.length;
  }
  function sizeof(value2) {
    return value2.length;
  }
  function append(value2, array2) {
    return array2.push(value2), value2;
  }
  var line = 1;
  var column = 1;
  var length = 0;
  var position$2 = 0;
  var character = 0;
  var characters = "";
  function node$1(value2, root2, parent, type2, props, children2, length2, siblings) {
    return { value: value2, root: root2, parent, type: type2, props, children: children2, line, column, length: length2, return: "", siblings };
  }
  function char() {
    return character;
  }
  function prev() {
    character = position$2 > 0 ? charat(characters, --position$2) : 0;
    if (column--, character === 10)
      column = 1, line--;
    return character;
  }
  function next$1() {
    character = position$2 < length ? charat(characters, position$2++) : 0;
    if (column++, character === 10)
      column = 1, line++;
    return character;
  }
  function peek() {
    return charat(characters, position$2);
  }
  function caret() {
    return position$2;
  }
  function slice$1(begin, end2) {
    return substr(characters, begin, end2);
  }
  function token(type2) {
    switch (type2) {
      case 0:
      case 9:
      case 10:
      case 13:
      case 32:
        return 5;
      case 33:
      case 43:
      case 44:
      case 47:
      case 62:
      case 64:
      case 126:
      case 59:
      case 123:
      case 125:
        return 4;
      case 58:
        return 3;
      case 34:
      case 39:
      case 40:
      case 91:
        return 2;
      case 41:
      case 93:
        return 1;
    }
    return 0;
  }
  function alloc(value2) {
    return line = column = 1, length = strlen(characters = value2), position$2 = 0, [];
  }
  function dealloc(value2) {
    return characters = "", value2;
  }
  function delimit(type2) {
    return trim(slice$1(position$2 - 1, delimiter$1(type2 === 91 ? type2 + 2 : type2 === 40 ? type2 + 1 : type2)));
  }
  function whitespace(type2) {
    while (character = peek())
      if (character < 33)
        next$1();
      else
        break;
    return token(type2) > 2 || token(character) > 3 ? "" : " ";
  }
  function escaping(index2, count) {
    while (--count && next$1())
      if (character < 48 || character > 102 || character > 57 && character < 65 || character > 70 && character < 97)
        break;
    return slice$1(index2, caret() + (count < 6 && peek() == 32 && next$1() == 32));
  }
  function delimiter$1(type2) {
    while (next$1())
      switch (character) {
        case type2:
          return position$2;
        case 34:
        case 39:
          if (type2 !== 34 && type2 !== 39)
            delimiter$1(character);
          break;
        case 40:
          if (type2 === 41)
            delimiter$1(type2);
          break;
        case 92:
          next$1();
          break;
      }
    return position$2;
  }
  function commenter(type2, index2) {
    while (next$1())
      if (type2 + character === 47 + 10)
        break;
      else if (type2 + character === 42 + 42 && peek() === 47)
        break;
    return "/*" + slice$1(index2, position$2 - 1) + "*" + from(type2 === 47 ? type2 : next$1());
  }
  function identifier(index2) {
    while (!token(peek()))
      next$1();
    return slice$1(index2, position$2);
  }
  function compile(value2) {
    return dealloc(parse$4("", null, null, null, [""], value2 = alloc(value2), 0, [0], value2));
  }
  function parse$4(value2, root2, parent, rule, rules, rulesets, pseudo, points, declarations) {
    var index2 = 0;
    var offset = 0;
    var length2 = pseudo;
    var atrule = 0;
    var property2 = 0;
    var previous2 = 0;
    var variable = 1;
    var scanning = 1;
    var ampersand = 1;
    var character2 = 0;
    var type2 = "";
    var props = rules;
    var children2 = rulesets;
    var reference = rule;
    var characters2 = type2;
    while (scanning)
      switch (previous2 = character2, character2 = next$1()) {
        case 40:
          if (previous2 != 108 && charat(characters2, length2 - 1) == 58) {
            if (indexof(characters2 += replace(delimit(character2), "&", "&\f"), "&\f", abs(index2 ? points[index2 - 1] : 0)) != -1)
              ampersand = -1;
            break;
          }
        case 34:
        case 39:
        case 91:
          characters2 += delimit(character2);
          break;
        case 9:
        case 10:
        case 13:
        case 32:
          characters2 += whitespace(previous2);
          break;
        case 92:
          characters2 += escaping(caret() - 1, 7);
          continue;
        case 47:
          switch (peek()) {
            case 42:
            case 47:
              append(comment(commenter(next$1(), caret()), root2, parent, declarations), declarations);
              break;
            default:
              characters2 += "/";
          }
          break;
        case 123 * variable:
          points[index2++] = strlen(characters2) * ampersand;
        case 125 * variable:
        case 59:
        case 0:
          switch (character2) {
            case 0:
            case 125:
              scanning = 0;
            case 59 + offset:
              if (ampersand == -1)
                characters2 = replace(characters2, /\f/g, "");
              if (property2 > 0 && strlen(characters2) - length2)
                append(property2 > 32 ? declaration(characters2 + ";", rule, parent, length2 - 1, declarations) : declaration(replace(characters2, " ", "") + ";", rule, parent, length2 - 2, declarations), declarations);
              break;
            case 59:
              characters2 += ";";
            default:
              append(reference = ruleset(characters2, root2, parent, index2, offset, rules, points, type2, props = [], children2 = [], length2, rulesets), rulesets);
              if (character2 === 123)
                if (offset === 0)
                  parse$4(characters2, root2, reference, reference, props, rulesets, length2, points, children2);
                else
                  switch (atrule === 99 && charat(characters2, 3) === 110 ? 100 : atrule) {
                    case 100:
                    case 108:
                    case 109:
                    case 115:
                      parse$4(value2, reference, reference, rule && append(ruleset(value2, reference, reference, 0, 0, rules, points, type2, rules, props = [], length2, children2), children2), rules, children2, length2, points, rule ? props : children2);
                      break;
                    default:
                      parse$4(characters2, reference, reference, reference, [""], children2, 0, points, children2);
                  }
          }
          index2 = offset = property2 = 0, variable = ampersand = 1, type2 = characters2 = "", length2 = pseudo;
          break;
        case 58:
          length2 = 1 + strlen(characters2), property2 = previous2;
        default:
          if (variable < 1) {
            if (character2 == 123)
              --variable;
            else if (character2 == 125 && variable++ == 0 && prev() == 125)
              continue;
          }
          switch (characters2 += from(character2), character2 * variable) {
            case 38:
              ampersand = offset > 0 ? 1 : (characters2 += "\f", -1);
              break;
            case 44:
              points[index2++] = (strlen(characters2) - 1) * ampersand, ampersand = 1;
              break;
            case 64:
              if (peek() === 45)
                characters2 += delimit(next$1());
              atrule = peek(), offset = length2 = strlen(type2 = characters2 += identifier(caret())), character2++;
              break;
            case 45:
              if (previous2 === 45 && strlen(characters2) == 2)
                variable = 0;
          }
      }
    return rulesets;
  }
  function ruleset(value2, root2, parent, index2, offset, rules, points, type2, props, children2, length2, siblings) {
    var post = offset - 1;
    var rule = offset === 0 ? rules : [""];
    var size2 = sizeof(rule);
    for (var i2 = 0, j = 0, k = 0; i2 < index2; ++i2)
      for (var x2 = 0, y2 = substr(value2, post + 1, post = abs(j = points[i2])), z = value2; x2 < size2; ++x2)
        if (z = trim(j > 0 ? rule[x2] + " " + y2 : replace(y2, /&\f/g, rule[x2])))
          props[k++] = z;
    return node$1(value2, root2, parent, offset === 0 ? RULESET : type2, props, children2, length2, siblings);
  }
  function comment(value2, root2, parent, siblings) {
    return node$1(value2, root2, parent, COMMENT, from(char()), substr(value2, 2, -2), 0, siblings);
  }
  function declaration(value2, root2, parent, length2, siblings) {
    return node$1(value2, root2, parent, DECLARATION, substr(value2, 0, length2), substr(value2, length2 + 1, -1), length2, siblings);
  }
  function serialize(children2, callback) {
    var output = "";
    for (var i2 = 0; i2 < children2.length; i2++)
      output += callback(children2[i2], i2, children2, callback) || "";
    return output;
  }
  function stringify(element2, index2, children2, callback) {
    switch (element2.type) {
      case LAYER:
        if (element2.children.length)
          break;
      case IMPORT:
      case DECLARATION:
        return element2.return = element2.return || element2.value;
      case COMMENT:
        return "";
      case KEYFRAMES:
        return element2.return = element2.value + "{" + serialize(element2.children, callback) + "}";
      case RULESET:
        if (!strlen(element2.value = element2.props.join(",")))
          return "";
    }
    return strlen(children2 = serialize(element2.children, callback)) ? element2.return = element2.value + "{" + children2 + "}" : "";
  }
  const version$1 = "10.9.0";
  const defaultConfig$1 = Object.freeze(defaultConfig$2);
  let siteConfig = assignWithDepth$1({}, defaultConfig$1);
  let configFromInitialize;
  let directives = [];
  let currentConfig = assignWithDepth$1({}, defaultConfig$1);
  const updateCurrentConfig = (siteCfg, _directives) => {
    let cfg = assignWithDepth$1({}, siteCfg);
    let sumOfDirectives = {};
    for (const d of _directives) {
      sanitize(d);
      sumOfDirectives = assignWithDepth$1(sumOfDirectives, d);
    }
    cfg = assignWithDepth$1(cfg, sumOfDirectives);
    if (sumOfDirectives.theme && sumOfDirectives.theme in theme) {
      const tmpConfigFromInitialize = assignWithDepth$1({}, configFromInitialize);
      const themeVariables = assignWithDepth$1(
        tmpConfigFromInitialize.themeVariables || {},
        sumOfDirectives.themeVariables
      );
      if (cfg.theme && cfg.theme in theme) {
        cfg.themeVariables = theme[cfg.theme].getThemeVariables(themeVariables);
      }
    }
    currentConfig = cfg;
    checkConfig(currentConfig);
    return currentConfig;
  };
  const setSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1({}, defaultConfig$1);
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    if (conf2.theme && theme[conf2.theme]) {
      siteConfig.themeVariables = theme[conf2.theme].getThemeVariables(conf2.themeVariables);
    }
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const saveConfigFromInitialize = (conf2) => {
    configFromInitialize = assignWithDepth$1({}, conf2);
  };
  const updateSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const getSiteConfig = () => {
    return assignWithDepth$1({}, siteConfig);
  };
  const setConfig$1 = (conf2) => {
    checkConfig(conf2);
    assignWithDepth$1(currentConfig, conf2);
    return getConfig$2();
  };
  const getConfig$2 = () => {
    return assignWithDepth$1({}, currentConfig);
  };
  const sanitize = (options2) => {
    if (!options2) {
      return;
    }
    ["secure", ...siteConfig.secure ?? []].forEach((key) => {
      if (Object.hasOwn(options2, key)) {
        log$1.debug(`Denied attempt to modify a secure key ${key}`, options2[key]);
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (key.startsWith("__")) {
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (typeof options2[key] === "string" && (options2[key].includes("<") || options2[key].includes(">") || options2[key].includes("url(data:"))) {
        delete options2[key];
      }
      if (typeof options2[key] === "object") {
        sanitize(options2[key]);
      }
    });
  };
  const addDirective = (directive) => {
    sanitizeDirective(directive);
    if (directive.fontFamily && (!directive.themeVariables || !directive.themeVariables.fontFamily)) {
      directive.themeVariables = { fontFamily: directive.fontFamily };
    }
    directives.push(directive);
    updateCurrentConfig(siteConfig, directives);
  };
  const reset = (config2 = siteConfig) => {
    directives = [];
    updateCurrentConfig(config2, directives);
  };
  const ConfigWarning = {
    LAZY_LOAD_DEPRECATED: "The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead."
  };
  const issuedWarnings = {};
  const issueWarning = (warning) => {
    if (issuedWarnings[warning]) {
      return;
    }
    log$1.warn(ConfigWarning[warning]);
    issuedWarnings[warning] = true;
  };
  const checkConfig = (config2) => {
    if (!config2) {
      return;
    }
    if (config2.lazyLoadedDiagrams || config2.loadExternalDiagramsAtStartup) {
      issueWarning("LAZY_LOAD_DEPRECATED");
    }
  };
  const id$l = "c4";
  const detector$l = (txt) => {
    return /^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/.test(txt);
  };
  const loader$m = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => c4Diagram);
    return { id: id$l, diagram: diagram2 };
  };
  const plugin$j = {
    id: id$l,
    detector: detector$l,
    loader: loader$m
  };
  const c4 = plugin$j;
  const id$k = "flowchart";
  const detector$k = (txt, config2) => {
    var _a2, _b2;
    if (((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper" || ((_b2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b2.defaultRenderer) === "elk") {
      return false;
    }
    return /^\s*graph/.test(txt);
  };
  const loader$l = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagram);
    return { id: id$k, diagram: diagram2 };
  };
  const plugin$i = {
    id: id$k,
    detector: detector$k,
    loader: loader$l
  };
  const flowchart = plugin$i;
  const id$j = "flowchart-v2";
  const detector$j = (txt, config2) => {
    var _a2, _b2, _c;
    if (((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "dagre-d3" || ((_b2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b2.defaultRenderer) === "elk") {
      return false;
    }
    if (/^\s*graph/.test(txt) && ((_c = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _c.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return /^\s*flowchart/.test(txt);
  };
  const loader$k = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagramV2);
    return { id: id$j, diagram: diagram2 };
  };
  const plugin$h = {
    id: id$j,
    detector: detector$j,
    loader: loader$k
  };
  const flowchartV2 = plugin$h;
  const id$i = "er";
  const detector$i = (txt) => {
    return /^\s*erDiagram/.test(txt);
  };
  const loader$j = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => erDiagram);
    return { id: id$i, diagram: diagram2 };
  };
  const plugin$g = {
    id: id$i,
    detector: detector$i,
    loader: loader$j
  };
  const er = plugin$g;
  const id$h = "gitGraph";
  const detector$h = (txt) => {
    return /^\s*gitGraph/.test(txt);
  };
  const loader$i = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => gitGraphDiagram);
    return { id: id$h, diagram: diagram2 };
  };
  const plugin$f = {
    id: id$h,
    detector: detector$h,
    loader: loader$i
  };
  const git = plugin$f;
  const id$g = "gantt";
  const detector$g = (txt) => {
    return /^\s*gantt/.test(txt);
  };
  const loader$h = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => ganttDiagram);
    return { id: id$g, diagram: diagram2 };
  };
  const plugin$e = {
    id: id$g,
    detector: detector$g,
    loader: loader$h
  };
  const gantt = plugin$e;
  const id$f = "info";
  const detector$f = (txt) => {
    return /^\s*info/.test(txt);
  };
  const loader$g = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => infoDiagram);
    return { id: id$f, diagram: diagram2 };
  };
  const info$1 = {
    id: id$f,
    detector: detector$f,
    loader: loader$g
  };
  const id$e = "pie";
  const detector$e = (txt) => {
    return /^\s*pie/.test(txt);
  };
  const loader$f = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => pieDiagram);
    return { id: id$e, diagram: diagram2 };
  };
  const pie = {
    id: id$e,
    detector: detector$e,
    loader: loader$f
  };
  const id$d = "quadrantChart";
  const detector$d = (txt) => {
    return /^\s*quadrantChart/.test(txt);
  };
  const loader$e = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => quadrantDiagram);
    return { id: id$d, diagram: diagram2 };
  };
  const plugin$d = {
    id: id$d,
    detector: detector$d,
    loader: loader$e
  };
  const quadrantChart = plugin$d;
  const id$c = "xychart";
  const detector$c = (txt) => {
    return /^\s*xychart-beta/.test(txt);
  };
  const loader$d = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => xychartDiagram);
    return { id: id$c, diagram: diagram2 };
  };
  const plugin$c = {
    id: id$c,
    detector: detector$c,
    loader: loader$d
  };
  const xychart = plugin$c;
  const id$b = "requirement";
  const detector$b = (txt) => {
    return /^\s*requirement(Diagram)?/.test(txt);
  };
  const loader$c = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => requirementDiagram);
    return { id: id$b, diagram: diagram2 };
  };
  const plugin$b = {
    id: id$b,
    detector: detector$b,
    loader: loader$c
  };
  const requirement = plugin$b;
  const id$a = "sequence";
  const detector$a = (txt) => {
    return /^\s*sequenceDiagram/.test(txt);
  };
  const loader$b = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => sequenceDiagram);
    return { id: id$a, diagram: diagram2 };
  };
  const plugin$a = {
    id: id$a,
    detector: detector$a,
    loader: loader$b
  };
  const sequence = plugin$a;
  const id$9 = "class";
  const detector$9 = (txt, config2) => {
    var _a2;
    if (((_a2 = config2 == null ? void 0 : config2.class) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return /^\s*classDiagram/.test(txt);
  };
  const loader$a = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagram);
    return { id: id$9, diagram: diagram2 };
  };
  const plugin$9 = {
    id: id$9,
    detector: detector$9,
    loader: loader$a
  };
  const classDiagram$1 = plugin$9;
  const id$8 = "classDiagram";
  const detector$8 = (txt, config2) => {
    var _a2;
    if (/^\s*classDiagram/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.class) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return /^\s*classDiagram-v2/.test(txt);
  };
  const loader$9 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagramV2);
    return { id: id$8, diagram: diagram2 };
  };
  const plugin$8 = {
    id: id$8,
    detector: detector$8,
    loader: loader$9
  };
  const classDiagramV2$1 = plugin$8;
  const id$7 = "state";
  const detector$7 = (txt, config2) => {
    var _a2;
    if (((_a2 = config2 == null ? void 0 : config2.state) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return /^\s*stateDiagram/.test(txt);
  };
  const loader$8 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagram);
    return { id: id$7, diagram: diagram2 };
  };
  const plugin$7 = {
    id: id$7,
    detector: detector$7,
    loader: loader$8
  };
  const state$1 = plugin$7;
  const id$6 = "stateDiagram";
  const detector$6 = (txt, config2) => {
    var _a2;
    if (/^\s*stateDiagram-v2/.test(txt)) {
      return true;
    }
    if (/^\s*stateDiagram/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.state) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return false;
  };
  const loader$7 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagramV2);
    return { id: id$6, diagram: diagram2 };
  };
  const plugin$6 = {
    id: id$6,
    detector: detector$6,
    loader: loader$7
  };
  const stateV2 = plugin$6;
  const id$5 = "journey";
  const detector$5 = (txt) => {
    return /^\s*journey/.test(txt);
  };
  const loader$6 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => journeyDiagram);
    return { id: id$5, diagram: diagram2 };
  };
  const plugin$5 = {
    id: id$5,
    detector: detector$5,
    loader: loader$6
  };
  const journey = plugin$5;
  const d3Attrs = function(d3Elem, attrs) {
    for (let attr of attrs) {
      d3Elem.attr(attr[0], attr[1]);
    }
  };
  const calculateSvgSizeAttrs = function(height, width2, useMaxWidth) {
    let attrs = /* @__PURE__ */ new Map();
    if (useMaxWidth) {
      attrs.set("width", "100%");
      attrs.set("style", `max-width: ${width2}px;`);
    } else {
      attrs.set("height", height);
      attrs.set("width", width2);
    }
    return attrs;
  };
  const configureSvgSize = function(svgElem, height, width2, useMaxWidth) {
    const attrs = calculateSvgSizeAttrs(height, width2, useMaxWidth);
    d3Attrs(svgElem, attrs);
  };
  const setupGraphViewbox$1 = function(graph, svgElem, padding2, useMaxWidth) {
    const svgBounds = svgElem.node().getBBox();
    const sWidth = svgBounds.width;
    const sHeight = svgBounds.height;
    log$1.info(`SVG bounds: ${sWidth}x${sHeight}`, svgBounds);
    let width2 = 0;
    let height = 0;
    log$1.info(`Graph bounds: ${width2}x${height}`, graph);
    width2 = sWidth + padding2 * 2;
    height = sHeight + padding2 * 2;
    log$1.info(`Calculated bounds: ${width2}x${height}`);
    configureSvgSize(svgElem, height, width2, useMaxWidth);
    const vBox = `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${svgBounds.width + 2 * padding2} ${svgBounds.height + 2 * padding2}`;
    svgElem.attr("viewBox", vBox);
  };
  const themes = {};
  const getStyles$f = (type2, userStyles, options2) => {
    let diagramStyles = "";
    if (type2 in themes && themes[type2]) {
      diagramStyles = themes[type2](options2);
    } else {
      log$1.warn(`No theme found for ${type2}`);
    }
    return ` & {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
    fill: ${options2.textColor}
  }

  /* Classes common for multiple diagrams */

  & .error-icon {
    fill: ${options2.errorBkgColor};
  }
  & .error-text {
    fill: ${options2.errorTextColor};
    stroke: ${options2.errorTextColor};
  }

  & .edge-thickness-normal {
    stroke-width: 2px;
  }
  & .edge-thickness-thick {
    stroke-width: 3.5px
  }
  & .edge-pattern-solid {
    stroke-dasharray: 0;
  }

  & .edge-pattern-dashed{
    stroke-dasharray: 3;
  }
  .edge-pattern-dotted {
    stroke-dasharray: 2;
  }

  & .marker {
    fill: ${options2.lineColor};
    stroke: ${options2.lineColor};
  }
  & .marker.cross {
    stroke: ${options2.lineColor};
  }

  & svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  ${diagramStyles}

  ${userStyles}
`;
  };
  const addStylesForDiagram = (type2, diagramTheme) => {
    if (diagramTheme !== void 0) {
      themes[type2] = diagramTheme;
    }
  };
  const getStyles$g = getStyles$f;
  let accTitle = "";
  let diagramTitle = "";
  let accDescription = "";
  const sanitizeText$4 = (txt) => sanitizeText$5(txt, getConfig$2());
  const clear$n = () => {
    accTitle = "";
    accDescription = "";
    diagramTitle = "";
  };
  const setAccTitle = (txt) => {
    accTitle = sanitizeText$4(txt).replace(/^\s+/g, "");
  };
  const getAccTitle = () => accTitle;
  const setAccDescription = (txt) => {
    accDescription = sanitizeText$4(txt).replace(/\n\s+/g, "\n");
  };
  const getAccDescription = () => accDescription;
  const setDiagramTitle = (txt) => {
    diagramTitle = sanitizeText$4(txt);
  };
  const getDiagramTitle = () => diagramTitle;
  const commonDb = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    clear: clear$n,
    getAccDescription,
    getAccTitle,
    getDiagramTitle,
    setAccDescription,
    setAccTitle,
    setDiagramTitle
  }, Symbol.toStringTag, { value: "Module" }));
  const log = log$1;
  const setLogLevel = setLogLevel$1;
  const getConfig$1 = getConfig$2;
  const setConfig = setConfig$1;
  const defaultConfig = defaultConfig$1;
  const sanitizeText$3 = (text2) => sanitizeText$5(text2, getConfig$1());
  const setupGraphViewbox = setupGraphViewbox$1;
  const getCommonDb$1 = () => {
    return commonDb;
  };
  const diagrams = {};
  const registerDiagram = (id2, diagram2, detector2) => {
    var _a2;
    if (diagrams[id2]) {
      throw new Error(`Diagram ${id2} already registered.`);
    }
    diagrams[id2] = diagram2;
    if (detector2) {
      addDetector(id2, detector2);
    }
    addStylesForDiagram(id2, diagram2.styles);
    (_a2 = diagram2.injectUtils) == null ? void 0 : _a2.call(
      diagram2,
      log,
      setLogLevel,
      getConfig$1,
      sanitizeText$3,
      setupGraphViewbox,
      getCommonDb$1(),
      () => {
      }
    );
  };
  const getDiagram = (name) => {
    if (name in diagrams) {
      return diagrams[name];
    }
    throw new DiagramNotFoundError(name);
  };
  class DiagramNotFoundError extends Error {
    constructor(name) {
      super(`Diagram ${name} not found.`);
    }
  }
  const selectSvgElement = (id2) => {
    var _a2;
    const { securityLevel } = getConfig$1();
    let root2 = d3select("body");
    if (securityLevel === "sandbox") {
      const sandboxElement = d3select(`#i${id2}`);
      const doc = ((_a2 = sandboxElement.node()) == null ? void 0 : _a2.contentDocument) ?? document;
      root2 = d3select(doc.body);
    }
    const svg2 = root2.select(`#${id2}`);
    return svg2;
  };
  const draw$m = (_text, id2, version2) => {
    log$1.debug("rendering svg for syntax error\n");
    const svg2 = selectSvgElement(id2);
    const g = svg2.append("g");
    svg2.attr("viewBox", "0 0 2412 512");
    configureSvgSize(svg2, 100, 512, true);
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m411.313,123.313c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32-9.375,9.375-20.688-20.688c-12.484-12.5-32.766-12.5-45.25,0l-16,16c-1.261,1.261-2.304,2.648-3.31,4.051-21.739-8.561-45.324-13.426-70.065-13.426-105.867,0-192,86.133-192,192s86.133,192 192,192 192-86.133 192-192c0-24.741-4.864-48.327-13.426-70.065 1.402-1.007 2.79-2.049 4.051-3.31l16-16c12.5-12.492 12.5-32.758 0-45.25l-20.688-20.688 9.375-9.375 32.001-31.999zm-219.313,100.687c-52.938,0-96,43.063-96,96 0,8.836-7.164,16-16,16s-16-7.164-16-16c0-70.578 57.422-128 128-128 8.836,0 16,7.164 16,16s-7.164,16-16,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m459.02,148.98c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l16,16c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16.001-16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m340.395,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16-16c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l15.999,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m400,64c8.844,0 16-7.164 16-16v-32c0-8.836-7.156-16-16-16-8.844,0-16,7.164-16,16v32c0,8.836 7.156,16 16,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m496,96.586h-32c-8.844,0-16,7.164-16,16 0,8.836 7.156,16 16,16h32c8.844,0 16-7.164 16-16 0-8.836-7.156-16-16-16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m436.98,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688l32-32c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32c-6.251,6.25-6.251,16.375-0.001,22.625z"
    );
    g.append("text").attr("class", "error-text").attr("x", 1440).attr("y", 250).attr("font-size", "150px").style("text-anchor", "middle").text("Syntax error in text");
    g.append("text").attr("class", "error-text").attr("x", 1250).attr("y", 400).attr("font-size", "100px").style("text-anchor", "middle").text(`mermaid version ${version2}`);
  };
  const renderer$h = { draw: draw$m };
  const errorRenderer = renderer$h;
  const diagram$m = {
    db: {},
    renderer: renderer$h,
    parser: {
      parser: { yy: {} },
      parse: () => {
        return;
      }
    }
  };
  const errorDiagram = diagram$m;
  const id$4 = "flowchart-elk";
  const detector$4 = (txt, config2) => {
    var _a2;
    if (
      // If diagram explicitly states flowchart-elk
      /^\s*flowchart-elk/.test(txt) || // If a flowchart/graph diagram has their default renderer set to elk
      /^\s*flowchart|graph/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "elk"
    ) {
      return true;
    }
    return false;
  };
  const loader$5 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowchartElkDefinition);
    return { id: id$4, diagram: diagram2 };
  };
  const plugin$4 = {
    id: id$4,
    detector: detector$4,
    loader: loader$5
  };
  const flowchartElk = plugin$4;
  const id$3 = "timeline";
  const detector$3 = (txt) => {
    return /^\s*timeline/.test(txt);
  };
  const loader$4 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => timelineDefinition);
    return { id: id$3, diagram: diagram2 };
  };
  const plugin$3 = {
    id: id$3,
    detector: detector$3,
    loader: loader$4
  };
  const timeline = plugin$3;
  const id$2 = "mindmap";
  const detector$2 = (txt) => {
    return /^\s*mindmap/.test(txt);
  };
  const loader$3 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => mindmapDefinition);
    return { id: id$2, diagram: diagram2 };
  };
  const plugin$2 = {
    id: id$2,
    detector: detector$2,
    loader: loader$3
  };
  const mindmap = plugin$2;
  const id$1 = "sankey";
  const detector$1 = (txt) => {
    return /^\s*sankey-beta/.test(txt);
  };
  const loader$2 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => sankeyDiagram);
    return { id: id$1, diagram: diagram2 };
  };
  const plugin$1 = {
    id: id$1,
    detector: detector$1,
    loader: loader$2
  };
  const sankey = plugin$1;
  const id = "block";
  const detector = (txt) => {
    return /^\s*block-beta/.test(txt);
  };
  const loader$1 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => blockDiagram);
    return { id, diagram: diagram2 };
  };
  const plugin = {
    id,
    detector,
    loader: loader$1
  };
  const block = plugin;
  let hasLoadedDiagrams = false;
  const addDiagrams = () => {
    if (hasLoadedDiagrams) {
      return;
    }
    hasLoadedDiagrams = true;
    registerDiagram("error", errorDiagram, (text2) => {
      return text2.toLowerCase().trim() === "error";
    });
    registerDiagram(
      "---",
      // --- diagram type may appear if YAML front-matter is not parsed correctly
      {
        db: {
          clear: () => {
          }
        },
        styles: {},
        // should never be used
        renderer: {
          draw: () => {
          }
        },
        parser: {
          parser: { yy: {} },
          parse: () => {
            throw new Error(
              "Diagrams beginning with --- are not valid. If you were trying to use a YAML front-matter, please ensure that you've correctly opened and closed the YAML front-matter with un-indented `---` blocks"
            );
          }
        },
        init: () => null
        // no op
      },
      (text2) => {
        return text2.toLowerCase().trimStart().startsWith("---");
      }
    );
    registerLazyLoadedDiagrams(
      c4,
      classDiagramV2$1,
      classDiagram$1,
      er,
      gantt,
      info$1,
      pie,
      requirement,
      sequence,
      flowchartElk,
      flowchartV2,
      flowchart,
      mindmap,
      timeline,
      git,
      stateV2,
      state$1,
      journey,
      quadrantChart,
      sankey,
      xychart,
      block
    );
  };
  class Diagram {
    constructor(text2, metadata = {}) {
      this.text = text2;
      this.metadata = metadata;
      this.type = "graph";
      this.text = encodeEntities(text2);
      this.text += "\n";
      const cnf = getConfig$2();
      try {
        this.type = detectType(text2, cnf);
      } catch (e) {
        this.type = "error";
        this.detectError = e;
      }
      const diagram2 = getDiagram(this.type);
      log$1.debug("Type " + this.type);
      this.db = diagram2.db;
      this.renderer = diagram2.renderer;
      this.parser = diagram2.parser;
      this.parser.parser.yy = this.db;
      this.init = diagram2.init;
      this.parse();
    }
    parse() {
      var _a2, _b2, _c, _d, _e;
      if (this.detectError) {
        throw this.detectError;
      }
      (_b2 = (_a2 = this.db).clear) == null ? void 0 : _b2.call(_a2);
      const config2 = getConfig$2();
      (_c = this.init) == null ? void 0 : _c.call(this, config2);
      if (this.metadata.title) {
        (_e = (_d = this.db).setDiagramTitle) == null ? void 0 : _e.call(_d, this.metadata.title);
      }
      this.parser.parse(this.text);
    }
    async render(id2, version2) {
      await this.renderer.draw(this.text, id2, version2, this);
    }
    getParser() {
      return this.parser;
    }
    getType() {
      return this.type;
    }
  }
  const getDiagramFromText$1 = async (text2, metadata = {}) => {
    const type2 = detectType(text2, getConfig$2());
    try {
      getDiagram(type2);
    } catch (error) {
      const loader2 = getDiagramLoader(type2);
      if (!loader2) {
        throw new UnknownDiagramError(`Diagram ${type2} not found.`);
      }
      const { id: id2, diagram: diagram2 } = await loader2();
      registerDiagram(id2, diagram2);
    }
    return new Diagram(text2, metadata);
  };
  let interactionFunctions = [];
  const attachFunctions = () => {
    interactionFunctions.forEach((f2) => {
      f2();
    });
    interactionFunctions = [];
  };
  var nativeKeys = overArg(Object.keys, Object);
  const nativeKeys$1 = nativeKeys;
  var objectProto$7 = Object.prototype;
  var hasOwnProperty$7 = objectProto$7.hasOwnProperty;
  function baseKeys(object2) {
    if (!isPrototype(object2)) {
      return nativeKeys$1(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$7.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  var DataView$1 = getNative(root$1, "DataView");
  const DataView$2 = DataView$1;
  var Promise$1 = getNative(root$1, "Promise");
  const Promise$2 = Promise$1;
  var Set$1 = getNative(root$1, "Set");
  const Set$2 = Set$1;
  var WeakMap = getNative(root$1, "WeakMap");
  const WeakMap$1 = WeakMap;
  var mapTag$5 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$5 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$3 = "[object DataView]";
  var dataViewCtorString = toSource(DataView$2), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$1);
  var getTag = baseGetTag;
  if (DataView$2 && getTag(new DataView$2(new ArrayBuffer(1))) != dataViewTag$3 || Map$2 && getTag(new Map$2()) != mapTag$5 || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$2 && getTag(new Set$2()) != setTag$5 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$1) {
    getTag = function(value2) {
      var result = baseGetTag(value2), Ctor = result == objectTag$2 ? value2.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$3;
          case mapCtorString:
            return mapTag$5;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$5;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  const getTag$1 = getTag;
  var mapTag$4 = "[object Map]", setTag$4 = "[object Set]";
  var objectProto$6 = Object.prototype;
  var hasOwnProperty$6 = objectProto$6.hasOwnProperty;
  function isEmpty(value2) {
    if (value2 == null) {
      return true;
    }
    if (isArrayLike(value2) && (isArray$1(value2) || typeof value2 == "string" || typeof value2.splice == "function" || isBuffer$1(value2) || isTypedArray$1(value2) || isArguments$1(value2))) {
      return !value2.length;
    }
    var tag = getTag$1(value2);
    if (tag == mapTag$4 || tag == setTag$4) {
      return !value2.size;
    }
    if (isPrototype(value2)) {
      return !baseKeys(value2).length;
    }
    for (var key in value2) {
      if (hasOwnProperty$6.call(value2, key)) {
        return false;
      }
    }
    return true;
  }
  const SVG_ROLE = "graphics-document document";
  function setA11yDiagramInfo(svg2, diagramType) {
    svg2.attr("role", SVG_ROLE);
    if (diagramType !== "") {
      svg2.attr("aria-roledescription", diagramType);
    }
  }
  function addSVGa11yTitleDescription(svg2, a11yTitle, a11yDesc, baseId) {
    if (svg2.insert === void 0) {
      return;
    }
    if (a11yDesc) {
      const descId = `chart-desc-${baseId}`;
      svg2.attr("aria-describedby", descId);
      svg2.insert("desc", ":first-child").attr("id", descId).text(a11yDesc);
    }
    if (a11yTitle) {
      const titleId = `chart-title-${baseId}`;
      svg2.attr("aria-labelledby", titleId);
      svg2.insert("title", ":first-child").attr("id", titleId).text(a11yTitle);
    }
  }
  const cleanupComments = (text2) => {
    return text2.replace(/^\s*%%(?!{)[^\n]+\n?/gm, "").trimStart();
  };
  /*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
  function isNothing(subject) {
    return typeof subject === "undefined" || subject === null;
  }
  function isObject(subject) {
    return typeof subject === "object" && subject !== null;
  }
  function toArray(sequence2) {
    if (Array.isArray(sequence2))
      return sequence2;
    else if (isNothing(sequence2))
      return [];
    return [sequence2];
  }
  function extend(target, source) {
    var index2, length2, key, sourceKeys;
    if (source) {
      sourceKeys = Object.keys(source);
      for (index2 = 0, length2 = sourceKeys.length; index2 < length2; index2 += 1) {
        key = sourceKeys[index2];
        target[key] = source[key];
      }
    }
    return target;
  }
  function repeat(string2, count) {
    var result = "", cycle;
    for (cycle = 0; cycle < count; cycle += 1) {
      result += string2;
    }
    return result;
  }
  function isNegativeZero(number2) {
    return number2 === 0 && Number.NEGATIVE_INFINITY === 1 / number2;
  }
  var isNothing_1 = isNothing;
  var isObject_1 = isObject;
  var toArray_1 = toArray;
  var repeat_1 = repeat;
  var isNegativeZero_1 = isNegativeZero;
  var extend_1 = extend;
  var common = {
    isNothing: isNothing_1,
    isObject: isObject_1,
    toArray: toArray_1,
    repeat: repeat_1,
    isNegativeZero: isNegativeZero_1,
    extend: extend_1
  };
  function formatError(exception2, compact) {
    var where = "", message = exception2.reason || "(unknown reason)";
    if (!exception2.mark)
      return message;
    if (exception2.mark.name) {
      where += 'in "' + exception2.mark.name + '" ';
    }
    where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
    if (!compact && exception2.mark.snippet) {
      where += "\n\n" + exception2.mark.snippet;
    }
    return message + " " + where;
  }
  function YAMLException$1(reason, mark) {
    Error.call(this);
    this.name = "YAMLException";
    this.reason = reason;
    this.mark = mark;
    this.message = formatError(this, false);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack || "";
    }
  }
  YAMLException$1.prototype = Object.create(Error.prototype);
  YAMLException$1.prototype.constructor = YAMLException$1;
  YAMLException$1.prototype.toString = function toString2(compact) {
    return this.name + ": " + formatError(this, compact);
  };
  var exception = YAMLException$1;
  function getLine(buffer, lineStart, lineEnd, position2, maxLineLength) {
    var head2 = "";
    var tail = "";
    var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
    if (position2 - lineStart > maxHalfLength) {
      head2 = " ... ";
      lineStart = position2 - maxHalfLength + head2.length;
    }
    if (lineEnd - position2 > maxHalfLength) {
      tail = " ...";
      lineEnd = position2 + maxHalfLength - tail.length;
    }
    return {
      str: head2 + buffer.slice(lineStart, lineEnd).replace(/\t/g, "→") + tail,
      pos: position2 - lineStart + head2.length
      // relative position
    };
  }
  function padStart(string2, max2) {
    return common.repeat(" ", max2 - string2.length) + string2;
  }
  function makeSnippet(mark, options2) {
    options2 = Object.create(options2 || null);
    if (!mark.buffer)
      return null;
    if (!options2.maxLength)
      options2.maxLength = 79;
    if (typeof options2.indent !== "number")
      options2.indent = 1;
    if (typeof options2.linesBefore !== "number")
      options2.linesBefore = 3;
    if (typeof options2.linesAfter !== "number")
      options2.linesAfter = 2;
    var re2 = /\r?\n|\r|\0/g;
    var lineStarts = [0];
    var lineEnds = [];
    var match;
    var foundLineNo = -1;
    while (match = re2.exec(mark.buffer)) {
      lineEnds.push(match.index);
      lineStarts.push(match.index + match[0].length);
      if (mark.position <= match.index && foundLineNo < 0) {
        foundLineNo = lineStarts.length - 2;
      }
    }
    if (foundLineNo < 0)
      foundLineNo = lineStarts.length - 1;
    var result = "", i2, line2;
    var lineNoLength = Math.min(mark.line + options2.linesAfter, lineEnds.length).toString().length;
    var maxLineLength = options2.maxLength - (options2.indent + lineNoLength + 3);
    for (i2 = 1; i2 <= options2.linesBefore; i2++) {
      if (foundLineNo - i2 < 0)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo - i2],
        lineEnds[foundLineNo - i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i2]),
        maxLineLength
      );
      result = common.repeat(" ", options2.indent) + padStart((mark.line - i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n" + result;
    }
    line2 = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
    result += common.repeat(" ", options2.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    result += common.repeat("-", options2.indent + lineNoLength + 3 + line2.pos) + "^\n";
    for (i2 = 1; i2 <= options2.linesAfter; i2++) {
      if (foundLineNo + i2 >= lineEnds.length)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo + i2],
        lineEnds[foundLineNo + i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i2]),
        maxLineLength
      );
      result += common.repeat(" ", options2.indent) + padStart((mark.line + i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    }
    return result.replace(/\n$/, "");
  }
  var snippet = makeSnippet;
  var TYPE_CONSTRUCTOR_OPTIONS = [
    "kind",
    "multi",
    "resolve",
    "construct",
    "instanceOf",
    "predicate",
    "represent",
    "representName",
    "defaultStyle",
    "styleAliases"
  ];
  var YAML_NODE_KINDS = [
    "scalar",
    "sequence",
    "mapping"
  ];
  function compileStyleAliases(map2) {
    var result = {};
    if (map2 !== null) {
      Object.keys(map2).forEach(function(style) {
        map2[style].forEach(function(alias) {
          result[String(alias)] = style;
        });
      });
    }
    return result;
  }
  function Type$1(tag, options2) {
    options2 = options2 || {};
    Object.keys(options2).forEach(function(name) {
      if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
        throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
      }
    });
    this.options = options2;
    this.tag = tag;
    this.kind = options2["kind"] || null;
    this.resolve = options2["resolve"] || function() {
      return true;
    };
    this.construct = options2["construct"] || function(data) {
      return data;
    };
    this.instanceOf = options2["instanceOf"] || null;
    this.predicate = options2["predicate"] || null;
    this.represent = options2["represent"] || null;
    this.representName = options2["representName"] || null;
    this.defaultStyle = options2["defaultStyle"] || null;
    this.multi = options2["multi"] || false;
    this.styleAliases = compileStyleAliases(options2["styleAliases"] || null);
    if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
      throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
    }
  }
  var type = Type$1;
  function compileList(schema2, name) {
    var result = [];
    schema2[name].forEach(function(currentType) {
      var newIndex = result.length;
      result.forEach(function(previousType, previousIndex) {
        if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
          newIndex = previousIndex;
        }
      });
      result[newIndex] = currentType;
    });
    return result;
  }
  function compileMap() {
    var result = {
      scalar: {},
      sequence: {},
      mapping: {},
      fallback: {},
      multi: {
        scalar: [],
        sequence: [],
        mapping: [],
        fallback: []
      }
    }, index2, length2;
    function collectType(type2) {
      if (type2.multi) {
        result.multi[type2.kind].push(type2);
        result.multi["fallback"].push(type2);
      } else {
        result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
      }
    }
    for (index2 = 0, length2 = arguments.length; index2 < length2; index2 += 1) {
      arguments[index2].forEach(collectType);
    }
    return result;
  }
  function Schema$1(definition2) {
    return this.extend(definition2);
  }
  Schema$1.prototype.extend = function extend2(definition2) {
    var implicit2 = [];
    var explicit = [];
    if (definition2 instanceof type) {
      explicit.push(definition2);
    } else if (Array.isArray(definition2)) {
      explicit = explicit.concat(definition2);
    } else if (definition2 && (Array.isArray(definition2.implicit) || Array.isArray(definition2.explicit))) {
      if (definition2.implicit)
        implicit2 = implicit2.concat(definition2.implicit);
      if (definition2.explicit)
        explicit = explicit.concat(definition2.explicit);
    } else {
      throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
    }
    implicit2.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
      if (type$1.loadKind && type$1.loadKind !== "scalar") {
        throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
      }
      if (type$1.multi) {
        throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
      }
    });
    explicit.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
    });
    var result = Object.create(Schema$1.prototype);
    result.implicit = (this.implicit || []).concat(implicit2);
    result.explicit = (this.explicit || []).concat(explicit);
    result.compiledImplicit = compileList(result, "implicit");
    result.compiledExplicit = compileList(result, "explicit");
    result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
    return result;
  };
  var schema = Schema$1;
  var str = new type("tag:yaml.org,2002:str", {
    kind: "scalar",
    construct: function(data) {
      return data !== null ? data : "";
    }
  });
  var seq$1 = new type("tag:yaml.org,2002:seq", {
    kind: "sequence",
    construct: function(data) {
      return data !== null ? data : [];
    }
  });
  var map$1 = new type("tag:yaml.org,2002:map", {
    kind: "mapping",
    construct: function(data) {
      return data !== null ? data : {};
    }
  });
  var failsafe = new schema({
    explicit: [
      str,
      seq$1,
      map$1
    ]
  });
  function resolveYamlNull(data) {
    if (data === null)
      return true;
    var max2 = data.length;
    return max2 === 1 && data === "~" || max2 === 4 && (data === "null" || data === "Null" || data === "NULL");
  }
  function constructYamlNull() {
    return null;
  }
  function isNull(object2) {
    return object2 === null;
  }
  var _null = new type("tag:yaml.org,2002:null", {
    kind: "scalar",
    resolve: resolveYamlNull,
    construct: constructYamlNull,
    predicate: isNull,
    represent: {
      canonical: function() {
        return "~";
      },
      lowercase: function() {
        return "null";
      },
      uppercase: function() {
        return "NULL";
      },
      camelcase: function() {
        return "Null";
      },
      empty: function() {
        return "";
      }
    },
    defaultStyle: "lowercase"
  });
  function resolveYamlBoolean(data) {
    if (data === null)
      return false;
    var max2 = data.length;
    return max2 === 4 && (data === "true" || data === "True" || data === "TRUE") || max2 === 5 && (data === "false" || data === "False" || data === "FALSE");
  }
  function constructYamlBoolean(data) {
    return data === "true" || data === "True" || data === "TRUE";
  }
  function isBoolean(object2) {
    return Object.prototype.toString.call(object2) === "[object Boolean]";
  }
  var bool = new type("tag:yaml.org,2002:bool", {
    kind: "scalar",
    resolve: resolveYamlBoolean,
    construct: constructYamlBoolean,
    predicate: isBoolean,
    represent: {
      lowercase: function(object2) {
        return object2 ? "true" : "false";
      },
      uppercase: function(object2) {
        return object2 ? "TRUE" : "FALSE";
      },
      camelcase: function(object2) {
        return object2 ? "True" : "False";
      }
    },
    defaultStyle: "lowercase"
  });
  function isHexCode(c2) {
    return 48 <= c2 && c2 <= 57 || 65 <= c2 && c2 <= 70 || 97 <= c2 && c2 <= 102;
  }
  function isOctCode(c2) {
    return 48 <= c2 && c2 <= 55;
  }
  function isDecCode(c2) {
    return 48 <= c2 && c2 <= 57;
  }
  function resolveYamlInteger(data) {
    if (data === null)
      return false;
    var max2 = data.length, index2 = 0, hasDigits = false, ch2;
    if (!max2)
      return false;
    ch2 = data[index2];
    if (ch2 === "-" || ch2 === "+") {
      ch2 = data[++index2];
    }
    if (ch2 === "0") {
      if (index2 + 1 === max2)
        return true;
      ch2 = data[++index2];
      if (ch2 === "b") {
        index2++;
        for (; index2 < max2; index2++) {
          ch2 = data[index2];
          if (ch2 === "_")
            continue;
          if (ch2 !== "0" && ch2 !== "1")
            return false;
          hasDigits = true;
        }
        return hasDigits && ch2 !== "_";
      }
      if (ch2 === "x") {
        index2++;
        for (; index2 < max2; index2++) {
          ch2 = data[index2];
          if (ch2 === "_")
            continue;
          if (!isHexCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch2 !== "_";
      }
      if (ch2 === "o") {
        index2++;
        for (; index2 < max2; index2++) {
          ch2 = data[index2];
          if (ch2 === "_")
            continue;
          if (!isOctCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch2 !== "_";
      }
    }
    if (ch2 === "_")
      return false;
    for (; index2 < max2; index2++) {
      ch2 = data[index2];
      if (ch2 === "_")
        continue;
      if (!isDecCode(data.charCodeAt(index2))) {
        return false;
      }
      hasDigits = true;
    }
    if (!hasDigits || ch2 === "_")
      return false;
    return true;
  }
  function constructYamlInteger(data) {
    var value2 = data, sign2 = 1, ch2;
    if (value2.indexOf("_") !== -1) {
      value2 = value2.replace(/_/g, "");
    }
    ch2 = value2[0];
    if (ch2 === "-" || ch2 === "+") {
      if (ch2 === "-")
        sign2 = -1;
      value2 = value2.slice(1);
      ch2 = value2[0];
    }
    if (value2 === "0")
      return 0;
    if (ch2 === "0") {
      if (value2[1] === "b")
        return sign2 * parseInt(value2.slice(2), 2);
      if (value2[1] === "x")
        return sign2 * parseInt(value2.slice(2), 16);
      if (value2[1] === "o")
        return sign2 * parseInt(value2.slice(2), 8);
    }
    return sign2 * parseInt(value2, 10);
  }
  function isInteger(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 === 0 && !common.isNegativeZero(object2));
  }
  var int = new type("tag:yaml.org,2002:int", {
    kind: "scalar",
    resolve: resolveYamlInteger,
    construct: constructYamlInteger,
    predicate: isInteger,
    represent: {
      binary: function(obj) {
        return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
      },
      octal: function(obj) {
        return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
      },
      decimal: function(obj) {
        return obj.toString(10);
      },
      /* eslint-disable max-len */
      hexadecimal: function(obj) {
        return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
      }
    },
    defaultStyle: "decimal",
    styleAliases: {
      binary: [2, "bin"],
      octal: [8, "oct"],
      decimal: [10, "dec"],
      hexadecimal: [16, "hex"]
    }
  });
  var YAML_FLOAT_PATTERN = new RegExp(
    // 2.5e4, 2.5 and integers
    "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
  );
  function resolveYamlFloat(data) {
    if (data === null)
      return false;
    if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
    // Probably should update regexp & check speed
    data[data.length - 1] === "_") {
      return false;
    }
    return true;
  }
  function constructYamlFloat(data) {
    var value2, sign2;
    value2 = data.replace(/_/g, "").toLowerCase();
    sign2 = value2[0] === "-" ? -1 : 1;
    if ("+-".indexOf(value2[0]) >= 0) {
      value2 = value2.slice(1);
    }
    if (value2 === ".inf") {
      return sign2 === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    } else if (value2 === ".nan") {
      return NaN;
    }
    return sign2 * parseFloat(value2, 10);
  }
  var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
  function representYamlFloat(object2, style) {
    var res;
    if (isNaN(object2)) {
      switch (style) {
        case "lowercase":
          return ".nan";
        case "uppercase":
          return ".NAN";
        case "camelcase":
          return ".NaN";
      }
    } else if (Number.POSITIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return ".inf";
        case "uppercase":
          return ".INF";
        case "camelcase":
          return ".Inf";
      }
    } else if (Number.NEGATIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return "-.inf";
        case "uppercase":
          return "-.INF";
        case "camelcase":
          return "-.Inf";
      }
    } else if (common.isNegativeZero(object2)) {
      return "-0.0";
    }
    res = object2.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
  }
  function isFloat(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 !== 0 || common.isNegativeZero(object2));
  }
  var float = new type("tag:yaml.org,2002:float", {
    kind: "scalar",
    resolve: resolveYamlFloat,
    construct: constructYamlFloat,
    predicate: isFloat,
    represent: representYamlFloat,
    defaultStyle: "lowercase"
  });
  var json = failsafe.extend({
    implicit: [
      _null,
      bool,
      int,
      float
    ]
  });
  var core = json;
  var YAML_DATE_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
  );
  var YAML_TIMESTAMP_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
  );
  function resolveYamlTimestamp(data) {
    if (data === null)
      return false;
    if (YAML_DATE_REGEXP.exec(data) !== null)
      return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data) !== null)
      return true;
    return false;
  }
  function constructYamlTimestamp(data) {
    var match, year, month, day, hour, minute, second2, fraction = 0, delta = null, tz_hour, tz_minute, date2;
    match = YAML_DATE_REGEXP.exec(data);
    if (match === null)
      match = YAML_TIMESTAMP_REGEXP.exec(data);
    if (match === null)
      throw new Error("Date resolve error");
    year = +match[1];
    month = +match[2] - 1;
    day = +match[3];
    if (!match[4]) {
      return new Date(Date.UTC(year, month, day));
    }
    hour = +match[4];
    minute = +match[5];
    second2 = +match[6];
    if (match[7]) {
      fraction = match[7].slice(0, 3);
      while (fraction.length < 3) {
        fraction += "0";
      }
      fraction = +fraction;
    }
    if (match[9]) {
      tz_hour = +match[10];
      tz_minute = +(match[11] || 0);
      delta = (tz_hour * 60 + tz_minute) * 6e4;
      if (match[9] === "-")
        delta = -delta;
    }
    date2 = new Date(Date.UTC(year, month, day, hour, minute, second2, fraction));
    if (delta)
      date2.setTime(date2.getTime() - delta);
    return date2;
  }
  function representYamlTimestamp(object2) {
    return object2.toISOString();
  }
  var timestamp = new type("tag:yaml.org,2002:timestamp", {
    kind: "scalar",
    resolve: resolveYamlTimestamp,
    construct: constructYamlTimestamp,
    instanceOf: Date,
    represent: representYamlTimestamp
  });
  function resolveYamlMerge(data) {
    return data === "<<" || data === null;
  }
  var merge$1 = new type("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
  });
  var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
  function resolveYamlBinary(data) {
    if (data === null)
      return false;
    var code, idx, bitlen = 0, max2 = data.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      code = map2.indexOf(data.charAt(idx));
      if (code > 64)
        continue;
      if (code < 0)
        return false;
      bitlen += 6;
    }
    return bitlen % 8 === 0;
  }
  function constructYamlBinary(data) {
    var idx, tailbits, input = data.replace(/[\r\n=]/g, ""), max2 = input.length, map2 = BASE64_MAP, bits = 0, result = [];
    for (idx = 0; idx < max2; idx++) {
      if (idx % 4 === 0 && idx) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
      }
      bits = bits << 6 | map2.indexOf(input.charAt(idx));
    }
    tailbits = max2 % 4 * 6;
    if (tailbits === 0) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    } else if (tailbits === 18) {
      result.push(bits >> 10 & 255);
      result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
      result.push(bits >> 4 & 255);
    }
    return new Uint8Array(result);
  }
  function representYamlBinary(object2) {
    var result = "", bits = 0, idx, tail, max2 = object2.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      if (idx % 3 === 0 && idx) {
        result += map2[bits >> 18 & 63];
        result += map2[bits >> 12 & 63];
        result += map2[bits >> 6 & 63];
        result += map2[bits & 63];
      }
      bits = (bits << 8) + object2[idx];
    }
    tail = max2 % 3;
    if (tail === 0) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    } else if (tail === 2) {
      result += map2[bits >> 10 & 63];
      result += map2[bits >> 4 & 63];
      result += map2[bits << 2 & 63];
      result += map2[64];
    } else if (tail === 1) {
      result += map2[bits >> 2 & 63];
      result += map2[bits << 4 & 63];
      result += map2[64];
      result += map2[64];
    }
    return result;
  }
  function isBinary(obj) {
    return Object.prototype.toString.call(obj) === "[object Uint8Array]";
  }
  var binary = new type("tag:yaml.org,2002:binary", {
    kind: "scalar",
    resolve: resolveYamlBinary,
    construct: constructYamlBinary,
    predicate: isBinary,
    represent: representYamlBinary
  });
  var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
  var _toString$2 = Object.prototype.toString;
  function resolveYamlOmap(data) {
    if (data === null)
      return true;
    var objectKeys = [], index2, length2, pair, pairKey, pairHasKey, object2 = data;
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      pairHasKey = false;
      if (_toString$2.call(pair) !== "[object Object]")
        return false;
      for (pairKey in pair) {
        if (_hasOwnProperty$3.call(pair, pairKey)) {
          if (!pairHasKey)
            pairHasKey = true;
          else
            return false;
        }
      }
      if (!pairHasKey)
        return false;
      if (objectKeys.indexOf(pairKey) === -1)
        objectKeys.push(pairKey);
      else
        return false;
    }
    return true;
  }
  function constructYamlOmap(data) {
    return data !== null ? data : [];
  }
  var omap = new type("tag:yaml.org,2002:omap", {
    kind: "sequence",
    resolve: resolveYamlOmap,
    construct: constructYamlOmap
  });
  var _toString$1 = Object.prototype.toString;
  function resolveYamlPairs(data) {
    if (data === null)
      return true;
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      if (_toString$1.call(pair) !== "[object Object]")
        return false;
      keys2 = Object.keys(pair);
      if (keys2.length !== 1)
        return false;
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return true;
  }
  function constructYamlPairs(data) {
    if (data === null)
      return [];
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      keys2 = Object.keys(pair);
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return result;
  }
  var pairs = new type("tag:yaml.org,2002:pairs", {
    kind: "sequence",
    resolve: resolveYamlPairs,
    construct: constructYamlPairs
  });
  var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  function resolveYamlSet(data) {
    if (data === null)
      return true;
    var key, object2 = data;
    for (key in object2) {
      if (_hasOwnProperty$2.call(object2, key)) {
        if (object2[key] !== null)
          return false;
      }
    }
    return true;
  }
  function constructYamlSet(data) {
    return data !== null ? data : {};
  }
  var set$1 = new type("tag:yaml.org,2002:set", {
    kind: "mapping",
    resolve: resolveYamlSet,
    construct: constructYamlSet
  });
  var _default = core.extend({
    implicit: [
      timestamp,
      merge$1
    ],
    explicit: [
      binary,
      omap,
      pairs,
      set$1
    ]
  });
  var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  var CONTEXT_FLOW_IN = 1;
  var CONTEXT_FLOW_OUT = 2;
  var CONTEXT_BLOCK_IN = 3;
  var CONTEXT_BLOCK_OUT = 4;
  var CHOMPING_CLIP = 1;
  var CHOMPING_STRIP = 2;
  var CHOMPING_KEEP = 3;
  var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
  var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
  var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
  var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
  var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
  function _class(obj) {
    return Object.prototype.toString.call(obj);
  }
  function is_EOL(c2) {
    return c2 === 10 || c2 === 13;
  }
  function is_WHITE_SPACE(c2) {
    return c2 === 9 || c2 === 32;
  }
  function is_WS_OR_EOL(c2) {
    return c2 === 9 || c2 === 32 || c2 === 10 || c2 === 13;
  }
  function is_FLOW_INDICATOR(c2) {
    return c2 === 44 || c2 === 91 || c2 === 93 || c2 === 123 || c2 === 125;
  }
  function fromHexCode(c2) {
    var lc;
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    lc = c2 | 32;
    if (97 <= lc && lc <= 102) {
      return lc - 97 + 10;
    }
    return -1;
  }
  function escapedHexLen(c2) {
    if (c2 === 120) {
      return 2;
    }
    if (c2 === 117) {
      return 4;
    }
    if (c2 === 85) {
      return 8;
    }
    return 0;
  }
  function fromDecimalCode(c2) {
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    return -1;
  }
  function simpleEscapeSequence(c2) {
    return c2 === 48 ? "\0" : c2 === 97 ? "\x07" : c2 === 98 ? "\b" : c2 === 116 ? "	" : c2 === 9 ? "	" : c2 === 110 ? "\n" : c2 === 118 ? "\v" : c2 === 102 ? "\f" : c2 === 114 ? "\r" : c2 === 101 ? "\x1B" : c2 === 32 ? " " : c2 === 34 ? '"' : c2 === 47 ? "/" : c2 === 92 ? "\\" : c2 === 78 ? "" : c2 === 95 ? " " : c2 === 76 ? "\u2028" : c2 === 80 ? "\u2029" : "";
  }
  function charFromCodepoint(c2) {
    if (c2 <= 65535) {
      return String.fromCharCode(c2);
    }
    return String.fromCharCode(
      (c2 - 65536 >> 10) + 55296,
      (c2 - 65536 & 1023) + 56320
    );
  }
  var simpleEscapeCheck = new Array(256);
  var simpleEscapeMap = new Array(256);
  for (var i$1 = 0; i$1 < 256; i$1++) {
    simpleEscapeCheck[i$1] = simpleEscapeSequence(i$1) ? 1 : 0;
    simpleEscapeMap[i$1] = simpleEscapeSequence(i$1);
  }
  function State$1(input, options2) {
    this.input = input;
    this.filename = options2["filename"] || null;
    this.schema = options2["schema"] || _default;
    this.onWarning = options2["onWarning"] || null;
    this.legacy = options2["legacy"] || false;
    this.json = options2["json"] || false;
    this.listener = options2["listener"] || null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.typeMap = this.schema.compiledTypeMap;
    this.length = input.length;
    this.position = 0;
    this.line = 0;
    this.lineStart = 0;
    this.lineIndent = 0;
    this.firstTabInLine = -1;
    this.documents = [];
  }
  function generateError(state2, message) {
    var mark = {
      name: state2.filename,
      buffer: state2.input.slice(0, -1),
      // omit trailing \0
      position: state2.position,
      line: state2.line,
      column: state2.position - state2.lineStart
    };
    mark.snippet = snippet(mark);
    return new exception(message, mark);
  }
  function throwError(state2, message) {
    throw generateError(state2, message);
  }
  function throwWarning(state2, message) {
    if (state2.onWarning) {
      state2.onWarning.call(null, generateError(state2, message));
    }
  }
  var directiveHandlers = {
    YAML: function handleYamlDirective(state2, name, args) {
      var match, major, minor;
      if (state2.version !== null) {
        throwError(state2, "duplication of %YAML directive");
      }
      if (args.length !== 1) {
        throwError(state2, "YAML directive accepts exactly one argument");
      }
      match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
      if (match === null) {
        throwError(state2, "ill-formed argument of the YAML directive");
      }
      major = parseInt(match[1], 10);
      minor = parseInt(match[2], 10);
      if (major !== 1) {
        throwError(state2, "unacceptable YAML version of the document");
      }
      state2.version = args[0];
      state2.checkLineBreaks = minor < 2;
      if (minor !== 1 && minor !== 2) {
        throwWarning(state2, "unsupported YAML version of the document");
      }
    },
    TAG: function handleTagDirective(state2, name, args) {
      var handle, prefix;
      if (args.length !== 2) {
        throwError(state2, "TAG directive accepts exactly two arguments");
      }
      handle = args[0];
      prefix = args[1];
      if (!PATTERN_TAG_HANDLE.test(handle)) {
        throwError(state2, "ill-formed tag handle (first argument) of the TAG directive");
      }
      if (_hasOwnProperty$1.call(state2.tagMap, handle)) {
        throwError(state2, 'there is a previously declared suffix for "' + handle + '" tag handle');
      }
      if (!PATTERN_TAG_URI.test(prefix)) {
        throwError(state2, "ill-formed tag prefix (second argument) of the TAG directive");
      }
      try {
        prefix = decodeURIComponent(prefix);
      } catch (err) {
        throwError(state2, "tag prefix is malformed: " + prefix);
      }
      state2.tagMap[handle] = prefix;
    }
  };
  function captureSegment(state2, start2, end2, checkJson) {
    var _position, _length, _character, _result;
    if (start2 < end2) {
      _result = state2.input.slice(start2, end2);
      if (checkJson) {
        for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
          _character = _result.charCodeAt(_position);
          if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
            throwError(state2, "expected valid JSON character");
          }
        }
      } else if (PATTERN_NON_PRINTABLE.test(_result)) {
        throwError(state2, "the stream contains non-printable characters");
      }
      state2.result += _result;
    }
  }
  function mergeMappings(state2, destination, source, overridableKeys) {
    var sourceKeys, key, index2, quantity;
    if (!common.isObject(source)) {
      throwError(state2, "cannot merge mappings; the provided source object is unacceptable");
    }
    sourceKeys = Object.keys(source);
    for (index2 = 0, quantity = sourceKeys.length; index2 < quantity; index2 += 1) {
      key = sourceKeys[index2];
      if (!_hasOwnProperty$1.call(destination, key)) {
        destination[key] = source[key];
        overridableKeys[key] = true;
      }
    }
  }
  function storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
    var index2, quantity;
    if (Array.isArray(keyNode)) {
      keyNode = Array.prototype.slice.call(keyNode);
      for (index2 = 0, quantity = keyNode.length; index2 < quantity; index2 += 1) {
        if (Array.isArray(keyNode[index2])) {
          throwError(state2, "nested arrays are not supported inside keys");
        }
        if (typeof keyNode === "object" && _class(keyNode[index2]) === "[object Object]") {
          keyNode[index2] = "[object Object]";
        }
      }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
      keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (_result === null) {
      _result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
      if (Array.isArray(valueNode)) {
        for (index2 = 0, quantity = valueNode.length; index2 < quantity; index2 += 1) {
          mergeMappings(state2, _result, valueNode[index2], overridableKeys);
        }
      } else {
        mergeMappings(state2, _result, valueNode, overridableKeys);
      }
    } else {
      if (!state2.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
        state2.line = startLine || state2.line;
        state2.lineStart = startLineStart || state2.lineStart;
        state2.position = startPos || state2.position;
        throwError(state2, "duplicated mapping key");
      }
      if (keyNode === "__proto__") {
        Object.defineProperty(_result, keyNode, {
          configurable: true,
          enumerable: true,
          writable: true,
          value: valueNode
        });
      } else {
        _result[keyNode] = valueNode;
      }
      delete overridableKeys[keyNode];
    }
    return _result;
  }
  function readLineBreak(state2) {
    var ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 === 10) {
      state2.position++;
    } else if (ch2 === 13) {
      state2.position++;
      if (state2.input.charCodeAt(state2.position) === 10) {
        state2.position++;
      }
    } else {
      throwError(state2, "a line break is expected");
    }
    state2.line += 1;
    state2.lineStart = state2.position;
    state2.firstTabInLine = -1;
  }
  function skipSeparationSpace(state2, allowComments, checkIndent) {
    var lineBreaks = 0, ch2 = state2.input.charCodeAt(state2.position);
    while (ch2 !== 0) {
      while (is_WHITE_SPACE(ch2)) {
        if (ch2 === 9 && state2.firstTabInLine === -1) {
          state2.firstTabInLine = state2.position;
        }
        ch2 = state2.input.charCodeAt(++state2.position);
      }
      if (allowComments && ch2 === 35) {
        do {
          ch2 = state2.input.charCodeAt(++state2.position);
        } while (ch2 !== 10 && ch2 !== 13 && ch2 !== 0);
      }
      if (is_EOL(ch2)) {
        readLineBreak(state2);
        ch2 = state2.input.charCodeAt(state2.position);
        lineBreaks++;
        state2.lineIndent = 0;
        while (ch2 === 32) {
          state2.lineIndent++;
          ch2 = state2.input.charCodeAt(++state2.position);
        }
      } else {
        break;
      }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state2.lineIndent < checkIndent) {
      throwWarning(state2, "deficient indentation");
    }
    return lineBreaks;
  }
  function testDocumentSeparator(state2) {
    var _position = state2.position, ch2;
    ch2 = state2.input.charCodeAt(_position);
    if ((ch2 === 45 || ch2 === 46) && ch2 === state2.input.charCodeAt(_position + 1) && ch2 === state2.input.charCodeAt(_position + 2)) {
      _position += 3;
      ch2 = state2.input.charCodeAt(_position);
      if (ch2 === 0 || is_WS_OR_EOL(ch2)) {
        return true;
      }
    }
    return false;
  }
  function writeFoldedLines(state2, count) {
    if (count === 1) {
      state2.result += " ";
    } else if (count > 1) {
      state2.result += common.repeat("\n", count - 1);
    }
  }
  function readPlainScalar(state2, nodeIndent, withinFlowCollection) {
    var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state2.kind, _result = state2.result, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (is_WS_OR_EOL(ch2) || is_FLOW_INDICATOR(ch2) || ch2 === 35 || ch2 === 38 || ch2 === 42 || ch2 === 33 || ch2 === 124 || ch2 === 62 || ch2 === 39 || ch2 === 34 || ch2 === 37 || ch2 === 64 || ch2 === 96) {
      return false;
    }
    if (ch2 === 63 || ch2 === 45) {
      following = state2.input.charCodeAt(state2.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        return false;
      }
    }
    state2.kind = "scalar";
    state2.result = "";
    captureStart = captureEnd = state2.position;
    hasPendingContent = false;
    while (ch2 !== 0) {
      if (ch2 === 58) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
          break;
        }
      } else if (ch2 === 35) {
        preceding = state2.input.charCodeAt(state2.position - 1);
        if (is_WS_OR_EOL(preceding)) {
          break;
        }
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2) || withinFlowCollection && is_FLOW_INDICATOR(ch2)) {
        break;
      } else if (is_EOL(ch2)) {
        _line = state2.line;
        _lineStart = state2.lineStart;
        _lineIndent = state2.lineIndent;
        skipSeparationSpace(state2, false, -1);
        if (state2.lineIndent >= nodeIndent) {
          hasPendingContent = true;
          ch2 = state2.input.charCodeAt(state2.position);
          continue;
        } else {
          state2.position = captureEnd;
          state2.line = _line;
          state2.lineStart = _lineStart;
          state2.lineIndent = _lineIndent;
          break;
        }
      }
      if (hasPendingContent) {
        captureSegment(state2, captureStart, captureEnd, false);
        writeFoldedLines(state2, state2.line - _line);
        captureStart = captureEnd = state2.position;
        hasPendingContent = false;
      }
      if (!is_WHITE_SPACE(ch2)) {
        captureEnd = state2.position + 1;
      }
      ch2 = state2.input.charCodeAt(++state2.position);
    }
    captureSegment(state2, captureStart, captureEnd, false);
    if (state2.result) {
      return true;
    }
    state2.kind = _kind;
    state2.result = _result;
    return false;
  }
  function readSingleQuotedScalar(state2, nodeIndent) {
    var ch2, captureStart, captureEnd;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 !== 39) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch2 = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch2 === 39) {
        captureSegment(state2, captureStart, state2.position, true);
        ch2 = state2.input.charCodeAt(++state2.position);
        if (ch2 === 39) {
          captureStart = state2.position;
          state2.position++;
          captureEnd = state2.position;
        } else {
          return true;
        }
      } else if (is_EOL(ch2)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a single quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a single quoted scalar");
  }
  function readDoubleQuotedScalar(state2, nodeIndent) {
    var captureStart, captureEnd, hexLength, hexResult, tmp, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 !== 34) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch2 = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch2 === 34) {
        captureSegment(state2, captureStart, state2.position, true);
        state2.position++;
        return true;
      } else if (ch2 === 92) {
        captureSegment(state2, captureStart, state2.position, true);
        ch2 = state2.input.charCodeAt(++state2.position);
        if (is_EOL(ch2)) {
          skipSeparationSpace(state2, false, nodeIndent);
        } else if (ch2 < 256 && simpleEscapeCheck[ch2]) {
          state2.result += simpleEscapeMap[ch2];
          state2.position++;
        } else if ((tmp = escapedHexLen(ch2)) > 0) {
          hexLength = tmp;
          hexResult = 0;
          for (; hexLength > 0; hexLength--) {
            ch2 = state2.input.charCodeAt(++state2.position);
            if ((tmp = fromHexCode(ch2)) >= 0) {
              hexResult = (hexResult << 4) + tmp;
            } else {
              throwError(state2, "expected hexadecimal character");
            }
          }
          state2.result += charFromCodepoint(hexResult);
          state2.position++;
        } else {
          throwError(state2, "unknown escape sequence");
        }
        captureStart = captureEnd = state2.position;
      } else if (is_EOL(ch2)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a double quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a double quoted scalar");
  }
  function readFlowCollection(state2, nodeIndent) {
    var readNext = true, _line, _lineStart, _pos, _tag = state2.tag, _result, _anchor = state2.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 === 91) {
      terminator = 93;
      isMapping = false;
      _result = [];
    } else if (ch2 === 123) {
      terminator = 125;
      isMapping = true;
      _result = {};
    } else {
      return false;
    }
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch2 = state2.input.charCodeAt(++state2.position);
    while (ch2 !== 0) {
      skipSeparationSpace(state2, true, nodeIndent);
      ch2 = state2.input.charCodeAt(state2.position);
      if (ch2 === terminator) {
        state2.position++;
        state2.tag = _tag;
        state2.anchor = _anchor;
        state2.kind = isMapping ? "mapping" : "sequence";
        state2.result = _result;
        return true;
      } else if (!readNext) {
        throwError(state2, "missed comma between flow collection entries");
      } else if (ch2 === 44) {
        throwError(state2, "expected the node content, but found ','");
      }
      keyTag = keyNode = valueNode = null;
      isPair = isExplicitPair = false;
      if (ch2 === 63) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following)) {
          isPair = isExplicitPair = true;
          state2.position++;
          skipSeparationSpace(state2, true, nodeIndent);
        }
      }
      _line = state2.line;
      _lineStart = state2.lineStart;
      _pos = state2.position;
      composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
      keyTag = state2.tag;
      keyNode = state2.result;
      skipSeparationSpace(state2, true, nodeIndent);
      ch2 = state2.input.charCodeAt(state2.position);
      if ((isExplicitPair || state2.line === _line) && ch2 === 58) {
        isPair = true;
        ch2 = state2.input.charCodeAt(++state2.position);
        skipSeparationSpace(state2, true, nodeIndent);
        composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
        valueNode = state2.result;
      }
      if (isMapping) {
        storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
      } else if (isPair) {
        _result.push(storeMappingPair(state2, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
      } else {
        _result.push(keyNode);
      }
      skipSeparationSpace(state2, true, nodeIndent);
      ch2 = state2.input.charCodeAt(state2.position);
      if (ch2 === 44) {
        readNext = true;
        ch2 = state2.input.charCodeAt(++state2.position);
      } else {
        readNext = false;
      }
    }
    throwError(state2, "unexpected end of the stream within a flow collection");
  }
  function readBlockScalar(state2, nodeIndent) {
    var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 === 124) {
      folding = false;
    } else if (ch2 === 62) {
      folding = true;
    } else {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    while (ch2 !== 0) {
      ch2 = state2.input.charCodeAt(++state2.position);
      if (ch2 === 43 || ch2 === 45) {
        if (CHOMPING_CLIP === chomping) {
          chomping = ch2 === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
        } else {
          throwError(state2, "repeat of a chomping mode identifier");
        }
      } else if ((tmp = fromDecimalCode(ch2)) >= 0) {
        if (tmp === 0) {
          throwError(state2, "bad explicit indentation width of a block scalar; it cannot be less than one");
        } else if (!detectedIndent) {
          textIndent = nodeIndent + tmp - 1;
          detectedIndent = true;
        } else {
          throwError(state2, "repeat of an indentation width identifier");
        }
      } else {
        break;
      }
    }
    if (is_WHITE_SPACE(ch2)) {
      do {
        ch2 = state2.input.charCodeAt(++state2.position);
      } while (is_WHITE_SPACE(ch2));
      if (ch2 === 35) {
        do {
          ch2 = state2.input.charCodeAt(++state2.position);
        } while (!is_EOL(ch2) && ch2 !== 0);
      }
    }
    while (ch2 !== 0) {
      readLineBreak(state2);
      state2.lineIndent = 0;
      ch2 = state2.input.charCodeAt(state2.position);
      while ((!detectedIndent || state2.lineIndent < textIndent) && ch2 === 32) {
        state2.lineIndent++;
        ch2 = state2.input.charCodeAt(++state2.position);
      }
      if (!detectedIndent && state2.lineIndent > textIndent) {
        textIndent = state2.lineIndent;
      }
      if (is_EOL(ch2)) {
        emptyLines++;
        continue;
      }
      if (state2.lineIndent < textIndent) {
        if (chomping === CHOMPING_KEEP) {
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (chomping === CHOMPING_CLIP) {
          if (didReadContent) {
            state2.result += "\n";
          }
        }
        break;
      }
      if (folding) {
        if (is_WHITE_SPACE(ch2)) {
          atMoreIndented = true;
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (atMoreIndented) {
          atMoreIndented = false;
          state2.result += common.repeat("\n", emptyLines + 1);
        } else if (emptyLines === 0) {
          if (didReadContent) {
            state2.result += " ";
          }
        } else {
          state2.result += common.repeat("\n", emptyLines);
        }
      } else {
        state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      }
      didReadContent = true;
      detectedIndent = true;
      emptyLines = 0;
      captureStart = state2.position;
      while (!is_EOL(ch2) && ch2 !== 0) {
        ch2 = state2.input.charCodeAt(++state2.position);
      }
      captureSegment(state2, captureStart, state2.position, false);
    }
    return true;
  }
  function readBlockSequence(state2, nodeIndent) {
    var _line, _tag = state2.tag, _anchor = state2.anchor, _result = [], following, detected = false, ch2;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch2 = state2.input.charCodeAt(state2.position);
    while (ch2 !== 0) {
      if (state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      if (ch2 !== 45) {
        break;
      }
      following = state2.input.charCodeAt(state2.position + 1);
      if (!is_WS_OR_EOL(following)) {
        break;
      }
      detected = true;
      state2.position++;
      if (skipSeparationSpace(state2, true, -1)) {
        if (state2.lineIndent <= nodeIndent) {
          _result.push(null);
          ch2 = state2.input.charCodeAt(state2.position);
          continue;
        }
      }
      _line = state2.line;
      composeNode(state2, nodeIndent, CONTEXT_BLOCK_IN, false, true);
      _result.push(state2.result);
      skipSeparationSpace(state2, true, -1);
      ch2 = state2.input.charCodeAt(state2.position);
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch2 !== 0) {
        throwError(state2, "bad indentation of a sequence entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "sequence";
      state2.result = _result;
      return true;
    }
    return false;
  }
  function readBlockMapping(state2, nodeIndent, flowIndent) {
    var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state2.tag, _anchor = state2.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch2;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch2 = state2.input.charCodeAt(state2.position);
    while (ch2 !== 0) {
      if (!atExplicitKey && state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      following = state2.input.charCodeAt(state2.position + 1);
      _line = state2.line;
      if ((ch2 === 63 || ch2 === 58) && is_WS_OR_EOL(following)) {
        if (ch2 === 63) {
          if (atExplicitKey) {
            storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = true;
          allowCompact = true;
        } else if (atExplicitKey) {
          atExplicitKey = false;
          allowCompact = true;
        } else {
          throwError(state2, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
        }
        state2.position += 1;
        ch2 = following;
      } else {
        _keyLine = state2.line;
        _keyLineStart = state2.lineStart;
        _keyPos = state2.position;
        if (!composeNode(state2, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
          break;
        }
        if (state2.line === _line) {
          ch2 = state2.input.charCodeAt(state2.position);
          while (is_WHITE_SPACE(ch2)) {
            ch2 = state2.input.charCodeAt(++state2.position);
          }
          if (ch2 === 58) {
            ch2 = state2.input.charCodeAt(++state2.position);
            if (!is_WS_OR_EOL(ch2)) {
              throwError(state2, "a whitespace character is expected after the key-value separator within a block mapping");
            }
            if (atExplicitKey) {
              storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
              keyTag = keyNode = valueNode = null;
            }
            detected = true;
            atExplicitKey = false;
            allowCompact = false;
            keyTag = state2.tag;
            keyNode = state2.result;
          } else if (detected) {
            throwError(state2, "can not read an implicit mapping pair; a colon is missed");
          } else {
            state2.tag = _tag;
            state2.anchor = _anchor;
            return true;
          }
        } else if (detected) {
          throwError(state2, "can not read a block mapping entry; a multiline key may not be an implicit key");
        } else {
          state2.tag = _tag;
          state2.anchor = _anchor;
          return true;
        }
      }
      if (state2.line === _line || state2.lineIndent > nodeIndent) {
        if (atExplicitKey) {
          _keyLine = state2.line;
          _keyLineStart = state2.lineStart;
          _keyPos = state2.position;
        }
        if (composeNode(state2, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
          if (atExplicitKey) {
            keyNode = state2.result;
          } else {
            valueNode = state2.result;
          }
        }
        if (!atExplicitKey) {
          storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        skipSeparationSpace(state2, true, -1);
        ch2 = state2.input.charCodeAt(state2.position);
      }
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch2 !== 0) {
        throwError(state2, "bad indentation of a mapping entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (atExplicitKey) {
      storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "mapping";
      state2.result = _result;
    }
    return detected;
  }
  function readTagProperty(state2) {
    var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 !== 33)
      return false;
    if (state2.tag !== null) {
      throwError(state2, "duplication of a tag property");
    }
    ch2 = state2.input.charCodeAt(++state2.position);
    if (ch2 === 60) {
      isVerbatim = true;
      ch2 = state2.input.charCodeAt(++state2.position);
    } else if (ch2 === 33) {
      isNamed = true;
      tagHandle = "!!";
      ch2 = state2.input.charCodeAt(++state2.position);
    } else {
      tagHandle = "!";
    }
    _position = state2.position;
    if (isVerbatim) {
      do {
        ch2 = state2.input.charCodeAt(++state2.position);
      } while (ch2 !== 0 && ch2 !== 62);
      if (state2.position < state2.length) {
        tagName = state2.input.slice(_position, state2.position);
        ch2 = state2.input.charCodeAt(++state2.position);
      } else {
        throwError(state2, "unexpected end of the stream within a verbatim tag");
      }
    } else {
      while (ch2 !== 0 && !is_WS_OR_EOL(ch2)) {
        if (ch2 === 33) {
          if (!isNamed) {
            tagHandle = state2.input.slice(_position - 1, state2.position + 1);
            if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
              throwError(state2, "named tag handle cannot contain such characters");
            }
            isNamed = true;
            _position = state2.position + 1;
          } else {
            throwError(state2, "tag suffix cannot contain exclamation marks");
          }
        }
        ch2 = state2.input.charCodeAt(++state2.position);
      }
      tagName = state2.input.slice(_position, state2.position);
      if (PATTERN_FLOW_INDICATORS.test(tagName)) {
        throwError(state2, "tag suffix cannot contain flow indicator characters");
      }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
      throwError(state2, "tag name cannot contain such characters: " + tagName);
    }
    try {
      tagName = decodeURIComponent(tagName);
    } catch (err) {
      throwError(state2, "tag name is malformed: " + tagName);
    }
    if (isVerbatim) {
      state2.tag = tagName;
    } else if (_hasOwnProperty$1.call(state2.tagMap, tagHandle)) {
      state2.tag = state2.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
      state2.tag = "!" + tagName;
    } else if (tagHandle === "!!") {
      state2.tag = "tag:yaml.org,2002:" + tagName;
    } else {
      throwError(state2, 'undeclared tag handle "' + tagHandle + '"');
    }
    return true;
  }
  function readAnchorProperty(state2) {
    var _position, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 !== 38)
      return false;
    if (state2.anchor !== null) {
      throwError(state2, "duplication of an anchor property");
    }
    ch2 = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch2 !== 0 && !is_WS_OR_EOL(ch2) && !is_FLOW_INDICATOR(ch2)) {
      ch2 = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an anchor node must contain at least one character");
    }
    state2.anchor = state2.input.slice(_position, state2.position);
    return true;
  }
  function readAlias(state2) {
    var _position, alias, ch2;
    ch2 = state2.input.charCodeAt(state2.position);
    if (ch2 !== 42)
      return false;
    ch2 = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch2 !== 0 && !is_WS_OR_EOL(ch2) && !is_FLOW_INDICATOR(ch2)) {
      ch2 = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an alias node must contain at least one character");
    }
    alias = state2.input.slice(_position, state2.position);
    if (!_hasOwnProperty$1.call(state2.anchorMap, alias)) {
      throwError(state2, 'unidentified alias "' + alias + '"');
    }
    state2.result = state2.anchorMap[alias];
    skipSeparationSpace(state2, true, -1);
    return true;
  }
  function composeNode(state2, parentIndent, nodeContext, allowToSeek, allowCompact) {
    var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
    if (state2.listener !== null) {
      state2.listener("open", state2);
    }
    state2.tag = null;
    state2.anchor = null;
    state2.kind = null;
    state2.result = null;
    allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
      if (skipSeparationSpace(state2, true, -1)) {
        atNewLine = true;
        if (state2.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state2.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state2.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      }
    }
    if (indentStatus === 1) {
      while (readTagProperty(state2) || readAnchorProperty(state2)) {
        if (skipSeparationSpace(state2, true, -1)) {
          atNewLine = true;
          allowBlockCollections = allowBlockStyles;
          if (state2.lineIndent > parentIndent) {
            indentStatus = 1;
          } else if (state2.lineIndent === parentIndent) {
            indentStatus = 0;
          } else if (state2.lineIndent < parentIndent) {
            indentStatus = -1;
          }
        } else {
          allowBlockCollections = false;
        }
      }
    }
    if (allowBlockCollections) {
      allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
      if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
        flowIndent = parentIndent;
      } else {
        flowIndent = parentIndent + 1;
      }
      blockIndent = state2.position - state2.lineStart;
      if (indentStatus === 1) {
        if (allowBlockCollections && (readBlockSequence(state2, blockIndent) || readBlockMapping(state2, blockIndent, flowIndent)) || readFlowCollection(state2, flowIndent)) {
          hasContent = true;
        } else {
          if (allowBlockScalars && readBlockScalar(state2, flowIndent) || readSingleQuotedScalar(state2, flowIndent) || readDoubleQuotedScalar(state2, flowIndent)) {
            hasContent = true;
          } else if (readAlias(state2)) {
            hasContent = true;
            if (state2.tag !== null || state2.anchor !== null) {
              throwError(state2, "alias node should not have any properties");
            }
          } else if (readPlainScalar(state2, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
            hasContent = true;
            if (state2.tag === null) {
              state2.tag = "?";
            }
          }
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
        }
      } else if (indentStatus === 0) {
        hasContent = allowBlockCollections && readBlockSequence(state2, blockIndent);
      }
    }
    if (state2.tag === null) {
      if (state2.anchor !== null) {
        state2.anchorMap[state2.anchor] = state2.result;
      }
    } else if (state2.tag === "?") {
      if (state2.result !== null && state2.kind !== "scalar") {
        throwError(state2, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state2.kind + '"');
      }
      for (typeIndex = 0, typeQuantity = state2.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
        type2 = state2.implicitTypes[typeIndex];
        if (type2.resolve(state2.result)) {
          state2.result = type2.construct(state2.result);
          state2.tag = type2.tag;
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
          break;
        }
      }
    } else if (state2.tag !== "!") {
      if (_hasOwnProperty$1.call(state2.typeMap[state2.kind || "fallback"], state2.tag)) {
        type2 = state2.typeMap[state2.kind || "fallback"][state2.tag];
      } else {
        type2 = null;
        typeList = state2.typeMap.multi[state2.kind || "fallback"];
        for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
          if (state2.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
            type2 = typeList[typeIndex];
            break;
          }
        }
      }
      if (!type2) {
        throwError(state2, "unknown tag !<" + state2.tag + ">");
      }
      if (state2.result !== null && type2.kind !== state2.kind) {
        throwError(state2, "unacceptable node kind for !<" + state2.tag + '> tag; it should be "' + type2.kind + '", not "' + state2.kind + '"');
      }
      if (!type2.resolve(state2.result, state2.tag)) {
        throwError(state2, "cannot resolve a node with !<" + state2.tag + "> explicit tag");
      } else {
        state2.result = type2.construct(state2.result, state2.tag);
        if (state2.anchor !== null) {
          state2.anchorMap[state2.anchor] = state2.result;
        }
      }
    }
    if (state2.listener !== null) {
      state2.listener("close", state2);
    }
    return state2.tag !== null || state2.anchor !== null || hasContent;
  }
  function readDocument(state2) {
    var documentStart = state2.position, _position, directiveName, directiveArgs, hasDirectives = false, ch2;
    state2.version = null;
    state2.checkLineBreaks = state2.legacy;
    state2.tagMap = /* @__PURE__ */ Object.create(null);
    state2.anchorMap = /* @__PURE__ */ Object.create(null);
    while ((ch2 = state2.input.charCodeAt(state2.position)) !== 0) {
      skipSeparationSpace(state2, true, -1);
      ch2 = state2.input.charCodeAt(state2.position);
      if (state2.lineIndent > 0 || ch2 !== 37) {
        break;
      }
      hasDirectives = true;
      ch2 = state2.input.charCodeAt(++state2.position);
      _position = state2.position;
      while (ch2 !== 0 && !is_WS_OR_EOL(ch2)) {
        ch2 = state2.input.charCodeAt(++state2.position);
      }
      directiveName = state2.input.slice(_position, state2.position);
      directiveArgs = [];
      if (directiveName.length < 1) {
        throwError(state2, "directive name must not be less than one character in length");
      }
      while (ch2 !== 0) {
        while (is_WHITE_SPACE(ch2)) {
          ch2 = state2.input.charCodeAt(++state2.position);
        }
        if (ch2 === 35) {
          do {
            ch2 = state2.input.charCodeAt(++state2.position);
          } while (ch2 !== 0 && !is_EOL(ch2));
          break;
        }
        if (is_EOL(ch2))
          break;
        _position = state2.position;
        while (ch2 !== 0 && !is_WS_OR_EOL(ch2)) {
          ch2 = state2.input.charCodeAt(++state2.position);
        }
        directiveArgs.push(state2.input.slice(_position, state2.position));
      }
      if (ch2 !== 0)
        readLineBreak(state2);
      if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
        directiveHandlers[directiveName](state2, directiveName, directiveArgs);
      } else {
        throwWarning(state2, 'unknown document directive "' + directiveName + '"');
      }
    }
    skipSeparationSpace(state2, true, -1);
    if (state2.lineIndent === 0 && state2.input.charCodeAt(state2.position) === 45 && state2.input.charCodeAt(state2.position + 1) === 45 && state2.input.charCodeAt(state2.position + 2) === 45) {
      state2.position += 3;
      skipSeparationSpace(state2, true, -1);
    } else if (hasDirectives) {
      throwError(state2, "directives end mark is expected");
    }
    composeNode(state2, state2.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
    skipSeparationSpace(state2, true, -1);
    if (state2.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state2.input.slice(documentStart, state2.position))) {
      throwWarning(state2, "non-ASCII line breaks are interpreted as content");
    }
    state2.documents.push(state2.result);
    if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
      if (state2.input.charCodeAt(state2.position) === 46) {
        state2.position += 3;
        skipSeparationSpace(state2, true, -1);
      }
      return;
    }
    if (state2.position < state2.length - 1) {
      throwError(state2, "end of the stream or a document separator is expected");
    } else {
      return;
    }
  }
  function loadDocuments(input, options2) {
    input = String(input);
    options2 = options2 || {};
    if (input.length !== 0) {
      if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
        input += "\n";
      }
      if (input.charCodeAt(0) === 65279) {
        input = input.slice(1);
      }
    }
    var state2 = new State$1(input, options2);
    var nullpos = input.indexOf("\0");
    if (nullpos !== -1) {
      state2.position = nullpos;
      throwError(state2, "null byte is not allowed in input");
    }
    state2.input += "\0";
    while (state2.input.charCodeAt(state2.position) === 32) {
      state2.lineIndent += 1;
      state2.position += 1;
    }
    while (state2.position < state2.length - 1) {
      readDocument(state2);
    }
    return state2.documents;
  }
  function loadAll$1(input, iterator, options2) {
    if (iterator !== null && typeof iterator === "object" && typeof options2 === "undefined") {
      options2 = iterator;
      iterator = null;
    }
    var documents2 = loadDocuments(input, options2);
    if (typeof iterator !== "function") {
      return documents2;
    }
    for (var index2 = 0, length2 = documents2.length; index2 < length2; index2 += 1) {
      iterator(documents2[index2]);
    }
  }
  function load$1(input, options2) {
    var documents2 = loadDocuments(input, options2);
    if (documents2.length === 0) {
      return void 0;
    } else if (documents2.length === 1) {
      return documents2[0];
    }
    throw new exception("expected a single document in the stream, but found more");
  }
  var loadAll_1 = loadAll$1;
  var load_1 = load$1;
  var loader = {
    loadAll: loadAll_1,
    load: load_1
  };
  var JSON_SCHEMA = json;
  var load = loader.load;
  function extractFrontMatter(text2) {
    const matches = text2.match(frontMatterRegex);
    if (!matches) {
      return {
        text: text2,
        metadata: {}
      };
    }
    let parsed = load(matches[1], {
      // To support config, we need JSON schema.
      // https://www.yaml.org/spec/1.2/spec.html#id2803231
      schema: JSON_SCHEMA
    }) ?? {};
    parsed = typeof parsed === "object" && !Array.isArray(parsed) ? parsed : {};
    const metadata = {};
    if (parsed.displayMode) {
      metadata.displayMode = parsed.displayMode.toString();
    }
    if (parsed.title) {
      metadata.title = parsed.title.toString();
    }
    if (parsed.config) {
      metadata.config = parsed.config;
    }
    return {
      text: text2.slice(matches[0].length),
      metadata
    };
  }
  const cleanupText = (code) => {
    return code.replace(/\r\n?/g, "\n").replace(
      /<(\w+)([^>]*)>/g,
      (match, tag, attributes) => "<" + tag + attributes.replace(/="([^"]*)"/g, "='$1'") + ">"
    );
  };
  const processFrontmatter = (code) => {
    const { text: text2, metadata } = extractFrontMatter(code);
    const { displayMode: displayMode2, title: title2, config: config2 = {} } = metadata;
    if (displayMode2) {
      if (!config2.gantt) {
        config2.gantt = {};
      }
      config2.gantt.displayMode = displayMode2;
    }
    return { title: title2, config: config2, text: text2 };
  };
  const processDirectives = (code) => {
    const initDirective = utils$1.detectInit(code) ?? {};
    const wrapDirectives = utils$1.detectDirective(code, "wrap");
    if (Array.isArray(wrapDirectives)) {
      initDirective.wrap = wrapDirectives.some(({ type: type2 }) => {
      });
    } else if ((wrapDirectives == null ? void 0 : wrapDirectives.type) === "wrap") {
      initDirective.wrap = true;
    }
    return {
      text: removeDirectives(code),
      directive: initDirective
    };
  };
  function preprocessDiagram(code) {
    const cleanedCode = cleanupText(code);
    const frontMatterResult = processFrontmatter(cleanedCode);
    const directiveResult = processDirectives(frontMatterResult.text);
    const config2 = cleanAndMerge(frontMatterResult.config, directiveResult.directive);
    code = cleanupComments(directiveResult.text);
    return {
      code,
      title: frontMatterResult.title,
      config: config2
    };
  }
  const MAX_TEXTLENGTH = 5e4;
  const MAX_TEXTLENGTH_EXCEEDED_MSG = "graph TB;a[Maximum text size in diagram exceeded];style a fill:#faa";
  const SECURITY_LVL_SANDBOX = "sandbox";
  const SECURITY_LVL_LOOSE = "loose";
  const XMLNS_SVG_STD = "http://www.w3.org/2000/svg";
  const XMLNS_XLINK_STD = "http://www.w3.org/1999/xlink";
  const XMLNS_XHTML_STD = "http://www.w3.org/1999/xhtml";
  const IFRAME_WIDTH = "100%";
  const IFRAME_HEIGHT = "100%";
  const IFRAME_STYLES = "border:0;margin:0;";
  const IFRAME_BODY_STYLE = "margin:0";
  const IFRAME_SANDBOX_OPTS = "allow-top-navigation-by-user-activation allow-popups";
  const IFRAME_NOT_SUPPORTED_MSG = 'The "iframe" tag is not supported by your browser.';
  const DOMPURIFY_TAGS = ["foreignobject"];
  const DOMPURIFY_ATTR = ["dominant-baseline"];
  function processAndSetConfigs(text2) {
    const processed2 = preprocessDiagram(text2);
    reset();
    addDirective(processed2.config ?? {});
    return processed2;
  }
  async function parse$3(text2, parseOptions) {
    addDiagrams();
    text2 = processAndSetConfigs(text2).code;
    try {
      await getDiagramFromText(text2);
    } catch (error) {
      if (parseOptions == null ? void 0 : parseOptions.suppressErrors) {
        return false;
      }
      throw error;
    }
    return true;
  }
  const cssImportantStyles = (cssClass, element2, cssClasses = []) => {
    return `
.${cssClass} ${element2} { ${cssClasses.join(" !important; ")} !important; }`;
  };
  const createCssStyles = (config2, classDefs = {}) => {
    var _a2;
    let cssStyles = "";
    if (config2.themeCSS !== void 0) {
      cssStyles += `
${config2.themeCSS}`;
    }
    if (config2.fontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-font-family: ${config2.fontFamily}}`;
    }
    if (config2.altFontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-alt-font-family: ${config2.altFontFamily}}`;
    }
    if (!isEmpty(classDefs)) {
      const htmlLabels = config2.htmlLabels || ((_a2 = config2.flowchart) == null ? void 0 : _a2.htmlLabels);
      const cssHtmlElements = ["> *", "span"];
      const cssShapeElements = ["rect", "polygon", "ellipse", "circle", "path"];
      const cssElements = htmlLabels ? cssHtmlElements : cssShapeElements;
      for (const classId in classDefs) {
        const styleClassDef = classDefs[classId];
        if (!isEmpty(styleClassDef.styles)) {
          cssElements.forEach((cssElement) => {
            cssStyles += cssImportantStyles(styleClassDef.id, cssElement, styleClassDef.styles);
          });
        }
        if (!isEmpty(styleClassDef.textStyles)) {
          cssStyles += cssImportantStyles(styleClassDef.id, "tspan", styleClassDef.textStyles);
        }
      }
    }
    return cssStyles;
  };
  const createUserStyles = (config2, graphType, classDefs, svgId) => {
    const userCSSstyles = createCssStyles(config2, classDefs);
    const allStyles = getStyles$g(graphType, userCSSstyles, config2.themeVariables);
    return serialize(compile(`${svgId}{${allStyles}}`), stringify);
  };
  const cleanUpSvgCode = (svgCode = "", inSandboxMode, useArrowMarkerUrls) => {
    let cleanedUpSvg = svgCode;
    if (!useArrowMarkerUrls && !inSandboxMode) {
      cleanedUpSvg = cleanedUpSvg.replace(
        /marker-end="url\([\d+./:=?A-Za-z-]*?#/g,
        'marker-end="url(#'
      );
    }
    cleanedUpSvg = decodeEntities(cleanedUpSvg);
    cleanedUpSvg = cleanedUpSvg.replace(/<br>/g, "<br/>");
    return cleanedUpSvg;
  };
  const putIntoIFrame = (svgCode = "", svgElement) => {
    var _a2, _b2;
    const height = ((_b2 = (_a2 = svgElement == null ? void 0 : svgElement.viewBox) == null ? void 0 : _a2.baseVal) == null ? void 0 : _b2.height) ? svgElement.viewBox.baseVal.height + "px" : IFRAME_HEIGHT;
    const base64encodedSrc = btoa('<body style="' + IFRAME_BODY_STYLE + '">' + svgCode + "</body>");
    return `<iframe style="width:${IFRAME_WIDTH};height:${height};${IFRAME_STYLES}" src="data:text/html;base64,${base64encodedSrc}" sandbox="${IFRAME_SANDBOX_OPTS}">
  ${IFRAME_NOT_SUPPORTED_MSG}
</iframe>`;
  };
  const appendDivSvgG = (parentRoot, id2, enclosingDivId, divStyle, svgXlink) => {
    const enclosingDiv = parentRoot.append("div");
    enclosingDiv.attr("id", enclosingDivId);
    if (divStyle) {
      enclosingDiv.attr("style", divStyle);
    }
    const svgNode2 = enclosingDiv.append("svg").attr("id", id2).attr("width", "100%").attr("xmlns", XMLNS_SVG_STD);
    if (svgXlink) {
      svgNode2.attr("xmlns:xlink", svgXlink);
    }
    svgNode2.append("g");
    return parentRoot;
  };
  function sandboxedIframe(parentNode, iFrameId) {
    return parentNode.append("iframe").attr("id", iFrameId).attr("style", "width: 100%; height: 100%;").attr("sandbox", "");
  }
  const removeExistingElements = (doc, id2, divId, iFrameId) => {
    var _a2, _b2, _c;
    (_a2 = doc.getElementById(id2)) == null ? void 0 : _a2.remove();
    (_b2 = doc.getElementById(divId)) == null ? void 0 : _b2.remove();
    (_c = doc.getElementById(iFrameId)) == null ? void 0 : _c.remove();
  };
  const render$4 = async function(id2, text2, svgContainingElement) {
    var _a2, _b2, _c, _d, _e, _f;
    addDiagrams();
    const processed2 = processAndSetConfigs(text2);
    text2 = processed2.code;
    const config2 = getConfig$2();
    log$1.debug(config2);
    if (text2.length > ((config2 == null ? void 0 : config2.maxTextSize) ?? MAX_TEXTLENGTH)) {
      text2 = MAX_TEXTLENGTH_EXCEEDED_MSG;
    }
    const idSelector = "#" + id2;
    const iFrameID = "i" + id2;
    const iFrameID_selector = "#" + iFrameID;
    const enclosingDivID = "d" + id2;
    const enclosingDivID_selector = "#" + enclosingDivID;
    let root2 = d3select("body");
    const isSandboxed = config2.securityLevel === SECURITY_LVL_SANDBOX;
    const isLooseSecurityLevel = config2.securityLevel === SECURITY_LVL_LOOSE;
    const fontFamily = config2.fontFamily;
    if (svgContainingElement !== void 0) {
      if (svgContainingElement) {
        svgContainingElement.innerHTML = "";
      }
      if (isSandboxed) {
        const iframe = sandboxedIframe(d3select(svgContainingElement), iFrameID);
        root2 = d3select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = d3select(svgContainingElement);
      }
      appendDivSvgG(root2, id2, enclosingDivID, `font-family: ${fontFamily}`, XMLNS_XLINK_STD);
    } else {
      removeExistingElements(document, id2, enclosingDivID, iFrameID);
      if (isSandboxed) {
        const iframe = sandboxedIframe(d3select("body"), iFrameID);
        root2 = d3select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = d3select("body");
      }
      appendDivSvgG(root2, id2, enclosingDivID);
    }
    let diag;
    let parseEncounteredException;
    try {
      diag = await getDiagramFromText(text2, { title: processed2.title });
    } catch (error) {
      diag = new Diagram("error");
      parseEncounteredException = error;
    }
    const element2 = root2.select(enclosingDivID_selector).node();
    const diagramType = diag.type;
    const svg2 = element2.firstChild;
    const firstChild = svg2.firstChild;
    const diagramClassDefs = (_b2 = (_a2 = diag.renderer).getClasses) == null ? void 0 : _b2.call(_a2, text2, diag);
    const rules = createUserStyles(config2, diagramType, diagramClassDefs, idSelector);
    const style1 = document.createElement("style");
    style1.innerHTML = rules;
    svg2.insertBefore(style1, firstChild);
    try {
      await diag.renderer.draw(text2, id2, version$1, diag);
    } catch (e) {
      errorRenderer.draw(text2, id2, version$1);
      throw e;
    }
    const svgNode2 = root2.select(`${enclosingDivID_selector} svg`);
    const a11yTitle = (_d = (_c = diag.db).getAccTitle) == null ? void 0 : _d.call(_c);
    const a11yDescr = (_f = (_e = diag.db).getAccDescription) == null ? void 0 : _f.call(_e);
    addA11yInfo(diagramType, svgNode2, a11yTitle, a11yDescr);
    root2.select(`[id="${id2}"]`).selectAll("foreignobject > *").attr("xmlns", XMLNS_XHTML_STD);
    let svgCode = root2.select(enclosingDivID_selector).node().innerHTML;
    log$1.debug("config.arrowMarkerAbsolute", config2.arrowMarkerAbsolute);
    svgCode = cleanUpSvgCode(svgCode, isSandboxed, evaluate(config2.arrowMarkerAbsolute));
    if (isSandboxed) {
      const svgEl = root2.select(enclosingDivID_selector + " svg").node();
      svgCode = putIntoIFrame(svgCode, svgEl);
    } else if (!isLooseSecurityLevel) {
      svgCode = purify.sanitize(svgCode, {
        ADD_TAGS: DOMPURIFY_TAGS,
        ADD_ATTR: DOMPURIFY_ATTR
      });
    }
    attachFunctions();
    if (parseEncounteredException) {
      throw parseEncounteredException;
    }
    const tmpElementSelector = isSandboxed ? iFrameID_selector : enclosingDivID_selector;
    const node2 = d3select(tmpElementSelector).node();
    if (node2 && "remove" in node2) {
      node2.remove();
    }
    return {
      svg: svgCode,
      bindFunctions: diag.db.bindFunctions
    };
  };
  function initialize$1(options2 = {}) {
    var _a2;
    if ((options2 == null ? void 0 : options2.fontFamily) && !((_a2 = options2.themeVariables) == null ? void 0 : _a2.fontFamily)) {
      if (!options2.themeVariables) {
        options2.themeVariables = {};
      }
      options2.themeVariables.fontFamily = options2.fontFamily;
    }
    saveConfigFromInitialize(options2);
    if ((options2 == null ? void 0 : options2.theme) && options2.theme in theme) {
      options2.themeVariables = theme[options2.theme].getThemeVariables(
        options2.themeVariables
      );
    } else if (options2) {
      options2.themeVariables = theme.default.getThemeVariables(options2.themeVariables);
    }
    const config2 = typeof options2 === "object" ? setSiteConfig(options2) : getSiteConfig();
    setLogLevel$1(config2.logLevel);
    addDiagrams();
  }
  const getDiagramFromText = (text2, metadata = {}) => {
    const { code } = preprocessDiagram(text2);
    return getDiagramFromText$1(code, metadata);
  };
  function addA11yInfo(diagramType, svgNode2, a11yTitle, a11yDescr) {
    setA11yDiagramInfo(svgNode2, diagramType);
    addSVGa11yTitleDescription(svgNode2, a11yTitle, a11yDescr, svgNode2.attr("id"));
  }
  const mermaidAPI = Object.freeze({
    render: render$4,
    parse: parse$3,
    getDiagramFromText,
    initialize: initialize$1,
    getConfig: getConfig$2,
    setConfig: setConfig$1,
    getSiteConfig,
    updateSiteConfig,
    reset: () => {
      reset();
    },
    globalReset: () => {
      reset(defaultConfig$1);
    },
    defaultConfig: defaultConfig$1
  });
  setLogLevel$1(getConfig$2().logLevel);
  reset(getConfig$2());
  const loadRegisteredDiagrams = async () => {
    log$1.debug(`Loading registered diagrams`);
    const results = await Promise.allSettled(
      Object.entries(detectors).map(async ([key, { detector: detector2, loader: loader2 }]) => {
        if (loader2) {
          try {
            getDiagram(key);
          } catch (error) {
            try {
              const { diagram: diagram2, id: id2 } = await loader2();
              registerDiagram(id2, diagram2, detector2);
            } catch (err) {
              log$1.error(`Failed to load external diagram with key ${key}. Removing from detectors.`);
              delete detectors[key];
              throw err;
            }
          }
        }
      })
    );
    const failed = results.filter((result) => result.status === "rejected");
    if (failed.length > 0) {
      log$1.error(`Failed to load ${failed.length} external diagrams`);
      for (const res of failed) {
        log$1.error(res);
      }
      throw new Error(`Failed to load ${failed.length} external diagrams`);
    }
  };
  const handleError = (error, errors, parseError) => {
    log$1.warn(error);
    if (isDetailedError(error)) {
      if (parseError) {
        parseError(error.str, error.hash);
      }
      errors.push({ ...error, message: error.str, error });
    } else {
      if (parseError) {
        parseError(error);
      }
      if (error instanceof Error) {
        errors.push({
          str: error.message,
          message: error.message,
          hash: error.name,
          error
        });
      }
    }
  };
  const run$3 = async function(options2 = {
    querySelector: ".mermaid"
  }) {
    try {
      await runThrowsErrors(options2);
    } catch (e) {
      if (isDetailedError(e)) {
        log$1.error(e.str);
      }
      if (mermaid.parseError) {
        mermaid.parseError(e);
      }
      if (!options2.suppressErrors) {
        log$1.error("Use the suppressErrors option to suppress these errors");
        throw e;
      }
    }
  };
  const runThrowsErrors = async function({ postRenderCallback, querySelector, nodes: nodes2 } = {
    querySelector: ".mermaid"
  }) {
    const conf2 = mermaidAPI.getConfig();
    log$1.debug(`${!postRenderCallback ? "No " : ""}Callback function found`);
    let nodesToProcess;
    if (nodes2) {
      nodesToProcess = nodes2;
    } else if (querySelector) {
      nodesToProcess = document.querySelectorAll(querySelector);
    } else {
      throw new Error("Nodes and querySelector are both undefined");
    }
    log$1.debug(`Found ${nodesToProcess.length} diagrams`);
    if ((conf2 == null ? void 0 : conf2.startOnLoad) !== void 0) {
      log$1.debug("Start On Load: " + (conf2 == null ? void 0 : conf2.startOnLoad));
      mermaidAPI.updateSiteConfig({ startOnLoad: conf2 == null ? void 0 : conf2.startOnLoad });
    }
    const idGenerator = new utils$1.InitIDGenerator(conf2.deterministicIds, conf2.deterministicIDSeed);
    let txt;
    const errors = [];
    for (const element2 of Array.from(nodesToProcess)) {
      log$1.info("Rendering diagram: " + element2.id);
      /*! Check if previously processed */
      if (element2.getAttribute("data-processed")) {
        continue;
      }
      element2.setAttribute("data-processed", "true");
      const id2 = `mermaid-${idGenerator.next()}`;
      txt = element2.innerHTML;
      txt = dedent(utils$1.entityDecode(txt)).trim().replace(/<br\s*\/?>/gi, "<br/>");
      const init2 = utils$1.detectInit(txt);
      if (init2) {
        log$1.debug("Detected early reinit: ", init2);
      }
      try {
        const { svg: svg2, bindFunctions: bindFunctions2 } = await render$3(id2, txt, element2);
        element2.innerHTML = svg2;
        if (postRenderCallback) {
          await postRenderCallback(id2);
        }
        if (bindFunctions2) {
          bindFunctions2(element2);
        }
      } catch (error) {
        handleError(error, errors, mermaid.parseError);
      }
    }
    if (errors.length > 0) {
      throw errors[0];
    }
  };
  const initialize = function(config2) {
    mermaidAPI.initialize(config2);
  };
  const init = async function(config2, nodes2, callback) {
    log$1.warn("mermaid.init is deprecated. Please use run instead.");
    if (config2) {
      initialize(config2);
    }
    const runOptions = { postRenderCallback: callback, querySelector: ".mermaid" };
    if (typeof nodes2 === "string") {
      runOptions.querySelector = nodes2;
    } else if (nodes2) {
      if (nodes2 instanceof HTMLElement) {
        runOptions.nodes = [nodes2];
      } else {
        runOptions.nodes = nodes2;
      }
    }
    await run$3(runOptions);
  };
  const registerExternalDiagrams = async (diagrams2, {
    lazyLoad = true
  } = {}) => {
    registerLazyLoadedDiagrams(...diagrams2);
    if (lazyLoad === false) {
      await loadRegisteredDiagrams();
    }
  };
  const contentLoaded = function() {
    if (mermaid.startOnLoad) {
      const { startOnLoad } = mermaidAPI.getConfig();
      if (startOnLoad) {
        mermaid.run().catch((err) => log$1.error("Mermaid failed to initialize", err));
      }
    }
  };
  if (typeof document !== "undefined") {
    /*!
     * Wait for document loaded before starting the execution
     */
    window.addEventListener("load", contentLoaded, false);
  }
  const setParseErrorHandler = function(parseErrorHandler) {
    mermaid.parseError = parseErrorHandler;
  };
  const executionQueue = [];
  let executionQueueRunning = false;
  const executeQueue = async () => {
    if (executionQueueRunning) {
      return;
    }
    executionQueueRunning = true;
    while (executionQueue.length > 0) {
      const f2 = executionQueue.shift();
      if (f2) {
        try {
          await f2();
        } catch (e) {
          log$1.error("Error executing queue", e);
        }
      }
    }
    executionQueueRunning = false;
  };
  const parse$2 = async (text2, parseOptions) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.parse(text2, parseOptions).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a2;
            log$1.error("Error parsing", e);
            (_a2 = mermaid.parseError) == null ? void 0 : _a2.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const render$3 = (id2, text2, container) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.render(id2, text2, container).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a2;
            log$1.error("Error parsing", e);
            (_a2 = mermaid.parseError) == null ? void 0 : _a2.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const mermaid = {
    startOnLoad: true,
    mermaidAPI,
    parse: parse$2,
    render: render$3,
    init,
    run: run$3,
    registerExternalDiagrams,
    initialize,
    parseError: void 0,
    contentLoaded,
    setParseErrorHandler,
    detectType
  };
  class SourceLocation {
    // The + prefix indicates that these fields aren't writeable
    // Lexer holding the input string.
    // Start offset, zero-based inclusive.
    // End offset, zero-based exclusive.
    constructor(lexer, start2, end2) {
      this.lexer = void 0;
      this.start = void 0;
      this.end = void 0;
      this.lexer = lexer;
      this.start = start2;
      this.end = end2;
    }
    /**
     * Merges two `SourceLocation`s from location providers, given they are
     * provided in order of appearance.
     * - Returns the first one's location if only the first is provided.
     * - Returns a merged range of the first and the last if both are provided
     *   and their lexers match.
     * - Otherwise, returns null.
     */
    static range(first, second2) {
      if (!second2) {
        return first && first.loc;
      } else if (!first || !first.loc || !second2.loc || first.loc.lexer !== second2.loc.lexer) {
        return null;
      } else {
        return new SourceLocation(first.loc.lexer, first.loc.start, second2.loc.end);
      }
    }
  }
  class Token {
    // don't expand the token
    // used in \noexpand
    constructor(text2, loc) {
      this.text = void 0;
      this.loc = void 0;
      this.noexpand = void 0;
      this.treatAsRelax = void 0;
      this.text = text2;
      this.loc = loc;
    }
    /**
     * Given a pair of tokens (this and endToken), compute a `Token` encompassing
     * the whole input range enclosed by these two.
     */
    range(endToken, text2) {
      return new Token(text2, SourceLocation.range(this, endToken));
    }
  }
  class ParseError {
    // Error start position based on passed-in Token or ParseNode.
    // Length of affected text based on passed-in Token or ParseNode.
    // The underlying error message without any context added.
    constructor(message, token2) {
      this.name = void 0;
      this.position = void 0;
      this.length = void 0;
      this.rawMessage = void 0;
      var error = "KaTeX parse error: " + message;
      var start2;
      var end2;
      var loc = token2 && token2.loc;
      if (loc && loc.start <= loc.end) {
        var input = loc.lexer.input;
        start2 = loc.start;
        end2 = loc.end;
        if (start2 === input.length) {
          error += " at end of input: ";
        } else {
          error += " at position " + (start2 + 1) + ": ";
        }
        var underlined = input.slice(start2, end2).replace(/[^]/g, "$&̲");
        var left2;
        if (start2 > 15) {
          left2 = "…" + input.slice(start2 - 15, start2);
        } else {
          left2 = input.slice(0, start2);
        }
        var right2;
        if (end2 + 15 < input.length) {
          right2 = input.slice(end2, end2 + 15) + "…";
        } else {
          right2 = input.slice(end2);
        }
        error += left2 + underlined + right2;
      }
      var self2 = new Error(error);
      self2.name = "ParseError";
      self2.__proto__ = ParseError.prototype;
      self2.position = start2;
      if (start2 != null && end2 != null) {
        self2.length = end2 - start2;
      }
      self2.rawMessage = message;
      return self2;
    }
  }
  ParseError.prototype.__proto__ = Error.prototype;
  var contains = function contains2(list2, elem) {
    return list2.indexOf(elem) !== -1;
  };
  var deflt = function deflt2(setting, defaultIfUndefined) {
    return setting === void 0 ? defaultIfUndefined : setting;
  };
  var uppercase = /([A-Z])/g;
  var hyphenate = function hyphenate2(str2) {
    return str2.replace(uppercase, "-$1").toLowerCase();
  };
  var ESCAPE_LOOKUP = {
    "&": "&amp;",
    ">": "&gt;",
    "<": "&lt;",
    '"': "&quot;",
    "'": "&#x27;"
  };
  var ESCAPE_REGEX = /[&><"']/g;
  function escape$1(text2) {
    return String(text2).replace(ESCAPE_REGEX, (match) => ESCAPE_LOOKUP[match]);
  }
  var getBaseElem = function getBaseElem2(group) {
    if (group.type === "ordgroup") {
      if (group.body.length === 1) {
        return getBaseElem2(group.body[0]);
      } else {
        return group;
      }
    } else if (group.type === "color") {
      if (group.body.length === 1) {
        return getBaseElem2(group.body[0]);
      } else {
        return group;
      }
    } else if (group.type === "font") {
      return getBaseElem2(group.body);
    } else {
      return group;
    }
  };
  var isCharacterBox = function isCharacterBox2(group) {
    var baseElem = getBaseElem(group);
    return baseElem.type === "mathord" || baseElem.type === "textord" || baseElem.type === "atom";
  };
  var assert = function assert2(value2) {
    if (!value2) {
      throw new Error("Expected non-null, but got " + String(value2));
    }
    return value2;
  };
  var protocolFromUrl = function protocolFromUrl2(url) {
    var protocol = /^\s*([^\\/#]*?)(?::|&#0*58|&#x0*3a)/i.exec(url);
    return protocol != null ? protocol[1] : "_relative";
  };
  var utils = {
    contains,
    deflt,
    escape: escape$1,
    hyphenate,
    getBaseElem,
    isCharacterBox,
    protocolFromUrl
  };
  var SETTINGS_SCHEMA = {
    displayMode: {
      type: "boolean",
      description: "Render math in display mode, which puts the math in display style (so \\int and \\sum are large, for example), and centers the math on the page on its own line.",
      cli: "-d, --display-mode"
    },
    output: {
      type: {
        enum: ["htmlAndMathml", "html", "mathml"]
      },
      description: "Determines the markup language of the output.",
      cli: "-F, --format <type>"
    },
    leqno: {
      type: "boolean",
      description: "Render display math in leqno style (left-justified tags)."
    },
    fleqn: {
      type: "boolean",
      description: "Render display math flush left."
    },
    throwOnError: {
      type: "boolean",
      default: true,
      cli: "-t, --no-throw-on-error",
      cliDescription: "Render errors (in the color given by --error-color) instead of throwing a ParseError exception when encountering an error."
    },
    errorColor: {
      type: "string",
      default: "#cc0000",
      cli: "-c, --error-color <color>",
      cliDescription: "A color string given in the format 'rgb' or 'rrggbb' (no #). This option determines the color of errors rendered by the -t option.",
      cliProcessor: (color2) => "#" + color2
    },
    macros: {
      type: "object",
      cli: "-m, --macro <def>",
      cliDescription: "Define custom macro of the form '\\foo:expansion' (use multiple -m arguments for multiple macros).",
      cliDefault: [],
      cliProcessor: (def, defs) => {
        defs.push(def);
        return defs;
      }
    },
    minRuleThickness: {
      type: "number",
      description: "Specifies a minimum thickness, in ems, for fraction lines, `\\sqrt` top lines, `{array}` vertical lines, `\\hline`, `\\hdashline`, `\\underline`, `\\overline`, and the borders of `\\fbox`, `\\boxed`, and `\\fcolorbox`.",
      processor: (t) => Math.max(0, t),
      cli: "--min-rule-thickness <size>",
      cliProcessor: parseFloat
    },
    colorIsTextColor: {
      type: "boolean",
      description: "Makes \\color behave like LaTeX's 2-argument \\textcolor, instead of LaTeX's one-argument \\color mode change.",
      cli: "-b, --color-is-text-color"
    },
    strict: {
      type: [{
        enum: ["warn", "ignore", "error"]
      }, "boolean", "function"],
      description: "Turn on strict / LaTeX faithfulness mode, which throws an error if the input uses features that are not supported by LaTeX.",
      cli: "-S, --strict",
      cliDefault: false
    },
    trust: {
      type: ["boolean", "function"],
      description: "Trust the input, enabling all HTML features such as \\url.",
      cli: "-T, --trust"
    },
    maxSize: {
      type: "number",
      default: Infinity,
      description: "If non-zero, all user-specified sizes, e.g. in \\rule{500em}{500em}, will be capped to maxSize ems. Otherwise, elements and spaces can be arbitrarily large",
      processor: (s) => Math.max(0, s),
      cli: "-s, --max-size <n>",
      cliProcessor: parseInt
    },
    maxExpand: {
      type: "number",
      default: 1e3,
      description: "Limit the number of macro expansions to the specified number, to prevent e.g. infinite macro loops. If set to Infinity, the macro expander will try to fully expand as in LaTeX.",
      processor: (n) => Math.max(0, n),
      cli: "-e, --max-expand <n>",
      cliProcessor: (n) => n === "Infinity" ? Infinity : parseInt(n)
    },
    globalGroup: {
      type: "boolean",
      cli: false
    }
  };
  function getDefaultValue(schema2) {
    if (schema2.default) {
      return schema2.default;
    }
    var type2 = schema2.type;
    var defaultType = Array.isArray(type2) ? type2[0] : type2;
    if (typeof defaultType !== "string") {
      return defaultType.enum[0];
    }
    switch (defaultType) {
      case "boolean":
        return false;
      case "string":
        return "";
      case "number":
        return 0;
      case "object":
        return {};
    }
  }
  class Settings {
    constructor(options2) {
      this.displayMode = void 0;
      this.output = void 0;
      this.leqno = void 0;
      this.fleqn = void 0;
      this.throwOnError = void 0;
      this.errorColor = void 0;
      this.macros = void 0;
      this.minRuleThickness = void 0;
      this.colorIsTextColor = void 0;
      this.strict = void 0;
      this.trust = void 0;
      this.maxSize = void 0;
      this.maxExpand = void 0;
      this.globalGroup = void 0;
      options2 = options2 || {};
      for (var prop in SETTINGS_SCHEMA) {
        if (SETTINGS_SCHEMA.hasOwnProperty(prop)) {
          var schema2 = SETTINGS_SCHEMA[prop];
          this[prop] = options2[prop] !== void 0 ? schema2.processor ? schema2.processor(options2[prop]) : options2[prop] : getDefaultValue(schema2);
        }
      }
    }
    /**
     * Report nonstrict (non-LaTeX-compatible) input.
     * Can safely not be called if `this.strict` is false in JavaScript.
     */
    reportNonstrict(errorCode, errorMsg, token2) {
      var strict = this.strict;
      if (typeof strict === "function") {
        strict = strict(errorCode, errorMsg, token2);
      }
      if (!strict || strict === "ignore") {
        return;
      } else if (strict === true || strict === "error") {
        throw new ParseError("LaTeX-incompatible input and strict mode is set to 'error': " + (errorMsg + " [" + errorCode + "]"), token2);
      } else if (strict === "warn") {
        typeof console !== "undefined" && console.warn("LaTeX-incompatible input and strict mode is set to 'warn': " + (errorMsg + " [" + errorCode + "]"));
      } else {
        typeof console !== "undefined" && console.warn("LaTeX-incompatible input and strict mode is set to " + ("unrecognized '" + strict + "': " + errorMsg + " [" + errorCode + "]"));
      }
    }
    /**
     * Check whether to apply strict (LaTeX-adhering) behavior for unusual
     * input (like `\\`).  Unlike `nonstrict`, will not throw an error;
     * instead, "error" translates to a return value of `true`, while "ignore"
     * translates to a return value of `false`.  May still print a warning:
     * "warn" prints a warning and returns `false`.
     * This is for the second category of `errorCode`s listed in the README.
     */
    useStrictBehavior(errorCode, errorMsg, token2) {
      var strict = this.strict;
      if (typeof strict === "function") {
        try {
          strict = strict(errorCode, errorMsg, token2);
        } catch (error) {
          strict = "error";
        }
      }
      if (!strict || strict === "ignore") {
        return false;
      } else if (strict === true || strict === "error") {
        return true;
      } else if (strict === "warn") {
        typeof console !== "undefined" && console.warn("LaTeX-incompatible input and strict mode is set to 'warn': " + (errorMsg + " [" + errorCode + "]"));
        return false;
      } else {
        typeof console !== "undefined" && console.warn("LaTeX-incompatible input and strict mode is set to " + ("unrecognized '" + strict + "': " + errorMsg + " [" + errorCode + "]"));
        return false;
      }
    }
    /**
     * Check whether to test potentially dangerous input, and return
     * `true` (trusted) or `false` (untrusted).  The sole argument `context`
     * should be an object with `command` field specifying the relevant LaTeX
     * command (as a string starting with `\`), and any other arguments, etc.
     * If `context` has a `url` field, a `protocol` field will automatically
     * get added by this function (changing the specified object).
     */
    isTrusted(context) {
      if (context.url && !context.protocol) {
        context.protocol = utils.protocolFromUrl(context.url);
      }
      var trust = typeof this.trust === "function" ? this.trust(context) : this.trust;
      return Boolean(trust);
    }
  }
  class Style {
    constructor(id2, size2, cramped) {
      this.id = void 0;
      this.size = void 0;
      this.cramped = void 0;
      this.id = id2;
      this.size = size2;
      this.cramped = cramped;
    }
    /**
     * Get the style of a superscript given a base in the current style.
     */
    sup() {
      return styles$a[sup[this.id]];
    }
    /**
     * Get the style of a subscript given a base in the current style.
     */
    sub() {
      return styles$a[sub[this.id]];
    }
    /**
     * Get the style of a fraction numerator given the fraction in the current
     * style.
     */
    fracNum() {
      return styles$a[fracNum[this.id]];
    }
    /**
     * Get the style of a fraction denominator given the fraction in the current
     * style.
     */
    fracDen() {
      return styles$a[fracDen[this.id]];
    }
    /**
     * Get the cramped version of a style (in particular, cramping a cramped style
     * doesn't change the style).
     */
    cramp() {
      return styles$a[cramp[this.id]];
    }
    /**
     * Get a text or display version of this style.
     */
    text() {
      return styles$a[text$1$1[this.id]];
    }
    /**
     * Return true if this style is tightly spaced (scriptstyle/scriptscriptstyle)
     */
    isTight() {
      return this.size >= 2;
    }
  }
  var D = 0;
  var Dc = 1;
  var T = 2;
  var Tc = 3;
  var S = 4;
  var Sc = 5;
  var SS = 6;
  var SSc = 7;
  var styles$a = [new Style(D, 0, false), new Style(Dc, 0, true), new Style(T, 1, false), new Style(Tc, 1, true), new Style(S, 2, false), new Style(Sc, 2, true), new Style(SS, 3, false), new Style(SSc, 3, true)];
  var sup = [S, Sc, S, Sc, SS, SSc, SS, SSc];
  var sub = [Sc, Sc, Sc, Sc, SSc, SSc, SSc, SSc];
  var fracNum = [T, Tc, S, Sc, SS, SSc, SS, SSc];
  var fracDen = [Tc, Tc, Sc, Sc, SSc, SSc, SSc, SSc];
  var cramp = [Dc, Dc, Tc, Tc, Sc, Sc, SSc, SSc];
  var text$1$1 = [D, Dc, T, Tc, T, Tc, T, Tc];
  var Style$1 = {
    DISPLAY: styles$a[D],
    TEXT: styles$a[T],
    SCRIPT: styles$a[S],
    SCRIPTSCRIPT: styles$a[SS]
  };
  var scriptData = [{
    // Latin characters beyond the Latin-1 characters we have metrics for.
    // Needed for Czech, Hungarian and Turkish text, for example.
    name: "latin",
    blocks: [
      [256, 591],
      // Latin Extended-A and Latin Extended-B
      [768, 879]
      // Combining Diacritical marks
    ]
  }, {
    // The Cyrillic script used by Russian and related languages.
    // A Cyrillic subset used to be supported as explicitly defined
    // symbols in symbols.js
    name: "cyrillic",
    blocks: [[1024, 1279]]
  }, {
    // Armenian
    name: "armenian",
    blocks: [[1328, 1423]]
  }, {
    // The Brahmic scripts of South and Southeast Asia
    // Devanagari (0900–097F)
    // Bengali (0980–09FF)
    // Gurmukhi (0A00–0A7F)
    // Gujarati (0A80–0AFF)
    // Oriya (0B00–0B7F)
    // Tamil (0B80–0BFF)
    // Telugu (0C00–0C7F)
    // Kannada (0C80–0CFF)
    // Malayalam (0D00–0D7F)
    // Sinhala (0D80–0DFF)
    // Thai (0E00–0E7F)
    // Lao (0E80–0EFF)
    // Tibetan (0F00–0FFF)
    // Myanmar (1000–109F)
    name: "brahmic",
    blocks: [[2304, 4255]]
  }, {
    name: "georgian",
    blocks: [[4256, 4351]]
  }, {
    // Chinese and Japanese.
    // The "k" in cjk is for Korean, but we've separated Korean out
    name: "cjk",
    blocks: [
      [12288, 12543],
      // CJK symbols and punctuation, Hiragana, Katakana
      [19968, 40879],
      // CJK ideograms
      [65280, 65376]
      // Fullwidth punctuation
      // TODO: add halfwidth Katakana and Romanji glyphs
    ]
  }, {
    // Korean
    name: "hangul",
    blocks: [[44032, 55215]]
  }];
  function scriptFromCodepoint(codepoint) {
    for (var i2 = 0; i2 < scriptData.length; i2++) {
      var script = scriptData[i2];
      for (var _i6 = 0; _i6 < script.blocks.length; _i6++) {
        var block2 = script.blocks[_i6];
        if (codepoint >= block2[0] && codepoint <= block2[1]) {
          return script.name;
        }
      }
    }
    return null;
  }
  var allBlocks = [];
  scriptData.forEach((s) => s.blocks.forEach((b) => allBlocks.push(...b)));
  function supportedCodepoint(codepoint) {
    for (var i2 = 0; i2 < allBlocks.length; i2 += 2) {
      if (codepoint >= allBlocks[i2] && codepoint <= allBlocks[i2 + 1]) {
        return true;
      }
    }
    return false;
  }
  var hLinePad = 80;
  var sqrtMain = function sqrtMain2(extraVinculum, hLinePad2) {
    return "M95," + (622 + extraVinculum + hLinePad2) + "\nc-2.7,0,-7.17,-2.7,-13.5,-8c-5.8,-5.3,-9.5,-10,-9.5,-14\nc0,-2,0.3,-3.3,1,-4c1.3,-2.7,23.83,-20.7,67.5,-54\nc44.2,-33.3,65.8,-50.3,66.5,-51c1.3,-1.3,3,-2,5,-2c4.7,0,8.7,3.3,12,10\ns173,378,173,378c0.7,0,35.3,-71,104,-213c68.7,-142,137.5,-285,206.5,-429\nc69,-144,104.5,-217.7,106.5,-221\nl" + extraVinculum / 2.075 + " -" + extraVinculum + "\nc5.3,-9.3,12,-14,20,-14\nH400000v" + (40 + extraVinculum) + "H845.2724\ns-225.272,467,-225.272,467s-235,486,-235,486c-2.7,4.7,-9,7,-19,7\nc-6,0,-10,-1,-12,-3s-194,-422,-194,-422s-65,47,-65,47z\nM" + (834 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
  };
  var sqrtSize1 = function sqrtSize12(extraVinculum, hLinePad2) {
    return "M263," + (601 + extraVinculum + hLinePad2) + "c0.7,0,18,39.7,52,119\nc34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120\nc340,-704.7,510.7,-1060.3,512,-1067\nl" + extraVinculum / 2.084 + " -" + extraVinculum + "\nc4.7,-7.3,11,-11,19,-11\nH40000v" + (40 + extraVinculum) + "H1012.3\ns-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232\nc-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1\ns-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26\nc-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z\nM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
  };
  var sqrtSize2 = function sqrtSize22(extraVinculum, hLinePad2) {
    return "M983 " + (10 + extraVinculum + hLinePad2) + "\nl" + extraVinculum / 3.13 + " -" + extraVinculum + "\nc4,-6.7,10,-10,18,-10 H400000v" + (40 + extraVinculum) + "\nH1013.1s-83.4,268,-264.1,840c-180.7,572,-277,876.3,-289,913c-4.7,4.7,-12.7,7,-24,7\ns-12,0,-12,0c-1.3,-3.3,-3.7,-11.7,-7,-25c-35.3,-125.3,-106.7,-373.3,-214,-744\nc-10,12,-21,25,-33,39s-32,39,-32,39c-6,-5.3,-15,-14,-27,-26s25,-30,25,-30\nc26.7,-32.7,52,-63,76,-91s52,-60,52,-60s208,722,208,722\nc56,-175.3,126.3,-397.3,211,-666c84.7,-268.7,153.8,-488.2,207.5,-658.5\nc53.7,-170.3,84.5,-266.8,92.5,-289.5z\nM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "h-400000z";
  };
  var sqrtSize3 = function sqrtSize32(extraVinculum, hLinePad2) {
    return "M424," + (2398 + extraVinculum + hLinePad2) + "\nc-1.3,-0.7,-38.5,-172,-111.5,-514c-73,-342,-109.8,-513.3,-110.5,-514\nc0,-2,-10.7,14.3,-32,49c-4.7,7.3,-9.8,15.7,-15.5,25c-5.7,9.3,-9.8,16,-12.5,20\ns-5,7,-5,7c-4,-3.3,-8.3,-7.7,-13,-13s-13,-13,-13,-13s76,-122,76,-122s77,-121,77,-121\ns209,968,209,968c0,-2,84.7,-361.7,254,-1079c169.3,-717.3,254.7,-1077.7,256,-1081\nl" + extraVinculum / 4.223 + " -" + extraVinculum + "c4,-6.7,10,-10,18,-10 H400000\nv" + (40 + extraVinculum) + "H1014.6\ns-87.3,378.7,-272.6,1166c-185.3,787.3,-279.3,1182.3,-282,1185\nc-2,6,-10,9,-24,9\nc-8,0,-12,-0.7,-12,-2z M" + (1001 + extraVinculum) + " " + hLinePad2 + "\nh400000v" + (40 + extraVinculum) + "h-400000z";
  };
  var sqrtSize4 = function sqrtSize42(extraVinculum, hLinePad2) {
    return "M473," + (2713 + extraVinculum + hLinePad2) + "\nc339.3,-1799.3,509.3,-2700,510,-2702 l" + extraVinculum / 5.298 + " -" + extraVinculum + "\nc3.3,-7.3,9.3,-11,18,-11 H400000v" + (40 + extraVinculum) + "H1017.7\ns-90.5,478,-276.2,1466c-185.7,988,-279.5,1483,-281.5,1485c-2,6,-10,9,-24,9\nc-8,0,-12,-0.7,-12,-2c0,-1.3,-5.3,-32,-16,-92c-50.7,-293.3,-119.7,-693.3,-207,-1200\nc0,-1.3,-5.3,8.7,-16,30c-10.7,21.3,-21.3,42.7,-32,64s-16,33,-16,33s-26,-26,-26,-26\ns76,-153,76,-153s77,-151,77,-151c0.7,0.7,35.7,202,105,604c67.3,400.7,102,602.7,104,\n606zM" + (1001 + extraVinculum) + " " + hLinePad2 + "h400000v" + (40 + extraVinculum) + "H1017.7z";
  };
  var phasePath = function phasePath2(y2) {
    var x2 = y2 / 2;
    return "M400000 " + y2 + " H0 L" + x2 + " 0 l65 45 L145 " + (y2 - 80) + " H400000z";
  };
  var sqrtTall = function sqrtTall2(extraVinculum, hLinePad2, viewBoxHeight) {
    var vertSegment = viewBoxHeight - 54 - hLinePad2 - extraVinculum;
    return "M702 " + (extraVinculum + hLinePad2) + "H400000" + (40 + extraVinculum) + "\nH742v" + vertSegment + "l-4 4-4 4c-.667.7 -2 1.5-4 2.5s-4.167 1.833-6.5 2.5-5.5 1-9.5 1\nh-12l-28-84c-16.667-52-96.667 -294.333-240-727l-212 -643 -85 170\nc-4-3.333-8.333-7.667-13 -13l-13-13l77-155 77-156c66 199.333 139 419.667\n219 661 l218 661zM702 " + hLinePad2 + "H400000v" + (40 + extraVinculum) + "H742z";
  };
  var sqrtPath = function sqrtPath2(size2, extraVinculum, viewBoxHeight) {
    extraVinculum = 1e3 * extraVinculum;
    var path2 = "";
    switch (size2) {
      case "sqrtMain":
        path2 = sqrtMain(extraVinculum, hLinePad);
        break;
      case "sqrtSize1":
        path2 = sqrtSize1(extraVinculum, hLinePad);
        break;
      case "sqrtSize2":
        path2 = sqrtSize2(extraVinculum, hLinePad);
        break;
      case "sqrtSize3":
        path2 = sqrtSize3(extraVinculum, hLinePad);
        break;
      case "sqrtSize4":
        path2 = sqrtSize4(extraVinculum, hLinePad);
        break;
      case "sqrtTall":
        path2 = sqrtTall(extraVinculum, hLinePad, viewBoxHeight);
    }
    return path2;
  };
  var innerPath = function innerPath2(name, height) {
    switch (name) {
      case "⎜":
        return "M291 0 H417 V" + height + " H291z M291 0 H417 V" + height + " H291z";
      case "∣":
        return "M145 0 H188 V" + height + " H145z M145 0 H188 V" + height + " H145z";
      case "∥":
        return "M145 0 H188 V" + height + " H145z M145 0 H188 V" + height + " H145z" + ("M367 0 H410 V" + height + " H367z M367 0 H410 V" + height + " H367z");
      case "⎟":
        return "M457 0 H583 V" + height + " H457z M457 0 H583 V" + height + " H457z";
      case "⎢":
        return "M319 0 H403 V" + height + " H319z M319 0 H403 V" + height + " H319z";
      case "⎥":
        return "M263 0 H347 V" + height + " H263z M263 0 H347 V" + height + " H263z";
      case "⎪":
        return "M384 0 H504 V" + height + " H384z M384 0 H504 V" + height + " H384z";
      case "⏐":
        return "M312 0 H355 V" + height + " H312z M312 0 H355 V" + height + " H312z";
      case "‖":
        return "M257 0 H300 V" + height + " H257z M257 0 H300 V" + height + " H257z" + ("M478 0 H521 V" + height + " H478z M478 0 H521 V" + height + " H478z");
      default:
        return "";
    }
  };
  var path$1 = {
    // The doubleleftarrow geometry is from glyph U+21D0 in the font KaTeX Main
    doubleleftarrow: "M262 157\nl10-10c34-36 62.7-77 86-123 3.3-8 5-13.3 5-16 0-5.3-6.7-8-20-8-7.3\n 0-12.2.5-14.5 1.5-2.3 1-4.8 4.5-7.5 10.5-49.3 97.3-121.7 169.3-217 216-28\n 14-57.3 25-88 33-6.7 2-11 3.8-13 5.5-2 1.7-3 4.2-3 7.5s1 5.8 3 7.5\nc2 1.7 6.3 3.5 13 5.5 68 17.3 128.2 47.8 180.5 91.5 52.3 43.7 93.8 96.2 124.5\n 157.5 9.3 8 15.3 12.3 18 13h6c12-.7 18-4 18-10 0-2-1.7-7-5-15-23.3-46-52-87\n-86-123l-10-10h399738v-40H218c328 0 0 0 0 0l-10-8c-26.7-20-65.7-43-117-69 2.7\n-2 6-3.7 10-5 36.7-16 72.3-37.3 107-64l10-8h399782v-40z\nm8 0v40h399730v-40zm0 194v40h399730v-40z",
    // doublerightarrow is from glyph U+21D2 in font KaTeX Main
    doublerightarrow: "M399738 392l\n-10 10c-34 36-62.7 77-86 123-3.3 8-5 13.3-5 16 0 5.3 6.7 8 20 8 7.3 0 12.2-.5\n 14.5-1.5 2.3-1 4.8-4.5 7.5-10.5 49.3-97.3 121.7-169.3 217-216 28-14 57.3-25 88\n-33 6.7-2 11-3.8 13-5.5 2-1.7 3-4.2 3-7.5s-1-5.8-3-7.5c-2-1.7-6.3-3.5-13-5.5-68\n-17.3-128.2-47.8-180.5-91.5-52.3-43.7-93.8-96.2-124.5-157.5-9.3-8-15.3-12.3-18\n-13h-6c-12 .7-18 4-18 10 0 2 1.7 7 5 15 23.3 46 52 87 86 123l10 10H0v40h399782\nc-328 0 0 0 0 0l10 8c26.7 20 65.7 43 117 69-2.7 2-6 3.7-10 5-36.7 16-72.3 37.3\n-107 64l-10 8H0v40zM0 157v40h399730v-40zm0 194v40h399730v-40z",
    // leftarrow is from glyph U+2190 in font KaTeX Main
    leftarrow: "M400000 241H110l3-3c68.7-52.7 113.7-120\n 135-202 4-14.7 6-23 6-25 0-7.3-7-11-21-11-8 0-13.2.8-15.5 2.5-2.3 1.7-4.2 5.8\n-5.5 12.5-1.3 4.7-2.7 10.3-4 17-12 48.7-34.8 92-68.5 130S65.3 228.3 18 247\nc-10 4-16 7.7-18 11 0 8.7 6 14.3 18 17 47.3 18.7 87.8 47 121.5 85S196 441.3 208\n 490c.7 2 1.3 5 2 9s1.2 6.7 1.5 8c.3 1.3 1 3.3 2 6s2.2 4.5 3.5 5.5c1.3 1 3.3\n 1.8 6 2.5s6 1 10 1c14 0 21-3.7 21-11 0-2-2-10.3-6-25-20-79.3-65-146.7-135-202\n l-3-3h399890zM100 241v40h399900v-40z",
    // overbrace is from glyphs U+23A9/23A8/23A7 in font KaTeX_Size4-Regular
    leftbrace: "M6 548l-6-6v-35l6-11c56-104 135.3-181.3 238-232 57.3-28.7 117\n-45 179-50h399577v120H403c-43.3 7-81 15-113 26-100.7 33-179.7 91-237 174-2.7\n 5-6 9-10 13-.7 1-7.3 1-20 1H6z",
    leftbraceunder: "M0 6l6-6h17c12.688 0 19.313.3 20 1 4 4 7.313 8.3 10 13\n 35.313 51.3 80.813 93.8 136.5 127.5 55.688 33.7 117.188 55.8 184.5 66.5.688\n 0 2 .3 4 1 18.688 2.7 76 4.3 172 5h399450v120H429l-6-1c-124.688-8-235-61.7\n-331-161C60.687 138.7 32.312 99.3 7 54L0 41V6z",
    // overgroup is from the MnSymbol package (public domain)
    leftgroup: "M400000 80\nH435C64 80 168.3 229.4 21 260c-5.9 1.2-18 0-18 0-2 0-3-1-3-3v-38C76 61 257 0\n 435 0h399565z",
    leftgroupunder: "M400000 262\nH435C64 262 168.3 112.6 21 82c-5.9-1.2-18 0-18 0-2 0-3 1-3 3v38c76 158 257 219\n 435 219h399565z",
    // Harpoons are from glyph U+21BD in font KaTeX Main
    leftharpoon: "M0 267c.7 5.3 3 10 7 14h399993v-40H93c3.3\n-3.3 10.2-9.5 20.5-18.5s17.8-15.8 22.5-20.5c50.7-52 88-110.3 112-175 4-11.3 5\n-18.3 3-21-1.3-4-7.3-6-18-6-8 0-13 .7-15 2s-4.7 6.7-8 16c-42 98.7-107.3 174.7\n-196 228-6.7 4.7-10.7 8-12 10-1.3 2-2 5.7-2 11zm100-26v40h399900v-40z",
    leftharpoonplus: "M0 267c.7 5.3 3 10 7 14h399993v-40H93c3.3-3.3 10.2-9.5\n 20.5-18.5s17.8-15.8 22.5-20.5c50.7-52 88-110.3 112-175 4-11.3 5-18.3 3-21-1.3\n-4-7.3-6-18-6-8 0-13 .7-15 2s-4.7 6.7-8 16c-42 98.7-107.3 174.7-196 228-6.7 4.7\n-10.7 8-12 10-1.3 2-2 5.7-2 11zm100-26v40h399900v-40zM0 435v40h400000v-40z\nm0 0v40h400000v-40z",
    leftharpoondown: "M7 241c-4 4-6.333 8.667-7 14 0 5.333.667 9 2 11s5.333\n 5.333 12 10c90.667 54 156 130 196 228 3.333 10.667 6.333 16.333 9 17 2 .667 5\n 1 9 1h5c10.667 0 16.667-2 18-6 2-2.667 1-9.667-3-21-32-87.333-82.667-157.667\n-152-211l-3-3h399907v-40zM93 281 H400000 v-40L7 241z",
    leftharpoondownplus: "M7 435c-4 4-6.3 8.7-7 14 0 5.3.7 9 2 11s5.3 5.3 12\n 10c90.7 54 156 130 196 228 3.3 10.7 6.3 16.3 9 17 2 .7 5 1 9 1h5c10.7 0 16.7\n-2 18-6 2-2.7 1-9.7-3-21-32-87.3-82.7-157.7-152-211l-3-3h399907v-40H7zm93 0\nv40h399900v-40zM0 241v40h399900v-40zm0 0v40h399900v-40z",
    // hook is from glyph U+21A9 in font KaTeX Main
    lefthook: "M400000 281 H103s-33-11.2-61-33.5S0 197.3 0 164s14.2-61.2 42.5\n-83.5C70.8 58.2 104 47 142 47 c16.7 0 25 6.7 25 20 0 12-8.7 18.7-26 20-40 3.3\n-68.7 15.7-86 37-10 12-15 25.3-15 40 0 22.7 9.8 40.7 29.5 54 19.7 13.3 43.5 21\n 71.5 23h399859zM103 281v-40h399897v40z",
    leftlinesegment: "M40 281 V428 H0 V94 H40 V241 H400000 v40z\nM40 281 V428 H0 V94 H40 V241 H400000 v40z",
    leftmapsto: "M40 281 V448H0V74H40V241H400000v40z\nM40 281 V448H0V74H40V241H400000v40z",
    // tofrom is from glyph U+21C4 in font KaTeX AMS Regular
    leftToFrom: "M0 147h400000v40H0zm0 214c68 40 115.7 95.7 143 167h22c15.3 0 23\n-.3 23-1 0-1.3-5.3-13.7-16-37-18-35.3-41.3-69-70-101l-7-8h399905v-40H95l7-8\nc28.7-32 52-65.7 70-101 10.7-23.3 16-35.7 16-37 0-.7-7.7-1-23-1h-22C115.7 265.3\n 68 321 0 361zm0-174v-40h399900v40zm100 154v40h399900v-40z",
    longequal: "M0 50 h400000 v40H0z m0 194h40000v40H0z\nM0 50 h400000 v40H0z m0 194h40000v40H0z",
    midbrace: "M200428 334\nc-100.7-8.3-195.3-44-280-108-55.3-42-101.7-93-139-153l-9-14c-2.7 4-5.7 8.7-9 14\n-53.3 86.7-123.7 153-211 199-66.7 36-137.3 56.3-212 62H0V214h199568c178.3-11.7\n 311.7-78.3 403-201 6-8 9.7-12 11-12 .7-.7 6.7-1 18-1s17.3.3 18 1c1.3 0 5 4 11\n 12 44.7 59.3 101.3 106.3 170 141s145.3 54.3 229 60h199572v120z",
    midbraceunder: "M199572 214\nc100.7 8.3 195.3 44 280 108 55.3 42 101.7 93 139 153l9 14c2.7-4 5.7-8.7 9-14\n 53.3-86.7 123.7-153 211-199 66.7-36 137.3-56.3 212-62h199568v120H200432c-178.3\n 11.7-311.7 78.3-403 201-6 8-9.7 12-11 12-.7.7-6.7 1-18 1s-17.3-.3-18-1c-1.3 0\n-5-4-11-12-44.7-59.3-101.3-106.3-170-141s-145.3-54.3-229-60H0V214z",
    oiintSize1: "M512.6 71.6c272.6 0 320.3 106.8 320.3 178.2 0 70.8-47.7 177.6\n-320.3 177.6S193.1 320.6 193.1 249.8c0-71.4 46.9-178.2 319.5-178.2z\nm368.1 178.2c0-86.4-60.9-215.4-368.1-215.4-306.4 0-367.3 129-367.3 215.4 0 85.8\n60.9 214.8 367.3 214.8 307.2 0 368.1-129 368.1-214.8z",
    oiintSize2: "M757.8 100.1c384.7 0 451.1 137.6 451.1 230 0 91.3-66.4 228.8\n-451.1 228.8-386.3 0-452.7-137.5-452.7-228.8 0-92.4 66.4-230 452.7-230z\nm502.4 230c0-111.2-82.4-277.2-502.4-277.2s-504 166-504 277.2\nc0 110 84 276 504 276s502.4-166 502.4-276z",
    oiiintSize1: "M681.4 71.6c408.9 0 480.5 106.8 480.5 178.2 0 70.8-71.6 177.6\n-480.5 177.6S202.1 320.6 202.1 249.8c0-71.4 70.5-178.2 479.3-178.2z\nm525.8 178.2c0-86.4-86.8-215.4-525.7-215.4-437.9 0-524.7 129-524.7 215.4 0\n85.8 86.8 214.8 524.7 214.8 438.9 0 525.7-129 525.7-214.8z",
    oiiintSize2: "M1021.2 53c603.6 0 707.8 165.8 707.8 277.2 0 110-104.2 275.8\n-707.8 275.8-606 0-710.2-165.8-710.2-275.8C311 218.8 415.2 53 1021.2 53z\nm770.4 277.1c0-131.2-126.4-327.6-770.5-327.6S248.4 198.9 248.4 330.1\nc0 130 128.8 326.4 772.7 326.4s770.5-196.4 770.5-326.4z",
    rightarrow: "M0 241v40h399891c-47.3 35.3-84 78-110 128\n-16.7 32-27.7 63.7-33 95 0 1.3-.2 2.7-.5 4-.3 1.3-.5 2.3-.5 3 0 7.3 6.7 11 20\n 11 8 0 13.2-.8 15.5-2.5 2.3-1.7 4.2-5.5 5.5-11.5 2-13.3 5.7-27 11-41 14.7-44.7\n 39-84.5 73-119.5s73.7-60.2 119-75.5c6-2 9-5.7 9-11s-3-9-9-11c-45.3-15.3-85\n-40.5-119-75.5s-58.3-74.8-73-119.5c-4.7-14-8.3-27.3-11-40-1.3-6.7-3.2-10.8-5.5\n-12.5-2.3-1.7-7.5-2.5-15.5-2.5-14 0-21 3.7-21 11 0 2 2 10.3 6 25 20.7 83.3 67\n 151.7 139 205zm0 0v40h399900v-40z",
    rightbrace: "M400000 542l\n-6 6h-17c-12.7 0-19.3-.3-20-1-4-4-7.3-8.3-10-13-35.3-51.3-80.8-93.8-136.5-127.5\ns-117.2-55.8-184.5-66.5c-.7 0-2-.3-4-1-18.7-2.7-76-4.3-172-5H0V214h399571l6 1\nc124.7 8 235 61.7 331 161 31.3 33.3 59.7 72.7 85 118l7 13v35z",
    rightbraceunder: "M399994 0l6 6v35l-6 11c-56 104-135.3 181.3-238 232-57.3\n 28.7-117 45-179 50H-300V214h399897c43.3-7 81-15 113-26 100.7-33 179.7-91 237\n-174 2.7-5 6-9 10-13 .7-1 7.3-1 20-1h17z",
    rightgroup: "M0 80h399565c371 0 266.7 149.4 414 180 5.9 1.2 18 0 18 0 2 0\n 3-1 3-3v-38c-76-158-257-219-435-219H0z",
    rightgroupunder: "M0 262h399565c371 0 266.7-149.4 414-180 5.9-1.2 18 0 18\n 0 2 0 3 1 3 3v38c-76 158-257 219-435 219H0z",
    rightharpoon: "M0 241v40h399993c4.7-4.7 7-9.3 7-14 0-9.3\n-3.7-15.3-11-18-92.7-56.7-159-133.7-199-231-3.3-9.3-6-14.7-8-16-2-1.3-7-2-15-2\n-10.7 0-16.7 2-18 6-2 2.7-1 9.7 3 21 15.3 42 36.7 81.8 64 119.5 27.3 37.7 58\n 69.2 92 94.5zm0 0v40h399900v-40z",
    rightharpoonplus: "M0 241v40h399993c4.7-4.7 7-9.3 7-14 0-9.3-3.7-15.3-11\n-18-92.7-56.7-159-133.7-199-231-3.3-9.3-6-14.7-8-16-2-1.3-7-2-15-2-10.7 0-16.7\n 2-18 6-2 2.7-1 9.7 3 21 15.3 42 36.7 81.8 64 119.5 27.3 37.7 58 69.2 92 94.5z\nm0 0v40h399900v-40z m100 194v40h399900v-40zm0 0v40h399900v-40z",
    rightharpoondown: "M399747 511c0 7.3 6.7 11 20 11 8 0 13-.8 15-2.5s4.7-6.8\n 8-15.5c40-94 99.3-166.3 178-217 13.3-8 20.3-12.3 21-13 5.3-3.3 8.5-5.8 9.5\n-7.5 1-1.7 1.5-5.2 1.5-10.5s-2.3-10.3-7-15H0v40h399908c-34 25.3-64.7 57-92 95\n-27.3 38-48.7 77.7-64 119-3.3 8.7-5 14-5 16zM0 241v40h399900v-40z",
    rightharpoondownplus: "M399747 705c0 7.3 6.7 11 20 11 8 0 13-.8\n 15-2.5s4.7-6.8 8-15.5c40-94 99.3-166.3 178-217 13.3-8 20.3-12.3 21-13 5.3-3.3\n 8.5-5.8 9.5-7.5 1-1.7 1.5-5.2 1.5-10.5s-2.3-10.3-7-15H0v40h399908c-34 25.3\n-64.7 57-92 95-27.3 38-48.7 77.7-64 119-3.3 8.7-5 14-5 16zM0 435v40h399900v-40z\nm0-194v40h400000v-40zm0 0v40h400000v-40z",
    righthook: "M399859 241c-764 0 0 0 0 0 40-3.3 68.7-15.7 86-37 10-12 15-25.3\n 15-40 0-22.7-9.8-40.7-29.5-54-19.7-13.3-43.5-21-71.5-23-17.3-1.3-26-8-26-20 0\n-13.3 8.7-20 26-20 38 0 71 11.2 99 33.5 0 0 7 5.6 21 16.7 14 11.2 21 33.5 21\n 66.8s-14 61.2-42 83.5c-28 22.3-61 33.5-99 33.5L0 241z M0 281v-40h399859v40z",
    rightlinesegment: "M399960 241 V94 h40 V428 h-40 V281 H0 v-40z\nM399960 241 V94 h40 V428 h-40 V281 H0 v-40z",
    rightToFrom: "M400000 167c-70.7-42-118-97.7-142-167h-23c-15.3 0-23 .3-23\n 1 0 1.3 5.3 13.7 16 37 18 35.3 41.3 69 70 101l7 8H0v40h399905l-7 8c-28.7 32\n-52 65.7-70 101-10.7 23.3-16 35.7-16 37 0 .7 7.7 1 23 1h23c24-69.3 71.3-125 142\n-167z M100 147v40h399900v-40zM0 341v40h399900v-40z",
    // twoheadleftarrow is from glyph U+219E in font KaTeX AMS Regular
    twoheadleftarrow: "M0 167c68 40\n 115.7 95.7 143 167h22c15.3 0 23-.3 23-1 0-1.3-5.3-13.7-16-37-18-35.3-41.3-69\n-70-101l-7-8h125l9 7c50.7 39.3 85 86 103 140h46c0-4.7-6.3-18.7-19-42-18-35.3\n-40-67.3-66-96l-9-9h399716v-40H284l9-9c26-28.7 48-60.7 66-96 12.7-23.333 19\n-37.333 19-42h-46c-18 54-52.3 100.7-103 140l-9 7H95l7-8c28.7-32 52-65.7 70-101\n 10.7-23.333 16-35.7 16-37 0-.7-7.7-1-23-1h-22C115.7 71.3 68 127 0 167z",
    twoheadrightarrow: "M400000 167\nc-68-40-115.7-95.7-143-167h-22c-15.3 0-23 .3-23 1 0 1.3 5.3 13.7 16 37 18 35.3\n 41.3 69 70 101l7 8h-125l-9-7c-50.7-39.3-85-86-103-140h-46c0 4.7 6.3 18.7 19 42\n 18 35.3 40 67.3 66 96l9 9H0v40h399716l-9 9c-26 28.7-48 60.7-66 96-12.7 23.333\n-19 37.333-19 42h46c18-54 52.3-100.7 103-140l9-7h125l-7 8c-28.7 32-52 65.7-70\n 101-10.7 23.333-16 35.7-16 37 0 .7 7.7 1 23 1h22c27.3-71.3 75-127 143-167z",
    // tilde1 is a modified version of a glyph from the MnSymbol package
    tilde1: "M200 55.538c-77 0-168 73.953-177 73.953-3 0-7\n-2.175-9-5.437L2 97c-1-2-2-4-2-6 0-4 2-7 5-9l20-12C116 12 171 0 207 0c86 0\n 114 68 191 68 78 0 168-68 177-68 4 0 7 2 9 5l12 19c1 2.175 2 4.35 2 6.525 0\n 4.35-2 7.613-5 9.788l-19 13.05c-92 63.077-116.937 75.308-183 76.128\n-68.267.847-113-73.952-191-73.952z",
    // ditto tilde2, tilde3, & tilde4
    tilde2: "M344 55.266c-142 0-300.638 81.316-311.5 86.418\n-8.01 3.762-22.5 10.91-23.5 5.562L1 120c-1-2-1-3-1-4 0-5 3-9 8-10l18.4-9C160.9\n 31.9 283 0 358 0c148 0 188 122 331 122s314-97 326-97c4 0 8 2 10 7l7 21.114\nc1 2.14 1 3.21 1 4.28 0 5.347-3 9.626-7 10.696l-22.3 12.622C852.6 158.372 751\n 181.476 676 181.476c-149 0-189-126.21-332-126.21z",
    tilde3: "M786 59C457 59 32 175.242 13 175.242c-6 0-10-3.457\n-11-10.37L.15 138c-1-7 3-12 10-13l19.2-6.4C378.4 40.7 634.3 0 804.3 0c337 0\n 411.8 157 746.8 157 328 0 754-112 773-112 5 0 10 3 11 9l1 14.075c1 8.066-.697\n 16.595-6.697 17.492l-21.052 7.31c-367.9 98.146-609.15 122.696-778.15 122.696\n -338 0-409-156.573-744-156.573z",
    tilde4: "M786 58C457 58 32 177.487 13 177.487c-6 0-10-3.345\n-11-10.035L.15 143c-1-7 3-12 10-13l22-6.7C381.2 35 637.15 0 807.15 0c337 0 409\n 177 744 177 328 0 754-127 773-127 5 0 10 3 11 9l1 14.794c1 7.805-3 13.38-9\n 14.495l-20.7 5.574c-366.85 99.79-607.3 139.372-776.3 139.372-338 0-409\n -175.236-744-175.236z",
    // vec is from glyph U+20D7 in font KaTeX Main
    vec: "M377 20c0-5.333 1.833-10 5.5-14S391 0 397 0c4.667 0 8.667 1.667 12 5\n3.333 2.667 6.667 9 10 19 6.667 24.667 20.333 43.667 41 57 7.333 4.667 11\n10.667 11 18 0 6-1 10-3 12s-6.667 5-14 9c-28.667 14.667-53.667 35.667-75 63\n-1.333 1.333-3.167 3.5-5.5 6.5s-4 4.833-5 5.5c-1 .667-2.5 1.333-4.5 2s-4.333 1\n-7 1c-4.667 0-9.167-1.833-13.5-5.5S337 184 337 178c0-12.667 15.667-32.333 47-59\nH213l-171-1c-8.667-6-13-12.333-13-19 0-4.667 4.333-11.333 13-20h359\nc-16-25.333-24-45-24-59z",
    // widehat1 is a modified version of a glyph from the MnSymbol package
    widehat1: "M529 0h5l519 115c5 1 9 5 9 10 0 1-1 2-1 3l-4 22\nc-1 5-5 9-11 9h-2L532 67 19 159h-2c-5 0-9-4-11-9l-5-22c-1-6 2-12 8-13z",
    // ditto widehat2, widehat3, & widehat4
    widehat2: "M1181 0h2l1171 176c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 220h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
    widehat3: "M1181 0h2l1171 236c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 280h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
    widehat4: "M1181 0h2l1171 296c6 0 10 5 10 11l-2 23c-1 6-5 10\n-11 10h-1L1182 67 15 340h-1c-6 0-10-4-11-10l-2-23c-1-6 4-11 10-11z",
    // widecheck paths are all inverted versions of widehat
    widecheck1: "M529,159h5l519,-115c5,-1,9,-5,9,-10c0,-1,-1,-2,-1,-3l-4,-22c-1,\n-5,-5,-9,-11,-9h-2l-512,92l-513,-92h-2c-5,0,-9,4,-11,9l-5,22c-1,6,2,12,8,13z",
    widecheck2: "M1181,220h2l1171,-176c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,153l-1167,-153h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
    widecheck3: "M1181,280h2l1171,-236c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,213l-1167,-213h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
    widecheck4: "M1181,340h2l1171,-296c6,0,10,-5,10,-11l-2,-23c-1,-6,-5,-10,\n-11,-10h-1l-1168,273l-1167,-273h-1c-6,0,-10,4,-11,10l-2,23c-1,6,4,11,10,11z",
    // The next ten paths support reaction arrows from the mhchem package.
    // Arrows for \ce{<-->} are offset from xAxis by 0.22ex, per mhchem in LaTeX
    // baraboveleftarrow is mostly from glyph U+2190 in font KaTeX Main
    baraboveleftarrow: "M400000 620h-399890l3 -3c68.7 -52.7 113.7 -120 135 -202\nc4 -14.7 6 -23 6 -25c0 -7.3 -7 -11 -21 -11c-8 0 -13.2 0.8 -15.5 2.5\nc-2.3 1.7 -4.2 5.8 -5.5 12.5c-1.3 4.7 -2.7 10.3 -4 17c-12 48.7 -34.8 92 -68.5 130\ns-74.2 66.3 -121.5 85c-10 4 -16 7.7 -18 11c0 8.7 6 14.3 18 17c47.3 18.7 87.8 47\n121.5 85s56.5 81.3 68.5 130c0.7 2 1.3 5 2 9s1.2 6.7 1.5 8c0.3 1.3 1 3.3 2 6\ns2.2 4.5 3.5 5.5c1.3 1 3.3 1.8 6 2.5s6 1 10 1c14 0 21 -3.7 21 -11\nc0 -2 -2 -10.3 -6 -25c-20 -79.3 -65 -146.7 -135 -202l-3 -3h399890z\nM100 620v40h399900v-40z M0 241v40h399900v-40zM0 241v40h399900v-40z",
    // rightarrowabovebar is mostly from glyph U+2192, KaTeX Main
    rightarrowabovebar: "M0 241v40h399891c-47.3 35.3-84 78-110 128-16.7 32\n-27.7 63.7-33 95 0 1.3-.2 2.7-.5 4-.3 1.3-.5 2.3-.5 3 0 7.3 6.7 11 20 11 8 0\n13.2-.8 15.5-2.5 2.3-1.7 4.2-5.5 5.5-11.5 2-13.3 5.7-27 11-41 14.7-44.7 39\n-84.5 73-119.5s73.7-60.2 119-75.5c6-2 9-5.7 9-11s-3-9-9-11c-45.3-15.3-85-40.5\n-119-75.5s-58.3-74.8-73-119.5c-4.7-14-8.3-27.3-11-40-1.3-6.7-3.2-10.8-5.5\n-12.5-2.3-1.7-7.5-2.5-15.5-2.5-14 0-21 3.7-21 11 0 2 2 10.3 6 25 20.7 83.3 67\n151.7 139 205zm96 379h399894v40H0zm0 0h399904v40H0z",
    // The short left harpoon has 0.5em (i.e. 500 units) kern on the left end.
    // Ref from mhchem.sty: \rlap{\raisebox{-.22ex}{$\kern0.5em
    baraboveshortleftharpoon: "M507,435c-4,4,-6.3,8.7,-7,14c0,5.3,0.7,9,2,11\nc1.3,2,5.3,5.3,12,10c90.7,54,156,130,196,228c3.3,10.7,6.3,16.3,9,17\nc2,0.7,5,1,9,1c0,0,5,0,5,0c10.7,0,16.7,-2,18,-6c2,-2.7,1,-9.7,-3,-21\nc-32,-87.3,-82.7,-157.7,-152,-211c0,0,-3,-3,-3,-3l399351,0l0,-40\nc-398570,0,-399437,0,-399437,0z M593 435 v40 H399500 v-40z\nM0 281 v-40 H399908 v40z M0 281 v-40 H399908 v40z",
    rightharpoonaboveshortbar: "M0,241 l0,40c399126,0,399993,0,399993,0\nc4.7,-4.7,7,-9.3,7,-14c0,-9.3,-3.7,-15.3,-11,-18c-92.7,-56.7,-159,-133.7,-199,\n-231c-3.3,-9.3,-6,-14.7,-8,-16c-2,-1.3,-7,-2,-15,-2c-10.7,0,-16.7,2,-18,6\nc-2,2.7,-1,9.7,3,21c15.3,42,36.7,81.8,64,119.5c27.3,37.7,58,69.2,92,94.5z\nM0 241 v40 H399908 v-40z M0 475 v-40 H399500 v40z M0 475 v-40 H399500 v40z",
    shortbaraboveleftharpoon: "M7,435c-4,4,-6.3,8.7,-7,14c0,5.3,0.7,9,2,11\nc1.3,2,5.3,5.3,12,10c90.7,54,156,130,196,228c3.3,10.7,6.3,16.3,9,17c2,0.7,5,1,9,\n1c0,0,5,0,5,0c10.7,0,16.7,-2,18,-6c2,-2.7,1,-9.7,-3,-21c-32,-87.3,-82.7,-157.7,\n-152,-211c0,0,-3,-3,-3,-3l399907,0l0,-40c-399126,0,-399993,0,-399993,0z\nM93 435 v40 H400000 v-40z M500 241 v40 H400000 v-40z M500 241 v40 H400000 v-40z",
    shortrightharpoonabovebar: "M53,241l0,40c398570,0,399437,0,399437,0\nc4.7,-4.7,7,-9.3,7,-14c0,-9.3,-3.7,-15.3,-11,-18c-92.7,-56.7,-159,-133.7,-199,\n-231c-3.3,-9.3,-6,-14.7,-8,-16c-2,-1.3,-7,-2,-15,-2c-10.7,0,-16.7,2,-18,6\nc-2,2.7,-1,9.7,3,21c15.3,42,36.7,81.8,64,119.5c27.3,37.7,58,69.2,92,94.5z\nM500 241 v40 H399408 v-40z M500 435 v40 H400000 v-40z"
  };
  var tallDelim = function tallDelim2(label, midHeight) {
    switch (label) {
      case "lbrack":
        return "M403 1759 V84 H666 V0 H319 V1759 v" + midHeight + " v1759 h347 v-84\nH403z M403 1759 V0 H319 V1759 v" + midHeight + " v1759 h84z";
      case "rbrack":
        return "M347 1759 V0 H0 V84 H263 V1759 v" + midHeight + " v1759 H0 v84 H347z\nM347 1759 V0 H263 V1759 v" + midHeight + " v1759 h84z";
      case "vert":
        return "M145 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M188 15 H145 v585 v" + midHeight + " v585 h43z";
      case "doublevert":
        return "M145 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M188 15 H145 v585 v" + midHeight + " v585 h43z\nM367 15 v585 v" + midHeight + " v585 c2.667,10,9.667,15,21,15\nc10,0,16.667,-5,20,-15 v-585 v" + -midHeight + " v-585 c-2.667,-10,-9.667,-15,-21,-15\nc-10,0,-16.667,5,-20,15z M410 15 H367 v585 v" + midHeight + " v585 h43z";
      case "lfloor":
        return "M319 602 V0 H403 V602 v" + midHeight + " v1715 h263 v84 H319z\nMM319 602 V0 H403 V602 v" + midHeight + " v1715 H319z";
      case "rfloor":
        return "M319 602 V0 H403 V602 v" + midHeight + " v1799 H0 v-84 H319z\nMM319 602 V0 H403 V602 v" + midHeight + " v1715 H319z";
      case "lceil":
        return "M403 1759 V84 H666 V0 H319 V1759 v" + midHeight + " v602 h84z\nM403 1759 V0 H319 V1759 v" + midHeight + " v602 h84z";
      case "rceil":
        return "M347 1759 V0 H0 V84 H263 V1759 v" + midHeight + " v602 h84z\nM347 1759 V0 h-84 V1759 v" + midHeight + " v602 h84z";
      case "lparen":
        return "M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1\nc-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,\n-36,557 l0," + (midHeight + 84) + "c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,\n949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9\nc0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,\n-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189\nl0,-" + (midHeight + 92) + "c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,\n-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z";
      case "rparen":
        return "M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,\n63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5\nc11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0," + (midHeight + 9) + "\nc-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664\nc-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11\nc0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17\nc242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558\nl0,-" + (midHeight + 144) + "c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,\n-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z";
      default:
        throw new Error("Unknown stretchy delimiter.");
    }
  };
  class DocumentFragment {
    // HtmlDomNode
    // Never used; needed for satisfying interface.
    constructor(children2) {
      this.children = void 0;
      this.classes = void 0;
      this.height = void 0;
      this.depth = void 0;
      this.maxFontSize = void 0;
      this.style = void 0;
      this.children = children2;
      this.classes = [];
      this.height = 0;
      this.depth = 0;
      this.maxFontSize = 0;
      this.style = {};
    }
    hasClass(className) {
      return utils.contains(this.classes, className);
    }
    /** Convert the fragment into a node. */
    toNode() {
      var frag = document.createDocumentFragment();
      for (var i2 = 0; i2 < this.children.length; i2++) {
        frag.appendChild(this.children[i2].toNode());
      }
      return frag;
    }
    /** Convert the fragment into HTML markup. */
    toMarkup() {
      var markup = "";
      for (var i2 = 0; i2 < this.children.length; i2++) {
        markup += this.children[i2].toMarkup();
      }
      return markup;
    }
    /**
     * Converts the math node into a string, similar to innerText. Applies to
     * MathDomNode's only.
     */
    toText() {
      var toText = (child) => child.toText();
      return this.children.map(toText).join("");
    }
  }
  var fontMetricsData = {
    "AMS-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "65": [0, 0.68889, 0, 0, 0.72222],
      "66": [0, 0.68889, 0, 0, 0.66667],
      "67": [0, 0.68889, 0, 0, 0.72222],
      "68": [0, 0.68889, 0, 0, 0.72222],
      "69": [0, 0.68889, 0, 0, 0.66667],
      "70": [0, 0.68889, 0, 0, 0.61111],
      "71": [0, 0.68889, 0, 0, 0.77778],
      "72": [0, 0.68889, 0, 0, 0.77778],
      "73": [0, 0.68889, 0, 0, 0.38889],
      "74": [0.16667, 0.68889, 0, 0, 0.5],
      "75": [0, 0.68889, 0, 0, 0.77778],
      "76": [0, 0.68889, 0, 0, 0.66667],
      "77": [0, 0.68889, 0, 0, 0.94445],
      "78": [0, 0.68889, 0, 0, 0.72222],
      "79": [0.16667, 0.68889, 0, 0, 0.77778],
      "80": [0, 0.68889, 0, 0, 0.61111],
      "81": [0.16667, 0.68889, 0, 0, 0.77778],
      "82": [0, 0.68889, 0, 0, 0.72222],
      "83": [0, 0.68889, 0, 0, 0.55556],
      "84": [0, 0.68889, 0, 0, 0.66667],
      "85": [0, 0.68889, 0, 0, 0.72222],
      "86": [0, 0.68889, 0, 0, 0.72222],
      "87": [0, 0.68889, 0, 0, 1],
      "88": [0, 0.68889, 0, 0, 0.72222],
      "89": [0, 0.68889, 0, 0, 0.72222],
      "90": [0, 0.68889, 0, 0, 0.66667],
      "107": [0, 0.68889, 0, 0, 0.55556],
      "160": [0, 0, 0, 0, 0.25],
      "165": [0, 0.675, 0.025, 0, 0.75],
      "174": [0.15559, 0.69224, 0, 0, 0.94666],
      "240": [0, 0.68889, 0, 0, 0.55556],
      "295": [0, 0.68889, 0, 0, 0.54028],
      "710": [0, 0.825, 0, 0, 2.33334],
      "732": [0, 0.9, 0, 0, 2.33334],
      "770": [0, 0.825, 0, 0, 2.33334],
      "771": [0, 0.9, 0, 0, 2.33334],
      "989": [0.08167, 0.58167, 0, 0, 0.77778],
      "1008": [0, 0.43056, 0.04028, 0, 0.66667],
      "8245": [0, 0.54986, 0, 0, 0.275],
      "8463": [0, 0.68889, 0, 0, 0.54028],
      "8487": [0, 0.68889, 0, 0, 0.72222],
      "8498": [0, 0.68889, 0, 0, 0.55556],
      "8502": [0, 0.68889, 0, 0, 0.66667],
      "8503": [0, 0.68889, 0, 0, 0.44445],
      "8504": [0, 0.68889, 0, 0, 0.66667],
      "8513": [0, 0.68889, 0, 0, 0.63889],
      "8592": [-0.03598, 0.46402, 0, 0, 0.5],
      "8594": [-0.03598, 0.46402, 0, 0, 0.5],
      "8602": [-0.13313, 0.36687, 0, 0, 1],
      "8603": [-0.13313, 0.36687, 0, 0, 1],
      "8606": [0.01354, 0.52239, 0, 0, 1],
      "8608": [0.01354, 0.52239, 0, 0, 1],
      "8610": [0.01354, 0.52239, 0, 0, 1.11111],
      "8611": [0.01354, 0.52239, 0, 0, 1.11111],
      "8619": [0, 0.54986, 0, 0, 1],
      "8620": [0, 0.54986, 0, 0, 1],
      "8621": [-0.13313, 0.37788, 0, 0, 1.38889],
      "8622": [-0.13313, 0.36687, 0, 0, 1],
      "8624": [0, 0.69224, 0, 0, 0.5],
      "8625": [0, 0.69224, 0, 0, 0.5],
      "8630": [0, 0.43056, 0, 0, 1],
      "8631": [0, 0.43056, 0, 0, 1],
      "8634": [0.08198, 0.58198, 0, 0, 0.77778],
      "8635": [0.08198, 0.58198, 0, 0, 0.77778],
      "8638": [0.19444, 0.69224, 0, 0, 0.41667],
      "8639": [0.19444, 0.69224, 0, 0, 0.41667],
      "8642": [0.19444, 0.69224, 0, 0, 0.41667],
      "8643": [0.19444, 0.69224, 0, 0, 0.41667],
      "8644": [0.1808, 0.675, 0, 0, 1],
      "8646": [0.1808, 0.675, 0, 0, 1],
      "8647": [0.1808, 0.675, 0, 0, 1],
      "8648": [0.19444, 0.69224, 0, 0, 0.83334],
      "8649": [0.1808, 0.675, 0, 0, 1],
      "8650": [0.19444, 0.69224, 0, 0, 0.83334],
      "8651": [0.01354, 0.52239, 0, 0, 1],
      "8652": [0.01354, 0.52239, 0, 0, 1],
      "8653": [-0.13313, 0.36687, 0, 0, 1],
      "8654": [-0.13313, 0.36687, 0, 0, 1],
      "8655": [-0.13313, 0.36687, 0, 0, 1],
      "8666": [0.13667, 0.63667, 0, 0, 1],
      "8667": [0.13667, 0.63667, 0, 0, 1],
      "8669": [-0.13313, 0.37788, 0, 0, 1],
      "8672": [-0.064, 0.437, 0, 0, 1.334],
      "8674": [-0.064, 0.437, 0, 0, 1.334],
      "8705": [0, 0.825, 0, 0, 0.5],
      "8708": [0, 0.68889, 0, 0, 0.55556],
      "8709": [0.08167, 0.58167, 0, 0, 0.77778],
      "8717": [0, 0.43056, 0, 0, 0.42917],
      "8722": [-0.03598, 0.46402, 0, 0, 0.5],
      "8724": [0.08198, 0.69224, 0, 0, 0.77778],
      "8726": [0.08167, 0.58167, 0, 0, 0.77778],
      "8733": [0, 0.69224, 0, 0, 0.77778],
      "8736": [0, 0.69224, 0, 0, 0.72222],
      "8737": [0, 0.69224, 0, 0, 0.72222],
      "8738": [0.03517, 0.52239, 0, 0, 0.72222],
      "8739": [0.08167, 0.58167, 0, 0, 0.22222],
      "8740": [0.25142, 0.74111, 0, 0, 0.27778],
      "8741": [0.08167, 0.58167, 0, 0, 0.38889],
      "8742": [0.25142, 0.74111, 0, 0, 0.5],
      "8756": [0, 0.69224, 0, 0, 0.66667],
      "8757": [0, 0.69224, 0, 0, 0.66667],
      "8764": [-0.13313, 0.36687, 0, 0, 0.77778],
      "8765": [-0.13313, 0.37788, 0, 0, 0.77778],
      "8769": [-0.13313, 0.36687, 0, 0, 0.77778],
      "8770": [-0.03625, 0.46375, 0, 0, 0.77778],
      "8774": [0.30274, 0.79383, 0, 0, 0.77778],
      "8776": [-0.01688, 0.48312, 0, 0, 0.77778],
      "8778": [0.08167, 0.58167, 0, 0, 0.77778],
      "8782": [0.06062, 0.54986, 0, 0, 0.77778],
      "8783": [0.06062, 0.54986, 0, 0, 0.77778],
      "8785": [0.08198, 0.58198, 0, 0, 0.77778],
      "8786": [0.08198, 0.58198, 0, 0, 0.77778],
      "8787": [0.08198, 0.58198, 0, 0, 0.77778],
      "8790": [0, 0.69224, 0, 0, 0.77778],
      "8791": [0.22958, 0.72958, 0, 0, 0.77778],
      "8796": [0.08198, 0.91667, 0, 0, 0.77778],
      "8806": [0.25583, 0.75583, 0, 0, 0.77778],
      "8807": [0.25583, 0.75583, 0, 0, 0.77778],
      "8808": [0.25142, 0.75726, 0, 0, 0.77778],
      "8809": [0.25142, 0.75726, 0, 0, 0.77778],
      "8812": [0.25583, 0.75583, 0, 0, 0.5],
      "8814": [0.20576, 0.70576, 0, 0, 0.77778],
      "8815": [0.20576, 0.70576, 0, 0, 0.77778],
      "8816": [0.30274, 0.79383, 0, 0, 0.77778],
      "8817": [0.30274, 0.79383, 0, 0, 0.77778],
      "8818": [0.22958, 0.72958, 0, 0, 0.77778],
      "8819": [0.22958, 0.72958, 0, 0, 0.77778],
      "8822": [0.1808, 0.675, 0, 0, 0.77778],
      "8823": [0.1808, 0.675, 0, 0, 0.77778],
      "8828": [0.13667, 0.63667, 0, 0, 0.77778],
      "8829": [0.13667, 0.63667, 0, 0, 0.77778],
      "8830": [0.22958, 0.72958, 0, 0, 0.77778],
      "8831": [0.22958, 0.72958, 0, 0, 0.77778],
      "8832": [0.20576, 0.70576, 0, 0, 0.77778],
      "8833": [0.20576, 0.70576, 0, 0, 0.77778],
      "8840": [0.30274, 0.79383, 0, 0, 0.77778],
      "8841": [0.30274, 0.79383, 0, 0, 0.77778],
      "8842": [0.13597, 0.63597, 0, 0, 0.77778],
      "8843": [0.13597, 0.63597, 0, 0, 0.77778],
      "8847": [0.03517, 0.54986, 0, 0, 0.77778],
      "8848": [0.03517, 0.54986, 0, 0, 0.77778],
      "8858": [0.08198, 0.58198, 0, 0, 0.77778],
      "8859": [0.08198, 0.58198, 0, 0, 0.77778],
      "8861": [0.08198, 0.58198, 0, 0, 0.77778],
      "8862": [0, 0.675, 0, 0, 0.77778],
      "8863": [0, 0.675, 0, 0, 0.77778],
      "8864": [0, 0.675, 0, 0, 0.77778],
      "8865": [0, 0.675, 0, 0, 0.77778],
      "8872": [0, 0.69224, 0, 0, 0.61111],
      "8873": [0, 0.69224, 0, 0, 0.72222],
      "8874": [0, 0.69224, 0, 0, 0.88889],
      "8876": [0, 0.68889, 0, 0, 0.61111],
      "8877": [0, 0.68889, 0, 0, 0.61111],
      "8878": [0, 0.68889, 0, 0, 0.72222],
      "8879": [0, 0.68889, 0, 0, 0.72222],
      "8882": [0.03517, 0.54986, 0, 0, 0.77778],
      "8883": [0.03517, 0.54986, 0, 0, 0.77778],
      "8884": [0.13667, 0.63667, 0, 0, 0.77778],
      "8885": [0.13667, 0.63667, 0, 0, 0.77778],
      "8888": [0, 0.54986, 0, 0, 1.11111],
      "8890": [0.19444, 0.43056, 0, 0, 0.55556],
      "8891": [0.19444, 0.69224, 0, 0, 0.61111],
      "8892": [0.19444, 0.69224, 0, 0, 0.61111],
      "8901": [0, 0.54986, 0, 0, 0.27778],
      "8903": [0.08167, 0.58167, 0, 0, 0.77778],
      "8905": [0.08167, 0.58167, 0, 0, 0.77778],
      "8906": [0.08167, 0.58167, 0, 0, 0.77778],
      "8907": [0, 0.69224, 0, 0, 0.77778],
      "8908": [0, 0.69224, 0, 0, 0.77778],
      "8909": [-0.03598, 0.46402, 0, 0, 0.77778],
      "8910": [0, 0.54986, 0, 0, 0.76042],
      "8911": [0, 0.54986, 0, 0, 0.76042],
      "8912": [0.03517, 0.54986, 0, 0, 0.77778],
      "8913": [0.03517, 0.54986, 0, 0, 0.77778],
      "8914": [0, 0.54986, 0, 0, 0.66667],
      "8915": [0, 0.54986, 0, 0, 0.66667],
      "8916": [0, 0.69224, 0, 0, 0.66667],
      "8918": [0.0391, 0.5391, 0, 0, 0.77778],
      "8919": [0.0391, 0.5391, 0, 0, 0.77778],
      "8920": [0.03517, 0.54986, 0, 0, 1.33334],
      "8921": [0.03517, 0.54986, 0, 0, 1.33334],
      "8922": [0.38569, 0.88569, 0, 0, 0.77778],
      "8923": [0.38569, 0.88569, 0, 0, 0.77778],
      "8926": [0.13667, 0.63667, 0, 0, 0.77778],
      "8927": [0.13667, 0.63667, 0, 0, 0.77778],
      "8928": [0.30274, 0.79383, 0, 0, 0.77778],
      "8929": [0.30274, 0.79383, 0, 0, 0.77778],
      "8934": [0.23222, 0.74111, 0, 0, 0.77778],
      "8935": [0.23222, 0.74111, 0, 0, 0.77778],
      "8936": [0.23222, 0.74111, 0, 0, 0.77778],
      "8937": [0.23222, 0.74111, 0, 0, 0.77778],
      "8938": [0.20576, 0.70576, 0, 0, 0.77778],
      "8939": [0.20576, 0.70576, 0, 0, 0.77778],
      "8940": [0.30274, 0.79383, 0, 0, 0.77778],
      "8941": [0.30274, 0.79383, 0, 0, 0.77778],
      "8994": [0.19444, 0.69224, 0, 0, 0.77778],
      "8995": [0.19444, 0.69224, 0, 0, 0.77778],
      "9416": [0.15559, 0.69224, 0, 0, 0.90222],
      "9484": [0, 0.69224, 0, 0, 0.5],
      "9488": [0, 0.69224, 0, 0, 0.5],
      "9492": [0, 0.37788, 0, 0, 0.5],
      "9496": [0, 0.37788, 0, 0, 0.5],
      "9585": [0.19444, 0.68889, 0, 0, 0.88889],
      "9586": [0.19444, 0.74111, 0, 0, 0.88889],
      "9632": [0, 0.675, 0, 0, 0.77778],
      "9633": [0, 0.675, 0, 0, 0.77778],
      "9650": [0, 0.54986, 0, 0, 0.72222],
      "9651": [0, 0.54986, 0, 0, 0.72222],
      "9654": [0.03517, 0.54986, 0, 0, 0.77778],
      "9660": [0, 0.54986, 0, 0, 0.72222],
      "9661": [0, 0.54986, 0, 0, 0.72222],
      "9664": [0.03517, 0.54986, 0, 0, 0.77778],
      "9674": [0.11111, 0.69224, 0, 0, 0.66667],
      "9733": [0.19444, 0.69224, 0, 0, 0.94445],
      "10003": [0, 0.69224, 0, 0, 0.83334],
      "10016": [0, 0.69224, 0, 0, 0.83334],
      "10731": [0.11111, 0.69224, 0, 0, 0.66667],
      "10846": [0.19444, 0.75583, 0, 0, 0.61111],
      "10877": [0.13667, 0.63667, 0, 0, 0.77778],
      "10878": [0.13667, 0.63667, 0, 0, 0.77778],
      "10885": [0.25583, 0.75583, 0, 0, 0.77778],
      "10886": [0.25583, 0.75583, 0, 0, 0.77778],
      "10887": [0.13597, 0.63597, 0, 0, 0.77778],
      "10888": [0.13597, 0.63597, 0, 0, 0.77778],
      "10889": [0.26167, 0.75726, 0, 0, 0.77778],
      "10890": [0.26167, 0.75726, 0, 0, 0.77778],
      "10891": [0.48256, 0.98256, 0, 0, 0.77778],
      "10892": [0.48256, 0.98256, 0, 0, 0.77778],
      "10901": [0.13667, 0.63667, 0, 0, 0.77778],
      "10902": [0.13667, 0.63667, 0, 0, 0.77778],
      "10933": [0.25142, 0.75726, 0, 0, 0.77778],
      "10934": [0.25142, 0.75726, 0, 0, 0.77778],
      "10935": [0.26167, 0.75726, 0, 0, 0.77778],
      "10936": [0.26167, 0.75726, 0, 0, 0.77778],
      "10937": [0.26167, 0.75726, 0, 0, 0.77778],
      "10938": [0.26167, 0.75726, 0, 0, 0.77778],
      "10949": [0.25583, 0.75583, 0, 0, 0.77778],
      "10950": [0.25583, 0.75583, 0, 0, 0.77778],
      "10955": [0.28481, 0.79383, 0, 0, 0.77778],
      "10956": [0.28481, 0.79383, 0, 0, 0.77778],
      "57350": [0.08167, 0.58167, 0, 0, 0.22222],
      "57351": [0.08167, 0.58167, 0, 0, 0.38889],
      "57352": [0.08167, 0.58167, 0, 0, 0.77778],
      "57353": [0, 0.43056, 0.04028, 0, 0.66667],
      "57356": [0.25142, 0.75726, 0, 0, 0.77778],
      "57357": [0.25142, 0.75726, 0, 0, 0.77778],
      "57358": [0.41951, 0.91951, 0, 0, 0.77778],
      "57359": [0.30274, 0.79383, 0, 0, 0.77778],
      "57360": [0.30274, 0.79383, 0, 0, 0.77778],
      "57361": [0.41951, 0.91951, 0, 0, 0.77778],
      "57366": [0.25142, 0.75726, 0, 0, 0.77778],
      "57367": [0.25142, 0.75726, 0, 0, 0.77778],
      "57368": [0.25142, 0.75726, 0, 0, 0.77778],
      "57369": [0.25142, 0.75726, 0, 0, 0.77778],
      "57370": [0.13597, 0.63597, 0, 0, 0.77778],
      "57371": [0.13597, 0.63597, 0, 0, 0.77778]
    },
    "Caligraphic-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "65": [0, 0.68333, 0, 0.19445, 0.79847],
      "66": [0, 0.68333, 0.03041, 0.13889, 0.65681],
      "67": [0, 0.68333, 0.05834, 0.13889, 0.52653],
      "68": [0, 0.68333, 0.02778, 0.08334, 0.77139],
      "69": [0, 0.68333, 0.08944, 0.11111, 0.52778],
      "70": [0, 0.68333, 0.09931, 0.11111, 0.71875],
      "71": [0.09722, 0.68333, 0.0593, 0.11111, 0.59487],
      "72": [0, 0.68333, 965e-5, 0.11111, 0.84452],
      "73": [0, 0.68333, 0.07382, 0, 0.54452],
      "74": [0.09722, 0.68333, 0.18472, 0.16667, 0.67778],
      "75": [0, 0.68333, 0.01445, 0.05556, 0.76195],
      "76": [0, 0.68333, 0, 0.13889, 0.68972],
      "77": [0, 0.68333, 0, 0.13889, 1.2009],
      "78": [0, 0.68333, 0.14736, 0.08334, 0.82049],
      "79": [0, 0.68333, 0.02778, 0.11111, 0.79611],
      "80": [0, 0.68333, 0.08222, 0.08334, 0.69556],
      "81": [0.09722, 0.68333, 0, 0.11111, 0.81667],
      "82": [0, 0.68333, 0, 0.08334, 0.8475],
      "83": [0, 0.68333, 0.075, 0.13889, 0.60556],
      "84": [0, 0.68333, 0.25417, 0, 0.54464],
      "85": [0, 0.68333, 0.09931, 0.08334, 0.62583],
      "86": [0, 0.68333, 0.08222, 0, 0.61278],
      "87": [0, 0.68333, 0.08222, 0.08334, 0.98778],
      "88": [0, 0.68333, 0.14643, 0.13889, 0.7133],
      "89": [0.09722, 0.68333, 0.08222, 0.08334, 0.66834],
      "90": [0, 0.68333, 0.07944, 0.13889, 0.72473],
      "160": [0, 0, 0, 0, 0.25]
    },
    "Fraktur-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69141, 0, 0, 0.29574],
      "34": [0, 0.69141, 0, 0, 0.21471],
      "38": [0, 0.69141, 0, 0, 0.73786],
      "39": [0, 0.69141, 0, 0, 0.21201],
      "40": [0.24982, 0.74947, 0, 0, 0.38865],
      "41": [0.24982, 0.74947, 0, 0, 0.38865],
      "42": [0, 0.62119, 0, 0, 0.27764],
      "43": [0.08319, 0.58283, 0, 0, 0.75623],
      "44": [0, 0.10803, 0, 0, 0.27764],
      "45": [0.08319, 0.58283, 0, 0, 0.75623],
      "46": [0, 0.10803, 0, 0, 0.27764],
      "47": [0.24982, 0.74947, 0, 0, 0.50181],
      "48": [0, 0.47534, 0, 0, 0.50181],
      "49": [0, 0.47534, 0, 0, 0.50181],
      "50": [0, 0.47534, 0, 0, 0.50181],
      "51": [0.18906, 0.47534, 0, 0, 0.50181],
      "52": [0.18906, 0.47534, 0, 0, 0.50181],
      "53": [0.18906, 0.47534, 0, 0, 0.50181],
      "54": [0, 0.69141, 0, 0, 0.50181],
      "55": [0.18906, 0.47534, 0, 0, 0.50181],
      "56": [0, 0.69141, 0, 0, 0.50181],
      "57": [0.18906, 0.47534, 0, 0, 0.50181],
      "58": [0, 0.47534, 0, 0, 0.21606],
      "59": [0.12604, 0.47534, 0, 0, 0.21606],
      "61": [-0.13099, 0.36866, 0, 0, 0.75623],
      "63": [0, 0.69141, 0, 0, 0.36245],
      "65": [0, 0.69141, 0, 0, 0.7176],
      "66": [0, 0.69141, 0, 0, 0.88397],
      "67": [0, 0.69141, 0, 0, 0.61254],
      "68": [0, 0.69141, 0, 0, 0.83158],
      "69": [0, 0.69141, 0, 0, 0.66278],
      "70": [0.12604, 0.69141, 0, 0, 0.61119],
      "71": [0, 0.69141, 0, 0, 0.78539],
      "72": [0.06302, 0.69141, 0, 0, 0.7203],
      "73": [0, 0.69141, 0, 0, 0.55448],
      "74": [0.12604, 0.69141, 0, 0, 0.55231],
      "75": [0, 0.69141, 0, 0, 0.66845],
      "76": [0, 0.69141, 0, 0, 0.66602],
      "77": [0, 0.69141, 0, 0, 1.04953],
      "78": [0, 0.69141, 0, 0, 0.83212],
      "79": [0, 0.69141, 0, 0, 0.82699],
      "80": [0.18906, 0.69141, 0, 0, 0.82753],
      "81": [0.03781, 0.69141, 0, 0, 0.82699],
      "82": [0, 0.69141, 0, 0, 0.82807],
      "83": [0, 0.69141, 0, 0, 0.82861],
      "84": [0, 0.69141, 0, 0, 0.66899],
      "85": [0, 0.69141, 0, 0, 0.64576],
      "86": [0, 0.69141, 0, 0, 0.83131],
      "87": [0, 0.69141, 0, 0, 1.04602],
      "88": [0, 0.69141, 0, 0, 0.71922],
      "89": [0.18906, 0.69141, 0, 0, 0.83293],
      "90": [0.12604, 0.69141, 0, 0, 0.60201],
      "91": [0.24982, 0.74947, 0, 0, 0.27764],
      "93": [0.24982, 0.74947, 0, 0, 0.27764],
      "94": [0, 0.69141, 0, 0, 0.49965],
      "97": [0, 0.47534, 0, 0, 0.50046],
      "98": [0, 0.69141, 0, 0, 0.51315],
      "99": [0, 0.47534, 0, 0, 0.38946],
      "100": [0, 0.62119, 0, 0, 0.49857],
      "101": [0, 0.47534, 0, 0, 0.40053],
      "102": [0.18906, 0.69141, 0, 0, 0.32626],
      "103": [0.18906, 0.47534, 0, 0, 0.5037],
      "104": [0.18906, 0.69141, 0, 0, 0.52126],
      "105": [0, 0.69141, 0, 0, 0.27899],
      "106": [0, 0.69141, 0, 0, 0.28088],
      "107": [0, 0.69141, 0, 0, 0.38946],
      "108": [0, 0.69141, 0, 0, 0.27953],
      "109": [0, 0.47534, 0, 0, 0.76676],
      "110": [0, 0.47534, 0, 0, 0.52666],
      "111": [0, 0.47534, 0, 0, 0.48885],
      "112": [0.18906, 0.52396, 0, 0, 0.50046],
      "113": [0.18906, 0.47534, 0, 0, 0.48912],
      "114": [0, 0.47534, 0, 0, 0.38919],
      "115": [0, 0.47534, 0, 0, 0.44266],
      "116": [0, 0.62119, 0, 0, 0.33301],
      "117": [0, 0.47534, 0, 0, 0.5172],
      "118": [0, 0.52396, 0, 0, 0.5118],
      "119": [0, 0.52396, 0, 0, 0.77351],
      "120": [0.18906, 0.47534, 0, 0, 0.38865],
      "121": [0.18906, 0.47534, 0, 0, 0.49884],
      "122": [0.18906, 0.47534, 0, 0, 0.39054],
      "160": [0, 0, 0, 0, 0.25],
      "8216": [0, 0.69141, 0, 0, 0.21471],
      "8217": [0, 0.69141, 0, 0, 0.21471],
      "58112": [0, 0.62119, 0, 0, 0.49749],
      "58113": [0, 0.62119, 0, 0, 0.4983],
      "58114": [0.18906, 0.69141, 0, 0, 0.33328],
      "58115": [0.18906, 0.69141, 0, 0, 0.32923],
      "58116": [0.18906, 0.47534, 0, 0, 0.50343],
      "58117": [0, 0.69141, 0, 0, 0.33301],
      "58118": [0, 0.62119, 0, 0, 0.33409],
      "58119": [0, 0.47534, 0, 0, 0.50073]
    },
    "Main-Bold": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0, 0, 0.35],
      "34": [0, 0.69444, 0, 0, 0.60278],
      "35": [0.19444, 0.69444, 0, 0, 0.95833],
      "36": [0.05556, 0.75, 0, 0, 0.575],
      "37": [0.05556, 0.75, 0, 0, 0.95833],
      "38": [0, 0.69444, 0, 0, 0.89444],
      "39": [0, 0.69444, 0, 0, 0.31944],
      "40": [0.25, 0.75, 0, 0, 0.44722],
      "41": [0.25, 0.75, 0, 0, 0.44722],
      "42": [0, 0.75, 0, 0, 0.575],
      "43": [0.13333, 0.63333, 0, 0, 0.89444],
      "44": [0.19444, 0.15556, 0, 0, 0.31944],
      "45": [0, 0.44444, 0, 0, 0.38333],
      "46": [0, 0.15556, 0, 0, 0.31944],
      "47": [0.25, 0.75, 0, 0, 0.575],
      "48": [0, 0.64444, 0, 0, 0.575],
      "49": [0, 0.64444, 0, 0, 0.575],
      "50": [0, 0.64444, 0, 0, 0.575],
      "51": [0, 0.64444, 0, 0, 0.575],
      "52": [0, 0.64444, 0, 0, 0.575],
      "53": [0, 0.64444, 0, 0, 0.575],
      "54": [0, 0.64444, 0, 0, 0.575],
      "55": [0, 0.64444, 0, 0, 0.575],
      "56": [0, 0.64444, 0, 0, 0.575],
      "57": [0, 0.64444, 0, 0, 0.575],
      "58": [0, 0.44444, 0, 0, 0.31944],
      "59": [0.19444, 0.44444, 0, 0, 0.31944],
      "60": [0.08556, 0.58556, 0, 0, 0.89444],
      "61": [-0.10889, 0.39111, 0, 0, 0.89444],
      "62": [0.08556, 0.58556, 0, 0, 0.89444],
      "63": [0, 0.69444, 0, 0, 0.54305],
      "64": [0, 0.69444, 0, 0, 0.89444],
      "65": [0, 0.68611, 0, 0, 0.86944],
      "66": [0, 0.68611, 0, 0, 0.81805],
      "67": [0, 0.68611, 0, 0, 0.83055],
      "68": [0, 0.68611, 0, 0, 0.88194],
      "69": [0, 0.68611, 0, 0, 0.75555],
      "70": [0, 0.68611, 0, 0, 0.72361],
      "71": [0, 0.68611, 0, 0, 0.90416],
      "72": [0, 0.68611, 0, 0, 0.9],
      "73": [0, 0.68611, 0, 0, 0.43611],
      "74": [0, 0.68611, 0, 0, 0.59444],
      "75": [0, 0.68611, 0, 0, 0.90138],
      "76": [0, 0.68611, 0, 0, 0.69166],
      "77": [0, 0.68611, 0, 0, 1.09166],
      "78": [0, 0.68611, 0, 0, 0.9],
      "79": [0, 0.68611, 0, 0, 0.86388],
      "80": [0, 0.68611, 0, 0, 0.78611],
      "81": [0.19444, 0.68611, 0, 0, 0.86388],
      "82": [0, 0.68611, 0, 0, 0.8625],
      "83": [0, 0.68611, 0, 0, 0.63889],
      "84": [0, 0.68611, 0, 0, 0.8],
      "85": [0, 0.68611, 0, 0, 0.88472],
      "86": [0, 0.68611, 0.01597, 0, 0.86944],
      "87": [0, 0.68611, 0.01597, 0, 1.18888],
      "88": [0, 0.68611, 0, 0, 0.86944],
      "89": [0, 0.68611, 0.02875, 0, 0.86944],
      "90": [0, 0.68611, 0, 0, 0.70277],
      "91": [0.25, 0.75, 0, 0, 0.31944],
      "92": [0.25, 0.75, 0, 0, 0.575],
      "93": [0.25, 0.75, 0, 0, 0.31944],
      "94": [0, 0.69444, 0, 0, 0.575],
      "95": [0.31, 0.13444, 0.03194, 0, 0.575],
      "97": [0, 0.44444, 0, 0, 0.55902],
      "98": [0, 0.69444, 0, 0, 0.63889],
      "99": [0, 0.44444, 0, 0, 0.51111],
      "100": [0, 0.69444, 0, 0, 0.63889],
      "101": [0, 0.44444, 0, 0, 0.52708],
      "102": [0, 0.69444, 0.10903, 0, 0.35139],
      "103": [0.19444, 0.44444, 0.01597, 0, 0.575],
      "104": [0, 0.69444, 0, 0, 0.63889],
      "105": [0, 0.69444, 0, 0, 0.31944],
      "106": [0.19444, 0.69444, 0, 0, 0.35139],
      "107": [0, 0.69444, 0, 0, 0.60694],
      "108": [0, 0.69444, 0, 0, 0.31944],
      "109": [0, 0.44444, 0, 0, 0.95833],
      "110": [0, 0.44444, 0, 0, 0.63889],
      "111": [0, 0.44444, 0, 0, 0.575],
      "112": [0.19444, 0.44444, 0, 0, 0.63889],
      "113": [0.19444, 0.44444, 0, 0, 0.60694],
      "114": [0, 0.44444, 0, 0, 0.47361],
      "115": [0, 0.44444, 0, 0, 0.45361],
      "116": [0, 0.63492, 0, 0, 0.44722],
      "117": [0, 0.44444, 0, 0, 0.63889],
      "118": [0, 0.44444, 0.01597, 0, 0.60694],
      "119": [0, 0.44444, 0.01597, 0, 0.83055],
      "120": [0, 0.44444, 0, 0, 0.60694],
      "121": [0.19444, 0.44444, 0.01597, 0, 0.60694],
      "122": [0, 0.44444, 0, 0, 0.51111],
      "123": [0.25, 0.75, 0, 0, 0.575],
      "124": [0.25, 0.75, 0, 0, 0.31944],
      "125": [0.25, 0.75, 0, 0, 0.575],
      "126": [0.35, 0.34444, 0, 0, 0.575],
      "160": [0, 0, 0, 0, 0.25],
      "163": [0, 0.69444, 0, 0, 0.86853],
      "168": [0, 0.69444, 0, 0, 0.575],
      "172": [0, 0.44444, 0, 0, 0.76666],
      "176": [0, 0.69444, 0, 0, 0.86944],
      "177": [0.13333, 0.63333, 0, 0, 0.89444],
      "184": [0.17014, 0, 0, 0, 0.51111],
      "198": [0, 0.68611, 0, 0, 1.04166],
      "215": [0.13333, 0.63333, 0, 0, 0.89444],
      "216": [0.04861, 0.73472, 0, 0, 0.89444],
      "223": [0, 0.69444, 0, 0, 0.59722],
      "230": [0, 0.44444, 0, 0, 0.83055],
      "247": [0.13333, 0.63333, 0, 0, 0.89444],
      "248": [0.09722, 0.54167, 0, 0, 0.575],
      "305": [0, 0.44444, 0, 0, 0.31944],
      "338": [0, 0.68611, 0, 0, 1.16944],
      "339": [0, 0.44444, 0, 0, 0.89444],
      "567": [0.19444, 0.44444, 0, 0, 0.35139],
      "710": [0, 0.69444, 0, 0, 0.575],
      "711": [0, 0.63194, 0, 0, 0.575],
      "713": [0, 0.59611, 0, 0, 0.575],
      "714": [0, 0.69444, 0, 0, 0.575],
      "715": [0, 0.69444, 0, 0, 0.575],
      "728": [0, 0.69444, 0, 0, 0.575],
      "729": [0, 0.69444, 0, 0, 0.31944],
      "730": [0, 0.69444, 0, 0, 0.86944],
      "732": [0, 0.69444, 0, 0, 0.575],
      "733": [0, 0.69444, 0, 0, 0.575],
      "915": [0, 0.68611, 0, 0, 0.69166],
      "916": [0, 0.68611, 0, 0, 0.95833],
      "920": [0, 0.68611, 0, 0, 0.89444],
      "923": [0, 0.68611, 0, 0, 0.80555],
      "926": [0, 0.68611, 0, 0, 0.76666],
      "928": [0, 0.68611, 0, 0, 0.9],
      "931": [0, 0.68611, 0, 0, 0.83055],
      "933": [0, 0.68611, 0, 0, 0.89444],
      "934": [0, 0.68611, 0, 0, 0.83055],
      "936": [0, 0.68611, 0, 0, 0.89444],
      "937": [0, 0.68611, 0, 0, 0.83055],
      "8211": [0, 0.44444, 0.03194, 0, 0.575],
      "8212": [0, 0.44444, 0.03194, 0, 1.14999],
      "8216": [0, 0.69444, 0, 0, 0.31944],
      "8217": [0, 0.69444, 0, 0, 0.31944],
      "8220": [0, 0.69444, 0, 0, 0.60278],
      "8221": [0, 0.69444, 0, 0, 0.60278],
      "8224": [0.19444, 0.69444, 0, 0, 0.51111],
      "8225": [0.19444, 0.69444, 0, 0, 0.51111],
      "8242": [0, 0.55556, 0, 0, 0.34444],
      "8407": [0, 0.72444, 0.15486, 0, 0.575],
      "8463": [0, 0.69444, 0, 0, 0.66759],
      "8465": [0, 0.69444, 0, 0, 0.83055],
      "8467": [0, 0.69444, 0, 0, 0.47361],
      "8472": [0.19444, 0.44444, 0, 0, 0.74027],
      "8476": [0, 0.69444, 0, 0, 0.83055],
      "8501": [0, 0.69444, 0, 0, 0.70277],
      "8592": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8593": [0.19444, 0.69444, 0, 0, 0.575],
      "8594": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8595": [0.19444, 0.69444, 0, 0, 0.575],
      "8596": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8597": [0.25, 0.75, 0, 0, 0.575],
      "8598": [0.19444, 0.69444, 0, 0, 1.14999],
      "8599": [0.19444, 0.69444, 0, 0, 1.14999],
      "8600": [0.19444, 0.69444, 0, 0, 1.14999],
      "8601": [0.19444, 0.69444, 0, 0, 1.14999],
      "8636": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8637": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8640": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8641": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8656": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8657": [0.19444, 0.69444, 0, 0, 0.70277],
      "8658": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8659": [0.19444, 0.69444, 0, 0, 0.70277],
      "8660": [-0.10889, 0.39111, 0, 0, 1.14999],
      "8661": [0.25, 0.75, 0, 0, 0.70277],
      "8704": [0, 0.69444, 0, 0, 0.63889],
      "8706": [0, 0.69444, 0.06389, 0, 0.62847],
      "8707": [0, 0.69444, 0, 0, 0.63889],
      "8709": [0.05556, 0.75, 0, 0, 0.575],
      "8711": [0, 0.68611, 0, 0, 0.95833],
      "8712": [0.08556, 0.58556, 0, 0, 0.76666],
      "8715": [0.08556, 0.58556, 0, 0, 0.76666],
      "8722": [0.13333, 0.63333, 0, 0, 0.89444],
      "8723": [0.13333, 0.63333, 0, 0, 0.89444],
      "8725": [0.25, 0.75, 0, 0, 0.575],
      "8726": [0.25, 0.75, 0, 0, 0.575],
      "8727": [-0.02778, 0.47222, 0, 0, 0.575],
      "8728": [-0.02639, 0.47361, 0, 0, 0.575],
      "8729": [-0.02639, 0.47361, 0, 0, 0.575],
      "8730": [0.18, 0.82, 0, 0, 0.95833],
      "8733": [0, 0.44444, 0, 0, 0.89444],
      "8734": [0, 0.44444, 0, 0, 1.14999],
      "8736": [0, 0.69224, 0, 0, 0.72222],
      "8739": [0.25, 0.75, 0, 0, 0.31944],
      "8741": [0.25, 0.75, 0, 0, 0.575],
      "8743": [0, 0.55556, 0, 0, 0.76666],
      "8744": [0, 0.55556, 0, 0, 0.76666],
      "8745": [0, 0.55556, 0, 0, 0.76666],
      "8746": [0, 0.55556, 0, 0, 0.76666],
      "8747": [0.19444, 0.69444, 0.12778, 0, 0.56875],
      "8764": [-0.10889, 0.39111, 0, 0, 0.89444],
      "8768": [0.19444, 0.69444, 0, 0, 0.31944],
      "8771": [222e-5, 0.50222, 0, 0, 0.89444],
      "8773": [0.027, 0.638, 0, 0, 0.894],
      "8776": [0.02444, 0.52444, 0, 0, 0.89444],
      "8781": [222e-5, 0.50222, 0, 0, 0.89444],
      "8801": [222e-5, 0.50222, 0, 0, 0.89444],
      "8804": [0.19667, 0.69667, 0, 0, 0.89444],
      "8805": [0.19667, 0.69667, 0, 0, 0.89444],
      "8810": [0.08556, 0.58556, 0, 0, 1.14999],
      "8811": [0.08556, 0.58556, 0, 0, 1.14999],
      "8826": [0.08556, 0.58556, 0, 0, 0.89444],
      "8827": [0.08556, 0.58556, 0, 0, 0.89444],
      "8834": [0.08556, 0.58556, 0, 0, 0.89444],
      "8835": [0.08556, 0.58556, 0, 0, 0.89444],
      "8838": [0.19667, 0.69667, 0, 0, 0.89444],
      "8839": [0.19667, 0.69667, 0, 0, 0.89444],
      "8846": [0, 0.55556, 0, 0, 0.76666],
      "8849": [0.19667, 0.69667, 0, 0, 0.89444],
      "8850": [0.19667, 0.69667, 0, 0, 0.89444],
      "8851": [0, 0.55556, 0, 0, 0.76666],
      "8852": [0, 0.55556, 0, 0, 0.76666],
      "8853": [0.13333, 0.63333, 0, 0, 0.89444],
      "8854": [0.13333, 0.63333, 0, 0, 0.89444],
      "8855": [0.13333, 0.63333, 0, 0, 0.89444],
      "8856": [0.13333, 0.63333, 0, 0, 0.89444],
      "8857": [0.13333, 0.63333, 0, 0, 0.89444],
      "8866": [0, 0.69444, 0, 0, 0.70277],
      "8867": [0, 0.69444, 0, 0, 0.70277],
      "8868": [0, 0.69444, 0, 0, 0.89444],
      "8869": [0, 0.69444, 0, 0, 0.89444],
      "8900": [-0.02639, 0.47361, 0, 0, 0.575],
      "8901": [-0.02639, 0.47361, 0, 0, 0.31944],
      "8902": [-0.02778, 0.47222, 0, 0, 0.575],
      "8968": [0.25, 0.75, 0, 0, 0.51111],
      "8969": [0.25, 0.75, 0, 0, 0.51111],
      "8970": [0.25, 0.75, 0, 0, 0.51111],
      "8971": [0.25, 0.75, 0, 0, 0.51111],
      "8994": [-0.13889, 0.36111, 0, 0, 1.14999],
      "8995": [-0.13889, 0.36111, 0, 0, 1.14999],
      "9651": [0.19444, 0.69444, 0, 0, 1.02222],
      "9657": [-0.02778, 0.47222, 0, 0, 0.575],
      "9661": [0.19444, 0.69444, 0, 0, 1.02222],
      "9667": [-0.02778, 0.47222, 0, 0, 0.575],
      "9711": [0.19444, 0.69444, 0, 0, 1.14999],
      "9824": [0.12963, 0.69444, 0, 0, 0.89444],
      "9825": [0.12963, 0.69444, 0, 0, 0.89444],
      "9826": [0.12963, 0.69444, 0, 0, 0.89444],
      "9827": [0.12963, 0.69444, 0, 0, 0.89444],
      "9837": [0, 0.75, 0, 0, 0.44722],
      "9838": [0.19444, 0.69444, 0, 0, 0.44722],
      "9839": [0.19444, 0.69444, 0, 0, 0.44722],
      "10216": [0.25, 0.75, 0, 0, 0.44722],
      "10217": [0.25, 0.75, 0, 0, 0.44722],
      "10815": [0, 0.68611, 0, 0, 0.9],
      "10927": [0.19667, 0.69667, 0, 0, 0.89444],
      "10928": [0.19667, 0.69667, 0, 0, 0.89444],
      "57376": [0.19444, 0.69444, 0, 0, 0]
    },
    "Main-BoldItalic": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0.11417, 0, 0.38611],
      "34": [0, 0.69444, 0.07939, 0, 0.62055],
      "35": [0.19444, 0.69444, 0.06833, 0, 0.94444],
      "37": [0.05556, 0.75, 0.12861, 0, 0.94444],
      "38": [0, 0.69444, 0.08528, 0, 0.88555],
      "39": [0, 0.69444, 0.12945, 0, 0.35555],
      "40": [0.25, 0.75, 0.15806, 0, 0.47333],
      "41": [0.25, 0.75, 0.03306, 0, 0.47333],
      "42": [0, 0.75, 0.14333, 0, 0.59111],
      "43": [0.10333, 0.60333, 0.03306, 0, 0.88555],
      "44": [0.19444, 0.14722, 0, 0, 0.35555],
      "45": [0, 0.44444, 0.02611, 0, 0.41444],
      "46": [0, 0.14722, 0, 0, 0.35555],
      "47": [0.25, 0.75, 0.15806, 0, 0.59111],
      "48": [0, 0.64444, 0.13167, 0, 0.59111],
      "49": [0, 0.64444, 0.13167, 0, 0.59111],
      "50": [0, 0.64444, 0.13167, 0, 0.59111],
      "51": [0, 0.64444, 0.13167, 0, 0.59111],
      "52": [0.19444, 0.64444, 0.13167, 0, 0.59111],
      "53": [0, 0.64444, 0.13167, 0, 0.59111],
      "54": [0, 0.64444, 0.13167, 0, 0.59111],
      "55": [0.19444, 0.64444, 0.13167, 0, 0.59111],
      "56": [0, 0.64444, 0.13167, 0, 0.59111],
      "57": [0, 0.64444, 0.13167, 0, 0.59111],
      "58": [0, 0.44444, 0.06695, 0, 0.35555],
      "59": [0.19444, 0.44444, 0.06695, 0, 0.35555],
      "61": [-0.10889, 0.39111, 0.06833, 0, 0.88555],
      "63": [0, 0.69444, 0.11472, 0, 0.59111],
      "64": [0, 0.69444, 0.09208, 0, 0.88555],
      "65": [0, 0.68611, 0, 0, 0.86555],
      "66": [0, 0.68611, 0.0992, 0, 0.81666],
      "67": [0, 0.68611, 0.14208, 0, 0.82666],
      "68": [0, 0.68611, 0.09062, 0, 0.87555],
      "69": [0, 0.68611, 0.11431, 0, 0.75666],
      "70": [0, 0.68611, 0.12903, 0, 0.72722],
      "71": [0, 0.68611, 0.07347, 0, 0.89527],
      "72": [0, 0.68611, 0.17208, 0, 0.8961],
      "73": [0, 0.68611, 0.15681, 0, 0.47166],
      "74": [0, 0.68611, 0.145, 0, 0.61055],
      "75": [0, 0.68611, 0.14208, 0, 0.89499],
      "76": [0, 0.68611, 0, 0, 0.69777],
      "77": [0, 0.68611, 0.17208, 0, 1.07277],
      "78": [0, 0.68611, 0.17208, 0, 0.8961],
      "79": [0, 0.68611, 0.09062, 0, 0.85499],
      "80": [0, 0.68611, 0.0992, 0, 0.78721],
      "81": [0.19444, 0.68611, 0.09062, 0, 0.85499],
      "82": [0, 0.68611, 0.02559, 0, 0.85944],
      "83": [0, 0.68611, 0.11264, 0, 0.64999],
      "84": [0, 0.68611, 0.12903, 0, 0.7961],
      "85": [0, 0.68611, 0.17208, 0, 0.88083],
      "86": [0, 0.68611, 0.18625, 0, 0.86555],
      "87": [0, 0.68611, 0.18625, 0, 1.15999],
      "88": [0, 0.68611, 0.15681, 0, 0.86555],
      "89": [0, 0.68611, 0.19803, 0, 0.86555],
      "90": [0, 0.68611, 0.14208, 0, 0.70888],
      "91": [0.25, 0.75, 0.1875, 0, 0.35611],
      "93": [0.25, 0.75, 0.09972, 0, 0.35611],
      "94": [0, 0.69444, 0.06709, 0, 0.59111],
      "95": [0.31, 0.13444, 0.09811, 0, 0.59111],
      "97": [0, 0.44444, 0.09426, 0, 0.59111],
      "98": [0, 0.69444, 0.07861, 0, 0.53222],
      "99": [0, 0.44444, 0.05222, 0, 0.53222],
      "100": [0, 0.69444, 0.10861, 0, 0.59111],
      "101": [0, 0.44444, 0.085, 0, 0.53222],
      "102": [0.19444, 0.69444, 0.21778, 0, 0.4],
      "103": [0.19444, 0.44444, 0.105, 0, 0.53222],
      "104": [0, 0.69444, 0.09426, 0, 0.59111],
      "105": [0, 0.69326, 0.11387, 0, 0.35555],
      "106": [0.19444, 0.69326, 0.1672, 0, 0.35555],
      "107": [0, 0.69444, 0.11111, 0, 0.53222],
      "108": [0, 0.69444, 0.10861, 0, 0.29666],
      "109": [0, 0.44444, 0.09426, 0, 0.94444],
      "110": [0, 0.44444, 0.09426, 0, 0.64999],
      "111": [0, 0.44444, 0.07861, 0, 0.59111],
      "112": [0.19444, 0.44444, 0.07861, 0, 0.59111],
      "113": [0.19444, 0.44444, 0.105, 0, 0.53222],
      "114": [0, 0.44444, 0.11111, 0, 0.50167],
      "115": [0, 0.44444, 0.08167, 0, 0.48694],
      "116": [0, 0.63492, 0.09639, 0, 0.385],
      "117": [0, 0.44444, 0.09426, 0, 0.62055],
      "118": [0, 0.44444, 0.11111, 0, 0.53222],
      "119": [0, 0.44444, 0.11111, 0, 0.76777],
      "120": [0, 0.44444, 0.12583, 0, 0.56055],
      "121": [0.19444, 0.44444, 0.105, 0, 0.56166],
      "122": [0, 0.44444, 0.13889, 0, 0.49055],
      "126": [0.35, 0.34444, 0.11472, 0, 0.59111],
      "160": [0, 0, 0, 0, 0.25],
      "168": [0, 0.69444, 0.11473, 0, 0.59111],
      "176": [0, 0.69444, 0, 0, 0.94888],
      "184": [0.17014, 0, 0, 0, 0.53222],
      "198": [0, 0.68611, 0.11431, 0, 1.02277],
      "216": [0.04861, 0.73472, 0.09062, 0, 0.88555],
      "223": [0.19444, 0.69444, 0.09736, 0, 0.665],
      "230": [0, 0.44444, 0.085, 0, 0.82666],
      "248": [0.09722, 0.54167, 0.09458, 0, 0.59111],
      "305": [0, 0.44444, 0.09426, 0, 0.35555],
      "338": [0, 0.68611, 0.11431, 0, 1.14054],
      "339": [0, 0.44444, 0.085, 0, 0.82666],
      "567": [0.19444, 0.44444, 0.04611, 0, 0.385],
      "710": [0, 0.69444, 0.06709, 0, 0.59111],
      "711": [0, 0.63194, 0.08271, 0, 0.59111],
      "713": [0, 0.59444, 0.10444, 0, 0.59111],
      "714": [0, 0.69444, 0.08528, 0, 0.59111],
      "715": [0, 0.69444, 0, 0, 0.59111],
      "728": [0, 0.69444, 0.10333, 0, 0.59111],
      "729": [0, 0.69444, 0.12945, 0, 0.35555],
      "730": [0, 0.69444, 0, 0, 0.94888],
      "732": [0, 0.69444, 0.11472, 0, 0.59111],
      "733": [0, 0.69444, 0.11472, 0, 0.59111],
      "915": [0, 0.68611, 0.12903, 0, 0.69777],
      "916": [0, 0.68611, 0, 0, 0.94444],
      "920": [0, 0.68611, 0.09062, 0, 0.88555],
      "923": [0, 0.68611, 0, 0, 0.80666],
      "926": [0, 0.68611, 0.15092, 0, 0.76777],
      "928": [0, 0.68611, 0.17208, 0, 0.8961],
      "931": [0, 0.68611, 0.11431, 0, 0.82666],
      "933": [0, 0.68611, 0.10778, 0, 0.88555],
      "934": [0, 0.68611, 0.05632, 0, 0.82666],
      "936": [0, 0.68611, 0.10778, 0, 0.88555],
      "937": [0, 0.68611, 0.0992, 0, 0.82666],
      "8211": [0, 0.44444, 0.09811, 0, 0.59111],
      "8212": [0, 0.44444, 0.09811, 0, 1.18221],
      "8216": [0, 0.69444, 0.12945, 0, 0.35555],
      "8217": [0, 0.69444, 0.12945, 0, 0.35555],
      "8220": [0, 0.69444, 0.16772, 0, 0.62055],
      "8221": [0, 0.69444, 0.07939, 0, 0.62055]
    },
    "Main-Italic": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0.12417, 0, 0.30667],
      "34": [0, 0.69444, 0.06961, 0, 0.51444],
      "35": [0.19444, 0.69444, 0.06616, 0, 0.81777],
      "37": [0.05556, 0.75, 0.13639, 0, 0.81777],
      "38": [0, 0.69444, 0.09694, 0, 0.76666],
      "39": [0, 0.69444, 0.12417, 0, 0.30667],
      "40": [0.25, 0.75, 0.16194, 0, 0.40889],
      "41": [0.25, 0.75, 0.03694, 0, 0.40889],
      "42": [0, 0.75, 0.14917, 0, 0.51111],
      "43": [0.05667, 0.56167, 0.03694, 0, 0.76666],
      "44": [0.19444, 0.10556, 0, 0, 0.30667],
      "45": [0, 0.43056, 0.02826, 0, 0.35778],
      "46": [0, 0.10556, 0, 0, 0.30667],
      "47": [0.25, 0.75, 0.16194, 0, 0.51111],
      "48": [0, 0.64444, 0.13556, 0, 0.51111],
      "49": [0, 0.64444, 0.13556, 0, 0.51111],
      "50": [0, 0.64444, 0.13556, 0, 0.51111],
      "51": [0, 0.64444, 0.13556, 0, 0.51111],
      "52": [0.19444, 0.64444, 0.13556, 0, 0.51111],
      "53": [0, 0.64444, 0.13556, 0, 0.51111],
      "54": [0, 0.64444, 0.13556, 0, 0.51111],
      "55": [0.19444, 0.64444, 0.13556, 0, 0.51111],
      "56": [0, 0.64444, 0.13556, 0, 0.51111],
      "57": [0, 0.64444, 0.13556, 0, 0.51111],
      "58": [0, 0.43056, 0.0582, 0, 0.30667],
      "59": [0.19444, 0.43056, 0.0582, 0, 0.30667],
      "61": [-0.13313, 0.36687, 0.06616, 0, 0.76666],
      "63": [0, 0.69444, 0.1225, 0, 0.51111],
      "64": [0, 0.69444, 0.09597, 0, 0.76666],
      "65": [0, 0.68333, 0, 0, 0.74333],
      "66": [0, 0.68333, 0.10257, 0, 0.70389],
      "67": [0, 0.68333, 0.14528, 0, 0.71555],
      "68": [0, 0.68333, 0.09403, 0, 0.755],
      "69": [0, 0.68333, 0.12028, 0, 0.67833],
      "70": [0, 0.68333, 0.13305, 0, 0.65277],
      "71": [0, 0.68333, 0.08722, 0, 0.77361],
      "72": [0, 0.68333, 0.16389, 0, 0.74333],
      "73": [0, 0.68333, 0.15806, 0, 0.38555],
      "74": [0, 0.68333, 0.14028, 0, 0.525],
      "75": [0, 0.68333, 0.14528, 0, 0.76888],
      "76": [0, 0.68333, 0, 0, 0.62722],
      "77": [0, 0.68333, 0.16389, 0, 0.89666],
      "78": [0, 0.68333, 0.16389, 0, 0.74333],
      "79": [0, 0.68333, 0.09403, 0, 0.76666],
      "80": [0, 0.68333, 0.10257, 0, 0.67833],
      "81": [0.19444, 0.68333, 0.09403, 0, 0.76666],
      "82": [0, 0.68333, 0.03868, 0, 0.72944],
      "83": [0, 0.68333, 0.11972, 0, 0.56222],
      "84": [0, 0.68333, 0.13305, 0, 0.71555],
      "85": [0, 0.68333, 0.16389, 0, 0.74333],
      "86": [0, 0.68333, 0.18361, 0, 0.74333],
      "87": [0, 0.68333, 0.18361, 0, 0.99888],
      "88": [0, 0.68333, 0.15806, 0, 0.74333],
      "89": [0, 0.68333, 0.19383, 0, 0.74333],
      "90": [0, 0.68333, 0.14528, 0, 0.61333],
      "91": [0.25, 0.75, 0.1875, 0, 0.30667],
      "93": [0.25, 0.75, 0.10528, 0, 0.30667],
      "94": [0, 0.69444, 0.06646, 0, 0.51111],
      "95": [0.31, 0.12056, 0.09208, 0, 0.51111],
      "97": [0, 0.43056, 0.07671, 0, 0.51111],
      "98": [0, 0.69444, 0.06312, 0, 0.46],
      "99": [0, 0.43056, 0.05653, 0, 0.46],
      "100": [0, 0.69444, 0.10333, 0, 0.51111],
      "101": [0, 0.43056, 0.07514, 0, 0.46],
      "102": [0.19444, 0.69444, 0.21194, 0, 0.30667],
      "103": [0.19444, 0.43056, 0.08847, 0, 0.46],
      "104": [0, 0.69444, 0.07671, 0, 0.51111],
      "105": [0, 0.65536, 0.1019, 0, 0.30667],
      "106": [0.19444, 0.65536, 0.14467, 0, 0.30667],
      "107": [0, 0.69444, 0.10764, 0, 0.46],
      "108": [0, 0.69444, 0.10333, 0, 0.25555],
      "109": [0, 0.43056, 0.07671, 0, 0.81777],
      "110": [0, 0.43056, 0.07671, 0, 0.56222],
      "111": [0, 0.43056, 0.06312, 0, 0.51111],
      "112": [0.19444, 0.43056, 0.06312, 0, 0.51111],
      "113": [0.19444, 0.43056, 0.08847, 0, 0.46],
      "114": [0, 0.43056, 0.10764, 0, 0.42166],
      "115": [0, 0.43056, 0.08208, 0, 0.40889],
      "116": [0, 0.61508, 0.09486, 0, 0.33222],
      "117": [0, 0.43056, 0.07671, 0, 0.53666],
      "118": [0, 0.43056, 0.10764, 0, 0.46],
      "119": [0, 0.43056, 0.10764, 0, 0.66444],
      "120": [0, 0.43056, 0.12042, 0, 0.46389],
      "121": [0.19444, 0.43056, 0.08847, 0, 0.48555],
      "122": [0, 0.43056, 0.12292, 0, 0.40889],
      "126": [0.35, 0.31786, 0.11585, 0, 0.51111],
      "160": [0, 0, 0, 0, 0.25],
      "168": [0, 0.66786, 0.10474, 0, 0.51111],
      "176": [0, 0.69444, 0, 0, 0.83129],
      "184": [0.17014, 0, 0, 0, 0.46],
      "198": [0, 0.68333, 0.12028, 0, 0.88277],
      "216": [0.04861, 0.73194, 0.09403, 0, 0.76666],
      "223": [0.19444, 0.69444, 0.10514, 0, 0.53666],
      "230": [0, 0.43056, 0.07514, 0, 0.71555],
      "248": [0.09722, 0.52778, 0.09194, 0, 0.51111],
      "338": [0, 0.68333, 0.12028, 0, 0.98499],
      "339": [0, 0.43056, 0.07514, 0, 0.71555],
      "710": [0, 0.69444, 0.06646, 0, 0.51111],
      "711": [0, 0.62847, 0.08295, 0, 0.51111],
      "713": [0, 0.56167, 0.10333, 0, 0.51111],
      "714": [0, 0.69444, 0.09694, 0, 0.51111],
      "715": [0, 0.69444, 0, 0, 0.51111],
      "728": [0, 0.69444, 0.10806, 0, 0.51111],
      "729": [0, 0.66786, 0.11752, 0, 0.30667],
      "730": [0, 0.69444, 0, 0, 0.83129],
      "732": [0, 0.66786, 0.11585, 0, 0.51111],
      "733": [0, 0.69444, 0.1225, 0, 0.51111],
      "915": [0, 0.68333, 0.13305, 0, 0.62722],
      "916": [0, 0.68333, 0, 0, 0.81777],
      "920": [0, 0.68333, 0.09403, 0, 0.76666],
      "923": [0, 0.68333, 0, 0, 0.69222],
      "926": [0, 0.68333, 0.15294, 0, 0.66444],
      "928": [0, 0.68333, 0.16389, 0, 0.74333],
      "931": [0, 0.68333, 0.12028, 0, 0.71555],
      "933": [0, 0.68333, 0.11111, 0, 0.76666],
      "934": [0, 0.68333, 0.05986, 0, 0.71555],
      "936": [0, 0.68333, 0.11111, 0, 0.76666],
      "937": [0, 0.68333, 0.10257, 0, 0.71555],
      "8211": [0, 0.43056, 0.09208, 0, 0.51111],
      "8212": [0, 0.43056, 0.09208, 0, 1.02222],
      "8216": [0, 0.69444, 0.12417, 0, 0.30667],
      "8217": [0, 0.69444, 0.12417, 0, 0.30667],
      "8220": [0, 0.69444, 0.1685, 0, 0.51444],
      "8221": [0, 0.69444, 0.06961, 0, 0.51444],
      "8463": [0, 0.68889, 0, 0, 0.54028]
    },
    "Main-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0, 0, 0.27778],
      "34": [0, 0.69444, 0, 0, 0.5],
      "35": [0.19444, 0.69444, 0, 0, 0.83334],
      "36": [0.05556, 0.75, 0, 0, 0.5],
      "37": [0.05556, 0.75, 0, 0, 0.83334],
      "38": [0, 0.69444, 0, 0, 0.77778],
      "39": [0, 0.69444, 0, 0, 0.27778],
      "40": [0.25, 0.75, 0, 0, 0.38889],
      "41": [0.25, 0.75, 0, 0, 0.38889],
      "42": [0, 0.75, 0, 0, 0.5],
      "43": [0.08333, 0.58333, 0, 0, 0.77778],
      "44": [0.19444, 0.10556, 0, 0, 0.27778],
      "45": [0, 0.43056, 0, 0, 0.33333],
      "46": [0, 0.10556, 0, 0, 0.27778],
      "47": [0.25, 0.75, 0, 0, 0.5],
      "48": [0, 0.64444, 0, 0, 0.5],
      "49": [0, 0.64444, 0, 0, 0.5],
      "50": [0, 0.64444, 0, 0, 0.5],
      "51": [0, 0.64444, 0, 0, 0.5],
      "52": [0, 0.64444, 0, 0, 0.5],
      "53": [0, 0.64444, 0, 0, 0.5],
      "54": [0, 0.64444, 0, 0, 0.5],
      "55": [0, 0.64444, 0, 0, 0.5],
      "56": [0, 0.64444, 0, 0, 0.5],
      "57": [0, 0.64444, 0, 0, 0.5],
      "58": [0, 0.43056, 0, 0, 0.27778],
      "59": [0.19444, 0.43056, 0, 0, 0.27778],
      "60": [0.0391, 0.5391, 0, 0, 0.77778],
      "61": [-0.13313, 0.36687, 0, 0, 0.77778],
      "62": [0.0391, 0.5391, 0, 0, 0.77778],
      "63": [0, 0.69444, 0, 0, 0.47222],
      "64": [0, 0.69444, 0, 0, 0.77778],
      "65": [0, 0.68333, 0, 0, 0.75],
      "66": [0, 0.68333, 0, 0, 0.70834],
      "67": [0, 0.68333, 0, 0, 0.72222],
      "68": [0, 0.68333, 0, 0, 0.76389],
      "69": [0, 0.68333, 0, 0, 0.68056],
      "70": [0, 0.68333, 0, 0, 0.65278],
      "71": [0, 0.68333, 0, 0, 0.78472],
      "72": [0, 0.68333, 0, 0, 0.75],
      "73": [0, 0.68333, 0, 0, 0.36111],
      "74": [0, 0.68333, 0, 0, 0.51389],
      "75": [0, 0.68333, 0, 0, 0.77778],
      "76": [0, 0.68333, 0, 0, 0.625],
      "77": [0, 0.68333, 0, 0, 0.91667],
      "78": [0, 0.68333, 0, 0, 0.75],
      "79": [0, 0.68333, 0, 0, 0.77778],
      "80": [0, 0.68333, 0, 0, 0.68056],
      "81": [0.19444, 0.68333, 0, 0, 0.77778],
      "82": [0, 0.68333, 0, 0, 0.73611],
      "83": [0, 0.68333, 0, 0, 0.55556],
      "84": [0, 0.68333, 0, 0, 0.72222],
      "85": [0, 0.68333, 0, 0, 0.75],
      "86": [0, 0.68333, 0.01389, 0, 0.75],
      "87": [0, 0.68333, 0.01389, 0, 1.02778],
      "88": [0, 0.68333, 0, 0, 0.75],
      "89": [0, 0.68333, 0.025, 0, 0.75],
      "90": [0, 0.68333, 0, 0, 0.61111],
      "91": [0.25, 0.75, 0, 0, 0.27778],
      "92": [0.25, 0.75, 0, 0, 0.5],
      "93": [0.25, 0.75, 0, 0, 0.27778],
      "94": [0, 0.69444, 0, 0, 0.5],
      "95": [0.31, 0.12056, 0.02778, 0, 0.5],
      "97": [0, 0.43056, 0, 0, 0.5],
      "98": [0, 0.69444, 0, 0, 0.55556],
      "99": [0, 0.43056, 0, 0, 0.44445],
      "100": [0, 0.69444, 0, 0, 0.55556],
      "101": [0, 0.43056, 0, 0, 0.44445],
      "102": [0, 0.69444, 0.07778, 0, 0.30556],
      "103": [0.19444, 0.43056, 0.01389, 0, 0.5],
      "104": [0, 0.69444, 0, 0, 0.55556],
      "105": [0, 0.66786, 0, 0, 0.27778],
      "106": [0.19444, 0.66786, 0, 0, 0.30556],
      "107": [0, 0.69444, 0, 0, 0.52778],
      "108": [0, 0.69444, 0, 0, 0.27778],
      "109": [0, 0.43056, 0, 0, 0.83334],
      "110": [0, 0.43056, 0, 0, 0.55556],
      "111": [0, 0.43056, 0, 0, 0.5],
      "112": [0.19444, 0.43056, 0, 0, 0.55556],
      "113": [0.19444, 0.43056, 0, 0, 0.52778],
      "114": [0, 0.43056, 0, 0, 0.39167],
      "115": [0, 0.43056, 0, 0, 0.39445],
      "116": [0, 0.61508, 0, 0, 0.38889],
      "117": [0, 0.43056, 0, 0, 0.55556],
      "118": [0, 0.43056, 0.01389, 0, 0.52778],
      "119": [0, 0.43056, 0.01389, 0, 0.72222],
      "120": [0, 0.43056, 0, 0, 0.52778],
      "121": [0.19444, 0.43056, 0.01389, 0, 0.52778],
      "122": [0, 0.43056, 0, 0, 0.44445],
      "123": [0.25, 0.75, 0, 0, 0.5],
      "124": [0.25, 0.75, 0, 0, 0.27778],
      "125": [0.25, 0.75, 0, 0, 0.5],
      "126": [0.35, 0.31786, 0, 0, 0.5],
      "160": [0, 0, 0, 0, 0.25],
      "163": [0, 0.69444, 0, 0, 0.76909],
      "167": [0.19444, 0.69444, 0, 0, 0.44445],
      "168": [0, 0.66786, 0, 0, 0.5],
      "172": [0, 0.43056, 0, 0, 0.66667],
      "176": [0, 0.69444, 0, 0, 0.75],
      "177": [0.08333, 0.58333, 0, 0, 0.77778],
      "182": [0.19444, 0.69444, 0, 0, 0.61111],
      "184": [0.17014, 0, 0, 0, 0.44445],
      "198": [0, 0.68333, 0, 0, 0.90278],
      "215": [0.08333, 0.58333, 0, 0, 0.77778],
      "216": [0.04861, 0.73194, 0, 0, 0.77778],
      "223": [0, 0.69444, 0, 0, 0.5],
      "230": [0, 0.43056, 0, 0, 0.72222],
      "247": [0.08333, 0.58333, 0, 0, 0.77778],
      "248": [0.09722, 0.52778, 0, 0, 0.5],
      "305": [0, 0.43056, 0, 0, 0.27778],
      "338": [0, 0.68333, 0, 0, 1.01389],
      "339": [0, 0.43056, 0, 0, 0.77778],
      "567": [0.19444, 0.43056, 0, 0, 0.30556],
      "710": [0, 0.69444, 0, 0, 0.5],
      "711": [0, 0.62847, 0, 0, 0.5],
      "713": [0, 0.56778, 0, 0, 0.5],
      "714": [0, 0.69444, 0, 0, 0.5],
      "715": [0, 0.69444, 0, 0, 0.5],
      "728": [0, 0.69444, 0, 0, 0.5],
      "729": [0, 0.66786, 0, 0, 0.27778],
      "730": [0, 0.69444, 0, 0, 0.75],
      "732": [0, 0.66786, 0, 0, 0.5],
      "733": [0, 0.69444, 0, 0, 0.5],
      "915": [0, 0.68333, 0, 0, 0.625],
      "916": [0, 0.68333, 0, 0, 0.83334],
      "920": [0, 0.68333, 0, 0, 0.77778],
      "923": [0, 0.68333, 0, 0, 0.69445],
      "926": [0, 0.68333, 0, 0, 0.66667],
      "928": [0, 0.68333, 0, 0, 0.75],
      "931": [0, 0.68333, 0, 0, 0.72222],
      "933": [0, 0.68333, 0, 0, 0.77778],
      "934": [0, 0.68333, 0, 0, 0.72222],
      "936": [0, 0.68333, 0, 0, 0.77778],
      "937": [0, 0.68333, 0, 0, 0.72222],
      "8211": [0, 0.43056, 0.02778, 0, 0.5],
      "8212": [0, 0.43056, 0.02778, 0, 1],
      "8216": [0, 0.69444, 0, 0, 0.27778],
      "8217": [0, 0.69444, 0, 0, 0.27778],
      "8220": [0, 0.69444, 0, 0, 0.5],
      "8221": [0, 0.69444, 0, 0, 0.5],
      "8224": [0.19444, 0.69444, 0, 0, 0.44445],
      "8225": [0.19444, 0.69444, 0, 0, 0.44445],
      "8230": [0, 0.123, 0, 0, 1.172],
      "8242": [0, 0.55556, 0, 0, 0.275],
      "8407": [0, 0.71444, 0.15382, 0, 0.5],
      "8463": [0, 0.68889, 0, 0, 0.54028],
      "8465": [0, 0.69444, 0, 0, 0.72222],
      "8467": [0, 0.69444, 0, 0.11111, 0.41667],
      "8472": [0.19444, 0.43056, 0, 0.11111, 0.63646],
      "8476": [0, 0.69444, 0, 0, 0.72222],
      "8501": [0, 0.69444, 0, 0, 0.61111],
      "8592": [-0.13313, 0.36687, 0, 0, 1],
      "8593": [0.19444, 0.69444, 0, 0, 0.5],
      "8594": [-0.13313, 0.36687, 0, 0, 1],
      "8595": [0.19444, 0.69444, 0, 0, 0.5],
      "8596": [-0.13313, 0.36687, 0, 0, 1],
      "8597": [0.25, 0.75, 0, 0, 0.5],
      "8598": [0.19444, 0.69444, 0, 0, 1],
      "8599": [0.19444, 0.69444, 0, 0, 1],
      "8600": [0.19444, 0.69444, 0, 0, 1],
      "8601": [0.19444, 0.69444, 0, 0, 1],
      "8614": [0.011, 0.511, 0, 0, 1],
      "8617": [0.011, 0.511, 0, 0, 1.126],
      "8618": [0.011, 0.511, 0, 0, 1.126],
      "8636": [-0.13313, 0.36687, 0, 0, 1],
      "8637": [-0.13313, 0.36687, 0, 0, 1],
      "8640": [-0.13313, 0.36687, 0, 0, 1],
      "8641": [-0.13313, 0.36687, 0, 0, 1],
      "8652": [0.011, 0.671, 0, 0, 1],
      "8656": [-0.13313, 0.36687, 0, 0, 1],
      "8657": [0.19444, 0.69444, 0, 0, 0.61111],
      "8658": [-0.13313, 0.36687, 0, 0, 1],
      "8659": [0.19444, 0.69444, 0, 0, 0.61111],
      "8660": [-0.13313, 0.36687, 0, 0, 1],
      "8661": [0.25, 0.75, 0, 0, 0.61111],
      "8704": [0, 0.69444, 0, 0, 0.55556],
      "8706": [0, 0.69444, 0.05556, 0.08334, 0.5309],
      "8707": [0, 0.69444, 0, 0, 0.55556],
      "8709": [0.05556, 0.75, 0, 0, 0.5],
      "8711": [0, 0.68333, 0, 0, 0.83334],
      "8712": [0.0391, 0.5391, 0, 0, 0.66667],
      "8715": [0.0391, 0.5391, 0, 0, 0.66667],
      "8722": [0.08333, 0.58333, 0, 0, 0.77778],
      "8723": [0.08333, 0.58333, 0, 0, 0.77778],
      "8725": [0.25, 0.75, 0, 0, 0.5],
      "8726": [0.25, 0.75, 0, 0, 0.5],
      "8727": [-0.03472, 0.46528, 0, 0, 0.5],
      "8728": [-0.05555, 0.44445, 0, 0, 0.5],
      "8729": [-0.05555, 0.44445, 0, 0, 0.5],
      "8730": [0.2, 0.8, 0, 0, 0.83334],
      "8733": [0, 0.43056, 0, 0, 0.77778],
      "8734": [0, 0.43056, 0, 0, 1],
      "8736": [0, 0.69224, 0, 0, 0.72222],
      "8739": [0.25, 0.75, 0, 0, 0.27778],
      "8741": [0.25, 0.75, 0, 0, 0.5],
      "8743": [0, 0.55556, 0, 0, 0.66667],
      "8744": [0, 0.55556, 0, 0, 0.66667],
      "8745": [0, 0.55556, 0, 0, 0.66667],
      "8746": [0, 0.55556, 0, 0, 0.66667],
      "8747": [0.19444, 0.69444, 0.11111, 0, 0.41667],
      "8764": [-0.13313, 0.36687, 0, 0, 0.77778],
      "8768": [0.19444, 0.69444, 0, 0, 0.27778],
      "8771": [-0.03625, 0.46375, 0, 0, 0.77778],
      "8773": [-0.022, 0.589, 0, 0, 0.778],
      "8776": [-0.01688, 0.48312, 0, 0, 0.77778],
      "8781": [-0.03625, 0.46375, 0, 0, 0.77778],
      "8784": [-0.133, 0.673, 0, 0, 0.778],
      "8801": [-0.03625, 0.46375, 0, 0, 0.77778],
      "8804": [0.13597, 0.63597, 0, 0, 0.77778],
      "8805": [0.13597, 0.63597, 0, 0, 0.77778],
      "8810": [0.0391, 0.5391, 0, 0, 1],
      "8811": [0.0391, 0.5391, 0, 0, 1],
      "8826": [0.0391, 0.5391, 0, 0, 0.77778],
      "8827": [0.0391, 0.5391, 0, 0, 0.77778],
      "8834": [0.0391, 0.5391, 0, 0, 0.77778],
      "8835": [0.0391, 0.5391, 0, 0, 0.77778],
      "8838": [0.13597, 0.63597, 0, 0, 0.77778],
      "8839": [0.13597, 0.63597, 0, 0, 0.77778],
      "8846": [0, 0.55556, 0, 0, 0.66667],
      "8849": [0.13597, 0.63597, 0, 0, 0.77778],
      "8850": [0.13597, 0.63597, 0, 0, 0.77778],
      "8851": [0, 0.55556, 0, 0, 0.66667],
      "8852": [0, 0.55556, 0, 0, 0.66667],
      "8853": [0.08333, 0.58333, 0, 0, 0.77778],
      "8854": [0.08333, 0.58333, 0, 0, 0.77778],
      "8855": [0.08333, 0.58333, 0, 0, 0.77778],
      "8856": [0.08333, 0.58333, 0, 0, 0.77778],
      "8857": [0.08333, 0.58333, 0, 0, 0.77778],
      "8866": [0, 0.69444, 0, 0, 0.61111],
      "8867": [0, 0.69444, 0, 0, 0.61111],
      "8868": [0, 0.69444, 0, 0, 0.77778],
      "8869": [0, 0.69444, 0, 0, 0.77778],
      "8872": [0.249, 0.75, 0, 0, 0.867],
      "8900": [-0.05555, 0.44445, 0, 0, 0.5],
      "8901": [-0.05555, 0.44445, 0, 0, 0.27778],
      "8902": [-0.03472, 0.46528, 0, 0, 0.5],
      "8904": [5e-3, 0.505, 0, 0, 0.9],
      "8942": [0.03, 0.903, 0, 0, 0.278],
      "8943": [-0.19, 0.313, 0, 0, 1.172],
      "8945": [-0.1, 0.823, 0, 0, 1.282],
      "8968": [0.25, 0.75, 0, 0, 0.44445],
      "8969": [0.25, 0.75, 0, 0, 0.44445],
      "8970": [0.25, 0.75, 0, 0, 0.44445],
      "8971": [0.25, 0.75, 0, 0, 0.44445],
      "8994": [-0.14236, 0.35764, 0, 0, 1],
      "8995": [-0.14236, 0.35764, 0, 0, 1],
      "9136": [0.244, 0.744, 0, 0, 0.412],
      "9137": [0.244, 0.745, 0, 0, 0.412],
      "9651": [0.19444, 0.69444, 0, 0, 0.88889],
      "9657": [-0.03472, 0.46528, 0, 0, 0.5],
      "9661": [0.19444, 0.69444, 0, 0, 0.88889],
      "9667": [-0.03472, 0.46528, 0, 0, 0.5],
      "9711": [0.19444, 0.69444, 0, 0, 1],
      "9824": [0.12963, 0.69444, 0, 0, 0.77778],
      "9825": [0.12963, 0.69444, 0, 0, 0.77778],
      "9826": [0.12963, 0.69444, 0, 0, 0.77778],
      "9827": [0.12963, 0.69444, 0, 0, 0.77778],
      "9837": [0, 0.75, 0, 0, 0.38889],
      "9838": [0.19444, 0.69444, 0, 0, 0.38889],
      "9839": [0.19444, 0.69444, 0, 0, 0.38889],
      "10216": [0.25, 0.75, 0, 0, 0.38889],
      "10217": [0.25, 0.75, 0, 0, 0.38889],
      "10222": [0.244, 0.744, 0, 0, 0.412],
      "10223": [0.244, 0.745, 0, 0, 0.412],
      "10229": [0.011, 0.511, 0, 0, 1.609],
      "10230": [0.011, 0.511, 0, 0, 1.638],
      "10231": [0.011, 0.511, 0, 0, 1.859],
      "10232": [0.024, 0.525, 0, 0, 1.609],
      "10233": [0.024, 0.525, 0, 0, 1.638],
      "10234": [0.024, 0.525, 0, 0, 1.858],
      "10236": [0.011, 0.511, 0, 0, 1.638],
      "10815": [0, 0.68333, 0, 0, 0.75],
      "10927": [0.13597, 0.63597, 0, 0, 0.77778],
      "10928": [0.13597, 0.63597, 0, 0, 0.77778],
      "57376": [0.19444, 0.69444, 0, 0, 0]
    },
    "Math-BoldItalic": {
      "32": [0, 0, 0, 0, 0.25],
      "48": [0, 0.44444, 0, 0, 0.575],
      "49": [0, 0.44444, 0, 0, 0.575],
      "50": [0, 0.44444, 0, 0, 0.575],
      "51": [0.19444, 0.44444, 0, 0, 0.575],
      "52": [0.19444, 0.44444, 0, 0, 0.575],
      "53": [0.19444, 0.44444, 0, 0, 0.575],
      "54": [0, 0.64444, 0, 0, 0.575],
      "55": [0.19444, 0.44444, 0, 0, 0.575],
      "56": [0, 0.64444, 0, 0, 0.575],
      "57": [0.19444, 0.44444, 0, 0, 0.575],
      "65": [0, 0.68611, 0, 0, 0.86944],
      "66": [0, 0.68611, 0.04835, 0, 0.8664],
      "67": [0, 0.68611, 0.06979, 0, 0.81694],
      "68": [0, 0.68611, 0.03194, 0, 0.93812],
      "69": [0, 0.68611, 0.05451, 0, 0.81007],
      "70": [0, 0.68611, 0.15972, 0, 0.68889],
      "71": [0, 0.68611, 0, 0, 0.88673],
      "72": [0, 0.68611, 0.08229, 0, 0.98229],
      "73": [0, 0.68611, 0.07778, 0, 0.51111],
      "74": [0, 0.68611, 0.10069, 0, 0.63125],
      "75": [0, 0.68611, 0.06979, 0, 0.97118],
      "76": [0, 0.68611, 0, 0, 0.75555],
      "77": [0, 0.68611, 0.11424, 0, 1.14201],
      "78": [0, 0.68611, 0.11424, 0, 0.95034],
      "79": [0, 0.68611, 0.03194, 0, 0.83666],
      "80": [0, 0.68611, 0.15972, 0, 0.72309],
      "81": [0.19444, 0.68611, 0, 0, 0.86861],
      "82": [0, 0.68611, 421e-5, 0, 0.87235],
      "83": [0, 0.68611, 0.05382, 0, 0.69271],
      "84": [0, 0.68611, 0.15972, 0, 0.63663],
      "85": [0, 0.68611, 0.11424, 0, 0.80027],
      "86": [0, 0.68611, 0.25555, 0, 0.67778],
      "87": [0, 0.68611, 0.15972, 0, 1.09305],
      "88": [0, 0.68611, 0.07778, 0, 0.94722],
      "89": [0, 0.68611, 0.25555, 0, 0.67458],
      "90": [0, 0.68611, 0.06979, 0, 0.77257],
      "97": [0, 0.44444, 0, 0, 0.63287],
      "98": [0, 0.69444, 0, 0, 0.52083],
      "99": [0, 0.44444, 0, 0, 0.51342],
      "100": [0, 0.69444, 0, 0, 0.60972],
      "101": [0, 0.44444, 0, 0, 0.55361],
      "102": [0.19444, 0.69444, 0.11042, 0, 0.56806],
      "103": [0.19444, 0.44444, 0.03704, 0, 0.5449],
      "104": [0, 0.69444, 0, 0, 0.66759],
      "105": [0, 0.69326, 0, 0, 0.4048],
      "106": [0.19444, 0.69326, 0.0622, 0, 0.47083],
      "107": [0, 0.69444, 0.01852, 0, 0.6037],
      "108": [0, 0.69444, 88e-4, 0, 0.34815],
      "109": [0, 0.44444, 0, 0, 1.0324],
      "110": [0, 0.44444, 0, 0, 0.71296],
      "111": [0, 0.44444, 0, 0, 0.58472],
      "112": [0.19444, 0.44444, 0, 0, 0.60092],
      "113": [0.19444, 0.44444, 0.03704, 0, 0.54213],
      "114": [0, 0.44444, 0.03194, 0, 0.5287],
      "115": [0, 0.44444, 0, 0, 0.53125],
      "116": [0, 0.63492, 0, 0, 0.41528],
      "117": [0, 0.44444, 0, 0, 0.68102],
      "118": [0, 0.44444, 0.03704, 0, 0.56666],
      "119": [0, 0.44444, 0.02778, 0, 0.83148],
      "120": [0, 0.44444, 0, 0, 0.65903],
      "121": [0.19444, 0.44444, 0.03704, 0, 0.59028],
      "122": [0, 0.44444, 0.04213, 0, 0.55509],
      "160": [0, 0, 0, 0, 0.25],
      "915": [0, 0.68611, 0.15972, 0, 0.65694],
      "916": [0, 0.68611, 0, 0, 0.95833],
      "920": [0, 0.68611, 0.03194, 0, 0.86722],
      "923": [0, 0.68611, 0, 0, 0.80555],
      "926": [0, 0.68611, 0.07458, 0, 0.84125],
      "928": [0, 0.68611, 0.08229, 0, 0.98229],
      "931": [0, 0.68611, 0.05451, 0, 0.88507],
      "933": [0, 0.68611, 0.15972, 0, 0.67083],
      "934": [0, 0.68611, 0, 0, 0.76666],
      "936": [0, 0.68611, 0.11653, 0, 0.71402],
      "937": [0, 0.68611, 0.04835, 0, 0.8789],
      "945": [0, 0.44444, 0, 0, 0.76064],
      "946": [0.19444, 0.69444, 0.03403, 0, 0.65972],
      "947": [0.19444, 0.44444, 0.06389, 0, 0.59003],
      "948": [0, 0.69444, 0.03819, 0, 0.52222],
      "949": [0, 0.44444, 0, 0, 0.52882],
      "950": [0.19444, 0.69444, 0.06215, 0, 0.50833],
      "951": [0.19444, 0.44444, 0.03704, 0, 0.6],
      "952": [0, 0.69444, 0.03194, 0, 0.5618],
      "953": [0, 0.44444, 0, 0, 0.41204],
      "954": [0, 0.44444, 0, 0, 0.66759],
      "955": [0, 0.69444, 0, 0, 0.67083],
      "956": [0.19444, 0.44444, 0, 0, 0.70787],
      "957": [0, 0.44444, 0.06898, 0, 0.57685],
      "958": [0.19444, 0.69444, 0.03021, 0, 0.50833],
      "959": [0, 0.44444, 0, 0, 0.58472],
      "960": [0, 0.44444, 0.03704, 0, 0.68241],
      "961": [0.19444, 0.44444, 0, 0, 0.6118],
      "962": [0.09722, 0.44444, 0.07917, 0, 0.42361],
      "963": [0, 0.44444, 0.03704, 0, 0.68588],
      "964": [0, 0.44444, 0.13472, 0, 0.52083],
      "965": [0, 0.44444, 0.03704, 0, 0.63055],
      "966": [0.19444, 0.44444, 0, 0, 0.74722],
      "967": [0.19444, 0.44444, 0, 0, 0.71805],
      "968": [0.19444, 0.69444, 0.03704, 0, 0.75833],
      "969": [0, 0.44444, 0.03704, 0, 0.71782],
      "977": [0, 0.69444, 0, 0, 0.69155],
      "981": [0.19444, 0.69444, 0, 0, 0.7125],
      "982": [0, 0.44444, 0.03194, 0, 0.975],
      "1009": [0.19444, 0.44444, 0, 0, 0.6118],
      "1013": [0, 0.44444, 0, 0, 0.48333],
      "57649": [0, 0.44444, 0, 0, 0.39352],
      "57911": [0.19444, 0.44444, 0, 0, 0.43889]
    },
    "Math-Italic": {
      "32": [0, 0, 0, 0, 0.25],
      "48": [0, 0.43056, 0, 0, 0.5],
      "49": [0, 0.43056, 0, 0, 0.5],
      "50": [0, 0.43056, 0, 0, 0.5],
      "51": [0.19444, 0.43056, 0, 0, 0.5],
      "52": [0.19444, 0.43056, 0, 0, 0.5],
      "53": [0.19444, 0.43056, 0, 0, 0.5],
      "54": [0, 0.64444, 0, 0, 0.5],
      "55": [0.19444, 0.43056, 0, 0, 0.5],
      "56": [0, 0.64444, 0, 0, 0.5],
      "57": [0.19444, 0.43056, 0, 0, 0.5],
      "65": [0, 0.68333, 0, 0.13889, 0.75],
      "66": [0, 0.68333, 0.05017, 0.08334, 0.75851],
      "67": [0, 0.68333, 0.07153, 0.08334, 0.71472],
      "68": [0, 0.68333, 0.02778, 0.05556, 0.82792],
      "69": [0, 0.68333, 0.05764, 0.08334, 0.7382],
      "70": [0, 0.68333, 0.13889, 0.08334, 0.64306],
      "71": [0, 0.68333, 0, 0.08334, 0.78625],
      "72": [0, 0.68333, 0.08125, 0.05556, 0.83125],
      "73": [0, 0.68333, 0.07847, 0.11111, 0.43958],
      "74": [0, 0.68333, 0.09618, 0.16667, 0.55451],
      "75": [0, 0.68333, 0.07153, 0.05556, 0.84931],
      "76": [0, 0.68333, 0, 0.02778, 0.68056],
      "77": [0, 0.68333, 0.10903, 0.08334, 0.97014],
      "78": [0, 0.68333, 0.10903, 0.08334, 0.80347],
      "79": [0, 0.68333, 0.02778, 0.08334, 0.76278],
      "80": [0, 0.68333, 0.13889, 0.08334, 0.64201],
      "81": [0.19444, 0.68333, 0, 0.08334, 0.79056],
      "82": [0, 0.68333, 773e-5, 0.08334, 0.75929],
      "83": [0, 0.68333, 0.05764, 0.08334, 0.6132],
      "84": [0, 0.68333, 0.13889, 0.08334, 0.58438],
      "85": [0, 0.68333, 0.10903, 0.02778, 0.68278],
      "86": [0, 0.68333, 0.22222, 0, 0.58333],
      "87": [0, 0.68333, 0.13889, 0, 0.94445],
      "88": [0, 0.68333, 0.07847, 0.08334, 0.82847],
      "89": [0, 0.68333, 0.22222, 0, 0.58056],
      "90": [0, 0.68333, 0.07153, 0.08334, 0.68264],
      "97": [0, 0.43056, 0, 0, 0.52859],
      "98": [0, 0.69444, 0, 0, 0.42917],
      "99": [0, 0.43056, 0, 0.05556, 0.43276],
      "100": [0, 0.69444, 0, 0.16667, 0.52049],
      "101": [0, 0.43056, 0, 0.05556, 0.46563],
      "102": [0.19444, 0.69444, 0.10764, 0.16667, 0.48959],
      "103": [0.19444, 0.43056, 0.03588, 0.02778, 0.47697],
      "104": [0, 0.69444, 0, 0, 0.57616],
      "105": [0, 0.65952, 0, 0, 0.34451],
      "106": [0.19444, 0.65952, 0.05724, 0, 0.41181],
      "107": [0, 0.69444, 0.03148, 0, 0.5206],
      "108": [0, 0.69444, 0.01968, 0.08334, 0.29838],
      "109": [0, 0.43056, 0, 0, 0.87801],
      "110": [0, 0.43056, 0, 0, 0.60023],
      "111": [0, 0.43056, 0, 0.05556, 0.48472],
      "112": [0.19444, 0.43056, 0, 0.08334, 0.50313],
      "113": [0.19444, 0.43056, 0.03588, 0.08334, 0.44641],
      "114": [0, 0.43056, 0.02778, 0.05556, 0.45116],
      "115": [0, 0.43056, 0, 0.05556, 0.46875],
      "116": [0, 0.61508, 0, 0.08334, 0.36111],
      "117": [0, 0.43056, 0, 0.02778, 0.57246],
      "118": [0, 0.43056, 0.03588, 0.02778, 0.48472],
      "119": [0, 0.43056, 0.02691, 0.08334, 0.71592],
      "120": [0, 0.43056, 0, 0.02778, 0.57153],
      "121": [0.19444, 0.43056, 0.03588, 0.05556, 0.49028],
      "122": [0, 0.43056, 0.04398, 0.05556, 0.46505],
      "160": [0, 0, 0, 0, 0.25],
      "915": [0, 0.68333, 0.13889, 0.08334, 0.61528],
      "916": [0, 0.68333, 0, 0.16667, 0.83334],
      "920": [0, 0.68333, 0.02778, 0.08334, 0.76278],
      "923": [0, 0.68333, 0, 0.16667, 0.69445],
      "926": [0, 0.68333, 0.07569, 0.08334, 0.74236],
      "928": [0, 0.68333, 0.08125, 0.05556, 0.83125],
      "931": [0, 0.68333, 0.05764, 0.08334, 0.77986],
      "933": [0, 0.68333, 0.13889, 0.05556, 0.58333],
      "934": [0, 0.68333, 0, 0.08334, 0.66667],
      "936": [0, 0.68333, 0.11, 0.05556, 0.61222],
      "937": [0, 0.68333, 0.05017, 0.08334, 0.7724],
      "945": [0, 0.43056, 37e-4, 0.02778, 0.6397],
      "946": [0.19444, 0.69444, 0.05278, 0.08334, 0.56563],
      "947": [0.19444, 0.43056, 0.05556, 0, 0.51773],
      "948": [0, 0.69444, 0.03785, 0.05556, 0.44444],
      "949": [0, 0.43056, 0, 0.08334, 0.46632],
      "950": [0.19444, 0.69444, 0.07378, 0.08334, 0.4375],
      "951": [0.19444, 0.43056, 0.03588, 0.05556, 0.49653],
      "952": [0, 0.69444, 0.02778, 0.08334, 0.46944],
      "953": [0, 0.43056, 0, 0.05556, 0.35394],
      "954": [0, 0.43056, 0, 0, 0.57616],
      "955": [0, 0.69444, 0, 0, 0.58334],
      "956": [0.19444, 0.43056, 0, 0.02778, 0.60255],
      "957": [0, 0.43056, 0.06366, 0.02778, 0.49398],
      "958": [0.19444, 0.69444, 0.04601, 0.11111, 0.4375],
      "959": [0, 0.43056, 0, 0.05556, 0.48472],
      "960": [0, 0.43056, 0.03588, 0, 0.57003],
      "961": [0.19444, 0.43056, 0, 0.08334, 0.51702],
      "962": [0.09722, 0.43056, 0.07986, 0.08334, 0.36285],
      "963": [0, 0.43056, 0.03588, 0, 0.57141],
      "964": [0, 0.43056, 0.1132, 0.02778, 0.43715],
      "965": [0, 0.43056, 0.03588, 0.02778, 0.54028],
      "966": [0.19444, 0.43056, 0, 0.08334, 0.65417],
      "967": [0.19444, 0.43056, 0, 0.05556, 0.62569],
      "968": [0.19444, 0.69444, 0.03588, 0.11111, 0.65139],
      "969": [0, 0.43056, 0.03588, 0, 0.62245],
      "977": [0, 0.69444, 0, 0.08334, 0.59144],
      "981": [0.19444, 0.69444, 0, 0.08334, 0.59583],
      "982": [0, 0.43056, 0.02778, 0, 0.82813],
      "1009": [0.19444, 0.43056, 0, 0.08334, 0.51702],
      "1013": [0, 0.43056, 0, 0.05556, 0.4059],
      "57649": [0, 0.43056, 0, 0.02778, 0.32246],
      "57911": [0.19444, 0.43056, 0, 0.08334, 0.38403]
    },
    "SansSerif-Bold": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0, 0, 0.36667],
      "34": [0, 0.69444, 0, 0, 0.55834],
      "35": [0.19444, 0.69444, 0, 0, 0.91667],
      "36": [0.05556, 0.75, 0, 0, 0.55],
      "37": [0.05556, 0.75, 0, 0, 1.02912],
      "38": [0, 0.69444, 0, 0, 0.83056],
      "39": [0, 0.69444, 0, 0, 0.30556],
      "40": [0.25, 0.75, 0, 0, 0.42778],
      "41": [0.25, 0.75, 0, 0, 0.42778],
      "42": [0, 0.75, 0, 0, 0.55],
      "43": [0.11667, 0.61667, 0, 0, 0.85556],
      "44": [0.10556, 0.13056, 0, 0, 0.30556],
      "45": [0, 0.45833, 0, 0, 0.36667],
      "46": [0, 0.13056, 0, 0, 0.30556],
      "47": [0.25, 0.75, 0, 0, 0.55],
      "48": [0, 0.69444, 0, 0, 0.55],
      "49": [0, 0.69444, 0, 0, 0.55],
      "50": [0, 0.69444, 0, 0, 0.55],
      "51": [0, 0.69444, 0, 0, 0.55],
      "52": [0, 0.69444, 0, 0, 0.55],
      "53": [0, 0.69444, 0, 0, 0.55],
      "54": [0, 0.69444, 0, 0, 0.55],
      "55": [0, 0.69444, 0, 0, 0.55],
      "56": [0, 0.69444, 0, 0, 0.55],
      "57": [0, 0.69444, 0, 0, 0.55],
      "58": [0, 0.45833, 0, 0, 0.30556],
      "59": [0.10556, 0.45833, 0, 0, 0.30556],
      "61": [-0.09375, 0.40625, 0, 0, 0.85556],
      "63": [0, 0.69444, 0, 0, 0.51945],
      "64": [0, 0.69444, 0, 0, 0.73334],
      "65": [0, 0.69444, 0, 0, 0.73334],
      "66": [0, 0.69444, 0, 0, 0.73334],
      "67": [0, 0.69444, 0, 0, 0.70278],
      "68": [0, 0.69444, 0, 0, 0.79445],
      "69": [0, 0.69444, 0, 0, 0.64167],
      "70": [0, 0.69444, 0, 0, 0.61111],
      "71": [0, 0.69444, 0, 0, 0.73334],
      "72": [0, 0.69444, 0, 0, 0.79445],
      "73": [0, 0.69444, 0, 0, 0.33056],
      "74": [0, 0.69444, 0, 0, 0.51945],
      "75": [0, 0.69444, 0, 0, 0.76389],
      "76": [0, 0.69444, 0, 0, 0.58056],
      "77": [0, 0.69444, 0, 0, 0.97778],
      "78": [0, 0.69444, 0, 0, 0.79445],
      "79": [0, 0.69444, 0, 0, 0.79445],
      "80": [0, 0.69444, 0, 0, 0.70278],
      "81": [0.10556, 0.69444, 0, 0, 0.79445],
      "82": [0, 0.69444, 0, 0, 0.70278],
      "83": [0, 0.69444, 0, 0, 0.61111],
      "84": [0, 0.69444, 0, 0, 0.73334],
      "85": [0, 0.69444, 0, 0, 0.76389],
      "86": [0, 0.69444, 0.01528, 0, 0.73334],
      "87": [0, 0.69444, 0.01528, 0, 1.03889],
      "88": [0, 0.69444, 0, 0, 0.73334],
      "89": [0, 0.69444, 0.0275, 0, 0.73334],
      "90": [0, 0.69444, 0, 0, 0.67223],
      "91": [0.25, 0.75, 0, 0, 0.34306],
      "93": [0.25, 0.75, 0, 0, 0.34306],
      "94": [0, 0.69444, 0, 0, 0.55],
      "95": [0.35, 0.10833, 0.03056, 0, 0.55],
      "97": [0, 0.45833, 0, 0, 0.525],
      "98": [0, 0.69444, 0, 0, 0.56111],
      "99": [0, 0.45833, 0, 0, 0.48889],
      "100": [0, 0.69444, 0, 0, 0.56111],
      "101": [0, 0.45833, 0, 0, 0.51111],
      "102": [0, 0.69444, 0.07639, 0, 0.33611],
      "103": [0.19444, 0.45833, 0.01528, 0, 0.55],
      "104": [0, 0.69444, 0, 0, 0.56111],
      "105": [0, 0.69444, 0, 0, 0.25556],
      "106": [0.19444, 0.69444, 0, 0, 0.28611],
      "107": [0, 0.69444, 0, 0, 0.53056],
      "108": [0, 0.69444, 0, 0, 0.25556],
      "109": [0, 0.45833, 0, 0, 0.86667],
      "110": [0, 0.45833, 0, 0, 0.56111],
      "111": [0, 0.45833, 0, 0, 0.55],
      "112": [0.19444, 0.45833, 0, 0, 0.56111],
      "113": [0.19444, 0.45833, 0, 0, 0.56111],
      "114": [0, 0.45833, 0.01528, 0, 0.37222],
      "115": [0, 0.45833, 0, 0, 0.42167],
      "116": [0, 0.58929, 0, 0, 0.40417],
      "117": [0, 0.45833, 0, 0, 0.56111],
      "118": [0, 0.45833, 0.01528, 0, 0.5],
      "119": [0, 0.45833, 0.01528, 0, 0.74445],
      "120": [0, 0.45833, 0, 0, 0.5],
      "121": [0.19444, 0.45833, 0.01528, 0, 0.5],
      "122": [0, 0.45833, 0, 0, 0.47639],
      "126": [0.35, 0.34444, 0, 0, 0.55],
      "160": [0, 0, 0, 0, 0.25],
      "168": [0, 0.69444, 0, 0, 0.55],
      "176": [0, 0.69444, 0, 0, 0.73334],
      "180": [0, 0.69444, 0, 0, 0.55],
      "184": [0.17014, 0, 0, 0, 0.48889],
      "305": [0, 0.45833, 0, 0, 0.25556],
      "567": [0.19444, 0.45833, 0, 0, 0.28611],
      "710": [0, 0.69444, 0, 0, 0.55],
      "711": [0, 0.63542, 0, 0, 0.55],
      "713": [0, 0.63778, 0, 0, 0.55],
      "728": [0, 0.69444, 0, 0, 0.55],
      "729": [0, 0.69444, 0, 0, 0.30556],
      "730": [0, 0.69444, 0, 0, 0.73334],
      "732": [0, 0.69444, 0, 0, 0.55],
      "733": [0, 0.69444, 0, 0, 0.55],
      "915": [0, 0.69444, 0, 0, 0.58056],
      "916": [0, 0.69444, 0, 0, 0.91667],
      "920": [0, 0.69444, 0, 0, 0.85556],
      "923": [0, 0.69444, 0, 0, 0.67223],
      "926": [0, 0.69444, 0, 0, 0.73334],
      "928": [0, 0.69444, 0, 0, 0.79445],
      "931": [0, 0.69444, 0, 0, 0.79445],
      "933": [0, 0.69444, 0, 0, 0.85556],
      "934": [0, 0.69444, 0, 0, 0.79445],
      "936": [0, 0.69444, 0, 0, 0.85556],
      "937": [0, 0.69444, 0, 0, 0.79445],
      "8211": [0, 0.45833, 0.03056, 0, 0.55],
      "8212": [0, 0.45833, 0.03056, 0, 1.10001],
      "8216": [0, 0.69444, 0, 0, 0.30556],
      "8217": [0, 0.69444, 0, 0, 0.30556],
      "8220": [0, 0.69444, 0, 0, 0.55834],
      "8221": [0, 0.69444, 0, 0, 0.55834]
    },
    "SansSerif-Italic": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0.05733, 0, 0.31945],
      "34": [0, 0.69444, 316e-5, 0, 0.5],
      "35": [0.19444, 0.69444, 0.05087, 0, 0.83334],
      "36": [0.05556, 0.75, 0.11156, 0, 0.5],
      "37": [0.05556, 0.75, 0.03126, 0, 0.83334],
      "38": [0, 0.69444, 0.03058, 0, 0.75834],
      "39": [0, 0.69444, 0.07816, 0, 0.27778],
      "40": [0.25, 0.75, 0.13164, 0, 0.38889],
      "41": [0.25, 0.75, 0.02536, 0, 0.38889],
      "42": [0, 0.75, 0.11775, 0, 0.5],
      "43": [0.08333, 0.58333, 0.02536, 0, 0.77778],
      "44": [0.125, 0.08333, 0, 0, 0.27778],
      "45": [0, 0.44444, 0.01946, 0, 0.33333],
      "46": [0, 0.08333, 0, 0, 0.27778],
      "47": [0.25, 0.75, 0.13164, 0, 0.5],
      "48": [0, 0.65556, 0.11156, 0, 0.5],
      "49": [0, 0.65556, 0.11156, 0, 0.5],
      "50": [0, 0.65556, 0.11156, 0, 0.5],
      "51": [0, 0.65556, 0.11156, 0, 0.5],
      "52": [0, 0.65556, 0.11156, 0, 0.5],
      "53": [0, 0.65556, 0.11156, 0, 0.5],
      "54": [0, 0.65556, 0.11156, 0, 0.5],
      "55": [0, 0.65556, 0.11156, 0, 0.5],
      "56": [0, 0.65556, 0.11156, 0, 0.5],
      "57": [0, 0.65556, 0.11156, 0, 0.5],
      "58": [0, 0.44444, 0.02502, 0, 0.27778],
      "59": [0.125, 0.44444, 0.02502, 0, 0.27778],
      "61": [-0.13, 0.37, 0.05087, 0, 0.77778],
      "63": [0, 0.69444, 0.11809, 0, 0.47222],
      "64": [0, 0.69444, 0.07555, 0, 0.66667],
      "65": [0, 0.69444, 0, 0, 0.66667],
      "66": [0, 0.69444, 0.08293, 0, 0.66667],
      "67": [0, 0.69444, 0.11983, 0, 0.63889],
      "68": [0, 0.69444, 0.07555, 0, 0.72223],
      "69": [0, 0.69444, 0.11983, 0, 0.59722],
      "70": [0, 0.69444, 0.13372, 0, 0.56945],
      "71": [0, 0.69444, 0.11983, 0, 0.66667],
      "72": [0, 0.69444, 0.08094, 0, 0.70834],
      "73": [0, 0.69444, 0.13372, 0, 0.27778],
      "74": [0, 0.69444, 0.08094, 0, 0.47222],
      "75": [0, 0.69444, 0.11983, 0, 0.69445],
      "76": [0, 0.69444, 0, 0, 0.54167],
      "77": [0, 0.69444, 0.08094, 0, 0.875],
      "78": [0, 0.69444, 0.08094, 0, 0.70834],
      "79": [0, 0.69444, 0.07555, 0, 0.73611],
      "80": [0, 0.69444, 0.08293, 0, 0.63889],
      "81": [0.125, 0.69444, 0.07555, 0, 0.73611],
      "82": [0, 0.69444, 0.08293, 0, 0.64584],
      "83": [0, 0.69444, 0.09205, 0, 0.55556],
      "84": [0, 0.69444, 0.13372, 0, 0.68056],
      "85": [0, 0.69444, 0.08094, 0, 0.6875],
      "86": [0, 0.69444, 0.1615, 0, 0.66667],
      "87": [0, 0.69444, 0.1615, 0, 0.94445],
      "88": [0, 0.69444, 0.13372, 0, 0.66667],
      "89": [0, 0.69444, 0.17261, 0, 0.66667],
      "90": [0, 0.69444, 0.11983, 0, 0.61111],
      "91": [0.25, 0.75, 0.15942, 0, 0.28889],
      "93": [0.25, 0.75, 0.08719, 0, 0.28889],
      "94": [0, 0.69444, 0.0799, 0, 0.5],
      "95": [0.35, 0.09444, 0.08616, 0, 0.5],
      "97": [0, 0.44444, 981e-5, 0, 0.48056],
      "98": [0, 0.69444, 0.03057, 0, 0.51667],
      "99": [0, 0.44444, 0.08336, 0, 0.44445],
      "100": [0, 0.69444, 0.09483, 0, 0.51667],
      "101": [0, 0.44444, 0.06778, 0, 0.44445],
      "102": [0, 0.69444, 0.21705, 0, 0.30556],
      "103": [0.19444, 0.44444, 0.10836, 0, 0.5],
      "104": [0, 0.69444, 0.01778, 0, 0.51667],
      "105": [0, 0.67937, 0.09718, 0, 0.23889],
      "106": [0.19444, 0.67937, 0.09162, 0, 0.26667],
      "107": [0, 0.69444, 0.08336, 0, 0.48889],
      "108": [0, 0.69444, 0.09483, 0, 0.23889],
      "109": [0, 0.44444, 0.01778, 0, 0.79445],
      "110": [0, 0.44444, 0.01778, 0, 0.51667],
      "111": [0, 0.44444, 0.06613, 0, 0.5],
      "112": [0.19444, 0.44444, 0.0389, 0, 0.51667],
      "113": [0.19444, 0.44444, 0.04169, 0, 0.51667],
      "114": [0, 0.44444, 0.10836, 0, 0.34167],
      "115": [0, 0.44444, 0.0778, 0, 0.38333],
      "116": [0, 0.57143, 0.07225, 0, 0.36111],
      "117": [0, 0.44444, 0.04169, 0, 0.51667],
      "118": [0, 0.44444, 0.10836, 0, 0.46111],
      "119": [0, 0.44444, 0.10836, 0, 0.68334],
      "120": [0, 0.44444, 0.09169, 0, 0.46111],
      "121": [0.19444, 0.44444, 0.10836, 0, 0.46111],
      "122": [0, 0.44444, 0.08752, 0, 0.43472],
      "126": [0.35, 0.32659, 0.08826, 0, 0.5],
      "160": [0, 0, 0, 0, 0.25],
      "168": [0, 0.67937, 0.06385, 0, 0.5],
      "176": [0, 0.69444, 0, 0, 0.73752],
      "184": [0.17014, 0, 0, 0, 0.44445],
      "305": [0, 0.44444, 0.04169, 0, 0.23889],
      "567": [0.19444, 0.44444, 0.04169, 0, 0.26667],
      "710": [0, 0.69444, 0.0799, 0, 0.5],
      "711": [0, 0.63194, 0.08432, 0, 0.5],
      "713": [0, 0.60889, 0.08776, 0, 0.5],
      "714": [0, 0.69444, 0.09205, 0, 0.5],
      "715": [0, 0.69444, 0, 0, 0.5],
      "728": [0, 0.69444, 0.09483, 0, 0.5],
      "729": [0, 0.67937, 0.07774, 0, 0.27778],
      "730": [0, 0.69444, 0, 0, 0.73752],
      "732": [0, 0.67659, 0.08826, 0, 0.5],
      "733": [0, 0.69444, 0.09205, 0, 0.5],
      "915": [0, 0.69444, 0.13372, 0, 0.54167],
      "916": [0, 0.69444, 0, 0, 0.83334],
      "920": [0, 0.69444, 0.07555, 0, 0.77778],
      "923": [0, 0.69444, 0, 0, 0.61111],
      "926": [0, 0.69444, 0.12816, 0, 0.66667],
      "928": [0, 0.69444, 0.08094, 0, 0.70834],
      "931": [0, 0.69444, 0.11983, 0, 0.72222],
      "933": [0, 0.69444, 0.09031, 0, 0.77778],
      "934": [0, 0.69444, 0.04603, 0, 0.72222],
      "936": [0, 0.69444, 0.09031, 0, 0.77778],
      "937": [0, 0.69444, 0.08293, 0, 0.72222],
      "8211": [0, 0.44444, 0.08616, 0, 0.5],
      "8212": [0, 0.44444, 0.08616, 0, 1],
      "8216": [0, 0.69444, 0.07816, 0, 0.27778],
      "8217": [0, 0.69444, 0.07816, 0, 0.27778],
      "8220": [0, 0.69444, 0.14205, 0, 0.5],
      "8221": [0, 0.69444, 316e-5, 0, 0.5]
    },
    "SansSerif-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "33": [0, 0.69444, 0, 0, 0.31945],
      "34": [0, 0.69444, 0, 0, 0.5],
      "35": [0.19444, 0.69444, 0, 0, 0.83334],
      "36": [0.05556, 0.75, 0, 0, 0.5],
      "37": [0.05556, 0.75, 0, 0, 0.83334],
      "38": [0, 0.69444, 0, 0, 0.75834],
      "39": [0, 0.69444, 0, 0, 0.27778],
      "40": [0.25, 0.75, 0, 0, 0.38889],
      "41": [0.25, 0.75, 0, 0, 0.38889],
      "42": [0, 0.75, 0, 0, 0.5],
      "43": [0.08333, 0.58333, 0, 0, 0.77778],
      "44": [0.125, 0.08333, 0, 0, 0.27778],
      "45": [0, 0.44444, 0, 0, 0.33333],
      "46": [0, 0.08333, 0, 0, 0.27778],
      "47": [0.25, 0.75, 0, 0, 0.5],
      "48": [0, 0.65556, 0, 0, 0.5],
      "49": [0, 0.65556, 0, 0, 0.5],
      "50": [0, 0.65556, 0, 0, 0.5],
      "51": [0, 0.65556, 0, 0, 0.5],
      "52": [0, 0.65556, 0, 0, 0.5],
      "53": [0, 0.65556, 0, 0, 0.5],
      "54": [0, 0.65556, 0, 0, 0.5],
      "55": [0, 0.65556, 0, 0, 0.5],
      "56": [0, 0.65556, 0, 0, 0.5],
      "57": [0, 0.65556, 0, 0, 0.5],
      "58": [0, 0.44444, 0, 0, 0.27778],
      "59": [0.125, 0.44444, 0, 0, 0.27778],
      "61": [-0.13, 0.37, 0, 0, 0.77778],
      "63": [0, 0.69444, 0, 0, 0.47222],
      "64": [0, 0.69444, 0, 0, 0.66667],
      "65": [0, 0.69444, 0, 0, 0.66667],
      "66": [0, 0.69444, 0, 0, 0.66667],
      "67": [0, 0.69444, 0, 0, 0.63889],
      "68": [0, 0.69444, 0, 0, 0.72223],
      "69": [0, 0.69444, 0, 0, 0.59722],
      "70": [0, 0.69444, 0, 0, 0.56945],
      "71": [0, 0.69444, 0, 0, 0.66667],
      "72": [0, 0.69444, 0, 0, 0.70834],
      "73": [0, 0.69444, 0, 0, 0.27778],
      "74": [0, 0.69444, 0, 0, 0.47222],
      "75": [0, 0.69444, 0, 0, 0.69445],
      "76": [0, 0.69444, 0, 0, 0.54167],
      "77": [0, 0.69444, 0, 0, 0.875],
      "78": [0, 0.69444, 0, 0, 0.70834],
      "79": [0, 0.69444, 0, 0, 0.73611],
      "80": [0, 0.69444, 0, 0, 0.63889],
      "81": [0.125, 0.69444, 0, 0, 0.73611],
      "82": [0, 0.69444, 0, 0, 0.64584],
      "83": [0, 0.69444, 0, 0, 0.55556],
      "84": [0, 0.69444, 0, 0, 0.68056],
      "85": [0, 0.69444, 0, 0, 0.6875],
      "86": [0, 0.69444, 0.01389, 0, 0.66667],
      "87": [0, 0.69444, 0.01389, 0, 0.94445],
      "88": [0, 0.69444, 0, 0, 0.66667],
      "89": [0, 0.69444, 0.025, 0, 0.66667],
      "90": [0, 0.69444, 0, 0, 0.61111],
      "91": [0.25, 0.75, 0, 0, 0.28889],
      "93": [0.25, 0.75, 0, 0, 0.28889],
      "94": [0, 0.69444, 0, 0, 0.5],
      "95": [0.35, 0.09444, 0.02778, 0, 0.5],
      "97": [0, 0.44444, 0, 0, 0.48056],
      "98": [0, 0.69444, 0, 0, 0.51667],
      "99": [0, 0.44444, 0, 0, 0.44445],
      "100": [0, 0.69444, 0, 0, 0.51667],
      "101": [0, 0.44444, 0, 0, 0.44445],
      "102": [0, 0.69444, 0.06944, 0, 0.30556],
      "103": [0.19444, 0.44444, 0.01389, 0, 0.5],
      "104": [0, 0.69444, 0, 0, 0.51667],
      "105": [0, 0.67937, 0, 0, 0.23889],
      "106": [0.19444, 0.67937, 0, 0, 0.26667],
      "107": [0, 0.69444, 0, 0, 0.48889],
      "108": [0, 0.69444, 0, 0, 0.23889],
      "109": [0, 0.44444, 0, 0, 0.79445],
      "110": [0, 0.44444, 0, 0, 0.51667],
      "111": [0, 0.44444, 0, 0, 0.5],
      "112": [0.19444, 0.44444, 0, 0, 0.51667],
      "113": [0.19444, 0.44444, 0, 0, 0.51667],
      "114": [0, 0.44444, 0.01389, 0, 0.34167],
      "115": [0, 0.44444, 0, 0, 0.38333],
      "116": [0, 0.57143, 0, 0, 0.36111],
      "117": [0, 0.44444, 0, 0, 0.51667],
      "118": [0, 0.44444, 0.01389, 0, 0.46111],
      "119": [0, 0.44444, 0.01389, 0, 0.68334],
      "120": [0, 0.44444, 0, 0, 0.46111],
      "121": [0.19444, 0.44444, 0.01389, 0, 0.46111],
      "122": [0, 0.44444, 0, 0, 0.43472],
      "126": [0.35, 0.32659, 0, 0, 0.5],
      "160": [0, 0, 0, 0, 0.25],
      "168": [0, 0.67937, 0, 0, 0.5],
      "176": [0, 0.69444, 0, 0, 0.66667],
      "184": [0.17014, 0, 0, 0, 0.44445],
      "305": [0, 0.44444, 0, 0, 0.23889],
      "567": [0.19444, 0.44444, 0, 0, 0.26667],
      "710": [0, 0.69444, 0, 0, 0.5],
      "711": [0, 0.63194, 0, 0, 0.5],
      "713": [0, 0.60889, 0, 0, 0.5],
      "714": [0, 0.69444, 0, 0, 0.5],
      "715": [0, 0.69444, 0, 0, 0.5],
      "728": [0, 0.69444, 0, 0, 0.5],
      "729": [0, 0.67937, 0, 0, 0.27778],
      "730": [0, 0.69444, 0, 0, 0.66667],
      "732": [0, 0.67659, 0, 0, 0.5],
      "733": [0, 0.69444, 0, 0, 0.5],
      "915": [0, 0.69444, 0, 0, 0.54167],
      "916": [0, 0.69444, 0, 0, 0.83334],
      "920": [0, 0.69444, 0, 0, 0.77778],
      "923": [0, 0.69444, 0, 0, 0.61111],
      "926": [0, 0.69444, 0, 0, 0.66667],
      "928": [0, 0.69444, 0, 0, 0.70834],
      "931": [0, 0.69444, 0, 0, 0.72222],
      "933": [0, 0.69444, 0, 0, 0.77778],
      "934": [0, 0.69444, 0, 0, 0.72222],
      "936": [0, 0.69444, 0, 0, 0.77778],
      "937": [0, 0.69444, 0, 0, 0.72222],
      "8211": [0, 0.44444, 0.02778, 0, 0.5],
      "8212": [0, 0.44444, 0.02778, 0, 1],
      "8216": [0, 0.69444, 0, 0, 0.27778],
      "8217": [0, 0.69444, 0, 0, 0.27778],
      "8220": [0, 0.69444, 0, 0, 0.5],
      "8221": [0, 0.69444, 0, 0, 0.5]
    },
    "Script-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "65": [0, 0.7, 0.22925, 0, 0.80253],
      "66": [0, 0.7, 0.04087, 0, 0.90757],
      "67": [0, 0.7, 0.1689, 0, 0.66619],
      "68": [0, 0.7, 0.09371, 0, 0.77443],
      "69": [0, 0.7, 0.18583, 0, 0.56162],
      "70": [0, 0.7, 0.13634, 0, 0.89544],
      "71": [0, 0.7, 0.17322, 0, 0.60961],
      "72": [0, 0.7, 0.29694, 0, 0.96919],
      "73": [0, 0.7, 0.19189, 0, 0.80907],
      "74": [0.27778, 0.7, 0.19189, 0, 1.05159],
      "75": [0, 0.7, 0.31259, 0, 0.91364],
      "76": [0, 0.7, 0.19189, 0, 0.87373],
      "77": [0, 0.7, 0.15981, 0, 1.08031],
      "78": [0, 0.7, 0.3525, 0, 0.9015],
      "79": [0, 0.7, 0.08078, 0, 0.73787],
      "80": [0, 0.7, 0.08078, 0, 1.01262],
      "81": [0, 0.7, 0.03305, 0, 0.88282],
      "82": [0, 0.7, 0.06259, 0, 0.85],
      "83": [0, 0.7, 0.19189, 0, 0.86767],
      "84": [0, 0.7, 0.29087, 0, 0.74697],
      "85": [0, 0.7, 0.25815, 0, 0.79996],
      "86": [0, 0.7, 0.27523, 0, 0.62204],
      "87": [0, 0.7, 0.27523, 0, 0.80532],
      "88": [0, 0.7, 0.26006, 0, 0.94445],
      "89": [0, 0.7, 0.2939, 0, 0.70961],
      "90": [0, 0.7, 0.24037, 0, 0.8212],
      "160": [0, 0, 0, 0, 0.25]
    },
    "Size1-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "40": [0.35001, 0.85, 0, 0, 0.45834],
      "41": [0.35001, 0.85, 0, 0, 0.45834],
      "47": [0.35001, 0.85, 0, 0, 0.57778],
      "91": [0.35001, 0.85, 0, 0, 0.41667],
      "92": [0.35001, 0.85, 0, 0, 0.57778],
      "93": [0.35001, 0.85, 0, 0, 0.41667],
      "123": [0.35001, 0.85, 0, 0, 0.58334],
      "125": [0.35001, 0.85, 0, 0, 0.58334],
      "160": [0, 0, 0, 0, 0.25],
      "710": [0, 0.72222, 0, 0, 0.55556],
      "732": [0, 0.72222, 0, 0, 0.55556],
      "770": [0, 0.72222, 0, 0, 0.55556],
      "771": [0, 0.72222, 0, 0, 0.55556],
      "8214": [-99e-5, 0.601, 0, 0, 0.77778],
      "8593": [1e-5, 0.6, 0, 0, 0.66667],
      "8595": [1e-5, 0.6, 0, 0, 0.66667],
      "8657": [1e-5, 0.6, 0, 0, 0.77778],
      "8659": [1e-5, 0.6, 0, 0, 0.77778],
      "8719": [0.25001, 0.75, 0, 0, 0.94445],
      "8720": [0.25001, 0.75, 0, 0, 0.94445],
      "8721": [0.25001, 0.75, 0, 0, 1.05556],
      "8730": [0.35001, 0.85, 0, 0, 1],
      "8739": [-599e-5, 0.606, 0, 0, 0.33333],
      "8741": [-599e-5, 0.606, 0, 0, 0.55556],
      "8747": [0.30612, 0.805, 0.19445, 0, 0.47222],
      "8748": [0.306, 0.805, 0.19445, 0, 0.47222],
      "8749": [0.306, 0.805, 0.19445, 0, 0.47222],
      "8750": [0.30612, 0.805, 0.19445, 0, 0.47222],
      "8896": [0.25001, 0.75, 0, 0, 0.83334],
      "8897": [0.25001, 0.75, 0, 0, 0.83334],
      "8898": [0.25001, 0.75, 0, 0, 0.83334],
      "8899": [0.25001, 0.75, 0, 0, 0.83334],
      "8968": [0.35001, 0.85, 0, 0, 0.47222],
      "8969": [0.35001, 0.85, 0, 0, 0.47222],
      "8970": [0.35001, 0.85, 0, 0, 0.47222],
      "8971": [0.35001, 0.85, 0, 0, 0.47222],
      "9168": [-99e-5, 0.601, 0, 0, 0.66667],
      "10216": [0.35001, 0.85, 0, 0, 0.47222],
      "10217": [0.35001, 0.85, 0, 0, 0.47222],
      "10752": [0.25001, 0.75, 0, 0, 1.11111],
      "10753": [0.25001, 0.75, 0, 0, 1.11111],
      "10754": [0.25001, 0.75, 0, 0, 1.11111],
      "10756": [0.25001, 0.75, 0, 0, 0.83334],
      "10758": [0.25001, 0.75, 0, 0, 0.83334]
    },
    "Size2-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "40": [0.65002, 1.15, 0, 0, 0.59722],
      "41": [0.65002, 1.15, 0, 0, 0.59722],
      "47": [0.65002, 1.15, 0, 0, 0.81111],
      "91": [0.65002, 1.15, 0, 0, 0.47222],
      "92": [0.65002, 1.15, 0, 0, 0.81111],
      "93": [0.65002, 1.15, 0, 0, 0.47222],
      "123": [0.65002, 1.15, 0, 0, 0.66667],
      "125": [0.65002, 1.15, 0, 0, 0.66667],
      "160": [0, 0, 0, 0, 0.25],
      "710": [0, 0.75, 0, 0, 1],
      "732": [0, 0.75, 0, 0, 1],
      "770": [0, 0.75, 0, 0, 1],
      "771": [0, 0.75, 0, 0, 1],
      "8719": [0.55001, 1.05, 0, 0, 1.27778],
      "8720": [0.55001, 1.05, 0, 0, 1.27778],
      "8721": [0.55001, 1.05, 0, 0, 1.44445],
      "8730": [0.65002, 1.15, 0, 0, 1],
      "8747": [0.86225, 1.36, 0.44445, 0, 0.55556],
      "8748": [0.862, 1.36, 0.44445, 0, 0.55556],
      "8749": [0.862, 1.36, 0.44445, 0, 0.55556],
      "8750": [0.86225, 1.36, 0.44445, 0, 0.55556],
      "8896": [0.55001, 1.05, 0, 0, 1.11111],
      "8897": [0.55001, 1.05, 0, 0, 1.11111],
      "8898": [0.55001, 1.05, 0, 0, 1.11111],
      "8899": [0.55001, 1.05, 0, 0, 1.11111],
      "8968": [0.65002, 1.15, 0, 0, 0.52778],
      "8969": [0.65002, 1.15, 0, 0, 0.52778],
      "8970": [0.65002, 1.15, 0, 0, 0.52778],
      "8971": [0.65002, 1.15, 0, 0, 0.52778],
      "10216": [0.65002, 1.15, 0, 0, 0.61111],
      "10217": [0.65002, 1.15, 0, 0, 0.61111],
      "10752": [0.55001, 1.05, 0, 0, 1.51112],
      "10753": [0.55001, 1.05, 0, 0, 1.51112],
      "10754": [0.55001, 1.05, 0, 0, 1.51112],
      "10756": [0.55001, 1.05, 0, 0, 1.11111],
      "10758": [0.55001, 1.05, 0, 0, 1.11111]
    },
    "Size3-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "40": [0.95003, 1.45, 0, 0, 0.73611],
      "41": [0.95003, 1.45, 0, 0, 0.73611],
      "47": [0.95003, 1.45, 0, 0, 1.04445],
      "91": [0.95003, 1.45, 0, 0, 0.52778],
      "92": [0.95003, 1.45, 0, 0, 1.04445],
      "93": [0.95003, 1.45, 0, 0, 0.52778],
      "123": [0.95003, 1.45, 0, 0, 0.75],
      "125": [0.95003, 1.45, 0, 0, 0.75],
      "160": [0, 0, 0, 0, 0.25],
      "710": [0, 0.75, 0, 0, 1.44445],
      "732": [0, 0.75, 0, 0, 1.44445],
      "770": [0, 0.75, 0, 0, 1.44445],
      "771": [0, 0.75, 0, 0, 1.44445],
      "8730": [0.95003, 1.45, 0, 0, 1],
      "8968": [0.95003, 1.45, 0, 0, 0.58334],
      "8969": [0.95003, 1.45, 0, 0, 0.58334],
      "8970": [0.95003, 1.45, 0, 0, 0.58334],
      "8971": [0.95003, 1.45, 0, 0, 0.58334],
      "10216": [0.95003, 1.45, 0, 0, 0.75],
      "10217": [0.95003, 1.45, 0, 0, 0.75]
    },
    "Size4-Regular": {
      "32": [0, 0, 0, 0, 0.25],
      "40": [1.25003, 1.75, 0, 0, 0.79167],
      "41": [1.25003, 1.75, 0, 0, 0.79167],
      "47": [1.25003, 1.75, 0, 0, 1.27778],
      "91": [1.25003, 1.75, 0, 0, 0.58334],
      "92": [1.25003, 1.75, 0, 0, 1.27778],
      "93": [1.25003, 1.75, 0, 0, 0.58334],
      "123": [1.25003, 1.75, 0, 0, 0.80556],
      "125": [1.25003, 1.75, 0, 0, 0.80556],
      "160": [0, 0, 0, 0, 0.25],
      "710": [0, 0.825, 0, 0, 1.8889],
      "732": [0, 0.825, 0, 0, 1.8889],
      "770": [0, 0.825, 0, 0, 1.8889],
      "771": [0, 0.825, 0, 0, 1.8889],
      "8730": [1.25003, 1.75, 0, 0, 1],
      "8968": [1.25003, 1.75, 0, 0, 0.63889],
      "8969": [1.25003, 1.75, 0, 0, 0.63889],
      "8970": [1.25003, 1.75, 0, 0, 0.63889],
      "8971": [1.25003, 1.75, 0, 0, 0.63889],
      "9115": [0.64502, 1.155, 0, 0, 0.875],
      "9116": [1e-5, 0.6, 0, 0, 0.875],
      "9117": [0.64502, 1.155, 0, 0, 0.875],
      "9118": [0.64502, 1.155, 0, 0, 0.875],
      "9119": [1e-5, 0.6, 0, 0, 0.875],
      "9120": [0.64502, 1.155, 0, 0, 0.875],
      "9121": [0.64502, 1.155, 0, 0, 0.66667],
      "9122": [-99e-5, 0.601, 0, 0, 0.66667],
      "9123": [0.64502, 1.155, 0, 0, 0.66667],
      "9124": [0.64502, 1.155, 0, 0, 0.66667],
      "9125": [-99e-5, 0.601, 0, 0, 0.66667],
      "9126": [0.64502, 1.155, 0, 0, 0.66667],
      "9127": [1e-5, 0.9, 0, 0, 0.88889],
      "9128": [0.65002, 1.15, 0, 0, 0.88889],
      "9129": [0.90001, 0, 0, 0, 0.88889],
      "9130": [0, 0.3, 0, 0, 0.88889],
      "9131": [1e-5, 0.9, 0, 0, 0.88889],
      "9132": [0.65002, 1.15, 0, 0, 0.88889],
      "9133": [0.90001, 0, 0, 0, 0.88889],
      "9143": [0.88502, 0.915, 0, 0, 1.05556],
      "10216": [1.25003, 1.75, 0, 0, 0.80556],
      "10217": [1.25003, 1.75, 0, 0, 0.80556],
      "57344": [-499e-5, 0.605, 0, 0, 1.05556],
      "57345": [-499e-5, 0.605, 0, 0, 1.05556],
      "57680": [0, 0.12, 0, 0, 0.45],
      "57681": [0, 0.12, 0, 0, 0.45],
      "57682": [0, 0.12, 0, 0, 0.45],
      "57683": [0, 0.12, 0, 0, 0.45]
    },
    "Typewriter-Regular": {
      "32": [0, 0, 0, 0, 0.525],
      "33": [0, 0.61111, 0, 0, 0.525],
      "34": [0, 0.61111, 0, 0, 0.525],
      "35": [0, 0.61111, 0, 0, 0.525],
      "36": [0.08333, 0.69444, 0, 0, 0.525],
      "37": [0.08333, 0.69444, 0, 0, 0.525],
      "38": [0, 0.61111, 0, 0, 0.525],
      "39": [0, 0.61111, 0, 0, 0.525],
      "40": [0.08333, 0.69444, 0, 0, 0.525],
      "41": [0.08333, 0.69444, 0, 0, 0.525],
      "42": [0, 0.52083, 0, 0, 0.525],
      "43": [-0.08056, 0.53055, 0, 0, 0.525],
      "44": [0.13889, 0.125, 0, 0, 0.525],
      "45": [-0.08056, 0.53055, 0, 0, 0.525],
      "46": [0, 0.125, 0, 0, 0.525],
      "47": [0.08333, 0.69444, 0, 0, 0.525],
      "48": [0, 0.61111, 0, 0, 0.525],
      "49": [0, 0.61111, 0, 0, 0.525],
      "50": [0, 0.61111, 0, 0, 0.525],
      "51": [0, 0.61111, 0, 0, 0.525],
      "52": [0, 0.61111, 0, 0, 0.525],
      "53": [0, 0.61111, 0, 0, 0.525],
      "54": [0, 0.61111, 0, 0, 0.525],
      "55": [0, 0.61111, 0, 0, 0.525],
      "56": [0, 0.61111, 0, 0, 0.525],
      "57": [0, 0.61111, 0, 0, 0.525],
      "58": [0, 0.43056, 0, 0, 0.525],
      "59": [0.13889, 0.43056, 0, 0, 0.525],
      "60": [-0.05556, 0.55556, 0, 0, 0.525],
      "61": [-0.19549, 0.41562, 0, 0, 0.525],
      "62": [-0.05556, 0.55556, 0, 0, 0.525],
      "63": [0, 0.61111, 0, 0, 0.525],
      "64": [0, 0.61111, 0, 0, 0.525],
      "65": [0, 0.61111, 0, 0, 0.525],
      "66": [0, 0.61111, 0, 0, 0.525],
      "67": [0, 0.61111, 0, 0, 0.525],
      "68": [0, 0.61111, 0, 0, 0.525],
      "69": [0, 0.61111, 0, 0, 0.525],
      "70": [0, 0.61111, 0, 0, 0.525],
      "71": [0, 0.61111, 0, 0, 0.525],
      "72": [0, 0.61111, 0, 0, 0.525],
      "73": [0, 0.61111, 0, 0, 0.525],
      "74": [0, 0.61111, 0, 0, 0.525],
      "75": [0, 0.61111, 0, 0, 0.525],
      "76": [0, 0.61111, 0, 0, 0.525],
      "77": [0, 0.61111, 0, 0, 0.525],
      "78": [0, 0.61111, 0, 0, 0.525],
      "79": [0, 0.61111, 0, 0, 0.525],
      "80": [0, 0.61111, 0, 0, 0.525],
      "81": [0.13889, 0.61111, 0, 0, 0.525],
      "82": [0, 0.61111, 0, 0, 0.525],
      "83": [0, 0.61111, 0, 0, 0.525],
      "84": [0, 0.61111, 0, 0, 0.525],
      "85": [0, 0.61111, 0, 0, 0.525],
      "86": [0, 0.61111, 0, 0, 0.525],
      "87": [0, 0.61111, 0, 0, 0.525],
      "88": [0, 0.61111, 0, 0, 0.525],
      "89": [0, 0.61111, 0, 0, 0.525],
      "90": [0, 0.61111, 0, 0, 0.525],
      "91": [0.08333, 0.69444, 0, 0, 0.525],
      "92": [0.08333, 0.69444, 0, 0, 0.525],
      "93": [0.08333, 0.69444, 0, 0, 0.525],
      "94": [0, 0.61111, 0, 0, 0.525],
      "95": [0.09514, 0, 0, 0, 0.525],
      "96": [0, 0.61111, 0, 0, 0.525],
      "97": [0, 0.43056, 0, 0, 0.525],
      "98": [0, 0.61111, 0, 0, 0.525],
      "99": [0, 0.43056, 0, 0, 0.525],
      "100": [0, 0.61111, 0, 0, 0.525],
      "101": [0, 0.43056, 0, 0, 0.525],
      "102": [0, 0.61111, 0, 0, 0.525],
      "103": [0.22222, 0.43056, 0, 0, 0.525],
      "104": [0, 0.61111, 0, 0, 0.525],
      "105": [0, 0.61111, 0, 0, 0.525],
      "106": [0.22222, 0.61111, 0, 0, 0.525],
      "107": [0, 0.61111, 0, 0, 0.525],
      "108": [0, 0.61111, 0, 0, 0.525],
      "109": [0, 0.43056, 0, 0, 0.525],
      "110": [0, 0.43056, 0, 0, 0.525],
      "111": [0, 0.43056, 0, 0, 0.525],
      "112": [0.22222, 0.43056, 0, 0, 0.525],
      "113": [0.22222, 0.43056, 0, 0, 0.525],
      "114": [0, 0.43056, 0, 0, 0.525],
      "115": [0, 0.43056, 0, 0, 0.525],
      "116": [0, 0.55358, 0, 0, 0.525],
      "117": [0, 0.43056, 0, 0, 0.525],
      "118": [0, 0.43056, 0, 0, 0.525],
      "119": [0, 0.43056, 0, 0, 0.525],
      "120": [0, 0.43056, 0, 0, 0.525],
      "121": [0.22222, 0.43056, 0, 0, 0.525],
      "122": [0, 0.43056, 0, 0, 0.525],
      "123": [0.08333, 0.69444, 0, 0, 0.525],
      "124": [0.08333, 0.69444, 0, 0, 0.525],
      "125": [0.08333, 0.69444, 0, 0, 0.525],
      "126": [0, 0.61111, 0, 0, 0.525],
      "127": [0, 0.61111, 0, 0, 0.525],
      "160": [0, 0, 0, 0, 0.525],
      "176": [0, 0.61111, 0, 0, 0.525],
      "184": [0.19445, 0, 0, 0, 0.525],
      "305": [0, 0.43056, 0, 0, 0.525],
      "567": [0.22222, 0.43056, 0, 0, 0.525],
      "711": [0, 0.56597, 0, 0, 0.525],
      "713": [0, 0.56555, 0, 0, 0.525],
      "714": [0, 0.61111, 0, 0, 0.525],
      "715": [0, 0.61111, 0, 0, 0.525],
      "728": [0, 0.61111, 0, 0, 0.525],
      "730": [0, 0.61111, 0, 0, 0.525],
      "770": [0, 0.61111, 0, 0, 0.525],
      "771": [0, 0.61111, 0, 0, 0.525],
      "776": [0, 0.61111, 0, 0, 0.525],
      "915": [0, 0.61111, 0, 0, 0.525],
      "916": [0, 0.61111, 0, 0, 0.525],
      "920": [0, 0.61111, 0, 0, 0.525],
      "923": [0, 0.61111, 0, 0, 0.525],
      "926": [0, 0.61111, 0, 0, 0.525],
      "928": [0, 0.61111, 0, 0, 0.525],
      "931": [0, 0.61111, 0, 0, 0.525],
      "933": [0, 0.61111, 0, 0, 0.525],
      "934": [0, 0.61111, 0, 0, 0.525],
      "936": [0, 0.61111, 0, 0, 0.525],
      "937": [0, 0.61111, 0, 0, 0.525],
      "8216": [0, 0.61111, 0, 0, 0.525],
      "8217": [0, 0.61111, 0, 0, 0.525],
      "8242": [0, 0.61111, 0, 0, 0.525],
      "9251": [0.11111, 0.21944, 0, 0, 0.525]
    }
  };
  var sigmasAndXis = {
    slant: [0.25, 0.25, 0.25],
    // sigma1
    space: [0, 0, 0],
    // sigma2
    stretch: [0, 0, 0],
    // sigma3
    shrink: [0, 0, 0],
    // sigma4
    xHeight: [0.431, 0.431, 0.431],
    // sigma5
    quad: [1, 1.171, 1.472],
    // sigma6
    extraSpace: [0, 0, 0],
    // sigma7
    num1: [0.677, 0.732, 0.925],
    // sigma8
    num2: [0.394, 0.384, 0.387],
    // sigma9
    num3: [0.444, 0.471, 0.504],
    // sigma10
    denom1: [0.686, 0.752, 1.025],
    // sigma11
    denom2: [0.345, 0.344, 0.532],
    // sigma12
    sup1: [0.413, 0.503, 0.504],
    // sigma13
    sup2: [0.363, 0.431, 0.404],
    // sigma14
    sup3: [0.289, 0.286, 0.294],
    // sigma15
    sub1: [0.15, 0.143, 0.2],
    // sigma16
    sub2: [0.247, 0.286, 0.4],
    // sigma17
    supDrop: [0.386, 0.353, 0.494],
    // sigma18
    subDrop: [0.05, 0.071, 0.1],
    // sigma19
    delim1: [2.39, 1.7, 1.98],
    // sigma20
    delim2: [1.01, 1.157, 1.42],
    // sigma21
    axisHeight: [0.25, 0.25, 0.25],
    // sigma22
    // These font metrics are extracted from TeX by using tftopl on cmex10.tfm;
    // they correspond to the font parameters of the extension fonts (family 3).
    // See the TeXbook, page 441. In AMSTeX, the extension fonts scale; to
    // match cmex7, we'd use cmex7.tfm values for script and scriptscript
    // values.
    defaultRuleThickness: [0.04, 0.049, 0.049],
    // xi8; cmex7: 0.049
    bigOpSpacing1: [0.111, 0.111, 0.111],
    // xi9
    bigOpSpacing2: [0.166, 0.166, 0.166],
    // xi10
    bigOpSpacing3: [0.2, 0.2, 0.2],
    // xi11
    bigOpSpacing4: [0.6, 0.611, 0.611],
    // xi12; cmex7: 0.611
    bigOpSpacing5: [0.1, 0.143, 0.143],
    // xi13; cmex7: 0.143
    // The \sqrt rule width is taken from the height of the surd character.
    // Since we use the same font at all sizes, this thickness doesn't scale.
    sqrtRuleThickness: [0.04, 0.04, 0.04],
    // This value determines how large a pt is, for metrics which are defined
    // in terms of pts.
    // This value is also used in katex.less; if you change it make sure the
    // values match.
    ptPerEm: [10, 10, 10],
    // The space between adjacent `|` columns in an array definition. From
    // `\showthe\doublerulesep` in LaTeX. Equals 2.0 / ptPerEm.
    doubleRuleSep: [0.2, 0.2, 0.2],
    // The width of separator lines in {array} environments. From
    // `\showthe\arrayrulewidth` in LaTeX. Equals 0.4 / ptPerEm.
    arrayRuleWidth: [0.04, 0.04, 0.04],
    // Two values from LaTeX source2e:
    fboxsep: [0.3, 0.3, 0.3],
    //        3 pt / ptPerEm
    fboxrule: [0.04, 0.04, 0.04]
    // 0.4 pt / ptPerEm
  };
  var extraCharacterMap = {
    // Latin-1
    "Å": "A",
    "Ð": "D",
    "Þ": "o",
    "å": "a",
    "ð": "d",
    "þ": "o",
    // Cyrillic
    "А": "A",
    "Б": "B",
    "В": "B",
    "Г": "F",
    "Д": "A",
    "Е": "E",
    "Ж": "K",
    "З": "3",
    "И": "N",
    "Й": "N",
    "К": "K",
    "Л": "N",
    "М": "M",
    "Н": "H",
    "О": "O",
    "П": "N",
    "Р": "P",
    "С": "C",
    "Т": "T",
    "У": "y",
    "Ф": "O",
    "Х": "X",
    "Ц": "U",
    "Ч": "h",
    "Ш": "W",
    "Щ": "W",
    "Ъ": "B",
    "Ы": "X",
    "Ь": "B",
    "Э": "3",
    "Ю": "X",
    "Я": "R",
    "а": "a",
    "б": "b",
    "в": "a",
    "г": "r",
    "д": "y",
    "е": "e",
    "ж": "m",
    "з": "e",
    "и": "n",
    "й": "n",
    "к": "n",
    "л": "n",
    "м": "m",
    "н": "n",
    "о": "o",
    "п": "n",
    "р": "p",
    "с": "c",
    "т": "o",
    "у": "y",
    "ф": "b",
    "х": "x",
    "ц": "n",
    "ч": "n",
    "ш": "w",
    "щ": "w",
    "ъ": "a",
    "ы": "m",
    "ь": "a",
    "э": "e",
    "ю": "m",
    "я": "r"
  };
  function setFontMetrics(fontName, metrics) {
    fontMetricsData[fontName] = metrics;
  }
  function getCharacterMetrics(character2, font, mode) {
    if (!fontMetricsData[font]) {
      throw new Error("Font metrics not found for font: " + font + ".");
    }
    var ch2 = character2.charCodeAt(0);
    var metrics = fontMetricsData[font][ch2];
    if (!metrics && character2[0] in extraCharacterMap) {
      ch2 = extraCharacterMap[character2[0]].charCodeAt(0);
      metrics = fontMetricsData[font][ch2];
    }
    if (!metrics && mode === "text") {
      if (supportedCodepoint(ch2)) {
        metrics = fontMetricsData[font][77];
      }
    }
    if (metrics) {
      return {
        depth: metrics[0],
        height: metrics[1],
        italic: metrics[2],
        skew: metrics[3],
        width: metrics[4]
      };
    }
  }
  var fontMetricsBySizeIndex = {};
  function getGlobalMetrics(size2) {
    var sizeIndex;
    if (size2 >= 5) {
      sizeIndex = 0;
    } else if (size2 >= 3) {
      sizeIndex = 1;
    } else {
      sizeIndex = 2;
    }
    if (!fontMetricsBySizeIndex[sizeIndex]) {
      var metrics = fontMetricsBySizeIndex[sizeIndex] = {
        cssEmPerMu: sigmasAndXis.quad[sizeIndex] / 18
      };
      for (var key in sigmasAndXis) {
        if (sigmasAndXis.hasOwnProperty(key)) {
          metrics[key] = sigmasAndXis[key][sizeIndex];
        }
      }
    }
    return fontMetricsBySizeIndex[sizeIndex];
  }
  var sizeStyleMap = [
    // Each element contains [textsize, scriptsize, scriptscriptsize].
    // The size mappings are taken from TeX with \normalsize=10pt.
    [1, 1, 1],
    // size1: [5, 5, 5]              \tiny
    [2, 1, 1],
    // size2: [6, 5, 5]
    [3, 1, 1],
    // size3: [7, 5, 5]              \scriptsize
    [4, 2, 1],
    // size4: [8, 6, 5]              \footnotesize
    [5, 2, 1],
    // size5: [9, 6, 5]              \small
    [6, 3, 1],
    // size6: [10, 7, 5]             \normalsize
    [7, 4, 2],
    // size7: [12, 8, 6]             \large
    [8, 6, 3],
    // size8: [14.4, 10, 7]          \Large
    [9, 7, 6],
    // size9: [17.28, 12, 10]        \LARGE
    [10, 8, 7],
    // size10: [20.74, 14.4, 12]     \huge
    [11, 10, 9]
    // size11: [24.88, 20.74, 17.28] \HUGE
  ];
  var sizeMultipliers = [
    // fontMetrics.js:getGlobalMetrics also uses size indexes, so if
    // you change size indexes, change that function.
    0.5,
    0.6,
    0.7,
    0.8,
    0.9,
    1,
    1.2,
    1.44,
    1.728,
    2.074,
    2.488
  ];
  var sizeAtStyle = function sizeAtStyle2(size2, style) {
    return style.size < 2 ? size2 : sizeStyleMap[size2 - 1][style.size - 1];
  };
  class Options {
    // A font family applies to a group of fonts (i.e. SansSerif), while a font
    // represents a specific font (i.e. SansSerif Bold).
    // See: https://tex.stackexchange.com/questions/22350/difference-between-textrm-and-mathrm
    /**
     * The base size index.
     */
    constructor(data) {
      this.style = void 0;
      this.color = void 0;
      this.size = void 0;
      this.textSize = void 0;
      this.phantom = void 0;
      this.font = void 0;
      this.fontFamily = void 0;
      this.fontWeight = void 0;
      this.fontShape = void 0;
      this.sizeMultiplier = void 0;
      this.maxSize = void 0;
      this.minRuleThickness = void 0;
      this._fontMetrics = void 0;
      this.style = data.style;
      this.color = data.color;
      this.size = data.size || Options.BASESIZE;
      this.textSize = data.textSize || this.size;
      this.phantom = !!data.phantom;
      this.font = data.font || "";
      this.fontFamily = data.fontFamily || "";
      this.fontWeight = data.fontWeight || "";
      this.fontShape = data.fontShape || "";
      this.sizeMultiplier = sizeMultipliers[this.size - 1];
      this.maxSize = data.maxSize;
      this.minRuleThickness = data.minRuleThickness;
      this._fontMetrics = void 0;
    }
    /**
     * Returns a new options object with the same properties as "this".  Properties
     * from "extension" will be copied to the new options object.
     */
    extend(extension2) {
      var data = {
        style: this.style,
        size: this.size,
        textSize: this.textSize,
        color: this.color,
        phantom: this.phantom,
        font: this.font,
        fontFamily: this.fontFamily,
        fontWeight: this.fontWeight,
        fontShape: this.fontShape,
        maxSize: this.maxSize,
        minRuleThickness: this.minRuleThickness
      };
      for (var key in extension2) {
        if (extension2.hasOwnProperty(key)) {
          data[key] = extension2[key];
        }
      }
      return new Options(data);
    }
    /**
     * Return an options object with the given style. If `this.style === style`,
     * returns `this`.
     */
    havingStyle(style) {
      if (this.style === style) {
        return this;
      } else {
        return this.extend({
          style,
          size: sizeAtStyle(this.textSize, style)
        });
      }
    }
    /**
     * Return an options object with a cramped version of the current style. If
     * the current style is cramped, returns `this`.
     */
    havingCrampedStyle() {
      return this.havingStyle(this.style.cramp());
    }
    /**
     * Return an options object with the given size and in at least `\textstyle`.
     * Returns `this` if appropriate.
     */
    havingSize(size2) {
      if (this.size === size2 && this.textSize === size2) {
        return this;
      } else {
        return this.extend({
          style: this.style.text(),
          size: size2,
          textSize: size2,
          sizeMultiplier: sizeMultipliers[size2 - 1]
        });
      }
    }
    /**
     * Like `this.havingSize(BASESIZE).havingStyle(style)`. If `style` is omitted,
     * changes to at least `\textstyle`.
     */
    havingBaseStyle(style) {
      style = style || this.style.text();
      var wantSize = sizeAtStyle(Options.BASESIZE, style);
      if (this.size === wantSize && this.textSize === Options.BASESIZE && this.style === style) {
        return this;
      } else {
        return this.extend({
          style,
          size: wantSize
        });
      }
    }
    /**
     * Remove the effect of sizing changes such as \Huge.
     * Keep the effect of the current style, such as \scriptstyle.
     */
    havingBaseSizing() {
      var size2;
      switch (this.style.id) {
        case 4:
        case 5:
          size2 = 3;
          break;
        case 6:
        case 7:
          size2 = 1;
          break;
        default:
          size2 = 6;
      }
      return this.extend({
        style: this.style.text(),
        size: size2
      });
    }
    /**
     * Create a new options object with the given color.
     */
    withColor(color2) {
      return this.extend({
        color: color2
      });
    }
    /**
     * Create a new options object with "phantom" set to true.
     */
    withPhantom() {
      return this.extend({
        phantom: true
      });
    }
    /**
     * Creates a new options object with the given math font or old text font.
     * @type {[type]}
     */
    withFont(font) {
      return this.extend({
        font
      });
    }
    /**
     * Create a new options objects with the given fontFamily.
     */
    withTextFontFamily(fontFamily) {
      return this.extend({
        fontFamily,
        font: ""
      });
    }
    /**
     * Creates a new options object with the given font weight
     */
    withTextFontWeight(fontWeight) {
      return this.extend({
        fontWeight,
        font: ""
      });
    }
    /**
     * Creates a new options object with the given font weight
     */
    withTextFontShape(fontShape) {
      return this.extend({
        fontShape,
        font: ""
      });
    }
    /**
     * Return the CSS sizing classes required to switch from enclosing options
     * `oldOptions` to `this`. Returns an array of classes.
     */
    sizingClasses(oldOptions) {
      if (oldOptions.size !== this.size) {
        return ["sizing", "reset-size" + oldOptions.size, "size" + this.size];
      } else {
        return [];
      }
    }
    /**
     * Return the CSS sizing classes required to switch to the base size. Like
     * `this.havingSize(BASESIZE).sizingClasses(this)`.
     */
    baseSizingClasses() {
      if (this.size !== Options.BASESIZE) {
        return ["sizing", "reset-size" + this.size, "size" + Options.BASESIZE];
      } else {
        return [];
      }
    }
    /**
     * Return the font metrics for this size.
     */
    fontMetrics() {
      if (!this._fontMetrics) {
        this._fontMetrics = getGlobalMetrics(this.size);
      }
      return this._fontMetrics;
    }
    /**
     * Gets the CSS color of the current options object
     */
    getColor() {
      if (this.phantom) {
        return "transparent";
      } else {
        return this.color;
      }
    }
  }
  Options.BASESIZE = 6;
  var ptPerUnit = {
    // https://en.wikibooks.org/wiki/LaTeX/Lengths and
    // https://tex.stackexchange.com/a/8263
    "pt": 1,
    // TeX point
    "mm": 7227 / 2540,
    // millimeter
    "cm": 7227 / 254,
    // centimeter
    "in": 72.27,
    // inch
    "bp": 803 / 800,
    // big (PostScript) points
    "pc": 12,
    // pica
    "dd": 1238 / 1157,
    // didot
    "cc": 14856 / 1157,
    // cicero (12 didot)
    "nd": 685 / 642,
    // new didot
    "nc": 1370 / 107,
    // new cicero (12 new didot)
    "sp": 1 / 65536,
    // scaled point (TeX's internal smallest unit)
    // https://tex.stackexchange.com/a/41371
    "px": 803 / 800
    // \pdfpxdimen defaults to 1 bp in pdfTeX and LuaTeX
  };
  var relativeUnit = {
    "ex": true,
    "em": true,
    "mu": true
  };
  var validUnit = function validUnit2(unit2) {
    if (typeof unit2 !== "string") {
      unit2 = unit2.unit;
    }
    return unit2 in ptPerUnit || unit2 in relativeUnit || unit2 === "ex";
  };
  var calculateSize = function calculateSize2(sizeValue, options2) {
    var scale;
    if (sizeValue.unit in ptPerUnit) {
      scale = ptPerUnit[sizeValue.unit] / options2.fontMetrics().ptPerEm / options2.sizeMultiplier;
    } else if (sizeValue.unit === "mu") {
      scale = options2.fontMetrics().cssEmPerMu;
    } else {
      var unitOptions;
      if (options2.style.isTight()) {
        unitOptions = options2.havingStyle(options2.style.text());
      } else {
        unitOptions = options2;
      }
      if (sizeValue.unit === "ex") {
        scale = unitOptions.fontMetrics().xHeight;
      } else if (sizeValue.unit === "em") {
        scale = unitOptions.fontMetrics().quad;
      } else {
        throw new ParseError("Invalid unit: '" + sizeValue.unit + "'");
      }
      if (unitOptions !== options2) {
        scale *= unitOptions.sizeMultiplier / options2.sizeMultiplier;
      }
    }
    return Math.min(sizeValue.number * scale, options2.maxSize);
  };
  var makeEm = function makeEm2(n) {
    return +n.toFixed(4) + "em";
  };
  var createClass = function createClass2(classes2) {
    return classes2.filter((cls) => cls).join(" ");
  };
  var initNode = function initNode2(classes2, options2, style) {
    this.classes = classes2 || [];
    this.attributes = {};
    this.height = 0;
    this.depth = 0;
    this.maxFontSize = 0;
    this.style = style || {};
    if (options2) {
      if (options2.style.isTight()) {
        this.classes.push("mtight");
      }
      var color2 = options2.getColor();
      if (color2) {
        this.style.color = color2;
      }
    }
  };
  var toNode = function toNode2(tagName) {
    var node2 = document.createElement(tagName);
    node2.className = createClass(this.classes);
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        node2.style[style] = this.style[style];
      }
    }
    for (var attr in this.attributes) {
      if (this.attributes.hasOwnProperty(attr)) {
        node2.setAttribute(attr, this.attributes[attr]);
      }
    }
    for (var i2 = 0; i2 < this.children.length; i2++) {
      node2.appendChild(this.children[i2].toNode());
    }
    return node2;
  };
  var toMarkup = function toMarkup2(tagName) {
    var markup = "<" + tagName;
    if (this.classes.length) {
      markup += ' class="' + utils.escape(createClass(this.classes)) + '"';
    }
    var styles2 = "";
    for (var style in this.style) {
      if (this.style.hasOwnProperty(style)) {
        styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
      }
    }
    if (styles2) {
      markup += ' style="' + utils.escape(styles2) + '"';
    }
    for (var attr in this.attributes) {
      if (this.attributes.hasOwnProperty(attr)) {
        markup += " " + attr + '="' + utils.escape(this.attributes[attr]) + '"';
      }
    }
    markup += ">";
    for (var i2 = 0; i2 < this.children.length; i2++) {
      markup += this.children[i2].toMarkup();
    }
    markup += "</" + tagName + ">";
    return markup;
  };
  class Span {
    constructor(classes2, children2, options2, style) {
      this.children = void 0;
      this.attributes = void 0;
      this.classes = void 0;
      this.height = void 0;
      this.depth = void 0;
      this.width = void 0;
      this.maxFontSize = void 0;
      this.style = void 0;
      initNode.call(this, classes2, options2, style);
      this.children = children2 || [];
    }
    /**
     * Sets an arbitrary attribute on the span. Warning: use this wisely. Not
     * all browsers support attributes the same, and having too many custom
     * attributes is probably bad.
     */
    setAttribute(attribute, value2) {
      this.attributes[attribute] = value2;
    }
    hasClass(className) {
      return utils.contains(this.classes, className);
    }
    toNode() {
      return toNode.call(this, "span");
    }
    toMarkup() {
      return toMarkup.call(this, "span");
    }
  }
  class Anchor {
    constructor(href, classes2, children2, options2) {
      this.children = void 0;
      this.attributes = void 0;
      this.classes = void 0;
      this.height = void 0;
      this.depth = void 0;
      this.maxFontSize = void 0;
      this.style = void 0;
      initNode.call(this, classes2, options2);
      this.children = children2 || [];
      this.setAttribute("href", href);
    }
    setAttribute(attribute, value2) {
      this.attributes[attribute] = value2;
    }
    hasClass(className) {
      return utils.contains(this.classes, className);
    }
    toNode() {
      return toNode.call(this, "a");
    }
    toMarkup() {
      return toMarkup.call(this, "a");
    }
  }
  class Img {
    constructor(src, alt, style) {
      this.src = void 0;
      this.alt = void 0;
      this.classes = void 0;
      this.height = void 0;
      this.depth = void 0;
      this.maxFontSize = void 0;
      this.style = void 0;
      this.alt = alt;
      this.src = src;
      this.classes = ["mord"];
      this.style = style;
    }
    hasClass(className) {
      return utils.contains(this.classes, className);
    }
    toNode() {
      var node2 = document.createElement("img");
      node2.src = this.src;
      node2.alt = this.alt;
      node2.className = "mord";
      for (var style in this.style) {
        if (this.style.hasOwnProperty(style)) {
          node2.style[style] = this.style[style];
        }
      }
      return node2;
    }
    toMarkup() {
      var markup = "<img  src='" + this.src + " 'alt='" + this.alt + "' ";
      var styles2 = "";
      for (var style in this.style) {
        if (this.style.hasOwnProperty(style)) {
          styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
        }
      }
      if (styles2) {
        markup += ' style="' + utils.escape(styles2) + '"';
      }
      markup += "'/>";
      return markup;
    }
  }
  var iCombinations = {
    "î": "ı̂",
    "ï": "ı̈",
    "í": "ı́",
    // 'ī': '\u0131\u0304', // enable when we add Extended Latin
    "ì": "ı̀"
  };
  class SymbolNode {
    constructor(text2, height, depth, italic, skew, width2, classes2, style) {
      this.text = void 0;
      this.height = void 0;
      this.depth = void 0;
      this.italic = void 0;
      this.skew = void 0;
      this.width = void 0;
      this.maxFontSize = void 0;
      this.classes = void 0;
      this.style = void 0;
      this.text = text2;
      this.height = height || 0;
      this.depth = depth || 0;
      this.italic = italic || 0;
      this.skew = skew || 0;
      this.width = width2 || 0;
      this.classes = classes2 || [];
      this.style = style || {};
      this.maxFontSize = 0;
      var script = scriptFromCodepoint(this.text.charCodeAt(0));
      if (script) {
        this.classes.push(script + "_fallback");
      }
      if (/[îïíì]/.test(this.text)) {
        this.text = iCombinations[this.text];
      }
    }
    hasClass(className) {
      return utils.contains(this.classes, className);
    }
    /**
     * Creates a text node or span from a symbol node. Note that a span is only
     * created if it is needed.
     */
    toNode() {
      var node2 = document.createTextNode(this.text);
      var span = null;
      if (this.italic > 0) {
        span = document.createElement("span");
        span.style.marginRight = makeEm(this.italic);
      }
      if (this.classes.length > 0) {
        span = span || document.createElement("span");
        span.className = createClass(this.classes);
      }
      for (var style in this.style) {
        if (this.style.hasOwnProperty(style)) {
          span = span || document.createElement("span");
          span.style[style] = this.style[style];
        }
      }
      if (span) {
        span.appendChild(node2);
        return span;
      } else {
        return node2;
      }
    }
    /**
     * Creates markup for a symbol node.
     */
    toMarkup() {
      var needsSpan = false;
      var markup = "<span";
      if (this.classes.length) {
        needsSpan = true;
        markup += ' class="';
        markup += utils.escape(createClass(this.classes));
        markup += '"';
      }
      var styles2 = "";
      if (this.italic > 0) {
        styles2 += "margin-right:" + this.italic + "em;";
      }
      for (var style in this.style) {
        if (this.style.hasOwnProperty(style)) {
          styles2 += utils.hyphenate(style) + ":" + this.style[style] + ";";
        }
      }
      if (styles2) {
        needsSpan = true;
        markup += ' style="' + utils.escape(styles2) + '"';
      }
      var escaped = utils.escape(this.text);
      if (needsSpan) {
        markup += ">";
        markup += escaped;
        markup += "</span>";
        return markup;
      } else {
        return escaped;
      }
    }
  }
  class SvgNode {
    constructor(children2, attributes) {
      this.children = void 0;
      this.attributes = void 0;
      this.children = children2 || [];
      this.attributes = attributes || {};
    }
    toNode() {
      var svgNS = "http://www.w3.org/2000/svg";
      var node2 = document.createElementNS(svgNS, "svg");
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          node2.setAttribute(attr, this.attributes[attr]);
        }
      }
      for (var i2 = 0; i2 < this.children.length; i2++) {
        node2.appendChild(this.children[i2].toNode());
      }
      return node2;
    }
    toMarkup() {
      var markup = '<svg xmlns="http://www.w3.org/2000/svg"';
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          markup += " " + attr + "='" + this.attributes[attr] + "'";
        }
      }
      markup += ">";
      for (var i2 = 0; i2 < this.children.length; i2++) {
        markup += this.children[i2].toMarkup();
      }
      markup += "</svg>";
      return markup;
    }
  }
  class PathNode {
    constructor(pathName, alternate) {
      this.pathName = void 0;
      this.alternate = void 0;
      this.pathName = pathName;
      this.alternate = alternate;
    }
    toNode() {
      var svgNS = "http://www.w3.org/2000/svg";
      var node2 = document.createElementNS(svgNS, "path");
      if (this.alternate) {
        node2.setAttribute("d", this.alternate);
      } else {
        node2.setAttribute("d", path$1[this.pathName]);
      }
      return node2;
    }
    toMarkup() {
      if (this.alternate) {
        return "<path d='" + this.alternate + "'/>";
      } else {
        return "<path d='" + path$1[this.pathName] + "'/>";
      }
    }
  }
  class LineNode {
    constructor(attributes) {
      this.attributes = void 0;
      this.attributes = attributes || {};
    }
    toNode() {
      var svgNS = "http://www.w3.org/2000/svg";
      var node2 = document.createElementNS(svgNS, "line");
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          node2.setAttribute(attr, this.attributes[attr]);
        }
      }
      return node2;
    }
    toMarkup() {
      var markup = "<line";
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          markup += " " + attr + "='" + this.attributes[attr] + "'";
        }
      }
      markup += "/>";
      return markup;
    }
  }
  function assertSymbolDomNode(group) {
    if (group instanceof SymbolNode) {
      return group;
    } else {
      throw new Error("Expected symbolNode but got " + String(group) + ".");
    }
  }
  function assertSpan(group) {
    if (group instanceof Span) {
      return group;
    } else {
      throw new Error("Expected span<HtmlDomNode> but got " + String(group) + ".");
    }
  }
  var ATOMS = {
    "bin": 1,
    "close": 1,
    "inner": 1,
    "open": 1,
    "punct": 1,
    "rel": 1
  };
  var NON_ATOMS = {
    "accent-token": 1,
    "mathord": 1,
    "op-token": 1,
    "spacing": 1,
    "textord": 1
  };
  var symbols = {
    "math": {},
    "text": {}
  };
  function defineSymbol(mode, font, group, replace2, name, acceptUnicodeChar) {
    symbols[mode][name] = {
      font,
      group,
      replace: replace2
    };
    if (acceptUnicodeChar && replace2) {
      symbols[mode][replace2] = symbols[mode][name];
    }
  }
  var math = "math";
  var text$2 = "text";
  var main = "main";
  var ams = "ams";
  var accent = "accent-token";
  var bin = "bin";
  var close = "close";
  var inner = "inner";
  var mathord = "mathord";
  var op = "op-token";
  var open = "open";
  var punct = "punct";
  var rel = "rel";
  var spacing = "spacing";
  var textord = "textord";
  defineSymbol(math, main, rel, "≡", "\\equiv", true);
  defineSymbol(math, main, rel, "≺", "\\prec", true);
  defineSymbol(math, main, rel, "≻", "\\succ", true);
  defineSymbol(math, main, rel, "∼", "\\sim", true);
  defineSymbol(math, main, rel, "⊥", "\\perp");
  defineSymbol(math, main, rel, "⪯", "\\preceq", true);
  defineSymbol(math, main, rel, "⪰", "\\succeq", true);
  defineSymbol(math, main, rel, "≃", "\\simeq", true);
  defineSymbol(math, main, rel, "∣", "\\mid", true);
  defineSymbol(math, main, rel, "≪", "\\ll", true);
  defineSymbol(math, main, rel, "≫", "\\gg", true);
  defineSymbol(math, main, rel, "≍", "\\asymp", true);
  defineSymbol(math, main, rel, "∥", "\\parallel");
  defineSymbol(math, main, rel, "⋈", "\\bowtie", true);
  defineSymbol(math, main, rel, "⌣", "\\smile", true);
  defineSymbol(math, main, rel, "⊑", "\\sqsubseteq", true);
  defineSymbol(math, main, rel, "⊒", "\\sqsupseteq", true);
  defineSymbol(math, main, rel, "≐", "\\doteq", true);
  defineSymbol(math, main, rel, "⌢", "\\frown", true);
  defineSymbol(math, main, rel, "∋", "\\ni", true);
  defineSymbol(math, main, rel, "∝", "\\propto", true);
  defineSymbol(math, main, rel, "⊢", "\\vdash", true);
  defineSymbol(math, main, rel, "⊣", "\\dashv", true);
  defineSymbol(math, main, rel, "∋", "\\owns");
  defineSymbol(math, main, punct, ".", "\\ldotp");
  defineSymbol(math, main, punct, "⋅", "\\cdotp");
  defineSymbol(math, main, textord, "#", "\\#");
  defineSymbol(text$2, main, textord, "#", "\\#");
  defineSymbol(math, main, textord, "&", "\\&");
  defineSymbol(text$2, main, textord, "&", "\\&");
  defineSymbol(math, main, textord, "ℵ", "\\aleph", true);
  defineSymbol(math, main, textord, "∀", "\\forall", true);
  defineSymbol(math, main, textord, "ℏ", "\\hbar", true);
  defineSymbol(math, main, textord, "∃", "\\exists", true);
  defineSymbol(math, main, textord, "∇", "\\nabla", true);
  defineSymbol(math, main, textord, "♭", "\\flat", true);
  defineSymbol(math, main, textord, "ℓ", "\\ell", true);
  defineSymbol(math, main, textord, "♮", "\\natural", true);
  defineSymbol(math, main, textord, "♣", "\\clubsuit", true);
  defineSymbol(math, main, textord, "℘", "\\wp", true);
  defineSymbol(math, main, textord, "♯", "\\sharp", true);
  defineSymbol(math, main, textord, "♢", "\\diamondsuit", true);
  defineSymbol(math, main, textord, "ℜ", "\\Re", true);
  defineSymbol(math, main, textord, "♡", "\\heartsuit", true);
  defineSymbol(math, main, textord, "ℑ", "\\Im", true);
  defineSymbol(math, main, textord, "♠", "\\spadesuit", true);
  defineSymbol(math, main, textord, "§", "\\S", true);
  defineSymbol(text$2, main, textord, "§", "\\S");
  defineSymbol(math, main, textord, "¶", "\\P", true);
  defineSymbol(text$2, main, textord, "¶", "\\P");
  defineSymbol(math, main, textord, "†", "\\dag");
  defineSymbol(text$2, main, textord, "†", "\\dag");
  defineSymbol(text$2, main, textord, "†", "\\textdagger");
  defineSymbol(math, main, textord, "‡", "\\ddag");
  defineSymbol(text$2, main, textord, "‡", "\\ddag");
  defineSymbol(text$2, main, textord, "‡", "\\textdaggerdbl");
  defineSymbol(math, main, close, "⎱", "\\rmoustache", true);
  defineSymbol(math, main, open, "⎰", "\\lmoustache", true);
  defineSymbol(math, main, close, "⟯", "\\rgroup", true);
  defineSymbol(math, main, open, "⟮", "\\lgroup", true);
  defineSymbol(math, main, bin, "∓", "\\mp", true);
  defineSymbol(math, main, bin, "⊖", "\\ominus", true);
  defineSymbol(math, main, bin, "⊎", "\\uplus", true);
  defineSymbol(math, main, bin, "⊓", "\\sqcap", true);
  defineSymbol(math, main, bin, "∗", "\\ast");
  defineSymbol(math, main, bin, "⊔", "\\sqcup", true);
  defineSymbol(math, main, bin, "◯", "\\bigcirc", true);
  defineSymbol(math, main, bin, "∙", "\\bullet", true);
  defineSymbol(math, main, bin, "‡", "\\ddagger");
  defineSymbol(math, main, bin, "≀", "\\wr", true);
  defineSymbol(math, main, bin, "⨿", "\\amalg");
  defineSymbol(math, main, bin, "&", "\\And");
  defineSymbol(math, main, rel, "⟵", "\\longleftarrow", true);
  defineSymbol(math, main, rel, "⇐", "\\Leftarrow", true);
  defineSymbol(math, main, rel, "⟸", "\\Longleftarrow", true);
  defineSymbol(math, main, rel, "⟶", "\\longrightarrow", true);
  defineSymbol(math, main, rel, "⇒", "\\Rightarrow", true);
  defineSymbol(math, main, rel, "⟹", "\\Longrightarrow", true);
  defineSymbol(math, main, rel, "↔", "\\leftrightarrow", true);
  defineSymbol(math, main, rel, "⟷", "\\longleftrightarrow", true);
  defineSymbol(math, main, rel, "⇔", "\\Leftrightarrow", true);
  defineSymbol(math, main, rel, "⟺", "\\Longleftrightarrow", true);
  defineSymbol(math, main, rel, "↦", "\\mapsto", true);
  defineSymbol(math, main, rel, "⟼", "\\longmapsto", true);
  defineSymbol(math, main, rel, "↗", "\\nearrow", true);
  defineSymbol(math, main, rel, "↩", "\\hookleftarrow", true);
  defineSymbol(math, main, rel, "↪", "\\hookrightarrow", true);
  defineSymbol(math, main, rel, "↘", "\\searrow", true);
  defineSymbol(math, main, rel, "↼", "\\leftharpoonup", true);
  defineSymbol(math, main, rel, "⇀", "\\rightharpoonup", true);
  defineSymbol(math, main, rel, "↙", "\\swarrow", true);
  defineSymbol(math, main, rel, "↽", "\\leftharpoondown", true);
  defineSymbol(math, main, rel, "⇁", "\\rightharpoondown", true);
  defineSymbol(math, main, rel, "↖", "\\nwarrow", true);
  defineSymbol(math, main, rel, "⇌", "\\rightleftharpoons", true);
  defineSymbol(math, ams, rel, "≮", "\\nless", true);
  defineSymbol(math, ams, rel, "", "\\@nleqslant");
  defineSymbol(math, ams, rel, "", "\\@nleqq");
  defineSymbol(math, ams, rel, "⪇", "\\lneq", true);
  defineSymbol(math, ams, rel, "≨", "\\lneqq", true);
  defineSymbol(math, ams, rel, "", "\\@lvertneqq");
  defineSymbol(math, ams, rel, "⋦", "\\lnsim", true);
  defineSymbol(math, ams, rel, "⪉", "\\lnapprox", true);
  defineSymbol(math, ams, rel, "⊀", "\\nprec", true);
  defineSymbol(math, ams, rel, "⋠", "\\npreceq", true);
  defineSymbol(math, ams, rel, "⋨", "\\precnsim", true);
  defineSymbol(math, ams, rel, "⪹", "\\precnapprox", true);
  defineSymbol(math, ams, rel, "≁", "\\nsim", true);
  defineSymbol(math, ams, rel, "", "\\@nshortmid");
  defineSymbol(math, ams, rel, "∤", "\\nmid", true);
  defineSymbol(math, ams, rel, "⊬", "\\nvdash", true);
  defineSymbol(math, ams, rel, "⊭", "\\nvDash", true);
  defineSymbol(math, ams, rel, "⋪", "\\ntriangleleft");
  defineSymbol(math, ams, rel, "⋬", "\\ntrianglelefteq", true);
  defineSymbol(math, ams, rel, "⊊", "\\subsetneq", true);
  defineSymbol(math, ams, rel, "", "\\@varsubsetneq");
  defineSymbol(math, ams, rel, "⫋", "\\subsetneqq", true);
  defineSymbol(math, ams, rel, "", "\\@varsubsetneqq");
  defineSymbol(math, ams, rel, "≯", "\\ngtr", true);
  defineSymbol(math, ams, rel, "", "\\@ngeqslant");
  defineSymbol(math, ams, rel, "", "\\@ngeqq");
  defineSymbol(math, ams, rel, "⪈", "\\gneq", true);
  defineSymbol(math, ams, rel, "≩", "\\gneqq", true);
  defineSymbol(math, ams, rel, "", "\\@gvertneqq");
  defineSymbol(math, ams, rel, "⋧", "\\gnsim", true);
  defineSymbol(math, ams, rel, "⪊", "\\gnapprox", true);
  defineSymbol(math, ams, rel, "⊁", "\\nsucc", true);
  defineSymbol(math, ams, rel, "⋡", "\\nsucceq", true);
  defineSymbol(math, ams, rel, "⋩", "\\succnsim", true);
  defineSymbol(math, ams, rel, "⪺", "\\succnapprox", true);
  defineSymbol(math, ams, rel, "≆", "\\ncong", true);
  defineSymbol(math, ams, rel, "", "\\@nshortparallel");
  defineSymbol(math, ams, rel, "∦", "\\nparallel", true);
  defineSymbol(math, ams, rel, "⊯", "\\nVDash", true);
  defineSymbol(math, ams, rel, "⋫", "\\ntriangleright");
  defineSymbol(math, ams, rel, "⋭", "\\ntrianglerighteq", true);
  defineSymbol(math, ams, rel, "", "\\@nsupseteqq");
  defineSymbol(math, ams, rel, "⊋", "\\supsetneq", true);
  defineSymbol(math, ams, rel, "", "\\@varsupsetneq");
  defineSymbol(math, ams, rel, "⫌", "\\supsetneqq", true);
  defineSymbol(math, ams, rel, "", "\\@varsupsetneqq");
  defineSymbol(math, ams, rel, "⊮", "\\nVdash", true);
  defineSymbol(math, ams, rel, "⪵", "\\precneqq", true);
  defineSymbol(math, ams, rel, "⪶", "\\succneqq", true);
  defineSymbol(math, ams, rel, "", "\\@nsubseteqq");
  defineSymbol(math, ams, bin, "⊴", "\\unlhd");
  defineSymbol(math, ams, bin, "⊵", "\\unrhd");
  defineSymbol(math, ams, rel, "↚", "\\nleftarrow", true);
  defineSymbol(math, ams, rel, "↛", "\\nrightarrow", true);
  defineSymbol(math, ams, rel, "⇍", "\\nLeftarrow", true);
  defineSymbol(math, ams, rel, "⇏", "\\nRightarrow", true);
  defineSymbol(math, ams, rel, "↮", "\\nleftrightarrow", true);
  defineSymbol(math, ams, rel, "⇎", "\\nLeftrightarrow", true);
  defineSymbol(math, ams, rel, "△", "\\vartriangle");
  defineSymbol(math, ams, textord, "ℏ", "\\hslash");
  defineSymbol(math, ams, textord, "▽", "\\triangledown");
  defineSymbol(math, ams, textord, "◊", "\\lozenge");
  defineSymbol(math, ams, textord, "Ⓢ", "\\circledS");
  defineSymbol(math, ams, textord, "®", "\\circledR");
  defineSymbol(text$2, ams, textord, "®", "\\circledR");
  defineSymbol(math, ams, textord, "∡", "\\measuredangle", true);
  defineSymbol(math, ams, textord, "∄", "\\nexists");
  defineSymbol(math, ams, textord, "℧", "\\mho");
  defineSymbol(math, ams, textord, "Ⅎ", "\\Finv", true);
  defineSymbol(math, ams, textord, "⅁", "\\Game", true);
  defineSymbol(math, ams, textord, "‵", "\\backprime");
  defineSymbol(math, ams, textord, "▲", "\\blacktriangle");
  defineSymbol(math, ams, textord, "▼", "\\blacktriangledown");
  defineSymbol(math, ams, textord, "■", "\\blacksquare");
  defineSymbol(math, ams, textord, "⧫", "\\blacklozenge");
  defineSymbol(math, ams, textord, "★", "\\bigstar");
  defineSymbol(math, ams, textord, "∢", "\\sphericalangle", true);
  defineSymbol(math, ams, textord, "∁", "\\complement", true);
  defineSymbol(math, ams, textord, "ð", "\\eth", true);
  defineSymbol(text$2, main, textord, "ð", "ð");
  defineSymbol(math, ams, textord, "╱", "\\diagup");
  defineSymbol(math, ams, textord, "╲", "\\diagdown");
  defineSymbol(math, ams, textord, "□", "\\square");
  defineSymbol(math, ams, textord, "□", "\\Box");
  defineSymbol(math, ams, textord, "◊", "\\Diamond");
  defineSymbol(math, ams, textord, "¥", "\\yen", true);
  defineSymbol(text$2, ams, textord, "¥", "\\yen", true);
  defineSymbol(math, ams, textord, "✓", "\\checkmark", true);
  defineSymbol(text$2, ams, textord, "✓", "\\checkmark");
  defineSymbol(math, ams, textord, "ℶ", "\\beth", true);
  defineSymbol(math, ams, textord, "ℸ", "\\daleth", true);
  defineSymbol(math, ams, textord, "ℷ", "\\gimel", true);
  defineSymbol(math, ams, textord, "ϝ", "\\digamma", true);
  defineSymbol(math, ams, textord, "ϰ", "\\varkappa");
  defineSymbol(math, ams, open, "┌", "\\@ulcorner", true);
  defineSymbol(math, ams, close, "┐", "\\@urcorner", true);
  defineSymbol(math, ams, open, "└", "\\@llcorner", true);
  defineSymbol(math, ams, close, "┘", "\\@lrcorner", true);
  defineSymbol(math, ams, rel, "≦", "\\leqq", true);
  defineSymbol(math, ams, rel, "⩽", "\\leqslant", true);
  defineSymbol(math, ams, rel, "⪕", "\\eqslantless", true);
  defineSymbol(math, ams, rel, "≲", "\\lesssim", true);
  defineSymbol(math, ams, rel, "⪅", "\\lessapprox", true);
  defineSymbol(math, ams, rel, "≊", "\\approxeq", true);
  defineSymbol(math, ams, bin, "⋖", "\\lessdot");
  defineSymbol(math, ams, rel, "⋘", "\\lll", true);
  defineSymbol(math, ams, rel, "≶", "\\lessgtr", true);
  defineSymbol(math, ams, rel, "⋚", "\\lesseqgtr", true);
  defineSymbol(math, ams, rel, "⪋", "\\lesseqqgtr", true);
  defineSymbol(math, ams, rel, "≑", "\\doteqdot");
  defineSymbol(math, ams, rel, "≓", "\\risingdotseq", true);
  defineSymbol(math, ams, rel, "≒", "\\fallingdotseq", true);
  defineSymbol(math, ams, rel, "∽", "\\backsim", true);
  defineSymbol(math, ams, rel, "⋍", "\\backsimeq", true);
  defineSymbol(math, ams, rel, "⫅", "\\subseteqq", true);
  defineSymbol(math, ams, rel, "⋐", "\\Subset", true);
  defineSymbol(math, ams, rel, "⊏", "\\sqsubset", true);
  defineSymbol(math, ams, rel, "≼", "\\preccurlyeq", true);
  defineSymbol(math, ams, rel, "⋞", "\\curlyeqprec", true);
  defineSymbol(math, ams, rel, "≾", "\\precsim", true);
  defineSymbol(math, ams, rel, "⪷", "\\precapprox", true);
  defineSymbol(math, ams, rel, "⊲", "\\vartriangleleft");
  defineSymbol(math, ams, rel, "⊴", "\\trianglelefteq");
  defineSymbol(math, ams, rel, "⊨", "\\vDash", true);
  defineSymbol(math, ams, rel, "⊪", "\\Vvdash", true);
  defineSymbol(math, ams, rel, "⌣", "\\smallsmile");
  defineSymbol(math, ams, rel, "⌢", "\\smallfrown");
  defineSymbol(math, ams, rel, "≏", "\\bumpeq", true);
  defineSymbol(math, ams, rel, "≎", "\\Bumpeq", true);
  defineSymbol(math, ams, rel, "≧", "\\geqq", true);
  defineSymbol(math, ams, rel, "⩾", "\\geqslant", true);
  defineSymbol(math, ams, rel, "⪖", "\\eqslantgtr", true);
  defineSymbol(math, ams, rel, "≳", "\\gtrsim", true);
  defineSymbol(math, ams, rel, "⪆", "\\gtrapprox", true);
  defineSymbol(math, ams, bin, "⋗", "\\gtrdot");
  defineSymbol(math, ams, rel, "⋙", "\\ggg", true);
  defineSymbol(math, ams, rel, "≷", "\\gtrless", true);
  defineSymbol(math, ams, rel, "⋛", "\\gtreqless", true);
  defineSymbol(math, ams, rel, "⪌", "\\gtreqqless", true);
  defineSymbol(math, ams, rel, "≖", "\\eqcirc", true);
  defineSymbol(math, ams, rel, "≗", "\\circeq", true);
  defineSymbol(math, ams, rel, "≜", "\\triangleq", true);
  defineSymbol(math, ams, rel, "∼", "\\thicksim");
  defineSymbol(math, ams, rel, "≈", "\\thickapprox");
  defineSymbol(math, ams, rel, "⫆", "\\supseteqq", true);
  defineSymbol(math, ams, rel, "⋑", "\\Supset", true);
  defineSymbol(math, ams, rel, "⊐", "\\sqsupset", true);
  defineSymbol(math, ams, rel, "≽", "\\succcurlyeq", true);
  defineSymbol(math, ams, rel, "⋟", "\\curlyeqsucc", true);
  defineSymbol(math, ams, rel, "≿", "\\succsim", true);
  defineSymbol(math, ams, rel, "⪸", "\\succapprox", true);
  defineSymbol(math, ams, rel, "⊳", "\\vartriangleright");
  defineSymbol(math, ams, rel, "⊵", "\\trianglerighteq");
  defineSymbol(math, ams, rel, "⊩", "\\Vdash", true);
  defineSymbol(math, ams, rel, "∣", "\\shortmid");
  defineSymbol(math, ams, rel, "∥", "\\shortparallel");
  defineSymbol(math, ams, rel, "≬", "\\between", true);
  defineSymbol(math, ams, rel, "⋔", "\\pitchfork", true);
  defineSymbol(math, ams, rel, "∝", "\\varpropto");
  defineSymbol(math, ams, rel, "◀", "\\blacktriangleleft");
  defineSymbol(math, ams, rel, "∴", "\\therefore", true);
  defineSymbol(math, ams, rel, "∍", "\\backepsilon");
  defineSymbol(math, ams, rel, "▶", "\\blacktriangleright");
  defineSymbol(math, ams, rel, "∵", "\\because", true);
  defineSymbol(math, ams, rel, "⋘", "\\llless");
  defineSymbol(math, ams, rel, "⋙", "\\gggtr");
  defineSymbol(math, ams, bin, "⊲", "\\lhd");
  defineSymbol(math, ams, bin, "⊳", "\\rhd");
  defineSymbol(math, ams, rel, "≂", "\\eqsim", true);
  defineSymbol(math, main, rel, "⋈", "\\Join");
  defineSymbol(math, ams, rel, "≑", "\\Doteq", true);
  defineSymbol(math, ams, bin, "∔", "\\dotplus", true);
  defineSymbol(math, ams, bin, "∖", "\\smallsetminus");
  defineSymbol(math, ams, bin, "⋒", "\\Cap", true);
  defineSymbol(math, ams, bin, "⋓", "\\Cup", true);
  defineSymbol(math, ams, bin, "⩞", "\\doublebarwedge", true);
  defineSymbol(math, ams, bin, "⊟", "\\boxminus", true);
  defineSymbol(math, ams, bin, "⊞", "\\boxplus", true);
  defineSymbol(math, ams, bin, "⋇", "\\divideontimes", true);
  defineSymbol(math, ams, bin, "⋉", "\\ltimes", true);
  defineSymbol(math, ams, bin, "⋊", "\\rtimes", true);
  defineSymbol(math, ams, bin, "⋋", "\\leftthreetimes", true);
  defineSymbol(math, ams, bin, "⋌", "\\rightthreetimes", true);
  defineSymbol(math, ams, bin, "⋏", "\\curlywedge", true);
  defineSymbol(math, ams, bin, "⋎", "\\curlyvee", true);
  defineSymbol(math, ams, bin, "⊝", "\\circleddash", true);
  defineSymbol(math, ams, bin, "⊛", "\\circledast", true);
  defineSymbol(math, ams, bin, "⋅", "\\centerdot");
  defineSymbol(math, ams, bin, "⊺", "\\intercal", true);
  defineSymbol(math, ams, bin, "⋒", "\\doublecap");
  defineSymbol(math, ams, bin, "⋓", "\\doublecup");
  defineSymbol(math, ams, bin, "⊠", "\\boxtimes", true);
  defineSymbol(math, ams, rel, "⇢", "\\dashrightarrow", true);
  defineSymbol(math, ams, rel, "⇠", "\\dashleftarrow", true);
  defineSymbol(math, ams, rel, "⇇", "\\leftleftarrows", true);
  defineSymbol(math, ams, rel, "⇆", "\\leftrightarrows", true);
  defineSymbol(math, ams, rel, "⇚", "\\Lleftarrow", true);
  defineSymbol(math, ams, rel, "↞", "\\twoheadleftarrow", true);
  defineSymbol(math, ams, rel, "↢", "\\leftarrowtail", true);
  defineSymbol(math, ams, rel, "↫", "\\looparrowleft", true);
  defineSymbol(math, ams, rel, "⇋", "\\leftrightharpoons", true);
  defineSymbol(math, ams, rel, "↶", "\\curvearrowleft", true);
  defineSymbol(math, ams, rel, "↺", "\\circlearrowleft", true);
  defineSymbol(math, ams, rel, "↰", "\\Lsh", true);
  defineSymbol(math, ams, rel, "⇈", "\\upuparrows", true);
  defineSymbol(math, ams, rel, "↿", "\\upharpoonleft", true);
  defineSymbol(math, ams, rel, "⇃", "\\downharpoonleft", true);
  defineSymbol(math, main, rel, "⊶", "\\origof", true);
  defineSymbol(math, main, rel, "⊷", "\\imageof", true);
  defineSymbol(math, ams, rel, "⊸", "\\multimap", true);
  defineSymbol(math, ams, rel, "↭", "\\leftrightsquigarrow", true);
  defineSymbol(math, ams, rel, "⇉", "\\rightrightarrows", true);
  defineSymbol(math, ams, rel, "⇄", "\\rightleftarrows", true);
  defineSymbol(math, ams, rel, "↠", "\\twoheadrightarrow", true);
  defineSymbol(math, ams, rel, "↣", "\\rightarrowtail", true);
  defineSymbol(math, ams, rel, "↬", "\\looparrowright", true);
  defineSymbol(math, ams, rel, "↷", "\\curvearrowright", true);
  defineSymbol(math, ams, rel, "↻", "\\circlearrowright", true);
  defineSymbol(math, ams, rel, "↱", "\\Rsh", true);
  defineSymbol(math, ams, rel, "⇊", "\\downdownarrows", true);
  defineSymbol(math, ams, rel, "↾", "\\upharpoonright", true);
  defineSymbol(math, ams, rel, "⇂", "\\downharpoonright", true);
  defineSymbol(math, ams, rel, "⇝", "\\rightsquigarrow", true);
  defineSymbol(math, ams, rel, "⇝", "\\leadsto");
  defineSymbol(math, ams, rel, "⇛", "\\Rrightarrow", true);
  defineSymbol(math, ams, rel, "↾", "\\restriction");
  defineSymbol(math, main, textord, "‘", "`");
  defineSymbol(math, main, textord, "$", "\\$");
  defineSymbol(text$2, main, textord, "$", "\\$");
  defineSymbol(text$2, main, textord, "$", "\\textdollar");
  defineSymbol(math, main, textord, "%", "\\%");
  defineSymbol(text$2, main, textord, "%", "\\%");
  defineSymbol(math, main, textord, "_", "\\_");
  defineSymbol(text$2, main, textord, "_", "\\_");
  defineSymbol(text$2, main, textord, "_", "\\textunderscore");
  defineSymbol(math, main, textord, "∠", "\\angle", true);
  defineSymbol(math, main, textord, "∞", "\\infty", true);
  defineSymbol(math, main, textord, "′", "\\prime");
  defineSymbol(math, main, textord, "△", "\\triangle");
  defineSymbol(math, main, textord, "Γ", "\\Gamma", true);
  defineSymbol(math, main, textord, "Δ", "\\Delta", true);
  defineSymbol(math, main, textord, "Θ", "\\Theta", true);
  defineSymbol(math, main, textord, "Λ", "\\Lambda", true);
  defineSymbol(math, main, textord, "Ξ", "\\Xi", true);
  defineSymbol(math, main, textord, "Π", "\\Pi", true);
  defineSymbol(math, main, textord, "Σ", "\\Sigma", true);
  defineSymbol(math, main, textord, "Υ", "\\Upsilon", true);
  defineSymbol(math, main, textord, "Φ", "\\Phi", true);
  defineSymbol(math, main, textord, "Ψ", "\\Psi", true);
  defineSymbol(math, main, textord, "Ω", "\\Omega", true);
  defineSymbol(math, main, textord, "A", "Α");
  defineSymbol(math, main, textord, "B", "Β");
  defineSymbol(math, main, textord, "E", "Ε");
  defineSymbol(math, main, textord, "Z", "Ζ");
  defineSymbol(math, main, textord, "H", "Η");
  defineSymbol(math, main, textord, "I", "Ι");
  defineSymbol(math, main, textord, "K", "Κ");
  defineSymbol(math, main, textord, "M", "Μ");
  defineSymbol(math, main, textord, "N", "Ν");
  defineSymbol(math, main, textord, "O", "Ο");
  defineSymbol(math, main, textord, "P", "Ρ");
  defineSymbol(math, main, textord, "T", "Τ");
  defineSymbol(math, main, textord, "X", "Χ");
  defineSymbol(math, main, textord, "¬", "\\neg", true);
  defineSymbol(math, main, textord, "¬", "\\lnot");
  defineSymbol(math, main, textord, "⊤", "\\top");
  defineSymbol(math, main, textord, "⊥", "\\bot");
  defineSymbol(math, main, textord, "∅", "\\emptyset");
  defineSymbol(math, ams, textord, "∅", "\\varnothing");
  defineSymbol(math, main, mathord, "α", "\\alpha", true);
  defineSymbol(math, main, mathord, "β", "\\beta", true);
  defineSymbol(math, main, mathord, "γ", "\\gamma", true);
  defineSymbol(math, main, mathord, "δ", "\\delta", true);
  defineSymbol(math, main, mathord, "ϵ", "\\epsilon", true);
  defineSymbol(math, main, mathord, "ζ", "\\zeta", true);
  defineSymbol(math, main, mathord, "η", "\\eta", true);
  defineSymbol(math, main, mathord, "θ", "\\theta", true);
  defineSymbol(math, main, mathord, "ι", "\\iota", true);
  defineSymbol(math, main, mathord, "κ", "\\kappa", true);
  defineSymbol(math, main, mathord, "λ", "\\lambda", true);
  defineSymbol(math, main, mathord, "μ", "\\mu", true);
  defineSymbol(math, main, mathord, "ν", "\\nu", true);
  defineSymbol(math, main, mathord, "ξ", "\\xi", true);
  defineSymbol(math, main, mathord, "ο", "\\omicron", true);
  defineSymbol(math, main, mathord, "π", "\\pi", true);
  defineSymbol(math, main, mathord, "ρ", "\\rho", true);
  defineSymbol(math, main, mathord, "σ", "\\sigma", true);
  defineSymbol(math, main, mathord, "τ", "\\tau", true);
  defineSymbol(math, main, mathord, "υ", "\\upsilon", true);
  defineSymbol(math, main, mathord, "ϕ", "\\phi", true);
  defineSymbol(math, main, mathord, "χ", "\\chi", true);
  defineSymbol(math, main, mathord, "ψ", "\\psi", true);
  defineSymbol(math, main, mathord, "ω", "\\omega", true);
  defineSymbol(math, main, mathord, "ε", "\\varepsilon", true);
  defineSymbol(math, main, mathord, "ϑ", "\\vartheta", true);
  defineSymbol(math, main, mathord, "ϖ", "\\varpi", true);
  defineSymbol(math, main, mathord, "ϱ", "\\varrho", true);
  defineSymbol(math, main, mathord, "ς", "\\varsigma", true);
  defineSymbol(math, main, mathord, "φ", "\\varphi", true);
  defineSymbol(math, main, bin, "∗", "*", true);
  defineSymbol(math, main, bin, "+", "+");
  defineSymbol(math, main, bin, "−", "-", true);
  defineSymbol(math, main, bin, "⋅", "\\cdot", true);
  defineSymbol(math, main, bin, "∘", "\\circ", true);
  defineSymbol(math, main, bin, "÷", "\\div", true);
  defineSymbol(math, main, bin, "±", "\\pm", true);
  defineSymbol(math, main, bin, "×", "\\times", true);
  defineSymbol(math, main, bin, "∩", "\\cap", true);
  defineSymbol(math, main, bin, "∪", "\\cup", true);
  defineSymbol(math, main, bin, "∖", "\\setminus", true);
  defineSymbol(math, main, bin, "∧", "\\land");
  defineSymbol(math, main, bin, "∨", "\\lor");
  defineSymbol(math, main, bin, "∧", "\\wedge", true);
  defineSymbol(math, main, bin, "∨", "\\vee", true);
  defineSymbol(math, main, textord, "√", "\\surd");
  defineSymbol(math, main, open, "⟨", "\\langle", true);
  defineSymbol(math, main, open, "∣", "\\lvert");
  defineSymbol(math, main, open, "∥", "\\lVert");
  defineSymbol(math, main, close, "?", "?");
  defineSymbol(math, main, close, "!", "!");
  defineSymbol(math, main, close, "⟩", "\\rangle", true);
  defineSymbol(math, main, close, "∣", "\\rvert");
  defineSymbol(math, main, close, "∥", "\\rVert");
  defineSymbol(math, main, rel, "=", "=");
  defineSymbol(math, main, rel, ":", ":");
  defineSymbol(math, main, rel, "≈", "\\approx", true);
  defineSymbol(math, main, rel, "≅", "\\cong", true);
  defineSymbol(math, main, rel, "≥", "\\ge");
  defineSymbol(math, main, rel, "≥", "\\geq", true);
  defineSymbol(math, main, rel, "←", "\\gets");
  defineSymbol(math, main, rel, ">", "\\gt", true);
  defineSymbol(math, main, rel, "∈", "\\in", true);
  defineSymbol(math, main, rel, "", "\\@not");
  defineSymbol(math, main, rel, "⊂", "\\subset", true);
  defineSymbol(math, main, rel, "⊃", "\\supset", true);
  defineSymbol(math, main, rel, "⊆", "\\subseteq", true);
  defineSymbol(math, main, rel, "⊇", "\\supseteq", true);
  defineSymbol(math, ams, rel, "⊈", "\\nsubseteq", true);
  defineSymbol(math, ams, rel, "⊉", "\\nsupseteq", true);
  defineSymbol(math, main, rel, "⊨", "\\models");
  defineSymbol(math, main, rel, "←", "\\leftarrow", true);
  defineSymbol(math, main, rel, "≤", "\\le");
  defineSymbol(math, main, rel, "≤", "\\leq", true);
  defineSymbol(math, main, rel, "<", "\\lt", true);
  defineSymbol(math, main, rel, "→", "\\rightarrow", true);
  defineSymbol(math, main, rel, "→", "\\to");
  defineSymbol(math, ams, rel, "≱", "\\ngeq", true);
  defineSymbol(math, ams, rel, "≰", "\\nleq", true);
  defineSymbol(math, main, spacing, " ", "\\ ");
  defineSymbol(math, main, spacing, " ", "\\space");
  defineSymbol(math, main, spacing, " ", "\\nobreakspace");
  defineSymbol(text$2, main, spacing, " ", "\\ ");
  defineSymbol(text$2, main, spacing, " ", " ");
  defineSymbol(text$2, main, spacing, " ", "\\space");
  defineSymbol(text$2, main, spacing, " ", "\\nobreakspace");
  defineSymbol(math, main, spacing, null, "\\nobreak");
  defineSymbol(math, main, spacing, null, "\\allowbreak");
  defineSymbol(math, main, punct, ",", ",");
  defineSymbol(math, main, punct, ";", ";");
  defineSymbol(math, ams, bin, "⊼", "\\barwedge", true);
  defineSymbol(math, ams, bin, "⊻", "\\veebar", true);
  defineSymbol(math, main, bin, "⊙", "\\odot", true);
  defineSymbol(math, main, bin, "⊕", "\\oplus", true);
  defineSymbol(math, main, bin, "⊗", "\\otimes", true);
  defineSymbol(math, main, textord, "∂", "\\partial", true);
  defineSymbol(math, main, bin, "⊘", "\\oslash", true);
  defineSymbol(math, ams, bin, "⊚", "\\circledcirc", true);
  defineSymbol(math, ams, bin, "⊡", "\\boxdot", true);
  defineSymbol(math, main, bin, "△", "\\bigtriangleup");
  defineSymbol(math, main, bin, "▽", "\\bigtriangledown");
  defineSymbol(math, main, bin, "†", "\\dagger");
  defineSymbol(math, main, bin, "⋄", "\\diamond");
  defineSymbol(math, main, bin, "⋆", "\\star");
  defineSymbol(math, main, bin, "◃", "\\triangleleft");
  defineSymbol(math, main, bin, "▹", "\\triangleright");
  defineSymbol(math, main, open, "{", "\\{");
  defineSymbol(text$2, main, textord, "{", "\\{");
  defineSymbol(text$2, main, textord, "{", "\\textbraceleft");
  defineSymbol(math, main, close, "}", "\\}");
  defineSymbol(text$2, main, textord, "}", "\\}");
  defineSymbol(text$2, main, textord, "}", "\\textbraceright");
  defineSymbol(math, main, open, "{", "\\lbrace");
  defineSymbol(math, main, close, "}", "\\rbrace");
  defineSymbol(math, main, open, "[", "\\lbrack", true);
  defineSymbol(text$2, main, textord, "[", "\\lbrack", true);
  defineSymbol(math, main, close, "]", "\\rbrack", true);
  defineSymbol(text$2, main, textord, "]", "\\rbrack", true);
  defineSymbol(math, main, open, "(", "\\lparen", true);
  defineSymbol(math, main, close, ")", "\\rparen", true);
  defineSymbol(text$2, main, textord, "<", "\\textless", true);
  defineSymbol(text$2, main, textord, ">", "\\textgreater", true);
  defineSymbol(math, main, open, "⌊", "\\lfloor", true);
  defineSymbol(math, main, close, "⌋", "\\rfloor", true);
  defineSymbol(math, main, open, "⌈", "\\lceil", true);
  defineSymbol(math, main, close, "⌉", "\\rceil", true);
  defineSymbol(math, main, textord, "\\", "\\backslash");
  defineSymbol(math, main, textord, "∣", "|");
  defineSymbol(math, main, textord, "∣", "\\vert");
  defineSymbol(text$2, main, textord, "|", "\\textbar", true);
  defineSymbol(math, main, textord, "∥", "\\|");
  defineSymbol(math, main, textord, "∥", "\\Vert");
  defineSymbol(text$2, main, textord, "∥", "\\textbardbl");
  defineSymbol(text$2, main, textord, "~", "\\textasciitilde");
  defineSymbol(text$2, main, textord, "\\", "\\textbackslash");
  defineSymbol(text$2, main, textord, "^", "\\textasciicircum");
  defineSymbol(math, main, rel, "↑", "\\uparrow", true);
  defineSymbol(math, main, rel, "⇑", "\\Uparrow", true);
  defineSymbol(math, main, rel, "↓", "\\downarrow", true);
  defineSymbol(math, main, rel, "⇓", "\\Downarrow", true);
  defineSymbol(math, main, rel, "↕", "\\updownarrow", true);
  defineSymbol(math, main, rel, "⇕", "\\Updownarrow", true);
  defineSymbol(math, main, op, "∐", "\\coprod");
  defineSymbol(math, main, op, "⋁", "\\bigvee");
  defineSymbol(math, main, op, "⋀", "\\bigwedge");
  defineSymbol(math, main, op, "⨄", "\\biguplus");
  defineSymbol(math, main, op, "⋂", "\\bigcap");
  defineSymbol(math, main, op, "⋃", "\\bigcup");
  defineSymbol(math, main, op, "∫", "\\int");
  defineSymbol(math, main, op, "∫", "\\intop");
  defineSymbol(math, main, op, "∬", "\\iint");
  defineSymbol(math, main, op, "∭", "\\iiint");
  defineSymbol(math, main, op, "∏", "\\prod");
  defineSymbol(math, main, op, "∑", "\\sum");
  defineSymbol(math, main, op, "⨂", "\\bigotimes");
  defineSymbol(math, main, op, "⨁", "\\bigoplus");
  defineSymbol(math, main, op, "⨀", "\\bigodot");
  defineSymbol(math, main, op, "∮", "\\oint");
  defineSymbol(math, main, op, "∯", "\\oiint");
  defineSymbol(math, main, op, "∰", "\\oiiint");
  defineSymbol(math, main, op, "⨆", "\\bigsqcup");
  defineSymbol(math, main, op, "∫", "\\smallint");
  defineSymbol(text$2, main, inner, "…", "\\textellipsis");
  defineSymbol(math, main, inner, "…", "\\mathellipsis");
  defineSymbol(text$2, main, inner, "…", "\\ldots", true);
  defineSymbol(math, main, inner, "…", "\\ldots", true);
  defineSymbol(math, main, inner, "⋯", "\\@cdots", true);
  defineSymbol(math, main, inner, "⋱", "\\ddots", true);
  defineSymbol(math, main, textord, "⋮", "\\varvdots");
  defineSymbol(math, main, accent, "ˊ", "\\acute");
  defineSymbol(math, main, accent, "ˋ", "\\grave");
  defineSymbol(math, main, accent, "¨", "\\ddot");
  defineSymbol(math, main, accent, "~", "\\tilde");
  defineSymbol(math, main, accent, "ˉ", "\\bar");
  defineSymbol(math, main, accent, "˘", "\\breve");
  defineSymbol(math, main, accent, "ˇ", "\\check");
  defineSymbol(math, main, accent, "^", "\\hat");
  defineSymbol(math, main, accent, "⃗", "\\vec");
  defineSymbol(math, main, accent, "˙", "\\dot");
  defineSymbol(math, main, accent, "˚", "\\mathring");
  defineSymbol(math, main, mathord, "", "\\@imath");
  defineSymbol(math, main, mathord, "", "\\@jmath");
  defineSymbol(math, main, textord, "ı", "ı");
  defineSymbol(math, main, textord, "ȷ", "ȷ");
  defineSymbol(text$2, main, textord, "ı", "\\i", true);
  defineSymbol(text$2, main, textord, "ȷ", "\\j", true);
  defineSymbol(text$2, main, textord, "ß", "\\ss", true);
  defineSymbol(text$2, main, textord, "æ", "\\ae", true);
  defineSymbol(text$2, main, textord, "œ", "\\oe", true);
  defineSymbol(text$2, main, textord, "ø", "\\o", true);
  defineSymbol(text$2, main, textord, "Æ", "\\AE", true);
  defineSymbol(text$2, main, textord, "Œ", "\\OE", true);
  defineSymbol(text$2, main, textord, "Ø", "\\O", true);
  defineSymbol(text$2, main, accent, "ˊ", "\\'");
  defineSymbol(text$2, main, accent, "ˋ", "\\`");
  defineSymbol(text$2, main, accent, "ˆ", "\\^");
  defineSymbol(text$2, main, accent, "˜", "\\~");
  defineSymbol(text$2, main, accent, "ˉ", "\\=");
  defineSymbol(text$2, main, accent, "˘", "\\u");
  defineSymbol(text$2, main, accent, "˙", "\\.");
  defineSymbol(text$2, main, accent, "¸", "\\c");
  defineSymbol(text$2, main, accent, "˚", "\\r");
  defineSymbol(text$2, main, accent, "ˇ", "\\v");
  defineSymbol(text$2, main, accent, "¨", '\\"');
  defineSymbol(text$2, main, accent, "˝", "\\H");
  defineSymbol(text$2, main, accent, "◯", "\\textcircled");
  var ligatures = {
    "--": true,
    "---": true,
    "``": true,
    "''": true
  };
  defineSymbol(text$2, main, textord, "–", "--", true);
  defineSymbol(text$2, main, textord, "–", "\\textendash");
  defineSymbol(text$2, main, textord, "—", "---", true);
  defineSymbol(text$2, main, textord, "—", "\\textemdash");
  defineSymbol(text$2, main, textord, "‘", "`", true);
  defineSymbol(text$2, main, textord, "‘", "\\textquoteleft");
  defineSymbol(text$2, main, textord, "’", "'", true);
  defineSymbol(text$2, main, textord, "’", "\\textquoteright");
  defineSymbol(text$2, main, textord, "“", "``", true);
  defineSymbol(text$2, main, textord, "“", "\\textquotedblleft");
  defineSymbol(text$2, main, textord, "”", "''", true);
  defineSymbol(text$2, main, textord, "”", "\\textquotedblright");
  defineSymbol(math, main, textord, "°", "\\degree", true);
  defineSymbol(text$2, main, textord, "°", "\\degree");
  defineSymbol(text$2, main, textord, "°", "\\textdegree", true);
  defineSymbol(math, main, textord, "£", "\\pounds");
  defineSymbol(math, main, textord, "£", "\\mathsterling", true);
  defineSymbol(text$2, main, textord, "£", "\\pounds");
  defineSymbol(text$2, main, textord, "£", "\\textsterling", true);
  defineSymbol(math, ams, textord, "✠", "\\maltese");
  defineSymbol(text$2, ams, textord, "✠", "\\maltese");
  var mathTextSymbols = '0123456789/@."';
  for (var i = 0; i < mathTextSymbols.length; i++) {
    var ch = mathTextSymbols.charAt(i);
    defineSymbol(math, main, textord, ch, ch);
  }
  var textSymbols = '0123456789!@*()-=+";:?/.,';
  for (var _i = 0; _i < textSymbols.length; _i++) {
    var _ch = textSymbols.charAt(_i);
    defineSymbol(text$2, main, textord, _ch, _ch);
  }
  var letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  for (var _i2 = 0; _i2 < letters.length; _i2++) {
    var _ch2 = letters.charAt(_i2);
    defineSymbol(math, main, mathord, _ch2, _ch2);
    defineSymbol(text$2, main, textord, _ch2, _ch2);
  }
  defineSymbol(math, ams, textord, "C", "ℂ");
  defineSymbol(text$2, ams, textord, "C", "ℂ");
  defineSymbol(math, ams, textord, "H", "ℍ");
  defineSymbol(text$2, ams, textord, "H", "ℍ");
  defineSymbol(math, ams, textord, "N", "ℕ");
  defineSymbol(text$2, ams, textord, "N", "ℕ");
  defineSymbol(math, ams, textord, "P", "ℙ");
  defineSymbol(text$2, ams, textord, "P", "ℙ");
  defineSymbol(math, ams, textord, "Q", "ℚ");
  defineSymbol(text$2, ams, textord, "Q", "ℚ");
  defineSymbol(math, ams, textord, "R", "ℝ");
  defineSymbol(text$2, ams, textord, "R", "ℝ");
  defineSymbol(math, ams, textord, "Z", "ℤ");
  defineSymbol(text$2, ams, textord, "Z", "ℤ");
  defineSymbol(math, main, mathord, "h", "ℎ");
  defineSymbol(text$2, main, mathord, "h", "ℎ");
  var wideChar = "";
  for (var _i3 = 0; _i3 < letters.length; _i3++) {
    var _ch3 = letters.charAt(_i3);
    wideChar = String.fromCharCode(55349, 56320 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56372 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56424 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56580 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56684 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56736 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56788 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56840 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    wideChar = String.fromCharCode(55349, 56944 + _i3);
    defineSymbol(math, main, mathord, _ch3, wideChar);
    defineSymbol(text$2, main, textord, _ch3, wideChar);
    if (_i3 < 26) {
      wideChar = String.fromCharCode(55349, 56632 + _i3);
      defineSymbol(math, main, mathord, _ch3, wideChar);
      defineSymbol(text$2, main, textord, _ch3, wideChar);
      wideChar = String.fromCharCode(55349, 56476 + _i3);
      defineSymbol(math, main, mathord, _ch3, wideChar);
      defineSymbol(text$2, main, textord, _ch3, wideChar);
    }
  }
  wideChar = String.fromCharCode(55349, 56668);
  defineSymbol(math, main, mathord, "k", wideChar);
  defineSymbol(text$2, main, textord, "k", wideChar);
  for (var _i4 = 0; _i4 < 10; _i4++) {
    var _ch4 = _i4.toString();
    wideChar = String.fromCharCode(55349, 57294 + _i4);
    defineSymbol(math, main, mathord, _ch4, wideChar);
    defineSymbol(text$2, main, textord, _ch4, wideChar);
    wideChar = String.fromCharCode(55349, 57314 + _i4);
    defineSymbol(math, main, mathord, _ch4, wideChar);
    defineSymbol(text$2, main, textord, _ch4, wideChar);
    wideChar = String.fromCharCode(55349, 57324 + _i4);
    defineSymbol(math, main, mathord, _ch4, wideChar);
    defineSymbol(text$2, main, textord, _ch4, wideChar);
    wideChar = String.fromCharCode(55349, 57334 + _i4);
    defineSymbol(math, main, mathord, _ch4, wideChar);
    defineSymbol(text$2, main, textord, _ch4, wideChar);
  }
  var extraLatin = "ÐÞþ";
  for (var _i5 = 0; _i5 < extraLatin.length; _i5++) {
    var _ch5 = extraLatin.charAt(_i5);
    defineSymbol(math, main, mathord, _ch5, _ch5);
    defineSymbol(text$2, main, textord, _ch5, _ch5);
  }
  var wideLatinLetterData = [
    ["mathbf", "textbf", "Main-Bold"],
    // A-Z bold upright
    ["mathbf", "textbf", "Main-Bold"],
    // a-z bold upright
    ["mathnormal", "textit", "Math-Italic"],
    // A-Z italic
    ["mathnormal", "textit", "Math-Italic"],
    // a-z italic
    ["boldsymbol", "boldsymbol", "Main-BoldItalic"],
    // A-Z bold italic
    ["boldsymbol", "boldsymbol", "Main-BoldItalic"],
    // a-z bold italic
    // Map fancy A-Z letters to script, not calligraphic.
    // This aligns with unicode-math and math fonts (except Cambria Math).
    ["mathscr", "textscr", "Script-Regular"],
    // A-Z script
    ["", "", ""],
    // a-z script.  No font
    ["", "", ""],
    // A-Z bold script. No font
    ["", "", ""],
    // a-z bold script. No font
    ["mathfrak", "textfrak", "Fraktur-Regular"],
    // A-Z Fraktur
    ["mathfrak", "textfrak", "Fraktur-Regular"],
    // a-z Fraktur
    ["mathbb", "textbb", "AMS-Regular"],
    // A-Z double-struck
    ["mathbb", "textbb", "AMS-Regular"],
    // k double-struck
    // Note that we are using a bold font, but font metrics for regular Fraktur.
    ["mathboldfrak", "textboldfrak", "Fraktur-Regular"],
    // A-Z bold Fraktur
    ["mathboldfrak", "textboldfrak", "Fraktur-Regular"],
    // a-z bold Fraktur
    ["mathsf", "textsf", "SansSerif-Regular"],
    // A-Z sans-serif
    ["mathsf", "textsf", "SansSerif-Regular"],
    // a-z sans-serif
    ["mathboldsf", "textboldsf", "SansSerif-Bold"],
    // A-Z bold sans-serif
    ["mathboldsf", "textboldsf", "SansSerif-Bold"],
    // a-z bold sans-serif
    ["mathitsf", "textitsf", "SansSerif-Italic"],
    // A-Z italic sans-serif
    ["mathitsf", "textitsf", "SansSerif-Italic"],
    // a-z italic sans-serif
    ["", "", ""],
    // A-Z bold italic sans. No font
    ["", "", ""],
    // a-z bold italic sans. No font
    ["mathtt", "texttt", "Typewriter-Regular"],
    // A-Z monospace
    ["mathtt", "texttt", "Typewriter-Regular"]
    // a-z monospace
  ];
  var wideNumeralData = [
    ["mathbf", "textbf", "Main-Bold"],
    // 0-9 bold
    ["", "", ""],
    // 0-9 double-struck. No KaTeX font.
    ["mathsf", "textsf", "SansSerif-Regular"],
    // 0-9 sans-serif
    ["mathboldsf", "textboldsf", "SansSerif-Bold"],
    // 0-9 bold sans-serif
    ["mathtt", "texttt", "Typewriter-Regular"]
    // 0-9 monospace
  ];
  var wideCharacterFont = function wideCharacterFont2(wideChar2, mode) {
    var H = wideChar2.charCodeAt(0);
    var L = wideChar2.charCodeAt(1);
    var codePoint = (H - 55296) * 1024 + (L - 56320) + 65536;
    var j = mode === "math" ? 0 : 1;
    if (119808 <= codePoint && codePoint < 120484) {
      var i2 = Math.floor((codePoint - 119808) / 26);
      return [wideLatinLetterData[i2][2], wideLatinLetterData[i2][j]];
    } else if (120782 <= codePoint && codePoint <= 120831) {
      var _i6 = Math.floor((codePoint - 120782) / 10);
      return [wideNumeralData[_i6][2], wideNumeralData[_i6][j]];
    } else if (codePoint === 120485 || codePoint === 120486) {
      return [wideLatinLetterData[0][2], wideLatinLetterData[0][j]];
    } else if (120486 < codePoint && codePoint < 120782) {
      return ["", ""];
    } else {
      throw new ParseError("Unsupported character: " + wideChar2);
    }
  };
  var lookupSymbol = function lookupSymbol2(value2, fontName, mode) {
    if (symbols[mode][value2] && symbols[mode][value2].replace) {
      value2 = symbols[mode][value2].replace;
    }
    return {
      value: value2,
      metrics: getCharacterMetrics(value2, fontName, mode)
    };
  };
  var makeSymbol = function makeSymbol2(value2, fontName, mode, options2, classes2) {
    var lookup = lookupSymbol(value2, fontName, mode);
    var metrics = lookup.metrics;
    value2 = lookup.value;
    var symbolNode;
    if (metrics) {
      var italic = metrics.italic;
      if (mode === "text" || options2 && options2.font === "mathit") {
        italic = 0;
      }
      symbolNode = new SymbolNode(value2, metrics.height, metrics.depth, italic, metrics.skew, metrics.width, classes2);
    } else {
      typeof console !== "undefined" && console.warn("No character metrics " + ("for '" + value2 + "' in style '" + fontName + "' and mode '" + mode + "'"));
      symbolNode = new SymbolNode(value2, 0, 0, 0, 0, 0, classes2);
    }
    if (options2) {
      symbolNode.maxFontSize = options2.sizeMultiplier;
      if (options2.style.isTight()) {
        symbolNode.classes.push("mtight");
      }
      var color2 = options2.getColor();
      if (color2) {
        symbolNode.style.color = color2;
      }
    }
    return symbolNode;
  };
  var mathsym = function mathsym2(value2, mode, options2, classes2) {
    if (classes2 === void 0) {
      classes2 = [];
    }
    if (options2.font === "boldsymbol" && lookupSymbol(value2, "Main-Bold", mode).metrics) {
      return makeSymbol(value2, "Main-Bold", mode, options2, classes2.concat(["mathbf"]));
    } else if (value2 === "\\" || symbols[mode][value2].font === "main") {
      return makeSymbol(value2, "Main-Regular", mode, options2, classes2);
    } else {
      return makeSymbol(value2, "AMS-Regular", mode, options2, classes2.concat(["amsrm"]));
    }
  };
  var boldsymbol = function boldsymbol2(value2, mode, options2, classes2, type2) {
    if (type2 !== "textord" && lookupSymbol(value2, "Math-BoldItalic", mode).metrics) {
      return {
        fontName: "Math-BoldItalic",
        fontClass: "boldsymbol"
      };
    } else {
      return {
        fontName: "Main-Bold",
        fontClass: "mathbf"
      };
    }
  };
  var makeOrd = function makeOrd2(group, options2, type2) {
    var mode = group.mode;
    var text2 = group.text;
    var classes2 = ["mord"];
    var isFont = mode === "math" || mode === "text" && options2.font;
    var fontOrFamily = isFont ? options2.font : options2.fontFamily;
    var wideFontName = "";
    var wideFontClass = "";
    if (text2.charCodeAt(0) === 55349) {
      [wideFontName, wideFontClass] = wideCharacterFont(text2, mode);
    }
    if (wideFontName.length > 0) {
      return makeSymbol(text2, wideFontName, mode, options2, classes2.concat(wideFontClass));
    } else if (fontOrFamily) {
      var fontName;
      var fontClasses;
      if (fontOrFamily === "boldsymbol") {
        var fontData = boldsymbol(text2, mode, options2, classes2, type2);
        fontName = fontData.fontName;
        fontClasses = [fontData.fontClass];
      } else if (isFont) {
        fontName = fontMap[fontOrFamily].fontName;
        fontClasses = [fontOrFamily];
      } else {
        fontName = retrieveTextFontName(fontOrFamily, options2.fontWeight, options2.fontShape);
        fontClasses = [fontOrFamily, options2.fontWeight, options2.fontShape];
      }
      if (lookupSymbol(text2, fontName, mode).metrics) {
        return makeSymbol(text2, fontName, mode, options2, classes2.concat(fontClasses));
      } else if (ligatures.hasOwnProperty(text2) && fontName.slice(0, 10) === "Typewriter") {
        var parts = [];
        for (var i2 = 0; i2 < text2.length; i2++) {
          parts.push(makeSymbol(text2[i2], fontName, mode, options2, classes2.concat(fontClasses)));
        }
        return makeFragment(parts);
      }
    }
    if (type2 === "mathord") {
      return makeSymbol(text2, "Math-Italic", mode, options2, classes2.concat(["mathnormal"]));
    } else if (type2 === "textord") {
      var font = symbols[mode][text2] && symbols[mode][text2].font;
      if (font === "ams") {
        var _fontName = retrieveTextFontName("amsrm", options2.fontWeight, options2.fontShape);
        return makeSymbol(text2, _fontName, mode, options2, classes2.concat("amsrm", options2.fontWeight, options2.fontShape));
      } else if (font === "main" || !font) {
        var _fontName2 = retrieveTextFontName("textrm", options2.fontWeight, options2.fontShape);
        return makeSymbol(text2, _fontName2, mode, options2, classes2.concat(options2.fontWeight, options2.fontShape));
      } else {
        var _fontName3 = retrieveTextFontName(font, options2.fontWeight, options2.fontShape);
        return makeSymbol(text2, _fontName3, mode, options2, classes2.concat(_fontName3, options2.fontWeight, options2.fontShape));
      }
    } else {
      throw new Error("unexpected type: " + type2 + " in makeOrd");
    }
  };
  var canCombine = (prev2, next2) => {
    if (createClass(prev2.classes) !== createClass(next2.classes) || prev2.skew !== next2.skew || prev2.maxFontSize !== next2.maxFontSize) {
      return false;
    }
    if (prev2.classes.length === 1) {
      var cls = prev2.classes[0];
      if (cls === "mbin" || cls === "mord") {
        return false;
      }
    }
    for (var style in prev2.style) {
      if (prev2.style.hasOwnProperty(style) && prev2.style[style] !== next2.style[style]) {
        return false;
      }
    }
    for (var _style in next2.style) {
      if (next2.style.hasOwnProperty(_style) && prev2.style[_style] !== next2.style[_style]) {
        return false;
      }
    }
    return true;
  };
  var tryCombineChars = (chars) => {
    for (var i2 = 0; i2 < chars.length - 1; i2++) {
      var prev2 = chars[i2];
      var next2 = chars[i2 + 1];
      if (prev2 instanceof SymbolNode && next2 instanceof SymbolNode && canCombine(prev2, next2)) {
        prev2.text += next2.text;
        prev2.height = Math.max(prev2.height, next2.height);
        prev2.depth = Math.max(prev2.depth, next2.depth);
        prev2.italic = next2.italic;
        chars.splice(i2 + 1, 1);
        i2--;
      }
    }
    return chars;
  };
  var sizeElementFromChildren = function sizeElementFromChildren2(elem) {
    var height = 0;
    var depth = 0;
    var maxFontSize = 0;
    for (var i2 = 0; i2 < elem.children.length; i2++) {
      var child = elem.children[i2];
      if (child.height > height) {
        height = child.height;
      }
      if (child.depth > depth) {
        depth = child.depth;
      }
      if (child.maxFontSize > maxFontSize) {
        maxFontSize = child.maxFontSize;
      }
    }
    elem.height = height;
    elem.depth = depth;
    elem.maxFontSize = maxFontSize;
  };
  var makeSpan$2 = function makeSpan2(classes2, children2, options2, style) {
    var span = new Span(classes2, children2, options2, style);
    sizeElementFromChildren(span);
    return span;
  };
  var makeSvgSpan = (classes2, children2, options2, style) => new Span(classes2, children2, options2, style);
  var makeLineSpan = function makeLineSpan2(className, options2, thickness) {
    var line2 = makeSpan$2([className], [], options2);
    line2.height = Math.max(thickness || options2.fontMetrics().defaultRuleThickness, options2.minRuleThickness);
    line2.style.borderBottomWidth = makeEm(line2.height);
    line2.maxFontSize = 1;
    return line2;
  };
  var makeAnchor = function makeAnchor2(href, classes2, children2, options2) {
    var anchor = new Anchor(href, classes2, children2, options2);
    sizeElementFromChildren(anchor);
    return anchor;
  };
  var makeFragment = function makeFragment2(children2) {
    var fragment = new DocumentFragment(children2);
    sizeElementFromChildren(fragment);
    return fragment;
  };
  var wrapFragment = function wrapFragment2(group, options2) {
    if (group instanceof DocumentFragment) {
      return makeSpan$2([], [group], options2);
    }
    return group;
  };
  var getVListChildrenAndDepth = function getVListChildrenAndDepth2(params) {
    if (params.positionType === "individualShift") {
      var oldChildren = params.children;
      var children2 = [oldChildren[0]];
      var _depth = -oldChildren[0].shift - oldChildren[0].elem.depth;
      var currPos = _depth;
      for (var i2 = 1; i2 < oldChildren.length; i2++) {
        var diff = -oldChildren[i2].shift - currPos - oldChildren[i2].elem.depth;
        var size2 = diff - (oldChildren[i2 - 1].elem.height + oldChildren[i2 - 1].elem.depth);
        currPos = currPos + diff;
        children2.push({
          type: "kern",
          size: size2
        });
        children2.push(oldChildren[i2]);
      }
      return {
        children: children2,
        depth: _depth
      };
    }
    var depth;
    if (params.positionType === "top") {
      var bottom2 = params.positionData;
      for (var _i6 = 0; _i6 < params.children.length; _i6++) {
        var child = params.children[_i6];
        bottom2 -= child.type === "kern" ? child.size : child.elem.height + child.elem.depth;
      }
      depth = bottom2;
    } else if (params.positionType === "bottom") {
      depth = -params.positionData;
    } else {
      var firstChild = params.children[0];
      if (firstChild.type !== "elem") {
        throw new Error('First child must have type "elem".');
      }
      if (params.positionType === "shift") {
        depth = -firstChild.elem.depth - params.positionData;
      } else if (params.positionType === "firstBaseline") {
        depth = -firstChild.elem.depth;
      } else {
        throw new Error("Invalid positionType " + params.positionType + ".");
      }
    }
    return {
      children: params.children,
      depth
    };
  };
  var makeVList = function makeVList2(params, options2) {
    var {
      children: children2,
      depth
    } = getVListChildrenAndDepth(params);
    var pstrutSize = 0;
    for (var i2 = 0; i2 < children2.length; i2++) {
      var child = children2[i2];
      if (child.type === "elem") {
        var elem = child.elem;
        pstrutSize = Math.max(pstrutSize, elem.maxFontSize, elem.height);
      }
    }
    pstrutSize += 2;
    var pstrut = makeSpan$2(["pstrut"], []);
    pstrut.style.height = makeEm(pstrutSize);
    var realChildren = [];
    var minPos = depth;
    var maxPos2 = depth;
    var currPos = depth;
    for (var _i22 = 0; _i22 < children2.length; _i22++) {
      var _child = children2[_i22];
      if (_child.type === "kern") {
        currPos += _child.size;
      } else {
        var _elem = _child.elem;
        var classes2 = _child.wrapperClasses || [];
        var style = _child.wrapperStyle || {};
        var childWrap = makeSpan$2(classes2, [pstrut, _elem], void 0, style);
        childWrap.style.top = makeEm(-pstrutSize - currPos - _elem.depth);
        if (_child.marginLeft) {
          childWrap.style.marginLeft = _child.marginLeft;
        }
        if (_child.marginRight) {
          childWrap.style.marginRight = _child.marginRight;
        }
        realChildren.push(childWrap);
        currPos += _elem.height + _elem.depth;
      }
      minPos = Math.min(minPos, currPos);
      maxPos2 = Math.max(maxPos2, currPos);
    }
    var vlist = makeSpan$2(["vlist"], realChildren);
    vlist.style.height = makeEm(maxPos2);
    var rows;
    if (minPos < 0) {
      var emptySpan = makeSpan$2([], []);
      var depthStrut = makeSpan$2(["vlist"], [emptySpan]);
      depthStrut.style.height = makeEm(-minPos);
      var topStrut = makeSpan$2(["vlist-s"], [new SymbolNode("​")]);
      rows = [makeSpan$2(["vlist-r"], [vlist, topStrut]), makeSpan$2(["vlist-r"], [depthStrut])];
    } else {
      rows = [makeSpan$2(["vlist-r"], [vlist])];
    }
    var vtable = makeSpan$2(["vlist-t"], rows);
    if (rows.length === 2) {
      vtable.classes.push("vlist-t2");
    }
    vtable.height = maxPos2;
    vtable.depth = -minPos;
    return vtable;
  };
  var makeGlue = (measurement, options2) => {
    var rule = makeSpan$2(["mspace"], [], options2);
    var size2 = calculateSize(measurement, options2);
    rule.style.marginRight = makeEm(size2);
    return rule;
  };
  var retrieveTextFontName = function retrieveTextFontName2(fontFamily, fontWeight, fontShape) {
    var baseFontName = "";
    switch (fontFamily) {
      case "amsrm":
        baseFontName = "AMS";
        break;
      case "textrm":
        baseFontName = "Main";
        break;
      case "textsf":
        baseFontName = "SansSerif";
        break;
      case "texttt":
        baseFontName = "Typewriter";
        break;
      default:
        baseFontName = fontFamily;
    }
    var fontStylesName;
    if (fontWeight === "textbf" && fontShape === "textit") {
      fontStylesName = "BoldItalic";
    } else if (fontWeight === "textbf") {
      fontStylesName = "Bold";
    } else if (fontWeight === "textit") {
      fontStylesName = "Italic";
    } else {
      fontStylesName = "Regular";
    }
    return baseFontName + "-" + fontStylesName;
  };
  var fontMap = {
    // styles
    "mathbf": {
      variant: "bold",
      fontName: "Main-Bold"
    },
    "mathrm": {
      variant: "normal",
      fontName: "Main-Regular"
    },
    "textit": {
      variant: "italic",
      fontName: "Main-Italic"
    },
    "mathit": {
      variant: "italic",
      fontName: "Main-Italic"
    },
    "mathnormal": {
      variant: "italic",
      fontName: "Math-Italic"
    },
    // "boldsymbol" is missing because they require the use of multiple fonts:
    // Math-BoldItalic and Main-Bold.  This is handled by a special case in
    // makeOrd which ends up calling boldsymbol.
    // families
    "mathbb": {
      variant: "double-struck",
      fontName: "AMS-Regular"
    },
    "mathcal": {
      variant: "script",
      fontName: "Caligraphic-Regular"
    },
    "mathfrak": {
      variant: "fraktur",
      fontName: "Fraktur-Regular"
    },
    "mathscr": {
      variant: "script",
      fontName: "Script-Regular"
    },
    "mathsf": {
      variant: "sans-serif",
      fontName: "SansSerif-Regular"
    },
    "mathtt": {
      variant: "monospace",
      fontName: "Typewriter-Regular"
    }
  };
  var svgData = {
    //   path, width, height
    vec: ["vec", 0.471, 0.714],
    // values from the font glyph
    oiintSize1: ["oiintSize1", 0.957, 0.499],
    // oval to overlay the integrand
    oiintSize2: ["oiintSize2", 1.472, 0.659],
    oiiintSize1: ["oiiintSize1", 1.304, 0.499],
    oiiintSize2: ["oiiintSize2", 1.98, 0.659]
  };
  var staticSvg = function staticSvg2(value2, options2) {
    var [pathName, width2, height] = svgData[value2];
    var path2 = new PathNode(pathName);
    var svgNode2 = new SvgNode([path2], {
      "width": makeEm(width2),
      "height": makeEm(height),
      // Override CSS rule `.katex svg { width: 100% }`
      "style": "width:" + makeEm(width2),
      "viewBox": "0 0 " + 1e3 * width2 + " " + 1e3 * height,
      "preserveAspectRatio": "xMinYMin"
    });
    var span = makeSvgSpan(["overlay"], [svgNode2], options2);
    span.height = height;
    span.style.height = makeEm(height);
    span.style.width = makeEm(width2);
    return span;
  };
  var buildCommon = {
    fontMap,
    makeSymbol,
    mathsym,
    makeSpan: makeSpan$2,
    makeSvgSpan,
    makeLineSpan,
    makeAnchor,
    makeFragment,
    wrapFragment,
    makeVList,
    makeOrd,
    makeGlue,
    staticSvg,
    svgData,
    tryCombineChars
  };
  var thinspace = {
    number: 3,
    unit: "mu"
  };
  var mediumspace = {
    number: 4,
    unit: "mu"
  };
  var thickspace = {
    number: 5,
    unit: "mu"
  };
  var spacings = {
    mord: {
      mop: thinspace,
      mbin: mediumspace,
      mrel: thickspace,
      minner: thinspace
    },
    mop: {
      mord: thinspace,
      mop: thinspace,
      mrel: thickspace,
      minner: thinspace
    },
    mbin: {
      mord: mediumspace,
      mop: mediumspace,
      mopen: mediumspace,
      minner: mediumspace
    },
    mrel: {
      mord: thickspace,
      mop: thickspace,
      mopen: thickspace,
      minner: thickspace
    },
    mopen: {},
    mclose: {
      mop: thinspace,
      mbin: mediumspace,
      mrel: thickspace,
      minner: thinspace
    },
    mpunct: {
      mord: thinspace,
      mop: thinspace,
      mrel: thickspace,
      mopen: thinspace,
      mclose: thinspace,
      mpunct: thinspace,
      minner: thinspace
    },
    minner: {
      mord: thinspace,
      mop: thinspace,
      mbin: mediumspace,
      mrel: thickspace,
      mopen: thinspace,
      mpunct: thinspace,
      minner: thinspace
    }
  };
  var tightSpacings = {
    mord: {
      mop: thinspace
    },
    mop: {
      mord: thinspace,
      mop: thinspace
    },
    mbin: {},
    mrel: {},
    mopen: {},
    mclose: {
      mop: thinspace
    },
    mpunct: {},
    minner: {
      mop: thinspace
    }
  };
  var _functions = {};
  var _htmlGroupBuilders = {};
  var _mathmlGroupBuilders = {};
  function defineFunction(_ref) {
    var {
      type: type2,
      names,
      props,
      handler,
      htmlBuilder: htmlBuilder2,
      mathmlBuilder: mathmlBuilder2
    } = _ref;
    var data = {
      type: type2,
      numArgs: props.numArgs,
      argTypes: props.argTypes,
      allowedInArgument: !!props.allowedInArgument,
      allowedInText: !!props.allowedInText,
      allowedInMath: props.allowedInMath === void 0 ? true : props.allowedInMath,
      numOptionalArgs: props.numOptionalArgs || 0,
      infix: !!props.infix,
      primitive: !!props.primitive,
      handler
    };
    for (var i2 = 0; i2 < names.length; ++i2) {
      _functions[names[i2]] = data;
    }
    if (type2) {
      if (htmlBuilder2) {
        _htmlGroupBuilders[type2] = htmlBuilder2;
      }
      if (mathmlBuilder2) {
        _mathmlGroupBuilders[type2] = mathmlBuilder2;
      }
    }
  }
  function defineFunctionBuilders(_ref2) {
    var {
      type: type2,
      htmlBuilder: htmlBuilder2,
      mathmlBuilder: mathmlBuilder2
    } = _ref2;
    defineFunction({
      type: type2,
      names: [],
      props: {
        numArgs: 0
      },
      handler() {
        throw new Error("Should never be called.");
      },
      htmlBuilder: htmlBuilder2,
      mathmlBuilder: mathmlBuilder2
    });
  }
  var normalizeArgument = function normalizeArgument2(arg) {
    return arg.type === "ordgroup" && arg.body.length === 1 ? arg.body[0] : arg;
  };
  var ordargument = function ordargument2(arg) {
    return arg.type === "ordgroup" ? arg.body : [arg];
  };
  var makeSpan$1 = buildCommon.makeSpan;
  var binLeftCanceller = ["leftmost", "mbin", "mopen", "mrel", "mop", "mpunct"];
  var binRightCanceller = ["rightmost", "mrel", "mclose", "mpunct"];
  var styleMap$1 = {
    "display": Style$1.DISPLAY,
    "text": Style$1.TEXT,
    "script": Style$1.SCRIPT,
    "scriptscript": Style$1.SCRIPTSCRIPT
  };
  var DomEnum = {
    mord: "mord",
    mop: "mop",
    mbin: "mbin",
    mrel: "mrel",
    mopen: "mopen",
    mclose: "mclose",
    mpunct: "mpunct",
    minner: "minner"
  };
  var buildExpression$1 = function buildExpression2(expression, options2, isRealGroup, surrounding) {
    if (surrounding === void 0) {
      surrounding = [null, null];
    }
    var groups = [];
    for (var i2 = 0; i2 < expression.length; i2++) {
      var output = buildGroup$1(expression[i2], options2);
      if (output instanceof DocumentFragment) {
        var children2 = output.children;
        groups.push(...children2);
      } else {
        groups.push(output);
      }
    }
    buildCommon.tryCombineChars(groups);
    if (!isRealGroup) {
      return groups;
    }
    var glueOptions = options2;
    if (expression.length === 1) {
      var node2 = expression[0];
      if (node2.type === "sizing") {
        glueOptions = options2.havingSize(node2.size);
      } else if (node2.type === "styling") {
        glueOptions = options2.havingStyle(styleMap$1[node2.style]);
      }
    }
    var dummyPrev = makeSpan$1([surrounding[0] || "leftmost"], [], options2);
    var dummyNext = makeSpan$1([surrounding[1] || "rightmost"], [], options2);
    var isRoot = isRealGroup === "root";
    traverseNonSpaceNodes(groups, (node3, prev2) => {
      var prevType = prev2.classes[0];
      var type2 = node3.classes[0];
      if (prevType === "mbin" && utils.contains(binRightCanceller, type2)) {
        prev2.classes[0] = "mord";
      } else if (type2 === "mbin" && utils.contains(binLeftCanceller, prevType)) {
        node3.classes[0] = "mord";
      }
    }, {
      node: dummyPrev
    }, dummyNext, isRoot);
    traverseNonSpaceNodes(groups, (node3, prev2) => {
      var prevType = getTypeOfDomTree(prev2);
      var type2 = getTypeOfDomTree(node3);
      var space = prevType && type2 ? node3.hasClass("mtight") ? tightSpacings[prevType][type2] : spacings[prevType][type2] : null;
      if (space) {
        return buildCommon.makeGlue(space, glueOptions);
      }
    }, {
      node: dummyPrev
    }, dummyNext, isRoot);
    return groups;
  };
  var traverseNonSpaceNodes = function traverseNonSpaceNodes2(nodes2, callback, prev2, next2, isRoot) {
    if (next2) {
      nodes2.push(next2);
    }
    var i2 = 0;
    for (; i2 < nodes2.length; i2++) {
      var node2 = nodes2[i2];
      var partialGroup = checkPartialGroup(node2);
      if (partialGroup) {
        traverseNonSpaceNodes2(partialGroup.children, callback, prev2, null, isRoot);
        continue;
      }
      var nonspace = !node2.hasClass("mspace");
      if (nonspace) {
        var result = callback(node2, prev2.node);
        if (result) {
          if (prev2.insertAfter) {
            prev2.insertAfter(result);
          } else {
            nodes2.unshift(result);
            i2++;
          }
        }
      }
      if (nonspace) {
        prev2.node = node2;
      } else if (isRoot && node2.hasClass("newline")) {
        prev2.node = makeSpan$1(["leftmost"]);
      }
      prev2.insertAfter = ((index2) => (n) => {
        nodes2.splice(index2 + 1, 0, n);
        i2++;
      })(i2);
    }
    if (next2) {
      nodes2.pop();
    }
  };
  var checkPartialGroup = function checkPartialGroup2(node2) {
    if (node2 instanceof DocumentFragment || node2 instanceof Anchor || node2 instanceof Span && node2.hasClass("enclosing")) {
      return node2;
    }
    return null;
  };
  var getOutermostNode = function getOutermostNode2(node2, side) {
    var partialGroup = checkPartialGroup(node2);
    if (partialGroup) {
      var children2 = partialGroup.children;
      if (children2.length) {
        if (side === "right") {
          return getOutermostNode2(children2[children2.length - 1], "right");
        } else if (side === "left") {
          return getOutermostNode2(children2[0], "left");
        }
      }
    }
    return node2;
  };
  var getTypeOfDomTree = function getTypeOfDomTree2(node2, side) {
    if (!node2) {
      return null;
    }
    if (side) {
      node2 = getOutermostNode(node2, side);
    }
    return DomEnum[node2.classes[0]] || null;
  };
  var makeNullDelimiter = function makeNullDelimiter2(options2, classes2) {
    var moreClasses = ["nulldelimiter"].concat(options2.baseSizingClasses());
    return makeSpan$1(classes2.concat(moreClasses));
  };
  var buildGroup$1 = function buildGroup2(group, options2, baseOptions) {
    if (!group) {
      return makeSpan$1();
    }
    if (_htmlGroupBuilders[group.type]) {
      var groupNode = _htmlGroupBuilders[group.type](group, options2);
      if (baseOptions && options2.size !== baseOptions.size) {
        groupNode = makeSpan$1(options2.sizingClasses(baseOptions), [groupNode], options2);
        var multiplier = options2.sizeMultiplier / baseOptions.sizeMultiplier;
        groupNode.height *= multiplier;
        groupNode.depth *= multiplier;
      }
      return groupNode;
    } else {
      throw new ParseError("Got group of unknown type: '" + group.type + "'");
    }
  };
  function buildHTMLUnbreakable(children2, options2) {
    var body = makeSpan$1(["base"], children2, options2);
    var strut = makeSpan$1(["strut"]);
    strut.style.height = makeEm(body.height + body.depth);
    if (body.depth) {
      strut.style.verticalAlign = makeEm(-body.depth);
    }
    body.children.unshift(strut);
    return body;
  }
  function buildHTML(tree, options2) {
    var tag = null;
    if (tree.length === 1 && tree[0].type === "tag") {
      tag = tree[0].tag;
      tree = tree[0].body;
    }
    var expression = buildExpression$1(tree, options2, "root");
    var eqnNum;
    if (expression.length === 2 && expression[1].hasClass("tag")) {
      eqnNum = expression.pop();
    }
    var children2 = [];
    var parts = [];
    for (var i2 = 0; i2 < expression.length; i2++) {
      parts.push(expression[i2]);
      if (expression[i2].hasClass("mbin") || expression[i2].hasClass("mrel") || expression[i2].hasClass("allowbreak")) {
        var nobreak = false;
        while (i2 < expression.length - 1 && expression[i2 + 1].hasClass("mspace") && !expression[i2 + 1].hasClass("newline")) {
          i2++;
          parts.push(expression[i2]);
          if (expression[i2].hasClass("nobreak")) {
            nobreak = true;
          }
        }
        if (!nobreak) {
          children2.push(buildHTMLUnbreakable(parts, options2));
          parts = [];
        }
      } else if (expression[i2].hasClass("newline")) {
        parts.pop();
        if (parts.length > 0) {
          children2.push(buildHTMLUnbreakable(parts, options2));
          parts = [];
        }
        children2.push(expression[i2]);
      }
    }
    if (parts.length > 0) {
      children2.push(buildHTMLUnbreakable(parts, options2));
    }
    var tagChild;
    if (tag) {
      tagChild = buildHTMLUnbreakable(buildExpression$1(tag, options2, true));
      tagChild.classes = ["tag"];
      children2.push(tagChild);
    } else if (eqnNum) {
      children2.push(eqnNum);
    }
    var htmlNode = makeSpan$1(["katex-html"], children2);
    htmlNode.setAttribute("aria-hidden", "true");
    if (tagChild) {
      var strut = tagChild.children[0];
      strut.style.height = makeEm(htmlNode.height + htmlNode.depth);
      if (htmlNode.depth) {
        strut.style.verticalAlign = makeEm(-htmlNode.depth);
      }
    }
    return htmlNode;
  }
  function newDocumentFragment(children2) {
    return new DocumentFragment(children2);
  }
  class MathNode {
    constructor(type2, children2, classes2) {
      this.type = void 0;
      this.attributes = void 0;
      this.children = void 0;
      this.classes = void 0;
      this.type = type2;
      this.attributes = {};
      this.children = children2 || [];
      this.classes = classes2 || [];
    }
    /**
     * Sets an attribute on a MathML node. MathML depends on attributes to convey a
     * semantic content, so this is used heavily.
     */
    setAttribute(name, value2) {
      this.attributes[name] = value2;
    }
    /**
     * Gets an attribute on a MathML node.
     */
    getAttribute(name) {
      return this.attributes[name];
    }
    /**
     * Converts the math node into a MathML-namespaced DOM element.
     */
    toNode() {
      var node2 = document.createElementNS("http://www.w3.org/1998/Math/MathML", this.type);
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          node2.setAttribute(attr, this.attributes[attr]);
        }
      }
      if (this.classes.length > 0) {
        node2.className = createClass(this.classes);
      }
      for (var i2 = 0; i2 < this.children.length; i2++) {
        node2.appendChild(this.children[i2].toNode());
      }
      return node2;
    }
    /**
     * Converts the math node into an HTML markup string.
     */
    toMarkup() {
      var markup = "<" + this.type;
      for (var attr in this.attributes) {
        if (Object.prototype.hasOwnProperty.call(this.attributes, attr)) {
          markup += " " + attr + '="';
          markup += utils.escape(this.attributes[attr]);
          markup += '"';
        }
      }
      if (this.classes.length > 0) {
        markup += ' class ="' + utils.escape(createClass(this.classes)) + '"';
      }
      markup += ">";
      for (var i2 = 0; i2 < this.children.length; i2++) {
        markup += this.children[i2].toMarkup();
      }
      markup += "</" + this.type + ">";
      return markup;
    }
    /**
     * Converts the math node into a string, similar to innerText, but escaped.
     */
    toText() {
      return this.children.map((child) => child.toText()).join("");
    }
  }
  class TextNode {
    constructor(text2) {
      this.text = void 0;
      this.text = text2;
    }
    /**
     * Converts the text node into a DOM text node.
     */
    toNode() {
      return document.createTextNode(this.text);
    }
    /**
     * Converts the text node into escaped HTML markup
     * (representing the text itself).
     */
    toMarkup() {
      return utils.escape(this.toText());
    }
    /**
     * Converts the text node into a string
     * (representing the text itself).
     */
    toText() {
      return this.text;
    }
  }
  class SpaceNode {
    /**
     * Create a Space node with width given in CSS ems.
     */
    constructor(width2) {
      this.width = void 0;
      this.character = void 0;
      this.width = width2;
      if (width2 >= 0.05555 && width2 <= 0.05556) {
        this.character = " ";
      } else if (width2 >= 0.1666 && width2 <= 0.1667) {
        this.character = " ";
      } else if (width2 >= 0.2222 && width2 <= 0.2223) {
        this.character = " ";
      } else if (width2 >= 0.2777 && width2 <= 0.2778) {
        this.character = "  ";
      } else if (width2 >= -0.05556 && width2 <= -0.05555) {
        this.character = " ⁣";
      } else if (width2 >= -0.1667 && width2 <= -0.1666) {
        this.character = " ⁣";
      } else if (width2 >= -0.2223 && width2 <= -0.2222) {
        this.character = " ⁣";
      } else if (width2 >= -0.2778 && width2 <= -0.2777) {
        this.character = " ⁣";
      } else {
        this.character = null;
      }
    }
    /**
     * Converts the math node into a MathML-namespaced DOM element.
     */
    toNode() {
      if (this.character) {
        return document.createTextNode(this.character);
      } else {
        var node2 = document.createElementNS("http://www.w3.org/1998/Math/MathML", "mspace");
        node2.setAttribute("width", makeEm(this.width));
        return node2;
      }
    }
    /**
     * Converts the math node into an HTML markup string.
     */
    toMarkup() {
      if (this.character) {
        return "<mtext>" + this.character + "</mtext>";
      } else {
        return '<mspace width="' + makeEm(this.width) + '"/>';
      }
    }
    /**
     * Converts the math node into a string, similar to innerText.
     */
    toText() {
      if (this.character) {
        return this.character;
      } else {
        return " ";
      }
    }
  }
  var mathMLTree = {
    MathNode,
    TextNode,
    SpaceNode,
    newDocumentFragment
  };
  var makeText = function makeText2(text2, mode, options2) {
    if (symbols[mode][text2] && symbols[mode][text2].replace && text2.charCodeAt(0) !== 55349 && !(ligatures.hasOwnProperty(text2) && options2 && (options2.fontFamily && options2.fontFamily.slice(4, 6) === "tt" || options2.font && options2.font.slice(4, 6) === "tt"))) {
      text2 = symbols[mode][text2].replace;
    }
    return new mathMLTree.TextNode(text2);
  };
  var makeRow = function makeRow2(body) {
    if (body.length === 1) {
      return body[0];
    } else {
      return new mathMLTree.MathNode("mrow", body);
    }
  };
  var getVariant = function getVariant2(group, options2) {
    if (options2.fontFamily === "texttt") {
      return "monospace";
    } else if (options2.fontFamily === "textsf") {
      if (options2.fontShape === "textit" && options2.fontWeight === "textbf") {
        return "sans-serif-bold-italic";
      } else if (options2.fontShape === "textit") {
        return "sans-serif-italic";
      } else if (options2.fontWeight === "textbf") {
        return "bold-sans-serif";
      } else {
        return "sans-serif";
      }
    } else if (options2.fontShape === "textit" && options2.fontWeight === "textbf") {
      return "bold-italic";
    } else if (options2.fontShape === "textit") {
      return "italic";
    } else if (options2.fontWeight === "textbf") {
      return "bold";
    }
    var font = options2.font;
    if (!font || font === "mathnormal") {
      return null;
    }
    var mode = group.mode;
    if (font === "mathit") {
      return "italic";
    } else if (font === "boldsymbol") {
      return group.type === "textord" ? "bold" : "bold-italic";
    } else if (font === "mathbf") {
      return "bold";
    } else if (font === "mathbb") {
      return "double-struck";
    } else if (font === "mathfrak") {
      return "fraktur";
    } else if (font === "mathscr" || font === "mathcal") {
      return "script";
    } else if (font === "mathsf") {
      return "sans-serif";
    } else if (font === "mathtt") {
      return "monospace";
    }
    var text2 = group.text;
    if (utils.contains(["\\imath", "\\jmath"], text2)) {
      return null;
    }
    if (symbols[mode][text2] && symbols[mode][text2].replace) {
      text2 = symbols[mode][text2].replace;
    }
    var fontName = buildCommon.fontMap[font].fontName;
    if (getCharacterMetrics(text2, fontName, mode)) {
      return buildCommon.fontMap[font].variant;
    }
    return null;
  };
  var buildExpression = function buildExpression2(expression, options2, isOrdgroup) {
    if (expression.length === 1) {
      var group = buildGroup(expression[0], options2);
      if (isOrdgroup && group instanceof MathNode && group.type === "mo") {
        group.setAttribute("lspace", "0em");
        group.setAttribute("rspace", "0em");
      }
      return [group];
    }
    var groups = [];
    var lastGroup;
    for (var i2 = 0; i2 < expression.length; i2++) {
      var _group = buildGroup(expression[i2], options2);
      if (_group instanceof MathNode && lastGroup instanceof MathNode) {
        if (_group.type === "mtext" && lastGroup.type === "mtext" && _group.getAttribute("mathvariant") === lastGroup.getAttribute("mathvariant")) {
          lastGroup.children.push(..._group.children);
          continue;
        } else if (_group.type === "mn" && lastGroup.type === "mn") {
          lastGroup.children.push(..._group.children);
          continue;
        } else if (_group.type === "mi" && _group.children.length === 1 && lastGroup.type === "mn") {
          var child = _group.children[0];
          if (child instanceof TextNode && child.text === ".") {
            lastGroup.children.push(..._group.children);
            continue;
          }
        } else if (lastGroup.type === "mi" && lastGroup.children.length === 1) {
          var lastChild = lastGroup.children[0];
          if (lastChild instanceof TextNode && lastChild.text === "̸" && (_group.type === "mo" || _group.type === "mi" || _group.type === "mn")) {
            var _child = _group.children[0];
            if (_child instanceof TextNode && _child.text.length > 0) {
              _child.text = _child.text.slice(0, 1) + "̸" + _child.text.slice(1);
              groups.pop();
            }
          }
        }
      }
      groups.push(_group);
      lastGroup = _group;
    }
    return groups;
  };
  var buildExpressionRow = function buildExpressionRow2(expression, options2, isOrdgroup) {
    return makeRow(buildExpression(expression, options2, isOrdgroup));
  };
  var buildGroup = function buildGroup2(group, options2) {
    if (!group) {
      return new mathMLTree.MathNode("mrow");
    }
    if (_mathmlGroupBuilders[group.type]) {
      var result = _mathmlGroupBuilders[group.type](group, options2);
      return result;
    } else {
      throw new ParseError("Got group of unknown type: '" + group.type + "'");
    }
  };
  function buildMathML(tree, texExpression, options2, isDisplayMode, forMathmlOnly) {
    var expression = buildExpression(tree, options2);
    var wrapper;
    if (expression.length === 1 && expression[0] instanceof MathNode && utils.contains(["mrow", "mtable"], expression[0].type)) {
      wrapper = expression[0];
    } else {
      wrapper = new mathMLTree.MathNode("mrow", expression);
    }
    var annotation = new mathMLTree.MathNode("annotation", [new mathMLTree.TextNode(texExpression)]);
    annotation.setAttribute("encoding", "application/x-tex");
    var semantics = new mathMLTree.MathNode("semantics", [wrapper, annotation]);
    var math2 = new mathMLTree.MathNode("math", [semantics]);
    math2.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
    if (isDisplayMode) {
      math2.setAttribute("display", "block");
    }
    var wrapperClass = forMathmlOnly ? "katex" : "katex-mathml";
    return buildCommon.makeSpan([wrapperClass], [math2]);
  }
  var optionsFromSettings = function optionsFromSettings2(settings) {
    return new Options({
      style: settings.displayMode ? Style$1.DISPLAY : Style$1.TEXT,
      maxSize: settings.maxSize,
      minRuleThickness: settings.minRuleThickness
    });
  };
  var displayWrap = function displayWrap2(node2, settings) {
    if (settings.displayMode) {
      var classes2 = ["katex-display"];
      if (settings.leqno) {
        classes2.push("leqno");
      }
      if (settings.fleqn) {
        classes2.push("fleqn");
      }
      node2 = buildCommon.makeSpan(classes2, [node2]);
    }
    return node2;
  };
  var buildTree = function buildTree2(tree, expression, settings) {
    var options2 = optionsFromSettings(settings);
    var katexNode;
    if (settings.output === "mathml") {
      return buildMathML(tree, expression, options2, settings.displayMode, true);
    } else if (settings.output === "html") {
      var htmlNode = buildHTML(tree, options2);
      katexNode = buildCommon.makeSpan(["katex"], [htmlNode]);
    } else {
      var mathMLNode = buildMathML(tree, expression, options2, settings.displayMode, false);
      var _htmlNode = buildHTML(tree, options2);
      katexNode = buildCommon.makeSpan(["katex"], [mathMLNode, _htmlNode]);
    }
    return displayWrap(katexNode, settings);
  };
  var buildHTMLTree = function buildHTMLTree2(tree, expression, settings) {
    var options2 = optionsFromSettings(settings);
    var htmlNode = buildHTML(tree, options2);
    var katexNode = buildCommon.makeSpan(["katex"], [htmlNode]);
    return displayWrap(katexNode, settings);
  };
  var stretchyCodePoint = {
    widehat: "^",
    widecheck: "ˇ",
    widetilde: "~",
    utilde: "~",
    overleftarrow: "←",
    underleftarrow: "←",
    xleftarrow: "←",
    overrightarrow: "→",
    underrightarrow: "→",
    xrightarrow: "→",
    underbrace: "⏟",
    overbrace: "⏞",
    overgroup: "⏠",
    undergroup: "⏡",
    overleftrightarrow: "↔",
    underleftrightarrow: "↔",
    xleftrightarrow: "↔",
    Overrightarrow: "⇒",
    xRightarrow: "⇒",
    overleftharpoon: "↼",
    xleftharpoonup: "↼",
    overrightharpoon: "⇀",
    xrightharpoonup: "⇀",
    xLeftarrow: "⇐",
    xLeftrightarrow: "⇔",
    xhookleftarrow: "↩",
    xhookrightarrow: "↪",
    xmapsto: "↦",
    xrightharpoondown: "⇁",
    xleftharpoondown: "↽",
    xrightleftharpoons: "⇌",
    xleftrightharpoons: "⇋",
    xtwoheadleftarrow: "↞",
    xtwoheadrightarrow: "↠",
    xlongequal: "=",
    xtofrom: "⇄",
    xrightleftarrows: "⇄",
    xrightequilibrium: "⇌",
    // Not a perfect match.
    xleftequilibrium: "⇋",
    // None better available.
    "\\cdrightarrow": "→",
    "\\cdleftarrow": "←",
    "\\cdlongequal": "="
  };
  var mathMLnode = function mathMLnode2(label) {
    var node2 = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(stretchyCodePoint[label.replace(/^\\/, "")])]);
    node2.setAttribute("stretchy", "true");
    return node2;
  };
  var katexImagesData = {
    //   path(s), minWidth, height, align
    overrightarrow: [["rightarrow"], 0.888, 522, "xMaxYMin"],
    overleftarrow: [["leftarrow"], 0.888, 522, "xMinYMin"],
    underrightarrow: [["rightarrow"], 0.888, 522, "xMaxYMin"],
    underleftarrow: [["leftarrow"], 0.888, 522, "xMinYMin"],
    xrightarrow: [["rightarrow"], 1.469, 522, "xMaxYMin"],
    "\\cdrightarrow": [["rightarrow"], 3, 522, "xMaxYMin"],
    // CD minwwidth2.5pc
    xleftarrow: [["leftarrow"], 1.469, 522, "xMinYMin"],
    "\\cdleftarrow": [["leftarrow"], 3, 522, "xMinYMin"],
    Overrightarrow: [["doublerightarrow"], 0.888, 560, "xMaxYMin"],
    xRightarrow: [["doublerightarrow"], 1.526, 560, "xMaxYMin"],
    xLeftarrow: [["doubleleftarrow"], 1.526, 560, "xMinYMin"],
    overleftharpoon: [["leftharpoon"], 0.888, 522, "xMinYMin"],
    xleftharpoonup: [["leftharpoon"], 0.888, 522, "xMinYMin"],
    xleftharpoondown: [["leftharpoondown"], 0.888, 522, "xMinYMin"],
    overrightharpoon: [["rightharpoon"], 0.888, 522, "xMaxYMin"],
    xrightharpoonup: [["rightharpoon"], 0.888, 522, "xMaxYMin"],
    xrightharpoondown: [["rightharpoondown"], 0.888, 522, "xMaxYMin"],
    xlongequal: [["longequal"], 0.888, 334, "xMinYMin"],
    "\\cdlongequal": [["longequal"], 3, 334, "xMinYMin"],
    xtwoheadleftarrow: [["twoheadleftarrow"], 0.888, 334, "xMinYMin"],
    xtwoheadrightarrow: [["twoheadrightarrow"], 0.888, 334, "xMaxYMin"],
    overleftrightarrow: [["leftarrow", "rightarrow"], 0.888, 522],
    overbrace: [["leftbrace", "midbrace", "rightbrace"], 1.6, 548],
    underbrace: [["leftbraceunder", "midbraceunder", "rightbraceunder"], 1.6, 548],
    underleftrightarrow: [["leftarrow", "rightarrow"], 0.888, 522],
    xleftrightarrow: [["leftarrow", "rightarrow"], 1.75, 522],
    xLeftrightarrow: [["doubleleftarrow", "doublerightarrow"], 1.75, 560],
    xrightleftharpoons: [["leftharpoondownplus", "rightharpoonplus"], 1.75, 716],
    xleftrightharpoons: [["leftharpoonplus", "rightharpoondownplus"], 1.75, 716],
    xhookleftarrow: [["leftarrow", "righthook"], 1.08, 522],
    xhookrightarrow: [["lefthook", "rightarrow"], 1.08, 522],
    overlinesegment: [["leftlinesegment", "rightlinesegment"], 0.888, 522],
    underlinesegment: [["leftlinesegment", "rightlinesegment"], 0.888, 522],
    overgroup: [["leftgroup", "rightgroup"], 0.888, 342],
    undergroup: [["leftgroupunder", "rightgroupunder"], 0.888, 342],
    xmapsto: [["leftmapsto", "rightarrow"], 1.5, 522],
    xtofrom: [["leftToFrom", "rightToFrom"], 1.75, 528],
    // The next three arrows are from the mhchem package.
    // In mhchem.sty, min-length is 2.0em. But these arrows might appear in the
    // document as \xrightarrow or \xrightleftharpoons. Those have
    // min-length = 1.75em, so we set min-length on these next three to match.
    xrightleftarrows: [["baraboveleftarrow", "rightarrowabovebar"], 1.75, 901],
    xrightequilibrium: [["baraboveshortleftharpoon", "rightharpoonaboveshortbar"], 1.75, 716],
    xleftequilibrium: [["shortbaraboveleftharpoon", "shortrightharpoonabovebar"], 1.75, 716]
  };
  var groupLength = function groupLength2(arg) {
    if (arg.type === "ordgroup") {
      return arg.body.length;
    } else {
      return 1;
    }
  };
  var svgSpan = function svgSpan2(group, options2) {
    function buildSvgSpan_() {
      var viewBoxWidth = 4e5;
      var label = group.label.slice(1);
      if (utils.contains(["widehat", "widecheck", "widetilde", "utilde"], label)) {
        var grp = group;
        var numChars = groupLength(grp.base);
        var viewBoxHeight;
        var pathName;
        var _height;
        if (numChars > 5) {
          if (label === "widehat" || label === "widecheck") {
            viewBoxHeight = 420;
            viewBoxWidth = 2364;
            _height = 0.42;
            pathName = label + "4";
          } else {
            viewBoxHeight = 312;
            viewBoxWidth = 2340;
            _height = 0.34;
            pathName = "tilde4";
          }
        } else {
          var imgIndex = [1, 1, 2, 2, 3, 3][numChars];
          if (label === "widehat" || label === "widecheck") {
            viewBoxWidth = [0, 1062, 2364, 2364, 2364][imgIndex];
            viewBoxHeight = [0, 239, 300, 360, 420][imgIndex];
            _height = [0, 0.24, 0.3, 0.3, 0.36, 0.42][imgIndex];
            pathName = label + imgIndex;
          } else {
            viewBoxWidth = [0, 600, 1033, 2339, 2340][imgIndex];
            viewBoxHeight = [0, 260, 286, 306, 312][imgIndex];
            _height = [0, 0.26, 0.286, 0.3, 0.306, 0.34][imgIndex];
            pathName = "tilde" + imgIndex;
          }
        }
        var path2 = new PathNode(pathName);
        var svgNode2 = new SvgNode([path2], {
          "width": "100%",
          "height": makeEm(_height),
          "viewBox": "0 0 " + viewBoxWidth + " " + viewBoxHeight,
          "preserveAspectRatio": "none"
        });
        return {
          span: buildCommon.makeSvgSpan([], [svgNode2], options2),
          minWidth: 0,
          height: _height
        };
      } else {
        var spans = [];
        var data = katexImagesData[label];
        var [paths, _minWidth, _viewBoxHeight] = data;
        var _height2 = _viewBoxHeight / 1e3;
        var numSvgChildren = paths.length;
        var widthClasses;
        var aligns;
        if (numSvgChildren === 1) {
          var align1 = data[3];
          widthClasses = ["hide-tail"];
          aligns = [align1];
        } else if (numSvgChildren === 2) {
          widthClasses = ["halfarrow-left", "halfarrow-right"];
          aligns = ["xMinYMin", "xMaxYMin"];
        } else if (numSvgChildren === 3) {
          widthClasses = ["brace-left", "brace-center", "brace-right"];
          aligns = ["xMinYMin", "xMidYMin", "xMaxYMin"];
        } else {
          throw new Error("Correct katexImagesData or update code here to support\n                    " + numSvgChildren + " children.");
        }
        for (var i2 = 0; i2 < numSvgChildren; i2++) {
          var _path = new PathNode(paths[i2]);
          var _svgNode = new SvgNode([_path], {
            "width": "400em",
            "height": makeEm(_height2),
            "viewBox": "0 0 " + viewBoxWidth + " " + _viewBoxHeight,
            "preserveAspectRatio": aligns[i2] + " slice"
          });
          var _span = buildCommon.makeSvgSpan([widthClasses[i2]], [_svgNode], options2);
          if (numSvgChildren === 1) {
            return {
              span: _span,
              minWidth: _minWidth,
              height: _height2
            };
          } else {
            _span.style.height = makeEm(_height2);
            spans.push(_span);
          }
        }
        return {
          span: buildCommon.makeSpan(["stretchy"], spans, options2),
          minWidth: _minWidth,
          height: _height2
        };
      }
    }
    var {
      span,
      minWidth,
      height
    } = buildSvgSpan_();
    span.height = height;
    span.style.height = makeEm(height);
    if (minWidth > 0) {
      span.style.minWidth = makeEm(minWidth);
    }
    return span;
  };
  var encloseSpan = function encloseSpan2(inner2, label, topPad, bottomPad, options2) {
    var img;
    var totalHeight = inner2.height + inner2.depth + topPad + bottomPad;
    if (/fbox|color|angl/.test(label)) {
      img = buildCommon.makeSpan(["stretchy", label], [], options2);
      if (label === "fbox") {
        var color2 = options2.color && options2.getColor();
        if (color2) {
          img.style.borderColor = color2;
        }
      }
    } else {
      var lines = [];
      if (/^[bx]cancel$/.test(label)) {
        lines.push(new LineNode({
          "x1": "0",
          "y1": "0",
          "x2": "100%",
          "y2": "100%",
          "stroke-width": "0.046em"
        }));
      }
      if (/^x?cancel$/.test(label)) {
        lines.push(new LineNode({
          "x1": "0",
          "y1": "100%",
          "x2": "100%",
          "y2": "0",
          "stroke-width": "0.046em"
        }));
      }
      var svgNode2 = new SvgNode(lines, {
        "width": "100%",
        "height": makeEm(totalHeight)
      });
      img = buildCommon.makeSvgSpan([], [svgNode2], options2);
    }
    img.height = totalHeight;
    img.style.height = makeEm(totalHeight);
    return img;
  };
  var stretchy = {
    encloseSpan,
    mathMLnode,
    svgSpan
  };
  function assertNodeType(node2, type2) {
    if (!node2 || node2.type !== type2) {
      throw new Error("Expected node of type " + type2 + ", but got " + (node2 ? "node of type " + node2.type : String(node2)));
    }
    return node2;
  }
  function assertSymbolNodeType(node2) {
    var typedNode = checkSymbolNodeType(node2);
    if (!typedNode) {
      throw new Error("Expected node of symbol group type, but got " + (node2 ? "node of type " + node2.type : String(node2)));
    }
    return typedNode;
  }
  function checkSymbolNodeType(node2) {
    if (node2 && (node2.type === "atom" || NON_ATOMS.hasOwnProperty(node2.type))) {
      return node2;
    }
    return null;
  }
  var htmlBuilder$a = (grp, options2) => {
    var base;
    var group;
    var supSubGroup;
    if (grp && grp.type === "supsub") {
      group = assertNodeType(grp.base, "accent");
      base = group.base;
      grp.base = base;
      supSubGroup = assertSpan(buildGroup$1(grp, options2));
      grp.base = group;
    } else {
      group = assertNodeType(grp, "accent");
      base = group.base;
    }
    var body = buildGroup$1(base, options2.havingCrampedStyle());
    var mustShift = group.isShifty && utils.isCharacterBox(base);
    var skew = 0;
    if (mustShift) {
      var baseChar = utils.getBaseElem(base);
      var baseGroup = buildGroup$1(baseChar, options2.havingCrampedStyle());
      skew = assertSymbolDomNode(baseGroup).skew;
    }
    var accentBelow = group.label === "\\c";
    var clearance = accentBelow ? body.height + body.depth : Math.min(body.height, options2.fontMetrics().xHeight);
    var accentBody;
    if (!group.isStretchy) {
      var accent2;
      var width2;
      if (group.label === "\\vec") {
        accent2 = buildCommon.staticSvg("vec", options2);
        width2 = buildCommon.svgData.vec[1];
      } else {
        accent2 = buildCommon.makeOrd({
          mode: group.mode,
          text: group.label
        }, options2, "textord");
        accent2 = assertSymbolDomNode(accent2);
        accent2.italic = 0;
        width2 = accent2.width;
        if (accentBelow) {
          clearance += accent2.depth;
        }
      }
      accentBody = buildCommon.makeSpan(["accent-body"], [accent2]);
      var accentFull = group.label === "\\textcircled";
      if (accentFull) {
        accentBody.classes.push("accent-full");
        clearance = body.height;
      }
      var left2 = skew;
      if (!accentFull) {
        left2 -= width2 / 2;
      }
      accentBody.style.left = makeEm(left2);
      if (group.label === "\\textcircled") {
        accentBody.style.top = ".2em";
      }
      accentBody = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: body
        }, {
          type: "kern",
          size: -clearance
        }, {
          type: "elem",
          elem: accentBody
        }]
      }, options2);
    } else {
      accentBody = stretchy.svgSpan(group, options2);
      accentBody = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: body
        }, {
          type: "elem",
          elem: accentBody,
          wrapperClasses: ["svg-align"],
          wrapperStyle: skew > 0 ? {
            width: "calc(100% - " + makeEm(2 * skew) + ")",
            marginLeft: makeEm(2 * skew)
          } : void 0
        }]
      }, options2);
    }
    var accentWrap = buildCommon.makeSpan(["mord", "accent"], [accentBody], options2);
    if (supSubGroup) {
      supSubGroup.children[0] = accentWrap;
      supSubGroup.height = Math.max(accentWrap.height, supSubGroup.height);
      supSubGroup.classes[0] = "mord";
      return supSubGroup;
    } else {
      return accentWrap;
    }
  };
  var mathmlBuilder$9 = (group, options2) => {
    var accentNode = group.isStretchy ? stretchy.mathMLnode(group.label) : new mathMLTree.MathNode("mo", [makeText(group.label, group.mode)]);
    var node2 = new mathMLTree.MathNode("mover", [buildGroup(group.base, options2), accentNode]);
    node2.setAttribute("accent", "true");
    return node2;
  };
  var NON_STRETCHY_ACCENT_REGEX = new RegExp(["\\acute", "\\grave", "\\ddot", "\\tilde", "\\bar", "\\breve", "\\check", "\\hat", "\\vec", "\\dot", "\\mathring"].map((accent2) => "\\" + accent2).join("|"));
  defineFunction({
    type: "accent",
    names: ["\\acute", "\\grave", "\\ddot", "\\tilde", "\\bar", "\\breve", "\\check", "\\hat", "\\vec", "\\dot", "\\mathring", "\\widecheck", "\\widehat", "\\widetilde", "\\overrightarrow", "\\overleftarrow", "\\Overrightarrow", "\\overleftrightarrow", "\\overgroup", "\\overlinesegment", "\\overleftharpoon", "\\overrightharpoon"],
    props: {
      numArgs: 1
    },
    handler: (context, args) => {
      var base = normalizeArgument(args[0]);
      var isStretchy = !NON_STRETCHY_ACCENT_REGEX.test(context.funcName);
      var isShifty = !isStretchy || context.funcName === "\\widehat" || context.funcName === "\\widetilde" || context.funcName === "\\widecheck";
      return {
        type: "accent",
        mode: context.parser.mode,
        label: context.funcName,
        isStretchy,
        isShifty,
        base
      };
    },
    htmlBuilder: htmlBuilder$a,
    mathmlBuilder: mathmlBuilder$9
  });
  defineFunction({
    type: "accent",
    names: ["\\'", "\\`", "\\^", "\\~", "\\=", "\\u", "\\.", '\\"', "\\c", "\\r", "\\H", "\\v", "\\textcircled"],
    props: {
      numArgs: 1,
      allowedInText: true,
      allowedInMath: true,
      // unless in strict mode
      argTypes: ["primitive"]
    },
    handler: (context, args) => {
      var base = args[0];
      var mode = context.parser.mode;
      if (mode === "math") {
        context.parser.settings.reportNonstrict("mathVsTextAccents", "LaTeX's accent " + context.funcName + " works only in text mode");
        mode = "text";
      }
      return {
        type: "accent",
        mode,
        label: context.funcName,
        isStretchy: false,
        isShifty: true,
        base
      };
    },
    htmlBuilder: htmlBuilder$a,
    mathmlBuilder: mathmlBuilder$9
  });
  defineFunction({
    type: "accentUnder",
    names: ["\\underleftarrow", "\\underrightarrow", "\\underleftrightarrow", "\\undergroup", "\\underlinesegment", "\\utilde"],
    props: {
      numArgs: 1
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var base = args[0];
      return {
        type: "accentUnder",
        mode: parser2.mode,
        label: funcName,
        base
      };
    },
    htmlBuilder: (group, options2) => {
      var innerGroup = buildGroup$1(group.base, options2);
      var accentBody = stretchy.svgSpan(group, options2);
      var kern = group.label === "\\utilde" ? 0.12 : 0;
      var vlist = buildCommon.makeVList({
        positionType: "top",
        positionData: innerGroup.height,
        children: [{
          type: "elem",
          elem: accentBody,
          wrapperClasses: ["svg-align"]
        }, {
          type: "kern",
          size: kern
        }, {
          type: "elem",
          elem: innerGroup
        }]
      }, options2);
      return buildCommon.makeSpan(["mord", "accentunder"], [vlist], options2);
    },
    mathmlBuilder: (group, options2) => {
      var accentNode = stretchy.mathMLnode(group.label);
      var node2 = new mathMLTree.MathNode("munder", [buildGroup(group.base, options2), accentNode]);
      node2.setAttribute("accentunder", "true");
      return node2;
    }
  });
  var paddedNode = (group) => {
    var node2 = new mathMLTree.MathNode("mpadded", group ? [group] : []);
    node2.setAttribute("width", "+0.6em");
    node2.setAttribute("lspace", "0.3em");
    return node2;
  };
  defineFunction({
    type: "xArrow",
    names: [
      "\\xleftarrow",
      "\\xrightarrow",
      "\\xLeftarrow",
      "\\xRightarrow",
      "\\xleftrightarrow",
      "\\xLeftrightarrow",
      "\\xhookleftarrow",
      "\\xhookrightarrow",
      "\\xmapsto",
      "\\xrightharpoondown",
      "\\xrightharpoonup",
      "\\xleftharpoondown",
      "\\xleftharpoonup",
      "\\xrightleftharpoons",
      "\\xleftrightharpoons",
      "\\xlongequal",
      "\\xtwoheadrightarrow",
      "\\xtwoheadleftarrow",
      "\\xtofrom",
      // The next 3 functions are here to support the mhchem extension.
      // Direct use of these functions is discouraged and may break someday.
      "\\xrightleftarrows",
      "\\xrightequilibrium",
      "\\xleftequilibrium",
      // The next 3 functions are here only to support the {CD} environment.
      "\\\\cdrightarrow",
      "\\\\cdleftarrow",
      "\\\\cdlongequal"
    ],
    props: {
      numArgs: 1,
      numOptionalArgs: 1
    },
    handler(_ref, args, optArgs) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      return {
        type: "xArrow",
        mode: parser2.mode,
        label: funcName,
        body: args[0],
        below: optArgs[0]
      };
    },
    // Flow is unable to correctly infer the type of `group`, even though it's
    // unambiguously determined from the passed-in `type` above.
    htmlBuilder(group, options2) {
      var style = options2.style;
      var newOptions = options2.havingStyle(style.sup());
      var upperGroup = buildCommon.wrapFragment(buildGroup$1(group.body, newOptions, options2), options2);
      var arrowPrefix = group.label.slice(0, 2) === "\\x" ? "x" : "cd";
      upperGroup.classes.push(arrowPrefix + "-arrow-pad");
      var lowerGroup;
      if (group.below) {
        newOptions = options2.havingStyle(style.sub());
        lowerGroup = buildCommon.wrapFragment(buildGroup$1(group.below, newOptions, options2), options2);
        lowerGroup.classes.push(arrowPrefix + "-arrow-pad");
      }
      var arrowBody = stretchy.svgSpan(group, options2);
      var arrowShift = -options2.fontMetrics().axisHeight + 0.5 * arrowBody.height;
      var upperShift = -options2.fontMetrics().axisHeight - 0.5 * arrowBody.height - 0.111;
      if (upperGroup.depth > 0.25 || group.label === "\\xleftequilibrium") {
        upperShift -= upperGroup.depth;
      }
      var vlist;
      if (lowerGroup) {
        var lowerShift = -options2.fontMetrics().axisHeight + lowerGroup.height + 0.5 * arrowBody.height + 0.111;
        vlist = buildCommon.makeVList({
          positionType: "individualShift",
          children: [{
            type: "elem",
            elem: upperGroup,
            shift: upperShift
          }, {
            type: "elem",
            elem: arrowBody,
            shift: arrowShift
          }, {
            type: "elem",
            elem: lowerGroup,
            shift: lowerShift
          }]
        }, options2);
      } else {
        vlist = buildCommon.makeVList({
          positionType: "individualShift",
          children: [{
            type: "elem",
            elem: upperGroup,
            shift: upperShift
          }, {
            type: "elem",
            elem: arrowBody,
            shift: arrowShift
          }]
        }, options2);
      }
      vlist.children[0].children[0].children[1].classes.push("svg-align");
      return buildCommon.makeSpan(["mrel", "x-arrow"], [vlist], options2);
    },
    mathmlBuilder(group, options2) {
      var arrowNode = stretchy.mathMLnode(group.label);
      arrowNode.setAttribute("minsize", group.label.charAt(0) === "x" ? "1.75em" : "3.0em");
      var node2;
      if (group.body) {
        var upperNode = paddedNode(buildGroup(group.body, options2));
        if (group.below) {
          var lowerNode = paddedNode(buildGroup(group.below, options2));
          node2 = new mathMLTree.MathNode("munderover", [arrowNode, lowerNode, upperNode]);
        } else {
          node2 = new mathMLTree.MathNode("mover", [arrowNode, upperNode]);
        }
      } else if (group.below) {
        var _lowerNode = paddedNode(buildGroup(group.below, options2));
        node2 = new mathMLTree.MathNode("munder", [arrowNode, _lowerNode]);
      } else {
        node2 = paddedNode();
        node2 = new mathMLTree.MathNode("mover", [arrowNode, node2]);
      }
      return node2;
    }
  });
  var makeSpan = buildCommon.makeSpan;
  function htmlBuilder$9(group, options2) {
    var elements2 = buildExpression$1(group.body, options2, true);
    return makeSpan([group.mclass], elements2, options2);
  }
  function mathmlBuilder$8(group, options2) {
    var node2;
    var inner2 = buildExpression(group.body, options2);
    if (group.mclass === "minner") {
      node2 = new mathMLTree.MathNode("mpadded", inner2);
    } else if (group.mclass === "mord") {
      if (group.isCharacterBox) {
        node2 = inner2[0];
        node2.type = "mi";
      } else {
        node2 = new mathMLTree.MathNode("mi", inner2);
      }
    } else {
      if (group.isCharacterBox) {
        node2 = inner2[0];
        node2.type = "mo";
      } else {
        node2 = new mathMLTree.MathNode("mo", inner2);
      }
      if (group.mclass === "mbin") {
        node2.attributes.lspace = "0.22em";
        node2.attributes.rspace = "0.22em";
      } else if (group.mclass === "mpunct") {
        node2.attributes.lspace = "0em";
        node2.attributes.rspace = "0.17em";
      } else if (group.mclass === "mopen" || group.mclass === "mclose") {
        node2.attributes.lspace = "0em";
        node2.attributes.rspace = "0em";
      } else if (group.mclass === "minner") {
        node2.attributes.lspace = "0.0556em";
        node2.attributes.width = "+0.1111em";
      }
    }
    return node2;
  }
  defineFunction({
    type: "mclass",
    names: ["\\mathord", "\\mathbin", "\\mathrel", "\\mathopen", "\\mathclose", "\\mathpunct", "\\mathinner"],
    props: {
      numArgs: 1,
      primitive: true
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var body = args[0];
      return {
        type: "mclass",
        mode: parser2.mode,
        mclass: "m" + funcName.slice(5),
        // TODO(kevinb): don't prefix with 'm'
        body: ordargument(body),
        isCharacterBox: utils.isCharacterBox(body)
      };
    },
    htmlBuilder: htmlBuilder$9,
    mathmlBuilder: mathmlBuilder$8
  });
  var binrelClass = (arg) => {
    var atom = arg.type === "ordgroup" && arg.body.length ? arg.body[0] : arg;
    if (atom.type === "atom" && (atom.family === "bin" || atom.family === "rel")) {
      return "m" + atom.family;
    } else {
      return "mord";
    }
  };
  defineFunction({
    type: "mclass",
    names: ["\\@binrel"],
    props: {
      numArgs: 2
    },
    handler(_ref2, args) {
      var {
        parser: parser2
      } = _ref2;
      return {
        type: "mclass",
        mode: parser2.mode,
        mclass: binrelClass(args[0]),
        body: ordargument(args[1]),
        isCharacterBox: utils.isCharacterBox(args[1])
      };
    }
  });
  defineFunction({
    type: "mclass",
    names: ["\\stackrel", "\\overset", "\\underset"],
    props: {
      numArgs: 2
    },
    handler(_ref3, args) {
      var {
        parser: parser2,
        funcName
      } = _ref3;
      var baseArg = args[1];
      var shiftedArg = args[0];
      var mclass;
      if (funcName !== "\\stackrel") {
        mclass = binrelClass(baseArg);
      } else {
        mclass = "mrel";
      }
      var baseOp = {
        type: "op",
        mode: baseArg.mode,
        limits: true,
        alwaysHandleSupSub: true,
        parentIsSupSub: false,
        symbol: false,
        suppressBaseShift: funcName !== "\\stackrel",
        body: ordargument(baseArg)
      };
      var supsub = {
        type: "supsub",
        mode: shiftedArg.mode,
        base: baseOp,
        sup: funcName === "\\underset" ? null : shiftedArg,
        sub: funcName === "\\underset" ? shiftedArg : null
      };
      return {
        type: "mclass",
        mode: parser2.mode,
        mclass,
        body: [supsub],
        isCharacterBox: utils.isCharacterBox(supsub)
      };
    },
    htmlBuilder: htmlBuilder$9,
    mathmlBuilder: mathmlBuilder$8
  });
  defineFunction({
    type: "pmb",
    names: ["\\pmb"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "pmb",
        mode: parser2.mode,
        mclass: binrelClass(args[0]),
        body: ordargument(args[0])
      };
    },
    htmlBuilder(group, options2) {
      var elements2 = buildExpression$1(group.body, options2, true);
      var node2 = buildCommon.makeSpan([group.mclass], elements2, options2);
      node2.style.textShadow = "0.02em 0.01em 0.04px";
      return node2;
    },
    mathmlBuilder(group, style) {
      var inner2 = buildExpression(group.body, style);
      var node2 = new mathMLTree.MathNode("mstyle", inner2);
      node2.setAttribute("style", "text-shadow: 0.02em 0.01em 0.04px");
      return node2;
    }
  });
  var cdArrowFunctionName = {
    ">": "\\\\cdrightarrow",
    "<": "\\\\cdleftarrow",
    "=": "\\\\cdlongequal",
    "A": "\\uparrow",
    "V": "\\downarrow",
    "|": "\\Vert",
    ".": "no arrow"
  };
  var newCell = () => {
    return {
      type: "styling",
      body: [],
      mode: "math",
      style: "display"
    };
  };
  var isStartOfArrow = (node2) => {
    return node2.type === "textord" && node2.text === "@";
  };
  var isLabelEnd = (node2, endChar) => {
    return (node2.type === "mathord" || node2.type === "atom") && node2.text === endChar;
  };
  function cdArrow(arrowChar, labels, parser2) {
    var funcName = cdArrowFunctionName[arrowChar];
    switch (funcName) {
      case "\\\\cdrightarrow":
      case "\\\\cdleftarrow":
        return parser2.callFunction(funcName, [labels[0]], [labels[1]]);
      case "\\uparrow":
      case "\\downarrow": {
        var leftLabel = parser2.callFunction("\\\\cdleft", [labels[0]], []);
        var bareArrow = {
          type: "atom",
          text: funcName,
          mode: "math",
          family: "rel"
        };
        var sizedArrow = parser2.callFunction("\\Big", [bareArrow], []);
        var rightLabel = parser2.callFunction("\\\\cdright", [labels[1]], []);
        var arrowGroup = {
          type: "ordgroup",
          mode: "math",
          body: [leftLabel, sizedArrow, rightLabel]
        };
        return parser2.callFunction("\\\\cdparent", [arrowGroup], []);
      }
      case "\\\\cdlongequal":
        return parser2.callFunction("\\\\cdlongequal", [], []);
      case "\\Vert": {
        var arrow = {
          type: "textord",
          text: "\\Vert",
          mode: "math"
        };
        return parser2.callFunction("\\Big", [arrow], []);
      }
      default:
        return {
          type: "textord",
          text: " ",
          mode: "math"
        };
    }
  }
  function parseCD(parser2) {
    var parsedRows = [];
    parser2.gullet.beginGroup();
    parser2.gullet.macros.set("\\cr", "\\\\\\relax");
    parser2.gullet.beginGroup();
    while (true) {
      parsedRows.push(parser2.parseExpression(false, "\\\\"));
      parser2.gullet.endGroup();
      parser2.gullet.beginGroup();
      var next2 = parser2.fetch().text;
      if (next2 === "&" || next2 === "\\\\") {
        parser2.consume();
      } else if (next2 === "\\end") {
        if (parsedRows[parsedRows.length - 1].length === 0) {
          parsedRows.pop();
        }
        break;
      } else {
        throw new ParseError("Expected \\\\ or \\cr or \\end", parser2.nextToken);
      }
    }
    var row = [];
    var body = [row];
    for (var i2 = 0; i2 < parsedRows.length; i2++) {
      var rowNodes = parsedRows[i2];
      var cell = newCell();
      for (var j = 0; j < rowNodes.length; j++) {
        if (!isStartOfArrow(rowNodes[j])) {
          cell.body.push(rowNodes[j]);
        } else {
          row.push(cell);
          j += 1;
          var arrowChar = assertSymbolNodeType(rowNodes[j]).text;
          var labels = new Array(2);
          labels[0] = {
            type: "ordgroup",
            mode: "math",
            body: []
          };
          labels[1] = {
            type: "ordgroup",
            mode: "math",
            body: []
          };
          if ("=|.".indexOf(arrowChar) > -1)
            ;
          else if ("<>AV".indexOf(arrowChar) > -1) {
            for (var labelNum = 0; labelNum < 2; labelNum++) {
              var inLabel = true;
              for (var k = j + 1; k < rowNodes.length; k++) {
                if (isLabelEnd(rowNodes[k], arrowChar)) {
                  inLabel = false;
                  j = k;
                  break;
                }
                if (isStartOfArrow(rowNodes[k])) {
                  throw new ParseError("Missing a " + arrowChar + " character to complete a CD arrow.", rowNodes[k]);
                }
                labels[labelNum].body.push(rowNodes[k]);
              }
              if (inLabel) {
                throw new ParseError("Missing a " + arrowChar + " character to complete a CD arrow.", rowNodes[j]);
              }
            }
          } else {
            throw new ParseError('Expected one of "<>AV=|." after @', rowNodes[j]);
          }
          var arrow = cdArrow(arrowChar, labels, parser2);
          var wrappedArrow = {
            type: "styling",
            body: [arrow],
            mode: "math",
            style: "display"
            // CD is always displaystyle.
          };
          row.push(wrappedArrow);
          cell = newCell();
        }
      }
      if (i2 % 2 === 0) {
        row.push(cell);
      } else {
        row.shift();
      }
      row = [];
      body.push(row);
    }
    parser2.gullet.endGroup();
    parser2.gullet.endGroup();
    var cols = new Array(body[0].length).fill({
      type: "align",
      align: "c",
      pregap: 0.25,
      // CD package sets \enskip between columns.
      postgap: 0.25
      // So pre and post each get half an \enskip, i.e. 0.25em.
    });
    return {
      type: "array",
      mode: "math",
      body,
      arraystretch: 1,
      addJot: true,
      rowGaps: [null],
      cols,
      colSeparationType: "CD",
      hLinesBeforeRow: new Array(body.length + 1).fill([])
    };
  }
  defineFunction({
    type: "cdlabel",
    names: ["\\\\cdleft", "\\\\cdright"],
    props: {
      numArgs: 1
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      return {
        type: "cdlabel",
        mode: parser2.mode,
        side: funcName.slice(4),
        label: args[0]
      };
    },
    htmlBuilder(group, options2) {
      var newOptions = options2.havingStyle(options2.style.sup());
      var label = buildCommon.wrapFragment(buildGroup$1(group.label, newOptions, options2), options2);
      label.classes.push("cd-label-" + group.side);
      label.style.bottom = makeEm(0.8 - label.depth);
      label.height = 0;
      label.depth = 0;
      return label;
    },
    mathmlBuilder(group, options2) {
      var label = new mathMLTree.MathNode("mrow", [buildGroup(group.label, options2)]);
      label = new mathMLTree.MathNode("mpadded", [label]);
      label.setAttribute("width", "0");
      if (group.side === "left") {
        label.setAttribute("lspace", "-1width");
      }
      label.setAttribute("voffset", "0.7em");
      label = new mathMLTree.MathNode("mstyle", [label]);
      label.setAttribute("displaystyle", "false");
      label.setAttribute("scriptlevel", "1");
      return label;
    }
  });
  defineFunction({
    type: "cdlabelparent",
    names: ["\\\\cdparent"],
    props: {
      numArgs: 1
    },
    handler(_ref2, args) {
      var {
        parser: parser2
      } = _ref2;
      return {
        type: "cdlabelparent",
        mode: parser2.mode,
        fragment: args[0]
      };
    },
    htmlBuilder(group, options2) {
      var parent = buildCommon.wrapFragment(buildGroup$1(group.fragment, options2), options2);
      parent.classes.push("cd-vert-arrow");
      return parent;
    },
    mathmlBuilder(group, options2) {
      return new mathMLTree.MathNode("mrow", [buildGroup(group.fragment, options2)]);
    }
  });
  defineFunction({
    type: "textord",
    names: ["\\@char"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      var arg = assertNodeType(args[0], "ordgroup");
      var group = arg.body;
      var number2 = "";
      for (var i2 = 0; i2 < group.length; i2++) {
        var node2 = assertNodeType(group[i2], "textord");
        number2 += node2.text;
      }
      var code = parseInt(number2);
      var text2;
      if (isNaN(code)) {
        throw new ParseError("\\@char has non-numeric argument " + number2);
      } else if (code < 0 || code >= 1114111) {
        throw new ParseError("\\@char with invalid code point " + number2);
      } else if (code <= 65535) {
        text2 = String.fromCharCode(code);
      } else {
        code -= 65536;
        text2 = String.fromCharCode((code >> 10) + 55296, (code & 1023) + 56320);
      }
      return {
        type: "textord",
        mode: parser2.mode,
        text: text2
      };
    }
  });
  var htmlBuilder$8 = (group, options2) => {
    var elements2 = buildExpression$1(group.body, options2.withColor(group.color), false);
    return buildCommon.makeFragment(elements2);
  };
  var mathmlBuilder$7 = (group, options2) => {
    var inner2 = buildExpression(group.body, options2.withColor(group.color));
    var node2 = new mathMLTree.MathNode("mstyle", inner2);
    node2.setAttribute("mathcolor", group.color);
    return node2;
  };
  defineFunction({
    type: "color",
    names: ["\\textcolor"],
    props: {
      numArgs: 2,
      allowedInText: true,
      argTypes: ["color", "original"]
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      var color2 = assertNodeType(args[0], "color-token").color;
      var body = args[1];
      return {
        type: "color",
        mode: parser2.mode,
        color: color2,
        body: ordargument(body)
      };
    },
    htmlBuilder: htmlBuilder$8,
    mathmlBuilder: mathmlBuilder$7
  });
  defineFunction({
    type: "color",
    names: ["\\color"],
    props: {
      numArgs: 1,
      allowedInText: true,
      argTypes: ["color"]
    },
    handler(_ref2, args) {
      var {
        parser: parser2,
        breakOnTokenText
      } = _ref2;
      var color2 = assertNodeType(args[0], "color-token").color;
      parser2.gullet.macros.set("\\current@color", color2);
      var body = parser2.parseExpression(true, breakOnTokenText);
      return {
        type: "color",
        mode: parser2.mode,
        color: color2,
        body
      };
    },
    htmlBuilder: htmlBuilder$8,
    mathmlBuilder: mathmlBuilder$7
  });
  defineFunction({
    type: "cr",
    names: ["\\\\"],
    props: {
      numArgs: 0,
      numOptionalArgs: 0,
      allowedInText: true
    },
    handler(_ref, args, optArgs) {
      var {
        parser: parser2
      } = _ref;
      var size2 = parser2.gullet.future().text === "[" ? parser2.parseSizeGroup(true) : null;
      var newLine = !parser2.settings.displayMode || !parser2.settings.useStrictBehavior("newLineInDisplayMode", "In LaTeX, \\\\ or \\newline does nothing in display mode");
      return {
        type: "cr",
        mode: parser2.mode,
        newLine,
        size: size2 && assertNodeType(size2, "size").value
      };
    },
    // The following builders are called only at the top level,
    // not within tabular/array environments.
    htmlBuilder(group, options2) {
      var span = buildCommon.makeSpan(["mspace"], [], options2);
      if (group.newLine) {
        span.classes.push("newline");
        if (group.size) {
          span.style.marginTop = makeEm(calculateSize(group.size, options2));
        }
      }
      return span;
    },
    mathmlBuilder(group, options2) {
      var node2 = new mathMLTree.MathNode("mspace");
      if (group.newLine) {
        node2.setAttribute("linebreak", "newline");
        if (group.size) {
          node2.setAttribute("height", makeEm(calculateSize(group.size, options2)));
        }
      }
      return node2;
    }
  });
  var globalMap = {
    "\\global": "\\global",
    "\\long": "\\\\globallong",
    "\\\\globallong": "\\\\globallong",
    "\\def": "\\gdef",
    "\\gdef": "\\gdef",
    "\\edef": "\\xdef",
    "\\xdef": "\\xdef",
    "\\let": "\\\\globallet",
    "\\futurelet": "\\\\globalfuture"
  };
  var checkControlSequence = (tok) => {
    var name = tok.text;
    if (/^(?:[\\{}$&#^_]|EOF)$/.test(name)) {
      throw new ParseError("Expected a control sequence", tok);
    }
    return name;
  };
  var getRHS = (parser2) => {
    var tok = parser2.gullet.popToken();
    if (tok.text === "=") {
      tok = parser2.gullet.popToken();
      if (tok.text === " ") {
        tok = parser2.gullet.popToken();
      }
    }
    return tok;
  };
  var letCommand = (parser2, name, tok, global2) => {
    var macro = parser2.gullet.macros.get(tok.text);
    if (macro == null) {
      tok.noexpand = true;
      macro = {
        tokens: [tok],
        numArgs: 0,
        // reproduce the same behavior in expansion
        unexpandable: !parser2.gullet.isExpandable(tok.text)
      };
    }
    parser2.gullet.macros.set(name, macro, global2);
  };
  defineFunction({
    type: "internal",
    names: [
      "\\global",
      "\\long",
      "\\\\globallong"
      // can’t be entered directly
    ],
    props: {
      numArgs: 0,
      allowedInText: true
    },
    handler(_ref) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      parser2.consumeSpaces();
      var token2 = parser2.fetch();
      if (globalMap[token2.text]) {
        if (funcName === "\\global" || funcName === "\\\\globallong") {
          token2.text = globalMap[token2.text];
        }
        return assertNodeType(parser2.parseFunction(), "internal");
      }
      throw new ParseError("Invalid token after macro prefix", token2);
    }
  });
  defineFunction({
    type: "internal",
    names: ["\\def", "\\gdef", "\\edef", "\\xdef"],
    props: {
      numArgs: 0,
      allowedInText: true,
      primitive: true
    },
    handler(_ref2) {
      var {
        parser: parser2,
        funcName
      } = _ref2;
      var tok = parser2.gullet.popToken();
      var name = tok.text;
      if (/^(?:[\\{}$&#^_]|EOF)$/.test(name)) {
        throw new ParseError("Expected a control sequence", tok);
      }
      var numArgs = 0;
      var insert;
      var delimiters2 = [[]];
      while (parser2.gullet.future().text !== "{") {
        tok = parser2.gullet.popToken();
        if (tok.text === "#") {
          if (parser2.gullet.future().text === "{") {
            insert = parser2.gullet.future();
            delimiters2[numArgs].push("{");
            break;
          }
          tok = parser2.gullet.popToken();
          if (!/^[1-9]$/.test(tok.text)) {
            throw new ParseError('Invalid argument number "' + tok.text + '"');
          }
          if (parseInt(tok.text) !== numArgs + 1) {
            throw new ParseError('Argument number "' + tok.text + '" out of order');
          }
          numArgs++;
          delimiters2.push([]);
        } else if (tok.text === "EOF") {
          throw new ParseError("Expected a macro definition");
        } else {
          delimiters2[numArgs].push(tok.text);
        }
      }
      var {
        tokens
      } = parser2.gullet.consumeArg();
      if (insert) {
        tokens.unshift(insert);
      }
      if (funcName === "\\edef" || funcName === "\\xdef") {
        tokens = parser2.gullet.expandTokens(tokens);
        tokens.reverse();
      }
      parser2.gullet.macros.set(name, {
        tokens,
        numArgs,
        delimiters: delimiters2
      }, funcName === globalMap[funcName]);
      return {
        type: "internal",
        mode: parser2.mode
      };
    }
  });
  defineFunction({
    type: "internal",
    names: [
      "\\let",
      "\\\\globallet"
      // can’t be entered directly
    ],
    props: {
      numArgs: 0,
      allowedInText: true,
      primitive: true
    },
    handler(_ref3) {
      var {
        parser: parser2,
        funcName
      } = _ref3;
      var name = checkControlSequence(parser2.gullet.popToken());
      parser2.gullet.consumeSpaces();
      var tok = getRHS(parser2);
      letCommand(parser2, name, tok, funcName === "\\\\globallet");
      return {
        type: "internal",
        mode: parser2.mode
      };
    }
  });
  defineFunction({
    type: "internal",
    names: [
      "\\futurelet",
      "\\\\globalfuture"
      // can’t be entered directly
    ],
    props: {
      numArgs: 0,
      allowedInText: true,
      primitive: true
    },
    handler(_ref4) {
      var {
        parser: parser2,
        funcName
      } = _ref4;
      var name = checkControlSequence(parser2.gullet.popToken());
      var middle = parser2.gullet.popToken();
      var tok = parser2.gullet.popToken();
      letCommand(parser2, name, tok, funcName === "\\\\globalfuture");
      parser2.gullet.pushToken(tok);
      parser2.gullet.pushToken(middle);
      return {
        type: "internal",
        mode: parser2.mode
      };
    }
  });
  var getMetrics = function getMetrics2(symbol, font, mode) {
    var replace2 = symbols.math[symbol] && symbols.math[symbol].replace;
    var metrics = getCharacterMetrics(replace2 || symbol, font, mode);
    if (!metrics) {
      throw new Error("Unsupported symbol " + symbol + " and font size " + font + ".");
    }
    return metrics;
  };
  var styleWrap = function styleWrap2(delim, toStyle, options2, classes2) {
    var newOptions = options2.havingBaseStyle(toStyle);
    var span = buildCommon.makeSpan(classes2.concat(newOptions.sizingClasses(options2)), [delim], options2);
    var delimSizeMultiplier = newOptions.sizeMultiplier / options2.sizeMultiplier;
    span.height *= delimSizeMultiplier;
    span.depth *= delimSizeMultiplier;
    span.maxFontSize = newOptions.sizeMultiplier;
    return span;
  };
  var centerSpan = function centerSpan2(span, options2, style) {
    var newOptions = options2.havingBaseStyle(style);
    var shift = (1 - options2.sizeMultiplier / newOptions.sizeMultiplier) * options2.fontMetrics().axisHeight;
    span.classes.push("delimcenter");
    span.style.top = makeEm(shift);
    span.height -= shift;
    span.depth += shift;
  };
  var makeSmallDelim = function makeSmallDelim2(delim, style, center2, options2, mode, classes2) {
    var text2 = buildCommon.makeSymbol(delim, "Main-Regular", mode, options2);
    var span = styleWrap(text2, style, options2, classes2);
    if (center2) {
      centerSpan(span, options2, style);
    }
    return span;
  };
  var mathrmSize = function mathrmSize2(value2, size2, mode, options2) {
    return buildCommon.makeSymbol(value2, "Size" + size2 + "-Regular", mode, options2);
  };
  var makeLargeDelim = function makeLargeDelim2(delim, size2, center2, options2, mode, classes2) {
    var inner2 = mathrmSize(delim, size2, mode, options2);
    var span = styleWrap(buildCommon.makeSpan(["delimsizing", "size" + size2], [inner2], options2), Style$1.TEXT, options2, classes2);
    if (center2) {
      centerSpan(span, options2, Style$1.TEXT);
    }
    return span;
  };
  var makeGlyphSpan = function makeGlyphSpan2(symbol, font, mode) {
    var sizeClass;
    if (font === "Size1-Regular") {
      sizeClass = "delim-size1";
    } else {
      sizeClass = "delim-size4";
    }
    var corner = buildCommon.makeSpan(["delimsizinginner", sizeClass], [buildCommon.makeSpan([], [buildCommon.makeSymbol(symbol, font, mode)])]);
    return {
      type: "elem",
      elem: corner
    };
  };
  var makeInner = function makeInner2(ch2, height, options2) {
    var width2 = fontMetricsData["Size4-Regular"][ch2.charCodeAt(0)] ? fontMetricsData["Size4-Regular"][ch2.charCodeAt(0)][4] : fontMetricsData["Size1-Regular"][ch2.charCodeAt(0)][4];
    var path2 = new PathNode("inner", innerPath(ch2, Math.round(1e3 * height)));
    var svgNode2 = new SvgNode([path2], {
      "width": makeEm(width2),
      "height": makeEm(height),
      // Override CSS rule `.katex svg { width: 100% }`
      "style": "width:" + makeEm(width2),
      "viewBox": "0 0 " + 1e3 * width2 + " " + Math.round(1e3 * height),
      "preserveAspectRatio": "xMinYMin"
    });
    var span = buildCommon.makeSvgSpan([], [svgNode2], options2);
    span.height = height;
    span.style.height = makeEm(height);
    span.style.width = makeEm(width2);
    return {
      type: "elem",
      elem: span
    };
  };
  var lapInEms = 8e-3;
  var lap = {
    type: "kern",
    size: -1 * lapInEms
  };
  var verts = ["|", "\\lvert", "\\rvert", "\\vert"];
  var doubleVerts = ["\\|", "\\lVert", "\\rVert", "\\Vert"];
  var makeStackedDelim = function makeStackedDelim2(delim, heightTotal, center2, options2, mode, classes2) {
    var top2;
    var middle;
    var repeat2;
    var bottom2;
    var svgLabel = "";
    var viewBoxWidth = 0;
    top2 = repeat2 = bottom2 = delim;
    middle = null;
    var font = "Size1-Regular";
    if (delim === "\\uparrow") {
      repeat2 = bottom2 = "⏐";
    } else if (delim === "\\Uparrow") {
      repeat2 = bottom2 = "‖";
    } else if (delim === "\\downarrow") {
      top2 = repeat2 = "⏐";
    } else if (delim === "\\Downarrow") {
      top2 = repeat2 = "‖";
    } else if (delim === "\\updownarrow") {
      top2 = "\\uparrow";
      repeat2 = "⏐";
      bottom2 = "\\downarrow";
    } else if (delim === "\\Updownarrow") {
      top2 = "\\Uparrow";
      repeat2 = "‖";
      bottom2 = "\\Downarrow";
    } else if (utils.contains(verts, delim)) {
      repeat2 = "∣";
      svgLabel = "vert";
      viewBoxWidth = 333;
    } else if (utils.contains(doubleVerts, delim)) {
      repeat2 = "∥";
      svgLabel = "doublevert";
      viewBoxWidth = 556;
    } else if (delim === "[" || delim === "\\lbrack") {
      top2 = "⎡";
      repeat2 = "⎢";
      bottom2 = "⎣";
      font = "Size4-Regular";
      svgLabel = "lbrack";
      viewBoxWidth = 667;
    } else if (delim === "]" || delim === "\\rbrack") {
      top2 = "⎤";
      repeat2 = "⎥";
      bottom2 = "⎦";
      font = "Size4-Regular";
      svgLabel = "rbrack";
      viewBoxWidth = 667;
    } else if (delim === "\\lfloor" || delim === "⌊") {
      repeat2 = top2 = "⎢";
      bottom2 = "⎣";
      font = "Size4-Regular";
      svgLabel = "lfloor";
      viewBoxWidth = 667;
    } else if (delim === "\\lceil" || delim === "⌈") {
      top2 = "⎡";
      repeat2 = bottom2 = "⎢";
      font = "Size4-Regular";
      svgLabel = "lceil";
      viewBoxWidth = 667;
    } else if (delim === "\\rfloor" || delim === "⌋") {
      repeat2 = top2 = "⎥";
      bottom2 = "⎦";
      font = "Size4-Regular";
      svgLabel = "rfloor";
      viewBoxWidth = 667;
    } else if (delim === "\\rceil" || delim === "⌉") {
      top2 = "⎤";
      repeat2 = bottom2 = "⎥";
      font = "Size4-Regular";
      svgLabel = "rceil";
      viewBoxWidth = 667;
    } else if (delim === "(" || delim === "\\lparen") {
      top2 = "⎛";
      repeat2 = "⎜";
      bottom2 = "⎝";
      font = "Size4-Regular";
      svgLabel = "lparen";
      viewBoxWidth = 875;
    } else if (delim === ")" || delim === "\\rparen") {
      top2 = "⎞";
      repeat2 = "⎟";
      bottom2 = "⎠";
      font = "Size4-Regular";
      svgLabel = "rparen";
      viewBoxWidth = 875;
    } else if (delim === "\\{" || delim === "\\lbrace") {
      top2 = "⎧";
      middle = "⎨";
      bottom2 = "⎩";
      repeat2 = "⎪";
      font = "Size4-Regular";
    } else if (delim === "\\}" || delim === "\\rbrace") {
      top2 = "⎫";
      middle = "⎬";
      bottom2 = "⎭";
      repeat2 = "⎪";
      font = "Size4-Regular";
    } else if (delim === "\\lgroup" || delim === "⟮") {
      top2 = "⎧";
      bottom2 = "⎩";
      repeat2 = "⎪";
      font = "Size4-Regular";
    } else if (delim === "\\rgroup" || delim === "⟯") {
      top2 = "⎫";
      bottom2 = "⎭";
      repeat2 = "⎪";
      font = "Size4-Regular";
    } else if (delim === "\\lmoustache" || delim === "⎰") {
      top2 = "⎧";
      bottom2 = "⎭";
      repeat2 = "⎪";
      font = "Size4-Regular";
    } else if (delim === "\\rmoustache" || delim === "⎱") {
      top2 = "⎫";
      bottom2 = "⎩";
      repeat2 = "⎪";
      font = "Size4-Regular";
    }
    var topMetrics = getMetrics(top2, font, mode);
    var topHeightTotal = topMetrics.height + topMetrics.depth;
    var repeatMetrics = getMetrics(repeat2, font, mode);
    var repeatHeightTotal = repeatMetrics.height + repeatMetrics.depth;
    var bottomMetrics = getMetrics(bottom2, font, mode);
    var bottomHeightTotal = bottomMetrics.height + bottomMetrics.depth;
    var middleHeightTotal = 0;
    var middleFactor = 1;
    if (middle !== null) {
      var middleMetrics = getMetrics(middle, font, mode);
      middleHeightTotal = middleMetrics.height + middleMetrics.depth;
      middleFactor = 2;
    }
    var minHeight = topHeightTotal + bottomHeightTotal + middleHeightTotal;
    var repeatCount = Math.max(0, Math.ceil((heightTotal - minHeight) / (middleFactor * repeatHeightTotal)));
    var realHeightTotal = minHeight + repeatCount * middleFactor * repeatHeightTotal;
    var axisHeight = options2.fontMetrics().axisHeight;
    if (center2) {
      axisHeight *= options2.sizeMultiplier;
    }
    var depth = realHeightTotal / 2 - axisHeight;
    var stack = [];
    if (svgLabel.length > 0) {
      var midHeight = realHeightTotal - topHeightTotal - bottomHeightTotal;
      var viewBoxHeight = Math.round(realHeightTotal * 1e3);
      var pathStr = tallDelim(svgLabel, Math.round(midHeight * 1e3));
      var path2 = new PathNode(svgLabel, pathStr);
      var width2 = (viewBoxWidth / 1e3).toFixed(3) + "em";
      var height = (viewBoxHeight / 1e3).toFixed(3) + "em";
      var svg2 = new SvgNode([path2], {
        "width": width2,
        "height": height,
        "viewBox": "0 0 " + viewBoxWidth + " " + viewBoxHeight
      });
      var wrapper = buildCommon.makeSvgSpan([], [svg2], options2);
      wrapper.height = viewBoxHeight / 1e3;
      wrapper.style.width = width2;
      wrapper.style.height = height;
      stack.push({
        type: "elem",
        elem: wrapper
      });
    } else {
      stack.push(makeGlyphSpan(bottom2, font, mode));
      stack.push(lap);
      if (middle === null) {
        var innerHeight = realHeightTotal - topHeightTotal - bottomHeightTotal + 2 * lapInEms;
        stack.push(makeInner(repeat2, innerHeight, options2));
      } else {
        var _innerHeight = (realHeightTotal - topHeightTotal - bottomHeightTotal - middleHeightTotal) / 2 + 2 * lapInEms;
        stack.push(makeInner(repeat2, _innerHeight, options2));
        stack.push(lap);
        stack.push(makeGlyphSpan(middle, font, mode));
        stack.push(lap);
        stack.push(makeInner(repeat2, _innerHeight, options2));
      }
      stack.push(lap);
      stack.push(makeGlyphSpan(top2, font, mode));
    }
    var newOptions = options2.havingBaseStyle(Style$1.TEXT);
    var inner2 = buildCommon.makeVList({
      positionType: "bottom",
      positionData: depth,
      children: stack
    }, newOptions);
    return styleWrap(buildCommon.makeSpan(["delimsizing", "mult"], [inner2], newOptions), Style$1.TEXT, options2, classes2);
  };
  var vbPad = 80;
  var emPad = 0.08;
  var sqrtSvg = function sqrtSvg2(sqrtName, height, viewBoxHeight, extraVinculum, options2) {
    var path2 = sqrtPath(sqrtName, extraVinculum, viewBoxHeight);
    var pathNode = new PathNode(sqrtName, path2);
    var svg2 = new SvgNode([pathNode], {
      // Note: 1000:1 ratio of viewBox to document em width.
      "width": "400em",
      "height": makeEm(height),
      "viewBox": "0 0 400000 " + viewBoxHeight,
      "preserveAspectRatio": "xMinYMin slice"
    });
    return buildCommon.makeSvgSpan(["hide-tail"], [svg2], options2);
  };
  var makeSqrtImage = function makeSqrtImage2(height, options2) {
    var newOptions = options2.havingBaseSizing();
    var delim = traverseSequence("\\surd", height * newOptions.sizeMultiplier, stackLargeDelimiterSequence, newOptions);
    var sizeMultiplier = newOptions.sizeMultiplier;
    var extraVinculum = Math.max(0, options2.minRuleThickness - options2.fontMetrics().sqrtRuleThickness);
    var span;
    var spanHeight = 0;
    var texHeight = 0;
    var viewBoxHeight = 0;
    var advanceWidth;
    if (delim.type === "small") {
      viewBoxHeight = 1e3 + 1e3 * extraVinculum + vbPad;
      if (height < 1) {
        sizeMultiplier = 1;
      } else if (height < 1.4) {
        sizeMultiplier = 0.7;
      }
      spanHeight = (1 + extraVinculum + emPad) / sizeMultiplier;
      texHeight = (1 + extraVinculum) / sizeMultiplier;
      span = sqrtSvg("sqrtMain", spanHeight, viewBoxHeight, extraVinculum, options2);
      span.style.minWidth = "0.853em";
      advanceWidth = 0.833 / sizeMultiplier;
    } else if (delim.type === "large") {
      viewBoxHeight = (1e3 + vbPad) * sizeToMaxHeight[delim.size];
      texHeight = (sizeToMaxHeight[delim.size] + extraVinculum) / sizeMultiplier;
      spanHeight = (sizeToMaxHeight[delim.size] + extraVinculum + emPad) / sizeMultiplier;
      span = sqrtSvg("sqrtSize" + delim.size, spanHeight, viewBoxHeight, extraVinculum, options2);
      span.style.minWidth = "1.02em";
      advanceWidth = 1 / sizeMultiplier;
    } else {
      spanHeight = height + extraVinculum + emPad;
      texHeight = height + extraVinculum;
      viewBoxHeight = Math.floor(1e3 * height + extraVinculum) + vbPad;
      span = sqrtSvg("sqrtTall", spanHeight, viewBoxHeight, extraVinculum, options2);
      span.style.minWidth = "0.742em";
      advanceWidth = 1.056;
    }
    span.height = texHeight;
    span.style.height = makeEm(spanHeight);
    return {
      span,
      advanceWidth,
      // Calculate the actual line width.
      // This actually should depend on the chosen font -- e.g. \boldmath
      // should use the thicker surd symbols from e.g. KaTeX_Main-Bold, and
      // have thicker rules.
      ruleWidth: (options2.fontMetrics().sqrtRuleThickness + extraVinculum) * sizeMultiplier
    };
  };
  var stackLargeDelimiters = ["(", "\\lparen", ")", "\\rparen", "[", "\\lbrack", "]", "\\rbrack", "\\{", "\\lbrace", "\\}", "\\rbrace", "\\lfloor", "\\rfloor", "⌊", "⌋", "\\lceil", "\\rceil", "⌈", "⌉", "\\surd"];
  var stackAlwaysDelimiters = ["\\uparrow", "\\downarrow", "\\updownarrow", "\\Uparrow", "\\Downarrow", "\\Updownarrow", "|", "\\|", "\\vert", "\\Vert", "\\lvert", "\\rvert", "\\lVert", "\\rVert", "\\lgroup", "\\rgroup", "⟮", "⟯", "\\lmoustache", "\\rmoustache", "⎰", "⎱"];
  var stackNeverDelimiters = ["<", ">", "\\langle", "\\rangle", "/", "\\backslash", "\\lt", "\\gt"];
  var sizeToMaxHeight = [0, 1.2, 1.8, 2.4, 3];
  var makeSizedDelim = function makeSizedDelim2(delim, size2, options2, mode, classes2) {
    if (delim === "<" || delim === "\\lt" || delim === "⟨") {
      delim = "\\langle";
    } else if (delim === ">" || delim === "\\gt" || delim === "⟩") {
      delim = "\\rangle";
    }
    if (utils.contains(stackLargeDelimiters, delim) || utils.contains(stackNeverDelimiters, delim)) {
      return makeLargeDelim(delim, size2, false, options2, mode, classes2);
    } else if (utils.contains(stackAlwaysDelimiters, delim)) {
      return makeStackedDelim(delim, sizeToMaxHeight[size2], false, options2, mode, classes2);
    } else {
      throw new ParseError("Illegal delimiter: '" + delim + "'");
    }
  };
  var stackNeverDelimiterSequence = [{
    type: "small",
    style: Style$1.SCRIPTSCRIPT
  }, {
    type: "small",
    style: Style$1.SCRIPT
  }, {
    type: "small",
    style: Style$1.TEXT
  }, {
    type: "large",
    size: 1
  }, {
    type: "large",
    size: 2
  }, {
    type: "large",
    size: 3
  }, {
    type: "large",
    size: 4
  }];
  var stackAlwaysDelimiterSequence = [{
    type: "small",
    style: Style$1.SCRIPTSCRIPT
  }, {
    type: "small",
    style: Style$1.SCRIPT
  }, {
    type: "small",
    style: Style$1.TEXT
  }, {
    type: "stack"
  }];
  var stackLargeDelimiterSequence = [{
    type: "small",
    style: Style$1.SCRIPTSCRIPT
  }, {
    type: "small",
    style: Style$1.SCRIPT
  }, {
    type: "small",
    style: Style$1.TEXT
  }, {
    type: "large",
    size: 1
  }, {
    type: "large",
    size: 2
  }, {
    type: "large",
    size: 3
  }, {
    type: "large",
    size: 4
  }, {
    type: "stack"
  }];
  var delimTypeToFont = function delimTypeToFont2(type2) {
    if (type2.type === "small") {
      return "Main-Regular";
    } else if (type2.type === "large") {
      return "Size" + type2.size + "-Regular";
    } else if (type2.type === "stack") {
      return "Size4-Regular";
    } else {
      throw new Error("Add support for delim type '" + type2.type + "' here.");
    }
  };
  var traverseSequence = function traverseSequence2(delim, height, sequence2, options2) {
    var start2 = Math.min(2, 3 - options2.style.size);
    for (var i2 = start2; i2 < sequence2.length; i2++) {
      if (sequence2[i2].type === "stack") {
        break;
      }
      var metrics = getMetrics(delim, delimTypeToFont(sequence2[i2]), "math");
      var heightDepth = metrics.height + metrics.depth;
      if (sequence2[i2].type === "small") {
        var newOptions = options2.havingBaseStyle(sequence2[i2].style);
        heightDepth *= newOptions.sizeMultiplier;
      }
      if (heightDepth > height) {
        return sequence2[i2];
      }
    }
    return sequence2[sequence2.length - 1];
  };
  var makeCustomSizedDelim = function makeCustomSizedDelim2(delim, height, center2, options2, mode, classes2) {
    if (delim === "<" || delim === "\\lt" || delim === "⟨") {
      delim = "\\langle";
    } else if (delim === ">" || delim === "\\gt" || delim === "⟩") {
      delim = "\\rangle";
    }
    var sequence2;
    if (utils.contains(stackNeverDelimiters, delim)) {
      sequence2 = stackNeverDelimiterSequence;
    } else if (utils.contains(stackLargeDelimiters, delim)) {
      sequence2 = stackLargeDelimiterSequence;
    } else {
      sequence2 = stackAlwaysDelimiterSequence;
    }
    var delimType = traverseSequence(delim, height, sequence2, options2);
    if (delimType.type === "small") {
      return makeSmallDelim(delim, delimType.style, center2, options2, mode, classes2);
    } else if (delimType.type === "large") {
      return makeLargeDelim(delim, delimType.size, center2, options2, mode, classes2);
    } else {
      return makeStackedDelim(delim, height, center2, options2, mode, classes2);
    }
  };
  var makeLeftRightDelim = function makeLeftRightDelim2(delim, height, depth, options2, mode, classes2) {
    var axisHeight = options2.fontMetrics().axisHeight * options2.sizeMultiplier;
    var delimiterFactor = 901;
    var delimiterExtend = 5 / options2.fontMetrics().ptPerEm;
    var maxDistFromAxis = Math.max(height - axisHeight, depth + axisHeight);
    var totalHeight = Math.max(
      // In real TeX, calculations are done using integral values which are
      // 65536 per pt, or 655360 per em. So, the division here truncates in
      // TeX but doesn't here, producing different results. If we wanted to
      // exactly match TeX's calculation, we could do
      //   Math.floor(655360 * maxDistFromAxis / 500) *
      //    delimiterFactor / 655360
      // (To see the difference, compare
      //    x^{x^{\left(\rule{0.1em}{0.68em}\right)}}
      // in TeX and KaTeX)
      maxDistFromAxis / 500 * delimiterFactor,
      2 * maxDistFromAxis - delimiterExtend
    );
    return makeCustomSizedDelim(delim, totalHeight, true, options2, mode, classes2);
  };
  var delimiter = {
    sqrtImage: makeSqrtImage,
    sizedDelim: makeSizedDelim,
    sizeToMaxHeight,
    customSizedDelim: makeCustomSizedDelim,
    leftRightDelim: makeLeftRightDelim
  };
  var delimiterSizes = {
    "\\bigl": {
      mclass: "mopen",
      size: 1
    },
    "\\Bigl": {
      mclass: "mopen",
      size: 2
    },
    "\\biggl": {
      mclass: "mopen",
      size: 3
    },
    "\\Biggl": {
      mclass: "mopen",
      size: 4
    },
    "\\bigr": {
      mclass: "mclose",
      size: 1
    },
    "\\Bigr": {
      mclass: "mclose",
      size: 2
    },
    "\\biggr": {
      mclass: "mclose",
      size: 3
    },
    "\\Biggr": {
      mclass: "mclose",
      size: 4
    },
    "\\bigm": {
      mclass: "mrel",
      size: 1
    },
    "\\Bigm": {
      mclass: "mrel",
      size: 2
    },
    "\\biggm": {
      mclass: "mrel",
      size: 3
    },
    "\\Biggm": {
      mclass: "mrel",
      size: 4
    },
    "\\big": {
      mclass: "mord",
      size: 1
    },
    "\\Big": {
      mclass: "mord",
      size: 2
    },
    "\\bigg": {
      mclass: "mord",
      size: 3
    },
    "\\Bigg": {
      mclass: "mord",
      size: 4
    }
  };
  var delimiters = ["(", "\\lparen", ")", "\\rparen", "[", "\\lbrack", "]", "\\rbrack", "\\{", "\\lbrace", "\\}", "\\rbrace", "\\lfloor", "\\rfloor", "⌊", "⌋", "\\lceil", "\\rceil", "⌈", "⌉", "<", ">", "\\langle", "⟨", "\\rangle", "⟩", "\\lt", "\\gt", "\\lvert", "\\rvert", "\\lVert", "\\rVert", "\\lgroup", "\\rgroup", "⟮", "⟯", "\\lmoustache", "\\rmoustache", "⎰", "⎱", "/", "\\backslash", "|", "\\vert", "\\|", "\\Vert", "\\uparrow", "\\Uparrow", "\\downarrow", "\\Downarrow", "\\updownarrow", "\\Updownarrow", "."];
  function checkDelimiter(delim, context) {
    var symDelim = checkSymbolNodeType(delim);
    if (symDelim && utils.contains(delimiters, symDelim.text)) {
      return symDelim;
    } else if (symDelim) {
      throw new ParseError("Invalid delimiter '" + symDelim.text + "' after '" + context.funcName + "'", delim);
    } else {
      throw new ParseError("Invalid delimiter type '" + delim.type + "'", delim);
    }
  }
  defineFunction({
    type: "delimsizing",
    names: ["\\bigl", "\\Bigl", "\\biggl", "\\Biggl", "\\bigr", "\\Bigr", "\\biggr", "\\Biggr", "\\bigm", "\\Bigm", "\\biggm", "\\Biggm", "\\big", "\\Big", "\\bigg", "\\Bigg"],
    props: {
      numArgs: 1,
      argTypes: ["primitive"]
    },
    handler: (context, args) => {
      var delim = checkDelimiter(args[0], context);
      return {
        type: "delimsizing",
        mode: context.parser.mode,
        size: delimiterSizes[context.funcName].size,
        mclass: delimiterSizes[context.funcName].mclass,
        delim: delim.text
      };
    },
    htmlBuilder: (group, options2) => {
      if (group.delim === ".") {
        return buildCommon.makeSpan([group.mclass]);
      }
      return delimiter.sizedDelim(group.delim, group.size, options2, group.mode, [group.mclass]);
    },
    mathmlBuilder: (group) => {
      var children2 = [];
      if (group.delim !== ".") {
        children2.push(makeText(group.delim, group.mode));
      }
      var node2 = new mathMLTree.MathNode("mo", children2);
      if (group.mclass === "mopen" || group.mclass === "mclose") {
        node2.setAttribute("fence", "true");
      } else {
        node2.setAttribute("fence", "false");
      }
      node2.setAttribute("stretchy", "true");
      var size2 = makeEm(delimiter.sizeToMaxHeight[group.size]);
      node2.setAttribute("minsize", size2);
      node2.setAttribute("maxsize", size2);
      return node2;
    }
  });
  function assertParsed(group) {
    if (!group.body) {
      throw new Error("Bug: The leftright ParseNode wasn't fully parsed.");
    }
  }
  defineFunction({
    type: "leftright-right",
    names: ["\\right"],
    props: {
      numArgs: 1,
      primitive: true
    },
    handler: (context, args) => {
      var color2 = context.parser.gullet.macros.get("\\current@color");
      if (color2 && typeof color2 !== "string") {
        throw new ParseError("\\current@color set to non-string in \\right");
      }
      return {
        type: "leftright-right",
        mode: context.parser.mode,
        delim: checkDelimiter(args[0], context).text,
        color: color2
        // undefined if not set via \color
      };
    }
  });
  defineFunction({
    type: "leftright",
    names: ["\\left"],
    props: {
      numArgs: 1,
      primitive: true
    },
    handler: (context, args) => {
      var delim = checkDelimiter(args[0], context);
      var parser2 = context.parser;
      ++parser2.leftrightDepth;
      var body = parser2.parseExpression(false);
      --parser2.leftrightDepth;
      parser2.expect("\\right", false);
      var right2 = assertNodeType(parser2.parseFunction(), "leftright-right");
      return {
        type: "leftright",
        mode: parser2.mode,
        body,
        left: delim.text,
        right: right2.delim,
        rightColor: right2.color
      };
    },
    htmlBuilder: (group, options2) => {
      assertParsed(group);
      var inner2 = buildExpression$1(group.body, options2, true, ["mopen", "mclose"]);
      var innerHeight = 0;
      var innerDepth = 0;
      var hadMiddle = false;
      for (var i2 = 0; i2 < inner2.length; i2++) {
        if (inner2[i2].isMiddle) {
          hadMiddle = true;
        } else {
          innerHeight = Math.max(inner2[i2].height, innerHeight);
          innerDepth = Math.max(inner2[i2].depth, innerDepth);
        }
      }
      innerHeight *= options2.sizeMultiplier;
      innerDepth *= options2.sizeMultiplier;
      var leftDelim;
      if (group.left === ".") {
        leftDelim = makeNullDelimiter(options2, ["mopen"]);
      } else {
        leftDelim = delimiter.leftRightDelim(group.left, innerHeight, innerDepth, options2, group.mode, ["mopen"]);
      }
      inner2.unshift(leftDelim);
      if (hadMiddle) {
        for (var _i6 = 1; _i6 < inner2.length; _i6++) {
          var middleDelim = inner2[_i6];
          var isMiddle = middleDelim.isMiddle;
          if (isMiddle) {
            inner2[_i6] = delimiter.leftRightDelim(isMiddle.delim, innerHeight, innerDepth, isMiddle.options, group.mode, []);
          }
        }
      }
      var rightDelim;
      if (group.right === ".") {
        rightDelim = makeNullDelimiter(options2, ["mclose"]);
      } else {
        var colorOptions = group.rightColor ? options2.withColor(group.rightColor) : options2;
        rightDelim = delimiter.leftRightDelim(group.right, innerHeight, innerDepth, colorOptions, group.mode, ["mclose"]);
      }
      inner2.push(rightDelim);
      return buildCommon.makeSpan(["minner"], inner2, options2);
    },
    mathmlBuilder: (group, options2) => {
      assertParsed(group);
      var inner2 = buildExpression(group.body, options2);
      if (group.left !== ".") {
        var leftNode = new mathMLTree.MathNode("mo", [makeText(group.left, group.mode)]);
        leftNode.setAttribute("fence", "true");
        inner2.unshift(leftNode);
      }
      if (group.right !== ".") {
        var rightNode = new mathMLTree.MathNode("mo", [makeText(group.right, group.mode)]);
        rightNode.setAttribute("fence", "true");
        if (group.rightColor) {
          rightNode.setAttribute("mathcolor", group.rightColor);
        }
        inner2.push(rightNode);
      }
      return makeRow(inner2);
    }
  });
  defineFunction({
    type: "middle",
    names: ["\\middle"],
    props: {
      numArgs: 1,
      primitive: true
    },
    handler: (context, args) => {
      var delim = checkDelimiter(args[0], context);
      if (!context.parser.leftrightDepth) {
        throw new ParseError("\\middle without preceding \\left", delim);
      }
      return {
        type: "middle",
        mode: context.parser.mode,
        delim: delim.text
      };
    },
    htmlBuilder: (group, options2) => {
      var middleDelim;
      if (group.delim === ".") {
        middleDelim = makeNullDelimiter(options2, []);
      } else {
        middleDelim = delimiter.sizedDelim(group.delim, 1, options2, group.mode, []);
        var isMiddle = {
          delim: group.delim,
          options: options2
        };
        middleDelim.isMiddle = isMiddle;
      }
      return middleDelim;
    },
    mathmlBuilder: (group, options2) => {
      var textNode = group.delim === "\\vert" || group.delim === "|" ? makeText("|", "text") : makeText(group.delim, group.mode);
      var middleNode = new mathMLTree.MathNode("mo", [textNode]);
      middleNode.setAttribute("fence", "true");
      middleNode.setAttribute("lspace", "0.05em");
      middleNode.setAttribute("rspace", "0.05em");
      return middleNode;
    }
  });
  var htmlBuilder$7 = (group, options2) => {
    var inner2 = buildCommon.wrapFragment(buildGroup$1(group.body, options2), options2);
    var label = group.label.slice(1);
    var scale = options2.sizeMultiplier;
    var img;
    var imgShift = 0;
    var isSingleChar = utils.isCharacterBox(group.body);
    if (label === "sout") {
      img = buildCommon.makeSpan(["stretchy", "sout"]);
      img.height = options2.fontMetrics().defaultRuleThickness / scale;
      imgShift = -0.5 * options2.fontMetrics().xHeight;
    } else if (label === "phase") {
      var lineWeight = calculateSize({
        number: 0.6,
        unit: "pt"
      }, options2);
      var clearance = calculateSize({
        number: 0.35,
        unit: "ex"
      }, options2);
      var newOptions = options2.havingBaseSizing();
      scale = scale / newOptions.sizeMultiplier;
      var angleHeight = inner2.height + inner2.depth + lineWeight + clearance;
      inner2.style.paddingLeft = makeEm(angleHeight / 2 + lineWeight);
      var viewBoxHeight = Math.floor(1e3 * angleHeight * scale);
      var path2 = phasePath(viewBoxHeight);
      var svgNode2 = new SvgNode([new PathNode("phase", path2)], {
        "width": "400em",
        "height": makeEm(viewBoxHeight / 1e3),
        "viewBox": "0 0 400000 " + viewBoxHeight,
        "preserveAspectRatio": "xMinYMin slice"
      });
      img = buildCommon.makeSvgSpan(["hide-tail"], [svgNode2], options2);
      img.style.height = makeEm(angleHeight);
      imgShift = inner2.depth + lineWeight + clearance;
    } else {
      if (/cancel/.test(label)) {
        if (!isSingleChar) {
          inner2.classes.push("cancel-pad");
        }
      } else if (label === "angl") {
        inner2.classes.push("anglpad");
      } else {
        inner2.classes.push("boxpad");
      }
      var topPad = 0;
      var bottomPad = 0;
      var ruleThickness = 0;
      if (/box/.test(label)) {
        ruleThickness = Math.max(
          options2.fontMetrics().fboxrule,
          // default
          options2.minRuleThickness
          // User override.
        );
        topPad = options2.fontMetrics().fboxsep + (label === "colorbox" ? 0 : ruleThickness);
        bottomPad = topPad;
      } else if (label === "angl") {
        ruleThickness = Math.max(options2.fontMetrics().defaultRuleThickness, options2.minRuleThickness);
        topPad = 4 * ruleThickness;
        bottomPad = Math.max(0, 0.25 - inner2.depth);
      } else {
        topPad = isSingleChar ? 0.2 : 0;
        bottomPad = topPad;
      }
      img = stretchy.encloseSpan(inner2, label, topPad, bottomPad, options2);
      if (/fbox|boxed|fcolorbox/.test(label)) {
        img.style.borderStyle = "solid";
        img.style.borderWidth = makeEm(ruleThickness);
      } else if (label === "angl" && ruleThickness !== 0.049) {
        img.style.borderTopWidth = makeEm(ruleThickness);
        img.style.borderRightWidth = makeEm(ruleThickness);
      }
      imgShift = inner2.depth + bottomPad;
      if (group.backgroundColor) {
        img.style.backgroundColor = group.backgroundColor;
        if (group.borderColor) {
          img.style.borderColor = group.borderColor;
        }
      }
    }
    var vlist;
    if (group.backgroundColor) {
      vlist = buildCommon.makeVList({
        positionType: "individualShift",
        children: [
          // Put the color background behind inner;
          {
            type: "elem",
            elem: img,
            shift: imgShift
          },
          {
            type: "elem",
            elem: inner2,
            shift: 0
          }
        ]
      }, options2);
    } else {
      var classes2 = /cancel|phase/.test(label) ? ["svg-align"] : [];
      vlist = buildCommon.makeVList({
        positionType: "individualShift",
        children: [
          // Write the \cancel stroke on top of inner.
          {
            type: "elem",
            elem: inner2,
            shift: 0
          },
          {
            type: "elem",
            elem: img,
            shift: imgShift,
            wrapperClasses: classes2
          }
        ]
      }, options2);
    }
    if (/cancel/.test(label)) {
      vlist.height = inner2.height;
      vlist.depth = inner2.depth;
    }
    if (/cancel/.test(label) && !isSingleChar) {
      return buildCommon.makeSpan(["mord", "cancel-lap"], [vlist], options2);
    } else {
      return buildCommon.makeSpan(["mord"], [vlist], options2);
    }
  };
  var mathmlBuilder$6 = (group, options2) => {
    var fboxsep = 0;
    var node2 = new mathMLTree.MathNode(group.label.indexOf("colorbox") > -1 ? "mpadded" : "menclose", [buildGroup(group.body, options2)]);
    switch (group.label) {
      case "\\cancel":
        node2.setAttribute("notation", "updiagonalstrike");
        break;
      case "\\bcancel":
        node2.setAttribute("notation", "downdiagonalstrike");
        break;
      case "\\phase":
        node2.setAttribute("notation", "phasorangle");
        break;
      case "\\sout":
        node2.setAttribute("notation", "horizontalstrike");
        break;
      case "\\fbox":
        node2.setAttribute("notation", "box");
        break;
      case "\\angl":
        node2.setAttribute("notation", "actuarial");
        break;
      case "\\fcolorbox":
      case "\\colorbox":
        fboxsep = options2.fontMetrics().fboxsep * options2.fontMetrics().ptPerEm;
        node2.setAttribute("width", "+" + 2 * fboxsep + "pt");
        node2.setAttribute("height", "+" + 2 * fboxsep + "pt");
        node2.setAttribute("lspace", fboxsep + "pt");
        node2.setAttribute("voffset", fboxsep + "pt");
        if (group.label === "\\fcolorbox") {
          var thk = Math.max(
            options2.fontMetrics().fboxrule,
            // default
            options2.minRuleThickness
            // user override
          );
          node2.setAttribute("style", "border: " + thk + "em solid " + String(group.borderColor));
        }
        break;
      case "\\xcancel":
        node2.setAttribute("notation", "updiagonalstrike downdiagonalstrike");
        break;
    }
    if (group.backgroundColor) {
      node2.setAttribute("mathbackground", group.backgroundColor);
    }
    return node2;
  };
  defineFunction({
    type: "enclose",
    names: ["\\colorbox"],
    props: {
      numArgs: 2,
      allowedInText: true,
      argTypes: ["color", "text"]
    },
    handler(_ref, args, optArgs) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var color2 = assertNodeType(args[0], "color-token").color;
      var body = args[1];
      return {
        type: "enclose",
        mode: parser2.mode,
        label: funcName,
        backgroundColor: color2,
        body
      };
    },
    htmlBuilder: htmlBuilder$7,
    mathmlBuilder: mathmlBuilder$6
  });
  defineFunction({
    type: "enclose",
    names: ["\\fcolorbox"],
    props: {
      numArgs: 3,
      allowedInText: true,
      argTypes: ["color", "color", "text"]
    },
    handler(_ref2, args, optArgs) {
      var {
        parser: parser2,
        funcName
      } = _ref2;
      var borderColor = assertNodeType(args[0], "color-token").color;
      var backgroundColor = assertNodeType(args[1], "color-token").color;
      var body = args[2];
      return {
        type: "enclose",
        mode: parser2.mode,
        label: funcName,
        backgroundColor,
        borderColor,
        body
      };
    },
    htmlBuilder: htmlBuilder$7,
    mathmlBuilder: mathmlBuilder$6
  });
  defineFunction({
    type: "enclose",
    names: ["\\fbox"],
    props: {
      numArgs: 1,
      argTypes: ["hbox"],
      allowedInText: true
    },
    handler(_ref3, args) {
      var {
        parser: parser2
      } = _ref3;
      return {
        type: "enclose",
        mode: parser2.mode,
        label: "\\fbox",
        body: args[0]
      };
    }
  });
  defineFunction({
    type: "enclose",
    names: ["\\cancel", "\\bcancel", "\\xcancel", "\\sout", "\\phase"],
    props: {
      numArgs: 1
    },
    handler(_ref4, args) {
      var {
        parser: parser2,
        funcName
      } = _ref4;
      var body = args[0];
      return {
        type: "enclose",
        mode: parser2.mode,
        label: funcName,
        body
      };
    },
    htmlBuilder: htmlBuilder$7,
    mathmlBuilder: mathmlBuilder$6
  });
  defineFunction({
    type: "enclose",
    names: ["\\angl"],
    props: {
      numArgs: 1,
      argTypes: ["hbox"],
      allowedInText: false
    },
    handler(_ref5, args) {
      var {
        parser: parser2
      } = _ref5;
      return {
        type: "enclose",
        mode: parser2.mode,
        label: "\\angl",
        body: args[0]
      };
    }
  });
  var _environments = {};
  function defineEnvironment(_ref) {
    var {
      type: type2,
      names,
      props,
      handler,
      htmlBuilder: htmlBuilder2,
      mathmlBuilder: mathmlBuilder2
    } = _ref;
    var data = {
      type: type2,
      numArgs: props.numArgs || 0,
      allowedInText: false,
      numOptionalArgs: 0,
      handler
    };
    for (var i2 = 0; i2 < names.length; ++i2) {
      _environments[names[i2]] = data;
    }
    if (htmlBuilder2) {
      _htmlGroupBuilders[type2] = htmlBuilder2;
    }
    if (mathmlBuilder2) {
      _mathmlGroupBuilders[type2] = mathmlBuilder2;
    }
  }
  var _macros = {};
  function defineMacro(name, body) {
    _macros[name] = body;
  }
  function getHLines(parser2) {
    var hlineInfo = [];
    parser2.consumeSpaces();
    var nxt = parser2.fetch().text;
    if (nxt === "\\relax") {
      parser2.consume();
      parser2.consumeSpaces();
      nxt = parser2.fetch().text;
    }
    while (nxt === "\\hline" || nxt === "\\hdashline") {
      parser2.consume();
      hlineInfo.push(nxt === "\\hdashline");
      parser2.consumeSpaces();
      nxt = parser2.fetch().text;
    }
    return hlineInfo;
  }
  var validateAmsEnvironmentContext = (context) => {
    var settings = context.parser.settings;
    if (!settings.displayMode) {
      throw new ParseError("{" + context.envName + "} can be used only in display mode.");
    }
  };
  function getAutoTag(name) {
    if (name.indexOf("ed") === -1) {
      return name.indexOf("*") === -1;
    }
  }
  function parseArray(parser2, _ref, style) {
    var {
      hskipBeforeAndAfter,
      addJot,
      cols,
      arraystretch,
      colSeparationType,
      autoTag,
      singleRow,
      emptySingleRow,
      maxNumCols,
      leqno
    } = _ref;
    parser2.gullet.beginGroup();
    if (!singleRow) {
      parser2.gullet.macros.set("\\cr", "\\\\\\relax");
    }
    if (!arraystretch) {
      var stretch = parser2.gullet.expandMacroAsText("\\arraystretch");
      if (stretch == null) {
        arraystretch = 1;
      } else {
        arraystretch = parseFloat(stretch);
        if (!arraystretch || arraystretch < 0) {
          throw new ParseError("Invalid \\arraystretch: " + stretch);
        }
      }
    }
    parser2.gullet.beginGroup();
    var row = [];
    var body = [row];
    var rowGaps = [];
    var hLinesBeforeRow = [];
    var tags2 = autoTag != null ? [] : void 0;
    function beginRow() {
      if (autoTag) {
        parser2.gullet.macros.set("\\@eqnsw", "1", true);
      }
    }
    function endRow() {
      if (tags2) {
        if (parser2.gullet.macros.get("\\df@tag")) {
          tags2.push(parser2.subparse([new Token("\\df@tag")]));
          parser2.gullet.macros.set("\\df@tag", void 0, true);
        } else {
          tags2.push(Boolean(autoTag) && parser2.gullet.macros.get("\\@eqnsw") === "1");
        }
      }
    }
    beginRow();
    hLinesBeforeRow.push(getHLines(parser2));
    while (true) {
      var cell = parser2.parseExpression(false, singleRow ? "\\end" : "\\\\");
      parser2.gullet.endGroup();
      parser2.gullet.beginGroup();
      cell = {
        type: "ordgroup",
        mode: parser2.mode,
        body: cell
      };
      if (style) {
        cell = {
          type: "styling",
          mode: parser2.mode,
          style,
          body: [cell]
        };
      }
      row.push(cell);
      var next2 = parser2.fetch().text;
      if (next2 === "&") {
        if (maxNumCols && row.length === maxNumCols) {
          if (singleRow || colSeparationType) {
            throw new ParseError("Too many tab characters: &", parser2.nextToken);
          } else {
            parser2.settings.reportNonstrict("textEnv", "Too few columns specified in the {array} column argument.");
          }
        }
        parser2.consume();
      } else if (next2 === "\\end") {
        endRow();
        if (row.length === 1 && cell.type === "styling" && cell.body[0].body.length === 0 && (body.length > 1 || !emptySingleRow)) {
          body.pop();
        }
        if (hLinesBeforeRow.length < body.length + 1) {
          hLinesBeforeRow.push([]);
        }
        break;
      } else if (next2 === "\\\\") {
        parser2.consume();
        var size2 = void 0;
        if (parser2.gullet.future().text !== " ") {
          size2 = parser2.parseSizeGroup(true);
        }
        rowGaps.push(size2 ? size2.value : null);
        endRow();
        hLinesBeforeRow.push(getHLines(parser2));
        row = [];
        body.push(row);
        beginRow();
      } else {
        throw new ParseError("Expected & or \\\\ or \\cr or \\end", parser2.nextToken);
      }
    }
    parser2.gullet.endGroup();
    parser2.gullet.endGroup();
    return {
      type: "array",
      mode: parser2.mode,
      addJot,
      arraystretch,
      body,
      cols,
      rowGaps,
      hskipBeforeAndAfter,
      hLinesBeforeRow,
      colSeparationType,
      tags: tags2,
      leqno
    };
  }
  function dCellStyle(envName) {
    if (envName.slice(0, 1) === "d") {
      return "display";
    } else {
      return "text";
    }
  }
  var htmlBuilder$6 = function htmlBuilder2(group, options2) {
    var r;
    var c2;
    var nr = group.body.length;
    var hLinesBeforeRow = group.hLinesBeforeRow;
    var nc = 0;
    var body = new Array(nr);
    var hlines = [];
    var ruleThickness = Math.max(
      // From LaTeX \showthe\arrayrulewidth. Equals 0.04 em.
      options2.fontMetrics().arrayRuleWidth,
      options2.minRuleThickness
      // User override.
    );
    var pt = 1 / options2.fontMetrics().ptPerEm;
    var arraycolsep = 5 * pt;
    if (group.colSeparationType && group.colSeparationType === "small") {
      var localMultiplier = options2.havingStyle(Style$1.SCRIPT).sizeMultiplier;
      arraycolsep = 0.2778 * (localMultiplier / options2.sizeMultiplier);
    }
    var baselineskip = group.colSeparationType === "CD" ? calculateSize({
      number: 3,
      unit: "ex"
    }, options2) : 12 * pt;
    var jot = 3 * pt;
    var arrayskip = group.arraystretch * baselineskip;
    var arstrutHeight = 0.7 * arrayskip;
    var arstrutDepth = 0.3 * arrayskip;
    var totalHeight = 0;
    function setHLinePos(hlinesInGap) {
      for (var i2 = 0; i2 < hlinesInGap.length; ++i2) {
        if (i2 > 0) {
          totalHeight += 0.25;
        }
        hlines.push({
          pos: totalHeight,
          isDashed: hlinesInGap[i2]
        });
      }
    }
    setHLinePos(hLinesBeforeRow[0]);
    for (r = 0; r < group.body.length; ++r) {
      var inrow = group.body[r];
      var height = arstrutHeight;
      var depth = arstrutDepth;
      if (nc < inrow.length) {
        nc = inrow.length;
      }
      var outrow = new Array(inrow.length);
      for (c2 = 0; c2 < inrow.length; ++c2) {
        var elt = buildGroup$1(inrow[c2], options2);
        if (depth < elt.depth) {
          depth = elt.depth;
        }
        if (height < elt.height) {
          height = elt.height;
        }
        outrow[c2] = elt;
      }
      var rowGap = group.rowGaps[r];
      var gap = 0;
      if (rowGap) {
        gap = calculateSize(rowGap, options2);
        if (gap > 0) {
          gap += arstrutDepth;
          if (depth < gap) {
            depth = gap;
          }
          gap = 0;
        }
      }
      if (group.addJot) {
        depth += jot;
      }
      outrow.height = height;
      outrow.depth = depth;
      totalHeight += height;
      outrow.pos = totalHeight;
      totalHeight += depth + gap;
      body[r] = outrow;
      setHLinePos(hLinesBeforeRow[r + 1]);
    }
    var offset = totalHeight / 2 + options2.fontMetrics().axisHeight;
    var colDescriptions = group.cols || [];
    var cols = [];
    var colSep;
    var colDescrNum;
    var tagSpans = [];
    if (group.tags && group.tags.some((tag2) => tag2)) {
      for (r = 0; r < nr; ++r) {
        var rw = body[r];
        var shift = rw.pos - offset;
        var tag = group.tags[r];
        var tagSpan = void 0;
        if (tag === true) {
          tagSpan = buildCommon.makeSpan(["eqn-num"], [], options2);
        } else if (tag === false) {
          tagSpan = buildCommon.makeSpan([], [], options2);
        } else {
          tagSpan = buildCommon.makeSpan([], buildExpression$1(tag, options2, true), options2);
        }
        tagSpan.depth = rw.depth;
        tagSpan.height = rw.height;
        tagSpans.push({
          type: "elem",
          elem: tagSpan,
          shift
        });
      }
    }
    for (
      c2 = 0, colDescrNum = 0;
      // Continue while either there are more columns or more column
      // descriptions, so trailing separators don't get lost.
      c2 < nc || colDescrNum < colDescriptions.length;
      ++c2, ++colDescrNum
    ) {
      var colDescr = colDescriptions[colDescrNum] || {};
      var firstSeparator = true;
      while (colDescr.type === "separator") {
        if (!firstSeparator) {
          colSep = buildCommon.makeSpan(["arraycolsep"], []);
          colSep.style.width = makeEm(options2.fontMetrics().doubleRuleSep);
          cols.push(colSep);
        }
        if (colDescr.separator === "|" || colDescr.separator === ":") {
          var lineType2 = colDescr.separator === "|" ? "solid" : "dashed";
          var separator = buildCommon.makeSpan(["vertical-separator"], [], options2);
          separator.style.height = makeEm(totalHeight);
          separator.style.borderRightWidth = makeEm(ruleThickness);
          separator.style.borderRightStyle = lineType2;
          separator.style.margin = "0 " + makeEm(-ruleThickness / 2);
          var _shift = totalHeight - offset;
          if (_shift) {
            separator.style.verticalAlign = makeEm(-_shift);
          }
          cols.push(separator);
        } else {
          throw new ParseError("Invalid separator type: " + colDescr.separator);
        }
        colDescrNum++;
        colDescr = colDescriptions[colDescrNum] || {};
        firstSeparator = false;
      }
      if (c2 >= nc) {
        continue;
      }
      var sepwidth = void 0;
      if (c2 > 0 || group.hskipBeforeAndAfter) {
        sepwidth = utils.deflt(colDescr.pregap, arraycolsep);
        if (sepwidth !== 0) {
          colSep = buildCommon.makeSpan(["arraycolsep"], []);
          colSep.style.width = makeEm(sepwidth);
          cols.push(colSep);
        }
      }
      var col = [];
      for (r = 0; r < nr; ++r) {
        var row = body[r];
        var elem = row[c2];
        if (!elem) {
          continue;
        }
        var _shift2 = row.pos - offset;
        elem.depth = row.depth;
        elem.height = row.height;
        col.push({
          type: "elem",
          elem,
          shift: _shift2
        });
      }
      col = buildCommon.makeVList({
        positionType: "individualShift",
        children: col
      }, options2);
      col = buildCommon.makeSpan(["col-align-" + (colDescr.align || "c")], [col]);
      cols.push(col);
      if (c2 < nc - 1 || group.hskipBeforeAndAfter) {
        sepwidth = utils.deflt(colDescr.postgap, arraycolsep);
        if (sepwidth !== 0) {
          colSep = buildCommon.makeSpan(["arraycolsep"], []);
          colSep.style.width = makeEm(sepwidth);
          cols.push(colSep);
        }
      }
    }
    body = buildCommon.makeSpan(["mtable"], cols);
    if (hlines.length > 0) {
      var line2 = buildCommon.makeLineSpan("hline", options2, ruleThickness);
      var dashes = buildCommon.makeLineSpan("hdashline", options2, ruleThickness);
      var vListElems = [{
        type: "elem",
        elem: body,
        shift: 0
      }];
      while (hlines.length > 0) {
        var hline = hlines.pop();
        var lineShift = hline.pos - offset;
        if (hline.isDashed) {
          vListElems.push({
            type: "elem",
            elem: dashes,
            shift: lineShift
          });
        } else {
          vListElems.push({
            type: "elem",
            elem: line2,
            shift: lineShift
          });
        }
      }
      body = buildCommon.makeVList({
        positionType: "individualShift",
        children: vListElems
      }, options2);
    }
    if (tagSpans.length === 0) {
      return buildCommon.makeSpan(["mord"], [body], options2);
    } else {
      var eqnNumCol = buildCommon.makeVList({
        positionType: "individualShift",
        children: tagSpans
      }, options2);
      eqnNumCol = buildCommon.makeSpan(["tag"], [eqnNumCol], options2);
      return buildCommon.makeFragment([body, eqnNumCol]);
    }
  };
  var alignMap = {
    c: "center ",
    l: "left ",
    r: "right "
  };
  var mathmlBuilder$5 = function mathmlBuilder2(group, options2) {
    var tbl = [];
    var glue = new mathMLTree.MathNode("mtd", [], ["mtr-glue"]);
    var tag = new mathMLTree.MathNode("mtd", [], ["mml-eqn-num"]);
    for (var i2 = 0; i2 < group.body.length; i2++) {
      var rw = group.body[i2];
      var row = [];
      for (var j = 0; j < rw.length; j++) {
        row.push(new mathMLTree.MathNode("mtd", [buildGroup(rw[j], options2)]));
      }
      if (group.tags && group.tags[i2]) {
        row.unshift(glue);
        row.push(glue);
        if (group.leqno) {
          row.unshift(tag);
        } else {
          row.push(tag);
        }
      }
      tbl.push(new mathMLTree.MathNode("mtr", row));
    }
    var table = new mathMLTree.MathNode("mtable", tbl);
    var gap = group.arraystretch === 0.5 ? 0.1 : 0.16 + group.arraystretch - 1 + (group.addJot ? 0.09 : 0);
    table.setAttribute("rowspacing", makeEm(gap));
    var menclose = "";
    var align = "";
    if (group.cols && group.cols.length > 0) {
      var cols = group.cols;
      var columnLines = "";
      var prevTypeWasAlign = false;
      var iStart = 0;
      var iEnd = cols.length;
      if (cols[0].type === "separator") {
        menclose += "top ";
        iStart = 1;
      }
      if (cols[cols.length - 1].type === "separator") {
        menclose += "bottom ";
        iEnd -= 1;
      }
      for (var _i6 = iStart; _i6 < iEnd; _i6++) {
        if (cols[_i6].type === "align") {
          align += alignMap[cols[_i6].align];
          if (prevTypeWasAlign) {
            columnLines += "none ";
          }
          prevTypeWasAlign = true;
        } else if (cols[_i6].type === "separator") {
          if (prevTypeWasAlign) {
            columnLines += cols[_i6].separator === "|" ? "solid " : "dashed ";
            prevTypeWasAlign = false;
          }
        }
      }
      table.setAttribute("columnalign", align.trim());
      if (/[sd]/.test(columnLines)) {
        table.setAttribute("columnlines", columnLines.trim());
      }
    }
    if (group.colSeparationType === "align") {
      var _cols = group.cols || [];
      var spacing2 = "";
      for (var _i22 = 1; _i22 < _cols.length; _i22++) {
        spacing2 += _i22 % 2 ? "0em " : "1em ";
      }
      table.setAttribute("columnspacing", spacing2.trim());
    } else if (group.colSeparationType === "alignat" || group.colSeparationType === "gather") {
      table.setAttribute("columnspacing", "0em");
    } else if (group.colSeparationType === "small") {
      table.setAttribute("columnspacing", "0.2778em");
    } else if (group.colSeparationType === "CD") {
      table.setAttribute("columnspacing", "0.5em");
    } else {
      table.setAttribute("columnspacing", "1em");
    }
    var rowLines = "";
    var hlines = group.hLinesBeforeRow;
    menclose += hlines[0].length > 0 ? "left " : "";
    menclose += hlines[hlines.length - 1].length > 0 ? "right " : "";
    for (var _i32 = 1; _i32 < hlines.length - 1; _i32++) {
      rowLines += hlines[_i32].length === 0 ? "none " : hlines[_i32][0] ? "dashed " : "solid ";
    }
    if (/[sd]/.test(rowLines)) {
      table.setAttribute("rowlines", rowLines.trim());
    }
    if (menclose !== "") {
      table = new mathMLTree.MathNode("menclose", [table]);
      table.setAttribute("notation", menclose.trim());
    }
    if (group.arraystretch && group.arraystretch < 1) {
      table = new mathMLTree.MathNode("mstyle", [table]);
      table.setAttribute("scriptlevel", "1");
    }
    return table;
  };
  var alignedHandler = function alignedHandler2(context, args) {
    if (context.envName.indexOf("ed") === -1) {
      validateAmsEnvironmentContext(context);
    }
    var cols = [];
    var separationType = context.envName.indexOf("at") > -1 ? "alignat" : "align";
    var isSplit = context.envName === "split";
    var res = parseArray(context.parser, {
      cols,
      addJot: true,
      autoTag: isSplit ? void 0 : getAutoTag(context.envName),
      emptySingleRow: true,
      colSeparationType: separationType,
      maxNumCols: isSplit ? 2 : void 0,
      leqno: context.parser.settings.leqno
    }, "display");
    var numMaths;
    var numCols = 0;
    var emptyGroup = {
      type: "ordgroup",
      mode: context.mode,
      body: []
    };
    if (args[0] && args[0].type === "ordgroup") {
      var arg0 = "";
      for (var i2 = 0; i2 < args[0].body.length; i2++) {
        var textord2 = assertNodeType(args[0].body[i2], "textord");
        arg0 += textord2.text;
      }
      numMaths = Number(arg0);
      numCols = numMaths * 2;
    }
    var isAligned = !numCols;
    res.body.forEach(function(row) {
      for (var _i42 = 1; _i42 < row.length; _i42 += 2) {
        var styling = assertNodeType(row[_i42], "styling");
        var ordgroup = assertNodeType(styling.body[0], "ordgroup");
        ordgroup.body.unshift(emptyGroup);
      }
      if (!isAligned) {
        var curMaths = row.length / 2;
        if (numMaths < curMaths) {
          throw new ParseError("Too many math in a row: " + ("expected " + numMaths + ", but got " + curMaths), row[0]);
        }
      } else if (numCols < row.length) {
        numCols = row.length;
      }
    });
    for (var _i52 = 0; _i52 < numCols; ++_i52) {
      var align = "r";
      var pregap = 0;
      if (_i52 % 2 === 1) {
        align = "l";
      } else if (_i52 > 0 && isAligned) {
        pregap = 1;
      }
      cols[_i52] = {
        type: "align",
        align,
        pregap,
        postgap: 0
      };
    }
    res.colSeparationType = isAligned ? "align" : "alignat";
    return res;
  };
  defineEnvironment({
    type: "array",
    names: ["array", "darray"],
    props: {
      numArgs: 1
    },
    handler(context, args) {
      var symNode = checkSymbolNodeType(args[0]);
      var colalign = symNode ? [args[0]] : assertNodeType(args[0], "ordgroup").body;
      var cols = colalign.map(function(nde) {
        var node2 = assertSymbolNodeType(nde);
        var ca = node2.text;
        if ("lcr".indexOf(ca) !== -1) {
          return {
            type: "align",
            align: ca
          };
        } else if (ca === "|") {
          return {
            type: "separator",
            separator: "|"
          };
        } else if (ca === ":") {
          return {
            type: "separator",
            separator: ":"
          };
        }
        throw new ParseError("Unknown column alignment: " + ca, nde);
      });
      var res = {
        cols,
        hskipBeforeAndAfter: true,
        // \@preamble in lttab.dtx
        maxNumCols: cols.length
      };
      return parseArray(context.parser, res, dCellStyle(context.envName));
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["matrix", "pmatrix", "bmatrix", "Bmatrix", "vmatrix", "Vmatrix", "matrix*", "pmatrix*", "bmatrix*", "Bmatrix*", "vmatrix*", "Vmatrix*"],
    props: {
      numArgs: 0
    },
    handler(context) {
      var delimiters2 = {
        "matrix": null,
        "pmatrix": ["(", ")"],
        "bmatrix": ["[", "]"],
        "Bmatrix": ["\\{", "\\}"],
        "vmatrix": ["|", "|"],
        "Vmatrix": ["\\Vert", "\\Vert"]
      }[context.envName.replace("*", "")];
      var colAlign = "c";
      var payload = {
        hskipBeforeAndAfter: false,
        cols: [{
          type: "align",
          align: colAlign
        }]
      };
      if (context.envName.charAt(context.envName.length - 1) === "*") {
        var parser2 = context.parser;
        parser2.consumeSpaces();
        if (parser2.fetch().text === "[") {
          parser2.consume();
          parser2.consumeSpaces();
          colAlign = parser2.fetch().text;
          if ("lcr".indexOf(colAlign) === -1) {
            throw new ParseError("Expected l or c or r", parser2.nextToken);
          }
          parser2.consume();
          parser2.consumeSpaces();
          parser2.expect("]");
          parser2.consume();
          payload.cols = [{
            type: "align",
            align: colAlign
          }];
        }
      }
      var res = parseArray(context.parser, payload, dCellStyle(context.envName));
      var numCols = Math.max(0, ...res.body.map((row) => row.length));
      res.cols = new Array(numCols).fill({
        type: "align",
        align: colAlign
      });
      return delimiters2 ? {
        type: "leftright",
        mode: context.mode,
        body: [res],
        left: delimiters2[0],
        right: delimiters2[1],
        rightColor: void 0
        // \right uninfluenced by \color in array
      } : res;
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["smallmatrix"],
    props: {
      numArgs: 0
    },
    handler(context) {
      var payload = {
        arraystretch: 0.5
      };
      var res = parseArray(context.parser, payload, "script");
      res.colSeparationType = "small";
      return res;
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["subarray"],
    props: {
      numArgs: 1
    },
    handler(context, args) {
      var symNode = checkSymbolNodeType(args[0]);
      var colalign = symNode ? [args[0]] : assertNodeType(args[0], "ordgroup").body;
      var cols = colalign.map(function(nde) {
        var node2 = assertSymbolNodeType(nde);
        var ca = node2.text;
        if ("lc".indexOf(ca) !== -1) {
          return {
            type: "align",
            align: ca
          };
        }
        throw new ParseError("Unknown column alignment: " + ca, nde);
      });
      if (cols.length > 1) {
        throw new ParseError("{subarray} can contain only one column");
      }
      var res = {
        cols,
        hskipBeforeAndAfter: false,
        arraystretch: 0.5
      };
      res = parseArray(context.parser, res, "script");
      if (res.body.length > 0 && res.body[0].length > 1) {
        throw new ParseError("{subarray} can contain only one column");
      }
      return res;
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["cases", "dcases", "rcases", "drcases"],
    props: {
      numArgs: 0
    },
    handler(context) {
      var payload = {
        arraystretch: 1.2,
        cols: [{
          type: "align",
          align: "l",
          pregap: 0,
          // TODO(kevinb) get the current style.
          // For now we use the metrics for TEXT style which is what we were
          // doing before.  Before attempting to get the current style we
          // should look at TeX's behavior especially for \over and matrices.
          postgap: 1
          /* 1em quad */
        }, {
          type: "align",
          align: "l",
          pregap: 0,
          postgap: 0
        }]
      };
      var res = parseArray(context.parser, payload, dCellStyle(context.envName));
      return {
        type: "leftright",
        mode: context.mode,
        body: [res],
        left: context.envName.indexOf("r") > -1 ? "." : "\\{",
        right: context.envName.indexOf("r") > -1 ? "\\}" : ".",
        rightColor: void 0
      };
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["align", "align*", "aligned", "split"],
    props: {
      numArgs: 0
    },
    handler: alignedHandler,
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["gathered", "gather", "gather*"],
    props: {
      numArgs: 0
    },
    handler(context) {
      if (utils.contains(["gather", "gather*"], context.envName)) {
        validateAmsEnvironmentContext(context);
      }
      var res = {
        cols: [{
          type: "align",
          align: "c"
        }],
        addJot: true,
        colSeparationType: "gather",
        autoTag: getAutoTag(context.envName),
        emptySingleRow: true,
        leqno: context.parser.settings.leqno
      };
      return parseArray(context.parser, res, "display");
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["alignat", "alignat*", "alignedat"],
    props: {
      numArgs: 1
    },
    handler: alignedHandler,
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["equation", "equation*"],
    props: {
      numArgs: 0
    },
    handler(context) {
      validateAmsEnvironmentContext(context);
      var res = {
        autoTag: getAutoTag(context.envName),
        emptySingleRow: true,
        singleRow: true,
        maxNumCols: 1,
        leqno: context.parser.settings.leqno
      };
      return parseArray(context.parser, res, "display");
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineEnvironment({
    type: "array",
    names: ["CD"],
    props: {
      numArgs: 0
    },
    handler(context) {
      validateAmsEnvironmentContext(context);
      return parseCD(context.parser);
    },
    htmlBuilder: htmlBuilder$6,
    mathmlBuilder: mathmlBuilder$5
  });
  defineMacro("\\nonumber", "\\gdef\\@eqnsw{0}");
  defineMacro("\\notag", "\\nonumber");
  defineFunction({
    type: "text",
    // Doesn't matter what this is.
    names: ["\\hline", "\\hdashline"],
    props: {
      numArgs: 0,
      allowedInText: true,
      allowedInMath: true
    },
    handler(context, args) {
      throw new ParseError(context.funcName + " valid only within array environment");
    }
  });
  var environments = _environments;
  defineFunction({
    type: "environment",
    names: ["\\begin", "\\end"],
    props: {
      numArgs: 1,
      argTypes: ["text"]
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var nameGroup = args[0];
      if (nameGroup.type !== "ordgroup") {
        throw new ParseError("Invalid environment name", nameGroup);
      }
      var envName = "";
      for (var i2 = 0; i2 < nameGroup.body.length; ++i2) {
        envName += assertNodeType(nameGroup.body[i2], "textord").text;
      }
      if (funcName === "\\begin") {
        if (!environments.hasOwnProperty(envName)) {
          throw new ParseError("No such environment: " + envName, nameGroup);
        }
        var env = environments[envName];
        var {
          args: _args,
          optArgs
        } = parser2.parseArguments("\\begin{" + envName + "}", env);
        var context = {
          mode: parser2.mode,
          envName,
          parser: parser2
        };
        var result = env.handler(context, _args, optArgs);
        parser2.expect("\\end", false);
        var endNameToken = parser2.nextToken;
        var end2 = assertNodeType(parser2.parseFunction(), "environment");
        if (end2.name !== envName) {
          throw new ParseError("Mismatch: \\begin{" + envName + "} matched by \\end{" + end2.name + "}", endNameToken);
        }
        return result;
      }
      return {
        type: "environment",
        mode: parser2.mode,
        name: envName,
        nameGroup
      };
    }
  });
  var htmlBuilder$5 = (group, options2) => {
    var font = group.font;
    var newOptions = options2.withFont(font);
    return buildGroup$1(group.body, newOptions);
  };
  var mathmlBuilder$4 = (group, options2) => {
    var font = group.font;
    var newOptions = options2.withFont(font);
    return buildGroup(group.body, newOptions);
  };
  var fontAliases = {
    "\\Bbb": "\\mathbb",
    "\\bold": "\\mathbf",
    "\\frak": "\\mathfrak",
    "\\bm": "\\boldsymbol"
  };
  defineFunction({
    type: "font",
    names: [
      // styles, except \boldsymbol defined below
      "\\mathrm",
      "\\mathit",
      "\\mathbf",
      "\\mathnormal",
      // families
      "\\mathbb",
      "\\mathcal",
      "\\mathfrak",
      "\\mathscr",
      "\\mathsf",
      "\\mathtt",
      // aliases, except \bm defined below
      "\\Bbb",
      "\\bold",
      "\\frak"
    ],
    props: {
      numArgs: 1,
      allowedInArgument: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var body = normalizeArgument(args[0]);
      var func = funcName;
      if (func in fontAliases) {
        func = fontAliases[func];
      }
      return {
        type: "font",
        mode: parser2.mode,
        font: func.slice(1),
        body
      };
    },
    htmlBuilder: htmlBuilder$5,
    mathmlBuilder: mathmlBuilder$4
  });
  defineFunction({
    type: "mclass",
    names: ["\\boldsymbol", "\\bm"],
    props: {
      numArgs: 1
    },
    handler: (_ref2, args) => {
      var {
        parser: parser2
      } = _ref2;
      var body = args[0];
      var isCharacterBox2 = utils.isCharacterBox(body);
      return {
        type: "mclass",
        mode: parser2.mode,
        mclass: binrelClass(body),
        body: [{
          type: "font",
          mode: parser2.mode,
          font: "boldsymbol",
          body
        }],
        isCharacterBox: isCharacterBox2
      };
    }
  });
  defineFunction({
    type: "font",
    names: ["\\rm", "\\sf", "\\tt", "\\bf", "\\it", "\\cal"],
    props: {
      numArgs: 0,
      allowedInText: true
    },
    handler: (_ref3, args) => {
      var {
        parser: parser2,
        funcName,
        breakOnTokenText
      } = _ref3;
      var {
        mode
      } = parser2;
      var body = parser2.parseExpression(true, breakOnTokenText);
      var style = "math" + funcName.slice(1);
      return {
        type: "font",
        mode,
        font: style,
        body: {
          type: "ordgroup",
          mode: parser2.mode,
          body
        }
      };
    },
    htmlBuilder: htmlBuilder$5,
    mathmlBuilder: mathmlBuilder$4
  });
  var adjustStyle = (size2, originalStyle) => {
    var style = originalStyle;
    if (size2 === "display") {
      style = style.id >= Style$1.SCRIPT.id ? style.text() : Style$1.DISPLAY;
    } else if (size2 === "text" && style.size === Style$1.DISPLAY.size) {
      style = Style$1.TEXT;
    } else if (size2 === "script") {
      style = Style$1.SCRIPT;
    } else if (size2 === "scriptscript") {
      style = Style$1.SCRIPTSCRIPT;
    }
    return style;
  };
  var htmlBuilder$4 = (group, options2) => {
    var style = adjustStyle(group.size, options2.style);
    var nstyle = style.fracNum();
    var dstyle = style.fracDen();
    var newOptions;
    newOptions = options2.havingStyle(nstyle);
    var numerm = buildGroup$1(group.numer, newOptions, options2);
    if (group.continued) {
      var hStrut = 8.5 / options2.fontMetrics().ptPerEm;
      var dStrut = 3.5 / options2.fontMetrics().ptPerEm;
      numerm.height = numerm.height < hStrut ? hStrut : numerm.height;
      numerm.depth = numerm.depth < dStrut ? dStrut : numerm.depth;
    }
    newOptions = options2.havingStyle(dstyle);
    var denomm = buildGroup$1(group.denom, newOptions, options2);
    var rule;
    var ruleWidth;
    var ruleSpacing;
    if (group.hasBarLine) {
      if (group.barSize) {
        ruleWidth = calculateSize(group.barSize, options2);
        rule = buildCommon.makeLineSpan("frac-line", options2, ruleWidth);
      } else {
        rule = buildCommon.makeLineSpan("frac-line", options2);
      }
      ruleWidth = rule.height;
      ruleSpacing = rule.height;
    } else {
      rule = null;
      ruleWidth = 0;
      ruleSpacing = options2.fontMetrics().defaultRuleThickness;
    }
    var numShift;
    var clearance;
    var denomShift;
    if (style.size === Style$1.DISPLAY.size || group.size === "display") {
      numShift = options2.fontMetrics().num1;
      if (ruleWidth > 0) {
        clearance = 3 * ruleSpacing;
      } else {
        clearance = 7 * ruleSpacing;
      }
      denomShift = options2.fontMetrics().denom1;
    } else {
      if (ruleWidth > 0) {
        numShift = options2.fontMetrics().num2;
        clearance = ruleSpacing;
      } else {
        numShift = options2.fontMetrics().num3;
        clearance = 3 * ruleSpacing;
      }
      denomShift = options2.fontMetrics().denom2;
    }
    var frac;
    if (!rule) {
      var candidateClearance = numShift - numerm.depth - (denomm.height - denomShift);
      if (candidateClearance < clearance) {
        numShift += 0.5 * (clearance - candidateClearance);
        denomShift += 0.5 * (clearance - candidateClearance);
      }
      frac = buildCommon.makeVList({
        positionType: "individualShift",
        children: [{
          type: "elem",
          elem: denomm,
          shift: denomShift
        }, {
          type: "elem",
          elem: numerm,
          shift: -numShift
        }]
      }, options2);
    } else {
      var axisHeight = options2.fontMetrics().axisHeight;
      if (numShift - numerm.depth - (axisHeight + 0.5 * ruleWidth) < clearance) {
        numShift += clearance - (numShift - numerm.depth - (axisHeight + 0.5 * ruleWidth));
      }
      if (axisHeight - 0.5 * ruleWidth - (denomm.height - denomShift) < clearance) {
        denomShift += clearance - (axisHeight - 0.5 * ruleWidth - (denomm.height - denomShift));
      }
      var midShift = -(axisHeight - 0.5 * ruleWidth);
      frac = buildCommon.makeVList({
        positionType: "individualShift",
        children: [{
          type: "elem",
          elem: denomm,
          shift: denomShift
        }, {
          type: "elem",
          elem: rule,
          shift: midShift
        }, {
          type: "elem",
          elem: numerm,
          shift: -numShift
        }]
      }, options2);
    }
    newOptions = options2.havingStyle(style);
    frac.height *= newOptions.sizeMultiplier / options2.sizeMultiplier;
    frac.depth *= newOptions.sizeMultiplier / options2.sizeMultiplier;
    var delimSize;
    if (style.size === Style$1.DISPLAY.size) {
      delimSize = options2.fontMetrics().delim1;
    } else if (style.size === Style$1.SCRIPTSCRIPT.size) {
      delimSize = options2.havingStyle(Style$1.SCRIPT).fontMetrics().delim2;
    } else {
      delimSize = options2.fontMetrics().delim2;
    }
    var leftDelim;
    var rightDelim;
    if (group.leftDelim == null) {
      leftDelim = makeNullDelimiter(options2, ["mopen"]);
    } else {
      leftDelim = delimiter.customSizedDelim(group.leftDelim, delimSize, true, options2.havingStyle(style), group.mode, ["mopen"]);
    }
    if (group.continued) {
      rightDelim = buildCommon.makeSpan([]);
    } else if (group.rightDelim == null) {
      rightDelim = makeNullDelimiter(options2, ["mclose"]);
    } else {
      rightDelim = delimiter.customSizedDelim(group.rightDelim, delimSize, true, options2.havingStyle(style), group.mode, ["mclose"]);
    }
    return buildCommon.makeSpan(["mord"].concat(newOptions.sizingClasses(options2)), [leftDelim, buildCommon.makeSpan(["mfrac"], [frac]), rightDelim], options2);
  };
  var mathmlBuilder$3 = (group, options2) => {
    var node2 = new mathMLTree.MathNode("mfrac", [buildGroup(group.numer, options2), buildGroup(group.denom, options2)]);
    if (!group.hasBarLine) {
      node2.setAttribute("linethickness", "0px");
    } else if (group.barSize) {
      var ruleWidth = calculateSize(group.barSize, options2);
      node2.setAttribute("linethickness", makeEm(ruleWidth));
    }
    var style = adjustStyle(group.size, options2.style);
    if (style.size !== options2.style.size) {
      node2 = new mathMLTree.MathNode("mstyle", [node2]);
      var isDisplay = style.size === Style$1.DISPLAY.size ? "true" : "false";
      node2.setAttribute("displaystyle", isDisplay);
      node2.setAttribute("scriptlevel", "0");
    }
    if (group.leftDelim != null || group.rightDelim != null) {
      var withDelims = [];
      if (group.leftDelim != null) {
        var leftOp = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(group.leftDelim.replace("\\", ""))]);
        leftOp.setAttribute("fence", "true");
        withDelims.push(leftOp);
      }
      withDelims.push(node2);
      if (group.rightDelim != null) {
        var rightOp = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode(group.rightDelim.replace("\\", ""))]);
        rightOp.setAttribute("fence", "true");
        withDelims.push(rightOp);
      }
      return makeRow(withDelims);
    }
    return node2;
  };
  defineFunction({
    type: "genfrac",
    names: [
      "\\dfrac",
      "\\frac",
      "\\tfrac",
      "\\dbinom",
      "\\binom",
      "\\tbinom",
      "\\\\atopfrac",
      // can’t be entered directly
      "\\\\bracefrac",
      "\\\\brackfrac"
      // ditto
    ],
    props: {
      numArgs: 2,
      allowedInArgument: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var numer = args[0];
      var denom = args[1];
      var hasBarLine;
      var leftDelim = null;
      var rightDelim = null;
      var size2 = "auto";
      switch (funcName) {
        case "\\dfrac":
        case "\\frac":
        case "\\tfrac":
          hasBarLine = true;
          break;
        case "\\\\atopfrac":
          hasBarLine = false;
          break;
        case "\\dbinom":
        case "\\binom":
        case "\\tbinom":
          hasBarLine = false;
          leftDelim = "(";
          rightDelim = ")";
          break;
        case "\\\\bracefrac":
          hasBarLine = false;
          leftDelim = "\\{";
          rightDelim = "\\}";
          break;
        case "\\\\brackfrac":
          hasBarLine = false;
          leftDelim = "[";
          rightDelim = "]";
          break;
        default:
          throw new Error("Unrecognized genfrac command");
      }
      switch (funcName) {
        case "\\dfrac":
        case "\\dbinom":
          size2 = "display";
          break;
        case "\\tfrac":
        case "\\tbinom":
          size2 = "text";
          break;
      }
      return {
        type: "genfrac",
        mode: parser2.mode,
        continued: false,
        numer,
        denom,
        hasBarLine,
        leftDelim,
        rightDelim,
        size: size2,
        barSize: null
      };
    },
    htmlBuilder: htmlBuilder$4,
    mathmlBuilder: mathmlBuilder$3
  });
  defineFunction({
    type: "genfrac",
    names: ["\\cfrac"],
    props: {
      numArgs: 2
    },
    handler: (_ref2, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref2;
      var numer = args[0];
      var denom = args[1];
      return {
        type: "genfrac",
        mode: parser2.mode,
        continued: true,
        numer,
        denom,
        hasBarLine: true,
        leftDelim: null,
        rightDelim: null,
        size: "display",
        barSize: null
      };
    }
  });
  defineFunction({
    type: "infix",
    names: ["\\over", "\\choose", "\\atop", "\\brace", "\\brack"],
    props: {
      numArgs: 0,
      infix: true
    },
    handler(_ref3) {
      var {
        parser: parser2,
        funcName,
        token: token2
      } = _ref3;
      var replaceWith;
      switch (funcName) {
        case "\\over":
          replaceWith = "\\frac";
          break;
        case "\\choose":
          replaceWith = "\\binom";
          break;
        case "\\atop":
          replaceWith = "\\\\atopfrac";
          break;
        case "\\brace":
          replaceWith = "\\\\bracefrac";
          break;
        case "\\brack":
          replaceWith = "\\\\brackfrac";
          break;
        default:
          throw new Error("Unrecognized infix genfrac command");
      }
      return {
        type: "infix",
        mode: parser2.mode,
        replaceWith,
        token: token2
      };
    }
  });
  var stylArray = ["display", "text", "script", "scriptscript"];
  var delimFromValue = function delimFromValue2(delimString) {
    var delim = null;
    if (delimString.length > 0) {
      delim = delimString;
      delim = delim === "." ? null : delim;
    }
    return delim;
  };
  defineFunction({
    type: "genfrac",
    names: ["\\genfrac"],
    props: {
      numArgs: 6,
      allowedInArgument: true,
      argTypes: ["math", "math", "size", "text", "math", "math"]
    },
    handler(_ref4, args) {
      var {
        parser: parser2
      } = _ref4;
      var numer = args[4];
      var denom = args[5];
      var leftNode = normalizeArgument(args[0]);
      var leftDelim = leftNode.type === "atom" && leftNode.family === "open" ? delimFromValue(leftNode.text) : null;
      var rightNode = normalizeArgument(args[1]);
      var rightDelim = rightNode.type === "atom" && rightNode.family === "close" ? delimFromValue(rightNode.text) : null;
      var barNode = assertNodeType(args[2], "size");
      var hasBarLine;
      var barSize = null;
      if (barNode.isBlank) {
        hasBarLine = true;
      } else {
        barSize = barNode.value;
        hasBarLine = barSize.number > 0;
      }
      var size2 = "auto";
      var styl = args[3];
      if (styl.type === "ordgroup") {
        if (styl.body.length > 0) {
          var textOrd = assertNodeType(styl.body[0], "textord");
          size2 = stylArray[Number(textOrd.text)];
        }
      } else {
        styl = assertNodeType(styl, "textord");
        size2 = stylArray[Number(styl.text)];
      }
      return {
        type: "genfrac",
        mode: parser2.mode,
        numer,
        denom,
        continued: false,
        hasBarLine,
        barSize,
        leftDelim,
        rightDelim,
        size: size2
      };
    },
    htmlBuilder: htmlBuilder$4,
    mathmlBuilder: mathmlBuilder$3
  });
  defineFunction({
    type: "infix",
    names: ["\\above"],
    props: {
      numArgs: 1,
      argTypes: ["size"],
      infix: true
    },
    handler(_ref5, args) {
      var {
        parser: parser2,
        funcName,
        token: token2
      } = _ref5;
      return {
        type: "infix",
        mode: parser2.mode,
        replaceWith: "\\\\abovefrac",
        size: assertNodeType(args[0], "size").value,
        token: token2
      };
    }
  });
  defineFunction({
    type: "genfrac",
    names: ["\\\\abovefrac"],
    props: {
      numArgs: 3,
      argTypes: ["math", "size", "math"]
    },
    handler: (_ref6, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref6;
      var numer = args[0];
      var barSize = assert(assertNodeType(args[1], "infix").size);
      var denom = args[2];
      var hasBarLine = barSize.number > 0;
      return {
        type: "genfrac",
        mode: parser2.mode,
        numer,
        denom,
        continued: false,
        hasBarLine,
        barSize,
        leftDelim: null,
        rightDelim: null,
        size: "auto"
      };
    },
    htmlBuilder: htmlBuilder$4,
    mathmlBuilder: mathmlBuilder$3
  });
  var htmlBuilder$3 = (grp, options2) => {
    var style = options2.style;
    var supSubGroup;
    var group;
    if (grp.type === "supsub") {
      supSubGroup = grp.sup ? buildGroup$1(grp.sup, options2.havingStyle(style.sup()), options2) : buildGroup$1(grp.sub, options2.havingStyle(style.sub()), options2);
      group = assertNodeType(grp.base, "horizBrace");
    } else {
      group = assertNodeType(grp, "horizBrace");
    }
    var body = buildGroup$1(group.base, options2.havingBaseStyle(Style$1.DISPLAY));
    var braceBody = stretchy.svgSpan(group, options2);
    var vlist;
    if (group.isOver) {
      vlist = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: body
        }, {
          type: "kern",
          size: 0.1
        }, {
          type: "elem",
          elem: braceBody
        }]
      }, options2);
      vlist.children[0].children[0].children[1].classes.push("svg-align");
    } else {
      vlist = buildCommon.makeVList({
        positionType: "bottom",
        positionData: body.depth + 0.1 + braceBody.height,
        children: [{
          type: "elem",
          elem: braceBody
        }, {
          type: "kern",
          size: 0.1
        }, {
          type: "elem",
          elem: body
        }]
      }, options2);
      vlist.children[0].children[0].children[0].classes.push("svg-align");
    }
    if (supSubGroup) {
      var vSpan = buildCommon.makeSpan(["mord", group.isOver ? "mover" : "munder"], [vlist], options2);
      if (group.isOver) {
        vlist = buildCommon.makeVList({
          positionType: "firstBaseline",
          children: [{
            type: "elem",
            elem: vSpan
          }, {
            type: "kern",
            size: 0.2
          }, {
            type: "elem",
            elem: supSubGroup
          }]
        }, options2);
      } else {
        vlist = buildCommon.makeVList({
          positionType: "bottom",
          positionData: vSpan.depth + 0.2 + supSubGroup.height + supSubGroup.depth,
          children: [{
            type: "elem",
            elem: supSubGroup
          }, {
            type: "kern",
            size: 0.2
          }, {
            type: "elem",
            elem: vSpan
          }]
        }, options2);
      }
    }
    return buildCommon.makeSpan(["mord", group.isOver ? "mover" : "munder"], [vlist], options2);
  };
  var mathmlBuilder$2 = (group, options2) => {
    var accentNode = stretchy.mathMLnode(group.label);
    return new mathMLTree.MathNode(group.isOver ? "mover" : "munder", [buildGroup(group.base, options2), accentNode]);
  };
  defineFunction({
    type: "horizBrace",
    names: ["\\overbrace", "\\underbrace"],
    props: {
      numArgs: 1
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      return {
        type: "horizBrace",
        mode: parser2.mode,
        label: funcName,
        isOver: /^\\over/.test(funcName),
        base: args[0]
      };
    },
    htmlBuilder: htmlBuilder$3,
    mathmlBuilder: mathmlBuilder$2
  });
  defineFunction({
    type: "href",
    names: ["\\href"],
    props: {
      numArgs: 2,
      argTypes: ["url", "original"],
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2
      } = _ref;
      var body = args[1];
      var href = assertNodeType(args[0], "url").url;
      if (!parser2.settings.isTrusted({
        command: "\\href",
        url: href
      })) {
        return parser2.formatUnsupportedCmd("\\href");
      }
      return {
        type: "href",
        mode: parser2.mode,
        href,
        body: ordargument(body)
      };
    },
    htmlBuilder: (group, options2) => {
      var elements2 = buildExpression$1(group.body, options2, false);
      return buildCommon.makeAnchor(group.href, [], elements2, options2);
    },
    mathmlBuilder: (group, options2) => {
      var math2 = buildExpressionRow(group.body, options2);
      if (!(math2 instanceof MathNode)) {
        math2 = new MathNode("mrow", [math2]);
      }
      math2.setAttribute("href", group.href);
      return math2;
    }
  });
  defineFunction({
    type: "href",
    names: ["\\url"],
    props: {
      numArgs: 1,
      argTypes: ["url"],
      allowedInText: true
    },
    handler: (_ref2, args) => {
      var {
        parser: parser2
      } = _ref2;
      var href = assertNodeType(args[0], "url").url;
      if (!parser2.settings.isTrusted({
        command: "\\url",
        url: href
      })) {
        return parser2.formatUnsupportedCmd("\\url");
      }
      var chars = [];
      for (var i2 = 0; i2 < href.length; i2++) {
        var c2 = href[i2];
        if (c2 === "~") {
          c2 = "\\textasciitilde";
        }
        chars.push({
          type: "textord",
          mode: "text",
          text: c2
        });
      }
      var body = {
        type: "text",
        mode: parser2.mode,
        font: "\\texttt",
        body: chars
      };
      return {
        type: "href",
        mode: parser2.mode,
        href,
        body: ordargument(body)
      };
    }
  });
  defineFunction({
    type: "hbox",
    names: ["\\hbox"],
    props: {
      numArgs: 1,
      argTypes: ["text"],
      allowedInText: true,
      primitive: true
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "hbox",
        mode: parser2.mode,
        body: ordargument(args[0])
      };
    },
    htmlBuilder(group, options2) {
      var elements2 = buildExpression$1(group.body, options2, false);
      return buildCommon.makeFragment(elements2);
    },
    mathmlBuilder(group, options2) {
      return new mathMLTree.MathNode("mrow", buildExpression(group.body, options2));
    }
  });
  defineFunction({
    type: "html",
    names: ["\\htmlClass", "\\htmlId", "\\htmlStyle", "\\htmlData"],
    props: {
      numArgs: 2,
      argTypes: ["raw", "original"],
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName,
        token: token2
      } = _ref;
      var value2 = assertNodeType(args[0], "raw").string;
      var body = args[1];
      if (parser2.settings.strict) {
        parser2.settings.reportNonstrict("htmlExtension", "HTML extension is disabled on strict mode");
      }
      var trustContext;
      var attributes = {};
      switch (funcName) {
        case "\\htmlClass":
          attributes.class = value2;
          trustContext = {
            command: "\\htmlClass",
            class: value2
          };
          break;
        case "\\htmlId":
          attributes.id = value2;
          trustContext = {
            command: "\\htmlId",
            id: value2
          };
          break;
        case "\\htmlStyle":
          attributes.style = value2;
          trustContext = {
            command: "\\htmlStyle",
            style: value2
          };
          break;
        case "\\htmlData": {
          var data = value2.split(",");
          for (var i2 = 0; i2 < data.length; i2++) {
            var keyVal = data[i2].split("=");
            if (keyVal.length !== 2) {
              throw new ParseError("Error parsing key-value for \\htmlData");
            }
            attributes["data-" + keyVal[0].trim()] = keyVal[1].trim();
          }
          trustContext = {
            command: "\\htmlData",
            attributes
          };
          break;
        }
        default:
          throw new Error("Unrecognized html command");
      }
      if (!parser2.settings.isTrusted(trustContext)) {
        return parser2.formatUnsupportedCmd(funcName);
      }
      return {
        type: "html",
        mode: parser2.mode,
        attributes,
        body: ordargument(body)
      };
    },
    htmlBuilder: (group, options2) => {
      var elements2 = buildExpression$1(group.body, options2, false);
      var classes2 = ["enclosing"];
      if (group.attributes.class) {
        classes2.push(...group.attributes.class.trim().split(/\s+/));
      }
      var span = buildCommon.makeSpan(classes2, elements2, options2);
      for (var attr in group.attributes) {
        if (attr !== "class" && group.attributes.hasOwnProperty(attr)) {
          span.setAttribute(attr, group.attributes[attr]);
        }
      }
      return span;
    },
    mathmlBuilder: (group, options2) => {
      return buildExpressionRow(group.body, options2);
    }
  });
  defineFunction({
    type: "htmlmathml",
    names: ["\\html@mathml"],
    props: {
      numArgs: 2,
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "htmlmathml",
        mode: parser2.mode,
        html: ordargument(args[0]),
        mathml: ordargument(args[1])
      };
    },
    htmlBuilder: (group, options2) => {
      var elements2 = buildExpression$1(group.html, options2, false);
      return buildCommon.makeFragment(elements2);
    },
    mathmlBuilder: (group, options2) => {
      return buildExpressionRow(group.mathml, options2);
    }
  });
  var sizeData = function sizeData2(str2) {
    if (/^[-+]? *(\d+(\.\d*)?|\.\d+)$/.test(str2)) {
      return {
        number: +str2,
        unit: "bp"
      };
    } else {
      var match = /([-+]?) *(\d+(?:\.\d*)?|\.\d+) *([a-z]{2})/.exec(str2);
      if (!match) {
        throw new ParseError("Invalid size: '" + str2 + "' in \\includegraphics");
      }
      var data = {
        number: +(match[1] + match[2]),
        // sign + magnitude, cast to number
        unit: match[3]
      };
      if (!validUnit(data)) {
        throw new ParseError("Invalid unit: '" + data.unit + "' in \\includegraphics.");
      }
      return data;
    }
  };
  defineFunction({
    type: "includegraphics",
    names: ["\\includegraphics"],
    props: {
      numArgs: 1,
      numOptionalArgs: 1,
      argTypes: ["raw", "url"],
      allowedInText: false
    },
    handler: (_ref, args, optArgs) => {
      var {
        parser: parser2
      } = _ref;
      var width2 = {
        number: 0,
        unit: "em"
      };
      var height = {
        number: 0.9,
        unit: "em"
      };
      var totalheight = {
        number: 0,
        unit: "em"
      };
      var alt = "";
      if (optArgs[0]) {
        var attributeStr = assertNodeType(optArgs[0], "raw").string;
        var attributes = attributeStr.split(",");
        for (var i2 = 0; i2 < attributes.length; i2++) {
          var keyVal = attributes[i2].split("=");
          if (keyVal.length === 2) {
            var str2 = keyVal[1].trim();
            switch (keyVal[0].trim()) {
              case "alt":
                alt = str2;
                break;
              case "width":
                width2 = sizeData(str2);
                break;
              case "height":
                height = sizeData(str2);
                break;
              case "totalheight":
                totalheight = sizeData(str2);
                break;
              default:
                throw new ParseError("Invalid key: '" + keyVal[0] + "' in \\includegraphics.");
            }
          }
        }
      }
      var src = assertNodeType(args[0], "url").url;
      if (alt === "") {
        alt = src;
        alt = alt.replace(/^.*[\\/]/, "");
        alt = alt.substring(0, alt.lastIndexOf("."));
      }
      if (!parser2.settings.isTrusted({
        command: "\\includegraphics",
        url: src
      })) {
        return parser2.formatUnsupportedCmd("\\includegraphics");
      }
      return {
        type: "includegraphics",
        mode: parser2.mode,
        alt,
        width: width2,
        height,
        totalheight,
        src
      };
    },
    htmlBuilder: (group, options2) => {
      var height = calculateSize(group.height, options2);
      var depth = 0;
      if (group.totalheight.number > 0) {
        depth = calculateSize(group.totalheight, options2) - height;
      }
      var width2 = 0;
      if (group.width.number > 0) {
        width2 = calculateSize(group.width, options2);
      }
      var style = {
        height: makeEm(height + depth)
      };
      if (width2 > 0) {
        style.width = makeEm(width2);
      }
      if (depth > 0) {
        style.verticalAlign = makeEm(-depth);
      }
      var node2 = new Img(group.src, group.alt, style);
      node2.height = height;
      node2.depth = depth;
      return node2;
    },
    mathmlBuilder: (group, options2) => {
      var node2 = new mathMLTree.MathNode("mglyph", []);
      node2.setAttribute("alt", group.alt);
      var height = calculateSize(group.height, options2);
      var depth = 0;
      if (group.totalheight.number > 0) {
        depth = calculateSize(group.totalheight, options2) - height;
        node2.setAttribute("valign", makeEm(-depth));
      }
      node2.setAttribute("height", makeEm(height + depth));
      if (group.width.number > 0) {
        var width2 = calculateSize(group.width, options2);
        node2.setAttribute("width", makeEm(width2));
      }
      node2.setAttribute("src", group.src);
      return node2;
    }
  });
  defineFunction({
    type: "kern",
    names: ["\\kern", "\\mkern", "\\hskip", "\\mskip"],
    props: {
      numArgs: 1,
      argTypes: ["size"],
      primitive: true,
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var size2 = assertNodeType(args[0], "size");
      if (parser2.settings.strict) {
        var mathFunction = funcName[1] === "m";
        var muUnit = size2.value.unit === "mu";
        if (mathFunction) {
          if (!muUnit) {
            parser2.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " supports only mu units, " + ("not " + size2.value.unit + " units"));
          }
          if (parser2.mode !== "math") {
            parser2.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " works only in math mode");
          }
        } else {
          if (muUnit) {
            parser2.settings.reportNonstrict("mathVsTextUnits", "LaTeX's " + funcName + " doesn't support mu units");
          }
        }
      }
      return {
        type: "kern",
        mode: parser2.mode,
        dimension: size2.value
      };
    },
    htmlBuilder(group, options2) {
      return buildCommon.makeGlue(group.dimension, options2);
    },
    mathmlBuilder(group, options2) {
      var dimension = calculateSize(group.dimension, options2);
      return new mathMLTree.SpaceNode(dimension);
    }
  });
  defineFunction({
    type: "lap",
    names: ["\\mathllap", "\\mathrlap", "\\mathclap"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var body = args[0];
      return {
        type: "lap",
        mode: parser2.mode,
        alignment: funcName.slice(5),
        body
      };
    },
    htmlBuilder: (group, options2) => {
      var inner2;
      if (group.alignment === "clap") {
        inner2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2)]);
        inner2 = buildCommon.makeSpan(["inner"], [inner2], options2);
      } else {
        inner2 = buildCommon.makeSpan(["inner"], [buildGroup$1(group.body, options2)]);
      }
      var fix = buildCommon.makeSpan(["fix"], []);
      var node2 = buildCommon.makeSpan([group.alignment], [inner2, fix], options2);
      var strut = buildCommon.makeSpan(["strut"]);
      strut.style.height = makeEm(node2.height + node2.depth);
      if (node2.depth) {
        strut.style.verticalAlign = makeEm(-node2.depth);
      }
      node2.children.unshift(strut);
      node2 = buildCommon.makeSpan(["thinbox"], [node2], options2);
      return buildCommon.makeSpan(["mord", "vbox"], [node2], options2);
    },
    mathmlBuilder: (group, options2) => {
      var node2 = new mathMLTree.MathNode("mpadded", [buildGroup(group.body, options2)]);
      if (group.alignment !== "rlap") {
        var offset = group.alignment === "llap" ? "-1" : "-0.5";
        node2.setAttribute("lspace", offset + "width");
      }
      node2.setAttribute("width", "0px");
      return node2;
    }
  });
  defineFunction({
    type: "styling",
    names: ["\\(", "$"],
    props: {
      numArgs: 0,
      allowedInText: true,
      allowedInMath: false
    },
    handler(_ref, args) {
      var {
        funcName,
        parser: parser2
      } = _ref;
      var outerMode = parser2.mode;
      parser2.switchMode("math");
      var close2 = funcName === "\\(" ? "\\)" : "$";
      var body = parser2.parseExpression(false, close2);
      parser2.expect(close2);
      parser2.switchMode(outerMode);
      return {
        type: "styling",
        mode: parser2.mode,
        style: "text",
        body
      };
    }
  });
  defineFunction({
    type: "text",
    // Doesn't matter what this is.
    names: ["\\)", "\\]"],
    props: {
      numArgs: 0,
      allowedInText: true,
      allowedInMath: false
    },
    handler(context, args) {
      throw new ParseError("Mismatched " + context.funcName);
    }
  });
  var chooseMathStyle = (group, options2) => {
    switch (options2.style.size) {
      case Style$1.DISPLAY.size:
        return group.display;
      case Style$1.TEXT.size:
        return group.text;
      case Style$1.SCRIPT.size:
        return group.script;
      case Style$1.SCRIPTSCRIPT.size:
        return group.scriptscript;
      default:
        return group.text;
    }
  };
  defineFunction({
    type: "mathchoice",
    names: ["\\mathchoice"],
    props: {
      numArgs: 4,
      primitive: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "mathchoice",
        mode: parser2.mode,
        display: ordargument(args[0]),
        text: ordargument(args[1]),
        script: ordargument(args[2]),
        scriptscript: ordargument(args[3])
      };
    },
    htmlBuilder: (group, options2) => {
      var body = chooseMathStyle(group, options2);
      var elements2 = buildExpression$1(body, options2, false);
      return buildCommon.makeFragment(elements2);
    },
    mathmlBuilder: (group, options2) => {
      var body = chooseMathStyle(group, options2);
      return buildExpressionRow(body, options2);
    }
  });
  var assembleSupSub = (base, supGroup, subGroup, options2, style, slant, baseShift) => {
    base = buildCommon.makeSpan([], [base]);
    var subIsSingleCharacter = subGroup && utils.isCharacterBox(subGroup);
    var sub2;
    var sup2;
    if (supGroup) {
      var elem = buildGroup$1(supGroup, options2.havingStyle(style.sup()), options2);
      sup2 = {
        elem,
        kern: Math.max(options2.fontMetrics().bigOpSpacing1, options2.fontMetrics().bigOpSpacing3 - elem.depth)
      };
    }
    if (subGroup) {
      var _elem = buildGroup$1(subGroup, options2.havingStyle(style.sub()), options2);
      sub2 = {
        elem: _elem,
        kern: Math.max(options2.fontMetrics().bigOpSpacing2, options2.fontMetrics().bigOpSpacing4 - _elem.height)
      };
    }
    var finalGroup;
    if (sup2 && sub2) {
      var bottom2 = options2.fontMetrics().bigOpSpacing5 + sub2.elem.height + sub2.elem.depth + sub2.kern + base.depth + baseShift;
      finalGroup = buildCommon.makeVList({
        positionType: "bottom",
        positionData: bottom2,
        children: [{
          type: "kern",
          size: options2.fontMetrics().bigOpSpacing5
        }, {
          type: "elem",
          elem: sub2.elem,
          marginLeft: makeEm(-slant)
        }, {
          type: "kern",
          size: sub2.kern
        }, {
          type: "elem",
          elem: base
        }, {
          type: "kern",
          size: sup2.kern
        }, {
          type: "elem",
          elem: sup2.elem,
          marginLeft: makeEm(slant)
        }, {
          type: "kern",
          size: options2.fontMetrics().bigOpSpacing5
        }]
      }, options2);
    } else if (sub2) {
      var top2 = base.height - baseShift;
      finalGroup = buildCommon.makeVList({
        positionType: "top",
        positionData: top2,
        children: [{
          type: "kern",
          size: options2.fontMetrics().bigOpSpacing5
        }, {
          type: "elem",
          elem: sub2.elem,
          marginLeft: makeEm(-slant)
        }, {
          type: "kern",
          size: sub2.kern
        }, {
          type: "elem",
          elem: base
        }]
      }, options2);
    } else if (sup2) {
      var _bottom = base.depth + baseShift;
      finalGroup = buildCommon.makeVList({
        positionType: "bottom",
        positionData: _bottom,
        children: [{
          type: "elem",
          elem: base
        }, {
          type: "kern",
          size: sup2.kern
        }, {
          type: "elem",
          elem: sup2.elem,
          marginLeft: makeEm(slant)
        }, {
          type: "kern",
          size: options2.fontMetrics().bigOpSpacing5
        }]
      }, options2);
    } else {
      return base;
    }
    var parts = [finalGroup];
    if (sub2 && slant !== 0 && !subIsSingleCharacter) {
      var spacer = buildCommon.makeSpan(["mspace"], [], options2);
      spacer.style.marginRight = makeEm(slant);
      parts.unshift(spacer);
    }
    return buildCommon.makeSpan(["mop", "op-limits"], parts, options2);
  };
  var noSuccessor = ["\\smallint"];
  var htmlBuilder$2 = (grp, options2) => {
    var supGroup;
    var subGroup;
    var hasLimits = false;
    var group;
    if (grp.type === "supsub") {
      supGroup = grp.sup;
      subGroup = grp.sub;
      group = assertNodeType(grp.base, "op");
      hasLimits = true;
    } else {
      group = assertNodeType(grp, "op");
    }
    var style = options2.style;
    var large = false;
    if (style.size === Style$1.DISPLAY.size && group.symbol && !utils.contains(noSuccessor, group.name)) {
      large = true;
    }
    var base;
    if (group.symbol) {
      var fontName = large ? "Size2-Regular" : "Size1-Regular";
      var stash = "";
      if (group.name === "\\oiint" || group.name === "\\oiiint") {
        stash = group.name.slice(1);
        group.name = stash === "oiint" ? "\\iint" : "\\iiint";
      }
      base = buildCommon.makeSymbol(group.name, fontName, "math", options2, ["mop", "op-symbol", large ? "large-op" : "small-op"]);
      if (stash.length > 0) {
        var italic = base.italic;
        var oval = buildCommon.staticSvg(stash + "Size" + (large ? "2" : "1"), options2);
        base = buildCommon.makeVList({
          positionType: "individualShift",
          children: [{
            type: "elem",
            elem: base,
            shift: 0
          }, {
            type: "elem",
            elem: oval,
            shift: large ? 0.08 : 0
          }]
        }, options2);
        group.name = "\\" + stash;
        base.classes.unshift("mop");
        base.italic = italic;
      }
    } else if (group.body) {
      var inner2 = buildExpression$1(group.body, options2, true);
      if (inner2.length === 1 && inner2[0] instanceof SymbolNode) {
        base = inner2[0];
        base.classes[0] = "mop";
      } else {
        base = buildCommon.makeSpan(["mop"], inner2, options2);
      }
    } else {
      var output = [];
      for (var i2 = 1; i2 < group.name.length; i2++) {
        output.push(buildCommon.mathsym(group.name[i2], group.mode, options2));
      }
      base = buildCommon.makeSpan(["mop"], output, options2);
    }
    var baseShift = 0;
    var slant = 0;
    if ((base instanceof SymbolNode || group.name === "\\oiint" || group.name === "\\oiiint") && !group.suppressBaseShift) {
      baseShift = (base.height - base.depth) / 2 - options2.fontMetrics().axisHeight;
      slant = base.italic;
    }
    if (hasLimits) {
      return assembleSupSub(base, supGroup, subGroup, options2, style, slant, baseShift);
    } else {
      if (baseShift) {
        base.style.position = "relative";
        base.style.top = makeEm(baseShift);
      }
      return base;
    }
  };
  var mathmlBuilder$1 = (group, options2) => {
    var node2;
    if (group.symbol) {
      node2 = new MathNode("mo", [makeText(group.name, group.mode)]);
      if (utils.contains(noSuccessor, group.name)) {
        node2.setAttribute("largeop", "false");
      }
    } else if (group.body) {
      node2 = new MathNode("mo", buildExpression(group.body, options2));
    } else {
      node2 = new MathNode("mi", [new TextNode(group.name.slice(1))]);
      var operator = new MathNode("mo", [makeText("⁡", "text")]);
      if (group.parentIsSupSub) {
        node2 = new MathNode("mrow", [node2, operator]);
      } else {
        node2 = newDocumentFragment([node2, operator]);
      }
    }
    return node2;
  };
  var singleCharBigOps = {
    "∏": "\\prod",
    "∐": "\\coprod",
    "∑": "\\sum",
    "⋀": "\\bigwedge",
    "⋁": "\\bigvee",
    "⋂": "\\bigcap",
    "⋃": "\\bigcup",
    "⨀": "\\bigodot",
    "⨁": "\\bigoplus",
    "⨂": "\\bigotimes",
    "⨄": "\\biguplus",
    "⨆": "\\bigsqcup"
  };
  defineFunction({
    type: "op",
    names: ["\\coprod", "\\bigvee", "\\bigwedge", "\\biguplus", "\\bigcap", "\\bigcup", "\\intop", "\\prod", "\\sum", "\\bigotimes", "\\bigoplus", "\\bigodot", "\\bigsqcup", "\\smallint", "∏", "∐", "∑", "⋀", "⋁", "⋂", "⋃", "⨀", "⨁", "⨂", "⨄", "⨆"],
    props: {
      numArgs: 0
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var fName = funcName;
      if (fName.length === 1) {
        fName = singleCharBigOps[fName];
      }
      return {
        type: "op",
        mode: parser2.mode,
        limits: true,
        parentIsSupSub: false,
        symbol: true,
        name: fName
      };
    },
    htmlBuilder: htmlBuilder$2,
    mathmlBuilder: mathmlBuilder$1
  });
  defineFunction({
    type: "op",
    names: ["\\mathop"],
    props: {
      numArgs: 1,
      primitive: true
    },
    handler: (_ref2, args) => {
      var {
        parser: parser2
      } = _ref2;
      var body = args[0];
      return {
        type: "op",
        mode: parser2.mode,
        limits: false,
        parentIsSupSub: false,
        symbol: false,
        body: ordargument(body)
      };
    },
    htmlBuilder: htmlBuilder$2,
    mathmlBuilder: mathmlBuilder$1
  });
  var singleCharIntegrals = {
    "∫": "\\int",
    "∬": "\\iint",
    "∭": "\\iiint",
    "∮": "\\oint",
    "∯": "\\oiint",
    "∰": "\\oiiint"
  };
  defineFunction({
    type: "op",
    names: ["\\arcsin", "\\arccos", "\\arctan", "\\arctg", "\\arcctg", "\\arg", "\\ch", "\\cos", "\\cosec", "\\cosh", "\\cot", "\\cotg", "\\coth", "\\csc", "\\ctg", "\\cth", "\\deg", "\\dim", "\\exp", "\\hom", "\\ker", "\\lg", "\\ln", "\\log", "\\sec", "\\sin", "\\sinh", "\\sh", "\\tan", "\\tanh", "\\tg", "\\th"],
    props: {
      numArgs: 0
    },
    handler(_ref3) {
      var {
        parser: parser2,
        funcName
      } = _ref3;
      return {
        type: "op",
        mode: parser2.mode,
        limits: false,
        parentIsSupSub: false,
        symbol: false,
        name: funcName
      };
    },
    htmlBuilder: htmlBuilder$2,
    mathmlBuilder: mathmlBuilder$1
  });
  defineFunction({
    type: "op",
    names: ["\\det", "\\gcd", "\\inf", "\\lim", "\\max", "\\min", "\\Pr", "\\sup"],
    props: {
      numArgs: 0
    },
    handler(_ref4) {
      var {
        parser: parser2,
        funcName
      } = _ref4;
      return {
        type: "op",
        mode: parser2.mode,
        limits: true,
        parentIsSupSub: false,
        symbol: false,
        name: funcName
      };
    },
    htmlBuilder: htmlBuilder$2,
    mathmlBuilder: mathmlBuilder$1
  });
  defineFunction({
    type: "op",
    names: ["\\int", "\\iint", "\\iiint", "\\oint", "\\oiint", "\\oiiint", "∫", "∬", "∭", "∮", "∯", "∰"],
    props: {
      numArgs: 0
    },
    handler(_ref5) {
      var {
        parser: parser2,
        funcName
      } = _ref5;
      var fName = funcName;
      if (fName.length === 1) {
        fName = singleCharIntegrals[fName];
      }
      return {
        type: "op",
        mode: parser2.mode,
        limits: false,
        parentIsSupSub: false,
        symbol: true,
        name: fName
      };
    },
    htmlBuilder: htmlBuilder$2,
    mathmlBuilder: mathmlBuilder$1
  });
  var htmlBuilder$1 = (grp, options2) => {
    var supGroup;
    var subGroup;
    var hasLimits = false;
    var group;
    if (grp.type === "supsub") {
      supGroup = grp.sup;
      subGroup = grp.sub;
      group = assertNodeType(grp.base, "operatorname");
      hasLimits = true;
    } else {
      group = assertNodeType(grp, "operatorname");
    }
    var base;
    if (group.body.length > 0) {
      var body = group.body.map((child2) => {
        var childText = child2.text;
        if (typeof childText === "string") {
          return {
            type: "textord",
            mode: child2.mode,
            text: childText
          };
        } else {
          return child2;
        }
      });
      var expression = buildExpression$1(body, options2.withFont("mathrm"), true);
      for (var i2 = 0; i2 < expression.length; i2++) {
        var child = expression[i2];
        if (child instanceof SymbolNode) {
          child.text = child.text.replace(/\u2212/, "-").replace(/\u2217/, "*");
        }
      }
      base = buildCommon.makeSpan(["mop"], expression, options2);
    } else {
      base = buildCommon.makeSpan(["mop"], [], options2);
    }
    if (hasLimits) {
      return assembleSupSub(base, supGroup, subGroup, options2, options2.style, 0, 0);
    } else {
      return base;
    }
  };
  var mathmlBuilder = (group, options2) => {
    var expression = buildExpression(group.body, options2.withFont("mathrm"));
    var isAllString = true;
    for (var i2 = 0; i2 < expression.length; i2++) {
      var node2 = expression[i2];
      if (node2 instanceof mathMLTree.SpaceNode)
        ;
      else if (node2 instanceof mathMLTree.MathNode) {
        switch (node2.type) {
          case "mi":
          case "mn":
          case "ms":
          case "mspace":
          case "mtext":
            break;
          case "mo": {
            var child = node2.children[0];
            if (node2.children.length === 1 && child instanceof mathMLTree.TextNode) {
              child.text = child.text.replace(/\u2212/, "-").replace(/\u2217/, "*");
            } else {
              isAllString = false;
            }
            break;
          }
          default:
            isAllString = false;
        }
      } else {
        isAllString = false;
      }
    }
    if (isAllString) {
      var word = expression.map((node3) => node3.toText()).join("");
      expression = [new mathMLTree.TextNode(word)];
    }
    var identifier2 = new mathMLTree.MathNode("mi", expression);
    identifier2.setAttribute("mathvariant", "normal");
    var operator = new mathMLTree.MathNode("mo", [makeText("⁡", "text")]);
    if (group.parentIsSupSub) {
      return new mathMLTree.MathNode("mrow", [identifier2, operator]);
    } else {
      return mathMLTree.newDocumentFragment([identifier2, operator]);
    }
  };
  defineFunction({
    type: "operatorname",
    names: ["\\operatorname@", "\\operatornamewithlimits"],
    props: {
      numArgs: 1
    },
    handler: (_ref, args) => {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var body = args[0];
      return {
        type: "operatorname",
        mode: parser2.mode,
        body: ordargument(body),
        alwaysHandleSupSub: funcName === "\\operatornamewithlimits",
        limits: false,
        parentIsSupSub: false
      };
    },
    htmlBuilder: htmlBuilder$1,
    mathmlBuilder
  });
  defineMacro("\\operatorname", "\\@ifstar\\operatornamewithlimits\\operatorname@");
  defineFunctionBuilders({
    type: "ordgroup",
    htmlBuilder(group, options2) {
      if (group.semisimple) {
        return buildCommon.makeFragment(buildExpression$1(group.body, options2, false));
      }
      return buildCommon.makeSpan(["mord"], buildExpression$1(group.body, options2, true), options2);
    },
    mathmlBuilder(group, options2) {
      return buildExpressionRow(group.body, options2, true);
    }
  });
  defineFunction({
    type: "overline",
    names: ["\\overline"],
    props: {
      numArgs: 1
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      var body = args[0];
      return {
        type: "overline",
        mode: parser2.mode,
        body
      };
    },
    htmlBuilder(group, options2) {
      var innerGroup = buildGroup$1(group.body, options2.havingCrampedStyle());
      var line2 = buildCommon.makeLineSpan("overline-line", options2);
      var defaultRuleThickness = options2.fontMetrics().defaultRuleThickness;
      var vlist = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: innerGroup
        }, {
          type: "kern",
          size: 3 * defaultRuleThickness
        }, {
          type: "elem",
          elem: line2
        }, {
          type: "kern",
          size: defaultRuleThickness
        }]
      }, options2);
      return buildCommon.makeSpan(["mord", "overline"], [vlist], options2);
    },
    mathmlBuilder(group, options2) {
      var operator = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode("‾")]);
      operator.setAttribute("stretchy", "true");
      var node2 = new mathMLTree.MathNode("mover", [buildGroup(group.body, options2), operator]);
      node2.setAttribute("accent", "true");
      return node2;
    }
  });
  defineFunction({
    type: "phantom",
    names: ["\\phantom"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        parser: parser2
      } = _ref;
      var body = args[0];
      return {
        type: "phantom",
        mode: parser2.mode,
        body: ordargument(body)
      };
    },
    htmlBuilder: (group, options2) => {
      var elements2 = buildExpression$1(group.body, options2.withPhantom(), false);
      return buildCommon.makeFragment(elements2);
    },
    mathmlBuilder: (group, options2) => {
      var inner2 = buildExpression(group.body, options2);
      return new mathMLTree.MathNode("mphantom", inner2);
    }
  });
  defineFunction({
    type: "hphantom",
    names: ["\\hphantom"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler: (_ref2, args) => {
      var {
        parser: parser2
      } = _ref2;
      var body = args[0];
      return {
        type: "hphantom",
        mode: parser2.mode,
        body
      };
    },
    htmlBuilder: (group, options2) => {
      var node2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2.withPhantom())]);
      node2.height = 0;
      node2.depth = 0;
      if (node2.children) {
        for (var i2 = 0; i2 < node2.children.length; i2++) {
          node2.children[i2].height = 0;
          node2.children[i2].depth = 0;
        }
      }
      node2 = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: node2
        }]
      }, options2);
      return buildCommon.makeSpan(["mord"], [node2], options2);
    },
    mathmlBuilder: (group, options2) => {
      var inner2 = buildExpression(ordargument(group.body), options2);
      var phantom = new mathMLTree.MathNode("mphantom", inner2);
      var node2 = new mathMLTree.MathNode("mpadded", [phantom]);
      node2.setAttribute("height", "0px");
      node2.setAttribute("depth", "0px");
      return node2;
    }
  });
  defineFunction({
    type: "vphantom",
    names: ["\\vphantom"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler: (_ref3, args) => {
      var {
        parser: parser2
      } = _ref3;
      var body = args[0];
      return {
        type: "vphantom",
        mode: parser2.mode,
        body
      };
    },
    htmlBuilder: (group, options2) => {
      var inner2 = buildCommon.makeSpan(["inner"], [buildGroup$1(group.body, options2.withPhantom())]);
      var fix = buildCommon.makeSpan(["fix"], []);
      return buildCommon.makeSpan(["mord", "rlap"], [inner2, fix], options2);
    },
    mathmlBuilder: (group, options2) => {
      var inner2 = buildExpression(ordargument(group.body), options2);
      var phantom = new mathMLTree.MathNode("mphantom", inner2);
      var node2 = new mathMLTree.MathNode("mpadded", [phantom]);
      node2.setAttribute("width", "0px");
      return node2;
    }
  });
  defineFunction({
    type: "raisebox",
    names: ["\\raisebox"],
    props: {
      numArgs: 2,
      argTypes: ["size", "hbox"],
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      var amount = assertNodeType(args[0], "size").value;
      var body = args[1];
      return {
        type: "raisebox",
        mode: parser2.mode,
        dy: amount,
        body
      };
    },
    htmlBuilder(group, options2) {
      var body = buildGroup$1(group.body, options2);
      var dy = calculateSize(group.dy, options2);
      return buildCommon.makeVList({
        positionType: "shift",
        positionData: -dy,
        children: [{
          type: "elem",
          elem: body
        }]
      }, options2);
    },
    mathmlBuilder(group, options2) {
      var node2 = new mathMLTree.MathNode("mpadded", [buildGroup(group.body, options2)]);
      var dy = group.dy.number + group.dy.unit;
      node2.setAttribute("voffset", dy);
      return node2;
    }
  });
  defineFunction({
    type: "internal",
    names: ["\\relax"],
    props: {
      numArgs: 0,
      allowedInText: true
    },
    handler(_ref) {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "internal",
        mode: parser2.mode
      };
    }
  });
  defineFunction({
    type: "rule",
    names: ["\\rule"],
    props: {
      numArgs: 2,
      numOptionalArgs: 1,
      argTypes: ["size", "size", "size"]
    },
    handler(_ref, args, optArgs) {
      var {
        parser: parser2
      } = _ref;
      var shift = optArgs[0];
      var width2 = assertNodeType(args[0], "size");
      var height = assertNodeType(args[1], "size");
      return {
        type: "rule",
        mode: parser2.mode,
        shift: shift && assertNodeType(shift, "size").value,
        width: width2.value,
        height: height.value
      };
    },
    htmlBuilder(group, options2) {
      var rule = buildCommon.makeSpan(["mord", "rule"], [], options2);
      var width2 = calculateSize(group.width, options2);
      var height = calculateSize(group.height, options2);
      var shift = group.shift ? calculateSize(group.shift, options2) : 0;
      rule.style.borderRightWidth = makeEm(width2);
      rule.style.borderTopWidth = makeEm(height);
      rule.style.bottom = makeEm(shift);
      rule.width = width2;
      rule.height = height + shift;
      rule.depth = -shift;
      rule.maxFontSize = height * 1.125 * options2.sizeMultiplier;
      return rule;
    },
    mathmlBuilder(group, options2) {
      var width2 = calculateSize(group.width, options2);
      var height = calculateSize(group.height, options2);
      var shift = group.shift ? calculateSize(group.shift, options2) : 0;
      var color2 = options2.color && options2.getColor() || "black";
      var rule = new mathMLTree.MathNode("mspace");
      rule.setAttribute("mathbackground", color2);
      rule.setAttribute("width", makeEm(width2));
      rule.setAttribute("height", makeEm(height));
      var wrapper = new mathMLTree.MathNode("mpadded", [rule]);
      if (shift >= 0) {
        wrapper.setAttribute("height", makeEm(shift));
      } else {
        wrapper.setAttribute("height", makeEm(shift));
        wrapper.setAttribute("depth", makeEm(-shift));
      }
      wrapper.setAttribute("voffset", makeEm(shift));
      return wrapper;
    }
  });
  function sizingGroup(value2, options2, baseOptions) {
    var inner2 = buildExpression$1(value2, options2, false);
    var multiplier = options2.sizeMultiplier / baseOptions.sizeMultiplier;
    for (var i2 = 0; i2 < inner2.length; i2++) {
      var pos = inner2[i2].classes.indexOf("sizing");
      if (pos < 0) {
        Array.prototype.push.apply(inner2[i2].classes, options2.sizingClasses(baseOptions));
      } else if (inner2[i2].classes[pos + 1] === "reset-size" + options2.size) {
        inner2[i2].classes[pos + 1] = "reset-size" + baseOptions.size;
      }
      inner2[i2].height *= multiplier;
      inner2[i2].depth *= multiplier;
    }
    return buildCommon.makeFragment(inner2);
  }
  var sizeFuncs = ["\\tiny", "\\sixptsize", "\\scriptsize", "\\footnotesize", "\\small", "\\normalsize", "\\large", "\\Large", "\\LARGE", "\\huge", "\\Huge"];
  var htmlBuilder = (group, options2) => {
    var newOptions = options2.havingSize(group.size);
    return sizingGroup(group.body, newOptions, options2);
  };
  defineFunction({
    type: "sizing",
    names: sizeFuncs,
    props: {
      numArgs: 0,
      allowedInText: true
    },
    handler: (_ref, args) => {
      var {
        breakOnTokenText,
        funcName,
        parser: parser2
      } = _ref;
      var body = parser2.parseExpression(false, breakOnTokenText);
      return {
        type: "sizing",
        mode: parser2.mode,
        // Figure out what size to use based on the list of functions above
        size: sizeFuncs.indexOf(funcName) + 1,
        body
      };
    },
    htmlBuilder,
    mathmlBuilder: (group, options2) => {
      var newOptions = options2.havingSize(group.size);
      var inner2 = buildExpression(group.body, newOptions);
      var node2 = new mathMLTree.MathNode("mstyle", inner2);
      node2.setAttribute("mathsize", makeEm(newOptions.sizeMultiplier));
      return node2;
    }
  });
  defineFunction({
    type: "smash",
    names: ["\\smash"],
    props: {
      numArgs: 1,
      numOptionalArgs: 1,
      allowedInText: true
    },
    handler: (_ref, args, optArgs) => {
      var {
        parser: parser2
      } = _ref;
      var smashHeight = false;
      var smashDepth = false;
      var tbArg = optArgs[0] && assertNodeType(optArgs[0], "ordgroup");
      if (tbArg) {
        var letter = "";
        for (var i2 = 0; i2 < tbArg.body.length; ++i2) {
          var node2 = tbArg.body[i2];
          letter = node2.text;
          if (letter === "t") {
            smashHeight = true;
          } else if (letter === "b") {
            smashDepth = true;
          } else {
            smashHeight = false;
            smashDepth = false;
            break;
          }
        }
      } else {
        smashHeight = true;
        smashDepth = true;
      }
      var body = args[0];
      return {
        type: "smash",
        mode: parser2.mode,
        body,
        smashHeight,
        smashDepth
      };
    },
    htmlBuilder: (group, options2) => {
      var node2 = buildCommon.makeSpan([], [buildGroup$1(group.body, options2)]);
      if (!group.smashHeight && !group.smashDepth) {
        return node2;
      }
      if (group.smashHeight) {
        node2.height = 0;
        if (node2.children) {
          for (var i2 = 0; i2 < node2.children.length; i2++) {
            node2.children[i2].height = 0;
          }
        }
      }
      if (group.smashDepth) {
        node2.depth = 0;
        if (node2.children) {
          for (var _i6 = 0; _i6 < node2.children.length; _i6++) {
            node2.children[_i6].depth = 0;
          }
        }
      }
      var smashedNode = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: node2
        }]
      }, options2);
      return buildCommon.makeSpan(["mord"], [smashedNode], options2);
    },
    mathmlBuilder: (group, options2) => {
      var node2 = new mathMLTree.MathNode("mpadded", [buildGroup(group.body, options2)]);
      if (group.smashHeight) {
        node2.setAttribute("height", "0px");
      }
      if (group.smashDepth) {
        node2.setAttribute("depth", "0px");
      }
      return node2;
    }
  });
  defineFunction({
    type: "sqrt",
    names: ["\\sqrt"],
    props: {
      numArgs: 1,
      numOptionalArgs: 1
    },
    handler(_ref, args, optArgs) {
      var {
        parser: parser2
      } = _ref;
      var index2 = optArgs[0];
      var body = args[0];
      return {
        type: "sqrt",
        mode: parser2.mode,
        body,
        index: index2
      };
    },
    htmlBuilder(group, options2) {
      var inner2 = buildGroup$1(group.body, options2.havingCrampedStyle());
      if (inner2.height === 0) {
        inner2.height = options2.fontMetrics().xHeight;
      }
      inner2 = buildCommon.wrapFragment(inner2, options2);
      var metrics = options2.fontMetrics();
      var theta = metrics.defaultRuleThickness;
      var phi = theta;
      if (options2.style.id < Style$1.TEXT.id) {
        phi = options2.fontMetrics().xHeight;
      }
      var lineClearance = theta + phi / 4;
      var minDelimiterHeight = inner2.height + inner2.depth + lineClearance + theta;
      var {
        span: img,
        ruleWidth,
        advanceWidth
      } = delimiter.sqrtImage(minDelimiterHeight, options2);
      var delimDepth = img.height - ruleWidth;
      if (delimDepth > inner2.height + inner2.depth + lineClearance) {
        lineClearance = (lineClearance + delimDepth - inner2.height - inner2.depth) / 2;
      }
      var imgShift = img.height - inner2.height - lineClearance - ruleWidth;
      inner2.style.paddingLeft = makeEm(advanceWidth);
      var body = buildCommon.makeVList({
        positionType: "firstBaseline",
        children: [{
          type: "elem",
          elem: inner2,
          wrapperClasses: ["svg-align"]
        }, {
          type: "kern",
          size: -(inner2.height + imgShift)
        }, {
          type: "elem",
          elem: img
        }, {
          type: "kern",
          size: ruleWidth
        }]
      }, options2);
      if (!group.index) {
        return buildCommon.makeSpan(["mord", "sqrt"], [body], options2);
      } else {
        var newOptions = options2.havingStyle(Style$1.SCRIPTSCRIPT);
        var rootm = buildGroup$1(group.index, newOptions, options2);
        var toShift = 0.6 * (body.height - body.depth);
        var rootVList = buildCommon.makeVList({
          positionType: "shift",
          positionData: -toShift,
          children: [{
            type: "elem",
            elem: rootm
          }]
        }, options2);
        var rootVListWrap = buildCommon.makeSpan(["root"], [rootVList]);
        return buildCommon.makeSpan(["mord", "sqrt"], [rootVListWrap, body], options2);
      }
    },
    mathmlBuilder(group, options2) {
      var {
        body,
        index: index2
      } = group;
      return index2 ? new mathMLTree.MathNode("mroot", [buildGroup(body, options2), buildGroup(index2, options2)]) : new mathMLTree.MathNode("msqrt", [buildGroup(body, options2)]);
    }
  });
  var styleMap = {
    "display": Style$1.DISPLAY,
    "text": Style$1.TEXT,
    "script": Style$1.SCRIPT,
    "scriptscript": Style$1.SCRIPTSCRIPT
  };
  defineFunction({
    type: "styling",
    names: ["\\displaystyle", "\\textstyle", "\\scriptstyle", "\\scriptscriptstyle"],
    props: {
      numArgs: 0,
      allowedInText: true,
      primitive: true
    },
    handler(_ref, args) {
      var {
        breakOnTokenText,
        funcName,
        parser: parser2
      } = _ref;
      var body = parser2.parseExpression(true, breakOnTokenText);
      var style = funcName.slice(1, funcName.length - 5);
      return {
        type: "styling",
        mode: parser2.mode,
        // Figure out what style to use by pulling out the style from
        // the function name
        style,
        body
      };
    },
    htmlBuilder(group, options2) {
      var newStyle = styleMap[group.style];
      var newOptions = options2.havingStyle(newStyle).withFont("");
      return sizingGroup(group.body, newOptions, options2);
    },
    mathmlBuilder(group, options2) {
      var newStyle = styleMap[group.style];
      var newOptions = options2.havingStyle(newStyle);
      var inner2 = buildExpression(group.body, newOptions);
      var node2 = new mathMLTree.MathNode("mstyle", inner2);
      var styleAttributes = {
        "display": ["0", "true"],
        "text": ["0", "false"],
        "script": ["1", "false"],
        "scriptscript": ["2", "false"]
      };
      var attr = styleAttributes[group.style];
      node2.setAttribute("scriptlevel", attr[0]);
      node2.setAttribute("displaystyle", attr[1]);
      return node2;
    }
  });
  var htmlBuilderDelegate = function htmlBuilderDelegate2(group, options2) {
    var base = group.base;
    if (!base) {
      return null;
    } else if (base.type === "op") {
      var delegate = base.limits && (options2.style.size === Style$1.DISPLAY.size || base.alwaysHandleSupSub);
      return delegate ? htmlBuilder$2 : null;
    } else if (base.type === "operatorname") {
      var _delegate = base.alwaysHandleSupSub && (options2.style.size === Style$1.DISPLAY.size || base.limits);
      return _delegate ? htmlBuilder$1 : null;
    } else if (base.type === "accent") {
      return utils.isCharacterBox(base.base) ? htmlBuilder$a : null;
    } else if (base.type === "horizBrace") {
      var isSup = !group.sub;
      return isSup === base.isOver ? htmlBuilder$3 : null;
    } else {
      return null;
    }
  };
  defineFunctionBuilders({
    type: "supsub",
    htmlBuilder(group, options2) {
      var builderDelegate = htmlBuilderDelegate(group, options2);
      if (builderDelegate) {
        return builderDelegate(group, options2);
      }
      var {
        base: valueBase,
        sup: valueSup,
        sub: valueSub
      } = group;
      var base = buildGroup$1(valueBase, options2);
      var supm;
      var subm;
      var metrics = options2.fontMetrics();
      var supShift = 0;
      var subShift = 0;
      var isCharacterBox2 = valueBase && utils.isCharacterBox(valueBase);
      if (valueSup) {
        var newOptions = options2.havingStyle(options2.style.sup());
        supm = buildGroup$1(valueSup, newOptions, options2);
        if (!isCharacterBox2) {
          supShift = base.height - newOptions.fontMetrics().supDrop * newOptions.sizeMultiplier / options2.sizeMultiplier;
        }
      }
      if (valueSub) {
        var _newOptions = options2.havingStyle(options2.style.sub());
        subm = buildGroup$1(valueSub, _newOptions, options2);
        if (!isCharacterBox2) {
          subShift = base.depth + _newOptions.fontMetrics().subDrop * _newOptions.sizeMultiplier / options2.sizeMultiplier;
        }
      }
      var minSupShift;
      if (options2.style === Style$1.DISPLAY) {
        minSupShift = metrics.sup1;
      } else if (options2.style.cramped) {
        minSupShift = metrics.sup3;
      } else {
        minSupShift = metrics.sup2;
      }
      var multiplier = options2.sizeMultiplier;
      var marginRight = makeEm(0.5 / metrics.ptPerEm / multiplier);
      var marginLeft = null;
      if (subm) {
        var isOiint = group.base && group.base.type === "op" && group.base.name && (group.base.name === "\\oiint" || group.base.name === "\\oiiint");
        if (base instanceof SymbolNode || isOiint) {
          marginLeft = makeEm(-base.italic);
        }
      }
      var supsub;
      if (supm && subm) {
        supShift = Math.max(supShift, minSupShift, supm.depth + 0.25 * metrics.xHeight);
        subShift = Math.max(subShift, metrics.sub2);
        var ruleWidth = metrics.defaultRuleThickness;
        var maxWidth = 4 * ruleWidth;
        if (supShift - supm.depth - (subm.height - subShift) < maxWidth) {
          subShift = maxWidth - (supShift - supm.depth) + subm.height;
          var psi = 0.8 * metrics.xHeight - (supShift - supm.depth);
          if (psi > 0) {
            supShift += psi;
            subShift -= psi;
          }
        }
        var vlistElem = [{
          type: "elem",
          elem: subm,
          shift: subShift,
          marginRight,
          marginLeft
        }, {
          type: "elem",
          elem: supm,
          shift: -supShift,
          marginRight
        }];
        supsub = buildCommon.makeVList({
          positionType: "individualShift",
          children: vlistElem
        }, options2);
      } else if (subm) {
        subShift = Math.max(subShift, metrics.sub1, subm.height - 0.8 * metrics.xHeight);
        var _vlistElem = [{
          type: "elem",
          elem: subm,
          marginLeft,
          marginRight
        }];
        supsub = buildCommon.makeVList({
          positionType: "shift",
          positionData: subShift,
          children: _vlistElem
        }, options2);
      } else if (supm) {
        supShift = Math.max(supShift, minSupShift, supm.depth + 0.25 * metrics.xHeight);
        supsub = buildCommon.makeVList({
          positionType: "shift",
          positionData: -supShift,
          children: [{
            type: "elem",
            elem: supm,
            marginRight
          }]
        }, options2);
      } else {
        throw new Error("supsub must have either sup or sub.");
      }
      var mclass = getTypeOfDomTree(base, "right") || "mord";
      return buildCommon.makeSpan([mclass], [base, buildCommon.makeSpan(["msupsub"], [supsub])], options2);
    },
    mathmlBuilder(group, options2) {
      var isBrace = false;
      var isOver;
      var isSup;
      if (group.base && group.base.type === "horizBrace") {
        isSup = !!group.sup;
        if (isSup === group.base.isOver) {
          isBrace = true;
          isOver = group.base.isOver;
        }
      }
      if (group.base && (group.base.type === "op" || group.base.type === "operatorname")) {
        group.base.parentIsSupSub = true;
      }
      var children2 = [buildGroup(group.base, options2)];
      if (group.sub) {
        children2.push(buildGroup(group.sub, options2));
      }
      if (group.sup) {
        children2.push(buildGroup(group.sup, options2));
      }
      var nodeType2;
      if (isBrace) {
        nodeType2 = isOver ? "mover" : "munder";
      } else if (!group.sub) {
        var base = group.base;
        if (base && base.type === "op" && base.limits && (options2.style === Style$1.DISPLAY || base.alwaysHandleSupSub)) {
          nodeType2 = "mover";
        } else if (base && base.type === "operatorname" && base.alwaysHandleSupSub && (base.limits || options2.style === Style$1.DISPLAY)) {
          nodeType2 = "mover";
        } else {
          nodeType2 = "msup";
        }
      } else if (!group.sup) {
        var _base = group.base;
        if (_base && _base.type === "op" && _base.limits && (options2.style === Style$1.DISPLAY || _base.alwaysHandleSupSub)) {
          nodeType2 = "munder";
        } else if (_base && _base.type === "operatorname" && _base.alwaysHandleSupSub && (_base.limits || options2.style === Style$1.DISPLAY)) {
          nodeType2 = "munder";
        } else {
          nodeType2 = "msub";
        }
      } else {
        var _base2 = group.base;
        if (_base2 && _base2.type === "op" && _base2.limits && options2.style === Style$1.DISPLAY) {
          nodeType2 = "munderover";
        } else if (_base2 && _base2.type === "operatorname" && _base2.alwaysHandleSupSub && (options2.style === Style$1.DISPLAY || _base2.limits)) {
          nodeType2 = "munderover";
        } else {
          nodeType2 = "msubsup";
        }
      }
      return new mathMLTree.MathNode(nodeType2, children2);
    }
  });
  defineFunctionBuilders({
    type: "atom",
    htmlBuilder(group, options2) {
      return buildCommon.mathsym(group.text, group.mode, options2, ["m" + group.family]);
    },
    mathmlBuilder(group, options2) {
      var node2 = new mathMLTree.MathNode("mo", [makeText(group.text, group.mode)]);
      if (group.family === "bin") {
        var variant = getVariant(group, options2);
        if (variant === "bold-italic") {
          node2.setAttribute("mathvariant", variant);
        }
      } else if (group.family === "punct") {
        node2.setAttribute("separator", "true");
      } else if (group.family === "open" || group.family === "close") {
        node2.setAttribute("stretchy", "false");
      }
      return node2;
    }
  });
  var defaultVariant = {
    "mi": "italic",
    "mn": "normal",
    "mtext": "normal"
  };
  defineFunctionBuilders({
    type: "mathord",
    htmlBuilder(group, options2) {
      return buildCommon.makeOrd(group, options2, "mathord");
    },
    mathmlBuilder(group, options2) {
      var node2 = new mathMLTree.MathNode("mi", [makeText(group.text, group.mode, options2)]);
      var variant = getVariant(group, options2) || "italic";
      if (variant !== defaultVariant[node2.type]) {
        node2.setAttribute("mathvariant", variant);
      }
      return node2;
    }
  });
  defineFunctionBuilders({
    type: "textord",
    htmlBuilder(group, options2) {
      return buildCommon.makeOrd(group, options2, "textord");
    },
    mathmlBuilder(group, options2) {
      var text2 = makeText(group.text, group.mode, options2);
      var variant = getVariant(group, options2) || "normal";
      var node2;
      if (group.mode === "text") {
        node2 = new mathMLTree.MathNode("mtext", [text2]);
      } else if (/[0-9]/.test(group.text)) {
        node2 = new mathMLTree.MathNode("mn", [text2]);
      } else if (group.text === "\\prime") {
        node2 = new mathMLTree.MathNode("mo", [text2]);
      } else {
        node2 = new mathMLTree.MathNode("mi", [text2]);
      }
      if (variant !== defaultVariant[node2.type]) {
        node2.setAttribute("mathvariant", variant);
      }
      return node2;
    }
  });
  var cssSpace = {
    "\\nobreak": "nobreak",
    "\\allowbreak": "allowbreak"
  };
  var regularSpace = {
    " ": {},
    "\\ ": {},
    "~": {
      className: "nobreak"
    },
    "\\space": {},
    "\\nobreakspace": {
      className: "nobreak"
    }
  };
  defineFunctionBuilders({
    type: "spacing",
    htmlBuilder(group, options2) {
      if (regularSpace.hasOwnProperty(group.text)) {
        var className = regularSpace[group.text].className || "";
        if (group.mode === "text") {
          var ord = buildCommon.makeOrd(group, options2, "textord");
          ord.classes.push(className);
          return ord;
        } else {
          return buildCommon.makeSpan(["mspace", className], [buildCommon.mathsym(group.text, group.mode, options2)], options2);
        }
      } else if (cssSpace.hasOwnProperty(group.text)) {
        return buildCommon.makeSpan(["mspace", cssSpace[group.text]], [], options2);
      } else {
        throw new ParseError('Unknown type of space "' + group.text + '"');
      }
    },
    mathmlBuilder(group, options2) {
      var node2;
      if (regularSpace.hasOwnProperty(group.text)) {
        node2 = new mathMLTree.MathNode("mtext", [new mathMLTree.TextNode(" ")]);
      } else if (cssSpace.hasOwnProperty(group.text)) {
        return new mathMLTree.MathNode("mspace");
      } else {
        throw new ParseError('Unknown type of space "' + group.text + '"');
      }
      return node2;
    }
  });
  var pad = () => {
    var padNode = new mathMLTree.MathNode("mtd", []);
    padNode.setAttribute("width", "50%");
    return padNode;
  };
  defineFunctionBuilders({
    type: "tag",
    mathmlBuilder(group, options2) {
      var table = new mathMLTree.MathNode("mtable", [new mathMLTree.MathNode("mtr", [pad(), new mathMLTree.MathNode("mtd", [buildExpressionRow(group.body, options2)]), pad(), new mathMLTree.MathNode("mtd", [buildExpressionRow(group.tag, options2)])])]);
      table.setAttribute("width", "100%");
      return table;
    }
  });
  var textFontFamilies = {
    "\\text": void 0,
    "\\textrm": "textrm",
    "\\textsf": "textsf",
    "\\texttt": "texttt",
    "\\textnormal": "textrm"
  };
  var textFontWeights = {
    "\\textbf": "textbf",
    "\\textmd": "textmd"
  };
  var textFontShapes = {
    "\\textit": "textit",
    "\\textup": "textup"
  };
  var optionsWithFont = (group, options2) => {
    var font = group.font;
    if (!font) {
      return options2;
    } else if (textFontFamilies[font]) {
      return options2.withTextFontFamily(textFontFamilies[font]);
    } else if (textFontWeights[font]) {
      return options2.withTextFontWeight(textFontWeights[font]);
    } else {
      return options2.withTextFontShape(textFontShapes[font]);
    }
  };
  defineFunction({
    type: "text",
    names: [
      // Font families
      "\\text",
      "\\textrm",
      "\\textsf",
      "\\texttt",
      "\\textnormal",
      // Font weights
      "\\textbf",
      "\\textmd",
      // Font Shapes
      "\\textit",
      "\\textup"
    ],
    props: {
      numArgs: 1,
      argTypes: ["text"],
      allowedInArgument: true,
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2,
        funcName
      } = _ref;
      var body = args[0];
      return {
        type: "text",
        mode: parser2.mode,
        body: ordargument(body),
        font: funcName
      };
    },
    htmlBuilder(group, options2) {
      var newOptions = optionsWithFont(group, options2);
      var inner2 = buildExpression$1(group.body, newOptions, true);
      return buildCommon.makeSpan(["mord", "text"], inner2, newOptions);
    },
    mathmlBuilder(group, options2) {
      var newOptions = optionsWithFont(group, options2);
      return buildExpressionRow(group.body, newOptions);
    }
  });
  defineFunction({
    type: "underline",
    names: ["\\underline"],
    props: {
      numArgs: 1,
      allowedInText: true
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "underline",
        mode: parser2.mode,
        body: args[0]
      };
    },
    htmlBuilder(group, options2) {
      var innerGroup = buildGroup$1(group.body, options2);
      var line2 = buildCommon.makeLineSpan("underline-line", options2);
      var defaultRuleThickness = options2.fontMetrics().defaultRuleThickness;
      var vlist = buildCommon.makeVList({
        positionType: "top",
        positionData: innerGroup.height,
        children: [{
          type: "kern",
          size: defaultRuleThickness
        }, {
          type: "elem",
          elem: line2
        }, {
          type: "kern",
          size: 3 * defaultRuleThickness
        }, {
          type: "elem",
          elem: innerGroup
        }]
      }, options2);
      return buildCommon.makeSpan(["mord", "underline"], [vlist], options2);
    },
    mathmlBuilder(group, options2) {
      var operator = new mathMLTree.MathNode("mo", [new mathMLTree.TextNode("‾")]);
      operator.setAttribute("stretchy", "true");
      var node2 = new mathMLTree.MathNode("munder", [buildGroup(group.body, options2), operator]);
      node2.setAttribute("accentunder", "true");
      return node2;
    }
  });
  defineFunction({
    type: "vcenter",
    names: ["\\vcenter"],
    props: {
      numArgs: 1,
      argTypes: ["original"],
      // In LaTeX, \vcenter can act only on a box.
      allowedInText: false
    },
    handler(_ref, args) {
      var {
        parser: parser2
      } = _ref;
      return {
        type: "vcenter",
        mode: parser2.mode,
        body: args[0]
      };
    },
    htmlBuilder(group, options2) {
      var body = buildGroup$1(group.body, options2);
      var axisHeight = options2.fontMetrics().axisHeight;
      var dy = 0.5 * (body.height - axisHeight - (body.depth + axisHeight));
      return buildCommon.makeVList({
        positionType: "shift",
        positionData: dy,
        children: [{
          type: "elem",
          elem: body
        }]
      }, options2);
    },
    mathmlBuilder(group, options2) {
      return new mathMLTree.MathNode("mpadded", [buildGroup(group.body, options2)], ["vcenter"]);
    }
  });
  defineFunction({
    type: "verb",
    names: ["\\verb"],
    props: {
      numArgs: 0,
      allowedInText: true
    },
    handler(context, args, optArgs) {
      throw new ParseError("\\verb ended by end of line instead of matching delimiter");
    },
    htmlBuilder(group, options2) {
      var text2 = makeVerb(group);
      var body = [];
      var newOptions = options2.havingStyle(options2.style.text());
      for (var i2 = 0; i2 < text2.length; i2++) {
        var c2 = text2[i2];
        if (c2 === "~") {
          c2 = "\\textasciitilde";
        }
        body.push(buildCommon.makeSymbol(c2, "Typewriter-Regular", group.mode, newOptions, ["mord", "texttt"]));
      }
      return buildCommon.makeSpan(["mord", "text"].concat(newOptions.sizingClasses(options2)), buildCommon.tryCombineChars(body), newOptions);
    },
    mathmlBuilder(group, options2) {
      var text2 = new mathMLTree.TextNode(makeVerb(group));
      var node2 = new mathMLTree.MathNode("mtext", [text2]);
      node2.setAttribute("mathvariant", "monospace");
      return node2;
    }
  });
  var makeVerb = (group) => group.body.replace(/ /g, group.star ? "␣" : " ");
  var functions$1 = _functions;
  var spaceRegexString = "[ \r\n	]";
  var controlWordRegexString = "\\\\[a-zA-Z@]+";
  var controlSymbolRegexString = "\\\\[^\uD800-\uDFFF]";
  var controlWordWhitespaceRegexString = "(" + controlWordRegexString + ")" + spaceRegexString + "*";
  var controlSpaceRegexString = "\\\\(\n|[ \r	]+\n?)[ \r	]*";
  var combiningDiacriticalMarkString = "[̀-ͯ]";
  var combiningDiacriticalMarksEndRegex = new RegExp(combiningDiacriticalMarkString + "+$");
  var tokenRegexString = "(" + spaceRegexString + "+)|" + // whitespace
  (controlSpaceRegexString + "|") + // \whitespace
  "([!-\\[\\]-‧‪-퟿豈-￿]" + // single codepoint
  (combiningDiacriticalMarkString + "*") + // ...plus accents
  "|[\uD800-\uDBFF][\uDC00-\uDFFF]" + // surrogate pair
  (combiningDiacriticalMarkString + "*") + // ...plus accents
  "|\\\\verb\\*([^]).*?\\4|\\\\verb([^*a-zA-Z]).*?\\5" + // \verb unstarred
  ("|" + controlWordWhitespaceRegexString) + // \macroName + spaces
  ("|" + controlSymbolRegexString + ")");
  class Lexer {
    // Category codes. The lexer only supports comment characters (14) for now.
    // MacroExpander additionally distinguishes active (13).
    constructor(input, settings) {
      this.input = void 0;
      this.settings = void 0;
      this.tokenRegex = void 0;
      this.catcodes = void 0;
      this.input = input;
      this.settings = settings;
      this.tokenRegex = new RegExp(tokenRegexString, "g");
      this.catcodes = {
        "%": 14,
        // comment character
        "~": 13
        // active character
      };
    }
    setCatcode(char2, code) {
      this.catcodes[char2] = code;
    }
    /**
     * This function lexes a single token.
     */
    lex() {
      var input = this.input;
      var pos = this.tokenRegex.lastIndex;
      if (pos === input.length) {
        return new Token("EOF", new SourceLocation(this, pos, pos));
      }
      var match = this.tokenRegex.exec(input);
      if (match === null || match.index !== pos) {
        throw new ParseError("Unexpected character: '" + input[pos] + "'", new Token(input[pos], new SourceLocation(this, pos, pos + 1)));
      }
      var text2 = match[6] || match[3] || (match[2] ? "\\ " : " ");
      if (this.catcodes[text2] === 14) {
        var nlIndex = input.indexOf("\n", this.tokenRegex.lastIndex);
        if (nlIndex === -1) {
          this.tokenRegex.lastIndex = input.length;
          this.settings.reportNonstrict("commentAtEnd", "% comment has no terminating newline; LaTeX would fail because of commenting the end of math mode (e.g. $)");
        } else {
          this.tokenRegex.lastIndex = nlIndex + 1;
        }
        return this.lex();
      }
      return new Token(text2, new SourceLocation(this, pos, this.tokenRegex.lastIndex));
    }
  }
  class Namespace {
    /**
     * Both arguments are optional.  The first argument is an object of
     * built-in mappings which never change.  The second argument is an object
     * of initial (global-level) mappings, which will constantly change
     * according to any global/top-level `set`s done.
     */
    constructor(builtins, globalMacros) {
      if (builtins === void 0) {
        builtins = {};
      }
      if (globalMacros === void 0) {
        globalMacros = {};
      }
      this.current = void 0;
      this.builtins = void 0;
      this.undefStack = void 0;
      this.current = globalMacros;
      this.builtins = builtins;
      this.undefStack = [];
    }
    /**
     * Start a new nested group, affecting future local `set`s.
     */
    beginGroup() {
      this.undefStack.push({});
    }
    /**
     * End current nested group, restoring values before the group began.
     */
    endGroup() {
      if (this.undefStack.length === 0) {
        throw new ParseError("Unbalanced namespace destruction: attempt to pop global namespace; please report this as a bug");
      }
      var undefs = this.undefStack.pop();
      for (var undef in undefs) {
        if (undefs.hasOwnProperty(undef)) {
          if (undefs[undef] == null) {
            delete this.current[undef];
          } else {
            this.current[undef] = undefs[undef];
          }
        }
      }
    }
    /**
     * Ends all currently nested groups (if any), restoring values before the
     * groups began.  Useful in case of an error in the middle of parsing.
     */
    endGroups() {
      while (this.undefStack.length > 0) {
        this.endGroup();
      }
    }
    /**
     * Detect whether `name` has a definition.  Equivalent to
     * `get(name) != null`.
     */
    has(name) {
      return this.current.hasOwnProperty(name) || this.builtins.hasOwnProperty(name);
    }
    /**
     * Get the current value of a name, or `undefined` if there is no value.
     *
     * Note: Do not use `if (namespace.get(...))` to detect whether a macro
     * is defined, as the definition may be the empty string which evaluates
     * to `false` in JavaScript.  Use `if (namespace.get(...) != null)` or
     * `if (namespace.has(...))`.
     */
    get(name) {
      if (this.current.hasOwnProperty(name)) {
        return this.current[name];
      } else {
        return this.builtins[name];
      }
    }
    /**
     * Set the current value of a name, and optionally set it globally too.
     * Local set() sets the current value and (when appropriate) adds an undo
     * operation to the undo stack.  Global set() may change the undo
     * operation at every level, so takes time linear in their number.
     * A value of undefined means to delete existing definitions.
     */
    set(name, value2, global2) {
      if (global2 === void 0) {
        global2 = false;
      }
      if (global2) {
        for (var i2 = 0; i2 < this.undefStack.length; i2++) {
          delete this.undefStack[i2][name];
        }
        if (this.undefStack.length > 0) {
          this.undefStack[this.undefStack.length - 1][name] = value2;
        }
      } else {
        var top2 = this.undefStack[this.undefStack.length - 1];
        if (top2 && !top2.hasOwnProperty(name)) {
          top2[name] = this.current[name];
        }
      }
      if (value2 == null) {
        delete this.current[name];
      } else {
        this.current[name] = value2;
      }
    }
  }
  var macros = _macros;
  defineMacro("\\noexpand", function(context) {
    var t = context.popToken();
    if (context.isExpandable(t.text)) {
      t.noexpand = true;
      t.treatAsRelax = true;
    }
    return {
      tokens: [t],
      numArgs: 0
    };
  });
  defineMacro("\\expandafter", function(context) {
    var t = context.popToken();
    context.expandOnce(true);
    return {
      tokens: [t],
      numArgs: 0
    };
  });
  defineMacro("\\@firstoftwo", function(context) {
    var args = context.consumeArgs(2);
    return {
      tokens: args[0],
      numArgs: 0
    };
  });
  defineMacro("\\@secondoftwo", function(context) {
    var args = context.consumeArgs(2);
    return {
      tokens: args[1],
      numArgs: 0
    };
  });
  defineMacro("\\@ifnextchar", function(context) {
    var args = context.consumeArgs(3);
    context.consumeSpaces();
    var nextToken = context.future();
    if (args[0].length === 1 && args[0][0].text === nextToken.text) {
      return {
        tokens: args[1],
        numArgs: 0
      };
    } else {
      return {
        tokens: args[2],
        numArgs: 0
      };
    }
  });
  defineMacro("\\@ifstar", "\\@ifnextchar *{\\@firstoftwo{#1}}");
  defineMacro("\\TextOrMath", function(context) {
    var args = context.consumeArgs(2);
    if (context.mode === "text") {
      return {
        tokens: args[0],
        numArgs: 0
      };
    } else {
      return {
        tokens: args[1],
        numArgs: 0
      };
    }
  });
  var digitToNumber = {
    "0": 0,
    "1": 1,
    "2": 2,
    "3": 3,
    "4": 4,
    "5": 5