# metismenu [![NPM version](https://img.shields.io/npm/v/metismenu.svg?style=flat)](https://www.npmjs.com/package/metismenu) [![NPM monthly downloads](https://img.shields.io/npm/dm/metismenu.svg?style=flat)](https://npmjs.org/package/metismenu)  [![NPM total downloads](https://img.shields.io/npm/dt/metismenu.svg?style=flat)](https://npmjs.org/package/metismenu)  [![](https://data.jsdelivr.com/v1/package/npm/metismenu/badge)](https://www.jsdelivr.com/package/npm/metismenu) [![Packagist](https://img.shields.io/packagist/v/onokumus/metismenu.svg)](https://packagist.org/packages/onokumus/metismenu)

> A menu plugin

## Table of Contents

- [Getting started](#getting-started)
  * [Install](#install)
  * [Download](#download)
- [Usage](#usage)
  * [Stopping list opening on certain elements](#stopping-list-opening-on-certain-elements)
- [Options](#options)
    + [toggle](#toggle)
    + [activeClass `deprecated`](#activeclass-deprecated)
    + [collapseClass `deprecated`](#collapseclass-deprecated)
    + [collapseInClass `deprecated`](#collapseinclass-deprecated)
    + [collapsingClass `deprecated`](#collapsingclass-deprecated)
    + [preventDefault *removed*](#preventdefault-removed)
    + [triggerElement](#triggerelement)
    + [parentTrigger](#parenttrigger)
    + [subMenu](#submenu)
- [API](#api)
    + [dispose](#dispose)
    + [update](#update)
- [Events](#events)
- [Demo](#demo)
- [About](#about)
  * [Related projects](#related-projects)
  * [Contributors](#contributors)
  * [Contributing](#contributing)
  * [Release History](#release-history)
  * [Author](#author)
  * [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Getting started
### Install
Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save metismenu@next
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add metismenu@next
```

Install with [composer](https://getcomposer.org/)

```sh
$ composer require onokumus/metismenu:dev-master
```

### Download
[download](https://github.com/onokumus/metismenu/archive/v3.zip)

## Usage

1. Include metismenu StyleSheet

  ```html
  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/metisMenu/3.0.0-alpha.1/metisMenu.min.css">
  <!-- OR -->  
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/metismenu@3.0.0-alpha.1/dist/metisMenu.css">
  ```

2. Include metisMenu plugin's code

  ```html
  <script src="//cdnjs.cloudflare.com/ajax/libs/metisMenu/3.0.0-alpha.1/metisMenu.min.js"></script>
  <!-- OR -->
  <script src="https://cdn.jsdelivr.net/npm/metismenu@3.0.0-alpha.1/dist/metisMenu.min.js"></script>
  ```

3. Add class `metismenu` to unordered list

  ```html
  <ul class="metismenu" id="menu">

  </ul>
  ```
4. Make expand/collapse controls accessible

  > Be sure to add `aria-expanded` to the element `a`. This attribute explicitly defines the current state of the collapsible element to screen readers and similar assistive technologies. If the collapsible element is closed by default, it should have a value of `aria-expanded="false"`. If you've set the collapsible element's parent `li` element to be open by default using the `active` class, set `aria-expanded="true"` on the control instead. The plugin will automatically toggle this attribute based on whether or not the collapsible element has been opened or closed.

  ```html
  <ul class="metismenu" id="menu">
    <li class="active">
      <a href="#" aria-expanded="true">Menu 1</a>
      <ul>
      ...
      </ul>
    </li>
    <li>
      <a href="#" aria-expanded="false">Menu 2</a>
      <ul>
      ...
      </ul>
    </li>
    ...
    </ul>
  ```
5. Arrow Options

  > add `has-arrow` class to `a` element

  ```html
  <ul class="metismenu" id="menu">
  <li class="active">
    <a class="has-arrow" href="#" aria-expanded="true">Menu 1</a>
    <ul>
    ...
    </ul>
  </li>
  <li>
    <a class="has-arrow" href="#" aria-expanded="false">Menu 2</a>
    <ul>
    ...
    </ul>
  </li>
  ...
  </ul>
  ```

6. Call the plugin:

  ```javascript
    new MetisMenu("#menu");
  ```

### Stopping list opening on certain elements
Setting aria-disabled="true" in the `<a>` element as shown will stop metisMenu opening the menu for that particular list. This can be changed dynamically and will be obeyed correctly:

```html
<a href="#" aria-expanded="false" aria-disabled="true">List 1</a>
```

## Options

#### toggle
Type: `Boolean`
Default: `true`

For auto collapse support.

```javascript
 new MetisMenu("#menu", {
   toggle: false
 });
```

#### activeClass `deprecated`
> This option will be remove from next version.

Type: `String`
Default: `active`

```javascript
 new MetisMenu("#menu", {
   activeClass: 'active'
 });
```

#### collapseClass `deprecated`
> This option will be remove from next version.

Type: `String`
Default: `collapse`

```javascript
 new MetisMenu("#menu", {
   collapseClass: 'collapse'
 });
```

#### collapseInClass `deprecated`
> This option will be remove from next version.

Type: `String`
Default: `in`

```javascript
 new MetisMenu("#menu", {
   collapseInClass: 'in'
 });
```

#### collapsingClass `deprecated`
> This option will be remove from next version.

Type: `String`
Default: `collapsing`

```javascript
 new MetisMenu("#menu", {
   collapsingClass: 'collapsing'
 });
```

#### preventDefault *removed*
Type: `Boolean`
Default: `true`

>Prevents or allows dropdowns' onclick events after expanding/collapsing.

  ```javascript
   new MetisMenu("#menu", {
     preventDefault: false
   });
  ```

*since from version 2.7.0*

#### triggerElement
Type: `css selector`
Default: `a`

```javascript
 new MetisMenu("#menu", {
   triggerElement: '.nav-link' // bootstrap 4
 });
```

#### parentTrigger
Type: `css selector`
Default: `li`

```javascript
 new MetisMenu("#menu", {
   parentTrigger: '.nav-item' // bootstrap 4
 });
```

#### subMenu
Type: `css selector`
Default: `ul`

```javascript
 new MetisMenu("#menu", {
   subMenu: '.nav.flex-column' // bootstrap 4
 });
```

## API
#### dispose

For stop and destroy metisMenu.

```javascript
 const mm = new MetisMenu("#menu");
 mm.dispose();
```

#### update

Re-init metisMenu.

```javascript
 const mm = new MetisMenu("#menu");
 mm.dispose();
 // ajax ...
 mm.update();
```

## Events

|**Event Type**      |**Description**|
|--------------|--------------|
|show.metisMenu    |This event fires immediately when the `show` instance method is called.|
|shown.metisMenu   |This event is fired when a collapse `ul` element has been made visible to the user (will wait for CSS transitions to complete).|
|hide.metisMenu    |This event is fired immediately when the `hide` method has been called. |
|hidden.metisMenu  |This event is fired when a collapse `ul` element has been hidden from the user (will wait for CSS transitions to complete).|

## Demo
[http://mm.onokumus.com/v3](http://mm.onokumus.com/v3)

Contains a simple HTML file to demonstrate metisMenu plugin.

## About

### Related projects
- [chl](https://www.npmjs.com/package/chl): flexbox admin layout | [homepage](https://github.com/chaldene/chl#readme "flexbox admin layout")
- [elektron](https://www.npmjs.com/package/elektron): An Admin Layout | [homepage](https://github.com/onokumus/elektron#readme "An Admin Layout")
- [onoffcanvas](https://www.npmjs.com/package/onoffcanvas): An offcanvas plugin | [homepage](https://github.com/onokumus/onoffcanvas#readme "An offcanvas plugin")
- [twbuttons](https://www.npmjs.com/package/twbuttons): alexwolfe/Buttons for Twitter Bootstrap 3 | [homepage](https://github.com/onokumus/twbuttons "alexwolfe/Buttons for Twitter Bootstrap 3")

### Contributors
| **Commits** | **Contributor** |  
| --- | --- |  
| 169 | [onokumus](https://github.com/onokumus) |  
| 8   | [diegozhu](https://github.com/diegozhu) |  
| 4   | [sinabs](https://github.com/sinabs) |  
| 3   | [BurkovBA](https://github.com/BurkovBA) |  
| 2   | [arthurtalkgoal](https://github.com/arthurtalkgoal) |  
| 2   | [PeterDaveHello](https://github.com/PeterDaveHello) |  
| 2   | [kalidema](https://github.com/kalidema) |  
| 2   | [AndrewEastwood](https://github.com/AndrewEastwood) |  
| 2   | [rgnevashev](https://github.com/rgnevashev) |  
| 1   | [719media](https://github.com/719media) |  
| 1   | [chriswiggins](https://github.com/chriswiggins) |  
| 1   | [jmagnusson](https://github.com/jmagnusson) |  
| 1   | [LukasDrgon](https://github.com/LukasDrgon) |  
| 1   | [Cediddi](https://github.com/Cediddi) |  
| 1   | [capynet](https://github.com/capynet) |  

### Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Release History
|**DATE**      |**VERSION**   |**CHANGES**|
|--------------|--------------|-----------|
|2018-06-22    |v3.0.0-alpha.1|fix init functions, remove unnecessary var, fix event listener element|
|2018-06-18    |v3.0.0-alpha.0|rewritten metismenu without jquery|
|2018-06-14    |v2.7.8        |remove aria-expanded attribute & remove transitionend check|
|2018-02-14    |v2.7.4        |jQuery -> $ in src/metisMenu.js to fix import. [#158](https://github.com/onokumus/metismenu/pull/158)|
|2018-02-14    |v2.7.3        |window might not be defined in node.js environment [#156](https://github.com/onokumus/metismenu/pull/156)|
|2017-12-31    |v2.7.2        |isolate against bootstrap changes, remove old legacy ie9 code [#154](https://github.com/onokumus/metismenu/pull/154)|
|2017-10-30    |v2.7.1        |added check in complete()-callback to break when menu was disposed [#150](https://github.com/onokumus/metismenu/pull/150)|
|2017-03-08    |v2.7.0        |fixed `has-arrow` class border color & added new 3 options|
|2017-02-23    |v2.6.3        |fixed #129|
|2017-02-02    |v2.6.2        |doubleTapToGo option is deprecated|
|2016-12-06    |v2.6.1        |fix require.js|
|2016-11-29    |v2.6.0        |dispose support|
|2016-05-06    |v2.5.2        |fix Menu failed to remove collapsing class|
|2016-05-06    |v2.5.1        |fixed bootstrap conflict|
|2016-03-31    |v2.5.0        |Event support|
|2016-03-11    |v2.4.3        |create meteor package|
|2016-03-04    |v2.4.2        |back to version 2.4.0|
|2016-03-03    |v2.4.1        |<del>Transition element passed to methods</del> (removed)|
|2016-01-25    |v2.4.0        |Support AMD / Node / CommonJS|
|2016-01-08    |v2.3.0        |Adding aria-disabled=true to the link element prevents the dropdown from opening|
|2015-09-27    |v2.2.0        |Events supported & added preventDefault options|
|2015-08-06    |v2.1.0        |RTL & `aria-expanded` attribute & TypeScript type definitions support|
|2015-07-25    |v2.0.3        |When the active item has doubleTapToGo should not collapse|
|2015-05-23    |v2.0.2        |[fixed](https://github.com/onokumus/metisMenu/issues/34#issuecomment-104656754)|
|2015-05-22    |v2.0.1        |changeable classname support|
|2015-04-03    |v2.0.0        |Remove Bootstrap dependency|
|2015-03-24    |v1.1.3        |composer support|
|2014-11-01    |v1.1.3        |Bootstrap 3.3.0|
|2014-07-07    |v1.1.0	      |Add double tap functionality|
|2014-06-24    |v1.0.3	      |cdnjs support & rename plugin|
|2014-06-18    |v1.0.3        |Create grunt task|
|2014-06-10    |v1.0.2        |Fixed for IE8 & IE9|

### Author
**Osman Nuri Okumus**

+ [github/onokumus](https://github.com/onokumus)
+ [twitter/onokumus](https://twitter.com/onokumus)

### License
Copyright © 2018, [Osman Nuri Okumus](https://github.com/onokumus).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.7.0, on June 22, 2018._

[chl]: https://github.com/chaldene/chl
[elektron]: https://github.com/onokumus/elektron
[onoffcanvas]: https://github.com/onokumus/onoffcanvas
[twbuttons]: https://github.com/onokumus/twbuttons

