"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use this library to read and write *.api.json files as defined by the
 * {@link https://api-extractor.com/ | API Extractor}  tool.  These files are used to generate a documentation
 * website for your TypeScript package.  The files store the API signatures and doc comments that were extracted
 * from your package.
 *
 * @packageDocumentation
 */
var AedocDefinitions_1 = require("./aedoc/AedocDefinitions");
exports.AedocDefinitions = AedocDefinitions_1.AedocDefinitions;
var ReleaseTag_1 = require("./aedoc/ReleaseTag");
exports.ReleaseTag = ReleaseTag_1.ReleaseTag;
// items
var ApiDeclaredItem_1 = require("./items/ApiDeclaredItem");
exports.ApiDeclaredItem = ApiDeclaredItem_1.ApiDeclaredItem;
var ApiDocumentedItem_1 = require("./items/ApiDocumentedItem");
exports.ApiDocumentedItem = ApiDocumentedItem_1.ApiDocumentedItem;
var ApiItem_1 = require("./items/ApiItem");
exports.ApiItem = ApiItem_1.ApiItem;
var ApiPropertyItem_1 = require("./items/ApiPropertyItem");
exports.ApiPropertyItem = ApiPropertyItem_1.ApiPropertyItem;
// mixins
var ApiParameterListMixin_1 = require("./mixins/ApiParameterListMixin");
exports.ApiParameterListMixin = ApiParameterListMixin_1.ApiParameterListMixin;
var ApiTypeParameterListMixin_1 = require("./mixins/ApiTypeParameterListMixin");
exports.ApiTypeParameterListMixin = ApiTypeParameterListMixin_1.ApiTypeParameterListMixin;
var ApiItemContainerMixin_1 = require("./mixins/ApiItemContainerMixin");
exports.ApiItemContainerMixin = ApiItemContainerMixin_1.ApiItemContainerMixin;
var ApiReleaseTagMixin_1 = require("./mixins/ApiReleaseTagMixin");
exports.ApiReleaseTagMixin = ApiReleaseTagMixin_1.ApiReleaseTagMixin;
var ApiReturnTypeMixin_1 = require("./mixins/ApiReturnTypeMixin");
exports.ApiReturnTypeMixin = ApiReturnTypeMixin_1.ApiReturnTypeMixin;
var ApiStaticMixin_1 = require("./mixins/ApiStaticMixin");
exports.ApiStaticMixin = ApiStaticMixin_1.ApiStaticMixin;
var ApiNameMixin_1 = require("./mixins/ApiNameMixin");
exports.ApiNameMixin = ApiNameMixin_1.ApiNameMixin;
var Excerpt_1 = require("./mixins/Excerpt");
exports.ExcerptToken = Excerpt_1.ExcerptToken;
exports.Excerpt = Excerpt_1.Excerpt;
// model
var ApiCallSignature_1 = require("./model/ApiCallSignature");
exports.ApiCallSignature = ApiCallSignature_1.ApiCallSignature;
var ApiClass_1 = require("./model/ApiClass");
exports.ApiClass = ApiClass_1.ApiClass;
var ApiConstructor_1 = require("./model/ApiConstructor");
exports.ApiConstructor = ApiConstructor_1.ApiConstructor;
var ApiConstructSignature_1 = require("./model/ApiConstructSignature");
exports.ApiConstructSignature = ApiConstructSignature_1.ApiConstructSignature;
var ApiEntryPoint_1 = require("./model/ApiEntryPoint");
exports.ApiEntryPoint = ApiEntryPoint_1.ApiEntryPoint;
var ApiEnum_1 = require("./model/ApiEnum");
exports.ApiEnum = ApiEnum_1.ApiEnum;
var ApiEnumMember_1 = require("./model/ApiEnumMember");
exports.ApiEnumMember = ApiEnumMember_1.ApiEnumMember;
var ApiFunction_1 = require("./model/ApiFunction");
exports.ApiFunction = ApiFunction_1.ApiFunction;
var ApiIndexSignature_1 = require("./model/ApiIndexSignature");
exports.ApiIndexSignature = ApiIndexSignature_1.ApiIndexSignature;
var ApiInterface_1 = require("./model/ApiInterface");
exports.ApiInterface = ApiInterface_1.ApiInterface;
var ApiMethod_1 = require("./model/ApiMethod");
exports.ApiMethod = ApiMethod_1.ApiMethod;
var ApiMethodSignature_1 = require("./model/ApiMethodSignature");
exports.ApiMethodSignature = ApiMethodSignature_1.ApiMethodSignature;
var ApiModel_1 = require("./model/ApiModel");
exports.ApiModel = ApiModel_1.ApiModel;
var ApiNamespace_1 = require("./model/ApiNamespace");
exports.ApiNamespace = ApiNamespace_1.ApiNamespace;
var ApiPackage_1 = require("./model/ApiPackage");
exports.ApiPackage = ApiPackage_1.ApiPackage;
var Parameter_1 = require("./model/Parameter");
exports.Parameter = Parameter_1.Parameter;
var ApiProperty_1 = require("./model/ApiProperty");
exports.ApiProperty = ApiProperty_1.ApiProperty;
var ApiPropertySignature_1 = require("./model/ApiPropertySignature");
exports.ApiPropertySignature = ApiPropertySignature_1.ApiPropertySignature;
var ApiTypeAlias_1 = require("./model/ApiTypeAlias");
exports.ApiTypeAlias = ApiTypeAlias_1.ApiTypeAlias;
var TypeParameter_1 = require("./model/TypeParameter");
exports.TypeParameter = TypeParameter_1.TypeParameter;
var ApiVariable_1 = require("./model/ApiVariable");
exports.ApiVariable = ApiVariable_1.ApiVariable;
var HeritageType_1 = require("./model/HeritageType");
exports.HeritageType = HeritageType_1.HeritageType;
//# sourceMappingURL=index.js.map