import { DeclarationReference } from '@microsoft/tsdoc/lib/beta/DeclarationReference';
/** @public */
export declare const enum ExcerptTokenKind {
    /**
     * Generic text without any special properties
     */
    Content = "Content",
    /**
     * A reference to an API declaration
     */
    Reference = "Reference"
}
/** @public */
export interface IExcerptTokenRange {
    startIndex: number;
    endIndex: number;
}
/** @public */
export interface IExcerptToken {
    readonly kind: ExcerptTokenKind;
    text: string;
    canonicalReference?: string;
}
/** @public */
export declare class ExcerptToken {
    private readonly _kind;
    private readonly _text;
    private readonly _canonicalReference;
    constructor(kind: ExcerptTokenKind, text: string, canonicalReference?: DeclarationReference);
    readonly kind: ExcerptTokenKind;
    readonly text: string;
    readonly canonicalReference: DeclarationReference | undefined;
}
/**
 * This class is used by {@link ApiDeclaredItem} to represent a source code excerpt containing
 * a TypeScript declaration.
 *
 * @remarks
 *
 * The main excerpt is parsed into an array of tokens, and the main excerpt's token range will span all of these
 * tokens.  The declaration may also have have "captured" excerpts, which are other subranges of tokens.
 * For example, if the main excerpt is a function declaration, it will also have a captured excerpt corresponding
 * to the return type of the function.
 *
 * An excerpt may be empty (i.e. a token range containing zero tokens).  For example, if a function's return value
 * is not explicitly declared, then the returnTypeExcerpt will be empty.  By contrast, a class constructor cannot
 * have a return value, so ApiConstructor has no returnTypeExcerpt property at all.
 *
 * @public
 */
export declare class Excerpt {
    readonly tokenRange: Readonly<IExcerptTokenRange>;
    readonly tokens: ReadonlyArray<ExcerptToken>;
    private _text;
    constructor(tokens: ReadonlyArray<ExcerptToken>, tokenRange: IExcerptTokenRange);
    readonly text: string;
    readonly isEmpty: boolean;
}
//# sourceMappingURL=Excerpt.d.ts.map