"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const DeclarationReference_1 = require("@microsoft/tsdoc/lib/beta/DeclarationReference");
const ApiDeclaredItem_1 = require("../items/ApiDeclaredItem");
const ApiParameterListMixin_1 = require("../mixins/ApiParameterListMixin");
const ApiReleaseTagMixin_1 = require("../mixins/ApiReleaseTagMixin");
/**
 * Represents a TypeScript class constructor declaration that belongs to an `ApiClass`.
 *
 * @remarks
 *
 * This is part of the {@link ApiModel} hierarchy of classes, which are serializable representations of
 * API declarations.
 *
 * `ApiConstructor` represents a declaration using the `constructor` keyword such as in this example:
 *
 * ```ts
 * export class Vector {
 *   public x: number;
 *   public y: number;
 *
 *   // A class constructor:
 *   public constructor(x: number, y: number) {
 *     this.x = x;
 *     this.y = y;
 *   }
 * }
 * ```
 *
 * Compare with {@link ApiConstructSignature}, which describes the construct signature for a class constructor.
 *
 * @public
 */
class ApiConstructor extends ApiParameterListMixin_1.ApiParameterListMixin(ApiReleaseTagMixin_1.ApiReleaseTagMixin(ApiDeclaredItem_1.ApiDeclaredItem)) {
    constructor(options) {
        super(options);
    }
    static getContainerKey(overloadIndex) {
        return `|${"Constructor" /* Constructor */}|${overloadIndex}`;
    }
    /** @override */
    get kind() {
        return "Constructor" /* Constructor */;
    }
    /** @override */
    get containerKey() {
        return ApiConstructor.getContainerKey(this.overloadIndex);
    }
    /** @beta @override */
    buildCanonicalReference() {
        const parent = this.parent
            ? this.parent.canonicalReference
            // .withMeaning() requires some kind of component
            : DeclarationReference_1.DeclarationReference.empty().addNavigationStep("#" /* Members */, '(parent)');
        return parent
            .withMeaning("constructor" /* Constructor */)
            .withOverloadIndex(this.overloadIndex);
    }
}
exports.ApiConstructor = ApiConstructor;
//# sourceMappingURL=ApiConstructor.js.map