"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
class TypeScriptMessageFormatter {
    /**
     * Returns a string such as this, based on the context information in the provided node:
     *   "[C:\Folder\File.ts#123]"
     */
    static formatFileAndLineNumber(node) {
        const sourceFile = node.getSourceFile();
        const lineAndCharacter = sourceFile.getLineAndCharacterOfPosition(node.getStart());
        return `[${sourceFile.fileName}#${lineAndCharacter.line}]`;
    }
}
exports.TypeScriptMessageFormatter = TypeScriptMessageFormatter;
//# sourceMappingURL=TypeScriptMessageFormatter.js.map