"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const colors = require("colors");
const path = require("path");
const node_core_library_1 = require("@rushstack/node-core-library");
const ts_command_line_1 = require("@rushstack/ts-command-line");
const ExtractorConfig_1 = require("../api/ExtractorConfig");
class InitAction extends ts_command_line_1.CommandLineAction {
    constructor(parser) {
        super({
            actionName: 'init',
            summary: `Create an ${ExtractorConfig_1.ExtractorConfig.FILENAME} config file`,
            documentation: `Use this command when setting up API Extractor for a new project.  It writes an`
                + ` ${ExtractorConfig_1.ExtractorConfig.FILENAME} config file template with code comments that describe all the settings.`
                + ` The file will be written in the current directory.`
        });
    }
    onDefineParameters() {
        // No parameters yet
    }
    onExecute() {
        const inputFilePath = path.resolve(__dirname, '../schemas/api-extractor-template.json');
        const outputFilePath = path.resolve(ExtractorConfig_1.ExtractorConfig.FILENAME);
        if (node_core_library_1.FileSystem.exists(outputFilePath)) {
            console.log(colors.red('The output file already exists:'));
            console.log('\n  ' + outputFilePath + '\n');
            throw new Error('Unable to write output file');
        }
        console.log(colors.green('Writing file: ') + outputFilePath);
        node_core_library_1.FileSystem.copyFile({
            sourcePath: inputFilePath,
            destinationPath: outputFilePath
        });
        console.log('\nThe recommended location for this file is in the project\'s "config" subfolder,\n'
            + 'or else in the top-level folder with package.json.');
        return Promise.resolve();
    }
}
exports.InitAction = InitAction;
//# sourceMappingURL=InitAction.js.map