"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const ts = require("typescript");
const node_core_library_1 = require("@rushstack/node-core-library");
const AstImport_1 = require("../analyzer/AstImport");
/**
 * Some common code shared between DtsRollupGenerator and ApiReportGenerator.
 */
class DtsEmitHelpers {
    static emitImport(stringWriter, collectorEntity, astImport) {
        switch (astImport.importKind) {
            case AstImport_1.AstImportKind.DefaultImport:
                stringWriter.writeLine(`import ${astImport.exportName} from '${astImport.modulePath}';`);
                break;
            case AstImport_1.AstImportKind.NamedImport:
                if (collectorEntity.nameForEmit !== astImport.exportName) {
                    stringWriter.write(`import { ${astImport.exportName} as ${collectorEntity.nameForEmit} }`);
                }
                else {
                    stringWriter.write(`import { ${astImport.exportName} }`);
                }
                stringWriter.writeLine(` from '${astImport.modulePath}';`);
                break;
            case AstImport_1.AstImportKind.StarImport:
                stringWriter.writeLine(`import * as ${collectorEntity.nameForEmit} from '${astImport.modulePath}';`);
                break;
            case AstImport_1.AstImportKind.EqualsImport:
                stringWriter.writeLine(`import ${collectorEntity.nameForEmit} = require('${astImport.modulePath}');`);
                break;
            default:
                throw new node_core_library_1.InternalError('Unimplemented AstImportKind');
        }
    }
    static emitNamedExport(stringWriter, exportName, collectorEntity) {
        if (exportName === ts.InternalSymbolName.Default) {
            stringWriter.writeLine(`export default ${collectorEntity.nameForEmit};`);
        }
        else if (collectorEntity.nameForEmit !== exportName) {
            stringWriter.writeLine(`export { ${collectorEntity.nameForEmit} as ${exportName} }`);
        }
        else {
            stringWriter.writeLine(`export { ${exportName} }`);
        }
    }
    static emitStarExports(stringWriter, collector) {
        if (collector.starExportedExternalModulePaths.length > 0) {
            stringWriter.writeLine();
            for (const starExportedExternalModulePath of collector.starExportedExternalModulePaths) {
                stringWriter.writeLine(`export * from "${starExportedExternalModulePath}";`);
            }
        }
    }
}
exports.DtsEmitHelpers = DtsEmitHelpers;
//# sourceMappingURL=DtsEmitHelpers.js.map