"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
const os = require("os");
const colors = require("colors");
const ApiExtractorCommandLine_1 = require("./cli/ApiExtractorCommandLine");
const Extractor_1 = require("./api/Extractor");
console.log(os.EOL + colors.bold(`api-extractor ${Extractor_1.Extractor.version} `
    + colors.cyan(' - https://api-extractor.com/') + os.EOL));
const parser = new ApiExtractorCommandLine_1.ApiExtractorCommandLine();
parser.execute().catch((error) => {
    console.error(colors.red(`An unexpected error occurred: ${error}`));
    process.exit(1);
});
//# sourceMappingURL=start.js.map