/*
 * Application Insights JavaScript SDK - Web, 2.8.17
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
import { _legacyCookieMgr } from "@microsoft/applicationinsights-core-js";
import { AppInsightsDeprecated } from "./ApplicationInsightsDeprecated";
import { Initialization as ApplicationInsights } from "./Initialization";
import { _DYN_LOAD_APP_INSIGHTS, _DYN_UPDATE_SNIPPET_DEFIN0 } from "./__DynamicConstants";
var ApplicationInsightsContainer = /** @class */ (function () {
    function ApplicationInsightsContainer() {
    }
    ApplicationInsightsContainer.getAppInsights = function (snippet, version) {
        var initialization = new ApplicationInsights(snippet);
        var legacyMode = version >= 2 ? false : true;
        // Side effect is to create, initialize and listen to the CoreUtils._canUseCookies changes
        // Called here to support backward compatibility
        _legacyCookieMgr();
        // Two target scenarios:
        // 1. Customer runs v1 snippet + runtime. If customer updates just cdn location to new SDK, it will run in compat mode so old apis work
        // 2. Customer updates to new snippet (that uses cdn location to new SDK. This is same as a new customer onboarding
        // and all api signatures are expected to map to new SDK. Note new snippet specifies version
        if (!legacyMode) {
            initialization[_DYN_UPDATE_SNIPPET_DEFIN0 /* @min:%2eupdateSnippetDefinitions */](snippet);
            initialization[_DYN_LOAD_APP_INSIGHTS /* @min:%2eloadAppInsights */](legacyMode);
            return initialization; // default behavior with new snippet
        }
        else {
            var legacy = new AppInsightsDeprecated(snippet, initialization); // target scenario old snippet + updated endpoint
            legacy[_DYN_UPDATE_SNIPPET_DEFIN0 /* @min:%2eupdateSnippetDefinitions */](snippet);
            initialization[_DYN_LOAD_APP_INSIGHTS /* @min:%2eloadAppInsights */](legacyMode);
            return legacy;
        }
    };
    return ApplicationInsightsContainer;
}());
export { ApplicationInsightsContainer };
//# sourceMappingURL=ApplicationInsightsContainer.js.map