/*
 * Application Insights JavaScript SDK - Web, 2.8.17
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
import dynamicProto from "@microsoft/dynamicproto-js";
import { DEFAULT_BREEZE_ENDPOINT, DEFAULT_BREEZE_PATH, ProcessLegacy, stringToBoolOrDefault } from "@microsoft/applicationinsights-common";
import { arrIndexOf, isFunction, proxyAssign, proxyFunctions, throwError } from "@microsoft/applicationinsights-core-js";
import { DfltAjaxCorrelationHeaderExDomains } from "@microsoft/applicationinsights-dependencies-js";
import { STR_ADD_TELEMETRY_INITIALIZER, STR_ADD_TELEMETRY_INITIALIZERS, STR_CLEAR_AUTHENTICATED_USER_CONTEXT, STR_FLUSH, STR_GET_COOKIE_MGR, STR_SET_AUTHENTICATED_USER_CONTEXT, STR_SNIPPET, STR_START_TRACK_EVENT, STR_START_TRACK_PAGE, STR_STOP_TRACK_EVENT, STR_STOP_TRACK_PAGE, STR_TRACK_DEPENDENCY_DATA, STR_TRACK_EVENT, STR_TRACK_EXCEPTION, STR_TRACK_METRIC, STR_TRACK_PAGE_VIEW, STR_TRACK_TRACE } from "./InternalConstants";
import { _DYN_AUTO_TRACK_PAGE_VISI5, _DYN_CONFIG, _DYN_CONTEXT, _DYN_CORRELATION_HEADER_E10, _DYN_DIAGNOSTIC_LOG_INTER4, _DYN_DISABLE_AJAX_TRACKIN6, _DYN_DISABLE_CORRELATION_9, _DYN_DISABLE_EXCEPTION_TR2, _DYN_DISABLE_FLUSH_ON_BEF11, _DYN_DISABLE_TELEMETRY, _DYN_EMIT_LINE_DELIMITED_3, _DYN_ENABLE_CORS_CORRELAT17, _DYN_ENABLE_SESSION_STORA13, _DYN_ENDPOINT_URL, _DYN_IS_BEACON_API_DISABL8, _DYN_IS_BROWSER_LINK_TRAC16, _DYN_IS_COOKIE_USE_DISABL14, _DYN_IS_STORAGE_USE_DISAB15, _DYN_LOAD_APP_INSIGHTS, _DYN_MAX_AJAX_CALLS_PER_V7, _DYN_MAX_BATCH_INTERVAL, _DYN_MAX_BATCH_SIZE_IN_BY1, _DYN_PUSH, _DYN_QUEUE, _DYN_SAMPLING_PERCENTAGE, _DYN_UPDATE_SNIPPET_DEFIN0 } from "./__DynamicConstants";
// This is an exclude list of properties that should not be updated during initialization
// They include a combination of private and internal property names
var _ignoreUpdateSnippetProperties = [
    STR_SNIPPET, "getDefaultConfig", "_hasLegacyInitializers", "_queue", "_processLegacyInitializers"
];
function getDefaultConfig(config) {
    if (!config) {
        config = {};
    }
    // set default values
    config[_DYN_ENDPOINT_URL /* @min:%2eendpointUrl */] = config[_DYN_ENDPOINT_URL /* @min:%2eendpointUrl */] || DEFAULT_BREEZE_ENDPOINT + DEFAULT_BREEZE_PATH;
    config.sessionRenewalMs = 30 * 60 * 1000;
    config.sessionExpirationMs = 24 * 60 * 60 * 1000;
    config[_DYN_MAX_BATCH_SIZE_IN_BY1 /* @min:%2emaxBatchSizeInBytes */] = config[_DYN_MAX_BATCH_SIZE_IN_BY1 /* @min:%2emaxBatchSizeInBytes */] > 0 ? config[_DYN_MAX_BATCH_SIZE_IN_BY1 /* @min:%2emaxBatchSizeInBytes */] : 102400; // 100kb
    config[_DYN_MAX_BATCH_INTERVAL /* @min:%2emaxBatchInterval */] = !isNaN(config[_DYN_MAX_BATCH_INTERVAL /* @min:%2emaxBatchInterval */]) ? config[_DYN_MAX_BATCH_INTERVAL /* @min:%2emaxBatchInterval */] : 15000;
    config.enableDebug = stringToBoolOrDefault(config.enableDebug);
    config[_DYN_DISABLE_EXCEPTION_TR2 /* @min:%2edisableExceptionTracking */] = stringToBoolOrDefault(config[_DYN_DISABLE_EXCEPTION_TR2 /* @min:%2edisableExceptionTracking */]);
    config[_DYN_DISABLE_TELEMETRY /* @min:%2edisableTelemetry */] = stringToBoolOrDefault(config[_DYN_DISABLE_TELEMETRY /* @min:%2edisableTelemetry */]);
    config.verboseLogging = stringToBoolOrDefault(config.verboseLogging);
    config[_DYN_EMIT_LINE_DELIMITED_3 /* @min:%2eemitLineDelimitedJson */] = stringToBoolOrDefault(config[_DYN_EMIT_LINE_DELIMITED_3 /* @min:%2eemitLineDelimitedJson */]);
    config[_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] = config[_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] || 10000;
    config[_DYN_AUTO_TRACK_PAGE_VISI5 /* @min:%2eautoTrackPageVisitTime */] = stringToBoolOrDefault(config[_DYN_AUTO_TRACK_PAGE_VISI5 /* @min:%2eautoTrackPageVisitTime */]);
    if (isNaN(config[_DYN_SAMPLING_PERCENTAGE /* @min:%2esamplingPercentage */]) || config[_DYN_SAMPLING_PERCENTAGE /* @min:%2esamplingPercentage */] <= 0 || config[_DYN_SAMPLING_PERCENTAGE /* @min:%2esamplingPercentage */] >= 100) {
        config[_DYN_SAMPLING_PERCENTAGE /* @min:%2esamplingPercentage */] = 100;
    }
    config[_DYN_DISABLE_AJAX_TRACKIN6 /* @min:%2edisableAjaxTracking */] = stringToBoolOrDefault(config[_DYN_DISABLE_AJAX_TRACKIN6 /* @min:%2edisableAjaxTracking */]);
    config[_DYN_MAX_AJAX_CALLS_PER_V7 /* @min:%2emaxAjaxCallsPerView */] = !isNaN(config[_DYN_MAX_AJAX_CALLS_PER_V7 /* @min:%2emaxAjaxCallsPerView */]) ? config[_DYN_MAX_AJAX_CALLS_PER_V7 /* @min:%2emaxAjaxCallsPerView */] : 500;
    config[_DYN_IS_BEACON_API_DISABL8 /* @min:%2eisBeaconApiDisabled */] = stringToBoolOrDefault(config[_DYN_IS_BEACON_API_DISABL8 /* @min:%2eisBeaconApiDisabled */], true);
    config[_DYN_DISABLE_CORRELATION_9 /* @min:%2edisableCorrelationHeaders */] = stringToBoolOrDefault(config[_DYN_DISABLE_CORRELATION_9 /* @min:%2edisableCorrelationHeaders */]);
    config[_DYN_CORRELATION_HEADER_E10 /* @min:%2ecorrelationHeaderExcludedDomains */] = config[_DYN_CORRELATION_HEADER_E10 /* @min:%2ecorrelationHeaderExcludedDomains */] || DfltAjaxCorrelationHeaderExDomains;
    config[_DYN_DISABLE_FLUSH_ON_BEF11 /* @min:%2edisableFlushOnBeforeUnload */] = stringToBoolOrDefault(config[_DYN_DISABLE_FLUSH_ON_BEF11 /* @min:%2edisableFlushOnBeforeUnload */]);
    config.disableFlushOnUnload = stringToBoolOrDefault(config.disableFlushOnUnload, config[_DYN_DISABLE_FLUSH_ON_BEF11 /* @min:%2edisableFlushOnBeforeUnload */]);
    config[_DYN_ENABLE_SESSION_STORA13 /* @min:%2eenableSessionStorageBuffer */] = stringToBoolOrDefault(config[_DYN_ENABLE_SESSION_STORA13 /* @min:%2eenableSessionStorageBuffer */], true);
    config.isRetryDisabled = stringToBoolOrDefault(config.isRetryDisabled);
    config[_DYN_IS_COOKIE_USE_DISABL14 /* @min:%2eisCookieUseDisabled */] = stringToBoolOrDefault(config[_DYN_IS_COOKIE_USE_DISABL14 /* @min:%2eisCookieUseDisabled */]);
    config[_DYN_IS_STORAGE_USE_DISAB15 /* @min:%2eisStorageUseDisabled */] = stringToBoolOrDefault(config[_DYN_IS_STORAGE_USE_DISAB15 /* @min:%2eisStorageUseDisabled */]);
    config[_DYN_IS_BROWSER_LINK_TRAC16 /* @min:%2eisBrowserLinkTrackingEnabled */] = stringToBoolOrDefault(config[_DYN_IS_BROWSER_LINK_TRAC16 /* @min:%2eisBrowserLinkTrackingEnabled */]);
    config[_DYN_ENABLE_CORS_CORRELAT17 /* @min:%2eenableCorsCorrelation */] = stringToBoolOrDefault(config[_DYN_ENABLE_CORS_CORRELAT17 /* @min:%2eenableCorsCorrelation */]);
    return config;
}
var AppInsightsDeprecated = /** @class */ (function () {
    function AppInsightsDeprecated(snippet, appInsightsNew) {
        var _this = this;
        var _hasLegacyInitializers = false;
        var _queue = [];
        var _config;
        dynamicProto(AppInsightsDeprecated, this, function (_self) {
            _config = getDefaultConfig(snippet[_DYN_CONFIG /* @min:%2econfig */]);
            _self[_DYN_CONFIG /* @min:%2econfig */] = _config;
            _self[STR_SNIPPET /* @min:%2esnippet */] = snippet;
            _self.appInsightsNew = appInsightsNew;
            _self[_DYN_CONTEXT /* @min:%2econtext */] = { addTelemetryInitializer: _addTelemetryInitializers.bind(_self) };
            _self[STR_ADD_TELEMETRY_INITIALIZERS /* @min:%2eaddTelemetryInitializers */] = _addTelemetryInitializers;
            function _addTelemetryInitializers(callBack) {
                // Add initializer to current processing only if there is any old telemetry initializer
                if (!_hasLegacyInitializers) {
                    appInsightsNew[STR_ADD_TELEMETRY_INITIALIZER /* @min:%2eaddTelemetryInitializer */](function (item) {
                        _processLegacyInitializers(item); // setup call back for each legacy processor
                    });
                    _hasLegacyInitializers = true;
                }
                _queue[_DYN_PUSH /* @min:%2epush */](callBack);
            }
            proxyFunctions(_self, appInsightsNew, [
                STR_GET_COOKIE_MGR,
                STR_START_TRACK_PAGE,
                STR_STOP_TRACK_PAGE,
                STR_FLUSH,
                STR_START_TRACK_EVENT,
                STR_STOP_TRACK_EVENT
            ]);
            _self[STR_TRACK_PAGE_VIEW /* @min:%2etrackPageView */] = function (name, url, properties, measurements, duration) {
                var telemetry = {
                    name: name,
                    uri: url,
                    properties: properties,
                    measurements: measurements
                };
                // fix for props, measurements, duration
                appInsightsNew[STR_TRACK_PAGE_VIEW /* @min:%2etrackPageView */](telemetry);
            };
            _self[STR_TRACK_EVENT /* @min:%2etrackEvent */] = function (name, properties, measurements) {
                appInsightsNew[STR_TRACK_EVENT /* @min:%2etrackEvent */]({ name: name });
            };
            _self.trackDependency = function (id, method, absoluteUrl, pathName, totalTime, success, resultCode) {
                appInsightsNew[STR_TRACK_DEPENDENCY_DATA /* @min:%2etrackDependencyData */]({
                    id: id,
                    target: absoluteUrl,
                    type: pathName,
                    duration: totalTime,
                    properties: { HttpMethod: method },
                    success: success,
                    responseCode: resultCode
                });
            };
            _self[STR_TRACK_EXCEPTION /* @min:%2etrackException */] = function (exception, handledAt, properties, measurements, severityLevel) {
                appInsightsNew[STR_TRACK_EXCEPTION /* @min:%2etrackException */]({
                    exception: exception
                });
            };
            _self[STR_TRACK_METRIC /* @min:%2etrackMetric */] = function (name, average, sampleCount, min, max, properties) {
                appInsightsNew[STR_TRACK_METRIC /* @min:%2etrackMetric */]({ name: name, average: average, sampleCount: sampleCount, min: min, max: max });
            };
            _self[STR_TRACK_TRACE /* @min:%2etrackTrace */] = function (message, properties, severityLevel) {
                appInsightsNew[STR_TRACK_TRACE /* @min:%2etrackTrace */]({ message: message, severityLevel: severityLevel });
            };
            _self[STR_SET_AUTHENTICATED_USER_CONTEXT /* @min:%2esetAuthenticatedUserContext */] = function (authenticatedUserId, accountId, storeInCookie) {
                appInsightsNew[_DYN_CONTEXT /* @min:%2econtext */].user[STR_SET_AUTHENTICATED_USER_CONTEXT /* @min:%2esetAuthenticatedUserContext */](authenticatedUserId, accountId, storeInCookie);
            };
            _self[STR_CLEAR_AUTHENTICATED_USER_CONTEXT /* @min:%2eclearAuthenticatedUserContext */] = function () {
                appInsightsNew[_DYN_CONTEXT /* @min:%2econtext */].user[STR_CLEAR_AUTHENTICATED_USER_CONTEXT /* @min:%2eclearAuthenticatedUserContext */]();
            };
            _self._onerror = function (message, url, lineNumber, columnNumber, error) {
                appInsightsNew._onerror({ message: message, url: url, lineNumber: lineNumber, columnNumber: columnNumber, error: error });
            };
            _self.downloadAndSetup = function (config) {
                throwError("downloadAndSetup not implemented in web SKU");
            };
            _self[_DYN_UPDATE_SNIPPET_DEFIN0 /* @min:%2eupdateSnippetDefinitions */] = function (snippet) {
                // apply full appInsights to the global instance
                // Note: This must be called before loadAppInsights is called
                proxyAssign(snippet, _this, function (name) {
                    // Not excluding names prefixed with "_" as we need to proxy some functions like _onError
                    return name && arrIndexOf(_ignoreUpdateSnippetProperties, name) === -1;
                });
            };
            // note: these are split into methods to enable unit tests
            _self[_DYN_LOAD_APP_INSIGHTS /* @min:%2eloadAppInsights */] = function () {
                // initialize global instance of appInsights
                // var appInsights = new Microsoft.ApplicationInsights.AppInsights(_self.config);
                // implement legacy version of trackPageView for 0.10<
                if (_self[_DYN_CONFIG /* @min:%2econfig */]["iKey"]) {
                    var originalTrackPageView_1 = _self[STR_TRACK_PAGE_VIEW /* @min:%2etrackPageView */];
                    _self[STR_TRACK_PAGE_VIEW /* @min:%2etrackPageView */] = function (pagePath, properties, measurements) {
                        originalTrackPageView_1.apply(_self, [null, pagePath, properties, measurements]);
                    };
                }
                // implement legacy pageView interface if it is present in the snippet
                var legacyPageView = "logPageView";
                if (isFunction(_self[STR_SNIPPET /* @min:%2esnippet */][legacyPageView])) {
                    _this[legacyPageView] = function (pagePath, properties, measurements) {
                        _self[STR_TRACK_PAGE_VIEW /* @min:%2etrackPageView */](null, pagePath, properties, measurements);
                    };
                }
                // implement legacy event interface if it is present in the snippet
                var legacyEvent = "logEvent";
                if (isFunction(_self[STR_SNIPPET /* @min:%2esnippet */][legacyEvent])) {
                    _this[legacyEvent] = function (name, props, measurements) {
                        _self[STR_TRACK_EVENT /* @min:%2etrackEvent */](name, props, measurements);
                    };
                }
                return _this;
            };
            function _processLegacyInitializers(item) {
                // instead of mapping new to legacy and then back again and repeating in channel, attach callback for channel to call
                item.tags[ProcessLegacy] = _queue;
                return item;
            }
        });
    }
// Removed Stub for AppInsightsDeprecated.prototype.addTelemetryInitializers.
// Removed Stub for AppInsightsDeprecated.prototype.getCookieMgr.
// Removed Stub for AppInsightsDeprecated.prototype.startTrackPage.
// Removed Stub for AppInsightsDeprecated.prototype.stopTrackPage.
// Removed Stub for AppInsightsDeprecated.prototype.trackPageView.
// Removed Stub for AppInsightsDeprecated.prototype.trackEvent.
// Removed Stub for AppInsightsDeprecated.prototype.trackDependency.
// Removed Stub for AppInsightsDeprecated.prototype.trackException.
// Removed Stub for AppInsightsDeprecated.prototype.trackMetric.
// Removed Stub for AppInsightsDeprecated.prototype.trackTrace.
// Removed Stub for AppInsightsDeprecated.prototype.flush.
// Removed Stub for AppInsightsDeprecated.prototype.setAuthenticatedUserContext.
// Removed Stub for AppInsightsDeprecated.prototype.clearAuthenticatedUserContext.
// Removed Stub for AppInsightsDeprecated.prototype._onerror.
// Removed Stub for AppInsightsDeprecated.prototype.startTrackEvent.
// Removed Stub for AppInsightsDeprecated.prototype.stopTrackEvent.
// Removed Stub for AppInsightsDeprecated.prototype.downloadAndSetup.
// Removed Stub for AppInsightsDeprecated.prototype.updateSnippetDefinitions.
    // note: these are split into methods to enable unit tests
// Removed Stub for AppInsightsDeprecated.prototype.loadAppInsights.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    AppInsightsDeprecated.__ieDyn=1;

    return AppInsightsDeprecated;
}());
export { AppInsightsDeprecated };
//# sourceMappingURL=ApplicationInsightsDeprecated.js.map