/*
 * Application Insights JavaScript SDK - Web, 2.8.17
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


"use strict";
import dynamicProto from "@microsoft/dynamicproto-js";
import { AnalyticsPlugin } from "@microsoft/applicationinsights-analytics-js";
import { Sender } from "@microsoft/applicationinsights-channel-js";
import { AnalyticsPluginIdentifier, BreezeChannelIdentifier, ConfigurationManager, ConnectionStringParser, ContextTagKeys, CorrelationIdHelper, CtxTagKeys, DEFAULT_BREEZE_ENDPOINT, DEFAULT_BREEZE_PATH, Data, DataSanitizer, DateTimeUtils, DisabledPropertyName, DistributedTracingModes, Envelope, Event, Exception, Extensions, HttpMethod, Metric, PageView, PageViewPerformance, ProcessLegacy, PropertiesPluginIdentifier, RemoteDependencyData, RequestHeaders, SampleRate, SeverityLevel, TelemetryItemCreator, Trace, UrlHelper, Util, parseConnectionString } from "@microsoft/applicationinsights-common";
import { AppInsightsCore, _throwInternal, addPageHideEventListener, addPageUnloadEventListener, arrForEach, arrIndexOf, createUniqueNamespace, doPerf, hasDocument, hasWindow, isArray, isFunction, isNullOrUndefined, isReactNative, isString, mergeEvtNamespace, objForEachKey, proxyAssign, proxyFunctions, removePageHideEventListener, removePageUnloadEventListener, throwError } from "@microsoft/applicationinsights-core-js";
import { AjaxPlugin as DependenciesPlugin } from "@microsoft/applicationinsights-dependencies-js";
import { PropertiesPlugin } from "@microsoft/applicationinsights-properties-js";
import { STR_ADD_TELEMETRY_INITIALIZER, STR_CLEAR_AUTHENTICATED_USER_CONTEXT, STR_EVT_NAMESPACE, STR_FLUSH, STR_GET_COOKIE_MGR, STR_GET_PLUGIN, STR_POLL_INTERNAL_LOGS, STR_SET_AUTHENTICATED_USER_CONTEXT, STR_SNIPPET, STR_START_TRACK_EVENT, STR_START_TRACK_PAGE, STR_STOP_TRACK_EVENT, STR_STOP_TRACK_PAGE, STR_TRACK_DEPENDENCY_DATA, STR_TRACK_EVENT, STR_TRACK_EXCEPTION, STR_TRACK_METRIC, STR_TRACK_PAGE_VIEW, STR_TRACK_TRACE } from "./InternalConstants";
import { _DYN_ADD_HOUSEKEEPING_BEF20, _DYN_APP_INSIGHTS, _DYN_CONFIG, _DYN_CONNECTION_STRING, _DYN_CONTEXT, _DYN_DIAGNOSTIC_LOG_INTER4, _DYN_DISABLE_FLUSH_ON_BEF11, _DYN_DISABLE_FLUSH_ON_UNL12, _DYN_DISABLE_IKEY_DEPRECA18, _DYN_ENDPOINT_URL, _DYN_GET_TRANSMISSION_CON19, _DYN_INDEX_OF, _DYN_INSTRUMENTATION_KEY, _DYN_LOAD_APP_INSIGHTS, _DYN_ONUNLOAD_FLUSH, _DYN_PUSH, _DYN_QUEUE, _DYN_UPDATE_SNIPPET_DEFIN0, _DYN_VERSION } from "./__DynamicConstants";
var _internalSdkSrc;
// This is an exclude list of properties that should not be updated during initialization
// They include a combination of private and internal property names
var _ignoreUpdateSnippetProperties = [
    STR_SNIPPET, "dependencies", "properties", "_snippetVersion", "appInsightsNew", "getSKUDefaults"
];
// Re-exposing the Common classes as Telemetry, the list was taken by reviewing the generated code for the build while using
// the previous configuration :-
// import * as Common from "@microsoft/applicationinsights-common"
// export const Telemetry = Common;
var fieldType = {
    Default: 0 /* FieldType.Default */,
    Required: 1 /* FieldType.Required */,
    Array: 2 /* FieldType.Array */,
    Hidden: 4 /* FieldType.Hidden */
};
/**
 * Telemetry type classes, e.g. PageView, Exception, etc
 */
export var Telemetry = {
    __proto__: null,
    PropertiesPluginIdentifier: PropertiesPluginIdentifier,
    BreezeChannelIdentifier: BreezeChannelIdentifier,
    AnalyticsPluginIdentifier: AnalyticsPluginIdentifier,
    Util: Util,
    CorrelationIdHelper: CorrelationIdHelper,
    UrlHelper: UrlHelper,
    DateTimeUtils: DateTimeUtils,
    ConnectionStringParser: ConnectionStringParser,
    FieldType: fieldType,
    RequestHeaders: RequestHeaders,
    DisabledPropertyName: DisabledPropertyName,
    ProcessLegacy: ProcessLegacy,
    SampleRate: SampleRate,
    HttpMethod: HttpMethod,
    DEFAULT_BREEZE_ENDPOINT: DEFAULT_BREEZE_ENDPOINT,
    Envelope: Envelope,
    Event: Event,
    Exception: Exception,
    Metric: Metric,
    PageView: PageView,
    RemoteDependencyData: RemoteDependencyData,
    Trace: Trace,
    PageViewPerformance: PageViewPerformance,
    Data: Data,
    SeverityLevel: SeverityLevel,
    ConfigurationManager: ConfigurationManager,
    ContextTagKeys: ContextTagKeys,
    DataSanitizer: DataSanitizer,
    TelemetryItemCreator: TelemetryItemCreator,
    CtxTagKeys: CtxTagKeys,
    Extensions: Extensions,
    DistributedTracingModes: DistributedTracingModes
};
/**
 * Application Insights API
 * @class Initialization
 * @implements {IApplicationInsights}
 */
var Initialization = /** @class */ (function () {
    function Initialization(snippet) {
        var _this = this;
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var dependencies;
        var properties;
        var _sender;
        var _snippetVersion;
        var _evtNamespace;
        var _houseKeepingNamespace;
        var _core;
        dynamicProto(Initialization, this, function (_self) {
            _initDefaults();
            // initialize the queue and config in case they are undefined
            _snippetVersion = "" + (snippet.sv || snippet[_DYN_VERSION /* @min:%2eversion */] || "");
            snippet[_DYN_QUEUE /* @min:%2equeue */] = snippet[_DYN_QUEUE /* @min:%2equeue */] || [];
            snippet[_DYN_VERSION /* @min:%2eversion */] = snippet[_DYN_VERSION /* @min:%2eversion */] || 2.0; // Default to new version
            var config = snippet[_DYN_CONFIG /* @min:%2econfig */] || {};
            if (config[_DYN_CONNECTION_STRING /* @min:%2econnectionString */]) {
                var cs = parseConnectionString(config[_DYN_CONNECTION_STRING /* @min:%2econnectionString */]);
                var ingest = cs.ingestionendpoint;
                config[_DYN_ENDPOINT_URL /* @min:%2eendpointUrl */] = ingest ? (ingest + DEFAULT_BREEZE_PATH) : config[_DYN_ENDPOINT_URL /* @min:%2eendpointUrl */]; // only add /v2/track when from connectionstring
                config[_DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */] = cs.instrumentationkey || config[_DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */];
            }
            _self[_DYN_APP_INSIGHTS /* @min:%2eappInsights */] = new AnalyticsPlugin();
            properties = new PropertiesPlugin();
            dependencies = new DependenciesPlugin();
            _sender = new Sender();
            _core = new AppInsightsCore();
            _self.core = _core;
            var isErrMessageDisabled = isNullOrUndefined(config[_DYN_DISABLE_IKEY_DEPRECA18 /* @min:%2edisableIkeyDeprecationMessage */]) ? true : config[_DYN_DISABLE_IKEY_DEPRECA18 /* @min:%2edisableIkeyDeprecationMessage */];
            if (!config[_DYN_CONNECTION_STRING /* @min:%2econnectionString */] && !isErrMessageDisabled) {
                _throwInternal(_core.logger, 1 /* eLoggingSeverity.CRITICAL */, 106 /* _eInternalMessageId.InstrumentationKeyDeprecation */, "Instrumentation key support will end soon, see aka.ms/IkeyMigrate");
            }
            _self[STR_SNIPPET /* @min:%2esnippet */] = snippet;
            _self[_DYN_CONFIG /* @min:%2econfig */] = config;
            _getSKUDefaults();
            _self[STR_FLUSH /* @min:%2eflush */] = function (async) {
                if (async === void 0) { async = true; }
                doPerf(_core, function () { return "AISKU.flush"; }, function () {
                    arrForEach(_core[_DYN_GET_TRANSMISSION_CON19 /* @min:%2egetTransmissionControls */](), function (channels) {
                        arrForEach(channels, function (channel) {
                            channel[STR_FLUSH /* @min:%2eflush */](async);
                        });
                    });
                }, null, async);
            };
            _self[_DYN_ONUNLOAD_FLUSH /* @min:%2eonunloadFlush */] = function (async) {
                if (async === void 0) { async = true; }
                arrForEach(_core[_DYN_GET_TRANSMISSION_CON19 /* @min:%2egetTransmissionControls */](), function (channels) {
                    arrForEach(channels, function (channel) {
                        if (channel[_DYN_ONUNLOAD_FLUSH /* @min:%2eonunloadFlush */]) {
                            channel[_DYN_ONUNLOAD_FLUSH /* @min:%2eonunloadFlush */]();
                        }
                        else {
                            channel[STR_FLUSH /* @min:%2eflush */](async);
                        }
                    });
                });
            };
            _self[_DYN_LOAD_APP_INSIGHTS /* @min:%2eloadAppInsights */] = function (legacyMode, logger, notificationManager) {
                if (legacyMode === void 0) { legacyMode = false; }
                function _updateSnippetProperties(snippet) {
                    if (snippet) {
                        var snippetVer = "";
                        if (!isNullOrUndefined(_snippetVersion)) {
                            snippetVer += _snippetVersion;
                        }
                        if (legacyMode) {
                            snippetVer += ".lg";
                        }
                        if (_self[_DYN_CONTEXT /* @min:%2econtext */] && _self[_DYN_CONTEXT /* @min:%2econtext */].internal) {
                            _self[_DYN_CONTEXT /* @min:%2econtext */].internal.snippetVer = snippetVer || "-";
                        }
                        // apply updated properties to the global instance (snippet)
                        objForEachKey(_self, function (field, value) {
                            if (isString(field) &&
                                !isFunction(value) &&
                                field && field[0] !== "_" && // Don't copy "internal" values
                                arrIndexOf(_ignoreUpdateSnippetProperties, field) === -1) {
                                snippet[field] = value;
                            }
                        });
                    }
                }
                // dont allow additional channels/other extensions for legacy mode; legacy mode is only to allow users to switch with no code changes!
                if (legacyMode && _self[_DYN_CONFIG /* @min:%2econfig */].extensions && _self[_DYN_CONFIG /* @min:%2econfig */].extensions.length > 0) {
                    throwError("Extensions not allowed in legacy mode");
                }
                doPerf(_self.core, function () { return "AISKU.loadAppInsights"; }, function () {
                    var extensions = [];
                    extensions[_DYN_PUSH /* @min:%2epush */](_sender);
                    extensions[_DYN_PUSH /* @min:%2epush */](properties);
                    extensions[_DYN_PUSH /* @min:%2epush */](dependencies);
                    extensions[_DYN_PUSH /* @min:%2epush */](_self[_DYN_APP_INSIGHTS /* @min:%2eappInsights */]);
                    // initialize core
                    _core.initialize(_self[_DYN_CONFIG /* @min:%2econfig */], extensions, logger, notificationManager);
                    _self[_DYN_CONTEXT /* @min:%2econtext */] = properties[_DYN_CONTEXT /* @min:%2econtext */];
                    if (_internalSdkSrc && _self[_DYN_CONTEXT /* @min:%2econtext */]) {
                        _self[_DYN_CONTEXT /* @min:%2econtext */].internal.sdkSrc = _internalSdkSrc;
                    }
                    _updateSnippetProperties(_self[STR_SNIPPET /* @min:%2esnippet */]);
                    // Empty queue of all api calls logged prior to sdk download
                    _self.emptyQueue();
                    _self[STR_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */]();
                    _self[_DYN_ADD_HOUSEKEEPING_BEF20 /* @min:%2eaddHousekeepingBeforeUnload */](_self);
                });
                return _self;
            };
            _self[_DYN_UPDATE_SNIPPET_DEFIN0 /* @min:%2eupdateSnippetDefinitions */] = function (snippet) {
                // apply full appInsights to the global instance
                // Note: This must be called before loadAppInsights is called
                proxyAssign(snippet, _self, function (name) {
                    // Not excluding names prefixed with "_" as we need to proxy some functions like _onError
                    return name && arrIndexOf(_ignoreUpdateSnippetProperties, name) === -1;
                });
            };
            _self.emptyQueue = function () {
                // call functions that were queued before the main script was loaded
                try {
                    if (isArray(_self.snippet[_DYN_QUEUE /* @min:%2equeue */])) {
                        // note: do not check length in the for-loop conditional in case something goes wrong and the stub methods are not overridden.
                        var length_1 = _self.snippet[_DYN_QUEUE /* @min:%2equeue */].length;
                        for (var i = 0; i < length_1; i++) {
                            var call = _self.snippet[_DYN_QUEUE /* @min:%2equeue */][i];
                            call();
                        }
                        _self.snippet[_DYN_QUEUE /* @min:%2equeue */] = undefined;
                        delete _self.snippet[_DYN_QUEUE /* @min:%2equeue */];
                    }
                }
                catch (exception) {
                    var properties_1 = {};
                    if (exception && isFunction(exception.toString)) {
                        properties_1.exception = exception.toString();
                    }
                    // need from core
                    // Microsoft.ApplicationInsights._InternalLogging.throwInternal(
                    //     eLoggingSeverity.WARNING,
                    //     _eInternalMessageId.FailedToSendQueuedTelemetry,
                    //     "Failed to send queued telemetry",
                    //     properties);
                }
            };
            _self[_DYN_ADD_HOUSEKEEPING_BEF20 /* @min:%2eaddHousekeepingBeforeUnload */] = function (appInsightsInstance) {
                // Add callback to push events when the user navigates away
                if (hasWindow() || hasDocument()) {
                    var performHousekeeping = function () {
                        // Adds the ability to flush all data before the page unloads.
                        // Note: This approach tries to push a sync request with all the pending events onbeforeunload.
                        // Firefox does not respect this.Other browsers DO push out the call with < 100% hit rate.
                        // Telemetry here will help us analyze how effective this approach is.
                        // Another approach would be to make this call sync with a acceptable timeout to reduce the
                        // impact on user experience.
                        // appInsightsInstance.context._sender.triggerSend();
                        appInsightsInstance[_DYN_ONUNLOAD_FLUSH /* @min:%2eonunloadFlush */](false);
                        // Back up the current session to local storage
                        // This lets us close expired sessions after the cookies themselves expire
                        if (isFunction(_this.core[STR_GET_PLUGIN /* @min:%2egetPlugin */])) {
                            var loadedPlugin = _this.core[STR_GET_PLUGIN /* @min:%2egetPlugin */](PropertiesPluginIdentifier);
                            if (loadedPlugin) {
                                var propertiesPlugin = loadedPlugin.plugin;
                                if (propertiesPlugin && propertiesPlugin[_DYN_CONTEXT /* @min:%2econtext */] && propertiesPlugin[_DYN_CONTEXT /* @min:%2econtext */]._sessionManager) {
                                    propertiesPlugin[_DYN_CONTEXT /* @min:%2econtext */]._sessionManager.backup();
                                }
                            }
                        }
                    };
                    var added = false;
                    var excludePageUnloadEvents = appInsightsInstance.appInsights[_DYN_CONFIG /* @min:%2econfig */].disablePageUnloadEvents;
                    if (!_houseKeepingNamespace) {
                        _houseKeepingNamespace = mergeEvtNamespace(_evtNamespace, _core[STR_EVT_NAMESPACE /* @min:%2eevtNamespace */] && _core[STR_EVT_NAMESPACE /* @min:%2eevtNamespace */]());
                    }
                    if (!appInsightsInstance.appInsights.config[_DYN_DISABLE_FLUSH_ON_BEF11 /* @min:%2edisableFlushOnBeforeUnload */]) {
                        // Hook the unload event for the document, window and body to ensure that the client events are flushed to the server
                        // As just hooking the window does not always fire (on chrome) for page navigation's.
                        if (addPageUnloadEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace)) {
                            added = true;
                        }
                        // We also need to hook the pagehide and visibilitychange events as not all versions of Safari support load/unload events.
                        if (addPageHideEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace)) {
                            added = true;
                        }
                        // A reactNative app may not have a window and therefore the beforeunload/pagehide events -- so don't
                        // log the failure in this case
                        if (!added && !isReactNative()) {
                            _throwInternal(appInsightsInstance[_DYN_APP_INSIGHTS /* @min:%2eappInsights */].core.logger, 1 /* eLoggingSeverity.CRITICAL */, 19 /* _eInternalMessageId.FailedToAddHandlerForOnBeforeUnload */, "Could not add handler for beforeunload and pagehide");
                        }
                    }
                    if (!added && !appInsightsInstance.appInsights.config[_DYN_DISABLE_FLUSH_ON_UNL12 /* @min:%2edisableFlushOnUnload */]) {
                        // If we didn't add the normal set then attempt to add the pagehide and visibilitychange only
                        addPageHideEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace);
                    }
                }
            };
            _self.getSender = function () {
                return _sender;
            };
            _self.unload = function (isAsync, unloadComplete, cbTimeout) {
                _self[_DYN_ONUNLOAD_FLUSH /* @min:%2eonunloadFlush */](isAsync);
                // Remove any registered event handlers
                if (_houseKeepingNamespace) {
                    removePageUnloadEventListener(null, _houseKeepingNamespace);
                    removePageHideEventListener(null, _houseKeepingNamespace);
                }
                _core.unload && _core.unload(isAsync, unloadComplete, cbTimeout);
            };
            proxyFunctions(_self, _self[_DYN_APP_INSIGHTS /* @min:%2eappInsights */], [
                STR_GET_COOKIE_MGR,
                STR_TRACK_EVENT,
                STR_TRACK_PAGE_VIEW,
                "trackPageViewPerformance",
                STR_TRACK_EXCEPTION,
                "_onerror",
                STR_TRACK_TRACE,
                STR_TRACK_METRIC,
                STR_START_TRACK_PAGE,
                STR_STOP_TRACK_PAGE,
                STR_START_TRACK_EVENT,
                STR_STOP_TRACK_EVENT
            ]);
            proxyFunctions(_self, _getCurrentDependencies, [
                STR_TRACK_DEPENDENCY_DATA,
                "addDependencyListener",
                "addDependencyInitializer"
            ]);
            proxyFunctions(_self, _core, [
                STR_ADD_TELEMETRY_INITIALIZER,
                STR_POLL_INTERNAL_LOGS,
                "stopPollingInternalLogs",
                STR_GET_PLUGIN,
                "addPlugin",
                STR_EVT_NAMESPACE,
                "addUnloadCb",
                "getTraceCtx"
            ]);
            proxyFunctions(_self, function () {
                var context = properties[_DYN_CONTEXT /* @min:%2econtext */];
                return context ? context.user : null;
            }, [
                STR_SET_AUTHENTICATED_USER_CONTEXT,
                STR_CLEAR_AUTHENTICATED_USER_CONTEXT
            ]);
            function _getSKUDefaults() {
                _self.config[_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] =
                    _self.config[_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] && _self[_DYN_CONFIG /* @min:%2econfig */][_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] > 0 ? _self[_DYN_CONFIG /* @min:%2econfig */][_DYN_DIAGNOSTIC_LOG_INTER4 /* @min:%2ediagnosticLogInterval */] : 10000;
            }
            // Using a function to support the dynamic adding / removal of plugins, so this will always return the current value
            function _getCurrentDependencies() {
                return dependencies;
            }
            function _initDefaults() {
                _evtNamespace = createUniqueNamespace("AISKU");
                _houseKeepingNamespace = null;
                dependencies = null;
                properties = null;
                _sender = null;
                _snippetVersion = null;
            }
        });
    }
    // Analytics Plugin
// Removed Stub for Initialization.prototype.getCookieMgr.
// Removed Stub for Initialization.prototype.trackEvent.
// Removed Stub for Initialization.prototype.trackPageView.
// Removed Stub for Initialization.prototype.trackPageViewPerformance.
// Removed Stub for Initialization.prototype.trackException.
// Removed Stub for Initialization.prototype._onerror.
// Removed Stub for Initialization.prototype.trackTrace.
// Removed Stub for Initialization.prototype.trackMetric.
// Removed Stub for Initialization.prototype.startTrackPage.
// Removed Stub for Initialization.prototype.stopTrackPage.
// Removed Stub for Initialization.prototype.startTrackEvent.
// Removed Stub for Initialization.prototype.stopTrackEvent.
// Removed Stub for Initialization.prototype.addTelemetryInitializer.
    // Properties Plugin
// Removed Stub for Initialization.prototype.setAuthenticatedUserContext.
// Removed Stub for Initialization.prototype.clearAuthenticatedUserContext.
    // Dependencies Plugin
// Removed Stub for Initialization.prototype.trackDependencyData.
    // Misc
// Removed Stub for Initialization.prototype.flush.
// Removed Stub for Initialization.prototype.onunloadFlush.
// Removed Stub for Initialization.prototype.loadAppInsights.
// Removed Stub for Initialization.prototype.updateSnippetDefinitions.
// Removed Stub for Initialization.prototype.emptyQueue.
// Removed Stub for Initialization.prototype.pollInternalLogs.
// Removed Stub for Initialization.prototype.stopPollingInternalLogs.
// Removed Stub for Initialization.prototype.addHousekeepingBeforeUnload.
// Removed Stub for Initialization.prototype.getSender.
// Removed Stub for Initialization.prototype.unload.
// Removed Stub for Initialization.prototype.getPlugin.
// Removed Stub for Initialization.prototype.addPlugin.
// Removed Stub for Initialization.prototype.evtNamespace.
// Removed Stub for Initialization.prototype.addUnloadCb.
// Removed Stub for Initialization.prototype.addDependencyListener.
    /**
     * Add an dependency telemetry initializer callback function to allow populating additional properties or drop the request.
     * It is called after the dependency call has completed and any available performance details are available. A dependency
     * initializer is similar to the TelemetryInitializer function but it allows you to block the reporting of the dependency
     * request so that it doesn't count against the `maxAjaxCallsPerView`.
     * @param dependencyInitializer - The Dependency Telemetry Initializer function
     * @returns - A IDependencyInitializerHandler to enable the initializer to be removed
     */
    Initialization.prototype.addDependencyInitializer = function (dependencyInitializer) {
        return null;
    };
// Removed Stub for Initialization.prototype.getTraceCtx.
    return Initialization;
}());
export { Initialization };
// tslint:disable-next-line
(function () {
    var sdkSrc = null;
    var isModule = false;
    var cdns = [
        "://js.monitor.azure.com/",
        "://az416426.vo.msecnd.net/"
    ];
    try {
        // Try and determine whether the sdk is being loaded from the CDN
        // currentScript is only valid during initial processing
        var scrpt = (document || {}).currentScript;
        if (scrpt) {
            sdkSrc = scrpt.src;
            // } else {
            //     // We need to update to at least typescript 2.9 for this to work :-(
            //     // Leaving as a stub for now so after we upgrade this breadcrumb is available
            //     let meta = import.meta;
            //     sdkSrc = (meta || {}).url;
            //     isModule = true;
        }
    }
    catch (e) {
        // eslint-disable-next-line no-empty
    }
    if (sdkSrc) {
        try {
            var url = sdkSrc.toLowerCase();
            if (url) {
                var src = "";
                for (var idx = 0; idx < cdns.length; idx++) {
                    if (url[_DYN_INDEX_OF /* @min:%2eindexOf */](cdns[idx]) !== -1) {
                        src = "cdn" + (idx + 1);
                        if (url[_DYN_INDEX_OF /* @min:%2eindexOf */]("/scripts/") === -1) {
                            if (url[_DYN_INDEX_OF /* @min:%2eindexOf */]("/next/") !== -1) {
                                src += "-next";
                            }
                            else if (url[_DYN_INDEX_OF /* @min:%2eindexOf */]("/beta/") !== -1) {
                                src += "-beta";
                            }
                        }
                        _internalSdkSrc = src + (isModule ? ".mod" : "");
                        break;
                    }
                }
            }
        }
        catch (e) {
            // eslint-disable-next-line no-empty
        }
    }
})();
//# sourceMappingURL=Initialization.js.map