/*
 * Microsoft.ApplicationInsights, 2.8.17
 * Copyright (c) Microsoft and contributors. All rights reserved.
 *
 * Microsoft Application Insights Team
 * https://github.com/microsoft/ApplicationInsights-JS#readme
 */

declare namespace ApplicationInsights {
    import { AppInsightsCore } from '@microsoft/applicationinsights-core-js';
    import { ApplicationInsights as ApplicationAnalytics } from '@microsoft/applicationinsights-analytics-js';
    import { BaseCore } from '@microsoft/applicationinsights-core-js';
    import { BaseTelemetryPlugin } from '@microsoft/applicationinsights-core-js';
    import { ConfigurationManager } from '@microsoft/applicationinsights-common';
    import { ContextTagKeys } from '@microsoft/applicationinsights-common';
    import { CoreUtils } from '@microsoft/applicationinsights-core-js';
    import { Data } from '@microsoft/applicationinsights-common';
    import { AjaxPlugin as DependenciesPlugin } from '@microsoft/applicationinsights-dependencies-js';
    import { DependencyInitializerFunction } from '@microsoft/applicationinsights-dependencies-js';
    import { DependencyListenerFunction } from '@microsoft/applicationinsights-dependencies-js';
    import { DependencyListenerFunction as DependencyListenerFunction_2 } from '@microsoft/applicationinsights-dependencies-js/types/DependencyListener';
    import { DistributedTracingModes } from '@microsoft/applicationinsights-common';
    import { doPerf } from '@microsoft/applicationinsights-core-js';
    import { eDistributedTracingModes } from '@microsoft/applicationinsights-common';
    import { _eInternalMessageId } from '@microsoft/applicationinsights-core-js';
    import { eLoggingSeverity } from '@microsoft/applicationinsights-core-js';
    import { EnumValue } from '@microsoft/applicationinsights-core-js';
    import { Envelope } from '@microsoft/applicationinsights-common';
    import { eSeverityLevel } from '@microsoft/applicationinsights-common';
    import { Event as Event_2 } from '@microsoft/applicationinsights-common';
    import { Exception } from '@microsoft/applicationinsights-common';
    import { FieldType } from '@microsoft/applicationinsights-common';
    import { IAppInsights } from '@microsoft/applicationinsights-common';
    import { IAppInsightsCore } from '@microsoft/applicationinsights-core-js';
    import { IAppInsightsInternal } from '@microsoft/applicationinsights-analytics-js';
    import { IAutoExceptionTelemetry } from '@microsoft/applicationinsights-common';
    import { IConfig } from '@microsoft/applicationinsights-common';
    import { IConfiguration } from '@microsoft/applicationinsights-core-js';
    import { ICookieMgr } from '@microsoft/applicationinsights-core-js';
    import { ICoreUtils } from '@microsoft/applicationinsights-core-js';
    import { ICorrelationIdHelper } from '@microsoft/applicationinsights-common';
    import { ICustomProperties } from '@microsoft/applicationinsights-core-js';
    import { IDataSanitizer } from '@microsoft/applicationinsights-common';
    import { IDateTimeUtils } from '@microsoft/applicationinsights-common';
    import { IDependenciesPlugin } from '@microsoft/applicationinsights-dependencies-js';
    import { IDependencyInitializerHandler } from '@microsoft/applicationinsights-dependencies-js';
    import { IDependencyListenerHandler } from '@microsoft/applicationinsights-dependencies-js';
    import { IDependencyListenerHandler as IDependencyListenerHandler_2 } from '@microsoft/applicationinsights-dependencies-js/types/DependencyListener';
    import { IDependencyTelemetry } from '@microsoft/applicationinsights-common';
    import { IDiagnosticLogger } from '@microsoft/applicationinsights-core-js';
    import { IDistributedTraceContext } from '@microsoft/applicationinsights-core-js';
    import { IEnvelope } from '@microsoft/applicationinsights-common';
    import { IEventTelemetry } from '@microsoft/applicationinsights-common';
    import { IExceptionTelemetry } from '@microsoft/applicationinsights-common';
    import { ILoadedPlugin } from '@microsoft/applicationinsights-core-js';
    import { IMetricTelemetry } from '@microsoft/applicationinsights-common';
    import { INotificationListener } from '@microsoft/applicationinsights-core-js';
    import { INotificationManager } from '@microsoft/applicationinsights-core-js';
    import { _InternalMessageId } from '@microsoft/applicationinsights-core-js';
    import { IPageViewPerformanceTelemetry } from '@microsoft/applicationinsights-common';
    import { IPageViewTelemetry } from '@microsoft/applicationinsights-common';
    import { IPerfEvent } from '@microsoft/applicationinsights-core-js';
    import { IPerfManager } from '@microsoft/applicationinsights-core-js';
    import { IPerfManagerProvider } from '@microsoft/applicationinsights-core-js';
    import { IPlugin } from '@microsoft/applicationinsights-core-js';
    import { IProcessTelemetryContext } from '@microsoft/applicationinsights-core-js';
    import { IPropertiesPlugin } from '@microsoft/applicationinsights-common';
    import { IRequestHeaders } from '@microsoft/applicationinsights-common';
    import { ITelemetryContext } from '@microsoft/applicationinsights-common';
    import { ITelemetryInitializerHandler } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryItem } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryPlugin } from '@microsoft/applicationinsights-core-js';
    import { ITelemetryPluginChain } from '@microsoft/applicationinsights-core-js';
    import { ITraceTelemetry } from '@microsoft/applicationinsights-common';
    import { IUrlHelper } from '@microsoft/applicationinsights-common';
    import { IUtil } from '@microsoft/applicationinsights-common';
    import { LoggingSeverity } from '@microsoft/applicationinsights-core-js';
    import { Metric } from '@microsoft/applicationinsights-common';
    import { NotificationManager } from '@microsoft/applicationinsights-core-js';
    import { PageView } from '@microsoft/applicationinsights-common';
    import { PageViewPerformance } from '@microsoft/applicationinsights-common';
    import { parseConnectionString } from '@microsoft/applicationinsights-common';
    import { PerfEvent } from '@microsoft/applicationinsights-core-js';
    import { PerfManager } from '@microsoft/applicationinsights-core-js';
    import { PropertiesPlugin } from '@microsoft/applicationinsights-properties-js';
    import { RemoteDependencyData } from '@microsoft/applicationinsights-common';
    import { Sender } from '@microsoft/applicationinsights-channel-js';
    import { SeverityLevel } from '@microsoft/applicationinsights-common';
    import { Tags } from '@microsoft/applicationinsights-core-js';
    import { TelemetryItemCreator } from '@microsoft/applicationinsights-common';
    import { Trace } from '@microsoft/applicationinsights-common';
    import { UnloadHandler } from '@microsoft/applicationinsights-core-js';
    import { Util } from '@microsoft/applicationinsights-common';

    export { AppInsightsCore }

    export { ApplicationAnalytics }

    /**
     * Application Insights API
     * @class Initialization
     * @implements {IApplicationInsights}
     */
    class ApplicationInsights implements IApplicationInsights {
        snippet: Snippet;
        config: IConfiguration & IConfig;
        appInsights: ApplicationAnalytics;
        core: IAppInsightsCore;
        context: ITelemetryContext;
        constructor(snippet: Snippet);
        /**
         * Get the current cookie manager for this instance
         */
        getCookieMgr(): ICookieMgr;
        /**
         * Log a user action or other occurrence.
         * @param {IEventTelemetry} event
         * @param {ICustomProperties} [customProperties]
         * @memberof Initialization
         */
        trackEvent(event: IEventTelemetry, customProperties?: ICustomProperties): void;
        /**
         * Logs that a page, or similar container was displayed to the user.
         * @param {IPageViewTelemetry} pageView
         * @memberof Initialization
         */
        trackPageView(pageView?: IPageViewTelemetry): void;
        /**
         * Log a bag of performance information via the customProperties field.
         * @param {IPageViewPerformanceTelemetry} pageViewPerformance
         * @memberof Initialization
         */
        trackPageViewPerformance(pageViewPerformance: IPageViewPerformanceTelemetry): void;
        /**
         * Log an exception that you have caught.
         * @param {IExceptionTelemetry} exception
         * @param {{[key: string]: any}} customProperties   Additional data used to filter pages and metrics in the portal. Defaults to empty.
         * @memberof Initialization
         */
        trackException(exception: IExceptionTelemetry, customProperties?: ICustomProperties): void;
        /**
         * Manually send uncaught exception telemetry. This method is automatically triggered
         * on a window.onerror event.
         * @param {IAutoExceptionTelemetry} exception
         * @memberof Initialization
         */
        _onerror(exception: IAutoExceptionTelemetry): void;
        /**
         * Log a diagnostic scenario such entering or leaving a function.
         * @param {ITraceTelemetry} trace
         * @param {ICustomProperties} [customProperties]
         * @memberof Initialization
         */
        trackTrace(trace: ITraceTelemetry, customProperties?: ICustomProperties): void;
        /**
         * Log a numeric value that is not associated with a specific event. Typically used
         * to send regular reports of performance indicators.
         *
         * To send a single measurement, just use the `name` and `average` fields
         * of {@link IMetricTelemetry}.
         *
         * If you take measurements frequently, you can reduce the telemetry bandwidth by
         * aggregating multiple measurements and sending the resulting average and modifying
         * the `sampleCount` field of {@link IMetricTelemetry}.
         * @param {IMetricTelemetry} metric input object argument. Only `name` and `average` are mandatory.
         * @param {ICustomProperties} [customProperties]
         * @memberof Initialization
         */
        trackMetric(metric: IMetricTelemetry, customProperties?: ICustomProperties): void;
        /**
         * Starts the timer for tracking a page load time. Use this instead of `trackPageView` if you want to control when the page view timer starts and stops,
         * but don't want to calculate the duration yourself. This method doesn't send any telemetry. Call `stopTrackPage` to log the end of the page view
         * and send the event.
         * @param name A string that idenfities this item, unique within this HTML document. Defaults to the document title.
         */
        startTrackPage(name?: string): void;
        /**
         * Stops the timer that was started by calling `startTrackPage` and sends the pageview load time telemetry with the specified properties and measurements.
         * The duration of the page view will be the time between calling `startTrackPage` and `stopTrackPage`.
         * @param   name  The string you used as the name in startTrackPage. Defaults to the document title.
         * @param   url   String - a relative or absolute URL that identifies the page or other item. Defaults to the window location.
         * @param   properties  map[string, string] - additional data used to filter pages and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this page, displayed in Metrics Explorer on the portal. Defaults to empty.
         */
        stopTrackPage(name?: string, url?: string, customProperties?: {
            [key: string]: any;
        }, measurements?: {
            [key: string]: number;
        }): void;
        startTrackEvent(name?: string): void;
        /**
         * Log an extended event that you started timing with `startTrackEvent`.
         * @param   name    The string you used to identify this event in `startTrackEvent`.
         * @param   properties  map[string, string] - additional data used to filter events and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this event, displayed in Metrics Explorer on the portal. Defaults to empty.
         */
        stopTrackEvent(name: string, properties?: {
            [key: string]: string;
        }, measurements?: {
            [key: string]: number;
        }): void;
        addTelemetryInitializer(telemetryInitializer: (item: ITelemetryItem) => boolean | void): ITelemetryInitializerHandler | void;
        /**
         * Set the authenticated user id and the account id. Used for identifying a specific signed-in user. Parameters must not contain whitespace or ,;=|
         *
         * The method will only set the `authenticatedUserId` and `accountId` in the current page view. To set them for the whole session, you should set `storeInCookie = true`
         * @param {string} authenticatedUserId
         * @param {string} [accountId]
         * @param {boolean} [storeInCookie=false]
         */
        setAuthenticatedUserContext(authenticatedUserId: string, accountId?: string, storeInCookie?: boolean): void;
        /**
         * Clears the authenticated user id and account id. The associated cookie is cleared, if present.
         */
        clearAuthenticatedUserContext(): void;
        /**
         * Log a dependency call (e.g. ajax)
         * @param {IDependencyTelemetry} dependency
         * @memberof Initialization
         */
        trackDependencyData(dependency: IDependencyTelemetry): void;
        /**
         * Manually trigger an immediate send of all telemetry still in the buffer.
         * @param {boolean} [async=true]
         * @memberof Initialization
         */
        flush(async?: boolean): void;
        /**
         * Manually trigger an immediate send of all telemetry still in the buffer using beacon Sender.
         * Fall back to xhr sender if beacon is not supported.
         * @param {boolean} [async=true]
         * @memberof Initialization
         */
        onunloadFlush(async?: boolean): void;
        /**
         * Initialize this instance of ApplicationInsights
         * @returns {IApplicationInsights}
         * @memberof Initialization
         */
        loadAppInsights(legacyMode?: boolean, logger?: IDiagnosticLogger, notificationManager?: INotificationManager): IApplicationInsights;
        /**
         * Overwrite the lazy loaded fields of global window snippet to contain the
         * actual initialized API methods
         * @param {Snippet} snippet
         * @memberof Initialization
         */
        updateSnippetDefinitions(snippet: Snippet): void;
        /**
         * Call any functions that were queued before the main script was loaded
         * @memberof Initialization
         */
        emptyQueue(): void;
        pollInternalLogs(): void;
        stopPollingInternalLogs(): void;
        addHousekeepingBeforeUnload(appInsightsInstance: IApplicationInsights): void;
        getSender(): Sender;
        /**
         * Unload and Tear down the SDK and any initialized plugins, after calling this the SDK will be considered
         * to be un-initialized and non-operational, re-initializing the SDK should only be attempted if the previous
         * unload call return `true` stating that all plugins reported that they also unloaded, the recommended
         * approach is to create a new instance and initialize that instance.
         * This is due to possible unexpected side effects caused by plugins not supporting unload / teardown, unable
         * to successfully remove any global references or they may just be completing the unload process asynchronously.
         */
        unload(isAsync?: boolean, unloadComplete?: () => void): void;
        getPlugin<T extends IPlugin = IPlugin>(pluginIdentifier: string): ILoadedPlugin<T>;
        addPlugin<T extends IPlugin = ITelemetryPlugin>(plugin: T, replaceExisting: boolean, doAsync: boolean, addCb?: (added?: boolean) => void): void;
        /**
         * Returns the unique event namespace that should be used
         */
        evtNamespace(): string;
        /**
         * Add an unload handler that will be called when the SDK is being unloaded
         * @param handler - the handler
         */
        addUnloadCb(handler: UnloadHandler): void;
        /**
         * Add an ajax listener which is called just prior to the request being sent and before the correlation headers are added, to allow you
         * to access the headers and modify the values used to generate the distributed tracing correlation headers. (added in v2.8.4)
         * @param dependencyListener - The Telemetry Initializer function
         * @returns - A IDependencyListenerHandler to enable the initializer to be removed
         */
        addDependencyListener(dependencyListener: DependencyListenerFunction_2): IDependencyListenerHandler_2;
        /**
         * Add an dependency telemetry initializer callback function to allow populating additional properties or drop the request.
         * It is called after the dependency call has completed and any available performance details are available. A dependency
         * initializer is similar to the TelemetryInitializer function but it allows you to block the reporting of the dependency
         * request so that it doesn't count against the `maxAjaxCallsPerView`.
         * @param dependencyInitializer - The Dependency Telemetry Initializer function
         * @returns - A IDependencyInitializerHandler to enable the initializer to be removed
         */
        addDependencyInitializer(dependencyInitializer: DependencyInitializerFunction): IDependencyInitializerHandler;
        /**
         * Gets the current distributed trace context for this instance if available
         */
        getTraceCtx(): IDistributedTraceContext | null | undefined;
    }

    class ApplicationInsightsContainer {
        static getAppInsights(snippet: Snippet, version: number): IApplicationInsights | IAppInsightsDeprecated;
    }

    export { BaseCore }

    export { BaseTelemetryPlugin }

    export { CoreUtils }

    export { DependenciesPlugin }

    export { DependencyInitializerFunction }

    export { DependencyListenerFunction }

    export { DistributedTracingModes }

    export { doPerf }

    const _DYN_CONTEXT = "context";

    const _DYN_QUEUE = "queue";

    export { _eInternalMessageId }

    export { eLoggingSeverity }

    export { eSeverityLevel }

    export { Event_2 as Event }

    export { Exception }

    export { IAppInsights }

    export { IAppInsightsCore }

    interface IAppInsightsDeprecated {
        config: IConfig;
        [_DYN_CONTEXT]: ITelemetryContext_2;
        [_DYN_QUEUE]: Array<() => void>;
        /**
         * Get the current cookie manager for this instance
         */
        getCookieMgr(): ICookieMgr;
        /**
         * Starts timing how long the user views a page or other item. Call this when the page opens.
         * This method doesn't send any telemetry. Call `stopTrackPage` to log the page when it closes.
         * @param   name  A string that identifies this item, unique within this HTML document. Defaults to the document title.
         */
        startTrackPage(name?: string): void;
        /**
         * Logs how long a page or other item was visible, after `startTrackPage`. Call this when the page closes.
         * @param   name  The string you used as the name in startTrackPage. Defaults to the document title.
         * @param   url   String - a relative or absolute URL that identifies the page or other item. Defaults to the window location.
         * @param   properties  map[string, string] - additional data used to filter pages and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this page, displayed in Metrics Explorer on the portal. Defaults to empty.
         * @deprecated API is deprecated; supported only if input configuration specifies deprecated=true
         */
        stopTrackPage(name?: string, url?: string, properties?: {
            [name: string]: string;
        }, measurements?: {
            [name: string]: number;
        }): void;
        /**
         * Logs that a page or other item was viewed.
         * @param   name  The string you used as the name in `startTrackPage`. Defaults to the document title.
         * @param   url   String - a relative or absolute URL that identifies the page or other item. Defaults to the window location.
         * @param   properties  map[string, string] - additional data used to filter pages and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this page, displayed in Metrics Explorer on the portal. Defaults to empty.
         * @param   duration    number - the number of milliseconds it took to load the page. Defaults to undefined. If set to default value, page load time is calculated internally.
         */
        trackPageView(name?: string, url?: string, properties?: {
            [name: string]: string;
        }, measurements?: {
            [name: string]: number;
        }, duration?: number): void;
        /**
         * Start timing an extended event. Call `stopTrackEvent` to log the event when it ends.
         * @param   name    A string that identifies this event uniquely within the document.
         */
        startTrackEvent(name: string): void;
        /**
         * Log an extended event that you started timing with `startTrackEvent`.
         * @param   name    The string you used to identify this event in `startTrackEvent`.
         * @param   properties  map[string, string] - additional data used to filter events and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this event, displayed in Metrics Explorer on the portal. Defaults to empty.
         */
        stopTrackEvent(name: string, properties?: {
            [name: string]: string;
        }, measurements?: {
            [name: string]: number;
        }): void;
        /**
         * Log a user action or other occurrence.
         * @param   name    A string to identify this event in the portal.
         * @param   properties  map[string, string] - additional data used to filter events and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this event, displayed in Metrics Explorer on the portal. Defaults to empty.
         */
        trackEvent(name: string, properties?: {
            [name: string]: string;
        }, measurements?: {
            [name: string]: number;
        }): void;
        /**
         * Log a dependency call
         * @param id    unique id, this is used by the backend to correlate server requests. Use newId() to generate a unique Id.
         * @param method    represents request verb (GET, POST, etc.)
         * @param absoluteUrl   absolute url used to make the dependency request
         * @param pathName  the path part of the absolute url
         * @param totalTime total request time
         * @param success   indicates if the request was successful
         * @param resultCode    response code returned by the dependency request
         */
        trackDependency(id: string, method: string, absoluteUrl: string, pathName: string, totalTime: number, success: boolean, resultCode: number): void;
        /**
         * Log an exception you have caught.
         * @param   exception   An Error from a catch clause, or the string error message.
         * @param   handledAt   Not used
         * @param   properties  map[string, string] - additional data used to filter events and metrics in the portal. Defaults to empty.
         * @param   measurements    map[string, number] - metrics associated with this event, displayed in Metrics Explorer on the portal. Defaults to empty.
         * @param   severityLevel   SeverityLevel - severity level
         */
        trackException(exception: Error, handledAt?: string, properties?: {
            [name: string]: string;
        }, measurements?: {
            [name: string]: number;
        }, severityLevel?: SeverityLevel): void;
        /**
         * Log a numeric value that is not associated with a specific event. Typically used to send regular reports of performance indicators.
         * To send a single measurement, use just the first two parameters. If you take measurements very frequently, you can reduce the
         * telemetry bandwidth by aggregating multiple measurements and sending the resulting average at intervals.
         * @param   name    A string that identifies the metric.
         * @param   average Number representing either a single measurement, or the average of several measurements.
         * @param   sampleCount The number of measurements represented by the average. Defaults to 1.
         * @param   min The smallest measurement in the sample. Defaults to the average.
         * @param   max The largest measurement in the sample. Defaults to the average.
         */
        trackMetric(name: string, average: number, sampleCount?: number, min?: number, max?: number, properties?: {
            [name: string]: string;
        }): void;
        /**
         * Log a diagnostic message.
         * @param   message A message string
         * @param   properties  map[string, string] - additional data used to filter traces in the portal. Defaults to empty.
         * @param   severityLevel   SeverityLevel - severity level
         */
        trackTrace(message: string, properties?: {
            [name: string]: string;
        }, severityLevel?: SeverityLevel): void;
        /**
         * Immediately send all queued telemetry.
         * @param {boolean} async - If flush should be call asynchronously
         */
        flush(async?: boolean): void;
        /**
         * Sets the autheticated user id and the account id in this session.
         * User auth id and account id should be of type string. They should not contain commas, semi-colons, equal signs, spaces, or vertical-bars.
         *
         * @param authenticatedUserId {string} - The authenticated user id. A unique and persistent string that represents each authenticated user in the service.
         * @param accountId {string} - An optional string to represent the account associated with the authenticated user.
         */
        setAuthenticatedUserContext(authenticatedUserId: string, accountId?: string, storeInCookie?: boolean): void;
        /**
         * Clears the authenticated user id and the account id from the user context.
         */
        clearAuthenticatedUserContext(): void;
        downloadAndSetup?(config: IConfig): void;
        /**
         * The custom error handler for Application Insights
         * @param {string} message - The error message
         * @param {string} url - The url where the error was raised
         * @param {number} lineNumber - The line number where the error was raised
         * @param {number} columnNumber - The column number for the line where the error was raised
         * @param {Error}  error - The Error object
         */
        _onerror(message: string, url: string, lineNumber: number, columnNumber: number, error: Error): void;
    }

    export { IAppInsightsInternal }

    interface IApplicationInsights extends IAppInsights, IDependenciesPlugin, IPropertiesPlugin {
        appInsights: ApplicationAnalytics;
        flush: (async?: boolean) => void;
        onunloadFlush: (async?: boolean) => void;
        getSender: () => Sender;
        setAuthenticatedUserContext(authenticatedUserId: string, accountId?: string, storeInCookie?: boolean): void;
        clearAuthenticatedUserContext(): void;
        /**
         * Unload and Tear down the SDK and any initialized plugins, after calling this the SDK will be considered
         * to be un-initialized and non-operational, re-initializing the SDK should only be attempted if the previous
         * unload call return `true` stating that all plugins reported that they also unloaded, the recommended
         * approach is to create a new instance and initialize that instance.
         * This is due to possible unexpected side effects caused by plugins not supporting unload / teardown, unable
         * to successfully remove any global references or they may just be completing the unload process asynchronously.
         */
        unload(isAsync?: boolean, unloadComplete?: () => void): void;
        /**
         * Find and return the (first) plugin with the specified identifier if present
         * @param pluginIdentifier
         */
        getPlugin<T extends IPlugin = IPlugin>(pluginIdentifier: string): ILoadedPlugin<T>;
        /**
         * Add a new plugin to the installation
         * @param plugin - The new plugin to add
         * @param replaceExisting - should any existing plugin be replaced
         * @param doAsync - Should the add be performed asynchronously
         */
        addPlugin<T extends IPlugin = ITelemetryPlugin>(plugin: T, replaceExisting: boolean, doAsync: boolean, addCb?: (added?: boolean) => void): void;
        /**
         * Returns the unique event namespace that should be used when registering events
         */
        evtNamespace(): string;
        /**
         * Add a handler that will be called when the SDK is being unloaded
         * @param handler - the handler
         */
        addUnloadCb(handler: UnloadHandler): void;
    }

    export { IAutoExceptionTelemetry }

    export { IConfig }

    export { IConfiguration }

    export { ICoreUtils }

    export { ICorrelationIdHelper }

    export { ICustomProperties }

    export { IDateTimeUtils }

    export { IDependenciesPlugin }

    export { IDependencyInitializerHandler }

    export { IDependencyListenerHandler }

    export { IDependencyTelemetry }

    export { IDiagnosticLogger }

    export { IEventTelemetry }

    export { IExceptionTelemetry }

    export { IMetricTelemetry }

    export { INotificationListener }

    export { INotificationManager }

    export { _InternalMessageId }

    export { IPageViewPerformanceTelemetry }

    export { IPageViewTelemetry }

    export { IPerfEvent }

    export { IPerfManager }

    export { IPerfManagerProvider }

    export { IPlugin }

    export { IProcessTelemetryContext }

    export { IRequestHeaders }

    interface ITelemetryContext_2 {
        /**
         * Adds a telemetry initializer to the collection. Telemetry initializers will be called one by one,
         * in the order they were added, before the telemetry item is pushed for sending.
         * If one of the telemetry initializers returns false or throws an error then the telemetry item will not be sent.
         */
        addTelemetryInitializer(telemetryInitializer: (envelope: IEnvelope) => boolean | void): void;
    }

    export { ITelemetryItem }

    export { ITelemetryPlugin }

    export { ITelemetryPluginChain }

    export { ITraceTelemetry }

    export { IUrlHelper }

    export { IUtil }

    export { LoggingSeverity }

    export { Metric }

    export { NotificationManager }

    export { PageView }

    export { PageViewPerformance }

    export { PerfEvent }

    export { PerfManager }

    export { PropertiesPlugin }

    export { RemoteDependencyData }

    export { Sender }

    export { SeverityLevel }

    /**
     *
     * @export
     * @interface Snippet
     */
    interface Snippet {
        config: IConfiguration & IConfig;
        queue?: Array<() => void>;
        sv?: string;
        version?: number;
    }

    export { Tags }

    /**
     * Telemetry type classes, e.g. PageView, Exception, etc
     */
    const Telemetry: {
        __proto__: any;
        PropertiesPluginIdentifier: string;
        BreezeChannelIdentifier: string;
        AnalyticsPluginIdentifier: string;
        Util: IUtil;
        CorrelationIdHelper: ICorrelationIdHelper;
        UrlHelper: IUrlHelper;
        DateTimeUtils: IDateTimeUtils;
        ConnectionStringParser: {
            parse: typeof parseConnectionString;
        };
        FieldType: {
            Default: FieldType;
            Required: FieldType;
            Array: FieldType;
            Hidden: FieldType;
        };
        RequestHeaders: IRequestHeaders & {
            requestContextHeader: "Request-Context";
            requestContextTargetKey: "appId";
            requestContextAppIdFormat: "appId=cid-v1:";
            requestIdHeader: "Request-Id";
            traceParentHeader: "traceparent";
            traceStateHeader: "tracestate";
            sdkContextHeader: "Sdk-Context";
            sdkContextHeaderAppIdRequest: "appId";
            requestContextHeaderLowerCase: "request-context";
            0: "Request-Context";
            1: "appId";
            2: "appId=cid-v1:";
            3: "Request-Id";
            4: "traceparent";
            5: "tracestate";
            6: "Sdk-Context";
            7: "appId";
            8: "request-context";
        };
        DisabledPropertyName: string;
        ProcessLegacy: string;
        SampleRate: string;
        HttpMethod: string;
        DEFAULT_BREEZE_ENDPOINT: string;
        Envelope: typeof Envelope;
        Event: typeof Event_2;
        Exception: typeof Exception;
        Metric: typeof Metric;
        PageView: typeof PageView;
        RemoteDependencyData: typeof RemoteDependencyData;
        Trace: typeof Trace;
        PageViewPerformance: typeof PageViewPerformance;
        Data: typeof Data;
        SeverityLevel: EnumValue<eSeverityLevel>;
        ConfigurationManager: typeof ConfigurationManager;
        ContextTagKeys: typeof ContextTagKeys;
        DataSanitizer: IDataSanitizer;
        TelemetryItemCreator: typeof TelemetryItemCreator;
        CtxTagKeys: ContextTagKeys;
        Extensions: {
            UserExt: string;
            DeviceExt: string;
            TraceExt: string;
            WebExt: string;
            AppExt: string;
            OSExt: string;
            SessionExt: string;
            SDKExt: string;
        };
        DistributedTracingModes: EnumValue<eDistributedTracingModes>;
    };

    export { Trace }

    export { Util }

    
}