import { ParserMessage } from './ParserMessage';
import { TextRange } from './TextRange';
import { TokenSequence } from './TokenSequence';
import { DocNode } from '../nodes/DocNode';
import { DocErrorText } from '../nodes/DocErrorText';
import { TSDocMessageId } from './TSDocMessageId';
/**
 * Used to report errors and warnings that occurred during parsing.
 */
export declare class ParserMessageLog {
    private _messages;
    /**
     * The unfiltered list of all messages.
     */
    readonly messages: ReadonlyArray<ParserMessage>;
    /**
     * Append a message to the log.
     */
    addMessage(parserMessage: ParserMessage): void;
    /**
     * Append a message associated with a TextRange.
     */
    addMessageForTextRange(messageId: TSDocMessageId, messageText: string, textRange: TextRange): void;
    /**
     * Append a message associated with a TokenSequence.
     */
    addMessageForTokenSequence(messageId: TSDocMessageId, messageText: string, tokenSequence: TokenSequence, docNode?: DocNode): void;
    /**
     * Append a message associated with a TokenSequence.
     */
    addMessageForDocErrorText(docErrorText: DocErrorText): void;
}
