"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DocNode_1 = require("./DocNode");
var DocInlineTagBase_1 = require("./DocInlineTagBase");
var DocExcerpt_1 = require("./DocExcerpt");
/**
 * Represents an `{@link}` tag.
 */
var DocLinkTag = /** @class */ (function (_super) {
    __extends(DocLinkTag, _super);
    /**
     * Don't call this directly.  Instead use {@link TSDocParser}
     * @internal
     */
    function DocLinkTag(parameters) {
        var _this = _super.call(this, parameters) || this;
        if (_this.tagNameWithUpperCase !== '@LINK') {
            throw new Error('DocLinkTag requires the tag name to be "{@link}"');
        }
        _this._codeDestination = parameters.codeDestination;
        if (DocNode_1.DocNode.isParsedParameters(parameters)) {
            if (parameters.codeDestination !== undefined && parameters.urlDestinationExcerpt !== undefined) {
                throw new Error('Either the codeDestination or the urlDestination may be specified, but not both');
            }
            if (parameters.urlDestinationExcerpt) {
                _this._urlDestinationExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "LinkTag_UrlDestination" /* LinkTag_UrlDestination */,
                    content: parameters.urlDestinationExcerpt
                });
            }
            if (parameters.spacingAfterDestinationExcerpt) {
                _this._spacingAfterDestinationExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "Spacing" /* Spacing */,
                    content: parameters.spacingAfterDestinationExcerpt
                });
            }
            if (parameters.pipeExcerpt) {
                _this._pipeExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "LinkTag_Pipe" /* LinkTag_Pipe */,
                    content: parameters.pipeExcerpt
                });
            }
            if (parameters.spacingAfterPipeExcerpt) {
                _this._spacingAfterPipeExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "Spacing" /* Spacing */,
                    content: parameters.spacingAfterPipeExcerpt
                });
            }
            if (parameters.linkTextExcerpt) {
                _this._linkTextExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "LinkTag_LinkText" /* LinkTag_LinkText */,
                    content: parameters.linkTextExcerpt
                });
            }
            if (parameters.spacingAfterLinkTextExcerpt) {
                _this._spacingAfterLinkTextExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "Spacing" /* Spacing */,
                    content: parameters.spacingAfterLinkTextExcerpt
                });
            }
        }
        else {
            if (parameters.codeDestination !== undefined && parameters.urlDestination !== undefined) {
                throw new Error('Either the codeDestination or the urlDestination may be specified, but not both');
            }
            _this._urlDestination = parameters.urlDestination;
            _this._linkText = parameters.linkText;
        }
        return _this;
    }
    Object.defineProperty(DocLinkTag.prototype, "kind", {
        /** @override */
        get: function () {
            return "LinkTag" /* LinkTag */;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocLinkTag.prototype, "codeDestination", {
        /**
         * If the link tag refers to a declaration, this returns the declaration reference object;
         * otherwise this property is undefined.
         * @remarks
         * Either the `codeDestination` or the `urlDestination` property will be defined, but never both.
         */
        get: function () {
            return this._codeDestination;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocLinkTag.prototype, "urlDestination", {
        /**
         * If the link tag was an ordinary URI, this returns the URL string;
         * otherwise this property is undefined.
         * @remarks
         * Either the `codeDestination` or the `urlDestination` property will be defined, but never both.
         */
        get: function () {
            if (this._urlDestination === undefined) {
                if (this._urlDestinationExcerpt !== undefined) {
                    this._urlDestination = this._urlDestinationExcerpt.content.toString();
                }
            }
            return this._urlDestination;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocLinkTag.prototype, "linkText", {
        /**
         * An optional text string that is the hyperlink text.  If omitted, the documentation
         * renderer will use a default string based on the link itself (e.g. the URL text
         * or the declaration identifier).
         *
         * @remarks
         *
         * In HTML, the hyperlink can include leading/trailing space characters around the link text.
         * For example, this HTML will cause a web browser to `y` and also the space character before
         * and after it:
         *
         * ```html
         * x<a href="#Button"> y </a> z
         * ```
         *
         * Unlike HTML, TSDoc trims leading/trailing spaces.  For example, this TSDoc will be
         * displayed `xy z` and underline only the `y` character:
         *
         * ```
         * x{@link Button | y } z
         * ```
         */
        get: function () {
            if (this._linkText === undefined) {
                if (this._linkTextExcerpt !== undefined) {
                    this._linkText = this._linkTextExcerpt.content.toString();
                }
            }
            return this._linkText;
        },
        enumerable: true,
        configurable: true
    });
    /** @override */
    DocLinkTag.prototype.getChildNodesForContent = function () {
        return [
            this._codeDestination,
            this._urlDestinationExcerpt,
            this._spacingAfterDestinationExcerpt,
            this._pipeExcerpt,
            this._spacingAfterPipeExcerpt,
            this._linkTextExcerpt,
            this._spacingAfterLinkTextExcerpt
        ];
    };
    return DocLinkTag;
}(DocInlineTagBase_1.DocInlineTagBase));
exports.DocLinkTag = DocLinkTag;
//# sourceMappingURL=DocLinkTag.js.map