import { DocNodeKind, DocNode, IDocNodeParameters, IDocNodeParsedParameters } from './DocNode';
import { TokenSequence } from '../parser/TokenSequence';
/**
 * Constructor parameters for {@link DocMemberIdentifier}.
 */
export interface IDocMemberIdentifierParameters extends IDocNodeParameters {
    identifier: string;
}
/**
 * Constructor parameters for {@link DocMemberIdentifier}.
 */
export interface IDocMemberIdentifierParsedParameters extends IDocNodeParsedParameters {
    leftQuoteExcerpt?: TokenSequence;
    identifierExcerpt: TokenSequence;
    rightQuoteExcerpt?: TokenSequence;
}
/**
 * A member identifier is part of a {@link DocMemberReference}.
 */
export declare class DocMemberIdentifier extends DocNode {
    private readonly _leftQuoteExcerpt;
    private _identifier;
    private readonly _identifierExcerpt;
    private readonly _rightQuoteExcerpt;
    /**
     * Returns true if the specified string is a valid TypeScript
     * identifier.  If not, {@link DocMemberIdentifier.hasQuotes} will be
     * required.
     */
    static isValidIdentifier(identifier: string): boolean;
    /**
     * Don't call this directly.  Instead use {@link TSDocParser}
     * @internal
     */
    constructor(parameters: IDocMemberIdentifierParameters | IDocMemberIdentifierParsedParameters);
    /** @override */
    readonly kind: DocNodeKind | string;
    /**
     * The identifier string without any quote encoding.
     *
     * @remarks
     * If the value is not a valid ECMAScript identifier, it will be quoted as a
     * string literal during rendering.
     */
    readonly identifier: string;
    /**
     * Returns true if the identifier will be rendered as a quoted string literal
     * instead of as a programming language identifier.  This is required if the
     * `identifier` property is not a valid ECMAScript identifier.
     */
    readonly hasQuotes: boolean;
    /** @override */
    protected onGetChildNodes(): ReadonlyArray<DocNode | undefined>;
}
