"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DocNode_1 = require("./DocNode");
var StringChecks_1 = require("../parser/StringChecks");
var DocExcerpt_1 = require("./DocExcerpt");
/**
 * A member identifier is part of a {@link DocMemberReference}.
 */
var DocMemberIdentifier = /** @class */ (function (_super) {
    __extends(DocMemberIdentifier, _super);
    /**
     * Don't call this directly.  Instead use {@link TSDocParser}
     * @internal
     */
    function DocMemberIdentifier(parameters) {
        var _this = _super.call(this, parameters) || this;
        if (DocNode_1.DocNode.isParsedParameters(parameters)) {
            if (parameters.leftQuoteExcerpt) {
                _this._leftQuoteExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "MemberIdentifier_LeftQuote" /* MemberIdentifier_LeftQuote */,
                    content: parameters.leftQuoteExcerpt
                });
            }
            _this._identifierExcerpt = new DocExcerpt_1.DocExcerpt({
                configuration: _this.configuration,
                excerptKind: "MemberIdentifier_Identifier" /* MemberIdentifier_Identifier */,
                content: parameters.identifierExcerpt
            });
            if (parameters.rightQuoteExcerpt) {
                _this._rightQuoteExcerpt = new DocExcerpt_1.DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "MemberIdentifier_RightQuote" /* MemberIdentifier_RightQuote */,
                    content: parameters.rightQuoteExcerpt
                });
            }
        }
        else {
            _this._identifier = parameters.identifier;
        }
        return _this;
    }
    /**
     * Returns true if the specified string is a valid TypeScript
     * identifier.  If not, {@link DocMemberIdentifier.hasQuotes} will be
     * required.
     */
    DocMemberIdentifier.isValidIdentifier = function (identifier) {
        return !StringChecks_1.StringChecks.explainIfInvalidUnquotedIdentifier(identifier);
    };
    Object.defineProperty(DocMemberIdentifier.prototype, "kind", {
        /** @override */
        get: function () {
            return "MemberIdentifier" /* MemberIdentifier */;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocMemberIdentifier.prototype, "identifier", {
        /**
         * The identifier string without any quote encoding.
         *
         * @remarks
         * If the value is not a valid ECMAScript identifier, it will be quoted as a
         * string literal during rendering.
         */
        get: function () {
            if (this._identifier === undefined) {
                this._identifier = this._identifierExcerpt.content.toString();
            }
            return this._identifier;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DocMemberIdentifier.prototype, "hasQuotes", {
        /**
         * Returns true if the identifier will be rendered as a quoted string literal
         * instead of as a programming language identifier.  This is required if the
         * `identifier` property is not a valid ECMAScript identifier.
         */
        get: function () {
            if (this._identifierExcerpt) {
                return !!this._leftQuoteExcerpt;
            }
            else {
                return !DocMemberIdentifier.isValidIdentifier(this.identifier);
            }
        },
        enumerable: true,
        configurable: true
    });
    /** @override */
    DocMemberIdentifier.prototype.onGetChildNodes = function () {
        return [
            this._leftQuoteExcerpt,
            this._identifierExcerpt,
            this._rightQuoteExcerpt
        ];
    };
    return DocMemberIdentifier;
}(DocNode_1.DocNode));
exports.DocMemberIdentifier = DocMemberIdentifier;
//# sourceMappingURL=DocMemberIdentifier.js.map