import { TextRange } from './TextRange';
import { TokenSequence } from './TokenSequence';
import { DocNode } from '../nodes/DocNode';
/**
 * Constructor parameters for {@link ParserMessage}.
 */
export interface IParserMessageParameters {
    messageText: string;
    textRange: TextRange;
    tokenSequence?: TokenSequence;
    docNode?: DocNode;
}
/**
 * Represents an error or warning that occurred during parsing.
 */
export declare class ParserMessage {
    /**
     * The message text without the default prefix that shows line/column information.
     */
    readonly unformattedText: string;
    readonly textRange: TextRange;
    readonly tokenSequence: TokenSequence | undefined;
    readonly docNode: DocNode | undefined;
    private _text;
    /**
     * Generates a line/column prefix.  Example with line=2 and column=5
     * and message="An error occurred":
     * ```
     * "(2,5): An error occurred"
     * ```
     */
    private static _formatMessageText;
    constructor(parameters: IParserMessageParameters);
    /**
     * The message text.
     */
    readonly text: string;
    toString(): string;
}
