import { StringChecks } from '../parser/StringChecks';
/**
 * Determines the type of syntax for a TSDocTagDefinition
 */
export var TSDocTagSyntaxKind;
(function (TSDocTagSyntaxKind) {
    /**
     * The tag is intended to be an inline tag.  For example: `{@link}`.
     */
    TSDocTagSyntaxKind[TSDocTagSyntaxKind["InlineTag"] = 0] = "InlineTag";
    /**
     * The tag is intended to be a block tag that starts a new documentation
     * section.  For example: `@remarks`
     */
    TSDocTagSyntaxKind[TSDocTagSyntaxKind["BlockTag"] = 1] = "BlockTag";
    /**
     * The tag is intended to be a modifier tag whose presence indicates
     * an aspect of the associated API item.  For example: `@internal`
     */
    TSDocTagSyntaxKind[TSDocTagSyntaxKind["ModifierTag"] = 2] = "ModifierTag";
})(TSDocTagSyntaxKind || (TSDocTagSyntaxKind = {}));
/**
 * Defines a TSDoc tag that will be understood by the TSDocParser.
 */
var TSDocTagDefinition = /** @class */ (function () {
    function TSDocTagDefinition(parameters) {
        StringChecks.validateTSDocTagName(parameters.tagName);
        this.tagName = parameters.tagName;
        this.tagNameWithUpperCase = parameters.tagName.toUpperCase();
        this.syntaxKind = parameters.syntaxKind;
        this.standardization =
            parameters.standardization || "None" /* None */;
        this.allowMultiple = !!parameters.allowMultiple;
    }
    /**
     * Throws an exception if `tagName` is not a valid TSDoc tag name.
     */
    TSDocTagDefinition.validateTSDocTagName = function (tagName) {
        StringChecks.validateTSDocTagName(tagName);
    };
    return TSDocTagDefinition;
}());
export { TSDocTagDefinition };
//# sourceMappingURL=TSDocTagDefinition.js.map