var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { DocNode } from './DocNode';
import { DocExcerpt } from './DocExcerpt';
import { StringBuilder } from '../emitters/StringBuilder';
/**
 * Represents an HTML end tag.  Example: `</a>`
 */
var DocHtmlEndTag = /** @class */ (function (_super) {
    __extends(DocHtmlEndTag, _super);
    /**
     * Don't call this directly.  Instead use {@link TSDocParser}
     * @internal
     */
    function DocHtmlEndTag(parameters) {
        var _this = _super.call(this, parameters) || this;
        if (DocNode.isParsedParameters(parameters)) {
            _this._openingDelimiterExcerpt = new DocExcerpt({
                configuration: _this.configuration,
                excerptKind: "HtmlEndTag_OpeningDelimiter" /* HtmlEndTag_OpeningDelimiter */,
                content: parameters.openingDelimiterExcerpt
            });
            _this._nameExcerpt = new DocExcerpt({
                configuration: _this.configuration,
                excerptKind: "HtmlEndTag_Name" /* HtmlEndTag_Name */,
                content: parameters.nameExcerpt
            });
            if (parameters.spacingAfterNameExcerpt) {
                _this._spacingAfterNameExcerpt = new DocExcerpt({
                    configuration: _this.configuration,
                    excerptKind: "Spacing" /* Spacing */,
                    content: parameters.spacingAfterNameExcerpt
                });
            }
            _this._closingDelimiterExcerpt = new DocExcerpt({
                configuration: _this.configuration,
                excerptKind: "HtmlEndTag_ClosingDelimiter" /* HtmlEndTag_ClosingDelimiter */,
                content: parameters.closingDelimiterExcerpt
            });
        }
        else {
            _this._name = parameters.name;
        }
        return _this;
    }
    Object.defineProperty(DocHtmlEndTag.prototype, "kind", {
        /** @override */
        get: function () {
            return "HtmlEndTag" /* HtmlEndTag */;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DocHtmlEndTag.prototype, "name", {
        /**
         * The HTML element name.
         */
        get: function () {
            if (this._name === undefined) {
                this._name = this._nameExcerpt.content.toString();
            }
            return this._name;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Generates the HTML for this tag.
     */
    DocHtmlEndTag.prototype.emitAsHtml = function () {
        // NOTE: Here we're assuming that the TSDoc representation for a tag is also a valid HTML expression.
        var stringBuilder = new StringBuilder();
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        var emitter = new TSDocEmitter();
        emitter.renderHtmlTag(stringBuilder, this);
        return stringBuilder.toString();
    };
    /** @override */
    DocHtmlEndTag.prototype.onGetChildNodes = function () {
        return [
            this._openingDelimiterExcerpt,
            this._nameExcerpt,
            this._spacingAfterNameExcerpt,
            this._closingDelimiterExcerpt
        ];
    };
    return DocHtmlEndTag;
}(DocNode));
export { DocHtmlEndTag };
// Circular reference
import { TSDocEmitter } from '../emitters/TSDocEmitter';
//# sourceMappingURL=DocHtmlEndTag.js.map