(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.milstd2525 = {}));
})(this, (function (exports) { 'use strict';

  function csv2json(str) {
    var e, et;
    str = str.replace(/\r/g, "");
    var arr = str.split("\n");
    var header = arr[0].split("\t");
    var names = [];
    for (var i = 1; i < arr.length; i++) {
      if (arr[i] == "") {
        arr.splice(i, 1);
        i--;
        continue;
      }
      var values = arr[i].split("\t");
      arr[i] = {};
      for (var j = 0; j < header.length; j++) {
        if (j <= values.length) {
          arr[i][header[j]] = values[j];
        }
        // For letter based standards
        if (arr[i].hasOwnProperty("hierarchy")) {
          var h = arr[i].hierarchy.split(".");
          names[h.length - 1] = arr[i].name;
          arr[i].names = names.slice(0, h.length);
        }
        // For number based standards
        if (arr[i]["Entity"]) {
          e = arr[i]["Entity"];
          et = "";
        }
        if (arr[i]["Entity Type"]) {
          arr[i]["Entity"] = e;
          et = arr[i]["Entity Type"];
        }
        if (arr[i]["Entity Subtype"]) {
          arr[i]["Entity"] = e;
          arr[i]["Entity Type"] = et;
        }
      }
    }
    arr.shift();
    return arr;
  }

  var mil_std_2525b_space = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.SPC\tS\t*\tP\t*\t------\tSPACE TRACK\t\nWAR.SPC.SAT\tS\t*\tP\t*\tS-----\tSATELLITE\t\nWAR.SPC.CSV\tS\t*\tP\t*\tV-----\tCREWED SPACE VEHICLE\t\nWAR.SPC.SST\tS\t*\tP\t*\tT-----\tSPACE STATION\t\nWAR.SPC.SLV\tS\t*\tP\t*\tL-----\tSPACE LAUNCH VEHICLE\t";

  var mil_std_2525b_air = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.AIRTRK\tS\t*\tA\t*\t------\tAIR TRACK\t\nWAR.AIRTRK.MIL\tS\t*\tA\t*\tM-----\tMILITARY\t\nWAR.AIRTRK.MIL.FIXD\tS\t*\tA\t*\tMF----\tFIXED WING\t\nWAR.AIRTRK.MIL.FIXD.BMB\tS\t*\tA\t*\tMFB---\tBOMBER\t\nWAR.AIRTRK.MIL.FIXD.FTR\tS\t*\tA\t*\tMFF---\tFIGHTER\t\nWAR.AIRTRK.MIL.FIXD.FTR.INCR\tS\t*\tA\t*\tMFFI--\tINTERCEPTOR\t\nWAR.AIRTRK.MIL.FIXD.TNE\tS\t*\tA\t*\tMFT---\tTRAINER\t\nWAR.AIRTRK.MIL.FIXD.ATK\tS\t*\tA\t*\tMFA---\tATTACK/STRIKE\t\nWAR.AIRTRK.MIL.FIXD.VSTOL\tS\t*\tA\t*\tMFL---\tVSTOL\t\nWAR.AIRTRK.MIL.FIXD.TNK\tS\t*\tA\t*\tMFK---\tTANKER\t\nWAR.AIRTRK.MIL.FIXD.TNK.BOOM\tS\t*\tA\t*\tMFKB--\tTANKER BOOM-ONLY\t\nWAR.AIRTRK.MIL.FIXD.TNK.DROG\tS\t*\tA\t*\tMFKD--\tTANKER DROGUE-ONLY\t\nWAR.AIRTRK.MIL.FIXD.CGOALT\tS\t*\tA\t*\tMFC---\tCARGO AIRLIFT (TRANSPORT)\t\nWAR.AIRTRK.MIL.FIXD.CGOALT.LIT\tS\t*\tA\t*\tMFCL--\tCARGO AIRLIFT (LIGHT)\t\nWAR.AIRTRK.MIL.FIXD.CGOALT.MDM\tS\t*\tA\t*\tMFCM--\tCARGO AIRLIFT (MEDIUM)\t\nWAR.AIRTRK.MIL.FIXD.CGOALT.HVY\tS\t*\tA\t*\tMFCH--\tCARGO AIRLIFT (HEAVY)\t\nWAR.AIRTRK.MIL.FIXD.ECM\tS\t*\tA\t*\tMFJ---\tELECTRONIC COUNTERMEASURES (ECM/JAMMER)\t\nWAR.AIRTRK.MIL.FIXD.MEDV\tS\t*\tA\t*\tMFO---\tMEDEVAC\t\nWAR.AIRTRK.MIL.FIXD.RECON\tS\t*\tA\t*\tMFR---\tRECONNAISSANCE\t\nWAR.AIRTRK.MIL.FIXD.RECON.ABNEW\tS\t*\tA\t*\tMFRW--\tAIRBORNE EARLY WARNING (AEW)\t\nWAR.AIRTRK.MIL.FIXD.RECON.ESM\tS\t*\tA\t*\tMFRZ--\tELECTRONIC SURVEILLANCE MEASURES\t\nWAR.AIRTRK.MIL.FIXD.RECON.PHG\tS\t*\tA\t*\tMFRX--\tPHOTOGRAPHIC\t\nWAR.AIRTRK.MIL.FIXD.PAT\tS\t*\tA\t*\tMFP---\tPATROL\t\nWAR.AIRTRK.MIL.FIXD.PAT.ASUW\tS\t*\tA\t*\tMFPN--\tANTISURFACE WARFARE (ASUW)\t\nWAR.AIRTRK.MIL.FIXD.PAT.MNECM\tS\t*\tA\t*\tMFPM--\tMINE COUNTERMEASURES\t\nWAR.AIRTRK.MIL.FIXD.UTY\tS\t*\tA\t*\tMFU---\tUTILITY\t\nWAR.AIRTRK.MIL.FIXD.UTY.LIT\tS\t*\tA\t*\tMFUL--\tUTILITY (LIGHT)\t\nWAR.AIRTRK.MIL.FIXD.UTY.MDM\tS\t*\tA\t*\tMFUM--\tUTILITY (MEDIUM)\t\nWAR.AIRTRK.MIL.FIXD.UTY.HVY\tS\t*\tA\t*\tMFUH--\tUTILITY (HEAVY)\t\nWAR.AIRTRK.MIL.FIXD.COMM\tS\t*\tA\t*\tMFY---\tCOMMUNICATIONS (C3I)\t\nWAR.AIRTRK.MIL.FIXD.CSAR\tS\t*\tA\t*\tMFH---\tCOMBAT SEARCH AND RESCUE (CSAR)\t\nWAR.AIRTRK.MIL.FIXD.ABNCP\tS\t*\tA\t*\tMFD---\tAIRBORNE COMMAND POST (C2)\t\nWAR.AIRTRK.MIL.FIXD.DRN\tS\t*\tA\t*\tMFQ---\tDRONE (RPV/UAV)\t\nWAR.AIRTRK.MIL.FIXD.DRN.ATK\tS\t*\tA\t*\tMFQA--\tATTACK\t\nWAR.AIRTRK.MIL.FIXD.DRN.BMB\tS\t*\tA\t*\tMFQB--\tBOMBER\t\nWAR.AIRTRK.MIL.FIXD.DRN.CGO\tS\t*\tA\t*\tMFQC--\tCARGO\t\nWAR.AIRTRK.MIL.FIXD.DRN.ABNCP\tS\t*\tA\t*\tMFQD--\tAIRBORNE COMMAND POST\t\nWAR.AIRTRK.MIL.FIXD.DRN.FTR\tS\t*\tA\t*\tMFQF--\tFIGHTER\t\nWAR.AIRTRK.MIL.FIXD.DRN.CSAR\tS\t*\tA\t*\tMFQH--\tSEARCH & RESCUE (CSAR)\t\nWAR.AIRTRK.MIL.FIXD.DRN.ECM\tS\t*\tA\t*\tMFQJ--\tELECTRONIC COUNTERMEASURES (JAMMER)\t\nWAR.AIRTRK.MIL.FIXD.DRN.TNK\tS\t*\tA\t*\tMFQK--\tTANKER\t\nWAR.AIRTRK.MIL.FIXD.DRN.VSTOL\tS\t*\tA\t*\tMFQL--\tVSTOL\t\nWAR.AIRTRK.MIL.FIXD.DRN.SOF\tS\t*\tA\t*\tMFQM--\tSPECIAL OPERATIONS FORCES (SOF)\t\nWAR.AIRTRK.MIL.FIXD.DRN.MNECM\tS\t*\tA\t*\tMFQI--\tMINE COUNTERMEASURES\t\nWAR.AIRTRK.MIL.FIXD.DRN.ASUW\tS\t*\tA\t*\tMFQN--\tANTI-SURFACE WARFARE (ASUW)\t\nWAR.AIRTRK.MIL.FIXD.DRN.PAT\tS\t*\tA\t*\tMFQP--\tPATROL\t\nWAR.AIRTRK.MIL.FIXD.DRN.RECON\tS\t*\tA\t*\tMFQR--\tRECONNAISSANCE\t\nWAR.AIRTRK.MIL.FIXD.DRN.RECON.ABNEW\tS\t*\tA\t*\tMFQRW-\tAIRBORNE EARLY WARNING (AEW)\t\nWAR.AIRTRK.MIL.FIXD.DRN.RECON.ESM\tS\t*\tA\t*\tMFQRZ-\tELECTRONIC SURVEILLANCE MEASURES\t\nWAR.AIRTRK.MIL.FIXD.DRN.RECON.PHG\tS\t*\tA\t*\tMFQRX-\tPHOTOGRAPHIC\t\nWAR.AIRTRK.MIL.FIXD.DRN.ASBW\tS\t*\tA\t*\tMFQS--\tANTI-SUBMARINE WARFARE (ASW)\t\nWAR.AIRTRK.MIL.FIXD.DRN.TNE\tS\t*\tA\t*\tMFQT--\tTRAINER\t\nWAR.AIRTRK.MIL.FIXD.DRN.UTY\tS\t*\tA\t*\tMFQU--\tUTILITY\t\nWAR.AIRTRK.MIL.FIXD.DRN.COMM\tS\t*\tA\t*\tMFQY--\tCOMMUNICATIONS (C3I)\t\nWAR.AIRTRK.MIL.FIXD.DRN.MEDV\tS\t*\tA\t*\tMFQO--\tMEDEVAC\t\nWAR.AIRTRK.MIL.FIXD.ASBWCB\tS\t*\tA\t*\tMFS---\tANTISUBMARINE WARFARE (ASW) CARRIER BASED\t\nWAR.AIRTRK.MIL.FIXD.SOF\tS\t*\tA\t*\tMFM---\tSPECIAL OPERATIONS FORCES (SOF)\t\nWAR.AIRTRK.MIL.ROT\tS\t*\tA\t*\tMH----\tROTARY WING\t\nWAR.AIRTRK.MIL.ROT.ATK\tS\t*\tA\t*\tMHA---\tATTACK\t\nWAR.AIRTRK.MIL.ROT.ASBW\tS\t*\tA\t*\tMHS---\tANTISUBMARINE WARFARE/MPA\t\nWAR.AIRTRK.MIL.ROT.UTY\tS\t*\tA\t*\tMHU---\tUTILITY\t\nWAR.AIRTRK.MIL.ROT.UTY.LIT\tS\t*\tA\t*\tMHUL--\tUTILITY (LIGHT)\t\nWAR.AIRTRK.MIL.ROT.UTY.MDM\tS\t*\tA\t*\tMHUM--\tUTILITY (MEDIUM)\t\nWAR.AIRTRK.MIL.ROT.UTY.HVY\tS\t*\tA\t*\tMHUH--\tUTILITY (HEAVY)\t\nWAR.AIRTRK.MIL.ROT.MNECM\tS\t*\tA\t*\tMHI---\tMINE COUNTERMEASURES\t\nWAR.AIRTRK.MIL.ROT.CSAR\tS\t*\tA\t*\tMHH---\tCOMBAT SEARCH AND RESCUE (CSAR)\t\nWAR.AIRTRK.MIL.ROT.RECON\tS\t*\tA\t*\tMHR---\tRECONNAISSANCE\t\nWAR.AIRTRK.MIL.ROT.DRN\tS\t*\tA\t*\tMHQ---\tDRONE (RPV/UAV)\t\nWAR.AIRTRK.MIL.ROT.CGOALT\tS\t*\tA\t*\tMHC---\tCARGO AIRLIFT (TRANSPORT)\t\nWAR.AIRTRK.MIL.ROT.CGOALT.LIT\tS\t*\tA\t*\tMHCL--\tCARGO AIRLIFT (LIGHT)\t\nWAR.AIRTRK.MIL.ROT.CGOALT.MDM\tS\t*\tA\t*\tMHCM--\tCARGO AIRLIFT (MEDIUM)\t\nWAR.AIRTRK.MIL.ROT.CGOALT.HVY\tS\t*\tA\t*\tMHCH--\tCARGO AIRLIFT (HEAVY)\t\nWAR.AIRTRK.MIL.ROT.TNE\tS\t*\tA\t*\tMHT---\tTRAINER\t\nWAR.AIRTRK.MIL.ROT.MEDV\tS\t*\tA\t*\tMHO---\tMEDEVAC\t\nWAR.AIRTRK.MIL.ROT.SOF\tS\t*\tA\t*\tMHM---\tSPECIAL OPERATIONS FORCES (SOF)\t\nWAR.AIRTRK.MIL.ROT.ABNCP\tS\t*\tA\t*\tMHD---\tAIRBORNE COMMAND POST (C2)\t\nWAR.AIRTRK.MIL.ROT.TNK\tS\t*\tA\t*\tMHK---\tTANKER\t\nWAR.AIRTRK.MIL.ROT.ECM\tS\t*\tA\t*\tMHJ---\tELECTRONIC COUNTERMEASURES (ECM/JAMMER)\t\nWAR.AIRTRK.MIL.LTA\tS\t*\tA\t*\tML----\tLIGHTER THAN AIR\t\nWAR.AIRTRK.WPN\tS\t*\tA\t*\tW-----\tWEAPON\t\nWAR.AIRTRK.WPN.MSLIF\tS\t*\tA\t*\tWM----\tMISSILE IN FLIGHT\t\nWAR.AIRTRK.WPN.MSLIF.SLM\tS\t*\tA\t*\tWMS---\tSURFACE LAUNCHED MISSILE\t\nWAR.AIRTRK.WPN.MSLIF.SLM.SSM\tS\t*\tA\t*\tWMSS--\tSURFACE TO SURFACE MISSILE (SSM)\t\nWAR.AIRTRK.WPN.MSLIF.SLM.SAM\tS\t*\tA\t*\tWMSA--\tSURFACE TO AIR MISSILE (SAM)\t\nWAR.AIRTRK.WPN.MSLIF.SLM.SSUM\tS\t*\tA\t*\tWMSU--\tSURFACE TO SUBSURFACE MISSILE\t\nWAR.AIRTRK.WPN.MSLIF.SLM.ABM\tS\t*\tA\t*\tWMSB--\tANTI-BALLISTIC MISSILE (ABM)\t\nWAR.AIRTRK.WPN.MSLIF.ALM\tS\t*\tA\t*\tWMA---\tAIR LAUNCHED MISSILE\t\nWAR.AIRTRK.WPN.MSLIF.ALM.ASM\tS\t*\tA\t*\tWMAS--\tAIR TO SURFACE MISSILE (ASM)\t\nWAR.AIRTRK.WPN.MSLIF.ALM.AAM\tS\t*\tA\t*\tWMAA--\tAIR TO AIR MISSILE (AAM)\t\nWAR.AIRTRK.WPN.MSLIF.ALM.ASPC\tS\t*\tA\t*\tWMAP--\tAIR TO SPACE MISSILE\t\nWAR.AIRTRK.WPN.MSLIF.SBSM\tS\t*\tA\t*\tWMU---\tSUBSURFACE TO SURFACE MISSILE (S/SSM)\t\nWAR.AIRTRK.WPN.MSLIF.CM\tS\t*\tA\t*\tWMCM--\tCRUISE MISSILE\t\nWAR.AIRTRK.WPN.MSLIF.BLST\tS\t*\tA\t*\tWMB---\tBALLISTIC MISSILE\t\nWAR.AIRTRK.WPN.BM\tS\t*\tA\t*\tWB----\tBOMB\t\nWAR.AIRTRK.WPN.DCY\tS\t*\tA\t*\tWD----\tDECOY\t\nWAR.AIRTRK.CVL\tS\t*\tA\t*\tC-----\tCIVIL AIRCRAFT\t\nWAR.AIRTRK.CVL.FIXD\tS\t*\tA\t*\tCF----\tFIXED WING\t\nWAR.AIRTRK.CVL.ROT\tS\t*\tA\t*\tCH----\tROTARY WING\t\nWAR.AIRTRK.CVL.LTA\tS\t*\tA\t*\tCL----\tLIGHTER THAN AIR\t\n";

  var mil_std_2525b_ground = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.GRDTRK\tS\t*\tG\t*\t------\tGROUND TRACK\t\nWAR.GRDTRK.UNT\tS\t*\tG\t*\tU-----\tUNIT\t\nWAR.GRDTRK.UNT.CBT\tS\t*\tG\t*\tUC----\tCOMBAT\t\nWAR.GRDTRK.UNT.CBT.ADF\tS\t*\tG\t*\tUCD---\tAIR DEFENSE\t\nWAR.GRDTRK.UNT.CBT.ADF.SHTR\tS\t*\tG\t*\tUCDS--\tSHORT RANGE\t\nWAR.GRDTRK.UNT.CBT.ADF.SHTR.CPL\tS\t*\tG\t*\tUCDSC-\tCHAPARRAL\t\nWAR.GRDTRK.UNT.CBT.ADF.SHTR.STG\tS\t*\tG\t*\tUCDSS-\tSTINGER\t\nWAR.GRDTRK.UNT.CBT.ADF.SHTR.VUL\tS\t*\tG\t*\tUCDSV-\tVULCAN\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL\tS\t*\tG\t*\tUCDM--\tAIR DEFENSE MISSILE\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.LIT\tS\t*\tG\t*\tUCDML-\tAIR DEFENSE MISSILE LIGHT\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.LIT.MOT\tS\t*\tG\t*\tUCDMLA\tAIR DEFENSE MISSILE MOTORIZED (AVENGER)\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.MDM\tS\t*\tG\t*\tUCDMM-\tAIR DEFENSE MISSILE MEDIUM\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.HVY\tS\t*\tG\t*\tUCDMH-\tAIR DEFENSE MISSILE HEAVY\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.HMAD\tS\t*\tG\t*\tUCDH--\tH/MAD\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.HMAD.HWK\tS\t*\tG\t*\tUCDHH-\tHAWK\t\nWAR.GRDTRK.UNT.CBT.ADF.MSL.HMAD.PATT\tS\t*\tG\t*\tUCDHP-\tPATRIOT\t\nWAR.GRDTRK.UNT.CBT.ADF.GUNUNT\tS\t*\tG\t*\tUCDG--\tGUN UNIT\t\nWAR.GRDTRK.UNT.CBT.ADF.CMPS\tS\t*\tG\t*\tUCDC--\tCOMPOSITE\t\nWAR.GRDTRK.UNT.CBT.ADF.TGTGUT\tS\t*\tG\t*\tUCDT--\tTARGETING UNIT\t\nWAR.GRDTRK.UNT.CBT.ADF.TMDU\tS\t*\tG\t*\tUCDO--\tTHEATER MISSILE DEFENSE UNIT\t\nWAR.GRDTRK.UNT.CBT.ARM\tS\t*\tG\t*\tUCA---\tARMOR\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK\tS\t*\tG\t*\tUCAT--\tARMOR TRACK\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.ABN\tS\t*\tG\t*\tUCATA-\tARMOR TRACK AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.AMP\tS\t*\tG\t*\tUCATW-\tARMOR TRACK AMPHIBIOUS\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.AMP.RCY\tS\t*\tG\t*\tUCATWR\tARMOR TRACK AMPHIBIOUS RECOVERY\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.LIT\tS\t*\tG\t*\tUCATL-\tARMOR TRACK, LIGHT\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.MDM\tS\t*\tG\t*\tUCATM-\tARMOR TRACK, MEDIUM\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.HVY\tS\t*\tG\t*\tUCATH-\tARMOR TRACK, HEAVY\t\nWAR.GRDTRK.UNT.CBT.ARM.TRK.RCY\tS\t*\tG\t*\tUCATR-\tARMOR TRACK, RECOVERY\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD\tS\t*\tG\t*\tUCAW--\tARMOR, WHEELED\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.AAST\tS\t*\tG\t*\tUCAWS-\tARMOR, WHEELED AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.ABN\tS\t*\tG\t*\tUCAWA-\tARMOR, WHEELED AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.AMP\tS\t*\tG\t*\tUCAWW-\tARMOR, WHEELED AMPHIBIOUS\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.AMP.RCY\tS\t*\tG\t*\tUCAWWR\tARMOR, WHEELED AMPHIBIOUS RECOVERY\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.LIT\tS\t*\tG\t*\tUCAWL-\tARMOR, WHEELED LIGHT\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.MDM\tS\t*\tG\t*\tUCAWM-\tARMOR, WHEELED MEDIUM\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.HVY\tS\t*\tG\t*\tUCAWH-\tARMOR, WHEELED HEAVY\t\nWAR.GRDTRK.UNT.CBT.ARM.WHD.RCY\tS\t*\tG\t*\tUCAWR-\tARMOR, WHEELED RECOVERY\t\nWAR.GRDTRK.UNT.CBT.AARM\tS\t*\tG\t*\tUCAA--\tANTI ARMOR\t\nWAR.GRDTRK.UNT.CBT.AARM.DMD\tS\t*\tG\t*\tUCAAD-\tANTI ARMOR DISMOUNTED\t\nWAR.GRDTRK.UNT.CBT.AARM.LIT\tS\t*\tG\t*\tUCAAL-\tANTI ARMOR LIGHT\t\nWAR.GRDTRK.UNT.CBT.AARM.ABN\tS\t*\tG\t*\tUCAAM-\tANTI ARMOR AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.AARM.AAST\tS\t*\tG\t*\tUCAAS-\tANTI ARMOR AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.AARM.MNT\tS\t*\tG\t*\tUCAAU-\tANTI ARMOR MOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.AARM.ARC\tS\t*\tG\t*\tUCAAC-\tANTI ARMOR ARCTIC\t\nWAR.GRDTRK.UNT.CBT.AARM.ARMD\tS\t*\tG\t*\tUCAAA-\tANTI ARMOR ARMORED\t\nWAR.GRDTRK.UNT.CBT.AARM.ARMD.TKD\tS\t*\tG\t*\tUCAAAT\tANTI ARMOR ARMORED TRACKED\t\nWAR.GRDTRK.UNT.CBT.AARM.ARMD.WHD\tS\t*\tG\t*\tUCAAAW\tANTI ARMOR ARMORED WHEELED\t\nWAR.GRDTRK.UNT.CBT.AARM.ARMD.AAST\tS\t*\tG\t*\tUCAAAS\tANTI ARMOR ARMORED AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.AARM.MOT\tS\t*\tG\t*\tUCAAO-\tANTI ARMOR MOTORIZED\t\nWAR.GRDTRK.UNT.CBT.AARM.MOT.AAST\tS\t*\tG\t*\tUCAAOS\tANTI ARMOR MOTORIZED AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.AVN\tS\t*\tG\t*\tUCV---\tAVIATION\t\nWAR.GRDTRK.UNT.CBT.AVN.FIXD\tS\t*\tG\t*\tUCVF--\tFIXED WING\t\nWAR.GRDTRK.UNT.CBT.AVN.FIXD.UTY\tS\t*\tG\t*\tUCVFU-\tUTILITY FIXED WING\t\nWAR.GRDTRK.UNT.CBT.AVN.FIXD.ATK\tS\t*\tG\t*\tUCVFA-\tATTACK FIXED WING\t\nWAR.GRDTRK.UNT.CBT.AVN.FIXD.RECON\tS\t*\tG\t*\tUCVFR-\tRECON FIXED WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT\tS\t*\tG\t*\tUCVR--\tROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.ATK\tS\t*\tG\t*\tUCVRA-\tATTACK ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.SCUT\tS\t*\tG\t*\tUCVRS-\tSCOUT ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.ASBW\tS\t*\tG\t*\tUCVRW-\tANTISUBMARINE WARFARE ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.UTY\tS\t*\tG\t*\tUCVRU-\tUTILITY ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.UTY.LIT\tS\t*\tG\t*\tUCVRUL\tLIGHT UTILITY ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.UTY.MDM\tS\t*\tG\t*\tUCVRUM\tMEDIUM UTILITY ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.UTY.HVY\tS\t*\tG\t*\tUCVRUH\tHEAVY UTILITY ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.C2\tS\t*\tG\t*\tUCVRUC\tC2 ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.MEDV\tS\t*\tG\t*\tUCVRUE\tMEDEVAC ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.ROT.MNECM\tS\t*\tG\t*\tUCVRM-\tMINE COUNTERMEASURE ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.AVN.SAR\tS\t*\tG\t*\tUCVS--\tSEARCH AND RESCUE\t\nWAR.GRDTRK.UNT.CBT.AVN.CMPS\tS\t*\tG\t*\tUCVC--\tCOMPOSITE\t\nWAR.GRDTRK.UNT.CBT.AVN.VSTOL\tS\t*\tG\t*\tUCVV--\tVERTICAL/SHORT TAKEOFF AND LANDING (V/STOL)\t\nWAR.GRDTRK.UNT.CBT.AVN.UAV\tS\t*\tG\t*\tUCVU--\tUNMANNED AERIAL VEHICLE\t\nWAR.GRDTRK.UNT.CBT.AVN.UAV.FIXD\tS\t*\tG\t*\tUCVUF-\tUNMANNED AERIAL VEHICLE FIXED WING\t\nWAR.GRDTRK.UNT.CBT.AVN.UAV.ROT\tS\t*\tG\t*\tUCVUR-\tUNMANNED AERIAL VEHICLE ROTARY WING\t\nWAR.GRDTRK.UNT.CBT.INF\tS\t*\tG\t*\tUCI---\tINFANTRY\t\nWAR.GRDTRK.UNT.CBT.INF.LIT\tS\t*\tG\t*\tUCIL--\tINFANTRY LIGHT\t\nWAR.GRDTRK.UNT.CBT.INF.MOT\tS\t*\tG\t*\tUCIM--\tINFANTRY MOTORIZED\t\nWAR.GRDTRK.UNT.CBT.INF.MNT\tS\t*\tG\t*\tUCIO--\tINFANTRY MOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.INF.ABN\tS\t*\tG\t*\tUCIA--\tINFANTRY AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.INF.AAST\tS\t*\tG\t*\tUCIS--\tINFANTRY AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.INF.MECH\tS\t*\tG\t*\tUCIZ--\tINFANTRY MECHANIZED\t\nWAR.GRDTRK.UNT.CBT.INF.NAV\tS\t*\tG\t*\tUCIN--\tINFANTRY NAVAL\t\nWAR.GRDTRK.UNT.CBT.INF.INFFV\tS\t*\tG\t*\tUCII--\tINFANTRY FIGHTING VEHICLE\t\nWAR.GRDTRK.UNT.CBT.INF.ARC\tS\t*\tG\t*\tUCIC--\tINFANTRY ARCTIC\t\nWAR.GRDTRK.UNT.CBT.ENG\tS\t*\tG\t*\tUCE---\tENGINEER\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT\tS\t*\tG\t*\tUCEC--\tENGINEER COMBAT\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.AAST\tS\t*\tG\t*\tUCECS-\tENGINEER COMBAT AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.ABN\tS\t*\tG\t*\tUCECA-\tENGINEER COMBAT AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.ARC\tS\t*\tG\t*\tUCECC-\tENGINEER COMBAT ARCTIC\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.LIT\tS\t*\tG\t*\tUCECL-\tENGINEER COMBAT LIGHT (SAPPER)\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.MDM\tS\t*\tG\t*\tUCECM-\tENGINEER COMBAT MEDIUM\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.HVY\tS\t*\tG\t*\tUCECH-\tENGINEER COMBAT HEAVY\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.MECH\tS\t*\tG\t*\tUCECT-\tENGINEER COMBAT MECHANIZED (TRACK)\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.MOT\tS\t*\tG\t*\tUCECW-\tENGINEER COMBAT MOTORIZED\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.MNT\tS\t*\tG\t*\tUCECO-\tENGINEER COMBAT MOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.ENG.CBT.RECON\tS\t*\tG\t*\tUCECR-\tENGINEER COMBAT RECON\t\nWAR.GRDTRK.UNT.CBT.ENG.CSN\tS\t*\tG\t*\tUCEN--\tENGINEER CONSTRUCTION\t\nWAR.GRDTRK.UNT.CBT.ENG.CSN.NAV\tS\t*\tG\t*\tUCENN-\tENGINEER NAVAL CONSTRUCTION\t\nWAR.GRDTRK.UNT.CBT.FLDART\tS\t*\tG\t*\tUCF---\tFIELD ARTILLERY\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW\tS\t*\tG\t*\tUCFH--\tHOWITZER/GUN\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.SPD\tS\t*\tG\t*\tUCFHE-\tSELF-PROPELLED\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.AAST\tS\t*\tG\t*\tUCFHS-\tAIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.ABN\tS\t*\tG\t*\tUCFHA-\tAIRBORNE\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.ARC\tS\t*\tG\t*\tUCFHC-\tARCTIC\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.MNT\tS\t*\tG\t*\tUCFHO-\tMOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.LIT\tS\t*\tG\t*\tUCFHL-\tLIGHT\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.MDM\tS\t*\tG\t*\tUCFHM-\tMEDIUM\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.HVY\tS\t*\tG\t*\tUCFHH-\tHEAVY\t\nWAR.GRDTRK.UNT.CBT.FLDART.HOW.AMP\tS\t*\tG\t*\tUCFHX-\tAMPHIBIOUS\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC\tS\t*\tG\t*\tUCFR--\tROCKET\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.SRL\tS\t*\tG\t*\tUCFRS-\tSINGLE ROCKET LAUNCHER\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.SRL.SRSPD\tS\t*\tG\t*\tUCFRSS\tSINGLE ROCKET SELF-PROPELLED\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.SRL.SRTRK\tS\t*\tG\t*\tUCFRSR\tSINGLE ROCKET TRUCK\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.SRL.SRTOW\tS\t*\tG\t*\tUCFRST\tSINGLE ROCKET TOWED\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.MRL\tS\t*\tG\t*\tUCFRM-\tMULTI ROCKET LAUNCHER\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.MRL.MRSPD\tS\t*\tG\t*\tUCFRMS\tMULTI ROCKET SELF-PROPELLED\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.MRL.MRTRK\tS\t*\tG\t*\tUCFRMR\tMULTI ROCKET TRUCK\t\nWAR.GRDTRK.UNT.CBT.FLDART.ROC.MRL.MRTOW\tS\t*\tG\t*\tUCFRMT\tMULTI ROCKET TOWED\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ\tS\t*\tG\t*\tUCFT--\tTARGET ACQUISITION\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.RAD\tS\t*\tG\t*\tUCFTR-\tRADAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.SND\tS\t*\tG\t*\tUCFTS-\tSOUND\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.FLH\tS\t*\tG\t*\tUCFTF-\tFLASH (OPTICAL)\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.CLT\tS\t*\tG\t*\tUCFTC-\tCOLT/FIST\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.CLT.DMD\tS\t*\tG\t*\tUCFTCD\tDISMOUNTED COLT/FIST\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.CLT.TKD\tS\t*\tG\t*\tUCFTCM\tTRACKED COLT/FIST\t\nWAR.GRDTRK.UNT.CBT.FLDART.TGTAQ.ANG\tS\t*\tG\t*\tUCFTA-\tANGLICO\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT\tS\t*\tG\t*\tUCFM--\tMORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.SPDTRK\tS\t*\tG\t*\tUCFMS-\tSELF-PROPELLED (SP) TRACKED MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.SPDWHD\tS\t*\tG\t*\tUCFMW-\tSP WHEELED MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.TOW\tS\t*\tG\t*\tUCFMT-\tTOWED MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.TOW.ABN\tS\t*\tG\t*\tUCFMTA\tTOWED AIRBORNE MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.TOW.AAST\tS\t*\tG\t*\tUCFMTS\tTOWED AIR ASSAULT MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.TOW.ARC\tS\t*\tG\t*\tUCFMTC\tTOWED ARCTIC MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.TOW.MNT\tS\t*\tG\t*\tUCFMTO\tTOWED MOUNTAIN MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.MORT.AMP\tS\t*\tG\t*\tUCFML-\tAMPHIBIOUS MORTAR\t\nWAR.GRDTRK.UNT.CBT.FLDART.ARTSVY\tS\t*\tG\t*\tUCFS--\tARTILLERY SURVEY\t\nWAR.GRDTRK.UNT.CBT.FLDART.ARTSVY.AAST\tS\t*\tG\t*\tUCFSS-\tAIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.FLDART.ARTSVY.ABN\tS\t*\tG\t*\tUCFSA-\tAIRBORNE\t\nWAR.GRDTRK.UNT.CBT.FLDART.ARTSVY.LIT\tS\t*\tG\t*\tUCFSL-\tLIGHT\t\nWAR.GRDTRK.UNT.CBT.FLDART.ARTSVY.MNT\tS\t*\tG\t*\tUCFSO-\tMOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.FLDART.METO\tS\t*\tG\t*\tUCFO--\tMETEOROLOGICAL\t\nWAR.GRDTRK.UNT.CBT.FLDART.METO.AAST\tS\t*\tG\t*\tUCFOS-\tAIR ASSAULT METEOROLOGICAL\t\nWAR.GRDTRK.UNT.CBT.FLDART.METO.ABN\tS\t*\tG\t*\tUCFOA-\tAIRBORNE METEOROLOGICAL\t\nWAR.GRDTRK.UNT.CBT.FLDART.METO.LIT\tS\t*\tG\t*\tUCFOL-\tLIGHT METEOROLOGICAL\t\nWAR.GRDTRK.UNT.CBT.FLDART.METO.MNT\tS\t*\tG\t*\tUCFOO-\tMOUNTAIN METEOROLOGICAL\t\nWAR.GRDTRK.UNT.CBT.RECON\tS\t*\tG\t*\tUCR---\tRECONNAISSANCE\t\nWAR.GRDTRK.UNT.CBT.RECON.HRE\tS\t*\tG\t*\tUCRH--\tRECONNAISSANCE HORSE\t\nWAR.GRDTRK.UNT.CBT.RECON.CVY\tS\t*\tG\t*\tUCRV--\tRECONNAISSANCE CAVALRY\t\nWAR.GRDTRK.UNT.CBT.RECON.CVY.ARMD\tS\t*\tG\t*\tUCRVA-\tRECONNAISSANCE CAVALRY ARMORED\t\nWAR.GRDTRK.UNT.CBT.RECON.CVY.MOT\tS\t*\tG\t*\tUCRVM-\tRECONNAISSANCE CAVALRY MOTORIZED\t\nWAR.GRDTRK.UNT.CBT.RECON.CVY.GRD\tS\t*\tG\t*\tUCRVG-\tRECONNAISSANCE CAVALRY GROUND\t\nWAR.GRDTRK.UNT.CBT.RECON.CVY.AIR\tS\t*\tG\t*\tUCRVO-\tRECONNAISSANCE CAVALRY AIR\t\nWAR.GRDTRK.UNT.CBT.RECON.ARC\tS\t*\tG\t*\tUCRC--\tRECONNAISSANCE ARCTIC\t\nWAR.GRDTRK.UNT.CBT.RECON.AAST\tS\t*\tG\t*\tUCRS--\tRECONNAISSANCE AIR ASSAULT\t\nWAR.GRDTRK.UNT.CBT.RECON.ABN\tS\t*\tG\t*\tUCRA--\tRECONNAISSANCE AIRBORNE\t\nWAR.GRDTRK.UNT.CBT.RECON.MNT\tS\t*\tG\t*\tUCRO--\tRECONNAISSANCE MOUNTAIN\t\nWAR.GRDTRK.UNT.CBT.RECON.LIT\tS\t*\tG\t*\tUCRL--\tRECONNAISSANCE LIGHT\t\nWAR.GRDTRK.UNT.CBT.RECON.MAR\tS\t*\tG\t*\tUCRR--\tRECONNAISSANCE MARINE\t\nWAR.GRDTRK.UNT.CBT.RECON.MAR.DIV\tS\t*\tG\t*\tUCRRD-\tRECONNAISSANCE MARINE DIVISION\t\nWAR.GRDTRK.UNT.CBT.RECON.MAR.FOR\tS\t*\tG\t*\tUCRRF-\tRECONNAISSANCE MARINE FORCE\t\nWAR.GRDTRK.UNT.CBT.RECON.MAR.LAR\tS\t*\tG\t*\tUCRRL-\tRECONNAISSANCE MARINE LIGHT ARMORED RECONNAISSNACE (LAR)\t\nWAR.GRDTRK.UNT.CBT.RECON.LRS\tS\t*\tG\t*\tUCRX--\tRECONNAISSANCE LONG RANGE SURVEILLANCE (LRS)\t\nWAR.GRDTRK.UNT.CBT.MSL\tS\t*\tG\t*\tUCM---\tMISSILE (SURF-SURF)\t\nWAR.GRDTRK.UNT.CBT.MSL.TAC\tS\t*\tG\t*\tUCMT--\tMISSILE (SURF-SURF) TACTICAL\t\nWAR.GRDTRK.UNT.CBT.MSL.STGC\tS\t*\tG\t*\tUCMS--\tMISSILE (SURF-SURF) STRATEGIC\t\nWAR.GRDTRK.UNT.CBT.ISF\tS\t*\tG\t*\tUCS---\tINTERNAL SECURITY FORCES\t\nWAR.GRDTRK.UNT.CBT.ISF.RIV\tS\t*\tG\t*\tUCSW--\tRIVERINE\t\nWAR.GRDTRK.UNT.CBT.ISF.GRD\tS\t*\tG\t*\tUCSG--\tGROUND\t\nWAR.GRDTRK.UNT.CBT.ISF.GRD.DMD\tS\t*\tG\t*\tUCSGD-\tDISMOUNTED GROUND\t\nWAR.GRDTRK.UNT.CBT.ISF.GRD.MOT\tS\t*\tG\t*\tUCSGM-\tMOTORIZED GROUND\t\nWAR.GRDTRK.UNT.CBT.ISF.GRD.MECH\tS\t*\tG\t*\tUCSGA-\tMECHANIZED GROUND\t\nWAR.GRDTRK.UNT.CBT.ISF.WHMECH\tS\t*\tG\t*\tUCSM--\tWHEELED MECHANIZED\t\nWAR.GRDTRK.UNT.CBT.ISF.RALRD\tS\t*\tG\t*\tUCSR--\tRAILROAD\t\nWAR.GRDTRK.UNT.CBT.ISF.AVN\tS\t*\tG\t*\tUCSA--\tAVIATION\t\nWAR.GRDTRK.UNT.CS\tS\t*\tG\t*\tUU----\tCOMBAT SUPPORT\t\nWAR.GRDTRK.UNT.CS.NBC\tS\t*\tG\t*\tUUA---\tCOMBAT SUPPORT NBC\t\nWAR.GRDTRK.UNT.CS.NBC.CML\tS\t*\tG\t*\tUUAC--\tCHEMICAL\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMKDEC\tS\t*\tG\t*\tUUACC-\tSMOKE/DECON\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMKDEC.MECH\tS\t*\tG\t*\tUUACCK\tMECHANIZED SMOKE/DECON\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMKDEC.MOT\tS\t*\tG\t*\tUUACCM\tMOTORIZED SMOKE/DECON\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMK\tS\t*\tG\t*\tUUACS-\tSMOKE\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMK.MOT\tS\t*\tG\t*\tUUACSM\tMOTORIZED SMOKE\t\nWAR.GRDTRK.UNT.CS.NBC.CML.SMK.ARM\tS\t*\tG\t*\tUUACSA\tARMOR SMOKE\t\nWAR.GRDTRK.UNT.CS.NBC.CML.RECON\tS\t*\tG\t*\tUUACR-\tCHEMICAL RECON\t\nWAR.GRDTRK.UNT.CS.NBC.CML.RECON.WARMVH\tS\t*\tG\t*\tUUACRW\tCHEMICAL WHEELED ARMORED VEHICLE\t\nWAR.GRDTRK.UNT.CS.NBC.CML.RECON.WAVS\tS\t*\tG\t*\tUUACRS\tCHEMICAL WHEELED ARMORED VEHICLE RECONNAISSANCE SURVEILLANCE\t\nWAR.GRDTRK.UNT.CS.NBC.NUC\tS\t*\tG\t*\tUUAN--\tNUCLEAR\t\nWAR.GRDTRK.UNT.CS.NBC.BIO\tS\t*\tG\t*\tUUAB--\tBIOLOGICAL\t\nWAR.GRDTRK.UNT.CS.NBC.BIO.RECEQP\tS\t*\tG\t*\tUUABR-\tRECON EQUIPPED\t\nWAR.GRDTRK.UNT.CS.NBC.DECON\tS\t*\tG\t*\tUUAD--\tDECONTAMINATION\t\nWAR.GRDTRK.UNT.CS.MILINT\tS\t*\tG\t*\tUUM---\tMILITARY INTELLIGENCE\t\nWAR.GRDTRK.UNT.CS.MILINT.AEREXP\tS\t*\tG\t*\tUUMA--\tAERIAL EXPLOITATION\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT\tS\t*\tG\t*\tUUMS--\tSIGNAL INTELLIGENCE (SIGINT)\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW\tS\t*\tG\t*\tUUMSE-\tELECTRONIC WARFARE\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.ARMWVH\tS\t*\tG\t*\tUUMSEA\tARMORED WHEELED VEHICLE\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.DFN\tS\t*\tG\t*\tUUMSED\tDIRECTION FINDING\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.INC\tS\t*\tG\t*\tUUMSEI\tINTERCEPT\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.JMG\tS\t*\tG\t*\tUUMSEJ\tJAMMING\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.THT\tS\t*\tG\t*\tUUMSET\tTHEATER\t\nWAR.GRDTRK.UNT.CS.MILINT.SIGINT.ECW.CRP\tS\t*\tG\t*\tUUMSEC\tCORPS\t\nWAR.GRDTRK.UNT.CS.MILINT.CINT\tS\t*\tG\t*\tUUMC--\tCOUNTER INTELLIGENCE\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL\tS\t*\tG\t*\tUUMR--\tSURVEILLANCE\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL.GRDSR\tS\t*\tG\t*\tUUMRG-\tGROUND SURVEILLANCE RADAR\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL.SNS\tS\t*\tG\t*\tUUMRS-\tSENSOR\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL.SNS.SCM\tS\t*\tG\t*\tUUMRSS\tSENSOR SCM\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL.GRDSM\tS\t*\tG\t*\tUUMRX-\tGROUND STATION MODULE\t\nWAR.GRDTRK.UNT.CS.MILINT.SVL.METO\tS\t*\tG\t*\tUUMMO-\tMETEOROLOGICAL\t\nWAR.GRDTRK.UNT.CS.MILINT.OPN\tS\t*\tG\t*\tUUMO--\tOPERATIONS\t\nWAR.GRDTRK.UNT.CS.MILINT.TACEXP\tS\t*\tG\t*\tUUMT--\tTACTICAL EXPLOIT\t\nWAR.GRDTRK.UNT.CS.MILINT.INTGN\tS\t*\tG\t*\tUUMQ--\tINTERROGATION\t\nWAR.GRDTRK.UNT.CS.MILINT.JINTCT\tS\t*\tG\t*\tUUMJ--\tJOINT INTELLIGENCE CENTER\t\nWAR.GRDTRK.UNT.CS.LAWENU\tS\t*\tG\t*\tUUL---\tLAW ENFORCEMENT UNIT\t\nWAR.GRDTRK.UNT.CS.LAWENU.SHRPAT\tS\t*\tG\t*\tUULS--\tSHORE PATROL\t\nWAR.GRDTRK.UNT.CS.LAWENU.MILP\tS\t*\tG\t*\tUULM--\tMILITARY POLICE\t\nWAR.GRDTRK.UNT.CS.LAWENU.CLE\tS\t*\tG\t*\tUULC--\tCIVILIAN LAW ENFORCEMENT\t\nWAR.GRDTRK.UNT.CS.LAWENU.SECPOL\tS\t*\tG\t*\tUULF--\tSECURITY POLICE (AIR)\t\nWAR.GRDTRK.UNT.CS.LAWENU.CID\tS\t*\tG\t*\tUULD--\tCENTRAL INTELLIGENCE DIVISION (CID)\t\nWAR.GRDTRK.UNT.CS.SIGUNT\tS\t*\tG\t*\tUUS---\tSIGNAL UNIT\t\nWAR.GRDTRK.UNT.CS.SIGUNT.ARA\tS\t*\tG\t*\tUUSA--\tAREA\t\nWAR.GRDTRK.UNT.CS.SIGUNT.COMCP\tS\t*\tG\t*\tUUSC--\tCOMMUNICATION CONFIGURED PACKAGE\t\nWAR.GRDTRK.UNT.CS.SIGUNT.COMCP.LCCP\tS\t*\tG\t*\tUUSCL-\tLARGE COMMUNICATION CONFIGURED PACKAGE (LCCP)\t\nWAR.GRDTRK.UNT.CS.SIGUNT.CMDOPN\tS\t*\tG\t*\tUUSO--\tCOMMAND OPERATIONS\t\nWAR.GRDTRK.UNT.CS.SIGUNT.FWDCOM\tS\t*\tG\t*\tUUSF--\tFORWARD COMMUNICATIONS\t\nWAR.GRDTRK.UNT.CS.SIGUNT.MSE\tS\t*\tG\t*\tUUSM--\tMULTIPLE SUBSCRIBER ELEMENT\t\nWAR.GRDTRK.UNT.CS.SIGUNT.MSE.SEN\tS\t*\tG\t*\tUUSMS-\tSMALL EXTENSION NODE\t\nWAR.GRDTRK.UNT.CS.SIGUNT.MSE.LEN\tS\t*\tG\t*\tUUSML-\tLARGE EXTENSION NODE\t\nWAR.GRDTRK.UNT.CS.SIGUNT.MSE.NODCTR\tS\t*\tG\t*\tUUSMN-\tNODE CENTER\t\nWAR.GRDTRK.UNT.CS.SIGUNT.RDOUNT\tS\t*\tG\t*\tUUSR--\tRADIO UNIT\t\nWAR.GRDTRK.UNT.CS.SIGUNT.RDOUNT.TACSAT\tS\t*\tG\t*\tUUSRS-\tTACTICAL SATELLITE\t\nWAR.GRDTRK.UNT.CS.SIGUNT.RDOUNT.TTYCTR\tS\t*\tG\t*\tUUSRT-\tTELETYPE CENTER\t\nWAR.GRDTRK.UNT.CS.SIGUNT.RDOUNT.RLY\tS\t*\tG\t*\tUUSRW-\tRELAY\t\nWAR.GRDTRK.UNT.CS.SIGUNT.SIGSUP\tS\t*\tG\t*\tUUSS--\tSIGNAL SUPPORT\t\nWAR.GRDTRK.UNT.CS.SIGUNT.PHOSWT\tS\t*\tG\t*\tUUSW--\tTELEPHONE SWITCH\t\nWAR.GRDTRK.UNT.CS.SIGUNT.ECRG\tS\t*\tG\t*\tUUSX--\tELECTRONIC RANGING\t\nWAR.GRDTRK.UNT.CS.IWU\tS\t*\tG\t*\tUUI---\tINFORMATION WARFARE UNIT\t\nWAR.GRDTRK.UNT.CS.LNDSUP\tS\t*\tG\t*\tUUP---\tLANDING SUPPORT\t\nWAR.GRDTRK.UNT.CS.EOD\tS\t*\tG\t*\tUUE---\tEXPLOSIVE ORDNANCE DISPOSAL\t\nWAR.GRDTRK.UNT.CSS\tS\t*\tG\t*\tUS----\tCOMBAT SERVICE SUPPORT\t\nWAR.GRDTRK.UNT.CSS.ADMIN\tS\t*\tG\t*\tUSA---\tADMINISTRATIVE (ADMIN)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.THT\tS\t*\tG\t*\tUSAT--\tADMIN THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.CRP\tS\t*\tG\t*\tUSAC--\tADMIN CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.JAG\tS\t*\tG\t*\tUSAJ--\tJUDGE ADVOCATE GENERAL (JAG)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.JAG.THT\tS\t*\tG\t*\tUSAJT-\tJAG THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.JAG.CRP\tS\t*\tG\t*\tUSAJC-\tJAG CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PST\tS\t*\tG\t*\tUSAO--\tPOSTAL\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PST.THT\tS\t*\tG\t*\tUSAOT-\tPOSTAL THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PST.CRP\tS\t*\tG\t*\tUSAOC-\tPOSTAL CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.FIN\tS\t*\tG\t*\tUSAF--\tFINANCE\t\nWAR.GRDTRK.UNT.CSS.ADMIN.FIN.THT\tS\t*\tG\t*\tUSAFT-\tFINANCE THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.FIN.CRP\tS\t*\tG\t*\tUSAFC-\tFINANCE CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PERSVC\tS\t*\tG\t*\tUSAS--\tPERSONNEL SERVICES\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PERSVC.THT\tS\t*\tG\t*\tUSAST-\tPERSONNEL THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PERSVC.CRP\tS\t*\tG\t*\tUSASC-\tPERSONNEL CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MTRY\tS\t*\tG\t*\tUSAM--\tMORTUARY/GRAVES REGISTRY\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MTRY.THT\tS\t*\tG\t*\tUSAMT-\tMORTUARY/GRAVES REGISTRY THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MTRY.CRP\tS\t*\tG\t*\tUSAMC-\tMORTUARY/GRAVES REGISTRY CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RELG\tS\t*\tG\t*\tUSAR--\tRELIGIOUS/CHAPLAIN\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RELG.THT\tS\t*\tG\t*\tUSART-\tRELIGIOUS/CHAPLAIN THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RELG.CRP\tS\t*\tG\t*\tUSARC-\tRELIGIOUS/CHAPLAIN CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF\tS\t*\tG\t*\tUSAP--\tPUBLIC AFFAIRS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.THT\tS\t*\tG\t*\tUSAPT-\tPUBLIC AFFAIRS THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.CRP\tS\t*\tG\t*\tUSAPC-\tPUBLIC AFFAIRS CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT\tS\t*\tG\t*\tUSAPB-\tPUBLIC AFFAIRS BROADCAST\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT.THT\tS\t*\tG\t*\tUSAPBT\tPUBLIC AFFAIRS BROADCAST THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT.CRP\tS\t*\tG\t*\tUSAPBC\tPUBLIC AFFAIRS BROADCAST CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB\tS\t*\tG\t*\tUSAPM-\tPUBLIC AFFAIRS JOINT INFORMATION BUREAU (JIB)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB.THT\tS\t*\tG\t*\tUSAPMT\tPUBLIC AFFAIRS JIB THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB.CRP\tS\t*\tG\t*\tUSAPMC\tPUBLIC AFFAIRS JIB CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RHU\tS\t*\tG\t*\tUSAX--\tREPLACEMENT HOLDING UNIT (RHU)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RHU.THT\tS\t*\tG\t*\tUSAXT-\tRHU THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.RHU.CRP\tS\t*\tG\t*\tUSAXC-\tRHU CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.LBR\tS\t*\tG\t*\tUSAL--\tLABOR\t\nWAR.GRDTRK.UNT.CSS.ADMIN.LBR.THT\tS\t*\tG\t*\tUSALT-\tLABOR THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.LBR.CRP\tS\t*\tG\t*\tUSALC-\tLABOR CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MWR\tS\t*\tG\t*\tUSAW--\tMORALE, WELFARE, RECREATION (MWR)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MWR.THT\tS\t*\tG\t*\tUSAWT-\tMWR THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.MWR.CRP\tS\t*\tG\t*\tUSAWC-\tMWR CORPS\t\nWAR.GRDTRK.UNT.CSS.ADMIN.SUPPLY\tS\t*\tG\t*\tUSAQ--\tQUARTERMASTER (SUPPLY)\t\nWAR.GRDTRK.UNT.CSS.ADMIN.SUPPLY.THT\tS\t*\tG\t*\tUSAQT-\tQUARTERMASTER (SUPPLY) THEATER\t\nWAR.GRDTRK.UNT.CSS.ADMIN.SUPPLY.CRP\tS\t*\tG\t*\tUSAQC-\tQUARTERMASTER (SUPPLY) CORPS\t\nWAR.GRDTRK.UNT.CSS.MED\tS\t*\tG\t*\tUSM---\tMEDICAL\t\nWAR.GRDTRK.UNT.CSS.MED.THT\tS\t*\tG\t*\tUSMT--\tMEDICAL THEATER\t\nWAR.GRDTRK.UNT.CSS.MED.CRP\tS\t*\tG\t*\tUSMC--\tMEDICAL CORPS\t\nWAR.GRDTRK.UNT.CSS.MED.MEDTF\tS\t*\tG\t*\tUSMM--\tMEDICAL TREATMENT FACILITY\t\nWAR.GRDTRK.UNT.CSS.MED.MEDTF.THT\tS\t*\tG\t*\tUSMMT-\tMEDICAL TREATMENT FACILITY THEATER\t\nWAR.GRDTRK.UNT.CSS.MED.MEDTF.CRP\tS\t*\tG\t*\tUSMMC-\tMEDICAL TREATMENT FACILITY CORPS\t\nWAR.GRDTRK.UNT.CSS.MED.VNY\tS\t*\tG\t*\tUSMV--\tMEDICAL VETERINARY\t\nWAR.GRDTRK.UNT.CSS.MED.VNY.THT\tS\t*\tG\t*\tUSMVT-\tMEDICAL VETERINARY THEATER\t\nWAR.GRDTRK.UNT.CSS.MED.VNY.CRP\tS\t*\tG\t*\tUSMVC-\tMEDICAL VETERINARY CORPS\t\nWAR.GRDTRK.UNT.CSS.MED.DEN\tS\t*\tG\t*\tUSMD--\tMEDICAL DENTAL\t\nWAR.GRDTRK.UNT.CSS.MED.DEN.THT\tS\t*\tG\t*\tUSMDT-\tMEDICAL DENTAL THEATER\t\nWAR.GRDTRK.UNT.CSS.MED.DEN.CRP\tS\t*\tG\t*\tUSMDC-\tMEDICAL DENTAL CORPS\t\nWAR.GRDTRK.UNT.CSS.MED.PSY\tS\t*\tG\t*\tUSMP--\tMEDICAL PSYCHOLOGICAL\t\nWAR.GRDTRK.UNT.CSS.MED.PSY.THT\tS\t*\tG\t*\tUSMPT-\tMEDICAL PSYCHOLOGICAL THEATER\t\nWAR.GRDTRK.UNT.CSS.MED.PSY.CRP\tS\t*\tG\t*\tUSMPC-\tMEDICAL PSYCHOLOGICAL CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP\tS\t*\tG\t*\tUSS---\tSUPPLY\t\nWAR.GRDTRK.UNT.CSS.SLP.THT\tS\t*\tG\t*\tUSST--\tSUPPLY THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CRP\tS\t*\tG\t*\tUSSC--\tSUPPLY CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS1\tS\t*\tG\t*\tUSS1--\tSUPPLY CLASS I\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS1.THT\tS\t*\tG\t*\tUSS1T-\tSUPPLY CLASS I THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS1.CRP\tS\t*\tG\t*\tUSS1C-\tSUPPLY CLASS I CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS2\tS\t*\tG\t*\tUSS2--\tSUPPLY CLASS II\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS2.THT\tS\t*\tG\t*\tUSS2T-\tSUPPLY CLASS II THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS2.CRP\tS\t*\tG\t*\tUSS2C-\tSUPPLY CLASS II CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3\tS\t*\tG\t*\tUSS3--\tSUPPLY CLASS III\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3.THT\tS\t*\tG\t*\tUSS3T-\tSUPPLY CLASS III THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3.CRP\tS\t*\tG\t*\tUSS3C-\tSUPPLY CLASS III CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3.AVN\tS\t*\tG\t*\tUSS3A-\tSUPPLY CLASS III AVIATION\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3.AVN.THT\tS\t*\tG\t*\tUSS3AT\tSUPPLY CLASS III AVIATION THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS3.AVN.CRP\tS\t*\tG\t*\tUSS3AC\tSUPPLY CLASS III AVIATION CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS4\tS\t*\tG\t*\tUSS4--\tSUPPLY CLASS IV\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS4.THT\tS\t*\tG\t*\tUSS4T-\tSUPPLY CLASS IV THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS4.CRP\tS\t*\tG\t*\tUSS4C-\tSUPPLY CLASS IV CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS5\tS\t*\tG\t*\tUSS5--\tSUPPLY CLASS V\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS5.THT\tS\t*\tG\t*\tUSS5T-\tSUPPLY CLASS V THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS5.CRP\tS\t*\tG\t*\tUSS5C-\tSUPPLY CLASS V CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS6\tS\t*\tG\t*\tUSS6--\tSUPPLY CLASS VI\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS6.THT\tS\t*\tG\t*\tUSS6T-\tSUPPLY CLASS VI THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS6.CRP\tS\t*\tG\t*\tUSS6C-\tSUPPLY CLASS VI CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS7\tS\t*\tG\t*\tUSS7--\tSUPPLY CLASS VII\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS7.THT\tS\t*\tG\t*\tUSS7T-\tSUPPLY CLASS VII THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS7.CRP\tS\t*\tG\t*\tUSS7C-\tSUPPLY CLASS VII CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS8\tS\t*\tG\t*\tUSS8--\tSUPPLY CLASS VIII\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS8.THT\tS\t*\tG\t*\tUSS8T-\tSUPPLY CLASS VIII THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS8.CRP\tS\t*\tG\t*\tUSS8C-\tSUPPLY CLASS VIII CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS9\tS\t*\tG\t*\tUSS9--\tSUPPLY CLASS IX\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS9.THT\tS\t*\tG\t*\tUSS9T-\tSUPPLY CLASS IX THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS9.CRP\tS\t*\tG\t*\tUSS9C-\tSUPPLY CLASS IX CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS10\tS\t*\tG\t*\tUSSX--\tSUPPLY CLASS X\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS10.THT\tS\t*\tG\t*\tUSSXT-\tSUPPLY CLASS X THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.CLS10.CRP\tS\t*\tG\t*\tUSSXC-\tSUPPLY CLASS X CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.LDY\tS\t*\tG\t*\tUSSL--\tSUPPLY LAUNDRY/BATH\t\nWAR.GRDTRK.UNT.CSS.SLP.LDY.THT\tS\t*\tG\t*\tUSSLT-\tSUPPLY LAUNDRY/BATH THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.LDY.CRP\tS\t*\tG\t*\tUSSLC-\tSUPPLY LAUNDRY/BATH CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O\tS\t*\tG\t*\tUSSW--\tSUPPLY WATER\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O.THT\tS\t*\tG\t*\tUSSWT-\tSUPPLY WATER THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O.CRP\tS\t*\tG\t*\tUSSWC-\tSUPPLY WATER CORPS\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O.PUR\tS\t*\tG\t*\tUSSWP-\tSUPPLY WATER PURIFICATION\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O.PUR.THT\tS\t*\tG\t*\tUSSWPT\tSUPPLY WATER PURIFICATION THEATER\t\nWAR.GRDTRK.UNT.CSS.SLP.H2O.PUR.CRP\tS\t*\tG\t*\tUSSWPC\tSUPPLY WATER PURIFICATION CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT\tS\t*\tG\t*\tUST---\tTRANSPORTATION\t\nWAR.GRDTRK.UNT.CSS.TPT.THT\tS\t*\tG\t*\tUSTT--\tTRANSPORTATION THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.CRP\tS\t*\tG\t*\tUSTC--\tTRANSPORTATION CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT.MCC\tS\t*\tG\t*\tUSTM--\tMOVEMENT CONTROL CENTER (MCC)\t\nWAR.GRDTRK.UNT.CSS.TPT.MCC.THT\tS\t*\tG\t*\tUSTMT-\tMCC THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.MCC.CRP\tS\t*\tG\t*\tUSTMC-\tMCC CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT.RHD\tS\t*\tG\t*\tUSTR--\tRAILHEAD\t\nWAR.GRDTRK.UNT.CSS.TPT.RHD.THT\tS\t*\tG\t*\tUSTRT-\tRAILHEAD THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.RHD.CRP\tS\t*\tG\t*\tUSTRC-\tRAILHEAD CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT.SPOD\tS\t*\tG\t*\tUSTS--\tSPOD/SPOE\t\nWAR.GRDTRK.UNT.CSS.TPT.SPOD.THT\tS\t*\tG\t*\tUSTST-\tSPOD/SPOE THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.SPOD.CRP\tS\t*\tG\t*\tUSTSC-\tSPOD/SPOE CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT.APOD\tS\t*\tG\t*\tUSTA--\tAPOD/APOE\t\nWAR.GRDTRK.UNT.CSS.TPT.APOD.THT\tS\t*\tG\t*\tUSTAT-\tAPOD/APOE THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.APOD.CRP\tS\t*\tG\t*\tUSTAC-\tAPOD/APOE CORPS\t\nWAR.GRDTRK.UNT.CSS.TPT.MSL\tS\t*\tG\t*\tUSTI--\tMISSILE\t\nWAR.GRDTRK.UNT.CSS.TPT.MSL.THT\tS\t*\tG\t*\tUSTIT-\tMISSILE THEATER\t\nWAR.GRDTRK.UNT.CSS.TPT.MSL.CRP\tS\t*\tG\t*\tUSTIC-\tMISSILE CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT\tS\t*\tG\t*\tUSX---\tMAINTENANCE\t\nWAR.GRDTRK.UNT.CSS.MAINT.THT\tS\t*\tG\t*\tUSXT--\tMAINTENANCE THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.CRP\tS\t*\tG\t*\tUSXC--\tMAINTENANCE CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT.HVY\tS\t*\tG\t*\tUSXH--\tMAINTENANCE HEAVY\t\nWAR.GRDTRK.UNT.CSS.MAINT.HVY.THT\tS\t*\tG\t*\tUSXHT-\tMAINTENANCE HEAVY THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.HVY.CRP\tS\t*\tG\t*\tUSXHC-\tMAINTENANCE HEAVY CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT.RCY\tS\t*\tG\t*\tUSXR--\tMAINTENANCE RECOVERY\t\nWAR.GRDTRK.UNT.CSS.MAINT.RCY.THT\tS\t*\tG\t*\tUSXRT-\tMAINTENANCE RECOVERY THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.RCY.CRP\tS\t*\tG\t*\tUSXRC-\tMAINTENANCE RECOVERY CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD\tS\t*\tG\t*\tUSXO--\tORDNANCE\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD.THT\tS\t*\tG\t*\tUSXOT-\tORDNANCE THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD.CRP\tS\t*\tG\t*\tUSXOC-\tORDNANCE CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD.MSL\tS\t*\tG\t*\tUSXOM-\tORDNANCE MISSILE\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD.MSL.THT\tS\t*\tG\t*\tUSXOMT\tORDNANCE MISSILE THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.ORD.MSL.CRP\tS\t*\tG\t*\tUSXOMC\tORDNANCE MISSILE CORPS\t\nWAR.GRDTRK.UNT.CSS.MAINT.EOP\tS\t*\tG\t*\tUSXE--\tELECTRO-OPTICAL\t\nWAR.GRDTRK.UNT.CSS.MAINT.EOP.THT\tS\t*\tG\t*\tUSXET-\tELECTRO-OPTICAL THEATER\t\nWAR.GRDTRK.UNT.CSS.MAINT.EOP.CRP\tS\t*\tG\t*\tUSXEC-\tELECTRO-OPTICAL CORPS\t\nWAR.GRDTRK.UNT.C2HQ\tS\t*\tG\t*\tUH----\tSPECIAL C2 HEADQUARTERS COMPONENT\t\nWAR.GRDTRK.EQT\tS\t*\tG\t*\tE-----\tGROUND TRACK EQUIPMENT\t\nWAR.GRDTRK.EQT.WPN\tS\t*\tG\t*\tEW----\tWEAPON\t\nWAR.GRDTRK.EQT.WPN.MSLL\tS\t*\tG\t*\tEWM---\tMISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD\tS\t*\tG\t*\tEWMA--\tAIR DEFENSE (AD) MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.SHTR\tS\t*\tG\t*\tEWMAS-\tSHORT RANGE AD MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.SHTR.TLAR\tS\t*\tG\t*\tEWMASR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.SHTR.TELAR\tS\t*\tG\t*\tEWMASE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.INTMR\tS\t*\tG\t*\tEWMAI-\tINTERMEDIATE RANGE AD MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.INTMR.TLAR\tS\t*\tG\t*\tEWMAIR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.INTMR.TELAR\tS\t*\tG\t*\tEWMAIE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.LNGR\tS\t*\tG\t*\tEWMAL-\tLONG RANGE AD MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.LNGR.TLAR\tS\t*\tG\t*\tEWMALR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.LNGR.TELAR\tS\t*\tG\t*\tEWMALE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.THT\tS\t*\tG\t*\tEWMAT-\tAD MISSILE LAUNCHER THEATER\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.THT.TLAR\tS\t*\tG\t*\tEWMATR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.ADFAD.THT.TELAR\tS\t*\tG\t*\tEWMATE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nWAR.GRDTRK.EQT.WPN.MSLL.SUF\tS\t*\tG\t*\tEWMS--\tSURF-SURF (SS) MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.SUF.SHTR\tS\t*\tG\t*\tEWMSS-\tSHORT RANGE SS MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.SUF.INTMR\tS\t*\tG\t*\tEWMSI-\tINTERMEDIATE RANGE SS MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.SUF.LNGR\tS\t*\tG\t*\tEWMSL-\tLONG RANGE SS MISSILE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MSLL.AT\tS\t*\tG\t*\tEWMT--\tMISSILE LAUNCHER ANTITANK (AT)\t\nWAR.GRDTRK.EQT.WPN.MSLL.AT.LIT\tS\t*\tG\t*\tEWMTL-\tMISSILE LAUNCHER AT LIGHT\t\nWAR.GRDTRK.EQT.WPN.MSLL.AT.MDM\tS\t*\tG\t*\tEWMTM-\tMISSILE LAUNCHER AT MEDIUM\t\nWAR.GRDTRK.EQT.WPN.MSLL.AT.HVY\tS\t*\tG\t*\tEWMTH-\tMISSILE LAUNCHER AT HEAVY\t\nWAR.GRDTRK.EQT.WPN.SRL\tS\t*\tG\t*\tEWS---\tSINGLE ROCKET LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.SRL.LIT\tS\t*\tG\t*\tEWSL--\tSINGLE ROCKET LAUNCHER LIGHT\t\nWAR.GRDTRK.EQT.WPN.SRL.MDM\tS\t*\tG\t*\tEWSM--\tSINGLE ROCKET LAUNCHER MEDIUM\t\nWAR.GRDTRK.EQT.WPN.SRL.HVY\tS\t*\tG\t*\tEWSH--\tSINGLE ROCKET LAUNCHER HEAVY\t\nWAR.GRDTRK.EQT.WPN.MRL\tS\t*\tG\t*\tEWX---\tMULTIPLE ROCKET LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.MRL.LIT\tS\t*\tG\t*\tEWXL--\tMULTIPLE ROCKET LAUNCHER LIGHT\t\nWAR.GRDTRK.EQT.WPN.MRL.MDM\tS\t*\tG\t*\tEWXM--\tMULTIPLE ROCKET LAUNCHER MEDIUM\t\nWAR.GRDTRK.EQT.WPN.MRL.HVY\tS\t*\tG\t*\tEWXH--\tMULTIPLE ROCKET LAUNCHER HEAVY\t\nWAR.GRDTRK.EQT.WPN.ATRL\tS\t*\tG\t*\tEWT---\tANTITANK ROCKET LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.ATRL.LIT\tS\t*\tG\t*\tEWTL--\tANTI-TANK ROCKET LAUNCHER LIGHT\t\nWAR.GRDTRK.EQT.WPN.ATRL.MDM\tS\t*\tG\t*\tEWTM--\tANTI-TANK ROCKET LAUNCHER MEDIUM\t\nWAR.GRDTRK.EQT.WPN.ATRL.HVY\tS\t*\tG\t*\tEWTH--\tANTI-TANK ROCKET LAUNCHER HEAVY\t\nWAR.GRDTRK.EQT.WPN.RIFWPN\tS\t*\tG\t*\tEWR---\tRIFLE/AUTOMATIC WEAPON\t\nWAR.GRDTRK.EQT.WPN.RIFWPN.RIF\tS\t*\tG\t*\tEWRR--\tRIFLE\t\nWAR.GRDTRK.EQT.WPN.RIFWPN.LMG\tS\t*\tG\t*\tEWRL--\tLIGHT MACHINE GUN\t\nWAR.GRDTRK.EQT.WPN.RIFWPN.HMG\tS\t*\tG\t*\tEWRH--\tHEAVY MACHINE GUN\t\nWAR.GRDTRK.EQT.WPN.GREL\tS\t*\tG\t*\tEWZ---\tGRENADE LAUNCHER\t\nWAR.GRDTRK.EQT.WPN.GREL.LIT\tS\t*\tG\t*\tEWZL--\tGRENADE LAUNCHER LIGHT\t\nWAR.GRDTRK.EQT.WPN.GREL.MDM\tS\t*\tG\t*\tEWZM--\tGRENADE LAUNCHER MEDIUM\t\nWAR.GRDTRK.EQT.WPN.GREL.HVY\tS\t*\tG\t*\tEWZH--\tGRENADE LAUNCHER HEAVY\t\nWAR.GRDTRK.EQT.WPN.MORT\tS\t*\tG\t*\tEWO---\tMORTAR\t\nWAR.GRDTRK.EQT.WPN.MORT.LIT\tS\t*\tG\t*\tEWOL--\tMORTAR LIGHT\t\nWAR.GRDTRK.EQT.WPN.MORT.MDM\tS\t*\tG\t*\tEWOM--\tMORTAR MEDIUM\t\nWAR.GRDTRK.EQT.WPN.MORT.HVY\tS\t*\tG\t*\tEWOH--\tMORTAR HEAVY\t\nWAR.GRDTRK.EQT.WPN.HOW\tS\t*\tG\t*\tEWH---\tHOWITZER\t\nWAR.GRDTRK.EQT.WPN.HOW.LIT\tS\t*\tG\t*\tEWHL--\tHOWITZER LIGHT\t\nWAR.GRDTRK.EQT.WPN.HOW.LIT.SPD\tS\t*\tG\t*\tEWHLS-\tHOWITZER LIGHT SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.HOW.MDM\tS\t*\tG\t*\tEWHM--\tHOWITZER MEDIUM\t\nWAR.GRDTRK.EQT.WPN.HOW.MDM.SPD\tS\t*\tG\t*\tEWHMS-\tHOWITZER MEDIUM SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.HOW.HVY\tS\t*\tG\t*\tEWHH--\tHOWITZER HEAVY\t\nWAR.GRDTRK.EQT.WPN.HOW.HVY.SPD\tS\t*\tG\t*\tEWHHS-\tHOWITZER HEAVY SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.ATG\tS\t*\tG\t*\tEWG---\tANTI-TANK GUN\t\nWAR.GRDTRK.EQT.WPN.ATG.LIT\tS\t*\tG\t*\tEWGL--\tANTI-TANK GUN LIGHT\t\nWAR.GRDTRK.EQT.WPN.ATG.MDM\tS\t*\tG\t*\tEWGM--\tANTI-TANK GUN MEDIUM\t\nWAR.GRDTRK.EQT.WPN.ATG.HVY\tS\t*\tG\t*\tEWGH--\tANTI-TANK GUN HEAVY\t\nWAR.GRDTRK.EQT.WPN.ATG.RECL\tS\t*\tG\t*\tEWGR--\tANTI-TANK GUN RECOILLESS\t\nWAR.GRDTRK.EQT.WPN.DFG\tS\t*\tG\t*\tEWD---\tDIRECT FIRE GUN\t\nWAR.GRDTRK.EQT.WPN.DFG.LIT\tS\t*\tG\t*\tEWDL--\tDIRECT FIRE GUN LIGHT\t\nWAR.GRDTRK.EQT.WPN.DFG.LIT.SPD\tS\t*\tG\t*\tEWDLS-\tDIRECT FIRE GUN LIGHT SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.DFG.MDM\tS\t*\tG\t*\tEWDM--\tDIRECT FIRE GUN MEDIUM\t\nWAR.GRDTRK.EQT.WPN.DFG.MDM.SPD\tS\t*\tG\t*\tEWDMS-\tDIRECT FIRE GUN MEDIUM SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.DFG.HVY\tS\t*\tG\t*\tEWDH--\tDIRECT FIRE GUN HEAVY\t\nWAR.GRDTRK.EQT.WPN.DFG.HVY.SPD\tS\t*\tG\t*\tEWDHS-\tDIRECT FIRE GUN HEAVY SELF-PROPELLED\t\nWAR.GRDTRK.EQT.WPN.ADFG\tS\t*\tG\t*\tEWA---\tAIR DEFENSE GUN\t\nWAR.GRDTRK.EQT.WPN.ADFG.LIT\tS\t*\tG\t*\tEWAL--\tAIR DEFENSE GUN LIGHT\t\nWAR.GRDTRK.EQT.WPN.ADFG.MDM\tS\t*\tG\t*\tEWAM--\tAIR DEFENSE GUN MEDIUM\t\nWAR.GRDTRK.EQT.WPN.ADFG.HVY\tS\t*\tG\t*\tEWAH--\tAIR DEFENSE GUN HEAVY\t\nWAR.GRDTRK.EQT.GRDVEH\tS\t*\tG\t*\tEV----\tGROUND VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD\tS\t*\tG\t*\tEVA---\tARMORED VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK\tS\t*\tG\t*\tEVAT--\tTANK\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.LIT\tS\t*\tG\t*\tEVATL-\tTANK LIGHT\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.LIT.RCY\tS\t*\tG\t*\tEVATLR\tTANK LIGHT RECOVERY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.MDM\tS\t*\tG\t*\tEVATM-\tTANK MEDIUM\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.MDM.RCY\tS\t*\tG\t*\tEVATMR\tTANK MEDIUM RECOVERY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.HVY\tS\t*\tG\t*\tEVATH-\tTANK HEAVY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.TANK.HVY.RCY\tS\t*\tG\t*\tEVATHR\tTANK HEAVY RECOVERY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.ARMPC\tS\t*\tG\t*\tEVAA--\tARMORED PERSONNEL CARRIER\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.ARMPC.RCY\tS\t*\tG\t*\tEVAAR-\tARMORED PERSONNEL CARRIER RECOVERY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.ARMINF\tS\t*\tG\t*\tEVAI--\tARMORED INFANTRY\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.C2V\tS\t*\tG\t*\tEVAC--\tC2V/ACV\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.CSSVEH\tS\t*\tG\t*\tEVAS--\tCOMBAT SERVICE SUPPORT VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ARMD.LARMVH\tS\t*\tG\t*\tEVAL--\tLIGHT ARMORED VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH\tS\t*\tG\t*\tEVU---\tUTILITY VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.BUS\tS\t*\tG\t*\tEVUB--\tBUS\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.SEMI\tS\t*\tG\t*\tEVUS--\tSEMI\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.SEMI.LIT\tS\t*\tG\t*\tEVUSL-\tSEMI LIGHT\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.SEMI.MDM\tS\t*\tG\t*\tEVUSM-\tSEMI MEDIUM\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.SEMI.HVY\tS\t*\tG\t*\tEVUSH-\tSEMI HEAVY\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.LCCTRK\tS\t*\tG\t*\tEVUL--\tLIMITED CROSS-COUNTRY TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.CCTRK\tS\t*\tG\t*\tEVUX--\tCROSS-COUNTRY TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.H2OCRT\tS\t*\tG\t*\tEVUR--\tWATER CRAFT\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK\tS\t*\tG\t*\tEVUT--\tTOW TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK.LIT\tS\t*\tG\t*\tEVUTL-\tTOW TRUCK LIGHT\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK.HVY\tS\t*\tG\t*\tEVUTH-\tTOW TRUCK HEAVY\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.AMBLNC\tS\t*\tG\t*\tEVUA--\tAMBULANCE\t\nWAR.GRDTRK.EQT.GRDVEH.UTYVEH.AMBLNC.ARMD\tS\t*\tG\t*\tEVUAA-\tARMORED AMBULANCE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH\tS\t*\tG\t*\tEVE---\tENGINEER VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.BRG\tS\t*\tG\t*\tEVEB--\tBRIDGE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.ERHMR\tS\t*\tG\t*\tEVEE--\tEARTHMOVER\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.CSNVEH\tS\t*\tG\t*\tEVEC--\tCONSTRUCTION VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MLVEH\tS\t*\tG\t*\tEVEM--\tMINE LAYING VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MLVEH.ARMCV\tS\t*\tG\t*\tEVEMV-\tARMORED CARRIER WITH VOLCANO\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MLVEH.TRKMV\tS\t*\tG\t*\tEVEML-\tTRUCK MOUNTED WITH VOLCANO\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MCVEH\tS\t*\tG\t*\tEVEA--\tMINE CLEARING VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MCVEH.ARMVM\tS\t*\tG\t*\tEVEAA-\tARMORED MOUNTED MINE CLEARING VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.MCVEH.TM\tS\t*\tG\t*\tEVEAT-\tTRAILER MOUNTED MINE CLEARING VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.DZR\tS\t*\tG\t*\tEVED--\tDOZER\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.DZR.ARMD\tS\t*\tG\t*\tEVEDA-\tARMORED DOZER\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.AST\tS\t*\tG\t*\tEVES--\tARMORED ASSAULT\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.ARMERV\tS\t*\tG\t*\tEVER--\tARMORED ENGINEER RECON VEHICLE (AERV)\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.BH\tS\t*\tG\t*\tEVEH--\tBACKHOE\t\nWAR.GRDTRK.EQT.GRDVEH.ENGVEH.FRYTSP\tS\t*\tG\t*\tEVEF--\tFERRY TRANSPORTER\t\nWAR.GRDTRK.EQT.GRDVEH.TRNLCO\tS\t*\tG\t*\tEVT---\tTRAIN LOCOMOTIVE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH\tS\t*\tG\t*\tEVC---\tCIVILIAN VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.AUT\tS\t*\tG\t*\tEVCA--\tAUTOMOBILE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.AUT.CPCT\tS\t*\tG\t*\tEVCAL-\tCOMPACT AUTOMOBILE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.AUT.MDSZ\tS\t*\tG\t*\tEVCAM-\tMIDSIZE AUTOMOBILE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.AUT.SDN\tS\t*\tG\t*\tEVCAH-\tSEDAN AUTOMOBILE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.OBTRK\tS\t*\tG\t*\tEVCO--\tOPEN-BED TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.PU\tS\t*\tG\t*\tEVCOL-\tPICKUP OPEN-BED TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.SMAL\tS\t*\tG\t*\tEVCOM-\tSMALL OPEN-BED TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.LRG\tS\t*\tG\t*\tEVCOH-\tLARGE OPEN-BED TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.MPV\tS\t*\tG\t*\tEVCM--\tMULTI-PASSENGER VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.MPV.VAN\tS\t*\tG\t*\tEVCML-\tVAN MULTI-PASSENGER VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.MPV.SBUS\tS\t*\tG\t*\tEVCMM-\tSMALL BUS MULTI-PASSENGER VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.MPV.LBUS\tS\t*\tG\t*\tEVCMH-\tLARGE BUS MULTI-PASSENGER VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH\tS\t*\tG\t*\tEVCU--\tUTILITY VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.SUV\tS\t*\tG\t*\tEVCUL-\tSPORT UTILITY VEHICLE (SUV), UTILITY VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.SBOX\tS\t*\tG\t*\tEVCUM-\tSMALL BOX TRUCK, UTILITY VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.LBOX\tS\t*\tG\t*\tEVCUH-\tLARGE BOX TRUCK, UTILITY VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.JP\tS\t*\tG\t*\tEVCJ--\tJEEP TYPE VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.JP.SMAL\tS\t*\tG\t*\tEVCJL-\tSMALL/LIGHT JEEP TYPE VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.JP.MDM\tS\t*\tG\t*\tEVCJM-\tMEDIUM JEEP TYPE VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.JP.LRG\tS\t*\tG\t*\tEVCJH-\tLARGE/HEAVY JEEP TYPE VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRL\tS\t*\tG\t*\tEVCT--\tTRACTOR TRAILER TRUCK WITH BOX TRAILER\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.SMAL\tS\t*\tG\t*\tEVCTL-\tSMALL/LIGHT BOX TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.MDM\tS\t*\tG\t*\tEVCTM-\tMEDIUM BOX TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.LRG\tS\t*\tG\t*\tEVCTH-\tLARGE/HEAVY BOX TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF\tS\t*\tG\t*\tEVCF--\tTRACTOR TRAILER TRUCK WITH FLATBED TRAILER\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.SMAL\tS\t*\tG\t*\tEVCFL-\tSMALL/LIGHT FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.MDM\tS\t*\tG\t*\tEVCFM-\tMEDIUM FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.LRG\tS\t*\tG\t*\tEVCFH-\tLARGE/HEAVY FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nWAR.GRDTRK.EQT.GRDVEH.PKAN\tS\t*\tG\t*\tEVM---\tPACK ANIMAL(S)\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT\tS\t*\tG\t*\tEVS---\tMISSILE SUPPORT VEHICLE\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT.TLDR\tS\t*\tG\t*\tEVST--\tMISSILE SUPPORT VEHICLE TRANSLOADER\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT.TPTR\tS\t*\tG\t*\tEVSR--\tMISSILE SUPPORT VEHICLE TRANSPORTER\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT.CRN\tS\t*\tG\t*\tEVSC--\tMISSILE SUPPORT VEHICLE CRANE/LOADING DEVICE\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT.PLNT\tS\t*\tG\t*\tEVSP--\tMISSILE SUPPORT VEHICLE PROPELLANT TRANSPORTER\t\nWAR.GRDTRK.EQT.GRDVEH.MSLSPT.WH\tS\t*\tG\t*\tEVSW--\tMISSILE SUPPORT VEHICLE WARHEAD TRANSPORTER\t\nWAR.GRDTRK.EQT.SNS\tS\t*\tG\t*\tES----\tSENSOR\t\nWAR.GRDTRK.EQT.SNS.RAD\tS\t*\tG\t*\tESR---\tRADAR\t\nWAR.GRDTRK.EQT.SNS.EMP\tS\t*\tG\t*\tESE---\tEMPLACED SENSOR\t\nWAR.GRDTRK.EQT.SPL\tS\t*\tG\t*\tEX----\tSPECIAL EQUIPMENT\tN/A\nWAR.GRDTRK.EQT.SPL.LSR\tS\t*\tG\t*\tEXL---\tLASER\t\nWAR.GRDTRK.EQT.SPL.NBCEQT\tS\t*\tG\t*\tEXN---\tNBC EQUIPMENT\t\nWAR.GRDTRK.EQT.SPL.FLMTHR\tS\t*\tG\t*\tEXF---\tFLAME THROWER\t\nWAR.GRDTRK.EQT.SPL.LNDMNE\tS\t*\tG\t*\tEXM---\tLAND MINES\t\nWAR.GRDTRK.EQT.SPL.LNDMNE.CLM\tS\t*\tG\t*\tEXMC--\tCLAYMORE\t\nWAR.GRDTRK.EQT.SPL.LNDMNE.LTL\tS\t*\tG\t*\tEXML--\tLESS THAN LETHAL\t\nWAR.GRDTRK.INS\tS\t*\tG\t*\tI-----\tINSTALLATION\t\nWAR.GRDTRK.INS.RMP\tS\t*\tG\t*\tIR----\tRAW MATERIAL PRODUCTION/STORAGE\t\nWAR.GRDTRK.INS.RMP.MNE\tS\t*\tG\t*\tIRM---\tMINE\t\nWAR.GRDTRK.INS.RMP.PGO\tS\t*\tG\t*\tIRP---\tPETROLEUM/GAS/OIL\t\nWAR.GRDTRK.INS.RMP.NBC\tS\t*\tG\t*\tIRN---\tNBC\t\nWAR.GRDTRK.INS.RMP.NBC.BIO\tS\t*\tG\t*\tIRNB--\tBIOLOGICAL\t\nWAR.GRDTRK.INS.RMP.NBC.CML\tS\t*\tG\t*\tIRNC--\tCHEMICAL\t\nWAR.GRDTRK.INS.RMP.NBC.NUC\tS\t*\tG\t*\tIRNN--\tNUCLEAR\t\nWAR.GRDTRK.INS.PF\tS\t*\tG\t*\tIP----\tPROCESSING FACILITY\t\nWAR.GRDTRK.INS.PF.DECON\tS\t*\tG\t*\tIPD---\tDECONTAMINATION\t\nWAR.GRDTRK.INS.EQTMNF\tS\t*\tG\t*\tIE----\tEQUIPMENT MANUFACTURE\t\nWAR.GRDTRK.INS.SRUF\tS\t*\tG\t*\tIU----\tSERVICE, RESEARCH, UTILITY FACILITY\t\nWAR.GRDTRK.INS.SRUF.TRF\tS\t*\tG\t*\tIUR---\tTECHNOLOGICAL RESEARCH FACILITY\t\nWAR.GRDTRK.INS.SRUF.TCF\tS\t*\tG\t*\tIUT---\tTELECOMMUNICATIONS FACILITY\t\nWAR.GRDTRK.INS.SRUF.EPF\tS\t*\tG\t*\tIUE---\tELECTRIC POWER FACILITY\t\nWAR.GRDTRK.INS.SRUF.EPF.NPT\tS\t*\tG\t*\tIUEN--\tNUCLEAR PLANT\t\nWAR.GRDTRK.INS.SRUF.EPF.DAM\tS\t*\tG\t*\tIUED--\tDAM\t\nWAR.GRDTRK.INS.SRUF.EPF.FOSF\tS\t*\tG\t*\tIUEF--\tFOSSIL FUEL\t\nWAR.GRDTRK.INS.SRUF.PWS\tS\t*\tG\t*\tIUP---\tPUBLIC WATER SERVICES\t\nWAR.GRDTRK.INS.MMF\tS\t*\tG\t*\tIM----\tMILITARY MATERIEL FACILITY\t\nWAR.GRDTRK.INS.MMF.NENY\tS\t*\tG\t*\tIMF---\tNUCLEAR ENERGY\t\nWAR.GRDTRK.INS.MMF.NENY.ATMER\tS\t*\tG\t*\tIMFA--\tATOMIC ENERGY REACTOR\t\nWAR.GRDTRK.INS.MMF.NENY.NMP\tS\t*\tG\t*\tIMFP--\tNUCLEAR MATERIAL PRODUCTION\t\nWAR.GRDTRK.INS.MMF.NENY.NMP.WPNGR\tS\t*\tG\t*\tIMFPW-\tWEAPONS GRADE\t\nWAR.GRDTRK.INS.MMF.NENY.NMS\tS\t*\tG\t*\tIMFS--\tNUCLEAR MATERIAL STORAGE\t\nWAR.GRDTRK.INS.MMF.APA\tS\t*\tG\t*\tIMA---\tAIRCRAFT PRODUCTION & ASSEMBLY\t\nWAR.GRDTRK.INS.MMF.AMEP\tS\t*\tG\t*\tIME---\tAMMUNITION AND EXPLOSIVES PRODUCTION\t\nWAR.GRDTRK.INS.MMF.AMTP\tS\t*\tG\t*\tIMG---\tARMAMENT PRODUCTION\t\nWAR.GRDTRK.INS.MMF.MILVP\tS\t*\tG\t*\tIMV---\tMILITARY VEHICLE PRODUCTION\t\nWAR.GRDTRK.INS.MMF.ENGEP\tS\t*\tG\t*\tIMN---\tENGINEERING EQUIPMENT PRODUCTION\t\nWAR.GRDTRK.INS.MMF.ENGEP.BRG\tS\t*\tG\t*\tIMNB--\tBRIDGE\t\nWAR.GRDTRK.INS.MMF.CBWP\tS\t*\tG\t*\tIMC---\tCHEMICAL & BIOLOGICAL WARFARE PRODUCTION\t\nWAR.GRDTRK.INS.MMF.SHPCSN\tS\t*\tG\t*\tIMS---\tSHIP CONSTRUCTION\t\nWAR.GRDTRK.INS.MMF.MSSP\tS\t*\tG\t*\tIMM---\tMISSILE & SPACE SYSTEM PRODUCTION\t\nWAR.GRDTRK.INS.GOVLDR\tS\t*\tG\t*\tIG----\tGOVERNMENT LEADERSHIP\t\nWAR.GRDTRK.INS.MILBF\tS\t*\tG\t*\tIB----\tMILITARY BASE/FACILITY\t\nWAR.GRDTRK.INS.MILBF.AB\tS\t*\tG\t*\tIBA---\tAIRPORT/AIRBASE\t\nWAR.GRDTRK.INS.MILBF.SP\tS\t*\tG\t*\tIBN---\tSEAPORT/NAVAL BASE\t\nWAR.GRDTRK.INS.TSPF\tS\t*\tG\t*\tIT----\tTRANSPORT FACILITY\t\nWAR.GRDTRK.INS.MEDF\tS\t*\tG\t*\tIX----\tMEDICAL FACILITY\t\nWAR.GRDTRK.INS.MEDF.HSP\tS\t*\tG\t*\tIXH---\tHOSPITAL\t\n";

  var mil_std_2525b_sea_surface = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.SSUF\tS\t*\tS\t*\t------\tSEA SURFACE TRACK\t\nWAR.SSUF.CBTT\tS\t*\tS\t*\tC-----\tCOMBATANT\t\nWAR.SSUF.CBTT.LNE\tS\t*\tS\t*\tCL----\tLINE\t\nWAR.SSUF.CBTT.LNE.CRR\tS\t*\tS\t*\tCLCV--\tCARRIER\t\nWAR.SSUF.CBTT.LNE.BBS\tS\t*\tS\t*\tCLBB--\tBATTLESHIP\t\nWAR.SSUF.CBTT.LNE.CRU\tS\t*\tS\t*\tCLCC--\tCRUISER\t\nWAR.SSUF.CBTT.LNE.DD\tS\t*\tS\t*\tCLDD--\tDESTROYER\t\nWAR.SSUF.CBTT.LNE.FFR\tS\t*\tS\t*\tCLFF--\tFRIGATE/CORVETTE\t\nWAR.SSUF.CBTT.LNE.LL\tS\t*\tS\t*\tCLLL--\tLITTORAL COMBATANT\t\nWAR.SSUF.CBTT.LNE.LL.ASBW\tS\t*\tS\t*\tCLLLAS\tANTISUBMARINE WARFARE MISSION PACKAGE\t\nWAR.SSUF.CBTT.LNE.LL.MNEW\tS\t*\tS\t*\tCLLLMI\tMINE WARFARE MISSION PACKAGE\t\nWAR.SSUF.CBTT.LNE.LL.SUW\tS\t*\tS\t*\tCLLLSU\tSURFACE WARFARE (SUW) MISSION PACKAGE\t\nWAR.SSUF.CBTT.AMPWS\tS\t*\tS\t*\tCA----\tAMPHIBIOUS WARFARE SHIP\t\nWAR.SSUF.CBTT.AMPWS.ASTVES\tS\t*\tS\t*\tCALA--\tASSAULT VESSEL\t\nWAR.SSUF.CBTT.AMPWS.LNDSHP\tS\t*\tS\t*\tCALS--\tLANDING SHIP\t\nWAR.SSUF.CBTT.AMPWS.LNDSHP.MDM\tS\t*\tS\t*\tCALSM-\tLANDING SHIP MEDIUM\t\nWAR.SSUF.CBTT.AMPWS.LNDSHP.TANK\tS\t*\tS\t*\tCALST-\tLANDING SHIP TANK\t\nWAR.SSUF.CBTT.AMPWS.LNDCRT\tS\t*\tS\t*\tCALC--\tLANDING CRAFT\t\nWAR.SSUF.CBTT.MNEWV\tS\t*\tS\t*\tCM----\tMINE WARFARE VESSEL\t\nWAR.SSUF.CBTT.MNEWV.MNELYR\tS\t*\tS\t*\tCMML--\tMINELAYER\t\nWAR.SSUF.CBTT.MNEWV.MNESWE\tS\t*\tS\t*\tCMMS--\tMINESWEEPER\t\nWAR.SSUF.CBTT.MNEWV.MNEHNT\tS\t*\tS\t*\tCMMH--\tMINEHUNTER\t\nWAR.SSUF.CBTT.MNEWV.MCMSUP\tS\t*\tS\t*\tCMMA--\tMCM SUPPORT\t\nWAR.SSUF.CBTT.PAT\tS\t*\tS\t*\tCP----\tPATROL\t\nWAR.SSUF.CBTT.PAT.ASBW\tS\t*\tS\t*\tCPSB--\tANTISUBMARINE WARFARE\t\nWAR.SSUF.CBTT.PAT.ASUW\tS\t*\tS\t*\tCPSU--\tANTISURFACE WARFARE\t\nWAR.SSUF.CBTT.PAT.ASUW.ASMSL\tS\t*\tS\t*\tCPSUM-\tANTI-SHIP MISSILE PATROL CRAFT\t\nWAR.SSUF.CBTT.PAT.ASUW.TPD\tS\t*\tS\t*\tCPSUT-\tTORPEDO PATROL CRAFT\t\nWAR.SSUF.CBTT.PAT.ASUW.GUN\tS\t*\tS\t*\tCPSUG-\tGUN PATROL CRAFT\t\nWAR.SSUF.CBTT.HOV\tS\t*\tS\t*\tCH----\tHOVERCRAFT\t\nWAR.SSUF.CBTT.STN\tS\t*\tS\t*\tS-----\tSTATION\t\nWAR.SSUF.CBTT.STN.PKT\tS\t*\tS\t*\tSP----\tPICKET\t\nWAR.SSUF.CBTT.STN.ASWSHP\tS\t*\tS\t*\tSA----\tASW SHIP\t\nWAR.SSUF.CBTT.NAVGRP\tS\t*\tS\t*\tG-----\tNAVY GROUP\t\nWAR.SSUF.CBTT.NAVGRP.NAVTF\tS\t*\tS\t*\tGT----\tNAVY TASK FORCE\t\nWAR.SSUF.CBTT.NAVGRP.NAVTG\tS\t*\tS\t*\tGG----\tNAVY TASK GROUP\t\nWAR.SSUF.CBTT.NAVGRP.NAVTU\tS\t*\tS\t*\tGU----\tNAVY TASK UNIT\t\nWAR.SSUF.CBTT.NAVGRP.CNY\tS\t*\tS\t*\tGC----\tCONVOY\t\nWAR.SSUF.CBTT.SUFDCY\tS\t*\tS\t*\tCD----\tSURFACE DECOY\t\nWAR.SSUF.CBTT.USV\tS\t*\tS\t*\tCU----\tUNMANNED SURFACE VEHICLE\t\nWAR.SSUF.CBTT.USV.MNECM\tS\t*\tS\t*\tCUM---\tMINE COUNTERMEASURES SURFACE DRONE\t\nWAR.SSUF.CBTT.USV.ASBW\tS\t*\tS\t*\tCUS---\tANTISUBMARINE WARFARE SURFACE DRONE\t\nWAR.SSUF.CBTT.USV.ASUW\tS\t*\tS\t*\tCUN---\tANTISURFACE WARFARE SURFACE DRONE\t\nWAR.SSUF.NCBTT\tS\t*\tS\t*\tN-----\tNONCOMBATANT\t\nWAR.SSUF.NCBTT.UWRPM\tS\t*\tS\t*\tNR----\tUNDERWAY REPLENISHMENT\t\nWAR.SSUF.NCBTT.FLTSUP\tS\t*\tS\t*\tNF----\tFLEET SUPPORT\t\nWAR.SSUF.NCBTT.INT\tS\t*\tS\t*\tNI----\tINTELLIGENCE\t\nWAR.SSUF.NCBTT.SSH\tS\t*\tS\t*\tNS----\tSERVICE & SUPPORT HARBOR\t\nWAR.SSUF.NCBTT.HSPSHP\tS\t*\tS\t*\tNM----\tHOSPITAL SHIP\t\nWAR.SSUF.NCBTT.HOV\tS\t*\tS\t*\tNH----\tHOVERCRAFT\t\nWAR.SSUF.NCBTT.STN\tS\t*\tS\t*\tNN----\tSTATION\t\nWAR.SSUF.NCBTT.STN.RSC\tS\t*\tS\t*\tNNR---\tRESCUE\t\nWAR.SSUF.NMIL\tS\t*\tS\t*\tX-----\tNON-MILITARY\tN/A\nWAR.SSUF.NMIL.MCT\tS\t*\tS\t*\tXM----\tMERCHANT\t\nWAR.SSUF.NMIL.MCT.CGO\tS\t*\tS\t*\tXMC---\tCARGO\t\nWAR.SSUF.NMIL.MCT.RORO\tS\t*\tS\t*\tXMR---\tROLL ON/ROLL OFF\t\nWAR.SSUF.NMIL.MCT.OLR\tS\t*\tS\t*\tXMO---\tOILER/TANKER\t\nWAR.SSUF.NMIL.MCT.TUG\tS\t*\tS\t*\tXMTU--\tTUG\t\nWAR.SSUF.NMIL.MCT.FRY\tS\t*\tS\t*\tXMF---\tFERRY\t\nWAR.SSUF.NMIL.MCT.PSG\tS\t*\tS\t*\tXMP---\tPASSENGER\t\nWAR.SSUF.NMIL.MCT.HAZMAT\tS\t*\tS\t*\tXMH---\tHAZARDOUS MATERIALS (HAZMAT)\t\nWAR.SSUF.NMIL.MCT.TOWVES\tS\t*\tS\t*\tXMTO--\tTOWING VESSEL\t\nWAR.SSUF.NMIL.FSG\tS\t*\tS\t*\tXF----\tFISHING\t\nWAR.SSUF.NMIL.FSG.DRFT\tS\t*\tS\t*\tXFDF--\tDRIFTER\t\nWAR.SSUF.NMIL.FSG.DRG\tS\t*\tS\t*\tXFDR--\tDREDGE\t\nWAR.SSUF.NMIL.FSG.TRW\tS\t*\tS\t*\tXFTR--\tTRAWLER\t\nWAR.SSUF.NMIL.LESCRT\tS\t*\tS\t*\tXR----\tLEISURE CRAFT\t\nWAR.SSUF.NMIL.LAWENV\tS\t*\tS\t*\tXL----\tLAW ENFORCEMENT VESSEL\t\nWAR.SSUF.NMIL.HOV\tS\t*\tS\t*\tXH----\tHOVERCRAFT\t\nWAR.SSUF.OWN\tS\t*\tS\t*\tO-----\tOWN TRACK\t\n";

  var mil_std_2525b_sub_surface = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.SBSUF\tS\t*\tU\t*\t------\tSUBSURFACE TRACK\t\nWAR.SBSUF.SUB\tS\t*\tU\t*\tS-----\tSUBMARINE\t\nWAR.SBSUF.SUB.SURF\tS\t*\tU\t*\tSF----\tSURFACED SUBMARINE\t\nWAR.SBSUF.SUB.NPRN\tS\t*\tU\t*\tSN----\tNUCLEAR PROPULSION\t\nWAR.SBSUF.SUB.NPRN.SURF\tS\t*\tU\t*\tSNF---\tSURFACED NUCLEAR PROPULSION SUBMARINE\t\nWAR.SBSUF.SUB.NPRN.ATK\tS\t*\tU\t*\tSNA---\tATTACK SUBMARINE (SSN)\t\nWAR.SBSUF.SUB.NPRN.MSL\tS\t*\tU\t*\tSNM---\tMISSILE SUBMARINE (TYPE UNKNOWN)\t\nWAR.SBSUF.SUB.NPRN.GDD\tS\t*\tU\t*\tSNG---\tGUIDED MISSILE SUBMARINE (SSGN)\t\nWAR.SBSUF.SUB.NPRN.BLST\tS\t*\tU\t*\tSNB---\tBALLISTIC MISSILE SUBMARINE (SSBN)\t\nWAR.SBSUF.SUB.CNVPRN\tS\t*\tU\t*\tSC----\tCONVENTIONAL PROPULSION\t\nWAR.SBSUF.SUB.CNVPRN.SURF\tS\t*\tU\t*\tSCF---\tSURFACED CONVENTIONAL PROPULSION SUBMARINE\t\nWAR.SBSUF.SUB.CNVPRN.ATK\tS\t*\tU\t*\tSCA---\tATTACK SUBMARINE (SS)\t\nWAR.SBSUF.SUB.CNVPRN.MSL\tS\t*\tU\t*\tSCM---\tMISSILE SUBMARINE (TYPE UNKNOWN)\t\nWAR.SBSUF.SUB.CNVPRN.GDD\tS\t*\tU\t*\tSCG---\tGUIDED MISSILE SUBMARINE (SSG)\t\nWAR.SBSUF.SUB.CNVPRN.BLST\tS\t*\tU\t*\tSCB---\tBALLISTIC MISSILE SUBMARINE (SSB)\t\nWAR.SBSUF.SUB.OTH\tS\t*\tU\t*\tSO----\tOTHER SUBMERSIBLE\t\nWAR.SBSUF.SUB.OTH.SURF\tS\t*\tU\t*\tSOF---\tSURFACED OTHER SUBMERSIBLE\t\nWAR.SBSUF.SUB.STN\tS\t*\tU\t*\tSS----\tSTATION\t\nWAR.SBSUF.SUB.STN.ASWSUB\tS\t*\tU\t*\tSSA---\tASW SUBMARINE\t\nWAR.SBSUF.SUB.UUV\tS\t*\tU\t*\tSU----\tUNMANNED UNDERWATER VEHICLE (UUV)\t\nWAR.SBSUF.SUB.UUV.MNEW\tS\t*\tU\t*\tSUM---\tMINE WARFARE SUBSURFACE DRONE\t\nWAR.SBSUF.SUB.UUV.ASBW\tS\t*\tU\t*\tSUS---\tANTISUBMARINE WARFARE SUBSURFACE DRONE\t\nWAR.SBSUF.SUB.UUV.ASUW\tS\t*\tU\t*\tSUN---\tANTISURFACE WARFARE SUBSURFACE DRONE\t\nWAR.SBSUF.UH2WPN\tS\t*\tU\t*\tW-----\tUNDERWATER WEAPON\t\nWAR.SBSUF.UH2WPN.TPD\tS\t*\tU\t*\tWT----\tTORPEDO\t\nWAR.SBSUF.UH2WPN.SMNE\tS\t*\tU\t*\tWM----\tSEA MINE\t\nWAR.SBSUF.UH2WPN.SMNE.DLT\tS\t*\tU\t*\tWMD---\tSEA MINE DEALT\t\nWAR.SBSUF.UH2WPN.SMNE.SMG\tS\t*\tU\t*\tWMG---\tSEA MINE (GROUND)\t\nWAR.SBSUF.UH2WPN.SMNE.SMG.DLT\tS\t*\tU\t*\tWMGD--\tSEA MINE (GROUND) DEALT\t\nWAR.SBSUF.UH2WPN.SMNE.SMM\tS\t*\tU\t*\tWMM---\tSEA MINE (MOORED)\t\nWAR.SBSUF.UH2WPN.SMNE.SMM.DLT\tS\t*\tU\t*\tWMMD--\tSEA MINE (MOORED) DEALT\t\nWAR.SBSUF.UH2WPN.SMNE.SMF\tS\t*\tU\t*\tWMF---\tSEA MINE (FLOATING)\t\nWAR.SBSUF.UH2WPN.SMNE.SMF.DLT\tS\t*\tU\t*\tWMFD--\tSEA MINE (FLOATING) DEALT\t\nWAR.SBSUF.UH2WPN.SMNE.SMOP\tS\t*\tU\t*\tWMO---\tSEA MINE (OTHER POSITION)\t\nWAR.SBSUF.UH2WPN.SMNE.SMOP.DLT\tS\t*\tU\t*\tWMOD--\tSEA MINE (OTHER POSITION) DEALT\t\nWAR.SBSUF.UH2DCY\tS\t*\tU\t*\tWD----\tUNDERWATER DECOY\t\nWAR.SBSUF.UH2DCY.SMDCY\tS\t*\tU\t*\tWDM---\tSEA MINE DECOY\t\nWAR.SBSUF.NSUB\tS\t*\tU\t*\tN-----\tNON-SUBMARINE\tN/A\nWAR.SBSUF.NSUB.DVR\tS\t*\tU\t*\tND----\tDIVER\t\n";

  var mil_std_2525b_sof = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nWAR.SOFUNT\tS\t*\tF\t*\t------\tSPECIAL OPERATIONS FORCES (SOF) UNIT\t\nWAR.SOFUNT.AVN\tS\t*\tF\t*\tA-----\tSOF UNIT AVIATION\t\nWAR.SOFUNT.AVN.FIXD\tS\t*\tF\t*\tAF----\tSOF UNIT FIXED WING\t\nWAR.SOFUNT.AVN.FIXD.ATK\tS\t*\tF\t*\tAFA---\tSOF UNIT ATTACK\t\nWAR.SOFUNT.AVN.FIXD.RFE\tS\t*\tF\t*\tAFK---\tSOF UNIT REFUEL\t\nWAR.SOFUNT.AVN.FIXD.UTY\tS\t*\tF\t*\tAFU---\tSOF UNIT UTILITY\t\nWAR.SOFUNT.AVN.FIXD.UTY.LIT\tS\t*\tF\t*\tAFUL--\tSOF UNIT UTILITY (LIGHT)\t\nWAR.SOFUNT.AVN.FIXD.UTY.MDM\tS\t*\tF\t*\tAFUM--\tSOF UNIT UTILITY (MEDIUM)\t\nWAR.SOFUNT.AVN.FIXD.UTY.HVY\tS\t*\tF\t*\tAFUH--\tSOF UNIT UTILITY (HEAVY)\t\nWAR.SOFUNT.AVN.VSTOL\tS\t*\tF\t*\tAV----\tSOF UNIT V/STOL\t\nWAR.SOFUNT.AVN.ROT\tS\t*\tF\t*\tAH----\tSOF UNIT ROTARY WING\t\nWAR.SOFUNT.AVN.ROT.CSAR\tS\t*\tF\t*\tAHH---\tSOF UNIT COMBAT SEARCH AND RESCUE\t\nWAR.SOFUNT.AVN.ROT.ATK\tS\t*\tF\t*\tAHA---\tSOF UNIT ATTACK\t\nWAR.SOFUNT.AVN.ROT.UTY\tS\t*\tF\t*\tAHU---\tSOF UNIT UTILITY\t\nWAR.SOFUNT.AVN.ROT.UTY.LIT\tS\t*\tF\t*\tAHUL--\tSOF UNIT UTILITY (LIGHT)\t\nWAR.SOFUNT.AVN.ROT.UTY.MDM\tS\t*\tF\t*\tAHUM--\tSOF UNIT UTILITY (MEDIUM)\t\nWAR.SOFUNT.AVN.ROT.UTY.HVY\tS\t*\tF\t*\tAHUH--\tSOF UNIT UTILITY (HEAVY)\t\nWAR.SOFUNT.NAV\tS\t*\tF\t*\tN-----\tSOF UNIT SOF UNIT NAVAL\t\nWAR.SOFUNT.NAV.SEAL\tS\t*\tF\t*\tNS----\tSOF UNIT SEAL\t\nWAR.SOFUNT.NAV.UH2DML\tS\t*\tF\t*\tNU----\tSOF UNIT UNDERWATER DEMOLITION TEAM\t\nWAR.SOFUNT.NAV.SBT\tS\t*\tF\t*\tNB----\tSOF UNIT SPECIAL BOAT\t\nWAR.SOFUNT.NAV.SSSNR\tS\t*\tF\t*\tNN----\tSOF UNIT SPECIAL SSNR\t\nWAR.SOFUNT.GRD\tS\t*\tF\t*\tG-----\tSOF UNIT GROUND\t\nWAR.SOFUNT.GRD.SOF\tS\t*\tF\t*\tGS----\tSOF UNIT SPECIAL FORCES\t\nWAR.SOFUNT.GRD.RGR\tS\t*\tF\t*\tGR----\tSOF UNIT RANGER\t\nWAR.SOFUNT.GRD.PSYOP\tS\t*\tF\t*\tGP----\tSOF UNIT PSYCHOLOGICAL OPERATIONS (PSYOP)\t\nWAR.SOFUNT.GRD.PSYOP.FIXAVN\tS\t*\tF\t*\tGPA---\tSOF UNIT FIXED WING AVIATION\t\nWAR.SOFUNT.GRD.CVLAFF\tS\t*\tF\t*\tGC----\tSOF UNIT CIVIL AFFAIRS\t\nWAR.SOFUNT.SUP\tS\t*\tF\t*\tB-----\tSOF UNIT SUPPORT\t";

  var mil_std_2525b_tactical_graphics = "geometry\thierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\r\n\tTACGRP\tG\t*\t-\t-------\tTACTICAL GRAPHICS\t\t\r\n\tTACGRP.TSK\tG\t*\tT\t*\t------\tTASKS\tN/A\r\n\tTACGRP.TSK.BLK\tG\t*\tT\t*\tB-----\tBLOCK\t\r\n\tTACGRP.TSK.BRH\tG\t*\tT\t*\tH-----\tBREACH\t\r\n\tTACGRP.TSK.BYS\tG\t*\tT\t*\tY-----\tBYPASS\t\r\n\tTACGRP.TSK.CNZ\tG\t*\tT\t*\tC-----\tCANALIZE\t\r\n\tTACGRP.TSK.CLR\tG\t*\tT\t*\tX-----\tCLEAR\t\r\n\tTACGRP.TSK.CNT\tG\t*\tT\t*\tJ-----\tCONTAIN\t\r\n\tTACGRP.TSK.CATK\tG\t*\tT\t*\tK-----\tCOUNTERATTACK (CATK)\t\r\n\tTACGRP.TSK.CATK.CATKF\tG\t*\tT\t*\tKF----\tCOUNTERATTACK BY FIRE\t\r\n\tTACGRP.TSK.DLY\tG\t*\tT\t*\tL-----\tDELAY\t\r\nPOINT\tTACGRP.TSK.DSTY\tG\t*\tT\t*\tD-----\tDESTROY\t\r\n\tTACGRP.TSK.DRT\tG\t*\tT\t*\tT-----\tDISRUPT\t\r\n\tTACGRP.TSK.FIX\tG\t*\tT\t*\tF-----\tFIX\t\r\n\tTACGRP.TSK.FLWASS\tG\t*\tT\t*\tA-----\tFOLLOW AND ASSUME\t\r\n\tTACGRP.TSK.FLWASS.FLWSUP\tG\t*\tT\t*\tAS----\tFOLLOW AND SUPPORT\t\r\nPOINT\tTACGRP.TSK.ITDT\tG\t*\tT\t*\tI-----\tINTERDICT\t\r\n\tTACGRP.TSK.ISL\tG\t*\tT\t*\tE-----\tISOLATE\t\r\nPOINT\tTACGRP.TSK.NEUT\tG\t*\tT\t*\tN-----\tNEUTRALIZE\t\r\n\tTACGRP.TSK.OCC\tG\t*\tT\t*\tO-----\tOCCUPY\t\r\n\tTACGRP.TSK.PNE\tG\t*\tT\t*\tP-----\tPENETRATE\t\r\n\tTACGRP.TSK.RIP\tG\t*\tT\t*\tR-----\tRELIEF IN PLACE (RIP)\t\r\n\tTACGRP.TSK.RTN\tG\t*\tT\t*\tQ-----\tRETAIN\t\r\n\tTACGRP.TSK.RTM\tG\t*\tT\t*\tM-----\tRETIREMENT\t\r\n\tTACGRP.TSK.SCE\tG\t*\tT\t*\tS-----\tSECURE\t\r\n\tTACGRP.TSK.SEC\tG\t-\tT\t*\tU-----\tSECURITY\tN/A\r\n\tTACGRP.TSK.SEC.SCN\tG\t*\tT\t*\tUS----\tSCREEN\t\r\n\tTACGRP.TSK.SEC.GUD\tG\t*\tT\t*\tUG----\tGUARD\t\r\n\tTACGRP.TSK.SEC.COV\tG\t*\tT\t*\tUC----\tCOVER\t\r\n\tTACGRP.TSK.SZE\tG\t*\tT\t*\tZ-----\tSEIZE\t\r\n\tTACGRP.TSK.WDR\tG\t*\tT\t*\tW-----\tWITHDRAW\t\r\n\tTACGRP.TSK.WDR.WDRUP\tG\t*\tT\t*\tWP----\tWITHDRAW UNDER PRESSURE\t\r\n\tTACGRP.C2GM\tG\t*\tG\t*\t------\tCOMMAND AND CONTROL AND GENERAL MANEUVER\tN/A\r\n\tTACGRP.C2GM.GNL\tG\t*\tG\t*\tG-----\tGENERAL\tN/A\r\n\tTACGRP.C2GM.GNL.PNT\tG\t*\tG\t*\tGP----\tPOINTS\tN/A\r\n\tTACGRP.C2GM.GNL.PNT.USW\tG\t*\tG\t*\tGPU---\tUNDER SEA WARFARE\tN/A\r\n\tTACGRP.C2GM.GNL.PNT.USW.UH2\tG\t*\tG\t*\tGPUU--\tUNDERWATER\tN/A\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.DTM\tG\t*\tG\t*\tGPUUD-\tDATUM\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.BCON\tG\t*\tG\t*\tGPUUB-\tBRIEF CONTACT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.LCON\tG\t*\tG\t*\tGPUUL-\tLOST CONTACT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.SNK\tG\t*\tG\t*\tGPUUS-\tSINKER\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY\tG\t*\tG\t*\tGPUY--\tSONOBUOY\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.PTNCTR\tG\t*\tG\t*\tGPUYP-\tPATTERN CENTER\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.DIFAR\tG\t*\tG\t*\tGPUYD-\tDIRECTIONAL FREQUENCY ANALYZING AND RECORDING (DIFAR)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.LOFAR\tG\t*\tG\t*\tGPUYL-\tLOW FREQUENCY ANALYZING AND RECORDING (LOFAR)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.CASS\tG\t*\tG\t*\tGPUYC-\tCOMMAND ACTIVE SONOBUOY SYSTEM (CASS)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.DICASS\tG\t*\tG\t*\tGPUYS-\tDIRECTIONAL COMMAND ACTIVE SONOBUOY SYSTEM (DICASS)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.BT\tG\t*\tG\t*\tGPUYB-\tBATHYTHERMOGRAPH TRANSMITTING (BT)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.ANM\tG\t*\tG\t*\tGPUYA-\tANM\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.VLAD\tG\t*\tG\t*\tGPUYV-\tVERTICAL LINE ARRAY DIFAR (VLAD)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.ATAC\tG\t*\tG\t*\tGPUYT-\tATAC\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.RO\tG\t*\tG\t*\tGPUYR-\tRANGE ONLY (RO)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.KGP\tG\t*\tG\t*\tGPUYK-\tKINGPIN\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH\tG\t*\tG\t*\tGPUS--\tSEARCH\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.ARA\tG\t*\tG\t*\tGPUSA-\tSEARCH AREA\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.DIPPSN\tG\t*\tG\t*\tGPUSD-\tDIP POSITION\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.CTR\tG\t*\tG\t*\tGPUSC-\tSEARCH CENTER\t\r\n\tTACGRP.C2GM.GNL.PNT.REFPNT\tG\t*\tG\t*\tGPR---\tREFERENCE POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.SPLPNT\tG\t*\tG\t*\tGPRS--\tSPECIAL POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.NAVREF\tG\t*\tG\t*\tGPRN--\tNAV REFERENCE\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.DLRP\tG\t*\tG\t*\tGPRD--\tDLRP\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.PNTINR\tG\t*\tG\t*\tGPRI--\tPOINT OF INTEREST\t\r\n\tTACGRP.C2GM.GNL.PNT.WPN\tG\t*\tG\t*\tGPW---\tWEAPON\tN/A\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.AIMPNT\tG\t*\tG\t*\tGPWA--\tAIM POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.DRPPNT\tG\t*\tG\t*\tGPWD--\tDROP POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.ENTPNT\tG\t*\tG\t*\tGPWE--\tENTRY POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.GRDZRO\tG\t*\tG\t*\tGPWG--\tGROUND ZERO\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.MSLPNT\tG\t*\tG\t*\tGPWM--\tMSL DETECT POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.IMTPNT\tG\t*\tG\t*\tGPWI--\tIMPACT POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.PIPNT\tG\t*\tG\t*\tGPWP--\tPREDICTED IMPACT POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.FRMN\tG\t*\tG\t*\tGPF---\tFORMATION\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR\tG\t*\tG\t*\tGPH---\tHARBOR (GENERAL)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTQ\tG\t*\tG\t*\tGPHQ--\tPOINT Q\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTA\tG\t*\tG\t*\tGPHA--\tPOINT A\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTY\tG\t*\tG\t*\tGPHY--\tPOINT Y\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTX\tG\t*\tG\t*\tGPHX--\tPOINT X\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE\tG\t*\tG\t*\tGPO---\tROUTE\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.RDV\tG\t*\tG\t*\tGPOZ--\tRENDEZVOUS\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.DVSN\tG\t*\tG\t*\tGPOD--\tDIVERSIONS\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.WAP\tG\t*\tG\t*\tGPOW--\tWAYPOINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.PIM\tG\t*\tG\t*\tGPOP--\tPIM\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.PNTR\tG\t*\tG\t*\tGPOR--\tPOINT R\t\r\n\tTACGRP.C2GM.GNL.PNT.ACTL\tG\t*\tG\t*\tGPA---\tAIR CONTROL\tN/A\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.CAP\tG\t*\tG\t*\tGPAP--\tCOMBAT AIR PATROL (CAP)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ABNEW\tG\t*\tG\t*\tGPAW--\tAIRBORNE EARLY WARNING (AEW)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TCN\tG\t*\tG\t*\tGPAT--\tTACAN\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TAK\tG\t*\tG\t*\tGPAK--\tTANKING\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ASBWF\tG\t*\tG\t*\tGPAA--\tANTISUBMARINE WARFARE, FIXED WING\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ASBWR\tG\t*\tG\t*\tGPAH--\tANTISUBMARINE WARFARE, ROTARY WING\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TMC\tG\t*\tG\t*\tGPAO--\tTOMCAT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.RSC\tG\t*\tG\t*\tGPAR--\tRESCUE\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.RPH\tG\t*\tG\t*\tGPAL--\tREPLENISH\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.MRSH\tG\t*\tG\t*\tGPAM--\tMARSHALL\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.SKEIP\tG\t*\tG\t*\tGPAS--\tSTRIKE IP\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.CRDRTB\tG\t*\tG\t*\tGPAC--\tCORRIDOR TAB\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT\tG\t*\tG\t*\tGPP---\tACTION POINTS (GENERAL)\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CHKPNT\tG\t*\tG\t*\tGPPK--\tCHECK POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CONPNT\tG\t*\tG\t*\tGPPC--\tCONTACT POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CRDPNT\tG\t*\tG\t*\tGPPO--\tCOORDINATION POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.DCNPNT\tG\t*\tG\t*\tGPPD--\tDECISION POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.LNKUPT\tG\t*\tG\t*\tGPPL--\tLINKUP POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.PSSPNT\tG\t*\tG\t*\tGPPP--\tPASSAGE POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.RAYPNT\tG\t*\tG\t*\tGPPR--\tRALLY POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.RELPNT\tG\t*\tG\t*\tGPPE--\tRELEASE POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.STRPNT\tG\t*\tG\t*\tGPPS--\tSTART POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.AMNPNT\tG\t*\tG\t*\tGPPA--\tAMNESTY POINT\t\r\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.WAP\tG\t*\tG\t*\tGPPW--\tWAYPOINT\t\r\n\tTACGRP.C2GM.GNL.LNE\tG\t*\tG\t*\tGL----\tLINES\tN/A\r\n\tTACGRP.C2GM.GNL.LNE.BNDS\tG\t*\tG\t*\tGLB---\tBOUNDARIES\t\r\n\tTACGRP.C2GM.GNL.LNE.FLOT\tG\t*\tG\t*\tGLF---\tFORWARD LINE OF OWN TROOPS (FLOT)\t\r\n\tTACGRP.C2GM.GNL.LNE.LOC\tG\t*\tG\t*\tGLC---\tLINE OF CONTACT\t\r\n\tTACGRP.C2GM.GNL.LNE.PHELNE\tG\t*\tG\t*\tGLP---\tPHASE LINE\t\r\n\tTACGRP.C2GM.GNL.LNE.LITLNE\tG\t*\tG\t*\tGLL---\tLIGHT LINE\t\r\n\tTACGRP.C2GM.GNL.ARS\tG\t*\tG\t*\tGA----\tAREAS\tN/A\r\n\tTACGRP.C2GM.GNL.ARS.GENARA\tG\t*\tG\t*\tGAG---\tGENERAL AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.ABYARA\tG\t*\tG\t*\tGAA---\tASSEMBLY AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.EMTARA\tG\t*\tG\t*\tGAE---\tENGAGEMENT AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.FTFDAR\tG\t*\tG\t*\tGAF---\tFORTIFIED AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.DRPZ\tG\t*\tG\t*\tGAD---\tDROP ZONE\t\r\n\tTACGRP.C2GM.GNL.ARS.EZ\tG\t*\tG\t*\tGAX---\tEXTRACTION ZONE (EZ)\t\r\n\tTACGRP.C2GM.GNL.ARS.LZ\tG\t*\tG\t*\tGAL---\tLANDING ZONE (LZ)\t\r\n\tTACGRP.C2GM.GNL.ARS.PZ\tG\t*\tG\t*\tGAP---\tPICKUP ZONE (PZ)\t\r\n\tTACGRP.C2GM.GNL.ARS.SRHARA\tG\t*\tG\t*\tGAS---\tSEARCH AREA/RECONNAISSANCE AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.LAARA\tG\t*\tG\t*\tGAY---\tLIMITED ACCESS AREA\t\r\n\tTACGRP.C2GM.GNL.ARS.AIRFZ\tG\t*\tG\t*\tGAZ---\tAIRFIELD ZONE\t\r\n\tTACGRP.C2GM.AVN\tG\t*\tG\t*\tA-----\tAVIATION\tN/A\r\n\tTACGRP.C2GM.AVN.PNT\tG\t*\tG\t*\tAP----\tPOINTS\tN/A\r\nPOINT\tTACGRP.C2GM.AVN.PNT.ACP\tG\t*\tG\t*\tAPP---\tAIR CONTROL POINT (ACP)\t\r\nPOINT\tTACGRP.C2GM.AVN.PNT.COMMCP\tG\t*\tG\t*\tAPC---\tCOMMUNICATIONS CHECKPOINT (CCP)\t\r\nPOINT\tTACGRP.C2GM.AVN.PNT.PUP\tG\t*\tG\t*\tAPU---\tPULL-UP POINT (PUP)\t\r\nPOINT\tTACGRP.C2GM.AVN.PNT.DAPP\tG\t*\tG\t*\tAPD---\tDOWNED AIRCREW PICKUP POINT\t\r\n\tTACGRP.C2GM.AVN.LNE\tG\t*\tG\t*\tAL----\tLINES\tN/A\r\n\tTACGRP.C2GM.AVN.LNE.ACDR\tG\t*\tG\t*\tALC---\tAIR CORRIDOR\t\r\n\tTACGRP.C2GM.AVN.LNE.MRR\tG\t*\tG\t*\tALM---\tMINIMUM RISK ROUTE (MRR)\t\r\n\tTACGRP.C2GM.AVN.LNE.SAAFR\tG\t*\tG\t*\tALS---\tSTANDARD-USE ARMY AIRCRAFT FLIGHT ROUTE (SAAFR)\t\r\n\tTACGRP.C2GM.AVN.LNE.UAVR\tG\t*\tG\t*\tALU---\tUNMANNED AERIAL VEHICLE (UAV) ROUTE\t\r\n\tTACGRP.C2GM.AVN.LNE.LLTR\tG\t*\tG\t*\tALL---\tLOW LEVEL TRANSIT ROUTE (LLTR)\t\r\n\tTACGRP.C2GM.AVN.ARS\tG\t*\tG\t*\tAA----\tAREAS\tN/A\r\n\tTACGRP.C2GM.AVN.ARS.ROZ\tG\t*\tG\t*\tAAR---\tRESTRICTED OPERATIONS ZONE (ROZ)\t\r\n\tTACGRP.C2GM.AVN.ARS.FAADEZ\tG\t*\tG\t*\tAAF---\tFORWARD AREA AIR DEFENSE ZONE (FAADEZ)\t\r\n\tTACGRP.C2GM.AVN.ARS.HIDACZ\tG\t*\tG\t*\tAAH---\tHIGH DENSITY AIRSPACE CONTROL ZONE (HIDACZ)\t\r\n\tTACGRP.C2GM.AVN.ARS.MEZ\tG\t*\tG\t*\tAAM---\tMISSILE ENGAGEMENT ZONE (MEZ)\t\r\n\tTACGRP.C2GM.AVN.ARS.MEZ.LAMEZ\tG\t*\tG\t*\tAAML--\tLOW ALTITUDE MEZ\t\r\n\tTACGRP.C2GM.AVN.ARS.MEZ.HAMEZ\tG\t*\tG\t*\tAAMH--\tHIGH ALTITUDE MEZ\t\r\n\tTACGRP.C2GM.AVN.ARS.WFZ\tG\t*\tG\t*\tAAW---\tWEAPONS FREE ZONE\t\r\n\tTACGRP.C2GM.DCPN\tG\t*\tG\t*\tP-----\tDECEPTION\tN/A\r\n\tTACGRP.C2GM.DCPN.DMY\tG\t*\tG\t*\tPD----\tDUMMY (DECEPTION/DECOY)\t\r\n\tTACGRP.C2GM.DCPN.AAFF\tG\t*\tG\t*\tPA----\tAXIS OF ADVANCE FOR FEINT\t\r\n\tTACGRP.C2GM.DCPN.DAFF\tG\t*\tG\t*\tPF----\tDIRECTION OF ATTACK FOR FEINT\t\r\n\tTACGRP.C2GM.DCPN.DMA\tG\t*\tG\t*\tPM----\tDECOY MINED AREA\t\r\n\tTACGRP.C2GM.DCPN.DMAF\tG\t*\tG\t*\tPY----\tDECOY MINED AREA, FENCED\t\r\n\tTACGRP.C2GM.DCPN.DMYMS\tG\t*\tG\t*\tPN----\tDUMMY MINEFIELD (STATIC)\t\r\n\tTACGRP.C2GM.DCPN.DMYMD\tG\t*\tG\t*\tPC----\tDUMMY MINEFIELD (DYNAMIC)\t\r\n\tTACGRP.C2GM.DEF\tG\t*\tG\t*\tD-----\tDEFENSE\tN/A\r\n\tTACGRP.C2GM.DEF.PNT\tG\t*\tG\t*\tDP----\tPOINTS\tN/A\r\nPOINT\tTACGRP.C2GM.DEF.PNT.TGTREF\tG\t*\tG\t*\tDPT---\tTARGET REFERENCE POINT (TRP)\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST\tG\t*\tG\t*\tDPO---\tOBSERVATION POST/OUTPOST\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.CBTPST\tG\t*\tG\t*\tDPOC--\tCOMBAT OUTPOST\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.RECON\tG\t*\tG\t*\tDPOR--\tOBSERVATION POST OCCUPIED BY DISMOUNTED SCOUTS OR RECONNAISSANCE\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.FWDOP\tG\t*\tG\t*\tDPOF--\tFORWARD OBSERVER POSITION\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.SOP\tG\t*\tG\t*\tDPOS--\tSENSOR OUTPOST/LISTENING POST (OP/LP)\t\r\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.NBCOP\tG\t*\tG\t*\tDPON--\tNBC OBSERVATION POST (DISMOUNTED)\t\r\n\tTACGRP.C2GM.DEF.LNE\tG\t*\tG\t*\tDL----\tLINES\tN/A\r\n\tTACGRP.C2GM.DEF.LNE.FEBA\tG\t*\tG\t*\tDLF---\tFORWARD EDGE OF BATTLE AREA (FEBA)\t\r\n\tTACGRP.C2GM.DEF.LNE.PDF\tG\t*\tG\t*\tDLP---\tPRINCIPAL DIRECTION OF FIRE (PDF)\t\r\n\tTACGRP.C2GM.DEF.ARS\tG\t*\tG\t*\tDA----\tAREAS\tN/A\r\n\tTACGRP.C2GM.DEF.ARS.BTLPSN\tG\t*\tG\t*\tDAB---\tBATTLE POSITION\t\r\n\tTACGRP.C2GM.DEF.ARS.BTLPSN.PBNO\tG\t*\tG\t*\tDABP--\tPREPARED BUT NOT OCCUPIED\t\r\n\tTACGRP.C2GM.DEF.ARS.EMTARA\tG\t*\tG\t*\tDAE---\tENGAGEMENT AREA\t\r\n\tTACGRP.C2GM.OFF\tG\t*\tG\t*\tO-----\tOFFENSE\tN/A\r\n\tTACGRP.C2GM.OFF.PNT\tG\t*\tG\t*\tOP----\tPOINTS\tN/A\r\nPOINT\tTACGRP.C2GM.OFF.PNT.PNTD\tG\t*\tG\t*\tOPP---\tPOINT OF DEPARTURE\t\r\n\tTACGRP.C2GM.OFF.LNE\tG\t*\tG\t*\tOL----\tLINES\tN/A\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV\tG\t*\tG\t*\tOLA---\tAXIS OF ADVANCE\tN/A\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.AVN\tG\t*\tG\t*\tOLAV--\tAVIATION\t\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.ABN\tG\t*\tG\t*\tOLAA--\tAIRBORNE\t\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.ATK\tG\t*\tG\t*\tOLAR--\tATTACK, ROTARY WING\t\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD\tG\t*\tG\t*\tOLAG--\tGROUND\tN/A\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD.MANATK\tG\t*\tG\t*\tOLAGM-\tMAIN ATTACK\t\r\n\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD.SUPATK\tG\t*\tG\t*\tOLAGS-\tSUPPORTING ATTACK\t\r\n\tTACGRP.C2GM.OFF.LNE.DIRATK\tG\t*\tG\t*\tOLK---\tDIRECTION OF ATTACK\tN/A\r\n\tTACGRP.C2GM.OFF.LNE.DIRATK.AVN\tG\t*\tG\t*\tOLKA--\tAVIATION\t\r\n\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD\tG\t*\tG\t*\tOLKG--\tGROUND\tN/A\r\n\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD.MANATK\tG\t*\tG\t*\tOLKGM-\tMAIN ATTACK\t\r\n\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD.SUPATK\tG\t*\tG\t*\tOLKGS-\tSUPPORTING ATTACK\t\r\n\tTACGRP.C2GM.OFF.LNE.FCL\tG\t*\tG\t*\tOLF---\tFINAL COORDINATION LINE\t\r\n\tTACGRP.C2GM.OFF.LNE.INFNLE\tG\t*\tG\t*\tOLI---\tINFILTRATION LANE\t\r\n\tTACGRP.C2GM.OFF.LNE.LMTADV\tG\t*\tG\t*\tOLL---\tLIMIT OF ADVANCE\t\r\n\tTACGRP.C2GM.OFF.LNE.LD\tG\t*\tG\t*\tOLT---\tLINE OF DEPARTURE\t\r\n\tTACGRP.C2GM.OFF.LNE.LDLC\tG\t*\tG\t*\tOLC---\tLINE OF DEPARTURE/LINE OF CONTACT (LD/LC)\t\r\n\tTACGRP.C2GM.OFF.LNE.PLD\tG\t*\tG\t*\tOLP---\tPROBABLE LINE OF DEPLOYMENT (PLD)\t\r\n\tTACGRP.C2GM.OFF.ARS\tG\t*\tG\t*\tOA----\tAREAS\tN/A\r\n\tTACGRP.C2GM.OFF.ARS.ASTPSN\tG\t*\tG\t*\tOAA---\tASSAULT POSITION\t\r\n\tTACGRP.C2GM.OFF.ARS.ATKPSN\tG\t*\tG\t*\tOAK---\tATTACK POSITION\t\r\n\tTACGRP.C2GM.OFF.ARS.AFP\tG\t*\tG\t*\tOAF---\tATTACK BY FIRE POSITION\t\r\n\tTACGRP.C2GM.OFF.ARS.SFP\tG\t*\tG\t*\tOAS---\tSUPPORT BY FIRE POSITION\t\r\n\tTACGRP.C2GM.OFF.ARS.OBJ\tG\t*\tG\t*\tOAO---\tOBJECTIVE\t\r\n\tTACGRP.C2GM.OFF.ARS.PBX\tG\t*\tG\t*\tOAP---\tPENETRATION BOX\t\r\n\tTACGRP.C2GM.SPL\tG\t*\tG\t*\tS-----\tSPECIAL\tN/A\r\n\tTACGRP.C2GM.SPL.LNE\tG\t*\tG\t*\tSL----\tLINE\tN/A\r\n\tTACGRP.C2GM.SPL.LNE.AMB\tG\t*\tG\t*\tSLA---\tAMBUSH\t\r\n\tTACGRP.C2GM.SPL.LNE.HGL\tG\t*\tG\t*\tSLH---\tHOLDING LINE\t\r\n\tTACGRP.C2GM.SPL.LNE.REL\tG\t*\tG\t*\tSLR---\tRELEASE LINE\t\r\n\tTACGRP.C2GM.SPL.LNE.BRGH\tG\t*\tG\t*\tSLB---\tBRIDGEHEAD\t\r\n\tTACGRP.C2GM.SPL.ARA\tG\t*\tG\t*\tSA----\tAREA\tN/A\r\n\tTACGRP.C2GM.SPL.ARA.AOO\tG\t*\tG\t*\tSAO---\tAREA OF OPERATIONS (AO)\t\r\n\tTACGRP.C2GM.SPL.ARA.AHD\tG\t*\tG\t*\tSAA---\tAIRHEAD\t\r\n\tTACGRP.C2GM.SPL.ARA.ENCMT\tG\t*\tG\t*\tSAE---\tENCIRCLEMENT\t\r\n\tTACGRP.C2GM.SPL.ARA.NAI\tG\t*\tG\t*\tSAN---\tNAMED AREA OF INTEREST (NAI)\t\r\n\tTACGRP.C2GM.SPL.ARA.TAI\tG\t*\tG\t*\tSAT---\tTARGETED AREA OF INTEREST (TAI)\t\r\n\tTACGRP.MOBSU\tG\t*\tM\t*\t------\tMOBILITY/SURVIVABILITY\tN/A\r\n\tTACGRP.MOBSU.OBST\tG\t*\tM\t*\tO-----\tOBSTACLES\tN/A\r\n\tTACGRP.MOBSU.OBST.GNL\tG\t*\tM\t*\tOG----\tGENERAL\tN/A\r\n\tTACGRP.MOBSU.OBST.GNL.BLT\tG\t*\tM\t*\tOGB---\tBELT\t\r\n\tTACGRP.MOBSU.OBST.GNL.LNE\tG\t*\tM\t*\tOGL---\tLINE\t\r\n\tTACGRP.MOBSU.OBST.GNL.Z\tG\t*\tM\t*\tOGZ---\tZONE\t\r\n\tTACGRP.MOBSU.OBST.GNL.OFA\tG\t*\tM\t*\tOGF---\tOBSTACLE FREE AREA\t\r\n\tTACGRP.MOBSU.OBST.GNL.ORA\tG\t*\tM\t*\tOGR---\tOBSTACLE RESTRICTED AREA\t\r\n\tTACGRP.MOBSU.OBST.ABS\tG\t*\tM\t*\tOS----\tABATIS\t\r\n\tTACGRP.MOBSU.OBST.ATO\tG\t*\tM\t*\tOA----\tANTITANK OBSTACLES\tN/A\r\n\tTACGRP.MOBSU.OBST.ATO.ATD\tG\t*\tM\t*\tOAD---\tANTITANK DITCH\tN/A\r\n\tTACGRP.MOBSU.OBST.ATO.ATD.ATDUC\tG\t*\tM\t*\tOADU--\tUNDER CONSTRUCTION\t\r\n\tTACGRP.MOBSU.OBST.ATO.ATD.ATDC\tG\t*\tM\t*\tOADC--\tCOMPLETE\t\r\n\tTACGRP.MOBSU.OBST.ATO.ATDATM\tG\t*\tM\t*\tOAR---\tANTITANK DITCH REINFORCED WITH ANTITANK MINES\t\r\n\tTACGRP.MOBSU.OBST.ATO.TDTSM\tG\t*\tM\t*\tOAO---\tANTITANK OBSTACLES: TETRAHEDRONS, DRAGONS TEETH, AND OTHER SIMILAR OBSTACLES\tN/A\r\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.FIXPFD\tG\t*\tM\t*\tOAOF--\tFIXED AND PREFABRICATED\t\r\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.MVB\tG\t*\tM\t*\tOAOM--\tMOVEABLE\t\r\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.MVBPFD\tG\t*\tM\t*\tOAOP--\tMOVEABLE AND PREFABRICATED\t\r\n\tTACGRP.MOBSU.OBST.ATO.ATW\tG\t*\tM\t*\tOAW---\tANTITANK WALL\t\r\nPOINT\tTACGRP.MOBSU.OBST.BBY\tG\t*\tM\t*\tOB----\tBOOBY TRAP\t\r\n\tTACGRP.MOBSU.OBST.MNE\tG\t*\tM\t*\tOM----\tMINES\tN/A\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.USPMNE\tG\t*\tM\t*\tOMU---\tUNSPECIFIED MINE\t\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMNE\tG\t*\tM\t*\tOMT---\tANTITANK MINE (AT)\t\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMAHD\tG\t*\tM\t*\tOMD---\tANTITANK MINE WITH ANTIHANDLING DEVICE\t\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMDIR\tG\t*\tM\t*\tOME---\tANTITANK MINE (DIRECTIONAL)\t\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.APMNE\tG\t*\tM\t*\tOMP---\tANTIPERSONNEL (AP) MINES\t\r\nPOINT\tTACGRP.MOBSU.OBST.MNE.WAMNE\tG\t*\tM\t*\tOMW---\tWIDE AREA MINES\t\r\n\tTACGRP.MOBSU.OBST.MNE.MCLST\tG\t*\tM\t*\tOMC---\tMINE CLUSTER\t\r\n\tTACGRP.MOBSU.OBST.MNEFLD\tG\t*\tM\t*\tOF----\tMINEFIELDS\tN/A\r\nPOINT\tTACGRP.MOBSU.OBST.MNEFLD.STC\tG\t*\tM\t*\tOFS---\tSTATIC DEPICTION\t\r\n\tTACGRP.MOBSU.OBST.MNEFLD.DYN\tG\t*\tM\t*\tOFD---\tDYNAMIC DEPICTION\t\r\n\tTACGRP.MOBSU.OBST.MNEFLD.GAP\tG\t*\tM\t*\tOFG---\tGAP\t\r\n\tTACGRP.MOBSU.OBST.MNEFLD.MNDARA\tG\t*\tM\t*\tOFA---\tMINED AREA\t\r\n\tTACGRP.MOBSU.OBST.OBSEFT\tG\t*\tM\t*\tOE----\tOBSTACLE EFFECT\tN/A\r\n\tTACGRP.MOBSU.OBST.OBSEFT.BLK\tG\t*\tM\t*\tOEB---\tBLOCK\t\r\n\tTACGRP.MOBSU.OBST.OBSEFT.FIX\tG\t*\tM\t*\tOEF---\tFIX\t\r\n\tTACGRP.MOBSU.OBST.OBSEFT.TUR\tG\t*\tM\t*\tOET---\tTURN\t\r\n\tTACGRP.MOBSU.OBST.OBSEFT.DRT\tG\t*\tM\t*\tOED---\tDISRUPT\t\r\n\tTACGRP.MOBSU.OBST.UXO\tG\t*\tM\t*\tOU----\tUNEXPLODED ORDNANCE AREA (UXO)\t\r\n\tTACGRP.MOBSU.OBST.RCBB\tG\t*\tM\t*\tOR----\tROADBLOCKS, CRATERS, AND BLOWN BRIDGES\tN/A\r\n\tTACGRP.MOBSU.OBST.RCBB.PLND\tG\t*\tM\t*\tORP---\tPLANNED\t\r\n\tTACGRP.MOBSU.OBST.RCBB.SAFE\tG\t*\tM\t*\tORS---\tEXPLOSIVES, STATE OF READINESS 1 (SAFE)\t\r\n\tTACGRP.MOBSU.OBST.RCBB.ABP\tG\t*\tM\t*\tORA---\tEXPLOSIVES, STATE OF READINESS 2 (ARMED-BUT PASSABLE)\t\r\n\tTACGRP.MOBSU.OBST.RCBB.EXCD\tG\t*\tM\t*\tORC---\tROADBLOCK COMPLETE (EXECUTED)\t\r\n\tTACGRP.MOBSU.OBST.TRIPWR\tG\t*\tM\t*\tOT----\tTRIP WIRE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS\tG\t*\tM\t*\tOW----\tWIRE OBSTACLE\tN/A\r\n\tTACGRP.MOBSU.OBST.WREOBS.USP\tG\t*\tM\t*\tOWU---\tUNSPECIFIED\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.SNGFNC\tG\t*\tM\t*\tOWS---\tSINGLE FENCE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.DBLFNC\tG\t*\tM\t*\tOWD---\tDOUBLE FENCE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.DAFNC\tG\t*\tM\t*\tOWA---\tDOUBLE APRON FENCE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.LWFNC\tG\t*\tM\t*\tOWL---\tLOW WIRE FENCE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.HWFNC\tG\t*\tM\t*\tOWH---\tHIGH WIRE FENCE\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.CCTA\tG\t*\tM\t*\tOWC---\tCONCERTINA\tN/A\r\n\tTACGRP.MOBSU.OBST.WREOBS.CCTA.SNG\tG\t*\tM\t*\tOWCS--\tSINGLE CONCERTINA\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.CCTA.DBLSTD\tG\t*\tM\t*\tOWCD--\tDOUBLE STRAND CONCERTINA\t\r\n\tTACGRP.MOBSU.OBST.WREOBS.CCTA.TRISTD\tG\t*\tM\t*\tOWCT--\tTRIPLE STRAND CONCERTINA\t\r\n\tTACGRP.MOBSU.OBSTBP\tG\t*\tM\t*\tB-----\tOBSTACLE BYPASS\tN/A\r\n\tTACGRP.MOBSU.OBSTBP.DFTY\tG\t*\tM\t*\tBD----\tOBSTACLE BYPASS DIFFICULTY\tN/A\r\n\tTACGRP.MOBSU.OBSTBP.DFTY.ESY\tG\t*\tM\t*\tBDE---\tBYPASS EASY\t\r\n\tTACGRP.MOBSU.OBSTBP.DFTY.DFT\tG\t*\tM\t*\tBDD---\tBYPASS DIFFICULT\t\r\n\tTACGRP.MOBSU.OBSTBP.DFTY.IMP\tG\t*\tM\t*\tBDI---\tBYPASS IMPOSSIBLE\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE\tG\t*\tM\t*\tBC----\tCROSSING SITE/WATER CROSSING\tN/A\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.ASTCA\tG\t*\tM\t*\tBCA---\tASSAULT CROSSING AREA\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.BRG\tG\t*\tM\t*\tBCB---\tBRIDGE OR GAP\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRY\tG\t*\tM\t*\tBCF---\tFERRY\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRDESY\tG\t*\tM\t*\tBCE---\tFORD EASY\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRDDFT\tG\t*\tM\t*\tBCD---\tFORD DIFFICULT\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.LANE\tG\t*\tM\t*\tBCL---\tLANE\t\r\n\tTACGRP.MOBSU.OBSTBP.CSGSTE.RFT\tG\t*\tM\t*\tBCR---\tRAFT SITE\t\r\nPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.ERP\tG\t*\tM\t*\tBCP---\tENGINEER REGULATING POINT\t\r\n\tTACGRP.MOBSU.SU\tG\t*\tM\t*\tS-----\tSURVIVABILITY\tN/A\r\nPOINT\tTACGRP.MOBSU.SU.ESTOF\tG\t*\tM\t*\tSE----\tEARTHWORK, SMALL TRENCH OR FORTIFICATION\t\r\nPOINT\tTACGRP.MOBSU.SU.FRT\tG\t*\tM\t*\tSF----\tFORT\t\r\n\tTACGRP.MOBSU.SU.FTFDLN\tG\t*\tM\t*\tSL----\tFORTIFIED LINE\t\r\n\tTACGRP.MOBSU.SU.FEWS\tG\t*\tM\t*\tSW----\tFOXHOLE, EMPLACEMENT OR WEAPON SITE\t\r\n\tTACGRP.MOBSU.SU.STRGPT\tG\t*\tM\t*\tSP----\tSTRONG POINT\t\r\nPOINT\tTACGRP.MOBSU.SU.SUFSHL\tG\t*\tM\t*\tSS----\tSURFACE SHELTER\t\r\nPOINT\tTACGRP.MOBSU.SU.UGDSHL\tG\t*\tM\t*\tSU----\tUNDERGROUND SHELTER\t\r\n\tTACGRP.MOBSU.NBC\tG\t*\tM\t*\tN-----\tNUCLEAR, BIOLOGICAL AND CHEMICAL\tN/A\r\n\tTACGRP.MOBSU.NBC.MSDZ\tG\t*\tM\t*\tNM----\tMINIMUM SAFE DISTANCE ZONES\t\r\nPOINT\tTACGRP.MOBSU.NBC.NDGZ\tG\t*\tM\t*\tNZ----\tNUCLEAR DETINATIONS GROUND ZERO\t\r\nPOINT\tTACGRP.MOBSU.NBC.FAOTP\tG\t*\tM\t*\tNF----\tFALLOUT PRODUCING\t\r\n\tTACGRP.MOBSU.NBC.RADA\tG\t*\tM\t*\tNR----\tRADIOACTIVE AREA\t\r\n\tTACGRP.MOBSU.NBC.BIOCA\tG\t*\tM\t*\tNB----\tBIOLOGICALLY CONTAMINATED AREA\t\r\n\tTACGRP.MOBSU.NBC.CMLCA\tG\t*\tM\t*\tNC----\tCHEMICALLY CONTAMINATED AREA\t\r\n\tTACGRP.MOBSU.NBC.REEVNT\tG\t*\tM\t*\tNE----\tRELEASE EVENTS\tN/A\r\nPOINT\tTACGRP.MOBSU.NBC.REEVNT.BIO\tG\t*\tM\t*\tNEB---\tBIOLOGICAL\t\r\nPOINT\tTACGRP.MOBSU.NBC.REEVNT.CML\tG\t*\tM\t*\tNEC---\tCHEMICAL\t\r\n\tTACGRP.MOBSU.NBC.DECONP\tG\t*\tM\t*\tND----\tDECONTAMINATION (DECON) POINTS\tN/A\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.USP\tG\t*\tM\t*\tNDP---\tDECON SITE/POINT (UNSPECIFIED)\t\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.ALTUSP\tG\t*\tM\t*\tNDA---\tALTERNATE DECON SITE/POINT (UNSPECIFIED)\t\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.TRP\tG\t*\tM\t*\tNDT---\tDECON SITE/POINT (TROOPS)\t\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.EQT\tG\t*\tM\t*\tNDE---\tDECON SITE/POINT (EQUIPMENT)\t\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.EQTTRP\tG\t*\tM\t*\tNDB---\tDECON SITE/POINT (EQUIPMENT AND TROOPS)\t\r\nPOINT\tTACGRP.MOBSU.NBC.DECONP.OPDECN\tG\t*\tM\t*\tNDO---\tDECON SITE/POINT (OPERATIONAL DECONTAMINATION)\t\r\n\tTACGRP.MOBSU.NBC.DECONP.TRGH\tG\t*\tM\t*\tNDD---\tDECON SITE/POINT (THOROUGH DECONTAMINATION)\t\r\n\tTACGRP.MOBSU.NBC.DRCL\tG\t*\tM\t*\tNL----\tDOSE RATE CONTOUR LINES\t\r\n\tTACGRP.FSUPP\tG\t*\tF\t*\t------\tFIRE SUPPORT\tN/A\r\n\tTACGRP.FSUPP.PNT\tG\t*\tF\t*\tP-----\tPOINT\tN/A\r\n\tTACGRP.FSUPP.PNT.TGT\tG\t*\tF\t*\tPT----\tTARGET\tN/A\r\nPOINT\tTACGRP.FSUPP.PNT.TGT.PTGT\tG\t*\tF\t*\tPTS---\tPOINT/SINGLE TARGET\t\r\nPOINT\tTACGRP.FSUPP.PNT.TGT.NUCTGT\tG\t*\tF\t*\tPTN---\tNUCLEAR TARGET\t\r\n\tTACGRP.FSUPP.PNT.C2PNT\tG\t*\tF\t*\tPC----\tCOMMAND & CONTROL POINTS\tN/A\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.FSS\tG\t*\tF\t*\tPCF---\tFIRE SUPPORT STATION\t\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.SCP\tG\t*\tF\t*\tPCS---\tSURVEY CONTROL POINT\t\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.FP\tG\t*\tF\t*\tPCB---\tFIRING POINT\t\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.RP\tG\t*\tF\t*\tPCR---\tRELOAD POINT\t\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.HP\tG\t*\tF\t*\tPCH---\tHIDE POINT\t\r\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.LP\tG\t*\tF\t*\tPCL---\tLAUNCH POINT\t\r\n\tTACGRP.FSUPP.LNE\tG\t*\tF\t*\tL-----\tLINES\tN/A\r\n\tTACGRP.FSUPP.LNE.LNRTGT\tG\t*\tF\t*\tLT----\tLINEAR TARGET\t\r\n\tTACGRP.FSUPP.LNE.LNRTGT.LSTGT\tG\t*\tF\t*\tLTS---\tLINEAR SMOKE TARGET\t\r\n\tTACGRP.FSUPP.LNE.LNRTGT.FPF\tG\t*\tF\t*\tLTF---\tFINAL PROTECTIVE FIRE (FPF)\t\r\n\tTACGRP.FSUPP.LNE.C2LNE\tG\t*\tF\t*\tLC----\tCOMMAND & CONTROL LINES\tN/A\r\n\tTACGRP.FSUPP.LNE.C2LNE.FSCL\tG\t*\tF\t*\tLCF---\tFIRE SUPPORT COORDINATION LINE (FSCL)\t\r\n\tTACGRP.FSUPP.LNE.C2LNE.CFL\tG\t*\tF\t*\tLCC---\tCOORDINATED FIRE LINE (CFL)\t\r\n\tTACGRP.FSUPP.LNE.C2LNE.NFL\tG\t*\tF\t*\tLCN---\tNO-FIRE LINE (NFL)\t\r\n\tTACGRP.FSUPP.LNE.C2LNE.RFL\tG\t*\tF\t*\tLCR---\tRESTRICTIVE FIRE LINE (RFL)\t\r\n\tTACGRP.FSUPP.ARS\tG\t*\tF\t*\tA-----\tAREAS\tN/A\r\n\tTACGRP.FSUPP.ARS.ARATGT\tG\t*\tF\t*\tAT----\tAREA TARGET\t\r\n\tTACGRP.FSUPP.ARS.ARATGT.RTGTGT\tG\t*\tF\t*\tATR---\tRECTANGULAR TARGET\t\r\n\tTACGRP.FSUPP.ARS.ARATGT.CIRTGT\tG\t*\tF\t*\tATC---\tCIRCULAR TARGET\t\r\n\tTACGRP.FSUPP.ARS.ARATGT.SGTGT\tG\t*\tF\t*\tATG---\tSERIES OR GROUP OF TARGETS\t\r\n\tTACGRP.FSUPP.ARS.ARATGT.SMK\tG\t*\tF\t*\tATS---\tSMOKE\t\r\n\tTACGRP.FSUPP.ARS.ARATGT.BMARA\tG\t*\tF\t*\tATB---\tBOMB AREA\t\r\n\tTACGRP.FSUPP.ARS.C2ARS\tG\t*\tF\t*\tAC----\tCOMMAND & CONTROL AREAS\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.FSA\tG\t*\tF\t*\tACS---\tFIRE SUPPORT AREA (FSA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.FSA.IRR\tG\t*\tF\t*\tACSI--\tFIRE SUPPORT AREA (FSA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.FSA.RTG\tG\t*\tF\t*\tACSR--\tFIRE SUPPORT AREA (FSA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.FSA.CIRCLR\tG\t*\tF\t*\tACSC--\tFIRE SUPPORT AREA (FSA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.ACA\tG\t*\tF\t*\tACA---\tAIRSPACE COORDINATION AREA (ACA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.ACA.IRR\tG\t*\tF\t*\tACAI--\tAIRSPACE COORDINATION AREA (ACA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.ACA.RTG\tG\t*\tF\t*\tACAR--\tAIRSPACE COORDINATION AREA (ACA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.ACA.CIRCLR\tG\t*\tF\t*\tACAC--\tAIRSPACE COORDINATION AREA (ACA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.FFA\tG\t*\tF\t*\tACF---\tFREE FIRE AREA (FFA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.FFA.IRR\tG\t*\tF\t*\tACFI--\tFREE FIRE AREA (FFA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.FFA.RTG\tG\t*\tF\t*\tACFR--\tFREE FIRE AREA (FFA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.FFA.CIRCLR\tG\t*\tF\t*\tACFC--\tFREE FIRE AREA (FFA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.NFA\tG\t*\tF\t*\tACN---\tNO-FIRE AREA (NFA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.NFA.IRR\tG\t*\tF\t*\tACNI--\tNO FIRE AREA (NFA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.NFA.RTG\tG\t*\tF\t*\tACNR--\tNO FIRE AREA (NFA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.NFA.CIRCLR\tG\t*\tF\t*\tACNC--\tNO FIRE AREA (NFA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.RFA\tG\t*\tF\t*\tACR---\tRESTRICTIVE FIRE AREA (RFA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.RFA.IRR\tG\t*\tF\t*\tACRI--\tRESTRICTIVE FIRE AREA (RFA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.RFA.RTG\tG\t*\tF\t*\tACRR--\tRESTRICTIVE FIRE AREA (RFA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.RFA.CIRCLR\tG\t*\tF\t*\tACRC--\tRESTRICTIVE FIRE AREA (RFA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.PAA\tG\t*\tF\t*\tACP---\tPOSITION AREA FOR ARTILLERY (PAA)\tN/A\r\n\tTACGRP.FSUPP.ARS.C2ARS.PAA.RTG\tG\t*\tF\t*\tACPR--\tPOSITION AREA FOR ARTILLERY (PAA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.C2ARS.PAA.CIRCLR\tG\t*\tF\t*\tACPC--\tPOSITION AREA FOR ARTILLERY (PAA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ\tG\t*\tF\t*\tAZ----\tTARGET ACQUISTION ZONES\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ\tG\t*\tF\t*\tAZI---\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ.IRR\tG\t*\tF\t*\tAZII--\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE, IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ.RTG\tG\t*\tF\t*\tAZIR--\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE, RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ.CIRCLR\tG\t*\tF\t*\tAZIC--\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE, CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ\tG\t*\tF\t*\tAZX---\tCALL FOR FIRE ZONE (CFFZ)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ.IRR\tG\t*\tF\t*\tAZXI--\tCALL FOR FIRE ZONE (CFFZ), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ.RTG\tG\t*\tF\t*\tAZXR--\tCALL FOR FIRE ZONE (CFFZ), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ.CIRCLR\tG\t*\tF\t*\tAZXC--\tCALL FOR FIRE ZONE (CFFZ), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.SNSZ\tG\t*\tF\t*\tAZS---\tSENSOR ZONE\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.SNSZ.IRR\tG\t*\tF\t*\tAZSI--\tSENSOR ZONE, IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.SNSZ.RTG\tG\t*\tF\t*\tAZSR--\tSENSOR ZONE, RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.SNSZ.CIRCLR\tG\t*\tF\t*\tAZSC--\tSENSOR ZONE, CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CNS\tG\t*\tF\t*\tAZC---\tCENSOR ZONE\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CNS.IRR\tG\t*\tF\t*\tAZCI--\tCENSOR ZONE, IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CNS.RTG\tG\t*\tF\t*\tAZCR--\tCENSOR ZONE, RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CNS.CIRCLR\tG\t*\tF\t*\tAZCC--\tCENSOR ZONE, CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.DA\tG\t*\tF\t*\tAZD---\tDEAD SPACE AREA (DA)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.DA.IRR\tG\t*\tF\t*\tAZDI--\tDEAD SPACE AREA (DA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.DA.RTG\tG\t*\tF\t*\tAZDR--\tDEAD SPACE AREA (DA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.DA.CIRCLR\tG\t*\tF\t*\tAZDC--\tDEAD SPACE AREA (DA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ\tG\t*\tF\t*\tAZF---\tCRITICAL FRIENDLY ZONE (CFZ)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ.IRR\tG\t*\tF\t*\tAZFI--\tCRITICAL FRIENDLY ZONE (CFZ), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ.RTG\tG\t*\tF\t*\tAZFR--\tCRITICAL FRIENDLY ZONE (CFZ), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ.CIRCLR\tG\t*\tF\t*\tAZFC--\tCRITICAL FRIENDLY ZONE (CFZ), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ZOR\tG\t*\tF\t*\tAZZ---\tZONE OF RESPONSIBILITY (ZOR)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ZOR.IRR\tG\t*\tF\t*\tAZZI--\tZONE OF RESPONSIBILITY (ZOR), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ZOR.RTG\tG\t*\tF\t*\tAZZR--\tZONE OF RESPONSIBILITY (ZOR), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.ZOR.CIRCLR\tG\t*\tF\t*\tAZZC--\tZONE OF RESPONSIBILITY (ZOR), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TBA\tG\t*\tF\t*\tAZB---\tTARGET BUILD-UP AREA (TBA)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TBA.IRR\tG\t*\tF\t*\tAZBI--\tTARGET BUILD UP AREA (TBA), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TBA.RTG\tG\t*\tF\t*\tAZBR--\tTARGET BUILD UP AREA (TBA), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TBA.CIRCLR\tG\t*\tF\t*\tAZBC--\tTARGET BUILD UP AREA (TBA), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TVAR\tG\t*\tF\t*\tAZV---\tTARGET VALUE AREA (TVAR)\tN/A\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TVAR.IRR\tG\t*\tF\t*\tAZVI--\tTARGET VALUE AREA (TVAR), IRREGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TVAR.RTG\tG\t*\tF\t*\tAZVR--\tTARGET VALUE AREA (TVAR), RECTANGULAR\t\r\n\tTACGRP.FSUPP.ARS.TGTAQZ.TVAR.CIRCLR\tG\t*\tF\t*\tAZVC--\tTARGET VALUE AREA (TVAR), CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.WPNRF\tG\t*\tF\t*\tAX----\tWEAPONS/RADAR RANGE FANS\tN/A\r\n\tTACGRP.FSUPP.ARS.WPNRF.CIRCLR\tG\t*\tF\t*\tAXC---\tWEAPONS/RADAR RANGE FANS, CIRCULAR\t\r\n\tTACGRP.FSUPP.ARS.WPNRF.SCR\tG\t*\tF\t*\tAXS---\tWEAPONS/RADAR RANGE FANS, SECTOR\t\r\n\tTACGRP.CSS\tG\t*\tS\t*\t------\tCOMBAT SERVICE SUPPORT\tN/A\r\n\tTACGRP.CSS.PNT\tG\t*\tS\t*\tP-----\tPOINTS\tN/A\r\nPOINT\tTACGRP.CSS.PNT.AEP\tG\t*\tS\t*\tPX----\tAMBULANCE EXCHANGE POINT\t\r\nPOINT\tTACGRP.CSS.PNT.CBNP\tG\t*\tS\t*\tPC----\tCANNIBALIZATION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.CCP\tG\t*\tS\t*\tPY----\tCASUALTY COLLECTION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.CVP\tG\t*\tS\t*\tPT----\tCIVILIAN COLLECTION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.DCP\tG\t*\tS\t*\tPD----\tDETAINEE COLLECTION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.EPWCP\tG\t*\tS\t*\tPE----\tENEMY PRISONER OF WAR (EPW) COLLECTION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.LRP\tG\t*\tS\t*\tPL----\tLOGISTICS RELEASE POINT (LRP)\t\r\nPOINT\tTACGRP.CSS.PNT.MCP\tG\t*\tS\t*\tPM----\tMAINTENANCE COLLECTION POINT\t\r\nPOINT\tTACGRP.CSS.PNT.RRRP\tG\t*\tS\t*\tPR----\tREARM, REFUEL AND RESUPPLY POINT\t\r\nPOINT\tTACGRP.CSS.PNT.ROM\tG\t*\tS\t*\tPU----\tREFUEL ON THE MOVE (ROM) POINT\t\r\nPOINT\tTACGRP.CSS.PNT.TCP\tG\t*\tS\t*\tPO----\tTRAFFIC CONTROL POST (TCP)\t\r\nPOINT\tTACGRP.CSS.PNT.TTP\tG\t*\tS\t*\tPI----\tTRAILER TRANSFER POINT\t\r\nPOINT\tTACGRP.CSS.PNT.UMC\tG\t*\tS\t*\tPN----\tUNIT MAINTENANCE COLLECTION POINT\t\r\n\tTACGRP.CSS.PNT.SPT\tG\t*\tS\t*\tPS----\tSUPPLY POINTS\tN/A\r\nPOINT\tTACGRP.CSS.PNT.SPT.GNL\tG\t*\tS\t*\tPSZ---\tGENERAL\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS1\tG\t*\tS\t*\tPSA---\tCLASS I\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS2\tG\t*\tS\t*\tPSB---\tCLASS II\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS3\tG\t*\tS\t*\tPSC---\tCLASS III\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS4\tG\t*\tS\t*\tPSD---\tCLASS IV\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS5\tG\t*\tS\t*\tPSE---\tCLASS V\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS6\tG\t*\tS\t*\tPSF---\tCLASS VI\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS7\tG\t*\tS\t*\tPSG---\tCLASS VII\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS8\tG\t*\tS\t*\tPSH---\tCLASS VIII\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS9\tG\t*\tS\t*\tPSI---\tCLASS IX\t\r\nPOINT\tTACGRP.CSS.PNT.SPT.CLS10\tG\t*\tS\t*\tPSJ---\tCLASS X\t\r\n\tTACGRP.CSS.PNT.AP\tG\t*\tS\t*\tPA----\tAMMUNITION POINTS\tN/A\r\nPOINT\tTACGRP.CSS.PNT.AP.ASP\tG\t*\tS\t*\tPAS---\tAMMUNITION SUPPLY POINT (ASP)\t\r\nPOINT\tTACGRP.CSS.PNT.AP.ATP\tG\t*\tS\t*\tPAT---\tAMMUNITION TRANSFER POINT (ATP)\t\r\n\tTACGRP.CSS.LNE\tG\t*\tS\t*\tL-----\tLINES\tN/A\r\n\tTACGRP.CSS.LNE.CNY\tG\t*\tS\t*\tLC----\tCONVOYS\tN/A\r\n\tTACGRP.CSS.LNE.CNY.MCNY\tG\t*\tS\t*\tLCM---\tMOVING CONVOY\t\r\n\tTACGRP.CSS.LNE.CNY.HCNY\tG\t*\tS\t*\tLCH---\tHALTED CONVOY\t\r\n\tTACGRP.CSS.LNE.SLPRUT\tG\t*\tS\t*\tLR----\tSUPPLY ROUTES\tN/A\r\n\tTACGRP.CSS.LNE.SLPRUT.MSRUT\tG\t*\tS\t*\tLRM---\tMAIN SUPPLY ROUTE\t\r\n\tTACGRP.CSS.LNE.SLPRUT.ASRUT\tG\t*\tS\t*\tLRA---\tALTERNATE SUPPLY ROUTE\t\r\n\tTACGRP.CSS.LNE.SLPRUT.1WTRFF\tG\t*\tS\t*\tLRO---\tONE-WAY TRAFFIC\t\r\n\tTACGRP.CSS.LNE.SLPRUT.ATRFF\tG\t*\tS\t*\tLRT---\tALTERNATING TRAFFIC\t\r\n\tTACGRP.CSS.LNE.SLPRUT.2WTRFF\tG\t*\tS\t*\tLRW---\tTWO-WAY TRAFFIC\t\r\n\tTACGRP.CSS.ARA\tG\t*\tS\t*\tA-----\tAREA\t\r\n\tTACGRP.CSS.ARA.DHA\tG\t*\tS\t*\tAD----\tDETAINEE HOLDING AREA\t\r\n\tTACGRP.CSS.ARA.EPWHA\tG\t*\tS\t*\tAE----\tENEMY PRISONER OF WAR (EPW) HOLDING AREA\t\r\n\tTACGRP.CSS.ARA.FARP\tG\t*\tS\t*\tAR----\tFORWARD ARMING AND REFUELING AREA (FARP)\t\r\n\tTACGRP.CSS.ARA.RHA\tG\t*\tS\t*\tAH----\tREFUGEE HOLDING AREA\t\r\n\tTACGRP.CSS.ARA.SUPARS\tG\t*\tS\t*\tAS----\tSUPPORT AREAS\tN/A\r\n\tTACGRP.CSS.ARA.SUPARS.BSA\tG\t*\tS\t*\tASB---\tBRIGADE (BSA)\t\r\n\tTACGRP.CSS.ARA.SUPARS.DSA\tG\t*\tS\t*\tASD---\tDIVISION (DSA)\t\r\n\tTACGRP.CSS.ARA.SUPARS.RSA\tG\t*\tS\t*\tASR---\tREGIMENTAL (RSA)\t\r\n\tTACGRP.OTH\tG\t*\tO\t*\t------\tOTHER\tN/A\r\n\tTACGRP.OTH.ER\tG\t*\tO\t*\tE-----\tEMERGENCY\tN/A\r\nPOINT\tTACGRP.OTH.ER.DTHAC\tG\t*\tO\t*\tED----\tDITCHED AIRCRAFT\t\r\nPOINT\tTACGRP.OTH.ER.PIW\tG\t*\tO\t*\tEP----\tPERSON IN WATER\t\r\nPOINT\tTACGRP.OTH.ER.DSTVES\tG\t*\tO\t*\tEV----\tDISTRESSED VESSEL\t\r\n\tTACGRP.OTH.HAZ\tG\t*\tO\t*\tH-----\tHAZARD\tN/A\r\nPOINT\tTACGRP.OTH.HAZ.SML\tG\t*\tO\t*\tHM----\tSEA MINE-LIKE\t\r\n\tTACGRP.OTH.HAZ.NVGL\tG\t*\tO\t*\tHN----\tNAVIGATIONAL\t\r\nPOINT\tTACGRP.OTH.HAZ.IB\tG\t*\tO\t*\tHI----\tICEBERG\t\r\nPOINT\tTACGRP.OTH.HAZ.OLRG\tG\t*\tO\t*\tHO----\tOIL RIG\t\r\n\tTACGRP.OTH.SSUBSR\tG\t*\tO\t*\tS-----\tSEA SUBSURFACE RETURNS\tN/A\r\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN\tG\t*\tO\t*\tSB----\tBOTTOM RETURN/NOMBO\t\r\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.INS\tG\t*\tO\t*\tSBM---\tINSTALLATION/MANMADE\t\r\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.SBRSOO\tG\t*\tO\t*\tSBN---\tSEABED ROCK/STONE, OBSTACLE, OTHER\t\r\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.WRKND\tG\t*\tO\t*\tSBW---\tWRECK, NON DANGEROUS\t\r\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.WRKND.WRKD\tG\t*\tO\t*\tSBWD--\tWRECK, DANGEROUS\t\r\nPOINT\tTACGRP.OTH.SSUBSR.MARLFE\tG\t*\tO\t*\tSM----\tMARINE LIFE\t\r\nPOINT\tTACGRP.OTH.SSUBSR.SA\tG\t*\tO\t*\tSS----\tSEA ANOMALY (WAKE, CURRENT, KNUCKLE)\t\r\n\tTACGRP.OTH.BERLNE\tG\t*\tO\t*\tB-----\tBEARING LINE\t\r\n\tTACGRP.OTH.BERLNE.ELC\tG\t*\tO\t*\tBE----\tELECTRONIC\t\r\n\tTACGRP.OTH.BERLNE.ACU\tG\t*\tO\t*\tBA----\tACOUSTIC\t\r\n\tTACGRP.OTH.BERLNE.TPD\tG\t*\tO\t*\tBT----\tTORPEDO\t\r\n\tTACGRP.OTH.BERLNE.EOPI\tG\t*\tO\t*\tBO----\tELECTRO-OPTICAL INTERCEPT\t\r\n\tTACGRP.OTH.FIX\tG\t*\tO\t*\tF-----\tFIX\tN/A\r\nPOINT\tTACGRP.OTH.FIX.ACU\tG\t*\tO\t*\tFA----\tACOUSTIC\t\r\nPOINT\tTACGRP.OTH.FIX.EM\tG\t*\tO\t*\tFE----\tELECTRO-MAGNETIC\t\r\nPOINT\tTACGRP.OTH.FIX.EOP\tG\t*\tO\t*\tFO----\tELECTRO-OPTICAL\t\r\n";

  var mil_std_2525b_signals_intelligence = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\r\nSIGINT\tI\t-\t-\t*\t-------\tSIGNALS INTELLIGENCE\t\r\nSIGINT.SPC\tI\t*\tP\t*\t------\tSPACE TRACK\t\r\nSIGINT.SPC.SIGINC\tI\t*\tP\t*\tS-----\tSIGNAL INTERCEPT\t\r\nSIGINT.SPC.SIGINC.COMM\tI\t*\tP\t*\tSC----\tCOMMUNICATIONS\t\r\nSIGINT.SPC.SIGINC.COMM.SATDL\tI\t*\tP\t*\tSCD---\tSATELLITE DOWN-LINK\t\r\nSIGINT.SPC.SIGINC.RAD\tI\t*\tP\t*\tSR----\tRADAR\t\r\nSIGINT.SPC.SIGINC.RAD.DATTMN\tI\t*\tP\t*\tSRD---\tDATA TRANSMISSION\t\r\nSIGINT.SPC.SIGINC.RAD.ERHSVL\tI\t*\tP\t*\tSRE---\tEARTH SURVEILLANCE\t\r\nSIGINT.SPC.SIGINC.RAD.IFF\tI\t*\tP\t*\tSRI---\tIFF (TRANSPONDER)\t\r\nSIGINT.SPC.SIGINC.RAD.MFN\tI\t*\tP\t*\tSRM---\tMULTI-FUNCTION\t\r\nSIGINT.SPC.SIGINC.RAD.TGTAQ\tI\t*\tP\t*\tSRT---\tTARGET ACQUISITION\t\r\nSIGINT.SPC.SIGINC.RAD.SPC\tI\t*\tP\t*\tSRS---\tSPACE\t\r\nSIGINT.SPC.SIGINC.RAD.UNK\tI\t*\tP\t*\tSRU---\tUNKNOWN\t\r\nSIGINT.AIRTRK\tI\t*\tA\t*\t------\tAIR TRACK\t\r\nSIGINT.AIRTRK.SIGINC\tI\t*\tA\t*\tS-----\tSIGNAL INTERCEPT\t\r\nSIGINT.AIRTRK.SIGINC.COMM\tI\t*\tA\t*\tSC----\tCOMMUNICATIONS\t\r\nSIGINT.AIRTRK.SIGINC.COMM.CELL\tI\t*\tA\t*\tSCC---\tCELLULAR/MOBILE\t\r\nSIGINT.AIRTRK.SIGINC.COMM.OLOS\tI\t*\tA\t*\tSCO---\tOMNI-LINE-OF-SIGHT (LOS)\t\r\nSIGINT.AIRTRK.SIGINC.COMM.PTPLOS\tI\t*\tA\t*\tSCP---\tPOINT-TO-POINT LINE-OF-SIGHT (LOS)\t\r\nSIGINT.AIRTRK.SIGINC.COMM.SATUL\tI\t*\tA\t*\tSCS---\tSATELLITE UP-LINK\t\r\nSIGINT.AIRTRK.SIGINC.RAD\tI\t*\tA\t*\tSR----\tRADAR\t\r\nSIGINT.AIRTRK.SIGINC.RAD.ABNINC\tI\t*\tA\t*\tSRAI--\tAIRBORNE INTERCEPT\t\r\nSIGINT.AIRTRK.SIGINC.RAD.ABNSB\tI\t*\tA\t*\tSRAS--\tAIRBORNE SEARCH & BOMBING\t\r\nSIGINT.AIRTRK.SIGINC.RAD.CTDINC\tI\t*\tA\t*\tSRC---\tCONTROLLED INTERCEPT\t\r\nSIGINT.AIRTRK.SIGINC.RAD.DATTMN\tI\t*\tA\t*\tSRD---\tDATA TRANSMISSION\t\r\nSIGINT.AIRTRK.SIGINC.RAD.EW\tI\t*\tA\t*\tSRE---\tEARLY WARNING\t\r\nSIGINT.AIRTRK.SIGINC.RAD.FIRCTL\tI\t*\tA\t*\tSRF---\tFIRE CONTROL\t\r\nSIGINT.AIRTRK.SIGINC.RAD.IFF\tI\t*\tA\t*\tSRI---\tIFF (TRANSPONDER)\t\r\nSIGINT.AIRTRK.SIGINC.RAD.MSLAQ\tI\t*\tA\t*\tSRMA--\tMISSILE ACQUISITION\t\r\nSIGINT.AIRTRK.SIGINC.RAD.MSLDL\tI\t*\tA\t*\tSRMD--\tMISSILE DOWNLINK\t\r\nSIGINT.AIRTRK.SIGINC.RAD.MSLGDN\tI\t*\tA\t*\tSRMG--\tMISSILE GUIDANCE\t\r\nSIGINT.AIRTRK.SIGINC.RAD.MSLTRK\tI\t*\tA\t*\tSRMT--\tMISSILE TRACKING\t\r\nSIGINT.AIRTRK.SIGINC.RAD.MFN\tI\t*\tA\t*\tSRMF--\tMULTI-FUNCTION\t\r\nSIGINT.AIRTRK.SIGINC.RAD.TGTILL\tI\t*\tA\t*\tSRTI--\tTARGET ILLUMINATOR\t\r\nSIGINT.AIRTRK.SIGINC.RAD.TGTAQ\tI\t*\tA\t*\tSRTA--\tTARGET ACQUISITION\t\r\nSIGINT.AIRTRK.SIGINC.RAD.TGTTRK\tI\t*\tA\t*\tSRTT--\tTARGET TRACKING\t\r\nSIGINT.AIRTRK.SIGINC.RAD.UNK\tI\t*\tA\t*\tSRU---\tUNKNOWN\t\r\nSIGINT.GRDTRK\tI\t*\tG\t*\t------\tGROUND TRACK\t\r\nSIGINT.GRDTRK.SIGINC\tI\t*\tG\t*\tS-----\tSIGNAL INTERCEPT\t\r\nSIGINT.GRDTRK.SIGINC.COMM\tI\t*\tG\t*\tSC----\tCOMMUNICATIONS\t\r\nSIGINT.GRDTRK.SIGINC.COMM.CELL\tI\t*\tG\t*\tSCC---\tCELLULAR/MOBILE\t\r\nSIGINT.GRDTRK.SIGINC.COMM.OLOS\tI\t*\tG\t*\tSCO---\tOMNI-LINE-OF-SIGHT (LOS)\t\r\nSIGINT.GRDTRK.SIGINC.COMM.PTPLOS\tI\t*\tG\t*\tSCP---\tPOINT-TO-POINT LINE-OF-SIGHT (LOS)\t\r\nSIGINT.GRDTRK.SIGINC.COMM.SATUL\tI\t*\tG\t*\tSCS---\tSATELLITE UP-LINK\t\r\nSIGINT.GRDTRK.SIGINC.COMM.TPSSCT\tI\t*\tG\t*\tSCT---\tTROPOSPHERIC SCATTER\t\r\nSIGINT.GRDTRK.SIGINC.RAD\tI\t*\tG\t*\tSR----\tRADAR\t\r\nSIGINT.GRDTRK.SIGINC.RAD.ATCTL\tI\t*\tG\t*\tSRAT--\tAIR TRAFFIC CONTROL\t\r\nSIGINT.GRDTRK.SIGINC.RAD.AA/C\tI\t*\tG\t*\tSRAA--\tANTI-AIRCRAFT\t\r\nSIGINT.GRDTRK.SIGINC.RAD.BTFSVL\tI\t*\tG\t*\tSRB---\tBATTLEFIELD SURVEILLANCE\t\r\nSIGINT.GRDTRK.SIGINC.RAD.CSTSVL\tI\t*\tG\t*\tSRCS--\tCOASTAL SURVEILLANCE\t\r\nSIGINT.GRDTRK.SIGINC.RAD.CTDAPP\tI\t*\tG\t*\tSRCA--\tCONTROLLED APPROACH\t\r\nSIGINT.GRDTRK.SIGINC.RAD.DATTMN\tI\t*\tG\t*\tSRD---\tDATA TRANSMISSION\t\r\nSIGINT.GRDTRK.SIGINC.RAD.EW\tI\t*\tG\t*\tSRE---\tEARLY WARNING\t\r\nSIGINT.GRDTRK.SIGINC.RAD.FIRCTL\tI\t*\tG\t*\tSRF---\tFIRE CONTROL\t\r\nSIGINT.GRDTRK.SIGINC.RAD.HGTFDG\tI\t*\tG\t*\tSRH---\tHEIGHT FINDING\t\r\nSIGINT.GRDTRK.SIGINC.RAD.IDFF\tI\t*\tG\t*\tSRI---\tIDENTIFICATION FRIEND/FOE (INTERROGATOR)\t\r\nSIGINT.GRDTRK.SIGINC.RAD.METO\tI\t*\tG\t*\tSRMM--\tMETEOROLOGICAL (MILITARY)\t\r\nSIGINT.GRDTRK.SIGINC.RAD.MSLAQ\tI\t*\tG\t*\tSRMA--\tMISSILE ACQUISITION\t\r\nSIGINT.GRDTRK.SIGINC.RAD.MSLGDN\tI\t*\tG\t*\tSRMG--\tMISSILE GUIDANCE\t\r\nSIGINT.GRDTRK.SIGINC.RAD.MSLTRK\tI\t*\tG\t*\tSRMT--\tMISSILE TRACKING\t\r\nSIGINT.GRDTRK.SIGINC.RAD.MFN\tI\t*\tG\t*\tSRMF--\tMULTI-FUNCTION\t\r\nSIGINT.GRDTRK.SIGINC.RAD.SHETKG\tI\t*\tG\t*\tSRS---\tSHELL TRACKING\t\r\nSIGINT.GRDTRK.SIGINC.RAD.TGTAQ\tI\t*\tG\t*\tSRTA--\tTARGET ACQUISITION\t\r\nSIGINT.GRDTRK.SIGINC.RAD.TGTILL\tI\t*\tG\t*\tSRTI--\tTARGET ILLUMINATOR\t\r\nSIGINT.GRDTRK.SIGINC.RAD.TGTTRK\tI\t*\tG\t*\tSRTT--\tTARGET TRACKING\t\r\nSIGINT.GRDTRK.SIGINC.RAD.UNK\tI\t*\tG\t*\tSRU---\tUNKNOWN\t\r\nSIGINT.SSUF\tI\t*\tS\t*\t------\tSEA SURFACE TRACK\t\r\nSIGINT.SSUF.SIGINC\tI\t*\tS\t*\tS-----\tSIGNAL INTERCEPT\t\r\nSIGINT.SSUF.SIGINC.COMM\tI\t*\tS\t*\tSC----\tCOMMUNICATIONS\t\r\nSIGINT.SSUF.SIGINC.COMM.CELL\tI\t*\tS\t*\tSCC---\tCELLULAR/MOBILE\t\r\nSIGINT.SSUF.SIGINC.COMM.OLOS\tI\t*\tS\t*\tSCO---\tOMNI-LINE-OF-SIGHT (LOS)\t\r\nSIGINT.SSUF.SIGINC.COMM.PTPLOS\tI\t*\tS\t*\tSCP---\tPOINT-TO-POINT LINE-OF-SIGHT (LOS)\t\r\nSIGINT.SSUF.SIGINC.COMM.SATUL\tI\t*\tS\t*\tSCS---\tSATELLITE UP-LINK\t\r\nSIGINT.SSUF.SIGINC.RAD\tI\t*\tS\t*\tSR----\tRADAR\t\r\nSIGINT.SSUF.SIGINC.RAD.ATCTL\tI\t*\tS\t*\tSRAT--\tAIR TRAFFIC CONTROL\t\r\nSIGINT.SSUF.SIGINC.RAD.AA/C\tI\t*\tS\t*\tSRAA--\tANTI-AIRCRAFT\t\r\nSIGINT.SSUF.SIGINC.RAD.CTDAPP\tI\t*\tS\t*\tSRCA--\tCONTROLLED APPROACH\t\r\nSIGINT.SSUF.SIGINC.RAD.CTDINC\tI\t*\tS\t*\tSRCI--\tCONTROLLED INTERCEPT\t\r\nSIGINT.SSUF.SIGINC.RAD.DATTMN\tI\t*\tS\t*\tSRD---\tDATA TRANSMISSION\t\r\nSIGINT.SSUF.SIGINC.RAD.EW\tI\t*\tS\t*\tSRE---\tEARLY WARNING\t\r\nSIGINT.SSUF.SIGINC.RAD.FIRCTL\tI\t*\tS\t*\tSRF---\tFIRE CONTROL\t\r\nSIGINT.SSUF.SIGINC.RAD.HGTFDG\tI\t*\tS\t*\tSRH---\tHEIGHT FINDING\t\r\nSIGINT.SSUF.SIGINC.RAD.IDFF\tI\t*\tS\t*\tSRI---\tIDENTIFICATION FRIEND/FOE (INTERROGATOR)\t\r\nSIGINT.SSUF.SIGINC.RAD.METO\tI\t*\tS\t*\tSRMM--\tMETEOROLOGICAL (MILITARY)\t\r\nSIGINT.SSUF.SIGINC.RAD.MSLAQ\tI\t*\tS\t*\tSRMA--\tMISSILE ACQUISITION\t\r\nSIGINT.SSUF.SIGINC.RAD.MSLGDN\tI\t*\tS\t*\tSRMG--\tMISSILE GUIDANCE\t\r\nSIGINT.SSUF.SIGINC.RAD.MSLTRK\tI\t*\tS\t*\tSRMT--\tMISSILE TRACKING\t\r\nSIGINT.SSUF.SIGINC.RAD.MFN\tI\t*\tS\t*\tSRMF--\tMULTI-FUNCTION\t\r\nSIGINT.SSUF.SIGINC.RAD.SUFSRH\tI\t*\tS\t*\tSRS---\tSURFACE SEARCH\t\r\nSIGINT.SSUF.SIGINC.RAD.TGTAQ\tI\t*\tS\t*\tSRTA--\tTARGET ACQUISITION\t\r\nSIGINT.SSUF.SIGINC.RAD.TGTILL\tI\t*\tS\t*\tSRTI--\tTARGET ILLUMINATOR\t\r\nSIGINT.SSUF.SIGINC.RAD.TGTTRK\tI\t*\tS\t*\tSRTT--\tTARGET TRACKING\t\r\nSIGINT.SSUF.SIGINC.RAD.UNK\tI\t*\tS\t*\tSRU---\tUNKNOWN\t\r\nSIGINT.SBSUF\tI\t*\tU\t*\t------\tSUBSURFACE TRACK\t\r\nSIGINT.SBSUF.SIGINC\tI\t*\tU\t*\tS-----\tSIGNAL INTERCEPT\t\r\nSIGINT.SBSUF.SIGINC.COMM\tI\t*\tU\t*\tSC----\tCOMMUNICATIONS\t\r\nSIGINT.SBSUF.SIGINC.COMM.OLOS\tI\t*\tU\t*\tSCO---\tOMNI-LINE-OF-SIGHT (LOS)\t\r\nSIGINT.SBSUF.SIGINC.COMM.PTPLOS\tI\t*\tU\t*\tSCP---\tPOINT-TO-POINT LINE-OF-SIGHT (LOS)\t\r\nSIGINT.SBSUF.SIGINC.COMM.SATUL\tI\t*\tU\t*\tSCS---\tSATELLITE UP-LINK\t\r\nSIGINT.SBSUF.SIGINC.RAD\tI\t*\tU\t*\tSR----\tRADAR\t\r\nSIGINT.SBSUF.SIGINC.RAD.DATTMN\tI\t*\tU\t*\tSRD---\tDATA TRANSMISSION\t\r\nSIGINT.SBSUF.SIGINC.RAD.EW\tI\t*\tU\t*\tSRE---\tEARLY WARNING\t\r\nSIGINT.SBSUF.SIGINC.RAD.MFN\tI\t*\tU\t*\tSRM---\tMULTI-FUNCTION\t\r\nSIGINT.SBSUF.SIGINC.RAD.SUFSRH\tI\t*\tU\t*\tSRS---\tSURFACE SEARCH\t\r\nSIGINT.SBSUF.SIGINC.RAD.TGTAQ\tI\t*\tU\t*\tSRT---\tTARGET ACQUISITION\t\r\nSIGINT.SBSUF.SIGINC.RAD.UNK\tI\t*\tU\t*\tSRU---\tUNKNOWN\t";

  var mil_std_2525b_mootw = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\r\nMOOTW\tO\t*\t-\t*\t-------\tMILITARY OPERATIONS OTHER THAN WAR (MOOTW)\t\r\nMOOTW.VIOATY\tO\t*\tV\t*\t------\tVIOLENT ACTIVITIES (DEATH CAUSING)\t\r\nMOOTW.VIOATY.ASN\tO\t*\tV\t*\tA-----\tARSON/FIRE\t\r\nMOOTW.VIOATY.KILL\tO\t*\tV\t*\tM-----\tKILLING (GENERAL)\t\r\nMOOTW.VIOATY.KILL.MDR\tO\t*\tV\t*\tMA----\tMURDER\t\r\nMOOTW.VIOATY.KILL.EX\tO\t*\tV\t*\tMB----\tEXECUTION\t\r\nMOOTW.VIOATY.KILL.ASS\tO\t*\tV\t*\tMC----\tASSASSINATION\t\r\nMOOTW.VIOATY.BM\tO\t*\tV\t*\tB-----\tBOMB/BOMBING\t\r\nMOOTW.VIOATY.BBY\tO\t*\tV\t*\tY-----\tBOOBY TRAP\t\r\nMOOTW.VIOATY.DBS\tO\t*\tV\t*\tD-----\tDRIVE-BY SHOOTING\t\r\nMOOTW.VIOATY.SPG\tO\t*\tV\t*\tS-----\tSNIPING\t\r\nMOOTW.VIOATY.PSNG\tO\t*\tV\t*\tP-----\tPOISONING\t\r\nMOOTW.LOCAT\tO\t*\tL\t*\t------\tLOCATIONS\t\r\nMOOTW.LOCAT.BLST\tO\t*\tL\t*\tB-----\tBLACK LIST LOCATION\t\r\nMOOTW.LOCAT.GLST\tO\t*\tL\t*\tG-----\tGRAY LIST LOCATION\t\r\nMOOTW.LOCAT.WLST\tO\t*\tL\t*\tW-----\tWHITE LIST LOCATION\t\r\nMOOTW.LOCAT.MASS\tO\t*\tL\t*\tM-----\tMASS GRAVE LOCATION\t\r\nMOOTW.OPN\tO\t*\tO\t*\t------\tOPERATIONS\t\r\nMOOTW.OPN.PATG\tO\t*\tO\t*\tP-----\tPATROLLING\t\r\nMOOTW.OPN.RCMT\tO\t*\tO\t*\tR-----\tRECRUITMENT\t\r\nMOOTW.OPN.RCMT.WLG\tO\t*\tO\t*\tRW----\tRECRUITMENT (WILLING)\t\r\nMOOTW.OPN.RCMT.CRCD\tO\t*\tO\t*\tRC----\tRECRUITMENT (COERCED/IMPRESSED)\t\r\nMOOTW.OPN.DEMO\tO\t*\tO\t*\tD-----\tDEMONSTRATION\t\r\nMOOTW.OPN.ML\tO\t*\tO\t*\tM-----\tMINE LAYING\t\r\nMOOTW.OPN.PSYOP\tO\t*\tO\t*\tY-----\tPSYCHOLOGICAL OPERATIONS (PSYOP)\t\r\nMOOTW.OPN.PSYOP.TARP\tO\t*\tO\t*\tYT----\tPSYOP (TV AND RADIO PROPAGANDA)\t\r\nMOOTW.OPN.PSYOP.WP\tO\t*\tO\t*\tYW----\tPSYOP (WRITTEN PROPAGANDA)\t\r\nMOOTW.OPN.PSYOP.HTHP\tO\t*\tO\t*\tYH----\tHOUSE-TO-HOUSE PROPAGANDA\t\r\nMOOTW.OPN.FRGSRH\tO\t*\tO\t*\tF-----\tFORAGING/SEARCHING\t\r\nMOOTW.OPN.SPY\tO\t*\tO\t*\tS-----\tSPY\t\r\nMOOTW.OPN.FDDIST\tO\t*\tO\t*\tO-----\tFOOD DISTRIBUTION\t\r\nMOOTW.OPN.EXTN\tO\t*\tO\t*\tE-----\tEXTORTION\t\r\nMOOTW.OPN.HJKG\tO\t*\tO\t*\tH-----\tHIJACKING\t\r\nMOOTW.OPN.HJKG.VEH\tO\t*\tO\t*\tHT----\tHIJACKING (VEHICLE)\t\r\nMOOTW.OPN.HJKG.APL\tO\t*\tO\t*\tHA----\tHIJACKING (AIRPLANE)\t\r\nMOOTW.OPN.HJKG.BOAT\tO\t*\tO\t*\tHV----\tHIJACKING (BOAT)\t\r\nMOOTW.OPN.KDNG\tO\t*\tO\t*\tK-----\tKIDNAPPING\t\r\nMOOTW.OPN.ARR\tO\t*\tO\t*\tA-----\tARREST\t\r\nMOOTW.OPN.DGOPN\tO\t*\tO\t*\tU-----\tDRUG OPERATION\t\r\nMOOTW.ITM\tO\t*\tI\t*\t------\tITEMS\t\r\nMOOTW.ITM.RFG\tO\t*\tI\t*\tR-----\tREFUGEES\t\r\nMOOTW.ITM.SAFHSE\tO\t*\tI\t*\tS-----\tSAFE HOUSE\t\r\nMOOTW.ITM.GRF\tO\t*\tI\t*\tG-----\tGRAFFITI\t\r\nMOOTW.ITM.VRLRPS\tO\t*\tI\t*\tV-----\tVANDALISM/RAPE/LOOT/RANSACK/PLUNDER/SACK\t\r\nMOOTW.ITM.KNIVEH\tO\t*\tI\t*\tI-----\tKNOWN INSURGENT VEHICLE\t\r\nMOOTW.ITM.DGVEH\tO\t*\tI\t*\tD-----\tDRUG VEHICLE\t\r\nMOOTW.ITM.ISF\tO\t*\tI\t*\tF-----\tINTERNAL SECURITY FORCE\t";

  var _2525b = {
    WAR: {
      name: "WARFIGHTING",
      SPC: {
        name: "SPACE",
        mainIcon: csv2json(mil_std_2525b_space)
      },
      AIRTRK: {
        name: "AIR",
        mainIcon: csv2json(mil_std_2525b_air)
      },
      GRDTRK: {
        name: "GROUND UNIT",
        mainIcon: csv2json(mil_std_2525b_ground)
      },
      SSUF: {
        name: "SEA SURFACE",
        mainIcon: csv2json(mil_std_2525b_sea_surface)
      },
      SBSUF: {
        name: "SUBSURFACE",
        mainIcon: csv2json(mil_std_2525b_sub_surface)
      },
      SOFUNT: {
        name: "SPECIAL OPERATIONS FORCES (SOF)",
        mainIcon: csv2json(mil_std_2525b_sof)
      }
    },
    TACGRP: {
      name: "TACTICAL GRAPHICS",
      mainIcon: csv2json(mil_std_2525b_tactical_graphics)
    },
    SIGINT: {
      name: "SIGNALS INTELLIGENCE",
      mainIcon: csv2json(mil_std_2525b_signals_intelligence)
    },
    MOOTW: {
      name: "MILITARY OPERATIONS OTHER THAN WAR (MOOTW)",
      mainIcon: csv2json(mil_std_2525b_mootw)
    }
  };

  var mil_std_2525c_space = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSPC \tS\t*\tP\t*\t------\tSPACE TRACK\t\nSPC.SAT \tS\t*\tP\t*\tS-----\tSATELLITE\t\nSPC.CSV \tS\t*\tP\t*\tV-----\tCREWED SPACE VEHICLE\t\nSPC.SST \tS\t*\tP\t*\tT-----\tSPACE STATION\t\nSPC.SLV \tS\t*\tP\t*\tL-----\tSPACE LAUNCH VEHICLE\t";

  var mil_std_2525c_air = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nAIRTRK \tS\t*\tA\t*\t------\tAIR TRACK\t\nAIRTRK.MIL \tS\t*\tA\t*\tM-----\tMILITARY\t\nAIRTRK.MIL.FIXD \tS\t*\tA\t*\tMF----\tFIXED WING\t\nAIRTRK.MIL.FIXD.BMB \tS\t*\tA\t*\tMFB---\tBOMBER\t\nAIRTRK.MIL.FIXD.FTR \tS\t*\tA\t*\tMFF---\tFIGHTER\t\nAIRTRK.MIL.FIXD.FTR.INCR \tS\t*\tA\t*\tMFFI--\tINTERCEPTOR\t\nAIRTRK.MIL.FIXD.TNE \tS\t*\tA\t*\tMFT---\tTRAINER\t\nAIRTRK.MIL.FIXD.ATK \tS\t*\tA\t*\tMFA---\tATTACK/STRIKE\t\nAIRTRK.MIL.FIXD.VSTOL \tS\t*\tA\t*\tMFL---\tV/STOL\t\nAIRTRK.MIL.FIXD.TNK \tS\t*\tA\t*\tMFK---\tTANKER\t\nAIRTRK.MIL.FIXD.TNK.BOOM \tS\t*\tA\t*\tMFKB--\tTANKER BOOM-ONLY\t\nAIRTRK.MIL.FIXD.TNK.DROG \tS\t*\tA\t*\tMFKD--\tTANKER DROGUE-ONLY\t\nAIRTRK.MIL.FIXD.CGOALT \tS\t*\tA\t*\tMFC---\tCARGO AIRLIFT (TRANSPORT)\t\nAIRTRK.MIL.FIXD.CGOALT.LIT \tS\t*\tA\t*\tMFCL--\tCARGO AIRLIFT (LIGHT)\t\nAIRTRK.MIL.FIXD.CGOALT.MDM \tS\t*\tA\t*\tMFCM--\tCARGO AIRLIFT (MEDIUM)\t\nAIRTRK.MIL.FIXD.CGOALT.HVY \tS\t*\tA\t*\tMFCH--\tCARGO AIRLIFT (HEAVY)\t\nAIRTRK.MIL.FIXD.ECM \tS\t*\tA\t*\tMFJ---\tELECTRONIC COUNTERMEASURES (ECM/JAMMER)\t\nAIRTRK.MIL.FIXD.MEDV \tS\t*\tA\t*\tMFO---\tMEDICAL EVACUATION (MEDEVAC)\t\nAIRTRK.MIL.FIXD.RECON \tS\t*\tA\t*\tMFR---\tRECONNAISSANCE\t\nAIRTRK.MIL.FIXD.RECON.ABNEW \tS\t*\tA\t*\tMFRW--\tAIRBORNE EARLY WARNING (AEW)\t\nAIRTRK.MIL.FIXD.RECON.ESM \tS\t*\tA\t*\tMFRZ--\tELECTRONIC SURVEILLANCE MEASURES\t\nAIRTRK.MIL.FIXD.RECON.PHG \tS\t*\tA\t*\tMFRX--\tPHOTOGRAPHIC\t\nAIRTRK.MIL.FIXD.PAT \tS\t*\tA\t*\tMFP---\tPATROL\t\nAIRTRK.MIL.FIXD.PAT.ASUW \tS\t*\tA\t*\tMFPN--\tANTISURFACE WARFARE (ASUW)\t\nAIRTRK.MIL.FIXD.PAT.MNECM \tS\t*\tA\t*\tMFPM--\tMINE COUNTERMEASURES\t\nAIRTRK.MIL.FIXD.UTY \tS\t*\tA\t*\tMFU---\tUTILITY\t\nAIRTRK.MIL.FIXD.UTY.LIT \tS\t*\tA\t*\tMFUL--\tUTILITY (LIGHT)\t\nAIRTRK.MIL.FIXD.UTY.MDM \tS\t*\tA\t*\tMFUM--\tUTILITY (MEDIUM)\t\nAIRTRK.MIL.FIXD.UTY.HVY \tS\t*\tA\t*\tMFUH--\tUTILITY (HEAVY)\t\nAIRTRK.MIL.FIXD.COMM \tS\t*\tA\t*\tMFY---\tCOMMUNICATIONS\t\nAIRTRK.MIL.FIXD.CSAR \tS\t*\tA\t*\tMFH---\tCOMBAT SEARCH AND RESCUE (CSAR)\t\nAIRTRK.MIL.FIXD.ABNCP \tS\t*\tA\t*\tMFD---\tAIRBORNE COMMAND POST (C2)\t\nAIRTRK.MIL.FIXD.DRN \tS\t*\tA\t*\tMFQ---\tDRONE (RPV/UA)\t\nAIRTRK.MIL.FIXD.DRN.ATK \tS\t*\tA\t*\tMFQA--\tATTACK\t\nAIRTRK.MIL.FIXD.DRN.BMB \tS\t*\tA\t*\tMFQB--\tBOMBER\t\nAIRTRK.MIL.FIXD.DRN.CGO \tS\t*\tA\t*\tMFQC--\tCARGO\t\nAIRTRK.MIL.FIXD.DRN.ABNCP \tS\t*\tA\t*\tMFQD--\tAIRBORNE COMMAND POST\t\nAIRTRK.MIL.FIXD.DRN.FTR \tS\t*\tA\t*\tMFQF--\tFIGHTER\t\nAIRTRK.MIL.FIXD.DRN.CSAR \tS\t*\tA\t*\tMFQH--\tSEARCH & RESCUE (CSAR)\t\nAIRTRK.MIL.FIXD.DRN.ECM \tS\t*\tA\t*\tMFQJ--\tELECTRONIC COUNTERMEASURES (JAMMER)\t\nAIRTRK.MIL.FIXD.DRN.TNK \tS\t*\tA\t*\tMFQK--\tTANKER\t\nAIRTRK.MIL.FIXD.DRN.VSTOL \tS\t*\tA\t*\tMFQL--\tV/STOL\t\nAIRTRK.MIL.FIXD.DRN.SOF \tS\t*\tA\t*\tMFQM--\tSPECIAL OPERATIONS FORCES (SOF)\t\nAIRTRK.MIL.FIXD.DRN.MNECM \tS\t*\tA\t*\tMFQI--\tMINE COUNTERMEASURES\t\nAIRTRK.MIL.FIXD.DRN.ASUW \tS\t*\tA\t*\tMFQN--\tANTISURFACE WARFARE (ASUW)\t\nAIRTRK.MIL.FIXD.DRN.PAT \tS\t*\tA\t*\tMFQP--\tPATROL\t\nAIRTRK.MIL.FIXD.DRN.RECON \tS\t*\tA\t*\tMFQR--\tRECONNAISSANCE\t\nAIRTRK.MIL.FIXD.DRN.RECON.ABNEW \tS\t*\tA\t*\tMFQRW-\tAIRBORNE EARLY WARNING (AEW)\t\nAIRTRK.MIL.FIXD.DRN.RECON.ESM \tS\t*\tA\t*\tMFQRZ-\tELECTRONIC SURVEILLANCE MEASURES\t\nAIRTRK.MIL.FIXD.DRN.RECON.PHG \tS\t*\tA\t*\tMFQRX-\tPHOTOGRAPHIC\t\nAIRTRK.MIL.FIXD.DRN.ASBW \tS\t*\tA\t*\tMFQS--\tANTISUBMARINE WARFARE (ASW)\t\nAIRTRK.MIL.FIXD.DRN.TNE \tS\t*\tA\t*\tMFQT--\tTRAINER\t\nAIRTRK.MIL.FIXD.DRN.UTY \tS\t*\tA\t*\tMFQU--\tUTILITY\t\nAIRTRK.MIL.FIXD.DRN.COMM \tS\t*\tA\t*\tMFQY--\tCOMMUNICATIONS\t\nAIRTRK.MIL.FIXD.DRN.MEDV \tS\t*\tA\t*\tMFQO--\tMEDEVAC\t\nAIRTRK.MIL.FIXD.ASBWCB \tS\t*\tA\t*\tMFS---\tANTISUBMARINE WARFARE (ASW) CARRIER BASED\t\nAIRTRK.MIL.FIXD.SOF \tS\t*\tA\t*\tMFM---\tSPECIAL OPERATIONS FORCES (SOF)\t\nAIRTRK.MIL.ROT \tS\t*\tA\t*\tMH----\tROTARY WING\t\nAIRTRK.MIL.ROT.ATK \tS\t*\tA\t*\tMHA---\tATTACK\t\nAIRTRK.MIL.ROT.ASBW \tS\t*\tA\t*\tMHS---\tANTISUBMARINE WARFARE/MPA\t\nAIRTRK.MIL.ROT.UTY \tS\t*\tA\t*\tMHU---\tUTILITY\t\nAIRTRK.MIL.ROT.UTY.LIT \tS\t*\tA\t*\tMHUL--\tUTILITY (LIGHT)\t\nAIRTRK.MIL.ROT.UTY.MDM \tS\t*\tA\t*\tMHUM--\tUTILITY (MEDIUM)\t\nAIRTRK.MIL.ROT.UTY.HVY \tS\t*\tA\t*\tMHUH--\tUTILITY (HEAVY)\t\nAIRTRK.MIL.ROT.MNECM \tS\t*\tA\t*\tMHI---\tMINE COUNTERMEASURES\t\nAIRTRK.MIL.ROT.CSAR \tS\t*\tA\t*\tMHH---\tCOMBAT SEARCH AND RESCUE (CSAR)\t\nAIRTRK.MIL.ROT.RECON \tS\t*\tA\t*\tMHR---\tRECONNAISSANCE\t\nAIRTRK.MIL.ROT.DRN \tS\t*\tA\t*\tMHQ---\tDRONE (RPV/UA)\t\nAIRTRK.MIL.ROT.CGOALT \tS\t*\tA\t*\tMHC---\tCARGO AIRLIFT (TRANSPORT)\t\nAIRTRK.MIL.ROT.CGOALT.LIT \tS\t*\tA\t*\tMHCL--\tCARGO AIRLIFT (LIGHT)\t\nAIRTRK.MIL.ROT.CGOALT.MDM \tS\t*\tA\t*\tMHCM--\tCARGO AIRLIFT (MEDIUM)\t\nAIRTRK.MIL.ROT.CGOALT.HVY \tS\t*\tA\t*\tMHCH--\tCARGO AIRLIFT (HEAVY)\t\nAIRTRK.MIL.ROT.TNE \tS\t*\tA\t*\tMHT---\tTRAINER\t\nAIRTRK.MIL.ROT.MEDV \tS\t*\tA\t*\tMHO---\tMEDEVAC\t\nAIRTRK.MIL.ROT.SOF \tS\t*\tA\t*\tMHM---\tSPECIAL OPERATIONS FORCES (SOF)\t\nAIRTRK.MIL.ROT.ABNCP \tS\t*\tA\t*\tMHD---\tAIRBORNE COMMAND POST (C2)\t\nAIRTRK.MIL.ROT.TNK \tS\t*\tA\t*\tMHK---\tTANKER\t\nAIRTRK.MIL.ROT.ECM \tS\t*\tA\t*\tMHJ---\tELECTRONIC COUNTERMEASURES (ECM/JAMMER)\t\nAIRTRK.MIL.LTA \tS\t*\tA\t*\tML----\tLIGHTER THAN AIR\t\nAIRTRK.MIL.VIP \tS\t*\tA\t*\tMV----\tVERY IMPORTANT PERSON (VIP)\t\nAIRTRK.MIL.ESCORT \tS\t*\tA\t*\tME----\tESCORT\t\nAIRTRK.WPN \tS\t*\tA\t*\tW-----\tWEAPON\t\nAIRTRK.WPN.MSLIF \tS\t*\tA\t*\tWM----\tMISSILE IN FLIGHT\t\nAIRTRK.WPN.MSLIF.SLM \tS\t*\tA\t*\tWMS---\tSURFACE LAUNCHED MISSILE\t\nAIRTRK.WPN.MSLIF.SLM.SSM \tS\t*\tA\t*\tWMSS--\tSURFACE-TO-SURFACE MISSILE (SSM)\t\nAIRTRK.WPN.MSLIF.SLM.SAM \tS\t*\tA\t*\tWMSA--\tSURFACE-TO-AIR MISSILE (SAM)\t\nAIRTRK.WPN.MSLIF.SLM.SSUM \tS\t*\tA\t*\tWMSU--\tSURFACE-TO-SUBSURFACE MISSILE\t\nAIRTRK.WPN.MSLIF.SLM.ABM \tS\t*\tA\t*\tWMSB--\tANTIBALLISTIC MISSILE (ABM)\t\nAIRTRK.WPN.MSLIF.ALM \tS\t*\tA\t*\tWMA---\tAIR LAUNCHED MISSILE\t\nAIRTRK.WPN.MSLIF.ALM.ASM \tS\t*\tA\t*\tWMAS--\tAIR-TO-SURFACE MISSILE (ASM)\t\nAIRTRK.WPN.MSLIF.ALM.AAM \tS\t*\tA\t*\tWMAA--\tAIR-TO-AIR MISSILE (AAM)\t\nAIRTRK.WPN.MSLIF.ALM.ASPC \tS\t*\tA\t*\tWMAP--\tAIR-TO-SPACE MISSILE\t\nAIRTRK.WPN.MSLIF.SBSM \tS\t*\tA\t*\tWMU---\tSUBSURFACE-TO-SURFACE MISSILE (S/SSM)\t\nAIRTRK.WPN.MSLIF.CM \tS\t*\tA\t*\tWMCM--\tCRUISE MISSILE\t\nAIRTRK.WPN.MSLIF.BLST \tS\t*\tA\t*\tWMB---\tBALLISTIC MISSILE\t\nAIRTRK.WPN.BM \tS\t*\tA\t*\tWB----\tBOMB\t\nAIRTRK.WPN.DCY \tS\t*\tA\t*\tWD----\tDECOY\t\nAIRTRK.CVL \tS\t*\tA\t*\tC-----\tCIVIL AIRCRAFT\t\nAIRTRK.CVL.FIXD \tS\t*\tA\t*\tCF----\tFIXED WING\t\nAIRTRK.CVL.ROT \tS\t*\tA\t*\tCH----\tROTARY WING\t\nAIRTRK.CVL.LTA \tS\t*\tA\t*\tCL----\tLIGHTER THAN AIR\t";

  var mil_std_2525c_ground_unit = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nGRDTRK \tS\t*\tG\t*\t------\tGROUND TRACK\t\nGRDTRK.UNT \tS\t*\tG\t*\tU-----\tUNIT\t\nGRDTRK.UNT.CBT \tS\t*\tG\t*\tUC----\tCOMBAT\t\nGRDTRK.UNT.CBT.ADF \tS\t*\tG\t*\tUCD---\tAIR DEFENSE\t\nGRDTRK.UNT.CBT.ADF.SHTR \tS\t*\tG\t*\tUCDS--\tSHORT RANGE\t\nGRDTRK.UNT.CBT.ADF.SHTR.CPL \tS\t*\tG\t*\tUCDSC-\tCHAPARRAL\t\nGRDTRK.UNT.CBT.ADF.SHTR.STG \tS\t*\tG\t*\tUCDSS-\tSTINGER\t\nGRDTRK.UNT.CBT.ADF.SHTR.VUL \tS\t*\tG\t*\tUCDSV-\tVULCAN\t\nGRDTRK.UNT.CBT.ADF.MSL \tS\t*\tG\t*\tUCDM--\tAIR DEFENSE MISSILE\t\nGRDTRK.UNT.CBT.ADF.MSL.LIT \tS\t*\tG\t*\tUCDML-\tAIR DEFENSE MISSILE LIGHT\t\nGRDTRK.UNT.CBT.ADF.MSL.LIT.MOT \tS\t*\tG\t*\tUCDMLA\tAIR DEFENSE MISSILE MOTORIZED (AVENGER)\t\nGRDTRK.UNT.CBT.ADF.MSL.MDM \tS\t*\tG\t*\tUCDMM-\tAIR DEFENSE MISSILE MEDIUM\t\nGRDTRK.UNT.CBT.ADF.MSL.HVY \tS\t*\tG\t*\tUCDMH-\tAIR DEFENSE MISSILE HEAVY\t\nGRDTRK.UNT.CBT.ADF.MSL.HMAD \tS\t*\tG\t*\tUCDH--\tH/MAD\t\nGRDTRK.UNT.CBT.ADF.MSL.HMAD.HWK \tS\t*\tG\t*\tUCDHH-\tHAWK\t\nGRDTRK.UNT.CBT.ADF.MSL.HMAD.PATT \tS\t*\tG\t*\tUCDHP-\tPATRIOT\t\nGRDTRK.UNT.CBT.ADF.GUNUNT \tS\t*\tG\t*\tUCDG--\tGUN UNIT\t\nGRDTRK.UNT.CBT.ADF.CMPS \tS\t*\tG\t*\tUCDC--\tCOMPOSITE\t\nGRDTRK.UNT.CBT.ADF.TGTGUT \tS\t*\tG\t*\tUCDT--\tTARGETING UNIT\t\nGRDTRK.UNT.CBT.ADF.TMDU \tS\t*\tG\t*\tUCDO--\tTHEATER MISSILE DEFENSE UNIT\t\nGRDTRK.UNT.CBT.ARM \tS\t*\tG\t*\tUCA---\tARMOR\t\nGRDTRK.UNT.CBT.ARM.TRK \tS\t*\tG\t*\tUCAT--\tARMOR TRACK\t\nGRDTRK.UNT.CBT.ARM.TRK.ABN \tS\t*\tG\t*\tUCATA-\tARMOR TRACK AIRBORNE\t\nGRDTRK.UNT.CBT.ARM.TRK.AMP \tS\t*\tG\t*\tUCATW-\tARMOR TRACK AMPHIBIOUS\t\nGRDTRK.UNT.CBT.ARM.TRK.AMP.RCY \tS\t*\tG\t*\tUCATWR\tARMOR TRACK AMPHIBIOUS RECOVERY\t\nGRDTRK.UNT.CBT.ARM.TRK.LIT \tS\t*\tG\t*\tUCATL-\tARMOR TRACK, LIGHT\t\nGRDTRK.UNT.CBT.ARM.TRK.MDM \tS\t*\tG\t*\tUCATM-\tARMOR TRACK, MEDIUM\t\nGRDTRK.UNT.CBT.ARM.TRK.HVY \tS\t*\tG\t*\tUCATH-\tARMOR TRACK, HEAVY\t\nGRDTRK.UNT.CBT.ARM.TRK.RCY \tS\t*\tG\t*\tUCATR-\tARMOR TRACK, RECOVERY\t\nGRDTRK.UNT.CBT.ARM.WHD \tS\t*\tG\t*\tUCAW--\tARMOR, WHEELED\t\nGRDTRK.UNT.CBT.ARM.WHD.AAST \tS\t*\tG\t*\tUCAWS-\tARMOR, WHEELED AIR ASSAULT\t\nGRDTRK.UNT.CBT.ARM.WHD.ABN \tS\t*\tG\t*\tUCAWA-\tARMOR, WHEELED AIRBORNE\t\nGRDTRK.UNT.CBT.ARM.WHD.AMP \tS\t*\tG\t*\tUCAWW-\tARMOR, WHEELED AMPHIBIOUS\t\nGRDTRK.UNT.CBT.ARM.WHD.AMP.RCY \tS\t*\tG\t*\tUCAWWR\tARMOR, WHEELED AMPHIBIOUS RECOVERY\t\nGRDTRK.UNT.CBT.ARM.WHD.LIT \tS\t*\tG\t*\tUCAWL-\tARMOR, WHEELED LIGHT\t\nGRDTRK.UNT.CBT.ARM.WHD.MDM \tS\t*\tG\t*\tUCAWM-\tARMOR, WHEELED MEDIUM\t\nGRDTRK.UNT.CBT.ARM.WHD.HVY \tS\t*\tG\t*\tUCAWH-\tARMOR, WHEELED HEAVY\t\nGRDTRK.UNT.CBT.ARM.WHD.RCY \tS\t*\tG\t*\tUCAWR-\tARMOR, WHEELED RECOVERY\t\nGRDTRK.UNT.CBT.AARM \tS\t*\tG\t*\tUCAA--\tANTIARMOR\t\nGRDTRK.UNT.CBT.AARM.DMD \tS\t*\tG\t*\tUCAAD-\tANTIARMOR DISMOUNTED\t\nGRDTRK.UNT.CBT.AARM.LIT \tS\t*\tG\t*\tUCAAL-\tANTIARMOR LIGHT\t\nGRDTRK.UNT.CBT.AARM.ABN \tS\t*\tG\t*\tUCAAM-\tANTIARMOR AIRBORNE\t\nGRDTRK.UNT.CBT.AARM.AAST \tS\t*\tG\t*\tUCAAS-\tANTIARMOR AIR ASSAULT\t\nGRDTRK.UNT.CBT.AARM.MNT \tS\t*\tG\t*\tUCAAU-\tANTIARMOR MOUNTAIN\t\nGRDTRK.UNT.CBT.AARM.ARC \tS\t*\tG\t*\tUCAAC-\tANTIARMOR ARCTIC\t\nGRDTRK.UNT.CBT.AARM.ARMD \tS\t*\tG\t*\tUCAAA-\tANTIARMOR ARMORED\t\nGRDTRK.UNT.CBT.AARM.ARMD.TKD \tS\t*\tG\t*\tUCAAAT\tANTIARMOR ARMORED TRACKED\t\nGRDTRK.UNT.CBT.AARM.ARMD.WHD \tS\t*\tG\t*\tUCAAAW\tANTIARMOR ARMORED WHEELED\t\nGRDTRK.UNT.CBT.AARM.ARMD.AAST \tS\t*\tG\t*\tUCAAAS\tANTIARMOR ARMORED AIR ASSAULT\t\nGRDTRK.UNT.CBT.AARM.MOT \tS\t*\tG\t*\tUCAAO-\tANTIARMOR MOTORIZED\t\nGRDTRK.UNT.CBT.AARM.MOT.AAST \tS\t*\tG\t*\tUCAAOS\tANTIARMOR MOTORIZED AIR ASSAULT\t\nGRDTRK.UNT.CBT.AVN \tS\t*\tG\t*\tUCV---\tAVIATION\t\nGRDTRK.UNT.CBT.AVN.FIXD \tS\t*\tG\t*\tUCVF--\tFIXED WING\t\nGRDTRK.UNT.CBT.AVN.FIXD.UTY \tS\t*\tG\t*\tUCVFU-\tUTILITY FIXED WING\t\nGRDTRK.UNT.CBT.AVN.FIXD.ATK \tS\t*\tG\t*\tUCVFA-\tATTACK FIXED WING\t\nGRDTRK.UNT.CBT.AVN.FIXD.RECON \tS\t*\tG\t*\tUCVFR-\tRECON FIXED WING\t\nGRDTRK.UNT.CBT.AVN.ROT \tS\t*\tG\t*\tUCVR--\tROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.ATK \tS\t*\tG\t*\tUCVRA-\tATTACK ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.SCUT \tS\t*\tG\t*\tUCVRS-\tSCOUT ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.ASBW \tS\t*\tG\t*\tUCVRW-\tANTISUBMARINE WARFARE ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.UTY \tS\t*\tG\t*\tUCVRU-\tUTILITY ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.UTY.LIT \tS\t*\tG\t*\tUCVRUL\tLIGHT UTILITY ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.UTY.MDM \tS\t*\tG\t*\tUCVRUM\tMEDIUM UTILITY ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.UTY.HVY \tS\t*\tG\t*\tUCVRUH\tHEAVY UTILITY ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.C2 \tS\t*\tG\t*\tUCVRUC\tC2 ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.MEDV \tS\t*\tG\t*\tUCVRUE\tMEDEVAC ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.ROT.MNECM \tS\t*\tG\t*\tUCVRM-\tMINE COUNTERMEASURE ROTARY WING\t\nGRDTRK.UNT.CBT.AVN.SAR \tS\t*\tG\t*\tUCVS--\tSEARCH AND RESCUE\t\nGRDTRK.UNT.CBT.AVN.CMPS \tS\t*\tG\t*\tUCVC--\tCOMPOSITE\t\nGRDTRK.UNT.CBT.AVN.VSTOL \tS\t*\tG\t*\tUCVV--\tVERTICAL AND/OR SHORT TAKEOFF AND LANDING AIRCRAFT(V/STOL)\t\nGRDTRK.UNT.CBT.AVN.UA \tS\t*\tG\t*\tUCVU--\tUNMANNED AIRCRAFT\t\nGRDTRK.UNT.CBT.AVN.UA.FIXD \tS\t*\tG\t*\tUCVUF-\tUNMANNED AIRCRAFT FIXED WING\t\nGRDTRK.UNT.CBT.AVN.UA.ROT \tS\t*\tG\t*\tUCVUR-\tUNMANNED AIRCRAFT ROTARY WING\t\nGRDTRK.UNT.CBT.INF \tS\t*\tG\t*\tUCI---\tINFANTRY\t\nGRDTRK.UNT.CBT.INF.LIT \tS\t*\tG\t*\tUCIL--\tINFANTRY LIGHT\t\nGRDTRK.UNT.CBT.INF.MOT \tS\t*\tG\t*\tUCIM--\tINFANTRY MOTORIZED\t\nGRDTRK.UNT.CBT.INF.MNT \tS\t*\tG\t*\tUCIO--\tINFANTRY MOUNTAIN\t\nGRDTRK.UNT.CBT.INF.ABN \tS\t*\tG\t*\tUCIA--\tINFANTRY AIRBORNE\t\nGRDTRK.UNT.CBT.INF.AAST \tS\t*\tG\t*\tUCIS--\tINFANTRY AIR ASSAULT\t\nGRDTRK.UNT.CBT.INF.MECH \tS\t*\tG\t*\tUCIZ--\tINFANTRY MECHANIZED\t\nGRDTRK.UNT.CBT.INF.NAV \tS\t*\tG\t*\tUCIN--\tINFANTRY NAVAL\t\nGRDTRK.UNT.CBT.INF.INFFV \tS\t*\tG\t*\tUCII--\tINFANTRY FIGHTING VEHICLE\t\nGRDTRK.UNT.CBT.INF.ARC \tS\t*\tG\t*\tUCIC--\tINFANTRY ARCTIC\t\nGRDTRK.UNT.CBT.ENG \tS\t*\tG\t*\tUCE---\tENGINEER\t\nGRDTRK.UNT.CBT.ENG.CBT \tS\t*\tG\t*\tUCEC--\tENGINEER COMBAT\t\nGRDTRK.UNT.CBT.ENG.CBT.AAST \tS\t*\tG\t*\tUCECS-\tENGINEER COMBAT AIR ASSAULT\t\nGRDTRK.UNT.CBT.ENG.CBT.ABN \tS\t*\tG\t*\tUCECA-\tENGINEER COMBAT AIRBORNE\t\nGRDTRK.UNT.CBT.ENG.CBT.ARC \tS\t*\tG\t*\tUCECC-\tENGINEER COMBAT ARCTIC\t\nGRDTRK.UNT.CBT.ENG.CBT.LIT \tS\t*\tG\t*\tUCECL-\tENGINEER COMBAT LIGHT (SAPPER)\t\nGRDTRK.UNT.CBT.ENG.CBT.MDM \tS\t*\tG\t*\tUCECM-\tENGINEER COMBAT MEDIUM\t\nGRDTRK.UNT.CBT.ENG.CBT.HVY \tS\t*\tG\t*\tUCECH-\tENGINEER COMBAT HEAVY\t\nGRDTRK.UNT.CBT.ENG.CBT.MECH \tS\t*\tG\t*\tUCECT-\tENGINEER COMBAT MECHANIZED (TRACK)\t\nGRDTRK.UNT.CBT.ENG.CBT.MOT \tS\t*\tG\t*\tUCECW-\tENGINEER COMBAT MOTORIZED\t\nGRDTRK.UNT.CBT.ENG.CBT.MNT \tS\t*\tG\t*\tUCECO-\tENGINEER COMBAT MOUNTAIN\t\nGRDTRK.UNT.CBT.ENG.CBT.RECON \tS\t*\tG\t*\tUCECR-\tENGINEER COMBAT RECON\t\nGRDTRK.UNT.CBT.ENG.CSN \tS\t*\tG\t*\tUCEN--\tENGINEER CONSTRUCTION\t\nGRDTRK.UNT.CBT.ENG.CSN.NAV \tS\t*\tG\t*\tUCENN-\tENGINEER NAVAL CONSTRUCTION\t\nGRDTRK.UNT.CBT.FLDART \tS\t*\tG\t*\tUCF---\tFIELD ARTILLERY\t\nGRDTRK.UNT.CBT.FLDART.HOW \tS\t*\tG\t*\tUCFH--\tHOWITZER/GUN\t\nGRDTRK.UNT.CBT.FLDART.HOW.SPD \tS\t*\tG\t*\tUCFHE-\tSELF-PROPELLED\t\nGRDTRK.UNT.CBT.FLDART.HOW.AAST \tS\t*\tG\t*\tUCFHS-\tAIR ASSAULT\t\nGRDTRK.UNT.CBT.FLDART.HOW.ABN \tS\t*\tG\t*\tUCFHA-\tAIRBORNE\t\nGRDTRK.UNT.CBT.FLDART.HOW.ARC \tS\t*\tG\t*\tUCFHC-\tARCTIC\t\nGRDTRK.UNT.CBT.FLDART.HOW.MNT \tS\t*\tG\t*\tUCFHO-\tMOUNTAIN\t\nGRDTRK.UNT.CBT.FLDART.HOW.LIT \tS\t*\tG\t*\tUCFHL-\tLIGHT\t\nGRDTRK.UNT.CBT.FLDART.HOW.MDM \tS\t*\tG\t*\tUCFHM-\tMEDIUM\t\nGRDTRK.UNT.CBT.FLDART.HOW.HVY \tS\t*\tG\t*\tUCFHH-\tHEAVY\t\nGRDTRK.UNT.CBT.FLDART.HOW.AMP \tS\t*\tG\t*\tUCFHX-\tAMPHIBIOUS\t\nGRDTRK.UNT.CBT.FLDART.ROC \tS\t*\tG\t*\tUCFR--\tROCKET\t\nGRDTRK.UNT.CBT.FLDART.ROC.SRL \tS\t*\tG\t*\tUCFRS-\tSINGLE ROCKET LAUNCHER\t\nGRDTRK.UNT.CBT.FLDART.ROC.SRL.SRSPD \tS\t*\tG\t*\tUCFRSS\tSINGLE ROCKET SELF-PROPELLED\t\nGRDTRK.UNT.CBT.FLDART.ROC.SRL.SRTRK \tS\t*\tG\t*\tUCFRSR\tSINGLE ROCKET TRUCK\t\nGRDTRK.UNT.CBT.FLDART.ROC.SRL.SRTOW \tS\t*\tG\t*\tUCFRST\tSINGLE ROCKET TOWED\t\nGRDTRK.UNT.CBT.FLDART.ROC.MRL \tS\t*\tG\t*\tUCFRM-\tMULTIPLE ROCKET LAUNCHER\t\nGRDTRK.UNT.CBT.FLDART.ROC.MRL.MRSPD \tS\t*\tG\t*\tUCFRMS\tMULTIPLE ROCKET SELF-PROPELLED\t\nGRDTRK.UNT.CBT.FLDART.ROC.MRL.MRTRK \tS\t*\tG\t*\tUCFRMR\tMULTIPLE ROCKET TRUCK\t\nGRDTRK.UNT.CBT.FLDART.ROC.MRL.MRTOW \tS\t*\tG\t*\tUCFRMT\tMULTIPLE ROCKET TOWED\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ \tS\t*\tG\t*\tUCFT--\tTARGET ACQUISITION\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.RAD \tS\t*\tG\t*\tUCFTR-\tRADAR\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.SND \tS\t*\tG\t*\tUCFTS-\tSOUND\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.FLH \tS\t*\tG\t*\tUCFTF-\tFLASH (OPTICAL)\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.CLT \tS\t*\tG\t*\tUCFTC-\tCOLT/FIST\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.CLT.DMD \tS\t*\tG\t*\tUCFTCD\tDISMOUNTED COLT/FIST\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.CLT.TKD \tS\t*\tG\t*\tUCFTCM\tTRACKED COLT/FIST\t\nGRDTRK.UNT.CBT.FLDART.TGTAQ.ANG \tS\t*\tG\t*\tUCFTA-\tANGLICO\t\nGRDTRK.UNT.CBT.FLDART.MORT \tS\t*\tG\t*\tUCFM--\tMORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.SPDTRK \tS\t*\tG\t*\tUCFMS-\tSELF-PROPELLED (SP) TRACKED MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.SPDWHD \tS\t*\tG\t*\tUCFMW-\tSP WHEELED MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.TOW \tS\t*\tG\t*\tUCFMT-\tTOWED MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.TOW.ABN \tS\t*\tG\t*\tUCFMTA\tTOWED AIRBORNE MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.TOW.AAST \tS\t*\tG\t*\tUCFMTS\tTOWED AIR ASSAULT MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.TOW.ARC \tS\t*\tG\t*\tUCFMTC\tTOWED ARCTIC MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.TOW.MNT \tS\t*\tG\t*\tUCFMTO\tTOWED MOUNTAIN MORTAR\t\nGRDTRK.UNT.CBT.FLDART.MORT.AMP \tS\t*\tG\t*\tUCFML-\tAMPHIBIOUS MORTAR\t\nGRDTRK.UNT.CBT.FLDART.ARTSVY \tS\t*\tG\t*\tUCFS--\tARTILLERY SURVEY\t\nGRDTRK.UNT.CBT.FLDART.ARTSVY.AAST \tS\t*\tG\t*\tUCFSS-\tAIR ASSAULT\t\nGRDTRK.UNT.CBT.FLDART.ARTSVY.ABN \tS\t*\tG\t*\tUCFSA-\tAIRBORNE\t\nGRDTRK.UNT.CBT.FLDART.ARTSVY.LIT \tS\t*\tG\t*\tUCFSL-\tLIGHT\t\nGRDTRK.UNT.CBT.FLDART.ARTSVY.MNT \tS\t*\tG\t*\tUCFSO-\tMOUNTAIN\t\nGRDTRK.UNT.CBT.FLDART.METO \tS\t*\tG\t*\tUCFO--\tMETEOROLOGICAL\t\nGRDTRK.UNT.CBT.FLDART.METO.AAST \tS\t*\tG\t*\tUCFOS-\tAIR ASSAULT METEOROLOGICAL\t\nGRDTRK.UNT.CBT.FLDART.METO.ABN \tS\t*\tG\t*\tUCFOA-\tAIRBORNE METEOROLOGICAL\t\nGRDTRK.UNT.CBT.FLDART.METO.LIT \tS\t*\tG\t*\tUCFOL-\tLIGHT METEOROLOGICAL\t\nGRDTRK.UNT.CBT.FLDART.METO.MNT \tS\t*\tG\t*\tUCFOO-\tMOUNTAIN METEOROLOGICAL\t\nGRDTRK.UNT.CBT.RECON \tS\t*\tG\t*\tUCR---\tRECONNAISSANCE\t\nGRDTRK.UNT.CBT.RECON.HRE \tS\t*\tG\t*\tUCRH--\tRECONNAISSANCE HORSE\t\nGRDTRK.UNT.CBT.RECON.CVY \tS\t*\tG\t*\tUCRV--\tRECONNAISSANCE CAVALRY\t\nGRDTRK.UNT.CBT.RECON.CVY.ARMD \tS\t*\tG\t*\tUCRVA-\tRECONNAISSANCE CAVALRY ARMORED\t\nGRDTRK.UNT.CBT.RECON.CVY.MOT \tS\t*\tG\t*\tUCRVM-\tRECONNAISSANCE CAVALRY MOTORIZED\t\nGRDTRK.UNT.CBT.RECON.CVY.GRD \tS\t*\tG\t*\tUCRVG-\tRECONNAISSANCE CAVALRY GROUND\t\nGRDTRK.UNT.CBT.RECON.CVY.AIR \tS\t*\tG\t*\tUCRVO-\tRECONNAISSANCE CAVALRY AIR\t\nGRDTRK.UNT.CBT.RECON.ARC \tS\t*\tG\t*\tUCRC--\tRECONNAISSANCE ARCTIC\t\nGRDTRK.UNT.CBT.RECON.AAST \tS\t*\tG\t*\tUCRS--\tRECONNAISSANCE AIR ASSAULT\t\nGRDTRK.UNT.CBT.RECON.ABN \tS\t*\tG\t*\tUCRA--\tRECONNAISSANCE AIRBORNE\t\nGRDTRK.UNT.CBT.RECON.MNT \tS\t*\tG\t*\tUCRO--\tRECONNAISSANCE MOUNTAIN\t\nGRDTRK.UNT.CBT.RECON.LIT \tS\t*\tG\t*\tUCRL--\tRECONNAISSANCE LIGHT\t\nGRDTRK.UNT.CBT.RECON.MAR \tS\t*\tG\t*\tUCRR--\tRECONNAISSANCE MARINE\t\nGRDTRK.UNT.CBT.RECON.MAR.DIV \tS\t*\tG\t*\tUCRRD-\tRECONNAISSANCE MARINE DIVISION\t\nGRDTRK.UNT.CBT.RECON.MAR.FOR \tS\t*\tG\t*\tUCRRF-\tRECONNAISSANCE MARINE FORCE\t\nGRDTRK.UNT.CBT.RECON.MAR.LAR \tS\t*\tG\t*\tUCRRL-\tRECONNAISSANCE MARINE LIGHT ARMORED RECONNAISSNACE (LAR)\t\nGRDTRK.UNT.CBT.RECON.LRS \tS\t*\tG\t*\tUCRX--\tRECONNAISSANCE LONG RANGE SURVEILLANCE (LRS)\t\nGRDTRK.UNT.CBT.MSL \tS\t*\tG\t*\tUCM---\tMISSILE (SURF-SURF)\t\nGRDTRK.UNT.CBT.MSL.TAC \tS\t*\tG\t*\tUCMT--\tMISSILE (SURF-SURF) TACTICAL\t\nGRDTRK.UNT.CBT.MSL.STGC \tS\t*\tG\t*\tUCMS--\tMISSILE (SURF-SURF) STRATEGIC\t\nGRDTRK.UNT.CBT.ISF \tS\t*\tG\t*\tUCS---\tINTERNAL SECURITY FORCES\t\nGRDTRK.UNT.CBT.ISF.RIV \tS\t*\tG\t*\tUCSW--\tRIVERINE\t\nGRDTRK.UNT.CBT.ISF.GRD \tS\t*\tG\t*\tUCSG--\tGROUND\t\nGRDTRK.UNT.CBT.ISF.GRD.DMD \tS\t*\tG\t*\tUCSGD-\tDISMOUNTED GROUND\t\nGRDTRK.UNT.CBT.ISF.GRD.MOT \tS\t*\tG\t*\tUCSGM-\tMOTORIZED GROUND\t\nGRDTRK.UNT.CBT.ISF.GRD.MECH \tS\t*\tG\t*\tUCSGA-\tMECHANIZED GROUND\t\nGRDTRK.UNT.CBT.ISF.WHMECH \tS\t*\tG\t*\tUCSM--\tWHEELED MECHANIZED\t\nGRDTRK.UNT.CBT.ISF.RALRD \tS\t*\tG\t*\tUCSR--\tRAILROAD\t\nGRDTRK.UNT.CBT.ISF.AVN \tS\t*\tG\t*\tUCSA--\tAVIATION\t\nGRDTRK.UNT.CS \tS\t*\tG\t*\tUU----\tCOMBAT SUPPORT\t\nGRDTRK.UNT.CS.CBRN \tS\t*\tG\t*\tUUA---\tCOMBAT SUPPORT CBRN\t\nGRDTRK.UNT.CS.CBRN.CML \tS\t*\tG\t*\tUUAC--\tCHEMICAL\t\nGRDTRK.UNT.CS.CBRN.CML.SMKDEC \tS\t*\tG\t*\tUUACC-\tSMOKE/DECON\t\nGRDTRK.UNT.CS.CBRN.CML.SMKDEC.MECH \tS\t*\tG\t*\tUUACCK\tMECHANIZED SMOKE/DECON\t\nGRDTRK.UNT.CS.CBRN.CML.SMKDEC.MOT \tS\t*\tG\t*\tUUACCM\tMOTORIZED SMOKE/DECON\t\nGRDTRK.UNT.CS.CBRN.CML.SMK \tS\t*\tG\t*\tUUACS-\tSMOKE\t\nGRDTRK.UNT.CS.CBRN.CML.SMK.MOT \tS\t*\tG\t*\tUUACSM\tMOTORIZED SMOKE\t\nGRDTRK.UNT.CS.CBRN.CML.SMK.ARM \tS\t*\tG\t*\tUUACSA\tARMOR SMOKE\t\nGRDTRK.UNT.CS.CBRN.CML.RECON \tS\t*\tG\t*\tUUACR-\tCHEMICAL RECON\t\nGRDTRK.UNT.CS.CBRN.CML.RECON.WARMVH \tS\t*\tG\t*\tUUACRW\tCHEMICAL WHEELED ARMORED VEHICLE\t\nGRDTRK.UNT.CS.CBRN.CML.RECON.WAVS \tS\t*\tG\t*\tUUACRS\tCHEMICAL WHEELED ARMORED VEHICLE RECONNAISSANCE \t\nGRDTRK.UNT.CS.CBRN.NUC \tS\t*\tG\t*\tUUAN--\tNUCLEAR\t\nGRDTRK.UNT.CS.CBRN.BIO \tS\t*\tG\t*\tUUAB--\tBIOLOGICAL\t\nGRDTRK.UNT.CS.CBRN.BIO.RECEQP \tS\t*\tG\t*\tUUABR-\tRECON EQUIPPED\t\nGRDTRK.UNT.CS.CBRN.DECON \tS\t*\tG\t*\tUUAD--\tDECONTAMINATION\t\nGRDTRK.UNT.CS.MILINT \tS\t*\tG\t*\tUUM---\tMILITARY INTELLIGENCE\t\nGRDTRK.UNT.CS.MILINT.AEREXP \tS\t*\tG\t*\tUUMA--\tAERIAL EXPLOITATION\t\nGRDTRK.UNT.CS.MILINT.SIGINT \tS\t*\tG\t*\tUUMS--\tSIGNAL INTELLIGENCE (SIGINT)\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW \tS\t*\tG\t*\tUUMSE-\tELECTRONIC WARFARE\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.ARMWVH \tS\t*\tG\t*\tUUMSEA\tARMORED WHEELED VEHICLE\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.DFN \tS\t*\tG\t*\tUUMSED\tDIRECTION FINDING\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.INC \tS\t*\tG\t*\tUUMSEI\tINTERCEPT\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.JMG \tS\t*\tG\t*\tUUMSEJ\tJAMMING\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.THT \tS\t*\tG\t*\tUUMSET\tTHEATER\t\nGRDTRK.UNT.CS.MILINT.SIGINT.ECW.CRP \tS\t*\tG\t*\tUUMSEC\tCORPS\t\nGRDTRK.UNT.CS.MILINT.CINT \tS\t*\tG\t*\tUUMC--\tCOUNTERINTELLIGENCE\t\nGRDTRK.UNT.CS.MILINT.SVL \tS\t*\tG\t*\tUUMR--\tSURVEILLANCE\t\nGRDTRK.UNT.CS.MILINT.SVL.GRDSR \tS\t*\tG\t*\tUUMRG-\tGROUND SURVEILLANCE RADAR\t\nGRDTRK.UNT.CS.MILINT.SVL.SNS \tS\t*\tG\t*\tUUMRS-\tSENSOR\t\nGRDTRK.UNT.CS.MILINT.SVL.SNS.SCM \tS\t*\tG\t*\tUUMRSS\tSENSOR SCM\t\nGRDTRK.UNT.CS.MILINT.SVL.GRDSM \tS\t*\tG\t*\tUUMRX-\tGROUND STATION MODULE\t\nGRDTRK.UNT.CS.MILINT.SVL.METO \tS\t*\tG\t*\tUUMMO-\tMETEOROLOGICAL\t\nGRDTRK.UNT.CS.MILINT.OPN \tS\t*\tG\t*\tUUMO--\tOPERATIONS\t\nGRDTRK.UNT.CS.MILINT.TACEXP \tS\t*\tG\t*\tUUMT--\tTACTICAL EXPLOIT\t\nGRDTRK.UNT.CS.MILINT.INTGN \tS\t*\tG\t*\tUUMQ--\tINTERROGATION\t\nGRDTRK.UNT.CS.MILINT.JINTCT \tS\t*\tG\t*\tUUMJ--\tJOINT INTELLIGENCE CENTER\t\nGRDTRK.UNT.CS.LAWENU \tS\t*\tG\t*\tUUL---\tLAW ENFORCEMENT UNIT\t\nGRDTRK.UNT.CS.LAWENU.SHRPAT \tS\t*\tG\t*\tUULS--\tSHORE PATROL\t\nGRDTRK.UNT.CS.LAWENU.MILP \tS\t*\tG\t*\tUULM--\tMILITARY POLICE\t\nGRDTRK.UNT.CS.LAWENU.CLE \tS\t*\tG\t*\tUULC--\tCIVILIAN LAW ENFORCEMENT\t\nGRDTRK.UNT.CS.LAWENU.SECPOL \tS\t*\tG\t*\tUULF--\tSECURITY POLICE (AIR)\t\nGRDTRK.UNT.CS.LAWENU.CID \tS\t*\tG\t*\tUULD--\tCENTRAL INTELLIGENCE DIVISION (CID)\t\nGRDTRK.UNT.CS.SIGUNT \tS\t*\tG\t*\tUUS---\tSIGNAL UNIT\t\nGRDTRK.UNT.CS.SIGUNT.ARA \tS\t*\tG\t*\tUUSA--\tAREA\t\nGRDTRK.UNT.CS.SIGUNT.COMCP \tS\t*\tG\t*\tUUSC--\tCOMMUNICATION CONFIGURED PACKAGE\t\nGRDTRK.UNT.CS.SIGUNT.COMCP.LCCP \tS\t*\tG\t*\tUUSCL-\tLARGE COMMUNICATION CONFIGURED PACKAGE (LCCP)\t\nGRDTRK.UNT.CS.SIGUNT.CMDOPN \tS\t*\tG\t*\tUUSO--\tCOMMAND OPERATIONS\t\nGRDTRK.UNT.CS.SIGUNT.FWDCOM \tS\t*\tG\t*\tUUSF--\tFORWARD COMMUNICATIONS\t\nGRDTRK.UNT.CS.SIGUNT.MSE \tS\t*\tG\t*\tUUSM--\tMULTIPLE SUBSCRIBER ELEMENT\t\nGRDTRK.UNT.CS.SIGUNT.MSE.SEN \tS\t*\tG\t*\tUUSMS-\tSMALL EXTENSION NODE\t\nGRDTRK.UNT.CS.SIGUNT.MSE.LEN \tS\t*\tG\t*\tUUSML-\tLARGE EXTENSION NODE\t\nGRDTRK.UNT.CS.SIGUNT.MSE.NODCTR \tS\t*\tG\t*\tUUSMN-\tNODE CENTER\t\nGRDTRK.UNT.CS.SIGUNT.RDOUNT \tS\t*\tG\t*\tUUSR--\tRADIO UNIT\t\nGRDTRK.UNT.CS.SIGUNT.RDOUNT.TACSAT \tS\t*\tG\t*\tUUSRS-\tTACTICAL SATELLITE\t\nGRDTRK.UNT.CS.SIGUNT.RDOUNT.TTYCTR \tS\t*\tG\t*\tUUSRT-\tTELETYPE CENTER\t\nGRDTRK.UNT.CS.SIGUNT.RDOUNT.RLY \tS\t*\tG\t*\tUUSRW-\tRELAY\t\nGRDTRK.UNT.CS.SIGUNT.SIGSUP \tS\t*\tG\t*\tUUSS--\tSIGNAL SUPPORT\t\nGRDTRK.UNT.CS.SIGUNT.PHOSWT \tS\t*\tG\t*\tUUSW--\tTELEPHONE SWITCH\t\nGRDTRK.UNT.CS.SIGUNT.ECRG \tS\t*\tG\t*\tUUSX--\tELECTRONIC RANGING\t\nGRDTRK.UNT.CS.IWU \tS\t*\tG\t*\tUUI---\tINFORMATION WARFARE UNIT\t\nGRDTRK.UNT.CS.LNDSUP \tS\t*\tG\t*\tUUP---\tLANDING SUPPORT\t\nGRDTRK.UNT.CS.EOD \tS\t*\tG\t*\tUUE---\tEXPLOSIVE ORDNANCE DISPOSAL\t\nGRDTRK.UNT.CSS \tS\t*\tG\t*\tUS----\tCOMBAT SERVICE SUPPORT\t\nGRDTRK.UNT.CSS.ADMIN \tS\t*\tG\t*\tUSA---\tADMINISTRATIVE (ADMIN)\t\nGRDTRK.UNT.CSS.ADMIN.THT \tS\t*\tG\t*\tUSAT--\tADMIN THEATER\t\nGRDTRK.UNT.CSS.ADMIN.CRP \tS\t*\tG\t*\tUSAC--\tADMIN CORPS\t\nGRDTRK.UNT.CSS.ADMIN.JAG \tS\t*\tG\t*\tUSAJ--\tJUDGE ADVOCATE GENERAL (JAG)\t\nGRDTRK.UNT.CSS.ADMIN.JAG.THT \tS\t*\tG\t*\tUSAJT-\tJAG THEATER\t\nGRDTRK.UNT.CSS.ADMIN.JAG.CRP \tS\t*\tG\t*\tUSAJC-\tJAG CORPS\t\nGRDTRK.UNT.CSS.ADMIN.PST \tS\t*\tG\t*\tUSAO--\tPOSTAL\t\nGRDTRK.UNT.CSS.ADMIN.PST.THT \tS\t*\tG\t*\tUSAOT-\tPOSTAL THEATER\t\nGRDTRK.UNT.CSS.ADMIN.PST.CRP \tS\t*\tG\t*\tUSAOC-\tPOSTAL CORPS\t\nGRDTRK.UNT.CSS.ADMIN.FIN \tS\t*\tG\t*\tUSAF--\tFINANCE\t\nGRDTRK.UNT.CSS.ADMIN.FIN.THT \tS\t*\tG\t*\tUSAFT-\tFINANCE THEATER\t\nGRDTRK.UNT.CSS.ADMIN.FIN.CRP \tS\t*\tG\t*\tUSAFC-\tFINANCE CORPS\t\nGRDTRK.UNT.CSS.ADMIN.PERSVC \tS\t*\tG\t*\tUSAS--\tPERSONNEL SERVICES\t\nGRDTRK.UNT.CSS.ADMIN.PERSVC.THT \tS\t*\tG\t*\tUSAST-\tPERSONNEL THEATER\t\nGRDTRK.UNT.CSS.ADMIN.PERSVC.CRP \tS\t*\tG\t*\tUSASC-\tPERSONNEL CORPS\t\nGRDTRK.UNT.CSS.ADMIN.MTRY \tS\t*\tG\t*\tUSAM--\tMORTUARY/GRAVES REGISTRY\t\nGRDTRK.UNT.CSS.ADMIN.MTRY.THT \tS\t*\tG\t*\tUSAMT-\tMORTUARY/GRAVES REGISTRY THEATER\t\nGRDTRK.UNT.CSS.ADMIN.MTRY.CRP \tS\t*\tG\t*\tUSAMC-\tMORTUARY/GRAVES REGISTRY CORPS\t\nGRDTRK.UNT.CSS.ADMIN.RELG \tS\t*\tG\t*\tUSAR--\tRELIGIOUS/CHAPLAIN\t\nGRDTRK.UNT.CSS.ADMIN.RELG.THT \tS\t*\tG\t*\tUSART-\tRELIGIOUS/CHAPLAIN THEATER\t\nGRDTRK.UNT.CSS.ADMIN.RELG.CRP \tS\t*\tG\t*\tUSARC-\tRELIGIOUS/CHAPLAIN CORPS\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF \tS\t*\tG\t*\tUSAP--\tPUBLIC AFFAIRS\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.THT \tS\t*\tG\t*\tUSAPT-\tPUBLIC AFFAIRS THEATER\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.CRP \tS\t*\tG\t*\tUSAPC-\tPUBLIC AFFAIRS CORPS\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT \tS\t*\tG\t*\tUSAPB-\tPUBLIC AFFAIRS BROADCAST\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT.THT \tS\t*\tG\t*\tUSAPBT\tPUBLIC AFFAIRS BROADCAST THEATER\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.BRCT.CRP \tS\t*\tG\t*\tUSAPBC\tPUBLIC AFFAIRS BROADCAST CORPS\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB \tS\t*\tG\t*\tUSAPM-\tPUBLIC AFFAIRS JOINT INFORMATION BUREAU (JIB)\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB.THT \tS\t*\tG\t*\tUSAPMT\tPUBLIC AFFAIRS JIB THEATER\t\nGRDTRK.UNT.CSS.ADMIN.PUBAFF.JIB.CRP \tS\t*\tG\t*\tUSAPMC\tPUBLIC AFFAIRS JIB CORPS\t\nGRDTRK.UNT.CSS.ADMIN.RHU \tS\t*\tG\t*\tUSAX--\tREPLACEMENT HOLDING UNIT (RHU)\t\nGRDTRK.UNT.CSS.ADMIN.RHU.THT \tS\t*\tG\t*\tUSAXT-\tRHU THEATER\t\nGRDTRK.UNT.CSS.ADMIN.RHU.CRP \tS\t*\tG\t*\tUSAXC-\tRHU CORPS\t\nGRDTRK.UNT.CSS.ADMIN.LBR \tS\t*\tG\t*\tUSAL--\tLABOR\t\nGRDTRK.UNT.CSS.ADMIN.LBR.THT \tS\t*\tG\t*\tUSALT-\tLABOR THEATER\t\nGRDTRK.UNT.CSS.ADMIN.LBR.CRP \tS\t*\tG\t*\tUSALC-\tLABOR CORPS\t\nGRDTRK.UNT.CSS.ADMIN.MWR \tS\t*\tG\t*\tUSAW--\tMORALE, WELFARE, RECREATION (MWR)\t\nGRDTRK.UNT.CSS.ADMIN.MWR.THT \tS\t*\tG\t*\tUSAWT-\tMWR THEATER\t\nGRDTRK.UNT.CSS.ADMIN.MWR.CRP \tS\t*\tG\t*\tUSAWC-\tMWR CORPS\t\nGRDTRK.UNT.CSS.ADMIN.SUPPLY \tS\t*\tG\t*\tUSAQ--\tQUARTERMASTER (SUPPLY)\t\nGRDTRK.UNT.CSS.ADMIN.SUPPLY.THT \tS\t*\tG\t*\tUSAQT-\tQUARTERMASTER (SUPPLY) THEATER\t\nGRDTRK.UNT.CSS.ADMIN.SUPPLY.CRP \tS\t*\tG\t*\tUSAQC-\tQUARTERMASTER (SUPPLY) CORPS\t\nGRDTRK.UNT.CSS.MED \tS\t*\tG\t*\tUSM---\tMEDICAL\t\nGRDTRK.UNT.CSS.MED.THT \tS\t*\tG\t*\tUSMT--\tMEDICAL THEATER\t\nGRDTRK.UNT.CSS.MED.CRP \tS\t*\tG\t*\tUSMC--\tMEDICAL CORPS\t\nGRDTRK.UNT.CSS.MED.MEDTF \tS\t*\tG\t*\tUSMM--\tMEDICAL TREATMENT FACILITY\t\nGRDTRK.UNT.CSS.MED.MEDTF.THT \tS\t*\tG\t*\tUSMMT-\tMEDICAL TREATMENT FACILITY THEATER\t\nGRDTRK.UNT.CSS.MED.MEDTF.CRP \tS\t*\tG\t*\tUSMMC-\tMEDICAL TREATMENT FACILITY CORPS\t\nGRDTRK.UNT.CSS.MED.VNY \tS\t*\tG\t*\tUSMV--\tMEDICAL VETERINARY\t\nGRDTRK.UNT.CSS.MED.VNY.THT \tS\t*\tG\t*\tUSMVT-\tMEDICAL VETERINARY THEATER\t\nGRDTRK.UNT.CSS.MED.VNY.CRP \tS\t*\tG\t*\tUSMVC-\tMEDICAL VETERINARY CORPS\t\nGRDTRK.UNT.CSS.MED.DEN \tS\t*\tG\t*\tUSMD--\tMEDICAL DENTAL\t\nGRDTRK.UNT.CSS.MED.DEN.THT \tS\t*\tG\t*\tUSMDT-\tMEDICAL DENTAL THEATER\t\nGRDTRK.UNT.CSS.MED.DEN.CRP \tS\t*\tG\t*\tUSMDC-\tMEDICAL DENTAL CORPS\t\nGRDTRK.UNT.CSS.MED.PSY \tS\t*\tG\t*\tUSMP--\tMEDICAL PSYCHOLOGICAL\t\nGRDTRK.UNT.CSS.MED.PSY.THT \tS\t*\tG\t*\tUSMPT-\tMEDICAL PSYCHOLOGICAL THEATER\t\nGRDTRK.UNT.CSS.MED.PSY.CRP \tS\t*\tG\t*\tUSMPC-\tMEDICAL PSYCHOLOGICAL CORPS\t\nGRDTRK.UNT.CSS.SLP \tS\t*\tG\t*\tUSS---\tSUPPLY\t\nGRDTRK.UNT.CSS.SLP.THT \tS\t*\tG\t*\tUSST--\tSUPPLY THEATER\t\nGRDTRK.UNT.CSS.SLP.CRP \tS\t*\tG\t*\tUSSC--\tSUPPLY CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS1 \tS\t*\tG\t*\tUSS1--\tSUPPLY CLASS I\t\nGRDTRK.UNT.CSS.SLP.CLS1.THT \tS\t*\tG\t*\tUSS1T-\tSUPPLY CLASS I THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS1.CRP \tS\t*\tG\t*\tUSS1C-\tSUPPLY CLASS I CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS2 \tS\t*\tG\t*\tUSS2--\tSUPPLY CLASS II\t\nGRDTRK.UNT.CSS.SLP.CLS2.THT \tS\t*\tG\t*\tUSS2T-\tSUPPLY CLASS II THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS2.CRP \tS\t*\tG\t*\tUSS2C-\tSUPPLY CLASS II CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS3 \tS\t*\tG\t*\tUSS3--\tSUPPLY CLASS III\t\nGRDTRK.UNT.CSS.SLP.CLS3.THT \tS\t*\tG\t*\tUSS3T-\tSUPPLY CLASS III THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS3.CRP \tS\t*\tG\t*\tUSS3C-\tSUPPLY CLASS III CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS3.AVN \tS\t*\tG\t*\tUSS3A-\tSUPPLY CLASS III AVIATION\t\nGRDTRK.UNT.CSS.SLP.CLS3.AVN.THT \tS\t*\tG\t*\tUSS3AT\tSUPPLY CLASS III AVIATION THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS3.AVN.CRP \tS\t*\tG\t*\tUSS3AC\tSUPPLY CLASS III AVIATION CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS4 \tS\t*\tG\t*\tUSS4--\tSUPPLY CLASS IV\t\nGRDTRK.UNT.CSS.SLP.CLS4.THT \tS\t*\tG\t*\tUSS4T-\tSUPPLY CLASS IV THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS4.CRP \tS\t*\tG\t*\tUSS4C-\tSUPPLY CLASS IV CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS5 \tS\t*\tG\t*\tUSS5--\tSUPPLY CLASS V\t\nGRDTRK.UNT.CSS.SLP.CLS5.THT \tS\t*\tG\t*\tUSS5T-\tSUPPLY CLASS V THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS5.CRP \tS\t*\tG\t*\tUSS5C-\tSUPPLY CLASS V CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS6 \tS\t*\tG\t*\tUSS6--\tSUPPLY CLASS VI\t\nGRDTRK.UNT.CSS.SLP.CLS6.THT \tS\t*\tG\t*\tUSS6T-\tSUPPLY CLASS VI THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS6.CRP \tS\t*\tG\t*\tUSS6C-\tSUPPLY CLASS VI CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS7 \tS\t*\tG\t*\tUSS7--\tSUPPLY CLASS VII\t\nGRDTRK.UNT.CSS.SLP.CLS7.THT \tS\t*\tG\t*\tUSS7T-\tSUPPLY CLASS VII THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS7.CRP \tS\t*\tG\t*\tUSS7C-\tSUPPLY CLASS VII CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS8 \tS\t*\tG\t*\tUSS8--\tSUPPLY CLASS VIII\t\nGRDTRK.UNT.CSS.SLP.CLS8.THT \tS\t*\tG\t*\tUSS8T-\tSUPPLY CLASS VIII THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS8.CRP \tS\t*\tG\t*\tUSS8C-\tSUPPLY CLASS VIII CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS9 \tS\t*\tG\t*\tUSS9--\tSUPPLY CLASS IX\t\nGRDTRK.UNT.CSS.SLP.CLS9.THT \tS\t*\tG\t*\tUSS9T-\tSUPPLY CLASS IX THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS9.CRP \tS\t*\tG\t*\tUSS9C-\tSUPPLY CLASS IX CORPS\t\nGRDTRK.UNT.CSS.SLP.CLS10 \tS\t*\tG\t*\tUSSX--\tSUPPLY CLASS X\t\nGRDTRK.UNT.CSS.SLP.CLS10.THT \tS\t*\tG\t*\tUSSXT-\tSUPPLY CLASS X THEATER\t\nGRDTRK.UNT.CSS.SLP.CLS10.CRP \tS\t*\tG\t*\tUSSXC-\tSUPPLY CLASS X CORPS\t\nGRDTRK.UNT.CSS.SLP.LDY \tS\t*\tG\t*\tUSSL--\tSUPPLY LAUNDRY/BATH\t\nGRDTRK.UNT.CSS.SLP.LDY.THT \tS\t*\tG\t*\tUSSLT-\tSUPPLY LAUNDRY/BATH THEATER\t\nGRDTRK.UNT.CSS.SLP.LDY.CRP \tS\t*\tG\t*\tUSSLC-\tSUPPLY LAUNDRY/BATH CORPS\t\nGRDTRK.UNT.CSS.SLP.H2O \tS\t*\tG\t*\tUSSW--\tSUPPLY WATER\t\nGRDTRK.UNT.CSS.SLP.H2O.THT \tS\t*\tG\t*\tUSSWT-\tSUPPLY WATER THEATER\t\nGRDTRK.UNT.CSS.SLP.H2O.CRP \tS\t*\tG\t*\tUSSWC-\tSUPPLY WATER CORPS\t\nGRDTRK.UNT.CSS.SLP.H2O.PUR \tS\t*\tG\t*\tUSSWP-\tSUPPLY WATER PURIFICATION\t\nGRDTRK.UNT.CSS.SLP.H2O.PUR.THT \tS\t*\tG\t*\tUSSWPT\tSUPPLY WATER PURIFICATION THEATER\t\nGRDTRK.UNT.CSS.SLP.H2O.PUR.CRP \tS\t*\tG\t*\tUSSWPC\tSUPPLY WATER PURIFICATION CORPS\t\nGRDTRK.UNT.CSS.TPT \tS\t*\tG\t*\tUST---\tTRANSPORTATION\t\nGRDTRK.UNT.CSS.TPT.THT \tS\t*\tG\t*\tUSTT--\tTRANSPORTATION THEATER\t\nGRDTRK.UNT.CSS.TPT.CRP \tS\t*\tG\t*\tUSTC--\tTRANSPORTATION CORPS\t\nGRDTRK.UNT.CSS.TPT.MCC \tS\t*\tG\t*\tUSTM--\tMOVEMENT CONTROL CENTER (MCC)\t\nGRDTRK.UNT.CSS.TPT.MCC.THT \tS\t*\tG\t*\tUSTMT-\tMCC THEATER\t\nGRDTRK.UNT.CSS.TPT.MCC.CRP \tS\t*\tG\t*\tUSTMC-\tMCC CORPS\t\nGRDTRK.UNT.CSS.TPT.RHD \tS\t*\tG\t*\tUSTR--\tRAILHEAD\t\nGRDTRK.UNT.CSS.TPT.RHD.THT \tS\t*\tG\t*\tUSTRT-\tRAILHEAD THEATER\t\nGRDTRK.UNT.CSS.TPT.RHD.CRP \tS\t*\tG\t*\tUSTRC-\tRAILHEAD CORPS\t\nGRDTRK.UNT.CSS.TPT.SPOD \tS\t*\tG\t*\tUSTS--\tSPOD/SPOE\t\nGRDTRK.UNT.CSS.TPT.SPOD.THT \tS\t*\tG\t*\tUSTST-\tSPOD/SPOE THEATER\t\nGRDTRK.UNT.CSS.TPT.SPOD.CRP \tS\t*\tG\t*\tUSTSC-\tSPOD/SPOE CORPS\t\nGRDTRK.UNT.CSS.TPT.APOD \tS\t*\tG\t*\tUSTA--\tAPOD/APOE\t\nGRDTRK.UNT.CSS.TPT.APOD.THT \tS\t*\tG\t*\tUSTAT-\tAPOD/APOE THEATER\t\nGRDTRK.UNT.CSS.TPT.APOD.CRP \tS\t*\tG\t*\tUSTAC-\tAPOD/APOE CORPS\t\nGRDTRK.UNT.CSS.TPT.MSL \tS\t*\tG\t*\tUSTI--\tMISSILE\t\nGRDTRK.UNT.CSS.TPT.MSL.THT \tS\t*\tG\t*\tUSTIT-\tMISSILE THEATER\t\nGRDTRK.UNT.CSS.TPT.MSL.CRP \tS\t*\tG\t*\tUSTIC-\tMISSILE CORPS\t\nGRDTRK.UNT.CSS.MAINT \tS\t*\tG\t*\tUSX---\tMAINTENANCE\t\nGRDTRK.UNT.CSS.MAINT.THT \tS\t*\tG\t*\tUSXT--\tMAINTENANCE THEATER\t\nGRDTRK.UNT.CSS.MAINT.CRP \tS\t*\tG\t*\tUSXC--\tMAINTENANCE CORPS\t\nGRDTRK.UNT.CSS.MAINT.HVY \tS\t*\tG\t*\tUSXH--\tMAINTENANCE HEAVY\t\nGRDTRK.UNT.CSS.MAINT.HVY.THT \tS\t*\tG\t*\tUSXHT-\tMAINTENANCE HEAVY THEATER\t\nGRDTRK.UNT.CSS.MAINT.HVY.CRP \tS\t*\tG\t*\tUSXHC-\tMAINTENANCE HEAVY CORPS\t\nGRDTRK.UNT.CSS.MAINT.RCY \tS\t*\tG\t*\tUSXR--\tMAINTENANCE RECOVERY\t\nGRDTRK.UNT.CSS.MAINT.RCY.THT \tS\t*\tG\t*\tUSXRT-\tMAINTENANCE RECOVERY THEATER\t\nGRDTRK.UNT.CSS.MAINT.RCY.CRP \tS\t*\tG\t*\tUSXRC-\tMAINTENANCE RECOVERY CORPS\t\nGRDTRK.UNT.CSS.MAINT.ORD \tS\t*\tG\t*\tUSXO--\tORDNANCE\t\nGRDTRK.UNT.CSS.MAINT.ORD.THT \tS\t*\tG\t*\tUSXOT-\tORDNANCE THEATER\t\nGRDTRK.UNT.CSS.MAINT.ORD.CRP \tS\t*\tG\t*\tUSXOC-\tORDNANCE CORPS\t\nGRDTRK.UNT.CSS.MAINT.ORD.MSL \tS\t*\tG\t*\tUSXOM-\tORDNANCE MISSILE\t\nGRDTRK.UNT.CSS.MAINT.ORD.MSL.THT \tS\t*\tG\t*\tUSXOMT\tORDNANCE MISSILE THEATER\t\nGRDTRK.UNT.CSS.MAINT.ORD.MSL.CRP \tS\t*\tG\t*\tUSXOMC\tORDNANCE MISSILE CORPS\t\nGRDTRK.UNT.CSS.MAINT.EOP \tS\t*\tG\t*\tUSXE--\tELECTRO-OPTICAL\t\nGRDTRK.UNT.CSS.MAINT.EOP.THT \tS\t*\tG\t*\tUSXET-\tELECTRO-OPTICAL THEATER\t\nGRDTRK.UNT.CSS.MAINT.EOP.CRP \tS\t*\tG\t*\tUSXEC-\tELECTRO-OPTICAL CORPS\t\nGRDTRK.UNT.C2HQ \tS\t*\tG\t*\tUH----\tSPECIAL C2 HEADQUARTERS COMPONENT\t";

  var mil_std_2525c_ground_equipment = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nGRDTRK.EQT \tS\t*\tG\t*\tE-----\tGROUND TRACK EQUIPMENT\t\nGRDTRK.EQT.WPN \tS\t*\tG\t*\tEW----\tWEAPON\tN/A\nGRDTRK.EQT.WPN.MSLL \tS\t*\tG\t*\tEWM---\tMISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD \tS\t*\tG\t*\tEWMA--\tAIR DEFENSE (AD) MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.SHTR \tS\t*\tG\t*\tEWMAS-\tSHORT RANGE AD MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.SHTR.TLAR \tS\t*\tG\t*\tEWMASR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.SHTR.TELAR \tS\t*\tG\t*\tEWMASE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.INTMR \tS\t*\tG\t*\tEWMAI-\tINTERMEDIATE RANGE AD MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.INTMR.TLAR \tS\t*\tG\t*\tEWMAIR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.INTMR.TELAR \tS\t*\tG\t*\tEWMAIE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.LNGR \tS\t*\tG\t*\tEWMAL-\tLONG RANGE AD MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.LNGR.TLAR \tS\t*\tG\t*\tEWMALR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.LNGR.TELAR \tS\t*\tG\t*\tEWMALE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.THT \tS\t*\tG\t*\tEWMAT-\tAD MISSILE LAUNCHER THEATER\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.THT.TLAR \tS\t*\tG\t*\tEWMATR\tTRANSPORTER LAUNCHER AND RADAR (TLAR)\t\nGRDTRK.EQT.WPN.MSLL.ADFAD.THT.TELAR \tS\t*\tG\t*\tEWMATE\tTRANSPORTER ERECTOR LAUNCHER AND RADAR (TELAR)\t\nGRDTRK.EQT.WPN.MSLL.SUF \tS\t*\tG\t*\tEWMS--\tSURF-SURF (SS) MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.SUF.SHTR \tS\t*\tG\t*\tEWMSS-\tSHORT RANGE SS MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.SUF.INTMR \tS\t*\tG\t*\tEWMSI-\tINTERMEDIATE RANGE SS MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.SUF.LNGR \tS\t*\tG\t*\tEWMSL-\tLONG RANGE SS MISSILE LAUNCHER\t\nGRDTRK.EQT.WPN.MSLL.AT \tS\t*\tG\t*\tEWMT--\tMISSILE LAUNCHER ANTITANK (AT)\t\nGRDTRK.EQT.WPN.MSLL.AT.LIT \tS\t*\tG\t*\tEWMTL-\tMISSILE LAUNCHER AT LIGHT\t\nGRDTRK.EQT.WPN.MSLL.AT.MDM \tS\t*\tG\t*\tEWMTM-\tMISSILE LAUNCHER AT MEDIUM\t\nGRDTRK.EQT.WPN.MSLL.AT.HVY \tS\t*\tG\t*\tEWMTH-\tMISSILE LAUNCHER AT HEAVY\t\nGRDTRK.EQT.WPN.SRL \tS\t*\tG\t*\tEWS---\tSINGLE ROCKET LAUNCHER\t\nGRDTRK.EQT.WPN.SRL.LIT \tS\t*\tG\t*\tEWSL--\tSINGLE ROCKET LAUNCHER LIGHT\t\nGRDTRK.EQT.WPN.SRL.MDM \tS\t*\tG\t*\tEWSM--\tSINGLE ROCKET LAUNCHER MEDIUM\t\nGRDTRK.EQT.WPN.SRL.HVY \tS\t*\tG\t*\tEWSH--\tSINGLE ROCKET LAUNCHER HEAVY\t\nGRDTRK.EQT.WPN.MRL \tS\t*\tG\t*\tEWX---\tMULTIPLE ROCKET LAUNCHER\t\nGRDTRK.EQT.WPN.MRL.LIT \tS\t*\tG\t*\tEWXL--\tMULTIPLE ROCKET LAUNCHER LIGHT\t\nGRDTRK.EQT.WPN.MRL.MDM \tS\t*\tG\t*\tEWXM--\tMULTIPLE ROCKET LAUNCHER MEDIUM\t\nGRDTRK.EQT.WPN.MRL.HVY \tS\t*\tG\t*\tEWXH--\tMULTIPLE ROCKET LAUNCHER HEAVY\t\nGRDTRK.EQT.WPN.ATRL \tS\t*\tG\t*\tEWT---\tANTITANK ROCKET LAUNCHER\t\nGRDTRK.EQT.WPN.ATRL.LIT \tS\t*\tG\t*\tEWTL--\tANTITANK ROCKET LAUNCHER LIGHT\t\nGRDTRK.EQT.WPN.ATRL.MDM \tS\t*\tG\t*\tEWTM--\tANTITANK ROCKET LAUNCHER MEDIUM\t\nGRDTRK.EQT.WPN.ATRL.HVY \tS\t*\tG\t*\tEWTH--\tANTITANK ROCKET LAUNCHER HEAVY\t\nGRDTRK.EQT.WPN.RIFWPN \tS\t*\tG\t*\tEWR---\tRIFLE/AUTOMATIC WEAPON\t\nGRDTRK.EQT.WPN.RIFWPN.RIF \tS\t*\tG\t*\tEWRR--\tRIFLE\t\nGRDTRK.EQT.WPN.RIFWPN.LMG \tS\t*\tG\t*\tEWRL--\tLIGHT MACHINE GUN\t\nGRDTRK.EQT.WPN.RIFWPN.HMG \tS\t*\tG\t*\tEWRH--\tHEAVY MACHINE GUN\t\nGRDTRK.EQT.WPN.GREL \tS\t*\tG\t*\tEWZ---\tGRENADE LAUNCHER\t\nGRDTRK.EQT.WPN.GREL.LIT \tS\t*\tG\t*\tEWZL--\tGRENADE LAUNCHER LIGHT\t\nGRDTRK.EQT.WPN.GREL.MDM \tS\t*\tG\t*\tEWZM--\tGRENADE LAUNCHER MEDIUM\t\nGRDTRK.EQT.WPN.GREL.HVY \tS\t*\tG\t*\tEWZH--\tGRENADE LAUNCHER HEAVY\t\nGRDTRK.EQT.WPN.MORT \tS\t*\tG\t*\tEWO---\tMORTAR\t\nGRDTRK.EQT.WPN.MORT.LIT \tS\t*\tG\t*\tEWOL--\tMORTAR LIGHT\t\nGRDTRK.EQT.WPN.MORT.MDM \tS\t*\tG\t*\tEWOM--\tMORTAR MEDIUM\t\nGRDTRK.EQT.WPN.MORT.HVY \tS\t*\tG\t*\tEWOH--\tMORTAR HEAVY\t\nGRDTRK.EQT.WPN.HOW \tS\t*\tG\t*\tEWH---\tHOWITZER\t\nGRDTRK.EQT.WPN.HOW.LIT \tS\t*\tG\t*\tEWHL--\tHOWITZER LIGHT\t\nGRDTRK.EQT.WPN.HOW.LIT.SPD \tS\t*\tG\t*\tEWHLS-\tHOWITZER LIGHT SELF-PROPELLED\t\nGRDTRK.EQT.WPN.HOW.MDM \tS\t*\tG\t*\tEWHM--\tHOWITZER MEDIUM\t\nGRDTRK.EQT.WPN.HOW.MDM.SPD \tS\t*\tG\t*\tEWHMS-\tHOWITZER MEDIUM SELF-PROPELLED\t\nGRDTRK.EQT.WPN.HOW.HVY \tS\t*\tG\t*\tEWHH--\tHOWITZER HEAVY\t\nGRDTRK.EQT.WPN.HOW.HVY.SPD \tS\t*\tG\t*\tEWHHS-\tHOWITZER HEAVY SELF-PROPELLED\t\nGRDTRK.EQT.WPN.ATG \tS\t*\tG\t*\tEWG---\tANTITANK GUN\t\nGRDTRK.EQT.WPN.ATG.LIT \tS\t*\tG\t*\tEWGL--\tANTITANK GUN LIGHT\t\nGRDTRK.EQT.WPN.ATG.MDM \tS\t*\tG\t*\tEWGM--\tANTITANK GUN MEDIUM\t\nGRDTRK.EQT.WPN.ATG.HVY \tS\t*\tG\t*\tEWGH--\tANTITANK GUN HEAVY\t\nGRDTRK.EQT.WPN.ATG.RECL \tS\t*\tG\t*\tEWGR--\tANTITANK GUN RECOILLESS\t\nGRDTRK.EQT.WPN.DFG \tS\t*\tG\t*\tEWD---\tDIRECT FIRE GUN\t\nGRDTRK.EQT.WPN.DFG.LIT \tS\t*\tG\t*\tEWDL--\tDIRECT FIRE GUN LIGHT\t\nGRDTRK.EQT.WPN.DFG.LIT.SPD \tS\t*\tG\t*\tEWDLS-\tDIRECT FIRE GUN LIGHT SELF-PROPELLED\t\nGRDTRK.EQT.WPN.DFG.MDM \tS\t*\tG\t*\tEWDM--\tDIRECT FIRE GUN MEDIUM\t\nGRDTRK.EQT.WPN.DFG.MDM.SPD \tS\t*\tG\t*\tEWDMS-\tDIRECT FIRE GUN MEDIUM SELF-PROPELLED\t\nGRDTRK.EQT.WPN.DFG.HVY \tS\t*\tG\t*\tEWDH--\tDIRECT FIRE GUN HEAVY\t\nGRDTRK.EQT.WPN.DFG.HVY.SPD \tS\t*\tG\t*\tEWDHS-\tDIRECT FIRE GUN HEAVY SELF-PROPELLED\t\nGRDTRK.EQT.WPN.ADFG \tS\t*\tG\t*\tEWA---\tAIR DEFENSE GUN\t\nGRDTRK.EQT.WPN.ADFG.LIT \tS\t*\tG\t*\tEWAL--\tAIR DEFENSE GUN LIGHT\t\nGRDTRK.EQT.WPN.ADFG.MDM \tS\t*\tG\t*\tEWAM--\tAIR DEFENSE GUN MEDIUM\t\nGRDTRK.EQT.WPN.ADFG.HVY \tS\t*\tG\t*\tEWAH--\tAIR DEFENSE GUN HEAVY\t\nGRDTRK.EQT.GRDVEH \tS\t*\tG\t*\tEV----\tGROUND VEHICLE\t\nGRDTRK.EQT.GRDVEH.ARMD \tS\t*\tG\t*\tEVA---\tARMORED VEHICLE\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK \tS\t*\tG\t*\tEVAT--\tTANK\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.LIT \tS\t*\tG\t*\tEVATL-\tTANK LIGHT\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.LIT.RCY \tS\t*\tG\t*\tEVATLR\tTANK LIGHT RECOVERY\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.MDM \tS\t*\tG\t*\tEVATM-\tTANK MEDIUM\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.MDM.RCY \tS\t*\tG\t*\tEVATMR\tTANK MEDIUM RECOVERY\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.HVY \tS\t*\tG\t*\tEVATH-\tTANK HEAVY\t\nGRDTRK.EQT.GRDVEH.ARMD.TANK.HVY.RCY \tS\t*\tG\t*\tEVATHR\tTANK HEAVY RECOVERY\t\nGRDTRK.EQT.GRDVEH.ARMD.ARMPC \tS\t*\tG\t*\tEVAA--\tARMORED PERSONNEL CARRIER\t\nGRDTRK.EQT.GRDVEH.ARMD.ARMPC.RCY \tS\t*\tG\t*\tEVAAR-\tARMORED PERSONNEL CARRIER RECOVERY\t\nGRDTRK.EQT.GRDVEH.ARMD.ARMINF \tS\t*\tG\t*\tEVAI--\tARMORED INFANTRY\t\nGRDTRK.EQT.GRDVEH.ARMD.C2V \tS\t*\tG\t*\tEVAC--\tC2V/ACV\t\nGRDTRK.EQT.GRDVEH.ARMD.CSSVEH \tS\t*\tG\t*\tEVAS--\tCOMBAT SERVICE SUPPORT VEHICLE\t\nGRDTRK.EQT.GRDVEH.ARMD.LARMVH \tS\t*\tG\t*\tEVAL--\tLIGHT ARMORED VEHICLE\t\nGRDTRK.EQT.GRDVEH.UTYVEH \tS\t*\tG\t*\tEVU---\tUTILITY VEHICLE\t\nGRDTRK.EQT.GRDVEH.UTYVEH.BUS \tS\t*\tG\t*\tEVUB--\tBUS\t\nGRDTRK.EQT.GRDVEH.UTYVEH.SEMI \tS\t*\tG\t*\tEVUS--\tSEMI\t\nGRDTRK.EQT.GRDVEH.UTYVEH.SEMI.LIT \tS\t*\tG\t*\tEVUSL-\tSEMI LIGHT\t\nGRDTRK.EQT.GRDVEH.UTYVEH.SEMI.MDM \tS\t*\tG\t*\tEVUSM-\tSEMI MEDIUM\t\nGRDTRK.EQT.GRDVEH.UTYVEH.SEMI.HVY \tS\t*\tG\t*\tEVUSH-\tSEMI HEAVY\t\nGRDTRK.EQT.GRDVEH.UTYVEH.LCCTRK \tS\t*\tG\t*\tEVUL--\tLIMITED CROSS-COUNTRY TRUCK\t\nGRDTRK.EQT.GRDVEH.UTYVEH.CCTRK \tS\t*\tG\t*\tEVUX--\tCROSS-COUNTRY TRUCK\t\nGRDTRK.EQT.GRDVEH.UTYVEH.H2OCRT \tS\t*\tG\t*\tEVUR--\tWATER CRAFT\t\nGRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK \tS\t*\tG\t*\tEVUT--\tTOW TRUCK\t\nGRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK.LIT \tS\t*\tG\t*\tEVUTL-\tTOW TRUCK LIGHT\t\nGRDTRK.EQT.GRDVEH.UTYVEH.TOWTRK.HVY \tS\t*\tG\t*\tEVUTH-\tTOW TRUCK HEAVY\t\nGRDTRK.EQT.GRDVEH.UTYVEH.AMBLNC \tS\t*\tG\t*\tEVUA--\tAMBULANCE\t\nGRDTRK.EQT.GRDVEH.UTYVEH.AMBLNC.ARMD \tS\t*\tG\t*\tEVUAA-\tARMORED AMBULANCE\t\nGRDTRK.EQT.GRDVEH.ENGVEH \tS\t*\tG\t*\tEVE---\tENGINEER VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.BRG \tS\t*\tG\t*\tEVEB--\tBRIDGE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.ERHMR \tS\t*\tG\t*\tEVEE--\tEARTHMOVER\t\nGRDTRK.EQT.GRDVEH.ENGVEH.CSNVEH \tS\t*\tG\t*\tEVEC--\tCONSTRUCTION VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MLVEH \tS\t*\tG\t*\tEVEM--\tMINE LAYING VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MLVEH.ARMCV \tS\t*\tG\t*\tEVEMV-\tARMORED CARRIER WITH VOLCANO\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MLVEH.TRKMV \tS\t*\tG\t*\tEVEML-\tTRUCK MOUNTED WITH VOLCANO\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MCVEH \tS\t*\tG\t*\tEVEA--\tMINE CLEARING VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MCVEH.ARMVM \tS\t*\tG\t*\tEVEAA-\tARMORED MOUNTED MINE CLEARING VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.MCVEH.TM \tS\t*\tG\t*\tEVEAT-\tTRAILER MOUNTED MINE CLEARING VEHICLE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.DZR \tS\t*\tG\t*\tEVED--\tDOZER\t\nGRDTRK.EQT.GRDVEH.ENGVEH.DZR.ARMD \tS\t*\tG\t*\tEVEDA-\tARMORED DOZER\t\nGRDTRK.EQT.GRDVEH.ENGVEH.AST \tS\t*\tG\t*\tEVES--\tARMORED ASSAULT\t\nGRDTRK.EQT.GRDVEH.ENGVEH.ARMERV \tS\t*\tG\t*\tEVER--\tARMORED ENGINEER RECON VEHICLE (AERV)\t\nGRDTRK.EQT.GRDVEH.ENGVEH.BH \tS\t*\tG\t*\tEVEH--\tBACKHOE\t\nGRDTRK.EQT.GRDVEH.ENGVEH.FRYTSP \tS\t*\tG\t*\tEVEF--\tFERRY TRANSPORTER\t\nGRDTRK.EQT.GRDVEH.TRNLCO \tS\t*\tG\t*\tEVT---\tTRAIN LOCOMOTIVE\t\nGRDTRK.EQT.GRDVEH.CVLVEH \tS\t*\tG\t*\tEVC---\tCIVILIAN VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.AUT \tS\t*\tG\t*\tEVCA--\tAUTOMOBILE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.AUT.CPCT \tS\t*\tG\t*\tEVCAL-\tCOMPACT AUTOMOBILE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.AUT.MDSZ \tS\t*\tG\t*\tEVCAM-\tMIDSIZE AUTOMOBILE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.AUT.SDN \tS\t*\tG\t*\tEVCAH-\tSEDAN AUTOMOBILE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.OBTRK \tS\t*\tG\t*\tEVCO--\tOPEN-BED TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.PU \tS\t*\tG\t*\tEVCOL-\tPICKUP OPEN-BED TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.SMAL \tS\t*\tG\t*\tEVCOM-\tSMALL OPEN-BED TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.OBTRK.LRG \tS\t*\tG\t*\tEVCOH-\tLARGE OPEN-BED TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.MPV \tS\t*\tG\t*\tEVCM--\tMULTIPLE PASSENGER VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.MPV.VAN \tS\t*\tG\t*\tEVCML-\tVAN MULTIPLE PASSENGER VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.MPV.SBUS \tS\t*\tG\t*\tEVCMM-\tSMALL BUS MULTIPLE PASSENGER VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.MPV.LBUS \tS\t*\tG\t*\tEVCMH-\tLARGE BUS MULTIPLE PASSENGER VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH \tS\t*\tG\t*\tEVCU--\tUTILITY VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.SUV \tS\t*\tG\t*\tEVCUL-\tSPORT UTILITY VEHICLE (SUV), UTILITY VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.SBOX \tS\t*\tG\t*\tEVCUM-\tSMALL BOX TRUCK, UTILITY VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.UTYVEH.LBOX \tS\t*\tG\t*\tEVCUH-\tLARGE BOX TRUCK, UTILITY VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.JP \tS\t*\tG\t*\tEVCJ--\tJEEP TYPE VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.JP.SMAL \tS\t*\tG\t*\tEVCJL-\tSMALL/LIGHT JEEP TYPE VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.JP.MDM \tS\t*\tG\t*\tEVCJM-\tMEDIUM JEEP TYPE VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.JP.LRG \tS\t*\tG\t*\tEVCJH-\tLARGE/HEAVY JEEP TYPE VEHICLE\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRL \tS\t*\tG\t*\tEVCT--\tTRACTOR TRAILER TRUCK WITH BOX TRAILER\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.SMAL \tS\t*\tG\t*\tEVCTL-\tSMALL/LIGHT BOX TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.MDM \tS\t*\tG\t*\tEVCTM-\tMEDIUM BOX TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRL.LRG \tS\t*\tG\t*\tEVCTH-\tLARGE/HEAVY BOX TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF \tS\t*\tG\t*\tEVCF--\tTRACTOR TRAILER TRUCK WITH FLATBED TRAILER\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.SMAL \tS\t*\tG\t*\tEVCFL-\tSMALL/LIGHT FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.MDM \tS\t*\tG\t*\tEVCFM-\tMEDIUM FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.CVLVEH.TRTRLF.LRG \tS\t*\tG\t*\tEVCFH-\tLARGE/HEAVY FLATBED TRAILER, TRACTOR TRAILER TRUCK\t\nGRDTRK.EQT.GRDVEH.PKAN \tS\t*\tG\t*\tEVM---\tPACK ANIMAL(S)\t\nGRDTRK.EQT.GRDVEH.MSLSPT \tS\t*\tG\t*\tEVS---\tMISSILE SUPPORT VEHICLE\t\nGRDTRK.EQT.GRDVEH.MSLSPT.TLDR \tS\t*\tG\t*\tEVST--\tMISSILE SUPPORT VEHICLE TRANSLOADER\t\nGRDTRK.EQT.GRDVEH.MSLSPT.TPTR \tS\t*\tG\t*\tEVSR--\tMISSILE SUPPORT VEHICLE TRANSPORTER\t\nGRDTRK.EQT.GRDVEH.MSLSPT.CRN \tS\t*\tG\t*\tEVSC--\tMISSILE SUPPORT VEHICLE CRANE/LOADING DEVICE\t\nGRDTRK.EQT.GRDVEH.MSLSPT.PLNT \tS\t*\tG\t*\tEVSP--\tMISSILE SUPPORT VEHICLE PROPELLANT TRANSPORTER\t\nGRDTRK.EQT.GRDVEH.MSLSPT.WH \tS\t*\tG\t*\tEVSW--\tMISSILE SUPPORT VEHICLE WARHEAD TRANSPORTER\t\nGRDTRK.EQT.SNS \tS\t*\tG\t*\tES----\tSENSOR\t\nGRDTRK.EQT.SNS.RAD \tS\t*\tG\t*\tESR---\tRADAR\t\nGRDTRK.EQT.SNS.EMP \tS\t*\tG\t*\tESE---\tEMPLACED SENSOR\t\nGRDTRK.EQT.SPL \tS\t*\tG\t*\tEX----\tSPECIAL EQUIPMENT\tN/A\nGRDTRK.EQT.SPL.IED \tS\t*\tG\t*\tEXI---\tIMPROVISED EXPLOSIVE DEVICE\t\nGRDTRK.EQT.SPL.LSR \tS\t*\tG\t*\tEXL---\tLASER\t\nGRDTRK.EQT.SPL.CBRNEQ \tS\t*\tG\t*\tEXN---\tCBRN EQUIPMENT\t\nGRDTRK.EQT.SPL.FLMTHR \tS\t*\tG\t*\tEXF---\tFLAME THROWER\t\nGRDTRK.EQT.SPL.LNDMNE \tS\t*\tG\t*\tEXM---\tLAND MINES\t\nGRDTRK.EQT.SPL.LNDMNE.CLM \tS\t*\tG\t*\tEXMC--\tCLAYMORE\t\nGRDTRK.EQT.SPL.LNDMNE.LTL \tS\t*\tG\t*\tEXML--\tLESS THAN LETHAL\t\n";

  var mil_std_2525c_ground_installation = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nGRDTRK.INS \tS\t*\tG\t*\tI-----\tINSTALLATION\t\nGRDTRK.INS.RMP \tS\t*\tG\t*\tIR----\tRAW MATERIAL PRODUCTION/STORAGE\t\nGRDTRK.INS.RMP.MNE \tS\t*\tG\t*\tIRM---\tMINE\t\nGRDTRK.INS.RMP.PGO \tS\t*\tG\t*\tIRP---\tPETROLEUM/GAS/OIL\t\nGRDTRK.INS.RMP.CBRN \tS\t*\tG\t*\tIRN---\tCBRN\t\nGRDTRK.INS.RMP.CBRN.BIO \tS\t*\tG\t*\tIRNB--\tBIOLOGICAL\t\nGRDTRK.INS.RMP.CBRN.CML \tS\t*\tG\t*\tIRNC--\tCHEMICAL\t\nGRDTRK.INS.RMP.CBRN.NUC \tS\t*\tG\t*\tIRNN--\tNUCLEAR\t\nGRDTRK.INS.PF \tS\t*\tG\t*\tIP----\tPROCESSING FACILITY\t\nGRDTRK.INS.PF.DECON \tS\t*\tG\t*\tIPD---\tDECONTAMINATION\t\nGRDTRK.INS.EQTMNF \tS\t*\tG\t*\tIE----\tEQUIPMENT MANUFACTURE\t\nGRDTRK.INS.SRUF \tS\t*\tG\t*\tIU----\tSERVICE, RESEARCH, UTILITY FACILITY\t\nGRDTRK.INS.SRUF.TRF \tS\t*\tG\t*\tIUR---\tTECHNOLOGICAL RESEARCH FACILITY\t\nGRDTRK.INS.SRUF.TCF \tS\t*\tG\t*\tIUT---\tTELECOMMUNICATIONS FACILITY\t\nGRDTRK.INS.SRUF.EPF \tS\t*\tG\t*\tIUE---\tELECTRIC POWER FACILITY\t\nGRDTRK.INS.SRUF.EPF.NPT \tS\t*\tG\t*\tIUEN--\tNUCLEAR PLANT\t\nGRDTRK.INS.SRUF.EPF.DAM \tS\t*\tG\t*\tIUED--\tDAM\t\nGRDTRK.INS.SRUF.EPF.FOSF \tS\t*\tG\t*\tIUEF--\tFOSSIL FUEL\t\nGRDTRK.INS.SRUF.PWS \tS\t*\tG\t*\tIUP---\tPUBLIC WATER SERVICES\t\nGRDTRK.INS.MMF \tS\t*\tG\t*\tIM----\tMILITARY MATERIEL FACILITY\tN/A\nGRDTRK.INS.MMF.NENY \tS\t*\tG\t*\tIMF---\tNUCLEAR ENERGY\t\nGRDTRK.INS.MMF.NENY.ATMER \tS\t*\tG\t*\tIMFA--\tATOMIC ENERGY REACTOR\t\nGRDTRK.INS.MMF.NENY.NMP \tS\t*\tG\t*\tIMFP--\tNUCLEAR MATERIAL PRODUCTION\t\nGRDTRK.INS.MMF.NENY.NMP.WPNGR \tS\t*\tG\t*\tIMFPW-\tWEAPONS GRADE\t\nGRDTRK.INS.MMF.NENY.NMS \tS\t*\tG\t*\tIMFS--\tNUCLEAR MATERIAL STORAGE\t\nGRDTRK.INS.MMF.APA \tS\t*\tG\t*\tIMA---\tAIRCRAFT PRODUCTION & ASSEMBLY\t\nGRDTRK.INS.MMF.AMEP \tS\t*\tG\t*\tIME---\tAMMUNITION AND EXPLOSIVES PRODUCTION\t\nGRDTRK.INS.MMF.AMTP \tS\t*\tG\t*\tIMG---\tARMAMENT PRODUCTION\t\nGRDTRK.INS.MMF.MILVP \tS\t*\tG\t*\tIMV---\tMILITARY VEHICLE PRODUCTION\t\nGRDTRK.INS.MMF.ENGEP \tS\t*\tG\t*\tIMN---\tENGINEERING EQUIPMENT PRODUCTION\t\nGRDTRK.INS.MMF.ENGEP.BRG \tS\t*\tG\t*\tIMNB--\tBRIDGE\t\nGRDTRK.INS.MMF.CBWP \tS\t*\tG\t*\tIMC---\tCHEMICAL & BIOLOGICAL WARFARE PRODUCTION\t\nGRDTRK.INS.MMF.SHPCSN \tS\t*\tG\t*\tIMS---\tSHIP CONSTRUCTION\t\nGRDTRK.INS.MMF.MSSP \tS\t*\tG\t*\tIMM---\tMISSILE & SPACE SYSTEM PRODUCTION\t\nGRDTRK.INS.GOVLDR \tS\t*\tG\t*\tIG----\tGOVERNMENT LEADERSHIP\t\nGRDTRK.INS.MILBF \tS\t*\tG\t*\tIB----\tMILITARY BASE/FACILITY\t\nGRDTRK.INS.MILBF.AB \tS\t*\tG\t*\tIBA---\tAIRPORT/AIRBASE\t\nGRDTRK.INS.MILBF.SP \tS\t*\tG\t*\tIBN---\tSEAPORT/NAVAL BASE\t\nGRDTRK.INS.TSPF \tS\t*\tG\t*\tIT----\tTRANSPORT FACILITY\t\nGRDTRK.INS.MEDF \tS\t*\tG\t*\tIX----\tMEDICAL FACILITY\t\nGRDTRK.INS.MEDF.HSP \tS\t*\tG\t*\tIXH---\tHOSPITAL\t\n";

  var mil_std_2525c_sea_surface = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSSUF \tS\t*\tS\t*\t------\tSEA SURFACE TRACK\t\nSSUF.CBTT \tS\t*\tS\t*\tC-----\tCOMBATANT\t\nSSUF.CBTT.LNE \tS\t*\tS\t*\tCL----\tLINE\t\nSSUF.CBTT.LNE.CRR \tS\t*\tS\t*\tCLCV--\tCARRIER\t\nSSUF.CBTT.LNE.BBS \tS\t*\tS\t*\tCLBB--\tBATTLESHIP\t\nSSUF.CBTT.LNE.CRU \tS\t*\tS\t*\tCLCC--\tCRUISER\t\nSSUF.CBTT.LNE.DD \tS\t*\tS\t*\tCLDD--\tDESTROYER\t\nSSUF.CBTT.LNE.FFR \tS\t*\tS\t*\tCLFF--\tFRIGATE/CORVETTE\t\nSSUF.CBTT.LNE.LL \tS\t*\tS\t*\tCLLL--\tLITTORAL COMBATANT\t\nSSUF.CBTT.LNE.LL.ASBW \tS\t*\tS\t*\tCLLLAS\tANTISUBMARINE WARFARE MISSION PACKAGE\t\nSSUF.CBTT.LNE.LL.MNEW \tS\t*\tS\t*\tCLLLMI\tMINE WARFARE MISSION PACKAGE\t\nSSUF.CBTT.LNE.LL.SUW \tS\t*\tS\t*\tCLLLSU\tSURFACE WARFARE (SUW) MISSION PACKAGE\t\nSSUF.CBTT.AMPWS \tS\t*\tS\t*\tCA----\tAMPHIBIOUS WARFARE SHIP\t\nSSUF.CBTT.AMPWS.ASTVES \tS\t*\tS\t*\tCALA--\tASSAULT VESSEL\t\nSSUF.CBTT.AMPWS.LNDSHP \tS\t*\tS\t*\tCALS--\tLANDING SHIP\t\nSSUF.CBTT.AMPWS.LNDSHP.MDM \tS\t*\tS\t*\tCALSM-\tLANDING SHIP MEDIUM\t\nSSUF.CBTT.AMPWS.LNDSHP.TANK \tS\t*\tS\t*\tCALST-\tLANDING SHIP TANK\t\nSSUF.CBTT.AMPWS.LNDCRT \tS\t*\tS\t*\tCALC--\tLANDING CRAFT\t\nSSUF.CBTT.MNEWV \tS\t*\tS\t*\tCM----\tMINE WARFARE VESSEL\t\nSSUF.CBTT.MNEWV.MNELYR \tS\t*\tS\t*\tCMML--\tMINELAYER\t\nSSUF.CBTT.MNEWV.MNESWE \tS\t*\tS\t*\tCMMS--\tMINESWEEPER\t\nSSUF.CBTT.MNEWV.MNEHNT \tS\t*\tS\t*\tCMMH--\tMINEHUNTER\t\nSSUF.CBTT.MNEWV.MCMSUP \tS\t*\tS\t*\tCMMA--\tMCM SUPPORT\t\nSSUF.CBTT.PAT \tS\t*\tS\t*\tCP----\tPATROL\t\nSSUF.CBTT.PAT.ASBW \tS\t*\tS\t*\tCPSB--\tANTISUBMARINE WARFARE\t\nSSUF.CBTT.PAT.ASUW \tS\t*\tS\t*\tCPSU--\tANTISURFACE WARFARE\t\nSSUF.CBTT.PAT.ASUW.ASMSL \tS\t*\tS\t*\tCPSUM-\tANTISHIP MISSILE PATROL CRAFT\t\nSSUF.CBTT.PAT.ASUW.TPD \tS\t*\tS\t*\tCPSUT-\tTORPEDO PATROL CRAFT\t\nSSUF.CBTT.PAT.ASUW.GUN \tS\t*\tS\t*\tCPSUG-\tGUN PATROL CRAFT\t\nSSUF.CBTT.HOV \tS\t*\tS\t*\tCH----\tHOVERCRAFT\t\nSSUF.CBTT.NAVGRP \tS\t*\tS\t*\tG-----\tNAVY GROUP\t\nSSUF.CBTT.NAVGRP.NAVTF \tS\t*\tS\t*\tGT----\tNAVY TASK FORCE\t\nSSUF.CBTT.NAVGRP.NAVTG \tS\t*\tS\t*\tGG----\tNAVY TASK GROUP\t\nSSUF.CBTT.NAVGRP.NAVTU \tS\t*\tS\t*\tGU----\tNAVY TASK UNIT\t\nSSUF.CBTT.NAVGRP.CNY \tS\t*\tS\t*\tGC----\tCONVOY\t\nSSUF.CBTT.SUFDCY \tS\t*\tS\t*\tCD----\tSURFACE DECOY\t\nSSUF.CBTT.USV \tS\t*\tS\t*\tCU----\tUNMANNED SURFACE VEHICLE\t\nSSUF.CBTT.USV.MNECM \tS\t*\tS\t*\tCUM---\tMINE COUNTERMEASURES SURFACE DRONE\t\nSSUF.CBTT.USV.ASBW \tS\t*\tS\t*\tCUS---\tANTISUBMARINE WARFARE SURFACE DRONE\t\nSSUF.CBTT.USV.ASUW \tS\t*\tS\t*\tCUN---\tANTISURFACE WARFARE SURFACE DRONE\t\nSSUF.CBTT.USV.RMV \tS\t*\tS\t*\tCUR---\tREMOTE MULTIMISSION VEHICLE\t\nSSUF.NCBTT \tS\t*\tS\t*\tN-----\tNONCOMBATANT\t\nSSUF.NCBTT.UWRPM \tS\t*\tS\t*\tNR----\tUNDERWAY REPLENISHMENT\t\nSSUF.NCBTT.FLTSUP \tS\t*\tS\t*\tNF----\tFLEET SUPPORT\t\nSSUF.NCBTT.INT \tS\t*\tS\t*\tNI----\tINTELLIGENCE\t\nSSUF.NCBTT.SSH \tS\t*\tS\t*\tNS----\tSERVICE & SUPPORT HARBOR\t\nSSUF.NCBTT.HSPSHP \tS\t*\tS\t*\tNM----\tHOSPITAL SHIP\t\nSSUF.NCBTT.HOV \tS\t*\tS\t*\tNH----\tHOVERCRAFT\t\nSSUF.NMIL \tS\t*\tS\t*\tX-----\tNON-MILITARY\tN/A\nSSUF.NMIL.MCT \tS\t*\tS\t*\tXM----\tMERCHANT\t\nSSUF.NMIL.MCT.CGO \tS\t*\tS\t*\tXMC---\tCARGO\t\nSSUF.NMIL.MCT.RORO \tS\t*\tS\t*\tXMR---\tROLL ON/ROLL OFF\t\nSSUF.NMIL.MCT.OLR \tS\t*\tS\t*\tXMO---\tOILER/TANKER\t\nSSUF.NMIL.MCT.TUG \tS\t*\tS\t*\tXMTU--\tTUG\t\nSSUF.NMIL.MCT.FRY \tS\t*\tS\t*\tXMF---\tFERRY\t\nSSUF.NMIL.MCT.PSG \tS\t*\tS\t*\tXMP---\tPASSENGER\t\nSSUF.NMIL.MCT.HAZMAT \tS\t*\tS\t*\tXMH---\tHAZARDOUS MATERIALS (HAZMAT)\t\nSSUF.NMIL.MCT.TOWVES \tS\t*\tS\t*\tXMTO--\tTOWING VESSEL\t\nSSUF.NMIL.FSG \tS\t*\tS\t*\tXF----\tFISHING\t\nSSUF.NMIL.FSG.DRFT \tS\t*\tS\t*\tXFDF--\tDRIFTER\t\nSSUF.NMIL.FSG.DRG \tS\t*\tS\t*\tXFDR--\tDREDGE\t\nSSUF.NMIL.FSG.TRW \tS\t*\tS\t*\tXFTR--\tTRAWLER\t\nSSUF.NMIL.LESCRT \tS\t*\tS\t*\tXR----\tLEISURE CRAFT\t\nSSUF.NMIL.LAWENV \tS\t*\tS\t*\tXL----\tLAW ENFORCEMENT VESSEL\t\nSSUF.NMIL.HOV \tS\t*\tS\t*\tXH----\tHOVERCRAFT\t\nSSUF.NMIL.FSTREC \tS\t*\tS\t*\tXA----\tFAST RECREACTIONAL CRAFT\t\nSSUF.NMIL.FSTREC.RHIB \tS\t*\tS\t*\tXAR---\tRIGID-HULL INFLATABLE BOAT\t\nSSUF.NMIL.FSTREC.SPDBT \tS\t*\tS\t*\tXAS---\tSPEED BOAT\t\nSSUF.NMIL.PWC \tS\t*\tS\t*\tXP----\tPERSONAL WATERCRAFT\t\nSSUF.OWN \tS\t*\tS\t*\tO-----\tOWN TRACK\t\n";

  var mil_std_2525c_sub_surface = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSBSUF \tS\t*\tU\t*\t------\tSUBSURFACE TRACK\t\nSBSUF.SUB \tS\t*\tU\t*\tS-----\tSUBMARINE\t\nSBSUF.SUB.SURF \tS\t*\tU\t*\tSF----\tSURFACED SUBMARINE\t\nSBSUF.SUB.BOTTMD \tS\t*\tU\t*\tSB----\tBOTTOMED\t\nSBSUF.SUB.CRT \tS\t*\tU\t*\tSR----\tCERTAIN SUBMARINE\t\nSBSUF.SUB.NONSUB \tS\t*\tU\t*\tSX----\tNONSUBMARINE\t\nSBSUF.SUB.NPRN \tS\t*\tU\t*\tSN----\tNUCLEAR PROPULSION\t\nSBSUF.SUB.NPRN.SURF \tS\t*\tU\t*\tSNF---\tSURFACED NUCLEAR PROPULSION SUBMARINE\t\nSBSUF.SUB.NPRN.ATK \tS\t*\tU\t*\tSNA---\tATTACK SUBMARINE (SSN)\t\nSBSUF.SUB.NPRN.MSL \tS\t*\tU\t*\tSNM---\tMISSILE SUBMARINE (TYPE UNKNOWN)\t\nSBSUF.SUB.NPRN.GDD \tS\t*\tU\t*\tSNG---\tGUIDED MISSILE SUBMARINE (SSGN)\t\nSBSUF.SUB.NPRN.BLST \tS\t*\tU\t*\tSNB---\tBALLISTIC MISSILE SUBMARINE (SSBN)\t\nSBSUF.SUB.CNVPRN \tS\t*\tU\t*\tSC----\tCONVENTIONAL PROPULSION\t\nSBSUF.SUB.CNVPRN.SURF \tS\t*\tU\t*\tSCF---\tSURFACED CONVENTIONAL PROPULSION SUBMARINE\t\nSBSUF.SUB.CNVPRN.ATK \tS\t*\tU\t*\tSCA---\tATTACK SUBMARINE (SS)\t\nSBSUF.SUB.CNVPRN.MSL \tS\t*\tU\t*\tSCM---\tMISSILE SUBMARINE (TYPE UNKNOWN)\t\nSBSUF.SUB.CNVPRN.GDD \tS\t*\tU\t*\tSCG---\tGUIDED MISSILE SUBMARINE (SSG)\t\nSBSUF.SUB.CNVPRN.BLST \tS\t*\tU\t*\tSCB---\tBALLISTIC MISSILE SUBMARINE (SSB)\t\nSBSUF.SUB.OTH \tS\t*\tU\t*\tSO----\tOTHER SUBMERSIBLE\t\nSBSUF.SUB.OTH.SURF \tS\t*\tU\t*\tSOF---\tSURFACED OTHER SUBMERSIBLE\t\nSBSUF.SUB.UUV \tS\t*\tU\t*\tSU----\tUNMANNED UNDERWATER VEHICLE (UUV)\t\nSBSUF.SUB.UUV.MNEW \tS\t*\tU\t*\tSUM---\tMINE WARFARE SUBSURFACE DRONE\t\nSBSUF.SUB.UUV.ASBW \tS\t*\tU\t*\tSUS---\tANTISUBMARINE WARFARE SUBSURFACE DRONE\t\nSBSUF.SUB.UUV.ASUW \tS\t*\tU\t*\tSUN---\tANTISURFACE WARFARE SUBSURFACE DRONE\t\nSBSUF.SUB.POSS1 \tS\t*\tU\t*\tS1----\tPOSSIBLE SUBMARINE 1\t\nSBSUF.SUB.POSS2 \tS\t*\tU\t*\tS2----\tPOSSIBLE SUBMARINE 2\t\nSBSUF.SUB.POSS3 \tS\t*\tU\t*\tS3----\tPOSSIBLE SUBMARINE 3\t\nSBSUF.SUB.POSS4 \tS\t*\tU\t*\tS4----\tPOSSIBLE SUBMARINE 4\t\nSBSUF.SUB.PRBSUB \tS\t*\tU\t*\tSL----\tPROBABLE SUBMARINE\t\nSBSUF.SUB.SNORKL \tS\t*\tU\t*\tSK----\tSNORKELING SUBMARINE\t\nSBSUF.UH2WPN \tS\t*\tU\t*\tW-----\tUNDERWATER WEAPON\t\nSBSUF.UH2WPN.TPD \tS\t*\tU\t*\tWT----\tTORPEDO\t\nSBSUF.UH2WPN.SMNE \tS\t*\tU\t*\tWM----\tSEA MINE\t\nSBSUF.UH2WPN.SMNE.NTRLZD \tS\t*\tU\t*\tWMD---\tSEA MINE NEUTRALIZED\t\nSBSUF.UH2WPN.SMNE.SMG \tS\t*\tU\t*\tWMG---\tSEA MINE (GROUND)\t\nSBSUF.UH2WPN.SMNE.SMG.NTRLZD \tS\t*\tU\t*\tWMGD--\tSEA MINE (GROUND) NEUTRALIZED\t\nSBSUF.UH2WPN.SMNE.SMG.EXER \tS\t*\tU\t*\tWMGX--\tGROUND (BOTTOM) EXERCISE MINE\t\nSBSUF.UH2WPN.SMNE.SMG.MILEC \tS\t*\tU\t*\tWMGE--\tGROUND (BOTTOM) MINE-LIKE ECHO (MILEC)\t\nSBSUF.UH2WPN.SMNE.SMG.MILCO \tS\t*\tU\t*\tWMGC--\tGROUND (BOTTOM) MINE-LIKE CONTACT (MILCO)\t\nSBSUF.UH2WPN.SMNE.SMG.NGREAC \tS\t*\tU\t*\tWMGR--\tGROUND (BOTTOM) NEGATIVE REACQUISITION\t\nSBSUF.UH2WPN.SMNE.SMG.NMMLCO \tS\t*\tU\t*\tWMGO--\tGROUND (BOTTOM) NON-MINE MINE-LIKE CONTACT\t\nSBSUF.UH2WPN.SMNE.SMM \tS\t*\tU\t*\tWMM---\tSEA MINE (MOORED)\t\nSBSUF.UH2WPN.SMNE.SMM.NTRLZD \tS\t*\tU\t*\tWMMD--\tSEA MINE (MOORED) NEUTRALIZED\t\nSBSUF.UH2WPN.SMNE.SMM.EXER \tS\t*\tU\t*\tWMMX--\tMOORED EXERCISE MINE\t\nSBSUF.UH2WPN.SMNE.SMM.MILEC \tS\t*\tU\t*\tWMME--\tMOORED MINE-LIKE ECHO\t\nSBSUF.UH2WPN.SMNE.SMM.MILCO \tS\t*\tU\t*\tWMMC--\tMOORED MINE-LIKE CONTACT\t\nSBSUF.UH2WPN.SMNE.SMM.NGREAC \tS\t*\tU\t*\tWMMR--\tMOORED NEGATIVE REACQUISITION\t\nSBSUF.UH2WPN.SMNE.SMM.NMMLCO \tS\t*\tU\t*\tWMMO--\tMOORED NON-MINE MINE-LIKE OBJECT\t\nSBSUF.UH2WPN.SMNE.SMF \tS\t*\tU\t*\tWMF---\tSEA MINE (FLOATING)\t\nSBSUF.UH2WPN.SMNE.SMF.NTRLZD \tS\t*\tU\t*\tWMFD--\tSEA MINE (FLOATING) NEUTRALIZED\t\nSBSUF.UH2WPN.SMNE.SMF.EXER \tS\t*\tU\t*\tWMFX--\tFLOATING EXERCISE MINE\t\nSBSUF.UH2WPN.SMNE.SMF.MILEC \tS\t*\tU\t*\tWMFE--\tFLOATING MINE-LIKE ECHO (MILEC)\t\nSBSUF.UH2WPN.SMNE.SMF.MILCO \tS\t*\tU\t*\tWMFC--\tFLOATING MINE-LIKE CONTACT (MILCO)\t\nSBSUF.UH2WPN.SMNE.SMF.NGREAC \tS\t*\tU\t*\tWMFR--\tFLOATING NEGATIVE REACQUISITION\t\nSBSUF.UH2WPN.SMNE.SMF.NMMLCO \tS\t*\tU\t*\tWMFO--\tFLOATING NON-MINE MINE-LIKE CONTACT\t\nSBSUF.UH2WPN.SMNE.SMOP \tS\t*\tU\t*\tWMO---\tSEA MINE (OTHER POSITION)\t\nSBSUF.UH2WPN.SMNE.SMOP.NTRLZD \tS\t*\tU\t*\tWMOD--\tSEA MINE (OTHER POSITION) NEUTRALIZED\t\nSBSUF.UH2WPN.SMNE.EXER \tS\t*\tU\t*\tWMX---\tGENERAL EXERCISE MINE\t\nSBSUF.UH2WPN.SMNE.MILEC \tS\t*\tU\t*\tWME---\tGENERAL MINE-LIKE ECHO (MILEC)\t\nSBSUF.UH2WPN.SMNE.ANCHOR \tS\t*\tU\t*\tWMA---\tGENERAL MINE ANCHOR\t\nSBSUF.UH2WPN.SMNE.MILCO \tS\t*\tU\t*\tWMC---\tGENERAL MINE-LIKE CONTACT (MILCO)\t\nSBSUF.UH2WPN.SMNE.NGREAC \tS\t*\tU\t*\tWMR---\tGENERAL NEGATIVE REACQUISITION\t\nSBSUF.UH2WPN.SMNE.OBSTRC \tS\t*\tU\t*\tWMB---\tGENERAL OBSTRUCTOR\t\nSBSUF.UH2WPN.SMNE.OBSTRC.NTRLZD \tS\t*\tU\t*\tWMBD--\tGENERAL NEUTRALIZED OBSTRUCTOR\t\nSBSUF.UH2WPN.SMNE.NMMLCO \tS\t*\tU\t*\tWMN---\tGENERAL NON-MINE MINE-LIKE OBJECT\t\nSBSUF.UH2WPN.SMNE.RISING \tS\t*\tU\t*\tWMS---\tRISING MINE\t\nSBSUF.UH2WPN.SMNE.RISING.EXER \tS\t*\tU\t*\tWMSX--\tRISING EXERCISE MINE\t\nSBSUF.UH2WPN.SMNE.RISING.NTRLZD \tS\t*\tU\t*\tWMSD--\tRISING NEUTRALIZED MINE\t\nSBSUF.UH2DCY \tS\t*\tU\t*\tWD----\tUNDERWATER DECOY\t\nSBSUF.UH2DCY.SMDCY \tS\t*\tU\t*\tWDM---\tSEA MINE DECOY\t\nSBSUF.UH2DCY.SMDCY.GRND \tS\t*\tU\t*\tWDMG--\tGROUND (BOTTOM) DECOY\t\nSBSUF.UH2DCY.SMDCY.MOORED \tS\t*\tU\t*\tWDMM--\tMOORED DECOY\t\nSBSUF.NSUB \tS\t*\tU\t*\tN-----\tNON-SUBMARINE\tN/A\nSBSUF.NSUB.DVR \tS\t*\tU\t*\tND----\tDIVER\t\nSBSUF.ERL \tS\t*\tU\t*\tE-----\tENVIRONMENTAL REPORT LOCATION\t\nSBSUF.DRL \tS\t*\tU\t*\tV-----\tDIVE REPORT LOCATION\t\nSBSUF.UXO \tS\t*\tU\t*\tX-----\tUNEXPLODED ORDNANCE AREA\t\n";

  var mil_std_2525c_sof = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSOFUNT \tS\t*\tF\t*\t------\tSPECIAL OPERATIONS FORCES (SOF) UNIT\t\nSOFUNT.AVN \tS\t*\tF\t*\tA-----\tSOF UNIT AVIATION\t\nSOFUNT.AVN.FIXD \tS\t*\tF\t*\tAF----\tSOF UNIT FIXED WING\t\nSOFUNT.AVN.FIXD.ATK \tS\t*\tF\t*\tAFA---\tSOF UNIT ATTACK\t\nSOFUNT.AVN.FIXD.RFE \tS\t*\tF\t*\tAFK---\tSOF UNIT REFUEL\t\nSOFUNT.AVN.FIXD.UTY \tS\t*\tF\t*\tAFU---\tSOF UNIT UTILITY\t\nSOFUNT.AVN.FIXD.UTY.LIT \tS\t*\tF\t*\tAFUL--\tSOF UNIT UTILITY (LIGHT)\t\nSOFUNT.AVN.FIXD.UTY.MDM \tS\t*\tF\t*\tAFUM--\tSOF UNIT UTILITY (MEDIUM)\t\nSOFUNT.AVN.FIXD.UTY.HVY \tS\t*\tF\t*\tAFUH--\tSOF UNIT UTILITY (HEAVY)\t\nSOFUNT.AVN.VSTOL \tS\t*\tF\t*\tAV----\tSOF UNIT V/STOL\t\nSOFUNT.AVN.ROT \tS\t*\tF\t*\tAH----\tSOF UNIT ROTARY WING\t\nSOFUNT.AVN.ROT.CSAR \tS\t*\tF\t*\tAHH---\tSOF UNIT COMBAT SEARCH AND RESCUE\t\nSOFUNT.AVN.ROT.ATK \tS\t*\tF\t*\tAHA---\tSOF UNIT ATTACK\t\nSOFUNT.AVN.ROT.UTY \tS\t*\tF\t*\tAHU---\tSOF UNIT UTILITY\t\nSOFUNT.AVN.ROT.UTY.LIT \tS\t*\tF\t*\tAHUL--\tSOF UNIT UTILITY (LIGHT)\t\nSOFUNT.AVN.ROT.UTY.MDM \tS\t*\tF\t*\tAHUM--\tSOF UNIT UTILITY (MEDIUM)\t\nSOFUNT.AVN.ROT.UTY.HVY \tS\t*\tF\t*\tAHUH--\tSOF UNIT UTILITY (HEAVY)\t\nSOFUNT.NAV \tS\t*\tF\t*\tN-----\tSOF UNIT SOF UNIT NAVAL\t\nSOFUNT.NAV.SEAL \tS\t*\tF\t*\tNS----\tSOF UNIT SEAL\t\nSOFUNT.NAV.UH2DML \tS\t*\tF\t*\tNU----\tSOF UNIT UNDERWATER DEMOLITION TEAM\t\nSOFUNT.NAV.SBT \tS\t*\tF\t*\tNB----\tSOF UNIT SPECIAL BOAT\t\nSOFUNT.NAV.SSSNR \tS\t*\tF\t*\tNN----\tSOF UNIT SPECIAL SSNR\t\nSOFUNT.GRD \tS\t*\tF\t*\tG-----\tSOF UNIT GROUND\t\nSOFUNT.GRD.SOF \tS\t*\tF\t*\tGS----\tSOF UNIT SPECIAL FORCES\t\nSOFUNT.GRD.RGR \tS\t*\tF\t*\tGR----\tSOF UNIT RANGER\t\nSOFUNT.GRD.PSYOP \tS\t*\tF\t*\tGP----\tSOF UNIT PSYCHOLOGICAL OPERATIONS (PSYOP)\t\nSOFUNT.GRD.PSYOP.FIXAVN \tS\t*\tF\t*\tGPA---\tSOF UNIT FIXED WING AVIATION\t\nSOFUNT.GRD.CVLAFF \tS\t*\tF\t*\tGC----\tSOF UNIT CIVIL AFFAIRS\t\nSOFUNT.SUP \tS\t*\tF\t*\tB-----\tSOF UNIT SUPPORT\t";

  var mil_std_2525c_tactical_graphics = "geometry\thierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\n\tTACGRP.TSK\tG\t*\tT\t*\t------\tTASKS\tN/A\nMULTIPOINT\tTACGRP.TSK.BLK\tG\t*\tT\t*\tB-----\tBLOCK\t\nMULTIPOINT\tTACGRP.TSK.BRH\tG\t*\tT\t*\tH-----\tBREACH\t\nMULTIPOINT\tTACGRP.TSK.BYS\tG\t*\tT\t*\tY-----\tBYPASS\t\nMULTIPOINT\tTACGRP.TSK.CNZ\tG\t*\tT\t*\tC-----\tCANALIZE\t\nMULTIPOINT\tTACGRP.TSK.CLR\tG\t*\tT\t*\tX-----\tCLEAR\t\nMULTIPOINT\tTACGRP.TSK.CNT\tG\t*\tT\t*\tJ-----\tCONTAIN\t\nMULTIPOINT\tTACGRP.TSK.CATK\tG\t*\tT\t*\tK-----\tCOUNTERATTACK (CATK)\t\nMULTIPOINT\tTACGRP.TSK.CATK.CATKF\tG\t*\tT\t*\tKF----\tCOUNTERATTACK BY FIRE\t\nMULTIPOINT\tTACGRP.TSK.DLY\tG\t*\tT\t*\tL-----\tDELAY\t\nPOINT\tTACGRP.TSK.DSTY\tG\t*\tT\t*\tD-----\tDESTROY\t\nMULTIPOINT\tTACGRP.TSK.DRT\tG\t*\tT\t*\tT-----\tDISRUPT\t\nMULTIPOINT\tTACGRP.TSK.FIX\tG\t*\tT\t*\tF-----\tFIX\t\nMULTIPOINT\tTACGRP.TSK.FLWASS\tG\t*\tT\t*\tA-----\tFOLLOW AND ASSUME\t\nMULTIPOINT\tTACGRP.TSK.FLWASS.FLWSUP\tG\t*\tT\t*\tAS----\tFOLLOW AND SUPPORT\t\nPOINT\tTACGRP.TSK.ITDT\tG\t*\tT\t*\tI-----\tINTERDICT\t\nMULTIPOINT\tTACGRP.TSK.ISL\tG\t*\tT\t*\tE-----\tISOLATE\t\nPOINT\tTACGRP.TSK.NEUT\tG\t*\tT\t*\tN-----\tNEUTRALIZE\t\nMULTIPOINT\tTACGRP.TSK.OCC\tG\t*\tT\t*\tO-----\tOCCUPY\t\nMULTIPOINT\tTACGRP.TSK.PNE\tG\t*\tT\t*\tP-----\tPENETRATE\t\nMULTIPOINT\tTACGRP.TSK.RIP\tG\t*\tT\t*\tR-----\tRELIEF IN PLACE (RIP)\t\nMULTIPOINT\tTACGRP.TSK.RTN\tG\t*\tT\t*\tQ-----\tRETAIN\t\nMULTIPOINT\tTACGRP.TSK.RTM\tG\t*\tT\t*\tM-----\tRETIREMENT\t\nMULTIPOINT\tTACGRP.TSK.SCE\tG\t*\tT\t*\tS-----\tSECURE\t\nMULTIPOINT\tTACGRP.TSK.SEC\tG\t-\tT\t*\tU-----\tSECURITY\t\nMULTIPOINT\tTACGRP.TSK.SEC.SCN\tG\t*\tT\t*\tUS----\tSCREEN\t\nMULTIPOINT\tTACGRP.TSK.SEC.GUD\tG\t*\tT\t*\tUG----\tGUARD\t\nMULTIPOINT\tTACGRP.TSK.SEC.COV\tG\t*\tT\t*\tUC----\tCOVER\t\nMULTIPOINT\tTACGRP.TSK.SZE\tG\t*\tT\t*\tZ-----\tSEIZE\t\nMULTIPOINT\tTACGRP.TSK.WDR\tG\t*\tT\t*\tW-----\tWITHDRAW\tN/A\nMULTIPOINT\tTACGRP.TSK.WDR.WDRUP\tG\t*\tT\t*\tWP----\tWITHDRAW UNDER PRESSURE\tN/A\n\tTACGRP.C2GM\tG\t*\tG\t*\t------\tCOMMAND AND CONTROL AND GENERAL MANEUVER\tN/A\n\tTACGRP.C2GM.GNL\tG\t*\tG\t*\tG-----\tGENERAL\tN/A\n\tTACGRP.C2GM.GNL.PNT\tG\t*\tG\t*\tGP----\tPOINTS\tN/A\n\tTACGRP.C2GM.GNL.PNT.USW\tG\t*\tG\t*\tGPU---\tUNDER SEA WARFARE\tN/A\n\tTACGRP.C2GM.GNL.PNT.USW.UH2\tG\t*\tG\t*\tGPUU--\tUNDERWATER\tN/A\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.DTM\tG\t*\tG\t*\tGPUUD-\tDATUM\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.BCON\tG\t*\tG\t*\tGPUUB-\tBRIEF CONTACT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.LCON\tG\t*\tG\t*\tGPUUL-\tLOST CONTACT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.UH2.SNK\tG\t*\tG\t*\tGPUUS-\tSINKER\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY\tG\t*\tG\t*\tGPUY--\tSONOBUOY\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.PTNCTR\tG\t*\tG\t*\tGPUYP-\tPATTERN CENTER\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.DIFAR\tG\t*\tG\t*\tGPUYD-\tDIRECTIONAL FREQUENCY ANALYZING AND RECORDING (DIFAR)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.LOFAR\tG\t*\tG\t*\tGPUYL-\tLOW FREQUENCY ANALYZING AND RECORDING (LOFAR)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.CASS\tG\t*\tG\t*\tGPUYC-\tCOMMAND ACTIVE SONOBUOY SYSTEM (CASS)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.DICASS\tG\t*\tG\t*\tGPUYS-\tDIRECTIONAL COMMAND ACTIVE SONOBUOY SYSTEM (DICASS)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.BT\tG\t*\tG\t*\tGPUYB-\tBATHYTHERMOGRAPH TRANSMITTING (BT)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.ANM\tG\t*\tG\t*\tGPUYA-\tANM\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.VLAD\tG\t*\tG\t*\tGPUYV-\tVERTICAL LINE ARRAY DIFAR (VLAD)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.ATAC\tG\t*\tG\t*\tGPUYT-\tATAC\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.RO\tG\t*\tG\t*\tGPUYR-\tRANGE ONLY (RO)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.KGP\tG\t*\tG\t*\tGPUYK-\tKINGPIN\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SNBY.EXP\tG\t*\tG\t*\tGPUYX-\tSONOBUOY-EXPIRED\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH\tG\t*\tG\t*\tGPUS--\tSEARCH\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.ARA\tG\t*\tG\t*\tGPUSA-\tSEARCH AREA\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.DIPPSN\tG\t*\tG\t*\tGPUSD-\tDIP POSITION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.USW.SRH.CTR\tG\t*\tG\t*\tGPUSC-\tSEARCH CENTER\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT\tG\t*\tG\t*\tGPR---\tREFERENCE POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.NAVREF\tG\t*\tG\t*\tGPRN--\tNAVIGATIONAL REFERENCE POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.SPLPNT\tG\t*\tG\t*\tGPRS--\tSPECIAL POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.DLRP\tG\t*\tG\t*\tGPRD--\tDLRP\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.PIM\tG\t*\tG\t*\tGPRP--\tPOINT OF INTENDED MOVEMENT (PIM)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.MRSH\tG\t*\tG\t*\tGPRM--\tMARSHALL POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.WAP\tG\t*\tG\t*\tGPRW--\tWAYPOINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.CRDRTB\tG\t*\tG\t*\tGPRC--\tCORRIDOR TAB\t\nPOINT\tTACGRP.C2GM.GNL.PNT.REFPNT.PNTINR\tG\t*\tG\t*\tGPRI--\tPOINT OF INTEREST\t\n\tTACGRP.C2GM.GNL.PNT.WPN\tG\t*\tG\t*\tGPW---\tWEAPON\tN/A\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.AIMPNT\tG\t*\tG\t*\tGPWA--\tAIM POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.DRPPNT\tG\t*\tG\t*\tGPWD--\tDROP POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.ENTPNT\tG\t*\tG\t*\tGPWE--\tENTRY POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.GRDZRO\tG\t*\tG\t*\tGPWG--\tGROUND ZERO\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.MSLPNT\tG\t*\tG\t*\tGPWM--\tMSL DETECT POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.IMTPNT\tG\t*\tG\t*\tGPWI--\tIMPACT POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.WPN.PIPNT\tG\t*\tG\t*\tGPWP--\tPREDICTED IMPACT POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.FRMN\tG\t*\tG\t*\tGPF---\tFORMATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR\tG\t*\tG\t*\tGPH---\tHARBOR (GENERAL)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTQ\tG\t*\tG\t*\tGPHQ--\tPOINT Q\t\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTA\tG\t*\tG\t*\tGPHA--\tPOINT A\t\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTY\tG\t*\tG\t*\tGPHY--\tPOINT Y\t\nPOINT\tTACGRP.C2GM.GNL.PNT.HBR.PNTX\tG\t*\tG\t*\tGPHX--\tPOINT X\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE\tG\t*\tG\t*\tGPO---\tROUTE\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.RDV\tG\t*\tG\t*\tGPOZ--\tRENDEZVOUS\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.DVSN\tG\t*\tG\t*\tGPOD--\tDIVERSIONS\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.WAP\tG\t*\tG\t*\tGPOW--\tWAYPOINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.PIM\tG\t*\tG\t*\tGPOP--\tPIM\t\nPOINT\tTACGRP.C2GM.GNL.PNT.RTE.PNTR\tG\t*\tG\t*\tGPOR--\tPOINT R\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL\tG\t*\tG\t*\tGPA---\tAIR CONTROL\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.CAP\tG\t*\tG\t*\tGPAP--\tCOMBAT AIR PATROL (CAP)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ABNEW\tG\t*\tG\t*\tGPAW--\tAIRBORNE EARLY WARNING (AEW)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TAK\tG\t*\tG\t*\tGPAK--\tTANKING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ASBWF\tG\t*\tG\t*\tGPAA--\tANTISUBMARINE WARFARE, FIXED WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ASBWR\tG\t*\tG\t*\tGPAH--\tANTISUBMARINE WARFARE, ROTARY WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.SUWF\tG\t*\tG\t*\tGPAB--\tSUCAP - FIXED WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.SUWR\tG\t*\tG\t*\tGPAC--\tSUCAP - ROTARY WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.MIWF\tG\t*\tG\t*\tGPAD--\tMIW - FIXED WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.MIWR\tG\t*\tG\t*\tGPAE--\tMIW - ROTARY WING\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.SKEIP\tG\t*\tG\t*\tGPAS--\tSTRIKE IP\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TCN\tG\t*\tG\t*\tGPAT--\tTACAN\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.TMC\tG\t*\tG\t*\tGPAO--\tTOMCAT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.RSC\tG\t*\tG\t*\tGPAR--\tRESCUE\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.RPH\tG\t*\tG\t*\tGPAL--\tREPLENISH\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.UA\tG\t*\tG\t*\tGPAF--\tUNMANNED AERIAL SYSTEM (UAS/UA)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.VTUA\tG\t*\tG\t*\tGPAG--\tVTUA\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ORB\tG\t*\tG\t*\tGPAI--\tORBIT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ORBF8\tG\t*\tG\t*\tGPAJ--\tORBIT - FIGURE EIGHT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ORBRT\tG\t*\tG\t*\tGPAM--\tORBIT - RACE TRACK\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTL.ORBRD\tG\t*\tG\t*\tGPAN--\tORBIT - RANDOM, CLOSED\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT\tG\t*\tG\t*\tGPP---\tACTION POINTS (GENERAL)\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CHKPNT\tG\t*\tG\t*\tGPPK--\tCHECK POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CONPNT\tG\t*\tG\t*\tGPPC--\tCONTACT POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.CRDPNT\tG\t*\tG\t*\tGPPO--\tCOORDINATION POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.DCNPNT\tG\t*\tG\t*\tGPPD--\tDECISION POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.LNKUPT\tG\t*\tG\t*\tGPPL--\tLINKUP POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.PSSPNT\tG\t*\tG\t*\tGPPP--\tPASSAGE POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.RAYPNT\tG\t*\tG\t*\tGPPR--\tRALLY POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.RELPNT\tG\t*\tG\t*\tGPPE--\tRELEASE POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.STRPNT\tG\t*\tG\t*\tGPPS--\tSTART POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.AMNPNT\tG\t*\tG\t*\tGPPA--\tAMNESTY POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.ACTPNT.WAP\tG\t*\tG\t*\tGPPW--\tWAYPOINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL\tG\t*\tG\t*\tGPC---\tSEA SURFACE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.USV\tG\t*\tG\t*\tGPCU--\tUNMANNED SURFACE VEHICLE (USV) CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.USV.RMV\tG\t*\tG\t*\tGPCUR-\tREMOTE MULTIMISSION VEHICLE (RMV) USV CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.USV.ASW\tG\t*\tG\t*\tGPCUA-\tUSV - ANTISUBMARINE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.USV.SUW\tG\t*\tG\t*\tGPCUS-\tUSV - SURFACE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.USV.MIW\tG\t*\tG\t*\tGPCUM-\tUSV - MINE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.ASW\tG\t*\tG\t*\tGPCA--\tASW CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.SUW\tG\t*\tG\t*\tGPCS--\tSUW CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.MIW\tG\t*\tG\t*\tGPCM--\tMIW CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.PKT\tG\t*\tG\t*\tGPCP--\tPICKET CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.RDV\tG\t*\tG\t*\tGPCR--\tRENDEZVOUS CONTROL POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.RSC\tG\t*\tG\t*\tGPCC--\tRESCUE CONTROL POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.REP\tG\t*\tG\t*\tGPCE--\tREPLENISHMENT CONTROL POINT\t\nPOINT\tTACGRP.C2GM.GNL.PNT.SCTL.NCBTT\tG\t*\tG\t*\tGPCN--\tNONCOMBATANT CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL\tG\t*\tG\t*\tGPB---\tSUBSURFACE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.UUV\tG\t*\tG\t*\tGPBU--\tUNMANNED UNDERWATER VEHICLE (UUV) CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.UUV.ASW\tG\t*\tG\t*\tGPBUA-\tUUV - ANTISUBMARINE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.UUV.SUW\tG\t*\tG\t*\tGPBUS-\tUUV - SURFACE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.UUV.MIW\tG\t*\tG\t*\tGPBUM-\tUUV - MINE WARFARE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.SBSTN\tG\t*\tG\t*\tGPBS--\tSUBMARINE CONTROL STATION\t\nPOINT\tTACGRP.C2GM.GNL.PNT.UCTL.SBSTN.ASW\tG\t*\tG\t*\tGPBSA-\tASW SUBMARINE CONTROL STATION\t\n\tTACGRP.C2GM.GNL.LNE\tG\t*\tG\t*\tGL----\tLINES\tN/A\nLINE\tTACGRP.C2GM.GNL.LNE.BNDS\tG\t*\tG\t*\tGLB---\tBOUNDARIES\t\nLINE\tTACGRP.C2GM.GNL.LNE.FLOT\tG\t*\tG\t*\tGLF---\tFORWARD LINE OF OWN TROOPS (FLOT)\t\nLINE\tTACGRP.C2GM.GNL.LNE.LOC\tG\t*\tG\t*\tGLC---\tLINE OF CONTACT\t\nLINE\tTACGRP.C2GM.GNL.LNE.PHELNE\tG\t*\tG\t*\tGLP---\tPHASE LINE\t\nLINE\tTACGRP.C2GM.GNL.LNE.LITLNE\tG\t*\tG\t*\tGLL---\tLIGHT LINE\t\n\tTACGRP.C2GM.GNL.ARS\tG\t*\tG\t*\tGA----\tAREAS\tN/A\nPOLYGON\tTACGRP.C2GM.GNL.ARS.GENARA\tG\t*\tG\t*\tGAG---\tGENERAL AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.ABYARA\tG\t*\tG\t*\tGAA---\tASSEMBLY AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.EMTARA\tG\t*\tG\t*\tGAE---\tENGAGEMENT AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.FTFDAR\tG\t*\tG\t*\tGAF---\tFORTIFIED AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.DRPZ\tG\t*\tG\t*\tGAD---\tDROP ZONE\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.EZ\tG\t*\tG\t*\tGAX---\tEXTRACTION ZONE (EZ)\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.LZ\tG\t*\tG\t*\tGAL---\tLANDING ZONE (LZ)\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.PZ\tG\t*\tG\t*\tGAP---\tPICKUP ZONE (PZ)\t\nMULTIPOINT\tTACGRP.C2GM.GNL.ARS.SRHARA\tG\t*\tG\t*\tGAS---\tSEARCH AREA/RECONNAISSANCE AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.LAARA\tG\t*\tG\t*\tGAY---\tLIMITED ACCESS AREA\t\nPOLYGON\tTACGRP.C2GM.GNL.ARS.AIRFZ\tG\t*\tG\t*\tGAZ---\tAIRFIELD ZONE\t\n\tTACGRP.C2GM.AVN\tG\t*\tG\t*\tA-----\tAVIATION\tN/A\n\tTACGRP.C2GM.AVN.PNT\tG\t*\tG\t*\tAP----\tPOINTS\tN/A\nPOINT\tTACGRP.C2GM.AVN.PNT.ACP\tG\t*\tG\t*\tAPP---\tAIR CONTROL POINT (ACP)\t\nPOINT\tTACGRP.C2GM.AVN.PNT.COMMCP\tG\t*\tG\t*\tAPC---\tCOMMUNICATIONS CHECKPOINT (CCP)\t\nPOINT\tTACGRP.C2GM.AVN.PNT.PUP\tG\t*\tG\t*\tAPU---\tPULL-UP POINT (PUP)\t\nPOINT\tTACGRP.C2GM.AVN.PNT.DAPP\tG\t*\tG\t*\tAPD---\tDOWNED AIRCREW PICKUP POINT\t\nLINE\tTACGRP.C2GM.AVN.LNE\tG\t*\tG\t*\tAL----\tLINES\tN/A\nLINE\tTACGRP.C2GM.AVN.LNE.ACDR\tG\t*\tG\t*\tALC---\tAIR CORRIDOR\t\nLINE\tTACGRP.C2GM.AVN.LNE.MRR\tG\t*\tG\t*\tALM---\tMINIMUM RISK ROUTE (MRR)\t\nLINE\tTACGRP.C2GM.AVN.LNE.SAAFR\tG\t*\tG\t*\tALS---\tSTANDARD-USE ARMY AIRCRAFT FLIGHT ROUTE (SAAFR)\t\nLINE\tTACGRP.C2GM.AVN.LNE.UAR\tG\t*\tG\t*\tALU---\tUNMANNED AIRCRAFT (UA) ROUTE\t\nLINE\tTACGRP.C2GM.AVN.LNE.LLTR\tG\t*\tG\t*\tALL---\tLOW LEVEL TRANSIT ROUTE (LLTR)\t\n\tTACGRP.C2GM.AVN.ARS\tG\t*\tG\t*\tAA----\tAREAS\tN/A\nPOLYGON\tTACGRP.C2GM.AVN.ARS.ROZ\tG\t*\tG\t*\tAAR---\tRESTRICTED OPERATIONS ZONE (ROZ)\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.SHRDEZ\tG\t*\tG\t*\tAAF---\tSHORT-RANGE AIR DEFENSE ENGAGEMENT ZONE (SHORADEZ)\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.HIDACZ\tG\t*\tG\t*\tAAH---\tHIGH DENSITY AIRSPACE CONTROL ZONE (HIDACZ)\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.MEZ\tG\t*\tG\t*\tAAM---\tMISSILE ENGAGEMENT ZONE (MEZ)\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.MEZ.LAMEZ\tG\t*\tG\t*\tAAML--\tLOW ALTITUDE MEZ\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.MEZ.HAMEZ\tG\t*\tG\t*\tAAMH--\tHIGH ALTITUDE MEZ\t\nPOLYGON\tTACGRP.C2GM.AVN.ARS.WFZ\tG\t*\tG\t*\tAAW---\tWEAPONS FREE ZONE\t\n\tTACGRP.C2GM.DCPN\tG\t*\tG\t*\tP-----\tDECEPTION\tN/A\nLINE\tTACGRP.C2GM.DCPN.DMY\tG\t*\tG\t*\tPD----\tDUMMY (DECEPTION/DECOY)\t\nLINE\tTACGRP.C2GM.DCPN.AAFF\tG\t*\tG\t*\tPA----\tAXIS OF ADVANCE FOR FEINT\t\nLINE\tTACGRP.C2GM.DCPN.DAFF\tG\t*\tG\t*\tPF----\tDIRECTION OF ATTACK FOR FEINT\t\nPOLYGON\tTACGRP.C2GM.DCPN.DMA\tG\t*\tG\t*\tPM----\tDECOY MINED AREA\t\nPOLYGON\tTACGRP.C2GM.DCPN.DMAF\tG\t*\tG\t*\tPY----\tDECOY MINED AREA, FENCED\t\nPOINT\tTACGRP.C2GM.DCPN.DMYMS\tG\t*\tG\t*\tPN----\tDUMMY MINEFIELD (STATIC)\t\nPOLYGON\tACGRP.C2GM.DCPN.DMYMD\tG\t*\tG\t*\tPC----\tDUMMY MINEFIELD (DYNAMIC)\t\n\tTACGRP.C2GM.DEF\tG\t*\tG\t*\tD-----\tDEFENSE\tN/A\n\tTACGRP.C2GM.DEF.PNT\tG\t*\tG\t*\tDP----\tPOINTS\tN/A\nPOINT\tTACGRP.C2GM.DEF.PNT.TGTREF\tG\t*\tG\t*\tDPT---\tTARGET REFERENCE POINT (TRP)\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST\tG\t*\tG\t*\tDPO---\tOBSERVATION POST/OUTPOST\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.CBTPST\tG\t*\tG\t*\tDPOC--\tCOMBAT OUTPOST\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.RECON\tG\t*\tG\t*\tDPOR--\tOBSERVATION POST OCCUPIED BY DISMOUNTED SCOUTS OR RECONNAISSANCE\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.FWDOP\tG\t*\tG\t*\tDPOF--\tFORWARD OBSERVER POSITION\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.SOP\tG\t*\tG\t*\tDPOS--\tSENSOR OUTPOST/LISTENING POST (OP/LP)\t\nPOINT\tTACGRP.C2GM.DEF.PNT.OBSPST.CBRNOP\tG\t*\tG\t*\tDPON--\tCBRN OBSERVATION POST (DISMOUNTED)\t\n\tTACGRP.C2GM.DEF.LNE\tG\t*\tG\t*\tDL----\tLINES\tN/A\nLINE\tTACGRP.C2GM.DEF.LNE.FEBA\tG\t*\tG\t*\tDLF---\tFORWARD EDGE OF BATTLE AREA (FEBA)\t\nLINE\tTACGRP.C2GM.DEF.LNE.PDF\tG\t*\tG\t*\tDLP---\tPRINCIPAL DIRECTION OF FIRE (PDF)\t\n\tTACGRP.C2GM.DEF.ARS\tG\t*\tG\t*\tDA----\tAREAS\tN/A\nPOLYGON\tTACGRP.C2GM.DEF.ARS.BTLPSN\tG\t*\tG\t*\tDAB---\tBATTLE POSITION\t\nPOLYGON\tTACGRP.C2GM.DEF.ARS.BTLPSN.PBNO\tG\t*\tG\t*\tDABP--\tPREPARED BUT NOT OCCUPIED\t\nPOLYGON\tTACGRP.C2GM.DEF.ARS.EMTARA\tG\t*\tG\t*\tDAE---\tENGAGEMENT AREA\t\n\tTACGRP.C2GM.OFF\tG\t*\tG\t*\tO-----\tOFFENSE\tN/A\n\tTACGRP.C2GM.OFF.PNT\tG\t*\tG\t*\tOP----\tPOINTS\tN/A\nPOINT\tTACGRP.C2GM.OFF.PNT.PNTD\tG\t*\tG\t*\tOPP---\tPOINT OF DEPARTURE\t\n\tTACGRP.C2GM.OFF.LNE\tG\t*\tG\t*\tOL----\tLINES\tN/A\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV\tG\t*\tG\t*\tOLA---\tAXIS OF ADVANCE\tN/A\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV.AVN\tG\t*\tG\t*\tOLAV--\tAVIATION\t\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV.ABN\tG\t*\tG\t*\tOLAA--\tAIRBORNE\t\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV.ATK\tG\t*\tG\t*\tOLAR--\tATTACK, ROTARY WING\t\n\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD\tG\t*\tG\t*\tOLAG--\tGROUND\tN/A\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD.MANATK\tG\t*\tG\t*\tOLAGM-\tMAIN ATTACK\t\nLINE\tTACGRP.C2GM.OFF.LNE.AXSADV.GRD.SUPATK\tG\t*\tG\t*\tOLAGS-\tSUPPORTING ATTACK\t\n\tTACGRP.C2GM.OFF.LNE.DIRATK\tG\t*\tG\t*\tOLK---\tDIRECTION OF ATTACK\tN/A\nLINE\tTACGRP.C2GM.OFF.LNE.DIRATK.AVN\tG\t*\tG\t*\tOLKA--\tAVIATION\t\n\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD\tG\t*\tG\t*\tOLKG--\tGROUND\tN/A\nLINE\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD.MANATK\tG\t*\tG\t*\tOLKGM-\tMAIN ATTACK\t\nLINE\tTACGRP.C2GM.OFF.LNE.DIRATK.GRD.SUPATK\tG\t*\tG\t*\tOLKGS-\tSUPPORTING ATTACK\t\nLINE\tTACGRP.C2GM.OFF.LNE.FCL\tG\t*\tG\t*\tOLF---\tFINAL COORDINATION LINE\t\nLINE\tTACGRP.C2GM.OFF.LNE.INFNLE\tG\t*\tG\t*\tOLI---\tINFILTRATION LANE\t\nLINE\tTACGRP.C2GM.OFF.LNE.LMTADV\tG\t*\tG\t*\tOLL---\tLIMIT OF ADVANCE\t\nLINE\tTACGRP.C2GM.OFF.LNE.LD\tG\t*\tG\t*\tOLT---\tLINE OF DEPARTURE\t\nLINE\tTACGRP.C2GM.OFF.LNE.LDLC\tG\t*\tG\t*\tOLC---\tLINE OF DEPARTURE/LINE OF CONTACT (LD/LC)\t\nLINE\tTACGRP.C2GM.OFF.LNE.PLD\tG\t*\tG\t*\tOLP---\tPROBABLE LINE OF DEPLOYMENT (PLD)\t\n\tTACGRP.C2GM.OFF.ARS\tG\t*\tG\t*\tOA----\tAREAS\tN/A\nPOLYGON\tTACGRP.C2GM.OFF.ARS.ASTPSN\tG\t*\tG\t*\tOAA---\tASSAULT POSITION\t\nPOLYGON\tTACGRP.C2GM.OFF.ARS.ATKPSN\tG\t*\tG\t*\tOAK---\tATTACK POSITION\t\nMULTIPOINT\tTACGRP.C2GM.OFF.ARS.AFP\tG\t*\tG\t*\tOAF---\tATTACK BY FIRE POSITION\t\nMULTIPOINT\tTACGRP.C2GM.OFF.ARS.SFP\tG\t*\tG\t*\tOAS---\tSUPPORT BY FIRE POSITION\t\nPOLYGON\tTACGRP.C2GM.OFF.ARS.OBJ\tG\t*\tG\t*\tOAO---\tOBJECTIVE\t\nPOLYGON\tTACGRP.C2GM.OFF.ARS.PBX\tG\t*\tG\t*\tOAP---\tPENETRATION BOX\t\n\tTACGRP.C2GM.SPL\tG\t*\tG\t*\tS-----\tSPECIAL\tN/A\n\tTACGRP.C2GM.SPL.LNE\tG\t*\tG\t*\tSL----\tLINE\tN/A\nMULTIPOINT\tTACGRP.C2GM.SPL.LNE.AMB\tG\t*\tG\t*\tSLA---\tAMBUSH\t\nMULTIPOINT\tTACGRP.C2GM.SPL.LNE.HGL\tG\t*\tG\t*\tSLH---\tHOLDING LINE\t\nLINE\tTACGRP.C2GM.SPL.LNE.REL\tG\t*\tG\t*\tSLR---\tRELEASE LINE\t\nMULTIPOINT\tTACGRP.C2GM.SPL.LNE.BRGH\tG\t*\tG\t*\tSLB---\tBRIDGEHEAD\t\n\tTACGRP.C2GM.SPL.ARA\tG\t*\tG\t*\tSA----\tAREA\tN/A\nPOLYGON\tTACGRP.C2GM.SPL.ARA.AOO\tG\t*\tG\t*\tSAO---\tAREA OF OPERATIONS (AO)\t\nPOLYGON\tTACGRP.C2GM.SPL.ARA.AHD\tG\t*\tG\t*\tSAA---\tAIRHEAD\t\nPOLYGON\tTACGRP.C2GM.SPL.ARA.ENCMT\tG\t*\tG\t*\tSAE---\tENCIRCLEMENT\t\nPOLYGON\tTACGRP.C2GM.SPL.ARA.NAI\tG\t*\tG\t*\tSAN---\tNAMED AREA OF INTEREST (NAI)\t\nPOLYGON\tTACGRP.C2GM.SPL.ARA.TAIS\tG\t*\tG\t*\tSAT---\tTARGETED AREA OF INTEREST (TAI)\t\n\tTACGRP.MOBSU\tG\t*\tM\t*\t------\tMOBILITY/SURVIVABILITY\tN/A\n\tTACGRP.MOBSU.OBST\tG\t*\tM \t*\tO-----\tOBSTACLES\tN/A\n\tTACGRP.MOBSU.OBST.GNL\tG\t*\tM\t*\tOG----\tGENERAL\tN/A\nPOLYGON\tTACGRP.MOBSU.OBST.GNL.BLT\tG\t*\tM\t*\tOGB---\tBELT\t\nLINE\tTACGRP.MOBSU.OBST.GNL.LNE\tG\t*\tM\t*\tOGL---\tLINE\t\nPOLYGON\tTACGRP.MOBSU.OBST.GNL.Z\tG\t*\tM\t*\tOGZ---\tZONE\t\nPOLYGON\tTACGRP.MOBSU.OBST.GNL.OFA\tG\t*\tM\t*\tOGF---\tOBSTACLE FREE AREA\t\nPOLYGON\tTACGRP.MOBSU.OBST.GNL.ORA\tG\t*\tM \t*\tOGR---\tOBSTACLE RESTRICTED AREA\t\nLINE\tTACGRP.MOBSU.OBST.ABS\tG\t*\tM\t*\tOS----\tABATIS\t\n\tTACGRP.MOBSU.OBST.ATO\tG\t*\tM\t*\tOA----\tANTITANK OBSTACLES\tN/A\n\tTACGRP.MOBSU.OBST.ATO.ATD\tG\t*\tM\t*\tOAD---\tANTITANK DITCH\tN/A\nLINE\tTACGRP.MOBSU.OBST.ATO.ATD.ATDUC\tG\t*\tM\t*\tOADU--\tUNDER CONSTRUCTION\t\nLINE\tTACGRP.MOBSU.OBST.ATO.ATD.ATDC\tG\t*\tM\t*\tOADC--\tCOMPLETE\t\nLINE\tTACGRP.MOBSU.OBST.ATO.ATDATM\tG\t*\tM\t*\tOAR---\tANTITANK DITCH REINFORCED WITH ANTITANK MINES\t\n\tTACGRP.MOBSU.OBST.ATO.TDTSM\tG\t*\tM\t*\tOAO---\tANTITANK OBSTACLES: TETRAHEDRONS, DRAGONS TEETH, AND OTHER SIMILAR OBSTACLES\tN/A\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.FIXPFD\tG\t*\tM\t*\tOAOF--\tFIXED AND PREFABRICATED\t\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.MVB\tG\t*\tM\t*\tOAOM--\tMOVEABLE\t\nPOINT\tTACGRP.MOBSU.OBST.ATO.TDTSM.MVBPFD\tG\t*\tM\t*\tOAOP--\tMOVEABLE AND PREFABRICATED\t\nLINE\tTACGRP.MOBSU.OBST.ATO.ATW\tG\t*\tM\t*\tOAW---\tANTITANK WALL\t\nPOINT\tTACGRP.MOBSU.OBST.BBY\tG\t*\tM\t*\tOB----\tBOOBY TRAP\t\n\tTACGRP.MOBSU.OBST.MNE\tG\t*\tM\t*\tOM----\tMINES\tN/A\nPOINT\tTACGRP.MOBSU.OBST.MNE.USPMNE\tG\t*\tM\t*\tOMU---\tUNSPECIFIED MINE\t\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMNE\tG\t*\tM\t*\tOMT---\tANTITANK MINE (AT)\t\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMAHD\tG\t*\tM\t*\tOMD---\tANTITANK MINE WITH ANTIHANDLING DEVICE\t\nPOINT\tTACGRP.MOBSU.OBST.MNE.ATMDIR\tG\t*\tM\t*\tOME---\tANTITANK MINE (DIRECTIONAL)\t\nPOINT\tTACGRP.MOBSU.OBST.MNE.APMNE\tG\t*\tM\t*\tOMP---\tANTIPERSONNEL (AP) MINES\t\nPOINT\tTACGRP.MOBSU.OBST.MNE.WAMNE\tG\t*\tM\t*\tOMW---\tWIDE AREA MINES\t\nLINE\tTACGRP.MOBSU.OBST.MNE.MCLST\tG\t*\tM\t*\tOMC---\tMINE CLUSTER\t\n\tTACGRP.MOBSU.OBST.MNEFLD\tG\t*\tM\t*\tOF----\tMINEFIELDS\tN/A\nPOINT\tTACGRP.MOBSU.OBST.MNEFLD.STC\tG\t*\tM\t*\tOFS---\tSTATIC DEPICTION\t\nPOLYGON\tTACGRP.MOBSU.OBST.MNEFLD.DYN\tG\t*\tM\t*\tOFD---\tDYNAMIC DEPICTION\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.MNEFLD.GAP\tG\t*\tM\t*\tOFG---\tGAP\t\nPOLYGON\tTACGRP.MOBSU.OBST.MNEFLD.MNDARA\tG\t*\tM\t*\tOFA---\tMINED AREA\t\n\tTACGRP.MOBSU.OBST.OBSEFT\tG\t*\tM\t*\tOE----\tOBSTACLE EFFECT\tN/A\nMULTIPOINT\tTACGRP.MOBSU.OBST.OBSEFT.BLK\tG\t*\tM\t*\tOEB---\tBLOCK\t\nLINE\tTACGRP.MOBSU.OBST.OBSEFT.FIX\tG\t*\tM\t*\tOEF---\tFIX\t\nLINE\tTACGRP.MOBSU.OBST.OBSEFT.TUR\tG\t*\tM\t*\tOET---\tTURN\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.OBSEFT.DRT\tG\t*\tM\t*\tOED---\tDISRUPT\t\nPOLYGON\tTACGRP.MOBSU.OBST.UXO\tG\t*\tM\t*\tOU----\tUNEXPLODED ORDNANCE AREA (UXO)\t\n\tTACGRP.MOBSU.OBST.RCBB\tG\t*\tM\t*\tOR----\tROADBLOCKS, CRATERS, AND BLOWN BRIDGES\tN/A\nMULTIPOINT\tTACGRP.MOBSU.OBST.RCBB.PLND\tG\t*\tM\t*\tORP---\tPLANNED\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.RCBB.SAFE\tG\t*\tM\t*\tORS---\tEXPLOSIVES, STATE OF READINESS 1 (SAFE)\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.RCBB.ABP\tG\t*\tM\t*\tORA---\tEXPLOSIVES, STATE OF READINESS 2 (ARMED-BUT PASSABLE)\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.RCBB.EXCD\tG\t*\tM\t*\tORC---\tROADBLOCK COMPLETE (EXECUTED)\t\nMULTIPOINT\tTACGRP.MOBSU.OBST.TRIPWR\tG\t*\tM\t*\tOT----\tTRIP WIRE\t\n\tTACGRP.MOBSU.OBST.WREOBS\tG\t*\tM\t*\tOW----\tWIRE OBSTACLE\tN/A\nLINE\tTACGRP.MOBSU.OBST.WREOBS.USP\tG\t*\tM\t*\tOWU---\tUNSPECIFIED\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.SNGFNC\tG\t*\tM\t*\tOWS---\tSINGLE FENCE\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.DBLFNC\tG\t*\tM\t*\tOWD---\tDOUBLE FENCE\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.DAFNC\tG\t*\tM\t*\tOWA---\tDOUBLE APRON FENCE\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.LWFNC\tG\t*\tM\t*\tOWL---\tLOW WIRE FENCE\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.HWFNC\tG\t*\tM\t*\tOWH---\tHIGH WIRE FENCE\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.CCTA\tG\t*\tM\t*\tOWC---\tCONCERTINA\tN/A\nLINE\tTACGRP.MOBSU.OBST.WREOBS.CCTA.SNG\tG\t*\tM\t*\tOWCS--\tSINGLE CONCERTINA\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.CCTA.DBLSTD\tG\t*\tM\t*\tOWCD--\tDOUBLE STRAND CONCERTINA\t\nLINE\tTACGRP.MOBSU.OBST.WREOBS.CCTA.TRISTD\tG\t*\tM\t*\tOWCT--\tTRIPLE STRAND CONCERTINA\t\n\tTACGRP.MOBSU.OBST.AVN\tG\t*\tM\t*\tOH----\tAVIATION\tN/A\n\tTACGRP.MOBSU.OBST.AVN.TWR\tG\t*\tM\t*\tOHT---\tTOWER\tN/A\nPOINT\tTACGRP.MOBSU.OBST.AVN.TWR.LOW\tG\t*\tM\t*\tOHTL--\tLOW\t\nPOINT\tTACGRP.MOBSU.OBST.AVN.TWR.HIGH\tG\t*\tM\t*\tOHTH--\tHIGH\t\nLINE\tTACGRP.MOBSU.OBST.AVN.OHWIRE\tG\t*\tM\t*\tOHO---\tOVERHEAD WIRE/POWER LINE\t\n\tTACGRP.MOBSU.OBSTBP\tG\t*\tM\t*\tB-----\tOBSTACLE BYPASS\tN/A\n\tTACGRP.MOBSU.OBSTBP.DFTY\tG\t*\tM\t*\tBD----\tOBSTACLE BYPASS DIFFICULTY\tN/A\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.DFTY.ESY\tG\t*\tM\t*\tBDE---\tBYPASS EASY\t\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.DFTY.DFT\tG\t*\tM\t*\tBDD---\tBYPASS DIFFICULT\t\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.DFTY.IMP\tG\t*\tM\t*\tBDI---\tBYPASS IMPOSSIBLE\t\n\tTACGRP.MOBSU.OBSTBP.CSGSTE\tG\t*\tM\t*\tBC----\tCROSSING SITE/WATER CROSSING\tN/A\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.ASTCA\tG\t*\tM\t*\tBCA---\tASSAULT CROSSING AREA\t\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.BRG\tG\t*\tM\t*\tBCB---\tBRIDGE OR GAP\t\nLINE\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRY\tG\t*\tM\t*\tBCF---\tFERRY\t\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRDESY\tG\t*\tM\t*\tBCE---\tFORD EASY\t\nMULTIPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.FRDDFT\tG\t*\tM\t*\tBCD---\tFORD DIFFICULT\t\nLINE\tTACGRP.MOBSU.OBSTBP.CSGSTE.LANE\tG\t*\tM\t*\tBCL---\tLANE\t\nLINE\tTACGRP.MOBSU.OBSTBP.CSGSTE.RFT\tG\t*\tM\t*\tBCR---\tRAFT SITE\t\nPOINT\tTACGRP.MOBSU.OBSTBP.CSGSTE.ERP\tG\t*\tM\t*\tBCP---\tENGINEER REGULATING POINT\t\n\tTACGRP.MOBSU.SU\tG\t*\tM\t*\tS-----\tSURVIVABILITY\tN/A\nPOINT\tTACGRP.MOBSU.SU.ESTOF\tG\t*\tM\t*\tSE----\tEARTHWORK, SMALL TRENCH OR FORTIFICATION\t\nPOINT\tTACGRP.MOBSU.SU.FRT\tG\t*\tM\t*\tSF----\tFORT\t\nLINE\tTACGRP.MOBSU.SU.FTFDLN\tG\t*\tM\t*\tSL----\tFORTIFIED LINE\t\nLINE\tTACGRP.MOBSU.SU.FEWS\tG\t*\tM\t*\tSW----\tFOXHOLE, EMPLACEMENT OR WEAPON SITE\t\nPOLYGON\tTACGRP.MOBSU.SU.STRGPT\tG\t*\tM\t*\tSP----\tSTRONG POINT\t\nPOINT\tTACGRP.MOBSU.SU.SUFSHL\tG\t*\tM\t*\tSS----\tSURFACE SHELTER\t\nPOINT\tTACGRP.MOBSU.SU.UGDSHL\tG\t*\tM\t*\tSU----\tUNDERGROUND SHELTER\t\n\tTACGRP.MOBSU.CBRN\tG\t*\tM\t*\tN-----\tCHEMICAL, BIOLOGICAL, RADIOLOGICAL, AND NUCLEAR\tN/A\nMULTIPOINT\tTACGRP.MOBSU.CBRN.MSDZ\tG\t*\tM\t*\tNM----\tMINIMUM SAFE DISTANCE ZONES\t\nPOINT\tTACGRP.MOBSU.CBRN.NDGZ\tG\t*\tM\t*\tNZ----\tNUCLEAR DETONATIONS GROUND ZERO\t\nPOINT\tTACGRP.MOBSU.CBRN.FAOTP\tG\t*\tM\t*\tNF----\tFALLOUT PRODUCING\t\nPOLYGON\tTACGRP.MOBSU.CBRN.RADA\tG\t*\tM\t*\tNR----\tRADIOACTIVE AREA\t\nPOLYGON\tTACGRP.MOBSU.CBRN.BIOCA\tG\t*\tM\t*\tNB----\tBIOLOGICALLY CONTAMINATED AREA\t\nPOLYGON\tTACGRP.MOBSU.CBRN.CMLCA\tG\t*\tM\t*\tNC----\tCHEMICALLY CONTAMINATED AREA\t\n\tTACGRP.MOBSU.CBRN.REEVNT\tG\t*\tM\t*\tNE----\tRELEASE EVENTS\tN/A\nPOINT\tTACGRP.MOBSU.CBRN.REEVNT.BIO\tG\t*\tM\t*\tNEB---\tBIOLOGICAL\t\nPOINT\tTACGRP.MOBSU.CBRN.REEVNT.CML\tG\t*\tM\t*\tNEC---\tCHEMICAL\t\n\tTACGRP.MOBSU.CBRN.DECONP\tG\t*\tM\t*\tND----\tDECONTAMINATION (DECON) POINTS\tN/A\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.USP\tG\t*\tM\t*\tNDP---\tDECON SITE/POINT (UNSPECIFIED)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.ALTUSP\tG\t*\tM\t*\tNDA---\tALTERNATE DECON SITE/POINT (UNSPECIFIED)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.TRP\tG\t*\tM\t*\tNDT---\tDECON SITE/POINT (TROOPS)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.EQT\tG\t*\tM\t*\tNDE---\tDECON SITE/POINT (EQUIPMENT)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.EQTTRP\tG\t*\tM\t*\tNDB---\tDECON SITE/POINT (EQUIPMENT AND TROOPS)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.OPDECN\tG\t*\tM\t*\tNDO---\tDECON SITE/POINT (OPERATIONAL DECONTAMINATION)\t\nPOINT\tTACGRP.MOBSU.CBRN.DECONP.TRGH\tG\t*\tM\t*\tNDD---\tDECON SITE/POINT (THOROUGH DECONTAMINATION)\t\nPOLYGON\tTACGRP.MOBSU.CBRN.DRCL\tG\t*\tM\t*\tNL----\tDOSE RATE CONTOUR LINES\t\n\tTACGRP.FSUPP\tG\t*\tF\t*\t------\tFIRE SUPPORT\tN/A\n\tTACGRP.FSUPP.PNT\tG\t*\tF\t*\tP-----\tPOINT\tN/A\n\tTACGRP.FSUPP.PNT.TGT\tG\t*\tF\t*\tPT----\tTARGET\tN/A\nPOINT\tTACGRP.FSUPP.PNT.TGT.PTGT\tG\t*\tF\t*\tPTS---\tPOINT/SINGLE TARGET\t\nPOINT\tTACGRP.FSUPP.PNT.TGT.NUCTGT\tG\t*\tF\t*\tPTN---\tNUCLEAR TARGET\t\n\tTACGRP.FSUPP.PNT.C2PNT\tG\t*\tF\t*\tPC----\tCOMMAND & CONTROL POINTS\tN/A\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.FSS\tG\t*\tF\t*\tPCF---\tFIRE SUPPORT STATION\t\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.SCP\tG\t*\tF\t*\tPCS---\tSURVEY CONTROL POINT\t\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.FP\tG\t*\tF\t*\tPCB---\tFIRING POINT\t\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.RP\tG\t*\tF\t*\tPCR---\tRELOAD POINT\t\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.HP\tG\t*\tF\t*\tPCH---\tHIDE POINT\t\nPOINT\tTACGRP.FSUPP.PNT.C2PNT.LP\tG\t*\tF\t*\tPCL---\tLAUNCH POINT\t\n\tTACGRP.FSUPP.LNE\tG\t*\tF\t*\tL-----\tLINES\tN/A\nLINE\tTACGRP.FSUPP.LNE.LNRTGT\tG\t*\tF\t*\tLT----\tLINEAR TARGET\t\nLINE\tTACGRP.FSUPP.LNE.LNRTGT.LSTGT\tG\t*\tF\t*\tLTS---\tLINEAR SMOKE TARGET\t\nLINE\tTACGRP.FSUPP.LNE.LNRTGT.FPF\tG\t*\tF\t*\tLTF---\tFINAL PROTECTIVE FIRE (FPF)\t\n\tTACGRP.FSUPP.LNE.C2LNE\tG\t*\tF\t*\tLC----\tCOMMAND & CONTROL LINES\tN/A\nLINE\tTACGRP.FSUPP.LNE.C2LNE.FSCL\tG\t*\tF\t*\tLCF---\tFIRE SUPPORT COORDINATION LINE (FSCL)\t\nLINE\tTACGRP.FSUPP.LNE.C2LNE.CFL\tG\t*\tF\t*\tLCC---\tCOORDINATED FIRE LINE (CFL)\t\nLINE\tTACGRP.FSUPP.LNE.C2LNE.NFL\tG\t*\tF\t*\tLCN---\tNO-FIRE LINE (NFL)\t\nLINE\tTACGRP.FSUPP.LNE.C2LNE.RFL\tG\t*\tF\t*\tLCR---\tRESTRICTIVE FIRE LINE (RFL)\t\nLINE\tTACGRP.FSUPP.LNE.C2LNE.MFP\tG\t*\tF\t*\tLCM---\tMUNITION FLIGHT PATH (MFP)\t\n\tTACGRP.FSUPP.ARS\tG\t*\tF\t*\tA-----\tAREAS\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.ARATGT\tG\t*\tF\t*\tAT----\tAREA TARGET\t\n\tTACGRP.FSUPP.ARS.ARATGT.RTGTGT\tG\t*\tF\t*\tATR---\tRECTANGULAR TARGET\t\n\tTACGRP.FSUPP.ARS.ARATGT.CIRTGT\tG\t*\tF\t*\tATC---\tCIRCULAR TARGET\t\nPOLYGON\tTACGRP.FSUPP.ARS.ARATGT.SGTGT\tG\t*\tF\t*\tATG---\tSERIES OR GROUP OF TARGETS\t\nPOLYGON\tTACGRP.FSUPP.ARS.ARATGT.SMK\tG\t*\tF\t*\tATS---\tSMOKE\t\nPOLYGON\tTACGRP.FSUPP.ARS.ARATGT.BMARA\tG\t*\tF\t*\tATB---\tBOMB AREA\t\n\tTACGRP.FSUPP.ARS.C2ARS\tG\t*\tF\t*\tAC----\tCOMMAND & CONTROL AREAS\tN/A\n\tTACGRP.FSUPP.ARS.C2ARS.FSA\tG\t*\tF\t*\tACS---\tFIRE SUPPORT AREA (FSA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.FSA.IRR\tG\t*\tF\t*\tACSI--\tFIRE SUPPORT AREA (FSA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.FSA.RTG\tG\t*\tF\t*\tACSR--\tFIRE SUPPORT AREA (FSA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.FSA.CIRCLR\tG\t*\tF\t*\tACSC--\tFIRE SUPPORT AREA (FSA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.ACA\tG\t*\tF\t*\tACA---\tAIRSPACE COORDINATION AREA (ACA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.ACA.IRR\tG\t*\tF\t*\tACAI--\tAIRSPACE COORDINATION AREA (ACA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.ACA.RTG\tG\t*\tF\t*\tACAR--\tAIRSPACE COORDINATION AREA (ACA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.ACA.CIRCLR\tG\t*\tF\t*\tACAC--\tAIRSPACE COORDINATION AREA (ACA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.FFA\tG\t*\tF\t*\tACF---\tFREE FIRE AREA (FFA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.FFA.IRR\tG\t*\tF\t*\tACFI--\tFREE FIRE AREA (FFA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.FFA.RTG\tG\t*\tF\t*\tACFR--\tFREE FIRE AREA (FFA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.FFA.CIRCLR\tG\t*\tF\t*\tACFC--\tFREE FIRE AREA (FFA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.NFA\tG\t*\tF\t*\tACN---\tNO-FIRE AREA (NFA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.NFA.IRR\tG\t*\tF\t*\tACNI--\tNO FIRE AREA (NFA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.NFA.RTG\tG\t*\tF\t*\tACNR--\tNO FIRE AREA (NFA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.NFA.CIRCLR\tG\t*\tF\t*\tACNC--\tNO FIRE AREA (NFA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.RFA\tG\t*\tF\t*\tACR---\tRESTRICTIVE FIRE AREA (RFA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.RFA.IRR\tG\t*\tF\t*\tACRI--\tRESTRICTIVE FIRE AREA (RFA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.RFA.RTG\tG\t*\tF\t*\tACRR--\tRESTRICTIVE FIRE AREA (RFA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.RFA.CIRCLR\tG\t*\tF\t*\tACRC--\tRESTRICTIVE FIRE AREA (RFA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.PAA\tG\t*\tF\t*\tACP---\tPOSITION AREA FOR ARTILLERY (PAA)\tN/A\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.PAA.RTG\tG\t*\tF\t*\tACPR--\tPOSITION AREA FOR ARTILLERY (PAA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.PAA.CIRCLR\tG\t*\tF\t*\tACPC--\tPOSITION AREA FOR ARTILLERY (PAA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.SNSZ\tG\t*\tF\t*\tACE---\tSENSOR ZONE\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.SNSZ.IRR\tG\t*\tF\t*\tACEI--\tSENSOR ZONE, IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.SNSZ.RTG\tG\t*\tF\t*\tACER--\tSENSOR ZONE, RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.SNSZ.CIRCLR\tG\t*\tF\t*\tACEC--\tSENSOR ZONE, CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.DA\tG\t*\tF\t*\tACD---\tDEAD SPACE AREA (DA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.DA.IRR\tG\t*\tF\t*\tACDI--\tDEAD SPACE AREA (DA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.DA.RTG\tG\t*\tF\t*\tACDR--\tDEAD SPACE AREA (DA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.DA.CIRCLR\tG\t*\tF\t*\tACDC--\tDEAD SPACE AREA (DA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.ZOR\tG\t*\tF\t*\tACZ---\tZONE OF RESPONSIBILITY (ZOR)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.ZOR.IRR\tG\t*\tF\t*\tACZI--\tZONE OF RESPONSIBILITY (ZOR), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.ZOR.RTG\tG\t*\tF\t*\tACZR--\tZONE OF RESPONSIBILITY (ZOR), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.ZOR.CIRCLR\tG\t*\tF\t*\tACZC--\tZONE OF RESPONSIBILITY (ZOR), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.TBA\tG\t*\tF\t*\tACB---\tTARGET BUILD-UP AREA (TBA)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.TBA.IRR\tG\t*\tF\t*\tACBI--\tTARGET BUILD UP AREA (TBA), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.TBA.RTG\tG\t*\tF\t*\tACBR--\tTARGET BUILD UP AREA (TBA), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.TBA.CIRCLR\tG\t*\tF\t*\tACBC--\tTARGET BUILD UP AREA (TBA), CIRCULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.TVAR\tG\t*\tF\t*\tACV---\tTARGET VALUE AREA (TVAR)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.TVAR.IRR\tG\t*\tF\t*\tACVI--\tTARGET VALUE AREA (TVAR), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.C2ARS.TVAR.RTG\tG\t*\tF\t*\tACVR--\tTARGET VALUE AREA (TVAR), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.C2ARS.TVAR.CIRCLR\tG\t*\tF\t*\tACVC--\tTARGET VALUE AREA (TVAR), CIRCULAR\t\nPOLYGON\tTACGRP.FSUPP.ARS.C2ARS.TGMF\tG\t*\tF\t*\tACT---\tTERMINALLY GUIDED MUNITION FOOTPRINT (TGMF)\t\n\tTACGRP.FSUPP.ARS.TGTAQZ\tG\t*\tF\t*\tAZ----\tTARGET ACQUISITION ZONES\tN/A\n\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ\tG\t*\tF\t*\tAZI---\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ.IRR\tG\t*\tF\t*\tAZII--\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE, IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.TGTAQZ.ATIZ.RTG\tG\t*\tF\t*\tAZIR--\tARTILLERY TARGET INTELLIGENCE (ATI) ZONE, RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ\tG\t*\tF\t*\tAZX---\tCALL FOR FIRE ZONE (CFFZ)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ.IRR\tG\t*\tF\t*\tAZXI--\tCALL FOR FIRE ZONE (CFFZ), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.TGTAQZ.CFFZ.RTG\tG\t*\tF\t*\tAZXR--\tCALL FOR FIRE ZONE (CFFZ), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.TGTAQZ.CNS\tG\t*\tF\t*\tAZC---\tCENSOR ZONE\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.TGTAQZ.CNS.IRR\tG\t*\tF\t*\tAZCI--\tCENSOR ZONE, IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.TGTAQZ.CNS.RTG\tG\t*\tF\t*\tAZCR--\tCENSOR ZONE, RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ\tG\t*\tF\t*\tAZF---\tCRITICAL FRIENDLY ZONE (CFZ)\tN/A\nPOLYGON\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ.IRR\tG\t*\tF\t*\tAZFI--\tCRITICAL FRIENDLY ZONE (CFZ), IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.TGTAQZ.CFZ.RTG\tG\t*\tF\t*\tAZFR--\tCRITICAL FRIENDLY ZONE (CFZ), RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.WPNRF\tG\t*\tF\t*\tAX----\tWEAPON/SENSOR RANGE FANS\tN/A\n\tTACGRP.FSUPP.ARS.WPNRF.CIRCLR\tG\t*\tF\t*\tAXC---\tWEAPON/SENSOR RANGE FAN, CIRCULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.WPNRF.SCR\tG\t*\tF\t*\tAXS---\tWEAPON/SENSOR RANGE FAN, SECTOR\t\n\tTACGRP.FSUPP.ARS.KLBOX\tG\t*\tF\t*\tAK----\tKILL BOX\tN/A\n\tTACGRP.FSUPP.ARS.KLBOX.BLUE\tG\t*\tF\t*\tAKB---\tBLUE KILL BOX (BKB)\tN/A\n\tTACGRP.FSUPP.ARS.KLBOX.BLUE.CIRCLR\tG\t*\tF\t*\tAKBC--\tBLUE KILL BOX, CIRCULAR\t\nPOLYGON\tTACGRP.FSUPP.ARS.KLBOX.BLUE.IRR\tG\t*\tF\t*\tAKBI--\tBLUE KILL BOX, IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.KLBOX.BLUE.RTG\tG\t*\tF\t*\tAKBR--\tBLUE KILL BOX, RECTANGULAR\t\n\tTACGRP.FSUPP.ARS.KLBOX.PURPLE\tG\t*\tF\t*\tAKP---\tPURPLE KILL BOX (PKB)\tN/A\n\tTACGRP.FSUPP.ARS.KLBOX.PURPLE.CIRCLR\tG\t*\tF\t*\tAKPC--\tPURPLE KILL BOX, CIRCULAR\t\nPOLYGON\tTACGRP.FSUPP.ARS.KLBOX.PURPLE.IRR\tG\t*\tF\t*\tAKPI--\tPURPLE KILL BOX, IRREGULAR\t\nMULTIPOINT\tTACGRP.FSUPP.ARS.KLBOX.PURPLE.RTG\tG\t*\tF\t*\tAKPR--\tPURPLE KILL BOX, RECTANGULAR\t\n\tTACGRP.CSS\tG\t*\tS\t*\t------\tCOMBAT SERVICE SUPPORT\tN/A\n\tTACGRP.CSS.PNT\tG\t*\tS\t*\tP-----\tPOINTS\tN/A\nPOINT\tTACGRP.CSS.PNT.AEP\tG\t*\tS\t*\tPX----\tAMBULANCE EXCHANGE POINT\t\nPOINT\tTACGRP.CSS.PNT.CBNP\tG\t*\tS\t*\tPC----\tCANNIBALIZATION POINT\t\nPOINT\tTACGRP.CSS.PNT.CCP\tG\t*\tS\t*\tPY----\tCASUALTY COLLECTION POINT\t\nPOINT\tTACGRP.CSS.PNT.CVP\tG\t*\tS\t*\tPT----\tCIVILIAN COLLECTION POINT\t\nPOINT\tTACGRP.CSS.PNT.DCP\tG\t*\tS\t*\tPD----\tDETAINEE COLLECTION POINT\t\nPOINT\tTACGRP.CSS.PNT.EPWCP\tG\t*\tS\t*\tPE----\tENEMY PRISONER OF WAR (EPW) COLLECTION POINT\t\nPOINT\tTACGRP.CSS.PNT.LRP\tG\t*\tS\t*\tPL----\tLOGISTICS RELEASE POINT (LRP)\t\nPOINT\tTACGRP.CSS.PNT.MCP\tG\t*\tS\t*\tPM----\tMAINTENANCE COLLECTION POINT\t\nPOINT\tTACGRP.CSS.PNT.RRRP\tG\t*\tS\t*\tPR----\tREARM, REFUEL AND RESUPPLY POINT\t\nPOINT\tTACGRP.CSS.PNT.ROM\tG\t*\tS\t*\tPU----\tREFUEL ON THE MOVE (ROM) POINT\t\nPOINT\tTACGRP.CSS.PNT.TCP\tG\t*\tS\t*\tPO----\tTRAFFIC CONTROL POST (TCP)\t\nPOINT\tTACGRP.CSS.PNT.TTP\tG\t*\tS\t*\tPI----\tTRAILER TRANSFER POINT\t\nPOINT\tTACGRP.CSS.PNT.UMC\tG\t*\tS\t*\tPN----\tUNIT MAINTENANCE COLLECTION POINT\t\n\tTACGRP.CSS.PNT.SPT\tG\t*\tS\t*\tPS----\tSUPPLY POINTS\tN/A\nPOINT\tTACGRP.CSS.PNT.SPT.GNL\tG\t*\tS\t*\tPSZ---\tGENERAL\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS1\tG\t*\tS\t*\tPSA---\tCLASS I\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS2\tG\t*\tS\t*\tPSB---\tCLASS II\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS3\tG\t*\tS\t*\tPSC---\tCLASS III\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS4\tG\t*\tS\t*\tPSD---\tCLASS IV\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS5\tG\t*\tS\t*\tPSE---\tCLASS V\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS6\tG\t*\tS\t*\tPSF---\tCLASS VI\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS7\tG\t*\tS\t*\tPSG---\tCLASS VII\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS8\tG\t*\tS\t*\tPSH---\tCLASS VIII\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS9\tG\t*\tS\t*\tPSI---\tCLASS IX\t\nPOINT\tTACGRP.CSS.PNT.SPT.CLS10\tG\t*\tS\t*\tPSJ---\tCLASS X\t\n\tTACGRP.CSS.PNT.AP\tG\t*\tS\t*\tPA----\tAMMUNITION POINTS\tN/A\nPOINT\tTACGRP.CSS.PNT.AP.ASP\tG\t*\tS\t*\tPAS---\tAMMUNITION SUPPLY POINT (ASP)\t\nPOINT\tTACGRP.CSS.PNT.AP.ATP\tG\t*\tS\t*\tPAT---\tAMMUNITION TRANSFER POINT (ATP)\t\n\tTACGRP.CSS.LNE\tG\t*\tS\t*\tL-----\tLINES\tN/A\n\tTACGRP.CSS.LNE.CNY\tG\t*\tS\t*\tLC----\tCONVOYS\tN/A\nMULTIPOINT\tTACGRP.CSS.LNE.CNY.MCNY\tG\t*\tS\t*\tLCM---\tMOVING CONVOY\t\nMULTIPOINT\tTACGRP.CSS.LNE.CNY.HCNY\tG\t*\tS\t*\tLCH---\tHALTED CONVOY\t\n\tTACGRP.CSS.LNE.SLPRUT\tG\t*\tS\t*\tLR----\tSUPPLY ROUTES\tN/A\nLINE\tTACGRP.CSS.LNE.SLPRUT.MSRUT\tG\t*\tS\t*\tLRM---\tMAIN SUPPLY ROUTE\t\nLINE\tTACGRP.CSS.LNE.SLPRUT.ASRUT\tG\t*\tS\t*\tLRA---\tALTERNATE SUPPLY ROUTE\t\nLINE\tTACGRP.CSS.LNE.SLPRUT.1WTRFF\tG\t*\tS\t*\tLRO---\tONE-WAY TRAFFIC\t\nLINE\tTACGRP.CSS.LNE.SLPRUT.ATRFF\tG\t*\tS\t*\tLRT---\tALTERNATING TRAFFIC\t\nLINE\tTACGRP.CSS.LNE.SLPRUT.2WTRFF\tG\t*\tS\t*\tLRW---\tTWO-WAY TRAFFIC\t\n\tTACGRP.CSS.ARA\tG\t*\tS\t*\tA-----\tAREA\tN/A\nPOLYGON\tTACGRP.CSS.ARA.DHA\tG\t*\tS\t*\tAD----\tDETAINEE HOLDING AREA\t\nPOLYGON\tTACGRP.CSS.ARA.EPWHA\tG\t*\tS\t*\tAE----\tENEMY PRISONER OF WAR (EPW) HOLDING AREA\t\nPOLYGON\tTACGRP.CSS.ARA.FARP\tG\t*\tS\t*\tAR----\tFORWARD ARMING AND REFUELING AREA (FARP)\t\nPOLYGON\tTACGRP.CSS.ARA.RHA\tG\t*\tS\t*\tAH----\tREFUGEE HOLDING AREA\t\nPOLYGON\tTACGRP.CSS.ARA.SUPARS\tG\t*\tS\t*\tAS----\tSUPPORT AREAS\tN/A\nPOLYGON\tTACGRP.CSS.ARA.SUPARS.BSA\tG\t*\tS\t*\tASB---\tBRIGADE (BSA)\t\nPOLYGON\tTACGRP.CSS.ARA.SUPARS.DSA\tG\t*\tS\t*\tASD---\tDIVISION (DSA)\t\nPOLYGON\tTACGRP.CSS.ARA.SUPARS.RSA\tG\t*\tS\t*\tASR---\tREGIMENTAL (RSA)\t\n\tTACGRP.OTH\tG\t*\tO\t*\t------\tOTHER\tN/A\n\tTACGRP.OTH.ER\tG\t*\tO\t*\tE-----\tEMERGENCY\tN/A\nPOINT\tTACGRP.OTH.ER.DTHAC\tG\t*\tO\t*\tED----\tDITCHED AIRCRAFT\t\nPOINT\tTACGRP.OTH.ER.PIW\tG\t*\tO\t*\tEP----\tPERSON IN WATER\t\nPOINT\tTACGRP.OTH.ER.DSTVES\tG\t*\tO\t*\tEV----\tDISTRESSED VESSEL\t\n\tTACGRP.OTH.HAZ\tG\t*\tO\t*\tH-----\tHAZARD\tN/A\nPOINT\tTACGRP.OTH.HAZ.SML\tG\t*\tO\t*\tHM----\tSEA MINE-LIKE\t\nMULTIPOINT\tTACGRP.OTH.HAZ.NVGL\tG\t*\tO\t*\tHN----\tNAVIGATIONAL\t\nPOINT\tTACGRP.OTH.HAZ.IB\tG\t*\tO\t*\tHI----\tICEBERG\t\nPOINT\tTACGRP.OTH.HAZ.OLRG\tG\t*\tO\t*\tHO----\tOIL RIG\t\n\tTACGRP.OTH.SSUBSR\tG\t*\tO\t*\tS-----\tSEA SUBSURFACE RETURNS\tN/A\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN\tG\t*\tO\t*\tSB----\tBOTTOM RETURN/NON-MILCO\t\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.INS\tG\t*\tO\t*\tSBM---\tINSTALLATION/MANMADE\t\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.SBRSOO\tG\t*\tO\t*\tSBN---\tSEABED ROCK/STONE, OBSTACLE, OTHER\t\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.WRKND\tG\t*\tO\t*\tSBW---\tWRECK, NON DANGEROUS\t\nPOINT\tTACGRP.OTH.SSUBSR.BTMRTN.WRKD\tG\t*\tO\t*\tSBX---\tWRECK, DANGEROUS\t\nPOINT\tTACGRP.OTH.SSUBSR.MARLFE\tG\t*\tO\t*\tSM----\tMARINE LIFE\t\nPOINT\tTACGRP.OTH.SSUBSR.SA\tG\t*\tO\t*\tSS----\tSEA ANOMALY (WAKE, CURRENT, KNUCKLE)\t\nLINE\tTACGRP.OTH.BERLNE\tG\t*\tO\t*\tB-----\tBEARING LINE\t\nLINE\tTACGRP.OTH.BERLNE.ELC\tG\t*\tO\t*\tBE----\tELECTRONIC\t\nLINE\tTACGRP.OTH.BERLNE.ACU\tG\t*\tO\t*\tBA----\tACOUSTIC\t\nLINE\tTACGRP.OTH.BERLNE.TPD\tG\t*\tO\t*\tBT----\tTORPEDO\t\nLINE\tTACGRP.OTH.BERLNE.EOPI\tG\t*\tO\t*\tBO----\tELECTRO-OPTICAL INTERCEPT\t\n\tTACGRP.OTH.FIX\tG\t*\tO\t*\tF-----\tFIX\tN/A\nPOINT\tTACGRP.OTH.FIX.ACU\tG\t*\tO\t*\tFA----\tACOUSTIC\t\nPOINT\tTACGRP.OTH.FIX.EM\tG\t*\tO\t*\tFE----\tELECTRO-MAGNETIC\t\nPOINT\tTACGRP.OTH.FIX.EOP\tG\t*\tO\t*\tFO----\tELECTRO-OPTICAL\t\n";

  var mil_std_2525c_signals_intelligence = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSIGINT \tI\t-\t-\t-\t------\tSIGNALS INTELLIGENCE\tN/A\nSIGINT.SPC \tI\t*\tP\t*\t------\tSPACE TRACK\tN/A\nSIGINT.SPC.SIGINC \tI\t*\tP\t*\tS-----\tSIGNAL INTERCEPT\tN/A\nSIGINT.SPC.SIGINC.COMM \tI\t*\tP\t*\tSC----\tCOMMUNICATIONS\tN/A\nSIGINT.SPC.SIGINC.COMM.SATDL \tI\t*\tP\t*\tSCD---\tSATELLITE DOWNLINK \t\nSIGINT.SPC.SIGINC.RAD \tI\t*\tP\t*\tSR----\tRADAR\tN/A\nSIGINT.SPC.SIGINC.RAD.DATTMN \tI\t*\tP\t*\tSRD---\tDATA TRANSMISSION \t\nSIGINT.SPC.SIGINC.RAD.ERHSVL \tI\t*\tP\t*\tSRE---\tEARTH SURVEILLANCE \t\nSIGINT.SPC.SIGINC.RAD.IFF \tI\t*\tP\t*\tSRI---\tIFF (TRANSPONDER) \t\nSIGINT.SPC.SIGINC.RAD.MFN \tI\t*\tP\t*\tSRM---\tMULTIFUNCTION \t\nSIGINT.SPC.SIGINC.RAD.TGTAQ \tI\t*\tP\t*\tSRT---\tTARGET ACQUISITION \t\nSIGINT.SPC.SIGINC.RAD.SPC \tI\t*\tP\t*\tSRS---\tSPACE \t\nSIGINT.SPC.SIGINC.RAD.UNK \tI\t*\tP\t*\tSRU---\tUNKNOWN \t\nSIGINT.AIRTRK \tI\t*\tA\t*\t------\tAIR TRACK\tN/A\nSIGINT.AIRTRK.SIGINC \tI\t*\tA\t*\tS-----\tSIGNAL INTERCEPT\tN/A\nSIGINT.AIRTRK.SIGINC.COMM \tI\t*\tA\t*\tSC----\tCOMMUNICATIONS\tN/A\nSIGINT.AIRTRK.SIGINC.COMM.CELL \tI\t*\tA\t*\tSCC---\tCELLULAR/MOBILE \t\nSIGINT.AIRTRK.SIGINC.COMM.OLOS \tI\t*\tA\t*\tSCO---\tOMNI-LINE OF SIGHT (LOS) \t\nSIGINT.AIRTRK.SIGINC.COMM.PTPLOS \tI\t*\tA\t*\tSCP---\tPOINT-TO-POINT LINE OF SIGHT (LOS) \t\nSIGINT.AIRTRK.SIGINC.COMM.SATUL \tI\t*\tA\t*\tSCS---\tSATELLITE UPLINK \t\nSIGINT.AIRTRK.SIGINC.RAD \tI\t*\tA\t*\tSR----\tRADAR\tN/A\nSIGINT.AIRTRK.SIGINC.RAD.ABNINC \tI\t*\tA\t*\tSRAI--\tAIRBORNE INTERCEPT \t\nSIGINT.AIRTRK.SIGINC.RAD.ABNSB \tI\t*\tA\t*\tSRAS--\tAIRBORNE SEARCH & BOMBING \t\nSIGINT.AIRTRK.SIGINC.RAD.CTDINC \tI\t*\tA\t*\tSRC---\tCONTROLLED INTERCEPT \t\nSIGINT.AIRTRK.SIGINC.RAD.DATTMN \tI\t*\tA\t*\tSRD---\tDATA TRANSMISSION \t\nSIGINT.AIRTRK.SIGINC.RAD.EW \tI\t*\tA\t*\tSRE---\tEARLY WARNING \t\nSIGINT.AIRTRK.SIGINC.RAD.FIRCTL \tI\t*\tA\t*\tSRF---\tFIRE CONTROL \t\nSIGINT.AIRTRK.SIGINC.RAD.IFF \tI\t*\tA\t*\tSRI---\tIFF (TRANSPONDER) \t\nSIGINT.AIRTRK.SIGINC.RAD.MSLAQ \tI\t*\tA\t*\tSRMA--\tMISSILE ACQUISITION \t\nSIGINT.AIRTRK.SIGINC.RAD.MSLDL \tI\t*\tA\t*\tSRMD--\tMISSILE DOWNLINK \t\nSIGINT.AIRTRK.SIGINC.RAD.MSLGDN \tI\t*\tA\t*\tSRMG--\tMISSILE GUIDANCE \t\nSIGINT.AIRTRK.SIGINC.RAD.MSLTRK \tI\t*\tA\t*\tSRMT--\tMISSILE TRACKING \t\nSIGINT.AIRTRK.SIGINC.RAD.MFN \tI\t*\tA\t*\tSRMF--\tMULTIFUNCTION \t\nSIGINT.AIRTRK.SIGINC.RAD.TGTILL \tI\t*\tA\t*\tSRTI--\tTARGET ILLUMINATOR \t\nSIGINT.AIRTRK.SIGINC.RAD.TGTAQ \tI\t*\tA\t*\tSRTA--\tTARGET ACQUISITION \t\nSIGINT.AIRTRK.SIGINC.RAD.TGTTRK \tI\t*\tA\t*\tSRTT--\tTARGET TRACKING \t\nSIGINT.AIRTRK.SIGINC.RAD.UNK \tI\t*\tA\t*\tSRU---\tUNKNOWN \t\nSIGINT.GRDTRK \tI\t*\tG\t*\t------\tGROUND TRACK\tN/A\nSIGINT.GRDTRK.SIGINC \tI\t*\tG\t*\tS-----\tSIGNAL INTERCEPT\tN/\nSIGINT.GRDTRK.SIGINC.COMM \tI\t*\tG\t*\tSC----\tCOMMUNICATIONS\tN/A\nSIGINT.GRDTRK.SIGINC.COMM.CELL \tI\t*\tG\t*\tSCC---\tCELLULAR/MOBILE \t\nSIGINT.GRDTRK.SIGINC.COMM.OLOS \tI\t*\tG\t*\tSCO---\tOMNI-LINE OF SIGHT (LOS) \t\nSIGINT.GRDTRK.SIGINC.COMM.PTPLOS \tI\t*\tG\t*\tSCP---\tPOINT-TO-POINT LINE OF SIGHT (LOS) \t\nSIGINT.GRDTRK.SIGINC.COMM.SATUL \tI\t*\tG\t*\tSCS---\tSATELLITE UPLINK \t\nSIGINT.GRDTRK.SIGINC.COMM.TPSSCT \tI\t*\tG\t*\tSCT---\tTROPOSPHERIC SCATTER \t\nSIGINT.GRDTRK.SIGINC.RAD \tI\t*\tG\t*\tSR----\tRADAR\tN/A\nSIGINT.GRDTRK.SIGINC.RAD.ATCTL \tI\t*\tG\t*\tSRAT--\tAIR TRAFFIC CONTROL\t\nSIGINT.GRDTRK.SIGINC.RAD.AA/C \tI\t*\tG\t*\tSRAA--\tANTIAIRCRAFT \t\nSIGINT.GRDTRK.SIGINC.RAD.BTFSVL \tI\t*\tG\t*\tSRB---\tBATTLEFIELD SURVEILLANCE \t\nSIGINT.GRDTRK.SIGINC.RAD.CSTSVL \tI\t*\tG\t*\tSRCS--\tCOASTAL SURVEILLANCE \t\nSIGINT.GRDTRK.SIGINC.RAD.CTDAPP \tI\t*\tG\t*\tSRCA--\tCONTROLLED APPROACH \t\nSIGINT.GRDTRK.SIGINC.RAD.DATTMN \tI\t*\tG\t*\tSRD---\tDATA TRANSMISSION \t\nSIGINT.GRDTRK.SIGINC.RAD.EW \tI\t*\tG\t*\tSRE---\tEARLY WARNING \t\nSIGINT.GRDTRK.SIGINC.RAD.FIRCTL \tI\t*\tG\t*\tSRF---\tFIRE CONTROL \t\nSIGINT.GRDTRK.SIGINC.RAD.HGTFDG \tI\t*\tG\t*\tSRH---\tHEIGHT FINDING \t\nSIGINT.GRDTRK.SIGINC.RAD.IDFF \tI\t*\tG\t*\tSRI---\tIDENTIFICATION FRIEND/FOE (INTERROGATOR) \t\nSIGINT.GRDTRK.SIGINC.RAD.METO \tI\t*\tG\t*\tSRMM--\tMETEOROLOGICAL (MILITARY) \t\nSIGINT.GRDTRK.SIGINC.RAD.MSLAQ \tI\t*\tG\t*\tSRMA--\tMISSILE ACQUISITION \t\nSIGINT.GRDTRK.SIGINC.RAD.MSLGDN \tI\t*\tG\t*\tSRMG--\tMISSILE GUIDANCE \t\nSIGINT.GRDTRK.SIGINC.RAD.MSLTRK \tI\t*\tG\t*\tSRMT--\tMISSILE TRACKING \t\nSIGINT.GRDTRK.SIGINC.RAD.MFN \tI\t*\tG\t*\tSRMF--\tMULTIFUNCTION \t\nSIGINT.GRDTRK.SIGINC.RAD.SHETKG \tI\t*\tG\t*\tSRS---\tSHELL TRACKING \t\nSIGINT.GRDTRK.SIGINC.RAD.TGTAQ \tI\t*\tG\t*\tSRTA--\tTARGET ACQUISITION \t\nSIGINT.GRDTRK.SIGINC.RAD.TGTILL \tI\t*\tG\t*\tSRTI--\tTARGET ILLUMINATOR \t\nSIGINT.GRDTRK.SIGINC.RAD.TGTTRK \tI\t*\tG\t*\tSRTT--\tTARGET TRACKING \t\nSIGINT.GRDTRK.SIGINC.RAD.UNK \tI\t*\tG\t*\tSRU---\tUNKNOWN \t\nSIGINT.SSUF \tI\t*\tS\t*\t------\tSEA SURFACE TRACK\tN/A\nSIGINT.SSUF.SIGINC \tI\t*\tS\t*\tS-----\tSIGNAL INTERCEPT\tN/A\nSIGINT.SSUF.SIGINC.COMM \tI\t*\tS\t*\tSC----\tCOMMUNICATIONS\tN/A\nSIGINT.SSUF.SIGINC.COMM.CELL \tI\t*\tS\t*\tSCC---\tCELLULAR/MOBILE \t\nSIGINT.SSUF.SIGINC.COMM.OLOS \tI\t*\tS\t*\tSCO---\tOMNI-LINE OF SIGHT (LOS) \t\nSIGINT.SSUF.SIGINC.COMM.PTPLOS \tI\t*\tS\t*\tSCP---\tPOINT-TO-POINT LINE OF SIGHT (LOS) \t\nSIGINT.SSUF.SIGINC.COMM.SATUL \tI\t*\tS\t*\tSCS---\tSATELLITE UPLINK \t\nSIGINT.SSUF.SIGINC.RAD \tI\t*\tS\t*\tSR----\tRADAR\tN/A\nSIGINT.SSUF.SIGINC.RAD.ATCTL \tI\t*\tS\t*\tSRAT--\tAIR TRAFFIC CONTROL \t\nSIGINT.SSUF.SIGINC.RAD.AA/C \tI\t*\tS\t*\tSRAA--\tANTIAIRCRAFT \t\nSIGINT.SSUF.SIGINC.RAD.CTDAPP \tI\t*\tS\t*\tSRCA--\tCONTROLLED APPROACH \t\nSIGINT.SSUF.SIGINC.RAD.CTDINC \tI\t*\tS\t*\tSRCI--\tCONTROLLED INTERCEPT \t\nSIGINT.SSUF.SIGINC.RAD.DATTMN \tI\t*\tS\t*\tSRD---\tDATA TRANSMISSION \t\nSIGINT.SSUF.SIGINC.RAD.EW \tI\t*\tS\t*\tSRE---\tEARLY WARNING \t\nSIGINT.SSUF.SIGINC.RAD.FIRCTL \tI\t*\tS\t*\tSRF---\tFIRE CONTROL \t\nSIGINT.SSUF.SIGINC.RAD.HGTFDG \tI\t*\tS\t*\tSRH---\tHEIGHT FINDING \t\nSIGINT.SSUF.SIGINC.RAD.IDFF \tI\t*\tS\t*\tSRI---\tIDENTIFICATION FRIEND/FOE (INTERROGATOR) \t\nSIGINT.SSUF.SIGINC.RAD.METO \tI\t*\tS\t*\tSRMM--\tMETEOROLOGICAL (MILITARY) \t\nSIGINT.SSUF.SIGINC.RAD.MSLAQ \tI\t*\tS\t*\tSRMA--\tMISSILE ACQUISITION \t\nSIGINT.SSUF.SIGINC.RAD.MSLGDN \tI\t*\tS\t*\tSRMG--\tMISSILE GUIDANCE \t\nSIGINT.SSUF.SIGINC.RAD.MSLTRK \tI\t*\tS\t*\tSRMT--\tMISSILE TRACKING \t\nSIGINT.SSUF.SIGINC.RAD.MFN \tI\t*\tS\t*\tSRMF--\tMULTIFUNCTION \t\nSIGINT.SSUF.SIGINC.RAD.SUFSRH \tI\t*\tS\t*\tSRS---\tSURFACE SEARCH \t\nSIGINT.SSUF.SIGINC.RAD.TGTAQ \tI\t*\tS\t*\tSRTA--\tTARGET ACQUISITION \t\nSIGINT.SSUF.SIGINC.RAD.TGTILL \tI\t*\tS\t*\tSRTI--\tTARGET ILLUMINATOR \t\nSIGINT.SSUF.SIGINC.RAD.TGTTRK \tI\t*\tS\t*\tSRTT--\tTARGET TRACKING \t\nSIGINT.SSUF.SIGINC.RAD.UNK \tI\t*\tS\t*\tSRU---\tUNKNOWN \t\nSIGINT.SBSUF \tI\t*\tU\t*\t------\tSUBSURFACE TRACK\tN/A\nSIGINT.SBSUF.SIGINC \tI\t*\tU\t*\tS-----\tSIGNAL INTERCEPT\tN/A\nSIGINT.SBSUF.SIGINC.COMM \tI\t*\tU\t*\tSC----\tCOMMUNICATIONS\tN/A\nSIGINT.SBSUF.SIGINC.COMM.OLOS \tI\t*\tU\t*\tSCO---\tOMNI-LINE OF SIGHT (LOS)\t\nSIGINT.SBSUF.SIGINC.COMM.PTPLOS \tI\t*\tU\t*\tSCP---\tPOINT-TO-POINT LINE OF SIGHT (LOS) \t\nSIGINT.SBSUF.SIGINC.COMM.SATUL \tI\t*\tU\t*\tSCS---\tSATELLITE UPLINK \t\nSIGINT.SBSUF.SIGINC.RAD \tI\t*\tU\t*\tSR----\tRADAR\tN/A\nSIGINT.SBSUF.SIGINC.RAD.DATTMN \tI\t*\tU\t*\tSRD---\tDATA TRANSMISSION \t\nSIGINT.SBSUF.SIGINC.RAD.EW \tI\t*\tU\t*\tSRE---\tEARLY WARNING \t\nSIGINT.SBSUF.SIGINC.RAD.MFN \tI\t*\tU\t*\tSRM---\tMULTIFUNCTION \t\nSIGINT.SBSUF.SIGINC.RAD.SUFSRH \tI\t*\tU\t*\tSRS---\tSURFACE SEARCH \t\nSIGINT.SBSUF.SIGINC.RAD.TGTAQ \tI\t*\tU\t*\tSRT---\tTARGET ACQUISITION \t\nSIGINT.SBSUF.SIGINC.RAD.UNK \tI\t*\tU\t*\tSRU---\tUNKNOWN\t\n";

  var mil_std_2525c_stbops = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nSTBOPS \tO\t-\t-\t-\t------\tSTABILITY OPERATIONS (SO)\tN/A\nSTBOPS.VIOATY \tO\t*\tV\t*\t------\tVIOLENT ACTIVITIES (DEATH CAUSING) \t\nSTBOPS.VIOATY.ASN \tO\t*\tV\t*\tA-----\tARSON/FIRE \t\nSTBOPS.VIOATY.KILL \tO\t*\tV\t*\tM-----\tKILLING (GENERAL) \t\nSTBOPS.VIOATY.KILL.MDR \tO\t*\tV\t*\tMA----\tMURDER \t\nSTBOPS.VIOATY.KILL.EX \tO\t*\tV\t*\tMB----\tEXECUTION \t\nSTBOPS.VIOATY.KILL.ASS \tO\t*\tV\t*\tMC----\tASSASSINATION \t\nSTBOPS.VIOATY.BM \tO\t*\tV\t*\tB-----\tBOMB/BOMBING \t\nSTBOPS.VIOATY.BBY \tO\t*\tV\t*\tY-----\tBOOBY TRAP \t\nSTBOPS.VIOATY.DBS \tO\t*\tV\t*\tD-----\tDRIVE-BY SHOOTING \t\nSTBOPS.VIOATY.SPG \tO\t*\tV\t*\tS-----\tSNIPING \t\nSTBOPS.VIOATY.PSNG \tO\t*\tV\t*\tP-----\tPOISONING \t\nSTBOPS.VIOATY.EXPLSN \tO\t*\tV\t*\tE-----\tEXPLOSION \t\nSTBOPS.VIOATY.EXPLSN.EXPLSN \tO\t*\tV\t*\tEI----\tIED EXPLOSION \t\nSTBOPS.LOCAT \tO\t*\tL\t*\t------\tLOCATIONS \t\nSTBOPS.LOCAT.BLST \tO\t*\tL\t*\tB-----\tBLACK LIST LOCATION \t\nSTBOPS.LOCAT.GLST \tO\t*\tL\t*\tG-----\tGRAY LIST LOCATION \t\nSTBOPS.LOCAT.WLST \tO\t*\tL\t*\tW-----\tWHITE LIST LOCATION \t\nSTBOPS.LOCAT.MASS \tO\t*\tL\t*\tM-----\tMASS GRAVE LOCATION \t\nSTBOPS.OPN \tO\t*\tO\t*\t------\tOPERATIONS \t\nSTBOPS.OPN.PATG \tO\t*\tO\t*\tP-----\tPATROLLING \t\nSTBOPS.OPN.RCMT \tO\t*\tO\t*\tR-----\tRECRUITMENT \t\nSTBOPS.OPN.RCMT.WLG \tO\t*\tO\t*\tRW----\tRECRUITMENT (WILLING) \t\nSTBOPS.OPN.RCMT.CRCD \tO\t*\tO\t*\tRC----\tRECRUITMENT (COERCED/IMPRESSED) \t\nSTBOPS.OPN.DEMO \tO\t*\tO\t*\tD-----\tDEMONSTRATION \t\nSTBOPS.OPN.ML \tO\t*\tO\t*\tM-----\tMINE LAYING \t\nSTBOPS.OPN.PSYOP \tO\t*\tO\t*\tY-----\tPSYCHOLOGICAL OPERATIONS (PSYOP) \t\nSTBOPS.OPN.PSYOP.TARP \tO\t*\tO\t*\tYT----\tPSYOP (TV AND RADIO PROPAGANDA) \t\nSTBOPS.OPN.PSYOP.WP \tO\t*\tO\t*\tYW----\tPSYOP (WRITTEN PROPAGANDA) \t\nSTBOPS.OPN.PSYOP.HTHP \tO\t*\tO\t*\tYH----\tHOUSE-TO-HOUSE PROPAGANDA \t\nSTBOPS.OPN.FRGSRH \tO\t*\tO\t*\tF-----\tFORAGING/SEARCHING \t\nSTBOPS.OPN.SPY \tO\t*\tO\t*\tS-----\tSPY \t\nSTBOPS.OPN.FDDIST \tO\t*\tO\t*\tO-----\tFOOD DISTRIBUTION \t\nSTBOPS.OPN.EXTN \tO\t*\tO\t*\tE-----\tEXTORTION \t\nSTBOPS.OPN.HJKG \tO\t*\tO\t*\tH-----\tHIJACKING \t\nSTBOPS.OPN.HJKG.VEH \tO\t*\tO\t*\tHT----\tHIJACKING (VEHICLE) \t\nSTBOPS.OPN.HJKG.APL \tO\t*\tO\t*\tHA----\tHIJACKING (AIRPLANE) \t\nSTBOPS.OPN.HJKG.BOAT \tO\t*\tO\t*\tHV----\tHIJACKING (BOAT) \t\nSTBOPS.OPN.KDNG \tO\t*\tO\t*\tK-----\tKIDNAPPING \t\nSTBOPS.OPN.KDNG.ATEMPT \tO\t*\tO\t*\tKA----\tATTEMPTED \t\nSTBOPS.OPN.ARR \tO\t*\tO\t*\tA-----\tARREST \t\nSTBOPS.OPN.DGOPN \tO\t*\tO\t*\tU-----\tDRUG OPERATION \t\nSTBOPS.OPN.CMPLSS \tO\t*\tO\t*\tC-----\tCOMPOSITE LOSS \t\nSTBOPS.OPN.CMPLSS.CBT \tO\t*\tO\t*\tCA----\tCOMBAT \t\nSTBOPS.OPN.CMPLSS.ACCDNT \tO\t*\tO\t*\tCB----\tACCIDENT \t\nSTBOPS.OPN.CMPLSS.OTHER \tO\t*\tO\t*\tCC----\tOTHER \t\nSTBOPS.ITM \tO\t*\tI\t*\t------\tITEMS\tN/A\nSTBOPS.ITM.RFG \tO\t*\tI\t*\tR-----\tREFUGEES \t\nSTBOPS.ITM.SAFHSE \tO\t*\tI\t*\tS-----\tSAFE HOUSE \t\nSTBOPS.ITM.GRF \tO\t*\tI\t*\tG-----\tGRAFFITI \t\nSTBOPS.ITM.VRLRPS \tO\t*\tI\t*\tV-----\tVANDALISM/LOOT/RANSACK/PLUNDER/SACK \t\nSTBOPS.ITM.KNIVEH \tO\t*\tI\t*\tI-----\tKNOWN INSURGENT VEHICLE \t\nSTBOPS.ITM.DGVEH \tO\t*\tI\t*\tD-----\tDRUG VEHICLE \t\nSTBOPS.ITM.ISF \tO\t*\tI\t*\tF-----\tINTERNAL SECURITY FORCE \t\nSTBOPS.INDIV \tO\t*\tP\t*\t------\tINDIVIDUAL \t\nSTBOPS.INDIV.LEADER \tO\t*\tP\t*\tA-----\tLEADER \t\nSTBOPS.INDIV.TRGTD \tO\t*\tP\t*\tB-----\tTARGETED \t\nSTBOPS.INDIV.TERRST \tO\t*\tP\t*\tC-----\tTERRORIST \t\nSTBOPS.GRPORG \tO\t*\tG\t*\t------\tNONMILITARY GROUP OR ORGANIZATION \t\nSTBOPS.GRPORG.DPRE \tO\t*\tG\t*\tA-----\tDISPLACED PERSONS, REFUGEES, AND EVACUEES \t\nSTBOPS.GRPORG.NGO \tO\t*\tG\t*\tB-----\tNONGOVERNMENTAL ORGANIZATION (NGO) \t\nSTBOPS.GRPORG.TERRST \tO\t*\tG\t*\tC-----\tTERRORIST \t\nSTBOPS.GRPORG.RELIGS \tO\t*\tG\t*\tD-----\tRELIGIOUS \t\nSTBOPS.GRPORG.FNFGHT \tO\t*\tG\t*\tE-----\tFOREIGN FIGHTERS \t\nSTBOPS.GRPORG.GANG \tO\t*\tG\t*\tF-----\tGANG \t\nSTBOPS.RAPE \tO\t*\tR\t*\t------\tRAPE \t\nSTBOPS.RAPE.ATEMPT \tO\t*\tR\t*\tA-----\tATTEMPTED\t\n";

  var mil_std_2525c_ems = "hierarchy\tcodingscheme\taffiliation\tbattledimension\tstatus\tfunctionid\tname\tremarks\nEMS\tE\t-\t-\t-\t------\tEMERGENCY MANAGEMENT SYMBOLS\tN/A\nEMS.INCDNT \tE\t-\tI\t-\t------\tINCIDENT\tN/A\nEMS.INCDNT.CVDIS \tE\t*\tI\t*\tA-----\tCIVIL DISTURBANCE INCIDENT\t\nEMS.INCDNT.CVDIS.DEMO \tO\t*\tO\t*\tD-----\tCIVIL DEMONSTRATION\t\nEMS.INCDNT.CVDIS.DISPOP \tO\t*\tI\t*\tR-----\tCIVIL DISPLACED POPULATION\t\nEMS.INCDNT.CVDIS.CVRIOT \tE\t*\tI\t*\tAC----\tCIVIL RIOTING\t\nEMS.INCDNT.CRMACT \tE\t*\tI\t*\tB-----\tCRIMINAL ACTIVITY INCIDENT\t\nEMS.INCDNT.CRMACT.BMTHT \tE\t*\tI\t*\tBA----\tBOMB THREAT\t\nEMS.INCDNT.CRMACT.BM \tO\t*\tV\t*\tB-----\tBOMB\t\nEMS.INCDNT.CRMACT.EXPLN \tE\t*\tI\t*\tBC----\tEXPLOSION\t\nEMS.INCDNT.CRMACT.LOOT \tE\t*\tI\t*\tBD----\tLOOTING\t\nEMS.INCDNT.CRMACT.PSNG \tO\t*\tV\t*\tP-----\tPOISONING\t\nEMS.INCDNT.CRMACT.SHTG \tE\t*\tI\t*\tBF----\tSHOOTING\t\nEMS.INCDNT.FIRE \tE\t*\tI\t*\tC-----\tFIRE INCIDENT\t\nEMS.INCDNT.FIRE.HTSPT \tE\t*\tI\t*\tCA----\tHOT SPOT\t\nEMS.INCDNT.FIRE.NRES \tE\t*\tI\t*\tCB----\tNON-RESIDENTIAL FIRE\t\nEMS.INCDNT.FIRE.ORGN \tE\t*\tI\t*\tCC----\tORIGIN (OF FIRE)\t\nEMS.INCDNT.FIRE.RES \tE\t*\tI\t*\tCD----\tRESIDENTIAL FIRE\t\nEMS.INCDNT.FIRE.SCH \tE\t*\tI\t*\tCE----\tSCHOOL FIRE\t\nEMS.INCDNT.FIRE.SMK \tE\t*\tI\t*\tCF----\tSMOKE\t\nEMS.INCDNT.FIRE.SN \tE\t*\tI\t*\tCG----\tSPECIAL NEEDS FIRE\t\nEMS.INCDNT.FIRE.WLD \tE\t*\tI\t*\tCH----\tWILD FIRE\t\nEMS.INCDNT.HAZMAT \tE\t*\tI\t*\tD-----\tHAZARDOUS MATERIAL INCIDENT\t\nEMS.INCDNT.HAZMAT.CHMAGT \tE\t*\tI\t*\tDA----\tCHEMICAL AGENT\t\nEMS.INCDNT.HAZMAT.CORMTL \tE\t*\tI\t*\tDB----\tCORROSIVE MATERIAL\t\nEMS.INCDNT.HAZMAT.WHWET \tE\t*\tI\t*\tDC----\tHAZARDOUS WHEN WET\t\nEMS.INCDNT.HAZMAT.EXPLV \tE\t*\tI\t*\tDD----\tEXPLOSIVE\t\nEMS.INCDNT.HAZMAT.FLGAS \tE\t*\tI\t*\tDE----\tFLAMMABLE GAS\t\nEMS.INCDNT.HAZMAT.FLLIQ \tE\t*\tI\t*\tDF----\tFLAMMABLE LIQUID\t\nEMS.INCDNT.HAZMAT.FLSLD \tE\t*\tI\t*\tDG----\tFLAMMABLE SOLID\t\nEMS.INCDNT.HAZMAT.NFLGAS \tE\t*\tI\t*\tDH----\tNON-FLAMMABLE GAS\t\nEMS.INCDNT.HAZMAT.ORGPER \tE\t*\tI\t*\tDI----\tORGANIC PEROXIDE\t\nEMS.INCDNT.HAZMAT.OXDZR \tE\t*\tI\t*\tDJ----\tOXIDIZER\t\nEMS.INCDNT.HAZMAT.RADMTL \tE\t*\tI\t*\tDK----\tRADIOACTIVE MATERIAL\t\nEMS.INCDNT.HAZMAT.SPCMB \tE\t*\tI\t*\tDL----\tSPONTANEOUSLY COMBUSTIBLE\t\nEMS.INCDNT.HAZMAT.TXGAS \tE\t*\tI\t*\tDM----\tTOXIC GAS\t\nEMS.INCDNT.HAZMAT.TXINF \tE\t*\tI\t*\tDN----\tTOXIC AND INFECTIOUS\t\nEMS.INCDNT.HAZMAT.UNXORD \tE\t*\tI\t*\tDO----\tUNEXPLODED ORDNANCE\t\nEMS.INCDNT.AIR \tE\t*\tI\t*\tE-----\tAIR INCIDENT\t\nEMS.INCDNT.AIR.ACDNT \tE\t*\tI\t*\tEA----\tAIR ACCIDENT\t\nEMS.INCDNT.AIR.HJKG \tO\t*\tO\t*\tHA----\tAIR HIJACKING\t\nEMS.INCDNT.MRN \tE\t*\tI\t*\tF-----\tMARINE INCIDENT\t\nEMS.INCDNT.MRN.ACDNT \tE\t*\tI\t*\tFA----\tMARINE ACCIDENT\t\nEMS.INCDNT.MRN.HJKG \tO\t*\tO\t*\tHV----\tMARINE HIJACKING\t\nEMS.INCDNT.RAIL \tE\t*\tI\t*\tG-----\tRAIL INCIDENT\t\nEMS.INCDNT.RAIL.ACDNT \tE\t*\tI\t*\tGA----\tRAIL ACCIDENT\t\nEMS.INCDNT.RAIL.HJCK \tE\t*\tI\t*\tGB----\tRAIL HIJACKING\t\nEMS.INCDNT.VEH \tE\t*\tI\t*\tH-----\tVEHICLE INCIDENT\t\nEMS.INCDNT.VEH.ACDNT \tE\t*\tI\t*\tHA----\tVEHICLE ACCIDENT\t\nEMS.INCDNT.VEH.HJKG \tO\t*\tO\t*\tHT----\tVEHICLE HIJACKING\t\nEMS.NATEVT \tE\t-\tN\t-\t------\tNATURAL EVENTS\tN/A\nEMS.NATEVT.GEO \tE\t*\tN\t*\tA-----\tGEOLOGIC\tN/A\nEMS.NATEVT.GEO.AFTSHK \tE\t*\tN\t*\tAA----\tAFTERSHOCK\t\nEMS.NATEVT.GEO.AVL \tE\t*\tN\t*\tAB----\tAVALANCHE\t\nEMS.NATEVT.GEO.EQKEPI \tE\t*\tN\t*\tAC----\tEARTHQUAKE EPICENTER\t\nEMS.NATEVT.GEO.LNDSLD \tE\t*\tN\t*\tAD----\tLANDSLIDE\t\nEMS.NATEVT.GEO.SBSDNC \tE\t*\tN\t*\tAE----\tSUBSIDENCE\t\nEMS.NATEVT.GEO.VOLERN \tW\tA\tS\t-\tWSVE--\tVOLCANIC ERUPTION\t\nEMS.NATEVT.GEO.VLCTHT \tE\t*\tN\t*\tAG----\tVOLCANIC THREAT\t\nEMS.NATEVT.HYDMET \tE\t*\tN\t*\tB-----\tHYDRO-METEOROLOGICAL\tN/A\nEMS.NATEVT.HYDMET.DZ \tW\tA\tS\t-\tWSD-LI\tDRIZZLE\t\nEMS.NATEVT.HYDMET.DRGHT \tE\t*\tN\t*\tBB----\tDROUGHT\t\nEMS.NATEVT.HYDMET.FLD \tE\t*\tN\t*\tBC----\tFLOOD\t\nEMS.NATEVT.HYDMET.FG \tW\tA\tS\t-\tWSFGSO\tFOG\t\nEMS.NATEVT.HYDMET.HL \tW\tA\tS\t-\tWSGRL-\tHAIL\t\nEMS.NATEVT.HYDMET.INV \tE\t*\tN\t*\tBF----\tINVERSION\t\nEMS.NATEVT.HYDMET.RA \tW\tA\tS\t-\tWSR-LI\tRAIN\t\nEMS.NATEVT.HYDMET.DT/SD \tW\tA\tS\t-\tWSDSLM\tSAND DUST STORM\t\nEMS.NATEVT.HYDMET.SN \tW\tA\tS\t-\tWSS-LI\tSNOW\t\nEMS.NATEVT.HYDMET.TSTRM \tW\tA\tS\t-\tWSTMH-\tTHUNDER STORM\t\nEMS.NATEVT.HYDMET.TNDO \tW\tA\tS\t-\tWST-FC\tTORNADO\t\nEMS.NATEVT.HYDMET.TRPCYC \tW\tA\tS\t-\tWSTSS-\tTROPICAL CYCLONE\t\nEMS.NATEVT.HYDMET.TSNMI \tE\t*\tN\t*\tBM----\tTSUNAMI\t\nEMS.NATEVT.INFST \tE\t*\tN\t*\tC-----\tINFESTATION\tN/A\nEMS.NATEVT.INFST.BIRD \tE\t*\tN\t*\tCA----\tBIRD INFESTATION\t\nEMS.NATEVT.INFST.INSCT \tE\t*\tN\t*\tCB----\tINSECT INFESTATION\t\nEMS.NATEVT.INFST.MICROB \tE\t*\tN\t*\tCC----\tMICROBIAL INFESTATION\t\nEMS.NATEVT.INFST.REPT \tE\t*\tN\t*\tCD----\tREPTILE INFESTATION\t\nEMS.NATEVT.INFST.RDNT \tE\t*\tN\t*\tCE----\tRODENT INFESTATION\t\nEMS.OPN \tE\t-\tO\t-\t------\tOPERATIONS\tN/A\nEMS.OPN.EMMED \tE\t*\tO\t*\tA-----\tEMERGENCY MEDICAL OPERATION\t\nEMS.OPN.EMMED.UNT \tE\t*\tO\t*\tAA----\tEMERGENCY MEDICAL OPERATION UNIT\t\nEMS.OPN.EMMED.EQPT \tE\t*\tO\t*\tAB----\tEMERGENCY MEDICAL OPERATION EQUIPMENT\t\nEMS.OPN.EMMED.INS \tE\t*\tO\t*\tAC----\tEMERGENCY MEDICAL OPERATION INSTALLATION\t\nEMS.OPN.EMMED.EMTLOC \tE\t*\tO\t*\tAD----\tEMT STATION LOCATION\t\nEMS.OPN.EMMED.AMBLNC \tE\t*\tO\t*\tAE----\tAMBULANCE\t\nEMS.OPN.EMMED.MEH \tE\t*\tO\t*\tAF----\tMEDICAL EVACUATION HELICOPTER\t\nEMS.OPN.EMMED.HDF \tE\t*\tO\t*\tAG----\tHEALTH DEPARTMENT FACILITY\t\nEMS.OPN.EMMED.HSP \tS\t*\tG\t*\tIXH---\tHOSPITAL\t\nEMS.OPN.EMMED.HSPSHP \tS\t*\tS\t*\tNM----\tHOSPITAL SHIP\t\nEMS.OPN.EMMED.MFOP \tE\t*\tO\t*\tAJ----\tMEDICAL FACILITIES OUT PATIENT\t\nEMS.OPN.EMMED.MRG \tE\t*\tO\t*\tAK----\tMORGUE\t\nEMS.OPN.EMMED.RX \tE\t*\tO\t*\tAL----\tPHARMACY\t\nEMS.OPN.EMMED.TRIAGE \tE\t*\tO\t*\tAM----\tTRIAGE\t\nEMS.OPN.EMOPN \tE\t*\tO\t*\tB-----\tEMERGENCY OPERATION\t\nEMS.OPN.EMOPN.UNT \tE\t*\tO\t*\tBA----\tEMERGENCY OPERATION UNIT\t\nEMS.OPN.EMOPN.EQPT \tE\t*\tO\t*\tBB----\tEMERGENCY OPERATION EQUIPMENT\t\nEMS.OPN.EMOPN.INS \tE\t*\tO\t*\tBC----\tEMERGENCY OPERATION INSTALLATION\t\nEMS.OPN.EMOPN.ECEP \tE\t*\tO\t*\tBD----\tEMERGENCY COLLECTION EVACUATION POINT\t\nEMS.OPN.EMOPN.EICC \tE\t*\tO\t*\tBE----\tEMERGENCY INCIDENT COMMAND CENTER\t\nEMS.OPN.EMOPN.EOC \tE\t*\tO\t*\tBF----\tEMERGENCY OPERATIONS CENTER\t\nEMS.OPN.EMOPN.EPIC \tE\t*\tO\t*\tBG----\tEMERGENCY PUBLIC INFORMATION CENTER\t\nEMS.OPN.EMOPN.EMSHLT \tE\t*\tO\t*\tBH----\tEMERGENCY SHELTER\t\nEMS.OPN.EMOPN.ESA \tE\t*\tO\t*\tBI----\tEMERGENCY STAGING AREA\t\nEMS.OPN.EMOPN.EMTM \tE\t*\tO\t*\tBJ----\tEMERGENCY TEAM\t\nEMS.OPN.EMOPN.EWDC \tE\t*\tO\t*\tBK----\tEMERGENCY WATER DISTRIBUTION CENTER\t\nEMS.OPN.EMOPN.FDDIST \tE\t*\tO\t*\tBL----\tEMERGENCY FOOD DISTRIBUTION CENTER\t\nEMS.OPN.FIRFT \tE\t*\tO\t*\tC-----\tFIRE FIGHTING OPERATION\t\nEMS.OPN.FIRFT.FIRFTU \tE\t*\tO\t*\tCA----\tFIRE FIGHTING OPERATION UNIT\t\nEMS.OPN.FIRFT.FIRFTE \tE\t*\tO\t*\tCB----\tFIRE FIGHTING OPERATION EQUIPMENT\t\nEMS.OPN.FIRFT.FIRHYD \tE\t*\tO\t*\tCC----\tFIRE HYDRANT\t\nEMS.OPN.FIRFT.OTHH2O \tE\t*\tO\t*\tCD----\tOTHER WATER SUPPLY LOCATION\t\nEMS.OPN.FIRFT.FIRSTN \tE\t*\tO\t*\tCE----\tFIRE STATION\t\nEMS.OPN.LAWENF \tE\t*\tO\t*\tD-----\tLAW ENFORCEMENT OPERATION\t\nEMS.OPN.LAWENF.LAWENU \tE\t*\tO\t*\tDA----\tLAW ENFORCEMENT OPERATION UNIT\t\nEMS.OPN.LAWENF.LAWENE \tE\t*\tO\t*\tDB----\tLAW ENFORCEMENT OPERATION EQUIPMENT\t\nEMS.OPN.LAWENF.LAWENI \tE\t*\tO\t*\tDC----\tLAW ENFORCEMENT OPERATION INSTALLATION\t\nEMS.OPN.LAWENF.ATF \tE\t*\tO\t*\tDD----\tATF\t\nEMS.OPN.LAWENF.ATF.ATFUNT \tE\t*\tO\t*\tDDA---\tATF UNIT\t\nEMS.OPN.LAWENF.ATF.ATFEQP \tE\t*\tO\t*\tDDB---\tATF EQUIPMENT\t\nEMS.OPN.LAWENF.ATF.ATFINS \tE\t*\tO\t*\tDDC---\tATF INSTALLATION\t\nEMS.OPN.LAWENF.BDRPT \tE\t*\tO\t*\tDE----\tBORDER PATROL\t\nEMS.OPN.LAWENF.BDRPT.BDRPTU \tE\t*\tO\t*\tDEA---\tBORDER PATROL UNIT\t\nEMS.OPN.LAWENF.BDRPT.BDRPTE \tE\t*\tO\t*\tDEB---\tBORDER PATROL EQUIPMENT\t\nEMS.OPN.LAWENF.BDRPT.BDRPTI \tE\t*\tO\t*\tDEC---\tBORDER PATROL INSTALLATION\t\nEMS.OPN.LAWENF.CSTM \tE\t*\tO\t*\tDF----\tCUSTOMS SERVICE\t\nEMS.OPN.LAWENF.CSTM.CSTMUN \tE\t*\tO\t*\tDFA---\tCUSTOMS SERVICE UNIT\t\nEMS.OPN.LAWENF.CSTM.CSTMEQ \tE\t*\tO\t*\tDFB---\tCUSTOMS SERVICE EQUIPMENT\t\nEMS.OPN.LAWENF.CSTM.CSTMIN \tE\t*\tO\t*\tDFC---\tCUSTOMS SERVICE INSTALLATION\t\nEMS.OPN.LAWENF.DEA \tE\t*\tO\t*\tDG----\tDEA\t\nEMS.OPN.LAWENF.DEA.DEAUNT \tE\t*\tO\t*\tDGA---\tDEA UNIT\t\nEMS.OPN.LAWENF.DEA.DEAEQP \tE\t*\tO\t*\tDGB---\tDEA EQUIPMENT\t\nEMS.OPN.LAWENF.DEA.DEAINS \tE\t*\tO\t*\tDGC---\tDEA INSTALLATION\t\nEMS.OPN.LAWENF.DOJ \tE\t*\tO\t*\tDH----\tDOJ\t\nEMS.OPN.LAWENF.DOJ.DOJ \tE\t*\tO\t*\tDHA---\tDOJ UNIT\t\nEMS.OPN.LAWENF.DOJ.DOJEQP \tE\t*\tO\t*\tDHB---\tDOJ EQUIPMENT\t\nEMS.OPN.LAWENF.DOJ.DOJINS \tE\t*\tO\t*\tDHC---\tDOJ INSTALLATION\t\nEMS.OPN.LAWENF.FBI \tE\t*\tO\t*\tDI----\tFBI\t\nEMS.OPN.LAWENF.FBI.FBIUNT \tE\t*\tO\t*\tDIA---\tFBI UNIT\t\nEMS.OPN.LAWENF.FBI.FBIEQP \tE\t*\tO\t*\tDIB---\tFBI EQUIPMENT\t\nEMS.OPN.LAWENF.FBI.FBIINS \tE\t*\tO\t*\tDIC---\tFBI INSTALLATION\t\nEMS.OPN.LAWENF.POL \tE\t*\tO\t*\tDJ----\tPOLICE\t\nEMS.OPN.LAWENF.POL.POLUNT \tS\t*\tG\t*\tUULC--\tPOLICE UNIT\t\nEMS.OPN.LAWENF.POL.POLEQP \tE\t*\tO\t*\tDJB---\tPOLICE EQUIPMENT\t\nEMS.OPN.LAWENF.POL.POLINS \tE\t*\tO\t*\tDJC---\tPOLICE INSTALLATION\t\nEMS.OPN.LAWENF.PRSN \tE\t*\tO\t*\tDK----\tPRISON\t\nEMS.OPN.LAWENF.SECSR \tE\t*\tO\t*\tDL----\tSECRET SERVICE\t\nEMS.OPN.LAWENF.SECSR.SECSRU \tE\t*\tO\t*\tDLA---\tSECRET SERVICE UNIT\t\nEMS.OPN.LAWENF.SECSR.SECSRE \tE\t*\tO\t*\tDLB---\tSECRET SERVICE EQUIPMENT\t\nEMS.OPN.LAWENF.SECSR.SECSRI \tE\t*\tO\t*\tDLC---\tSECRET SERVICE INSTALLATION\t\nEMS.OPN.LAWENF.TSA \tE\t*\tO\t*\tDM----\tTSA\t\nEMS.OPN.LAWENF.TSA.TSAUNT \tE\t*\tO\t*\tDMA---\tTSA UNIT\t\nEMS.OPN.LAWENF.TSA.TSAEQP \tE\t*\tO\t*\tDMB---\tTSA EQUIPMENT\t\nEMS.OPN.LAWENF.TSA.TSAINS \tE\t*\tO\t*\tDMC---\tTSA INSTALLATION\t\nEMS.OPN.LAWENF.CSTGD \tE\t*\tO\t*\tDN----\tCOAST GUARD\t\nEMS.OPN.LAWENF.CSTGD.CSTGDU \tE\t*\tO\t*\tDNA---\tCOAST GUARD UNIT\t\nEMS.OPN.LAWENF.CSTGD.CSTGDE \tS\t*\tS\t*\tXL----\tCOAST GUARD EQUIPMENT\t\nEMS.OPN.LAWENF.CSTGD.CSTGDI \tE\t*\tO\t*\tDNC---\tCOAST GUARD INSTALLATION\t\nEMS.OPN.LAWENF.USMAR \tE\t*\tO\t*\tDO----\tUS MARSHALS SERVICE\t\nEMS.OPN.LAWENF.USMAR.USMARU \tE\t*\tO\t*\tDOA---\tUS MARSHALS SERVICE UNIT\t\nEMS.OPN.LAWENF.USMAR.USMARE \tE\t*\tO\t*\tDOB---\tUS MARSHALS SERVICE EQUIPMENT\t\nEMS.OPN.LAWENF.USMAR.USMARI \tE\t*\tO\t*\tDOC---\tUS MARSHALS SERVICE INSTALLATION\t\nEMS.OPN.SNS \tS\t*\tG\t*\tES----\tSENSOR\t\nEMS.OPN.SNS.BIO \tE\t*\tO\t*\tEA----\tBIOLOGICAL SENSOR\t\nEMS.OPN.SNS.CML \tE\t*\tO\t*\tEB----\tCHEMICAL SENSOR\t\nEMS.OPN.SNS.INT \tE\t*\tO\t*\tEC----\tINTRUSION SENSOR\t\nEMS.OPN.SNS.NUC \tE\t*\tO\t*\tED----\tNUCLEAR SENSOR\t\nEMS.OPN.SNS.RAD \tE\t*\tO\t*\tEE----\tRADIOLOGICAL SENSOR\t\nEMS.INFSTR \tE\t-\tF\t-\t------\tINFRASTRUCTURE\tN/A\nEMS.INFSTR.AGFD \tE\t*\tF\t*\tA-----\tAGRICULTURE AND FOOD INFRASTRUCTURE\t\nEMS.INFSTR.AGFD.AGLAB \tE\t*\tF\t*\tAA----\tAGRICULTURAL LABORATORY\t\nEMS.INFSTR.AGFD.AFL \tE\t*\tF\t*\tAB----\tANIMAL FEEDLOT\t\nEMS.INFSTR.AGFD.CFDC \tE\t*\tF\t*\tAC----\tCOMMERCIAL FOOD DISTRIBUTION CENTER\t\nEMS.INFSTR.AGFD.FRMRNC \tE\t*\tF\t*\tAD----\tFARM/RANCH\t\nEMS.INFSTR.AGFD.FPC \tE\t*\tF\t*\tAE----\tFOOD PRODUCTION CENTER\t\nEMS.INFSTR.AGFD.FDRTL \tE\t*\tF\t*\tAF----\tFOOD RETAIL\t\nEMS.INFSTR.AGFD.GRSTR \tE\t*\tF\t*\tAG----\tGRAIN STORAGE\t\nEMS.INFSTR.BFI \tE\t*\tF\t*\tB-----\tBANKING FINANCE AND INSURANCE INFRASTRUCTURE\t\nEMS.INFSTR.BFI.ATM \tE\t*\tF\t*\tBA----\tATM\t\nEMS.INFSTR.BFI.BANK \tE\t*\tF\t*\tBB----\tBANK\t\nEMS.INFSTR.BFI.BLSTR \tE\t*\tF\t*\tBC----\tBULLION STORAGE\t\nEMS.INFSTR.BFI.FRB \tE\t*\tF\t*\tBD----\tFEDERAL RESERVE BANK\t\nEMS.INFSTR.BFI.FINEX \tE\t*\tF\t*\tBE----\tFINANCIAL EXCHANGE\t\nEMS.INFSTR.BFI.FSO \tE\t*\tF\t*\tBF----\tFINANCIAL SERVICES OTHER\t\nEMS.INFSTR.CMCL \tE\t*\tF\t*\tC-----\tCOMMERCIAL INFRASTRUCTURE\t\nEMS.INFSTR.CMCL.CMLPLN \tE\t*\tF\t*\tCA----\tCHEMICAL PLANT\t\nEMS.INFSTR.CMCL.FIRMAN \tE\t*\tF\t*\tCB----\tFIREARMS MANUFACTURER\t\nEMS.INFSTR.CMCL.FIRRET \tE\t*\tF\t*\tCC----\tFIREARMS RETAILER\t\nEMS.INFSTR.CMCL.HZMTPR \tE\t*\tF\t*\tCD----\tHAZARDOUS MATERIAL PRODUCTION\t\nEMS.INFSTR.CMCL.HZMTST \tE\t*\tF\t*\tCE----\tHAZARDOUS MATERIAL STORAGE\t\nEMS.INFSTR.CMCL.INDSTE \tE\t*\tF\t*\tCF----\tINDUSTRIAL SITE\t\nEMS.INFSTR.CMCL.LNDFL \tE\t*\tF\t*\tCG----\tLANDFILL\t\nEMS.INFSTR.CMCL.RXMFG \tE\t*\tF\t*\tCH----\tPHARMACEUTICAL MANUFACTURER\t\nEMS.INFSTR.CMCL.CHWS \tE\t*\tF\t*\tCI----\tCONTAMINATED HAZARDOUS WASTE SITE\t\nEMS.INFSTR.CMCL.TXRLIN \tE\t*\tF\t*\tCJ----\tTOXIC RELEASE INVENTORY\t\nEMS.INFSTR.EDFAC \tE\t*\tF\t*\tD-----\tEDUCATIONAL FACILITIES INFRASTRUCTURE\t\nEMS.INFSTR.EDFAC.COLUNI \tE\t*\tF\t*\tDA----\tCOLLEGE UNIVERSITY\t\nEMS.INFSTR.EDFAC.SCHOOL \tE\t*\tF\t*\tDB----\tSCHOOL\t\nEMS.INFSTR.ENGFAC \tS\t*\tG\t*\tIUE---\tENERGY FACILITIES INFRASTRUCTURE\t\nEMS.INFSTR.ENGFAC.GENSTA \tE\t*\tF\t*\tEA----\tGENERATION STATION\t\nEMS.INFSTR.ENGFAC.NTLGAS \tE\t*\tF\t*\tEB----\tNATURAL GAS FACILITY\t\nEMS.INFSTR.ENGFAC.NUCFAC \tS\t*\tG\t*\tIUEN--\tNUCLEAR FACILITY\t\nEMS.INFSTR.ENGFAC.PETFAC \tS\t*\tG\t*\tIRP---\tPETROLEUM FACILITY\t\nEMS.INFSTR.ENGFAC.PROPNE \tE\t*\tF\t*\tEE----\tPROPANE FACILITY\t\nEMS.INFSTR.GVTSTE \tE\t*\tF\t*\tF-----\tGOVERNMENT SITE INFRASTRUCTURE\t\nEMS.INFSTR.MIL \tE\t*\tF\t*\tG-----\tMILITARY INFRASTRUCTURE\t\nEMS.INFSTR.MIL.ARMORY \tE\t*\tF\t*\tGA----\tMILITARY ARMORY\t\nEMS.INFSTR.MIL.MILBF \tS\t*\tG\t*\tIB----\tMILITARY BASE\t\nEMS.INFSTR.PSTSRV \tE\t*\tF\t*\tH-----\tPOSTAL SERVICE INFRASTRUCTURE\t\nEMS.INFSTR.PSTSRV.PDC \tE\t*\tF\t*\tHA----\tPOSTAL DISTRIBUTION CENTER\t\nEMS.INFSTR.PSTSRV.PO \tE\t*\tF\t*\tHB----\tPOST OFFICE\t\nEMS.INFSTR.PUBVEN \tE\t*\tF\t*\tI-----\tPUBLIC VENUES INFRASTRUCTURE\t\nEMS.INFSTR.PUBVEN.ENCFAC \tE\t*\tF\t*\tIA----\tENCLOSED FACILITY\t\nEMS.INFSTR.PUBVEN.OPNFAC \tE\t*\tF\t*\tIB----\tOPEN FACILITY\t\nEMS.INFSTR.PUBVEN.RECARE \tE\t*\tF\t*\tIC----\tRECREATIONAL AREA\t\nEMS.INFSTR.PUBVEN.RELIG \tE\t*\tF\t*\tID----\tRELIGIOUS INSTITUTION\t\nEMS.INFSTR.SPCNDS \tE\t*\tF\t*\tJ-----\tSPECIAL NEEDS INFRASTRUCTURE\t\nEMS.INFSTR.SPCNDS.ADLTDC \tE\t*\tF\t*\tJA----\tADULT DAY CARE\t\nEMS.INFSTR.SPCNDS.CHLDDC \tE\t*\tF\t*\tJB----\tCHILD DAY CARE\t\nEMS.INFSTR.SPCNDS.ELDERC \tE\t*\tF\t*\tJC----\tELDER CARE\t\nEMS.INFSTR.TELCOM \tE\t*\tF\t*\tK-----\tTELECOMMUNICATIONS INFRASTRUCTURE\t\nEMS.INFSTR.TELCOM.TCF \tS\t*\tG\t*\tIUT---\tTELECOMMUNICATIONS FACILITY\t\nEMS.INFSTR.TELCOM.TCTWR \tE\t*\tF\t*\tKB----\tTELECOMMUNICATIONS TOWER\t\nEMS.INFSTR.TSP \tS\t*\tG\t*\tIT----\tTRANSPORTATION INFRASTRUCTURE\t\nEMS.INFSTR.TSP.ATCF \tE\t*\tF\t*\tLA----\tAIR TRAFFIC CONTROL FACILITY\t\nEMS.INFSTR.TSP.AIRPT \tS\t*\tG\t*\tIBA---\tAIRPORT\t\nEMS.INFSTR.TSP.BRG \tG\t*\tM\t*\tBCB---\tBRIDGE\t\nEMS.INFSTR.TSP.BSTN \tE\t*\tF\t*\tLD----\tBUS STATION\t\nEMS.INFSTR.TSP.FRYTRM \tE\t*\tF\t*\tLE----\tFERRY TERMINAL\t\nEMS.INFSTR.TSP.HLS \tE\t*\tF\t*\tLF----\tHELICOPTER LANDING SITE\t\nEMS.INFSTR.TSP.LCK \tW\tO\tS\t-\tML----\tLOCK\t\nEMS.INFSTR.TSP.MAINTF \tE\t*\tF\t*\tLH----\tMAINTENANCE FACILITY\t\nEMS.INFSTR.TSP.SP \tS\t*\tG\t*\tIBN---\tPORT\t\nEMS.INFSTR.TSP.RLSTN \tE\t*\tF\t*\tLJ----\tRAIL STATION\t\nEMS.INFSTR.TSP.RSTSTP \tE\t*\tF\t*\tLK----\tREST STOP\t\nEMS.INFSTR.TSP.ANCRG \tW\tO\tS\t-\tHPBA--\tSHIP ANCHORAGE\t\nEMS.INFSTR.TSP.TOLLF \tE\t*\tF\t*\tLM----\tTOLL FACILITY\t\nEMS.INFSTR.TSP.TCP \tG\t*\tS\t*\tPO----\tTRAFFIC CONTROL POINT\t\nEMS.INFSTR.TSP.TIF \tE\t*\tF\t*\tLO----\tTRAFFIC INSPECTION FACILITY\t\nEMS.INFSTR.TSP.TNL \tE\t*\tF\t*\tLP----\tTUNNEL\t\nEMS.INFSTR.WS \tS\t*\tG\t*\tIUP---\tWATER SUPPLY INFRASTRUCTURE\t\nEMS.INFSTR.WS.CV \tE\t*\tF\t*\tMA----\tCONTROL VALVE\t\nEMS.INFSTR.WS.DAM \tE\t*\tF\t*\tMB----\tDAM\t\nEMS.INFSTR.WS.DO \tE\t*\tF\t*\tMC----\tDISCHARGE OUTFALL\t\nEMS.INFSTR.WS.GWWELL \tE\t*\tF\t*\tMD----\tGROUND WATER WELL\t\nEMS.INFSTR.WS.PMPSTN \tE\t*\tF\t*\tME----\tPUMPING STATION\t\nEMS.INFSTR.WS.RSVR \tE\t*\tF\t*\tMF----\tRESERVOIR\t\nEMS.INFSTR.WS.STRTWR \tE\t*\tF\t*\tMG----\tSTORAGE TOWER\t\nEMS.INFSTR.WS.SWI \tE\t*\tF\t*\tMH----\tSURFACE WATER INTAKE\t\nEMS.INFSTR.WS.WH20TF \tE\t*\tF\t*\tMI----\tWASTEWATER TREATMENT FACILITY\t\n";

  var _2525c = {
    WAR: {
      name: "WARFIGHTING",
      SPC: {
        name: "SPACE",
        mainIcon: csv2json(mil_std_2525c_space)
      },
      AIRTRK: {
        name: "AIR",
        mainIcon: csv2json(mil_std_2525c_air)
      },
      GRDTRK_UNT: {
        name: "GROUND UNIT",
        mainIcon: csv2json(mil_std_2525c_ground_unit)
      },
      GRDTRK_EQT: {
        name: "GROUND EQUIPMENT",
        mainIcon: csv2json(mil_std_2525c_ground_equipment)
      },
      GRDTRK_INS: {
        name: "GROUND INSTALLATION",
        mainIcon: csv2json(mil_std_2525c_ground_installation)
      },
      SSUF: {
        name: "SEA SURFACE",
        mainIcon: csv2json(mil_std_2525c_sea_surface)
      },
      SBSUF: {
        name: "SUBSURFACE",
        mainIcon: csv2json(mil_std_2525c_sub_surface)
      },
      SOFUNT: {
        name: "SPECIAL OPERATIONS FORCES (SOF)",
        mainIcon: csv2json(mil_std_2525c_sof)
      }
    },
    TACGRP: {
      name: "TACTICAL GRAPHICS",
      mainIcon: csv2json(mil_std_2525c_tactical_graphics)
    },
    SIGINT: {
      name: "SIGNALS INTELLIGENCE",
      mainIcon: csv2json(mil_std_2525c_signals_intelligence)
    },
    STBOPS: {
      name: "STABILITY OPERATIONS (SO)",
      mainIcon: csv2json(mil_std_2525c_stbops)
    },
    EMS: {
      name: "EMERGENCY MANAGEMENT SYMBOLS",
      mainIcon: csv2json(mil_std_2525c_ems)
    }
  };

  var mil_std_2525d_air_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nMilitary\t\t\t110000\tReserved for hierarchical purposes.\n\tFixed Wing\t\t110100\t\n\t\tMedical Evacuation (MEDEVAC)\t110101\t\n\t\tAttack/Strike\t110102\t\n\t\tBomber\t110103\t\n\t\tFighter\t110104\t\n\t\tFighter/Bomber\t110105\t\n\t\t{Reserved for future use}\t110106\t\n\t\tCargo\t110107\t\n\t\tElectronic Combat (EC)/Jammer\t110108\t\n\t\tTanker\t110109\t\n\t\tPatrol\t110110\t\n\t\tReconnaissance\t110111\t\n\t\tTrainer\t110112\t\n\t\tUtility\t110113\t\n\t\tVertical or Short Take-off and Landing (VSTOL)\t110114\t\n\t\tAirborne Command Post (ACP)\t110115\t\n\t\tAirborne Early Warning (AEW)\t110116\t\n\t\tAntisurface Warfare\t110117\t\n\t\tAntisubmarine Warfare\t110118\t\n\t\tCommunications\t110119\t\n\t\tCombat Search and Rescue (CSAR)\t110120\t\n\t\tElectronic Support (ES)\t110121\t\n\t\tGovernment\t110122\t\n\t\tMine Countermeasures (MCM)\t110123\t\n\t\tPersonnel Recovery\t110124\t\n\t\tSearch and Rescue\t110125\t\n\t\tSpecial Operations Forces\t110126\t\n\t\tUltra Light\t110127\t\n\t\tPhotographic Reconnaissance\t110128\t\n\t\tVery Important Person (VIP)\t110129\t\n\t\tSuppression of Enemy Air Defense\t110130\t\n\t\tPassenger\t110131\t\n\t\tEscort\t110132\t\n\t\tElectronic Attack (EA)\t110133\t\n\tRotary Wing\t\t110200\t\n\tUnmanned Aircraft (UA) / Unmanned Aerial Vehicle (UAV) / Unmanned Aircraft System (UAS) / Remotely Piloted Vehicle (RPV)\t\t110300\t\n\tVertical–Takeoff UAV (VT–UAV)\t\t110400\t\n\tLighter Than Air\t\t110500\t\n\tAirship\t\t110600\t\n\tTethered Lighter than Air\t\t110700\t\nCivilian\t\t\t120000\tReserved for hierarchical purposes.\n\tFixed Wing\t\t120100\t\n\tRotary Wing\t\t120200\t\n\tUnmanned Aircraft (UA) / Unmanned Aerial Vehicle (UAV) / Unmanned Aircraft System (UAS) / Remotely Piloted Vehicle (RPV)\t\t120300\t\n\tLighter Than Air\t\t120400\t\n\tAirship\t\t120500\t\n\tTethered Lighter than Air\t\t120600\t\nWeapon\t\t\t130000\tReserved for hierarchical purposes.\n\tBomb\t\t130100\t\n\tDecoy\t\t130200\t\nManual Track\t\t\t140000\t";

  var mil_std_2525d_air_m1 = "First Modifier\tCategory\tCode\tRemarks\nNot Applicable\t\t00\t\nAttack/Strike\tMilitary Aircraft Type\t01\t\nBomber\tMilitary Aircraft Type\t02\t\nCargo\tAircraft Type\t03\t\nFighter\tMilitary Aircraft Type\t04\t\nInterceptor\tMilitary Aircraft Type\t05\tAPP-6\nTanker\tAircraft Type\t06\t\nUtility\tAircraft Type\t07\t\nVertical or Short Take-off and Landing (VSTOL)/ Vertical Take-off and Landing (VTOL)\tAircraft Type\t08\t\nPassenger\tAircraft Type\t09\t\nUltra Light\tAircraft Type\t10\t\nAirborne Command Post (ACP)\tMilitary Aircraft Type\t11\t\nAirborne Early Warning (AEW)\tMilitary Aircraft Type\t12\t\nGovernment\tAircraft Type\t13\t\nMedical Evacuation (MEDEVAC)\tMission Area\t14\t\nEscort\tMilitary Mission Area\t15\t\nElectronic Combat (EC)/Jammer\tMilitary Mission Area\t16\t\nPatrol\tMission Area\t17\t\nReconnaissance\tMission Area\t18\t\nTrainer\tMission Area\t19\t\nPhotographic (Reconnaissance)\tMission Area\t20\t\nPersonnel Recovery \tMission Area\t21\t\nAntisubmarine Warfare\tMilitary Mission Area\t22\t\nCommunications\tMission Area\t23\t\nElectronic Support (ES)\tMilitary Mission Area\t24\t\nMine Countermeasures (MCM)\tMilitary Mission Area\t25\t\nSearch and Rescue\tMission Area\t26\t\nSpecial Operations Forces\tMilitary Mission Area\t27\t\nSurface Warfare\tMilitary Mission Area\t28\t\nVery Important Person (VIP) Transport\tMission Area\t29\t\nCombat Search and Rescue (CSAR)\tMilitary Mission Area\t30\t\nSuppression of Enemy Air Defenses\tMilitary Mission Area\t31\tAPP-6\nAntisurface Warfare\tMilitary Mission Area\t32\t\nFighter/Bomber\tMilitary Aircraft Type\t33\t\nIntensive Care\tMission Area\t34\t\nElectronic Attack (EA)\tMilitary Mission Area\t35\t\nMulti-Mission\tMission Area\t36\t\nHijacking/Hijacked\tCrime\t37\t\nASW Helo- LAMPS\tMission Area\t38\tMust be paired in conjunction with rotary wing icon\nASW Helo – SH-60R\tMission Area\t39\tMust be paired in conjunction with rotary wing icon\nHijacker\tCrime\t40\t\nCyberspace\tCapability\t41\t\n{Reserved for future use}\t\t42-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_air_m2 = "Second Modifier\tCategory\tCode\tRemarks\nNot Applicable\t\t00\t\nHeavy\tCargo/Transport Capacity\t01\t\nMedium\tCargo/Transport Capacity\t02\t\nLight\tCargo/Transport Capacity\t03\t\nBoom–Only\tRe-Fueling Capability\t04\tUsed with TANKER only.\nDrogue–Only\tRe-Fueling Capability\t05\tUsed with TANKER only.\nBoom and Drogue\tRe-Fueling Capability\t06\tUsed with TANKER only.\nClose Range\tRange\t07\t\nShort Range\tRange\t08\t\nMedium Range\tRange\t09\t\nLong Range\tRange\t10\t\nDownlinked\tTrack Link Availability\t11\t\nCyberspace\tCapability\t12\t\n{Reserved for future use}\t\t13-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_air_missile_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\r\nUnspecified\t\t\t000000\t\r\nMissile\t\t\t110000\t\r\n";

  var mil_std_2525d_air_missile_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAir\tLaunch Origin\t01\t\nSurface\tLaunch Origin\t02\t\nSubsurface\tLaunch Origin\t03\t\nSpace\tLaunch Origin\t04\t\nAnti–Ballistic\tMissile Class\t05\t\nBallistic\tMissile Class\t06\t\nCruise\tMissile Class\t07\t\nInterceptor\tMissile Class\t08\t\n{Reserved for future use}\t\t09-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_air_missile_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAir\tMissile Destination\t01\t\nSurface\tMissile Destination\t02\t\nSubsurface\tMissile Destination\t03\t\nSpace\tMissile Destination\t04\t\nLaunched\tMissile Status\t05\t\nMissile\tMissile Status\t06\t\nPatriot\tMissile Type-BMD\t07\tUsed with INTERCEPTOR modifier 1 only.\nStandard Missile-2 (SM-2)\tMissile Type-AAW\t08\tUsed with INTERCEPTOR modifier 1 only.\nStandard Missile-6 (SM-6)\tMissile Type-AAW\t09\tUsed with INTERCEPTOR modifier 1 only.\nEvolved Sea Sparrow Missile (ESSM)\tMissile Type-AAW\t10\tUsed with INTERCEPTOR modifier 1 only.\nRolling Airframe Missile (RAM)\tMissile Type-AAW\t11\tUsed with INTERCEPTOR modifier 1 only.\nShort Range\tMissile Range\t12\t1000km or less.\nMedium Range\tMissile Range\t13\t1000km to 3500km. Typically used in reference to surface-to-air missile\nIntermediate Range\tMissile Range\t14\t1000km to 3500km. Typically used in reference to ballistic missile\nLong Range\tMissile Range\t15\t3500km to 5500km.\nIntercontinental\tMissile Range\t16\t5500km or greater.\n{Reserved for future use}\t\t17-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_space_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nMilitary\t\t\t110000\tReserved for hierarchical purposes.\n\tSpace Vehicle\t\t110100\t\n\tRe–Entry Vehicle\t\t110200\t\n\tPlanet Lander\t\t110300\t\n\tOrbiter Shuttle\t\t110400\t\n\tCapsule\t\t110500\t\n\tSatellite, General\t\t110600\tAPP-6\n\tSatellite\t\t110700\t\n\tAntisatellite Weapon\t\t110800\t\n\tAstronomical Satellite\t\t110900\t\n\tBiosatellite\t\t111000\t\n\tCommunications Satellite\t\t111100\t\n\tEarth Observation Satellite\t\t111200\t\n\tMiniaturized Satellite\t\t111300\t\n\tNavigational Satellite\t\t111400\t\n\tReconnaissance Satellite\t\t111500\t\n\tSpace Station\t\t111600\t\n\tTethered Satellite\t\t111700\t\n\tWeather Satellite\t\t111800\t\n\tSpace Launched Vehicle (SLV)\t\t111900\t\nCivilian\t\t\t120000\tReserved for hierarchical purposes.\n\tOrbiter Shuttle\t\t120100\t\n\tCapsule\t\t120200\t\n\tSatellite\t\t120300\t\n\tAstronomical Satellite\t\t120400\t\n\tBiosatellite\t\t120500\t\n\tCommunications Satellite\t\t120600\t\n\tEarth Observation Satellite\t\t120700\t\n\tMiniaturized Satellite\t\t120800\t\n\tNavigational Satellite\t\t120900\t\n\tSpace Station\t\t121000\t\n\tTethered Satellite\t\t121100\t\n\tWeather Satellite\t\t121200\t\nManual Track\t\t\t130000\t";

  var mil_std_2525d_space_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nLow Earth Orbit (LEO)\tOrbit\t01\t\nMedium Earth Orbit  (MEO)\tOrbit\t02\t\nHigh Earth Orbit  (HEO)\tOrbit\t03\t\nGeosynchronous Orbit (GSO)\tOrbit\t04\t\nGeostationary Orbit (GO)\tOrbit\t05\t\nMolniya Orbit (MO)\tOrbit\t06\t\nCyberspace\tCapability\t07\t\n{Reserved for future use}\t\t08-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_space_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\tOnly used with satellite icons.\nOptical\tSensor\t01\tOnly used with satellite icons.\nInfrared\tSensor\t02\tOnly used with satellite icons.\nRadar\tSensor\t03\tOnly used with satellite icons.\nSignals Intelligence (SIGINT)\tSensor\t04\tOnly used with satellite icons.\nCyberspace\tCapability\t05\t\n{Reserved for future use}\t\t06-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_space_missile_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\r\nUnspecified\t\t\t000000\t\r\nMissile\t\t\t110000\t";

  var mil_std_2525d_space_missile_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nBallistic\tMissile Class\t01\t\nSpace\tLaunch Origin\t02\t\nInterceptor\tMissile Class\t03\t\n{Reserved for future use}\t\t04-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_space_missile_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nShort Range\tMissile Range\t01\t1000km or less.\nMedium Range\tMissile Range\t02\t1000km to 3500km.\nIntermediate Range\tMissile Range\t03\t1000km to 3500km.\nLong Range\tMissile Range\t04\t3500km to 5500km.\nIntercontinental \tMissile Range\t05\t5500km or greater.\nArrow\tMissile Type-BMD\t06\tUsed with INTERCEPTOR modifier 1 only.\nGround-Based Interceptor (GBI)\tMissile Type-BMD\t07\tUsed with INTERCEPTOR modifier 1 only.\nPatriot\tMissile Type-BMD\t08\tUsed with INTERCEPTOR modifier 1 only.\nStandard Missile Terminal Phase (SM-T)\tMissile Type-BMD\t09\tUsed with INTERCEPTOR modifier 1 only.\nStandard Missile – 3 (SM-3)\tMissile Type-BMD\t10\tUsed with INTERCEPTOR modifier 1 only.\nTerminal High Altitude Area Defense (THAAD)\tMissile Type-BMD\t11\tUsed with INTERCEPTOR modifier 1 only.\nSpace\tLaunch Origin\t12\t\nClose Range (CRBM)\tMissile Range\t13\t\nDebris\tMissile Type-BMD\t14\t\nUnknown\tMissile Type-BMD\t15\t\n{Reserved for future use}\t\t16-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_unit_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nCommand and Control\t\t\t110000\tReserved for Amplifier field {AA} only. \n\tBroadcast Transmitter Antennae\t\t110100\t\n\tCivil Affairs \t\t110200\t\n\tCivil–Military Cooperation \t\t110300\t\n\tInformation Operations\t\t110400\t\n\tLiaison\t\t110500\t\n\tMilitary Information Support Operations (MISO)\t\t110600\t\n\t\tBroadcast Transmitter Antennae\t110601\t\n\tRadio\t\t110700\t\n\tRadio Relay\t\t110800\t\n\tRadio Teletype Center\t\t110900\t\n\tSignal\t\t111000\t\n\t\tRadio\t111001\t\n\t\tRadio Relay\t111002\t\n\t\tTeletype\t111003\t\n\t\tTactical Satellite\t111004\t\n\t\tVideo Imagery (Combat Camera)\t111005\t\n\tTactical Satellite\t\t111100\t\n\tVideo Imagery (Combat Camera)\t\t111200\t\n\tSpace\t\t111300\t\n\tSpecial Troops\t\t111400\t\nMovement and Maneuver\t\t\t120000\tReserved for hierarchical purposes.\n\tAir Assault with Organic Lift\t\t120100\t\n\tAir Traffic Services/Airfield Operations\t\t120200\t\n\t{Reserved for future use}\t\t120300\t\n\tAntitank/Antiarmor\t\t120400\t\n\t\tArmored\t120401\t\n\t\tMotorized\t120402\t\n\tArmor/Armored/Mechanized/Self–Propelled/ Tracked\t\t120500\t\n\t\tReconnaissance/Cavalry/Scout\t120501\t\n\t\tAmphibious\t120502\t\n\tArmy Aviation/Aviation Rotary Wing\t\t120600\t\n\t\tReconnaissance\t120601\t\n\tAviation Composite\t\t120700\t\n\tAviation Fixed Wing\t\t120800\t\n\t\tReconnaissance\t120801\t\n\tCombat\t\t120900\t\n\tCombined Arms\t\t121000\t\n\tInfantry\t\t121100\t\n\t\tAmphibious\t121101\t\n\t\tArmored/Mechanized/Tracked\t121102\t\n\t\tMain Gun System \t121103\t\n\t\tMotorized \t121104\t\n\t\tInfantry Fighting Vehicle\t121105\t\n\tObserver\t\t121200\t\n\tReconnaissance/Cavalry/Scout\t\t121300\t\n\t\tReconnaissance and Surveillance\t121301\t\n\t\tMarine\t121302\t\n\t\tMotorized\t121303\t\n\tSea Air Land (SEAL)\t\t121400\t\n\tSniper\t\t121500\t\n\tSurveillance\t\t121600\t\n\tSpecial Forces\t\t121700\t\n\tSpecial Operations Forces (SOF)\t\t121800\t\n\t\tFixed Wing MISO\t121801\t\n\t\tGround\t121802\t\n\t\tSpecial Boat\t121803\t\n\t\tSpecial SSNR\t121804\t\n\t\tUnderwater Demolition Team\t121805\t\n\tUnmanned Aerial Systems\t\t121900\t\n\tRanger\t\t122000\t\nFires\t\t\t130000\tReserved for hierarchical purposes.\n\tAir Defense\t\t130100\t\n\t\tMain Gun System\t130101\t\n\t\tMissile\t130102\t\n\t\tAir and Missile Defense\t130103\t\n\tAir/Land Naval Gunfire Liaison\t\t130200\t\n\tField Artillery\t\t130300\t\n\t\tSelf–propelled\t130301\t\n\t\tTarget Acquisition\t130302\t\n\tField Artillery Observer\t\t130400\t\n\tJoint Fire Support\t\t130500\t\n\tMeteorological\t\t130600\t\n\tMissile\t\t130700\t\n\tMortar\t\t130800\t\n\t\tArmored/Mechanized/Tracked\t130801\t\n\t\tSelf-Propelled Wheeled\t130802\t\n\t\tTowed\t130803\t\n\tSurvey\t\t130900\t\nProtection\t\t\t140000\tReserved for hierarchical purposes.\n\tChemical Biological Radiological Nuclear Defense\t\t140100\t\n\t\tMechanized\t140101\t\n\t\tMotorized\t140102\t\n\t\tReconnaissance\t140103\t\n\t\tReconnaissance Armored\t140104\t\n\t\tReconnaissance Equipped\t140105\t\n\t\tChemical, Biological, Radiological, Nuclear, and High-Yield Explosives\t140106\t\n\tCombat Support (Maneuver Enhancement)\t\t140200\t\n\tCriminal Investigation Division\t\t140300\t\n\tDiving\t\t140400\t\n\tDog\t\t140500\t\n\tDrilling\t\t140600\t\n\tEngineer\t\t140700\t\n\t\tMechanized\t140701\t\n\t\tMotorized\t140702\t\n\t\tReconnaissance\t140703\t\n\tExplosive Ordnance Disposal (EOD)\t\t140800\t\n\tField Camp Construction\t\t140900\t\n\tFire Fighting/Fire Protection\t\t141000\t\n\tGeospatial Support/Geospatial Information Support\t\t141100\t\n\tMilitary Police\t\t141200\t\n\tMine\t\t141300\t\n\tMine Clearing\t\t141400\t\n\tMine Launching\t\t141500\t\n\tMine Laying\t\t141600\t\n\tSecurity\t\t141700\t\n\t\tMechanized\t141701\t\n\t\tMotorized\t141702\t\n\tSearch and Rescue\t\t141800\t\n\tSecurity Police (Air)\t\t141900\t\n\tShore Patrol\t\t142000\t\n\tTopographic/Geospatial\t\t142100\t\n\tMissile Defense\t\t142200\t\nIntelligence\t\t\t150000\tReserved for hierarchical purposes.\n\tAnalysis\t\t150100\t\n\tCounterintelligence\t\t150200\t\n\tDirection Finding\t\t150300\t\n\tElectronic Ranging\t\t150400\t\n\tElectronic Warfare\t\t150500\t\n\t\tAnalysis\t150501\t\n\t\tDirection Finding\t150502\t\n\t\tIntercept\t150503\t\n\t\tJamming\t150504\t\n\t\tSearch\t150505\t\n\tIntercept (Search and Recording)\t\t150600\t\n\tInterrogation\t\t150700\t\n\tJamming\t\t150800\t\n\tJoint Intelligence Center\t\t150900\t\n\tMilitary Intelligence\t\t151000\t\n\tSearch\t\t151100\t\n\tSensor\t\t151200\t\n\tMilitary History\t\t151300\t\nSustainment\t\t\t160000\t\n\tAdministrative\t\t160100\t\n\tAll Classes of Supply\t\t160200\t\n\tAirport of Debarkation/Airport of Embarkation \t\t160300\t\n\tAmmunition\t\t160400\t\n\tBand\t\t160500\t\n\t\tArmy Music\t160501\t\n\tCombat Service Support\t\t160600\t\n\tFinance\t\t160700\t\n\tJudge Advocate General\t\t160800\t\n\tLabor\t\t160900\t\n\tLaundry/Bath\t\t161000\t\n\tMaintenance\t\t161100\t\n\tMaterial\t\t161200\t\n\tMedical\t\t161300\t\n\tMedical Treatment Facility\t\t161400\t\n\tMorale, Welfare and Recreation\t\t161500\t\n\tMortuary Affairs\t\t161600\t\n\tMultiple Classes of Supply\t\t161700\t\n\tNATO Supply Class I\t\t161800\t\n\t{Reserved for future use}\t\t161900\t\n\tNATO Supply Class III\t\t162000\t\n\tNATO Supply Class IV\t\t162100\t\n\t{Reserved for future use}\t\t162200\t\n\tOrdnance\t\t162300\t\n\tPersonnel Services\t\t162400\t\n\tPetroleum, Oil and Lubricants\t\t162500\t\n\t{Reserved for future use}\t\t162600\t\n\t{Reserved for future use}\t\t162700\t\n\tPublic Affairs/Public Information\t\t162800\t\n\tQuartermaster\t\t162900\t\n\tRailhead\t\t163000\t\n\tReligious Support\t\t163100\t\n\tReplacement Holding Unit\t\t163200\t\n\tSea Port of Debarkation/Sea Port of Embarkation \t\t163300\t\n\t{Reserved for future use}\t\t163400\t\n\tJoint Information Bureau (JIB)\t\t163500\t\n\tTransportation\t\t163600\t\n\t\tFloating Craft\t163601\t\n\tUS Supply Class I\t\t163700\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\t{Reserved for future use}\t\t163800\t\n\t{Reserved for future use}\t\t163900\t\n\tUS Supply Class IV\t\t164000\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\t{Reserved for future use}\t\t164100\t\n\tUS Supply Class VI\t\t164200\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\tUS Supply Class VII\t\t164300\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\tUS Supply Class VIII\t\t164400\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\tUS Supply Class IX\t\t164500\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\tUS Supply Class X\t\t164600\tReferenced in STANAG 2961 Classes of Supply of NATO Land Forces\n\t{Reserved for future use}\t\t164700\t\n\tWater Purification\t\t164800\t\n\tBroadcast\t\t164900\t\n\tNATO Supply Class - ALL\t\t165000\tNATO Only\n\tInterpreter/Translator\t\t165100\t\n\tSupport\t\t165200\t\n\tArmy Field Support\t\t165300\t\n\tContracting Services\t\t165400\t\n\tParachute Rigger\t\t165500\t\nNaval \t\t\t170000\tReserved for hierarchical purposes.\n\tNaval\t\t170100\t\nNamed Headquarters\t\t\t180000\tReserved for hierarchical purposes.\n\tAllied Command Europe Rapid Reaction Corps (ARRC)\t\t180100\t\n\tAllied Command Operations\t\t180200\t\n\tInternational Security Assistance Force (ISAF)\t\t180300\t\n\tMultinational (MN)\t\t180400\t\nEmergency Operation\t\t\t190000\t\nLaw Enforcement\t\t\t200000\t\n\tBureau of Alcohol, Tobacco, Firearms and Explosives (ATF) (Department of Justice)\t\t200100\t\n\tBorder Patrol\t\t200200\t\n\tCustoms Service\t\t200300\t\n\tDrug Enforcement Administration (DEA)\t\t200400\t\n\tDepartment of Justice (DOJ)\t\t200500\t\n\tFederal Bureau of Investigation (FBI)\t\t200600\t\n\tPolice\t\t200700\t\n\tPrison\t\t200800\t\n\tUnited States Secret Service (Treas) (USSS)\t\t200900\t\n\tTransportation Security Administration (TSA)\t\t201000\t\n\tCoast Guard\t\t201100\t\n\tUS Marshals Service\t\t201200\t\n\tInternal Security Force\t\t201300\t";

  var mil_std_2525d_land_unit_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nTactical Satellite Communications\tCapability\t01\t\nArea\tCapability\t02\t\nAttack\tCapability\t03\t\nBiological\tCapability\t04\t\nBorder\tCapability\t05\t\nBridging\tCapability\t06\t\nChemical\tCapability\t07\t\nClose Protection\tCapability\t08\t\nCombat\tCapability\t09\t\nCommand and Control\tCapability\t10\t\nCommunications Contingency Package\tCapability\t11\t\nConstruction\tCapability\t12\t\nCross Cultural Communication\tCapability\t13\t\nCrowd and Riot Control\tCapability\t14\t\nDecontamination\tCapability\t15\t\nDetention\tCapability\t16\t\nDirect Communications\tCapability\t17\t\nDiving\tCapability\t18\t\nDivision\tCapability\t19\t\nDog\tCapability\t20\t\nDrilling\tCapability\t21\t\nElectro–Optical\tCapability\t22\t\nEnhanced\tCapability\t23\t\nExplosive Ordnance Disposal (EOD)\tCapability\t24\t\nFire Direction Center\tCapability\t25\t\nForce\tCapability\t26\t\nForward\tCapability\t27\t\nGround Station Module\tCapability\t28\t\nLanding Support\tCapability\t29\t\n{Reserved for future use}\t\t30\t\nMaintenance\tCapability\t31\t\nMeteorological\tCapability\t32\t\nMine Countermeasure\tCapability\t33\t\nMissile\tCapability\t34\t\nMobile Advisor and Support\tCapability\t35\t\nMobile Subscriber Equipment\tCapability\t36\t\nMobility Support\tCapability\t37\t\n{Reserved for future use}\t\t38\t\nMultinational\tCapability\t39\t\nMultinational Specialized Unit\tCapability\t40\t\nMultiple Rocket Launcher\tCapability\t41\t\nNATO Medical Role 1\tCapability\t42\tModifier is offset so that the modifier is not compromised by the main sector icon.\nNATO Medical Role 2\tCapability\t43\tModifier is offset so that the modifier is not compromised by the main sector icon.\nNATO Medical Role 3\tCapability\t44\tModifier is offset so that the modifier is not compromised by the main sector icon.\nNATO Medical Role 4\tCapability\t45\tModifier is offset so that the modifier is not compromised by the main sector icon.\nNaval\tCapability\t46\t\nUnmanned Aerial Systems (UAS)\tCapability\t47\t\nNuclear\tCapability\t48\t\nOperations\tCapability\t49\t\nRadar\tCapability\t50\t\nRadio Frequency Identification (RFID) Interrogator / Sensor\tCapability\t51\t\nRadiological\tCapability\t52\t\nSearch and Rescue\tCapability\t53\t\nSecurity\tCapability\t54\t\nSensor\tCapability\t55\t\nWeapons\tCapability\t56\t\nSignals Intelligence\tCapability\t57\t\nArmored\tCapability\t58\t\nSingle Rocket Launcher\tCapability\t59\t\nSmoke\tCapability\t60\t\nSniper\tCapability\t61\t\nSound Ranging\tCapability\t62\t\nSpecial Operations Forces (SOF)\tCapability\t63\t\nSpecial Weapons and Tactics\tCapability\t64\t\nSurvey\tCapability\t65\t\nTactical Exploitation\tCapability\t66\t\nTarget Acquisition\tCapability\t67\t\nTopographic/Geospatial\tCapability\t68\t\nUtility\tCapability\t69\t\nVideo Imagery (Combat Camera)\tCapability\t70\t\nMobility Assault\tCapability\t71\t\nAmphibious Warfare Ship\tCapability\t72\t\nLoad Handling System\tCapability\t73\t\nPalletized Load System\tCapability\t74\t\nMedevac\tCapability\t75\t\nRanger\tCapability\t76\t\nSupport\tCapability\t77\t\nAviation\tCapability\t78\t\nRoute, Reconnaissance, and Clearance\tCapability\t79\t\nTilt-Rotor\tCapability\t80\t\nCommand Post Node\tCapability\t81\t\nJoint Network Node\tCapability\t82\t\nRetransmission Site\tCapability\t83\t\nAssault\tCapability\t84\t\nWeapons\tCapability\t85\t\nCriminal Investigation Division\tCapability\t86\t\nDigital\tCapability\t87\t\nNetwork or Network Operations\tCapability\t88\t\nAirfield, Aerial Port of Debarkation, or Aerial Port of Embarkation\tCapability\t89\t\nPipeline\tCapability\t90\t\nPostal\tCapability\t91\t\nWater\tCapability\t92\t\nIndependent Command\tCapability\t93\t\nTheater\tCapability\t94\t\nArmy or Theater Army\tCapability\t95\t\nCorps\tCapability\t96\t\nBrigade\tCapability\t97\t\nHeadquarters or headquarters staff element\tCapability\t98\t\n{Reserved for future use}\t\t99\t\nVersion Extension Flag\t\t-\t\n";

  var mil_std_2525d_land_unit_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAirborne\tMobility\t01\t\nArctic\tMobility\t02\t\nBattle Damage Repair\tCapability\t03\t\nBicycle Equipped\tMobility\t04\t\nCasualty Staging\tCapability\t05\tModifier is offset so that the modifier is not compromised by the main sector icon.\nClearing\tCapability\t06\t\nClose Range\tCapability\t07\t\nControl\tCapability\t08\t\nDecontamination\tCapability\t09\t\nDemolition\tCapability\t10\t\nDental\tCapability\t11\tModifier is offset so that the modifier is not compromised by the main sector icon.\nDigital\tCapability\t12\t\nEnhanced Position Location Reporting System (EPLRS)\tCapability\t13\t\nEquipment\tCapability\t14\tAPP6\nHeavy\tCapability\t15\t\nHigh Altitude\tCapability\t16\t\nIntermodal\tCapability\t17\t\nIntensive Care\tCapability\t18\tModifier is offset so that the modifier is not compromised by the main sector icon.\nLight\tCapability\t19\t\nLaboratory\tCapability\t20\t\nLauncher\tCapability\t21\t\nLong Range\tCapability\t22\t\nLow Altitude\tCapability\t23\t\nMedium\tCapability\t24\t\nMedium Altitude\tCapability\t25\t\nMedium Range\tCapability\t26\t\nMountain\tCapability\t27\t\nHigh to Medium Altitude\tCapability\t28\t\nMulti–Channel\tCapability\t29\t\nOptical (Flash)\tCapability\t30\t\nPack Animal\tCapability\t31\t\nPatient Evacuation Coordination\tCapability\t32\tModifier is offset so that the modifier is not compromised by the main sector icon.\nPreventive Maintenance\tCapability\t33\t\nPsychological\tCapability\t34\tModifier is offset so that the modifier is not compromised by the main sector icon.\nRadio Relay Line of Sight\tCapability\t35\t\nRailroad\tMobility\t36\t\nRecovery (Unmanned Systems)\tCapability\t37\t\nRecovery (Maintenance)\tCapability\t38\t\nRescue Coordination Center\tCapability\t39\tModifier is offset so that the modifier is not compromised by the main sector icon.\nRiverine\tMobility\t40\t\nSingle Channel\tCapability\t41\t\nSki\tCapability\t42\t\nShort Range\tCapability\t43\t\nStrategic\tCapability\t44\t\nSupport\tCapability\t45\t\nTactical\tCapability\t46\t\nTowed\tMobility\t47\t\nTroop\tCapability\t48\t\nVertical or Short Take–Off and Landing (VTOL/VSTOL)\tMobility\t49\t\nVeterinary\tCapability\t50\tModifier is offset so that the modifier is not compromised by the main sector icon.\nWheeled\tMobility\t51\t\nHigh to Low Altitude\tCapability\t52\t\nMedium to Low Altitude\tCapability\t53\t\nAttack\tCapability\t54\t\nRefuel\tCapability\t55\t\nUtility\tCapability\t56\t\nCombat Search and Rescue\tCapability\t57\t\nGuerilla\tCapability\t58\t\nAir Assault\tMobility\t59\t\nAmphibious\tMobility\t60\t\nVery Heavy\tCapability\t61\t\nSupply\tCapability\t62\t\nCyberspace\tCapability\t63\t\nNavy Barge, Self-Propelled\tMobility\t64\t\nNavy Barge, Not Self-Propelled\tMobility\t65\t\nLaunch\tMobility\t66\t\nLanding Craft\tMobility\t67\t\nLanding Ship\tMobility\t68\t\nService Craft/Yard\tMobility\t69\t\nTug Harbor\tMobility\t70\t\nOcean Going Tug Boat\tMobility\t71\t\nSurface Deployment and Distribution Command\tCapability\t72\t\nNoncombatant Generic Vessel\tMobility\t73\t\nComposite\tCapability\t74\t\nShelter\tCapability\t75\t\nLight and Medium\tCapability\t76\t\nTracked\tMobility\t77\t\nSecurity Force Assistance\tCapability\t78\t\n{Reserved for future use}\t\t79-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_civilian_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nCivilian\t\t\t110000\tReserved for hierarchical purposes.\n\tEnvironmental Protection\t\t110100\t\n\tGovernmental Organization\t\t110200\t\n\tIndividual\t\t110300\t\n\tOrganization or Group\t\t110400\t\n\tKilling Victim\t\t110500\t\n\tKilling Victims\t\t110600\t\n\tVictim of an Attempted Crime\t\t110700\t\n\tSpy\t\t110800\t\n\tComposite Loss\t\t110900\t\n\tEmergency Medical Operation\t\t111000\t";

  var mil_std_2525d_land_civilian_m1 = "First Modifier\tCapability\tCode\tRemarks\nUnspecified\t\t00\t\nAssassination\tCrime\t01\t\nExecution (Wrongful Killing)\tCrime\t02\t\nMurder Victims\tCrime\t03\t\nHijacking/Hijacked\tCrime\t04\t\nKidnapping\tCrime\t05\t\nPiracy\tCrime\t06\t\nRape\tCrime\t07\t\nCivilian\tOrganization\t08\t\nDisplaced Person(s), Refugee(s) and Evacuee(s)\tOrganization\t09\t\nForeign Fighter(s)\tOrganization\t10\t\nGang Member or Gang\tOrganization\t11\t\nGovernment Organization\tOrganization\t12\t\nLeader or Leadership\tOrganization\t13\t\nNongovernmental Organization Member or Nongovernmental Organization\tOrganization\t14\t\nUnwilling/Coerced Recruit\tOrganization\t15\t\nWilling Recruit\tOrganization\t16\t\nReligious or Religious Organization\tOrganization\t17\t\nTargeted Individual or Organization\tOrganization\t18\t\nTerrorist or Terrorist Organization\tOrganization\t19\t\nSpeaker\tOrganization\t20\t\nAccident\tComposite Loss\t21\t\nCombat\tComposite Loss\t22\t\nOther\tComposite Loss\t23\t\nLoot\tCrime\t24\t\nHijacker\tCrime\t25\t\nCyberspace\tCapability\t26\t\n{Reserved for future use}\t\t27-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_civilian_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nLeader or Leadership\tOrganization\t01\t\nCyberspace\tCapability\t02\t\n{Reserved for future use}\t\t03-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_equipment_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nWeapon/Weapon System\t\t\t110000\tReserved for hierarchical purposes.\n\tRifle\t\t110100\t\n\t\tSingle Shot Rifle\t110101\t\n\t\tSemiautomatic Rifle\t110102\t\n\t\tAutomatic Rifle\t110103\t\n\tMachine Gun\t\t110200\t\n\t\tLight \t110201\t\n\t\tMedium \t110202\t\n\t\tHeavy\t110203\t\n\tGrenade Launcher\t\t110300\t\n\t\tLight\t110301\t\n\t\tMedium\t110302\t\n\t\tHeavy\t110303\t\n\tFlame Thrower\t\t110400\t\n\tAir Defense Gun\t\t110500\t\n\t\tLight\t110501\t\n\t\tMedium\t110502\t\n\t\tHeavy\t110503\t\n\tAntitank Gun\t\t110600\t\n\t\tLight\t110601\t\n\t\tMedium\t110602\t\n\t\tHeavy\t110603\t\n\tDirect Fire Gun\t\t110700\t\n\t\tLight\t110701\t\n\t\tMedium\t110702\t\n\t\tHeavy\t110703\t\n\tRecoilless Gun\t\t110800\t\n\t\tLight\t110801\t\n\t\tMedium\t110802\t\n\t\tHeavy\t110803\t\n\tHowitzer\t\t110900\t\n\t\tLight\t110901\t\n\t\tMedium\t110902\t\n\t\tHeavy\t110903\t\n\tMissile Launcher\t\t111000\t\n\t\tLight\t111001\t\n\t\tMedium\t111002\t\n\t\tHeavy\t111003\t\n\tAir Defense Missile Launcher\t\t111100\t\n\t\tLight\t111101\t\n\t\tLight, Light Transporter-Launcher and Radar (TLAR)\t111102\t\n\t\tLight, Light Tactical Landing Approach Radar (TELAR)\t111103\t\n\t\tMedium\t111104\t\n\t\tMedium, TLAR\t111105\t\n\t\tMedium, TELAR\t111106\t\n\t\tHeavy\t111107\t\n\t\tHeavy, TLAR\t111108\t\n\t\tHeavy, TELAR\t111109\t\n\tAntitank Missile Launcher\t\t111200\t\n\t\tLight\t111201\t\n\t\tMedium\t111202\t\n\t\tHeavy\t111203\t\n\tSurface-to-Surface Missile Launcher\t\t111300\t\n\t\tLight\t111301\t\n\t\tMedium\t111302\t\n\t\tHeavy\t111303\t\n\tMortar\t\t111400\t\n\t\tLight\t111401\t\n\t\tMedium\t111402\t\n\t\tHeavy\t111403\t\n\tSingle Rocket Launcher\t\t111500\t\n\t\tLight\t111501\t\n\t\tMedium\t111502\t\n\t\tHeavy\t111503\t\n\tMultiple Rocket Launcher\t\t111600\t\n\t\tLight\t111601\t\n\t\tMedium\t111602\t\n\t\tHeavy\t111603\t\n\tAntitank Rocket Launcher\t\t111700\t\n\t\tLight\t111701\t\n\t\tMedium\t111702\t\n\t\tHeavy\t111703\t\n\tNonlethal Weapon\t\t111800\t\n\tTaser\t\t111900\t\n\tWater Cannon\t\t112000\t\nVehicle\t\t\t120000\tReserved for hierarchical purposes.\n\tArmored\t\t120100\t\n\t\tArmored Fighting Vehicle\t120101\t\n\t\tArmored Fighting Vehicle Command and Control\t120102\t\n\t\tArmored Personnel Carrier\t120103\t\n\t\tArmored Personnel Carrier Ambulance\t120104\t\n\t\tArmored Protected Vehicle\t120105\t\n\t\tArmored Protected Vehicle Recovery\t120106\t\n\t\tArmored Protected Vehicle Medical Evacuation\t120107\t\n\t\tArmored Personnel Carrier, Recovery\t120108\t\n\t\tCombat Service Support Vehicle\t120109\t\n\t\tLight Wheeled Armored Vehicle\t120110\t\n\t\tLight Armor Reconnaissance\t120111\t\n\tTank\t\t120200\t\n\t\tLight\t120201\t\n\t\tMedium\t120202\t\n\t\tHeavy\t120203\t\n\tTank Recovery Vehicle\t\t120300\t\n\t\tLight\t120301\t\n\t\tMedium\t120302\t\n\t\tHeavy\t120303\t\nEngineer Vehicle and Equipment\t\t\t130000\t\n\tBridge\t\t130100\t\n\tBridge Mounted on Utility Vehicle\t\t130200\t\n\tFixed Bridge\t\t130300\t\n\tFloating Bridge\t\t130400\t\n\tFolding Girder Bridge\t\t130500\t\n\tHollow Deck Bridge\t\t130600\t\n\tDrill\t\t130700\t\n\t\tDrill Mounted on Utility Vehicle\t130701\t\n\tEarthmover\t\t130800\t\n\t\tMultifunctional Earthmover/Digger\t130801\t\n\tMine Clearing Equipment\t\t130900\t\n\t\tTrailer Mounted\t130901\t\n\t\tMine Clearing Equipment on Tank Chassis\t130902\t\n\t\tAssault Breacher Vehicle (ABV) with Combat Dozer Blade\t130903\t\n\t\tMedium Capability Equipment \t130904\t\n\t\tHeavy Capability Equipment\t130905\t\n\tMine Laying Equipment\t\t131000\t\n\t\tMine Laying Equipment on Utility Vehicle\t131001\t\n\t\tArmored Carrier with Volcano\t131002\t\n\t\tTruck Mounted with Volcano\t131003\t\n\tDozer\t\t131100\t\n\t\tDozer, Armored\t131101\t\n\tArmored Assault\t\t131200\t\n\tArmored Engineer Recon Vehicle (AERV)\t\t131300\t\n\tBackhoe\t\t131400\t\n\tConstruction Vehicle\t\t131500\t\n\tFerry Transporter\t\t131600\t\nUtility Vehicle\t\t\t140000\tReserved for hierarchical purposes.\n\tVehicle (Generic)\t\t140100\t\n\tMedical\t\t140200\t\n\tMedical Evacuation\t\t140300\t\n\tMobile Emergency Physician\t\t140400\t\n\tBus\t\t140500\t\n\tSemi–Trailer and Truck\t\t140600\t\n\t\tLight\t140601\t\n\t\tMedium\t140602\t\n\t\tHeavy\t140603\t\n\tLimited Cross Country Truck\t\t140700\t\n\tCross Country Truck\t\t140800\t\n\tPetroleum, Oil and Lubricant\t\t140900\t\n\tWater\t\t141000\t\n\tAmphibious Utility Wheeled Vehicle\t\t141100\t\n\tTow Truck\t\t141200\t\n\t\tLight\t141201\t\n\t\tHeavy\t141202\t\nTrain\t\t\t150000\tReserved for hierarchical purposes.\n\tLocomotive\t\t150100\t\n\tRailcar\t\t150200\t\nCivilian Vehicle\t\t\t160000\tReserved for hierarchical purposes.\n\tAutomobile\t\t160100\t\n\t\tCompact\t160101\t\n\t\tMidsize\t160102\t\n\t\tSedan\t160103\t\n\tOpen-Bed Truck\t\t160200\t\n\t\tPickup\t160201\t\n\t\tSmall\t160202\t\n\t\tLarge\t160203\t\n\tMultiple Passenger Vehicle\t\t160300\t\n\t\tVan\t160301\t\n\t\tSmall Bus\t160302\t\n\t\tLarge Bus\t160303\t\n\tUtility Vehicle\t\t160400\t\n\t\tSport Utility Vehicle (SUV)\t160401\t\n\t\tSmall Box Truck\t160402\t\n\t\tLarge Box Truck\t160403\t\n\tJeep Type Vehicle\t\t160500\t\n\t\tSmall/Light\t160501\t\n\t\tMedium\t160502\t\n\t\tLarge/Heavy\t160503\t\n\tTractor Trailer Truck with Box\t\t160600\t\n\t\tSmall/Light\t160601\t\n\t\tMedium\t160602\t\n\t\tLarge/Heavy\t160603\t\n\tTractor Trailer Truck with Flatbed Trailer\t\t160700\t\n\t\tSmall/Light\t160701\t\n\t\tMedium\t160702\t\n\t\tLarge/Heavy\t160703\t\n\tKnown Insurgent Vehicle\t\t160800\t\n\tDrug Vehicle\t\t160900\t\nLaw Enforcement\t\t\t170000\t\n\tBureau of Alcohol, Tobacco, Firearms and Explosives (ATF) (Department of Justice)\t\t170100\t\n\tBorder Patrol\t\t170200\t\n\tCustoms Service\t\t170300\t\n\tDrug Enforcement Administration (DEA)\t\t170400\t\n\tDepartment of Justice (DOJ)\t\t170500\t\n\tFederal Bureau of Investigation (FBI)\t\t170600\t\n\tPolice\t\t170700\t\n\tUnited States Secret Service (Treas) (USSS)\t\t170800\t\n\tTransportation Security Administration (TSA)\t\t170900\t\n\tCoast Guard\t\t171000\t\n\tUS Marshals Service\t\t171100\t\nPack Animals\t\t\t180000\t\nMissile Support\t\t\t190000\t\n\tTransloader\t\t190100\t\n\tTransporter\t\t190200\t\n\tCrane/Loading Device\t\t190300\t\n\tPropellant Transporter\t\t190400\t\n\tWarhead Transporter\t\t190500\t\nOther Equipment\t\t\t200000\tReserved for hierarchical purposes.\n\tAntennae\t\t200100\t\n\tBomb\t\t200200\t\n\tBooby Trap\t\t200300\t\n\tCBRN Equipment\t\t200400\t\n\tComputer System\t\t200500\t\n\tCommand Launch Equipment (CLE)\t\t200600\t\n\tGenerator Set\t\t200700\t\n\tGround-based Midcourse Defense (GMD) Fire Control (GFC) Center\t\t200800\t\n\tIn-Flight Interceptor Communications System (IFICS) Data Terminal (IDT)\t\t200900\t\n\tLaser\t\t201000\t\n\tMilitary Information Support Operations (MISO)\t\t201100\t\n\tSustainment Shipments\t\t201200\t\n\tTent\t\t201300\t\n\t\tCivilian\t201301\t\n\t\tMilitary\t201302\t\n\tUnit Deployment Shipments\t\t201400\t\n\tEmergency Medical Operation\t\t201500\t\n\t\tMedical Evacuation Helicopter\t201501\t\nLand Mines\t\t\t210000\tReserved for hierarchical purposes.\n\tLand Mine\t\t210100\t\n\tAntipersonnel Land mine (APL)\t\t210200\t\n\tAntitank Mine\t\t210300\t\n\tImprovised Explosives Device (IED)\t\t210400\t\n\tLess Than Lethal\t\t210500\t\nSensors\t\t\t220000\tReserved for hierarchical purposes.\n\tSensor\t\t220100\t\n\tSensor Emplaced\t\t220200\t\n\tRadar\t\t220300\t\nEmergency Operation\t\t\t230000\t\n\tAmbulance\t\t230100\t\n\tFire Fighting/Fire Protection\t\t230200\t\nManual Track\t\t\t240000\t\nRotary Wing\t\t\t250000\t";

  var mil_std_2525d_land_equipment_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nBiological\tSensor Type\t01\t\nChemical\tSensor Type\t02\t\nEarly Warning Radar\tSensor Type\t03\t\nIntrusion\tSensor Type\t04\t\nNuclear\tSensor Type\t05\t\nRadiological\tSensor Type\t06\t\nUpgraded Early Warning Radar\tSensor Type\t07\t\nHijacking/Hijacked\tCrime\t08\t\nCivilian\tOrganization\t09\t\nTilt-Rotor\tCapability\t10\t\n{Reserved for future use}\t\t11\t\nMulti-purpose Blade\tCapability\t12\t\nTank-width Mine Plow\tCapability\t13\t\nBridge\tCapability\t14\t\nCyberspace\tCapability\t15\t\nArmored\tCapability\t16\t\nAttack\tCapability\t17\t\nCargo\tCapability\t18\t\nMaintenance\tCapability\t19\t\nMedEvac\tCapability\t20\t\nPetroleum, oil, and lubricants (POL)\tCapability\t21\t\nUtility\tCapability\t22\t\nWater\tCapability\t23\t\nRobotic\tCapability\t24\t\n{Reserved for future use}\t\t25-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_equipment_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nCyberspace\tCapability\t01\t\nLight\tCapability\t02\t\nMedium\tCapability\t03\t\nRailway\tCapability\t04\t\nTracked\tCapability\t05\t\nTractor Trailer\tCapability\t06\t\nWheeled LTD\tCapability\t07\t\nWheeled X\tCapability\t08\t\nRobotic\tCapability\t09\t\n{Reserved for future use}\t\t10-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_installation_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nMilitary/Civilian\t\t\t110000\tReserved for hierarchical purposes.\n\tAircraft Production/Assembly\t\t110100\t\n\tAmmunition and Explosives Production\t\t110200\t\n\tAmmunition Cache\t\t110300\t\n\tArmament Production\t\t110400\t\n\tBlack List Location\t\t110500\t\n\tChemical, Biological, Radiological and Nuclear (CBRN)\t\t110600\t\n\tEngineering Equipment Production\t\t110700\t\n\t\tBridge\t110701\t\n\tEquipment Manufacture\t\t110800\t\n\tGovernment Leadership\t\t110900\t\n\tGray List Location\t\t111000\t\n\tMass Grave Site\t\t111100\t\n\tMateriel\t\t111200\t\n\tMine\t\t111300\t\n\tMissile and Space System Production\t\t111400\t\n\tNuclear (Non CBRN Defense)\t\t111500\t\n\tPrinted Media\t\t111600\t\n\tSafe House\t\t111700\t\n\tWhite List Location\t\t111800\t\n\tTented Camp\t\t111900\t\n\t\tDisplaced Persons/ Refugee/Evacuees Camp\t111901\t\n\t\tTraining Camp\t111902\t\n\tWarehouse/Storage Facility\t\t112000\t\n\tLaw Enforcement\t\t112100\t\n\t\tBureau of Alcohol, Tobacco, Firearms and Explosives (ATF) (Department of Justice)\t112101\t\n\t\tBorder Patrol\t112102\t\n\t\tCustoms Service\t112103\t\n\t\tDrug Enforcement Administration (DEA)\t112104\t\n\t\tDepartment of Justice (DOJ)\t112105\t\n\t\tFederal Bureau of Investigation (FBI)\t112106\t\n\t\tPolice\t112107\t\n\t\tPrison\t112108\t\n\t\tUnited States Secret Service (Treas) (USSS)\t112109\t\n\t\tTransportation Security Administration (TSA)\t112110\t\n\t\tCoast Guard\t112111\t\n\t\tUS Marshals Service\t112112\t\n\tEmergency Operation\t\t112200\t\n\t\tFire Station\t112201\t\n\t\tEmergency Medical Operation\t112202\t\nInfrastructure\t\t\t120000\tReserved for hierarchical purposes.\n\tAgriculture and Food Infrastructure\t\t120100\t\n\t\tAgriculture Laboratory\t120101\t\n\t\tAnimal Feedlot\t120102\t\n\t\tCommercial Food Distribution Center\t120103\t\n\t\tFarm/Ranch\t120104\t\n\t\tFood Distribution\t120105\t\n\t\tFood Production Center\t120106\t\n\t\tFood Retail\t120107\t\n\t\tGrain Storage\t120108\t\n\tBanking Finance and Insurance Infrastructure\t\t120200\t\n\t\tATM\t120201\t\n\t\tBank\t120202\t\n\t\tBullion Storage\t120203\t\n\t\tEconomic Infrastructure Asset\t120204\t\n\t\tFederal Reserve Bank\t120205\t\n\t\tFinancial Exchange\t120206\t\n\t\tFinancial Services, Other\t120207\t\n\tCommercial Infrastructure\t\t120300\t\n\t\tChemical Plant\t120301\t\n\t\tFirearms Manufacturer\t120302\t\n\t\tFirearms Retailer\t120303\t\n\t\tHazardous Material Production\t120304\t\n\t\tHazardous Material Storage\t120305\t\n\t\tIndustrial Site\t120306\t\n\t\tLandfill\t120307\t\n\t\tPharmaceutical Manufacturer\t120308\t\n\t\tContaminated Hazardous Waste Site\t120309\t\n\t\tToxic Release Inventory\t120310\t\n\tEducational Facilities Infrastructure\t\t120400\t\n\t\tCollege/University\t120401\t\n\t\tSchool\t120402\t\n\tEnergy Facility Infrastructure\t\t120500\t\n\t\tElectric Power\t120501\t\n\t\tGeneration Station\t120502\t\n\t\tNatural Gas Facility\t120503\t\n\t\tPetroleum Facility\t120504\t\n\t\tPetroleum/Gas/Oil\t120505\t\n\t\tPropane Facility\t120506\t\n\tGovernment Site Infrastructure\t\t120600\t\n\tMedical Infrastructure\t\t120700\tReserved for hierarchical purposes.\n\t\tMedical\t120701\t\n\t\tMedical Treatment Facility (Hospital)\t120702\t\n\tMilitary Infrastructure\t\t120800\t\n\t\tMilitary Armory\t120801\t\n\t\tMilitary Base\t120802\t\n\tPostal Services Infrastructure\t\t120900\t\n\t\tPostal Distribution Center\t120901\t\n\t\tPost Office\t120902\t\n\tPublic Venues Infrastructure\t\t121000\t\n\t\tEnclosed Facility (Public Venue)\t121001\t\n\t\tOpen Facility (Public Venue)\t121002\t\n\t\tRecreational Area\t121003\t\n\t\tReligious Institution\t121004\t\n\tSpecial Needs Infrastructure\t\t121100\t\n\t\tAdult Day Care\t121101\t\n\t\tChild Day Care\t121102\t\n\t\tElder Care\t121103\t\n\tTelecommunications Infrastructure\t\t121200\t\n\t\tBroadcast Transmitter Antennae\t121201\t\n\t\tTelecommunications\t121202\t\n\t\tTelecommunications Tower\t121203\t\n\tTransportation Infrastructure\t\t121300\t\n\t\tAirport/Air Base\t121301\t\n\t\tAir Traffic Control Facility\t121302\t\n\t\tBus Station\t121303\t\n\t\tFerry Terminal\t121304\t\n\t\tHelicopter Landing Site\t121305\t\n\t\tMaintenance Facility\t121306\t\n\t\tRailhead/Railroad Station\t121307\t\n\t\tRest Stop\t121308\t\n\t\tSea Port/Naval Base\t121309\t\n\t\tShip Yard\t121310\t\n\t\tToll Facility\t121311\t\n\t\tTraffic Inspection Facility\t121312\t\n\t\tTunnel\t121313\t\n\tWater Supply Infrastructure\t\t121400\t\n\t\tControl Valve\t121401\t\n\t\tDam\t121402\t\n\t\tDischarge Outfall\t121403\t\n\t\tGround Water Well\t121404\t\n\t\tPumping Station\t121405\t\n\t\tReservoir\t121406\t\n\t\tStorage Tower\t121407\t\n\t\tSurface Water Intake\t121408\t\n\t\tWastewater Treatment Facility\t121409\t\n\t\tWater\t121410\t\n\t\tWater Treatment\t121411\t";

  var mil_std_2525d_land_installation_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nBiological\tCBRN Type\t01\t\nChemical \tCBRN Type\t02\t\nNuclear\tCBRN Type\t03\t\nRadiological\tCBRN Type\t04\t\nDecontamination\tCBRN Type\t05\t\nCoal\tElectric Power Type\t06\tUsed with Electric Power only\nGeothermal\tElectric Power Type\t07\tUsed with Electric Power only\nHydroelectric\t Electric Power Type\t08\tUsed with Electric Power only\nNatural Gas\tElectric Power Type\t09\tUsed with Electric Power only\nPetroleum\tElectric Power Type\t10\tUsed with Electric Power only\nCivilian \tOperation\t11\t\nCivilian Telephone\tTelecommunication Type\t12\t\nCivilian Television\tTelecommunication Type\t13\t\nCyberspace\tCapability\t14\t\n{Reserved for future use}\t\t15-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_land_installation_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nBiological Warfare Production\tCapability\t01\t\nChemical Warfare Production\tCapability\t02\t\nNuclear Warfare Production\tCapability\t03\t\nRadiological Warfare Production\tCapability\t04\t\nAtomic Energy Reactor\tCapability\t05\t\nNuclear Material Production\tCapability\t06\t\nNuclear Material Storage\tCapability\t07\t\nWeapons Grade Production\tCapability\t08\t\nCyberspace\tCapability\t09\t\n{Reserved for future use}\t\t10-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_control_measure_mainIcon = "Entity\tEntity Type\tEntity Subtype\tGeometric Rendering\tCode\tRemarks\t\nCommand and Control Lines\t\t\t\t110000\t\t\n\tBoundary\t\tLine\t110100\t\t\n\tLight Line\t\tLine\t110200\t\t\n\tEngineer Work Line\t\tLine\t110300\t\t\nCommand and Control Areas\t\t\t\t120000\t\t\n\tArea of Operations\t\tArea\t120100\t\t\n\tNamed Area of Interest\t\tArea\t120200\t\t\n\tTargeted Area of Interest\t\tArea\t120300\t\t\n\tAirfield Zone\t\tArea\t120400\t\t\n\tBase Camp\t\tArea\t120500\t\t\n\tGuerrilla Base\t\tArea\t120600\t\t\nCommand and Control Points\t\t\t\t130000\t\t\n\tAction Point (General)\t\tPoint\t130100\t\t\n\tAmnesty Point\t\tPoint\t130200\t\t\n\tCheckpoint\t\tPoint\t130300\t\t\n\tCenter of Main Effort\t\tPoint\t130400\t\t\n\tContact Point\t\tPoint\t130500\t\t\n\tCoordinating Point\t\tPoint\t130600\t\t\n\tDecision Point\t\tPoint\t130700\t\t\n\tDistress Call\t\tPoint\t130800\t\t\n\tEntry Control Point\t\tPoint\t130900\t\t\n\tFly-To-Point\t\t\t131000\t\t\n\t\tSonobuoy\tPoint\t131001\t\t\n\t\tWeapon\tPoint\t131002\t\t\n\t\tNormal\tPoint\t131003\t\t\n\tLinkup Point\t\tPoint\t131100\t\t\n\tPassage Point\t\tPoint\t131200\t\t\n\tPoint of Interest\t\tPoint\t131300\t\t\n\t\tLaunch Event\tPoint\t131301\t\t\n\tRally Point\t\tPoint\t131400\t\t\n\tRelease Point\t\tPoint\t131500\t\t\n\tStart Point\t\tPoint\t131600\t\t\n\tSpecial Point\t\tPoint\t131700\t\t\n\tWaypoint\t\tPoint\t131800\t\t\n\tAirfield\t\tPoint\t131900\t\t\n\tTarget Handover\t\tPoint\t132000\t\t\n\tKey Terrain\t\tPoint\t132100\t\t\nManeuver Lines\t\t\t\t140000\t\t\n\tForward Line of Troops\t\tLine\t140100\t\t\n\t{Reserved for future use}\t\t\t140200\t\t\n\tPhase Line\t\tLine\t140300\t\t\n\tForward Edge of the Battle Area\t\tLine\t140400\t\t\n\tPrinciple Direction of Fire\t\tLine\t140500\t\t\n\tDirection of Attack\t\tLine\t140600\t\t\n\t\tFriendly Aviation\tLine\t140601\t\t\n\t\tFriendly Main Attack /Decisive\tLine\t140602\t\t\n\t\tFriendly Supporting Attack\tLine\t140603\t\t\n\t\tFeint\tLine\t140605\t\t\n\tFinal Coordination Line\t\tLine\t140700\t\t\n\tInfiltration Lane\t\tLine\t140800\t\t\n\tLimit of Advance\t\tLine\t140900\t\t\n\tLine of Departure\t\tLine\t141000\t\t\n\tLine of Departure/Line of Contact\t\tLine\t141100\t\t\n\tProbable Line of Deployment\t\tLine\t141200\t\t\n\tAirhead Line\t\tLine\t141300\t\t\n\tBridgehead Line\t\tLine\t141400\t\t\n\tHolding Line\t\tLine\t141500\t\t\n\tRelease Line\t\tLine\t141600\t\t\n\tAmbush\t\tLine\t141700\t\t\nManeuver Areas\t\t\t\t150000\t\t\n\tArea\t\tArea\t150100\t\t\n\tAssembly Area\t\tArea\t150200\t\t\n\tOccupied Assembly Area\t\tArea\t150300\t\t\n\t{Reserved for future use}\t\t\t150400\t\t\n\tAction Area\t\t\t150500\t\t\n\t\tJoint Tactical Action Area (JTAA)\tArea\t150501\t\t\n\t\tSubmarine Action Area (SAA)\tArea\t150502\t\t\n\t\tSubmarine-Generated Action Area (SGAA)\tArea\t150503\t\t\n\tDrop Zone\t\tArea\t150600\t\t\n\tExtraction Zone\t\tArea\t150700\t\t\n\tLanding Zone\t\tArea\t150800\t\t\n\tPick–Up Zone\t\tArea\t150900\t\t\n\tFortified Area\t\tArea\t151000\t\t\n\tLimited Access Area\t\tArea\t151100\t\t\n\tBattle Position\t\tArea\t151200\t\t\n\t\tPrepared (P) but not Occupied\tArea\t151202\t\t\n\t\tStrong Point\tArea\t151203\t\t\n\t\tContain\tArea\t151204\t\t\n\t\tRetain\tArea\t151205\t\t\n\tEngagement Area (EA)\t\tArea\t151300\t\t\n\tAxis of Advance\t\t\t151400\t\t\n\t\tFriendly Airborne/Aviation\tLine\t151401\t\t\n\t\tAttack Helicopter\tLine\t151402\t\t\n\t\tMain Attack\tLine\t151403\t\t\n\t\tSupporting Attack \tLine\t151404\t\t\n\tAssault Position\t\tArea\t151500\t\t\n\tAttack Position\t\tArea\t151600\t\t\n\tObjective\t\tArea\t151700\t\t\n\tEncirclement\t\tArea\t151800\t\t\n\tPenetration Box\t\tArea\t151900\t\t\n\tAttack by Fire Position\t\tArea\t152000\t\t\n\tSupport by Fire\t\tArea\t152100\t\t\n\tSearch Area/Reconnaissance Area\t\tArea\t152200\t\t\nManeuver Points\t\t\t\t160000\t\t\n\tObservation Post/Outpost (unspecified)\t\tPoint\t160100\t\t\n\tObservation Post/Outpost (specified)\t\tPoint\t160200\t\t\n\t\tReconnaissance Outpost\tPoint\t160201\t\t\n\t\tForward Observer/Spotter Outpost/Position\tPoint\t160202\t\t\n\t\tCBRN Observation Outpost\tPoint\t160203\t\t\n\t\tSensor Outpost /Listening Post\tPoint\t160204\t\t\n\t\tCombat Outpost\tPoint\t160205\t\t\n\tTarget Reference Point\t\tPoint\t160300\t\t\n\tPoint of Departure\t\tPoint\t160400\t\t\nAirspace Control (Corridors) Areas\t\t\t\t170000\t\t\n\tAir Corridor\t\tArea\t170100\t\t\n\tLow Level Transit Route\t\tArea\t170200\t\t\n\tMinimum–Risk Route\t\tArea\t170300\t\t\n\tSafe Lane\t\tArea\t170400\t\t\n\tStandard Use Army Aircraft Flight Route\t\tArea\t170500\t\t\n\tTransit Corridor\t\tArea\t170600\t\t\n\tSpecial Corridor\t\tArea\t170700\t\t\n\tBase Defense Zone\t\tArea\t170800\t\t\n\tHigh–Density Airspace Control Zone\t\tArea\t170900\t\t\n\tRestricted Operations Zone\t\tArea\t171000\t\t\n\tAir-to-Air Restricted Operating Zone\t\tArea\t171100\t\t\n\tUnmanned Aircraft Restricted Operating Zone\t\tArea\t171200\t\t\n\tWeapon Engagement Zone\t\tArea\t171300\t\t\n\tFighter Engagement Zone\t\tArea\t171400\t\t\n\tJoint Engagement Zone\t\tArea\t171500\t\t\n\tMissile Engagement Zone\t\tArea\t171600\t\t\n\tLow Altitude Missile Engagement Zone\t\tArea\t171700\t\t\n\tHigh Altitude Missile Engagement Zone\t\tArea\t171800\t\t\n\tShort Range Air Defense Engagement Zone\t\tArea\t171900\t\t\n\tWeapons Free Zone\t\tArea\t172000\t\t\nAirspace Control Points\t\t\t\t180000\t\t\n\tAir Control Point\t\tPoint\t180100\t\t\n\tCommunications Checkpoint\t\tPoint\t180200\t\t\n\tDowned Aircraft Pick–up Point\t\tPoint\t180300\t\t\n\tPop–up Point\t\tPoint\t180400\t\t\n\tAir Control Rendezvous\t\tPoint\t180500\t\t\n\tTactical Air Navigation (TACAN)\t\tPoint\t180600\t\t\n\tCombat Air Patrol (CAP)Station\t\tPoint\t180700\t\t\n\tAirborne Early Warning (AEW) Station\t\tPoint\t180800\t\t\n\tASW (Helo and F/W) Station\t\tPoint\t180900\t\t\n\tStrike Initial Point\t\tPoint\t181000\t\t\n\tReplenishment Station\t\tPoint\t181100\t\t\n\tTanking\t\tPoint\t181200\t\t\n\tAntisubmarine Warfare, Rotary Wing\t\tPoint\t181300\t\t\n\tSurface Combat Air Patrol (SUCAP) – Fixed Wing\t\tPoint\t181400\t\t\n\tSUCAP – Rotary Wing\t\tPoint\t181500\t\t\n\tMIW – Fixed Wing\t\tPoint\t181600\t\t\n\tMIW – Rotary Wing\t\tPoint\t181700\t\t\n\tTomcat\t\tPoint\t181800\t\t\n\tRescue\t\tPoint\t181900\t\t\n\tUnmanned Aerial System (UAS/UA)\t\tPoint\t182000\t\t\n\tVertical Takeoff and Landing (VTOL) Tactical Unmanned Aircraft (VTUA)\t\tPoint\t182100\t\t\t\t\n\tOrbit\t\tPoint\t182200\t\t\n\tOrbit – Figure Eight\t\tPoint\t182300\t\t\n\tOrbit – Race Track\t\tPoint\t182400\t\t\n\tOrbit – Random Closed\t\tPoint\t182500\t\t\nAirspace Control Lines\t\t\t\t190000\t\t\n\tIdentification Friend or Foe Off Line\t\tLine\t190100\t\t\n\tIdentification Friend or Foe On Line\t\tLine\t190200\t\t\nMaritime Control Areas\t\t\t\t200000\t\t\n\tLaunch Area\t\t\t200100\t\t\n\t\tEllipse/Circle\tArea\t200101\t\t\n\tDefended Area\t\t\t200200\t\t\n\t\tEllipse/Circle\tArea\t200201\t\t\n\t\tRectangle\tArea\t200202\t\t\n\tNo Attack (NOTACK) Zone\t\tArea\t200300\t\t\n\tShip Area of Interest\t\tPoint\t200400\t\t\n\t\tEllipse/Circle\tArea\t200401\t\t\n\t\tRectangle\tArea\t200402\t\t\n\tActive Maneuver Area\t\tPoint\t200500\t\t\n\tCued Acquisition Doctrine\t\tPoint17\t200600\t\t\n\tRadar Search Doctrine\t\tPoint18\t200700\t\t\nMaritime Control Points\t\t\t\t210000\t\t\n\tPlan Ship\t\tPoint\t210100\t\t\n\tAim Point\t\tPoint\t210200\t\t\n\tDefended Asset\t\tPoint\t210300\t\t\n\tDrop Point\t\tPoint\t210400\t\t\n\tEntry Point\t\tPoint\t210500\t\t\n\tAir Detonation\t\tPoint\t210600\t\t\n\tGround Zero\t\tPoint\t210700\t\t\n\tImpact Point\t\tPoint\t210800\t\t\n\tPredicted Impact Point\t\tPoint\t210900\t\t\n\tLaunched Torpedo\t\tPoint\t211000\t\t\n\tMissile Detection Point\t\tPoint\t211100\t\t\n\tAcoustic Countermeasure (Decoy)\t\tPoint\t211200\t\t\n\tElectronic Countermeasures (ECM) Decoy\t\tPoint\t211300\t\t\n\tBrief Contact\t\tPoint\t211400\t\t\n\tDatum Lost Contact\t\tPoint\t211500\t\t\n\tBT Buoy Drop\t\tPoint\t211600\t\t\n\tReported Bottomed Sub\t\tPoint\t211700\t\t\n\tMoving Haven\t\tPoint\t211800\t\t\n\tScreen Center\t\tPoint\t211900\t\t\n\tLost Contact\t\tPoint\t212000\t\t\n\tSinker\t\tPoint\t212100\t\t\n\tTrial Track\t\tPoint\t212200\t\t\n\tAcoustic Fix\t\tPoint\t212300\t\t\n\tElectromagnetic Fix\t\tPoint\t212400\t\t\n\tElectromagnetic – Magnetic Anomaly Detection (MAD)\t\tPoint\t212500\t\t\n\tOptical Fix\t\tPoint\t212600\t\t\n\tFormation\t\tPoint\t212700\t\t\n\tHarbor\t\tPoint\t212800\t\t\n\tHarbor Entrance Point\t\tPoint\t212900\t\t\n\t\tA\tPoint\t212901\t\t\n\t\tQ\tPoint\t212902\t\t\n\t\tX\tPoint\t212903\t\t\n\t\tY\tPoint\t212904\t\t\n\tDip Position\t\tPoint\t213000\t\t\n\tSearch\t\tPoint\t213100\t\t\n\tSearch Area\t\tPoint\t213200\t\t\n\tSearch Center\t\tPoint\t213300\t\t\n\tNavigational Reference Point\t\tPoint\t213400\t\t\n\tSonobuoy\t\tPoint\t213500\t\t\n\t\tAmbient Noise\tPoint\t213501\t\t\n\t\tAir Transportable Communication\tPoint\t213502\t\t\n\t\tBarra\tPoint\t213503\t\t\n\t\tBathythermograph Transmitting\tPoint\t213504\t\t\n\t\tCommand Active Multi-Beam (CAMBS)\tPoint\t213505\t\t\n\t\tCommand Active Sonobuoy Directional Command Active Sonobuoy System (CASS)\tPoint\t213506\t\t\n\t\tDirectional Frequency Analysis and Recording (DIFAR)\tPoint\t213507\t\t\n\t\tDirectional Command Active Sonobuoy System (DICASS)\tPoint\t213508\t\t\n\t\tExpendable Reliable Acoustic Path Sonobuoy (ERAPS)\tPoint\t213509\t\t\n\t\tExpired\tPoint\t213510\t\t\n\t\tKingpin\tPoint\t213511\t\t\n\t\tLow Frequency Analysis and Recording (LOFAR)\tPoint\t213512\t\t\n\t\tPattern Center\tPoint\t213513\t\t\n\t\tRange Only\tPoint\t213514\t\t\n\t\tVertical Line Array Directional Frequency Analysis and Recording (DIFAR)\tPoint\t213515\t\t\n\tReference Point\t\tPoint\t213600\t\t\n\tSpecial Point\t\tPoint\t213700\t\t\n\tNavigational Reference Point(Points)\t\tPoint\t213800\t\t\n\tData Link Reference Point\t\tPoint\t213900\t\t\n\t{Reserved for future use}\t\t\t214000\t\t\n\tVital Area Center\t\tPoint\t214100\t\t\n\tCorridor Tab Point\t\tPoint\t214200\t\t\n\tEnemy Point\t\tPoint\t214300\t\t\n\tMarshall Point\t\tPoint\t214400\t\t\n\tPosition and Intended Movement (PIM)\t\tPoint\t214500\t\t\n\tPre-Landfall Waypoint\t\tPoint\t214600\t\t\n\tEstimated Position (EP)\t\tPoint\t214700\t\t\n\tWaypoint\t\tPoint\t214800\t\t\n\tGeneral Sea Subsurface Station\t\tPoint\t214900\t\t\n\tSubmarine Sea Subsurface Station\t\tPoint\t215000\t\t\n\tSubmarine Antisubmarine Warfare Sea Subsurface Station\t\tPoint\t215100\t\t\n\tUnmanned Underwater Vehicle Sea Subsurface Station\t\tPoint\t215200\t\t\n\tAntisubmarine Warfare (ASW) Unmanned Underwater Vehicle Sea Subsurface Station\t\tPoint\t215300\t\t\n\tMine Warfare Unmanned Underwater Vehicle Sea Subsurface Station\t\tPoint\t215400\t\t\n\tSea Surface Warfare Unmanned Underwater Vehicle Subsurface Station\t\tPoint\t215500\t\t\n\tGeneral Sea Surface Station\t\tPoint\t215600\t\t\n\tAntisubmarine Warfare (ASW) Sea Surface Station\t\tPoint\t215700\t\t\n\tMine Warfare Sea Surface Station\t\tPoint\t215800\t\t\n\tNon-Combatant Sea Surface Station\t\tPoint\t215900\t\t\n\tPicket Sea Surface Station\t\tPoint\t216000\t\t\n\tRendezvous Sea Surface Station\t\tPoint\t216100\t\t\n\tReplenishment at Sea Surface Station\t\tPoint\t216200\t\t\n\tRescue Sea Surface Station\t\tPoint\t216300\t\t\n\tSurface Warfare Sea Surface Station\t\tPoint\t216400\t\t\n\tUnmanned Underwater Vehicle Sea Surface Station\t\tPoint\t216500\t\t\n\tAntisubmarine Warfare (ASW) Unmanned Underwater Vehicle Sea Surface Station\t\tPoint\t216600\t\t\n\tMine Warfare Unmanned Underwater Vehicle Sea Surface Station\t\tPoint\t216700\t\t\n\tRemote Multi-Mission Vehicle Mine Warfare Unmanned Underwater Sea Surface Station\t\tPoint\t216800\t\t\n\tSurface Warfare Mine Warfare Unmanned Underwater Vehicle Sea Surface Station\t\tPoint\t216900\t\t\n\tShore Control Station\t\tPoint\t217000\t\t\n\tGeneral Route\t\tPoint\t217100\t\t\n\tDiversion Route\t\tPoint\t217200\t\t\n\tPosition and Intended Movement (PIM) Route\t\tPoint\t217300\t\t\t\t\n\tPicket Route\t\tPoint\t217400\t\t\n\tPoint R Route\t\tPoint\t217500\t\t\n\tRendezvous Route\t\tPoint\t217600\t\t\n\tWaypoint Route\t\tPoint\t217700\t\t\n\tClutter, Stationary or Cease Reporting\t\tPoint\t217800\t\t\n\tTentative or Provisional Track\t\tPoint\t217900\t\t\n\tDistressed Vessel\t\tPoint\t218000\t\t\n\tDitched Aircraft/Downed Aircraft\t\tPoint\t218100\t\t\n\tPerson in Water/Bailout\t\tPoint\t218200\t\t\n\tIceberg\t\tPoint\t218300\t\t\n\tNavigational\t\tLine\t218400\t\t\n\tOil Rig\t\tPoint\t218500\t\t\n\tSea Mine–Like\t\tPoint\t218600\t\t\n\tBottom Return/Non-Mine, Mine-Like Bottom Object (NOMBO)\t\tPoint\t218700\t\t\n\tBottom Return/Non-Mine, Mine-Like Bottom Object (NOMBO)/Installation Manmade\t\tPoint\t218800\t\t\n\t\tMarine Life\tPoint\t218900\t\t\n\t\tSea Anomaly (Wake, Current, Knuckle)\tPoint\t219000\t\t\t\t\t\n\t\tBottom Return/Non-MILCO, Wreck, Dangerous\tPoint\t219100\t\t\n\t\tBottom Return/Non-MILCO, Wreck, Non Dangerous\tPoint\t219200\t\t\nMaritime Control Lines\t\t\t\t220000\t\t\n\tBearing Line\t\tLine\t220100\t\t\n\t\tElectronic\tLine\t220101\t\t\n\t\tElectronic Warfare (EW)\tLine\t220102\t\t\n\t\tAcoustic\tLine\t220103\t\t\n\t\tAcoustic (Ambiguous)\tLine\t220104\t\t\n\t\tTorpedo\tLine\t220105\t\t\n\t\tElectro-Optical Intercept\tLine\t220106\t\t\n\t\tJammer\tLine\t220107\t\t\n\t\tRadio Direction Finder (RDF)\tLine\t220108\t\t\n{reserved for future use}\t\t\t\t230000\t\t\nFires Areas\t\t\t\t240000\t\t\n\tAirspace Coordination Area\t\t\t240100\t\t\n\t\tIrregular\tArea\t240101\t\t\n\t\tRectangular\tArea\t240102\t\t\n\t\tCircular\tArea\t240103\t\t\n\tFree Fire Area\t\t\t240200\t\t\n\t\tIrregular\tArea\t240201\t\t\n\t\tRectangular\tArea\t240202\t\t\n\t\tCircular\tArea\t240203\t\t\n\tNo Fire Area\t\t\t240300\t\t\n\t\tIrregular\tArea\t240301\t\t\n\t\tRectangular\tArea\t240302\t\t\n\t\tCircular\tArea\t240303\t\t\n\tRestricted Fire Area\t\t\t240400\t\t\n\t\tIrregular\tArea\t240401\t\t\n\t\tRectangular\tArea\t240402\t\t\n\t\tCircular\tArea\t240403\t\t\n\tPosition Area For Artillery (PAA)\t\t\t240500\t\t\n\t\tRectangular\tArea\t240501\t\t\n\t\tCircular\tArea\t240502\t\t\n\tPoint Targets\t\t\t240600\t\t\n\t\tPoint or Single Target\tPoint\t240601\t\t\n\t\tNuclear Target\tPoint\t240602\t\t\n\t\tTarget-Recorded\tPoint\t240603\t\t\n\tLinear Targets\t\t\t240700\t\t\n\t\tLinear Target\tLine\t240701\t\t\n\t\tLinear Smoke Target\tLine\t240702\t\t\n\t\tFinal Protective Fire (FPF)\tLine\t240703\t\t\n\tArea Targets\t\t\t240800\t\t\n\t\tArea Target\tArea\t240801\t\t\n\t\tRectangular Target\tArea\t240802\t\t\n\t\tCircular Target\tArea\t240803\t\t\n\t\tRectangular Target – Single Target\tArea\t240804\t\t\n\t\tSeries or Groups of Targets\tArea\t240805\t\t\n\t\tSmoke \tArea\t240806\t\t\n\t\t{reserved for future use}\t\t240807\t\t\n\t\tBomb Area\tArea\t240808\t\t\n\tFire Support Station\t\tPoint\t240900\t\t\n\tFire Support Area\t\t\t241000\t\t\n\t\tIrregular\tArea\t241001\t\t\n\t\tRectangular\tArea\t241002\t\t\n\t\tCircular\tArea\t241003\t\t\n\tArtillery Target Intelligence Zone\t\t\t241100\t\t\n\t\tIrregular\tArea\t241101\t\t\n\t\tRectangular\tArea\t241102\t\t\n\t\tCircular\tArea\t241103\t\t\n\tCall for Fire Area\t\t\t241200\t\t\n\t\tIrregular\tArea\t241201\t\t\n\t\tRectangular\tArea\t241202\t\t\n\t\tCircular\tArea\t241203\t\t\n\tCensor Zone\t\t\t241300\t\t\n\t\tIrregular\tArea\t241301\t\t\n\t\tRectangular\tArea\t241302\t\t\n\t\tCircular\tArea\t241303\t\t\n\tCritical Friendly Zone\t\t\t241400\t\t\n\t\tIrregular\tArea\t241401\t\t\n\t\tRectangular\tArea\t241402\t\t\n\t\tCircular\tArea\t241403\t\t\n\tDead Space Area\t\t\t241500\t\t\n\t\tIrregular\tArea\t241501\t\t\n\t\tRectangular\tArea\t241502\t\t\n\t\tCircular\tArea\t241503\t\t\n\tSensor Zone\t\t\t241600\t\t\n\t\tIrregular\tArea\t241601\t\t\n\t\tRectangular\tArea\t241602\t\t\n\t\tCircular\tArea\t241603\t\t\n\tTarget Build–up Area\t\t\t241700\t\t\n\t\tIrregular\tArea\t241701\t\t\n\t\tRectangular\tArea\t241702\t\t\n\t\tCircular\tArea\t241703\t\t\n\tTarget Value Area\t\t\t241800\t\t\n\t\tIrregular\tArea\t241801\t\t\n\t\tRectangular\tArea\t241802\t\t\n\t\tCircular\tArea\t241803\t\t\n\tZone of Responsibility\t\t\t241900\t\t\n\t\tIrregular\tArea\t241901\t\t\n\t\tRectangular\tArea\t241902\t\t\n\t\tCircular\tArea\t241903\t\t\n\tTerminally Guided Munition Footprint (TGMF)\t\tArea\t242000\t\t\n\tWeapon/Sensor Range fan, Circular\t\tArea\t242100\t\t\n\tWeapon/Sensor Range fan, Sector\t\tArea\t242200\t\t\n\tKill Box\t\t\t242300\t\t\n\t\tIrregular, Blue\tArea\t242301\t\t\n\t\tRectangular, Blue\tArea\t242302\t\t\n\t\tCircular, Blue\tArea\t242303\t\t\n\t\tIrregular, Purple\tArea\t242304\t\t\n\t\tRectangular, Purple\tArea\t242305\t\t\n\t\tCircular, Purple\tArea\t242306\t\t\nFires Points\t\t\t\t250000\t\t\n\tFiring Point\t\tPoint\t250100\t\t\n\tHide Point\t\tPoint\t250200\t\t\n\tLaunch Point\t\tPoint\t250300\t\t\n\tReload Point\t\tPoint\t250400\t\t\n\tSurvey Control Point\t\tPoint\t250500\t\t\n\tKnown Point\t\tPoint\t250600\t\t\nFire Lines\t\t\t\t260000\t\t\n\tFire Support Coordination Line (FSCL)\t\tLine\t260100\t\t\n\tCoordinated Fire Line (CFL)\t\tLine\t260200\t\t\n\tNo Fire Line\t\tLine\t260300\t\t\n\tBattlefield Coordination Line\t\tLine\t260400\t\t\n\tRestrictive Fire Line\t\tLine\t260500\t\t\n\tMunition Flight Path\t\tLine\t260600\t\t\nProtection Areas\t\t\t\t270000\t\t\n\tObstacle Belt\t\tArea\t270100\t\t\n\tObstacle Zone\t\tArea\t270200\t\t\n\tObstacle Free Zone\t\tArea\t270300\t\t\n\tObstacle Restricted Zone\t\tArea\t270400\t\t\n\tObstacle Effects\t\t\t270500\t\t\n\t\tBlock\tArea\t270501\t\t\n\t\tDisrupt\tArea\t270502\t\t\n\t\tFix\tLine\t270503\t\t\n\t\tTurn\tLine\t270504\t\t\n\tObstacle Bypass\t\t\t270600\t\t\n\t\tEasy\tPoint12\t270601\t\t\n\t\tDifficult\tPoint12\t270602\t\t\n\t\tImpossible\tPoint12\t270603\t\t\n\tMinefields\t\t\t270700\t\t\n\t\tStatic Depiction\tPoint\t270701\t\t\n\t\tDynamic Depiction\tArea\t270707\t\t\n\tMined Area\t\tArea\t270800\t\t\n\t\tFenced\tArea\t270801\t\t\n\tUnexploded Explosive Ordnance (UXO) Area\t\tArea\t271000\t\t\n\tBridge or Gap\t\tLine\t271100\t\t\n\tRoadblocks, Craters and Blown Bridges\t\t\t271200\t\t\n\t\tPlanned\tLine\t271201\t\t\n\t\tExplosives, State of Readiness 1 (Safe)\tLine\t271202\t\t\n\t\tExplosives, State of Readiness 2 (armed but passable)\tLine\t271203\t\t\n\t\tRoadblock Complete (Executed)\tLine\t271204\t\t\n\tAssault Crossing\t\tLine\t271300\t\t\n\t{Reserved for future use}\t\t\t271400\t\t\n\tFord Easy\t\tLine\t271500\t\t\n\tFord Difficult\t\tLine\t271600\t\t\n\tBiological Contaminated Area\t\tArea\t271700\t\t\n\tChemical Contaminated Area\t\tArea\t271800\t\t\n\tNuclear Contaminated Area\t\tArea\t271900\t\t\n\tRadiological Contaminated Area\t\tArea\t272000\t\t\n\tMinimum Safe Distance Zone\t\tArea\t272100\t\t\n\tMultiple Strikes – STRIKWARN\t\tArea\t272101\t\t\n\tRadiation Dose Rate Contour Lines\t\tArea\t272200\t\t\nProtection Points\t\t\t\t280000\t\t\n\tAbatis\t\tLine\t280100\t\t\n\tAntipersonnel Mine\t\tPoint\t280200\t\t\n\t\tAntipersonnel Mine with Directional Effects\tPoint\t280201\t\t\n\tAntitank Mine\t\tPoint\t280300\t\t\n\tAntitank Mine with Anti-handling Device\t\tPoint\t280400\t\t\n\tWide Area Antitank Mine\t\tPoint\t280500\t\t\n\tUnspecified Mine\t\tPoint\t280600\t\t\n\tBooby Trap\t\tPoint\t280700\t\t\n\tEngineer Regulating Point\t\tPoint\t280800\t\t\n\tShelter\t\tPoint\t280900\t\t\n\tShelter Above Ground\t\tPoint\t281000\t\t\n\tBelow Ground Shelter\t\tPoint\t281100\t\t\n\tFort\t\tPoint\t281200\t\t\n\tChemical Event\t\tPoint\t281300\t\t\n\tBiological Event\t\tPoint\t281400\t\t\n\tNuclear Event\t\tPoint\t281500\t\t\n\tNuclear Fallout Producing Event\t\tPoint\t281600\t\t\n\tRadiological Event\t\tPoint\t281700\t\t\n\tGeneral Decontamination Point/Site\t\tPoint\t281800\t\t\n\t\tAlternate\tPoint\t281801\t\t\n\t\tEquipment\tPoint\t281802\t\t\n\t\tTroop\tPoint\t281803\t\t\n\t\tEquipment/Troop\tPoint\t281804\t\n\t\tOperational\tPoint\t281805\t\t\n\t\tThorough\tPoint\t281806\t\t\n\t\tMain Equipment\tPoint\t281807\t\t\n\t\tForward Troop\tPoint\t281808\t\t\n\t\tWounded Personnel\tPoint\t281809\t\t\n\tTetrahedrons, Dragons Teeth, and Other Similar Obstacles\t\t\t281900\t\t\n\t\tFixed and Prefabricated\tPoint\t281901\t\t\n\t\tMovable\tPoint\t281902\t\t\n\t\tMovable and Prefabricated\tPoint\t281903\t\t\n\tVertical Obstructions\t\t\t282000\t\t\n\t\tTower, Low\tPoint\t282001\t\t\n\t\tTower, High\tPoint\t282002\t\t\n\t\tOverhead Wire\tLine\t282003\t\t\nProtection Lines\t\t\t\t290000\t\t\n\tObstacle Line\t\tLine\t290100\t\t\n\t\tMineline\tLine\t290101\t\t\n\tAntitank Obstacles\t\t\t290200\t\t\n\t\tUnder Construction\tLine\t290201\t\t\n\t\tCompleted\tLine\t290202\t\t\n\t\tReinforced, with Antitank Mines\tLine\t290203\t\t\n\t\tAntitank Wall\tLine\t290204\t\t\n\tWire Obstacles\t\t\t290300\t\t\n\t\tUnspecified Wire\tLine\t290301\t\t\n\t\tSingle Fence Wire\tLine\t290302\t\t\n\t\tDouble Fence Wire\tLine\t290303\t\t\n\t\tDouble Apron Fence\tLine\t290304\t\t\n\t\tLow Wire Fence\tLine\t290305\t\t\n\t\tHigh Wire Fence\tLine\t290306\t\t\n\t\tSingle Concertina\tLine\t290307\t\t\n\t\tDouble Strand Concertina\tLine\t290308\t\t\n\t\tTriple Strand Concertina\tLine\t290309\t\t\n\tMine Cluster\t\tArea\t290400\t\t\n\tTrip Wire\t\tLine\t290500\t\t\n\tLane\t\tLine\t290600\t\t\n\tFerry\t\tLine\t290700\t\t\n\tRaft Site\t\tLine\t290800\t\t\n\tFortified Line\t\tLine\t290900\t\t\n\tFighting Position\t\tLine\t291000\t\t\nIntelligence Lines\t\t\t\t300000\t\t\n\tIntelligence Coordination Line\t\tLine\t300100\t\t\nSustainment Areas\t\t\t\t310000\t\t\n\tDetainee Holding Area\t\tArea\t310100\t\t\n\tEnemy Prisoner or War Holding Area\t\tArea\t310200\t\t\n\tForward Arming and Refueling Point\t\tArea\t310300\t\t\n\tRefugee Holding Area\t\tArea\t310400\t\t\n\tRegimental Support Area\t\tArea\t310500\t\t\n\tBrigade Support Area\t\tArea\t310600\t\t\n\tDivision Support Area\t\tArea\t310700\t\t\nSustainment Points\t\t\t\t320000\t\t\n\tAmbulance Points\t\tPoint\t320100\t\t\n\t\tAmbulance Exchange Point\tPoint\t320101\t\t\n\t\tAmbulance Control Point\tPoint\t320102\t\t\n\t\tAmbulance Load Point\tPoint\t320103\t\t\n\t\tAmbulance Relay Point\tPoint\t320104\t\t\n\tAmmunition Supply Point\t\tPoint\t320200\t\t\n\tAmmunition Transfer and Holding Point\t\tPoint\t320300\t\t\n\tCannibalization Point\t\tPoint\t320400\t\t\n\tCasualty Collection Point\t\tPoint\t320500\t\n\tCivilian Collection Point\t\tPoint\t320600\t\t\n\tDetainee Collection Point\t\tPoint\t320700\t\t\n\tEnemy Prisoner of War Collection Point\t\tPoint\t320800\t\t\n\tLogistics Release Point\t\tPoint\t320900\t\t\n\tMaintenance Collection Point (MCP)\t\tPoint\t321000\t\t\n\tMedical Evacuation Point (MEDEVAC) Pick-Up Point\t\tPoint\t321100\t\t\n\tRearm, Refuel and Resupply Point (R3P)\t\tPoint\t321200\t\t\n\tRefuel on the Move (ROM) Point\t\tPoint\t321300\t\t\n\tTraffic Control Post (TCP)\t\tPoint\t321400\t\t\n\tTrailer Transfer Point (TTP)\t\tPoint\t321500\t\t\n\tUnit Maintenance Collection Point (UNCP)\t\tPoint\t321600\t\t\n\tGeneral Supply Point\t\tPoint\t321700\t\t\n\t\tNATO Class I Supply Point\tPoint\t321701\t\t\n\t\tNATO Class II Supply Point\tPoint\t321702\t\t\n\t\tNATO Class III Supply Point\tPoint\t321703\t\t\n\t\tNATO Class IV Supply Point\tPoint\t321704\t\t\n\t\tNATO Class V Supply Point\tPoint\t321705\t\t\n\t\tNATO Multiple Class Supply Point\tPoint\t321706\t\t\n\t\tUS Class I Supply Point\tPoint\t321707\t\t\n\t\tUS Class II Supply Point\tPoint\t321708\t\t\n\t\tUS Class III Supply Point\tPoint\t321709\t\t\n\t\tUS Class IV Supply Point\tPoint\t321710\t\t\n\t\tUS Class V Supply Point\tPoint\t321711\t\t\n\t\tUS Class VI Supply Point\tPoint\t321712\t\t\n\t\tUS Class VII Supply Point\tPoint\t321713\t\t\n\t\tUS Class VIII Supply Point\tPoint\t321714\t\t\n\t\tUS Class IX Supply Point\tPoint\t321715\t\t\n\t\tUS Class X Supply Point\tPoint\t321716\t\t\n\tMedical Supply Point\t\tPoint\t321800\t\t\nSustainment Lines\t\t\t\t330000\t\t\n\tMoving Convoy\t\tLine\t330100\t\t\n\tHalted Convoy\t\tLine\t330200\t\t\n\tMain Supply Route\t\tLine\t330300\t\t\n\t\tOne Way Traffic\tLine\t330301\t\t\n\t\tTwo Way Traffic\tLine\t330302\t\t\n\t\tAlternating Traffic\tLine\t330303\t\t\n\tAlternate Supply Route\t\tLine\t330400\t\t\n\t\tOne Way Traffic\tLine\t330401\t\t\n\t\tTwo Way Traffic\tLine\t330402\t\t\n\t\tAlternating Traffic\tLine\t330403\t\t\nMission Tasks\t\t\t\t340000\t\t\n\tBlock\t\tArea\t340100\t\t\n\tBreach\t\tLine\t340200\t\t\n\tBypass\t\tPoint12\t340300\t\t\n\tCanalize\t\tPoint12\t340400\t\t\n\tClear\t\tLine\t340500\t\t\n\tCounterattack\t\tLine\t340600\t\t\n\tCounterattack by Fire\t\tLine\t340700\t\t\n\tDelay\t\tLine\t340800\t\t\n\tDestroy\t\tPoint\t340900\t\t\n\tDisrupt\t\tArea\t341000\t\t\n\tFix\t\tLine\t341100\t\t\n\tFollow and Assume\t\tLine\t341200\t\t\n\tFollow and Support\t\tLine\t341300\t\t\n\tInterdict\t\tPoint\t341400\t\t\n\tIsolate\t\tArea\t341500\t\t\n\tNeutralize\t\tPoint\t341600\t\t\n\tOccupy\t\tArea\t341700\t\t\n\tPenetrate\t\tArea\t341800\t\t\n\tRelief in Place (RIP)\t\tArea\t341900\t\t\n\tRetire/Retirement\t\tLine\t342000\t\t\n\tSecure\t\tArea\t342100\t\t\n\tSecurity\t\t\t342200\t\t\n\t\tCover\tLine\t342201\t\t\n\t\tGuard\tLine\t342202\t\t\n\t\tScreen\tLine\t342203\t\t\n\tSeize\t\tLine\t342300\t\t\n\tWithdraw\t\tLine\t342400\t\t\n\tWithdraw Under Pressure\t\tLine\t342500\t\t\n\tCordon and Knock\t\tArea\t342600\t\t\n\tCordon and Search\t\tArea\t342700\t\t\n\tSuppress\t\tPoint\t342800\t\t\n\tAdvance to Contact\t\tLine\t342900\t\t\n\tCapture\t\tLine\t343000\t\t\n\tConduct Exploitation\t\tLine\t343100\t\t\n\tControl\t\tArea\t343200\t\t\n\tDemonstration\t\tLine\t343300\t\t\n\tDeny\t\tArea\t343400\t\t\n\tEnvelop\t\tLine\t343500\t\t\n\tEscort\t\tLine\t343600\t\t\n\tExfiltrate\t\tLine\t343700\t\t\n\tInfiltrate\t\tLine\t343800\t\t\n\tLocate\t\tArea\t343900\t\t\n\tPursue\t\tLine\t344000\t\t\nSpace Debris\t\t\t\t350000\t\t\n\tMan Made Space Debris\t\t\t350100\t\t\n\t\tMan Made Space Debris Small\tPoint\t350101\t\t\n\t\tMan Made Space Debris Medium\tPoint\t350102\t\t\n\t\tMan Made Space Debris Big\tPoint\t350103\t\t\n\tNatural Space Debris\t\t\t350200\t\t\n\t\tNatural Space Debris Small\tPoint\t350201\t\t\n\t\tNatural Space Debris Medium\tPoint\t350202\t\t\n\t\tNatural Space Debris Big\tPoint\t350203\t\t";

  var mil_std_2525d_control_measure_m1 = "First Modifier\tCapability\tCode\tRemarks\r\nUnspecified\t\t00\t\r\nWheeled limited cross country \tMobility\t01\t\r\nWheeled cross country \tMobility\t02\t\r\nTracked \tMobility\t03\t\r\nWheeled and tracked combination \tMobility\t04\t\r\nTowed\tMobility\t05\t\r\nRail\tMobility\t06\t\r\nPack Animals\tMobility\t07\t\r\nNo Vehicles\tMobility\t08\t\r\nOver snow (prime mover)\tMobility\t09\t\r\nSled\tMobility\t10\t\r\nBarge\tMobility\t11\t\r\nAmphibious\tMobility\t12\t\r\nUnspecified Mine\tObstacles\t13\t\r\nAntipersonnel Mine\tObstacles\t14\t\r\nAntipersonnel Mine with Directional Effects\tObstacles\t15\t\r\nAntitank Mine\tObstacles\t16\t\r\nAntitank Mine with Antihandling Device\tObstacles\t17\t\r\nWide Area Antitank Mine\tObstacles\t18\t\r\nMine Cluster\tObstacles\t19\t\r\nAntipersonnel Mine and Antipersonnel Mine with Directional Effects\tObstacles\t20\t\r\nAntipersonnel Mine and Antitank Mine\tObstacles\t21\t\r\nAntipersonnel Mine and Antitank Mine with Antihandling Device\tObstacles\t22\t\r\nAntipersonnel Mine and Wide Area Antitank Mine\tObstacles\t23\t\r\nAntipersonnel Mine and Mine Cluster\tObstacles\t24\t\r\nAntipersonnel Mine with Directional Effects and Antitank Mine\tObstacles\t25\t\r\nAntipersonnel Mine with Directional Effects and Antitank Mine with Antihandling Device\tObstacles\t26\t\r\nAntipersonnel Mine with Directional Effects and Wide Area Antitank Mine\tObstacles\t27\t\r\nAntipersonnel Mine with Directional Effects and Mine Cluster\tObstacles\t28\t\r\nAntitank Mine and Antitank Mine with Antihandling Device\tObstacles\t29\t\r\nAntitank Mine and Wide Area Antitank Mine\tObstacles\t30\t\r\nAntitank Mine and Mine Cluster\tObstacles\t31\t\r\nAntitank Mine with Antihandling Device and Wide Area Antitank Mine\tObstacles\t32\t\r\nAntitank Mine with Antihandling Device and Mine Cluster\tObstacles\t33\t\r\nWide Area Antitank Mine and Mine Cluster\tObstacles\t34\t\r\nAntipersonnel Mine, Antipersonnel Mine with Directional Effects, and Antitank Mine\tObstacles\t35\t\r\nAntipersonnel Mine, Antipersonnel Mine with Directional Effects, and Antitank Mine with Antihandling Device\tObstacles\t36\t\r\nAntipersonnel Mine, Antipersonnel Mine with Directional Effects, and Wide Area Antitank Mine\tObstacles\t37\t\r\nAntipersonnel Mine, Antipersonnel Mine with Directional Effects, and Mine Cluster\tObstacles\t38\t\r\nAntipersonnel Mine, Antitank Mine, and Antitank Mine with Antihandling Device\tObstacles\t39\t\r\nAntipersonnel Mine, Antitank Mine, and Wide Area Antitank Mine\tObstacles\t40\t\r\nAntipersonnel Mine, Antitank Mine, and Mine Cluster\tObstacles\t41\t\r\nAntipersonnel Mine, Antitank Mine with Antihandling Device, and Wide Area Antitank Mine\tObstacles\t42\t\r\nAntipersonnel Mine, Antitank Mine with Antihandling Device, and Mine Cluster\tObstacles\t43\t\r\nAntipersonnel Mine, Wide Area Antitank Mine, and Mine Cluster\tObstacles\t44\t\r\nAntipersonnel Mine with Directional Effects, Antitank Mine, and Antitank Mine with Antihandling Device\tObstacles\t45\t\r\nAntipersonnel Mine with Directional Effects, Antitank Mine, and Wide Area Antitank Mine\tObstacles\t46\t\r\nAntipersonnel Mine with Directional Effects, Antitank Mine, and Mine Cluster\tObstacles\t47\t\r\nAntipersonnel Mine with Directional Effects, Antitank Mine with Antihandling Device, and Wide Area Antitank Mine\tObstacles\t48\t\r\nAntipersonnel Mine with Directional Effects, Antitank Mine with Antihandling Device, and Mine Cluster\tObstacles\t49\t\r\nAntipersonnel Mine with Directional Effects, Wide Area Antitank Mine, and Mine Cluster\tObstacles\t50\t\r\n{Reserved for future use}\t\t51-99\t\r\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_sea_surface_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nMilitary\t\t\t110000\tReserved for hierarchical purposes.\nMilitary Combatant\t\t\t120000\tReserved for hierarchical purposes.\n\tCarrier\t\t120100\t\n\tSurface Combatant, Line\t\t120200\t\n\t\tBattleship\t120201\t\n\t\tCruiser\t120202\t\n\t\tDestroyer\t120203\t\n\t\tFrigate\t120204\t\n\t\tCorvette\t120205\t\n\t\tLittoral Combatant Ship\t120206\t\n\tAmphibious Warfare Ship\t\t120300\t\n\t\tAmphibious Command Ship\t120301\t\n\t\tAmphibious Assault, Non-specified\t120302\t\n\t\tAmphibious Assault Ship, General\t120303\t\n\t\tAmphibious Assault Ship, Multipurpose\t120304\t\n\t\tAmphibious Assault Ship, Helicopter\t120305\t\n\t\tAmphibious Transport Dock\t120306\t\n\t\tLanding Ship\t120307\t\n\t\tLanding Craft\t120308\t\n\tMine Warfare Ship\t\t120400\t\n\t\tMine Layer\t120401\t\n\t\tMine Sweeper\t120402\t\n\t\tMine Sweeper, Drone\t120403\t\n\t\tMine Hunter\t120404\t\n\t\tMine Countermeasures\t120405\t\n\t\tMine Countermeasures, Support Ship\t120406\t\n\tPatrol Boat\t\t120500\t\n\t\tPatrol Craft, Submarine Chaser/Escort, General\t120501\t\n\t\tPatrol Ship, General\t120502\t\n\tDecoy\t\t120600\t\n\tUnmanned Surface Water Vehicle (USV)\t\t120700\t\n\tSpeedboat\t\t120800\t\n\t\tRigid–Hull Inflatable Boat (RHIB)\t120801\t\n\tJet Ski\t\t120900\t\n\tNavy Task Organization\t\t121000\t\n\t\tNavy Task Element\t121001\t\n\t\tNavy Task Force\t121002\t\n\t\tNavy Task Group\t121003\t\n\t\tNavy Task Unit\t121004\t\n\t\tConvoy\t121005\t\n\tSea-Based X-Band Radar\t\t121100\t\nMilitary Non Combatant\t\t\t130000\tReserved for hierarchical purposes.\n\tAuxiliary Ship\t\t130100\t\n\t\tAmmunition Ship\t130101\t\n\t\tNaval Stores Ship\t130102\t\n\t\tAuxiliary Flag Ship\t130103\t\n\t\tIntelligence Collector\t130104\t\n\t\tOceanographic Research Ship\t130105\t\n\t\tSurvey Ship\t130106\t\n\t\tHospital Ship\t130107\t\n\t\tNaval Cargo Ship\t130108\t\n\t\tCombat Support Ship, Fast\t130109\t\n\t\tOiler, Replenishment\t130110\t\n\t\tRepair Ship\t130111\t\n\t\tSubmarine Tender\t130112\t\n\t\tTug, Ocean Going\t130113\t\n\tService Craft/Yard\t\t130200\t\n\t\tBarge, not Self–Propelled\t130201\t\n\t\tBarge, Self–Propelled\t130202\t\n\t\tTug, Harbor\t130203\t\n\t\tLaunch\t130204\t\nCivilian\t\t\t140000\t\n\tMerchant Ship\t\t140100\t\n\t\tCargo, General\t140101\t\n\t\tContainer Ship\t140102\t\n\t\tDredge\t140103\t\n\t\tRoll On/Roll Off\t140104\t\n\t\tFerry\t140105\t\n\t\tHeavy Lift\t140106\t\n\t\tHovercraft\t140107\t\n\t\tLash Carrier (with Barges)\t140108\t\n\t\tOiler/Tanker\t140109\t\n\t\tPassenger\t140110\t\n\t\tTug, Ocean Going\t140111\t\n\t\tTow\t140112\t\n\t\tTransport Ship, Hazardous Material\t140113\t\n\t\tJunk/Dhow\t140114\t\n\t\tBarge, not Self–Propelled\t140115\t\n\t\tHospital Ship\t140116\t\n\tFishing Vessel\t\t140200\t\n\t\tDrifter\t140201\t\n\t\tTrawler\t140202\t\n\t\tDredger\t140203\t\n\tLaw Enforcement Vessel\t\t140300\t\n\tLeisure Craft, Sailing\t\t140400\t\n\tLeisure Craft, Motorized\t\t140500\t\n\t\tRigid–Hull Inflatable Boat (RHIB)\t140501\t\n\t\tSpeedboat\t140502\t\n\tJet Ski\t\t140600\t\n\tUnmanned Surface Water Vehicle (USV)\t\t140700\t\nOwn Ship\t\t\t150000\t\nFused Track\t\t\t160000\tAll fused tracks shall have a pending standard identity frame.\nManual Track\t\t\t170000\t";

  var mil_std_2525d_sea_surface_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\tMission Area\t00\t\nOwn Ship\tMission Area\t01\tAPP6\nAntiair Warfare\tMission Area\t02\t\nAntisubmarine Warfare\tMission Area\t03\t\nEscort\tMission Area\t04\t\nElectronic Warfare\tMission Area\t05\t\nIntelligence, Surveillance, Reconnaissance\tMission Area\t06\t\nMine Countermeasures\tMission Area\t07\t\nMissile Defense\tMission Area\t08\t\nMedical\tMission Area\t09\t\nMine Warfare\tMission Area\t10\t\nRemote Mult-imission Vehicle (RMV)\tMission Area\t11\tUS only\nSpecial Operations Forces (SOF)\tAsset Capability\t12\t\nSurface Warfare\tMission Area\t13\t\nBallistic Missile \tWeapons Capability\t14\t\nGuided Missile \tWeapons Capability\t15\t\nOther Guided Missile \tWeapons Capability\t16\t\nTorpedo\tWeapons Capability\t17\t\nDrone–Equipped\tAsset Capability\t18\t\nHelicopter–Equipped/VSTOL\tAsset Capability\t19\t\nBallistic Missile Defense, Shooter \tMission Area\t20\t\nBallistic Missile Defense, Long-Range Surveillance and Track (LRS&T)\tMission Area\t21\t\nSea-Base X-Band\tMission Area\t22\tUsed with SBX Radar (Code: 121100) only\nHijacking/Hijacked\tCrime\t23\t\nHijacker\tCrime\t24\t\nCyberspace\tCapability\t25\t\n{Reserved for future use}\t\t26-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_sea_surface_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nNuclear Powered\tShip Propulsion\t01\t\nHeavy\tShip Capacity\t02\t\nLight\tShip Capacity\t03\t\nMedium\tShip Capacity\t04\t\nDock\tCargo Capacity\t05\t\nLogistics\tCargo Capacity\t06\t\nTank\tCargo Capacity\t07\t\nVehicle\tCargo Capacity\t08\t\nFast\tShip Mobility\t09\t\nAir–Cushioned (US)\tShip Mobility\t10\t\nAir–Cushioned (NATO)\tShip Mobility\t11\t\nHydrofoil\tShip Mobility\t12\t\nAutonomous Control\tUSV Control\t13\tUsed with USV only.\nRemotely Piloted\tUSV Control\t14\tUsed with USV only.\nExpendable\tUSV Control\t15\tUsed with USV only.\nCyberspace\tCapability\t16\t\n{Reserved for future use}\t\t17-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_sea_subsurface_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nMilitary\t\t\t110000\t\n\tSubmarine\t\t110100\t\n\t\tSubmarine, Surfaced\t110101\t\n\t\tSubmarine, Snorkeling\t110102\t\n\t\tSubmarine, Bottomed\t110103\t\n\tOther Submersible\t\t110200\t\n\tNonsubmarine\t\t110300\t\n\tAutonomous Underwater Vehicle (AUV)/Unmanned Underwater Vehicle (UUV)\t\t110400\t\n\tDiver\t\t110500\t\nCivilian\t\t\t120000\t\n\tSubmersible\t\t120100\t\n\tAutonomous Underwater Vehicle (AUV)/ Unmanned Underwater Vehicle (UUV)\t\t120200\t\n\tDiver\t\t120300\t\nWeapon\t\t\t130000\t\n\tTorpedo\t\t130100\t\n\tImprovised Explosive Device (IED)\t\t130200\tUsed with hostile standard identity only.\n\tDecoy\t\t130300\t\nEcho Tracker Classifier (ETC) / Possible Contact (POSCON)\t\t\t140000\tAll ETC/POSCON tracks shall have a pending standard identity frame.\nFused Track\t\t\t150000\tAll fused tracks shall have a pending standard identity frame.\nManual Track\t\t\t160000\t";

  var mil_std_2525d_sea_subsurface_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAntisubmarine Warfare\tMission Area\t01\t\nAuxiliary\tMission Area\t02\tUsed with SUBMARINE entity type only.\nCommand and Control\tMission Area\t03\tUsed with SUBMARINE entity type only.\nIntelligence, Surveillance, Reconnaissance\tMission Area\t04\t\nMine Countermeasures\tMission Area\t05\t\nMine Warfare\tMission Area\t06\t\nSurface Warfare\tMission Area\t07\t\nAttack\tWeapons Capability\t08\tUsed with SUBMARINE entity type only.\nBallistic Missile \tWeapons Capability\t09\tUsed with SUBMARINE entity type only.\nGuided Missile \tWeapons Capability\t10\tUsed with SUBMARINE entity type only.\nOther Guided Missile\tWeapons Capability\t11\tUsed with SUBMARINE entity type only.\nSpecial Operations Forces (SOF)\tAsset Capability\t12\tUsed with SUBMARINE entity type only.\nPossible Submarine Low 1 \tSubmarine Confidence\t13\tUsed with SUBMARINE entity type only.\nPossible Submarine Low 2\tSubmarine Confidence\t14\tUsed with SUBMARINE entity type only.\nPossible Submarine High 3\tSubmarine Confidence\t15\tUsed with SUBMARINE entity type only.\nPossible Submarine High 4\tSubmarine Confidence\t16\tUsed with SUBMARINE entity type only.\nProbable Submarine\tSubmarine Confidence\t17\tUsed with SUBMARINE entity type only.\nCertain Submarine\tSubmarine Confidence\t18\tUsed with SUBMARINE entity type only.\nAnti-torpedo Torpedo\tWeapons Capability\t19\tUsed with SUBMARINE entity type only.\nHijacking/Hijacked\tCrime\t20\t\nHijacker\tCrime\t21\t\nCyberspace\tCapability\t22\t\n{Reserved for future use}\t\t23-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_sea_subsurface_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAir Independent Propulsion\tShip Propulsion\t01\tUsed with SUBMARINE entity type only.\nDiesel Electric, General\tShip Propulsion\t02\tUsed with SUBMARINE entity type only.\nDiesel – Type 1\tShip Propulsion\t03\tUsed with SUBMARINE entity type only.\nDiesel – Type 2\tShip Propulsion\t04\tUsed with SUBMARINE entity type only.\nDiesel – Type 3\tShip Propulsion\t05\tUsed with SUBMARINE entity type only.\nNuclear Powered, General\tShip Propulsion\t06\tUsed with SUBMARINE entity type only.\nNuclear – Type 1\tShip Propulsion\t07\tUsed with SUBMARINE entity type only.\nNuclear – Type 2\tShip Propulsion\t08\tUsed with SUBMARINE entity type only.\nNuclear – Type 3\tShip Propulsion\t09\tUsed with SUBMARINE entity type only.\nNuclear – Type 4\tShip Propulsion\t10\tUsed with SUBMARINE entity type only.\nNuclear – Type 5\tShip Propulsion\t11\tUsed with SUBMARINE entity type only.\nNuclear – Type 6\tShip Propulsion\t12\tUsed with SUBMARINE entity type only.\nNuclear – Type 7\tShip Propulsion\t13\tUsed with SUBMARINE entity type only.\nAutonomous Control\tUUV Control\t14\tUsed with AUV/UUV entity type only.\nRemotely Piloted\tUUV Control\t15\tUsed with AUV/UUV entity type only.\nExpendable\tUUV Control\t16\tUsed with AUV/UUV entity type only.\nCyberspace\tCapability\t17\t\n{Reserved for future use}\t\t18-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_mine_warfare_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nSea Mine, General\t\t\t110000\t\n\tSea Mine, Bottom\t\t110100\t\n\tSea Mine, Moored\t\t110200\t\n\tSea Mine, Floating\t\t110300\t\n\tSea Mine, Rising\t\t110400\t\n\tSea Mine, Other Position\t\t110500\t\n\tKingfisher\t\t110600\t\n\tSmall Object, Mine–Like\t\t110700\t\n\tExercise Mine, General\t\t110800\tUsed with exercise frame only.\n\t\tExercise Mine, Bottom\t110801\tUsed with exercise frame only.\n\t\tExercise Mine, Moored\t110802\tUsed with exercise frame only.\n\t\tExercise Mine, Floating\t110803\tUsed with exercise frame only.\n\t\tExercise Mine, Rising\t110804\tUsed with exercise frame only.\n\tNeutralized Mine, General\t\t110900\t\n\t\tNeutralized Mine, Bottom\t110901\t\n\t\tNeutralized Mine, Moored\t110902\t\n\t\tNeutralized Mine, Floating\t110903\t\n\t\tNeutralized Mine, Rising\t110904\t\n\t\tNeutralized Mine, Other Position\t110905\t\nUnexploded Ordnance\t\t\t120000\t\nSea Mine Decoy\t\t\t130000\t\n\tSea Mine Decoy, Bottom\t\t130100\t\n\tSea Mine Decoy, Moored\t\t130200\t\nMine–Like Contact (MILCO)\t\t\t140000\t\n\tMILCO - General\t\t140100\t\n\t\tMILCO - General, Confidence Level 1\t140101\t\n\t\tMILCO - General, Confidence Level 2\t140102\t\n\t\tMILCO - General, Confidence Level 3\t140103\t\n\t\tMILCO - General, Confidence Level 4\t140104\t\n\t\tMILCO - General, Confidence Level 5\t140105\t\n\tMILCO - Bottom\t\t140200\t\n\t\tMILCO - Bottom, Confidence Level 1\t140201\t\n\t\tMILCO - Bottom, Confidence Level 2\t140202\t\n\t\tMILCO - Bottom, Confidence Level 3\t140203\t\n\t\tMILCO - Bottom, Confidence Level 4\t140204\t\n\t\tMILCO - Bottom, Confidence Level 5\t140205\t\n\tMILCO - Moored\t\t140300\t\n\t\tMILCO - Moored, Confidence Level 1\t140301\t\n\t\tMILCO - Moored, Confidence Level 2\t140302\t\n\t\tMILCO - Moored, Confidence Level 3\t140303\t\n\t\tMILCO - Moored, Confidence Level 4\t140304\t\n\t\tMILCO - Moored, Confidence Level 5\t140305\t\n\tMILCO - Floating\t\t140400\t\n\t\tMILCO - Floating, Confidence Level 1\t140401\t\n\t\tMILCO - Floating, Confidence Level 2\t140402\t\n\t\tMILCO - Floating, Confidence Level 3\t140403\t\n\t\tMILCO - Floating, Confidence Level 4\t140404\t\n\t\tMILCO - Floating, Confidence Level 5\t140405\t\nMine–Like Echo (MILEC), General\t\t\t150000\t\n\tMine–Like Echo, Bottom\t\t150100\t\n\tMine–Like Echo, Moored\t\t150200\t\n\tMine–Like Echo, Floating\t\t150300\t\nNegative Reacquisition, General\t\t\t160000\t\n\tNegative Reacquisition, Bottom\t\t160100\t\n\tNegative Reacquisition, Moored\t\t160200\t\n\tNegative Reacquisition, Floating\t\t160300\t\nObstructor\t\t\t170000\t\n\tNeutralized Obstructor\t\t170100\t\nGeneral Mine Anchor\t\t\t180000\t\nNon-Mine Mine–Like Object (NMLO), General\t\t\t190000\t\n\tNon-Mine Mine–Like Object, Bottom\t\t190100\t\n\tNon-Mine Mine–Like Object, Moored\t\t190200\t\n\tNon-Mine Mine–Like Object, Floating\t\t190300\t\nEnvironmental Report Location\t\t\t200000\t\nDive Report Location\t\t\t210000\t";

  var mil_std_2525d_activities_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nIncident\t\t\t110000\tReserved for hierarchical purposes.\n\tCriminal Activity Incident\t\t110100\t\n\t\tArrest\t110101\t\n\t\tArson\t110102\t\n\t\tAttempted Criminal Activity\t110103\tAPP-6C\n\t\tDrive-by Shooting\t110104\t\n\t\tDrug Related\t110105\tAPP-6C\n\t\tExtortion\t110106\t\n\t\tGraffiti\t110107\t\n\t\tKilling\t110108\t\n\t\tPoisoning\t110109\t\n\t\tCivil Rioting\t110110\t\n\t\tBooby Trap\t110111\t\n\t\tHome Eviction\t110112\t\n\t\tBlack Marketing\t110113\t\n\t\tVandalism/Loot/Ransack/Plunder\t110114\t\n\t\tJail Break\t110115\t\n\t\tRobbery\t110116\t\n\t\tTheft\t110117\t\n\t\tBurglary\t110118\t\n\t\tSmuggling\t110119\t\n\t\tRock Throwing\t110120\t\n\t\tDead Body\t110121\t\n\t\tSabotage\t110122\t\n\t\tSuspicious Activity\t110123\t\n\tBomb/Bombing\t\t110200\t\n\t\tBomb Threat\t110201\t\n\tIED Event\t\t110300\t\n\t\tIED Explosion\t110301\t\n\t\tPremature IED Explosion\t110302\t\n\t\tIED Cache\t110303\t\n\t\tIED Suicide Bomber\t110304\t\n\tShooting\t\t110400\t\n\t\tSniping\t110401\t\n\tIllegal Drug Operation\t\t110500\t\n\t\tTrafficking\t110501\t\n\t\tIllegal Drug Lab\t110502\t\n\tExplosion\t\t110600\t\n\t\tGrenade Explosion\t110601\t\n\t\tIncendiary Explosion\t110602\t\n\t\tMine Explosion\t110603\t\n\t\tMortar Fire Explosion\t110604\t\n\t\tRocket Explosion\t110605\t\n\t\tBomb Explosion\t110606\t\nCivil Disturbance\t\t\t120000\t\n\tDemonstration\t\t120100\t\nOperation\t\t\t130000\tReserved for hierarchical purposes.\n\tPatrolling\t\t130100\t\n\tMilitary Information Support Operation (MISO)\t\t130200\t\n\t\tTV and Radio Propaganda\t130201\t\n\tForaging/Searching\t\t130300\t\n\tRecruitment\t\t130400\tReserved for hierarchical purposes.\n\t\tWilling\t130401\t\n\t\tUnwilling/Coerced\t130402\t\n\tMine Laying\t\t130500\t\n\tSpy\t\t130600\t\n\tWarrant Served\t\t130700\t\n\tExfiltration\t\t130800\t\n\tInfiltration\t\t130900\t\n\tMeeting\t\t131000\t\n\t\tPolling Place/Election\t131001\t\n\tRaid on House\t\t131100\t\n\tEmergency Operation\t\t131200\t\n\t\tEmergency Collection Evacuation Point\t131201\t\n\t\tEmergency Food Distribution\t131202\t\n\t\tEmergency Incident Command Center\t131203\t\n\t\tEmergency Operations Center\t131204\t\n\t\tEmergency Public Information Center\t131205\t\n\t\tEmergency Shelter\t131206\t\n\t\tEmergency Staging Area\t131207\t\n\t\tEmergency Water Distribution Center\t131208\t\n\tEmergency Medical Operation\t\t131300\t\n\t\tEMT Station Location\t131301\t\n\t\tHealth Department Facility\t131302\t\n\t\tMedical Facilities Outpatient\t131303\t\n\t\tMorgue\t131304\t\n\t\tPharmacy\t131305\t\n\t\tTriage\t131306\t\n\tFire Fighting Operation\t\t131400\t\n\t\tFire Hydrant\t131401\t\n\t\tFire Station\t131402\t\n\t\tOther Water Supply Location\t131403\t\n\tLaw Enforcement Operation\t\t131500\t\n\t\tBureau of Alcohol, Tobacco, Firearms and Explosives (ATF) (Department of Justice)\t131501\t\n\t\tBorder Patrol\t131502\t\n\t\tCustoms Service\t131503\t\n\t\tDrug Enforcement Administration (DEA)\t131504\t\n\t\tDepartment of Justice (DOJ)\t131505\t\n\t\tFederal Bureau of Investigation (FBI)\t131506\t\n\t\tPolice\t131507\t\n\t\tPrison\t131508\t\n\t\tUnited States Secret Service(Treas) (USSS)\t131509\t\n\t\tTransportation Security Administration (TSA)\t131510\t\n\t\tCoast Guard\t131511\t\n\t\tUS Marshals Service\t131512\t\n\t\tInternal Security Force\t131513\t\nFire Event\t\t\t140000\t\n\tFire Origin\t\t140100\t\n\tSmoke\t\t140200\t\n\tHot Spot\t\t140300\t\n\tNon-Residential Fire\t\t140400\t\n\tResidential Fire\t\t140500\t\n\tSchool Fire\t\t140600\t\n\tSpecial Needs Fire\t\t140700\t\n\tWild Fire\t\t140800\t\nHazardous Materials\t\t\t150000\tReserved for hierarchical purposes.\n\tHazardous Materials Incident\t\t150100\t\n\t\tChemical Agent\t150101\t\n\t\tCorrosive Material\t150102\t\n\t\tHazardous when Wet\t150103\t\n\t\tExplosive Material\t150104\t\n\t\tFlammable Gas\t150105\t\n\t\tFlammable Liquid\t150106\t\n\t\tFlammable Solid\t150107\t\n\t\tNon-Flammable Gas\t150108\t\n\t\tOrganic Peroxide\t150109\t\n\t\tOxidizer\t150110\t\n\t\tRadioactive Material\t150111\t\n\t\tSpontaneously Combustible Material\t150112\t\n\t\tToxic Gas\t150113\t\n\t\tToxic Infectious Material\t150114\t\n\t\tUnexploded Ordnance\t150115\t\nTransportation Incident\t\t\t160000\tReserved for hierarchical purposes.\n\tAir\t\t160100\t\n\tMarine\t\t160200\t\n\tRail\t\t160300\t\n\tVehicle\t\t160400\t\n\tWheeled Vehicle Explosion\t\t160500\t\nNatural Event\t\t\t170000\tReserved for hierarchical purposes.\n\tGeologic\t\t170100\tReserved for hierarchical purposes.\n\t\tAftershock\t170101\t\n\t\tAvalanche\t170102\t\n\t\tEarthquake Epicenter\t170103\t\n\t\tLandslide\t170104\t\n\t\tSubsidence\t170105\t\n\t\tVolcanic Eruption\t170106\t\n\t\tVolcanic Threat\t170107\t\n\t\tCave Entrance\t170108\t\n\tHydro-Meteorological\t\t170200\tReserved for hierarchical purposes.\n\t\tDrought\t170201\t\n\t\tFlood\t170202\t\n\t\tTsunami\t170203\t\n\tInfestation\t\t170300\tReserved for hierarchical purposes.\n\t\tBird\t170301\t\n\t\tInsect\t170302\t\n\t\tMicrobial\t170303\t\n\t\tReptile\t170304\t\n\t\tRodent\t170305\t\nIndividual\t\t\t180000\tReserved for hierarchical purposes.\n\tReligious Leader\t\t180100\t\n\tSpeaker\t\t180200\t";

  var mil_std_2525d_activities_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAssassination\tCrime\t01\t\nExecution (Wrongful Killing)\tCrime\t02\t\nHijacking/Hijacked\tCrime\t03\t\nHouse–to–House\tMilitary Information Support Operations\t04\t\nKidnapping\tCrime\t05\t\nMurder\tCrime\t06\t\nPiracy\tCrime\t07\t\nRape\tCrime\t08\t\nWritten Military Information Support Operations\tMilitary Information Support Operations\t09\t\nPirate\tCrime\t10\t\nFalse\tIED Category\t11\t\nFind\tIED Category\t12\t\nFound and Cleared\tIED Category\t13\t\nHoax (Decoy)\tIED Category\t14\t\nAttempted\tIncident Qualifier\t15\t\nAccident\tIncident Qualifier\t16\t\nIncident\tIncident Qualifier\t17\t\nTheft\tCrime\t18\t\nHijacker\tCrime\t19\t\nCyberspace\tCapability\t20\t\n{Reserved for future use}\t\t21-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_activities_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nCyberspace\tCapability\t01\t\nSecurity Force Assistance\tCapability\t02\t\n{Reserved for future use}\t\t03-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_signals_intelligence_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nSignal Intercept\t\t\t110000\tReserved for hierarchical purposes.\n\tCommunications\t\t110100\t\n\tJammer\t\t110200\t\n\tRadar\t\t110300\t";

  var mil_std_2525d_signals_intelligence_m1 = "First Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nAnti-Aircraft Fire Control\tRadar\t01\t\nAirborne Search and Bombing\tRadar\t02\t\nAirborne Intercept\tRadar\t03\t\nAltimeter\tRadar\t04\t\nAirborne Reconnaissance and Mapping\tRadar\t05\t\nAir Traffic Control\tRadar\t06\t\nBeacon Transponder (not IFF)\tRadar\t07\t\nBattlefield Surveillance\tRadar\t08\t\nControlled Approach\tRadar\t09\t\nControlled Intercept\tRadar\t10\t\nCellular/Mobile\tCommunications\t11\t\nCoastal Surveillance\tRadar\t12\t\nDecoy/Mimic\tRadar\t13\t\nData Transmission\tRadar\t14\t\nEarth Surveillance\tRadar\t15\t\nEarly Warning\tRadar\t16\t\nFire Control\tRadar\t17\t\nGround Mapping\tRadar\t18\t\nHeight Finding\tRadar\t19\t\nHarbor Surveillance\tRadar\t20\t\nIdentification, Friend or Foe (Interrogator)\tRadar\t21\t\nInstrument Landing System\tRadar\t22\t\nIonospheric Sounding\tRadar\t23\t\nIdentification, Friend or Foe (Transponder)\tRadar\t24\t\nBarrage Jammer\tJammer\t25\t\nClick Jammer\tJammer\t26\t\nDeceptive Jammer\tJammer\t27\t\nFrequency Swept Jammer\tJammer\t28\t\nJammer (general)\tJammer\t29\t\nNoise Jammer\tJammer\t30\t\nPulsed Jammer\tJammer\t31\t\nRepeater Jammer\tJammer\t32\t\nSpot Noise Jammer\tJammer\t33\t\nTransponder Jammer\tJammer\t34\t\nMissile Acquisition\tRadar\t35\t\nMissile Control\tJammer\t36\t\nMissile Downlink\tAir Radar\t37\t\nMeteorological\tRadar\t38\t\nMulti-Function\tJammer\t39\t\nMissile Guidance\tRadar\t40\t\nMissile Homing\tRadar\t41\t\nMissile Tracking\tJammer\t42\t\nNavigational/General\tJammer\t43\t\nNavigational/Distance Measuring Equipment\tJammer\t44\t\nNavigation/Terrain Following\tJammer\t45\t\nNavigational/Weather Avoidance\tJammer\t46\t\nOmni-Line of Sight (LOS)\tJammer\t47\t\nProximity Use\tAir Radar\t48\t\nPoint-to-Point Line of Sight (LOS)\tCommunications\t49\t\nInstrumentation\tRadar\t50\t\nRange Only\tRadar\t51\t\nSonobuoy\tRadar\t52\t\nSatellite Downlink\tCommunications\t53\t\nSpace\tRadar\t54\t\nSurface Search\tRadar\t55\t\nShell Tracking\tLand Radar\t56\t\nSatellite Uplink\tCommunications\t57\t\nTarget Acquisition\tRadar\t58\t\nTarget Illumination\tRadar\t59\t\nTropospheric Scatter\tCommunications\t60\t\nTarget Tracking\tRadar\t61\t\nUnknown\tRadar\t62\t\nVideo Remoting\tRadar\t63\t\nExperimental\tRadar\t64\t\nCyberspace\tCapability\t65\t\n{Reserved for future use}\t\t66-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_signals_intelligence_m2 = "Second Modifier\tCategory\tCode\tRemarks\nUnspecified\t\t00\t\nCyberspace\tCapability\t01\t\n{Reserved for future use}\t\t02-99\t\nVersion Extension Flag\t\t-\t";

  var mil_std_2525d_cyberspace_mainIcon = "Entity\tEntity Type\tEntity Subtype\tCode\tRemarks\nUnspecified\t\t\t000000\t\nBotnet\t\t\t110000\tReserved for hierarchical purposes.\n\tCommand and Control (C2)    \t\t110100\t\n\tHerder \t\t110200\t\n\tCallback Domain\t\t110300\t\n\tZombie \t\t110400\t\nInfection\t\t\t120000\t\n\tAdvanced Persistent Threat  (APT)\t\t120100\t\n\t\tAPT with C2 \t120101\t\n\t\tAPT with Self Propagation\t120102\t\n\t\tAPT with C2 and Self Propagation\t120103\t\n\t\tAPT Other \t120104\t\n\tNon-Advanced Persistent Threat (NAPT)\t\t120200\t\n\t\tNAPT with C2 \t120201\t\n\t\tNAPT with Self Propagation\t120202\t\n\t\tNAPT with C2 and Self Propagation\t120203\t\n\t\tNAPT Other \t120204\t\nHealth and Status  \t\t\t130000\t\n\tNormal\t\t130100\t\n\tNetwork Outage\t\t130200\t\n\tUnknown\t\t130300\t\n\tImpaired\t\t130400\t\nDevice Type  \t\t\t140000\t\n\tCore Router \t\t140100\t\n\tRouter\t\t140200\t\n\tCross Domain Solution    \t\t140300\t\n\tMail Server \t\t140400\t\n\tWeb Server \t\t140500\t\n\tDomain Server\t\t140600\t\n\tFile Server\t\t140700\t\n\tPeer-to-Peer Node\t\t140800\t\n\tFirewall\t\t140900\t\n\tSwitch\t\t141000\t\n\tHost\t\t141100\t\n\tVirtual Private Network (VPN)\t\t141200\t\nDevice Domain  \t\t\t150000\t\n\tDepartment of Defense (DoD)\t\t150100\t\n\tGovernment\t\t150200\t\n\tContractor\t\t150300\t\n\tSupervisory Control and Data Acquisition (SCADA)\t\t150400\t\n\tNon-Government\t\t150500\t\nEffect\t\t\t160000\t\n\tInfection\t\t160100\t\n\tDegradation\t\t160200\t\n\tData Spoofing\t\t160300\t\n\tData Manipulation\t\t160400\t\n\tExfiltration\t\t160500\t\n\tPower Outage\t\t160600\t\n\tNetwork Outage\t\t160700\t\n\tService Outage\t\t160800\t\n\tDevice Outage\t\t160900\t\n";

  //import mil_std_2525d_signals_intelligence_m1 from "./../tsv-tables/2525d/Signals intelligence sector 1.tsv";
  //import mil_std_2525d_sea_subsurface_m2 from "./../tsv-tables/2525d/Sea subsurface sector 2.tsv";

  var _2525d = {
    "01": {
      symbolset: "01",
      name: "Air",
      mainIcon: csv2json(mil_std_2525d_air_mainIcon),
      modifier1: csv2json(mil_std_2525d_air_m1),
      modifier2: csv2json(mil_std_2525d_air_m2)
    },
    "02": {
      symbolset: "02",
      name: "Air missile",
      mainIcon: csv2json(mil_std_2525d_air_missile_mainIcon),
      modifier1: csv2json(mil_std_2525d_air_missile_m1),
      modifier2: csv2json(mil_std_2525d_air_missile_m2)
    },
    "05": {
      symbolset: "05",
      name: "Space",
      mainIcon: csv2json(mil_std_2525d_space_mainIcon),
      modifier1: csv2json(mil_std_2525d_space_m1),
      modifier2: csv2json(mil_std_2525d_space_m2)
    },
    "06": {
      symbolset: "06",
      name: "Space Missile",
      mainIcon: csv2json(mil_std_2525d_space_missile_mainIcon),
      modifier1: csv2json(mil_std_2525d_space_missile_m1),
      modifier2: csv2json(mil_std_2525d_space_missile_m2)
    },
    "10": {
      symbolset: "10",
      name: "Land unit",
      mainIcon: csv2json(mil_std_2525d_land_unit_mainIcon),
      modifier1: csv2json(mil_std_2525d_land_unit_m1),
      modifier2: csv2json(mil_std_2525d_land_unit_m2)
    },
    "11": {
      symbolset: "11",
      name: "Land civilian unit/Organization",
      mainIcon: csv2json(mil_std_2525d_land_civilian_mainIcon),
      modifier1: csv2json(mil_std_2525d_land_civilian_m1),
      modifier2: csv2json(mil_std_2525d_land_civilian_m2)
    },
    "15": {
      symbolset: "15",
      name: "Land equipment",
      mainIcon: csv2json(mil_std_2525d_land_equipment_mainIcon),
      modifier1: csv2json(mil_std_2525d_land_equipment_m1),
      modifier2: csv2json(mil_std_2525d_land_equipment_m2)
    },
    "20": {
      symbolset: "20",
      name: "Land installations",
      mainIcon: csv2json(mil_std_2525d_land_installation_mainIcon),
      modifier1: csv2json(mil_std_2525d_land_installation_m1),
      modifier2: csv2json(mil_std_2525d_land_installation_m2)
    },
    "25": {
      symbolset: "25",
      name: "Control measure",
      mainIcon: csv2json(mil_std_2525d_control_measure_mainIcon),
      modifier1: csv2json(mil_std_2525d_control_measure_m1),
      modifier2: csv2json("")
    },
    "30": {
      symbolset: "30",
      name: "Sea surface",
      mainIcon: csv2json(mil_std_2525d_sea_surface_mainIcon),
      modifier1: csv2json(mil_std_2525d_sea_surface_m1),
      modifier2: csv2json(mil_std_2525d_sea_surface_m2)
    },
    "35": {
      symbolset: "35",
      name: "Sea subsurface",
      mainIcon: csv2json(mil_std_2525d_sea_subsurface_mainIcon),
      modifier1: csv2json(mil_std_2525d_sea_subsurface_m1),
      modifier2: csv2json(mil_std_2525d_sea_subsurface_m2)
    },
    "36": {
      symbolset: "36",
      name: "Mine warfare",
      mainIcon: csv2json(mil_std_2525d_mine_warfare_mainIcon),
      modifier1: csv2json(""),
      modifier2: csv2json("")
    },
    "40": {
      symbolset: "40",
      name: "Activity/Event",
      mainIcon: csv2json(mil_std_2525d_activities_mainIcon),
      modifier1: csv2json(mil_std_2525d_activities_m1),
      modifier2: csv2json(mil_std_2525d_activities_m2)
    },
    "50": {
      symbolset: "50",
      name: "Signals Intelligence – Space",
      mainIcon: csv2json(mil_std_2525d_signals_intelligence_mainIcon),
      modifier1: csv2json(mil_std_2525d_signals_intelligence_m1),
      modifier2: csv2json(mil_std_2525d_signals_intelligence_m2)
    },
    "51": {
      symbolset: "51",
      name: "Signals Intelligence – Air",
      mainIcon: csv2json(mil_std_2525d_signals_intelligence_mainIcon),
      modifier1: csv2json(mil_std_2525d_signals_intelligence_m1),
      modifier2: csv2json(mil_std_2525d_signals_intelligence_m2)
    },
    "52": {
      symbolset: "52",
      name: "Signals Intelligence – Land",
      mainIcon: csv2json(mil_std_2525d_signals_intelligence_mainIcon),
      modifier1: csv2json(mil_std_2525d_signals_intelligence_m1),
      modifier2: csv2json(mil_std_2525d_signals_intelligence_m2)
    },
    "53": {
      symbolset: "53",
      name: "Signals Intelligence – Surface",
      mainIcon: csv2json(mil_std_2525d_signals_intelligence_mainIcon),
      modifier1: csv2json(mil_std_2525d_signals_intelligence_m1),
      modifier2: csv2json(mil_std_2525d_signals_intelligence_m2)
    },
    "54": {
      symbolset: "54",
      name: "Signals Intelligence – Subsurface",
      mainIcon: csv2json(mil_std_2525d_signals_intelligence_mainIcon),
      modifier1: csv2json(mil_std_2525d_signals_intelligence_m1),
      modifier2: csv2json(mil_std_2525d_signals_intelligence_m2)
    },
    "60": {
      symbolset: "60",
      name: "Cyberspace",
      mainIcon: csv2json(mil_std_2525d_cyberspace_mainIcon),
      modifier1: csv2json(""),
      modifier2: csv2json("")
    }
  };

  exports.ms2525b = _2525b;
  exports.ms2525c = _2525c;
  exports.ms2525d = _2525d;

}));
