import { linkSchema } from '@milkdown/preset-commonmark';
import { $ctx, $command } from '@milkdown/utils';
import { tooltipFactory, TooltipProvider } from '@milkdown/plugin-tooltip';
import { editorViewCtx } from '@milkdown/core';
import { posToDOMRect } from '@milkdown/prose';
import { TextSelection } from '@milkdown/prose/state';
import DOMPurify from 'dompurify';
import { h, defineComponent, ref, watch, createApp } from 'vue';
import clsx from 'clsx';
import debounce from 'lodash.debounce';

var __defProp$3 = Object.defineProperty;
var __getOwnPropSymbols$3 = Object.getOwnPropertySymbols;
var __hasOwnProp$3 = Object.prototype.hasOwnProperty;
var __propIsEnum$3 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$3 = (obj, key, value) => key in obj ? __defProp$3(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$3 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$3.call(b, prop))
      __defNormalProp$3(a, prop, b[prop]);
  if (__getOwnPropSymbols$3)
    for (var prop of __getOwnPropSymbols$3(b)) {
      if (__propIsEnum$3.call(b, prop))
        __defNormalProp$3(a, prop, b[prop]);
    }
  return a;
};
function withMeta(plugin, meta) {
  Object.assign(plugin, {
    meta: __spreadValues$3({
      package: "@milkdown/components"
    }, meta)
  });
  return plugin;
}

var __defProp$2 = Object.defineProperty;
var __getOwnPropSymbols$2 = Object.getOwnPropertySymbols;
var __hasOwnProp$2 = Object.prototype.hasOwnProperty;
var __propIsEnum$2 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2 = (obj, key, value) => key in obj ? __defProp$2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2.call(b, prop))
      __defNormalProp$2(a, prop, b[prop]);
  if (__getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(b)) {
      if (__propIsEnum$2.call(b, prop))
        __defNormalProp$2(a, prop, b[prop]);
    }
  return a;
};
const defaultState = {
  mode: "preview"
};
const linkTooltipState = $ctx(__spreadValues$2({}, defaultState), "linkTooltipStateCtx");
withMeta(linkTooltipState, {
  displayName: "State<link-tooltip>",
  group: "LinkTooltip"
});
const defaultAPI = {
  addLink: () => {
  },
  editLink: () => {
  },
  removeLink: () => {
  }
};
const linkTooltipAPI = $ctx(__spreadValues$2({}, defaultAPI), "linkTooltipAPICtx");
withMeta(linkTooltipState, {
  displayName: "API<link-tooltip>",
  group: "LinkTooltip"
});
const defaultConfig = {
  linkIcon: "\u{1F517}",
  editButton: "\u270E",
  removeButton: "\u232B",
  confirmButton: "Confirm \u23CE",
  onCopyLink: () => {
  },
  inputPlaceholder: "Paste link..."
};
const linkTooltipConfig = $ctx(
  __spreadValues$2({}, defaultConfig),
  "linkTooltipConfigCtx"
);
withMeta(linkTooltipState, {
  displayName: "Config<link-tooltip>",
  group: "LinkTooltip"
});

const toggleLinkCommand = $command("ToggleLink", (ctx) => {
  return () => (state) => {
    const { doc, selection } = state;
    const mark = linkSchema.type(ctx);
    const hasLink = doc.rangeHasMark(selection.from, selection.to, mark);
    if (hasLink) {
      ctx.get(linkTooltipAPI.key).removeLink(selection.from, selection.to);
      return true;
    }
    ctx.get(linkTooltipAPI.key).addLink(selection.from, selection.to);
    return true;
  };
});

const linkPreviewTooltip = tooltipFactory("LINK_PREVIEW");
withMeta(linkPreviewTooltip[0], {
  displayName: "PreviewTooltipSpec<link-tooltip>",
  group: "LinkTooltip"
});
withMeta(linkPreviewTooltip[1], {
  displayName: "PreviewTooltipPlugin<link-tooltip>",
  group: "LinkTooltip"
});
const linkEditTooltip = tooltipFactory("LINK_EDIT");
withMeta(linkEditTooltip[0], {
  displayName: "EditTooltipSpec<link-tooltip>",
  group: "LinkTooltip"
});
withMeta(linkEditTooltip[1], {
  displayName: "EditTooltipPlugin<link-tooltip>",
  group: "LinkTooltip"
});

function Icon({ icon, class: className, onClick }) {
  return /* @__PURE__ */ h(
    "span",
    {
      class: clsx("milkdown-icon", className),
      onPointerdown: onClick,
      ref: (el) => {
        if (el && icon) {
          el.innerHTML = DOMPurify.sanitize(icon.trim());
        }
      }
    }
  );
}
Icon.props = {
  icon: {
    type: String,
    required: false
  },
  class: {
    type: String,
    required: false
  },
  onClick: {
    type: Function,
    required: false
  }
};

const EditLink = defineComponent({
  props: {
    config: {
      type: Object,
      required: true
    },
    src: {
      type: Object,
      required: true
    },
    onConfirm: {
      type: Function,
      required: true
    },
    onCancel: {
      type: Function,
      required: true
    }
  },
  setup({ config, src, onConfirm, onCancel }) {
    const link = ref(src);
    watch(src, (value) => {
      link.value = value;
    });
    const onConfirmEdit = () => {
      onConfirm(link.value);
    };
    const onKeydown = (e) => {
      e.stopPropagation();
      if (e.key === "Enter") {
        e.preventDefault();
        onConfirmEdit();
      }
      if (e.key === "Escape") {
        e.preventDefault();
        onCancel();
      }
    };
    return () => {
      return /* @__PURE__ */ h("div", { class: "link-edit" }, /* @__PURE__ */ h(
        "input",
        {
          class: "input-area",
          placeholder: config.value.inputPlaceholder,
          onKeydown,
          onInput: (e) => {
            link.value = e.target.value;
          },
          value: link.value
        }
      ), link.value ? /* @__PURE__ */ h(
        Icon,
        {
          class: "button confirm",
          icon: config.value.confirmButton,
          onClick: onConfirmEdit
        }
      ) : null);
    };
  }
});

var __defProp$1 = Object.defineProperty;
var __defProps$1 = Object.defineProperties;
var __getOwnPropDescs$1 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __typeError$1 = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1.call(b, prop))
      __defNormalProp$1(a, prop, b[prop]);
  if (__getOwnPropSymbols$1)
    for (var prop of __getOwnPropSymbols$1(b)) {
      if (__propIsEnum$1.call(b, prop))
        __defNormalProp$1(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1 = (a, b) => __defProps$1(a, __getOwnPropDescs$1(b));
var __accessCheck$1 = (obj, member, msg) => member.has(obj) || __typeError$1("Cannot " + msg);
var __privateGet$1 = (obj, member, getter) => (__accessCheck$1(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd$1 = (obj, member, value) => member.has(obj) ? __typeError$1("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet$1 = (obj, member, value, setter) => (__accessCheck$1(obj, member, "write to private field"), member.set(obj, value), value);
var _content$1, _provider$1, _data, _app$1, _config$1, _src$1, _reset, _confirmEdit, _enterEditMode;
const defaultData = {
  from: -1,
  to: -1,
  mark: null
};
class LinkEditTooltip {
  constructor(ctx, view) {
    this.ctx = ctx;
    __privateAdd$1(this, _content$1);
    __privateAdd$1(this, _provider$1);
    __privateAdd$1(this, _data, __spreadValues$1({}, defaultData));
    __privateAdd$1(this, _app$1);
    __privateAdd$1(this, _config$1);
    __privateAdd$1(this, _src$1, ref(""));
    __privateAdd$1(this, _reset, () => {
      __privateGet$1(this, _provider$1).hide();
      this.ctx.update(linkTooltipState.key, (state) => __spreadProps$1(__spreadValues$1({}, state), {
        mode: "preview"
      }));
      __privateSet$1(this, _data, __spreadValues$1({}, defaultData));
    });
    __privateAdd$1(this, _confirmEdit, (href) => {
      const view = this.ctx.get(editorViewCtx);
      const { from, to, mark } = __privateGet$1(this, _data);
      const type = linkSchema.type(this.ctx);
      const link = DOMPurify.sanitize(href);
      if (mark && mark.attrs.href === link) {
        __privateGet$1(this, _reset).call(this);
        return;
      }
      const tr = view.state.tr;
      if (mark) tr.removeMark(from, to, mark);
      tr.addMark(from, to, type.create({ href: link }));
      view.dispatch(tr);
      __privateGet$1(this, _reset).call(this);
    });
    __privateAdd$1(this, _enterEditMode, (value, from, to) => {
      const config = this.ctx.get(linkTooltipConfig.key);
      __privateGet$1(this, _config$1).value = config;
      __privateGet$1(this, _src$1).value = value;
      this.ctx.update(linkTooltipState.key, (state) => __spreadProps$1(__spreadValues$1({}, state), {
        mode: "edit"
      }));
      const view = this.ctx.get(editorViewCtx);
      view.dispatch(
        view.state.tr.setSelection(TextSelection.create(view.state.doc, from, to))
      );
      __privateGet$1(this, _provider$1).show({
        getBoundingClientRect: () => posToDOMRect(view, from, to)
      });
      requestAnimationFrame(() => {
        var _a;
        (_a = __privateGet$1(this, _content$1).querySelector("input")) == null ? void 0 : _a.focus();
      });
    });
    this.update = (view) => {
      const { state } = view;
      const { selection } = state;
      if (!(selection instanceof TextSelection)) return;
      const { from, to } = selection;
      if (from === __privateGet$1(this, _data).from && to === __privateGet$1(this, _data).to) return;
      __privateGet$1(this, _reset).call(this);
    };
    this.destroy = () => {
      __privateGet$1(this, _app$1).unmount();
      __privateGet$1(this, _provider$1).destroy();
      __privateGet$1(this, _content$1).remove();
    };
    this.addLink = (from, to) => {
      __privateSet$1(this, _data, {
        from,
        to,
        mark: null
      });
      __privateGet$1(this, _enterEditMode).call(this, "", from, to);
    };
    this.editLink = (mark, from, to) => {
      __privateSet$1(this, _data, {
        from,
        to,
        mark
      });
      __privateGet$1(this, _enterEditMode).call(this, mark.attrs.href, from, to);
    };
    this.removeLink = (from, to) => {
      const view = this.ctx.get(editorViewCtx);
      const tr = view.state.tr;
      tr.removeMark(from, to, linkSchema.type(this.ctx));
      view.dispatch(tr);
      __privateGet$1(this, _reset).call(this);
    };
    __privateSet$1(this, _config$1, ref(this.ctx.get(linkTooltipConfig.key)));
    const content = document.createElement("div");
    content.className = "milkdown-link-edit";
    const app = createApp(EditLink, {
      config: __privateGet$1(this, _config$1),
      src: __privateGet$1(this, _src$1),
      onConfirm: __privateGet$1(this, _confirmEdit),
      onCancel: __privateGet$1(this, _reset)
    });
    app.mount(content);
    __privateSet$1(this, _app$1, app);
    __privateSet$1(this, _content$1, content);
    __privateSet$1(this, _provider$1, new TooltipProvider({
      content,
      debounce: 0,
      shouldShow: () => false
    }));
    __privateGet$1(this, _provider$1).onHide = () => {
      requestAnimationFrame(() => {
        view.dom.focus({ preventScroll: true });
      });
    };
    __privateGet$1(this, _provider$1).update(view);
  }
}
_content$1 = new WeakMap();
_provider$1 = new WeakMap();
_data = new WeakMap();
_app$1 = new WeakMap();
_config$1 = new WeakMap();
_src$1 = new WeakMap();
_reset = new WeakMap();
_confirmEdit = new WeakMap();
_enterEditMode = new WeakMap();

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function configureLinkEditTooltip(ctx) {
  let linkEditTooltipView;
  ctx.update(linkTooltipAPI.key, (api) => __spreadProps(__spreadValues({}, api), {
    addLink: (from, to) => {
      linkEditTooltipView == null ? void 0 : linkEditTooltipView.addLink(from, to);
    },
    editLink: (mark, from, to) => {
      linkEditTooltipView == null ? void 0 : linkEditTooltipView.editLink(mark, from, to);
    },
    removeLink: (from, to) => {
      linkEditTooltipView == null ? void 0 : linkEditTooltipView.removeLink(from, to);
    }
  }));
  ctx.set(linkEditTooltip.key, {
    view: (view) => {
      linkEditTooltipView = new LinkEditTooltip(ctx, view);
      return linkEditTooltipView;
    }
  });
}

function findMarkPosition(mark, node, doc, from, to) {
  let markPos = { start: -1, end: -1 };
  doc.nodesBetween(from, to, (n, pos) => {
    if (markPos.start > -1) return false;
    if (markPos.start === -1 && mark.isInSet(n.marks) && node === n) {
      markPos = {
        start: pos,
        end: pos + Math.max(n.textContent.length, 1)
      };
    }
    return void 0;
  });
  return markPos;
}
function shouldShowPreviewWhenHover(ctx, view, event) {
  const $pos = view.posAtCoords({ left: event.clientX, top: event.clientY });
  if (!$pos) return;
  const { pos } = $pos;
  const node = view.state.doc.nodeAt(pos);
  if (!node) return;
  const mark = node.marks.find(
    (mark2) => mark2.type === linkSchema.mark.type(ctx)
  );
  if (!mark) return;
  const key = linkPreviewTooltip.pluginKey();
  if (!key) return;
  return { show: true, pos, node, mark };
}

const PreviewLink = defineComponent({
  props: {
    config: {
      type: Object,
      required: true
    },
    src: {
      type: Object,
      required: true
    },
    onEdit: {
      type: Object,
      required: true
    },
    onRemove: {
      type: Object,
      required: true
    }
  },
  setup({ config, src, onEdit, onRemove }) {
    const onClickEditButton = (e) => {
      e.preventDefault();
      e.stopPropagation();
      onEdit.value();
    };
    const onClickRemoveButton = (e) => {
      e.preventDefault();
      e.stopPropagation();
      onRemove.value();
    };
    const onClickPreview = (e) => {
      e.preventDefault();
      const link = src.value;
      if (navigator.clipboard && link) {
        navigator.clipboard.writeText(link).then(() => {
          config.value.onCopyLink(link);
        }).catch((e2) => console.error(e2));
      }
    };
    return () => {
      return /* @__PURE__ */ h("div", { class: "link-preview" }, /* @__PURE__ */ h(
        Icon,
        {
          class: "button link-icon",
          icon: config.value.linkIcon,
          onClick: onClickPreview
        }
      ), /* @__PURE__ */ h("a", { href: src.value, target: "_blank", class: "link-display" }, src.value), /* @__PURE__ */ h(
        Icon,
        {
          class: "button link-edit-button",
          icon: config.value.editButton,
          onClick: onClickEditButton
        }
      ), /* @__PURE__ */ h(
        Icon,
        {
          class: "button link-remove-button",
          icon: config.value.removeButton,
          onClick: onClickRemoveButton
        }
      ));
    };
  }
});

var __typeError = (msg) => {
  throw TypeError(msg);
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), member.set(obj, value), value);
var _content, _provider, _slice, _config, _src, _onEdit, _onRemove, _app, _hovering, _onStateChange, _onMouseEnter, _onMouseLeave, _hide;
class LinkPreviewTooltip {
  constructor(ctx, view) {
    this.ctx = ctx;
    __privateAdd(this, _content);
    __privateAdd(this, _provider);
    __privateAdd(this, _slice, this.ctx.use(linkTooltipState.key));
    __privateAdd(this, _config);
    __privateAdd(this, _src, ref(""));
    __privateAdd(this, _onEdit, ref(() => {
    }));
    __privateAdd(this, _onRemove, ref(() => {
    }));
    __privateAdd(this, _app);
    __privateAdd(this, _hovering, false);
    __privateAdd(this, _onStateChange, ({ mode }) => {
      if (mode === "edit") __privateGet(this, _hide).call(this);
    });
    __privateAdd(this, _onMouseEnter, () => {
      __privateSet(this, _hovering, true);
    });
    __privateAdd(this, _onMouseLeave, () => {
      __privateSet(this, _hovering, false);
    });
    __privateAdd(this, _hide, () => {
      __privateGet(this, _provider).hide();
      __privateGet(this, _provider).element.removeEventListener("mouseenter", __privateGet(this, _onMouseEnter));
      __privateGet(this, _provider).element.removeEventListener("mouseleave", __privateGet(this, _onMouseLeave));
    });
    this.show = (mark, from, to, rect) => {
      __privateGet(this, _config).value = this.ctx.get(linkTooltipConfig.key);
      __privateGet(this, _src).value = mark.attrs.href;
      __privateGet(this, _onEdit).value = () => {
        this.ctx.get(linkTooltipAPI.key).editLink(mark, from, to);
      };
      __privateGet(this, _onRemove).value = () => {
        this.ctx.get(linkTooltipAPI.key).removeLink(from, to);
        __privateGet(this, _hide).call(this);
      };
      __privateGet(this, _provider).show({
        getBoundingClientRect: () => rect
      });
      __privateGet(this, _provider).element.addEventListener("mouseenter", __privateGet(this, _onMouseEnter));
      __privateGet(this, _provider).element.addEventListener("mouseleave", __privateGet(this, _onMouseLeave));
    };
    this.hide = () => {
      if (__privateGet(this, _hovering)) return;
      __privateGet(this, _hide).call(this);
    };
    this.update = () => {
    };
    this.destroy = () => {
      __privateGet(this, _app).unmount();
      __privateGet(this, _slice).off(__privateGet(this, _onStateChange));
      __privateGet(this, _provider).destroy();
      __privateGet(this, _content).remove();
    };
    __privateSet(this, _config, ref(this.ctx.get(linkTooltipConfig.key)));
    __privateSet(this, _app, createApp(PreviewLink, {
      config: __privateGet(this, _config),
      src: __privateGet(this, _src),
      onEdit: __privateGet(this, _onEdit),
      onRemove: __privateGet(this, _onRemove)
    }));
    __privateSet(this, _content, document.createElement("div"));
    __privateGet(this, _content).className = "milkdown-link-preview";
    __privateGet(this, _app).mount(__privateGet(this, _content));
    __privateSet(this, _provider, new TooltipProvider({
      debounce: 0,
      content: __privateGet(this, _content),
      shouldShow: () => false
    }));
    __privateGet(this, _provider).update(view);
    __privateSet(this, _slice, ctx.use(linkTooltipState.key));
    __privateGet(this, _slice).on(__privateGet(this, _onStateChange));
  }
}
_content = new WeakMap();
_provider = new WeakMap();
_slice = new WeakMap();
_config = new WeakMap();
_src = new WeakMap();
_onEdit = new WeakMap();
_onRemove = new WeakMap();
_app = new WeakMap();
_hovering = new WeakMap();
_onStateChange = new WeakMap();
_onMouseEnter = new WeakMap();
_onMouseLeave = new WeakMap();
_hide = new WeakMap();

function configureLinkPreviewTooltip(ctx) {
  let linkPreviewTooltipView;
  const DELAY = 50;
  const onMouseMove = debounce((view, event) => {
    if (!linkPreviewTooltipView) return;
    if (!view.hasFocus()) return;
    const state = ctx.get(linkTooltipState.key);
    if (state.mode === "edit") return;
    const result = shouldShowPreviewWhenHover(ctx, view, event);
    if (result) {
      const position = view.state.doc.resolve(result.pos);
      const markPosition = findMarkPosition(
        result.mark,
        result.node,
        view.state.doc,
        position.before(),
        position.after()
      );
      const from = markPosition.start;
      const to = markPosition.end;
      linkPreviewTooltipView.show(
        result.mark,
        from,
        to,
        posToDOMRect(view, from, to)
      );
      return;
    }
    linkPreviewTooltipView.hide();
  }, DELAY);
  const onMouseLeave = () => {
    setTimeout(() => {
      linkPreviewTooltipView == null ? void 0 : linkPreviewTooltipView.hide();
    }, DELAY);
  };
  ctx.set(linkPreviewTooltip.key, {
    props: {
      handleDOMEvents: {
        mousemove: onMouseMove,
        mouseleave: onMouseLeave
      }
    },
    view: (view) => {
      linkPreviewTooltipView = new LinkPreviewTooltip(ctx, view);
      return linkPreviewTooltipView;
    }
  });
}

function configureLinkTooltip(ctx) {
  configureLinkPreviewTooltip(ctx);
  configureLinkEditTooltip(ctx);
}

const linkTooltipPlugin = [
  linkTooltipState,
  linkTooltipAPI,
  linkTooltipConfig,
  linkPreviewTooltip,
  linkEditTooltip,
  toggleLinkCommand
].flat();

export { configureLinkTooltip, linkEditTooltip, linkPreviewTooltip, linkTooltipAPI, linkTooltipConfig, linkTooltipPlugin, linkTooltipState, toggleLinkCommand };
//# sourceMappingURL=index.js.map
