'use strict';

var block = require('@milkdown/kit/plugin/block');
var ctx = require('@milkdown/kit/ctx');
var core = require('@milkdown/kit/core');
var commonmark = require('@milkdown/kit/preset/commonmark');
var prose = require('@milkdown/kit/prose');
var state = require('@milkdown/kit/prose/state');
var vue = require('vue');
var slash = require('@milkdown/kit/plugin/slash');
var utils = require('@milkdown/kit/utils');
var component = require('@milkdown/kit/component');
var imageBlock = require('@milkdown/kit/component/image-block');
var gfm = require('@milkdown/kit/preset/gfm');

ctx.createSlice([], "FeaturesCtx");
ctx.createSlice({}, "CrepeCtx");
function useCrepeFeatures(ctx) {
  return ctx.use("FeaturesCtx");
}
function crepeFeatureConfig(feature) {
  return (ctx) => {
    useCrepeFeatures(ctx).update((features) => {
      if (features.includes(feature)) {
        return features;
      }
      return [...features, feature];
    });
  };
}

var CrepeFeature = /* @__PURE__ */ ((CrepeFeature2) => {
  CrepeFeature2["CodeMirror"] = "code-mirror";
  CrepeFeature2["ListItem"] = "list-item";
  CrepeFeature2["LinkTooltip"] = "link-tooltip";
  CrepeFeature2["Cursor"] = "cursor";
  CrepeFeature2["ImageBlock"] = "image-block";
  CrepeFeature2["BlockEdit"] = "block-edit";
  CrepeFeature2["Toolbar"] = "toolbar";
  CrepeFeature2["Placeholder"] = "placeholder";
  CrepeFeature2["Table"] = "table";
  CrepeFeature2["Latex"] = "latex";
  return CrepeFeature2;
})(CrepeFeature || {});

const bulletListIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8070)">
      <path
        d="M4 10.5C3.17 10.5 2.5 11.17 2.5 12C2.5 12.83 3.17 13.5 4 13.5C4.83 13.5 5.5 12.83 5.5 12C5.5 11.17 4.83 10.5 4 10.5ZM4 4.5C3.17 4.5 2.5 5.17 2.5 6C2.5 6.83 3.17 7.5 4 7.5C4.83 7.5 5.5 6.83 5.5 6C5.5 5.17 4.83 4.5 4 4.5ZM4 16.5C3.17 16.5 2.5 17.18 2.5 18C2.5 18.82 3.18 19.5 4 19.5C4.82 19.5 5.5 18.82 5.5 18C5.5 17.18 4.83 16.5 4 16.5ZM8 19H20C20.55 19 21 18.55 21 18C21 17.45 20.55 17 20 17H8C7.45 17 7 17.45 7 18C7 18.55 7.45 19 8 19ZM8 13H20C20.55 13 21 12.55 21 12C21 11.45 20.55 11 20 11H8C7.45 11 7 11.45 7 12C7 12.55 7.45 13 8 13ZM7 6C7 6.55 7.45 7 8 7H20C20.55 7 21 6.55 21 6C21 5.45 20.55 5 20 5H8C7.45 5 7 5.45 7 6Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8070">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const codeIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8081)">
      <path
        d="M9.4 16.6L4.8 12L9.4 7.4L8 6L2 12L8 18L9.4 16.6ZM14.6 16.6L19.2 12L14.6 7.4L16 6L22 12L16 18L14.6 16.6Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8081">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const dividerIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_7900)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M19 13H5C4.45 13 4 12.55 4 12C4 11.45 4.45 11 5 11H19C19.55 11 20 11.45 20 12C20 12.55 19.55 13 19 13Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_7900">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h1Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_992_5553)">
      <path
        d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V5H19V19ZM12 17H14V7H10V9H12V17Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_992_5553">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h2Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_992_5559)">
      <path
        d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V5H19V19ZM15 15H11V13H13C14.1 13 15 12.11 15 11V9C15 7.89 14.1 7 13 7H9V9H13V11H11C9.9 11 9 11.89 9 13V17H15V15Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_992_5559">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h3Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_992_5565)">
      <path
        d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V5H19V19ZM15 15V13.5C15 12.67 14.33 12 13.5 12C14.33 12 15 11.33 15 10.5V9C15 7.89 14.1 7 13 7H9V9H13V11H11V13H13V15H9V17H13C14.1 17 15 16.11 15 15Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_992_5565">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h4Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_7757)">
      <path
        d="M19.04 3H5.04004C3.94004 3 3.04004 3.9 3.04004 5V19C3.04004 20.1 3.94004 21 5.04004 21H19.04C20.14 21 21.04 20.1 21.04 19V5C21.04 3.9 20.14 3 19.04 3ZM19.04 19H5.04004V5H19.04V19ZM13.04 17H15.04V7H13.04V11H11.04V7H9.04004V13H13.04V17Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_7757">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h5Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_7760)">
      <path
        d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V5H19V19ZM15 15V13C15 11.89 14.1 11 13 11H11V9H15V7H9V13H13V15H9V17H13C14.1 17 15 16.11 15 15Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_7760">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const h6Icon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_7763)">
      <path
        d="M11 17H13C14.1 17 15 16.11 15 15V13C15 11.89 14.1 11 13 11H11V9H15V7H11C9.9 7 9 7.89 9 9V15C9 16.11 9.9 17 11 17ZM11 13H13V15H11V13ZM19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V5H19V19Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_7763">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const imageIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8075)">
      <path
        d="M19 5V19H5V5H19ZM19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM14.14 11.86L11.14 15.73L9 13.14L6 17H18L14.14 11.86Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8075">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const menuIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_971_7680)">
      <path
        d="M11 18C11 19.1 10.1 20 9 20C7.9 20 7 19.1 7 18C7 16.9 7.9 16 9 16C10.1 16 11 16.9 11 18ZM9 10C7.9 10 7 10.9 7 12C7 13.1 7.9 14 9 14C10.1 14 11 13.1 11 12C11 10.9 10.1 10 9 10ZM9 4C7.9 4 7 4.9 7 6C7 7.1 7.9 8 9 8C10.1 8 11 7.1 11 6C11 4.9 10.1 4 9 4ZM15 8C16.1 8 17 7.1 17 6C17 4.9 16.1 4 15 4C13.9 4 13 4.9 13 6C13 7.1 13.9 8 15 8ZM15 10C13.9 10 13 10.9 13 12C13 13.1 13.9 14 15 14C16.1 14 17 13.1 17 12C17 10.9 16.1 10 15 10ZM15 16C13.9 16 13 16.9 13 18C13 19.1 13.9 20 15 20C16.1 20 17 19.1 17 18C17 16.9 16.1 16 15 16Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_971_7680">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const orderedListIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8067)">
      <path
        d="M8 7H20C20.55 7 21 6.55 21 6C21 5.45 20.55 5 20 5H8C7.45 5 7 5.45 7 6C7 6.55 7.45 7 8 7ZM20 17H8C7.45 17 7 17.45 7 18C7 18.55 7.45 19 8 19H20C20.55 19 21 18.55 21 18C21 17.45 20.55 17 20 17ZM20 11H8C7.45 11 7 11.45 7 12C7 12.55 7.45 13 8 13H20C20.55 13 21 12.55 21 12C21 11.45 20.55 11 20 11ZM4.5 16H2.5C2.22 16 2 16.22 2 16.5C2 16.78 2.22 17 2.5 17H4V17.5H3.5C3.22 17.5 3 17.72 3 18C3 18.28 3.22 18.5 3.5 18.5H4V19H2.5C2.22 19 2 19.22 2 19.5C2 19.78 2.22 20 2.5 20H4.5C4.78 20 5 19.78 5 19.5V16.5C5 16.22 4.78 16 4.5 16ZM2.5 5H3V7.5C3 7.78 3.22 8 3.5 8C3.78 8 4 7.78 4 7.5V4.5C4 4.22 3.78 4 3.5 4H2.5C2.22 4 2 4.22 2 4.5C2 4.78 2.22 5 2.5 5ZM4.5 10H2.5C2.22 10 2 10.22 2 10.5C2 10.78 2.22 11 2.5 11H3.8L2.12 12.96C2.04 13.05 2 13.17 2 13.28V13.5C2 13.78 2.22 14 2.5 14H4.5C4.78 14 5 13.78 5 13.5C5 13.22 4.78 13 4.5 13H3.2L4.88 11.04C4.96 10.95 5 10.83 5 10.72V10.5C5 10.22 4.78 10 4.5 10Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8067">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const plusIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_971_7676)">
      <path
        d="M18 13H13V18C13 18.55 12.55 19 12 19C11.45 19 11 18.55 11 18V13H6C5.45 13 5 12.55 5 12C5 11.45 5.45 11 6 11H11V6C11 5.45 11.45 5 12 5C12.55 5 13 5.45 13 6V11H18C18.55 11 19 11.45 19 12C19 12.55 18.55 13 18 13Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_971_7676">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const quoteIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_7897)">
      <path
        d="M7.17 17C7.68 17 8.15 16.71 8.37 16.26L9.79 13.42C9.93 13.14 10 12.84 10 12.53V8C10 7.45 9.55 7 9 7H5C4.45 7 4 7.45 4 8V12C4 12.55 4.45 13 5 13H7L5.97 15.06C5.52 15.95 6.17 17 7.17 17ZM17.17 17C17.68 17 18.15 16.71 18.37 16.26L19.79 13.42C19.93 13.14 20 12.84 20 12.53V8C20 7.45 19.55 7 19 7H15C14.45 7 14 7.45 14 8V12C14 12.55 14.45 13 15 13H17L15.97 15.06C15.52 15.95 16.17 17 17.17 17Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_7897">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const tableIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8078)">
      <path
        d="M20 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H20C21.1 21 22 20.1 22 19V5C22 3.9 21.1 3 20 3ZM20 5V8H5V5H20ZM15 19H10V10H15V19ZM5 10H8V19H5V10ZM17 19V10H20V19H17Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8078">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const textIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_992_5547)">
      <path
        d="M5 5.5C5 6.33 5.67 7 6.5 7H10.5V17.5C10.5 18.33 11.17 19 12 19C12.83 19 13.5 18.33 13.5 17.5V7H17.5C18.33 7 19 6.33 19 5.5C19 4.67 18.33 4 17.5 4H6.5C5.67 4 5 4.67 5 5.5Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_992_5547">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const todoListIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <path
      d="M5.66936 16.3389L9.39244 12.6158C9.54115 12.4671 9.71679 12.3937 9.91936 12.3957C10.1219 12.3976 10.2975 12.4761 10.4463 12.6312C10.5847 12.7823 10.654 12.9585 10.654 13.1599C10.654 13.3613 10.5847 13.5363 10.4463 13.6851L6.32704 17.8197C6.14627 18.0004 5.93538 18.0908 5.69436 18.0908C5.45333 18.0908 5.24243 18.0004 5.06166 17.8197L3.01744 15.7754C2.87899 15.637 2.81136 15.4629 2.81456 15.2533C2.81776 15.0437 2.88859 14.8697 3.02706 14.7312C3.16551 14.5928 3.34008 14.5235 3.55076 14.5235C3.76144 14.5235 3.93494 14.5928 4.07126 14.7312L5.66936 16.3389ZM5.66936 8.72359L9.39244 5.00049C9.54115 4.85177 9.71679 4.77838 9.91936 4.78031C10.1219 4.78223 10.2975 4.86075 10.4463 5.01586C10.5847 5.16691 10.654 5.34314 10.654 5.54454C10.654 5.74592 10.5847 5.92097 10.4463 6.06969L6.32704 10.2043C6.14627 10.3851 5.93538 10.4755 5.69436 10.4755C5.45333 10.4755 5.24243 10.3851 5.06166 10.2043L3.01744 8.16009C2.87899 8.02162 2.81136 7.84759 2.81456 7.63799C2.81776 7.42837 2.88859 7.25433 3.02706 7.11586C3.16551 6.97741 3.34008 6.90819 3.55076 6.90819C3.76144 6.90819 3.93494 6.97741 4.07126 7.11586L5.66936 8.72359ZM13.7597 16.5581C13.5472 16.5581 13.3691 16.4862 13.2253 16.3424C13.0816 16.1986 13.0097 16.0204 13.0097 15.8078C13.0097 15.5952 13.0816 15.4171 13.2253 15.2735C13.3691 15.13 13.5472 15.0582 13.7597 15.0582H20.7597C20.9722 15.0582 21.1503 15.1301 21.2941 15.2739C21.4378 15.4177 21.5097 15.5959 21.5097 15.8085C21.5097 16.0211 21.4378 16.1992 21.2941 16.3427C21.1503 16.4863 20.9722 16.5581 20.7597 16.5581H13.7597ZM13.7597 8.94276C13.5472 8.94276 13.3691 8.87085 13.2253 8.72704C13.0816 8.58324 13.0097 8.40504 13.0097 8.19244C13.0097 7.97985 13.0816 7.80177 13.2253 7.65819C13.3691 7.5146 13.5472 7.44281 13.7597 7.44281H20.7597C20.9722 7.44281 21.1503 7.51471 21.2941 7.65851C21.4378 7.80233 21.5097 7.98053 21.5097 8.19311C21.5097 8.40571 21.4378 8.5838 21.2941 8.72739C21.1503 8.87097 20.9722 8.94276 20.7597 8.94276H13.7597Z"
    />
  </svg>
`;

const functionsIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="32"
    height="32"
    viewBox="0 0 24 24"
  >
    <path
      fill="currentColor"
      d="M7 19v-.808L13.096 12L7 5.808V5h10v1.25H9.102L14.727 12l-5.625 5.77H17V19z"
    />
  </svg>
`;

function isInCodeBlock(selection) {
  const type = selection.$from.parent.type;
  return type.name === "code_block";
}
function isInList(selection) {
  var _a;
  const type = (_a = selection.$from.node(selection.$from.depth - 1)) == null ? void 0 : _a.type;
  return (type == null ? void 0 : type.name) === "list_item";
}

var __typeError$2 = (msg) => {
  throw TypeError(msg);
};
var __accessCheck$2 = (obj, member, msg) => member.has(obj) || __typeError$2("Cannot " + msg);
var __privateGet$2 = (obj, member, getter) => (__accessCheck$2(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd$2 = (obj, member, value) => member.has(obj) ? __typeError$2("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet$2 = (obj, member, value, setter) => (__accessCheck$2(obj, member, "write to private field"), member.set(obj, value), value);
var _groups, _getGroupInstance;
class GroupBuilder {
  constructor() {
    __privateAdd$2(this, _groups, []);
    this.clear = () => {
      __privateSet$2(this, _groups, []);
      return this;
    };
    __privateAdd$2(this, _getGroupInstance, (group) => {
      const groupInstance = {
        group,
        addItem: (key, item) => {
          const data = { ...item, key };
          group.items.push(data);
          return groupInstance;
        },
        clear: () => {
          group.items = [];
          return groupInstance;
        }
      };
      return groupInstance;
    });
    this.addGroup = (key, label) => {
      const items = [];
      const group = {
        key,
        label,
        items
      };
      __privateGet$2(this, _groups).push(group);
      return __privateGet$2(this, _getGroupInstance).call(this, group);
    };
    this.getGroup = (key) => {
      const group = __privateGet$2(this, _groups).find((group2) => group2.key === key);
      if (!group) throw new Error(`Group with key ${key} not found`);
      return __privateGet$2(this, _getGroupInstance).call(this, group);
    };
    this.build = () => {
      return __privateGet$2(this, _groups);
    };
  }
}
_groups = new WeakMap();
_getGroupInstance = new WeakMap();

function getGroups(filter, config, ctx) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z, __, _$, _aa, _ba, _ca, _da, _ea, _fa, _ga, _ha, _ia, _ja, _ka, _la, _ma, _na, _oa, _pa, _qa, _ra, _sa, _ta, _ua, _va, _wa, _xa, _ya, _za, _Aa, _Ba, _Ca, _Da, _Ea, _Fa, _Ga, _Ha, _Ia, _Ja, _Ka, _La, _Ma, _Na, _Oa, _Pa, _Qa, _Ra, _Sa, _Ta, _Ua, _Va, _Wa, _Xa, _Ya, _Za, __a, _$a, _ab, _bb, _cb, _db, _eb, _fb, _gb, _hb, _ib, _jb, _kb;
  const flags = ctx && useCrepeFeatures(ctx).get();
  const isLatexEnabled = flags == null ? void 0 : flags.includes(CrepeFeature.Latex);
  const isImageBlockEnabled = flags == null ? void 0 : flags.includes(CrepeFeature.ImageBlock);
  const isTableEnabled = flags == null ? void 0 : flags.includes(CrepeFeature.Table);
  const groupBuilder = new GroupBuilder();
  if ((config == null ? void 0 : config.textGroup) !== null) {
    const textGroup = groupBuilder.addGroup(
      "text",
      (_b = (_a = config == null ? void 0 : config.textGroup) == null ? void 0 : _a.label) != null ? _b : "Text"
    );
    if (((_c = config == null ? void 0 : config.textGroup) == null ? void 0 : _c.text) !== null) {
      textGroup.addItem("text", {
        label: (_f = (_e = (_d = config == null ? void 0 : config.textGroup) == null ? void 0 : _d.text) == null ? void 0 : _e.label) != null ? _f : "Text",
        icon: (_i = (_h = (_g = config == null ? void 0 : config.textGroup) == null ? void 0 : _g.text) == null ? void 0 : _h.icon) != null ? _i : textIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const paragraph = commonmark.paragraphSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: paragraph
          });
        }
      });
    }
    if (((_j = config == null ? void 0 : config.textGroup) == null ? void 0 : _j.h1) !== null) {
      textGroup.addItem("h1", {
        label: (_m = (_l = (_k = config == null ? void 0 : config.textGroup) == null ? void 0 : _k.h1) == null ? void 0 : _l.label) != null ? _m : "Heading 1",
        icon: (_p = (_o = (_n = config == null ? void 0 : config.textGroup) == null ? void 0 : _n.h1) == null ? void 0 : _o.icon) != null ? _p : h1Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 1
            }
          });
        }
      });
    }
    if (((_q = config == null ? void 0 : config.textGroup) == null ? void 0 : _q.h2) !== null) {
      textGroup.addItem("h2", {
        label: (_t = (_s = (_r = config == null ? void 0 : config.textGroup) == null ? void 0 : _r.h2) == null ? void 0 : _s.label) != null ? _t : "Heading 2",
        icon: (_w = (_v = (_u = config == null ? void 0 : config.textGroup) == null ? void 0 : _u.h2) == null ? void 0 : _v.icon) != null ? _w : h2Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 2
            }
          });
        }
      });
    }
    if (((_x = config == null ? void 0 : config.textGroup) == null ? void 0 : _x.h3) !== null) {
      textGroup.addItem("h3", {
        label: (_A = (_z = (_y = config == null ? void 0 : config.textGroup) == null ? void 0 : _y.h3) == null ? void 0 : _z.label) != null ? _A : "Heading 3",
        icon: (_D = (_C = (_B = config == null ? void 0 : config.textGroup) == null ? void 0 : _B.h3) == null ? void 0 : _C.icon) != null ? _D : h3Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 3
            }
          });
        }
      });
    }
    if (((_E = config == null ? void 0 : config.textGroup) == null ? void 0 : _E.h4) !== null) {
      textGroup.addItem("h4", {
        label: (_H = (_G = (_F = config == null ? void 0 : config.textGroup) == null ? void 0 : _F.h4) == null ? void 0 : _G.label) != null ? _H : "Heading 4",
        icon: (_K = (_J = (_I = config == null ? void 0 : config.textGroup) == null ? void 0 : _I.h4) == null ? void 0 : _J.icon) != null ? _K : h4Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 4
            }
          });
        }
      });
    }
    if (((_L = config == null ? void 0 : config.textGroup) == null ? void 0 : _L.h5) !== null) {
      textGroup.addItem("h5", {
        label: (_O = (_N = (_M = config == null ? void 0 : config.textGroup) == null ? void 0 : _M.h5) == null ? void 0 : _N.label) != null ? _O : "Heading 5",
        icon: (_R = (_Q = (_P = config == null ? void 0 : config.textGroup) == null ? void 0 : _P.h5) == null ? void 0 : _Q.icon) != null ? _R : h5Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 5
            }
          });
        }
      });
    }
    if (((_S = config == null ? void 0 : config.textGroup) == null ? void 0 : _S.h6) !== null) {
      textGroup.addItem("h6", {
        label: (_V = (_U = (_T = config == null ? void 0 : config.textGroup) == null ? void 0 : _T.h6) == null ? void 0 : _U.label) != null ? _V : "Heading 6",
        icon: (_Y = (_X = (_W = config == null ? void 0 : config.textGroup) == null ? void 0 : _W.h6) == null ? void 0 : _X.icon) != null ? _Y : h6Icon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const heading = commonmark.headingSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: heading,
            attrs: {
              level: 6
            }
          });
        }
      });
    }
    if (((_Z = config == null ? void 0 : config.textGroup) == null ? void 0 : _Z.quote) !== null) {
      textGroup.addItem("quote", {
        label: (_aa = (_$ = (__ = config == null ? void 0 : config.textGroup) == null ? void 0 : __.quote) == null ? void 0 : _$.label) != null ? _aa : "Quote",
        icon: (_da = (_ca = (_ba = config == null ? void 0 : config.textGroup) == null ? void 0 : _ba.quote) == null ? void 0 : _ca.icon) != null ? _da : quoteIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const blockquote = commonmark.blockquoteSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.wrapInBlockTypeCommand.key, {
            nodeType: blockquote
          });
        }
      });
    }
    if (((_ea = config == null ? void 0 : config.textGroup) == null ? void 0 : _ea.divider) !== null) {
      textGroup.addItem("divider", {
        label: (_ha = (_ga = (_fa = config == null ? void 0 : config.textGroup) == null ? void 0 : _fa.divider) == null ? void 0 : _ga.label) != null ? _ha : "Divider",
        icon: (_ka = (_ja = (_ia = config == null ? void 0 : config.textGroup) == null ? void 0 : _ia.divider) == null ? void 0 : _ja.icon) != null ? _ka : dividerIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const hr = commonmark.hrSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.addBlockTypeCommand.key, {
            nodeType: hr
          });
        }
      });
    }
  }
  if ((config == null ? void 0 : config.listGroup) !== null) {
    const listGroup = groupBuilder.addGroup(
      "list",
      (_ma = (_la = config == null ? void 0 : config.listGroup) == null ? void 0 : _la.label) != null ? _ma : "List"
    );
    if (((_na = config == null ? void 0 : config.listGroup) == null ? void 0 : _na.bulletList) !== null) {
      listGroup.addItem("bullet-list", {
        label: (_qa = (_pa = (_oa = config == null ? void 0 : config.listGroup) == null ? void 0 : _oa.bulletList) == null ? void 0 : _pa.label) != null ? _qa : "Bullet List",
        icon: (_ta = (_sa = (_ra = config == null ? void 0 : config.listGroup) == null ? void 0 : _ra.bulletList) == null ? void 0 : _sa.icon) != null ? _ta : bulletListIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const bulletList = commonmark.bulletListSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.wrapInBlockTypeCommand.key, {
            nodeType: bulletList
          });
        }
      });
    }
    if (((_ua = config == null ? void 0 : config.listGroup) == null ? void 0 : _ua.orderedList) !== null) {
      listGroup.addItem("ordered-list", {
        label: (_xa = (_wa = (_va = config == null ? void 0 : config.listGroup) == null ? void 0 : _va.orderedList) == null ? void 0 : _wa.label) != null ? _xa : "Ordered List",
        icon: (_Aa = (_za = (_ya = config == null ? void 0 : config.listGroup) == null ? void 0 : _ya.orderedList) == null ? void 0 : _za.icon) != null ? _Aa : orderedListIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const orderedList = commonmark.orderedListSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.wrapInBlockTypeCommand.key, {
            nodeType: orderedList
          });
        }
      });
    }
    if (((_Ba = config == null ? void 0 : config.listGroup) == null ? void 0 : _Ba.taskList) !== null) {
      listGroup.addItem("task-list", {
        label: (_Ea = (_Da = (_Ca = config == null ? void 0 : config.listGroup) == null ? void 0 : _Ca.taskList) == null ? void 0 : _Da.label) != null ? _Ea : "Task List",
        icon: (_Ha = (_Ga = (_Fa = config == null ? void 0 : config.listGroup) == null ? void 0 : _Fa.taskList) == null ? void 0 : _Ga.icon) != null ? _Ha : todoListIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const listItem = commonmark.listItemSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.wrapInBlockTypeCommand.key, {
            nodeType: listItem,
            attrs: { checked: false }
          });
        }
      });
    }
  }
  if ((config == null ? void 0 : config.advancedGroup) !== null) {
    const advancedGroup = groupBuilder.addGroup(
      "advanced",
      (_Ja = (_Ia = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Ia.label) != null ? _Ja : "Advanced"
    );
    if (((_Ka = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Ka.image) !== null && isImageBlockEnabled) {
      advancedGroup.addItem("image", {
        label: (_Na = (_Ma = (_La = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _La.image) == null ? void 0 : _Ma.label) != null ? _Na : "Image",
        icon: (_Qa = (_Pa = (_Oa = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Oa.image) == null ? void 0 : _Pa.icon) != null ? _Qa : imageIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const imageBlock$1 = imageBlock.imageBlockSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.addBlockTypeCommand.key, {
            nodeType: imageBlock$1
          });
        }
      });
    }
    if (((_Ra = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Ra.codeBlock) !== null) {
      advancedGroup.addItem("code", {
        label: (_Ua = (_Ta = (_Sa = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Sa.codeBlock) == null ? void 0 : _Ta.label) != null ? _Ua : "Code",
        icon: (_Xa = (_Wa = (_Va = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Va.codeBlock) == null ? void 0 : _Wa.icon) != null ? _Xa : codeIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const codeBlock = commonmark.codeBlockSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.setBlockTypeCommand.key, {
            nodeType: codeBlock
          });
        }
      });
    }
    if (((_Ya = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Ya.table) !== null && isTableEnabled) {
      advancedGroup.addItem("table", {
        label: (_$a = (__a = (_Za = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _Za.table) == null ? void 0 : __a.label) != null ? _$a : "Table",
        icon: (_cb = (_bb = (_ab = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _ab.table) == null ? void 0 : _bb.icon) != null ? _cb : tableIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const view = ctx2.get(core.editorViewCtx);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          const { from } = view.state.selection;
          commands.call(commonmark.addBlockTypeCommand.key, {
            nodeType: gfm.createTable(ctx2, 3, 3)
          });
          commands.call(commonmark.selectTextNearPosCommand.key, {
            pos: from
          });
        }
      });
    }
    if (((_db = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _db.math) !== null && isLatexEnabled) {
      advancedGroup.addItem("math", {
        label: (_gb = (_fb = (_eb = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _eb.math) == null ? void 0 : _fb.label) != null ? _gb : "Math",
        icon: (_jb = (_ib = (_hb = config == null ? void 0 : config.advancedGroup) == null ? void 0 : _hb.math) == null ? void 0 : _ib.icon) != null ? _jb : functionsIcon,
        onRun: (ctx2) => {
          const commands = ctx2.get(core.commandsCtx);
          const codeBlock = commonmark.codeBlockSchema.type(ctx2);
          commands.call(commonmark.clearTextInCurrentBlockCommand.key);
          commands.call(commonmark.addBlockTypeCommand.key, {
            nodeType: codeBlock,
            attrs: { language: "LaTex" }
          });
        }
      });
    }
  }
  (_kb = config == null ? void 0 : config.buildMenu) == null ? void 0 : _kb.call(config, groupBuilder);
  let groups = groupBuilder.build();
  if (filter) {
    groups = groups.map((group) => {
      const items2 = group.items.filter(
        (item) => item.label.toLowerCase().includes(filter.toLowerCase())
      );
      return {
        ...group,
        items: items2
      };
    }).filter((group) => group.items.length > 0);
  }
  const items = groups.flatMap((groups2) => groups2.items);
  items.forEach((item, index) => {
    Object.assign(item, { index });
  });
  groups.reduce((acc, group) => {
    const end = acc + group.items.length;
    Object.assign(group, {
      range: [acc, end]
    });
    return end;
  }, 0);
  return {
    groups,
    size: items.length
  };
}

const Menu = vue.defineComponent({
  props: {
    ctx: {
      type: Object,
      required: true
    },
    show: {
      type: Object,
      required: true
    },
    filter: {
      type: Object,
      required: true
    },
    hide: {
      type: Function,
      required: true
    },
    config: {
      type: Object,
      required: false
    }
  },
  setup({ ctx, show, filter, hide, config }) {
    const host = vue.ref();
    const groupInfo = vue.computed(() => getGroups(filter.value, config, ctx));
    const hoverIndex = vue.ref(0);
    const prevMousePosition = vue.ref({ x: -999, y: -999 });
    const onPointerMove = (e) => {
      const { x, y } = e;
      prevMousePosition.value = { x, y };
    };
    vue.watch([groupInfo, show], () => {
      const { size } = groupInfo.value;
      if (size === 0 && show.value) hide();
      else if (hoverIndex.value >= size) hoverIndex.value = 0;
    });
    const onHover = (index, after) => {
      const prevHoverIndex = hoverIndex.value;
      const next = typeof index === "function" ? index(prevHoverIndex) : index;
      after == null ? void 0 : after(next);
      hoverIndex.value = next;
    };
    const scrollToIndex = (index) => {
      var _a, _b;
      const target = (_a = host.value) == null ? void 0 : _a.querySelector(
        `[data-index="${index}"]`
      );
      const scrollRoot = (_b = host.value) == null ? void 0 : _b.querySelector(".menu-groups");
      if (!target || !scrollRoot) return;
      scrollRoot.scrollTop = target.offsetTop - scrollRoot.offsetTop;
    };
    const runByIndex = (index) => {
      const item = groupInfo.value.groups.flatMap((group) => group.items).at(index);
      if (item && ctx) item.onRun(ctx);
      hide();
    };
    const onKeydown = (e) => {
      const { size, groups } = groupInfo.value;
      if (e.key === "Escape") {
        e.preventDefault();
        hide == null ? void 0 : hide();
        return;
      }
      if (e.key === "ArrowDown") {
        e.preventDefault();
        return onHover(
          (index) => index < size - 1 ? index + 1 : index,
          scrollToIndex
        );
      }
      if (e.key === "ArrowUp") {
        e.preventDefault();
        return onHover(
          (index) => index <= 0 ? index : index - 1,
          scrollToIndex
        );
      }
      if (e.key === "ArrowLeft") {
        e.preventDefault();
        return onHover((index) => {
          const group = groups.find(
            (group2) => group2.range[0] <= index && group2.range[1] > index
          );
          if (!group) return index;
          const prevGroup = groups[groups.indexOf(group) - 1];
          if (!prevGroup) return index;
          return prevGroup.range[1] - 1;
        }, scrollToIndex);
      }
      if (e.key === "ArrowRight") {
        e.preventDefault();
        return onHover((index) => {
          const group = groups.find(
            (group2) => group2.range[0] <= index && group2.range[1] > index
          );
          if (!group) return index;
          const nextGroup = groups[groups.indexOf(group) + 1];
          if (!nextGroup) return index;
          return nextGroup.range[0];
        }, scrollToIndex);
      }
      if (e.key === "Enter") {
        e.preventDefault();
        runByIndex(hoverIndex.value);
      }
    };
    const getOnPointerEnter = (index) => (e) => {
      const prevPos = prevMousePosition.value;
      if (!prevPos) return;
      const { x, y } = e;
      if (x === prevPos.x && y === prevPos.y) return;
      onHover(index);
    };
    vue.watchEffect(() => {
      const isShown = show.value;
      if (isShown) {
        window.addEventListener("keydown", onKeydown, { capture: true });
      } else {
        window.removeEventListener("keydown", onKeydown, { capture: true });
      }
    });
    vue.onUnmounted(() => {
      window.removeEventListener("keydown", onKeydown, { capture: true });
    });
    return () => {
      return /* @__PURE__ */ vue.h("div", { ref: host, onPointerdown: (e) => e.preventDefault() }, /* @__PURE__ */ vue.h("nav", { class: "tab-group" }, /* @__PURE__ */ vue.h("ul", null, groupInfo.value.groups.map((group) => /* @__PURE__ */ vue.h(
        "li",
        {
          key: group.key,
          onPointerdown: () => onHover(group.range[0], scrollToIndex),
          class: hoverIndex.value >= group.range[0] && hoverIndex.value < group.range[1] ? "selected" : ""
        },
        group.label
      )))), /* @__PURE__ */ vue.h("div", { class: "menu-groups", onPointermove: onPointerMove }, groupInfo.value.groups.map((group) => /* @__PURE__ */ vue.h("div", { key: group.key, class: "menu-group" }, /* @__PURE__ */ vue.h("h6", null, group.label), /* @__PURE__ */ vue.h("ul", null, group.items.map((item) => /* @__PURE__ */ vue.h(
        "li",
        {
          key: item.key,
          "data-index": item.index,
          class: hoverIndex.value === item.index ? "hover" : "",
          onPointerenter: getOnPointerEnter(item.index),
          onPointerdown: () => {
            var _a, _b;
            (_b = (_a = host.value) == null ? void 0 : _a.querySelector(`[data-index="${item.index}"]`)) == null ? void 0 : _b.classList.add("active");
          },
          onPointerup: () => {
            var _a, _b;
            (_b = (_a = host.value) == null ? void 0 : _a.querySelector(`[data-index="${item.index}"]`)) == null ? void 0 : _b.classList.remove("active");
            runByIndex(item.index);
          }
        },
        /* @__PURE__ */ vue.h(component.Icon, { icon: item.icon }),
        /* @__PURE__ */ vue.h("span", null, item.label)
      )))))));
    };
  }
});

var __typeError$1 = (msg) => {
  throw TypeError(msg);
};
var __accessCheck$1 = (obj, member, msg) => member.has(obj) || __typeError$1("Cannot " + msg);
var __privateGet$1 = (obj, member, getter) => (__accessCheck$1(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd$1 = (obj, member, value) => member.has(obj) ? __typeError$1("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet$1 = (obj, member, value, setter) => (__accessCheck$1(obj, member, "write to private field"), member.set(obj, value), value);
var _content$1, _app$1, _filter, _slashProvider, _programmaticallyPos;
const menu = slash.slashFactory("CREPE_MENU");
const menuAPI = utils.$ctx(
  {
    show: () => {
    },
    hide: () => {
    }
  },
  "menuAPICtx"
);
function configureMenu(ctx, config) {
  ctx.set(menu.key, {
    view: (view) => new MenuView(ctx, view, config)
  });
}
class MenuView {
  constructor(ctx, view, config) {
    __privateAdd$1(this, _content$1);
    __privateAdd$1(this, _app$1);
    __privateAdd$1(this, _filter);
    __privateAdd$1(this, _slashProvider);
    __privateAdd$1(this, _programmaticallyPos, null);
    this.update = (view) => {
      __privateGet$1(this, _slashProvider).update(view);
    };
    this.show = (pos) => {
      __privateSet$1(this, _programmaticallyPos, pos);
      __privateGet$1(this, _filter).value = "";
      __privateGet$1(this, _slashProvider).show();
    };
    this.hide = () => {
      __privateSet$1(this, _programmaticallyPos, null);
      __privateGet$1(this, _slashProvider).hide();
    };
    this.destroy = () => {
      __privateGet$1(this, _slashProvider).destroy();
      __privateGet$1(this, _app$1).unmount();
      __privateGet$1(this, _content$1).remove();
    };
    const content = document.createElement("div");
    content.classList.add("milkdown-slash-menu");
    const show = vue.ref(false);
    const filter = vue.ref("");
    __privateSet$1(this, _filter, filter);
    const hide = this.hide;
    const app = vue.createApp(Menu, {
      ctx,
      config,
      show,
      filter,
      hide
    });
    __privateSet$1(this, _app$1, app);
    app.mount(content);
    __privateSet$1(this, _content$1, content);
    const self = this;
    __privateSet$1(this, _slashProvider, new slash.SlashProvider({
      content: __privateGet$1(this, _content$1),
      debounce: 20,
      shouldShow(view2) {
        if (isInCodeBlock(view2.state.selection) || isInList(view2.state.selection))
          return false;
        const currentText = this.getContent(
          view2,
          (node) => ["paragraph", "heading"].includes(node.type.name)
        );
        if (currentText == null) return false;
        if (!isSelectionAtEndOfNode(view2.state.selection)) {
          return false;
        }
        const pos = __privateGet$1(self, _programmaticallyPos);
        filter.value = currentText.startsWith("/") ? currentText.slice(1) : currentText;
        if (typeof pos === "number") {
          const maxSize = view2.state.doc.nodeSize - 2;
          const validPos = Math.min(pos, maxSize);
          if (view2.state.doc.resolve(validPos).node() !== view2.state.doc.resolve(view2.state.selection.from).node()) {
            __privateSet$1(self, _programmaticallyPos, null);
            return false;
          }
          return true;
        }
        if (!currentText.startsWith("/")) return false;
        return true;
      },
      offset: 10
    }));
    __privateGet$1(this, _slashProvider).onShow = () => {
      show.value = true;
    };
    __privateGet$1(this, _slashProvider).onHide = () => {
      show.value = false;
    };
    this.update(view);
    ctx.set(menuAPI.key, {
      show: (pos) => this.show(pos),
      hide: () => this.hide()
    });
  }
}
_content$1 = new WeakMap();
_app$1 = new WeakMap();
_filter = new WeakMap();
_slashProvider = new WeakMap();
_programmaticallyPos = new WeakMap();
function isSelectionAtEndOfNode(selection) {
  if (!(selection instanceof state.TextSelection)) return false;
  const { $head } = selection;
  const parent = $head.parent;
  const offset = $head.parentOffset;
  return offset === parent.content.size;
}

const BlockHandle = vue.defineComponent({
  props: {
    onAdd: {
      type: Function,
      required: true
    },
    addIcon: {
      type: String,
      required: true
    },
    handleIcon: {
      type: String,
      required: true
    }
  },
  setup(props) {
    const addButton = vue.ref();
    return () => {
      return /* @__PURE__ */ vue.h(vue.Fragment, null, /* @__PURE__ */ vue.h(
        "div",
        {
          ref: addButton,
          class: "operation-item",
          onPointerdown: (e) => {
            var _a;
            e.preventDefault();
            e.stopPropagation();
            (_a = addButton.value) == null ? void 0 : _a.classList.add("active");
          },
          onPointerup: (e) => {
            var _a;
            e.preventDefault();
            e.stopPropagation();
            (_a = addButton.value) == null ? void 0 : _a.classList.remove("active");
            props.onAdd();
          }
        },
        /* @__PURE__ */ vue.h(component.Icon, { icon: props.addIcon })
      ), /* @__PURE__ */ vue.h("div", { class: "operation-item" }, /* @__PURE__ */ vue.h(component.Icon, { icon: props.handleIcon })));
    };
  }
});

var __typeError = (msg) => {
  throw TypeError(msg);
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), member.set(obj, value), value);
var _content, _provider, _app, _ctx;
class BlockHandleView {
  constructor(ctx, config) {
    __privateAdd(this, _content);
    __privateAdd(this, _provider);
    __privateAdd(this, _app);
    __privateAdd(this, _ctx);
    this.update = () => {
      __privateGet(this, _provider).update();
    };
    this.destroy = () => {
      __privateGet(this, _provider).destroy();
      __privateGet(this, _content).remove();
      __privateGet(this, _app).unmount();
    };
    this.onAdd = () => {
      const ctx = __privateGet(this, _ctx);
      const view = ctx.get(core.editorViewCtx);
      if (!view.hasFocus()) view.focus();
      const { state: state$1, dispatch } = view;
      const active = __privateGet(this, _provider).active;
      if (!active) return;
      const $pos = active.$pos;
      const pos = $pos.pos + active.node.nodeSize;
      let tr = state$1.tr.insert(pos, commonmark.paragraphSchema.type(ctx).create());
      tr = tr.setSelection(state.TextSelection.near(tr.doc.resolve(pos)));
      dispatch(tr.scrollIntoView());
      __privateGet(this, _provider).hide();
      ctx.get(menuAPI.key).show(tr.selection.from);
    };
    var _a, _b, _c;
    __privateSet(this, _ctx, ctx);
    const content = document.createElement("div");
    content.classList.add("milkdown-block-handle");
    const app = vue.createApp(BlockHandle, {
      onAdd: this.onAdd,
      addIcon: (_a = config == null ? void 0 : config.handleAddIcon) != null ? _a : plusIcon,
      handleIcon: (_b = config == null ? void 0 : config.handleDragIcon) != null ? _b : menuIcon
    });
    app.mount(content);
    __privateSet(this, _app, app);
    __privateSet(this, _content, content);
    const blockProviderOptions = (_c = config == null ? void 0 : config.blockHandle) != null ? _c : {};
    __privateSet(this, _provider, new block.BlockProvider({
      ctx,
      content,
      getOffset: () => 16,
      getPlacement: ({ active, blockDom }) => {
        if (active.node.type.name === "heading") return "left";
        let totalDescendant = 0;
        active.node.descendants((node) => {
          totalDescendant += node.childCount;
        });
        const dom = active.el;
        const domRect = dom.getBoundingClientRect();
        const handleRect = blockDom.getBoundingClientRect();
        const style = window.getComputedStyle(dom);
        const paddingTop = Number.parseInt(style.paddingTop, 10) || 0;
        const paddingBottom = Number.parseInt(style.paddingBottom, 10) || 0;
        const height = domRect.height - paddingTop - paddingBottom;
        const handleHeight = handleRect.height;
        return totalDescendant > 2 || handleHeight < height ? "left-start" : "left";
      },
      ...blockProviderOptions
    }));
    this.update();
  }
}
_content = new WeakMap();
_provider = new WeakMap();
_app = new WeakMap();
_ctx = new WeakMap();
function configureBlockHandle(ctx, config) {
  ctx.set(block.blockConfig.key, {
    filterNodes: (pos) => {
      const filter = prose.findParent(
        (node) => ["table", "blockquote", "math_inline"].includes(node.type.name)
      )(pos);
      if (filter) return false;
      return true;
    }
  });
  ctx.set(block.block.key, {
    view: () => new BlockHandleView(ctx, config)
  });
}

const blockEdit = (editor, config) => {
  editor.config(crepeFeatureConfig(CrepeFeature.BlockEdit)).config((ctx) => configureBlockHandle(ctx, config)).config((ctx) => configureMenu(ctx, config)).use(menuAPI).use(block.block).use(menu);
};

exports.blockEdit = blockEdit;
//# sourceMappingURL=index.js.map
