'use strict';

var cursor$1 = require('@milkdown/kit/plugin/cursor');
var utils = require('@milkdown/kit/utils');
var prosemirrorVirtualCursor = require('prosemirror-virtual-cursor');
var ctx = require('@milkdown/kit/ctx');

ctx.createSlice([], "FeaturesCtx");
ctx.createSlice({}, "CrepeCtx");
function useCrepeFeatures(ctx) {
  return ctx.use("FeaturesCtx");
}
function crepeFeatureConfig(feature) {
  return (ctx) => {
    useCrepeFeatures(ctx).update((features) => {
      if (features.includes(feature)) {
        return features;
      }
      return [...features, feature];
    });
  };
}

var CrepeFeature = /* @__PURE__ */ ((CrepeFeature2) => {
  CrepeFeature2["CodeMirror"] = "code-mirror";
  CrepeFeature2["ListItem"] = "list-item";
  CrepeFeature2["LinkTooltip"] = "link-tooltip";
  CrepeFeature2["Cursor"] = "cursor";
  CrepeFeature2["ImageBlock"] = "image-block";
  CrepeFeature2["BlockEdit"] = "block-edit";
  CrepeFeature2["Toolbar"] = "toolbar";
  CrepeFeature2["Placeholder"] = "placeholder";
  CrepeFeature2["Table"] = "table";
  CrepeFeature2["Latex"] = "latex";
  return CrepeFeature2;
})(CrepeFeature || {});

const cursor = (editor, config) => {
  editor.config(crepeFeatureConfig(CrepeFeature.Cursor)).config((ctx) => {
    ctx.update(cursor$1.dropCursorConfig.key, () => {
      var _a, _b;
      return {
        class: "crepe-drop-cursor",
        width: (_a = config == null ? void 0 : config.width) != null ? _a : 4,
        color: (_b = config == null ? void 0 : config.color) != null ? _b : false
      };
    });
  }).use(cursor$1.cursor);
  if ((config == null ? void 0 : config.virtual) === false) {
    return;
  }
  const virtualCursor = prosemirrorVirtualCursor.createVirtualCursor();
  editor.use(utils.$prose(() => virtualCursor));
};

exports.cursor = cursor;
//# sourceMappingURL=index.js.map
