'use strict';

var imageBlock$1 = require('@milkdown/kit/component/image-block');
var imageInline = require('@milkdown/kit/component/image-inline');
var ctx = require('@milkdown/kit/ctx');

ctx.createSlice([], "FeaturesCtx");
ctx.createSlice({}, "CrepeCtx");
function useCrepeFeatures(ctx) {
  return ctx.use("FeaturesCtx");
}
function crepeFeatureConfig(feature) {
  return (ctx) => {
    useCrepeFeatures(ctx).update((features) => {
      if (features.includes(feature)) {
        return features;
      }
      return [...features, feature];
    });
  };
}

const captionIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="32"
    height="32"
    viewBox="0 0 24 24"
  >
    <path
      fill="currentColor"
      d="M9 22a1 1 0 0 1-1-1v-3H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2h-6.1l-3.7 3.71c-.2.19-.45.29-.7.29zm1-6v3.08L13.08 16H20V4H4v12z"
    />
  </svg>
`;

const confirmIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
  >
    <g clip-path="url(#clip0_1013_1606)">
      <path
        d="M9.00012 16.1998L5.50012 12.6998C5.11012 12.3098 4.49012 12.3098 4.10012 12.6998C3.71012 13.0898 3.71012 13.7098 4.10012 14.0998L8.29012 18.2898C8.68012 18.6798 9.31012 18.6798 9.70012 18.2898L20.3001 7.69982C20.6901 7.30982 20.6901 6.68982 20.3001 6.29982C19.9101 5.90982 19.2901 5.90982 18.9001 6.29982L9.00012 16.1998Z"
        fill="#817567"
      />
    </g>
    <defs>
      <clipPath id="clip0_1013_1606">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const imageIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_977_8075)">
      <path
        d="M19 5V19H5V5H19ZM19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM14.14 11.86L11.14 15.73L9 13.14L6 17H18L14.14 11.86Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_977_8075">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

var CrepeFeature = /* @__PURE__ */ ((CrepeFeature2) => {
  CrepeFeature2["CodeMirror"] = "code-mirror";
  CrepeFeature2["ListItem"] = "list-item";
  CrepeFeature2["LinkTooltip"] = "link-tooltip";
  CrepeFeature2["Cursor"] = "cursor";
  CrepeFeature2["ImageBlock"] = "image-block";
  CrepeFeature2["BlockEdit"] = "block-edit";
  CrepeFeature2["Toolbar"] = "toolbar";
  CrepeFeature2["Placeholder"] = "placeholder";
  CrepeFeature2["Table"] = "table";
  CrepeFeature2["Latex"] = "latex";
  return CrepeFeature2;
})(CrepeFeature || {});

const imageBlock = (editor, config) => {
  editor.config(crepeFeatureConfig(CrepeFeature.ImageBlock)).config((ctx) => {
    ctx.update(imageInline.inlineImageConfig.key, (value) => {
      var _a, _b, _c, _d, _e, _f;
      return {
        uploadButton: (_a = config == null ? void 0 : config.inlineUploadButton) != null ? _a : "Upload",
        imageIcon: (_b = config == null ? void 0 : config.inlineImageIcon) != null ? _b : imageIcon,
        confirmButton: (_c = config == null ? void 0 : config.inlineConfirmButton) != null ? _c : confirmIcon,
        uploadPlaceholderText: (_d = config == null ? void 0 : config.inlineUploadPlaceholderText) != null ? _d : "or paste link",
        onUpload: (_f = (_e = config == null ? void 0 : config.inlineOnUpload) != null ? _e : config == null ? void 0 : config.onUpload) != null ? _f : value.onUpload,
        proxyDomURL: config == null ? void 0 : config.proxyDomURL
      };
    });
    ctx.update(imageBlock$1.imageBlockConfig.key, (value) => {
      var _a, _b, _c, _d, _e, _f, _g, _h;
      return {
        uploadButton: (_a = config == null ? void 0 : config.blockUploadButton) != null ? _a : "Upload file",
        imageIcon: (_b = config == null ? void 0 : config.blockImageIcon) != null ? _b : imageIcon,
        captionIcon: (_c = config == null ? void 0 : config.blockCaptionIcon) != null ? _c : captionIcon,
        confirmButton: (_d = config == null ? void 0 : config.blockConfirmButton) != null ? _d : "Confirm",
        captionPlaceholderText: (_e = config == null ? void 0 : config.blockCaptionPlaceholderText) != null ? _e : "Write Image Caption",
        uploadPlaceholderText: (_f = config == null ? void 0 : config.blockUploadPlaceholderText) != null ? _f : "or paste link",
        onUpload: (_h = (_g = config == null ? void 0 : config.blockOnUpload) != null ? _g : config == null ? void 0 : config.onUpload) != null ? _h : value.onUpload,
        proxyDomURL: config == null ? void 0 : config.proxyDomURL
      };
    });
  }).use(imageBlock$1.imageBlockComponent).use(imageInline.imageInlineComponent);
};

exports.imageBlock = imageBlock;
//# sourceMappingURL=index.js.map
