import { defaultKeymap, indentWithTab } from '@codemirror/commands';
import { keymap } from '@codemirror/view';
import { codeBlockConfig, codeBlockComponent } from '@milkdown/kit/component/code-block';
import { basicSetup } from 'codemirror';
import { createSlice } from '@milkdown/kit/ctx';

createSlice([], "FeaturesCtx");
createSlice({}, "CrepeCtx");
function useCrepeFeatures(ctx) {
  return ctx.use("FeaturesCtx");
}
function crepeFeatureConfig(feature) {
  return (ctx) => {
    useCrepeFeatures(ctx).update((features) => {
      if (features.includes(feature)) {
        return features;
      }
      return [...features, feature];
    });
  };
}

const chevronDownIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 24 24"
    stroke-width="1.5"
    stroke="currentColor"
    class="w-6 h-6"
  >
    <path
      stroke-linecap="round"
      stroke-linejoin="round"
      d="M19.5 8.25l-7.5 7.5-7.5-7.5"
    />
  </svg>
`;

const clearIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_1098_15553)">
      <path
        d="M18.3007 5.70973C17.9107 5.31973 17.2807 5.31973 16.8907 5.70973L12.0007 10.5897L7.1107 5.69973C6.7207 5.30973 6.0907 5.30973 5.7007 5.69973C5.3107 6.08973 5.3107 6.71973 5.7007 7.10973L10.5907 11.9997L5.7007 16.8897C5.3107 17.2797 5.3107 17.9097 5.7007 18.2997C6.0907 18.6897 6.7207 18.6897 7.1107 18.2997L12.0007 13.4097L16.8907 18.2997C17.2807 18.6897 17.9107 18.6897 18.3007 18.2997C18.6907 17.9097 18.6907 17.2797 18.3007 16.8897L13.4107 11.9997L18.3007 7.10973C18.6807 6.72973 18.6807 6.08973 18.3007 5.70973Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_1098_15553">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const copyIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    height="24px"
    viewBox="0 -960 960 960"
    width="24px"
    fill="none"
  >
    <path
      d="M360-240q-33 0-56.5-23.5T280-320v-480q0-33 23.5-56.5T360-880h360q33 0 56.5 23.5T800-800v480q0 33-23.5 56.5T720-240H360Zm0-80h360v-480H360v480ZM200-80q-33 0-56.5-23.5T120-160v-560h80v560h440v80H200Zm160-240v-480 480Z"
    />
  </svg>
`;

const editIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
  >
    <g clip-path="url(#clip0_1013_1585)">
      <path
        d="M14.06 9.02L14.98 9.94L5.92 19H5V18.08L14.06 9.02ZM17.66 3C17.41 3 17.15 3.1 16.96 3.29L15.13 5.12L18.88 8.87L20.71 7.04C21.1 6.65 21.1 6.02 20.71 5.63L18.37 3.29C18.17 3.09 17.92 3 17.66 3ZM14.06 6.19L3 17.25V21H6.75L17.81 9.94L14.06 6.19Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_1013_1585">
        <rect width="24" height="24" />
      </clipPath>
    </defs>
  </svg>
`;

const searchIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 24 24"
    stroke-width="1.5"
    stroke="currentColor"
    class="w-6 h-6"
  >
    <path
      stroke-linecap="round"
      stroke-linejoin="round"
      d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z"
    />
  </svg>
`;

const visibilityOffIcon = `
  <svg
    xmlns="http://www.w3.org/2000/svg"
    height="24px"
    viewBox="0 -960 960 960"
    width="24px"
  >
    <path
      d="m644-428-58-58q9-47-27-88t-93-32l-58-58q17-8 34.5-12t37.5-4q75 0 127.5 52.5T660-500q0 20-4 37.5T644-428Zm128 126-58-56q38-29 67.5-63.5T832-500q-50-101-143.5-160.5T480-720q-29 0-57 4t-55 12l-62-62q41-17 84-25.5t90-8.5q151 0 269 83.5T920-500q-23 59-60.5 109.5T772-302Zm20 246L624-222q-35 11-70.5 16.5T480-200q-151 0-269-83.5T40-500q21-53 53-98.5t73-81.5L56-792l56-56 736 736-56 56ZM222-624q-29 26-53 57t-41 67q50 101 143.5 160.5T480-280q20 0 39-2.5t39-5.5l-36-38q-11 3-21 4.5t-21 1.5q-75 0-127.5-52.5T300-500q0-11 1.5-21t4.5-21l-84-82Zm319 93Zm-151 75Z"
    />
  </svg>
`;

var CrepeFeature = /* @__PURE__ */ ((CrepeFeature2) => {
  CrepeFeature2["CodeMirror"] = "code-mirror";
  CrepeFeature2["ListItem"] = "list-item";
  CrepeFeature2["LinkTooltip"] = "link-tooltip";
  CrepeFeature2["Cursor"] = "cursor";
  CrepeFeature2["ImageBlock"] = "image-block";
  CrepeFeature2["BlockEdit"] = "block-edit";
  CrepeFeature2["Toolbar"] = "toolbar";
  CrepeFeature2["Placeholder"] = "placeholder";
  CrepeFeature2["Table"] = "table";
  CrepeFeature2["Latex"] = "latex";
  return CrepeFeature2;
})(CrepeFeature || {});

const codeMirror = (editor, config = {}) => {
  editor.config(crepeFeatureConfig(CrepeFeature.CodeMirror)).config((ctx) => {
    const { languages = [], theme } = config;
    const extensions = [
      keymap.of(defaultKeymap.concat(indentWithTab)),
      basicSetup
    ];
    if (theme) {
      extensions.push(theme);
    }
    if (config.extensions) {
      extensions.push(...config.extensions);
    }
    ctx.update(codeBlockConfig.key, (defaultConfig) => ({
      extensions,
      languages,
      expandIcon: config.expandIcon || chevronDownIcon,
      searchIcon: config.searchIcon || searchIcon,
      clearSearchIcon: config.clearSearchIcon || clearIcon,
      searchPlaceholder: config.searchPlaceholder || "Search language",
      copyText: config.copyText || "Copy",
      copyIcon: config.copyIcon || copyIcon,
      onCopy: config.onCopy || (() => {
      }),
      noResultText: config.noResultText || "No result",
      renderLanguage: config.renderLanguage || defaultConfig.renderLanguage,
      renderPreview: config.renderPreview || defaultConfig.renderPreview,
      previewToggleButton: (previewOnlyMode) => {
        var _a, _b;
        const icon = ((_a = config.previewToggleIcon) == null ? void 0 : _a.call(config, previewOnlyMode)) || (previewOnlyMode ? editIcon : visibilityOffIcon);
        const text = ((_b = config.previewToggleText) == null ? void 0 : _b.call(config, previewOnlyMode)) || (previewOnlyMode ? "Edit" : "Hide");
        return [icon, text].map((v) => v.trim()).join(" ");
      },
      previewLabel: config.previewLabel || defaultConfig.previewLabel
    }));
  }).use(codeBlockComponent);
};

export { codeMirror };
//# sourceMappingURL=index.js.map
