import { findParent } from '@milkdown/kit/prose';
import { Plugin, PluginKey } from '@milkdown/kit/prose/state';
import { DecorationSet, Decoration } from '@milkdown/kit/prose/view';
import { $ctx, $prose } from '@milkdown/kit/utils';
import { createSlice } from '@milkdown/kit/ctx';

createSlice([], "FeaturesCtx");
createSlice({}, "CrepeCtx");
function useCrepe(ctx) {
  return ctx.get("CrepeCtx");
}
function useCrepeFeatures(ctx) {
  return ctx.use("FeaturesCtx");
}
function crepeFeatureConfig(feature) {
  return (ctx) => {
    useCrepeFeatures(ctx).update((features) => {
      if (features.includes(feature)) {
        return features;
      }
      return [...features, feature];
    });
  };
}

function isInCodeBlock(selection) {
  const type = selection.$from.parent.type;
  return type.name === "code_block";
}
function isInList(selection) {
  var _a;
  const type = (_a = selection.$from.node(selection.$from.depth - 1)) == null ? void 0 : _a.type;
  return (type == null ? void 0 : type.name) === "list_item";
}

var CrepeFeature = /* @__PURE__ */ ((CrepeFeature2) => {
  CrepeFeature2["CodeMirror"] = "code-mirror";
  CrepeFeature2["ListItem"] = "list-item";
  CrepeFeature2["LinkTooltip"] = "link-tooltip";
  CrepeFeature2["Cursor"] = "cursor";
  CrepeFeature2["ImageBlock"] = "image-block";
  CrepeFeature2["BlockEdit"] = "block-edit";
  CrepeFeature2["Toolbar"] = "toolbar";
  CrepeFeature2["Placeholder"] = "placeholder";
  CrepeFeature2["Table"] = "table";
  CrepeFeature2["Latex"] = "latex";
  return CrepeFeature2;
})(CrepeFeature || {});

function isDocEmpty(doc) {
  var _a;
  return doc.childCount <= 1 && !((_a = doc.firstChild) == null ? void 0 : _a.content.size);
}
function createPlaceholderDecoration(state, placeholderText) {
  const { selection } = state;
  if (!selection.empty) return null;
  const $pos = selection.$anchor;
  const node = $pos.parent;
  if (node.content.size > 0) return null;
  const inTable = findParent((node2) => node2.type.name === "table")($pos);
  if (inTable) return null;
  const before = $pos.before();
  return Decoration.node(before, before + node.nodeSize, {
    class: "crepe-placeholder",
    "data-placeholder": placeholderText
  });
}
const placeholderConfig = $ctx(
  {
    text: "Please enter...",
    mode: "block"
  },
  "placeholderConfigCtx"
);
const placeholderPlugin = $prose((ctx) => {
  return new Plugin({
    key: new PluginKey("CREPE_PLACEHOLDER"),
    props: {
      decorations: (state) => {
        var _a;
        const crepe = useCrepe(ctx);
        if (crepe.readonly) return null;
        const config = ctx.get(placeholderConfig.key);
        if (config.mode === "doc" && !isDocEmpty(state.doc)) return null;
        if (isInCodeBlock(state.selection) || isInList(state.selection))
          return null;
        const placeholderText = (_a = config.text) != null ? _a : "Please enter...";
        const deco = createPlaceholderDecoration(state, placeholderText);
        if (!deco) return null;
        return DecorationSet.create(state.doc, [deco]);
      }
    }
  });
});
const placeholder = (editor, config) => {
  editor.config(crepeFeatureConfig(CrepeFeature.Placeholder)).config((ctx) => {
    if (config) {
      ctx.update(placeholderConfig.key, (prev) => {
        return {
          ...prev,
          ...config
        };
      });
    }
  }).use(placeholderPlugin).use(placeholderConfig);
};

export { placeholder, placeholderConfig, placeholderPlugin };
//# sourceMappingURL=index.js.map
