import type { LanguageDescription } from '@codemirror/language';
import type { Extension } from '@codemirror/state';
import type { DefineFeature } from '../shared';
interface CodeMirrorConfig {
    extensions: Extension[];
    languages: LanguageDescription[];
    theme: Extension;
    expandIcon: string;
    searchIcon: string;
    clearSearchIcon: string;
    searchPlaceholder: string;
    copyText: string;
    copyIcon: string;
    onCopy: (text: string) => void;
    noResultText: string;
    renderLanguage: (language: string, selected: boolean) => string;
    renderPreview: (language: string, content: string) => string | HTMLElement | null;
    previewToggleIcon: (previewOnlyMode: boolean) => string;
    previewToggleText: (previewOnlyMode: boolean) => string;
    previewLabel: string;
}
export type CodeMirrorFeatureConfig = Partial<CodeMirrorConfig>;
export declare const codeMirror: DefineFeature<CodeMirrorFeatureConfig>;
export {};
//# sourceMappingURL=index.d.ts.map