import type { BlockEditFeatureConfig } from './block-edit';
import type { CodeMirrorFeatureConfig } from './code-mirror';
import type { CursorFeatureConfig } from './cursor';
import type { ImageBlockFeatureConfig } from './image-block';
import type { LatexFeatureConfig } from './latex';
import type { LinkTooltipFeatureConfig } from './link-tooltip';
import type { ListItemFeatureConfig } from './list-item';
import type { PlaceholderFeatureConfig } from './placeholder';
import type { TableFeatureConfig } from './table';
import type { ToolbarFeatureConfig } from './toolbar';
export declare enum CrepeFeature {
    CodeMirror = "code-mirror",
    ListItem = "list-item",
    LinkTooltip = "link-tooltip",
    Cursor = "cursor",
    ImageBlock = "image-block",
    BlockEdit = "block-edit",
    Toolbar = "toolbar",
    Placeholder = "placeholder",
    Table = "table",
    Latex = "latex"
}
export interface CrepeFeatureConfig {
    [CrepeFeature.Cursor]?: CursorFeatureConfig;
    [CrepeFeature.ListItem]?: ListItemFeatureConfig;
    [CrepeFeature.LinkTooltip]?: LinkTooltipFeatureConfig;
    [CrepeFeature.ImageBlock]?: ImageBlockFeatureConfig;
    [CrepeFeature.BlockEdit]?: BlockEditFeatureConfig;
    [CrepeFeature.Placeholder]?: PlaceholderFeatureConfig;
    [CrepeFeature.Toolbar]?: ToolbarFeatureConfig;
    [CrepeFeature.CodeMirror]?: CodeMirrorFeatureConfig;
    [CrepeFeature.Table]?: TableFeatureConfig;
    [CrepeFeature.Latex]?: LatexFeatureConfig;
}
export declare const defaultFeatures: Record<CrepeFeature, boolean>;
//# sourceMappingURL=index.d.ts.map