import { dropCursor } from "@milkdown/prose/dropcursor";
import { gapCursor } from "@milkdown/prose/gapcursor";
import { $ctx, $prose } from "@milkdown/utils";
function withMeta(plugin, meta) {
  Object.assign(plugin, {
    meta: {
      package: "@milkdown/plugin-cursor",
      ...meta
    }
  });
  return plugin;
}
const dropCursorConfig = $ctx(
  {},
  "dropCursorConfig"
);
withMeta(dropCursorConfig, {
  displayName: "Ctx<dropCursor>"
});
const dropCursorPlugin = $prose(
  (ctx) => dropCursor(ctx.get(dropCursorConfig.key))
);
withMeta(dropCursorPlugin, {
  displayName: "Prose<dropCursor>"
});
const gapCursorPlugin = $prose(() => gapCursor());
withMeta(gapCursorPlugin, {
  displayName: "Prose<gapCursor>"
});
const cursor = [
  dropCursorConfig,
  dropCursorPlugin,
  gapCursorPlugin
];
export {
  cursor,
  dropCursorConfig,
  dropCursorPlugin,
  gapCursorPlugin
};
//# sourceMappingURL=index.js.map
