import { commandsCtx } from "@milkdown/core";
import { undo, redo, history as history$1 } from "@milkdown/prose/history";
import { $command, $ctx, $prose, $useKeymap } from "@milkdown/utils";
function withMeta(plugin, meta) {
  Object.assign(plugin, {
    meta: {
      package: "@milkdown/plugin-history",
      ...meta
    }
  });
  return plugin;
}
const undoCommand = $command("Undo", () => () => undo);
withMeta(undoCommand, {
  displayName: "Command<undo>"
});
const redoCommand = $command("Redo", () => () => redo);
withMeta(redoCommand, {
  displayName: "Command<redo>"
});
const historyProviderConfig = $ctx({}, "historyProviderConfig");
withMeta(historyProviderConfig, {
  displayName: "Ctx<historyProviderConfig>"
});
const historyProviderPlugin = $prose(
  (ctx) => history$1(ctx.get(historyProviderConfig.key))
);
withMeta(historyProviderPlugin, {
  displayName: "Ctx<historyProviderPlugin>"
});
const historyKeymap = $useKeymap("historyKeymap", {
  Undo: {
    shortcuts: "Mod-z",
    command: (ctx) => {
      const commands = ctx.get(commandsCtx);
      return () => commands.call(undoCommand.key);
    }
  },
  Redo: {
    shortcuts: ["Mod-y", "Shift-Mod-z"],
    command: (ctx) => {
      const commands = ctx.get(commandsCtx);
      return () => commands.call(redoCommand.key);
    }
  }
});
withMeta(historyKeymap.ctx, {
  displayName: "KeymapCtx<history>"
});
withMeta(historyKeymap.shortcuts, {
  displayName: "Keymap<history>"
});
const history = [
  historyProviderConfig,
  historyProviderPlugin,
  historyKeymap,
  undoCommand,
  redoCommand
].flat();
export {
  history,
  historyKeymap,
  historyProviderConfig,
  historyProviderPlugin,
  redoCommand,
  undoCommand
};
//# sourceMappingURL=index.js.map
