import { inject, ref, onMounted, onUnmounted, defineComponent, createVNode, provide, Fragment } from "vue";
const editorInfoCtxKey = Symbol("editorInfoCtxKey");
function useGetEditor() {
  const {
    dom,
    loading,
    editor: editorRef,
    editorFactory: getEditor
  } = inject(editorInfoCtxKey, {});
  const currentEditorRef = ref();
  onMounted(() => {
    if (!dom.value) return;
    const editor = getEditor.value(dom.value);
    if (!editor) return;
    loading.value = true;
    currentEditorRef.value = editor;
    editor.create().then((editor2) => {
      editorRef.value = editor2;
    }).finally(() => {
      loading.value = false;
    }).catch(console.error);
  });
  onUnmounted(() => {
    currentEditorRef.value?.destroy().catch(console.error);
  });
  return dom;
}
const Milkdown = /* @__PURE__ */ defineComponent({
  name: "Milkdown",
  setup: () => {
    const domRef = useGetEditor();
    return () => createVNode("div", {
      "data-milkdown-root": true,
      "ref": domRef
    }, null);
  }
});
const MilkdownProvider = /* @__PURE__ */ defineComponent({
  name: "MilkdownProvider",
  setup: (_, {
    slots
  }) => {
    const dom = ref(null);
    const editorFactory = ref(void 0);
    const editor = ref(void 0);
    const loading = ref(true);
    provide(editorInfoCtxKey, {
      loading,
      dom,
      editor,
      editorFactory
    });
    return () => createVNode(Fragment, null, [slots.default?.()]);
  }
});
function useEditor(getEditor) {
  const { editorFactory, loading, editor } = inject(editorInfoCtxKey);
  editorFactory.value = getEditor;
  return {
    loading,
    get: () => editor.value
  };
}
function useInstance() {
  const editorInfo = inject(editorInfoCtxKey);
  return [editorInfo.loading, () => editorInfo.editor.value];
}
export {
  Milkdown,
  MilkdownProvider,
  useEditor,
  useInstance
};
//# sourceMappingURL=index.js.map
