/**!
* @license
* The MIT License (MIT)
* 
* Copyright (c) 2017 Måns Beckman - www.spatialillusions.com
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* More information can be found at www.spatialillusions.com 
*/
!function(I,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define("milsymbol",t):I.ms=t()}(this,function(){"use strict";function I(I){return void 0===I&&(I={}),{x1:void 0!==I.x1?I.x1:100,y1:void 0!==I.y1?I.y1:100,x2:void 0!==I.x2?I.x2:100,y2:void 0!==I.y2?I.y2:100,width:function(){return this.x2-this.x1},height:function(){return this.y2-this.y1},getSize:function(){return{height:this.y2-this.y1,width:this.x2-this.x1}},merge:function(I){return this.x1=I.x1<=this.x1?I.x1:this.x1,this.y1=I.y1<=this.y1?I.y1:this.y1,this.x2=I.x2>=this.x2?I.x2:this.x2,this.y2=I.y2>=this.y2?I.y2:this.y2,this}}}var t={Black:{Civilian:"black",Friend:"black",Hostile:"black",Neutral:"black",Unknown:"black"},Dark:{Civilian:"rgb(80,0,80)",Friend:"rgb(0,107,140)",Hostile:"rgb(200,0,0)",Neutral:"rgb(0,160,0)",Unknown:"rgb(225,220,0)"},FrameColor:{Civilian:"rgb(255,0,255)",Friend:"rgb(0, 255, 255)",Hostile:"rgb(255, 0, 0)",Neutral:"rgb(0, 255, 0)",Unknown:"rgb(255, 255, 0)"},IconColor:{Civilian:"rgb(255,0,255)",Friend:"rgb(0, 255, 255)",Hostile:"rgb(255, 0, 0)",Neutral:"rgb(0, 255, 0)",Unknown:"rgb(255, 255, 0)"},Light:{Civilian:"rgb(255,161,255)",Friend:"rgb(128,224,255)",Hostile:"rgb(255,128,128)",Neutral:"rgb(170,255,170)",Unknown:"rgb(255,255,128)"},Medium:{Civilian:"rgb(128,0,128)",Friend:"rgb(0,168,220)",Hostile:"rgb(255,48,49)",Neutral:"rgb(0,226,110)",Unknown:"rgb(255,255,0)"},None:{Civilian:!1,Friend:!1,Hostile:!1,Neutral:!1,Unknown:!1},OffWhite:{Civilian:"rgb(239, 239, 239)",Friend:"rgb(239, 239, 239)",Hostile:"rgb(239, 239, 239)",Neutral:"rgb(239, 239, 239)",Unknown:"rgb(239, 239, 239)"},White:{Civilian:"white",Friend:"white",Hostile:"white",Neutral:"white",Unknown:"white"}},E={AirHostile:{g:{type:"path",d:"M 45,150 L45,70 100,20 155,70 155,150"},bbox:new I({x1:45,y1:20,x2:155,y2:150})},AirFriend:{g:{type:"path",d:"M 155,150 C 155,50 115,30 100,30 85,30 45,50 45,150"},bbox:new I({x1:45,y1:30,x2:155,y2:150})},AirNeutral:{g:{type:"path",d:"M 45,150 L 45,30,155,30,155,150"},bbox:new I({x1:45,y1:30,x2:155,y2:150})},AirUnknown:{g:{type:"path",d:"M 65,150 c -55,0 -50,-90 0,-90 0,-50 70,-50 70,0 50,0 55,90 0,90"},bbox:new I({x1:25,y1:20,x2:175,y2:150})},GroundHostile:{g:{type:"path",d:"M 100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new I({x1:28,y1:28,x2:172,y2:172})},GroundFriend:{g:{type:"path",d:"M25,50 l150,0 0,100 -150,0 z"},bbox:new I({x1:25,y1:50,x2:175,y2:150})},GroundNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new I({x1:45,y1:45,x2:155,y2:155})},GroundUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new I({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},LandDismountedIndividualHostile:{g:{type:"path",d:"M 100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new I({x1:28,y1:28,x2:172,y2:172})},LandDismountedIndividualFriend:{g:{type:"path",d:"m 100,45 55,25 0,60 -55,25 -55,-25 0,-60 z"},bbox:new I({x1:45,y1:45,x2:155,y2:155})},LandDismountedIndividualNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new I({x1:45,y1:45,x2:155,y2:155})},LandDismountedIndividualUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new I({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},SeaHostile:{g:{type:"path",d:"M100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new I({x1:28,y1:28,x2:172,y2:172})},SeaFriend:{g:{type:"circle",cx:100,cy:100,r:60},bbox:new I({x1:40,y1:40,x2:160,y2:160})},SeaNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new I({x1:45,y1:45,x2:155,y2:155})},SeaUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new I({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},SubsurfaceHostile:{g:{type:"path",d:"M45,50 L45,130 100,180 155,130 155,50"},bbox:new I({x1:45,y1:50,x2:155,y2:180})},SubsurfaceFriend:{g:{type:"path",d:"m 45,50 c 0,100 40,120 55,120 15,0 55,-20 55,-120"},bbox:new I({x1:45,y1:50,x2:155,y2:170})},SubsurfaceNeutral:{g:{type:"path",d:"M45,50 L45,170 155,170 155,50"},bbox:new I({x1:45,y1:50,x2:155,y2:170})},SubsurfaceUnknown:{g:{type:"path",d:"m 65,50 c -55,0 -50,90 0,90 0,50 70,50 70,0 50,0 55,-90 0,-90"},bbox:new I({x1:25,y1:50,x2:175,y2:180})},PositionMarker:{g:{type:"circle",cx:100,cy:100,r:15},bbox:new I({x1:85,y1:85,x2:115,y2:115})}};var s=new function(){this._brokenPath2D=void 0,this._colorModes={},this._dashArrays={pending:"4,4",anticipated:"8,12",feintDummy:"8,8"},this._getIcons={},this._getMetadata={},this._hqStaffLength=100,this._iconCache={},this._iconParts=[],this._labelCache={},this._labelOverrides={},this._iconSIDC={},this._iconSIDC.letter=[],this._iconSIDC.number=[],this._STD2525=!0,this._svgNS="http://www.w3.org/2000/svg",this._symbolParts=[],this._autoValidation=!1,this.version="2.0.0","object"==typeof console&&console.info("milsymbol.js "+this.version+" - Copyright (c) 2017 M"+String.fromCharCode(229)+"ns Beckman  http://www.spatialillusions.com")};for(var R in s.BBox=I,s.ColorMode=function(I,t,E,R,e){var A={};return A.Civilian=I,A.Friend=t,A.Hostile=E,A.Neutral=R,A.Unknown=e,A},s.setBrokenPath2D=function(I){s._brokenPath2D=I},s._getIconParts=function(I,t,E,R,e){var A={};for(var C in this._iconParts)this._iconParts.hasOwnProperty(C)&&this._iconParts[C].call(this,A,I,t,E,R,e);return A},s._scale=function(I,t){return{type:"translate",x:100-100*I,y:100-100*I,draw:[{type:"scale",factor:I,draw:[t]}]}},s._translate=function(I,t,E){return{type:"translate",x:I,y:t,draw:[E]}},s.addIconParts=function(I){return"function"==typeof I&&-1==this._iconParts.indexOf(I)&&(this._iconParts=this._iconParts.concat(I)),s},s.addLabelOverrides=function(I,t){return"function"==typeof I&&(this._labelOverrides.hasOwnProperty(t)||(this._labelOverrides[t]=[]),this._labelOverrides[t]=this._labelOverrides[t].concat(I)),s},s.addIcons=function(I){if(Array.isArray(I))for(var t=0;t<I.length;t++)s.addSIDCicons(I[t].icons,I[t].type);else s.addSIDCicons(I.icons,I.type)},s.addSIDCicons=function(I,t){return"function"==typeof I&&-1==this._iconSIDC[t].indexOf(I)&&(this._iconSIDC[t]=this._iconSIDC[t].concat(I)),s},s.addSymbolPart=function(I){if("function"==typeof I){var t=s.getSymbolParts();-1==t.indexOf(I)&&s.setSymbolParts(t.concat(I))}return s},s.getColorMode=function(I){var t=this._colorModes[I];return new s.ColorMode(t.Civilian,t.Friend,t.Hostile,t.Neutral,t.Unknown)},s.getDashArrays=function(){return this._dashArrays},s.getHqStaffLength=function(){return this._hqStaffLength},s.getSymbolParts=function(){return this._symbolParts.slice(0)},s.getVersion=function(){return this.version},s.outline=function(I,t,E,R){return function I(t,E,R,e){var A;if(Array.isArray(t))for(var C in A=[],t)A.push(I(t[C],E,R,e));else{for(var T in A={},t)-1==["fill","fillopacity"].indexOf(T)&&(A[T]=t[T]);if("translate"==t.type||"rotate"==t.type||"scale"==t.type)for(var S in A.draw=[],t.draw)A.draw.push(I(t.draw[S],E,R,e));else A.strokewidth=!1!==A.stroke?Number(A.strokewidth||R)+2*E:2*E,A.stroke=e,A.fill=!1,A.linecap="round"}return A}(I,t,E,R)},s.setColorMode=function(I,t){return this._colorModes[I]={},this._colorModes[I].Hostile=t.Hostile,this._colorModes[I].Friend=t.Friend,this._colorModes[I].Neutral=t.Neutral,this._colorModes[I].Unknown=t.Unknown,this._colorModes[I].Civilian=t.Civilian,this._colorModes[I]},s.setDashArrays=function(I,t,E){return this._dashArrays.pending=I,this._dashArrays.anticipated=t,this._dashArrays.feintDummy=E,this._dashArrays},s.setHqStaffLength=function(I){return this._hqStaffLength=I,this._hqStaffLength},s.setSymbolParts=function(I){return this._symbolParts=I,s},s.setStandard=function(I){return"2525"==I?this._STD2525=!0:"APP6"==I&&!(this._STD2525=!1)},t)s.setColorMode(R,t[R]);function e(){this.bbox=new I,this.colors={},this.metadata={},this.octagonAnchor={x:50,y:50},this.options={},this.options.quantity="",this.options.reinforcedReduced="",this.options.staffComments="",this.options.additionalInformation="",this.options.evaluationRating="",this.options.combatEffectiveness="",this.options.signatureEquipment="",this.options.higherFormation="",this.options.hostile="",this.options.iffSif="",this.options.direction="",this.options.sigint="",this.options.uniqueDesignation="",this.options.type="",this.options.dtg="",this.options.altitudeDepth="",this.options.location="",this.options.speed="",this.options.speedLeader=0,this.options.specialHeadquarters="",this.options.country="",this.options.platformType="",this.options.equipmentTeardownTime="",this.options.commonIdentifier="",this.options.auxiliaryEquipmentIndicator="",this.options.headquartersElement="",this.options.installationComposition="",this.options.engagementBar="",this.options.engagementType="",this.options.guardedUnit="",this.options.specialDesignator="",this.style={},this.style.alternateMedal=!1,this.style.civilianColor=!0,this.style.colorMode="Light",this.style.fill=!0,this.style.fillOpacity=1,this.style.fontfamily="Arial",this.style.frame=!0,this.style.frameColor="",this.style.hqStaffLength=0,this.style.icon=!0,this.style.iconColor="",this.style.infoBackground="",this.style.infoBackgroundFrame="",this.style.infoColor="",this.style.infoFields=!0,this.style.infoSize=40,this.style.monoColor="",this.style.outlineColor="rgb(239, 239, 239)",this.style.outlineWidth=0,this.style.padding=0,this.style.simpleStatusModifier=!1,this.style.size=100,this.style.square=!1,this.style.standard="",this.style.strokeWidth=4,this.symbolAnchor={x:50,y:50},this.validIcon=!0,0<arguments.length&&this.setOptions.apply(this,arguments)}function A(I,t,E){this.options.sidc=this.options.sidc.toUpperCase();var R=""!=this.options.sidc.charAt(0)?this.options.sidc.charAt(0):"-",e=""!=this.options.sidc.charAt(1)?this.options.sidc.charAt(1):"-",A=""!=this.options.sidc.charAt(2)?this.options.sidc.charAt(2):"-",C=""!=this.options.sidc.charAt(3)?this.options.sidc.charAt(3):"-",T=t.functionid=""!=this.options.sidc.substr(4,6)?this.options.sidc.substr(4,6):"------",S=""!=this.options.sidc.charAt(10)?this.options.sidc.charAt(10):"-",N=""!=this.options.sidc.charAt(11)?this.options.sidc.charAt(11):"-";if(-1<["H","S","J","K"].indexOf(e)&&(t.affiliation=E.affiliation[0]),-1<["F","A","D","M"].indexOf(e)&&(t.affiliation=E.affiliation[1]),-1<["N","L"].indexOf(e)&&(t.affiliation=E.affiliation[2]),-1<["P","U","G","W","O"].indexOf(e)&&(t.affiliation=E.affiliation[3]),-1<["P","A"].indexOf(A)&&(t.dimension=E.dimension[0]),-1<["G","Z","F","X"].indexOf(A)&&(t.dimension=E.dimension[1]),-1<["S"].indexOf(A)&&(t.dimension=E.dimension[2]),-1<["U"].indexOf(A)&&(t.dimension=E.dimension[3]),"P"==A&&"O"!=R&&(t.space=!0),"O"==R&&-1<["V","O","R"].indexOf(A)&&(t.activity=!0),"G"==R&&(t.controlMeasure=!0),"H"==S&&(t.installation=!0),this.style.frame&&"A"==C&&(t.notpresent=I._dashArrays.anticipated),this.style.frame&&-1<["P","A","S","G","M"].indexOf(e)&&(t.notpresent=I._dashArrays.pending),"C"==C&&(t.condition=E.status[2]),"D"==C&&(t.condition=E.status[3]),"X"==C&&(t.condition=E.status[4]),"F"==C&&(t.condition=E.status[5]),-1<["G","W","D","L","M","J","K"].indexOf(e)&&(t.context=E.context[1]),"O"==R&&(t.dimension=E.dimension[1]),"E"==R&&(t.dimension=E.dimension[1]),t.baseDimension=t.dimension,t.baseAffilation=t.affiliation,"J"==e&&(t.joker=!0),"K"==e&&(t.faker=!0),(t.joker||t.faker)&&(t.affiliation=E.affiliation[1]),"S"==R&&"G"==A&&"E"==T.charAt(0)&&(t.dimension=E.dimension[2]),"I"==R&&"G"==A&&(t.dimension=E.dimension[2]),"E"==R&&("O"==A&&-1<["AB----","AE----","AF----","BB----","CB----","CC----","DB----","DDB---","DEB---","DFB---","DGB---","DHB---","DIB---","DJB---","DLB---","DMB---","DOB---","EA----","EB----","EC----","ED----","EE----"].indexOf(T)||"F"==A&&-1<["BA----","MA----","MC----"].indexOf(T))&&(t.dimension=E.dimension[2]),(-1<["F","G","C","D"].indexOf(S)||"H"==S&&"B"==N)&&(t.feintDummy=!0),-1<["A","B","C","D"].indexOf(S)&&(t.headquarters=!0),"G"==A&&"UH----"==T&&(t.headquarters=!0),-1<["E","B","G","D"].indexOf(S)&&(t.taskForce=!0),"A"==N&&(t.echelon=E.echelonMobility[11]),"B"==N&&"H"!=S&&(t.echelon=E.echelonMobility[12]),"C"==N&&(t.echelon=E.echelonMobility[13]),"D"==N&&(t.echelon=E.echelonMobility[14]),"E"==N&&(t.echelon=E.echelonMobility[15]),"F"==N&&(t.echelon=E.echelonMobility[16]),"G"==N&&(t.echelon=E.echelonMobility[17]),"H"==N&&(t.echelon=E.echelonMobility[18]),"I"==N&&(t.echelon=E.echelonMobility[21]),"J"==N&&(t.echelon=E.echelonMobility[22]),"K"==N&&(t.echelon=E.echelonMobility[23]),"L"==N&&"N"!=S&&(t.echelon=E.echelonMobility[24]),"M"==N&&(t.echelon=E.echelonMobility[25]),"N"==N&&(t.echelon=E.echelonMobility[26]),"M"==S)switch(N){case"O":t.mobility=E.echelonMobility[31];break;case"P":t.mobility=E.echelonMobility[32];break;case"Q":t.mobility=E.echelonMobility[33];break;case"R":t.mobility=E.echelonMobility[34];break;case"S":t.mobility=E.echelonMobility[35];break;case"T":t.mobility=E.echelonMobility[36];break;case"U":t.mobility=E.echelonMobility[41];break;case"V":t.mobility=E.echelonMobility[42];break;case"W":t.mobility=E.echelonMobility[37];break;case"Y":t.mobility=E.echelonMobility[51];break;case"Z":t.mobility=E.echelonMobility[52];break;default:t.mobility=void 0}if("N"==S)switch(N){case"S":t.mobility=E.echelonMobility[61];break;case"L":t.mobility=E.echelonMobility[62];break;default:t.mobility=void 0}return("A"==A&&"C"==T.charAt(0)||"G"==A&&"EVC"==T.substring(0,3)||"S"==A&&"X"==T.charAt(0))&&(t.civilian=!0),"Z"!=A&&"X"!=A||(-1<["P","U","F","N","H","A","S","G","W"].indexOf(e)&&(t.dimensionUnknown=!0),-1<["F","A"].indexOf(e)&&(t.dimension="Sea"),-1<["D","L","M","J","K"].indexOf(e)&&(t.affiliation="none")),"S"==A&&-1<["O-----","ED----","EP----","EV----","ZM----","ZN----","ZI----"].indexOf(T)&&(t.frame=!1),"E"==R&&"N"==A&&-1<["AA----","AB----","AC----","AD----","AE----","AG----","BB----","BC----","BF----","BM----","-C-----","CA----","CB----","CC----","CD----","CE----"].indexOf(T)&&(t.frame=!1),"U"==A&&-1<["WM----","WMD---","WMG---","WMGD--","WMGX--","WMGE--","WMGC--","WMGR--","WMGO--","WMM---","WMMD--","WMMX--","WMME--","WMMC--","WMMR--","WMMO--","WMF---","WMFD--","WMFX--","WMFE--","WMFC--","WMFR--","WMFO--","WMO---","WMOD--","WMX---","WME---","WMA---","WMC---","WMR---","WMB---","WMBD--","WMN---","WMS---","WMSX--","WMSD--","WD----","WDM---","WDMG--","WDMM--","ND----","E-----","V-----","X-----","NBS---","NBR---","NBW---","NM----","NA----"].indexOf(T)&&(t.STD2525?(t.fill=!1,"WD----"==T&&(t.fill=!0),-1<["ND----","NBS---","NBR---","NBW---","NM----","NA----"].indexOf(T)&&(t.fill=!0,t.frame=!1)):(t.frame=!1,-1<["E-----","V-----","X-----"].indexOf(T)&&(t.fill=!1,t.frame=!1))),"WAS"!=this.options.sidc.substr(0,3)&&"WOS"!=this.options.sidc.substr(0,3)&&"G"!=R||(t.frame=!1),"G"==R&&"O"==A&&-1<["V","L","P","I"].indexOf(T.charAt(0))&&(t.frame=!0,t.dimension=E.dimension[1]),t}function C(I,t,E){var R={},e={};for(var A in I._iconSIDC.letter)I._iconSIDC.letter.hasOwnProperty(A)&&I._iconSIDC.letter[A].call(this,R,e,t,E);return{icons:R,bbox:e}}function n(I,t){if("object"==typeof I){if(Array.isArray(I)){for(var E=0;E<I.length;E++)n.call(this,I[E],t);return}return I.icon=!0,"text"==I.type&&(I.hasOwnProperty("fontfamily")||(I.fontfamily="Arial"),I.hasOwnProperty("fontweight")||(I.fontweight="bold"),I.hasOwnProperty("textanchor")||(I.textanchor="middle"),I.hasOwnProperty("stroke")||(I.stroke=!1)),I.hasOwnProperty("fill")||(I.fill=t),void(I.hasOwnProperty("stroke")||(I.stroke=t))}}function a(I){var t=42,E=115;return 1==I.length&&(t=45,E=115),3==I.length&&(t=35,E=110),4<=I.length&&(t=32,E=110),{type:"text",stroke:!1,textanchor:"middle",x:100,y:E,fontsize:t,text:I}}function l(I){var t=30;return 3==I.length&&(t=25),4<=I.length&&(t=22),{type:"text",stroke:!1,textanchor:"middle",x:100,y:77,fontsize:t,text:I}}function r(I){var t=30,E=145;return 3==I.length&&(t=25,E=140),4<=I.length&&(t=20,E=135),{type:"text",stroke:!1,textanchor:"middle",x:100,y:E,fontsize:t,text:I}}function T(I,t,E,R,e,A){var C=t.affiliation||"Friend",T=t.frame,S=t.numberSIDC,N=E.iconColor[C],O=E.iconFillColor[C],G=E.none[C],o=E.black[C],M={"SP.I.ANTISATELLITE WEAPON":{type:"path",d:"m 100,110 0,9 m 0,-34 0,5 m 0,-9 -2,4 4,0 z m -10,9 0,20 20,0 0,-20 z m 25,0 0,20 25,0 0,-20 z m -30,0 -25,0 0,20 25,0 z m 0,10 5,0 m 20,0 5,0"},"SP.I.ASTRONOMICAL SATELLITE":{type:"path",d:"m 97,90 -1,-9 8,0 -1,9 m -5,20 1,9 2,0 1,-9 m 8,-10 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},"SP.I.BIOSATELLITE":{type:"path",d:"m 100,89 c 0,4.4 -3.6,8 -8,8 -4.4,0 -8,-3.6 -8,-8 0,-4.4 3.6,-8 8,-8 4.4,0 8,3.6 8,8 z m -10,10 0,20 20,0 0,-20 z m 25,0 0,20 25,0 0,-20 z m -30,0 -25,0 0,20 25,0 z m 0,10 5,0 m 20,0 5,0 m -17,-25 17,10 -1,2 -14,-7"},"SP.I.CAPSULE":{type:"path",d:"m 85,115 c -2,5 32,5 30,0 l -5,-30 c -1,-5 -19,-5 -20,0 z"}};for(var i in M["SP.I.CIVILIAN ASTRONOMICAL SATELLITE"]={type:"path",fill:R?O:!T&&O,d:"m 97,90 -1,-9 8,0 -1,9 m -5,20 1,9 2,0 1,-9 m 8,-10 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},M["SP.I.CIVILIAN BIOSATELLITE"]={type:"path",fill:R?O:!T&&O,d:"m 100,89 c 0,4.4 -3.6,8 -8,8 -4.4,0 -8,-3.6 -8,-8 0,-4.4 3.6,-8 8,-8 4.4,0 8,3.6 8,8 z m -10,10 0,20 20,0 0,-20 z m 25,0 0,20 25,0 0,-20 z m -30,0 -25,0 0,20 25,0 z m 0,10 5,0 m 20,0 5,0 m -17,-25 17,10 -1,2 -14,-7"},M["SP.I.CIVILIAN CAPSULE"]={type:"path",fill:R?O:!T&&O,d:"m 85,115 c -2,5 32,5 30,0 l -5,-30 c -1,-5 -19,-5 -20,0 z"},M["SP.I.CIVILIAN COMMUNICATIONS SATELLITE"]=[{type:"path",fill:R?O:!T&&O,d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"path",fill:!1,d:"m 100,90 0,9 M 75,81 c 16,12 34,12 50,0"}],M["SP.I.CIVILIAN EARTH OBSERVATION SATELLITE"]=[{type:"path",fill:R?O:!T&&O,d:"m 107,113 c 0,3.9 -3.1,7 -7,7 -3.9,0 -7,-3.1 -7,-7 0,-3.9 3.1,-7 7,-7 3.9,0 7,3.1 7,7 z m -17,-33 0,20 20,0 0,-20 z m 25,0 0,20 25,0 0,-20 z m -30,0 -25,0 0,20 25,0 z m 0,10 5,0 m 20,0 5,0"},{type:"path",fill:!1,d:"m 88,107 c 8,-9 16,-9 24,0"}],M["SP.I.CIVILIAN MINIATURIZED SATELLITE"]=[{type:"path",fill:R?O:!T&&O,d:"m 91.1,92 0,16 17.8,0 0,-16 z m 22.2,0 0,16 22.2,0 0,-16 z m -26.6,0 -22.2,0 0,16 22.2,0 z m 0,8 4.4,0 m 17.8,0 4.4,0"},{type:"path",fill:!1,d:"m 90,119 10,-9 10,9 m -20,-38 10,9 10,-9 m 35,9 -10,10 10,10 M 55,90 65,100 55,110"}],M["SP.I.CIVILIAN NAVIGATIONAL SATELLITE"]=[{type:"path",fill:R?O:!T&&O,d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"path",fill:!1,d:"m 88,87 c 8,6 16,6 24,0 m -20,8 8,-14 8,14"}],M["SP.I.CIVILIAN ORBITER SHUTTLE"]={type:"path",fill:R?O:!T&&O,d:"m 89,115 6,-25 c 3,-12 7,-12 10,0 l 6,25 -10,0 -1,5 -1,-5 z"},M["SP.I.CIVILIAN SATELLITE"]={type:"path",fill:R?O:!T&&O,d:"m 110,100 10,0 m -40,0 10,0 m -10,-10 -25,0 0,20 25,0 z m 40,0 0,20 25,0 0,-20 z m -30,0 0,20 20,0 0,-20 z"},M["SP.I.CIVILIAN SPACE STATION"]={type:"path",fill:R?O:!T&&O,d:"m 97.5,112.5 0,7.5 5,0 0,-7.5 z m 0,-32.5 5,0 0,26.4 -5,0 z m -0.3,7.6 C 83.3,88.2 72.5,93.5 72.5,100 c 0,6.9 12.3,12.5 27.5,12.5 15.2,0 27.5,-5.6 27.5,-12.5 0,-6.5 -11,-11.9 -25,-12.4 l 0,5.6 c 9.9,0.4 17.5,3.2 17.5,6.6 0,3.7 -8.9,6.7 -19.8,6.7 -10.9,0 -19.8,-3 -19.8,-6.7 0,-3.4 7.4,-6.1 17.1,-6.6 l 0,-5.6 c -0.1,0 -0.2,-0 -0.3,0 z"},M["SP.I.CIVILIAN TETHERED SATELLITE"]={type:"path",fill:R?O:!T&&O,d:"m 120,87 -20,12 m 33,-12 c 0,3.6 -2.9,6.5 -6.5,6.5 -3.6,0 -6.5,-2.9 -6.5,-6.5 0,-3.6 2.9,-6.5 6.5,-6.5 3.6,0 6.5,2.9 6.5,6.5 z m -23,22 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},M["SP.I.CIVILIAN WEATHER SATELLITE"]=[{type:"path",fill:R?O:!T&&O,d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:25,text:"WX"}],M["SP.I.CIVILIAN"]=a("CIV"),M["SP.I.CIVILIAN"].fill=R||S?O:!T&&O,M["SP.I.CIVILIAN"].stroke=o,M["SP.I.CIVILIAN"].strokewidth=3,M["SP.I.COMMUNICATIONS SATELLITE"]=[{type:"path",d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"path",fill:!1,d:"m 100,90 0,9 M 75,81 c 16,12 34,12 50,0"}],M["SP.M1.CYBERSPACE"]=l("CYB"),M["SP.M2.CYBERSPACE"]=r("CYB"),M["SP.I.EARTH OBSERVATION SATELLITE"]=[{type:"path",d:"m 107,113 c 0,3.9 -3.1,7 -7,7 -3.9,0 -7,-3.1 -7,-7 0,-3.9 3.1,-7 7,-7 3.9,0 7,3.1 7,7 z m -17,-33 0,20 20,0 0,-20 z m 25,0 0,20 25,0 0,-20 z m -30,0 -25,0 0,20 25,0 z m 0,10 5,0 m 20,0 5,0"},{type:"path",fill:!1,d:"m 88,107 c 8,-9 16,-9 24,0"}],M["SP.I.FF.CREWED SPACE VEHICLE"]={type:"path",stroke:!1,d:"m 100.3,62.4 c -1.8,-0 -4.3,3.7 -4.5,5.4 -2.5,11.3 -3.4,23.1 -6.2,33.4 -2.9,6.7 -6.8,8.3 -9.9,12.1 -3,3.6 -8.5,10.4 -8.5,10.4 l 0,6.4 c 0,0 5.9,0.9 8.9,1.2 3,0.2 8.7,0.1 8.7,0.1 l 0.3,4.3 4.3,0.2 0.2,3.1 5.8,0 0.9,6.5 0.9,-6.4 5.8,0 0.2,-3.1 4.3,-0.2 0.3,-4.3 c 0,0 5.7,0.1 8.7,-0.1 3,-0.2 8.9,-1.2 8.9,-1.2 l 0,-6.4 c 0,0 -5.5,-6.7 -8.5,-10.3 -3.1,-3.8 -7,-5.4 -9.9,-12.1 -2.8,-10.4 -3.7,-22.2 -6.2,-33.4 -0.3,-2.9 -2.7,-5.5 -4.5,-5.5 z"},M["SP.I.FF.SATELLITE"]=[{type:"path",stroke:!1,d:"m 115,70 20,0 0,55 -20,0 z m -25,5 20,0 0,45 -20,0 z m -25,-5 20,0 0,55 -20,0 z"},{type:"path",fill:!1,d:"M80,135 c10,-10 30,-10 40,0 M100,127 L100,100 M70,100 L130,100"}],M["SP.I.FF.SPACE STATION"]=[{type:"path",d:"m 103.1,97.4 c -12.4,0.3 -25.7,0.1 -36.7,6.7 -4.1,2.1 -8.5,5.9 -7.8,11 0.2,3.7 0.3,7.4 0.5,11.1 6.2,7.8 16.6,10.4 26,11.8 14,1.8 28.5,1.2 42.1,-3 5.2,-1.7 10.4,-4.3 14.2,-8.3 0.3,-5.1 -0.3,-10.4 0.7,-15.3 -1.2,-4.3 -5.9,-6.4 -9.7,-8.2 -9.2,-4 -19.3,-5.4 -29.2,-5.6 z m -3.2,9.6 c 10.1,-0.2 20.5,1.9 29.1,7.4 -13,8.4 -29.6,9.7 -44.3,6.1 -4.9,-1.3 -9.7,-3.3 -13.7,-6.4 8.8,-4.9 18.9,-6.9 28.9,-7.2 z",fill:R?O:G},{type:"path",fill:!1,stroke:"black",d:"m 96.9,107 c 0.7,-8.1 1.4,-16.3 2.1,-24.4 M 89.3,121.8 c 3.1,-13.2 6.2,-26.3 9.3,-39.5 4.9,12.7 9.7,25.5 14.6,38.2 m 27.8,-5.3 c -0.1,3.9 -0.2,7.8 -0.3,11.6 M 58.6,113.3 c 0.2,4.5 0.3,9 0.5,13.5 m -0.5,-1.2 c 3.5,6.3 11,8.6 17.6,10.5 16.4,4.1 33.9,3.9 50.1,-0.8 5.5,-1.8 11.8,-4.3 14.7,-9.7 m 0.5,-13 c -0.5,5.4 -6.1,8.1 -10.5,10 -15.4,5.7 -32.4,6.1 -48.5,3.6 -7.9,-1.4 -16.3,-3.4 -22.2,-9.2 -3.6,-3.9 -0.9,-9.6 3.4,-11.7 8.3,-5.2 18.3,-6.6 27.9,-7.5 13.5,-1 27.5,0 40.2,5.1 4.2,1.8 9.3,4.6 9.7,9.7 z m -13.3,1.6 c -8.2,-5.9 -18.8,-6.8 -28.6,-7 -9.5,0.1 -19.5,1.2 -27.6,6.4 l -0.6,0.5 m 58.9,-2.6 c -0.8,4.8 -6.1,6.4 -10,7.8 -13.2,3.7 -27.4,3.7 -40.5,-0 -3.8,-1.2 -8.1,-2.8 -9.8,-6.7 -0.7,-4.9 5,-7.1 8.7,-8.5 12.7,-4 26.6,-4 39.5,-1 4.4,1.2 9.8,2.8 11.9,7.3 l 0.1,0.5 0,0.5 z"},{type:"path",fill:"black",stroke:!1,d:"M 75.2,93.1 C 88.9,87 102.6,80.8 116.3,74.7 c 2.3,1.3 4.7,2.6 7,3.9 -13.7,6 -27.3,12 -41,18 -2.4,-1.2 -4.8,-2.3 -7.2,-3.5 z"}],M["SP.I.MANUAL TRACK"]=a("MAN"),M["SP.I.MILITARY"]=a("MIL"),M["SP.I.MINIATURIZED SATELLITE"]=[{type:"path",d:"m 91.1,92 0,16 17.8,0 0,-16 z m 22.2,0 0,16 22.2,0 0,-16 z m -26.6,0 -22.2,0 0,16 22.2,0 z m 0,8 4.4,0 m 17.8,0 4.4,0"},{type:"path",fill:!1,d:"m 90,119 10,-9 10,9 m -20,-38 10,9 10,-9 m 35,9 -10,10 10,10 M 55,90 65,100 55,110"}],M["SP.I.NAVIGATIONAL SATELLITE"]=[{type:"path",d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"path",fill:!1,d:"m 88,87 c 8,6 16,6 24,0 m -20,8 8,-14 8,14"}],M["SP.I.ORBITER SHUTTLE"]={type:"path",d:"m 89,115 6,-25 c 3,-12 7,-12 10,0 l 6,25 -10,0 -1,5 -1,-5 z"},M["SP.I.RE-ENTRY VEHICLE"]=a("RV"),M["SP.I.RECONNAISSANCE SATELLITE"]={type:"path",d:"m 106,100 9,20 m -21,-20 -9,20 m 17,-20 3,20 m -7,-20 -3,20 m 15,-30 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},M["SP.I.SATELLITE, GENERAL"]=a("SAT"),M["SP.I.SATELLITE"]={type:"path",d:"m 110,100 10,0 m -40,0 10,0 m -10,-10 -25,0 0,20 25,0 z m 40,0 0,20 25,0 0,-20 z m -30,0 0,20 20,0 0,-20 z"},M["SP.I.SPACE LAUNCH VEHICLE"]=a("SLV"),M["SP.I.SPACE STATION"]={type:"path",d:"m 97.5,112.5 0,7.5 5,0 0,-7.5 z m 0,-32.5 5,0 0,26.4 -5,0 z m -0.3,7.6 C 83.3,88.2 72.5,93.5 72.5,100 c 0,6.9 12.3,12.5 27.5,12.5 15.2,0 27.5,-5.6 27.5,-12.5 0,-6.5 -11,-11.9 -25,-12.4 l 0,5.6 c 9.9,0.4 17.5,3.2 17.5,6.6 0,3.7 -8.9,6.7 -19.8,6.7 -10.9,0 -19.8,-3 -19.8,-6.7 0,-3.4 7.4,-6.1 17.1,-6.6 l 0,-5.6 c -0.1,0 -0.2,-0 -0.3,0 z"},M["SP.I.SPACE VEHICLE"]=a("SV"),M["SP.I.TETHERED SATELLITE"]={type:"path",d:"m 120,87 -20,12 m 33,-12 c 0,3.6 -2.9,6.5 -6.5,6.5 -3.6,0 -6.5,-2.9 -6.5,-6.5 0,-3.6 2.9,-6.5 6.5,-6.5 3.6,0 6.5,2.9 6.5,6.5 z m -23,22 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},M["SP.I.WEATHER SATELLITE"]=[{type:"path",d:"m 110,109 5,0 m -30,0 5,0 m -5,-10 -25,0 0,20 25,0 z m 30,0 0,20 25,0 0,-20 z m -25,0 0,20 20,0 0,-20 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:100,fontsize:25,text:"WX"}],M["SP.M1.GEOSTATIONARY ORBIT (GO)"]=l("GO"),M["SP.M1.GEOSYNCHRONOUS ORBIT (GSO)"]=l("GSO"),M["SP.M1.HIGH EARTH ORBIT (HEO)"]=l("HEO"),M["SP.M1.LOW EARTH ORBIT (LEO)"]=l("LEO"),M["SP.M1.MEDIUM EARTH ORBIT (MEO)"]=l("MEO"),M["SP.M1.MOLNIYA ORBIT (MO)"]=l("MO"),M["SP.M2.INFRARED"]=r("IR"),M["SP.M2.OPTICAL"]=r("O"),M["SP.M2.RADAR"]=r("R"),M["SP.M2.SIGNALS INTELLIGENCE (SIGINT)"]=r("SI"),M["SPACE.MISSILE.ICON"]={type:"path",d:"M90,135 l0,-10 5,-5 0,-55 5,-5 5,5 0,55 5,5 0,10 -10,-10 z"},(R||S)&&(M["SPACE.MISSILE.ICON"].fill=T?E.fillColor.Unknown:E.iconFillColor.Unknown),M["SPACE.MISSILE.M1.BALLISTIC"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"B"},M["SPACE.MISSILE.M1.INTERCEPTOR"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"I"},M["SPACE.MISSILE.M1.SPACE"]=[{type:"text",stroke:!1,x:68,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:68,y:125,fontsize:30,text:"P"}],M["SPACE.MISSILE.M2.ARROW"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"A"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.GROUND-BASED INTERCEPTOR (GBI)"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"G"},M["SPACE.MISSILE.M2.INTERCONTINENTAL"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"I"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"C"}],M["SPACE.MISSILE.M2.INTERMEDIATE RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"I"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.LONG RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"L"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.MEDIUM RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"M"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.PATRIOT"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"P"},M["SPACE.MISSILE.M2.SHORT RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.SPACE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"P"}],M["SPACE.MISSILE.M2.STANDARD MISSILE - 3 (SM-3)"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"3"}],M["SPACE.MISSILE.M2.STANDARD MISSILE - TERMINAL PHASE (SM-T)"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"T"}],M["SPACE.MISSILE.M2.TERMINAL HIGH-ALTITUDE AREA DEFENSE (THAAD)"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"T"},M["SPACE.MISSILE.M2.CLOSE RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"C"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],M["SPACE.MISSILE.M2.DEBRIS"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"D"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"B"}],M["SPACE.MISSILE.M2.UNKNOWN"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"U"},M["SPACE.PLANET LANDER"]=a("PL"),M)M.hasOwnProperty(i)&&(I.hasOwnProperty(i)&&console.warn("Override of: "+i),n.call(this,M[i],N),I[i]=M[i])}s._symbolGeometries=E,s.addSymbolPart(function(I){var t,E=[],R=[],e=this.colors.frameColor[this.metadata.affiliation];if(!this.metadata.frame&&this.style.icon||void 0===this.metadata.baseGeometry.g.type)return{pre:E,post:R,bbox:this.metadata.baseGeometry.bbox};var A,C={type:this.metadata.baseGeometry.g.type};switch(C.type){case"path":C.d=this.metadata.baseGeometry.g.d;break;case"circle":C.cx=this.metadata.baseGeometry.g.cx,C.cy=this.metadata.baseGeometry.g.cy,C.r=this.metadata.baseGeometry.g.r}if(C.fill=this.colors.fillColor[this.metadata.affiliation],C.fillopacity=this.style.fillOpacity,C.stroke=e,C.strokewidth=10<=this.style.size?this.style.strokeWidth:10,this.style.frame&&0<this.style.outlineWidth&&("path"==C.type&&this.metadata.fill&&!this.style.monoColor?((A={type:this.metadata.baseGeometry.g.type}).d=this.metadata.baseGeometry.g.d+" Z",A.strokewidth=10<=this.style.size?this.style.strokeWidth:10):A=C,E.push(I.outline(A,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor))),""==this.style.monoColor&&this.style.fill||!this.metadata.notpresent||(C.strokedasharray=this.metadata.notpresent),R.push(C),this.metadata.space&&(t={Friend:{type:"path",stroke:!1,fill:e,d:"M 100,30 C 90,30 80,35 68.65625,50 l 62.6875,0 C 120,35 110,30 100,30"},Hostile:{type:"path",stroke:!1,fill:e,d:"M67,50 L100,20 133,50 z"},Neutral:{type:"path",stroke:!1,fill:e,d:"M45,50 l0,-20 110,0 0,20 z"},Unknown:{type:"path",stroke:!1,fill:e,d:"M 100 22.5 C 85 22.5 70 31.669211 66 50 L 134 50 C 130 31.669204 115 22.5 100 22.5 z"}},R.push(t[this.metadata.affiliation])),this.metadata.activity&&(t={Friend:{type:"path",stroke:!1,fill:e,d:"m 160,135 0,15 15,0 0,-15 z m -135,0 15,0 0,15 -15,0 z m 135,-85 0,15 15,0 0,-15 z m -135,0 15,0 0,15 -15,0 z"},Hostile:{type:"path",stroke:!1,fill:e,d:"M 100 28 L 89.40625 38.59375 L 100 49.21875 L 110.59375 38.59375 L 100 28 z M 38.6875 89.3125 L 28.0625 99.9375 L 38.6875 110.53125 L 49.28125 99.9375 L 38.6875 89.3125 z M 161.40625 89.40625 L 150.78125 100 L 161.40625 110.59375 L 172 100 L 161.40625 89.40625 z M 99.9375 150.71875 L 89.3125 161.3125 L 99.9375 171.9375 L 110.53125 161.3125 L 99.9375 150.71875"},Neutral:{type:"path",stroke:!1,fill:e,d:"m 140,140 15,0 0,15 -15,0 z m -80,0 0,15 -15,0 0,-15 z m 80,-80 0,-15 15,0 0,15 z m -80,0 -15,0 0,-15 15,0 z"},Unknown:{type:"path",stroke:!1,fill:e,d:"M 107.96875 31.46875 L 92.03125 31.71875 L 92.03125 46.4375 L 107.71875 46.4375 L 107.96875 31.46875 z M 47.03125 92.5 L 31.09375 92.75 L 31.09375 107.5 L 46.78125 107.5 L 47.03125 92.5 z M 168.4375 92.5 L 152.5 92.75 L 152.5 107.5 L 168.1875 107.5 L 168.4375 92.5 z M 107.96875 153.5625 L 92.03125 153.8125 L 92.03125 168.53125 L 107.71875 168.53125 L 107.96875 153.5625 z"}},R.push(t[this.metadata.affiliation])),this.metadata.cyberspace&&(t={Friend:{type:"path",stroke:!1,fill:e,d:"m 135,150 40,-40 0,40 z"},Hostile:{type:"path",stroke:!1,fill:e,d:"m 150,78 0,44 22,-22 z"},Neutral:{type:"path",stroke:!1,fill:e,d:"m 115,155 40,-40 0,40 z"},Unknown:{type:"path",stroke:!1,fill:e,d:"M 150 65.7 L 150 134 C 176 123 176 77.2 150 65.7 z"}},R.push(t[this.metadata.affiliation])),this.style.fill&&this.style.frame&&this.metadata.notpresent&&!this.metadata.unframed){switch((C={type:this.metadata.baseGeometry.g.type}).type){case"path":C.d=this.metadata.baseGeometry.g.d;break;case"circle":C.cx=this.metadata.baseGeometry.g.cx,C.cy=this.metadata.baseGeometry.g.cy,C.r=this.metadata.baseGeometry.g.r}C.fill=!1,C.stroke=this.colors.white[this.metadata.affiliation],C.strokewidth=parseFloat(this.style.strokeWidth)+1,C.strokedasharray=this.metadata.notpresent,R.push(C)}return{pre:E,post:R,bbox:this.metadata.baseGeometry.bbox}}),s.addSymbolPart(function(I){var t,E,R=[],e=[],A=new I.BBox({x1:50,x2:150,y1:50,y2:150}),C=[],T=[],S=[],N=[];if(this.style.icon){var O=this.colors.fillColor[this.metadata.affiliation],G=this.colors.fillColor.Neutral;E=this.colors.iconColor[this.metadata.affiliation];var o=this.colors.iconFillColor[this.metadata.affiliation],M=this.colors.none[this.metadata.affiliation],i=this.colors.black[this.metadata.affiliation],L=this.colors.white[this.metadata.affiliation],s=(this.metadata.STD2525?"2525":"APP6")+","+this.metadata.dimension+this.metadata.affiliation+this.metadata.notpresent+this.metadata.numberSIDC+",frame:"+this.style.frame+",alternateMedal:"+this.style.alternateMedal+",colors:{fillcolor:"+O+",neutralColor"+G+",iconColor:"+E+",iconFillColor:"+o+",none:"+M+",black:"+i+",white:"+L+"}";if(I._iconCache.hasOwnProperty(s)?C=I._iconCache[s].iconParts:(I._iconCache[s]={},C=I._iconCache[s].iconParts=I._getIconParts(this.metadata,this.colors,this.metadata.STD2525,this.style.monoColor,this.style.alternateMedal)),this.metadata.numberSIDC||(-1!=["WMGX--","WMMX--","WMFX--","WMX---","WMSX--"].indexOf(this.metadata.functionid)&&(A.y1=10,"Unknown"!=this.metadata.affiliation&&(A.x2=this.metadata.baseGeometry.bbox.x2+20)),I._iconCache[s].hasOwnProperty("letterSIDC")?(t=I._iconCache[s].letterSIDC.icons,N=I._iconCache[s].letterSIDC.bbox):"function"==typeof I._getIcons.letter?(I._iconCache[s].letterSIDC=I._getIcons.letter(I,C,this.metadata.STD2525),t=I._iconCache[s].letterSIDC.icons,N=I._iconCache[s].letterSIDC.bbox):console.warn("ms._getIcons.letter() is not present, you will need to load functionality for letter based SIDCs")),this.metadata.numberSIDC){var n=String(this.options.sidc).substr(4,2);I._iconCache[s].hasOwnProperty("numberSIDC")?I._iconCache[s].numberSIDC.symbolSet.hasOwnProperty(n)?(t=I._iconCache[s].numberSIDC.symbolSet[n].icons,T=I._iconCache[s].numberSIDC.symbolSet[n].m1,S=I._iconCache[s].numberSIDC.symbolSet[n].m2,N=I._iconCache[s].numberSIDC.symbolSet[n].bbox):"function"==typeof I._getIcons.number?(I._iconCache[s].numberSIDC.symbolSet[n]=I._getIcons.number(I,n,C,this.metadata.STD2525),t=I._iconCache[s].numberSIDC.symbolSet[n].icons,T=I._iconCache[s].numberSIDC.symbolSet[n].m1,S=I._iconCache[s].numberSIDC.symbolSet[n].m2,N=I._iconCache[s].numberSIDC.symbolSet[n].bbox):console.warn("ms._getIcons.number() is not present, you will need to load functionality for number based SIDCs"):(I._iconCache[s].numberSIDC={},I._iconCache[s].numberSIDC.symbolSet={},"function"==typeof I._getIcons.number?(I._iconCache[s].numberSIDC.symbolSet[n]=I._getIcons.number(I,n,C,this.metadata.STD2525),t=I._iconCache[s].numberSIDC.symbolSet[n].icons,T=I._iconCache[s].numberSIDC.symbolSet[n].m1,S=I._iconCache[s].numberSIDC.symbolSet[n].m2,N=I._iconCache[s].numberSIDC.symbolSet[n].bbox):console.warn("ms._getIcons.number() is not present, you will need to load functionality for number based SIDCs"))}var a=[{type:"path",stroke:!1,fill:E=this.colors.iconColor[this.metadata.affiliation],d:"m 94.8206,78.1372 c -0.4542,6.8983 0.6532,14.323 5.3424,19.6985 4.509,5.6933 11.309,9.3573 14.98,15.7283 3.164,6.353 -0.09,14.245 -5.903,17.822 -7.268,4.817 -18.6219,2.785 -22.7328,-5.249 -1.5511,-2.796 -2.3828,-5.931 -2.8815,-9.071 -3.5048,0.416 -7.0093,0.835 -10.5142,1.252 0.8239,8.555 5.2263,17.287 13.2544,21.111 7.8232,3.736 17.1891,3.783 25.3291,1.052 8.846,-3.103 15.737,-11.958 15.171,-21.537 0.05,-6.951 -4.272,-12.85 -9.134,-17.403 -4.526,-4.6949 -11.048,-8.3862 -12.401,-15.2748 -1.215,-2.3639 -0.889,-8.129 -0.889,-8.129 z m -0.6253,-20.5177 0,11.6509 11.6527,0 0,-11.6509 z"}];if(this.metadata.numberSIDC){var l=t[this.metadata.functionid.substr(0,6)];if(void 0===l&&95<=this.metadata.functionid.substr(4,2)&&(l=t[this.metadata.functionid.substr(0,4)+"00"]),void 0===l)"000000"!=this.metadata.functionid.substr(0,6)&&""!=this.metadata.functionid.substr(0,6)&&(e.push(a),this.validIcon=!1);else{var r=Number(this.metadata.functionid.substr(0,6));this.metadata.dismounted&&110301<=r&&r<=110403&&("00"!=this.metadata.functionid.substr(6,2)&&"00"!=this.metadata.functionid.substr(8,2)&&(l=[I._scale(.5,l)]),"00"==this.metadata.functionid.substr(6,2)&&"00"!=this.metadata.functionid.substr(8,2)&&(l=[I._translate(0,-10,I._scale(.7,l))]),"00"!=this.metadata.functionid.substr(6,2)&&"00"==this.metadata.functionid.substr(8,2)&&(l=[I._translate(0,10,I._scale(.7,l))])),e.push(l)}if(N.hasOwnProperty(this.metadata.functionid.substr(0,6))&&(A=new I.BBox(N[this.metadata.functionid.substr(0,6)])),"95"==this.metadata.functionid.substr(4,2)&&e.push(C["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]),"96"==this.metadata.functionid.substr(4,2)&&e.push(C["GR.IC.FF.DIVISION AND BELOW SUPPORT"]),"97"==this.metadata.functionid.substr(4,2)&&e.push(C["GR.IC.FF.CORPS SUPPORT"]),"98"==this.metadata.functionid.substr(4,2)&&e.push(C["GR.IC.FF.THEATRE SUPPORT"]),"00"!=this.metadata.functionid.substr(6,2)){var P=T[this.metadata.functionid.substr(6,2)];void 0===P?this.validIcon=!1:e.push(P)}if("00"!=this.metadata.functionid.substr(8,2)){var y=S[this.metadata.functionid.substr(8,2)];void 0===y?this.validIcon=!1:e.push(y)}}else{var c=this.options.sidc.substr(0,1)+"-"+this.options.sidc.substr(2,1)+"-"+this.options.sidc.substr(4,6);t.hasOwnProperty(c)?e.push(t[c]):"------"!=this.options.sidc.substr(4,6)&&""!=this.options.sidc.substr(4,6)&&(e.push(a),this.validIcon=!1),N[c]&&(A=new I.BBox(N[c]))}}return this.style.frame&&this.metadata.fill&&!this.style.monoColor&&!this.metadata.controlMeasure||0<this.style.outlineWidth&&R.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:R,post:e,bbox:A}}),s.addSymbolPart(function(I){var t,E=[],R=[],e=new I.BBox(this.metadata.baseGeometry.bbox),A=this.style.frameColor?this.style.frameColor[this.metadata.affiliation]:this.colors.iconColor[this.metadata.affiliation],C=new I.BBox;if(this.metadata.headquarters){var T=100,S=Number(this.style.hqStaffLength||I._hqStaffLength);-1<["AirFriend","AirNeutral","GroundFriend","GroundNeutral","SeaNeutral","SubsurfaceNeutral"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(T=e.y2),this.metadata.dimensionType+this.metadata.affiliationType=="SubsurfaceFriend"&&(T=e.y1),t={type:"path",d:"M"+e.x1+","+T+" L"+e.x1+","+(e.y2+S)},0<this.style.outlineWidth&&E.push(I.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push(t),C.y2=e.y2+S}if(this.metadata.taskForce){var N={"Corps/MEF":110,Army:145,"Army Group/front":180,"Region/Theater":215};t={type:"path",d:"M"+(100-(N=N[this.metadata.echelon]||90)/2)+","+e.y1+" L"+(100-N/2)+","+(e.y1-40)+" "+(100+N/2)+","+(e.y1-40)+" "+(100+N/2)+","+e.y1},0<this.style.outlineWidth&&E.push(I.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push(t),C.x1=Math.min(e.x1,100-N/2),C.x2=Math.max(e.x2,100+N/2),C.y1=e.y1-40}if(this.metadata.installation){var O=0;-1<["AirHostile","GroundHostile","SeaHostile"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(O=14),-1<["AirUnknown","GroundUnknown","SeaUnknown","AirFriend","SeaFriend"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(O=2),t={type:"path",fill:A,d:"M85,"+(e.y1+O-this.style.strokeWidth/2)+" 85,"+(e.y1-10)+" 115,"+(e.y1-10)+" 115,"+(e.y1+O-this.style.strokeWidth/2)+" 100,"+(e.y1-this.style.strokeWidth)+" Z"},0<this.style.outlineWidth&&E.push(I.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push(t),C.merge({y1:e.y1-10})}if(this.metadata.feintDummy){var G=e.y1-0-e.width()/2;t={type:"path",strokedasharray:I._dashArrays.feintDummy,d:"M100,"+G+" L"+e.x1+","+(e.y1-0)+" M100,"+G+" L"+e.x2+","+(e.y1-0)},0<this.style.outlineWidth&&E.push(I.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push(t),C.merge({y1:G})}if(this.metadata.echelon){var o=this.metadata.installation?15:0,M={"Team/Crew":{g:[{type:"circle",cx:100,cy:e.y1-20,r:15},{type:"path",d:"M80,"+(e.y1-10)+"L120,"+(e.y1-30)}],bbox:{y1:e.y1-40-o}},Squad:{g:[{type:"circle",fill:A,cx:100,cy:e.y1-20,r:7.5}],bbox:{y1:e.y1-20-7.5-o}},Section:{g:[{type:"circle",fill:A,cx:115,cy:e.y1-20,r:7.5},{type:"circle",fill:A,cx:85,cy:e.y1-20,r:7.5}],bbox:{y1:e.y1-20-7.5-o}},"Platoon/detachment":{g:[{type:"circle",fill:A,cx:100,cy:e.y1-20,r:7.5},{type:"circle",fill:A,cx:70,cy:e.y1-20,r:7.5},{type:"circle",fill:A,cx:130,cy:e.y1-20,r:7.5}],bbox:{y1:e.y1-20-7.5-o}},"Company/battery/troop":{g:[{type:"path",d:"M100,"+(e.y1-10)+"L100,"+(e.y1-35)}],bbox:{y1:e.y1-40-o}},"Battalion/squadron":{g:[{type:"path",d:"M90,"+(e.y1-10)+"L90,"+(e.y1-35)},{type:"path",d:"M110,"+(e.y1-10)+"L110,"+(e.y1-35)}],bbox:{y1:e.y1-40-o}},"Regiment/group":{g:[{type:"path",d:"M100,"+(e.y1-10)+"L100,"+(e.y1-35)},{type:"path",d:"M120,"+(e.y1-10)+"L120,"+(e.y1-35)},{type:"path",d:"M80,"+(e.y1-10)+"L80,"+(e.y1-35)}],bbox:{y1:e.y1-40-o}},Brigade:{g:[{type:"path",d:"M87.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o}},Division:{g:[{type:"path",d:"M70,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o,x1:70,x2:130}},"Corps/MEF":{g:[{type:"path",d:"M52.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M87.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M122.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o,x1:52.5,x2:147.5}},Army:{g:[{type:"path",d:"M35,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M70,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M140,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o,x1:35,x2:165}},"Army Group/front":{g:[{type:"path",d:"M17.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M52.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M87.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M122.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25       M157.5,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o,x1:17.5,x2:182.5}},"Region/Theater":{g:[{type:"path",d:"M0,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M35,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M70,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25    M140,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25     M175,"+(e.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:e.y1-15-25-o,x1:0,x2:200}},Command:{g:[{type:"path",d:"M70,"+(e.y1-22.5)+" l25,0 m-12.5,12.5 l0,-25   M105,"+(e.y1-22.5)+" l25,0 m-12.5,12.5 l0,-25"}],bbox:{y1:e.y1-15-25-o,x1:70,x2:130}}};M.hasOwnProperty(this.metadata.echelon)&&(t=M[this.metadata.echelon].g,0<this.style.outlineWidth&&E.push(I.outline({type:"translate",x:0,y:-o,draw:t},this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push({type:"translate",x:0,y:-o,draw:t}),C.merge(M[this.metadata.echelon].bbox))}if(this.metadata.mobility){this.style.frame||(e.y2=this.bbox.y2),"Neutral"==this.metadata.affiliation&&("Towed"!=this.metadata.mobility&&"Short towed array"!=this.metadata.mobility&&"Long towed Array"!=this.metadata.mobility||(e.y2+=8),"Over snow (prime mover)"!=this.metadata.mobility&&"Sled"!=this.metadata.mobility||(e.y2+=13));var i={"Wheeled limited cross country":{g:[{type:"path",d:"M 53,1 l 94,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8}],bbox:{y2:e.y2+16}},"Wheeled cross country":{g:[{type:"path",d:"M 53,1 l 94,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8},{type:"circle",cx:100,cy:8,r:8}],bbox:{y2:e.y2+16}},Tracked:{g:[{type:"path",d:"M 53,1 l 100,0 c15,0 15,15 0,15 l -100,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:e.y2+18,x1:42,x2:168}},"Wheeled and tracked combination":{g:[{type:"circle",cx:58,cy:8,r:8},{type:"path",d:"M 83,1 l 70,0 c15,0 15,15 0,15 l -70,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:e.y2+16,x2:168}},Towed:{g:[{type:"path",d:"M 63,1 l 74,0"},{type:"circle",cx:58,cy:3,r:8},{type:"circle",cx:142,cy:3,r:8}],bbox:{y2:e.y2+10}},Rail:{g:[{type:"path",d:"M 53,1 l 96,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:73,cy:8,r:8},{type:"circle",cx:127,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8}],bbox:{y2:e.y2+16}},"Over snow (prime mover)":{g:[{type:"path",d:"M 50,-9 l10,10 90,0"}],bbox:{y2:e.y2+9}},Sled:{g:[{type:"path",d:"M 145,-12  c15,0 15,15 0,15 l -90,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:e.y2+15,x1:42,x2:168}},"Pack animals":{g:[{type:"path",d:"M 80,20 l 10,-20 10,20 10,-20 10,20"}],bbox:{y2:e.y2+20}},Barge:{g:[{type:"path",d:"M 50,1 l 100,0 c0,10 -100,10 -100,0"}],bbox:{y2:e.y2+10}},Amphibious:{g:[{type:"path",d:"M 65,10 c 0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0"}],bbox:{y2:e.y2+20}},"Short towed array":{g:[{type:"path",fill:A,d:"M 50,5 l 100,0 M50,0 l10,0 0,10 -10,0 z M150,0 l-10,0 0,10 10,0 z M100,0 l5,5 -5,5 -5,-5 z"}],bbox:{y2:e.y2+10}},"Long towed Array":{g:[{type:"path",fill:A,d:"M 50,5 l 100,0 M50,0 l10,0 0,10 -10,0 z M150,0 l-10,0 0,10 10,0 z M105,0 l-10,0 0,10 10,0 z M75,0 l5,5 -5,5 -5,-5 z  M125,0 l5,5 -5,5 -5,-5 z"}],bbox:{y2:e.y2+10}}};i.hasOwnProperty(this.metadata.mobility)&&(t=i[this.metadata.mobility].g,0<this.style.outlineWidth&&E.push(I.outline({type:"translate",x:0,y:e.y2,draw:t},this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),R.push({type:"translate",x:0,y:e.y2,draw:t}),C.merge(i[this.metadata.mobility].bbox))}if(this.metadata.leadership){var L={Friend:{type:"path",d:"m 45,60 55,-25 55,25"}}[this.metadata.affiliation];L&&(E.push(L),C.merge({y1:e.y1-20}))}for(var s=0;s<E.length;s++)E[s].hasOwnProperty("fill")||(E[s].fill=!1),E[s].hasOwnProperty("stroke")||(E[s].stroke=A),E[s].hasOwnProperty("strokewidth")||(E[s].strokewidth=this.style.strokeWidth);for(s=0;s<R.length;s++)R[s].hasOwnProperty("fill")||(R[s].fill=!1),R[s].hasOwnProperty("stroke")||(R[s].stroke=A),R[s].hasOwnProperty("strokewidth")||(R[s].strokewidth=this.style.strokeWidth);return{pre:E,post:R,bbox:C}}),s.addSymbolPart(function(I){var t=[],E=[],R=this.metadata.baseGeometry.bbox,e=R.y1,A=R.y2;this.metadata.condition&&(this.metadata.fill&&""===this.style.monoColor&&!this.style.simpleStatusModifier?(!this.metadata.frame&&this.metadata.iconBottom&&(A=this.metadata.iconBottom),this.options.headquartersElement&&(A+=35),A+=this.metadata.mobility?25:5,E.push({type:"path",strokewidth:this.style.strokeWidth,fill:{FullyCapable:"rgb(0,255,0)",Damaged:"rgb(255,255,0)",Destroyed:"rgb(255,0,0)",FullToCapacity:"rgb(0, 180, 240)"}[this.metadata.condition],stroke:this.colors.frameColor[this.metadata.affiliation],d:"M"+R.x1+","+A+" l"+R.width()+",0 0,25 -"+R.width()+",0 z"}),A+=25):("Damaged"!=this.metadata.condition&&"Destroyed"!=this.metadata.condition||(E.push({type:"path",d:"M150,20 L50,180",strokewidth:2*this.style.strokeWidth,stroke:this.colors.frameColor[this.metadata.affiliation]}),e=20,A=180),"Destroyed"==this.metadata.condition&&E.push({type:"path",d:"M50,20 L150,180",strokewidth:2*this.style.strokeWidth,stroke:this.colors.frameColor[this.metadata.affiliation]})),0<this.style.outlineWidth&&t.push(I.outline(E,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)));return{pre:t,post:E,bbox:{y1:e,y2:A}}}),s.addSymbolPart(function(I){var t=[],E=[],R=this.bbox,e=R.x1,A=R.x2,C=R.y1,T=R.y2;if(""!==this.options.engagementBar){C-=6;var S=this.style.fontfamily,N=this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend;E.push({type:"text",text:this.options.engagementBar,x:100,y:R.y1-11,textanchor:"middle",fontsize:22,fontfamily:S,fontweight:"bold",fill:N,stroke:!1});var O=!1;this.metadata.fill&&""===this.style.monoColor&&(O={TARGET:"rgb(255, 0, 0)","NON-TARGET":"rgb(255, 255, 255)",EXPIRED:"rgb(255, 120, 0)"}[this.options.engagementType.toUpperCase()]||this.colors.fillColor[this.metadata.affiliation]);var G,o=Math.max(R.width(),16*this.options.engagementBar.length);e=Math.min(e,100-o/2),A=Math.max(A,100+o/2),E.unshift({type:"path",strokewidth:this.style.strokeWidth,fill:O,stroke:this.colors.frameColor[this.metadata.affiliation],d:"M"+(100-o/2)+","+C+" l"+o+",0 0,-25 -"+o+",0 z"}),C-=25,0<this.style.outlineWidth&&(G=this.metadata.fill&&""===this.style.monoColor?E[0]:E,t.push(I.outline(G,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)))}return{pre:t,post:E,bbox:{x1:e,x2:A,y1:C,y2:T}}}),s.addSymbolPart(function(I){var t=[],E=[],R=this.metadata.baseGeometry.bbox,e=this.colors.frameColor[this.metadata.affiliation];if(this.metadata.dimensionUnknown&&e&&E.push({type:"text",text:"?",x:100,y:127,fill:e,fontfamily:this.style.fontfamily,fontsize:80,fontweight:"bold",textanchor:"middle"}),this.metadata.baseGeometry.g&&e){var A=10;("Unknown"==this.metadata.affiliation||"Hostile"==this.metadata.affiliation&&"Subsurface"!=this.metadata.dimension)&&(A=-10),"Exercise"==this.metadata.context&&(this.metadata.joker||this.metadata.faker||E.push({type:"text",text:"X",x:R.x2+A,y:60,fill:e,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),this.metadata.joker&&E.push({type:"text",text:"J",x:R.x2+A,y:60,fill:e,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),this.metadata.faker&&E.push({type:"text",text:"K",x:R.x2+A,y:60,fill:e,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),R={x2:R.x2+A+22,y1:35}),"Simulation"==this.metadata.context&&(E.push({type:"text",text:"S",x:R.x2+A,y:60,fill:e,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),R=new I.BBox({x2:R.x2+A+22,y1:35}))}return 0<this.style.outlineWidth&&t.push(I.outline(E,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:t,post:E,bbox:R}}),s.addSymbolPart(function(I){var t,E,R=[],e=[],A=this.metadata.baseGeometry.bbox,S=("object"==typeof this.style.infoColor?this.style.infoColor[this.metadata.affiliation]:this.style.infoColor)||this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend,N=this.style.fontfamily,O=this.style.infoSize,C="object"==typeof this.style.infoBackground?this.style.infoBackground[this.metadata.affiliation]:this.style.infoBackground,T="object"==typeof this.style.infoBackground?this.style.infoBackground[this.metadata.affiliation]:this.style.infoBackground,G=new I.BBox,o=20;function M(I){var t,E=[];for(var R in I)if(this.options.hasOwnProperty(R)&&""!=this.options[R]){if(!I.hasOwnProperty(R))continue;for(var e=0;e<(I[R].length||1);e++){var A;if(t={y2:(A=Array.isArray(I[R])?I[R][e]:I[R]).y,y1:A.y-A.fontsize},"start"==A.textanchor&&(t.x1=A.x,t.x2=A.x+i(this.options[R])*(A.fontsize/O)),"middle"==A.textanchor){var C=i(this.options[R])*(A.fontsize/O);t.x1=A.x-C/2,t.x2=A.x+C/2}"end"==A.textanchor&&(t.x1=A.x-i(this.options[R])*(A.fontsize/O),t.x2=A.x),G.merge(t);var T={type:"text",fontfamily:N,fill:S};A.hasOwnProperty("fill")&&(T.fill=A.fill),A.hasOwnProperty("stroke")&&(T.stroke=A.stroke),A.hasOwnProperty("textanchor")&&(T.textanchor=A.textanchor),A.hasOwnProperty("fontsize")&&(T.fontsize=A.fontsize),A.hasOwnProperty("fontweight")&&(T.fontweight=A.fontweight),T.x=A.x,T.y=A.y,T.text=this.options[R],E.push(T)}}return E}function i(I){if(0==I.length)return 0;for(var t={" ":9,"!":10,'"':15,"#":17,$:17,"%":27,"&":22,"'":8,"(":10,")":10,"*":12,"+":18,",":9,"-":10,".":9,"/":9,0:17,1:17,2:17,3:17,4:17,5:17,6:17,7:17,8:17,9:17,":":10,";":10,"<":18,"=":18,">":18,"?":19,"@":30,A:22,B:22,C:22,D:22,E:21,F:19,G:24,H:22,I:9,J:17,K:22,L:19,M:25,N:22,O:24,P:21,Q:24,R:22,S:21,T:19,U:22,V:21,W:29,X:21,Y:21,Z:19,"[":10,"]":10,"^":18,_:17,"`":10,a:17,b:19,c:17,d:19,e:17,f:10,g:19,h:19,i:9,j:9,k:17,l:9,m:27,n:19,o:19,p:19,q:19,r:12,s:17,t:10,u:19,v:17,w:24,x:17,y:17,z:15,"{":12,"|":9,"}":12,"~":18},E=0,R=0;R<I.length;R++)E+=O/30*(t[I[R]]?t[I[R]]:28.5);return E+=o}if(this.metadata.numberSIDC){if(!I._labelCache.hasOwnProperty("number"))for(t in I._labelCache.number={},I._labelOverrides.number)I._labelOverrides.number.hasOwnProperty(t)&&I._labelOverrides.number[t].call(this,I._labelCache.number);if(E=this.metadata.functionid.substr(0,6),this.metadata.controlMeasure&&I._labelCache.number.hasOwnProperty(E))return e.push(M.call(this,I._labelCache.number[E])),0<this.style.outlineWidth&&R.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:R,post:e,bbox:G}}else{if(!I._labelCache.hasOwnProperty("letter"))for(t in I._labelCache.letter={},I._labelOverrides.letter)I._labelOverrides.letter.hasOwnProperty(t)&&I._labelOverrides.letter[t].call(this,I._labelCache.letter);if(E=this.options.sidc.substr(0,1)+"-"+this.options.sidc.substr(2,1)+"-"+this.options.sidc.substr(4,6),I._labelCache.letter.hasOwnProperty(E))return e.push(M.call(this,I._labelCache.letter[E])),0<this.style.outlineWidth&&R.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:R,post:e,bbox:G}}var L,s,n,a=this.options.quantity||this.options.reinforcedReduced||this.options.staffComments||this.options.additionalInformation||this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.higherFormation||this.options.hostile||this.options.iffSif||this.options.sigint||this.options.uniqueDesignation||this.options.type||this.options.dtg||this.options.altitudeDepth||this.options.location||this.options.speed||this.options.specialHeadquarters||this.options.platformType||this.options.equipmentTeardownTime||this.options.commonIdentifier||this.options.auxiliaryEquipmentIndicator||this.options.headquartersElement||this.options.installationComposition||this.options.guardedUnit||this.options.specialDesignator;if(this.style.infoFields&&a){this.options.specialHeadquarters&&e.push((L=this.options.specialHeadquarters,s=42,n=115,1==L.length&&(s=45,n=115),3==L.length&&(s=35,n=110),4<=L.length&&(s=32,n=110),{type:"text",text:L,x:100,y:n,textanchor:"middle",fontsize:s,fontfamily:N,fill:S,stroke:!1,fontweight:"bold"})),this.options.quantity&&!this.metadata.dismounted&&(e.push({type:"text",text:this.options.quantity,x:100,y:A.y1-10,textanchor:"middle",fontsize:O,fontfamily:N,fill:S,stroke:!1}),G.y1=A.y1-10-O),this.options.headquartersElement&&(e.push({type:"text",text:this.options.headquartersElement,x:100,y:A.y2+35,textanchor:"middle",fontsize:35,fontfamily:N,fontweight:"bold",fill:S,stroke:!1}),G.y2=A.y2+35);var l,r={L1:"",L2:"",L3:"",L4:"",L5:"",R1:"",R2:"",R3:"",R4:"",R5:""};if(isNaN(this.options.sidc)||"Air"!=this.metadata.baseDimension||(r.R1=this.options.uniqueDesignation,r.R2=this.options.iffSif,r.R3=this.options.type,(this.options.speed||this.options.altitudeDepth)&&(l=[],this.options.speed&&l.push(this.options.speed),this.options.altitudeDepth&&l.push(this.options.altitudeDepth),r.R4=l.join("/")),(this.options.staffComments||this.options.additionalInformation)&&(l=[],this.options.staffComments&&l.push(this.options.staffComments),this.options.additionalInformation&&l.push(this.options.additionalInformation),r.R5=l.join("/"))),(isNaN(this.options.sidc)||"Ground"==this.metadata.baseDimension)&&(r.L1=this.options.dtg,(this.options.altitudeDepth||this.options.location)&&(l=[],this.options.altitudeDepth&&l.push(this.options.altitudeDepth),this.options.location&&l.push(this.options.location),r.L2=l.join("/")),r.L4=this.options.uniqueDesignation,r.L5=this.options.speed,r.R2=this.options.staffComments,r.R4=this.options.higherFormation,(this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.hostile||this.options.iffSif)&&(l=[],this.options.evaluationRating&&l.push(this.options.evaluationRating),this.options.combatEffectiveness&&l.push(this.options.combatEffectiveness),this.options.signatureEquipment&&l.push(this.options.signatureEquipment),this.options.hostile&&l.push(this.options.hostile),this.options.iffSif&&l.push(this.options.iffSif),r.R5=l.join("/")),isNaN(this.options.sidc)||this.metadata.unit?((this.options.type||this.options.platformType||this.options.equipmentTeardownTime)&&(l=[],this.options.type&&l.push(this.options.type),this.options.platformType&&l.push(this.options.platformType),this.options.equipmentTeardownTime&&l.push(this.options.equipmentTeardownTime),r.L3=l.join("/")),r.R1=this.options.reinforcedReduced,this.metadata.activity&&(r.R1=this.options.country),(this.options.additionalInformation||this.options.commonIdentifier)&&(l=[],this.options.additionalInformation&&l.push(this.options.additionalInformation),this.options.commonIdentifier&&l.push(this.options.commonIdentifier),r.R3=l.join("/"))):((this.options.type||this.options.platformType||this.options.commonIdentifier||this.options.installationComposition)&&(l=[],this.options.type&&l.push(this.options.type),this.options.platformType&&l.push(this.options.platformType),this.options.commonIdentifier&&l.push(this.options.commonIdentifier),this.options.installationComposition&&l.push(this.options.installationComposition),r.L3=l.join("/")),r.R1=this.options.country,(this.options.additionalInformation||this.options.equipmentTeardownTime)&&(l=[],this.options.additionalInformation&&l.push(this.options.additionalInformation),this.options.equipmentTeardownTime&&l.push(this.options.equipmentTeardownTime),r.R3=l.join("/")))),this.metadata.dismounted&&(this.options.quantity&&(e.push({type:"text",text:this.options.quantity,x:100,y:A.y2+O,textanchor:"middle",fontsize:O,fontfamily:N,fill:S,stroke:!1}),G.y2=A.y2+O),r.L1=this.options.dtg,(this.options.altitudeDepth||this.options.location)&&(l=[],this.options.altitudeDepth&&l.push(this.options.altitudeDepth),this.options.location&&l.push(this.options.location),r.L2=l.join("/")),(this.options.type||this.options.platformType||this.options.commonIdentifier)&&(l=[],this.options.type&&l.push(this.options.type),this.options.platformType&&l.push(this.options.platformType),this.options.commonIdentifier&&l.push(this.options.commonIdentifier),r.L3=l.join("/")),r.L4=this.options.uniqueDesignation,r.L5=this.options.speed,r.R1=this.options.country,r.R2=this.options.staffComments,this.options.additionalInformation&&(l=[],this.options.additionalInformation&&l.push(this.options.additionalInformation),r.R3=l.join("/")),r.R4=this.options.higherFormation,(this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.hostile||this.options.iffSif)&&(l=[],this.options.evaluationRating&&l.push(this.options.evaluationRating),this.options.combatEffectiveness&&l.push(this.options.combatEffectiveness),this.options.signatureEquipment&&l.push(this.options.signatureEquipment),this.options.hostile&&l.push(this.options.hostile),this.options.iffSif&&l.push(this.options.iffSif),r.R5=l.join("/"))),isNaN(this.options.sidc)||"Sea"!=this.metadata.baseDimension||((this.options.guardedUnit||this.options.specialDesignator)&&(l=[],this.options.guardedUnit&&l.push(this.options.guardedUnit),this.options.specialDesignator&&l.push(this.options.specialDesignator),r.L1=l.join("/")),r.R1=this.options.uniqueDesignation,r.R2=this.options.type,r.R3=this.options.iffSif,(this.options.staffComments||this.options.additionalInformation)&&(l=[],this.options.staffComments&&l.push(this.options.staffComments),this.options.additionalInformation&&l.push(this.options.additionalInformation),r.R4=l.join("/")),(this.options.location||this.options.speed)&&(l=[],this.options.location&&l.push(this.options.location),this.options.speed&&l.push(this.options.speed),r.R5=l.join("/"))),isNaN(this.options.sidc)||"Subsurface"!=this.metadata.baseDimension||(r.L1=this.options.specialDesignator,r.R1=this.options.uniqueDesignation,r.R2=this.options.type,r.R3=this.options.altitudeDepth,r.R4=this.options.staffComments,r.R5=this.options.additionalInformation),G.x1=A.x1-Math.max(this.options.specialHeadquarters?(i(this.options.specialHeadquarters)-this.metadata.baseGeometry.bbox.width())/2:0,this.options.quantity?(i(this.options.quantity)-this.metadata.baseGeometry.bbox.width())/2:0,i(r.L1),i(r.L2),i(r.L3),i(r.L4),i(r.L5)),G.x2=A.x2+Math.max(this.options.specialHeadquarters?(i(this.options.specialHeadquarters)-this.metadata.baseGeometry.bbox.width())/2:0,this.options.quantity?(i(this.options.quantity)-this.metadata.baseGeometry.bbox.width())/2:0,i(r.R1),i(r.R2),i(r.R3),i(r.R4),i(r.R5)),(r.L1||r.R1)&&(G.y1=Math.min(G.y1,100-2.5*O)),(r.L2||r.R2)&&(G.y1=Math.min(G.y1,100-1.5*O)),(r.L4||r.R4)&&(G.y2=Math.max(G.y2,100+1.7*O)),(r.L5||r.R5)&&(G.y2=Math.max(G.y2,100+2.7*O)),this.style.infoBackground){var P={x1:100,y1:1e3,y2:0},y={x2:100,y1:1e3,y2:0};r.L1&&(P={x1:Math.min(P.x1,A.x1-i(r.L1)),x2:A.x1-o/2,y1:Math.min(P.y1,100-2.5*O),y2:Math.max(P.y2,100-1.5*O+o/2)}),r.L2&&(P={x1:Math.min(P.x1,A.x1-i(r.L2)),x2:A.x1-o/2,y1:Math.min(P.y1,100-1.5*O),y2:Math.max(P.y2,100-.5*O+o/2)}),r.L3&&(P={x1:Math.min(P.x1,A.x1-i(r.L3)),x2:A.x1-o/2,y1:Math.min(P.y1,100-.5*O),y2:Math.max(P.y2,100+.5*O+o/2)}),r.L4&&(P={x1:Math.min(P.x1,A.x1-i(r.L4)),x2:A.x1-o/2,y1:Math.min(P.y1,100+.5*O),y2:Math.max(P.y2,100+1.5*O+o/2)}),r.L5&&(P={x1:Math.min(P.x1,A.x1-i(r.L5)),x2:A.x1-o/2,y1:Math.min(P.y1,100+1.5*O),y2:Math.max(P.y2,100+2.5*O+o/2)}),P.hasOwnProperty("x2")&&(G.x1-=O/2,e.push({type:"path",d:"M "+(P.x1-O/2)+","+(P.y1+O/2)+" "+P.x1+","+P.y1+" "+P.x2+","+P.y1+" "+P.x2+","+P.y2+" "+(P.x1-O/2)+","+P.y2+"z",fill:C,stroke:T||!1})),r.R1&&(y={x1:A.x2+o/2,x2:Math.max(y.x2,A.x2+i(r.R1)),y1:Math.min(y.y1,100-2.5*O),y2:Math.max(y.y2,100-1.5*O+o/2)}),r.R2&&(y={x1:A.x2+o/2,x2:Math.max(y.x2,A.x2+i(r.R2)),y1:Math.min(y.y1,100-1.5*O),y2:Math.max(y.y2,100-.5*O+o/2)}),r.R3&&(y={x1:A.x2+o/2,x2:Math.max(y.x2,A.x2+i(r.R3)),y1:Math.min(y.y1,100-.5*O),y2:Math.max(y.y2,100+.5*O+o/2)}),r.R4&&(y={x1:A.x2+o/2,x2:Math.max(y.x2,A.x2+i(r.R4)),y1:Math.min(y.y1,100+.5*O),y2:Math.max(y.y2,100+1.5*O+o/2)}),r.R5&&(y={x1:A.x2+o/2,x2:Math.max(y.x2,A.x2+i(r.R5)),y1:Math.min(y.y1,100+1.5*O),y2:Math.max(y.y2,100+2.5*O+o/2)}),y.hasOwnProperty("x1")&&(G.x2+=O/2,e.push({type:"path",d:"M "+y.x1+","+y.y1+" "+(y.x2+O/2)+","+y.y1+" "+(y.x2+O/2)+","+(y.y2-O/2)+" "+y.x2+","+y.y2+" "+y.x1+","+y.y2+"z",fill:C,stroke:T||!1}))}r.L1&&e.push({type:"text",text:r.L1,x:A.x1-o,y:100-1.5*O,textanchor:"end",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.L2&&e.push({type:"text",text:r.L2,x:A.x1-o,y:100-.5*O,textanchor:"end",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.L3&&e.push({type:"text",text:r.L3,x:A.x1-o,y:100+.5*O,textanchor:"end",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.L4&&e.push({type:"text",text:r.L4,x:A.x1-o,y:100+1.5*O,textanchor:"end",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.L5&&e.push({type:"text",text:r.L5,x:A.x1-o,y:100+2.5*O,textanchor:"end",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.R1&&e.push({type:"text",text:r.R1,x:A.x2+o,y:100-1.5*O,textanchor:"start",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.R2&&e.push({type:"text",text:r.R2,x:A.x2+o,y:100-.5*O,textanchor:"start",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.R3&&e.push({type:"text",text:r.R3,x:A.x2+o,y:100+.5*O,textanchor:"start",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.R4&&e.push({type:"text",text:r.R4,x:A.x2+o,y:100+1.5*O,textanchor:"start",fontsize:O,fontfamily:N,fill:S,stroke:!1}),r.R5&&e.push({type:"text",text:r.R5,x:A.x2+o,y:100+2.5*O,textanchor:"start",fontsize:O,fontfamily:N,fill:S,stroke:!1}),0<this.style.outlineWidth&&R.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor))}return{pre:R,post:e,bbox:G}}),s.addSymbolPart(function(I){var t=[],E=[],R=this.metadata.baseGeometry.bbox;""==this.metadata.baseGeometry.g&&(R=this.bbox);var e,A=new I.BBox,C=this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend;if(this.style.infoFields&&""!==this.options.direction){if(0==this.options.speedLeader)e=[{type:"rotate",degree:this.options.direction,x:100,y:100,draw:[{type:"path",fill:C,stroke:C,strokewidth:this.style.strokeWidth,d:"M100,100 l0,-75 -5,3 5,-15 5,15 -5,-3"}]}],A.y1=Math.min(100-95*Math.cos(this.options.direction/360*Math.PI*2),100),A.y2=Math.max(100-95*Math.cos(this.options.direction/360*Math.PI*2),100),A.x1=Math.min(100+95*Math.sin(this.options.direction/360*Math.PI*2),100),A.x2=Math.max(100+95*Math.sin(this.options.direction/360*Math.PI*2),100),"Ground"!=this.metadata.baseDimension&&""!=this.metadata.baseDimension||(this.metadata.headquarters?(e=[{type:"translate",x:R.x1-100,y:R.y2-(100-(this.style.hqStaffLength||I._hqStaffLength)),draw:e}],A.x1+=R.x1-100,A.x2+=R.x1-100):e=[{type:"translate",x:0,y:R.y2,draw:e},{type:"path",fill:C,stroke:C,strokewidth:this.style.strokeWidth,d:"M 100,"+R.y2+"l0,100"}]),A.y2+=R.y2+parseFloat(this.style.strokeWidth),E.push(e);else{var T=this.options.speedLeader*(100/this.style.size),S=this.options.direction*Math.PI/180,N=-T*Math.cos(S),O=T*Math.sin(S);A.x1=Math.min(100,100+O),A.x2=Math.max(100,100+O),A.y1=Math.min(100,100+N),A.y2=Math.max(100,100+N),e={type:"path",fill:C,stroke:C,strokewidth:this.style.strokeWidth,d:"M 100,100  l"+O+","+N},t.push(e)}0<this.style.outlineWidth&&t.unshift(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor))}return{pre:t,post:E,bbox:A}}),e.prototype.asCanvas=function(I){if(void 0===s._brokenPath2D)if("undefined"==typeof Path2D)s.setBrokenPath2D(!0);else{var t=document.createElement("canvas");t.widht=1,t.height=1;var E=t.getContext("2d"),R=new Path2D("M0 0 h 10 v 10 h -10 Z");E.fill(R);var e=E.getImageData(0,0,1,1).data.join();s.setBrokenPath2D(!("0,0,0,255"==e))}var A=document.createElement("canvas");I=I||1,A.width=this.width*I,A.height=this.height*I;var C=A.getContext("2d");return C.scale(I*this.style.size/100,I*this.style.size/100),C.translate(-(this.bbox.x1-this.style.strokeWidth-this.style.outlineWidth),-(this.bbox.y1-this.style.strokeWidth-this.style.outlineWidth)),this.canvasDraw.call(this,C,this.drawInstructions),A},e.prototype.canvasDraw=function I(t,E){for(var R=0;R<E.length;R++)if(Array.isArray(E[R]))E[R].length&&I.call(this,t,E[R]);else if("object"==typeof E[R]){switch(t.lineWidth=E[R].strokewidth||this.style.strokeWidth,void 0!==E[R].stroke&&(E[R].stroke?t.strokeStyle=E[R].stroke:t.strokeStyle="rgba(0,0,0,0)"),E[R].strokedasharray?t.setLineDash(E[R].strokedasharray.split(",")):0!=t.getLineDash().length&&t.setLineDash([]),E[R].linecap&&(t.lineCap=E[R].linecap,t.lineJoin=E[R].linecap),E[R].fill&&(t.fillStyle=E[R].fill),E[R].fill||(t.fillStyle="rgba(0,0,0,0)"),void 0!==E[R].fillopacity&&(t.globalAlpha=E[R].fillopacity),E[R].type){case"path":if(s._brokenPath2D)"function"==typeof s.Path2D?(s.Path2D(t,E[R].d),(void 0===E[R].fill||void 0!==E[R].fill&&E[R].fill)&&t.fill(),1!=t.globalAlpha&&(t.globalAlpha=1),(void 0===E[R].stroke||void 0!==E[R].stroke&&E[R].stroke)&&t.stroke()):console.warn("ms.Path2D() is not present, you will need to load functionality for using Canvas in older version of Internet Explorer.");else{var e=new Path2D(E[R].d);E[R].hasOwnProperty("clipPath")&&(t.save(),t.clip(new Path2D(E[R].clipPath),"nonzero")),(void 0===E[R].fill||void 0!==E[R].fill&&E[R].fill)&&t.fill(e),E[R].hasOwnProperty("clipPath")&&t.restore(),1!=t.globalAlpha&&(t.globalAlpha=1),(void 0===E[R].stroke||void 0!==E[R].stroke&&E[R].stroke)&&t.stroke(e)}break;case"circle":E[R].hasOwnProperty("clipPath")&&(t.save(),t.clip(new Path2D(E[R].clipPath),"nonzero")),t.beginPath(),t.arc(E[R].cx,E[R].cy,E[R].r,0,2*Math.PI,!1),(void 0===E[R].fill||void 0!==E[R].fill&&E[R].fill)&&t.fill(),E[R].hasOwnProperty("clipPath")&&t.restore(),(void 0===E[R].stroke||void 0!==E[R].stroke&&E[R].stroke)&&t.stroke();break;case"text":t.font=(void 0!==E[R].fontweight?E[R].fontweight+" ":"")+E[R].fontsize+"px "+E[R].fontfamily,t.textAlign="middle"==E[R].textanchor?"center":E[R].textanchor,t.fillText(E[R].text,E[R].x,E[R].y),E[R].stroke&&t.strokeText(E[R].text,E[R].x,E[R].y);break;case"translate":t.save(),t.translate(E[R].x,E[R].y),I.call(this,t,E[R].draw),t.restore();break;case"rotate":var A=E[R].x,C=E[R].y;t.save(),t.translate(A,C),t.rotate(E[R].degree*Math.PI/180),t.translate(-A,-C),I.call(this,t,E[R].draw),t.restore();break;case"scale":t.save(),t.scale(E[R].factor,E[R].factor),I.call(this,t,E[R].draw),t.restore()}E[R].linecap&&(t.lineCap="butt",t.lineJoin="miter"),void 0!==E[R].fillopacity&&(t.globalAlpha=1)}},e.prototype.asDOM=function(){var I=document,t=(new DOMParser).parseFromString(this.asSVG(),"text/xml");return I.adoptNode(t.documentElement)},e.prototype.asSVG=function(){var I='<svg xmlns="'+s._svgNS+'" version="1.2" baseProfile="tiny" width="'+this.width+'" height="'+this.height+'" viewBox="'+(this.bbox.x1-this.style.strokeWidth-this.style.outlineWidth)+" "+(this.bbox.y1-this.style.strokeWidth-this.style.outlineWidth)+" "+this.baseWidth+" "+this.baseHeight+'">';return I+=function I(t){for(var E="",R=0;R<t.length;R++)if(Array.isArray(t[R]))t[R].length&&(E+=I.call(this,t[R]));else if("object"==typeof t[R]){var e="";if("svg"==t[R].type)e+=t[R].svg;else{switch(t[R].hasOwnProperty("clipPath")&&(e+='<clipPath id="clip">',e+='<path d="'+t[R].clipPath+'" clip-rule="nonzero" />',e+="</clipPath>"),t[R].type){case"path":e+='<path d="'+t[R].d+'" ',t[R].hasOwnProperty("clipPath")&&(e+='clip-path="url(#clip)" ');break;case"circle":e+='<circle cx="'+t[R].cx+'" cy="'+t[R].cy+'" r="'+t[R].r+'" ',t[R].hasOwnProperty("clipPath")&&(e+='clip-path="url(#clip)" ');break;case"text":e+='<text x="'+t[R].x+'" y="'+t[R].y+'" text-anchor="'+t[R].textanchor+'" font-size="'+t[R].fontsize+'" font-family="'+t[R].fontfamily+'" ',t[R].fontweight&&(e+='font-weight="'+t[R].fontweight+'" ');break;case"translate":e+='<g transform="translate('+t[R].x+","+t[R].y+')" ';break;case"rotate":e+='<g transform="rotate('+t[R].degree+","+t[R].x+","+t[R].y+')" ';break;case"scale":e+='<g transform="scale('+t[R].factor+')" '}switch(void 0!==t[R].stroke&&(e+='stroke-width="'+(t[R].strokewidth||this.style.strokeWidth)+'" ',t[R].strokedasharray&&(e+='stroke-dasharray="'+t[R].strokedasharray+'" '),t[R].linecap&&(e+='stroke-linecap="'+t[R].linecap+'" ',e+='stroke-linejoin="'+t[R].linecap+'" '),t[R].stroke?e+='stroke="'+t[R].stroke+'" ':e+='stroke="none" '),void 0!==t[R].fill&&(e+='fill="'+(t[R].fill?t[R].fill:"none")+'" '),void 0!==t[R].fillopacity&&(e+='fill-opacity="'+t[R].fillopacity+'" '),e+=">",t[R].type){case"path":e+="</path>";break;case"circle":e+="</circle>";break;case"text":e+=String(t[R].text).replace("&","&amp;")+"</text>";break;case"translate":case"rotate":case"scale":e+=I.call(this,t[R].draw),e+="</g>"}}E+=e}return E}.call(this,this.drawInstructions),I+="</svg>",this.XML=I},e.prototype.getAnchor=function(){return this.symbolAnchor},e.prototype.getColors=function(){var I="object"==typeof this.style.colorMode?this.style.colorMode:s.getColorMode(this.style.colorMode),t="object"==typeof this.style.frameColor?this.style.frameColor:s.getColorMode("FrameColor"),E="object"==typeof this.style.iconColor?this.style.iconColor:s.getColorMode("IconColor"),R=I,e=s.getColorMode("Black"),A=s.getColorMode("White"),C=s.getColorMode("OffWhite"),T=s.getColorMode("None");this.style.civilianColor&&this.metadata.civilian&&(I.Friend=I.Neutral=I.Unknown=I.Civilian,t.Friend=t.Neutral=t.Unknown=t.Civilian,E.Friend=E.Neutral=E.Unknown=E.Civilian),(this.metadata.joker||this.metadata.faker)&&(I.Friend=I.Hostile,t.Friend=t.Hostile,E.Friend=E.Hostile),""!=this.style.monoColor&&(t.Friend=t.Neutral=t.Hostile=t.Unknown=t.Civilian=this.style.monoColor,e=t,A=I=T);var S={fillColor:I,frameColor:t,iconColor:E,iconFillColor:R,none:T,black:e,white:A};return this.metadata.frame?S.frameColor="object"==typeof this.style.frameColor?this.style.frameColor:e:S.frameColor=T,this.metadata.fill?(S.fillColor=this.metadata.frame||!this.metadata.frame&&!this.style.icon?I:T,S.iconColor="object"==typeof this.style.iconColor?this.style.iconColor:e,S.iconFillColor=this.metadata.frame?C:I,S.white=C):(S.fillColor=T,S.frameColor=this.metadata.frame?t:T,S.iconColor=t,S.iconFillColor=T,this.metadata.frame||this.metadata.fill||this.style.icon||(S.frameColor=e,S.fillColor=e)),S},e.prototype.getOctagonAnchor=function(){return this.octagonAnchor},e.prototype.getMetadata=function(){var I={activity:!1,affiliation:"",baseAffilation:"",baseDimension:"",baseGeometry:{g:"",bbox:{}},civilian:!1,condition:"",context:"",dimension:"",dimensionUnknown:!1,echelon:"",faker:!1,fenintDummy:!1,fill:this.style.fill,frame:this.style.frame,functionid:"",headquarters:!1,installation:!1,joker:!1,mobility:"",notpresent:"",numberSIDC:!1,space:!1,STD2525:s._STD2525,taskForce:!1,unit:!1},t={context:["Reality","Exercise","Simulation"],status:["Present","Planned","FullyCapable","Damaged","Destroyed","FullToCapacity"],echelonMobility:{11:"Team/Crew",12:"Squad",13:"Section",14:"Platoon/detachment",15:"Company/battery/troop",16:"Battalion/squadron",17:"Regiment/group",18:"Brigade",21:"Division",22:"Corps/MEF",23:"Army",24:"Army Group/front",25:"Region/Theater",26:"Command",31:"Wheeled limited cross country",32:"Wheeled cross country",33:"Tracked",34:"Wheeled and tracked combination",35:"Towed",36:"Rail",37:"Pack animals",41:"Over snow (prime mover)",42:"Sled",51:"Barge",52:"Amphibious",61:"Short towed array",62:"Long towed Array",71:"Leader Individual",72:"Deputy Individual"},affiliation:["Hostile","Friend","Neutral","Unknown"],dimension:["Air","Ground","Sea","Subsurface"]};return I.context=t.context[0],this.style.standard&&(I.STD2525="APP6"!=this.style.standard),""!=this.style.monoColor&&(I.fill=!1),this.options.sidc=String(this.options.sidc).replace(/\*/g,"-").replace(/ /g,""),I.numberSIDC=!isNaN(this.options.sidc),I.numberSIDC?"function"==typeof s._getMetadata.number?I=s._getMetadata.number.call(this,s,I,t):console.warn("ms._getMetadata.number() is not present, you will need to load functionality for number based SIDCs"):"function"==typeof s._getMetadata.letter?I=s._getMetadata.letter.call(this,s,I,t):console.warn("ms._getMetadata.letter() is not present, you will need to load functionality for letter based SIDCs"),s._symbolGeometries.hasOwnProperty(I.dimension+I.affiliation)?I.baseGeometry=s._symbolGeometries[I.dimension+I.affiliation]:I.baseGeometry.bbox=new s.BBox,this.style.frame||this.style.icon||(I.baseGeometry=s._symbolGeometries.PositionMarker),I},e.prototype.getOptions=function(I){var t,E={};for(t in this.options)this.options.hasOwnProperty(t)&&(E[t]=this.options[t]);if(I||void 0===I)for(t in this.style)this.style.hasOwnProperty(t)&&(E[t]=this.style[t]);return E},e.prototype.getSize=function(){return void 0!==this.width&&void 0!==this.height||this.updateSymbol(),{width:this.width,height:this.height}},e.prototype.getStyle=function(){var I,t={};for(I in this.style)this.style.hasOwnProperty(I)&&(t[I]=this.style[I]);return t},e.prototype.isValid=function(I){var t=-1==JSON.stringify(this.drawInstructions).indexOf("null");return I?{drawInstructions:t,icon:this.validIcon,mobility:null!=this.metadata.mobility}:t&&this.validIcon&&null!=this.metadata.mobility},e.prototype.setOptions=function(){var I;for(I=0;I<arguments.length;I++){var t=arguments[I];if("object"==typeof t)for(var E in t)t.hasOwnProperty(E)&&("SIDC"!==E?this.style.hasOwnProperty(E)?this.style[E]=t[E]:this.options[E]=t[E]:this.options.sidc=t[E]);else this.options.sidc=t}for(I in this.validIcon=!0,this.metadata=this.getMetadata(),this.colors=this.getColors(),this.drawInstructions=[],this.bbox=new s.BBox,s._symbolParts)if(s._symbolParts.hasOwnProperty(I)){var R=s._symbolParts[I].call(this,s),e=0<R.pre.length||0<R.post.length;if(R.pre){if(0<R.pre.length){for(;1==R.pre.length;)R.pre=R.pre[0];0!=R.pre.length&&(this.drawInstructions=[].concat(R.pre,this.drawInstructions))}if(0<R.post.length){for(;1==R.post.length&&(R.post=R.post[0],void 0!==R.post););void 0!==R.post&&0==R.post.length||(this.drawInstructions=this.drawInstructions.concat(R.post))}"object"==typeof R.bbox&&e&&this.bbox.merge(R.bbox)}}this.style.padding&&(this.bbox.x1-=this.style.padding,this.bbox.x2+=this.style.padding,this.bbox.y1-=this.style.padding,this.bbox.y2+=this.style.padding);var A={x:100,y:100};if(this.octagonAnchor={x:(A.x-this.bbox.x1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100,y:(A.y-this.bbox.y1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100},this.metadata.headquarters){var C=this.style.hqStaffLength||s._hqStaffLength;A={x:this.metadata.baseGeometry.bbox.x1,y:this.metadata.baseGeometry.bbox.y2+C}}if(this.style.square){var T=Math.max(A.x-this.bbox.x1,this.bbox.x2-A.x),S=Math.max(A.y-this.bbox.y1,this.bbox.y2-A.y),N=Math.max(T,S);this.bbox.x1=A.x-N,this.bbox.y1=A.y-N,this.bbox.x2=A.x+N,this.bbox.y2=A.y+N}return this.baseWidth=this.bbox.width()+Number(2*this.style.strokeWidth)+Number(2*this.style.outlineWidth),this.baseHeight=this.bbox.height()+Number(2*this.style.strokeWidth)+Number(2*this.style.outlineWidth),this.width=this.baseWidth*this.style.size/100,this.height=this.baseHeight*this.style.size/100,this.symbolAnchor={x:(A.x-this.bbox.x1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100,y:(A.y-this.bbox.y1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100},s._autoValidation&&(this.isValid()||(console.warn("Error in symbol: "+this.options.sidc),console.warn(this.isValid(!0)))),this},e.prototype.toDataURL=function(){return"data:image/svg+xml;base64,"+window.btoa(this.asSVG())},s.Symbol=e,s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(T);var S={type:"letter",icons:function(I,t,E,R){I["S-P-------"]=[],I["S-P-S-----"]=[E["SP.I.FF.SATELLITE"]],I["S-P-V-----"]=[E["SP.I.FF.CREWED SPACE VEHICLE"]],I["S-P-T-----"]=[E["SP.I.FF.SPACE STATION"]],I["S-P-L-----"]=[E["SP.I.SPACE LAUNCH VEHICLE"]]}};function N(I,t,E,R,e,A){var C=t.frame,T=t.affiliation||"Friend",S=t.numberSIDC,N=E.iconColor[T],O=E.iconFillColor[T],G=E.black[T],o={};for(var M in o["AR.I.MILITARY"]=a("MIL"),o["AR.I.CIVILIAN"]=a("CIV"),o["AR.I.CIVILIAN"].fill=R||S?O:!C&&O,o["AR.I.CIVILIAN"].stroke=G,o["AR.I.CIVILIAN"].strokewidth=3,o["AR.I.MILITARY FIXED WING"]={type:"path",d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},o["AR.I.CIVILIAN FIXED WING"]={type:"path",fill:!1,d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},o["AR.I.FF.CIVILIAN FIXED WING"]={type:"path",stroke:G,d:"M62,80 l30,0 0,-10 16,0 0,10 30,0 0,15 -30,0 0,25 10,0 0,5 -36,0 0,-5 10,0 0,-25 -30,0 Z M95,70 l0,-5 10,0 0,5",fill:!!R&&O},o["AR.I.MILITARY ROTARY WING"]={type:"path",d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},o["AR.I.CIVILIAN ROTARY WING"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},o["AR.I.FF.CIVILIAN ROTARY WING"]=[{type:"path",stroke:G,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:G,fill:!!R&&O,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"}],o["AR.I.MILITARY BALLOON"]=[{type:"circle",cx:100,cy:95,r:15},{type:"path",d:"M95,110 l0,10 10,0 0,-10 z"}],o["AR.I.FF.MILITARY BALLOON"]=[{type:"path",d:"M90,115 l20,0 0,20 -20,0 z"},{type:"circle",cx:100,cy:90,r:35}],o["AR.I.CIVILIAN BALLOON"]=[{type:"circle",fill:!(!R&&!S)&&O,stroke:G,cx:100,cy:95,r:15},{type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"M95,110 l0,10 10,0 0,-10 z"}],o["AR.I.FF.CIVILIAN BALLOON"]=[{type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"M90,125 l20,0 0,10 -20,0 z"},{type:"circle",fill:!(!R&&!S)&&O,stroke:G,cx:100,cy:90,r:35}],o["AR.I.MILITARY AIRSHIP"]={type:"path",d:"m 110,110 10,10 10,0 -5,-15 m 0,-10 5,-15 -10,0 -10,10 m 17.2,10 c 0,6.1 -12.2,11.1 -27.2,11.1 -15,0 -27.2,-5 -27.2,-11.1 0,-6.1 12.2,-11.1 27.2,-11.1 15,0 27.2,5 27.2,11.1 z"},o["AR.I.CIVILIAN AIRSHIP"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"m 110,110 10,10 10,0 -5,-15 m 0,-10 5,-15 -10,0 -10,10 m 17.2,10 c 0,6.1 -12.2,11.1 -27.2,11.1 -15,0 -27.2,-5 -27.2,-11.1 0,-6.1 12.2,-11.1 27.2,-11.1 15,0 27.2,5 27.2,11.1 z"},o["AR.I.UNMANNED AERIAL VEHICLE"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},o["AR.I.AIR DECOY"]={type:"path",d:"M65,95 l15,-15 0,30 Z M92.5,95 l15,-15 0,30 Z M120,95 l15,-15 0,30 Z M65,120 l70,0 0,-5 -70,0 Z"},o["SU.IC.AIR DECOY DSymbol"]={type:"path",d:"M 85 81 L 65 98 L 85 119 L 85 81 z M 110 81 L 90 98 L 110 119 L 110 81 z M 135 81 L 115 98 L 135 119 L 135 81 z"},o["AR.I.MEDICAL EVACUATION"]={type:"path",d:"M93,83 l14,0 0,10 10,0 0,14 -10,0 0,10 -14,0 0,-10 -10,0 0,-14 10,0 Z"},o["AR.I.ATTACK/STRIKE"]=a("A"),o["AR.I.BOMBER"]=a("B"),o["AR.I.CARGO"]=a("C"),o["AR.I.ESCORT"]=a("E"),o["AR.I.FIGHTER"]=a("F"),o["AR.I.FIGHTER INTERCEPTOR"]=a("I"),o["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]=a("J"),o["AR.I.TANKER"]=a("K"),o["AR.I.PATROL"]=a("P"),o["AR.I.RECONNAISSANCE"]=a("R"),o["AR.I.2525 PHOTOGRAPHIC"]=a("X"),o["AR.I.TRAINER"]=a("T"),o["AR.I.UTILITY"]=a("U"),o["AR.I.VSTOL"]=a(R&&!S?"L":"V"),o["AR.I.AIRBORNE COMMAND POST"]=a(R&&!S?"D":"ACP"),o["AR.I.AIRBORNE EARLY WARNING"]=a(R&&!S?"W":"AEW"),o["AR.I.ANTISURFACE WARFARE"]=a(R&&!S?"N":"ASUW"),o["AR.I.ANTISUBMARINE WARFARE"]=a(R&&!S?"S":"ASW"),o["AR.I.COMMUNICATIONS"]=a(R&&!S?"Y":"COM"),o["AR.I.COMBAT SEARCH AND RESCUE"]=a("CSAR"),o["AR.I.ELECTRONIC SUPPORT MEASURES"]=a(R?"Z":"ESM"),o["AR.I.GOVERNMENT"]=a("GOV"),o["AR.I.MINE COUNTERMEASURES"]=a("MCM"),o["AR.I.PERSONNEL RECOVERY"]=a(R?"H":"PRO"),o["AR.I.PASSENGER"]=a("PX"),o["AR.I.SEARCH AND RESCUE"]=a("SAR"),o["AR.I.SUPRESSION OF ENEMY AIR DEFENCE"]=a("SEAD"),o["AR.I.SPECIAL OPERATIONS FORCES"]=a("SOF"),o["AR.I.ULTRA LIGHT"]=a("UL"),o["AR.I.VIP"]=a("VIP"),o["AR.I.FF.MILITARY FIXED WING"]={type:"path",d:"m 99.2,58.2 c -3,0.8 -2.5,5.8 -2.5,5.8 l -0.3,16 -37.2,36.5 1.3,4.6 L 96.7,96.6 97,128.6 l -8.5,8.2 0,4.6 9.3,-4.2 c 0.7,0.6 1.8,1.7 1.8,1.7 0,0 1.2,-1.1 1.9,-1.7 l 9.3,4.2 0,-4.6 -8.5,-8.2 0.3,-32 36.2,24.5 1.3,-4.6 -37.2,-36.5 -0.3,-16 c 0,0 0.5,-5 -2.5,-5.8 -0.4,-0.1 -0.7,-0.1 -1.1,0 z",stroke:!1},o["AR.I.FIXED-WING DSymbol"]={type:"path",d:R?"M 99.4 80.8 C 97.9 81.1 98.1 83.4 98.1 83.4 L 98 90.7 L 78.6 107.4 L 79.3 109.4 L 98.1 98.3 L 98.3 112.9 L 93.9 116.6 L 93.9 118.7 L 98.8 116.8 C 99.1 117 99.7 117.5 99.7 117.5 C 99.7 117.5 100.4 117 100.7 116.8 L 105.6 118.7 L 105.6 116.6 L 101.1 112.9 L 101.3 98.3 L 120.2 109.4 L 120.9 107.4 L 101.5 90.7 L 101.3 83.4 C 101.3 83.4 101.6 81.1 100 80.8 C 99.8 80.8 99.6 80.8 99.4 80.8 z":"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},o["AR.I.CIVILIAN FIXED-WING DSymbol"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:R?"m 75.1,90.3 19.6,0 0,-6.5 10.5,0 0,6.5 19.6,0 0,9.7 -19.6,0 0,16.2 6.5,0 0,3.2 -23.6,0 0,-3.2 6.5,0 0,-16.2 -19.6,0 z m 21.6,-6.5 0,-3.2 6.5,0 0,3.2":"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},o["AR.I.FIGHTER/BOMBER"]=a("F/B"),o["AR.I.ELECTRONIC SUPPORT"]=a(R?"ES":"ESM"),o["AR.I.PERSONNEL RECOVERY DSymbol"]=a("PR"),o["AR.I.PHOTOGRAPHIC RECONNAISSANCE"]=a("PH"),o["AR.I.ELECTRONIC ATTACK (EA)"]=a("EA"),o["AR.I.VERTICAL-TAKEOFF UAV (VT-UAV)"]={type:"path",d:"m 70,85 30,10 30,-10 0,-5 -30,5 -30,-5 z m -10,5 40,15 40,-15 0,30 -40,-15 -40,15 z"},o["AR.I.TETHERED LIGHTER THAN AIR"]={type:"path",d:"M 75,110 85,95 m -5,20 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m 15,-6 0,11 10,0 0,-11 m 10,-14 c 0,8.3 -6.7,15 -15,15 -8.3,0 -15,-6.7 -15,-15 0,-8.3 6.7,-15 15,-15 8.3,0 15,6.7 15,15 z"},o["AR.I.CIVILIAN TETHERED LIGHTER THAN AIR"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"M 75,110 85,95 m -5,20 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m 15,-6 0,11 10,0 0,-11 m 10,-14 c 0,8.3 -6.7,15 -15,15 -8.3,0 -15,-6.7 -15,-15 0,-8.3 6.7,-15 15,-15 8.3,0 15,6.7 15,15 z"},o["AR.I.CIVILIAN UNMANNED AERIAL VEHICLE"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},o["AR.I.WEAPON"]=a("WPN"),o["AR.I.UNDERWATER DECOY DSymbol"]={type:"path",d:"M 85 81 L 65 98 L 85 119 L 85 81 z M 110 81 L 90 98 L 110 119 L 110 81 z M 135 81 L 115 98 L 135 119 L 135 81 z"},o["AR.I.BOMB"]=a("BOMB"),o["AR.I.MANUAL TRACK"]=a("MAN"),o["AIR.M1.ATTACK"]=l("A"),o["AIR.M1.BOMBER"]=l("B"),o["AIR.M1.CARGO"]=l("C"),o["AIR.M1.FIGHTER"]=l("F"),o["AIR.M1.INTERCEPTOR"]=l("I"),o["AIR.M1.TANKER"]=l("K"),o["AIR.M1.UTILITY"]=l("U"),o["AIR.M1.VSTOL"]=l(R&&!S?"L":"V"),o["AIR.M1.PASSENGER"]=l("PX"),o["AIR.M1.ULTRA LIGHT"]=l("UL"),o["AIR.M1.AIRBORNE COMMAND POST"]=l(R&&!S?"D":"ACP"),o["AIR.M1.ANTISURFACE WARFARE"]=l(R&&!S?"N":"ASUW"),o["AIR.M1.AIRBORNE EARLY WARNING"]=l(R&&!S?"W":"AEW"),o["AIR.M1.GOVERNMENT"]=l("GOV"),o["AIR.M1.MEDEVAC"]={type:"path",stroke:!1,d:"M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},o["AIR.M1.ESCORT"]=l("E"),o["AIR.M1.INTENSIVE CARE"]=l("IC"),o["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]=l("J"),o["AIR.M1.PATROL"]=l("P"),o["AIR.M1.RECONNAISSANCE"]=l("R"),o["AIR.M1.TRAINER"]=l("T"),o["AIR.M1.PHOTOGRAPHIC"]=l(R&&!S?"X":"PH"),o["AIR.M1.PERSONNEL RECOVERY"]=l("PR"),o["AIR.M1.ANTISUBMARINE WARFARE"]=l(R&&!S?"S":"ASW"),o["AIR.M1.COMMUNICATIONS"]=l(R&&!S?"Y":"COM"),o["AIR.M1.ELECTRONIC SURVEILLANCE MEASURES"]=l(R?"Z":"ESM"),o["AIR.M1.MINE COUNTERMEASURES"]=l("MCM"),o["AIR.M1.SEARCH AND RESCUE"]=l("SAR"),o["AIR.M1.SPECIAL OPERATIONS FORCES"]=l("SOF"),o["AIR.M1.SURFACE WARFARE"]=l("SUW"),o["AIR.M1.VIP"]=l("VIP"),o["AIR.M1.COMBAT SEARCH AND RESCUE"]=l(R&&!S?"H":"CSAR"),o["AIR.M1.SUPRESSION OF ENEMY AIR DEFENCE"]=l("SEAD"),o["AIR.M1.UNMANNED AERIAL VEHICLE"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},o["AIR.M1.BOOM-ONLY"]=l("B"),o["AIR.M1.DROUGE-ONLY"]=l("D"),o["AIR.M1.ELECTRONIC SUPPORT (ES)"]=l(R?"ES":"ESM"),o["AIR.M1.HIJACKER"]=l("HJ"),o["AIR.M1.CYBERSPACE"]=l("CYB"),o["AIR.M1.FIGHTER/BOMBER"]=l("F/B"),o["AIR.M1.ELECTRONIC ATTACK (EA)"]=l("EA"),o["AIR.M1.MULTIMISSION"]=l("MM"),o["AIR.M1.HIJACKING"]=l("H"),o["AIR.M1.ASW HELO-LAMPS"]=l("LP"),o["AIR.M1.ASW HELO - SH-60R"]=l("60R"),o["AIR.M2.HEAVY"]=r("H"),o["AIR.M2.MEDIUM"]=r("M"),o["AIR.M2.LIGHT"]=r("L"),o["AIR.M2.BOOM-ONLY"]=r("B"),o["AIR.M2.DROUGE-ONLY"]=r("D"),o["AIR.M2.BOOM AND DROUGE"]=r("B/D"),o["AIR.M2.CLOSE RANGE"]=r("CR"),o["AIR.M2.SHORT RANGE"]=r("SR"),o["AIR.M2.MEDIUM RANGE"]=r("MR"),o["AIR.M2.LONG RANGE"]=r("LR"),o["AIR.M2.PHOTOGRAPHIC"]=r("P"),o["AIR.M2.CYBERSPACE"]=r("CYB"),o["AIR.M2.DOWNLINKED"]={type:"text",stroke:!1,x:100,y:140,fontsize:25,text:"DL"},o["AIR.MISSILE.ICON"]={type:"path",d:"M90,135 l0,-10 5,-5 0,-55 5,-5 5,5 0,55 5,5 0,10 -10,-10 z"},(R||S)&&(o["AIR.MISSILE.ICON"].fill=C?E.fillColor.Unknown:E.iconFillColor.Unknown),o["AIR.MISSILE.IC.ANTIBALLISTIC MISSILE"]={type:"text",stroke:!1,x:100,y:110,fontsize:25,text:"ABM"},o["AIR.MISSILE.IC.BOMB"]={type:"text",stroke:!1,x:100,y:110,fontsize:25,text:"BOMB"},o["AIR.MISSILE.M1.AIR"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"A"},o["AIR.MISSILE.M1.SURFACE"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"S"},o["AIR.MISSILE.M1.SUBSURFACE"]=[{type:"text",stroke:!1,x:68,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:68,y:125,fontsize:30,text:"U"}],o["AIR.MISSILE.M1.SPACE"]=[{type:"text",stroke:!1,x:68,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:68,y:125,fontsize:30,text:"P"}],o["AIR.MISSILE.M1.ANTI-BALLISTIC"]=[{type:"text",stroke:!1,x:68,y:95,fontsize:30,text:"A"},{type:"text",stroke:!1,x:68,y:125,fontsize:30,text:"B"}],o["AIR.MISSILE.M1.BALLISTIC"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"B"},o["AIR.MISSILE.M1.CRUISE"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"C"},o["AIR.MISSILE.M1.LAND"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"L"},o["AIR.MISSILE.M1.INTERCEPTOR"]={type:"text",stroke:!1,x:68,y:110,fontsize:30,text:"I"},o["AIR.MISSILE.M2.AIR"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"A"},o["AIR.MISSILE.M2.SURFACE"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"S"},o["AIR.MISSILE.M2.SUBSURFACE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"U"}],o["AIR.MISSILE.M2.SPACE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"P"}],o["AIR.MISSILE.M2.LAUNCHED"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"L"},o["AIR.MISSILE.M2.MISSILE"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"M"},o["AIR.MISSILE.M2.PATRIOT"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"P"},o["AIR.MISSILE.M2.STANDARD MISSILE - 2 (SM-2)"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"2"}],o["AIR.MISSILE.M2.STANDARD MISSILE - 6 (SM-6)"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"6"}],o["AIR.MISSILE.M2.EVOLVED SEA SPARROW MISSILE (ESSM)"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"S"}],o["AIR.MISSILE.M2.ROLLING AIRFRAME MISSILE (RAM)"]={type:"text",stroke:!1,x:132,y:110,fontsize:30,text:"R"},o["AIR.MISSILE.M2.SHORT RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"S"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],o["AIR.MISSILE.M2.MEDIUM RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"M"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],o["AIR.MISSILE.M2.INTERMEDIATE RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"I"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],o["AIR.MISSILE.M2.LONG RANGE"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"L"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"R"}],o["AIR.MISSILE.M2.INTERCONTINENTAL"]=[{type:"text",stroke:!1,x:132,y:95,fontsize:30,text:"I"},{type:"text",stroke:!1,x:132,y:125,fontsize:30,text:"C"}],o)o.hasOwnProperty(M)&&(I.hasOwnProperty(M)&&console.warn("Override of: "+M),n.call(this,o[M],N),I[M]=o[M])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(N);var O={type:"letter",icons:function(I,t,E,R){I["S-A-------"]=[],I["S-A-M-----"]=[E["AR.I.MILITARY"]],I["S-A-MF----"]=[E["AR.I.FF.MILITARY FIXED WING"]],I["S-A-MFB---"]=[E["AR.I.BOMBER"]],I["S-A-MFF---"]=[E["AR.I.FIGHTER"]],I["S-A-MFFI--"]=[E["AR.I.FIGHTER INTERCEPTOR"]],I["S-A-MFT---"]=[E["AR.I.TRAINER"]],I["S-A-MFA---"]=[E["AR.I.ATTACK/STRIKE"]],I["S-A-MFL---"]=[E["AR.I.VSTOL"]],I["S-A-MFK---"]=[E["AR.I.TANKER"]],I["S-A-MFKB--"]=[E["AR.I.TANKER"],E["AIR.M1.BOOM-ONLY"]],I["S-A-MFKD--"]=[E["AR.I.TANKER"],E["AIR.M1.DROUGE-ONLY"]],I["S-A-MFC---"]=[E["AR.I.CARGO"]],I["S-A-MFCL--"]=[E["AR.I.CARGO"],E["AIR.M2.LIGHT"]],I["S-A-MFCM--"]=[E["AR.I.CARGO"],E["AIR.M2.MEDIUM"]],I["S-A-MFCH--"]=[E["AR.I.CARGO"],E["AIR.M2.HEAVY"]],I["S-A-MFJ---"]=[E["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I["S-A-MFO---"]=[E["AR.I.MEDICAL EVACUATION"]],I["S-A-MFR---"]=[E["AR.I.RECONNAISSANCE"]],I["S-A-MFRW--"]=[E["AR.I.AIRBORNE EARLY WARNING"]],I["S-A-MFRZ--"]=[E["AR.I.ELECTRONIC SUPPORT MEASURES"]],I["S-A-MFRX--"]=R?[E["AR.I.2525 PHOTOGRAPHIC"]]:[E["AR.I.RECONNAISSANCE"],E["AIR.M2.PHOTOGRAPHIC"]],I["S-A-MFP---"]=[E["AR.I.PATROL"]],I["S-A-MFPN--"]=[E["AR.I.ANTISURFACE WARFARE"]],I["S-A-MFPM--"]=[E["AR.I.MINE COUNTERMEASURES"]],I["S-A-MFU---"]=[E["AR.I.UTILITY"]],I["S-A-MFUL--"]=[E["AR.I.UTILITY"],E["AIR.M2.LIGHT"]],I["S-A-MFUM--"]=[E["AR.I.UTILITY"],E["AIR.M2.MEDIUM"]],I["S-A-MFUH--"]=[E["AR.I.UTILITY"],E["AIR.M2.HEAVY"]],I["S-A-MFY---"]=[E["AR.I.COMMUNICATIONS"]],I["S-A-MFH---"]=[E["AR.I.PERSONNEL RECOVERY"]],I["S-A-MFD---"]=[E["AR.I.AIRBORNE COMMAND POST"]],I["S-A-MFQ---"]=[E["AR.I.UNMANNED AERIAL VEHICLE"]],I["S-A-MFQA--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ATTACK"]],I["S-A-MFQB--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.BOMBER"]],I["S-A-MFQC--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.CARGO"]],I["S-A-MFQD--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.AIRBORNE COMMAND POST"]],I["S-A-MFQF--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.FIGHTER"]],I["S-A-MFQH--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.COMBAT SEARCH AND RESCUE"]],I["S-A-MFQJ--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I["S-A-MFQK--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.TANKER"]],I["S-A-MFQL--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.VSTOL"]],I["S-A-MFQM--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-A-MFQI--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.MINE COUNTERMEASURES"]],I["S-A-MFQN--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ANTISURFACE WARFARE"]],I["S-A-MFQP--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.PATROL"]],I["S-A-MFQR--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.RECONNAISSANCE"]],I["S-A-MFQRW-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.AIRBORNE EARLY WARNING"]],I["S-A-MFQRZ-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ELECTRONIC SURVEILLANCE MEASURES"]],I["S-A-MFQRX-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.PHOTOGRAPHIC"]],I["S-A-MFQS--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ANTISUBMARINE WARFARE"]],I["S-A-MFQT--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.TRAINER"]],I["S-A-MFQU--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.UTILITY"]],I["S-A-MFQY--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.COMMUNICATIONS"]],I["S-A-MFQO--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.MEDEVAC"]],I["S-A-MFS---"]=[E["AR.I.ANTISUBMARINE WARFARE"]],I["S-A-MFM---"]=[E["AR.I.SPECIAL OPERATIONS FORCES"]],I["S-A-MH----"]=[E["AR.I.MILITARY ROTARY WING"]],I["S-A-MHA---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.ATTACK"]],I["S-A-MHS---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.ANTISUBMARINE WARFARE"]],I["S-A-MHU---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"]],I["S-A-MHUL--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.LIGHT"]],I["S-A-MHUM--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.MEDIUM"]],I["S-A-MHUH--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.HEAVY"]],I["S-A-MHI---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.MINE COUNTERMEASURES"]],I["S-A-MHH---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.COMBAT SEARCH AND RESCUE"]],I["S-A-MHR---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.RECONNAISSANCE"]],I["S-A-MHQ---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UNMANNED AERIAL VEHICLE"]],I["S-A-MHC---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"]],I["S-A-MHCL--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.LIGHT"]],I["S-A-MHCM--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.MEDIUM"]],I["S-A-MHCH--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.HEAVY"]],I["S-A-MHT---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.TRAINER"]],I["S-A-MHO---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.MEDEVAC"]],I["S-A-MHM---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-A-MHD---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.AIRBORNE COMMAND POST"]],I["S-A-MHK---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.TANKER"]],I["S-A-MHJ---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I["S-A-ML----"]=[E["AR.I.FF.MILITARY BALLOON"]],I["S-A-MV----"]=[E["AR.I.VIP"]],I["S-A-ME----"]=[E["AR.I.ESCORT"]],I["S-A-W-----"]=[E["AIR.MISSILE.ICON"]],I["S-A-WM----"]=[E["AIR.MISSILE.ICON"]],I["S-A-WMS---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.LAUNCHED"]],I["S-A-WMSS--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.SURFACE"]],I["S-A-WMSA--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.AIR"]],I["S-A-WMSU--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.SUBSURFACE"]],I["S-A-WMSB--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.IC.ANTIBALLISTIC MISSILE"]],I["S-A-WMA---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.LAUNCHED"]],I["S-A-WMAS--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.SURFACE"]],I["S-A-WMAA--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.AIR"]],I["S-A-WMAP--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.SPACE"]],I["S-A-WMU---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SUBSURFACE"],E["AIR.MISSILE.M2.SURFACE"]],I["S-A-WML---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.LAND"],E["AIR.MISSILE.M2.AIR"]],I["S-A-WMCM--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.CRUISE"],E["AIR.MISSILE.M2.MISSILE"]],I["S-A-WMB---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.BALLISTIC"],E["AIR.MISSILE.M2.MISSILE"]],I["S-A-WB----"]=[E["AIR.MISSILE.IC.BOMB"]],I["S-A-WD----"]=[E["AR.I.AIR DECOY"]],I["S-A-C-----"]=[E["AR.I.CIVILIAN"]],I["S-A-CF----"]=[E["AR.I.FF.CIVILIAN FIXED WING"]],I["S-A-CH----"]=[E["AR.I.FF.CIVILIAN ROTARY WING"]],I["S-A-CL----"]=[E["AR.I.FF.CIVILIAN BALLOON"]]}};function G(I,t,E,R,e,A){var C=t.frame,T=t.affiliation||"Friend",S=t.baseGeometry,N=t.numberSIDC,O=E.iconColor[T],G=E.iconFillColor[T],o=E.black[T],M=E.white[T],i={};for(var L in i["GR.IC.MILITARY"]=a("MIL"),i["GR.I.GOVERNMENT"]=a("GOV"),i["GR.IC.SUBMARINE NUCLEAR PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},i["GR.IC.FERRY"]=[{type:"path",fill:R?G:!C&&G,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"FE":"F"}],i["GR.IC.ADMINISTRATIVE"]=a("ADM"),i["GR.IC.MANUAL TRACK"]=a("MAN"),i["GR.IC.AIR DEFENSE CHAPARRAL"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"C"}],i["GR.IC.AIR DEFENSE COMPOSITE"]={type:"path",d:"M85,120 C85,110 115,110 115,120 M90,115 L90,90 C90,80 110,80 110,90 L110,115 M100,112 l0,-30",fill:!1},i["GR.IC.AIR DEFENSE H/MAD"]=a("HMD"),i["GR.IC.AIR DEFENSE H/MAD HAWK"]={type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"H"},i["GR.IC.AIR DEFENSE H/MAD PATRIOT"]={type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"P"},i["GR.IC.AIR DEFENSE MISSILE"]={type:"path",d:"M90,120 L90,90 C90,80 110,80 110,90 L110,120",fill:!1},i["GR.IC.FLOATING CRAFT"]={type:"path",d:"m 90,75 20,0 0,-10 -5,0 0,-10 -10,0 0,10 -5,0 z",stroke:!1},i["GR.IC.AIR AND MISSILE DEFENSE"]=a("MD"),i["GR.IC.MILITARY HISTORY"]=a("MH"),i["GR.IC.AIR DEFENSE TARGETING UNIT"]=[{type:"path",d:"M80,100 l20,-15 0,15 20,-15 M75,80 C75,100 85,115 105,115",fill:!1},{type:"circle",cx:75,cy:110,r:5}],i["GR.IC.AIR DEFENSE THEATER MISSILE DEFENSE UNIT"]=a("TMD"),i["GR.IC.AIR DEFENSE SHORT RANGE"]=a("SRD"),i["GR.IC.AIR DEFENSE STINGER"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"S"}],i["GR.IC.AIR DEFENSE VULCAN"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"V"}],i["GR.IC.AIR DEFENSE GUN UNIT"]={type:"path",d:"M100,80 L100,120 M92,90 l0,20 M108,90 l0,20",fill:!1},i["GR.IC.AIR TRAFFIC SERVICES"]={type:"path",d:"m 100,95 0,25 m 7.5,-32.5 c 0,4.1 -3.4,7.5 -7.5,7.5 -4.1,0 -7.5,-3.4 -7.5,-7.5 0,-4.1 3.4,-7.5 7.5,-7.5 4.1,0 7.5,3.4 7.5,7.5 z M 60,85 l 40,15 40,-15 0,30 -40,-15 -40,15 z"},i["GR.IC.AIRPORT OF DEBARKATION"]=[{type:"path",fill:!1,d:"M80,70 l40,0 M80,80 l25,-25 M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1}],i["GR.IC.ALLIED COMMAND EUROPE RAPID REACTION CORPS (ARRC)"]=a("ARRC"),i["GR.IC.ALLIED COMMAND OPERATIONS"]=a("ACO"),i["GR.IC.AMMUNITION"]={type:"path",d:"m 90,117 0,-25 c 0,-15 20,-15 20,0 l 0,25 m -25,0 30,0",fill:!1},i["GR.IC.ARMOUR"]={type:"path",d:"M125,80 C150,80 150,120 125,120 L75,120 C50,120 50,80 75,80 Z",fill:!1},i["GR.IC.ARMOR, WHEELED"]=[{type:"path",d:"m 120,80 c 25,0 25,30 0,30 l -40,0 C 55,110 55,80 80,80 Z",fill:!1},{type:"circle",cx:70,cy:115,r:5,fill:!1},{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"circle",cx:130,cy:115,r:5,fill:!1}],i["GR.IC.AVIATION ROTARY WING"]={type:"path",d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},i["GR.IC.AVIATION ROTARY WING 2525C"]={type:"path",d:"M100,100 L100,140"},i["GR.IC.AVIATION FIXED WING"]={type:"path",d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},i["GR.IC.COMBATANT"]=[{type:"path",d:"m 86.9,110 c -3.6,2 -7.2,3.9 -10.8,5.9 2.1,2.9 6.7,3.9 10,2.1 2.6,-0.9 4.7,-3.8 3.1,-6.1 -0.8,-0.6 -1.5,-1.3 -2.3,-1.9 z m 26.3,0.1 c 3.6,2 7.2,3.9 10.8,5.9 -2.1,2.9 -6.7,3.9 -10,2.1 -2.6,-0.9 -4.7,-3.8 -3.1,-6.1 0.8,-0.6 1.5,-1.3 2.3,-1.9 z",fill:!1},{type:"path",d:"m 112.9,110 c -5.6,-4 -11.3,-7.9 -16.1,-12.5 -4.2,-4.5 -7,-9.8 -9.2,-15.1 -0.8,4.4 -0.9,9.3 2.4,13.2 3.6,4.5 8.6,8.1 13.5,11.8 2.3,1.7 4.7,3.3 7.1,4.8 0.8,-0.7 1.5,-1.5 2.3,-2.2 m -25.7,0 c 5.6,-4 11.3,-7.9 16.1,-12.5 4.2,-4.5 7,-9.8 9.2,-15.1 0.8,4.4 0.9,9.3 -2.4,13.2 -3.6,4.5 -8.6,8.1 -13.5,11.8 -2.3,1.7 -4.7,3.3 -7.1,4.8 -0.8,-0.7 -1.5,-1.5 -2.3,-2.2",fill:M,strokewidth:2}],i["GR.IC.AVIATION COMPOSITE"]={type:"path",d:"m 100,100 15.7,7.9 c 11.8,0 11.8,-15.7 0,-15.7 z m 0,0 -15.7,-7.9 c -11.8,0 -11.8,15.7 0,15.7 z m -10,-20 10,20 -10,20 20,0 -10,-20 10,-20 z"},i["GR.IC.AVIATION TACTICAL AIR CONTROL PARTY"]=a("TACP"),i["GR.IC.AVIATION FORWARD AIR CONTROLLER"]=a("FAC"),i["GR.IC.SPECIAL TROOPS"]=a("ST"),i["GR.IC.RANGER"]=a("RGR"),i["GR.IC.BAND"]=a("BAND"),i["GR.IC.ARMY MUSIC"]={type:"path",d:"m 99.6,110.5 c -4.8,-1.4 -10.9,2.2 -10.4,7.7 1,2.5 6.2,2.4 9.6,-0.2 1.9,-1.5 2.7,-3.8 2.3,-6.9 l -0.1,-21.3 c 12.7,5.8 7.6,14.8 5.6,20.7 4.7,-4.9 5.8,-13.2 1.5,-17.9 -4.4,-4.6 -5,-7 -8.4,-13 z",stroke:!1},i["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]=a("ATF"),i["GR.IC.CBRN"]=[{type:"path",d:"m 80,120 c 0,-20 10,-32 50,-35 m -10,35 C 120,100 110,88 70,85",fill:!1},{type:"circle",cx:75,cy:90,r:6},{type:"circle",cx:125,cy:90,r:6}],i["GR.CHEMICAL, BIOLOGICAL, RADIOLOGICAL, NUCLEAR, AND HIGH-YIELD EXPLOSIVES"]=[{type:"path",d:"m 90,80 20,0 10,20 -10,20 -20,0 -10,-20 z",fill:G},a("E")],i["GR.IC.SPACE"]=[{type:"path",d:"m 100,80 -1.25,16.5 -4.2,-3.3 2.5,4.9 -5.5,1.7 -0.4,-0 0.2,0 -0.2,0 0.4,-0 5.4,2.3 -1.8,4.6 3.6,-3.5 1.3,16.5 1.3,-16.5 4.2,3.3 -2.5,-4.9 5.5,-1.7 0.4,0 -0.2,-0 0.2,0 -0.4,0 -5.3,-1.7 2.5,-4.6 -4,3.2 z",stroke:!1}],i["GR.IC.CIVIL AFFAIRS"]=a("CA"),i["GR.IC.CIVIL-MILITARY-COOPERATION"]={type:"path",d:"m 60,80 80,0 0,20 c 0,25 -80,25 -80,0 z",fill:!1},i["GR.I.CIVILIAN"]=a("CIV"),i["GR.I.CIVILIAN"].fill=R||N?G:!C&&G,i["GR.I.CIVILIAN"].stroke=o,i["GR.I.CIVILIAN"].strokewidth=3,i["GR.IC.COMMAND AND CONTROL"]=a("C2"),i["GR.IC.COMBAT"]=a("CBT"),i["GR.IC.COMBAT SERVICE SUPPORT"]=a("CSS"),i["GR.IC.COMBAT SUPPORT"]=a("CS"),i["GR.IC.COMBAT SUPPORT (MANOEUVRE ENHANCEMENT)"]={type:"path",d:"m 85,80 0,25 15,15 15,-15 0,-25 z"},i["GR.IC.COMBINED ARMS"]={type:"path",d:"m 70,80 60,40 m 0,-40 -60,40 m 55,-40 c 25,0 25,40 0,40 l -50,0 C 50,120 50,80 75,80 z",fill:!1},i["GR.IC.COUNTER-INTELLIGENCE"]=a("CI"),i["GR.IC.CRIMINAL INVESTIGATION DIVISION"]=a("CID"),i["GR.IC.DIVING"]=[],i["GR.IC.DOG"]=a("DOG"),i["GR.IC.DRILLING"]={type:"path",d:"m 85,80 5,40 20,0 5,-40 z"},i["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]=a("DEA"),i["GR.IC.ELECTRONIC RANGING"]={type:"path",d:"M120,130 c-40,20 -80,-45 -40,-70 z M100,95 L140,75",fill:!!R&&G},i["GR.IC.ELECTRONIC WARFARE"]=a("EW"),i["GR.IC.EMERGENCY MEDICAL OPERATION"]={type:"path",d:"m 90,60 0,22.7 -19.7,-11.3 -10,17.3 L 80,100 l -19.7,11.3 10,17.3 L 90,117.3 90,140 l 20,0 0,-22.7 19.7,11.3 10,-17.3 L 120,100 l 19.7,-11.3 -10,-17.3 L 110,82.7 110,60 90,60 z"},i["GR.IC.ENGINEER"]={type:"path",fill:!1,d:"M60,120 L60,80 140,80 140,120 M100,80 L100,110"},i["GR.IC.ENGINEER MECHANIZED"]={type:"path",fill:!1,d:"m 100,90 0,15 m -25,5 0,-20 50,0 0,20 m 0,-30 c 25,0 25,40 0,40 l -50,0 C 50,120 50,80 75,80 Z"},i["GR.IC.ENGINEER UTILITY VEHICLE"]={type:"path",fill:!1,d:"m 100,100 0,10 m -15,5 0,-15 30,0 0,15 M 70,80 c 0,15 60,15 60,0 l 0,40 -60,0 z"},i["GR.IC.ENVIRONMENTAL PROTECTION"]={type:"path",d:"m 100,80 -10,15 5,0 -10,10 5,0 -10,10 15,0 0,5 10,0 0,-5 15,0 -10,-10 5,0 -10,-10 5,0 z",fill:!1},i["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]=a("EOD"),i["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]=a("FBI"),i["GR.IC.FIELD ARTILLERY"]={type:"circle",cx:100,cy:100,r:15},i["GR.IC.FIELD ARTILLERY OBSERVER"]=[{type:"circle",cx:100,cy:108,r:5},{type:"path",d:"m 80,120 30,-20 m -30,20 20,-40 20,40 z",fill:!1}],i["GR.IC.FIELD CAMP CONSTRUCTION"]=[i["GR.IC.ENGINEER"],{type:"text",stroke:!1,x:100,y:77,fontsize:25,text:"CAMP"}],i["GR.IC.FINANCE"]={type:"path",d:"m 80,95 10,-10 20,0 10,10 m -40,0 0,20 40,0 0,-20 z",fill:!1},i["GR.IC.FIRE PROTECTION"]={type:"path",d:"m 120,90 -5,5 -10,-10 5,-5 -20,0 5,5 -10,10 -5,-5 0,20 5,-5 10,10 -5,5 20,0 -5,-5 10,-10 5,5 z"},i["GR.IC.FIXED WING MISO"]=[{type:"path",fill:!!R&&G,stroke:o,d:"M70,85 l40,0 10,-10 0,50 -10,-10 -40,0 z M120,85 l10,0 M120,95 l10,0 M120,105 l10,0 M120,115 l10,0"},{type:"path",d:"M 78.8 61.5 C 68.1 61.5 68.1 78.5 78.8 78.5 L 100 70 L 78.8 61.5 z M 100 70 L 121.3 78.5 C 131.9 78.5 131.9 61.5 121.3 61.5 L 100 70 z"}],i["GR.IC.GEOSPATIAL SUPPORT"]=a("GEO"),i["GR.IC.GOVERNMENT ORGANIZATION"]=a("GO"),i["GR.IC.INFORMATION OPERATIONS"]=a(R&&!N?"IW":"IO"),i["GR.IC.INTERNATIONAL SECURITY ASSISTANCE FORCE (ISAF)"]=a("ISAF"),i["GR.IC.INTERROGATION"]=a("IPW"),i["GR.IC.JOINT FIRE SUPPORT"]=a("JFS"),i["GR.IC.JOINT INFORMATION BUREAU"]=a("JIB"),i["GR.IC.JOINT INTELLIGENCE CENTRE"]=a("JIC"),i["GR.IC.JUDGE ADVOCATE GENERAL"]=a("JAG"),i["GR.IC.LABOUR"]={type:"path",d:"m 90,85 20,0 m -10,0 0,25 -10,0 10,10 10,-10 -10,0",fill:!1},i["GR.IC.LAUNDRY/BATH"]={type:"path",d:"m 95,80 10,10 0,30 m 0,-30 -10,0 m 10,0 -10,10",fill:!1},i["GR.IC.LAW ENFORCEMENT"]={type:"path",d:"M 100,118 C 76,109 85,95 82,82 c 6,7 12,7 18,0 6,7 12,7 18,0 -3,13 6,27 -18,36 z",fill:!1},i["GR.IC.LAW ENFORCEMENT VESSEL"]=[{type:"path",fill:R?G:!C&&G,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],i["GR.IC.LIAISON"]=a("LO"),i["GR.IC.MAINTENANCE"]={type:"path",d:"M70,90 c10,0 10,20 0,20 m10,-10 l40,0 m10,-10 c-10,0 -10,20 0,20",fill:!1},i["GR.IC.MATERIEL"]=a("MAT"),i["GR.IC.MEDICAL EVACUATION HELICOPTER"]={type:"path",d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},i["GR.IC.MESSENGER"]=a("M"),i["GR.IC.METEOROLOGICAL"]=a("MET"),i["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"]={type:"path",d:"M70,85 l40,0 10,-10 0,50 -10,-10 -40,0 z M120,85 l10,0 M120,95 l10,0 M120,105 l10,0 M120,115 l10,0"},i["GR.IC.MILITARY INTELLIGENCE"]=a("MI"),i["GR.IC.MILITARY POLICE"]=a("MP"),i["GR.IC.MINE"]={type:"path",d:"m 120,100 c 0,5.5 -9,10 -20,10 -11,0 -20,-4.5 -20,-10 0,-5.5 9,-10 20,-10 11,0 20,4.5 20,10 z m -5,-20 -30,40 m 0,-40 30,40 m -15,-40 0,40"},i["GR.IC.MINE CLEARING"]=[i["GR.IC.MINE"],{type:"text",stroke:!1,x:100,y:77,fontsize:25,text:"CLR"}],i["GR.IC.MINE LAUNCHING"]=[i["GR.IC.MINE"],{type:"path",d:"m 80,125 0,10 40,0 0,-10 z"}],i["GR.IC.MINE LAYING"]=[i["GR.IC.MINE"],{type:"path",d:"m 80,65 0,10 40,0 0,-10 z"}],i["GR.IC.MISSILE"]={type:"path",d:"M90,120 L90,90 C90,80 110,80 110,90 L110,120 M100,120 L100,80",fill:!1},i["GR.IC.MISSILE.LIGHT"]={type:"path",d:"M90,90 L110,90"},i["GR.IC.MISSILE.MEDIUM"]={type:"path",d:"M90,90 L110,90 M90,97 L110,97"},i["GR.IC.MISSILE.HEAVY"]={type:"path",d:"M90,90 L110,90 M90,97 L110,97 M90,104 L110,104"},i["GR.IC.MORALE, WELFARE, AND RECREATION"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MWR"},i["GR.IC.MORTAR"]=[{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"path",d:"M100,111 l0,-30 M90,90 l10,-10 10,10",fill:!1}],i["GR.IC.MORTUARY AFFAIRS"]={type:"path",d:"m 90,95 20,0 m -10,-10 0,30 m -15,-35 30,0 0,40 -30,0 z",fill:!1},i["GR.IC.MULTINATIONAL (MN)"]=a("MN"),i["GR.IC.NAVAL"]=[{type:"path",d:"m 105,85 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -20,5 30,0 m -15,0 0,30",fill:!1},{type:"path",d:"M 82.3 102.6 C 82.3 113.9 84.2 115.9 84.2 115.9 L 86.5 114.1 C 90.2 117.8 94.8 120.8 99.9 120.9 L 100.5 120.9 L 101 120.9 C 106.2 120.8 110.8 117.8 114.4 114.1 L 116.7 115.9 C 116.7 115.9 118.6 113.9 118.7 102.6 C 113.9 106.8 108.9 109 108.9 109 L 110.9 110.7 C 110.9 110.7 106.8 115.2 100.5 115.2 L 100.5 115.2 C 100.5 115.2 100.4 115.2 100.4 115.2 C 94.2 115.2 90 110.7 90 110.7 L 92 109 C 92 109 87 106.8 82.3 102.6 z",stroke:!1}],i["GR.IC.OBSERVER/OBSERVATION"]={type:"path",d:"m 100,80 -25,40 50,0 z",fill:!1},i["GR.IC.ORDNANCE"]={type:"path",d:"M 90,97 83,83 m 27,14 7,-14 M 95,95 90,81 m 15,14 5,-14 m 10,26.5 c 0,6.9 -9,12.5 -20,12.5 -11,0 -20,-5.6 -20,-12.5 0,-6.9 9,-12.5 20,-12.5 11,0 20,5.6 20,12.5 z",fill:!1},i["GR.IC.PERSONNEL SERVICES"]=a("PS"),i["GR.IC.PETROLEUM OIL LUBRICANTS"]={type:"path",d:"m 100,119 0,-24 m 0,0 C 99,95 85,81 85,81 l 30,0 z",fill:!1},i["GR.IC.PIPELINE"]={type:"path",d:"m 115,110 15,0 m -15,-15 15,0 m -45,15 -15,0 M 85,95 70,95 m 30,-15 0,10 -15,0 0,25 30,0 0,-25 -15,0 m -10,-10 20,0",fill:!1},i["GR.IC.POSTAL"]={type:"path",d:"m 80,80 30,0 c -1.4,15.5 0,25 10,35 -20,0 -40,-20 -40,-35 z",fill:!1},i["GR.IC.PUBLIC AFFAIRS"]=a("PA"),i["GR.IC.PUBLIC AFFAIRS BROADCAST"]=a("BPAD"),i["GR.IC.PSYCHOLOGICAL OPERATIONS"]={type:"path",fill:!!R&&G,stroke:o,d:"M70,85 l40,0 10,-10 0,50 -10,-10 -40,0 z M120,85 l10,0 M120,95 l10,0 M120,105 l10,0 M120,115 l10,0"},i["GR.IC.QUARTERMASTER"]={type:"path",fill:!1,d:"m 115,95 c 0,15 15,15 15,0 0,-15 -15,-15 -15,0 z m 0,0 -45,0 0,10 10,0 0,-10"},i["GR.IC.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},i["GR.IC.RADIO"]=[{type:"circle",cx:100,cy:130,r:10,fill:!1},{type:"path",fill:!1,d:"M100,120 l0,-60 M70,70 l10,-10 10,10 10,-10 10,10 10,-10 10,10"}],i["GR.IC.RADIO RELAY"]=[{type:"circle",cx:100,cy:130,r:10,fill:!1},{type:"path",fill:!1,d:"M100,120 l-15,-40 15,0 0,-20 M70,60 l60,0"}],i["GR.IC.RADIO TELETYPE CENTRE"]=[{type:"text",stroke:!1,x:100,y:135,fontsize:30,text:"C"},{type:"path",fill:!1,d:"M100,140 l0,-80  M70,60 l60,0 M80,70 l40,0"}],i["GR.IC.RAILHEAD"]=[{type:"path",fill:!1,d:"M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1},s._translate(0,-50,[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:125,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}])],i["GR.IC.RELIGIOUS SUPPORT"]=a("REL"),i["GR.IC.REPLACEMENT HOLDING UNIT"]=a("RHU"),i["GR.IC.SEA-AIR-LAND"]=a("SEAL"),i["GR.IC.SUPPORT"]=a("SPT"),i["GR.IC.ARMY FIELD SUPPORT"]=a("AFS"),i["GR.IC.CONTRACTING SERVICES"]=a("KS"),i["GR.IC.SEAPORT OF DEBARKATION"]=[{type:"path",fill:!1,d:"M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1},s._translate(0,-35,s._scale(.6,i["GR.IC.NAVAL"]))],i["GR.IC.SECURITY"]=a("SEC"),i["GR.IC.SECURITY POLICE (AIR)"]=[a("SP"),{type:"path",d:"M 78.8 121.5 C 68.1 121.5 68.1 138.5 78.8 138.5 L 100 130 L 78.8 121.5 z M 100 130 L 121.3 138.5 C 131.9 138.5 131.9 121.5 121.3 121.5 L 100 130 z"}],i["GR.IC.SENSOR"]={type:"path",d:"m 100,80 c 0,7.5 12.5,20 20,20 -7.5,0 -20,12.5 -20,20 0,-7.5 -12.5,-20 -20,-20 7.5,0 20,-12.5 20,-20 z"},i["GR.IC.SHORE PATROL"]=a("SP"),i["GR.IC.SNIPER"]={type:"path",fill:!1,d:"M 60 85 L 90 85 L 60 85 z M 110 85 L 140 85 L 110 85 z M 100 90 L 100 115 L 100 90 z"},i["GR.IC.PARACHUTE RIGGER"]={type:"path",fill:!1,d:"m 120,100 -20,20 -20,-20 m 0,0 c 0,-25 40,-25 40,0 l -40,0"},i["GR.IC.SPECIAL FORCES"]=a("SF"),i["GR.IC.SPECIAL OPERATIONS FORCES"]=a("SOF"),i["GR.IC.SURVEILLANCE"]={type:"path",d:"m 100,80 -25,40 50,0 z"},i["GR.IC.SURVEY"]=[{type:"path",d:"M85,120 l15,-15 15,15 ",fill:!1},{type:"path",d:"M100,105 l0,-25 20,12.5 z",fill:!!R&&G}],i["GR.IC.SUSTAINMENT"]=a("SUST"),i["GR.IC.TELEPHONE SWITCH"]=[{type:"text",stroke:!1,x:100,y:135,fontsize:30,text:"C"},{type:"path",fill:!1,d:"M100,140 l0,-80  M70,60 l60,0"}],i["GR.IC.TOPOGRAPHIC"]={type:"path",fill:!1,d:"m 85,105 c 10,5 20,5 30,0 m -15,-15 15,30 m -30,0 15,-30 0,-10"},i["GR.IC.TRANSPORTATION"]=[{type:"path",fill:!1,d:"M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1}],i["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]=a("TSA"),i["GR.IC.UNMANNED SYSTEMS"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},i["GR.IC.SEARCH AND RESCUE"]=a("SAR"),i["GR.IC.DIVER, CIVILIAN"]={type:"path",fill:G,d:"M 114.3,94 C 114.3,102.3 107.9,109 100,109 c -7.9,0 -14.2,-6.7 -14.2,-15 0,-8.3 6.4,-15 14.2,-15 7.9,0 14.3,6.7 14.3,15 z m 0,27 14.3,15 -57,0 14.3,-15 M 125.7,79 l 14.3,0 0,30 -14.3,0 m -51.3,0 -14.3,0 0,-30 14.3,0 m 54.2,15 c 0,16.6 -12.8,30 -28.5,30 -15.7,0 -28.5,-13.4 -28.5,-30 C 71.5,77.4 84.3,64 100,64 115.7,64 128.5,77.4 128.5,94 z"},i["GR.IC.VIDEO IMAGERY"]={type:"path",fill:!1,d:"m 140,110 -26,0 m 7,-20 19,0 m -15,-10 -65,0 0,40 50,0 z m 15,5 0,30"},i["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]=a("USSS"),i["GR.IC.WATER"]={type:"path",d:"m 65,90 50,0 c 10,0 20,10 20,20 m -40,-30 20,0 m -10,0 0,10",fill:!1},i["GR.IC.WATER PURIFICATION"]=[i["GR.IC.WATER"],{type:"text",stroke:!1,x:90,y:110,fontsize:20,text:"PURE"}],i["GR.IC.FF.AIR ASSAULT WITH ORGANIC LIFT"]={Unknown:{type:"path",d:"M35,120 L 90,120 l10,10 10,-10 L165,120",fill:!1},Friend:{type:"path",d:"M25,120 L 90,120 l10,10 10,-10 L175,120",fill:!1},Neutral:{type:"path",d:"M45,120 L 90,120 l10,10 10,-10 L155,120",fill:!1},Hostile:{type:"path",d:"M50,120 L 90,120 l10,10 10,-10 L150,120",fill:!1}}[T],i["GR.IC.FF.AIR DEFENCE"]={Unknown:{type:"path",d:"m 55,135 c 10,-20 80,-20 90,0",fill:!1},Friend:{type:"path",d:"M25,150 C25,110 175,110 175,150",fill:!1},Neutral:{type:"path",d:"M45,150 C45,110 155,110 155,150",fill:!1},Hostile:{type:"path",d:"M70,140 C70,115 130,115 130,140",fill:!1}}[T],i["GR.IC.FF.AIR AND NAVAL GUNFIRE LIAISON COMPANY"]=[],i["GR.IC.FF.AMPHIBIOUS"]={Unknown:{type:"path",d:"m 30,95 c 10,0 0,15 13.5,15 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 13.5,0 3.5,-15 13.5,-15",fill:!1},Friend:{type:"path",d:"m 25,90 c 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 20,-20",fill:!1},Neutral:{type:"path",d:"m 45,110 c 18.8,0 0,-20 18,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18,20",fill:!1},Hostile:{type:"path",d:"m 32,95 c 10,0 0,15 11.5,15 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 11.5,0 1.5,-15 11.5,-15",fill:!1}}[T],i["GR.IC.FF.ANALYSIS"]={type:"path",d:"m 100,120 0,-65 m 0,90 -30,-25 60,0 z",fill:!1},i["GR.IC.FF.ANTITANK/ANTIARMOUR"]={Unknown:{type:"path",fill:!1,d:"M55,135 L100,33 145,135"},Friend:{type:"path",fill:!1,d:"M25,150 L100,52 175,150"},Neutral:{type:"path",fill:!1,d:"M45,150 L100,47 155,150"},Hostile:{type:"path",fill:!1,d:"M60,132 L100,30 140,132"}}[T],i["GR.IC.FF.BORDER PATROL"]=[{type:"path",stroke:!1,d:"M 122.8 66.8 C 119.9 66.8 117.4 68.6 117.4 71.6 L 117.4 73.1 L 128.7 73.1 L 128.7 72.4 C 128.7 68.8 126.5 66.8 122.8 66.8 z M 108.6 74.8 L 108.6 76 L 117.6 76 L 117.5 77.5 L 118 80.8 C 119.1 81.5 118.9 82.5 120.8 83.5 C 122.1 84.1 124 84 125.2 83.4 C 127.5 82.4 129 79.2 128.3 76 L 137.5 76 L 137.5 74.8 L 108.6 74.8 z M 94.8 82.1 C 93.3 82.1 92 83.5 92 85 L 92 85.2 C 92 86.6 96 91.3 97 92.6 C 98.2 94.3 100.8 98.8 103.2 98.8 C 104.5 98.8 111.1 93.7 112.6 92.8 L 112.6 106.2 L 126.4 85.6 C 123 85.6 114.9 85.2 112.2 85.9 C 110.2 86.4 105 91.6 103.6 91.7 C 103.4 91 100.6 87.5 100 86.5 C 99.2 85.4 97.2 82.1 95.6 82.1 L 94.8 82.1 z M 130.4 85.6 C 129.6 85.6 117.5 104.1 116.3 106.2 L 128.1 106.2 L 128.1 110.6 L 112.5 110.6 L 112.5 133.2 L 120.7 133.2 L 122 117.5 L 124.3 117.5 L 125.6 133.2 L 133.5 133.2 L 133.5 87.9 C 133.5 87.2 131.2 85.6 130.4 85.6 z M 66.9 90.7 C 66.5 91.4 62.5 96.9 62.5 96.9 C 62.5 97.8 76.7 107.2 78.5 108.3 C 81.4 110.2 83.9 112.1 86.7 114 C 88.2 115 89.4 115.9 90.8 116.8 C 92.1 117.7 94.1 118.5 94.1 120.4 L 94.1 133.2 L 105.5 133.2 L 105.5 121.7 C 105.5 120.6 107.2 119 107.2 118.8 C 107.2 117.6 106.1 118.6 105.6 116.9 C 105.2 115.4 105.4 115.6 104.5 114.5 C 103.5 113.1 101.9 112 99.8 112 C 96.8 112 97.6 111.8 95.3 110.3 C 93.9 109.3 92.5 108.4 91.2 107.4 C 88.7 105.5 85.8 103.5 83.2 101.8 C 80.9 100.3 68.2 91 66.9 90.7 z M 67.9 92.6 L 72.7 95.7 L 72.8 103 L 67.9 99.9 L 67.9 92.6 z M 77.8 99.3 L 82.6 102.6 L 82.6 110 L 77.8 106.6 L 77.8 99.3 z M 87.4 106.2 L 92.5 109.5 L 92.4 116.9 L 87.4 113.5 L 87.4 106.2 z"},{type:"path",fill:!!R&&G,stroke:!1,d:"M 117.4 73.1 L 117.4 74.8 L 128.7 74.8 L 128.7 73.1 L 117.4 73.1 z M 126.4 85.6 L 112.6 106.2 L 112.6 110.6 L 128.1 110.6 L 128.1 106.2 L 116.4 106.2 C 117.5 104.1 129.6 85.6 130.4 85.6 L 126.4 85.6 z M 67.9 92.6 L 67.9 99.9 L 72.8 103 L 72.7 95.7 L 67.9 92.6 z M 77.8 99.3 L 77.8 106.6 L 82.6 110 L 82.6 102.6 L 77.8 99.3 z M 87.4 106.2 L 87.4 113.5 L 92.4 116.9 L 92.5 109.5 L 87.4 106.2 z "}],i["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]={type:"path",fill:!1,d:"m 80,60 20,20 20,-20 m -20,0 0,80"},i["GR.IC.FF.CORPS SUPPORT"]={Unknown:{type:"path",d:"M160,75 l-15,25 15,25",fill:!1},Friend:{type:"path",d:"M175,50 l-30,50 30,50",fill:!1},Neutral:{type:"path",d:"M155,50 l-20,50 20,50",fill:!1},Hostile:{type:"path",d:"M150,80 l-15,20 15,20",fill:!1}}[T],i["GR.IC.FF.CUSTOMS SERVICE"]=[{type:"path",stroke:!1,d:"M 115.5 69.8 C 115.8 70.4 116.9 72.9 117.5 72.9 L 128.3 72.9 L 128.3 69.8 L 115.5 69.8 z M 117.3 74.7 C 116.8 74.7 116 75.7 115.8 76.1 L 117.2 76.1 L 117.2 76.8 C 117.2 79.6 119.8 81.8 122.8 81.8 C 126.5 81.8 128.3 78.6 128.3 74.7 L 117.3 74.7 z M 111.3 83.6 C 110.5 83.6 99.4 91.8 97.8 92.9 C 95.6 94.4 93 96.1 91 97.7 C 89.1 99.2 85.4 100.5 85.4 103.6 L 85.4 104 C 85.4 104.7 87.1 106.7 88.2 106.7 L 88.8 106.7 C 90.2 106.7 108 93.4 111.3 91.7 L 111.3 105.3 L 126 83.6 L 111.3 83.6 z M 75.3 83.6 C 74.5 83.6 73.4 84.4 73.4 85 L 73.4 108.9 C 73.4 109.8 73.9 110.2 74.4 110.5 L 78.5 110.5 L 78.5 83.6 L 75.3 83.6 z M 78.5 110.5 L 78.5 135.2 L 105.6 135.2 L 105.6 110.5 L 78.5 110.5 z M 130.5 83.6 C 129.6 83.6 123.8 92.9 122.9 94.2 C 121.9 95.7 115.7 104.5 115.5 105.3 L 127.6 105.3 L 127.6 110.3 L 111.5 110.3 L 111.5 134.8 L 119.6 134.8 C 120.6 134.8 121.1 127.9 121.3 126.6 C 121.7 123.9 122.4 120.4 122.6 117.8 L 122.9 117.8 L 125.4 134.8 L 133.9 134.8 L 133.9 86.7 C 133.9 85.6 131.9 83.6 130.7 83.6 L 130.5 83.6"},{type:"path",fill:!!R&&G,stroke:!1,d:"M 117.5 72.9 L 117.3 74.7 L 128.3 74.7 L 128.3 72.9 L 117.5 72.9 z M 126 83.7 L 111.3 105.3 L 111.5 110.3 L 127.7 110.3 L 127.7 105.3 L 115.5 105.3 C 115.7 104.5 121.9 95.7 122.9 94.3 C 123.8 92.9 129.6 83.7 130.5 83.7 L 126 83.7 z "}],i["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]={type:"path",stroke:!1,d:"M 100.2 62.3 C 100.1 63.2 99 66.3 98.7 67.4 C 97.8 69.9 99.4 70 99.4 72.3 L 99.4 73 C 99.4 73.7 98.9 73.5 98.3 73.8 C 96.6 72.4 94.2 71 91.3 71 L 90 71 C 84.2 71 80 75.5 74.6 75.5 L 73.9 75.5 C 72.3 75.5 71.5 74.1 71.3 75.8 L 74.3 77.2 C 71.8 82.4 69.9 89.7 67.5 95.5 C 66.3 98.6 65.3 101.6 64.1 104.7 C 63.5 106.3 63.1 107.7 62.5 109.3 C 62 110.5 61.8 113.1 60.2 113.2 C 62.4 116.4 68 120.5 73.3 120.5 L 76 120.5 C 81.6 120.5 87.3 116.6 89.5 113.2 L 88.2 113.2 L 75.4 77.2 L 74.5 77.2 L 74.5 77 L 75.4 77.2 L 78.6 77.7 L 79.3 77.7 L 89.3 76.2 L 90.4 76.3 C 93.7 76.3 93.8 80.2 94.7 80.2 L 97.7 80.2 L 97.7 129.2 L 86.1 129.2 L 86.1 131.5 L 81.4 131.5 L 81.4 134.1 L 77.5 134.1 L 77.5 138.2 L 123.3 138.2 L 123.3 133.9 L 119.3 133.9 L 119.3 131.6 L 114.5 131.6 L 114.5 129.2 L 102.6 129.2 L 102.6 80.2 L 106 80.2 C 107 80.2 106.6 76.4 110.7 76.4 L 111.3 76.4 L 121.2 77.7 L 122.2 77.7 L 125.4 77.3 C 124.3 79.7 123.1 83.8 122.1 86.4 C 120.9 89.6 119.9 92.6 118.7 95.8 C 117.5 98.9 116.6 101.9 115.4 105 C 114.9 106.4 114.2 108.1 113.7 109.6 C 113.4 110.4 113.1 111.1 112.9 111.9 C 112.5 113.2 112.8 113.2 111.2 113.2 C 113.3 116.4 119.2 120.5 124.6 120.5 L 127.2 120.5 C 132.6 120.5 138.8 116.4 140.9 113.2 L 139.8 113.2 L 126.4 77.1 C 127.4 76.9 129.3 76.2 129.3 75.3 C 129.3 74.5 127.8 75.5 126.7 75.5 L 126.3 75.5 C 120.8 75.5 116.6 71 110.9 71 L 109.6 71 C 106.7 71 104.2 72.4 102.6 73.8 C 101.8 73.4 101.3 73.6 101.3 72.3 C 101.3 71.9 102.4 68.8 102.5 68.5 L 100.6 62.3 L 100.2 62.3 z M 126.1 80.8 L 137.8 113.2 L 114.1 113.2 L 126.1 80.8 z M 74.8 80.8 L 86.5 113.2 L 63.1 113.1 L 74.8 80.8 z"},i["GR.IC.FF.DIRECTION FINDING"]={type:"path",d:"M100,140 l0,-80 M80,80 l20,-20 20,20",fill:!1},i["GR.IC.FF.DIVISION AND BELOW SUPPORT"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50",fill:!1},Neutral:{type:"path",d:"M45,50 l20,50 -20,50",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20",fill:!1}}[T],i["GR.IC.FF.EMERGENCY OPERATION"]=[{type:"path",d:"M 100 65 L 115.2 91.3 L 130.3 117.5 C 133.3 112.4 135 106.4 135 100 C 135 80.7 119.3 65 100 65 z M 100 65 C 80.7 65 65 80.7 65 100 C 65 106.4 66.7 112.4 69.7 117.5 L 84.8 91.3 L 100 65 z M 69.7 117.5 C 75.7 128 87 135 100 135 C 113 135 124.3 128 130.3 117.5 L 100 117.5 L 69.7 117.5 z"},{type:"path",fill:!!R&&G,stroke:!1,d:"M 69.7,117.5 100,65 l 30.3,52.5 z"}],i["GR.IC.FF.FIELD ARTILLERY ROCKET"]={type:"path",d:"M100,150 l0,-97 M85,130 l0,-50 M115,130 l0,-50 M85,73 l15,-20 15,20",fill:!1},i["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]={Unknown:{type:"path",d:"M35,80 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,80 l150,0 ",fill:!1},Neutral:{type:"path",d:"M45,80 l110,0 ",fill:!1},Hostile:{type:"path",d:"M50,80 l100,0 ",fill:!1}}[T],i["GR.IC.FF.HORSE"]={type:"path",d:"m 129,72.8 c 0,0 -6.3,2 -9,2.6 -3.4,0.7 -4.9,1.8 -7.7,3.1 -4.2,1.9 -6.8,3.6 -11.3,4.3 -3.3,0.5 -7.7,1.7 -11,1 -3.9,-0.9 -6.1,-2.9 -10.1,-2.9 -3.7,-0 -7.4,-0.6 -10.6,1.3 -2.6,1.6 -4.7,4.2 -5.8,7.1 -2.3,5.4 -0.8,12.5 -1.2,18.4 -0.2,3.1 -0.4,9.3 -0.6,10.2 0,0 1.6,-0 3.4,-2.5 0.9,-1.2 1.7,-3.4 1.9,-4.9 0.5,-3.1 -0.7,-7.5 -0.4,-10 1.1,-0.3 2.4,2.8 2.6,4.7 0.2,2 -1,3.3 -1.4,5.2 -0.5,3 0.3,5 0.6,8.3 0.1,1.6 0.8,3.9 0.5,6 -0.2,2 -0.2,4.3 -0.2,4.3 l 6.9,0 -0.4,-3.8 c 0,0 -1.8,-2.5 -2.1,-4.3 -0.5,-2.7 -0.5,-5.4 0.2,-8 0.5,-2 3.1,-4.3 4.1,-6.1 1.8,-3.1 3.1,-7.1 3.1,-7.1 0,0 5.1,3.4 9.1,4.2 3.8,0.8 11.6,1.4 11.6,1.4 0,0 -0.2,7.3 0.1,12.4 -0,0.1 0.3,3.9 0.3,3.1 -1.4,3.2 -0,8.2 -0,8.2 0,0 2.9,0 6.3,-0 l -0.3,-3.4 c 0,0 -1.5,-3.5 -1.5,-5.3 0,-3.1 0.1,-5.9 0.9,-8.9 0.4,-1.2 0.7,-2.9 1.3,-4 1.4,-2.2 3.1,-3.8 4.2,-6.1 1.1,-2.6 2.3,-5.3 3.6,-7.9 1.6,-3.3 7.8,-7.3 7.8,-7.3 0,0 5,2.9 8.4,4.9 1.2,0.7 3,0.1 3.7,-1 0.7,-1.1 0.8,-2.2 0.3,-3.3 -3.2,-6.7 -7.8,-9.4 -7.8,-9.4 z",stroke:!1},i["GR.IC.FF.INFANTRY"]={Unknown:{type:"path",d:"M50,65L150,135M50,135L150,65"},Friend:{type:"path",d:"M25,50 L175,150 M25,150 L175,50"},Neutral:{type:"path",d:"M45,45L155,155M45,155L155,45"},Hostile:{type:"path",d:"M60,70L140,130M60,130L140,70"}}[T],i["GR.IC.FF.INFANTRY DISMOUNTED"]={Unknown:{type:"path",d:"M50,65L150,135M50,135L150,65"},Friend:{type:"path",d:"m 45,70 110,60 M 45,130 155,70"},Neutral:{type:"path",d:"M45,45L155,155M45,155L155,45"},Hostile:{type:"path",d:"M60,70L140,130M60,130L140,70"}}[T],i["GR.IC.FF.INTERCEPT"]={type:"path",d:"M100,120 l0,-60 M80,120 l20,20 20,-20"},i["GR.IC.FF.JAMMING"]={Unknown:{type:"path",d:"M63,60 c10,0 0,10 7,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 7,-10 M40,75 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10",fill:!1},Friend:{type:"path",d:"M25,60 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 M25,75 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10",fill:!1},Neutral:{type:"path",d:"M45,60 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10  M45,75 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10",fill:!1},Hostile:{type:"path",d:"M67,60 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 13,10   M52,75 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 10,-10 c10,0 0,10 10,10 c10,0 0,-10 7,-10",fill:!1}}[T],i["GR.IC.FF.LAW ENFORCEMENT"]={type:"path",d:"m 99.6,51 c -2.8,0 -5,2.3 -5,5.3 0,2.1 1.2,3.9 2.8,4.7 L 87.8,78.3 69.5,78.4 c -0.1,-2.8 -2.3,-5.1 -5,-5.1 -2.8,0 -5,2.3 -5,5.3 0,2.9 2.2,5.3 5,5.3 0.7,0 1.4,-0.2 2,-0.4 l 9.2,16.8 -9.4,17.2 c -0.6,-0.2 -1.2,-0.4 -1.8,-0.4 -2.8,0 -5,2.4 -5,5.3 0,2.9 2.2,5.3 5,5.3 2.8,0 5,-2.3 5,-5.3 0,-0.1 -0,-0.2 -0,-0.3 l 18.3,0.1 9.5,17.1 c -1.6,0.9 -2.7,2.6 -2.7,4.6 0,2.9 2.3,5.3 5,5.3 2.8,0 5,-2.3 5,-5.3 0,-1.9 -0.9,-3.5 -2.3,-4.4 l 9.6,-17.3 18.7,-0.1 c -0,0.1 -0,0.2 -0,0.3 0,2.9 2.3,5.3 5,5.3 2.8,0 5,-2.3 5,-5.3 0,-2.9 -2.2,-5.3 -5,-5.3 -0.8,0 -1.5,0.2 -2.1,0.5 l -9.5,-17.4 9.5,-17.4 c 0.6,0.3 1.4,0.5 2.1,0.5 2.8,0 5,-2.4 5,-5.3 0,-2.9 -2.2,-5.3 -5,-5.3 -2.8,0 -5,2.3 -5,5.3 0,0.1 0,0.2 0,0.3 L 111.8,78.3 102.1,60.8 c 1.5,-0.9 2.5,-2.6 2.5,-4.5 0,-2.9 -2.2,-5.3 -5,-5.3 z"},i["GR.IC.FF.MAIN GUN SYSTEM"]={Unknown:{type:"path",d:"M55,65L55,135"},Friend:{type:"path",d:"M55,50L55,150"},Neutral:{type:"path",d:"M55,45L55,155"},Hostile:{type:"path",d:"M55,72L55,128"}}[T],i["GR.IC.FF.MEDICAL"]={type:"path",d:"M100,"+S.bbox.y1+"L100,"+S.bbox.y2+"M"+S.bbox.x1+",100L"+S.bbox.x2+",100"},i["GR.IC.FF.MEDICAL THEATER"]={Unknown:{type:"path",d:"M100,170 l0,-140 M40,75 l15,25 -15,25 M160,75 l-15,25 15,25 M55,100 l90,0",fill:!1},Friend:{type:"path",d:"M100,150 l0,-100 M25,50 l30,50 -30,50 M175,50 l-30,50 30,50 M55,100 l90,0",fill:!1},Neutral:{type:"path",d:"M100,155 l0,-110  M45,50 l20,50 -20,50 M155,50 l-20,50 20,50 M65,100 l70,0",fill:!1},Hostile:{type:"path",d:"M100,172 l0,-144 M50,80 l15,20 -15,20 M150,80 l-15,20 15,20 M65,100 l70,0",fill:!1}}[T],i["GR.IC.FF.MEDICAL CORPS"]={Unknown:{type:"path",d:"M100,170 l0,-140 M160,75 l-15,25 15,25 M30,100 l115,0",fill:!1},Friend:{type:"path",d:"M100,150 l0,-100  M175,50 l-30,50 30,50 M25,100 l120,0",fill:!1},Neutral:{type:"path",d:"M100,155 l0,-110 M155,50 l-20,50 20,50 M45,100 l90,0",fill:!1},Hostile:{type:"path",d:"M100,172 l0,-144  M150,80 l-15,20 15,20 M28,100 l110,0",fill:!1}}[T],i["GR.IC.FF.MEDICAL TREATMENT FACILITY"]=[i["GR.IC.FF.MEDICAL"],{type:"path",fill:!1,d:"M70,90 l0,20  M130,90 l0,20"}],i["GR.IC.FF.MILITARY POLICE"]={type:"path",d:"M 100,140 C 53.7465,122.654 71.0916,95.6737 65.3099,70.6197 c 11.5634,13.4906 23.1267,13.4906 34.6901,0 11.564,13.4906 23.126,13.4906 34.69,0 C 128.908,95.6737 146.254,122.654 100,140 Z",fill:!1},i["GR.IC.FF.MOTORIZED"]={type:"path",d:"M100,"+S.bbox.y1+"L100,"+S.bbox.y2},i["GR.IC.FF.NAVAL"]=[{type:"path",d:"M 100,145 100,65",fill:!1},{type:"path",d:"m 70,70 60,0",fill:!1},{type:"path",d:"m 57.8,105.5 c -2.2,0.1 1.3,20.6 2.8,22.1 0.8,0.8 3.5,-3.8 4.6,-2.6 17.4,20.2 33,19.7 34.7,19.6 0,0 0.2,-0 0.3,0 1.7,0.1 17.3,0.5 34.7,-19.6 1,-1.2 3.7,3.4 4.6,2.6 1.4,-1.5 4.9,-21.9 2.8,-22.1 -2.2,-0.1 -4,4.2 -6.7,6.4 -3,2.4 -7.5,3.4 -7.7,4.5 -0.1,0.8 4.9,3.5 3.9,4.9 -5.1,6.3 -15.1,16.6 -31.3,17 l -0.3,4.3 -0.3,-4.3 c -16.2,-0.4 -26.3,-10.7 -31.3,-17 -1.1,-1.3 4,-4.1 3.9,-4.9 -0.2,-1 -4.7,-2 -7.7,-4.5 -2.7,-2.3 -4.5,-6.6 -6.7,-6.4 z",stroke:!1},{type:"circle",cx:100,cy:60,r:5,fill:!1}],i["GR.IC.FF.PRISON"]={type:"path",stroke:!1,d:"M 62.5 67.9 L 62.5 73.4 L 69.9 73.4 L 69.9 106 C 66.8 106.7 64.4 109.6 64.4 113.4 C 64.4 116 65.8 116.9 65.9 118.4 C 66 120.4 65.6 122.5 65.6 124.7 L 65.6 126.6 L 62.5 126.6 L 62.5 132.1 L 137.5 132.1 L 137.5 126.6 L 136 126.6 L 135.6 117.5 C 138.3 113.4 135.8 107 131.5 106 L 131.5 73.4 L 137.5 73.4 L 137.5 67.9 L 62.5 67.9 z M 74.5 73.4 L 87.2 73.4 L 87.2 108.4 C 87.2 109.2 84.8 109.7 83.9 110.6 C 83.1 111.3 82.2 112.7 81.6 113.6 C 80.5 115.2 78.6 118.7 78.6 121.1 L 76.1 117 C 76.5 116.4 76.9 114.6 76.9 113.7 L 76.9 112.2 C 76.9 109.5 74.5 107.9 74.5 106.5 L 74.5 73.4 z M 91.5 73.4 L 110.2 73.4 L 110.2 90.9 C 109 89.6 108.8 87.8 106.8 85.7 C 105.4 84.3 103.5 83 100.8 83 L 100.3 83 C 98.2 83 96.1 83.6 94.9 84.5 C 94.3 85 93.6 85.4 93.1 86 C 92.4 86.6 92.2 87.3 91.5 87.8 L 91.5 73.4 z M 114.3 73.4 L 127.2 73.4 L 127.2 106.5 C 127.2 106.9 124.8 109.2 124.4 111.1 C 123.7 114.2 124.5 114.6 125 117 L 123.3 120.2 C 122.7 118.3 120.7 115 119.7 113.5 C 118.3 111.4 117.3 109.1 114.3 108.9 L 114.3 73.4 z M 99.7 84.9 L 100.6 84.9 C 104.8 84.9 108.5 90.4 108.5 94.7 L 108.5 96.4 C 108.5 100.4 105 106.2 101.3 106.2 L 99.4 106.2 C 94.9 106.2 91.4 100.2 91.6 95.5 C 91.8 90.7 94.9 84.9 99.7 84.9 z M 110.3 100.5 L 110.2 106.9 L 106.7 106.3 L 110.3 100.5 z M 91.5 103.6 L 94.3 106.8 L 91.5 107.4 L 91.5 103.6 z M 70.7 107.9 C 72.9 107.9 74.7 110.4 74.7 112.7 L 74.7 113.4 C 74.7 117.9 70 120.2 67.6 116.7 C 65.7 113.8 66.9 107.9 70.7 107.9 z M 130.6 107.9 C 132.8 107.9 134.4 110.8 134.4 113.2 L 134.4 113.4 C 134.4 116.7 133 116.7 132 118.2 L 128.9 118.3 L 126.7 115.4 L 126.5 113.2 C 126.1 111 128.2 107.9 130.6 107.9 z M 105.9 108.2 C 107.2 108.2 108.9 109 110.2 109.3 L 110.2 126.6 L 91.5 126.6 L 91.5 110.1 C 91.5 108.6 96.6 108.9 98.4 108.9 C 101.1 108.9 104 108.2 105.9 108.2 z M 114.3 110.8 C 117.2 112.3 117.4 113.4 119 116.4 C 120.1 118.5 121.7 120.9 121.7 124 C 121.9 124.2 122.3 124.9 122.7 124.9 C 124 124.9 125.5 119.8 126.7 118.9 L 126.7 119.4 L 127.2 119.4 L 127.2 126.6 L 114.3 126.6 L 114.3 110.8 z M 87.2 111.3 L 87.2 126.6 L 74.5 126.6 L 74.5 118.9 C 75.8 119.4 77.4 125.4 78.6 125.4 C 80.6 125.4 80.7 119.6 81.9 117.5 C 83.2 115.3 84.4 111.9 87.2 111.3 z M 133.6 119.7 L 133.9 126.6 L 131.5 126.6 L 131.5 120.4 L 133.6 119.7 z M 68.1 119.9 C 68.6 120.1 69.9 120.3 69.9 121.1 L 69.9 126.6 L 67.7 126.6 L 68.1 119.9 z"},i["GR.IC.FF.JAIL BREAK"]=[i["GR.IC.FF.PRISON"],{type:"path",strokewidth:5,d:"m 70,130 L130,70",fill:!1}],i["GR.IC.FF.RECONNAISSANCE"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M25,150L175,50"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],i["GR.IC.FF.RECONNAISSANCE DISMOUNTED"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M 45,130 155,70"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],i["GR.IC.FF.RECONNAISSANCE EQUPIMENT"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M 50.6 132.9 L 149.3 67"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],i["GR.IC.FF.SEARCH"]={type:"path",d:"m 100,145 0,-90 m 30,65 -30,25 -30,-25",fill:!1},i["GR.IC.FF.SENSOR"]=[{type:"path",d:"M"+S.bbox.x1+",100 L75,100 M"+(200-S.bbox.x1)+",100 L125,100"},{type:"path",d:"M65,85 l70,0 -15,30 -40,0 z",fill:!!R&&G}],i["GR.IC.FF.SIGNAL"]={Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 100,110 100,90 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T],i["GR.IC.FF.SIGNAL DISMOUNTED"]={Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M 52,66.8 100,110 l 0,-20 47.9,43.1"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T],i["GR.IC.FF.SOUND"]=[{type:"path",d:"M"+S.bbox.x1+",100 L75,100 M"+(200-S.bbox.x1)+",100 L125,100"},{type:"path",d:"M65,85 l70,0 -15,30 -40,0 z",fill:!!R&&G},{type:"text",stroke:!1,x:100,y:110,fontsize:25,text:"S"}],i["GR.IC.FF.SUPPLY"]={Unknown:{type:"path",d:"M35,120 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,120 l150,0",fill:!1},Neutral:{type:"path",d:"M45,120 l110,0",fill:!1},Hostile:{type:"path",d:"M50,120 l100,0 ",fill:!1}}[T],i["GR.IC.FF.SUPPLY CORPS"]={Unknown:{type:"path",d:"M160,75 l-15,25 15,25 M35,120 l120,0",fill:!1},Friend:{type:"path",d:"M175,50 l-30,50 30,50 M25,120 l135,0",fill:!1},Neutral:{type:"path",d:"M155,50 l-20,50 20,50 M45,120 l100,0",fill:!1},Hostile:{type:"path",d:"M150,80 l-15,20 15,20 M50,120 l100,0",fill:!1}}[T],i["GR.IC.FF.SUPPLY DIVISION AND BELOW"]={Unknown:{type:"path",d:"m 45,120 120,0 M 40,75 55,100 40,125",fill:!1},Friend:{type:"path",d:"m 45,120 130,0 M 25,50 55,100 25,150",fill:!1},Neutral:{type:"path",d:"m 57,120 98,0 M 45,50 65,100 45,150",fill:!1},Hostile:{type:"path",d:"m 50,120 100,0 M 50,80 65,100 50,120",fill:!1}}[T],i["GR.IC.FF.SUPPLY THEATER"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25 M160,75 l-15,25 15,25 M45,120 l110,0 ",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50 M175,50 l-30,50 30,50 M40,120 l120,0 ",fill:!1},Neutral:{type:"path",d:" M45,50 l20,50 -20,50 M155,50 l-20,50 20,50 M55,120 l90,0 ",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20 M150,80 l-15,20 15,20 M50,120 l100,0",fill:!1}}[T],i["GR.IC.FF.CLASS ALL"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"ALL"},i["GR.IC.FF.CLASS MULTIPLE"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MULT"},i["GR.IC.FF.CLASS I"]={type:"path",d:"m 105,85 c -5,10 -5,20 0,30 m 0,-30 c -20,0 -20,30 0,30",fill:!1},i["GR.IC.FF.NATO SUPPLY CLASS I"]=a("I"),i["GR.IC.FF.CLASS II"]=i["GR.IC.QUARTERMASTER"],i["GR.IC.FF.NATO SUPPLY CLASS II"]=a("II"),i["GR.IC.FF.CLASS III"]={type:"path",d:"m 100,120 0,-20 -15,-20 30,0 -15,20 ",fill:!1},i["GR.IC.FF.CLASS IV"]=i["GR.IC.ENGINEER"],i["GR.IC.FF.NATO SUPPLY CLASS IV"]=a("IV"),i["GR.IC.FF.CLASS V"]={type:"path",d:"m 90,115 0,-25 c 0,-10 20,-10 20,0 l 0,25 m -25,0 30,0",fill:!1},i["GR.IC.INTERPRETER/TRANSLATOR"]=[{type:"path",d:"m 65,90 15,0 0,-10 20,20 -20,20 0,-10 -15,0 z",fill:G},{type:"path",d:"m 135,90 -15,0 0,-10 -20,20 20,20 0,-10 15,0 z"}],i["GR.IC.FF.NATO SUPPLY CLASS ALL"]=a("ALL"),i["GR.IC.FF.CLASS VI"]=[{type:"circle",cx:100,cy:85,r:5,fill:!1},{type:"path",d:"m 85,95 30,0 m -15,15 0,-20 m -10,30 10,-10 10,10",fill:!1}],i["GR.IC.FF.CLASS VII"]=[{type:"circle",cx:75,cy:100,r:7},{type:"circle",cx:125,cy:100,r:7},{type:"path",d:"M75,100 c0,-20 50,-20 50,0",fill:!1}],i["GR.IC.FF.CLASS VIII"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M165,80 l-130,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M175,80 l-150,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M155,80 l-110,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],i["GR.IC.FF.CLASS VIII.THEATER"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M155,80 l-110,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M155,80 l-110,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M145,80 l-90,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],i["GR.IC.FF.CLASS VIII.CORPS"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M155,80 l-120,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M155,80 l-130,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M145,80 l-100,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],i["GR.IC.FF.CLASS IX"]=[{type:"circle",cx:100,cy:100,r:10,fill:!1},{type:"path",d:"m 100,110 0,10 m 0,-30 0,-10 m 8.7,14.2 8.4,-4.8 m -8.4,15.9 8,5.4 m -25.4,-5.4 -8.2,5.4 m 8.2,-16.3 -8,-5.4",fill:!1}],i["GR.IC.EQUIPMENT MANUFACTURE"]=[{type:"circle",cx:100,cy:100,r:20,fill:!1},{type:"path",d:"m 100,120 0,20 m 0,-60 0,-20 m 18.1,28.4 16,-9.6 m -16,31.2 16,12 M 82.5,110 66.1,122 M 82.5,88.8 66.5,78",fill:!1}],i["GR.IC.FF.CLASS X"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"CA"},i["GR.IC.FF.THEATRE SUPPORT"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25 M160,75 l-15,25 15,25",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50 M175,50 l-30,50 30,50",fill:!1},Neutral:{type:"path",d:"M45,50 l20,50 -20,50 M155,50 l-20,50 20,50",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20 M150,80 l-15,20 15,20",fill:!1}}[T],i["GR.IC.FF.US MARSHALS SERVICE"]={type:"path",d:"m 100,70 7.1,20.3 21.5,0.4 -17.1,13 6.2,20.6 L 100,112 82.4,124.3 88.6,103.7 71.5,90.7 92.9,90.3 z m 0,-5 c -19.3,0 -35,15.7 -35,35 0,19.3 15.7,35 35,35 19.3,0 35,-15.7 35,-35 0,-19.3 -15.7,-35 -35,-35 z m 0,5 c 16.6,0 30,13.4 30,30 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 z"},i["GR.M1.ACCIDENT"]=l("ACC"),i["GR.M1.AIRMOBILE/AIR ASSAULT"]={type:"path",fill:!1,d:"M85,55 L100,75 115,55"},i["GR.M1.ARMORED"]={type:"path",fill:!1,d:"m 90,60 20,0 c 10,0 10,15 0,15 L 90,75 C 80,75 80,60 90,60"},i["GR.M1.CARGO"]={type:"path",fill:!1,d:"m 100,60 0,15 -15,0 0,-15 30,0 0,15 -15,0"},i["GR.M1.AMMUNITION"]={type:"path",d:"M95,75 L95,60 C95,55 105,55 105,60 L105,75 M90,75 L110,75",fill:!1},i["GR.M1.AMPHIBIOUS WARFARE SHIP "]={type:"path",d:"M 113,75 100,75 90,64.3 95,65 l 0,-8 10,0 0,8 5.5,-0.6 L 100,75"},i["GR.M1.ANTISUBMARINE WARFARE"]=l("P"),i["GR.M1.AREA"]=l("AREA"),i["GR.M1.ARMY"]=l("XXXX"),i["GR.M1.ATTACK"]=l("A"),i["GR.M1.AVIATION"]={type:"path",d:"m 75,60 0,15 50,-15 0,15 z"},i["GR.M1.BATTALION"]=l("II"),i["GR.M1.BIOLOGICAL"]=l("B"),i["GR.M1.BORDER"]=l("BOR"),i["GR.M1.BRIDGING"]={type:"path",fill:!1,d:"m 80,80 5,-5 30,0 5,5 m -40,-20 5,5 30,0 5,-5"},i["GR.M1.BRIGADE"]=l("X"),i["GR.M1.CHEMICAL"]=l("C"),i["GR.M1.INTRUSION"]=l("I"),i["GR.M1.CHEMICAL SURVEILLANCE"]=l("RS"),i["GR.M1.CIVILIAN"]=l("CIV"),i["GR.M1.CLOSE PROTECTION"]=l("CLP"),i["GR.M1.COMBAT"]=l("CBT"),i["GR.M1.COMMAND AND CONTROL"]=l("C2"),i["GR.M1.COMMAND AND CONTROL ROTARY WING"]=l(R?"Y":"C2"),i["GR.M1.TILT-ROTOR"]=l("TR"),i["GR.M1.COMMAND POST NODE"]=l("CPN"),i["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]=l("CCP"),i["GR.M1.CONSTRUCTION"]={type:"text",stroke:!1,x:100,y:75,fontsize:20,text:"CONST"},i["GR.M1.COMPANY"]=l("I"),i["GR.M1.CORPS"]=l("XXX"),i["GR.M1.CROSS CULTURAL COMMUNICATION"]=l("CCC"),i["GR.M1.CROWD AND RIOT CONTROL"]=l("CRC"),i["GR.M1.DECONTAMINATION"]=l("D"),i["GR.M1.DETENTION"]=l("DET"),i["GR.M1.DEPUTY"]=l("DEP"),i["GR.M1.DIRECT COMMUNICATIONS"]={type:"path",fill:!1,d:"m 95,65 -5,5 5,5 m 10,-10 5,5 -5,5 M 90,70 c 20,0 20,0 20,0 m 15,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -40,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z"},i["GR.M1.DIVING"]={type:"path",fill:!1,d:"m 104.6,64.8 c 0,2.7 -2.1,4.8 -4.6,4.8 -2.5,0 -4.6,-2.2 -4.6,-4.8 0,-2.7 2.1,-4.8 4.6,-4.8 2.5,0 4.6,2.2 4.6,4.8 z m 0,8.7 4.6,4.8 -18.3,0 4.6,-4.8 M 108.3,60 l 4.6,0 0,9.6 -4.6,0 m -16.5,0 -4.6,0 0,-9.6 4.6,0 m 17.4,4.8 c 0,5.3 -4.1,9.6 -9.2,9.6 -5.1,0 -9.2,-4.3 -9.2,-9.6 0,-5.3 4.1,-9.6 9.2,-9.6 5.1,0 9.2,4.3 9.2,9.6 z"},i["GR.M1.DIVISION"]=l("XX"),i["GR.M1.MARINE DIVISION"]=l("D"),i["GR.M1.DOG"]=l("DOG"),i["GR.M1.DRILLING"]={type:"path",d:"m 90,60 5,15 10,0 5,-15 z"},i["GR.M1.ELECTRO-OPTICAL"]=l("EO"),i["GR.M1.ENHANCED"]=l("ENH"),i["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]=l("EOD"),i["GR.M1.EARLY WARNING RADAR"]=l("EWR"),i["GR.M1.FIRE DIRECTION CENTRE"]=l("FDC"),i["GR.M1.FORCE"]=l("F"),i["GR.M1.FORWARD"]=l("FWD"),i["GR.M1.GROUND STATION MODULE"]=l("GSM"),i["GR.M1.HIJACKING"]=l("H"),i["GR.M1.INDIVIDUAL"]={type:"path",fill:!1,d:"M85,65 l30,0"},i["GR.M1.INTRUSION"]=l("I"),i["GR.M1.J1"]=l("J1"),i["GR.M1.J2"]=l("J2"),i["GR.M1.J3"]=l("J3"),i["GR.M1.J4"]=l("J4"),i["GR.M1.J5"]=l("J5"),i["GR.M1.J6"]=l("J6"),i["GR.M1.J7"]=l("J7"),i["GR.M1.J8"]=l("J8"),i["GR.M1.J9"]=l("J9"),i["GR.M1.JOINT NETWORK NODE"]=l("JNN"),i["GR.M1.LANDING SUPPORT"]=l("LS"),i["GR.M1.LARGE COMMUNICATIONS CONTINGENCY PACKAGE"]=l("LCCP"),i["GR.M1.LARGE EXTENSION NODE"]=l("LEN"),i["GR.M1.LOAD HANDLING SYSTEM"]=l("LHS"),i["GR.M1.MAINTENANCE"]={type:"path",fill:!1,d:"m 84,70 32,0 m 4,-5 c -5,0 -5,10 0,10 M 80,65 c 5,0 5,10 0,10"},i["GR.M1.MEDEVAC"]={type:"path",stroke:!1,d:"M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},i["GR.M1.METEOROLOGICAL"]=l("MET"),i["GR.M1.MINE COUNTERMEASURE"]=l("MCM"),i["GR.M1.MISSILE"]={type:"path",d:"M95,80 L95,60 C95,55 105,55 105,60 L105,80 M100,80 L100,55",fill:!1},i["GR.M1.(MOBILE) ADVISOR AND SUPPORT"]={type:"path",d:"m 105,65 5,5 -5,5 M 90,70 c 20,0 20,0 20,0 m 15,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -40,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z",fill:!1},i["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]=l("MSE"),i["GR.M1.MOBILITY ASSAULT"]=l("MA"),i["GR.M1.MOBILITY SUPPORT"]=l("MS"),i["GR.M1.MOVEMENT CONTROL CENTRE"]=l("MCC"),i["GR.M1.MULTINATIONAL"]=l("MN"),i["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]=l("MSU"),i["GR.M1.MULTIPLE ROCKET LAUNCHER"]={type:"path",d:"M85,75 l15,-15 15,15 M85,67 l15,-15 15,15",fill:!1},i["GR.M1.NATO MEDICAL ROLE 1"]={type:"text",stroke:!1,x:120,y:77,fontsize:25,text:"1"},i["GR.M1.NATO MEDICAL ROLE 2"]={type:"text",stroke:!1,x:120,y:77,fontsize:25,text:"2"},i["GR.M1.NATO MEDICAL ROLE 3"]={type:"text",stroke:!1,x:120,y:77,fontsize:25,text:"3"},i["GR.M1.NATO MEDICAL ROLE 4"]={type:"text",stroke:!1,x:120,y:77,fontsize:25,text:"4"},i["GR.M1.NAVAL"]=s._translate(0,-35,s._scale(.6,i["GR.IC.NAVAL"])),i["GR.M1.NODE CENTRE"]=l("NC"),i["GR.M1.NUCLEAR"]=l("N"),i["GR.M1.OF-1"]=l("OF-1"),i["GR.M1.OF-2"]=l("OF-2"),i["GR.M1.OF-3"]=l("OF-3"),i["GR.M1.OF-4"]=l("OF-4"),i["GR.M1.OF-5"]=l("OF-5"),i["GR.M1.OF-6"]=l("OF-6"),i["GR.M1.OF-7"]=l("OF-7"),i["GR.M1.OF-8"]=l("OF-8"),i["GR.M1.OF-9"]=l("OF-9"),i["GR.M1.OF-10"]=l("OF-10"),i["GR.M1.OF-D"]=l("OF-D"),i["GR.M1.OPERATIONS"]=l("OPS"),i["GR.M1.OPTICAL"]=l("OPT"),i["GR.M1.OR-1"]=l("OR-1"),i["GR.M1.OR-2"]=l("OR-2"),i["GR.M1.OR-3"]=l("OR-3"),i["GR.M1.OR-4"]=l("OR-4"),i["GR.M1.OR-5"]=l("OR-5"),i["GR.M1.OR-6"]=l("OR-6"),i["GR.M1.OR-7"]=l("OR-7"),i["GR.M1.OR-8"]=l("OR-8"),i["GR.M1.OR-9"]=l("OR-9"),i["GR.M1.OTHER"]=l("OTH"),i["GR.M1.PALLETIZED LOAD SYSTEM"]=l("PLS"),i["GR.M1.PERSONNEL RECOVERY"]=l("H"),i["GR.M1.PLATOON"]=[{type:"circle",stroke:!1,cx:80,cy:68,r:8},{type:"circle",stroke:!1,cx:100,cy:68,r:8},{type:"circle",stroke:!1,cx:120,cy:68,r:8}],i["GR.M1.RADAR"]={type:"path",fill:!1,d:"m 85,55 c 0.1,21.4 11.7,24.6 25,25 M 116,55 101,67.5 101,55 86.6,66.9"},i["GR.M1.RADIO FREQUENCY IDENTIFICATION (RFID) INTERROGATOR/ SENSOR"]=l("RF"),i["GR.M1.RAILROAD"]=s._translate(0,-50,[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:125,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}]),i["GR.M1.RADIOLOGICAL"]=l("RAD"),i["GR.M1.RANGER"]=l("RGR"),i["GR.M1.RECON"]=l("R"),i["GR.M1.REGIMENT"]=l("III"),i["GR.M1.RETRANSMISSION SITE"]=l("RTNS"),i["GR.M1.ASSAULT"]=l("ASLT"),i["GR.M1.WEAPON"]=l("WPN"),i["GR.M1.WEAPONS"]=l("W"),i["GR.M1.CRIMINAL INVESTIGATION DIVISION"]=l("CID"),i["GR.M1.DIGITAL"]=l("DIG"),i["GR.M1.NETWORK OR NETWORK OPERATIONS"]=l("NET"),i["GR.M1.AIRFIELD, AERIAL PORT OF DEBARKATION, OR AERIAL PORT OF EMBARKATION"]={type:"path",d:"m 80,70 40,0 M 80,80 111,55",fill:!1},i["GR.M1.PIPELINE"]={type:"path",d:"m 92,66 -12,0 m 12,8 -12,0 m 28,0 12,0 m -12,-8 12,0 m -20,-11 0,7 m -5,-7 10,0 m -13,7 0,16 16,0 0,-16 -16,0",fill:!1},i["GR.M1.POSTAL"]={type:"path",d:"m 90,60 15,0 c 0,5 0,10 10,15 -15,0 -20,0 -25,-15",fill:!1},i["GR.M1.WATER"]={type:"path",d:"m 90,55 20,0 m -10,10 0,-10 m -25,10 40,0 c 10,0 15,5 15,10",fill:!1},i["GR.M1.INDEPENDENT COMMAND"]={type:"path",d:"m 111.8,59.2 0,15.8 m -7.9,-7.9 15.8,0 m -31.6,-7.9 0,15.8 m 7.9,-7.9 -15.8,0",fill:!1},i["GR.M1.MULTI-PURPOSE BLADE"]={type:"path",d:"m 80,65 20,-10 20,10 m -20,15 0,-25",fill:!1},i["GR.M1.TANK-WIDTH MINE PLOW"]={type:"path",d:"m 80,65 5,-2.5 m 5,-2.5 5,-2.5 m 10,0 5,2.5 m 5,2.5 5,2.5 m -20,15 0,-20",fill:!1},i["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"]=l("RRC"),i["GR.M1.SEARCH AND RESCUE"]=l("SAR"),i["GR.M1.SECTION"]=[{type:"circle",stroke:!1,cx:90,cy:68,r:8},{type:"circle",stroke:!1,cx:110,cy:68,r:8}],i["GR.M1.SECURITY"]=l("SEC"),i["GR.M1.SENSOR"]={type:"path",d:"m 100,55 c -2,5 -5,8 -10,10 5,2 8,5 10,10 2,-5 5,-8 10,-10 -5,-2 -8,-5 -10,-10 z"},i["GR.M1.SENSOR CONTROL MODULE"]=l("SCM"),i["GR.M1.SIGNALS INTELLIGENCE"]={type:"path",fill:!1,d:"m 100,55 0,23 m -15,-18 5,-5 5,5 5,-5 5,5 5,-5 5,5"},i["GR.M1.SIGNAL SUPPORT"]=l("SPT"),i["GR.M1.SINGLE SHELTER SWITCH"]=l("SSS"),i["GR.M1.SINGLE ROCKET LAUNCHER"]={type:"path",d:"M85,75 l15,-15 15,15",fill:!1},i["GR.M1.SMALL EXTENSION NODE"]=l("SEN"),i["GR.M1.SMOKE"]=l("S"),i["GR.M1.SMOKE/DECON"]=l("SD"),i["GR.M1.SNIPER"]={type:"path",d:"M75,60 l20,0 M100,76 l0,-18 M125,60 l-20,0",fill:!1},i["GR.M1.SOUND RANGING"]=l("SDR"),i["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]=l("SOF"),i["GR.M1.SPECIAL WEAPONS AND TACTICS"]={type:"text",stroke:!1,x:100,y:77,fontsize:23,text:"SWAT"},i["GR.M1.SQUAD"]={type:"circle",stroke:!1,cx:100,cy:68,r:8},i["GR.M1.SUPPORT"]=l("SPT"),i["GR.M1.SURVEY"]={type:"path",d:"m 108,78 -8,-8 m 0,0 -8,8 m 8,-8 0,-15 15,8 z"},i["GR.M1.TACTICAL EXPLOITATION"]=l("TE"),i["GR.M1.TARGET ACQUISITION"]=l("TA"),i["GR.M1.TEAM"]=[{type:"circle",fill:!1,cx:100,cy:65,r:10},{type:"path",d:"m 90,75 l20,-20"}],i["GR.M1.THEATRE"]=l("XXXXX"),i["GR.M1.TOPOGRAPHIC"]={type:"path",fill:!1,d:"m 92,65 c 6,3 10,3 16,0 m -18,13 10,-23 10,23"},i["GR.M1.TRAINING CAMP"]=l("TNG"),i["GR.M1.HIJACKER"]=l("HJ"),i["GR.M1.UNMANNED AERIAL VEHICLE"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},i["GR.M1.UPGRADED EARLY WARNING RADAR"]=l("UEW"),i["GR.M1.UTILITY"]=l("U"),i["GR.M1.VIDEO IMAGERY"]={type:"path",fill:!1,d:"m 120,65 -11,0 m 11,10 -14,0 m 4,-14 -30,0 0,18 25,0 z m 10,2 0,14"},i["GR.M1.WO-1"]=l("WO-1"),i["GR.M1.WO-2"]=l("WO-2"),i["GR.M1.WO-3"]=l("WO-3"),i["GR.M1.WO-4"]=l("WO-4"),i["GR.M1.WO-5"]=l("WO-5"),i["GR.M1.YARD"]=l("YRD"),i["GR.M2.AIRBORNE"]={type:"path",d:"M75,140 C75,125 100,125 100,140 C100,125 125,125 125,140",fill:!1},i["GR.M2.ARCTIC"]={type:"path",d:"M115,125 C125,125 125,135 115,135 L85,135 C75,135 75,125 85,125",fill:!1},i["GR.M2.ATTACK"]=r("A"),i["GR.M2.LANDING CRAFT"]=r("LC"),i["GR.M2.LANDING SHIP"]=r("LS"),i["GR.M2.SERVICE CRAFT/YARD"]=r("YY"),i["GR.M2.TUG HARBOR"]=r("YT"),i["GR.M2.OCEAN GOING TUG BOAT"]=r("AT"),i["GR.M2.SURFACE DEPLOYMENT AND DISTRIBUTION COMMAND"]=r("SDDC"),i["GR.M2.COMPOSITE"]=r("COMP"),i["GR.M2.LIGHT AND MEDIUM"]=r("L/M"),i["GR.M2.BATTLE DAMAGE REPAIR"]=r("BDR"),i["GR.M2.BICYCLE EQUIPPED"]={type:"circle",cx:100,cy:132,r:11,fill:!1},i["GR.M2.CASUALTY STAGING"]=r("CS"),i["GR.M2.CLEARING"]=r("CLR"),i["GR.M2.CLOSE RANGE"]=r("CR"),i["GR.M2.COMBAT SEARCH AND RESCUE"]=r("CSAR"),i["GR.M2.CONTROL"]={type:"path",d:"m 98,130 2,-4 2,4 m -8,8 -4,-2 4,-2 m 8,8 -2,4 -2,-4 m 8,-8 4,2 -4,2 m -14,-2 16,0 m -8,-8 0,16",fill:!1},i["GR.M2.NONCOMBATANT GENERIC VESSEL"]={type:"path",d:"m 95,135 0,-10 10,0 0,10 5,0 0,10 -20,0 0,-10 z",stroke:!1},i["GR.M2.SHELTER"]={type:"path",d:"m 85,140 30,0 -5,-15 -10,-5 -10,5 z",stroke:!1},i["GR.M2.SELF-PROPELLED"]={type:"path",d:"m 85,125 30,0 c 10,0 10,15 0,15 l -30,0 c -10,0 -10,-15 0,-15",fill:!1},i["GR.M2.CROSS-COUNTRY TRUCK"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:100,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],i["GR.M2.CAVALRY"]={type:"text",stroke:!1,x:110,y:140,fontsize:25,text:"CAV"},i["GR.M2.DECONTAMINATION"]=r("D"),i["GR.M2.DEMOLITION"]=r("DEM"),i["GR.M2.DENTAL"]={type:"text",stroke:!1,x:115,y:133,fontsize:25,text:"D"},i["GR.M2.DIGITAL"]=r("DIG"),i["GR.M2.ENHANCED POSITION LOCATION REPORTING SYSTEM"]={type:"path",d:"m 87,142 13,-12 13,12 m -13,-20 0,20 0,0",fill:!1},i["GR.M2.EQUIPMENT"]=r("E"),i["GR.M2.EQUIMENT/TROOP"]=r("E/T"),i["GR.M2.HEAVY"]=r("H"),i["GR.M2.HIGH ALTITUDE"]=r("HA"),i["GR.M2.HIGH TO MEDIUM ALTITUDE"]=r("HMA"),i["GR.M2.HIGH TO LOW ALTITUDE"]=r("HLA"),i["GR.M1.CYBERSPACE"]=l("CYB"),i["GR.M2.AIR ASSAULT"]={type:"path",fill:!1,d:"m 85,125 15,20 15,-20"},i["GR.M2.VERY HEAVY"]=r("VH"),i["GR.M2.CYBERSPACE"]=r("CYB"),i["GR.M2.NAVY BARGE, SELF-PROPELLED"]=r("YS"),i["GR.M2.NAVY BARGE, NOT SELF-PROPELLED"]=r("YB"),i["GR.M2.LAUNCH"]=r("YFT"),i["GR.M1.TACTICAL SATELLITE COMMUNICATIONS"]=[{type:"path",d:"m 105,65 10,0 m -30,0 10,0 M 85,77 c 10,-7 20,-7 30,0",fill:!1},{type:"path",d:"m 75.4,60.9 0,9.1 13.1,0 0,-9.1 z m 36,0 0,9.1 13.1,0 0,-9.1 z m -18,0 0,9.1 13.1,0 0,-9.1 z",stroke:!1}],i["GR.M2.INTERMODAL"]={type:"path",d:"m 80,125 40,0 0,-4 8,9 -8,9 0,-4 -40,0 0,4 -8,-9 8,-9 z",fill:!1},i["GR.M2.INTENSIVE CARE"]=r("IC"),i["GR.M2.J1"]=r("J1"),i["GR.M2.J2"]=r("J2"),i["GR.M2.J3"]=r("J3"),i["GR.M2.J4"]=r("J4"),i["GR.M2.J5"]=r("J5"),i["GR.M2.J6"]=r("J6"),i["GR.M2.J7"]=r("J7"),i["GR.M2.J8"]=r("J8"),i["GR.M2.J9"]=r("J9"),i["GR.M2.LIGHT"]=r("L"),i["GR.M2.LABORATORY"]=r("LAB"),i["GR.M2.LAUNCHER"]={type:"path",fill:!1,d:"M80,140 L115,120 120,140"},i["GR.M2.LONG RANGE"]=r("LR"),i["GR.M2.LONG RANGE SURVEILLANCE"]={type:"text",stroke:!1,x:110,y:140,fontsize:25,text:"LRS"},i["GR.M2.LOW ALTITUDE"]=r("LA"),i["GR.M2.MEDIUM"]=r("M"),i["GR.M2.MEDIUM ALTITUDE"]=r("MA"),i["GR.M2.MEDIUM TO LOW ALTITUDE"]=r("MLA"),i["GR.M2.MEDIUM RANGE"]=r("MR"),i["GR.M2.MOUNTAIN"]={type:"path",stroke:!1,d:"M90,140 L100,120 110,140"},i["GR.M2.MULTIPLE ALTITUDES"]=r("H/MA"),i["GR.M2.MULTI-CHANNEL"]=r("MC"),i["GR.M2.OF-1"]=r("OF-1"),i["GR.M2.OF-2"]=r("OF-2"),i["GR.M2.OF-3"]=r("OF-3"),i["GR.M2.OF-4"]=r("OF-4"),i["GR.M2.OF-5"]=r("OF-5"),i["GR.M2.OF-6"]=r("OF-6"),i["GR.M2.OF-7"]=r("OF-7"),i["GR.M2.OF-8"]=r("OF-8"),i["GR.M2.OF-9"]=r("OF-9"),i["GR.M2.OF-10"]=r("OF-10"),i["GR.M2.OF-D"]=r("OF-D"),i["GR.M2.OPTICAL"]=r("OPT"),i["GR.M2.OR-1"]=r("OR-1"),i["GR.M2.OR-2"]=r("OR-2"),i["GR.M2.OR-3"]=r("OR-3"),i["GR.M2.OR-4"]=r("OR-4"),i["GR.M2.OR-5"]=r("OR-5"),i["GR.M2.OR-6"]=r("OR-6"),i["GR.M2.OR-7"]=r("OR-7"),i["GR.M2.OR-8"]=r("OR-8"),i["GR.M2.OR-9"]=r("OR-9"),i["GR.M2.GUERILLA"]=r("G"),i["GR.M2.AMPHIBIOUS"]={Unknown:{type:"path",d:"M 64 144.9 C 80.4 143.9 63.1 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 137.1 125 120.2 143.6 135.9 144.9",fill:!1},Friend:{type:"path",d:"m 25,145 c 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 20,20",fill:!1},Neutral:{type:"path",d:"M 45 125 C 61.7 125.9 44.2 145 62.6 145 C 81.4 145 62.6 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 137.8 125 119 145 137.8 145 C 155.9 145 138.9 126.2 154.8 125 ",fill:!1},Hostile:{type:"path",d:"M 70.4 142.4 C 74.8 137 66.8 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 133.3 125 125.7 136.6 129.7 142.1 ",fill:!1}}[T],i["GR.M2.PACK ANIMAL"]={type:"path",d:"m 84,140 9,-15 7,15 7,-15 9,15",fill:!1},i["GR.M2.PATIENT EVACUATION COORDINATION"]=r("PEC"),i["GR.M2.PREVENTIVE MAINTENANCE"]=r("PM"),i["GR.M2.PSYCHOLOGICAL"]={type:"text",stroke:!1,x:115,y:133,fontsize:25,text:"P"},i["GR.M2.RADIO RELAY LINE OF SIGHT"]=[{type:"circle",cx:100,cy:132,r:11,fill:!1},{type:"path",d:"M 90.8 128.2 C 90.3 129.3 90 130.6 90 132 C 90 133.4 90.3 134.7 90.8 135.8 L 100 132 L 90.8 128.2 z M 100 132 L 109.3 135.8 C 109.7 134.7 110 133.4 110 132 C 110 130.6 109.7 129.3 109.3 128.2 L 100 132 z"}],i["GR.M2.RAILROAD"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:125,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],i["GR.M2.TRACTOR TRAILER"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],i["GR.M2.RECOVERY (UNMANNED SYSTEMS)"]={type:"path",d:"m 70,125 c0,20 60,20 60,0",fill:!1},i["GR.M2.RECOVERY (MAINTENANCE)"]={type:"path",fill:!1,d:"M75,125 c8,0 8,16 0,16 m8,-8 l35,0 m8,-8 c-8,0 -8,16 0,16"},i["GR.M2.REFUEL"]=r("K"),i["GR.M2.RESCUE COORDINATION CENTRE"]=r("RCC"),i["GR.M2.RIVERINE"]={type:"path",d:"m 80,125 c 0,10 40,10 40,0 z",fill:!1},i["GR.M2.SINGLE CHANNEL"]=r("SC"),i["GR.M2.SKI"]={type:"path",d:"m 95,145 -9,-8 m 28,0 -9,8 m -15,-24 20,20 m 0,-20 -20,20",fill:!1},i["GR.M2.SHORT RANGE"]=r("SR"),i["GR.M2.STRATEGIC"]=r("STR"),i["GR.M2.STRATEGIC MISSILE"]=r("S"),i["GR.M2.SUPPORT"]=r("SPT"),i["GR.M2.TACTICAL"]=r("TAC"),i["GR.M2.TACTICAL MISSILE"]=r("T"),i["GR.M2.TARGET ACQUISITION"]=r("TA"),i["GR.M2.TOWED"]=[{type:"path",d:"M70,120 l60,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:120,r:5},{type:"circle",fill:!1,cx:135,cy:120,r:5}],i["GR.M2.TROOP"]=r("T"),i["GR.M2.TRACKED"]={type:"path",d:"M 70,120 l 60,0 c10,0 10,10 0,10 l -60,0 c-10,0 -10,-10 0,-10",fill:!1},i["GR.M2.TRUCK"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],i["GR.M2.UTILITY"]=r("U"),i["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]={type:"text",stroke:!1,x:100,y:135,fontsize:20,text:"VSTOL"},i["GR.M2.VETERINARY"]={type:"text",stroke:!1,x:115,y:133,fontsize:25,text:"V"},i["GR.M2.WHEELED"]=[{type:"circle",cx:70,cy:125,r:5,fill:!1},{type:"circle",cx:100,cy:125,r:5,fill:!1},{type:"circle",cx:130,cy:125,r:5,fill:!1}],i["GR.M2.WHEELED LIMITED"]=[{type:"circle",cx:70,cy:125,r:5,fill:!1},{type:"circle",cx:130,cy:125,r:5,fill:!1}],i["GR.M2.WO-1"]=r("WO-1"),i["GR.M2.WO-2"]=r("WO-2"),i["GR.M2.WO-3"]=r("WO-3"),i["GR.M2.WO-4"]=r("WO-4"),i["GR.M2.WO-5"]=r("WO-5"),i["GR.EQ.SHORT RANGE"]={type:"path",d:"m 85,100 30,0",fill:!1},i["GR.EQ.INTERMEDIATE RANGE"]={type:"path",d:"m 85,105 30,0 m -30,-10 30,0",fill:!1},i["GR.EQ.LONG RANGE"]={type:"path",d:"m 85,110 30,0 m -30,-20 30,0 m -30,10 30,0",fill:!1},i["GR.EQ.WEAPON"]={type:"path",d:"m 100,60 0,80",fill:!1},i["GR.EQ.RIFLE"]={type:"path",d:"m 100,60 0,80 M 85,75 100,60 115,75",fill:!1},i["GR.EQ.RIFLE DISMOUNTED1"]={type:"path",d:"m 90,90 10,-10 10,10 m -10,-10 0,40",fill:!1},i["GR.EQ.MACHINE GUN"]={type:"path",d:"m 100,60 0,80 M 85,75 100,60 115,75 M 80,140 120,140",fill:!1},i["GR.EQ.GRENADE LAUNCHER"]=[i["GR.EQ.RIFLE"],{type:"circle",cx:100,cy:90,r:15,fill:!1}],i["GR.EQ.FLAME THROWER"]={type:"path",fill:!1,d:"m 90,135 0,-70 c 0,-15 20,-15 20,0"},i["GR.EQ.AIR DEFENCE GUN"]=[{type:"path",d:"m 85,140 30,0 c 0,-20 -30,-20 -30,0 z m 15,-80 0,65 m 15,-45 0,40 m -30,-40 0,40",fill:!1}],R||i["GR.EQ.AIR DEFENCE GUN"].push({type:"path",d:"M 85,75 100,60 115,75",fill:!1}),i["GR.EQ.ANTITANK GUN"]={type:"path",d:"m 85,140 15,-15 15,15 m -15,-80 0,65 m -15,-45 0,40 m 30,-40 0,40",fill:!1},i["GR.EQ.DIRECT FIRE GUN"]={type:"path",d:"m 100,60 0,80 m 15,-60 0,40 m -30,-40 0,40",fill:!1},i["GR.EQ.RECOILLESS GUN"]={type:"path",d:"m 85,75 15,-15 15,15 m 0,5 0,40 m -30,-40 0,40 m 15,-60 0,80",fill:!1},i["GR.EQ.HOWITZER"]=[{type:"circle",cx:100,cy:130,r:10,fill:!1},{type:"path",d:"m 115,80 0,40 m -30,-40 0,40 m 15,-60 0,60",fill:!1}],R||i["GR.EQ.HOWITZER"].push({type:"path",d:"M 85,75 100,60 115,75",fill:!1}),i["GR.EQ.HOWITZER TRACKED"]={type:"path",d:"M 70,120 l 60,0 c10,0 10,10 0,10 l -60,0 c-10,0 -10,-10 0,-10",fill:!1},i["GR.EQ.MISSILE LAUNCHER"]={type:"path",d:"m 100,140 0,-80 m -15,80 0,-65 c 0,-20 30,-20 30,0 l 0,65",fill:!1},i["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]={type:"path",d:"m 85,140 30,0 c 0,-20 -30,-20 -30,0 z m 15,-15 0,-65 m -15,80 0,-65 c 0,-20 30,-20 30,0 l 0,65",fill:!1},i["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"R"},i["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]=[{type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"E"},{type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"R"}],i["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"]={type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"T"},i["GR.EQ.ANTITANK MISSILE LAUNCHER"]={type:"path",d:"m 85,140 15,-15 15,15 M 85,120 85,75 c 0,-20 30,-20 30,0 l 0,45 m -15,5 0,-65",fill:!1},i["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]=[i["GR.EQ.MISSILE LAUNCHER"]],R&&i["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"].push({type:"path",d:"m 85,140 30,0",fill:!1}),i["GR.EQ.MORTAR"]=[{type:"path",d:"m 100,60 0,60 M 85,75 100,60 115,75",fill:!1},{type:"circle",cx:100,cy:130,r:10,fill:!1}],i["GR.EQ.SINGLE ROCKET LAUNCHER"]={type:"path",d:"m 85,75 15,-15 15,15 m -15,-5 0,70 M 85,85 100,70 115,85",fill:!1},i["GR.EQ.MULTIPLE ROCKET LAUNCHER"]={type:"path",d:"m 115,90 0,40 m -30,-40 0,40 m 0,-55 15,-15 15,15 m -15,-5 0,70 M 85,85 100,70 115,85",fill:!1},i["GR.EQ.ANTITANK ROCKET LAUNCHER"]={type:"path",d:"m 85,140 15,-15 15,15 M 85,85 100,70 115,85 m -15,-15 0,55 M 85,75 100,60 115,75",fill:!1},i["GR.EQ.NON-LETHAL WEAPON"]={type:"path",d:"m 100,60 0,80 M 80,60 l40,0",fill:!1},i["GR.EQ.NON-LETHAL GRENADE LAUNCHER"]=[i["GR.EQ.NON-LETHAL WEAPON"],{type:"circle",cx:100,cy:90,r:15,fill:!1}],i["GR.EQ.TASER"]=[i["GR.EQ.NON-LETHAL WEAPON"],a("Z")],i["GR.EQ.WATER CANNON"]=[i["GR.EQ.NON-LETHAL WEAPON"],a("W")],i["GR.EQ.LIMITED CROSS-COUNTRY"]=[{type:"path",d:"m 70,130 60,0",fill:!1},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],i["GR.EQ.CROSS-COUNTRY"]=[{type:"path",d:"m 70,130 60,0",fill:!1},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:100,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],i["GR.EQ.ARMOURED FIGHTING VEHICLE"]={type:"path",d:"m 70,100 30,-30 30,30 -30,30 z m 60,-30 0,60 m -60,-60 0,60 0,0",fill:!1},i["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]=[i["GR.EQ.ARMOURED FIGHTING VEHICLE"]],N?i["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"].push({type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"C2"}):i["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"].push({type:"path",d:"m 80,90 20,15 0,-10 20,15",fill:!1}),i["GR.EQ.ARMOURED PERSONNEL CARRIER"]={type:"path",fill:!1,d:"m 70,80 30,-10 30,10 0,0 m -60,50 60,0 m 0,-60 0,60 m -60,-60 0,60 0,0"},i["GR.EQ.ARMOURED PERSONNEL CARRIER COMBAT SERVICE SUPPORT VEHICLE"]=[i["GR.EQ.ARMOURED PERSONNEL CARRIER"],{type:"path",d:"m 70,120 60,0",fill:!1}],i["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]={type:"path",fill:!1,d:"M 130,80 70,130"},i["GR.EQ.COMBAT SERVICE SUPPORT VEHICLE"]={type:"path",fill:!1,d:"M 70,120 130,120"},i["GR.EQ.ARMOURED MEDICAL PERSONNEL CARRIER"]={type:"path",fill:!1,d:"m 70,100 60,0 m -30,-30 0,60"},i["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]=[{type:"path",d:"m 60,120 80,0 M 120,80 c 25,0.2 25,40 0,40 l -40,0 C 55,120 55,80 80,80 Z",fill:!1},i["GR.M2.WHEELED LIMITED"]],i["GR.EQ.ARMOURED VEHICLE"]=a("A"),i["GR.EQ.ARMORED CARRIER WITH VOLCANO"]=a("V"),i["GR.EQ.TANK"]={type:"path",fill:!1,d:"m 70,80 60,0 m -60,40 60,0 m -60,-50 0,60 0,0 m 60,-60 0,60"},i["GR.EQ.ASSAULT BREACHER VEHICLE (ABV) WITH COMBAT DOZER BLADE"]={type:"path",fill:!1,d:"m 100,95 30,25 m -30,-60 0,35 -30,25 m 10,-60 40,0 m -50,20 60,0 m -60,40 60,0 m -60,-50 0,60 0,0 m 60,-60 0,60"},i["GR.EQ.LIGHT TANK"]={type:"path",fill:!1,d:"m 100,80 0,40"},i["GR.EQ.MEDIUM TANK"]={type:"path",fill:!1,d:"m 105,80 0,40 m -10,-40 0,40"},i["GR.EQ.HEAVY TANK"]={type:"path",fill:!1,d:"m 110,80 0,40 m -20,-40 0,40 m 10,-40 0,40"},i["GR.EQ.TANK RECOVERY VEHICLE"]={type:"path",fill:!1,d:"m 85,100 30,0 m 10,-10 c -13.1,0 -12.4,20 0,20 M 75,90 c 12.7,0.3 12.7,20.3 0,20"},i["GR.EQ.BRIDGE"]={type:"path",d:"m 115,75 -10,10 0,30 10,10 m -30,-50 10,10 0,30 -10,10 m -15,-55 60,0 0,60 -60,0 0,-60",fill:!1},i["GR.EQ.FIXED BRIDGE"]={type:"path",d:"M 100,70 100,130",fill:!1},i["GR.EQ.FOLDING GIRDER BRIDGE"]={type:"path",d:"M 110, 80 90,80 90,120 110,120",fill:!1},i["GR.EQ.HOLLOW DECK BRIDGE"]={type:"path",d:"M 110, 80 90,80 90,120 110,120 z",fill:!1},i["GR.EQ.DRILL"]=i["GR.IC.DRILLING"],i["GR.EQ.DOZER"]={type:"path",d:"m 90,60 20,0 m -10,0 0,20 m -30,0 60,0 m -60,-10 0,60 0,0 m 60,-60 0,60 m -60,-10 60,0",fill:!1},i["GR.EQ.DOZER ARMORED"]={type:"path",d:"m 70,130 60,0 m -30,-70 0,10 m -30,10 30,-10 30,10 m 0,-10 0,60 m -60,-60 0,60 0,0 m 20,-70 20,0",fill:!1},i["GR.EQ.EARTHMOVER"]={type:"path",d:"m 100,60 0,20 m -25,-15 5,-5 40,0 5,5 m -55,15 60,0 m -60,40 60,0 m 0,-50 0,60 m -60,-60 0,60 0,0",fill:!1},i["GR.EQ.MULTIFUNCTIONAL EARTHMOVER/DIGGER"]=[i["GR.EQ.EARTHMOVER"],a("MF")],i["GR.EQ.MINE CLEARING EQUIPMENT"]={type:"path",d:"m 100,80 0,15 -30,25 60,0 -30,-25",fill:!1},i["GR.EQ.MINE LAYING VEHICLE"]=[{type:"path",d:"m 90,85 20,30 m 0,-30 -20,30 m 10,-30 0,30",fill:!1},{type:"circle",cx:100,cy:100,r:10}],i["GR.EQ.MINE SCATTERABLE"]=[a("S"),{type:"circle",cx:85,cy:115,r:5,fill:!1},{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"circle",cx:115,cy:115,r:5,fill:!1}],i["GR.EQ.UTILITY VEHICLE"]={type:"path",fill:!1,d:"m 70,65 c 0,15 60,15 60,0 l 0,65 -60,0 z"},i["GR.EQ.UTILITY VEHICLE BACKHOE"]=[{type:"path",fill:!1,d:"M 130,130 100,80 75,95 75,95"},{type:"path",d:"M 75,105 85,95 75,95 z"}],i["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]={type:"path",fill:!1,d:"m 75,100 c 15,15 35,15 50,0 z"},i["GR.EQ.UTILITY VEHICLE LIGHT"]={type:"path",fill:!1,d:"M 100,78.3 100,130"},i["GR.EQ.UTILITY VEHICLE MEDIUM"]={type:"path",fill:!1,d:"m 105,130 0,-52 M 95,130 l0,-52"},i["GR.EQ.UTILITY VEHICLE HEAVY"]={type:"path",fill:!1,d:"m 110,130 0,-53 m -20,50 0,-53 m 10,1.3 0,52"},i["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]={type:"path",fill:!1,d:"m 130,130 -40,-40 0,25 c 0,5 -10,5 -10,0"},i["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]={type:"path",fill:!1,d:"m 105,115 10,-10"},i["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]={type:"path",fill:!1,d:"m 120,110 -10,10 m -10,-10 10,-10 m -5,15 10,-10"},i["GR.EQ.MEDICAL VEHICLE"]={type:"path",fill:!1,d:"m 70,100 l 60,0 M 100,78.3 100,130"},i["GR.EQ.MEDICAL EVACUATION"]={type:"path",d:"m 95,85 10,0 0,10 10,0 0,10 -10,0 0,10 -10,0 0,-10 -10,0 0,-10 10,0 z"},i["GR.EQ.MOBILE EMERGENCY PHYSICIAN"]={type:"path",fill:!1,d:"m 70,100 l 60,0 M 100,78.3 100,130 M 85,85 115,85"},i["GR.EQ.BUS"]=[i["GR.EQ.UTILITY VEHICLE"],a("B")],i["GR.EQ.SEMI-TRAILER TRUCK"]=[i["GR.EQ.UTILITY VEHICLE"],{type:"path",fill:!1,d:"m 140,90 0,20 m -10,-10 10,0"},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:85,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],i["GR.EQ.WATER VEHICLE"]=[i["GR.EQ.UTILITY VEHICLE"],{type:"path",fill:!1,d:"m 70,95 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10"},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],i["GR.EQ.TRAIN LOCOMOTIVE"]={type:"path",fill:!1,d:"m 70,70 0,60 60,0 0,-30 -30,0 0,-30 z"},i["GR.EQ.RAILCAR"]=[i["GR.EQ.UTILITY VEHICLE"],{type:"circle",fill:!1,cx:75,cy:135,r:5},{type:"circle",fill:!1,cx:85,cy:135,r:5},{type:"circle",fill:!1,cx:115,cy:135,r:5},{type:"circle",fill:!1,cx:125,cy:135,r:5}],i["GR.EQ.CBRN EQUIPMENT"]=[{type:"path",d:"M80,140 c0,-20 10,-60 50,-63 m-10,63 c0,-20 -10,-60 -50,-63 ",fill:!1},{type:"circle",cx:70,cy:85,r:8},{type:"circle",cx:130,cy:85,r:8}],i["GR.EQ.COMPUTER SYSTEM"]={type:"path",d:"m 100,132 0,-10 -35,0 0,-50 70,0 0,50 -35,0 m -25,10 50,0",fill:!1},i["GR.EQ.COMMAND LAUNCH EQUIPMENT (CLE)"]=a("CLE"),i["GR.EQ.GENERATOR SET"]=a("G"),i["GR.EQ.GROUND-BASED MIDCOURSE DEFENSE (GMD) FIRE CONTROL (GFC) CENTER"]=a("GFC"),i["GR.EQ.IN-FLIGHT INTERCEPTOR COMMUNICATIONS SYSTEM (IFICS) DATA TERMINAL (IDT)"]={type:"path",fill:!1,d:"m 80,82.4 45,-2 -4,37 m -6,-1 0,-35 -34,9 m 12,21 0,8 M 80,82.4 c 0,25 16,35 41,35"},i["GR.EQ.LASER"]={type:"path",fill:!1,d:"m 100,55 0,25 10,5 -20,5 20,5 -20,5 10,5 0,15 10,5 -20,5 20,5 -20,5 20,5 M 90,65 100,55 110,65"},i["GR.EQ.TENT"]={type:"path",fill:!1,d:"m 65,124.4 10,-37 25,-10 25,10 10,37 z"},i["GR.EQ.TENT CIVILIAN"]={type:"path",fill:!1,d:"m 75,120 10,-30 15,-10 15,10 10,30 z"},i["GR.EQ.TENT MILITARY"]={type:"path",d:"m 75,120 10,-30 15,-10 15,10 10,30 z"},i["GR.EQ.UNIT DEPLOYMENT SHIPMENTS"]=a("DPLY"),i["GR.EQ.CIVILIAN VEHICLE.LIGHT"]={type:"path",fill:!1,d:"m 100,125 0,-20"},i["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]={type:"path",fill:!1,d:"m 103,105 0,20 m -6,-20 0,20"},i["GR.EQ.CIVILIAN VEHICLE.HEAVY"]={type:"path",fill:!1,d:"m 106,105 0,20 m -12,-20 0,20 m 6,-20 0,20"},i["GR.EQ.CIVILIAN VEHICLE.TRAILER"]={type:"path",fill:!1,d:"m 140,105 0,20 m -10,-10 10,0"},i["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]=[{type:"path",fill:!!R&&G,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 5,0 0,-20 -20,0 0,-20 -20,0 0,20 -20,0 0,20 5,0 m 50,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z"},{type:"path",fill:!1,strokewidth:2,d:"m 95,90 0,15 10,0 0,-15 z"}],i["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]=[{type:"path",fill:!!R&&G,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 -20,0 -20,0 0,-20 -20,0 0,20 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 75,90 0,15 10,0 0,-15 z"}],i["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]=[{type:"path",fill:!!R&&G,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 0,-20 -20,0 -20,0 -20,0 0,20 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 115,90 0,15 10,0 0,-15 z m -20,0 0,15 10,0 0,-15 z m -20,0 0,15 10,0 0,-15 z"}],i["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]=[{type:"path",fill:!!R&&G,d:"m 90,125 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m -35,0 20,0 m 15,0 5,0 0,-20 0,-20 -20,0 -20,0 0,20 -20,0 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 95,90 0,15 10,0 0,-15 z"}],i["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]={type:"path",fill:!!R&&G,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 -60,0 0,20 5,0 m 15,-20 5,-15"},i["GR.EQ.PACK ANIMAL"]={type:"path",fill:!1,d:"m 70,125 15,-50 15,50 15,-50 15,50 "},i["GR.EQ.MISSILE SUPPORT"]=[{type:"text",stroke:!1,x:100,y:100,fontsize:20,text:"MSL"},{type:"text",stroke:!1,x:100,y:115,fontsize:20,text:"SPT"}],i["GR.EQ.MISSILE TRANSLOADER"]=[{type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MSL"},{type:"path",fill:!1,d:"m 75,70 50,0 m -25,10 c 0,-5 0,-10 0,-10"}],i["GR.EQ.MISSILE TRANSPORTER"]=[{type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MSL"},{type:"path",fill:!1,d:"m 55,85 90,0"}],i["GR.EQ.MISSILE CRANE/LOADING DEVICE"]=[{type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MSL"},{type:"path",fill:!1,d:"m 75,80 25,-20 c 0,0 0,15 0,15 l 5,0 0,-5"}],i["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]=[{type:"text",stroke:!1,x:90,y:110,fontsize:20,text:"MSL"},{type:"path",fill:!1,d:"m 120,115 0,-15 -10,-10 20,0 -10,10"}],i["GR.EQ.MISSILE WARHEAD TRANSPORTER"]=[{type:"text",stroke:!1,x:100,y:100,fontsize:20,text:"MSL"},{type:"text",stroke:!1,x:100,y:115,fontsize:20,text:"WHD"}],i["GR.EQ.LAND MINE"]=N?{type:"circle",cx:100,cy:100,r:22,fill:!1}:[{type:"path",fill:!1,d:"m 70,65 60,0 -30,65 z"},{type:"text",stroke:!1,x:100,y:90,fontfamily:"Arial",fontsize:30,text:"M"}],i["GR.EQ.ANTIPERSONNEL LAND MINE"]=[{type:"circle",cx:100,cy:100,r:22},{type:"path",d:"M117,82 l20,-18 -18,25z M83,82 l-20,-18 18,25z",stroke:!1}],i["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]=[{type:"circle",cx:100,cy:100,r:22,fill:!1},{type:"path",d:"M117,82 l20,-18 -18,25z M83,82 l-20,-18 18,25z",stroke:!1}],i["GR.EQ.ANTITANK MINE"]={type:"circle",cx:100,cy:100,r:22},i["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]=a("IED"),i["GR.EQ.LAND MINES"]=[{type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"M"},{type:"path",fill:!1,d:R?"m 135,70 -70,0 35,70 z":"m 65,130 70,0 -35,-70 z"}],i["GR.EQ.SENSOR"]={type:"path",d:"m 100,60 c 0,15 25,40 40,40 -15,0 -40,25 -40,40 0,-15 -25,-40 -40,-40 15,0 40,-25 40,-40 z"},i["GR.EQ.SENSOR EMPLACED"]=[s._scale(.75,i["GR.EQ.SENSOR"]),{type:"path",fill:!1,d:"m 70,75 10,-15 10,15 10,-15 10,15 10,-15 10,15"}],i["GR.EQ.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},i["GR.EQ.ANTENNAE"]=[],i["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]={type:"path",fill:!!R&&G,stroke:o,d:"m 110,95 10,0 m -10,10 10,0 m -10,10 10,0 m -10,-30 10,0 m -10,-5 -10,10 -30,0 0,20 30,0 10,10 z"},i["GR.IN.IC.ELDER CARE"]={type:"path",d:"m 120.1,119.1 c 0,-6.3 2.3,-8.2 3.9,-12.6 1,-2.6 1.6,-3.3 1.8,-6.5 0.2,-2.4 0.9,-4.7 0.9,-7.2 v -2.6 c 0,-2.6 -2.2,-8.9 -3.3,-10.5 -1.3,-2 -4.8,-5.4 -6.7,-6.9 -2.2,-1.8 -5.4,-4.6 -8.2,-5.6 -1.6,-0.5 -9.8,-2.4 -11.4,-2.3 l -5.7,0.6 v 0.8 c 0,0.8 2,2.7 2.4,3.3 0,3.3 0.8,6.8 -1.3,8.4 -2.2,1.6 -2.8,3.4 -3.8,6.3 -0.4,1 -0.9,3.1 -1,4 -0.2,1 -0.2,4 -0.4,4.6 -1.1,2.4 -2.6,4.2 -3.8,6.4 l -5.1,0.5 c -2.1,3.2 -4.6,4.1 -4.6,9.6 v 26.4 c 0.6,0.2 0.4,0.2 0.9,0.2 0.5,0 0.3,-0.1 0.9,-0.2 v -27.5 c 0,-0.7 0.8,-3 1.1,-3.5 0.4,0.2 0.8,0.6 1.3,0.6 0.3,0 1.1,-0.3 1.3,-0.4 l 2.6,0.9 0.8,-0.6 0.6,2.5 c 0.4,0.3 0.4,0.5 0.8,0.5 h 0.4 c 0.5,0 0.6,-0.2 0.6,-0.6 v -0.4 c 0,-1 -1.2,-3 -1.5,-3.7 1.2,-2.5 6.3,-2.6 8.2,-5.8 0.9,-1.6 1.8,-3 2.6,-4.5 0.4,-0.9 2.3,-4.1 2.4,-4.4 h 4.4 c 2.3,0 2.1,2.5 2.6,4.2 0.6,2 2,2 2,4.6 0,2.8 -2.9,7 -4,9 -0.3,0.7 -3.9,8.8 -3.9,8.9 v 2 c 0,3 2.6,9.1 2.6,11.2 v 2.2 c -1.2,0.3 -6.8,2.4 -6.8,3.5 0,0.3 0.4,0.6 0.9,0.6 h 6.8 c 2.3,0 4.5,-1 6.6,-1.1 v -3 c 0,-0.6 -1.1,-2.2 -1.1,-3.7 -0.9,-1.3 -1.8,-6 -1.8,-8.2 0,-3.2 1.2,-5.4 2.5,-7.4 2.5,-4 0.4,-2.3 4.6,-5.1 l 1.8,1.7 c -1,1.8 -2.3,3.7 -2.3,6.4 v 5.9 h 0.4 v 0.6 c 0,0.9 5,9 5.7,10.3 -1.5,2.3 -6.7,1.6 -6.8,5 h 7.5 c 1.2,0 3.3,-1 4.5,-1.4 1.6,-0.5 2.9,-1.1 2.9,-3 0,-0.7 -2.9,-4.6 -3.6,-5.7 -0.3,-0.4 -2.4,-6 -2.4,-6.6 v -0.4 z m -45.3,-47.9 v 0.6 c 0,4.3 3.7,7.9 8.1,7.9 h 0.2 c 3.7,0 7.7,-3.6 7.7,-7 v -2.2 c 0,-3.2 -3.9,-6.8 -7.5,-6.8 h -1.2 c -3.4,0 -7.3,4 -7.3,7.5 z",stroke:!1},i["GR.IN.IC.RAW MATERIAL PRODUCTION/STORAGE"]=[{type:"text",stroke:!1,x:100,y:90,fontsize:30,text:"PS"},{type:"text",stroke:!1,x:100,y:120,fontsize:30,text:"RM"}],i["GR.IN.IC.MINE"]={type:"path",d:"m 105,85 10,10 5,-5 c -5,-5 -10,-5 -15,-5 z M 95,85 85,95 80,90 c 5,-5 10,-5 15,-5 z m -5,5 30,30 m -40,0 30,-30"},i["GR.IN.IC.PROCESSING FACILITY"]=[{type:"text",stroke:!1,x:100,y:90,fontsize:30,text:"PROC"},{type:"text",stroke:!1,x:100,y:120,fontsize:30,text:"FAC"}],i["GR.IN.IC.UTILITY FACILITY"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"UTIL"},i["GR.IN.IC.RESEARCH"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"R&D"},i["GR.IN.IC.TELECOMMUNICATIONS"]={type:"path",d:"m 95,80 10,20 -10,0 10,20",fill:!1},i["GR.IN.IC.ELECTRIC POWER"]={type:"path",d:"m 100,60.5 c -16.4,0 -29.6,13.2 -29.6,29.6 0,12.8 8.3,23.9 19.7,27.8 l 0,19.7 c 3.2,1.2 6.3,1.8 9.9,1.8 3.6,0 6.7,-0.6 9.9,-1.8 l 0,-19.8 c 11.5,-3.9 19.8,-15 19.7,-27.8 0,-16.4 -13.2,-29.6 -29.6,-29.6 z",fill:!1},i["GR.IN.IC.ELECTRIC POWER NUCLEAR"]={type:"text",stroke:!1,x:100,y:105,fontsize:40,text:"N"},i["GR.IN.IC.ELECTRIC POWER DAM"]={type:"text",stroke:!1,x:100,y:105,fontsize:40,text:"H"},i["GR.IN.IC.ELECTRIC POWER FOSSIL"]={type:"text",stroke:!1,x:100,y:105,fontsize:40,text:"F"},i["GR.IN.IC.ATOMIC ENERGY"]={type:"path",d:R?"M 90.4,119 C 84.2,115 80,109 80,101 l 20,0 -9.6,18 z m 19.6,0 -10,-18 20,0 c 0,8 -4,14 -10,18 z M 100,101 89.7,83.8 c 3,-2 6.5,-3 10.3,-3 4,0 7,1 10,3 L 100,101 Z":"M 89.9,82.5 110,82.7 89.7,117.1 80,99.9 120.1,100 110,117.3 z",fill:!1},i["GR.IN.IC.ATOMIC ENERGY WEAPONS GRADE"]={type:"path",d:R?"M 90.4,119 C 84.2,115 80,109 80,101 l 20,0 -9.6,18 z m 19.6,0 -10,-18 20,0 c 0,8 -4,14 -10,18 z M 100,101 89.7,83.8 c 3,-2 6.5,-3 10.3,-3 4,0 7,1 10,3 L 100,101 Z":"M 89.9,82.5 110,82.7 89.7,117.1 80,99.9 120.1,100 110,117.3 z"},i["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]={type:"path",stroke:!1,d:"m 95.1,109.3 c 0,0 -20.8,4.9 -30.1,6.7 -2.2,0.4 -5.7,0.2 -6.5,-2 -0.4,-1.1 3.3,-6.6 6.5,-7.3 8.7,-1.9 25.7,-5.5 25.7,-5.5 l 3.1,-16.1 4,-0.8 0.3,15.9 25.6,-5.8 6.5,-13.2 5.3,-1.4 -3.3,16.1 14,4.8 -4.3,1.2 -13.7,-2.8 -23.6,6.7 31.6,11.8 -5.5,2.5 z"},i["GR.IN.IC.BRIDGE"]={type:"path",d:"m 70,115 10,-10 40,0 10,10 m -60,-30 10,10 40,0 10,-10",fill:!1},i["GR.IN.IC.BASE"]={type:"path",d:"m 75,85 50,30 m -50,0 50,-30",fill:!1},i["GR.IN.IC.SEA SURFACE INSTALLATION, OIL RIG/PLATFORM"]=[{type:"path",d:"m 85,105 0,-40 m 25,40 0,15 m -35,0 0,-15 50,0 0,15",fill:!1},{type:"path",d:"m 85,90 15,0 0,15 -15,0 0,-15"}],i["GR.IN.IC.MILITARY/CIVILIAN.MATERIEL"]=a("MAT"),i["GR.IN.IC.MILITARY/CIVILIAN.PRINTED MEDIA"]=[{type:"circle",cx:100,cy:90,r:10,fill:!1},{type:"circle",cx:100,cy:110,r:10,fill:!1},{type:"path",d:"m 65,100 75,0",fill:!1}],i["GR.IN.IC.INFRASTRUCTURE.BANKING FINANCE AND INSURANCE  INFRASTRUCTURE.ECONOMIC INFRASTRUCTURE ASSET"]=a("ECON"),i["GR.IN.IC.INFRASTRUCTURE.TELECOMMUNICATIONS INFRASTRUCTURE.TELECOMMUNICATIONS"]={type:"path",d:"m 90,105 20,0 0,0 m -25,15 15,-30 15,30 m -55,-40 25,10 0,-10 15,10 15,-10 0,10 25,-10",fill:!1},i["GR.IN.M1.RADIOLOGICAL"]=l("R"),i["GR.IN.M1.COAL"]=l("CO"),i["GR.IN.M1.GEOTHERMAL"]=l("GT"),i["GR.IN.M1.HYDROELECTRIC"]=l("HY"),i["GR.IN.M1.NATURAL GAS"]=l("NG"),i["GR.IN.M1.PETROLEUM"]={type:"path",d:"m 100,75 0,-10 -6,-10 12,0 -6,10",fill:!1},i["GR.IN.M1.CIVILIAN"]=l("CIV"),i["GR.IN.M1.CIVILIAN TELEPHONE"]=l("T"),i["GR.IN.M1.CIVILIAN TELEVISION"]=l("TV"),i["GR.IN.M2.CHEMICAL WARFARE PRODUCTION"]=r("C"),i["GR.IN.M2.NUCLEAR WARFARE PRODUCTION"]=r("N"),i["GR.IN.M2.RADIOLOGICAL WARFARE PRODUCTION"]=r("R"),i["GR.IN.M2.ATOMIC ENERGY REACTOR"]=r("A"),i["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]=r("P"),i["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]=r("S"),i["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]=r("B"),i["GR.IN.M2.SHIP CONSTRUCTION"]=r("YRD"),i["GR.IN.M2.WEAPONS GRADE PRODUCTION"]=r("W"),i["SOF.IC.UNDERWATER DEMOLITION TEAM"]={type:"text",stroke:!1,x:100,y:110,fontsize:32,text:"UDT"},i["SOF.M2.ATTACK"]=r("A"),i["SOF.M2.REFUEL"]=r("K"),i["SOF.M2.UTILITY"]=r("U"),i["SOF.M2.VSTOL"]={type:"text",stroke:!1,x:100,y:135,fontsize:20,text:"VSTOL"},i["SOF.M2.COMBAT SEARCH AND RESCUE"]=r(R?"CSAR":"H"),i["ST.IC.ARREST"]={type:"path",d:"m 92.5,100 15,0 m -2.5,-10 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -5,5 0,20 m 20,-15 c 0,11 -9,20 -20,20 -11,0 -20,-9 -20,-20 0,-11 9,-20 20,-20 11,0 20,9 20,20 z",fill:!1},i["ST.IC.ARSON/FIRE"]=R?[{type:"path",d:"m 84.6,101.6 c 1.3,23.1 31,23.2 30.7,-1.9 -1.5,2.1 -4.6,6.5 -8.1,7.3 1.9,-2.4 2.6,-8.5 2.4,-12.9 -1.7,3.4 -4,7.9 -7,7.8 1.7,-4.3 2.7,-9.4 -0.5,-13.7 -0.2,3 0.8,7.1 -1.9,7 -2.7,-0.1 -2.9,-4.4 -1.1,-10.8 -4,4.1 -6.2,9.8 -3.8,17.5 -1.9,-0.2 -4.4,-1.9 -7,-7.8 -1.5,4.9 1.2,9.6 3.2,13.7 -2.4,-1.1 -6,-3 -7,-6.2 z",stroke:!1},{type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"ASN"}]:{type:"text",stroke:!1,x:100,y:110,fontsize:35,text:"FIRE"},i["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]={type:"path",d:"m 127,127 5,5 m -15,-15 5,5 m -15,-15 5,5 m -15,-15 5,5 m -15,-15 5,5 m -15,-15 5,5 m -15,-15 5,5",fill:!1},i["ST.IC.BLACK LIST LOCATION"]=a("BLK"),i["ST.IC.BLACK MARKETING"]=[{type:"text",stroke:!1,x:100,y:95,fontsize:30,text:"BLK"},{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"MKT"}],i["ST.IC.BOMB"]=a("BOMB"),i["ST.IC.BOOBY TRAP"]={type:"path",d:"m 85,105 15,-25 15,25 m -35,5 c 0,-10 40,-10 40,0 0,10 -40,10 -40,0 z",fill:!1},i["ST.IC.COMPOSITE LOSS"]={type:"path",d:"m 100,85 0,30 m -35,-15 45,0 m 20,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",fill:!1},i["ST.IC.DEMONSTRATION"]=a("MASS"),i["ST.IC.DRIVE-BY SHOOTING"]={type:"path",d:"m 95,85 5,-5 5,5 m -5,-5 0,30 m -15,0 30,0 m 5,5 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -30,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z",fill:!1},i["ST.IC.DRUG RELATED ACTIVITIES"]=a("DRUG"),i["ST.IC.EXPLOSION"]={type:"path",d:"m 110,55 5,20 15,-10 0,15 15,5 -15,10 15,10 -15,5 5,15 -20,-5 -5,20 -10,-15 -10,20 -5,-25 -20,10 5,-15 L 55,105 70,95 60,85 70,80 70,65 85,75 90,55 100,70 z",fill:!1},i["ST.IC.EXTORTION"]={type:"text",stroke:!1,x:100,y:130,fontsize:80,text:"$"},i["ST.IC.FOOD DISTRIBUTION"]=[{type:"path",d:"m 105,85 c -5,10 -5,20 0,30 m 0,-30 c -20,0 -20,30 0,30",fill:!1},{Unknown:{type:"path",d:"M35,120 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,120 l150,0 ",fill:!1},Neutral:{type:"path",d:"M45,120 l110,0 ",fill:!1},Hostile:{type:"path",d:"M50,120 l100,0 ",fill:!1}}[T]],i["ST.IC.GRAFFITI"]={type:"path",d:"m 110,80 c -10,0 -10,10 0,10 10,0 10,10 0,10 -10,0 -10,10 0,10 10,0 10,10 0,10 M 90,80 c -10,0 -10,10 0,10 10,0 10,10 0,10 -10,0 -10,10 0,10 10,0 10,10 0,10",fill:!1},i["ST.IC.GROUP"]={type:"path",d:"m 133,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m -52,-12.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m 23,-7.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},i["ST.IC.HIJACKING (AIRPLANE)"]={type:"path",fill:!!R&&G,d:"m 70,95 0,10 65,0 0,-10 z m 55,10 0,10 5,0 0,-10 z m 0,-10 0,-10 5,0 0,10 z m -45,10 0,15 10,0 0,-15 z m 0,-10 0,-15 10,0 0,15 z"},i["ST.IC.HIJACKING (BOAT)"]={type:"path",fill:R?G:!C&&G,d:"m 105,80 0,20 20,0 z m -5,25 0,-25 m -30,25 10,15 40,0 10,-15 z"},i["ST.IC.GRAY LIST LOCATION"]=a("GRAY"),i["ST.IC.IED"]=a("IED"),i["ST.IC.INDIVIDUAL"]={type:"path",d:"m 108,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},i["ST.IC.INTERNAL SECURITY FORCE"]=a("ISF"),i["ST.IC.KILLING VICTIM"]=[{type:"path",d:"m 108,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},{Unknown:{type:"path",fill:!1,d:"M50,65 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 143,130"}}[T]],i["ST.IC.KILLING VICTIMS"]=[{type:"path",d:"m 133,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m -52,-12.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m 23,-7.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},{Unknown:{type:"path",fill:!1,d:"M50,65 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 143,130"}}[T]],i["ST.IC.KNOWN INSURGENT VEHICLE"]={type:"path",d:"m 65,95 70,0 m 0,10 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -50,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",fill:!1},i["ST.IC.MASS GRAVE LOCATION"]={type:"path",d:"m 77.5,90 10,0 m -5,-5 0,15 m 7.5,-20 0,30 -15,0 0,-30 z m 22.5,10 10,0 m -5,-5 0,15 m -7.5,-20 0,30 15,0 0,-30 z m -15,20 10,0 m -5,-5 0,20 m -7.5,-25 15,0 0,30 -15,0 z",fill:!1},i["ST.IC.MINE LAYING"]=[{type:"path",d:"m 60,85 80,0 0,30 -80,0 z",fill:!1},{type:"path",d:"m 135,100 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -25,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -25,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",stroke:!1}],i["ST.IC.PATROLLING"]={type:"path",d:"m 131,97 0,-14 5,0 c 4,0 4,7 0,7 l -5,0 m -71,15 15,10 M 60,105 75,95 m -15,10 40,0 -15,-15 40,0",fill:!1},i["ST.IC.POISONING"]={type:"path",d:"m 85,95 c 0,-20 30,-20 30,0 0,20 -30,20 -30,0 z m -15,10 60,15 m -60,0 60,-15",fill:!1},i["ST.IC.PSYCHOLOGICAL OPERATIONS"]={type:"path",fill:!!R&&G,stroke:o,d:"m 110,95 10,0 m -10,10 10,0 m -10,10 10,0 m -10,-30 10,0 m -10,-5 -10,10 -30,0 0,20 30,0 10,10 z"},i["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]=[i["ST.IC.PSYCHOLOGICAL OPERATIONS"],{Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 100,110 100,90 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T]],i["ST.IC.RIOT"]=a("RIOT"),i["ST.IC.SAFE HOUSE"]=a("SAFE"),i["ST.IC.SEARCHING"]={type:"path",d:"m 140,105 c -10,0 -5,0 -10,0 -15,0 -5,-15 -20,-15 -15,0 -5,20 -20,20 -15,0 -5,-20 -20,-20 -10,0 -10,10 -10,10 m 70,0 10,5 -10,5",fill:!1},i["ST.IC.SPY"]=a("SPY"),i["ST.IC.SNIPING"]=[{type:"path",d:"m 95,85 5,-5 5,5 m -5,-5 0,40",fill:!1},{type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"S"}],i["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]={type:"path",d:"m 115,100 c 0,-5 5,-10 10,-10 M 85,100 C 85,95 80,90 75,90 m 5,25 c -0.5,-29.5 40,-30 40,0 z",fill:!1},i["ST.IC.WHITE LIST LOCATION"]=a("WHT"),i["ST.IC.ROBBERY"]=a("ROB"),i["ST.IC.THEFT"]=a("THF"),i["ST.IC.BURGLARY"]=a("BUR"),i["ST.IC.SMUGGLING"]=a("SMGL"),i["ST.IC.SABOTAGE"]=a("SAB"),i["ST.IC.ILLEGAL DRUG OPERATION"]=a("DRUG"),i["ST.IC.SPY"]=a("SPY"),i["ST.IC.WARRANT SERVED"]=a("WNT"),i["ST.IC.POLLING PLACE/ELECTION"]=a("VOTE"),i["ST.IC.NATURAL EVENT"]=a("NAT"),i["ST.IC.GEOLOGIC"]=a("GEOL"),i["ST.IC.HYDRO-METEOROLOGICAL"]=a("HYDR"),i["ST.IC.INFESTATION"]=a("INFS"),i["ST.IC.GRENADE"]=a("G"),i["ST.IC.INCENDIARY"]=a("I"),i["ST.IC.MINE"]=a("M"),i["ST.IC.HOUSE"]={type:"path",fill:!!R&&G,d:"m 70,100 60,0 m -30,-20 -30,20 0,35 60,0 0,-35 -30,-20 z"},i["ST.IC.ROCK THROWING"]={type:"path",d:"m 90,60 25,25 M 70,65 95,90 M 60,80 80,100 m 45,-5 5,15 -5,15 -20,10 -20,-5 -5,-20 5,-5 10,0 5,-10 10,-5 15,5 z"},i["ST.M1.ACCIDENT"]=l("ACC"),i["ST.M1.ASSASSINATION"]=l("AS"),i["ST.M1.CIVILIAN"]=l("CIV"),i["ST.M1.COERCED/IMPRESSED"]=l("C"),i["ST.M1.COMBAT"]=l("CBT"),i["ST.M1.DEAD BODY"]=l("DB"),i["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]=l("DPRE"),i["ST.M1.DRUG"]=l("DRUG"),i["ST.M1.EVICTION"]=l("EV"),i["ST.M1.EXECUTION (WRONGFUL KILLING)"]=l("EX"),i["ST.M1.EXFILTRATION"]=l("EXFL"),i["ST.M1.FOREIGN FIGHTERS"]=l("FF"),i["ST.M1.GANG"]=l("GANG"),i["ST.M1.GOVERNMENT ORGANIZATION"]=l("GO"),i["ST.M1.HIJACKING/HIJACKED"]=l("H"),i["ST.M1.HOUSE-TO-HOUSE"]={type:"path",fill:!!R&&G,d:"m 110,65 -20,0 0,15 20,0 z m -10,-10 -10,10 20,0 z"},i["ST.M1.IED"]=l("IED"),i["ST.M1.INCIDENT"]=l("INC"),i["ST.M1.INFILTRATION"]=l("INFL"),i["ST.M1.KIDNAPPING"]=l("K"),i["ST.M1.LABRATORY"]=l("LAB"),i["ST.M1.LEADER"]=l("LDR"),i["ST.M1.LOOT"]=l("LOOT"),i["ST.M1.MEETING"]=l("MTG"),i["ST.M1.MURDER"]=l("MU"),i["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]=l("NGO"),i["ST.M1.OTHER"]=l("OTH"),i["ST.M1.PIRACY"]=l("PI"),i["ST.M1.PREMATURE"]=l("P"),i["ST.M1.RAID"]=l("RAID"),i["ST.M1.RAPE"]=l("RA"),i["ST.M1.RELIGIOUS"]=l("REL"),i["ST.M1.SPEAKER"]=l("SPK"),i["ST.M1.TARGETED"]=l("TGT"),i["ST.M1.TERRORIST"]=l("TER"),i["ST.M1.TRAFFICKING"]=l("TFK"),i["ST.M1.WILLING RECRUIT"]=l("WR"),i["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]=i["ST.M1.WILLING"]=l("W"),i["ST.M1.FALSE"]=l("FAL"),i["ST.M1.FIND"]=l("FND"),i["ST.M1.FOUND AND CLEARED"]=l("CLR"),i["ST.M1.HOAX (DECOY)"]={type:"path",d:"M 90,75 80,67.5 90,60 90,75 Z m 15,0 -10,-7.5 10,-7.5 0,15 z m 15,0 -10,-7.5 10,-7.5 0,15 z"},i["ST.M1.ATTEMPTED"]=l("ATT"),i["ST.M1.ACCIDENT"]=l("ACC"),i["ST.M1.INCIDENT"]=l("INC"),i["ST.M1.THEFT"]=l("THF"),i["ST.M1.PIRATE"]=[{type:"circle",cx:100,cy:60,r:7,fill:!1},{type:"path",fill:!1,d:"m 82.5,75 35,-15 m 0,15 -35,-15 m 3,7 5,10 m 27,-10 -10,10"}],i["ST.M2.LEADER OR LEADERSHIP"]=r("LDR"),i["ST.M2.RELIGIOUS"]=r("REL"),i["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]=[{type:"path",stroke:!1,d:"m 98.7,66.7 c -3.2,0.7 -6.3,3.7 -6.4,7 0.3,3.6 5.3,2.8 7,0.6 2,-1.2 1.7,-4.5 4.5,-3.7 2.6,-0.6 3.2,3.2 5.9,3.2 1.6,1.5 4.4,-0.6 5.4,1.2 0.7,1.1 1.5,2.2 2.2,3.3 -2,3.1 -1.3,7.9 1.9,10 3.5,1.1 4.8,-3.5 4.1,-6.2 -0.2,-3 -2.5,-5 -5.1,-5.4 -1.5,-1.9 -2.7,-3.4 -1.6,-5.6 -1,-3.3 -5.1,-4.5 -8.2,-4.3 -2.2,0.3 -2.9,2.6 -5.3,1.9 -1.9,0.4 -1.9,-2.8 -4.3,-2 z m 0.2,1.3 c 2.7,0.5 0.9,0.6 -0.6,1.3 -0.5,2.2 3.8,0.4 1.4,2.9 -0.9,1.9 -5.8,4.7 -5.9,1.1 0.1,-2.5 2.7,-4.8 5.1,-5.2 z m 10.3,0.1 c 2.4,-0.5 7.1,2.3 5.6,3.7 -0.8,-2.1 -3,0 -1.2,1.2 -1.7,0.9 -7.4,-1.6 -5.7,-2.4 2.5,0.8 2.8,-2.7 -0,-1.9 -1.4,0.2 1.1,-0.8 1.3,-0.6 z M 81.9,71.6 c -1.8,1.9 -3.6,3.9 -5.5,5.8 -7.5,-0.1 -14,6.2 -15.7,13.2 -0.6,4.2 0.5,8.5 2.8,12 0.7,3.9 -3.2,6.7 -3,10.7 -0.8,7.4 4.8,14.5 11.7,16.8 2.3,-0.4 1.3,1.3 1.4,2 1.5,-0.4 3,-0.8 4.6,-1.2 -0.2,1.5 -0.1,2.7 1.4,1.2 0.9,-0.3 2.3,-2.2 2.9,-1.5 0.2,2.2 1.2,0.1 2,-0.7 0.8,-1.2 1.6,-2.3 2.4,-0.5 1.2,-2.4 4.1,-7.2 -0.8,-7.3 -3.4,2.3 -7.5,4.6 -11.8,3.5 -6.3,-1.5 -10.9,-8.8 -8.2,-14.9 0.4,-3.9 6.8,-3.4 5,-8.2 -1.8,-2.6 -5.7,-2.9 -5.7,-7 -1.5,-7.3 5.6,-14.7 13,-13.7 4.7,0.5 7.4,4.9 10.8,7.6 1.9,1.9 4.1,5.1 5.9,1.4 2.8,-2 4.3,-4.7 1.8,-7.6 C 94.8,79.7 90.9,77.3 88,74.4 86.3,72.9 83.9,72.6 81.9,71.6 z m 3.3,3.8 c 1.6,1.1 2.9,2.1 0.3,3.3 -0.9,3.7 -5.1,-0.5 -1.5,-1.5 0.4,-0.6 0.9,-1.1 1.2,-1.8 z m 34.2,3.1 c 3,1.4 3.9,6.4 1.4,8.8 -2.9,0.1 -3.6,-4.3 -3.1,-6.6 0.1,-2.9 2.5,2.7 2.5,-0.7 -0.2,-0.5 -0.5,-1 -0.8,-1.4 z M 127.3,90.2 c -4.3,0.4 -8.8,-0 -13.1,1 -2.1,1.1 -5.7,1.5 -4.6,4.5 0.1,1.8 0.2,3.6 0.4,5.4 -4.9,4.9 -5.5,13.3 -2.2,19.2 2.4,4.3 7,7 11.8,7.8 3.3,4.9 7.3,-1.3 11.2,-1.7 5.5,-2.5 8.9,-8.5 8.5,-14.5 0.2,-5 -2.4,-10.1 -6.7,-12.8 -0.1,-2.3 -0.2,-4.6 -0.3,-6.9 -1.6,-0.8 -3.4,-1.4 -5.1,-2.1 z M 127.8,92.5 c -0.9,1.7 0.6,3.8 -0.9,4.9 -2.3,0.7 -1.7,-2.4 -1.9,-3.8 -0.6,-1.7 1.9,-0.7 2.8,-1 z m -2.9,8.3 c 4.1,0.9 8,3.7 9.3,7.9 0.9,3.7 0.5,8 -2.3,10.9 -1.7,2 -5.3,4.3 -7.7,3.1 -3.1,-0.8 -5.8,2.1 -8.6,-0.5 -6.9,-4.2 -7.2,-16 0.2,-19.8 2.7,-1.6 6,-1.6 9.1,-1.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 85.1 75.3 C 85 75.8 84.2 76.7 83.9 77.1 C 83.6 77.6 82.4 77.9 82.4 78.6 L 82.4 79 C 82.4 79.4 83.3 80.1 83.6 80.1 L 83.8 80.1 C 84.8 80.1 85 79.1 85.4 78.6 C 85.7 78.2 86.7 77.4 87.2 77 L 85.1 75.3 z M 127.8 92.5 L 125 92.7 L 125.2 96.5 C 125.3 97.5 125.9 97.3 126.5 97.6 C 127.1 97.3 127.8 97.1 127.8 96.3 C 127.8 95.8 127.7 95.6 127.5 95.3 L 127.8 92.5 z"}],i["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]={type:"path",stroke:!1,d:"m 110.6,142.4 0,-28.6 -7.1,0 0,28.6 z m -21.2,0 7.1,0 0,-28.6 -7.1,0 z m 7.1,-28.6 h 7.1 v -11.8 h 24.4 V 77.2 h -6.3 v 18.6 h -18 v -10.7 c 0,-0.9 2.1,-1.2 3,-1.7 0.8,-0.4 2.1,-1.4 2.7,-2 1.5,-1.4 3.2,-3.6 3.8,-5.9 1.6,-6.3 -0.2,-10.6 -3.8,-14.1 -3,-3.1 -9.2,-4.9 -14.3,-2.7 -3.6,1.6 -8.4,6.2 -8.4,11 v 3.2 c 0,2.8 1.9,6.2 3.3,7.7 1,1 1.8,1.7 3,2.5 1,0.6 3.6,1.3 3.6,2.2 v 10.7 H 78.4 v -18.6 h -6.3 v 24.9 h 24.4 v 11.8 h -0 z"},i["AC.IC.SHOOTING"]={type:"path",stroke:!1,d:"m 93.2,89.7 h 16.8 v 9.3 c -2.6,0 -7.3,1.6 -9,1 -2.3,-0.8 -5.4,-2 -7.8,-2.6 v -7.8 l 0,0 z m -30,0 h 26.1 v 9.6 c 0,0.9 4.1,2 5,2.3 1.9,0.6 3.6,1.4 5.5,2 2,0.7 3.4,0.4 6,-0.1 1.6,-0.3 5.7,-0.4 6.6,-0.9 0.6,2.7 4.6,14 4.6,15.2 0,1.6 -1.2,4 -1.3,5.7 l 21.5,0 -8.2,-25.9 7.8,-7.7 c -0.8,-1.6 -4.1,-13.4 -5.2,-13.4 h -68.4 v 13.2 l 0,0 z"},i["AC.IC.FIRE EVENT"]={type:"path",stroke:!1,d:"m 96.5,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.2,1.6 -2.4,3.3 -3.6,5 -1,1.4 -3.1,3.5 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.8,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.6 0.2,9 0.6,2.8 1.4,5 2.5,7.3 0.6,1.2 3,5.5 3.1,6.5 -2.2,-0.5 -7,-4.6 -8.6,-6.2 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.2,8.6 2.4,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.8,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.8 v -1.3 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.9,4.6 -1.4,2.1 -5.2,6.3 -7.8,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 h -0.6 c -0.3,3.9 -1.6,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.3 c 0,-5.1 3,-8.9 3,-12.8 v -0.8 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.2 -3.6,-6.2 v -1.9 l 0,0 z"},i["AC.IC.NON-REsIdENTIAL FIRE"]={type:"path",stroke:!1,d:"m 121.2,122.3 -6.2,0 0,5.9 6.2,0 z m -12.1,0 -6.1,0 0,5.9 6.1,0 z m -12.2,0 -5.9,0 0,5.9 5.9,0 z m -12.3,0 -5.7,0 0,5.9 5.7,0 z m 30.4,-4.8 h 6.1 v -6.2 h -2.5 c -1.2,0 -2.5,1.5 -3.6,1.8 v 4.4 z m -5.9,-6.2 -6.1,0 0,6.2 6.1,0 z m -12.2,0 -5.9,0 0,6.2 5.9,0 z m -12.3,0 -5.7,0 0,6.2 5.7,0 z m 25,-33.4 c 0,-3.4 3.4,-7.4 3.4,-9.1 0,-1.4 -0.8,-4.2 -1.8,-4.6 0,7.1 -8.6,12.8 -8.6,15.7 v 0.4 c 0,0.7 1.9,5.2 2.3,6.6 0.4,1.7 1.4,5.6 1.6,7.3 -6.2,-0.1 -7.3,-9.8 -10.3,-11.8 l -0.3,3 0,4.6 c 0,4.7 3.4,11.4 5.6,13.9 1,1.1 4.2,3.7 5.5,4.3 0.8,0.4 6.3,3 6.6,3 1.4,0 9.2,-7.2 10.5,-8.6 2.5,-2.5 4,-9.6 4,-14.8 v -0.7 l -0.7,-5.7 c -1,0.6 -2.1,5.6 -2.8,7 -1.5,3.2 -1.8,3.1 -5.4,4 -0.3,-12.2 6.7,-8.3 -2.7,-19.1 0,4.9 -0.9,7.9 -4.1,9.6 -1.4,-0.7 -3,-2.7 -3,-4.8 z m -14.8,26.4 h 3.6 c -0.1,-0.6 -0.3,-1.4 -1.1,-1.4 h -1.2 v -2.7 c 0,-0.9 -0.9,-2.4 -1.4,-3 v 7 z m -16.4,-28.6 h 3.9 v 28.6 h 8.9 v -28.6 h 3.6 v 5.4 c 0.3,-0.2 1.4,-1.4 1.4,-1.8 v -5 h -6.4 v 28.6 h -6.4 v -28.6 h -6.1 v 28.6 h -5.2 v 32.7 h 54.8 v -30.7 c -0.4,0.2 -1.1,1 -1.1,1.6 v 27.5 h -52.5 v -29.8 h 5.2 v -28.6 h -0 z"},i["AC.IC.REsIdENTIAL FIRE"]={type:"path",stroke:!1,d:"m 91.5,88.3 -0.7,-3 -30.1,25.2 15.6,0.1 v 25.6 h 50.5 v -25.6 h 12.4 c -0.4,-0.5 -7.6,-5.9 -8,-5.9 -0.3,0 -1.2,1.6 -1.4,1.9 l 1.4,1.4 h -2.4 c -0.7,0.5 -4.9,3.1 -4.9,3.8 v 22.3 h -18.3 v -12.9 h -8.7 v 12.9 h -18.1 v -23.5 h 22.6 l -2.2,-2.7 -30.7,-0.1 L 91.5,88.3 z m 27.6,28 -8.2,0 0,8.5 8.2,0 z m -27,0.2 -8.7,0 0,8.2 8.7,0 z m 11,-36.4 c 0,0.9 2.1,5.3 2.5,6.9 0.4,1.8 1.5,6.1 1.5,7.8 -7.1,-1.6 -6.9,-9.9 -10.3,-12.2 -1.7,7.5 0.8,15.1 3.7,19.5 2.4,3.6 2.6,3.4 6,6 0.4,0.4 7.9,4.3 7.9,4.3 2,0 9.6,-7.1 11.1,-8.6 1.8,-1.8 5.6,-10.8 5.6,-14.4 V 83.5 c 0,-1.9 -0.3,-3.2 -1.4,-4 0,2 -1.8,7 -2.6,8.4 -0.8,1.8 -4.3,4.2 -6.3,4.7 v -1.7 c 0,-4.4 2.4,-6.8 2.4,-10.1 0,-2 -4,-7.2 -5.2,-8 0,5.4 -0.7,8 -4.2,9.8 -1.2,-0.7 -3.1,-2.6 -3.1,-4.4 v -1 c 0,-1.5 1.8,-5.4 2.5,-6.6 2,-3.9 0.5,-3.8 -0.4,-7 h -0.4 c -1.3,5.5 -0.8,4.8 -3.8,8.9 -1,1.4 -5.4,5.9 -5.4,7.5 z"},i["AC.IC.SCHOOL FIRE"]={type:"path",stroke:!1,d:"m 131.3,73 c -4,-1 -17,-7.2 -19.8,-7.2 h -2.4 V 96 h -0.7 c 0,5.6 -3.8,15.3 -6.2,18.6 -2,2.7 -3.7,4.1 -6.2,6.2 -0.8,0.6 -7,4.9 -7,5.4 v 8 h 44.1 V 96 h -20.4 l 0,-14.8 18.8,-8.2 z m -49.2,11.8 c 0,-3 3.6,-8 3.6,-10 0,-1.8 -0.8,-3.9 -2,-4.6 -0.4,0.8 -0.4,3.6 -0.9,5 -0.3,0.7 -1.8,2.7 -2.3,3.5 -1.6,2.3 -3.4,4.2 -5.1,6.4 -2.2,2.8 0,5 1.1,8.2 0.8,2.2 1.4,7.9 2.1,9.4 C 71.9,102.4 70.6,91.8 67.6,89.9 l -0.6,7.6 0.1,0.2 c 0,5 3.6,12.3 5.9,15 1.1,1.3 4.3,3.6 5.9,4.6 1.1,0.7 2.5,1 3.7,1.6 0.4,0.2 3.2,1.9 3.2,1.9 2.1,0 9.9,-7.4 11.5,-9 1.8,-1.8 5.8,-11 5.8,-14.4 v -6.3 c 0,-2.1 -0.4,-2.6 -0.7,-4.2 h -0.8 c -0.2,1.9 -2.2,7.1 -3,8.7 -0.7,1.3 -6.3,5.7 -6.3,3.7 v -1.2 c 0,-3.8 2.4,-7.2 2.4,-10 v -0.8 c 0,-1.5 -4.3,-6.8 -5.4,-7.6 0,2.5 0.1,4.8 -0.8,6.5 -0.5,0.9 -2.5,3.5 -3.6,3.5 -1.1,0 -3.2,-3.4 -3.2,-5.1 z"},i["AC.IC.HOT SPOT"]=[{type:"path",stroke:!1,d:"m 96.3,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.3,1.6 -2.3,3.3 -3.6,4.9 -1,1.3 -3.1,3.4 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.7,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.7 0.3,9 0.6,2.8 1.3,5 2.5,7.3 0.6,1.2 3.1,5.5 3.1,6.5 -2.2,-0.5 -7.1,-4.6 -8.6,-6.1 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.1,8.7 2.5,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.9,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.7 V 99.9 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.8,4.6 -1.4,2.1 -5.2,6.3 -7.9,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 -0.7,8e-4 c -0.3,3.9 -1.7,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.4 c 0,-5.1 3,-8.9 3,-12.8 V 82.6 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.1 -3.6,-6.2 v -1.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 113,126.9 c 0,6.3 -5.1,11.4 -11.4,11.4 -6.3,0 -11.4,-5.1 -11.4,-11.4 0,-6.3 5.1,-11.4 11.4,-11.4 6.3,0 11.4,5.1 11.4,11.4 z"}],i["AC.IC.FIRE ORIGIN"]=[{type:"path",stroke:!1,d:"m 96.3,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.3,1.6 -2.3,3.3 -3.6,4.9 -1,1.3 -3.1,3.4 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.7,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.7 0.3,9 0.6,2.8 1.3,5 2.5,7.3 0.6,1.2 3.1,5.5 3.1,6.5 -2.2,-0.5 -7.1,-4.6 -8.6,-6.1 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.1,8.7 2.5,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.9,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.7 V 99.9 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.8,4.6 -1.4,2.1 -5.2,6.3 -7.9,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 -0.7,8e-4 c -0.3,3.9 -1.7,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.4 c 0,-5.1 3,-8.9 3,-12.8 V 82.6 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.1 -3.6,-6.2 v -1.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 99.6 105.9 C 93.3 105.9 88.2 111 88.2 117.3 C 88.2 123.6 93.3 128.7 99.6 128.7 C 105.9 128.7 111 123.6 111 117.3 C 111 111 105.9 105.9 99.6 105.9 z M 105 109.4 L 106.8 111 L 101.2 117.1 L 107.3 123.2 L 105.6 124.9 L 99.5 118.8 L 93.7 125.3 L 91.9 123.6 L 97.8 117.2 L 92.1 111.4 L 93.8 109.8 L 99.5 115.4 L 105 109.4 z"}],i["AC.IC.SMOKE"]=[{type:"path",stroke:!1,d:"m 99.3,69.2 c 0.2,-2.6 4.4,-5.5 7.2,-6 4.2,-0.8 6.9,1.2 9.1,3.3 1.1,1.1 1.9,2.7 2.4,4.3 0.6,2.2 1.9,1.3 4,2.5 2.4,1.4 4.9,4.4 5.6,7.4 5.3,0 10.3,4.8 10.3,9.9 v 1.3 c 0,3 -1.2,4.9 -2.8,6.5 -1.1,1.1 -1.2,1.2 -2.6,2.1 -1.3,0.8 -2.5,0.6 -2.7,2 -0.6,4.6 -4.2,9 -9.4,9 3.3,5 2.3,8.7 -0.6,13 0,4.8 -0.2,6.2 -2.8,8.8 -2.4,2.5 -4.5,2.4 -8.6,2.4 0.7,-1 1.2,-1 2,-2.4 0.6,-1.1 0.8,-1.7 1.4,-2.9 1,-2.2 1.8,-3.7 1.8,-6.8 v -2.1 c 0,-1.4 -0.2,-2.4 -0.8,-3.2 -1.2,5.2 -1.4,6.4 -5.7,8.6 0,-8.3 3.8,-6.8 -1.9,-13.4 0,3.8 -0.2,5.6 -2.7,6.9 -0.8,-0.5 -2.1,-1.7 -2.1,-2.9 v -0.4 c 0,-2 2.5,-5.2 2.5,-6.7 v -0.4 c 0,-1.1 -0.4,-2.1 -1,-2.5 0,2.9 -3.4,7.6 -4.9,9.2 -1.6,1.7 -1.1,2.8 -0.2,5 0.7,1.7 1.1,3.5 1.1,5.8 v 1 c -3.2,-0.3 -4.4,-6.2 -6.1,-8.2 0,3.4 -0.8,6.3 0.4,9.4 0.8,1.9 2.4,5.6 4.4,6.1 v 0.4 l -3.4,0.6 -0.2,-0.1 c -3.4,0 -6.4,-2.4 -7.8,-4.4 -0.8,-1.1 -1.5,-2.7 -1.7,-4.4 -0.3,-2.3 0.6,-3.6 0.6,-5 0,0 -5.1,-4.7 -4.4,-9 l 0.2,-1.7 c -0.4,-0.5 -1.4,-1.4 -2,-2.2 -0.6,-0.8 -1.1,-1.8 -1.6,-2.6 -1.4,0 -2,0.6 -3.2,0.6 h -0.6 c -5.4,0 -10.5,-5.2 -10.5,-10.5 v -0.8 c 0,-4.9 4.1,-9.2 9,-9.2 h 2.1 c 0.8,-3.2 5.7,-6.9 10.1,-5.9 -0.4,-1.5 -1,-2.7 -1,-4.8 v -0.4 c 0,-3.8 3.2,-7.8 6.1,-8.8 1.9,-0.7 3.9,-1 6.1,-0.4 2.3,0.6 3.7,2.2 4.8,2.5 l 0,0 z m -0.4,-1.9 c -1.3,-0.1 -2.9,-2.1 -5.9,-2.1 h -1.9 c -5,0 -10.6,5.8 -10,11.4 l 0.5,3.4 h -0.6 c -4.3,0 -7.1,3.2 -8.6,6.1 -2.3,-1.1 -6.8,1.2 -7.9,2.4 -1.6,1.6 -3.6,4.2 -3.6,7.3 v 1.5 c 0,3.6 2.4,7.3 4.5,8.9 1.8,1.3 2,1.6 4.4,2.4 2.7,0.9 3.7,0.1 5.9,0.2 l 3.1,3.7 c -0.6,1.3 0.4,4.9 0.9,6 0.5,1.2 0.7,1.4 1.4,2.4 0.2,0.4 1.7,2 1.7,2 0,1.1 -0.4,1.4 -0.4,2.7 v 0.2 c 0,6.3 4.8,12 10.7,12 2.1,0 3.6,-0.4 5,-1 2.6,1.4 7.1,3 9.2,-0.1 l 3.4,0.5 c 2.7,0.4 6.8,-2.2 7.9,-3.6 1,-1.4 3.7,-6 2.4,-8.8 1.1,-0.7 2.6,-3.7 2.7,-5.5 0.1,-1.7 0.2,-1.8 -0.1,-3.6 -0.2,-1.4 -0.9,-2.2 -1,-3.2 4,-0.3 8.4,-5.2 8.4,-9.7 2.5,-1.6 3.4,-1.2 5.6,-3.8 1.3,-1.4 2.6,-4.4 2.6,-7 0,-6.3 -4.7,-12 -10.7,-12 -0.9,-4 -4.8,-8.3 -9.2,-8.6 -0.4,-4.4 -5.7,-9.4 -10.7,-9.4 -4.1,-0 -8.9,2.7 -9.6,5.6 l 0,0 z m 15.8,38.4 c 0.5,0 1,0.1 1,-0.4 0,-3.1 -4.1,-6.7 -7.6,-6.7 h -1.9 c -0.6,0 -1,0.8 -0.6,1 0.4,0.2 1.6,0.1 2,0.1 1.2,0 2.6,0.5 3.4,1 2.1,1.6 2.8,2.1 3.5,5.1 z m -34.5,-12.6 v 1.7 c 0,1.4 0.6,2.2 0.6,3.2 0,0 -3.6,3.4 -3.8,5.4 l 0.6,0.2 c 1,-0.6 1.6,-2.6 3,-4 1,-0.9 3.1,-2.2 4.8,-2.2 h 0.6 c 1.3,0 3.6,1 3.6,-0.2 0,-0.9 -2.6,-1 -3.6,-1 h -0.2 c -1.6,0 -3,0.6 -4,1.3 -0.1,-1 -0.6,-1.9 -0.6,-3.2 0,-4.6 3.7,-8.6 8.4,-8.6 h 1 c 1,0 1.5,0.2 2.3,0.4 0.1,-0.2 0.4,-0.6 0.4,-0.7 0,-0.7 -1.8,-1 -2.5,-1 h -1.5 c -4.5,-8e-4 -9.2,4.4 -9.2,8.6 z m 19.1,-15.8 0.6,0.6 c 1.6,-0.9 3.4,-2.3 5.9,-2.3 h 1 c 5.5,0 10.1,4.4 10.1,9.7 v 0.6 c -1.5,-0 -2.6,-0.8 -4.6,-0.8 h -1 c -1.5,0 -4.1,0.3 -4.2,1.7 0.6,0.1 0.4,0.2 0.8,0.2 0.9,0 1.4,-0.6 3,-0.6 h 2.3 c 2.2,0 5.6,1.8 6.6,3.1 2,2.6 1.8,3.7 2.6,7.2 0.5,0 1,0.1 1,-0.4 0,-4 -2.6,-8.1 -5.2,-9.4 0,-6.9 -4.5,-12.4 -11.1,-12.4 h -1.3 c -2.3,0 -5.6,1.6 -6.5,2.9 z"}],i["AC.IC.SPECIAL NEEDS FIRE"]=[{type:"path",stroke:!1,d:"m 75.3,133.9 h 49.4 v -28.9 c -0.6,0.4 -2.4,1.2 -2.4,2 v 24.8 H 77.4 v -30 h -2.2 v 32.1 l 0,0 z M 93,129.1 h 2 c 4.2,0 7.6,-2.4 9.3,-5 l -1.3,-3.5 c -1.2,0.3 -2.1,5.2 -8.6,5.2 h -0.8 c -3.4,0 -6.3,-3.3 -7.2,-6 -0.6,-1.7 -0.6,-3.6 0,-5.4 0.8,-2.5 1.6,-2.4 2.6,-4 l -0.4,-3.4 c -3.2,0.8 -7.1,8 -5.7,12.8 1.2,4.1 5.4,9.2 10.2,9.2 z M 88.9,97.9 v 0.4 c 0,0.8 0.5,1.4 0.8,2 l 1.4,14.7 11.3,0 4.3,10.2 6.2,-2 -1,-3 -3.5,1 C 108,119.9 104.8,111.7 104,111.7 H 94.1 C 94,111 93.8,110.9 93.8,110.1 v -1.1 h 7.6 v -2.4 h -8 l -0.2,-3.7 v -2.2 c 3.4,-0.8 2.7,-6.2 -1.1,-6.2 -1.8,0 -3.2,1.4 -3.2,3.2 z m 19.9,-7.4 v 1 l -0.4,0.3 C 105.1,89.7 101,86.1 101,80.8 99.6,81.7 98.8,84.8 98.8,87.1 v 1.1 c 0,4.5 3,10.7 5,13.3 2.8,3.7 7.4,4.8 11.6,7 1.6,-0.8 9.3,-5.4 10,-6.3 1.3,-1.7 4.2,-9.8 4.2,-12.4 0,-1.9 -0.3,-8.2 -1.3,-8.8 -0.7,2.7 -0.8,4.7 -2.3,6.8 -1,1.4 -3.3,3.5 -5,4 l -0.2,-2.4 v -0.2 c 0,-3 2,-5.4 2,-8.8 0,-1 -3.4,-6.1 -4.1,-6.2 0,1.8 -0.2,4.1 -0.6,5.4 -0.3,1 -1.9,3.4 -2.9,3.4 h -0.6 c -0.4,-1.4 -1.9,-1.7 -1.9,-4.8 V 76.9 c 0,-2.3 2.6,-5.5 2.6,-7.8 l 0,-0.6 -0.3,-2.4 c -1,0.2 -1,1.9 -1.4,2.9 -0.4,1 -1,2 -1.6,2.9 -1.3,1.7 -2.6,3.4 -3.9,5.1 -2,2.8 -2.1,2.7 -1,6.1 0.6,2 1.7,4.8 1.7,7.4 z m 24.3,10.2 -3.3,-2 -1.2,1.9 3.5,2 z m -66.2,0 1,1.9 c 5,-2.7 11,-6.9 16,-10.1 2.7,-1.7 5.2,-3.4 7.8,-5.1 1.4,-0.9 2.6,-1.6 3.9,-2.6 1.8,-1.2 1.9,-1.9 2.4,-4.3 l -31.2,20.2 z"}],i["AC.IC.WILD FIRE"]=[{type:"path",stroke:!1,d:"m 110.8,139.5 c 0.2,-0.5 6.5,-6.2 7.4,-7 2.6,-2.6 5.6,-5.2 7.8,-8.1 3.9,-5.2 8,-15 8,-24 v -6.9 c 0,-1 0,-2.2 -0.8,-2.4 -0.8,3.4 -3.3,7.7 -5.1,10.1 -0.5,0.6 -7.9,8.7 -7.9,6.2 0,-4.7 2.5,-8.4 2.9,-13.4 0.2,-2.9 -0.8,-11.4 -1.4,-14.3 -0.9,0.7 -1.2,4.2 -1.7,5.7 -0.6,1.7 -1.2,3.6 -2.1,5 -0.7,1.1 -6.1,7.2 -7,7.2 -0.7,0 -1.6,-2.9 -1.6,-4.1 0,-4.7 3.3,-9.7 3.3,-13.4 v -0.6 c 0,-2.4 -1.9,-3.6 -3,-5.6 -0.6,-1 -2.7,-4.7 -3.7,-4.8 v 2.9 c 0,2.2 -0.5,5.6 -1.3,7.1 -0.4,0.8 -3.2,4.1 -4,4.1 -1,0 -3.9,-3.9 -3.9,-5.7 v -3.5 c 0,-4.1 4.1,-8.6 4.1,-12.6 v -0.2 c 0,-1.5 -0,-4 -1.4,-4.1 -0.7,8 -12.6,18.7 -12.6,21.8 0,4.4 3.9,9.2 3.9,15.9 v 2.2 c 0,0.7 -0.2,0.8 -0.2,1.4 -0.8,-0.2 -1.4,-1.3 -1.9,-2 -0.7,-0.8 -1.4,-1.1 -2.2,-1.7 -1.5,-1 -2.7,-2.3 -3.8,-3.7 -1.9,-2.5 -4.1,-6.7 -4.1,-10.9 -1.8,0.5 -3.3,6.3 -3.3,8.8 v 3.5 c 0,8.3 5.9,15.1 5.9,18.1 -3.2,-1.7 -6,-3.9 -8.5,-6.4 -1.2,-1.2 -5.5,-8.5 -6.2,-8.7 0,5.7 1.7,10.3 2.6,15.1 0.5,2.3 1.2,5.1 1.9,7.1 1,2.7 1.9,3.3 3.4,5.3 3,4 4.9,6 8.3,9.4 1.5,1.5 2.9,2.9 4.4,4.4 l 4.7,3.4 5.9,2.8 V 129.9 h -13 l 9.9,-11.5 -7.4,-0.1 9.8,-11.1 -6.6,-0.1 10.9,-17.3 0.1,-0.2 11.2,17.5 -6.1,-0 9.4,11 -7.6,0 10.1,11.7 -13.1,0.1 v 13 l 6,-3.4 z"}],i["AC.IC.HAZARDOUS MATERIALS INCIDENT"]=[{type:"path",stroke:!1,d:"m 60.7,100.6 78.5,-0 -39.3,39.2 -39.2,-39.2 z M 127.6,87.8 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 87.8 z M 115.3,75.5 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 75.5 z M 90.8,69.5 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 90.8 V 69.5 z m -12.2,12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 78.6 V 81.7 z m -6.3,6 0,12.2 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 30.8,-24.5 6.2,6.1 c -0.2,0.4 -0.1,-0.1 -0.1,0.4 V 100 h -6.1 V 63.3 z M 56.7,100 100,143.3 143.3,100 100,56.7 56.7,100 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 103.1,63.3 6.2,6.1 c -0.2,0.4 -0.1,-0.1 -0.1,0.4 V 100 h -6.1 V 63.3 z m -30.8,24.5 0,12.2 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 6.3,-6 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 78.6 V 81.7 z m 12.2,-12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 90.8 V 69.5 z m 24.5,6 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 75.5 z m 12.3,12.3 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 87.8 z m -66.9,12.8 78.5,-0 -39.3,39.2 -39.2,-39.2 z"}],i["AC.IC.CHEMICAL AGENT"]=[{type:"path",stroke:!1,d:"m 100.7,107.7 c -3.2,2e-5 -5.8,1 -7.6,3 -1.9,2 -2.8,4.7 -2.8,8.1 -2e-6,3.4 0.9,6.1 2.8,8.1 1.9,2 4.4,3 7.6,3 1.3,0 2.4,-0.2 3.6,-0.5 1.1,-0.3 2.2,-0.9 3.2,-1.5 l 0.1,-0.1 0,-0.1 0,-3 0,-0.5 -0.3,0.3 c -0.9,0.9 -1.9,1.5 -3,1.9 -1.1,0.4 -2.2,0.7 -3.4,0.7 -2.4,0 -4.1,-0.7 -5.3,-2.1 -1.2,-1.4 -1.9,-3.5 -1.9,-6.2 -4e-6,-2.7 0.6,-4.8 1.9,-6.2 1.2,-1.4 3,-2.1 5.3,-2.1 1.2,2e-5 2.3,0.2 3.4,0.6 1.1,0.4 2.1,1.1 3,1.9 l 0.3,0.3 0,-0.5 0,-3 -0.2,0 0.1,-0.2 c -1,-0.7 -2.1,-1.2 -3.2,-1.5 -1.1,-0.3 -2.3,-0.5 -3.6,-0.5 z M 92.7,64.2 h 14.7 v 33 c 0,8.2 12.9,9.6 12.4,21.8 -0.3,6.8 -7,18.6 -14.3,18.6 h -11 c -6.8,0 -14.6,-13.1 -14.3,-20 0.6,-10.6 12.4,-12.8 12.4,-20.4 v -33 z m -14.7,55 c 0,6.8 7.9,20.2 14.7,20.2 h 14.7 c 8.1,0 14.7,-13 14.7,-22 0,-11.8 -12.8,-13.6 -12.8,-22 V 60.6 H 90.8 V 95.4 c 0,7.8 -12.8,8.7 -12.8,23.9 l 0,0 z"},{type:"path",stroke:!1,fill:E.fillColor.Unknown,d:"m 92.7,64.2 0,33 c 0,7.6 -11.9,9.8 -12.4,20.4 C 79.9,124.5 87.7,137.6 94.5,137.6 l 11,0 c 7.2,0 14,-11.8 14.3,-18.6 0.5,-12.2 -12.4,-13.6 -12.4,-21.8 l 0,-33 -14.7,0 z M 100.7,107.7 c 1.3,2e-5 2.5,0.2 3.6,0.5 1.1,0.3 2.2,0.8 3.2,1.5 l -0.1,0.2 0.2,0 0,3 0,0.5 -0.3,-0.3 c -0.9,-0.9 -1.9,-1.5 -3,-1.9 -1.1,-0.4 -2.2,-0.6 -3.4,-0.6 -2.4,2e-5 -4.1,0.7 -5.3,2.1 -1.2,1.4 -1.9,3.5 -1.9,6.2 -4e-6,2.7 0.6,4.8 1.9,6.2 1.2,1.4 3,2.1 5.3,2.1 1.2,0 2.3,-0.2 3.4,-0.7 1.1,-0.4 2.1,-1.1 3,-1.9 l 0.3,-0.3 0,0.5 0,3 0,0.1 -0.1,0.1 c -1,0.7 -2.1,1.2 -3.2,1.5 -1.1,0.3 -2.3,0.5 -3.6,0.5 -3.2,0 -5.8,-1 -7.6,-3 -1.9,-2 -2.8,-4.7 -2.8,-8.1 -2e-6,-3.4 0.9,-6.1 2.8,-8.1 1.9,-2 4.4,-3 7.6,-3 z"}],i["AC.IC.CORROSIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 102.9,135.4 c 0.8,0 1.4,-0.8 1.4,-1.5 0,-0.7 -0.6,-1.5 -1.2,-1.5 H 102.3 c -0.5,0 -1.2,0.7 -1.2,1.4 v 0.3 c 0,0.8 0.6,1.4 1.4,1.4 H 102.9 z M 96.9,132.5 c 0,0.7 0.6,1.5 1.2,1.5 h 0.6 c 0.8,0 1.4,-0.8 1.4,-1.5 v -0.2 c 0,-0.7 -0.6,-1.5 -1.2,-1.5 H 98.1 c -0.6,0 -1.2,0.9 -1.2,1.5 v 0.2 z m 8.5,-0.9 c 1.3,0 2.2,-1.8 1.1,-2.8 -1,-1 -2.8,-0.2 -2.8,1.1 0,0.8 0.9,1.7 1.7,1.7 z m -6.2,-4.4 c 0,0.6 0.6,1.5 1.2,1.5 h 0.6 c 0.8,0 1.4,-0.6 1.4,-1.4 v -0.6 c 0,-0.5 -0.7,-1.2 -1.4,-1.2 h -0.3 c -0.8,0 -1.5,0.8 -1.5,1.6 z m -0.6,-4.1 c 0.6,0 1.2,-0.8 1.2,-1.5 0,-1 -0.7,-1.7 -1.7,-1.7 -0.6,0 -1.5,0.6 -1.5,1.2 v 0.6 c 0,0.7 0.7,1.4 1.2,1.4 h 0.8 V 123.1 z m 2.4,-2.7 c 0,0.6 0.7,1.5 1.2,1.5 h 0.8 c 0.4,0 1.2,-0.8 1.2,-1.2 v -0.8 c 0,-0.6 -0.8,-1.2 -1.5,-1.2 h -0.1 c -0.8,0 -1.5,0.8 -1.5,1.5 v 0.1 z m -2.7,-3.5 c 0.6,0 1.4,-0.8 1.4,-1.5 v -0.2 c 0,-2.2 -3.2,-1.8 -3.2,-0.3 v 0.8 c 0,0.7 1.1,1.2 1.8,1.2 z m 4.1,-3.6 c 0,2 3.3,1.9 3.2,-0.1 -0.1,-2.3 -3.2,-1.8 -3.2,-0.3 v 0.4 z m 4.7,-16.2 0,2.9 -3,-0.2 0.9,2.8 -1.1,0.1 -1.6,-0.9 -0.4,3 -1,-1.5 -3.3,1 -0.6,-3.2 -2,1.3 -0.6,-1.6 -2.5,0.4 1.5,-2.7 -0.6,-1.5 -22.2,0 0,12.4 59.2,0 0,-12.4 z M 94.3,85.2 v 1.4 c 0,4.4 2.1,8.7 5.7,9.4 3.7,0.8 7,-4.5 7,-8 v -1.5 c 0,-3 -2.1,-8.6 -3,-11.3 -0.5,-1.4 -3.1,-10.6 -3.9,-10.6 -0.8,0 -0.9,4.5 -1.1,5.4 -0.6,2.1 -0.9,3.2 -1.6,5.1 -0.8,2.3 -3.2,7.6 -3.2,10.1 l 0,0 z"}],i["AC.IC.HAZARDOUS WHEN WET"]=[{type:"path",stroke:!1,d:"m 60.6,100.5 78.8,-0 -39.4,39.4 L 60.6,100.5 z M 127.6,87.8 c 0.6,0.4 6.1,5.9 6.1,6.2 v 5.8 H 127.6 V 87.8 z M 115.3,75.5 c 0.6,0.4 6.1,5.9 6.1,6.2 v 18.1 h -6.1 V 75.5 z M 90.8,69.5 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 90.8 V 69.5 z M 78.6,81.7 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 78.6 V 81.7 z m -6.3,6 0,12.1 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 30.8,-24.5 6.2,6.1 c -0.2,0.4 -0.1,-0.2 -0.1,0.4 v 30 h -6.1 V 63.3 z M 56.7,100 100,143.3 143.3,100 100,56.7 56.7,100 z m 41.2,25.3 c 0.2,1 0.6,1.6 1.6,1.8 l -0.8,0.6 c -1.3,-0.6 -1.3,-0.1 -1.7,-1.9 l 0.9,-0.4 z m -2.4,-1 c 0,2.9 1.3,4.9 4.2,4.9 h 0.9 c 1.9,0 3,-1 3.6,-2.3 0.9,-1.8 0.6,-3.1 -0.2,-4.6 -0.8,-1.4 -1.6,-2.3 -2.2,-3.8 -0.5,-1.2 -0.8,-3.8 -1.7,-4.4 C 99.6,118.1 95.5,122.5 95.5,124.2 z m -12.6,-9.4 c 0.4,0.9 0.4,1.4 1.5,1.7 l -0.6,0.6 C 82.2,116.7 82.6,116.5 82,115.3 l 0.9,-0.5 z m 1.6,3.8 H 86 c 2.3,0 3.7,-2.2 3.7,-4.6 0,-1.2 -1.9,-3.9 -2.6,-4.9 -0.9,-1.4 -1.2,-4.7 -2.2,-5.4 -0.2,3 -2.3,5.9 -3.6,8 -1.9,2.9 -0.4,6.9 3.1,6.9 z m 28.4,-3.8 c 0.2,1.6 0.9,1.1 1.5,2 l -0.8,0.3 c -1,-0.2 -1.7,-0.8 -1.8,-1.9 L 112.9,114.8 z m 2,-11.1 c -0.3,3.6 -2.2,5.6 -3.6,8.1 -1.7,3.1 -0.3,6.8 3.2,6.8 h 1.3 c 2.2,0 3.7,-1.7 3.7,-3.9 v -0.9 c 0,-1.4 -1.9,-3.8 -2.6,-4.9 -0.9,-1.4 -0.7,-4.4 -2,-5.2 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 112.9,114.8 c 0.2,1.6 0.9,1.1 1.5,2 l -0.8,0.3 c -1,-0.2 -1.7,-0.8 -1.8,-1.9 L 112.9,114.8 z m -30,0 c 0.4,0.9 0.4,1.4 1.5,1.7 l -0.6,0.6 C 82.2,116.7 82.6,116.5 82,115.3 l 0.9,-0.5 z m 15,10.4 c 0.2,1 0.6,1.6 1.6,1.8 l -0.8,0.6 c -1.3,-0.6 -1.3,-0.1 -1.7,-1.9 l 0.9,-0.4 z m 5.2,-62 6.2,6.1 c -0.2,0.4 -0.1,-0.2 -0.1,0.4 v 30 h -6.1 V 63.3 z m -30.8,24.5 0,12.1 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 6.3,-6 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 78.6 V 81.7 z m 12.2,-12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 90.8 V 69.5 z m 24.5,6 c 0.6,0.4 6.1,5.9 6.1,6.2 v 18.1 h -6.1 V 75.5 z m 12.4,12.3 c 0.6,0.4 6.1,5.9 6.1,6.2 v 5.8 H 127.6 V 87.8 z m 11.7,12.6 -78.8,0 39.4,39.4 L 139.4,100.4 z M 85,103.7 c 1,0.7 1.3,4 2.2,5.4 0.6,1 2.6,3.6 2.6,4.9 0,2.4 -1.4,4.6 -3.7,4.6 l -1.5,0 c -3.5,0 -5,-4 -3.1,-6.9 1.3,-2.1 3.4,-5 3.6,-8 z m 29.8,0 c 1.3,0.9 1.2,3.8 2,5.2 0.7,1.1 2.6,3.5 2.6,4.9 l 0,0.9 c 0,2.2 -1.6,3.9 -3.7,3.9 l -1.3,0 c -3.5,0 -4.9,-3.7 -3.2,-6.8 1.4,-2.5 3.4,-4.5 3.7,-8.1 z M 100,114.1 c 0.8,0.6 1.2,3.1 1.7,4.3 0.6,1.5 1.5,2.4 2.2,3.8 0.8,1.5 1.2,2.7 0.3,4.6 -0.6,1.3 -1.7,2.3 -3.6,2.3 l -0.9,0 c -2.8,0 -4.2,-2 -4.2,-4.9 0,-1.7 4.1,-6.1 4.5,-10.1 z"}],i["AC.IC.EXPLOSIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 96.5,104.6 0,0.2 -0.2,0 0,4 0,0.2 0.2,0 3.2,0 0.2,0 0,-0.2 0,-4 0,-0.2 -0.2,0 -3.2,0 z m 2.3,-20 c -1.1,2.4e-5 -2.2,0.1 -3.2,0.5 -1,0.3 -2,0.8 -3,1.4 l -0.1,0.1 0,0.1 0,3 0,0.4 0.3,-0.2 c 1,-0.7 2,-1.2 2.9,-1.6 0.9,-0.4 1.8,-0.5 2.6,-0.5 1.1,2.1e-5 2,0.3 2.6,0.8 0.7,0.5 1,1.2 1,2.1 -10e-6,0.5 -0.1,1 -0.4,1.4 -0.2,0.5 -0.7,1 -1.3,1.5 l -0,0 -1.4,1.4 c -1,0.9 -1.6,1.7 -1.9,2.5 -0.3,0.7 -0.5,1.6 -0.5,2.7 l 0,2.4 0,0.2 0.2,0 3,0 0,-0.2 0.2,0 0,-1.9 c -8e-6,-0.5 0,-1 0,-1.3 0,-0.3 0.1,-0.6 0.1,-0.8 0.1,-0.2 0.2,-0.5 0.4,-0.8 0.2,-0.3 0.5,-0.7 1,-1.1 l 1.4,-1.4 c 1,-0.9 1.6,-1.7 2,-2.5 0.4,-0.8 0.6,-1.6 0.6,-2.4 -2e-5,-1.7 -0.6,-3.1 -1.8,-4.2 -1.2,-1.1 -2.8,-1.6 -4.8,-1.6 z m 4.8,-31.1 -1.5,4.5 -4.3,12.9 -4.5,-7 -1.6,-2.5 -0.3,2.9 -1.3,14.4 -9.5,-10.7 -2.8,-3.2 1.1,4.1 3.4,12.9 -13.1,-0.7 -0.7,-0 -0.3,0.6 -0.1,0.2 -0.4,0.8 0.7,0.5 11.3,8.1 -20.1,1.4 -5.6,0.4 5.4,1.6 18,5.3 -12.3,7.1 -0.8,0.4 0.3,0.8 0.1,0.2 0.3,0.7 0.8,-0.1 16.1,-2 -4.8,8.3 -1.5,2.6 2.7,-1.1 8.8,-3.7 -3.4,14.5 -1.1,4.5 2.8,-3.7 8.9,-11.6 5,19.2 0.2,0.8 0.8,0 0.4,0 0.9,0 0.1,-1 0.9,-18.7 9.2,11.2 2.6,3.2 -0.9,-4 -3.3,-15.2 10.6,5.9 4.7,2.6 -3.4,-4.1 -5.5,-6.6 15.6,4.4 4,1.2 -3.1,-2.9 -10.7,-9.9 13.7,-2.1 4.6,-0.7 -4.5,-1.2 -15.5,-4.3 18.9,-9.6 4.7,-2.4 -5.2,0.5 -17.1,1.6 6.7,-10.8 2,-3.2 -3.3,1.8 -14.6,7.9 5.2,-16.5 1.7,-5.5 -3.5,4.5 -10.6,14 -1.7,-18.8 -0.4,-4.8 z m -1.1,9.7 1.5,16.6 0.2,2.6 1.6,-2 8.7,-11.5 -4.2,13.4 -0.8,2.4 2.2,-1.2 13.4,-7.3 -5.8,9.3 -1.1,1.7 2,-0.2 13.9,-1.3 -16.5,8.4 -2.3,1.2 2.5,0.7 13.5,3.7 -11.2,1.7 -2,0.3 1.5,1.4 9.1,8.4 -14.6,-4.2 -3.1,-0.9 2.1,2.5 4.2,5 -7.8,-4.3 -1.9,-1.1 0.5,2.2 2.9,13.3 -8.2,-10 -1.6,-2 -0.1,2.6 -0.8,16.1 -4.2,-16.3 -0.5,-2 -1.2,1.6 -7.3,9.5 2.8,-11.9 0.4,-1.9 -1.8,0.7 -7.9,3.3 4.3,-7.4 1,-1.7 -2,0.2 -13.9,1.7 10.3,-6 0.5,-0.3 0,-0.6 0,-0.3 0,-0.8 -0.7,-0.2 -14.5,-4.2 17.3,-1.2 2.8,-0.2 -2.3,-1.6 -11,-8 11.5,0.6 1.4,0.1 -0.3,-1.3 -2.7,-10.1 8.2,9.3 1.5,1.8 0.2,-2.3 1.3,-13.8 4,6.3 1.1,1.8 0.7,-2 3.4,-10.3 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 102.5 63.2 L 99 73.5 L 98.4 75.5 L 97.3 73.7 L 93.2 67.4 L 91.9 81.3 L 91.7 83.6 L 90.2 81.8 L 82 72.5 L 84.7 82.7 L 85.1 84 L 83.7 83.9 L 72.2 83.4 L 83.2 91.3 L 85.5 93 L 82.7 93.2 L 65.4 94.3 L 79.9 98.5 L 80.7 98.8 L 80.7 99.5 L 80.7 99.8 L 80.7 100.3 L 80.2 100.7 L 69.8 106.6 L 83.8 104.9 L 85.8 104.7 L 84.8 106.4 L 80.4 113.8 L 88.3 110.6 L 90.1 109.8 L 89.7 111.7 L 86.9 123.6 L 94.2 114.1 L 95.5 112.5 L 96 114.4 L 100.2 130.8 L 101 114.6 L 101.2 112 L 102.8 114 L 111 124 L 108.1 110.7 L 107.6 108.5 L 109.6 109.6 L 117.3 113.9 L 113.2 108.9 L 111.1 106.4 L 114.3 107.3 L 128.9 111.5 L 119.7 103.1 L 118.2 101.7 L 120.3 101.3 L 131.4 99.6 L 117.9 95.9 L 115.4 95.2 L 117.8 94 L 134.3 85.6 L 120.3 86.9 L 118.3 87.1 L 119.4 85.4 L 125.2 76.1 L 111.8 83.3 L 109.6 84.5 L 110.3 82.2 L 114.5 68.8 L 105.8 80.3 L 104.3 82.3 L 104 79.8 L 102.5 63.2 z M 98.8 84.5 C 100.8 84.5 102.4 85.1 103.6 86.1 C 104.8 87.2 105.5 88.6 105.5 90.3 C 105.5 91.2 105.3 92 104.9 92.7 C 104.5 93.5 103.8 94.3 102.8 95.2 L 101.5 96.6 C 101 97.1 100.6 97.4 100.4 97.7 C 100.2 98 100.1 98.2 100 98.5 C 100 98.7 99.9 98.9 99.9 99.2 C 99.8 99.5 99.8 100 99.8 100.5 L 99.8 102.4 L 99.7 102.4 L 99.7 102.7 L 96.6 102.7 L 96.4 102.7 L 96.4 102.4 L 96.4 100 C 96.4 98.9 96.6 98 96.9 97.3 C 97.2 96.6 97.9 95.8 98.8 94.8 L 100.2 93.4 C 100.8 92.9 101.2 92.4 101.5 91.9 C 101.7 91.4 101.9 91 101.9 90.5 C 101.9 89.6 101.5 88.9 100.9 88.3 C 100.2 87.8 99.4 87.5 98.3 87.5 C 97.5 87.5 96.6 87.7 95.7 88.1 C 94.8 88.5 93.8 89 92.8 89.7 L 92.5 89.9 L 92.5 89.5 L 92.5 86.5 L 92.5 86.4 L 92.6 86.3 C 93.6 85.7 94.6 85.3 95.6 85 C 96.7 84.7 97.7 84.5 98.8 84.5 z M 96.5 104.6 L 99.8 104.6 L 99.9 104.6 L 99.9 104.8 L 99.9 108.8 L 99.9 109 L 99.8 109 L 96.5 109 L 96.3 109 L 96.3 108.8 L 96.3 104.8 L 96.5 104.8 L 96.5 104.6 z"}],i["AC.IC.FLAMMABLE GAS"]=[{type:"path",stroke:!1,d:"m 93.3,82.5 c 0,-4.3 13.8,-4.3 13.8,0 v 55.6 c 0,1.3 -4.4,1.2 -5.9,1.2 h -2 c -1.5,0 -5.9,0.1 -5.9,-1.2 V 82.5 l 4e-4,0 z m 5.3,-20.6 h -6.5 v 2.9 h 6.3 v 3.2 h -3.7 v 2 h 3.7 v 5.3 h -4.6 v 4.5 c -1.1,0.3 -2,1.6 -2,3 v 54.8 c 0,3.3 3.7,3.2 7.1,3.2 h 2.4 c 3.4,0 7.1,0.2 7.1,-3.2 V 83.1 c 0,-2.8 -1.8,-2.8 -1.8,-3.7 v -4.1 h -4.7 v -10.4 h 6.3 v -3 h -6.7 v -2.5 h -2.9 v 2.5 l 0,0 z m 21.8,32.3 v 0.6 c 0,2.2 2.3,5.1 1.6,8.1 -1.3,-0.3 -3.1,-2 -3.8,-3 -0.3,-0.4 -0.9,-1.7 -1.2,-2.2 -0.4,-0.9 -0.4,-2.3 -0.7,-2.8 -1.1,0.8 -1.6,3.5 -1.6,5.5 v 0.2 c 0,3.2 2.4,7.5 3.8,9.6 2,3 6.3,3.3 8.4,5.1 1.6,-0.9 6.9,-3.7 7.7,-4.9 0.9,-1.2 3.2,-7.4 3,-9.6 l -0.7,-5.9 h -0.4 c -0,3.2 -2.7,7.6 -5.5,7.9 v -2 c 0,-1.7 1.4,-4 1.4,-6.1 v -0.2 c 0,-0.9 -2.4,-4.4 -3.2,-4.7 0,3.4 -0.3,5.5 -2.5,6.7 -0.8,-0.7 -1.8,-1.6 -1.8,-3.1 v -1.2 c 0,-2.1 2,-4.1 2,-6.1 0,-0.9 -0.1,-1.6 -0.6,-2 -0.9,3.8 -5.9,8.9 -5.9,10.2 z m -52.7,0 v 0.4 c 0,1.2 1.8,4.3 1.8,6.1 v 2.2 c -2.4,-0.2 -5.7,-5 -5.7,-8.1 -1.7,1.1 -1.5,4.3 -1.4,6.7 0.1,2.4 1.3,4.7 2.2,6.3 1.3,2.6 1.6,2.9 4,4.5 0.6,0.4 5.3,2.8 5.9,2.8 1.2,0 6.8,-3.9 7.5,-4.7 0.9,-1 3.3,-7.3 3.1,-9.1 l -0.6,-6.5 h -0.4 c -0.5,2.3 -0.3,3.3 -1.6,5 -0.6,0.8 -2.7,2.7 -3.8,2.8 0,-0.9 -0.2,-0.7 -0.2,-1.4 0,-1.8 1.4,-4.3 1.7,-6.6 0.1,-1 -2.6,-4.6 -3.3,-5 0.4,2 -0.8,6.5 -2.4,6.5 h -0.2 c -0.9,0 -1.8,-2.2 -1.8,-3.4 0,-3.9 2.6,-4.5 1.6,-8.8 -0,0 -2.2,4.5 -2.9,5.4 -0.6,0.6 -3.5,4.3 -3.5,4.9 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 93.3,82.5 c 0,-4.3 13.8,-4.3 13.8,0 v 55.6 c 0,1.3 -4.4,1.2 -5.9,1.2 h -2 c -1.5,0 -5.9,0.1 -5.9,-1.2 V 82.5 l 4e-4,0 z"}],i["AC.IC.FLAMMABLE LIQUID"]=[{type:"path",stroke:!1,d:"m 100.1,135.4 c -7.4,0 -11.3,-5.4 -13.1,-11.1 -2.1,-6.7 -2.4,-14.4 0.8,-20.2 5.9,-10.6 10.7,-21.6 11.9,-36.7 4,4.6 3.6,17.4 6.3,23.9 2.6,6.5 8.9,13.4 8.9,21 v 1.7 c 0,10 -4.5,21.3 -14.2,21.3 h -0.7 v 0 z m -0.6,1.7 h 1.9 c 10.1,0 15.4,-11.7 15.4,-21.9 v -3 c 0,-9.5 -7.7,-15.8 -9.9,-24.1 -2.4,-8.9 -1.7,-21.2 -9.1,-25.1 0,8.6 -1.3,16 -3.6,22.4 -1.2,3.3 -2.4,6.2 -3.6,9.5 -1.2,2.7 -3.1,5.8 -4.5,8.6 -1.4,2.7 -3,6.1 -2.6,10.5 0.4,4.4 0.6,7.6 1.8,11.3 2,5.9 6.7,11.9 14.3,11.9 z M 122,87 v 0.2 c 0,2.3 2.4,5.5 1.7,8.6 -1.3,-0.1 -3.5,-2.2 -4.1,-3.2 -0.5,-0.9 -0.9,-1.3 -1.2,-2.4 -0.3,-0.7 -0.6,-2.6 -0.8,-3 -1.2,0.9 -1.7,4 -1.7,6.1 0,3.2 2.6,8.4 4,10.4 1,1.3 2.5,2.3 4.1,3.1 0.6,0.3 4.8,2.4 5,2.4 0.9,0 7.6,-4.4 8.2,-5.1 0.9,-1.1 3.5,-8 3.3,-10.1 l -0.7,-6.8 h -0.4 c -0.1,3.5 -2.8,8.2 -5.9,8.4 0,0 0.3,-3.5 0.5,-4.4 0.3,-1.3 1,-2.9 1,-4.3 V 86.8 c 0,-1 -2.7,-4.6 -3.4,-5.1 0,3.7 -0.2,6 -2.7,7.2 -0.7,-0.6 -1.9,-1.7 -1.9,-3 v -1.4 c 0,-2.3 2.1,-4.7 2.1,-6.5 l 0,-0.2 -0.3,-1.9 c -1,0.2 -1.1,2 -1.5,2.9 -0.5,0.9 -1.2,1.9 -1.8,2.6 -0.9,1.2 -3.5,4.1 -3.5,5.7 z m -56.6,0 c 0,1.3 1.9,4.7 1.9,7 v 1.9 c -2.6,-0.2 -6.1,-5.2 -6.1,-8.6 -3.4,2.4 -0.7,11.4 0.9,14.1 1.5,2.6 1.8,3 4.4,4.7 0.4,0.3 6.1,3.1 6.2,3.1 1.3,0 4.1,-2.5 5.3,-3.2 2.5,-1.2 2.9,-1.7 4.2,-4.3 0.4,-0.9 1.6,-5.4 1.9,-6.6 0.4,-2.1 -0.5,-5.8 -0.5,-7.9 h -0.5 c -0.3,3.5 -2.9,8.4 -5.9,8.4 -0,-0.9 -0.2,-0.5 -0.2,-1.2 0,-2 1.5,-4.9 1.8,-7.1 0.2,-1.2 -2.7,-5.2 -3.5,-5.4 1,2.1 -1.1,6.1 -2.7,7 -0.9,-0.6 -1.9,-2.2 -1.9,-3.6 v -0.4 c 0,-3.7 2.7,-4.6 1.7,-9.1 -0.5,0.4 -0.8,2 -1.4,3 -0.7,1 -1,1.7 -1.8,2.7 -0.8,1 -3.6,4.2 -3.6,5.5 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 100.1,135.4 c -7.4,0 -11.3,-5.4 -13.1,-11.1 -2.1,-6.7 -2.4,-14.4 0.8,-20.2 5.9,-10.6 10.7,-21.6 11.9,-36.7 4,4.6 3.6,17.4 6.3,23.9 2.6,6.5 8.9,13.4 8.9,21 v 1.7 c 0,10 -4.5,21.3 -14.2,21.3 h -0.7 v 0 z"}],i["AC.IC.FLAMMABLE SOLID"]=[{type:"path",stroke:!1,d:"m 68.6,102 c 0,-2 1.9,-4.2 1.9,-6.3 v -1.5 c 0,-0.6 -0.1,-0.4 -0.4,-0.7 -0.8,3.7 -6.1,9.1 -6.1,10.4 0,1.6 1.9,4.6 1.9,8.2 -2.6,-0.2 -5.9,-4.9 -5.9,-8 -0.8,0.9 -1.5,2.6 -1.5,4.3 0,4.4 1.7,8.1 3.5,10.6 0.8,1.2 7,5.2 8.7,5.2 1.1,0 6.7,-3.7 7.3,-4.4 0.9,-1.2 3.2,-6.8 3.2,-8.6 0,-1.6 -0,-6.6 -0.9,-7.2 -1.1,4.8 -1.5,5.9 -5.4,8.1 0,-4.3 1.3,-5.7 1.3,-8.2 v -0.4 c 0,-0.1 -2.8,-4.4 -3,-4.6 0,2.4 -0.7,6.7 -2.6,6.7 -1,8e-4 -2,-2.4 -2,-3.7 z m 60.3,-0.4 c 0,-1.7 2.2,-4.5 2.2,-6.3 0,-0.7 -0.2,-1.6 -0.7,-1.9 -0.9,3.7 -5.9,8.9 -5.9,10.2 v 0.4 c 0,1.9 1.5,3.7 1.5,6.1 v 2.2 c -2.3,-0.6 -5.6,-4.9 -5.7,-8 -1,0.7 -1.5,3 -1.5,4.8 v 1.1 c 0,2.8 2.5,7.7 3.8,9.5 2,2.7 6.4,3.1 8.4,4.8 2.1,-1.1 3.1,-1.8 5.1,-2.9 2.6,-1.6 2.2,-1.5 3.5,-4.3 0.7,-1.4 1.7,-4.5 1.8,-6.2 0.1,-1.5 -0.1,-6.4 -0.9,-7 -0.8,3.5 -2.1,7.1 -5.4,8 -0,-0.7 -0.2,-0.7 -0.2,-1.5 v -0.2 c 0,-1.8 1.7,-4.9 1.5,-6.4 -0.1,-0.8 -2.5,-4.8 -3,-5.1 0,2.8 -0.5,6.7 -3,6.7 -0.4,-1.3 -1.5,-1 -1.5,-3.9 z m -35.6,1.9 v -20 l 20,-0.4 v 19.4 l -20,1 z m -13.9,-7.6 0,-16.8 10.8,4 v 19.8 c -1.2,-0.7 -10.9,-6.2 -10.9,-7 z m 1.5,-18.4 c 5.7,0 11.4,0 17.2,0 2.1,0 12.1,3.1 13.2,3.9 l -3.7,0.3 H 92.6 c -0.9,0 -11.1,-3.7 -11.7,-4.1 z m -3.5,-1.5 0,14.7 -0.3,6.7 c 2.2,1.2 5.3,3 7.5,4.5 1.9,1.2 5.5,4 8.1,4 7.6,0 15.3,-1.1 23.1,-1.1 l -0,-23.6 c -1,-0.5 -14.8,-5.4 -15.2,-5.4 l -3.9,-0.1 -19.3,0.4 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 80.9,77.5 c 5.7,0 11.4,0 17.2,0 2.1,0 12.1,3.1 13.2,3.9 l -3.7,0.3 H 92.6 c -0.9,0 -11.1,-3.7 -11.7,-4.1 z m -1.5,18.4 0,-16.8 10.8,4 v 19.8 c -1.2,-0.7 -10.9,-6.2 -10.9,-7 z m 13.9,7.6 v -20 l 20,-0.4 v 19.4 l -20,1 z"}],i["AC.IC.NON-FLAMMABLE GAS"]=[{type:"path",stroke:!1,d:"m 92.7,81.3 c 0,-4.6 14.7,-4.6 14.7,0 v 59.4 c 0,1.4 -4.7,1.3 -6.3,1.3 h -2.1 c -1.6,0 -6.3,0.1 -6.3,-1.3 V 81.3 z m 5.7,-22 h -7 v 3.2 h 6.7 v 3.3 h -4 v 2.1 h 4 v 5.7 h -4.8 v 4.8 c -1.1,0.3 -2.1,1.7 -2.1,3.1 v 58.6 c 0,3.5 4,3.3 7.6,3.3 h 2.5 c 3.6,0 7.6,0.2 7.6,-3.3 V 81.9 c 0,-3 -1.9,-3 -1.9,-4 v -4.4 h -5 v -11.1 h 6.7 v -3.1 h -7.2 v -2.7 h -3.1 v 2.7 l -4e-4,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 92.7,81.3 c 0,-4.6 14.7,-4.6 14.7,0 v 59.4 c 0,1.4 -4.7,1.3 -6.3,1.3 h -2.1 c -1.6,0 -6.3,0.1 -6.3,-1.3 V 81.3 z"}],i["AC.IC.ORGANIC PEROXIDE"]=[{type:"path",stroke:!1,d:"m 132.1,128.2 v 6.2 l -36.6,2.2 v -6.7 l 0.6,0.1 36,-1.7 z m -63.8,-11.1 c 2.6,1.7 26.1,12.1 26.1,13.2 v 5.9 l -0.1,0.2 -26,-14.7 v -4.6 z m 61.1,10 c -4.7,0 -33,2.1 -34.6,1.5 -1.8,-0.7 -23.8,-11.4 -24.4,-12 3.8,0 7.5,0 11.3,0 2.9,0 8.8,-0.8 10,1.1 l -9,0.6 2.1,0.7 v 0.4 h -1.2 l -1.8,0.2 c 2,1.3 18.3,5.2 22.4,5.2 h 1.9 c 4.8,0 9.2,-1.3 13,-1.4 0.7,0 9.9,3.3 10.4,3.7 z m -25.4,-23.2 1.1,9.4 5.4,-6.8 -2.5,8.2 7.7,-4.3 -3.7,5.9 8.4,-0.8 -9.2,4.7 8.1,2.6 -14.4,1.7 c -3.3,0.2 -19,-3.7 -20.5,-4.8 l 10.3,-0.6 -6.2,-4.5 6.8,0.1 -1.7,-5.9 5.1,5.2 0.7,-7.5 2.6,3.9 2.1,-6.6 z m 0.7,-2.2 -0.1,-0.6 h -0.3 l -1.8,6.2 -0.4,-0 -2.4,-3.7 -0,2.1 -0.7,-1.1 -0.6,6.2 -4.9,-5.4 0.6,2.6 -1.5,-1.2 1.8,6.2 -2.5,0 -4,-0.2 1.5,1.1 -2.4,-0.1 1.5,1.4 h -21.3 c -0.1,0.5 -0.2,0.5 -0.2,1.1 v 5 c 0,1.6 4.8,3.7 6.2,4.4 2.3,1.3 4.6,2.4 6.9,3.8 4.4,2.7 9.2,5 13.7,7.6 1.8,1.1 6.8,0.5 9.6,0.2 2.8,-0.3 7.2,-0.2 9.9,-0.7 2.8,-0.5 7,-0.4 9.9,-0.7 2.7,-0.4 7.4,-0.6 10,-0.7 v -7.9 c 0,-0.9 -5.3,-2.4 -6.4,-2.8 -1.6,-0.5 -5.7,-1.9 -6.8,-2.6 l 2.9,-0.3 -8.4,-2.2 0,-0.4 9.2,-4.7 -1.5,0.2 1.7,-1.1 -10,1 3.9,-6.6 -8.1,4.7 2.9,-10 -6.4,8.4 -1.1,-11.1 -0.6,1.9 z m 1.1,-6.2 c -5.6,0 -9.6,-3.4 -9.6,-9 v -1.1 c 0,-4.8 9,-12.5 9,-21.1 2.8,3.2 2.2,7.6 4.3,11 1.2,1.9 5.3,7.8 5.3,9.9 v 1.1 c 0,5.3 -3.7,9.2 -9,9.2 z m -10.9,-10 v 1.1 c 0,13.7 21.1,13.2 21.1,0.8 v -2.1 c 0,-3.5 -4.5,-8.3 -5.9,-11.7 -2.2,-5.1 -1.1,-8.8 -6.2,-11.6 0,11.2 -9,17.6 -9,23.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 105.7,95.5 c -5.6,0 -9.6,-3.4 -9.6,-9 v -1.1 c 0,-4.8 9,-12.5 9,-21.1 2.8,3.2 2.2,7.6 4.3,11 1.2,1.9 5.3,7.8 5.3,9.9 v 1.1 c 0,5.3 -3.7,9.2 -9,9.2 z m -1.8,8.4 1.1,9.4 5.4,-6.8 -2.5,8.2 7.7,-4.3 -3.7,5.9 8.4,-0.8 -9.2,4.7 8.1,2.6 -14.4,1.7 c -3.3,0.2 -19,-3.7 -20.5,-4.8 l 10.3,-0.6 -6.2,-4.5 6.8,0.1 -1.7,-5.9 5.1,5.2 0.7,-7.5 2.6,3.9 2.1,-6.6 z m -35.6,13.2 c 2.6,1.7 26.1,12.1 26.1,13.2 v 5.9 l -0.1,0.2 -26,-14.7 v -4.6 z m 63.8,11.1 v 6.2 l -36.6,2.2 v -6.7 l 0.6,0.1 36,-1.7 z m -2.7,-1.1 c -4.7,0 -33,2.1 -34.6,1.5 -1.8,-0.7 -23.8,-11.4 -24.4,-12 3.8,0 7.5,0 11.3,0 2.9,0 8.8,-0.8 10,1.1 l -9,0.6 2.1,0.7 v 0.4 h -1.2 l -1.8,0.2 c 2,1.3 18.3,5.2 22.4,5.2 h 1.9 c 4.8,0 9.2,-1.3 13,-1.4 0.7,0 9.9,3.3 10.4,3.7 z"}],i["AC.IC.OXIDIZER"]=[{type:"path",stroke:!1,d:"m 80.9,135.3 0,0.2 0,4.2 0,0.2 0.2,0 40.7,0 0.2,0 0,-0.2 0,-4.2 0,-0.2 -0.2,0 -40.7,0 -0.2,0 z m 6.5,-20.7 c 0,-7.4 6.1,-14 13.4,-14 h 1.1 c 7.5,0 13.6,6.6 13.6,14 0,7.1 -6.2,13.9 -13.2,13.9 h -1.9 c -6.8,-0 -13,-6.8 -13,-13.9 z m 12.8,-35.9 c -0.7,0 -2.1,-2.1 -2.3,-2.9 -0.3,-1.2 -0.4,-3 0,-4.4 0.5,-2.1 2.8,-5.9 2.8,-7.5 0,-1.1 -0.1,-3 -1.3,-3.1 -1,4.4 -2.1,4.9 -4.1,8 -1,1.5 -4.7,5.8 -4.7,7.3 v 0.4 c 0,2.4 3.1,8.1 2.7,10.5 l -0.2,1.7 c -3.5,-0.8 -8.1,-7.3 -8.1,-12 -1.4,0.1 -2.5,4.4 -2.5,6.1 v 2.9 c 0,5.7 3.3,8.3 4.2,12 -2.7,-1.4 -4,-2.2 -5.9,-4.4 -1.1,-1.2 -3.7,-5.6 -4.1,-5.9 -1.1,2.4 1.7,10.3 2.4,12.1 0.7,1.7 1.4,3.5 2.3,5 1.1,1.8 2.2,2.6 3.2,4.1 0,1.7 -0.5,2.4 -0.6,4.7 -0,1.8 -0,2.6 0.2,4.6 0.2,2.1 2.1,6.1 3.2,7.3 2.4,2.6 2.4,2.8 5.6,4.8 2,1.3 4.9,2.2 8.1,2.2 h 0.6 c 6.4,0 11.4,-3.5 14.2,-7.2 3.8,-5.2 3.8,-9.9 2.2,-16.7 3.5,-6.6 5.9,-9.3 5.9,-19.7 v -0.4 l -0.4,-4 c -0.1,0 -3.3,6.2 -3.8,7 -1,1.5 -3.7,4.8 -5.7,5 0.1,-3.2 2.1,-6.2 2.1,-9.4 v -2.2 l -1.1,-8 c -1,0.7 -1.5,5.9 -3,7.7 -0.4,0.5 -5.6,5.5 -5.6,3.6 v -1.7 c 0,-3.1 2.1,-6.3 2.1,-9 v -1.3 c 0,-0.8 -3.9,-6.5 -4.6,-6.9 0,2.3 -0.2,4.4 -0.7,6.2 -0.3,1.1 -2,3.7 -3,3.7 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 87.4,114.5 c 0,-7.4 6.1,-14 13.4,-14 h 1.1 c 7.5,0 13.6,6.6 13.6,14 0,7.1 -6.2,13.9 -13.2,13.9 h -1.9 c -6.8,-0 -13,-6.8 -13,-13.9 z"}],i["AC.IC.RADIOACTIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 83.7,130.4 c -10.1,-5.6 -16.6,-17 -16.4,-28.5 l 17.8,-0 c -0.2,5 3.1,10.7 7.5,13.1 l -9,15.4 z m 49.1,-28.2 c 0.2,11.5 -6.4,22.9 -16.4,28.5 l -9,-15.4 c 4.4,-2.4 7.7,-8.1 7.6,-13.1 l 17.8,0 z M 83.5,73.8 c 9.9,-5.9 23,-5.9 32.9,0 l -8.9,15.5 c -4.3,-2.6 -10.9,-2.6 -15.1,0 l -8.9,-15.5 z m 26.5,28.5 c 0,5.5 -4.4,9.9 -9.9,9.9 -5.5,0 -9.9,-4.4 -9.9,-9.9 0,-5.5 4.4,-9.9 9.9,-9.9 5.5,0 9.9,4.4 9.9,9.9 z"}],i["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]=[{type:"path",stroke:!1,d:"m 101.2,128.4 -2.1,0 0,12.6 2.1,0 z m 26.5,0.6 -8.7,-8.6 -1.2,1.2 8.7,8.7 z m -45,-7.5 -1.3,-1.3 -8.8,8.8 1.3,1.4 z m 55.5,-19.7 -12.2,0 0,1.9 12.2,0 z m -63.3,0 -13.1,0 0,1.9 12.8,0 z m 52.8,-25.3 -1.3,-1.2 -9,8.7 1.5,1.5 z m -46.1,9.1 1.4,-1.5 -9.3,-9.2 -0,0.2 -1.2,1.3 z m 19.5,-26.5 -2.1,0 0,9.7 2.1,0 z M 91.7,88 v 0.6 c 0,0.5 1.4,4.3 1.7,5.1 0.7,2.2 0.7,3.4 0.7,5.7 -1.2,-0.1 -4.4,-3 -5.1,-4 -1.7,-2.5 -1.7,-3.4 -2.5,-6.7 -0.9,0.7 -1.9,3.8 -1.9,5.5 v 2.3 c 0,5.6 3.6,8.4 3.8,11.1 -0.9,-0.2 -4.8,-3.2 -5.4,-3.8 -0.7,-0.8 -3.3,-5.3 -3.8,-5.4 0,3.9 1.1,6.9 2.1,9.7 0.6,1.5 1.2,2.9 1.7,4.2 0.8,2.2 1.4,2 2.6,3.5 2.9,3.6 9.4,8.3 15.7,8.3 h 0.8 c 2.2,0 6.4,-1.7 7.9,-2.6 2.4,-1.3 4.5,-2.7 6,-4.8 2.8,-3.8 5.3,-9.3 5.3,-16 v -2.7 l -0.2,-2.3 h -0.4 c -1.1,4.7 -4.2,8.4 -8,10.5 0,-3.6 1.3,-5.3 1.9,-8.4 0.4,-2.4 -1,-6.9 -1,-9.2 -0.4,0.3 -1.2,5.4 -2.5,7 -0.3,0.4 -5.1,5.2 -5.1,3.1 v -2.1 c 0,-3 1.9,-4.8 1.9,-8.2 0,-0.8 -3.5,-6 -4.1,-6.3 l 0.1,0.9 c 0,1.2 -0.4,4.1 -0.7,5 -0.2,0.5 -2.3,3 -2.6,3 -1.2,0 -2.5,-2.9 -2.5,-4.4 v -1.1 c 0,-2.9 2.8,-6.1 2.6,-8 l -0.5,-2.9 c -0.5,0.4 -1.2,3 -1.6,3.9 -0.6,1.3 -1.4,2.2 -2.2,3.2 C 95.4,82.4 91.7,87.1 91.7,88 z"}],i["AC.IC.UNEXPLODED ORDNANCE"]=a("UXO"),i["AC.IC.TOXIC INFECTIOUS MATERIAL"]=[{type:"path",stroke:!1,d:"m 104.6,116.2 c 0,-3.6 0.9,-4.6 1.5,-7.3 l -2.5,-1.2 c -2.4,2.1 -4.4,1.6 -6.8,0 l -2.5,1.4 c 0.2,2.6 2,3.9 1.5,8.7 -0.4,3.1 -1.1,5.8 -2.6,7.8 -2.9,3.9 -7,7.4 -13.7,7.4 h -1 c -4.7,0 -10.2,-3.2 -12,-6 l -1.2,0.6 c 3.3,4.9 11.4,10 19.8,10 h 0.2 c 6.4,0 10.9,-2.7 14.8,-5.3 3.7,2.5 7.6,5 13.8,5 h 3 c 3.8,0 8.2,-1.6 10.6,-3.2 1.8,-1.2 6.7,-4.5 7.2,-6.6 -1.1,-0.3 -0.5,-0.5 -1.3,-0.5 -0.5,0 -1.7,1.9 -2.2,2.3 -0.8,0.6 -1.8,1.1 -2.6,1.6 -1.4,0.9 -4.7,1.8 -7,1.8 h -1.8 c -7.9,0 -15.3,-7.7 -15.3,-15.8 v -0.8 z m 2.3,3.5 2.5,4.3 c 3.2,-0.8 7.7,-5.2 9.3,-7.8 2.2,-3.7 3.5,-7.8 3.5,-13.8 h -5.5 c 0.1,5.2 -0.1,7.2 -2.5,10.8 -1.2,1.8 -1.7,2.1 -3.2,3.6 -1,1 -3.6,2.2 -4.1,2.9 z m -28.6,-13.8 c 0,7.4 6.8,16.7 12.5,18 l 2.3,-4.5 c -6.5,-3.4 -9.5,-8 -9.5,-17.1 h -5.3 v 3.5 z m -2.5,-17 v 1 c 0,0.5 -5,3.2 -5.8,3.8 -1.6,1.1 -3.5,3.2 -4.7,4.8 -2.8,3.6 -4.8,8.1 -4.8,14.2 0,4.4 1,6 1.8,9.4 l 1.2,-0.6 c -0.1,-1.5 -0.8,-2.3 -0.8,-4 v -2 c 0,-7.8 7.9,-15.6 16,-15.6 h 1.8 c 2.6,0 5.9,1.3 7.5,2.2 2.2,1.3 3.6,3.6 5.3,4.8 l 2.3,-1 v -1.8 c 0,-2 1.6,-3.9 3.3,-4.3 v -3 c -7.6,-0.2 -15.3,-7.8 -15.3,-15.5 v -1.5 c 0,-4.1 2.1,-8.6 4.2,-10.6 1.3,-1.2 2.5,-2.3 4,-3.2 0.8,-0.5 5.1,-1.5 5.1,-2.5 v -1 c -6.6,1.6 -11.7,3.8 -15.4,8.5 -4.3,5.5 -5.7,9 -5.7,17.9 l 0,0 z m 27.6,-25.4 c 0,0.6 4.2,2.1 5,2.5 1.2,0.6 3.5,2.4 4.2,3.5 2.1,2.9 4.3,6 4.3,11 0,8.2 -7.4,16.3 -15.6,16.3 v 3 c 2.3,0.2 4.4,3.4 3.3,5.8 0.6,0.2 2.5,1.2 2.5,1.2 0.7,0 5,-7 14.3,-7 h 0.2 c 4.5,0 9,2.6 11.1,5 1.7,1.9 5.3,7.6 4.8,11.4 l -0.8,5.5 1.2,0.6 c 0.1,-0.9 0.8,-2.3 1.1,-3.6 0.3,-1.2 0.4,-3 0.4,-4.4 v -3.3 c 0,-8.4 -8.3,-18.8 -15,-20.3 0,-5 0.4,-6.4 -0.9,-10.9 -0.9,-2.8 -2.6,-6.4 -4.3,-8.3 -5.1,-5.3 -7.5,-7 -15.9,-9 v 1 l -4e-4,0 z m -15.8,22.6 2.8,4.8 c 3,-1.6 4.8,-3.3 9.5,-3.3 h 0.5 c 5.8,0 6.9,2.6 9.7,3.2 l 2.6,-4.7 c -9.5,-5 -15.7,-5 -25.1,0 z"}],i["AC.IC.TOXIC GAS"]=[{type:"path",stroke:!1,fill:!!R&&G,d:"m 90.2,102.3 c 0.6,-1.9 5.7,-1.9 11.3,-0 5.6,1.9 9.6,4.9 9,6.8 -0.6,1.9 -5.7,1.9 -11.3,0 -5.6,-1.9 -9.6,-4.9 -9,-6.8 z m 7.7,-22.2 c 10e-7,3.7 -1.7,6.7 -3.8,6.7 -2.1,-2e-6 -3.8,-3 -3.8,-6.7 2e-6,-3.7 1.7,-6.7 3.8,-6.7 2.1,0 3.8,3 3.8,6.7 z m 17,2.2 c 0,4.1 -2.8,7.3 -6.3,7.3 -3.5,2e-6 -6.3,-3.3 -6.3,-7.3 0,-4.1 2.8,-7.3 6.3,-7.3 3.5,0 6.3,3.3 6.3,7.3 z m -7.9,49.6 c -1,2.9 -8.5,2.9 -16.6,0 -8.2,-2.9 -13.9,-7.6 -12.9,-10.5 1,-2.9 8.5,-2.9 16.6,-0 8.2,2.9 13.9,7.6 12.9,10.5 z"},{type:"path",stroke:!1,d:"M 107.5 64.3 C 102.2 64.2 96.9 67.1 92.8 71.6 C 90.6 73.6 89.2 76.8 89.2 80.4 C 89.2 83 90 85.4 91.2 87.3 C 92.1 89.9 92.7 91.8 92.7 94.5 L 92.4 96.7 L 90.7 101.6 C 92.3 100.5 96.7 100.7 101.5 102.3 C 106.6 104 110.4 106.7 110.5 108.6 L 112 104.2 C 115.9 104 120.5 96.9 122.7 87.6 C 124.9 77.9 123.5 69.3 119.8 67.9 C 118.4 66.6 116.1 65.5 112.8 65.3 C 111.1 64.6 109.3 64.3 107.5 64.3 z M 94.1 73.4 C 94.4 73.4 94.6 73.4 94.8 73.5 C 95.1 73.6 95.3 73.8 95.6 73.9 C 96.2 74.4 96.8 75.3 97.2 76.3 C 97.5 77.1 97.7 77.9 97.8 78.7 C 97.9 79.2 97.9 79.6 97.9 80.1 C 97.9 80.5 97.9 81 97.8 81.4 C 97.7 82.3 97.5 83.1 97.2 83.8 C 96.9 84.7 96.4 85.4 95.9 85.9 C 95.6 86.2 95.2 86.5 94.8 86.6 C 94.7 86.6 94.6 86.7 94.5 86.7 C 94.3 86.7 94.2 86.7 94.1 86.7 C 93.8 86.7 93.6 86.7 93.3 86.6 C 93 86.5 92.6 86.2 92.3 85.9 C 92.2 85.8 92.1 85.7 92 85.6 C 91.6 85.1 91.2 84.5 91 83.8 C 90.8 83.4 90.7 83.1 90.6 82.7 C 90.4 81.9 90.3 81 90.3 80.1 C 90.3 79.1 90.4 78.3 90.6 77.5 C 90.7 77.1 90.8 76.7 91 76.3 C 91.2 75.6 91.6 75 92 74.5 C 92.2 74.3 92.4 74.1 92.6 73.9 C 92.9 73.8 93.1 73.6 93.3 73.5 C 93.6 73.4 93.8 73.4 94.1 73.4 z M 108.6 75 C 110.4 75 112.1 75.9 113.3 77.3 C 113.3 77.4 113.4 77.5 113.5 77.6 C 113.5 77.6 113.5 77.6 113.5 77.7 C 113.6 77.8 113.7 78 113.8 78.2 C 113.8 78.3 113.9 78.3 113.9 78.4 C 114 78.5 114 78.5 114 78.6 C 114.1 78.7 114.2 78.8 114.2 79 C 114.3 79.1 114.3 79.3 114.4 79.4 C 114.4 79.5 114.5 79.5 114.5 79.6 C 114.5 79.7 114.6 79.9 114.6 80 C 114.6 80.1 114.6 80.2 114.7 80.3 C 114.7 80.4 114.7 80.6 114.8 80.8 C 114.9 81.3 114.9 81.8 114.9 82.3 C 114.9 84.6 114 86.6 112.6 88 C 112 88.6 111.3 89 110.5 89.3 C 110.3 89.4 110.1 89.5 109.9 89.5 C 109.5 89.6 109 89.7 108.6 89.7 C 108.2 89.7 107.7 89.6 107.3 89.5 C 107.3 89.5 107.3 89.5 107.3 89.5 C 107.1 89.5 106.9 89.4 106.7 89.3 C 105.9 89 105.2 88.6 104.6 88 C 104 87.4 103.5 86.6 103.1 85.8 C 102.9 85.4 102.7 85 102.6 84.5 C 102.5 84.3 102.5 84 102.4 83.8 C 102.4 83.5 102.4 83.3 102.3 83.1 C 102.3 82.8 102.3 82.6 102.3 82.3 C 102.3 82 102.3 81.8 102.3 81.5 C 102.3 81.5 102.4 81.5 102.4 81.4 C 102.4 81 102.5 80.5 102.6 80.1 C 102.6 80.1 102.6 80.1 102.6 80 C 103.4 77.1 105.8 75 108.6 75 z M 88.8 104 C 86.6 104 84.8 104.4 83.9 105.2 L 83.8 105.2 L 83.7 105.3 C 83.4 105.6 83.2 105.9 83.1 106.2 C 83 106.5 83 106.8 83 107.2 L 78.1 120.5 C 80.2 118.5 86.9 118.7 94.2 121.3 C 101.2 123.8 106.4 127.7 107.1 130.6 L 111.8 117.8 C 112.2 117.5 112.5 117.2 112.7 116.8 C 113.7 113.8 107.9 109.1 99.8 106.2 C 95.7 104.8 91.8 104 88.8 104 z M 82 120.8 C 79 120.8 76.9 121.5 76.4 123 C 75.4 125.9 81.1 130.7 89.3 133.6 C 97.4 136.5 104.9 136.5 105.9 133.6 C 107 130.6 101.2 125.9 93 123 C 89 121.5 85 120.8 82 120.8 z M 86.1 125.6 C 87.4 125.5 89.4 125.9 91.5 126.6 C 94.8 127.8 97.2 129.6 96.9 130.6 C 96.5 131.6 93.5 131.5 90.1 130.3 C 86.8 129.1 84.4 127.3 84.7 126.3 C 84.9 125.9 85.4 125.7 86.1 125.6 z "}],i["AC.IC.AFTERSHOCK"]=[{type:"path",stroke:!1,d:"m 99,62.5 -0,0 -0,0 -0.9,0 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.2 -0,0 -0,0 -0.7,0.1 0.6,2.7 0.7,-0.1 0,-0 0.8,-0.1 0,-0 0.8,-0.1 0,0 0.8,-0.1 0,0 0.9,-0.1 0,0 0.9,-0.1 0,0 0.9,-0.1 0,0 0.9,-0 0,0 0.9,-0 0,0 0,0 0.9,0 0,0 0.9,0 0,0 0.1,0 0.2,-2.8 -0.1,-0 -0,0 -0,0 -0.9,-0 -0,0 -0,0 -1,-0 -0,0 -0,0 z m 8.8,3.6 0.2,0 0,0 0.8,0.2 0,0 0.8,0.2 0,0 0.8,0.2 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.4 0,0 0,0 0.7,0.4 0,0 0.1,0 1.3,-2.5 -0.1,-0.1 -0,-0 -0,0 -0.8,-0.4 -0,-0 -0,0 -0.8,-0.4 -0,0 -0,-0 -0.8,-0.4 -0,-0 -0,0 -0.8,-0.4 -0,0 -0,-0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 -0,0 -0,-0 -0.9,-0.3 -0,0 -0,0 -0.9,-0.3 -0,0 -0,0 -0.9,-0.2 -0,0 -0,-0 -0.9,-0.2 -0,0 -0,0 -0.2,-0.1 z m -22.7,-0.7 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.5 -0,0 -0,0 -0.8,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.1,0.1 1.7,2.2 0.1,-0.1 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0,0 0.8,-0.4 0,-0 0.8,-0.3 0,-0 0.8,-0.3 0,-0 0.3,-0.1 -1,-2.6 z m 36.9,7.3 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0.6,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.4,0.5 2.3,-1.7 -0.4,-0.6 -0,-0 0,-0 -0.6,-0.7 -0,-0 0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,0 -0.7,-0.6 -0,-0 -0,0 -0.7,-0.6 -0,-0 -0,-0 -0.7,-0.6 -0,-0 -0,-0 -0.6,-0.5 z m -51,2.7 -0,0 -0,0 -0.6,0.7 -0,0 -0,0 -0.6,0.7 0,0 -0,0 -0.6,0.7 0,0 -0,0 -0.5,0.7 -0,0 -0,0 -0.5,0.7 -0,0 -0,0 -0.5,0.7 -0,0 0,0 -0.5,0.7 -0,0 0,0 -0.5,0.8 0,0 -0,0 -0.4,0.8 -0,0 0,0 -0.4,0.8 0,0 -0,0 -0.3,0.6 2.5,1.3 0.3,-0.6 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.6 0,-0 0.5,-0.6 0,-0 0.5,-0.6 0,-0 0.5,-0.5 -2.1,-1.9 z m 60.9,9.4 0.1,0.1 0,0 0,0 0.3,0.7 0,0 0.3,0.7 0,0 0.3,0.8 0,0 0.3,0.8 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0,0.2 2.8,-0.5 -0,-0.3 -0,-0 0,-0 -0.2,-0.9 0,-0 0,-0 -0.2,-0.9 0,-0 -0,-0 -0.2,-0.9 0,-0 -0,-0 -0.2,-0.9 0,-0 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 -0,-0 -0,-0 -0.4,-0.8 -0,-0 0,-0 -0.1,-0.2 z m -68.8,4.9 -0,0 0,0 -0.2,0.9 -0,0 0,0 -0.2,0.9 -0,0 0,0 -0.2,0.9 0,0 0,0 -0.2,0.9 0,0 -0,0 -0.1,0.9 0,0 0,0 -0.1,0.9 -0,0 0,0 -0.1,0.9 0,0 -0,0 -0.1,0.9 0,0 0,0 -0.1,0.9 0,0 0,0 -0,0.9 0,0 0,0 -0,0.9 0,0 0,0 0,0 1.4,-0 0.3,0 1.1,0 0,-0 0,-0.9 0,-0 0,-0.9 -0,0 0.1,-0.8 0,-0 0.1,-0.9 -0,0 0.1,-0.9 0.1,-0.9 -0,0 0.1,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.1,-0.2 -2.7,-0.8 z m 73,10.3 -0.6,0 0,0 0,0 -0,0.9 0,0 -0,0.9 0,0 -0.1,0.8 0,0 -0.1,0.9 0,0 -0.1,0.9 -0.1,0.9 0,0 -0.1,0.8 0,0 -0.2,0.8 -0,0 -0.2,0.8 -0,0 -0.2,0.8 0,0 -0.2,0.8 -0,0 -0.1,0.2 2.7,0.8 0.1,-0.2 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0,-0.9 0,-0 0,-0 0,-0.9 -1.4,-0 1.4,-0 0,-0 z m -73.9,6.4 0,0.3 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.4,0.8 0,0 0,0 0.1,0.2 2.5,-1.3 -0.1,-0.1 -0,-0 -0.3,-0.7 -0,-0 -0.3,-0.7 -0,-0 -0.3,-0.8 -0,-0 -0.3,-0.8 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 -0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 0,-0 -0,-0.2 z m 69.4,9.4 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.6 -0,0 -0.5,0.6 -0,0 -0.5,0.6 -0,0 -0.5,0.6 2.1,1.9 0.5,-0.6 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.8 0,-0 0,-0 0.4,-0.8 0,-0 0,-0 0.4,-0.8 0,-0 0,-0 0.3,-0.6 -2.5,-1.3 z m -62.8,6.1 0.4,0.6 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.6,0.5 1.7,-2.2 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0.6,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.4,-0.5 z m 53.1,5.4 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0.8,0.3 -0,0 -0.8,0.3 -0,0 -0.3,0.1 1,2.6 0.4,-0.1 0,-0 0,0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,-0 0,0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,-0 0,0 0.8,-0.5 0,0 0,-0 0.8,-0.5 0,-0 0,0 0.7,-0.5 0,0 0,-0 0.7,-0.5 0,-0 0,0 0.7,-0.5 0,-0 0,-0 0.7,-0.5 0,-0 0,-0 0.1,-0.1 -1.7,-2.2 z m -40.4,5.6 0.1,0.1 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0,0 0.9,0.3 0,0 0,0 0.9,0.3 0,0 0,0 0.9,0.2 0,0 0,0 0.9,0.2 0,0 0,0 0.2,0.1 0.6,-2.7 -0.2,-0 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.4 -0,0 -0,-0 -0.7,-0.4 -0,-0 -0.1,-0 z m 25.6,1.1 -0,0 -0.8,0.1 -0,0 -0.8,0.1 -0,0 -0.8,0.1 0,-0 -0.9,0.1 0,-0 -0.9,0.1 -0,0 -0.9,0.1 -0,0 -0.9,0 -0,0 -0.9,0 -0,0 -0,0 -0.9,-0 -0,0 -0.9,-0 -0,0 -0.1,0 -0.2,2.8 0.1,0 0,0 0,0 0.9,0 0,0 0,0 1,0 0,0 0,0 1,-0 0,0 0,0 0.9,-0 0,0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.1 0,-0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.1 0,-0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.2 0,0 0,0 0.7,-0.1 -0.6,-2.7 z m -7.2,-58.9 -0,1.2 0.1,0 0,0 1.3,0 0,-0 1.3,0.1 1.1,0.1 0.1,0 0,0 1.1,0.2 0.1,0 0.7,0.1 0.7,-3.1 -0.7,-0.2 -0,0 -0,-0 -1.3,-0.2 -0,0 -0,-0 -1.3,-0.2 -0,0 -0,0 -1.3,-0.1 -0,0 -0.1,0 -1.3,-0 -0,0 -0,0 -0,0 z m -5.5,-1.4 -0,0 -0,0 -1.3,0.3 -0,0 -0,0 -1.2,0.3 -0,0 -0,0 -1.2,0.4 -0,0 -0,0 -0.9,0.3 1.1,3 0.8,-0.3 0.1,-0 0,0 1.1,-0.4 0,-0 1.1,-0.3 1.2,-0.3 0.1,-0 1.1,-0.2 -0.6,-3.1 z m 14.8,4.4 0.2,0.1 0.1,0 1.1,0.5 1,0.5 0.1,0 1,0.5 0,0 0,0 0.9,0.6 0.1,0 0.5,0.4 1.8,-2.6 -0.6,-0.4 -0,-0 -0,-0 -1.1,-0.7 -0,-0 -0,-0 -1.1,-0.6 -0,-0 -0,-0 -1.1,-0.6 -0,-0 -0,-0 -1.1,-0.5 -0,-0 -0,-0 -0.3,-0.1 z m -23.6,-1.1 -0,0 -0,0 -1.1,0.7 -0,0 -0,0 -1,0.7 -0,0 -0,0 -1,0.8 -0,0 -0,0 -0.9,0.8 -0,0 -0,0 -0.8,0.7 2.2,2.4 0.7,-0.7 0.1,-0.1 0.8,-0.7 0,-0 0,-0 0.9,-0.7 0.1,-0 0.9,-0.6 0.1,-0 0.9,-0.6 0,-0 0,-0 -0.4,-0.6 -1.2,-2.2 z m 31.5,6.2 0.1,0.1 0,0 0,0 0.8,0.8 0.1,0.1 0.7,0.8 0.1,0.1 0.7,0.8 0,0 0,0.1 0.6,0.9 0,0.1 0,0 0.5,0.7 2.7,-1.8 -0.5,-0.8 -0,-0 -0,-0 -0.7,-1 -0,-0 -0,-0 -0.8,-0.9 -0,-0 -0,-0 -0.8,-0.9 -0,-0 -0,-0 -0.9,-0.9 -0,-0 -0,-0 -0.1,-0.1 z m -40.1,1.8 -0,0 -0,0 -0.7,1 -0,0 -0,0 -0.6,1.1 -0,0 -0,0 -0.6,1.1 -0,0 -0,0 -0.5,1.1 -0,0 -0,0 -0,0.1 2.4,1 0.5,0.3 0,-0 0.5,-1 0,-0.1 0,-0 0.5,-0.9 0,-0.1 0.6,-0.9 0.6,-1 0,-0 0,-0.1 0.6,-0.8 -2.6,-1.9 z m 45.4,5.9 0.4,1.1 0,0.1 0.3,1 0,0.1 0.3,1.1 0.3,1.1 0.2,1 3.1,-0.6 -0.2,-1.1 0,-0 -0,-0 -0.3,-1.2 -0,-0 -0,-0.1 -0.3,-1.2 -0,-0 -0,-0 -0.4,-1.2 -0,-0 -0,-0 -0.5,-1.1 z m -49.6,3.8 -0,0 0,0 -0.2,1.3 0,0 -0,0 -0.2,1.3 -0,0 0,0 -0.1,1.3 0,0 0,0.1 -0,1.3 0,0 0,0 0,0 1.9,-0 1.3,0 0,-0.1 0,-0 0,-1.2 0.1,-1.1 0,0 0.1,-1.2 0,-0.1 0,-0 0.2,-1.1 0.2,-0.9 -3.1,-0.7 z m 52.8,5.5 -1.2,-0 0,0.1 0,0 -0,1.2 -0.1,1.1 -0,0 -0.1,1.2 0,0 -0,0.1 -0.2,1.1 -0.2,0.9 3.1,0.8 0.2,-0.9 0,-0 0,-0 0.2,-1.3 0,-0 0,-0 0.2,-1.3 0,-0 0,-0 0.1,-1.3 0,-0 0,-0.1 0,-1.3 -1.6,-0 1.6,-0 0,-0 z m -53,4.3 0.2,1.1 0,0 0,0 0.3,1.2 0,0 0,0.1 0.3,1.2 0,0 0,0 0.4,1.2 0,0 0,0 0.5,1.1 3,-1.2 -0.4,-1 -0,-0.1 -0.3,-1 -0,-0.1 -0.3,-1.1 -0.3,-1.1 -0.2,-1 z m 49.9,4.9 -0.5,1 -0,0.1 -0,0 -0.5,1 -0,0.1 -0.6,0.9 -0.6,1 -0,0 -0,0.1 -0.6,0.8 2.6,1.9 0.6,-0.9 0,-0 0,-0 0.7,-1 0,-0 0,-0 0.6,-1.1 0,-0 0,-0 0.6,-1.1 0,-0 0,-0 0.5,-1.1 0,-0 0,-0 0,-0 -2.2,-0.9 -0.8,-0.3 z m -46,5 0.5,0.8 0,0 0,0 0.7,1 0,0 0,0 0.8,0.9 0,0 0,0 0.8,0.9 0,0 0,0 0.9,0.9 0,0 0,0 0.1,0.1 2.2,-2.3 -0.1,-0.1 -0,-0 -0,-0 -0.8,-0.8 -0.1,-0.1 -0.7,-0.8 -0.1,-0.1 -0.7,-0.8 -0,-0 -0,-0.1 -0.6,-0.9 -0.1,-0.1 -0.5,-0.7 z m 40,3.3 -0.1,0.1 -0.8,0.7 -0,0 -0,0 -0.9,0.7 -0.1,0 -0.9,0.6 -0.1,0 -0.9,0.6 0,-0 -0.1,0 0,0 -0,0 0.3,0.4 1.3,2.4 0,-0 0,-0 0,-0 1.1,-0.7 0,-0 0,-0 1,-0.7 0,-0 0,-0 1,-0.8 0,-0 0,-0 0.9,-0.8 0,-0 0,-0 0.8,-0.7 -2.2,-2.4 z m -32.6,4.4 0.6,0.4 0,0 0,0 1.1,0.7 0,0 0,0 1.1,0.6 0,0 0,0 1.1,0.6 0,0 0,0 1.1,0.5 0,0 0,0 0.3,0.1 1.1,-3 -0.2,-0.1 -0.1,-0 -1.1,-0.5 -1,-0.5 -0.1,-0 -1,-0.6 0,0 -0.9,-0.6 -0.1,-0 -0.5,-0.4 z m 24.5,0.3 -0.1,0 -1.1,0.3 -0.1,0 -1.1,0.3 -1.2,0.3 -0.1,0 -1.1,0.2 0.6,3.1 1.2,-0.2 0,0 0,-0 1.3,-0.3 0,0 0,-0 1.2,-0.3 0,-0 0,-0 1.2,-0.4 0,-0 0,-0 0.9,-0.3 -1.1,-3 z m -14.8,3.9 0.7,0.2 0,0 0,0 1.3,0.2 0,0 0,0 1.3,0.2 0,0 0,0 1.3,0.1 0,0 0.1,0 1.3,0 0,0 0,0 0,0 -0.1,-1.6 0,-0.1 0,-1.5 -0.1,0 -1.3,-0 0,0 -1.3,-0.1 -1.1,-0.1 -0.1,-0 -0,0 -1.1,-0.2 -0.1,-0 -0.7,-0.1 z m 6.3,-43.1 -0.4,0 0.1,4 0.3,-0 0.1,0 0.1,0 0.6,0 0.1,0 0.6,0 0.1,0 0.6,0.1 0.1,0 0.6,0.1 0.7,0.1 0.1,0 0.1,0 0.6,0.2 0.5,0.2 0.1,0 0.5,0.2 0.1,0 0,0 0.5,0.2 0.1,0 0.4,0.2 1.8,-3.6 -0.5,-0.3 -0,-0 -0.1,-0 -0.7,-0.3 -0.1,-0 -0.1,-0 -0.7,-0.3 -0,-0 -0.1,-0 -0.7,-0.2 -0.1,-0 -0,-0 -0.7,-0.2 -0.1,-0 -0.1,-0 -0.7,-0.2 -0.1,-0 -0.1,-0 -0.8,-0.1 -0,-0 -0.1,-0 -0.8,-0.1 -0.1,-0 -0.1,0 -0.8,-0.1 -0.1,0 -0.1,0 -0.8,-0 -0.1,-0 z m -5.1,0.7 -0.1,0 -0,0 -0.7,0.2 -0.1,0 -0.1,0 -0.7,0.3 -0,0 -0.1,0 -0.7,0.3 -0.1,0 -0,0 -0.7,0.3 -0,0 -0,0 -0.7,0.4 -0,0 -0.1,0 -0.6,0.4 -0,0 -0,0 -0.6,0.4 -0,0 -0,0 -0.6,0.4 -0,0 -0,0 -0.6,0.5 -0,0 -0,0 -0.5,0.5 -0,0 -0,0 -0.2,0.2 2.9,2.8 0.1,-0.1 0.1,-0.1 0.4,-0.4 0.1,-0.1 0.4,-0.3 0,-0 0.1,-0.1 0.4,-0.3 0.5,-0.4 0.1,-0.1 0.6,-0.3 0,-0 0.5,-0.3 0.1,-0 0.5,-0.3 0.1,-0 0.5,-0.2 0,0 0.1,-0 0.6,-0.2 0,-0 0.5,-0.2 0.1,-0 0.1,-0 -1.1,-3.9 z m 14.2,6.7 0.4,0.3 0.5,0.5 0.1,0.1 0.3,0.4 0.1,0.1 0.3,0.4 0.1,0.1 0.3,0.4 0,0 0,0.1 0.3,0.4 0.1,0.1 0.3,0.5 0,0 0,0.1 0.3,0.5 0,0.1 0.2,0.5 0,0.1 0.2,0.5 0,0.1 0,0 0.2,0.6 3.8,-1.3 -0.2,-0.7 -0,-0.1 -0,-0.1 -0.3,-0.7 -0,-0.1 -0,-0 -0.3,-0.7 -0,-0.1 -0,-0 -0.3,-0.7 -0,-0.1 -0,-0 -0.4,-0.6 -0,-0 -0,-0.1 -0.4,-0.6 -0,-0 -0,-0.1 -0.4,-0.6 -0,-0.1 -0,-0 -0.5,-0.6 -0,-0 -0,-0 -0.5,-0.5 -0,-0 -0,-0 -0.5,-0.5 -0,-0 -0,-0 -0.5,-0.4 z m -24.4,1.4 -0,0 -0,0.1 -0.3,0.7 -0,0 -0,0.1 -0.3,0.7 -0,0 -0,0.1 -0.3,0.7 -0,0.1 -0,0.1 -0.2,0.7 -0,0.1 -0,0.1 -0.2,0.7 -0,0.1 0,0.1 -0.2,0.7 -0,0.1 -0,0.1 -0.1,0.7 -0,0.1 0,0.1 -0.1,0.8 0,0.1 -0,0.1 -0.1,0.8 0,0.1 0,0.1 -0,0.8 0,0.1 0,0.1 0,0.3 4,-0.1 -0,-0.2 0,-0.1 0,-0 0,-0.7 0,-0.6 0,-0.1 0,-0 0.1,-0.5 0.1,-0.6 0,-0.1 0.1,-0.5 0,-0 0,-0.1 0.1,-0.5 0.2,-0.6 0,-0.1 0,-0 0.2,-0.5 0.3,-0.6 0.1,-0.1 0.3,-0.5 0,-0.1 0,-0 0,-0 -3.5,-2 z m 28.7,7.6 0,0.5 0,0.1 0,0 -0,0.6 -0.1,0.7 -0,0.1 0,0.1 -0.1,0.6 -0.1,0.5 -0,0.1 -0.1,0.5 0,0 -0,0.1 -0.1,0.5 -0,0.1 -0.2,0.5 -0,0 -0,0.1 -0.2,0.5 -0,0 -0,0.1 -0.2,0.5 -0,0.1 -0.3,0.5 -0,0.1 -0,0 -0.2,0.3 3.5,2 0.2,-0.4 0,-0.1 0,-0 0.3,-0.7 0,-0 0,-0.1 0.3,-0.7 0,-0 0,-0.1 0.3,-0.7 0,-0.1 0,-0.1 0.2,-0.7 0,-0 0,-0.1 0.2,-0.7 0,-0.1 0,-0.1 0.2,-0.7 0,-0.1 0,-0.1 0.1,-0.7 0,-0.1 0,-0.1 0.1,-0.8 0,-0.1 0,-0.1 0.1,-0.8 0,-0.1 0,-0.1 0,-0.8 -2,-0.1 2,-0.1 -0,-0.6 z m -30.1,5.3 0.1,0.3 0,0.1 0,0 0.2,0.7 0,0.1 0,0.1 0.3,0.7 0,0.1 0,0 0.3,0.7 0,0.1 0,0 0.3,0.7 0,0 0,0.1 0.4,0.6 0,0 0,0.1 0.4,0.6 0,0 0,0 0.4,0.6 0,0 0,0 0.5,0.6 0,0 0,0 0.5,0.5 0,0 0,0 0.5,0.5 0,0 0,0 0.2,0.2 2.7,-2.9 -0.2,-0.1 -0.1,-0.1 -0,-0 -0.4,-0.4 -0.1,-0.1 -0.4,-0.4 -0,-0.1 -0,-0 -0.3,-0.4 -0.1,-0.1 -0.4,-0.5 -0.3,-0.4 -0.1,-0.1 -0.3,-0.5 -0,-0 -0,-0.1 -0.3,-0.5 -0.1,-0.1 -0.2,-0.5 -0,-0.1 -0,-0 -0.2,-0.5 -0,-0.1 -0,-0.1 -0.2,-0.6 -0,-0.1 z m 25.8,4.8 -0.1,0.1 -0.4,0.3 -0,0 -0.1,0.1 -0.4,0.3 -0.1,0.1 -0.5,0.3 -0,0 -0.1,0 -0.5,0.3 -0.1,0 -0,0 -0.6,0.3 -0.5,0.3 -0.1,0 -0.5,0.2 -0,0 -0.1,0 -0.5,0.2 -0.1,0 -0.5,0.2 -0.5,0.1 1.1,3.9 0.5,-0.1 0,-0 0.1,-0 0.7,-0.2 0.1,-0 0,-0 0.7,-0.3 0.1,-0 0.1,-0 0.7,-0.3 0.1,-0 0,-0 0.7,-0.3 0.1,-0 0,-0 0.7,-0.4 0,-0 0,-0 0.6,-0.4 0,-0 0.1,-0 0.6,-0.4 0,-0 0,-0 0.6,-0.5 0,-0 0,-0 0.6,-0.5 0,-0 0,-0 0.5,-0.5 -2.7,-2.9 z m -15.5,1.8 -1.9,3.5 0.1,0.1 0,0 0,0 0.7,0.3 0,0 0.1,0 0.7,0.3 0.1,0 0,0 0.7,0.3 0.1,0 0.1,0 0.7,0.2 0,0 0.1,0 0.7,0.2 0,0 0.1,0 0.8,0.2 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0 0.1,0 0.1,0 0.1,0 -0.1,-4 -0.1,0 -0.1,0 -0.6,-0 -0.1,0 -0.6,-0 0,-0 -0.7,-0.1 -0,0 -0.1,-0 -0.6,-0.1 -0.1,-0 -0.6,-0.1 0,-0 -0.7,-0.2 -0.5,-0.2 0,-0 -0.6,-0.2 -0.1,-0 -0,0 -0.5,-0.2 -0.1,-0 -0.5,-0.3 -0.1,-0.1 z M 100,93.2 c -3.5,-4e-4 -6.7,2.9 -6.7,6.5 l 0,0.4 c 0,3.5 3,6.5 6.5,6.5 l 0.4,0 c 3.4,0 6.5,-3 6.5,-6.3 l 0,-0.9 c 0,-3.4 -3.3,-6.3 -6.8,-6.3 z"}],i["AC.IC.AVALANCHE"]=[{type:"path",stroke:!1,d:"m 115.7,87.3 -3.6,0.9 11,38 -4.6,1.5 9.6,9.2 3.1,-13 -4.6,1.4 z m 3,46.4 -8.5,-10 4.3,-1.2 -11.2,-40.6 -34.5,51.9 z m -12.1,-59.8 0,8.4 1.6,0 0,-8.3 7.1,4.3 0.8,-1.3 -7.4,-4.1 7.5,-4.4 -1,-1.2 -7,4 0,-8.2 -1.6,0 0,8.2 -7.4,-4 -0.6,1.1 7.2,4.4 -7.2,4.1 0.6,1.4 z"}],i["AC.IC.EARTHQUAKE EPICENTER"]=[{type:"path",stroke:!1,d:"m 62.8,99.8 c 0,-10.8 4.9,-20.2 10.3,-25.7 5.1,-5.1 14.8,-11.3 24.7,-11.3 h 4.1 c 4.9,0 10.5,1.9 13.9,3.6 5,2.5 6.4,4 10.4,7 4.6,3.6 11.1,15.4 11.1,23.8 v 5.3 c 0,17.4 -17.5,34.6 -35.1,34.6 h -4.6 c -10.3,0 -19.4,-6.2 -24.6,-11.4 -5.5,-5.4 -10.3,-15 -10.3,-25.8 z m 39.4,38.5 c 10.7,0 20,-6.3 25.5,-11.8 6.7,-6.7 9.9,-13.9 10.7,-26.5 1.3,-19.2 -17.7,-38.1 -36.2,-38.1 h -4.8 c -10.3,0 -20.1,6.6 -25.2,12.1 -3,3.2 -5.6,6.7 -7.5,11.1 -1.1,2.8 -3.5,11.3 -3,15.3 0.7,6.4 0.9,10.4 3.4,15.3 2.2,4.4 4,7.6 7.3,11 5,5.3 15.2,11.7 25.3,11.7 h 4.6 z m -3.9,-11.6 c -13.6,0 -24.7,-13.1 -25.2,-26.8 -0.5,-13.2 12.5,-26.4 25.4,-26.4 h 2.9 c 12.8,0 25.2,12.4 25.2,25.2 v 2.4 c 0,12.8 -12.4,25.7 -25.2,25.7 h -3.1 v -0 z m -27.1,-26.9 c 0,8.8 3.7,16 8.1,20.5 2.3,2.4 5.2,4.4 8.3,5.9 4.2,2.2 6.3,1.9 11.5,2.8 2.9,0.5 10,-1.3 12,-2.2 4.6,-2.2 5,-2.9 8.6,-5.6 4.3,-3.1 9.1,-12.3 9.1,-19.7 v -3.4 c 0,-13.7 -13.6,-26.8 -27.3,-26.8 h -3.2 c -14.5,-4e-4 -27.1,13.6 -27.1,28.5 z m 28.5,14.8 c -8.4,0 -13.5,-6.5 -14.4,-14.4 -0.7,-7.3 6.8,-14.6 13.9,-14.6 h 1.7 c 7.3,0 13.6,6.9 13.6,14.5 0,7.7 -6.2,14.5 -13.8,14.5 h -1 z m -18.6,-14.8 c 0,11.5 8,18.1 18.4,19.3 6.2,0.8 10.3,-2.9 13.6,-5.3 2.8,-2 5.8,-8.3 5.8,-13.3 V 99.8 c 0,-10.4 -8.3,-18.6 -18.6,-18.6 h -0.7 c -9.9,0 -18.4,8.6 -18.4,18.6 z m 10.9,0 v 0.2 c 0,3.7 3.5,7.7 7,7.7 h 1.7 c 3.9,0 7.3,-3.9 7.3,-7.7 0,-4 -3.5,-8 -7,-8 h -1.7 c -3.5,0 -7.3,4 -7.3,7.7 z"}],i["AC.IC.LANDSLIDE"]=[{type:"path",stroke:!1,d:"m 129.4,110.8 c -2.7,0 -6.2,4.1 -4.3,5.1 -1,1.5 -3.6,2 -3.6,4 0,1.8 2.6,4.7 3.4,6.2 1.1,2 3.2,3.2 6.2,3.2 h 1.8 c 2.7,0 4.6,-2.6 4.6,-5.3 v -1 c 0,-3.4 -1,-5 -2.1,-7.5 -1,-2.4 -1.6,-4.6 -4.9,-4.6 h -1 z m -22.2,-35 -5.3,-5.2 -39.3,58.3 55.8,0.1 v -1.2 c 0,-0.7 -1,-1.5 -1.5,-1.8 0,-2 -0.6,-1.6 -0.9,-2.9 -0.2,-0.9 -0.1,-2.7 -0.1,-3.7 0,-2.8 -0.1,-4.3 -1.7,-5.6 -2.2,-1.9 -1.3,-1.5 -4.3,-3.1 -2,-1 -1.5,-2.1 -5.2,-2.2 v -1.5 c 0,-1.9 -2,-3.6 -2.8,-4.8 0,-2.3 -0.5,-4.7 -0.5,-6.8 0,-1.6 -0.2,-2 -0.2,-3.3 -0.1,-1.7 -0.8,-1.5 -0.8,-2.8 v -0.2 c 0,-3 0.5,-4.5 2.1,-6 2.2,-2.1 0.9,-2.2 3.8,-3.9 l 0.8,-3.3 0,0 z m 9.7,34 c 0,3.6 6.1,2.8 6.1,-0.8 0,-4.2 -6.1,-1.9 -6.1,0.8 z m 2.8,-16.4 c -2.2,0 -7,6.4 -4,8.6 1.7,1.2 2.6,1.6 5.3,0.6 2,-0.8 2.8,-1.6 2.8,-4.3 4e-4,-2.4 -2,-4.8 -4,-4.8 z m -8.4,5.3 c 0.8,0 1,-0.7 1.3,-1.3 -0.6,-1.4 -0.5,-2.5 -2.6,-2.5 h -0.2 c -1,0 -2,0.6 -2,1.5 0,0.7 1.6,2.3 2.8,2.3 h 0.8 z m -3.3,-13.7 c -0.1,1 -0.3,0.6 -0.3,1.5 0,1 0.8,3 1.8,3 h 0.2 c 3.1,0 3.1,-0.2 4.8,-1.5 -1,-2.3 -0.4,-3.6 -4.2,-3.6 -1.1,0 -1.4,0.3 -2.3,0.5 z"}],i["AC.IC.SUBSIDENCE"]=[{type:"path",stroke:!1,d:"m 56.8,75.6 0,2 14.4,0 3.8,7.9 c -0.1,0.3 -0.3,0.7 -0.3,1.6 l 0,0.6 c 0,0.7 0.3,1.1 0.7,1.5 0.3,0.4 0.7,0.8 1.1,1.3 0.7,0.8 1.5,1.5 1.8,2 l -0.3,4.1 c -0.1,1 0.4,2 1,2.6 0.6,0.6 1.3,1.1 2,1.5 0.7,0.4 1.3,0.8 1.7,1.2 0.4,0.4 0.6,0.6 0.6,1 0,1.3 -0.5,2.2 -0.5,4.2 0,0.9 0.5,1.7 1.1,2.1 0.6,0.4 1.2,0.7 1.8,0.9 0.6,0.2 1.1,0.4 1.4,0.6 0.3,0.2 0.3,0.2 0.3,0.3 0,0.6 -0.1,0.8 -0.3,1.2 -0.2,0.3 -0.5,0.7 -0.5,1.5 l 0,0.6 c 0,1.8 1,2.9 1.9,3.5 0.8,0.6 1.3,0.8 1.5,1.3 0,0 0,0 0,0 0.2,0.8 0.3,2 0.7,3.1 0.2,0.6 0.5,1.2 1,1.6 0.5,0.5 1.2,0.7 2,0.7 l 0.3,0 c 1.1,0 1.9,-0 2.6,-0.2 0.7,-0.1 1.3,-0.4 1.7,-0.9 0.4,-0.5 0.5,-1.1 0.7,-1.7 0.1,-0.6 0.2,-1.3 0.3,-2.1 7.6e-4,-0 -7.6e-4,-0 0,-0 0.2,-1.4 0.7,-2.1 1.3,-2.8 0.5,-0.7 1.2,-1.7 1.2,-3.1 0,-0.6 -0.2,-1 -0.5,-1.3 -0.2,-0.3 -0.5,-0.7 -0.7,-1 -0.5,-0.7 -0.8,-1.5 -0.8,-2.4 l 0,-0.9 c 0,-0 -0,-0 0.1,-0.2 0.2,-0.2 0.5,-0.4 0.8,-0.6 0.4,-0.3 0.8,-0.5 1.1,-1 0.4,-0.4 0.7,-1.1 0.7,-1.8 0,-1.2 -0.5,-2.4 -0.9,-3.5 -0.4,-1.1 -0.8,-2.2 -0.8,-2.5 0,-0.5 0.2,-1 0.6,-1.6 0.4,-0.6 1,-1.3 1.5,-2.2 0.5,-0.8 0.9,-1.8 0.9,-3 -0,-1.1 -0.5,-2.4 -1.6,-3.6 l -0,-0 -0,0 c -0.3,-0.3 -0.7,-1.3 -0.8,-2.2 -0.1,-0.9 0.1,-1.9 0.4,-2.3 0.3,-0.5 0.9,-0.9 1.7,-1.4 0.7,-0.6 1.5,-1.6 1.5,-3 l 0,-1.4 38.1,0 0,-2 -40.1,0 -30.6,0 -0.6,0 -15,0 z"}],i["AC.IC.VOLCANIC ERUPTION"]=[{type:"path",stroke:!1,d:"m 122.2,66 -10.4,17.9 1.7,1 10.4,-17.9 -1.7,-1 z m -23.2,0.5 0,17.9 2,0 0,-17.9 -2,0 z m -19.5,-0.4 -1.8,0.8 8,17.9 1.8,-0.8 -8,-17.9 z M 99.3,120.8 c -1.7,-0 -3.3,0.8 -4.5,2 -1.2,1.2 -2,2.9 -2,4.5 l 0,1.9 c 0,1.7 0.8,3.3 2,4.5 1.2,1.2 2.8,2 4.5,2 l 1.3,0 c 1.7,0 3.3,-0.8 4.5,-2 1.2,-1.2 2,-2.8 2,-4.5 l 0,-1.9 c 0,-1.7 -0.8,-3.3 -2,-4.5 -1.2,-1.2 -2.8,-2 -4.5,-2 l -1.2,0 -0,0 z M 80.3,86.5 c -0.5,0 -0.9,0.3 -1.4,0.8 -0.4,0.5 -0.8,1.2 -1.3,2 -0.8,1.7 -1.6,3.9 -2.4,6.3 -1.5,4.7 -2.8,9.8 -3.4,11.4 l -0,0 c -2,7 -5.8,15.2 -7,21.6 l -0.1,0.2 0.2,0 20.9,0.6 0.2,0 0,-0.2 0,-1.9 0,-0.2 -0.2,-0 -17.6,-0.7 L 80.5,89.4 l 39.1,0 11.9,37.1 -17.5,0.7 -0.2,0 0,0.2 0,1.9 0,0.2 0.2,-0 20.9,-0.6 0.2,0 -0.1,-0.2 c -1.3,-6.4 -5.1,-14.7 -7,-21.6 L 128.1,107 c -0.6,-1.6 -1.9,-6.7 -3.4,-11.4 -0.8,-2.3 -1.6,-4.6 -2.4,-6.3 -0.4,-0.8 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.9,-0.8 -1.4,-0.8 l -39.4,0 z"}],i["AC.IC.VOLCANIC THREAT"]=[{type:"path",stroke:!1,d:"m 80.3,85.6 c -0.5,0 -0.9,0.3 -1.4,0.8 -0.4,0.5 -0.8,1.2 -1.3,2 -0.8,1.7 -1.6,3.9 -2.4,6.3 -1.5,4.7 -2.8,9.8 -3.4,11.3 l 0,0 -0,0 c -2,7 -5.8,15.2 -7,21.6 l -0.1,0.2 0.2,0 20.9,0.6 0.2,0 0,-0.2 0,-1.9 0,-0.2 -0.2,-0 -17.6,-0.7 12,-37.1 39.1,0 11.9,37.1 -17.5,0.7 -0.2,0 0,0.2 0,1.9 0,0.2 0.2,0 20.9,-0.6 0.2,-0 -0.1,-0.2 c -1.3,-6.4 -5.1,-14.7 -7,-21.6 l -0,0 0,-0 c -0.6,-1.6 -1.9,-6.7 -3.4,-11.3 -0.8,-2.3 -1.6,-4.6 -2.4,-6.3 -0.4,-0.8 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.9,-0.8 -1.4,-0.8 l -39.4,0 z M 99.3,120 c -1.7,-0 -3.3,0.8 -4.5,2 -1.2,1.2 -2,2.9 -2,4.5 l 0,1.9 c 0,1.7 0.8,3.3 2,4.5 1.2,1.2 2.8,2 4.5,2 l 1.3,0 c 1.7,0 3.3,-0.8 4.5,-2 1.2,-1.2 2,-2.8 2,-4.5 l 0,-1.9 c 0,-1.7 -0.8,-3.3 -2,-4.5 -1.2,-1.2 -2.8,-2 -4.5,-2 l -1.2,0 -0,0 z m -2.7,-42.1 0,0.2 -0.2,0 0,4.2 0,0.2 0.2,0 3.3,0 0.2,0 0,-0.2 0,-4.2 0,-0.2 -0.2,0 -3.3,0 z M 99,57.1 c -1.1,2.5e-5 -2.3,0.2 -3.3,0.5 -1.1,0.3 -2.1,0.8 -3.2,1.4 l -0.1,0.1 0,0.1 0,3.1 0,0.4 0.3,-0.2 c 1.1,-0.7 2,-1.3 3,-1.6 1,-0.4 1.9,-0.6 2.7,-0.6 1.1,2.2e-5 2,0.3 2.7,0.8 0.7,0.6 1,1.3 1,2.2 -1e-5,0.5 -0.1,1 -0.4,1.5 -0.3,0.5 -0.7,1 -1.3,1.6 l 0,0 -1.5,1.5 c -1,0.9 -1.7,1.8 -2,2.5 -0.3,0.7 -0.5,1.7 -0.5,2.8 l 0,2.5 0,0.2 0.2,0 3.1,0 0,-0.2 0.2,0 0,-2 c -10e-6,-0.6 0,-1 0.1,-1.3 0,-0.3 0.1,-0.6 0.1,-0.8 0.1,-0.2 0.2,-0.5 0.4,-0.8 0.2,-0.3 0.6,-0.7 1.1,-1.2 l 1.4,-1.4 c 1,-0.9 1.7,-1.8 2.1,-2.6 l 0,-0 c 0.4,-0.8 0.6,-1.6 0.6,-2.5 -2e-5,-1.8 -0.6,-3.3 -1.9,-4.3 -1.3,-1.1 -2.9,-1.6 -5,-1.6 z"}],i["AC.IC.CAVE ENTRANCE"]=[{type:"path",fill:!1,d:"m 55,100 55,0 30,-20 0,40 -30,-20"}],i["AC.IC.DROUGHT"]=[{type:"path",stroke:!1,d:"m 87.6,127.4 c 1.3,0.6 4.5,0 6.1,0 h 4.2 l -2,-5.9 -4.9,-0.3 c -5.7,10.8 -2.4,4.3 -3.4,6.2 z m -24.1,-7 c -0.6,1.9 17.6,6.9 20.5,7.4 2.7,-1.8 4.5,-2.4 4.8,-6.7 -4,0 -11.4,-0.8 -14.8,-1.7 -2.2,-0.6 -4.2,-1.2 -6.4,-1.7 -3.5,-0.9 -4.2,-1.5 -4.2,2.6 z m 35.9,6.1 6.7,-0.3 18.6,-1.7 c 1.5,-0.4 4.5,-0.4 6,-1.4 -1.3,-2.6 -2.4,-4.1 -3.7,-6.6 -1.4,-2.6 -1.9,-4.9 -3,-7.2 -3.7,0.8 -4.7,3.5 -6.3,4 -3.5,1.1 -4.8,0.4 -6.7,3.8 -1.7,3 -2.5,3.3 -5.3,5.2 -2.4,1.7 -3.6,2.8 -6.3,4.2 z m -2.8,-9 c 0,3.7 0.5,4.2 2.2,7.3 l 8.5,-7.1 -0.2,-0.2 c -1.7,-0.4 -2.4,-1.5 -4.8,-2.2 -1.6,-0.4 -4.1,-1.3 -5.8,-1.4 v 3.6 h 0.1 z m 37.6,0.5 c -0.9,0 -1,-0.2 -1.9,-0.2 l 1,2.4 2.7,-2.8 c -0.9,0.2 -0.8,0.5 -1.8,0.5 z m -51.3,-0.3 c -0.1,1.9 7.7,1.5 9.3,1.5 h 2.8 c 0,-1.7 -0.7,-2.8 -0.8,-4.4 -0.1,-2.5 -0.4,-1.8 -3.1,-2.1 -4,-0.4 -4.6,-2 -7.7,-2.8 l -0.6,7.7 z m -25.5,-12.6 3,12.1 c 0.7,-3 2.2,-4.5 2.8,-7.3 0.3,-1.8 0.1,-2.6 0.9,-4 0.4,-0.7 1.3,-2.8 1.5,-3.6 -1.4,-0.3 -6.9,-1.6 -8.6,-1.6 l 0.4,4.4 z m 69.9,-2.2 c -1,4.1 -0.7,3.5 1,7 1.2,2.4 2,4.4 3.1,6.6 5.8,-0.5 6.2,-0.5 9.4,-3.6 1.6,-1.6 1,-6.8 2,-8.3 -2.5,-1.2 -1.7,-0.6 -4.6,-1.3 -4.5,-1 -6.6,-0.4 -10.9,-0.3 z m -30.9,1.1 v 0.8 c 0,2.2 -0.1,3.3 0,5.4 0.1,3.3 -0.3,2.5 3.1,2.8 1.2,0.1 3.5,1 4.5,1.4 0.7,0.4 1.5,0.5 2,0.8 0.8,0.4 0.3,0.6 1.7,1.4 l -0.2,-0.2 5.6,-4.7 c 3.1,0 4.2,0.4 5.8,-1.3 2.4,-2.5 0.8,-1.4 4,-3.1 l 0.6,-3.1 c -2.5,0.6 -5.5,2.2 -8.2,1.1 -2.6,-1.1 -3.8,-2.8 -7.4,-2.8 l -1.6,-0.3 -9.9,1.8 z m -32.1,11.2 c 1.3,0 5.8,0.7 6.9,1 1.4,0.4 4.7,2.3 5.6,2.3 h 2.8 c 1,0 0.9,-0.3 1.7,-0.5 l 1.7,-8.3 -5.2,-4.5 -9,-2 c -0.4,1.7 -2.4,3 -3.1,5.1 -0.3,0.7 -1.5,6.3 -1.5,7 z m 41,-35.1 c 1,1.2 1.4,2.8 2.2,4.2 0.4,0.6 2.9,3.3 2.9,3.5 0,0.8 -0.9,2.3 -1.3,2.3 -2.7,0 -3.8,-6.7 -3.8,-10 z m -1.8,-1.2 c -0.3,1 -1.9,4.5 -2.5,5.6 -0.9,1.8 -1.9,3.5 -4.4,3.5 -0.5,0 -1,-0.4 -1,-0.8 0,-3.1 3.8,-5.8 5.2,-7.6 l 2.8,-0.8 z m 9.5,8.6 h -0.8 c -2.3,0 -6.9,-8 -6.9,-9.7 0,-0.1 0.3,-0.5 0.3,-0.5 1.7,0.5 7.9,6 7.9,8.7 -4e-4,0.5 -0.4,0.8 -0.5,1.5 z m 0.6,-6 c -0.7,-0.3 -1.7,-1 -2.4,-1.3 -1.4,-0.8 -3.5,-2.9 -4.7,-3.3 l 1.1,-1.3 c 3.1,1.5 10.1,1.3 10.1,5.7 0,0.3 -0.8,0.8 -1,1 -0.8,-0.3 -2,-0.4 -3.1,-0.8 z m -24.9,1.3 h -1 c 1,-2 -2.2,-6.7 -4.4,-7.2 -2.2,1.2 -4.2,0.6 -5.5,3.3 -0.4,1 -0.7,2.2 -1.5,2.8 -0.8,0.6 -2.4,0.8 -2.4,1.9 0,1.5 4.3,0.4 4.9,-0.2 1.2,-1.1 2.4,-2.1 4.5,-2.1 2,0 2.9,5.8 3.1,8.2 0.2,3.2 -2.3,7.7 -2.2,9.5 l 0.9,6.8 -4.4,-0.3 c 2.1,3.1 8.5,6 13.4,6.4 l -0.4,-7.7 -5.6,1.3 c 0,-4.4 -2,-5.5 -0.5,-9.5 0.6,-1.7 1,-2.2 1,-4.7 0,-1.1 0.2,-4.6 0.6,-5.3 1.5,-2.5 1.9,-5.6 3.1,-8.4 1.2,-2.8 5,-2.6 8.3,-3.5 l 1.2,1.3 -1,0.3 0.8,1.8 c -1.7,2 -2.9,2.9 -4.5,5 -0.8,1 -3.8,6.3 -0.6,6.3 h 1 c 3.9,0 5.1,-7.1 6.9,-9.2 0.4,4.4 1.2,9.5 4.4,11.2 1.7,-0.4 2.2,-1.1 2.6,-2.8 0.7,0.2 0.5,0.3 1,0.3 1.3,0 2,-1.1 2,-2.3 V 85.8 c 0,-2.1 -1.2,-2.4 -1.5,-3.8 0.8,0.4 2.2,1 3.3,1 h 0.5 c 1.2,0 1.3,-0.6 1.8,-1.3 -0.2,-2.5 -1.5,-3.9 -3.5,-4.6 -1.3,-0.4 -5.2,-1.7 -6.7,-1.7 l 0.5,-1 h -0.7 l 0.8,-1.6 -4.9,1 c -0.9,-0.6 -1.2,-1.5 -2.6,-1.5 h -1.8 C 92.3,72.2 88.7,75.8 88.7,82.9 l 0,0 z"}],i["AC.IC.FLOOD"]=[{type:"path",stroke:!1,d:"M77.2,92.9L77.3,92.8L99.3,72.5L99.7,72.1L100,72.1L100.4,72.5L122.4,92.8L123.5,93.9L122.4,93.9L122.4,115.902C123.023,115.106 123.657,114.5 124.4,114.5C125.454,114.199 124.857,116.712 125.5,117.6C125.988,118.273 126.805,118.721 127.609,118.928C130.146,119.58 132.747,117.303 134.5,116.2C135.043,115.859 136.356,115.26 136.4,115.9C136.652,119.558 136.526,123.235 136.4,126.9L63.7,126.9L63.7,114.9C64.819,117.943 66.835,120.948 70.637,119.05C72.357,118.192 73.209,115.745 75.1,115.4C75.464,115.334 76.266,116.335 77.1,117.278L77.1,93.9L76.2,93.9L77.1,93L77.1,92.9L77.2,92.9ZM121.2,117.544L121.2,94.1L78.3,94.1L78.3,118.49C78.521,118.667 78.727,118.795 78.911,118.845C83.407,120.084 82.345,116.009 86.9,115.5C87.588,115.423 90.549,119.114 91.583,119.536C95.694,121.215 95.826,116.694 98.9,115.9C100.074,115.597 100.538,118.237 100.9,118.5C101.86,119.198 103.028,119.651 104.2,119.837C109.33,120.655 108.685,117.216 111.9,114.9C112.848,114.217 113.556,116.602 113.563,116.613C115.1,119.229 115.092,120.273 118.659,119.606C119.666,119.418 120.465,118.529 121.2,117.544ZM99.75,73.846L99.8,73.8L99.7,73.8L99.75,73.846L79.3,92.7L120.2,92.7L99.75,73.846Z"}],i["AC.IC.INVERSION"]=[{type:"path",stroke:!1,d:"M 69.5,87.9 C 69.5,86.7 73.6,83.9 75.5,83.9 h 0.3 c 3.3,0 9,9.1 15.2,9.1 h 1.8 c 5.4,0 11.3,-9.1 14.9,-9.1 3.5,0 8.8,9.1 15.2,9.1 h 0.9 c 8.5,0 10.5,-4.4 15.5,-7 l -5.3,-6.4 c -3.4,1.8 -4.1,4.6 -9.5,5.3 -2.2,0.3 -6.6,-3.9 -8.3,-5.5 -8,-6.8 -13,-3 -19.4,2 -3.9,3.1 -3.9,5.3 -8.5,1.3 -2.2,-1.8 -5.6,-4.8 -8.2,-6 -3.8,-1.8 -8.6,-0.7 -11.4,1.2 -1.6,1 -7.3,5.2 -7.3,6.9 v 52.2 h 8.2 V 87.9 z m -9.4,-16.4 79.9,0 0,-8.5 -79.9,0 z"}],i["AC.IC.TSUNAMI"]=[{type:"path",stroke:!1,d:"m 63,122 39.5,-0.1 30.8,0.3 c -7.1,0 -12.8,-1.7 -16.9,-4.8 -3.7,-2.9 -7.7,-8 -7.7,-14.4 0,-9.1 6.9,-16.5 15.8,-16.5 h 0.7 c 6.5,0 8.2,2.8 11.8,5.3 -2,-8.6 -10.6,-14.2 -21.4,-14.2 h -0.2 c -18.2,0 -44.9,33 -52.4,44.3 l 0,0 0,0 z"}],i["AC.IC.BIRD"]=[{type:"path",stroke:!1,d:"m 81.6,92.5 -18.4,2.9 v 0.3 l 6.6,0.5 c -0.7,0.5 -3.3,1.1 -4.5,1.5 -2.6,0.9 -2,0.3 -3.5,2.4 l 3.4,0.1 -1,1 c 1.8,0 3.3,0.1 4.8,0.2 1.4,0.1 1.9,-1.3 3.5,-1.4 3,-0.2 5.7,0.2 9.3,0.3 l -0.8,0.5 c 0.6,0.1 0.7,0.2 1.4,0.2 h 1.6 l 0.1,0.9 2.9,1.2 1.6,-0.1 c 1.6,1.1 1.9,2.3 5.2,2.4 0.2,2.7 0.6,3.8 3,4.4 v 0.8 c 0,2.2 0.2,4.8 2.1,5 l 1.2,5.3 h -0.4 v 0.4 c -0.3,-0.3 -1.4,-1.2 -1.8,-1.2 h -0.2 c -0.5,0 -0.5,0.1 -1,0.2 0.6,0.8 2.7,1.7 3.1,2.7 0.5,1.6 0.1,3.8 0.2,5.3 l 0.9,0.6 0.8,-0.1 0.1,-0.8 -0.1,-2.7 c 0.7,0.5 2.7,3 3.3,3 h 1 c -0.5,-2 -1.8,-2.4 -2.7,-3.9 l 3.7,1.1 c -1,-1.5 -0.9,-1.8 -2.9,-2.3 -3.1,-0.8 -1.8,-1.9 -3.1,-2.2 l -1,-5.4 c 1,-0.2 1.4,-1 1.4,-2.2 l 0.1,-1.6 -0.3,-2.6 h 1 c 0.7,0 0.7,-0.2 1.4,-0.4 0.1,1.6 1.2,3.3 2.7,3.4 l 3.1,6.3 c -0.3,0.3 -0.4,0.3 -0.4,0.8 v 0.7 l -4.4,-0.9 v 0.2 c 0.8,0.7 3.7,1.7 5.1,2.8 1.1,0.8 1.2,0.6 2,1.9 0.3,0.5 1.3,2.2 1.9,2.2 h 0.8 l 0.2,-0.1 -1.7,-3.2 4.3,1.9 c -0.1,-2.1 -2.1,-1.5 -3.6,-2.8 h 3 c -1.3,-1.1 -1.6,-0.9 -3.5,-1.2 -1.6,-0.2 -1.7,-1.2 -2.7,-2.1 -1.1,-1.2 -2,-4.9 -2.9,-6.6 1.2,-1.8 1,-1.4 1,-4.4 4.8,-2.3 5.6,-2.1 9.3,-5.9 2.7,-2.7 3.9,-6.1 5.8,-9.7 0.9,-1.8 1.5,-3.3 2.2,-5.2 0.7,-1.8 0.7,-4.7 1.4,-6.3 2.3,-4.6 9,-3.2 10.3,-5.2 l -4.4,0.2 v -0.2 l 5,-0.6 c -2.2,-1.9 -4.8,-1.4 -8.3,-1.8 -2.1,-0.3 -2.9,0.7 -4.4,-0.3 -1.4,-1 -1.6,-1.2 -3.7,-1.5 -3.1,-0.5 -5.6,1.2 -7.4,2.5 -1.7,1.3 -3.2,5.2 -4.2,6.1 -0.3,0.2 -6.1,2.7 -7.1,3.2 -2.9,1.5 -3.5,2.5 -7.3,3.1 -6.3,1 -9.9,3.4 -14.2,6.3 l 0,0 z"}],i["AC.IC.INSECT"]=[{type:"path",stroke:!1,d:"m 77.4,88.8 0.1,-0.3 6.1,4.9 -0.1,0.2 c -2.2,1.5 -7.7,9 -10,9 l -1.6,-0.1 5.6,-13.7 z m 7.1,3.3 c -0.4,-1.7 -5,-6.4 -6.7,-7.2 -0.4,0.3 -1.8,1 -1.8,1.6 0,0.8 0.3,1 0.5,1.5 l -5.6,14.7 h -1 c 0.2,0.9 0.5,0.7 0.5,1 0,0.3 -3,7.8 -3.3,8.7 -0.6,1.4 -1,2.7 -1.6,4.2 -0.3,0.8 -0.6,1.6 -0.9,2.2 -0.5,1.1 -0.6,0.3 -1.4,1.7 l -1.3,0.3 c 0.3,0.5 1.8,0.5 2.5,0.4 1.2,-0.2 0.4,-1 0.8,-2.2 0.7,-1.8 1.4,-3.5 2.1,-5.4 0.5,-1.2 3.7,-10.3 4.6,-10.3 h 1.3 c 0.8,0 1,0.3 1.5,0.5 l 2.3,-2.8 c 2.7,1.8 8.5,4.6 12.8,4.6 h 0.7 l 0.2,-0.1 -3.5,-5 -9.9,-0.1 6.5,-6.3 c 4.3,2.9 11.7,16.9 14.9,16.9 h 0.3 c 1.4,0 1.3,-0.6 1.8,-1.6 -0.9,-3.7 -4.8,-6.3 -7.3,-8.5 -2.4,-2 -6.1,-6.5 -8.3,-7.9 1.2,-1.7 10.3,-10.8 12.2,-11.3 l 0.9,7.7 0.1,2.9 -1.2,7.4 h -1.8 l 5.2,4.4 7.2,-3.9 c -0.5,2.1 -0.3,2.5 -2.2,3.4 -0.6,0.3 -3.7,1.9 -3.7,2.3 0,0.5 0.7,1.7 0.7,3.1 0,2.9 -3.1,4.4 -5.8,3.3 -2.1,-1 -4.9,-5.1 -5.5,-5.1 h -1 c -4.6,0 -6.7,1.6 -10.5,1.6 h -0.5 c -1.9,0 -2.5,-0.7 -4.1,-0.7 h -0.5 c -0.6,0 -1,0.4 -1,1 0,3.2 12.3,4.7 16.9,4.6 l 13.1,-0.3 v 0.3 c -0.9,1.3 -5.8,4.8 -8,4.8 -0.1,0.2 -0.5,0.7 -0.5,0.8 0,0.7 0.1,0.7 0.3,1.3 0.7,0.1 0.5,0.3 1,0.3 0.5,0 0.5,-0.2 1,-0.5 v -1.3 l 7.7,-5.4 -1.6,6.1 c -0.9,0.1 -1.3,0.4 -1.3,1.3 0,0.9 0.5,0.7 1.4,1.2 l 1.2,-1.4 c 0,-0.2 -0.7,-1.3 -0.7,-1.4 0,-1.3 2.4,-7.6 2.8,-9.5 l 15.6,-0.5 1.2,8.4 -0.4,0.1 c 0.3,0.5 0.3,1 1,1 1,0 1.1,-0.3 1.6,-0.7 -0.5,-1 -0.5,-1.9 -1.7,-1.3 l -0.8,-6.7 4.8,5.5 -0.7,0.8 1.4,1.2 c 0.5,-0.3 1,-0.2 1,-1 v -0.5 c 0,-0.9 -0.9,-1 -1.6,-1.2 l -4.5,-5 0.3,-1 h -8.5 c 0,-5 2,-8.2 2.3,-12.4 l -9.2,0.4 -0.8,2.5 h -4.6 c -1.8,0 -2.8,-8 -2.9,-10.3 0,-2.4 -0.3,-4.1 -0.2,-6.4 0.1,-1.4 1,-5.1 -1,-5.1 h -0.7 c -1,0 -1.3,1 -1.6,1.8 -0.3,1 -1,1.4 -1.6,2 -1.2,1.3 -2.3,2.4 -3.5,3.6 -1.2,1.2 -6.2,6.7 -7.4,7 l 0,0 z m 37.9,8 c 0,-0.3 0.3,-0.5 0.7,-0.5 h 0.7 l 0.1,0.5 -0.3,1 h -1 c -0.1,-0.7 -0.3,-0.4 -0.3,-1 z m 3.6,-1.8 c -0.2,0 -1.6,-1.8 -3.3,-1.8 h -0.5 c -2,0 -2,2.2 -2.5,3.9 -0.5,1.4 -1.4,3.7 -1.4,5.4 0,0.6 0.4,1 1,1 2.4,0 6.4,-5.2 6.9,-7.4 3.9,0 11.1,-1.1 11.8,-3.9 -2.6,0.7 -2.9,2.4 -8,2.8 1.8,-1.6 5.6,-4.3 5.9,-7.2 h -0.5 c -0.8,3.1 -5.6,7.2 -9.5,7.2 z"}],i["AC.IC.MICROBIAL"]=[{type:"path",stroke:!1,d:"m 83.9,93.3 c -3.3,0 -6,2.7 -6,6 0,3.3 2.7,6 6,6 3.3,0 6,-2.7 6,-6 0,-3.3 -2.7,-6 -6,-6 z M 100,85.5 c -11.1,0 -21.2,1.5 -28.6,4.1 -3.7,1.3 -6.7,2.8 -8.8,4.5 -2.1,1.7 -3.4,3.7 -3.4,5.9 0,2.2 1.3,4.2 3.4,5.9 2.1,1.7 5.1,3.2 8.8,4.5 7.4,2.5 17.5,4.1 28.6,4.1 11.1,0 21.2,-1.5 28.6,-4.1 3.7,-1.3 6.7,-2.8 8.8,-4.5 2.1,-1.7 3.4,-3.7 3.4,-5.9 0,-2.2 -1.3,-4.2 -3.4,-5.9 -2.1,-1.7 -5.1,-3.2 -8.8,-4.5 C 121.2,87.1 111.1,85.5 100,85.5 z m 0,1.4 c 11,0 21,1.5 28.2,4 3.6,1.2 6.5,2.7 8.4,4.3 1.9,1.6 2.9,3.2 2.9,4.8 0,1.6 -1,3.3 -2.9,4.8 -1.9,1.6 -4.8,3 -8.4,4.3 -7.2,2.5 -17.1,4 -28.2,4 -11,0 -21,-1.5 -28.2,-4 -3.6,-1.2 -6.5,-2.7 -8.4,-4.3 -1.9,-1.6 -2.9,-3.2 -2.9,-4.8 0,-1.6 1,-3.3 2.9,-4.8 1.9,-1.6 4.8,-3 8.4,-4.3 7.2,-2.5 17.1,-4 28.2,-4 z"}],i["AC.IC.REPTILE"]=[{type:"path",stroke:!1,d:"m 93.5,82.3 c 0,-2 1.8,-2.7 1.8,-4.3 0,-1 -0.6,-1.5 -1.2,-2 -2.8,0.3 -6.5,0.6 -7.4,2.7 -0.5,1.2 -0.5,2.4 -1.2,3.9 -0.5,1 -1.2,2.4 -1.2,3.8 0,0.8 0.4,0.7 0.4,1.6 v 0.8 c 0,2.2 -2.4,3.5 -0.6,6.1 -0.2,0.3 -2,1.5 -2.4,1.7 -1.7,1 -1.8,-0.6 -2.6,-0.6 h -0.8 l -0.3,-1.2 c -0.5,-0.3 -1,-0.8 -1.7,-0.8 -0.8,0 -0.8,0.5 -0.6,1 l -2.1,0.4 -0.8,2.3 h 1 c 0.9,0 1.4,0.4 1.6,1.2 l -1.5,1.2 -0.1,0.4 c 2.8,0.3 4.6,-0.6 7.2,-1.2 1.5,-0.4 6.8,-0.6 7.3,-1 l 0.1,-2.2 c 1,0.3 2,1.3 3.1,1.7 1.2,0.4 1.7,0.8 3.1,1.2 2.4,0.6 4.5,1.2 7.7,1.2 h 0.6 l 6.1,-0.6 c 0,2.6 2.3,2.5 2.8,4.5 -1.3,-0.3 -2.3,-2 -3.5,-2 -0.1,0 -0.4,0.1 -0.6,0.2 l 0.3,1.2 -1.6,0.3 v 0.8 l 0.6,0.4 -0.9,0.6 1,1 c -0.2,0.8 -0.7,0.6 -0.7,1.3 0,0.4 0.1,0.6 0.6,0.6 0.6,0 1.6,-1 2.8,-1 1.9,0 8.3,0.8 8.3,-0.8 v -0.2 c 0,-1.5 -3.5,-1.6 -3.3,-5.5 5,2.6 9.3,7.4 4.5,13.6 -1.5,2 -4.1,3.6 -6.7,4.5 -1.4,0.5 -7.4,1.9 -9.3,1.5 -4.2,-0.8 -5.4,-0.8 -8.8,-2.4 -2.6,-1.2 -4.7,-2.5 -7,-4 -3.9,-2.4 -10,-6.1 -16.1,-6.1 -5,0 -11.4,3.1 -11.4,7.9 1.2,-0.6 1.3,-1.3 2.1,-2.2 0.5,-0.6 1.7,-1.3 2.4,-1.7 1.5,-1 3.9,-1.8 6.5,-1.8 h 1 c 4.4,0 11.6,4.7 14.5,6.7 4.5,3.1 8.1,5.5 14.7,6.7 7,1.2 12.7,-0.1 17.4,-2.8 1.9,-1.1 4.3,-3.3 5.5,-5.1 1,-1.6 2.9,-5.4 2.7,-8 l -0.3,-2.6 c 0.3,0.1 2.8,3.7 3.6,4.5 0.8,0.8 3.8,2.5 5.3,2.5 1,0 4.4,-2.2 4.7,-2.9 l -1.3,-0.6 1.2,-1 c -1.5,-1 -0.8,-0.6 -2.4,-0.6 h -1 c 0,-1.4 -0.3,-1.8 -1.3,-1.6 l 0.2,0.1 -1.7,3.4 c -1.4,0 -2.9,-0.9 -3.6,-1.8 0,-0.1 -1.3,-3.8 -1.3,-3.9 -0.6,-2 -0.6,-2.2 -1.8,-3.6 -1.2,-1.3 -1.9,-1.2 -3.4,-1.9 l -0.1,0.6 c -0.6,-1.8 -6.2,-6.5 -8.1,-7.4 -2.2,-1.2 -3.2,-1.2 -6,-1.7 -2.1,-0.3 -5.4,0.3 -7,-0.5 0.4,-1.5 1.6,-0.6 1.6,-2.2 0,-0.5 -0.7,-0.4 -1.2,-0.4 0.6,-1.2 -0.3,-1 -1.3,-1 0.1,-0.3 0.4,-0.6 0.4,-1 0,-0.3 -0.3,-0.4 -0.6,-0.4 -0.4,0 0,0.6 -1.3,0.6 -0.3,-1 -0.3,-1.3 -1.5,-1.4 v 1.6 h -1.3 v 0.6 c 0,0.8 0.6,1.5 1,2.2 -0.4,0.7 -0.3,2 -1.4,2 -0.6,0 -1.8,-1.5 -3.1,-1.9 -1.3,-0.4 -3,0.5 -3,-1.5 -0,-0.9 2.1,-2.5 2.8,-3.5 l 0,0 z"}],i["AC.IC.RODENT"]=[{type:"path",stroke:!1,d:"m 117.2,80.3 c 0.6,1.2 0.6,1.7 1.5,2.6 0.6,0.7 1.8,1.2 1.9,2.2 -2,-0.1 -4.2,-3.3 -4.4,-5.3 -2.1,-0.5 -8.4,-3.6 -10.9,-4.7 -3.1,-1.3 -8.3,-2.7 -12.7,-2.7 h -2.2 c -4,0 -9,2.5 -11.3,4.2 -3,2.2 -5.2,5.2 -5.2,10.4 v 0.7 c -4.6,1.1 -11.7,8.4 -11.7,13.9 v 2.4 c 0,6.2 7.7,10 11.8,12.7 2.5,1.7 4.7,3.3 7,5.1 2.2,1.7 4.7,4.2 6.7,5.5 -2.1,-9 -22.4,-12.7 -22.4,-25.1 0,-4.5 4.9,-9.3 8.5,-10.2 -0.1,0.6 -0.3,0.6 -0.3,1.3 v 0.5 c 0,4.5 7.8,4.1 11.5,3 5.1,-1.5 8.1,-2.2 13.6,-1.2 5.4,1.1 8.3,1.5 12.7,3.6 3.7,1.9 2,1.2 4.2,3.8 1.1,1.3 1,1.1 2.9,1.3 0.8,0.1 1.8,1 2.4,1.5 h 1.7 c -1.3,-2.6 -4.9,-2.9 -5.6,-5.8 0.8,-1.5 1.7,-1.7 3.9,-1.7 0.8,0 1,0.2 1.7,0.3 -0.3,-0.6 -0.6,-1.7 0.5,-1.7 h 1.9 c 4.5,0 9,2.5 12.7,0 0,-3 0.4,-2.2 -0.9,-4.9 -0.5,-0.8 -2.1,-2.7 -2.8,-3.4 -1.6,-1.5 -5.7,-4.1 -6.7,-5.5 0,-2.8 -0.4,-3.4 -2.7,-3.9 l -0.5,1 0.5,2.7 -1,0.3 v 0.9 h -0.8 c -0.2,-2.4 -1.2,-5.8 -3.6,-5.8 h -0.2 c -1.8,-4e-4 -1.5,1 -2,1.9 z m 9.5,24.6 h 1.2 c -0.2,-2.6 -5.1,-2.8 -5.4,-5.4 l -2.2,0.3 c 0.2,1.5 1.1,2.9 2.4,3.5 0.9,0.3 1.5,0 2.3,0.6 0.4,0.3 1.1,1 1.7,1 z m -45.1,-6.1 c 1.2,1.8 5.9,4.2 8.8,4.2 1,0 1.6,-0.8 1.9,-1.5 -0.9,-1.3 -2.9,-2.8 -4.7,-3.1 -3.7,-0.8 -2.9,0.1 -6,0.4 l 0,0 z m 9.5,-1.9 c 1.3,2 5,2.9 8.3,2.9 0.8,0 1.4,-0.4 1.9,-0.7 -2,-2.9 -6.1,-2.6 -10.2,-2.2 z"}],i["AC.IC.PHARMACY"]=[{type:"path",stroke:!1,d:"m 83.3,74.5 h 13.2 c 3,0 6.2,3.8 6,7.3 -0.1,3.6 -2.9,6.6 -6.5,6.6 H 83.3 V 74.5 z m -8.7,45.9 h 8.7 V 98 h 2.4 c 0.6,0 13.6,16.1 13.6,17.2 0,0.6 -13.6,16.6 -15,19.3 l 10.5,-0.1 10.3,-12.2 9.6,12.3 10.9,-0 -15.2,-19.3 14.4,-17.8 -10.2,-0.1 -9.7,10.8 -7.4,-10 c 8.5,-2 14.1,-6.8 14.1,-17.2 0,-8.1 -7,-15.3 -15,-15.3 H 74.6 v 54.8 z"}],i["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 99.6,107.1 h -14.8 v 31.7 h 32 v -31.7 h -14.8 V 95.2 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 h -2.3 v 24.5 z m -3.1,-45 -5.6,14.8 1.7,0 1.3,-3.8 0.1,-0.1 0.1,0 6.8,0 0.1,0 0.1,0.1 1.3,3.8 1.7,0 -5.6,-14.8 -2.1,0 z m 0.8,1.8 0.2,0.1 0.2,-0.1 2.8,7.5 0.1,0.3 -0.3,0 -5.6,0 -0.3,0 0.1,-0.3 2.8,-7.5 z m -14.8,-1.8 8.3,0 0,1.3 -6.5,0 -0.2,0 0,0.2 0,4.5 0,0.2 0.2,0 5.8,0 0,1.3 -5.8,0 -0.2,0 0,0.2 0,7 -1.6,0 0,-14.8 z m 30.3,-0.3 c 0.9,1.5e-5 1.7,0.1 2.5,0.4 l 0,0 c 0.8,0.2 1.4,0.6 2.1,1 l 0,1.6 c -0.6,-0.5 -1.3,-0.9 -1.9,-1.2 -0.8,-0.3 -1.7,-0.5 -2.6,-0.5 -1.8,1.4e-5 -3.2,0.6 -4.1,1.7 -1,1.1 -1.4,2.7 -1.4,4.7 -1e-5,2 0.5,3.6 1.4,4.7 1,1.1 2.4,1.7 4.1,1.6 0.9,2e-6 1.8,-0.2 2.6,-0.5 0.7,-0.3 1.3,-0.7 1.9,-1.2 l 0,1.6 c -0.7,0.4 -1.4,0.8 -2.1,1 -0.8,0.2 -1.6,0.4 -2.5,0.4 -2.3,0 -4,-0.7 -5.3,-2 -1.3,-1.4 -1.9,-3.2 -1.9,-5.6 0,-2.4 0.6,-4.3 1.9,-5.6 1.3,-1.4 3,-2 5.3,-2 z"}],i["ATMOSPHERIC.IC.DRIZZLE.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 100,82.7 c -5.5,0 -10,4.5 -10,10 0,5.5 4.5,10 10,10 0.1,0 0.1,0 0.2,0 l -0.2,0.2 c 0.9,5 -8.4,14.4 -8.4,14.4 12.8,0.1 18.4,-13.4 18.3,-23.4 l -0,0 c 0,-0.4 0.1,-0.8 0.1,-1.2 0,-5.5 -4.5,-10 -10,-10 z"}],i["ATMOSPHERIC.IC.FOG.SKY OBSCURED"]=[{type:"path",stroke:!1,fill:"rgb(255, 247, 0)",d:"m 49.6,59.7 0,8 100.9,0 0,-8 -100.9,0 z m 0,71.6 0,8 100.9,0 0,-8 -100.9,0 z m 0,-35.6 0,8 100.9,0 0,-8 -100.9,0 z"}],i["ATMOSPHERIC.IC.HAIL.LIGHT NOT ASSOCIATED WITH THUNDER"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"m 100,45.5 -0.9,2.1 -16,36 -0.6,1.4 1.5,0 32,0 1.5,0 -0.6,-1.4 -16,-36 L 100,45.5 z m -21.4,46.7 0.4,1.3 20,60 0.9,2.9 0.9,-2.9 20,-60 0.4,-1.3 -1.4,0 -40,0 -1.4,0 z m 2.8,2 37.2,0 L 100,150 81.4,94.1 z"}],i["ATMOSPHERIC.IC.RAIN.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 100,79.8 c -11.2,0 -20.2,9 -20.2,20.2 0,11.2 9,20.2 20.2,20.2 11.2,0 20.2,-9 20.2,-20.2 0,-11.2 -9,-20.2 -20.2,-20.2 z"}],i["ATMOSPHERIC.IC.DUST OR SAND.LIGHT TO MODERATE"]=[{type:"path",stroke:!1,fill:"rgb(173, 105, 75)",d:"m 140.7,85 -2,2 13,13 -13,13 2,2 14,-14 1,-1 -1,-1 L 140.7,85 z m -93.5,13.6 0,2.8 106.5,0 0,-2.8 -106.5,0 z M 98.5,62.3 c -3.2,0 -6.4,0.8 -9.2,2.2 -3.7,1.8 -6.9,4.4 -9.3,7.3 -2.3,2.9 -3.9,6.1 -3.9,9.3 0,5.6 2.9,9.9 6.9,13.2 4,3.3 9,5.8 13.9,8.3 4.9,2.5 9.7,4.9 13.1,7.7 3.4,2.8 5.4,5.8 5.4,10.1 0,3.6 -4,9 -10,11.6 -6,2.6 -13.6,2.7 -20.9,-3.4 l -2.7,3.2 c 8.4,7.1 18,7.2 25.3,4 7.2,-3.1 12.5,-9.2 12.5,-15.4 0,-5.6 -2.9,-10 -6.9,-13.3 -4,-3.3 -9,-5.8 -13.9,-8.2 -4.9,-2.5 -9.7,-4.9 -13.1,-7.7 -3.4,-2.8 -5.4,-5.8 -5.4,-10 0,-1.7 1,-4.3 2.9,-6.7 1.9,-2.4 4.7,-4.7 7.8,-6.2 6.2,-3 13.5,-3.1 19.9,4.4 l 3.2,-2.7 C 109.5,64.4 103.9,62.3 98.5,62.3 z"}],i["ATMOSPHERIC.IC.SNOW.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 111.5,78.9 -26.4,40 3.3,2.2 26.4,-40 -3.3,-2.2 z m -23.1,0 -3.3,2.2 26.4,40 3.3,-2.2 -26.4,-40 z M 80,98 l 0,4 40,0 0,-4 -40,0 z"}],i["ATMOSPHERIC.IC.STORMS.THUNDERSTORM LIGHT TO MODERATE - WITH HAIL"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 101 51.9 L 99.7 54.4 L 85.8 82.3 L 84.8 84.3 L 87 84.3 L 114.9 84.3 L 117.2 84.3 L 116.2 82.3 L 102.2 54.4 L 101 51.9 z M 101 58.1 L 112.7 81.5 L 89.3 81.5 L 101 58.1 z M 78.3 87.7 L 78.3 90.5 L 83.9 90.5 L 83.9 145 L 86.7 145 L 86.7 90.5 L 117.8 90.5 L 102.8 116.4 L 102.4 117.1 L 102.9 117.8 L 117.8 140.9 L 111.2 136.8 L 109.8 139.2 L 120.9 146.2 L 123.3 147.7 L 123 144.9 L 121.7 130.9 L 118.9 131.2 L 119.6 138.6 L 105.7 117 L 121.5 89.8 L 122.7 87.7 L 120.3 87.7 L 78.3 87.7 z "}],i["ATMOSPHERIC.IC.STORMS.FUNNEL CLOUD (TORNADO/WATERSPOUT)"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 125.7,59.1 112.4,72.4 112,72.8 l 0,0.6 0,53.3 0,0.6 0.4,0.4 13.3,13.3 1.9,-1.9 -12.9,-12.9 0,-52.2 12.9,-12.9 -1.9,-1.9 z m -51.5,0 -1.9,1.9 12.9,12.9 0,52.2 L 72.4,139.1 74.3,140.9 87.6,127.6 88,127.2 l 0,-0.6 0,-53.3 0,-0.6 L 87.6,72.4 74.3,59.1 z"}],i["ATMOSPHERIC.IC.TROPICAL STORM SYSTEMS.TROPICAL STORM"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 112.1 55 C 96.9 59.9 76.7 81.8 82.2 101.4 C 82.9 110.6 90.6 117.9 100 117.9 C 100 117.9 100 117.9 100.1 117.9 C 99.3 128.2 87.9 145 87.9 145 C 103.1 140.1 123.3 118.2 117.8 98.6 C 117.1 89.4 109.4 82.1 100 82.1 C 100 82.1 100 82.1 99.9 82.1 C 100.7 71.8 112.1 55 112.1 55 z M 100 84.5 C 106.8 84.5 112.5 88.8 114.6 94.8 C 114.8 95.2 114.9 95.6 115 96 C 115 96.1 115 96.1 115 96.2 C 115.1 96.6 115.2 96.9 115.3 97.3 C 115.4 98.1 115.5 99.1 115.5 100 C 115.5 101.1 115.4 102.1 115.2 103.1 C 115 104.1 114.7 105 114.4 105.8 C 114.4 105.9 114.3 105.9 114.3 106 C 114.1 106.4 114 106.7 113.8 107.1 C 113.7 107.2 113.7 107.3 113.7 107.3 C 113.6 107.4 113.6 107.5 113.5 107.6 C 113.3 107.9 113.1 108.3 112.9 108.6 C 112.4 109.3 111.9 110 111.3 110.6 C 111.2 110.7 111.1 110.8 111.1 110.9 C 110.8 111.1 110.5 111.4 110.3 111.6 C 110.2 111.7 110.2 111.7 110.1 111.8 C 109.8 112 109.5 112.3 109.2 112.5 C 109.1 112.5 109.1 112.5 109.1 112.5 C 108.9 112.7 108.6 112.9 108.4 113 C 108.1 113.2 107.8 113.4 107.5 113.6 C 107.4 113.6 107.4 113.6 107.4 113.7 C 106.6 114.1 105.7 114.4 104.9 114.7 C 104.7 114.8 104.5 114.8 104.3 114.9 C 104 115 103.6 115.1 103.3 115.2 C 103.2 115.2 103.1 115.2 103.1 115.2 C 102.1 115.4 101.1 115.5 100 115.5 C 93.3 115.5 87.6 111.3 85.4 105.3 C 85.4 105.3 85.4 105.2 85.4 105.2 C 85.3 104.8 85.2 104.5 85.1 104.2 C 85 104 85 103.9 85 103.8 C 84.9 103.5 84.8 103.2 84.8 102.9 C 84.7 102.5 84.6 102 84.6 101.6 C 84.5 101.1 84.5 100.5 84.5 100 C 84.5 99 84.6 98 84.8 97 C 84.8 97 84.8 96.9 84.8 96.9 C 84.9 96.4 85 96 85.2 95.6 C 85.3 95.2 85.4 94.9 85.5 94.5 C 85.6 94.3 85.6 94.2 85.7 94 C 85.7 93.9 85.8 93.8 85.8 93.8 C 86 93.4 86.2 93 86.3 92.7 C 86.4 92.6 86.4 92.5 86.5 92.4 C 86.7 92.1 86.9 91.7 87.1 91.4 C 87.3 91.1 87.5 90.8 87.8 90.5 C 88 90.2 88.2 90 88.4 89.7 C 88.6 89.5 88.8 89.3 88.9 89.1 C 89 89 89.1 89 89.2 88.9 C 89.4 88.7 89.7 88.4 89.9 88.2 C 90.2 88 90.5 87.8 90.8 87.5 C 90.8 87.5 90.9 87.5 90.9 87.5 C 91.1 87.3 91.4 87.1 91.6 87 C 91.9 86.8 92.2 86.6 92.5 86.4 C 92.6 86.4 92.6 86.4 92.6 86.3 C 93.1 86.1 93.5 85.9 94 85.7 C 94.4 85.6 94.7 85.4 95.1 85.3 C 95.3 85.2 95.5 85.2 95.7 85.1 C 96 85 96.4 84.9 96.8 84.8 C 96.8 84.8 96.8 84.8 96.9 84.8 C 96.9 84.8 96.9 84.8 96.9 84.8 C 97.4 84.7 97.9 84.6 98.4 84.6 C 98.9 84.5 99.5 84.5 100 84.5 z "}],i["AC.IC.EMT STATION LOCATION"]=[{type:"path",stroke:!1,d:"M 100 55 L 70 80 L 75 80 L 75 125 L 125 125 L 125 80 L 130 80 L 100 55 z M 95 80 L 105 80 L 105 91.3 L 114.8 85.7 L 119.8 94.3 L 110 100 L 119.8 105.7 L 114.8 114.3 L 105 108.7 L 105 120 L 95 120 L 95 108.7 L 85.2 114.3 L 80.2 105.7 L 90 100 L 80.2 94.3 L 85.2 85.7 L 95 91.3 L 95 80 z "},{type:"path",stroke:!1,fill:!!R&&G,d:"M 95 80 L 95 91.3 L 85.2 85.7 L 80.2 94.3 L 90 100 L 80.2 105.7 L 85.2 114.3 L 95 108.7 L 95 120 L 105 120 L 105 108.7 L 114.8 114.3 L 119.8 105.7 L 110 100 L 119.8 94.3 L 114.8 85.7 L 105 91.3 L 105 80 L 95 80 z "}],i["AC.IC.HEALTH DEPARTMENT FACILITY"]=[{type:"path",stroke:!1,d:"M 131.4,83.6 100,68.4 68.5,83.5 z m -26.4,14.6 0,-9.7 -10.1,0 0,9.7 -9.5,0 0,10.4 9.5,0 0,9.5 10.1,0 0,-9.5 9.6,0 0,-10.4 z m -27.2,19.5 0,-27.8 1.4,0 0,-3.7 -7.3,0 0,3.7 1.2,0 0,27.8 -1.2,0 0,3.8 7.3,0 0,-3.8 z m 48.7,0 0,-27.8 1.4,0 0,-3.7 -7.3,0 0,3.7 1.2,0 0,27.8 -1.2,0 0,3.8 7.3,0 0,-3.8 z m -56.4,5.1 0,3 59.4,0 0,-3 z m -1.8,6.1 0,2.8 63.2,0 0,-2.8 z"}],i["AC.IC.MEDICAL FACILITIES OUTPATIENT"]=[{type:"path",stroke:!1,d:"m 81.8,63.6 26.6,9 0,63.9 -26.6,-9.1 v -63.8 l 0,0 z m -1.6,65 29.9,10.4 v -10.6 h 9.8 V 61 H 80.2 v 67.6 l 0,0 z m 21.4,-18.1 c 0,1.1 1,2.6 2.2,2.6 0.8,0 1.2,-0.8 1.2,-1.6 v -0.4 c 0,-1.2 -1.1,-3 -2,-3 -0.8,0 -1.4,0.8 -1.4,1.6 v 0.8 H 101.5 z M 85.9,90.9 c 0.9,0.1 5.3,1.8 5.3,2.4 v 7.1 l 5.7,2.2 v -7.5 l 5.5,1.9 V 89.1 C 101.5,88.8 96.9,87.2 96.9,86.6 V 79.5 L 91.2,77.6 v 7.4 l -5.3,-2 v 7.9 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 81.8 63.6 L 81.8 127.4 L 108.4 136.6 L 108.4 72.7 L 81.8 63.6 z M 91.2 77.6 L 96.9 79.5 L 96.9 86.6 C 96.9 87.2 101.5 88.9 102.3 89.1 L 102.3 97 L 96.8 95.2 L 96.8 102.6 L 91.1 100.4 L 91.1 93.3 C 91.1 92.6 86.8 91 85.9 90.9 L 85.9 83 L 91.2 85 L 91.2 77.6 z M 102.9 108.1 C 103.9 108.1 105 109.9 105 111.2 L 105 111.6 C 105 112.4 104.6 113.2 103.8 113.2 C 102.5 113.2 101.5 111.6 101.5 110.6 L 101.5 110.6 L 101.5 109.8 C 101.5 108.9 102.1 108.1 102.9 108.1 z "}],i["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]=[{type:"path",stroke:!1,d:"m 73.7,89.7 c 0.4,4.9 2.3,11.3 3.4,15.6 1.4,5.7 3.5,8.7 6.1,13.1 2.2,3.6 3.4,9.6 5.6,13.4 0.7,1.3 2.8,5.3 3.6,6 0.5,0.4 5.5,4 5.6,4 1.6,0 9.7,-0.4 10.4,-0.7 0.3,-0.1 4.1,-6.6 4.1,-7 v -3 h -7.8 c -2.7,0 -5.6,-1.3 -8.4,-1.3 V 112.6 c 0,-2.4 1.3,-17.3 2.1,-18 0.8,-0.7 11.4,-8.2 11.9,-8.3 l -1,-8.5 c -0.5,0.2 -5.6,1 -6,0.9 -1,-0.2 -4.7,-1.4 -5.5,-1.8 -1.9,1.1 -4.4,1.8 -6.5,2.7 -1.6,0.7 -3.5,2.7 -5.5,3.7 -2.4,1.2 -3.9,1.7 -6.7,2.5 -1.6,0.4 -2.4,0.4 -3.3,1.5 -0.7,0.8 -1.7,1.8 -2.2,2.5 z m 27.8,36.1 c 0,-8.1 2,-16.8 1.9,-24.8 0,-1.2 0.2,-1.9 0.2,-3.2 0,-1.4 0.4,-1.4 1.2,-2.2 1.2,-1.1 2.4,-2 3.6,-3 2.1,-1.7 5,-4.8 7.1,-6.1 0.3,0.1 0.3,0.2 0.9,0.2 h 4.9 c 0.2,0.8 4.9,6.4 5.8,7.4 2.6,3.1 3.8,3.9 2.9,9.6 -0.5,3.2 -0.7,8.6 -1,12 -0.3,4 -0.9,8.1 -0.9,12.2 l -26.7,-2.2 z m -1.7,1.3 29.8,2.2 2.4,-31.4 -9.8,-12.6 -7.2,-0.3 c -0.2,0 -6.9,5.9 -7.8,6.5 -1.4,1.1 -2.5,2.3 -3.9,3.2 -1.7,1.2 -1.2,3.3 -1.4,5.9 -0.6,8.4 -2.1,18.1 -2.1,26.5 z m 12.8,-9 0.2,0 c 2.3,0 6.5,2.8 8.1,2.8 h 3 V 119.4 H 121.4 c -0.6,0 -6.1,-2.3 -7.2,-2.7 -1.5,-0.6 -6.6,0.3 -8.6,0.3 v 1.3 l 7.1,-0.3 z m -5.6,-7.9 0.2,1.5 c 3.1,-0.7 5.6,-1.4 8.7,-0.8 1.3,0.3 2.8,0.6 4.2,0.9 2.5,0.6 2.8,1.2 3.3,-1 -1.3,0 -6.8,-1.3 -8.4,-1.7 -2.5,-0.7 -5.5,0.4 -8.1,1.1 z m -0.2,-8.1 0.5,1.4 5.7,-1.9 5,3.7 8,-1 -0.3,-1.7 -7.3,1 c -0.8,-0.6 -4.7,-3.6 -5.3,-3.6 -0.5,0 -5.6,1.9 -6.2,2.2 z m 10.7,-7.3 h 1.1 c 1.2,0 2.5,-1.3 2.5,-2.5 v -0.4 c 0,-1.4 -1.6,-2.5 -3,-2.5 -4.4,-0 -3.6,5.5 -0.6,5.5 z M 67.9,81.8 c 0,1.5 3.2,4.4 4.2,5.1 l 1.5,-1.6 -2.1,-4.7 h -2.2 c -0.5,0 -1.5,1.1 -1.5,1.2 z M 110.2,70.5 c 0.8,0.4 2.4,0.8 2.4,1.9 0,0.9 -0.5,1.4 -0.6,2.1 l -2.6,-0.4 c -1,-0.1 -4.2,0.6 -5.8,0.6 v 1.1 c 0,1.1 4,0 5.6,0 h 0.4 c 1.7,0 5.4,1.2 6.2,1.9 0.5,0.5 1.4,5.2 1.9,6.2 1.8,-0.9 1.3,-0.5 0.6,-3.2 -0.3,-0.9 -1.1,-3.1 -1.1,-4 l -3.9,-1.6 1.2,-2.3 c -1.1,-2.1 -0.8,-3.6 -4,-3.6 l -0.3,1.2 z m -36.5,6.6 c 0,0.9 2,4.6 2.2,6 0.3,0.1 1.1,0.4 1.1,0.4 0.3,0 2.1,-0.9 2.8,-1.1 -0.7,-3.1 -1.7,-6.6 -4.3,-7.9 -0.2,0.7 -1.7,2.3 -1.7,2.5 z m 5.9,-3.6 c 1.9,4.1 0.4,3.7 4.2,7 l 2.4,-1.2 v -3.8 c 0,-1.5 -1.2,-3.6 -1.3,-5.3 l -1.9,-0.2 h -1.7 l -1.6,3.7 z m 7.6,-2.8 2.5,5 3.9,-0.8 c 0,-1 0.6,-2.5 0.6,-3.4 0,-2.2 -1.1,-4.7 -1.1,-6.9 H 88.5 l -1.3,6 z M 97.8,62.8 c 0,0.6 0.2,7.2 0.3,7.4 0.3,1 3.7,2.6 5.5,2.4 0.9,-0.1 2.5,-0.3 3.5,-0.4 1.8,-0.2 1.2,-0.6 1.5,-2.6 0.2,-1.9 0.6,-4.9 1.1,-6.8 -0.4,-0.8 -2.4,-4.7 -3.2,-4.7 h -5.1 c -0.7,0 -3,4 -3.5,4.7 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 115.6 86.6 C 113.5 88 110.6 91 108.5 92.7 C 107.3 93.7 106 94.6 104.8 95.7 C 104 96.4 103.6 96.5 103.6 97.8 C 103.6 99.2 103.4 99.9 103.4 101.1 C 103.5 109.1 101.5 117.8 101.5 125.9 L 128.2 128 C 128.2 124 128.8 119.9 129.1 115.8 C 129.3 112.4 129.6 107.1 130.1 103.8 C 131 98.1 129.8 97.3 127.2 94.2 C 126.3 93.1 121.6 87.6 121.4 86.8 L 116.5 86.8 C 115.9 86.8 115.9 86.7 115.6 86.6 z M 118.2 89.3 C 119.5 89.3 121.1 90.4 121.1 91.9 L 121.1 92.3 C 121.1 93.6 119.8 94.9 118.6 94.9 L 117.5 94.9 C 114.5 94.9 113.8 89.3 118.2 89.3 z M 113.1 100 C 113.7 100 117.6 103.1 118.4 103.7 L 125.7 102.6 L 126 104.3 L 118 105.3 L 113 101.6 L 107.3 103.6 L 106.9 102.2 C 107.5 101.9 112.5 100 113.1 100 z M 113.2 109 C 113.9 109 114.5 109.1 115.2 109.2 C 116.7 109.6 122.2 110.9 123.5 110.9 C 123 113 122.7 112.4 120.2 111.8 C 118.8 111.5 117.3 111.2 116 110.9 C 112.8 110.3 110.4 111 107.3 111.8 L 107.1 110.3 C 109 109.8 111.2 109.1 113.2 109 z M 112.5 116.5 C 113.2 116.5 113.8 116.6 114.2 116.8 C 115.2 117.1 120.8 119.4 121.4 119.4 L 123.9 119.4 L 123.9 121 L 121 121 C 119.4 121 115.1 118.2 112.9 118.2 L 112.6 118.2 L 105.6 118.4 L 105.6 117.1 C 107.1 117.1 110.4 116.5 112.5 116.5 z"}],i["AC.IC.TRIAGE"]=[{type:"path",stroke:!1,d:"M 91.6 69 C 87.3 69 83.6 71.5 83.6 75.3 L 83.6 83.3 L 80.5 83.3 C 74 83.3 73.6 88.1 71.2 91.5 C 69.3 94.3 63 94.4 63 100.9 L 63 131 L 137 131 L 137 102.6 C 137 99.5 136.2 97.3 134.7 95.6 C 133.2 94 130.8 93.6 129.1 92 C 126 88.8 126.9 83.3 119.1 83.3 L 116.2 83.3 L 116.2 75.5 C 116.2 71.3 112.9 69 108.4 69 L 91.6 69 z M 89.9 76 L 110.1 76 L 110.1 83.3 L 89.9 83.3 L 89.9 76 z M 95.3 90.4 L 104.4 90.4 L 104.4 99.4 L 112.2 94.9 L 116.8 102.8 L 109.1 107.3 L 116.8 111.9 L 112.1 119.8 L 104.4 115.3 L 104.4 124.1 L 95.3 124.1 L 95.3 115.3 L 87.6 119.7 L 83 111.8 L 90.7 107.3 L 83 102.8 L 87.6 94.9 L 95.3 99.3 L 95.3 90.4 z "},{type:"path",stroke:!1,fill:!!R&&G,d:"m 112.1,119.8 4.6,-7.9 -7.6,-4.6 7.7,-4.5 -4.6,-7.9 -7.7,4.4 -0,-8.9 -9.1,0 0,8.9 -7.7,-4.4 -4.5,7.9 7.6,4.5 -7.6,4.5 4.5,7.9 7.7,-4.4 0,8.8 9.1,0 0,-8.8 z"}],i["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]=[i["GR.IC.FF.EMERGENCY OPERATION"],a("i")],i["AC.IC.FIRE HYDRANT"]=[{type:"path",stroke:!1,d:"m 80,131.3 v -1 c 1.3,0.1 5.7,1.8 7.7,2.2 2.8,0.6 5.8,1 9.1,1 h 6.5 c 3.4,0 6.1,-0.4 8.9,-1 2,-0.4 6.5,-2.1 7.7,-2.2 v 1 c 0,2.9 -12.5,4.5 -16.6,4.5 h -6.4 c -4.1,0 -16.9,-1.6 -16.9,-4.5 l 0,0 z m 17.9,-43.4 4.5,0.1 12.4,0.4 v 8.3 h 6.3 v 11.9 h -6.3 v 17.4 l 4.5,1.3 c -1.2,1.6 -12.2,3.3 -15.8,3.3 h -6.4 c -3.5,0 -15,-1.8 -16,-3.2 l 4.6,-1.6 0.1,-17.2 h -6.3 V 96.7 h 6.3 v -8.3 l 12.4,-0.4 0,0 z m 25.7,5.9 h 3 v 6.7 h 3.2 v 3.9 h -3.2 v 6.7 h -3 V 93.8 z m -50,0 h 2.9 v 17.2 h -2.9 v -6.7 h -3.5 v -3.9 h 3.4 V 93.8 h 0.1 z m 26.1,-8.3 c -5.2,0 -9.7,0.2 -14.8,0.2 -4.4,0 -3.5,-2.6 -1.8,-2.8 2.1,-0.3 4.9,-0.1 6.9,-0.4 5.3,-0.8 23.6,-0.3 28.1,0.8 0.2,1.8 0.4,1.5 -1,2.4 l -15.8,-0.2 -1.6,0.1 z m -1,-21.1 h 2.9 v 3.8 h 2 v 1.8 c 3.2,0.7 5.3,1.1 7.4,3.1 1.3,1.3 3.5,4.3 3.7,6.7 l -10.4,-0.3 -9.9,0.1 0.2,-0.1 -9.1,0.5 c 0.4,-4.7 5.2,-9.7 10.4,-9.7 h 0.8 v -2 h 2 v -3.8 z m -2.6,1.2 h -2 v 2.2 c -5.7,0.5 -10.6,6.6 -11.1,12.5 -2.2,0.2 -2.3,1.3 -3.4,2.1 l -0.2,1.6 c -0.3,2.2 2,3.9 3.6,4.3 v 5.5 h -3.6 v -2.4 h -8.3 v 6.7 h -3.2 V 107 h 3.2 v 6.3 h 8.3 v -2.4 h 3.6 V 123.8 c -2.3,0.6 -5.5,2 -5.5,4.9 v 2 c 0,6.3 12.9,7.7 19.8,7.7 h 5.9 c 6.9,0 19.4,-1.2 19.4,-7.7 v -2 c 0,-2.8 -3,-4.3 -5.3,-4.9 v -12.9 h 3.6 v 2.4 h 8.1 V 107 h 3.2 v -9.1 h -3.2 v -6.4 h -8.1 v 2.4 h -3.6 v -5.5 c 1.6,-0.3 3.6,-1.8 3.6,-3.8 0,-2.2 -1.6,-3.9 -3.6,-4 -0.5,-5.9 -5.7,-12.1 -11.4,-12.6 v -2.2 h -2 V 61.6 h -7.9 v 4 z m 2.9,47.2 c -4,0 -8.3,-5 -8.1,-9.3 0.2,-4.4 4.2,-9 8.3,-9 h 2 c 4.2,0 8.3,4.7 8.3,9.1 0,4.3 -4,9.1 -8.1,9.1 h -2.4 l 0,0 z m -10.5,-9.9 v 1.8 c 0,5.2 5.4,10.8 10.5,10.8 h 2.4 c 5.6,0 10.8,-5.8 10.8,-11.8 0,-6 -5.3,-11.8 -10.9,-11.8 h -2.1 C 93.7,92 88.4,97.5 88.4,103 l 0,0 z m 9.5,0.8 c 0.3,-0.6 0.8,-1.8 1.4,-1.8 h 1.4 c 0.7,0 1.4,1.3 1.4,2 0,0.1 -0.9,1.6 -1.4,1.6 h -1.4 c -0.6,0.1 -1.1,-1.2 -1.4,-1.8 z m -2.9,0 2.2,4.3 h 5 c 0.7,0 2.4,-3.6 2.9,-4.3 l -2.4,-4.5 h -4.9 c -0.8,0.1 -2.5,3.7 -2.9,4.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 97.9,103.8 c 0.3,-0.6 0.8,-1.8 1.4,-1.8 h 1.4 c 0.7,0 1.4,1.3 1.4,2 0,0.1 -0.9,1.6 -1.4,1.6 h -1.4 c -0.6,0.1 -1.1,-1.2 -1.4,-1.8 z m 1.2,-9.1 c -4.1,0 -8.1,4.6 -8.3,9 -0.2,4.3 4.1,9.3 8.1,9.3 l 2.4,0 c 4,0 8.1,-4.9 8.1,-9.1 0,-4.4 -4.1,-9.1 -8.3,-9.1 l -2,0 z m -1.2,4.7 4.9,0 2.4,4.5 c -0.4,0.7 -2.1,4.3 -2.9,4.3 l -5,0 -2.3,-4.3 c 0.4,-0.8 2.1,-4.4 2.9,-4.5 z M 98.7,64.5 h 2.9 v 3.8 h 2 v 1.8 c 3.2,0.7 5.3,1.1 7.4,3.1 1.3,1.3 3.5,4.3 3.7,6.7 l -10.4,-0.3 -9.9,0.1 0.2,-0.1 -9.1,0.5 c 0.4,-4.7 5.2,-9.7 10.4,-9.7 h 0.8 v -2 h 2 v -3.8 z m 1,21.1 c -5.2,0 -9.7,0.2 -14.8,0.2 -4.4,0 -3.5,-2.6 -1.8,-2.8 2.1,-0.3 4.9,-0.1 6.9,-0.4 5.3,-0.8 23.6,-0.3 28.1,0.8 0.2,1.8 0.4,1.5 -1,2.4 l -15.8,-0.2 -1.6,0.1 z m -26.1,8.3 h 2.9 v 17.2 h -2.9 v -6.7 h -3.5 v -3.9 h 3.4 V 93.8 h 0.1 z m 50,0 h 3 v 6.7 h 3.2 v 3.9 h -3.2 v 6.7 h -3 V 93.8 z m -25.7,-5.9 -12.4,0.4 0,8.3 -6.3,0 0,11.9 6.3,0 -0.1,17.3 -4.6,1.6 c 1.1,1.5 12.5,3.3 16,3.3 l 6.4,0 c 3.6,0 14.7,-1.7 15.8,-3.3 l -4.5,-1.3 0,-17.4 6.3,0 0,-11.9 -6.3,0 0,-8.3 -12.4,-0.4 -4.5,-0.1 z m 1.2,4.2 2.1,0 c 5.7,0 10.9,5.8 10.9,11.8 0,5.9 -5.2,11.8 -10.8,11.8 l -2.4,0 c -5.2,0 -10.5,-5.6 -10.5,-10.8 l 0,-1.8 c 0,-5.5 5.3,-11 10.7,-10.9 z M 80,131.3 v -1 c 1.3,0.1 5.7,1.8 7.7,2.2 2.8,0.6 5.8,1 9.1,1 h 6.5 c 3.4,0 6.1,-0.4 8.9,-1 2,-0.4 6.5,-2.1 7.7,-2.2 v 1 c 0,2.9 -12.5,4.5 -16.6,4.5 h -6.4 c -4.1,0 -16.9,-1.6 -16.9,-4.5 l 0,0 z"}],i["AC.IC.OTHER WATER SUPPLY LOCATION"]=[{type:"path",stroke:!1,d:"m 113.2,116.5 c 0,-2.9 4.4,-9.3 5.8,-11.8 2.8,-5 3.1,-6.8 4.6,-13 2.1,1.4 2.2,4.3 3,7.1 0.8,2.8 1.6,4.8 2.9,7 2.2,3.8 6.7,8 5,14.1 -1.6,5.8 -5.2,7.8 -12.2,7.5 -5.8,-0.2 -9.1,-4.9 -9.1,-11 z m -1.2,-0.4 v 0.6 c 0,7.5 4.6,12.2 12,12.2 6.8,0 12,-4.6 12,-11 v -1.3 c 0,-5 -4.7,-10 -6.6,-13.8 -1.1,-2.2 -1.6,-5.5 -2.3,-8.1 -0.9,-3.3 -2.4,-4 -4.8,-5.6 0,13.6 -10.3,20 -10.3,26.8 z m 4.8,3.6 c 0,2.4 1.8,4.4 3.8,4.4 0.7,0 1.5,-0.6 1.7,-1.3 -1.6,-0.4 -3.2,-2.5 -3.4,-4.4 l -2.1,1.3 z M 89.2,73 v 15.8 h -2.1 v -15.8 l 0.6,-0.1 1.5,0.1 z m -10.4,2.3 h 6.6 v 11 H 78.8 v -11 z m 37.2,1.1 c 0,-0.5 0.2,-0.6 0.6,-0.6 h 1.5 c 0.5,0 0.6,0.2 0.6,0.6 v 9.1 h -2.8 v -9.1 z m -24.9,-1.3 22.8,2.4 v 6.5 l -22.8,1.9 v -10.7 z m -27,11.8 h 12.9 v 1 l 8.3,0.1 1.2,2.4 1.6,0.3 c 0.6,0.1 1,-0.2 1.8,-0.3 l 0.9,-0.6 0.2,-2.4 22.8,-1.6 c 1.2,2.5 4.2,1.6 6.6,1 0,-0.7 0.2,-0.8 0.2,-1.5 v -9.5 c 0,-1.5 -0.8,-2.1 -2.3,-2.1 h -2.1 c -3.8,0 0.2,2.5 -5,1.6 -2.1,-0.4 -4.6,-0.4 -6.7,-0.7 -3.3,-0.5 -10.4,-1.3 -13.5,-1.3 -0.1,-3.1 -5.6,-3.3 -5.7,0.4 h -8.4 v 0.6 h -13 l 0.1,12.4 0,0 z m 15.6,-4.8 0,1.9 4.6,0 0,-1.9 z m 0,-4.2 0,1.7 4.6,0 0,-1.7 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 91,75.1 22.8,2.4 v 6.5 l -22.8,1.9 v -10.7 z m 24.9,1.3 c 0,-0.5 0.2,-0.6 0.6,-0.6 h 1.5 c 0.5,0 0.6,0.2 0.6,0.6 v 9.1 h -2.8 v -9.1 z M 78.8,75.3 l 0,11 6.6,0 0,-11 -6.6,0 z m 0.8,2.6 4.7,0 0,1.7 -4.7,0 0,-1.7 z m 0,4.2 4.7,0 0,1.9 -4.7,0 0,-1.9 z M 123.5,91.8 c -1.4,6.2 -1.8,8 -4.6,13 -1.3,2.5 -5.8,8.9 -5.8,11.8 0,6.1 3.3,10.8 9.1,11 7,0.2 10.5,-1.7 12.2,-7.5 1.7,-6.1 -2.8,-10.3 -5,-14.1 -1.3,-2.2 -2,-4.3 -2.9,-7 -0.8,-2.8 -0.9,-5.7 -3,-7.1 z m -4.6,26.7 c 0.2,1.9 1.8,4 3.4,4.4 -0.2,0.6 -1,1.3 -1.7,1.3 -2,0 -3.8,-2.1 -3.8,-4.4 l 2.1,-1.3 z M 89.2,73 v 15.8 h -2.1 v -15.8 l 0.6,-0.1 1.5,0.1 z"}],i["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]=a("€$£"),i["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 87.9,87.3 c -3.2,0 -5.8,2.6 -5.8,5.8 0,2.8 2.1,5.2 4.8,5.7 l 0,3.3 -3.8,0 0,2 3.8,0 0,9.4 2,0 0,-9.4 3.8,0 0,-2 -3.8,0 0,-3.3 c 2.7,-0.5 4.8,-2.8 4.8,-5.7 0,-3.2 -2.6,-5.8 -5.8,-5.8 z m 24,0 c -3.2,0 -5.8,2.6 -5.8,5.8 0,2.8 2.1,5.2 4.8,5.7 l 0,3.3 -3.8,0 0,2 3.8,0 0,9.4 2,0 0,-9.4 3.8,0 0,-2 -3.8,0 0,-3.3 c 2.7,-0.5 4.8,-2.8 4.8,-5.7 0,-3.2 -2.6,-5.8 -5.8,-5.8 z m -24,2 c 2.1,0 3.8,1.7 3.8,3.8 0,2.1 -1.7,3.8 -3.8,3.8 -2.1,0 -3.8,-1.7 -3.8,-3.8 0,-2.1 1.7,-3.8 3.8,-3.8 z m 24,0 c 2.1,0 3.8,1.7 3.8,3.8 0,2.1 -1.7,3.8 -3.8,3.8 -2.1,0 -3.8,-1.7 -3.8,-3.8 0,-2.1 1.7,-3.8 3.8,-3.8 z m 24.2,37.8 0,-3 -72.1,0 0,3 z m -3,-6.2 0,-2.8 -66.2,0 0,2.8 z M 66.8,98.2 c 0,1.3 -0.7,2.6 -0.7,4.3 -0,1.8 -0.2,3.1 -0.2,5 v 3.2 l 0.6,3.6 h 2.7 l -0.8,-6.4 v -1.8 c 0,-8.1 5,-17.9 9.3,-21.5 5.6,-4.6 11.6,-9.1 21.7,-9.1 h 0.9 c 9,0 17.1,4.4 21.6,8.8 3.2,3.2 4.1,4.7 6.4,8.7 1.4,2.4 3.3,8.4 3.3,12 v 4.3 c 0,1.4 -0.7,3 -0.7,4.4 v 0.5 h 2.7 l 0.6,-6.4 v -3.8 c 0,-1.6 -1,-5.2 -1.4,-6.6 -0.8,-2.5 -1.3,-3.6 -2.3,-5.7 -1.8,-3.8 -3.8,-6.4 -6.7,-9.3 -4.6,-4.6 -13.6,-9.6 -22.6,-9.6 h -2.5 c -7.8,0 -16.6,4.1 -20.6,7.9 -2.8,2.7 -4.4,4.1 -6.7,7.5 -1.1,1.6 -1.5,3 -2.5,4.6 -0.9,1.6 -1.2,4 -2,5.2 z"}],i["GR.IN.IC.RECREATIONAL AREA"]=[{type:"path",stroke:!1,d:"m 96.4,78.8 8.1,-0 c 0.9,0 2.4,5.7 2.4,6.9 l 1.5,4.3 c 0,0.4 2,6.6 2,7 v 0.6 l -19.4,-0 5.4,-18.8 z m -19.9,-0 11.1,0 -3.5,11.2 c 0,1.7 -1.9,5.7 -1.9,6.9 v 0.6 h -20.8 v 7.2 l 18.5,0 -1.2,3 -0.1,0.8 -2.6,8.3 -3.6,11.5 c 1.1,0 9.3,0.1 9.7,-0.1 0.2,-0.1 2,-6.8 2.3,-7.7 0.5,-1.2 4.5,-15 4.5,-15.2 v -0.6 l 23.5,0 6.7,23.6 9.8,0 -1.4,-4.8 -0.7,-2.6 -2.4,-7.8 -0.9,-2.8 -1.7,-5.7 h 15.8 v -7.2 h -18.2 l -2.9,-8.9 -0.1,-0.8 -1,-3 -1.7,-6.2 h 10.6 v -7.2 h -47.9 v 7.2 l 0,0 0,0 z m 62.1,16.9 0,-6.1 -15.2,0 0,6.1 z m -62.3,0 0,-6.1 -14.9,0 0,6.1 z"}],i["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 73.1,111.2 c 0,-3.8 1,-5.8 2.3,-8.4 1.4,-2.8 3.3,-3.8 4.6,-5.8 l -1.1,-8.2 c -2.6,0.7 -7.7,6.5 -9.2,9 -2.4,4.1 -3.8,7.9 -3.8,14.2 v 3.3 c 0,2.2 2.2,8.1 3.1,9.6 2,3.2 3,4.5 5.5,7.1 3.6,3.6 10.7,7.1 17.9,7.1 h 1 c 4.9,0 9.9,-1.6 13.1,-3.6 1.7,-1 8.5,-6.2 8.5,-7.8 0,-1.2 -3.1,-6.6 -3.5,-8.4 -1.2,1.5 -1.6,3 -3,4.8 -1.2,1.5 -2.3,2.7 -3.8,3.8 -2.6,2 -6.8,4 -11.3,4 h -1.2 c -10.2,0 -19.1,-9 -19.1,-19.3 v -1.4 l 0,0 z m 8.9,-37.9 c 0.5,0.4 0.5,2.9 0.5,4 L 85,106.8 l 25.4,0 10,23 c 1.5,-0.1 5.5,-1.5 7.1,-2.1 1.2,-0.4 6.5,-1.4 6.5,-2.6 v -0.2 c 0,-0.7 -1.9,-4.8 -2,-6.3 l -7.6,2.6 -9,-21.6 H 91.6 l -0.4,-6 h 17.3 v -5.4 H 90.8 l -1.1,-12.9 c 2.6,-0.2 5.2,-3.9 5.2,-6.7 v -2.2 h -0.5 v -0.8 c 0,-0.8 -2.1,-3.1 -2.7,-3.5 -1,-0.7 -3.3,-1.6 -4.8,-1.3 -2.2,0.4 -3.2,0.8 -4.4,2 -0.7,0.7 -2.2,3.2 -2.2,4.3 v 1.2 c 0,2.4 0.8,3.6 1.7,4.9 l 0,0 z m 0.5,4 c 0,-1.1 0,-3.6 -0.5,-4 0,1.1 -0,3.6 0.5,4 z"}],i["GR.IN.IC.ADULT DAY CARE"]=[{type:"path",stroke:!1,d:"m 107,118.3 v -0.2 c 0,-15.5 22.4,-14.7 22.4,-0.6 v 1.3 c 0,5.4 -5.3,10.4 -10.8,10.4 h -0.6 c -5.9,0 -11,-5.1 -11,-11 z m -1.6,-22.2 h 4.6 v 10 c 0,0 -3.2,3.3 -3.8,4.3 -0.5,0.8 -2.2,4.7 -2.2,5.8 v 2.3 c 0,6.8 6.6,13.7 13.3,13.7 h 1 c 5.8,0 10.8,-5 11,-5 h 7.1 v -1.9 h -3.2 c 0.2,-0.5 0.8,-1.3 0.8,-1.9 v -11 c 0,-1.9 -1,-3.3 -2.1,-4 h -3.3 l -0.8,-0.7 c 1.1,-0.3 2,-0.9 2,-2.2 v -0.4 c 0,-0.5 -1,-1.7 -1.6,-1.7 h -5 v -5.4 c 0,-2.7 -1.5,-4.2 -4.2,-4.2 h -2.1 c -5.9,0 -4.6,5.8 -4.6,11.6 l -0.6,0.4 V 94.7 c -0.4,-0.2 -0.4,-0.4 -0.8,-0.4 h -5.4 v 1.7 z m -22.6,1 c 0,-2.2 3.3,-4.8 4.5,-6.6 1.4,1 1.4,1.8 3.4,2.8 1.4,0.7 2.6,1.4 4,1.9 2.4,0.9 2.2,-0.1 4.3,1.9 0.9,0.9 1.8,2.5 3.5,2.5 0.4,0 0.8,-0.8 0.8,-1.3 v -1.1 c 0,-2.8 -3.3,-3.6 -5.3,-4.5 -2.3,-0.9 -5.3,-1.6 -6.1,-3.8 -0.8,-2.3 -2.2,-4.6 -2.9,-6.9 -0.7,-2.1 -1.9,-5.1 -4.6,-5.1 h -0.4 c -3,0 -7.4,7.5 -8.1,10.4 -0.6,2.3 -1.6,4.7 -2.1,7.2 -0.5,2.8 -0.6,5.2 -1.1,8 -0.3,1.8 0.1,2.3 -0.6,4 -0.4,1.2 -0.8,2.3 -1.2,3.4 -0.9,2.3 -1.7,4.6 -2.5,6.8 -0.8,2.1 -4.9,11.8 -4.9,13.5 0,2.6 6.2,1.3 7.7,1.1 -0,-1.9 -2.3,-1.6 -3.1,-2.7 2.1,-3.1 3.8,-6.3 5.8,-9.5 1,-1.7 4.6,-9.2 5.4,-9.8 0.6,0.4 3,3.1 3.8,3.9 1.9,1.9 2,1.8 2.8,4.8 1.1,4.2 1.9,7.7 1.9,13.1 l 1.7,0.2 4.2,-0 c 1.3,0 1.8,-0.2 2.3,-1 -0.6,-1 -3.1,-1.7 -4.6,-2.1 v -1.1 c 0,-0.4 -0.1,-0.4 -0.4,-0.8 v -12.1 c -1.5,-2.3 -2.9,-4.9 -4.6,-7.1 -1.1,-1.6 -3.8,-5.2 -3.8,-7.6 v -2.5 l 0,0 z m 30.3,-9.7 v 1.6 c 0,1.5 2.3,3.9 4.2,3.9 h 0.8 c 2.1,0 4.2,-2.3 4.2,-4.5 V 87.6 c 0,-2.2 -2.2,-4.2 -4.5,-4.2 h -0.1 c -2.3,-0 -4.6,2 -4.6,4 z m -28.4,-15.6 v 1.7 c 0,0.6 1,2.1 1.4,2.5 0.6,0.6 1.8,1.2 2.9,1.2 h 1 c 2,0 4.2,-2.2 4.2,-4 v -1.4 c 0,-1.6 -2.5,-3.9 -4.5,-3.9 h -0.7 c -1.8,0 -4.2,2.2 -4.2,3.9 z"}],i["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 79.5,127.9 h -7.8 v -21.4 c 0,-1 6.8,-13.3 7.4,-13.6 1,-0.6 13.9,-7.1 14.1,-7.1 0.5,0 13.2,6.3 14.4,7 0.4,0.3 7.7,13.1 7.7,13.7 v 21.4 h -7.6 V 110.4 H 79.5 v 17.5 z m 37.4,-39.4 h 15.4 v 39.8 h -12.1 v -18.8 h 2.6 c -0.5,-0.8 -5.8,-9.8 -5.8,-10 V 88.5 z m 0.2,-1.9 c 0,-4.4 2.9,-8.2 7.2,-8.2 h 0.4 c 4.5,0 7.6,3.7 7.6,8.2 h -15.2 v 0 z M 105.2,82.1 h 8.9 c -0.2,1.6 -0.9,2.5 -0.9,5 0,2 0,3.9 0,5.8 -1.4,-1 -0.9,-2.8 -3.2,-4 -1.2,-0.6 -3.8,-2 -4.8,-2.3 v -4.6 z m 0,-2.8 c 0,-2.8 3.8,-7.4 6.9,-7.4 h 0.6 c 3.1,0 5.5,1.8 6.7,3.7 -0.2,0.2 -4.8,4.3 -4.8,4.3 h -9.5 v -0.6 z m -11.9,1.5 c -3.2,1.7 -6.6,3.2 -9.9,4.8 -1.7,0.9 -3.3,1.5 -5,2.4 -2.8,1.4 -2.3,0.7 -4,3.1 -0.9,1.3 -1.8,3.2 -2.7,4.7 -0.9,1.6 -1.9,3 -2.8,4.6 -1.6,2.9 -3.6,6.5 -5.4,9.1 h 2.8 v 22.5 H 84 V 114.7 h 19 v 17.3 h 33.3 V 87.5 c 0,-7.5 -4.2,-13 -11.7,-13 h -1.7 c -0.8,-2.9 -5.9,-6.5 -10,-6.5 h -0.4 c -6.4,0 -11,5.9 -11,12.1 v 4.6 l -8.2,-3.9 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 79.5,110.4 h 28.1 v 17.5 h 7.6 v -21.4 c 0,-0.6 -7.2,-13.4 -7.7,-13.7 -1.1,-0.8 -13.8,-7.1 -14.4,-7.1 -0.1,0 -13,6.5 -14.1,7.1 -0.6,0.4 -7.3,12.6 -7.3,13.6 v 21.4 h 7.8 v -17.5 z m 37.4,-10.8 c 0,0.1 5.3,9.2 5.8,10 h -2.6 v 18.8 h 12.1 v -39.8 h -15.4 v 11 z m 0.2,-13 h 15.1 c 0,-4.6 -3,-8.2 -7.6,-8.2 h -0.4 c -4.2,-0 -7.2,3.8 -7.2,8.2 z m -11.9,0 c 1.1,0.2 3.6,1.7 4.8,2.3 2.2,1.1 1.7,3 3.2,3.9 0,-2 0,-3.9 0,-5.8 0,-2.5 0.7,-3.4 0.9,-5 h -8.9 v 4.6 z m 0,-7.4 v 0.6 h 9.5 c 0,0 4.6,-4.1 4.8,-4.3 -1.2,-1.8 -3.6,-3.7 -6.7,-3.7 h -0.6 c -3.1,0 -6.9,4.6 -6.9,7.4 z"}],i["GR.IN.IC.AGRICULTURAL LABORATORY"]=[{type:"path",stroke:!1,d:"m 98.4,77.9 -0.1,0.3 2.6,0.6 0,-0.3 z m 2.1,7.3 0.4,-3.2 -0.3,-0.1 -0.4,3.2 z m -3.8,-16.8 0.1,-0.2 -1.4,-0.3 1,-2.6 -0.4,-0.3 -1.7,5.7 0.1,0 0.3,-0.1 0.7,-2.4 z m -1,5.3 c 0.8,0 0.5,-1.7 0.8,-2.3 l -0.4,-0.1 -0.4,2.4 z m 1.4,-5.5 0.6,-2.6 -0.4,-0.1 -0.6,2.7 z m 0.2,-2.7 0.1,-0.3 -1,-0.2 -0.1,0.2 z m 11.8,65.6 0,5.6 3.3,0 c 1.1,0 1.9,-0.2 2.4,-0.7 0.5,-0.5 0.8,-1.2 0.8,-2.1 -10e-6,-0.9 -0.3,-1.6 -0.8,-2.1 -0.5,-0.5 -1.3,-0.7 -2.4,-0.7 l -3.3,0 m 0,-6.2 0,4.6 3,0 c 1,0 1.7,-0.2 2.2,-0.6 0.5,-0.4 0.7,-1 0.7,-1.7 -10e-6,-0.8 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.6 -2.2,-0.6 l -3,0 m -2.1,-1.7 5.2,0 c 1.6,1e-5 2.8,0.3 3.6,1 0.8,0.7 1.3,1.6 1.3,2.8 -2e-5,0.9 -0.2,1.7 -0.7,2.2 -0.4,0.5 -1.1,0.9 -1.9,1 1,0.2 1.8,0.7 2.3,1.4 0.6,0.7 0.8,1.5 0.8,2.6 -1e-5,1.4 -0.5,2.4 -1.4,3.1 -0.9,0.7 -2.2,1.1 -3.9,1.1 l -5.4,0 0,-15.2 m -9.2,2 -2.8,7.5 5.6,0 -2.8,-7.5 m -1.2,-2 2.3,0 5.8,15.2 -2.1,0 -1.4,-3.9 -6.8,0 -1.4,3.9 -2.2,0 5.8,-15.2 m -16,0 2.1,0 0,13.4 7.4,0 0,1.7 -9.4,0 0,-15.2 M 98.6,92.5 c 0.9,-0.2 0.8,-1.8 1.1,-2.6 l 0.9,0.4 -1.4,4.2 -0.6,-2 z m -0.2,-0.4 0.1,0.2 c -0.5,-0.1 -0.8,-1.3 -0.8,-1.9 l 0.4,0.6 -0.3,-2.2 1.6,0.8 c -0,0.7 -0.4,2.3 -0.9,2.4 z m -0.9,-2.3 -0.6,-1.4 c 0.4,0.1 0.6,0.3 0.6,0.9 v 0.5 z m 2.6,-4.4 -0.6,3.9 -1.7,-0.8 v -3.4 -0.3 l 2.3,0.6 z m -2.6,-1.1 0.4,0.1 v 0.4 h -0.4 v 3.5 l -0.8,-0.4 0.1,0.4 h -0.2 c 0,-0.9 -1.2,-2.8 -1.6,-3.5 0.1,-0.1 0.1,-0.1 0.1,-0.4 v -0.4 l 2.4,0.6 0,-0.4 z m 6.1,-1.7 2.5,0.6 v 0.4 c 0,0.2 0,0.2 0.1,0.3 -1.2,0 -1.9,0.4 -2.8,0.8 l 0.2,-2 z m -6.1,1.7 -2.4,-0.8 0.1,-1.8 v -1 l 2.4,0.5 -0.2,3 z m 8.6,-1.6 c -0.3,0 -2.3,-0.4 -2.4,-0.6 0,0 0.2,-2.3 0.2,-2.7 l 2.2,0.4 0.1,1.6 -0,1.2 z m -12.7,-2.4 c 0.4,0 0.7,0.2 1.1,0.2 0.8,0.2 0.4,0.1 0.4,0.7 v 2.1 c -0.3,-0 -0.7,-0.2 -1,-0.3 -0.7,-0.2 -0.5,0.1 -0.5,-0.4 v -2.4 z m 10.7,-4.2 1.7,0.4 0.3,3 -2.2,-0.4 0.2,-3 z m -6.4,5.2 v -0.4 l -2.4,-0.5 0.3,-2.8 2.4,0.5 -0.2,2.9 h 0.3 v 0.4 h -0.3 z m -4,-4.2 1.6,0.4 -0.3,2.9 -1.5,-0.4 0.2,-2.9 z m 7.6,1.4 0.3,-3.1 2.4,0.6 -0.3,3 -2.4,-0.5 z m -0.4,-0.1 0.4,0.1 v 0.4 c 0.4,0 2.3,0.4 2.4,0.6 0,0.1 -0.2,2.3 -0.2,2.6 -0.8,0 -1.6,-0.4 -2.3,-0.4 -0.2,0 -0.2,0.2 -0.2,0.4 l 2.4,0.5 -0.2,2.2 h 0.2 c -0.5,0.7 -1.1,1.6 -1.4,2.4 -0.3,0.8 -0.7,2.1 -1.1,2.8 l -0.9,-0.4 0.6,-4 h -0.2 l -0.2,-0.1 v -0.4 l -2.3,-0.7 0.2,-3 2.5,0.5 v -0.3 h 0.4 l 0.2,-2.8 h -0.3 l -0.3,2.7 -2.4,-0.4 0.2,-2.9 c -0.3,-0.1 -0.2,0 -0.3,-0.4 h 0.2 l 0.2,0.1 0.4,-3.2 2.4,0.6 -0.3,3.1 z m 3.2,-5.4 v -0.3 l 0.3,0.1 v 0.3 c 1,0.1 1.1,0.1 1.2,1 0,0.3 0.2,1.8 0.3,1.9 l -1.7,-0.3 v 0.4 h -0.3 v -0.5 l -2.4,-0.6 0.3,-2.5 2.3,0.4 z m 0.2,-0.2 0.2,-2.9 c 0.6,0.1 0.7,2.4 0.8,3.1 l -1,-0.2 z m -5.1,-0.9 2.4,0.5 -0.3,2.6 -2.4,-0.6 0.4,-2.5 z m 4.9,0.8 c -3.3,-0.8 -2,0 -2,-3.3 l 2.2,0.4 -0.2,2.9 z m -4.4,-3.8 c 3.2,0.8 1.9,-0.2 1.9,3.2 l -2.3,-0.5 0.4,-2.7 z m -2.5,-0.4 2.1,0.4 -0.4,2.7 -2.2,-0.4 0.4,-2.6 z m 7.1,1.3 v -0.4 l -2.2,-0.4 0.2,-2.6 c 0.3,0 0.7,0.1 1.1,0.2 0.6,0.1 0.5,0 0.7,0.6 0.3,1 0.3,0.9 0.3,2.2 l 0.3,0.4 -0.4,0.1 z m -4.1,-3.9 1.8,0.4 -0.2,2.6 -2.1,-0.4 0.4,-2.6 z m 2.3,-2.2 1.4,2.6 -1.5,-0.2 0.1,-2.4 z m -1.6,-1.6 0,-0.1 1.2,1.2 -0.1,0 c 0.3,-0.1 0.3,-0.1 0.4,0.3 l -0.2,-0.2 -0.2,2.6 -1.8,-0.4 0.7,-3.5 z m -2.9,3 c 0.5,-1.1 0.3,-3.4 1.9,-3.4 0.3,0 0.2,0 0.5,0.1 l -0.6,3.7 -1.8,-0.4 z m -0.4,-0.1 0.4,0.1 v 0.3 l 1.8,0.4 -0.4,2.6 -2.1,-0.4 v 0.2 l -0.1,0.2 -0.2,-0.1 h -0.2 l -0.5,2.6 -1.6,-0.3 v 0.3 c 0.5,0 1,0.3 1.4,0.3 0.2,0 0,-0.2 0.5,-0.2 v 0.4 l 2.2,0.4 -0.3,2.4 -2.4,-0.6 v 0.4 l 2.3,0.6 -0.3,3.1 -2.4,-0.6 0.4,-3.2 h -0.4 c -0,0.8 -0.3,1.7 -0.3,2.4 -0,0.8 -0,0.7 -0.7,0.5 -0.2,-0 -0.9,-0.1 -0.9,-0.3 -0,-0.3 0.2,-2 0.3,-2.4 0.2,-1.2 0.5,-0.4 1.7,-0.3 l 0.1,-0.3 c -0.2,-0.1 -1.6,-0.3 -1.6,-0.5 0,-0.8 0.4,-1.5 0.4,-2.3 -0.6,0.1 -0.7,2.3 -0.8,3 -0.1,0.8 -0.4,2.6 -0.4,3.3 0,0.8 -0.2,2.4 -0.2,3.5 0,1.3 -0.1,2.4 -0.1,3.8 h 0.3 v -0.9 l 1.5,0.4 v 1 l -3.4,-0.5 h -0.1 c -5,0 -8.8,9.7 -8.8,15.4 0,2.3 0.8,5.4 2,6.2 0.7,-1.4 1.3,-3.1 2,-4.6 0.8,-1.5 1.4,-3.1 2.1,-4.6 0.3,-0.7 0.7,-1.5 1,-2.2 0.4,-0.8 0.8,-1.5 1.8,-1.2 0.9,0.3 1.9,3.2 2.1,4.6 0.5,3.8 0,9 0.6,12.6 0.7,4 2.3,6.4 5.4,8 1,-0.4 2.5,-0.6 3.4,-1.2 0.9,-0.6 1.8,-1.2 2.4,-2.2 1.2,-1.8 2,-4.1 2,-7.2 l 0,-0.6 -0.3,-5.6 v -0.3 c 0,-2.7 0.5,-8.3 2.8,-8.3 h 0.1 c 1.4,0 2,0.6 2.6,1.4 0.6,0.8 1.2,1.4 1.8,2.2 1.2,1.5 2.6,2.9 2.6,5.5 v 0.6 l 0.4,0.1 c 0.4,-1.6 1.8,-2.8 1.8,-5.2 v -1.5 c 0,-3.5 -1.4,-6.2 -3,-8.3 -0.8,-1.1 -1.8,-2 -2.8,-2.8 -0.7,-0.5 -2.7,-1.9 -3.8,-1.9 l -0.8,-0 -2.3,0.4 c -0.2,-0.8 0.1,-2 -0.1,-3.1 -0.1,-0.8 -0.2,-2.5 -0.2,-3.3 -0.2,-2.1 -0.5,-4.2 -0.9,-6.1 -0.6,-3.3 -2,-8.2 -4.6,-9.4 v 0.3 l -0.4,-0.1 0.1,-0.3 -0.8,-0.1 c -0.9,-0.1 -1.9,0.8 -2.3,1.3 -0.2,0.3 -1.7,2 -0.8,2 0.2,-0.6 1.3,-2.2 1.8,-2.4 l -0.8,2.7 z m 3,20.4 1.6,0.5 0.2,-0 c -0.1,-0.5 -1.4,-0.6 -1.8,-0.8 v 0.4 z m 3.6,-9.8 0.2,-2.6 -0.2,-0.1 -0.2,2.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 98.6,92.5 0.6,2 1.4,-4.2 -0.9,-0.4 c -0.3,0.7 -0.2,2.3 -1.1,2.6 z m -0.6,-1.4 -0.3,-0.6 c 0,0.6 0.4,1.8 0.8,1.9 l -0.1,-0.2 c 0.6,-0.2 0.9,-1.8 1,-2.4 l -1.6,-0.8 0.2,2.2 z m 2.4,-5.9 c 0.4,0.2 1.7,0.3 1.8,0.8 l -0.2,0 -1.6,-0.5 -0.6,4 0.9,0.5 c 0.4,-0.7 0.8,-2 1.1,-2.8 0.4,-0.8 1,-1.7 1.4,-2.4 h -0.2 l 0.2,-2.3 -2.4,-0.5 -0.4,3.2 z m -1,4.1 0.6,-3.9 -2.3,-0.6 0,0.2 0,3.4 z m 0.6,-4.2 0.4,-3.2 -2.5,-0.5 -0.2,3 z m 0.7,-6.6 0.3,-3.1 -2.4,-0.6 -0.4,3.2 z m -5.1,-4.8 -0.1,0.3 c -1.2,-0 -1.5,-0.9 -1.7,0.3 -0.1,0.4 -0.3,2.1 -0.3,2.4 0,0.2 0.7,0.2 1,0.3 0.7,0.2 0.7,0.2 0.7,-0.5 0,-0.8 0.3,-1.7 0.4,-2.4 h 0.4 l -0.4,3.2 2.4,0.6 0.4,-3.2 -2.3,-0.5 v -0.4 l 2.3,0.6 0.3,-2.4 -2.2,-0.4 c -0.3,0.6 0,2.3 -0.8,2.3 z m 8.3,-1 0.2,-2.9 -2.2,-0.4 c 0,3.4 -1.3,2.6 2,3.3 z m -6.2,11.7 -0.4,-0.1 v 0.4 l -2.4,-0.6 v 0.4 c 0,0.2 -0,0.2 -0.1,0.4 0.4,0.7 1.6,2.6 1.6,3.5 h 0.2 l -0.1,-0.4 0.8,0.4 v -3.5 h 0.4 l -0,-0.4 0,0 z m -0.3,5.4 0,-0.6 c 0,-0.5 -0.2,-0.8 -0.6,-0.9 l 0.6,1.4 z m 2.6,-4.8 0,0.4 0.2,0.1 0.2,0 0,-0.3 z m 3.3,-0.4 c 0.8,-0.4 1.5,-0.8 2.8,-0.8 -0.1,-0.1 -0.1,-0.1 -0.1,-0.2 v -0.4 l -2.5,-0.6 -0.2,2 z m -8.3,-1.1 2.4,0.8 0.2,-3 -2.5,-0.5 0,1 z m -1.8,-0.8 c 0,0.5 -0.2,0.2 0.5,0.4 0.3,0.1 0.6,0.2 1,0.3 v -2.1 c 0,-0.7 0.4,-0.6 -0.4,-0.7 -0.4,-0.1 -0.7,-0.2 -1.1,-0.2 v 2.4 z m 7.5,-4 h 0.3 l -0.2,2.8 h -0.4 v 0.4 l 0.3,0.1 c 0,-0.2 0,-0.4 0.2,-0.4 0.7,0 1.6,0.4 2.3,0.4 0,-0.3 0.3,-2.5 0.2,-2.6 -0,-0.2 -2,-0.6 -2.3,-0.6 v -0.4 l -0.4,-0.1 v 0.3 z m 3.3,-8.9 0.4,-0 -0.3,-0.4 c 0,-1.3 -0,-1.2 -0.3,-2.2 -0.2,-0.6 -0,-0.5 -0.7,-0.6 -0.4,-0.1 -0.8,-0.2 -1.1,-0.2 l -0.2,2.6 2.2,0.4 v 0.4 z m -2.4,-0.9 0.2,-2.6 -1.8,-0.4 -0.4,2.6 z m 4.4,13.8 0,-1.2 -0.1,-1.6 -2.2,-0.4 c 0,0.4 -0.2,2.7 -0.2,2.7 0.1,0.2 2.2,0.6 2.4,0.6 z m -7.8,-4.6 -0.2,2.9 2.4,0.4 0.3,-2.7 z m -0.2,3.2 0,-0.4 -0.3,0 0.2,-2.9 -2.3,-0.5 -0.3,2.8 2.4,0.5 0,0.4 z m -3.1,-1 0.3,-2.9 -1.6,-0.4 -0.2,2.9 z m 11.1,-0.8 -0.3,-3 -1.7,-0.4 -0.2,3 z m -2,-6.6 -2.3,-0.4 -0.3,2.5 2.4,0.6 z m -0.4,6 0.2,-3 -2.4,-0.6 -0.2,3.1 z m -2.4,-4 0.3,-2.6 -2.3,-0.5 -0.3,2.5 z m -2.9,3.2 0.1,-0.3 -0.2,-0.1 h -0.2 c 0,0.4 -0.1,0.3 0.2,0.4 z m 5.8,-2.4 1.7,0.3 c -0.1,-0.2 -0.2,-1.6 -0.3,-1.9 -0.1,-1 -0.2,-1 -1.2,-1 l -0.2,2.6 z m 0,0.3 0,-0.3 -0.3,-0.1 0,0.4 z m 0.2,-3 0,-0.3 -0.2,-0.1 0,0.3 z m 0,-0.3 1,0.2 c -0.1,-0.6 -0.2,-3 -0.8,-3 l -0.2,2.9 z m -5.1,-1.1 2.3,0.5 c 0,-3.4 1.3,-2.5 -1.9,-3.2 l -0.4,2.7 z m -2.5,-0.6 2.2,0.4 0.4,-2.7 -2.1,-0.4 z m 1.1,-5.6 -0.6,2.6 2.1,0.4 0.4,-2.6 -1.8,-0.4 0,-0.3 -0.4,-0.1 -0.1,0.3 z m -0.6,2.8 0,-0.2 -0.4,0 -0.1,0.2 0.2,0 0.2,0.1 z m 0.2,-2.9 -1,-0.2 -1,2.6 1.4,0.3 z m 4.8,0.7 1.5,0.2 -1.4,-2.6 z m -2.1,-0.4 1.8,0.4 0.2,-2.6 0.2,0.2 c -0,-0.4 -0,-0.3 -0.4,-0.3 l 0.1,-0.1 -1.2,-1.1 -0.1,0.1 -0.7,3.5 z m -2.2,-0.4 1.8,0.4 0.6,-3.7 c -0.4,-0 -0.2,-0.1 -0.6,-0.1 -1.6,0 -1.4,2.3 -1.9,3.4 z"}],i["GR.IN.IC.ANIMAL FEEDLOT"]=[{type:"path",stroke:!1,d:"m 121.6,107.1 -0.4,-2.3 -0.2,-2 h 16.3 l -1.7,13.2 h -13 v -0.6 l -1,-8.2 z m 16.1,4.3 0.4,-2.3 0.9,-6.2 -0.1,-1.6 h -19.6 l 1.4,10.7 0.3,0.6 0.5,4.3 -0.1,0.6 h 15.7 v -1.6 l 0.6,-4.6 z M 123,82.6 c -3.3,-0.8 -4.6,0.4 -6.8,1.9 h -1.4 c -0.3,0.4 -0.6,1.2 -1.2,1.2 h -1 c -2.2,0 -3.9,-1.8 -5.8,-1.8 h -0.6 c -0.9,0 -2.1,0.8 -3.9,0.8 -5.1,0 -3.9,0.2 -8,1.5 -2,0.6 -6.2,0.8 -8.9,0.8 h -5.2 c -2.8,0 -5,-0.6 -7.2,-0.6 -2.6,0 -4.7,0.2 -7.4,0.2 -0.5,0 -0.5,-0.1 -0.8,-0.2 -2.4,1.2 -3.1,4.2 -3.1,7.8 0,3.6 -0.6,6.3 -0.6,10.1 v 0.2 c 0,0.6 0.1,0.6 0.2,1 l 1,-0.3 0,-0.5 h 0.4 l 0.2,-12.2 h 0.2 c 0,2 0.1,4.5 0.6,6 0.4,1.2 1.7,3.8 1.7,4.9 v 0.2 l -1.6,13.2 h 3.7 c 0,-1.4 -0.4,-1.1 -0.4,-2.1 v -2.1 c 0,-1.4 1,-4.2 2.3,-4.3 0.4,1.5 3.3,3.7 3.3,6.8 v 0.6 c 0,0.6 -0.1,0.6 -0.2,1 0.4,-0.1 0.5,-0.2 1,-0.2 1.2,0 3.5,0.7 3.5,-0.4 0,-0.3 -1.9,-3.2 -2.2,-3.5 -0.4,-0.5 -1.3,-3.6 -1.3,-4.3 v -0.2 c 0,-0.2 1.2,-2.3 1.2,-4.8 4,2.2 3.5,2.7 9.9,2.7 2.2,0 4.2,0.5 6,0.4 1,-0 3.3,-1.4 4.3,-1.9 0,1.2 0.4,2.4 0.2,3.3 l -1.2,8 c 1,0.3 1.6,0.6 2.8,0.6 h 0.6 -0.2 l 0.7,-11.3 c 0.6,0.4 2.8,7.1 2.6,8.4 l -0.3,2.3 c 0.8,0.4 1.5,0.6 2.6,0.6 h 1 l -1.2,-7.4 -0.1,-0.8 c 0,-0.9 1.6,-0.7 2.5,-1.2 0.6,-0.3 1.4,-1.2 1.8,-1.7 1.1,-1.5 2,-2.7 3,-4.2 3.9,-5.4 3.5,-2.4 10.2,-4 v -0.6 h 1.6 c 1,0 1.8,-0.8 1.8,-1.8 v -0.4 c 0,-2.4 -2.5,-2.5 -2.5,-5.6 l -3.3,-3.4 5.4,-2.9 z m 14.6,28.9 c 0.4,-0.4 0.4,-1.5 0.4,-2.3 l -0.4,2.3 z m -16.1,-4.3 c 0,-0.8 0,-1.9 -0.4,-2.3 l 0.4,2.3 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 121.2,104.9 c 0.4,0.4 0.4,1.5 0.4,2.3 l 1,8.2 v 0.6 h 13 l 1.7,-13.2 h -16.3 l 0.2,2.1 z"}],i["GR.I.FF.SATELLITE"]=[{type:"path",stroke:!N&&O,fill:!!N&&O,d:"m 115,70 20,0 0,55 -20,0 z m -25,5 20,0 0,45 -20,0 z m -25,-5 20,0 0,55 -20,0 z"},{type:"path",fill:!1,d:"m 110,100 5,0 m -30,0 5,0 m 10,27 0,-7 m -20,15 c 10,-10 30,-10 40,0"}],i["GR.IN.IC.FARM/RANCH"]=[{type:"path",stroke:!1,d:"m 119.9,119 v -0.2 c 0,-2 1.5,-3.7 3.5,-3.7 h 0.4 c 2.2,0 3.7,1.6 3.7,4 v 0.6 c 0,1.2 -2.1,2.8 -3.7,2.8 h -0.4 c -1.9,0 -3.5,-1.6 -3.5,-3.5 z m -52,-10.7 c 1.3,-2 1.1,-2.7 3.2,-4.4 1.3,-1 3.3,-1.9 5.5,-1.9 h 0.6 c 4.7,0 9,4.1 9,8.8 v 1.1 c 0,5 -4,9.2 -8.8,9.2 H 76.9 c -5.4,0 -9.4,-4.2 -9.4,-9.6 0,-1.4 0.4,-1.6 0.4,-3 l 0,0 z m 7.9,-20.2 c -0.8,0 -1.5,-4.4 -1.8,-5.3 -0.2,-1 -1.3,-4.6 -1.3,-5.5 h 24.1 c 0.5,0 1.3,-0.8 1.3,-1.3 v -2.2 c 0,-0.7 -0.8,-1.1 -1.5,-1.1 h -31.8 c -0.7,0 -1.5,0.4 -1.5,1.1 v 2.2 c 0,0.5 0.8,1.3 1.3,1.3 h 3.5 l 2.6,16 -6.8,2.5 2.8,3.4 c -1,1.3 -2.3,2.1 -3.6,4.2 -0.4,0.8 -1.9,4.4 -1.9,5.5 v 2.2 c 0,5.4 1.6,8.8 4.3,11.5 2.3,2.3 6.5,4.8 11,4.8 h 0.4 c 8.8,0 15.8,-7.4 15.8,-16 h 13.4 c 0.6,0 1.9,1.4 2.4,1.8 h 8.6 c -1.1,1.6 -2.2,2.9 -2.2,5.7 0,4.6 3.9,8.6 8.6,8.6 4.4,0 8.8,-3.8 8.8,-7.9 v -2 c 0,-1.2 -1.5,-3.4 -2,-4.4 h 7.2 l 1,-4.6 h -7.2 v -0.6 l 1.2,-8.1 -0.1,-3.3 c 0,-0.6 -1.7,-2.1 -2.2,-2.4 l -16,-0.5 V 78.2 c 0,-0.5 -0.4,-0.9 -0.9,-0.9 -0.5,0 -0.9,0.4 -0.9,0.9 v 15.4 c -2.2,-0.2 -6,-0.4 -8.1,-0.4 -1.3,0 -2.9,0.1 -4.2,0 -2.1,-0.1 -2,-1.3 -2.9,-1.3 h -4.6 l 2,12.3 H 91.1 V 98.6 C 91.1,97.8 87.1,94.4 86.1,94.4 H 78.7 V 89.8 L 77.5,88.1 75.8,88 z M 88.1,92 c 0,0.5 0.1,0.2 0.2,0.9 h 0.6 c 0.9,0 8.5,-6.4 10.1,-6.8 V 85.4 c 0,-0.5 -0.2,-0.6 -0.6,-0.6 h -0.4 C 97.5,84.7 88.1,91.6 88.1,92 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 119.9,119 c 0,1.9 1.6,3.5 3.5,3.5 h 0.4 c 1.6,0 3.7,-1.6 3.7,-2.8 v -0.7 c 0,-2.3 -1.5,-4 -3.7,-4 h -0.4 c -2,0 -3.5,1.7 -3.5,3.7 v 0.2 z m -52,-10.7 c 0,1.4 -0.4,1.7 -0.4,3.1 0,5.4 4.1,9.6 9.4,9.6 h 0.6 c 4.8,0 8.8,-4.3 8.8,-9.2 v -1.1 c 0,-4.7 -4.3,-8.8 -9,-8.8 h -0.6 c -2.2,0 -4.3,0.9 -5.5,1.9 -2.2,1.7 -1.9,2.4 -3.2,4.4 z"}],i["GR.IN.IC.GRAIN STORAGE"]=[{type:"path",stroke:!1,d:"m 122.8,69.6 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -1e-5,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -1e-5,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 0,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -2e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.6e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -2e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,0 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -10e-7,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -4e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,0 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,1e-6 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -10e-6,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -10e-7,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.6e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 m 24.4,48.1 -0.2,2.4 h 0.4 l -1.7,3 -1,-1.7 -0.1,2 0.5,0.6 -1.2,3 -1.5,-3 0.4,3.6 0.8,0.2 -3.1,9.7 -0.5,-4.2 0.1,-1.8 c 0,-1.5 0.8,-4.7 1,-6.3 0.3,-1.7 1.3,-4.5 1.4,-6 0.6,0.1 0.4,0.2 0.8,0.2 0.4,0 2.3,-1.5 2.6,-1.8 l -3,0.6 0.8,-2.7 c 0.6,0.1 0.4,0.2 0.8,0.2 0.4,0 2.6,-1.7 2.8,-2 l -3,0.8 0.7,-2.4 c 1.3,0 2.1,-0.8 2.8,-1.4 l -2.4,0.4 0.8,-2 c 1.1,-0 1.5,-0.9 1.8,-1.8 l -1.3,0.7 2.3,-6.1 -0.8,-0.1 -2.1,5.9 -0.3,0 -0.5,-2.1 -0.1,-0 c 0,1.5 -0.4,1.6 -0.4,2.4 0,0.5 0.2,0.5 0.6,0.6 l -0.9,2.1 -1,-1.4 c -0.1,1.6 -0.4,1.9 0.7,2.4 l -0.8,2.4 -1.7,-2.2 0.4,2.8 0.6,0.5 -0.5,2.7 -1.5,-1.9 0.2,2.4 0.9,0.5 c 0,0.4 -1,4.6 -1.2,6 -0.4,2.3 -0.9,3.5 -0.9,6.3 l -1.2,-3.6 0.6,-0.8 -0,-2 -1.2,1.2 -0.8,-2.8 0.6,-0.8 -0,-2 -1.1,1.2 -0.7,-1.7 c 1,-0.5 1,-1.6 1,-3.2 l -1.3,2.1 c -0.7,-0.2 -1.1,-1.4 -1.3,-2.3 0.3,-0.4 0.6,-0.5 0.6,-1 v -1.6 h -0.4 l -0.7,1.8 c -0.2,-0.2 -0.7,-0.7 -0.7,-1.2 0,-0.4 0.6,-0.3 0.6,-1 v -0.2 c 0,-1.1 -0.4,-1.1 -0.4,-2.4 l -0.7,2.3 -0.3,0 -2.8,-5.9 -0.4,0.2 2.5,5.7 -1.3,-0.7 1,1.9 1,0 0.6,1 -2.6,-0.4 c 0.4,0.4 1.7,1.4 2.4,1.4 0.1,0 0.4,-0.1 0.6,-0.2 l 1,2.2 -3.2,-0.6 c 1.1,1 2,1.7 3.6,1.6 l 1.1,2.7 -2.9,-0.4 c 0.7,1 1.7,1.3 3,1.5 0.4,0.1 1.1,2.8 1.2,3.5 l -3,-0.6 2.2,1.6 h 1 c 1.2,2.3 2.4,11.9 2.4,15.8 h 1.4 l -0.2,-2.2 0,-1 c 0,-4 2.9,-9.3 3.2,-12.3 0.8,0.1 0.5,0.2 1,0.2 0.2,0 2.9,-1.2 3.2,-1.4 l -3.6,0.3 1.2,-3.1 0.8,0.4 3,-1.3 -3.2,0.2 1.4,-2.8 c 0.4,0.1 0.4,0.2 1,0.2 0.3,0 2.1,-1 2.4,-1.2 l -2.8,0.2 1.4,-2 c 1.5,0.1 1.5,-0.4 2.4,-1.6 l -1.4,0.4 c 0.5,-1.1 1.2,-2.2 1.8,-3.2 0.4,-0.6 2,-2.7 0.8,-3 l 0.2,0.1 -3.4,5.8 -0.4,-2.3 h -0.2 c 0,1.4 -0.6,1.7 -0.6,2.2 0,0.3 0.3,0.7 0.4,1 l -1.5,2 -0.7,-1.9 z m -25.4,13.5 c 0,-3.7 0.1,-9.1 0.7,-12.4 0.4,-2 0.1,-4 0.6,-6 0.4,-1.7 0.4,-4.2 0.8,-5.8 2.8,-10.1 1,-11.8 14.3,-11.8 h 4.4 c 11.6,0 12.6,1.2 14.2,11.3 1.2,7.6 2,14.6 2,23.6 v 8.3 l -0.4,3.6 c -1.1,1.6 -2.1,3.4 -4.9,3.4 H 86.7 c -5.4,0 -5.3,-6.4 -5.3,-11.9 v -2.4 z m -5.8,-32.5 c 2.1,-0.6 0.4,-1.3 4.4,-1 2.4,0.2 3,0.3 5,0.8 -0.7,1.1 -4.6,3 -6.5,3 h -0.4 c -0.9,0 -2.4,-1.2 -2.4,-2 v -0.8 h -0 z m 43.2,-1.5 c 2.2,-0.2 4.8,0.9 4.8,3.1 v 0.6 c 0,0.6 -0.6,0.8 -1.2,0.8 h -0.6 c -1.8,0 -6.2,-2.7 -6.9,-3.9 l 4,-0.6 z m -36.6,-6.7 c 0,-1 1,-2.2 1.8,-2.2 h 0.6 c 0.6,0 1.4,1.6 1.4,2.2 v 4.2 c 0,1.3 -0.4,1.5 -0.4,2.8 -1,-0.3 -3.4,-4.3 -3.4,-5.5 v -1.4 h -0 z m 31.7,2.8 c 0,-2.8 -0,-5.2 2.8,-5.2 h 0.6 c 0.6,0 1,0.7 1,1.4 0,2 -3,6.8 -4.4,7.3 v -3.6 h -0 z m 1.4,3.8 c 0.5,-1.8 3.8,-5 3.8,-7.1 v -1.4 c -0.6,-0.3 -0.7,-1.2 -1.6,-1.2 h -0.6 c -2.6,0 -3.8,2 -3.8,4.5 v 4.2 c -2,-0.5 -2.3,-1 -5.2,-1.2 -2,-0.2 -3.7,-0.4 -6,-0.4 h -3.6 c -4.8,0 -8.9,0.3 -12.1,2 0.2,-0.7 0.4,-0.9 0.4,-1.8 v -3.4 c 0,-1.4 -1,-3.8 -2.2,-3.8 h -0.8 c -0.8,0 -2.6,1.9 -2.6,3 0,2 2.1,5.5 3,6.8 l -5.7,-0.5 c -1.2,0 -3.4,1.1 -3.4,2.1 v 0.6 c 0,1.3 1.7,2.8 3,2.8 h 0.2 c 2.9,0 4.5,-2 6.3,-2.4 -1.9,3.5 -3.8,22 -3.8,28.1 v 6 c 0,5.9 0.3,12.3 6.1,12.3 h 26.1 c 4.1,0 6.1,-3.8 6.1,-7.9 v -10.5 c 0,-2.3 -0.2,-5.5 -0.4,-7.7 -0.2,-1.8 -0.8,-5.7 -0.8,-7.4 0,-2.6 -0.7,-4.7 -1,-7.1 -0.2,-2.1 -1.3,-4.3 -1.8,-6.2 1.2,0.6 4.9,3 6.1,3 h 1.2 c 1,0 1.8,-0.8 1.8,-1.8 v -0.2 c 0,-2.2 -1.5,-3.8 -3.8,-3.8 h -2.6 l -2.8,0.4 z m -28.1,0.6 c 0.5,1.9 8.9,3.2 11.9,3.2 h 1 c 3.1,0 12.5,-1.4 12.7,-3.6 -4.1,-1 -6.5,-1.8 -11.9,-1.8 h -1.4 c -2.4,0 -4.4,0.4 -6.5,0.6 -2.9,0.4 -3.8,1.1 -5.8,1.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 105.3,110.1 c -0.3,0.3 -2.2,1.8 -2.6,1.8 -0.4,0 -0.2,-0.1 -0.8,-0.2 0,1.5 -1.1,4.3 -1.3,6 -0.3,1.6 -1,4.8 -1,6.3 l -0.1,1.8 0.5,4.2 3.1,-9.7 -0.8,-0.2 -0.4,-3.6 1.5,3 1.2,-3 -0.5,-0.6 0.1,-2 1,1.7 1.7,-3 h -0.4 l 0.2,-2.4 -0.3,-1.2 -1.2,1.2 z m 0,0 1.2,-1.2 0.3,1.2 0.7,1.9 1.5,-2 c -0.1,-0.3 -0.4,-0.7 -0.4,-1 0,-0.5 0.6,-0.8 0.6,-2.2 h 0.2 l 0.4,2.3 3.4,-5.7 -0.2,-0.1 c 1.3,0.4 -0.4,2.4 -0.8,3 -0.6,1 -1.3,2.1 -1.8,3.2 l 1.4,-0.4 c -0.8,1.2 -0.9,1.7 -2.4,1.6 l -1.4,2 2.8,-0.2 c -0.3,0.2 -2,1.2 -2.4,1.2 -0.5,0 -0.5,-0.1 -1,-0.2 l -1.4,2.8 3.2,-0.2 -3,1.3 -0.8,-0.4 -1.2,3.1 3.6,-0.4 c -0.3,0.2 -2.9,1.4 -3.2,1.4 -0.5,0 -0.2,-0.1 -1,-0.2 -0.3,2.9 -3.2,8.2 -3.2,12.3 l -0.1,1 0.3,2.2 h -1.4 c 0,-4 -1.2,-13.6 -2.4,-15.8 h -1 l -2.2,-1.6 3,0.6 c 0,-0.7 -0.8,-3.4 -1.2,-3.5 -1.3,-0.2 -2.3,-0.5 -3,-1.5 l 2.9,0.4 -1.1,-2.8 c -1.5,0.1 -2.5,-0.6 -3.6,-1.6 l 3.2,0.6 -1.1,-2.2 c -0.2,0.1 -0.5,0.2 -0.6,0.2 -0.7,0 -2,-1 -2.4,-1.4 l 2.6,0.4 -0.6,-1 h -1 l -1,-1.9 1.3,0.7 -2.5,-5.7 0.4,-0.2 2.8,5.9 0.3,-0 0.7,-2.4 c 0,1.3 0.4,1.2 0.4,2.4 v 0.2 c 0,0.7 -0.6,0.6 -0.6,1 0,0.4 0.5,1 0.7,1.2 l 0.7,-1.8 h 0.4 v 1.6 c 0,0.5 -0.3,0.6 -0.6,1 0.2,0.9 0.5,2.1 1.3,2.3 l 1.3,-2.1 c 0,1.5 0,2.6 -1,3.2 l 0.7,1.7 1.1,-1.2 0,2 -0.6,0.8 0.8,2.8 1.2,-1.2 0,2 -0.6,0.7 1.2,3.6 c 0,-2.8 0.4,-4 0.9,-6.2 0.3,-1.3 1.3,-5.6 1.2,-6 l -0.9,-0.5 -0.2,-2.5 1.5,1.9 0.5,-2.7 -0.6,-0.5 -0.4,-2.8 1.7,2.2 0.8,-2.4 c -1,-0.5 -0.8,-0.8 -0.7,-2.4 l 1,1.4 0.9,-2.1 c -0.4,-0.1 -0.6,-0 -0.6,-0.6 0,-0.8 0.4,-0.9 0.4,-2.4 l 0.1,0 0.5,2.1 0.3,-0 2.1,-5.9 0.8,0.1 -2.3,6.1 1.3,-0.7 c -0.2,0.9 -0.6,1.8 -1.8,1.8 l -0.8,2 2.4,-0.4 c -0.7,0.6 -1.5,1.4 -2.8,1.4 l -0.7,2.4 3,-0.8 c -0.2,0.3 -2.4,2 -2.8,2 -0.4,0 -0.2,-0.1 -0.8,-0.2 l -0.8,2.7 3,-0.5 z M 87.1,90.1 c 2,-0.5 2.9,-1.2 5.8,-1.6 2.1,-0.3 4.1,-0.6 6.5,-0.6 h 1.4 c 5.4,0 7.8,0.8 11.9,1.8 -0.2,2.2 -9.6,3.6 -12.7,3.6 h -1 c -3,0 -11.4,-1.3 -11.9,-3.2 z m -5.8,33.5 v 2.4 c 0,5.5 -0.1,11.9 5.3,11.9 h 26.4 c 2.8,0 3.8,-1.7 4.9,-3.4 l 0.4,-3.6 v -8.3 c 0,-9 -0.8,-15.9 -2,-23.6 -1.6,-10.1 -2.6,-11.3 -14.2,-11.3 h -4.4 c -13.3,0 -11.6,1.7 -14.3,11.8 -0.4,1.6 -0.4,4 -0.8,5.8 -0.5,2 -0.2,3.9 -0.6,6 -0.6,3.3 -0.7,8.6 -0.7,12.4 z M 114.8,90.2 c 0.7,1.2 5.2,3.9 6.9,3.9 h 0.6 c 0.6,0 1.2,-0.2 1.2,-0.8 v -0.6 c 0,-2.2 -2.6,-3.3 -4.8,-3.1 l -4,0.6 0,0 z m -39.2,0.9 v 0.8 c 0,0.8 1.4,2 2.4,2 h 0.4 c 2,0 5.8,-1.9 6.5,-3 -2,-0.4 -2.6,-0.6 -5,-0.8 -3.8,-0.3 -2.1,0.4 -4.3,1 z m 38.3,-5.3 v 3.6 c 1.3,-0.5 4.4,-5.3 4.4,-7.3 0,-0.7 -0.4,-1.4 -1,-1.4 h -0.6 c -2.8,-0 -2.8,2.4 -2.8,5.1 z m -31.7,-2.8 v 1.4 c 0,1.3 2.4,5.3 3.4,5.5 0,-1.3 0.4,-1.5 0.4,-2.8 v -4.2 c 0,-0.6 -0.8,-2.2 -1.4,-2.2 h -0.6 c -0.8,0 -1.8,1.3 -1.8,2.2 z"}],i["GR.IN.IC.ATM"]=[{type:"path",stroke:!1,d:"m 73.6,116.3 c 5.1,-0.1 15.8,-6.6 17,-6.6 0.4,0 7.4,3.8 8.9,4.2 -0.4,0.6 -5.1,4.6 -6.2,5.7 -1.2,1.2 -4.7,5.8 -5.5,6.4 -1.6,-0.8 -14,-8.9 -14.2,-9.6 z m -15.1,-6.2 11.9,-2.5 11.1,5.6 -9.6,3 16.2,10.7 -0,-0.2 6.4,-7.5 26.9,12.7 20.3,-46.8 -50.2,-17.2 c -0.6,2.2 -5.2,9.1 -6.5,11.8 -0.8,1.8 -2.3,4.4 -3.3,6 -1.2,1.8 -2.2,4.1 -3.3,6 -1.2,2 -2.1,3.8 -3.3,5.8 -1.2,1.9 -2.1,4.2 -3.3,6 -2.4,3.6 -0.2,2.7 -5.5,3.7 -2.6,0.5 -5.2,1 -7.7,1.6 m 62,21.5 -25.2,-11.8 4.8,-4 7.3,3.5 1.2,-2.4 -23.9,-11.7 v 0.2 l -1,2.2 6,2.9 -6.2,3.4 -11.8,-5.8 -0.2,0 20.7,-37 0.2,0.1 47.4,16.1 h 0.2 l -19.4,44.2 z m 7.8,-31.3 1.1,-2 -5.8,-2.3 -0.8,2.3 z m -2.7,5.2 1.2,-1.9 -5.6,-2.3 -0.8,2.2 z m -22,-7.3 c 0.6,0.4 2.1,1.4 2.1,2.1 v 2.4 c 0,0.8 -1.7,1.5 -2.6,1.5 h -0.2 c -0.8,0 -1,-0.2 -1.7,-0.4 l 2.4,-5.7 z m -3.4,-6.4 c 0,-2.2 1.1,-2.8 3.2,-2.8 h 0.2 c 0.7,0 1,0.2 1.5,0.4 l -2.2,5.1 c -0.9,-0 -2.8,-1.2 -2.8,-2.4 v -0.2 z m 5.6,-4.2 c -0.3,-0.1 -1.2,-0.5 -1.6,-0.5 h -1.9 c -0.7,0 -2.5,0.6 -2.9,0.9 -0.3,0.2 -1.4,2.1 -1.4,2.5 v 1.7 c 0,2.1 3.8,4.2 3.8,4.9 0,0.4 -2.2,4.6 -2.4,5.7 -0.6,-0.3 -2.5,-1.8 -2.5,-2.6 v -0.6 c 0,-0.8 0.6,-1.4 0.8,-2.1 -0.9,-0.2 -2,-1.1 -2.4,-1.2 -0.4,-0.1 -1,1.7 -1,2.3 v 0.4 c 0,2.7 4.2,5.4 4.2,5.7 0,0.6 -0.4,1.4 -0.5,2 l 1.7,0.8 0.6,-1.7 c 1.4,0 2,0.8 3.6,0.8 h 0.6 c 1.4,0 2.6,-0.5 3.2,-1.3 0.3,-0.4 1.5,-2.4 1.5,-3 v -0.4 c 0,-2.6 -2.8,-4.8 -4.4,-5.9 l 2.5,-5.6 h 0.4 c 0.4,1.2 1.5,0.6 1.5,3.6 l 2.8,1.2 v -1.7 c 0,-2 -2,-4.1 -3.8,-4.6 l 0.8,-2.1 -2.1,-0.5 -0.8,1.5 z m 13,18.4 -0.9,2 5.4,2.2 -0,-0.2 1.2,-1.8 z m -22.4,-25.2 26.1,9.5 -11,24.1 -26.7,-12.8 11.6,-20.8 z m -12.5,21.2 27.8,13.4 11.7,-25.7 c -1,-0.1 -11.8,-4.2 -13.4,-4.8 -1.2,-0.5 -13.3,-5 -13.5,-5 -0.9,0 -5.4,9.5 -6.4,10.8 -0.8,1.3 -5.9,10.3 -6.1,11.2 z m 31.7,11.2 5.4,2.2 -0.1,-0.2 1.3,-1.8 c -1.1,-0.2 -5,-2.2 -5.5,-2.2 -0.4,0 -1.1,1.6 -1.2,2.1 z m -25.8,0.6 4.3,2.9 -6,5.8 -6,-4.1 7.7,-4.6 z m -9.1,4.5 7.4,4.9 7.1,-6.6 c -0.5,-0.4 -5.3,-3.6 -5.4,-3.6 -1,0 -7.6,4.9 -9.1,5.3 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 115.7,111.8 c 0,-0.5 0.8,-2.1 1.2,-2.1 0.5,0 4.4,2 5.5,2.3 l -1.3,1.8 0.1,0.2 -5.4,-2.2 z m 3.2,-7.1 5.7,2.2 -1.2,1.8 0,0.2 -5.4,-2.2 0.9,-2 z m 2.4,-4.8 5.6,2.3 -1.2,1.9 -5.2,-2 0.8,-2.2 z m 2.5,-5.3 5.8,2.3 -1.1,2 -5.5,-2 0.8,-2.3 z m -39.7,6 c 0.2,-1 5.3,-10 6.1,-11.2 0.9,-1.4 5.4,-10.8 6.4,-10.8 0.2,0 12.3,4.5 13.5,5 1.7,0.7 12.5,4.8 13.5,4.8 l -11.7,25.7 -27.8,-13.4 z m 55.9,-14.6 h -0.2 l -47.4,-16.1 -0.2,-0.1 -20.7,37 0.2,-0 11.8,5.8 6.3,-3.4 -6,-2.9 1,-2.2 v -0.2 l 23.9,11.7 -1.2,2.4 -7.3,-3.5 -4.8,4 25.2,11.8 19.4,-44.2 0,0 z m -59.1,30.9 c 1.5,-0.4 8,-5.3 9.1,-5.3 0.2,0 4.9,3.2 5.5,3.6 l -7.2,6.6 -7.4,-4.9 z m -7.2,-0.6 c 0.2,0.8 12.6,8.8 14.2,9.6 0.8,-0.6 4.3,-5.2 5.5,-6.4 1.1,-1.1 5.8,-5.1 6.2,-5.7 -1.6,-0.3 -8.5,-4.1 -8.9,-4.1 -1.2,0 -11.9,6.5 -17,6.6 z m 26.6,-25.9 v 0.2 c 0,1.2 1.8,2.4 2.7,2.4 l 2.2,-5 c -0.4,-0.2 -0.8,-0.4 -1.5,-0.4 h -0.2 c -2.1,0 -3.2,0.7 -3.2,2.8 z m 0.9,12.1 c 0.7,0.2 0.9,0.4 1.7,0.4 h 0.2 c 1,0 2.6,-0.7 2.6,-1.5 v -2.4 c 0,-0.7 -1.6,-1.7 -2.1,-2.1 l -2.4,5.6 z m 5.5,-17.7 2.1,0.5 -0.8,2.1 c 1.8,0.4 3.8,2.5 3.8,4.6 v 1.7 l -2.8,-1.1 c 0,-3 -1.1,-2.4 -1.5,-3.6 h -0.4 l -2.5,5.6 c 1.6,1.1 4.4,3.3 4.4,5.9 v 0.4 c 0,0.6 -1.2,2.6 -1.5,3 -0.6,0.8 -1.8,1.3 -3.2,1.3 h -0.6 c -1.6,0 -2.2,-0.7 -3.6,-0.8 l -0.6,1.7 -1.7,-0.8 c 0.1,-0.6 0.5,-1.4 0.5,-2 0,-0.3 -4.2,-2.9 -4.2,-5.7 v -0.4 c 0,-0.6 0.6,-2.4 1,-2.4 0.4,0.1 1.4,1 2.4,1.2 -0.2,0.7 -0.7,1.3 -0.7,2.1 v 0.6 c 0,0.8 1.8,2.3 2.4,2.6 0.2,-1 2.4,-5.3 2.4,-5.7 0,-0.7 -3.8,-2.8 -3.8,-4.9 V 89.1 c 0,-0.4 1.1,-2.3 1.4,-2.5 0.4,-0.3 2.2,-0.9 2.9,-0.9 h 1.9 c 0.4,0 1.4,0.4 1.6,0.5 l 0.8,-1.4 z m -21.8,15.4 26.6,12.9 11,-24.1 -26,-9.5 -11.6,20.8 z m 5,12.1 -7.7,4.6 6,4.1 6,-5.8 z"}],i["GR.IN.IC.BANK"]=[{type:"path",stroke:!1,d:"m 100.8,110.6 c 2.4,0 5.3,1.9 5.3,4.4 v 0.7 c 0,3.1 -2.1,4.9 -5.3,4.9 v -9.9 z m -6.6,-8.8 c 0,-2.3 1.7,-4.4 4,-4.4 h 0.7 v 9 c -1.9,-0.4 -4.6,-1.6 -4.6,-3.7 v -0.9 z m 6.6,-4.4 c 2.2,0 4.6,1.6 4.6,3.5 v 0.9 h 3.5 c 0,-5.3 -3.7,-6.7 -8.1,-7.7 v -2.4 h -2 v 2.4 c -3.9,0 -8.2,3.5 -8.2,7 v 2.6 c 0,1.3 2,3.6 3,4.2 1,0.6 3.8,1.8 5.1,1.9 v 10.6 c -3.4,-0.1 -5.2,-2.6 -5.2,-6.1 h -3.3 l 0.2,3.5 c 1.1,1.7 0.9,2.8 2.9,4.1 1.3,0.8 3.4,1.6 5.5,1.6 v 4 h 2 v -3.9 c 4.9,0 9,-3.4 9,-8.1 v -1.8 c 0,-4.2 -5.4,-6 -9,-6.8 v -9.4 z m -25.3,15.2 v -2.4 c 0,-2.2 2.6,-7.4 3.1,-9.4 0.7,-2.7 3.1,-5.9 4.7,-8 3.5,-4.6 8.5,-8.9 16.5,-8.9 h 4.4 c 3.4,0 8.8,4.3 10.4,6.5 1.3,1.7 2.2,3.1 3.4,5 0.5,0.7 2.7,5.2 2.7,5.9 v 0.7 h 0.4 v 0.7 c 0,0.4 0.9,1.5 0.8,3.1 l 0.5,0.7 c 0,2 1.1,6.8 1.3,9 0.4,3.2 1.3,5.6 -0.7,8.5 0,2.4 -5.2,8.7 -6.2,8.8 l -9.2,-1.5 c -1.8,-0.3 -6.8,2 -9.2,2 -2,0 -5.6,-1.7 -7.5,-1.7 -1.6,0 -3.2,1.3 -5.5,1.3 h -0.6 c -1.9,0 -5.9,-6.1 -7,-7.7 -1.8,-2.6 -2.4,-8 -2.4,-12.3 z m 30.7,-31 -6.1,-1.1 c -0.8,-0.1 -5.2,1.1 -5.8,1.3 l -6.3,-11.5 1.7,0.5 v -2.9 l 8.9,3.4 0.3,-3.5 3.2,2.5 5.7,-2.6 v 2.6 l 7.5,-1.4 -9.3,13 0,0 z m 11.8,-14.5 -9.1,1.6 v -2.8 c -0.9,0.5 -5.7,2.9 -6.6,2.9 -0.1,0 -3.4,-2.6 -4,-2.9 l -0.7,4 -8.8,-3.6 v 2.9 l -3.1,-1 8.1,15.1 -0.2,0.1 c -4.6,1.1 -10.3,6.8 -12.7,10.4 -0.8,1.1 -1.3,2.6 -2,3.7 -1.4,1.8 -0.9,2.5 -1.7,4 -0.6,1.1 -2.9,7.2 -2.9,8.6 v 3.7 c 0,1 0.7,5.8 1,6.7 0.4,1.4 0.4,2 0.8,3.2 0.3,0.9 0.9,1.6 1.4,2.3 1.3,2 4.8,7.5 7.6,7.5 2.5,0 4.3,-1.3 5.7,-1.3 2.3,0 5.2,1.7 7.3,1.7 h 0.7 c 2,0 5.7,-1.4 8,-1.9 1.8,-0.3 5.9,1 8.5,1 h 1.7 c 1.7,0 4.8,-4.2 5.8,-5.5 1.1,-1.4 1.3,-2.2 1.7,-4 0.1,-0.4 1.1,-4.3 1.1,-4.4 0,-3 -0.9,-4.1 -1.1,-5.9 -0.2,-2.4 -0.4,-4 -0.7,-6.1 -0.2,-1.7 -2.8,-8.6 -3.6,-10.3 -2.4,-4.9 -7.7,-13.2 -14,-13.7 l 11.7,-16.2 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 100.8,120.4 c 3.2,0 5.3,-1.7 5.3,-4.9 v -0.6 c 0,-2.5 -2.9,-4.3 -5.3,-4.4 v 9.8 z m -6.6,-18.7 v 0.9 c 0,2.2 2.8,3.3 4.6,3.7 v -9 h -0.7 c -2.3,0 -4,2 -4,4.4 z m 6.6,5 c 3.6,0.8 9,2.6 9,6.8 v 1.7 c 0,4.7 -4.1,8.1 -9,8.1 v 4 h -2 v -3.9 c -2,0 -4.2,-0.7 -5.5,-1.6 -2,-1.3 -1.7,-2.5 -2.9,-4.2 l -0.2,-3.5 h 3.3 c 0,3.5 1.8,6.1 5.3,6.2 v -10.6 c -1.3,-0.1 -4.1,-1.3 -5.1,-2 -1,-0.6 -3,-3 -3,-4.2 v -2.6 c 0,-3.5 4.2,-7 8.1,-7 v -2.4 h 2 v 2.4 c 4.4,1 8.1,2.3 8.1,7.7 h -3.5 v -0.9 c 0,-1.9 -2.5,-3.5 -4.6,-3.5 v 9.5 l 0,0 z m -25.3,5.8 c 0,4.3 0.6,9.8 2.4,12.3 1.1,1.6 5.1,7.7 7,7.7 h 0.7 c 2.3,0 3.9,-1.3 5.5,-1.3 1.9,0 5.5,1.7 7.5,1.7 2.5,0 7.4,-2.3 9.2,-2 l 9.1,1.5 c 1,0 6.2,-6.4 6.2,-8.8 2,-2.9 1,-5.3 0.7,-8.6 -0.2,-2.2 -1.3,-6.9 -1.3,-9 l -0.5,-0.6 c 0.1,-1.6 -0.8,-2.7 -0.8,-3.1 v -0.7 h -0.4 v -0.7 c 0,-0.7 -2.2,-5.2 -2.7,-5.9 -1.1,-1.9 -2.1,-3.2 -3.4,-5 -1.6,-2.2 -7,-6.5 -10.4,-6.5 h -4.4 c -8,0 -13,4.4 -16.5,8.9 -1.6,2.1 -4,5.3 -4.7,8 -0.5,2 -3.1,7.2 -3.1,9.4 v 2.4 z m 40,-44 -7.4,1.5 v -2.6 l -5.8,2.6 -3.2,-2.4 -0.3,3.5 -8.9,-3.4 v 2.9 l -1.7,-0.5 6.3,11.5 c 0.5,-0.2 5,-1.4 5.8,-1.3 l 6.1,1.1 9.3,-13 0,0 z"}],i["GR.IN.IC.BULLION STORAGE"]=[{type:"path",stroke:!1,d:"m 123.1,77.9 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -1e-5,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -1e-5,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -10e-6,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,10e-7 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -1e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -1e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,0 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -10e-7,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -3e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,0 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,10e-7 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -1e-5,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -2e-6,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.5e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 M 103.6,119.3 h 9.6 c 0.4,0 9,9.2 9.6,10.1 H 95.6 c 0.2,-1 7.4,-10.1 8,-10.1 z m -29.2,0 h 9.9 c 0.6,0 8.2,9 8.9,10.1 H 65.9 c 0.3,-1 7.8,-10.1 8.4,-10.1 l 0,0 z m 11.5,0 h 15.4 l -6.9,9.9 -8.5,-9.9 z m -5.5,-1 c 0.7,-1.1 7.6,-9.4 8.4,-9.4 h 9.2 c 0.7,0 8.9,8.5 9.2,9.4 H 80.4 z m 43.7,10.8 -9.5,-10.4 10.4,-14.3 9.7,8.5 -10.7,16.1 0,0 z m -4.8,-24.8 4.8,-0 -10.5,14.1 -4.1,-0.1 9.8,-13.9 z m -31.1,-0.2 2.8,0.1 c -1.1,1.6 -4.6,4.9 -6.2,6.8 -1.7,2.1 -4.2,5.1 -5.6,7.2 l -4.2,-0.1 13.2,-14.1 z m 21.1,-8.6 c 0.9,0.6 9,8.2 9,8.5 0,0.1 -9.3,13.6 -9.9,14 l -8.9,-9.9 9.8,-12.6 z M 89.1,108 c 0.9,-1.3 11.4,-12.6 12.1,-12.6 h 6.8 l -9.5,12.5 -9.4,0 z m 2.9,-4.6 h -4.6 c -1.2,1.8 -4.3,4.9 -6,6.6 -2.1,2.1 -3.9,4.4 -6,6.5 -1.3,1.3 -11.2,12.8 -11.4,13.7 0.5,0.1 0.5,0.2 1.2,0.2 l 59.3,-0 11.6,-17.5 -0.3,0.1 -10.5,-9.6 h -5.8 c -1.5,-1 -9.6,-8.9 -10.4,-8.9 h -8.2 c -0.9,0 -7.6,8 -9,8.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 103.6,119.3 c -0.5,0 -7.7,9.2 -8,10.1 h 27.3 c -0.6,-1 -9.2,-10.1 -9.6,-10.1 h -9.6 z m -29.2,0 c -0.6,0 -8.2,9.1 -8.4,10.1 h 27.3 c -0.7,-1.1 -8.3,-10.1 -8.9,-10.1 H 74.3 l 0,0 z m 50.7,-14.7 -10.4,14.3 9.5,10.4 10.7,-16.1 z m -30.7,24.7 6.9,-9.9 -15.4,0 z m 5.1,-21.1 8.9,9.9 c 0.6,-0.4 9.9,-13.9 9.9,-14 0,-0.3 -8.1,-7.9 -9,-8.5 l -9.9,12.6 z m -19.1,10.2 h 26.8 c -0.2,-0.9 -8.5,-9.4 -9.2,-9.4 h -9.2 c -0.9,0 -7.7,8.3 -8.4,9.4 z m 33.2,0.1 10.5,-14.1 -4.8,0 -9.8,13.9 z m -38.6,-0.2 4.2,0.1 c 1.4,-2.1 3.9,-5.1 5.6,-7.2 1.6,-1.9 5.1,-5.2 6.2,-6.8 l -2.8,-0.1 -13.2,14.1 z m 14.1,-10.3 9.4,-0 9.5,-12.5 h -6.7 c -0.7,0 -11.2,11.2 -12.1,12.6 z"}],i["GR.IN.IC.FEDERAL RESERVE BANK"]=[{type:"path",stroke:!1,d:"m 65.6,125.4 h 68.8 v 4.4 H 65.6 v -4.4 z m 58.1,-31.3 h 5.3 v 29.9 h -5.3 v -29.9 z m -10.6,0 h 5.1 v 29.9 h -5.1 v -29.9 z m -31.3,0 h 5.3 v 29.9 H 81.8 v -29.9 z m -10.6,0 h 5.1 v 29.9 h -5.1 v -29.9 z m 27.7,1.5 h 2 v 1.4 h 0.5 c 2.9,0 6,2.3 6,5.3 l -2.9,0.4 c -0.2,-0 -1,-1.9 -1.4,-2.4 -0.4,-0.5 -1.5,-1.1 -2.3,-1.2 v 7.8 c 3,0.3 7.3,2.3 7.3,5.3 v 1.1 c 0,4 -3.4,6.7 -7.3,6.7 v 2.5 h -2 v -2.5 c -1.7,-0 -4.1,-0.8 -5.1,-1.7 -0.8,-0.7 -2.4,-2.8 -2.4,-4.1 v -0.9 l 3.1,-0.5 c 0,2.3 2,4.9 4.4,4.9 v -8.6 c -2.3,-0 -6.9,-2.5 -6.9,-5.1 v -1.8 c 0,-3 3.2,-5.3 6.2,-5.3 h 0.7 v -1.4 z m -33.3,-7.5 h 68.8 v 4.6 H 65.6 v -4.6 z M 100,70.3 c 0.7,0.6 6.5,3.4 7.9,4.1 2.7,1.4 5.2,2.7 7.9,4.1 2.7,1.3 5.3,2.7 7.9,4.1 1.1,0.6 7.7,3.6 8.1,4 H 68.5 l 31.5,-16.1 0,0 z m -35.9,17.1 v 6 c 0,0.4 0.3,0.7 0.7,0.7 h 4.9 v 29.9 h -5.6 v 7.4 h 71.7 v -7.4 h -5.5 v -29.9 h 4.9 c 0.4,0 0.5,-0.1 0.5,-0.5 v -6.7 c -2,-0.7 -6.7,-3.4 -8.9,-4.6 -3,-1.5 -5.9,-3 -8.9,-4.6 -1.7,-0.8 -17.8,-9.1 -17.9,-9.1 -0.4,0 -16.3,8.2 -18.1,9.2 -1.9,1 -17.8,8.7 -17.8,9.6 l 0,0 0,0 z m 36.7,30.4 c 1.7,0 4,-2 4,-3.5 v -1.4 c 0,-2.1 -2.3,-2.7 -4,-3.1 v 8 z m -5.6,-14 c 0,1.6 2.2,2.6 3.6,2.7 v -7.4 c -1.3,0.3 -3.6,1.4 -3.6,2.7 v 2 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 134.4,129.8 0,-4.4 -68.8,0 0,4.4 z m -5.5,-5.8 0,-29.9 -5.3,0 0,29.9 z m -10.8,0 0,-29.9 -5.1,0 0,29.9 z m -31.1,0 0,-29.9 -5.3,0 0,29.9 z m -10.7,0 0,-29.9 -5.1,0 0,29.9 z m -7.9,-37.5 63.3,0 c -0.4,-0.3 -6.9,-3.4 -8.1,-4 -2.7,-1.3 -5.2,-2.7 -7.9,-4.1 -2.7,-1.3 -5.2,-2.7 -7.9,-4.1 -1.4,-0.7 -7.2,-3.5 -7.9,-4.1 l -31.5,16.1 0,0 z m 65.9,6.2 0,-4.6 -68.8,0 0,4.6 z m -33.5,25.1 v -8 c 1.7,0.4 4,1 4,3.1 v 1.5 c 0,1.4 -2.2,3.5 -4,3.5 z m -5.6,-14 v -2 c 0,-1.3 2.4,-2.4 3.6,-2.7 v 7.4 c -1.5,-0.1 -3.6,-1.1 -3.6,-2.7 z m 3.6,-6.7 h -0.8 c -3,0 -6.2,2.3 -6.2,5.3 v 1.8 c 0,2.5 4.6,5.1 6.9,5.1 v 8.6 c -2.4,0 -4.4,-2.5 -4.4,-4.9 l -3.1,0.5 v 0.9 c 0,1.3 1.6,3.5 2.4,4.1 1,0.8 3.3,1.6 5.1,1.7 v 2.5 h 2 v -2.5 c 3.9,0 7.3,-2.7 7.3,-6.7 v -1.1 c 0,-3 -4.3,-5 -7.3,-5.3 v -7.8 c 0.8,0.1 1.9,0.6 2.3,1.2 0.3,0.5 1.1,2.3 1.4,2.4 l 2.9,-0.4 c 0,-3 -3.1,-5.3 -6,-5.3 h -0.6 v -1.4 h -2 v 1.4 z"}],i["GR.IN.IC.FINANCIAL EXCHANGE"]=[{type:"path",stroke:!1,d:"m 133.7,124.6 0,-1.4 -66.8,0 0.3,0 0,-47 -1,0 0,48.4 z m -29.5,-8.6 -9.8,-20.8 -5.9,14.4 -5.3,-6.5 -13.3,12.4 0.9,1 v 0.2 l 12.4,-11.3 5.5,7 h 0.3 c 0,-1 2.3,-5.6 2.8,-7 0.3,-1 1.1,-2.4 1.5,-3.4 0.3,-0.8 0.9,-3.1 1.5,-3.2 l 9.4,20.3 0.1,0.2 17.4,-27.4 0.2,0.1 8,15.6 1.4,-0.5 -9.4,-18 c -0.1,0.5 -7.7,12.1 -8.7,13.6 -1,1.6 -8.2,13.2 -8.9,13.4 z m 2.8,-19.4 V 89.2 c 2.1,0 4.1,1.4 4.1,3.6 v 0.2 c 0,2.1 -1.9,3.6 -4.1,3.6 z m -4.7,-13.6 c 0,-2 1,-3.4 3,-3.4 h 0.5 v 6.6 c -1.8,-0.1 -3.4,-1.3 -3.4,-3.2 z m 3.5,-5.6 h -1 c -2.6,0 -5.2,2.9 -5.2,5.6 v 1 c 0,1.1 1.3,2.8 2.1,3.4 1.1,0.8 2.5,1.2 4,1.5 v 7.8 c -2.6,-0.6 -4.1,-1.7 -4.1,-4.8 h -2.4 l 0.2,2.5 c 0.9,1.4 0.6,2.1 2.2,3.2 1.1,0.7 2.4,1.2 4.1,1.2 v 2.8 h 1.2 v -2.8 c 3,0 6.4,-2.3 6.4,-5 v -2.5 c 0,-2.9 -4,-4.3 -6.4,-4.8 v -6.9 c 2,0 3.4,1.4 3.4,3.3 h 2.7 c 0,-3.2 -2.8,-5.5 -6.1,-5.5 V 75.4 h -1.2 v 1.9 z"}],i["GR.IN.IC.FINANCIAL SERVICES, OTHER"]=[{type:"path",stroke:!1,d:"m 103.4,138.2 -2.7,0 -0,-8.2 c -1.9,-0 -3.8,-0.3 -5.7,-0.7 -1.9,-0.4 -3.8,-1 -5.8,-1.9 l 0,-4.9 c 1.9,1.2 3.7,2.1 5.6,2.7 1.9,0.6 3.9,0.9 5.9,0.9 l 0,-12.5 c -4,-0.7 -7,-1.8 -8.8,-3.3 -1.8,-1.6 -2.7,-3.7 -2.7,-6.5 -5e-6,-3 1,-5.3 3,-7 2,-1.7 4.8,-2.7 8.6,-3 l 0,-6.4 2.7,0 0,6.3 c 1.7,0.1 3.3,0.3 4.9,0.5 1.6,0.3 3.1,0.7 4.6,1.1 l 0,4.8 c -1.5,-0.8 -3.1,-1.4 -4.7,-1.8 -1.6,-0.4 -3.2,-0.7 -4.9,-0.7 l 0,11.7 c 4.1,0.6 7.2,1.8 9.1,3.4 2,1.6 2.9,3.9 2.9,6.7 -3e-5,3.1 -1,5.5 -3.1,7.3 -2.1,1.8 -5,2.8 -8.9,3.1 l 0,8.3 m -2.7,-29.3 0,-11.2 c -2.1,0.2 -3.7,0.8 -4.8,1.8 -1.1,1 -1.7,2.3 -1.7,3.9 -1e-5,1.6 0.5,2.8 1.5,3.7 1,0.9 2.7,1.5 5,1.9 m 2.7,5.3 0,11.8 c 2.3,-0.3 4.1,-1 5.2,-2 1.2,-1 1.8,-2.3 1.8,-4 -3e-5,-1.6 -0.6,-2.9 -1.7,-3.8 -1.1,-0.9 -2.9,-1.6 -5.3,-2.1 m 5.8,-52.2 2.1,0 0,6.2 7.5,0 0,-6.2 2.1,0 0,15.2 -2.1,0 0,-7.2 -7.5,0 0,7.2 -2.1,0 0,-15.2 m -14.8,0 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -8.1,1.4 c -1.5,1.3e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -3e-6,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -1.3e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -1.5e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,-10e-7 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -1e-6,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1"}],i["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 101.9,123.3 -1.7,0 -0,-5 c -1.2,-0 -2.3,-0.2 -3.5,-0.4 -1.2,-0.3 -2.3,-0.6 -3.5,-1.1 l 0,-3 c 1.1,0.7 2.3,1.2 3.4,1.6 1.2,0.4 2.4,0.5 3.6,0.5 l 0,-7.6 c -2.4,-0.4 -4.2,-1.1 -5.3,-2 -1.1,-1 -1.7,-2.3 -1.7,-3.9 -2e-6,-1.8 0.6,-3.2 1.8,-4.3 1.2,-1 2.9,-1.6 5.2,-1.8 l 0,-3.9 1.7,0 0,3.9 c 1,0 2,0.2 3,0.3 1,0.2 1.9,0.4 2.8,0.7 l 0,2.9 c -0.9,-0.5 -1.9,-0.8 -2.8,-1.1 -1,-0.3 -2,-0.4 -3,-0.4 l 0,7.1 c 2.5,0.4 4.4,1.1 5.5,2.1 1.2,1 1.8,2.4 1.8,4.1 -2e-5,1.9 -0.6,3.3 -1.9,4.4 -1.3,1.1 -3.1,1.7 -5.4,1.9 l 0,5 m -1.7,-17.8 0,-6.8 c -1.3,0.1 -2.3,0.5 -2.9,1.1 -0.7,0.6 -1,1.4 -1,2.3 -6e-6,1 0.3,1.7 0.9,2.2 0.6,0.5 1.6,0.9 3,1.1 m 1.7,3.2 0,7.2 c 1.4,-0.2 2.5,-0.6 3.2,-1.2 0.7,-0.6 1.1,-1.4 1.1,-2.4 -1e-5,-1 -0.3,-1.7 -1,-2.3 -0.7,-0.6 -1.7,-1 -3.2,-1.3 M 104.5,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 70 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 V 86.9 H 68.8 v 39.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 101.9,108.7 0,7.2 c 1.4,-0.2 2.5,-0.6 3.2,-1.2 0.7,-0.6 1.1,-1.4 1.1,-2.4 -1e-5,-1 -0.3,-1.7 -1,-2.3 -0.7,-0.6 -1.7,-1 -3.2,-1.3 m -1.7,-3.2 0,-6.8 c -1.3,0.1 -2.3,0.5 -2.9,1.1 -0.7,0.6 -1,1.4 -1,2.3 -6e-6,1 0.3,1.7 0.9,2.2 0.6,0.5 1.6,0.9 3,1.1 m 4.3,-30.7 0,13.4 -34.6,0 0,37 60.1,0 0,-37 -6.7,0 0,-13.4 -4.5,0 0,13.4 -9.9,0 0,-13.4 -4.5,0 z m -4.3,17.6 1.7,0 0,3.8 c 1,0 2,0.2 3,0.3 1,0.2 1.9,0.4 2.8,0.7 l 0,2.9 c -0.9,-0.5 -1.9,-0.8 -2.8,-1.1 -1,-0.3 -2,-0.4 -3,-0.5 l 0,7.1 c 2.5,0.4 4.3,1.1 5.5,2.1 1.2,1 1.8,2.4 1.8,4.1 -2e-5,1.9 -0.6,3.4 -1.9,4.4 -1.3,1.1 -3.1,1.7 -5.4,1.9 l 0,5 -1.7,0 -0,-5 c -1.2,-0 -2.3,-0.2 -3.5,-0.4 -1.2,-0.3 -2.3,-0.6 -3.5,-1.1 l 0,-3 c 1.1,0.7 2.3,1.3 3.4,1.6 1.2,0.4 2.4,0.5 3.6,0.5 l 0,-7.6 c -2.4,-0.4 -4.2,-1.1 -5.3,-2 -1.1,-1 -1.7,-2.2 -1.7,-3.9 -2e-6,-1.8 0.6,-3.2 1.8,-4.3 1.2,-1 3,-1.6 5.2,-1.8 l 0,-3.9 z"}],i["GR.IN.IC.CHEMICAL PLANT"]=[{type:"path",stroke:!1,d:"m 94.4,89.6 0,0.1 c -0.5,0.1 -1,0.3 -1.4,0.6 -0.5,0.5 -0.6,1.3 -0.5,1.9 0.2,0.8 0.8,1.5 1.7,1.8 -0,0.5 -0.1,1.7 0,3 l -0.1,0 c -0,2.7 -2.3,5.7 -4.9,8.8 -2.4,3 -5,6.4 -5.3,10.4 l -0.1,0 c 0,0.1 0,0.2 0,0.2 -0,0.1 -0,0.2 -0,0.3 l 0.1,0 c 0.2,2.4 1.7,4.2 3.7,5.3 2.1,1.2 4.6,1.7 6.8,1.6 l 0,-0 8.9,0 0,0.1 c 0.3,-0 0.5,-0 0.8,-0.1 l 0.5,0 0,-0.1 c 2.1,-0.2 4.2,-0.3 6,-1 1.1,-0.4 2.1,-1.1 2.8,-2.1 0.6,-0.9 0.9,-2.1 1.1,-3.6 l 0.2,0 c 0.2,-4.4 -2.1,-7.5 -4.5,-10.3 -2.3,-2.8 -4.7,-5.5 -5.4,-9.6 0,-1.3 0.1,-3 0.1,-3.3 0.2,-0.1 0.4,-0.2 0.6,-0.3 0.5,-0.4 0.9,-1 0.9,-1.7 -0,-0.7 -0.5,-1.3 -1.1,-1.6 -0.4,-0.2 -0.9,-0.3 -1.5,-0.4 l 0,-0.1 c -0.2,0 -0.4,-0 -0.6,0 -2.5,0 -7.2,0 -8.1,0 -0.1,-2.4e-4 -0.7,0 -0.7,0 z m 0.7,2 c 0.8,0 5.5,0 8.1,0 0.6,0 0.9,0.1 1.1,0.2 -0.2,0.1 -0.5,0.3 -0.9,0.4 l -8.1,0 c -0.4,-0.1 -0.7,-0.3 -0.7,-0.4 -0,-0.1 -0,-0.1 -0,-0.1 0,-0 0.1,-0.1 0.6,-0.1 z m 1.2,2.6 6.7,0 c -0,0.7 -0.1,1.9 -0.1,3.1 -0,0.1 -0,0.2 -0,0.3 l 0.1,0 c 0.9,4.5 3.5,7.6 5.8,10.3 2.2,2.7 4,5 4,8.4 l -0.1,0 c -0,1.4 -0.4,2.4 -0.8,3 -0.4,0.7 -1,1.1 -1.8,1.4 -1.4,0.6 -3.6,0.7 -5.8,0.9 l -10.3,0 0,0 c -1.6,0 -3.6,-0.4 -5.1,-1.3 -1.6,-0.9 -2.6,-2.2 -2.7,-3.9 0.1,-3.2 2.4,-6.3 4.9,-9.4 2.4,-3 5.1,-6.1 5.3,-9.6 l 0.1,-0 c -0.1,-1 -0.1,-2.7 -0,-3.3 z m -7,19.6 v 1.9 c 0,3.5 6,4.3 9.9,4.3 h 3.2 c 2.5,0 8,-2.2 8,-4.2 v -0.8 c 0,-3.2 -6.6,-9.4 -7.3,-12.4 h -7.5 c -0.6,2.5 -6.2,10 -6.2,11.2 z m 14.8,-39 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 v 13.4 h -34.4 v 39.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 104.1 74.8 L 104.1 88.2 L 69.6 88.2 L 69.6 125.2 L 129.6 125.2 L 129.6 88.2 L 122.9 88.2 L 122.9 74.8 L 118.5 74.8 L 118.5 88.2 L 108.6 88.2 L 108.6 74.8 L 104.1 74.8 z M 94.4 89.6 C 94.4 89.6 95.1 89.6 95.2 89.6 C 96.1 89.6 100.8 89.6 103.3 89.6 C 103.5 89.6 103.8 89.6 103.9 89.6 L 103.9 89.7 C 104.5 89.8 105 89.9 105.4 90.1 C 106 90.4 106.5 91 106.5 91.7 C 106.5 92.4 106.1 93 105.6 93.4 C 105.4 93.5 105.2 93.6 105 93.8 C 105 94 104.9 95.7 104.9 97.1 C 105.6 101.1 108 103.8 110.3 106.7 C 112.6 109.5 114.9 112.6 114.7 117 L 114.6 116.9 C 114.4 118.4 114.1 119.6 113.5 120.5 C 112.8 121.5 111.8 122.2 110.8 122.7 C 108.9 123.4 106.8 123.5 104.8 123.7 L 104.8 123.7 L 104.3 123.7 C 104.1 123.7 103.8 123.8 103.5 123.8 L 103.5 123.7 L 94.6 123.7 L 94.6 123.8 C 92.4 123.9 89.9 123.4 87.8 122.2 C 85.9 121.1 84.3 119.2 84.1 116.8 L 84.1 116.8 C 84.1 116.7 84.1 116.6 84.1 116.5 C 84.1 116.4 84 116.4 84 116.3 L 84.1 116.3 C 84.3 112.3 86.9 109 89.4 105.9 C 91.9 102.7 94.2 99.8 94.3 97.1 L 94.3 97.1 C 94.2 95.7 94.3 94.6 94.3 94 C 93.5 93.7 92.8 93.1 92.6 92.3 C 92.4 91.6 92.6 90.9 93.1 90.4 C 93.4 90 93.9 89.8 94.4 89.7 L 94.4 89.6 z M 95.1 91.6 C 94.7 91.6 94.5 91.7 94.5 91.8 C 94.5 91.8 94.5 91.7 94.6 91.8 C 94.6 91.9 94.8 92.2 95.3 92.2 L 103.4 92.2 C 103.8 92.1 104.1 92 104.3 91.8 C 104.1 91.8 103.8 91.6 103.2 91.6 C 100.6 91.6 95.9 91.6 95.1 91.6 z M 96.3 94.2 C 96.2 94.9 96.2 96.5 96.3 97.5 L 96.2 97.6 C 96 101.1 93.4 104.2 90.9 107.2 C 88.5 110.3 86.2 113.3 86.1 116.6 C 86.2 118.3 87.2 119.5 88.8 120.5 C 90.3 121.3 92.3 121.8 93.9 121.8 L 93.9 121.7 L 104.2 121.7 C 106.5 121.5 108.6 121.4 110 120.8 C 110.8 120.5 111.4 120.1 111.8 119.4 C 112.3 118.8 112.6 117.8 112.7 116.4 L 112.7 116.4 C 112.7 113 110.9 110.6 108.7 107.9 C 106.5 105.2 103.8 102.1 103 97.6 L 102.8 97.6 C 102.8 97.5 102.9 97.4 102.9 97.3 C 102.9 96.1 102.9 94.9 103 94.2 L 96.3 94.2 z M 95.5 102.6 L 103 102.6 C 103.8 105.7 110.3 111.9 110.3 115.1 L 110.3 115.9 C 110.3 117.9 104.9 120 102.4 120 L 99.2 120 C 95.3 120 89.3 119.2 89.3 115.7 L 89.3 113.8 C 89.3 112.6 94.9 105.1 95.5 102.6 z "}],i["GR.IN.IC.FIREARMS MANUFACTURER"]=[{type:"path",stroke:!1,d:"m 104.1,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 v 13.4 h -34.4 v 39.5 z m 25.8,-26.6 h 10.8 v 5.8 c -1.6,0 -4.7,1 -5.8,0.7 -1.2,-0.4 -3.8,-1.5 -5,-1.6 v -4.8 z m -19.2,0 h 16.6 v 6 c 0,0.6 3,1.4 3.7,1.7 0.4,0.1 3.9,1.4 3.9,1.5 l 7.2,-0.9 0.8,2.7 1.1,3.7 c 0.3,0.4 1,2.4 1,3.1 v 0.2 c 0,1.1 -0.6,1.9 -0.6,3.5 l 13.5,-0 -0.9,-3 -0.6,-1.7 -3,-10 c -0.2,-0.4 -0.5,-0.7 -0.5,-1.3 0,-1.3 3.9,-4.1 4.7,-5.3 l -2.7,-8.4 h -43.9 v 8.4 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 94.2,99.9 h 10.8 v 5.8 c -1.6,0 -4.7,1 -5.8,0.7 -1.2,-0.4 -3.8,-1.5 -5,-1.6 v -4.8 z m 9.9,-25.1 0,13.4 -34.6,0 0,37 60.1,0 0,-37 -6.7,0 0,-13.4 -4.5,0 0,13.4 -9.9,0 0,-13.4 -4.5,0 z m -29.1,16.7 43.9,0 2.7,8.4 c -0.8,1.2 -4.7,4.1 -4.7,5.3 0,0.6 0.2,0.9 0.5,1.3 l 3.1,10 0.6,1.8 0.9,3 -13.5,0 c 0,-1.6 0.7,-2.4 0.7,-3.6 l 0,-0.2 c 0,-0.7 -0.7,-2.7 -1,-3.1 L 107.2,110.8 106.4,108.1 99.2,109 c -0,-0.1 -3.6,-1.4 -3.9,-1.5 -0.7,-0.3 -3.7,-1.1 -3.7,-1.7 l 0,-5.9 -16.6,0 0,-8.4 z"}],i["GR.IN.IC.FIREARMS RETAILER"]=[{type:"path",stroke:!1,d:"m 85.1,123 -1.1,0 -0,-3.2 c -0.8,-0 -1.5,-0.1 -2.3,-0.3 -0.8,-0.2 -1.5,-0.4 -2.3,-0.7 l 0,-1.9 c 0.7,0.5 1.5,0.8 2.2,1 0.8,0.2 1.5,0.3 2.3,0.4 l 0,-4.9 c -1.6,-0.3 -2.7,-0.7 -3.5,-1.3 -0.7,-0.6 -1.1,-1.5 -1.1,-2.5 -2e-6,-1.2 0.4,-2.1 1.2,-2.8 0.8,-0.7 1.9,-1.1 3.4,-1.2 l 0,-2.5 1.1,0 0,2.5 c 0.7,0 1.3,0.1 1.9,0.2 0.6,0.1 1.2,0.3 1.8,0.5 l 0,1.9 c -0.6,-0.3 -1.2,-0.5 -1.8,-0.7 -0.6,-0.2 -1.3,-0.3 -1.9,-0.3 l 0,4.6 c 1.6,0.3 2.8,0.7 3.6,1.3 0.8,0.6 1.1,1.5 1.1,2.6 -1.2e-5,1.2 -0.4,2.2 -1.2,2.9 -0.8,0.7 -2,1.1 -3.5,1.2 l 0,3.3 m -1.1,-11.5 0,-4.4 c -0.8,0.1 -1.5,0.3 -1.9,0.7 -0.4,0.4 -0.7,0.9 -0.7,1.5 -4e-6,0.6 0.2,1.1 0.6,1.4 0.4,0.3 1.1,0.6 2,0.7 m 1.1,2.1 0,4.7 c 0.9,-0.1 1.6,-0.4 2.1,-0.8 0.5,-0.4 0.7,-0.9 0.7,-1.6 -1e-5,-0.6 -0.2,-1.1 -0.7,-1.5 -0.4,-0.4 -1.1,-0.6 -2.1,-0.8 m 22.6,-21.9 -8,20.8 0.8,0.3 8,-20.8 -0.8,-0.3 z m -43,6.5 0,0.8 0.3,26 0,0.8 0.8,0 32.2,-0.2 0.4,0 0.2,-0.3 7.3,-8.7 0.2,-0.2 -0,-0.3 -0.2,-10.1 0,-0.4 -0.3,-0.2 -8.4,-6.6 -0.2,-0.2 -0.3,0 -31.3,-0.4 -0.8,0 z m 1.6,1.6 30.2,0.3 7.9,6.2 0.2,9.4 -6.9,8.2 -31,0.2 -0.3,-24.3 z M 97.3,85.4 h 14.4 v 7.7 c -2.1,0 -6.2,1.4 -7.8,0.9 -1.6,-0.5 -5,-2.1 -6.6,-2.2 v -6.4 z m -25.5,0 h 22.1 v 7.9 c 0,0.8 4,1.9 4.8,2.2 0.5,0.2 5.2,1.9 5.2,2 l 9.6,-1.2 1,3.6 1.4,4.9 c 0.3,0.5 1.3,3.2 1.3,4.1 v 0.2 c 0,1.5 -0.9,2.5 -0.9,4.7 h 18 l -1.1,-3.9 -0.8,-2.4 -4,-13.4 c -0.3,-0.5 -0.6,-0.9 -0.6,-1.7 0,-1.7 5.2,-5.5 6.2,-7.1 l -3.6,-11.1 H 71.8 v 11.1 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 85.1,113.6 0,4.7 c 0.9,-0.1 1.6,-0.4 2.1,-0.8 0.5,-0.4 0.7,-0.9 0.7,-1.6 -1e-5,-0.6 -0.2,-1.1 -0.7,-1.5 -0.4,-0.4 -1.1,-0.6 -2.1,-0.8 m -1.1,-2.1 0,-4.4 c -0.8,0.1 -1.5,0.3 -1.9,0.7 -0.4,0.4 -0.7,0.9 -0.7,1.5 -4e-6,0.6 0.2,1.1 0.6,1.4 0.4,0.3 1.1,0.6 2,0.7 M 66.4,99.8 l 0.3,24.3 31,-0.2 6.9,-8.2 -0.2,-9.4 -7.9,-6.2 -30.2,-0.3 z m 17.7,3.3 1.1,0 0,2.5 c 0.7,0 1.3,0.1 1.9,0.2 0.6,0.1 1.2,0.2 1.8,0.4 l 0,1.9 c -0.6,-0.3 -1.2,-0.5 -1.8,-0.7 -0.6,-0.2 -1.3,-0.3 -1.9,-0.3 l 0,4.6 c 1.6,0.3 2.8,0.7 3.6,1.3 0.8,0.6 1.2,1.5 1.2,2.7 -1.2e-5,1.2 -0.4,2.2 -1.2,2.9 -0.8,0.7 -2,1.1 -3.5,1.2 l 0,3.3 -1.1,0 0,-3.2 c -0.8,-0 -1.5,-0.1 -2.3,-0.3 -0.8,-0.2 -1.5,-0.4 -2.3,-0.8 l 0,-1.9 c 0.7,0.5 1.5,0.8 2.2,1.1 0.8,0.2 1.5,0.3 2.3,0.3 l 0,-4.9 c -1.6,-0.3 -2.7,-0.7 -3.5,-1.3 -0.7,-0.6 -1.1,-1.5 -1.1,-2.5 -2e-6,-1.2 0.4,-2.1 1.2,-2.8 0.8,-0.7 1.9,-1.1 3.4,-1.2 l 0,-2.5 z"}],i["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]=[{type:"path",stroke:!1,d:"m 104.7,71.8 h 5 v 15 h 11.1 v -15 h 5 v 15 h 7.5 v 41.4 h -67.4 V 86.8 h 38.8 v -15 z m -40,57.9 h 69.8 V 85.5 h -7.1 v -15.2 h -8 v 15.2 h -8 v -15.2 h -8 v 15.2 h -38.6 v 44.1 l 0,0 z m 15.5,-21.8 h 38.6 l -19.3,18.6 -19.3,-18.6 z m 21.8,-16.8 c 0.5,0.4 4.3,3.8 4.3,4.3 v 12 h -4.3 V 91.1 z m -5,-0 0,16.3 h -4.3 l 0.1,-12.2 4.1,-4.1 0,0 z m -12.1,12 c 0,-0.4 3.1,-3.2 3.6,-3.6 v 7.8 h -3.6 v -4.3 z m 25.7,-3.6 3.7,3.4 c -0.2,0.4 -0.2,-0.2 -0.2,0.5 v 4 h -3.6 v -7.9 z m 9.4,8.2 -20.5,-20 -20.4,20 20.4,19.9 20.5,-19.9 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 99.5,126.5 19.3,-18.6 -38.6,0 z m 0,1 -20.4,-19.9 20.4,-20 20.5,20 -20.5,19.8 z m 5.2,-40.8 h -38.8 v 41.4 h 67.4 V 86.8 h -7.5 v -15 h -5 v 15 h -11.1 v -15 h -5 v 15 z m 5.9,20.6 h 3.6 v -4 c 0,-0.7 -0,-0.1 0.2,-0.5 l -3.7,-3.4 v 7.9 z m -8.6,0 h 4.3 v -12 c 0,-0.4 -3.8,-3.9 -4.3,-4.3 v 16.3 z m -9.3,0 4.3,0 -0,-16.3 -4.1,4.1 z m -7.8,-4.3 v 4.3 h 3.6 v -7.9 c -0.5,0.3 -3.6,3.2 -3.6,3.6 z"}],i["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]=[{type:"path",stroke:!1,d:"m 122.4,68.8 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -10e-6,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -10e-6,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -1e-5,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -10e-6,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -10e-6,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,-10e-7 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -2e-6,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -3e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,-10e-7 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,1e-6 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -1e-5,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -2e-6,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.5e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 M 70.6,110 h 57.9 l -29,27.9 -28.9,-27.9 z m 32.8,-25.2 c 0.8,0.5 6.4,5.8 6.4,6.4 v 17.9 h -6.4 V 84.8 z m -7.6,-0.1 0.1,24.4 h -6.5 l 0.2,-18.3 6.2,-6.1 0,0 z m -18.2,18 c 0,-0.7 4.7,-4.9 5.3,-5.3 v 11.8 h -5.3 v -6.5 z m 38.6,-5.3 5.6,5.2 c -0.3,0.7 -0.2,-0.3 -0.2,0.7 v 5.9 h -5.3 V 97.4 z m 14.2,12.3 -30.7,-30.1 -30.7,30 30.7,29.9 30.8,-29.8 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 99.5,137.9 29,-27.9 -57.9,0 z m 16.7,-28.7 h 5.3 v -5.9 c 0,-1 -0.1,-0.1 0.2,-0.7 l -5.6,-5.2 v 11.8 z m -12.8,0 h 6.4 V 91.2 c 0,-0.7 -5.6,-5.9 -6.4,-6.4 v 24.4 z m -14,-10e-6 6.5,0 -0.1,-24.4 -6.2,6.1 z m -11.8,-6.4 v 6.4 h 5.3 V 97.4 c -0.7,0.5 -5.3,4.7 -5.3,5.3 z"}],i["GR.IN.IC.INDUSTRIAL SITE"]=[{type:"path",stroke:!1,d:"m 104.1,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 v 13.4 h -34.4 v 39.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 104.1,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z"}],i["GR.IN.IC.LANDFILL"]=[{type:"path",stroke:!1,d:"m 124.1,115.8 c 0,2.5 1.6,2.7 3,3.6 h -22.8 c 1.2,-0.7 2.8,-1.2 2.8,-3.3 v -1.2 c 0,-1.3 -1.9,-2.8 -3.6,-2.8 -1,0 -1.8,0.4 -2.3,0.9 -0.4,0.4 -1.1,1.6 -1.1,2.1 v 1.3 c 0,0.2 0.9,1.7 1,1.9 0.6,0.7 1.2,0.6 1.8,1 h -8.6 c 0.6,-0.4 1.3,-0.5 1.8,-1.1 0.4,-0.4 0.6,-1.4 1,-1.6 v -1.7 c 0,-0.4 -0.9,-1.8 -1.2,-2.1 -0.6,-0.6 -1.3,-0.9 -2.4,-0.9 h -0.1 c -1.7,0 -3.5,1.5 -3.5,3.1 v 1.3 c 0,1.5 2,2.2 2.8,2.8 h -8.7 c -0.1,-3.2 -2.5,-1.8 -3.1,-3 -1.1,-1.9 0.9,-2.2 -2.8,-3.1 -3.1,-0.8 -2,-0.3 -3.9,-2.2 -0.6,-0.7 -3,-1.8 -4.2,-1.8 h -0.1 c -1,0 -1.9,1.2 -2.7,1.5 -1.1,0.5 -2.3,0.4 -3.2,1.1 -1.1,0.8 -2.3,4.4 -2.3,6.2 v 0.6 h -0.4 v 2.2 h 72.1 4.9 v -1.5 h -9.5 c 0.8,-0.5 0.9,-0.2 1.8,-1 0.4,-0.4 0.9,-1.5 1.2,-1.6 v -1.6 c 0,-0.5 -0.9,-1.9 -1.3,-2.2 -0.7,-0.5 -1.4,-0.8 -2.5,-0.8 -1.9,0 -3.6,1.5 -3.6,3.5 v 0.2 h 0 z m -1,-17.6 h 3.5 c 0.5,0 4.2,4.8 4.6,5.4 h -8.1 v -5.4 z m -4.1,-17.8 -0.7,-1.3 -7,3.9 1.4,3.5 -32,14.5 c 0.8,0.4 2.1,4.3 2.6,5.3 0.2,0.4 2.3,5 2.3,5.1 0,0.5 -0.9,0.2 -0.8,0.6 l 0.5,3.1 h 3.4 c 0,-2.4 2,-4.8 4.3,-4.8 h 1 c 2.4,0 4.3,2.3 4.3,4.8 h 0.6 c 0,-2.4 0.6,-2.3 1.5,-3.6 l -2.1,-5.6 9.5,-4.3 4.2,9.9 -5.1,0 c 0.9,1.3 1.6,1.3 1.6,3.6 h 14.4 v -0.5 c 0,-2.1 2.5,-4.3 4.8,-4.3 h 0.5 c 2.6,0 4.6,2.2 4.6,4.8 h 2.6 v -3.1 h -1.2 v -7.4 c 0,-1.2 -5.8,-6.8 -6.1,-8.1 h -6.4 v 15 h -4.1 l -5.3,-12.1 5.5,-2.3 -4.3,-9.5 5.6,-7.4 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 123.1,103.6 h 8.1 c -0.5,-0.6 -4.2,-5.4 -4.6,-5.4 h -3.5 v 5.4 z"}],i["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]=[{type:"path",stroke:!1,d:"m 105.2,71.3 h 5.1 V 86.5 H 121.5 V 71.3 h 5.1 v 15.2 h 7.6 v 42.1 H 65.8 V 86.6 h 39.4 V 71.3 z M 64.5,130.1 h 71 V 85.3 h -7.3 V 69.9 h -8.2 V 85.3 h -8.2 V 69.9 H 103.7 V 85.3 H 64.5 v 44.8 z M 90.3,93.1 h 7.6 c 1.2,0 3.4,1.8 3.4,2.7 v 2.6 c 0,1.3 -2.4,2.9 -3.6,2.9 h -7.4 v -8.2 z m -4.9,26.5 h 4.9 v -13.1 l 1.7,0.1 7.6,10 -8.8,11 5.9,0.1 5.9,-7 c 1.2,0.3 4.2,5.9 5.6,6.9 h 6.2 c -0.9,-1.7 -8.4,-10.4 -8.4,-11 0,-0.3 7.4,-9.7 8.2,-10.4 l -6,-0.1 -5.6,6.2 -4.3,-5.7 c 5.2,-1.2 8.4,-3.3 8.4,-9.8 v -0.6 c 0,-2 -1.7,-4.7 -2.8,-5.8 -1,-1 -4.1,-2.4 -6.2,-2.4 H 85.4 v 31.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 85.4,88 h 12.4 c 2.1,0 5.1,1.4 6.1,2.4 1.1,1.1 2.8,3.8 2.8,5.8 v 0.6 c 0,6.5 -3.1,8.6 -8.4,9.8 l 4.3,5.7 5.6,-6.2 6.1,0.1 c -0.8,0.6 -8.2,10 -8.2,10.4 0,0.7 7.4,9.4 8.4,11.1 h -6.2 c -1.5,-1 -4.4,-6.6 -5.6,-6.9 l -5.9,6.9 -5.9,-0.1 8.8,-11 -7.6,-9.9 -1.8,-0.1 v 13.1 h -4.9 v -31.6 z m 19.8,-1.4 h -39.4 v 42.1 h 68.4 V 86.6 h -7.6 V 71.3 H 121.5 V 86.5 H 110.3 V 71.3 h -5.1 v 15.3 z m -14.9,14.7 h 7.4 c 1.2,0 3.6,-1.6 3.6,-2.9 v -2.5 c 0,-1 -2.2,-2.7 -3.4,-2.7 h -7.6 v 8.2 z"}],i["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]=[{type:"path",stroke:!1,d:"m 133.7,71.5 c -0.3,0 -0.7,0.1 -0.9,0.2 l -49.5,0 -0.7,0 0,0.1 c -0.7,0.3 -1.3,0.9 -1.8,1.7 -0.6,1 -1.2,2.5 -1.6,4.2 -0.9,3.5 -1.4,8.2 -1.4,13.4 0,4.8 0.5,9.2 1.2,12.6 -1,0.1 -2.1,0.5 -3,0.3 -1.2,-0.1 -2.5,-0.1 -3.8,-0.1 -1.3,0 -6.5,-0.9 -6.5,0.7 0,1.8 6,3.4 7.5,6.1 -0.8,1.5 -5.9,1.4 -8.1,1.8 -1.5,0.2 -3,0.2 -3.8,1.1 -1,1 0.2,2.3 1.1,2.7 1.7,0.9 6,1 8.2,1.5 1.3,0.3 2.6,0.7 3.1,1.9 0.4,1.1 0.6,2.6 2.2,2.6 l 0.1,0 c 2.1,0 5.1,-1.7 7.9,-1.7 l 1.1,0 c 6.2,0 6.8,7.4 12.3,7.7 3.5,0.2 5.3,-0.8 7.8,-1.9 1.6,-0.7 5.5,-2.8 7.3,-2.8 l 0.3,0 c 1.8,0 3.3,1.1 4.8,1.5 1.6,0.5 3.3,1 5.4,1 l 0.5,0 c 1.2,0 2.3,-0.2 3.2,-0.5 1.2,-0.4 1.1,-1 1.1,-2.4 -0.1,-1.9 -2.2,-3.3 -3.5,-4 -1.4,-0.9 -3.4,-1.8 -4.9,-2.6 -0.8,-0.4 -1.5,-0.9 -2.3,-1.4 -1.3,-1 -1,-0.6 -1.7,-2.1 1.2,-1.8 6.9,0.2 6.9,-1.9 0,-0.2 -0.3,-0.5 -0.7,-0.7 l 12.2,0 0.7,0 0,-0.4 c 0.7,-0.3 1.3,-0.9 1.8,-1.7 0.6,-1 1.2,-2.5 1.6,-4.2 0.9,-3.5 1.4,-8.2 1.4,-13.4 0,-5.2 -0.5,-9.9 -1.4,-13.4 -0.4,-1.7 -1,-3.2 -1.6,-4.2 -0.6,-1 -1.4,-1.8 -2.5,-1.8 z m 0.3,1.4 c 0.3,0 0.7,0.3 1.3,1.1 0.5,0.8 1,2.2 1.4,3.8 0.8,3.3 1.4,7.9 1.4,13.1 0,5.1 -0.5,9.8 -1.4,13.1 -0.4,1.7 -0.9,3 -1.4,3.8 -0.5,0.8 -1,1.1 -1.3,1.1 -0.2,0 -0.4,-0.1 -0.7,-0.4 l 0,0.7 -47.9,0 c 0.2,-0.2 0.4,-0.4 0.6,-0.8 0.6,-1 1.1,-2.3 1.5,-4 0.9,-3.4 1.4,-8.1 1.4,-13.2 0,-5.2 -0.5,-9.8 -1.4,-13.2 -0.4,-1.7 -0.9,-3.1 -1.5,-4 -0.2,-0.3 -0.4,-0.5 -0.6,-0.7 l 47.9,0 0,0.2 c 0.3,-0.3 0.5,-0.4 0.7,-0.4 z m -50.7,0.2 c 0.3,0 0.7,0.3 1.3,1.1 0.5,0.8 1,2.2 1.4,3.8 0.8,3.3 1.4,7.9 1.4,13.1 0,5.1 -0.5,9.8 -1.4,13.1 -0.4,1.7 -0.9,3 -1.4,3.8 -0.5,0.8 -1,1.1 -1.3,1.1 -0.3,0 -0.7,-0.3 -1.3,-1.1 -0.3,-0.5 -0.6,-1.1 -0.8,-1.8 0.4,1.7 1,3 1.7,3.5 l 8.3,-0.2 7.1,0.1 20.3,-0.1 c 0.5,0 1.5,0.5 2.3,1 l 0,0 c 0.5,0.3 0.8,0.6 1,0.7 -0.1,0.2 -0.4,0.3 -0.6,0.4 -0.2,0.1 -0.5,0.2 -0.8,0.2 -0.4,0.1 -0.9,0.1 -1.3,0.1 -0.2,-0 -0.5,-0 -0.7,-0 -0.4,-0 -0.9,-0 -1.2,-0 l -0.3,0 c -0.9,0 -1.7,0.5 -1.7,1.4 l 0,0.1 0,0.1 c 0,0.1 0,0.2 0,0.3 0.7,3 11.3,5.8 11.9,9.2 0,0.1 0,0.2 0,0.3 -0,0.1 -0,0.1 -0,0.1 -0.2,1.6 -2.9,2.2 -5.2,2.2 -0.7,0 -1.3,0 -1.8,-0.1 -2.6,-0.4 -5.4,-2.3 -7.3,-2.3 -5.3,0 -9.5,5.5 -15.2,4.8 -4.4,-0.6 -5.5,-7.9 -12.3,-7.9 l -1.3,0 c -3,0 -5.6,1.7 -8.4,1.7 -0.5,0 -0.7,-0.3 -0.9,-0.6 -0,-0 -0,-0.1 -0.1,-0.1 -0.2,-0.5 -0.3,-1.1 -0.6,-1.6 -0,-0 0,-0 0,-0 -0,-0.1 -0.1,-0.1 -0.1,-0.2 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0.1 -0.1,-0.1 -0.1,-0.1 -0.1,-0.2 -0.3,-0.3 -0.4,-0.4 -1.2,-0.9 -2.3,-1.1 -4,-1.4 -1.9,-0.3 -5.8,-0.3 -7.3,-1.5 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0.1 -0,-0 -0,-0 -0,-0 -0.2,-0.3 -0.4,-0.6 -0.4,-0.9 l 0,-0.3 c 0,-2.1 13.2,-0.9 13.2,-3.2 0,-0.3 -0.1,-0.6 -0.3,-0.8 -0,-0.1 -0.1,-0.1 -0.1,-0.2 -0,-0 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.1,-0.1 -0.2,-0.2 -0,-0 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.3,-0.3 -0.5,-0.4 -1.7,-1.3 -4.8,-2.7 -6.3,-3.9 -0.1,-0.1 -0.3,-0.2 -0.4,-0.3 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.1,-0.1 -0.2,-0.2 -0.2,-0.4 0.3,-0.1 0.6,-0.3 1.1,-0.3 l 2.9,0 6.3,0.3 2.6,-0.3 c 9.4e-4,0 -9.4e-4,0 0,0 l 0.7,-0.1 0.8,0.1 c -0,-0 -0,-0 -0,-0 -0.8,-3.3 -1.4,-7.9 -1.4,-13.1 0,-5.1 0.5,-9.7 1.4,-13.1 0.4,-1.7 0.9,-3 1.4,-3.8 0.5,-0.8 1,-1.1 1.3,-1.1 z m 27.7,1.1 -17.4,17 17.4,16.9 17.4,-16.9 -17.4,-17 z m -2.2,2.9 0,13.8 -3.6,0 0.1,-10.4 3.5,-3.5 z m 4.3,0 c 0.4,0.3 3.6,3.3 3.6,3.7 l 0,10.2 -3.6,0 0,-13.8 z m 7.3,7.2 3.2,2.9 c -0.1,0.1 -0.1,0.1 -0.1,0.1 -0,-0 0,0 0,0.3 l 0,3.3 -3.1,0 0,-6.7 z m -18.8,0 0,6.7 -3,0 0,-3.7 c 0,-0.4 2.7,-2.8 3,-3 z m -7,7.1 32.8,0 -16.4,15.8 -16.4,-15.8 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 134,72.9 c -0.2,0 -0.4,0.1 -0.7,0.4 l 0,-0.2 -47.9,0 c 0.2,0.2 0.4,0.4 0.6,0.7 0.6,1 1.1,2.3 1.5,4 0.9,3.4 1.4,8.1 1.4,13.2 0,5.2 -0.5,9.8 -1.4,13.2 -0.4,1.7 -0.9,3.1 -1.5,4 -0.2,0.3 -0.4,0.5 -0.6,0.8 l 47.9,0 0,-0.7 c 0.3,0.3 0.5,0.4 0.7,0.4 0.3,0 0.7,-0.3 1.3,-1.1 0.5,-0.8 1,-2.2 1.4,-3.8 0.8,-3.3 1.4,-7.9 1.4,-13.1 0,-5.1 -0.5,-9.8 -1.4,-13.1 -0.4,-1.7 -0.9,-3 -1.4,-3.8 -0.5,-0.8 -1,-1.1 -1.3,-1.1 z m -50.7,0.2 c -0.3,0 -0.7,0.3 -1.3,1.1 -0.5,0.8 -1,2.2 -1.4,3.8 -0.8,3.3 -1.4,7.9 -1.4,13.1 0,5.1 0.5,9.8 1.4,13.1 0,0 0,0 0,0 l -0.8,-0.1 -3.3,0.4 -6.2,-0.3 -2.9,0 c -0.5,0 -0.8,0.1 -1.1,0.3 0.4,1.6 8.4,4.3 8.4,6.5 0,2.3 -13.2,1.1 -13.2,3.2 l 0,0.3 c 0,2.4 5.6,2.3 8,2.7 1.7,0.3 2.8,0.5 4,1.4 1.3,1 0.8,3.3 2.2,3.3 2.8,0 5.4,-1.7 8.4,-1.7 l 1.3,0 c 6.8,0 7.9,7.3 12.3,7.9 5.7,0.7 9.9,-4.8 15.2,-4.8 1.8,0 4.7,1.9 7.3,2.3 2.3,0.2 7,-0.2 7,-2.4 0,-3.6 -12,-6.5 -12,-9.8 l 0,-0.1 c 0,-0.9 0.9,-1.4 1.7,-1.4 l 0.3,0 c 1.4,0 3.9,0.3 4.7,-0.7 -0.3,-0.4 -2.5,-1.7 -3.2,-1.7 l -20.3,0.1 -7.1,-0.1 -8.3,0.2 c -0.7,-0.5 -1.3,-1.8 -1.7,-3.5 0.3,0.7 0.5,1.3 0.8,1.8 0.5,0.8 1,1.1 1.3,1.1 0.3,0 0.7,-0.3 1.3,-1.1 0.5,-0.8 1,-2.2 1.4,-3.8 0.8,-3.3 1.4,-7.9 1.4,-13.1 0,-5.1 -0.5,-9.7 -1.4,-13.1 -0.4,-1.7 -0.9,-3 -1.4,-3.8 -0.5,-0.8 -1,-1.1 -1.3,-1.1 z m 27.7,1.1 17.4,17 -17.4,16.9 -17.4,-16.9 17.4,-17 z m -2.2,2.9 -3.5,3.5 -0.1,10.4 3.6,0 -0,-13.8 z m 4.3,0 0,13.8 3.6,0 0,-10.2 c 0,-0.4 -3.2,-3.4 -3.6,-3.7 z m 7.3,7.2 0,6.7 3.1,0 0,-3.3 c 0,-0.3 -0,-0.3 -0,-0.3 0,0 0,0 0.1,-0.1 l -3.2,-2.9 z m -18.8,0 c -0.4,0.3 -3,2.7 -3,3 l 0,3.7 3,0 0,-6.7 z m -7,7.1 16.4,15.8 16.4,-15.8 -32.8,0 z"}],i["GR.IN.IC.TOXIC RELEASE INVENTORY"]=[{type:"path",stroke:!1,d:"m 81.8,61 0,15.2 2,0 0,-6.4 2.2,0 c 0.8,6e-6 1.5,0.2 1.9,0.5 0.5,0.3 1,1 1.5,2 l 1.9,3.9 2.2,0 -2.1,-4.2 c -0.4,-0.9 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.8,-0.8 -1.3,-0.9 0.8,-0.2 1.5,-0.7 1.9,-1.3 0.4,-0.6 0.7,-1.4 0.7,-2.4 -2e-5,-1.5 -0.4,-2.6 -1.3,-3.3 -0.9,-0.7 -2.1,-1.1 -3.9,-1.1 l -4.6,0 z m 14.5,0 0,15.2 9.8,0 0,-1.7 -7.7,0 0,-5.5 7.2,0 0,-1.7 -7.2,0 0,-4.5 7.5,0 0,-1.7 -9.6,0 z m 13.2,0 0,15.2 9.4,0 0,-1.7 -7.4,0 0,-13.4 -2,0 z m -25.6,1.7 2.6,0 c 1,1.4e-5 1.7,0.2 2.2,0.7 0.5,0.4 0.8,1.1 0.8,2 -10e-6,0.9 -0.3,1.6 -0.8,2 -0.5,0.5 -1.2,0.7 -2.2,0.7 l -2.6,0 0,-5.4 z m 16,14.7 c -4.3,1.1e-5 -8.3,0.4 -11.2,1.2 -1.4,0.4 -2.6,0.8 -3.5,1.3 -0.7,0.4 -1.2,0.9 -1.4,1.5 l -0.1,0 0,0.6 c -3.1e-5,0 0,0 0,0 l 0,31.1 -0.2,-0.7 c -0.1,0 -1.1,0.1 -2.4,0 -1.2,-0.1 -2.7,-0.2 -4.2,-0.3 -1.5,-0.1 -2.9,-0.2 -4,-0.1 -0.6,0 -1.1,0 -1.5,0.1 -0.2,0 -0.4,0.1 -0.6,0.2 -0.2,0.1 -0.4,0.2 -0.6,0.5 -0.3,0.4 -0.4,0.9 -0.3,1.4 0.1,0.5 0.3,0.8 0.5,1.2 0.5,0.7 1.2,1.2 1.9,1.7 0.7,0.5 1.4,1 1.9,1.5 0.5,0.5 0.7,0.9 0.6,1.2 -0,0.1 -0,0.2 -0.2,0.3 -0.2,0.2 -0.6,0.3 -1,0.5 -0.9,0.3 -2.2,0.5 -3.5,0.7 -1.3,0.2 -2.7,0.3 -3.7,0.5 -0.5,0.1 -1,0.2 -1.4,0.4 -0.2,0.1 -0.4,0.2 -0.6,0.3 -0.2,0.2 -0.4,0.4 -0.4,0.7 -0.1,0.9 0.3,1.7 1,2.3 0.7,0.6 1.5,1.1 2.6,1.6 2.1,0.9 4.9,1.7 7.9,2.4 2.9,0.7 5.9,1.2 8.3,1.7 2.4,0.4 4.4,0.8 4.8,0.9 2,0.6 3.3,1.8 4.9,3.2 1.5,1.3 3.2,2.8 5.8,3.5 3,0.8 6.2,-0.6 9.4,-2 3.2,-1.4 6.4,-2.8 9.1,-2.5 0.1,0 1,0.2 1.9,0.5 1,0.3 2.2,0.6 3.4,0.8 1.2,0.3 2.4,0.5 3.5,0.6 1.1,0.1 2,0.2 2.7,-0.5 0.8,-0.7 1.3,-1.4 1.4,-2.1 0.2,-0.8 -0,-1.5 -0.4,-2.2 -0.8,-1.3 -2.2,-2.3 -3.9,-3.2 -1.6,-0.9 -3.5,-1.8 -5,-2.6 -1.5,-0.8 -2.7,-1.6 -3,-1.9 -0.2,-0.3 -0.2,-0.2 -0.1,-0.4 0.1,-0.1 0.3,-0.4 0.7,-0.7 0.8,-0.5 2.2,-1 3.2,-1.5 0.5,-0.3 1,-0.5 1.3,-1 0.2,-0.3 0.3,-0.7 0.2,-1 -0.1,-0.4 -0.3,-0.6 -0.6,-0.8 -0.5,-0.4 -1.2,-0.7 -2.3,-1.1 -1.1,-0.3 -2.6,-0.7 -4.6,-1.1 l -0.3,1.3 0,-35.4 0,-0.6 -0.1,0 c -0.2,-0.6 -0.7,-1.1 -1.4,-1.5 -0.9,-0.5 -2.1,-1 -3.5,-1.3 -2.9,-0.7 -6.8,-1.2 -11.2,-1.2 z m 0,1.2 c 4.3,-1.1e-5 8.1,0.4 10.9,1.1 1.4,0.4 2.5,0.8 3.2,1.2 0.3,0.2 0.4,0.3 0.6,0.5 0.1,0.1 0.2,0.2 0.3,0.3 0,0 0,0 0,0.1 0,0 0,0.1 0,0.1 0,0 0,0.1 0,0.1 0,0 -0,0.1 -0,0.1 -0,0 -0,0 -0,0 -0,0 -0,0 -0,0.1 -0,0 -0,0 -0,0.1 -0,0 -0,0 -0,0.1 -0,0 -0,0.1 -0.1,0.1 -0,0.1 -0.1,0.1 -0.1,0.2 -0,0 -0,0 -0,0 -0.1,0.1 -0.3,0.3 -0.6,0.5 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.2 -10.9,1.2 -4.3,1.1e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.3,-0.2 -0.5,-0.3 -0.6,-0.5 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0.1 -0.1,-0.1 -0.1,-0.2 0,-0 0,-0.1 0,-0.1 0.1,-0.2 0.3,-0.6 0.9,-0.9 0.7,-0.4 1.8,-0.8 3.2,-1.2 2.8,-0.7 6.6,-1.1 10.9,-1.1 z m 15,5.3 0,34.1 0,0 0,5.6 c 0.1,0.2 0.2,0.3 0.2,0.4 0,0.2 -0.2,0.6 -0.9,1.1 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.1 -10.9,1.1 -4.3,1e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.6,-0.4 -0.9,-0.7 -0.9,-1 l -0,0 0,-0.1 0,-1.9 c -0.1,0.1 -0.1,0.1 -0.2,0.1 l 0,-38.4 c 0.1,0.1 0.2,0.1 0.3,0.2 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1.2e-5 8.3,-0.5 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.1,-0.1 0.2,-0.1 0.3,-0.2 z m -15.2,6.1 -14.6,14.2 14.2,13.8 0.8,0 14.2,-13.8 -14.6,-14.3 z m -1.8,2.4 0,11.6 -3.1,0 0.1,-8.7 3,-2.9 z m 3.6,0 c 0.4,0.3 3,2.7 3,3 l 0,8.5 -3,0 0,-11.6 z m -9.7,6 0,5.6 -2.5,0 0,-3.1 c 0,-0.3 2.2,-2.3 2.5,-2.5 z m 15.8,0 2.6,2.5 c -0.1,0.3 -0.1,-0.1 -0.1,0.3 l 0,2.8 -2.5,0 0,-5.6 z m -21.7,6 27.5,0 -13.8,13.3 -13.7,-13.3 z m -12.8,9.3 c 1.1,-0 2.5,0 3.9,0.1 1.4,0.1 2.9,0.2 4.2,0.3 1.1,0.1 1.9,0.1 2.6,-0 l 0,10 0,0.6 0.3,0 c 0.2,0.6 0.7,1.1 1.4,1.5 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1e-5 8.3,-0.4 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.9,-0.5 1.5,-1.2 1.5,-2.1 0,-0.3 -0.1,-0.5 -0.2,-0.8 l 0,-5.6 c 1.9,0.4 3.4,0.8 4.4,1.1 0.9,0.3 1.3,0.5 1.6,0.7 -0.1,0.1 -0.1,0.1 -0.4,0.3 -0.8,0.4 -2.2,0.9 -3.3,1.6 -0.5,0.3 -1,0.7 -1.3,1.3 -0.3,0.6 -0.2,1.4 0.2,2 0.7,1 2,1.6 3.5,2.4 1.6,0.8 3.4,1.6 4.9,2.5 1.5,0.9 2.8,1.9 3.3,2.7 0.2,0.4 0.3,0.7 0.2,1 -0.1,0.3 -0.3,0.8 -0.9,1.3 0,-0 -0.6,0.2 -1.5,0.1 -0.9,-0.1 -2.1,-0.3 -3.3,-0.6 -1.2,-0.3 -2.4,-0.6 -3.3,-0.8 -1,-0.3 -1.7,-0.5 -2.2,-0.5 -3.3,-0.3 -6.7,1.3 -9.9,2.7 -3.2,1.4 -6.1,2.5 -8.4,1.9 -2.3,-0.6 -3.7,-1.8 -5.2,-3.2 -1.5,-1.3 -3.1,-2.8 -5.5,-3.5 -0.8,-0.2 -2.5,-0.5 -5,-0.9 -2.4,-0.4 -5.4,-1 -8.3,-1.6 -2.9,-0.7 -5.6,-1.5 -7.6,-2.3 -1,-0.4 -1.7,-0.9 -2.2,-1.3 -0.3,-0.3 -0.4,-0.5 -0.5,-0.7 0.2,-0.1 0.6,-0.2 1.1,-0.3 1,-0.2 2.3,-0.3 3.6,-0.5 1.4,-0.2 2.7,-0.4 3.9,-0.8 0.6,-0.2 1.1,-0.4 1.5,-0.8 0.4,-0.3 0.8,-0.8 0.8,-1.4 0.1,-1 -0.4,-1.8 -1.1,-2.5 -0.6,-0.7 -1.4,-1.2 -2.1,-1.7 -0.7,-0.5 -1.3,-1 -1.6,-1.4 -0.1,-0.2 -0.2,-0.3 -0.2,-0.4 -0,-0.1 0,-0.1 0.1,-0.2 0,-0 0.1,-0 0.1,-0 0.3,-0 0.7,-0.1 1.2,-0.1 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 85.8,104.4 13.7,13.3 13.8,-13.3 z m 21.7,-0.4 h 2.5 v -2.8 c 0,-0.5 -0,-0.1 0.1,-0.4 l -2.7,-2.4 v 5.6 z m -6.1,0 h 3.1 v -8.5 c 0,-0.3 -2.7,-2.8 -3.1,-3.1 v 11.6 z m -6.6,-8.7 -0.1,8.7 3.1,0 -0,-11.6 z m -5.7,5.6 v 3.1 h 2.5 v -5.6 c -0.3,0.2 -2.5,2.2 -2.5,2.5 z M 99.8,85.4 c -4.3,1.2e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.7,-0.4 -0.9,-0.8 -0.9,-1 0,-0.2 0.2,-0.6 0.9,-1 0.7,-0.4 1.8,-0.8 3.2,-1.2 2.8,-0.7 6.6,-1.2 10.9,-1.2 4.3,-1.1e-5 8.1,0.4 10.9,1.1 1.4,0.4 2.5,0.8 3.2,1.2 0.7,0.4 0.9,0.8 0.9,1 0,0.2 -0.2,0.6 -0.9,1 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.2 -10.9,1.2 z m -15,-1.5 0,38.4 c 0.1,-0.1 0.1,-0.1 0.2,-0.1 l 0,1.8 0,0.1 0,0 c 0,0.2 0.3,0.6 0.9,0.9 0.7,0.4 1.8,0.9 3.2,1.2 2.8,0.7 6.6,1.2 10.9,1.2 4.3,-1e-5 8.2,-0.5 10.9,-1.2 1.4,-0.4 2.4,-0.8 3.2,-1.2 0.7,-0.4 0.9,-0.8 0.9,-1 0,-0.1 -0,-0.2 -0.2,-0.4 l 0,-5.6 -0,0 0,-34.1 c -0.1,0.1 -0.2,0.1 -0.3,0.2 -0.9,0.5 -2.1,1 -3.5,1.3 -2.9,0.7 -6.8,1.2 -11.2,1.2 -4.3,1.1e-5 -8.3,-0.4 -11.2,-1.2 -1.4,-0.4 -2.6,-0.8 -3.5,-1.3 -0.1,-0.1 -0.2,-0.1 -0.3,-0.2 z m 14.8,6.1 14.6,14.3 -14.2,13.8 -0.8,0 L 85,104.2 99.6,90 z m -26.7,23.7 c 1.1,-0 2.5,0 3.9,0.1 1.4,0.1 2.9,0.2 4.2,0.3 1.1,0.1 1.9,0.1 2.6,-0 l 0,10 0,0.6 0.3,0 c 0.2,0.6 0.7,1.1 1.4,1.5 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1e-5 8.3,-0.4 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.9,-0.5 1.5,-1.2 1.5,-2.1 0,-0.3 -0.1,-0.5 -0.2,-0.8 l 0,-5.6 c 1.9,0.4 3.4,0.8 4.4,1.1 0.9,0.3 1.3,0.5 1.6,0.7 -0.1,0.1 -0.1,0.1 -0.4,0.3 -0.8,0.4 -2.2,0.9 -3.3,1.6 -0.5,0.3 -1,0.7 -1.3,1.3 -0.3,0.6 -0.2,1.4 0.2,2 0.7,1 2,1.6 3.5,2.4 1.6,0.8 3.4,1.6 4.9,2.5 1.5,0.9 2.8,1.9 3.3,2.7 0.2,0.4 0.3,0.7 0.2,1 -0.1,0.3 -0.3,0.8 -0.9,1.3 0,-0 -0.6,0.2 -1.5,0.1 -0.9,-0.1 -2.1,-0.3 -3.3,-0.6 -1.2,-0.3 -2.4,-0.6 -3.3,-0.8 -1,-0.3 -1.7,-0.5 -2.2,-0.5 -3.3,-0.3 -6.7,1.3 -9.9,2.7 -3.2,1.4 -6.1,2.5 -8.4,1.9 -2.3,-0.6 -3.7,-1.8 -5.2,-3.2 -1.5,-1.3 -3.1,-2.8 -5.5,-3.5 -0.8,-0.2 -2.5,-0.5 -5,-0.9 -2.4,-0.4 -5.4,-1 -8.3,-1.6 -2.9,-0.7 -5.6,-1.5 -7.6,-2.3 -1,-0.4 -1.7,-0.9 -2.2,-1.3 -0.3,-0.3 -0.4,-0.5 -0.5,-0.7 0.2,-0.1 0.6,-0.2 1.1,-0.3 1,-0.2 2.3,-0.3 3.6,-0.5 1.4,-0.2 2.7,-0.4 3.9,-0.8 0.6,-0.2 1.1,-0.4 1.5,-0.8 0.4,-0.3 0.8,-0.8 0.8,-1.4 0.1,-1 -0.4,-1.8 -1.1,-2.5 -0.6,-0.7 -1.4,-1.2 -2.1,-1.7 -0.7,-0.5 -1.3,-1 -1.6,-1.4 -0.1,-0.2 -0.2,-0.3 -0.2,-0.4 -0,-0.1 0,-0.1 0.1,-0.2 0,-0 0.1,-0 0.1,-0 0.3,-0 0.7,-0.1 1.2,-0.1 z"}],i["GR.IN.IC.COLLEGE/UNIVERSITY"]=[{type:"path",stroke:!1,d:"m 97.4,106.9 h -14.8 v 31.7 h 32 v -31.7 H 99.8 V 95.1 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 h -2.3 v 24.5 z m 23.3,-30.1 -9.6,0 0,-15.1 2,0 0,13.3 7.6,0 0,1.8 M 106,63.5 c 0.6,0.7 1.1,1.5 1.4,2.5 0.3,1 0.5,2.1 0.5,3.3 -1e-5,1.2 -0.2,2.4 -0.5,3.4 -0.3,1 -0.8,1.8 -1.4,2.5 -0.6,0.7 -1.4,1.2 -2.2,1.5 -0.8,0.3 -1.8,0.5 -2.9,0.5 -1.1,0 -2,-0.2 -2.9,-0.5 -0.9,-0.4 -1.6,-0.9 -2.2,-1.5 -0.6,-0.7 -1.1,-1.5 -1.4,-2.5 -0.3,-1 -0.5,-2.1 -0.5,-3.3 -10e-7,-1.2 0.2,-2.3 0.5,-3.3 0.3,-1 0.8,-1.8 1.4,-2.5 0.6,-0.7 1.3,-1.2 2.2,-1.5 0.9,-0.4 1.9,-0.5 2.9,-0.5 1.1,1.5e-5 2.1,0.2 2.9,0.5 0.9,0.4 1.6,0.9 2.2,1.5 m -0.2,5.8 c -2e-5,-2 -0.4,-3.5 -1.3,-4.5 -0.9,-1.1 -2.1,-1.6 -3.6,-1.6 -1.5,1.4e-5 -2.7,0.5 -3.6,1.6 -0.9,1.1 -1.3,2.6 -1.3,4.5 -3e-6,2 0.4,3.5 1.3,4.6 0.9,1 2.1,1.6 3.6,1.6 1.5,2e-6 2.7,-0.5 3.6,-1.6 0.9,-1.1 1.3,-2.6 1.3,-4.6 m -14,6.5 c -0.4,0.2 -0.7,0.3 -1,0.5 -0.3,0.1 -0.7,0.3 -1.2,0.4 -0.4,0.1 -0.9,0.2 -1.4,0.3 -0.5,0.1 -1,0.1 -1.6,0.1 -1.1,0 -2.1,-0.2 -3,-0.5 -0.9,-0.3 -1.7,-0.8 -2.3,-1.5 -0.7,-0.6 -1.2,-1.5 -1.5,-2.4 -0.4,-1 -0.5,-2.1 -0.5,-3.5 -10e-7,-1.2 0.2,-2.4 0.5,-3.3 0.4,-1 0.9,-1.8 1.5,-2.5 0.6,-0.7 1.4,-1.2 2.3,-1.5 0.9,-0.3 1.9,-0.5 3,-0.5 0.8,1.5e-5 1.6,0.1 2.4,0.3 0.8,0.2 1.7,0.5 2.7,1 l 0,2.4 -0.2,0 c -0.8,-0.7 -1.7,-1.2 -2.5,-1.5 -0.8,-0.3 -1.7,-0.5 -2.6,-0.5 -0.8,1.4e-5 -1.5,0.1 -2.1,0.4 -0.6,0.2 -1.2,0.6 -1.6,1.1 -0.5,0.5 -0.8,1.2 -1.1,1.9 -0.3,0.8 -0.4,1.7 -0.4,2.7 -3e-6,1.1 0.1,2 0.4,2.7 0.3,0.8 0.7,1.4 1.1,1.9 0.5,0.5 1,0.9 1.7,1.1 0.6,0.2 1.3,0.4 2,0.4 1,2e-6 1.9,-0.2 2.7,-0.5 0.8,-0.3 1.6,-0.8 2.4,-1.5 l 0.1,0 0,2.4"}],i["GR.IN.IC.SCHOOL"]=[{type:"path",stroke:!1,d:"M 98.4,96.4 H 83.7 v 31.7 h 32 V 96.4 H 100.9 V 84.6 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 H 98.4 V 96.4 z"}],i["GR.IN.IC.REST STOP"]=[{type:"path",stroke:!1,d:"m 108.4,89.6 v -0.4 l 0.6,-0.6 -0.4,1.4 -3.8,13.4 -0.2,0.8 -0.4,0.6 0,0.9 -2,6.7 7.2,0 v 19.7 h 5.2 v -19.7 h 2.7 v 19.7 h 5.2 v -19.7 h 7.1 l -1.3,-5.3 -0.2,-0.8 -4.8,-16.4 -0.5,-1.4 0.6,0.7 0.1,0.4 c 2.1,2.4 5.4,14.2 8.6,14.2 h 0.4 c 1.2,0 2.1,-1.1 2.1,-2.3 v -0.6 c 0,-0.5 -4.8,-10 -5.3,-11.6 -0.7,-2 -1.7,-4.2 -2.6,-6 -1,-2.1 -1.2,-3.8 -4.6,-3.8 h -12.4 c -3.4,0 -3.6,1.8 -4.7,3.9 -0.9,1.7 -1.9,4 -2.5,5.9 -0.6,1.6 -5.2,11.1 -5.2,11.6 v 0.6 c 0,1.3 0.6,2.3 1.9,2.3 h 0.8 c 2.4,0 6.4,-12.2 8.2,-14.2 z m 0.2,0.4 0.4,-1.5 -0.6,0.6 0,0.4 z m 15.1,-0.4 -0.1,-0.4 -0.6,-0.6 0.5,1.4 z M 69.6,88.8 h 2.3 v 43.6 h 6.1 v -25.6 h 2.7 v 25.6 h 5.9 v -43.6 h 2.3 v 16.4 h 4.6 V 86.3 l -0.3,-2.3 h -0.4 c 0,-2.3 -1.7,-4.4 -4,-4.4 H 69.6 c -3,0 -4.4,3.4 -4.4,6.5 v 19.1 h 4.4 V 88.8 z M 110.7,72.8 c 0,2.7 2.4,5.4 5,5.4 h 0.2 c 1.6,0 2.8,-0.6 3.6,-1.4 0.5,-0.4 1.8,-2.4 1.8,-3 v -1.6 c 0,-2.4 -2.8,-4.6 -5.4,-4.6 -3,-0 -5.2,2.4 -5.2,5.2 z m -36.7,1.1 c 0,2 2.8,4.4 5,4.4 h 0.2 c 4.2,0 4.3,-3.4 5.2,-3.8 V 71.6 c 0,-1.8 -2.8,-4 -5.2,-4 -2.3,0 -5.2,2.2 -5.2,4 v 2.3 z"}],i["GR.IN.IC.CONTROL VALVE"]=[{type:"path",stroke:!1,d:"m 114,114.5 h 15.7 v 4 h 9.1 v -23.6 h -9.1 V 98.8 H 114.4 c -0.4,0 -2.6,-2.6 -2.6,-3.4 v -5.6 h -9.9 v -8.2 h 12.3 v -3.6 h -28.2 v 3.6 h 12.1 v 8.3 H 89.2 v 6.6 l -0.2,-0.2 -1.8,2.4 -17.2,0.1 V 95 H 61.2 v 23.6 h 8.9 v -4 H 87 c 0.4,0 2,2.4 2.4,2.8 0.5,0.6 2.2,1.9 2.9,2.4 1.9,1.2 4.7,2.4 7.8,2.4 h 0.6 c 3.5,0 5.8,-1 8.1,-2.4 1.4,-0.8 4.8,-3.8 5.2,-5.3 z"}],i["GR.IN.IC.DAM"]=[{type:"path",stroke:!1,d:"m 68.3,89.1 c 2.3,0 3.2,-1.7 4.6,-2.6 1.1,0.8 2.2,2.6 4.4,2.6 h 0.2 c 2.6,0 3.3,-1.7 4.7,-2.6 1.4,0.9 2.2,2.6 4.7,2.6 2.4,0 3.3,-1.8 4.6,-2.6 0.6,0.4 1.1,1.1 1.9,1.6 0.4,0.2 2.2,0.9 2.2,1.3 v 6.8 C 94.1,95.8 91.8,93.8 91.5,92.6 h -0.3 c -0.3,1.1 -3,3.6 -4.5,3.6 -1.5,0 -4.1,-2.6 -4.4,-3.8 -1,0.6 -2.6,3.8 -4.6,3.8 h -0.4 c -1.2,0 -4,-2.7 -4.2,-3.7 -0.8,0.2 -2.6,3.7 -4.7,3.7 h -0.3 c -1.1,0 -1.7,-0.7 -2.4,-1.2 l -1,1.2 c 1,0.7 1.6,1.8 3.2,1.8 h 0.4 c 2.3,0 3.1,-1.8 4.6,-2.8 0.7,1.1 2.8,2.8 4.7,2.8 2.3,0 3.3,-2 4.6,-2.8 1.2,0.8 2.6,2.8 4.7,2.8 2.1,0 3.4,-2.1 4.7,-2.8 0.7,1 2.6,2.4 4,2.7 v 7 c -1.4,-0.1 -3.4,-2.4 -4,-3.5 -1.1,0.7 -2.5,3.6 -4.7,3.6 h -0.1 c -2.3,0 -4.1,-3.5 -4.7,-3.7 -0.3,1 -3,3.7 -4.1,3.7 h -0.4 c -2.2,0 -3.6,-2.9 -4.7,-3.7 -0.6,1 -2.8,3.7 -4.1,3.7 H 67.7 c -0.7,0 -1.7,-1 -2.2,-1.3 l -0.9,1.5 c 1.1,0.7 1.7,1.6 3.6,1.6 2.7,0 3.1,-1.8 4.7,-2.6 1.4,0.9 2,2.6 4.7,2.6 2.2,0 3.4,-1.8 4.6,-2.6 1.4,1 2.5,2.6 4.8,2.6 1.8,0 3.4,-2 4.4,-2.6 0.9,0.5 1,1 2,1.6 0.4,0.3 2.2,0.7 2.2,1.2 v 6.8 c -1.4,-0.3 -3.6,-2.2 -4,-3.5 -1.1,0.7 -2.5,3.8 -4.8,3.8 -1.4,0 -4.1,-2.6 -4.4,-3.8 -1.2,0.8 -2.6,3.8 -4.8,3.8 -2,0 -3.7,-3.2 -4.7,-3.8 -0.3,1 -3,3.8 -4.3,3.8 h -0.6 c -0.8,0 -1.8,-1 -2.4,-1.3 l -0.9,1.3 c 1.1,0.7 1.8,1.8 3.6,1.8 2.2,0 3.3,-1.8 4.7,-2.8 1.2,0.8 2.6,2.9 4.7,2.8 2.3,-0.1 3.3,-1.9 4.6,-2.8 1.2,0.8 2.7,2.8 4.7,2.8 1.9,0 3.4,-2 4.6,-2.8 1.6,1 1.8,2 4.1,2.5 v 5 h 17 l -1.4,-5.2 c 0.8,0.2 1,0.6 2.2,0.6 2,0 3.3,-1.9 4.6,-2.8 1.3,0.9 2.4,2.8 4.7,2.8 1.6,0 3.8,-1.8 4.4,-2.8 1.3,0.3 2.5,2.8 5.1,2.8 1.2,0 2.6,-1.4 3.4,-1.8 l -1,-1.3 c -0.7,0.4 -1.5,1.3 -2.6,1.3 -2.1,0 -3.7,-3.1 -4.7,-3.8 -0.7,1.4 -2.7,3.8 -4.7,3.8 -1.3,0 -4.3,-2.6 -4.4,-3.8 -1,0.7 -2.6,3.8 -4.7,3.8 h -0.2 c -1.1,0 -2.2,-0.9 -2.7,-1.5 -0.4,-0.4 -0.8,-2.5 -1.1,-3.2 -0.4,-1 -1.8,-5.6 -1.8,-6.6 l -0.3,-0.4 0,-0.6 -0.3,-0.4 v -0.6 l -0.3,-0.4 -5.3,-18.6 0.2,-0 -0.3,-0.4 0,-0.6 c -0.2,-0.3 -0.3,-0.3 -0.3,-0.6 v -0.4 h -5.6 v 7.8 c -1.4,-0.7 -1.2,-0.5 -2.4,-1.6 -0.1,-0.1 -1,-0.9 -1,-1 -0.4,-0.5 -0.1,-0.9 -0.8,-1.1 -0.1,1.2 -3.1,3.8 -4.3,3.8 h -0.2 c -2.5,0 -4.2,-3.6 -4.8,-3.8 -0.3,1.1 -3,3.8 -4.2,3.8 h -0.4 c -1.2,0 -4.2,-2.7 -4.2,-3.8 -0.5,0.1 -2.8,3.8 -4.4,3.8 H 67.7 c -0.7,0 -1.7,-1 -2.2,-1.3 l -0.9,1.3 c 1,0.7 1.6,1.6 3.4,1.6 h 0.3 v 0 z"}],i["GR.IN.IC.DISCHARGE OUTFALL"]=[{type:"path",stroke:!1,d:"m 63.2,111.4 v 13.4 h 73.6 V 111.7 l -3.1,0.5 -1.1,-0.1 c -2.2,0 -3.6,-0.7 -4.9,-1.6 -0.6,-0.4 -1.1,-1.1 -1.5,-1.8 -0.4,-0.6 -0.2,-2.1 -1,-2.1 h -0.4 c -0.8,0 -0.7,1.6 -1.2,2.2 -0.4,0.6 -0.9,1.2 -1.6,1.7 -1.3,1 -3,1.6 -5.1,1.6 h -0.9 c -3.2,0 -6.8,-2.1 -6.8,-5.1 -0.3,-0.2 -0.4,-0.4 -0.8,-0.4 h -0.3 c -0.7,0 -0.8,1.5 -1.1,2.1 -0.4,0.6 -1,1.4 -1.5,1.8 -1.2,1 -2.7,1.6 -4.8,1.6 h -0.9 c -3.5,0 -7.3,-2.1 -7.3,-5.4 -0.4,-0.1 -0.4,-0.2 -0.8,-0.2 h -0.3 c -0.6,0 -0.6,1.5 -1.1,2.2 -0.5,0.8 -0.7,1.1 -1.5,1.7 -1.3,1 -2.7,1.6 -4.8,1.6 H 82.9 c -3.5,0 -6.7,-2.2 -7,-5.4 -0.3,-0.1 -0.4,-0.2 -0.8,-0.2 h -0.1 c -0.7,0 -0.8,1.5 -1.2,2.2 -0.4,0.6 -0.9,1.2 -1.6,1.7 -1.4,1 -2.7,1.6 -5,1.6 h -1 c -1.2,0 -2.2,-0.4 -3,-0.8 l 0,0 z m 0,-21.6 19.5,0 0,1.2 2.7,0 0,-15.8 -2.7,0 0,1.2 -19.5,0 z M 89.7,80.9 v 0.1 c 8.1,0 16.2,1.2 20.6,4.9 2.8,2.4 3.1,4.5 3.1,9.6 0,4.1 0.5,8.3 4.5,8.3 h 0.8 c 1.7,0 2.8,-2.6 2.8,-4.3 v -0.9 c 0,-5.1 -3.3,-10.7 -5.9,-13.3 -1.6,-1.6 -3.6,-3 -6.1,-3.6 -2.2,-0.5 -6,-1.1 -8.6,-1.1 l -1.8,-0.1 -9.4,0.4 z"}],i["GR.IN.IC.GROUND WATER WELL"]=[{type:"path",stroke:!1,d:"M86,64L86,70L75,110L81,110L92,70L99,70L99,130L86,130L86,140L120,140L120,130L110,130L110,89L120,89L120,93L130,93L130,87C130,82.631 125.551,83 125.551,83L110,83L110,70L113.774,70L113.774,64L86,64Z"}],i["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 109.7,116.6 4.1,13.4 -0.2,0.1 -12.2,-8.4 8.3,-5.2 z m -19.7,0 8,5.1 -12.1,8.4 4.1,-13.6 z m 9.8,-9.8 8.8,8.2 c -1.7,0.5 -8.1,5.6 -8.8,5.6 -0.2,0 -8.2,-5.4 -8.6,-5.8 l 8.5,-8.1 z m 5.3,-4.8 3.1,9.8 -6.9,-6.4 3.7,-3.4 z m -10.5,0.1 3.8,3.3 -6.9,6.4 3.1,-9.7 z m 2.1,-1 6.4,-0 -3.2,3.2 -3.2,-3.2 z M 99.2,84.8 C 99.1,85.4 99,85.5 99,86.1 v 2 h -3 c -0.5,0 -0.8,0.3 -0.8,0.8 0,0.5 0.1,0.5 0.2,1 0.4,0.1 0.4,0.2 1,0.2 h 2.6 v 2.8 h -4.5 c -0.6,0 -1.2,0.2 -1.2,0.8 0,0.5 0.3,0.8 0.8,0.8 h 4.9 v 4.9 h -4.5 c -0.5,0 -0.5,0.1 -0.9,0.2 l -2.5,7.9 -1,3.2 -4.1,13.3 -1.1,3.1 c 0,2 -1.4,3.5 -1.4,5.5 0,0.4 0.1,0.2 0.2,0.8 h 0.5 c 0.6,0 15.1,-10.3 15.4,-10.3 0.6,0 14.2,9.4 15.8,10.5 0.4,-0.2 1,-0.4 1,-1 v -0.6 c 0,-0 -1.5,-4.4 -1.7,-5 -0.4,-1.1 -1.4,-4.3 -1.5,-5.2 l -1,-3.2 -4.1,-13.2 -0.9,-3.4 c -1,-0.4 -0.3,-2.6 -1.6,-2.6 h -4.8 v -5 h 4.8 c 0.5,0 0.8,-0.3 0.8,-0.8 0,-0.5 -0.3,-0.8 -0.8,-0.8 H 100.8 V 90.1 h 2.4 c 0.7,0 1.4,-0.4 1.4,-1 v -0.2 c 0,-0.5 -0.3,-0.8 -0.8,-0.8 h -2.9 v -2.6 c 0,-0.4 -0.6,-1 -0.8,-1 -0,-0 -0.7,0.1 -0.8,0.2 z m 6.7,-15.7 c 7,1.6 10.9,4.6 15.1,8.9 3,3 7.3,11 7.3,16.9 v 4 c 0,2.1 -1.5,7.7 -2.2,9 -0.7,1.1 -1.2,2.4 -1.9,3.6 -0.3,0.4 -2.4,3.3 -2.4,3.4 0,0.7 1,1.6 1.2,2.6 1.7,-0.4 4.8,-6.3 5.7,-8.2 1.2,-2.5 2.7,-7.8 2.7,-11.4 V 94.3 c 0,-0.1 -0.9,-4.9 -1,-5.5 -0.3,-0.9 -1.4,-3.7 -1.8,-4.8 -0.9,-2.2 -3.7,-6.4 -5.2,-8 -3.6,-3.6 -10.6,-9.2 -16.9,-9.7 l -0.4,2.8 z m -1.6,10.7 c 6,0.5 13.3,9.2 13.3,16.1 v 2.2 c 0,1.5 -1.4,5.5 -1.4,5.5 0,0.2 1.2,2.9 1.4,3.2 l 0.2,0.1 1.6,-3.4 0.1,-0.6 0.7,-5.9 0.2,-0.4 -1,-5.9 c -0.7,-0.3 -0.6,-1.4 -1.1,-2.2 -0.4,-0.8 -0.8,-1.6 -1.3,-2.3 -1.1,-1.6 -1.8,-2.6 -3.2,-3.9 -2.2,-2.2 -5.8,-4.2 -9.2,-5 l -0.3,2.8 z M 68.7,95.2 v 5.1 c 0,4.2 5.4,16.3 7.9,17 0.1,-0.5 1,-2.2 1,-2.6 0,0 -2.1,-2.9 -2.3,-3.4 -0.7,-1.3 -1.3,-2.4 -1.9,-3.8 -1,-2.6 -1.8,-6 -1.8,-9.6 v -2.4 c 0,-8 3.3,-12.9 6.9,-17.5 1.4,-1.8 4.7,-4.4 6.7,-5.6 1.4,-0.8 2.5,-1.4 4.1,-2.1 0.5,-0.2 4.5,-1.3 4.5,-1.6 l -0.2,-2.6 c -2.4,0.1 -8,2.6 -9.6,3.7 -3.2,1.9 -4.8,3.6 -7.3,6.1 -3.6,3.6 -7.8,12 -7.8,19.1 l 0,0 z m 10.7,0 v 2.9 c 0,1.9 0.2,3.1 0.8,4.5 0.2,0.4 1.5,4 1.5,4 l 0.4,-0 1.5,-2.9 c -0.9,-1.2 -1.4,-4 -1.4,-6.2 v -1.8 c 0,-3.7 2.3,-8.3 4.2,-10.3 1.8,-1.8 5.9,-5.5 9.1,-5.6 L 95,77.1 C 88,77.6 79.4,87.3 79.4,95.2 z"}],i["GR.IN.IC.TELECOMMUNICATIONS TOWER"]=[{type:"path",stroke:!1,d:"m 102.5,119.2 12,-8 2.8,9.2 1.3,4 2.1,6.9 -18.2,-12 z m -23,12 3.4,-11.7 2,-5.9 0.8,-2.6 11.9,8.2 -18,12 z m 20.4,-34.6 13,12.2 c -1.5,1 -12.3,8.5 -13.1,8.5 -0.1,0 -11.6,-7.7 -12.7,-8.5 L 99.9,96.6 z m 7.7,-7.1 0.2,0.2 1.8,5.7 2.5,8.7 -10.1,-9.3 5.6,-5.2 0,0 z m -15.5,0.6 v -0.6 l 0.4,0.2 5.4,5 -10,9.4 2.6,-9 1.6,-5 z m 2.9,-1.7 9.8,-0 -5,4.4 -4.8,-4.4 z m 3.6,-23.1 v 3.6 h -4.4 c -0.5,0 -1,0.6 -1,1 v 0.6 c 0,0.7 0.8,1 1.5,1 h 4 v 4.2 h -7.2 c -0.5,0 -1,0.6 -1,1 v 0.2 c 0,1 0.5,1.5 1.5,1.5 h 6.8 v 7 h -6.8 c -0.8,0 -1,0.3 -1.3,0.7 l -0.6,2 -4.9,15.6 -3,9.6 -3.1,9.4 -0.1,0.8 -2.9,8.7 -0.1,0.8 -0.5,2.2 c 1,0.2 0.5,0.6 1.3,0.6 h 0.2 c 0.8,0 20.1,-13.7 23.1,-15.2 2.5,1.7 22.4,15.2 23.5,15.2 0.6,0 1,-0.7 1,-1.3 0,-0.1 -1.4,-4 -1.5,-4.2 l -0.1,-0.8 -3.1,-9.7 -2.9,-9.3 -4.7,-15.7 c -0.6,-0.8 -1.4,-3.8 -1.8,-5 -0.6,-1.8 -0.5,-4.3 -2.5,-4.3 h -6.8 v -7 h 7.2 c 0.5,0 1,-0.6 1,-1 v -0.4 c 0,-0.6 -0.2,-1.3 -0.8,-1.3 h -7.4 v -4.2 h 4 c 0.7,0 1.5,-0.4 1.5,-1 v -0.6 c 0,-0.7 -0.8,-1 -1.5,-1 h -4 v -4 c 0,-0.6 -0.7,-1 -1.3,-1 -0.8,-0 -1.3,0.6 -1.3,1.4 l 0,0 z m -6.6,24.8 0.4,-0.4 -0.4,-0.2 z"}],i["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]=a("ATC"),i["GR.IN.IC.PROPANE FACILITY"]=[{type:"path",stroke:!1,d:"m 98.7,73.1 v 0.2 c 0,1 0.5,1.5 1.5,1.5 0.5,0 1.1,-0.6 1.1,-1.1 0,-0.8 -0.2,-0.8 -0.2,-1.5 -0.5,-0.1 -0.5,-0.2 -1.1,-0.2 h -0.2 c -0.5,0 -1.1,0.6 -1.1,1.1 z m -12.6,58.5 h 28.4 v 3.3 h -28.4 v -3.3 z M 75.8,119 h 48.5 v 3.3 c 0,2 -8.8,7.8 -9.8,7.8 H 85.8 c -1,0 -10,-5.8 -10,-7.6 v -3.5 l 0,0 z m 0,-27.5 c 0,-1.1 7.2,-5.8 8.5,-6.6 2.6,-1.5 7.4,-3.7 11.4,-3.7 h 8.5 c 4.1,0 9.1,2 11.6,3.7 1.3,0.9 8.5,5.4 8.5,6.6 v 4.2 H 75.8 V 91.5 l 0,0 z M 98.2,77.1 c 0.7,0 0.8,0.2 1.5,0.2 h 0.4 c 0.8,0 0.8,-0.2 1.5,-0.2 v 1.8 l 1.2,0.8 -5.5,0 c 0.3,-0.5 0.9,-0.8 0.9,-1.3 l -0,-1.3 0,0 z m -1.1,-4 c 0,-1.4 1.4,-2.4 2.8,-2.4 1.3,0 2.8,0.9 2.8,2 v 1.1 c 0,1.4 -1.6,2.4 -3,2.4 -1,0 -2.6,-1.2 -2.6,-2.4 v -0.7 h -0 z m 12.2,-8.1 h 3.5 v 3.5 h -1.8 v 6.8 c 0.7,0 2.4,0.6 2.4,1.3 v 3.7 H 109.4 V 65.1 z m -22.7,0 h 4.2 V 80.3 H 85.8 v -4.1 c 0.8,-0.2 3.1,-0.8 3.1,-1.5 v -6.1 h -2.2 v -3.5 z m 5.7,0 h 15.5 v 15.3 c -1.6,-0.4 -4.8,-0.9 -4.8,-2.6 v -0.9 c 0,-1.5 0.9,-2.1 0.9,-2.6 v -1.1 c 0,-3.2 -3,-3.2 -3.3,-4.4 h 4.2 v -1.5 h -9.6 v 1.5 h 4.2 v 0.6 c -1.9,0.1 -3.1,1.9 -3.1,4 v 0.6 c 0,1 0.9,2 0.9,2.4 v 1.3 c 0,1.4 -3.4,2.3 -4.8,2.6 V 65.1 l 0,0 z m -7.2,4.8 h 2.2 v 4 c 0,0.8 -2.1,1.2 -2.8,1.3 v 6.8 h 3 c -0.6,0.4 -2.7,1.2 -3.6,1.8 -1.2,0.7 -2.2,1.4 -3.4,2.1 -0.9,0.6 -6.1,4.7 -6.3,4.8 v 31.6 c 0,1.9 3.2,4.4 4.5,5.3 1,0.6 5.8,3.3 5.8,4.1 v 4.8 h 31.2 v -4.8 c 0,-1.6 10,-4.6 10,-10 V 91.1 c 0,-0.9 -5,-4.4 -6,-5.1 -1.2,-0.8 -2.1,-1.4 -3.3,-2.1 -0.9,-0.6 -3.2,-1.4 -3.7,-1.9 h 2.4 v -6.8 c -0.7,-0.2 -2.6,-0.5 -2.6,-1.3 v -4 h 2 V 63.5 H 85.2 v 6.3 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 114.4,134.9 0,-3.3 -28.4,0 0,3.3 z M 75.8,122.5 c 0,1.9 9,7.6 10,7.6 h 28.6 c 1,0 9.8,-5.9 9.8,-7.8 v -3.3 H 75.8 v 3.5 l 0,0 z m 0,-31 v 4.2 h 48.5 V 91.5 c 0,-1.2 -7.2,-5.7 -8.5,-6.6 -2.5,-1.7 -7.5,-3.7 -11.6,-3.7 h -8.5 c -3.9,0 -8.8,2.2 -11.4,3.7 -1.3,0.8 -8.5,5.4 -8.5,6.6 l 0,0 z M 109.4,80.3 h 4.2 v -3.7 c 0,-0.8 -1.7,-1.2 -2.4,-1.3 v -6.8 h 1.8 V 65.1 H 109.4 V 80.3 z M 86.7,68.6 h 2.2 v 6.1 c 0,0.8 -2.3,1.4 -3,1.5 v 4.2 h 5 V 65.1 h -4.2 v 3.5 z m 11.6,9.8 c 0,0.6 -0.6,0.8 -0.9,1.3 l 5.5,-0.1 -1.1,-0.8 V 77.1 c -0.7,0 -0.8,0.2 -1.5,0.2 H 99.8 c -0.8,0 -0.8,-0.2 -1.5,-0.2 l -0,1.3 0,0 z m 2.8,-6.1 c 0.1,0.7 0.2,0.8 0.2,1.6 0,0.5 -0.6,1.1 -1.1,1.1 -1,0 -1.5,-0.5 -1.5,-1.5 v -0.2 c 0,-0.5 0.6,-1.1 1.1,-1.1 h 0.2 c 0.6,0 0.6,0.1 1.1,0.2 z m -3.9,0.9 v 0.7 c 0,1.2 1.6,2.4 2.6,2.4 1.4,0 3,-1 3,-2.4 V 72.7 c 0,-1 -1.6,-2 -2.8,-2 -1.4,0 -2.8,1 -2.8,2.4 z"}],i["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"M 100,67.3 C 90.1122,72.1037 79.3336,77.3992 70,82 c -1.2,0.6 -3.8,1.3 -3.8,2.8 l -0.1,0 0,0.4 c 0,0.6 0.1,0.6 0.2,1.1 0.5,0.1 0.5,0.2 1.1,0.2 l 65,0 c 0.7,0 1.7,-0.6 1.7,-1.1 0,-2.2 -1.7,-2.4 -3.2,-3 C 119.391,76.7575 109.17,71.7941 100,67.3 Z m -0.1,3.4 c 0.2,0 24.5,12 25.9,13 l -51.6,0 0,-0.1 C 75,83 99.7,70.7 99.9,70.7 Z m 31.6,55.6 0,-3 -63.3,0 0,3 z m 2.3,6.4 0,-3 -67.7,0 0,3 z m -6.2,-40.7 2.4,0 0,-3.2 -7.9,0 0,3.2 2.1,0 -0.6,25.5 -1.5,0 0,3.8 7.9,0 0,-3.8 -1.5,0 z m -14.6,-3.2 -7.6,0 0,3.2 2.2,0 -0.9,25.4 -1.3,0 0,3.8 7.6,0 0,-3.8 -1.4,0 -0.7,-25.5 2.1,0 z m -20.8,3.1 2.3,0 0,-3.2 -7.8,0 0,3.2 2.3,0 -0.8,25.4 -1.5,0 0,3.8 7.8,0 0,-3.8 -1.7,0 z m -22.5,25.5 0,3.8 8,0 0,-3.8 -1.5,0 -0.8,-25.5 2.3,0 0,-3.2 -8,0 0,3.2 2.4,0 -0.9,25.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 74.1,83.6 h 51.6 C 124.3,82.7 100,70.7 99.8,70.7 99.6,70.7 74.9,83 74.1,83.6 l 0,0 z"}],i["GR.IN.IC.MILITARY INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 65.2,93.1 c 0,-0.5 15.6,-11.5 17.3,-12.8 1.5,-1.2 17.3,-12.6 17.4,-12.6 0.6,0 15.9,11.2 17.6,12.5 1.7,1.3 17.3,12.4 17.3,12.9 0,0 -6.1,18.6 -6.7,20.3 -1.2,3.4 -2.2,6.8 -3.4,10.3 -1,3 -2.7,7.2 -3.3,10 H 78.4 c -0.1,-1.7 -5.6,-18 -6.5,-20.4 -0.6,-1.4 -6.6,-20.1 -6.6,-20.1 z m 8.4,38.5 2,6.1 49,0 8.4,-26.4 6.6,-20.5 -39.7,-28.7 -39.6,28.8 13.3,40.6 0,0 z M 100,76.2 c 2.7,2.4 26.6,18.7 26.6,19.6 0,0.8 -4.1,12.7 -4.5,13.4 l -5.6,17.4 -32.5,0 c -0.9,0 -3,-7.4 -3.5,-8.7 -0.6,-1.8 -2.9,-7.8 -2.9,-9.4 L 74.3,98.9 73.5,95.5 100,76.2 z m 30.5,18 c -3.1,-2.1 -30,-22.2 -30.7,-22.2 -0.1,0 -13.8,10.1 -15.2,11.1 -2,1.4 -14.3,10.7 -15.2,10.9 v 0.7 c 0,1 2.9,7 2.9,9.3 l 8.7,26.3 37.7,0 5,-15.7 6.6,-20.4 z m -50.4,3.2 c 0.8,-0.2 8.6,-6.1 10,-7 1.2,-0.8 9.5,-7.1 10,-7.1 0,0 9,6.5 10,7.2 1.2,0.8 9.7,6.5 9.7,7.3 0,1.2 -0.4,2 -0.9,2.7 0,1.6 -2.6,8.7 -3.3,10.6 -0.5,1.4 -2.8,10.1 -3.7,10.1 H 88.1 c -0.7,0 -1.8,-4 -2,-4.8 -0.6,-1.7 -1.2,-3.3 -1.7,-5.1 -0.6,-2.1 -3.1,-8.7 -3.1,-10.3 l -0.3,0.1 -0.9,-3.7 z m -3.2,-0.7 8.8,27 28.2,-0 8.7,-27.2 c -3.2,-1.7 -21.7,-16.3 -22.9,-16.3 -0.3,0 -20.6,15 -22.9,16.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 77,96.8 c 2.3,-1.5 22.6,-16.6 22.9,-16.6 1.2,0 19.7,14.6 22.9,16.3 l -8.7,27.2 -28.3,0 -8.8,-27 z m -3.6,-1.3 0.9,3.4 3.4,9.7 c 0,1.5 2.3,7.6 2.9,9.4 0.4,1.3 2.5,8.7 3.5,8.7 l 32.5,-0 5.5,-17.4 c 0.4,-0.6 4.5,-12.6 4.5,-13.4 0,-1 -23.9,-17.2 -26.6,-19.6 L 73.5,95.5 z m 6.7,2 0.9,3.7 0.3,-0.1 c 0,1.6 2.4,8.2 3.1,10.3 0.5,1.8 1.1,3.4 1.7,5.1 0.2,0.8 1.3,4.8 2,4.8 h 23.8 c 1,0 3.3,-8.6 3.7,-10.1 0.6,-1.9 3.3,-9 3.3,-10.6 0.5,-0.7 1,-1.5 1,-2.7 0,-0.8 -8.5,-6.5 -9.7,-7.3 -1,-0.7 -9.9,-7.2 -10,-7.2 -0.5,0 -8.8,6.2 -10,7 -1.3,1 -9.2,6.8 -10,7.1 z m 43.8,17.1 -5,15.7 -37.7,-0 -8.7,-26.3 c 0,-2.3 -2.9,-8.3 -2.9,-9.3 v -0.7 c 1,-0.2 13.2,-9.5 15.2,-10.9 1.4,-1 15.1,-11.1 15.2,-11.1 0.7,0 27.6,20 30.7,22.2 l -6.6,20.4 z M 65.2,93.1 c 0,0 6,18.7 6.6,20.1 1,2.4 6.4,18.7 6.5,20.4 h 43.1 c 0.6,-2.8 2.3,-7 3.3,-10 1.2,-3.5 2.1,-6.8 3.4,-10.3 0.6,-1.7 6.7,-20.2 6.7,-20.3 0,-0.5 -15.6,-11.5 -17.3,-12.9 C 115.8,79 100.5,67.7 99.9,67.7 99.8,67.7 84.1,79.2 82.5,80.3 80.8,81.6 65.2,92.7 65.2,93.1 z"}],i["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"M 64.3,86.6 99.9,102.1 135.7,86.6 v 31.8 H 64.3 v -31.8 l 0,0 z m 62.5,1.9 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18,7.7 -0.5,0 -15.8,-7 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.8 v -3.2 h 71.5 v 3.2 c -2.1,0.4 -6.6,2.9 -9,3.9 z m -64.1,31.7 h 74.7 V 79.8 H 62.7 v 40.4 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 64.3,86.6 0,31.8 71.5,0 0,-31.8 -35.8,15.5 z m 0,-2 c 2,0.5 6.5,3 8.8,3.8 2.9,1.1 5.8,2.7 8.8,3.9 2,0.8 17.3,7.8 17.8,7.8 0.9,0 15.9,-6.8 18,-7.7 3.1,-1.3 5.9,-2.6 9,-3.9 2.4,-1 6.9,-3.4 9,-3.9 V 81.4 H 64.3 v 3.2 l 0,0 z"}],i["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]=[{type:"path",stroke:!1,d:"M 64.3,94.6 99.9,110.1 135.7,94.6 V 126.4 H 64.3 l 4e-4,-31.8 0,0 z m 62.5,1.9 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18.1,7.7 -0.5,0 -15.7,-6.9 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.9 v -3.2 h 71.5 v 3.2 c -2.1,0.5 -6.6,2.9 -9,3.9 z M 62.7,128.2 h 74.7 V 87.8 H 62.7 v 40.5 z m 66.1,-54.4 -5.4,0 0,13.3 -2,0 0,-13.3 -5.4,0 0,-1.8 12.8,0 0,1.8 m -14,9 c -1e-5,0.6 -0.1,1.2 -0.4,1.7 -0.3,0.6 -0.7,1.1 -1.1,1.5 -0.5,0.4 -1.2,0.8 -1.9,1 -0.7,0.2 -1.6,0.4 -2.6,0.4 -1.1,0 -2.1,-0.1 -2.9,-0.3 -0.9,-0.2 -1.8,-0.5 -2.7,-0.9 l 0,-2.5 0.1,0 c 0.8,0.6 1.6,1.1 2.7,1.5 1,0.3 1.9,0.5 2.8,0.5 1.2,10e-7 2.2,-0.2 2.9,-0.7 0.7,-0.5 1,-1.1 1,-1.9 -1e-5,-0.7 -0.2,-1.2 -0.5,-1.5 -0.3,-0.3 -0.8,-0.6 -1.5,-0.7 -0.5,-0.1 -1.1,-0.2 -1.7,-0.3 -0.6,-0.1 -1.2,-0.2 -1.9,-0.3 -1.3,-0.3 -2.3,-0.8 -3,-1.5 -0.6,-0.7 -1,-1.6 -1,-2.7 0,-1.3 0.5,-2.3 1.6,-3.1 1.1,-0.8 2.4,-1.2 4.1,-1.2 1.1,1.6e-5 2,0.1 2.9,0.3 0.9,0.2 1.7,0.5 2.4,0.8 l 0,2.4 -0.1,0 c -0.6,-0.5 -1.3,-0.9 -2.3,-1.2 -0.9,-0.3 -1.9,-0.5 -2.9,-0.5 -1.1,1.3e-5 -1.9,0.2 -2.6,0.7 -0.7,0.4 -1,1 -1,1.7 -1e-5,0.6 0.2,1.1 0.5,1.5 0.3,0.4 0.9,0.6 1.7,0.8 0.4,0.1 1,0.2 1.8,0.3 0.8,0.1 1.5,0.3 2,0.4 1.1,0.3 2,0.7 2.5,1.4 0.6,0.6 0.9,1.4 0.9,2.5 m -14.4,4.3 -6,0 0,-1.5 2,0 0,-12 -2,0 0,-1.5 6,0 0,1.5 -2,0 0,12 2,0 0,1.5 m -8.6,-7.5 c -1.5e-5,1.4 -0.3,2.6 -0.9,3.7 -0.6,1.1 -1.4,2 -2.4,2.6 -0.7,0.4 -1.5,0.7 -2.3,0.9 -0.8,0.2 -2,0.3 -3.4,0.3 l -3.8,0 0,-15.1 3.8,0 c 1.5,1.5e-5 2.6,0.1 3.5,0.3 0.9,0.2 1.6,0.5 2.2,0.9 1,0.6 1.8,1.5 2.4,2.6 0.6,1.1 0.9,2.3 0.9,3.8 m -2.1,-0 c -1.2e-5,-1.2 -0.2,-2.2 -0.6,-3 -0.4,-0.8 -1,-1.5 -1.8,-1.9 -0.6,-0.3 -1.2,-0.6 -1.9,-0.7 -0.7,-0.1 -1.5,-0.2 -2.4,-0.2 l -1.9,0 0,11.7 1.9,0 c 1,2e-6 1.8,-0.1 2.5,-0.2 0.7,-0.1 1.4,-0.4 2,-0.8 0.8,-0.5 1.3,-1.1 1.7,-1.9 0.4,-0.8 0.6,-1.8 0.6,-2.9"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 126.8,96.5 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18.1,7.7 -0.5,0 -15.7,-6.9 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.9 v -3.2 h 71.5 v 3.2 c -2.1,0.5 -6.6,2.9 -9,3.9 z m -62.5,-1.9 35.6,15.5 35.8,-15.5 V 126.4 H 64.3 l 4e-4,-31.8 0,0 z"}],i["GR.IN.IC.POST OFFICE"]=[{type:"path",stroke:!1,d:"m 74.7,92.8 24.9,10.8 L 124.7,92.8 V 115.1 H 74.7 V 92.8 l 0,0 z m 43.7,1.3 c -2.2,0.9 -4.1,1.8 -6.3,2.7 -1.5,0.6 -12,5.4 -12.6,5.4 -0.4,0 -11,-4.9 -12.5,-5.4 -2.1,-0.8 -4.1,-1.9 -6.2,-2.7 -1.6,-0.6 -4.8,-2.4 -6.2,-2.7 v -2.2 h 50 v 2.3 c -1.5,0.3 -4.6,2 -6.3,2.7 z M 73.6,116.4 H 125.8 V 88.1 H 73.6 V 116.4 z M 99.8,64.3 c 0.2,0 35.5,19.8 37.1,21.2 h -4.8 v 38.6 h -63.9 v -38.6 h -4.9 c 1.6,-1.4 6.9,-4.1 9.1,-5.3 3.1,-1.8 6,-3.4 9.1,-5.3 1.6,-1 18.3,-10.6 18.4,-10.6 z m -43.3,23.1 9.9,-0.2 v 38.4 h 67.4 v -38.4 l 9.9,0.2 c -0.5,-0.6 -43.6,-25 -43.9,-25 -0,0 -19.5,11.4 -21.7,12.5 -3.5,1.8 -7.4,4.2 -10.9,6.2 -2.7,1.6 -8.8,4.6 -10.8,6.3 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"M 99.8,64.3 C 99.8,64.3 83.1,73.9 81.5,74.9 c -3,1.8 -6,3.5 -9.1,5.3 -2.2,1.2 -7.5,4 -9.1,5.3 l 4.9,0 0,38.6 63.9,0 0,-38.7 4.8,0 c -1.6,-1.4 -36.9,-21.2 -37.1,-21.2 z M 73.6,88.1 l 52.3,0 0,28.3 -52.3,0 0,-28.3 z m 44.9,6.1 c -2.2,0.9 -4.1,1.8 -6.3,2.7 -1.5,0.6 -12,5.4 -12.6,5.4 -0.4,0 -11,-4.9 -12.5,-5.4 -2.1,-0.8 -4.1,-1.9 -6.2,-2.7 -1.6,-0.6 -4.8,-2.4 -6.2,-2.7 v -2.2 h 50 v 2.3 c -1.5,0.3 -4.6,2 -6.3,2.7 z M 74.7,92.8 99.6,103.7 124.7,92.8 V 115.1 H 74.7 V 92.8 l 0,0 z"}],i["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]=[{type:"path",stroke:!1,d:"m 114.9,121.3 0,-1.2 -30.7,0 0,1.2 z m -31.9,-2.5 -10.4,-16.7 -1,0.4 10.6,16.6 z m 13,-13.8 h 7 c 0.6,0 4.4,-6 5,-6.8 H 91 c 0.6,0.9 4.4,6.8 5,6.8 z m 15.3,12 0,-1 -23.5,0 0,1 z m 2.4,-1.6 8.6,-13.6 -0.8,-0.4 -8.5,13.3 z M 76.8,101.9 c 0,0.3 3.7,5.9 4.2,6.7 0.4,0.6 4.2,6.7 4.3,6.7 0.4,0 0.5,-0.2 0.7,-0.5 l -8.5,-13.4 c -0.2,0.1 -0.7,0.2 -0.7,0.5 z m 31,10.8 0,-1 -16.5,0 0,1 z m -19.3,-1.2 0.7,-0.4 -6.7,-10.5 -0.7,0.4 z m 22.3,-0 6.4,-10.5 -0.8,-0.3 -6.6,10.5 z m -6.4,-3 0,-1 -9.7,0 0,1 z m 2.8,-1.8 c 0,0.6 0.3,0.6 0.7,0.6 l 4.2,-6.9 -0.6,-0.4 c -0.2,0.2 -4.3,6.6 -4.3,6.7 z m -20.3,-6.3 4.1,7 c 0.3,-0.1 0.8,-0.2 0.8,-0.5 0,-0.6 -3.7,-5.6 -4,-6.9 l -1,0.4 z m -19.7,18 0.3,-2.8 c 0.1,-3.9 2,-11.4 3,-14.6 1.6,-4.7 3.2,-8.3 5.6,-12 4.4,-6.5 12,-12.4 22.8,-12.4 h 1.1 c 9.6,0 17,4.8 21.3,10.2 1.2,1.5 2.3,2.8 3.2,4.6 0.5,0.9 1,1.6 1.4,2.6 0.4,0.9 0.7,1.9 1.1,2.7 0.8,1.4 3.6,10.3 3.6,12.1 v 0.6 h 0.3 v 1 l 1.2,10.8 -0.1,2.2 H 67 l 0.2,-5 0,0 z m -2.3,-4 -0.3,2.4 -0.4,5.6 v 3.8 h 70.9 v -1 c 0,-2 0.1,-6.4 -0.2,-8.1 -0.4,-2.4 -0.5,-5.2 -1,-7.5 -0.4,-2 -2.9,-12.7 -3.9,-13.1 0,-1.6 -3.5,-7.6 -4.3,-8.8 -1.8,-2.6 -3.8,-5 -6.2,-7 -4.9,-3.9 -10.5,-7 -19.3,-7 h -1 c -11.8,0 -19.6,5.9 -24.6,12.8 -1.4,1.9 -2.4,3.8 -3.5,5.9 -1.2,2.3 -1.7,4.2 -2.6,6.7 -1.2,3 -3.4,11.4 -3.5,15.3 l 0,0 z m 52.2,4.7 c 0.4,-1.3 4.2,-6.6 5.2,-8.3 0.6,-1 5.1,-7.9 5.1,-8.2 0,-0.3 -0.6,-0.4 -0.8,-0.5 l -10.6,16.6 1.1,0.4 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 84.2,120.1 h 30.7 v 1.2 H 84.2 v -1.2 z m 3.6,-4.2 h 23.5 v 1 H 87.8 v -1 z m 3.5,-4.2 h 16.5 v 1 H 91.4 v -1 z m 3.3,-4.2 h 9.7 v 1 h -9.7 v -1 z m 22.4,11.5 -1.1,-0.4 10.6,-16.6 c 0.3,0.1 0.8,0.2 0.8,0.5 0,0.3 -4.6,7.2 -5.1,8.2 -1,1.8 -4.9,7 -5.2,8.3 z m -45.4,-16.6 1,-0.4 10.4,16.7 -0.8,0.4 -10.6,-16.6 z m 13.7,12.8 c -0.2,0 -4,-6 -4.3,-6.7 -0.5,-0.8 -4.2,-6.3 -4.2,-6.6 0,-0.3 0.4,-0.4 0.7,-0.5 l 8.5,13.3 c -0.2,0.3 -0.2,0.5 -0.7,0.5 z m 36.2,-13.8 0.8,0.4 -8.6,13.6 -0.8,-0.6 8.6,-13.4 z m -5.1,-0.6 0.8,0.3 -6.4,10.5 -1,-0.3 6.6,-10.5 z m -33.9,-0 6.7,10.5 -0.7,0.4 -6.7,-10.5 0.7,-0.4 z m 24.7,6 c 0,-0.1 4.1,-6.5 4.3,-6.7 l 0.6,0.4 -4.2,6.9 c -0.4,0 -0.7,-0.1 -0.7,-0.6 z m -19.4,-6.7 c 0.3,1.3 4,6.3 4,6.9 0,0.3 -0.6,0.4 -0.8,0.5 l -4.1,-7 1,-0.4 z m 8.2,4.9 c -0.6,0 -4.4,-6 -5,-6.8 h 17 c -0.6,0.8 -4.4,6.8 -5,6.8 h -7 z m -28.5,10.7 c 0,0.5 -0,2.8 -0.3,2.8 l -0.2,5 h 65.2 l 0.1,-2.2 -1.2,-10.8 v -1 h -0.3 v -0.6 c 0,-1.8 -2.8,-10.6 -3.6,-12.1 -0.4,-0.8 -0.7,-1.8 -1.1,-2.7 -0.5,-1 -1,-1.6 -1.5,-2.6 -0.9,-1.8 -2,-3.1 -3.2,-4.6 -4.2,-5.4 -11.6,-10.2 -21.3,-10.2 h -1 c -10.8,0 -18.5,5.8 -22.8,12.4 -2.5,3.8 -4.1,7.4 -5.7,12 -1.1,3.2 -3,10.7 -3,14.6 l 0,0 z"}],i["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]=[{type:"path",stroke:!1,d:"m 122.4,117.1 0,-1.5 -45.1,0 0,1.5 z M 74.5,114 75.6,113.4 59.8,88.8 58.8,89.4 z m 49.6,-0.6 c 0.2,0.1 1,0.5 1.3,0.5 0.2,0 14.4,-22.4 15.9,-24.6 l -1.5,-0.5 -15.7,24.6 z m -6.6,-2.6 0,-1.7 -35,0 0,1.7 z m 2.4,-3.2 c 0,0.2 1,0.8 1.1,0.9 l 12.8,-20 h 0.2 l -1.6,-0.8 c -1.3,2.4 -12.6,19.3 -12.6,20 z m -41.1,0.9 1.4,-0.8 -12.7,-20.1 -1.3,0.8 z m 33.3,-3.9 0,-1.6 -24.4,0 0,1.6 z m 3.4,-2.8 c 0,0.6 0.6,0.7 1.1,0.9 l 9.6,-15.4 -1.2,-0.6 c -0.6,2 -9.4,14.5 -9.4,15.2 z m -32.2,1 1.4,-0.6 -9.7,-15.5 -1.3,0.8 z m 23.4,-4.5 0,-1.7 -13.8,0 0,1.7 z m 5.6,-1.7 6.4,-10.3 -1.2,-0.5 -6.6,10.2 z m -24.6,0.1 1.1,-0.8 -6.5,-10.2 -1.3,0.6 z m 6.6,-4 11,0.1 c 0.6,0 6.4,-8.9 7,-10 H 87.3 l 6.9,9.9 z"}],i["GR.IN.IC.RELIGIOUS INSTITUTION"]=[{type:"path",stroke:!1,d:"m 101.2,68.1 c 7.9,0 18,3.8 21.7,8 5,5.7 7,12.3 7,22.8 V 131.9 H 101.2 V 68.1 z M 70.1,96.3 c 0,-8.4 3.4,-16.4 7.7,-20.7 3.9,-3.9 13.2,-7.5 20.9,-7.5 v 63.9 H 70.1 V 96.3 z m -2.6,38.3 h 65 V 99.3 c 0,-10.8 -2.5,-19.7 -8.1,-25.2 -4.8,-4.8 -15,-8.7 -24.6,-8.7 -8.3,0 -19.4,3.7 -23.6,7.9 -3.2,3.3 -4.3,5 -6.2,9.5 -1,2.4 -2.5,10 -2.5,13.2 v 38.5 l 0,0 z M 105.1,97.6 v 12.5 c 0,0.5 0.6,1.1 1.1,1.1 h 0.4 c 0.7,0 1.1,-0.8 1.1,-1.5 V 97.8 c 0,-0.5 -0.6,-1.1 -1.1,-1.1 H 106 c -0.5,0 -0.9,0.4 -0.9,0.9 z m -11.2,13.6 c 0.8,0 0.9,-1 0.9,-1.7 V 97.6 c 0,-0.5 -0.4,-0.9 -0.9,-0.9 h -0.6 c -0.5,0 -0.9,0.4 -0.9,0.9 v 12.5 c 0,0.5 0.6,1.1 1.1,1.1 h 0.4 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 105.1,97.6 c 0,-0.5 0.4,-0.9 0.9,-0.9 h 0.7 c 0.5,0 1.1,0.6 1.1,1.1 v 11.8 c 0,0.7 -0.4,1.5 -1.1,1.5 h -0.5 c -0.5,0 -1.1,-0.6 -1.1,-1.1 V 97.6 h 0 z m -3.9,34.4 h 28.7 V 98.9 c 0,-10.5 -2,-17.1 -7,-22.8 C 119.2,71.9 109.1,68.1 101.2,68.1 v 63.9 z M 94,111.2 H 93.5 c -0.5,0 -1.1,-0.6 -1.1,-1.1 V 97.6 c 0,-0.5 0.4,-0.9 0.9,-0.9 h 0.7 c 0.5,0 0.9,0.4 0.9,0.9 v 11.8 c 0,0.8 -0.1,1.8 -0.9,1.8 z M 70.1,96.3 v 35.7 H 98.8 V 68.1 c -7.7,0 -17,3.6 -20.9,7.5 -4.3,4.3 -7.7,12.3 -7.7,20.7 z"}],i["GR.IN.IC.CHILD DAY CARE"]=[{type:"path",stroke:!1,d:"m 76.6,100.3 c 0,1.8 1.1,3.4 3,3.4 h 0.6 c 1.4,0 2.4,-1.5 2.4,-3 0,-4.3 -6,-4.2 -6,-0.4 z m 26.5,-11.9 v 0.4 c 0,1.5 1.4,3.2 2.8,3.2 h 0.4 c 1.6,0 3,-1.2 3,-2.8 V 87.8 c 0,-1 -1.6,-2 -2.8,-2 h -0.2 c -1.5,-0 -3.2,1.4 -3.2,2.6 z m -3.2,-16.8 35.4,21.7 c -1.3,0.2 -4.6,-0.3 -4.6,0.9 v 34.9 H 69.3 V 94.1 c 0,-1.2 -3.3,-0.8 -4.6,-0.9 l 35.2,-21.7 0,0 z m -39.8,22.4 c 0.2,0.8 0.3,1.3 1.3,1.3 h 6.2 v 34.6 c 0,0.5 0.1,0.5 0.2,0.9 h 64 c 0.4,0 0.8,-0.3 0.8,-0.8 V 95.2 h 6 c 0.8,0 1.3,-0.4 1.3,-1.1 0,-0.6 -17.8,-11.2 -19.8,-12.5 -1.6,-1 -20,-12.3 -20,-12.3 -0.2,0 -36.7,22.5 -40,24.7 l 0,0 z m 20.9,14.2 5.9,4.3 -0.1,0.1 -4.8,2.2 c -0.2,-0.8 -1,-1.9 -1,-2.5 v -4.1 z m 28.4,-8.8 c 0.5,-0.8 0.6,-2.9 1,-3.1 0.4,-0.2 2.4,0.8 2.9,0.9 v 3.6 l -4.4,1.7 v -0.6 c -0,-0.9 0.5,-1 0.5,-2.4 z m -3,2 c 0,0.9 0,1.1 -0.4,1.7 V 104 c -2.4,0.2 -15.4,7.5 -17,7.5 -0.5,0 -6.5,-6.7 -7.3,-6.7 h -4.3 c -0.5,0 -2.8,5.2 -2.8,5.6 v 4.7 c 0,0.9 1.8,1.4 2,2.4 l -4.1,1.7 1.3,2.6 6.2,-2.8 c 1.5,0.8 9.3,5.6 10.5,5.6 h 0.6 c 0.8,0 1.9,-0.8 1.9,-1.5 v -0.4 c 0,-0.9 -7.3,-4.8 -8.4,-5.8 l 14,-6.3 v 8.4 h -3 v 6.7 h 8.4 v -6.7 h -2.8 v -9.9 l 13.2,-5.8 c 0,1.6 0.2,3.7 0.4,5.1 0.2,1.8 -0.6,3.9 1.5,3.9 2.1,0 1.3,-2.5 1.3,-4.3 0,-1.9 -0.2,-3.5 -0.2,-5.6 v -0.6 l 9.1,-4 -1,-2.9 -6.2,2.8 c 0.3,-0.6 0.7,-0.8 1,-1.4 0.2,-0.7 0.4,-1.2 0.7,-1.8 0.5,-1 0.9,-2.6 1.4,-3.4 l -11.4,-1.6 c -0.6,0.5 -3.2,3.3 -3.2,4.2 v 0.6 h -0.4 l -1.1,7.1 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 81,112.2 c 0,0.6 0.8,1.7 1,2.5 l 4.8,-2.2 0.2,-0.1 -6,-4.3 v 4.1 z m 28.4,-12.9 c 0,1.4 -0.6,1.6 -0.6,2.4 v 0.6 l 4.5,-1.7 v -3.6 c -0.5,-0.1 -2.6,-1 -2.9,-0.9 -0.4,0.2 -0.5,2.4 -1,3.1 z m -32.9,0.9 c 0,-3.9 6,-4 6,0.4 0,1.4 -1.1,3 -2.4,3 h -0.5 c -1.8,0 -3,-1.6 -3,-3.4 z m 29.5,2.8 0.4,-1.7 1.1,-7.1 h 0.4 v -0.6 c 0,-0.8 2.6,-3.7 3.2,-4.2 l 11.4,1.6 c -0.5,0.8 -0.9,2.4 -1.4,3.4 -0.3,0.6 -0.4,1.1 -0.7,1.8 -0.3,0.7 -0.7,0.8 -1,1.4 l 6.2,-2.8 1,2.9 -9.1,4 v 0.6 c 0,2.1 0.2,3.7 0.2,5.6 0,1.8 0.8,4.3 -1.3,4.3 -2.1,0 -1.3,-2.2 -1.5,-3.9 -0.2,-1.4 -0.4,-3.5 -0.4,-5.1 l -13.2,5.8 v 9.9 h 2.8 v 6.7 h -8.4 v -6.7 h 3 v -8.4 l -14,6.3 c 1.1,0.9 8.4,4.9 8.4,5.8 v 0.4 c 0,0.7 -1,1.5 -1.9,1.5 H 90.6 c -1.2,0 -8.9,-4.8 -10.5,-5.6 l -6.2,2.8 -1.3,-2.6 4.1,-1.7 c -0.3,-1 -2,-1.5 -2,-2.4 v -4.6 c 0,-0.4 2.3,-5.6 2.8,-5.6 h 4.3 c 0.8,0 6.8,6.7 7.3,6.7 1.5,0 14.6,-7.3 17,-7.5 v -0.9 z m -3,-14.8 c 0,-1.2 1.7,-2.6 3.2,-2.6 h 0.2 c 1.2,0 2.8,1.1 2.8,2 v 1.3 c 0,1.6 -1.4,2.8 -3,2.8 h -0.4 c -1.4,0 -2.8,-1.7 -2.8,-3.2 v -0.4 z m -38.4,4.9 c 1.3,0.1 4.6,-0.3 4.6,0.8 v 34.9 h 61.4 V 94.1 c 0,-1.2 3.3,-0.8 4.6,-0.9 l -35.4,-21.7 -35.2,21.8 0,0 z"}],i["GR.IN.IC.HELICOPTER LANDING SITE"]=[{type:"path",stroke:o,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:o,fill:!!R&&G,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"},{type:"circle",fill:!1,cx:100,cy:100,r:40}],i["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE LOCK"]=[{type:"path",fill:!1,d:"m 70,70 65,30 -65,30"}],i["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE SHIP ANCHORAGE"]=[{type:"path",fill:!1,stroke:"rgb(255, 0, 255)",d:"m 73.6,112.8 c 0.8,8 26.4,11.2 26.4,11.2 0,0 25.6,-3.2 26.4,-11.2 M 80,88 l 40,0 m -20,-12 0,48"}],i["GR.IN.IC.NATURAL GAS FACILITY"]=[{type:"path",fill:!1,d:"m 100,60.5 c -16.4,0 -29.6,13.2 -29.6,29.6 0,12.8 8.3,23.9 19.7,27.8 l 0,19.7 c 3.2,1.2 6.3,1.8 9.9,1.8 3.6,0 6.7,-0.6 9.9,-1.8 l 0,-19.8 c 11.5,-3.9 19.8,-15 19.7,-27.8 0,-16.4 -13.2,-29.6 -29.6,-29.6 z"},{type:"text",stroke:!1,x:100,y:103,fontsize:35,text:"NG"}],i["GR.IN.IC.TOLL FACILITY"]=[{type:"path",stroke:!1,d:"m 69.1,112.3 c 0,-0.7 0.8,-1.7 1.4,-1.7 h 0.5 c 0.8,0 1.5,0.8 1.5,1.5 v 1.2 c 0,0.5 -0.9,1.2 -1.5,1.2 h -0.2 c -0.8,0 -1.7,-0.8 -1.7,-1.4 v -0.9 l 0,0 z m -1.1,0.5 v 0.3 c 0,1.2 1.5,2.6 2.9,2.6 1.3,0 2.8,-1.5 2.8,-2.5 v -1 c 0,-1.2 -1.4,-2.6 -2.8,-2.6 -1.7,0 -2.9,1.6 -2.9,3.2 z m 27.6,-11.6 -2,-2.8 -2.3,0 4.3,2.8 z m -29.5,17.8 c 0,-0.5 0.8,-0.9 1.4,-0.9 H 99.1 c 0.8,0 1.3,0.6 1.4,1.4 -0.6,0.1 -1,0.3 -1.7,0.3 H 68 c -0.6,0 -1.8,0 -1.8,-0.6 v -0.2 z m 9.4,-10.2 15.1,0 8.2,0.2 c 0.5,0.9 2,3 1.8,4.3 l -0.2,2.6 c -0.5,0.2 -0.5,0.3 -1,0.3 H 67.1 c -0.6,0 -0.5,-0.2 -1.1,-0.3 -0.1,-0.7 -0.3,-1 -0.3,-1.8 v -0.6 c 0,-1.1 1.5,-3.5 2,-4.4 l 7.8,-0.2 z m -5.8,-2 c 0.1,-1.1 3.5,-7.1 4.3,-7.1 h 18.4 c 1,0 4,5.8 4.3,7.1 H 69.7 z m 21.7,-8.4 2.3,-0 2,2.8 -4.3,-2.8 z m 44.3,27.8 V 73.8 c -1,0.2 -10.3,6 -11.9,7 -1.3,0.8 -11.6,6.5 -11.6,7.2 0,0 1.3,2.1 1.4,2.3 l 4.9,-2.8 v 19.2 l -0.4,0.3 c -2.9,-2 -33.4,-22 -33.6,-22 -0.1,0 -3.9,5.6 -4,6.2 l 10.8,7 -18.3,0 c -0.9,1.4 -1.9,2.4 -2.8,3.8 -0.2,0.3 -2,4.4 -2,4.6 v 0.8 h -1.2 c -0.1,0.9 -2.6,4.6 -2.6,5.4 v 0.8 c 0,1.5 0.4,2.9 1.4,3.4 -0.2,0.3 -1,1.1 -1,1.6 v 0.9 c 0,1.1 1.5,1.5 2.6,1.5 v 2.3 l 0.2,2 c 0.5,0.2 0.3,0.5 1.2,0.6 0.6,0.1 1,0.2 1.7,0.2 h 1.1 l 1.7,-0.2 0.3,-0.3 0.2,-2 0,-2.5 h 19.1 v 3.1 c 0,0.8 0.3,1.2 0.6,1.7 l 1.4,0.2 1.2,-0 c 1.7,0 3.1,-0.1 3.1,-1.8 v -3.1 c 0.8,-0.2 2.6,-0.5 2.6,-1.4 v -1.7 c 0,-0.5 -0.5,-0.7 -0.9,-0.8 0.1,-0.5 1.2,-1.1 1.2,-2.5 v -2 c 0,-1.5 -2.1,-4.1 -2.5,-5.4 h -1.2 v -0.4 c 0,-1.1 -2.2,-4.8 -2.5,-5.8 l 19,12.5 c -0.4,1.6 -2,4 -2,5.2 v 7.2 h 22.9 l 0,0 z M 95.9,114.6 H 95.7 c -1.1,0 -1.8,-0.7 -1.8,-1.7 v -0.5 c 0,-1 0.6,-1.8 1.5,-1.8 h 0.5 c 1,0 1.5,1.1 1.5,2 0,1.1 -0.5,2 -1.5,2 z m -3.1,-2.5 v 1.1 c 0,1 1.6,2.5 2.9,2.5 1.4,0 2.6,-1.3 2.6,-2.8 v -0.8 c 0,-1.2 -1.3,-2.6 -2.5,-2.6 H 95.7 c -1.4,0 -2.9,1.4 -2.9,2.6 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 114.5,107.9 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m -11.2,-7.2 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m -5.5,-3.7 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 108.9,104.5 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 92.3,93.5 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 86.5,89.8 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m 35.6,2.6 10.8,0 0,16.1 -10.8,0 z m -55.9,26.4 v 0.2 c 0,0.6 1.2,0.6 1.8,0.6 h 30.8 c 0.7,0 1.1,-0.2 1.7,-0.3 -0.1,-0.8 -0.6,-1.4 -1.4,-1.4 H 67.5 c -0.5,0 -1.4,0.4 -1.4,0.9 z m 26.6,-6.8 c 0,-1.2 1.5,-2.6 2.9,-2.6 h 0.2 c 1.2,0 2.5,1.4 2.5,2.6 v 0.8 c 0,1.4 -1.2,2.8 -2.6,2.8 -1.4,0 -2.9,-1.4 -2.9,-2.5 v -1 h -0 z m -24.8,0.6 c 0,-1.6 1.2,-3.2 2.9,-3.2 1.3,0 2.8,1.5 2.8,2.6 v 1.1 c 0,0.9 -1.4,2.5 -2.8,2.5 -1.4,0 -2.9,-1.4 -2.9,-2.6 v -0.3 z m -0.3,-3.8 c -0.5,1 -2,3.4 -2,4.4 v 0.6 c 0,0.9 0.2,1.1 0.3,1.8 0.5,0.1 0.5,0.3 1.1,0.3 h 32.3 c 0.6,0 0.5,-0.2 1,-0.3 l 0.2,-2.6 c 0.1,-1.2 -1.4,-3.4 -1.8,-4.3 l -8.2,-0.2 -15.1,-0 -7.8,0.2 z m 2,-2.2 h 27.1 c -0.4,-1.3 -3.3,-7.1 -4.3,-7.1 H 74 c -0.8,0 -4.2,6 -4.3,7.1 z m 26.2,7.8 c 1.1,0 1.5,-0.9 1.5,-2 0,-0.9 -0.6,-2 -1.5,-2 h -0.5 c -1,0 -1.5,0.8 -1.5,1.8 v 0.5 c 0,1 0.8,1.7 1.8,1.7 h 0.2 l 0,0 z M 69.1,112.3 v 0.9 c 0,0.6 1,1.4 1.7,1.4 h 0.2 c 0.6,0 1.5,-0.8 1.5,-1.2 v -1.2 c 0,-0.8 -0.8,-1.5 -1.5,-1.5 h -0.5 c -0.6,0 -1.4,1 -1.4,1.7 z"}],i["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]=[{type:"path",stroke:!1,d:"m 121.4,81.7 h 1.1 v 0.6 c 0,0.6 0.8,2.1 1.2,2.4 0.5,0.4 1.9,0.9 2.7,0.9 2.6,0 3.9,-1.9 3.9,-4.5 v -0.5 h -7.4 c -0.5,0 -1.2,0.8 -1.4,1.1 z m -22.6,23.5 c 0,-1.7 1.7,-3 3.4,-3 1.7,0 3.1,1.4 3.1,3.1 v 0.6 c 0,1.3 -1.7,2.6 -3.1,2.6 -1.7,0 -3.4,-1.3 -3.4,-3 v -0.5 z m -29.7,0 c 0,-1.8 1.3,-3 3.1,-3 1.7,0 3.3,1.4 3.3,3.1 v 0.3 c 0,1.6 -1.6,3 -3.4,3 -1.5,0 -3,-1.2 -3,-2.6 v -0.8 z m 3.7,-7 c 0,-0.4 1.6,-4.2 1.9,-5 0.6,-1.7 0.9,-3.6 3.3,-3.6 H 96.5 c 2.8,0 2.2,1.8 3.2,3.6 0.2,0.4 1.8,4.5 1.8,4.9 H 72.8 z m -3.7,1 c -2.1,0 -3.7,1.5 -3.7,3.6 v 9.2 c 0,1 1.7,2.3 3.1,2.3 v 5.3 c 0,1.8 1.3,3.3 3.3,3.3 1.4,0 3.1,-1.6 3.1,-2.6 v -5.9 h 24.8 v 6.2 c 0,1 1.7,2.3 3,2.3 h 0.2 c 1.4,0 3.1,-1.3 3.1,-2.6 v -5.9 c 1.9,0 3.3,-1.4 3.3,-3.3 v -8.1 c 0,-2 -1.4,-3.3 -3.2,-3.7 -1.4,-0.2 -1.1,-0.8 -1.6,-1.9 -0.4,-0.8 -0.7,-1.6 -1,-2.4 -1.2,-2.6 -2.2,-8.2 -5.6,-8.2 h -21.2 c -2.9,0 -3.5,3.3 -4.5,5.5 -0.6,1.4 -2.7,5.8 -3,7 z m 56.5,20.2 0.3,-3.3 0.5,-6.2 h 1.7 l 0.8,12.9 h 5.8 V 88.9 c 0,-0.6 -1.2,-1.9 -2,-1.9 l -0.6,0.1 -9.9,14.6 h 8.4 v 3.6 h -11.2 v 17.6 h 6.1 l -0,-0.8 0.2,-2.6 z m -16.8,-30.8 c 0.2,-0.9 1,-1.5 2,-1.6 v 2.2 h -2 c 0,1.4 0.8,2.2 2.2,2.2 v -2 h 2 c -0,1.3 -0.8,1.4 -1.4,2 h 7.8 l 0,10.2 10,-14.3 -10.1,-0.2 h -6.4 v -7.6 c 0,-1.2 -0.8,-2.2 -1.9,-2.2 h -0.4 c -2.2,0 -2,2.4 -2,4.7 0,1.3 -0.4,5.8 0.2,6.6 z m 0,0 v 0.6 h 2 v -2.2 c -1.1,0 -1.8,0.7 -2,1.6 z m 2.2,2.8 h 0.6 c 0.6,-0.6 1.4,-0.7 1.4,-2 h -2 v 2 z m 19.3,-12 0,-2 -8.8,-0 1,2 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 130.3,79.4 -7.9,-0 0.4,1.3 7.5,0 z m -8.1,22.2 9.9,-14.6 0.6,-0.1 -3.1,0.2 -10,14.3 -0.1,3.7 11.2,0 0,-3.6 z m -23.3,3.6 v 0.5 c 0,1.7 1.7,3 3.4,3 1.4,0 3.1,-1.4 3.1,-2.6 v -0.6 c 0,-1.7 -1.4,-3.1 -3.1,-3.1 -1.8,0 -3.4,1.3 -3.4,3 z m -29.7,0 v 0.8 c 0,1.4 1.5,2.6 3,2.6 1.8,0 3.4,-1.3 3.4,-3 v -0.3 c 0,-1.6 -1.6,-3.1 -3.3,-3.1 -1.8,0 -3.1,1.2 -3.1,3 z m 3.7,-7 h 28.6 c 0,-0.5 -1.5,-4.5 -1.8,-4.9 -1,-1.8 -0.4,-3.6 -3.2,-3.6 H 77.9 c -2.4,0 -2.6,1.9 -3.3,3.6 -0.2,0.8 -1.8,4.6 -1.8,5 z"}],i["GR.IN.IC.TUNNEL"]=[{type:"path",stroke:!1,d:"m 94.4,116.8 c 0,-3.5 2.6,-7.2 5.9,-7.2 3.2,0 5.6,4 5.6,7.1 v 0.8 H 94.4 v -0.7 z m 27.2,-4.7 9,-4.2 c 0.2,1.7 0.8,3.2 1,5.2 0.3,1.8 0.6,3.3 0.6,5.6 v 0.5 h -10 l -0.7,-7.1 z m -43.5,4.9 0.1,2.2 H 68 c 0,-1.6 0.3,-3.8 0.6,-5.4 0.1,-0.7 0.2,-1.8 0.5,-2.4 0.1,-0.2 0.7,-2.2 0.7,-2.4 l 9.2,3.1 -0.8,4.9 z m 39,-16.8 6.2,-6.2 c 0.6,1 1.2,1.8 1.9,2.8 0.8,1.1 1.2,2 1.8,3.1 0.6,1 2.8,5.6 2.8,6.9 l -8.7,4.2 c -0.1,-2.5 -3,-9 -4,-10.6 z m -37.9,10.4 -9.1,-3 c 0.1,-1.2 2.4,-5.9 3,-7 1.2,-2.1 3,-4.2 4,-6 l 7.6,4.4 c -0.2,0.5 -2.6,4.3 -3,5.4 -0.8,1.7 -1.6,4.9 -2.4,6.2 z M 111.2,83.2 c 2.8,0.7 9.8,7.1 11.3,9.4 l -6.3,6.2 c -0.5,-1.8 -6,-6.9 -8.2,-7.4 l 3.2,-8.2 z M 78.1,93.4 C 79.7,91 88,83.8 91,83.1 L 94.9,91 c -2.6,0.6 -7.9,5 -9.2,6.9 l -7.6,-4.5 z M 92.6,82.4 c 2.6,-0.6 4.1,-1.8 7.8,-1.8 h 1.4 c 4,0 5.3,1.2 8.1,1.8 -0,1 -1.9,5.2 -2.3,6.3 -0.6,1.4 -0.4,2 -2.2,1.5 -1.1,-0.3 -2.4,-0.6 -3.6,-0.6 h -1 L 96.1,90.3 92.6,82.4 z M 66.5,119.8 H 60.4 c -0.4,0 -0.5,0.1 -0.5,0.5 v 0.2 c 0,0.4 0.1,0.5 0.5,0.5 h 79 c 0.3,0 0.7,-0.3 0.7,-0.5 0,-0.4 -0.3,-0.7 -0.7,-0.7 h -5.7 v -1.5 c 0,-10.1 -4.9,-20.4 -9.5,-25.9 C 119.8,87 111.6,79 102.2,79 h -2 c -9.7,0 -18.8,8.4 -23.6,13.7 -5,5.6 -10.1,16.6 -10.1,27.1 l 0,0 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 79,112 -9.3,-3.1 c -0,0.2 -0.6,2.2 -0.7,2.4 -0.2,0.6 -0.4,1.7 -0.5,2.4 -0.2,1.5 -0.5,3.8 -0.5,5.4 h 10.3 l -0.1,-2.2 0.8,-4.9 z m 15.5,5.4 h 11.4 v -0.8 c 0,-3.1 -2.4,-7.1 -5.6,-7.1 -3.3,0 -5.9,3.8 -5.9,7.2 v 0.7 z m 27.9,1.7 h 10 v -0.5 c 0,-2.3 -0.4,-3.8 -0.6,-5.6 -0.3,-2 -0.9,-3.5 -1,-5.2 l -9,4.2 0.7,7.1 z m -5.2,-19 c 1.1,1.6 4,8.1 4,10.6 l 8.7,-4.2 c 0,-1.2 -2.1,-5.8 -2.8,-6.8 -0.7,-1.1 -1.1,-2 -1.8,-3.1 -0.7,-1 -1.3,-1.8 -1.9,-2.8 l -6.2,6.2 z m -37.9,10.4 c 0.7,-1.4 1.6,-4.5 2.4,-6.2 0.5,-1.1 2.9,-4.9 3,-5.4 l -7.6,-4.4 c -1,1.8 -2.8,4 -4,6 -0.6,1.1 -2.9,5.8 -3,7 l 9.1,3 z m 28.8,-19.1 c 2.1,0.5 7.6,5.6 8.2,7.4 l 6.3,-6.1 c -1.5,-2.3 -8.5,-8.8 -11.3,-9.5 l -3.2,8.2 z m -30,2 7.6,4.6 C 87,96 92.3,91.6 94.9,91 l -3.8,-7.9 c -3.1,0.7 -11.4,7.9 -13,10.3 z M 92.6,82.4 l 3.5,7.9 4.6,-0.6 h 1 c 1.3,0 2.6,0.3 3.6,0.6 1.7,0.4 1.6,-0.1 2.2,-1.5 0.4,-1.1 2.3,-5.3 2.3,-6.3 -2.8,-0.6 -4,-1.9 -8.1,-1.9 h -1.4 c -3.6,0 -5.2,1.3 -7.7,1.9 z"}],i["GR.IN.IC.PUMPING STATION"]=[{type:"path",stroke:!1,d:"m 83.2,83.8 0,1.2 0,5.6 -11.3,0 0,-0 c -0.2,0 -0.3,0 -0.5,0 -0.1,6.6e-4 -0.1,-9.6e-4 -0.2,0 -2.7,0 -4.9,0.3 -6.5,1.7 -1.4,1.2 -2,3.3 -2.1,5.9 l -0.1,0 0,1.2 c 8e-6,0.1 -0,0.2 -0,0.3 l 0,0 0,14.1 -2.8,0 0,2.4 80.8,0 0,-2.4 -2.8,0 0,-14 0,-1.6 -0.1,0 c -0.1,-2.6 -0.5,-4.6 -1.8,-5.9 -1.5,-1.4 -3.8,-1.7 -6.8,-1.7 l 0,-0 -0.3,0 c -0.2,-5.6e-4 -0.3,-0 -0.4,-0 l 0,0 -11.3,0 0,-5.6 0,-1.2 -1.2,0 -31.2,0 -1.2,0 z m 2.4,2.4 28.8,0 0,27.2 -28.8,0 0,-27.2 z M 71.2,93 c 0.1,-0 0.1,0 0.2,0 l 11.8,0 0,8.4 -7.5,0 c -0.8,-0.1 -1.4,-0.1 -2,-0 -0,0 -0,0 -0.1,0 -0,0 -0,-0 -0,0 l 0,0 c -0.5,0.1 -1.2,0.3 -1.5,0.8 -0.4,0.5 -0.4,1.1 -0.4,1.6 -0,0.4 -0,0.8 0,1.2 l -0,0 0,8.8 -6.8,0 0,-14.5 c 0,-3 0.5,-4.5 1.4,-5.3 C 67.1,93.3 68.7,93.1 71.2,93 z m 45.6,0 11.8,0 c 0.1,9.7e-4 0.1,-0 0.2,0 2.8,0.1 4.5,0.4 5.2,1.1 0.8,0.7 1.2,2.3 1.2,5.2 l 0,14.5 -6.8,0 0,-8 0,0 c -0,-0.1 -0,-0.3 -0,-0.4 0,-0.9 0.2,-1.6 -0.1,-2.5 -0.1,-0.5 -0.6,-1.2 -1.2,-1.4 -0.2,-0.1 -0.5,-0 -0.7,-0 l 0,-0.1 -9.6,0 0,-8.4 z M 74,103.8 l 9.2,0 0,10 -9.2,0 0,-8.5 0,0 c 0,-0.6 -0,-1.1 -0,-1.4 0,-0.1 -0,-0 0,-0.1 z m 42.8,0 9.2,0 c 0,0.2 0,0.8 0,1.6 l -0,0 0,8.4 -9.2,0 0,-10 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 116.8,93 11.8,0 c 0.1,9.7e-4 0.1,-0 0.2,0 2.8,0.1 4.5,0.4 5.2,1.1 0.8,0.7 1.2,2.3 1.2,5.2 l 0,14.5 -6.8,0 0,-8 0,0 c -0,-0.1 -0,-0.3 -0,-0.4 0,-0.9 0.2,-1.6 -0.1,-2.5 -0.1,-0.5 -0.6,-1.2 -1.2,-1.4 -0.2,-0.1 -0.5,-0 -0.7,-0 l 0,-0.1 -9.6,0 0,-8.4 z m -45.6,0 c 0.1,-0 0.1,0 0.2,0 l 11.8,0 0,8.4 -7.5,0 c -0.8,-0.1 -1.4,-0.1 -2,-0 -0,0 -0,0 -0.1,0 -0,0 -0,-0 -0,0 l 0,0 c -0.5,0.1 -1.2,0.3 -1.5,0.8 -0.4,0.5 -0.4,1.1 -0.4,1.6 -0,0.4 -0,0.8 0,1.2 l -0,0 0,8.8 -6.8,0 0,-14.5 c 0,-3 0.5,-4.5 1.4,-5.3 C 67.1,93.3 68.7,93.1 71.2,93 z m 14.4,-6.8 28.8,0 0,27.2 -28.8,0 0,-27.2 z"}],i["GR.IN.IC.RESERVOIR"]=[{type:"path",stroke:!1,d:"M 127.3 69.1 C 127 69.1 126.7 69.2 126.4 69.2 C 123.4 69.5 120.8 71.9 118.4 74.5 C 115.9 77 113.5 79.7 111.5 80.9 C 108.9 82.4 105.5 82.5 101.9 82.6 C 98.3 82.7 94.7 82.9 91.8 84.9 C 89.7 86.5 88.6 88.5 87.5 90.3 C 86.4 92 85.2 93.4 82.7 94.2 C 79.4 95.3 72 96.4 66.9 98.8 C 64.3 100.1 62.1 101.7 61.5 104 C 60.8 106.3 61.7 109.1 64.7 112.3 L 65.1 111.9 L 65.1 120.1 L 84.3 120.1 L 84.3 129.7 L 86.7 129.7 L 86.7 120.1 L 97.9 120.1 L 97.9 129.7 L 100.3 129.7 L 100.3 120.1 L 117.1 120.1 L 117.1 112.5 C 117.4 112.2 117.7 111.9 118 111.5 C 119 110.1 119.3 108.5 119.5 106.9 C 119.8 103.7 119.5 100.5 121.7 97.7 C 123.1 95.9 126 95.4 129.1 94.7 C 132.1 94.1 135.4 93.3 137.2 90.4 C 139.4 86.7 139.1 81.3 137.2 76.8 C 136.3 74.5 134.9 72.5 133 71.1 C 131.4 69.9 129.5 69.1 127.3 69.1 z M 127.4 70.7 C 129.2 70.7 130.7 71.3 132.1 72.3 C 133.6 73.5 134.9 75.4 135.8 77.4 C 137.5 81.5 137.6 86.6 135.8 89.6 C 134.5 91.8 131.7 92.5 128.7 93.2 C 125.7 93.8 122.4 94.3 120.5 96.7 C 117.8 100 118.2 103.7 117.9 106.7 C 117.8 108.2 117.5 109.5 116.7 110.6 C 116.5 110.8 116.3 111.1 116.1 111.3 L 65.8 111.3 L 65.9 111.3 C 63.1 108.2 62.6 106.1 63 104.4 C 63.5 102.8 65.2 101.4 67.6 100.3 C 72.3 98 79.5 96.9 83.1 95.8 C 86.1 94.8 87.7 92.9 88.8 91.1 C 90 89.3 90.9 87.5 92.8 86.2 C 95.1 84.5 98.4 84.3 102 84.2 C 105.5 84.1 109.2 84.1 112.3 82.3 C 114.7 80.8 117.1 78.1 119.5 75.6 C 121.9 73.1 124.4 71 126.6 70.8 C 126.9 70.8 127.1 70.7 127.4 70.7 z "},{type:"path",stroke:!1,fill:!!R&&G,d:"m 127.4,70.7 c 1.8,-0 3.3,0.6 4.7,1.6 1.5,1.2 2.8,3 3.7,5.1 1.7,4.1 1.9,9.2 0.1,12.2 -1.3,2.2 -4.1,3 -7.1,3.6 -3,0.6 -6.3,1.1 -8.3,3.5 -2.6,3.3 -2.3,7.1 -2.6,10 -0.1,1.5 -0.4,2.8 -1.2,3.8 -0.2,0.2 -0.4,0.5 -0.6,0.7 l -50.2,0 0,-0 c -2.8,-3 -3.3,-5.2 -2.8,-6.8 0.5,-1.6 2.1,-3 4.5,-4.2 4.8,-2.3 11.9,-3.4 15.6,-4.5 3,-1 4.5,-2.8 5.7,-4.6 1.2,-1.8 2.1,-3.6 3.9,-4.9 2.3,-1.7 5.7,-1.9 9.2,-2 3.5,-0.1 7.3,-0.1 10.3,-1.9 2.5,-1.4 4.8,-4.2 7.2,-6.7 2.4,-2.5 4.9,-4.6 7.1,-4.8 0.3,-0 0.5,-0.1 0.8,-0.1 z m -41.9,49 13.6,0 0,10 -13.6,0 z"}],i["GR.IN.IC.STORAGE TOWER"]=[{type:"path",stroke:!1,d:"m 118.3,121 0.4,5.3 0.7,12.8 h 2.9 c 0,-6.1 -1.1,-12.6 -1.1,-18.6 0,-3.4 -0.4,-6.2 -0.4,-9.6 -0.1,-5.3 0.2,-3 2.6,-6.6 l -0.3,-3.1 0,-1.1 h -4.2 V 84 c -2.5,0.6 -5.2,1.8 -8.3,2.6 -2.6,0.6 -6.4,1.4 -9.4,1.4 h -2.4 c -7.6,0 -12.2,-2.6 -18,-4 v 16.2 h -4.2 v 0.7 l -0.3,3.7 3.2,3.7 -2,30.8 h 3.1 v -3.3 l 1.4,-21.7 c 0.5,0.4 2.1,2.7 3,3.6 0.9,0.9 2.4,2.2 3.5,2.9 2.2,1.5 5.6,3.8 8.7,4.1 v 14.4 h 5.6 v -14.4 c 3.7,-0.9 6.2,-2.2 8.8,-4.3 1.4,-1.1 2.2,-1.8 3.4,-3 0.7,-0.7 2.5,-3.2 3,-3.4 v 3.1 l 0.2,3.8 z M 99.7,85.2 c 7.4,0 23,-4.4 25.7,-8.4 -2.8,-1.5 -25.1,-16 -25.3,-16 -0.4,0 -24.9,15.4 -25.5,16.2 2.6,3.5 16.6,8.2 23.3,8.2 h 1.8 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 97.9,85.2 c -4.3,0 -11.7,-2 -17,-4.3 l -0,3.2 c 5.8,1.4 10.4,4 18,4 h 2.4 c 3,0 6.9,-0.8 9.4,-1.4 3,-0.8 5.8,-2 8.3,-2.6 V 80.8 c -6,2.4 -14.4,4.4 -19.3,4.4 H 97.9 z"}],i["GR.IN.IC.SURFACE WATER INTAKE"]=[{type:"path",stroke:!1,d:"M 63.4 75.5 L 63.4 76.3 L 63.4 90.7 L 63.4 91.5 L 64.2 91.5 L 75.7 91.5 C 76.5 96.6 79.8 99.1 83.3 101 C 87.1 102.9 91.3 104.3 93.8 107.5 C 94.8 108.9 94.9 110.7 95.2 112.6 C 95.4 113.6 95.6 114.5 96.2 115.4 C 96.7 116.2 97.5 117 98.8 117.5 C 101.2 118.6 108.7 120.7 115.9 122.4 C 119.6 123.2 123.1 123.9 126 124.3 C 127.5 124.4 128.7 124.5 129.8 124.5 C 130.8 124.4 131.6 124.3 132.2 123.8 C 134.8 121.7 136.1 119.9 136.5 118.3 C 136.8 116.8 136.1 115.4 135 114.4 C 133.9 113.4 132.4 112.5 131 111.7 C 129.7 110.8 128.4 109.9 127.7 108.8 C 124.2 103.6 121 95.5 113.4 91.5 L 119 91.5 L 119.8 91.5 L 119.8 90.7 L 119.8 76.3 L 119.8 75.5 L 119 75.5 L 64.2 75.5 L 63.4 75.5 z M 65 77.1 L 118.2 77.1 L 118.2 89.9 L 109.4 89.9 L 109.4 81.1 L 73.8 81.1 L 73.8 89.9 L 65 89.9 L 65 77.1 z M 76.9 91.5 L 110.5 91.5 C 119.4 94.8 122.7 103.5 126.7 109.5 C 127.6 110.8 129 111.8 130.4 112.7 C 131.8 113.6 133.2 114.4 134.2 115.3 C 135.1 116.2 135.6 117 135.3 118.1 C 135.1 119.2 134 120.8 131.4 122.9 C 131.3 123 130.6 123.2 129.7 123.3 C 128.8 123.3 127.6 123.3 126.2 123.1 C 123.3 122.8 119.8 122.1 116.2 121.3 C 109 119.6 101.5 117.3 99.3 116.4 C 98.2 116 97.6 115.4 97.2 114.8 C 96.8 114.1 96.6 113.3 96.4 112.4 C 96.1 110.6 96 108.5 94.7 106.8 C 91.9 103.2 87.6 101.8 83.9 99.9 C 80.5 98.1 77.7 96.1 76.9 91.5 z "},{type:"path",stroke:!1,fill:!!R&&G,d:"m 76.9,91.5 33.6,0 c 8.9,3.3 12.2,12 16.2,18 0.9,1.3 2.3,2.3 3.7,3.2 1.4,0.9 2.8,1.7 3.8,2.6 0.9,0.9 1.4,1.7 1.2,2.8 -0.2,1.1 -1.3,2.7 -3.9,4.8 -0.2,0.1 -0.8,0.3 -1.7,0.4 -0.9,0 -2.2,-0 -3.6,-0.2 -2.8,-0.3 -6.4,-1 -10,-1.8 -7.2,-1.7 -14.7,-3.9 -16.9,-4.8 -1.1,-0.4 -1.6,-1 -2.1,-1.7 -0.4,-0.7 -0.6,-1.5 -0.8,-2.3 -0.3,-1.8 -0.4,-3.9 -1.7,-5.6 -2.8,-3.6 -7.1,-5 -10.8,-6.9 C 80.5,98.1 77.7,96.1 76.9,91.5 z m -11.9,-14.4 53.2,0 0,12.8 -8.8,0 0,-8.8 -35.6,0 0,8.8 -8.8,0 0,-12.8 z"}],i["GR.IN.IC.WAREHOUSE/STORAGE FACILITY"]=[{type:"text",stroke:!1,x:100,y:113,fontsize:23,text:"STOR"}],i["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]=[{type:"path",stroke:!1,d:"m 107.2,114.8 c 1.9,0 3.9,-1 4.3,-2.4 1.5,1 1.7,2.4 4.6,2.4 h 0.4 c 1.8,0 3.8,-1.1 4.1,-2.4 h 0.4 c 0.4,1.4 2.5,2.4 4.5,2.4 h 0.4 c 2.7,0 3,-1.5 4.5,-2.4 0.4,1.4 2.6,2.4 4.5,2.4 v -1.5 c -2.2,0 -3.5,-1.6 -3.9,-3.4 h -1.5 c -0,1.8 -1.7,3.4 -3.6,3.4 h -0.4 c -2.2,0 -3.6,-1.4 -3.8,-3.4 h -1.7 l -0.2,1.3 c -1,0.7 -1.1,2 -3.3,2 h -0.4 c -3.3,0 -3.2,-3.4 -4.1,-3.4 h -1.3 c -0.2,2 -1.4,3.4 -3.6,3.4 v 1.5 z m -2.2,-33.3 h 32 v 37 h -32 V 81.5 z M 65.1,114.8 v -1.5 c 2,0 3.7,-1.6 3.8,-3.4 h 1.9 c 0,1.8 1.5,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 2.2,0 3.2,-1.6 3.6,-3.4 h 1.7 c 0,2 1.7,3.4 3.8,3.4 v 1.5 c -2,0 -4.1,-1 -4.5,-2.4 -1.4,0.9 -1.7,2.5 -4.6,2.5 h -0.6 c -2.9,0 -3.1,-1.5 -4.5,-2.4 -0.4,1.3 -2.4,2.4 -4.1,2.4 H 74.1 c -2.4,0 -3.4,-1.2 -4.5,-2.4 -0.4,1.4 -2.6,2.4 -4.5,2.4 l 0,0 z M 96.5,93.4 h 6.7 v 13.3 H 96.5 V 93.4 z m -31.4,7.9 c 2,0 3.6,-1.5 3.8,-3.4 h 1.9 c 0.2,1.8 1.4,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.7 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 1.5,0 3.4,-1.5 3.4,-2.6 v -0.8 h 1.9 c 0,1.9 1.8,3.4 3.8,3.4 v 1.5 c -3.6,0 -3.8,-2 -4.9,-2.2 -0.4,1.3 -2.5,2.2 -4.2,2.2 h -0.6 c -1.7,0 -3.8,-1 -4.1,-2.2 -1,0.3 -1.4,2.2 -4.5,2.2 H 74.1 c -2.7,0 -3,-1.3 -4.5,-2.2 -1,1.4 -2.2,2.2 -4.5,2.2 v -1.5 l 0,0 z m 0,-12 c 2,0 3.6,-1.5 3.8,-3.4 h 1.9 c 0.1,1.8 1.4,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.7 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 1.5,0 3.4,-1.5 3.4,-2.6 v -0.8 h 1.9 c 0,1.9 1.8,3.4 3.8,3.4 v 1.5 c -3.1,0 -3,-1 -4.7,-2 -1.4,1 -1.7,2.1 -4.4,2.1 h -0.6 c -2.7,0 -2.9,-1.1 -4.3,-2 -1.6,1 -1.6,2 -4.5,2 H 73.9 c -2.4,0 -2.9,-1.2 -4.1,-2 -1.6,1 -1.7,2 -4.7,2 v -1.5 l 0,0 z m 31.4,21.3 h 6.7 v 10.1 h 35.6 V 79.4 L 103.3,79.2 V 89.5 H 96.5 V 79.4 L 61.2,79.2 v 41.6 h 35.4 v -10.1 z m 14.2,-12.2 c 0,1.4 -1.8,2.8 -3.6,2.8 v 1.5 c 3.4,0 3.5,-1.9 4.7,-2.2 0.4,1.3 2.7,2.2 4.5,2.2 h 0.2 c 2.9,0 3,-1.3 4.3,-2.2 1.2,0.9 1.7,2.2 4.3,2.2 h 0.8 c 2.6,0 3,-1.3 4.3,-2.2 1.4,1 1.5,2.2 4.6,2.2 v -1.5 c -1.7,0 -3.8,-1.6 -3.8,-2.8 v -0.6 h -1.7 c -0.1,1.8 -1.6,3.4 -3.6,3.4 h -0.6 c -1.4,0 -3.4,-1.4 -3.4,-2.4 v -0.9 h -1.9 c 0,1.7 -1.7,3.4 -3.5,3.4 h -0.4 c -1.9,0 -3.5,-1.5 -3.6,-3.4 h -1.8 v 0.6 z m 0,-12 c 0,1.4 -1.8,2.8 -3.6,2.8 v 1.5 c 1.8,0 4,-0.9 4.3,-2.2 1.6,1.1 1.7,2.2 4.9,2.2 h 0.4 c 2.6,0 2.9,-1.3 4.3,-2.2 0.3,1.3 2.4,2.3 4.1,2.3 h 0.8 c 2.7,0 3,-1.3 4.5,-2.2 0.4,1.3 2.7,2.2 4.5,2.2 v -1.5 c -1.7,0 -3.8,-1.6 -3.8,-2.8 v -0.6 h -1.7 c -0.1,1.8 -1.6,3.4 -3.6,3.4 h -0.6 c -1.6,0 -3.4,-1.4 -3.4,-2.8 v -0.6 h -1.9 c 0,1.7 -1.7,3.4 -3.5,3.4 h -0.4 c -1.9,0 -3.5,-1.5 -3.6,-3.4 h -1.8 v 0.5 z"},{type:"path",stroke:!1,fill:!!R&&G,d:"m 65.1,114.8 c 1.9,0 4.1,-1 4.5,-2.4 1.1,1.2 2.2,2.4 4.5,2.4 h 0.6 c 1.8,0 3.8,-1.1 4.1,-2.4 1.4,1 1.6,2.4 4.5,2.4 h 0.6 c 2.8,0 3.2,-1.6 4.5,-2.4 0.4,1.4 2.5,2.4 4.5,2.4 v -1.5 c -2.1,0 -3.7,-1.4 -3.8,-3.4 h -1.6 c -0.4,1.8 -1.4,3.4 -3.6,3.4 h -0.2 c -2.1,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.8 -1.7,3.4 -3.6,3.4 H 74.1 c -1.8,0 -3.3,-1.6 -3.4,-3.4 h -1.9 c -0,1.8 -1.8,3.4 -3.8,3.4 v 1.5 l 0,0 z m 0,-13.5 v 1.5 c 2.3,0 3.6,-0.9 4.5,-2.2 1.4,1 1.8,2.2 4.5,2.2 h 0.6 c 3.1,0 3.5,-2 4.5,-2.2 0.4,1.3 2.4,2.2 4.1,2.2 h 0.6 c 1.7,0 3.8,-1 4.1,-2.2 1.1,0.3 1.2,2.2 4.9,2.2 v -1.5 c -2,0 -3.8,-1.4 -3.8,-3.4 h -1.9 v 0.8 c 0,1.2 -1.9,2.6 -3.4,2.6 h -0.2 c -2,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.6 -1.7,3.4 -3.6,3.4 H 74.1 c -2,0 -3.2,-1.5 -3.4,-3.4 h -1.9 c -0.2,1.8 -1.7,3.4 -3.8,3.4 l 0,0 z m 0,-12 v 1.5 c 3,0 3.1,-1 4.7,-2 1.2,0.9 1.7,2 4.1,2 h 0.6 c 2.9,0 2.9,-1 4.5,-2 1.4,0.9 1.6,2 4.3,2 h 0.6 c 2.7,0 2.9,-1.1 4.3,-2 1.6,1.1 1.6,2 4.7,2 v -1.5 c -2,0 -3.8,-1.4 -3.8,-3.4 h -1.9 v 0.8 c 0,1.2 -1.9,2.6 -3.4,2.6 h -0.2 c -2,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.7 -1.7,3.4 -3.6,3.4 H 74.1 c -2,0 -3.2,-1.5 -3.4,-3.4 h -1.9 c -0.2,1.8 -1.7,3.4 -3.8,3.4 l 0,0 z m 42.1,25.4 v -1.5 c 2.2,0 3.4,-1.4 3.6,-3.4 h 1.3 c 1,0 0.8,3.4 4.1,3.4 h 0.4 c 2.2,0 2.4,-1.4 3.3,-2.1 l 0.2,-1.3 h 1.7 c 0.2,2 1.6,3.4 3.8,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.5 c 0.4,1.8 1.7,3.4 3.9,3.4 v 1.5 c -1.9,0 -4.1,-1 -4.5,-2.4 -1.5,1 -1.8,2.5 -4.5,2.5 h -0.4 c -2,0 -4.1,-1 -4.5,-2.4 h -0.4 c -0.4,1.3 -2.3,2.4 -4.1,2.4 h -0.4 c -2.9,0 -3.1,-1.4 -4.7,-2.4 -0.4,1.4 -2.4,2.4 -4.3,2.4 z m 3.6,-16.8 h 1.9 c 0,1.8 1.6,3.4 3.5,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 v 0.9 c 0,1 2,2.4 3.4,2.4 h 0.6 c 1.9,0 3.4,-1.6 3.6,-3.4 h 1.7 v 0.6 c 0,1.2 2,2.8 3.8,2.8 v 1.5 c -3.1,0 -3.2,-1.2 -4.7,-2.2 -1.3,0.9 -1.7,2.2 -4.4,2.2 h -0.7 c -2.6,0 -3,-1.3 -4.3,-2.2 -1.3,1 -1.4,2.2 -4.3,2.2 h -0.2 c -1.8,0 -4.2,-1 -4.5,-2.2 -1.2,0.3 -1.2,2.2 -4.7,2.2 v -1.5 c 1.8,0 3.6,-1.4 3.6,-2.8 v -0.6 l 0,0 z m 0,-12 h 1.9 c 0,1.9 1.6,3.4 3.5,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 v 0.6 c 0,1.4 1.8,2.8 3.4,2.8 h 0.6 c 1.9,0 3.4,-1.6 3.6,-3.4 h 1.7 v 0.6 c 0,1.2 2,2.8 3.8,2.8 v 1.5 c -1.8,0 -4.2,-1 -4.5,-2.2 -1.5,1 -1.8,2.2 -4.6,2.2 h -0.7 c -1.7,0 -3.8,-1 -4.1,-2.2 -1.4,0.9 -1.7,2.2 -4.3,2.2 h -0.4 c -3.1,0 -3.2,-1.2 -4.9,-2.2 -0.4,1.3 -2.5,2.2 -4.3,2.2 v -1.5 c 1.8,0 3.6,-1.4 3.6,-2.8 v -0.6 z m -5.8,32.6 h 32 V 81.5 h -32 v 37 z m -1.7,-11.8 0,-13.3 -6.8,0 0,13.3 z"}],i["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE.TRAFFIC CONTROL POINT"]=[{type:"path",stroke:!1,d:"m 85.5,81.3 0.5,0.7 13.7,18.2 0.3,0.5 0.3,-0.5 13.7,-18.2 0.5,-0.7 -0.9,0 -27.4,0 -0.9,0 z m 1.7,0.9 25.7,0 L 100,99.3 87.2,82.2 z M 106.7,50.7 c 0,0.2 -0,0.5 -0.1,0.7 -0.1,0.2 -0.2,0.4 -0.4,0.5 -0.2,0.2 -0.4,0.3 -0.7,0.4 -0.3,0.1 -0.6,0.1 -1,0.1 l -0.7,0 0,2.1 -0.7,0 0,-5.6 1.5,0 c 0.3,5e-6 0.6,0 0.9,0.1 0.2,0.1 0.4,0.1 0.6,0.3 0.2,0.1 0.4,0.3 0.5,0.5 0.1,0.2 0.2,0.5 0.2,0.8 m -0.8,0 c -1e-5,-0.2 -0,-0.4 -0.1,-0.5 -0.1,-0.1 -0.2,-0.3 -0.3,-0.3 -0.1,-0.1 -0.3,-0.1 -0.4,-0.2 -0.2,-0 -0.3,-0.1 -0.6,-0.1 l -0.7,0 0,2.2 0.6,0 c 0.3,3e-6 0.5,-0 0.7,-0.1 0.2,-0.1 0.3,-0.1 0.5,-0.3 0.1,-0.1 0.2,-0.2 0.2,-0.4 0.1,-0.1 0.1,-0.3 0.1,-0.4 m -3.9,3.5 c -0.1,0.1 -0.3,0.1 -0.4,0.2 -0.1,0.1 -0.3,0.1 -0.4,0.2 -0.2,0 -0.3,0.1 -0.5,0.1 -0.2,0 -0.4,0.1 -0.6,0.1 -0.4,0 -0.8,-0.1 -1.1,-0.2 -0.3,-0.1 -0.6,-0.3 -0.9,-0.5 -0.2,-0.2 -0.4,-0.5 -0.6,-0.9 -0.1,-0.4 -0.2,-0.8 -0.2,-1.3 0,-0.5 0.1,-0.9 0.2,-1.2 0.1,-0.4 0.3,-0.7 0.6,-0.9 0.2,-0.2 0.5,-0.4 0.9,-0.6 0.3,-0.1 0.7,-0.2 1.1,-0.2 0.3,6e-6 0.6,0 0.9,0.1 0.3,0.1 0.6,0.2 1,0.4 l 0,0.9 -0.1,0 c -0.3,-0.3 -0.6,-0.4 -0.9,-0.6 -0.3,-0.1 -0.6,-0.2 -1,-0.2 -0.3,5e-6 -0.5,0 -0.8,0.1 -0.2,0.1 -0.4,0.2 -0.6,0.4 -0.2,0.2 -0.3,0.4 -0.4,0.7 -0.1,0.3 -0.1,0.6 -0.1,1 -10e-7,0.4 0.1,0.7 0.2,1 0.1,0.3 0.2,0.5 0.4,0.7 0.2,0.2 0.4,0.3 0.6,0.4 0.2,0.1 0.5,0.1 0.7,0.1 0.4,10e-7 0.7,-0.1 1,-0.2 0.3,-0.1 0.6,-0.3 0.9,-0.6 l 0.1,0 0,0.9 m -5.1,-4.5 -2,0 0,4.9 -0.7,0 0,-4.9 -2,0 0,-0.7 4.7,0 0,0.7 M 85.9,44.6 l 0,0.4 0,36.5 0,0.4 0.4,0 27.4,0 0.4,0 0,-0.4 0,-36.5 0,-0.4 -0.4,0 -27.4,0 -0.4,0 z m 0.9,0.9 26.5,0 0,35.6 -26.5,0 0,-35.6 z"}],i["AC.M1.RIOT"]=l("RIOT"),i["AC.M1.THREAT"]=l("?"),i["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]=l("ECEP"),i["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]=l("EICC"),i["AC.M1.EMERGENCY OPERATIONS CENTER"]=l("EOC"),i["AC.M1.EMERGENCY SHELTER"]=l("ES"),i["AC.M1.EMERGENCY STAGING AREA"]=l("SA"),i["AC.M1.EMERGENCY"]=l("EMER"),i["AC.M1.COMMERCIAL"]=l("COM"),i["AC.M1.PRODUCTION"]=l("PROD"),i["AC.M1.RETAIL"]=l("RTL"),i["AC.M1.MILITARY ARMORY"]=l("RES"),i["AC.M1.GENERATION STATION"]=l("GEN"),i["GR.I.FF.CIVILIAN ROTARY WING"]=[{type:"path",stroke:o,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:o,fill:!!R&&G,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"}],i["GR.IC.HOSPITAL SHIP"]=a("AH"),i["GR.IC.LAW ENFORCEMENT VESSEL"]=[{type:"path",fill:R?G:!C&&G,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],i["CY.IC.COMBAT MISSION TEAM"]=a("CMT"),i["CY.IC.NATIONAL MISSION TEAM"]=a("NMT"),i["CY.IC.CYBER PROTECTION TEAM"]=a("CPT"),i["CY.IC.NATION STATE CYBER THREAT ACTOR"]=a("CTA"),i["CY.IC.NON NATION STATE CYBER THREAT ACTOR"]=a("CTA"),i["CY.IC.NON NATION STATE CYBER THREAT ACTOR"].fill=R||N?G:!C&&G,i["CY.IC.NON NATION STATE CYBER THREAT ACTOR"].stroke=o,i["CY.IC.NON NATION STATE CYBER THREAT ACTOR"].strokewidth=3,i)i.hasOwnProperty(L)&&(I.hasOwnProperty(L)&&console.warn("Override of: "+L),n.call(this,i[L],O),I[L]=i[L])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G);var o={type:"letter",icons:function(I,t,E,R){I["S-G-------"]=[],I["S-G-U-----"]=[],I["S-G-UC----"]=[E["GR.IC.COMBAT"]],I["S-G-UCD---"]=[E["GR.IC.FF.AIR DEFENCE"]],I["S-G-UCDS--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE SHORT RANGE"]],I["S-G-UCDSC-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE CHAPARRAL"]],I["S-G-UCDSS-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE STINGER"]],I["S-G-UCDSV-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.FF.MAIN GUN SYSTEM"],E["GR.IC.AIR DEFENSE VULCAN"]],I["S-G-UCDM--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"]],I["S-G-UCDML-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.LIGHT"]],I["S-G-UCDMLA"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCDMM-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.MEDIUM"]],I["S-G-UCDMH-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.HEAVY"]],I["S-G-UCDH--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE H/MAD"]],I["S-G-UCDHH-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE H/MAD HAWK"]],I["S-G-UCDHP-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE H/MAD PATRIOT"]],I["S-G-UCDG--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE GUN UNIT"]],I["S-G-UCDC--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE COMPOSITE"]],I["S-G-UCDT--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE TARGETING UNIT"]],I["S-G-UCDO--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE THEATER MISSILE DEFENSE UNIT"]],I["S-G-UCA---"]=[E["GR.IC.ARMOUR"]],I["S-G-UCAT--"]=[E["GR.IC.ARMOUR"]],I["S-G-UCATA-"]=[E["GR.IC.ARMOUR"],E["GR.M2.AIRBORNE"]],I["S-G-UCATW-"]=[E["GR.IC.ARMOUR"],E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCATWR"]=[E["GR.IC.ARMOUR"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M2.RECOVERY (MAINTENANCE)"]],I["S-G-UCATL-"]=[E["GR.IC.ARMOUR"],E["GR.M2.LIGHT"]],I["S-G-UCATM-"]=[E["GR.IC.ARMOUR"],E["GR.M2.MEDIUM"]],I["S-G-UCATH-"]=[E["GR.IC.ARMOUR"],E["GR.M2.HEAVY"]],I["S-G-UCATR-"]=[E["GR.IC.ARMOUR"],E["GR.M2.RECOVERY (MAINTENANCE)"]],I["S-G-UCAW--"]=[E["GR.IC.ARMOR, WHEELED"]],I["S-G-UCAWS-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCAWA-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.AIRBORNE"]],I["S-G-UCAWW-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCAWWR"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M2.RECOVERY (MAINTENANCE)"]],I["S-G-UCAWL-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.LIGHT"]],I["S-G-UCAWM-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.MEDIUM"]],I["S-G-UCAWH-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.HEAVY"]],I["S-G-UCAWR-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.RECOVERY (MAINTENANCE)"]],I["S-G-UCAA--"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"]],I["S-G-UCAAD-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"]],I["S-G-UCAAL-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.LIGHT"]],I["S-G-UCAAM-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.AIRBORNE"]],I["S-G-UCAAS-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCAAU-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.MOUNTAIN"]],I["S-G-UCAAC-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.ARCTIC"]],I["S-G-UCAAA-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"]],I["S-G-UCAAAT"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"]],I["S-G-UCAAAW"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],I["S-G-UCAAAS"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCAAO-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCAAOS"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.FF.MOTORIZED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCV---"]=[E["GR.IC.AVIATION ROTARY WING"]],I["S-G-UCVF--"]=[E["GR.IC.AVIATION FIXED WING"]],I["S-G-UCVFU-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.UTILITY"]],I["S-G-UCVFA-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.ATTACK"]],I["S-G-UCVUTP"]=[E["GR.IC.AVIATION TACTICAL AIR CONTROL PARTY"]],I["S-G-UCVUFC"]=[E["GR.IC.AVIATION FORWARD AIR CONTROLLER"]],I["S-G-UCVFR-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.RECON"]],I["S-G-UCVR--"]=R?[E["GR.IC.AVIATION ROTARY WING"],E["GR.IC.AVIATION ROTARY WING 2525C"]]:[E["GR.IC.AVIATION ROTARY WING"]],I["S-G-UCVRA-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.ATTACK"]],I["S-G-UCVRS-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.RECON"]],I["S-G-UCVRW-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.ANTISUBMARINE WARFARE"]],I["S-G-UCVRU-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"]],I["S-G-UCVRUL"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.LIGHT"]],I["S-G-UCVRUM"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.MEDIUM"]],I["S-G-UCVRUH"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.HEAVY"]],I["S-G-UCVRUC"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.COMMAND AND CONTROL ROTARY WING"]],I["S-G-UCVRUE"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.MEDEVAC"]],I["S-G-UCVRM-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.MINE COUNTERMEASURE"]],I["S-G-UCVS--"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.PERSONNEL RECOVERY"]],I["S-G-UCVC--"]=[E["GR.IC.AVIATION COMPOSITE"]],I["S-G-UCVV--"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]],I["S-G-UCVU--"]=[E["GR.IC.UNMANNED SYSTEMS"]],I["S-G-UCVUF-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],I["S-G-UCVUR-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],I["S-G-UCI---"]=[E["GR.IC.FF.INFANTRY"]],I["S-G-UCIL--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.LIGHT"]],I["S-G-UCIM--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCIO--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.MOUNTAIN"]],I["S-G-UCIA--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.AIRBORNE"]],I["S-G-UCIS--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCIZ--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.ARMOUR"]],I["S-G-UCIN--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.NAVAL"]],I["S-G-UCII--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.ARMOUR"],E["GR.IC.FF.MAIN GUN SYSTEM"]],I["S-G-UCIC--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.ARCTIC"]],I["S-G-UCE---"]=[E["GR.IC.ENGINEER"]],I["S-G-UCEC--"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"]],I["S-G-UCECS-"]=[E["GR.IC.ENGINEER"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCECA-"]=[E["GR.IC.ENGINEER"],E["GR.M2.AIRBORNE"]],I["S-G-UCECC-"]=[E["GR.IC.ENGINEER"],E["GR.M2.ARCTIC"]],I["S-G-UCECL-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.LIGHT"]],I["S-G-UCECM-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.MEDIUM"]],I["S-G-UCECH-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.HEAVY"]],I["S-G-UCECT-"]=[s._scale(.7,E["GR.IC.ENGINEER"]),E["GR.IC.ARMOUR"]],I["S-G-UCECW-"]=[E["GR.IC.ENGINEER"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCECO-"]=[E["GR.IC.ENGINEER"],E["GR.M2.MOUNTAIN"]],I["S-G-UCECR-"]=[E["GR.IC.ENGINEER"],E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UCEN--"]=[E["GR.IC.ENGINEER"],E["GR.M1.CONSTRUCTION"]],I["S-G-UCENN-"]=[E["GR.IC.ENGINEER"],E["GR.M1.NAVAL"]],I["S-G-UCF---"]=[E["GR.IC.FIELD ARTILLERY"]],I["S-G-UCFH--"]=[E["GR.IC.FIELD ARTILLERY"]],I["S-G-UCFHE-"]=[s._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.IC.ARMOUR"]],I["S-G-UCFHS-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCFHA-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.AIRBORNE"]],I["S-G-UCFHC-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.ARCTIC"]],I["S-G-UCFHO-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.MOUNTAIN"]],I["S-G-UCFHL-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.LIGHT"]],I["S-G-UCFHM-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.MEDIUM"]],I["S-G-UCFHH-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.HEAVY"]],I["S-G-UCFHX-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCFR--"]=[E["GR.IC.FF.FIELD ARTILLERY ROCKET"]],I["S-G-UCFRS-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"]],I["S-G-UCFRS-"]=[s._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.M1.SINGLE ROCKET LAUNCHER"],R?[]:E["GR.IC.ARMOUR"]],I["S-G-UCFRSS"]=[s._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.IC.ARMOUR"]],I["S-G-UCFRSR"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.M2.TRUCK"]],I["S-G-UCFRST"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.M2.TOWED"]],I["S-G-UCFRM-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],R?"":E["GR.M2.CROSS-COUNTRY TRUCK"]],I["S-G-UCFRMS"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.IC.ARMOUR"]],I["S-G-UCFRMR"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.M2.TRUCK"]],I["S-G-UCFRMT"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.M2.TOWED"]],I["S-G-UCFT--"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.TARGET ACQUISITION"]],I["S-G-UCFTR-"]=[s._translate(-30,10,s._scale(.6,E["GR.IC.FIELD ARTILLERY"])),E["GR.IC.RADAR"]],I["S-G-UCFTS-"]=[s._translate(0,30,s._scale(.7,E["GR.IC.FIELD ARTILLERY"])),E["GR.IC.FF.SOUND"]],I["S-G-UCFTF-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.OPTICAL"],E["GR.M2.TARGET ACQUISITION"]],I["S-G-UCFTC-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.MOTORIZED"],E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UCFTCD"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UCFTCM"]=[s._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"]],I["S-G-UCFTA-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.NAVAL"]],I["S-G-UCFM--"]=[E["GR.IC.MORTAR"]],I["S-G-UCFMS-"]=[E["GR.IC.MORTAR"],E["GR.M2.TRACKED"]],I["S-G-UCFMW-"]=I["S-G-UCFMSW"]=[E["GR.IC.MORTAR"],E["GR.M2.TRUCK"]],I["S-G-UCFMT-"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"]],I["S-G-UCFMTA"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M2.AIRBORNE"]],I["S-G-UCFMTS"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCFMTC"]=[E["GR.IC.MORTAR"],E["GR.M2.ARCTIC"]],I["S-G-UCFMTO"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M2.MOUNTAIN"]],I["S-G-UCFML-"]=[s._translate(0,-20,E["GR.IC.MORTAR"]),E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCFS--"]=[E["GR.IC.SURVEY"]],I["S-G-UCFSS-"]=[E["GR.IC.SURVEY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCFSA-"]=[E["GR.IC.SURVEY"],E["GR.M2.AIRBORNE"]],I["S-G-UCFSL-"]=[E["GR.IC.SURVEY"],E["GR.M2.LIGHT"]],I["S-G-UCFSO-"]=[E["GR.IC.SURVEY"],E["GR.M2.MOUNTAIN"]],I["S-G-UCFO--"]=[E["GR.IC.METEOROLOGICAL"]],I["S-G-UCFOS-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCFOA-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.AIRBORNE"]],I["S-G-UCFOL-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.LIGHT"]],I["S-G-UCFOO-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.MOUNTAIN"]],I["S-G-UCR---"]=[E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UCRH--"]=[E["GR.IC.FF.HORSE"]],I["S-G-UCRV--"]=[E["GR.IC.FF.RECONNAISSANCE"],R?E["GR.M2.CAVALRY"]:[]],I["S-G-UCRVA-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"]],I["S-G-UCRVM-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCRVG-"]=[E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UCRVO-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.AVIATION ROTARY WING"]],I["S-G-UCRC--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.ARCTIC"]],I["S-G-UCRS--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["S-G-UCRA--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.AIRBORNE"]],I["S-G-UCRO--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.MOUNTAIN"]],I["S-G-UCRL--"]=I["S-G-UCRLL-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.LIGHT"]],I["S-G-UCRR--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCRRD-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"],R?E["GR.M1.MARINE DIVISION"]:[]],I["S-G-UCRRF-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M1.FORCE"]],I["S-G-UCRRL-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],I["S-G-UCRX--"]=[E["GR.IC.FF.RECONNAISSANCE"],R?E["GR.M2.LONG RANGE SURVEILLANCE"]:[s._translate(0,-20,E["GR.M2.MOUNTAIN"]),E["GR.M2.LONG RANGE"]]],I["S-G-UCM---"]=[E["GR.IC.MISSILE"]],I["S-G-UCMT--"]=[E["GR.IC.MISSILE"],E["GR.M2.TACTICAL MISSILE"]],I["S-G-UCMS--"]=[E["GR.IC.MISSILE"],E["GR.M2.STRATEGIC MISSILE"]],I["S-G-UCS---"]=[E["GR.IC.SECURITY"]],I["S-G-UCSW--"]=[s._translate(0,-20,E["GR.IC.SECURITY"]),E["GR.IC.FF.AMPHIBIOUS"]],I["S-G-UCSG--"]=[E["GR.IC.SECURITY"]],I["S-G-UCSGD-"]=[E["GR.IC.SECURITY"],E["GR.IC.FF.INFANTRY"]],I["S-G-UCSGM-"]=[E["GR.IC.SECURITY"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UCSGA-"]=[E["GR.IC.SECURITY"],E["GR.IC.ARMOUR"]],I["S-G-UCSM--"]=[E["GR.IC.SECURITY"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],I["S-G-UCSR--"]=[E["GR.IC.SECURITY"],E["GR.M2.RAILROAD"]],I["S-G-UCSA--"]=[s._translate(0,-20,E["GR.IC.SECURITY"]),E["GR.IC.AVIATION ROTARY WING"]],I["S-G-F-S---"]=E["GR.IC.SURVEILLANCE"],I["S-G-UU----"]=[E["GR.IC.COMBAT SUPPORT"]],I["S-G-UUA---"]=[E["GR.IC.CBRN"]],I["S-G-UUAC--"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"]],I["S-G-UUACC-"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"]],I["S-G-UUACCK"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"],E["GR.IC.ARMOUR"]],I["S-G-UUACCM"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UUACS-"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"]],I["S-G-UUACSM"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"],E["GR.IC.FF.MOTORIZED"]],I["S-G-UUACSA"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"],E["GR.IC.ARMOUR"]],I["S-G-UUACR-"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"],E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UUACRW"]=[E["GR.IC.CBRN"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],I["S-G-UUACRS"]=[E["GR.IC.CBRN"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"],R?E["GR.M1.CHEMICAL SURVEILLANCE"]:[]],I["S-G-UUAN--"]=[E["GR.IC.CBRN"],E["GR.M1.NUCLEAR"]],I["S-G-UUAB--"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"]],I["S-G-UUABR-"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"],E["GR.IC.FF.MOTORIZED"],E["GR.IC.FF.RECONNAISSANCE"]],I["S-G-UUAD--"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"]],I["S-G-UUADT-"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.TROOP"]],I["S-G-UUADE-"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.EQUIPMENT"]],I["S-G-UUADET"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.EQUIMENT/TROOP"]],I["S-G-UUAL--"]=[E["GR.IC.CBRN"],E["GR.M2.LABORATORY"]],I["S-G-UUM---"]=[E["GR.IC.MILITARY INTELLIGENCE"]],I["S-G-UUMA--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],I["S-G-UUMS--"]=[s._translate(-25,0,E["GR.IC.MILITARY INTELLIGENCE"]),E["GR.IC.RADIO"]],I["S-G-UUMSE-"]=[E["GR.IC.ELECTRONIC WARFARE"]],I["S-G-UUMSEA"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],I["S-G-UUMSED"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.DIRECTION FINDING"]],I["S-G-UUMSEI"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.INTERCEPT"]],I["S-G-UUMSEJ"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.JAMMING"]],I["S-G-UUMSET"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-UUMSEC"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-UUMC--"]=[E["GR.IC.COUNTER-INTELLIGENCE"]],I["S-G-UUMR--"]=[E["GR.IC.MILITARY INTELLIGENCE"]],I["S-G-UUMRG-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.RADAR"]],I["S-G-UUMRS-"]=[s._translate(0,30,s._scale(.8,E["GR.IC.MILITARY INTELLIGENCE"])),E["GR.IC.FF.SENSOR"]],I["S-G-UUMRSS"]=[s._translate(0,30,s._scale(.8,E["GR.IC.MILITARY INTELLIGENCE"])),E["GR.IC.FF.SENSOR"],E["GR.M1.SENSOR CONTROL MODULE"]],I["S-G-UUMRX-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.GROUND STATION MODULE"]],I["S-G-UUMMO-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.METEOROLOGICAL"]],I["S-G-UUMO--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.OPERATIONS"]],I["S-G-UUMT--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.TACTICAL EXPLOITATION"]],I["S-G-UUMQ--"]=[E["GR.IC.INTERROGATION"]],I["S-G-UUMJ--"]=[E["GR.IC.JOINT INTELLIGENCE CENTRE"]],I["S-G-UUL---"]=[E["GR.IC.FF.MILITARY POLICE"],E["GR.IC.MILITARY POLICE"]],I["S-G-UULS--"]=[E["GR.IC.SHORE PATROL"]],I["S-G-UULM--"]=[E["GR.IC.MILITARY POLICE"]],I["S-G-UULC--"]=[E["GR.IC.LAW ENFORCEMENT"]],I["S-G-UULF--"]=[s._translate(0,-25,s._scale(.8,E["GR.IC.SHORE PATROL"])),E["GR.IC.AVIATION FIXED WING"]],I["S-G-UULD--"]=[E["GR.IC.CRIMINAL INVESTIGATION DIVISION"]],I["S-G-UUS---"]=[E["GR.IC.FF.SIGNAL"]],I["S-G-UUSA--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.AREA"]],I["S-G-UUSC--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]],I["S-G-UUSCL-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.LARGE COMMUNICATIONS CONTINGENCY PACKAGE"],E["GR.M2.AIRBORNE"]],I["S-G-UUSO--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.OPERATIONS"]],I["S-G-UUSF--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.FORWARD"]],I["S-G-UUSM--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]],I["S-G-UUSMS-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.SMALL EXTENSION NODE"]],I["S-G-UUSML-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.LARGE EXTENSION NODE"]],I["S-G-UUSMN-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.NODE CENTRE"]],I["S-G-UUSR--"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO"]],I["S-G-UUSRS-"]=[E["GR.IC.FF.SIGNAL"],E["GR.I.FF.SATELLITE"]],I["S-G-UUSRT-"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO TELETYPE CENTRE"]],I["S-G-UUSRW-"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO RELAY"]],I["S-G-UUSS--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.SIGNAL SUPPORT"]],I["S-G-UUSW--"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.TELEPHONE SWITCH"]],I["S-G-UUSX--"]=[E["GR.IC.ELECTRONIC RANGING"]],I["S-G-UUI---"]=[E["GR.IC.INFORMATION OPERATIONS"]],I["S-G-UUP---"]=I["S-G-UUX---"]=[E["GR.IC.FF.AMPHIBIOUS"],E["GR.M1.LANDING SUPPORT"]],I["S-G-UUE---"]=[E["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],I["S-G-UUT---"]=[E["GR.IC.TOPOGRAPHIC"]],I["S-G-UUD---"]=[E["GR.IC.DRILLING"]],I["S-G-US----"]=[E["GR.IC.COMBAT SERVICE SUPPORT"]],I["S-G-USA---"]=[E["GR.IC.ADMINISTRATIVE"]],I["S-G-USAT--"]=[E["GR.IC.ADMINISTRATIVE"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAC--"]=[E["GR.IC.ADMINISTRATIVE"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAJ--"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"]],I["S-G-USAJT-"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAJC-"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAO--"]=[E["GR.IC.POSTAL"]],I["S-G-USAOT-"]=[E["GR.IC.POSTAL"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAOC-"]=[E["GR.IC.POSTAL"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAF--"]=[E["GR.IC.FINANCE"]],I["S-G-USAFT-"]=[E["GR.IC.FINANCE"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAFC-"]=[E["GR.IC.FINANCE"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAS--"]=[E["GR.IC.PERSONNEL SERVICES"]],I["S-G-USAST-"]=[E["GR.IC.PERSONNEL SERVICES"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USASC-"]=[E["GR.IC.PERSONNEL SERVICES"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAM--"]=[E["GR.IC.MORTUARY AFFAIRS"]],I["S-G-USAMT-"]=[E["GR.IC.MORTUARY AFFAIRS"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAMC-"]=[E["GR.IC.MORTUARY AFFAIRS"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAR--"]=[E["GR.IC.RELIGIOUS SUPPORT"]],I["S-G-USART-"]=[E["GR.IC.RELIGIOUS SUPPORT"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USARC-"]=[E["GR.IC.RELIGIOUS SUPPORT"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAP--"]=[E["GR.IC.PUBLIC AFFAIRS"]],I["S-G-USAPT-"]=[E["GR.IC.PUBLIC AFFAIRS"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAPC-"]=[E["GR.IC.PUBLIC AFFAIRS"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAPB-"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"]],I["S-G-USAPBT"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAPBC"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAPM-"]=[E["GR.IC.JOINT INFORMATION BUREAU"]],I["S-G-USAPMT"]=[E["GR.IC.JOINT INFORMATION BUREAU"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAPMC"]=[E["GR.IC.JOINT INFORMATION BUREAU"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAX--"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"]],I["S-G-USAXT-"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAXC-"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAL--"]=[E["GR.IC.LABOUR"]],I["S-G-USALT-"]=[E["GR.IC.LABOUR"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USALC-"]=[E["GR.IC.LABOUR"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAW--"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"]],I["S-G-USAWT-"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAWC-"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USAQ--"]=[E["GR.IC.QUARTERMASTER"]],I["S-G-USAQT-"]=[E["GR.IC.QUARTERMASTER"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USAQC-"]=[E["GR.IC.QUARTERMASTER"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USM---"]=[E["GR.IC.FF.MEDICAL"]],I["S-G-USMT--"]=[E["GR.IC.FF.MEDICAL THEATER"]],I["S-G-USMC--"]=[E["GR.IC.FF.MEDICAL CORPS"]],I["S-G-USMM--"]=[E["GR.IC.FF.MEDICAL"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I["S-G-USMMT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I["S-G-USMMC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I["S-G-USMV--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.VETERINARY"]],I["S-G-USMVT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.VETERINARY"]],I["S-G-USMVC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.VETERINARY"]],I["S-G-USMD--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.DENTAL"]],I["S-G-USMDT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.DENTAL"]],I["S-G-USMDC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.DENTAL"]],I["S-G-USMP--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.PSYCHOLOGICAL"]],I["S-G-USMPT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.PSYCHOLOGICAL"]],I["S-G-USMPC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.PSYCHOLOGICAL"]],I["S-G-USS---"]=[E["GR.IC.FF.SUPPLY"]],I["S-G-USST--"]=[E["GR.IC.FF.SUPPLY THEATER"]],I["S-G-USSC--"]=[E["GR.IC.FF.SUPPLY CORPS"]],I["S-G-USS1--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS I"]],I["S-G-USS1T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS I"]],I["S-G-USS1C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS I"]],I["S-G-USS2--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS II"]],I["S-G-USS2T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS II"]],I["S-G-USS2C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS II"]],I["S-G-USS3--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS III"]],I["S-G-USS3T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS III"]],I["S-G-USS3C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS III"]],I["S-G-USS3A-"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS III"],s._translate(25,5,s._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],I["S-G-USS3AT"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS III"],s._translate(25,5,s._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],I["S-G-USS3AC"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS III"],s._translate(25,5,s._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],I["S-G-USS4--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS IV"]],I["S-G-USS4T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS IV"]],I["S-G-USS4C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS IV"]],I["S-G-USS5--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS V"]],I["S-G-USS5T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS V"]],I["S-G-USS5C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS V"]],I["S-G-USS6--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VI"]],I["S-G-USS6T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VI"]],I["S-G-USS6C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VI"]],I["S-G-USS7--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VII"]],I["S-G-USS7T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VII"]],I["S-G-USS7C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VII"]],I["S-G-USS8--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VIII"]],I["S-G-USS8T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VIII"]],I["S-G-USS8C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VIII"]],I["S-G-USS9--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS IX"]],I["S-G-USS9T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS IX"]],I["S-G-USS9C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS IX"]],I["S-G-USSX--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS X"]],I["S-G-USSXT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS X"]],I["S-G-USSXC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS X"]],I["S-G-USSL--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.LAUNDRY/BATH"]],I["S-G-USSLT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.LAUNDRY/BATH"]],I["S-G-USSLC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.LAUNDRY/BATH"]],I["S-G-USSW--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER"]],I["S-G-USSWT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.WATER"]],I["S-G-USSWC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.WATER"]],I["S-G-USSWP-"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER PURIFICATION"]],I["S-G-USSWPT"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.WATER PURIFICATION"]],I["S-G-USSWPC"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.WATER PURIFICATION"]],I["S-G-UST---"]=[E["GR.IC.TRANSPORTATION"]],I["S-G-USTT--"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"]],I["S-G-USTC--"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"]],I["S-G-USTM--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],I["S-G-USTMT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],I["S-G-USTMC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],I["S-G-USTR--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],I["S-G-USTRT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],I["S-G-USTRC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],I["S-G-USTS--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],I["S-G-USTST-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],I["S-G-USTSC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],I["S-G-USTA--"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],I["S-G-USTAT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],I["S-G-USTAC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],I["S-G-USTI--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],I["S-G-USTIT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],I["S-G-USTIC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],I["S-G-USX---"]=[E["GR.IC.MAINTENANCE"]],I["S-G-USXT--"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"]],I["S-G-USXC--"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"]],I["S-G-USXH--"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.HEAVY"]],I["S-G-USXHT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M2.HEAVY"]],I["S-G-USXHC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M2.HEAVY"]],I["S-G-USXR--"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.RAILROAD"]],I["S-G-USXRT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M2.RAILROAD"]],I["S-G-USXRC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M2.RAILROAD"]],I["S-G-USXO--"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.AMMUNITION"]],I["S-G-USXOT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.AMMUNITION"]],I["S-G-USXOC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.AMMUNITION"]],I["S-G-USXOM-"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.MISSILE"]],I["S-G-USXOMT"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.MISSILE"]],I["S-G-USXOMC"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.MISSILE"]],I["S-G-USXE--"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.ELECTRO-OPTICAL"]],I["S-G-USXET-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.ELECTRO-OPTICAL"]],I["S-G-USXEC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.ELECTRO-OPTICAL"]],I["S-G-USXBDR"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.BATTLE DAMAGE REPAIR"]],I["S-G-USXPM-"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.PREVENTIVE MAINTENANCE"]],I["S-G-USXP--"]=[E["GR.IC.PIPELINE"]],I["S-G-USXEP-"]=[E["GR.IC.ENVIRONMENTAL PROTECTION"]],I["S-G-UH----"]=[],I["S-G-UH1---"]=[E["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],I["S-G-UH2---"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],I["S-G-UHGL--"]=I["S-G-GL----"]=[E["GR.IC.LIAISON"]]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G);var M={type:"letter",icons:function(I,t,E,R){I["S-G-E-----"]=[],I["S-G-EW----"]=[],I["S-G-EWM---"]=[E["GR.EQ.MISSILE LAUNCHER"]],I["S-G-EWMA--"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]],I["S-G-EWMAS-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWMASR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I["S-G-EWMASE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I["S-G-EWMAI-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWMAIR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I["S-G-EWMAIE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I["S-G-EWMAL-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"]],I["S-G-EWMALR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I["S-G-EWMALE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I["S-G-EWMAT-"]=[s._translate(0,-15,s._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"]],I["S-G-EWMATR"]=[s._translate(0,-15,s._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I["S-G-EWMATE"]=[s._translate(0,-15,s._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I["S-G-EWMS--"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]],I["S-G-EWMSS-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWMSI-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWMSL-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.LONG RANGE"]],I["S-G-EWMT--"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"]],I["S-G-EWMTL-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWMTM-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWMTH-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.LONG RANGE"]],I["S-G-EWS---"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"]],I["S-G-EWSL--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWSM--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWSH--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.LONG RANGE"]],I["S-G-EWX---"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"]],I["S-G-EWXL--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,E["GR.EQ.SHORT RANGE"])],I["S-G-EWXM--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,E["GR.EQ.INTERMEDIATE RANGE"])],I["S-G-EWXH--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,E["GR.EQ.LONG RANGE"])],I["S-G-EWT---"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"]],I["S-G-EWTL--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWTM--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWTH--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.LONG RANGE"]],I["S-G-EWR---"]=[E["GR.EQ.RIFLE"]],I["S-G-EWRR--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWRL--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWRH--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.LONG RANGE"]],I["S-G-EWZ---"]=[E["GR.EQ.GRENADE LAUNCHER"]],I["S-G-EWZL--"]=[E["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,E["GR.EQ.SHORT RANGE"])],I["S-G-EWZM--"]=[E["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,E["GR.EQ.INTERMEDIATE RANGE"])],I["S-G-EWZH--"]=[E["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,E["GR.EQ.LONG RANGE"])],I["S-G-EWO---"]=[E["GR.EQ.MORTAR"]],I["S-G-EWOL--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWOM--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWOH--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.LONG RANGE"]],I["S-G-EWH---"]=[E["GR.EQ.HOWITZER"]],I["S-G-EWHL--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWHLS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.SHORT RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWHM--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWHMS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.INTERMEDIATE RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWHH--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.LONG RANGE"]],I["S-G-EWHHS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.LONG RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWG---"]=[E["GR.EQ.ANTITANK GUN"]],I["S-G-EWGL--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWGM--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWGH--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.LONG RANGE"]],I["S-G-EWGR--"]=[E["GR.EQ.RECOILLESS GUN"]],I["S-G-EWD---"]=[E["GR.EQ.DIRECT FIRE GUN"]],I["S-G-EWDL--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWDLS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.SHORT RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWDM--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWDMS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWDH--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.LONG RANGE"]],I["S-G-EWDHS-"]=[s._translate(0,-15,s._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.LONG RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],I["S-G-EWA---"]=[E["GR.EQ.AIR DEFENCE GUN"]],I["S-G-EWAL--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.SHORT RANGE"]],I["S-G-EWAM--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],I["S-G-EWAH--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.LONG RANGE"]],I["S-G-EV----"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]],I["S-G-EVA---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.ARMOURED VEHICLE"]],I["S-G-EVAT--"]=[E["GR.EQ.TANK"]],I["S-G-EVATL-"]=[E["GR.EQ.TANK"],E["GR.EQ.LIGHT TANK"]],I["S-G-EVATLR"]=I["S-G-EVATW-"]=[E["GR.EQ.TANK"],E["GR.EQ.LIGHT TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],I["S-G-EVATM-"]=[E["GR.EQ.TANK"],E["GR.EQ.MEDIUM TANK"]],I["S-G-EVATMR"]=I["S-G-EVATX-"]=[E["GR.EQ.TANK"],E["GR.EQ.MEDIUM TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],I["S-G-EVATH-"]=[E["GR.EQ.TANK"],E["GR.EQ.HEAVY TANK"]],I["S-G-EVATHR"]=I["S-G-EVATY-"]=[E["GR.EQ.TANK"],E["GR.EQ.HEAVY TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],I["S-G-EVAA--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"]],I["S-G-EVAAR-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.TANK RECOVERY VEHICLE"]],I["S-G-EVAI--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE"]],I["S-G-EVAC--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]],I["S-G-EVAS--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER COMBAT SERVICE SUPPORT VEHICLE"]],I["S-G-EVAL--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE"],E["GR.EQ.CROSS-COUNTRY"]],I["S-G-EVU---"]=[E["GR.EQ.UTILITY VEHICLE"]],I["S-G-EVUB--"]=[E["GR.EQ.BUS"]],I["S-G-EVUS--"]=[E["GR.EQ.SEMI-TRAILER TRUCK"]],I["S-G-EVUSL-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE LIGHT"]],I["S-G-EVUSM-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE MEDIUM"]],I["S-G-EVUSH-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE HEAVY"]],I["S-G-EVUL--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"]],I["S-G-EVUX--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"]],I["S-G-EVUR--"]=[E["GR.EQ.WATER VEHICLE"]],I["S-G-EVUT--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]],I["S-G-EVUTL-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]],I["S-G-EVUTH-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]],I["S-G-EVUA--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.MEDICAL EVACUATION"]],I["S-G-EVUAA-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.MEDICAL EVACUATION"]],I["S-G-EVE---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],s._scale(.7,E["GR.IC.ENGINEER"])],I["S-G-EVEB--"]=[E["GR.EQ.BRIDGE"]],I["S-G-EVEE--"]=[E["GR.EQ.EARTHMOVER"]],I["S-G-EVEC--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],s._scale(.6,E["GR.IC.ENGINEER"])],I["S-G-EVEM--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.MINE LAYING VEHICLE"]],I["S-G-EVEMA-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],E["GR.EQ.TANK"]],I["S-G-EVEMV-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],I["S-G-EVEMT-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],s._translate(0,-10,E["GR.EQ.LIMITED CROSS-COUNTRY"])],I["S-G-EVEML-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],E["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],I["S-G-EVEA--"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"]],I["S-G-EVEAA-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],E["GR.EQ.TANK"]],I["S-G-EVEAT-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],s._translate(0,-10,E["GR.EQ.LIMITED CROSS-COUNTRY"])],I["S-G-EVEMSM"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.MINE SCATTERABLE"]],I["S-G-EVED--"]=[E["GR.EQ.DOZER"]],I["S-G-EVEDA-"]=[E["GR.EQ.DOZER ARMORED"]],I["S-G-EVES--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],s._scale(.6,E["GR.IC.ENGINEER"])],I["S-G-EVER--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],s._scale(.6,E["GR.IC.ENGINEER"]),E["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]],I["S-G-EVEH--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],E["GR.EQ.UTILITY VEHICLE BACKHOE"]],I["S-G-EVEF--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"],E["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]],I["S-G-EVD---"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"],s._scale(.7,E["GR.IC.DRILLING"])],I["S-G-EVT---"]=[E["GR.EQ.TRAIN LOCOMOTIVE"]],I["S-G-EVC---"]=[E["GR.I.CIVILIAN"]],I["S-G-EVCA--"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]],I["S-G-EVCAL-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I["S-G-EVCAM-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I["S-G-EVCAH-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I["S-G-EVCO--"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]],I["S-G-EVCOL-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I["S-G-EVCOM-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I["S-G-EVCOH-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I["S-G-EVCM--"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],I["S-G-EVCML-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I["S-G-EVCMM-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I["S-G-EVCMH-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I["S-G-EVCU--"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]],I["S-G-EVCUL-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I["S-G-EVCUM-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I["S-G-EVCUH-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I["S-G-EVCJ--"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]],I["S-G-EVCJL-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I["S-G-EVCJM-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I["S-G-EVCJH-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I["S-G-EVCT--"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCTL-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCTM-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCTH-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCF--"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCFL-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCFM-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVCFH-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I["S-G-EVM---"]=[E["GR.EQ.PACK ANIMAL"]],I["S-G-EVS---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE SUPPORT"]],I["S-G-EVST--"]=R?[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE TRANSLOADER"]]:[E["GR.EQ.TRAIN LOCOMOTIVE"]],I["S-G-EVSR--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE TRANSPORTER"]],I["S-G-EVSC--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE CRANE/LOADING DEVICE"]],I["S-G-EVSP--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]],I["S-G-EVSW--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE WARHEAD TRANSPORTER"]],I["S-G-ES----"]=[E["GR.EQ.SENSOR"]],I["S-G-ESR---"]=[E["GR.EQ.RADAR"]],I["S-G-ESE---"]=[E["GR.EQ.SENSOR EMPLACED"]],I["S-G-EXI---"]=[E["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]],I["S-G-EX----"]=[],I["S-G-EXL---"]=[E["GR.EQ.LASER"]],I["S-G-EXN---"]=[E["GR.EQ.CBRN EQUIPMENT"]],I["S-G-EXF---"]=[E["GR.EQ.FLAME THROWER"]],I["S-G-EXM---"]=[E["GR.EQ.LAND MINES"]],I["S-G-EXMC--"]=[E["GR.EQ.ANTIPERSONNEL LAND MINE"]],I["S-G-EXML--"]=[E["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]];var e={"E-----":0,"EWM---":140,"EWMA--":140,"EWMAS-":140,EWMASR:140,EWMASE:140,"EWMAI-":140,EWMAIR:140,EWMAIE:140,"EWMAL-":140,EWMALR:140,EWMALE:140,"EWMAT-":153,EWMATR:153,EWMATE:153,"EWMS--":140,"EWMSS-":140,"EWMSI-":140,"EWMSL-":140,"EWMT--":140,"EWMTL-":140,"EWMTM-":140,"EWMTH-":140,"EWS---":140,"EWSL--":140,"EWSM--":140,"EWSH--":140,"EWX---":140,"EWXL--":140,"EWXM--":140,"EWXH--":140,"EWT---":140,"EWTL--":140,"EWTM--":140,"EWTH--":140,"EWR---":140,"EWRL--":140,"EWRM--":140,"EWRH--":140,"EWZ---":140,"EWZL--":140,"EWZM--":140,"EWZH--":140,"EWO---":140,"EWOL--":140,"EWOM--":140,"EWOH--":140,"EWH---":140,"EWHL--":140,"EWHLS-":130,"EWHM--":140,"EWHMS-":130,"EWHH--":140,"EWHHS-":130,"EWG---":140,"EWGL--":140,"EWGM--":140,"EWGH--":140,"EWGR--":140,"EWD---":140,"EWDL--":140,"EWDLS-":130,"EWDM--":140,"EWDMS-":130,"EWDH--":140,"EWDHS-":130,"EWA---":140,"EWAL--":140,"EWAM--":140,"EWAH--":140,"EV----":129,"EVA---":129,"EVAT--":130,"EVATL-":130,EVATLR:130,"EVATM-":130,EVATMR:130,"EVATH-":130,EVATHR:130,"EVAA--":130,"EVAAR-":130,"EVAI--":130,"EVAC--":130,"EVAS--":130,"EVAL--":140,"EVU---":130,"EVAB--":130,"EVUS--":140,"EVUSL-":140,"EVUSM-":140,"EVUSH-":140,"EVUL--":140,"EVUX--":140,"EVUR--":130,"EVUTL-":130,"EVUTH-":130,"EVUA--":130,"EVUAA-":130,"EVE---":129,"EVEB--":130,"EVEE--":130,"EVEC--":140,"EVEM--":130,"EVEMA-":130,"EVEMV-":130,"EVEMT-":130,"EVEML-":140,"EVEA--":120,"EVEAA-":130,"EVEAT-":130,EVEMSM:130,"EVED--":130,"EVEDA-":130,"EVES--":130,"EVER--":130,"EVEH--":140,"EVEF--":140,"EVD---":140,"EVT--":130,"EVC---":119,"EVCA--":132.5,"EVCAL-":132.5,"EVCAM-":132.5,"EVCAH-":132.5,"EVCO--":132.5,"EVCOL-":132.5,"EVCOM-":132.5,"EVCOH-":132.5,"EVCM--":132.5,"EVCML-":132.5,"EVCMM-":132.5,"EVCMH-":132.5,"EVCU--":132.5,"EVCUL-":132.5,"EVCUM-":132.5,"EVCUH-":132.5,"EVCJ--":132.5,"EVCJL-":132.5,"EVCJM-":132.5,"EVCJH-":132.5,"EVCT--":132.5,"EVCTL-":132.5,"EVCTM-":132.5,"EVCTH-":132.5,"EVCF--":132.5,"EVCFL-":132.5,"EVCFM-":132.5,"EVCFH-":132.5,"EVM---":125,"EVS---":129,"EVST--":129,"EVSR--":129,"EVSC--":129,"EVSP--":129,"EVSW--":129,"ES----":140,"ESR---":120,"ESE---":136,"EXI---":119,"EXL---":145,"EXN---":140,"EXF---":135,"EXM---":130,"EXMC--":122,"EXML--":122};for(var A in e)e.hasOwnProperty(A)&&(t["S-G-"+A]={x1:50,x2:150,y1:50,y2:e[A]})}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G);var i={type:"letter",icons:function(I,t,E,R){I["S-G-I-----"]=[],I["S-G-IR----"]=[E["GR.IN.IC.RAW MATERIAL PRODUCTION/STORAGE"]],I["S-G-IRM---"]=[E["GR.IN.IC.MINE"]],I["S-G-IRP---"]=[E["GR.IC.FF.CLASS III"]],I["S-G-IRN---"]=[E["GR.IC.CBRN"]],I["S-G-IRNB--"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"]],I["S-G-IRNC--"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"]],I["S-G-IRNN--"]=[E["GR.IC.CBRN"],E["GR.M1.NUCLEAR"]],I["S-G-IP----"]=[E["GR.IN.IC.PROCESSING FACILITY"]],I["S-G-IPD---"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"]],I["S-G-IE----"]=[E["GR.IC.EQUIPMENT MANUFACTURE"]],I["S-G-IU----"]=[E["GR.IN.IC.UTILITY FACILITY"]],I["S-G-IUR---"]=[E["GR.IN.IC.RESEARCH"]],I["S-G-IUT---"]=[E["GR.IN.IC.TELECOMMUNICATIONS"]],I["S-G-IUE---"]=[E["GR.IN.IC.ELECTRIC POWER"]],I["S-G-IUEN--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER NUCLEAR"]],I["S-G-IUED--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER DAM"]],I["S-G-IUEF--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER FOSSIL"]],I["S-G-IUP---"]=[E["GR.IC.WATER"]],I["S-G-IM----"]=[],I["S-G-IMF---"]=[E["GR.IN.IC.ATOMIC ENERGY"]],I["S-G-IMFA--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.ATOMIC ENERGY REACTOR"]],I["S-G-IMFP--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],I["S-G-IMFPW-"]=[E["GR.IN.IC.ATOMIC ENERGY WEAPONS GRADE"],E["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],I["S-G-IMFS--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]],I["S-G-IMA---"]=[E["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]],I["S-G-IME---"]=[E["GR.IC.FF.CLASS V"]],I["S-G-IMG---"]=[E["GR.EQ.TANK"]],I["S-G-IMV---"]=[E["GR.IC.MAINTENANCE"]],I["S-G-IMN---"]=[E["GR.EQ.DOZER"]],I["S-G-IMNB--"]=[E["GR.IN.IC.BRIDGE"]],I["S-G-IMC---"]=[E["GR.IC.CBRN"],E["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]],I["S-G-IMS---"]=[E["GR.IC.NAVAL"],E["GR.IN.M2.SHIP CONSTRUCTION"]],I["S-G-IMM---"]=[E["GR.IC.MISSILE"]],I["S-G-IG----"]=[E["GR.I.GOVERNMENT"]],I["S-G-IB----"]=[E["GR.IN.IC.BASE"]],I["S-G-IBA---"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],I["S-G-IBN---"]=[E["GR.IC.NAVAL"]],I["S-G-IT----"]=[E["GR.IC.TRANSPORTATION"]],I["S-G-IX----"]=[E["GR.IC.FF.MEDICAL"]],I["S-G-IXH---"]=[E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I["S-G-IRR---"]=I["S-G-IRSR--"]=[E["GR.IN.IC.SEA SURFACE INSTALLATION, OIL RIG/PLATFORM"]]}};function L(I,t,E,R,e,A){var C=t.frame,T=t.affiliation||"Friend",S=t.numberSIDC,N=E.iconColor[T],O=E.iconFillColor[T],G=E.black[T],o=E.white[T],M={};for(var i in M["SE.IC.MILITARY"]=a("MIL"),M["SE.IC.MANUAL TRACK"]=a("MAN"),M["SE.IC.COMBATANT"]=[{type:"path",d:"m 86.9,110 c -3.6,2 -7.2,3.9 -10.8,5.9 2.1,2.9 6.7,3.9 10,2.1 2.6,-0.9 4.7,-3.8 3.1,-6.1 -0.8,-0.6 -1.5,-1.3 -2.3,-1.9 z m 26.3,0.1 c 3.6,2 7.2,3.9 10.8,5.9 -2.1,2.9 -6.7,3.9 -10,2.1 -2.6,-0.9 -4.7,-3.8 -3.1,-6.1 0.8,-0.6 1.5,-1.3 2.3,-1.9 z",fill:!1},{type:"path",d:"m 112.9,110 c -5.6,-4 -11.3,-7.9 -16.1,-12.5 -4.2,-4.5 -7,-9.8 -9.2,-15.1 -0.8,4.4 -0.9,9.3 2.4,13.2 3.6,4.5 8.6,8.1 13.5,11.8 2.3,1.7 4.7,3.3 7.1,4.8 0.8,-0.7 1.5,-1.5 2.3,-2.2 m -25.7,0 c 5.6,-4 11.3,-7.9 16.1,-12.5 4.2,-4.5 7,-9.8 9.2,-15.1 0.8,4.4 0.9,9.3 -2.4,13.2 -3.6,4.5 -8.6,8.1 -13.5,11.8 -2.3,1.7 -4.7,3.3 -7.1,4.8 -0.8,-0.7 -1.5,-1.5 -2.3,-2.2",fill:o,strokewidth:2}],M["SE.IC.SURFACE COMBATANT, LINE"]={type:"path",stroke:!1,d:"m 100,120 -25,-17 15,2 0,-10 5,0 0,-5 -15,0 0,-5 15,0 0,-5 10,0 0,5 15,0 0,5 -15,0 0,5 5,0 0,10 15,-2 z"},M["SE.IC.CARRIER"]={type:"path",d:"m 80,100 20,20 20,-20 -20,0 0,-20 -20,0 z"},M["SE.IC.BATTLESHIP"]=a("BB"),M["SE.IC.CIVILIAN"]=a("CIV"),M["SE.IC.CIVILIAN"].fill=R||S?O:!C&&O,M["SE.IC.CIVILIAN"].stroke=G,M["SE.IC.CIVILIAN"].strokewidth=3,M["SE.IC.CRUISER"]=a("CC"),M["SE.IC.CRUISER, GUIDED MISSILE"]=a("CG"),M["SE.IC.DESTROYER"]=a("DD"),M["SE.IC.FRIGATE"]=a("FF"),M["SE.IC.CORVETTE"]=a("FS"),M["SE.IC.LITTORAL COMBATANT SHIP"]=a("LL"),M["SE.IC.AMPHIBIOUS WARFARE SHIP"]={type:"path",d:"m 100,120 20,0 m -20,0 -20,-20 10,0 0,-20 20,0 0,20 10,0 z"},M["SE.IC.AMPHIBIOUS FORCE FLAGSHIP"]=a("LCC"),M["SE.IC.AMPHIBIOUS ASSAULT"]=a("LA"),M["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]=a("LHA"),M["SE.IC.AMPHIBIOUS ASSAULT SHIP, MULTI-PURPOSE"]=a("LHD"),M["SE.IC.AMPHIBIOUS TRANSPORT, DOCK"]=a("LPD"),M["SE.IC.AMPHIBIOUS ASSAULT SHIP, HELICOPTER"]=a("LPH"),M["SE.IC.LANDING SHIP"]=a("LS"),M["SE.IC.LANDING CRAFT"]=a("LC"),M["SE.IC.MINE WARFARE VESSEL"]={type:"path",d:"m 98.3,81 0,4.1 c -2.4,0.3 -4.6,1.4 -6.4,2.9 l -3.5,-3.5 -2.4,2.4 3.6,3.6 c -0.9,1.3 -1.5,4.9 -1.8,6.5 l -10.8,0 0,3 3,0 20,20 20,-20 3,0 0,-3 -10,0 c -1,-1.7 -2,-5.3 -3,-6.7 l 4,-3.7 -2,-2.4 -4,3.6 c -2,-1.4 -4,-2.4 -6,-2.7 l 0,-4.1 z"},M["SE.IC.MINELAYER"]=a("ML"),M["SE.IC.MINESWEEPER"]=a("MS"),M["SE.IC.MINESWEEPER, DRONE"]=a("MSD"),M["SE.IC.MINEHUNTER"]=a("MH"),M["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]=a(R?"MA":"MCS"),M["SE.IC.MINE COUNTERMEASURES"]=a("MCM"),M["SE.IC.SEA SURFACE DECOY"]={type:"path",d:"M 105,110 90,95 105,80 z M 85,110 70,95 85,80 z m 40,-30 -15,15 15,15 z m -55,40 0,-5 55,0 0,5 z"},M["SE.IC.PATROL"]={type:"path",d:"m 80,100 20,20 20,-20 -10,0 0,-20 -20,0 0,20 z"},M["SE.IC.PATROL CRAFT"]=a("PC"),M["SE.IC.PATROL ANTI SUBMARINE WARFARE"]={type:"path",d:"m 100,120 -25,-25 5,-5 10,10 5,0 0,-20 10,0 0,20 5,0 10,-10 5,5 z"},M["SE.IC.PATROL ANTISHIP MISSILE"]=a("PM"),M["SE.IC.PATROL TORPEDO"]=a("PT"),M["SE.IC.PATROL GUN"]=a("PG"),M["SE.IC.PATROL SHIP"]=[],M["SE.IC.MILITARY SPEEDBOAT"]={type:"path",stroke:!1,d:"m 120,120 -40,0 -15,-25 15,0 5,-15 10,0 -5,15 45,0 z"},M["SE.IC.MILITARY SPEEDBOAT, RIGID-HULL INFLATABLE BOAT"]=[{type:"path",stroke:!1,d:"M 85 80 L 80 95 L 65 95 L 80 120 L 120 120 L 135 95 L 90 95 L 95 80 L 85 80 z M 87 100.7 L 93.1 100.7 C 94.6 100.7 95.7 100.8 96.4 101.1 C 97.1 101.3 97.7 101.8 98.1 102.4 C 98.5 103.1 98.7 103.8 98.7 104.7 C 98.7 105.8 98.4 106.7 97.8 107.4 C 97.1 108.1 96.2 108.5 94.9 108.7 C 95.6 109.1 96.1 109.4 96.5 109.9 C 96.9 110.3 97.4 111.1 98.1 112.2 L 99.9 115 L 96.4 115 L 94.3 111.9 C 93.6 110.8 93.1 110.1 92.8 109.8 C 92.5 109.5 92.2 109.3 91.9 109.2 C 91.6 109.1 91.2 109 90.5 109 L 89.9 109 L 89.9 115 L 87 115 L 87 100.7 z M 101.5 100.7 L 107.2 100.7 C 108.3 100.7 109.2 100.7 109.7 100.8 C 110.3 100.9 110.8 101.1 111.2 101.4 C 111.7 101.7 112 102.1 112.3 102.6 C 112.6 103.1 112.7 103.7 112.8 104.3 C 112.7 105 112.6 105.6 112.2 106.1 C 111.9 106.7 111.4 107.1 110.8 107.4 C 111.6 107.7 112.3 108.1 112.8 108.7 C 113.2 109.3 113.5 110 113.5 110.8 C 113.5 111.5 113.3 112.1 113 112.8 C 112.7 113.4 112.3 113.8 111.8 114.2 C 111.2 114.6 110.6 114.8 109.8 114.9 C 109.3 115 108.2 115 106.3 115 L 101.5 115 L 101.5 100.7 z M 104.3 103.1 L 104.3 106.4 L 106.3 106.4 C 107.4 106.4 108.1 106.3 108.3 106.3 C 108.8 106.3 109.2 106.1 109.5 105.8 C 109.8 105.5 109.9 105.1 109.9 104.7 C 109.9 104.2 109.8 103.9 109.6 103.6 C 109.3 103.3 109 103.2 108.5 103.1 C 108.2 103.1 107.4 103.1 106 103.1 L 104.3 103.1 z M 89.9 103.1 L 89.9 106.8 L 92 106.8 C 93.4 106.8 94.3 106.7 94.6 106.6 C 95 106.4 95.2 106.3 95.4 106 C 95.6 105.7 95.7 105.3 95.8 104.9 C 95.7 104.4 95.6 104 95.3 103.7 C 95.1 103.4 94.7 103.2 94.3 103.2 C 94 103.1 93.3 103.1 92.2 103.1 L 89.9 103.1 z M 104.3 108.8 L 104.3 112.6 L 107 112.6 C 108.1 112.6 108.7 112.6 109 112.5 C 109.4 112.4 109.8 112.2 110.1 111.9 C 110.3 111.6 110.5 111.2 110.5 110.7 C 110.5 110.3 110.4 109.9 110.2 109.6 C 109.9 109.3 109.6 109.1 109.3 109 C 108.9 108.8 108 108.8 106.7 108.8 L 104.3 108.8 z"},{type:"text",fill:R?O:!C&&O,stroke:!1,x:100,y:115,fontsize:20,text:"RB"}],M["SE.IC.MILITARY JETSKI"]={type:"path",stroke:!1,d:"m 135,105 0,15 -60,0 -10,-15 20,-25 10,0 0,10 -5,0 -5,15 z"},M["SE.IC.UNMANNED SURFACE WATER VEHICLE"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},M["SE.IC.NAVY TASK ORGANIZATION UNIT"]=[{type:"path",d:"m 110,80 15,15 0,25 M 90,80 75,95 l 0,25",fill:!1}],R&&M["SE.IC.NAVY TASK ORGANIZATION UNIT"].push({type:"path",d:"m 100,80 -15,15 0,25 30,0 0,-25 -15,-15"}),M["SE.IC.NAVY TASK FORCE"]=[M["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",stroke:!1,x:100,y:R?150:120,fontsize:30,text:"TF"}],M["SE.IC.NAVY TASK GROUP"]=[M["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",stroke:!1,x:100,y:R?150:120,fontsize:30,text:"TG"}],M["SE.IC.NAVY TASK UNIT"]=[M["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",stroke:!1,x:100,y:R?150:120,fontsize:30,text:"TU"}],M["SE.IC.NAVY TASK ELEMENT"]=[M["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",stroke:!1,x:100,y:R?150:120,fontsize:30,text:"TE"}],M["SE.IC.CONVOY"]={type:"path",d:"m 80,115 -20,0 0,-35 80,0 0,35 -20,0 0,-20 -40,0 z"},M["SE.IC.NONCOMBATANT"]={type:"path",d:"m 80,100 0,-20 40,0 0,20 15,0 0,20 -70,0 0,-20 z"},M["SE.IC.AUXILIARY SHIP"]=a(R?"AR":"AA"),M["SE.IC.AMMUNITION SHIP"]=a("AE"),M["SE.IC.STORES SHIP"]=a("AF"),M["SE.IC.AUXILIARY FLAG OR COMMAND SHIP"]=a("AGF"),M["SE.IC.INTELLIGENCE COLLECTOR"]=a(R?"JI":"AI"),M["SE.IC.OCEAN RESEARCH SHIP"]=a("AGO"),M["SE.IC.SURVEY SHIP"]=a("AGS"),M["SE.IC.HOSPITAL SHIP"]=a("AH"),M["SE.IC.CARGO SHIP"]=a("AK"),M["SE.IC.COMBAT SUPPORT SHIP, FAST"]=a("AOE"),M["SE.IC.OILER, REPLENISHMENT"]=a("AO"),M["SE.IC.REPAIR SHIP"]=a("AR"),M["SE.IC.SUBMARINE TENDER"]=a("AS"),M["SE.IC.TUG, OCEAN GOING"]=a(R?"AS":"AT"),M["SE.IC.SERVICE CRAFT, YARD, GENERAL"]=a(R?"YY":"YT"),M["SE.IC.BARGE, NOT SELF-PROPELLED"]=a("YB"),M["SE.IC.BARGE, SELF-PROPELLED"]=a("YS"),M["SE.IC.TUG, HARBOUR"]=a("YT"),M["SE.IC.LAUNCH"]=a("YFT"),M["SE.IC.MERCHANT SHIP, GENERAL"]={type:"path",fill:R?O:!C&&O,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},M["SE.IC.CARGO, GENERAL"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"CA":"A"}],M["SE.IC.CONTAINER SHIP"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"C"}],M["SE.IC.DREDGE"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"D"}],M["SE.IC.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},M["SE.IC.ROLL ON-ROLL OFF"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:"30",text:R?"RO":"E"}],M["SE.IC.FERRY"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"FE":"F"}],M["SE.IC.HEAVY LIFT"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"H"}],M["SE.IC.HOVERCRAFT"]={type:"path",d:R?"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z":"m 90,80 0,15.6 C 78.4,96.9 70,100.6 70,105 c 0,5.5 13.4,10 30,10 16.6,0 30,-4.5 30,-10 0,-4.4 -8.4,-8.1 -20,-9.4 L 110,80 90,80 z m -15,40 50,0"},M["SE.IC.HOVERCRAFT 2525D"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"J"}],M["SE.IC.HOVERCRAFT CIVILIAN"]={type:"path",fill:R?O:!C&&O,d:R?"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z":"m 90,80 0,15.6 C 78.4,96.9 70,100.6 70,105 c 0,5.5 13.4,10 30,10 16.6,0 30,-4.5 30,-10 0,-4.4 -8.4,-8.1 -20,-9.4 L 110,80 90,80 z m -15,40 50,0"},M["SE.IC.HOVERCRAFT NONCOMBATANT"]=[{type:"path",d:"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z",strokewidth:!1},R?{type:"text",fill:o,stroke:!1,x:100,y:120,fontsize:30,text:"NC"}:[]],M["SE.IC.MERCHANT SHIP, LASH CARRIER (WITH BARGES)"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"L"}],M["SE.IC.OILER/TANKER"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"OT":"O"}],M["SE.IC.PASSENGER SHIP"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"PA":"P"}],M["SE.IC.TUG, OCEAN GOING CIVILIAN"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:R?"TU":"T"}],M["SE.IC.TOW"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"TW"}],M["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"HZ"}],M["SE.IC.JUNK/DHOW"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"QJ"}],M["SE.IC.BARGE, NOT SELF-PROPELLED"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",stroke:!1,x:100,y:115,fontsize:30,text:"YB"}],M["SE.IC.HOSPITAL SHIP2"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"path",stroke:!1,d:"m 95,95 0,-15 10,0 0,15 15,0 0,10 -15,0 0,15 -10,0 0,-15 -15,0 0,-10 z"}],M["SE.IC.FISHING VESSEL"]={type:"path",fill:R?O:!C&&O,d:"m 75,100 0,-15 20,0 0,15 50,0 -15,35 -60,0 -15,-35 z M 105,57.4 105,100 m 30,-35 -30,35"},M["SE.IC.DRIFTER"]=[M["SE.IC.FISHING VESSEL"],{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"DF"}],M["SE.IC.TRAWLER"]=[M["SE.IC.FISHING VESSEL"],{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"TR"}],M["SE.IC.FISHING VESSEL DREDGE"]=[M["SE.IC.FISHING VESSEL"],{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"DR"}],M["SE.IC.LAW ENFORCEMENT VESSEL"]=[M["SE.IC.MERCHANT SHIP, GENERAL"],{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],M["SE.IC.LEISURE CRAFT, SAILING BOAT"]={type:"path",fill:R?O:!C&&O,d:"m 105,55 0,40 35,0 z m -5,-5 0,50 m 45,0 -15,35 -60,0 -15,-35 z"},M["SE.IC.LEISURE CRAFT, MOTORIZED"]={type:"path",fill:R?O:!C&&O,d:"m 70,97.4 15,-30 10,0 -15,30 65,0 -15,35 -60,0 -15,-35 z"},M["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]=[M["SE.IC.LEISURE CRAFT, MOTORIZED"],{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"RB"}],M["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]=[M["SE.IC.LEISURE CRAFT, MOTORIZED"],{type:"text",stroke:!1,x:100,y:125,fontsize:30,text:"SP"}],M["SE.IC.LEISURE CRAFT, JETSKI"]={type:"path",fill:R?O:!C&&O,d:"m 85,60 -30,45 10,15 75,0 0,-20 -60,0 10,-30 5,0 0,-10 z"},M["SE.IC.UNMANNED SURFACE WATER VEHICLE (USV)"]={type:"path",fill:!(!R&&!S)&&O,stroke:G,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},M["SE.IC.OWN SHIP"]={type:"path",fill:!1,stroke:e?N:O,d:"m 50,100 100,0 m -50,-50 0,100 m 50,-50 c 0,27.6 -22.4,50 -50,50 -27.6,0 -50,-22.4 -50,-50 0,-27.6 22.4,-50 50,-50 27.6,0 50,22.4 50,50 z"},M["SE.IC.DITCHED AIRCRAFT"]={type:"path",fill:e?N:O,stroke:e?N:O,d:"m 145,120 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 10,10 25,-30 -10,-10 10,-10 20,20 -10,35 -15,-15 -15,15 z"},M["SE.IC.PERSON IN WATER"]={type:"path",fill:e?N:O,stroke:e?N:O,d:"m 105,110 10,-10 0,-15 5,0 0,20 -10,10 z m -10,0 -10,-10 0,-15 -5,0 0,20 10,10 z m 5,-5 0,-10 -5,0 -5,-5 0,-10 5,-5 10,0 5,5 0,10 -5,5 -5,0 m -15,25 15,-15 m 45,15 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 45,15 -15,-15"},M["SE.IC.DISTRESSED VESSEL"]={type:"path",fill:e?N:O,stroke:e?N:O,d:"m 120,65 -20,20 20,-20 m -5,55 -35,-35 0,-20 45,45 z m -30,0 -15,-15 m -15,15 15,-15 m 45,15 15,-15 m 15,15 -15,-15 m -45,15 15,-15"},M["SE.IC.SEA MINELIKE"]={type:"path",fill:e?N:O,stroke:e?N:O,d:"m 117.7,75 c 3.5,-3.5 7.1,-7.1 7.1,-7.1 l 7.1,7.1 -7.1,7.1 m -49.5,0 c -3.5,-3.5 -7.1,-7.1 -7.1,-7.1 l 7.1,-7.1 7.1,7.1 M 95,70 c 0,-5 0,-10 0,-10 l 10,0 0,10 m 25,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 16.6,0 30,13.4 30,30 z"},M["SE.IC.NAVIGATIONAL"]={type:"path",fill:!1,stroke:e?N:"red",d:"m 75,90 -10,10 70,0 -10,10"},M["SE.IC.ICEBERG"]={type:"path",fill:e?N:O,stroke:e?N:O,d:"m 75,100 25,-30 25,30 -5,15 -5,-5 -15,20 -15,-20 -5,5 z m -15,0 80,0"},M["SE.IC.FUSED TRACK"]=[a("?"),{type:"path",fill:!1,d:"m 70,65 10,35 -10,35 60,0 -10,-35 10,-35 z"}],M["SE.M1.OWN SHIP"]=l("OWN"),M["SE.M1.ANTIAIR WARFARE"]=l("AAW"),M["SE.M1.ANTISUBMARINE WARFARE"]=l("ASW"),M["SE.M1.ESCORT"]=l("E"),M["SE.M1.ELECTRONIC WARFARE"]=l("EW"),M["SE.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]=l("ISR"),M["SE.M1.MINE COUNTER MEASURES"]=l("MCM"),M["SE.M1.MISSILE DEFENSE"]=l("MD"),M["SE.M1.MEDICAL"]=l("ME"),M["SE.M1.MINE COUNTERMEASURES"]=l("MCM"),M["SE.M1.MINE WARFARE"]=l("MIW"),M["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]=l("RMV"),M["SE.M1.SPECIAL OPERATIONS FORCE"]=l("SOF"),M["SE.M1.SURFACE WARFARE"]=l("SUW"),M["SE.M1.BALLISTIC MISSILE"]=l("B"),M["SE.M1.GUIDED MISSILE"]=l("G"),M["SE.M1.OTHER GUIDED MISSILE"]=l("M"),M["SE.M1.TORPEDO"]=l("T"),M["SE.M1.CYBERSPACE"]=l("CYB"),M["SE.M1.HIJACKER"]=l("HJ"),M["SE.M2.CYBERSPACE"]=r("CYB"),M["SE.M1.DRONE-EQUIPPED"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},M["SE.M1.HELICOPTER-EQUIPPED"]=l("H"),M["SE.M1.BALLISTIC MISSILE DEFENSE, SHOOTER"]=l("BM"),M["SE.M1.BALLISTIC MISSILE DEFENSE, LONG- RANGE SURVEILLANCE AND TRACK (LRS&T)"]=l("ST"),M["SE.M1.SEA-BASE X-BAND"]=l("SBX"),M["SE.M1.HIJACKING/HIJACKED"]=l("H"),M["SE.M2.ANTISUBMARINE WARFARE"]=r("ASW"),M["SE.M2.MINE WARFARE"]=r("MIW"),M["SE.M2.SURFACE WARFARE"]=r("SUW"),M["SE.M2.NUCLEAR POWERED"]=r("N"),M["SE.M2.HEAVY"]=r("H"),M["SE.M2.LIGHT"]=r("L"),M["SE.M2.MEDIUM"]=r("M"),M["SE.M2.DOCK"]=r("D"),M["SE.M2.LOGISTICS"]=r("LOG"),M["SE.M2.TANK"]=r("T"),M["SE.M2.VEHICLE"]=r("V"),M["SE.M2.FAST"]=r("F"),M["SE.M2.AIR-CUSHIONED"]=r("J"),M["SE.M2.AIR-CUSHIONED (USA ONLY)"]=r("AC"),M["SE.M2.HYDROFOIL"]=r("K"),M["SE.M2.AUTONOMOUS CONTROL"]=r("AUT"),M["SE.M2.REMOTELY PILOTED"]=r("RP"),M["SE.M2.EXPENDABLE"]=r("EXP"),M)M.hasOwnProperty(i)&&(I.hasOwnProperty(i)&&console.warn("Override of: "+i),n.call(this,M[i],N),I[i]=M[i])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(L);var P={type:"letter",icons:function(I,t,E,R){I["S-S-------"]=[],I["S-S-C-----"]=[E["SE.IC.COMBATANT"]],I["S-S-CL----"]=[E["SE.IC.SURFACE COMBATANT, LINE"]],I["S-S-CLCV--"]=[E["SE.IC.CARRIER"]],I["S-S-CLBB--"]=[E["SE.IC.BATTLESHIP"]],I["S-S-CLCC--"]=[E["SE.IC.CRUISER"]],I["S-S-CLDD--"]=[E["SE.IC.DESTROYER"]],I["S-S-CLFF--"]=[E["SE.IC.FRIGATE"]],I["S-S-CLLL--"]=[E["SE.IC.LITTORAL COMBATANT SHIP"]],I["S-S-CLLLAS"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.ANTISUBMARINE WARFARE"]],I["S-S-CLLLMI"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.MINE WARFARE"]],I["S-S-CLLLSU"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.SURFACE WARFARE"]],I["S-S-CA----"]=[E["SE.IC.AMPHIBIOUS WARFARE SHIP"]],I["S-S-CALA--"]=[R?E["SE.IC.AMPHIBIOUS ASSAULT"]:E["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]],I["S-S-CALS--"]=[E["SE.IC.LANDING SHIP"]],I["S-S-CALSM-"]=[E["SE.IC.LANDING SHIP"],E["SE.M2.MEDIUM"]],I["S-S-CALST-"]=[E["SE.IC.LANDING SHIP"],E["SE.M2.TANK"]],I["S-S-CALC--"]=[E["SE.IC.LANDING CRAFT"]],I["S-S-CM----"]=[E["SE.IC.MINE WARFARE VESSEL"]],I["S-S-CMML--"]=[E["SE.IC.MINELAYER"]],I["S-S-CMMS--"]=[E["SE.IC.MINESWEEPER"]],I["S-S-CMMH--"]=[E["SE.IC.MINEHUNTER"]],I["S-S-CMMA--"]=[E["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]],I["S-S-CMMD--"]=[E["SE.IC.MINESWEEPER, DRONE"]],I["S-S-CP----"]=[E["SE.IC.PATROL"]],I["S-S-CPSB--"]=[E["SE.IC.PATROL CRAFT"]],I["S-S-CPSU--"]=[E["SE.IC.PATROL ANTI SUBMARINE WARFARE"]],I["S-S-CPSUM-"]=[E["SE.IC.PATROL ANTISHIP MISSILE"]],I["S-S-CPSUT-"]=[E["SE.IC.PATROL TORPEDO"]],I["S-S-CPSUG-"]=[E["SE.IC.PATROL GUN"]],I["S-S-CH----"]=[E["SE.IC.HOVERCRAFT"]],I["S-S-G-----"]=[E["SE.IC.NAVY TASK ORGANIZATION UNIT"]],I["S-S-GF----"]=I["S-S-GT----"]=[E["SE.IC.NAVY TASK FORCE"]],I["S-S-GG----"]=[E["SE.IC.NAVY TASK GROUP"]],I["S-S-GU----"]=[E["SE.IC.NAVY TASK UNIT"]],I["S-S-GE----"]=[E["SE.IC.NAVY TASK ELEMENT"]],I["S-S-GC----"]=[E["SE.IC.CONVOY"]],I["S-S-CD----"]=[E["SE.IC.SEA SURFACE DECOY"]],I["S-S-CU----"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"]],I["S-S-CUM---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.MINE COUNTERMEASURES"]],I["S-S-CUS---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.ANTISUBMARINE WARFARE"]],I["S-S-CUN---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.SURFACE WARFARE"]],I["S-S-CUR---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]],I["S-S-N-----"]=[E["SE.IC.NONCOMBATANT"]],I["S-S-NR----"]=[E["SE.IC.AUXILIARY SHIP"]],I["S-S-NRA---"]=[E["SE.IC.AMMUNITION SHIP"]],I["S-S-NRO---"]=[E["SE.IC.OILER, REPLENISHMENT"]],I["S-S-NF----"]=I["S-S-NFT---"]=[E["SE.IC.TUG, OCEAN GOING"]],I["S-S-NI----"]=[E["SE.IC.INTELLIGENCE COLLECTOR"]],I["S-S-NM----"]=[E["SE.IC.HOSPITAL SHIP"]],I["S-S-NS----"]=[E["SE.IC.SERVICE CRAFT, YARD, GENERAL"]],I["S-S-NR----"]=[E["SE.IC.REPAIR SHIP"]],I["S-S-NTS---"]=[E["SE.IC.SUBMARINE TENDER"]],I["S-S-NH----"]=[E["SE.IC.HOVERCRAFT NONCOMBATANT"]],I["S-S-X-----"]=[],I["S-S-XM----"]=[E["SE.IC.MERCHANT SHIP, GENERAL"]],I["S-S-XMC---"]=[E["SE.IC.CARGO, GENERAL"]],I["S-S-XME---"]=I["S-S-XMR---"]=[E["SE.IC.ROLL ON-ROLL OFF"]],I["S-S-XMO---"]=[E["SE.IC.OILER/TANKER"]],I["S-S-XMT---"]=I["S-S-XMTU--"]=[E["SE.IC.TUG, OCEAN GOING CIVILIAN"]],I["S-S-XMF---"]=[E["SE.IC.FERRY"]],I["S-S-XMP---"]=[E["SE.IC.PASSENGER SHIP"]],I["S-S-XMH---"]=[E["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]],I["S-S-XMD---"]=[E["SE.IC.DREDGE"]],I["S-S-XMTO--"]=[E["SE.IC.TOW"]],I["S-S-XF----"]=[E["SE.IC.FISHING VESSEL"]],I["S-S-XFDF--"]=[E["SE.IC.DRIFTER"]],I["S-S-XFTR--"]=[E["SE.IC.TRAWLER"]],I["S-S-XFDR--"]=[E["SE.IC.FISHING VESSEL DREDGE"]],I["S-S-XR----"]=[E["SE.IC.LEISURE CRAFT, SAILING BOAT"]],I["S-S-XL----"]=[E["SE.IC.LAW ENFORCEMENT VESSEL"]],I["S-S-XH----"]=[E["SE.IC.HOVERCRAFT CIVILIAN"]],I["S-S-XA----"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED"]],I["S-S-XAR---"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]],I["S-S-XAS---"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]],I["S-S-XP----"]=[E["SE.IC.LEISURE CRAFT, JETSKI"]],I["S-S-O-----"]=[E["SE.IC.OWN SHIP"]],I["S-S-E-----"]=[],I["S-S-ED----"]=[E["SE.IC.DITCHED AIRCRAFT"]],I["S-S-EP----"]=[E["SE.IC.PERSON IN WATER"]],I["S-S-EV----"]=[E["SE.IC.DISTRESSED VESSEL"]],I["S-S-Z-----"]=[],I["S-S-ZM----"]=[E["SE.IC.SEA MINELIKE"]],I["S-S-ZN----"]=[E["SE.IC.NAVIGATIONAL"]],I["S-S-ZI----"]=[E["SE.IC.ICEBERG"]]}};function y(I,t,E,R,e,A){var C=t.affiliation||"Friend",T=t.frame,S=t.numberSIDC,N=E.iconColor[C],O=E.iconFillColor[C],G=E.white[C],o=E.black[C],M={};for(var i in M["SU.IC.MILITARY"]=a("MIL"),M["SU.IC.CIVILIAN"]=a("CIV"),M["SU.IC.CIVILIAN"].fill=R||S?O:!T&&O,M["SU.IC.CIVILIAN"].stroke=o,M["SU.IC.CIVILIAN"].strokewidth=3,M["SU.IC.MANUAL TRACK"]=a("MAN"),M["SU.IC.SUBMARINE"]={type:"path",d:"m 75,85 50,0 15,15 -15,15 -50,0 -15,-15 z"},M["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 20,0 0,-10 10,0 0,10 20,0 10,10 -10,10 z"},M["SU.IC.SUBMARINE CONVENTIONAL PROPULSION, SURFACED"]=[{type:"path",d:"m 75,110 -10,-10 10,-10 20,0 0,-10 10,0 0,10 20,0 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],M["SU.IC.SUBMARINE NUCLEAR PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},M["SU.IC.SUBMARINE NUCLEAR PROPULSION, SURFACED"]=[{type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],M["SU.IC.SUBMARINE ATTACK (SSN)"]={type:"text",fill:G,stroke:!1,x:100,y:110,fontsize:30,text:"A"},M["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]={type:"text",fill:G,stroke:!1,x:100,y:110,fontsize:30,text:"M"},M["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]={type:"text",fill:G,stroke:!1,x:100,y:110,fontsize:30,text:"G"},M["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]={type:"text",fill:G,stroke:!1,x:100,y:110,fontsize:30,text:"B"},M["SU.IC.SUBMARINE, SURFACED"]=[{type:"path",d:"m 75,80 50,0 15,15 -15,15 -50,0 -15,-15 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],M["SU.IC.SUBMARINE, BOTTOMED"]=[{type:"path",d:"m 75,80 50,0 15,15 -15,15 -50,0 -15,-15 z"},{type:"path",d:"m 70,120 0,-5 60,0 0,5 z"}],M["SU.IC.SUBMARINE, SNORKELING"]=[{type:"path",d:"m 75,120 -10,-10 10,-10 20,0 0,-20 10,0 0,20 20,0 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,95 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],M["SU.IC.OTHER SUBMERSIBLE"]={type:"path",d:"m 85,90 0,-10 30,0 0,10 m 20,10 c 0,5.5 -15.7,10 -35,10 -19.3,0 -35,-4.5 -35,-10 0,-5.5 15.7,-10 35,-10 19.3,0 35,4.5 35,10 z"},M["SU.IC.OTHER SUBMERSIBLE, SURFACED"]=[M["SU.IC.OTHER SUBMERSIBLE"],{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],M["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},M["SU.IC.NON-SUBMARINE"]=R&&!S?{type:"text",stroke:!1,x:100,y:110,fontsize:35,text:"NON"}:[{type:"text",stroke:!1,x:100,y:100,fontsize:25,text:"NON"},{type:"text",stroke:!1,x:100,y:120,fontsize:25,text:"SUB"}],M["SU.IC.DIVER, MILITARY"]={type:"path",stroke:!1,d:"M 100 80 C 93.7 80 88.3 82.7 85.8 88.3 L 85.8 88.3 L 77.8 88.3 L 77.8 105 L 85.8 105 L 85.8 104.8 C 87.3 108.2 88.8 110 92 111.7 L 92.1 111.7 L 84.2 120 L 115.8 120 L 107.9 111.7 L 108 111.7 C 111.1 110 112.8 108.3 114.3 105 L 122.2 105 L 122.2 88.3 L 114.3 88.3 L 114.3 88.3 C 111.7 82.8 106.3 80 100 80 z M 100 86.6 C 105.4 86.6 109.8 91.1 109.8 96.6 C 109.8 102.1 105.4 106.6 100 106.6 C 94.6 106.6 90.1 102.1 90.1 96.6 C 90.1 91.1 94.6 86.6 100 86.6 z M 100 89.6 C 96.2 89.6 93.1 92.7 93.1 96.6 C 93.1 100.5 96.2 103.6 100 103.6 C 103.8 103.6 106.8 100.5 106.8 96.6 C 106.8 92.7 103.8 89.6 100 89.6 z"},M["SU.IC.SUBMERSIBLE, CIVILIAN"]={type:"path",fill:R?O:!T&&O,d:"m 85,90 0,-10 30,0 0,10 m 20,10 c 0,5.5 -15.7,10 -35,10 -19.3,0 -35,-4.5 -35,-10 0,-5.5 15.7,-10 35,-10 19.3,0 35,4.5 35,10 z"},M["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV), CIVILIAN"]={type:"path",fill:R?O:!T&&O,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},M["SU.M1.CYBERSPACE"]=l("CYB"),M["SU.M1.HIJACKER"]=l("HJ"),M["SU.M2.CYBERSPACE"]=r("CYB"),M["SU.IC.DIVER, CIVILIAN"]={type:"path",fill:O,d:"M 114.3,94 C 114.3,102.3 107.9,109 100,109 c -7.9,0 -14.2,-6.7 -14.2,-15 0,-8.3 6.4,-15 14.2,-15 7.9,0 14.3,6.7 14.3,15 z m 0,27 14.3,15 -57,0 14.3,-15 M 125.7,79 l 14.3,0 0,30 -14.3,0 m -51.3,0 -14.3,0 0,-30 14.3,0 m 54.2,15 c 0,16.6 -12.8,30 -28.5,30 -15.7,0 -28.5,-13.4 -28.5,-30 C 71.5,77.4 84.3,64 100,64 115.7,64 128.5,77.4 128.5,94 z"},M["SU.IC.UNDERWATER WEAPON"]=a("WPN"),M["SU.IC.TORPEDO"]={type:"path",d:"m 65,105 -5,-5 5,-5 60,0 c 0,0 5,5 5,5 l 5,-5 0,10 -5,-5 -5,5 z"},M["SU.IC.IMPROVISED EXPLOSIVE DEVICE (IED)"]=a("IED"),M["SU.IC.UNDERWATER DECOY"]={type:"path",stroke:o,d:R?"M 105,110 90,95 105,80 z M 85,110 70,95 85,80 z m 40,-30 -15,15 15,15 z m -55,40 0,-5 55,0 0,5 z":"M 105,120 90,105 105,90 z M 85,120 70,105 85,90 z m 40,-30 -15,15 15,15 z m -55,-5 0,-5 55,0 0,5 z",fill:R?N:O},M["SU.IC.UNDERWATER DECOY DSymbol"]={type:"path",d:"M 85 81 L 65 98 L 85 119 L 85 81 z M 110 81 L 90 98 L 110 119 L 110 81 z M 135 81 L 115 98 L 135 119 L 135 81 z"},M["SU.IC.ECHO TRACKER CLASSIFIER (ETC)/POSSIBLE CONTACT (POSCON)"]={type:"text",stroke:!1,x:100,y:130,fontsize:60,text:"?"},M["SU.IC.FUSED TRACK"]=[a("?"),{type:"path",fill:!1,d:"m 70,65 10,35 -10,35 60,0 -10,-35 10,-35"}],M["SU.IC.SEA MINE"]={type:"path",fill:!R&&!S||e?O:E.iconColor.Hostile,stroke:!R&&!S||e?N:o,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},M["SU.IC.SEA MINE - BOTTOM"]=[M["SU.IC.SEA MINE"],{type:"path",fill:!R&&!S||e?O:E.iconColor.Hostile,stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE - MOORED"]=[M["SU.IC.SEA MINE"],{type:"path",fill:!R&&!S||e?O:E.iconColor.Hostile,stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE - FLOATING"]=[M["SU.IC.SEA MINE"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE - RISING"]=[M["SU.IC.SEA MINE"],{type:"path",fill:S&&A?"":!R&&!S||e?O:E.iconColor.Hostile,stroke:!R&&!S||e?N:o,d:"m 100,128 -10,15 20,0 z"}],M["SU.IC.SEA MINE (IN OTHER POSITION)"]=[M["SU.IC.SEA MINE"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 130,100 15,0 M 70,100 l -15,0"}],M["SU.IC.SEA MINE - KINGFISHER"]=[M["SU.IC.SEA MINE"],{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"K"}],M["SU.IC.SEA MINE - SMALL OBJECT"]=[M["SU.IC.SEA MINE"],{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"SO"}],M["SU.IC.SEA MINE EXERCISE MINE"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"EX"},S?[]:{type:"text",stroke:!1,fill:!R&&!S||e?N:o,x:150,y:46,fontsize:40,text:"X"}],M["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]=[M["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE EXERCISE MINE - MOORED"]=[M["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]=[M["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE EXERCISE MINE - RISING"]=[M["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 100,128 -10,15 20,0 z"}],M["SU.IC.SEA MINE DECOY"]={type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 106.6,101.6 0,26.3 -13.1,-13.1 z m -19.7,0 0,26.3 -13.1,-13.1 z m 39.4,0 0,26.3 -13.1,-13.1 13.1,-13.1 M 100,75.3 c -14.5,0 -26.3,11.8 -26.3,26.3 l 52.5,0 C 126.3,87.1 114.5,75.3 100,75.3 z m -6.6,0 0,-13.1 13.1,0 0,13.1 m -29.8,12.3 -9.3,-9.3 9.3,-9.3 9.3,9.3 m 27.9,0 9.3,-9.3 9.3,9.3 -9.3,9.3"},M["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]=[M["SU.IC.SEA MINE DECOY"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE DECOY, MOORED"]=[M["SU.IC.SEA MINE DECOY"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 75,140 50,0 M 100,100 l 0,40"}],M["SU.IC.SEA MINE NEUTRALIZED"]=[{type:"path",fill:!R&&!S||e?O:E.iconColor.Neutral,stroke:!R&&!S||e?N:o,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},{type:"path",strokewidth:5,stroke:A?G:o,d:"m 135,65 -70,70 m 0,-70 70,70"}],M["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]=[M["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!R&&!S||e?O:E.iconColor.Neutral,stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE NEUTRALIZED - MOORED"]=[M["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!R&&!S||e?O:E.iconColor.Neutral,stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]=[M["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE NEUTRALIZED - RISING"]=[M["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!R&&!S||e?O:E.iconColor.Neutral,stroke:!R&&!S||e?N:o,d:"m 100,128 -10,15 20,0 z"}],M["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]=[M["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 130,100 15,0 M 70,100 l -15,0"}],M["SU.IC.SEA MINE MILEC"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"E"}],M["SU.IC.SEA MINE MILEC - BOTTOM"]=[M["SU.IC.SEA MINE MILEC"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE MILEC - MOORED"]=[M["SU.IC.SEA MINE MILEC"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE MILEC - FLOATING"]=[M["SU.IC.SEA MINE MILEC"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE MINE ANCHOR"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!(!R&&!S||e)&&o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:105,fontsize:18,text:"ANCR"}],M["SU.IC.SEA MINE MILCO"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,141,42)",stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},S?[]:{type:"text",stroke:!1,fill:!R&&!S||e?N:o,x:100,y:112,fontsize:30,text:"#"}],M["SU.IC.SEA MINE MILCO - BOTTOM"]=[M["SU.IC.SEA MINE MILCO"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,141,42)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE MILCO - MOORED"]=[M["SU.IC.SEA MINE MILCO"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE MILCO - FLOATING"]=[M["SU.IC.SEA MINE MILCO"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]={type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"1"},M["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]={type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"2"},M["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]={type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"3"},M["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]={type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"4"},M["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]={type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:110,fontsize:35,text:"5"},M["SU.IC.SEA MINE NEGATIVE REACQUISITION"]=[{type:"path",strokedasharray:"8,4",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"NR"}],M["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]=[M["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]=[M["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]=[M["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.SEA MINE GENERAL OBSTRUCTOR"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(255,255,0)",stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"OB"}],M["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]=[{type:"path",fill:!R&&!S||e?O:E.iconColor.Neutral,stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:!R&&!S||e||A?G:o,x:100,y:112,fontsize:30,text:"OB"},{type:"path",strokewidth:5,stroke:A?G:o,d:"m 135,65 -70,70 m 0,-70 70,70"}],M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"]=[{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:e||(!R&&!S||A?G:o),x:100,y:112,fontsize:30,text:"N"}],M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]=[M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]=[M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!R&&!S||e?O:A?o:"rgb(0, 130, 24)",stroke:!R&&!S||e?N:o,d:"m 75.5,136.8 49,0 M 100,124.5 l 0,12.3"}],M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]=[M["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!1,stroke:!R&&!S||e?N:o,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],M["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]=[{type:"path",strokedasharray:"8,4",fill:!1,stroke:!R&&!S||e?N:E.iconColor.Hostile,d:"m 85,65 30,0 20,20 0,30 -20,20 -30,0 -20,-20 0,-30 z"},{type:"text",stroke:!1,fill:!R&&!S||e?N:E.iconColor.Hostile,x:100,y:110,fontsize:30,text:"UXO"}],M["SU.IC.ENVIRONMENTAL REPORT LOCATION"]=[{type:"path",fill:!1,stroke:!R&&!S||e?N:E.iconColor.Neutral,d:"m 70,70 0,60 60,0 0,-60 z"},{type:"text",stroke:!1,fill:!R&&!S||e?N:E.iconColor.Neutral,x:100,y:122,fontsize:60,text:"E"}],M["SU.IC.DIVE REPORT LOCATION"]=[{type:"path",fill:!1,stroke:!R&&!S||e?N:E.iconColor.Neutral,d:"m 70,70 0,60 60,0 0,-60 z"},{type:"text",stroke:!1,fill:!R&&!S||e?N:E.iconColor.Neutral,x:100,y:122,fontsize:60,text:"D"}],M["SU.IC.SEABED INSTALLATION/MANMADE"]={type:"path",fill:O,stroke:o,d:"m 140,125 -80,0 10,-30 10,20 20,-50 20,50 10,-25 z"},M["SU.IC.SEABED INSTALLATION, MAN-MADE, MILITARY"]={type:"path",d:"m 75,80 0,40 50,0 0,-15 -15,0 0,-10 -20,0 0,-15 z"},M["SU.IC.SEABED INSTALLATION, MAN-MADE, NON-MILITARY"]={type:"path",fill:O,d:"m 75,80 0,40 50,0 0,-15 -15,0 0,-10 -20,0 0,-15 z"},M["SU.IC.SEABED ROCK/STONE, OBSTACLE, OTHER"]={type:"path",d:"m 140,125 -80,0 10,-30 10,20 20,-50 20,50 10,-25 z"},M["SU.IC.WRECK"]={type:"path",d:"m 125,85 0,30 m -50,-30 0,30 m 25,-40 0,45 m -40,-20 80,0"},M["SU.IC.MARINE LIFE"]={type:"path",d:"m 60,100 20,-20 45,20 15,-10 0,20 -15,-10 -45,20 z"},M["SU.IC.SEA ANOMALY"]={type:"path",fill:!1,d:"m 65,100 15,-20 20,30 20,-30 15,20 m -70,10 15,-20 20,30 20,-30 15,20"},M["SU.M1.ANTISUBMARINE WARFARE"]=l("ASW"),M["SU.M1.AUXILIARY"]=l("AUX"),M["SU.M1.COMMAND AND CONTROL"]=l("C2"),M["SU.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]=l("ISR"),M["SU.M1.MINE COUNTERMEASURES"]=l("MCM"),M["SU.M1.MINE WARFARE"]=l("MIW"),M["SU.M1.SURFACE WARFARE"]=l("SUW"),M["SU.M1.ATTACK"]=l("A"),M["SU.M1.BALLISTIC MISSILE"]=l("B"),M["SU.M1.GUIDED MISSILE"]=l("G"),M["SU.M1.OTHER GUIDED MISSILES (POINT DEFENCE)"]=l("M"),M["SU.M1.SPECIAL OPERATIONS FORCE"]=l("SOF"),M["SU.M1.POSSIBLE SUBMARINE - LOW 1"]=l("P1"),M["SU.M1.POSSIBLE SUBMARINE - LOW 2"]=l("P2"),M["SU.M1.POSSIBLE SUBMARINE - HIGH 3"]=l("P3"),M["SU.M1.POSSIBLE SUBMARINE - HIGH 4"]=l("P4"),M["SU.M1.PROBABLE SUBMARINE"]=l("PB"),M["SU.M1.CERTAIN SUBMARINE"]=l("CT"),M["SU.M1.ANTI-TORPEDO TORPEDO"]=l("ATT"),M["SU.M1.HIJACKING/HIJACKED"]=l("H"),M["SU.M2.POSSIBLE SUBMARINE - LOW 1"]=r("P1"),M["SU.M2.POSSIBLE SUBMARINE - LOW 2"]=r("P2"),M["SU.M2.POSSIBLE SUBMARINE - HIGH 3"]=r("P3"),M["SU.M2.POSSIBLE SUBMARINE - HIGH 4"]=r("P4"),M["SU.M2.PROBABLE SUBMARINE"]=r("PB"),M["SU.M2.AIR INDEPENDENT PROPULSION"]=r("AI"),M["SU.M2.CERTSUB"]=r("CT"),M["SU.M2.DIESEL PROPULSION"]=r("D"),M["SU.M2.DIESEL - TYPE 1"]=r("D1"),M["SU.M2.DIESEL - TYPE 2"]=r("D2"),M["SU.M2.DIESEL - TYPE 3"]=r("D3"),M["SU.M2.NUCLEAR POWERED"]=r("N"),M["SU.M2.NUCLEAR - TYPE 1"]=r("N1"),M["SU.M2.NUCLEAR - TYPE 2"]=r("N2"),M["SU.M2.NUCLEAR - TYPE 3"]=r("N3"),M["SU.M2.NUCLEAR - TYPE 4"]=r("N4"),M["SU.M2.NUCLEAR - TYPE 5"]=r("N5"),M["SU.M2.NUCLEAR - TYPE 6"]=r("N6"),M["SU.M2.NUCLEAR - TYPE 7"]=r("N7"),M["SU.M2.AUTONOMOUS CONTROL"]=r("AUT"),M["SU.M2.REMOTELY PILOTED"]=r("RP"),M["SU.M2.EXPENDABLE"]=r("EXP"),M)M.hasOwnProperty(i)&&(I.hasOwnProperty(i)&&console.warn("Override of: "+i),n.call(this,M[i],N),I[i]=M[i])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(y);var c={type:"letter",icons:function(I,t,E,R){I["S-U-------"]=[],I["S-U-S-----"]=[E["SU.IC.SUBMARINE"]],I["S-U-SF----"]=[E["SU.IC.SUBMARINE, SURFACED"]],I["S-U-SB----"]=[E["SU.IC.SUBMARINE, BOTTOMED"]],I["S-U-SR----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.CERTSUB"]],I["S-U-SX----"]=[E["SU.IC.NON-SUBMARINE"]],I["S-U-SN----"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"]],I["S-U-SNF---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION, SURFACED"]],I["S-U-SNA---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE ATTACK (SSN)"]],I["S-U-SNM---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]],I["S-U-SNG---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]],I["S-U-SNB---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]],I["S-U-SC----"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"]],I["S-U-SCF---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION, SURFACED"]],I["S-U-SCA---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE ATTACK (SSN)"]],I["S-U-SCM---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]],I["S-U-SCG---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]],I["S-U-SCB---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]],I["S-U-SO----"]=[E["SU.IC.OTHER SUBMERSIBLE"]],I["S-U-SOF---"]=[E["SU.IC.OTHER SUBMERSIBLE, SURFACED"]],I["S-U-SU----"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],I["S-U-SUM---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.MINE COUNTERMEASURES"]],I["S-U-SUS---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.ANTISUBMARINE WARFARE"]],I["S-U-SUN---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.SURFACE WARFARE"]],I["S-U-S1----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - LOW 1"]],I["S-U-S2----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - LOW 2"]],I["S-U-S3----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - HIGH 3"]],I["S-U-S4----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - HIGH 4"]],I["S-U-SL----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.PROBABLE SUBMARINE"]],I["S-U-SK----"]=[E["SU.IC.SUBMARINE, SNORKELING"]],I["S-U-W-----"]=[E["SU.IC.UNDERWATER WEAPON"]],I["S-U-WT----"]=[E["SU.IC.TORPEDO"]],I["S-U-WM----"]=[E["SU.IC.SEA MINE"]],I["S-U-WMD---"]=[E["SU.IC.SEA MINE NEUTRALIZED"]],I["S-U-WMG---"]=[E["SU.IC.SEA MINE - BOTTOM"]],I["S-U-WMGD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]],I["S-U-WMGX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]],I["S-U-WMGE--"]=[E["SU.IC.SEA MINE MILEC - BOTTOM"]],I["S-U-WMGC--"]=[E["SU.IC.SEA MINE MILCO - BOTTOM"]],I["S-U-WMGR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]],I["S-U-WMGO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]],I["S-U-WMM---"]=[E["SU.IC.SEA MINE - MOORED"]],I["S-U-WMMD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - MOORED"]],I["S-U-WMMX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - MOORED"]],I["S-U-WMME--"]=[E["SU.IC.SEA MINE MILEC - MOORED"]],I["S-U-WMMC--"]=[E["SU.IC.SEA MINE MILCO - MOORED"]],I["S-U-WMMR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]],I["S-U-WMMO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]],I["S-U-WMF---"]=[E["SU.IC.SEA MINE - FLOATING"]],I["S-U-WMFD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]],I["S-U-WMFX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]],I["S-U-WMFE--"]=[E["SU.IC.SEA MINE MILEC - FLOATING"]],I["S-U-WMFC--"]=[E["SU.IC.SEA MINE MILCO - FLOATING"]],I["S-U-WMFR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]],I["S-U-WMFO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]],I["S-U-WMO---"]=[E["SU.IC.SEA MINE (IN OTHER POSITION)"]],I["S-U-WMOD--"]=[E["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]],I["S-U-WMX---"]=[E["SU.IC.SEA MINE EXERCISE MINE"]],I["S-U-WME---"]=[E["SU.IC.SEA MINE MILEC"]],I["S-U-WMA---"]=[E["SU.IC.SEA MINE MINE ANCHOR"]],I["S-U-WMC---"]=[E["SU.IC.SEA MINE MILCO"]],I["S-U-WMR---"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION"]],I["S-U-WMB---"]=[E["SU.IC.SEA MINE GENERAL OBSTRUCTOR"]],I["S-U-WMBD--"]=[E["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]],I["S-U-WMN---"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"]],I["S-U-WMS---"]=[E["SU.IC.SEA MINE - RISING"]],I["S-U-WMSX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - RISING"]],I["S-U-WMSD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - RISING"]],I["S-U-WV----"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],I["S-U-WD----"]=[E["SU.IC.UNDERWATER DECOY"]],I["S-U-WDM---"]=[E["SU.IC.SEA MINE DECOY"]],I["S-U-WDMG--"]=[E["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]],I["S-U-WDMM--"]=[E["SU.IC.SEA MINE DECOY, MOORED"]],I["S-U-N-----"]=[E["SU.IC.NON-SUBMARINE"]],I["S-U-ND----"]=[E["SU.IC.DIVER, CIVILIAN"]],I["S-U-NB----"]=[],I["S-U-E-----"]=[E["SU.IC.ENVIRONMENTAL REPORT LOCATION"]],I["S-U-V-----"]=[E["SU.IC.DIVE REPORT LOCATION"]],I["S-U-X-----"]=[E["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]],I["S-U-NBS---"]=[E["SU.IC.SEABED INSTALLATION/MANMADE"]],I["S-U-NBR---"]=[E["SU.IC.SEABED ROCK/STONE, OBSTACLE, OTHER"]],I["S-U-NBW---"]=[E["SU.IC.WRECK"]],I["S-U-NM----"]=[E["SU.IC.MARINE LIFE"]],I["S-U-NA----"]=[E["SU.IC.SEA ANOMALY"]]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G),s.addIconParts(N);var h={type:"letter",icons:function(I,t,E,R){I["S-F-------"]=[E["GR.IC.SPECIAL OPERATIONS FORCES"]],I["S-F-A-----"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-AF----"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-AFA---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.ATTACK"]],I["S-F-AFK---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.REFUEL"]],I["S-F-AFU---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.UTILITY"]],I["S-F-AFUL--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.LIGHT"]],I["S-F-AFUM--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.MEDIUM"]],I["S-F-AFUH--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.HEAVY"]],I["S-F-AV----"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.VSTOL"]],I["S-F-AH----"]=R?[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["GR.IC.AVIATION ROTARY WING 2525C"]]:[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-AHH---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.COMBAT SEARCH AND RESCUE"]],I["S-F-AHA---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.ATTACK"]],I["S-F-AHU---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.UTILITY"]],I["S-F-AHUL--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.LIGHT"]],I["S-F-AHUM--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.MEDIUM"]],I["S-F-AHUH--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.HEAVY"]],I["S-F-SN----"]=I["S-F-N-----"]=[E["GR.IC.NAVAL"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-SNS---"]=I["S-F-NS----"]=[E["GR.IC.SEA-AIR-LAND"]],I["S-F-SNU---"]=I["S-F-NU----"]=[E["SOF.IC.UNDERWATER DEMOLITION TEAM"]],I["S-F-SNB---"]=I["S-F-NB----"]=[E["GR.IC.COMBATANT"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-SNN---"]=I["S-F-NN----"]=[E["GR.IC.SUBMARINE NUCLEAR PROPULSION"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],I["S-F-G-----"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.SPECIAL OPERATIONS FORCES"]],I["S-F-GS----"]=[E["GR.IC.SPECIAL FORCES"]],I["S-F-GR----"]=I["S-F-GSR---"]=[E["GR.IC.FF.INFANTRY"],E["AIR.M1.RECONNAISSANCE"],E["GR.M2.AIRBORNE"]],I["S-F-GP----"]=I["S-F-GSP---"]=[E["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]],I["S-F-GPA---"]=I["S-F-GSPA--"]=[E["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"],s._translate(0,-30,s._scale(.7,E["AR.I.MILITARY FIXED WING"]))],I["S-F-GC----"]=I["S-F-GCA---"]=[E["GR.IC.CIVIL AFFAIRS"]],I["S-F-GB----"]=I["S-F-B-----"]=[E["GR.IC.SPECIAL OPERATIONS FORCES"],E["GR.M2.SUPPORT"]]}};function x(I,t,E,R,e,A){var C=t.affiliation||"Friend",T=E.iconColor[C],S={"SI.IC.COMMUNICATIONS":{type:"path",d:"m 93,120 14,0 0,0 m -7,-27 0,27 m 2,-25 8,2 -5,5 13,3 m -20,-10 -8,2 5,5 -14,3 m 21,-13 8,-2 -5,-5 13,-3 m -37,0 14,3 -5,5 8,2",fill:!1},"SI.IC.RADAR":{type:"path",d:"m 115,90 -15,15 0,-15 -15,15 M 80,85 c 0,25 15,35 35,35",fill:!1}};for(var N in S["SI.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]=a("J"),S["SI.M1.ANTI-AIRCRAFT FIRE CONTROL"]=l("AA"),S["SI.M1.AIRBORNE SEARCH AND BOMBING"]=l("AB"),S["SI.M1.AIRBORNE INTERCEPT"]=l("AI"),S["SI.M1.ALTIMETER"]=l("AL"),S["SI.M1.AIRBORNE RECONNAISSANCE AND MAPPING"]=l("AM"),S["SI.M1.AIR TRAFFIC CONTROL"]=l("AT"),S["SI.M1.BEACON TRANSPONDER (NOT IFF)"]=l("BN"),S["SI.M1.BATTLEFIELD SURVEILLANCE"]=l("BS"),S["SI.M1.CONTROLLED APPROACH"]=l("CA"),S["SI.M1.CONTROLLED INTERCEPT"]=l("CI"),S["SI.M1.CELLULAR/MOBILE"]=l("CM"),S["SI.M1.COASTAL SURVEILLANCE"]=l("CS"),S["SI.M1.CYBER"]=l("CYB"),S["SI.M1.DECOY/MIMIC"]=l("DC"),S["SI.M1.DATA TRANSMISSION"]=l("DT"),S["SI.M1.EARTH SURVEILLANCE"]=l("ES"),S["SI.M1.EARLY WARNING"]=l("EW"),S["SI.M1.FIRE CONTROL"]=l("FC"),S["SI.M1.GROUND MAPPING"]=l("GM"),S["SI.M1.HEIGHT FINDING"]=l("HF"),S["SI.M1.HARBOR SURVEILLANCE"]=l("HS"),S["SI.M1.IDENTIFICATION, FRIEND OR FOE (INTERROGATOR)"]=l("IF"),S["SI.M1.INSTRUMENT LANDING SYSTEM"]=l("IL"),S["SI.M1.IONOSPHERIC SOUNDING"]=l("IS"),S["SI.M1.IDENTIFICATION, FRIEND OR FOE (TRANSPONDER)"]=l("IT"),S["SI.M1.BARRAGE JAMMER"]=l("JB"),S["SI.M1.CLICK JAMMER"]=l("JC"),S["SI.M1.DECEPTIVE JAMMER"]=l("JD"),S["SI.M1.FREQUENCY SWEPT JAMMER"]=l("JF"),S["SI.M1.JAMMER (GENERAL)"]=l("JG"),S["SI.M1.NOISE JAMMER"]=l("JN"),S["SI.M1.PULSED JAMMER"]=l("JP"),S["SI.M1.REPEATER JAMMER"]=l("JR"),S["SI.M1.SPOT NOISE JAMMER"]=l("JS"),S["SI.M1.TRANSPONDER JAMMER"]=l("JT"),S["SI.M1.MISSILE ACQUISITION"]=l("MA"),S["SI.M1.MISSILE CONTROL"]=l("MC"),S["SI.M1.MISSILE DOWNLINK"]=l("MD"),S["SI.M1.METEOROLOGICAL"]=l("ME"),S["SI.M1.MULTI-FUNCTION"]=l("MF"),S["SI.M1.MISSILE GUIDANCE"]=l("MG"),S["SI.M1.MISSILE HOMING"]=l("MH"),S["SI.M1.MISSILE TRACKING"]=l("MT"),S["SI.M1.NAVIGATIONAL/GENERAL"]=l("NA"),S["SI.M1.NAVIGATIONAL/DISTANCE MEASURING EQUIPMENT"]=l("ND"),S["SI.M1.NAVIGATION/TERRAIN FOLLOWING"]=l("NT"),S["SI.M1.NAVIGATIONAL/WEATHER AVOIDANCE"]=l("NW"),S["SI.M1.OMNI-LINE OF SIGHT (LOS)"]=l("OL"),S["SI.M1.PROXIMITY USE"]=l("PF"),S["SI.M1.POINT-TO-POINT LINE OF SIGHT (LOS)"]=l("PP"),S["SI.M1.INSTRUMENTATION"]=l("RI"),S["SI.M1.RANGE ONLY"]=l("RO"),S["SI.M1.SONOBUOY"]=l("SB"),S["SI.M1.SATELLITE DOWNLINK"]=l("SD"),S["SI.M1.SPACE"]=l("SP"),S["SI.M1.SURFACE SEARCH"]=l("SS"),S["SI.M1.SHELL TRACKING"]=l("ST"),S["SI.M1.SATELLITE UPLINK"]=l("SU"),S["SI.M1.TARGET ACQUISITION"]=l("TA"),S["SI.M1.TARGET ILLUMINATION"]=l("TI"),S["SI.M1.TROPOSPHERIC SCATTER"]=l("TS"),S["SI.M1.TARGET TRACKING"]=l("TT"),S["SI.M1.UNKNOWN"]=l("UN"),S["SI.M1.VIDEO REMOTING"]=l("VR"),S["SI.M1.EXPERIMENTAL"]=l("XP"),S["SI.M1.ALPHA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"A"},S["SI.M1.BRAVO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"B"},S["SI.M1.CHARLIE"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"C"},S["SI.M1.DELTA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"D"},S["SI.M1.ECHO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"E"},S["SI.M1.FOXTROT"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"F"},S["SI.M1.HOTEL"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"H"},S["SI.M1.INDY"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"I"},S["SI.M1.MIKE"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"M"},S["SI.M1.OSCAR"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"O"},S["SI.M1.PAPA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"P"},S["SI.M1.SIERRA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"S"},S["SI.M1.TANGO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"T"},S["SI.M1.UNIFORM"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"U"},S["SI.M2.ALPHA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"A"},S["SI.M2.BRAVO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"B"},S["SI.M2.CHARLIE"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"C"},S["SI.M2.CYBER"]=r("CYB"),S["SI.M2.DELTA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"D"},S["SI.M2.ECHO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"E"},S["SI.M2.FOXTROT"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"F"},S["SI.M2.GOLF"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"G"},S["SI.M2.INDY"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"I"},S["SI.M2.LIMA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"L"},S["SI.M2.MIKE"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"M"},S["SI.M2.NOVEMBER"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"N"},S["SI.M2.PAPA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"P"},S["SI.M2.SIERRA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"S"},S["SI.M2.TANGO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"T"},S["SI.M2.UNIFORM"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"U"},S["SI.M2.WHISKEY"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"W"},S["SI.M3.SPACE"]={type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"S"},S["SI.M3.GROUND"]={type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"G"},S)S.hasOwnProperty(N)&&(I.hasOwnProperty(N)&&console.warn("Override of: "+N),n.call(this,S[N],T),I[N]=S[N])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(x);var U={type:"letter",icons:function(I,t,E,R){I["I-P-S-----"]=[],I["I-P-SC----"]=[],I["I-P-SCD---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.DELTA"],E["SI.M3.SPACE"]],I["I-P-SR----"]=[],I["I-P-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"],E["SI.M3.SPACE"]],I["I-P-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.SIERRA"],E["SI.M3.SPACE"]],I["I-P-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"],E["SI.M3.SPACE"]],I["I-P-SRM---"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"],E["SI.M3.SPACE"]],I["I-P-SRT---"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"],E["SI.M3.SPACE"]],I["I-P-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.PAPA"],E["SI.M3.SPACE"]],I["I-P-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"],E["SI.M3.SPACE"]],I["I-A-S-----"]=[],I["I-A-SC----"]=[],I["I-A-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"]],I["I-A-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],I["I-A-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],I["I-A-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],I["I-A-SR----"]=[],I["I-A-SRAI--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.INDY"]],I["I-A-SRAS--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.BRAVO"]],I["I-A-SRC---"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.INDY"]],I["I-A-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],I["I-A-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],I["I-A-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"]],I["I-A-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"]],I["I-A-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"]],I["I-A-SRMD--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.DELTA"]],I["I-A-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"]],I["I-A-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"]],I["I-A-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],I["I-A-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"]],I["I-A-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],I["I-A-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"]],I["I-A-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]],I["I-G-S-----"]=[],I["I-G-SC----"]=[],I["I-G-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"],E["SI.M3.GROUND"]],I["I-G-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"],E["SI.M3.GROUND"]],I["I-G-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"],E["SI.M3.GROUND"]],I["I-G-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"],E["SI.M3.GROUND"]],I["I-G-SCT---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.TANGO"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],I["I-G-SR----"]=[],I["I-G-SRAT--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],I["I-G-SRAA--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],I["I-G-SRB---"]=[E["SI.IC.RADAR"],E["SI.M1.BRAVO"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],I["I-G-SRCS--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],I["I-G-SRCA--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],I["I-G-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],I["I-G-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"],E["SI.M3.GROUND"]],I["I-G-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"],E["SI.M3.GROUND"]],I["I-G-SRH---"]=[E["SI.IC.RADAR"],E["SI.M1.HOTEL"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],I["I-G-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],I["I-G-SRMM--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ECHO"],E["SI.M3.GROUND"]],I["I-G-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],I["I-G-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"],E["SI.M3.GROUND"]],I["I-G-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],I["I-G-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],I["I-G-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],I["I-G-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],I["I-G-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"],E["SI.M3.GROUND"]],I["I-G-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],I["I-G-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"],E["SI.M3.GROUND"]],I["I-S-S-----"]=[],I["I-S-SC----"]=[],I["I-S-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"]],I["I-S-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],I["I-S-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],I["I-S-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],I["I-S-SR----"]=[],I["I-S-SRAT--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.TANGO"]],I["I-S-SRAA--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.ALPHA"]],I["I-S-SRCA--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.ALPHA"]],I["I-S-SRCI--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.INDY"]],I["I-S-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],I["I-S-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],I["I-S-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"]],I["I-S-SRH---"]=[E["SI.IC.RADAR"],E["SI.M1.HOTEL"],E["SI.M2.FOXTROT"]],I["I-S-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"]],I["I-S-SRMM--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ECHO"]],I["I-S-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"]],I["I-S-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"]],I["I-S-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"]],I["I-S-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],I["I-S-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.SIERRA"]],I["I-S-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],I["I-S-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"]],I["I-S-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"]],I["I-S-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]],I["I-U-S-----"]=[],I["I-U-SC----"]=[],I["I-U-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],I["I-U-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],I["I-U-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],I["I-U-SR----"]=[],I["I-U-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],I["I-U-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],I["I-U-SRM---"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],I["I-U-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.SIERRA"]],I["I-U-SRT---"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],I["I-U-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G);var d={type:"letter",icons:function(I,t,E,R){I["O-V-A-----"]=[E["ST.IC.ARSON/FIRE"]],I["O-V-M-----"]=[E["ST.IC.KILLING VICTIM"]],I["O-V-MA----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.MURDER"]],I["O-V-MB----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.EXECUTION (WRONGFUL KILLING)"]],I["O-V-MC----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.ASSASSINATION"]],I["O-V-B-----"]=[E["ST.IC.BOMB"]],I["O-V-Y-----"]=[E["ST.IC.BOOBY TRAP"]],I["O-V-D-----"]=[E["ST.IC.DRIVE-BY SHOOTING"]],I["O-V-S-----"]=[E["ST.IC.SNIPING"]],I["O-V-P-----"]=[E["ST.IC.POISONING"]],I["O-V-E-----"]=[E["ST.IC.EXPLOSION"]],I["O-V-EI----"]=[E["ST.IC.EXPLOSION"],E["ST.IC.IED"]],I["O-L-B-----"]=[E["ST.IC.BLACK LIST LOCATION"]],I["O-L-G-----"]=[E["ST.IC.GRAY LIST LOCATION"]],I["O-L-W-----"]=[E["ST.IC.WHITE LIST LOCATION"]],I["O-L-M-----"]=[E["ST.IC.MASS GRAVE LOCATION"]],I["O-O-P-----"]=[E["ST.IC.PATROLLING"]],I["O-O-R-----"]=[],I["O-O-RW----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.WILLING"]],I["O-O-RC----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.COERCED/IMPRESSED"]],I["O-O-D-----"]=[E["ST.IC.DEMONSTRATION"]],I["O-O-M-----"]=[E["ST.IC.MINE LAYING"]],I["O-O-Y-----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"]],I["O-O-YT----"]=[E["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]],I["O-O-YW----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],I["O-O-YH----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.HOUSE-TO-HOUSE"]],I["O-O-F-----"]=[E["ST.IC.SEARCHING"]],I["O-O-S-----"]=[E["ST.IC.SPY"]],I["O-O-O-----"]=[E["ST.IC.FOOD DISTRIBUTION"]],I["O-O-E-----"]=[E["ST.IC.EXTORTION"]],I["O-O-H-----"]=[],I["O-O-HT----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],I["O-O-HA----"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],I["O-O-HV----"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],I["O-O-K-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"]],I["O-O-KA----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"],E["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],I["O-O-A-----"]=[E["ST.IC.ARREST"]],I["O-O-U-----"]=[E["ST.IC.DRUG RELATED ACTIVITIES"]],I["O-O-C-----"]=[E["ST.IC.COMPOSITE LOSS"]],I["O-O-CA----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.COMBAT"]],I["O-O-CB----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.ACCIDENT"]],I["O-O-CC----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.OTHER"]],I["O-I-R-----"]=[E["ST.IC.GROUP"]],I["O-I-S-----"]=[E["ST.IC.SAFE HOUSE"]],I["O-I-G-----"]=[E["ST.IC.GRAFFITI"]],I["O-I-V-----"]=[E["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]],I["O-I-I-----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"]],I["O-I-D-----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.DRUG"]],I["O-I-F-----"]=[E["ST.IC.INTERNAL SECURITY FORCE"]],I["O-P-------"]=[E["ST.IC.INDIVIDUAL"]],I["O-P-A-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.LEADER"]],I["O-P-B-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.TARGETED"]],I["O-P-C-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.TERRORIST"]],I["O-G-------"]=[E["ST.IC.GROUP"]],I["O-G-A-----"]=[E["ST.IC.GROUP"],E["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],I["O-G-B-----"]=[E["ST.IC.GROUP"],E["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],I["O-G-C-----"]=[E["ST.IC.GROUP"],E["ST.M1.TERRORIST"]],I["O-G-D-----"]=[E["ST.IC.GROUP"],E["ST.M1.RELIGIOUS"]],I["O-G-E-----"]=[E["ST.IC.GROUP"],E["ST.M1.FOREIGN FIGHTERS"]],I["O-G-F-----"]=[E["ST.IC.GROUP"],E["ST.M1.GANG"]],I["O-R-------"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.RAPE"]],I["O-R-A-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.RAPE"],E["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(G);var p={type:"letter",icons:function(I,t,E,R){I["E-I-A-----"]=[E["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]],I["E-I-AC----"]=[E["ST.IC.GROUP"],E["AC.M1.RIOT"]],I["E-I-B-----"]=[E["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]],I["E-I-BA----"]=[E["ST.IC.BOMB"],E["AC.M1.THREAT"]],I["E-I-BC----"]=[E["ST.IC.EXPLOSION"],s._scale(.6,E["ST.IC.BOMB"])],I["E-I-BD----"]=[E["ST.IC.GROUP"],E["ST.M1.LOOT"]],I["E-I-BF----"]=[E["AC.IC.SHOOTING"]],I["E-I-C-----"]=[E["AC.IC.FIRE EVENT"]],I["E-I-CA----"]=[E["AC.IC.HOT SPOT"]],I["E-I-CB----"]=[E["AC.IC.NON-REsIdENTIAL FIRE"]],I["E-I-CC----"]=[E["AC.IC.FIRE ORIGIN"]],I["E-I-CD----"]=[E["AC.IC.REsIdENTIAL FIRE"]],I["E-I-CE----"]=[E["AC.IC.SCHOOL FIRE"]],I["E-I-CF----"]=[E["AC.IC.SMOKE"]],I["E-I-CG----"]=[E["AC.IC.SPECIAL NEEDS FIRE"]],I["E-I-CH----"]=[E["AC.IC.WILD FIRE"]],I["E-I-D-----"]=[E["AC.IC.HAZARDOUS MATERIALS INCIDENT"]],I["E-I-DA----"]=[E["AC.IC.CHEMICAL AGENT"]],I["E-I-DB----"]=[E["AC.IC.CORROSIVE MATERIAL"]],I["E-I-DC----"]=[E["AC.IC.HAZARDOUS WHEN WET"]],I["E-I-DD----"]=[E["AC.IC.EXPLOSIVE MATERIAL"]],I["E-I-DE----"]=[E["AC.IC.FLAMMABLE GAS"]],I["E-I-DF----"]=[E["AC.IC.FLAMMABLE LIQUID"]],I["E-I-DG----"]=[E["AC.IC.FLAMMABLE SOLID"]],I["E-I-DH----"]=[E["AC.IC.NON-FLAMMABLE GAS"]],I["E-I-DI----"]=[E["AC.IC.ORGANIC PEROXIDE"]],I["E-I-DJ----"]=[E["AC.IC.OXIDIZER"]],I["E-I-DK----"]=[E["AC.IC.RADIOACTIVE MATERIAL"]],I["E-I-DL----"]=[E["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]],I["E-I-DM----"]=[E["AC.IC.TOXIC GAS"]],I["E-I-DN----"]=[E["AC.IC.TOXIC INFECTIOUS MATERIAL"]],I["E-I-DO----"]=[E["AC.IC.UNEXPLODED ORDNANCE"]],I["E-I-E-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.HIJACKING (AIRPLANE)"]],I["E-I-EA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.HIJACKING (AIRPLANE)"]],I["E-I-F-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.HIJACKING (BOAT)"]],I["E-I-FA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.HIJACKING (BOAT)"]],I["E-I-G-----"]=[E["ST.M1.INCIDENT"],E["GR.EQ.TRAIN LOCOMOTIVE"]],I["E-I-GA----"]=[E["ST.M1.ACCIDENT"],E["GR.EQ.TRAIN LOCOMOTIVE"]],I["E-I-GB----"]=[E["GR.EQ.TRAIN LOCOMOTIVE"],E["ST.M1.HIJACKING/HIJACKED"]],I["E-I-H-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.KNOWN INSURGENT VEHICLE"]],I["E-I-HA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.KNOWN INSURGENT VEHICLE"]],I["E-N-A-----"]=[],I["E-N-AA----"]=[E["AC.IC.AFTERSHOCK"]],I["E-N-AB----"]=[E["AC.IC.AVALANCHE"]],I["E-N-AC----"]=[E["AC.IC.EARTHQUAKE EPICENTER"]],I["E-N-AD----"]=[E["AC.IC.LANDSLIDE"]],I["E-N-AE----"]=[E["AC.IC.SUBSIDENCE"]],I["W-S-WSVE--"]=[E["AC.IC.VOLCANIC ERUPTION"]],I["E-N-AG----"]=[E["AC.IC.VOLCANIC THREAT"]],I["W-S-WSD-LI"]=[E["ATMOSPHERIC.IC.DRIZZLE.INTERMITTENT LIGHT"]],I["E-N-B-----"]=[],I["E-N-BB----"]=[E["AC.IC.DROUGHT"]],I["E-N-BC----"]=[E["AC.IC.FLOOD"]],I["W-S-WSFGSO"]=[E["ATMOSPHERIC.IC.FOG.SKY OBSCURED"]],I["W-S-WSGRL-"]=[E["ATMOSPHERIC.IC.HAIL.LIGHT NOT ASSOCIATED WITH THUNDER"]],I["E-N-BF----"]=[E["AC.IC.INVERSION"]],I["W-S-WSR-LI"]=[E["ATMOSPHERIC.IC.RAIN.INTERMITTENT LIGHT"]],I["W-S-WSDSLM"]=[E["ATMOSPHERIC.IC.DUST OR SAND.LIGHT TO MODERATE"]],I["W-S-WSS-LI"]=[E["ATMOSPHERIC.IC.SNOW.INTERMITTENT LIGHT"]],I["W-S-WSTMH-"]=[E["ATMOSPHERIC.IC.STORMS.THUNDERSTORM LIGHT TO MODERATE - WITH HAIL"]],I["W-S-WST-FC"]=[E["ATMOSPHERIC.IC.STORMS.FUNNEL CLOUD (TORNADO/WATERSPOUT)"]],I["W-S-WSTSS-"]=[E["ATMOSPHERIC.IC.TROPICAL STORM SYSTEMS.TROPICAL STORM"]],I["E-N-BM----"]=[E["AC.IC.TSUNAMI"]],I["E-N-C-----"]=[],I["E-N-CA----"]=[E["AC.IC.BIRD"]],I["E-N-CB----"]=[E["AC.IC.INSECT"]],I["E-N-CC----"]=[E["AC.IC.MICROBIAL"]],I["E-N-CD----"]=[E["AC.IC.REPTILE"]],I["E-N-CE----"]=[E["AC.IC.RODENT"]],I["E-O-A-----"]=I["E-O-AA----"]=I["E-O-AB----"]=I["E-O-AC----"]=I["E-O-AD----"]=[E["GR.IC.EMERGENCY MEDICAL OPERATION"]],I["E-O-AE----"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.M1.MEDEVAC"]],I["E-O-AF----"]=[s._translate(0,10,s._scale(.8,E["GR.I.FF.CIVILIAN ROTARY WING"])),E["GR.M1.MEDEVAC"]],I["E-O-AG----"]=[E["AC.IC.HEALTH DEPARTMENT FACILITY"]],I["E-O-AJ----"]=[E["AC.IC.MEDICAL FACILITIES OUTPATIENT"]],I["E-O-AK----"]=[E["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]],I["E-O-AL----"]=[E["AC.IC.PHARMACY"]],I["E-O-AM----"]=[E["AC.IC.TRIAGE"]],I["E-O-B-----"]=I["E-O-BA----"]=I["E-O-BB----"]=I["E-O-BC----"]=[E["GR.IC.FF.EMERGENCY OPERATION"]],I["E-O-BD----"]=[s._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]],I["E-O-BE----"]=[s._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]],I["E-O-BF----"]=[s._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY OPERATIONS CENTER"]],I["E-O-BG----"]=[E["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]],I["E-O-BH----"]=[s._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY SHELTER"]],I["E-O-BI----"]=[s._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY STAGING AREA"]],I["E-O-BJ----"]=[E["GR.IC.FF.EMERGENCY OPERATION"]],I["E-O-BK----"]=I["S-G-USSW--"],I["E-O-BL----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.EMERGENCY"]],I["E-O-C-----"]=I["E-O-CA----"]=I["E-O-CB----"]=I["E-O-CE----"]=[E["GR.IC.FIRE PROTECTION"]],I["E-O-CC----"]=[E["AC.IC.FIRE HYDRANT"]],I["E-O-CD----"]=[E["AC.IC.OTHER WATER SUPPLY LOCATION"]],I["E-O-D-----"]=I["E-O-DA----"]=I["E-O-DB----"]=I["E-O-DC----"]=[E["GR.IC.FF.LAW ENFORCEMENT"]],I["E-O-DD----"]=I["E-O-DDA---"]=I["E-O-DDB---"]=I["E-O-DDC---"]=[E["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],I["E-O-DE----"]=I["E-O-DEA---"]=I["E-O-DEB---"]=I["E-O-DEC---"]=[E["GR.IC.FF.BORDER PATROL"]],I["E-O-DF----"]=I["E-O-DFA---"]=I["E-O-DFB---"]=I["E-O-DFC---"]=[E["GR.IC.FF.CUSTOMS SERVICE"]],I["E-O-DG----"]=I["E-O-DGA---"]=I["E-O-DGB---"]=I["E-O-DGC---"]=[E["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],I["E-O-DH----"]=I["E-O-DHA---"]=I["E-O-DHB---"]=I["E-O-DHC---"]=[E["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],I["E-O-DI----"]=I["E-O-DIA---"]=I["E-O-DIB---"]=I["E-O-DIC---"]=[E["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],I["E-O-DJ----"]=I["E-O-DJB---"]=I["E-O-DJC---"]=[E["GR.IC.LAW ENFORCEMENT"]],I["E-O-DK----"]=[E["GR.IC.FF.PRISON"]],I["E-O-DL----"]=I["E-O-DLA---"]=I["E-O-DLB---"]=I["E-O-DLC---"]=[E["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],I["E-O-DM----"]=I["E-O-DMA---"]=I["E-O-DMB---"]=I["E-O-DMC---"]=[E["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],I["E-O-DN----"]=I["E-O-DNA---"]=I["E-O-DNC---"]=[E["GR.IC.LAW ENFORCEMENT VESSEL"]],I["E-O-DO----"]=I["E-O-DOA---"]=I["E-O-DOB---"]=I["E-O-DOC---"]=[E["GR.IC.FF.US MARSHALS SERVICE"]],I["E-O-EA----"]=[s._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.BIOLOGICAL"]],I["E-O-EB----"]=[s._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.CHEMICAL"]],I["E-O-EC----"]=[s._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.INTRUSION"]],I["E-O-ED----"]=[s._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.NUCLEAR"]],I["E-O-EE----"]=[s._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.RADIOLOGICAL"]],I["E-F-A-----"]=[E["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]],I["E-F-AA----"]=[E["GR.IN.IC.AGRICULTURAL LABORATORY"]],I["E-F-AB----"]=[E["GR.IN.IC.ANIMAL FEEDLOT"]],I["E-F-AC----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.COMMERCIAL"]],I["E-F-AD----"]=[E["GR.IN.IC.FARM/RANCH"]],I["E-F-AE----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.PRODUCTION"]],I["E-F-AF----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.RETAIL"]],I["E-F-AG----"]=[E["GR.IN.IC.GRAIN STORAGE"]],I["E-F-B-----"]=[E["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]],I["E-F-BA----"]=[E["GR.IN.IC.ATM"]],I["E-F-BB----"]=[E["GR.IN.IC.BANK"]],I["E-F-BC----"]=[E["GR.IN.IC.BULLION STORAGE"]],I["E-F-BD----"]=[E["GR.IN.IC.FEDERAL RESERVE BANK"]],I["E-F-BE----"]=[E["GR.IN.IC.FINANCIAL EXCHANGE"]],I["E-F-BF----"]=[E["GR.IN.IC.FINANCIAL SERVICES, OTHER"]],I["E-F-C-----"]=[E["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]],I["E-F-CA----"]=[E["GR.IN.IC.CHEMICAL PLANT"]],I["E-F-CB----"]=[E["GR.IN.IC.FIREARMS MANUFACTURER"]],I["E-F-CC----"]=[E["GR.IN.IC.FIREARMS RETAILER"]],I["E-F-CD----"]=[E["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]],I["E-F-CE----"]=[E["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]],I["E-F-CF----"]=[E["GR.IN.IC.INDUSTRIAL SITE"]],I["E-F-CG----"]=[E["GR.IN.IC.LANDFILL"]],I["E-F-CH----"]=[E["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]],I["E-F-CI----"]=[E["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]],I["E-F-CJ----"]=[E["GR.IN.IC.TOXIC RELEASE INVENTORY"]],I["E-F-D-----"]=[E["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]],I["E-F-DA----"]=[E["GR.IN.IC.COLLEGE/UNIVERSITY"]],I["E-F-DB----"]=[E["GR.IN.IC.SCHOOL"]],I["E-F-EA----"]=[s._translate(0,15,s._scale(.75,E["GR.IN.IC.ELECTRIC POWER"])),E["AC.M1.GENERATION STATION"]],I["E-F-EB----"]=[E["GR.IN.IC.NATURAL GAS FACILITY"]],I["E-F-EE----"]=[E["GR.IN.IC.PROPANE FACILITY"]],I["E-F-F-----"]=[E["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]],I["E-F-G-----"]=[E["GR.IN.IC.MILITARY INFRASTRUCTURE"]],I["E-F-GA----"]=[E["GR.IN.IC.BASE"],E["AC.M1.MILITARY ARMORY"]],I["E-F-H-----"]=[E["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]],I["E-F-HA----"]=[E["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]],I["E-F-HB----"]=[E["GR.IN.IC.POST OFFICE"]],I["E-F-I-----"]=[E["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]],I["E-F-IA----"]=[E["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]],I["E-F-IB----"]=[E["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]],I["E-F-IC----"]=[E["GR.IN.IC.RECREATIONAL AREA"]],I["E-F-ID----"]=[E["GR.IN.IC.RELIGIOUS INSTITUTION"]],I["E-F-J-----"]=[E["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]],I["E-F-JA----"]=[E["GR.IN.IC.ADULT DAY CARE"]],I["E-F-JB----"]=[E["GR.IN.IC.CHILD DAY CARE"]],I["E-F-JC----"]=[E["GR.IN.IC.ELDER CARE"]],I["E-F-K-----"]=[E["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]],I["E-F-KB----"]=[E["GR.IN.IC.TELECOMMUNICATIONS TOWER"]],I["E-F-LA----"]=[E["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]],I["G-M-BCB---"]=[E["GR.IN.IC.BRIDGE"]],t["G-M-BCB---"]={x1:50,x2:150,y1:50,y2:150},I["E-F-LD----"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],I["E-F-LE----"]=[E["GR.IC.FERRY"]],I["E-F-LF----"]=[E["GR.IN.IC.HELICOPTER LANDING SITE"]],I["W-S-ML----"]=[E["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE LOCK"]],I["E-F-LH----"]=[E["GR.IC.MAINTENANCE"]],I["E-F-LJ----"]=[E["GR.IC.RAILHEAD"]],I["E-F-LK----"]=[E["GR.IN.IC.REST STOP"]],I["W-S-HPBA--"]=[E["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE SHIP ANCHORAGE"]],I["E-F-LM----"]=[E["GR.IN.IC.TOLL FACILITY"]],I["G-S-PO----"]=[E["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE.TRAFFIC CONTROL POINT"]],I["E-F-LO----"]=[E["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]],I["E-F-LP----"]=[E["GR.IN.IC.TUNNEL"]],I["E-F-MA----"]=[E["GR.IN.IC.CONTROL VALVE"]],I["E-F-MB----"]=[E["GR.IN.IC.DAM"]],I["E-F-MC----"]=[E["GR.IN.IC.DISCHARGE OUTFALL"]],I["E-F-MD----"]=[E["GR.IN.IC.GROUND WATER WELL"]],I["E-F-ME----"]=[E["GR.IN.IC.PUMPING STATION"]],I["E-F-MF----"]=[E["GR.IN.IC.RESERVOIR"]],I["E-F-MG----"]=[E["GR.IN.IC.STORAGE TOWER"]],I["E-F-MH----"]=[E["GR.IN.IC.SURFACE WATER INTAKE"]],I["E-F-MI----"]=[E["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]],I["O-O-D-----"]=[E["ST.IC.DEMONSTRATION"]],I["O-I-R-----"]=[E["ST.IC.GROUP"]],I["O-V-B-----"]=[E["ST.IC.BOMB"]],I["O-V-P-----"]=[E["ST.IC.POISONING"]],I["O-O-HA----"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],I["O-O-HV----"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],I["O-O-HT----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],I["S-G-IXH---"]=[E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I["S-S-NM----"]=[E["GR.IC.HOSPITAL SHIP"]],I["E-O-BK----"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER"]],I["S-G-UULC--"]=[E["GR.IC.LAW ENFORCEMENT"]],I["S-S-XL----"]=[E["GR.IC.LAW ENFORCEMENT VESSEL"]],I["S-G-ES----"]=[E["GR.EQ.SENSOR"]],I["S-G-IUE---"]=[E["GR.IN.IC.ELECTRIC POWER"]],I["S-G-IUEN--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER NUCLEAR"]],I["S-G-IRP---"]=[E["GR.IC.FF.CLASS III"]],I["S-G-IB----"]=[E["GR.IN.IC.BASE"]],I["S-G-IUT---"]=[E["GR.IN.IC.TELECOMMUNICATIONS"]],I["S-G-IT----"]=[E["GR.IC.TRANSPORTATION"]],I["S-G-IBA---"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],I["S-G-IBN---"]=[E["GR.IC.NAVAL"]],I["S-G-IUP---"]=[E["GR.IC.WATER"]]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(function(I,t,E,R,e,A){var C=t.affiliation||"Friend",T=E.iconColor[C],S={"2525B.ASWSUB":{type:"path",d:"m 80,85 40,0 0,-20 -40,0 z m 20,-30 0,40 m -40,15 15,15 50,0 15,-15 -15,-15 -50,0 z"},"2525B.NCBTT.STN":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"NC"}],"2525B.STN.ASWSHP":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"AS"}],"2525B.STN.PKT":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"PK"}],"2525B.STN.RSC":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"RS"}],"2525B.STN":{type:"path",fill:!1,d:"m 70,85 c 20,0 40,0 60,0 0,10 0,20 0,30 -20,0 -40,0 -60,0 0,-10 0,-20 0,-30 z m 30,-15 c 0,20 0,40 0,60 m 35,-5 C 120,148 82.7,149 66.8,126 49.2,105 59.1,69.2 85.2,60.1 103,53.1 124,59.4 135,74.8"},"2525B.SUB.STN":[{type:"path",d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"SS"}]};for(var N in S)S.hasOwnProperty(N)&&(I.hasOwnProperty(N)&&console.warn("Override of: "+N),n.call(this,S[N],T),I[N]=S[N])});function D(I,t,E,R,e,A){var C=t.affiliation||"Friend",T="Hostile"!=C||e?E.iconColor[C]:"rgb(255, 0, 0)",S="Hostile"!=C||e?E.fillColor[C]:"rgb(255, 0, 0)",N=t.numberSIDC,O=E.white[C],G={};for(var o in G["TP.DESTROY"]=R||N?[{type:"path",fill:!1,d:"m 0,45 85,46.75 m 30,16.5 85,46.75 M 0,155 85,108.25 M 115,91.75 200,45"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"D"}]:{type:"path",fill:!1,strokedasharray:"12,5",d:"M 0,155 200,45 M 0,45 200,155"},G["TP.INTERDICT"]=R||N?[{type:"path",fill:!1,d:"m 194.203,65.6674 5.49,-20.4904 -20.49,-5.4904 M 115,91.75 200,45 M 0,155 85,108.25 M 185,85 l 15,15 -15,15 m -70,-15 85,0 m -200,0 85,0"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"I"}]:{type:"path",fill:!1,d:"m 0,100 200,0 M 0,155 200,45.2 M 185,85 l 15,15 -15,15 m 9.2,-49.3 5.5,-20.5 -20.5,-5.5"},G["TP.NEUTRALIZE"]=R||N?[{type:"path",fill:!1,d:"M 115,108.25 200,155 M 0,45 85,91.75"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 115,91.75 200,45 M 0,155 85,108.25"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"N"}]:[{type:"path",fill:!1,d:"M 0,45 200,155"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 0,155 200,45"}],G["TP.DATUM"]=[{type:"path",stroke:!1,d:"m 100,50 0,50 50,0 C 150,72.3858 127.614,50 100,50 Z m 0,50 -50,0 c 0,27.614 22.3858,50 50,50 z"},{type:"circle",fill:!1,cx:100,cy:100,r:50}],G["TP.BRIEF CONTACT"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",stroke:!1,textanchor:"middle",x:75,y:55,fontsize:45,text:"B"},{type:"text",stroke:!1,textanchor:"middle",x:125,y:55,fontsize:45,text:"C"}],G["TP.LOST CONTACT"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",stroke:!1,textanchor:"middle",x:75,y:55,fontsize:45,text:"L"},{type:"text",stroke:!1,textanchor:"middle",x:125,y:55,fontsize:45,text:"C"}],G["TP.SINKER"]=[{type:"path",fill:!1,d:"m 100,15 0,65 M 60,15 80,0 100,15 120,0 140,15"},{type:"path",d:"M 100,100 55,80 145,80 Z"}],G["TP.TRIAL TRACK"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",stroke:!1,textanchor:"middle",x:75,y:55,fontsize:45,text:"T"},{type:"text",stroke:!1,textanchor:"middle",x:125,y:55,fontsize:45,text:"T"}],G["TP.SONOBUOY"]=[{type:"path",fill:!1,d:"M 100,60 l 0,-35 10,10 0,-45"},{type:"circle",fill:!1,cx:100,cy:100,r:40}],G["TP.SONOBUOY PATTERN CENTER"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"P"}],G["TP.SONOBUOY DIFAR"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"D"}],G["TP.SONOBUOY LOFAR"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"L"}],G["TP.SONOBUOY CASS"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"C"}],G["TP.SONOBUOY DICASS"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"S"}],G["TP.SONOBUOY BT"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"B"}],G["TP.SONOBUOY ANM"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"A"}],G["TP.SONOBUOY VLAD"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"V"}],G["TP.SONOBUOY ATAC"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"T"}],G["TP.SONOBUOY BARRA"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"BR"}],G["TP.SONOBUOY BATHYTHERMOGRAPH TRANSMITTING SONOBUOY (BT)"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"B"}],G["TP.SONOBUOY COMMAND ACTIVE MULTIBEAM SONOBUOY (CAMBS)"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"CM"}],G["TP.SONOBUOY EXPENDABLE RELIABLE ACOUSTIC PATH SONOBUOY (ERAPS)"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"E"}],G["TP.SONOBUOY RO"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"R"}],G["TP.SONOBUOY KINGPIN"]=[G["TP.SONOBUOY"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"K"}],G["TP.SONOBUOY EXPIRED"]=[G["TP.SONOBUOY"],{type:"path",fill:!1,d:"M 40,60 l 120,80 M 40,140 l 120,-80"}],G["TP.SEARCH"]={type:"path",d:"m 80,80 20,20 -20,20 40,0 -20,-20 20,-20 z M 50,150 150,50 M 50,50 150,150"},G["TP.SEARCH AREA"]=[G["TP.SEARCH"],R||N?[{type:"text",stroke:!1,textanchor:"middle",x:60,y:115,fontsize:45,text:"S"},{type:"text",stroke:!1,textanchor:"middle",x:140,y:115,fontsize:45,text:"A"}]:{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"SA"}],G["TP.DIP POSITION"]=[G["TP.SEARCH"],R||N?[{type:"text",stroke:!1,textanchor:"middle",x:60,y:115,fontsize:45,text:"D"},{type:"text",stroke:!1,textanchor:"middle",x:140,y:115,fontsize:45,text:"P"}]:{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"DIP"}],G["TP.SEARCH CENTER"]={type:"path",stroke:!1,d:"m 100,100 -50,10 0,-20 z m 0,0 10,50 -20,0 z m 0,0 50,-10 0,20 z m 0,0 -10,-50 20,0 z"},G["TP.REFERENCE POINT"]=[{type:"path",fill:!1,d:"M 160,160 40,160 40,40 160,40 Z"},{type:"circle",cx:100,cy:100,r:15}],G["TP.NAVIGATIONAL REFERENCE"]=!N&&R?{type:"path",fill:!1,d:"M 160,160 40,160 40,40 160,40 Z M 160,160 40,40 M 40,160 160,40"}:{type:"path",fill:!1,d:"M 160,160 40,40 M 40,160 160,40"},G["TP.SPECIAL POINT"]=[G["TP.NAVIGATIONAL REFERENCE"],{type:"circle",cx:100,cy:100,r:15}],G["TP.AIRFIELD"]=[{type:"path",fill:!1,d:"M 35,125 165,60 m -135,40 140,0"}],G["TP.DLRP"]=[G["TP.SPECIAL POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"D"}],G["TP.POINT OF INTENDED MOVEMENT"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"P"}],G["TP.PRE-LANDFALL WAYPOINT"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"PL"}],G["TP.MARSHALL POINT"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"M"}],G["TP.REFERENCE POINT WAYPOINT"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"W"}],G["TP.CORRIDOR TAB"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"C"}],G["TP.ENEMY POINT"]=[G["TP.REFERENCE POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"ENY"}],G["TP.POINT OF INTEREST"]=[{type:"path",d:"M 129.021,41.957 C 121.48,49.9458 110.986,54.4816 100,54.5 89.0432,54.4928 78.569,49.9914 71.0234,42.0469 L 100,100 Z"},{type:"circle",fill:!1,cx:100,cy:15,r:40}],G["POINT OF INTEREST – LAUNCH EVENT"]=[G["TP.POINT OF INTEREST"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:30,fontsize:40,fontweight:"bold",text:"LE"}],G["TP.SHIP AREA OF INTEREST (AEGIS ONLY)"]={type:"circle",fill:!1,cx:100,cy:100,r:50},G["TP.ACTIVE MANOEUVRE AREA (AEGIS ONLY)"]={type:"circle",fill:!1,stroke:"rgb(254,203,47)",cx:100,cy:100,r:60},G["TP.PLAN SHIP"]=[{type:"circle",fill:S,stroke:S,cx:100,cy:100,r:15},{type:"circle",stroke:S,cx:100,cy:100,r:45,fill:!1}],G["TP.AIM POINT"]=[{type:"circle",cx:100,cy:100,r:15},{type:"circle",cx:100,cy:100,r:35,fill:!1},{type:"circle",cx:100,cy:100,r:45,fill:!1}],G["TP.DEFENDED ASSET"]={type:"path",fill:!1,d:"m 90,135 0,-30 20,0 0,30 m -50,0 0,-50 -10,0 0,-20 20,0 0,10 20,0 0,-10 20,0 0,10 20,0 0,-10 20,0 0,20 -10,0 0,50 z"},G["TP.CHEMICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"C"}],G["TP.CHEMICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"C"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:30,text:"T"}],G["TP.BIOLOGICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"B"}],G["TP.BIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"B"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:30,text:"T"}],G["TP.NUCLEAR EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"N"}],G["TP.RADIOLOGICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"R"}],G["TP.RADIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30,text:"R"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:30,text:"T"}],G["TP.DROP POINT"]={type:"path",fill:!1,d:"m 130,100 0,-40 m -60,40 0,-40 m 60,40 0,0 c 0,8.284 -6.716,15 -15,15 -8.284,0 -15,-6.716 -15,-15 m 0,0 0,0 c 0,8.284 -6.7157,15 -15,15 -8.2843,0 -15,-6.716 -15,-15 m 30,-40 0,40"},G["TP.ENTRY POINT"]={type:"path",fill:!1,d:"m 100,100 0,-50 m -35,15 35,35 35,-35 m -85,35 100,0"},G["TP.AIR DETONATION"]={type:"path",d:"m 55,150 90,0 m -35,-95 5,20 15,-10 0,15 15,5 -15,10 15,10 -15,5 5,15 -20,-5 -5,20 -10,-15 -10,20 -5,-25 -20,10 5,-15 L 55,105 70,95 60,85 70,80 70,65 85,75 90,55 100,70 Z",fill:!1},G["TP.GROUND ZERO"]={type:"path",stroke:!1,d:"M 100 28 C 100 28 65.4398 29.8261 61.6543 55 C 60.2826 64.1213 75.0115 70.4884 82.2363 71.6543 C 89.4611 72.8201 91.7277 55.3462 98.5098 56.0371 L 93 90 C 93 90 70 90 67 97 C 65.0304 101.596 100 100 100 100 C 100 100 134.97 101.596 133 97 C 130 90 107 90 107 90 L 101.49 56.0371 C 108.272 55.3462 110.539 72.8201 117.764 71.6543 C 124.988 70.4884 139.718 64.1213 138.346 55 C 134.56 29.8261 100 28 100 28 z"},G["TP.LAUNCHED TORPEDO (AEGIS ONLY)"]={type:"path",d:"m 150,90 0,20 m -10,-10 10,0 m -97,-10 84,0 c 1.662,0 3,1.338 3,3 l 0,14 c 0,1.662 -1.338,3 -3,3 l -84,0 c -1.662,0 -3,-1.338 -3,-3 l 0,-14 c 0,-1.662 1.338,-3 3,-3 z"},G["TP.MSL DETECT POINT"]={type:"path",d:"m 95,100 0,-55 -10,0 15,-15 15,15 -10,0 0,55 m -55,0 100,0"},G["TP.ACOUSTIC COUNTER MEASURE (DECOY)"]={type:"path",d:"M 107.5,55 92.5518,70 107.5,85 Z M 50,30 150,30 m -90,70 0,-5 80,0 0,5 z m 70,-45 -15,15 15,15 z M 85,55 70,70 85,85 Z m 15,-25 0,33"},G["TP.ELECTRONIC COUNTER MEASURES (ECM) DECOY"]=[{type:"path",d:"m 80,120 -20,10 20,10 z m 30,0 -20,10 20,10 0,-20 z m 30,0 -20,10 20,10 z m -25,-20 c 0,10 -10,18 -19.4,14 -9.4,-2 -13.8,-14.7 -8,-22.5 5.2,-8.2 18.4,-8.7 24.4,-0.8 2,2.6 3,5.9 3,9.3 z"},{type:"path",fill:!1,d:"m 50,50 0,100 100,0 0,-100 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:80,fontsize:30,text:"ECM"}],G["TP.IMPACT POINT"]={type:"path",d:"m 50,100 40,-10 10,-40 10,40 40,10 -40,10 -10,40 -10,-40 -40,-10"},G["TP.PREDICTED IMPACT POINT"]={type:"path",fill:!1,strokedasharray:"12,5",d:"m 50,100 40,-10 10,-40 10,40 40,10 -40,10 -10,40 -10,-40 -40,-10"},G["TP.FORMATION"]={type:"path",fill:!1,d:"m 100,50 0,100 m -50,-50 100,0"},G["TP.HARBOR"]={type:"path",fill:!1,d:"M 80,140 50,60 150,60 120,140"},G["TP.HARBOR POINT Q"]=[G["TP.HARBOR"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"Q"}],G["TP.HARBOR POINT A"]=[G["TP.HARBOR"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"A"}],G["TP.HARBOR POINT Y"]=[G["TP.HARBOR"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"Y"}],G["TP.HARBOR POINT X"]=[G["TP.HARBOR"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"X"}],G["TP.ROUTE"]={type:"path",fill:!1,d:"m 138.484,76.82 c 0,-7.4823 6.066,-13.5478 13.548,-13.548 7.483,-3e-4 13.549,6.0653 13.549,13.548 m -27.097,0 0,0 c 0,6.9484 -5.634,12.5807 -12.582,12.58 -6.948,-4e-4 -12.58,-5.6324 -12.58,-12.58 m -27.097,0 c 2e-4,-7.4823 6.0657,-13.5478 13.548,-13.548 7.483,-3e-4 13.549,6.0653 13.549,13.548 m -79.3554,0 c 2e-4,-7.4824 6.066,-13.548 13.5484,-13.548 7.4824,0 13.5482,6.0656 13.5484,13.548 m 25.1616,0 0,0 C 86.2246,83.7681 80.5918,89.4003 73.6437,89.4 66.696,89.3998 61.0638,83.7677 61.0634,76.82 m 77.4206,47.328 c 0,-7.482 6.066,-13.548 13.548,-13.548 7.483,0 13.549,6.065 13.549,13.548 m -27.097,0 0,0 c 0,6.948 -5.634,12.581 -12.582,12.58 -6.948,0 -12.58,-5.632 -12.58,-12.58 m -27.097,0 c 2e-4,-7.482 6.0657,-13.548 13.548,-13.548 7.483,0 13.549,6.065 13.549,13.548 m -79.3554,0 c 2e-4,-7.482 6.066,-13.548 13.5484,-13.548 7.4824,0 13.5482,6.066 13.5484,13.548 m 25.1616,0 0,0 c -4e-4,6.948 -5.6332,12.58 -12.5813,12.58 -6.9477,0 -12.5799,-5.632 -12.5803,-12.58 m -27.0968,-23.664 132.5184,0"},G["TP.ROUTE RENDEZVOUS"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"R"}],G["TP.ROUTE DIVERSIONS"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"D"}],G["TP.ROUTE WAYPOINT"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"W"}],G["TP.ROUTE PIM"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"M"}],G["TP.ROUTE POINT R"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"P"}],G["TP.PICKET ROUTE"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"PK"}],G["TP.POINT R ROUTE"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"R"}],G["TP.RENDEZVOUS ROUTE"]=[G["TP.ROUTE"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:45,text:"RZ"}],G["TP.AIR CONTROL"]={type:"path",fill:!1,d:"m 140,165 0,-130 m -80,0 0,130"},G["TP.AIR CONTROL POINT"]=[G["TP.AIR CONTROL"],{type:"circle",cx:100,cy:100,r:15}],G["TP.COMBAT AIR PATROL (CAP)"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"C"}],G["TP.AIRBORNE EARLY WARNING (AEW)"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"W"}],G["TP.TANKING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"K"},N||R?[]:{type:"circle",cx:100,cy:100,r:15}],G["TP.FIXED WING"]=[G["TP.AIR CONTROL"],N||R?[{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:R?"ASW":"AS"},{type:"path",d:R?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}]:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"F"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.ROTARY WING"]=[G["TP.AIR CONTROL"],N||R?[{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:"ASW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}]:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"H"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.SUCAP - FIXED WING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:"SUW"},{type:"path",d:R?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}],G["TP.SUCAP - ROTARY WING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:"ASW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}],G["TP.MIW - FIXED WING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:R?"MIW":"MW"},{type:"path",d:R?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}],G["TP.MIW - ROTARY WING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:R?"MIW":"MW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}],G["TP.STRIKE IP"]=[G["TP.AIR CONTROL"],N||R?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"S"}:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"S"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.CORRIDOR TAB POINT"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"C"},{type:"circle",cx:100,cy:100,r:15}],G["TP.AIR CONTROL RENDEZVOUS"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"RZ"}],G["TP.CAP STATION"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"C"}],G["TP.AEW STATION"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"W"}],G["TP.TACAN"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"T"},N||R?[]:{type:"circle",cx:100,cy:100,r:15}],G["TP.REPLENISHMENT STATION"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"RP"}],G["TP.TANKING"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:N||R?115:155,fontsize:45,text:"K"}],G["TP.TOMCAT"]=[G["TP.AIR CONTROL"],N||R?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"TC"}:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"O"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.RESCUE"]=[G["TP.AIR CONTROL"],N?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RS"}:R?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RC"}:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"R"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.REPLENISH"]=[G["TP.AIR CONTROL"],N||R?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RP"}:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"F"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.MARSHALL"]=[G["TP.AIR CONTROL"],N||R?{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"M"}:[{type:"text",stroke:!1,textanchor:"middle",x:100,y:155,fontsize:45,text:"M"},{type:"circle",cx:100,cy:100,r:15}]],G["TP.UNMANNED AERIAL SYSTEM"]=[G["TP.AIR CONTROL"],{type:"path",stroke:!1,d:"m 70,85 30,15 30,-15 0,15 -30,15 -30,-15 z"}],G["TP.VTUA"]=[G["TP.AIR CONTROL"],{type:"path",stroke:!1,d:"m 70,95 30,15 30,-15 0,30 -30,-15 -30,15 z m 0,-25 30,15 30,-15 0,15 -30,15 -30,-15 z"}],G["TP.ORBIT"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"O"}],G["TP.ORBIT - FIGURE EIGHT"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"O"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"F8"}],G["TP.ORBIT - RACE TRACK"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"O"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"RT"}],G["TP.ORBIT - RANDOM, CLOSED"]=[G["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"O"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:150,fontsize:40,text:"RC"}],G["TP.ACTION POINT"]={type:"path",fill:!1,d:"m 60,45 80,0 m -40,55 -40,-55 0,-105 80,0 0,105 z"},G["TP.ACTION CHECK POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"CKP"}],G["TP.CONTACT POINT"]=N?{type:"path",fill:!1,d:"M 50,50 150,50 150,150 50,150z"}:{type:"path",fill:!1,d:"m 100,100 0,-35 -45,0 0,-75 90,0 0,75 -45,0"},G["TP.CENTRE OF MAIN EFFORT"]=[{type:"path",fill:!1,d:"m 155,100 0,-35 M 45,100 45,65 m 88,0 0,35 m -22,-35 0,35 m -22,-35 0,35 m -22,0 0,-35 m -37,70 0,-35 140,0 0,40"}],G["TP.COORDINATION POINT"]=[{type:"path",fill:!1,d:"m 65,135 70,-70 m -70,0 70,70"},{type:"circle",fill:!1,cx:100,cy:100,r:50}],G["TP.DECISION POINT"]={type:"path",fill:!1,d:"M 99.9998,25.5886 117.061,76.5192 170.77,77.0054 127.604,108.968 143.738,160.2 100,129.024 56.2624,160.2 72.3967,108.968 29.2306,77.0059 82.9403,76.5192 Z"},G["TP.DISTRESS CALL"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"SOS"}],G["TP.ENTRY CONTROL POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"EC"}],G["TP.FLY-TO-POINT (SONOBUOY)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"FTP"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:35,text:"SBY"}],G["TP.FLY-TO-POINT (WEAPON)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"FTP"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:35,text:"WPN"}],G["TP.FLY-TO-POINT (NORMAL)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"FTP"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:35,text:"NRM"}],G["TP.ACTION LINKUP POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"LU"}],G["TP.ACTION PASSAGE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"PP"}],G["TP.ACTION RALLY POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"RLY"}],G["TP.ACTION RELEASE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"RP"}],G["TP.ACTION START POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"SP"}],G["TP.ACTION AMNESTY POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"AMN"}],G["TP.WAYPOINT"]={type:"path",fill:!1,strokewidth:8,d:"m 65,135 70,-70 m -70,0 70,70"},G["TP.COMBATANT STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"CBT"}],G["TP.PICKET STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"PKT"}],G["TP.ASW SHIP STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"ASW"}],G["TP.REPLENISHMENT AT SEA (RAS) STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"RAS"}],G["TP.RESCUE STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"RSC"}],G["TP.SUBMARINE STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"SUB"}],G["TP.ASW SUBMARINE STATION"]=[G["TP.WAYPOINT"],{type:"text",stroke:!1,textanchor:"end",x:75,y:115,fontsize:40,text:"ASW/SUB"}],G["TP.SEA SURFACE CONTROL"]={type:"path",fill:!1,d:"m 30,60 140,0 m -140,80 140,0"},G["TP.SEA SURFACE CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"circle",cx:100,cy:100,r:15}],G["TP.(USV) CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 100,115 45,-20 0,-15 -45,20 -45,-20 0,15 z"}],G["TP.(USV)"]=[G["TP.SEA SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 55,100 45,20 45,-20 0,15 -45,20 -45,-20 z"}],G["TP.(RMV) USV CONTROL STATION"]=[G["TP.(USV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"RMV"}],G["TP.USV - ASW CONTROL STATION"]=[G["TP.(USV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"ASW"}],G["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SURFACE STATION"]=[G["TP.(USV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"MW"}],G["TP.USV - SUW CONTROL STATION"]=[G["TP.(USV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"SUW"}],G["TP.USV - MIW CONTROL STATION"]=[G["TP.(USV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"MIW"}],G["TP.ASW CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"ASW"}],G["TP.MINE WARFARE SURFACE STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"MW"}],G["TP.NON-COMBATANT SURFACE STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"NC"}],G["TP.SUW CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"SUW"}],G["TP.MIW CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"MIW"}],G["TP.PICKET CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"PK"}],G["TP.RENDEZVOUS CONTROL POINT"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RZ"}],G["TP.REPLENISHMENT AT SEA SURFACE STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RAS"}],G["TP.RESCUE CONTROL POINT"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RS"}],G["TP.REPLENISHMENT CONTROL POINT"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"RP"}],G["TP.NONCOMBATANT CONTROL STATION"]=[G["TP.SEA SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,text:"NC"}],G["TP.SUB SURFACE CONTROL"]=[{type:"path",fill:!1,d:"m 30,140 140,0"},{type:"path",fill:!1,strokedasharray:"12,4",d:"m 30,60 140,0"}],G["TP.SUB SURFACE CONTROL STATION"]=[G["TP.SUB SURFACE CONTROL"],{type:"circle",cx:100,cy:100,r:15}],G["TP.(UUV) CONTROL STATION"]=[G["TP.SUB SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 100,115 45,-20 0,-15 -45,20 -45,-20 0,15 z"}],G["TP.(UUV)"]=[G["TP.SUB SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 55,100 45,20 45,-20 0,15 -45,20 -45,-20 z"}],G["TP.UUV - ASW CONTROL STATION"]=[G["TP.(UUV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"ASW"}],G["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SUBSURFACE STATION"]=[G["TP.(UUV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"MW"}],G["TP.UUV - SUW CONTROL STATION"]=[G["TP.(UUV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"SUW"}],G["TP.UUV - MIW CONTROL STATION"]=[G["TP.(UUV)"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:95,fontsize:40,text:"MIW"}],G["TP.SUBMARINE CONTROL STATION"]=[G["TP.SUB SURFACE CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:130,fontsize:35,text:"SS"},{type:"path",d:"m 75,95 0,-20 50,0 0,20 z m 25,-30 0,40"}],G["TP.ASW SUBMARINE CONTROL STATION"]=[G["TP.SUB SURFACE CONTROL"],{type:"path",d:"m 68.75,105 -12.5,12.5 12.5,12.5 62.5,0 12.5,-12.5 -12.5,-12.5 z M 75,95 l 0,-20 50,0 0,20 z m 25,-30 0,40"}],G["TP.AIR CONTROL POINT (ACP)"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",stroke:!1,textanchor:"middle",x:100,y:90,fontsize:30,text:"ACP"}],G["TP.COMMUNICATIONS CHECKPOINT"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",stroke:!1,textanchor:"middle",x:100,y:90,fontsize:30,text:"CCP"}],G["TP.PULL-UP POINT"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",stroke:!1,textanchor:"start",x:160,y:115,fontsize:40,text:"PUP"},{type:"path",fill:!1,d:"m 65,80 0,40 70,-40 0,40 z"}],G["TP.DOWNED AIRCREW PICKUP POINT"]=[G["TP.ACTION POINT"],{type:"circle",cx:100,cy:-35,r:12},{type:"path",fill:!1,d:"m 75,35 50,0 m -25,-45 0,45 m -30,-75 30,30 30,-30"}],G["TP.DUMMY MINEFIELD"]=[{type:"path",fill:!1,d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,-40 0,80 120,0 0,-80 z"},{type:"path",fill:!1,strokedasharray:"15,10",d:"M 160,60 100,-5 M 40,60 100,-5"}],G["TP.TARGET REFERENCE"]={type:"path",fill:!1,d:"m 50,100 100,0 m -50,-50 0,100"},G["TP.OBSERVATION POST/OUTPOST"]={type:"path",fill:!1,d:"m 100,45 47.6,82.5 -95.2,0 z"},G["TP.COMBAT OUTPOST"]={type:"path",fill:!1,d:"m 140,140 0,-12.5 m -16,12.5 0,-12.5 m -16,12.5 0,-12.5 m -48.0001,12.5 3e-4,-12.5 m 15.9993,12.5 4e-4,-12.501 m 16,12.501 3e-4,-12.5 m -46.43,-12.493 10.8256,6.25 m -2.8256,-20.107 10.8256,6.251 m -2.8257,-20.1071 10.8257,6.2506 m 13.1743,-47.8198 10.8257,6.2506 m -18.8253,7.6056 10.8256,6.2506 m -18.826,7.606 10.8257,6.2506 M 114.43,45.725 l -10.826,6.25 m 18.826,7.6064 -10.826,6.25 m 18.826,7.6064 -10.826,6.25 m 34.826,35.3192 -10.826,6.25 m 2.826,-20.106 -10.826,6.25 m 2.826,-20.1068 -10.826,6.25 M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},G["TP.OBSERVATION POST/RECONNAISSANCE"]={type:"path",fill:!1,d:"M 52.3687,127.5 123.816,86.2499 M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},G["TP.FORWARD OBSERVER POSITION"]=[G["TP.OBSERVATION POST/RECONNAISSANCE"],{type:"path",d:"m 115,100 c 0,8.284 -6.716,15 -15,15 -8.2843,0 -15,-6.716 -15,-15 0,-8.2843 6.7157,-15 15,-15 8.284,0 15,6.7157 15,15 z"}],G["TP.SENSOR OUTPOST"]=N?[{type:"path",fill:!1,d:"M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},{type:"path",stroke:!1,d:"m 100,80 c 0,7.5 12.5,20 20,20 -7.5,0 -20,12.5 -20,20 0,-7.5 -12.5,-20 -20,-20 7.5,0 20,-12.5 20,-20 z"}]:{type:"path",fill:!1,d:"m 61.1738,112.25 23.6601,0 m 30.3321,0 23.66,0 M 80,105 l 10,15 20,0 10,-15 z m 19.9998,-60 47.6312,82.5 -95.2623,0 z"},G["TP.CBRN OBSERVATION POST"]=[{type:"path",fill:!1,d:"m 99.9998,45 47.6312,82.5 -95.2623,0 z M 88,119 c 2.1824,-13.288 7.7157,-24.22 22,-29 m 1.829,29 C 109.664,105.712 104.173,94.78 90,90 M 52.3687,127.5 123.816,86.2499"},{type:"path",d:"m 91,92 c 0,2.7614 -2.2386,5 -5,5 -2.7614,0 -5,-2.2386 -5,-5 0,-2.7614 2.2386,-5 5,-5 2.7614,0 5,2.2386 5,5 z m 28.011,0 c 0,2.7678 -2.243,5.0117 -5.011,5.012 -2.768,-3e-4 -5.011,-2.2442 -5.011,-5.012 0,-2.7676 2.243,-5.0112 5.011,-5.0115 2.768,3e-4 5.011,2.2439 5.011,5.0115 z"}],G["TP.POINT OF DEPARTURE"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"PD"}],G["TP.FIXED AND PREFABRICATED"]={type:"path",d:"m 60,100 40,-65 40,65 z"},G["TP.TETRAHEDRONS"]={type:"path",fill:!1,d:"m 60,100 40,-65 40,65"},G["TP.TETRAHEDRONS MOVABLE"]={type:"path",fill:!1,d:"m 60,100 40,-65 40,65 z"},G["TP.BOOBY TRAP"]={type:"path",fill:!1,d:"M 77.2413,87.9311 100,50 122.781,87.9687 M 130,100 c 0,10.24 -13.431,18.541 -30,18.541 -16.5685,0 -30,-8.301 -30,-18.541 0,-10.2399 13.4315,-18.541 30,-18.541 16.569,0 30,8.3011 30,18.541 z"},G["TP.UNSPECIFIED MINE"]={type:"path",fill:!1,d:"m 129,100 c 0,16.016 -12.984,29 -29,29 -16.0163,0 -29,-12.984 -29,-29 0,-16.0163 12.9837,-29 29,-29 16.016,0 29,12.9837 29,29 z"},G["TP.ANTITANK MINE (AT)"]={type:"path",d:"m 129,100 c 0,16.016 -12.984,29 -29,29 -16.0163,0 -29,-12.984 -29,-29 0,-16.0163 12.9837,-29 29,-29 16.016,0 29,12.9837 29,29 z"},G["TP.(AT) ANTIHANDLING DEVICE"]=[G["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 100,130 0,65 15,-15"}],G["TP.(AT) DIRECTIONAL"]=[G["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,strokedasharray:"5,5",d:"m 100,70 0,-60"},{type:"path",fill:!1,d:"m 90,20 10,-10 10,10"}],G["TP.ANTIPERSONNEL (AP) MINES"]=[G["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 50,50 29.5,29.5 m 41,0 L 150,50"}],G["TP.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS"]=[G["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 131,100 10,0 M 50,50 79.5,79.5 m 41,0 L 150,50 m -4,50 10,0 m 5,0 10,0 m -10,-10 10,10 -10,10"}],G["TP.WIDE AREA MINES"]=[G["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 50,110 25,40 12,-24 M 113,126 125,150 150,110"}],G["TP.PLANNED MINEFIELD"]=[{type:"path",fill:!1,strokedasharray:"15,15",d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",fill:!1,d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],G["TP.MINEFIELDS STATIC"]={type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z m 70,35 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m 35,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,0 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z"},G["TP.MINEFIELD, STATIC"]={type:"path",fill:!1,d:"m 25,65 0,70 150,0 0,-70 z"},t.notpresent&&(G["TP.MINEFIELDS STATIC"]=G["TP.PLANNED MINEFIELD"]),G["TP.ANTITANK (AT) MINEFIELD"]=[{type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],G["TP.SCATTERABLE MINES"]=[G["TP.MINEFIELDS STATIC"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:60,fontsize:35,text:"S"}],G["TP.ANTIPERSONNEL (AP) MINEFIELD"]=[{type:"text",stroke:!1,textanchor:"middle",x:100,y:60,fontsize:35,text:"+S"},{type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",d:"M 72.0703,92.9297 80,82.3622 m -30,0 7.9297,10.5675 m 49.1403,0 7.93,-10.5675 m -30,0 7.9297,10.5675 m 49.1403,0 7.93,-10.5675 m -30,0 7.93,10.5675 M 110,100 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m 35,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,0 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z"}],G["TP.SCATTERABLE MINEFIELD WITH SELF-DESTRUCT"]=[G["TP.ANTITANK (AT) MINEFIELD"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:60,fontsize:35,text:"S"}],G["TP.VOLCANO MINEFIELD"]=[G["TP.ANTITANK (AT) MINEFIELD"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:60,fontsize:35,text:"V"}],G["TP.TOWER LOW"]=[{type:"circle",stroke:!1,cx:100,cy:100,r:7},{type:"path",fill:!1,strokewidth:8,d:"m 75,105 25,-65 25,65"}],G["TP.TOWER HIGH"]=[{type:"circle",stroke:!1,cx:100,cy:100,r:7},{type:"path",fill:!1,strokewidth:8,d:"m 100,40 c 2.358,31.6754 7.162,59.2531 25,64.999 M 100,40 c -2.358,31.6754 -7.1624,59.2531 -25,65"}],G["TP.ENGINEER REGULATING POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ERP"}],G["TP.EARTHWORK/FORTIFICATION"]={type:"path",d:"m 65,65 0,70 70,0 0,-70 -70,0z"},G["TP.FORT"]={type:"path",fill:!1,d:"m 135,65 15,-15 m -15,85 15,15 M 65,135 50,150 m 15,-85 0,70 70,0 0,-70 -70,0 -15,-15"},G["TP.SURFACE SHELTER"]={type:"path",d:"m 135,135 15,0 m -100,0 15,0 m 0,-70 0,70 70,0 0,-70 -70,0"},G["TP.UNDERGROUND SHELTER"]={type:"path",d:"m 135,65 15,0 m -100,0 15,0 m 0,70 0,-70 70,0 0,70 -70,0"},G["TP.NUCLEAR DETONATIONS GROUND ZERO"]=[{type:"path",fill:!e&&"rgb(255,255,0)",d:"m 85,25 0,75 30,0 0,-75 m -50,0 c 0,-50 70,-50 70,0 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:35,text:"N"}],G["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"]=[{type:"path",strokedasharray:"5,5",fill:!e&&"rgb(255,255,0)",d:"m 85,25 0,75 30,0 0,-75 m -50,0 c 0,-50 70,-50 70,0 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:35,text:"N"}],G["TP.NUCLEAR FALLOUT PRODUCING"]=[{type:"path",fill:!1,d:"m 120,85 -15,15 m -25,0 40,-35 M 80,80 120,40 M 80,55 115,25 M 80,40 95,25 m -40,0 c 0,-60 90,-60 90,0 z m 25,0 0,75 40,0 0,-75"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:35,text:"N"}],G["TP.RELEASE EVENTS BIOLOGICAL"]=[{type:"path",fill:!e&&"rgb(255,255,0)",d:"m 85,-15 0,60 -25,55 80,0 -25,-55 0,-60 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:35,text:"B"},{type:"text",stroke:!1,textanchor:"end",x:50,y:60,fontsize:35,text:"BIO"}],G["TP.RELEASE EVENTS CHEMICAL"]=[{type:"path",fill:!e&&"rgb(255,255,0)",d:"m 85,-15 0,59.0625 C 75.7313,49.4137 70.0154,59.2975 70,70 c 0,16.5685 13.4315,30 30,30 16.569,0 30,-13.4315 30,-30 -0.01,-10.7067 -5.728,-20.5959 -15,-25.9492 L 115,-15 Z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:80,fontsize:35,text:"C"},{type:"text",stroke:!1,textanchor:"end",x:50,y:60,fontsize:35,text:"CML"}],G["TP.DECON SITE/POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"DCN"}],G["TP.ALTERNATE DECON SITE/POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"ALT"}],G["TP.DECON SITE/POINT (TROOPS)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"T"}],G["TP.DECON SITE/POINT (EQUIPMENT)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"E"}],G["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"E/T"}],G["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"O"}],G["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"TH"}],G["TP.MAIN EQUIPMENT DECONTAMINATION POINT/SITE"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:30,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:25,text:"(M)"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:13,fontsize:25,text:"E"}],G["TP.FORWARD TROOP DECONTAMINATION POINT/SITE"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:30,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:25,text:"(F)"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:13,fontsize:25,text:"T"}],G["TP.WOUNDED PERSONNEL DECONTAMINATION SITE"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"W"}],G["TP.AMBULANCE CONTROL POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ACP"}],G["TP.AMBULANCE LOAD POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ALP"}],G["TP.AMBULANCE RELAY POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ARP"}],G["TP.DECON POINT (MAIN) EQUIPMENT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,text:"(M)E"}],G["TP.DECON POINT (FORWARD) TROOPS"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"DCN"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,text:"(F)T"}],G["TP.POINT/SINGLE TARGET"]={type:"path",fill:!1,d:"m 50,100 100,0 m -50,-50 0,100"},G["TP.NUCLEAR TARGET"]={type:"path",fill:!1,d:"m 90,100 -40,0 m 50,10 0,40 m 10,-50 40,0 m -50,-10 0,-40 m 2.5,50 c 0,1.381 -1.119,2.5 -2.5,2.5 -1.3807,0 -2.5,-1.119 -2.5,-2.5 0,-1.3807 1.1193,-2.5 2.5,-2.5 1.381,0 2.5,1.1193 2.5,2.5 z"},G["TP.TARGETRECORDED (AEGIS ONLY)"]=[{type:"path",fill:!1,d:"m 0,50 0,100 200,0 0,-100 z"},{type:"path",stroke:!1,d:"m 100,90 -10,10 10,10 10,-10 z"}],G["TP.FIRE SUPPORT STATION"]=[{type:"path",fill:!1,d:"M 50,50 150,150 M 50,150 150,50"},N?{type:"text",stroke:!1,textanchor:"left",x:120,y:110,fontsize:35,text:"FSS"}:[]],G["TP.SURVEY CONTROL POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"SCP"}],G["TP.FIRING POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"FP"}],G["TP.RELOAD POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"RLP"}],G["TP.HIDE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"HP"}],G["TP.LAUNCH POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"LP"}],G["TP.AMBULANCE EXCHANGE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"AXP"}],G["TP.CANNIBALIZATION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"CAN"}],G["TP.CASUALTY COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"CCP"}],G["TP.CIVILIAN COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"CIV"}],G["TP.DETAINEE COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"DET"}],G["TP.EPW COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"EPW"}],G["TP.LOGISTICS RELEASE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"LRP"}],G["TP.MAINTENANCE COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"MCP"}],G["TP.MEDICAL EVACUATION (MEDEVAC) PICKUP POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:30,text:"MEP"},{type:"path",stroke:!1,d:"m 95,-25 0,10 -10,0 0,10 10,0 0,10 10,0 0,-10 10,0 0,-10 -10,0 0,-10 z"}],G["TP.REARM, REFUEL AND RESUPPLY POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"R3P"}],G["TP.REFUEL ON THE MOVE POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ROM"}],G["TP.TRAFFIC CONTROL POST"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"TCP"}],G["TP.TRAILER TRANSFER POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"TTP"}],G["TP.UNIT MAINTENANCE COLLECTION POINT"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:25,text:"UMCP"}],G["TP.SUPPLY POINT"]={type:"path",fill:!1,d:"m 60,30 80,0 m -80,15 80,0 m -40,55 -40,-55 0,-105 80,0 0,105 z"},G["TP.NATO CLASS I"]=[G["TP.SUPPLY POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:45,text:"I"}],G["TP.NATO CLASS II"]=[G["TP.SUPPLY POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:45,text:"II"}],G["TP.NATO CLASS III"]=[G["TP.SUPPLY POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:45,text:"III"}],G["TP.NATO CLASS IV"]=[G["TP.SUPPLY POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:45,text:"IV"}],G["TP.NATO CLASS V"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 80,-10 40,0 m -32,0 0,-26.7 c 0,-17.8 24,-17.8 24,0 L 112,-10"}],G["TP.SP CLASS I"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 115,-50 c -45,5 -45,65 0,70 -20,-25 -20,-50 0,-70 z"}],G["TP.SP CLASS II"]=[G["TP.SUPPLY POINT"],{type:"path",stroke:!1,d:"m 101.143,3.91602 q 3.662,-0.26368 4.746,-1.08399 1.084,-0.84961 1.084,-4.33594 l 0,-26.68949 q 0,-3.3105 -1.084,-4.248 -1.084,-0.9668 -4.746,-1.1426 l 0,-1.1133 17.753,0 0,1.1133 q -3.662,0.1758 -4.746,1.1426 -1.084,0.9375 -1.084,4.248 l 0,26.68949 q 0,3.48633 1.084,4.33594 1.084,0.82031 4.746,1.08399 l 0,1.08398 -17.753,0 0,-1.08398 z m 8.877,-38.61332 0,0 z M 81.1035,3.91602 q 3.6621,-0.26368 4.7461,-1.08399 1.084,-0.84961 1.084,-4.33594 l 0,-26.68949 q 0,-3.3105 -1.084,-4.248 -1.084,-0.9668 -4.7461,-1.1426 l 0,-1.1133 17.7539,0 0,1.1133 q -3.6621,0.1758 -4.7461,1.1426 -1.084,0.9375 -1.084,4.248 l 0,26.68949 q 0,3.48633 1.084,4.33594 1.084,0.82031 4.7461,1.08399 l 0,1.08398 -17.7539,0 0,-1.08398 z m 8.877,-38.61332 0,0 z"}],G["TP.SP CLASS III"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,20 0,-30 -20,-40 40,0 -20,40"}],G["TP.SP CLASS IV"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,-40 0,20 m -25,10 0,-30 50,0 0,30"}],G["TP.SP CLASS V"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 80,15 0,-50 c 0,-20 40,-20 40,0 l 0,50 m -50,0 60,0"}],G["TP.SP CLASS VI"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 75,-20 50,0 m -25,15 15,25 m -15,-50 0,25 -20,25 m 30,-60 c 0,5.5228 -4.477,10 -10,10 -5.5228,0 -10,-4.4772 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],G["TP.SP CLASS VII"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 85,-25 c 10,-10 20,-10 30,0"},{type:"path",d:"m 129.6,-20 c 0,5.3019 -4.298,9.5999 -9.6,9.5998 -5.302,10e-5 -9.6,-4.2979 -9.6,-9.5998 0,-5.3019 4.298,-9.5999 9.6,-9.5998 5.302,-1e-4 9.6,4.2979 9.6,9.5998 z m -40.4886,0 c 0,5.0321 -4.0793,9.1114 -9.1114,9.1114 -5.0321,0 -9.1114,-4.0793 -9.1114,-9.1114 0,-5.0321 4.0793,-9.1114 9.1114,-9.1114 5.0321,0 9.1114,4.0793 9.1114,9.1114 z"}],G["TP.SP CLASS VIII"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 60,-15 80,0 m -40,-45 0,90"}],G["TP.SP CLASS IX"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 121.213,-36.2132 -7.08,7.0802 M 85.8669,-0.866982 78.7868,6.2132 m 0,-42.4264 7.0801,7.0802 m 28.2661,28.266018 7.08,7.080182 M 100,-45 l 0,10 m 0,40 0,10 m -30,-30 10,0 m 40,0 10,0 m -10,0 c 0,11.04569 -8.954,20 -20,20 -11.0457,0 -20,-8.95431 -20,-20 0,-11.0457 8.9543,-20 20,-20 11.046,0 20,8.9543 20,20 z"}],G["TP.SP CLASS X"]=[G["TP.SUPPLY POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:40,text:"CA"}],G["TP.MEDICAL SUPPLY POINT"]=[G["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,-20 0,-40 m -40,25 80,0"}],G["TP.AMMUNITION SUPPLY POINT (ASP)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ASP"}],G["TP.AMMUNITION TRANSFER POINT (ATP)"]=[G["TP.ACTION POINT"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,text:"ATP"}],G["TP.TARGET HANDOVER"]=[{type:"path",strokedasharray:"10,5",fill:!1,d:"m 100,45 -15,40 -40,15 40,15 15,40 15,-40 40,-15 -40,-15 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:110,fontsize:30,text:"TH"}],G["TP.KEY TERRAIN"]=[{type:"path",d:"m 145,100 a 45,45 0 0 1 -45,45 45,45 0 0 1 -45,-45 45,45 0 0 1 45,-45 45,45 0 0 1 45,45 z"},{type:"text",stroke:!1,textanchor:"middle",x:80,y:110,fontsize:35,text:"K",fill:O}],G["TP.BT BOUY DROP"]=[{type:"path",fill:!1,d:"m 65,45 0,110 70,0 0,-110 m -35,95 0,-95 m -35,0 70,0"},{type:"path",d:"m 104,100 c 0,2 -3,2 -4.8,2 -1.4,0 -4.1,-1 -2.7,-2.9 1.9,-1.4 4.5,-1.4 6.5,-0.4 1,0.3 1,0.7 1,1.3 z m 0,40 c 0,2 -3,2 -4.8,2 -1.4,0 -4.1,-1 -2.7,-3 1.9,-1 4.5,-1 6.5,0 1,0 1,0 1,1 z"},{type:"text",stroke:!1,textanchor:"middle",x:80,y:110,fontsize:35,text:"B"},{type:"text",stroke:!1,textanchor:"middle",x:120,y:110,fontsize:35,text:"T"}],G["TP.REPORTED BOTTOMED SUB"]={type:"path",fill:!1,d:"M 129,122.4 70.9,78.8 m 0,43.6 58.1,-43.6 m -80,-14.5 0,43.6 29,0 0,29 43.6,0 0,-29 29,0 0,-43.6"},G["TP.MOVING HAVEN"]={type:"path",d:"M 108.142,100 A 8.14167,8.14167 0 0 1 100,108.142 8.14167,8.14167 0 0 1 91.8583,100 8.14167,8.14167 0 0 1 100,91.8583 8.14167,8.14167 0 0 1 108.142,100 Z M 45,55 l 0,90 m 110,-90 0,90 m -110,-45 110,0"},G["TP.SCREEN CENTRE"]={type:"path",d:"m 100,55 0,90 m 8.142,-45 A 8.14167,8.14167 0 0 1 100,108.142 8.14167,8.14167 0 0 1 91.8583,100 8.14167,8.14167 0 0 1 100,91.8583 8.14167,8.14167 0 0 1 108.142,100 Z"},G["TP.SHORE CONTROL STATION"]={type:"path",fill:!1,d:"m 30,155 140,0 m -27,-20 2,-10 -10,5 m -78,5 -2,-10 10,5 m 35,-55 0,68 m 7.5,-76 A 7.5,7.5 0 0 1 100,74.5 7.5,7.5 0 0 1 92.5,67 7.5,7.5 0 0 1 100,59.5 7.5,7.5 0 0 1 107.5,67 Z m -52.5,8 90,0 m -90,50 c 15,25 75,25 90,0 M 40,45 50,55 60,45 70,55 80,45 l 10,10 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"},G["TP.DITCHED AIRCRAFT"]={type:"path",d:"m 145,120 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 10,10 25,-30 -10,-10 10,-10 20,20 -10,35 -15,-15 -15,15 z"},G["TP.PERSON IN WATER"]={type:"path",d:"m 105,110 10,-10 0,-15 5,0 0,20 -10,10 z m -10,0 -10,-10 0,-15 -5,0 0,20 10,10 z m 5,-5 0,-10 -5,0 -5,-5 0,-10 5,-5 10,0 5,5 0,10 -5,5 -5,0 m -15,25 15,-15 m 45,15 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 45,15 -15,-15"},G["TP.CLUTTER, STATIONARY OR CEASE REPORTING"]={type:"path",fill:!1,d:"m 65,135 c 23.3,-23 47,-46.7 70,-70 m -70,0 c 23.3,23.3 47,47 70,70 m -35,-4 c -19.7,0 -47.8,-8 -50,-31 3,-24.9 33.9,-32 55,-30.7 19,0.8 46,10.9 45,33.7 -5,21 -31,28 -50,28 z m 31,-31 c 0,20 -8,48 -31,50 C 75.1,147 68,116 69.3,95 70.1,76.2 80.2,48.6 103,50.2 c 21,4.9 28,31.1 28,49.8 z"},G["TP.TENTATIVE OR PROVISIONAL TRACK"]={type:"path",fill:!1,d:"M 130.902,100 A 30.9017,50 0 0 1 100,150 30.9017,50 0 0 1 69.0983,100 30.9017,50 0 0 1 100,50 30.9017,50 0 0 1 130.902,100 Z M 100,130.902 A 50,30.9017 0 0 1 50,100 50,30.9017 0 0 1 100,69.0983 50,30.9017 0 0 1 150,100 50,30.9017 0 0 1 100,130.902 Z"},G["TP.DISTRESSED VESSEL"]={type:"path",d:"m 120,65 -20,20 20,-20 m -5,55 -35,-35 0,-20 45,45 z m -30,0 -15,-15 m -15,15 15,-15 m 45,15 15,-15 m 15,15 -15,-15 m -45,15 15,-15"},G["TP.SEA MINELIKE"]={type:"path",d:"M 75,75 55,55 m 45,-15 0,25 m 25,10 20,-20 m -80,60 0,-30 20,-20 30,0 20,20 0,30 -20,20 -30,0 z"},G["TP.ICEBERG"]={type:"path",d:"m 75,100 25,-30 25,30 -5,15 -5,-5 -15,20 -15,-20 -5,5 z m -15,0 80,0"},G["TP.OIL RIG/PLATFORM"]=[{type:"path",d:"m 55,100 0,-50 m 75,50 0,40 m 20,-40 0,40 m -115,0 0,-40 130,0",fill:!1},{type:"path",d:"m 55,100 0,-15 25,0 0,15 z"}],G["TP.BOTTOM RETURN"]={type:"path",d:"m 50,100 15,-35 15,30 20,-55 20,55 15,-35 15,40 z"},G["TP.INSTALLATION/MANMADE"]={type:"path",fill:!1,d:"m 50,100 15,-35 15,30 20,-55 20,55 15,-35 15,40 z"},G["TP.WRECK, NON DANGEROUS"]={type:"path",fill:!1,d:"m 135,85 0,30 m -85,-15 100,0 m -85,-15 0,30 m 35,-40 0,50"},G["TP.WRECK, DANGEROUS"]=[G["TP.WRECK, NON DANGEROUS"],{type:"path",strokedasharray:"5,5",fill:!1,d:"m 156.547,100 c 0,16.382 -25.162,29.662 -56.202,29.662 -31.0395,0 -56.2019,-13.28 -56.2017,-29.662 0,-16.3818 25.1624,-29.6618 56.2017,-29.6618 31.039,-1e-4 56.202,13.28 56.202,29.6618 z"}],G["TP.MARINE LIFE"]={type:"path",stroke:!1,d:"m 132,75 0,50 83,-37.5 0,25 L 132,75 m -32,25 25.5,-25 0,50 z"},G["TP.SEA ANOMALY"]={type:"path",fill:!1,d:"M 150,80 130,35 100,100 70,35 50,80 m 0,20 20,-45 30,65 30,-65 20,45"},G["TP.FIX ACOUSTIC"]={type:"path",fill:!1,d:"M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},G["TP.FIX ELECTRO-MAGNETIC"]={type:"path",fill:!1,d:"m 50,90 15,20 5,-20 15,20 5,-20 20,20 5,-20 15,20 5,-20 15,20 M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},G["TP.ELECTRO MAGNETIC - MAGNETIC ANOMALY DETECTION (MAD)"]=[G["TP.FIX ELECTRO-MAGNETIC"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:180,fontsize:35,text:"MAD"}],G["TP.FIX ELECTRO-OPTICAL"]={type:"path",fill:!1,d:"m 150,100 c 0,6.904 -22.386,12.5 -50,12.5 -27.6142,0 -50,-5.596 -50,-12.5 0,-6.9036 22.3858,-12.5 50,-12.5 27.614,0 50,5.5964 50,12.5 z M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},G["TP.FIRE"]={type:"text",stroke:!1,fill:E.iconColor[C],textanchor:"middle",x:100,y:115,fontsize:35,text:"FIRE"},G["TP.INDIRECT FIRE"]={type:"path",stroke:E.iconColor[C],fill:!1,d:"m 100,60 0,80 m -40,-40 80,0"},G["TP.AMBUSH"]={type:"path",stroke:E.iconColor[C],fill:!1,d:"m 77.5,106 20,0 m -20,-12 20,0 M 75,82 95,82 m -20,36 20,0 m -25,12 20,0 M 70,70 90,70 M 80,60 c 25,15 25,65 0,80 m 45,-50 10,10 -10,10 m -25,-10 35,0"},G["TP.ROAD BLOCK"]={type:"path",stroke:E.iconColor[C],fill:!1,d:"m 73,133 60,-60 m -66,54 60,-60 m -54,0 60,60 m -66,-54 60,60"},G["TP.ROAD BLOCK (UNDER CONSTRUCTION)"]=[{type:"path",stroke:E.iconColor[C],fill:!1,strokedasharray:"5,5",d:"m 73,67 60,60 m -66,-54 60,60"},{type:"path",stroke:E.iconColor[C],fill:!1,d:"M 73,133 133,73 M 67,127 127,67"}],G["TP.VITAL AREA CENTRE"]=[{type:"path",fill:!1,d:"m 45,100 110,0 m 0,-40 0,85 M 45,60 l 0,80 m 55,-80 0,80"}],G["TP.ESTIMATED POSITION (EP)"]=[{type:"path",fill:!1,strokedasharray:"12,5",d:"M 160,160 40,160 40,40 160,40 Z"},{type:"path",fill:!1,d:"m 140,100 c 1,26 -27,47 -51.8,38 C 63.1,131 51.5,98.3 67,77.4 c 13.8,-21.9 49,-23.2 64,-2.3 6,7 9,15.9 9,24.9 z"},{type:"text",stroke:!1,textanchor:"middle",x:100,y:115,fontsize:35,text:"EP"}],G["FORWARD OBSERVER / SPOTTER POSITION"]=[{type:"circle",cx:100,cy:100,r:3},{type:"path",fill:!1,d:"m 40,135 60,-75 60,75 z"}],G["MAN MADE SPACE DEBRIS SMALL"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"M 60,110 75,100 60,90 m 50,50 -10,-15 -10,15 m 50,-50 -15,10 15,10 M 90,60 100,75 110,60"}],G["MAN MADE SPACE DEBRIS MEDIUM"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50}],G["MAN MADE SPACE DEBRIS BIG"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"m 90,75 10,-15 10,15 M 75,110 60,100 75,90 m 35,35 -10,15 -10,-15 m 35,-35 15,10 -15,10"}],G["NATURAL SPACE DEBRIS SMALL"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"M 60,110 75,100 60,90 m 50,50 -10,-15 -10,15 m 50,-50 -15,10 15,10 M 90,60 100,75 110,60"}],G["NATURAL SPACE DEBRIS MEDIUM"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50}],G["NATURAL SPACE DEBRIS BIG"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"m 90,75 10,-15 10,15 M 75,110 60,100 75,90 m 35,35 -10,15 -10,-15 m 35,-35 15,10 -15,10"}],G["TP.M1.UNSPECIFIED"]=[{type:"circle",fill:!1,cx:55,cy:100,r:15},{type:"circle",fill:!1,cx:100,cy:100,r:15},{type:"circle",fill:!1,cx:145,cy:100,r:15}],G["TP.M1.ANTIPERSONNEL MINE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 35,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],G["TP.M1.ANTIPERSONNEL MINE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 80,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],G["TP.M1.ANTIPERSONNEL MINE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 125,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],G["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"M 64.4,88.3 75,75 m -40,0 10.6,13.3 m 32.4,10 2,1.7 -2,2 z m -8,1.7 3.3,0"}],G["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"M 109,88.3 120,75 m -40,0 10.6,13.3 m 32.4,10 2,1.7 -2,2 z m -8,1.7 3,0"}],G["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"M 154,88.3 165,75 m -40,0 11,13.3 m 32,10 2,1.7 -2,2 z m -8,1.7 3,0"}],G["TP.M1.ANTITANK MINE 1"]=[{type:"circle",cx:55,cy:100,r:15}],G["TP.M1.ANTITANK MINE 2"]=[{type:"circle",cx:100,cy:100,r:15}],G["TP.M1.ANTITANK MINE 3"]=[{type:"circle",cx:145,cy:100,r:15}],G["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 55,115 0,13 6,-6"}],G["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 100,115 0,13 6,-6"}],G["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 145,115 0,13 6,-6"}],G["TP.M1.WIDE AREA ANTITANK MINE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 35,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],G["TP.M1.WIDE AREA ANTITANK MINE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 80,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],G["TP.M1.WIDE AREA ANTITANK MINE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 125,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],G["TP.M1.MINE CLUSTER 1"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 73,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],G["TP.M1.MINE CLUSTER 2"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 118,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],G["TP.M1.MINE CLUSTER 3"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 163,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],G)G.hasOwnProperty(o)&&(I.hasOwnProperty(o)&&console.warn("Override of: "+o),n.call(this,G[o],T),I[o]=G[o])}s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(D),s.addLabelOverrides(function(I){I["G-T-D-----"]={},I["G-T-I-----"]={},I["G-T-N-----"]={},I["G-G-GPUUD-"]={},I["G-G-GPUUB-"]={},I["G-G-GPUUL-"]={},I["G-G-GPUUS-"]={},I["G-G-GPUY--"]={},I["G-G-GPUYP-"]={},I["G-G-GPUYD-"]={},I["G-G-GPUYL-"]={},I["G-G-GPUYC-"]={},I["G-G-GPUYS-"]={},I["G-G-GPUYB-"]={},I["G-G-GPUYA-"]={},I["G-G-GPUYV-"]={},I["G-G-GPUYT-"]={},I["G-G-GPUYR-"]={},I["G-G-GPUYK-"]={},I["G-G-GPUYX-"]={},I["G-G-GPUS--"]={},I["G-G-GPUSA-"]={},I["G-G-GPUSD-"]={},I["G-G-GPUSC-"]={},I["G-G-GPR---"]={},I["G-G-GPRN--"]={},I["G-G-GPRS--"]={},I["G-G-GPRD--"]={},I["G-G-GPRP--"]={},I["G-G-GPRM--"]={},I["G-G-GPRW--"]={},I["G-G-GPRC--"]={},I["G-G-GPRI--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:45,fontweight:"bold"}},I["G-G-GPWA--"]={},I["G-G-GPWD--"]={},I["G-G-GPWE--"]={},I["G-G-GPWG--"]={},I["G-G-GPWM--"]={},I["G-G-GPWI--"]={},I["G-G-GPWP--"]={},I["G-G-GPF---"]={},I["G-G-GPH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},I["G-G-GPHQ--"]={},I["G-G-GPHA--"]={},I["G-G-GPHY--"]={},I["G-G-GPHX--"]={},I["G-G-GPO---"]={},I["G-G-GPOZ--"]={},I["G-G-GPOD--"]={},I["G-G-GPOW--"]={},I["G-G-GPOP--"]={},I["G-G-GPOR--"]={},I["G-G-GPA---"]={},I["G-G-GPAP--"]={},I["G-G-GPAW--"]={},I["G-G-GPAK--"]={},I["G-G-GPAA--"]={},I["G-G-GPAH--"]={},I["G-G-GPAB--"]={},I["G-G-GPAC--"]={},I["G-G-GPAD--"]={},I["G-G-GPAE--"]={},I["G-G-GPAS--"]={},I["G-G-GPAT--"]={},I["G-G-GPAO--"]={},I["G-G-GPAR--"]={},I["G-G-GPAL--"]={},I["G-G-GPAF--"]={},I["G-G-GPAG--"]={},I["G-G-GPAI--"]={},I["G-G-GPAJ--"]={},I["G-G-GPAM--"]={},I["G-G-GPAN--"]={},I["G-G-GPP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},additionalInformation1:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,fontweight:"bold"},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPK--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPC--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:40,fontsize:45,fontweight:"bold"}},I["G-G-GPPO--"]={},I["G-G-GPPD--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},I["G-G-GPPL--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPP--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPR--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPS--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-G-GPPW--"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:125,fontsize:70}},I["G-G-GPC---"]={},I["G-G-GPCU--"]={},I["G-G-GPCUR-"]={},I["G-G-GPCUA-"]={},I["G-G-GPCUS-"]={},I["G-G-GPCUM-"]={},I["G-G-GPCA--"]={},I["G-G-GPCS--"]={},I["G-G-GPCM--"]={},I["G-G-GPCP--"]={},I["G-G-GPCR--"]={},I["G-G-GPCC--"]={},I["G-G-GPCE--"]={},I["G-G-GPCN--"]={},I["G-G-GPB---"]={},I["G-G-GPBU--"]={},I["G-G-GPBUA-"]={},I["G-G-GPBUS-"]={},I["G-G-GPBUM-"]={},I["G-G-GPBS--"]={},I["G-G-GPBSA-"]={},I["G-G-APP---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},I["G-G-APC---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},I["G-G-APU---"]={},I["G-G-APD---"]={},I["G-G-PN----"]={},I["G-G-DPT---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:115,y:85,fontsize:45,fontweight:"bold"}},I["G-G-DPO---"]={},I["G-G-DPOC--"]={},I["G-G-DPOR--"]={},I["G-G-DPOF--"]={},I["G-G-DPOS--"]={},I["G-G-DPON--"]={},I["G-G-OPP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-OAOF--"]={},I["G-M-OAOM--"]={},I["G-M-OAOP--"]={},I["G-M-OB----"]={},I["G-M-OMU---"]={},I["G-M-OMT---"]={},I["G-M-OMD---"]={},I["G-M-OME---"]={},I["G-M-OMP---"]={},I["G-M-OMW---"]={},I["G-M-OFS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:55,fontsize:40},hostile:[{stroke:!1,textanchor:"end",x:35,y:110,fontsize:30,fontweight:"bold"},{stroke:!1,textanchor:"start",x:165,y:110,fontsize:30,fontweight:"bold"}],dtg:{stroke:!1,textanchor:"middle",x:100,y:175,fontsize:40}},I["G-M-OHTL--"]={altitudeDepth:{stroke:!1,textanchor:"start",x:120,y:60,fontsize:40,fontweight:"bold"}},I["G-M-OHTH--"]={altitudeDepth:{stroke:!1,textanchor:"start",x:115,y:60,fontsize:40,fontweight:"bold"}},I["G-M-BCP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-SE----"]={},I["G-M-SF----"]={},I["G-M-SS----"]={},I["G-M-SU----"]={},I["G-M-NZ----"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-M-NF----"]={},I["G-M-NEB---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-M-NEC---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-M-NDP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDO---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-M-NDD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-F-PTS---"]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},I["G-F-PTN---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40,fontweight:"bold"}},I["G-F-PCF---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:125,y:115,fontsize:40,fontweight:"bold"}},I["G-F-PCS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-F-PCB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-F-PCR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-F-PCH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-F-PCL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PX----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PC----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PY----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PT----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PD----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PE----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PL----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PM----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PR----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PU----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PO----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PI----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PN----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PS----"]={},I["G-S-PSZ---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSF---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSG---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PSJ---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PA----"]={},I["G-S-PAS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-S-PAT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-O-ED----"]={},I["G-O-EP----"]={},I["G-O-EV----"]={},I["G-O-HM----"]={},I["G-O-HI----"]={},I["G-O-HO----"]={},I["G-O-SB----"]={},I["G-O-SBM---"]={},I["G-O-SBN---"]={},I["G-O-SBW---"]={},I["G-O-SBX---"]={},I["G-O-SM----"]={},I["G-O-SS----"]={},I["G-O-FA----"]={},I["G-O-FE----"]={},I["G-O-FO----"]={}},"letter");var m={type:"letter",icons:function(I,t,E,R){I["G-T-D-----"]=E["TP.DESTROY"],t["G-T-D-----"]={x1:0,x2:200,y1:40,y2:160},I["G-T-I-----"]=E["TP.INTERDICT"],t["G-T-I-----"]={x1:0,x2:200,y1:40,y2:160},I["G-T-N-----"]=E["TP.NEUTRALIZE"],t["G-T-N-----"]={x1:0,x2:200,y1:40,y2:160},I["G-G-GPUUD-"]=E["TP.DATUM"],t["G-G-GPUUD-"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPUUB-"]=E["TP.BRIEF CONTACT"],t["G-G-GPUUB-"]={x1:50,x2:150,y1:0,y2:100},I["G-G-GPUUL-"]=E["TP.LOST CONTACT"],t["G-G-GPUUL-"]={x1:50,x2:150,y1:0,y2:100},I["G-G-GPUUS-"]=E["TP.SINKER"],t["G-G-GPUUS-"]={x1:50,x2:150,y1:0,y2:100},I["G-G-GPUY--"]=E["TP.SONOBUOY"],t["G-G-GPUY--"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYP-"]=E["TP.SONOBUOY PATTERN CENTER"],t["G-G-GPUYP-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYD-"]=E["TP.SONOBUOY DIFAR"],t["G-G-GPUYD-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYL-"]=E["TP.SONOBUOY LOFAR"],t["G-G-GPUYL-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYC-"]=E["TP.SONOBUOY CASS"],t["G-G-GPUYC-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYS-"]=E["TP.SONOBUOY DICASS"],t["G-G-GPUYS-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYB-"]=E["TP.SONOBUOY BT"],t["G-G-GPUYB-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYA-"]=E["TP.SONOBUOY ANM"],t["G-G-GPUYA-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYV-"]=E["TP.SONOBUOY VLAD"],t["G-G-GPUYV-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYT-"]=E["TP.SONOBUOY ATAC"],t["G-G-GPUYT-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYR-"]=E["TP.SONOBUOY RO"],t["G-G-GPUYR-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYK-"]=E["TP.SONOBUOY KINGPIN"],t["G-G-GPUYK-"]={x1:60,x2:140,y1:-10,y2:160},I["G-G-GPUYX-"]=E["TP.SONOBUOY EXPIRED"],t["G-G-GPUYX-"]={x1:40,x2:160,y1:-10,y2:160},I["G-G-GPUS--"]=E["TP.SEARCH"],t["G-G-GPUS--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPUSA-"]=E["TP.SEARCH AREA"],t["G-G-GPUSA-"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPUSD-"]=E["TP.DIP POSITION"],t["G-G-GPUSD-"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPUSC-"]=E["TP.SEARCH CENTER"],t["G-G-GPUSC-"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPR---"]=E["TP.REFERENCE POINT"],t["G-G-GPR---"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRN--"]=E["TP.NAVIGATIONAL REFERENCE"],t["G-G-GPRN--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRS--"]=E["TP.SPECIAL POINT"],t["G-G-GPRS--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRD--"]=E["TP.DLRP"],t["G-G-GPRD--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRP--"]=E["TP.POINT OF INTENDED MOVEMENT"],t["G-G-GPRP--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRM--"]=E["TP.MARSHALL POINT"],t["G-G-GPRM--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRW--"]=E["TP.REFERENCE POINT WAYPOINT"],t["G-G-GPRW--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRC--"]=E["TP.CORRIDOR TAB"],t["G-G-GPRC--"]={x1:40,x2:160,y1:40,y2:160},I["G-G-GPRI--"]=E["TP.POINT OF INTEREST"],t["G-G-GPRI--"]={x1:50,x2:150,y1:-25},I["G-G-GPWA--"]=E["TP.AIM POINT"],t["G-G-GPWA--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPWD--"]=E["TP.DROP POINT"],t["G-G-GPWD--"]={x1:50,x2:150,y1:50,y2:120},I["G-G-GPWE--"]=E["TP.ENTRY POINT"],t["G-G-GPWE--"]={x1:50,x2:150,y1:50},I["G-G-GPWG--"]=E["TP.GROUND ZERO"],t["G-G-GPWG--"]={x1:50,x2:150,y1:30},I["G-G-GPWM--"]=E["TP.MSL DETECT POINT"],t["G-G-GPWM--"]={x1:50,x2:150,y1:30},I["G-G-GPWI--"]=E["TP.IMPACT POINT"],t["G-G-GPWI--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPWP--"]=E["TP.PREDICTED IMPACT POINT"],t["G-G-GPWP--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPF---"]=E["TP.FORMATION"],t["G-G-GPF---"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPH---"]=E["TP.HARBOR"],t["G-G-GPH---"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPHQ--"]=E["TP.HARBOR POINT Q"],t["G-G-GPHQ--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPHA--"]=E["TP.HARBOR POINT A"],t["G-G-GPHA--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPHY--"]=E["TP.HARBOR POINT Y"],t["G-G-GPHY--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPHX--"]=E["TP.HARBOR POINT X"],t["G-G-GPHX--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPO---"]=E["TP.ROUTE"],t["G-G-GPO---"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPOZ--"]=E["TP.ROUTE RENDEZVOUS"],t["G-G-GPOZ--"]={x1:30,x2:170,y1:60,y2:170},I["G-G-GPOD--"]=E["TP.ROUTE DIVERSIONS"],t["G-G-GPOD--"]={x1:30,x2:170,y1:60,y2:170},I["G-G-GPOW--"]=E["TP.ROUTE WAYPOINT"],t["G-G-GPOW--"]={x1:30,x2:170,y1:60,y2:170},I["G-G-GPOP--"]=E["TP.ROUTE PIM"],t["G-G-GPOP--"]={x1:30,x2:170,y1:60,y2:170},I["G-G-GPOR--"]=E["TP.ROUTE POINT R"],t["G-G-GPOR--"]={x1:30,x2:170,y1:60,y2:170},I["G-G-GPA---"]=E["TP.AIR CONTROL POINT"],t["G-G-GPA---"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAP--"]=E["TP.COMBAT AIR PATROL (CAP)"],t["G-G-GPAP--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAW--"]=E["TP.AIRBORNE EARLY WARNING (AEW)"],t["G-G-GPAW--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAK--"]=E["TP.TANKING"],t["G-G-GPAK--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAA--"]=E["TP.FIXED WING"],t["G-G-GPAA--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAH--"]=E["TP.ROTARY WING"],t["G-G-GPAH--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAB--"]=E["TP.SUCAP - FIXED WING"],t["G-G-GPAB--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAC--"]=E["TP.SUCAP - ROTARY WING"],t["G-G-GPAC--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAD--"]=E["TP.MIW - FIXED WING"],t["G-G-GPAD--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAE--"]=E["TP.MIW - ROTARY WING"],t["G-G-GPAE--"]={x1:60,x2:140,y1:40,y2:160},I["G-G-GPAS--"]=E["TP.STRIKE IP"],t["G-G-GPAS--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAT--"]=E["TP.TACAN"],t["G-G-GPAT--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAO--"]=E["TP.TOMCAT"],t["G-G-GPAO--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAR--"]=E["TP.RESCUE"],t["G-G-GPAR--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAL--"]=E["TP.REPLENISH"],t["G-G-GPAL--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAF--"]=E["TP.UNMANNED AERIAL SYSTEM"],t["G-G-GPAF--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAG--"]=E["TP.VTUA"],t["G-G-GPAG--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAI--"]=E["TP.ORBIT"],t["G-G-GPAI--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAJ--"]=E["TP.ORBIT - FIGURE EIGHT"],t["G-G-GPAJ--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAM--"]=E["TP.ORBIT - RACE TRACK"],t["G-G-GPAM--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPAN--"]=E["TP.ORBIT - RANDOM, CLOSED"],t["G-G-GPAN--"]={x1:60,x2:140,y1:30,y2:170},I["G-G-GPP---"]=E["TP.ACTION POINT"],t["G-G-GPP---"]={x1:60,x2:140,y1:-60},I["G-G-GPPK--"]=E["TP.ACTION CHECK POINT"],t["G-G-GPPK--"]={x1:60,x2:140,y1:-60},I["G-G-GPPC--"]=E["TP.CONTACT POINT"],t["G-G-GPPC--"]={x1:55,x2:145,y1:-10},I["G-G-GPPO--"]=E["TP.COORDINATION POINT"],t["G-G-GPPO--"]={x1:50,x2:150,y1:50,y2:150},I["G-G-GPPD--"]=E["TP.DECISION POINT"],t["G-G-GPPD--"]={x1:30,x2:170,y1:25,y2:160},I["G-G-GPPL--"]=E["TP.ACTION LINKUP POINT"],t["G-G-GPPL--"]={x1:60,x2:140,y1:-60},I["G-G-GPPP--"]=E["TP.ACTION PASSAGE POINT"],t["G-G-GPPP--"]={x1:60,x2:140,y1:-60},I["G-G-GPPR--"]=E["TP.ACTION RALLY POINT"],t["G-G-GPPR--"]={x1:60,x2:140,y1:-60},I["G-G-GPPE--"]=E["TP.ACTION RELEASE POINT"],t["G-G-GPPE--"]={x1:60,x2:140,y1:-60},I["G-G-GPPS--"]=E["TP.ACTION START POINT"],t["G-G-GPPS--"]={x1:60,x2:140,y1:-60},I["G-G-GPPA--"]=E["TP.ACTION AMNESTY POINT"],t["G-G-GPPA--"]={x1:60,x2:140,y1:-60},I["G-G-GPPW--"]=E["TP.WAYPOINT"],t["G-G-GPPW--"]={x1:60,x2:140,y1:60,y2:140},I["G-G-GPC---"]=E["TP.SEA SURFACE CONTROL STATION"],t["G-G-GPC---"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCU--"]=E["TP.(USV) CONTROL STATION"],t["G-G-GPCU--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCUR-"]=E["TP.(RMV) USV CONTROL STATION"],t["G-G-GPCUR-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCUA-"]=E["TP.USV - ASW CONTROL STATION"],t["G-G-GPCUA-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCUS-"]=E["TP.USV - SUW CONTROL STATION"],t["G-G-GPCUS-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCUM-"]=E["TP.USV - MIW CONTROL STATION"],t["G-G-GPCUM-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCA--"]=E["TP.ASW CONTROL STATION"],t["G-G-GPCA--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCS--"]=E["TP.SUW CONTROL STATION"],t["G-G-GPCS--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCM--"]=E["TP.MIW CONTROL STATION"],t["G-G-GPCM--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCP--"]=E["TP.PICKET CONTROL STATION"],t["G-G-GPCP--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCR--"]=E["TP.RENDEZVOUS CONTROL POINT"],t["G-G-GPCR--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCC--"]=E["TP.RESCUE CONTROL POINT"],t["G-G-GPCC--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCE--"]=E["TP.REPLENISHMENT CONTROL POINT"],t["G-G-GPCE--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPCN--"]=E["TP.NONCOMBATANT CONTROL STATION"],t["G-G-GPCN--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPB---"]=E["TP.SUB SURFACE CONTROL STATION"],t["G-G-GPB---"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBU--"]=E["TP.(UUV) CONTROL STATION"],t["G-G-GPBU--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBUA-"]=E["TP.UUV - ASW CONTROL STATION"],t["G-G-GPBUA-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBUS-"]=E["TP.UUV - SUW CONTROL STATION"],t["G-G-GPBUS-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBUM-"]=E["TP.UUV - MIW CONTROL STATION"],t["G-G-GPBUM-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBS--"]=E["TP.SUBMARINE CONTROL STATION"],t["G-G-GPBS--"]={x1:30,x2:170,y1:60,y2:140},I["G-G-GPBSA-"]=E["TP.ASW SUBMARINE CONTROL STATION"],t["G-G-GPBSA-"]={x1:30,x2:170,y1:60,y2:140},I["G-G-APP---"]=E["TP.AIR CONTROL POINT (ACP)"],t["G-G-APP---"]={x1:50,x2:150,y1:50,y2:150},I["G-G-APC---"]=E["TP.COMMUNICATIONS CHECKPOINT"],t["G-G-APC---"]={x1:50,x2:150,y1:50,y2:150},I["G-G-APU---"]=E["TP.PULL-UP POINT"],t["G-G-APU---"]={x1:50,x2:240,y1:50,y2:150},I["G-G-APD---"]=E["TP.DOWNED AIRCREW PICKUP POINT"],t["G-G-APD---"]={x1:60,x2:140,y1:-60},I["G-G-PN----"]=E["TP.DUMMY MINEFIELD"],t["G-G-PN----"]={x1:40,x2:160,y1:-10,y2:140},I["G-G-DPT---"]=E["TP.TARGET REFERENCE"],I["G-G-DPO---"]=E["TP.OBSERVATION POST/OUTPOST"],t["G-G-DPO---"]={x1:50,x2:150,y1:40,y2:150},I["G-G-DPOC--"]=E["TP.COMBAT OUTPOST"],t["G-G-DPOC--"]={x1:50,x2:150,y1:40,y2:150},I["G-G-DPOR--"]=E["TP.OBSERVATION POST/RECONNAISSANCE"],t["G-G-DPOR--"]={x1:50,x2:150,y1:40,y2:150},I["G-G-DPOF--"]=E["TP.FORWARD OBSERVER POSITION"],t["G-G-DPOF--"]={x1:50,x2:150,y1:40,y2:150},I["G-G-DPOS--"]=E["TP.SENSOR OUTPOST"],t["G-G-DPOS--"]={x1:50,x2:150,y1:40,y2:150},I["G-G-DPON--"]=E["TP.CBRN OBSERVATION POST"],t["G-G-DPON--"]={x1:50,x2:150,y1:40,y2:150},I["G-G-OPP---"]=E["TP.POINT OF DEPARTURE"],t["G-G-OPP---"]={x1:60,x2:140,y1:-60},I["G-M-OAOF--"]=E["TP.FIXED AND PREFABRICATED"],t["G-M-OAOF--"]={x1:60,x2:140,y1:30},I["G-M-OAOM--"]=E["TP.TETRAHEDRONS"],t["G-M-OAOM--"]={x1:60,x2:140,y1:30},I["G-M-OAOP--"]=E["TP.TETRAHEDRONS MOVABLE"],t["G-M-OAOP--"]={x1:60,x2:140,y1:30},I["G-M-OB----"]=E["TP.BOOBY TRAP"],I["G-M-OMU---"]=E["TP.UNSPECIFIED MINE"],I["G-M-OMT---"]=E["TP.ANTITANK MINE (AT)"],I["G-M-OMD---"]=E["TP.(AT) ANTIHANDLING DEVICE"],t["G-M-OMD---"]={x1:60,x2:140,y1:40,y2:195},I["G-M-OME---"]=E["TP.(AT) DIRECTIONAL"],t["G-M-OME---"]={x1:60,x2:140,y1:10,y2:140},I["G-M-OMP---"]=E["TP.ANTIPERSONNEL (AP) MINES"],I["G-M-OMW---"]=E["TP.WIDE AREA MINES"],I["G-M-OFS---"]=E["TP.MINEFIELDS STATIC"],t["G-M-OFS---"]={x1:40,x2:160,y1:60,y2:140},I["G-M-OHTL--"]=E["TP.TOWER LOW"],t["G-M-OHTL--"]={x1:50,x2:150,y1:30,y2:120},I["G-M-OHTH--"]=E["TP.TOWER HIGH"],t["G-M-OHTH--"]={x1:50,x2:150,y1:30,y2:120},I["G-M-BCP---"]=E["TP.ENGINEER REGULATING POINT"],t["G-M-BCP---"]={x1:60,x2:140,y1:-60},I["G-M-SE----"]=E["TP.EARTHWORK/FORTIFICATION"],I["G-M-SF----"]=E["TP.FORT"],I["G-M-SS----"]=E["TP.SURFACE SHELTER"],I["G-M-SU----"]=E["TP.UNDERGROUND SHELTER"],I["G-M-NZ----"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],t["G-M-NZ----"]={x1:60,x2:140,y1:-20},I["G-M-NF----"]=E["TP.NUCLEAR FALLOUT PRODUCING"],t["G-M-NF----"]={x1:50,x2:150,y1:-20},I["G-M-NEB---"]=E["TP.RELEASE EVENTS BIOLOGICAL"],t["G-M-NEB---"]={x1:-10,x2:140,y1:-20},I["G-M-NEC---"]=E["TP.RELEASE EVENTS CHEMICAL"],t["G-M-NEC---"]={x1:-20,x2:140,y1:-20},I["G-M-NDP---"]=E["TP.DECON SITE/POINT"],t["G-M-NDP---"]={x1:60,x2:140,y1:-60},I["G-M-NDA---"]=E["TP.ALTERNATE DECON SITE/POINT"],t["G-M-NDA---"]={x1:60,x2:140,y1:-60},I["G-M-NDT---"]=E["TP.DECON SITE/POINT (TROOPS)"],t["G-M-NDT---"]={x1:60,x2:140,y1:-60},I["G-M-NDE---"]=E["TP.DECON SITE/POINT (EQUIPMENT)"],t["G-M-NDE---"]={x1:60,x2:140,y1:-60},I["G-M-NDB---"]=E["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],t["G-M-NDB---"]={x1:60,x2:140,y1:-60},I["G-M-NDO---"]=E["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],t["G-M-NDO---"]={x1:60,x2:140,y1:-60},I["G-M-NDD---"]=E["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],t["G-M-NDD---"]={x1:60,x2:140,y1:-60},I["G-F-PTS---"]=E["TP.POINT/SINGLE TARGET"],I["G-F-PTN---"]=E["TP.NUCLEAR TARGET"],I["G-F-PCF---"]=E["TP.FIRE SUPPORT STATION"],I["G-F-PCS---"]=E["TP.SURVEY CONTROL POINT"],t["G-F-PCS---"]={x1:60,x2:140,y1:-60},I["G-F-PCB---"]=E["TP.FIRING POINT"],t["G-F-PCB---"]={x1:60,x2:140,y1:-60},I["G-F-PCR---"]=E["TP.RELOAD POINT"],t["G-F-PCR---"]={x1:60,x2:140,y1:-60},I["G-F-PCH---"]=E["TP.HIDE POINT"],t["G-F-PCH---"]={x1:60,x2:140,y1:-60},I["G-F-PCL---"]=E["TP.LAUNCH POINT"],t["G-F-PCL---"]={x1:60,x2:140,y1:-60},I["G-S-PX----"]=E["TP.AMBULANCE EXCHANGE POINT"],t["G-S-PX----"]={x1:60,x2:140,y1:-60},I["G-S-PC----"]=E["TP.CANNIBALIZATION POINT"],t["G-S-PC----"]={x1:60,x2:140,y1:-60},I["G-S-PY----"]=E["TP.CASUALTY COLLECTION POINT"],t["G-S-PY----"]={x1:60,x2:140,y1:-60},I["G-S-PT----"]=E["TP.CIVILIAN COLLECTION POINT"],t["G-S-PT----"]={x1:60,x2:140,y1:-60},I["G-S-PD----"]=E["TP.DETAINEE COLLECTION POINT"],t["G-S-PD----"]={x1:60,x2:140,y1:-60},I["G-S-PE----"]=E["TP.EPW COLLECTION POINT"],t["G-S-PE----"]={x1:60,x2:140,y1:-60},I["G-S-PL----"]=E["TP.LOGISTICS RELEASE POINT"],t["G-S-PL----"]={x1:60,x2:140,y1:-60},I["G-S-PM----"]=E["TP.MAINTENANCE COLLECTION POINT"],t["G-S-PM----"]={x1:60,x2:140,y1:-60},I["G-S-PR----"]=E["TP.REARM, REFUEL AND RESUPPLY POINT"],t["G-S-PR----"]={x1:60,x2:140,y1:-60},I["G-S-PU----"]=E["TP.REFUEL ON THE MOVE POINT"],t["G-S-PU----"]={x1:60,x2:140,y1:-60},I["G-S-PO----"]=E["TP.TRAFFIC CONTROL POST"],t["G-S-PO----"]={x1:60,x2:140,y1:-60},I["G-S-PI----"]=E["TP.TRAILER TRANSFER POINT"],t["G-S-PI----"]={x1:60,x2:140,y1:-60},I["G-S-PN----"]=E["TP.UNIT MAINTENANCE COLLECTION POINT"],t["G-S-PN----"]={x1:60,x2:140,y1:-60},I["G-S-PSZ---"]=E["TP.SUPPLY POINT"],t["G-S-PSZ---"]={x1:60,x2:140,y1:-60},I["G-S-PSA---"]=E["TP.SP CLASS I"],t["G-S-PSA---"]={x1:60,x2:140,y1:-60},I["G-S-PSB---"]=E["TP.SP CLASS II"],t["G-S-PSB---"]={x1:60,x2:140,y1:-60},I["G-S-PSC---"]=E["TP.SP CLASS III"],t["G-S-PSC---"]={x1:60,x2:140,y1:-60},I["G-S-PSD---"]=E["TP.SP CLASS IV"],t["G-S-PSD---"]={x1:60,x2:140,y1:-60},I["G-S-PSE---"]=E["TP.SP CLASS V"],t["G-S-PSE---"]={x1:60,x2:140,y1:-60},I["G-S-PSF---"]=E["TP.SP CLASS VI"],t["G-S-PSF---"]={x1:60,x2:140,y1:-60},I["G-S-PSG---"]=E["TP.SP CLASS VII"],t["G-S-PSG---"]={x1:60,x2:140,y1:-60},I["G-S-PSH---"]=E["TP.SP CLASS VIII"],t["G-S-PSH---"]={x1:60,x2:140,y1:-60},I["G-S-PSI---"]=E["TP.SP CLASS IX"],t["G-S-PSI---"]={x1:60,x2:140,y1:-60},I["G-S-PSJ---"]=E["TP.SP CLASS X"],t["G-S-PSJ---"]={x1:60,x2:140,y1:-60},I["G-S-PAS---"]=E["TP.AMMUNITION SUPPLY POINT (ASP)"],t["G-S-PAS---"]={x1:60,x2:140,y1:-60},I["G-S-PAT---"]=E["TP.AMMUNITION TRANSFER POINT (ATP)"],t["G-S-PAT---"]={x1:60,x2:140,y1:-60},I["G-O-ED----"]=E["TP.DITCHED AIRCRAFT"],I["G-O-EP----"]=E["TP.PERSON IN WATER"],I["G-O-EV----"]=E["TP.DISTRESSED VESSEL"],I["G-O-HM----"]=E["TP.SEA MINELIKE"],t["G-O-HM----"]={x1:40,x2:160,y1:40,y2:150},I["G-O-HI----"]=E["TP.ICEBERG"],t["G-O-HI----"]={x1:50,x2:150,y1:50,y2:150},I["G-O-HO----"]=E["TP.OIL RIG/PLATFORM"],t["G-O-HO----"]={x1:30,x2:170,y1:60,y2:140},I["G-O-SB----"]=E["TP.BOTTOM RETURN"],t["G-O-SB----"]={x1:40,x2:160,y1:40,y2:100},I["G-O-SBM---"]=E["TP.INSTALLATION/MANMADE"],t["G-O-SBM---"]={x1:40,x2:160,y1:40,y2:100},I["G-O-SBN---"]=E["TP.BOTTOM RETURN"],t["G-O-SBN---"]={x1:40,x2:160,y1:40,y2:100},I["G-O-SBW---"]=E["TP.WRECK, NON DANGEROUS"],t["G-O-SBW---"]={x1:40,x2:160,y1:70,y2:130},I["G-O-SBX---"]=E["TP.WRECK, DANGEROUS"],t["G-O-SBX---"]={x1:40,x2:160,y1:70,y2:130},I["G-O-SM----"]=E["TP.MARINE LIFE"],t["G-O-SM----"]={x1:100,x2:220,y1:70,y2:130},I["G-O-SS----"]=E["TP.SEA ANOMALY"],t["G-O-SS----"]={x1:50,x2:150,y1:30,y2:120},I["G-O-FA----"]=E["TP.FIX ACOUSTIC"],I["G-O-FE----"]=E["TP.FIX ELECTRO-MAGNETIC"],I["G-O-FO----"]=E["TP.FIX ELECTRO-OPTICAL"]}};s._getMetadata.letter=A,s._getIcons.letter=C,s.addIconParts(D),s.addLabelOverrides(function(I){I["G-T-GD----"]={},I["G-T-GI----"]={},I["G-T-GN----"]={},I["G-C-MGPFE-"]={},I["G-C-MGPFA-"]={},I["G-C-MGPFO-"]={},I["G-C-MGPI--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:45,fontweight:"bold"}},I["G-C-MAAP--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},I["G-C-MAAC--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},I["G-C-MAAU--"]={},I["G-C-MAAD--"]={},I["G-C-MDN---"]={},I["G-C-MMPT--"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:115,y:85,fontsize:45,fontweight:"bold"}},I["G-C-MMPO--"]={},I["G-C-MMPOC-"]={},I["G-C-MMPOR-"]={},I["G-C-MMPOF-"]={},I["G-C-MMPOS-"]={},I["G-C-MMPON-"]={},I["G-C-MMPON-"]={},I["G-C-MMPON-"]={},I["G-C-MOPD--"]={},I["G-C-BOATD-"]={},I["G-C-BOAB--"]={},I["G-C-BOAMA-"]={},I["G-C-BOAMT-"]={},I["G-C-BOAMD-"]={},I["G-C-BOAMC-"]={},I["G-C-BOAMU-"]={},I["G-C-BOAMN-"]={},I["G-C-BOAIP-"]={},I["G-C-BOAIC-"]={},I["G-C-BOAIN-"]={},I["G-C-BOAIS-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},I["G-C-BOAIH-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},I["G-C-BOAID-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},I["G-C-BOAV--"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},I["G-C-BYCG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BSE---"]={},I["G-C-BSF---"]={},I["G-C-BSH---"]={},I["G-C-BSU---"]={},I["G-C-BWN---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-C-BWE---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-C-BWI---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-C-BWF---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},I["G-C-BWP---"]={},I["G-C-BWDP--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDS--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDO--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDEM-"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-BWDTF-"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-FSTP--"]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},I["G-C-FSS---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:125,y:115,fontsize:40,fontweight:"bold"}},I["G-C-FAU---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40,fontweight:"bold"}},I["G-C-SPA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPY---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPM---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPU---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPO---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPN---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQB--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQC--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQD--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQF--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQH--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQI--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPQJ--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPMA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-SPMT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OX----"]={},I["G-C-OXRN--"]={},I["G-C-OXRD--"]={},I["G-C-OXUD--"]={},I["G-C-OXUB--"]={},I["G-C-OXUL--"]={},I["G-C-OXUS--"]={},I["G-C-OXWA--"]={},I["G-C-OXWD--"]={},I["G-C-OXWE--"]={},I["G-C-OXWG--"]={},I["G-C-OXWM--"]={},I["G-C-OXWI--"]={},I["G-C-OXWP--"]={},I["G-C-OXY---"]={},I["G-C-OXYP--"]={},I["G-C-OXYD--"]={},I["G-C-OXYL--"]={},I["G-C-OXYC--"]={},I["G-C-OXYS--"]={},I["G-C-OXYB--"]={},I["G-C-OXYA--"]={},I["G-C-OXYV--"]={},I["G-C-OXYT--"]={},I["G-C-OXYR--"]={},I["G-C-OXYK--"]={},I["G-C-OXN---"]={},I["G-C-OXH---"]={},I["G-C-OXHQ--"]={},I["G-C-OXHA--"]={},I["G-C-OXHY--"]={},I["G-C-OXHX--"]={},I["G-C-OXR---"]={},I["G-C-OXRR--"]={},I["G-C-OXRD--"]={},I["G-C-OXRW--"]={},I["G-C-OXRP--"]={},I["G-C-OXRT--"]={},I["G-C-OXSTC-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTCP"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTCA"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTR-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTH-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTS-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXSTSA"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},I["G-C-OXS---"]={},I["G-C-OXSA--"]={},I["G-C-OXSD--"]={},I["G-C-OXSC--"]={},I["G-C-OXAC--"]={},I["G-C-OXAA--"]={},I["G-C-OXAT--"]={},I["G-C-OXAK--"]={},I["G-C-OXAF--"]={},I["G-C-OXAH--"]={},I["G-C-OXAO--"]={},I["G-C-OXAR--"]={},I["G-C-OXAP--"]={},I["G-C-OXAM--"]={},I["G-C-OXAS--"]={},I["G-C-OXAD--"]={},I["G-C-OG----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGP---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:40,fontsize:45,fontweight:"bold"}},I["G-C-OGT---"]={},I["G-C-OGD---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},I["G-C-OGL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGN---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I["G-C-OGW---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:125,fontsize:70}},I["G-O-VA----"]={},I["G-O-VR----"]={},I["G-O-VE----"]={},I["G-O-VB----"]={},I["G-O-VY----"]={},I["G-O-VD----"]={},I["G-O-VI----"]={},I["G-O-VM----"]={},I["G-O-VK----"]={},I["G-O-VS----"]={},I["G-O-VP----"]={},I["G-O-VU----"]={},I["G-O-VC----"]={},I["G-O-VH----"]={},I["G-O-VF----"]={},I["G-O-VO----"]={},I["G-O-VL----"]={},I["G-O-VX----"]={},I["G-O-VZ----"]={},I["G-O-LB----"]={},I["G-O-LG----"]={},I["G-O-LW----"]={},I["G-O-PR----"]={},I["G-O-PRB---"]={},I["G-O-PT----"]={},I["G-O-PC----"]={},I["G-O-PCU---"]={},I["G-O-PD----"]={},I["G-O-PM----"]={},I["G-O-PH----"]={},I["G-O-PHY---"]={},I["G-O-PHW---"]={},I["G-O-PHG---"]={},I["G-O-PHT---"]={},I["G-O-PG----"]={},I["G-O-PS----"]={},I["G-O-PF----"]={},I["G-O-PI----"]={},I["G-O-PE----"]={},I["G-O-PX----"]={},I["G-O-PJV---"]={},I["G-O-PJA---"]={},I["G-O-PJB---"]={},I["G-O-PK----"]={},I["G-O-PA----"]={},I["G-O-PO----"]={},I["G-O-IR----"]={},I["G-O-IS----"]={},I["G-O-IG----"]={},I["G-O-IV----"]={},I["G-O-IK----"]={},I["G-O-ID----"]={},I["G-O-IF----"]={}},"letter");var F=[S,O,o,M,i,P,c,h,{type:"letter",icons:function(I,t,E,R){I["G-T-GD----"]=E["TP.DESTROY"],t["G-T-GD----"]={x1:0,x2:200,y1:40,y2:160},I["G-T-GI----"]=E["TP.INTERDICT"],t["G-T-GI----"]={x1:0,x2:200,y1:40,y2:160},I["G-T-GN----"]=E["TP.NEUTRALIZE"],t["G-T-GN----"]={x1:0,x2:200,y1:40,y2:160},I["G-C-MGPFE-"]=E["TP.FIX ELECTRO-MAGNETIC"],I["G-C-MGPFA-"]=E["TP.FIX ACOUSTIC"],I["G-C-MGPFO-"]=E["TP.FIX ELECTRO-OPTICAL"],I["G-C-MGPI--"]=E["TP.POINT OF INTEREST"],t["G-C-MGPI--"]={x1:50,x2:150,y1:-25},I["G-C-MAAP--"]=E["TP.AIR CONTROL POINT (ACP)"],t["G-C-MAAP--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-MAAC--"]=E["TP.COMMUNICATIONS CHECKPOINT"],t["G-C-MAAC--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-MAAU--"]=E["TP.PULL-UP POINT"],t["G-C-MAAU--"]={x1:50,x2:240,y1:50,y2:150},I["G-C-MAAD--"]=E["TP.DOWNED AIRCREW PICKUP POINT"],t["G-C-MAAD--"]={x1:60,x2:140,y1:-60},I["G-C-MDN---"]=E["TP.DUMMY MINEFIELD"],t["G-C-MDN---"]={x1:40,x2:160,y1:-10,y2:140},I["G-C-MMPT--"]=E["TP.TARGET REFERENCE"],I["G-C-MMPO--"]=E["TP.OBSERVATION POST/OUTPOST"],t["G-C-MMPO--"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MMPOC-"]=E["TP.COMBAT OUTPOST"],t["G-C-MMPOC-"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MMPOR-"]=E["TP.OBSERVATION POST/RECONNAISSANCE"],t["G-C-MMPOR-"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MMPOF-"]=E["TP.FORWARD OBSERVER POSITION"],t["G-C-MMPOF-"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MMPOS-"]=E["TP.SENSOR OUTPOST"],t["G-C-MMPOS-"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MMPON-"]=E["TP.CBRN OBSERVATION POST"],t["G-C-MMPON-"]={x1:50,x2:150,y1:40,y2:150},I["G-C-MOPD--"]=E["TP.POINT OF DEPARTURE"],t["G-C-MOPD--"]={x1:60,x2:140,y1:-60},I["G-C-BOATD-"]=E["TP.FIXED AND PREFABRICATED"],t["G-C-BOATD-"]={x1:60,x2:140,y1:30},I["G-C-BOAB--"]=E["TP.BOOBY TRAP"],I["G-C-BOAMA-"]=E["TP.ANTIPERSONNEL (AP) MINES"],I["G-C-BOAMT-"]=E["TP.ANTITANK MINE (AT)"],I["G-C-BOAMD-"]=E["TP.(AT) ANTIHANDLING DEVICE"],t["G-C-BOAMD-"]={x1:60,x2:140,y1:40,y2:195},I["G-C-BOAMC-"]=E["TP.(AT) DIRECTIONAL"],t["G-C-BOAMC-"]={x1:60,x2:140,y1:10,y2:140},I["G-C-BOAMU-"]=E["TP.UNSPECIFIED MINE"],I["G-C-BOAMW-"]=E["TP.WIDE AREA MINES"],I["G-C-BOAIP-"]=E["TP.PLANNED MINEFIELD"],t["G-C-BOAIP-"]={x1:40,x2:160,y1:60,y2:140},I["G-C-BOAIC-"]=E["TP.MINEFIELDS STATIC"],t["G-C-BOAIC-"]={x1:40,x2:160,y1:60,y2:140},I["G-C-BOAIN-"]=E["TP.ANTITANK (AT) MINEFIELD"],t["G-C-BOAIN-"]={x1:40,x2:160,y1:60,y2:140},I["G-C-BOAIS-"]=E["TP.SCATTERABLE MINES"],t["G-C-BOAIS-"]={x1:40,x2:160,y1:20,y2:140},I["G-C-BOAIH-"]=E["TP.ANTIPERSONNEL (AP) MINEFIELD"],t["G-C-BOAIH-"]={x1:40,x2:160,y1:20,y2:140},I["G-C-BOAID-"]=E["TP.SCATTERABLE MINEFIELD WITH SELF-DESTRUCT"],t["G-C-BOAID-"]={x1:40,x2:160,y1:20,y2:140},I["G-C-BOAV--"]=E["TP.VOLCANO MINEFIELD"],t["G-C-BOAV--"]={x1:40,x2:160,y1:20,y2:140},I["G-C-BYCG--"]=E["TP.ENGINEER REGULATING POINT"],t["G-C-BYCG--"]={x1:60,x2:140,y1:-60},I["G-C-BSE---"]=E["TP.EARTHWORK/FORTIFICATION"],I["G-C-BSF---"]=E["TP.FORT"],I["G-C-BSH---"]=E["TP.SURFACE SHELTER"],I["G-C-BSU---"]=E["TP.UNDERGROUND SHELTER"],I["G-C-BWN---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],t["G-C-BWN---"]={x1:60,x2:140,y1:-20},I["G-C-BWE---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],t["G-C-BWE---"]={x1:60,x2:140,y1:-20},I["G-C-BWI---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"],t["G-C-BWI---"]={x1:60,x2:140,y1:-20},I["G-C-BWF---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"],t["G-C-BWF---"]={x1:60,x2:140,y1:-20},I["G-C-BWP---"]=E["TP.NUCLEAR FALLOUT PRODUCING"],t["G-C-BWP---"]={x1:50,x2:150,y1:-20},I["G-C-BWDP--"]=E["TP.DECON SITE/POINT"],t["G-C-BWDP--"]={x1:60,x2:140,y1:-60},I["G-C-BWDA--"]=E["TP.ALTERNATE DECON SITE/POINT"],t["G-C-BWDA--"]={x1:60,x2:140,y1:-60},I["G-C-BWDT--"]=E["TP.DECON SITE/POINT (TROOPS)"],t["G-C-BWDT--"]={x1:60,x2:140,y1:-60},I["G-C-BWDE--"]=E["TP.DECON SITE/POINT (EQUIPMENT)"],t["G-C-BWDE--"]={x1:60,x2:140,y1:-60},I["G-C-BWDS--"]=E["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],t["G-C-BWDS--"]={x1:60,x2:140,y1:-60},I["G-C-BWDO--"]=E["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],t["G-C-BWDO--"]={x1:60,x2:140,y1:-60},I["G-C-BWDG--"]=E["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],t["G-C-BWDG--"]={x1:60,x2:140,y1:-60},I["G-C-BWDEM-"]=E["TP.DECON POINT (MAIN) EQUIPMENT"],t["G-C-BWDEM-"]={x1:60,x2:140,y1:-60},I["G-C-BWDTF-"]=E["TP.DECON POINT (FORWARD) TROOPS"],t["G-C-BWDTF-"]={x1:60,x2:140,y1:-60},I["G-C-FSTP--"]=E["TP.POINT/SINGLE TARGET"],I["G-C-FSS---"]=E["TP.FIRE SUPPORT STATION"],I["G-C-FAU---"]=E["TP.NUCLEAR TARGET"],I["G-C-SPA---"]=E["TP.AMBULANCE EXCHANGE POINT"],t["G-C-SPA---"]={x1:60,x2:140,y1:-60},I["G-C-SPC---"]=E["TP.CANNIBALIZATION POINT"],t["G-C-SPC---"]={x1:60,x2:140,y1:-60},I["G-C-SPY---"]=E["TP.CASUALTY COLLECTION POINT"],t["G-C-SPY---"]={x1:60,x2:140,y1:-60},I["G-C-SPT---"]=E["TP.CIVILIAN COLLECTION POINT"],t["G-C-SPT---"]={x1:60,x2:140,y1:-60},I["G-C-SPD---"]=E["TP.DETAINEE COLLECTION POINT"],t["G-C-SPD---"]={x1:60,x2:140,y1:-60},I["G-C-SPE---"]=E["TP.EPW COLLECTION POINT"],t["G-C-SPE---"]={x1:60,x2:140,y1:-60},I["G-C-SPL---"]=E["TP.LOGISTICS RELEASE POINT"],t["G-C-SPL---"]={x1:60,x2:140,y1:-60},I["G-C-SPM---"]=E["TP.MAINTENANCE COLLECTION POINT"],t["G-C-SPM---"]={x1:60,x2:140,y1:-60},I["G-C-SPR---"]=E["TP.REARM, REFUEL AND RESUPPLY POINT"],t["G-C-SPR---"]={x1:60,x2:140,y1:-60},I["G-C-SPU---"]=E["TP.REFUEL ON THE MOVE POINT"],t["G-C-SPU---"]={x1:60,x2:140,y1:-60},I["G-C-SPO---"]=E["TP.TRAFFIC CONTROL POST"],t["G-C-SPO---"]={x1:60,x2:140,y1:-60},I["G-C-SPI---"]=E["TP.TRAILER TRANSFER POINT"],t["G-C-SPI---"]={x1:60,x2:140,y1:-60},I["G-C-SPN---"]=E["TP.UNIT MAINTENANCE COLLECTION POINT"],t["G-C-SPN---"]={x1:60,x2:140,y1:-60},I["G-C-SPQT--"]=E["TP.SUPPLY POINT"],t["G-C-SPQT--"]={x1:60,x2:140,y1:-60},I["G-C-SPQA--"]=E["TP.SP CLASS I"],t["G-C-SPQA--"]={x1:60,x2:140,y1:-60},I["G-C-SPQB--"]=E["TP.SP CLASS II"],t["G-C-SPQB--"]={x1:60,x2:140,y1:-60},I["G-C-SPQC--"]=E["TP.SP CLASS III"],t["G-C-SPQC--"]={x1:60,x2:140,y1:-60},I["G-C-SPQD--"]=E["TP.SP CLASS IV"],t["G-C-SPQD--"]={x1:60,x2:140,y1:-60},I["G-C-SPQE--"]=E["TP.SP CLASS V"],t["G-C-SPQE--"]={x1:60,x2:140,y1:-60},I["G-C-SPQF--"]=E["TP.SP CLASS VI"],t["G-C-SPQF--"]={x1:60,x2:140,y1:-60},I["G-C-SPQG--"]=E["TP.SP CLASS VII"],t["G-C-SPQG--"]={x1:60,x2:140,y1:-60},I["G-C-SPQH--"]=E["TP.SP CLASS VIII"],t["G-C-SPQH--"]={x1:60,x2:140,y1:-60},I["G-C-SPQI--"]=E["TP.SP CLASS IX"],t["G-C-SPQI--"]={x1:60,x2:140,y1:-60},I["G-C-SPQJ--"]=E["TP.SP CLASS X"],t["G-C-SPQJ--"]={x1:60,x2:140,y1:-60},I["G-C-SPMA--"]=E["TP.AMMUNITION SUPPLY POINT (ASP)"],t["G-C-SPMA--"]={x1:60,x2:140,y1:-60},I["G-C-SPMT--"]=E["TP.AMMUNITION TRANSFER POINT (ATP)"],t["G-C-SPMT--"]={x1:60,x2:140,y1:-60},I["G-C-OX----"]=E["TP.SPECIAL POINT"],t["G-C-OX----"]={x1:40,x2:160,y1:40,y2:160},I["G-C-OXRN--"]=E["TP.NAVIGATIONAL REFERENCE"],t["G-C-OXRN--"]={x1:40,x2:160,y1:40,y2:160},I["G-C-OXUD--"]=E["TP.DATUM"],t["G-C-OXUD--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXUB--"]=E["TP.BRIEF CONTACT"],t["G-C-OXUB--"]={x1:50,x2:150,y1:0,y2:100},I["G-C-OXUL--"]=E["TP.LOST CONTACT"],t["G-C-OXUL--"]={x1:50,x2:150,y1:0,y2:100},I["G-C-OXUS--"]=E["TP.SINKER"],t["G-C-OXUS--"]={x1:50,x2:150,y1:0,y2:100},I["G-C-OXWA--"]=E["TP.AIM POINT"],t["G-C-OXWA--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXWD--"]=E["TP.DROP POINT"],t["G-C-OXWD--"]={x1:50,x2:150,y1:50,y2:120},I["G-C-OXWE--"]=E["TP.ENTRY POINT"],t["G-C-OXWE--"]={x1:50,x2:150,y1:50},I["G-C-OXWG--"]=E["TP.GROUND ZERO"],t["G-C-OXWG--"]={x1:50,x2:150,y1:30},I["G-C-OXWM--"]=E["TP.MSL DETECT POINT"],t["G-C-OXWM--"]={x1:50,x2:150,y1:30},I["G-C-OXWI--"]=E["TP.IMPACT POINT"],t["G-C-OXWI--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXWP--"]=E["TP.PREDICTED IMPACT POINT"],t["G-C-OXWP--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXY---"]=E["TP.SONOBUOY"],t["G-C-OXY---"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYP--"]=E["TP.SONOBUOY PATTERN CENTER"],t["G-C-OXYP--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYD--"]=E["TP.SONOBUOY DIFAR"],t["G-C-OXYD--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYL--"]=E["TP.SONOBUOY LOFAR"],t["G-C-OXYL--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYC--"]=E["TP.SONOBUOY CASS"],t["G-C-OXYC--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYS--"]=E["TP.SONOBUOY DICASS"],t["G-C-OXYS--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYB--"]=E["TP.SONOBUOY BT"],t["G-C-OXYB--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYA--"]=E["TP.SONOBUOY ANM"],t["G-C-OXYA--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYV--"]=E["TP.SONOBUOY VLAD"],t["G-C-OXYV--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYT--"]=E["TP.SONOBUOY ATAC"],t["G-C-OXYT--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYR--"]=E["TP.SONOBUOY RO"],t["G-C-OXYR--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXYK--"]=E["TP.SONOBUOY KINGPIN"],t["G-C-OXYK--"]={x1:60,x2:140,y1:-10,y2:160},I["G-C-OXN---"]=E["TP.FORMATION"],t["G-C-OXN---"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXH---"]=E["TP.HARBOR"],t["G-C-OXH---"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXHQ--"]=E["TP.HARBOR POINT Q"],t["G-C-OXHQ--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXHA--"]=E["TP.HARBOR POINT A"],t["G-C-OXHA--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXHY--"]=E["TP.HARBOR POINT Y"],t["G-C-OXHY--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXHX--"]=E["TP.HARBOR POINT X"],t["G-C-OXHX--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXR---"]=E["TP.ROUTE"],t["G-C-OXR---"]={x1:30,x2:170,y1:60,y2:140},I["G-C-OXRR--"]=E["TP.ROUTE RENDEZVOUS"],t["G-C-OXRR--"]={x1:30,x2:170,y1:60,y2:170},I["G-C-OXRD--"]=E["TP.ROUTE DIVERSIONS"],t["G-C-OXRD--"]={x1:30,x2:170,y1:60,y2:170},I["G-C-OXRW--"]=E["TP.ROUTE WAYPOINT"],t["G-C-OXRW--"]={x1:30,x2:170,y1:60,y2:170},I["G-C-OXRP--"]=E["TP.ROUTE PIM"],t["G-C-OXRP--"]={x1:30,x2:170,y1:60,y2:170},I["G-C-OXRT--"]=E["TP.ROUTE POINT R"],t["G-C-OXRT--"]={x1:30,x2:170,y1:60,y2:170},I["G-C-OXSTC-"]=E["TP.COMBATANT STATION"],t["G-C-OXSTC-"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTCP"]=E["TP.PICKET STATION"],t["G-C-OXSTCP"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTCA"]=E["TP.ASW SHIP STATION"],t["G-C-OXSTCA"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTR-"]=E["TP.REPLENISHMENT AT SEA (RAS) STATION"],t["G-C-OXSTR-"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTH-"]=E["TP.RESCUE STATION"],t["G-C-OXSTH-"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTS-"]=E["TP.SUBMARINE STATION"],t["G-C-OXSTS-"]={x1:-15,x2:140,y1:60,y2:140},I["G-C-OXSTSA"]=E["TP.ASW SUBMARINE STATION"],t["G-C-OXSTSA"]={x1:-115,x2:140,y1:60,y2:140},I["G-C-OXS---"]=E["TP.SEARCH"],t["G-C-OXS---"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXSA--"]=E["TP.SEARCH AREA"],t["G-C-OXSA--"]={x1:20,x2:150,y1:50,y2:150},I["G-C-OXSD--"]=E["TP.DIP POSITION"],t["G-C-OXSD--"]={x1:10,x2:150,y1:50,y2:150},I["G-C-OXSC--"]=E["TP.SEARCH CENTER"],t["G-C-OXSC--"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OXAC--"]=E["TP.COMBAT AIR PATROL (CAP)"],t["G-C-OXAC--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAA--"]=E["TP.AIRBORNE EARLY WARNING (AEW)"],t["G-C-OXAA--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAT--"]=E["TP.TACAN"],t["G-C-OXAT--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAK--"]=E["TP.TANKING"],t["G-C-OXAK--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAF--"]=E["TP.FIXED WING"],t["G-C-OXAF--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAH--"]=E["TP.ROTARY WING"],t["G-C-OXAH--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAO--"]=E["TP.TOMCAT"],t["G-C-OXAO--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAR--"]=E["TP.RESCUE"],t["G-C-OXAR--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAP--"]=E["TP.REPLENISH"],t["G-C-OXAP--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAM--"]=E["TP.MARSHALL"],t["G-C-OXAM--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAS--"]=E["TP.STRIKE IP"],t["G-C-OXAS--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OXAD--"]=E["TP.CORRIDOR TAB POINT"],t["G-C-OXAD--"]={x1:60,x2:140,y1:40,y2:160},I["G-C-OG----"]=E["TP.ACTION POINT"],t["G-C-OG----"]={x1:60,x2:140,y1:-60},I["G-C-OGC---"]=E["TP.ACTION POINT"],t["G-C-OGC---"]={x1:60,x2:140,y1:-60},I["G-C-OGP---"]=E["TP.CONTACT POINT"],t["G-C-OGP---"]={x1:55,x2:145,y1:-10},I["G-C-OGT---"]=E["TP.COORDINATION POINT"],t["G-C-OGT---"]={x1:50,x2:150,y1:50,y2:150},I["G-C-OGD---"]=E["TP.DECISION POINT"],t["G-C-OGD---"]={x1:30,x2:170,y1:25,y2:160},I["G-C-OGL---"]=E["TP.ACTION LINKUP POINT"],t["G-C-OGL---"]={x1:60,x2:140,y1:-60},I["G-C-OGN---"]=E["TP.ACTION PASSAGE POINT"],t["G-C-OGN---"]={x1:60,x2:140,y1:-60},I["G-C-OGR---"]=E["TP.ACTION RALLY POINT"],t["G-C-OGR---"]={x1:60,x2:140,y1:-60},I["G-C-OGS---"]=E["TP.ACTION RELEASE POINT"],t["G-C-OGS---"]={x1:60,x2:140,y1:-60},I["G-C-OGI---"]=E["TP.ACTION START POINT"],t["G-C-OGI---"]={x1:60,x2:140,y1:-60},I["G-C-OGW---"]=E["TP.WAYPOINT"],t["G-C-OGW---"]={x1:60,x2:140,y1:60,y2:140},I["G-O-VA----"]=E["TP.FIRE"],I["G-O-VR----"]=E["GR.EQ.HOWITZER"],I["G-O-VE----"]=E["ST.IC.KILLING VICTIM"],I["G-O-VB----"]=E["AIR.MISSILE.IC.BOMB"],I["G-O-VY----"]=E["ST.IC.BOOBY TRAP"],I["G-O-VD----"]=E["ST.IC.DRIVE-BY SHOOTING"],I["G-O-VI----"]=E["TP.INDIRECT FIRE"],I["G-O-VM----"]=E["GR.EQ.MORTAR"],I["G-O-VK----"]=E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],I["G-O-VS----"]=E["ST.IC.SNIPING"],I["G-O-VP----"]=E["ST.IC.POISONING"],I["G-O-VU----"]=E["TP.AMBUSH"],I["G-O-VC----"]=E["GR.IC.FF.CLASS V"],I["G-O-VH----"]=E["AR.I.FF.CIVILIAN ROTARY WING"],I["G-O-VF----"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.MOTORIZED"]],I["G-O-VO----"]=E["GR.IC.FF.INFANTRY"],I["G-O-VL----"]=E["GR.IC.FF.RECONNAISSANCE"],I["G-O-VX----"]=E["GR.IC.FF.SIGNAL"],I["G-O-VZ----"]=E["GR.IC.FF.SUPPLY"],I["G-O-LB----"]=E["ST.IC.BLACK LIST LOCATION"],I["G-O-LG----"]=E["ST.IC.GRAY LIST LOCATION"],I["G-O-LW----"]=E["ST.IC.WHITE LIST LOCATION"],I["G-O-PR----"]=E["TP.ROAD BLOCK"],I["G-O-PRB---"]=E["TP.ROAD BLOCK (UNDER CONSTRUCTION)"],I["G-O-PT----"]=E["ST.IC.PATROLLING"],I["G-O-PC----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.WILLING"]],I["G-O-PCU---"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.COERCED/IMPRESSED"]],I["G-O-PD----"]=E["ST.IC.DEMONSTRATION"],I["G-O-PM----"]=E["ST.IC.MINE LAYING"],I["G-O-PH----"]=E["ST.IC.PSYCHOLOGICAL OPERATIONS"],I["G-O-PHY---"]=E["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"],I["G-O-PHW---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],I["G-O-PHG---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],I["G-O-PHT---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.HOUSE-TO-HOUSE"]],I["G-O-PG----"]=E["ST.IC.SEARCHING"],I["G-O-PS----"]=E["ST.IC.SPY"],I["G-O-PF----"]=E["ST.IC.FOOD DISTRIBUTION"],I["G-O-PI----"]=E["GR.IC.FF.MEDICAL TREATMENT FACILITY"],I["G-O-PE----"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.INTERCEPT"]],I["G-O-PX----"]=E["ST.IC.EXTORTION"],I["G-O-PJV---"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],I["G-O-PJA---"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],I["G-O-PJB---"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],I["G-O-PK----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"]],I["G-O-PA----"]=E["ST.IC.ARREST"],I["G-O-PO----"]=E["ST.IC.DRUG RELATED ACTIVITIES"],I["G-O-IR----"]=E["ST.IC.GROUP"],I["G-O-IS----"]=E["ST.IC.SAFE HOUSE"],I["G-O-IG----"]=E["ST.IC.GRAFFITI"],I["G-O-IV----"]=E["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"],I["G-O-IK----"]=E["ST.IC.KNOWN INSURGENT VEHICLE"],I["G-O-ID----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.DRUG"]],I["G-O-IF----"]=E["ST.IC.INTERNAL SECURITY FORCE"]}}],f=[S,O,o,M,i,P,c,h,U,d,{type:"letter",icons:function(I,t,E,R){I["S-S-S-----"]=E["2525B.STN"],I["S-S-SP----"]=E["2525B.STN.PKT"],I["S-S-SA----"]=E["2525B.STN.ASWSHP"],I["S-S-NN----"]=E["2525B.NCBTT.STN"],I["S-S-NNR---"]=E["2525B.STN.RSC"],I["S-U-SS----"]=E["2525B.SUB.STN"],I["S-U-SSA---"]=E["2525B.ASWSUB"],I["G-O-SBWD--"]=E["TP.WRECK, DANGEROUS"],t["G-O-SBXD--"]={x1:35,x2:165,y1:70,y2:130}}},m],z=[S,O,o,M,i,P,c,h,U,d,p,m];function H(I,t,E){var R=this.options.sidc.substr(2,1),e=this.options.sidc.substr(3,1),A=this.options.sidc.substr(4,2),C=this.options.sidc.substr(6,1),T=this.options.sidc.substr(7,1),S=this.options.sidc.substr(8,2),N=t.functionid=this.options.sidc.substr(10,10);return t.context=E.context[parseInt(this.options.sidc.substr(2,1))],t.affiliation={0:"Unknown",1:"Unknown",2:"Friend",3:"Friend",4:"Neutral",5:"Hostile",6:"Hostile"}[e],t.dimension={"00":"Sea","01":"Air","02":"Air","05":"Air","06":"Air",10:"Ground",11:"Ground",12:"Ground",15:"Ground",20:"Ground",30:"Sea",35:"Subsurface",36:"Subsurface",39:"Subsurface",40:"Ground",50:"Air",51:"Air",52:"Ground",53:"Sea",54:"Subsurface",60:"Ground"}[A]||"","10"!=A&&"11"!=A&&"25"!=A&&"27"!=A&&"40"!=A||(t.unit=!0),"05"!=A&&"06"!=A&&"50"!=A||(t.space=!0),"40"==A&&(t.activity=!0),"20"==A&&(t.installation=!0),"25"==A&&(t.controlMeasure=!0),"60"==A&&(t.cyberspace=!0),"36"==A&&!1===this.style.alternateMedal&&(t.fill=!1),"30"==A&&15e4==N.substr(0,6)&&(t.frame=!1),"1"==C&&(t.notpresent=I._dashArrays.anticipated),"0"!=e&&"2"!=e&&"5"!=e||(t.notpresent=I._dashArrays.pending),"30"==A&&16e4==N.substr(0,6)&&(t.notpresent=I._dashArrays.pending),"35"==A&&14e4==N.substr(0,6)&&(t.notpresent=I._dashArrays.pending),"35"==A&&15e4==N.substr(0,6)&&(t.notpresent=I._dashArrays.pending),"2"!=C&&"3"!=C&&"4"!=C&&"5"!=C||(t.condition=E.status[parseInt(C)]),t.baseDimension=t.dimension,t.baseAffilation=t.affiliation,"5"==e&&"1"==R&&(t.joker=!0),"6"==e&&"1"==R&&(t.faker=!0),(t.joker||t.faker)&&(t.affiliation=E.affiliation[1]),"00"==A&&(t.dimensionUnknown=!0),"00"==A&&"1"==R&&"Unknown"!=t.affiliation&&(t.affiliation=""),"27"==A&&(t.dimension="LandDismountedIndividual",t.dismounted=!0),"15"!=A&&"52"!=A||(t.dimension=E.dimension[2]),-1<["1","3","5","7"].indexOf(T)&&(t.feintDummy=!0),-1<["2","3","6","7"].indexOf(T)&&(t.headquarters=!0),-1<["4","5","6","7"].indexOf(T)&&(t.taskForce=!0),S<=30&&(t.echelon=E.echelonMobility[S]),30<=S&&S<70&&(t.mobility=E.echelonMobility[S]),70<=S&&S<80&&(t.leadership=E.echelonMobility[S]),("01"==A&&"12"==N.substring(0,2)||"05"==A&&"12"==N.substring(0,2)||"11"==A||"12"==A&&"12"==N.substring(0,2)||"15"==A&&"16"==N.substring(0,2)||"30"==A&&"14"==N.substring(0,2)||"35"==A&&"12"==N.substring(0,2))&&(t.civilian=!0),t}function V(I,t,E,R){var e={},A={},C={},T={};for(var S in I._iconSIDC.number)I._iconSIDC.number.hasOwnProperty(S)&&I._iconSIDC.number[S].call(this,e,A,C,T,t,E,R);return{icons:e,m1:A,m2:C,bbox:T}}s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(N);var k={type:"number",icons:function(I,t,E,R,e,A,C){"01"==e&&(I[11e4]=[A["AR.I.MILITARY"]],I[110100]=[A["AR.I.FIXED-WING DSymbol"]],I[110101]=[A["AR.I.MEDICAL EVACUATION"]],I[110102]=[A["AR.I.ATTACK/STRIKE"]],I[110103]=[A["AR.I.BOMBER"]],I[110104]=[A["AR.I.FIGHTER"]],I[110105]=[A["AR.I.FIGHTER/BOMBER"]],I[110106]=[],I[110107]=[A["AR.I.CARGO"]],I[110108]=[A["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I[110109]=[A["AR.I.TANKER"]],I[110110]=[A["AR.I.PATROL"]],I[110111]=[A["AR.I.RECONNAISSANCE"]],I[110112]=[A["AR.I.TRAINER"]],I[110113]=[A["AR.I.UTILITY"]],I[110114]=[A["AR.I.VSTOL"]],I[110115]=[A["AR.I.AIRBORNE COMMAND POST"]],I[110116]=[A["AR.I.AIRBORNE EARLY WARNING"]],I[110117]=[A["AR.I.ANTISURFACE WARFARE"]],I[110118]=[A["AR.I.ANTISUBMARINE WARFARE"]],I[110119]=[A["AR.I.COMMUNICATIONS"]],I[110120]=[A["AR.I.COMBAT SEARCH AND RESCUE"]],I[110121]=[A["AR.I.ELECTRONIC SUPPORT"]],I[110122]=[A["AR.I.GOVERNMENT"]],I[110123]=[A["AR.I.MINE COUNTERMEASURES"]],I[110124]=[A["AR.I.PERSONNEL RECOVERY DSymbol"]],I[110125]=[A["AR.I.SEARCH AND RESCUE"]],I[110126]=[A["AR.I.SPECIAL OPERATIONS FORCES"]],I[110127]=[A["AR.I.ULTRA LIGHT"]],I[110128]=[A["AR.I.PHOTOGRAPHIC RECONNAISSANCE"]],I[110129]=[A["AR.I.VIP"]],I[110130]=[A["AR.I.SUPRESSION OF ENEMY AIR DEFENCE"]],I[110131]=[A["AR.I.PASSENGER"]],I[110132]=[A["AR.I.ESCORT"]],I[110133]=[A["AR.I.ELECTRONIC ATTACK (EA)"]],I[110200]=[A["AR.I.MILITARY ROTARY WING"]],I[110300]=[A["AR.I.UNMANNED AERIAL VEHICLE"]],I[110400]=[A["AR.I.VERTICAL-TAKEOFF UAV (VT-UAV)"]],I[110500]=[A["AR.I.MILITARY BALLOON"]],I[110600]=[A["AR.I.MILITARY AIRSHIP"]],I[110700]=[A["AR.I.TETHERED LIGHTER THAN AIR"]],I[12e4]=[A["AR.I.CIVILIAN"]],I[120100]=[A["AR.I.CIVILIAN FIXED-WING DSymbol"]],I[120200]=[A["AR.I.CIVILIAN ROTARY WING"]],I[120300]=[A["AR.I.CIVILIAN UNMANNED AERIAL VEHICLE"]],I[120400]=[A["AR.I.CIVILIAN BALLOON"]],I[120500]=[A["AR.I.CIVILIAN AIRSHIP"]],I[120600]=[A["AR.I.CIVILIAN TETHERED LIGHTER THAN AIR"]],I[13e4]=[A["AR.I.WEAPON"]],I[130100]=[A["AR.I.BOMB"]],I[130200]=[A["AR.I.UNDERWATER DECOY DSymbol"]],I[14e4]=[A["AR.I.MANUAL TRACK"]],t["01"]=[A["AIR.M1.ATTACK"]],t["02"]=[A["AIR.M1.BOMBER"]],t["03"]=[A["AIR.M1.CARGO"]],t["04"]=[A["AIR.M1.FIGHTER"]],t["05"]=[A["AIR.M1.INTERCEPTOR"]],t["06"]=[A["AIR.M1.TANKER"]],t["07"]=[A["AIR.M1.UTILITY"]],t["08"]=[A["AIR.M1.VSTOL"]],t["09"]=[A["AIR.M1.PASSENGER"]],t[10]=[A["AIR.M1.ULTRA LIGHT"]],t[11]=[A["AIR.M1.AIRBORNE COMMAND POST"]],t[12]=[A["AIR.M1.AIRBORNE EARLY WARNING"]],t[13]=[A["AIR.M1.GOVERNMENT"]],t[14]=[A["AIR.M1.MEDEVAC"]],t[15]=[A["AIR.M1.ESCORT"]],t[16]=[A["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t[17]=[A["AIR.M1.PATROL"]],t[18]=[A["AIR.M1.RECONNAISSANCE"]],t[19]=[A["AIR.M1.TRAINER"]],t[20]=[A["AIR.M1.PHOTOGRAPHIC"]],t[21]=[A["AIR.M1.PERSONNEL RECOVERY"]],t[22]=[A["AIR.M1.ANTISUBMARINE WARFARE"]],t[23]=[A["AIR.M1.COMMUNICATIONS"]],t[24]=[A["AIR.M1.ELECTRONIC SUPPORT (ES)"]],t[25]=[A["AIR.M1.MINE COUNTERMEASURES"]],t[26]=[A["AIR.M1.SEARCH AND RESCUE"]],t[27]=[A["AIR.M1.SPECIAL OPERATIONS FORCES"]],t[28]=[A["AIR.M1.SURFACE WARFARE"]],t[29]=[A["AIR.M1.VIP"]],t[30]=[A["AIR.M1.COMBAT SEARCH AND RESCUE"]],t[31]=[A["AIR.M1.SUPRESSION OF ENEMY AIR DEFENCE"]],t[32]=[A["AIR.M1.ANTISURFACE WARFARE"]],t[33]=[A["AIR.M1.FIGHTER/BOMBER"]],t[34]=[A["AIR.M1.INTENSIVE CARE"]],t[35]=[A["AIR.M1.ELECTRONIC ATTACK (EA)"]],t[36]=[A["AIR.M1.MULTIMISSION"]],t[37]=[A["AIR.M1.HIJACKING"]],t[38]=[A["AIR.M1.ASW HELO-LAMPS"]],t[39]=[A["AIR.M1.ASW HELO - SH-60R"]],t[40]=[A["AIR.M1.HIJACKER"]],t[41]=[A["AIR.M1.CYBERSPACE"]],E["01"]=[A["AIR.M2.HEAVY"]],E["02"]=[A["AIR.M2.MEDIUM"]],E["03"]=[A["AIR.M2.LIGHT"]],E["04"]=[A["AIR.M2.BOOM-ONLY"]],E["05"]=[A["AIR.M2.DROUGE-ONLY"]],E["06"]=[A["AIR.M2.BOOM AND DROUGE"]],E["07"]=[A["AIR.M2.CLOSE RANGE"]],E["08"]=[A["AIR.M2.SHORT RANGE"]],E["09"]=[A["AIR.M2.MEDIUM RANGE"]],E[10]=[A["AIR.M2.LONG RANGE"]],E[11]=[A["AIR.M2.DOWNLINKED"]],E[12]=[A["AIR.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(N);var B={type:"number",icons:function(I,t,E,R,e,A,C){"02"==e&&(I[11e4]=[A["AIR.MISSILE.ICON"]],t["01"]=[A["AIR.MISSILE.M1.AIR"]],t["02"]=[A["AIR.MISSILE.M1.SURFACE"]],t["03"]=[A["AIR.MISSILE.M1.SUBSURFACE"]],t["04"]=[A["AIR.MISSILE.M1.SPACE"]],t["05"]=[A["AIR.MISSILE.M1.ANTI-BALLISTIC"]],t["06"]=[A["AIR.MISSILE.M1.BALLISTIC"]],t["07"]=[A["AIR.MISSILE.M1.CRUISE"]],t["08"]=[A["AIR.MISSILE.M1.INTERCEPTOR"]],E["01"]=[A["AIR.MISSILE.M2.AIR"]],E["02"]=[A["AIR.MISSILE.M2.SURFACE"]],E["03"]=[A["AIR.MISSILE.M2.SUBSURFACE"]],E["04"]=[A["AIR.MISSILE.M2.SPACE"]],E["05"]=[A["AIR.MISSILE.M2.LAUNCHED"]],E["06"]=[A["AIR.MISSILE.M2.MISSILE"]],E["07"]=[A["AIR.MISSILE.M2.PATRIOT"]],E["08"]=[A["AIR.MISSILE.M2.STANDARD MISSILE - 2 (SM-2)"]],E["09"]=[A["AIR.MISSILE.M2.STANDARD MISSILE - 6 (SM-6)"]],E[10]=[A["AIR.MISSILE.M2.EVOLVED SEA SPARROW MISSILE (ESSM)"]],E[11]=[A["AIR.MISSILE.M2.ROLLING AIRFRAME MISSILE (RAM)"]],E[12]=[A["AIR.MISSILE.M2.SHORT RANGE"]],E[13]=[A["AIR.MISSILE.M2.MEDIUM RANGE"]],E[14]=[A["AIR.MISSILE.M2.INTERMEDIATE RANGE"]],E[15]=[A["AIR.MISSILE.M2.LONG RANGE"]],E[16]=[A["AIR.MISSILE.M2.INTERCONTINENTAL"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(T);var Y={type:"number",icons:function(I,t,E,R,e,A,C){"05"==e&&(I[11e4]=[A["SP.I.MILITARY"]],I[110100]=[A["SP.I.SPACE VEHICLE"]],I[110200]=[A["SP.I.RE-ENTRY VEHICLE"]],I[110300]=[A["SPACE.PLANET LANDER"]],I[110400]=[A["SP.I.ORBITER SHUTTLE"]],I[110500]=[A["SP.I.CAPSULE"]],I[110600]=[A["SP.I.SATELLITE, GENERAL"]],I[110700]=[A["SP.I.SATELLITE"]],I[110800]=[A["SP.I.ANTISATELLITE WEAPON"]],I[110900]=[A["SP.I.ASTRONOMICAL SATELLITE"]],I[111e3]=[A["SP.I.BIOSATELLITE"]],I[111100]=[A["SP.I.COMMUNICATIONS SATELLITE"]],I[111200]=[A["SP.I.EARTH OBSERVATION SATELLITE"]],I[111300]=[A["SP.I.MINIATURIZED SATELLITE"]],I[111400]=[A["SP.I.NAVIGATIONAL SATELLITE"]],I[111500]=[A["SP.I.RECONNAISSANCE SATELLITE"]],I[111600]=[A["SP.I.SPACE STATION"]],I[111700]=[A["SP.I.TETHERED SATELLITE"]],I[111800]=[A["SP.I.WEATHER SATELLITE"]],I[111900]=[A["SP.I.SPACE LAUNCH VEHICLE"]],I[12e4]=[A["SP.I.CIVILIAN"]],I[120100]=[A["SP.I.CIVILIAN ORBITER SHUTTLE"]],I[120200]=[A["SP.I.CIVILIAN CAPSULE"]],I[120300]=[A["SP.I.CIVILIAN SATELLITE"]],I[120400]=[A["SP.I.CIVILIAN ASTRONOMICAL SATELLITE"]],I[120500]=[A["SP.I.CIVILIAN BIOSATELLITE"]],I[120600]=[A["SP.I.CIVILIAN COMMUNICATIONS SATELLITE"]],I[120700]=[A["SP.I.CIVILIAN EARTH OBSERVATION SATELLITE"]],I[120800]=[A["SP.I.CIVILIAN MINIATURIZED SATELLITE"]],I[120900]=[A["SP.I.CIVILIAN NAVIGATIONAL SATELLITE"]],I[121e3]=[A["SP.I.CIVILIAN SPACE STATION"]],I[121100]=[A["SP.I.CIVILIAN TETHERED SATELLITE"]],I[121200]=[A["SP.I.CIVILIAN WEATHER SATELLITE"]],I[13e4]=[A["SP.I.MANUAL TRACK"]],t["01"]=[A["SP.M1.LOW EARTH ORBIT (LEO)"]],t["02"]=[A["SP.M1.MEDIUM EARTH ORBIT (MEO)"]],t["03"]=[A["SP.M1.HIGH EARTH ORBIT (HEO)"]],t["04"]=[A["SP.M1.GEOSYNCHRONOUS ORBIT (GSO)"]],t["05"]=[A["SP.M1.GEOSTATIONARY ORBIT (GO)"]],t["06"]=[A["SP.M1.MOLNIYA ORBIT (MO)"]],t["07"]=[A["SP.M1.CYBERSPACE"]],E["01"]=[A["SP.M2.OPTICAL"]],E["02"]=[A["SP.M2.INFRARED"]],E["03"]=[A["SP.M2.RADAR"]],E["04"]=[A["SP.M2.SIGNALS INTELLIGENCE (SIGINT)"]],E["05"]=[A["SP.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(T);var W={type:"number",icons:function(I,t,E,R,e,A,C){"06"==e&&(I[11e4]=[A["SPACE.MISSILE.ICON"]],t["01"]=[A["SPACE.MISSILE.M1.BALLISTIC"]],t["02"]=[A["SPACE.MISSILE.M1.SPACE"]],t["03"]=[A["SPACE.MISSILE.M1.INTERCEPTOR"]],E["01"]=[A["SPACE.MISSILE.M2.SHORT RANGE"]],E["02"]=[A["SPACE.MISSILE.M2.MEDIUM RANGE"]],E["03"]=[A["SPACE.MISSILE.M2.INTERMEDIATE RANGE"]],E["04"]=[A["SPACE.MISSILE.M2.LONG RANGE"]],E["05"]=[A["SPACE.MISSILE.M2.INTERCONTINENTAL"]],E["06"]=[A["SPACE.MISSILE.M2.ARROW"]],E["07"]=[A["SPACE.MISSILE.M2.GROUND-BASED INTERCEPTOR (GBI)"]],E["08"]=[A["SPACE.MISSILE.M2.PATRIOT"]],E["09"]=[A["SPACE.MISSILE.M2.STANDARD MISSILE - TERMINAL PHASE (SM-T)"]],E[10]=[A["SPACE.MISSILE.M2.STANDARD MISSILE - 3 (SM-3)"]],E[11]=[A["SPACE.MISSILE.M2.TERMINAL HIGH-ALTITUDE AREA DEFENSE (THAAD)"]],E[12]=[A["SPACE.MISSILE.M2.SPACE"]],E[13]=[A["SPACE.MISSILE.M2.CLOSE RANGE"]],E[14]=[A["SPACE.MISSILE.M2.DEBRIS"]],E[15]=[A["SPACE.MISSILE.M2.UNKNOWN"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var u={type:"number",icons:function(I,t,E,R,e,A,C){"10"==e&&(I[11e4]=[A["GR.IC.COMMAND AND CONTROL"]],I[110100]=[A["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],I[110200]=[A["GR.IC.CIVIL AFFAIRS"]],I[110300]=[A["GR.IC.CIVIL-MILITARY-COOPERATION"]],I[110400]=[A["GR.IC.INFORMATION OPERATIONS"]],I[110500]=[A["GR.IC.LIAISON"]],I[110501]=[A["GR.IC.LIAISON"],A["GR.IC.FF.RECONNAISSANCE"]],I[110600]=[A["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"]],I[110601]=[A["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"],A["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],I[110700]=[A["GR.IC.RADIO"]],I[110800]=[A["GR.IC.RADIO RELAY"]],I[110900]=[A["GR.IC.RADIO TELETYPE CENTRE"]],I[111e3]=[A["GR.IC.FF.SIGNAL"]],I[111001]=[A["GR.IC.FF.SIGNAL"],A["GR.IC.RADIO"]],I[111002]=[A["GR.IC.FF.SIGNAL"],A["GR.IC.RADIO RELAY"]],I[111003]=[A["GR.IC.FF.SIGNAL"],A["GR.IC.RADIO TELETYPE CENTRE"]],I[111004]=[A["GR.IC.FF.SIGNAL"],A["GR.I.FF.SATELLITE"]],I[111005]=[A["GR.IC.FF.SIGNAL"],A["GR.IC.VIDEO IMAGERY"]],I[111100]=[A["GR.I.FF.SATELLITE"]],I[111200]=[A["GR.IC.VIDEO IMAGERY"]],I[111300]=[A["GR.IC.SPACE"]],I[111400]=[A["GR.IC.SPECIAL TROOPS"]],I[12e4]=[],I[120100]=[A["GR.IC.FF.AIR ASSAULT WITH ORGANIC LIFT"]],I[120200]=[A["GR.IC.AIR TRAFFIC SERVICES"]],I[120300]=[A["GR.IC.FF.AMPHIBIOUS"]],I[120400]=[A["GR.IC.FF.ANTITANK/ANTIARMOUR"]],I[120401]=[A["GR.IC.FF.ANTITANK/ANTIARMOUR"],A["GR.IC.ARMOUR"]],I[120402]=[A["GR.IC.FF.ANTITANK/ANTIARMOUR"],A["GR.IC.FF.MOTORIZED"]],I[120500]=[A["GR.IC.ARMOUR"]],I[120501]=[A["GR.IC.ARMOUR"],A["GR.IC.FF.RECONNAISSANCE"]],I[120502]=[A["GR.IC.ARMOUR"],A["GR.IC.FF.AMPHIBIOUS"]],I[120600]=[A["GR.IC.AVIATION ROTARY WING"]],I[120601]=[A["GR.IC.AVIATION ROTARY WING"],A["GR.IC.FF.RECONNAISSANCE"]],I[120700]=[A["GR.IC.AVIATION COMPOSITE"]],I[120800]=[A["GR.IC.AVIATION FIXED WING"]],I[120801]=[A["GR.IC.AVIATION FIXED WING"],A["GR.IC.FF.RECONNAISSANCE"]],I[120900]=[A["GR.IC.COMBAT"]],I[121e3]=[A["GR.IC.COMBINED ARMS"]],I[121100]=[A["GR.IC.FF.INFANTRY"]],I[121101]=[A["GR.IC.FF.INFANTRY"],A["GR.IC.FF.AMPHIBIOUS"]],I[121102]=[A["GR.IC.FF.INFANTRY"],A["GR.IC.ARMOUR"]],I[121103]=[A["GR.IC.FF.INFANTRY"],A["GR.IC.FF.MAIN GUN SYSTEM"]],I[121104]=[A["GR.IC.FF.INFANTRY"],A["GR.IC.FF.MOTORIZED"]],I[121105]=[A["GR.IC.FF.INFANTRY"],A["GR.IC.ARMOUR"],A["GR.IC.FF.MAIN GUN SYSTEM"]],I[121106]=[A["GR.IC.FF.MAIN GUN SYSTEM"]],I[121200]=[A["GR.IC.OBSERVER/OBSERVATION"]],I[121300]=[A["GR.IC.FF.RECONNAISSANCE"]],I[121301]=[A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.SURVEILLANCE"]],I[121302]=[A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.FF.AMPHIBIOUS"]],I[121303]=[A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.FF.MOTORIZED"]],I[121400]=[A["GR.IC.SEA-AIR-LAND"]],I[121500]=[A["GR.IC.SNIPER"]],I[121600]=[A["GR.IC.SURVEILLANCE"]],I[121700]=[A["GR.IC.SPECIAL FORCES"]],I[121800]=[A["GR.IC.SPECIAL OPERATIONS FORCES"]],I[121801]=[A["GR.IC.FIXED WING MISO"]],I[121802]=[A["GR.IC.SPECIAL OPERATIONS FORCES"],A["GR.IC.FF.INFANTRY"]],I[121803]=[A["GR.IC.COMBATANT"],A["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],I[121804]=[A["GR.IC.SUBMARINE NUCLEAR PROPULSION"],A["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],I[121805]=[A["SOF.IC.UNDERWATER DEMOLITION TEAM"]],I[121900]=[A["GR.IC.UNMANNED SYSTEMS"]],I[122e3]=[A["GR.IC.RANGER"]],I[13e4]=[],I[130100]=[A["GR.IC.FF.AIR DEFENCE"]],I[130101]=[A["GR.IC.FF.AIR DEFENCE"],A["GR.IC.FF.MAIN GUN SYSTEM"]],I[130102]=[A["GR.IC.FF.AIR DEFENCE"],A["GR.IC.AIR DEFENSE MISSILE"]],I[130103]=[A["GR.IC.FF.AIR DEFENCE"],A["GR.IC.AIR AND MISSILE DEFENSE"]],I[130200]=[A["GR.IC.FIELD ARTILLERY"],A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.AVIATION ROTARY WING"],A["GR.M1.NAVAL"]],I[130300]=[A["GR.IC.FIELD ARTILLERY"]],I[130301]=[s._scale(.8,A["GR.IC.FIELD ARTILLERY"]),A["GR.IC.ARMOUR"]],I[130302]=[s._scale(.8,A["GR.IC.FIELD ARTILLERY"]),A["GR.IC.ARMOUR"],A["GR.IC.FF.RECONNAISSANCE"]],I[130303]=[s._scale(.8,A["GR.IC.FIELD ARTILLERY"]),A["GR.IC.FF.RECONNAISSANCE"]],I[130400]=[A["GR.IC.FIELD ARTILLERY OBSERVER"]],I[130500]=[A["GR.IC.JOINT FIRE SUPPORT"]],I[130600]=[A["GR.IC.METEOROLOGICAL"]],I[130700]=[A["GR.IC.MISSILE"]],I[130800]=[A["GR.IC.MORTAR"]],I[130801]=[A["GR.IC.MORTAR"],A["GR.M2.TRACKED"]],I[130802]=[A["GR.IC.MORTAR"],A["GR.M2.TRUCK"]],I[130803]=[A["GR.IC.MORTAR"],A["GR.M2.TOWED"]],I[130900]=[A["GR.IC.SURVEY"]],I[14e4]=[],I[140100]=[A["GR.IC.CBRN"]],I[140101]=[A["GR.IC.CBRN"],A["GR.IC.ARMOUR"]],I[140102]=[A["GR.IC.CBRN"],A["GR.IC.FF.MOTORIZED"]],I[140103]=[A["GR.IC.CBRN"],A["GR.IC.FF.RECONNAISSANCE"]],I[140104]=[A["GR.IC.CBRN"],A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.ARMOUR"]],I[140105]=[A["GR.IC.CBRN"],A["GR.IC.FF.RECONNAISSANCE"],A["GR.IC.FF.MOTORIZED"]],I[140106]=[A["GR.IC.CBRN"],A["GR.CHEMICAL, BIOLOGICAL, RADIOLOGICAL, NUCLEAR, AND HIGH-YIELD EXPLOSIVES"]],I[140200]=[A["GR.IC.COMBAT SUPPORT (MANOEUVRE ENHANCEMENT)"]],I[140300]=[A["GR.IC.CRIMINAL INVESTIGATION DIVISION"]],I[140400]=[A["GR.IC.DIVER, CIVILIAN"]],I[140500]=[A["GR.IC.DOG"]],I[140600]=[A["GR.IC.DRILLING"]],I[140700]=[A["GR.IC.ENGINEER"]],I[140701]=[A["GR.IC.ENGINEER MECHANIZED"]],I[140702]=[A["GR.IC.ENGINEER"],A["GR.IC.FF.MOTORIZED"]],I[140703]=[A["GR.IC.ENGINEER"],A["GR.IC.FF.RECONNAISSANCE"]],I[140800]=[A["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],I[140900]=[A["GR.IC.FIELD CAMP CONSTRUCTION"]],I[141e3]=[A["GR.IC.FIRE PROTECTION"]],I[141100]=[A["GR.IC.GEOSPATIAL SUPPORT"]],I[141200]=[A["GR.IC.MILITARY POLICE"]],I[141300]=[A["GR.IC.MINE"]],I[141400]=[A["GR.IC.MINE CLEARING"]],I[141500]=[A["GR.IC.MINE LAUNCHING"]],I[141600]=[A["GR.IC.MINE LAYING"]],I[141700]=[A["GR.IC.SECURITY"]],I[141701]=[A["GR.IC.SECURITY"],A["GR.IC.ARMOUR"]],I[141702]=[A["GR.IC.SECURITY"],A["GR.IC.FF.MOTORIZED"]],I[141800]=[A["GR.IC.SEARCH AND RESCUE"]],I[141900]=[A["GR.IC.SECURITY POLICE (AIR)"]],I[142e3]=[A["GR.IC.SHORE PATROL"]],I[142100]=[A["GR.IC.TOPOGRAPHIC"]],I[142200]=[A["GR.IC.AIR AND MISSILE DEFENSE"]],I[15e4]=[],I[150100]=[A["GR.IC.FF.ANALYSIS"]],I[150200]=[A["GR.IC.COUNTER-INTELLIGENCE"]],I[150300]=[A["GR.IC.FF.DIRECTION FINDING"]],I[150400]=[A["GR.IC.ELECTRONIC RANGING"]],I[150500]=[A["GR.IC.ELECTRONIC WARFARE"]],I[150501]=[A["GR.IC.ELECTRONIC WARFARE"],A["GR.IC.FF.ANALYSIS"]],I[150502]=[A["GR.IC.ELECTRONIC WARFARE"],A["GR.IC.FF.DIRECTION FINDING"]],I[150503]=[A["GR.IC.ELECTRONIC WARFARE"],A["GR.IC.FF.INTERCEPT"]],I[150504]=[A["GR.IC.ELECTRONIC WARFARE"],A["GR.IC.FF.JAMMING"]],I[150505]=[A["GR.IC.ELECTRONIC WARFARE"],A["GR.IC.FF.SEARCH"]],I[150600]=[A["GR.IC.FF.INTERCEPT"]],I[150700]=[A["GR.IC.INTERROGATION"]],I[150800]=[A["GR.IC.FF.JAMMING"]],I[150900]=[A["GR.IC.JOINT INTELLIGENCE CENTRE"]],I[151e3]=[A["GR.IC.MILITARY INTELLIGENCE"]],I[151100]=[A["GR.IC.FF.SEARCH"]],I[151200]=[A["GR.IC.SENSOR"]],I[151300]=[A["GR.IC.MILITARY HISTORY"]],I[16e4]=[A["GR.IC.SUSTAINMENT"]],I[160100]=[A["GR.IC.ADMINISTRATIVE"]],I[160200]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS ALL"]],I[160300]=[A["GR.IC.TRANSPORTATION"],A["GR.IC.AIRPORT OF DEBARKATION"]],I[160400]=[A["GR.IC.AMMUNITION"]],I[160500]=[A["GR.IC.BAND"]],I[160501]=[A["GR.IC.ARMY MUSIC"]],I[160600]=[A["GR.IC.COMBAT SERVICE SUPPORT"]],I[160700]=[A["GR.IC.FINANCE"]],I[160800]=[A["GR.IC.JUDGE ADVOCATE GENERAL"]],I[160900]=[A["GR.IC.LABOUR"]],I[161e3]=[A["GR.IC.LAUNDRY/BATH"]],I[161100]=[A["GR.IC.MAINTENANCE"]],I[161200]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.MATERIEL"]],I[161300]=[A["GR.IC.FF.MEDICAL"]],I[161400]=[A["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I[161500]=[A["GR.IC.MORALE, WELFARE, AND RECREATION"]],I[161600]=[A["GR.IC.MORTUARY AFFAIRS"]],I[161700]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS MULTIPLE"]],I[161800]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.NATO SUPPLY CLASS I"]],I[161900]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.NATO SUPPLY CLASS II"]],I[162e3]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS III"]],I[162100]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.NATO SUPPLY CLASS IV"]],I[162200]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS V"]],I[162300]=[A["GR.IC.ORDNANCE"]],I[162400]=[A["GR.IC.PERSONNEL SERVICES"]],I[162500]=[A["GR.IC.PETROLEUM OIL LUBRICANTS"]],I[162600]=[A["GR.IC.PIPELINE"]],I[162700]=[A["GR.IC.POSTAL"]],I[162800]=[A["GR.IC.PUBLIC AFFAIRS"]],I[162900]=[A["GR.IC.QUARTERMASTER"]],I[163e3]=[A["GR.IC.RAILHEAD"]],I[163100]=[A["GR.IC.RELIGIOUS SUPPORT"]],I[163200]=[A["GR.IC.REPLACEMENT HOLDING UNIT"]],I[163300]=[A["GR.IC.SEAPORT OF DEBARKATION"]],I[163400]=[A["GR.IC.FF.SUPPLY"]],I[163500]=[A["GR.IC.JOINT INFORMATION BUREAU"]],I[163600]=[A["GR.IC.TRANSPORTATION"]],I[163601]=[A["GR.IC.TRANSPORTATION"],A["GR.IC.FLOATING CRAFT"]],I[163700]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS I"]],I[163800]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS II"]],I[163900]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS III"]],I[164e3]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS IV"]],I[164100]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS V"]],I[164200]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS VI"]],I[164300]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS VII"]],I[164400]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS VIII"]],I[164500]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS IX"]],I[164600]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.CLASS X"]],I[164700]=[A["GR.IC.WATER"]],I[164800]=[A["GR.IC.WATER PURIFICATION"]],I[164900]=[A["GR.IC.PUBLIC AFFAIRS BROADCAST"]],I[165e3]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.FF.NATO SUPPLY CLASS ALL"]],I[165100]=[A["GR.IC.INTERPRETER/TRANSLATOR"]],I[165200]=[A["GR.IC.SUPPORT"]],I[165300]=[A["GR.IC.ARMY FIELD SUPPORT"]],I[165400]=[A["GR.IC.CONTRACTING SERVICES"]],I[165500]=[A["GR.IC.PARACHUTE RIGGER"]],I[17e4]=[],I[170100]=[A["GR.IC.NAVAL"]],I[18e4]=[],I[180100]=[A["GR.IC.ALLIED COMMAND EUROPE RAPID REACTION CORPS (ARRC)"]],I[180200]=[A["GR.IC.ALLIED COMMAND OPERATIONS"]],I[180300]=[A["GR.IC.INTERNATIONAL SECURITY ASSISTANCE FORCE (ISAF)"]],I[180400]=[A["GR.IC.MULTINATIONAL (MN)"]],I[19e4]=[A["GR.IC.FF.EMERGENCY OPERATION"]],I[2e5]=[A["GR.IC.FF.LAW ENFORCEMENT"]],I[200100]=[A["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],I[200200]=[A["GR.IC.FF.BORDER PATROL"]],I[200300]=[A["GR.IC.FF.CUSTOMS SERVICE"]],I[200400]=[A["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],I[200500]=[A["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],I[200600]=[A["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],I[200700]=[A["GR.IC.LAW ENFORCEMENT"]],I[200800]=[A["GR.IC.FF.PRISON"]],I[200900]=[A["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],I[201e3]=[A["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],I[201100]=[A["GR.IC.LAW ENFORCEMENT VESSEL"]],I[201200]=[A["GR.IC.FF.US MARSHALS SERVICE"]],I[201300]=[A["ST.IC.INTERNAL SECURITY FORCE"]],t["01"]=[C?A["GR.M1.TACTICAL SATELLITE COMMUNICATIONS"]:A["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["02"]=[A["GR.M1.AREA"]],t["03"]=[A["GR.M1.ATTACK"]],t["04"]=[A["GR.M1.BIOLOGICAL"]],t["05"]=[A["GR.M1.BORDER"]],t["06"]=[A["GR.M1.BRIDGING"]],t["07"]=[A["GR.M1.CHEMICAL"]],t["08"]=[A["GR.M1.CLOSE PROTECTION"]],t["09"]=[A["GR.M1.COMBAT"]],t[10]=[A["GR.M1.COMMAND AND CONTROL"]],t[11]=[A["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]],t[12]=[A["GR.M1.CONSTRUCTION"]],t[13]=[A["GR.M1.CROSS CULTURAL COMMUNICATION"]],t[14]=[A["GR.M1.CROWD AND RIOT CONTROL"]],t[15]=[A["GR.M1.DECONTAMINATION"]],t[16]=[A["GR.M1.DETENTION"]],t[17]=[A["GR.M1.DIRECT COMMUNICATIONS"]],t[18]=[A["GR.M1.DIVING"]],t[19]=[A["GR.M1.DIVISION"]],t[20]=[A["GR.M1.DOG"]],t[21]=[A["GR.M1.DRILLING"]],t[22]=[A["GR.M1.ELECTRO-OPTICAL"]],t[23]=[A["GR.M1.ENHANCED"]],t[24]=[A["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]],t[25]=[A["GR.M1.FIRE DIRECTION CENTRE"]],t[26]=[A["GR.M1.FORCE"]],t[27]=[A["GR.M1.FORWARD"]],t[28]=[A["GR.M1.GROUND STATION MODULE"]],t[29]=[A["GR.M1.LANDING SUPPORT"]],t[30]=[A["GR.M1.LARGE EXTENSION NODE"]],t[31]=[A["GR.M1.MAINTENANCE"]],t[32]=[A["GR.M1.METEOROLOGICAL"]],t[33]=[A["GR.M1.MINE COUNTERMEASURE"]],t[34]=[A["GR.M1.MISSILE"]],t[35]=[A["GR.M1.(MOBILE) ADVISOR AND SUPPORT"]],t[36]=[A["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]],t[37]=[A["GR.M1.MOBILITY SUPPORT"]],t[38]=[A["GR.M1.MOVEMENT CONTROL CENTRE"]],t[39]=[A["GR.M1.MULTINATIONAL"]],t[40]=[A["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]],t[41]=[A["GR.M1.MULTIPLE ROCKET LAUNCHER"]],t[42]=[A["GR.M1.NATO MEDICAL ROLE 1"]],t[43]=[A["GR.M1.NATO MEDICAL ROLE 2"]],t[44]=[A["GR.M1.NATO MEDICAL ROLE 3"]],t[45]=[A["GR.M1.NATO MEDICAL ROLE 4"]],t[46]=[A["GR.M1.NAVAL"]],t[47]=[C?A["GR.M1.UNMANNED AERIAL VEHICLE"]:A["GR.M1.NODE CENTRE"]],t[48]=[A["GR.M1.NUCLEAR"]],t[49]=[A["GR.M1.OPERATIONS"]],t[50]=[A["GR.M1.RADAR"]],t[51]=[A["GR.M1.RADIO FREQUENCY IDENTIFICATION (RFID) INTERROGATOR/ SENSOR"]],t[52]=[A["GR.M1.RADIOLOGICAL"]],t[53]=[A["GR.M1.SEARCH AND RESCUE"]],t[54]=[A["GR.M1.SECURITY"]],t[55]=[A["GR.M1.SENSOR"]],t[56]=[C?A["GR.M1.WEAPON"]:A["GR.M1.SENSOR CONTROL MODULE"]],t[57]=[A["GR.M1.SIGNALS INTELLIGENCE"]],t[58]=[C?A["GR.M1.ARMORED"]:A["GR.M1.SINGLE SHELTER SWITCH"]],t[59]=[A["GR.M1.SINGLE ROCKET LAUNCHER"]],t[60]=[A["GR.M1.SMOKE"]],t[61]=[A["GR.M1.SNIPER"]],t[62]=[A["GR.M1.SOUND RANGING"]],t[63]=[A["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],t[64]=[A["GR.M1.SPECIAL WEAPONS AND TACTICS"]],t[65]=[A["GR.M1.SURVEY"]],t[66]=[A["GR.M1.TACTICAL EXPLOITATION"]],t[67]=[A["GR.M1.TARGET ACQUISITION"]],t[68]=[A["GR.M1.TOPOGRAPHIC"]],t[69]=[A["GR.M1.UTILITY"]],t[70]=[A["GR.M1.VIDEO IMAGERY"]],t[71]=[C?A["GR.M1.MOBILITY ASSAULT"]:A["GR.M1.ACCIDENT"]],t[72]=[C?A["GR.M1.AMPHIBIOUS WARFARE SHIP "]:A["GR.M1.OTHER"]],t[73]=[C?A["GR.M1.LOAD HANDLING SYSTEM"]:A["GR.M1.CIVILIAN"]],t[74]=[C?A["GR.M1.PALLETIZED LOAD SYSTEM"]:A["GR.M1.ANTISUBMARINE WARFARE"]],t[75]=[A["GR.M1.MEDEVAC"]],t[76]=[A["GR.M1.CYBERSPACE"]],t[77]=[A["GR.M1.SUPPORT"]],t[78]=[A["GR.M1.AVIATION"]],t[79]=[A["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"]],t[80]=[A["GR.M1.TILT-ROTOR"]],t[81]=[A["GR.M1.COMMAND POST NODE"]],t[82]=[A["GR.M1.JOINT NETWORK NODE"]],t[83]=[A["GR.M1.RETRANSMISSION SITE"]],t[84]=[A["GR.M1.ASSAULT"]],t[85]=[A["GR.M1.WEAPONS"]],t[86]=[A["GR.M1.CRIMINAL INVESTIGATION DIVISION"]],t[87]=[A["GR.M1.DIGITAL"]],t[88]=[A["GR.M1.NETWORK OR NETWORK OPERATIONS"]],t[89]=[A["GR.M1.AIRFIELD, AERIAL PORT OF DEBARKATION, OR AERIAL PORT OF EMBARKATION"]],t[90]=[A["GR.M1.PIPELINE"]],t[91]=[A["GR.M1.POSTAL"]],t[92]=[A["GR.M1.WATER"]],t[93]=[A["GR.M1.INDEPENDENT COMMAND"]],t[94]=[A["GR.M1.THEATRE"]],t[95]=[A["GR.M1.ARMY"]],t[96]=[A["GR.M1.CORPS"]],t[97]=[A["GR.M1.BRIGADE"]],t[98]=[A["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],E["01"]=[A["GR.M2.AIRBORNE"]],E["02"]=[A["GR.M2.ARCTIC"]],E["03"]=[A["GR.M2.BATTLE DAMAGE REPAIR"]],E["04"]=[A["GR.M2.BICYCLE EQUIPPED"]],E["05"]=[A["GR.M2.CASUALTY STAGING"]],E["06"]=[A["GR.M2.CLEARING"]],E["07"]=[A["GR.M2.CLOSE RANGE"]],E["08"]=[A["GR.M2.CONTROL"]],E["09"]=[A["GR.M2.DECONTAMINATION"]],E[10]=[A["GR.M2.DEMOLITION"]],E[11]=[A["GR.M2.DENTAL"]],E[12]=[A["GR.M2.DIGITAL"]],E[13]=[A["GR.M2.ENHANCED POSITION LOCATION REPORTING SYSTEM"]],E[14]=[A["GR.M2.EQUIPMENT"]],E[15]=[A["GR.M2.HEAVY"]],E[16]=[A["GR.M2.HIGH ALTITUDE"]],E[17]=[A["GR.M2.INTERMODAL"]],E[18]=[A["GR.M2.INTENSIVE CARE"]],E[19]=[A["GR.M2.LIGHT"]],E[20]=[A["GR.M2.LABORATORY"]],E[21]=[A["GR.M2.LAUNCHER"]],E[22]=[A["GR.M2.LONG RANGE"]],E[23]=[A["GR.M2.LOW ALTITUDE"]],E[24]=[A["GR.M2.MEDIUM"]],E[25]=[A["GR.M2.MEDIUM ALTITUDE"]],E[26]=[A["GR.M2.MEDIUM RANGE"]],E[27]=[A["GR.M2.MOUNTAIN"]],E[28]=[A["GR.M2.HIGH TO MEDIUM ALTITUDE"]],E[29]=[A["GR.M2.MULTI-CHANNEL"]],E[30]=[A["GR.M2.OPTICAL"]],E[31]=[A["GR.M2.PACK ANIMAL"]],E[32]=[A["GR.M2.PATIENT EVACUATION COORDINATION"]],E[33]=[A["GR.M2.PREVENTIVE MAINTENANCE"]],E[34]=[A["GR.M2.PSYCHOLOGICAL"]],E[35]=[A["GR.M2.RADIO RELAY LINE OF SIGHT"]],E[36]=[A["GR.M2.RAILROAD"]],E[37]=[A["GR.M2.RECOVERY (UNMANNED SYSTEMS)"]],E[38]=[A["GR.M2.RECOVERY (MAINTENANCE)"]],E[39]=[A["GR.M2.RESCUE COORDINATION CENTRE"]],E[40]=[A["GR.M2.RIVERINE"]],E[41]=[A["GR.M2.SINGLE CHANNEL"]],E[42]=[A["GR.M2.SKI"]],E[43]=[A["GR.M2.SHORT RANGE"]],E[44]=[A["GR.M2.STRATEGIC"]],E[45]=[A["GR.M2.SUPPORT"]],E[46]=[A["GR.M2.TACTICAL"]],E[47]=[A["GR.M2.TOWED"]],E[48]=[A["GR.M2.TROOP"]],E[49]=[A["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]],E[50]=[A["GR.M2.VETERINARY"]],E[51]=[A["GR.M2.WHEELED"]],E[52]=[A["GR.M2.HIGH TO LOW ALTITUDE"]],E[53]=[A["GR.M2.MEDIUM TO LOW ALTITUDE"]],E[54]=[A["GR.M2.ATTACK"]],E[55]=[A["GR.M2.REFUEL"]],E[56]=[A["GR.M2.UTILITY"]],E[57]=[A["GR.M2.COMBAT SEARCH AND RESCUE"]],E[58]=[A["GR.M2.GUERILLA"]],E[59]=[A["GR.M2.AIR ASSAULT"]],E[60]=[A["GR.M2.AMPHIBIOUS"]],E[61]=[A["GR.M2.VERY HEAVY"]],E[62]=[A["GR.IC.FF.SUPPLY"]],E[63]=[A["GR.M2.CYBERSPACE"]],E[64]=[A["GR.M2.NAVY BARGE, SELF-PROPELLED"]],E[65]=[A["GR.M2.NAVY BARGE, NOT SELF-PROPELLED"]],E[66]=[A["GR.M2.LAUNCH"]],E[67]=[A["GR.M2.LANDING CRAFT"]],E[68]=[A["GR.M2.LANDING SHIP"]],E[69]=[A["GR.M2.SERVICE CRAFT/YARD"]],E[70]=[A["GR.M2.TUG HARBOR"]],E[71]=[A["GR.M2.OCEAN GOING TUG BOAT"]],E[72]=[A["GR.M2.SURFACE DEPLOYMENT AND DISTRIBUTION COMMAND"]],E[73]=[A["GR.M2.NONCOMBATANT GENERIC VESSEL"]],E[74]=[A["GR.M2.COMPOSITE"]],E[75]=[A["GR.M2.SHELTER"]],E[76]=[A["GR.M2.LIGHT AND MEDIUM"]],E[77]=[A["GR.M2.SELF-PROPELLED"]],E[78]=[A.TODO])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var v={type:"number",icons:function(I,t,E,R,e,A,C){"11"==e&&(I[11e4]=[A["GR.I.CIVILIAN"]],I[110100]=[A["GR.IC.ENVIRONMENTAL PROTECTION"]],I[110200]=[A["GR.IC.GOVERNMENT ORGANIZATION"]],I[110300]=[A["ST.IC.INDIVIDUAL"]],I[110400]=[A["ST.IC.GROUP"]],I[110500]=[A["ST.IC.KILLING VICTIM"]],I[110600]=[A["ST.IC.KILLING VICTIMS"]],I[110700]=[A["ST.IC.INDIVIDUAL"],A["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],I[110800]=[A["ST.IC.SPY"]],I[110900]=[A["ST.IC.COMPOSITE LOSS"]],I[111e3]=[A["GR.IC.EMERGENCY MEDICAL OPERATION"]],t["01"]=[A["ST.M1.ASSASSINATION"]],t["02"]=[A["ST.M1.EXECUTION (WRONGFUL KILLING)"]],t["03"]=[A["ST.M1.MURDER"]],t["04"]=[A["ST.M1.HIJACKING/HIJACKED"]],t["05"]=[A["ST.M1.KIDNAPPING"]],t["06"]=[A["ST.M1.PIRACY"]],t["07"]=[A["ST.M1.RAPE"]],t["08"]=[A["ST.M1.CIVILIAN"]],t["09"]=[A["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],t[10]=[A["ST.M1.FOREIGN FIGHTERS"]],t[11]=[A["ST.M1.GANG"]],t[12]=[A["ST.M1.GOVERNMENT ORGANIZATION"]],t[13]=[A["ST.M1.LEADER"]],t[14]=[A["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],t[15]=[A["ST.M1.COERCED/IMPRESSED"]],t[16]=[A["ST.M1.WILLING RECRUIT"]],t[17]=[A["ST.M1.RELIGIOUS"]],t[18]=[A["ST.M1.TARGETED"]],t[19]=[A["ST.M1.TERRORIST"]],t[20]=[A["ST.M1.SPEAKER"]],t[21]=[A["ST.M1.ACCIDENT"]],t[22]=[A["ST.M1.COMBAT"]],t[23]=[A["ST.M1.OTHER"]],t[24]=[A["ST.M1.LOOT"]],t[25]=[A["GR.M1.HIJACKER"]],t[26]=[A["GR.M1.CYBERSPACE"]],E["01"]=[A["ST.M2.LEADER OR LEADERSHIP"]],E["02"]=[A["GR.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var Q={type:"number",icons:function(I,t,E,R,e,A,C){if("15"==e){I[11e4]=[A["GR.EQ.WEAPON"]],I[110100]=[A["GR.EQ.RIFLE"]],I[110101]=[A["GR.EQ.RIFLE"],A["GR.EQ.SHORT RANGE"]],I[110102]=[A["GR.EQ.RIFLE"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110103]=[A["GR.EQ.RIFLE"],A["GR.EQ.LONG RANGE"]],I[110200]=[A["GR.EQ.MACHINE GUN"]],I[110201]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.SHORT RANGE"]],I[110202]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110203]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.LONG RANGE"]],I[110300]=[A["GR.EQ.GRENADE LAUNCHER"]],I[110301]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.SHORT RANGE"])],I[110302]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.INTERMEDIATE RANGE"])],I[110303]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.LONG RANGE"])],I[110400]=[A["GR.EQ.FLAME THROWER"]],I[110500]=[A["GR.EQ.AIR DEFENCE GUN"]],I[110501]=[A["GR.EQ.AIR DEFENCE GUN"],A["GR.EQ.SHORT RANGE"]],I[110502]=[A["GR.EQ.AIR DEFENCE GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110503]=[A["GR.EQ.AIR DEFENCE GUN"],A["GR.EQ.LONG RANGE"]],I[110600]=[A["GR.EQ.ANTITANK GUN"]],I[110601]=[A["GR.EQ.ANTITANK GUN"],A["GR.EQ.SHORT RANGE"]],I[110602]=[A["GR.EQ.ANTITANK GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110603]=[A["GR.EQ.ANTITANK GUN"],A["GR.EQ.LONG RANGE"]],I[110700]=[A["GR.EQ.DIRECT FIRE GUN"]],I[110701]=[A["GR.EQ.DIRECT FIRE GUN"],A["GR.EQ.SHORT RANGE"]],I[110702]=[A["GR.EQ.DIRECT FIRE GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110703]=[A["GR.EQ.DIRECT FIRE GUN"],A["GR.EQ.LONG RANGE"]],I[110800]=[A["GR.EQ.RECOILLESS GUN"]],I[110801]=[A["GR.EQ.RECOILLESS GUN"],A["GR.EQ.SHORT RANGE"]],I[110802]=[A["GR.EQ.RECOILLESS GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110803]=[A["GR.EQ.RECOILLESS GUN"],A["GR.EQ.LONG RANGE"]],I[110900]=[A["GR.EQ.HOWITZER"]],I[110901]=[A["GR.EQ.HOWITZER"],A["GR.EQ.SHORT RANGE"]],I[110902]=[A["GR.EQ.HOWITZER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110903]=[A["GR.EQ.HOWITZER"],A["GR.EQ.LONG RANGE"]],I[111e3]=[A["GR.EQ.MISSILE LAUNCHER"]],I[111001]=[A["GR.EQ.MISSILE LAUNCHER"],A["GR.EQ.SHORT RANGE"]],I[111002]=[A["GR.EQ.MISSILE LAUNCHER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111003]=[A["GR.EQ.MISSILE LAUNCHER"],A["GR.EQ.LONG RANGE"]],I[111100]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]],I[111101]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.SHORT RANGE"]],I[111102]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.SHORT RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I[111103]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.SHORT RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I[111104]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111105]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.INTERMEDIATE RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I[111106]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.INTERMEDIATE RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I[111107]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.LONG RANGE"]],I[111108]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.LONG RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],I[111109]=[A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],A["GR.EQ.LONG RANGE"],A["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],I[111200]=[A["GR.EQ.ANTITANK MISSILE LAUNCHER"]],I[111201]=[A["GR.EQ.ANTITANK MISSILE LAUNCHER"],A["GR.EQ.SHORT RANGE"]],I[111202]=[A["GR.EQ.ANTITANK MISSILE LAUNCHER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111203]=[A["GR.EQ.ANTITANK MISSILE LAUNCHER"],A["GR.EQ.LONG RANGE"]],I[111300]=[A["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]],I[111301]=[A["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],A["GR.EQ.SHORT RANGE"]],I[111302]=[A["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111303]=[A["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],A["GR.EQ.LONG RANGE"]],I[111400]=[A["GR.EQ.MORTAR"]],I[111401]=[A["GR.EQ.MORTAR"],A["GR.EQ.SHORT RANGE"]],I[111402]=[A["GR.EQ.MORTAR"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111403]=[A["GR.EQ.MORTAR"],A["GR.EQ.LONG RANGE"]],I[111500]=[A["GR.EQ.SINGLE ROCKET LAUNCHER"]],I[111501]=[A["GR.EQ.SINGLE ROCKET LAUNCHER"],A["GR.EQ.SHORT RANGE"]],I[111502]=[A["GR.EQ.SINGLE ROCKET LAUNCHER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111503]=[A["GR.EQ.SINGLE ROCKET LAUNCHER"],A["GR.EQ.LONG RANGE"]],I[111600]=[A["GR.EQ.MULTIPLE ROCKET LAUNCHER"]],I[111601]=[A["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,A["GR.EQ.SHORT RANGE"])],I[111602]=[A["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,A["GR.EQ.INTERMEDIATE RANGE"])],I[111603]=[A["GR.EQ.MULTIPLE ROCKET LAUNCHER"],s._translate(0,10,A["GR.EQ.LONG RANGE"])],I[111700]=[A["GR.EQ.ANTITANK ROCKET LAUNCHER"]],I[111701]=[A["GR.EQ.ANTITANK ROCKET LAUNCHER"],A["GR.EQ.SHORT RANGE"]],I[111702]=[A["GR.EQ.ANTITANK ROCKET LAUNCHER"],A["GR.EQ.INTERMEDIATE RANGE"]],I[111703]=[A["GR.EQ.ANTITANK ROCKET LAUNCHER"],A["GR.EQ.LONG RANGE"]],I[111800]=[A["GR.EQ.NON-LETHAL WEAPON"]],I[111900]=[A["GR.EQ.TASER"]],I[112e3]=[A["GR.EQ.WATER CANNON"]],I[12e4]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]],I[120100]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.ARMOURED VEHICLE"]],I[120101]=[A["GR.EQ.ARMOURED FIGHTING VEHICLE"]],I[120102]=[A["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]],I[120103]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER COMBAT SERVICE SUPPORT VEHICLE"]],I[120104]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],A["GR.EQ.MEDICAL EVACUATION"]],I[120105]=[A["GR.IC.ARMOUR"]],I[120106]=[A["GR.IC.ARMOUR"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[120107]=[A["GR.IC.ARMOUR"],A["GR.EQ.MEDICAL EVACUATION"]],I[120108]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[120109]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],A["GR.EQ.COMBAT SERVICE SUPPORT VEHICLE"]],I[120110]=[A["GR.EQ.ARMOURED FIGHTING VEHICLE"],A["GR.EQ.CROSS-COUNTRY"]],I[120111]=[A["GR.EQ.ARMOURED FIGHTING VEHICLE"],A["GR.EQ.CROSS-COUNTRY"],A["GR.IC.FF.RECONNAISSANCE EQUPIMENT"]],I[120200]=[A["GR.EQ.TANK"]],I[120201]=[A["GR.EQ.TANK"],A["GR.EQ.LIGHT TANK"]],I[120202]=[A["GR.EQ.TANK"],A["GR.EQ.MEDIUM TANK"]],I[120203]=[A["GR.EQ.TANK"],A["GR.EQ.HEAVY TANK"]],I[120300]=[A["GR.EQ.TANK"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[120301]=[A["GR.EQ.TANK"],A["GR.EQ.LIGHT TANK"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[120302]=[A["GR.EQ.TANK"],A["GR.EQ.MEDIUM TANK"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[120303]=[A["GR.EQ.TANK"],A["GR.EQ.HEAVY TANK"],A["GR.EQ.TANK RECOVERY VEHICLE"]],I[13e4]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],s._scale(.7,A["GR.IC.ENGINEER"])],I[130100]=[A["GR.IN.IC.BRIDGE"]],I[130200]=[A["GR.EQ.UTILITY VEHICLE"],s._scale(.8,A["GR.IN.IC.BRIDGE"])],I[130300]=[A["GR.IN.IC.BRIDGE"],A["GR.EQ.FIXED BRIDGE"]],I[130400]=[A["GR.IN.IC.BRIDGE"],A["GR.M2.RIVERINE"]],I[130500]=[A["GR.IN.IC.BRIDGE"],A["GR.EQ.FOLDING GIRDER BRIDGE"]],I[130600]=[A["GR.IN.IC.BRIDGE"],A["GR.EQ.HOLLOW DECK BRIDGE"]],I[130700]=[A["GR.IC.DRILLING"]],I[130701]=[s._scale(.7,A["GR.IC.DRILLING"]),A["GR.EQ.UTILITY VEHICLE"]],I[130800]=[A["GR.EQ.EARTHMOVER"]],I[130801]=[A["GR.EQ.MULTIFUNCTIONAL EARTHMOVER/DIGGER"]],I[130900]=[A["GR.EQ.MINE CLEARING EQUIPMENT"]],I[130901]=[A["GR.EQ.MINE CLEARING EQUIPMENT"],s._translate(0,-10,A["GR.EQ.LIMITED CROSS-COUNTRY"])],I[130902]=[A["GR.EQ.MINE CLEARING EQUIPMENT"],A["GR.EQ.TANK"]],I[130903]=[A["GR.EQ.ASSAULT BREACHER VEHICLE (ABV) WITH COMBAT DOZER BLADE"]],I[130904]=[A["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"],A["GR.IC.ENGINEER UTILITY VEHICLE"],A["GR.M2.MEDIUM"]],I[130905]=[A["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"],A["GR.IC.ENGINEER UTILITY VEHICLE"],A["GR.M2.HEAVY"]],I[131e3]=[A["GR.IC.MINE LAYING"]],I[131001]=[A["GR.EQ.UTILITY VEHICLE"],s._translate(0,10,s._scale(.7,A["GR.IC.MINE LAYING"]))],I[131002]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],A["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],I[131003]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.LIMITED CROSS-COUNTRY"],A["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],I[131100]=[A["GR.EQ.DOZER"]],I[131101]=[A["GR.EQ.DOZER ARMORED"]],I[131200]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],s._scale(.6,A["GR.IC.ENGINEER"])],I[131300]=[A["GR.EQ.ARMOURED PERSONNEL CARRIER"],s._scale(.6,A["GR.IC.ENGINEER"]),A["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]],I[131400]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.LIMITED CROSS-COUNTRY"],A["GR.EQ.UTILITY VEHICLE BACKHOE"]],I[131500]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.LIMITED CROSS-COUNTRY"],s._scale(.6,A["GR.IC.ENGINEER"])],I[131600]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.CROSS-COUNTRY"],A["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]],I[14e4]=[],I[140100]=[A["GR.EQ.UTILITY VEHICLE"]],I[140200]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.MEDICAL VEHICLE"]],I[140300]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.MEDICAL EVACUATION"]],I[140400]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.MOBILE EMERGENCY PHYSICIAN"]],I[140500]=[A["GR.EQ.BUS"]],I[140600]=[A["GR.EQ.SEMI-TRAILER TRUCK"]],I[140601]=[A["GR.EQ.SEMI-TRAILER TRUCK"],A["GR.EQ.UTILITY VEHICLE LIGHT"]],I[140602]=[A["GR.EQ.SEMI-TRAILER TRUCK"],A["GR.EQ.UTILITY VEHICLE MEDIUM"]],I[140603]=[A["GR.EQ.SEMI-TRAILER TRUCK"],A["GR.EQ.UTILITY VEHICLE HEAVY"]],I[140700]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.LIMITED CROSS-COUNTRY"]],I[140800]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.CROSS-COUNTRY"]],I[140900]=[A["GR.EQ.UTILITY VEHICLE"],s._scale(.8,A["GR.IC.FF.CLASS III"])],I[141e3]=[A["GR.EQ.UTILITY VEHICLE"],s._scale(.7,A["GR.IC.WATER"])],I[141100]=[A["GR.EQ.WATER VEHICLE"],A["GR.EQ.LIMITED CROSS-COUNTRY"]],I[141200]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]],I[141201]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],A["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]],I[141202]=[A["GR.EQ.UTILITY VEHICLE"],A["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],A["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]],I[15e4]=[],I[150100]=[A["GR.EQ.TRAIN LOCOMOTIVE"]],I[150200]=[A["GR.EQ.RAILCAR"]],I[16e4]=[],I[160100]=[A["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]],I[160101]=[A["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I[160102]=[A["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I[160103]=[A["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I[160200]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]],I[160201]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I[160202]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I[160203]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I[160300]=[A["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],I[160301]=[A["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I[160302]=[A["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I[160303]=[A["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I[160400]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]],I[160401]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I[160402]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I[160403]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I[160500]=[A["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]],I[160501]=[A["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],I[160502]=[A["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],I[160503]=[A["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],I[160600]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160601]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160602]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160603]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160700]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160701]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.LIGHT"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160702]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160703]=[A["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],A["GR.EQ.CIVILIAN VEHICLE.HEAVY"],A["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],I[160800]=[A["ST.IC.KNOWN INSURGENT VEHICLE"]],I[160900]=[A["ST.IC.KNOWN INSURGENT VEHICLE"],A["ST.M1.DRUG"]],I[17e4]=[A["GR.IC.FF.LAW ENFORCEMENT"]],I[170100]=[A["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],I[170200]=[A["GR.IC.FF.BORDER PATROL"]],I[170300]=[A["GR.IC.FF.CUSTOMS SERVICE"]],I[170400]=[A["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],I[170500]=[A["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],I[170600]=[A["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],I[170700]=[A["GR.IC.MILITARY POLICE"]],I[170800]=[A["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],I[170900]=[A["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],I[171e3]=[A["GR.IC.LAW ENFORCEMENT VESSEL"]],I[171100]=[A["GR.IC.FF.US MARSHALS SERVICE"]],I[18e4]=[A["GR.EQ.PACK ANIMAL"]],I[19e4]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE SUPPORT"]],I[190100]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE TRANSLOADER"]],I[190200]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE TRANSPORTER"]],I[190300]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE CRANE/LOADING DEVICE"]],I[190400]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]],I[190500]=[A["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],A["GR.EQ.MISSILE WARHEAD TRANSPORTER"]],I[2e5]=[],I[200100]=[A["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],I[200200]=[A["ST.IC.BOMB"]],I[200300]=[A["ST.IC.BOOBY TRAP"]],I[200400]=[A["GR.EQ.CBRN EQUIPMENT"]],I[200500]=[A["GR.EQ.COMPUTER SYSTEM"]],I[200600]=[A["GR.EQ.COMMAND LAUNCH EQUIPMENT (CLE)"]],I[200700]=[A["GR.EQ.GENERATOR SET"]],I[200800]=[A["GR.EQ.GROUND-BASED MIDCOURSE DEFENSE (GMD) FIRE CONTROL (GFC) CENTER"]],I[200900]=[A["GR.EQ.IN-FLIGHT INTERCEPTOR COMMUNICATIONS SYSTEM (IFICS) DATA TERMINAL (IDT)"]],I[201e3]=[A["GR.EQ.LASER"]],I[201100]=[A["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]],I[201200]=[A["GR.IC.SUSTAINMENT"]],I[201300]=[A["GR.EQ.TENT"]],I[201301]=[A["GR.EQ.TENT CIVILIAN"]],I[201302]=[A["GR.EQ.TENT MILITARY"]],I[201400]=[A["GR.EQ.UNIT DEPLOYMENT SHIPMENTS"]],I[201500]=[A["GR.IC.EMERGENCY MEDICAL OPERATION"]],I[201501]=[A["GR.IC.MEDICAL EVACUATION HELICOPTER"]],I[21e4]=[],I[210100]=[A["GR.EQ.LAND MINE"]],I[210200]=[A["GR.EQ.ANTIPERSONNEL LAND MINE"]],I[210300]=[A["GR.EQ.ANTITANK MINE"]],I[210400]=[A["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]],I[210500]=[A["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]],I[22e4]=[],I[220100]=[A["GR.EQ.SENSOR"]],I[220200]=[A["GR.EQ.SENSOR EMPLACED"]],I[220300]=[A["GR.EQ.RADAR"]],I[23e4]=[A["GR.IC.FF.EMERGENCY OPERATION"]],I[230100]=[A["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],A["GR.M1.MEDEVAC"]],I[230200]=[A["GR.IC.FIRE PROTECTION"]],I[24e4]=[A["GR.IC.MANUAL TRACK"]],I[25e4]=[A["GR.IC.AVIATION ROTARY WING"]],t["01"]=[A["GR.M1.BIOLOGICAL"]],t["02"]=[A["GR.M1.CHEMICAL"]],t["03"]=[A["GR.M1.EARLY WARNING RADAR"]],t["04"]=[A["GR.M1.INTRUSION"]],t["05"]=[A["GR.M1.NUCLEAR"]],t["06"]=[A["GR.M1.RADIOLOGICAL"]],t["07"]=[A["GR.M1.UPGRADED EARLY WARNING RADAR"]],t["08"]=[A["GR.M1.HIJACKING"]],t["09"]=[A["GR.M1.CIVILIAN"]],t[10]=[A["GR.M1.TILT-ROTOR"]],t[11]=[],t[12]=[A["GR.M1.MULTI-PURPOSE BLADE"]],t[13]=[A["GR.M1.TANK-WIDTH MINE PLOW"]],t[14]=[A["GR.M1.BRIDGING"]],t[15]=[A["GR.M1.CYBERSPACE"]],t[16]=[A["GR.M1.ARMORED"]],t[17]=[A["GR.M1.ATTACK"]],t[18]=[A["GR.M1.CARGO"]],t[19]=[A["GR.M1.MAINTENANCE"]],t[20]=[A["GR.M1.MEDEVAC"]],t[21]=[A["GR.IN.M1.PETROLEUM"]],t[22]=[A["GR.M1.UTILITY"]],t[23]=[A["GR.M1.WATER"]],E["01"]=[A["GR.M2.CYBERSPACE"]],E["02"]=[A["GR.M2.LIGHT"]],E["03"]=[A["GR.M2.MEDIUM"]],E["04"]=[A["GR.M2.RAILROAD"]],E["05"]=[A["GR.M2.TRACKED"]],E["06"]=[A["GR.M2.TRACTOR TRAILER"]],E["07"]=[A["GR.M2.WHEELED LIMITED"]],E["08"]=[A["GR.M2.WHEELED"]];var T={110000:140,110100:140,110101:140,110102:140,110103:140,110200:140,110201:140,110202:140,110203:140,110300:140,110301:140,110302:140,110303:140,110400:135,110500:140,110501:140,110502:140,110503:140,110600:140,110601:140,110602:140,110603:140,110700:140,110701:140,110702:140,110703:140,110800:140,110801:140,110802:140,110803:140,110900:140,110901:140,110902:140,110903:140,111000:140,111001:140,111002:140,111003:140,111100:140,111101:140,111102:140,111103:140,111104:140,111105:140,111106:140,111107:140,111108:140,111109:140,111200:140,111201:140,111202:140,111203:140,111300:140,111301:140,111302:140,111303:140,111400:140,111401:140,111402:140,111403:140,111500:140,111501:140,111502:140,111503:140,111600:140,111601:140,111602:140,111603:140,111701:140,111702:140,111703:140,111800:140,111900:140,112000:140,120000:129,120100:129,120101:130,120102:130,120103:130,120104:130,120105:120,120106:120,120107:120,120108:130,120109:130,120110:140,120200:130,120201:130,120202:130,120203:130,120300:130,120301:130,120302:130,120303:130,130000:129,130100:115,130200:130,130300:130,130400:135,130500:120,130600:120,130700:120,130701:130,130800:130,130801:130,130900:120,130901:130,130902:130,131000:115,131001:130,131002:130,131003:140,131100:130,131101:130,131200:130,131300:130,131400:140,131500:140,131600:140,140100:130,140200:130,140300:130,140400:130,140500:130,140600:140,140601:140,140602:140,140603:140,140700:140,140800:140,140900:130,141000:130,141100:140,141200:130,141201:130,141202:130,150100:130,150200:140,160100:132.5,160101:132.5,160102:132.5,160103:132.5,160200:132.5,160201:132.5,160202:132.5,160203:132.5,160300:132.5,160301:132.5,160302:132.5,160303:132.5,160400:132.5,160401:132.5,160402:132.5,160403:132.5,160500:132.5,160501:132.5,160502:132.5,160503:132.5,160600:132.5,160601:132.5,160602:132.5,160603:132.5,160700:132.5,160701:132.5,160702:132.5,160703:132.5,160800:115,160900:115,170000:149.03125,170100:118.75,170200:133.21875,170300:135.21875,170400:118.75,170500:138.1875,170600:118.75,170700:118.75,170800:118,170900:118,171000:135,171100:135,180000:125,190000:129,190100:129,190200:129,190300:129,190400:129,190500:129,200100:140,200200:118.75,200300:120,200400:140,200500:132,200600:118.75,200700:118.75,200800:118.75,200900:119.36222839355469,201000:145,201100:120,201200:118,201300:124.36222076416016,201301:120,201302:120,201400:118.75,201500:140,201501:115,210100:122,210200:122,210300:122,210400:118.75,210500:122,220100:140,220200:136,220300:120,230000:135,230100:132.5,230200:120,240000:118.75};for(var S in T)T.hasOwnProperty(S)&&(R[S]={x1:50,x2:150,y1:50,y2:T[S]})}}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var g={type:"number",icons:function(I,t,E,R,e,A,C){"20"==e&&(I[11e4]=[A["GR.IC.MILITARY"]],I[110100]=[A["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]],I[110200]=[s._scale(1.4,A["GR.IC.FF.CLASS V"])],I[110300]=[A["GR.IC.FF.CLASS V"],A["GR.IC.FF.SUPPLY"]],I[110400]=[A["GR.EQ.TANK"]],I[110500]=[A["ST.IC.BLACK LIST LOCATION"]],I[110600]=[A["GR.IC.CBRN"]],I[110700]=[A["GR.EQ.DOZER"]],I[110701]=[A["GR.IN.IC.BRIDGE"]],I[110800]=[A["GR.IC.EQUIPMENT MANUFACTURE"]],I[110900]=[A["GR.I.GOVERNMENT"]],I[111e3]=[A["ST.IC.GRAY LIST LOCATION"]],I[111100]=[A["ST.IC.MASS GRAVE LOCATION"]],I[111200]=[A["GR.IN.IC.MILITARY/CIVILIAN.MATERIEL"],A["GR.IC.FF.SUPPLY"]],I[111300]=[A["GR.IN.IC.MINE"]],I[111400]=[A["GR.EQ.MISSILE LAUNCHER"]],I[111500]=[s._scale(.8,A["AC.IC.RADIOACTIVE MATERIAL"])],I[111600]=[A["GR.IN.IC.MILITARY/CIVILIAN.PRINTED MEDIA"]],I[111700]=[A["ST.IC.SAFE HOUSE"]],I[111800]=[A["ST.IC.WHITE LIST LOCATION"]],I[111900]=[A["GR.EQ.TENT"]],I[111901]=[A["GR.EQ.TENT"],A["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],I[111902]=[A["GR.EQ.TENT"],A["GR.M1.TRAINING CAMP"]],I[112e3]=[A["GR.IN.IC.INDUSTRIAL SITE"],A["GR.IN.IC.WAREHOUSE/STORAGE FACILITY"]],I[112100]=[A["GR.IC.FF.LAW ENFORCEMENT"]],I[112101]=[A["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],I[112102]=[A["GR.IC.FF.BORDER PATROL"]],I[112103]=[A["GR.IC.FF.CUSTOMS SERVICE"]],I[112104]=[A["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],I[112105]=[A["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],I[112106]=[A["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],I[112107]=[A["GR.IC.LAW ENFORCEMENT"]],I[112108]=[A["GR.IC.FF.PRISON"]],I[112109]=[A["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],I[112110]=[A["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],I[112111]=[A["GR.IC.LAW ENFORCEMENT VESSEL"]],I[112112]=[A["GR.IC.FF.US MARSHALS SERVICE"]],I[112200]=[A["GR.IC.FF.EMERGENCY OPERATION"]],I[112201]=[A["GR.IC.FIRE PROTECTION"]],I[112202]=[A["GR.IC.EMERGENCY MEDICAL OPERATION"]],I[12e4]=[],I[120100]=[A["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]],I[120101]=[A["GR.IN.IC.AGRICULTURAL LABORATORY"]],I[120102]=[A["GR.IN.IC.ANIMAL FEEDLOT"]],I[120103]=[A["ST.IC.FOOD DISTRIBUTION"],A["AC.M1.COMMERCIAL"]],I[120104]=[A["GR.IN.IC.FARM/RANCH"]],I[120105]=[A["ST.IC.FOOD DISTRIBUTION"]],I[120106]=[A["ST.IC.FOOD DISTRIBUTION"],A["AC.M1.PRODUCTION"]],I[120107]=[A["ST.IC.FOOD DISTRIBUTION"],A["AC.M1.RETAIL"]],I[120108]=[A["GR.IN.IC.GRAIN STORAGE"]],I[120200]=[A["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]],I[120201]=[A["GR.IN.IC.ATM"]],I[120202]=[A["GR.IN.IC.BANK"]],I[120203]=[A["GR.IN.IC.BULLION STORAGE"]],I[120204]=[A["GR.IN.IC.INFRASTRUCTURE.BANKING FINANCE AND INSURANCE  INFRASTRUCTURE.ECONOMIC INFRASTRUCTURE ASSET"]],I[120205]=[A["GR.IN.IC.FEDERAL RESERVE BANK"]],I[120206]=[A["GR.IN.IC.FINANCIAL EXCHANGE"]],I[120207]=[A["GR.IN.IC.FINANCIAL SERVICES, OTHER"]],I[120300]=[A["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]],I[120301]=[A["GR.IN.IC.CHEMICAL PLANT"]],I[120302]=[A["GR.IN.IC.FIREARMS MANUFACTURER"]],I[120303]=[A["GR.IN.IC.FIREARMS RETAILER"]],I[120304]=[A["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]],I[120305]=[A["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]],I[120306]=[A["GR.IN.IC.INDUSTRIAL SITE"]],I[120307]=[A["GR.IN.IC.LANDFILL"]],I[120308]=[A["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]],I[120309]=[A["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]],I[120310]=[A["GR.IN.IC.TOXIC RELEASE INVENTORY"]],I[120400]=[A["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]],I[120401]=[A["GR.IN.IC.COLLEGE/UNIVERSITY"]],I[120402]=[A["GR.IN.IC.SCHOOL"]],I[120500]=[A["GR.IN.IC.ELECTRIC POWER"]],I[120501]=[s._scale(.6,A["GR.IN.IC.ELECTRIC POWER"])],I[120502]=[s._translate(0,15,s._scale(.75,A["GR.IN.IC.ELECTRIC POWER"])),A["AC.M1.GENERATION STATION"]],I[120503]=[A["GR.IN.IC.NATURAL GAS FACILITY"]],I[120504]=[s._scale(1.5,A["GR.IC.FF.CLASS III"])],I[120505]=[A["GR.IC.FF.CLASS III"]],I[120506]=[A["GR.IN.IC.PROPANE FACILITY"]],I[120600]=[A["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]],I[120700]=[],I[120701]=[A["GR.IC.FF.MEDICAL"]],I[120702]=[A["GR.IC.FF.MEDICAL"],A["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],I[120800]=[A["GR.IN.IC.MILITARY INFRASTRUCTURE"]],I[120801]=[A["GR.IN.IC.BASE"],A["AC.M1.MILITARY ARMORY"]],I[120802]=[A["GR.IN.IC.BASE"]],I[120900]=[A["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]],I[120901]=[A["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]],I[120902]=[A["GR.IN.IC.POST OFFICE"]],I[121e3]=[A["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]],I[121001]=[A["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]],I[121002]=[A["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]],I[121003]=[A["GR.IN.IC.RECREATIONAL AREA"]],I[121004]=[A["GR.IN.IC.RELIGIOUS INSTITUTION"]],I[121100]=[A["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]],I[121101]=[A["GR.IN.IC.ADULT DAY CARE"]],I[121102]=[A["GR.IN.IC.CHILD DAY CARE"]],I[121103]=[A["GR.IN.IC.ELDER CARE"]],I[121200]=[A["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]],I[121201]=[A["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],I[121202]=[A["GR.IN.IC.INFRASTRUCTURE.TELECOMMUNICATIONS INFRASTRUCTURE.TELECOMMUNICATIONS"]],I[121203]=[A["GR.IN.IC.TELECOMMUNICATIONS TOWER"]],I[121300]=[s._scale(1.5,A["GR.IC.TRANSPORTATION"])],I[121301]=[A["GR.IC.TRANSPORTATION"],A["GR.IC.AIRPORT OF DEBARKATION"]],I[121302]=[A["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]],I[121303]=[A["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],I[121304]=[A["GR.IC.FERRY"]],I[121305]=[A["GR.IN.IC.HELICOPTER LANDING SITE"]],I[121306]=[A["GR.IC.MAINTENANCE"]],I[121307]=[A["GR.IC.RAILHEAD"]],I[121308]=[A["GR.IN.IC.REST STOP"]],I[121309]=[A["GR.IC.TRANSPORTATION"],A["GR.M1.NAVAL"]],I[121310]=[A["GR.IC.NAVAL"],A["GR.M1.YARD"]],I[121311]=[A["GR.IN.IC.TOLL FACILITY"]],I[121312]=[A["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]],I[121313]=[A["GR.IN.IC.TUNNEL"]],I[121400]=[A["GR.IC.WATER"]],I[121401]=[A["GR.IN.IC.CONTROL VALVE"]],I[121402]=[A["GR.IN.IC.DAM"]],I[121403]=[A["GR.IN.IC.DISCHARGE OUTFALL"]],I[121404]=[A["GR.IN.IC.GROUND WATER WELL"]],I[121405]=[A["GR.IN.IC.PUMPING STATION"]],I[121406]=[A["GR.IN.IC.RESERVOIR"]],I[121407]=[A["GR.IN.IC.STORAGE TOWER"]],I[121408]=[A["GR.IN.IC.SURFACE WATER INTAKE"]],I[121409]=[A["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]],I[121410]=[A["GR.IC.WATER"]],I[121411]=[A["GR.IC.WATER PURIFICATION"]],t["01"]=[A["GR.M1.BIOLOGICAL"]],t["02"]=[A["GR.M1.CHEMICAL"]],t["03"]=[A["GR.M1.NUCLEAR"]],t["04"]=[A["GR.IN.M1.RADIOLOGICAL"]],t["05"]=[A["GR.M1.DECONTAMINATION"]],t["06"]=[A["GR.IN.M1.COAL"]],t["07"]=[A["GR.IN.M1.GEOTHERMAL"]],t["08"]=[A["GR.IN.M1.HYDROELECTRIC"]],t["09"]=[A["GR.IN.M1.NATURAL GAS"]],t[10]=[A["GR.IN.M1.PETROLEUM"]],t[11]=[A["GR.IN.M1.CIVILIAN"]],t[12]=[A["GR.IN.M1.CIVILIAN TELEPHONE"]],t[13]=[A["GR.IN.M1.CIVILIAN TELEVISION"]],t[14]=[A["GR.M1.CYBERSPACE"]],t[15]=[A["GR.M1.JOINT NETWORK NODE"]],t[16]=[A["GR.M1.COMMAND POST NODE"]],E["01"]=[A["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]],E["02"]=[A["GR.IN.M2.CHEMICAL WARFARE PRODUCTION"]],E["03"]=[A["GR.IN.M2.NUCLEAR WARFARE PRODUCTION"]],E["04"]=[A["GR.IN.M2.RADIOLOGICAL WARFARE PRODUCTION"]],E["05"]=[A["GR.IN.M2.ATOMIC ENERGY REACTOR"]],E["06"]=[A["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],E["07"]=[A["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]],E["08"]=[A["GR.IN.M2.WEAPONS GRADE PRODUCTION"]],E["09"]=[A["GR.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(L);var b={type:"number",icons:function(I,t,E,R,e,A,C){"30"==e&&(I[11e4]=[A["SE.IC.MILITARY"]],I[12e4]=[A["SE.IC.COMBATANT"]],I[120100]=[A["SE.IC.CARRIER"]],I[120200]=[A["SE.IC.SURFACE COMBATANT, LINE"]],I[120201]=[A["SE.IC.BATTLESHIP"]],I[120202]=[A["SE.IC.CRUISER, GUIDED MISSILE"]],I[120203]=[A["SE.IC.DESTROYER"]],I[120204]=[A["SE.IC.FRIGATE"]],I[120205]=[A["SE.IC.CORVETTE"]],I[120206]=[A["SE.IC.LITTORAL COMBATANT SHIP"]],I[120300]=[A["SE.IC.AMPHIBIOUS WARFARE SHIP"]],I[120301]=[A["SE.IC.AMPHIBIOUS FORCE FLAGSHIP"]],I[120302]=[A["SE.IC.AMPHIBIOUS ASSAULT"]],I[120303]=[A["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]],I[120304]=[A["SE.IC.AMPHIBIOUS ASSAULT SHIP, MULTI-PURPOSE"]],I[120305]=[A["SE.IC.AMPHIBIOUS ASSAULT SHIP, HELICOPTER"]],I[120306]=[A["SE.IC.AMPHIBIOUS TRANSPORT, DOCK"]],I[120307]=[A["SE.IC.LANDING SHIP"]],I[120308]=[A["SE.IC.LANDING CRAFT"]],I[120400]=[A["SE.IC.MINE WARFARE VESSEL"]],I[120401]=[A["SE.IC.MINELAYER"]],I[120402]=[A["SE.IC.MINESWEEPER"]],I[120403]=[A["SE.IC.MINESWEEPER, DRONE"]],I[120404]=[A["SE.IC.MINEHUNTER"]],I[120405]=[A["SE.IC.MINE COUNTERMEASURES"]],I[120406]=[A["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]],I[120500]=[A["SE.IC.PATROL"]],I[120501]=[A["SE.IC.PATROL CRAFT"]],I[120502]=[A["SE.IC.PATROL GUN"]],I[120600]=[A["SE.IC.SEA SURFACE DECOY"]],I[120700]=[A["SE.IC.UNMANNED SURFACE WATER VEHICLE"]],I[120800]=[A["SE.IC.MILITARY SPEEDBOAT"]],I[120801]=[A["SE.IC.MILITARY SPEEDBOAT, RIGID-HULL INFLATABLE BOAT"]],I[120900]=[A["SE.IC.MILITARY JETSKI"]],I[121e3]=[A["SE.IC.NAVY TASK ORGANIZATION UNIT"]],I[121001]=[A["SE.IC.NAVY TASK ELEMENT"]],I[121002]=[A["SE.IC.NAVY TASK FORCE"]],I[121003]=[A["SE.IC.NAVY TASK GROUP"]],I[121004]=[A["SE.IC.NAVY TASK UNIT"]],I[121005]=[A["SE.IC.CONVOY"]],I[121100]=[A["SE.IC.RADAR"]],I[13e4]=[A["SE.IC.NONCOMBATANT"]],I[130100]=[A["SE.IC.AUXILIARY SHIP"]],I[130101]=[A["SE.IC.AMMUNITION SHIP"]],I[130102]=[A["SE.IC.STORES SHIP"]],I[130103]=[A["SE.IC.AUXILIARY FLAG OR COMMAND SHIP"]],I[130104]=[A["SE.IC.INTELLIGENCE COLLECTOR"]],I[130105]=[A["SE.IC.OCEAN RESEARCH SHIP"]],I[130106]=[A["SE.IC.SURVEY SHIP"]],I[130107]=[A["SE.IC.HOSPITAL SHIP2"]],I[130108]=[A["SE.IC.CARGO SHIP"]],I[130109]=[A["SE.IC.COMBAT SUPPORT SHIP, FAST"]],I[130110]=[A["SE.IC.OILER, REPLENISHMENT"]],I[130111]=[A["SE.IC.REPAIR SHIP"]],I[130112]=[A["SE.IC.SUBMARINE TENDER"]],I[130113]=[A["SE.IC.TUG, OCEAN GOING"]],I[130200]=[A["SE.IC.SERVICE CRAFT, YARD, GENERAL"]],I[130201]=[A["SE.IC.BARGE, NOT SELF-PROPELLED"]],I[130202]=[A["SE.IC.BARGE, SELF-PROPELLED"]],I[130203]=[A["SE.IC.TUG, HARBOUR"]],I[130204]=[A["SE.IC.LAUNCH"]],I[14e4]=[A["SE.IC.CIVILIAN"]],I[140100]=[A["SE.IC.MERCHANT SHIP, GENERAL"]],I[140101]=[A["SE.IC.CARGO, GENERAL"]],I[140102]=[A["SE.IC.CONTAINER SHIP"]],I[140103]=[A["SE.IC.DREDGE"]],I[140104]=[A["SE.IC.ROLL ON-ROLL OFF"]],I[140105]=[A["SE.IC.FERRY"]],I[140106]=[A["SE.IC.HEAVY LIFT"]],I[140107]=[A["SE.IC.HOVERCRAFT 2525D"]],I[140108]=[A["SE.IC.MERCHANT SHIP, LASH CARRIER (WITH BARGES)"]],I[140109]=[A["SE.IC.OILER/TANKER"]],I[140110]=[A["SE.IC.PASSENGER SHIP"]],I[140111]=[A["SE.IC.TUG, OCEAN GOING CIVILIAN"]],I[140112]=[A["SE.IC.TOW"]],I[140113]=[A["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]],I[140114]=[A["SE.IC.JUNK/DHOW"]],I[140115]=[A["SE.IC.BARGE, NOT SELF-PROPELLED"]],I[140116]=[A["SE.IC.HOSPITAL SHIP"]],I[140200]=[A["SE.IC.FISHING VESSEL"]],I[140201]=[A["SE.IC.DRIFTER"]],I[140202]=[A["SE.IC.TRAWLER"]],I[140203]=[A["SE.IC.FISHING VESSEL DREDGE"]],I[140300]=[A["SE.IC.LAW ENFORCEMENT VESSEL"]],I[140400]=[A["SE.IC.LEISURE CRAFT, SAILING BOAT"]],I[140500]=[A["SE.IC.LEISURE CRAFT, MOTORIZED"]],I[140501]=[A["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]],I[140502]=[A["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]],I[140600]=[A["SE.IC.LEISURE CRAFT, JETSKI"]],I[140700]=[A["SE.IC.UNMANNED SURFACE WATER VEHICLE (USV)"]],I[15e4]=[A["SE.IC.OWN SHIP"]],I[16e4]=[A["SE.IC.FUSED TRACK"]],I[17e4]=[A["SE.IC.MANUAL TRACK"]],t["01"]=[A["SE.M1.OWN SHIP"]],t["02"]=[A["SE.M1.ANTIAIR WARFARE"]],t["03"]=[A["SE.M1.ANTISUBMARINE WARFARE"]],t["04"]=[A["SE.M1.ESCORT"]],t["05"]=[A["SE.M1.ELECTRONIC WARFARE"]],t["06"]=[A["SE.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]],t["07"]=[A["SE.M1.MINE COUNTER MEASURES"]],t["08"]=[A["SE.M1.MISSILE DEFENSE"]],t["09"]=[A["SE.M1.MEDICAL"]],t[10]=[A["SE.M1.MINE WARFARE"]],t[11]=[A["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]],t[12]=[A["SE.M1.SPECIAL OPERATIONS FORCE"]],t[13]=[A["SE.M1.SURFACE WARFARE"]],t[14]=[A["SE.M1.BALLISTIC MISSILE"]],t[15]=[A["SE.M1.GUIDED MISSILE"]],t[16]=[A["SE.M1.OTHER GUIDED MISSILE"]],t[17]=[A["SE.M1.TORPEDO"]],t[18]=[A["SE.M1.DRONE-EQUIPPED"]],t[19]=[A["SE.M1.HELICOPTER-EQUIPPED"]],t[20]=[A["SE.M1.BALLISTIC MISSILE DEFENSE, SHOOTER"]],t[21]=[A["SE.M1.BALLISTIC MISSILE DEFENSE, LONG- RANGE SURVEILLANCE AND TRACK (LRS&T)"]],t[22]=[A["SE.M1.SEA-BASE X-BAND"]],t[23]=[A["SE.M1.HIJACKING/HIJACKED"]],t[24]=[A["SE.M1.HIJACKER"]],t[25]=[A["SE.M1.CYBERSPACE"]],E["01"]=[A["SE.M2.NUCLEAR POWERED"]],E["02"]=[A["SE.M2.HEAVY"]],E["03"]=[A["SE.M2.LIGHT"]],E["04"]=[A["SE.M2.MEDIUM"]],E["05"]=[A["SE.M2.DOCK"]],E["06"]=[A["SE.M2.LOGISTICS"]],E["07"]=[A["SE.M2.TANK"]],E["08"]=[A["SE.M2.VEHICLE"]],E["09"]=[A["SE.M2.FAST"]],E[10]=[A["SE.M2.AIR-CUSHIONED (USA ONLY)"]],E[11]=[A["SE.M2.AIR-CUSHIONED"]],E[12]=[A["SE.M2.HYDROFOIL"]],E[13]=[A["SE.M2.AUTONOMOUS CONTROL"]],E[14]=[A["SE.M2.REMOTELY PILOTED"]],E[15]=[A["SE.M2.EXPENDABLE"]],E[16]=[A["SE.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(y);var K={type:"number",icons:function(I,t,E,R,e,A,C){"35"==e&&(I[11e4]=[A["SU.IC.MILITARY"]],I[110100]=[A["SU.IC.SUBMARINE"]],I[110101]=[A["SU.IC.SUBMARINE, SURFACED"]],I[110102]=[A["SU.IC.SUBMARINE, SNORKELING"]],I[110103]=[A["SU.IC.SUBMARINE, BOTTOMED"]],I[110200]=[A["SU.IC.OTHER SUBMERSIBLE"]],I[110300]=[A["SU.IC.NON-SUBMARINE"]],I[110400]=[A["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],I[110500]=[A["SU.IC.DIVER, MILITARY"]],I[12e4]=[A["SU.IC.CIVILIAN"]],I[120100]=[A["SU.IC.SUBMERSIBLE, CIVILIAN"]],I[120200]=[A["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV), CIVILIAN"]],I[120300]=[A["SU.IC.DIVER, CIVILIAN"]],I[13e4]=[A["SU.IC.UNDERWATER WEAPON"]],I[130100]=[A["SU.IC.TORPEDO"]],I[130200]=[A["SU.IC.IMPROVISED EXPLOSIVE DEVICE (IED)"]],I[130300]=[A["SU.IC.UNDERWATER DECOY DSymbol"]],I[14e4]=[A["SU.IC.ECHO TRACKER CLASSIFIER (ETC)/POSSIBLE CONTACT (POSCON)"]],I[15e4]=[A["SU.IC.FUSED TRACK"]],I[16e4]=[A["SU.IC.MANUAL TRACK"]],I[2e5]=[A["SU.IC.SEABED INSTALLATION, MAN-MADE, MILITARY"]],I[21e4]=[A["SU.IC.SEABED INSTALLATION, MAN-MADE, NON-MILITARY"]],t["01"]=[A["SU.M1.ANTISUBMARINE WARFARE"]],t["02"]=[A["SU.M1.AUXILIARY"]],t["03"]=[A["SU.M1.COMMAND AND CONTROL"]],t["04"]=[A["SU.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]],t["05"]=[A["SU.M1.MINE COUNTERMEASURES"]],t["06"]=[A["SU.M1.MINE WARFARE"]],t["07"]=[A["SU.M1.SURFACE WARFARE"]],t["08"]=[A["SU.M1.ATTACK"]],t["09"]=[A["SU.M1.BALLISTIC MISSILE"]],t[10]=[A["SU.M1.GUIDED MISSILE"]],t[11]=[A["SU.M1.OTHER GUIDED MISSILES (POINT DEFENCE)"]],t[12]=[A["SU.M1.SPECIAL OPERATIONS FORCE"]],t[13]=[A["SU.M1.POSSIBLE SUBMARINE - LOW 1"]],t[14]=[A["SU.M1.POSSIBLE SUBMARINE - LOW 2"]],t[15]=[A["SU.M1.POSSIBLE SUBMARINE - HIGH 3"]],t[16]=[A["SU.M1.POSSIBLE SUBMARINE - HIGH 4"]],t[17]=[A["SU.M1.PROBABLE SUBMARINE"]],t[18]=[A["SU.M1.CERTAIN SUBMARINE"]],t[19]=[A["SU.M1.ANTI-TORPEDO TORPEDO"]],t[20]=[A["SU.M1.HIJACKING/HIJACKED"]],t[21]=[A["SU.M1.HIJACKER"]],t[22]=[A["SU.M1.CYBERSPACE"]],E["01"]=[A["SU.M2.AIR INDEPENDENT PROPULSION"]],E["02"]=[A["SU.M2.DIESEL PROPULSION"]],E["03"]=[A["SU.M2.DIESEL - TYPE 1"]],E["04"]=[A["SU.M2.DIESEL - TYPE 2"]],E["05"]=[A["SU.M2.DIESEL - TYPE 3"]],E["06"]=[A["SU.M2.NUCLEAR POWERED"]],E["07"]=[A["SU.M2.NUCLEAR - TYPE 1"]],E["08"]=[A["SU.M2.NUCLEAR - TYPE 2"]],E["09"]=[A["SU.M2.NUCLEAR - TYPE 3"]],E[10]=[A["SU.M2.NUCLEAR - TYPE 4"]],E[11]=[A["SU.M2.NUCLEAR - TYPE 5"]],E[12]=[A["SU.M2.NUCLEAR - TYPE 6"]],E[13]=[A["SU.M2.NUCLEAR - TYPE 7"]],E[14]=[A["SU.M2.AUTONOMOUS CONTROL"]],E[15]=[A["SU.M2.REMOTELY PILOTED"]],E[16]=[A["SU.M2.EXPENDABLE"]],E[17]=[A["SU.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(y);var X={type:"number",icons:function(I,t,E,R,e,A,C){"36"==e&&(I[11e4]=[A["SU.IC.SEA MINE"]],I[110100]=[A["SU.IC.SEA MINE - BOTTOM"]],I[110200]=[A["SU.IC.SEA MINE - MOORED"]],I[110300]=[A["SU.IC.SEA MINE - FLOATING"]],I[110400]=[A["SU.IC.SEA MINE - RISING"]],I[110500]=[A["SU.IC.SEA MINE (IN OTHER POSITION)"]],I[110600]=[A["SU.IC.SEA MINE - KINGFISHER"]],I[110700]=[A["SU.IC.SEA MINE - SMALL OBJECT"]],I[110800]=[A["SU.IC.SEA MINE EXERCISE MINE"]],I[110801]=[A["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]],I[110802]=[A["SU.IC.SEA MINE EXERCISE MINE - MOORED"]],I[110803]=[A["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]],I[110804]=[A["SU.IC.SEA MINE EXERCISE MINE - RISING"]],I[110900]=[A["SU.IC.SEA MINE NEUTRALIZED"]],I[110901]=[A["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]],I[110902]=[A["SU.IC.SEA MINE NEUTRALIZED - MOORED"]],I[110903]=[A["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]],I[110904]=[A["SU.IC.SEA MINE NEUTRALIZED - RISING"]],I[110905]=[A["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]],I[12e4]=[A["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]],I[13e4]=[A["SU.IC.SEA MINE DECOY"]],I[130100]=[A["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]],I[130200]=[A["SU.IC.SEA MINE DECOY, MOORED"]],I[14e4]=[],I[140100]=[s._scale(1.3,A["SU.IC.SEA MINE MILCO"])],I[140101]=[s._scale(1.3,[A["SU.IC.SEA MINE MILCO"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]])],I[140102]=[s._scale(1.3,[A["SU.IC.SEA MINE MILCO"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]])],I[140103]=[s._scale(1.3,[A["SU.IC.SEA MINE MILCO"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]])],I[140104]=[s._scale(1.3,[A["SU.IC.SEA MINE MILCO"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]])],I[140105]=[s._scale(1.3,[A["SU.IC.SEA MINE MILCO"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]])],I[140200]=[A["SU.IC.SEA MINE MILCO - BOTTOM"]],I[140201]=[A["SU.IC.SEA MINE MILCO - BOTTOM"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],I[140202]=[A["SU.IC.SEA MINE MILCO - BOTTOM"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],I[140203]=[A["SU.IC.SEA MINE MILCO - BOTTOM"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],I[140204]=[A["SU.IC.SEA MINE MILCO - BOTTOM"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],I[140205]=[A["SU.IC.SEA MINE MILCO - BOTTOM"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],I[140300]=[A["SU.IC.SEA MINE MILCO - MOORED"]],I[140301]=[A["SU.IC.SEA MINE MILCO - MOORED"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],I[140302]=[A["SU.IC.SEA MINE MILCO - MOORED"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],I[140303]=[A["SU.IC.SEA MINE MILCO - MOORED"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],I[140304]=[A["SU.IC.SEA MINE MILCO - MOORED"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],I[140305]=[A["SU.IC.SEA MINE MILCO - MOORED"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],I[140400]=[A["SU.IC.SEA MINE MILCO - FLOATING"]],I[140401]=[A["SU.IC.SEA MINE MILCO - FLOATING"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],I[140402]=[A["SU.IC.SEA MINE MILCO - FLOATING"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],I[140403]=[A["SU.IC.SEA MINE MILCO - FLOATING"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],I[140404]=[A["SU.IC.SEA MINE MILCO - FLOATING"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],I[140405]=[A["SU.IC.SEA MINE MILCO - FLOATING"],A["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],I[15e4]=[s._scale(1.3,A["SU.IC.SEA MINE MILEC"])],I[150100]=[A["SU.IC.SEA MINE MILEC - BOTTOM"]],I[150200]=[A["SU.IC.SEA MINE MILEC - MOORED"]],I[150300]=[A["SU.IC.SEA MINE MILEC - FLOATING"]],I[16e4]=[s._scale(1.3,A["SU.IC.SEA MINE NEGATIVE REACQUISITION"])],I[160100]=[A["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]],I[160200]=[A["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]],I[160300]=[A["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]],I[17e4]=[s._scale(1.3,A["SU.IC.SEA MINE GENERAL OBSTRUCTOR"])],I[170100]=[A["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]],I[18e4]=[s._scale(1.3,A["SU.IC.SEA MINE MINE ANCHOR"])],I[19e4]=[s._scale(1.3,A["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"])],I[190100]=[A["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]],I[190200]=[A["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]],I[190300]=[A["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]],I[2e5]=[A["SU.IC.ENVIRONMENTAL REPORT LOCATION"]],I[21e4]=[A["SU.IC.DIVE REPORT LOCATION"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var w={type:"number",icons:function(I,t,E,R,e,A,C){"40"==e&&(I[11e4]=[],I[110100]=[A["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]],I[110101]=[s._scale(1.5,A["ST.IC.ARREST"])],I[110102]=[A["ST.IC.ARSON/FIRE"]],I[110103]=[A["ST.IC.INDIVIDUAL"],A["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],I[110104]=[A["ST.IC.DRIVE-BY SHOOTING"]],I[110105]=[A["ST.IC.DRUG RELATED ACTIVITIES"]],I[110106]=[A["ST.IC.EXTORTION"]],I[110107]=[A["ST.IC.GRAFFITI"]],I[110108]=[A["ST.IC.KILLING VICTIM"]],I[110109]=[A["ST.IC.POISONING"]],I[110110]=[A["ST.IC.RIOT"]],I[110111]=[s._scale(1.5,A["ST.IC.BOOBY TRAP"])],I[110112]=[A["ST.IC.HOUSE"],A["ST.M1.EVICTION"]],I[110113]=[A["ST.IC.BLACK MARKETING"]],I[110114]=[A["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]],I[110115]=[A["GR.IC.FF.JAIL BREAK"]],I[110116]=[A["ST.IC.ROBBERY"]],I[110117]=[A["ST.IC.THEFT"]],I[110118]=[A["ST.IC.BURGLARY"]],I[110119]=[A["ST.IC.SMUGGLING"]],I[110120]=[A["ST.IC.ROCK THROWING"]],I[110121]=[A["ST.IC.COMPOSITE LOSS"],A["ST.M1.DEAD BODY"]],I[110122]=[A["ST.IC.SABOTAGE"]],I[110123]=[s._translate(0,10,s._scale(.8,A["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"])),A["AC.M1.THREAT"]],I[110200]=[A["ST.IC.BOMB"]],I[110201]=[A["ST.IC.BOMB"],A["AC.M1.THREAT"]],I[110300]=[A["ST.IC.IED"]],I[110301]=[A["ST.IC.EXPLOSION"],A["ST.IC.IED"]],I[110302]=[s._translate(0,15,s._scale(.7,[A["ST.IC.EXPLOSION"],A["ST.IC.IED"]])),A["ST.M1.PREMATURE"]],I[110303]=[A["ST.IC.IED"],A["GR.IC.FF.SUPPLY"]],I[110304]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.IED"]],I[110400]=[A["AC.IC.SHOOTING"]],I[110401]=[A["ST.IC.SNIPING"]],I[110500]=[A["ST.IC.ILLEGAL DRUG OPERATION"]],I[110501]=[A["ST.IC.ILLEGAL DRUG OPERATION"],A["ST.M1.TRAFFICKING"]],I[110502]=[A["ST.IC.ILLEGAL DRUG OPERATION"],A["ST.M1.LABRATORY"]],I[110600]=[A["ST.IC.EXPLOSION"]],I[110601]=[A["ST.IC.EXPLOSION"],A["ST.IC.GRENADE"]],I[110602]=[A["ST.IC.EXPLOSION"],A["ST.IC.INCENDIARY"]],I[110603]=[A["ST.IC.EXPLOSION"],A["ST.IC.MINE"]],I[110604]=[A["ST.IC.EXPLOSION"],s._scale(.6,A["GR.EQ.MORTAR"])],I[110605]=[A["ST.IC.EXPLOSION"],s._scale(.6,A["GR.EQ.SINGLE ROCKET LAUNCHER"])],I[110606]=[s._scale(.7,A["ST.IC.BOMB"]),A["ST.IC.EXPLOSION"]],I[12e4]=[A["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]],I[120100]=[A["ST.IC.DEMONSTRATION"]],I[13e4]=[],I[130100]=[A["ST.IC.PATROLLING"]],I[130200]=[A["ST.IC.PSYCHOLOGICAL OPERATIONS"]],I[130201]=[A["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]],I[130300]=[A["ST.IC.SEARCHING"]],I[130400]=[],I[130401]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.WILLING"]],I[130402]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.COERCED/IMPRESSED"]],I[130500]=[A["ST.IC.MINE LAYING"]],I[130600]=[A["ST.IC.SPY"]],I[130700]=[A["ST.IC.WARRANT SERVED"]],I[130800]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.EXFILTRATION"]],I[130900]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.INFILTRATION"]],I[131e3]=[A["ST.IC.GROUP"],A["ST.M1.MEETING"]],I[131001]=[A["ST.IC.POLLING PLACE/ELECTION"]],I[131100]=[A["ST.IC.HOUSE"],A["ST.M1.RAID"]],I[131200]=[A["GR.IC.FF.EMERGENCY OPERATION"]],I[131201]=[s._scale(.7,A["GR.IC.FF.EMERGENCY OPERATION"]),A["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]],I[131202]=[A["ST.IC.FOOD DISTRIBUTION"]],I[131203]=[s._scale(.7,A["GR.IC.FF.EMERGENCY OPERATION"]),A["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]],I[131204]=[s._scale(.7,A["GR.IC.FF.EMERGENCY OPERATION"]),A["AC.M1.EMERGENCY OPERATIONS CENTER"]],I[131205]=[A["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]],I[131206]=[s._scale(.7,A["GR.IC.FF.EMERGENCY OPERATION"]),A["AC.M1.EMERGENCY SHELTER"]],I[131207]=[s._scale(.7,A["GR.IC.FF.EMERGENCY OPERATION"]),A["AC.M1.EMERGENCY STAGING AREA"]],I[131208]=[A["GR.IC.FF.SUPPLY"],A["GR.IC.WATER"]],I[131300]=[A["GR.IC.EMERGENCY MEDICAL OPERATION"]],I[131301]=[A["AC.IC.EMT STATION LOCATION"]],I[131302]=[A["AC.IC.HEALTH DEPARTMENT FACILITY"]],I[131303]=[A["AC.IC.MEDICAL FACILITIES OUTPATIENT"]],I[131304]=[A["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]],I[131305]=[A["AC.IC.PHARMACY"]],I[131306]=[A["AC.IC.TRIAGE"]],I[131400]=[A["GR.IC.FIRE PROTECTION"]],I[131401]=[A["AC.IC.FIRE HYDRANT"]],I[131402]=[s._scale(1.5,A["GR.IC.FIRE PROTECTION"])],I[131403]=[A["AC.IC.OTHER WATER SUPPLY LOCATION"]],I[131500]=[A["GR.IC.FF.LAW ENFORCEMENT"]],I[131501]=[A["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],I[131502]=[A["GR.IC.FF.BORDER PATROL"]],I[131503]=[A["GR.IC.FF.CUSTOMS SERVICE"]],I[131504]=[A["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],I[131505]=[A["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],I[131506]=[A["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],I[131507]=[A["GR.IC.LAW ENFORCEMENT"]],I[131508]=[A["GR.IC.FF.PRISON"]],I[131509]=[A["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],I[131510]=[A["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],I[131511]=[A["GR.IC.LAW ENFORCEMENT VESSEL"]],I[131512]=[A["GR.IC.FF.US MARSHALS SERVICE"]],I[131513]=[A["ST.IC.INTERNAL SECURITY FORCE"]],I[14e4]=[A["AC.IC.FIRE EVENT"]],I[140100]=[A["AC.IC.FIRE ORIGIN"]],I[140200]=[A["AC.IC.SMOKE"]],I[140300]=[A["AC.IC.HOT SPOT"]],I[140400]=[A["AC.IC.NON-REsIdENTIAL FIRE"]],I[140500]=[A["AC.IC.REsIdENTIAL FIRE"]],I[140600]=[A["AC.IC.SCHOOL FIRE"]],I[140700]=[A["AC.IC.SPECIAL NEEDS FIRE"]],I[140800]=[A["AC.IC.WILD FIRE"]],I[15e4]=[],I[150100]=[A["AC.IC.HAZARDOUS MATERIALS INCIDENT"]],I[150101]=[A["AC.IC.CHEMICAL AGENT"]],I[150102]=[A["AC.IC.CORROSIVE MATERIAL"]],I[150103]=[A["AC.IC.HAZARDOUS WHEN WET"]],I[150104]=[A["AC.IC.EXPLOSIVE MATERIAL"]],I[150105]=[A["AC.IC.FLAMMABLE GAS"]],I[150106]=[A["AC.IC.FLAMMABLE LIQUID"]],I[150107]=[A["AC.IC.FLAMMABLE SOLID"]],I[150108]=[A["AC.IC.NON-FLAMMABLE GAS"]],I[150109]=[A["AC.IC.ORGANIC PEROXIDE"]],I[150110]=[A["AC.IC.OXIDIZER"]],I[150111]=[A["AC.IC.RADIOACTIVE MATERIAL"]],I[150112]=[A["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]],I[150113]=[A["AC.IC.TOXIC GAS"]],I[150114]=[A["AC.IC.TOXIC INFECTIOUS MATERIAL"]],I[150115]=[A["AC.IC.UNEXPLODED ORDNANCE"]],I[16e4]=[A["GR.IC.TRANSPORTATION"]],I[160100]=[A["ST.IC.HIJACKING (AIRPLANE)"]],I[160200]=[A["ST.IC.HIJACKING (BOAT)"]],I[160300]=[A["GR.EQ.TRAIN LOCOMOTIVE"]],I[160400]=[A["ST.IC.KNOWN INSURGENT VEHICLE"]],I[160500]=[A["ST.IC.EXPLOSION"],s._scale(.7,A["ST.IC.KNOWN INSURGENT VEHICLE"])],I[17e4]=[A["ST.IC.NATURAL EVENT"]],I[170100]=[A["ST.IC.GEOLOGIC"]],I[170101]=[A["AC.IC.AFTERSHOCK"]],I[170102]=[A["AC.IC.AVALANCHE"]],I[170103]=[A["AC.IC.EARTHQUAKE EPICENTER"]],I[170104]=[A["AC.IC.LANDSLIDE"]],I[170105]=[A["AC.IC.SUBSIDENCE"]],I[170106]=[A["AC.IC.VOLCANIC ERUPTION"]],I[170107]=[A["AC.IC.VOLCANIC THREAT"]],I[170108]=[A["AC.IC.CAVE ENTRANCE"]],I[170200]=[A["ST.IC.HYDRO-METEOROLOGICAL"]],I[170201]=[A["AC.IC.DROUGHT"]],I[170202]=[A["AC.IC.FLOOD"]],I[170203]=[A["AC.IC.TSUNAMI"]],I[170300]=[A["ST.IC.INFESTATION"]],I[170301]=[A["AC.IC.BIRD"]],I[170302]=[A["AC.IC.INSECT"]],I[170303]=[A["AC.IC.MICROBIAL"]],I[170304]=[A["AC.IC.REPTILE"]],I[170305]=[A["AC.IC.RODENT"]],I[18e4]=[],I[180100]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.LEADER"],A["ST.M2.RELIGIOUS"]],I[180200]=[A["ST.IC.INDIVIDUAL"],A["ST.M1.SPEAKER"]],t["01"]=[A["ST.M1.ASSASSINATION"]],t["02"]=[A["ST.M1.EXECUTION (WRONGFUL KILLING)"]],t["03"]=[A["ST.M1.HIJACKING/HIJACKED"]],t["04"]=[A["ST.M1.HOUSE-TO-HOUSE"]],t["05"]=[A["ST.M1.KIDNAPPING"]],t["06"]=[A["ST.M1.MURDER"]],t["07"]=[A["ST.M1.PIRACY"]],t["08"]=[A["ST.M1.RAPE"]],t["09"]=[A["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],t[10]=[A["ST.M1.PIRATE"]],t[11]=[A["ST.M1.FALSE"]],t[12]=[A["ST.M1.FIND"]],t[13]=[A["ST.M1.FOUND AND CLEARED"]],t[14]=[A["ST.M1.HOAX (DECOY)"]],t[15]=[A["ST.M1.ATTEMPTED"]],t[16]=[A["ST.M1.ACCIDENT"]],t[17]=[A["ST.M1.INCIDENT"]],t[18]=[A["ST.M1.THEFT"]],t[19]=[A["GR.M1.HIJACKER"]],t[20]=[A["GR.M1.CYBERSPACE"]],E["01"]=[A["GR.M2.CYBERSPACE"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(x);var _={type:"number",icons:function(I,t,E,R,e,A,C){"50"!=e&&"51"!=e&&"52"!=e&&"53"!=e&&"54"!=e||(I[11e4]=[],I[110100]=[A["SI.IC.COMMUNICATIONS"]],I[110200]=[A["SI.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I[110300]=[A["SI.IC.RADAR"]],t["01"]=[A["SI.M1.ANTI-AIRCRAFT FIRE CONTROL"]],t["02"]=[A["SI.M1.AIRBORNE SEARCH AND BOMBING"]],t["03"]=[A["SI.M1.AIRBORNE INTERCEPT"]],t["04"]=[A["SI.M1.ALTIMETER"]],t["05"]=[A["SI.M1.AIRBORNE RECONNAISSANCE AND MAPPING"]],t["06"]=[A["SI.M1.AIR TRAFFIC CONTROL"]],t["07"]=[A["SI.M1.BEACON TRANSPONDER (NOT IFF)"]],t["08"]=[A["SI.M1.BATTLEFIELD SURVEILLANCE"]],t["09"]=[A["SI.M1.CONTROLLED APPROACH"]],t[10]=[A["SI.M1.CONTROLLED INTERCEPT"]],t[11]=[A["SI.M1.CELLULAR/MOBILE"]],t[12]=[A["SI.M1.COASTAL SURVEILLANCE"]],t[13]=[A["SI.M1.DECOY/MIMIC"]],t[14]=[A["SI.M1.DATA TRANSMISSION"]],t[15]=[A["SI.M1.EARTH SURVEILLANCE"]],t[16]=[A["SI.M1.EARLY WARNING"]],t[17]=[A["SI.M1.FIRE CONTROL"]],t[18]=[A["SI.M1.GROUND MAPPING"]],t[19]=[A["SI.M1.HEIGHT FINDING"]],t[20]=[A["SI.M1.HARBOR SURVEILLANCE"]],t[21]=[A["SI.M1.IDENTIFICATION, FRIEND OR FOE (INTERROGATOR)"]],t[22]=[A["SI.M1.INSTRUMENT LANDING SYSTEM"]],t[23]=[A["SI.M1.IONOSPHERIC SOUNDING"]],t[24]=[A["SI.M1.IDENTIFICATION, FRIEND OR FOE (TRANSPONDER)"]],t[25]=[A["SI.M1.BARRAGE JAMMER"]],t[26]=[A["SI.M1.CLICK JAMMER"]],t[27]=[A["SI.M1.DECEPTIVE JAMMER"]],t[28]=[A["SI.M1.FREQUENCY SWEPT JAMMER"]],t[29]=[A["SI.M1.JAMMER (GENERAL)"]],t[30]=[A["SI.M1.NOISE JAMMER"]],t[31]=[A["SI.M1.PULSED JAMMER"]],t[32]=[A["SI.M1.REPEATER JAMMER"]],t[33]=[A["SI.M1.SPOT NOISE JAMMER"]],t[34]=[A["SI.M1.TRANSPONDER JAMMER"]],t[35]=[A["SI.M1.MISSILE ACQUISITION"]],t[36]=[A["SI.M1.MISSILE CONTROL"]],t[37]=[A["SI.M1.MISSILE DOWNLINK"]],t[38]=[A["SI.M1.METEOROLOGICAL"]],t[39]=[A["SI.M1.MULTI-FUNCTION"]],t[40]=[A["SI.M1.MISSILE GUIDANCE"]],t[41]=[A["SI.M1.MISSILE HOMING"]],t[42]=[A["SI.M1.MISSILE TRACKING"]],t[43]=[A["SI.M1.NAVIGATIONAL/GENERAL"]],t[44]=[A["SI.M1.NAVIGATIONAL/DISTANCE MEASURING EQUIPMENT"]],t[45]=[A["SI.M1.NAVIGATION/TERRAIN FOLLOWING"]],t[46]=[A["SI.M1.NAVIGATIONAL/WEATHER AVOIDANCE"]],t[47]=[A["SI.M1.OMNI-LINE OF SIGHT (LOS)"]],t[48]=[A["SI.M1.PROXIMITY USE"]],t[49]=[A["SI.M1.POINT-TO-POINT LINE OF SIGHT (LOS)"]],t[50]=[A["SI.M1.INSTRUMENTATION"]],t[51]=[A["SI.M1.RANGE ONLY"]],t[52]=[A["SI.M1.SONOBUOY"]],t[53]=[A["SI.M1.SATELLITE DOWNLINK"]],t[54]=[A["SI.M1.SPACE"]],t[55]=[A["SI.M1.SURFACE SEARCH"]],t[56]=[A["SI.M1.SHELL TRACKING"]],t[57]=[A["SI.M1.SATELLITE UPLINK"]],t[58]=[A["SI.M1.TARGET ACQUISITION"]],t[59]=[A["SI.M1.TARGET ILLUMINATION"]],t[60]=[A["SI.M1.TROPOSPHERIC SCATTER"]],t[61]=[A["SI.M1.TARGET TRACKING"]],t[62]=[A["SI.M1.UNKNOWN"]],t[63]=[A["SI.M1.VIDEO REMOTING"]],t[64]=[A["SI.M1.EXPERIMENTAL"]],t[65]=[A["SI.M1.CYBER"]],E["01"]=[A["SI.M2.CYBER"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(G);var J={type:"number",icons:function(I,t,E,R,e,A,C){"27"==e&&(I[11e4]=[],I[110100]=[],I[110101]=[A["GR.IC.FF.INFANTRY DISMOUNTED"]],I[110102]=[A["GR.IC.FF.MEDICAL"]],I[110103]=[A["GR.IC.FF.RECONNAISSANCE DISMOUNTED"]],I[110104]=[A["GR.IC.FF.SIGNAL DISMOUNTED"]],I[110200]=[],I[110201]=[A["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],I[110202]=[A["GR.IC.FIELD ARTILLERY OBSERVER"]],I[110203]=[A["GR.IC.JOINT FIRE SUPPORT"]],I[110204]=[A["GR.IC.LIAISON"]],I[110205]=[A["GR.IC.MESSENGER"]],I[110206]=[A["GR.IC.MILITARY POLICE"]],I[110207]=[A["GR.IC.OBSERVER/OBSERVATION"]],I[110208]=[A["GR.IC.SECURITY"]],I[110209]=[A["GR.IC.SNIPER"]],I[110210]=[A["GR.IC.SPECIAL OPERATIONS FORCES"]],I[110300]=[],I[110301]=[A["GR.EQ.RIFLE"]],I[110302]=[A["GR.EQ.RIFLE"],A["GR.EQ.SHORT RANGE"]],I[110303]=[A["GR.EQ.RIFLE"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110304]=[A["GR.EQ.RIFLE"],A["GR.EQ.LONG RANGE"]],I[110305]=[A["GR.EQ.MACHINE GUN"]],I[110306]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.SHORT RANGE"]],I[110307]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.INTERMEDIATE RANGE"]],I[110308]=[A["GR.EQ.MACHINE GUN"],A["GR.EQ.LONG RANGE"]],I[110309]=[A["GR.EQ.GRENADE LAUNCHER"]],I[110310]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.SHORT RANGE"])],I[110311]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.INTERMEDIATE RANGE"])],I[110312]=[A["GR.EQ.GRENADE LAUNCHER"],s._translate(0,20,A["GR.EQ.LONG RANGE"])],I[110313]=[A["GR.EQ.FLAME THROWER"]],I[110314]=[A["GR.EQ.MORTAR"]],I[110315]=[A["GR.EQ.SINGLE ROCKET LAUNCHER"]],I[110316]=[A["GR.EQ.ANTITANK ROCKET LAUNCHER"]],I[110400]=[],I[110401]=[A["GR.EQ.NON-LETHAL WEAPON"]],I[110402]=A["GR.EQ.NON-LETHAL GRENADE LAUNCHER"],I[110403]=[A["GR.EQ.TASER"]],I[12e4]=[],I[120100]=[],I[120101]=[A["GR.IC.LAW ENFORCEMENT"]],t["01"]=[A["GR.M1.CLOSE PROTECTION"]],t["02"]=[A["GR.M1.CROWD AND RIOT CONTROL"]],t["03"]=[A["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]],t["04"]=[A["GR.M1.SECURITY"]],t["05"]=[A["GR.M1.SNIPER"]],t["06"]=[A["GR.M1.SPECIAL WEAPONS AND TACTICS"]],t["07"]=[A["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],t["08"]=[A["GR.M1.MULTINATIONAL"]],t["09"]=[A["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]],t[10]=[A["ST.M1.GOVERNMENT ORGANIZATION"]],t[11]=[A["GR.M1.VIDEO IMAGERY"]],t[12]=[A["GR.M1.J1"]],t[13]=[A["GR.M1.J2"]],t[14]=[A["GR.M1.J3"]],t[15]=[A["GR.M1.J4"]],t[16]=[A["GR.M1.J5"]],t[17]=[A["GR.M1.J6"]],t[18]=[A["GR.M1.J7"]],t[19]=[A["GR.M1.J8"]],t[20]=[A["GR.M1.J9"]],t[21]=[A["GR.M1.OF-1"]],t[22]=[A["GR.M1.OF-2"]],t[23]=[A["GR.M1.OF-3"]],t[24]=[A["GR.M1.OF-4"]],t[25]=[A["GR.M1.OF-5"]],t[26]=[A["GR.M1.OF-6"]],t[27]=[A["GR.M1.OF-7"]],t[28]=[A["GR.M1.OF-8"]],t[29]=[A["GR.M1.OF-9"]],t[30]=[A["GR.M1.OF-10"]],t[31]=[A["GR.M1.OF-D"]],t[32]=[A["GR.M1.OR-1"]],t[33]=[A["GR.M1.OR-2"]],t[34]=[A["GR.M1.OR-3"]],t[35]=[A["GR.M1.OR-4"]],t[36]=[A["GR.M1.OR-5"]],t[37]=[A["GR.M1.OR-6"]],t[38]=[A["GR.M1.OR-7"]],t[39]=[A["GR.M1.OR-8"]],t[40]=[A["GR.M1.OR-9"]],t[41]=[A["GR.M1.WO-1"]],t[42]=[A["GR.M1.WO-2"]],t[43]=[A["GR.M1.WO-3"]],t[44]=[A["GR.M1.WO-4"]],t[45]=[A["GR.M1.WO-5"]],t[46]=[A["GR.M1.INDIVIDUAL"]],t[47]=[A["GR.M1.TEAM"]],t[48]=[A["GR.M1.SQUAD"]],t[49]=[A["GR.M1.SECTION"]],t[50]=[A["GR.M1.PLATOON"]],t[51]=[A["GR.M1.COMPANY"]],t[52]=[A["GR.M1.BATTALION"]],t[53]=[A["GR.M1.REGIMENT"]],t[54]=[A["GR.M1.BRIGADE"]],t[55]=[A["GR.M1.DIVISION"]],E["01"]=[A["GR.M2.AIRBORNE"]],E["02"]=[A["GR.M2.BICYCLE EQUIPPED"]],E["03"]=[A["GR.M2.DEMOLITION"]],E["04"]=[A["GR.M2.J1"]],E["05"]=[A["GR.M2.J2"]],E["06"]=[A["GR.M2.J3"]],E["07"]=[A["GR.M2.J4"]],E["08"]=[A["GR.M2.J5"]],E["09"]=[A["GR.M2.J6"]],E[10]=[A["GR.M2.J7"]],E[11]=[A["GR.M2.J8"]],E[12]=[A["GR.M2.J9"]],E[13]=[A["GR.M2.MOUNTAIN"]],E[14]=[A["GR.M2.OF-1"]],E[15]=[A["GR.M2.OF-2"]],E[16]=[A["GR.M2.OF-3"]],E[17]=[A["GR.M2.OF-4"]],E[18]=[A["GR.M2.OF-5"]],E[19]=[A["GR.M2.OF-6"]],E[20]=[A["GR.M2.OF-7"]],E[21]=[A["GR.M2.OF-8"]],E[22]=[A["GR.M2.OF-9"]],E[23]=[A["GR.M2.OF-10"]],E[24]=[A["GR.M2.OF-D"]],E[25]=[A["GR.M2.OR-1"]],E[26]=[A["GR.M2.OR-2"]],E[27]=[A["GR.M2.OR-3"]],E[28]=[A["GR.M2.OR-4"]],E[29]=[A["GR.M2.OR-5"]],E[30]=[A["GR.M2.OR-6"]],E[31]=[A["GR.M2.OR-7"]],E[32]=[A["GR.M2.OR-8"]],E[33]=[A["GR.M2.OR-9"]],E[34]=[A["GR.M2.WO-1"]],E[35]=[A["GR.M2.WO-2"]],E[36]=[A["GR.M2.WO-3"]],E[37]=[A["GR.M2.WO-4"]],E[38]=[A["GR.M2.WO-5"]],E[39]=[A["GR.M2.SKI"]])}};s._getMetadata.number=H,s._getIcons.number=V,s.addIconParts(D),s.addLabelOverrides(function(I){var t={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:30},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},E={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},R={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}};I[130100]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},additionalInformation1:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:30},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:0,fontsize:80},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},I[130200]=t,I[130300]=t,I[130400]={},I[130500]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},I[130600]={},I[130700]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},I[130800]=t,I[130900]=t,I[131001]=E,I[131002]=E,I[131003]=E,I[131100]=t,I[131200]=t,I[131300]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:40,fontweight:"bold"}},I[131301]={},I[131400]=t,I[131500]=t,I[131600]=t,I[131700]={},I[131800]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:125,fontsize:70}},I[131900]={uniqueDesignation:{stroke:!1,textanchor:"start",x:180,y:115,fontsize:40}},I[132e3]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},I[132100]={uniqueDesignation:{stroke:!1,textanchor:"start",x:100,y:110,fontsize:35,fill:"rgb(255,255,255)",fontweight:"bold"}},I[160100]={},I[160200]={},I[160201]={},I[160202]={},I[160203]={},I[160204]={},I[160205]={},I[160300]={uniqueDesignation:{stroke:!1,textanchor:"start",x:110,y:90,fontsize:40}},I[160400]=E,I[18e4]={},I[180100]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:130,fontsize:35}},I[180200]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:130,fontsize:35}},I[180300]={},I[180400]={},I[180500]={},I[180600]={uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:70,fontsize:35}},I[180700]={},I[180800]={},I[180900]={},I[181e3]={},I[181100]={},I[181200]={},I[181300]={},I[181400]={},I[181500]={},I[181600]={},I[181700]={},I[181800]={},I[181900]={},I[182e3]={},I[182100]={},I[182200]={},I[182300]={},I[182400]={},I[182500]={},I[200400]={},I[200500]={},I[200600]={},I[200700]={},I[210100]={},I[210200]={},I[210300]={},I[210400]={},I[210500]={},I[210600]={altitudeDepth:{stroke:!1,textanchor:"start",x:150,y:70,fontsize:35}},I[210700]={},I[210800]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:35}},I[210900]={},I[211e3]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:80,fontsize:35}},I[211100]={},I[211200]={},I[211300]={},I[211400]={},I[211500]={},I[211600]={},I[211700]={},I[211800]={},I[211900]={},I[212e3]={},I[212100]={},I[212200]={},I[212300]={},I[212400]={},I[212500]={},I[212600]={},I[212700]={},I[212800]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45}},I[212900]={},I[212901]={},I[212902]={},I[212903]={},I[212904]={},I[213e3]={},I[213100]={},I[213200]={},I[213300]={},I[213400]={},I[213500]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213501]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213502]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213503]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213504]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213505]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213506]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213507]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213508]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213509]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213510]={},I[213511]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213512]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213513]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213514]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213515]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},I[213600]={},I[213700]={},I[213800]={},I[213900]={},I[214e3]={},I[214100]={},I[214200]={},I[214300]={},I[214400]={},I[214500]={},I[214600]={},I[214700]={},I[214800]={},I[214900]={dtg:{stroke:!1,textanchor:"start",x:180,y:75,fontsize:30},dtg1:{stroke:!1,textanchor:"start",x:180,y:100,fontsize:30},uniqueDesignation:{stroke:!1,textanchor:"start",x:180,y:125,fontsize:30}},I[215e3]={},I[215100]={},I[215200]={},I[215300]={},I[215400]={},I[215500]={},I[215600]={dtg:{stroke:!1,textanchor:"start",x:180,y:75,fontsize:30},dtg1:{stroke:!1,textanchor:"start",x:180,y:100,fontsize:30},uniqueDesignation:{stroke:!1,textanchor:"start",x:180,y:125,fontsize:30}},I[215700]={},I[215800]={},I[215900]={},I[216e3]={},I[216100]={},I[216200]={},I[216300]={},I[216400]={},I[216500]={},I[216600]={},I[216700]={},I[216800]={},I[216900]={},I[217e3]={},I[217100]={},I[217200]={},I[217300]={},I[217400]={},I[217500]={},I[217600]={},I[217700]={},I[217800]={},I[217900]={},I[218e3]={},I[218100]={},I[218200]={},I[218300]={},I[218500]={},I[218600]={},I[218700]={},I[218800]={},I[218900]={},I[219e3]={},I[219100]={},I[219200]={},I[240601]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},targetNumber:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},I[240602]={targetNumber:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},I[240603]={},I[240900]={uniqueDesignation:{stroke:!1,textanchor:"start",x:195,y:110,fontsize:35,fontweight:"bold"}},I[250100]=E,I[250200]=E,I[250300]=E,I[250400]=E,I[250500]=E,I[270601]={},I[270602]={},I[270603]={},I[270701]={},I[280100]={},I[280200]={},I[280201]={},I[280300]={},I[280400]={},I[280500]={},I[280600]={},I[280700]={},I[280800]=t,I[280900]={},I[281e3]={},I[281100]={},I[281200]={},I[281300]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281301]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281400]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281500]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281600]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281700]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},I[281800]=t,I[281801]=t,I[281802]=t,I[281803]=t,I[281804]=t,I[281805]=t,I[281806]=t,I[281807]=t,I[281808]=t,I[281809]=t,I[281901]={},I[281902]={},I[281903]={},I[282001]={altitudeDepth:{stroke:!1,textanchor:"start",x:120,y:60,fontsize:40,fontweight:"bold"}},I[282002]={altitudeDepth:{stroke:!1,textanchor:"start",x:115,y:60,fontsize:40,fontweight:"bold"}},I[320100]={},I[320101]=t,I[320102]=t,I[320103]=t,I[320104]=t,I[320200]=t,I[320300]=t,I[320400]=t,I[320500]=t,I[320600]=t,I[320700]=t,I[320800]=t,I[320900]=t,I[321e3]=t,I[321100]=t,I[321200]=t,I[321300]=t,I[321400]=t,I[321500]=t,I[321600]=t,I[321700]=R,I[321701]=R,I[321702]=R,I[321703]=R,I[321704]=R,I[321705]=R,I[321706]={},I[321707]=E,I[321708]=E,I[321709]=E,I[321710]=E,I[321711]=E,I[321712]=E,I[321713]=E,I[321714]=E,I[321715]=E,I[321716]=E,I[321800]=R,I[340300]={},I[340400]={},I[340900]={},I[341400]={},I[341600]={},I[350101]={},I[350102]={},I[350103]={},I[350201]={},I[350202]={},I[350203]={}},"number");var Z={type:"number",icons:function(I,t,E,R,e,A,C){"25"==e&&(I[130100]=A["TP.ACTION POINT"],R[130100]={x1:60,x2:140,y1:-60},I[130200]=A["TP.ACTION AMNESTY POINT"],R[130200]={x1:60,x2:140,y1:-60},I[130300]=A["TP.ACTION CHECK POINT"],R[130300]={x1:60,x2:140,y1:-60},I[130400]=A["TP.CENTRE OF MAIN EFFORT"],R[130400]={x1:25,x2:175,y1:65,y2:135},I[130500]=A["TP.CONTACT POINT"],R[130500]={x1:50,x2:150,y1:50,y2:150},I[130600]=A["TP.COORDINATION POINT"],R[130600]={x1:50,x2:150,y1:50,y2:150},I[130700]=A["TP.DECISION POINT"],R[130700]={x1:30,x2:170,y1:25,y2:160},I[130800]=A["TP.DISTRESS CALL"],R[130800]={x1:60,x2:140,y1:-60},I[130900]=A["TP.ENTRY CONTROL POINT"],R[130900]={x1:60,x2:140,y1:-60},I[131001]=A["TP.FLY-TO-POINT (SONOBUOY)"],R[131001]={x1:60,x2:140,y1:-60},I[131002]=A["TP.FLY-TO-POINT (WEAPON)"],R[131002]={x1:60,x2:140,y1:-60},I[131003]=A["TP.FLY-TO-POINT (NORMAL)"],R[131003]={x1:60,x2:140,y1:-60},I[131100]=A["TP.ACTION LINKUP POINT"],R[131100]={x1:60,x2:140,y1:-60},I[131200]=A["TP.ACTION PASSAGE POINT"],R[131200]={x1:60,x2:140,y1:-60},I[131300]=A["TP.POINT OF INTEREST"],R[131300]={x1:50,x2:150,y1:-25},I[131301]=A["POINT OF INTEREST – LAUNCH EVENT"],R[131301]={x1:50,x2:150,y1:-25},I[131400]=A["TP.ACTION RALLY POINT"],R[131400]={x1:60,x2:140,y1:-60},I[131500]=A["TP.ACTION RELEASE POINT"],R[131500]={x1:60,x2:140,y1:-60},I[131600]=A["TP.ACTION START POINT"],R[131600]={x1:60,x2:140,y1:-60},I[131700]=A["TP.SPECIAL POINT"],R[131700]={x1:40,x2:160,y1:40,y2:160},I[131800]=A["TP.WAYPOINT"],R[131800]={x1:60,x2:140,y1:60,y2:140},I[131900]=A["TP.AIRFIELD"],R[131900]={x1:35,x2:165,y1:60,y2:125},I[132e3]=A["TP.TARGET HANDOVER"],R[132e3]={x1:40,x2:160,y1:40,y2:160},I[132100]=A["TP.KEY TERRAIN"],I[160100]=A["TP.OBSERVATION POST/OUTPOST"],R[160100]={x1:50,x2:150,y1:40,y2:150},I[160200]=A["TP.OBSERVATION POST/OUTPOST"],R[160200]={x1:50,x2:150,y1:40,y2:150},I[160201]=A["TP.OBSERVATION POST/RECONNAISSANCE"],R[160201]={x1:50,x2:150,y1:40,y2:150},I[160202]=A["TP.FORWARD OBSERVER POSITION"],R[160202]={x1:50,x2:150,y1:40,y2:150},I[160203]=A["TP.CBRN OBSERVATION POST"],R[160203]={x1:50,x2:150,y1:40,y2:150},I[160204]=A["TP.SENSOR OUTPOST"],R[160204]={x1:50,x2:150,y1:40,y2:150},I[160205]=A["TP.COMBAT OUTPOST"],R[160205]={x1:50,x2:150,y1:40,y2:150},I[160300]=A["TP.TARGET REFERENCE"],I[160400]=A["TP.POINT OF DEPARTURE"],R[160400]={x1:60,x2:140,y1:-60},I[18e4]=A["TP.AIR CONTROL POINT"],R[18e4]={x1:60,x2:140,y1:40,y2:160},I[180100]=A["TP.AIR CONTROL POINT (ACP)"],R[180100]={x1:50,x2:150,y1:50,y2:150},I[180200]=A["TP.COMMUNICATIONS CHECKPOINT"],R[180200]={x1:50,x2:150,y1:50,y2:150},I[180300]=A["TP.DOWNED AIRCREW PICKUP POINT"],R[180300]={x1:60,x2:140,y1:-60},I[180400]=A["TP.PULL-UP POINT"],R[180400]={x1:50,x2:240,y1:50,y2:150},I[180500]=A["TP.AIR CONTROL RENDEZVOUS"],R[180500]={x1:60,x2:140,y1:30,y2:170},I[180600]=A["TP.TACAN"],R[180600]={x1:60,x2:140,y1:30,y2:170},I[180700]=A["TP.CAP STATION"],R[180700]={x1:60,x2:140,y1:30,y2:170},I[180800]=A["TP.AEW STATION"],R[180800]={x1:60,x2:140,y1:30,y2:170},I[180900]=A["TP.FIXED WING"],I[181e3]=A["TP.STRIKE IP"],R[181e3]={x1:60,x2:140,y1:30,y2:170},I[181100]=A["TP.REPLENISHMENT STATION"],R[181100]={x1:60,x2:140,y1:30,y2:170},I[181200]=A["TP.TANKING"],R[181200]={x1:60,x2:140,y1:30,y2:170},I[181300]=A["TP.SUCAP - ROTARY WING"],R[181300]={x1:60,x2:140,y1:40,y2:160},I[181400]=A["TP.SUCAP - FIXED WING"],R[181400]={x1:60,x2:140,y1:40,y2:160},I[181500]=A["TP.SUCAP - ROTARY WING"],R[181500]={x1:60,x2:140,y1:40,y2:160},I[181600]=A["TP.MIW - FIXED WING"],R[181600]={x1:60,x2:140,y1:40,y2:160},I[181700]=A["TP.MIW - ROTARY WING"],R[181700]={x1:60,x2:140,y1:40,y2:160},I[181800]=A["TP.TOMCAT"],R[181800]={x1:60,x2:140,y1:30,y2:170},I[181900]=A["TP.RESCUE"],R[181900]={x1:60,x2:140,y1:30,y2:170},I[182e3]=A["TP.UNMANNED AERIAL SYSTEM"],R[182e3]={x1:60,x2:140,y1:30,y2:170},I[182100]=A["TP.VTUA"],R[182100]={x1:60,x2:140,y1:30,y2:170},I[182200]=A["TP.ORBIT"],R[182200]={x1:60,x2:140,y1:30,y2:170},I[182300]=A["TP.ORBIT - FIGURE EIGHT"],R[182300]={x1:60,x2:140,y1:30,y2:170},I[182400]=A["TP.ORBIT - RACE TRACK"],R[182400]={x1:60,x2:140,y1:30,y2:170},I[182500]=A["TP.ORBIT - RANDOM, CLOSED"],R[182500]={x1:60,x2:140,y1:30,y2:170},I[200400]=A["TP.SHIP AREA OF INTEREST (AEGIS ONLY)"],I[200500]=A["TP.ACTIVE MANOEUVRE AREA (AEGIS ONLY)"],R[200500]={x1:40,x2:160,y1:40,y2:160},I[200600]=A.TODO,I[200700]=A.TODO,I[210100]=A["TP.PLAN SHIP"],R[210100]={x1:50,x2:150,y1:50,y2:150},I[210200]=A["TP.AIM POINT"],R[210200]={x1:50,x2:150,y1:50,y2:150},I[210300]=A["TP.DEFENDED ASSET"],I[210400]=A["TP.DROP POINT"],R[210400]={x1:50,x2:150,y1:50,y2:120},I[210500]=A["TP.ENTRY POINT"],R[210500]={x1:50,x2:150,y1:50},I[210600]=A["TP.AIR DETONATION"],I[210700]=A["TP.GROUND ZERO"],R[210700]={x1:50,x2:150,y1:30},I[210800]=A["TP.IMPACT POINT"],R[210800]={x1:50,x2:150,y1:50,y2:150},I[210900]=A["TP.PREDICTED IMPACT POINT"],R[210900]={x1:50,x2:150,y1:50,y2:150},I[211e3]=A["TP.LAUNCHED TORPEDO (AEGIS ONLY)"],R[211e3]={x1:50,x2:150,y1:90,y2:110},I[211100]=A["TP.MSL DETECT POINT"],R[211100]={x1:50,x2:150,y1:30},I[211200]=A["TP.ACOUSTIC COUNTER MEASURE (DECOY)"],R[211200]={x1:50,x2:150,y1:30},I[211300]=A["TP.ELECTRONIC COUNTER MEASURES (ECM) DECOY"],R[211300]={x1:50,x2:150,y1:50,y2:150},I[211400]=A["TP.BRIEF CONTACT"],R[211400]={x1:50,x2:150,y1:0,y2:100},I[211500]=A["TP.DATUM"],R[211500]={x1:50,x2:150,y1:50,y2:150},I[211600]=A["TP.BT BOUY DROP"],R[211600]={x1:50,x2:150,y1:40,y2:160},I[211700]=A["TP.REPORTED BOTTOMED SUB"],I[211800]=A["TP.MOVING HAVEN"],R[211800]={x1:40,x2:160,y1:50,y2:150},I[211900]=A["TP.SCREEN CENTRE"],I[212e3]=A["TP.LOST CONTACT"],R[212e3]={x1:50,x2:150,y1:0,y2:100},I[212100]=A["TP.SINKER"],R[212100]={x1:50,x2:150,y1:0,y2:100},I[212200]=A["TP.TRIAL TRACK"],R[212200]={x1:50,x2:150,y1:0,y2:100},I[212300]=A["TP.FIX ACOUSTIC"],I[212400]=A["TP.FIX ELECTRO-MAGNETIC"],I[212500]=A["TP.ELECTRO MAGNETIC - MAGNETIC ANOMALY DETECTION (MAD)"],R[212500]={x1:50,x2:150,y1:50,y2:180},I[212600]=A["TP.FIX ELECTRO-OPTICAL"],I[212700]=A["TP.TARGET REFERENCE"],I[212800]=A["TP.HARBOR"],R[212800]={x1:50,x2:150,y1:50,y2:150},I[212900]=A["TP.HARBOR"],R[212900]={x1:50,x2:150,y1:50,y2:150},I[212901]=A["TP.HARBOR POINT A"],R[212901]={x1:50,x2:150,y1:50,y2:150},I[212902]=A["TP.HARBOR POINT Q"],R[212902]={x1:50,x2:150,y1:50,y2:150},I[212903]=A["TP.HARBOR POINT X"],R[212903]={x1:50,x2:150,y1:50,y2:150},I[212904]=A["TP.HARBOR POINT Y"],R[212904]={x1:50,x2:150,y1:50,y2:150},I[213e3]=A["TP.DIP POSITION"],R[213e3]={x1:50,x2:150,y1:50,y2:150},I[213100]=A["TP.SEARCH"],R[213100]={x1:50,x2:150,y1:50,y2:150},I[213200]=A["TP.SEARCH AREA"],R[213200]={x1:50,x2:150,y1:50,y2:150},I[213300]=A["TP.SEARCH CENTER"],R[213300]={x1:50,x2:150,y1:50,y2:150},I[213400]=A["TP.NAVIGATIONAL REFERENCE"],I[213500]=A["TP.SONOBUOY"],R[213500]={x1:60,x2:140,y1:-10,y2:160},I[213501]=A["TP.SONOBUOY ANM"],R[213501]={x1:60,x2:140,y1:-10,y2:160},I[213502]=A["TP.SONOBUOY ATAC"],R[213502]={x1:60,x2:140,y1:-10,y2:160},I[213503]=A["TP.SONOBUOY BARRA"],R[213503]={x1:60,x2:140,y1:-10,y2:160},I[213504]=A["TP.SONOBUOY BATHYTHERMOGRAPH TRANSMITTING SONOBUOY (BT)"],R[213504]={x1:60,x2:140,y1:-10,y2:160},I[213505]=A["TP.SONOBUOY COMMAND ACTIVE MULTIBEAM SONOBUOY (CAMBS)"],R[213505]={x1:60,x2:140,y1:-10,y2:160},I[213506]=A["TP.SONOBUOY CASS"],R[213506]={x1:60,x2:140,y1:-10,y2:160},I[213507]=A["TP.SONOBUOY DIFAR"],R[213507]={x1:60,x2:140,y1:-10,y2:160},I[213508]=A["TP.SONOBUOY DICASS"],R[213508]={x1:60,x2:140,y1:-10,y2:160},I[213509]=A["TP.SONOBUOY EXPENDABLE RELIABLE ACOUSTIC PATH SONOBUOY (ERAPS)"],R[213509]={x1:60,x2:140,y1:-10,y2:160},I[213510]=A["TP.SONOBUOY EXPIRED"],R[213510]={x1:40,x2:160,y1:-10,y2:160},I[213511]=A["TP.SONOBUOY KINGPIN"],R[213511]={x1:40,x2:160,y1:-10,y2:160},I[213512]=A["TP.SONOBUOY LOFAR"],R[213512]={x1:40,x2:160,y1:-10,y2:160},I[213513]=A["TP.SONOBUOY PATTERN CENTER"],R[213513]={x1:40,x2:160,y1:-10,y2:160},I[213514]=A["TP.SONOBUOY RO"],R[213514]={x1:40,x2:160,y1:-10,y2:160},I[213515]=A["TP.SONOBUOY VLAD"],R[213515]={x1:40,x2:160,y1:-10,y2:160},I[213600]=A["TP.REFERENCE POINT"],R[213600]={x1:40,x2:160,y1:40,y2:160},I[213700]=A["TP.SPECIAL POINT"],R[213700]={x1:40,x2:160,y1:40,y2:160},I[213800]=A["TP.NAVIGATIONAL REFERENCE"],R[213800]={x1:40,x2:160,y1:40,y2:160},I[213900]=A["TP.DLRP"],R[213900]={x1:40,x2:160,y1:40,y2:160},I[214e3]=A["FORWARD OBSERVER / SPOTTER POSITION"],R[214e3]={x1:40,x2:160,y1:60,y2:140},I[214100]=A["TP.VITAL AREA CENTRE"],R[214100]={x1:40,x2:160,y1:60,y2:140},I[214200]=A["TP.CORRIDOR TAB"],R[214200]={x1:40,x2:160,y1:40,y2:160},I[214300]=A["TP.ENEMY POINT"],R[214300]={x1:40,x2:160,y1:40,y2:160},I[214400]=A["TP.MARSHALL POINT"],R[214400]={x1:40,x2:160,y1:40,y2:160},I[214500]=A["TP.POINT OF INTENDED MOVEMENT"],R[214500]={x1:40,x2:160,y1:40,y2:160},I[214600]=A["TP.PRE-LANDFALL WAYPOINT"],R[214600]={x1:40,x2:160,y1:40,y2:160},I[214700]=A["TP.ESTIMATED POSITION (EP)"],R[214700]={x1:40,x2:160,y1:40,y2:160},I[214800]=A["TP.REFERENCE POINT WAYPOINT"],R[214800]={x1:40,x2:160,y1:40,y2:160},I[214900]=A["TP.SUB SURFACE CONTROL STATION"],R[214900]={x1:30,x2:170,y1:60,y2:140},I[215e3]=A["TP.SUBMARINE CONTROL STATION"],R[215e3]={x1:30,x2:170,y1:60,y2:140},I[215100]=A["TP.ASW SUBMARINE CONTROL STATION"],R[215100]={x1:30,x2:170,y1:60,y2:140},I[215200]=A["TP.(UUV) CONTROL STATION"],R[215200]={x1:30,x2:170,y1:60,y2:140},I[215300]=A["TP.UUV - ASW CONTROL STATION"],R[215300]={x1:30,x2:170,y1:60,y2:140},I[215400]=A["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SUBSURFACE STATION"],R[215400]={x1:30,x2:170,y1:60,y2:140},I[215500]=A["TP.UUV - SUW CONTROL STATION"],R[215500]={x1:30,x2:170,y1:60,y2:140},I[215600]=A["TP.SEA SURFACE CONTROL STATION"],R[215600]={x1:30,x2:170,y1:60,y2:140},I[215700]=A["TP.ASW CONTROL STATION"],R[215700]={x1:30,x2:170,y1:60,y2:140},I[215800]=A["TP.MINE WARFARE SURFACE STATION"],R[215800]={x1:30,x2:170,y1:60,y2:140},I[215900]=A["TP.NON-COMBATANT SURFACE STATION"],R[215900]={x1:30,x2:170,y1:60,y2:140},I[216e3]=A["TP.PICKET CONTROL STATION"],R[216e3]={x1:30,x2:170,y1:60,y2:140},I[216100]=A["TP.RENDEZVOUS CONTROL POINT"],R[216100]={x1:30,x2:170,y1:60,y2:140},I[216200]=A["TP.REPLENISHMENT AT SEA SURFACE STATION"],R[216200]={x1:30,x2:170,y1:60,y2:140},I[216300]=A["TP.RESCUE CONTROL POINT"],R[216300]={x1:30,x2:170,y1:60,y2:140},I[216400]=A["TP.SUW CONTROL STATION"],R[216400]={x1:30,x2:170,y1:60,y2:140},I[216500]=A["TP.(USV) CONTROL STATION"],R[216500]={x1:30,x2:170,y1:60,y2:140},I[216600]=A["TP.USV - ASW CONTROL STATION"],R[216600]={x1:30,x2:170,y1:60,y2:140},I[216700]=A["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SURFACE STATION"],R[216700]={x1:30,x2:170,y1:60,y2:140},I[216800]=A["TP.(RMV) USV CONTROL STATION"],R[216800]={x1:30,x2:170,y1:60,y2:140},I[216900]=A["TP.USV - SUW CONTROL STATION"],R[216900]={x1:30,x2:170,y1:60,y2:140},I[217e3]=A["TP.SHORE CONTROL STATION"],R[217e3]={x1:40,x2:160,y1:40,y2:160},I[217100]=A["TP.ROUTE"],R[217100]={x1:30,x2:170,y1:60,y2:140},I[217200]=A["TP.ROUTE DIVERSIONS"],R[217200]={x1:30,x2:170,y1:60,y2:170},I[217300]=A["TP.ROUTE POINT R"],R[217300]={x1:30,x2:170,y1:60,y2:170},I[217400]=A["TP.PICKET ROUTE"],R[217400]={x1:30,x2:170,y1:60,y2:170},I[217500]=A["TP.POINT R ROUTE"],R[217500]={x1:30,x2:170,y1:60,y2:170},I[217600]=A["TP.RENDEZVOUS ROUTE"],R[217600]={x1:30,x2:170,y1:60,y2:170},I[217700]=A["TP.ROUTE WAYPOINT"],R[217700]={x1:30,x2:170,y1:60,y2:170},I[217800]=A["TP.CLUTTER, STATIONARY OR CEASE REPORTING"],I[217900]=A["TP.TENTATIVE OR PROVISIONAL TRACK"],I[218e3]=A["TP.DISTRESSED VESSEL"],I[218100]=A["TP.DITCHED AIRCRAFT"],I[218200]=A["TP.PERSON IN WATER"],I[218300]=A["TP.ICEBERG"],R[218300]={x1:50,x2:150,y1:50,y2:150},I[218500]=A["TP.OIL RIG/PLATFORM"],R[218500]={x1:30,x2:170,y1:60,y2:140},I[218600]=A["TP.SEA MINELIKE"],R[218600]={x1:40,x2:160,y1:40,y2:150},I[218700]=A["TP.BOTTOM RETURN"],R[218700]={x1:40,x2:160,y1:40,y2:100},I[218800]=A["TP.INSTALLATION/MANMADE"],R[218800]={x1:40,x2:160,y1:40,y2:100},I[218900]=A["TP.MARINE LIFE"],R[218900]={x1:100,x2:220,y1:70,y2:130},I[219e3]=A["TP.SEA ANOMALY"],R[219e3]={x1:50,x2:150,y1:30,y2:120},I[219100]=A["TP.WRECK, DANGEROUS"],R[219100]={x1:40,x2:160,y1:70,y2:130},I[219200]=A["TP.WRECK, NON DANGEROUS"],R[219200]={x1:40,x2:160,y1:70,y2:130},I[240601]=A["TP.POINT/SINGLE TARGET"],I[240602]=A["TP.NUCLEAR TARGET"],I[240603]=A["TP.TARGETRECORDED (AEGIS ONLY)"],R[240603]={x1:0,x2:200,y1:50,y2:150},I[240900]=A["TP.FIRE SUPPORT STATION"],R[240900]={x1:50,x2:200,y1:50,y2:150},I[250100]=A["TP.FIRING POINT"],R[250100]={x1:60,x2:140,y1:-60},I[250200]=A["TP.HIDE POINT"],R[250200]={x1:60,x2:140,y1:-60},I[250300]=A["TP.LAUNCH POINT"],R[250300]={x1:60,x2:140,y1:-60},I[250400]=A["TP.RELOAD POINT"],R[250400]={x1:60,x2:140,y1:-60},I[250500]=A["TP.SURVEY CONTROL POINT"],R[250500]={x1:60,x2:140,y1:-60},I[270701]=A["TP.MINEFIELD, STATIC"],R[270701]={x1:25,x2:175,y1:65,y2:145},I[280100]=A.TODO,I[280200]=A["TP.ANTIPERSONNEL (AP) MINES"],I[280201]=A["TP.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS"],R[280201]={x1:40,x2:180,y1:40,y2:150},I[280300]=A["TP.ANTITANK MINE (AT)"],I[280400]=A["TP.(AT) ANTIHANDLING DEVICE"],R[280400]={x1:60,x2:140,y1:40,y2:195},I[280500]=A["TP.WIDE AREA MINES"],I[280600]=A["TP.UNSPECIFIED MINE"],I[280700]=A["TP.BOOBY TRAP"],I[280800]=A["TP.ENGINEER REGULATING POINT"],R[280800]={x1:60,x2:140,y1:-60},I[280900]=A["TP.EARTHWORK/FORTIFICATION"],I[281e3]=A["TP.SURFACE SHELTER"],I[281100]=A["TP.UNDERGROUND SHELTER"],I[281200]=A["TP.FORT"],I[281300]=A["TP.CHEMICAL EVENT"],R[281300]={x1:25,x2:175,y1:-10},I[281301]=A["TP.CHEMICAL – TOXIC INDUSTRIAL MATERIAL"],R[281301]={x1:25,x2:175,y1:-10},I[281400]=A["TP.BIOLOGICAL EVENT"],R[281400]={x1:25,x2:175,y1:-10},I[281401]=A["TP.BIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"],R[281401]={x1:25,x2:175,y1:-10},I[281500]=A["TP.NUCLEAR EVENT"],R[281500]={x1:25,x2:175,y1:-10},I[281600]=A["TP.NUCLEAR EVENT"],R[281600]={x1:25,x2:175,y1:-10},I[281700]=A["TP.RADIOLOGICAL EVENT"],R[281700]={x1:25,x2:175,y1:-10},I[281701]=A["TP.RADIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"],R[281701]={x1:25,x2:175,y1:-10},I[281800]=A["TP.DECON SITE/POINT"],R[281800]={x1:60,x2:140,y1:-60},I[281801]=A["TP.ALTERNATE DECON SITE/POINT"],R[281801]={x1:60,x2:140,y1:-60},I[281802]=A["TP.DECON SITE/POINT (EQUIPMENT)"],R[281802]={x1:60,x2:140,y1:-60},I[281803]=A["TP.DECON SITE/POINT (TROOPS)"],R[281803]={x1:60,x2:140,y1:-60},I[281804]=A["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],R[281804]={x1:60,x2:140,y1:-60},I[281805]=A["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],R[281805]={x1:60,x2:140,y1:-60},I[281806]=A["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],R[281806]={x1:60,x2:140,y1:-60},I[281807]=A["TP.MAIN EQUIPMENT DECONTAMINATION POINT/SITE"],R[281807]={x1:60,x2:140,y1:-60},I[281808]=A["TP.FORWARD TROOP DECONTAMINATION POINT/SITE"],R[281808]={x1:60,x2:140,y1:-60},I[281809]=A["TP.WOUNDED PERSONNEL DECONTAMINATION SITE"],R[281809]={x1:60,x2:140,y1:-60},I[281901]=A["TP.FIXED AND PREFABRICATED"],R[281901]={x1:60,x2:140,y1:30},I[281902]=A["TP.TETRAHEDRONS"],R[281902]={x1:60,x2:140,y1:30},I[281903]=A["TP.TETRAHEDRONS MOVABLE"],R[281903]={x1:60,x2:140,y1:30},I[282001]=A["TP.TOWER LOW"],R[282001]={x1:50,x2:150,y1:30,y2:120},I[282002]=A["TP.TOWER HIGH"],R[282002]={x1:50,x2:150,y1:30,y2:120},I[320100]=A["TP.AMBULANCE EXCHANGE POINT"],R[320100]={x1:60,x2:140,y1:-60},I[320101]=A["TP.AMBULANCE EXCHANGE POINT"],R[320101]={x1:60,x2:140,y1:-60},I[320102]=A["TP.AMBULANCE CONTROL POINT"],R[320102]={x1:60,x2:140,y1:-60},I[320103]=A["TP.AMBULANCE LOAD POINT"],R[320103]={x1:60,x2:140,y1:-60},I[320104]=A["TP.AMBULANCE RELAY POINT"],R[320104]={x1:60,x2:140,y1:-60},I[320200]=A["TP.AMMUNITION SUPPLY POINT (ASP)"],R[320200]={x1:60,x2:140,y1:-60},I[320300]=A["TP.AMMUNITION TRANSFER POINT (ATP)"],R[320300]={x1:60,x2:140,y1:-60},I[320400]=A["TP.CANNIBALIZATION POINT"],R[320400]={x1:60,x2:140,y1:-60},I[320500]=A["TP.CASUALTY COLLECTION POINT"],R[320500]={x1:60,x2:140,y1:-60},I[320600]=A["TP.CIVILIAN COLLECTION POINT"],R[320600]={x1:60,x2:140,y1:-60},I[320700]=A["TP.DETAINEE COLLECTION POINT"],R[320700]={x1:60,x2:140,y1:-60},I[320800]=A["TP.EPW COLLECTION POINT"],R[320800]={x1:60,x2:140,y1:-60},I[320900]=A["TP.LOGISTICS RELEASE POINT"],R[320900]={x1:60,x2:140,y1:-60},I[321e3]=A["TP.MAINTENANCE COLLECTION POINT"],R[321e3]={x1:60,x2:140,y1:-60},I[321100]=A["TP.MEDICAL EVACUATION (MEDEVAC) PICKUP POINT"],R[321100]={x1:60,x2:140,y1:-60},I[321200]=A["TP.REARM, REFUEL AND RESUPPLY POINT"],R[321200]={x1:60,x2:140,y1:-60},I[321300]=A["TP.REFUEL ON THE MOVE POINT"],R[321300]={x1:60,x2:140,y1:-60},I[321400]=A["TP.TRAFFIC CONTROL POST"],R[321400]={x1:60,x2:140,y1:-60},I[321500]=A["TP.TRAILER TRANSFER POINT"],R[321500]={x1:60,x2:140,y1:-60},I[321600]=A["TP.UNIT MAINTENANCE COLLECTION POINT"],R[321600]={x1:60,x2:140,y1:-60},I[321700]=A["TP.SUPPLY POINT"],R[321700]={x1:60,x2:140,y1:-60},I[321701]=A["TP.NATO CLASS I"],R[321701]={x1:60,x2:140,y1:-60},I[321702]=A["TP.NATO CLASS II"],R[321702]={x1:60,x2:140,y1:-60},I[321703]=A["TP.NATO CLASS III"],R[321703]={x1:60,x2:140,y1:-60},I[321704]=A["TP.NATO CLASS IV"],R[321704]={x1:60,x2:140,y1:-60},I[321705]=A["TP.NATO CLASS V"],R[321705]={x1:60,x2:140,y1:-60},I[321706]=A["TP.SUPPLY POINT"],R[321706]={x1:60,x2:140,y1:-60},I[321707]=A["TP.SP CLASS I"],R[321707]={x1:60,x2:140,y1:-60},I[321708]=A["TP.SP CLASS II"],R[321708]={x1:60,x2:140,y1:-60},I[321709]=A["TP.SP CLASS III"],R[321709]={x1:60,x2:140,y1:-60},I[321710]=A["TP.SP CLASS IV"],R[321710]={x1:60,x2:140,y1:-60},I[321711]=A["TP.SP CLASS V"],R[321711]={x1:60,x2:140,y1:-60},I[321712]=A["TP.SP CLASS VI"],R[321712]={x1:60,x2:140,y1:-60},I[321713]=A["TP.SP CLASS VII"],R[321713]={x1:60,x2:140,y1:-60},I[321714]=A["TP.SP CLASS VIII"],R[321714]={x1:60,x2:140,y1:-60},I[321715]=A["TP.SP CLASS IX"],R[321715]={x1:60,x2:140,y1:-60},I[321716]=A["TP.SP CLASS X"],R[321716]={x1:60,x2:140,y1:-60},I[321800]=A["TP.MEDICAL SUPPLY POINT"],R[321800]={x1:60,x2:140,y1:-60},I[340900]=A["TP.DESTROY"],R[340900]={x1:0,x2:200,y1:40,y2:160},I[341400]=A["TP.INTERDICT"],R[341400]={x1:0,x2:200,y1:40,y2:160},I[341600]=A["TP.NEUTRALIZE"],R[341600]={x1:0,x2:200,y1:40,y2:160},I[350101]=A["MAN MADE SPACE DEBRIS SMALL"],I[350102]=A["MAN MADE SPACE DEBRIS MEDIUM"],I[350103]=A["MAN MADE SPACE DEBRIS BIG"],I[350201]=A["NATURAL SPACE DEBRIS SMALL"],I[350202]=A["NATURAL SPACE DEBRIS MEDIUM"],I[350203]=A["NATURAL SPACE DEBRIS BIG"],t[13]=[A["TP.M1.UNSPECIFIED"]],t[14]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE 2"],A["TP.M1.ANTIPERSONNEL MINE 3"]],t[15]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],t[16]=[A["TP.M1.ANTITANK MINE 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.ANTITANK MINE 3"]],t[17]=[A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[18]=[A["TP.M1.WIDE AREA ANTITANK MINE 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[19]=[A["TP.M1.MINE CLUSTER 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.MINE CLUSTER 3"]],t[20]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.ANTIPERSONNEL MINE 3"]],t[21]=[A["TP.M1.ANTITANK MINE 1"],A["TP.M1.ANTIPERSONNEL MINE 2"],A["TP.M1.ANTITANK MINE 3"]],t[22]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.ANTIPERSONNEL MINE 3"]],t[23]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.ANTIPERSONNEL MINE 3"]],t[24]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.ANTIPERSONNEL MINE 3"]],t[25]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],t[26]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],t[27]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],t[28]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],t[29]=[A["TP.M1.ANTITANK MINE 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.ANTITANK MINE 3"]],t[30]=[A["TP.M1.ANTITANK MINE 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.ANTITANK MINE 3"]],t[31]=[A["TP.M1.ANTITANK MINE 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.ANTITANK MINE 3"]],t[32]=[A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[33]=[A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[34]=[A["TP.M1.WIDE AREA ANTITANK MINE 1"],A["TP.M1.MINE CLUSTER 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[35]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.ANTITANK MINE 3"]],t[36]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[37]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[38]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],A["TP.M1.MINE CLUSTER 3"]],t[39]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[40]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[41]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.MINE CLUSTER 3"]],t[42]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[43]=[A["TP.M1.ANTIPERSONNEL MINE 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.MINE CLUSTER 3"]],t[44]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.MINE CLUSTER 3"]],t[45]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],t[46]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[47]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE 2"],A["TP.M1.MINE CLUSTER 3"]],t[48]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.WIDE AREA ANTITANK MINE 3"]],t[49]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],A["TP.M1.MINE CLUSTER 3"]],t[50]=[A["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],A["TP.M1.WIDE AREA ANTITANK MINE 2"],A["TP.M1.MINE CLUSTER 3"]])}},q=[k,B,Y,W,u,v,Q,g,b,K,X,w,_,J,Z],j=[k,B,Y,W,u,v,Q,g,b,K,X,w,_,{type:"number",icons:function(I,t,E,R,e,A,C){"60"==e&&(I[11e4]=[],I[110100]=[A["CY.IC.COMBAT MISSION TEAM"]],I[110200]=[A["CY.IC.NATIONAL MISSION TEAM"]],I[110300]=[A["CY.IC.CYBER PROTECTION TEAM"]],I[110400]=[A["CY.IC.NATION STATE CYBER THREAT ACTOR"]],I[110500]=[A["CY.IC.NON NATION STATE CYBER THREAT ACTOR"]])}},Z];return s.addIcons(F),s.addIcons(f),s.addIcons(z),s.addIcons(q),s.addIcons(j),s.Path2D=function(I,t){var E,R,e,A,C,T,S,N,O,G,o;I.beginPath();var M=t.match(/([MCLHV][^MCLHV]*)/gi);for(S=0;S<M.length;S++){if("M"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),O=E=parseFloat(o[0]),G=R=parseFloat(o[1]),I.moveTo(E,R),N=2;N<o.length;N+=2)E=parseFloat(o[N]),R=parseFloat(o[N+1]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(I.closePath(),E=O,R=G)}if("m"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),O=E=E?E+parseFloat(o[0]):parseFloat(o[0]),G=R=R?R+parseFloat(o[1]):parseFloat(o[1]),I.moveTo(E,R),N=2;N<o.length;N+=2)E+=parseFloat(o[N]),R+=parseFloat(o[N+1]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(I.closePath(),E=O,R=G)}if("L"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<o.length;N+=2)E=parseFloat(o[N]),R=parseFloat(o[N+1]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(I.closePath(),E=O,R=G)}if("l"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<o.length;N+=2)E+=parseFloat(o[N]),R+=parseFloat(o[N+1]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("C"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<o.length;N+=6)e=parseFloat(o[N]),A=parseFloat(o[N+1]),C=parseFloat(o[N+2]),T=parseFloat(o[N+3]),E=parseFloat(o[N+4]),R=parseFloat(o[N+5]),I.bezierCurveTo(e,A,C,T,E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("c"==M[S].charAt(0)){for(o=M[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<o.length;N+=6)e=E+parseFloat(o[N]),A=R+parseFloat(o[N+1]),C=E+parseFloat(o[N+2]),T=R+parseFloat(o[N+3]),E+=parseFloat(o[N+4]),R+=parseFloat(o[N+5]),I.bezierCurveTo(e,A,C,T,E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("H"==M[S].charAt(0)){for(o=M[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<o.length;N++)E=parseFloat(o[N]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("h"==M[S].charAt(0)){for(o=M[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<o.length;N++)E+=parseFloat(o[N]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("V"==M[S].charAt(0)){for(o=M[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<o.length;N++)R=parseFloat(o[N]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}if("v"==M[S].charAt(0)){for(o=M[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<o.length;N++)R+=parseFloat(o[N]),I.lineTo(E,R);"Z"==M[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&I.closePath()}}},s});