/**!
* @license
* The MIT License (MIT)
* 
* Copyright (c) 2017 Måns Beckman - www.spatialillusions.com
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* More information can be found at www.spatialillusions.com 
*/
!function(t,I){"object"==typeof exports&&"undefined"!=typeof module?module.exports=I():"function"==typeof define&&define.amd?define("milsymbol",I):(t="undefined"!=typeof globalThis?globalThis:t||self).ms=I()}(this,function(){"use strict";var B={Black:{Civilian:"black",Friend:"black",Hostile:"black",Neutral:"black",Unknown:"black",Suspect:"black"},Dark:{Civilian:"rgb(80,0,80)",Friend:"rgb(0,107,140)",Hostile:"rgb(200,0,0)",Neutral:"rgb(0,160,0)",Unknown:"rgb(225,220,0)",Suspect:"rgb(255, 188, 1)"},FrameColor:{Civilian:"rgb(255,0,255)",Friend:"rgb(0, 255, 255)",Hostile:"rgb(255, 0, 0)",Neutral:"rgb(0, 255, 0)",Unknown:"rgb(255, 255, 0)",Suspect:"rbg(255, 188, 1)"},IconColor:{Civilian:"rgb(255,0,255)",Friend:"rgb(0, 255, 255)",Hostile:"rgb(255, 0, 0)",Neutral:"rgb(0, 255, 0)",Unknown:"rgb(255, 255, 0)",Suspect:"rgb(255, 188, 1)"},Light:{Civilian:"rgb(255,161,255)",Friend:"rgb(128,224,255)",Hostile:"rgb(255,128,128)",Neutral:"rgb(170,255,170)",Unknown:"rgb(255,255,128)",Suspect:"rgb(255, 229, 153)"},Medium:{Civilian:"rgb(128,0,128)",Friend:"rgb(0,168,220)",Hostile:"rgb(255,48,49)",Neutral:"rgb(0,226,110)",Unknown:"rgb(255,255,0)",Suspect:"rgb(255, 217, 107)"},None:{Civilian:!1,Friend:!1,Hostile:!1,Neutral:!1,Unknown:!1,Suspect:!1},OffWhite:{Civilian:"rgb(239, 239, 239)",Friend:"rgb(239, 239, 239)",Hostile:"rgb(239, 239, 239)",Neutral:"rgb(239, 239, 239)",Unknown:"rgb(239, 239, 239)",Suspect:"rgb(239, 239, 239)"},White:{Civilian:"white",Friend:"white",Hostile:"white",Neutral:"white",Unknown:"white",Suspect:"white"}};function k(E){let t;var e=[],R=[],C=this.colors.frameColor[this.metadata.affiliation];if((this.metadata.frame||!this.style.icon)&&void 0!==this.metadata.baseGeometry.g.type){let I={type:this.metadata.baseGeometry.g.type};switch(I.type){case"path":I.d=this.metadata.baseGeometry.g.d;break;case"circle":I.cx=this.metadata.baseGeometry.g.cx,I.cy=this.metadata.baseGeometry.g.cy,I.r=this.metadata.baseGeometry.g.r}if(I.fill=this.style.fillColor||this.colors.fillColor[this.metadata.affiliation],I.fillopacity=this.style.fillOpacity,I.stroke=C,I.strokewidth=10<=this.style.size?this.style.strokeWidth:10,this.style.frame&&0<this.style.outlineWidth){let t;"path"==I.type&&this.metadata.fill&&!this.style.monoColor?((t={type:this.metadata.baseGeometry.g.type}).d=this.metadata.baseGeometry.g.d+" Z",t.strokewidth=10<=this.style.size?this.style.strokeWidth:10):t=I,e.push(E.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor))}if(""==this.style.monoColor&&this.style.fill||!this.metadata.notpresent||(I.strokedasharray=this.metadata.notpresent),R.push(I),this.metadata.space&&(t={Friend:{type:"path",stroke:!1,fill:C,d:"M 100,30 C 90,30 80,35 68.65625,50 l 62.6875,0 C 120,35 110,30 100,30"},Hostile:{type:"path",stroke:!1,fill:C,d:"M67,50 L100,20 133,50 z"},Neutral:{type:"path",stroke:!1,fill:C,d:"M45,50 l0,-20 110,0 0,20 z"},Unknown:{type:"path",stroke:!1,fill:C,d:"M 100 22.5 C 85 22.5 70 31.669211 66 50 L 134 50 C 130 31.669204 115 22.5 100 22.5 z"}},R.push(t[this.metadata.affiliation])),this.metadata.activity&&(t={Friend:{type:"path",stroke:!1,fill:C,d:"m 160,135 0,15 15,0 0,-15 z m -135,0 15,0 0,15 -15,0 z m 135,-85 0,15 15,0 0,-15 z m -135,0 15,0 0,15 -15,0 z"},Hostile:{type:"path",stroke:!1,fill:C,d:"M 100 28 L 89.40625 38.59375 L 100 49.21875 L 110.59375 38.59375 L 100 28 z M 38.6875 89.3125 L 28.0625 99.9375 L 38.6875 110.53125 L 49.28125 99.9375 L 38.6875 89.3125 z M 161.40625 89.40625 L 150.78125 100 L 161.40625 110.59375 L 172 100 L 161.40625 89.40625 z M 99.9375 150.71875 L 89.3125 161.3125 L 99.9375 171.9375 L 110.53125 161.3125 L 99.9375 150.71875"},Neutral:{type:"path",stroke:!1,fill:C,d:"m 140,140 15,0 0,15 -15,0 z m -80,0 0,15 -15,0 0,-15 z m 80,-80 0,-15 15,0 0,15 z m -80,0 -15,0 0,-15 15,0 z"},Unknown:{type:"path",stroke:!1,fill:C,d:"M 107.96875 31.46875 L 92.03125 31.71875 L 92.03125 46.4375 L 107.71875 46.4375 L 107.96875 31.46875 z M 47.03125 92.5 L 31.09375 92.75 L 31.09375 107.5 L 46.78125 107.5 L 47.03125 92.5 z M 168.4375 92.5 L 152.5 92.75 L 152.5 107.5 L 168.1875 107.5 L 168.4375 92.5 z M 107.96875 153.5625 L 92.03125 153.8125 L 92.03125 168.53125 L 107.71875 168.53125 L 107.96875 153.5625 z"}},R.push(t[this.metadata.affiliation])),this.metadata.cyberspace&&(t={Friend:{type:"path",stroke:!1,fill:C,d:"m 135,150 40,-40 0,40 z"},Hostile:{type:"path",stroke:!1,fill:C,d:"m 150,78 0,44 22,-22 z"},Neutral:{type:"path",stroke:!1,fill:C,d:"m 115,155 40,-40 0,40 z"},Unknown:{type:"path",stroke:!1,fill:C,d:"M 150 65.7 L 150 134 C 176 123 176 77.2 150 65.7 z"}},R.push(t[this.metadata.affiliation])),this.style.fill&&this.style.frame&&this.metadata.notpresent&&!this.metadata.unframed){switch((I={type:this.metadata.baseGeometry.g.type}).type){case"path":I.d=this.metadata.baseGeometry.g.d;break;case"circle":I.cx=this.metadata.baseGeometry.g.cx,I.cy=this.metadata.baseGeometry.g.cy,I.r=this.metadata.baseGeometry.g.r}I.fill=!1,I.stroke=this.colors.white[this.metadata.affiliation],I.strokewidth=parseFloat(this.style.strokeWidth)+1,I.strokedasharray=this.metadata.notpresent,R.push(I)}}return{pre:e,post:R,bbox:this.metadata.baseGeometry.bbox}}function Y(I){var t=[],E=[];let e=new I.BBox({x1:50,x2:150,y1:50,y2:150}),R,C,A=[],T=[],S=[],N=[];if(this.style.icon){var O=this.colors.fillColor[this.metadata.affiliation],i=this.colors.fillColor.Neutral,M=(C=this.colors.iconColor[this.metadata.affiliation],this.colors.iconFillColor[this.metadata.affiliation]),G=this.colors.none[this.metadata.affiliation],o=this.colors.black[this.metadata.affiliation],n=this.colors.white[this.metadata.affiliation],O="standard:"+(this.metadata.STD2525?"2525":"APP6")+",edition:"+(this.metadata.edition||"")+","+this.metadata.dimension+this.metadata.affiliation+this.metadata.notpresent+this.metadata.numberSIDC+",frame:"+this.style.frame+",alternateMedal:"+this.style.alternateMedal+",colors:{fillcolor:"+O+",neutralColor"+i+",iconColor:"+C+",iconFillColor:"+M+",none:"+G+",black:"+o+",white:"+n+"}",M=(A=I._iconCache.hasOwnProperty(O)?I._iconCache[O].iconParts:(I._iconCache[O]={},I._iconCache[O].iconParts=I._getIconParts(this.metadata,this.colors,this.metadata.STD2525,this.style.monoColor,this.style.alternateMedal)),this.metadata.numberSIDC||(-1!=["WMGX--","WMMX--","WMFX--","WMX---","WMSX--"].indexOf(this.metadata.functionid)&&(e.y1=10,"Unknown"!=this.metadata.affiliation)&&(e.x2=this.metadata.baseGeometry.bbox.x2+20),I._iconCache[O].hasOwnProperty("letterSIDC")?(R=I._iconCache[O].letterSIDC.icons,N=I._iconCache[O].letterSIDC.bbox):"function"==typeof I._getIcons.letter?(I._iconCache[O].letterSIDC=I._getIcons.letter(I,A,this.metadata.STD2525),R=I._iconCache[O].letterSIDC.icons,N=I._iconCache[O].letterSIDC.bbox):console.warn("ms._getIcons.letter() is not present, you will need to load functionality for letter based SIDCs")),this.metadata.numberSIDC&&(i=String(this.options.sidc).substring(4,6),I._iconCache[O].hasOwnProperty("numberSIDC")?I._iconCache[O].numberSIDC.symbolSet.hasOwnProperty(i)?(R=I._iconCache[O].numberSIDC.symbolSet[i].icons,T=I._iconCache[O].numberSIDC.symbolSet[i].m1,S=I._iconCache[O].numberSIDC.symbolSet[i].m2,N=I._iconCache[O].numberSIDC.symbolSet[i].bbox):"function"==typeof I._getIcons.number?(I._iconCache[O].numberSIDC.symbolSet[i]=I._getIcons.number(I,i,A,this.metadata.STD2525,this.metadata.edition),R=I._iconCache[O].numberSIDC.symbolSet[i].icons,T=I._iconCache[O].numberSIDC.symbolSet[i].m1,S=I._iconCache[O].numberSIDC.symbolSet[i].m2,N=I._iconCache[O].numberSIDC.symbolSet[i].bbox):console.warn("ms._getIcons.number() is not present, you will need to load functionality for number based SIDCs"):(I._iconCache[O].numberSIDC={},I._iconCache[O].numberSIDC.symbolSet={},"function"==typeof I._getIcons.number?(I._iconCache[O].numberSIDC.symbolSet[i]=I._getIcons.number(I,i,A,this.metadata.STD2525,this.metadata.edition),R=I._iconCache[O].numberSIDC.symbolSet[i].icons,T=I._iconCache[O].numberSIDC.symbolSet[i].m1,S=I._iconCache[O].numberSIDC.symbolSet[i].m2,N=I._iconCache[O].numberSIDC.symbolSet[i].bbox):console.warn("ms._getIcons.number() is not present, you will need to load functionality for number based SIDCs"))),[{type:"path",stroke:!1,fill:this.colors.iconColor[this.metadata.affiliation],d:"m 94.8206,78.1372 c -0.4542,6.8983 0.6532,14.323 5.3424,19.6985 4.509,5.6933 11.309,9.3573 14.98,15.7283 3.164,6.353 -0.09,14.245 -5.903,17.822 -7.268,4.817 -18.6219,2.785 -22.7328,-5.249 -1.5511,-2.796 -2.3828,-5.931 -2.8815,-9.071 -3.5048,0.416 -7.0093,0.835 -10.5142,1.252 0.8239,8.555 5.2263,17.287 13.2544,21.111 7.8232,3.736 17.1891,3.783 25.3291,1.052 8.846,-3.103 15.737,-11.958 15.171,-21.537 0.05,-6.951 -4.272,-12.85 -9.134,-17.403 -4.526,-4.6949 -11.048,-8.3862 -12.401,-15.2748 -1.215,-2.3639 -0.889,-8.129 -0.889,-8.129 z m -0.6253,-20.5177 0,11.6509 11.6527,0 0,-11.6509 z"}]);if(this.metadata.numberSIDC){let t=R[this.metadata.functionid.substr(0,6)];void 0===(t=void 0===t&&95<=this.metadata.functionid.substr(4,2)?R[this.metadata.functionid.substr(0,4)+"00"]:t)?"000000"!=this.metadata.functionid.substr(0,6)&&""!=this.metadata.functionid.substr(0,6)&&(E.push(M),this.validIcon=!1):(G=String(this.options.sidc).substring(4,6),o=Number(this.metadata.functionid.substr(0,6)),("27"==G&&110301<=o&&o<=110403||"15"==G&&-1==[130100,17e4,170400,170600,170700,170800,170900,171100,200200,200300,200600,200700,200800,200900,201100,201301,201302,201400,210100,210200,210300,210400,210500,230200,25e4].indexOf(o))&&("000"!=this.metadata._modifier1&&"000"!=this.metadata._modifier2&&(t=[I._scale(.45,t,!0)]),"000"==this.metadata._modifier1&&"000"!=this.metadata._modifier2&&(t=[I._translate(0,-10,I._scale(.7,t,!0))]),"000"!=this.metadata._modifier1&&"000"==this.metadata._modifier2&&(t=[I._translate(0,10,I._scale(.7,t,!0))]),"000"==this.metadata._modifier1)&&"000"==this.metadata._modifier2&&(t=[I._scale(1,t,!0)]),E.push(t)),N.hasOwnProperty(this.metadata.functionid.substr(0,6))&&(e=new I.BBox(N[this.metadata.functionid.substr(0,6)])),"95"==this.metadata.functionid.substr(4,2)&&E.push(A["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]),"96"==this.metadata.functionid.substr(4,2)&&E.push(A["GR.IC.FF.DIVISION AND BELOW SUPPORT"]),"97"==this.metadata.functionid.substr(4,2)&&E.push(A["GR.IC.FF.CORPS SUPPORT"]),"98"==this.metadata.functionid.substr(4,2)&&E.push(A["GR.IC.FF.THEATRE SUPPORT"]),"0"==this.metadata._modifier1.substr(0,1)?"00"!=this.metadata.functionid.substr(6,2)&&(void 0===(n=T[this.metadata.functionid.substr(6,2)])?this.validIcon=!1:E.push(n)):void 0===(O=T[this.metadata._modifier1])?this.validIcon=!1:E.push(O),"0"==this.metadata._modifier2.substr(0,1)?"00"!=this.metadata.functionid.substr(8,2)&&(void 0===(i=S[this.metadata.functionid.substr(8,2)])?this.validIcon=!1:E.push(i)):void 0===(G=S[this.metadata._modifier2])?this.validIcon=!1:E.push(G)}else{o=this.options.sidc.substr(0,1)+"-"+this.options.sidc.substr(2,1)+"-"+this.options.sidc.substr(4,6);R.hasOwnProperty(o)?E.push(R[o]):"------"!=this.options.sidc.substr(4,6)&&""!=this.options.sidc.substr(4,6)&&(E.push(M),this.validIcon=!1),N[o]&&(e=new I.BBox(N[o]))}}return this.style.frame&&this.metadata.fill&&!this.style.monoColor&&!this.metadata.controlMeasure||0<this.style.outlineWidth&&t.push(I.outline(E,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:t,post:E,bbox:e}}function W(I){var E=[],e=[],R=new I.BBox(this.metadata.baseGeometry.bbox),C=(this.style.frameColor||this.colors.iconColor)[this.metadata.affiliation],A=new I.BBox;let T;var t,S=Number(this.style.hqStaffLength||I._hqStaffLength);if(this.metadata.headquarters&&0<S){let t=100;-1<["AirFriend","AirNeutral","GroundFriend","GroundNeutral","SeaNeutral","SubsurfaceNeutral"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(t=R.y2),this.metadata.dimensionType+this.metadata.affiliationType=="SubsurfaceFriend"&&(t=R.y1),T={type:"path",d:"M"+R.x1+","+t+" L"+R.x1+","+(R.y2+S)},0<this.style.outlineWidth&&E.push(I.outline(T,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push(T),A.y2=R.y2+S}if(this.metadata.taskForce&&(S=(S={"Corps/MEF":110,Army:145,"Army Group/front":180,"Region/Theater":215})[this.metadata.echelon]||90,T={type:"path",d:"M"+(100-S/2)+","+R.y1+" L"+(100-S/2)+","+(R.y1-40)+" "+(100+S/2)+","+(R.y1-40)+" "+(100+S/2)+","+R.y1},0<this.style.outlineWidth&&E.push(I.outline(T,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push(T),A.x1=Math.min(R.x1,100-S/2),A.x2=Math.max(R.x2,100+S/2),A.y1=R.y1-40),this.metadata.installation){let t=0;-1<["AirHostile","GroundHostile","SeaHostile"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(t=14),-1<["AirUnknown","GroundUnknown","SeaUnknown","AirFriend","SeaFriend"].indexOf(this.metadata.dimension+this.metadata.affiliation)&&(t=2),T={type:"path",fill:C,d:"M85,"+(R.y1+t-this.style.strokeWidth/2)+" 85,"+(R.y1-10)+" 115,"+(R.y1-10)+" 115,"+(R.y1+t-this.style.strokeWidth/2)+" 100,"+(R.y1-this.style.strokeWidth)+" Z"},0<this.style.outlineWidth&&E.push(I.outline(T,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push(T),A.merge({y1:R.y1-10})}this.metadata.feintDummy&&(S=+R.y1-R.width()/2,T={type:"path",strokedasharray:I._dashArrays.feintDummy,d:"M100,"+S+" L"+R.x1+","+ +R.y1+" M100,"+S+" L"+R.x2+","+ +R.y1},0<this.style.outlineWidth&&E.push(I.outline(T,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push(T),A.merge({y1:S})),this.metadata.echelon&&(S=this.metadata.installation?15:0,(t={"Team/Crew":{g:[{type:"circle",cx:100,cy:R.y1-20,r:15},{type:"path",d:"M80,"+(R.y1-10)+"L120,"+(R.y1-30)}],bbox:{y1:R.y1-40-S}},Squad:{g:[{type:"circle",fill:C,cx:100,cy:R.y1-20,r:7.5}],bbox:{y1:R.y1-20-7.5-S}},Section:{g:[{type:"circle",fill:C,cx:115,cy:R.y1-20,r:7.5},{type:"circle",fill:C,cx:85,cy:R.y1-20,r:7.5}],bbox:{y1:R.y1-20-7.5-S}},"Platoon/detachment":{g:[{type:"circle",fill:C,cx:100,cy:R.y1-20,r:7.5},{type:"circle",fill:C,cx:70,cy:R.y1-20,r:7.5},{type:"circle",fill:C,cx:130,cy:R.y1-20,r:7.5}],bbox:{y1:R.y1-20-7.5-S}},"Company/battery/troop":{g:[{type:"path",d:"M100,"+(R.y1-10)+"L100,"+(R.y1-35)}],bbox:{y1:R.y1-40-S}},"Battalion/squadron":{g:[{type:"path",d:"M90,"+(R.y1-10)+"L90,"+(R.y1-35)},{type:"path",d:"M110,"+(R.y1-10)+"L110,"+(R.y1-35)}],bbox:{y1:R.y1-40-S}},"Regiment/group":{g:[{type:"path",d:"M100,"+(R.y1-10)+"L100,"+(R.y1-35)},{type:"path",d:"M120,"+(R.y1-10)+"L120,"+(R.y1-35)},{type:"path",d:"M80,"+(R.y1-10)+"L80,"+(R.y1-35)}],bbox:{y1:R.y1-40-S}},Brigade:{g:[{type:"path",d:"M87.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S}},Division:{g:[{type:"path",d:"M70,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S,x1:70,x2:130}},"Corps/MEF":{g:[{type:"path",d:"M52.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M87.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M122.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S,x1:52.5,x2:147.5}},Army:{g:[{type:"path",d:"M35,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M70,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M140,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S,x1:35,x2:165}},"Army Group/front":{g:[{type:"path",d:"M17.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M52.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M87.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M122.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25       M157.5,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S,x1:17.5,x2:182.5}},"Region/Theater":{g:[{type:"path",d:"M0,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M35,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M70,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25   M105,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25    M140,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25     M175,"+(R.y1-10)+" l25,-25 m0,25 l-25,-25"}],bbox:{y1:R.y1-15-25-S,x1:0,x2:200}},Command:{g:[{type:"path",d:"M70,"+(R.y1-22.5)+" l25,0 m-12.5,12.5 l0,-25   M105,"+(R.y1-22.5)+" l25,0 m-12.5,12.5 l0,-25"}],bbox:{y1:R.y1-15-25-S,x1:70,x2:130}}}).hasOwnProperty(this.metadata.echelon))&&(T=t[this.metadata.echelon].g,0<this.style.outlineWidth&&E.push(I.outline({type:"translate",x:0,y:-S,draw:T},this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push({type:"translate",x:0,y:-S,draw:T}),A.merge(t[this.metadata.echelon].bbox)),this.metadata.mobility&&(this.style.frame||(R.y2=this.bbox.y2),"Neutral"==this.metadata.affiliation&&("Towed"!=this.metadata.mobility&&"Short towed array"!=this.metadata.mobility&&"Long towed Array"!=this.metadata.mobility||(R.y2+=8),"Over snow (prime mover)"!=this.metadata.mobility&&"Sled"!=this.metadata.mobility||(R.y2+=18),"Barge"==this.metadata.mobility)&&(R.y2+=5),(S={"Wheeled limited cross country":{g:[{type:"path",d:"M 53,1 l 94,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8}],bbox:{y2:R.y2+16}},"Wheeled cross country":{g:[{type:"path",d:"M 53,1 l 94,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8},{type:"circle",cx:100,cy:8,r:8}],bbox:{y2:R.y2+16}},Tracked:{g:[{type:"path",d:"M 53,1 l 100,0 c15,0 15,15 0,15 l -100,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:R.y2+18,x1:42,x2:168}},"Wheeled and tracked combination":{g:[{type:"circle",cx:58,cy:8,r:8},{type:"path",d:"M 83,1 l 70,0 c15,0 15,15 0,15 l -70,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:R.y2+16,x2:168}},Towed:{g:[{type:"path",d:"M 63,1 l 74,0"},{type:"circle",cx:58,cy:3,r:8},{type:"circle",cx:142,cy:3,r:8}],bbox:{y2:R.y2+10}},Rail:{g:[{type:"path",d:"M 53,1 l 96,0"},{type:"circle",cx:58,cy:8,r:8},{type:"circle",cx:73,cy:8,r:8},{type:"circle",cx:127,cy:8,r:8},{type:"circle",cx:142,cy:8,r:8}],bbox:{y2:R.y2+16}},"Over snow (prime mover)":{g:[{type:"path",d:"M 50,-9 l10,10 90,0"}],bbox:{y2:R.y2+9}},Sled:{g:[{type:"path",d:"M 145,-12  c15,0 15,15 0,15 l -90,0 c-15,0 -15,-15 0,-15"}],bbox:{y2:R.y2+15,x1:42,x2:168}},"Pack animals":{g:[{type:"path",d:"M 80,20 l 10,-20 10,20 10,-20 10,20"}],bbox:{y2:R.y2+20}},Barge:{g:[{type:"path",d:"M 50,1 l 100,0 c0,10 -100,10 -100,0"}],bbox:{y2:R.y2+10}},Amphibious:{g:[{type:"path",d:"M 65,10 c 0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0 0,10 10,10 10,0\t0,-10 10,-10 10,0"}],bbox:{y2:R.y2+20}},"Short towed array":{g:[{type:"path",fill:C,d:"M 50,5 l 100,0 M50,0 l10,0 0,10 -10,0 z M150,0 l-10,0 0,10 10,0 z M100,0 l5,5 -5,5 -5,-5 z"}],bbox:{y2:R.y2+10}},"Long towed Array":{g:[{type:"path",fill:C,d:"M 50,5 l 100,0 M50,0 l10,0 0,10 -10,0 z M150,0 l-10,0 0,10 10,0 z M105,0 l-10,0 0,10 10,0 z M75,0 l5,5 -5,5 -5,-5 z  M125,0 l5,5 -5,5 -5,-5 z"}],bbox:{y2:R.y2+10}}}).hasOwnProperty(this.metadata.mobility))&&(T=S[this.metadata.mobility].g,0<this.style.outlineWidth&&E.push(I.outline({type:"translate",x:0,y:R.y2,draw:T},this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),e.push({type:"translate",x:0,y:R.y2,draw:T}),A.merge(S[this.metadata.mobility].bbox)),this.metadata.leadership&&(t={Friend:{type:"path",d:"m 45,60 55,-25 55,25"}}[this.metadata.affiliation])&&(E.push(t),A.merge({y1:R.y1-20}));for(let t=0;t<E.length;t++)E[t].hasOwnProperty("fill")||(E[t].fill=!1),E[t].hasOwnProperty("stroke")||(E[t].stroke=C),E[t].hasOwnProperty("strokewidth")||(E[t].strokewidth=this.style.strokeWidth);for(let t=0;t<e.length;t++)e[t].hasOwnProperty("fill")||(e[t].fill=!1),e[t].hasOwnProperty("stroke")||(e[t].stroke=C),e[t].hasOwnProperty("strokewidth")||(e[t].strokewidth=this.style.strokeWidth);return{pre:E,post:e,bbox:A}}function v(t){var I=[],E=[],e=this.metadata.baseGeometry.bbox;let R=e.y1,C=e.y2;return this.metadata.condition&&(this.metadata.fill&&""===this.style.monoColor&&!this.style.simpleStatusModifier?(!this.metadata.frame&&this.metadata.iconBottom&&(C=this.metadata.iconBottom),this.options.headquartersElement&&(C+=35),C+=this.metadata.mobility?25:5,E.push({type:"path",strokewidth:this.style.strokeWidth,fill:{FullyCapable:"rgb(0,255,0)",Damaged:"rgb(255,255,0)",Destroyed:"rgb(255,0,0)",FullToCapacity:"rgb(0, 180, 240)"}[this.metadata.condition],stroke:this.colors.frameColor[this.metadata.affiliation],d:"M"+e.x1+","+C+" l"+e.width()+",0 0,25 -"+e.width()+",0 z"}),C+=25):("Damaged"!=this.metadata.condition&&"Destroyed"!=this.metadata.condition||(E.push({type:"path",d:"M150,20 L50,180",strokewidth:2*this.style.strokeWidth,stroke:this.colors.frameColor[this.metadata.affiliation]}),R=20,C=180),"Destroyed"==this.metadata.condition&&E.push({type:"path",d:"M50,20 L150,180",strokewidth:2*this.style.strokeWidth,stroke:this.colors.frameColor[this.metadata.affiliation]})),0<this.style.outlineWidth)&&I.push(t.outline(E,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:I,post:E,bbox:{y1:R,y2:C}}}function g(I){var E=[],e=[],R=this.bbox;let C=R.x1,A=R.x2,T=R.y1;var t=R.y2;if(""!==this.options.engagementBar){T-=6;var S=this.style.fontfamily,N=this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend;e.push({type:"text",text:this.options.engagementBar,x:100,y:R.y1-11,textanchor:"middle",fontsize:22,fontfamily:S,fontweight:"bold",fill:N,stroke:!1});let t=!1;this.metadata.fill&&""===this.style.monoColor&&(t={TARGET:"rgb(255, 0, 0)","NON-TARGET":"rgb(255, 255, 255)",EXPIRED:"rgb(255, 120, 0)"}[this.options.engagementType.toUpperCase()]||this.colors.fillColor[this.metadata.affiliation]);S=Math.max(R.width(),16*this.options.engagementBar.length);if(C=Math.min(C,100-S/2),A=Math.max(A,100+S/2),e.unshift({type:"path",strokewidth:this.style.strokeWidth,fill:t,stroke:this.colors.frameColor[this.metadata.affiliation],d:"M"+(100-S/2)+","+T+" l"+S+",0 0,-25 -"+S+",0 z"}),T-=25,0<this.style.outlineWidth){let t;t=this.metadata.fill&&""===this.style.monoColor?e[0]:e,E.push(I.outline(t,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor))}}return{pre:E,post:e,bbox:{x1:C,x2:A,y1:T,y2:t}}}function u(I){var t=[],E=[];let e=this.metadata.baseGeometry.bbox;var R=this.colors.frameColor[this.metadata.affiliation];if(this.metadata.dimensionUnknown&&R&&E.push({type:"text",text:"?",x:100,y:127,fill:R,fontfamily:this.style.fontfamily,fontsize:80,fontweight:"bold",textanchor:"middle"}),this.metadata.baseGeometry.g&&R){let t=10;("Unknown"==this.metadata.affiliation||"Hostile"==this.metadata.affiliation&&"Subsurface"!=this.metadata.dimension)&&(t=-10),"Exercise"==this.metadata.context&&(this.metadata.joker||this.metadata.faker||E.push({type:"text",text:"X",x:e.x2+t,y:50,fill:R,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),this.metadata.joker&&E.push({type:"text",text:"J",x:e.x2+t,y:50,fill:R,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),this.metadata.faker&&E.push({type:"text",text:"K",x:e.x2+t,y:50,fill:R,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),e={x2:e.x2+t+22,y1:25}),"Simulation"==this.metadata.context&&(E.push({type:"text",text:"S",x:e.x2+t,y:50,fill:R,fontfamily:this.style.fontfamily,fontsize:35,fontweight:"bold",textanchor:"start"}),e=new I.BBox({x2:e.x2+t+22,y1:25}))}return 0<this.style.outlineWidth&&t.push(I.outline(E,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:t,post:E,bbox:e}}const Q={0:19,1:19,2:19,3:19,4:19,5:19,6:19,7:19,8:19,9:19," ":10,"!":10,'"':12,"#":19,$:19,"%":30,"&":23,"'":7,"(":11,")":11,"*":13,"+":20,",":10,"-":11,".":10,"/":10,":":10,";":10,"<":20,"=":20,">":20,"?":19,"@":34,"{":12,"|":9,"}":12,"~":20,"[":10,"]":10,"^":16,_:19,"`":11,A:23,B:23,C:24,D:24,E:23,F:21,G:26,H:24,I:10,J:17,K:23,L:19,M:28,N:24,O:26,P:23,Q:26,R:24,S:23,T:21,U:24,V:23,W:32,X:23,Y:23,Z:21,a:19,b:19,c:17,d:19,e:19,f:10,g:19,h:19,i:8,j:8,k:17,l:8,m:28,n:19,o:19,p:19,q:19,r:11,s:17,t:10,u:19,v:17,w:24,x:17,y:17,z:17,"А":23,"а":19,"Б":22,"б":19,"В":23,"в":18,"Г":18,"г":13,"Д":23,"д":20,"Е":23,"е":19,"Ё":23,"ё":19,"Ж":31,"ж":23,"З":20,"з":16,"И":24,"и":19,"Й":24,"й":19,"К":20,"к":15,"Л":22,"л":20,"М":28,"м":23,"Н":24,"н":19,"О":26,"о":19,"П":24,"п":18,"Р":23,"р":19,"С":24,"с":17,"Т":21,"т":16,"У":21,"у":17,"Ф":26,"ф":28,"Х":23,"х":17,"Ц":25,"ц":19,"Ч":22,"ч":18,"Ш":31,"ш":27,"Щ":31,"щ":28,"Ъ":27,"ъ":21,"Ы":30,"ы":24,"Ь":22,"ь":18,"Э":24,"э":17,"Ю":34,"ю":25,"Я":24,"я":18};function l(I,E,t){if(0==I.length)return 0;let e=0;for(let t=0;t<I.length;t++)e+=E/30*(Q[I[t]]||28.5);return e+=t}function b(I){var E=[],e=[],R=this.metadata.baseGeometry.bbox,C=this.options.country_flag?70:0,A=(C+="!"==this.options.signature?30:0,this.options.stack?15*this.options.stack:0);const T=("object"==typeof this.style.infoColor?this.style.infoColor[this.metadata.affiliation]:this.style.infoColor)||this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend,S=this.style.fontfamily;var N=this.style.infoSize,O="object"==typeof this.style.infoBackground?this.style.infoBackground[this.metadata.affiliation]:this.style.infoBackground,i="object"==typeof this.style.infoBackground?this.style.infoBackground[this.metadata.affiliation]:this.style.infoBackground;const M=new I.BBox;function t(E){var e,R=[];for(const A in E)if(Object.prototype.hasOwnProperty.call(this.options,A)&&""!=this.options[A]&&Object.prototype.hasOwnProperty.call(E,A))for(let I=0;I<(E[A].length||1);I++){let t;e={y2:(t=Array.isArray(E[A])?E[A][I]:E[A]).y,y1:t.y-t.fontsize},"start"==t.textanchor&&(e.x1=t.x,e.x2=t.x+l(this.options[A],t.fontsize,0)),"middle"==t.textanchor&&(C=l(this.options[A],t.fontsize,0),e.x1=t.x-C/2,e.x2=t.x+C/2),"end"==t.textanchor&&(e.x1=t.x-l(this.options[A],t.fontsize,0),e.x2=t.x),M.merge(e);var C={type:"text",fontfamily:S,fill:T};Object.prototype.hasOwnProperty.call(t,"alignmentBaseline")&&(C.alignmentBaseline=t.alignmentBaseline),Object.prototype.hasOwnProperty.call(t,"fill")&&(C.fill=t.fill),Object.prototype.hasOwnProperty.call(t,"stroke")&&(C.stroke=t.stroke),Object.prototype.hasOwnProperty.call(t,"textanchor")&&(C.textanchor=t.textanchor),Object.prototype.hasOwnProperty.call(t,"fontsize")&&(C.fontsize=t.fontsize),Object.prototype.hasOwnProperty.call(t,"fontweight")&&(C.fontweight=t.fontweight),C.x=t.x,C.y=t.y,C.text=this.options[A],R.push(C)}return R}let G,o;if(this.metadata.numberSIDC){if(!Object.prototype.hasOwnProperty.call(I._labelCache,"number"))for(G in I._labelCache.number={},I._labelOverrides.number)Object.prototype.hasOwnProperty.call(I._labelOverrides.number,G)&&I._labelOverrides.number[G].call(this,I._labelCache.number);if(o=this.metadata.functionid.substr(0,6),this.metadata.controlMeasure&&Object.prototype.hasOwnProperty.call(I._labelCache.number,o))return e.push(t.call(this,I._labelCache.number[o])),0<this.style.outlineWidth&&E.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:E,post:e,bbox:M}}else{if(!Object.prototype.hasOwnProperty.call(I._labelCache,"letter"))for(G in I._labelCache.letter={},I._labelOverrides.letter)Object.prototype.hasOwnProperty.call(I._labelOverrides.letter,G)&&I._labelOverrides.letter[G].call(this,I._labelCache.letter);if(o=this.options.sidc.substr(0,1)+"-"+this.options.sidc.substr(2,1)+"-"+this.options.sidc.substr(4,6),Object.prototype.hasOwnProperty.call(I._labelCache.letter,o))return e.push(t.call(this,I._labelCache.letter[o])),0<this.style.outlineWidth&&E.push(I.outline(e,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:E,post:e,bbox:M}}var n=this.options.quantity||this.options.reinforcedReduced||this.options.staffComments||this.options.additionalInformation||this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.higherFormation||this.options.hostile||this.options.iffSif||this.options.sigint||this.options.uniqueDesignation||this.options.type||this.options.dtg||this.options.altitudeDepth||this.options.location||this.options.speed||this.options.specialHeadquarters||this.options.platformType||this.options.equipmentTeardownTime||this.options.commonIdentifier||this.options.auxiliaryEquipmentIndicator||this.options.headquartersElement||this.options.installationComposition||this.options.guardedUnit||this.options.specialDesignator;if(this.style.infoFields&&n){this.options.specialHeadquarters&&e.push(function(t){let I=45;return 1==t.length&&(I=45),3==t.length&&(I=39),{type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:100,y:103,fontsize:I=4<=t.length?33:I,text:t,fontweight:"bold",fontfamily:S,fill:T}}(this.options.specialHeadquarters)),this.options.quantity&&!this.metadata.dismounted&&(e.push({type:"text",text:this.options.quantity,x:100,y:R.y1-10,textanchor:"middle",fontsize:N,fontfamily:S,fill:T,stroke:!1}),M.y1=R.y1-10-N),this.options.headquartersElement&&(e.push({type:"text",text:this.options.headquartersElement,x:100,y:R.y2+35,textanchor:"middle",fontsize:35,fontfamily:S,fontweight:"bold",fill:T,stroke:!1}),M.y2=R.y2+35);n={L1:"",L2:"",L3:"",L4:"",L5:"",R1:"",R2:"",R3:"",R4:"",R5:""};let t;if(!isNaN(this.options.sidc)&&"Air"==this.metadata.baseDimension&&(n.R1=this.options.uniqueDesignation,n.R2=this.options.iffSif,n.R3=this.options.type,(this.options.speed||this.options.altitudeDepth)&&(t=[],this.options.speed&&t.push(this.options.speed),this.options.altitudeDepth&&t.push(this.options.altitudeDepth),n.R4=t.join("/")),this.options.staffComments||this.options.additionalInformation)&&(t=[],this.options.staffComments&&t.push(this.options.staffComments),this.options.additionalInformation&&t.push(this.options.additionalInformation),n.R5=t.join("/")),!isNaN(this.options.sidc)&&"Ground"!=this.metadata.baseDimension||(n.L1=this.options.dtg,(this.options.altitudeDepth||this.options.location)&&(t=[],this.options.altitudeDepth&&t.push(this.options.altitudeDepth),this.options.location&&t.push(this.options.location),n.L2=t.join("/")),n.L4=this.options.uniqueDesignation,n.L5=this.options.speed,n.R2=this.options.staffComments,n.R4=this.options.higherFormation,(this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.hostile||this.options.iffSif)&&(t=[],this.options.evaluationRating&&t.push(this.options.evaluationRating),this.options.combatEffectiveness&&t.push(this.options.combatEffectiveness),this.options.signatureEquipment&&t.push(this.options.signatureEquipment),this.options.hostile&&t.push(this.options.hostile),this.options.iffSif&&t.push(this.options.iffSif),n.R5=t.join("/")),isNaN(this.options.sidc)||this.metadata.unit?((this.options.type||this.options.platformType||this.options.equipmentTeardownTime)&&(t=[],this.options.type&&t.push(this.options.type),this.options.platformType&&t.push(this.options.platformType),this.options.equipmentTeardownTime&&t.push(this.options.equipmentTeardownTime),n.L3=t.join("/")),n.R1=this.options.reinforcedReduced,this.metadata.activity&&(n.R1=this.options.country),(this.options.additionalInformation||this.options.commonIdentifier)&&(t=[],this.options.additionalInformation&&t.push(this.options.additionalInformation),this.options.commonIdentifier&&t.push(this.options.commonIdentifier),n.R3=t.join("/"))):((this.options.type||this.options.platformType||this.options.commonIdentifier||this.options.installationComposition)&&(t=[],this.options.type&&t.push(this.options.type),this.options.platformType&&t.push(this.options.platformType),this.options.commonIdentifier&&t.push(this.options.commonIdentifier),this.options.installationComposition&&t.push(this.options.installationComposition),n.L3=t.join("/")),n.R1=this.options.country,(this.options.additionalInformation||this.options.equipmentTeardownTime)&&(t=[],this.options.additionalInformation&&t.push(this.options.additionalInformation),this.options.equipmentTeardownTime&&t.push(this.options.equipmentTeardownTime),n.R3=t.join("/")))),this.metadata.dismounted&&(this.options.quantity&&(e.push({type:"text",text:this.options.quantity,x:100,y:R.y2+N,textanchor:"middle",fontsize:N,fontfamily:S,fill:T,stroke:!1}),M.y2=R.y2+N),n.L1=this.options.dtg,(this.options.altitudeDepth||this.options.location)&&(t=[],this.options.altitudeDepth&&t.push(this.options.altitudeDepth),this.options.location&&t.push(this.options.location),n.L2=t.join("/")),(this.options.type||this.options.platformType||this.options.commonIdentifier)&&(t=[],this.options.type&&t.push(this.options.type),this.options.platformType&&t.push(this.options.platformType),this.options.commonIdentifier&&t.push(this.options.commonIdentifier),n.L3=t.join("/")),n.L4=this.options.uniqueDesignation,n.L5=this.options.speed,n.R1=this.options.country,n.R2=this.options.staffComments,this.options.additionalInformation&&(t=[],this.options.additionalInformation&&t.push(this.options.additionalInformation),n.R3=t.join("/")),n.R4=this.options.higherFormation,this.options.evaluationRating||this.options.combatEffectiveness||this.options.signatureEquipment||this.options.hostile||this.options.iffSif)&&(t=[],this.options.evaluationRating&&t.push(this.options.evaluationRating),this.options.combatEffectiveness&&t.push(this.options.combatEffectiveness),this.options.signatureEquipment&&t.push(this.options.signatureEquipment),this.options.hostile&&t.push(this.options.hostile),this.options.iffSif&&t.push(this.options.iffSif),n.R5=t.join("/")),!isNaN(this.options.sidc)&&"Sea"==this.metadata.baseDimension&&((this.options.guardedUnit||this.options.specialDesignator)&&(t=[],this.options.guardedUnit&&t.push(this.options.guardedUnit),this.options.specialDesignator&&t.push(this.options.specialDesignator),n.L1=t.join("/")),n.R1=this.options.uniqueDesignation,n.R2=this.options.type,n.R3=this.options.iffSif,(this.options.staffComments||this.options.additionalInformation)&&(t=[],this.options.staffComments&&t.push(this.options.staffComments),this.options.additionalInformation&&t.push(this.options.additionalInformation),n.R4=t.join("/")),this.options.location||this.options.speed)&&(t=[],this.options.location&&t.push(this.options.location),this.options.speed&&t.push(this.options.speed),n.R5=t.join("/")),isNaN(this.options.sidc)||"Subsurface"!=this.metadata.baseDimension||(n.L1=this.options.specialDesignator,n.R1=this.options.uniqueDesignation,n.R2=this.options.type,n.R3=this.options.altitudeDepth,n.R4=this.options.staffComments,n.R5=this.options.additionalInformation),M.x1=R.x1-Math.max(this.options.specialHeadquarters?(l(this.options.specialHeadquarters,N,20)-this.metadata.baseGeometry.bbox.width())/2:0,this.options.quantity?(l(this.options.quantity,N,20)-this.metadata.baseGeometry.bbox.width())/2:0,l(n.L1,N,20),l(n.L2,N,20),l(n.L3,N,20),l(n.L4,N,20),l(n.L5,N,20)),M.x2=R.x2+Math.max(this.options.specialHeadquarters?(l(this.options.specialHeadquarters,N,20)-this.metadata.baseGeometry.bbox.width())/2:0,this.options.quantity?(l(this.options.quantity,N,20)-this.metadata.baseGeometry.bbox.width())/2:0,l(n.R1+A,N,20),l(n.R2+A,N,20),l(n.R3+A,N,20),l(n.R4+A+1.5*C,N,20),l(n.R5+A+1.5*C,N,20)),(n.L1||n.R1)&&(M.y1=Math.min(M.y1,100-2.5*N)),(n.L2||n.R2)&&(M.y1=Math.min(M.y1,100-1.5*N)),(n.L4||n.R4)&&(M.y2=Math.max(M.y2,100+1.7*N)),(n.L5||n.R5)&&(M.y2=Math.max(M.y2,100+2.7*N)),this.style.infoBackground){let t={x1:100,y1:1e3,y2:0},I={x2:100,y1:1e3,y2:0};n.L1&&(t={x1:Math.min(t.x1,R.x1-l(n.L1,N,20)),x2:R.x1-10,y1:Math.min(t.y1,100-2.5*N),y2:Math.max(t.y2,100-1.5*N+10)}),n.L2&&(t={x1:Math.min(t.x1,R.x1-l(n.L2,N,20)),x2:R.x1-10,y1:Math.min(t.y1,100-1.5*N),y2:Math.max(t.y2,100-.5*N+10)}),n.L3&&(t={x1:Math.min(t.x1,R.x1-l(n.L3,N,20)),x2:R.x1-10,y1:Math.min(t.y1,100-.5*N),y2:Math.max(t.y2,100+.5*N+10)}),n.L4&&(t={x1:Math.min(t.x1,R.x1-l(n.L4,N,20)),x2:R.x1-10,y1:Math.min(t.y1,100+.5*N),y2:Math.max(t.y2,100+1.5*N+10)}),n.L5&&(t={x1:Math.min(t.x1,R.x1-l(n.L5,N,20)),x2:R.x1-10,y1:Math.min(t.y1,100+1.5*N),y2:Math.max(t.y2,100+2.5*N+10)}),Object.prototype.hasOwnProperty.call(t,"x2")&&(M.x1-=N/2,e.push({type:"path",d:"M "+(t.x1-N/2)+","+(t.y1+N/2)+" "+t.x1+","+t.y1+" "+t.x2+","+t.y1+" "+t.x2+","+t.y2+" "+(t.x1-N/2)+","+t.y2+"z",fill:O,stroke:i||!1})),n.R1&&(I={x1:R.x2+10,x2:Math.max(I.x2,R.x2+l(n.R1,N,20)),y1:Math.min(I.y1,100-2.5*N),y2:Math.max(I.y2,100-1.5*N+10)}),n.R2&&(I={x1:R.x2+10,x2:Math.max(I.x2,R.x2+l(n.R2,N,20)),y1:Math.min(I.y1,100-1.5*N),y2:Math.max(I.y2,100-.5*N+10)}),n.R3&&(I={x1:R.x2+10,x2:Math.max(I.x2,R.x2+l(n.R3,N,20)),y1:Math.min(I.y1,100-.5*N),y2:Math.max(I.y2,100+.5*N+10)}),n.R4&&(I={x1:R.x2+10,x2:Math.max(I.x2,R.x2+l(n.R4,N,20)),y1:Math.min(I.y1,100+.5*N),y2:Math.max(I.y2,100+1.5*N+10)}),n.R5&&(I={x1:R.x2+10,x2:Math.max(I.x2,R.x2+l(n.R5,N,20)),y1:Math.min(I.y1,100+1.5*N),y2:Math.max(I.y2,100+2.5*N+10)}),Object.prototype.hasOwnProperty.call(I,"x1")&&(M.x2+=N/2,e.push({type:"path",d:"M "+I.x1+","+I.y1+" "+(I.x2+N/2)+","+I.y1+" "+(I.x2+N/2)+","+(I.y2-N/2)+" "+I.x2+","+I.y2+" "+I.x1+","+I.y2+"z",fill:O,stroke:i||!1}))}n.L1&&e.push({type:"text",text:n.L1,x:R.x1-20,y:100-1.5*N,textanchor:"end",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.L2&&e.push({type:"text",text:n.L2,x:R.x1-20,y:100-.5*N,textanchor:"end",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.L3&&e.push({type:"text",text:n.L3,x:R.x1-20,y:100+.5*N,textanchor:"end",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.L4&&e.push({type:"text",text:n.L4,x:R.x1-20,y:100+1.5*N,textanchor:"end",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.L5&&e.push({type:"text",text:n.L5,x:R.x1-20,y:100+2.5*N,textanchor:"end",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.R1&&e.push({type:"text",text:n.R1,x:R.x2+20+A,y:100-1.5*N,textanchor:"start",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.R2&&e.push({type:"text",text:n.R2,x:R.x2+20+A,y:100-.5*N,textanchor:"start",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.R3&&e.push({type:"text",text:n.R3,x:R.x2+20+A,y:100+.5*N,textanchor:"start",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.R4&&e.push({type:"text",text:n.R4,x:C+R.x2+20+A,y:100+1.5*N,textanchor:"start",fontsize:N,fontfamily:S,fill:T,stroke:!1}),n.R5&&e.push({type:"text",text:n.R5,x:C+R.x2+20+A,y:100+2.5*N,textanchor:"start",fontsize:N,fontfamily:S,fill:T,stroke:!1}),(0<this.style.infoOutlineWidth||!1===this.style.infoOutlineWidth&&0<this.style.outlineWidth)&&E.push(I.outline(e,!1===this.style.infoOutlineWidth?this.style.outlineWidth:this.style.infoOutlineWidth,this.style.strokeWidth,this.style.infoOutlineColor||("object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)))}return{pre:E,post:e,bbox:M}}function K(t){var I=[],E=[];let e=this.metadata.baseGeometry.bbox;""==this.metadata.baseGeometry.g&&(e=this.bbox);var R,C,A,T=new t.BBox,S=this.colors.iconColor[this.metadata.affiliation]||this.colors.iconColor.Friend;let N;return this.style.infoFields&&""!==this.options.direction&&((0==this.options.speedLeader?(N=[{type:"rotate",degree:this.options.direction,x:100,y:100,draw:[{type:"path",fill:S,stroke:S,strokewidth:this.style.strokeWidth,d:"M100,100 l0,-75 -5,3 5,-15 5,15 -5,-3"}]}],T.y1=Math.min(100-95*Math.cos(this.options.direction/360*Math.PI*2),100),T.y2=Math.max(100-95*Math.cos(this.options.direction/360*Math.PI*2),100),T.x1=Math.min(100+95*Math.sin(this.options.direction/360*Math.PI*2),100),T.x2=Math.max(100+95*Math.sin(this.options.direction/360*Math.PI*2),100),"Ground"!=this.metadata.baseDimension&&""!=this.metadata.baseDimension||(this.metadata.headquarters?(N=[{type:"translate",x:e.x1-100,y:e.y2-(100-(this.style.hqStaffLength||t._hqStaffLength)),draw:N}],T.x1+=e.x1-100,T.x2+=e.x1-100):N=[{type:"translate",x:0,y:e.y2,draw:N},{type:"path",fill:S,stroke:S,strokewidth:this.style.strokeWidth,d:"M 100,"+e.y2+"l0,100"}]),T.y2+=e.y2+parseFloat(this.style.strokeWidth),E):(A=this.options.speedLeader*(100/this.style.size),R=this.options.direction*Math.PI/180,C=-A*Math.cos(R),A=A*Math.sin(R),T.x1=Math.min(100,100+A),T.x2=Math.max(100,100+A),T.y1=Math.min(100,100+C),T.y2=Math.max(100,100+C),N={type:"path",fill:S,stroke:S,strokewidth:this.style.strokeWidth,d:"M 100,100  l"+A+","+C},I)).push(N),0<this.style.outlineWidth)&&I.unshift(t.outline(N,this.style.outlineWidth,this.style.strokeWidth,"object"==typeof this.style.outlineColor?this.style.outlineColor[this.metadata.affiliation]:this.style.outlineColor)),{pre:I,post:E,bbox:T}}function X(t){var I=[],t=new t.BBox;return I.push({type:"path",fill:!1,stroke:"rgb(0,0,255)",strokewidth:1,d:"m 120,60 0,80 m -40,-80 0,80 m -20,-20 80,0 m 0,-40 -80,0 M 100,50 135.35534,64.64466 150,100 135.35534,135.35534 100,150.00002 64.644661,135.35534 50,100 64.644661,64.64466 z"}),{pre:[],post:I,bbox:t}}function t(t){return{x1:void 0!==(t=void 0===t?{}:t).x1?t.x1:100,y1:void 0!==t.y1?t.y1:100,x2:void 0!==t.x2?t.x2:100,y2:void 0!==t.y2?t.y2:100,width:function(){return this.x2-this.x1},height:function(){return this.y2-this.y1},getSize:function(){return{height:this.y2-this.y1,width:this.x2-this.x1}},merge:function(t){return this.x1=(t.x1<=this.x1?t:this).x1,this.y1=(t.y1<=this.y1?t:this).y1,this.x2=(t.x2>=this.x2?t:this).x2,this.y2=(t.y2>=this.y2?t:this).y2,this}}}var I={AirHostile:{g:{type:"path",d:"M 45,150 L45,70 100,20 155,70 155,150"},bbox:new t({x1:45,y1:20,x2:155,y2:150})},AirFriend:{g:{type:"path",d:"M 155,150 C 155,50 115,30 100,30 85,30 45,50 45,150"},bbox:new t({x1:45,y1:30,x2:155,y2:150})},AirNeutral:{g:{type:"path",d:"M 45,150 L 45,30,155,30,155,150"},bbox:new t({x1:45,y1:30,x2:155,y2:150})},AirUnknown:{g:{type:"path",d:"M 65,150 c -55,0 -50,-90 0,-90 0,-50 70,-50 70,0 50,0 55,90 0,90"},bbox:new t({x1:25,y1:20,x2:175,y2:150})},GroundHostile:{g:{type:"path",d:"M 100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new t({x1:28,y1:28,x2:172,y2:172})},GroundFriend:{g:{type:"path",d:"M25,50 l150,0 0,100 -150,0 z"},bbox:new t({x1:25,y1:50,x2:175,y2:150})},GroundNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new t({x1:45,y1:45,x2:155,y2:155})},GroundUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new t({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},LandDismountedIndividualHostile:{g:{type:"path",d:"M 100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new t({x1:28,y1:28,x2:172,y2:172})},LandDismountedIndividualFriend:{g:{type:"path",d:"m 100,45 55,25 0,60 -55,25 -55,-25 0,-60 z"},bbox:new t({x1:45,y1:45,x2:155,y2:155})},LandDismountedIndividualNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new t({x1:45,y1:45,x2:155,y2:155})},LandDismountedIndividualUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new t({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},SeaHostile:{g:{type:"path",d:"M100,28 L172,100 100,172 28,100 100,28 Z"},bbox:new t({x1:28,y1:28,x2:172,y2:172})},SeaFriend:{g:{type:"circle",cx:100,cy:100,r:60},bbox:new t({x1:40,y1:40,x2:160,y2:160})},SeaNeutral:{g:{type:"path",d:"M45,45 l110,0 0,110 -110,0 z"},bbox:new t({x1:45,y1:45,x2:155,y2:155})},SeaUnknown:{g:{type:"path",d:"M63,63 C63,20 137,20 137,63 C180,63 180,137 137,137 C137,180 63,180 63,137 C20,137 20,63 63,63 Z"},bbox:new t({x1:30.75,y1:30.75,x2:169.25,y2:169.25})},SubsurfaceHostile:{g:{type:"path",d:"M45,50 L45,130 100,180 155,130 155,50"},bbox:new t({x1:45,y1:50,x2:155,y2:180})},SubsurfaceFriend:{g:{type:"path",d:"m 45,50 c 0,100 40,120 55,120 15,0 55,-20 55,-120"},bbox:new t({x1:45,y1:50,x2:155,y2:170})},SubsurfaceNeutral:{g:{type:"path",d:"M45,50 L45,170 155,170 155,50"},bbox:new t({x1:45,y1:50,x2:155,y2:170})},SubsurfaceUnknown:{g:{type:"path",d:"m 65,50 c -55,0 -50,90 0,90 0,50 70,50 70,0 50,0 55,-90 0,-90"},bbox:new t({x1:25,y1:50,x2:175,y2:180})},PositionMarker:{g:{type:"circle",cx:100,cy:100,r:15},bbox:new t({x1:85,y1:85,x2:115,y2:115})}};const L=new function(){this._autoValidation=!1,this.version="3.0.2","object"==typeof console&&"object"!=typeof process&&console.info("milsymbol.js "+this.version+" - Copyright (c) 2024 M"+String.fromCharCode(229)+"ns Beckman  http://www.spatialillusions.com")};function C(I,E){for(let t=0;t<E.length;t++)if(Array.isArray(E[t]))E[t].length&&C.call(this,I,E[t]);else if("object"==typeof E[t]){var e,R;switch(I.lineWidth=(E[t].non_scaling_stroke||1)*(E[t].strokewidth||this.style.strokeWidth),void 0!==E[t].stroke&&(E[t].stroke?I.strokeStyle=E[t].stroke:I.strokeStyle="rgba(0,0,0,0)"),E[t].strokedasharray?I.setLineDash(E[t].strokedasharray.split(",")):0!=I.getLineDash().length&&I.setLineDash([]),E[t].linecap&&(I.lineCap=E[t].linecap,I.lineJoin=E[t].linecap),E[t].fill&&(I.fillStyle=E[t].fill),E[t].fill||(I.fillStyle="rgba(0,0,0,0)"),void 0!==E[t].fillopacity&&(I.globalAlpha=E[t].fillopacity),E[t].type){case"path":L._brokenPath2D?"function"==typeof L.Path2D?(L.Path2D(I,E[t].d),(void 0===E[t].fill||void 0!==E[t].fill&&E[t].fill)&&I.fill(),1!=I.globalAlpha&&(I.globalAlpha=1),(void 0===E[t].stroke||void 0!==E[t].stroke&&E[t].stroke)&&I.stroke()):console.warn("ms.Path2D() is not present"):(R=new Path2D(E[t].d),E[t].hasOwnProperty("clipPath")&&(I.save(),I.clip(new Path2D(E[t].clipPath),"nonzero")),(void 0===E[t].fill||void 0!==E[t].fill&&E[t].fill)&&I.fill(R),E[t].hasOwnProperty("clipPath")&&I.restore(),1!=I.globalAlpha&&(I.globalAlpha=1),(void 0===E[t].stroke||void 0!==E[t].stroke&&E[t].stroke)&&I.stroke(R));break;case"circle":E[t].hasOwnProperty("clipPath")&&(I.save(),I.clip(new Path2D(E[t].clipPath),"nonzero")),I.beginPath(),I.arc(E[t].cx,E[t].cy,E[t].r,0,2*Math.PI,!1),(void 0===E[t].fill||void 0!==E[t].fill&&E[t].fill)&&I.fill(),E[t].hasOwnProperty("clipPath")&&I.restore(),(void 0===E[t].stroke||void 0!==E[t].stroke&&E[t].stroke)&&I.stroke();break;case"text":I.font=(void 0!==E[t].fontweight?E[t].fontweight+" ":"")+E[t].fontsize+"px "+E[t].fontfamily,I.textAlign="middle"==E[t].textanchor?"center":E[t].textanchor,I.textBaseline=E[t].alignmentBaseline||"bottom",I.fillText(E[t].text,E[t].x,E[t].y),E[t].stroke&&I.strokeText(E[t].text,E[t].x,E[t].y);break;case"translate":I.save(),I.translate(E[t].x,E[t].y),C.call(this,I,E[t].draw),I.restore();break;case"rotate":R=E[t].x,e=E[t].y,I.save(),I.translate(R,e),I.rotate(E[t].degree*Math.PI/180),I.translate(-R,-e),C.call(this,I,E[t].draw),I.restore();break;case"scale":I.save(),I.scale(E[t].factor,E[t].factor),C.call(this,I,E[t].draw),I.restore()}E[t].linecap&&(I.lineCap="butt",I.lineJoin="miter"),void 0!==E[t].fillopacity&&(I.globalAlpha=1)}}function E(){this.bbox=new t,this.colors={},this.metadata={},this.octagonAnchor={x:50,y:50},this.options={},this.options.quantity="",this.options.reinforcedReduced="",this.options.staffComments="",this.options.additionalInformation="",this.options.evaluationRating="",this.options.combatEffectiveness="",this.options.signatureEquipment="",this.options.higherFormation="",this.options.hostile="",this.options.iffSif="",this.options.direction="",this.options.sigint="",this.options.uniqueDesignation="",this.options.type="",this.options.dtg="",this.options.altitudeDepth="",this.options.location="",this.options.speed="",this.options.speedLeader=0,this.options.specialHeadquarters="",this.options.country="",this.options.platformType="",this.options.equipmentTeardownTime="",this.options.commonIdentifier="",this.options.auxiliaryEquipmentIndicator="",this.options.headquartersElement="",this.options.installationComposition="",this.options.engagementBar="",this.options.engagementType="",this.options.guardedUnit="",this.options.specialDesignator="",this.style={},this.style.alternateMedal=!1,this.style.civilianColor=!0,this.style.colorMode="Light",this.style.fill=!0,this.style.fillColor="",this.style.fillOpacity=1,this.style.fontfamily="Arial",this.style.frame=!0,this.style.frameColor="",this.style.hqStaffLength=0,this.style.icon=!0,this.style.iconColor="",this.style.infoBackground="",this.style.infoBackgroundFrame="",this.style.infoColor="",this.style.infoFields=!0,this.style.infoOutlineColor="rgb(239, 239, 239)",this.style.infoOutlineWidth=!1,this.style.infoSize=40,this.style.monoColor="",this.style.outlineColor="rgb(239, 239, 239)",this.style.outlineWidth=0,this.style.padding=0,this.style.simpleStatusModifier=!1,this.style.size=100,this.style.square=!1,this.style.standard="",this.style.strokeWidth=4,this.symbolAnchor={x:50,y:50},this.validIcon=!0,0<arguments.length&&this.setOptions.apply(this,arguments)}function e(t,I,E){this.options.sidc=this.options.sidc.toUpperCase();var e=""!=this.options.sidc.charAt(0)?this.options.sidc.charAt(0):"-",R=""!=this.options.sidc.charAt(1)?this.options.sidc.charAt(1):"-",C=""!=this.options.sidc.charAt(2)?this.options.sidc.charAt(2):"-",A=""!=this.options.sidc.charAt(3)?this.options.sidc.charAt(3):"-",T=I.functionid=""!=this.options.sidc.substr(4,6)?this.options.sidc.substr(4,6):"------",S=""!=this.options.sidc.charAt(10)?this.options.sidc.charAt(10):"-",N=""!=this.options.sidc.charAt(11)?this.options.sidc.charAt(11):"-";if(-1<["H","S","J","K"].indexOf(R)&&(I.affiliation=E.affiliation[0]),-1<["F","A","D","M"].indexOf(R)&&(I.affiliation=E.affiliation[1]),-1<["N","L"].indexOf(R)&&(I.affiliation=E.affiliation[2]),-1<["P","U","G","W","O"].indexOf(R)&&(I.affiliation=E.affiliation[3]),-1<["P","A"].indexOf(C)&&(I.dimension=E.dimension[0]),-1<["G","Z","F","X"].indexOf(C)&&(I.dimension=E.dimension[1]),-1<["S"].indexOf(C)&&(I.dimension=E.dimension[2]),-1<["U"].indexOf(C)&&(I.dimension=E.dimension[3]),"P"==C&&"O"!=e&&(I.space=!0),"O"==e&&-1<["V","O","R"].indexOf(C)&&(I.activity=!0),"G"==e&&(I.controlMeasure=!0),"H"==S&&(I.installation=!0),this.style.frame&&"A"==A&&(I.notpresent=t._dashArrays.anticipated),this.style.frame&&-1<["P","A","S","G","M"].indexOf(R)&&(I.notpresent=t._dashArrays.pending),"C"==A&&(I.condition=E.status[2]),"D"==A&&(I.condition=E.status[3]),"X"==A&&(I.condition=E.status[4]),"F"==A&&(I.condition=E.status[5]),-1<["G","W","D","L","M","J","K"].indexOf(R)&&(I.context=E.context[1]),"O"==e&&(I.dimension=E.dimension[1]),"E"==e&&(I.dimension=E.dimension[1]),I.baseDimension=I.dimension,I.baseAffilation=I.affiliation,"J"==R&&(I.joker=!0),"K"==R&&(I.faker=!0),(I.joker||I.faker)&&(I.affiliation=E.affiliation[1]),"S"==e&&"G"==C&&"E"==T.charAt(0)&&(I.dimension=E.dimension[2]),"I"==e&&"G"==C&&(I.dimension=E.dimension[2]),"E"==e&&("O"==C&&-1<["AB----","AE----","AF----","BB----","CB----","CC----","DB----","DDB---","DEB---","DFB---","DGB---","DHB---","DIB---","DJB---","DLB---","DMB---","DOB---","EA----","EB----","EC----","ED----","EE----"].indexOf(T)||"F"==C&&-1<["BA----","MA----","MC----"].indexOf(T))&&(I.dimension=E.dimension[2]),(-1<["F","G","C","D"].indexOf(S)||"H"==S&&"B"==N)&&(I.feintDummy=!0),-1<["A","B","C","D"].indexOf(S)&&(I.headquarters=!0),"G"==C&&"UH----"==T&&(I.headquarters=!0),-1<["E","B","G","D"].indexOf(S)&&(I.taskForce=!0),"A"==N&&(I.echelon=E.echelonMobility[11]),"B"==N&&"H"!=S&&(I.echelon=E.echelonMobility[12]),"C"==N&&(I.echelon=E.echelonMobility[13]),"D"==N&&(I.echelon=E.echelonMobility[14]),"E"==N&&(I.echelon=E.echelonMobility[15]),"F"==N&&(I.echelon=E.echelonMobility[16]),"G"==N&&(I.echelon=E.echelonMobility[17]),"H"==N&&(I.echelon=E.echelonMobility[18]),"I"==N&&(I.echelon=E.echelonMobility[21]),"J"==N&&(I.echelon=E.echelonMobility[22]),"K"==N&&(I.echelon=E.echelonMobility[23]),"L"==N&&"N"!=S&&(I.echelon=E.echelonMobility[24]),"M"==N&&(I.echelon=E.echelonMobility[25]),"N"==N&&(I.echelon=E.echelonMobility[26]),"M"==S)switch(N){case"O":I.mobility=E.echelonMobility[31];break;case"P":I.mobility=E.echelonMobility[32];break;case"Q":I.mobility=E.echelonMobility[33];break;case"R":I.mobility=E.echelonMobility[34];break;case"S":I.mobility=E.echelonMobility[35];break;case"T":I.mobility=E.echelonMobility[36];break;case"U":I.mobility=E.echelonMobility[41];break;case"V":I.mobility=E.echelonMobility[42];break;case"W":I.mobility=E.echelonMobility[37];break;case"X":I.mobility=E.echelonMobility[51];break;case"Y":I.mobility=E.echelonMobility[52];break;default:I.mobility=void 0}if("N"==S)switch(N){case"S":I.mobility=E.echelonMobility[61];break;case"L":I.mobility=E.echelonMobility[62];break;default:I.mobility=void 0}return("A"==C&&"C"==T.charAt(0)||"G"==C&&"EVC"==T.substring(0,3)||"S"==C&&"X"==T.charAt(0))&&(I.civilian=!0),"Z"!=C&&"X"!=C||(-1<["P","U","F","N","H","A","S","G","W"].indexOf(R)&&(I.dimensionUnknown=!0),-1<["F","A"].indexOf(R)&&(I.dimension="Sea"),-1<["D","L","M","J","K"].indexOf(R)&&(I.affiliation="none")),"S"==C&&-1<["O-----","ED----","EP----","EV----","ZM----","ZN----","ZI----"].indexOf(T)&&(I.frame=!1),"E"==e&&"N"==C&&-1<["AA----","AB----","AC----","AD----","AE----","AG----","BB----","BC----","BF----","BM----","-C-----","CA----","CB----","CC----","CD----","CE----"].indexOf(T)&&(I.frame=!1),"W"==e&&"S"==C&&-1<["WSVE--","WSD-LI","WSFGSO","WSGRL-","WSR-LI","WSDSLM","WSS-LI","WSTMH-","WST-FC","WSTSS-"].indexOf(T)&&(I.frame=!1),"U"==C&&-1<["WM----","WMD---","WMG---","WMGD--","WMGX--","WMGE--","WMGC--","WMGR--","WMGO--","WMM---","WMMD--","WMMX--","WMME--","WMMC--","WMMR--","WMMO--","WMF---","WMFD--","WMFX--","WMFE--","WMFC--","WMFR--","WMFO--","WMO---","WMOD--","WMX---","WME---","WMA---","WMC---","WMR---","WMB---","WMBD--","WMN---","WMS---","WMSX--","WMSD--","WD----","WDM---","WDMG--","WDMM--","ND----","E-----","V-----","X-----","NBS---","NBR---","NBW---","NM----","NA----"].indexOf(T)&&(I.STD2525?(I.fill=!1,"WD----"==T&&(I.fill=!0),-1<["ND----","NBS---","NBR---","NBW---","NM----","NA----"].indexOf(T)&&(I.fill=!0,I.frame=!1)):(I.frame=!1,-1<["E-----","V-----","X-----"].indexOf(T)&&(I.fill=!1,I.frame=!1))),"WAS"!=this.options.sidc.substr(0,3)&&"WOS"!=this.options.sidc.substr(0,3)&&"G"!=e||(I.frame=!1),"G"==e&&"O"==C&&-1<["V","L","P","I"].indexOf(T.charAt(0))&&(I.frame=!0,I.dimension=E.dimension[1]),I}function R(t,I,E){var e={},R={};for(const C in t._iconSIDC.letter)t._iconSIDC.letter.hasOwnProperty(C)&&t._iconSIDC.letter[C].call(this,e,R,I,E);return{icons:e,bbox:R}}function s(t,I){if("object"==typeof t)if(Array.isArray(t))for(var E=0;E<t.length;E++)s.call(this,t[E],I);else t.icon=!0,"text"==t.type&&(t.hasOwnProperty("fontfamily")||(t.fontfamily="Arial"),t.hasOwnProperty("fontweight")||(t.fontweight="bold"),t.hasOwnProperty("textanchor")||(t.textanchor="middle"),t.hasOwnProperty("stroke")||(t.stroke=!1)),t.hasOwnProperty("fill")||(t.fill=I),t.hasOwnProperty("stroke")||(t.stroke=I),t.hasOwnProperty("strokewidth")||(t.strokewidth=3)}function a(t){let I=45;return 1==t.length&&(I=45),3==t.length&&(I=39),{type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:100,y:103,fontsize:I=4<=t.length?33:I,text:t}}function P(t){let I=28;return 3==t.length&&(I=25),{type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:100,y:71,fontsize:I=4<=t.length?22:I,text:t}}function r(t){let I=28;return 3==t.length&&(I=25),{type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:100,y:134,fontsize:I=4<=t.length?20:I,text:t}}function A(t,I,E,e,R,C){var A=I.affiliation||"Friend",T=I.frame,I=I.numberSIDC,S=E.iconColor[A],N=E.iconFillColor[A],O=E.none[A],A=E.black[A],i={"SP.I.ANTISATELLITE WEAPON":{type:"path",d:"m 100,110 v 9  m 0,-35 v 6  m 0,-9 -2,3 h 4 z  m -8,9 v 20 h 16 V 90 Z  m 26,0 v 20 h 26 V 90 Z  M 82,90 H 56 v 20 h 26 z  m 0,10 h 10  m 16,0 h 10"},"SP.I.ASTRONOMICAL SATELLITE":{type:"path",d:"m 97,90 -1,-9 h 8 l -1,9  m -5,20 1,9 h 2 l 1,-9  m 6,-10 h 10  m -36,0 H 92  M 82,90 H 56 v 20 h 26 z  m 36,0 v 20 h 26 V 90 Z  m -26,0 v 20 h 16 V 90 Z"},"SP.I.BIOSATELLITE":{type:"path",d:"m 98,88 c 0,3 -2.5,6 -6,6 -3.5,0 -6,-3 -6,-6 0,-4 2.5,-7 6,-7 3.5,0 6,3 6,7 z  m -6,11 v 20 h 16 V 99 Z  m 26,0 v 20 h 22 V 99 Z  M 82,99 H 60 v 20 h 22 z  m 0,10 h 10  m 16,0 h 10  M 96.192895,82.850539 115,94 114,96 98,87.5"},"SP.I.CAPSULE":{type:"path",d:"m 85,115 c -2,5 32,5 30,0 l -5,-30 c -1,-5 -19,-5 -20,0 z"}};i["SP.I.CIVILIAN ASTRONOMICAL SATELLITE"]={type:"path",fill:(e||!T)&&N,d:"m 97,90 -1,-9 h 8 l -1,9  m -5,20 1,9 h 2 l 1,-9  m 6,-10 h 10  m -36,0 H 92  M 82,90 H 56 v 20 h 26 z  m 36,0 v 20 h 26 V 90 Z  m -26,0 v 20 h 16 V 90 Z"},i["SP.I.CIVILIAN BIOSATELLITE"]={type:"path",fill:(e||!T)&&N,d:"m 98,88 c 0,3 -2.5,6 -6,6 -3.5,0 -6,-3 -6,-6 0,-4 2.5,-7 6,-7 3.5,0 6,3 6,7 z  m -6,11 v 20 h 16 V 99 Z  m 26,0 v 20 h 22 V 99 Z  M 82,99 H 60 v 20 h 22 z  m 0,10 h 10  m 16,0 h 10  M 96.192895,82.850539 115,94 114,96 98,87.5"},i["SP.I.CIVILIAN CAPSULE"]={type:"path",fill:(e||!T)&&N,d:"m 85,115 c -2,5 32,5 30,0 l -5,-30 c -1,-5 -19,-5 -20,0 z"},i["SP.I.CIVILIAN COMMUNICATIONS SATELLITE"]=[{type:"path",fill:(e||!T)&&N,d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"path",fill:!1,d:"m 100,90 0,9 M 75,81 c 16,12 34,12 50,0"}],i["SP.I.CIVILIAN EARTH OBSERVATION SATELLITE"]=[{type:"path",fill:(e||!T)&&N,d:"m 107,113 c 0,4 -3.1,7 -7,7 -3.9,0 -7,-3.1 -7,-7 0,-3.9 3.1,-7 7,-7 4,0 7,3.1 7,7 z  M 91.905742,81 92,97 h 16 l -0.0943,-16 z  M 117.90574,81 118,97 h 22 l -0.0943,-16 z  m -35.999998,0 h -22 L 60,97 H 82 Z  M 82,89 h 10  m 16,0 h 10"},{type:"path",fill:!1,d:"m 88,107 c 8,-9 16,-9 24,0"}],i["SP.I.CIVILIAN MINIATURIZED SATELLITE"]=[{type:"path",fill:(e||!T)&&N,d:"m 92,94 v 12 h 16 V 94 Z  m 26,0 v 12 h 14 V 94 Z  M 82,94 H 68 v 12 h 14 z  m 0,6 h 9.1  m 17,0 h 10"},{type:"path",fill:!1,d:"m 90,119 10,-9 10,9 m -20,-38 10,9 10,-9 m 35,9 -10,10 10,10 M 55,90 65,100 55,110"}],i["SP.I.CIVILIAN NAVIGATIONAL SATELLITE"]=[{type:"path",fill:(e||!T)&&N,d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"path",fill:!1,d:"m 88,87 c 8,6 16,6 24,0 m -20,8 8,-14 8,14"}],i["SP.I.CIVILIAN ORBITER SHUTTLE"]={type:"path",fill:(e||!T)&&N,d:"m 87,115 6,-24 c 3,-12 11,-12 14,0 l 6,24 h -12 l -1,5 -1,-5 z"},i["SP.I.CIVILIAN SATELLITE"]={type:"path",fill:(e||!T)&&N,d:"m 108,100 h 10  m -36,0 H 92  M 82,90 H 56 v 20 h 26 z  m 36,0 v 20 h 26 V 90 Z  m -26,0 v 20 h 16 V 90 Z"},i["SP.I.CIVILIAN SPACE STATION"]={type:"path",fill:(e||!T)&&N,d:"m 97.5,112.5 0,7.5 5,0 0,-7.5 z m 0,-32.5 5,0 0,26.4 -5,0 z m -0.3,7.6 C 83.3,88.2 72.5,93.5 72.5,100 c 0,6.9 12.3,12.5 27.5,12.5 15.2,0 27.5,-5.6 27.5,-12.5 0,-6.5 -11,-11.9 -25,-12.4 l 0,5.6 c 9.9,0.4 17.5,3.2 17.5,6.6 0,3.7 -8.9,6.7 -19.8,6.7 -10.9,0 -19.8,-3 -19.8,-6.7 0,-3.4 7.4,-6.1 17.1,-6.6 l 0,-5.6 c -0.1,0 -0.2,-0 -0.3,0 z"},i["SP.I.CIVILIAN SPACE VEHICLE"]=a("SV"),i["SP.I.CIVILIAN SPACE VEHICLE"].fill=(e||I||!T)&&N,i["SP.I.CIVILIAN SPACE VEHICLE"].stroke=A,i["SP.I.CIVILIAN SPACE VEHICLE"].strokewidth=3,i["SP.I.CIVILIAN TETHERED SATELLITE"]={type:"path",fill:(e||!T)&&N,d:"m 120,87 -20,12  m 33,-12 c 0,3.6 -2.9,6.5 -6.5,6.5 -3.6,0 -6.5,-2.9 -6.5,-6.5 0,-3.6 2.9,-6.5 6.5,-6.5 3.6,0 6.5,2.9 6.5,6.5 z  m -25,22 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},i["SP.I.CIVILIAN WEATHER SATELLITE"]=[{type:"path",fill:(e||!T)&&N,d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:92,fontsize:22,text:"WX"}],i["SP.I.CIVILIAN"]=a("CIV"),i["SP.I.CIVILIAN"].fill=(e||I||!T)&&N,i["SP.I.CIVILIAN"].stroke=A,i["SP.I.CIVILIAN"].strokewidth=3,i["SP.I.COMMUNICATIONS SATELLITE"]=[{type:"path",d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"path",fill:!1,d:"m 100,90 0,9 M 75,81 c 16,12 34,12 50,0"}],i["SP.M1.CYBERSPACE"]=P("CYB"),i["SP.M2.CYBERSPACE"]=r("CYB"),i["SP.I.EARTH OBSERVATION SATELLITE"]=[{type:"path",d:"m 107,113 c 0,4 -3.1,7 -7,7 -3.9,0 -7,-3.1 -7,-7 0,-3.9 3.1,-7 7,-7 4,0 7,3.1 7,7 z  M 91.905742,81 92,97 h 16 l -0.0943,-16 z  M 117.90574,81 118,97 h 22 l -0.0943,-16 z  m -35.999998,0 h -22 L 60,97 H 82 Z  M 82,89 h 10  m 16,0 h 10"},{type:"path",fill:!1,d:"m 88,107 c 8,-9 16,-9 24,0"}],i["SP.I.FF.CREWED SPACE VEHICLE"]={type:"path",stroke:!1,d:"m 100.3,62.4 c -1.8,-0 -4.3,3.7 -4.5,5.4 -2.5,11.3 -3.4,23.1 -6.2,33.4 -2.9,6.7 -6.8,8.3 -9.9,12.1 -3,3.6 -8.5,10.4 -8.5,10.4 l 0,6.4 c 0,0 5.9,0.9 8.9,1.2 3,0.2 8.7,0.1 8.7,0.1 l 0.3,4.3 4.3,0.2 0.2,3.1 5.8,0 0.9,6.5 0.9,-6.4 5.8,0 0.2,-3.1 4.3,-0.2 0.3,-4.3 c 0,0 5.7,0.1 8.7,-0.1 3,-0.2 8.9,-1.2 8.9,-1.2 l 0,-6.4 c 0,0 -5.5,-6.7 -8.5,-10.3 -3.1,-3.8 -7,-5.4 -9.9,-12.1 -2.8,-10.4 -3.7,-22.2 -6.2,-33.4 -0.3,-2.9 -2.7,-5.5 -4.5,-5.5 z"},i["SP.I.FF.SATELLITE"]=[{type:"path",stroke:!1,d:"m 115,70 20,0 0,55 -20,0 z m -25,5 20,0 0,45 -20,0 z m -25,-5 20,0 0,55 -20,0 z"},{type:"path",fill:!1,d:"M80,135 c10,-10 30,-10 40,0 M100,127 L100,100 M70,100 L130,100"}],i["SP.I.FF.SPACE STATION"]=[{type:"path",d:"m 103.1,97.4 c -12.4,0.3 -25.7,0.1 -36.7,6.7 -4.1,2.1 -8.5,5.9 -7.8,11 0.2,3.7 0.3,7.4 0.5,11.1 6.2,7.8 16.6,10.4 26,11.8 14,1.8 28.5,1.2 42.1,-3 5.2,-1.7 10.4,-4.3 14.2,-8.3 0.3,-5.1 -0.3,-10.4 0.7,-15.3 -1.2,-4.3 -5.9,-6.4 -9.7,-8.2 -9.2,-4 -19.3,-5.4 -29.2,-5.6 z m -3.2,9.6 c 10.1,-0.2 20.5,1.9 29.1,7.4 -13,8.4 -29.6,9.7 -44.3,6.1 -4.9,-1.3 -9.7,-3.3 -13.7,-6.4 8.8,-4.9 18.9,-6.9 28.9,-7.2 z",fill:e?N:O},{type:"path",fill:!1,stroke:"black",d:"m 96.9,107 c 0.7,-8.1 1.4,-16.3 2.1,-24.4 M 89.3,121.8 c 3.1,-13.2 6.2,-26.3 9.3,-39.5 4.9,12.7 9.7,25.5 14.6,38.2 m 27.8,-5.3 c -0.1,3.9 -0.2,7.8 -0.3,11.6 M 58.6,113.3 c 0.2,4.5 0.3,9 0.5,13.5 m -0.5,-1.2 c 3.5,6.3 11,8.6 17.6,10.5 16.4,4.1 33.9,3.9 50.1,-0.8 5.5,-1.8 11.8,-4.3 14.7,-9.7 m 0.5,-13 c -0.5,5.4 -6.1,8.1 -10.5,10 -15.4,5.7 -32.4,6.1 -48.5,3.6 -7.9,-1.4 -16.3,-3.4 -22.2,-9.2 -3.6,-3.9 -0.9,-9.6 3.4,-11.7 8.3,-5.2 18.3,-6.6 27.9,-7.5 13.5,-1 27.5,0 40.2,5.1 4.2,1.8 9.3,4.6 9.7,9.7 z m -13.3,1.6 c -8.2,-5.9 -18.8,-6.8 -28.6,-7 -9.5,0.1 -19.5,1.2 -27.6,6.4 l -0.6,0.5 m 58.9,-2.6 c -0.8,4.8 -6.1,6.4 -10,7.8 -13.2,3.7 -27.4,3.7 -40.5,-0 -3.8,-1.2 -8.1,-2.8 -9.8,-6.7 -0.7,-4.9 5,-7.1 8.7,-8.5 12.7,-4 26.6,-4 39.5,-1 4.4,1.2 9.8,2.8 11.9,7.3 l 0.1,0.5 0,0.5 z"},{type:"path",fill:"black",stroke:!1,d:"M 75.2,93.1 C 88.9,87 102.6,80.8 116.3,74.7 c 2.3,1.3 4.7,2.6 7,3.9 -13.7,6 -27.3,12 -41,18 -2.4,-1.2 -4.8,-2.3 -7.2,-3.5 z"}],i["SP.I.MANUAL TRACK"]=a("MAN"),i["SP.I.MILITARY"]=a("MIL"),i["SP.I.MINIATURIZED SATELLITE"]=[{type:"path",d:"m 92,94 v 12 h 16 V 94 Z  m 26,0 v 12 h 14 V 94 Z  M 82,94 H 68 v 12 h 14 z  m 0,6 h 9.1  m 17,0 h 10"},{type:"path",fill:!1,d:"m 90,119 10,-9 10,9 m -20,-38 10,9 10,-9 m 35,9 -10,10 10,10 M 55,90 65,100 55,110"}],i["SP.I.NAVIGATIONAL SATELLITE"]=[{type:"path",d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"path",fill:!1,d:"m 88,87 c 8,6 16,6 24,0 m -20,8 8,-14 8,14"}],i["SP.I.ORBITER SHUTTLE"]={type:"path",d:"m 87,115 6,-24 c 3,-12 11,-12 14,0 l 6,24 h -12 l -1,5 -1,-5 z"},i["SP.I.PLANETARY LANDER"]=a("PL"),i["SP.I.PLANETARY LANDER"].fill=(e||I||!T)&&N,i["SP.I.PLANETARY LANDER"].stroke=A,i["SP.I.PLANETARY LANDER"].strokewidth=3,i["SP.I.RE-ENTRY VEHICLE"]=a("RV"),i["SP.I.RECONNAISSANCE SATELLITE"]={type:"path",d:"m 106,100 9,20  m -21,-20 -9,20  m 17,-20 3,20  m -7,-20 -3,20  m 13,-30 h 10  M 82,90 H 92  M 82,81 H 60 v 19 h 22 z  m 36,0 v 19 h 22 V 81 Z  m -26,0 v 19 h 16 V 81 Z"},i["SP.I.SATELLITE, GENERAL"]=a("SAT"),i["SP.I.SATELLITE"]={type:"path",d:"m 108,100 h 10  m -36,0 H 92  M 82,90 H 56 v 20 h 26 z  m 36,0 v 20 h 26 V 90 Z  m -26,0 v 20 h 16 V 90 Z"},i["SP.I.SPACE LAUNCH VEHICLE"]=a("SLV"),i["SP.I.SPACE STATION"]={type:"path",d:"m 97.5,112.5 0,7.5 5,0 0,-7.5 z m 0,-32.5 5,0 0,26.4 -5,0 z m -0.3,7.6 C 83.3,88.2 72.5,93.5 72.5,100 c 0,6.9 12.3,12.5 27.5,12.5 15.2,0 27.5,-5.6 27.5,-12.5 0,-6.5 -11,-11.9 -25,-12.4 l 0,5.6 c 9.9,0.4 17.5,3.2 17.5,6.6 0,3.7 -8.9,6.7 -19.8,6.7 -10.9,0 -19.8,-3 -19.8,-6.7 0,-3.4 7.4,-6.1 17.1,-6.6 l 0,-5.6 c -0.1,0 -0.2,-0 -0.3,0 z"},i["SP.I.SPACE VEHICLE"]=a("SV"),i["SP.I.TETHERED SATELLITE"]={type:"path",d:"m 120,87 -20,12  m 33,-12 c 0,3.6 -2.9,6.5 -6.5,6.5 -3.6,0 -6.5,-2.9 -6.5,-6.5 0,-3.6 2.9,-6.5 6.5,-6.5 3.6,0 6.5,2.9 6.5,6.5 z  m -25,22 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},i["SP.I.WEATHER SATELLITE"]=[{type:"path",d:"m 108,109 h 10  m -36,0 H 92  M 82,99 H 60 v 20 h 22 z  m 36,0 v 20 h 22 V 99 Z  m -26,0 v 20 h 16 V 99 Z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:92,fontsize:22,text:"WX"}],i["SP.M1.GEOSTATIONARY ORBIT (GO)"]=P("GO"),i["SP.M1.GEOSYNCHRONOUS ORBIT (GSO)"]=P("GSO"),i["SP.M1.HIGH EARTH ORBIT (HEO)"]=P("HEO"),i["SP.M1.LOW EARTH ORBIT (LEO)"]=P("LEO"),i["SP.M1.MEDIUM EARTH ORBIT (MEO)"]=P("MEO"),i["SP.M1.MOLNIYA ORBIT (MO)"]=P("MO"),i["SP.M2.HIGH POWER MICROWAVE"]=r("HPM"),i["SP.M2.INFRARED"]=r("IR"),i["SP.M2.LASER"]={type:"path",fill:!1,d:"m 130,129 h -17 l -3,7 -3,-13 -4,13 -3.1,-13 -3.4,6 h -9.9 l -3.3,7 -3.3,-13 -3.3,13 -3.3,-13 -3.3,13  m 52.9,-13 7,6 -7,7"},i["SP.M2.MAINTENANCE"]={type:"path",fill:!1,d:"M75,125 c8,0 8,16 0,16 m8,-8 l35,0 m8,-8 c-8,0 -8,16 0,16"},i["SP.M2.MINE"]={type:"path",d:"m 111,133 c 0,4 -5,6 -11,6 -6.3,0 -11.4,-2 -11.4,-6 0,-2 5.1,-5 11.4,-5 6,0 11,3 11,5 z  m -2,-11 -17.5,23  m 0,-23 17.5,23  m -9,-23 v 23"},i["SP.M2.OPTICAL"]=r("O"),i["SP.M2.RADAR"]=r("R"),i["SP.M2.REFUEL"]=r("K"),i["SP.M2.SIGNALS INTELLIGENCE (SIGINT)"]=r("SI"),i["SP.M2.ELECTROMAGNETIC WARFARE (ASAT)"]=r("EW"),i["SP.M2.TUG"]=r("TUG"),i["SPACE.MISSILE.ICON"]={type:"path",d:"m 87,135 v -11 l 6,-5 V 65 l 7,-10 7,10 v 54 l 6,5 v 11 l -13,-10 z"},(e||I)&&(i["SPACE.MISSILE.ICON"].fill=(T?E.fillColor:E.iconFillColor).Unknown),i["SPACE.MISSILE.M1.BALLISTIC"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"B"},i["SPACE.MISSILE.M1.HYPERSONIC"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"H"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"V"}],i["SPACE.MISSILE.M1.INTERCEPTOR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"I"},i["SPACE.MISSILE.M1.SPACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"P"}],i["SPACE.MISSILE.M2.ARROW"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"A"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.GROUND-BASED INTERCEPTOR (GBI)"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"G"},i["SPACE.MISSILE.M2.INTERCONTINENTAL"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"I"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"C"}],i["SPACE.MISSILE.M2.INTERMEDIATE RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"I"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.LONG RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"L"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.MEDIUM RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"M"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.PATRIOT"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"P"},i["SPACE.MISSILE.M2.SHORT RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.SPACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"P"}],i["SPACE.MISSILE.M2.STANDARD MISSILE - 3 (SM-3)"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"3"}],i["SPACE.MISSILE.M2.STANDARD MISSILE - TERMINAL PHASE (SM-T)"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"T"}],i["SPACE.MISSILE.M2.TERMINAL HIGH-ALTITUDE AREA DEFENSE (THAAD)"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"T"},i["SPACE.MISSILE.M2.CLOSE RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"C"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],i["SPACE.MISSILE.M2.DEBRIS"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"D"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"B"}],i["SPACE.MISSILE.M2.UNKNOWN"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"U"},i["SPACE.PLANET LANDER"]=a("PL");for(const M in i)i.hasOwnProperty(M)&&(t.hasOwnProperty(M)&&console.warn("Override of: "+M),s.call(this,i[M],S),t[M]=i[M])}L.setColorMode=function(t,I){return this._colorModes[t]={},this._colorModes[t].Hostile=I.Hostile,this._colorModes[t].Friend=I.Friend,this._colorModes[t].Neutral=I.Neutral,this._colorModes[t].Unknown=I.Unknown,this._colorModes[t].Civilian=I.Civilian,this._colorModes[t].Suspect=I.Suspect,this._colorModes[t]},L.addSymbolPart=function(t){var I;return"function"==typeof t&&-1==(I=L.getSymbolParts()).indexOf(t)&&L.setSymbolParts(I.concat(t)),L},L.getSymbolParts=function(){return this._symbolParts.slice(0)},L.setSymbolParts=function(t){return this._symbolParts=t,L},L.reset=function(){this._brokenPath2D=void 0,this._colorModes={};for(const t in B)L.setColorMode(t,B[t]);this._dashArrays={pending:"4,4",anticipated:"8,12",feintDummy:"8,8"},this._getIcons={},this._getMetadata={},this._hqStaffLength=100,this._iconCache={},this._iconParts=[],this._labelCache={},this._labelOverrides={},this._iconSIDC={},this._iconSIDC.letter=[],this._iconSIDC.number=[],this._STD2525=!0,this._svgNS="http://www.w3.org/2000/svg",this._symbolParts=[],L.addSymbolPart(k),L.addSymbolPart(Y),L.addSymbolPart(W),L.addSymbolPart(v),L.addSymbolPart(g),L.addSymbolPart(u),L.addSymbolPart(b),L.addSymbolPart(K)},L.reset(),L.BBox=t,L.ColorMode=function(t,I,E,e,R,C){var A={};return A.Civilian=t,A.Friend=I,A.Hostile=E,A.Neutral=e,A.Unknown=R,A.Suspect=C,A},L.setBrokenPath2D=function(t){L._brokenPath2D=t},L._getIconParts=function(t,I,E,e,R){var C={};for(const A in this._iconParts)this._iconParts.hasOwnProperty(A)&&this._iconParts[A].call(this,C,t,I,E,e,R);return C},L._scale=function(t,I,E){return E&&function I(t,E){Array.isArray(t)?t.forEach(t=>{t.non_scaling_stroke=1/E,t.hasOwnProperty("draw")&&I(t.draw,E),Array.isArray(t)&&t.forEach(t=>{I(t,E)})}):t.non_scaling_stroke=1/E}(I,t),{type:"translate",x:100-100*t,y:100-100*t,draw:[{type:"scale",factor:t,draw:[I]}]}},L._translate=function(t,I,E){return{type:"translate",x:t,y:I,draw:[E]}},L.addIconParts=function(I){Array.isArray(I)||(I=[I]);for(let t=0;t<I.length;t++)"function"==typeof I[t]&&-1==this._iconParts.indexOf(I[t])&&(this._iconParts=this._iconParts.concat(I[t]));return L},L.addLabelOverrides=function(t,I){return this._labelCache={},"function"==typeof t&&(this._labelOverrides.hasOwnProperty(I)||(this._labelOverrides[I]=[]),this._labelOverrides[I]=this._labelOverrides[I].concat(t)),L},L.addIcons=function(I){this._iconCache={},Array.isArray(I)||(I=[I]);for(let t=0;t<I.length;t++)I[t].hasOwnProperty("getMetadata")&&(L._getMetadata[I[t].type]=I[t].getMetadata),I[t].hasOwnProperty("getIcons")&&(L._getIcons[I[t].type]=I[t].getIcons),I[t].hasOwnProperty("iconParts")&&L.addIconParts(I[t].iconParts),I[t].hasOwnProperty("labels")&&L.addLabelOverrides(I[t].labels,I[t].type),I[t].hasOwnProperty("icons")&&L.addSIDCicons(I[t].icons,I[t].type)},L.addSIDCicons=function(t,I){return"function"==typeof t&&-1==this._iconSIDC[I].indexOf(t)&&(this._iconSIDC[I]=this._iconSIDC[I].concat(t)),L},L.getColorMode=function(t){t=this._colorModes[t];return new L.ColorMode(t.Civilian,t.Friend,t.Hostile,t.Neutral,t.Unknown,t.Suspect)},L.getDashArrays=function(){return this._dashArrays},L.getHqStaffLength=function(){return this._hqStaffLength},L.getVersion=function(){return this.version},L.outline=function(t,I,E,e){return function t(I,E,e,R){let C;if(Array.isArray(I)){C=[];for(const A in I)C.push(t(I[A],E,e,R))}else{C={};for(const T in I)-1==["fill","fillopacity"].indexOf(T)&&(C[T]=I[T]);if("translate"==I.type||"rotate"==I.type||"scale"==I.type){C.draw=[];for(const S in I.draw)C.draw.push(t(I.draw[S],E,e,R))}else C.strokewidth=!1!==C.stroke?Number(C.strokewidth||e)+2*E:2*E,C.stroke=R,C.fill=!1,C.linecap="round"}return C}(t,I,E,e)},L.setDashArrays=function(t,I,E){return this._dashArrays.pending=t,this._dashArrays.anticipated=I,this._dashArrays.feintDummy=E,this._dashArrays},L.setHqStaffLength=function(t){return this._hqStaffLength=t,this._hqStaffLength},L.setStandard=function(t){return"2525"==t?this._STD2525=!0:"APP6"==t&&!(this._STD2525=!1)},L.showOctagon=function(){L.addSymbolPart(X)},L._symbolGeometries=I,E.prototype.asCanvas=function(t){void 0===L._brokenPath2D&&("undefined"==typeof Path2D?L.setBrokenPath2D(!0):((I=document.createElement("canvas")).widht=1,I.height=1,I=I.getContext("2d"),E=new Path2D("M0 0 h 10 v 10 h -10 Z"),I.fill(E),E=I.getImageData(0,0,1,1).data.join(),L.setBrokenPath2D(!("0,0,0,255"==E))));var I=document.createElement("canvas"),E=(I.width=this.width*(t=t||1),I.height=this.height*t,I.getContext("2d"));return E.scale(t*this.style.size/100,t*this.style.size/100),E.translate(-(this.bbox.x1-this.style.strokeWidth-this.style.outlineWidth),-(this.bbox.y1-this.style.strokeWidth-this.style.outlineWidth)),this.canvasDraw.call(this,E,this.drawInstructions),I},E.prototype.asOffscreenCanvas=function(t){void 0===L._brokenPath2D&&("undefined"==typeof Path2D?L.setBrokenPath2D(!0):(I=new OffscreenCanvas(1,1).getContext("2d"),E=new Path2D("M0 0 h 10 v 10 h -10 Z"),I.fill(E),E=I.getImageData(0,0,1,1).data.join(),L.setBrokenPath2D(!("0,0,0,255"==E)))),t=t||1;var I=new OffscreenCanvas(this.width*t,this.height*t),E=I.getContext("2d");return E.scale(t*this.style.size/100,t*this.style.size/100),E.translate(-(this.bbox.x1-this.style.strokeWidth-this.style.outlineWidth),-(this.bbox.y1-this.style.strokeWidth-this.style.outlineWidth)),this.canvasDraw.call(this,E,this.drawInstructions),I},E.prototype.canvasDraw=C,E.prototype.asDOM=function(){var t=document,I=(new DOMParser).parseFromString(this.asSVG(),"text/xml");return t.adoptNode(I.documentElement)},E.prototype.asSVG=function(){function R(E){let e="";for(let I=0;I<E.length;I++)if(Array.isArray(E[I]))E[I].length&&(e+=R.call(this,E[I]));else if("object"==typeof E[I]){let t="";if("svg"==E[I].type)t+=E[I].svg;else{switch(E[I].hasOwnProperty("clipPath")&&(t=(t+='<clipPath id="clip">')+'<path d="'+E[I].clipPath+'" clip-rule="nonzero" /></clipPath>'),E[I].type){case"path":t+='<path d="'+E[I].d+'" ',E[I].hasOwnProperty("clipPath")&&(t+='clip-path="url(#clip)" ');break;case"circle":t+='<circle cx="'+E[I].cx+'" cy="'+E[I].cy+'" r="'+E[I].r+'" ',E[I].hasOwnProperty("clipPath")&&(t+='clip-path="url(#clip)" ');break;case"text":t+='<text x="'+E[I].x+'" y="'+E[I].y+'" text-anchor="'+E[I].textanchor+'" font-size="'+E[I].fontsize+'" font-family="'+E[I].fontfamily+'" ',E[I].fontweight&&(t+='font-weight="'+E[I].fontweight+'" '),E[I].alignmentBaseline&&(t+='dominant-baseline="'+E[I].alignmentBaseline+'" ');break;case"translate":t+='<g transform="translate('+E[I].x+","+E[I].y+')" ';break;case"rotate":t+='<g transform="rotate('+E[I].degree+","+E[I].x+","+E[I].y+')" ';break;case"scale":t+='<g transform="scale('+E[I].factor+')" '}switch(void 0!==E[I].stroke&&(t+='stroke-width="'+(E[I].non_scaling_stroke||1)*(E[I].strokewidth||this.style.strokeWidth)+'" ',E[I].strokedasharray&&(t+='stroke-dasharray="'+E[I].strokedasharray+'" '),E[I].linecap&&(t=(t+='stroke-linecap="'+E[I].linecap+'" ')+'stroke-linejoin="'+E[I].linecap+'" '),E[I].stroke?t+='stroke="'+E[I].stroke+'" ':t+='stroke="none" '),void 0!==E[I].fill&&(t+='fill="'+(E[I].fill||"none")+'" '),void 0!==E[I].fillopacity&&(t+='fill-opacity="'+E[I].fillopacity+'" '),t+=">",E[I].type){case"path":t+="</path>";break;case"circle":t+="</circle>";break;case"text":t+=String(E[I].text).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")+"</text>";break;case"translate":case"rotate":case"scale":t=t+R.call(this,E[I].draw)+"</g>"}}e+=t}return e}var t='<svg xmlns="'+L._svgNS+'" version="1.2" baseProfile="tiny" width="'+this.width+'" height="'+this.height+'" viewBox="'+(this.bbox.x1-this.style.strokeWidth-this.style.outlineWidth)+" "+(this.bbox.y1-this.style.strokeWidth-this.style.outlineWidth)+" "+this.baseWidth+" "+this.baseHeight+'">';return t+=R.call(this,this.drawInstructions),this.XML=t+="</svg>"},E.prototype.getAnchor=function(){return this.symbolAnchor},E.prototype.getColors=function(){let t="object"==typeof this.style.colorMode?this.style.colorMode:L.getColorMode(this.style.colorMode);var I="object"==typeof this.style.frameColor?this.style.frameColor:L.getColorMode("FrameColor"),E="object"==typeof this.style.iconColor?this.style.iconColor:L.getColorMode("IconColor"),e=t;let R=L.getColorMode("Black"),C=L.getColorMode("White");var A=L.getColorMode("OffWhite"),T=L.getColorMode("None"),E=(this.style.civilianColor&&this.metadata.civilian&&(t.Friend=t.Neutral=t.Unknown=t.Civilian,I.Friend=I.Neutral=I.Unknown=I.Civilian,E.Friend=E.Neutral=E.Unknown=E.Civilian),(this.metadata.joker||this.metadata.faker)&&(t.Friend=t.Hostile,I.Friend=I.Hostile,E.Friend=E.Hostile),this.metadata.suspect&&(t.Friend=t.Hostile=t.Suspect,I.Friend=I.Hostile=I.Suspect,E.Friend=E.Hostile=E.Suspect),""!=this.style.monoColor&&(I.Friend=I.Neutral=I.Hostile=I.Unknown=I.Civilian=this.style.monoColor,R=I,C=t=T),{fillColor:t,frameColor:I,iconColor:E,iconFillColor:e,none:T,black:R,white:C});return this.metadata.frame?E.frameColor="object"==typeof this.style.frameColor?this.style.frameColor:R:E.frameColor=T,this.metadata.fill?(E.fillColor=this.metadata.frame||!this.metadata.frame&&!this.style.icon?t:T,E.iconColor="object"==typeof this.style.iconColor?this.style.iconColor:R,E.iconFillColor=this.metadata.frame?A:t,E.white=A):(E.fillColor=T,E.frameColor=this.metadata.frame?I:T,E.iconColor=I,E.iconFillColor=T,this.metadata.frame||this.metadata.fill||this.style.icon||(E.frameColor=R,E.fillColor=R)),E},E.prototype.getOctagonAnchor=function(){return this.octagonAnchor},E.prototype.getMetadata=function(){let t={activity:!1,affiliation:"undefined",baseAffilation:"",baseDimension:"",baseGeometry:{g:"",bbox:{}},civilian:!1,condition:"",context:"",dimension:"undefined",dimensionUnknown:!1,echelon:"",faker:!1,fenintDummy:!1,fill:this.style.fill,frame:this.style.frame,functionid:"",headquarters:!1,installation:!1,joker:!1,mobility:"",notpresent:"",numberSIDC:!1,space:!1,STD2525:L._STD2525,taskForce:!1,unit:!1};var I={context:["Reality","Exercise","Simulation"],status:["Present","Planned","FullyCapable","Damaged","Destroyed","FullToCapacity"],echelonMobility:{11:"Team/Crew",12:"Squad",13:"Section",14:"Platoon/detachment",15:"Company/battery/troop",16:"Battalion/squadron",17:"Regiment/group",18:"Brigade",21:"Division",22:"Corps/MEF",23:"Army",24:"Army Group/front",25:"Region/Theater",26:"Command",31:"Wheeled limited cross country",32:"Wheeled cross country",33:"Tracked",34:"Wheeled and tracked combination",35:"Towed",36:"Rail",37:"Pack animals",41:"Over snow (prime mover)",42:"Sled",51:"Barge",52:"Amphibious",61:"Short towed array",62:"Long towed Array",71:"Leader Individual",72:"Deputy Individual"},affiliation:["Hostile","Friend","Neutral","Unknown"],dimension:["Air","Ground","Sea","Subsurface"]};return t.context=I.context[0],this.style.standard&&(t.STD2525="APP6"!=this.style.standard),""!=this.style.monoColor&&(t.fill=!1),this.options.sidc=String(this.options.sidc).replace(/\*/g,"-").replace(/ /g,""),t.numberSIDC=!isNaN(this.options.sidc.substr(0,2)),t.numberSIDC?"function"==typeof L._getMetadata.number?t=L._getMetadata.number.call(this,L,t,I):console.warn("ms._getMetadata.number() is not present, you will need to load functionality for number based SIDCs"):"function"==typeof L._getMetadata.letter?t=L._getMetadata.letter.call(this,L,t,I):console.warn("ms._getMetadata.letter() is not present, you will need to load functionality for letter based SIDCs"),L._symbolGeometries.hasOwnProperty(t.dimension+t.affiliation)?t.baseGeometry=L._symbolGeometries[t.dimension+t.affiliation]:t.baseGeometry.bbox=new L.BBox,this.style.frame||this.style.icon||(t.baseGeometry=L._symbolGeometries.PositionMarker),t},E.prototype.getOptions=function(t){let I;var E={};for(I in this.options)this.options.hasOwnProperty(I)&&(E[I]=this.options[I]);if(t||void 0===t)for(I in this.style)this.style.hasOwnProperty(I)&&(E[I]=this.style[I]);return E},E.prototype.getSize=function(){return void 0!==this.width&&void 0!==this.height||this.updateSymbol(),{width:this.width,height:this.height}},E.prototype.getStyle=function(){let t;var I={};for(t in this.style)this.style.hasOwnProperty(t)&&(I[t]=this.style[t]);return I},E.prototype.isValid=function(t){var I=-1==JSON.stringify(this.drawInstructions).indexOf("null");return t?{affiliation:this.metadata.affiliation,dimension:this.metadata.dimension,dimensionUnknown:this.metadata.dimensionUnknown,drawInstructions:I,icon:this.validIcon,mobility:null!=this.metadata.mobility}:!("undefined"==this.metadata.affiliation||"undefined"==this.metadata.dimension&&!this.metadata.controlMeasure)&&I&&this.validIcon&&null!=this.metadata.mobility},E.prototype.setOptions=function(){let t;for(t=0;t<arguments.length;t++){var I=arguments[t];if("object"==typeof I)for(const T in I)I.hasOwnProperty(T)&&("SIDC"===T?this.options.sidc=I[T]:this.style.hasOwnProperty(T)?this.style[T]=I[T]:this.options[T]=I[T]);else this.options.sidc=I}for(t in this.validIcon=!0,this.metadata=this.getMetadata(),this.colors=this.getColors(),this.drawInstructions=[],this.bbox=new L.BBox,L._symbolParts)if(L._symbolParts.hasOwnProperty(t)){var E=L._symbolParts[t].call(this,L),e=0<E.pre.length||0<E.post.length;if(E.pre){if(0<E.pre.length){for(;1==E.pre.length;)E.pre=E.pre[0];0!=E.pre.length&&(this.drawInstructions=[].concat(E.pre,this.drawInstructions))}if(0<E.post.length){for(;1==E.post.length&&(E.post=E.post[0],void 0!==E.post););void 0!==E.post&&0==E.post.length||(this.drawInstructions=this.drawInstructions.concat(E.post))}"object"==typeof E.bbox&&e&&this.bbox.merge(E.bbox)}}this.style.padding&&(this.bbox.x1-=this.style.padding,this.bbox.x2+=this.style.padding,this.bbox.y1-=this.style.padding,this.bbox.y2+=this.style.padding);let R={x:100,y:100};var C,A;return this.octagonAnchor={x:(R.x-this.bbox.x1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100,y:(R.y-this.bbox.y1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100},this.metadata.headquarters&&(A=this.style.hqStaffLength||L._hqStaffLength,R={x:this.metadata.baseGeometry.bbox.x1,y:this.metadata.baseGeometry.bbox.y2+A}),this.style.square&&(A=Math.max(R.x-this.bbox.x1,this.bbox.x2-R.x),C=Math.max(R.y-this.bbox.y1,this.bbox.y2-R.y),A=Math.max(A,C),this.bbox.x1=R.x-A,this.bbox.y1=R.y-A,this.bbox.x2=R.x+A,this.bbox.y2=R.y+A),this.baseWidth=this.bbox.width()+Number(2*this.style.strokeWidth)+Number(2*this.style.outlineWidth),this.baseHeight=this.bbox.height()+Number(2*this.style.strokeWidth)+Number(2*this.style.outlineWidth),this.width=this.baseWidth*this.style.size/100,this.height=this.baseHeight*this.style.size/100,this.symbolAnchor={x:(R.x-this.bbox.x1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100,y:(R.y-this.bbox.y1+parseFloat(this.style.strokeWidth)+parseFloat(this.style.outlineWidth))*this.style.size/100},L._autoValidation&&!this.isValid()&&(console.warn("Error in symbol: "+this.options.sidc),console.warn(this.isValid(!0))),this},E.prototype.toDataURL=function(){return"data:image/svg+xml;utf8,"+encodeURIComponent(this.asSVG())},L.Symbol=E;I={type:"letter",getMetadata:e,getIcons:R,iconParts:[A],icons:function(t,I,E,e){t["S-P-------"]=[],t["S-P-S-----"]=[E["SP.I.FF.SATELLITE"]],t["S-P-V-----"]=[E["SP.I.FF.CREWED SPACE VEHICLE"]],t["S-P-T-----"]=[E["SP.I.FF.SPACE STATION"]],t["S-P-L-----"]=[E["SP.I.SPACE LAUNCH VEHICLE"]]}};function T(t,I,E,e,R,C){var A=I.frame,T=I.affiliation||"Friend",I=I.numberSIDC,S=E.iconColor[T],N=E.iconFillColor[T],T=E.black[T],O={};O["AR.I.MILITARY"]=a("MIL"),O["AR.I.CIVILIAN"]=a("CIV"),O["AR.I.CIVILIAN"].fill=(e||I||!A)&&N,O["AR.I.CIVILIAN"].stroke=T,O["AR.I.CIVILIAN"].strokewidth=3,O["AR.I.MILITARY FIXED WING"]={type:"path",d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},O["AR.I.CIVILIAN FIXED WING"]={type:"path",fill:!1,d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},O["AR.I.FF.CIVILIAN FIXED WING"]={type:"path",stroke:T,d:"M62,80 l30,0 0,-10 16,0 0,10 30,0 0,15 -30,0 0,25 10,0 0,5 -36,0 0,-5 10,0 0,-25 -30,0 Z M95,70 l0,-5 10,0 0,5",fill:!!e&&N},O["AR.I.MILITARY ROTARY WING"]={type:"path",d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},O["AR.I.CIVILIAN ROTARY WING"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},O["AR.I.FF.CIVILIAN ROTARY WING"]=[{type:"path",stroke:T,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:T,fill:!!e&&N,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"}],O["AR.I.MILITARY BALLOON"]=[{type:"circle",cx:100,cy:95,r:15},{type:"path",d:"M95,110 l0,10 10,0 0,-10 z"}],O["AR.I.FF.MILITARY BALLOON"]=[{type:"path",d:"M90,115 l20,0 0,20 -20,0 z"},{type:"circle",cx:100,cy:90,r:35}],O["AR.I.CIVILIAN BALLOON"]=[{type:"circle",fill:!(!e&&!I)&&N,stroke:T,cx:100,cy:95,r:15},{type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"M95,110 l0,10 10,0 0,-10 z"}],O["AR.I.FF.CIVILIAN BALLOON"]=[{type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"M90,125 l20,0 0,10 -20,0 z"},{type:"circle",fill:!(!e&&!I)&&N,stroke:T,cx:100,cy:90,r:35}],O["AR.I.MILITARY AIRSHIP"]={type:"path",d:"m 126,107 c -4,2 -10,3 -16,3 l 10,10 h 10 z  m -6,-27 -9,9.4 c 5,0.6 11,1.7 15,3.2 L 130,80 Z  m 15,20 c 0,6 -16,11 -35,11 -19.3,0 -35,-5 -35,-11 0,-6.1 15.7,-11.1 35,-11.1 19,0 35,5 35,11.1 z"},O["AR.I.CIVILIAN AIRSHIP"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"m 126,107 c -4,2 -10,3 -16,3 l 10,10 h 10 z  m -6,-27 -9,9.4 c 5,0.6 11,1.7 15,3.2 L 130,80 Z  m 15,20 c 0,6 -16,11 -35,11 -19.3,0 -35,-5 -35,-11 0,-6.1 15.7,-11.1 35,-11.1 19,0 35,5 35,11.1 z"},O["AR.I.CIVILIAN MEDICAL EVACUATION"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"M93,83 l14,0 0,10 10,0 0,14 -10,0 0,10 -14,0 0,-10 -10,0 0,-14 10,0 Z"},O["AR.I.UNMANNED AERIAL VEHICLE"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},O["AR.I.AIR DECOY"]={type:"path",d:"M65,95 l15,-15 0,30 Z M92.5,95 l15,-15 0,30 Z M120,95 l15,-15 0,30 Z M65,120 l70,0 0,-5 -70,0 Z"},O["SU.IC.AIR DECOY DSymbol"]={type:"path",d:"M 85 81 L 65 98 L 85 119 L 85 81 z M 110 81 L 90 98 L 110 119 L 110 81 z M 135 81 L 115 98 L 135 119 L 135 81 z"},O["AR.I.MEDICAL EVACUATION"]={type:"path",d:"M93,83 l14,0 0,10 10,0 0,14 -10,0 0,10 -14,0 0,-10 -10,0 0,-14 10,0 Z"},O["AR.I.ATTACK/STRIKE"]=a("A"),O["AR.I.BOMBER"]=a("B"),O["AR.I.CARGO"]=a("C"),O["AR.I.ESCORT"]=a("E"),O["AR.I.FIGHTER"]=a("F"),O["AR.I.FIGHTER INTERCEPTOR"]=a("I"),O["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]=a("J"),O["AR.I.TANKER"]=a("K"),O["AR.I.PATROL"]=a("P"),O["AR.I.RECONNAISSANCE"]=a("R"),O["AR.I.2525 PHOTOGRAPHIC"]=a("X"),O["AR.I.TRAINER"]=a("T"),O["AR.I.UTILITY"]=a("U"),O["AR.I.VSTOL"]=a(e&&!I?"L":"V"),O["AR.I.AIRBORNE COMMAND POST"]=a(e&&!I?"D":"ACP"),O["AR.I.AIRBORNE EARLY WARNING"]=a(e&&!I?"W":"AEW"),O["AR.I.ANTISURFACE WARFARE"]=a(e&&!I?"N":"ASUW"),O["AR.I.ANTISUBMARINE WARFARE"]=a(e&&!I?"S":"ASW"),O["AR.I.COMMUNICATIONS"]=a(e&&!I?"Y":"COM"),O["AR.I.COMBAT SEARCH AND RESCUE"]=a("CSAR"),O["AR.I.ELECTRONIC SUPPORT MEASURES"]=a(e?"Z":"ESM"),O["AR.I.GOVERNMENT"]=a("GOV"),O["AR.I.MINE COUNTERMEASURES"]=a("MCM"),O["AR.I.PERSONNEL RECOVERY"]=a(e?"H":"PRO"),O["AR.I.PASSENGER"]=a("PX"),O["AR.I.SEARCH AND RESCUE"]=a("SAR"),O["AR.I.SUPRESSION OF ENEMY AIR DEFENCE"]=a("SEAD"),O["AR.I.SPECIAL OPERATIONS FORCES"]=a("SOF"),O["AR.I.ULTRA LIGHT"]=a("UL"),O["AR.I.VIP"]=a("VIP"),O["AR.I.FF.MILITARY FIXED WING"]={type:"path",d:"m 99.2,58.2 c -3,0.8 -2.5,5.8 -2.5,5.8 l -0.3,16 -37.2,36.5 1.3,4.6 L 96.7,96.6 97,128.6 l -8.5,8.2 0,4.6 9.3,-4.2 c 0.7,0.6 1.8,1.7 1.8,1.7 0,0 1.2,-1.1 1.9,-1.7 l 9.3,4.2 0,-4.6 -8.5,-8.2 0.3,-32 36.2,24.5 1.3,-4.6 -37.2,-36.5 -0.3,-16 c 0,0 0.5,-5 -2.5,-5.8 -0.4,-0.1 -0.7,-0.1 -1.1,0 z",stroke:!1},O["AR.I.FIXED-WING DSymbol"]={type:"path",d:e?"M 99.4 80.8 C 97.9 81.1 98.1 83.4 98.1 83.4 L 98 90.7 L 78.6 107.4 L 79.3 109.4 L 98.1 98.3 L 98.3 112.9 L 93.9 116.6 L 93.9 118.7 L 98.8 116.8 C 99.1 117 99.7 117.5 99.7 117.5 C 99.7 117.5 100.4 117 100.7 116.8 L 105.6 118.7 L 105.6 116.6 L 101.1 112.9 L 101.3 98.3 L 120.2 109.4 L 120.9 107.4 L 101.5 90.7 L 101.3 83.4 C 101.3 83.4 101.6 81.1 100 80.8 C 99.8 80.8 99.6 80.8 99.4 80.8 z":"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},O["AR.I.CIVILIAN FIXED-WING DSymbol"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:e?"m 75.1,90.3 19.6,0 0,-6.5 10.5,0 0,6.5 19.6,0 0,9.7 -19.6,0 0,16.2 6.5,0 0,3.2 -23.6,0 0,-3.2 6.5,0 0,-16.2 -19.6,0 z m 21.6,-6.5 0,-3.2 6.5,0 0,3.2":"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},O["AR.I.FIGHTER/BOMBER"]=a("F/B"),O["AR.I.ELECTRONIC SUPPORT"]=a(e?"ES":"ESM"),O["AR.I.PERSONNEL RECOVERY DSymbol"]=a("PR"),O["AR.I.PHOTOGRAPHIC RECONNAISSANCE"]=a("PH"),O["AR.I.ELECTRONIC ATTACK (EA)"]=a("EA"),O["AR.I.VERTICAL-TAKEOFF UAV (VT-UAV)"]={type:"path",d:"m 70,84 30,14 30,-14 V 81 L 100,91 70,81 Z  m 0,9 30,15 30,-15 v 25 l -30,-10 -30,10 z"},O["AR.I.TETHERED LIGHTER THAN AIR"]={type:"path",d:"M 75,110 85,95 m -5,20 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m 15,-6 0,11 10,0 0,-11 m 10,-14 c 0,8.3 -6.7,15 -15,15 -8.3,0 -15,-6.7 -15,-15 0,-8.3 6.7,-15 15,-15 8.3,0 15,6.7 15,15 z"},O["AR.I.CIVILIAN TETHERED LIGHTER THAN AIR"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"M 75,110 85,95 m -5,20 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m 15,-6 0,11 10,0 0,-11 m 10,-14 c 0,8.3 -6.7,15 -15,15 -8.3,0 -15,-6.7 -15,-15 0,-8.3 6.7,-15 15,-15 8.3,0 15,6.7 15,15 z"},O["AR.I.CIVILIAN UNMANNED AERIAL VEHICLE"]={type:"path",fill:!(!e&&!I)&&N,stroke:T,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},O["AR.I.WEAPON"]=a("WPN"),O["AR.I.UNDERWATER DECOY DSymbol"]={type:"path",d:"M 86.6,82.8 68.7,100 86.6,117 Z  m 22.4,0 -18,17.2 18,17 z  m 23,0 -18,17.2 18,17 z"},O["AR.I.BOMB"]=a("BOMB"),O["AR.I.MANUAL TRACK"]=a("MAN"),O["AIR.M1.ATTACK"]=P("A"),O["AIR.M1.BOMBER"]=P("B"),O["AIR.M1.CARGO"]=P("C"),O["AIR.M1.FIGHTER"]=P("F"),O["AIR.M1.INTERCEPTOR"]=P("I"),O["AIR.M1.TANKER"]=P("K"),O["AIR.M1.UTILITY"]=P("U"),O["AIR.M1.VSTOL"]=P(e&&!I?"L":"V"),O["AIR.M1.PASSENGER"]=P("PX"),O["AIR.M1.ULTRA LIGHT"]=P("UL"),O["AIR.M1.AIRBORNE COMMAND POST"]=P(e&&!I?"D":"ACP"),O["AIR.M1.ANTISURFACE WARFARE"]=P(e&&!I?"N":"ASUW"),O["AIR.M1.AIRBORNE EARLY WARNING"]=P(e&&!I?"W":"AEW"),O["AIR.M1.GOVERNMENT"]=P("GOV"),O["AIR.M1.HYPERSONIC"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"H"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"V"}],O["AIR.M1.MEDEVAC"]={type:"path",stroke:!1,d:"M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},O["AIR.M1.ESCORT"]=P("E"),O["AIR.M1.INTENSIVE CARE"]=P("IC"),O["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]=P("J"),O["AIR.M1.PATROL"]=P("P"),O["AIR.M1.RECONNAISSANCE"]=P("R"),O["AIR.M1.TRAINER"]=P("T"),O["AIR.M1.PHOTOGRAPHIC"]=P(e&&!I?"X":"PH"),O["AIR.M1.PERSONNEL RECOVERY"]=P("PR"),O["AIR.M1.ANTISUBMARINE WARFARE"]=P(e&&!I?"S":"ASW"),O["AIR.M1.COMMUNICATIONS"]=P(e&&!I?"Y":"COM"),O["AIR.M1.ELECTRONIC SURVEILLANCE MEASURES"]=P(e?"Z":"ESM"),O["AIR.M1.MINE COUNTERMEASURES"]=P("MCM"),O["AIR.M1.SEARCH AND RESCUE"]=P("SAR"),O["AIR.M1.SPECIAL OPERATIONS FORCES"]=P("SOF"),O["AIR.M1.SURFACE WARFARE"]=P("SUW"),O["AIR.M1.VIP"]=P("VIP"),O["AIR.M1.COMBAT SEARCH AND RESCUE"]=P(e&&!I?"H":"CSAR"),O["AIR.M1.SUPRESSION OF ENEMY AIR DEFENCE"]=P("SEAD"),O["AIR.M1.UNMANNED AERIAL VEHICLE"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},O["AIR.M1.BOOM-ONLY"]=P("B"),O["AIR.M1.DROUGE-ONLY"]=P("D"),O["AIR.M1.ELECTRONIC SUPPORT (ES)"]=P(e?"ES":"ESM"),O["AIR.M1.HIJACKER"]=P("HJ"),O["AIR.M1.CYBERSPACE"]=P("CYB"),O["AIR.M1.FIGHTER/BOMBER"]=P("F/B"),O["AIR.M1.ELECTRONIC ATTACK (EA)"]=P("EA"),O["AIR.M1.MULTIMISSION"]=P("MM"),O["AIR.M1.HIJACKING"]=P("H"),O["AIR.M1.ASW HELO-LAMPS"]=P("LP"),O["AIR.M1.ASW HELO - SH-60R"]=P("60R"),O["AIR.M2.HEAVY"]=r("H"),O["AIR.M2.MEDIUM"]=r("M"),O["AIR.M2.LIGHT"]=r("L"),O["AIR.M2.BOOM-ONLY"]=r("B"),O["AIR.M2.DROUGE-ONLY"]=r("D"),O["AIR.M2.BOOM AND DROUGE"]=r("B/D"),O["AIR.M2.CLOSE RANGE"]=r("CR"),O["AIR.M2.SHORT RANGE"]=r("SR"),O["AIR.M2.MEDIUM RANGE"]=r("MR"),O["AIR.M2.LONG RANGE"]=r("LR"),O["AIR.M2.PHOTOGRAPHIC"]=r("P"),O["AIR.M2.CYBERSPACE"]=r("CYB"),O["AIR.M2.DOWNLINKED"]={type:"text",stroke:!1,x:100,y:140,fontsize:25,text:"DL"},O["AIR.MISSILE.ICON"]={type:"path",d:"m 87,135 v -11 l 6,-5 V 65 l 7,-10 7,10 v 54 l 6,5 v 11 l -13,-10 z"},(e||I)&&(O["AIR.MISSILE.ICON"].fill=(A?E.fillColor:E.iconFillColor).Unknown),O["AIR.MISSILE.IC.ANTIBALLISTIC MISSILE"]={type:"text",stroke:!1,x:100,y:110,fontsize:25,text:"ABM"},O["AIR.MISSILE.IC.BOMB"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:25,text:"BOMB"},O["AIR.MISSILE.M1.AIR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"A"},O["AIR.MISSILE.M1.SURFACE"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"S"},O["AIR.MISSILE.M1.SUBSURFACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"U"}],O["AIR.MISSILE.M1.SPACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"P"}],O["AIR.MISSILE.M1.ANTI-BALLISTIC"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:85,fontsize:30,text:"A"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:115,fontsize:30,text:"B"}],O["AIR.MISSILE.M1.BALLISTIC"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"B"},O["AIR.MISSILE.M1.CRUISE"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"C"},O["AIR.MISSILE.M1.LAND"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"L"},O["AIR.MISSILE.M1.INTERCEPTOR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:30,text:"I"},O["AIR.MISSILE.M2.AIR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"A"},O["AIR.MISSILE.M2.SURFACE"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"S"},O["AIR.MISSILE.M2.SUBSURFACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"U"}],O["AIR.MISSILE.M2.SPACE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"P"}],O["AIR.MISSILE.M2.LAUNCHED"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"L"},O["AIR.MISSILE.M2.MISSILE"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"M"},O["AIR.MISSILE.M2.PATRIOT"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"P"},O["AIR.MISSILE.M2.STANDARD MISSILE - 2 (SM-2)"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"2"}],O["AIR.MISSILE.M2.STANDARD MISSILE - 6 (SM-6)"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"6"}],O["AIR.MISSILE.M2.EVOLVED SEA SPARROW MISSILE (ESSM)"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"S"}],O["AIR.MISSILE.M2.ROLLING AIRFRAME MISSILE (RAM)"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:30,text:"R"},O["AIR.MISSILE.M2.SHORT RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],O["AIR.MISSILE.M2.MEDIUM RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"M"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],O["AIR.MISSILE.M2.INTERMEDIATE RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"I"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],O["AIR.MISSILE.M2.LONG RANGE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"L"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"R"}],O["AIR.MISSILE.M2.INTERCONTINENTAL"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:85,fontsize:30,text:"I"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:115,fontsize:30,text:"C"}];for(const i in O)O.hasOwnProperty(i)&&(t.hasOwnProperty(i)&&console.warn("Override of: "+i),s.call(this,O[i],S),t[i]=O[i])}var S={type:"letter",getMetadata:e,getIcons:R,iconParts:[T],icons:function(t,I,E,e){t["S-A-------"]=[],t["S-A-M-----"]=[E["AR.I.MILITARY"]],t["S-A-MF----"]=[E["AR.I.FF.MILITARY FIXED WING"]],t["S-A-MFB---"]=[E["AR.I.BOMBER"]],t["S-A-MFF---"]=[E["AR.I.FIGHTER"]],t["S-A-MFFI--"]=[E["AR.I.FIGHTER INTERCEPTOR"]],t["S-A-MFT---"]=[E["AR.I.TRAINER"]],t["S-A-MFA---"]=[E["AR.I.ATTACK/STRIKE"]],t["S-A-MFL---"]=[E["AR.I.VSTOL"]],t["S-A-MFK---"]=[E["AR.I.TANKER"]],t["S-A-MFKB--"]=[E["AR.I.TANKER"],E["AIR.M1.BOOM-ONLY"]],t["S-A-MFKD--"]=[E["AR.I.TANKER"],E["AIR.M1.DROUGE-ONLY"]],t["S-A-MFC---"]=[E["AR.I.CARGO"]],t["S-A-MFCL--"]=[E["AR.I.CARGO"],E["AIR.M2.LIGHT"]],t["S-A-MFCM--"]=[E["AR.I.CARGO"],E["AIR.M2.MEDIUM"]],t["S-A-MFCH--"]=[E["AR.I.CARGO"],E["AIR.M2.HEAVY"]],t["S-A-MFJ---"]=[E["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t["S-A-MFO---"]=[E["AR.I.MEDICAL EVACUATION"]],t["S-A-MFR---"]=[E["AR.I.RECONNAISSANCE"]],t["S-A-MFRW--"]=[E["AR.I.AIRBORNE EARLY WARNING"]],t["S-A-MFRZ--"]=[E["AR.I.ELECTRONIC SUPPORT MEASURES"]],t["S-A-MFRX--"]=e?[E["AR.I.2525 PHOTOGRAPHIC"]]:[E["AR.I.RECONNAISSANCE"],E["AIR.M2.PHOTOGRAPHIC"]],t["S-A-MFP---"]=[E["AR.I.PATROL"]],t["S-A-MFPN--"]=[E["AR.I.ANTISURFACE WARFARE"]],t["S-A-MFPM--"]=[E["AR.I.MINE COUNTERMEASURES"]],t["S-A-MFU---"]=[E["AR.I.UTILITY"]],t["S-A-MFUL--"]=[E["AR.I.UTILITY"],E["AIR.M2.LIGHT"]],t["S-A-MFUM--"]=[E["AR.I.UTILITY"],E["AIR.M2.MEDIUM"]],t["S-A-MFUH--"]=[E["AR.I.UTILITY"],E["AIR.M2.HEAVY"]],t["S-A-MFY---"]=[E["AR.I.COMMUNICATIONS"]],t["S-A-MFH---"]=[E["AR.I.PERSONNEL RECOVERY"]],t["S-A-MFD---"]=[E["AR.I.AIRBORNE COMMAND POST"]],t["S-A-MFQ---"]=[E["AR.I.UNMANNED AERIAL VEHICLE"]],t["S-A-MFQA--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ATTACK"]],t["S-A-MFQB--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.BOMBER"]],t["S-A-MFQC--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.CARGO"]],t["S-A-MFQD--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.AIRBORNE COMMAND POST"]],t["S-A-MFQF--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.FIGHTER"]],t["S-A-MFQH--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.COMBAT SEARCH AND RESCUE"]],t["S-A-MFQJ--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t["S-A-MFQK--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.TANKER"]],t["S-A-MFQL--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.VSTOL"]],t["S-A-MFQM--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-A-MFQI--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.MINE COUNTERMEASURES"]],t["S-A-MFQN--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ANTISURFACE WARFARE"]],t["S-A-MFQP--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.PATROL"]],t["S-A-MFQR--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.RECONNAISSANCE"]],t["S-A-MFQRW-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.AIRBORNE EARLY WARNING"]],t["S-A-MFQRZ-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ELECTRONIC SURVEILLANCE MEASURES"]],t["S-A-MFQRX-"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.PHOTOGRAPHIC"]],t["S-A-MFQS--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.ANTISUBMARINE WARFARE"]],t["S-A-MFQT--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.TRAINER"]],t["S-A-MFQU--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.UTILITY"]],t["S-A-MFQY--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.COMMUNICATIONS"]],t["S-A-MFQO--"]=[E["AR.I.UNMANNED AERIAL VEHICLE"],E["AIR.M1.MEDEVAC"]],t["S-A-MFS---"]=[E["AR.I.ANTISUBMARINE WARFARE"]],t["S-A-MFM---"]=[E["AR.I.SPECIAL OPERATIONS FORCES"]],t["S-A-MH----"]=[E["AR.I.MILITARY ROTARY WING"]],t["S-A-MHA---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.ATTACK"]],t["S-A-MHS---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.ANTISUBMARINE WARFARE"]],t["S-A-MHU---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"]],t["S-A-MHUL--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.LIGHT"]],t["S-A-MHUM--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.MEDIUM"]],t["S-A-MHUH--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UTILITY"],E["AIR.M2.HEAVY"]],t["S-A-MHI---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.MINE COUNTERMEASURES"]],t["S-A-MHH---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.COMBAT SEARCH AND RESCUE"]],t["S-A-MHR---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.RECONNAISSANCE"]],t["S-A-MHQ---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.UNMANNED AERIAL VEHICLE"]],t["S-A-MHC---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"]],t["S-A-MHCL--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.LIGHT"]],t["S-A-MHCM--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.MEDIUM"]],t["S-A-MHCH--"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.CARGO"],E["AIR.M2.HEAVY"]],t["S-A-MHT---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.TRAINER"]],t["S-A-MHO---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.MEDEVAC"]],t["S-A-MHM---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-A-MHD---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.AIRBORNE COMMAND POST"]],t["S-A-MHK---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.TANKER"]],t["S-A-MHJ---"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t["S-A-ML----"]=[E["AR.I.FF.MILITARY BALLOON"]],t["S-A-MV----"]=[E["AR.I.VIP"]],t["S-A-ME----"]=[E["AR.I.ESCORT"]],t["S-A-W-----"]=[E["AIR.MISSILE.ICON"]],t["S-A-WM----"]=[E["AIR.MISSILE.ICON"]],t["S-A-WMS---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.LAUNCHED"]],t["S-A-WMSS--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.SURFACE"]],t["S-A-WMSA--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.AIR"]],t["S-A-WMSU--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SURFACE"],E["AIR.MISSILE.M2.SUBSURFACE"]],t["S-A-WMSB--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.IC.ANTIBALLISTIC MISSILE"]],t["S-A-WMA---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.LAUNCHED"]],t["S-A-WMAS--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.SURFACE"]],t["S-A-WMAA--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.AIR"]],t["S-A-WMAP--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.AIR"],E["AIR.MISSILE.M2.SPACE"]],t["S-A-WMU---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.SUBSURFACE"],E["AIR.MISSILE.M2.SURFACE"]],t["S-A-WML---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.LAND"],E["AIR.MISSILE.M2.AIR"]],t["S-A-WMCM--"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.CRUISE"],E["AIR.MISSILE.M2.MISSILE"]],t["S-A-WMB---"]=[E["AIR.MISSILE.ICON"],E["AIR.MISSILE.M1.BALLISTIC"],E["AIR.MISSILE.M2.MISSILE"]],t["S-A-WB----"]=[E["AIR.MISSILE.IC.BOMB"]],t["S-A-WD----"]=[E["AR.I.AIR DECOY"]],t["S-A-C-----"]=[E["AR.I.CIVILIAN"]],t["S-A-CF----"]=[E["AR.I.FF.CIVILIAN FIXED WING"]],t["S-A-CH----"]=[E["AR.I.FF.CIVILIAN ROTARY WING"]],t["S-A-CL----"]=[E["AR.I.FF.CIVILIAN BALLOON"]]}};function N(t,I,E,e,R,C){var A=I.frame,T=I.affiliation||"Friend",S=I.baseGeometry,N=I.numberSIDC,O=E.iconColor[T],i=E.iconFillColor[T],M=E.black[T],G=E.white[T],o={};o["GR.IC.MILITARY"]=a("MIL"),o["GR.I.GOVERNMENT"]=a("GOV"),o["GR.IC.SUBMARINE NUCLEAR PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},o["GR.IC.FERRY"]=[{type:"path",fill:(e||!A)&&i,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:30,text:e?"FE":"F"}],o["GR.IC.ADMINISTRATIVE"]=a("ADM"),o["GR.IC.MANUAL TRACK"]=a("MAN"),o["GR.IC.AIR DEFENSE CHAPARRAL"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:95,fontsize:20,text:"C"}],o["GR.IC.AIR DEFENSE COMPOSITE"]={type:"path",d:"M85,120 C85,110 115,110 115,120 M90,115 L90,90 C90,80 110,80 110,90 L110,115 M100,112 l0,-30",fill:!1},o["GR.IC.AIR DEFENSE H/MAD"]=a("HMD"),o["GR.IC.AIR DEFENSE H/MAD HAWK"]={type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"H"},o["GR.IC.AIR DEFENSE H/MAD PATRIOT"]={type:"text",stroke:!1,x:100,y:101,fontsize:20,text:"P"},o["GR.IC.AIR DEFENSE MISSILE"]={type:"path",d:"M90,120 L90,90 C90,80 110,80 110,90 L110,120",fill:!1},o["GR.IC.FLOATING CRAFT"]={type:"path",d:"m 90,75 20,0 0,-10 -5,0 0,-10 -10,0 0,10 -5,0 z",stroke:!1},o["GR.IC.AIR AND MISSILE DEFENSE"]=a("MD"),o["GR.IC.MILITARY HISTORY"]=a("MH"),o["GR.IC.AIR DEFENSE TARGETING UNIT"]=[{type:"path",d:"M80,100 l20,-15 0,15 20,-15 M75,80 C75,100 85,115 105,115",fill:!1},{type:"circle",cx:75,cy:110,r:5}],o["GR.IC.AIR DEFENSE THEATER MISSILE DEFENSE UNIT"]=a("TMD"),o["GR.IC.AIR DEFENSE SHORT RANGE"]=a("SRD"),o["GR.IC.AIR DEFENSE STINGER"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:95,fontsize:20,text:"S"}],o["GR.IC.AIR DEFENSE VULCAN"]=[{type:"path",fill:!1,d:"m 85,80 30,0 c 5.54,0 10,4.46 10,10 l 0,5 c 0,5.54 -4.46,10 -10,10 l -30,0 c -5.54,0 -10,-4.46 -10,-10 l 0,-5 c 0,-5.54 4.46,-10 10,-10 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:95,fontsize:20,text:"V"}],o["GR.IC.AIR DEFENSE GUN UNIT"]={type:"path",d:"M100,80 L100,120 M92,90 l0,20 M108,90 l0,20",fill:!1},o["GR.IC.AIR TRAFFIC SERVICES"]={type:"path",d:"m 100,95 0,25 m 7.5,-32.5 c 0,4.1 -3.4,7.5 -7.5,7.5 -4.1,0 -7.5,-3.4 -7.5,-7.5 0,-4.1 3.4,-7.5 7.5,-7.5 4.1,0 7.5,3.4 7.5,7.5 z M 60,85 l 40,15 40,-15 0,30 -40,-15 -40,15 z"},o["GR.IC.AIRPORT OF DEBARKATION"]=[{type:"path",fill:!1,d:"M80,70 l40,0 M80,80 l25,-25 M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1}],o["GR.IC.ALLIED COMMAND EUROPE RAPID REACTION CORPS (ARRC)"]=a("ARRC"),o["GR.IC.ALLIED COMMAND OPERATIONS"]=a("ACO"),o["GR.IC.AMMUNITION"]={type:"path",d:"m 90,117 0,-25 c 0,-15 20,-15 20,0 l 0,25 m -25,0 30,0",fill:!1},o["GR.IC.ARMOUR"]={type:"path",d:"M125,80 C150,80 150,120 125,120 L75,120 C50,120 50,80 75,80 Z",fill:!1},o["GR.IC.ARMOR, WHEELED"]=[{type:"path",d:"m 120,80 c 25,0 25,30 0,30 l -40,0 C 55,110 55,80 80,80 Z",fill:!1},{type:"circle",cx:70,cy:115,r:5,fill:!1},{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"circle",cx:130,cy:115,r:5,fill:!1}],o["GR.IC.AVIATION ROTARY WING"]={type:"path",stroke:!1,d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z"},o["GR.IC.AVIATION ROTARY WING 2525C"]={type:"path",stroke:!1,d:"M100,100 L100,140"},o["GR.IC.AVIATION FIXED WING"]={type:"path",stroke:!1,d:"M100,100 L130,88 c15,0 15,24 0,24 L100,100 70,112 c-15,0 -15,-24 0,-24 Z"},o["GR.IC.COMBATANT"]=[{type:"path",d:"m 86.9,110 c -3.6,2 -7.2,3.9 -10.8,5.9 2.1,2.9 6.7,3.9 10,2.1 2.6,-0.9 4.7,-3.8 3.1,-6.1 -0.8,-0.6 -1.5,-1.3 -2.3,-1.9 z m 26.3,0.1 c 3.6,2 7.2,3.9 10.8,5.9 -2.1,2.9 -6.7,3.9 -10,2.1 -2.6,-0.9 -4.7,-3.8 -3.1,-6.1 0.8,-0.6 1.5,-1.3 2.3,-1.9 z",fill:!1},{type:"path",d:"m 112.9,110 c -5.6,-4 -11.3,-7.9 -16.1,-12.5 -4.2,-4.5 -7,-9.8 -9.2,-15.1 -0.8,4.4 -0.9,9.3 2.4,13.2 3.6,4.5 8.6,8.1 13.5,11.8 2.3,1.7 4.7,3.3 7.1,4.8 0.8,-0.7 1.5,-1.5 2.3,-2.2 m -25.7,0 c 5.6,-4 11.3,-7.9 16.1,-12.5 4.2,-4.5 7,-9.8 9.2,-15.1 0.8,4.4 0.9,9.3 -2.4,13.2 -3.6,4.5 -8.6,8.1 -13.5,11.8 -2.3,1.7 -4.7,3.3 -7.1,4.8 -0.8,-0.7 -1.5,-1.5 -2.3,-2.2",fill:G,strokewidth:2}],o["GR.IC.AVIATION COMPOSITE"]={type:"path",stroke:!1,d:"m 100,100 15.7,7.9 c 11.8,0 11.8,-15.7 0,-15.7 z m 0,0 -15.7,-7.9 c -11.8,0 -11.8,15.7 0,15.7 z m -10,-20 10,20 -10,20 20,0 -10,-20 10,-20 z"},o["GR.IC.AVIATION TACTICAL AIR CONTROL PARTY"]=a("TACP"),o["GR.IC.AVIATION FORWARD AIR CONTROLLER"]=a("FAC"),o["GR.IC.SPECIAL TROOPS"]=a("ST"),o["GR.IC.MULTI-DOMAIN"]={type:"path",d:"m 79.3,98.2 v -7 h 7.1  M 100,112 79.3,91.2  M 76,107 l -5,5 5,6  m 24,-6 H 71  m 53,-5 5,5 -5,6  m -24,-6 h 29  M 114,91.2 h 7 v 7.1  M 100,112 121,91.2  m -26,-3.8 5,-5 5,5  M 100,112 V 82.4",fill:!1},o["GR.IC.RANGER"]=a("RGR"),o["GR.IC.BAND"]=a("BAND"),o["GR.IC.ARMY MUSIC"]={type:"path",d:"m 99.6,110.5 c -4.8,-1.4 -10.9,2.2 -10.4,7.7 1,2.5 6.2,2.4 9.6,-0.2 1.9,-1.5 2.7,-3.8 2.3,-6.9 l -0.1,-21.3 c 12.7,5.8 7.6,14.8 5.6,20.7 4.7,-4.9 5.8,-13.2 1.5,-17.9 -4.4,-4.6 -5,-7 -8.4,-13 z",strokewidth:2},o["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]=a("ATF"),o["GR.IC.CBRN"]=[{type:"path",d:"m 74,120 c 0,-15 13.2,-32.9 65,-36  m -13,36 C 126,105 113,87.1 61.5,84",fill:!1},{type:"circle",cx:65,cy:90,r:6},{type:"circle",cx:135,cy:90,r:6}],o["GR.CHEMICAL, BIOLOGICAL, RADIOLOGICAL, NUCLEAR, AND HIGH-YIELD EXPLOSIVES"]=[{type:"path",d:"M 89.5,82 H 111 l 10,18 -10,18 H 89.5 L 79,100 Z",fill:i},{type:"text",stroke:!1,alignmentBaseline:"middle",textanchor:"middle",x:100,y:102,fontsize:25,text:"E"}],o["GR.IC.SPACE"]=[{type:"path",d:"M 97.5,104.2 92,108 96,102.5 85,100 96,98.53 92,93 98.09,96.98 100,80 102.5,96.98 109,93 l -5,5.53 11,1.47 -11,2.5 5,5.5 -6.5,-3.8 -2.5,15.8 z",stroke:!1}],o["GR.IC.CIVIL AFFAIRS"]=a("CA"),o["GR.IC.CIVIL-MILITARY-COOPERATION"]={type:"path",d:"m 65,85 h 69 v 15 c 0,20 -69,20 -69,0 z",fill:!1},o["GR.I.CIVILIAN"]=a("CIV"),o["GR.I.CIVILIAN"].fill=(e||N||!A)&&i,o["GR.I.CIVILIAN"].stroke=M,o["GR.I.CIVILIAN"].strokewidth=3,o["GR.IC.COMMAND AND CONTROL"]=a(""),o["GR.IC.COMBAT"]=a("CBT"),o["GR.IC.COMBAT SERVICE SUPPORT"]=a("CSS"),o["GR.IC.COMBAT SUPPORT"]=a("CS"),o["GR.IC.COMBAT SUPPORT (MANOEUVRE ENHANCEMENT)"]={type:"path",d:"m 85,80 0,25 15,15 15,-15 0,-25 z"},o["GR.IC.COMBINED ARMS"]={type:"path",d:"m 70,80 60,40 m 0,-40 -60,40 m 55,-40 c 25,0 25,40 0,40 l -50,0 C 50,120 50,80 75,80 z",fill:!1},o["GR.IC.COUNTER-INTELLIGENCE"]=a("CI"),o["GR.IC.CRIMINAL INVESTIGATION DIVISION"]=a("CID"),o["GR.IC.CYBER"]=a("CYB"),o["GR.IC.DIVING"]=[],o["GR.IC.DOG"]=a("DOG"),o["GR.IC.DRILLING"]={type:"path",d:"m 85,80 5,40 20,0 5,-40 z"},o["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]=a("DEA"),o["GR.IC.ELECTRONIC RANGING"]={type:"path",d:"M 108,117 C 86,129 65,93 86.7,80.7 Z  M 97.2,99.1 118,88.7",fill:!!e&&i},o["GR.IC.ELECTRONIC WARFARE"]=a("EW"),o["GR.IC.EMERGENCY MEDICAL OPERATION"]={type:"path",d:"m 90,60 0,22.7 -19.7,-11.3 -10,17.3 L 80,100 l -19.7,11.3 10,17.3 L 90,117.3 90,140 l 20,0 0,-22.7 19.7,11.3 10,-17.3 L 120,100 l 19.7,-11.3 -10,-17.3 L 110,82.7 110,60 90,60 z"},o["GR.IC.ENGINEER"]={type:"path",fill:!1,d:"M 60,118 V 83 h 80 v 35  M 100,83 V 110"},o["GR.IC.ENGINEER MECHANIZED"]={type:"path",fill:!1,d:"m 100,90 0,15 m -25,5 0,-20 50,0 0,20 m 0,-30 c 25,0 25,40 0,40 l -50,0 C 50,120 50,80 75,80 Z"},o["GR.IC.ENGINEER UTILITY VEHICLE"]={type:"path",fill:!1,d:"m 100,100 0,10 m -15,5 0,-15 30,0 0,15 M 70,80 c 0,15 60,15 60,0 l 0,40 -60,0 z"},o["GR.IC.ENVIRONMENTAL PROTECTION"]={type:"path",d:"m 100,80 -10,15 5,0 -10,10 5,0 -10,10 15,0 0,5 10,0 0,-5 15,0 -10,-10 5,0 -10,-10 5,0 z",fill:!1},o["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]=a("EOD"),o["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]=a("FBI"),o["GR.IC.FIELD ARTILLERY"]={type:"circle",cx:100,cy:100,r:15},o["GR.IC.FIELD ARTILLERY OBSERVER"]=[{type:"circle",cx:100,cy:108,r:5},{type:"path",d:"m 100,80 -25,40 50,0 z",fill:!1}],o["GR.IC.FIELD CAMP CONSTRUCTION"]=[o["GR.IC.ENGINEER"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:72,fontsize:25,text:"CAMP"}],o["GR.IC.FINANCE"]={type:"path",d:"m 80,95 10,-10 20,0 10,10 m -40,0 0,20 40,0 0,-20 z",fill:!1},o["GR.IC.FIRE PROTECTION"]={type:"path",d:"m 120,90 -5,5 -10,-10 5,-5 -20,0 5,5 -10,10 -5,-5 0,20 5,-5 10,10 -5,5 20,0 -5,-5 10,-10 5,5 z"},o["GR.IC.FIXED WING MISO"]=[{type:"path",fill:!!e&&i,stroke:M,d:"M70,85 l40,0 10,-10 0,50 -10,-10 -40,0 z M120,85 l10,0 M120,95 l10,0 M120,105 l10,0 M120,115 l10,0"},{type:"path",d:"M 78.8 61.5 C 68.1 61.5 68.1 78.5 78.8 78.5 L 100 70 L 78.8 61.5 z M 100 70 L 121.3 78.5 C 131.9 78.5 131.9 61.5 121.3 61.5 L 100 70 z"}],o["GR.IC.GEOSPATIAL SUPPORT"]=a("GEO"),o["GR.IC.GOVERNMENT ORGANIZATION"]=a("GO"),o["GR.IC.GRENADE"]={type:"path",d:"m 86,105 h 28  M 95,92 v -9 h 10 v 9  m 0,-5.3 a 19,19 0 0 1 14,18.3  m -5,0 A 14.3,14.3 0 0 1 99.9,119 14.3,14.3 0 0 1 85.6,105 14.3,14.3 0 0 1 99.9,90.7 14.3,14.3 0 0 1 114,105 Z",fill:!1},o["GR.IC.HUMAN RESOURCES"]=a("HR"),o["GR.IC.INFORMATION OPERATIONS"]=a(e&&!N?"IW":"IO"),o["GR.IC.INTERNATIONAL SECURITY ASSISTANCE FORCE (ISAF)"]=a("ISAF"),o["GR.IC.INTERROGATION"]=a("IPW"),o["GR.IC.ISOLATED PERSONNEL"]=[{type:"path",d:"M 100,100 88,88  m 12,12 12,-12  m -12,30 v -18  m -9.5,18 H 110",fill:!1},{type:"path",d:"m 106,87.2 a 5.92,5.92 0 0 1 -6,5.9 5.92,5.92 0 0 1 -5.9,-5.9 5.92,5.92 0 0 1 5.9,-6 5.92,5.92 0 0 1 6,6 z",stroke:!1}],o["GR.IC.JOINT FIRE SUPPORT"]=a("JFS"),o["GR.IC.JOINT INFORMATION BUREAU"]=a("JIB"),o["GR.IC.JOINT INTELLIGENCE CENTRE"]=a("JIC"),o["GR.IC.JUDGE ADVOCATE GENERAL"]=a("JAG"),o["GR.IC.LABOUR"]={type:"path",d:"m 90,85 20,0 m -10,0 0,25 -10,0 10,10 10,-10 -10,0",fill:!1},o["GR.IC.LAUNDRY/BATH"]={type:"path",d:"m 95,80 10,10 0,30 m 0,-30 -10,0 m 10,0 -10,10",fill:!1},o["GR.IC.LAW ENFORCEMENT"]={type:"path",d:"m 82,82 c 6,7 12,7 18,0 6,7 12,7 18,0  m 0,0 c -3,13 6,27 -18,36 C 76,109 85,95 82,82",fill:!1},o["GR.IC.LAW ENFORCEMENT VESSEL"]=[{type:"path",fill:(e||!A)&&i,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],o["GR.IC.LIAISON"]=a("LO"),o["GR.IC.MAINTENANCE"]={type:"path",d:"M70,90 c10,0 10,20 0,20 m10,-10 l40,0 m10,-10 c-10,0 -10,20 0,20",fill:!1},o["GR.IC.MATERIEL"]=a("MAT"),o["GR.IC.MEDICAL EVACUATION HELICOPTER"]={type:"path",d:"M60,85 l40,15 40,-15 0,30 -40,-15 -40,15 z M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},o["GR.IC.MESSENGER"]=a("M"),o["GR.IC.METEOROLOGICAL"]=a("MET"),o["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"]={type:"path",d:"M 83.7,89 H 106 l 8,-6.8 V 118 l -8,-8 H 83.7 Z  m 30.3,0.3 h 11  m -11,7.1 h 11  m -11,6.6 h 11  m -11,7 h 11"},o["GR.IC.MILITARY INTELLIGENCE"]=a("MI"),o["GR.IC.MILITARY POLICE"]=a("MP"),o["GR.IC.MINE"]={type:"path",d:"m 120,100 c 0,5.5 -9,10 -20,10 -11,0 -20,-4.5 -20,-10 0,-5.5 9,-10 20,-10 11,0 20,4.5 20,10 z m -5,-20 -30,40 m 0,-40 30,40 m -15,-40 0,40"},o["GR.IC.MINE CLEARING"]=[o["GR.IC.MINE"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:72,fontsize:25,text:"CLR"}],o["GR.IC.MINE LAUNCHING"]=[o["GR.IC.MINE"],{type:"path",d:"m 80,125 0,10 40,0 0,-10 z"}],o["GR.IC.MINE LAYING"]=[o["GR.IC.MINE"],{type:"path",d:"m 80,65 0,10 40,0 0,-10 z"}],o["GR.IC.MISSILE"]={type:"path",d:"M 100,82.62 V 120  M 90,120 V 90 c 0,-10 20,-10 20,0 v 30",fill:!1},o["GR.IC.MISSILE.LIGHT"]={type:"path",d:"M90,90 L110,90"},o["GR.IC.MISSILE.MEDIUM"]={type:"path",d:"M90,90 L110,90 M90,97 L110,97"},o["GR.IC.MISSILE.HEAVY"]={type:"path",d:"M90,90 L110,90 M90,97 L110,97 M90,104 L110,104"},o["GR.IC.MORALE, WELFARE, AND RECREATION"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"MWR"},o["GR.IC.MORTAR"]=[{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"path",d:"M100,111 l0,-30 M90,90 l10,-10 10,10",fill:!1}],o["GR.IC.MORTUARY AFFAIRS"]={type:"path",d:"m 70,85 h 60 v 30 H 70 Z  m 40,5 v 20  M 74.8,100 H 125",fill:!1},o["GR.IC.MULTINATIONAL (MN)"]=a("MN"),o["GR.IC.NAVAL"]=[{type:"path",d:"m 105,85 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -20,5 30,0 m -15,0 0,30",fill:!1},{type:"path",d:"m 114,110 -3,-2 7,-5 -1,9 -3,-2 c -8,12 -18.6,12 -28,0 l -3,2 -2,-10 8,6 -3,2 c 9.3,11 19,11 28,0 z"}],o["GR.IC.OBSERVER/OBSERVATION"]={type:"path",d:"m 100,80 -25,40 50,0 z",fill:!1},o["GR.IC.ORDNANCE"]={type:"path",d:"M 90,97 83,83 m 27,14 7,-14 M 95,95 90,81 m 15,14 5,-14 m 10,26.5 c 0,6.9 -9,12.5 -20,12.5 -11,0 -20,-5.6 -20,-12.5 0,-6.9 9,-12.5 20,-12.5 11,0 20,5.6 20,12.5 z",fill:!1},o["GR.IC.PERSONNEL SERVICES"]=a("PS"),o["GR.IC.PETROLEUM OIL LUBRICANTS"]={type:"path",d:"m 100,119 0,-24 m 0,0 C 99,95 85,81 85,81 l 30,0 z",fill:!1},o["GR.IC.PIPELINE"]={type:"path",d:"m 115,110 15,0 m -15,-15 15,0 m -45,15 -15,0 M 85,95 70,95 m 30,-15 0,10 -15,0 0,25 30,0 0,-25 -15,0 m -10,-10 20,0",fill:!1},o["GR.IC.POSTAL"]={type:"path",d:"m 80,80 30,0 c -1.4,15.5 0,25 10,35 -20,0 -40,-20 -40,-35 z",fill:!1},o["GR.IC.PUBLIC AFFAIRS"]=a("PA"),o["GR.IC.PUBLIC AFFAIRS BROADCAST"]=a("BPAD"),o["GR.IC.PSYCHOLOGICAL OPERATIONS"]={type:"path",fill:!!e&&i,stroke:M,d:"M70,85 l40,0 10,-10 0,50 -10,-10 -40,0 z M120,85 l10,0 M120,95 l10,0 M120,105 l10,0 M120,115 l10,0"},o["GR.IC.QUARTERMASTER"]={type:"path",fill:!1,d:"m 115,95 c 0,15 15,15 15,0 0,-15 -15,-15 -15,0 z m 0,0 -45,0 0,10 10,0 0,-10"},o["GR.IC.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},o["GR.IC.RADIO"]=[{type:"path",fill:!1,d:"M 100,108 V 82.5  m -12.5,4.1 4.1,-4.1 4.2,4.1 4.2,-4.1 4,4.1 4,-4.1 5,4.1  M 100,107 c -3.2,0 -5.9,3 -5.9,6 0,3 2.7,6 5.9,6 3,0 6,-3 6,-6 0,-3 -3,-6 -6,-6 z"}],o["GR.IC.RADIO RELAY"]=[{type:"path",fill:!1,d:"m 85,83 h 30  m -15,25 V 82.5  m 0,24.5 c -3.2,0 -5.9,3 -5.9,6 0,3 2.7,6 5.9,6 3,0 6,-3 6,-6 0,-3 -3,-6 -6,-6 z"}],o["GR.IC.RADIO TELETYPE CENTRE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:30,text:"C"},{type:"path",fill:!1,d:"M 100,120 V 82  M 85.8,82 H 114  M 90.5,86.7 H 109"}],o["GR.IC.RAILHEAD"]=[{type:"path",fill:!1,d:"M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1},L._translate(0,-50,[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:125,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}])],o["GR.IC.RELIGIOUS SUPPORT"]=a("REL"),o["GR.IC.REPLACEMENT HOLDING UNIT"]=a("RHU"),o["GR.IC.SEA-AIR-LAND"]=a("SEAL"),o["GR.IC.SUPPORT"]=a("SPT"),o["GR.IC.ARMY FIELD SUPPORT"]=a("AFS"),o["GR.IC.CONTRACTING SERVICES"]=a("KS"),o["GR.IC.SEAPORT OF DEBARKATION"]=[{type:"path",fill:!1,d:"M100,80 l0,40 M81,90.5 l38,19 M81,109.5 l38,-19"},{type:"circle",cx:100,cy:100,r:20,fill:!1},L._translate(0,-35,L._scale(.6,o["GR.IC.NAVAL"],!0))],o["GR.IC.SECURITY"]=a("SEC"),o["GR.IC.SECURITY POLICE (AIR)"]=[a("SP"),{type:"path",d:"M 78.8 121.5 C 68.1 121.5 68.1 138.5 78.8 138.5 L 100 130 L 78.8 121.5 z M 100 130 L 121.3 138.5 C 131.9 138.5 131.9 121.5 121.3 121.5 L 100 130 z"}],o["GR.IC.SENSOR"]={type:"path",d:"m 100,80 c 0,7.5 12.5,20 20,20 -7.5,0 -20,12.5 -20,20 0,-7.5 -12.5,-20 -20,-20 7.5,0 20,-12.5 20,-20 z"},o["GR.IC.SHORE PATROL"]=a("SP"),o["GR.IC.SNIPER"]={type:"path",fill:!1,d:"M 60 85 L 90 85 L 60 85 z M 110 85 L 140 85 L 110 85 z M 100 90 L 100 115 L 100 90 z"},o["GR.IC.PARACHUTE RIGGER"]={type:"path",fill:!1,d:"m 120,100 -20,20 -20,-20 m 0,0 c 0,-25 40,-25 40,0 l -40,0"},o["GR.IC.SPECIAL FORCES"]=a("SF"),o["GR.IC.SPECIAL OPERATIONS FORCES"]=a("SOF"),o["GR.IC.SURVEILLANCE"]={type:"path",stroke:!1,d:"m 100,80 -25,40 50,0 z"},o["GR.IC.SURVEY"]=[{type:"path",d:"M85,120 l15,-15 15,15 ",fill:!1},{type:"path",d:"M100,105 l0,-25 20,12.5 z",fill:!!e&&i}],o["GR.IC.SUSTAINMENT"]=a("SUST"),o["GR.IC.TELEPHONE SWITCH"]=[{type:"text",stroke:!1,x:100,y:135,fontsize:30,text:"C"},{type:"path",fill:!1,d:"M100,140 l0,-80  M70,60 l60,0"}],o["GR.IC.TOPOGRAPHIC"]={type:"path",fill:!1,d:"m 85,105 c 10,5 20,5 30,0 m -15,-15 15,30 m -30,0 15,-30 0,-10"},o["GR.IC.TRANSPORTATION"]=[{type:"path",fill:!1,d:"M 119,100 A 18.5,18.3 0 0 1 99.4,118 18.5,18.3 0 0 1 81.2,100 18.5,18.3 0 0 1 99.4,81.8 18.5,18.3 0 0 1 119,100 Z  M 100,81.9 V 118  M 82.9,91.2 117,108  M 82.9,108 117,91.2"}],o["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]=a("TSA"),o["GR.IC.UNMANNED SYSTEMS"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},o["GR.IC.SEARCH AND RESCUE"]=a("SAR"),o["GR.IC.DIVER, CIVILIAN"]={type:"path",fill:i,d:"M 114.3,94 C 114.3,102.3 107.9,109 100,109 c -7.9,0 -14.2,-6.7 -14.2,-15 0,-8.3 6.4,-15 14.2,-15 7.9,0 14.3,6.7 14.3,15 z m 0,27 14.3,15 -57,0 14.3,-15 M 125.7,79 l 14.3,0 0,30 -14.3,0 m -51.3,0 -14.3,0 0,-30 14.3,0 m 54.2,15 c 0,16.6 -12.8,30 -28.5,30 -15.7,0 -28.5,-13.4 -28.5,-30 C 71.5,77.4 84.3,64 100,64 115.7,64 128.5,77.4 128.5,94 z"},o["GR.IC.VIDEO IMAGERY"]={type:"path",fill:!1,d:"m 140,110 -26,0 m 7,-20 19,0 m -15,-10 -65,0 0,40 50,0 z m 15,5 0,30"},o["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]=a("USSS"),o["GR.IC.WATER"]={type:"path",d:"m 65,90 50,0 c 10,0 20,10 20,20 m -40,-30 20,0 m -10,0 0,10",fill:!1},o["GR.IC.WATER PURIFICATION"]=[o["GR.IC.WATER"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:90,y:105,fontsize:20,text:"PURE"}],o["GR.IC.FF.AIR ASSAULT WITH ORGANIC LIFT"]={Unknown:{type:"path",d:"M35,120 L 85,120 l15,15 15,-15 L165,120",fill:!1},Friend:{type:"path",d:"M25,120 L 85,120 l15,15 15,-15L175,120",fill:!1},Neutral:{type:"path",d:"M45,120 L 85,120 l15,15 15,-15 L155,120",fill:!1},Hostile:{type:"path",d:"M50,120 L 85,120 l15,15 15,-15 L150,120",fill:!1}}[T],o["GR.IC.FF.AIR DEFENCE"]={Unknown:{type:"path",d:"m 55,135 c 10,-20 80,-20 90,0",fill:!1},Friend:{type:"path",d:"M25,150 C25,110 175,110 175,150",fill:!1},Neutral:{type:"path",d:"M45,150 C45,110 155,110 155,150",fill:!1},Hostile:{type:"path",d:"M70,140 C70,115 130,115 130,140",fill:!1}}[T],o["GR.IC.FF.AIR AND NAVAL GUNFIRE LIAISON COMPANY"]=[],o["GR.IC.FF.AMPHIBIOUS"]={Unknown:{type:"path",d:"m 30,95 c 10,0 0,15 13.5,15 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 13.5,0 3.5,-15 13.5,-15",fill:!1},Friend:{type:"path",d:"m 25,90 c 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 20,-20",fill:!1},Neutral:{type:"path",d:"m 45,110 c 18.8,0 0,-20 18,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18,20",fill:!1},Hostile:{type:"path",d:"m 32,95 c 10,0 0,15 11.5,15 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 11.5,0 1.5,-15 11.5,-15",fill:!1}}[T],o["GR.IC.FF.ANALYSIS"]={type:"path",d:"m 100,125 0,-70  m 0,90 -25,-20 h 50 z",fill:!1},o["GR.IC.FF.ANTITANK/ANTIARMOUR"]={Unknown:{type:"path",fill:!1,d:"M55,135 L100,33 145,135"},Friend:{type:"path",fill:!1,d:"M25,150 L100,52 175,150"},Neutral:{type:"path",fill:!1,d:"M45,150 L100,47 155,150"},Hostile:{type:"path",fill:!1,d:"M60,132 L100,30 140,132"}}[T],o["GR.IC.FF.BORDER PATROL"]=[{type:"path",stroke:!1,d:"M 122.8 66.8 C 119.9 66.8 117.4 68.6 117.4 71.6 L 117.4 73.1 L 128.7 73.1 L 128.7 72.4 C 128.7 68.8 126.5 66.8 122.8 66.8 z M 108.6 74.8 L 108.6 76 L 117.6 76 L 117.5 77.5 L 118 80.8 C 119.1 81.5 118.9 82.5 120.8 83.5 C 122.1 84.1 124 84 125.2 83.4 C 127.5 82.4 129 79.2 128.3 76 L 137.5 76 L 137.5 74.8 L 108.6 74.8 z M 94.8 82.1 C 93.3 82.1 92 83.5 92 85 L 92 85.2 C 92 86.6 96 91.3 97 92.6 C 98.2 94.3 100.8 98.8 103.2 98.8 C 104.5 98.8 111.1 93.7 112.6 92.8 L 112.6 106.2 L 126.4 85.6 C 123 85.6 114.9 85.2 112.2 85.9 C 110.2 86.4 105 91.6 103.6 91.7 C 103.4 91 100.6 87.5 100 86.5 C 99.2 85.4 97.2 82.1 95.6 82.1 L 94.8 82.1 z M 130.4 85.6 C 129.6 85.6 117.5 104.1 116.3 106.2 L 128.1 106.2 L 128.1 110.6 L 112.5 110.6 L 112.5 133.2 L 120.7 133.2 L 122 117.5 L 124.3 117.5 L 125.6 133.2 L 133.5 133.2 L 133.5 87.9 C 133.5 87.2 131.2 85.6 130.4 85.6 z M 66.9 90.7 C 66.5 91.4 62.5 96.9 62.5 96.9 C 62.5 97.8 76.7 107.2 78.5 108.3 C 81.4 110.2 83.9 112.1 86.7 114 C 88.2 115 89.4 115.9 90.8 116.8 C 92.1 117.7 94.1 118.5 94.1 120.4 L 94.1 133.2 L 105.5 133.2 L 105.5 121.7 C 105.5 120.6 107.2 119 107.2 118.8 C 107.2 117.6 106.1 118.6 105.6 116.9 C 105.2 115.4 105.4 115.6 104.5 114.5 C 103.5 113.1 101.9 112 99.8 112 C 96.8 112 97.6 111.8 95.3 110.3 C 93.9 109.3 92.5 108.4 91.2 107.4 C 88.7 105.5 85.8 103.5 83.2 101.8 C 80.9 100.3 68.2 91 66.9 90.7 z M 67.9 92.6 L 72.7 95.7 L 72.8 103 L 67.9 99.9 L 67.9 92.6 z M 77.8 99.3 L 82.6 102.6 L 82.6 110 L 77.8 106.6 L 77.8 99.3 z M 87.4 106.2 L 92.5 109.5 L 92.4 116.9 L 87.4 113.5 L 87.4 106.2 z"},{type:"path",fill:!!e&&i,stroke:!1,d:"M 117.4 73.1 L 117.4 74.8 L 128.7 74.8 L 128.7 73.1 L 117.4 73.1 z M 126.4 85.6 L 112.6 106.2 L 112.6 110.6 L 128.1 110.6 L 128.1 106.2 L 116.4 106.2 C 117.5 104.1 129.6 85.6 130.4 85.6 L 126.4 85.6 z M 67.9 92.6 L 67.9 99.9 L 72.8 103 L 72.7 95.7 L 67.9 92.6 z M 77.8 99.3 L 77.8 106.6 L 82.6 110 L 82.6 102.6 L 77.8 99.3 z M 87.4 106.2 L 87.4 113.5 L 92.4 116.9 L 92.5 109.5 L 87.4 106.2 z "}],o["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]={type:"path",fill:!1,d:"m 80,60 20,20 20,-20 m -20,0 0,80"},o["GR.IC.FF.CORPS SUPPORT"]={Unknown:{type:"path",d:"M160,75 l-15,25 15,25",fill:!1},Friend:{type:"path",d:"M175,50 l-30,50 30,50",fill:!1},Neutral:{type:"path",d:"M155,50 l-20,50 20,50",fill:!1},Hostile:{type:"path",d:"M150,80 l-15,20 15,20",fill:!1}}[T],o["GR.IC.FF.CUSTOMS SERVICE"]=[{type:"path",stroke:!1,d:"M 115.5 69.8 C 115.8 70.4 116.9 72.9 117.5 72.9 L 128.3 72.9 L 128.3 69.8 L 115.5 69.8 z M 117.3 74.7 C 116.8 74.7 116 75.7 115.8 76.1 L 117.2 76.1 L 117.2 76.8 C 117.2 79.6 119.8 81.8 122.8 81.8 C 126.5 81.8 128.3 78.6 128.3 74.7 L 117.3 74.7 z M 111.3 83.6 C 110.5 83.6 99.4 91.8 97.8 92.9 C 95.6 94.4 93 96.1 91 97.7 C 89.1 99.2 85.4 100.5 85.4 103.6 L 85.4 104 C 85.4 104.7 87.1 106.7 88.2 106.7 L 88.8 106.7 C 90.2 106.7 108 93.4 111.3 91.7 L 111.3 105.3 L 126 83.6 L 111.3 83.6 z M 75.3 83.6 C 74.5 83.6 73.4 84.4 73.4 85 L 73.4 108.9 C 73.4 109.8 73.9 110.2 74.4 110.5 L 78.5 110.5 L 78.5 83.6 L 75.3 83.6 z M 78.5 110.5 L 78.5 135.2 L 105.6 135.2 L 105.6 110.5 L 78.5 110.5 z M 130.5 83.6 C 129.6 83.6 123.8 92.9 122.9 94.2 C 121.9 95.7 115.7 104.5 115.5 105.3 L 127.6 105.3 L 127.6 110.3 L 111.5 110.3 L 111.5 134.8 L 119.6 134.8 C 120.6 134.8 121.1 127.9 121.3 126.6 C 121.7 123.9 122.4 120.4 122.6 117.8 L 122.9 117.8 L 125.4 134.8 L 133.9 134.8 L 133.9 86.7 C 133.9 85.6 131.9 83.6 130.7 83.6 L 130.5 83.6"},{type:"path",fill:!!e&&i,stroke:!1,d:"M 117.5 72.9 L 117.3 74.7 L 128.3 74.7 L 128.3 72.9 L 117.5 72.9 z M 126 83.7 L 111.3 105.3 L 111.5 110.3 L 127.7 110.3 L 127.7 105.3 L 115.5 105.3 C 115.7 104.5 121.9 95.7 122.9 94.3 C 123.8 92.9 129.6 83.7 130.5 83.7 L 126 83.7 z "}],o["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]={type:"path",stroke:!1,d:"M 100.2 62.3 C 100.1 63.2 99 66.3 98.7 67.4 C 97.8 69.9 99.4 70 99.4 72.3 L 99.4 73 C 99.4 73.7 98.9 73.5 98.3 73.8 C 96.6 72.4 94.2 71 91.3 71 L 90 71 C 84.2 71 80 75.5 74.6 75.5 L 73.9 75.5 C 72.3 75.5 71.5 74.1 71.3 75.8 L 74.3 77.2 C 71.8 82.4 69.9 89.7 67.5 95.5 C 66.3 98.6 65.3 101.6 64.1 104.7 C 63.5 106.3 63.1 107.7 62.5 109.3 C 62 110.5 61.8 113.1 60.2 113.2 C 62.4 116.4 68 120.5 73.3 120.5 L 76 120.5 C 81.6 120.5 87.3 116.6 89.5 113.2 L 88.2 113.2 L 75.4 77.2 L 74.5 77.2 L 74.5 77 L 75.4 77.2 L 78.6 77.7 L 79.3 77.7 L 89.3 76.2 L 90.4 76.3 C 93.7 76.3 93.8 80.2 94.7 80.2 L 97.7 80.2 L 97.7 129.2 L 86.1 129.2 L 86.1 131.5 L 81.4 131.5 L 81.4 134.1 L 77.5 134.1 L 77.5 138.2 L 123.3 138.2 L 123.3 133.9 L 119.3 133.9 L 119.3 131.6 L 114.5 131.6 L 114.5 129.2 L 102.6 129.2 L 102.6 80.2 L 106 80.2 C 107 80.2 106.6 76.4 110.7 76.4 L 111.3 76.4 L 121.2 77.7 L 122.2 77.7 L 125.4 77.3 C 124.3 79.7 123.1 83.8 122.1 86.4 C 120.9 89.6 119.9 92.6 118.7 95.8 C 117.5 98.9 116.6 101.9 115.4 105 C 114.9 106.4 114.2 108.1 113.7 109.6 C 113.4 110.4 113.1 111.1 112.9 111.9 C 112.5 113.2 112.8 113.2 111.2 113.2 C 113.3 116.4 119.2 120.5 124.6 120.5 L 127.2 120.5 C 132.6 120.5 138.8 116.4 140.9 113.2 L 139.8 113.2 L 126.4 77.1 C 127.4 76.9 129.3 76.2 129.3 75.3 C 129.3 74.5 127.8 75.5 126.7 75.5 L 126.3 75.5 C 120.8 75.5 116.6 71 110.9 71 L 109.6 71 C 106.7 71 104.2 72.4 102.6 73.8 C 101.8 73.4 101.3 73.6 101.3 72.3 C 101.3 71.9 102.4 68.8 102.5 68.5 L 100.6 62.3 L 100.2 62.3 z M 126.1 80.8 L 137.8 113.2 L 114.1 113.2 L 126.1 80.8 z M 74.8 80.8 L 86.5 113.2 L 63.1 113.1 L 74.8 80.8 z"},o["GR.IC.FF.DIRECTION FINDING"]={type:"path",d:"M 100,140 V 55  M 78,67 100,54.9 122,67",fill:!1},o["GR.IC.FF.DIVISION AND BELOW SUPPORT"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50",fill:!1},Neutral:{type:"path",d:"M45,50 l20,50 -20,50",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20",fill:!1}}[T],o["GR.IC.FF.EMERGENCY OPERATION"]=[{type:"path",d:"M 100 65 L 115.2 91.3 L 130.3 117.5 C 133.3 112.4 135 106.4 135 100 C 135 80.7 119.3 65 100 65 z M 100 65 C 80.7 65 65 80.7 65 100 C 65 106.4 66.7 112.4 69.7 117.5 L 84.8 91.3 L 100 65 z M 69.7 117.5 C 75.7 128 87 135 100 135 C 113 135 124.3 128 130.3 117.5 L 100 117.5 L 69.7 117.5 z"},{type:"path",fill:!!e&&i,stroke:!1,d:"M 69.7,117.5 100,65 l 30.3,52.5 z"}],o["GR.IC.FF.FIELD ARTILLERY ROCKET"]={type:"path",d:"M100,150 l0,-97 M85,130 l0,-50 M115,130 l0,-50 M85,73 l15,-20 15,20",fill:!1},o["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]={Unknown:{type:"path",d:"M35,80 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,80 l150,0 ",fill:!1},Neutral:{type:"path",d:"M45,80 l110,0 ",fill:!1},Hostile:{type:"path",d:"M50,80 l100,0 ",fill:!1}}[T],o["GR.IC.FF.HORSE"]={type:"path",d:"m 129,72.8 c 0,0 -6.3,2 -9,2.6 -3.4,0.7 -4.9,1.8 -7.7,3.1 -4.2,1.9 -6.8,3.6 -11.3,4.3 -3.3,0.5 -7.7,1.7 -11,1 -3.9,-0.9 -6.1,-2.9 -10.1,-2.9 -3.7,-0 -7.4,-0.6 -10.6,1.3 -2.6,1.6 -4.7,4.2 -5.8,7.1 -2.3,5.4 -0.8,12.5 -1.2,18.4 -0.2,3.1 -0.4,9.3 -0.6,10.2 0,0 1.6,-0 3.4,-2.5 0.9,-1.2 1.7,-3.4 1.9,-4.9 0.5,-3.1 -0.7,-7.5 -0.4,-10 1.1,-0.3 2.4,2.8 2.6,4.7 0.2,2 -1,3.3 -1.4,5.2 -0.5,3 0.3,5 0.6,8.3 0.1,1.6 0.8,3.9 0.5,6 -0.2,2 -0.2,4.3 -0.2,4.3 l 6.9,0 -0.4,-3.8 c 0,0 -1.8,-2.5 -2.1,-4.3 -0.5,-2.7 -0.5,-5.4 0.2,-8 0.5,-2 3.1,-4.3 4.1,-6.1 1.8,-3.1 3.1,-7.1 3.1,-7.1 0,0 5.1,3.4 9.1,4.2 3.8,0.8 11.6,1.4 11.6,1.4 0,0 -0.2,7.3 0.1,12.4 -0,0.1 0.3,3.9 0.3,3.1 -1.4,3.2 -0,8.2 -0,8.2 0,0 2.9,0 6.3,-0 l -0.3,-3.4 c 0,0 -1.5,-3.5 -1.5,-5.3 0,-3.1 0.1,-5.9 0.9,-8.9 0.4,-1.2 0.7,-2.9 1.3,-4 1.4,-2.2 3.1,-3.8 4.2,-6.1 1.1,-2.6 2.3,-5.3 3.6,-7.9 1.6,-3.3 7.8,-7.3 7.8,-7.3 0,0 5,2.9 8.4,4.9 1.2,0.7 3,0.1 3.7,-1 0.7,-1.1 0.8,-2.2 0.3,-3.3 -3.2,-6.7 -7.8,-9.4 -7.8,-9.4 z",stroke:!1},o["GR.IC.FF.INFANTRY"]={Unknown:{type:"path",d:"M50,65L150,135M50,135L150,65"},Friend:{type:"path",d:"M25,50 L175,150 M25,150 L175,50"},Neutral:{type:"path",d:"M45,45L155,155M45,155L155,45"},Hostile:{type:"path",d:"M60,70L140,130M60,130L140,70"}}[T],o["GR.IC.FF.INFANTRY DISMOUNTED"]={Unknown:{type:"path",d:"M50,65L150,135M50,135L150,65"},Friend:{type:"path",d:"m 45,70 110,60 M 45,130 155,70"},Neutral:{type:"path",d:"M45,45L155,155M45,155L155,45"},Hostile:{type:"path",d:"M60,70L140,130M60,130L140,70"}}[T],o["GR.IC.FF.INTERCEPT"]={type:"path",d:"m 100,125 0,-70  m 0,90 -25,-20 h 50 z"},o["GR.IC.FF.JAMMING"]={Unknown:{type:"path",d:"M 63.889,55.047 C 64.229,55.016 64.598,55 65,55 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 2.75,0 3.99,-0.755 4.54,-1.85  M 45.785,68.023 C 54.462,68.546 45.277,78 55,78 c 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 4.88,0 5,-2.381 5,-4.82",fill:!1},Friend:{type:"path",d:"m 25,55 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10  M 25,68 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10",fill:!1},Neutral:{type:"path",d:"m 45,55 v 0 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10  M 45,68 v 0 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10",fill:!1},Hostile:{type:"path",d:"M 69.912,58.091 C 70.339,61.028 68.698,65 75,65 c 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 0.94,0 1.7,0.09 2.32,0.247  M 51.052,76.935 C 51.769,77.59 52.974,78 55,78 c 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 7.97,0 3.23,-6.358 6.05,-8.935",fill:!1}}[T],o["GR.IC.FF.LAW ENFORCEMENT"]={type:"path",stroke:!1,d:"m 99.79,81.61 c -1.05,0 -1.87,0.87 -1.87,1.98 0,0.79 0.45,1.46 1.05,1.76 l -3.59,6.44 -6.83,0.1 c 0,-1.05 -0.86,-1.91 -1.87,-1.91 -1.04,0 -1.86,0.86 -1.86,1.96 0,1.09 0.82,2.02 1.86,2.02 0.26,0 0.53,-0.11 0.75,-0.16 l 3.44,6.3 -3.51,6.4 c -0.23,-0.1 -0.45,-0.1 -0.68,-0.1 -1.04,0 -1.86,0.8 -1.86,1.9 0,1.1 0.82,2 1.86,2 1.05,0 1.87,-0.8 1.87,-2 0,0 0,0 0,-0.1 l 6.83,0.1 3.55,6.4 c -0.6,0.3 -1.01,0.9 -1.01,1.7 0,1 0.86,2 1.87,2 1.11,0 1.91,-0.9 1.91,-2 0,-0.8 -0.4,-1.4 -0.9,-1.7 l 3.6,-6.4 7,-0.1 c 0,0.1 0,0.1 0,0.1 0,1.1 0.9,2 1.8,2 1.1,0 2,-0.8 2,-2 0,-1.1 -0.9,-1.9 -2,-1.9 -0.2,0 -0.5,0 -0.7,0.1 l -3.6,-6.57 3.6,-6.4 c 0.2,0.1 0.5,0.21 0.7,0.21 1.1,0 2,-0.92 2,-2.02 0,-1.06 -0.9,-1.96 -2,-1.96 -1,0 -1.8,0.86 -1.8,1.96 0,0.1 0,0.11 0,0.11 h -7 l -3.6,-6.52 c 0.5,-0.33 0.9,-0.97 0.9,-1.68 0,-1.08 -0.8,-1.98 -1.91,-1.98 z"},o["GR.IC.FF.MAIN GUN SYSTEM"]={Unknown:{type:"path",d:"M55,65L55,135"},Friend:{type:"path",d:"M55,50L55,150"},Neutral:{type:"path",d:"M55,45L55,155"},Hostile:{type:"path",d:"M55,72L55,128"}}[T],o["GR.IC.FF.MEDICAL"]={type:"path",d:"M100,"+S.bbox.y1+"L100,"+S.bbox.y2+"M"+S.bbox.x1+",100L"+S.bbox.x2+",100"},o["GR.IC.FF.MEDICAL THEATER"]={Unknown:{type:"path",d:"M100,170 l0,-140 M40,75 l15,25 -15,25 M160,75 l-15,25 15,25 M55,100 l90,0",fill:!1},Friend:{type:"path",d:"M100,150 l0,-100 M25,50 l30,50 -30,50 M175,50 l-30,50 30,50 M55,100 l90,0",fill:!1},Neutral:{type:"path",d:"M100,155 l0,-110  M45,50 l20,50 -20,50 M155,50 l-20,50 20,50 M65,100 l70,0",fill:!1},Hostile:{type:"path",d:"M100,172 l0,-144 M50,80 l15,20 -15,20 M150,80 l-15,20 15,20 M65,100 l70,0",fill:!1}}[T],o["GR.IC.FF.MEDICAL CORPS"]={Unknown:{type:"path",d:"M100,170 l0,-140 M160,75 l-15,25 15,25 M30,100 l115,0",fill:!1},Friend:{type:"path",d:"M100,150 l0,-100  M175,50 l-30,50 30,50 M25,100 l120,0",fill:!1},Neutral:{type:"path",d:"M100,155 l0,-110 M155,50 l-20,50 20,50 M45,100 l90,0",fill:!1},Hostile:{type:"path",d:"M100,172 l0,-144  M150,80 l-15,20 15,20 M28,100 l110,0",fill:!1}}[T],o["GR.IC.FF.MEDICAL TREATMENT FACILITY"]=[o["GR.IC.FF.MEDICAL"],{type:"path",fill:!1,d:"M70,90 l0,20  M130,90 l0,20"}],o["GR.IC.FF.MILITARY POLICE"]={type:"path",d:"m 65.31,70.62 c 11.56,13.49 23.13,13.49 34.69,0  m 0,0 c 11.6,13.49 23.1,13.49 34.7,0  m 0,0 C 128.9,95.67 146.3,122.7 100,140 53.75,122.7 71.09,95.67 65.31,70.62",fill:!1},o["GR.IC.FF.MOTORIZED"]={type:"path",d:"M100,"+S.bbox.y1+"L100,"+S.bbox.y2},o["GR.IC.FF.NAVAL"]=[{type:"path",d:"M 100,145 100,65",fill:!1},{type:"path",d:"m 70,70 60,0",fill:!1},{type:"path",d:"m 57.8,105.5 c -2.2,0.1 1.3,20.6 2.8,22.1 0.8,0.8 3.5,-3.8 4.6,-2.6 17.4,20.2 33,19.7 34.7,19.6 0,0 0.2,-0 0.3,0 1.7,0.1 17.3,0.5 34.7,-19.6 1,-1.2 3.7,3.4 4.6,2.6 1.4,-1.5 4.9,-21.9 2.8,-22.1 -2.2,-0.1 -4,4.2 -6.7,6.4 -3,2.4 -7.5,3.4 -7.7,4.5 -0.1,0.8 4.9,3.5 3.9,4.9 -5.1,6.3 -15.1,16.6 -31.3,17 l -0.3,4.3 -0.3,-4.3 c -16.2,-0.4 -26.3,-10.7 -31.3,-17 -1.1,-1.3 4,-4.1 3.9,-4.9 -0.2,-1 -4.7,-2 -7.7,-4.5 -2.7,-2.3 -4.5,-6.6 -6.7,-6.4 z",stroke:!1},{type:"circle",cx:100,cy:60,r:5,fill:!1}],o["GR.IC.FF.PRISON"]={type:"path",stroke:!1,d:"M 62.5 67.9 L 62.5 73.4 L 69.9 73.4 L 69.9 106 C 66.8 106.7 64.4 109.6 64.4 113.4 C 64.4 116 65.8 116.9 65.9 118.4 C 66 120.4 65.6 122.5 65.6 124.7 L 65.6 126.6 L 62.5 126.6 L 62.5 132.1 L 137.5 132.1 L 137.5 126.6 L 136 126.6 L 135.6 117.5 C 138.3 113.4 135.8 107 131.5 106 L 131.5 73.4 L 137.5 73.4 L 137.5 67.9 L 62.5 67.9 z M 74.5 73.4 L 87.2 73.4 L 87.2 108.4 C 87.2 109.2 84.8 109.7 83.9 110.6 C 83.1 111.3 82.2 112.7 81.6 113.6 C 80.5 115.2 78.6 118.7 78.6 121.1 L 76.1 117 C 76.5 116.4 76.9 114.6 76.9 113.7 L 76.9 112.2 C 76.9 109.5 74.5 107.9 74.5 106.5 L 74.5 73.4 z M 91.5 73.4 L 110.2 73.4 L 110.2 90.9 C 109 89.6 108.8 87.8 106.8 85.7 C 105.4 84.3 103.5 83 100.8 83 L 100.3 83 C 98.2 83 96.1 83.6 94.9 84.5 C 94.3 85 93.6 85.4 93.1 86 C 92.4 86.6 92.2 87.3 91.5 87.8 L 91.5 73.4 z M 114.3 73.4 L 127.2 73.4 L 127.2 106.5 C 127.2 106.9 124.8 109.2 124.4 111.1 C 123.7 114.2 124.5 114.6 125 117 L 123.3 120.2 C 122.7 118.3 120.7 115 119.7 113.5 C 118.3 111.4 117.3 109.1 114.3 108.9 L 114.3 73.4 z M 99.7 84.9 L 100.6 84.9 C 104.8 84.9 108.5 90.4 108.5 94.7 L 108.5 96.4 C 108.5 100.4 105 106.2 101.3 106.2 L 99.4 106.2 C 94.9 106.2 91.4 100.2 91.6 95.5 C 91.8 90.7 94.9 84.9 99.7 84.9 z M 110.3 100.5 L 110.2 106.9 L 106.7 106.3 L 110.3 100.5 z M 91.5 103.6 L 94.3 106.8 L 91.5 107.4 L 91.5 103.6 z M 70.7 107.9 C 72.9 107.9 74.7 110.4 74.7 112.7 L 74.7 113.4 C 74.7 117.9 70 120.2 67.6 116.7 C 65.7 113.8 66.9 107.9 70.7 107.9 z M 130.6 107.9 C 132.8 107.9 134.4 110.8 134.4 113.2 L 134.4 113.4 C 134.4 116.7 133 116.7 132 118.2 L 128.9 118.3 L 126.7 115.4 L 126.5 113.2 C 126.1 111 128.2 107.9 130.6 107.9 z M 105.9 108.2 C 107.2 108.2 108.9 109 110.2 109.3 L 110.2 126.6 L 91.5 126.6 L 91.5 110.1 C 91.5 108.6 96.6 108.9 98.4 108.9 C 101.1 108.9 104 108.2 105.9 108.2 z M 114.3 110.8 C 117.2 112.3 117.4 113.4 119 116.4 C 120.1 118.5 121.7 120.9 121.7 124 C 121.9 124.2 122.3 124.9 122.7 124.9 C 124 124.9 125.5 119.8 126.7 118.9 L 126.7 119.4 L 127.2 119.4 L 127.2 126.6 L 114.3 126.6 L 114.3 110.8 z M 87.2 111.3 L 87.2 126.6 L 74.5 126.6 L 74.5 118.9 C 75.8 119.4 77.4 125.4 78.6 125.4 C 80.6 125.4 80.7 119.6 81.9 117.5 C 83.2 115.3 84.4 111.9 87.2 111.3 z M 133.6 119.7 L 133.9 126.6 L 131.5 126.6 L 131.5 120.4 L 133.6 119.7 z M 68.1 119.9 C 68.6 120.1 69.9 120.3 69.9 121.1 L 69.9 126.6 L 67.7 126.6 L 68.1 119.9 z"},o["GR.IC.FF.JAIL BREAK"]=[o["GR.IC.FF.PRISON"],{type:"path",strokewidth:5,d:"m 70,130 L130,70",fill:!1}],o["GR.IC.FF.RECONNAISSANCE"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M25,150L175,50"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],o["GR.IC.FF.RECONNAISSANCE DISMOUNTED"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M 45,130 155,70"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],o["GR.IC.FF.RECONNAISSANCE EQUPIMENT"]={Unknown:{type:"path",d:"M50,135L150,65"},Friend:{type:"path",d:"M 50.6 132.9 L 149.3 67"},Neutral:{type:"path",d:"M45,155L155,45"},Hostile:{type:"path",d:"M60,130L140,70"}}[T],o["GR.IC.FF.SEARCH"]={type:"path",d:"M 100,54.3 V 139  m -22,-12 22,12 22,-12",fill:!1},o["GR.IC.FF.SENSOR"]=[{type:"path",d:"M"+S.bbox.x1+",100 L75,100 M"+(200-S.bbox.x1)+",100 L125,100"},{type:"path",d:"M65,85 l70,0 -15,30 -40,0 z",fill:!!e&&i}],o["GR.IC.FF.SIGNAL"]={Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 100,110 100,90 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T],o["GR.IC.FF.SIGNAL DISMOUNTED"]={Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M 52,66.8 100,110 l 0,-20 47.9,43.1"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T],o["GR.IC.FF.SOUND"]=[{type:"path",d:"M"+S.bbox.x1+",100 L75,100 M"+(200-S.bbox.x1)+",100 L125,100"},{type:"path",d:"M65,85 l70,0 -15,30 -40,0 z",fill:!!e&&i},{type:"text",stroke:!1,x:100,y:110,fontsize:25,text:"S"}],o["GR.IC.FF.SUPPLY"]={Unknown:{type:"path",d:"M35,120 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,120 l150,0",fill:!1},Neutral:{type:"path",d:"M45,120 l110,0",fill:!1},Hostile:{type:"path",d:"M50,120 l100,0 ",fill:!1}}[T],o["GR.IC.FF.SUPPLY CORPS"]={Unknown:{type:"path",d:"M160,75 l-15,25 15,25 M35,120 l120,0",fill:!1},Friend:{type:"path",d:"M175,50 l-30,50 30,50 M25,120 l135,0",fill:!1},Neutral:{type:"path",d:"M155,50 l-20,50 20,50 M45,120 l100,0",fill:!1},Hostile:{type:"path",d:"M150,80 l-15,20 15,20 M50,120 l100,0",fill:!1}}[T],o["GR.IC.FF.SUPPLY DIVISION AND BELOW"]={Unknown:{type:"path",d:"m 45,120 120,0 M 40,75 55,100 40,125",fill:!1},Friend:{type:"path",d:"m 45,120 130,0 M 25,50 55,100 25,150",fill:!1},Neutral:{type:"path",d:"m 57,120 98,0 M 45,50 65,100 45,150",fill:!1},Hostile:{type:"path",d:"m 50,120 100,0 M 50,80 65,100 50,120",fill:!1}}[T],o["GR.IC.FF.SUPPLY THEATER"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25 M160,75 l-15,25 15,25 M45,120 l110,0 ",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50 M175,50 l-30,50 30,50 M40,120 l120,0 ",fill:!1},Neutral:{type:"path",d:" M45,50 l20,50 -20,50 M155,50 l-20,50 20,50 M55,120 l90,0 ",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20 M150,80 l-15,20 15,20 M50,120 l100,0",fill:!1}}[T],o["GR.IC.FF.CLASS ALL"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"ALL"},o["GR.IC.FF.CLASS MULTIPLE"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"MULT"},o["GR.IC.FF.CLASS I"]={type:"path",d:"M 111,115 C 96.3,110 96.3,89.5 111,84 100,79.7 87.5,86.3 87.5,99.5 87.5,113 100,119 111,115 Z",fill:!1},o["GR.IC.FF.NATO SUPPLY CLASS I"]=a("I"),o["GR.IC.FF.CLASS II"]=o["GR.IC.QUARTERMASTER"],o["GR.IC.FF.NATO SUPPLY CLASS II"]=a("II"),o["GR.IC.FF.CLASS III"]={type:"path",d:"m 100,120 0,-20 -15,-20 30,0 -15,20 ",fill:!1},o["GR.IC.FF.CLASS IV"]=o["GR.IC.ENGINEER"],o["GR.IC.FF.NATO SUPPLY CLASS IV"]=a("IV"),o["GR.IC.FF.CLASS V"]={type:"path",d:"m 90,115 0,-25 c 0,-10 20,-10 20,0 l 0,25 m -25,0 30,0",fill:!1},o["GR.IC.INTERPRETER/TRANSLATOR"]=[{type:"path",d:"m 65,90 15,0 0,-10 20,20 -20,20 0,-10 -15,0 z",fill:i},{type:"path",d:"m 135,90 -15,0 0,-10 -20,20 20,20 0,-10 15,0 z"}],o["GR.IC.FF.NATO SUPPLY CLASS ALL"]=a("ALL"),o["GR.IC.FF.CLASS VI"]=[{type:"circle",cx:100,cy:85,r:5,fill:!1},{type:"path",d:"m 85,95 30,0 m -15,15 0,-20 m -10,30 10,-10 10,10",fill:!1}],o["GR.IC.FF.CLASS VII"]=[{type:"circle",cx:75,cy:100,r:7},{type:"circle",cx:125,cy:100,r:7},{type:"path",d:"M75,100 c0,-20 50,-20 50,0",fill:!1}],o["GR.IC.FF.CLASS VIII"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M165,80 l-130,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M175,80 l-150,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M155,80 l-110,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],o["GR.IC.FF.CLASS VIII.THEATER"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M155,80 l-110,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M155,80 l-110,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M145,80 l-90,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],o["GR.IC.FF.CLASS VIII.CORPS"]={Unknown:{type:"path",fill:!1,d:"M100,120 l0,-90 M155,80 l-120,0"},Friend:{type:"path",fill:!1,d:"M100,120 l0,-70 M155,80 l-130,0"},Neutral:{type:"path",fill:!1,d:"M100,120 l0,-75 M145,80 l-100,0"},Hostile:{type:"path",fill:!1,d:"M100,120 l0,-92 M153,80 l-106,0"}}[T],o["GR.IC.FF.CLASS IX"]=[{type:"circle",cx:100,cy:100,r:10,fill:!1},{type:"path",d:"m 100,110 0,10 m 0,-30 0,-10 m 8.7,14.2 8.4,-4.8 m -8.4,15.9 8,5.4 m -25.4,-5.4 -8.2,5.4 m 8.2,-16.3 -8,-5.4",fill:!1}],o["GR.IC.EQUIPMENT MANUFACTURE"]=[{type:"circle",cx:100,cy:100,r:20,fill:!1},{type:"path",d:"m 100,120 0,20 m 0,-60 0,-20 m 18.1,28.4 16,-9.6 m -16,31.2 16,12 M 82.5,110 66.1,122 M 82.5,88.8 66.5,78",fill:!1}],o["GR.IC.FF.CLASS X"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"CA"},o["GR.IC.FF.THEATRE SUPPORT"]={Unknown:{type:"path",d:"M40,75 l15,25 -15,25 M160,75 l-15,25 15,25",fill:!1},Friend:{type:"path",d:"M25,50 l30,50 -30,50 M175,50 l-30,50 30,50",fill:!1},Neutral:{type:"path",d:"M45,50 l20,50 -20,50 M155,50 l-20,50 20,50",fill:!1},Hostile:{type:"path",d:"M50,80 l15,20 -15,20 M150,80 l-15,20 15,20",fill:!1}}[T],o["GR.IC.FF.US MARSHALS SERVICE"]={type:"path",stroke:!1,d:"m 100,84.25 3.7,10.66 11.3,0.21 -8.9,6.88 3.2,10.8 -9.3,-6.5 -9.24,6.5 3.26,-10.8 -8.98,-6.88 11.23,-0.21 z  m 0,-2.62 c -10.13,0 -18.37,8.24 -18.37,18.37 0,10.2 8.24,18.4 18.37,18.4 10.2,0 18.4,-8.2 18.4,-18.4 0,-10.13 -8.2,-18.37 -18.4,-18.37 z  m 0,2.62 c 8.8,0 15.7,7.04 15.7,15.75 0,8.8 -6.9,15.7 -15.7,15.7 -8.71,0 -15.75,-6.9 -15.75,-15.7 0,-8.71 7.04,-15.75 15.75,-15.75 z"},o["GR.M1.ACCIDENT"]=P("ACC"),o["GR.M1.AIRMOBILE/AIR ASSAULT"]={type:"path",fill:!1,d:"M85,55 L100,75 115,55"},o["GR.M1.ARMORED"]={type:"path",fill:!1,d:"m 90,60 20,0 c 10,0 10,15 0,15 L 90,75 C 80,75 80,60 90,60"},o["GR.M1.CARGO"]={type:"path",fill:!1,d:"m 100,60 0,15 -15,0 0,-15 30,0 0,15 -15,0"},o["GR.M1.AMMUNITION"]={type:"path",d:"M95,75 L95,60 C95,55 105,55 105,60 L105,75 M90,75 L110,75",fill:!1},o["GR.M1.AMPHIBIOUS WARFARE SHIP "]={type:"path",d:"M 113,75 100,75 90,64.3 95,65 l 0,-8 10,0 0,8 5.5,-0.6 L 100,75"},o["GR.M1.ANTISUBMARINE WARFARE"]=P("P"),o["GR.M1.AREA"]=P("AREA"),o["GR.M1.ARMY"]={type:"path",fill:!1,d:"m 132,64.9 -13,12.7  m 0,-12.7 13,12.7  M 115,64.9 102,77.6  m 0,-12.7 13,12.7  M 97.9,64.9 85.2,77.6  m 0,-12.7 12.7,12.7  M 80.9,64.9 68.2,77.6  m 0,-12.7 12.7,12.7"},o["GR.M1.ATTACK"]=P("A"),o["GR.M1.AVIATION"]={type:"path",d:"m 75,60 0,15 50,-15 0,15 z"},o["GR.M1.BATTALION"]={type:"path",fill:!1,d:"m 105,60 v 18 0  M 95,60 v 18"},o["GR.M1.BIOLOGICAL"]=P("B"),o["GR.M1.BORDER"]=P("BOR"),o["GR.M1.BRIDGING"]={type:"path",fill:!1,d:"m 80,80 5,-5 30,0 5,5 m -40,-20 5,5 30,0 5,-5"},o["GR.M1.BRIGADE"]={type:"path",fill:!1,d:"m 107.5,62.5 -15,15  m 0,-15 15,15"},o["GR.M1.CHEMICAL"]=P("C"),o["GR.M1.INTRUSION"]=P("I"),o["GR.M1.CHEMICAL SURVEILLANCE"]=P("RS"),o["GR.M1.CIVILIAN"]=P("CIV"),o["GR.M1.CLOSE PROTECTION"]=P("CLP"),o["GR.M1.COMBAT"]=P("CBT"),o["GR.M1.COMMAND AND CONTROL"]=P("C2"),o["GR.M1.COMMAND AND CONTROL ROTARY WING"]=P(e?"Y":"C2"),o["GR.M1.TILT-ROTOR"]=P("TR"),o["GR.M1.COMMANDER"]=P("CDR"),o["GR.M1.COMMAND POST NODE"]=P("CPN"),o["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]=P("CCP"),o["GR.M1.CONSTRUCTION"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:70,fontsize:20,text:"CONST"},o["GR.M1.COMPANY"]={type:"path",fill:!1,d:"M 100,59.6 V 78"},o["GR.M1.CORPS"]={type:"path",fill:!1,d:"m 127.5,62.5 -15,15  m 0,-15 15,15  m -20,-15 -15,15  m 0,-15 15,15  m -20,-15 -15,15  m 0,-15 15,15"},o["GR.M1.CROSS CULTURAL COMMUNICATION"]=P("CCC"),o["GR.M1.CROWD AND RIOT CONTROL"]=P("CRC"),o["GR.M1.DECONTAMINATION"]=P("D"),o["GR.M1.DEMOLITION"]=P("DEM"),o["GR.M1.DETENTION"]=P("DET"),o["GR.M1.DEPUTY"]=P("DEP"),o["GR.M1.DIRECT COMMUNICATIONS"]={type:"path",fill:!1,d:"m 95,65 -5,5 5,5 m 10,-10 5,5 -5,5 M 90,70 c 20,0 20,0 20,0 m 15,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -40,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z"},o["GR.M1.DIVING"]={type:"path",fill:!1,d:"m 104.6,64.8 c 0,2.7 -2.1,4.8 -4.6,4.8 -2.5,0 -4.6,-2.2 -4.6,-4.8 0,-2.7 2.1,-4.8 4.6,-4.8 2.5,0 4.6,2.2 4.6,4.8 z m 0,8.7 4.6,4.8 -18.3,0 4.6,-4.8 M 108.3,60 l 4.6,0 0,9.6 -4.6,0 m -16.5,0 -4.6,0 0,-9.6 4.6,0 m 17.4,4.8 c 0,5.3 -4.1,9.6 -9.2,9.6 -5.1,0 -9.2,-4.3 -9.2,-9.6 0,-5.3 4.1,-9.6 9.2,-9.6 5.1,0 9.2,4.3 9.2,9.6 z"},o["GR.M1.DIVISION"]={type:"path",fill:!1,d:"m 117.5,62.5 -15,15  m 0,-15 15,15  m -20,-15 -15,15  m 0,-15 15,15"},o["GR.M1.MARINE DIVISION"]=P("D"),o["GR.M1.DESIGNATED MARKSMAN"]=P("DM"),o["GR.M1.DOG"]=P("DOG"),o["GR.M1.DRILLING"]={type:"path",d:"m 90,60 5,15 10,0 5,-15 z"},o["GR.M1.ELECTRO-OPTICAL"]=P("EO"),o["GR.M1.ENHANCED"]=P("ENH"),o["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]=P("EOD"),o["GR.M1.EARLY WARNING RADAR"]=P("EWR"),o["GR.M1.FIELD ARTILLERY OBSERVER"]=[{type:"circle",cx:100,cy:68,r:3},{type:"path",d:"M 100,53.1 85.8,75.9 H 114 Z",fill:!1}],o["GR.M1.FIRE DIRECTION CENTRE"]=P("FDC"),o["GR.M1.FORCE"]=P("F"),o["GR.M1.FORWARD"]=P("FWD"),o["GR.M1.GROUND STATION MODULE"]=P("GSM"),o["GR.M1.HIJACKING"]=P("H"),o["GR.M1.INDIVIDUAL"]={type:"path",fill:!1,d:"M85,65 l30,0"},o["GR.M1.INFANTRY"]=P("IN"),o["GR.M1.INTRUSION"]=P("I"),o["GR.M1.J1"]=P("J1"),o["GR.M1.J2"]=P("J2"),o["GR.M1.J3"]=P("J3"),o["GR.M1.J4"]=P("J4"),o["GR.M1.J5"]=P("J5"),o["GR.M1.J6"]=P("J6"),o["GR.M1.J7"]=P("J7"),o["GR.M1.J8"]=P("J8"),o["GR.M1.J9"]=P("J9"),o["GR.M1.JOINT FIRE SUPPORT"]=P("JFS"),o["GR.M1.JOINT NETWORK NODE"]=P("JNN"),o["GR.M1.LANDING SUPPORT"]=P("LS"),o["GR.M1.LARGE COMMUNICATIONS CONTINGENCY PACKAGE"]=P("LCCP"),o["GR.M1.LARGE EXTENSION NODE"]=P("LEN"),o["GR.M1.LIAISON"]=P("LO"),o["GR.M1.LOAD HANDLING SYSTEM"]=P("LHS"),o["GR.M1.MAINTENANCE"]={type:"path",fill:!1,d:"m 83,70 h 34  m 8,-7 c -10,0 -10,14 0,14  M 75,63 c 10,0 10,14 0,14"},o["GR.M1.MEDEVAC"]={type:"path",stroke:!1,d:"M95.5,80 l9,0 0,-9 9,0 0,-9 -9,0 0,-9 -9,0 0,9 -9,0 0,9 9,0 Z"},o["GR.M1.MESSENGER"]=P("MSG"),o["GR.M1.METEOROLOGICAL"]=P("MET"),o["GR.M1.MILITARY POLICE"]=P("MP"),o["GR.M1.MINE COUNTERMEASURE"]=P("MCM"),o["GR.M1.MISSILE"]={type:"path",d:"M 95,78 V 58 c 0,-5 10,-5 10,0 v 20",fill:!1},o["GR.M1.(MOBILE) ADVISOR AND SUPPORT"]={type:"path",d:"m 105,65 5,5 -5,5 M 90,70 c 20,0 20,0 20,0 m 15,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -40,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z",fill:!1},o["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]=P("MSE"),o["GR.M1.MOBILITY ASSAULT"]=P("MA"),o["GR.M1.MOBILITY SUPPORT"]=P("MS"),o["GR.M1.MOVEMENT CONTROL CENTRE"]=P("MCC"),o["GR.M1.MULTI-DOMAIN"]={type:"path",d:"m 85.9,65.6 v -4.7 h 4.9  M 100,75 85.9,60.9  m -2.2,10.7 -3.4,3.4 3.4,4.1  M 100,75 H 80.3  m 35.7,-3.4 3,3.4 -3,4.1  M 100,75 h 19  M 109,60.9 h 5 v 4.8  M 100,75 114,60.9  m -17.4,-2.6 3.4,-3.4 3,3.4  M 100,75 V 54.9",fill:!1},o["GR.M1.MULTINATIONAL"]=P("MN"),o["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]=P("MSU"),o["GR.M1.MULTIPLE ROCKET LAUNCHER"]={type:"path",d:"M85,75 l15,-15 15,15 M85,67 l15,-15 15,15",fill:!1},o["GR.M1.NATO MEDICAL ROLE 1"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"1"},o["GR.M1.NATO MEDICAL ROLE 2"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"2"},o["GR.M1.NATO MEDICAL ROLE 2 BASIC"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"2B"},o["GR.M1.NATO MEDICAL ROLE 2 ENHANCED"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"2E"},o["GR.M1.NATO MEDICAL ROLE 2 FORWARD"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"2E"},o["GR.M1.NATO MEDICAL ROLE 3"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"3"},o["GR.M1.NATO MEDICAL ROLE 4"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:120,y:72,fontsize:25,text:"4"},o["GR.M1.NAVAL"]=L._translate(0,-35,L._scale(.6,o["GR.IC.NAVAL"],!0)),o["GR.M1.NODE CENTRE"]=P("NC"),o["GR.M1.NUCLEAR"]=P("N"),o["GR.M1.OBSERVER"]=[{type:"path",d:"M 100,53.1 85.8,75.9 H 114 Z",fill:!1}],o["GR.M1.OF-1"]=P(e?"OF-1":"O-1/O-2"),o["GR.M1.OF-2"]=P(e?"O-3":"OF-2"),o["GR.M1.OF-3"]=P(e?"O-4":"OF-3"),o["GR.M1.OF-4"]=P(e?"O-5":"OF-4"),o["GR.M1.OF-5"]=P(e?"O-6":"OF-5"),o["GR.M1.OF-6"]=P(e?"O-7":"OF-6"),o["GR.M1.OF-7"]=P(e?"O-8":"OF-7"),o["GR.M1.OF-8"]=P(e?"O-9":"OF-8"),o["GR.M1.OF-9"]=P(e?"O-10":"OF-9"),o["GR.M1.OF-10"]=P(e?"O-11":"OF-10"),o["GR.M1.OF-D"]=P(e?"":"OF-D"),o["GR.M1.OPERATIONS"]=P("OPS"),o["GR.M1.OPTICAL"]=P("OPT"),o["GR.M1.OR-1"]=P(e?"E-1":"OR-1"),o["GR.M1.OR-2"]=P(e?"E-2":"OR-2"),o["GR.M1.OR-3"]=P(e?"E-3":"OR-3"),o["GR.M1.OR-4"]=P(e?"E-4":"OR-4"),o["GR.M1.OR-5"]=P(e?"E-5":"OR-5"),o["GR.M1.OR-6"]=P(e?"E-6":"OR-6"),o["GR.M1.OR-7"]=P(e?"E-7":"OR-7"),o["GR.M1.OR-8"]=P(e?"E-8":"OR-8"),o["GR.M1.OR-9"]=P(e?"E-9":"OR-9"),o["GR.M1.OTHER"]=P("OTH"),o["GR.M1.PALLETIZED LOAD SYSTEM"]=P("PLS"),o["GR.M1.PERSONNEL RECOVERY"]=P("H"),o["GR.M1.PLATOON"]=[{type:"circle",stroke:!1,cx:80,cy:68,r:8},{type:"circle",stroke:!1,cx:100,cy:68,r:8},{type:"circle",stroke:!1,cx:120,cy:68,r:8}],o["GR.M1.POLICE"]={type:"path",fill:!1,d:"m 90.3,57.8 c 1.6,7 -3.4,14.7 9.7,19.6 13,-4.9 8,-12.6 10,-19.6  m 0,0 c -3,3.8 -7,3.8 -10,0  m 0,0 c -3.2,3.8 -6.5,3.8 -9.7,0"},o["GR.M1.RADAR"]={type:"path",fill:!1,d:"m 85,55 c 0.1,21.4 11.7,24.6 25,25 M 116,55 101,67.5 101,55 86.6,66.9"},o["GR.M1.RADIO FREQUENCY IDENTIFICATION (RFID) INTERROGATOR/ SENSOR"]=P("RF"),o["GR.M1.RAILROAD"]=L._translate(0,-50,[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:125,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}]),o["GR.M1.RADIOLOGICAL"]=P("RAD"),o["GR.M1.RANGER"]=P("RGR"),o["GR.M1.RECON"]=P("R"),o["GR.M1.RECONNAISSANCE"]=P("REC"),o["GR.M1.REGIMENT"]={type:"path",fill:!1,d:"m 110,60 v 18 0  M 90,60 v 18  m 10,-18 v 18"},o["GR.M1.RETRANSMISSION SITE"]=P("RTNS"),o["GR.M1.ROBOTIC"]={type:"path",d:"m 100,52.7 14.9,14.8 c 0.4,-0.3 0.9,-0.4 1.4,-0.4 1.5,0 2.7,1.2 2.7,2.7 0,1.4 -1.2,2.7 -2.7,2.7 -1.5,0 -2.7,-1.3 -2.7,-2.7 0,-0.4 0.1,-0.7 0.2,-1 l -10.4,-5.2 -2.5,8.6 c 0.2,0.1 0.4,0.2 0.6,0.3 0.7,0.5 1.2,1.3 1.2,2.3 0,1.5 -1.2,2.7 -2.7,2.7 -0.55,0 -1.06,-0.2 -1.49,-0.5 -0.73,-0.4 -1.22,-1.3 -1.22,-2.2 0,-1.2 0.77,-2.2 1.85,-2.6 l -2.53,-8.6 -10.42,5.2 c 0.12,0.3 0.18,0.6 0.18,1 0,1.5 -1.21,2.7 -2.7,2.7 -1.49,0 -2.7,-1.2 -2.7,-2.7 0,-1.5 1.21,-2.7 2.7,-2.7 0.52,0 1.01,0.1 1.42,0.4 l 14.9,-14.8 0,0 0,0 z",stroke:!1},o["GR.M1.SECOND IN COMMAND"]=P("SIC"),o["GR.M1.SIGNALER"]=P("SIG"),o["GR.M1.ASSAULT"]=P("ASLT"),o["GR.M1.WEAPON"]=P("WPN"),o["GR.M1.WEAPONS"]=P("W"),o["GR.M1.CRIMINAL INVESTIGATION DIVISION"]=P("CID"),o["GR.M1.DIGITAL"]=P("DIG"),o["GR.M1.NETWORK OR NETWORK OPERATIONS"]=P("NET"),o["GR.M1.AIRFIELD, AERIAL PORT OF DEBARKATION, OR AERIAL PORT OF EMBARKATION"]={type:"path",d:"m 80,70 40,0 M 80,80 111,55",fill:!1},o["GR.M1.PIPELINE"]={type:"path",d:"m 92,66 -12,0 m 12,8 -12,0 m 28,0 12,0 m -12,-8 12,0 m -20,-11 0,7 m -5,-7 10,0 m -13,7 0,16 16,0 0,-16 -16,0",fill:!1},o["GR.M1.POSTAL"]={type:"path",d:"m 90,60 15,0 c 0,5 0,10 10,15 -15,0 -20,0 -25,-15",fill:!1},o["GR.M1.WATER"]={type:"path",d:"m 92,59 h 16  m -8,9.7 V 59  M 75,69 h 40 c 10,0 15,5 15,10",fill:!1},o["GR.M1.INDEPENDENT COMMAND"]={type:"path",d:"m 110,59 v 16  m -8,-8 h 16  M 90,59 v 16  m 8,-8 H 82",fill:!1},o["GR.M1.MULTI-PURPOSE BLADE"]={type:"path",d:"m 80,65 20,-10 20,10 m -20,15 0,-25",fill:!1},o["GR.M1.TANK-WIDTH MINE PLOW"]={type:"path",d:"m 80,65 5,-2.5 m 5,-2.5 5,-2.5 m 10,0 5,2.5 m 5,2.5 5,2.5 m -20,15 0,-20",fill:!1},o["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"]=P("RRC"),o["GR.M1.SEARCH AND RESCUE"]=P("SAR"),o["GR.M1.SECTION"]=[{type:"circle",stroke:!1,cx:90,cy:68,r:8},{type:"circle",stroke:!1,cx:110,cy:68,r:8}],o["GR.M1.SECURITY"]=P("SEC"),o["GR.M1.SENSOR"]={type:"path",d:"m 100,55 c -2,5 -5,8 -10,10 5,2 8,5 10,10 2,-5 5,-8 10,-10 -5,-2 -8,-5 -10,-10 z"},o["GR.M1.SENSOR CONTROL MODULE"]=P("SCM"),o["GR.M1.SIGNALS INTELLIGENCE"]={type:"path",fill:!1,d:"m 100,55 0,23 m -15,-18 5,-5 5,5 5,-5 5,5 5,-5 5,5"},o["GR.M1.SIGNAL SUPPORT"]=P("SPT"),o["GR.M1.SINGLE SHELTER SWITCH"]=P("SSS"),o["GR.M1.SINGLE ROCKET LAUNCHER"]={type:"path",d:"M85,75 l15,-15 15,15",fill:!1},o["GR.M1.SMALL EXTENSION NODE"]=P("SEN"),o["GR.M1.SMOKE"]=P("S"),o["GR.M1.SMOKE/DECON"]=P("SD"),o["GR.M1.SNIPER"]={type:"path",d:"m 75,62 h 20  m 5,16 V 62.1  M 125,62 h -20",fill:!1},o["GR.M1.SOUND RANGING"]=P("SDR"),o["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]=P("SOF"),o["GR.M1.SPECIAL WEAPONS AND TACTICS"]={type:"text",stroke:!1,x:100,y:77,fontsize:23,text:"SWAT"},o["GR.M1.SQUAD"]={type:"circle",stroke:!1,cx:100,cy:68,r:8},o["GR.M1.SUPPORT"]=P("SPT"),o["GR.M1.SURVEY"]={type:"path",d:"m 108,78 -8,-8 m 0,0 -8,8 m 8,-8 0,-15 15,8 z"},o["GR.M1.TACTICAL EXPLOITATION"]=P("TE"),o["GR.M1.TARGET ACQUISITION"]=P("TA"),o["GR.M1.TEAM"]=[{type:"circle",fill:!1,cx:100,cy:65,r:10},{type:"path",d:"m 90,75 l20,-20"}],o["GR.M1.THEATRE"]={type:"path",fill:!1,d:"m 135,66.6 -11,11  m 0,-11 11,11  m -15,-11 -12,11  m 0,-11 12,11  m -15,-11 -10.7,11  m 0,-11 10.7,11  m -14.3,-11 -11.1,11  m 0,-11 11.1,11  m -14.9,-11 -11.1,11  m 0,-11 11.1,11"},o["GR.M1.TOPOGRAPHIC"]={type:"path",fill:!1,d:"m 92,65 c 6,3 10,3 16,0 m -18,13 10,-23 10,23"},o["GR.M1.TRAINING CAMP"]=P("TNG"),o["GR.M1.HIJACKER"]=P("HJ"),o["GR.M1.UNMANNED AERIAL VEHICLE"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},o["GR.M1.UPGRADED EARLY WARNING RADAR"]=P("UEW"),o["GR.M1.UTILITY"]=P("U"),o["GR.M1.VIDEO IMAGERY"]={type:"path",fill:!1,d:"m 120,65 -11,0 m 11,10 -14,0 m 4,-14 -30,0 0,18 25,0 z m 10,2 0,14"},o["GR.M1.WO-1"]=P("WO-1"),o["GR.M1.WO-2"]=P("WO-2"),o["GR.M1.WO-3"]=P("WO-3"),o["GR.M1.WO-4"]=P("WO-4"),o["GR.M1.WO-5"]=P("WO-5"),o["GR.M1.YARD"]=P("YRD"),o["GR.M2.AIRBORNE"]={type:"path",d:"M75,140 C75,125 100,125 100,140 C100,125 125,125 125,140",fill:!1},o["GR.M2.ARCTIC"]={type:"path",d:"M115,125 C125,125 125,135 115,135 L85,135 C75,135 75,125 85,125",fill:!1},o["GR.M2.ATTACK"]=r("A"),o["GR.M2.BLOOD"]={type:"path",d:"m 120,121 c -2,7 -6,10 -6,13 0,3 2,6 6,6 4,0 6,-3 6,-6 0,-3 -4,-6 -6,-13 z",stroke:!1},o["GR.M2.COMBAT AND OPERATIONAL STRESS CONTROL"]={type:"path",d:"m 118.5,132.9 v -8 q 0,-1.1 -0.4,-1.6 -0.5,-0.5 -2,-0.5 v -0.5 h 7.7 v 0.5 q -1.5,0 -2.1,0.5 -0.4,0.5 -0.4,1.6 v 8 q 2.4,-0.1 3.2,-1 0.8,-0.9 0.8,-3.4 v -2.2 q 0,-2.3 0.8,-3.2 0.7,-1 2.6,-1 0.4,0 0.7,0.1 0.3,0 0.6,0 v 0.6 h -0.5 q -0.8,0 -1.1,0.5 -0.2,0.5 -0.2,2.2 v 2.7 q 0,2.7 -1.7,4 -1.8,1.4 -5.1,1.6 v 2.4 q 0,1.2 0.4,1.7 0.6,0.6 2.1,0.6 v 0.5 h -7.7 v -0.5 q 1.5,0 2,-0.6 0.4,-0.4 0.4,-1.7 v -2.4 q -3.4,-0.2 -5.1,-1.6 -1.7,-1.3 -1.7,-4 v -2.7 q 0,-1.7 -0.2,-2.2 -0.3,-0.5 -1.2,-0.5 h -0.5 v -0.6 q 0.3,0 0.6,0 0.5,-0.1 0.7,-0.1 1.8,0 2.5,1 0.9,0.9 0.9,3.2 v 2.2 q 0,2.5 0.8,3.4 0.9,0.9 3.1,1 z",stroke:!1},o["GR.M2.LANDING CRAFT"]=r("LC"),o["GR.M2.LANDING SHIP"]=r("LS"),o["GR.M2.SERVICE CRAFT/YARD"]=r("YY"),o["GR.M2.TUG HARBOR"]=r("YT"),o["GR.M2.OCEAN GOING TUG BOAT"]=r("AT"),o["GR.M2.SURFACE DEPLOYMENT AND DISTRIBUTION COMMAND"]=r("SDDC"),o["GR.M2.COMPOSITE"]=r("COMP"),o["GR.M2.LIGHT AND MEDIUM"]=r("L/M"),o["GR.M2.BATTLE DAMAGE REPAIR"]=r("BDR"),o["GR.M2.BICYCLE EQUIPPED"]={type:"circle",cx:100,cy:132,r:11,fill:!1},o["GR.M2.CASUALTY STAGING"]={type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:122,y:133,fontsize:18,text:"CS"},o["GR.M2.CLEARING"]=r("CLR"),o["GR.M2.CLOSE RANGE"]=r("CR"),o["GR.M2.COMBAT SEARCH AND RESCUE"]=r("CSAR"),o["GR.M2.CONTROL"]={type:"path",d:"m 98,130 2,-4 2,4 m -8,8 -4,-2 4,-2 m 8,8 -2,4 -2,-4 m 8,-8 4,2 -4,2 m -14,-2 16,0 m -8,-8 0,16",fill:!1},o["GR.M2.NONCOMBATANT GENERIC VESSEL"]={type:"path",d:"m 95,135 0,-10 10,0 0,10 5,0 0,10 -20,0 0,-10 z",stroke:!1},o["GR.M2.SHELTER"]={type:"path",d:"m 85,140 30,0 -5,-15 -10,-5 -10,5 z",stroke:!1},o["GR.M2.SELF-PROPELLED"]={type:"path",d:"m 85,125 30,0 c 10,0 10,15 0,15 l -30,0 c -10,0 -10,-15 0,-15",fill:!1},o["GR.M2.SURGICAL"]={type:"path",d:"m 114,126 21,6 -21,6  m 0,-12 a 3.89,3.89 0 0 1 -3,3 3.89,3.89 0 0 1 -4,-3 3.89,3.89 0 0 1 4,-4 3.89,3.89 0 0 1 3,4 z  m 0,12 a 3.89,3.89 0 0 1 -3,4 3.89,3.89 0 0 1 -4,-4 3.89,3.89 0 0 1 4,-4 3.89,3.89 0 0 1 3,4 z",fill:!1},o["GR.M2.CROSS-COUNTRY TRUCK"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:100,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],o["GR.M2.CAVALRY"]={type:"text",stroke:!1,x:110,y:140,fontsize:25,text:"CAV"},o["GR.M2.DECONTAMINATION"]=r("D"),o["GR.M2.DEMOLITION"]=r("DEM"),o["GR.M2.DENTAL"]="E"==I.edition?{type:"path",d:"m 108.8,142 c -0.1,0 -0.2,0 -0.2,0 0,0 0,0 0,0 -0.3,-0.1 -0.5,-0.3 -0.6,-0.6 0,-0.1 -0.2,-0.1 -0.2,-0.2 -0.5,-1.2 -0.8,-2.5 -1,-3.9 -0.1,-1.1 -0.1,-2.2 -0.2,-3.3 0,-1 -0.1,-2 -0.1,-3 0,-0.3 -0.1,-0.5 -0.2,-0.7 -0.1,-0.3 -0.2,-0.5 -0.3,-0.7 -0.4,-1 -0.8,-2 -0.9,-3.1 -0.1,-1 0,-2 0.5,-2.8 0.4,-0.7 0.9,-1.3 1.6,-1.6 0.3,-0.1 0.5,-0.2 0.8,-0.3 0.2,0 0.4,0 0.5,0 0.2,0 0.2,0 0.3,0 0.6,0.1 1.2,0.2 1.8,0.3 0.7,0.2 1.4,0.2 2.2,0.1 0.6,-0.1 1.2,-0.2 1.8,-0.3 0.4,-0.1 0.8,-0.1 1.3,0 0.6,0.1 1.1,0.4 1.6,0.9 0.8,0.8 1.1,1.9 1.2,3 0,0.6 -0.1,1.2 -0.2,1.7 -0.3,0.9 -0.6,1.7 -0.9,2.5 -0.2,0.4 -0.3,0.8 -0.3,1.3 0,0.6 -0.1,1.3 -0.1,2 0,0.9 -0.1,1.9 -0.2,2.9 0,0.5 -0.1,1 -0.1,1.4 -0.1,1 -0.4,2 -0.7,2.9 -0.1,0.4 -0.3,0.7 -0.5,1.1 -0.1,0.2 -0.3,0.4 -0.5,0.4 0,0 -0.1,0 -0.1,0 0,0 -0.1,0 -0.1,0 0,0 -0.1,0 -0.1,0 -0.3,-0.1 -0.4,-0.2 -0.5,-0.4 0,-0.2 0,-0.2 0,-0.3 -0.1,-0.7 -0.1,-1.3 -0.2,-2 -0.1,-1 -0.3,-2 -0.5,-2.9 -0.2,-0.7 -0.4,-1.3 -0.7,-1.8 -0.2,-0.4 -0.5,-0.7 -0.8,-0.9 -0.3,-0.2 -0.4,-0.2 -0.6,0 -0.3,0.1 -0.4,0.3 -0.6,0.6 -0.3,0.4 -0.6,0.9 -0.7,1.4 -0.5,1.5 -0.7,2.9 -0.8,4.4 0,0.4 -0.1,0.8 -0.1,1.2 0,0.4 -0.2,0.6 -0.6,0.7 z",stroke:!1}:{type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:122,y:133,fontsize:18,text:"D"},o["GR.M2.DIGITAL"]=r("DIG"),o["GR.M2.ENHANCED POSITION LOCATION REPORTING SYSTEM"]={type:"path",d:"m 87,142 13,-12 13,12 m -13,-20 0,20 0,0",fill:!1},o["GR.M2.EQUIPMENT"]=r("E"),o["GR.M2.EQUIMENT/TROOP"]=r("E/T"),o["GR.M2.HEAVY"]=r("H"),o["GR.M2.HIGH ALTITUDE"]=r("HA"),o["GR.M2.HIGH TO MEDIUM ALTITUDE"]=r("HMA"),o["GR.M2.HIGH TO LOW ALTITUDE"]=r("HLA"),o["GR.M2.JAMMING"]={Unknown:{type:"path",d:"M 40.019,126.84 C 40.121,124.78 40.776,123 45,123 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 9.16,0 1.54,8.38 7.87,9.8  m -91.625,4.1 c 0.734,-0.56 1.901,-0.9 3.755,-0.9 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 0.29,0 0.56,-0 0.81,-0",fill:!1},Friend:{type:"path",d:"m 25,123 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10  m -150,3 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10",fill:!1},Neutral:{type:"path",d:"m 45,123 v 0 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10  m -110,3 v 0 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10",fill:!1},Hostile:{type:"path",d:"M 59.401,131.4 C 61.215,128.57 57.535,123 65,123 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 1.55,0 2.62,0.24 3.36,0.65  m -74.484,22.3 c 0.343,0 0.717,0.1 1.124,0.1 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 5.66,0 4.91,3.21 5.01,5.99",fill:!1}}[T],o["GR.M1.CYBERSPACE"]=P("CYB"),o["GR.M2.AIR ASSAULT"]={type:"path",fill:!1,d:"m 85,125 15,20 15,-20"},o["GR.M2.VERY HEAVY"]=r("VH"),o["GR.M2.CYBERSPACE"]=r("CYB"),o["GR.M2.NAVY BARGE, SELF-PROPELLED"]=r("YS"),o["GR.M2.NAVY BARGE, NOT SELF-PROPELLED"]=r("YB"),o["GR.M2.LAUNCH"]=r("YFT"),o["GR.M1.TACTICAL SATELLITE COMMUNICATIONS"]=[{type:"path",d:"m 105,65 10,0 m -30,0 10,0 M 85,77 c 10,-7 20,-7 30,0",fill:!1},{type:"path",d:"m 75.4,60.9 0,9.1 13.1,0 0,-9.1 z m 36,0 0,9.1 13.1,0 0,-9.1 z m -18,0 0,9.1 13.1,0 0,-9.1 z",stroke:!1}],o["GR.M2.INTERMODAL"]={type:"path",d:"m 80,125 40,0 0,-4 8,9 -8,9 0,-4 -40,0 0,4 -8,-9 8,-9 z",fill:!1},o["GR.M2.INTENSIVE CARE"]={type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:122,y:133,fontsize:18,text:"IC"},o["GR.M2.J1"]=r("J1"),o["GR.M2.J2"]=r("J2"),o["GR.M2.J3"]=r("J3"),o["GR.M2.J4"]=r("J4"),o["GR.M2.J5"]=r("J5"),o["GR.M2.J6"]=r("J6"),o["GR.M2.J7"]=r("J7"),o["GR.M2.J8"]=r("J8"),o["GR.M2.J9"]=r("J9"),o["GR.M2.LIGHT"]=r("L"),o["GR.M2.LABORATORY"]=r("LAB"),o["GR.M2.LAUNCHER"]={type:"path",fill:!1,d:"M80,140 L115,120 120,140"},o["GR.M2.LONG RANGE"]=r("LR"),o["GR.M2.LONG RANGE SURVEILLANCE"]={type:"text",stroke:!1,x:110,y:140,fontsize:25,text:"LRS"},o["GR.M2.LOW ALTITUDE"]=r("LA"),o["GR.M2.MEDIUM"]=r("M"),o["GR.M2.MEDIUM ALTITUDE"]=r("MA"),o["GR.M2.MEDIUM TO LOW ALTITUDE"]=r("MLA"),o["GR.M2.MEDIUM RANGE"]=r("MR"),o["GR.M2.MOUNTAIN"]={type:"path",stroke:!1,d:"m 87,142 10,-20 5,10 3,-5 8,15"},o["GR.M2.MULTIPLE ALTITUDES"]=r("H/MA"),o["GR.M2.MULTI-CHANNEL"]=r("MC"),o["GR.M2.OF-1"]=r(e?"O-1/O-2":"OF-1"),o["GR.M2.OF-2"]=r(e?"O-3":"OF-2"),o["GR.M2.OF-3"]=r(e?"O-4":"OF-3"),o["GR.M2.OF-4"]=r(e?"O-5":"OF-4"),o["GR.M2.OF-5"]=r(e?"O-6":"OF-5"),o["GR.M2.OF-6"]=r(e?"O-7":"OF-6"),o["GR.M2.OF-7"]=r(e?"O-8":"OF-7"),o["GR.M2.OF-8"]=r(e?"O-9":"OF-8"),o["GR.M2.OF-9"]=r(e?"O-10":"OF-9"),o["GR.M2.OF-10"]=r(e?"O-11":"OF-10"),o["GR.M2.OF-D"]=r("OF-D"),o["GR.M2.OPTICAL"]=r("OPT"),o["GR.M2.OPTOMETRY"]=[{type:"path",d:"m 135,129 c -1.68,-1.82 -7.72,-7.76 -15.11,-7.83 h -0.15 c -7.32,0 -13.42,5.74 -15.12,7.52 -0.44,0.45 -0.45,1.18 0,1.65 1.67,1.82 7.72,7.76 15.11,7.84 h 0.15 c 7.32,0 13.42,-5.75 15.12,-7.52 0.44,-0.46 0.45,-1.19 0,-1.66 z  m -15.14,7.92 h -0.14 c -6.89,-0.1 -12.61,-5.71 -14.2,-7.36 1.62,-1.68 7.39,-7.14 14.22,-7.14 h 0.14 c 6.84,0.1 12.53,5.64 14.16,7.4 -1.65,1.72 -7.39,7.1 -14.18,7.1 z",strokewidth:2},{type:"path",d:"m 123.71,130.25 a 3.908,3.908 0 0 1 -3.91,3.91 3.908,3.908 0 0 1 -3.91,-3.91 3.908,3.908 0 0 1 3.91,-3.91 3.908,3.908 0 0 1 3.91,3.91 z",stroke:!1}],o["GR.M2.OR-1"]=r(e?"E-1":"OR-1"),o["GR.M2.OR-2"]=r(e?"E-2":"OR-2"),o["GR.M2.OR-3"]=r(e?"E-3":"OR-3"),o["GR.M2.OR-4"]=r(e?"E-4":"OR-4"),o["GR.M2.OR-5"]=r(e?"E-5":"OR-5"),o["GR.M2.OR-6"]=r(e?"E-6":"OR-6"),o["GR.M2.OR-7"]=r(e?"E-7":"OR-7"),o["GR.M2.OR-8"]=r(e?"E-8":"OR-8"),o["GR.M2.OR-9"]=r(e?"E-9":"OR-9"),o["GR.M2.GUERILLA"]=r("G"),o["GR.M2.AMPHIBIOUS"]={Unknown:{type:"path",d:"M 64 144.9 C 80.4 143.9 63.1 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 137.1 125 120.2 143.6 135.9 144.9",fill:!1},Friend:{type:"path",d:"m 25,145 c 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 18.8,20 18.8,0 0,-20 18.8,-20 18.8,0 0,20 20,20",fill:!1},Neutral:{type:"path",d:"M 45 125 C 61.7 125.9 44.2 145 62.6 145 C 81.4 145 62.6 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 137.8 125 119 145 137.8 145 C 155.9 145 138.9 126.2 154.8 125 ",fill:!1},Hostile:{type:"path",d:"M 70.4 142.4 C 74.8 137 66.8 125 81.4 125 C 100.2 125 81.4 145 100.2 145 C 119 145 100.2 125 119 125 C 133.3 125 125.7 136.6 129.7 142.1 ",fill:!1}}[T],o["GR.M2.PACK ANIMAL"]={type:"path",d:"m 84,140 9,-15 7,15 7,-15 9,15",fill:!1},o["GR.M2.PATIENT EVACUATION COORDINATION"]={type:"text",stroke:!1,x:122,y:135,fontsize:16,text:"PEC"},o["GR.M2.PREVENTIVE MEDICIN"]={type:"path",d:"m 116.6,121.74 -6.47,9.88 h 4.51 l 1.23,-4.5 2.93,6.75 0.9,-2.21 h 3.32 z  m -0.45,9.11 -0.56,2.04 h -6.27 l -3.54,5.4 h 21.44 l -3.4,-5.29 h -3.29 l -1.68,4.15 z",stroke:!1},o["GR.M2.PREVENTIVE MAINTENANCE"]=r("PM"),o["GR.M2.PSYCHOLOGICAL"]={type:"text",textanchor:"middle",alignmentBaseline:"middle",stroke:!1,x:115,y:135,fontsize:28,text:"P"},o["GR.M2.RADIO RELAY LINE OF SIGHT"]=[{type:"circle",cx:100,cy:132,r:11,fill:!1,strokewidth:3},{type:"path",d:"M 90.8 128.2 C 90.3 129.3 90 130.6 90 132 C 90 133.4 90.3 134.7 90.8 135.8 L 100 132 L 90.8 128.2 z M 100 132 L 109.3 135.8 C 109.7 134.7 110 133.4 110 132 C 110 130.6 109.7 129.3 109.3 128.2 L 100 132 z"}],o["GR.M2.RAILROAD"]=[{type:"path",d:"M65,125 l70,0",fill:!1},{type:"circle",fill:!1,cx:70,cy:130,r:5},{type:"circle",fill:!1,cx:80,cy:130,r:5},{type:"circle",fill:!1,cx:120,cy:130,r:5},{type:"circle",fill:!1,cx:130,cy:130,r:5}],o["GR.M2.TRACTOR TRAILER"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:75,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],o["GR.M2.RECOVERY (UNMANNED SYSTEMS)"]={type:"path",d:"m 70,125 c0,20 60,20 60,0",fill:!1},o["GR.M2.RECOVERY (MAINTENANCE)"]={type:"path",fill:!1,d:"M75,125 c8,0 8,16 0,16 m8,-8 l35,0 m8,-8 c-8,0 -8,16 0,16"},o["GR.M2.REFUEL"]=r("K"),o["GR.M2.RESCUE COORDINATION CENTRE"]={type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:122,y:132,fontsize:16,text:"RCC"},o["GR.M2.RIVERINE"]={type:"path",d:"m 70.1,123 c 0,17 59.9,17 59.9,0 z",fill:!1},o["GR.M2.ROBOTIC"]={type:"path",d:"M100,121.68L114.895,136.459C115.309,136.201 115.798,136.052 116.321,136.052C117.812,136.052 119.022,137.262 119.022,138.753C119.022,140.243 117.812,141.454 116.321,141.454C114.831,141.454 113.62,140.243 113.62,138.753C113.62,138.407 113.686,138.076 113.805,137.772L103.378,132.6L100.851,141.224C101.072,141.298 101.28,141.4 101.471,141.526C102.211,142.008 102.701,142.843 102.701,143.791C102.701,145.281 101.491,146.492 100,146.492C99.451,146.492 98.939,146.327 98.512,146.045C97.776,145.562 97.29,144.73 97.29,143.785C97.29,142.592 98.064,141.579 99.138,141.222L96.613,132.606L86.186,137.778C86.305,138.082 86.37,138.413 86.37,138.759C86.37,140.25 85.16,141.46 83.669,141.46C82.179,141.46 80.969,140.25 80.969,138.759C80.969,137.268 82.179,136.058 83.669,136.058C84.193,136.058 84.681,136.207 85.095,136.465L99.991,121.671L100,121.662L100,121.68Z",stroke:!1},o["GR.M2.SECURITY FORCE ASSISTANCE"]=r("SFA"),o["GR.M2.SINGLE CHANNEL"]=r("SC"),o["GR.M2.SKI"]={type:"path",d:"m 95,145 -9,-8 m 28,0 -9,8 m -15,-24 20,20 m 0,-20 -20,20",fill:!1},o["GR.M2.SHORT RANGE"]=r("SR"),o["GR.M2.STRATEGIC"]=r("STR"),o["GR.M2.STRATEGIC MISSILE"]=r("S"),o["GR.M2.SUPPORT"]=r("SPT"),o["GR.M2.TACTICAL"]=r("TAC"),o["GR.M2.TACTICAL MISSILE"]=r("T"),o["GR.M2.TARGET ACQUISITION"]=r("TA"),o["GR.M2.TOWED"]=[{type:"path",d:"M82,130 l36,0",fill:!1},{type:"circle",fill:!1,cx:75,cy:130,r:7},{type:"circle",fill:!1,cx:125,cy:130,r:7}],o["GR.M2.TROOP"]=r("TR"),o["GR.M2.TRACKED"]={type:"path",d:"m 90,125 h 20 c 10,0 10,15 0,15 H 90 c -10,0 -10,-15 0,-15",fill:!1},o["GR.M2.TRUCK"]=[{type:"path",d:"M60,120 l80,0",fill:!1},{type:"circle",fill:!1,cx:65,cy:125,r:5},{type:"circle",fill:!1,cx:135,cy:125,r:5}],o["GR.M2.UTILITY"]=r("U"),o["GR.M2.VIDEO IMAGERY"]={type:"path",fill:!1,d:"m 120,126 h -11  m 11,10 h -14  m 4,-14 H 80 v 18 h 25 z  m 10,2 v 14"},o["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:130,fontsize:20,text:"VTOL"},o["GR.M2.VETERINARY"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:115,y:137,fontsize:28,text:"V"},o["GR.M2.WHEELED"]=[{type:"circle",cx:75,cy:130,r:7,fill:!1},{type:"circle",cx:100,cy:130,r:7,fill:!1},{type:"circle",cx:125,cy:130,r:7,fill:!1}],o["GR.M2.WHEELED LIMITED"]=[{type:"circle",cx:80,cy:130,r:7,fill:!1},{type:"circle",cx:120,cy:130,r:7,fill:!1}],o["GR.M2.WO-1"]=r("WO-1"),o["GR.M2.WO-2"]=r("WO-2"),o["GR.M2.WO-3"]=r("WO-3"),o["GR.M2.WO-4"]=r("WO-4"),o["GR.M2.WO-5"]=r("WO-5"),o["GR.EQ.SHORT RANGE"]={type:"path",d:"m 85,100 30,0",fill:!1},o["GR.EQ.INTERMEDIATE RANGE"]={type:"path",d:"m 85,105 30,0 m -30,-10 30,0",fill:!1},o["GR.EQ.LONG RANGE"]={type:"path",d:"m 85,110 30,0 m -30,-20 30,0 m -30,10 30,0",fill:!1},o["GR.EQ.WEAPON"]={type:"path",d:"m 100,60 0,80",fill:!1},o["GR.EQ.RIFLE"]={type:"path",d:"m 100,60 0,80 M 85,75 100,60 115,75",fill:!1},o["GR.EQ.RIFLE DISMOUNTED1"]={type:"path",d:"m 90,90 10,-10 10,10 m -10,-10 0,40",fill:!1},o["GR.EQ.MACHINE GUN"]={type:"path",d:"m 100,60 0,80 M 85,75 100,60 115,75 M 80,140 120,140",fill:!1},o["GR.EQ.GRENADE LAUNCHER"]=[o["GR.EQ.RIFLE"],{type:"circle",cx:100,cy:90,r:10,fill:!1}],o["GR.EQ.FLAME THROWER"]={type:"path",fill:!1,d:"m 90,135 0,-70 c 0,-15 20,-15 20,0"},o["GR.EQ.AIR DEFENCE GUN"]=[{type:"path",d:"m 85,140 30,0 c 0,-20 -30,-20 -30,0 z m 15,-80 0,65 m 15,-45 0,40 m -30,-40 0,40",fill:!1}],e||N||o["GR.EQ.AIR DEFENCE GUN"].push({type:"path",d:"M 85,75 100,60 115,75",fill:!1}),o["GR.EQ.ANTITANK GUN"]={type:"path",d:"m 85,140 15,-15 15,15 m -15,-80 0,65 m -15,-45 0,40 m 30,-40 0,40",fill:!1},o["GR.EQ.DIRECT FIRE GUN"]={type:"path",d:"m 100,60 0,80 m 15,-60 0,40 m -30,-40 0,40",fill:!1},o["GR.EQ.RECOILLESS GUN"]={type:"path",d:"m 85,75 15,-15 15,15 m 0,5 0,40 m -30,-40 0,40 m 15,-60 0,80",fill:!1},o["GR.EQ.HOWITZER"]=[{type:"circle",cx:100,cy:130,r:10,fill:!1},{type:"path",d:"m 115,80 0,40 m -30,-40 0,40 m 15,-60 0,60",fill:!1}],o["GR.EQ.HOWITZER TRACKED"]={type:"path",d:"M 70,120 l 60,0 c10,0 10,10 0,10 l -60,0 c-10,0 -10,-10 0,-10",fill:!1},o["GR.EQ.MISSILE LAUNCHER"]={type:"path",d:"m 100,140 0,-80 m -15,80 0,-65 c 0,-20 30,-20 30,0 l 0,65",fill:!1},o["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]={type:"path",d:"m 85,140 30,0 c 0,-20 -30,-20 -30,0 z m 15,-15 0,-65 m -15,80 0,-65 c 0,-20 30,-20 30,0 l 0,65",fill:!1},o["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:25,text:"R"},o["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:68,y:100,fontsize:25,text:"E"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:132,y:100,fontsize:25,text:"R"}],o["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"]={type:"text",stroke:!1,x:100,y:145,fontsize:30,text:"T"},o["GR.EQ.ANTITANK MISSILE LAUNCHER"]={type:"path",d:"m 85,140 15,-15 15,15 M 85,120 85,75 c 0,-20 30,-20 30,0 l 0,45 m -15,5 0,-65",fill:!1},o["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]=[o["GR.EQ.MISSILE LAUNCHER"]],o["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"].push({type:"path",d:"m 85,140 30,0",fill:!1}),o["GR.EQ.MORTAR"]=[{type:"path",d:"m 100,60 0,60 M 85,75 100,60 115,75",fill:!1},{type:"circle",cx:100,cy:130,r:10,fill:!1}],o["GR.EQ.SINGLE ROCKET LAUNCHER"]={type:"path",d:"m 85,75 15,-15 15,15 m -15,-5 0,70 M 85,85 100,70 115,85",fill:!1},o["GR.EQ.MULTIPLE ROCKET LAUNCHER"]={type:"path",d:"m 115,90 0,40 m -30,-40 0,40 m 0,-55 15,-15 15,15 m -15,-5 0,70 M 85,85 100,70 115,85",fill:!1},o["GR.EQ.ANTITANK ROCKET LAUNCHER"]={type:"path",d:"m 85,140 15,-15 15,15 M 85,85 100,70 115,85 m -15,-15 0,55 M 85,75 100,60 115,75",fill:!1},o["GR.EQ.NON-LETHAL WEAPON"]={type:"path",d:"m 100,60 0,80 M 80,60 l40,0",fill:!1},o["GR.EQ.NON-LETHAL GRENADE LAUNCHER"]=[o["GR.EQ.NON-LETHAL WEAPON"],{type:"circle",cx:100,cy:90,r:15,fill:!1}],o["GR.EQ.TASER"]=[o["GR.EQ.NON-LETHAL WEAPON"],a("Z")],o["GR.EQ.WATER CANNON"]=[o["GR.EQ.NON-LETHAL WEAPON"],a("W")],o["GR.EQ.LIMITED CROSS-COUNTRY"]=[{type:"path",d:"m 70,130 60,0",fill:!1},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],o["GR.EQ.CROSS-COUNTRY"]=[{type:"path",d:"m 70,130 60,0",fill:!1},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:100,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],o["GR.EQ.ARMOURED FIGHTING VEHICLE"]={type:"path",d:"m 70,100 30,-30 30,30 -30,30 z m 60,-30 0,60 m -60,-60 0,60 0,0",fill:!1},o["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]=[o["GR.EQ.ARMOURED FIGHTING VEHICLE"]],N?o["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"].push({type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:30,text:"C2"}):o["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"].push({type:"path",d:"m 80,90 20,15 0,-10 20,15",fill:!1}),o["GR.EQ.ARMOURED PERSONNEL CARRIER"]={type:"path",fill:!1,d:"m 70,80 30,-10 30,10 m -60,-10 0,60 60,0 0,-60"},o["GR.EQ.ARMOURED PERSONNEL CARRIER COMBAT SERVICE SUPPORT VEHICLE"]=[o["GR.EQ.ARMOURED PERSONNEL CARRIER"],{type:"path",d:"m 70,120 60,0",fill:!1}],o["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]={type:"path",fill:!1,d:"M 130,80 70,130"},o["GR.EQ.COMBAT SERVICE SUPPORT VEHICLE"]={type:"path",fill:!1,d:"M 70,120 130,120"},o["GR.EQ.DESIGNATED MARKSMAN"]=a("DM"),o["GR.EQ.ARMOURED MEDICAL PERSONNEL CARRIER"]={type:"path",fill:!1,d:"m 70,100 60,0 m -30,-30 0,60"},o["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]=[{type:"path",d:"m 60,120 80,0 M 120,80 c 25,0.2 25,40 0,40 l -40,0 C 55,120 55,80 80,80 Z",fill:!1},o["GR.M2.WHEELED LIMITED"]],o["GR.EQ.ARMOURED VEHICLE"]=a("A"),o["GR.EQ.CLOSE PROTECTION"]=a("CLP"),o["GR.EQ.CROWD AND RIOT CONTROL"]=a("CRC"),o["GR.EQ.SPECIAL WEAPONS AND TACTICS (SWAT)"]=a("SWAT"),o["GR.EQ.DEMOLITION"]=a("DEM"),o["GR.EQ.COMMANDER (CDR)"]=a("CDR"),o["GR.EQ.SECOND IN COMMAND (SIC)"]=a("SIC"),o["GR.EQ.ARMORED CARRIER WITH VOLCANO"]=a("V"),o["GR.EQ.TANK"]={type:"path",fill:!1,d:"m 70,80 60,0 m -60,40 60,0 m -60,-50 0,60 0,0 m 60,-60 0,60"},o["GR.EQ.ASSAULT BREACHER VEHICLE (ABV) WITH COMBAT DOZER BLADE"]={type:"path",fill:!1,d:"m 100,95 30,25 m -30,-60 0,35 -30,25 m 10,-60 40,0 m -50,20 60,0 m -60,40 60,0 m -60,-50 0,60 0,0 m 60,-60 0,60"},o["GR.EQ.LIGHT TANK"]={type:"path",fill:!1,d:"m 100,80 0,40"},o["GR.EQ.MEDIC"]={type:"path",d:"M93,83 l14,0 0,10 10,0 0,14 -10,0 0,10 -14,0 0,-10 -10,0 0,-14 10,0 Z"},o["GR.EQ.MEDIUM TANK"]={type:"path",fill:!1,d:"m 105,80 0,40 m -10,-40 0,40"},o["GR.EQ.HEAVY TANK"]={type:"path",fill:!1,d:"m 110,80 0,40 m -20,-40 0,40 m 10,-40 0,40"},o["GR.EQ.TANK RECOVERY VEHICLE"]={type:"path",fill:!1,d:"m 85,100 30,0 m 10,-10 c -13.1,0 -12.4,20 0,20 M 75,90 c 12.7,0.3 12.7,20.3 0,20"},o["GR.EQ.BRIDGE"]={type:"path",d:"m 115,75 -10,10 0,30 10,10 m -30,-50 10,10 0,30 -10,10 m -15,-55 60,0 0,60 -60,0 0,-60",fill:!1},o["GR.EQ.FIXED BRIDGE"]={type:"path",d:"M 100,70 100,130",fill:!1},o["GR.EQ.FOLDING GIRDER BRIDGE"]={type:"path",d:"M 110, 80 90,80 90,120 110,120",fill:!1},o["GR.EQ.HOLLOW DECK BRIDGE"]={type:"path",d:"M 110, 80 90,80 90,120 110,120 z",fill:!1},o["GR.EQ.DRILL"]=o["GR.IC.DRILLING"],o["GR.EQ.DOZER"]={type:"path",d:"m 90,60 20,0 m -10,0 0,20 m -30,0 60,0 m -60,-10 0,60 0,0 m 60,-60 0,60 m -60,-10 60,0",fill:!1},o["GR.EQ.DOZER ARMORED"]={type:"path",d:"m 70,130 60,0 m -30,-70 0,10 m -30,10 30,-10 30,10 m 0,-10 0,60 m -60,-60 0,60 0,0 m 20,-70 20,0",fill:!1},o["GR.EQ.EARTHMOVER"]={type:"path",d:"m 100,60 0,20 m -25,-15 5,-5 40,0 5,5 m -55,15 60,0 m -60,40 60,0 m 0,-50 0,60 m -60,-60 0,60 0,0",fill:!1},o["GR.EQ.MULTIFUNCTIONAL EARTHMOVER/DIGGER"]=[o["GR.EQ.EARTHMOVER"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"MF"}],o["GR.EQ.MINE CLEARING EQUIPMENT"]={type:"path",d:"m 100,80 0,15 -30,25 60,0 -30,-25",fill:!1},o["GR.EQ.MINE LAYING VEHICLE"]=[{type:"path",d:"m 90,85 20,30 m 0,-30 -20,30 m 10,-30 0,30",fill:!1},{type:"circle",cx:100,cy:100,r:10}],o["GR.EQ.MINE SCATTERABLE"]=[a("S"),{type:"circle",cx:85,cy:115,r:5,fill:!1},{type:"circle",cx:100,cy:115,r:5,fill:!1},{type:"circle",cx:115,cy:115,r:5,fill:!1}],o["GR.EQ.UTILITY VEHICLE"]={type:"path",fill:!1,d:"m 70,65 c 0,15 60,15 60,0 l 0,65 -60,0 z"},o["GR.EQ.UTILITY VEHICLE BACKHOE"]=[{type:"path",fill:!1,d:"M 130,130 100,80 75,95 75,95"},{type:"path",d:"M 75,105 85,95 75,95 z"}],o["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]={type:"path",fill:!1,d:"m 75,100 c 15,15 35,15 50,0 z"},o["GR.EQ.UTILITY VEHICLE LIGHT"]={type:"path",fill:!1,d:"M 100,78.3 100,130"},o["GR.EQ.UTILITY VEHICLE MEDIUM"]={type:"path",fill:!1,d:"m 105,130 0,-52 M 95,130 l0,-52"},o["GR.EQ.UTILITY VEHICLE HEAVY"]={type:"path",fill:!1,d:"m 110,130 0,-53 m -20,50 0,-53 m 10,1.3 0,52"},o["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]={type:"path",fill:!1,d:"m 130,130 -40,-40 0,25 c 0,5 -10,5 -10,0"},o["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]={type:"path",fill:!1,d:"m 105,115 10,-10"},o["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]={type:"path",fill:!1,d:"m 120,110 -10,10 m -10,-10 10,-10 m -5,15 10,-10"},o["GR.EQ.MEDICAL VEHICLE"]={type:"path",fill:!1,d:"m 70,100 l 60,0 M 100,78.3 100,130"},o["GR.EQ.MEDICAL EVACUATION"]={type:"path",d:"m 95,85 10,0 0,10 10,0 0,10 -10,0 0,10 -10,0 0,-10 -10,0 0,-10 10,0 z"},o["GR.EQ.MOBILE EMERGENCY PHYSICIAN"]={type:"path",fill:!1,d:"m 70,100 l 60,0 M 100,78.3 100,130 M 85,85 115,85"},o["GR.EQ.BUS"]=[o["GR.EQ.UTILITY VEHICLE"],a("B")],o["GR.EQ.SEMI-TRAILER TRUCK"]=[o["GR.EQ.UTILITY VEHICLE"],{type:"path",fill:!1,d:"m 140,90 0,20 m -10,-10 10,0"},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:85,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],o["GR.EQ.WATER VEHICLE"]=[o["GR.EQ.UTILITY VEHICLE"],{type:"path",fill:!1,d:"m 70,95 c 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10 10,0 0,10 10,10 10,0 0,-10 10,-10"},{type:"circle",cx:75,cy:135,r:5,fill:!1},{type:"circle",cx:125,cy:135,r:5,fill:!1}],o["GR.EQ.TRAIN LOCOMOTIVE"]={type:"path",fill:!1,d:"m 70,70 0,60 60,0 0,-30 -30,0 0,-30 z"},o["GR.EQ.RAILCAR"]=[o["GR.EQ.UTILITY VEHICLE"],{type:"circle",fill:!1,cx:75,cy:135,r:5},{type:"circle",fill:!1,cx:85,cy:135,r:5},{type:"circle",fill:!1,cx:115,cy:135,r:5},{type:"circle",fill:!1,cx:125,cy:135,r:5}],o["GR.EQ.CBRN EQUIPMENT"]=[{type:"path",d:"M80,140 c0,-20 10,-60 50,-63 m-10,63 c0,-20 -10,-60 -50,-63 ",fill:!1},{type:"circle",cx:70,cy:85,r:8},{type:"circle",cx:130,cy:85,r:8}],o["GR.EQ.COMPUTER SYSTEM"]={type:"path",d:"m 100,132 0,-10 -35,0 0,-50 70,0 0,50 -35,0 m -25,10 50,0",fill:!1},o["GR.EQ.COMMAND LAUNCH EQUIPMENT (CLE)"]=a("CLE"),o["GR.EQ.GENERATOR SET"]=a("G"),o["GR.EQ.GROUND-BASED MIDCOURSE DEFENSE (GMD) FIRE CONTROL (GFC) CENTER"]=a("GFC"),o["GR.EQ.IN-FLIGHT INTERCEPTOR COMMUNICATIONS SYSTEM (IFICS) DATA TERMINAL (IDT)"]={type:"path",fill:!1,d:"m 80,82.4 45,-2 -4,37 m -6,-1 0,-35 -34,9 m 12,21 0,8 M 80,82.4 c 0,25 16,35 41,35"},o["GR.EQ.LASER"]={type:"path",fill:!1,d:"m 100,55 0,25 10,5 -20,5 20,5 -20,5 10,5 0,15 10,5 -20,5 20,5 -20,5 20,5 M 90,65 100,55 110,65"},o["GR.EQ.TENT"]={type:"path",fill:!1,d:"m 65,124.4 10,-37 25,-10 25,10 10,37 z"},o["GR.EQ.TENT CIVILIAN"]={type:"path",fill:!1,d:"m 75,120 10,-30 15,-10 15,10 10,30 z"},o["GR.EQ.TENT MILITARY"]={type:"path",d:"m 75,120 10,-30 15,-10 15,10 10,30 z"},o["GR.EQ.UNIT DEPLOYMENT SHIPMENTS"]=a("DPLY"),o["GR.EQ.CIVILIAN VEHICLE.LIGHT"]={type:"path",fill:!1,d:"m 100,125 0,-20"},o["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]={type:"path",fill:!1,d:"m 103,105 0,20 m -6,-20 0,20"},o["GR.EQ.CIVILIAN VEHICLE.HEAVY"]={type:"path",fill:!1,d:"m 106,105 0,20 m -12,-20 0,20 m 6,-20 0,20"},o["GR.EQ.CIVILIAN VEHICLE.TRAILER"]={type:"path",fill:!1,d:"m 140,105 0,20 m -10,-10 10,0"},o["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]=[{type:"path",fill:!!e&&i,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 5,0 0,-20 -20,0 0,-20 -20,0 0,20 -20,0 0,20 5,0 m 50,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z"},{type:"path",fill:!1,strokewidth:2,d:"m 95,90 0,15 10,0 0,-15 z"}],o["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]=[{type:"path",fill:!!e&&i,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 -20,0 -20,0 0,-20 -20,0 0,20 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 75,90 0,15 10,0 0,-15 z"}],o["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]=[{type:"path",fill:!!e&&i,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 0,-20 -20,0 -20,0 -20,0 0,20 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 115,90 0,15 10,0 0,-15 z m -20,0 0,15 10,0 0,-15 z m -20,0 0,15 10,0 0,-15 z"}],o["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]=[{type:"path",fill:!!e&&i,d:"m 90,125 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m -35,0 20,0 m 15,0 5,0 0,-20 0,-20 -20,0 -20,0 0,20 -20,0 0,20 5,0"},{type:"path",fill:!1,strokewidth:2,d:"m 95,90 0,15 10,0 0,-15 z"}],o["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]={type:"path",fill:!!e&&i,d:"m 90,125 20,0 m -20,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 35,0 c 0,-4.1 -3.4,-7.5 -7.5,-7.5 -4.1,0 -7.5,3.4 -7.5,7.5 0,4.1 3.4,7.5 7.5,7.5 4.1,0 7.5,-3.4 7.5,-7.5 z m 0,0 5,0 0,-20 -60,0 0,20 5,0 m 15,-20 5,-15"},o["GR.EQ.PACK ANIMAL"]={type:"path",fill:!1,d:"m 70,125 15,-50 15,50 15,-50 15,50 "},o["GR.EQ.MISSILE SUPPORT"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:93,fontsize:20,text:"MSL"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:20,text:"SPT"}],o["GR.EQ.MISSILE TRANSLOADER"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"MSL"},{type:"path",fill:!1,d:"m 75,70 50,0 m -25,10 c 0,-5 0,-10 0,-10"}],o["GR.EQ.MISSILE TRANSPORTER"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"MSL"}],o["GR.EQ.MISSILE CRANE/LOADING DEVICE"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:30,text:"MSL"},{type:"path",fill:!1,d:"m 75,80 25,-20 c 0,0 0,15 0,15 l 5,0 0,-5"}],o["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:90,y:100,fontsize:20,text:"MSL"},{type:"path",fill:!1,d:"m 120,115 0,-15 -10,-10 20,0 -10,10"}],o["GR.EQ.MISSILE WARHEAD TRANSPORTER"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:93,fontsize:20,text:"MSL"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:20,text:"WHD"}],o["GR.EQ.LAND MINE"]=N?{type:"circle",cx:100,cy:100,r:22,fill:!1}:[{type:"path",fill:!1,d:"m 70,65 60,0 -30,65 z"},{type:"text",stroke:!1,x:100,y:90,fontfamily:"Arial",fontsize:30,text:"M"}],o["GR.EQ.ANTIPERSONNEL LAND MINE"]=[{type:"circle",cx:100,cy:100,r:22},{type:"path",d:"M117,82 l20,-18 -18,25z M83,82 l-20,-18 18,25z",stroke:!1}],o["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]=[{type:"circle",cx:100,cy:100,r:22,fill:!1},{type:"path",d:"M117,82 l20,-18 -18,25z M83,82 l-20,-18 18,25z",stroke:!1}],o["GR.EQ.ANTITANK MINE"]={type:"circle",cx:100,cy:100,r:22},o["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]=a("IED"),o["GR.EQ.LAND MINES"]=[{type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"M"},{type:"path",fill:!1,d:e?"m 135,70 -70,0 35,70 z":"m 65,130 70,0 -35,-70 z"}],o["GR.EQ.SENSOR"]={type:"path",d:"m 100,60 c 0,15 25,40 40,40 -15,0 -40,25 -40,40 0,-15 -25,-40 -40,-40 15,0 40,-25 40,-40 z"},o["GR.EQ.SENSOR EMPLACED"]=[L._scale(.75,o["GR.EQ.SENSOR"],!0),{type:"path",fill:!1,d:"m 70,75 10,-15 10,15 10,-15 10,15 10,-15 10,15"}],o["GR.EQ.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},o["GR.EQ.ANTENNAE"]=[],o["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]={type:"path",fill:!!e&&i,stroke:M,d:"m 110,95 10,0 m -10,10 10,0 m -10,10 10,0 m -10,-30 10,0 m -10,-5 -10,10 -30,0 0,20 30,0 10,10 z"},o["GR.IN.IC.ELDER CARE"]={type:"path",d:"m 120.1,119.1 c 0,-6.3 2.3,-8.2 3.9,-12.6 1,-2.6 1.6,-3.3 1.8,-6.5 0.2,-2.4 0.9,-4.7 0.9,-7.2 v -2.6 c 0,-2.6 -2.2,-8.9 -3.3,-10.5 -1.3,-2 -4.8,-5.4 -6.7,-6.9 -2.2,-1.8 -5.4,-4.6 -8.2,-5.6 -1.6,-0.5 -9.8,-2.4 -11.4,-2.3 l -5.7,0.6 v 0.8 c 0,0.8 2,2.7 2.4,3.3 0,3.3 0.8,6.8 -1.3,8.4 -2.2,1.6 -2.8,3.4 -3.8,6.3 -0.4,1 -0.9,3.1 -1,4 -0.2,1 -0.2,4 -0.4,4.6 -1.1,2.4 -2.6,4.2 -3.8,6.4 l -5.1,0.5 c -2.1,3.2 -4.6,4.1 -4.6,9.6 v 26.4 c 0.6,0.2 0.4,0.2 0.9,0.2 0.5,0 0.3,-0.1 0.9,-0.2 v -27.5 c 0,-0.7 0.8,-3 1.1,-3.5 0.4,0.2 0.8,0.6 1.3,0.6 0.3,0 1.1,-0.3 1.3,-0.4 l 2.6,0.9 0.8,-0.6 0.6,2.5 c 0.4,0.3 0.4,0.5 0.8,0.5 h 0.4 c 0.5,0 0.6,-0.2 0.6,-0.6 v -0.4 c 0,-1 -1.2,-3 -1.5,-3.7 1.2,-2.5 6.3,-2.6 8.2,-5.8 0.9,-1.6 1.8,-3 2.6,-4.5 0.4,-0.9 2.3,-4.1 2.4,-4.4 h 4.4 c 2.3,0 2.1,2.5 2.6,4.2 0.6,2 2,2 2,4.6 0,2.8 -2.9,7 -4,9 -0.3,0.7 -3.9,8.8 -3.9,8.9 v 2 c 0,3 2.6,9.1 2.6,11.2 v 2.2 c -1.2,0.3 -6.8,2.4 -6.8,3.5 0,0.3 0.4,0.6 0.9,0.6 h 6.8 c 2.3,0 4.5,-1 6.6,-1.1 v -3 c 0,-0.6 -1.1,-2.2 -1.1,-3.7 -0.9,-1.3 -1.8,-6 -1.8,-8.2 0,-3.2 1.2,-5.4 2.5,-7.4 2.5,-4 0.4,-2.3 4.6,-5.1 l 1.8,1.7 c -1,1.8 -2.3,3.7 -2.3,6.4 v 5.9 h 0.4 v 0.6 c 0,0.9 5,9 5.7,10.3 -1.5,2.3 -6.7,1.6 -6.8,5 h 7.5 c 1.2,0 3.3,-1 4.5,-1.4 1.6,-0.5 2.9,-1.1 2.9,-3 0,-0.7 -2.9,-4.6 -3.6,-5.7 -0.3,-0.4 -2.4,-6 -2.4,-6.6 v -0.4 z m -45.3,-47.9 v 0.6 c 0,4.3 3.7,7.9 8.1,7.9 h 0.2 c 3.7,0 7.7,-3.6 7.7,-7 v -2.2 c 0,-3.2 -3.9,-6.8 -7.5,-6.8 h -1.2 c -3.4,0 -7.3,4 -7.3,7.5 z",stroke:!1},o["GR.IN.IC.RAW MATERIAL PRODUCTION/STORAGE"]=[{type:"text",stroke:!1,x:100,y:90,fontsize:30,text:"PS"},{type:"text",stroke:!1,x:100,y:120,fontsize:30,text:"RM"}],o["GR.IN.IC.MINE"]={type:"path",d:"m 105,85 10,10 5,-5 c -5,-5 -10,-5 -15,-5 z M 95,85 85,95 80,90 c 5,-5 10,-5 15,-5 z m -5,5 30,30 m -40,0 30,-30"},o["GR.IN.IC.PROCESSING FACILITY"]=[{type:"text",stroke:!1,x:100,y:90,fontsize:30,text:"PROC"},{type:"text",stroke:!1,x:100,y:120,fontsize:30,text:"FAC"}],o["GR.IN.IC.UTILITY FACILITY"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"UTIL"},o["GR.IN.IC.RESEARCH"]={type:"text",stroke:!1,x:100,y:110,fontsize:30,text:"R&D"},o["GR.IN.IC.TELECOMMUNICATIONS"]={type:"path",d:"m 95,80 10,20 -10,0 10,20",fill:!1},o["GR.IN.IC.ELECTRIC POWER"]={type:"path",d:"m 100,60.5 c -16.4,0 -29.6,13.2 -29.6,29.6 0,12.8 8.3,23.9 19.7,27.8 l 0,19.7 c 3.2,1.2 6.3,1.8 9.9,1.8 3.6,0 6.7,-0.6 9.9,-1.8 l 0,-19.8 c 11.5,-3.9 19.8,-15 19.7,-27.8 0,-16.4 -13.2,-29.6 -29.6,-29.6 z",fill:!1},o["GR.IN.IC.ELECTRIC POWER NUCLEAR"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:40,text:"N"},o["GR.IN.IC.ELECTRIC POWER DAM"]={type:"text",stroke:!1,x:100,y:105,fontsize:40,text:"H"},o["GR.IN.IC.ELECTRIC POWER FOSSIL"]={type:"text",stroke:!1,x:100,y:105,fontsize:40,text:"F"},o["GR.IN.MC.HOME"]={type:"path",d:"m 100,82 18,15 h -4 v 22 h -10 v -15 h -8 v 15 H 86 V 97 h -4 z",stroke:!1},o["GR.IN.IC.ATOMIC ENERGY"]={type:"path",d:e?"M 90.4,119 C 84.2,115 80,109 80,101 l 20,0 -9.6,18 z m 19.6,0 -10,-18 20,0 c 0,8 -4,14 -10,18 z M 100,101 89.7,83.8 c 3,-2 6.5,-3 10.3,-3 4,0 7,1 10,3 L 100,101 Z":"M 89.9,82.5 110,82.7 89.7,117.1 80,99.9 120.1,100 110,117.3 z",fill:!1},o["GR.IN.IC.ATOMIC ENERGY WEAPONS GRADE"]={type:"path",d:e?"M 90.4,119 C 84.2,115 80,109 80,101 l 20,0 -9.6,18 z m 19.6,0 -10,-18 20,0 c 0,8 -4,14 -10,18 z M 100,101 89.7,83.8 c 3,-2 6.5,-3 10.3,-3 4,0 7,1 10,3 L 100,101 Z":"M 89.9,82.5 110,82.7 89.7,117.1 80,99.9 120.1,100 110,117.3 z"},o["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]={type:"path",stroke:!1,d:"m 95.1,109.3 c 0,0 -20.8,4.9 -30.1,6.7 -2.2,0.4 -5.7,0.2 -6.5,-2 -0.4,-1.1 3.3,-6.6 6.5,-7.3 8.7,-1.9 25.7,-5.5 25.7,-5.5 l 3.1,-16.1 4,-0.8 0.3,15.9 25.6,-5.8 6.5,-13.2 5.3,-1.4 -3.3,16.1 14,4.8 -4.3,1.2 -13.7,-2.8 -23.6,6.7 31.6,11.8 -5.5,2.5 z"},o["GR.IN.IC.AIRPORT"]={type:"path",fill:!1,d:"m 74,118 52,-36  m -53,22 h 54"},o["GR.IN.IC.BRIDGE"]={type:"path",d:"m 70,115 10,-10 40,0 10,10 m -60,-30 10,10 40,0 10,-10",fill:!1},o["GR.IN.IC.BASE"]={type:"path",d:"m 75,85 50,30 m -50,0 50,-30",fill:!1},o["GR.IN.IC.SEA SURFACE INSTALLATION, OIL RIG/PLATFORM"]=[{type:"path",d:"m 85,105 0,-40 m 25,40 0,15 m -35,0 0,-15 50,0 0,15",fill:!1},{type:"path",d:"m 85,90 15,0 0,15 -15,0 0,-15"}],o["GR.IN.IC.MILITARY/CIVILIAN.MATERIEL"]=a("MAT"),o["GR.IN.IC.MILITARY/CIVILIAN.PRINTED MEDIA"]=[{type:"circle",cx:100,cy:90,r:10,fill:!1},{type:"circle",cx:100,cy:110,r:10,fill:!1},{type:"path",d:"m 65,100 75,0",fill:!1}],o["GR.IN.IC.INFRASTRUCTURE.BANKING FINANCE AND INSURANCE  INFRASTRUCTURE.ECONOMIC INFRASTRUCTURE ASSET"]=a("ECON"),o["GR.IN.IC.INFRASTRUCTURE.TELECOMMUNICATIONS INFRASTRUCTURE.TELECOMMUNICATIONS"]={type:"path",d:"m 90,105 20,0 0,0 m -25,15 15,-30 15,30 m -55,-40 25,10 0,-10 15,10 15,-10 0,10 25,-10",fill:!1},o["GR.IN.M1.RADIOLOGICAL"]=P("R"),o["GR.IN.M1.COAL"]=P("CO"),o["GR.IN.M1.GEOTHERMAL"]=P("GT"),o["GR.IN.M1.HYDROELECTRIC"]=P("HY"),o["GR.IN.M1.NATURAL GAS"]=P("NG"),o["GR.IN.M1.PETROLEUM"]={type:"path",d:"M 100,79 V 69 L 91,57 h 18 l -9,12",fill:!1},o["GR.IN.M1.CIVILIAN"]=P("CIV"),o["GR.IN.M1.CIVILIAN TELEPHONE"]=P("T"),o["GR.IN.M1.CIVILIAN TELEVISION"]=P("TV"),o["GR.IN.M2.CHEMICAL WARFARE PRODUCTION"]=r("C"),o["GR.IN.M2.NUCLEAR WARFARE PRODUCTION"]=r("N"),o["GR.IN.M2.RADIOLOGICAL WARFARE PRODUCTION"]=r("R"),o["GR.IN.M2.TRANSPORTATION"]={type:"path",d:"M 112,134 A 12.3,12.2 0 0 1 99.7,146 12.3,12.2 0 0 1 87.6,134 12.3,12.2 0 0 1 99.7,122 12.3,12.2 0 0 1 112,134 Z  m -12,-12 v 24  M 88.7,128 111,139  m -22.3,0 22.3,-11",fill:!1},o["GR.IN.M2.ATOMIC ENERGY REACTOR"]=r("A"),o["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]=r("P"),o["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]=r("S"),o["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]=r("B"),o["GR.IN.M2.SHIP CONSTRUCTION"]=r("YRD"),o["GR.IN.M2.WEAPONS GRADE PRODUCTION"]=r("WPN"),o["SOF.IC.UNDERWATER DEMOLITION TEAM"]=a("UD"),o["SOF.M2.ATTACK"]=r("A"),o["SOF.M2.REFUEL"]=r("K"),o["SOF.M2.UTILITY"]=r("U"),o["SOF.M2.VSTOL"]={type:"text",stroke:!1,x:100,y:135,fontsize:20,text:"VSTOL"},o["SOF.M2.COMBAT SEARCH AND RESCUE"]=r(e?"CSAR":"H"),o["ST.IC.ARREST"]={type:"path",d:"m 92.5,100 15,0 m -2.5,-10 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -5,5 0,20 m 20,-15 c 0,11 -9,20 -20,20 -11,0 -20,-9 -20,-20 0,-11 9,-20 20,-20 11,0 20,9 20,20 z",fill:!1},o["ST.IC.ARSON/FIRE"]=e?[{type:"path",d:"m 84.6,101.6 c 1.3,23.1 31,23.2 30.7,-1.9 -1.5,2.1 -4.6,6.5 -8.1,7.3 1.9,-2.4 2.6,-8.5 2.4,-12.9 -1.7,3.4 -4,7.9 -7,7.8 1.7,-4.3 2.7,-9.4 -0.5,-13.7 -0.2,3 0.8,7.1 -1.9,7 -2.7,-0.1 -2.9,-4.4 -1.1,-10.8 -4,4.1 -6.2,9.8 -3.8,17.5 -1.9,-0.2 -4.4,-1.9 -7,-7.8 -1.5,4.9 1.2,9.6 3.2,13.7 -2.4,-1.1 -6,-3 -7,-6.2 z",stroke:!1},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:70,fontsize:25,text:"ASN"}]:{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:35,text:"FIRE"},o["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]={type:"path",d:"m 127,114.4 5,2.7  m -15,-8.1 5,2.7  m -15,-8.1 5,2.7  m -15,-8.16 5,2.76  m -15,-8.19 5,2.72  M 77,87.29 82,90  m -15,-8.14 5,2.71",fill:!1},o["ST.IC.BLACK LIST LOCATION"]=a("BLK"),o["ST.IC.BLACK MARKETING"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:93,fontsize:22,text:"BLK"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:22,text:"MKT"}],o["ST.IC.BOMB"]=a("BOMB"),o["ST.IC.BOOBY TRAP"]={type:"path",d:"m 85,105 15,-25 15,25 m -35,5 c 0,-10 40,-10 40,0 0,10 -40,10 -40,0 z",fill:!1},o["ST.IC.COMPOSITE LOSS"]={type:"path",d:"m 100,85 0,30 m -35,-15 45,0 m 20,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",fill:!1},o["ST.IC.DEMONSTRATION"]=a("MASS"),o["ST.IC.DRIVE-BY SHOOTING"]={type:"path",d:"m 95,85 5,-5 5,5 m -5,-5 0,30 m -15,0 30,0 m 5,5 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z m -30,0 c 0,2.8 -2.2,5 -5,5 -2.8,0 -5,-2.2 -5,-5 0,-2.8 2.2,-5 5,-5 2.8,0 5,2.2 5,5 z",fill:!1},o["ST.IC.DRUG RELATED ACTIVITIES"]=a("DRUG"),o["ST.IC.EXPLOSION"]={type:"path",d:"m 110,55 5,20 15,-10 0,15 15,5 -15,10 15,10 -15,5 5,15 -20,-5 -5,20 -10,-15 -10,20 -5,-25 -20,10 5,-15 L 55,105 70,95 60,85 70,80 70,65 85,75 90,55 100,70 z",fill:!1},o["ST.IC.EXTORTION"]={type:"text",stroke:!1,textanchor:"middle",alignmentBaseline:"middle",x:100,y:103,fontsize:80,text:"$"},o["ST.IC.FOOD DISTRIBUTION"]=[{type:"path",d:"M 111,115 C 96.3,110 96.3,89.5 111,84 100,79.7 87.5,86.3 87.5,99.5 87.5,113 100,119 111,115 Z",fill:!1},{Unknown:{type:"path",d:"M35,120 l130,0 ",fill:!1},Friend:{type:"path",d:"M25,120 l150,0 ",fill:!1},Neutral:{type:"path",d:"M45,120 l110,0 ",fill:!1},Hostile:{type:"path",d:"M50,120 l100,0 ",fill:!1}}[T]],o["ST.IC.GRAFFITI"]={type:"path",d:"m 110,80 c -10,0 -10,10 0,10 10,0 10,10 0,10 -10,0 -10,10 0,10 10,0 10,10 0,10 M 90,80 c -10,0 -10,10 0,10 10,0 10,10 0,10 -10,0 -10,10 0,10 10,0 10,10 0,10",fill:!1},o["ST.IC.GROUP"]={type:"path",d:"m 133,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m -52,-12.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m 23,-7.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},o["ST.IC.HIJACKING (AIRPLANE)"]={type:"path",fill:!!e&&i,d:"m 70,95 0,10 65,0 0,-10 z m 55,10 0,10 5,0 0,-10 z m 0,-10 0,-10 5,0 0,10 z m -45,10 0,15 10,0 0,-15 z m 0,-10 0,-15 10,0 0,15 z"},o["ST.IC.HIJACKING (BOAT)"]={type:"path",fill:(e||!A)&&i,d:"m 105,80 0,20 20,0 z m -5,25 0,-25 m -30,25 10,15 40,0 10,-15 z"},o["ST.IC.GRAY LIST LOCATION"]=a("GRAY"),o["ST.IC.IED"]=a("IED"),o["ST.IC.INDIVIDUAL"]={type:"path",d:"m 108,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},o["ST.IC.INTERNAL SECURITY FORCE"]=a("ISF"),o["ST.IC.KILLING VICTIM"]=[{type:"path",d:"m 108,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},{Unknown:{type:"path",fill:!1,d:"M50,65 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 143,130"}}[T]],o["ST.IC.KILLING VICTIMS"]=[{type:"path",d:"m 133,90 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m -52,-12.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0 m 23,-7.3 c 0,10 -15,10 -15,0 0,-10 15,-10 15,0 z m -8,7.3 0,25 m -10,-20 20,0",fill:!1},{Unknown:{type:"path",fill:!1,d:"M50,65 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 143,130"}}[T]],o["ST.IC.KNOWN INSURGENT VEHICLE"]={type:"path",d:"m 65,95 70,0 m 0,10 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -50,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",fill:!1},o["ST.IC.MASS GRAVE LOCATION"]={type:"path",d:"m 77.5,90 10,0 m -5,-5 0,15 m 7.5,-20 0,30 -15,0 0,-30 z m 22.5,10 10,0 m -5,-5 0,15 m -7.5,-20 0,30 15,0 0,-30 z m -15,20 10,0 m -5,-5 0,20 m -7.5,-25 15,0 0,30 -15,0 z",fill:!1},o["ST.IC.MINE LAYING"]=[{type:"path",d:"m 60,85 80,0 0,30 -80,0 z",fill:!1},{type:"path",d:"m 135,100 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -25,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z m -25,0 c 0,5.5 -4.5,10 -10,10 -5.5,0 -10,-4.5 -10,-10 0,-5.5 4.5,-10 10,-10 5.5,0 10,4.5 10,10 z",stroke:!1}],o["ST.IC.PATROLLING"]={type:"path",d:"m 131,97 0,-14 5,0 c 4,0 4,7 0,7 l -5,0 m -71,15 15,10 M 60,105 75,95 m -15,10 40,0 -15,-15 40,0",fill:!1},o["ST.IC.POISONING"]={type:"path",d:"m 85,95 c 0,-20 30,-20 30,0 0,20 -30,20 -30,0 z m -15,10 60,15 m -60,0 60,-15",fill:!1},o["ST.IC.PSYCHOLOGICAL OPERATIONS"]={type:"path",fill:!!e&&i,stroke:M,d:"m 110,95 10,0 m -10,10 10,0 m -10,10 10,0 m -10,-30 10,0 m -10,-5 -10,10 -30,0 0,20 30,0 10,10 z"},o["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]=[o["ST.IC.PSYCHOLOGICAL OPERATIONS"],{Unknown:{type:"path",fill:!1,d:"M50,65 100,110 100,90 150,135"},Friend:{type:"path",fill:!1,d:"M25,50 100,110 100,90 175,150"},Neutral:{type:"path",fill:!1,d:"M45,45 100,110 100,90 155,155"},Hostile:{type:"path",fill:!1,d:"M57,70 100,110 100,90 143,130"}}[T]],o["ST.IC.RIOT"]=a("RIOT"),o["ST.IC.SAFE HOUSE"]=a("SAFE"),o["ST.IC.SEARCHING"]={type:"path",d:"m 140,105 c -10,0 -5,0 -10,0 -15,0 -5,-15 -20,-15 -15,0 -5,20 -20,20 -15,0 -5,-20 -20,-20 -10,0 -10,10 -10,10 m 70,0 10,5 -10,5",fill:!1},o["ST.IC.SPY"]=a("SPY"),o["ST.IC.SNIPING"]=[{type:"path",d:"m 95,85 5,-5 5,5 m -5,-5 0,40",fill:!1},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:65,fontsize:25,text:"S"}],o["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]={type:"path",d:"m 115,100 c 0,-5 5,-10 10,-10 M 85,100 C 85,95 80,90 75,90 m 5,25 c -0.5,-29.5 40,-30 40,0 z",fill:!1},o["ST.IC.WHITE LIST LOCATION"]=a("WHT"),o["ST.IC.ROBBERY"]=a("ROB"),o["ST.IC.THEFT"]=a("THF"),o["ST.IC.BURGLARY"]=a("BUR"),o["ST.IC.SMUGGLING"]=a("SMGL"),o["ST.IC.SABOTAGE"]=a("SAB"),o["ST.IC.ILLEGAL DRUG OPERATION"]=a("DRUG"),o["ST.IC.SPY"]=a("SPY"),o["ST.IC.WARRANT SERVED"]=a("WNT"),o["ST.IC.POLLING PLACE/ELECTION"]=a("VOTE"),o["ST.IC.NATURAL EVENT"]=a("NAT"),o["ST.IC.GEOLOGIC"]=a("GEOL"),o["ST.IC.HYDRO-METEOROLOGICAL"]=a("HYDR"),o["ST.IC.INFESTATION"]=a("INFS"),o["ST.IC.GRENADE"]=a("G"),o["ST.IC.INCENDIARY"]=a("I"),o["ST.IC.MINE"]=a("M"),o["ST.IC.HOUSE"]={type:"path",fill:!!e&&i,d:"m 70,100 60,0 m -30,-20 -30,20 0,35 60,0 0,-35 -30,-20 z"},o["ST.IC.ROCK THROWING"]={type:"path",d:"m 90,60 25,25 M 70,65 95,90 M 60,80 80,100 m 45,-5 5,15 -5,15 -20,10 -20,-5 -5,-20 5,-5 10,0 5,-10 10,-5 15,5 z"},o["ST.M1.ACCIDENT"]=P("ACC"),o["ST.M1.ASSASSINATION"]=P("AS"),o["ST.M1.CIVILIAN"]=P("CIV"),o["ST.M1.COERCED/IMPRESSED"]=P("UR"),o["ST.M1.COMBAT"]=P("CBT"),o["ST.M1.DEAD BODY"]=P("DB"),o["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]=P("DPRE"),o["ST.M1.DRUG"]=P("DRUG"),o["ST.M1.EVICTION"]=P("EV"),o["ST.M1.EXECUTION (WRONGFUL KILLING)"]=P("EX"),o["ST.M1.EXFILTRATION"]=P("EXFL"),o["ST.M1.FOREIGN FIGHTERS"]=P("FF"),o["ST.M1.GANG"]=P("GANG"),o["ST.M1.GOVERNMENT ORGANIZATION"]=P("GO"),o["ST.M1.HIJACKING/HIJACKED"]=P("H"),o["ST.M1.HOUSE-TO-HOUSE"]={type:"path",fill:!!e&&i,d:"m 110,65 -20,0 0,15 20,0 z m -10,-10 -10,10 20,0 z"},o["ST.M1.IED"]=P("IED"),o["ST.M1.INCIDENT"]=P("INC"),o["ST.M1.INFILTRATION"]=P("INFL"),o["ST.M1.KIDNAPPING"]=P("K"),o["ST.M1.LABRATORY"]=P("LAB"),o["ST.M1.LEADER"]=P("LDR");o["ST.M1.LOOT"]=P("LOOT"),o["ST.M1.MEETING"]=P("MTG"),o["ST.M1.MURDER"]=P("MU"),o["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]=P("NGO"),o["ST.M1.OTHER"]=P("OTH"),o["ST.M1.PIRACY"]=P("PI"),o["ST.M1.PREMATURE"]=P("P"),o["ST.M1.RAID"]=P("RAID"),o["ST.M1.RAPE"]=P("RA"),o["ST.M1.RELIGIOUS"]=P("REL"),o["ST.M1.SPEAKER"]=P("SPK"),o["ST.M1.TARGETED"]=P("TGT"),o["ST.M1.TERRORIST"]=P("TER"),o["ST.M1.TRAFFICKING"]=P("TFK"),o["ST.M1.WILLING RECRUIT"]=P("WR"),o["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]=o["ST.M1.WILLING"]=P("W"),o["ST.M1.FALSE"]=P("FAL"),o["ST.M1.FIND"]=P("FND"),o["ST.M1.FOUND AND CLEARED"]=P("CLR"),o["ST.M1.HOAX (DECOY)"]={type:"path",d:"M 90,75 80,67.5 90,60 90,75 Z m 15,0 -10,-7.5 10,-7.5 0,15 z m 15,0 -10,-7.5 10,-7.5 0,15 z"},o["ST.M1.ATTEMPTED"]=P("ATT"),o["ST.M1.ACCIDENT"]=P("ACC"),o["ST.M1.INCIDENT"]=P("INC"),o["ST.M1.THEFT"]=P("THF"),o["ST.M1.PIRATE"]=[{type:"circle",cx:100,cy:60,r:7,fill:!1},{type:"path",fill:!1,d:"m 82.5,75 35,-15 m 0,15 -35,-15 m 3,7 5,10 m 27,-10 -10,10"}],o["ST.M2.LEADER OR LEADERSHIP"]=r("LDR"),o["ST.M2.RELIGIOUS"]=r("REL"),o["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]=[{type:"path",stroke:!1,d:"m 98.7,66.7 c -3.2,0.7 -6.3,3.7 -6.4,7 0.3,3.6 5.3,2.8 7,0.6 2,-1.2 1.7,-4.5 4.5,-3.7 2.6,-0.6 3.2,3.2 5.9,3.2 1.6,1.5 4.4,-0.6 5.4,1.2 0.7,1.1 1.5,2.2 2.2,3.3 -2,3.1 -1.3,7.9 1.9,10 3.5,1.1 4.8,-3.5 4.1,-6.2 -0.2,-3 -2.5,-5 -5.1,-5.4 -1.5,-1.9 -2.7,-3.4 -1.6,-5.6 -1,-3.3 -5.1,-4.5 -8.2,-4.3 -2.2,0.3 -2.9,2.6 -5.3,1.9 -1.9,0.4 -1.9,-2.8 -4.3,-2 z m 0.2,1.3 c 2.7,0.5 0.9,0.6 -0.6,1.3 -0.5,2.2 3.8,0.4 1.4,2.9 -0.9,1.9 -5.8,4.7 -5.9,1.1 0.1,-2.5 2.7,-4.8 5.1,-5.2 z m 10.3,0.1 c 2.4,-0.5 7.1,2.3 5.6,3.7 -0.8,-2.1 -3,0 -1.2,1.2 -1.7,0.9 -7.4,-1.6 -5.7,-2.4 2.5,0.8 2.8,-2.7 -0,-1.9 -1.4,0.2 1.1,-0.8 1.3,-0.6 z M 81.9,71.6 c -1.8,1.9 -3.6,3.9 -5.5,5.8 -7.5,-0.1 -14,6.2 -15.7,13.2 -0.6,4.2 0.5,8.5 2.8,12 0.7,3.9 -3.2,6.7 -3,10.7 -0.8,7.4 4.8,14.5 11.7,16.8 2.3,-0.4 1.3,1.3 1.4,2 1.5,-0.4 3,-0.8 4.6,-1.2 -0.2,1.5 -0.1,2.7 1.4,1.2 0.9,-0.3 2.3,-2.2 2.9,-1.5 0.2,2.2 1.2,0.1 2,-0.7 0.8,-1.2 1.6,-2.3 2.4,-0.5 1.2,-2.4 4.1,-7.2 -0.8,-7.3 -3.4,2.3 -7.5,4.6 -11.8,3.5 -6.3,-1.5 -10.9,-8.8 -8.2,-14.9 0.4,-3.9 6.8,-3.4 5,-8.2 -1.8,-2.6 -5.7,-2.9 -5.7,-7 -1.5,-7.3 5.6,-14.7 13,-13.7 4.7,0.5 7.4,4.9 10.8,7.6 1.9,1.9 4.1,5.1 5.9,1.4 2.8,-2 4.3,-4.7 1.8,-7.6 C 94.8,79.7 90.9,77.3 88,74.4 86.3,72.9 83.9,72.6 81.9,71.6 z m 3.3,3.8 c 1.6,1.1 2.9,2.1 0.3,3.3 -0.9,3.7 -5.1,-0.5 -1.5,-1.5 0.4,-0.6 0.9,-1.1 1.2,-1.8 z m 34.2,3.1 c 3,1.4 3.9,6.4 1.4,8.8 -2.9,0.1 -3.6,-4.3 -3.1,-6.6 0.1,-2.9 2.5,2.7 2.5,-0.7 -0.2,-0.5 -0.5,-1 -0.8,-1.4 z M 127.3,90.2 c -4.3,0.4 -8.8,-0 -13.1,1 -2.1,1.1 -5.7,1.5 -4.6,4.5 0.1,1.8 0.2,3.6 0.4,5.4 -4.9,4.9 -5.5,13.3 -2.2,19.2 2.4,4.3 7,7 11.8,7.8 3.3,4.9 7.3,-1.3 11.2,-1.7 5.5,-2.5 8.9,-8.5 8.5,-14.5 0.2,-5 -2.4,-10.1 -6.7,-12.8 -0.1,-2.3 -0.2,-4.6 -0.3,-6.9 -1.6,-0.8 -3.4,-1.4 -5.1,-2.1 z M 127.8,92.5 c -0.9,1.7 0.6,3.8 -0.9,4.9 -2.3,0.7 -1.7,-2.4 -1.9,-3.8 -0.6,-1.7 1.9,-0.7 2.8,-1 z m -2.9,8.3 c 4.1,0.9 8,3.7 9.3,7.9 0.9,3.7 0.5,8 -2.3,10.9 -1.7,2 -5.3,4.3 -7.7,3.1 -3.1,-0.8 -5.8,2.1 -8.6,-0.5 -6.9,-4.2 -7.2,-16 0.2,-19.8 2.7,-1.6 6,-1.6 9.1,-1.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 85.1 75.3 C 85 75.8 84.2 76.7 83.9 77.1 C 83.6 77.6 82.4 77.9 82.4 78.6 L 82.4 79 C 82.4 79.4 83.3 80.1 83.6 80.1 L 83.8 80.1 C 84.8 80.1 85 79.1 85.4 78.6 C 85.7 78.2 86.7 77.4 87.2 77 L 85.1 75.3 z M 127.8 92.5 L 125 92.7 L 125.2 96.5 C 125.3 97.5 125.9 97.3 126.5 97.6 C 127.1 97.3 127.8 97.1 127.8 96.3 C 127.8 95.8 127.7 95.6 127.5 95.3 L 127.8 92.5 z"}],o["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]={type:"path",stroke:!1,d:"m 110.6,142.4 0,-28.6 -7.1,0 0,28.6 z m -21.2,0 7.1,0 0,-28.6 -7.1,0 z m 7.1,-28.6 h 7.1 v -11.8 h 24.4 V 77.2 h -6.3 v 18.6 h -18 v -10.7 c 0,-0.9 2.1,-1.2 3,-1.7 0.8,-0.4 2.1,-1.4 2.7,-2 1.5,-1.4 3.2,-3.6 3.8,-5.9 1.6,-6.3 -0.2,-10.6 -3.8,-14.1 -3,-3.1 -9.2,-4.9 -14.3,-2.7 -3.6,1.6 -8.4,6.2 -8.4,11 v 3.2 c 0,2.8 1.9,6.2 3.3,7.7 1,1 1.8,1.7 3,2.5 1,0.6 3.6,1.3 3.6,2.2 v 10.7 H 78.4 v -18.6 h -6.3 v 24.9 h 24.4 v 11.8 h -0 z"},o["AC.IC.SHOOTING"]={type:"path",stroke:!1,d:"m 93.2,89.7 h 16.8 v 9.3 c -2.6,0 -7.3,1.6 -9,1 -2.3,-0.8 -5.4,-2 -7.8,-2.6 v -7.8 l 0,0 z m -30,0 h 26.1 v 9.6 c 0,0.9 4.1,2 5,2.3 1.9,0.6 3.6,1.4 5.5,2 2,0.7 3.4,0.4 6,-0.1 1.6,-0.3 5.7,-0.4 6.6,-0.9 0.6,2.7 4.6,14 4.6,15.2 0,1.6 -1.2,4 -1.3,5.7 l 21.5,0 -8.2,-25.9 7.8,-7.7 c -0.8,-1.6 -4.1,-13.4 -5.2,-13.4 h -68.4 v 13.2 l 0,0 z"},o["AC.IC.FIRE EVENT"]={type:"path",stroke:!1,d:"m 96.5,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.2,1.6 -2.4,3.3 -3.6,5 -1,1.4 -3.1,3.5 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.8,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.6 0.2,9 0.6,2.8 1.4,5 2.5,7.3 0.6,1.2 3,5.5 3.1,6.5 -2.2,-0.5 -7,-4.6 -8.6,-6.2 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.2,8.6 2.4,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.8,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.8 v -1.3 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.9,4.6 -1.4,2.1 -5.2,6.3 -7.8,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 h -0.6 c -0.3,3.9 -1.6,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.3 c 0,-5.1 3,-8.9 3,-12.8 v -0.8 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.2 -3.6,-6.2 v -1.9 l 0,0 z"},o["AC.IC.NON-REsIdENTIAL FIRE"]={type:"path",stroke:!1,d:"m 121.2,122.3 -6.2,0 0,5.9 6.2,0 z m -12.1,0 -6.1,0 0,5.9 6.1,0 z m -12.2,0 -5.9,0 0,5.9 5.9,0 z m -12.3,0 -5.7,0 0,5.9 5.7,0 z m 30.4,-4.8 h 6.1 v -6.2 h -2.5 c -1.2,0 -2.5,1.5 -3.6,1.8 v 4.4 z m -5.9,-6.2 -6.1,0 0,6.2 6.1,0 z m -12.2,0 -5.9,0 0,6.2 5.9,0 z m -12.3,0 -5.7,0 0,6.2 5.7,0 z m 25,-33.4 c 0,-3.4 3.4,-7.4 3.4,-9.1 0,-1.4 -0.8,-4.2 -1.8,-4.6 0,7.1 -8.6,12.8 -8.6,15.7 v 0.4 c 0,0.7 1.9,5.2 2.3,6.6 0.4,1.7 1.4,5.6 1.6,7.3 -6.2,-0.1 -7.3,-9.8 -10.3,-11.8 l -0.3,3 0,4.6 c 0,4.7 3.4,11.4 5.6,13.9 1,1.1 4.2,3.7 5.5,4.3 0.8,0.4 6.3,3 6.6,3 1.4,0 9.2,-7.2 10.5,-8.6 2.5,-2.5 4,-9.6 4,-14.8 v -0.7 l -0.7,-5.7 c -1,0.6 -2.1,5.6 -2.8,7 -1.5,3.2 -1.8,3.1 -5.4,4 -0.3,-12.2 6.7,-8.3 -2.7,-19.1 0,4.9 -0.9,7.9 -4.1,9.6 -1.4,-0.7 -3,-2.7 -3,-4.8 z m -14.8,26.4 h 3.6 c -0.1,-0.6 -0.3,-1.4 -1.1,-1.4 h -1.2 v -2.7 c 0,-0.9 -0.9,-2.4 -1.4,-3 v 7 z m -16.4,-28.6 h 3.9 v 28.6 h 8.9 v -28.6 h 3.6 v 5.4 c 0.3,-0.2 1.4,-1.4 1.4,-1.8 v -5 h -6.4 v 28.6 h -6.4 v -28.6 h -6.1 v 28.6 h -5.2 v 32.7 h 54.8 v -30.7 c -0.4,0.2 -1.1,1 -1.1,1.6 v 27.5 h -52.5 v -29.8 h 5.2 v -28.6 h -0 z"},o["AC.IC.REsIdENTIAL FIRE"]={type:"path",stroke:!1,d:"m 91.5,88.3 -0.7,-3 -30.1,25.2 15.6,0.1 v 25.6 h 50.5 v -25.6 h 12.4 c -0.4,-0.5 -7.6,-5.9 -8,-5.9 -0.3,0 -1.2,1.6 -1.4,1.9 l 1.4,1.4 h -2.4 c -0.7,0.5 -4.9,3.1 -4.9,3.8 v 22.3 h -18.3 v -12.9 h -8.7 v 12.9 h -18.1 v -23.5 h 22.6 l -2.2,-2.7 -30.7,-0.1 L 91.5,88.3 z m 27.6,28 -8.2,0 0,8.5 8.2,0 z m -27,0.2 -8.7,0 0,8.2 8.7,0 z m 11,-36.4 c 0,0.9 2.1,5.3 2.5,6.9 0.4,1.8 1.5,6.1 1.5,7.8 -7.1,-1.6 -6.9,-9.9 -10.3,-12.2 -1.7,7.5 0.8,15.1 3.7,19.5 2.4,3.6 2.6,3.4 6,6 0.4,0.4 7.9,4.3 7.9,4.3 2,0 9.6,-7.1 11.1,-8.6 1.8,-1.8 5.6,-10.8 5.6,-14.4 V 83.5 c 0,-1.9 -0.3,-3.2 -1.4,-4 0,2 -1.8,7 -2.6,8.4 -0.8,1.8 -4.3,4.2 -6.3,4.7 v -1.7 c 0,-4.4 2.4,-6.8 2.4,-10.1 0,-2 -4,-7.2 -5.2,-8 0,5.4 -0.7,8 -4.2,9.8 -1.2,-0.7 -3.1,-2.6 -3.1,-4.4 v -1 c 0,-1.5 1.8,-5.4 2.5,-6.6 2,-3.9 0.5,-3.8 -0.4,-7 h -0.4 c -1.3,5.5 -0.8,4.8 -3.8,8.9 -1,1.4 -5.4,5.9 -5.4,7.5 z"},o["AC.IC.SCHOOL FIRE"]={type:"path",stroke:!1,d:"m 131.3,73 c -4,-1 -17,-7.2 -19.8,-7.2 h -2.4 V 96 h -0.7 c 0,5.6 -3.8,15.3 -6.2,18.6 -2,2.7 -3.7,4.1 -6.2,6.2 -0.8,0.6 -7,4.9 -7,5.4 v 8 h 44.1 V 96 h -20.4 l 0,-14.8 18.8,-8.2 z m -49.2,11.8 c 0,-3 3.6,-8 3.6,-10 0,-1.8 -0.8,-3.9 -2,-4.6 -0.4,0.8 -0.4,3.6 -0.9,5 -0.3,0.7 -1.8,2.7 -2.3,3.5 -1.6,2.3 -3.4,4.2 -5.1,6.4 -2.2,2.8 0,5 1.1,8.2 0.8,2.2 1.4,7.9 2.1,9.4 C 71.9,102.4 70.6,91.8 67.6,89.9 l -0.6,7.6 0.1,0.2 c 0,5 3.6,12.3 5.9,15 1.1,1.3 4.3,3.6 5.9,4.6 1.1,0.7 2.5,1 3.7,1.6 0.4,0.2 3.2,1.9 3.2,1.9 2.1,0 9.9,-7.4 11.5,-9 1.8,-1.8 5.8,-11 5.8,-14.4 v -6.3 c 0,-2.1 -0.4,-2.6 -0.7,-4.2 h -0.8 c -0.2,1.9 -2.2,7.1 -3,8.7 -0.7,1.3 -6.3,5.7 -6.3,3.7 v -1.2 c 0,-3.8 2.4,-7.2 2.4,-10 v -0.8 c 0,-1.5 -4.3,-6.8 -5.4,-7.6 0,2.5 0.1,4.8 -0.8,6.5 -0.5,0.9 -2.5,3.5 -3.6,3.5 -1.1,0 -3.2,-3.4 -3.2,-5.1 z"},o["AC.IC.HOT SPOT"]=[{type:"path",stroke:!1,d:"m 96.3,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.3,1.6 -2.3,3.3 -3.6,4.9 -1,1.3 -3.1,3.4 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.7,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.7 0.3,9 0.6,2.8 1.3,5 2.5,7.3 0.6,1.2 3.1,5.5 3.1,6.5 -2.2,-0.5 -7.1,-4.6 -8.6,-6.1 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.1,8.7 2.5,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.9,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.7 V 99.9 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.8,4.6 -1.4,2.1 -5.2,6.3 -7.9,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 -0.7,8e-4 c -0.3,3.9 -1.7,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.4 c 0,-5.1 3,-8.9 3,-12.8 V 82.6 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.1 -3.6,-6.2 v -1.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 113,126.9 c 0,6.3 -5.1,11.4 -11.4,11.4 -6.3,0 -11.4,-5.1 -11.4,-11.4 0,-6.3 5.1,-11.4 11.4,-11.4 6.3,0 11.4,5.1 11.4,11.4 z"}],o["AC.IC.FIRE ORIGIN"]=[{type:"path",stroke:!1,d:"m 96.3,78.5 c 0,-5.1 4.1,-9.7 4.1,-13 v -0.4 c 0,-1.3 -0,-3.8 -1.1,-4.1 -1,4.5 -3.5,8 -5.9,11.2 -1.3,1.6 -2.3,3.3 -3.6,4.9 -1,1.3 -3.1,3.4 -3.1,5.5 0,1.4 6.1,17.7 3,17.7 -0.1,0 -3.7,-2.5 -4.2,-2.9 -1.4,-1 -2.4,-2.3 -3.3,-3.7 -3.1,-4.6 -2.4,-4.4 -3.8,-10.3 -1.5,0.4 -2.6,5 -2.9,6.9 -0.4,2.4 -0.3,6.7 0.3,9 0.6,2.8 1.3,5 2.5,7.3 0.6,1.2 3.1,5.5 3.1,6.5 -2.2,-0.5 -7.1,-4.6 -8.6,-6.1 -1.5,-1.5 -5.5,-8.3 -5.9,-8.6 0,9.9 5,22.8 9.8,27.6 3.1,3.1 6.3,6.4 10.1,8.7 2.5,1.5 10.5,4.3 14.3,4.3 h 2.4 c 2.9,0 10.8,-3 12.9,-4.2 3.4,-1.9 6.9,-4.7 9,-7.9 4.4,-6.5 8,-15 8,-25.7 V 99.9 l -0.4,-5.8 c -0.7,0.4 -2.2,4.4 -2.5,5.2 -0.5,1.3 -2,3.4 -2.8,4.6 -1.4,2.1 -5.2,6.3 -7.9,6.9 v -1.1 c 0,-4.4 2.8,-8.8 2.8,-12.4 v -1.9 l -1.3,-12.2 -0.7,8e-4 c -0.3,3.9 -1.7,7.9 -3.4,10.5 -1.3,2 -5.3,5.6 -7.7,6.2 -0.2,-0.4 -0.4,-0.6 -0.4,-1.3 v -2.4 c 0,-5.1 3,-8.9 3,-12.8 V 82.6 c 0,-1.5 -2.1,-3.9 -2.9,-5.2 -0.7,-1.1 -2.4,-4.3 -3.5,-4.6 v 1.3 c 0,6.2 -1.4,10.6 -5.6,12.6 -1.1,-1.7 -3.6,-3.1 -3.6,-6.2 v -1.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 99.6 105.9 C 93.3 105.9 88.2 111 88.2 117.3 C 88.2 123.6 93.3 128.7 99.6 128.7 C 105.9 128.7 111 123.6 111 117.3 C 111 111 105.9 105.9 99.6 105.9 z M 105 109.4 L 106.8 111 L 101.2 117.1 L 107.3 123.2 L 105.6 124.9 L 99.5 118.8 L 93.7 125.3 L 91.9 123.6 L 97.8 117.2 L 92.1 111.4 L 93.8 109.8 L 99.5 115.4 L 105 109.4 z"}],o["AC.IC.SMOKE"]=[{type:"path",stroke:!1,d:"m 99.3,69.2 c 0.2,-2.6 4.4,-5.5 7.2,-6 4.2,-0.8 6.9,1.2 9.1,3.3 1.1,1.1 1.9,2.7 2.4,4.3 0.6,2.2 1.9,1.3 4,2.5 2.4,1.4 4.9,4.4 5.6,7.4 5.3,0 10.3,4.8 10.3,9.9 v 1.3 c 0,3 -1.2,4.9 -2.8,6.5 -1.1,1.1 -1.2,1.2 -2.6,2.1 -1.3,0.8 -2.5,0.6 -2.7,2 -0.6,4.6 -4.2,9 -9.4,9 3.3,5 2.3,8.7 -0.6,13 0,4.8 -0.2,6.2 -2.8,8.8 -2.4,2.5 -4.5,2.4 -8.6,2.4 0.7,-1 1.2,-1 2,-2.4 0.6,-1.1 0.8,-1.7 1.4,-2.9 1,-2.2 1.8,-3.7 1.8,-6.8 v -2.1 c 0,-1.4 -0.2,-2.4 -0.8,-3.2 -1.2,5.2 -1.4,6.4 -5.7,8.6 0,-8.3 3.8,-6.8 -1.9,-13.4 0,3.8 -0.2,5.6 -2.7,6.9 -0.8,-0.5 -2.1,-1.7 -2.1,-2.9 v -0.4 c 0,-2 2.5,-5.2 2.5,-6.7 v -0.4 c 0,-1.1 -0.4,-2.1 -1,-2.5 0,2.9 -3.4,7.6 -4.9,9.2 -1.6,1.7 -1.1,2.8 -0.2,5 0.7,1.7 1.1,3.5 1.1,5.8 v 1 c -3.2,-0.3 -4.4,-6.2 -6.1,-8.2 0,3.4 -0.8,6.3 0.4,9.4 0.8,1.9 2.4,5.6 4.4,6.1 v 0.4 l -3.4,0.6 -0.2,-0.1 c -3.4,0 -6.4,-2.4 -7.8,-4.4 -0.8,-1.1 -1.5,-2.7 -1.7,-4.4 -0.3,-2.3 0.6,-3.6 0.6,-5 0,0 -5.1,-4.7 -4.4,-9 l 0.2,-1.7 c -0.4,-0.5 -1.4,-1.4 -2,-2.2 -0.6,-0.8 -1.1,-1.8 -1.6,-2.6 -1.4,0 -2,0.6 -3.2,0.6 h -0.6 c -5.4,0 -10.5,-5.2 -10.5,-10.5 v -0.8 c 0,-4.9 4.1,-9.2 9,-9.2 h 2.1 c 0.8,-3.2 5.7,-6.9 10.1,-5.9 -0.4,-1.5 -1,-2.7 -1,-4.8 v -0.4 c 0,-3.8 3.2,-7.8 6.1,-8.8 1.9,-0.7 3.9,-1 6.1,-0.4 2.3,0.6 3.7,2.2 4.8,2.5 l 0,0 z m -0.4,-1.9 c -1.3,-0.1 -2.9,-2.1 -5.9,-2.1 h -1.9 c -5,0 -10.6,5.8 -10,11.4 l 0.5,3.4 h -0.6 c -4.3,0 -7.1,3.2 -8.6,6.1 -2.3,-1.1 -6.8,1.2 -7.9,2.4 -1.6,1.6 -3.6,4.2 -3.6,7.3 v 1.5 c 0,3.6 2.4,7.3 4.5,8.9 1.8,1.3 2,1.6 4.4,2.4 2.7,0.9 3.7,0.1 5.9,0.2 l 3.1,3.7 c -0.6,1.3 0.4,4.9 0.9,6 0.5,1.2 0.7,1.4 1.4,2.4 0.2,0.4 1.7,2 1.7,2 0,1.1 -0.4,1.4 -0.4,2.7 v 0.2 c 0,6.3 4.8,12 10.7,12 2.1,0 3.6,-0.4 5,-1 2.6,1.4 7.1,3 9.2,-0.1 l 3.4,0.5 c 2.7,0.4 6.8,-2.2 7.9,-3.6 1,-1.4 3.7,-6 2.4,-8.8 1.1,-0.7 2.6,-3.7 2.7,-5.5 0.1,-1.7 0.2,-1.8 -0.1,-3.6 -0.2,-1.4 -0.9,-2.2 -1,-3.2 4,-0.3 8.4,-5.2 8.4,-9.7 2.5,-1.6 3.4,-1.2 5.6,-3.8 1.3,-1.4 2.6,-4.4 2.6,-7 0,-6.3 -4.7,-12 -10.7,-12 -0.9,-4 -4.8,-8.3 -9.2,-8.6 -0.4,-4.4 -5.7,-9.4 -10.7,-9.4 -4.1,-0 -8.9,2.7 -9.6,5.6 l 0,0 z m 15.8,38.4 c 0.5,0 1,0.1 1,-0.4 0,-3.1 -4.1,-6.7 -7.6,-6.7 h -1.9 c -0.6,0 -1,0.8 -0.6,1 0.4,0.2 1.6,0.1 2,0.1 1.2,0 2.6,0.5 3.4,1 2.1,1.6 2.8,2.1 3.5,5.1 z m -34.5,-12.6 v 1.7 c 0,1.4 0.6,2.2 0.6,3.2 0,0 -3.6,3.4 -3.8,5.4 l 0.6,0.2 c 1,-0.6 1.6,-2.6 3,-4 1,-0.9 3.1,-2.2 4.8,-2.2 h 0.6 c 1.3,0 3.6,1 3.6,-0.2 0,-0.9 -2.6,-1 -3.6,-1 h -0.2 c -1.6,0 -3,0.6 -4,1.3 -0.1,-1 -0.6,-1.9 -0.6,-3.2 0,-4.6 3.7,-8.6 8.4,-8.6 h 1 c 1,0 1.5,0.2 2.3,0.4 0.1,-0.2 0.4,-0.6 0.4,-0.7 0,-0.7 -1.8,-1 -2.5,-1 h -1.5 c -4.5,-8e-4 -9.2,4.4 -9.2,8.6 z m 19.1,-15.8 0.6,0.6 c 1.6,-0.9 3.4,-2.3 5.9,-2.3 h 1 c 5.5,0 10.1,4.4 10.1,9.7 v 0.6 c -1.5,-0 -2.6,-0.8 -4.6,-0.8 h -1 c -1.5,0 -4.1,0.3 -4.2,1.7 0.6,0.1 0.4,0.2 0.8,0.2 0.9,0 1.4,-0.6 3,-0.6 h 2.3 c 2.2,0 5.6,1.8 6.6,3.1 2,2.6 1.8,3.7 2.6,7.2 0.5,0 1,0.1 1,-0.4 0,-4 -2.6,-8.1 -5.2,-9.4 0,-6.9 -4.5,-12.4 -11.1,-12.4 h -1.3 c -2.3,0 -5.6,1.6 -6.5,2.9 z"}],o["AC.IC.SPECIAL NEEDS FIRE"]=[{type:"path",stroke:!1,d:"m 75.3,133.9 h 49.4 v -28.9 c -0.6,0.4 -2.4,1.2 -2.4,2 v 24.8 H 77.4 v -30 h -2.2 v 32.1 l 0,0 z M 93,129.1 h 2 c 4.2,0 7.6,-2.4 9.3,-5 l -1.3,-3.5 c -1.2,0.3 -2.1,5.2 -8.6,5.2 h -0.8 c -3.4,0 -6.3,-3.3 -7.2,-6 -0.6,-1.7 -0.6,-3.6 0,-5.4 0.8,-2.5 1.6,-2.4 2.6,-4 l -0.4,-3.4 c -3.2,0.8 -7.1,8 -5.7,12.8 1.2,4.1 5.4,9.2 10.2,9.2 z M 88.9,97.9 v 0.4 c 0,0.8 0.5,1.4 0.8,2 l 1.4,14.7 11.3,0 4.3,10.2 6.2,-2 -1,-3 -3.5,1 C 108,119.9 104.8,111.7 104,111.7 H 94.1 C 94,111 93.8,110.9 93.8,110.1 v -1.1 h 7.6 v -2.4 h -8 l -0.2,-3.7 v -2.2 c 3.4,-0.8 2.7,-6.2 -1.1,-6.2 -1.8,0 -3.2,1.4 -3.2,3.2 z m 19.9,-7.4 v 1 l -0.4,0.3 C 105.1,89.7 101,86.1 101,80.8 99.6,81.7 98.8,84.8 98.8,87.1 v 1.1 c 0,4.5 3,10.7 5,13.3 2.8,3.7 7.4,4.8 11.6,7 1.6,-0.8 9.3,-5.4 10,-6.3 1.3,-1.7 4.2,-9.8 4.2,-12.4 0,-1.9 -0.3,-8.2 -1.3,-8.8 -0.7,2.7 -0.8,4.7 -2.3,6.8 -1,1.4 -3.3,3.5 -5,4 l -0.2,-2.4 v -0.2 c 0,-3 2,-5.4 2,-8.8 0,-1 -3.4,-6.1 -4.1,-6.2 0,1.8 -0.2,4.1 -0.6,5.4 -0.3,1 -1.9,3.4 -2.9,3.4 h -0.6 c -0.4,-1.4 -1.9,-1.7 -1.9,-4.8 V 76.9 c 0,-2.3 2.6,-5.5 2.6,-7.8 l 0,-0.6 -0.3,-2.4 c -1,0.2 -1,1.9 -1.4,2.9 -0.4,1 -1,2 -1.6,2.9 -1.3,1.7 -2.6,3.4 -3.9,5.1 -2,2.8 -2.1,2.7 -1,6.1 0.6,2 1.7,4.8 1.7,7.4 z m 24.3,10.2 -3.3,-2 -1.2,1.9 3.5,2 z m -66.2,0 1,1.9 c 5,-2.7 11,-6.9 16,-10.1 2.7,-1.7 5.2,-3.4 7.8,-5.1 1.4,-0.9 2.6,-1.6 3.9,-2.6 1.8,-1.2 1.9,-1.9 2.4,-4.3 l -31.2,20.2 z"}],o["AC.IC.WILD FIRE"]=[{type:"path",stroke:!1,d:"m 110.8,139.5 c 0.2,-0.5 6.5,-6.2 7.4,-7 2.6,-2.6 5.6,-5.2 7.8,-8.1 3.9,-5.2 8,-15 8,-24 v -6.9 c 0,-1 0,-2.2 -0.8,-2.4 -0.8,3.4 -3.3,7.7 -5.1,10.1 -0.5,0.6 -7.9,8.7 -7.9,6.2 0,-4.7 2.5,-8.4 2.9,-13.4 0.2,-2.9 -0.8,-11.4 -1.4,-14.3 -0.9,0.7 -1.2,4.2 -1.7,5.7 -0.6,1.7 -1.2,3.6 -2.1,5 -0.7,1.1 -6.1,7.2 -7,7.2 -0.7,0 -1.6,-2.9 -1.6,-4.1 0,-4.7 3.3,-9.7 3.3,-13.4 v -0.6 c 0,-2.4 -1.9,-3.6 -3,-5.6 -0.6,-1 -2.7,-4.7 -3.7,-4.8 v 2.9 c 0,2.2 -0.5,5.6 -1.3,7.1 -0.4,0.8 -3.2,4.1 -4,4.1 -1,0 -3.9,-3.9 -3.9,-5.7 v -3.5 c 0,-4.1 4.1,-8.6 4.1,-12.6 v -0.2 c 0,-1.5 -0,-4 -1.4,-4.1 -0.7,8 -12.6,18.7 -12.6,21.8 0,4.4 3.9,9.2 3.9,15.9 v 2.2 c 0,0.7 -0.2,0.8 -0.2,1.4 -0.8,-0.2 -1.4,-1.3 -1.9,-2 -0.7,-0.8 -1.4,-1.1 -2.2,-1.7 -1.5,-1 -2.7,-2.3 -3.8,-3.7 -1.9,-2.5 -4.1,-6.7 -4.1,-10.9 -1.8,0.5 -3.3,6.3 -3.3,8.8 v 3.5 c 0,8.3 5.9,15.1 5.9,18.1 -3.2,-1.7 -6,-3.9 -8.5,-6.4 -1.2,-1.2 -5.5,-8.5 -6.2,-8.7 0,5.7 1.7,10.3 2.6,15.1 0.5,2.3 1.2,5.1 1.9,7.1 1,2.7 1.9,3.3 3.4,5.3 3,4 4.9,6 8.3,9.4 1.5,1.5 2.9,2.9 4.4,4.4 l 4.7,3.4 5.9,2.8 V 129.9 h -13 l 9.9,-11.5 -7.4,-0.1 9.8,-11.1 -6.6,-0.1 10.9,-17.3 0.1,-0.2 11.2,17.5 -6.1,-0 9.4,11 -7.6,0 10.1,11.7 -13.1,0.1 v 13 l 6,-3.4 z"}],o["AC.IC.HAZARDOUS MATERIALS INCIDENT"]=[{type:"path",stroke:!1,d:"m 60.7,100.6 78.5,-0 -39.3,39.2 -39.2,-39.2 z M 127.6,87.8 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 87.8 z M 115.3,75.5 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 75.5 z M 90.8,69.5 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 90.8 V 69.5 z m -12.2,12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 78.6 V 81.7 z m -6.3,6 0,12.2 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 30.8,-24.5 6.2,6.1 c -0.2,0.4 -0.1,-0.1 -0.1,0.4 V 100 h -6.1 V 63.3 z M 56.7,100 100,143.3 143.3,100 100,56.7 56.7,100 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 103.1,63.3 6.2,6.1 c -0.2,0.4 -0.1,-0.1 -0.1,0.4 V 100 h -6.1 V 63.3 z m -30.8,24.5 0,12.2 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 6.3,-6 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 78.6 V 81.7 z m 12.2,-12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 100 H 90.8 V 69.5 z m 24.5,6 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 75.5 z m 12.3,12.3 c 0.6,0.4 6.1,5.9 6.1,6.2 V 100 h -6.1 V 87.8 z m -66.9,12.8 78.5,-0 -39.3,39.2 -39.2,-39.2 z"}],o["AC.IC.CHEMICAL AGENT"]=[{type:"path",stroke:!1,d:"m 100.7,107.7 c -3.2,2e-5 -5.8,1 -7.6,3 -1.9,2 -2.8,4.7 -2.8,8.1 -2e-6,3.4 0.9,6.1 2.8,8.1 1.9,2 4.4,3 7.6,3 1.3,0 2.4,-0.2 3.6,-0.5 1.1,-0.3 2.2,-0.9 3.2,-1.5 l 0.1,-0.1 0,-0.1 0,-3 0,-0.5 -0.3,0.3 c -0.9,0.9 -1.9,1.5 -3,1.9 -1.1,0.4 -2.2,0.7 -3.4,0.7 -2.4,0 -4.1,-0.7 -5.3,-2.1 -1.2,-1.4 -1.9,-3.5 -1.9,-6.2 -4e-6,-2.7 0.6,-4.8 1.9,-6.2 1.2,-1.4 3,-2.1 5.3,-2.1 1.2,2e-5 2.3,0.2 3.4,0.6 1.1,0.4 2.1,1.1 3,1.9 l 0.3,0.3 0,-0.5 0,-3 -0.2,0 0.1,-0.2 c -1,-0.7 -2.1,-1.2 -3.2,-1.5 -1.1,-0.3 -2.3,-0.5 -3.6,-0.5 z M 92.7,64.2 h 14.7 v 33 c 0,8.2 12.9,9.6 12.4,21.8 -0.3,6.8 -7,18.6 -14.3,18.6 h -11 c -6.8,0 -14.6,-13.1 -14.3,-20 0.6,-10.6 12.4,-12.8 12.4,-20.4 v -33 z m -14.7,55 c 0,6.8 7.9,20.2 14.7,20.2 h 14.7 c 8.1,0 14.7,-13 14.7,-22 0,-11.8 -12.8,-13.6 -12.8,-22 V 60.6 H 90.8 V 95.4 c 0,7.8 -12.8,8.7 -12.8,23.9 l 0,0 z"},{type:"path",stroke:!1,fill:E.fillColor.Unknown,d:"m 92.7,64.2 0,33 c 0,7.6 -11.9,9.8 -12.4,20.4 C 79.9,124.5 87.7,137.6 94.5,137.6 l 11,0 c 7.2,0 14,-11.8 14.3,-18.6 0.5,-12.2 -12.4,-13.6 -12.4,-21.8 l 0,-33 -14.7,0 z M 100.7,107.7 c 1.3,2e-5 2.5,0.2 3.6,0.5 1.1,0.3 2.2,0.8 3.2,1.5 l -0.1,0.2 0.2,0 0,3 0,0.5 -0.3,-0.3 c -0.9,-0.9 -1.9,-1.5 -3,-1.9 -1.1,-0.4 -2.2,-0.6 -3.4,-0.6 -2.4,2e-5 -4.1,0.7 -5.3,2.1 -1.2,1.4 -1.9,3.5 -1.9,6.2 -4e-6,2.7 0.6,4.8 1.9,6.2 1.2,1.4 3,2.1 5.3,2.1 1.2,0 2.3,-0.2 3.4,-0.7 1.1,-0.4 2.1,-1.1 3,-1.9 l 0.3,-0.3 0,0.5 0,3 0,0.1 -0.1,0.1 c -1,0.7 -2.1,1.2 -3.2,1.5 -1.1,0.3 -2.3,0.5 -3.6,0.5 -3.2,0 -5.8,-1 -7.6,-3 -1.9,-2 -2.8,-4.7 -2.8,-8.1 -2e-6,-3.4 0.9,-6.1 2.8,-8.1 1.9,-2 4.4,-3 7.6,-3 z"}],o["AC.IC.CORROSIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 102.9,135.4 c 0.8,0 1.4,-0.8 1.4,-1.5 0,-0.7 -0.6,-1.5 -1.2,-1.5 H 102.3 c -0.5,0 -1.2,0.7 -1.2,1.4 v 0.3 c 0,0.8 0.6,1.4 1.4,1.4 H 102.9 z M 96.9,132.5 c 0,0.7 0.6,1.5 1.2,1.5 h 0.6 c 0.8,0 1.4,-0.8 1.4,-1.5 v -0.2 c 0,-0.7 -0.6,-1.5 -1.2,-1.5 H 98.1 c -0.6,0 -1.2,0.9 -1.2,1.5 v 0.2 z m 8.5,-0.9 c 1.3,0 2.2,-1.8 1.1,-2.8 -1,-1 -2.8,-0.2 -2.8,1.1 0,0.8 0.9,1.7 1.7,1.7 z m -6.2,-4.4 c 0,0.6 0.6,1.5 1.2,1.5 h 0.6 c 0.8,0 1.4,-0.6 1.4,-1.4 v -0.6 c 0,-0.5 -0.7,-1.2 -1.4,-1.2 h -0.3 c -0.8,0 -1.5,0.8 -1.5,1.6 z m -0.6,-4.1 c 0.6,0 1.2,-0.8 1.2,-1.5 0,-1 -0.7,-1.7 -1.7,-1.7 -0.6,0 -1.5,0.6 -1.5,1.2 v 0.6 c 0,0.7 0.7,1.4 1.2,1.4 h 0.8 V 123.1 z m 2.4,-2.7 c 0,0.6 0.7,1.5 1.2,1.5 h 0.8 c 0.4,0 1.2,-0.8 1.2,-1.2 v -0.8 c 0,-0.6 -0.8,-1.2 -1.5,-1.2 h -0.1 c -0.8,0 -1.5,0.8 -1.5,1.5 v 0.1 z m -2.7,-3.5 c 0.6,0 1.4,-0.8 1.4,-1.5 v -0.2 c 0,-2.2 -3.2,-1.8 -3.2,-0.3 v 0.8 c 0,0.7 1.1,1.2 1.8,1.2 z m 4.1,-3.6 c 0,2 3.3,1.9 3.2,-0.1 -0.1,-2.3 -3.2,-1.8 -3.2,-0.3 v 0.4 z m 4.7,-16.2 0,2.9 -3,-0.2 0.9,2.8 -1.1,0.1 -1.6,-0.9 -0.4,3 -1,-1.5 -3.3,1 -0.6,-3.2 -2,1.3 -0.6,-1.6 -2.5,0.4 1.5,-2.7 -0.6,-1.5 -22.2,0 0,12.4 59.2,0 0,-12.4 z M 94.3,85.2 v 1.4 c 0,4.4 2.1,8.7 5.7,9.4 3.7,0.8 7,-4.5 7,-8 v -1.5 c 0,-3 -2.1,-8.6 -3,-11.3 -0.5,-1.4 -3.1,-10.6 -3.9,-10.6 -0.8,0 -0.9,4.5 -1.1,5.4 -0.6,2.1 -0.9,3.2 -1.6,5.1 -0.8,2.3 -3.2,7.6 -3.2,10.1 l 0,0 z"}],o["AC.IC.HAZARDOUS WHEN WET"]=[{type:"path",stroke:!1,d:"m 60.6,100.5 78.8,-0 -39.4,39.4 L 60.6,100.5 z M 127.6,87.8 c 0.6,0.4 6.1,5.9 6.1,6.2 v 5.8 H 127.6 V 87.8 z M 115.3,75.5 c 0.6,0.4 6.1,5.9 6.1,6.2 v 18.1 h -6.1 V 75.5 z M 90.8,69.5 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 90.8 V 69.5 z M 78.6,81.7 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 78.6 V 81.7 z m -6.3,6 0,12.1 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 30.8,-24.5 6.2,6.1 c -0.2,0.4 -0.1,-0.2 -0.1,0.4 v 30 h -6.1 V 63.3 z M 56.7,100 100,143.3 143.3,100 100,56.7 56.7,100 z m 41.2,25.3 c 0.2,1 0.6,1.6 1.6,1.8 l -0.8,0.6 c -1.3,-0.6 -1.3,-0.1 -1.7,-1.9 l 0.9,-0.4 z m -2.4,-1 c 0,2.9 1.3,4.9 4.2,4.9 h 0.9 c 1.9,0 3,-1 3.6,-2.3 0.9,-1.8 0.6,-3.1 -0.2,-4.6 -0.8,-1.4 -1.6,-2.3 -2.2,-3.8 -0.5,-1.2 -0.8,-3.8 -1.7,-4.4 C 99.6,118.1 95.5,122.5 95.5,124.2 z m -12.6,-9.4 c 0.4,0.9 0.4,1.4 1.5,1.7 l -0.6,0.6 C 82.2,116.7 82.6,116.5 82,115.3 l 0.9,-0.5 z m 1.6,3.8 H 86 c 2.3,0 3.7,-2.2 3.7,-4.6 0,-1.2 -1.9,-3.9 -2.6,-4.9 -0.9,-1.4 -1.2,-4.7 -2.2,-5.4 -0.2,3 -2.3,5.9 -3.6,8 -1.9,2.9 -0.4,6.9 3.1,6.9 z m 28.4,-3.8 c 0.2,1.6 0.9,1.1 1.5,2 l -0.8,0.3 c -1,-0.2 -1.7,-0.8 -1.8,-1.9 L 112.9,114.8 z m 2,-11.1 c -0.3,3.6 -2.2,5.6 -3.6,8.1 -1.7,3.1 -0.3,6.8 3.2,6.8 h 1.3 c 2.2,0 3.7,-1.7 3.7,-3.9 v -0.9 c 0,-1.4 -1.9,-3.8 -2.6,-4.9 -0.9,-1.4 -0.7,-4.4 -2,-5.2 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 112.9,114.8 c 0.2,1.6 0.9,1.1 1.5,2 l -0.8,0.3 c -1,-0.2 -1.7,-0.8 -1.8,-1.9 L 112.9,114.8 z m -30,0 c 0.4,0.9 0.4,1.4 1.5,1.7 l -0.6,0.6 C 82.2,116.7 82.6,116.5 82,115.3 l 0.9,-0.5 z m 15,10.4 c 0.2,1 0.6,1.6 1.6,1.8 l -0.8,0.6 c -1.3,-0.6 -1.3,-0.1 -1.7,-1.9 l 0.9,-0.4 z m 5.2,-62 6.2,6.1 c -0.2,0.4 -0.1,-0.2 -0.1,0.4 v 30 h -6.1 V 63.3 z m -30.8,24.5 0,12.1 H 66.4 V 94.2 c 0,-0.3 -0,-0.3 -0.1,-0.4 l 6,-6 z m 6.3,-6 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 78.6 V 81.7 z m 12.2,-12.2 c 0,-0.4 5.5,-5.8 6.1,-6.2 V 99.8 H 90.8 V 69.5 z m 24.5,6 c 0.6,0.4 6.1,5.9 6.1,6.2 v 18.1 h -6.1 V 75.5 z m 12.4,12.3 c 0.6,0.4 6.1,5.9 6.1,6.2 v 5.8 H 127.6 V 87.8 z m 11.7,12.6 -78.8,0 39.4,39.4 L 139.4,100.4 z M 85,103.7 c 1,0.7 1.3,4 2.2,5.4 0.6,1 2.6,3.6 2.6,4.9 0,2.4 -1.4,4.6 -3.7,4.6 l -1.5,0 c -3.5,0 -5,-4 -3.1,-6.9 1.3,-2.1 3.4,-5 3.6,-8 z m 29.8,0 c 1.3,0.9 1.2,3.8 2,5.2 0.7,1.1 2.6,3.5 2.6,4.9 l 0,0.9 c 0,2.2 -1.6,3.9 -3.7,3.9 l -1.3,0 c -3.5,0 -4.9,-3.7 -3.2,-6.8 1.4,-2.5 3.4,-4.5 3.7,-8.1 z M 100,114.1 c 0.8,0.6 1.2,3.1 1.7,4.3 0.6,1.5 1.5,2.4 2.2,3.8 0.8,1.5 1.2,2.7 0.3,4.6 -0.6,1.3 -1.7,2.3 -3.6,2.3 l -0.9,0 c -2.8,0 -4.2,-2 -4.2,-4.9 0,-1.7 4.1,-6.1 4.5,-10.1 z"}],o["AC.IC.EXPLOSIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 96.5,104.6 0,0.2 -0.2,0 0,4 0,0.2 0.2,0 3.2,0 0.2,0 0,-0.2 0,-4 0,-0.2 -0.2,0 -3.2,0 z m 2.3,-20 c -1.1,2.4e-5 -2.2,0.1 -3.2,0.5 -1,0.3 -2,0.8 -3,1.4 l -0.1,0.1 0,0.1 0,3 0,0.4 0.3,-0.2 c 1,-0.7 2,-1.2 2.9,-1.6 0.9,-0.4 1.8,-0.5 2.6,-0.5 1.1,2.1e-5 2,0.3 2.6,0.8 0.7,0.5 1,1.2 1,2.1 -10e-6,0.5 -0.1,1 -0.4,1.4 -0.2,0.5 -0.7,1 -1.3,1.5 l -0,0 -1.4,1.4 c -1,0.9 -1.6,1.7 -1.9,2.5 -0.3,0.7 -0.5,1.6 -0.5,2.7 l 0,2.4 0,0.2 0.2,0 3,0 0,-0.2 0.2,0 0,-1.9 c -8e-6,-0.5 0,-1 0,-1.3 0,-0.3 0.1,-0.6 0.1,-0.8 0.1,-0.2 0.2,-0.5 0.4,-0.8 0.2,-0.3 0.5,-0.7 1,-1.1 l 1.4,-1.4 c 1,-0.9 1.6,-1.7 2,-2.5 0.4,-0.8 0.6,-1.6 0.6,-2.4 -2e-5,-1.7 -0.6,-3.1 -1.8,-4.2 -1.2,-1.1 -2.8,-1.6 -4.8,-1.6 z m 4.8,-31.1 -1.5,4.5 -4.3,12.9 -4.5,-7 -1.6,-2.5 -0.3,2.9 -1.3,14.4 -9.5,-10.7 -2.8,-3.2 1.1,4.1 3.4,12.9 -13.1,-0.7 -0.7,-0 -0.3,0.6 -0.1,0.2 -0.4,0.8 0.7,0.5 11.3,8.1 -20.1,1.4 -5.6,0.4 5.4,1.6 18,5.3 -12.3,7.1 -0.8,0.4 0.3,0.8 0.1,0.2 0.3,0.7 0.8,-0.1 16.1,-2 -4.8,8.3 -1.5,2.6 2.7,-1.1 8.8,-3.7 -3.4,14.5 -1.1,4.5 2.8,-3.7 8.9,-11.6 5,19.2 0.2,0.8 0.8,0 0.4,0 0.9,0 0.1,-1 0.9,-18.7 9.2,11.2 2.6,3.2 -0.9,-4 -3.3,-15.2 10.6,5.9 4.7,2.6 -3.4,-4.1 -5.5,-6.6 15.6,4.4 4,1.2 -3.1,-2.9 -10.7,-9.9 13.7,-2.1 4.6,-0.7 -4.5,-1.2 -15.5,-4.3 18.9,-9.6 4.7,-2.4 -5.2,0.5 -17.1,1.6 6.7,-10.8 2,-3.2 -3.3,1.8 -14.6,7.9 5.2,-16.5 1.7,-5.5 -3.5,4.5 -10.6,14 -1.7,-18.8 -0.4,-4.8 z m -1.1,9.7 1.5,16.6 0.2,2.6 1.6,-2 8.7,-11.5 -4.2,13.4 -0.8,2.4 2.2,-1.2 13.4,-7.3 -5.8,9.3 -1.1,1.7 2,-0.2 13.9,-1.3 -16.5,8.4 -2.3,1.2 2.5,0.7 13.5,3.7 -11.2,1.7 -2,0.3 1.5,1.4 9.1,8.4 -14.6,-4.2 -3.1,-0.9 2.1,2.5 4.2,5 -7.8,-4.3 -1.9,-1.1 0.5,2.2 2.9,13.3 -8.2,-10 -1.6,-2 -0.1,2.6 -0.8,16.1 -4.2,-16.3 -0.5,-2 -1.2,1.6 -7.3,9.5 2.8,-11.9 0.4,-1.9 -1.8,0.7 -7.9,3.3 4.3,-7.4 1,-1.7 -2,0.2 -13.9,1.7 10.3,-6 0.5,-0.3 0,-0.6 0,-0.3 0,-0.8 -0.7,-0.2 -14.5,-4.2 17.3,-1.2 2.8,-0.2 -2.3,-1.6 -11,-8 11.5,0.6 1.4,0.1 -0.3,-1.3 -2.7,-10.1 8.2,9.3 1.5,1.8 0.2,-2.3 1.3,-13.8 4,6.3 1.1,1.8 0.7,-2 3.4,-10.3 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 102.5 63.2 L 99 73.5 L 98.4 75.5 L 97.3 73.7 L 93.2 67.4 L 91.9 81.3 L 91.7 83.6 L 90.2 81.8 L 82 72.5 L 84.7 82.7 L 85.1 84 L 83.7 83.9 L 72.2 83.4 L 83.2 91.3 L 85.5 93 L 82.7 93.2 L 65.4 94.3 L 79.9 98.5 L 80.7 98.8 L 80.7 99.5 L 80.7 99.8 L 80.7 100.3 L 80.2 100.7 L 69.8 106.6 L 83.8 104.9 L 85.8 104.7 L 84.8 106.4 L 80.4 113.8 L 88.3 110.6 L 90.1 109.8 L 89.7 111.7 L 86.9 123.6 L 94.2 114.1 L 95.5 112.5 L 96 114.4 L 100.2 130.8 L 101 114.6 L 101.2 112 L 102.8 114 L 111 124 L 108.1 110.7 L 107.6 108.5 L 109.6 109.6 L 117.3 113.9 L 113.2 108.9 L 111.1 106.4 L 114.3 107.3 L 128.9 111.5 L 119.7 103.1 L 118.2 101.7 L 120.3 101.3 L 131.4 99.6 L 117.9 95.9 L 115.4 95.2 L 117.8 94 L 134.3 85.6 L 120.3 86.9 L 118.3 87.1 L 119.4 85.4 L 125.2 76.1 L 111.8 83.3 L 109.6 84.5 L 110.3 82.2 L 114.5 68.8 L 105.8 80.3 L 104.3 82.3 L 104 79.8 L 102.5 63.2 z M 98.8 84.5 C 100.8 84.5 102.4 85.1 103.6 86.1 C 104.8 87.2 105.5 88.6 105.5 90.3 C 105.5 91.2 105.3 92 104.9 92.7 C 104.5 93.5 103.8 94.3 102.8 95.2 L 101.5 96.6 C 101 97.1 100.6 97.4 100.4 97.7 C 100.2 98 100.1 98.2 100 98.5 C 100 98.7 99.9 98.9 99.9 99.2 C 99.8 99.5 99.8 100 99.8 100.5 L 99.8 102.4 L 99.7 102.4 L 99.7 102.7 L 96.6 102.7 L 96.4 102.7 L 96.4 102.4 L 96.4 100 C 96.4 98.9 96.6 98 96.9 97.3 C 97.2 96.6 97.9 95.8 98.8 94.8 L 100.2 93.4 C 100.8 92.9 101.2 92.4 101.5 91.9 C 101.7 91.4 101.9 91 101.9 90.5 C 101.9 89.6 101.5 88.9 100.9 88.3 C 100.2 87.8 99.4 87.5 98.3 87.5 C 97.5 87.5 96.6 87.7 95.7 88.1 C 94.8 88.5 93.8 89 92.8 89.7 L 92.5 89.9 L 92.5 89.5 L 92.5 86.5 L 92.5 86.4 L 92.6 86.3 C 93.6 85.7 94.6 85.3 95.6 85 C 96.7 84.7 97.7 84.5 98.8 84.5 z M 96.5 104.6 L 99.8 104.6 L 99.9 104.6 L 99.9 104.8 L 99.9 108.8 L 99.9 109 L 99.8 109 L 96.5 109 L 96.3 109 L 96.3 108.8 L 96.3 104.8 L 96.5 104.8 L 96.5 104.6 z"}],o["AC.IC.FLAMMABLE GAS"]=[{type:"path",stroke:!1,d:"m 93.3,82.5 c 0,-4.3 13.8,-4.3 13.8,0 v 55.6 c 0,1.3 -4.4,1.2 -5.9,1.2 h -2 c -1.5,0 -5.9,0.1 -5.9,-1.2 V 82.5 l 4e-4,0 z m 5.3,-20.6 h -6.5 v 2.9 h 6.3 v 3.2 h -3.7 v 2 h 3.7 v 5.3 h -4.6 v 4.5 c -1.1,0.3 -2,1.6 -2,3 v 54.8 c 0,3.3 3.7,3.2 7.1,3.2 h 2.4 c 3.4,0 7.1,0.2 7.1,-3.2 V 83.1 c 0,-2.8 -1.8,-2.8 -1.8,-3.7 v -4.1 h -4.7 v -10.4 h 6.3 v -3 h -6.7 v -2.5 h -2.9 v 2.5 l 0,0 z m 21.8,32.3 v 0.6 c 0,2.2 2.3,5.1 1.6,8.1 -1.3,-0.3 -3.1,-2 -3.8,-3 -0.3,-0.4 -0.9,-1.7 -1.2,-2.2 -0.4,-0.9 -0.4,-2.3 -0.7,-2.8 -1.1,0.8 -1.6,3.5 -1.6,5.5 v 0.2 c 0,3.2 2.4,7.5 3.8,9.6 2,3 6.3,3.3 8.4,5.1 1.6,-0.9 6.9,-3.7 7.7,-4.9 0.9,-1.2 3.2,-7.4 3,-9.6 l -0.7,-5.9 h -0.4 c -0,3.2 -2.7,7.6 -5.5,7.9 v -2 c 0,-1.7 1.4,-4 1.4,-6.1 v -0.2 c 0,-0.9 -2.4,-4.4 -3.2,-4.7 0,3.4 -0.3,5.5 -2.5,6.7 -0.8,-0.7 -1.8,-1.6 -1.8,-3.1 v -1.2 c 0,-2.1 2,-4.1 2,-6.1 0,-0.9 -0.1,-1.6 -0.6,-2 -0.9,3.8 -5.9,8.9 -5.9,10.2 z m -52.7,0 v 0.4 c 0,1.2 1.8,4.3 1.8,6.1 v 2.2 c -2.4,-0.2 -5.7,-5 -5.7,-8.1 -1.7,1.1 -1.5,4.3 -1.4,6.7 0.1,2.4 1.3,4.7 2.2,6.3 1.3,2.6 1.6,2.9 4,4.5 0.6,0.4 5.3,2.8 5.9,2.8 1.2,0 6.8,-3.9 7.5,-4.7 0.9,-1 3.3,-7.3 3.1,-9.1 l -0.6,-6.5 h -0.4 c -0.5,2.3 -0.3,3.3 -1.6,5 -0.6,0.8 -2.7,2.7 -3.8,2.8 0,-0.9 -0.2,-0.7 -0.2,-1.4 0,-1.8 1.4,-4.3 1.7,-6.6 0.1,-1 -2.6,-4.6 -3.3,-5 0.4,2 -0.8,6.5 -2.4,6.5 h -0.2 c -0.9,0 -1.8,-2.2 -1.8,-3.4 0,-3.9 2.6,-4.5 1.6,-8.8 -0,0 -2.2,4.5 -2.9,5.4 -0.6,0.6 -3.5,4.3 -3.5,4.9 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 93.3,82.5 c 0,-4.3 13.8,-4.3 13.8,0 v 55.6 c 0,1.3 -4.4,1.2 -5.9,1.2 h -2 c -1.5,0 -5.9,0.1 -5.9,-1.2 V 82.5 l 4e-4,0 z"}],o["AC.IC.FLAMMABLE LIQUID"]=[{type:"path",stroke:!1,d:"m 100.1,135.4 c -7.4,0 -11.3,-5.4 -13.1,-11.1 -2.1,-6.7 -2.4,-14.4 0.8,-20.2 5.9,-10.6 10.7,-21.6 11.9,-36.7 4,4.6 3.6,17.4 6.3,23.9 2.6,6.5 8.9,13.4 8.9,21 v 1.7 c 0,10 -4.5,21.3 -14.2,21.3 h -0.7 v 0 z m -0.6,1.7 h 1.9 c 10.1,0 15.4,-11.7 15.4,-21.9 v -3 c 0,-9.5 -7.7,-15.8 -9.9,-24.1 -2.4,-8.9 -1.7,-21.2 -9.1,-25.1 0,8.6 -1.3,16 -3.6,22.4 -1.2,3.3 -2.4,6.2 -3.6,9.5 -1.2,2.7 -3.1,5.8 -4.5,8.6 -1.4,2.7 -3,6.1 -2.6,10.5 0.4,4.4 0.6,7.6 1.8,11.3 2,5.9 6.7,11.9 14.3,11.9 z M 122,87 v 0.2 c 0,2.3 2.4,5.5 1.7,8.6 -1.3,-0.1 -3.5,-2.2 -4.1,-3.2 -0.5,-0.9 -0.9,-1.3 -1.2,-2.4 -0.3,-0.7 -0.6,-2.6 -0.8,-3 -1.2,0.9 -1.7,4 -1.7,6.1 0,3.2 2.6,8.4 4,10.4 1,1.3 2.5,2.3 4.1,3.1 0.6,0.3 4.8,2.4 5,2.4 0.9,0 7.6,-4.4 8.2,-5.1 0.9,-1.1 3.5,-8 3.3,-10.1 l -0.7,-6.8 h -0.4 c -0.1,3.5 -2.8,8.2 -5.9,8.4 0,0 0.3,-3.5 0.5,-4.4 0.3,-1.3 1,-2.9 1,-4.3 V 86.8 c 0,-1 -2.7,-4.6 -3.4,-5.1 0,3.7 -0.2,6 -2.7,7.2 -0.7,-0.6 -1.9,-1.7 -1.9,-3 v -1.4 c 0,-2.3 2.1,-4.7 2.1,-6.5 l 0,-0.2 -0.3,-1.9 c -1,0.2 -1.1,2 -1.5,2.9 -0.5,0.9 -1.2,1.9 -1.8,2.6 -0.9,1.2 -3.5,4.1 -3.5,5.7 z m -56.6,0 c 0,1.3 1.9,4.7 1.9,7 v 1.9 c -2.6,-0.2 -6.1,-5.2 -6.1,-8.6 -3.4,2.4 -0.7,11.4 0.9,14.1 1.5,2.6 1.8,3 4.4,4.7 0.4,0.3 6.1,3.1 6.2,3.1 1.3,0 4.1,-2.5 5.3,-3.2 2.5,-1.2 2.9,-1.7 4.2,-4.3 0.4,-0.9 1.6,-5.4 1.9,-6.6 0.4,-2.1 -0.5,-5.8 -0.5,-7.9 h -0.5 c -0.3,3.5 -2.9,8.4 -5.9,8.4 -0,-0.9 -0.2,-0.5 -0.2,-1.2 0,-2 1.5,-4.9 1.8,-7.1 0.2,-1.2 -2.7,-5.2 -3.5,-5.4 1,2.1 -1.1,6.1 -2.7,7 -0.9,-0.6 -1.9,-2.2 -1.9,-3.6 v -0.4 c 0,-3.7 2.7,-4.6 1.7,-9.1 -0.5,0.4 -0.8,2 -1.4,3 -0.7,1 -1,1.7 -1.8,2.7 -0.8,1 -3.6,4.2 -3.6,5.5 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 100.1,135.4 c -7.4,0 -11.3,-5.4 -13.1,-11.1 -2.1,-6.7 -2.4,-14.4 0.8,-20.2 5.9,-10.6 10.7,-21.6 11.9,-36.7 4,4.6 3.6,17.4 6.3,23.9 2.6,6.5 8.9,13.4 8.9,21 v 1.7 c 0,10 -4.5,21.3 -14.2,21.3 h -0.7 v 0 z"}],o["AC.IC.FLAMMABLE SOLID"]=[{type:"path",stroke:!1,d:"m 68.6,102 c 0,-2 1.9,-4.2 1.9,-6.3 v -1.5 c 0,-0.6 -0.1,-0.4 -0.4,-0.7 -0.8,3.7 -6.1,9.1 -6.1,10.4 0,1.6 1.9,4.6 1.9,8.2 -2.6,-0.2 -5.9,-4.9 -5.9,-8 -0.8,0.9 -1.5,2.6 -1.5,4.3 0,4.4 1.7,8.1 3.5,10.6 0.8,1.2 7,5.2 8.7,5.2 1.1,0 6.7,-3.7 7.3,-4.4 0.9,-1.2 3.2,-6.8 3.2,-8.6 0,-1.6 -0,-6.6 -0.9,-7.2 -1.1,4.8 -1.5,5.9 -5.4,8.1 0,-4.3 1.3,-5.7 1.3,-8.2 v -0.4 c 0,-0.1 -2.8,-4.4 -3,-4.6 0,2.4 -0.7,6.7 -2.6,6.7 -1,8e-4 -2,-2.4 -2,-3.7 z m 60.3,-0.4 c 0,-1.7 2.2,-4.5 2.2,-6.3 0,-0.7 -0.2,-1.6 -0.7,-1.9 -0.9,3.7 -5.9,8.9 -5.9,10.2 v 0.4 c 0,1.9 1.5,3.7 1.5,6.1 v 2.2 c -2.3,-0.6 -5.6,-4.9 -5.7,-8 -1,0.7 -1.5,3 -1.5,4.8 v 1.1 c 0,2.8 2.5,7.7 3.8,9.5 2,2.7 6.4,3.1 8.4,4.8 2.1,-1.1 3.1,-1.8 5.1,-2.9 2.6,-1.6 2.2,-1.5 3.5,-4.3 0.7,-1.4 1.7,-4.5 1.8,-6.2 0.1,-1.5 -0.1,-6.4 -0.9,-7 -0.8,3.5 -2.1,7.1 -5.4,8 -0,-0.7 -0.2,-0.7 -0.2,-1.5 v -0.2 c 0,-1.8 1.7,-4.9 1.5,-6.4 -0.1,-0.8 -2.5,-4.8 -3,-5.1 0,2.8 -0.5,6.7 -3,6.7 -0.4,-1.3 -1.5,-1 -1.5,-3.9 z m -35.6,1.9 v -20 l 20,-0.4 v 19.4 l -20,1 z m -13.9,-7.6 0,-16.8 10.8,4 v 19.8 c -1.2,-0.7 -10.9,-6.2 -10.9,-7 z m 1.5,-18.4 c 5.7,0 11.4,0 17.2,0 2.1,0 12.1,3.1 13.2,3.9 l -3.7,0.3 H 92.6 c -0.9,0 -11.1,-3.7 -11.7,-4.1 z m -3.5,-1.5 0,14.7 -0.3,6.7 c 2.2,1.2 5.3,3 7.5,4.5 1.9,1.2 5.5,4 8.1,4 7.6,0 15.3,-1.1 23.1,-1.1 l -0,-23.6 c -1,-0.5 -14.8,-5.4 -15.2,-5.4 l -3.9,-0.1 -19.3,0.4 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 80.9,77.5 c 5.7,0 11.4,0 17.2,0 2.1,0 12.1,3.1 13.2,3.9 l -3.7,0.3 H 92.6 c -0.9,0 -11.1,-3.7 -11.7,-4.1 z m -1.5,18.4 0,-16.8 10.8,4 v 19.8 c -1.2,-0.7 -10.9,-6.2 -10.9,-7 z m 13.9,7.6 v -20 l 20,-0.4 v 19.4 l -20,1 z"}],o["AC.IC.NON-FLAMMABLE GAS"]=[{type:"path",stroke:!1,d:"m 92.7,81.3 c 0,-4.6 14.7,-4.6 14.7,0 v 59.4 c 0,1.4 -4.7,1.3 -6.3,1.3 h -2.1 c -1.6,0 -6.3,0.1 -6.3,-1.3 V 81.3 z m 5.7,-22 h -7 v 3.2 h 6.7 v 3.3 h -4 v 2.1 h 4 v 5.7 h -4.8 v 4.8 c -1.1,0.3 -2.1,1.7 -2.1,3.1 v 58.6 c 0,3.5 4,3.3 7.6,3.3 h 2.5 c 3.6,0 7.6,0.2 7.6,-3.3 V 81.9 c 0,-3 -1.9,-3 -1.9,-4 v -4.4 h -5 v -11.1 h 6.7 v -3.1 h -7.2 v -2.7 h -3.1 v 2.7 l -4e-4,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 92.7,81.3 c 0,-4.6 14.7,-4.6 14.7,0 v 59.4 c 0,1.4 -4.7,1.3 -6.3,1.3 h -2.1 c -1.6,0 -6.3,0.1 -6.3,-1.3 V 81.3 z"}],o["AC.IC.ORGANIC PEROXIDE"]=[{type:"path",stroke:!1,d:"m 132.1,128.2 v 6.2 l -36.6,2.2 v -6.7 l 0.6,0.1 36,-1.7 z m -63.8,-11.1 c 2.6,1.7 26.1,12.1 26.1,13.2 v 5.9 l -0.1,0.2 -26,-14.7 v -4.6 z m 61.1,10 c -4.7,0 -33,2.1 -34.6,1.5 -1.8,-0.7 -23.8,-11.4 -24.4,-12 3.8,0 7.5,0 11.3,0 2.9,0 8.8,-0.8 10,1.1 l -9,0.6 2.1,0.7 v 0.4 h -1.2 l -1.8,0.2 c 2,1.3 18.3,5.2 22.4,5.2 h 1.9 c 4.8,0 9.2,-1.3 13,-1.4 0.7,0 9.9,3.3 10.4,3.7 z m -25.4,-23.2 1.1,9.4 5.4,-6.8 -2.5,8.2 7.7,-4.3 -3.7,5.9 8.4,-0.8 -9.2,4.7 8.1,2.6 -14.4,1.7 c -3.3,0.2 -19,-3.7 -20.5,-4.8 l 10.3,-0.6 -6.2,-4.5 6.8,0.1 -1.7,-5.9 5.1,5.2 0.7,-7.5 2.6,3.9 2.1,-6.6 z m 0.7,-2.2 -0.1,-0.6 h -0.3 l -1.8,6.2 -0.4,-0 -2.4,-3.7 -0,2.1 -0.7,-1.1 -0.6,6.2 -4.9,-5.4 0.6,2.6 -1.5,-1.2 1.8,6.2 -2.5,0 -4,-0.2 1.5,1.1 -2.4,-0.1 1.5,1.4 h -21.3 c -0.1,0.5 -0.2,0.5 -0.2,1.1 v 5 c 0,1.6 4.8,3.7 6.2,4.4 2.3,1.3 4.6,2.4 6.9,3.8 4.4,2.7 9.2,5 13.7,7.6 1.8,1.1 6.8,0.5 9.6,0.2 2.8,-0.3 7.2,-0.2 9.9,-0.7 2.8,-0.5 7,-0.4 9.9,-0.7 2.7,-0.4 7.4,-0.6 10,-0.7 v -7.9 c 0,-0.9 -5.3,-2.4 -6.4,-2.8 -1.6,-0.5 -5.7,-1.9 -6.8,-2.6 l 2.9,-0.3 -8.4,-2.2 0,-0.4 9.2,-4.7 -1.5,0.2 1.7,-1.1 -10,1 3.9,-6.6 -8.1,4.7 2.9,-10 -6.4,8.4 -1.1,-11.1 -0.6,1.9 z m 1.1,-6.2 c -5.6,0 -9.6,-3.4 -9.6,-9 v -1.1 c 0,-4.8 9,-12.5 9,-21.1 2.8,3.2 2.2,7.6 4.3,11 1.2,1.9 5.3,7.8 5.3,9.9 v 1.1 c 0,5.3 -3.7,9.2 -9,9.2 z m -10.9,-10 v 1.1 c 0,13.7 21.1,13.2 21.1,0.8 v -2.1 c 0,-3.5 -4.5,-8.3 -5.9,-11.7 -2.2,-5.1 -1.1,-8.8 -6.2,-11.6 0,11.2 -9,17.6 -9,23.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 105.7,95.5 c -5.6,0 -9.6,-3.4 -9.6,-9 v -1.1 c 0,-4.8 9,-12.5 9,-21.1 2.8,3.2 2.2,7.6 4.3,11 1.2,1.9 5.3,7.8 5.3,9.9 v 1.1 c 0,5.3 -3.7,9.2 -9,9.2 z m -1.8,8.4 1.1,9.4 5.4,-6.8 -2.5,8.2 7.7,-4.3 -3.7,5.9 8.4,-0.8 -9.2,4.7 8.1,2.6 -14.4,1.7 c -3.3,0.2 -19,-3.7 -20.5,-4.8 l 10.3,-0.6 -6.2,-4.5 6.8,0.1 -1.7,-5.9 5.1,5.2 0.7,-7.5 2.6,3.9 2.1,-6.6 z m -35.6,13.2 c 2.6,1.7 26.1,12.1 26.1,13.2 v 5.9 l -0.1,0.2 -26,-14.7 v -4.6 z m 63.8,11.1 v 6.2 l -36.6,2.2 v -6.7 l 0.6,0.1 36,-1.7 z m -2.7,-1.1 c -4.7,0 -33,2.1 -34.6,1.5 -1.8,-0.7 -23.8,-11.4 -24.4,-12 3.8,0 7.5,0 11.3,0 2.9,0 8.8,-0.8 10,1.1 l -9,0.6 2.1,0.7 v 0.4 h -1.2 l -1.8,0.2 c 2,1.3 18.3,5.2 22.4,5.2 h 1.9 c 4.8,0 9.2,-1.3 13,-1.4 0.7,0 9.9,3.3 10.4,3.7 z"}],o["AC.IC.OXIDIZER"]=[{type:"path",stroke:!1,d:"m 80.9,135.3 0,0.2 0,4.2 0,0.2 0.2,0 40.7,0 0.2,0 0,-0.2 0,-4.2 0,-0.2 -0.2,0 -40.7,0 -0.2,0 z m 6.5,-20.7 c 0,-7.4 6.1,-14 13.4,-14 h 1.1 c 7.5,0 13.6,6.6 13.6,14 0,7.1 -6.2,13.9 -13.2,13.9 h -1.9 c -6.8,-0 -13,-6.8 -13,-13.9 z m 12.8,-35.9 c -0.7,0 -2.1,-2.1 -2.3,-2.9 -0.3,-1.2 -0.4,-3 0,-4.4 0.5,-2.1 2.8,-5.9 2.8,-7.5 0,-1.1 -0.1,-3 -1.3,-3.1 -1,4.4 -2.1,4.9 -4.1,8 -1,1.5 -4.7,5.8 -4.7,7.3 v 0.4 c 0,2.4 3.1,8.1 2.7,10.5 l -0.2,1.7 c -3.5,-0.8 -8.1,-7.3 -8.1,-12 -1.4,0.1 -2.5,4.4 -2.5,6.1 v 2.9 c 0,5.7 3.3,8.3 4.2,12 -2.7,-1.4 -4,-2.2 -5.9,-4.4 -1.1,-1.2 -3.7,-5.6 -4.1,-5.9 -1.1,2.4 1.7,10.3 2.4,12.1 0.7,1.7 1.4,3.5 2.3,5 1.1,1.8 2.2,2.6 3.2,4.1 0,1.7 -0.5,2.4 -0.6,4.7 -0,1.8 -0,2.6 0.2,4.6 0.2,2.1 2.1,6.1 3.2,7.3 2.4,2.6 2.4,2.8 5.6,4.8 2,1.3 4.9,2.2 8.1,2.2 h 0.6 c 6.4,0 11.4,-3.5 14.2,-7.2 3.8,-5.2 3.8,-9.9 2.2,-16.7 3.5,-6.6 5.9,-9.3 5.9,-19.7 v -0.4 l -0.4,-4 c -0.1,0 -3.3,6.2 -3.8,7 -1,1.5 -3.7,4.8 -5.7,5 0.1,-3.2 2.1,-6.2 2.1,-9.4 v -2.2 l -1.1,-8 c -1,0.7 -1.5,5.9 -3,7.7 -0.4,0.5 -5.6,5.5 -5.6,3.6 v -1.7 c 0,-3.1 2.1,-6.3 2.1,-9 v -1.3 c 0,-0.8 -3.9,-6.5 -4.6,-6.9 0,2.3 -0.2,4.4 -0.7,6.2 -0.3,1.1 -2,3.7 -3,3.7 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 87.4,114.5 c 0,-7.4 6.1,-14 13.4,-14 h 1.1 c 7.5,0 13.6,6.6 13.6,14 0,7.1 -6.2,13.9 -13.2,13.9 h -1.9 c -6.8,-0 -13,-6.8 -13,-13.9 z"}],o["AC.IC.RADIOACTIVE MATERIAL"]=[{type:"path",stroke:!1,d:"m 83.7,130.4 c -10.1,-5.6 -16.6,-17 -16.4,-28.5 l 17.8,-0 c -0.2,5 3.1,10.7 7.5,13.1 l -9,15.4 z m 49.1,-28.2 c 0.2,11.5 -6.4,22.9 -16.4,28.5 l -9,-15.4 c 4.4,-2.4 7.7,-8.1 7.6,-13.1 l 17.8,0 z M 83.5,73.8 c 9.9,-5.9 23,-5.9 32.9,0 l -8.9,15.5 c -4.3,-2.6 -10.9,-2.6 -15.1,0 l -8.9,-15.5 z m 26.5,28.5 c 0,5.5 -4.4,9.9 -9.9,9.9 -5.5,0 -9.9,-4.4 -9.9,-9.9 0,-5.5 4.4,-9.9 9.9,-9.9 5.5,0 9.9,4.4 9.9,9.9 z"}],o["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]=[{type:"path",stroke:!1,d:"m 101.2,128.4 -2.1,0 0,12.6 2.1,0 z m 26.5,0.6 -8.7,-8.6 -1.2,1.2 8.7,8.7 z m -45,-7.5 -1.3,-1.3 -8.8,8.8 1.3,1.4 z m 55.5,-19.7 -12.2,0 0,1.9 12.2,0 z m -63.3,0 -13.1,0 0,1.9 12.8,0 z m 52.8,-25.3 -1.3,-1.2 -9,8.7 1.5,1.5 z m -46.1,9.1 1.4,-1.5 -9.3,-9.2 -0,0.2 -1.2,1.3 z m 19.5,-26.5 -2.1,0 0,9.7 2.1,0 z M 91.7,88 v 0.6 c 0,0.5 1.4,4.3 1.7,5.1 0.7,2.2 0.7,3.4 0.7,5.7 -1.2,-0.1 -4.4,-3 -5.1,-4 -1.7,-2.5 -1.7,-3.4 -2.5,-6.7 -0.9,0.7 -1.9,3.8 -1.9,5.5 v 2.3 c 0,5.6 3.6,8.4 3.8,11.1 -0.9,-0.2 -4.8,-3.2 -5.4,-3.8 -0.7,-0.8 -3.3,-5.3 -3.8,-5.4 0,3.9 1.1,6.9 2.1,9.7 0.6,1.5 1.2,2.9 1.7,4.2 0.8,2.2 1.4,2 2.6,3.5 2.9,3.6 9.4,8.3 15.7,8.3 h 0.8 c 2.2,0 6.4,-1.7 7.9,-2.6 2.4,-1.3 4.5,-2.7 6,-4.8 2.8,-3.8 5.3,-9.3 5.3,-16 v -2.7 l -0.2,-2.3 h -0.4 c -1.1,4.7 -4.2,8.4 -8,10.5 0,-3.6 1.3,-5.3 1.9,-8.4 0.4,-2.4 -1,-6.9 -1,-9.2 -0.4,0.3 -1.2,5.4 -2.5,7 -0.3,0.4 -5.1,5.2 -5.1,3.1 v -2.1 c 0,-3 1.9,-4.8 1.9,-8.2 0,-0.8 -3.5,-6 -4.1,-6.3 l 0.1,0.9 c 0,1.2 -0.4,4.1 -0.7,5 -0.2,0.5 -2.3,3 -2.6,3 -1.2,0 -2.5,-2.9 -2.5,-4.4 v -1.1 c 0,-2.9 2.8,-6.1 2.6,-8 l -0.5,-2.9 c -0.5,0.4 -1.2,3 -1.6,3.9 -0.6,1.3 -1.4,2.2 -2.2,3.2 C 95.4,82.4 91.7,87.1 91.7,88 z"}],o["AC.IC.UNEXPLODED ORDNANCE"]=a("UXO"),o["AC.IC.TOXIC INFECTIOUS MATERIAL"]=[{type:"path",stroke:!1,d:"m 104.6,116.2 c 0,-3.6 0.9,-4.6 1.5,-7.3 l -2.5,-1.2 c -2.4,2.1 -4.4,1.6 -6.8,0 l -2.5,1.4 c 0.2,2.6 2,3.9 1.5,8.7 -0.4,3.1 -1.1,5.8 -2.6,7.8 -2.9,3.9 -7,7.4 -13.7,7.4 h -1 c -4.7,0 -10.2,-3.2 -12,-6 l -1.2,0.6 c 3.3,4.9 11.4,10 19.8,10 h 0.2 c 6.4,0 10.9,-2.7 14.8,-5.3 3.7,2.5 7.6,5 13.8,5 h 3 c 3.8,0 8.2,-1.6 10.6,-3.2 1.8,-1.2 6.7,-4.5 7.2,-6.6 -1.1,-0.3 -0.5,-0.5 -1.3,-0.5 -0.5,0 -1.7,1.9 -2.2,2.3 -0.8,0.6 -1.8,1.1 -2.6,1.6 -1.4,0.9 -4.7,1.8 -7,1.8 h -1.8 c -7.9,0 -15.3,-7.7 -15.3,-15.8 v -0.8 z m 2.3,3.5 2.5,4.3 c 3.2,-0.8 7.7,-5.2 9.3,-7.8 2.2,-3.7 3.5,-7.8 3.5,-13.8 h -5.5 c 0.1,5.2 -0.1,7.2 -2.5,10.8 -1.2,1.8 -1.7,2.1 -3.2,3.6 -1,1 -3.6,2.2 -4.1,2.9 z m -28.6,-13.8 c 0,7.4 6.8,16.7 12.5,18 l 2.3,-4.5 c -6.5,-3.4 -9.5,-8 -9.5,-17.1 h -5.3 v 3.5 z m -2.5,-17 v 1 c 0,0.5 -5,3.2 -5.8,3.8 -1.6,1.1 -3.5,3.2 -4.7,4.8 -2.8,3.6 -4.8,8.1 -4.8,14.2 0,4.4 1,6 1.8,9.4 l 1.2,-0.6 c -0.1,-1.5 -0.8,-2.3 -0.8,-4 v -2 c 0,-7.8 7.9,-15.6 16,-15.6 h 1.8 c 2.6,0 5.9,1.3 7.5,2.2 2.2,1.3 3.6,3.6 5.3,4.8 l 2.3,-1 v -1.8 c 0,-2 1.6,-3.9 3.3,-4.3 v -3 c -7.6,-0.2 -15.3,-7.8 -15.3,-15.5 v -1.5 c 0,-4.1 2.1,-8.6 4.2,-10.6 1.3,-1.2 2.5,-2.3 4,-3.2 0.8,-0.5 5.1,-1.5 5.1,-2.5 v -1 c -6.6,1.6 -11.7,3.8 -15.4,8.5 -4.3,5.5 -5.7,9 -5.7,17.9 l 0,0 z m 27.6,-25.4 c 0,0.6 4.2,2.1 5,2.5 1.2,0.6 3.5,2.4 4.2,3.5 2.1,2.9 4.3,6 4.3,11 0,8.2 -7.4,16.3 -15.6,16.3 v 3 c 2.3,0.2 4.4,3.4 3.3,5.8 0.6,0.2 2.5,1.2 2.5,1.2 0.7,0 5,-7 14.3,-7 h 0.2 c 4.5,0 9,2.6 11.1,5 1.7,1.9 5.3,7.6 4.8,11.4 l -0.8,5.5 1.2,0.6 c 0.1,-0.9 0.8,-2.3 1.1,-3.6 0.3,-1.2 0.4,-3 0.4,-4.4 v -3.3 c 0,-8.4 -8.3,-18.8 -15,-20.3 0,-5 0.4,-6.4 -0.9,-10.9 -0.9,-2.8 -2.6,-6.4 -4.3,-8.3 -5.1,-5.3 -7.5,-7 -15.9,-9 v 1 l -4e-4,0 z m -15.8,22.6 2.8,4.8 c 3,-1.6 4.8,-3.3 9.5,-3.3 h 0.5 c 5.8,0 6.9,2.6 9.7,3.2 l 2.6,-4.7 c -9.5,-5 -15.7,-5 -25.1,0 z"}],o["AC.IC.TOXIC GAS"]=[{type:"path",stroke:!1,fill:!!e&&i,d:"m 90.2,102.3 c 0.6,-1.9 5.7,-1.9 11.3,-0 5.6,1.9 9.6,4.9 9,6.8 -0.6,1.9 -5.7,1.9 -11.3,0 -5.6,-1.9 -9.6,-4.9 -9,-6.8 z m 7.7,-22.2 c 10e-7,3.7 -1.7,6.7 -3.8,6.7 -2.1,-2e-6 -3.8,-3 -3.8,-6.7 2e-6,-3.7 1.7,-6.7 3.8,-6.7 2.1,0 3.8,3 3.8,6.7 z m 17,2.2 c 0,4.1 -2.8,7.3 -6.3,7.3 -3.5,2e-6 -6.3,-3.3 -6.3,-7.3 0,-4.1 2.8,-7.3 6.3,-7.3 3.5,0 6.3,3.3 6.3,7.3 z m -7.9,49.6 c -1,2.9 -8.5,2.9 -16.6,0 -8.2,-2.9 -13.9,-7.6 -12.9,-10.5 1,-2.9 8.5,-2.9 16.6,-0 8.2,2.9 13.9,7.6 12.9,10.5 z"},{type:"path",stroke:!1,d:"M 107.5 64.3 C 102.2 64.2 96.9 67.1 92.8 71.6 C 90.6 73.6 89.2 76.8 89.2 80.4 C 89.2 83 90 85.4 91.2 87.3 C 92.1 89.9 92.7 91.8 92.7 94.5 L 92.4 96.7 L 90.7 101.6 C 92.3 100.5 96.7 100.7 101.5 102.3 C 106.6 104 110.4 106.7 110.5 108.6 L 112 104.2 C 115.9 104 120.5 96.9 122.7 87.6 C 124.9 77.9 123.5 69.3 119.8 67.9 C 118.4 66.6 116.1 65.5 112.8 65.3 C 111.1 64.6 109.3 64.3 107.5 64.3 z M 94.1 73.4 C 94.4 73.4 94.6 73.4 94.8 73.5 C 95.1 73.6 95.3 73.8 95.6 73.9 C 96.2 74.4 96.8 75.3 97.2 76.3 C 97.5 77.1 97.7 77.9 97.8 78.7 C 97.9 79.2 97.9 79.6 97.9 80.1 C 97.9 80.5 97.9 81 97.8 81.4 C 97.7 82.3 97.5 83.1 97.2 83.8 C 96.9 84.7 96.4 85.4 95.9 85.9 C 95.6 86.2 95.2 86.5 94.8 86.6 C 94.7 86.6 94.6 86.7 94.5 86.7 C 94.3 86.7 94.2 86.7 94.1 86.7 C 93.8 86.7 93.6 86.7 93.3 86.6 C 93 86.5 92.6 86.2 92.3 85.9 C 92.2 85.8 92.1 85.7 92 85.6 C 91.6 85.1 91.2 84.5 91 83.8 C 90.8 83.4 90.7 83.1 90.6 82.7 C 90.4 81.9 90.3 81 90.3 80.1 C 90.3 79.1 90.4 78.3 90.6 77.5 C 90.7 77.1 90.8 76.7 91 76.3 C 91.2 75.6 91.6 75 92 74.5 C 92.2 74.3 92.4 74.1 92.6 73.9 C 92.9 73.8 93.1 73.6 93.3 73.5 C 93.6 73.4 93.8 73.4 94.1 73.4 z M 108.6 75 C 110.4 75 112.1 75.9 113.3 77.3 C 113.3 77.4 113.4 77.5 113.5 77.6 C 113.5 77.6 113.5 77.6 113.5 77.7 C 113.6 77.8 113.7 78 113.8 78.2 C 113.8 78.3 113.9 78.3 113.9 78.4 C 114 78.5 114 78.5 114 78.6 C 114.1 78.7 114.2 78.8 114.2 79 C 114.3 79.1 114.3 79.3 114.4 79.4 C 114.4 79.5 114.5 79.5 114.5 79.6 C 114.5 79.7 114.6 79.9 114.6 80 C 114.6 80.1 114.6 80.2 114.7 80.3 C 114.7 80.4 114.7 80.6 114.8 80.8 C 114.9 81.3 114.9 81.8 114.9 82.3 C 114.9 84.6 114 86.6 112.6 88 C 112 88.6 111.3 89 110.5 89.3 C 110.3 89.4 110.1 89.5 109.9 89.5 C 109.5 89.6 109 89.7 108.6 89.7 C 108.2 89.7 107.7 89.6 107.3 89.5 C 107.3 89.5 107.3 89.5 107.3 89.5 C 107.1 89.5 106.9 89.4 106.7 89.3 C 105.9 89 105.2 88.6 104.6 88 C 104 87.4 103.5 86.6 103.1 85.8 C 102.9 85.4 102.7 85 102.6 84.5 C 102.5 84.3 102.5 84 102.4 83.8 C 102.4 83.5 102.4 83.3 102.3 83.1 C 102.3 82.8 102.3 82.6 102.3 82.3 C 102.3 82 102.3 81.8 102.3 81.5 C 102.3 81.5 102.4 81.5 102.4 81.4 C 102.4 81 102.5 80.5 102.6 80.1 C 102.6 80.1 102.6 80.1 102.6 80 C 103.4 77.1 105.8 75 108.6 75 z M 88.8 104 C 86.6 104 84.8 104.4 83.9 105.2 L 83.8 105.2 L 83.7 105.3 C 83.4 105.6 83.2 105.9 83.1 106.2 C 83 106.5 83 106.8 83 107.2 L 78.1 120.5 C 80.2 118.5 86.9 118.7 94.2 121.3 C 101.2 123.8 106.4 127.7 107.1 130.6 L 111.8 117.8 C 112.2 117.5 112.5 117.2 112.7 116.8 C 113.7 113.8 107.9 109.1 99.8 106.2 C 95.7 104.8 91.8 104 88.8 104 z M 82 120.8 C 79 120.8 76.9 121.5 76.4 123 C 75.4 125.9 81.1 130.7 89.3 133.6 C 97.4 136.5 104.9 136.5 105.9 133.6 C 107 130.6 101.2 125.9 93 123 C 89 121.5 85 120.8 82 120.8 z M 86.1 125.6 C 87.4 125.5 89.4 125.9 91.5 126.6 C 94.8 127.8 97.2 129.6 96.9 130.6 C 96.5 131.6 93.5 131.5 90.1 130.3 C 86.8 129.1 84.4 127.3 84.7 126.3 C 84.9 125.9 85.4 125.7 86.1 125.6 z "}],o["AC.IC.AFTERSHOCK"]=[{type:"path",stroke:!1,d:"m 99,62.5 -0,0 -0,0 -0.9,0 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.1 -0,0 -0,0 -0.9,0.2 -0,0 -0,0 -0.7,0.1 0.6,2.7 0.7,-0.1 0,-0 0.8,-0.1 0,-0 0.8,-0.1 0,0 0.8,-0.1 0,0 0.9,-0.1 0,0 0.9,-0.1 0,0 0.9,-0.1 0,0 0.9,-0 0,0 0.9,-0 0,0 0,0 0.9,0 0,0 0.9,0 0,0 0.1,0 0.2,-2.8 -0.1,-0 -0,0 -0,0 -0.9,-0 -0,0 -0,0 -1,-0 -0,0 -0,0 z m 8.8,3.6 0.2,0 0,0 0.8,0.2 0,0 0.8,0.2 0,0 0.8,0.2 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.3 0,0 0.8,0.4 0,0 0,0 0.7,0.4 0,0 0.1,0 1.3,-2.5 -0.1,-0.1 -0,-0 -0,0 -0.8,-0.4 -0,-0 -0,0 -0.8,-0.4 -0,0 -0,-0 -0.8,-0.4 -0,-0 -0,0 -0.8,-0.4 -0,0 -0,-0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 -0,0 -0,-0 -0.9,-0.3 -0,0 -0,0 -0.9,-0.3 -0,0 -0,0 -0.9,-0.2 -0,0 -0,-0 -0.9,-0.2 -0,0 -0,0 -0.2,-0.1 z m -22.7,-0.7 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0,0 -0.8,0.5 -0,0 -0,0 -0.8,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.7,0.5 -0,0 -0,0 -0.1,0.1 1.7,2.2 0.1,-0.1 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.5 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0.7,-0.4 0,-0 0,0 0.8,-0.4 0,-0 0.8,-0.3 0,-0 0.8,-0.3 0,-0 0.3,-0.1 -1,-2.6 z m 36.9,7.3 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.5 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0.6,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.5,0.6 0,0 0.4,0.5 2.3,-1.7 -0.4,-0.6 -0,-0 0,-0 -0.6,-0.7 -0,-0 0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.7 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0,0 -0.7,-0.6 -0,-0 -0,0 -0.7,-0.6 -0,-0 -0,-0 -0.7,-0.6 -0,-0 -0,-0 -0.6,-0.5 z m -51,2.7 -0,0 -0,0 -0.6,0.7 -0,0 -0,0 -0.6,0.7 0,0 -0,0 -0.6,0.7 0,0 -0,0 -0.5,0.7 -0,0 -0,0 -0.5,0.7 -0,0 -0,0 -0.5,0.7 -0,0 0,0 -0.5,0.7 -0,0 0,0 -0.5,0.8 0,0 -0,0 -0.4,0.8 -0,0 0,0 -0.4,0.8 0,0 -0,0 -0.3,0.6 2.5,1.3 0.3,-0.6 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.4,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.7 0,-0 0.5,-0.6 0,-0 0.5,-0.6 0,-0 0.5,-0.6 0,-0 0.5,-0.5 -2.1,-1.9 z m 60.9,9.4 0.1,0.1 0,0 0,0 0.3,0.7 0,0 0.3,0.7 0,0 0.3,0.8 0,0 0.3,0.8 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0.2,0.8 0,0 0,0.2 2.8,-0.5 -0,-0.3 -0,-0 0,-0 -0.2,-0.9 0,-0 0,-0 -0.2,-0.9 0,-0 -0,-0 -0.2,-0.9 0,-0 -0,-0 -0.2,-0.9 0,-0 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 0,-0 -0,-0 -0.3,-0.8 -0,-0 -0,-0 -0.4,-0.8 -0,-0 0,-0 -0.1,-0.2 z m -68.8,4.9 -0,0 0,0 -0.2,0.9 -0,0 0,0 -0.2,0.9 -0,0 0,0 -0.2,0.9 0,0 0,0 -0.2,0.9 0,0 -0,0 -0.1,0.9 0,0 0,0 -0.1,0.9 -0,0 0,0 -0.1,0.9 0,0 -0,0 -0.1,0.9 0,0 0,0 -0.1,0.9 0,0 0,0 -0,0.9 0,0 0,0 -0,0.9 0,0 0,0 0,0 1.4,-0 0.3,0 1.1,0 0,-0 0,-0.9 0,-0 0,-0.9 -0,0 0.1,-0.8 0,-0 0.1,-0.9 -0,0 0.1,-0.9 0.1,-0.9 -0,0 0.1,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.2,-0.8 0,-0 0.1,-0.2 -2.7,-0.8 z m 73,10.3 -0.6,0 0,0 0,0 -0,0.9 0,0 -0,0.9 0,0 -0.1,0.8 0,0 -0.1,0.9 0,0 -0.1,0.9 -0.1,0.9 0,0 -0.1,0.8 0,0 -0.2,0.8 -0,0 -0.2,0.8 -0,0 -0.2,0.8 0,0 -0.2,0.8 -0,0 -0.1,0.2 2.7,0.8 0.1,-0.2 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.2,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0.1,-0.9 0,-0 0,-0 0,-0.9 0,-0 0,-0 0,-0.9 -1.4,-0 1.4,-0 0,-0 z m -73.9,6.4 0,0.3 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.2,0.9 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.3,0.8 0,0 0,0 0.4,0.8 0,0 0,0 0.1,0.2 2.5,-1.3 -0.1,-0.1 -0,-0 -0.3,-0.7 -0,-0 -0.3,-0.7 -0,-0 -0.3,-0.8 -0,-0 -0.3,-0.8 -0,-0 -0.3,-0.8 -0,-0 0,-0 -0.3,-0.8 -0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 -0,-0 -0.2,-0.8 0,-0 -0,-0.2 z m 69.4,9.4 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.4,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.7 -0,0 -0.5,0.6 -0,0 -0.5,0.6 -0,0 -0.5,0.6 -0,0 -0.5,0.6 2.1,1.9 0.5,-0.6 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.6,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.7 0,-0 0,-0 0.5,-0.8 0,-0 0,-0 0.4,-0.8 0,-0 0,-0 0.4,-0.8 0,-0 0,-0 0.3,-0.6 -2.5,-1.3 z m -62.8,6.1 0.4,0.6 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.7 0,0 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0,0 0.6,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.7,0.6 0,0 0,0 0.6,0.5 1.7,-2.2 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.5 -0,-0 -0.6,-0.6 -0,-0 -0,-0 -0.6,-0.6 -0,-0 -0.6,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.5,-0.6 -0,-0 -0.4,-0.5 z m 53.1,5.4 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.5 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0.7,0.4 -0,0 -0,0 -0.8,0.4 -0,0 -0.8,0.3 -0,0 -0.8,0.3 -0,0 -0.3,0.1 1,2.6 0.4,-0.1 0,-0 0,0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,-0 0,0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,0 0,-0 0.8,-0.4 0,-0 0,0 0.8,-0.5 0,0 0,-0 0.8,-0.5 0,-0 0,0 0.7,-0.5 0,0 0,-0 0.7,-0.5 0,-0 0,0 0.7,-0.5 0,-0 0,-0 0.7,-0.5 0,-0 0,-0 0.1,-0.1 -1.7,-2.2 z m -40.4,5.6 0.1,0.1 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.4 0,0 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0,0 0.8,0.3 0,0 0,0 0.9,0.3 0,0 0,0 0.9,0.3 0,0 0,0 0.9,0.2 0,0 0,0 0.9,0.2 0,0 0,0 0.2,0.1 0.6,-2.7 -0.2,-0 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.2 -0,-0 -0.8,-0.3 -0,-0 -0,0 -0.8,-0.3 0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.3 -0,-0 -0.8,-0.4 -0,0 -0,-0 -0.7,-0.4 -0,-0 -0.1,-0 z m 25.6,1.1 -0,0 -0.8,0.1 -0,0 -0.8,0.1 -0,0 -0.8,0.1 0,-0 -0.9,0.1 0,-0 -0.9,0.1 -0,0 -0.9,0.1 -0,0 -0.9,0 -0,0 -0.9,0 -0,0 -0,0 -0.9,-0 -0,0 -0.9,-0 -0,0 -0.1,0 -0.2,2.8 0.1,0 0,0 0,0 0.9,0 0,0 0,0 1,0 0,0 0,0 1,-0 0,0 0,0 0.9,-0 0,0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.1 0,-0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.1 0,-0 0,0 0.9,-0.1 0,0 0,0 0.9,-0.2 0,0 0,0 0.7,-0.1 -0.6,-2.7 z m -7.2,-58.9 -0,1.2 0.1,0 0,0 1.3,0 0,-0 1.3,0.1 1.1,0.1 0.1,0 0,0 1.1,0.2 0.1,0 0.7,0.1 0.7,-3.1 -0.7,-0.2 -0,0 -0,-0 -1.3,-0.2 -0,0 -0,-0 -1.3,-0.2 -0,0 -0,0 -1.3,-0.1 -0,0 -0.1,0 -1.3,-0 -0,0 -0,0 -0,0 z m -5.5,-1.4 -0,0 -0,0 -1.3,0.3 -0,0 -0,0 -1.2,0.3 -0,0 -0,0 -1.2,0.4 -0,0 -0,0 -0.9,0.3 1.1,3 0.8,-0.3 0.1,-0 0,0 1.1,-0.4 0,-0 1.1,-0.3 1.2,-0.3 0.1,-0 1.1,-0.2 -0.6,-3.1 z m 14.8,4.4 0.2,0.1 0.1,0 1.1,0.5 1,0.5 0.1,0 1,0.5 0,0 0,0 0.9,0.6 0.1,0 0.5,0.4 1.8,-2.6 -0.6,-0.4 -0,-0 -0,-0 -1.1,-0.7 -0,-0 -0,-0 -1.1,-0.6 -0,-0 -0,-0 -1.1,-0.6 -0,-0 -0,-0 -1.1,-0.5 -0,-0 -0,-0 -0.3,-0.1 z m -23.6,-1.1 -0,0 -0,0 -1.1,0.7 -0,0 -0,0 -1,0.7 -0,0 -0,0 -1,0.8 -0,0 -0,0 -0.9,0.8 -0,0 -0,0 -0.8,0.7 2.2,2.4 0.7,-0.7 0.1,-0.1 0.8,-0.7 0,-0 0,-0 0.9,-0.7 0.1,-0 0.9,-0.6 0.1,-0 0.9,-0.6 0,-0 0,-0 -0.4,-0.6 -1.2,-2.2 z m 31.5,6.2 0.1,0.1 0,0 0,0 0.8,0.8 0.1,0.1 0.7,0.8 0.1,0.1 0.7,0.8 0,0 0,0.1 0.6,0.9 0,0.1 0,0 0.5,0.7 2.7,-1.8 -0.5,-0.8 -0,-0 -0,-0 -0.7,-1 -0,-0 -0,-0 -0.8,-0.9 -0,-0 -0,-0 -0.8,-0.9 -0,-0 -0,-0 -0.9,-0.9 -0,-0 -0,-0 -0.1,-0.1 z m -40.1,1.8 -0,0 -0,0 -0.7,1 -0,0 -0,0 -0.6,1.1 -0,0 -0,0 -0.6,1.1 -0,0 -0,0 -0.5,1.1 -0,0 -0,0 -0,0.1 2.4,1 0.5,0.3 0,-0 0.5,-1 0,-0.1 0,-0 0.5,-0.9 0,-0.1 0.6,-0.9 0.6,-1 0,-0 0,-0.1 0.6,-0.8 -2.6,-1.9 z m 45.4,5.9 0.4,1.1 0,0.1 0.3,1 0,0.1 0.3,1.1 0.3,1.1 0.2,1 3.1,-0.6 -0.2,-1.1 0,-0 -0,-0 -0.3,-1.2 -0,-0 -0,-0.1 -0.3,-1.2 -0,-0 -0,-0 -0.4,-1.2 -0,-0 -0,-0 -0.5,-1.1 z m -49.6,3.8 -0,0 0,0 -0.2,1.3 0,0 -0,0 -0.2,1.3 -0,0 0,0 -0.1,1.3 0,0 0,0.1 -0,1.3 0,0 0,0 0,0 1.9,-0 1.3,0 0,-0.1 0,-0 0,-1.2 0.1,-1.1 0,0 0.1,-1.2 0,-0.1 0,-0 0.2,-1.1 0.2,-0.9 -3.1,-0.7 z m 52.8,5.5 -1.2,-0 0,0.1 0,0 -0,1.2 -0.1,1.1 -0,0 -0.1,1.2 0,0 -0,0.1 -0.2,1.1 -0.2,0.9 3.1,0.8 0.2,-0.9 0,-0 0,-0 0.2,-1.3 0,-0 0,-0 0.2,-1.3 0,-0 0,-0 0.1,-1.3 0,-0 0,-0.1 0,-1.3 -1.6,-0 1.6,-0 0,-0 z m -53,4.3 0.2,1.1 0,0 0,0 0.3,1.2 0,0 0,0.1 0.3,1.2 0,0 0,0 0.4,1.2 0,0 0,0 0.5,1.1 3,-1.2 -0.4,-1 -0,-0.1 -0.3,-1 -0,-0.1 -0.3,-1.1 -0.3,-1.1 -0.2,-1 z m 49.9,4.9 -0.5,1 -0,0.1 -0,0 -0.5,1 -0,0.1 -0.6,0.9 -0.6,1 -0,0 -0,0.1 -0.6,0.8 2.6,1.9 0.6,-0.9 0,-0 0,-0 0.7,-1 0,-0 0,-0 0.6,-1.1 0,-0 0,-0 0.6,-1.1 0,-0 0,-0 0.5,-1.1 0,-0 0,-0 0,-0 -2.2,-0.9 -0.8,-0.3 z m -46,5 0.5,0.8 0,0 0,0 0.7,1 0,0 0,0 0.8,0.9 0,0 0,0 0.8,0.9 0,0 0,0 0.9,0.9 0,0 0,0 0.1,0.1 2.2,-2.3 -0.1,-0.1 -0,-0 -0,-0 -0.8,-0.8 -0.1,-0.1 -0.7,-0.8 -0.1,-0.1 -0.7,-0.8 -0,-0 -0,-0.1 -0.6,-0.9 -0.1,-0.1 -0.5,-0.7 z m 40,3.3 -0.1,0.1 -0.8,0.7 -0,0 -0,0 -0.9,0.7 -0.1,0 -0.9,0.6 -0.1,0 -0.9,0.6 0,-0 -0.1,0 0,0 -0,0 0.3,0.4 1.3,2.4 0,-0 0,-0 0,-0 1.1,-0.7 0,-0 0,-0 1,-0.7 0,-0 0,-0 1,-0.8 0,-0 0,-0 0.9,-0.8 0,-0 0,-0 0.8,-0.7 -2.2,-2.4 z m -32.6,4.4 0.6,0.4 0,0 0,0 1.1,0.7 0,0 0,0 1.1,0.6 0,0 0,0 1.1,0.6 0,0 0,0 1.1,0.5 0,0 0,0 0.3,0.1 1.1,-3 -0.2,-0.1 -0.1,-0 -1.1,-0.5 -1,-0.5 -0.1,-0 -1,-0.6 0,0 -0.9,-0.6 -0.1,-0 -0.5,-0.4 z m 24.5,0.3 -0.1,0 -1.1,0.3 -0.1,0 -1.1,0.3 -1.2,0.3 -0.1,0 -1.1,0.2 0.6,3.1 1.2,-0.2 0,0 0,-0 1.3,-0.3 0,0 0,-0 1.2,-0.3 0,-0 0,-0 1.2,-0.4 0,-0 0,-0 0.9,-0.3 -1.1,-3 z m -14.8,3.9 0.7,0.2 0,0 0,0 1.3,0.2 0,0 0,0 1.3,0.2 0,0 0,0 1.3,0.1 0,0 0.1,0 1.3,0 0,0 0,0 0,0 -0.1,-1.6 0,-0.1 0,-1.5 -0.1,0 -1.3,-0 0,0 -1.3,-0.1 -1.1,-0.1 -0.1,-0 -0,0 -1.1,-0.2 -0.1,-0 -0.7,-0.1 z m 6.3,-43.1 -0.4,0 0.1,4 0.3,-0 0.1,0 0.1,0 0.6,0 0.1,0 0.6,0 0.1,0 0.6,0.1 0.1,0 0.6,0.1 0.7,0.1 0.1,0 0.1,0 0.6,0.2 0.5,0.2 0.1,0 0.5,0.2 0.1,0 0,0 0.5,0.2 0.1,0 0.4,0.2 1.8,-3.6 -0.5,-0.3 -0,-0 -0.1,-0 -0.7,-0.3 -0.1,-0 -0.1,-0 -0.7,-0.3 -0,-0 -0.1,-0 -0.7,-0.2 -0.1,-0 -0,-0 -0.7,-0.2 -0.1,-0 -0.1,-0 -0.7,-0.2 -0.1,-0 -0.1,-0 -0.8,-0.1 -0,-0 -0.1,-0 -0.8,-0.1 -0.1,-0 -0.1,0 -0.8,-0.1 -0.1,0 -0.1,0 -0.8,-0 -0.1,-0 z m -5.1,0.7 -0.1,0 -0,0 -0.7,0.2 -0.1,0 -0.1,0 -0.7,0.3 -0,0 -0.1,0 -0.7,0.3 -0.1,0 -0,0 -0.7,0.3 -0,0 -0,0 -0.7,0.4 -0,0 -0.1,0 -0.6,0.4 -0,0 -0,0 -0.6,0.4 -0,0 -0,0 -0.6,0.4 -0,0 -0,0 -0.6,0.5 -0,0 -0,0 -0.5,0.5 -0,0 -0,0 -0.2,0.2 2.9,2.8 0.1,-0.1 0.1,-0.1 0.4,-0.4 0.1,-0.1 0.4,-0.3 0,-0 0.1,-0.1 0.4,-0.3 0.5,-0.4 0.1,-0.1 0.6,-0.3 0,-0 0.5,-0.3 0.1,-0 0.5,-0.3 0.1,-0 0.5,-0.2 0,0 0.1,-0 0.6,-0.2 0,-0 0.5,-0.2 0.1,-0 0.1,-0 -1.1,-3.9 z m 14.2,6.7 0.4,0.3 0.5,0.5 0.1,0.1 0.3,0.4 0.1,0.1 0.3,0.4 0.1,0.1 0.3,0.4 0,0 0,0.1 0.3,0.4 0.1,0.1 0.3,0.5 0,0 0,0.1 0.3,0.5 0,0.1 0.2,0.5 0,0.1 0.2,0.5 0,0.1 0,0 0.2,0.6 3.8,-1.3 -0.2,-0.7 -0,-0.1 -0,-0.1 -0.3,-0.7 -0,-0.1 -0,-0 -0.3,-0.7 -0,-0.1 -0,-0 -0.3,-0.7 -0,-0.1 -0,-0 -0.4,-0.6 -0,-0 -0,-0.1 -0.4,-0.6 -0,-0 -0,-0.1 -0.4,-0.6 -0,-0.1 -0,-0 -0.5,-0.6 -0,-0 -0,-0 -0.5,-0.5 -0,-0 -0,-0 -0.5,-0.5 -0,-0 -0,-0 -0.5,-0.4 z m -24.4,1.4 -0,0 -0,0.1 -0.3,0.7 -0,0 -0,0.1 -0.3,0.7 -0,0 -0,0.1 -0.3,0.7 -0,0.1 -0,0.1 -0.2,0.7 -0,0.1 -0,0.1 -0.2,0.7 -0,0.1 0,0.1 -0.2,0.7 -0,0.1 -0,0.1 -0.1,0.7 -0,0.1 0,0.1 -0.1,0.8 0,0.1 -0,0.1 -0.1,0.8 0,0.1 0,0.1 -0,0.8 0,0.1 0,0.1 0,0.3 4,-0.1 -0,-0.2 0,-0.1 0,-0 0,-0.7 0,-0.6 0,-0.1 0,-0 0.1,-0.5 0.1,-0.6 0,-0.1 0.1,-0.5 0,-0 0,-0.1 0.1,-0.5 0.2,-0.6 0,-0.1 0,-0 0.2,-0.5 0.3,-0.6 0.1,-0.1 0.3,-0.5 0,-0.1 0,-0 0,-0 -3.5,-2 z m 28.7,7.6 0,0.5 0,0.1 0,0 -0,0.6 -0.1,0.7 -0,0.1 0,0.1 -0.1,0.6 -0.1,0.5 -0,0.1 -0.1,0.5 0,0 -0,0.1 -0.1,0.5 -0,0.1 -0.2,0.5 -0,0 -0,0.1 -0.2,0.5 -0,0 -0,0.1 -0.2,0.5 -0,0.1 -0.3,0.5 -0,0.1 -0,0 -0.2,0.3 3.5,2 0.2,-0.4 0,-0.1 0,-0 0.3,-0.7 0,-0 0,-0.1 0.3,-0.7 0,-0 0,-0.1 0.3,-0.7 0,-0.1 0,-0.1 0.2,-0.7 0,-0 0,-0.1 0.2,-0.7 0,-0.1 0,-0.1 0.2,-0.7 0,-0.1 0,-0.1 0.1,-0.7 0,-0.1 0,-0.1 0.1,-0.8 0,-0.1 0,-0.1 0.1,-0.8 0,-0.1 0,-0.1 0,-0.8 -2,-0.1 2,-0.1 -0,-0.6 z m -30.1,5.3 0.1,0.3 0,0.1 0,0 0.2,0.7 0,0.1 0,0.1 0.3,0.7 0,0.1 0,0 0.3,0.7 0,0.1 0,0 0.3,0.7 0,0 0,0.1 0.4,0.6 0,0 0,0.1 0.4,0.6 0,0 0,0 0.4,0.6 0,0 0,0 0.5,0.6 0,0 0,0 0.5,0.5 0,0 0,0 0.5,0.5 0,0 0,0 0.2,0.2 2.7,-2.9 -0.2,-0.1 -0.1,-0.1 -0,-0 -0.4,-0.4 -0.1,-0.1 -0.4,-0.4 -0,-0.1 -0,-0 -0.3,-0.4 -0.1,-0.1 -0.4,-0.5 -0.3,-0.4 -0.1,-0.1 -0.3,-0.5 -0,-0 -0,-0.1 -0.3,-0.5 -0.1,-0.1 -0.2,-0.5 -0,-0.1 -0,-0 -0.2,-0.5 -0,-0.1 -0,-0.1 -0.2,-0.6 -0,-0.1 z m 25.8,4.8 -0.1,0.1 -0.4,0.3 -0,0 -0.1,0.1 -0.4,0.3 -0.1,0.1 -0.5,0.3 -0,0 -0.1,0 -0.5,0.3 -0.1,0 -0,0 -0.6,0.3 -0.5,0.3 -0.1,0 -0.5,0.2 -0,0 -0.1,0 -0.5,0.2 -0.1,0 -0.5,0.2 -0.5,0.1 1.1,3.9 0.5,-0.1 0,-0 0.1,-0 0.7,-0.2 0.1,-0 0,-0 0.7,-0.3 0.1,-0 0.1,-0 0.7,-0.3 0.1,-0 0,-0 0.7,-0.3 0.1,-0 0,-0 0.7,-0.4 0,-0 0,-0 0.6,-0.4 0,-0 0.1,-0 0.6,-0.4 0,-0 0,-0 0.6,-0.5 0,-0 0,-0 0.6,-0.5 0,-0 0,-0 0.5,-0.5 -2.7,-2.9 z m -15.5,1.8 -1.9,3.5 0.1,0.1 0,0 0,0 0.7,0.3 0,0 0.1,0 0.7,0.3 0.1,0 0,0 0.7,0.3 0.1,0 0.1,0 0.7,0.2 0,0 0.1,0 0.7,0.2 0,0 0.1,0 0.8,0.2 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0.1 0.1,0 0.1,0 0.8,0 0.1,0 0.1,0 0.1,0 -0.1,-4 -0.1,0 -0.1,0 -0.6,-0 -0.1,0 -0.6,-0 0,-0 -0.7,-0.1 -0,0 -0.1,-0 -0.6,-0.1 -0.1,-0 -0.6,-0.1 0,-0 -0.7,-0.2 -0.5,-0.2 0,-0 -0.6,-0.2 -0.1,-0 -0,0 -0.5,-0.2 -0.1,-0 -0.5,-0.3 -0.1,-0.1 z M 100,93.2 c -3.5,-4e-4 -6.7,2.9 -6.7,6.5 l 0,0.4 c 0,3.5 3,6.5 6.5,6.5 l 0.4,0 c 3.4,0 6.5,-3 6.5,-6.3 l 0,-0.9 c 0,-3.4 -3.3,-6.3 -6.8,-6.3 z"}],o["AC.IC.AVALANCHE"]=[{type:"path",stroke:!1,d:"m 115.7,87.3 -3.6,0.9 11,38 -4.6,1.5 9.6,9.2 3.1,-13 -4.6,1.4 z m 3,46.4 -8.5,-10 4.3,-1.2 -11.2,-40.6 -34.5,51.9 z m -12.1,-59.8 0,8.4 1.6,0 0,-8.3 7.1,4.3 0.8,-1.3 -7.4,-4.1 7.5,-4.4 -1,-1.2 -7,4 0,-8.2 -1.6,0 0,8.2 -7.4,-4 -0.6,1.1 7.2,4.4 -7.2,4.1 0.6,1.4 z"}],o["AC.IC.EARTHQUAKE EPICENTER"]=[{type:"path",stroke:!1,d:"m 62.8,99.8 c 0,-10.8 4.9,-20.2 10.3,-25.7 5.1,-5.1 14.8,-11.3 24.7,-11.3 h 4.1 c 4.9,0 10.5,1.9 13.9,3.6 5,2.5 6.4,4 10.4,7 4.6,3.6 11.1,15.4 11.1,23.8 v 5.3 c 0,17.4 -17.5,34.6 -35.1,34.6 h -4.6 c -10.3,0 -19.4,-6.2 -24.6,-11.4 -5.5,-5.4 -10.3,-15 -10.3,-25.8 z m 39.4,38.5 c 10.7,0 20,-6.3 25.5,-11.8 6.7,-6.7 9.9,-13.9 10.7,-26.5 1.3,-19.2 -17.7,-38.1 -36.2,-38.1 h -4.8 c -10.3,0 -20.1,6.6 -25.2,12.1 -3,3.2 -5.6,6.7 -7.5,11.1 -1.1,2.8 -3.5,11.3 -3,15.3 0.7,6.4 0.9,10.4 3.4,15.3 2.2,4.4 4,7.6 7.3,11 5,5.3 15.2,11.7 25.3,11.7 h 4.6 z m -3.9,-11.6 c -13.6,0 -24.7,-13.1 -25.2,-26.8 -0.5,-13.2 12.5,-26.4 25.4,-26.4 h 2.9 c 12.8,0 25.2,12.4 25.2,25.2 v 2.4 c 0,12.8 -12.4,25.7 -25.2,25.7 h -3.1 v -0 z m -27.1,-26.9 c 0,8.8 3.7,16 8.1,20.5 2.3,2.4 5.2,4.4 8.3,5.9 4.2,2.2 6.3,1.9 11.5,2.8 2.9,0.5 10,-1.3 12,-2.2 4.6,-2.2 5,-2.9 8.6,-5.6 4.3,-3.1 9.1,-12.3 9.1,-19.7 v -3.4 c 0,-13.7 -13.6,-26.8 -27.3,-26.8 h -3.2 c -14.5,-4e-4 -27.1,13.6 -27.1,28.5 z m 28.5,14.8 c -8.4,0 -13.5,-6.5 -14.4,-14.4 -0.7,-7.3 6.8,-14.6 13.9,-14.6 h 1.7 c 7.3,0 13.6,6.9 13.6,14.5 0,7.7 -6.2,14.5 -13.8,14.5 h -1 z m -18.6,-14.8 c 0,11.5 8,18.1 18.4,19.3 6.2,0.8 10.3,-2.9 13.6,-5.3 2.8,-2 5.8,-8.3 5.8,-13.3 V 99.8 c 0,-10.4 -8.3,-18.6 -18.6,-18.6 h -0.7 c -9.9,0 -18.4,8.6 -18.4,18.6 z m 10.9,0 v 0.2 c 0,3.7 3.5,7.7 7,7.7 h 1.7 c 3.9,0 7.3,-3.9 7.3,-7.7 0,-4 -3.5,-8 -7,-8 h -1.7 c -3.5,0 -7.3,4 -7.3,7.7 z"}],o["AC.IC.LANDSLIDE"]=[{type:"path",stroke:!1,d:"m 129.4,110.8 c -2.7,0 -6.2,4.1 -4.3,5.1 -1,1.5 -3.6,2 -3.6,4 0,1.8 2.6,4.7 3.4,6.2 1.1,2 3.2,3.2 6.2,3.2 h 1.8 c 2.7,0 4.6,-2.6 4.6,-5.3 v -1 c 0,-3.4 -1,-5 -2.1,-7.5 -1,-2.4 -1.6,-4.6 -4.9,-4.6 h -1 z m -22.2,-35 -5.3,-5.2 -39.3,58.3 55.8,0.1 v -1.2 c 0,-0.7 -1,-1.5 -1.5,-1.8 0,-2 -0.6,-1.6 -0.9,-2.9 -0.2,-0.9 -0.1,-2.7 -0.1,-3.7 0,-2.8 -0.1,-4.3 -1.7,-5.6 -2.2,-1.9 -1.3,-1.5 -4.3,-3.1 -2,-1 -1.5,-2.1 -5.2,-2.2 v -1.5 c 0,-1.9 -2,-3.6 -2.8,-4.8 0,-2.3 -0.5,-4.7 -0.5,-6.8 0,-1.6 -0.2,-2 -0.2,-3.3 -0.1,-1.7 -0.8,-1.5 -0.8,-2.8 v -0.2 c 0,-3 0.5,-4.5 2.1,-6 2.2,-2.1 0.9,-2.2 3.8,-3.9 l 0.8,-3.3 0,0 z m 9.7,34 c 0,3.6 6.1,2.8 6.1,-0.8 0,-4.2 -6.1,-1.9 -6.1,0.8 z m 2.8,-16.4 c -2.2,0 -7,6.4 -4,8.6 1.7,1.2 2.6,1.6 5.3,0.6 2,-0.8 2.8,-1.6 2.8,-4.3 4e-4,-2.4 -2,-4.8 -4,-4.8 z m -8.4,5.3 c 0.8,0 1,-0.7 1.3,-1.3 -0.6,-1.4 -0.5,-2.5 -2.6,-2.5 h -0.2 c -1,0 -2,0.6 -2,1.5 0,0.7 1.6,2.3 2.8,2.3 h 0.8 z m -3.3,-13.7 c -0.1,1 -0.3,0.6 -0.3,1.5 0,1 0.8,3 1.8,3 h 0.2 c 3.1,0 3.1,-0.2 4.8,-1.5 -1,-2.3 -0.4,-3.6 -4.2,-3.6 -1.1,0 -1.4,0.3 -2.3,0.5 z"}],o["AC.IC.SUBSIDENCE"]=[{type:"path",stroke:!1,d:"m 56.8,75.6 0,2 14.4,0 3.8,7.9 c -0.1,0.3 -0.3,0.7 -0.3,1.6 l 0,0.6 c 0,0.7 0.3,1.1 0.7,1.5 0.3,0.4 0.7,0.8 1.1,1.3 0.7,0.8 1.5,1.5 1.8,2 l -0.3,4.1 c -0.1,1 0.4,2 1,2.6 0.6,0.6 1.3,1.1 2,1.5 0.7,0.4 1.3,0.8 1.7,1.2 0.4,0.4 0.6,0.6 0.6,1 0,1.3 -0.5,2.2 -0.5,4.2 0,0.9 0.5,1.7 1.1,2.1 0.6,0.4 1.2,0.7 1.8,0.9 0.6,0.2 1.1,0.4 1.4,0.6 0.3,0.2 0.3,0.2 0.3,0.3 0,0.6 -0.1,0.8 -0.3,1.2 -0.2,0.3 -0.5,0.7 -0.5,1.5 l 0,0.6 c 0,1.8 1,2.9 1.9,3.5 0.8,0.6 1.3,0.8 1.5,1.3 0,0 0,0 0,0 0.2,0.8 0.3,2 0.7,3.1 0.2,0.6 0.5,1.2 1,1.6 0.5,0.5 1.2,0.7 2,0.7 l 0.3,0 c 1.1,0 1.9,-0 2.6,-0.2 0.7,-0.1 1.3,-0.4 1.7,-0.9 0.4,-0.5 0.5,-1.1 0.7,-1.7 0.1,-0.6 0.2,-1.3 0.3,-2.1 7.6e-4,-0 -7.6e-4,-0 0,-0 0.2,-1.4 0.7,-2.1 1.3,-2.8 0.5,-0.7 1.2,-1.7 1.2,-3.1 0,-0.6 -0.2,-1 -0.5,-1.3 -0.2,-0.3 -0.5,-0.7 -0.7,-1 -0.5,-0.7 -0.8,-1.5 -0.8,-2.4 l 0,-0.9 c 0,-0 -0,-0 0.1,-0.2 0.2,-0.2 0.5,-0.4 0.8,-0.6 0.4,-0.3 0.8,-0.5 1.1,-1 0.4,-0.4 0.7,-1.1 0.7,-1.8 0,-1.2 -0.5,-2.4 -0.9,-3.5 -0.4,-1.1 -0.8,-2.2 -0.8,-2.5 0,-0.5 0.2,-1 0.6,-1.6 0.4,-0.6 1,-1.3 1.5,-2.2 0.5,-0.8 0.9,-1.8 0.9,-3 -0,-1.1 -0.5,-2.4 -1.6,-3.6 l -0,-0 -0,0 c -0.3,-0.3 -0.7,-1.3 -0.8,-2.2 -0.1,-0.9 0.1,-1.9 0.4,-2.3 0.3,-0.5 0.9,-0.9 1.7,-1.4 0.7,-0.6 1.5,-1.6 1.5,-3 l 0,-1.4 38.1,0 0,-2 -40.1,0 -30.6,0 -0.6,0 -15,0 z"}],o["AC.IC.VOLCANIC ERUPTION"]=[{type:"path",stroke:!1,d:"m 122.2,66 -10.4,17.9 1.7,1 10.4,-17.9 -1.7,-1 z m -23.2,0.5 0,17.9 2,0 0,-17.9 -2,0 z m -19.5,-0.4 -1.8,0.8 8,17.9 1.8,-0.8 -8,-17.9 z M 99.3,120.8 c -1.7,-0 -3.3,0.8 -4.5,2 -1.2,1.2 -2,2.9 -2,4.5 l 0,1.9 c 0,1.7 0.8,3.3 2,4.5 1.2,1.2 2.8,2 4.5,2 l 1.3,0 c 1.7,0 3.3,-0.8 4.5,-2 1.2,-1.2 2,-2.8 2,-4.5 l 0,-1.9 c 0,-1.7 -0.8,-3.3 -2,-4.5 -1.2,-1.2 -2.8,-2 -4.5,-2 l -1.2,0 -0,0 z M 80.3,86.5 c -0.5,0 -0.9,0.3 -1.4,0.8 -0.4,0.5 -0.8,1.2 -1.3,2 -0.8,1.7 -1.6,3.9 -2.4,6.3 -1.5,4.7 -2.8,9.8 -3.4,11.4 l -0,0 c -2,7 -5.8,15.2 -7,21.6 l -0.1,0.2 0.2,0 20.9,0.6 0.2,0 0,-0.2 0,-1.9 0,-0.2 -0.2,-0 -17.6,-0.7 L 80.5,89.4 l 39.1,0 11.9,37.1 -17.5,0.7 -0.2,0 0,0.2 0,1.9 0,0.2 0.2,-0 20.9,-0.6 0.2,0 -0.1,-0.2 c -1.3,-6.4 -5.1,-14.7 -7,-21.6 L 128.1,107 c -0.6,-1.6 -1.9,-6.7 -3.4,-11.4 -0.8,-2.3 -1.6,-4.6 -2.4,-6.3 -0.4,-0.8 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.9,-0.8 -1.4,-0.8 l -39.4,0 z"}],o["AC.IC.VOLCANIC THREAT"]=[{type:"path",stroke:!1,d:"m 80.3,85.6 c -0.5,0 -0.9,0.3 -1.4,0.8 -0.4,0.5 -0.8,1.2 -1.3,2 -0.8,1.7 -1.6,3.9 -2.4,6.3 -1.5,4.7 -2.8,9.8 -3.4,11.3 l 0,0 -0,0 c -2,7 -5.8,15.2 -7,21.6 l -0.1,0.2 0.2,0 20.9,0.6 0.2,0 0,-0.2 0,-1.9 0,-0.2 -0.2,-0 -17.6,-0.7 12,-37.1 39.1,0 11.9,37.1 -17.5,0.7 -0.2,0 0,0.2 0,1.9 0,0.2 0.2,0 20.9,-0.6 0.2,-0 -0.1,-0.2 c -1.3,-6.4 -5.1,-14.7 -7,-21.6 l -0,0 0,-0 c -0.6,-1.6 -1.9,-6.7 -3.4,-11.3 -0.8,-2.3 -1.6,-4.6 -2.4,-6.3 -0.4,-0.8 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.9,-0.8 -1.4,-0.8 l -39.4,0 z M 99.3,120 c -1.7,-0 -3.3,0.8 -4.5,2 -1.2,1.2 -2,2.9 -2,4.5 l 0,1.9 c 0,1.7 0.8,3.3 2,4.5 1.2,1.2 2.8,2 4.5,2 l 1.3,0 c 1.7,0 3.3,-0.8 4.5,-2 1.2,-1.2 2,-2.8 2,-4.5 l 0,-1.9 c 0,-1.7 -0.8,-3.3 -2,-4.5 -1.2,-1.2 -2.8,-2 -4.5,-2 l -1.2,0 -0,0 z m -2.7,-42.1 0,0.2 -0.2,0 0,4.2 0,0.2 0.2,0 3.3,0 0.2,0 0,-0.2 0,-4.2 0,-0.2 -0.2,0 -3.3,0 z M 99,57.1 c -1.1,2.5e-5 -2.3,0.2 -3.3,0.5 -1.1,0.3 -2.1,0.8 -3.2,1.4 l -0.1,0.1 0,0.1 0,3.1 0,0.4 0.3,-0.2 c 1.1,-0.7 2,-1.3 3,-1.6 1,-0.4 1.9,-0.6 2.7,-0.6 1.1,2.2e-5 2,0.3 2.7,0.8 0.7,0.6 1,1.3 1,2.2 -1e-5,0.5 -0.1,1 -0.4,1.5 -0.3,0.5 -0.7,1 -1.3,1.6 l 0,0 -1.5,1.5 c -1,0.9 -1.7,1.8 -2,2.5 -0.3,0.7 -0.5,1.7 -0.5,2.8 l 0,2.5 0,0.2 0.2,0 3.1,0 0,-0.2 0.2,0 0,-2 c -10e-6,-0.6 0,-1 0.1,-1.3 0,-0.3 0.1,-0.6 0.1,-0.8 0.1,-0.2 0.2,-0.5 0.4,-0.8 0.2,-0.3 0.6,-0.7 1.1,-1.2 l 1.4,-1.4 c 1,-0.9 1.7,-1.8 2.1,-2.6 l 0,-0 c 0.4,-0.8 0.6,-1.6 0.6,-2.5 -2e-5,-1.8 -0.6,-3.3 -1.9,-4.3 -1.3,-1.1 -2.9,-1.6 -5,-1.6 z"}],o["AC.IC.CAVE ENTRANCE"]=[{type:"path",fill:!1,d:"m 55,100 55,0 30,-20 0,40 -30,-20"}],o["AC.IC.DROUGHT"]=[{type:"path",stroke:!1,d:"m 87.6,127.4 c 1.3,0.6 4.5,0 6.1,0 h 4.2 l -2,-5.9 -4.9,-0.3 c -5.7,10.8 -2.4,4.3 -3.4,6.2 z m -24.1,-7 c -0.6,1.9 17.6,6.9 20.5,7.4 2.7,-1.8 4.5,-2.4 4.8,-6.7 -4,0 -11.4,-0.8 -14.8,-1.7 -2.2,-0.6 -4.2,-1.2 -6.4,-1.7 -3.5,-0.9 -4.2,-1.5 -4.2,2.6 z m 35.9,6.1 6.7,-0.3 18.6,-1.7 c 1.5,-0.4 4.5,-0.4 6,-1.4 -1.3,-2.6 -2.4,-4.1 -3.7,-6.6 -1.4,-2.6 -1.9,-4.9 -3,-7.2 -3.7,0.8 -4.7,3.5 -6.3,4 -3.5,1.1 -4.8,0.4 -6.7,3.8 -1.7,3 -2.5,3.3 -5.3,5.2 -2.4,1.7 -3.6,2.8 -6.3,4.2 z m -2.8,-9 c 0,3.7 0.5,4.2 2.2,7.3 l 8.5,-7.1 -0.2,-0.2 c -1.7,-0.4 -2.4,-1.5 -4.8,-2.2 -1.6,-0.4 -4.1,-1.3 -5.8,-1.4 v 3.6 h 0.1 z m 37.6,0.5 c -0.9,0 -1,-0.2 -1.9,-0.2 l 1,2.4 2.7,-2.8 c -0.9,0.2 -0.8,0.5 -1.8,0.5 z m -51.3,-0.3 c -0.1,1.9 7.7,1.5 9.3,1.5 h 2.8 c 0,-1.7 -0.7,-2.8 -0.8,-4.4 -0.1,-2.5 -0.4,-1.8 -3.1,-2.1 -4,-0.4 -4.6,-2 -7.7,-2.8 l -0.6,7.7 z m -25.5,-12.6 3,12.1 c 0.7,-3 2.2,-4.5 2.8,-7.3 0.3,-1.8 0.1,-2.6 0.9,-4 0.4,-0.7 1.3,-2.8 1.5,-3.6 -1.4,-0.3 -6.9,-1.6 -8.6,-1.6 l 0.4,4.4 z m 69.9,-2.2 c -1,4.1 -0.7,3.5 1,7 1.2,2.4 2,4.4 3.1,6.6 5.8,-0.5 6.2,-0.5 9.4,-3.6 1.6,-1.6 1,-6.8 2,-8.3 -2.5,-1.2 -1.7,-0.6 -4.6,-1.3 -4.5,-1 -6.6,-0.4 -10.9,-0.3 z m -30.9,1.1 v 0.8 c 0,2.2 -0.1,3.3 0,5.4 0.1,3.3 -0.3,2.5 3.1,2.8 1.2,0.1 3.5,1 4.5,1.4 0.7,0.4 1.5,0.5 2,0.8 0.8,0.4 0.3,0.6 1.7,1.4 l -0.2,-0.2 5.6,-4.7 c 3.1,0 4.2,0.4 5.8,-1.3 2.4,-2.5 0.8,-1.4 4,-3.1 l 0.6,-3.1 c -2.5,0.6 -5.5,2.2 -8.2,1.1 -2.6,-1.1 -3.8,-2.8 -7.4,-2.8 l -1.6,-0.3 -9.9,1.8 z m -32.1,11.2 c 1.3,0 5.8,0.7 6.9,1 1.4,0.4 4.7,2.3 5.6,2.3 h 2.8 c 1,0 0.9,-0.3 1.7,-0.5 l 1.7,-8.3 -5.2,-4.5 -9,-2 c -0.4,1.7 -2.4,3 -3.1,5.1 -0.3,0.7 -1.5,6.3 -1.5,7 z m 41,-35.1 c 1,1.2 1.4,2.8 2.2,4.2 0.4,0.6 2.9,3.3 2.9,3.5 0,0.8 -0.9,2.3 -1.3,2.3 -2.7,0 -3.8,-6.7 -3.8,-10 z m -1.8,-1.2 c -0.3,1 -1.9,4.5 -2.5,5.6 -0.9,1.8 -1.9,3.5 -4.4,3.5 -0.5,0 -1,-0.4 -1,-0.8 0,-3.1 3.8,-5.8 5.2,-7.6 l 2.8,-0.8 z m 9.5,8.6 h -0.8 c -2.3,0 -6.9,-8 -6.9,-9.7 0,-0.1 0.3,-0.5 0.3,-0.5 1.7,0.5 7.9,6 7.9,8.7 -4e-4,0.5 -0.4,0.8 -0.5,1.5 z m 0.6,-6 c -0.7,-0.3 -1.7,-1 -2.4,-1.3 -1.4,-0.8 -3.5,-2.9 -4.7,-3.3 l 1.1,-1.3 c 3.1,1.5 10.1,1.3 10.1,5.7 0,0.3 -0.8,0.8 -1,1 -0.8,-0.3 -2,-0.4 -3.1,-0.8 z m -24.9,1.3 h -1 c 1,-2 -2.2,-6.7 -4.4,-7.2 -2.2,1.2 -4.2,0.6 -5.5,3.3 -0.4,1 -0.7,2.2 -1.5,2.8 -0.8,0.6 -2.4,0.8 -2.4,1.9 0,1.5 4.3,0.4 4.9,-0.2 1.2,-1.1 2.4,-2.1 4.5,-2.1 2,0 2.9,5.8 3.1,8.2 0.2,3.2 -2.3,7.7 -2.2,9.5 l 0.9,6.8 -4.4,-0.3 c 2.1,3.1 8.5,6 13.4,6.4 l -0.4,-7.7 -5.6,1.3 c 0,-4.4 -2,-5.5 -0.5,-9.5 0.6,-1.7 1,-2.2 1,-4.7 0,-1.1 0.2,-4.6 0.6,-5.3 1.5,-2.5 1.9,-5.6 3.1,-8.4 1.2,-2.8 5,-2.6 8.3,-3.5 l 1.2,1.3 -1,0.3 0.8,1.8 c -1.7,2 -2.9,2.9 -4.5,5 -0.8,1 -3.8,6.3 -0.6,6.3 h 1 c 3.9,0 5.1,-7.1 6.9,-9.2 0.4,4.4 1.2,9.5 4.4,11.2 1.7,-0.4 2.2,-1.1 2.6,-2.8 0.7,0.2 0.5,0.3 1,0.3 1.3,0 2,-1.1 2,-2.3 V 85.8 c 0,-2.1 -1.2,-2.4 -1.5,-3.8 0.8,0.4 2.2,1 3.3,1 h 0.5 c 1.2,0 1.3,-0.6 1.8,-1.3 -0.2,-2.5 -1.5,-3.9 -3.5,-4.6 -1.3,-0.4 -5.2,-1.7 -6.7,-1.7 l 0.5,-1 h -0.7 l 0.8,-1.6 -4.9,1 c -0.9,-0.6 -1.2,-1.5 -2.6,-1.5 h -1.8 C 92.3,72.2 88.7,75.8 88.7,82.9 l 0,0 z"}],o["AC.IC.FLOOD"]=[{type:"path",stroke:!1,d:"M77.2,92.9L77.3,92.8L99.3,72.5L99.7,72.1L100,72.1L100.4,72.5L122.4,92.8L123.5,93.9L122.4,93.9L122.4,115.902C123.023,115.106 123.657,114.5 124.4,114.5C125.454,114.199 124.857,116.712 125.5,117.6C125.988,118.273 126.805,118.721 127.609,118.928C130.146,119.58 132.747,117.303 134.5,116.2C135.043,115.859 136.356,115.26 136.4,115.9C136.652,119.558 136.526,123.235 136.4,126.9L63.7,126.9L63.7,114.9C64.819,117.943 66.835,120.948 70.637,119.05C72.357,118.192 73.209,115.745 75.1,115.4C75.464,115.334 76.266,116.335 77.1,117.278L77.1,93.9L76.2,93.9L77.1,93L77.1,92.9L77.2,92.9ZM121.2,117.544L121.2,94.1L78.3,94.1L78.3,118.49C78.521,118.667 78.727,118.795 78.911,118.845C83.407,120.084 82.345,116.009 86.9,115.5C87.588,115.423 90.549,119.114 91.583,119.536C95.694,121.215 95.826,116.694 98.9,115.9C100.074,115.597 100.538,118.237 100.9,118.5C101.86,119.198 103.028,119.651 104.2,119.837C109.33,120.655 108.685,117.216 111.9,114.9C112.848,114.217 113.556,116.602 113.563,116.613C115.1,119.229 115.092,120.273 118.659,119.606C119.666,119.418 120.465,118.529 121.2,117.544ZM99.75,73.846L99.8,73.8L99.7,73.8L99.75,73.846L79.3,92.7L120.2,92.7L99.75,73.846Z"}],o["AC.IC.INVERSION"]=[{type:"path",stroke:!1,d:"M 69.5,87.9 C 69.5,86.7 73.6,83.9 75.5,83.9 h 0.3 c 3.3,0 9,9.1 15.2,9.1 h 1.8 c 5.4,0 11.3,-9.1 14.9,-9.1 3.5,0 8.8,9.1 15.2,9.1 h 0.9 c 8.5,0 10.5,-4.4 15.5,-7 l -5.3,-6.4 c -3.4,1.8 -4.1,4.6 -9.5,5.3 -2.2,0.3 -6.6,-3.9 -8.3,-5.5 -8,-6.8 -13,-3 -19.4,2 -3.9,3.1 -3.9,5.3 -8.5,1.3 -2.2,-1.8 -5.6,-4.8 -8.2,-6 -3.8,-1.8 -8.6,-0.7 -11.4,1.2 -1.6,1 -7.3,5.2 -7.3,6.9 v 52.2 h 8.2 V 87.9 z m -9.4,-16.4 79.9,0 0,-8.5 -79.9,0 z"}],o["AC.IC.TSUNAMI"]=[{type:"path",stroke:!1,d:"m 63,122 39.5,-0.1 30.8,0.3 c -7.1,0 -12.8,-1.7 -16.9,-4.8 -3.7,-2.9 -7.7,-8 -7.7,-14.4 0,-9.1 6.9,-16.5 15.8,-16.5 h 0.7 c 6.5,0 8.2,2.8 11.8,5.3 -2,-8.6 -10.6,-14.2 -21.4,-14.2 h -0.2 c -18.2,0 -44.9,33 -52.4,44.3 l 0,0 0,0 z"}],o["AC.IC.BIRD"]=[{type:"path",stroke:!1,d:"m 81.6,92.5 -18.4,2.9 v 0.3 l 6.6,0.5 c -0.7,0.5 -3.3,1.1 -4.5,1.5 -2.6,0.9 -2,0.3 -3.5,2.4 l 3.4,0.1 -1,1 c 1.8,0 3.3,0.1 4.8,0.2 1.4,0.1 1.9,-1.3 3.5,-1.4 3,-0.2 5.7,0.2 9.3,0.3 l -0.8,0.5 c 0.6,0.1 0.7,0.2 1.4,0.2 h 1.6 l 0.1,0.9 2.9,1.2 1.6,-0.1 c 1.6,1.1 1.9,2.3 5.2,2.4 0.2,2.7 0.6,3.8 3,4.4 v 0.8 c 0,2.2 0.2,4.8 2.1,5 l 1.2,5.3 h -0.4 v 0.4 c -0.3,-0.3 -1.4,-1.2 -1.8,-1.2 h -0.2 c -0.5,0 -0.5,0.1 -1,0.2 0.6,0.8 2.7,1.7 3.1,2.7 0.5,1.6 0.1,3.8 0.2,5.3 l 0.9,0.6 0.8,-0.1 0.1,-0.8 -0.1,-2.7 c 0.7,0.5 2.7,3 3.3,3 h 1 c -0.5,-2 -1.8,-2.4 -2.7,-3.9 l 3.7,1.1 c -1,-1.5 -0.9,-1.8 -2.9,-2.3 -3.1,-0.8 -1.8,-1.9 -3.1,-2.2 l -1,-5.4 c 1,-0.2 1.4,-1 1.4,-2.2 l 0.1,-1.6 -0.3,-2.6 h 1 c 0.7,0 0.7,-0.2 1.4,-0.4 0.1,1.6 1.2,3.3 2.7,3.4 l 3.1,6.3 c -0.3,0.3 -0.4,0.3 -0.4,0.8 v 0.7 l -4.4,-0.9 v 0.2 c 0.8,0.7 3.7,1.7 5.1,2.8 1.1,0.8 1.2,0.6 2,1.9 0.3,0.5 1.3,2.2 1.9,2.2 h 0.8 l 0.2,-0.1 -1.7,-3.2 4.3,1.9 c -0.1,-2.1 -2.1,-1.5 -3.6,-2.8 h 3 c -1.3,-1.1 -1.6,-0.9 -3.5,-1.2 -1.6,-0.2 -1.7,-1.2 -2.7,-2.1 -1.1,-1.2 -2,-4.9 -2.9,-6.6 1.2,-1.8 1,-1.4 1,-4.4 4.8,-2.3 5.6,-2.1 9.3,-5.9 2.7,-2.7 3.9,-6.1 5.8,-9.7 0.9,-1.8 1.5,-3.3 2.2,-5.2 0.7,-1.8 0.7,-4.7 1.4,-6.3 2.3,-4.6 9,-3.2 10.3,-5.2 l -4.4,0.2 v -0.2 l 5,-0.6 c -2.2,-1.9 -4.8,-1.4 -8.3,-1.8 -2.1,-0.3 -2.9,0.7 -4.4,-0.3 -1.4,-1 -1.6,-1.2 -3.7,-1.5 -3.1,-0.5 -5.6,1.2 -7.4,2.5 -1.7,1.3 -3.2,5.2 -4.2,6.1 -0.3,0.2 -6.1,2.7 -7.1,3.2 -2.9,1.5 -3.5,2.5 -7.3,3.1 -6.3,1 -9.9,3.4 -14.2,6.3 l 0,0 z"}],o["AC.IC.INSECT"]=[{type:"path",stroke:!1,d:"m 77.4,88.8 0.1,-0.3 6.1,4.9 -0.1,0.2 c -2.2,1.5 -7.7,9 -10,9 l -1.6,-0.1 5.6,-13.7 z m 7.1,3.3 c -0.4,-1.7 -5,-6.4 -6.7,-7.2 -0.4,0.3 -1.8,1 -1.8,1.6 0,0.8 0.3,1 0.5,1.5 l -5.6,14.7 h -1 c 0.2,0.9 0.5,0.7 0.5,1 0,0.3 -3,7.8 -3.3,8.7 -0.6,1.4 -1,2.7 -1.6,4.2 -0.3,0.8 -0.6,1.6 -0.9,2.2 -0.5,1.1 -0.6,0.3 -1.4,1.7 l -1.3,0.3 c 0.3,0.5 1.8,0.5 2.5,0.4 1.2,-0.2 0.4,-1 0.8,-2.2 0.7,-1.8 1.4,-3.5 2.1,-5.4 0.5,-1.2 3.7,-10.3 4.6,-10.3 h 1.3 c 0.8,0 1,0.3 1.5,0.5 l 2.3,-2.8 c 2.7,1.8 8.5,4.6 12.8,4.6 h 0.7 l 0.2,-0.1 -3.5,-5 -9.9,-0.1 6.5,-6.3 c 4.3,2.9 11.7,16.9 14.9,16.9 h 0.3 c 1.4,0 1.3,-0.6 1.8,-1.6 -0.9,-3.7 -4.8,-6.3 -7.3,-8.5 -2.4,-2 -6.1,-6.5 -8.3,-7.9 1.2,-1.7 10.3,-10.8 12.2,-11.3 l 0.9,7.7 0.1,2.9 -1.2,7.4 h -1.8 l 5.2,4.4 7.2,-3.9 c -0.5,2.1 -0.3,2.5 -2.2,3.4 -0.6,0.3 -3.7,1.9 -3.7,2.3 0,0.5 0.7,1.7 0.7,3.1 0,2.9 -3.1,4.4 -5.8,3.3 -2.1,-1 -4.9,-5.1 -5.5,-5.1 h -1 c -4.6,0 -6.7,1.6 -10.5,1.6 h -0.5 c -1.9,0 -2.5,-0.7 -4.1,-0.7 h -0.5 c -0.6,0 -1,0.4 -1,1 0,3.2 12.3,4.7 16.9,4.6 l 13.1,-0.3 v 0.3 c -0.9,1.3 -5.8,4.8 -8,4.8 -0.1,0.2 -0.5,0.7 -0.5,0.8 0,0.7 0.1,0.7 0.3,1.3 0.7,0.1 0.5,0.3 1,0.3 0.5,0 0.5,-0.2 1,-0.5 v -1.3 l 7.7,-5.4 -1.6,6.1 c -0.9,0.1 -1.3,0.4 -1.3,1.3 0,0.9 0.5,0.7 1.4,1.2 l 1.2,-1.4 c 0,-0.2 -0.7,-1.3 -0.7,-1.4 0,-1.3 2.4,-7.6 2.8,-9.5 l 15.6,-0.5 1.2,8.4 -0.4,0.1 c 0.3,0.5 0.3,1 1,1 1,0 1.1,-0.3 1.6,-0.7 -0.5,-1 -0.5,-1.9 -1.7,-1.3 l -0.8,-6.7 4.8,5.5 -0.7,0.8 1.4,1.2 c 0.5,-0.3 1,-0.2 1,-1 v -0.5 c 0,-0.9 -0.9,-1 -1.6,-1.2 l -4.5,-5 0.3,-1 h -8.5 c 0,-5 2,-8.2 2.3,-12.4 l -9.2,0.4 -0.8,2.5 h -4.6 c -1.8,0 -2.8,-8 -2.9,-10.3 0,-2.4 -0.3,-4.1 -0.2,-6.4 0.1,-1.4 1,-5.1 -1,-5.1 h -0.7 c -1,0 -1.3,1 -1.6,1.8 -0.3,1 -1,1.4 -1.6,2 -1.2,1.3 -2.3,2.4 -3.5,3.6 -1.2,1.2 -6.2,6.7 -7.4,7 l 0,0 z m 37.9,8 c 0,-0.3 0.3,-0.5 0.7,-0.5 h 0.7 l 0.1,0.5 -0.3,1 h -1 c -0.1,-0.7 -0.3,-0.4 -0.3,-1 z m 3.6,-1.8 c -0.2,0 -1.6,-1.8 -3.3,-1.8 h -0.5 c -2,0 -2,2.2 -2.5,3.9 -0.5,1.4 -1.4,3.7 -1.4,5.4 0,0.6 0.4,1 1,1 2.4,0 6.4,-5.2 6.9,-7.4 3.9,0 11.1,-1.1 11.8,-3.9 -2.6,0.7 -2.9,2.4 -8,2.8 1.8,-1.6 5.6,-4.3 5.9,-7.2 h -0.5 c -0.8,3.1 -5.6,7.2 -9.5,7.2 z"}],o["AC.IC.MICROBIAL"]=[{type:"path",stroke:!1,d:"m 83.9,93.3 c -3.3,0 -6,2.7 -6,6 0,3.3 2.7,6 6,6 3.3,0 6,-2.7 6,-6 0,-3.3 -2.7,-6 -6,-6 z M 100,85.5 c -11.1,0 -21.2,1.5 -28.6,4.1 -3.7,1.3 -6.7,2.8 -8.8,4.5 -2.1,1.7 -3.4,3.7 -3.4,5.9 0,2.2 1.3,4.2 3.4,5.9 2.1,1.7 5.1,3.2 8.8,4.5 7.4,2.5 17.5,4.1 28.6,4.1 11.1,0 21.2,-1.5 28.6,-4.1 3.7,-1.3 6.7,-2.8 8.8,-4.5 2.1,-1.7 3.4,-3.7 3.4,-5.9 0,-2.2 -1.3,-4.2 -3.4,-5.9 -2.1,-1.7 -5.1,-3.2 -8.8,-4.5 C 121.2,87.1 111.1,85.5 100,85.5 z m 0,1.4 c 11,0 21,1.5 28.2,4 3.6,1.2 6.5,2.7 8.4,4.3 1.9,1.6 2.9,3.2 2.9,4.8 0,1.6 -1,3.3 -2.9,4.8 -1.9,1.6 -4.8,3 -8.4,4.3 -7.2,2.5 -17.1,4 -28.2,4 -11,0 -21,-1.5 -28.2,-4 -3.6,-1.2 -6.5,-2.7 -8.4,-4.3 -1.9,-1.6 -2.9,-3.2 -2.9,-4.8 0,-1.6 1,-3.3 2.9,-4.8 1.9,-1.6 4.8,-3 8.4,-4.3 7.2,-2.5 17.1,-4 28.2,-4 z"}],o["AC.IC.REPTILE"]=[{type:"path",stroke:!1,d:"m 93.5,82.3 c 0,-2 1.8,-2.7 1.8,-4.3 0,-1 -0.6,-1.5 -1.2,-2 -2.8,0.3 -6.5,0.6 -7.4,2.7 -0.5,1.2 -0.5,2.4 -1.2,3.9 -0.5,1 -1.2,2.4 -1.2,3.8 0,0.8 0.4,0.7 0.4,1.6 v 0.8 c 0,2.2 -2.4,3.5 -0.6,6.1 -0.2,0.3 -2,1.5 -2.4,1.7 -1.7,1 -1.8,-0.6 -2.6,-0.6 h -0.8 l -0.3,-1.2 c -0.5,-0.3 -1,-0.8 -1.7,-0.8 -0.8,0 -0.8,0.5 -0.6,1 l -2.1,0.4 -0.8,2.3 h 1 c 0.9,0 1.4,0.4 1.6,1.2 l -1.5,1.2 -0.1,0.4 c 2.8,0.3 4.6,-0.6 7.2,-1.2 1.5,-0.4 6.8,-0.6 7.3,-1 l 0.1,-2.2 c 1,0.3 2,1.3 3.1,1.7 1.2,0.4 1.7,0.8 3.1,1.2 2.4,0.6 4.5,1.2 7.7,1.2 h 0.6 l 6.1,-0.6 c 0,2.6 2.3,2.5 2.8,4.5 -1.3,-0.3 -2.3,-2 -3.5,-2 -0.1,0 -0.4,0.1 -0.6,0.2 l 0.3,1.2 -1.6,0.3 v 0.8 l 0.6,0.4 -0.9,0.6 1,1 c -0.2,0.8 -0.7,0.6 -0.7,1.3 0,0.4 0.1,0.6 0.6,0.6 0.6,0 1.6,-1 2.8,-1 1.9,0 8.3,0.8 8.3,-0.8 v -0.2 c 0,-1.5 -3.5,-1.6 -3.3,-5.5 5,2.6 9.3,7.4 4.5,13.6 -1.5,2 -4.1,3.6 -6.7,4.5 -1.4,0.5 -7.4,1.9 -9.3,1.5 -4.2,-0.8 -5.4,-0.8 -8.8,-2.4 -2.6,-1.2 -4.7,-2.5 -7,-4 -3.9,-2.4 -10,-6.1 -16.1,-6.1 -5,0 -11.4,3.1 -11.4,7.9 1.2,-0.6 1.3,-1.3 2.1,-2.2 0.5,-0.6 1.7,-1.3 2.4,-1.7 1.5,-1 3.9,-1.8 6.5,-1.8 h 1 c 4.4,0 11.6,4.7 14.5,6.7 4.5,3.1 8.1,5.5 14.7,6.7 7,1.2 12.7,-0.1 17.4,-2.8 1.9,-1.1 4.3,-3.3 5.5,-5.1 1,-1.6 2.9,-5.4 2.7,-8 l -0.3,-2.6 c 0.3,0.1 2.8,3.7 3.6,4.5 0.8,0.8 3.8,2.5 5.3,2.5 1,0 4.4,-2.2 4.7,-2.9 l -1.3,-0.6 1.2,-1 c -1.5,-1 -0.8,-0.6 -2.4,-0.6 h -1 c 0,-1.4 -0.3,-1.8 -1.3,-1.6 l 0.2,0.1 -1.7,3.4 c -1.4,0 -2.9,-0.9 -3.6,-1.8 0,-0.1 -1.3,-3.8 -1.3,-3.9 -0.6,-2 -0.6,-2.2 -1.8,-3.6 -1.2,-1.3 -1.9,-1.2 -3.4,-1.9 l -0.1,0.6 c -0.6,-1.8 -6.2,-6.5 -8.1,-7.4 -2.2,-1.2 -3.2,-1.2 -6,-1.7 -2.1,-0.3 -5.4,0.3 -7,-0.5 0.4,-1.5 1.6,-0.6 1.6,-2.2 0,-0.5 -0.7,-0.4 -1.2,-0.4 0.6,-1.2 -0.3,-1 -1.3,-1 0.1,-0.3 0.4,-0.6 0.4,-1 0,-0.3 -0.3,-0.4 -0.6,-0.4 -0.4,0 0,0.6 -1.3,0.6 -0.3,-1 -0.3,-1.3 -1.5,-1.4 v 1.6 h -1.3 v 0.6 c 0,0.8 0.6,1.5 1,2.2 -0.4,0.7 -0.3,2 -1.4,2 -0.6,0 -1.8,-1.5 -3.1,-1.9 -1.3,-0.4 -3,0.5 -3,-1.5 -0,-0.9 2.1,-2.5 2.8,-3.5 l 0,0 z"}],o["AC.IC.RODENT"]=[{type:"path",stroke:!1,d:"m 117.2,80.3 c 0.6,1.2 0.6,1.7 1.5,2.6 0.6,0.7 1.8,1.2 1.9,2.2 -2,-0.1 -4.2,-3.3 -4.4,-5.3 -2.1,-0.5 -8.4,-3.6 -10.9,-4.7 -3.1,-1.3 -8.3,-2.7 -12.7,-2.7 h -2.2 c -4,0 -9,2.5 -11.3,4.2 -3,2.2 -5.2,5.2 -5.2,10.4 v 0.7 c -4.6,1.1 -11.7,8.4 -11.7,13.9 v 2.4 c 0,6.2 7.7,10 11.8,12.7 2.5,1.7 4.7,3.3 7,5.1 2.2,1.7 4.7,4.2 6.7,5.5 -2.1,-9 -22.4,-12.7 -22.4,-25.1 0,-4.5 4.9,-9.3 8.5,-10.2 -0.1,0.6 -0.3,0.6 -0.3,1.3 v 0.5 c 0,4.5 7.8,4.1 11.5,3 5.1,-1.5 8.1,-2.2 13.6,-1.2 5.4,1.1 8.3,1.5 12.7,3.6 3.7,1.9 2,1.2 4.2,3.8 1.1,1.3 1,1.1 2.9,1.3 0.8,0.1 1.8,1 2.4,1.5 h 1.7 c -1.3,-2.6 -4.9,-2.9 -5.6,-5.8 0.8,-1.5 1.7,-1.7 3.9,-1.7 0.8,0 1,0.2 1.7,0.3 -0.3,-0.6 -0.6,-1.7 0.5,-1.7 h 1.9 c 4.5,0 9,2.5 12.7,0 0,-3 0.4,-2.2 -0.9,-4.9 -0.5,-0.8 -2.1,-2.7 -2.8,-3.4 -1.6,-1.5 -5.7,-4.1 -6.7,-5.5 0,-2.8 -0.4,-3.4 -2.7,-3.9 l -0.5,1 0.5,2.7 -1,0.3 v 0.9 h -0.8 c -0.2,-2.4 -1.2,-5.8 -3.6,-5.8 h -0.2 c -1.8,-4e-4 -1.5,1 -2,1.9 z m 9.5,24.6 h 1.2 c -0.2,-2.6 -5.1,-2.8 -5.4,-5.4 l -2.2,0.3 c 0.2,1.5 1.1,2.9 2.4,3.5 0.9,0.3 1.5,0 2.3,0.6 0.4,0.3 1.1,1 1.7,1 z m -45.1,-6.1 c 1.2,1.8 5.9,4.2 8.8,4.2 1,0 1.6,-0.8 1.9,-1.5 -0.9,-1.3 -2.9,-2.8 -4.7,-3.1 -3.7,-0.8 -2.9,0.1 -6,0.4 l 0,0 z m 9.5,-1.9 c 1.3,2 5,2.9 8.3,2.9 0.8,0 1.4,-0.4 1.9,-0.7 -2,-2.9 -6.1,-2.6 -10.2,-2.2 z"}],o["AC.IC.PHARMACY"]=[{type:"path",stroke:!1,d:"m 83.3,74.5 h 13.2 c 3,0 6.2,3.8 6,7.3 -0.1,3.6 -2.9,6.6 -6.5,6.6 H 83.3 V 74.5 z m -8.7,45.9 h 8.7 V 98 h 2.4 c 0.6,0 13.6,16.1 13.6,17.2 0,0.6 -13.6,16.6 -15,19.3 l 10.5,-0.1 10.3,-12.2 9.6,12.3 10.9,-0 -15.2,-19.3 14.4,-17.8 -10.2,-0.1 -9.7,10.8 -7.4,-10 c 8.5,-2 14.1,-6.8 14.1,-17.2 0,-8.1 -7,-15.3 -15,-15.3 H 74.6 v 54.8 z"}],o["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 99.6,107.1 h -14.8 v 31.7 h 32 v -31.7 h -14.8 V 95.2 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 h -2.3 v 24.5 z m -3.1,-45 -5.6,14.8 1.7,0 1.3,-3.8 0.1,-0.1 0.1,0 6.8,0 0.1,0 0.1,0.1 1.3,3.8 1.7,0 -5.6,-14.8 -2.1,0 z m 0.8,1.8 0.2,0.1 0.2,-0.1 2.8,7.5 0.1,0.3 -0.3,0 -5.6,0 -0.3,0 0.1,-0.3 2.8,-7.5 z m -14.8,-1.8 8.3,0 0,1.3 -6.5,0 -0.2,0 0,0.2 0,4.5 0,0.2 0.2,0 5.8,0 0,1.3 -5.8,0 -0.2,0 0,0.2 0,7 -1.6,0 0,-14.8 z m 30.3,-0.3 c 0.9,1.5e-5 1.7,0.1 2.5,0.4 l 0,0 c 0.8,0.2 1.4,0.6 2.1,1 l 0,1.6 c -0.6,-0.5 -1.3,-0.9 -1.9,-1.2 -0.8,-0.3 -1.7,-0.5 -2.6,-0.5 -1.8,1.4e-5 -3.2,0.6 -4.1,1.7 -1,1.1 -1.4,2.7 -1.4,4.7 -1e-5,2 0.5,3.6 1.4,4.7 1,1.1 2.4,1.7 4.1,1.6 0.9,2e-6 1.8,-0.2 2.6,-0.5 0.7,-0.3 1.3,-0.7 1.9,-1.2 l 0,1.6 c -0.7,0.4 -1.4,0.8 -2.1,1 -0.8,0.2 -1.6,0.4 -2.5,0.4 -2.3,0 -4,-0.7 -5.3,-2 -1.3,-1.4 -1.9,-3.2 -1.9,-5.6 0,-2.4 0.6,-4.3 1.9,-5.6 1.3,-1.4 3,-2 5.3,-2 z"}],o["ATMOSPHERIC.IC.DRIZZLE.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 100,82.7 c -5.5,0 -10,4.5 -10,10 0,5.5 4.5,10 10,10 0.1,0 0.1,0 0.2,0 l -0.2,0.2 c 0.9,5 -8.4,14.4 -8.4,14.4 12.8,0.1 18.4,-13.4 18.3,-23.4 l -0,0 c 0,-0.4 0.1,-0.8 0.1,-1.2 0,-5.5 -4.5,-10 -10,-10 z"}],o["ATMOSPHERIC.IC.FOG.SKY OBSCURED"]=[{type:"path",stroke:!1,fill:"rgb(255, 247, 0)",d:"m 49.6,59.7 0,8 100.9,0 0,-8 -100.9,0 z m 0,71.6 0,8 100.9,0 0,-8 -100.9,0 z m 0,-35.6 0,8 100.9,0 0,-8 -100.9,0 z"}],o["ATMOSPHERIC.IC.HAIL.LIGHT NOT ASSOCIATED WITH THUNDER"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"m 100,45.5 -0.9,2.1 -16,36 -0.6,1.4 1.5,0 32,0 1.5,0 -0.6,-1.4 -16,-36 L 100,45.5 z m -21.4,46.7 0.4,1.3 20,60 0.9,2.9 0.9,-2.9 20,-60 0.4,-1.3 -1.4,0 -40,0 -1.4,0 z m 2.8,2 37.2,0 L 100,150 81.4,94.1 z"}],o["ATMOSPHERIC.IC.RAIN.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 100,79.8 c -11.2,0 -20.2,9 -20.2,20.2 0,11.2 9,20.2 20.2,20.2 11.2,0 20.2,-9 20.2,-20.2 0,-11.2 -9,-20.2 -20.2,-20.2 z"}],o["ATMOSPHERIC.IC.DUST OR SAND.LIGHT TO MODERATE"]=[{type:"path",stroke:!1,fill:"rgb(173, 105, 75)",d:"m 140.7,85 -2,2 13,13 -13,13 2,2 14,-14 1,-1 -1,-1 L 140.7,85 z m -93.5,13.6 0,2.8 106.5,0 0,-2.8 -106.5,0 z M 98.5,62.3 c -3.2,0 -6.4,0.8 -9.2,2.2 -3.7,1.8 -6.9,4.4 -9.3,7.3 -2.3,2.9 -3.9,6.1 -3.9,9.3 0,5.6 2.9,9.9 6.9,13.2 4,3.3 9,5.8 13.9,8.3 4.9,2.5 9.7,4.9 13.1,7.7 3.4,2.8 5.4,5.8 5.4,10.1 0,3.6 -4,9 -10,11.6 -6,2.6 -13.6,2.7 -20.9,-3.4 l -2.7,3.2 c 8.4,7.1 18,7.2 25.3,4 7.2,-3.1 12.5,-9.2 12.5,-15.4 0,-5.6 -2.9,-10 -6.9,-13.3 -4,-3.3 -9,-5.8 -13.9,-8.2 -4.9,-2.5 -9.7,-4.9 -13.1,-7.7 -3.4,-2.8 -5.4,-5.8 -5.4,-10 0,-1.7 1,-4.3 2.9,-6.7 1.9,-2.4 4.7,-4.7 7.8,-6.2 6.2,-3 13.5,-3.1 19.9,4.4 l 3.2,-2.7 C 109.5,64.4 103.9,62.3 98.5,62.3 z"}],o["ATMOSPHERIC.IC.SNOW.INTERMITTENT LIGHT"]=[{type:"path",stroke:!1,fill:"rgb(0, 128, 0)",d:"m 111.5,78.9 -26.4,40 3.3,2.2 26.4,-40 -3.3,-2.2 z m -23.1,0 -3.3,2.2 26.4,40 3.3,-2.2 -26.4,-40 z M 80,98 l 0,4 40,0 0,-4 -40,0 z"}],o["ATMOSPHERIC.IC.STORMS.THUNDERSTORM LIGHT TO MODERATE - WITH HAIL"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 101 51.9 L 99.7 54.4 L 85.8 82.3 L 84.8 84.3 L 87 84.3 L 114.9 84.3 L 117.2 84.3 L 116.2 82.3 L 102.2 54.4 L 101 51.9 z M 101 58.1 L 112.7 81.5 L 89.3 81.5 L 101 58.1 z M 78.3 87.7 L 78.3 90.5 L 83.9 90.5 L 83.9 145 L 86.7 145 L 86.7 90.5 L 117.8 90.5 L 102.8 116.4 L 102.4 117.1 L 102.9 117.8 L 117.8 140.9 L 111.2 136.8 L 109.8 139.2 L 120.9 146.2 L 123.3 147.7 L 123 144.9 L 121.7 130.9 L 118.9 131.2 L 119.6 138.6 L 105.7 117 L 121.5 89.8 L 122.7 87.7 L 120.3 87.7 L 78.3 87.7 z "}],o["ATMOSPHERIC.IC.STORMS.FUNNEL CLOUD (TORNADO/WATERSPOUT)"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 125.7,59.1 112.4,72.4 112,72.8 l 0,0.6 0,53.3 0,0.6 0.4,0.4 13.3,13.3 1.9,-1.9 -12.9,-12.9 0,-52.2 12.9,-12.9 -1.9,-1.9 z m -51.5,0 -1.9,1.9 12.9,12.9 0,52.2 L 72.4,139.1 74.3,140.9 87.6,127.6 88,127.2 l 0,-0.6 0,-53.3 0,-0.6 L 87.6,72.4 74.3,59.1 z"}],o["ATMOSPHERIC.IC.TROPICAL STORM SYSTEMS.TROPICAL STORM"]=[{type:"path",stroke:!1,fill:"rgb(198, 16, 33)",d:"M 112.1 55 C 96.9 59.9 76.7 81.8 82.2 101.4 C 82.9 110.6 90.6 117.9 100 117.9 C 100 117.9 100 117.9 100.1 117.9 C 99.3 128.2 87.9 145 87.9 145 C 103.1 140.1 123.3 118.2 117.8 98.6 C 117.1 89.4 109.4 82.1 100 82.1 C 100 82.1 100 82.1 99.9 82.1 C 100.7 71.8 112.1 55 112.1 55 z M 100 84.5 C 106.8 84.5 112.5 88.8 114.6 94.8 C 114.8 95.2 114.9 95.6 115 96 C 115 96.1 115 96.1 115 96.2 C 115.1 96.6 115.2 96.9 115.3 97.3 C 115.4 98.1 115.5 99.1 115.5 100 C 115.5 101.1 115.4 102.1 115.2 103.1 C 115 104.1 114.7 105 114.4 105.8 C 114.4 105.9 114.3 105.9 114.3 106 C 114.1 106.4 114 106.7 113.8 107.1 C 113.7 107.2 113.7 107.3 113.7 107.3 C 113.6 107.4 113.6 107.5 113.5 107.6 C 113.3 107.9 113.1 108.3 112.9 108.6 C 112.4 109.3 111.9 110 111.3 110.6 C 111.2 110.7 111.1 110.8 111.1 110.9 C 110.8 111.1 110.5 111.4 110.3 111.6 C 110.2 111.7 110.2 111.7 110.1 111.8 C 109.8 112 109.5 112.3 109.2 112.5 C 109.1 112.5 109.1 112.5 109.1 112.5 C 108.9 112.7 108.6 112.9 108.4 113 C 108.1 113.2 107.8 113.4 107.5 113.6 C 107.4 113.6 107.4 113.6 107.4 113.7 C 106.6 114.1 105.7 114.4 104.9 114.7 C 104.7 114.8 104.5 114.8 104.3 114.9 C 104 115 103.6 115.1 103.3 115.2 C 103.2 115.2 103.1 115.2 103.1 115.2 C 102.1 115.4 101.1 115.5 100 115.5 C 93.3 115.5 87.6 111.3 85.4 105.3 C 85.4 105.3 85.4 105.2 85.4 105.2 C 85.3 104.8 85.2 104.5 85.1 104.2 C 85 104 85 103.9 85 103.8 C 84.9 103.5 84.8 103.2 84.8 102.9 C 84.7 102.5 84.6 102 84.6 101.6 C 84.5 101.1 84.5 100.5 84.5 100 C 84.5 99 84.6 98 84.8 97 C 84.8 97 84.8 96.9 84.8 96.9 C 84.9 96.4 85 96 85.2 95.6 C 85.3 95.2 85.4 94.9 85.5 94.5 C 85.6 94.3 85.6 94.2 85.7 94 C 85.7 93.9 85.8 93.8 85.8 93.8 C 86 93.4 86.2 93 86.3 92.7 C 86.4 92.6 86.4 92.5 86.5 92.4 C 86.7 92.1 86.9 91.7 87.1 91.4 C 87.3 91.1 87.5 90.8 87.8 90.5 C 88 90.2 88.2 90 88.4 89.7 C 88.6 89.5 88.8 89.3 88.9 89.1 C 89 89 89.1 89 89.2 88.9 C 89.4 88.7 89.7 88.4 89.9 88.2 C 90.2 88 90.5 87.8 90.8 87.5 C 90.8 87.5 90.9 87.5 90.9 87.5 C 91.1 87.3 91.4 87.1 91.6 87 C 91.9 86.8 92.2 86.6 92.5 86.4 C 92.6 86.4 92.6 86.4 92.6 86.3 C 93.1 86.1 93.5 85.9 94 85.7 C 94.4 85.6 94.7 85.4 95.1 85.3 C 95.3 85.2 95.5 85.2 95.7 85.1 C 96 85 96.4 84.9 96.8 84.8 C 96.8 84.8 96.8 84.8 96.9 84.8 C 96.9 84.8 96.9 84.8 96.9 84.8 C 97.4 84.7 97.9 84.6 98.4 84.6 C 98.9 84.5 99.5 84.5 100 84.5 z "}],o["AC.IC.EMT STATION LOCATION"]=[{type:"path",stroke:!1,d:"M 100 55 L 70 80 L 75 80 L 75 125 L 125 125 L 125 80 L 130 80 L 100 55 z M 95 80 L 105 80 L 105 91.3 L 114.8 85.7 L 119.8 94.3 L 110 100 L 119.8 105.7 L 114.8 114.3 L 105 108.7 L 105 120 L 95 120 L 95 108.7 L 85.2 114.3 L 80.2 105.7 L 90 100 L 80.2 94.3 L 85.2 85.7 L 95 91.3 L 95 80 z "},{type:"path",stroke:!1,fill:!!e&&i,d:"M 95 80 L 95 91.3 L 85.2 85.7 L 80.2 94.3 L 90 100 L 80.2 105.7 L 85.2 114.3 L 95 108.7 L 95 120 L 105 120 L 105 108.7 L 114.8 114.3 L 119.8 105.7 L 110 100 L 119.8 94.3 L 114.8 85.7 L 105 91.3 L 105 80 L 95 80 z "}],o["AC.IC.HEALTH DEPARTMENT FACILITY"]=[{type:"path",stroke:!1,d:"M 131.4,83.6 100,68.4 68.5,83.5 z m -26.4,14.6 0,-9.7 -10.1,0 0,9.7 -9.5,0 0,10.4 9.5,0 0,9.5 10.1,0 0,-9.5 9.6,0 0,-10.4 z m -27.2,19.5 0,-27.8 1.4,0 0,-3.7 -7.3,0 0,3.7 1.2,0 0,27.8 -1.2,0 0,3.8 7.3,0 0,-3.8 z m 48.7,0 0,-27.8 1.4,0 0,-3.7 -7.3,0 0,3.7 1.2,0 0,27.8 -1.2,0 0,3.8 7.3,0 0,-3.8 z m -56.4,5.1 0,3 59.4,0 0,-3 z m -1.8,6.1 0,2.8 63.2,0 0,-2.8 z"}],o["AC.IC.MEDICAL FACILITIES OUTPATIENT"]=[{type:"path",stroke:!1,d:"m 81.8,63.6 26.6,9 0,63.9 -26.6,-9.1 v -63.8 l 0,0 z m -1.6,65 29.9,10.4 v -10.6 h 9.8 V 61 H 80.2 v 67.6 l 0,0 z m 21.4,-18.1 c 0,1.1 1,2.6 2.2,2.6 0.8,0 1.2,-0.8 1.2,-1.6 v -0.4 c 0,-1.2 -1.1,-3 -2,-3 -0.8,0 -1.4,0.8 -1.4,1.6 v 0.8 H 101.5 z M 85.9,90.9 c 0.9,0.1 5.3,1.8 5.3,2.4 v 7.1 l 5.7,2.2 v -7.5 l 5.5,1.9 V 89.1 C 101.5,88.8 96.9,87.2 96.9,86.6 V 79.5 L 91.2,77.6 v 7.4 l -5.3,-2 v 7.9 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 81.8 63.6 L 81.8 127.4 L 108.4 136.6 L 108.4 72.7 L 81.8 63.6 z M 91.2 77.6 L 96.9 79.5 L 96.9 86.6 C 96.9 87.2 101.5 88.9 102.3 89.1 L 102.3 97 L 96.8 95.2 L 96.8 102.6 L 91.1 100.4 L 91.1 93.3 C 91.1 92.6 86.8 91 85.9 90.9 L 85.9 83 L 91.2 85 L 91.2 77.6 z M 102.9 108.1 C 103.9 108.1 105 109.9 105 111.2 L 105 111.6 C 105 112.4 104.6 113.2 103.8 113.2 C 102.5 113.2 101.5 111.6 101.5 110.6 L 101.5 110.6 L 101.5 109.8 C 101.5 108.9 102.1 108.1 102.9 108.1 z "}],o["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]=[{type:"path",stroke:!1,d:"m 73.7,89.7 c 0.4,4.9 2.3,11.3 3.4,15.6 1.4,5.7 3.5,8.7 6.1,13.1 2.2,3.6 3.4,9.6 5.6,13.4 0.7,1.3 2.8,5.3 3.6,6 0.5,0.4 5.5,4 5.6,4 1.6,0 9.7,-0.4 10.4,-0.7 0.3,-0.1 4.1,-6.6 4.1,-7 v -3 h -7.8 c -2.7,0 -5.6,-1.3 -8.4,-1.3 V 112.6 c 0,-2.4 1.3,-17.3 2.1,-18 0.8,-0.7 11.4,-8.2 11.9,-8.3 l -1,-8.5 c -0.5,0.2 -5.6,1 -6,0.9 -1,-0.2 -4.7,-1.4 -5.5,-1.8 -1.9,1.1 -4.4,1.8 -6.5,2.7 -1.6,0.7 -3.5,2.7 -5.5,3.7 -2.4,1.2 -3.9,1.7 -6.7,2.5 -1.6,0.4 -2.4,0.4 -3.3,1.5 -0.7,0.8 -1.7,1.8 -2.2,2.5 z m 27.8,36.1 c 0,-8.1 2,-16.8 1.9,-24.8 0,-1.2 0.2,-1.9 0.2,-3.2 0,-1.4 0.4,-1.4 1.2,-2.2 1.2,-1.1 2.4,-2 3.6,-3 2.1,-1.7 5,-4.8 7.1,-6.1 0.3,0.1 0.3,0.2 0.9,0.2 h 4.9 c 0.2,0.8 4.9,6.4 5.8,7.4 2.6,3.1 3.8,3.9 2.9,9.6 -0.5,3.2 -0.7,8.6 -1,12 -0.3,4 -0.9,8.1 -0.9,12.2 l -26.7,-2.2 z m -1.7,1.3 29.8,2.2 2.4,-31.4 -9.8,-12.6 -7.2,-0.3 c -0.2,0 -6.9,5.9 -7.8,6.5 -1.4,1.1 -2.5,2.3 -3.9,3.2 -1.7,1.2 -1.2,3.3 -1.4,5.9 -0.6,8.4 -2.1,18.1 -2.1,26.5 z m 12.8,-9 0.2,0 c 2.3,0 6.5,2.8 8.1,2.8 h 3 V 119.4 H 121.4 c -0.6,0 -6.1,-2.3 -7.2,-2.7 -1.5,-0.6 -6.6,0.3 -8.6,0.3 v 1.3 l 7.1,-0.3 z m -5.6,-7.9 0.2,1.5 c 3.1,-0.7 5.6,-1.4 8.7,-0.8 1.3,0.3 2.8,0.6 4.2,0.9 2.5,0.6 2.8,1.2 3.3,-1 -1.3,0 -6.8,-1.3 -8.4,-1.7 -2.5,-0.7 -5.5,0.4 -8.1,1.1 z m -0.2,-8.1 0.5,1.4 5.7,-1.9 5,3.7 8,-1 -0.3,-1.7 -7.3,1 c -0.8,-0.6 -4.7,-3.6 -5.3,-3.6 -0.5,0 -5.6,1.9 -6.2,2.2 z m 10.7,-7.3 h 1.1 c 1.2,0 2.5,-1.3 2.5,-2.5 v -0.4 c 0,-1.4 -1.6,-2.5 -3,-2.5 -4.4,-0 -3.6,5.5 -0.6,5.5 z M 67.9,81.8 c 0,1.5 3.2,4.4 4.2,5.1 l 1.5,-1.6 -2.1,-4.7 h -2.2 c -0.5,0 -1.5,1.1 -1.5,1.2 z M 110.2,70.5 c 0.8,0.4 2.4,0.8 2.4,1.9 0,0.9 -0.5,1.4 -0.6,2.1 l -2.6,-0.4 c -1,-0.1 -4.2,0.6 -5.8,0.6 v 1.1 c 0,1.1 4,0 5.6,0 h 0.4 c 1.7,0 5.4,1.2 6.2,1.9 0.5,0.5 1.4,5.2 1.9,6.2 1.8,-0.9 1.3,-0.5 0.6,-3.2 -0.3,-0.9 -1.1,-3.1 -1.1,-4 l -3.9,-1.6 1.2,-2.3 c -1.1,-2.1 -0.8,-3.6 -4,-3.6 l -0.3,1.2 z m -36.5,6.6 c 0,0.9 2,4.6 2.2,6 0.3,0.1 1.1,0.4 1.1,0.4 0.3,0 2.1,-0.9 2.8,-1.1 -0.7,-3.1 -1.7,-6.6 -4.3,-7.9 -0.2,0.7 -1.7,2.3 -1.7,2.5 z m 5.9,-3.6 c 1.9,4.1 0.4,3.7 4.2,7 l 2.4,-1.2 v -3.8 c 0,-1.5 -1.2,-3.6 -1.3,-5.3 l -1.9,-0.2 h -1.7 l -1.6,3.7 z m 7.6,-2.8 2.5,5 3.9,-0.8 c 0,-1 0.6,-2.5 0.6,-3.4 0,-2.2 -1.1,-4.7 -1.1,-6.9 H 88.5 l -1.3,6 z M 97.8,62.8 c 0,0.6 0.2,7.2 0.3,7.4 0.3,1 3.7,2.6 5.5,2.4 0.9,-0.1 2.5,-0.3 3.5,-0.4 1.8,-0.2 1.2,-0.6 1.5,-2.6 0.2,-1.9 0.6,-4.9 1.1,-6.8 -0.4,-0.8 -2.4,-4.7 -3.2,-4.7 h -5.1 c -0.7,0 -3,4 -3.5,4.7 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 115.6 86.6 C 113.5 88 110.6 91 108.5 92.7 C 107.3 93.7 106 94.6 104.8 95.7 C 104 96.4 103.6 96.5 103.6 97.8 C 103.6 99.2 103.4 99.9 103.4 101.1 C 103.5 109.1 101.5 117.8 101.5 125.9 L 128.2 128 C 128.2 124 128.8 119.9 129.1 115.8 C 129.3 112.4 129.6 107.1 130.1 103.8 C 131 98.1 129.8 97.3 127.2 94.2 C 126.3 93.1 121.6 87.6 121.4 86.8 L 116.5 86.8 C 115.9 86.8 115.9 86.7 115.6 86.6 z M 118.2 89.3 C 119.5 89.3 121.1 90.4 121.1 91.9 L 121.1 92.3 C 121.1 93.6 119.8 94.9 118.6 94.9 L 117.5 94.9 C 114.5 94.9 113.8 89.3 118.2 89.3 z M 113.1 100 C 113.7 100 117.6 103.1 118.4 103.7 L 125.7 102.6 L 126 104.3 L 118 105.3 L 113 101.6 L 107.3 103.6 L 106.9 102.2 C 107.5 101.9 112.5 100 113.1 100 z M 113.2 109 C 113.9 109 114.5 109.1 115.2 109.2 C 116.7 109.6 122.2 110.9 123.5 110.9 C 123 113 122.7 112.4 120.2 111.8 C 118.8 111.5 117.3 111.2 116 110.9 C 112.8 110.3 110.4 111 107.3 111.8 L 107.1 110.3 C 109 109.8 111.2 109.1 113.2 109 z M 112.5 116.5 C 113.2 116.5 113.8 116.6 114.2 116.8 C 115.2 117.1 120.8 119.4 121.4 119.4 L 123.9 119.4 L 123.9 121 L 121 121 C 119.4 121 115.1 118.2 112.9 118.2 L 112.6 118.2 L 105.6 118.4 L 105.6 117.1 C 107.1 117.1 110.4 116.5 112.5 116.5 z"}],o["AC.IC.TRIAGE"]=[{type:"path",stroke:!1,d:"M 91.6 69 C 87.3 69 83.6 71.5 83.6 75.3 L 83.6 83.3 L 80.5 83.3 C 74 83.3 73.6 88.1 71.2 91.5 C 69.3 94.3 63 94.4 63 100.9 L 63 131 L 137 131 L 137 102.6 C 137 99.5 136.2 97.3 134.7 95.6 C 133.2 94 130.8 93.6 129.1 92 C 126 88.8 126.9 83.3 119.1 83.3 L 116.2 83.3 L 116.2 75.5 C 116.2 71.3 112.9 69 108.4 69 L 91.6 69 z M 89.9 76 L 110.1 76 L 110.1 83.3 L 89.9 83.3 L 89.9 76 z M 95.3 90.4 L 104.4 90.4 L 104.4 99.4 L 112.2 94.9 L 116.8 102.8 L 109.1 107.3 L 116.8 111.9 L 112.1 119.8 L 104.4 115.3 L 104.4 124.1 L 95.3 124.1 L 95.3 115.3 L 87.6 119.7 L 83 111.8 L 90.7 107.3 L 83 102.8 L 87.6 94.9 L 95.3 99.3 L 95.3 90.4 z "},{type:"path",stroke:!1,fill:!!e&&i,d:"m 112.1,119.8 4.6,-7.9 -7.6,-4.6 7.7,-4.5 -4.6,-7.9 -7.7,4.4 -0,-8.9 -9.1,0 0,8.9 -7.7,-4.4 -4.5,7.9 7.6,4.5 -7.6,4.5 4.5,7.9 7.7,-4.4 0,8.8 9.1,0 0,-8.8 z"}],o["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]=[o["GR.IC.FF.EMERGENCY OPERATION"],a("i")],o["AC.IC.FIRE HYDRANT"]=[{type:"path",stroke:!1,d:"m 80,131.3 v -1 c 1.3,0.1 5.7,1.8 7.7,2.2 2.8,0.6 5.8,1 9.1,1 h 6.5 c 3.4,0 6.1,-0.4 8.9,-1 2,-0.4 6.5,-2.1 7.7,-2.2 v 1 c 0,2.9 -12.5,4.5 -16.6,4.5 h -6.4 c -4.1,0 -16.9,-1.6 -16.9,-4.5 l 0,0 z m 17.9,-43.4 4.5,0.1 12.4,0.4 v 8.3 h 6.3 v 11.9 h -6.3 v 17.4 l 4.5,1.3 c -1.2,1.6 -12.2,3.3 -15.8,3.3 h -6.4 c -3.5,0 -15,-1.8 -16,-3.2 l 4.6,-1.6 0.1,-17.2 h -6.3 V 96.7 h 6.3 v -8.3 l 12.4,-0.4 0,0 z m 25.7,5.9 h 3 v 6.7 h 3.2 v 3.9 h -3.2 v 6.7 h -3 V 93.8 z m -50,0 h 2.9 v 17.2 h -2.9 v -6.7 h -3.5 v -3.9 h 3.4 V 93.8 h 0.1 z m 26.1,-8.3 c -5.2,0 -9.7,0.2 -14.8,0.2 -4.4,0 -3.5,-2.6 -1.8,-2.8 2.1,-0.3 4.9,-0.1 6.9,-0.4 5.3,-0.8 23.6,-0.3 28.1,0.8 0.2,1.8 0.4,1.5 -1,2.4 l -15.8,-0.2 -1.6,0.1 z m -1,-21.1 h 2.9 v 3.8 h 2 v 1.8 c 3.2,0.7 5.3,1.1 7.4,3.1 1.3,1.3 3.5,4.3 3.7,6.7 l -10.4,-0.3 -9.9,0.1 0.2,-0.1 -9.1,0.5 c 0.4,-4.7 5.2,-9.7 10.4,-9.7 h 0.8 v -2 h 2 v -3.8 z m -2.6,1.2 h -2 v 2.2 c -5.7,0.5 -10.6,6.6 -11.1,12.5 -2.2,0.2 -2.3,1.3 -3.4,2.1 l -0.2,1.6 c -0.3,2.2 2,3.9 3.6,4.3 v 5.5 h -3.6 v -2.4 h -8.3 v 6.7 h -3.2 V 107 h 3.2 v 6.3 h 8.3 v -2.4 h 3.6 V 123.8 c -2.3,0.6 -5.5,2 -5.5,4.9 v 2 c 0,6.3 12.9,7.7 19.8,7.7 h 5.9 c 6.9,0 19.4,-1.2 19.4,-7.7 v -2 c 0,-2.8 -3,-4.3 -5.3,-4.9 v -12.9 h 3.6 v 2.4 h 8.1 V 107 h 3.2 v -9.1 h -3.2 v -6.4 h -8.1 v 2.4 h -3.6 v -5.5 c 1.6,-0.3 3.6,-1.8 3.6,-3.8 0,-2.2 -1.6,-3.9 -3.6,-4 -0.5,-5.9 -5.7,-12.1 -11.4,-12.6 v -2.2 h -2 V 61.6 h -7.9 v 4 z m 2.9,47.2 c -4,0 -8.3,-5 -8.1,-9.3 0.2,-4.4 4.2,-9 8.3,-9 h 2 c 4.2,0 8.3,4.7 8.3,9.1 0,4.3 -4,9.1 -8.1,9.1 h -2.4 l 0,0 z m -10.5,-9.9 v 1.8 c 0,5.2 5.4,10.8 10.5,10.8 h 2.4 c 5.6,0 10.8,-5.8 10.8,-11.8 0,-6 -5.3,-11.8 -10.9,-11.8 h -2.1 C 93.7,92 88.4,97.5 88.4,103 l 0,0 z m 9.5,0.8 c 0.3,-0.6 0.8,-1.8 1.4,-1.8 h 1.4 c 0.7,0 1.4,1.3 1.4,2 0,0.1 -0.9,1.6 -1.4,1.6 h -1.4 c -0.6,0.1 -1.1,-1.2 -1.4,-1.8 z m -2.9,0 2.2,4.3 h 5 c 0.7,0 2.4,-3.6 2.9,-4.3 l -2.4,-4.5 h -4.9 c -0.8,0.1 -2.5,3.7 -2.9,4.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 97.9,103.8 c 0.3,-0.6 0.8,-1.8 1.4,-1.8 h 1.4 c 0.7,0 1.4,1.3 1.4,2 0,0.1 -0.9,1.6 -1.4,1.6 h -1.4 c -0.6,0.1 -1.1,-1.2 -1.4,-1.8 z m 1.2,-9.1 c -4.1,0 -8.1,4.6 -8.3,9 -0.2,4.3 4.1,9.3 8.1,9.3 l 2.4,0 c 4,0 8.1,-4.9 8.1,-9.1 0,-4.4 -4.1,-9.1 -8.3,-9.1 l -2,0 z m -1.2,4.7 4.9,0 2.4,4.5 c -0.4,0.7 -2.1,4.3 -2.9,4.3 l -5,0 -2.3,-4.3 c 0.4,-0.8 2.1,-4.4 2.9,-4.5 z M 98.7,64.5 h 2.9 v 3.8 h 2 v 1.8 c 3.2,0.7 5.3,1.1 7.4,3.1 1.3,1.3 3.5,4.3 3.7,6.7 l -10.4,-0.3 -9.9,0.1 0.2,-0.1 -9.1,0.5 c 0.4,-4.7 5.2,-9.7 10.4,-9.7 h 0.8 v -2 h 2 v -3.8 z m 1,21.1 c -5.2,0 -9.7,0.2 -14.8,0.2 -4.4,0 -3.5,-2.6 -1.8,-2.8 2.1,-0.3 4.9,-0.1 6.9,-0.4 5.3,-0.8 23.6,-0.3 28.1,0.8 0.2,1.8 0.4,1.5 -1,2.4 l -15.8,-0.2 -1.6,0.1 z m -26.1,8.3 h 2.9 v 17.2 h -2.9 v -6.7 h -3.5 v -3.9 h 3.4 V 93.8 h 0.1 z m 50,0 h 3 v 6.7 h 3.2 v 3.9 h -3.2 v 6.7 h -3 V 93.8 z m -25.7,-5.9 -12.4,0.4 0,8.3 -6.3,0 0,11.9 6.3,0 -0.1,17.3 -4.6,1.6 c 1.1,1.5 12.5,3.3 16,3.3 l 6.4,0 c 3.6,0 14.7,-1.7 15.8,-3.3 l -4.5,-1.3 0,-17.4 6.3,0 0,-11.9 -6.3,0 0,-8.3 -12.4,-0.4 -4.5,-0.1 z m 1.2,4.2 2.1,0 c 5.7,0 10.9,5.8 10.9,11.8 0,5.9 -5.2,11.8 -10.8,11.8 l -2.4,0 c -5.2,0 -10.5,-5.6 -10.5,-10.8 l 0,-1.8 c 0,-5.5 5.3,-11 10.7,-10.9 z M 80,131.3 v -1 c 1.3,0.1 5.7,1.8 7.7,2.2 2.8,0.6 5.8,1 9.1,1 h 6.5 c 3.4,0 6.1,-0.4 8.9,-1 2,-0.4 6.5,-2.1 7.7,-2.2 v 1 c 0,2.9 -12.5,4.5 -16.6,4.5 h -6.4 c -4.1,0 -16.9,-1.6 -16.9,-4.5 l 0,0 z"}],o["AC.IC.OTHER WATER SUPPLY LOCATION"]=[{type:"path",stroke:!1,d:"m 113.2,116.5 c 0,-2.9 4.4,-9.3 5.8,-11.8 2.8,-5 3.1,-6.8 4.6,-13 2.1,1.4 2.2,4.3 3,7.1 0.8,2.8 1.6,4.8 2.9,7 2.2,3.8 6.7,8 5,14.1 -1.6,5.8 -5.2,7.8 -12.2,7.5 -5.8,-0.2 -9.1,-4.9 -9.1,-11 z m -1.2,-0.4 v 0.6 c 0,7.5 4.6,12.2 12,12.2 6.8,0 12,-4.6 12,-11 v -1.3 c 0,-5 -4.7,-10 -6.6,-13.8 -1.1,-2.2 -1.6,-5.5 -2.3,-8.1 -0.9,-3.3 -2.4,-4 -4.8,-5.6 0,13.6 -10.3,20 -10.3,26.8 z m 4.8,3.6 c 0,2.4 1.8,4.4 3.8,4.4 0.7,0 1.5,-0.6 1.7,-1.3 -1.6,-0.4 -3.2,-2.5 -3.4,-4.4 l -2.1,1.3 z M 89.2,73 v 15.8 h -2.1 v -15.8 l 0.6,-0.1 1.5,0.1 z m -10.4,2.3 h 6.6 v 11 H 78.8 v -11 z m 37.2,1.1 c 0,-0.5 0.2,-0.6 0.6,-0.6 h 1.5 c 0.5,0 0.6,0.2 0.6,0.6 v 9.1 h -2.8 v -9.1 z m -24.9,-1.3 22.8,2.4 v 6.5 l -22.8,1.9 v -10.7 z m -27,11.8 h 12.9 v 1 l 8.3,0.1 1.2,2.4 1.6,0.3 c 0.6,0.1 1,-0.2 1.8,-0.3 l 0.9,-0.6 0.2,-2.4 22.8,-1.6 c 1.2,2.5 4.2,1.6 6.6,1 0,-0.7 0.2,-0.8 0.2,-1.5 v -9.5 c 0,-1.5 -0.8,-2.1 -2.3,-2.1 h -2.1 c -3.8,0 0.2,2.5 -5,1.6 -2.1,-0.4 -4.6,-0.4 -6.7,-0.7 -3.3,-0.5 -10.4,-1.3 -13.5,-1.3 -0.1,-3.1 -5.6,-3.3 -5.7,0.4 h -8.4 v 0.6 h -13 l 0.1,12.4 0,0 z m 15.6,-4.8 0,1.9 4.6,0 0,-1.9 z m 0,-4.2 0,1.7 4.6,0 0,-1.7 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 91,75.1 22.8,2.4 v 6.5 l -22.8,1.9 v -10.7 z m 24.9,1.3 c 0,-0.5 0.2,-0.6 0.6,-0.6 h 1.5 c 0.5,0 0.6,0.2 0.6,0.6 v 9.1 h -2.8 v -9.1 z M 78.8,75.3 l 0,11 6.6,0 0,-11 -6.6,0 z m 0.8,2.6 4.7,0 0,1.7 -4.7,0 0,-1.7 z m 0,4.2 4.7,0 0,1.9 -4.7,0 0,-1.9 z M 123.5,91.8 c -1.4,6.2 -1.8,8 -4.6,13 -1.3,2.5 -5.8,8.9 -5.8,11.8 0,6.1 3.3,10.8 9.1,11 7,0.2 10.5,-1.7 12.2,-7.5 1.7,-6.1 -2.8,-10.3 -5,-14.1 -1.3,-2.2 -2,-4.3 -2.9,-7 -0.8,-2.8 -0.9,-5.7 -3,-7.1 z m -4.6,26.7 c 0.2,1.9 1.8,4 3.4,4.4 -0.2,0.6 -1,1.3 -1.7,1.3 -2,0 -3.8,-2.1 -3.8,-4.4 l 2.1,-1.3 z M 89.2,73 v 15.8 h -2.1 v -15.8 l 0.6,-0.1 1.5,0.1 z"}],o["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]=a("€$£"),o["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 87.9,87.3 c -3.2,0 -5.8,2.6 -5.8,5.8 0,2.8 2.1,5.2 4.8,5.7 l 0,3.3 -3.8,0 0,2 3.8,0 0,9.4 2,0 0,-9.4 3.8,0 0,-2 -3.8,0 0,-3.3 c 2.7,-0.5 4.8,-2.8 4.8,-5.7 0,-3.2 -2.6,-5.8 -5.8,-5.8 z m 24,0 c -3.2,0 -5.8,2.6 -5.8,5.8 0,2.8 2.1,5.2 4.8,5.7 l 0,3.3 -3.8,0 0,2 3.8,0 0,9.4 2,0 0,-9.4 3.8,0 0,-2 -3.8,0 0,-3.3 c 2.7,-0.5 4.8,-2.8 4.8,-5.7 0,-3.2 -2.6,-5.8 -5.8,-5.8 z m -24,2 c 2.1,0 3.8,1.7 3.8,3.8 0,2.1 -1.7,3.8 -3.8,3.8 -2.1,0 -3.8,-1.7 -3.8,-3.8 0,-2.1 1.7,-3.8 3.8,-3.8 z m 24,0 c 2.1,0 3.8,1.7 3.8,3.8 0,2.1 -1.7,3.8 -3.8,3.8 -2.1,0 -3.8,-1.7 -3.8,-3.8 0,-2.1 1.7,-3.8 3.8,-3.8 z m 24.2,37.8 0,-3 -72.1,0 0,3 z m -3,-6.2 0,-2.8 -66.2,0 0,2.8 z M 66.8,98.2 c 0,1.3 -0.7,2.6 -0.7,4.3 -0,1.8 -0.2,3.1 -0.2,5 v 3.2 l 0.6,3.6 h 2.7 l -0.8,-6.4 v -1.8 c 0,-8.1 5,-17.9 9.3,-21.5 5.6,-4.6 11.6,-9.1 21.7,-9.1 h 0.9 c 9,0 17.1,4.4 21.6,8.8 3.2,3.2 4.1,4.7 6.4,8.7 1.4,2.4 3.3,8.4 3.3,12 v 4.3 c 0,1.4 -0.7,3 -0.7,4.4 v 0.5 h 2.7 l 0.6,-6.4 v -3.8 c 0,-1.6 -1,-5.2 -1.4,-6.6 -0.8,-2.5 -1.3,-3.6 -2.3,-5.7 -1.8,-3.8 -3.8,-6.4 -6.7,-9.3 -4.6,-4.6 -13.6,-9.6 -22.6,-9.6 h -2.5 c -7.8,0 -16.6,4.1 -20.6,7.9 -2.8,2.7 -4.4,4.1 -6.7,7.5 -1.1,1.6 -1.5,3 -2.5,4.6 -0.9,1.6 -1.2,4 -2,5.2 z"}],o["GR.IN.IC.RECREATIONAL AREA"]=[{type:"path",stroke:!1,d:"m 96.4,78.8 8.1,-0 c 0.9,0 2.4,5.7 2.4,6.9 l 1.5,4.3 c 0,0.4 2,6.6 2,7 v 0.6 l -19.4,-0 5.4,-18.8 z m -19.9,-0 11.1,0 -3.5,11.2 c 0,1.7 -1.9,5.7 -1.9,6.9 v 0.6 h -20.8 v 7.2 l 18.5,0 -1.2,3 -0.1,0.8 -2.6,8.3 -3.6,11.5 c 1.1,0 9.3,0.1 9.7,-0.1 0.2,-0.1 2,-6.8 2.3,-7.7 0.5,-1.2 4.5,-15 4.5,-15.2 v -0.6 l 23.5,0 6.7,23.6 9.8,0 -1.4,-4.8 -0.7,-2.6 -2.4,-7.8 -0.9,-2.8 -1.7,-5.7 h 15.8 v -7.2 h -18.2 l -2.9,-8.9 -0.1,-0.8 -1,-3 -1.7,-6.2 h 10.6 v -7.2 h -47.9 v 7.2 l 0,0 0,0 z m 62.1,16.9 0,-6.1 -15.2,0 0,6.1 z m -62.3,0 0,-6.1 -14.9,0 0,6.1 z"}],o["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 73.1,111.2 c 0,-3.8 1,-5.8 2.3,-8.4 1.4,-2.8 3.3,-3.8 4.6,-5.8 l -1.1,-8.2 c -2.6,0.7 -7.7,6.5 -9.2,9 -2.4,4.1 -3.8,7.9 -3.8,14.2 v 3.3 c 0,2.2 2.2,8.1 3.1,9.6 2,3.2 3,4.5 5.5,7.1 3.6,3.6 10.7,7.1 17.9,7.1 h 1 c 4.9,0 9.9,-1.6 13.1,-3.6 1.7,-1 8.5,-6.2 8.5,-7.8 0,-1.2 -3.1,-6.6 -3.5,-8.4 -1.2,1.5 -1.6,3 -3,4.8 -1.2,1.5 -2.3,2.7 -3.8,3.8 -2.6,2 -6.8,4 -11.3,4 h -1.2 c -10.2,0 -19.1,-9 -19.1,-19.3 v -1.4 l 0,0 z m 8.9,-37.9 c 0.5,0.4 0.5,2.9 0.5,4 L 85,106.8 l 25.4,0 10,23 c 1.5,-0.1 5.5,-1.5 7.1,-2.1 1.2,-0.4 6.5,-1.4 6.5,-2.6 v -0.2 c 0,-0.7 -1.9,-4.8 -2,-6.3 l -7.6,2.6 -9,-21.6 H 91.6 l -0.4,-6 h 17.3 v -5.4 H 90.8 l -1.1,-12.9 c 2.6,-0.2 5.2,-3.9 5.2,-6.7 v -2.2 h -0.5 v -0.8 c 0,-0.8 -2.1,-3.1 -2.7,-3.5 -1,-0.7 -3.3,-1.6 -4.8,-1.3 -2.2,0.4 -3.2,0.8 -4.4,2 -0.7,0.7 -2.2,3.2 -2.2,4.3 v 1.2 c 0,2.4 0.8,3.6 1.7,4.9 l 0,0 z m 0.5,4 c 0,-1.1 0,-3.6 -0.5,-4 0,1.1 -0,3.6 0.5,4 z"}],o["GR.IN.IC.ADULT DAY CARE"]=[{type:"path",stroke:!1,d:"m 107,118.3 v -0.2 c 0,-15.5 22.4,-14.7 22.4,-0.6 v 1.3 c 0,5.4 -5.3,10.4 -10.8,10.4 h -0.6 c -5.9,0 -11,-5.1 -11,-11 z m -1.6,-22.2 h 4.6 v 10 c 0,0 -3.2,3.3 -3.8,4.3 -0.5,0.8 -2.2,4.7 -2.2,5.8 v 2.3 c 0,6.8 6.6,13.7 13.3,13.7 h 1 c 5.8,0 10.8,-5 11,-5 h 7.1 v -1.9 h -3.2 c 0.2,-0.5 0.8,-1.3 0.8,-1.9 v -11 c 0,-1.9 -1,-3.3 -2.1,-4 h -3.3 l -0.8,-0.7 c 1.1,-0.3 2,-0.9 2,-2.2 v -0.4 c 0,-0.5 -1,-1.7 -1.6,-1.7 h -5 v -5.4 c 0,-2.7 -1.5,-4.2 -4.2,-4.2 h -2.1 c -5.9,0 -4.6,5.8 -4.6,11.6 l -0.6,0.4 V 94.7 c -0.4,-0.2 -0.4,-0.4 -0.8,-0.4 h -5.4 v 1.7 z m -22.6,1 c 0,-2.2 3.3,-4.8 4.5,-6.6 1.4,1 1.4,1.8 3.4,2.8 1.4,0.7 2.6,1.4 4,1.9 2.4,0.9 2.2,-0.1 4.3,1.9 0.9,0.9 1.8,2.5 3.5,2.5 0.4,0 0.8,-0.8 0.8,-1.3 v -1.1 c 0,-2.8 -3.3,-3.6 -5.3,-4.5 -2.3,-0.9 -5.3,-1.6 -6.1,-3.8 -0.8,-2.3 -2.2,-4.6 -2.9,-6.9 -0.7,-2.1 -1.9,-5.1 -4.6,-5.1 h -0.4 c -3,0 -7.4,7.5 -8.1,10.4 -0.6,2.3 -1.6,4.7 -2.1,7.2 -0.5,2.8 -0.6,5.2 -1.1,8 -0.3,1.8 0.1,2.3 -0.6,4 -0.4,1.2 -0.8,2.3 -1.2,3.4 -0.9,2.3 -1.7,4.6 -2.5,6.8 -0.8,2.1 -4.9,11.8 -4.9,13.5 0,2.6 6.2,1.3 7.7,1.1 -0,-1.9 -2.3,-1.6 -3.1,-2.7 2.1,-3.1 3.8,-6.3 5.8,-9.5 1,-1.7 4.6,-9.2 5.4,-9.8 0.6,0.4 3,3.1 3.8,3.9 1.9,1.9 2,1.8 2.8,4.8 1.1,4.2 1.9,7.7 1.9,13.1 l 1.7,0.2 4.2,-0 c 1.3,0 1.8,-0.2 2.3,-1 -0.6,-1 -3.1,-1.7 -4.6,-2.1 v -1.1 c 0,-0.4 -0.1,-0.4 -0.4,-0.8 v -12.1 c -1.5,-2.3 -2.9,-4.9 -4.6,-7.1 -1.1,-1.6 -3.8,-5.2 -3.8,-7.6 v -2.5 l 0,0 z m 30.3,-9.7 v 1.6 c 0,1.5 2.3,3.9 4.2,3.9 h 0.8 c 2.1,0 4.2,-2.3 4.2,-4.5 V 87.6 c 0,-2.2 -2.2,-4.2 -4.5,-4.2 h -0.1 c -2.3,-0 -4.6,2 -4.6,4 z m -28.4,-15.6 v 1.7 c 0,0.6 1,2.1 1.4,2.5 0.6,0.6 1.8,1.2 2.9,1.2 h 1 c 2,0 4.2,-2.2 4.2,-4 v -1.4 c 0,-1.6 -2.5,-3.9 -4.5,-3.9 h -0.7 c -1.8,0 -4.2,2.2 -4.2,3.9 z"}],o["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 79.5,127.9 h -7.8 v -21.4 c 0,-1 6.8,-13.3 7.4,-13.6 1,-0.6 13.9,-7.1 14.1,-7.1 0.5,0 13.2,6.3 14.4,7 0.4,0.3 7.7,13.1 7.7,13.7 v 21.4 h -7.6 V 110.4 H 79.5 v 17.5 z m 37.4,-39.4 h 15.4 v 39.8 h -12.1 v -18.8 h 2.6 c -0.5,-0.8 -5.8,-9.8 -5.8,-10 V 88.5 z m 0.2,-1.9 c 0,-4.4 2.9,-8.2 7.2,-8.2 h 0.4 c 4.5,0 7.6,3.7 7.6,8.2 h -15.2 v 0 z M 105.2,82.1 h 8.9 c -0.2,1.6 -0.9,2.5 -0.9,5 0,2 0,3.9 0,5.8 -1.4,-1 -0.9,-2.8 -3.2,-4 -1.2,-0.6 -3.8,-2 -4.8,-2.3 v -4.6 z m 0,-2.8 c 0,-2.8 3.8,-7.4 6.9,-7.4 h 0.6 c 3.1,0 5.5,1.8 6.7,3.7 -0.2,0.2 -4.8,4.3 -4.8,4.3 h -9.5 v -0.6 z m -11.9,1.5 c -3.2,1.7 -6.6,3.2 -9.9,4.8 -1.7,0.9 -3.3,1.5 -5,2.4 -2.8,1.4 -2.3,0.7 -4,3.1 -0.9,1.3 -1.8,3.2 -2.7,4.7 -0.9,1.6 -1.9,3 -2.8,4.6 -1.6,2.9 -3.6,6.5 -5.4,9.1 h 2.8 v 22.5 H 84 V 114.7 h 19 v 17.3 h 33.3 V 87.5 c 0,-7.5 -4.2,-13 -11.7,-13 h -1.7 c -0.8,-2.9 -5.9,-6.5 -10,-6.5 h -0.4 c -6.4,0 -11,5.9 -11,12.1 v 4.6 l -8.2,-3.9 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 79.5,110.4 h 28.1 v 17.5 h 7.6 v -21.4 c 0,-0.6 -7.2,-13.4 -7.7,-13.7 -1.1,-0.8 -13.8,-7.1 -14.4,-7.1 -0.1,0 -13,6.5 -14.1,7.1 -0.6,0.4 -7.3,12.6 -7.3,13.6 v 21.4 h 7.8 v -17.5 z m 37.4,-10.8 c 0,0.1 5.3,9.2 5.8,10 h -2.6 v 18.8 h 12.1 v -39.8 h -15.4 v 11 z m 0.2,-13 h 15.1 c 0,-4.6 -3,-8.2 -7.6,-8.2 h -0.4 c -4.2,-0 -7.2,3.8 -7.2,8.2 z m -11.9,0 c 1.1,0.2 3.6,1.7 4.8,2.3 2.2,1.1 1.7,3 3.2,3.9 0,-2 0,-3.9 0,-5.8 0,-2.5 0.7,-3.4 0.9,-5 h -8.9 v 4.6 z m 0,-7.4 v 0.6 h 9.5 c 0,0 4.6,-4.1 4.8,-4.3 -1.2,-1.8 -3.6,-3.7 -6.7,-3.7 h -0.6 c -3.1,0 -6.9,4.6 -6.9,7.4 z"}],o["GR.IN.IC.AGRICULTURAL LABORATORY"]=[{type:"path",stroke:!1,d:"m 98.4,77.9 -0.1,0.3 2.6,0.6 0,-0.3 z m 2.1,7.3 0.4,-3.2 -0.3,-0.1 -0.4,3.2 z m -3.8,-16.8 0.1,-0.2 -1.4,-0.3 1,-2.6 -0.4,-0.3 -1.7,5.7 0.1,0 0.3,-0.1 0.7,-2.4 z m -1,5.3 c 0.8,0 0.5,-1.7 0.8,-2.3 l -0.4,-0.1 -0.4,2.4 z m 1.4,-5.5 0.6,-2.6 -0.4,-0.1 -0.6,2.7 z m 0.2,-2.7 0.1,-0.3 -1,-0.2 -0.1,0.2 z m 11.8,65.6 0,5.6 3.3,0 c 1.1,0 1.9,-0.2 2.4,-0.7 0.5,-0.5 0.8,-1.2 0.8,-2.1 -10e-6,-0.9 -0.3,-1.6 -0.8,-2.1 -0.5,-0.5 -1.3,-0.7 -2.4,-0.7 l -3.3,0 m 0,-6.2 0,4.6 3,0 c 1,0 1.7,-0.2 2.2,-0.6 0.5,-0.4 0.7,-1 0.7,-1.7 -10e-6,-0.8 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.6 -2.2,-0.6 l -3,0 m -2.1,-1.7 5.2,0 c 1.6,1e-5 2.8,0.3 3.6,1 0.8,0.7 1.3,1.6 1.3,2.8 -2e-5,0.9 -0.2,1.7 -0.7,2.2 -0.4,0.5 -1.1,0.9 -1.9,1 1,0.2 1.8,0.7 2.3,1.4 0.6,0.7 0.8,1.5 0.8,2.6 -1e-5,1.4 -0.5,2.4 -1.4,3.1 -0.9,0.7 -2.2,1.1 -3.9,1.1 l -5.4,0 0,-15.2 m -9.2,2 -2.8,7.5 5.6,0 -2.8,-7.5 m -1.2,-2 2.3,0 5.8,15.2 -2.1,0 -1.4,-3.9 -6.8,0 -1.4,3.9 -2.2,0 5.8,-15.2 m -16,0 2.1,0 0,13.4 7.4,0 0,1.7 -9.4,0 0,-15.2 M 98.6,92.5 c 0.9,-0.2 0.8,-1.8 1.1,-2.6 l 0.9,0.4 -1.4,4.2 -0.6,-2 z m -0.2,-0.4 0.1,0.2 c -0.5,-0.1 -0.8,-1.3 -0.8,-1.9 l 0.4,0.6 -0.3,-2.2 1.6,0.8 c -0,0.7 -0.4,2.3 -0.9,2.4 z m -0.9,-2.3 -0.6,-1.4 c 0.4,0.1 0.6,0.3 0.6,0.9 v 0.5 z m 2.6,-4.4 -0.6,3.9 -1.7,-0.8 v -3.4 -0.3 l 2.3,0.6 z m -2.6,-1.1 0.4,0.1 v 0.4 h -0.4 v 3.5 l -0.8,-0.4 0.1,0.4 h -0.2 c 0,-0.9 -1.2,-2.8 -1.6,-3.5 0.1,-0.1 0.1,-0.1 0.1,-0.4 v -0.4 l 2.4,0.6 0,-0.4 z m 6.1,-1.7 2.5,0.6 v 0.4 c 0,0.2 0,0.2 0.1,0.3 -1.2,0 -1.9,0.4 -2.8,0.8 l 0.2,-2 z m -6.1,1.7 -2.4,-0.8 0.1,-1.8 v -1 l 2.4,0.5 -0.2,3 z m 8.6,-1.6 c -0.3,0 -2.3,-0.4 -2.4,-0.6 0,0 0.2,-2.3 0.2,-2.7 l 2.2,0.4 0.1,1.6 -0,1.2 z m -12.7,-2.4 c 0.4,0 0.7,0.2 1.1,0.2 0.8,0.2 0.4,0.1 0.4,0.7 v 2.1 c -0.3,-0 -0.7,-0.2 -1,-0.3 -0.7,-0.2 -0.5,0.1 -0.5,-0.4 v -2.4 z m 10.7,-4.2 1.7,0.4 0.3,3 -2.2,-0.4 0.2,-3 z m -6.4,5.2 v -0.4 l -2.4,-0.5 0.3,-2.8 2.4,0.5 -0.2,2.9 h 0.3 v 0.4 h -0.3 z m -4,-4.2 1.6,0.4 -0.3,2.9 -1.5,-0.4 0.2,-2.9 z m 7.6,1.4 0.3,-3.1 2.4,0.6 -0.3,3 -2.4,-0.5 z m -0.4,-0.1 0.4,0.1 v 0.4 c 0.4,0 2.3,0.4 2.4,0.6 0,0.1 -0.2,2.3 -0.2,2.6 -0.8,0 -1.6,-0.4 -2.3,-0.4 -0.2,0 -0.2,0.2 -0.2,0.4 l 2.4,0.5 -0.2,2.2 h 0.2 c -0.5,0.7 -1.1,1.6 -1.4,2.4 -0.3,0.8 -0.7,2.1 -1.1,2.8 l -0.9,-0.4 0.6,-4 h -0.2 l -0.2,-0.1 v -0.4 l -2.3,-0.7 0.2,-3 2.5,0.5 v -0.3 h 0.4 l 0.2,-2.8 h -0.3 l -0.3,2.7 -2.4,-0.4 0.2,-2.9 c -0.3,-0.1 -0.2,0 -0.3,-0.4 h 0.2 l 0.2,0.1 0.4,-3.2 2.4,0.6 -0.3,3.1 z m 3.2,-5.4 v -0.3 l 0.3,0.1 v 0.3 c 1,0.1 1.1,0.1 1.2,1 0,0.3 0.2,1.8 0.3,1.9 l -1.7,-0.3 v 0.4 h -0.3 v -0.5 l -2.4,-0.6 0.3,-2.5 2.3,0.4 z m 0.2,-0.2 0.2,-2.9 c 0.6,0.1 0.7,2.4 0.8,3.1 l -1,-0.2 z m -5.1,-0.9 2.4,0.5 -0.3,2.6 -2.4,-0.6 0.4,-2.5 z m 4.9,0.8 c -3.3,-0.8 -2,0 -2,-3.3 l 2.2,0.4 -0.2,2.9 z m -4.4,-3.8 c 3.2,0.8 1.9,-0.2 1.9,3.2 l -2.3,-0.5 0.4,-2.7 z m -2.5,-0.4 2.1,0.4 -0.4,2.7 -2.2,-0.4 0.4,-2.6 z m 7.1,1.3 v -0.4 l -2.2,-0.4 0.2,-2.6 c 0.3,0 0.7,0.1 1.1,0.2 0.6,0.1 0.5,0 0.7,0.6 0.3,1 0.3,0.9 0.3,2.2 l 0.3,0.4 -0.4,0.1 z m -4.1,-3.9 1.8,0.4 -0.2,2.6 -2.1,-0.4 0.4,-2.6 z m 2.3,-2.2 1.4,2.6 -1.5,-0.2 0.1,-2.4 z m -1.6,-1.6 0,-0.1 1.2,1.2 -0.1,0 c 0.3,-0.1 0.3,-0.1 0.4,0.3 l -0.2,-0.2 -0.2,2.6 -1.8,-0.4 0.7,-3.5 z m -2.9,3 c 0.5,-1.1 0.3,-3.4 1.9,-3.4 0.3,0 0.2,0 0.5,0.1 l -0.6,3.7 -1.8,-0.4 z m -0.4,-0.1 0.4,0.1 v 0.3 l 1.8,0.4 -0.4,2.6 -2.1,-0.4 v 0.2 l -0.1,0.2 -0.2,-0.1 h -0.2 l -0.5,2.6 -1.6,-0.3 v 0.3 c 0.5,0 1,0.3 1.4,0.3 0.2,0 0,-0.2 0.5,-0.2 v 0.4 l 2.2,0.4 -0.3,2.4 -2.4,-0.6 v 0.4 l 2.3,0.6 -0.3,3.1 -2.4,-0.6 0.4,-3.2 h -0.4 c -0,0.8 -0.3,1.7 -0.3,2.4 -0,0.8 -0,0.7 -0.7,0.5 -0.2,-0 -0.9,-0.1 -0.9,-0.3 -0,-0.3 0.2,-2 0.3,-2.4 0.2,-1.2 0.5,-0.4 1.7,-0.3 l 0.1,-0.3 c -0.2,-0.1 -1.6,-0.3 -1.6,-0.5 0,-0.8 0.4,-1.5 0.4,-2.3 -0.6,0.1 -0.7,2.3 -0.8,3 -0.1,0.8 -0.4,2.6 -0.4,3.3 0,0.8 -0.2,2.4 -0.2,3.5 0,1.3 -0.1,2.4 -0.1,3.8 h 0.3 v -0.9 l 1.5,0.4 v 1 l -3.4,-0.5 h -0.1 c -5,0 -8.8,9.7 -8.8,15.4 0,2.3 0.8,5.4 2,6.2 0.7,-1.4 1.3,-3.1 2,-4.6 0.8,-1.5 1.4,-3.1 2.1,-4.6 0.3,-0.7 0.7,-1.5 1,-2.2 0.4,-0.8 0.8,-1.5 1.8,-1.2 0.9,0.3 1.9,3.2 2.1,4.6 0.5,3.8 0,9 0.6,12.6 0.7,4 2.3,6.4 5.4,8 1,-0.4 2.5,-0.6 3.4,-1.2 0.9,-0.6 1.8,-1.2 2.4,-2.2 1.2,-1.8 2,-4.1 2,-7.2 l 0,-0.6 -0.3,-5.6 v -0.3 c 0,-2.7 0.5,-8.3 2.8,-8.3 h 0.1 c 1.4,0 2,0.6 2.6,1.4 0.6,0.8 1.2,1.4 1.8,2.2 1.2,1.5 2.6,2.9 2.6,5.5 v 0.6 l 0.4,0.1 c 0.4,-1.6 1.8,-2.8 1.8,-5.2 v -1.5 c 0,-3.5 -1.4,-6.2 -3,-8.3 -0.8,-1.1 -1.8,-2 -2.8,-2.8 -0.7,-0.5 -2.7,-1.9 -3.8,-1.9 l -0.8,-0 -2.3,0.4 c -0.2,-0.8 0.1,-2 -0.1,-3.1 -0.1,-0.8 -0.2,-2.5 -0.2,-3.3 -0.2,-2.1 -0.5,-4.2 -0.9,-6.1 -0.6,-3.3 -2,-8.2 -4.6,-9.4 v 0.3 l -0.4,-0.1 0.1,-0.3 -0.8,-0.1 c -0.9,-0.1 -1.9,0.8 -2.3,1.3 -0.2,0.3 -1.7,2 -0.8,2 0.2,-0.6 1.3,-2.2 1.8,-2.4 l -0.8,2.7 z m 3,20.4 1.6,0.5 0.2,-0 c -0.1,-0.5 -1.4,-0.6 -1.8,-0.8 v 0.4 z m 3.6,-9.8 0.2,-2.6 -0.2,-0.1 -0.2,2.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 98.6,92.5 0.6,2 1.4,-4.2 -0.9,-0.4 c -0.3,0.7 -0.2,2.3 -1.1,2.6 z m -0.6,-1.4 -0.3,-0.6 c 0,0.6 0.4,1.8 0.8,1.9 l -0.1,-0.2 c 0.6,-0.2 0.9,-1.8 1,-2.4 l -1.6,-0.8 0.2,2.2 z m 2.4,-5.9 c 0.4,0.2 1.7,0.3 1.8,0.8 l -0.2,0 -1.6,-0.5 -0.6,4 0.9,0.5 c 0.4,-0.7 0.8,-2 1.1,-2.8 0.4,-0.8 1,-1.7 1.4,-2.4 h -0.2 l 0.2,-2.3 -2.4,-0.5 -0.4,3.2 z m -1,4.1 0.6,-3.9 -2.3,-0.6 0,0.2 0,3.4 z m 0.6,-4.2 0.4,-3.2 -2.5,-0.5 -0.2,3 z m 0.7,-6.6 0.3,-3.1 -2.4,-0.6 -0.4,3.2 z m -5.1,-4.8 -0.1,0.3 c -1.2,-0 -1.5,-0.9 -1.7,0.3 -0.1,0.4 -0.3,2.1 -0.3,2.4 0,0.2 0.7,0.2 1,0.3 0.7,0.2 0.7,0.2 0.7,-0.5 0,-0.8 0.3,-1.7 0.4,-2.4 h 0.4 l -0.4,3.2 2.4,0.6 0.4,-3.2 -2.3,-0.5 v -0.4 l 2.3,0.6 0.3,-2.4 -2.2,-0.4 c -0.3,0.6 0,2.3 -0.8,2.3 z m 8.3,-1 0.2,-2.9 -2.2,-0.4 c 0,3.4 -1.3,2.6 2,3.3 z m -6.2,11.7 -0.4,-0.1 v 0.4 l -2.4,-0.6 v 0.4 c 0,0.2 -0,0.2 -0.1,0.4 0.4,0.7 1.6,2.6 1.6,3.5 h 0.2 l -0.1,-0.4 0.8,0.4 v -3.5 h 0.4 l -0,-0.4 0,0 z m -0.3,5.4 0,-0.6 c 0,-0.5 -0.2,-0.8 -0.6,-0.9 l 0.6,1.4 z m 2.6,-4.8 0,0.4 0.2,0.1 0.2,0 0,-0.3 z m 3.3,-0.4 c 0.8,-0.4 1.5,-0.8 2.8,-0.8 -0.1,-0.1 -0.1,-0.1 -0.1,-0.2 v -0.4 l -2.5,-0.6 -0.2,2 z m -8.3,-1.1 2.4,0.8 0.2,-3 -2.5,-0.5 0,1 z m -1.8,-0.8 c 0,0.5 -0.2,0.2 0.5,0.4 0.3,0.1 0.6,0.2 1,0.3 v -2.1 c 0,-0.7 0.4,-0.6 -0.4,-0.7 -0.4,-0.1 -0.7,-0.2 -1.1,-0.2 v 2.4 z m 7.5,-4 h 0.3 l -0.2,2.8 h -0.4 v 0.4 l 0.3,0.1 c 0,-0.2 0,-0.4 0.2,-0.4 0.7,0 1.6,0.4 2.3,0.4 0,-0.3 0.3,-2.5 0.2,-2.6 -0,-0.2 -2,-0.6 -2.3,-0.6 v -0.4 l -0.4,-0.1 v 0.3 z m 3.3,-8.9 0.4,-0 -0.3,-0.4 c 0,-1.3 -0,-1.2 -0.3,-2.2 -0.2,-0.6 -0,-0.5 -0.7,-0.6 -0.4,-0.1 -0.8,-0.2 -1.1,-0.2 l -0.2,2.6 2.2,0.4 v 0.4 z m -2.4,-0.9 0.2,-2.6 -1.8,-0.4 -0.4,2.6 z m 4.4,13.8 0,-1.2 -0.1,-1.6 -2.2,-0.4 c 0,0.4 -0.2,2.7 -0.2,2.7 0.1,0.2 2.2,0.6 2.4,0.6 z m -7.8,-4.6 -0.2,2.9 2.4,0.4 0.3,-2.7 z m -0.2,3.2 0,-0.4 -0.3,0 0.2,-2.9 -2.3,-0.5 -0.3,2.8 2.4,0.5 0,0.4 z m -3.1,-1 0.3,-2.9 -1.6,-0.4 -0.2,2.9 z m 11.1,-0.8 -0.3,-3 -1.7,-0.4 -0.2,3 z m -2,-6.6 -2.3,-0.4 -0.3,2.5 2.4,0.6 z m -0.4,6 0.2,-3 -2.4,-0.6 -0.2,3.1 z m -2.4,-4 0.3,-2.6 -2.3,-0.5 -0.3,2.5 z m -2.9,3.2 0.1,-0.3 -0.2,-0.1 h -0.2 c 0,0.4 -0.1,0.3 0.2,0.4 z m 5.8,-2.4 1.7,0.3 c -0.1,-0.2 -0.2,-1.6 -0.3,-1.9 -0.1,-1 -0.2,-1 -1.2,-1 l -0.2,2.6 z m 0,0.3 0,-0.3 -0.3,-0.1 0,0.4 z m 0.2,-3 0,-0.3 -0.2,-0.1 0,0.3 z m 0,-0.3 1,0.2 c -0.1,-0.6 -0.2,-3 -0.8,-3 l -0.2,2.9 z m -5.1,-1.1 2.3,0.5 c 0,-3.4 1.3,-2.5 -1.9,-3.2 l -0.4,2.7 z m -2.5,-0.6 2.2,0.4 0.4,-2.7 -2.1,-0.4 z m 1.1,-5.6 -0.6,2.6 2.1,0.4 0.4,-2.6 -1.8,-0.4 0,-0.3 -0.4,-0.1 -0.1,0.3 z m -0.6,2.8 0,-0.2 -0.4,0 -0.1,0.2 0.2,0 0.2,0.1 z m 0.2,-2.9 -1,-0.2 -1,2.6 1.4,0.3 z m 4.8,0.7 1.5,0.2 -1.4,-2.6 z m -2.1,-0.4 1.8,0.4 0.2,-2.6 0.2,0.2 c -0,-0.4 -0,-0.3 -0.4,-0.3 l 0.1,-0.1 -1.2,-1.1 -0.1,0.1 -0.7,3.5 z m -2.2,-0.4 1.8,0.4 0.6,-3.7 c -0.4,-0 -0.2,-0.1 -0.6,-0.1 -1.6,0 -1.4,2.3 -1.9,3.4 z"}],o["GR.IN.IC.ANIMAL FEEDLOT"]=[{type:"path",stroke:!1,d:"m 121.6,107.1 -0.4,-2.3 -0.2,-2 h 16.3 l -1.7,13.2 h -13 v -0.6 l -1,-8.2 z m 16.1,4.3 0.4,-2.3 0.9,-6.2 -0.1,-1.6 h -19.6 l 1.4,10.7 0.3,0.6 0.5,4.3 -0.1,0.6 h 15.7 v -1.6 l 0.6,-4.6 z M 123,82.6 c -3.3,-0.8 -4.6,0.4 -6.8,1.9 h -1.4 c -0.3,0.4 -0.6,1.2 -1.2,1.2 h -1 c -2.2,0 -3.9,-1.8 -5.8,-1.8 h -0.6 c -0.9,0 -2.1,0.8 -3.9,0.8 -5.1,0 -3.9,0.2 -8,1.5 -2,0.6 -6.2,0.8 -8.9,0.8 h -5.2 c -2.8,0 -5,-0.6 -7.2,-0.6 -2.6,0 -4.7,0.2 -7.4,0.2 -0.5,0 -0.5,-0.1 -0.8,-0.2 -2.4,1.2 -3.1,4.2 -3.1,7.8 0,3.6 -0.6,6.3 -0.6,10.1 v 0.2 c 0,0.6 0.1,0.6 0.2,1 l 1,-0.3 0,-0.5 h 0.4 l 0.2,-12.2 h 0.2 c 0,2 0.1,4.5 0.6,6 0.4,1.2 1.7,3.8 1.7,4.9 v 0.2 l -1.6,13.2 h 3.7 c 0,-1.4 -0.4,-1.1 -0.4,-2.1 v -2.1 c 0,-1.4 1,-4.2 2.3,-4.3 0.4,1.5 3.3,3.7 3.3,6.8 v 0.6 c 0,0.6 -0.1,0.6 -0.2,1 0.4,-0.1 0.5,-0.2 1,-0.2 1.2,0 3.5,0.7 3.5,-0.4 0,-0.3 -1.9,-3.2 -2.2,-3.5 -0.4,-0.5 -1.3,-3.6 -1.3,-4.3 v -0.2 c 0,-0.2 1.2,-2.3 1.2,-4.8 4,2.2 3.5,2.7 9.9,2.7 2.2,0 4.2,0.5 6,0.4 1,-0 3.3,-1.4 4.3,-1.9 0,1.2 0.4,2.4 0.2,3.3 l -1.2,8 c 1,0.3 1.6,0.6 2.8,0.6 h 0.6 -0.2 l 0.7,-11.3 c 0.6,0.4 2.8,7.1 2.6,8.4 l -0.3,2.3 c 0.8,0.4 1.5,0.6 2.6,0.6 h 1 l -1.2,-7.4 -0.1,-0.8 c 0,-0.9 1.6,-0.7 2.5,-1.2 0.6,-0.3 1.4,-1.2 1.8,-1.7 1.1,-1.5 2,-2.7 3,-4.2 3.9,-5.4 3.5,-2.4 10.2,-4 v -0.6 h 1.6 c 1,0 1.8,-0.8 1.8,-1.8 v -0.4 c 0,-2.4 -2.5,-2.5 -2.5,-5.6 l -3.3,-3.4 5.4,-2.9 z m 14.6,28.9 c 0.4,-0.4 0.4,-1.5 0.4,-2.3 l -0.4,2.3 z m -16.1,-4.3 c 0,-0.8 0,-1.9 -0.4,-2.3 l 0.4,2.3 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 121.2,104.9 c 0.4,0.4 0.4,1.5 0.4,2.3 l 1,8.2 v 0.6 h 13 l 1.7,-13.2 h -16.3 l 0.2,2.1 z"}],o["GR.I.FF.SATELLITE"]=[{type:"path",stroke:!N&&O,fill:!!N&&O,d:"m 115,70 20,0 0,55 -20,0 z m -25,5 20,0 0,45 -20,0 z m -25,-5 20,0 0,55 -20,0 z"},{type:"path",fill:!1,d:"m 110,100 5,0 m -30,0 5,0 m 10,27 0,-7 m -20,15 c 10,-10 30,-10 40,0"}],o["GR.IN.IC.FARM/RANCH"]=[{type:"path",stroke:!1,d:"m 119.9,119 v -0.2 c 0,-2 1.5,-3.7 3.5,-3.7 h 0.4 c 2.2,0 3.7,1.6 3.7,4 v 0.6 c 0,1.2 -2.1,2.8 -3.7,2.8 h -0.4 c -1.9,0 -3.5,-1.6 -3.5,-3.5 z m -52,-10.7 c 1.3,-2 1.1,-2.7 3.2,-4.4 1.3,-1 3.3,-1.9 5.5,-1.9 h 0.6 c 4.7,0 9,4.1 9,8.8 v 1.1 c 0,5 -4,9.2 -8.8,9.2 H 76.9 c -5.4,0 -9.4,-4.2 -9.4,-9.6 0,-1.4 0.4,-1.6 0.4,-3 l 0,0 z m 7.9,-20.2 c -0.8,0 -1.5,-4.4 -1.8,-5.3 -0.2,-1 -1.3,-4.6 -1.3,-5.5 h 24.1 c 0.5,0 1.3,-0.8 1.3,-1.3 v -2.2 c 0,-0.7 -0.8,-1.1 -1.5,-1.1 h -31.8 c -0.7,0 -1.5,0.4 -1.5,1.1 v 2.2 c 0,0.5 0.8,1.3 1.3,1.3 h 3.5 l 2.6,16 -6.8,2.5 2.8,3.4 c -1,1.3 -2.3,2.1 -3.6,4.2 -0.4,0.8 -1.9,4.4 -1.9,5.5 v 2.2 c 0,5.4 1.6,8.8 4.3,11.5 2.3,2.3 6.5,4.8 11,4.8 h 0.4 c 8.8,0 15.8,-7.4 15.8,-16 h 13.4 c 0.6,0 1.9,1.4 2.4,1.8 h 8.6 c -1.1,1.6 -2.2,2.9 -2.2,5.7 0,4.6 3.9,8.6 8.6,8.6 4.4,0 8.8,-3.8 8.8,-7.9 v -2 c 0,-1.2 -1.5,-3.4 -2,-4.4 h 7.2 l 1,-4.6 h -7.2 v -0.6 l 1.2,-8.1 -0.1,-3.3 c 0,-0.6 -1.7,-2.1 -2.2,-2.4 l -16,-0.5 V 78.2 c 0,-0.5 -0.4,-0.9 -0.9,-0.9 -0.5,0 -0.9,0.4 -0.9,0.9 v 15.4 c -2.2,-0.2 -6,-0.4 -8.1,-0.4 -1.3,0 -2.9,0.1 -4.2,0 -2.1,-0.1 -2,-1.3 -2.9,-1.3 h -4.6 l 2,12.3 H 91.1 V 98.6 C 91.1,97.8 87.1,94.4 86.1,94.4 H 78.7 V 89.8 L 77.5,88.1 75.8,88 z M 88.1,92 c 0,0.5 0.1,0.2 0.2,0.9 h 0.6 c 0.9,0 8.5,-6.4 10.1,-6.8 V 85.4 c 0,-0.5 -0.2,-0.6 -0.6,-0.6 h -0.4 C 97.5,84.7 88.1,91.6 88.1,92 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 119.9,119 c 0,1.9 1.6,3.5 3.5,3.5 h 0.4 c 1.6,0 3.7,-1.6 3.7,-2.8 v -0.7 c 0,-2.3 -1.5,-4 -3.7,-4 h -0.4 c -2,0 -3.5,1.7 -3.5,3.7 v 0.2 z m -52,-10.7 c 0,1.4 -0.4,1.7 -0.4,3.1 0,5.4 4.1,9.6 9.4,9.6 h 0.6 c 4.8,0 8.8,-4.3 8.8,-9.2 v -1.1 c 0,-4.7 -4.3,-8.8 -9,-8.8 h -0.6 c -2.2,0 -4.3,0.9 -5.5,1.9 -2.2,1.7 -1.9,2.4 -3.2,4.4 z"}],o["GR.IN.IC.GRAIN STORAGE"]=[{type:"path",stroke:!1,d:"m 122.8,69.6 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -1e-5,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -1e-5,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 0,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -2e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.6e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -2e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,0 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -10e-7,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -4e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,0 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,1e-6 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -10e-6,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -10e-7,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.6e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 m 24.4,48.1 -0.2,2.4 h 0.4 l -1.7,3 -1,-1.7 -0.1,2 0.5,0.6 -1.2,3 -1.5,-3 0.4,3.6 0.8,0.2 -3.1,9.7 -0.5,-4.2 0.1,-1.8 c 0,-1.5 0.8,-4.7 1,-6.3 0.3,-1.7 1.3,-4.5 1.4,-6 0.6,0.1 0.4,0.2 0.8,0.2 0.4,0 2.3,-1.5 2.6,-1.8 l -3,0.6 0.8,-2.7 c 0.6,0.1 0.4,0.2 0.8,0.2 0.4,0 2.6,-1.7 2.8,-2 l -3,0.8 0.7,-2.4 c 1.3,0 2.1,-0.8 2.8,-1.4 l -2.4,0.4 0.8,-2 c 1.1,-0 1.5,-0.9 1.8,-1.8 l -1.3,0.7 2.3,-6.1 -0.8,-0.1 -2.1,5.9 -0.3,0 -0.5,-2.1 -0.1,-0 c 0,1.5 -0.4,1.6 -0.4,2.4 0,0.5 0.2,0.5 0.6,0.6 l -0.9,2.1 -1,-1.4 c -0.1,1.6 -0.4,1.9 0.7,2.4 l -0.8,2.4 -1.7,-2.2 0.4,2.8 0.6,0.5 -0.5,2.7 -1.5,-1.9 0.2,2.4 0.9,0.5 c 0,0.4 -1,4.6 -1.2,6 -0.4,2.3 -0.9,3.5 -0.9,6.3 l -1.2,-3.6 0.6,-0.8 -0,-2 -1.2,1.2 -0.8,-2.8 0.6,-0.8 -0,-2 -1.1,1.2 -0.7,-1.7 c 1,-0.5 1,-1.6 1,-3.2 l -1.3,2.1 c -0.7,-0.2 -1.1,-1.4 -1.3,-2.3 0.3,-0.4 0.6,-0.5 0.6,-1 v -1.6 h -0.4 l -0.7,1.8 c -0.2,-0.2 -0.7,-0.7 -0.7,-1.2 0,-0.4 0.6,-0.3 0.6,-1 v -0.2 c 0,-1.1 -0.4,-1.1 -0.4,-2.4 l -0.7,2.3 -0.3,0 -2.8,-5.9 -0.4,0.2 2.5,5.7 -1.3,-0.7 1,1.9 1,0 0.6,1 -2.6,-0.4 c 0.4,0.4 1.7,1.4 2.4,1.4 0.1,0 0.4,-0.1 0.6,-0.2 l 1,2.2 -3.2,-0.6 c 1.1,1 2,1.7 3.6,1.6 l 1.1,2.7 -2.9,-0.4 c 0.7,1 1.7,1.3 3,1.5 0.4,0.1 1.1,2.8 1.2,3.5 l -3,-0.6 2.2,1.6 h 1 c 1.2,2.3 2.4,11.9 2.4,15.8 h 1.4 l -0.2,-2.2 0,-1 c 0,-4 2.9,-9.3 3.2,-12.3 0.8,0.1 0.5,0.2 1,0.2 0.2,0 2.9,-1.2 3.2,-1.4 l -3.6,0.3 1.2,-3.1 0.8,0.4 3,-1.3 -3.2,0.2 1.4,-2.8 c 0.4,0.1 0.4,0.2 1,0.2 0.3,0 2.1,-1 2.4,-1.2 l -2.8,0.2 1.4,-2 c 1.5,0.1 1.5,-0.4 2.4,-1.6 l -1.4,0.4 c 0.5,-1.1 1.2,-2.2 1.8,-3.2 0.4,-0.6 2,-2.7 0.8,-3 l 0.2,0.1 -3.4,5.8 -0.4,-2.3 h -0.2 c 0,1.4 -0.6,1.7 -0.6,2.2 0,0.3 0.3,0.7 0.4,1 l -1.5,2 -0.7,-1.9 z m -25.4,13.5 c 0,-3.7 0.1,-9.1 0.7,-12.4 0.4,-2 0.1,-4 0.6,-6 0.4,-1.7 0.4,-4.2 0.8,-5.8 2.8,-10.1 1,-11.8 14.3,-11.8 h 4.4 c 11.6,0 12.6,1.2 14.2,11.3 1.2,7.6 2,14.6 2,23.6 v 8.3 l -0.4,3.6 c -1.1,1.6 -2.1,3.4 -4.9,3.4 H 86.7 c -5.4,0 -5.3,-6.4 -5.3,-11.9 v -2.4 z m -5.8,-32.5 c 2.1,-0.6 0.4,-1.3 4.4,-1 2.4,0.2 3,0.3 5,0.8 -0.7,1.1 -4.6,3 -6.5,3 h -0.4 c -0.9,0 -2.4,-1.2 -2.4,-2 v -0.8 h -0 z m 43.2,-1.5 c 2.2,-0.2 4.8,0.9 4.8,3.1 v 0.6 c 0,0.6 -0.6,0.8 -1.2,0.8 h -0.6 c -1.8,0 -6.2,-2.7 -6.9,-3.9 l 4,-0.6 z m -36.6,-6.7 c 0,-1 1,-2.2 1.8,-2.2 h 0.6 c 0.6,0 1.4,1.6 1.4,2.2 v 4.2 c 0,1.3 -0.4,1.5 -0.4,2.8 -1,-0.3 -3.4,-4.3 -3.4,-5.5 v -1.4 h -0 z m 31.7,2.8 c 0,-2.8 -0,-5.2 2.8,-5.2 h 0.6 c 0.6,0 1,0.7 1,1.4 0,2 -3,6.8 -4.4,7.3 v -3.6 h -0 z m 1.4,3.8 c 0.5,-1.8 3.8,-5 3.8,-7.1 v -1.4 c -0.6,-0.3 -0.7,-1.2 -1.6,-1.2 h -0.6 c -2.6,0 -3.8,2 -3.8,4.5 v 4.2 c -2,-0.5 -2.3,-1 -5.2,-1.2 -2,-0.2 -3.7,-0.4 -6,-0.4 h -3.6 c -4.8,0 -8.9,0.3 -12.1,2 0.2,-0.7 0.4,-0.9 0.4,-1.8 v -3.4 c 0,-1.4 -1,-3.8 -2.2,-3.8 h -0.8 c -0.8,0 -2.6,1.9 -2.6,3 0,2 2.1,5.5 3,6.8 l -5.7,-0.5 c -1.2,0 -3.4,1.1 -3.4,2.1 v 0.6 c 0,1.3 1.7,2.8 3,2.8 h 0.2 c 2.9,0 4.5,-2 6.3,-2.4 -1.9,3.5 -3.8,22 -3.8,28.1 v 6 c 0,5.9 0.3,12.3 6.1,12.3 h 26.1 c 4.1,0 6.1,-3.8 6.1,-7.9 v -10.5 c 0,-2.3 -0.2,-5.5 -0.4,-7.7 -0.2,-1.8 -0.8,-5.7 -0.8,-7.4 0,-2.6 -0.7,-4.7 -1,-7.1 -0.2,-2.1 -1.3,-4.3 -1.8,-6.2 1.2,0.6 4.9,3 6.1,3 h 1.2 c 1,0 1.8,-0.8 1.8,-1.8 v -0.2 c 0,-2.2 -1.5,-3.8 -3.8,-3.8 h -2.6 l -2.8,0.4 z m -28.1,0.6 c 0.5,1.9 8.9,3.2 11.9,3.2 h 1 c 3.1,0 12.5,-1.4 12.7,-3.6 -4.1,-1 -6.5,-1.8 -11.9,-1.8 h -1.4 c -2.4,0 -4.4,0.4 -6.5,0.6 -2.9,0.4 -3.8,1.1 -5.8,1.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 105.3,110.1 c -0.3,0.3 -2.2,1.8 -2.6,1.8 -0.4,0 -0.2,-0.1 -0.8,-0.2 0,1.5 -1.1,4.3 -1.3,6 -0.3,1.6 -1,4.8 -1,6.3 l -0.1,1.8 0.5,4.2 3.1,-9.7 -0.8,-0.2 -0.4,-3.6 1.5,3 1.2,-3 -0.5,-0.6 0.1,-2 1,1.7 1.7,-3 h -0.4 l 0.2,-2.4 -0.3,-1.2 -1.2,1.2 z m 0,0 1.2,-1.2 0.3,1.2 0.7,1.9 1.5,-2 c -0.1,-0.3 -0.4,-0.7 -0.4,-1 0,-0.5 0.6,-0.8 0.6,-2.2 h 0.2 l 0.4,2.3 3.4,-5.7 -0.2,-0.1 c 1.3,0.4 -0.4,2.4 -0.8,3 -0.6,1 -1.3,2.1 -1.8,3.2 l 1.4,-0.4 c -0.8,1.2 -0.9,1.7 -2.4,1.6 l -1.4,2 2.8,-0.2 c -0.3,0.2 -2,1.2 -2.4,1.2 -0.5,0 -0.5,-0.1 -1,-0.2 l -1.4,2.8 3.2,-0.2 -3,1.3 -0.8,-0.4 -1.2,3.1 3.6,-0.4 c -0.3,0.2 -2.9,1.4 -3.2,1.4 -0.5,0 -0.2,-0.1 -1,-0.2 -0.3,2.9 -3.2,8.2 -3.2,12.3 l -0.1,1 0.3,2.2 h -1.4 c 0,-4 -1.2,-13.6 -2.4,-15.8 h -1 l -2.2,-1.6 3,0.6 c 0,-0.7 -0.8,-3.4 -1.2,-3.5 -1.3,-0.2 -2.3,-0.5 -3,-1.5 l 2.9,0.4 -1.1,-2.8 c -1.5,0.1 -2.5,-0.6 -3.6,-1.6 l 3.2,0.6 -1.1,-2.2 c -0.2,0.1 -0.5,0.2 -0.6,0.2 -0.7,0 -2,-1 -2.4,-1.4 l 2.6,0.4 -0.6,-1 h -1 l -1,-1.9 1.3,0.7 -2.5,-5.7 0.4,-0.2 2.8,5.9 0.3,-0 0.7,-2.4 c 0,1.3 0.4,1.2 0.4,2.4 v 0.2 c 0,0.7 -0.6,0.6 -0.6,1 0,0.4 0.5,1 0.7,1.2 l 0.7,-1.8 h 0.4 v 1.6 c 0,0.5 -0.3,0.6 -0.6,1 0.2,0.9 0.5,2.1 1.3,2.3 l 1.3,-2.1 c 0,1.5 0,2.6 -1,3.2 l 0.7,1.7 1.1,-1.2 0,2 -0.6,0.8 0.8,2.8 1.2,-1.2 0,2 -0.6,0.7 1.2,3.6 c 0,-2.8 0.4,-4 0.9,-6.2 0.3,-1.3 1.3,-5.6 1.2,-6 l -0.9,-0.5 -0.2,-2.5 1.5,1.9 0.5,-2.7 -0.6,-0.5 -0.4,-2.8 1.7,2.2 0.8,-2.4 c -1,-0.5 -0.8,-0.8 -0.7,-2.4 l 1,1.4 0.9,-2.1 c -0.4,-0.1 -0.6,-0 -0.6,-0.6 0,-0.8 0.4,-0.9 0.4,-2.4 l 0.1,0 0.5,2.1 0.3,-0 2.1,-5.9 0.8,0.1 -2.3,6.1 1.3,-0.7 c -0.2,0.9 -0.6,1.8 -1.8,1.8 l -0.8,2 2.4,-0.4 c -0.7,0.6 -1.5,1.4 -2.8,1.4 l -0.7,2.4 3,-0.8 c -0.2,0.3 -2.4,2 -2.8,2 -0.4,0 -0.2,-0.1 -0.8,-0.2 l -0.8,2.7 3,-0.5 z M 87.1,90.1 c 2,-0.5 2.9,-1.2 5.8,-1.6 2.1,-0.3 4.1,-0.6 6.5,-0.6 h 1.4 c 5.4,0 7.8,0.8 11.9,1.8 -0.2,2.2 -9.6,3.6 -12.7,3.6 h -1 c -3,0 -11.4,-1.3 -11.9,-3.2 z m -5.8,33.5 v 2.4 c 0,5.5 -0.1,11.9 5.3,11.9 h 26.4 c 2.8,0 3.8,-1.7 4.9,-3.4 l 0.4,-3.6 v -8.3 c 0,-9 -0.8,-15.9 -2,-23.6 -1.6,-10.1 -2.6,-11.3 -14.2,-11.3 h -4.4 c -13.3,0 -11.6,1.7 -14.3,11.8 -0.4,1.6 -0.4,4 -0.8,5.8 -0.5,2 -0.2,3.9 -0.6,6 -0.6,3.3 -0.7,8.6 -0.7,12.4 z M 114.8,90.2 c 0.7,1.2 5.2,3.9 6.9,3.9 h 0.6 c 0.6,0 1.2,-0.2 1.2,-0.8 v -0.6 c 0,-2.2 -2.6,-3.3 -4.8,-3.1 l -4,0.6 0,0 z m -39.2,0.9 v 0.8 c 0,0.8 1.4,2 2.4,2 h 0.4 c 2,0 5.8,-1.9 6.5,-3 -2,-0.4 -2.6,-0.6 -5,-0.8 -3.8,-0.3 -2.1,0.4 -4.3,1 z m 38.3,-5.3 v 3.6 c 1.3,-0.5 4.4,-5.3 4.4,-7.3 0,-0.7 -0.4,-1.4 -1,-1.4 h -0.6 c -2.8,-0 -2.8,2.4 -2.8,5.1 z m -31.7,-2.8 v 1.4 c 0,1.3 2.4,5.3 3.4,5.5 0,-1.3 0.4,-1.5 0.4,-2.8 v -4.2 c 0,-0.6 -0.8,-2.2 -1.4,-2.2 h -0.6 c -0.8,0 -1.8,1.3 -1.8,2.2 z"}],o["GR.IN.IC.ATM"]=[{type:"path",stroke:!1,d:"m 73.6,116.3 c 5.1,-0.1 15.8,-6.6 17,-6.6 0.4,0 7.4,3.8 8.9,4.2 -0.4,0.6 -5.1,4.6 -6.2,5.7 -1.2,1.2 -4.7,5.8 -5.5,6.4 -1.6,-0.8 -14,-8.9 -14.2,-9.6 z m -15.1,-6.2 11.9,-2.5 11.1,5.6 -9.6,3 16.2,10.7 -0,-0.2 6.4,-7.5 26.9,12.7 20.3,-46.8 -50.2,-17.2 c -0.6,2.2 -5.2,9.1 -6.5,11.8 -0.8,1.8 -2.3,4.4 -3.3,6 -1.2,1.8 -2.2,4.1 -3.3,6 -1.2,2 -2.1,3.8 -3.3,5.8 -1.2,1.9 -2.1,4.2 -3.3,6 -2.4,3.6 -0.2,2.7 -5.5,3.7 -2.6,0.5 -5.2,1 -7.7,1.6 m 62,21.5 -25.2,-11.8 4.8,-4 7.3,3.5 1.2,-2.4 -23.9,-11.7 v 0.2 l -1,2.2 6,2.9 -6.2,3.4 -11.8,-5.8 -0.2,0 20.7,-37 0.2,0.1 47.4,16.1 h 0.2 l -19.4,44.2 z m 7.8,-31.3 1.1,-2 -5.8,-2.3 -0.8,2.3 z m -2.7,5.2 1.2,-1.9 -5.6,-2.3 -0.8,2.2 z m -22,-7.3 c 0.6,0.4 2.1,1.4 2.1,2.1 v 2.4 c 0,0.8 -1.7,1.5 -2.6,1.5 h -0.2 c -0.8,0 -1,-0.2 -1.7,-0.4 l 2.4,-5.7 z m -3.4,-6.4 c 0,-2.2 1.1,-2.8 3.2,-2.8 h 0.2 c 0.7,0 1,0.2 1.5,0.4 l -2.2,5.1 c -0.9,-0 -2.8,-1.2 -2.8,-2.4 v -0.2 z m 5.6,-4.2 c -0.3,-0.1 -1.2,-0.5 -1.6,-0.5 h -1.9 c -0.7,0 -2.5,0.6 -2.9,0.9 -0.3,0.2 -1.4,2.1 -1.4,2.5 v 1.7 c 0,2.1 3.8,4.2 3.8,4.9 0,0.4 -2.2,4.6 -2.4,5.7 -0.6,-0.3 -2.5,-1.8 -2.5,-2.6 v -0.6 c 0,-0.8 0.6,-1.4 0.8,-2.1 -0.9,-0.2 -2,-1.1 -2.4,-1.2 -0.4,-0.1 -1,1.7 -1,2.3 v 0.4 c 0,2.7 4.2,5.4 4.2,5.7 0,0.6 -0.4,1.4 -0.5,2 l 1.7,0.8 0.6,-1.7 c 1.4,0 2,0.8 3.6,0.8 h 0.6 c 1.4,0 2.6,-0.5 3.2,-1.3 0.3,-0.4 1.5,-2.4 1.5,-3 v -0.4 c 0,-2.6 -2.8,-4.8 -4.4,-5.9 l 2.5,-5.6 h 0.4 c 0.4,1.2 1.5,0.6 1.5,3.6 l 2.8,1.2 v -1.7 c 0,-2 -2,-4.1 -3.8,-4.6 l 0.8,-2.1 -2.1,-0.5 -0.8,1.5 z m 13,18.4 -0.9,2 5.4,2.2 -0,-0.2 1.2,-1.8 z m -22.4,-25.2 26.1,9.5 -11,24.1 -26.7,-12.8 11.6,-20.8 z m -12.5,21.2 27.8,13.4 11.7,-25.7 c -1,-0.1 -11.8,-4.2 -13.4,-4.8 -1.2,-0.5 -13.3,-5 -13.5,-5 -0.9,0 -5.4,9.5 -6.4,10.8 -0.8,1.3 -5.9,10.3 -6.1,11.2 z m 31.7,11.2 5.4,2.2 -0.1,-0.2 1.3,-1.8 c -1.1,-0.2 -5,-2.2 -5.5,-2.2 -0.4,0 -1.1,1.6 -1.2,2.1 z m -25.8,0.6 4.3,2.9 -6,5.8 -6,-4.1 7.7,-4.6 z m -9.1,4.5 7.4,4.9 7.1,-6.6 c -0.5,-0.4 -5.3,-3.6 -5.4,-3.6 -1,0 -7.6,4.9 -9.1,5.3 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 115.7,111.8 c 0,-0.5 0.8,-2.1 1.2,-2.1 0.5,0 4.4,2 5.5,2.3 l -1.3,1.8 0.1,0.2 -5.4,-2.2 z m 3.2,-7.1 5.7,2.2 -1.2,1.8 0,0.2 -5.4,-2.2 0.9,-2 z m 2.4,-4.8 5.6,2.3 -1.2,1.9 -5.2,-2 0.8,-2.2 z m 2.5,-5.3 5.8,2.3 -1.1,2 -5.5,-2 0.8,-2.3 z m -39.7,6 c 0.2,-1 5.3,-10 6.1,-11.2 0.9,-1.4 5.4,-10.8 6.4,-10.8 0.2,0 12.3,4.5 13.5,5 1.7,0.7 12.5,4.8 13.5,4.8 l -11.7,25.7 -27.8,-13.4 z m 55.9,-14.6 h -0.2 l -47.4,-16.1 -0.2,-0.1 -20.7,37 0.2,-0 11.8,5.8 6.3,-3.4 -6,-2.9 1,-2.2 v -0.2 l 23.9,11.7 -1.2,2.4 -7.3,-3.5 -4.8,4 25.2,11.8 19.4,-44.2 0,0 z m -59.1,30.9 c 1.5,-0.4 8,-5.3 9.1,-5.3 0.2,0 4.9,3.2 5.5,3.6 l -7.2,6.6 -7.4,-4.9 z m -7.2,-0.6 c 0.2,0.8 12.6,8.8 14.2,9.6 0.8,-0.6 4.3,-5.2 5.5,-6.4 1.1,-1.1 5.8,-5.1 6.2,-5.7 -1.6,-0.3 -8.5,-4.1 -8.9,-4.1 -1.2,0 -11.9,6.5 -17,6.6 z m 26.6,-25.9 v 0.2 c 0,1.2 1.8,2.4 2.7,2.4 l 2.2,-5 c -0.4,-0.2 -0.8,-0.4 -1.5,-0.4 h -0.2 c -2.1,0 -3.2,0.7 -3.2,2.8 z m 0.9,12.1 c 0.7,0.2 0.9,0.4 1.7,0.4 h 0.2 c 1,0 2.6,-0.7 2.6,-1.5 v -2.4 c 0,-0.7 -1.6,-1.7 -2.1,-2.1 l -2.4,5.6 z m 5.5,-17.7 2.1,0.5 -0.8,2.1 c 1.8,0.4 3.8,2.5 3.8,4.6 v 1.7 l -2.8,-1.1 c 0,-3 -1.1,-2.4 -1.5,-3.6 h -0.4 l -2.5,5.6 c 1.6,1.1 4.4,3.3 4.4,5.9 v 0.4 c 0,0.6 -1.2,2.6 -1.5,3 -0.6,0.8 -1.8,1.3 -3.2,1.3 h -0.6 c -1.6,0 -2.2,-0.7 -3.6,-0.8 l -0.6,1.7 -1.7,-0.8 c 0.1,-0.6 0.5,-1.4 0.5,-2 0,-0.3 -4.2,-2.9 -4.2,-5.7 v -0.4 c 0,-0.6 0.6,-2.4 1,-2.4 0.4,0.1 1.4,1 2.4,1.2 -0.2,0.7 -0.7,1.3 -0.7,2.1 v 0.6 c 0,0.8 1.8,2.3 2.4,2.6 0.2,-1 2.4,-5.3 2.4,-5.7 0,-0.7 -3.8,-2.8 -3.8,-4.9 V 89.1 c 0,-0.4 1.1,-2.3 1.4,-2.5 0.4,-0.3 2.2,-0.9 2.9,-0.9 h 1.9 c 0.4,0 1.4,0.4 1.6,0.5 l 0.8,-1.4 z m -21.8,15.4 26.6,12.9 11,-24.1 -26,-9.5 -11.6,20.8 z m 5,12.1 -7.7,4.6 6,4.1 6,-5.8 z"}],o["GR.IN.IC.BANK"]=[{type:"path",stroke:!1,d:"m 100.8,110.6 c 2.4,0 5.3,1.9 5.3,4.4 v 0.7 c 0,3.1 -2.1,4.9 -5.3,4.9 v -9.9 z m -6.6,-8.8 c 0,-2.3 1.7,-4.4 4,-4.4 h 0.7 v 9 c -1.9,-0.4 -4.6,-1.6 -4.6,-3.7 v -0.9 z m 6.6,-4.4 c 2.2,0 4.6,1.6 4.6,3.5 v 0.9 h 3.5 c 0,-5.3 -3.7,-6.7 -8.1,-7.7 v -2.4 h -2 v 2.4 c -3.9,0 -8.2,3.5 -8.2,7 v 2.6 c 0,1.3 2,3.6 3,4.2 1,0.6 3.8,1.8 5.1,1.9 v 10.6 c -3.4,-0.1 -5.2,-2.6 -5.2,-6.1 h -3.3 l 0.2,3.5 c 1.1,1.7 0.9,2.8 2.9,4.1 1.3,0.8 3.4,1.6 5.5,1.6 v 4 h 2 v -3.9 c 4.9,0 9,-3.4 9,-8.1 v -1.8 c 0,-4.2 -5.4,-6 -9,-6.8 v -9.4 z m -25.3,15.2 v -2.4 c 0,-2.2 2.6,-7.4 3.1,-9.4 0.7,-2.7 3.1,-5.9 4.7,-8 3.5,-4.6 8.5,-8.9 16.5,-8.9 h 4.4 c 3.4,0 8.8,4.3 10.4,6.5 1.3,1.7 2.2,3.1 3.4,5 0.5,0.7 2.7,5.2 2.7,5.9 v 0.7 h 0.4 v 0.7 c 0,0.4 0.9,1.5 0.8,3.1 l 0.5,0.7 c 0,2 1.1,6.8 1.3,9 0.4,3.2 1.3,5.6 -0.7,8.5 0,2.4 -5.2,8.7 -6.2,8.8 l -9.2,-1.5 c -1.8,-0.3 -6.8,2 -9.2,2 -2,0 -5.6,-1.7 -7.5,-1.7 -1.6,0 -3.2,1.3 -5.5,1.3 h -0.6 c -1.9,0 -5.9,-6.1 -7,-7.7 -1.8,-2.6 -2.4,-8 -2.4,-12.3 z m 30.7,-31 -6.1,-1.1 c -0.8,-0.1 -5.2,1.1 -5.8,1.3 l -6.3,-11.5 1.7,0.5 v -2.9 l 8.9,3.4 0.3,-3.5 3.2,2.5 5.7,-2.6 v 2.6 l 7.5,-1.4 -9.3,13 0,0 z m 11.8,-14.5 -9.1,1.6 v -2.8 c -0.9,0.5 -5.7,2.9 -6.6,2.9 -0.1,0 -3.4,-2.6 -4,-2.9 l -0.7,4 -8.8,-3.6 v 2.9 l -3.1,-1 8.1,15.1 -0.2,0.1 c -4.6,1.1 -10.3,6.8 -12.7,10.4 -0.8,1.1 -1.3,2.6 -2,3.7 -1.4,1.8 -0.9,2.5 -1.7,4 -0.6,1.1 -2.9,7.2 -2.9,8.6 v 3.7 c 0,1 0.7,5.8 1,6.7 0.4,1.4 0.4,2 0.8,3.2 0.3,0.9 0.9,1.6 1.4,2.3 1.3,2 4.8,7.5 7.6,7.5 2.5,0 4.3,-1.3 5.7,-1.3 2.3,0 5.2,1.7 7.3,1.7 h 0.7 c 2,0 5.7,-1.4 8,-1.9 1.8,-0.3 5.9,1 8.5,1 h 1.7 c 1.7,0 4.8,-4.2 5.8,-5.5 1.1,-1.4 1.3,-2.2 1.7,-4 0.1,-0.4 1.1,-4.3 1.1,-4.4 0,-3 -0.9,-4.1 -1.1,-5.9 -0.2,-2.4 -0.4,-4 -0.7,-6.1 -0.2,-1.7 -2.8,-8.6 -3.6,-10.3 -2.4,-4.9 -7.7,-13.2 -14,-13.7 l 11.7,-16.2 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 100.8,120.4 c 3.2,0 5.3,-1.7 5.3,-4.9 v -0.6 c 0,-2.5 -2.9,-4.3 -5.3,-4.4 v 9.8 z m -6.6,-18.7 v 0.9 c 0,2.2 2.8,3.3 4.6,3.7 v -9 h -0.7 c -2.3,0 -4,2 -4,4.4 z m 6.6,5 c 3.6,0.8 9,2.6 9,6.8 v 1.7 c 0,4.7 -4.1,8.1 -9,8.1 v 4 h -2 v -3.9 c -2,0 -4.2,-0.7 -5.5,-1.6 -2,-1.3 -1.7,-2.5 -2.9,-4.2 l -0.2,-3.5 h 3.3 c 0,3.5 1.8,6.1 5.3,6.2 v -10.6 c -1.3,-0.1 -4.1,-1.3 -5.1,-2 -1,-0.6 -3,-3 -3,-4.2 v -2.6 c 0,-3.5 4.2,-7 8.1,-7 v -2.4 h 2 v 2.4 c 4.4,1 8.1,2.3 8.1,7.7 h -3.5 v -0.9 c 0,-1.9 -2.5,-3.5 -4.6,-3.5 v 9.5 l 0,0 z m -25.3,5.8 c 0,4.3 0.6,9.8 2.4,12.3 1.1,1.6 5.1,7.7 7,7.7 h 0.7 c 2.3,0 3.9,-1.3 5.5,-1.3 1.9,0 5.5,1.7 7.5,1.7 2.5,0 7.4,-2.3 9.2,-2 l 9.1,1.5 c 1,0 6.2,-6.4 6.2,-8.8 2,-2.9 1,-5.3 0.7,-8.6 -0.2,-2.2 -1.3,-6.9 -1.3,-9 l -0.5,-0.6 c 0.1,-1.6 -0.8,-2.7 -0.8,-3.1 v -0.7 h -0.4 v -0.7 c 0,-0.7 -2.2,-5.2 -2.7,-5.9 -1.1,-1.9 -2.1,-3.2 -3.4,-5 -1.6,-2.2 -7,-6.5 -10.4,-6.5 h -4.4 c -8,0 -13,4.4 -16.5,8.9 -1.6,2.1 -4,5.3 -4.7,8 -0.5,2 -3.1,7.2 -3.1,9.4 v 2.4 z m 40,-44 -7.4,1.5 v -2.6 l -5.8,2.6 -3.2,-2.4 -0.3,3.5 -8.9,-3.4 v 2.9 l -1.7,-0.5 6.3,11.5 c 0.5,-0.2 5,-1.4 5.8,-1.3 l 6.1,1.1 9.3,-13 0,0 z"}],o["GR.IN.IC.BULLION STORAGE"]=[{type:"path",stroke:!1,d:"m 123.1,77.9 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -1e-5,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -1e-5,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -10e-6,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,10e-7 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -1e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -1e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,0 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -10e-7,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -3e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,0 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,10e-7 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -1e-5,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -2e-6,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.5e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 M 103.6,119.3 h 9.6 c 0.4,0 9,9.2 9.6,10.1 H 95.6 c 0.2,-1 7.4,-10.1 8,-10.1 z m -29.2,0 h 9.9 c 0.6,0 8.2,9 8.9,10.1 H 65.9 c 0.3,-1 7.8,-10.1 8.4,-10.1 l 0,0 z m 11.5,0 h 15.4 l -6.9,9.9 -8.5,-9.9 z m -5.5,-1 c 0.7,-1.1 7.6,-9.4 8.4,-9.4 h 9.2 c 0.7,0 8.9,8.5 9.2,9.4 H 80.4 z m 43.7,10.8 -9.5,-10.4 10.4,-14.3 9.7,8.5 -10.7,16.1 0,0 z m -4.8,-24.8 4.8,-0 -10.5,14.1 -4.1,-0.1 9.8,-13.9 z m -31.1,-0.2 2.8,0.1 c -1.1,1.6 -4.6,4.9 -6.2,6.8 -1.7,2.1 -4.2,5.1 -5.6,7.2 l -4.2,-0.1 13.2,-14.1 z m 21.1,-8.6 c 0.9,0.6 9,8.2 9,8.5 0,0.1 -9.3,13.6 -9.9,14 l -8.9,-9.9 9.8,-12.6 z M 89.1,108 c 0.9,-1.3 11.4,-12.6 12.1,-12.6 h 6.8 l -9.5,12.5 -9.4,0 z m 2.9,-4.6 h -4.6 c -1.2,1.8 -4.3,4.9 -6,6.6 -2.1,2.1 -3.9,4.4 -6,6.5 -1.3,1.3 -11.2,12.8 -11.4,13.7 0.5,0.1 0.5,0.2 1.2,0.2 l 59.3,-0 11.6,-17.5 -0.3,0.1 -10.5,-9.6 h -5.8 c -1.5,-1 -9.6,-8.9 -10.4,-8.9 h -8.2 c -0.9,0 -7.6,8 -9,8.9 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 103.6,119.3 c -0.5,0 -7.7,9.2 -8,10.1 h 27.3 c -0.6,-1 -9.2,-10.1 -9.6,-10.1 h -9.6 z m -29.2,0 c -0.6,0 -8.2,9.1 -8.4,10.1 h 27.3 c -0.7,-1.1 -8.3,-10.1 -8.9,-10.1 H 74.3 l 0,0 z m 50.7,-14.7 -10.4,14.3 9.5,10.4 10.7,-16.1 z m -30.7,24.7 6.9,-9.9 -15.4,0 z m 5.1,-21.1 8.9,9.9 c 0.6,-0.4 9.9,-13.9 9.9,-14 0,-0.3 -8.1,-7.9 -9,-8.5 l -9.9,12.6 z m -19.1,10.2 h 26.8 c -0.2,-0.9 -8.5,-9.4 -9.2,-9.4 h -9.2 c -0.9,0 -7.7,8.3 -8.4,9.4 z m 33.2,0.1 10.5,-14.1 -4.8,0 -9.8,13.9 z m -38.6,-0.2 4.2,0.1 c 1.4,-2.1 3.9,-5.1 5.6,-7.2 1.6,-1.9 5.1,-5.2 6.2,-6.8 l -2.8,-0.1 -13.2,14.1 z m 14.1,-10.3 9.4,-0 9.5,-12.5 h -6.7 c -0.7,0 -11.2,11.2 -12.1,12.6 z"}],o["GR.IN.IC.FEDERAL RESERVE BANK"]=[{type:"path",stroke:!1,d:"m 65.6,125.4 h 68.8 v 4.4 H 65.6 v -4.4 z m 58.1,-31.3 h 5.3 v 29.9 h -5.3 v -29.9 z m -10.6,0 h 5.1 v 29.9 h -5.1 v -29.9 z m -31.3,0 h 5.3 v 29.9 H 81.8 v -29.9 z m -10.6,0 h 5.1 v 29.9 h -5.1 v -29.9 z m 27.7,1.5 h 2 v 1.4 h 0.5 c 2.9,0 6,2.3 6,5.3 l -2.9,0.4 c -0.2,-0 -1,-1.9 -1.4,-2.4 -0.4,-0.5 -1.5,-1.1 -2.3,-1.2 v 7.8 c 3,0.3 7.3,2.3 7.3,5.3 v 1.1 c 0,4 -3.4,6.7 -7.3,6.7 v 2.5 h -2 v -2.5 c -1.7,-0 -4.1,-0.8 -5.1,-1.7 -0.8,-0.7 -2.4,-2.8 -2.4,-4.1 v -0.9 l 3.1,-0.5 c 0,2.3 2,4.9 4.4,4.9 v -8.6 c -2.3,-0 -6.9,-2.5 -6.9,-5.1 v -1.8 c 0,-3 3.2,-5.3 6.2,-5.3 h 0.7 v -1.4 z m -33.3,-7.5 h 68.8 v 4.6 H 65.6 v -4.6 z M 100,70.3 c 0.7,0.6 6.5,3.4 7.9,4.1 2.7,1.4 5.2,2.7 7.9,4.1 2.7,1.3 5.3,2.7 7.9,4.1 1.1,0.6 7.7,3.6 8.1,4 H 68.5 l 31.5,-16.1 0,0 z m -35.9,17.1 v 6 c 0,0.4 0.3,0.7 0.7,0.7 h 4.9 v 29.9 h -5.6 v 7.4 h 71.7 v -7.4 h -5.5 v -29.9 h 4.9 c 0.4,0 0.5,-0.1 0.5,-0.5 v -6.7 c -2,-0.7 -6.7,-3.4 -8.9,-4.6 -3,-1.5 -5.9,-3 -8.9,-4.6 -1.7,-0.8 -17.8,-9.1 -17.9,-9.1 -0.4,0 -16.3,8.2 -18.1,9.2 -1.9,1 -17.8,8.7 -17.8,9.6 l 0,0 0,0 z m 36.7,30.4 c 1.7,0 4,-2 4,-3.5 v -1.4 c 0,-2.1 -2.3,-2.7 -4,-3.1 v 8 z m -5.6,-14 c 0,1.6 2.2,2.6 3.6,2.7 v -7.4 c -1.3,0.3 -3.6,1.4 -3.6,2.7 v 2 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 134.4,129.8 0,-4.4 -68.8,0 0,4.4 z m -5.5,-5.8 0,-29.9 -5.3,0 0,29.9 z m -10.8,0 0,-29.9 -5.1,0 0,29.9 z m -31.1,0 0,-29.9 -5.3,0 0,29.9 z m -10.7,0 0,-29.9 -5.1,0 0,29.9 z m -7.9,-37.5 63.3,0 c -0.4,-0.3 -6.9,-3.4 -8.1,-4 -2.7,-1.3 -5.2,-2.7 -7.9,-4.1 -2.7,-1.3 -5.2,-2.7 -7.9,-4.1 -1.4,-0.7 -7.2,-3.5 -7.9,-4.1 l -31.5,16.1 0,0 z m 65.9,6.2 0,-4.6 -68.8,0 0,4.6 z m -33.5,25.1 v -8 c 1.7,0.4 4,1 4,3.1 v 1.5 c 0,1.4 -2.2,3.5 -4,3.5 z m -5.6,-14 v -2 c 0,-1.3 2.4,-2.4 3.6,-2.7 v 7.4 c -1.5,-0.1 -3.6,-1.1 -3.6,-2.7 z m 3.6,-6.7 h -0.8 c -3,0 -6.2,2.3 -6.2,5.3 v 1.8 c 0,2.5 4.6,5.1 6.9,5.1 v 8.6 c -2.4,0 -4.4,-2.5 -4.4,-4.9 l -3.1,0.5 v 0.9 c 0,1.3 1.6,3.5 2.4,4.1 1,0.8 3.3,1.6 5.1,1.7 v 2.5 h 2 v -2.5 c 3.9,0 7.3,-2.7 7.3,-6.7 v -1.1 c 0,-3 -4.3,-5 -7.3,-5.3 v -7.8 c 0.8,0.1 1.9,0.6 2.3,1.2 0.3,0.5 1.1,2.3 1.4,2.4 l 2.9,-0.4 c 0,-3 -3.1,-5.3 -6,-5.3 h -0.6 v -1.4 h -2 v 1.4 z"}],o["GR.IN.IC.FINANCIAL EXCHANGE"]=[{type:"path",stroke:!1,d:"m 133.7,124.6 0,-1.4 -66.8,0 0.3,0 0,-47 -1,0 0,48.4 z m -29.5,-8.6 -9.8,-20.8 -5.9,14.4 -5.3,-6.5 -13.3,12.4 0.9,1 v 0.2 l 12.4,-11.3 5.5,7 h 0.3 c 0,-1 2.3,-5.6 2.8,-7 0.3,-1 1.1,-2.4 1.5,-3.4 0.3,-0.8 0.9,-3.1 1.5,-3.2 l 9.4,20.3 0.1,0.2 17.4,-27.4 0.2,0.1 8,15.6 1.4,-0.5 -9.4,-18 c -0.1,0.5 -7.7,12.1 -8.7,13.6 -1,1.6 -8.2,13.2 -8.9,13.4 z m 2.8,-19.4 V 89.2 c 2.1,0 4.1,1.4 4.1,3.6 v 0.2 c 0,2.1 -1.9,3.6 -4.1,3.6 z m -4.7,-13.6 c 0,-2 1,-3.4 3,-3.4 h 0.5 v 6.6 c -1.8,-0.1 -3.4,-1.3 -3.4,-3.2 z m 3.5,-5.6 h -1 c -2.6,0 -5.2,2.9 -5.2,5.6 v 1 c 0,1.1 1.3,2.8 2.1,3.4 1.1,0.8 2.5,1.2 4,1.5 v 7.8 c -2.6,-0.6 -4.1,-1.7 -4.1,-4.8 h -2.4 l 0.2,2.5 c 0.9,1.4 0.6,2.1 2.2,3.2 1.1,0.7 2.4,1.2 4.1,1.2 v 2.8 h 1.2 v -2.8 c 3,0 6.4,-2.3 6.4,-5 v -2.5 c 0,-2.9 -4,-4.3 -6.4,-4.8 v -6.9 c 2,0 3.4,1.4 3.4,3.3 h 2.7 c 0,-3.2 -2.8,-5.5 -6.1,-5.5 V 75.4 h -1.2 v 1.9 z"}],o["GR.IN.IC.FINANCIAL SERVICES, OTHER"]=[{type:"path",stroke:!1,d:"m 103.4,138.2 -2.7,0 -0,-8.2 c -1.9,-0 -3.8,-0.3 -5.7,-0.7 -1.9,-0.4 -3.8,-1 -5.8,-1.9 l 0,-4.9 c 1.9,1.2 3.7,2.1 5.6,2.7 1.9,0.6 3.9,0.9 5.9,0.9 l 0,-12.5 c -4,-0.7 -7,-1.8 -8.8,-3.3 -1.8,-1.6 -2.7,-3.7 -2.7,-6.5 -5e-6,-3 1,-5.3 3,-7 2,-1.7 4.8,-2.7 8.6,-3 l 0,-6.4 2.7,0 0,6.3 c 1.7,0.1 3.3,0.3 4.9,0.5 1.6,0.3 3.1,0.7 4.6,1.1 l 0,4.8 c -1.5,-0.8 -3.1,-1.4 -4.7,-1.8 -1.6,-0.4 -3.2,-0.7 -4.9,-0.7 l 0,11.7 c 4.1,0.6 7.2,1.8 9.1,3.4 2,1.6 2.9,3.9 2.9,6.7 -3e-5,3.1 -1,5.5 -3.1,7.3 -2.1,1.8 -5,2.8 -8.9,3.1 l 0,8.3 m -2.7,-29.3 0,-11.2 c -2.1,0.2 -3.7,0.8 -4.8,1.8 -1.1,1 -1.7,2.3 -1.7,3.9 -1e-5,1.6 0.5,2.8 1.5,3.7 1,0.9 2.7,1.5 5,1.9 m 2.7,5.3 0,11.8 c 2.3,-0.3 4.1,-1 5.2,-2 1.2,-1 1.8,-2.3 1.8,-4 -3e-5,-1.6 -0.6,-2.9 -1.7,-3.8 -1.1,-0.9 -2.9,-1.6 -5.3,-2.1 m 5.8,-52.2 2.1,0 0,6.2 7.5,0 0,-6.2 2.1,0 0,15.2 -2.1,0 0,-7.2 -7.5,0 0,7.2 -2.1,0 0,-15.2 m -14.8,0 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -8.1,1.4 c -1.5,1.3e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -3e-6,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -1.3e-5,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -1.5e-5,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,-10e-7 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -1e-6,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1"}],o["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 101.9,123.3 -1.7,0 -0,-5 c -1.2,-0 -2.3,-0.2 -3.5,-0.4 -1.2,-0.3 -2.3,-0.6 -3.5,-1.1 l 0,-3 c 1.1,0.7 2.3,1.2 3.4,1.6 1.2,0.4 2.4,0.5 3.6,0.5 l 0,-7.6 c -2.4,-0.4 -4.2,-1.1 -5.3,-2 -1.1,-1 -1.7,-2.3 -1.7,-3.9 -2e-6,-1.8 0.6,-3.2 1.8,-4.3 1.2,-1 2.9,-1.6 5.2,-1.8 l 0,-3.9 1.7,0 0,3.9 c 1,0 2,0.2 3,0.3 1,0.2 1.9,0.4 2.8,0.7 l 0,2.9 c -0.9,-0.5 -1.9,-0.8 -2.8,-1.1 -1,-0.3 -2,-0.4 -3,-0.4 l 0,7.1 c 2.5,0.4 4.4,1.1 5.5,2.1 1.2,1 1.8,2.4 1.8,4.1 -2e-5,1.9 -0.6,3.3 -1.9,4.4 -1.3,1.1 -3.1,1.7 -5.4,1.9 l 0,5 m -1.7,-17.8 0,-6.8 c -1.3,0.1 -2.3,0.5 -2.9,1.1 -0.7,0.6 -1,1.4 -1,2.3 -6e-6,1 0.3,1.7 0.9,2.2 0.6,0.5 1.6,0.9 3,1.1 m 1.7,3.2 0,7.2 c 1.4,-0.2 2.5,-0.6 3.2,-1.2 0.7,-0.6 1.1,-1.4 1.1,-2.4 -1e-5,-1 -0.3,-1.7 -1,-2.3 -0.7,-0.6 -1.7,-1 -3.2,-1.3 M 104.5,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 70 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 V 86.9 H 68.8 v 39.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 101.9,108.7 0,7.2 c 1.4,-0.2 2.5,-0.6 3.2,-1.2 0.7,-0.6 1.1,-1.4 1.1,-2.4 -1e-5,-1 -0.3,-1.7 -1,-2.3 -0.7,-0.6 -1.7,-1 -3.2,-1.3 m -1.7,-3.2 0,-6.8 c -1.3,0.1 -2.3,0.5 -2.9,1.1 -0.7,0.6 -1,1.4 -1,2.3 -6e-6,1 0.3,1.7 0.9,2.2 0.6,0.5 1.6,0.9 3,1.1 m 4.3,-30.7 0,13.4 -34.6,0 0,37 60.1,0 0,-37 -6.7,0 0,-13.4 -4.5,0 0,13.4 -9.9,0 0,-13.4 -4.5,0 z m -4.3,17.6 1.7,0 0,3.8 c 1,0 2,0.2 3,0.3 1,0.2 1.9,0.4 2.8,0.7 l 0,2.9 c -0.9,-0.5 -1.9,-0.8 -2.8,-1.1 -1,-0.3 -2,-0.4 -3,-0.5 l 0,7.1 c 2.5,0.4 4.3,1.1 5.5,2.1 1.2,1 1.8,2.4 1.8,4.1 -2e-5,1.9 -0.6,3.4 -1.9,4.4 -1.3,1.1 -3.1,1.7 -5.4,1.9 l 0,5 -1.7,0 -0,-5 c -1.2,-0 -2.3,-0.2 -3.5,-0.4 -1.2,-0.3 -2.3,-0.6 -3.5,-1.1 l 0,-3 c 1.1,0.7 2.3,1.3 3.4,1.6 1.2,0.4 2.4,0.5 3.6,0.5 l 0,-7.6 c -2.4,-0.4 -4.2,-1.1 -5.3,-2 -1.1,-1 -1.7,-2.2 -1.7,-3.9 -2e-6,-1.8 0.6,-3.2 1.8,-4.3 1.2,-1 3,-1.6 5.2,-1.8 l 0,-3.9 z"}],o["GR.IN.IC.CHEMICAL PLANT"]=[{type:"path",stroke:!1,d:"m 94.4,89.6 0,0.1 c -0.5,0.1 -1,0.3 -1.4,0.6 -0.5,0.5 -0.6,1.3 -0.5,1.9 0.2,0.8 0.8,1.5 1.7,1.8 -0,0.5 -0.1,1.7 0,3 l -0.1,0 c -0,2.7 -2.3,5.7 -4.9,8.8 -2.4,3 -5,6.4 -5.3,10.4 l -0.1,0 c 0,0.1 0,0.2 0,0.2 -0,0.1 -0,0.2 -0,0.3 l 0.1,0 c 0.2,2.4 1.7,4.2 3.7,5.3 2.1,1.2 4.6,1.7 6.8,1.6 l 0,-0 8.9,0 0,0.1 c 0.3,-0 0.5,-0 0.8,-0.1 l 0.5,0 0,-0.1 c 2.1,-0.2 4.2,-0.3 6,-1 1.1,-0.4 2.1,-1.1 2.8,-2.1 0.6,-0.9 0.9,-2.1 1.1,-3.6 l 0.2,0 c 0.2,-4.4 -2.1,-7.5 -4.5,-10.3 -2.3,-2.8 -4.7,-5.5 -5.4,-9.6 0,-1.3 0.1,-3 0.1,-3.3 0.2,-0.1 0.4,-0.2 0.6,-0.3 0.5,-0.4 0.9,-1 0.9,-1.7 -0,-0.7 -0.5,-1.3 -1.1,-1.6 -0.4,-0.2 -0.9,-0.3 -1.5,-0.4 l 0,-0.1 c -0.2,0 -0.4,-0 -0.6,0 -2.5,0 -7.2,0 -8.1,0 -0.1,-2.4e-4 -0.7,0 -0.7,0 z m 0.7,2 c 0.8,0 5.5,0 8.1,0 0.6,0 0.9,0.1 1.1,0.2 -0.2,0.1 -0.5,0.3 -0.9,0.4 l -8.1,0 c -0.4,-0.1 -0.7,-0.3 -0.7,-0.4 -0,-0.1 -0,-0.1 -0,-0.1 0,-0 0.1,-0.1 0.6,-0.1 z m 1.2,2.6 6.7,0 c -0,0.7 -0.1,1.9 -0.1,3.1 -0,0.1 -0,0.2 -0,0.3 l 0.1,0 c 0.9,4.5 3.5,7.6 5.8,10.3 2.2,2.7 4,5 4,8.4 l -0.1,0 c -0,1.4 -0.4,2.4 -0.8,3 -0.4,0.7 -1,1.1 -1.8,1.4 -1.4,0.6 -3.6,0.7 -5.8,0.9 l -10.3,0 0,0 c -1.6,0 -3.6,-0.4 -5.1,-1.3 -1.6,-0.9 -2.6,-2.2 -2.7,-3.9 0.1,-3.2 2.4,-6.3 4.9,-9.4 2.4,-3 5.1,-6.1 5.3,-9.6 l 0.1,-0 c -0.1,-1 -0.1,-2.7 -0,-3.3 z m -7,19.6 v 1.9 c 0,3.5 6,4.3 9.9,4.3 h 3.2 c 2.5,0 8,-2.2 8,-4.2 v -0.8 c 0,-3.2 -6.6,-9.4 -7.3,-12.4 h -7.5 c -0.6,2.5 -6.2,10 -6.2,11.2 z m 14.8,-39 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 v 13.4 h -34.4 v 39.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 104.1 74.8 L 104.1 88.2 L 69.6 88.2 L 69.6 125.2 L 129.6 125.2 L 129.6 88.2 L 122.9 88.2 L 122.9 74.8 L 118.5 74.8 L 118.5 88.2 L 108.6 88.2 L 108.6 74.8 L 104.1 74.8 z M 94.4 89.6 C 94.4 89.6 95.1 89.6 95.2 89.6 C 96.1 89.6 100.8 89.6 103.3 89.6 C 103.5 89.6 103.8 89.6 103.9 89.6 L 103.9 89.7 C 104.5 89.8 105 89.9 105.4 90.1 C 106 90.4 106.5 91 106.5 91.7 C 106.5 92.4 106.1 93 105.6 93.4 C 105.4 93.5 105.2 93.6 105 93.8 C 105 94 104.9 95.7 104.9 97.1 C 105.6 101.1 108 103.8 110.3 106.7 C 112.6 109.5 114.9 112.6 114.7 117 L 114.6 116.9 C 114.4 118.4 114.1 119.6 113.5 120.5 C 112.8 121.5 111.8 122.2 110.8 122.7 C 108.9 123.4 106.8 123.5 104.8 123.7 L 104.8 123.7 L 104.3 123.7 C 104.1 123.7 103.8 123.8 103.5 123.8 L 103.5 123.7 L 94.6 123.7 L 94.6 123.8 C 92.4 123.9 89.9 123.4 87.8 122.2 C 85.9 121.1 84.3 119.2 84.1 116.8 L 84.1 116.8 C 84.1 116.7 84.1 116.6 84.1 116.5 C 84.1 116.4 84 116.4 84 116.3 L 84.1 116.3 C 84.3 112.3 86.9 109 89.4 105.9 C 91.9 102.7 94.2 99.8 94.3 97.1 L 94.3 97.1 C 94.2 95.7 94.3 94.6 94.3 94 C 93.5 93.7 92.8 93.1 92.6 92.3 C 92.4 91.6 92.6 90.9 93.1 90.4 C 93.4 90 93.9 89.8 94.4 89.7 L 94.4 89.6 z M 95.1 91.6 C 94.7 91.6 94.5 91.7 94.5 91.8 C 94.5 91.8 94.5 91.7 94.6 91.8 C 94.6 91.9 94.8 92.2 95.3 92.2 L 103.4 92.2 C 103.8 92.1 104.1 92 104.3 91.8 C 104.1 91.8 103.8 91.6 103.2 91.6 C 100.6 91.6 95.9 91.6 95.1 91.6 z M 96.3 94.2 C 96.2 94.9 96.2 96.5 96.3 97.5 L 96.2 97.6 C 96 101.1 93.4 104.2 90.9 107.2 C 88.5 110.3 86.2 113.3 86.1 116.6 C 86.2 118.3 87.2 119.5 88.8 120.5 C 90.3 121.3 92.3 121.8 93.9 121.8 L 93.9 121.7 L 104.2 121.7 C 106.5 121.5 108.6 121.4 110 120.8 C 110.8 120.5 111.4 120.1 111.8 119.4 C 112.3 118.8 112.6 117.8 112.7 116.4 L 112.7 116.4 C 112.7 113 110.9 110.6 108.7 107.9 C 106.5 105.2 103.8 102.1 103 97.6 L 102.8 97.6 C 102.8 97.5 102.9 97.4 102.9 97.3 C 102.9 96.1 102.9 94.9 103 94.2 L 96.3 94.2 z M 95.5 102.6 L 103 102.6 C 103.8 105.7 110.3 111.9 110.3 115.1 L 110.3 115.9 C 110.3 117.9 104.9 120 102.4 120 L 99.2 120 C 95.3 120 89.3 119.2 89.3 115.7 L 89.3 113.8 C 89.3 112.6 94.9 105.1 95.5 102.6 z "}],o["GR.IN.IC.FIREARMS MANUFACTURER"]=[{type:"path",stroke:!1,d:"m 104.1,74.8 h 4.5 v 13.4 h 9.9 V 74.8 h 4.5 v 13.4 h 6.7 v 37 H 69.6 V 88.2 h 34.6 l 4e-4,-13.4 0,0 z m -35.7,51.6 h 62.3 V 86.9 h -6.4 V 73.5 h -7.2 v 13.4 h -7.2 V 73.5 h -7.2 v 13.4 h -34.4 v 39.5 z m 25.8,-26.6 h 10.8 v 5.8 c -1.6,0 -4.7,1 -5.8,0.7 -1.2,-0.4 -3.8,-1.5 -5,-1.6 v -4.8 z m -19.2,0 h 16.6 v 6 c 0,0.6 3,1.4 3.7,1.7 0.4,0.1 3.9,1.4 3.9,1.5 l 7.2,-0.9 0.8,2.7 1.1,3.7 c 0.3,0.4 1,2.4 1,3.1 v 0.2 c 0,1.1 -0.6,1.9 -0.6,3.5 l 13.5,-0 -0.9,-3 -0.6,-1.7 -3,-10 c -0.2,-0.4 -0.5,-0.7 -0.5,-1.3 0,-1.3 3.9,-4.1 4.7,-5.3 l -2.7,-8.4 h -43.9 v 8.4 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 94.2,99.9 h 10.8 v 5.8 c -1.6,0 -4.7,1 -5.8,0.7 -1.2,-0.4 -3.8,-1.5 -5,-1.6 v -4.8 z m 9.9,-25.1 0,13.4 -34.6,0 0,37 60.1,0 0,-37 -6.7,0 0,-13.4 -4.5,0 0,13.4 -9.9,0 0,-13.4 -4.5,0 z m -29.1,16.7 43.9,0 2.7,8.4 c -0.8,1.2 -4.7,4.1 -4.7,5.3 0,0.6 0.2,0.9 0.5,1.3 l 3.1,10 0.6,1.8 0.9,3 -13.5,0 c 0,-1.6 0.7,-2.4 0.7,-3.6 l 0,-0.2 c 0,-0.7 -0.7,-2.7 -1,-3.1 L 107.2,110.8 106.4,108.1 99.2,109 c -0,-0.1 -3.6,-1.4 -3.9,-1.5 -0.7,-0.3 -3.7,-1.1 -3.7,-1.7 l 0,-5.9 -16.6,0 0,-8.4 z"}],o["GR.IN.IC.FIREARMS RETAILER"]=[{type:"path",stroke:!1,d:"m 85.1,123 -1.1,0 -0,-3.2 c -0.8,-0 -1.5,-0.1 -2.3,-0.3 -0.8,-0.2 -1.5,-0.4 -2.3,-0.7 l 0,-1.9 c 0.7,0.5 1.5,0.8 2.2,1 0.8,0.2 1.5,0.3 2.3,0.4 l 0,-4.9 c -1.6,-0.3 -2.7,-0.7 -3.5,-1.3 -0.7,-0.6 -1.1,-1.5 -1.1,-2.5 -2e-6,-1.2 0.4,-2.1 1.2,-2.8 0.8,-0.7 1.9,-1.1 3.4,-1.2 l 0,-2.5 1.1,0 0,2.5 c 0.7,0 1.3,0.1 1.9,0.2 0.6,0.1 1.2,0.3 1.8,0.5 l 0,1.9 c -0.6,-0.3 -1.2,-0.5 -1.8,-0.7 -0.6,-0.2 -1.3,-0.3 -1.9,-0.3 l 0,4.6 c 1.6,0.3 2.8,0.7 3.6,1.3 0.8,0.6 1.1,1.5 1.1,2.6 -1.2e-5,1.2 -0.4,2.2 -1.2,2.9 -0.8,0.7 -2,1.1 -3.5,1.2 l 0,3.3 m -1.1,-11.5 0,-4.4 c -0.8,0.1 -1.5,0.3 -1.9,0.7 -0.4,0.4 -0.7,0.9 -0.7,1.5 -4e-6,0.6 0.2,1.1 0.6,1.4 0.4,0.3 1.1,0.6 2,0.7 m 1.1,2.1 0,4.7 c 0.9,-0.1 1.6,-0.4 2.1,-0.8 0.5,-0.4 0.7,-0.9 0.7,-1.6 -1e-5,-0.6 -0.2,-1.1 -0.7,-1.5 -0.4,-0.4 -1.1,-0.6 -2.1,-0.8 m 22.6,-21.9 -8,20.8 0.8,0.3 8,-20.8 -0.8,-0.3 z m -43,6.5 0,0.8 0.3,26 0,0.8 0.8,0 32.2,-0.2 0.4,0 0.2,-0.3 7.3,-8.7 0.2,-0.2 -0,-0.3 -0.2,-10.1 0,-0.4 -0.3,-0.2 -8.4,-6.6 -0.2,-0.2 -0.3,0 -31.3,-0.4 -0.8,0 z m 1.6,1.6 30.2,0.3 7.9,6.2 0.2,9.4 -6.9,8.2 -31,0.2 -0.3,-24.3 z M 97.3,85.4 h 14.4 v 7.7 c -2.1,0 -6.2,1.4 -7.8,0.9 -1.6,-0.5 -5,-2.1 -6.6,-2.2 v -6.4 z m -25.5,0 h 22.1 v 7.9 c 0,0.8 4,1.9 4.8,2.2 0.5,0.2 5.2,1.9 5.2,2 l 9.6,-1.2 1,3.6 1.4,4.9 c 0.3,0.5 1.3,3.2 1.3,4.1 v 0.2 c 0,1.5 -0.9,2.5 -0.9,4.7 h 18 l -1.1,-3.9 -0.8,-2.4 -4,-13.4 c -0.3,-0.5 -0.6,-0.9 -0.6,-1.7 0,-1.7 5.2,-5.5 6.2,-7.1 l -3.6,-11.1 H 71.8 v 11.1 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 85.1,113.6 0,4.7 c 0.9,-0.1 1.6,-0.4 2.1,-0.8 0.5,-0.4 0.7,-0.9 0.7,-1.6 -1e-5,-0.6 -0.2,-1.1 -0.7,-1.5 -0.4,-0.4 -1.1,-0.6 -2.1,-0.8 m -1.1,-2.1 0,-4.4 c -0.8,0.1 -1.5,0.3 -1.9,0.7 -0.4,0.4 -0.7,0.9 -0.7,1.5 -4e-6,0.6 0.2,1.1 0.6,1.4 0.4,0.3 1.1,0.6 2,0.7 M 66.4,99.8 l 0.3,24.3 31,-0.2 6.9,-8.2 -0.2,-9.4 -7.9,-6.2 -30.2,-0.3 z m 17.7,3.3 1.1,0 0,2.5 c 0.7,0 1.3,0.1 1.9,0.2 0.6,0.1 1.2,0.2 1.8,0.4 l 0,1.9 c -0.6,-0.3 -1.2,-0.5 -1.8,-0.7 -0.6,-0.2 -1.3,-0.3 -1.9,-0.3 l 0,4.6 c 1.6,0.3 2.8,0.7 3.6,1.3 0.8,0.6 1.2,1.5 1.2,2.7 -1.2e-5,1.2 -0.4,2.2 -1.2,2.9 -0.8,0.7 -2,1.1 -3.5,1.2 l 0,3.3 -1.1,0 0,-3.2 c -0.8,-0 -1.5,-0.1 -2.3,-0.3 -0.8,-0.2 -1.5,-0.4 -2.3,-0.8 l 0,-1.9 c 0.7,0.5 1.5,0.8 2.2,1.1 0.8,0.2 1.5,0.3 2.3,0.3 l 0,-4.9 c -1.6,-0.3 -2.7,-0.7 -3.5,-1.3 -0.7,-0.6 -1.1,-1.5 -1.1,-2.5 -2e-6,-1.2 0.4,-2.1 1.2,-2.8 0.8,-0.7 1.9,-1.1 3.4,-1.2 l 0,-2.5 z"}],o["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]=[{type:"path",stroke:!1,d:"m 104.7,71.8 h 5 v 15 h 11.1 v -15 h 5 v 15 h 7.5 v 41.4 h -67.4 V 86.8 h 38.8 v -15 z m -40,57.9 h 69.8 V 85.5 h -7.1 v -15.2 h -8 v 15.2 h -8 v -15.2 h -8 v 15.2 h -38.6 v 44.1 l 0,0 z m 15.5,-21.8 h 38.6 l -19.3,18.6 -19.3,-18.6 z m 21.8,-16.8 c 0.5,0.4 4.3,3.8 4.3,4.3 v 12 h -4.3 V 91.1 z m -5,-0 0,16.3 h -4.3 l 0.1,-12.2 4.1,-4.1 0,0 z m -12.1,12 c 0,-0.4 3.1,-3.2 3.6,-3.6 v 7.8 h -3.6 v -4.3 z m 25.7,-3.6 3.7,3.4 c -0.2,0.4 -0.2,-0.2 -0.2,0.5 v 4 h -3.6 v -7.9 z m 9.4,8.2 -20.5,-20 -20.4,20 20.4,19.9 20.5,-19.9 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 99.5,126.5 19.3,-18.6 -38.6,0 z m 0,1 -20.4,-19.9 20.4,-20 20.5,20 -20.5,19.8 z m 5.2,-40.8 h -38.8 v 41.4 h 67.4 V 86.8 h -7.5 v -15 h -5 v 15 h -11.1 v -15 h -5 v 15 z m 5.9,20.6 h 3.6 v -4 c 0,-0.7 -0,-0.1 0.2,-0.5 l -3.7,-3.4 v 7.9 z m -8.6,0 h 4.3 v -12 c 0,-0.4 -3.8,-3.9 -4.3,-4.3 v 16.3 z m -9.3,0 4.3,0 -0,-16.3 -4.1,4.1 z m -7.8,-4.3 v 4.3 h 3.6 v -7.9 c -0.5,0.3 -3.6,3.2 -3.6,3.6 z"}],o["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]=[{type:"path",stroke:!1,d:"m 122.4,68.8 c 0.4,0.1 0.9,0.5 1.3,1 0.4,0.5 0.8,1.2 1.3,2 l 2.1,4.1 -2.2,0 -1.9,-3.9 c -0.5,-1 -1,-1.7 -1.5,-2 -0.5,-0.3 -1.1,-0.5 -1.9,-0.5 l -2.2,0 0,6.4 -2.1,0 0,-15.2 4.6,0 c 1.7,1.5e-5 3,0.4 3.9,1.1 0.9,0.7 1.3,1.8 1.3,3.3 -10e-6,1 -0.2,1.7 -0.7,2.4 -0.4,0.6 -1.1,1.1 -1.9,1.3 m -5.1,-6.4 0,5.4 2.6,0 c 1,8e-6 1.7,-0.2 2.2,-0.7 0.5,-0.5 0.8,-1.1 0.8,-2 -10e-6,-0.9 -0.3,-1.6 -0.8,-2 -0.5,-0.5 -1.2,-0.7 -2.2,-0.7 l -2.6,0 m -12.3,-0.3 c -1.5,1.4e-5 -2.7,0.6 -3.6,1.7 -0.9,1.1 -1.3,2.6 -1.3,4.5 -1e-5,1.9 0.4,3.4 1.3,4.5 0.9,1.1 2.1,1.7 3.6,1.7 1.5,1e-6 2.7,-0.6 3.5,-1.7 0.9,-1.1 1.3,-2.6 1.3,-4.5 -10e-6,-1.9 -0.4,-3.4 -1.3,-4.5 -0.9,-1.1 -2,-1.7 -3.5,-1.7 m 0,-1.7 c 2.1,1.5e-5 3.8,0.7 5.1,2.1 1.3,1.4 1.9,3.3 1.9,5.7 -10e-6,2.4 -0.6,4.3 -1.9,5.7 -1.3,1.4 -3,2.1 -5.1,2.1 -2.1,-10e-7 -3.8,-0.7 -5.1,-2.1 -1.3,-1.4 -1.9,-3.3 -1.9,-5.7 -2e-6,-2.4 0.6,-4.3 1.9,-5.7 1.3,-1.4 3,-2.1 5.1,-2.1 m -21,0.3 12.8,0 0,1.7 -5.4,0 0,13.4 -2.1,0 0,-13.4 -5.4,0 0,-1.7 m -2,0.5 0,2 c -0.8,-0.4 -1.5,-0.6 -2.2,-0.8 -0.7,-0.2 -1.4,-0.3 -2,-0.3 -1.1,1.4e-5 -2,0.2 -2.6,0.7 -0.6,0.4 -0.9,1 -0.9,1.8 -3e-6,0.7 0.2,1.2 0.6,1.5 0.4,0.3 1.2,0.6 2.3,0.8 l 1.2,0.3 c 1.5,0.3 2.7,0.8 3.4,1.5 0.7,0.7 1.1,1.7 1.1,2.9 -1.2e-5,1.5 -0.5,2.6 -1.5,3.3 -1,0.8 -2.4,1.1 -4.3,1.1 -0.7,-10e-7 -1.5,-0.1 -2.3,-0.2 -0.8,-0.2 -1.6,-0.4 -2.5,-0.7 l 0,-2.1 c 0.8,0.5 1.6,0.8 2.4,1.1 0.8,0.2 1.6,0.4 2.4,0.4 1.2,1e-6 2.1,-0.2 2.7,-0.7 0.6,-0.5 1,-1.1 1,-2 -1e-5,-0.7 -0.2,-1.3 -0.7,-1.7 -0.5,-0.4 -1.2,-0.7 -2.2,-0.9 l -1.2,-0.2 c -1.5,-0.3 -2.6,-0.8 -3.3,-1.4 -0.7,-0.6 -1,-1.6 -1,-2.7 -2e-6,-1.3 0.5,-2.4 1.4,-3.2 0.9,-0.8 2.3,-1.2 3.9,-1.2 0.7,1.5e-5 1.4,0.1 2.2,0.2 0.7,0.1 1.5,0.3 2.3,0.6 M 70.6,110 h 57.9 l -29,27.9 -28.9,-27.9 z m 32.8,-25.2 c 0.8,0.5 6.4,5.8 6.4,6.4 v 17.9 h -6.4 V 84.8 z m -7.6,-0.1 0.1,24.4 h -6.5 l 0.2,-18.3 6.2,-6.1 0,0 z m -18.2,18 c 0,-0.7 4.7,-4.9 5.3,-5.3 v 11.8 h -5.3 v -6.5 z m 38.6,-5.3 5.6,5.2 c -0.3,0.7 -0.2,-0.3 -0.2,0.7 v 5.9 h -5.3 V 97.4 z m 14.2,12.3 -30.7,-30.1 -30.7,30 30.7,29.9 30.8,-29.8 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 99.5,137.9 29,-27.9 -57.9,0 z m 16.7,-28.7 h 5.3 v -5.9 c 0,-1 -0.1,-0.1 0.2,-0.7 l -5.6,-5.2 v 11.8 z m -12.8,0 h 6.4 V 91.2 c 0,-0.7 -5.6,-5.9 -6.4,-6.4 v 24.4 z m -14,-10e-6 6.5,0 -0.1,-24.4 -6.2,6.1 z m -11.8,-6.4 v 6.4 h 5.3 V 97.4 c -0.7,0.5 -5.3,4.7 -5.3,5.3 z"}],o["GR.IN.IC.INDUSTRIAL SITE"]=[{type:"path",fill:!!e&&i,d:"m 104,75 h 5 v 13 h 9 V 75 h 5 v 13 h 7 v 37 H 70 V 88 h 34 z"}],o["GR.IN.IC.LANDFILL"]=[{type:"path",stroke:!1,d:"m 124.1,115.8 c 0,2.5 1.6,2.7 3,3.6 h -22.8 c 1.2,-0.7 2.8,-1.2 2.8,-3.3 v -1.2 c 0,-1.3 -1.9,-2.8 -3.6,-2.8 -1,0 -1.8,0.4 -2.3,0.9 -0.4,0.4 -1.1,1.6 -1.1,2.1 v 1.3 c 0,0.2 0.9,1.7 1,1.9 0.6,0.7 1.2,0.6 1.8,1 h -8.6 c 0.6,-0.4 1.3,-0.5 1.8,-1.1 0.4,-0.4 0.6,-1.4 1,-1.6 v -1.7 c 0,-0.4 -0.9,-1.8 -1.2,-2.1 -0.6,-0.6 -1.3,-0.9 -2.4,-0.9 h -0.1 c -1.7,0 -3.5,1.5 -3.5,3.1 v 1.3 c 0,1.5 2,2.2 2.8,2.8 h -8.7 c -0.1,-3.2 -2.5,-1.8 -3.1,-3 -1.1,-1.9 0.9,-2.2 -2.8,-3.1 -3.1,-0.8 -2,-0.3 -3.9,-2.2 -0.6,-0.7 -3,-1.8 -4.2,-1.8 h -0.1 c -1,0 -1.9,1.2 -2.7,1.5 -1.1,0.5 -2.3,0.4 -3.2,1.1 -1.1,0.8 -2.3,4.4 -2.3,6.2 v 0.6 h -0.4 v 2.2 h 72.1 4.9 v -1.5 h -9.5 c 0.8,-0.5 0.9,-0.2 1.8,-1 0.4,-0.4 0.9,-1.5 1.2,-1.6 v -1.6 c 0,-0.5 -0.9,-1.9 -1.3,-2.2 -0.7,-0.5 -1.4,-0.8 -2.5,-0.8 -1.9,0 -3.6,1.5 -3.6,3.5 v 0.2 h 0 z m -1,-17.6 h 3.5 c 0.5,0 4.2,4.8 4.6,5.4 h -8.1 v -5.4 z m -4.1,-17.8 -0.7,-1.3 -7,3.9 1.4,3.5 -32,14.5 c 0.8,0.4 2.1,4.3 2.6,5.3 0.2,0.4 2.3,5 2.3,5.1 0,0.5 -0.9,0.2 -0.8,0.6 l 0.5,3.1 h 3.4 c 0,-2.4 2,-4.8 4.3,-4.8 h 1 c 2.4,0 4.3,2.3 4.3,4.8 h 0.6 c 0,-2.4 0.6,-2.3 1.5,-3.6 l -2.1,-5.6 9.5,-4.3 4.2,9.9 -5.1,0 c 0.9,1.3 1.6,1.3 1.6,3.6 h 14.4 v -0.5 c 0,-2.1 2.5,-4.3 4.8,-4.3 h 0.5 c 2.6,0 4.6,2.2 4.6,4.8 h 2.6 v -3.1 h -1.2 v -7.4 c 0,-1.2 -5.8,-6.8 -6.1,-8.1 h -6.4 v 15 h -4.1 l -5.3,-12.1 5.5,-2.3 -4.3,-9.5 5.6,-7.4 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 123.1,103.6 h 8.1 c -0.5,-0.6 -4.2,-5.4 -4.6,-5.4 h -3.5 v 5.4 z"}],o["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]=[{type:"path",stroke:!1,d:"m 105.2,71.3 h 5.1 V 86.5 H 121.5 V 71.3 h 5.1 v 15.2 h 7.6 v 42.1 H 65.8 V 86.6 h 39.4 V 71.3 z M 64.5,130.1 h 71 V 85.3 h -7.3 V 69.9 h -8.2 V 85.3 h -8.2 V 69.9 H 103.7 V 85.3 H 64.5 v 44.8 z M 90.3,93.1 h 7.6 c 1.2,0 3.4,1.8 3.4,2.7 v 2.6 c 0,1.3 -2.4,2.9 -3.6,2.9 h -7.4 v -8.2 z m -4.9,26.5 h 4.9 v -13.1 l 1.7,0.1 7.6,10 -8.8,11 5.9,0.1 5.9,-7 c 1.2,0.3 4.2,5.9 5.6,6.9 h 6.2 c -0.9,-1.7 -8.4,-10.4 -8.4,-11 0,-0.3 7.4,-9.7 8.2,-10.4 l -6,-0.1 -5.6,6.2 -4.3,-5.7 c 5.2,-1.2 8.4,-3.3 8.4,-9.8 v -0.6 c 0,-2 -1.7,-4.7 -2.8,-5.8 -1,-1 -4.1,-2.4 -6.2,-2.4 H 85.4 v 31.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 85.4,88 h 12.4 c 2.1,0 5.1,1.4 6.1,2.4 1.1,1.1 2.8,3.8 2.8,5.8 v 0.6 c 0,6.5 -3.1,8.6 -8.4,9.8 l 4.3,5.7 5.6,-6.2 6.1,0.1 c -0.8,0.6 -8.2,10 -8.2,10.4 0,0.7 7.4,9.4 8.4,11.1 h -6.2 c -1.5,-1 -4.4,-6.6 -5.6,-6.9 l -5.9,6.9 -5.9,-0.1 8.8,-11 -7.6,-9.9 -1.8,-0.1 v 13.1 h -4.9 v -31.6 z m 19.8,-1.4 h -39.4 v 42.1 h 68.4 V 86.6 h -7.6 V 71.3 H 121.5 V 86.5 H 110.3 V 71.3 h -5.1 v 15.3 z m -14.9,14.7 h 7.4 c 1.2,0 3.6,-1.6 3.6,-2.9 v -2.5 c 0,-1 -2.2,-2.7 -3.4,-2.7 h -7.6 v 8.2 z"}],o["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]=[{type:"path",stroke:!1,d:"m 133.7,71.5 c -0.3,0 -0.7,0.1 -0.9,0.2 l -49.5,0 -0.7,0 0,0.1 c -0.7,0.3 -1.3,0.9 -1.8,1.7 -0.6,1 -1.2,2.5 -1.6,4.2 -0.9,3.5 -1.4,8.2 -1.4,13.4 0,4.8 0.5,9.2 1.2,12.6 -1,0.1 -2.1,0.5 -3,0.3 -1.2,-0.1 -2.5,-0.1 -3.8,-0.1 -1.3,0 -6.5,-0.9 -6.5,0.7 0,1.8 6,3.4 7.5,6.1 -0.8,1.5 -5.9,1.4 -8.1,1.8 -1.5,0.2 -3,0.2 -3.8,1.1 -1,1 0.2,2.3 1.1,2.7 1.7,0.9 6,1 8.2,1.5 1.3,0.3 2.6,0.7 3.1,1.9 0.4,1.1 0.6,2.6 2.2,2.6 l 0.1,0 c 2.1,0 5.1,-1.7 7.9,-1.7 l 1.1,0 c 6.2,0 6.8,7.4 12.3,7.7 3.5,0.2 5.3,-0.8 7.8,-1.9 1.6,-0.7 5.5,-2.8 7.3,-2.8 l 0.3,0 c 1.8,0 3.3,1.1 4.8,1.5 1.6,0.5 3.3,1 5.4,1 l 0.5,0 c 1.2,0 2.3,-0.2 3.2,-0.5 1.2,-0.4 1.1,-1 1.1,-2.4 -0.1,-1.9 -2.2,-3.3 -3.5,-4 -1.4,-0.9 -3.4,-1.8 -4.9,-2.6 -0.8,-0.4 -1.5,-0.9 -2.3,-1.4 -1.3,-1 -1,-0.6 -1.7,-2.1 1.2,-1.8 6.9,0.2 6.9,-1.9 0,-0.2 -0.3,-0.5 -0.7,-0.7 l 12.2,0 0.7,0 0,-0.4 c 0.7,-0.3 1.3,-0.9 1.8,-1.7 0.6,-1 1.2,-2.5 1.6,-4.2 0.9,-3.5 1.4,-8.2 1.4,-13.4 0,-5.2 -0.5,-9.9 -1.4,-13.4 -0.4,-1.7 -1,-3.2 -1.6,-4.2 -0.6,-1 -1.4,-1.8 -2.5,-1.8 z m 0.3,1.4 c 0.3,0 0.7,0.3 1.3,1.1 0.5,0.8 1,2.2 1.4,3.8 0.8,3.3 1.4,7.9 1.4,13.1 0,5.1 -0.5,9.8 -1.4,13.1 -0.4,1.7 -0.9,3 -1.4,3.8 -0.5,0.8 -1,1.1 -1.3,1.1 -0.2,0 -0.4,-0.1 -0.7,-0.4 l 0,0.7 -47.9,0 c 0.2,-0.2 0.4,-0.4 0.6,-0.8 0.6,-1 1.1,-2.3 1.5,-4 0.9,-3.4 1.4,-8.1 1.4,-13.2 0,-5.2 -0.5,-9.8 -1.4,-13.2 -0.4,-1.7 -0.9,-3.1 -1.5,-4 -0.2,-0.3 -0.4,-0.5 -0.6,-0.7 l 47.9,0 0,0.2 c 0.3,-0.3 0.5,-0.4 0.7,-0.4 z m -50.7,0.2 c 0.3,0 0.7,0.3 1.3,1.1 0.5,0.8 1,2.2 1.4,3.8 0.8,3.3 1.4,7.9 1.4,13.1 0,5.1 -0.5,9.8 -1.4,13.1 -0.4,1.7 -0.9,3 -1.4,3.8 -0.5,0.8 -1,1.1 -1.3,1.1 -0.3,0 -0.7,-0.3 -1.3,-1.1 -0.3,-0.5 -0.6,-1.1 -0.8,-1.8 0.4,1.7 1,3 1.7,3.5 l 8.3,-0.2 7.1,0.1 20.3,-0.1 c 0.5,0 1.5,0.5 2.3,1 l 0,0 c 0.5,0.3 0.8,0.6 1,0.7 -0.1,0.2 -0.4,0.3 -0.6,0.4 -0.2,0.1 -0.5,0.2 -0.8,0.2 -0.4,0.1 -0.9,0.1 -1.3,0.1 -0.2,-0 -0.5,-0 -0.7,-0 -0.4,-0 -0.9,-0 -1.2,-0 l -0.3,0 c -0.9,0 -1.7,0.5 -1.7,1.4 l 0,0.1 0,0.1 c 0,0.1 0,0.2 0,0.3 0.7,3 11.3,5.8 11.9,9.2 0,0.1 0,0.2 0,0.3 -0,0.1 -0,0.1 -0,0.1 -0.2,1.6 -2.9,2.2 -5.2,2.2 -0.7,0 -1.3,0 -1.8,-0.1 -2.6,-0.4 -5.4,-2.3 -7.3,-2.3 -5.3,0 -9.5,5.5 -15.2,4.8 -4.4,-0.6 -5.5,-7.9 -12.3,-7.9 l -1.3,0 c -3,0 -5.6,1.7 -8.4,1.7 -0.5,0 -0.7,-0.3 -0.9,-0.6 -0,-0 -0,-0.1 -0.1,-0.1 -0.2,-0.5 -0.3,-1.1 -0.6,-1.6 -0,-0 0,-0 0,-0 -0,-0.1 -0.1,-0.1 -0.1,-0.2 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0.1 -0.1,-0.1 -0.1,-0.1 -0.1,-0.2 -0.3,-0.3 -0.4,-0.4 -1.2,-0.9 -2.3,-1.1 -4,-1.4 -1.9,-0.3 -5.8,-0.3 -7.3,-1.5 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0.1 -0,-0 -0,-0 -0,-0 -0.2,-0.3 -0.4,-0.6 -0.4,-0.9 l 0,-0.3 c 0,-2.1 13.2,-0.9 13.2,-3.2 0,-0.3 -0.1,-0.6 -0.3,-0.8 -0,-0.1 -0.1,-0.1 -0.1,-0.2 -0,-0 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.1,-0.1 -0.2,-0.2 -0,-0 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.3,-0.3 -0.5,-0.4 -1.7,-1.3 -4.8,-2.7 -6.3,-3.9 -0.1,-0.1 -0.3,-0.2 -0.4,-0.3 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0.1,-0.1 -0,-0 -0.1,-0.1 -0.1,-0.1 -0.1,-0.1 -0.2,-0.2 -0.2,-0.4 0.3,-0.1 0.6,-0.3 1.1,-0.3 l 2.9,0 6.3,0.3 2.6,-0.3 c 9.4e-4,0 -9.4e-4,0 0,0 l 0.7,-0.1 0.8,0.1 c -0,-0 -0,-0 -0,-0 -0.8,-3.3 -1.4,-7.9 -1.4,-13.1 0,-5.1 0.5,-9.7 1.4,-13.1 0.4,-1.7 0.9,-3 1.4,-3.8 0.5,-0.8 1,-1.1 1.3,-1.1 z m 27.7,1.1 -17.4,17 17.4,16.9 17.4,-16.9 -17.4,-17 z m -2.2,2.9 0,13.8 -3.6,0 0.1,-10.4 3.5,-3.5 z m 4.3,0 c 0.4,0.3 3.6,3.3 3.6,3.7 l 0,10.2 -3.6,0 0,-13.8 z m 7.3,7.2 3.2,2.9 c -0.1,0.1 -0.1,0.1 -0.1,0.1 -0,-0 0,0 0,0.3 l 0,3.3 -3.1,0 0,-6.7 z m -18.8,0 0,6.7 -3,0 0,-3.7 c 0,-0.4 2.7,-2.8 3,-3 z m -7,7.1 32.8,0 -16.4,15.8 -16.4,-15.8 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 134,72.9 c -0.2,0 -0.4,0.1 -0.7,0.4 l 0,-0.2 -47.9,0 c 0.2,0.2 0.4,0.4 0.6,0.7 0.6,1 1.1,2.3 1.5,4 0.9,3.4 1.4,8.1 1.4,13.2 0,5.2 -0.5,9.8 -1.4,13.2 -0.4,1.7 -0.9,3.1 -1.5,4 -0.2,0.3 -0.4,0.5 -0.6,0.8 l 47.9,0 0,-0.7 c 0.3,0.3 0.5,0.4 0.7,0.4 0.3,0 0.7,-0.3 1.3,-1.1 0.5,-0.8 1,-2.2 1.4,-3.8 0.8,-3.3 1.4,-7.9 1.4,-13.1 0,-5.1 -0.5,-9.8 -1.4,-13.1 -0.4,-1.7 -0.9,-3 -1.4,-3.8 -0.5,-0.8 -1,-1.1 -1.3,-1.1 z m -50.7,0.2 c -0.3,0 -0.7,0.3 -1.3,1.1 -0.5,0.8 -1,2.2 -1.4,3.8 -0.8,3.3 -1.4,7.9 -1.4,13.1 0,5.1 0.5,9.8 1.4,13.1 0,0 0,0 0,0 l -0.8,-0.1 -3.3,0.4 -6.2,-0.3 -2.9,0 c -0.5,0 -0.8,0.1 -1.1,0.3 0.4,1.6 8.4,4.3 8.4,6.5 0,2.3 -13.2,1.1 -13.2,3.2 l 0,0.3 c 0,2.4 5.6,2.3 8,2.7 1.7,0.3 2.8,0.5 4,1.4 1.3,1 0.8,3.3 2.2,3.3 2.8,0 5.4,-1.7 8.4,-1.7 l 1.3,0 c 6.8,0 7.9,7.3 12.3,7.9 5.7,0.7 9.9,-4.8 15.2,-4.8 1.8,0 4.7,1.9 7.3,2.3 2.3,0.2 7,-0.2 7,-2.4 0,-3.6 -12,-6.5 -12,-9.8 l 0,-0.1 c 0,-0.9 0.9,-1.4 1.7,-1.4 l 0.3,0 c 1.4,0 3.9,0.3 4.7,-0.7 -0.3,-0.4 -2.5,-1.7 -3.2,-1.7 l -20.3,0.1 -7.1,-0.1 -8.3,0.2 c -0.7,-0.5 -1.3,-1.8 -1.7,-3.5 0.3,0.7 0.5,1.3 0.8,1.8 0.5,0.8 1,1.1 1.3,1.1 0.3,0 0.7,-0.3 1.3,-1.1 0.5,-0.8 1,-2.2 1.4,-3.8 0.8,-3.3 1.4,-7.9 1.4,-13.1 0,-5.1 -0.5,-9.7 -1.4,-13.1 -0.4,-1.7 -0.9,-3 -1.4,-3.8 -0.5,-0.8 -1,-1.1 -1.3,-1.1 z m 27.7,1.1 17.4,17 -17.4,16.9 -17.4,-16.9 17.4,-17 z m -2.2,2.9 -3.5,3.5 -0.1,10.4 3.6,0 -0,-13.8 z m 4.3,0 0,13.8 3.6,0 0,-10.2 c 0,-0.4 -3.2,-3.4 -3.6,-3.7 z m 7.3,7.2 0,6.7 3.1,0 0,-3.3 c 0,-0.3 -0,-0.3 -0,-0.3 0,0 0,0 0.1,-0.1 l -3.2,-2.9 z m -18.8,0 c -0.4,0.3 -3,2.7 -3,3 l 0,3.7 3,0 0,-6.7 z m -7,7.1 16.4,15.8 16.4,-15.8 -32.8,0 z"}],o["GR.IN.IC.TOXIC RELEASE INVENTORY"]=[{type:"path",stroke:!1,d:"m 81.8,61 0,15.2 2,0 0,-6.4 2.2,0 c 0.8,6e-6 1.5,0.2 1.9,0.5 0.5,0.3 1,1 1.5,2 l 1.9,3.9 2.2,0 -2.1,-4.2 c -0.4,-0.9 -0.8,-1.5 -1.3,-2 -0.4,-0.5 -0.8,-0.8 -1.3,-0.9 0.8,-0.2 1.5,-0.7 1.9,-1.3 0.4,-0.6 0.7,-1.4 0.7,-2.4 -2e-5,-1.5 -0.4,-2.6 -1.3,-3.3 -0.9,-0.7 -2.1,-1.1 -3.9,-1.1 l -4.6,0 z m 14.5,0 0,15.2 9.8,0 0,-1.7 -7.7,0 0,-5.5 7.2,0 0,-1.7 -7.2,0 0,-4.5 7.5,0 0,-1.7 -9.6,0 z m 13.2,0 0,15.2 9.4,0 0,-1.7 -7.4,0 0,-13.4 -2,0 z m -25.6,1.7 2.6,0 c 1,1.4e-5 1.7,0.2 2.2,0.7 0.5,0.4 0.8,1.1 0.8,2 -10e-6,0.9 -0.3,1.6 -0.8,2 -0.5,0.5 -1.2,0.7 -2.2,0.7 l -2.6,0 0,-5.4 z m 16,14.7 c -4.3,1.1e-5 -8.3,0.4 -11.2,1.2 -1.4,0.4 -2.6,0.8 -3.5,1.3 -0.7,0.4 -1.2,0.9 -1.4,1.5 l -0.1,0 0,0.6 c -3.1e-5,0 0,0 0,0 l 0,31.1 -0.2,-0.7 c -0.1,0 -1.1,0.1 -2.4,0 -1.2,-0.1 -2.7,-0.2 -4.2,-0.3 -1.5,-0.1 -2.9,-0.2 -4,-0.1 -0.6,0 -1.1,0 -1.5,0.1 -0.2,0 -0.4,0.1 -0.6,0.2 -0.2,0.1 -0.4,0.2 -0.6,0.5 -0.3,0.4 -0.4,0.9 -0.3,1.4 0.1,0.5 0.3,0.8 0.5,1.2 0.5,0.7 1.2,1.2 1.9,1.7 0.7,0.5 1.4,1 1.9,1.5 0.5,0.5 0.7,0.9 0.6,1.2 -0,0.1 -0,0.2 -0.2,0.3 -0.2,0.2 -0.6,0.3 -1,0.5 -0.9,0.3 -2.2,0.5 -3.5,0.7 -1.3,0.2 -2.7,0.3 -3.7,0.5 -0.5,0.1 -1,0.2 -1.4,0.4 -0.2,0.1 -0.4,0.2 -0.6,0.3 -0.2,0.2 -0.4,0.4 -0.4,0.7 -0.1,0.9 0.3,1.7 1,2.3 0.7,0.6 1.5,1.1 2.6,1.6 2.1,0.9 4.9,1.7 7.9,2.4 2.9,0.7 5.9,1.2 8.3,1.7 2.4,0.4 4.4,0.8 4.8,0.9 2,0.6 3.3,1.8 4.9,3.2 1.5,1.3 3.2,2.8 5.8,3.5 3,0.8 6.2,-0.6 9.4,-2 3.2,-1.4 6.4,-2.8 9.1,-2.5 0.1,0 1,0.2 1.9,0.5 1,0.3 2.2,0.6 3.4,0.8 1.2,0.3 2.4,0.5 3.5,0.6 1.1,0.1 2,0.2 2.7,-0.5 0.8,-0.7 1.3,-1.4 1.4,-2.1 0.2,-0.8 -0,-1.5 -0.4,-2.2 -0.8,-1.3 -2.2,-2.3 -3.9,-3.2 -1.6,-0.9 -3.5,-1.8 -5,-2.6 -1.5,-0.8 -2.7,-1.6 -3,-1.9 -0.2,-0.3 -0.2,-0.2 -0.1,-0.4 0.1,-0.1 0.3,-0.4 0.7,-0.7 0.8,-0.5 2.2,-1 3.2,-1.5 0.5,-0.3 1,-0.5 1.3,-1 0.2,-0.3 0.3,-0.7 0.2,-1 -0.1,-0.4 -0.3,-0.6 -0.6,-0.8 -0.5,-0.4 -1.2,-0.7 -2.3,-1.1 -1.1,-0.3 -2.6,-0.7 -4.6,-1.1 l -0.3,1.3 0,-35.4 0,-0.6 -0.1,0 c -0.2,-0.6 -0.7,-1.1 -1.4,-1.5 -0.9,-0.5 -2.1,-1 -3.5,-1.3 -2.9,-0.7 -6.8,-1.2 -11.2,-1.2 z m 0,1.2 c 4.3,-1.1e-5 8.1,0.4 10.9,1.1 1.4,0.4 2.5,0.8 3.2,1.2 0.3,0.2 0.4,0.3 0.6,0.5 0.1,0.1 0.2,0.2 0.3,0.3 0,0 0,0 0,0.1 0,0 0,0.1 0,0.1 0,0 0,0.1 0,0.1 0,0 -0,0.1 -0,0.1 -0,0 -0,0 -0,0 -0,0 -0,0 -0,0.1 -0,0 -0,0 -0,0.1 -0,0 -0,0 -0,0.1 -0,0 -0,0.1 -0.1,0.1 -0,0.1 -0.1,0.1 -0.1,0.2 -0,0 -0,0 -0,0 -0.1,0.1 -0.3,0.3 -0.6,0.5 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.2 -10.9,1.2 -4.3,1.1e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.3,-0.2 -0.5,-0.3 -0.6,-0.5 -0,-0 -0.1,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0 -0,-0 -0,-0 -0,-0 -0,-0.1 -0.1,-0.1 -0,-0.1 -0.1,-0.1 -0.1,-0.2 0,-0 0,-0.1 0,-0.1 0.1,-0.2 0.3,-0.6 0.9,-0.9 0.7,-0.4 1.8,-0.8 3.2,-1.2 2.8,-0.7 6.6,-1.1 10.9,-1.1 z m 15,5.3 0,34.1 0,0 0,5.6 c 0.1,0.2 0.2,0.3 0.2,0.4 0,0.2 -0.2,0.6 -0.9,1.1 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.1 -10.9,1.1 -4.3,1e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.6,-0.4 -0.9,-0.7 -0.9,-1 l -0,0 0,-0.1 0,-1.9 c -0.1,0.1 -0.1,0.1 -0.2,0.1 l 0,-38.4 c 0.1,0.1 0.2,0.1 0.3,0.2 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1.2e-5 8.3,-0.5 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.1,-0.1 0.2,-0.1 0.3,-0.2 z m -15.2,6.1 -14.6,14.2 14.2,13.8 0.8,0 14.2,-13.8 -14.6,-14.3 z m -1.8,2.4 0,11.6 -3.1,0 0.1,-8.7 3,-2.9 z m 3.6,0 c 0.4,0.3 3,2.7 3,3 l 0,8.5 -3,0 0,-11.6 z m -9.7,6 0,5.6 -2.5,0 0,-3.1 c 0,-0.3 2.2,-2.3 2.5,-2.5 z m 15.8,0 2.6,2.5 c -0.1,0.3 -0.1,-0.1 -0.1,0.3 l 0,2.8 -2.5,0 0,-5.6 z m -21.7,6 27.5,0 -13.8,13.3 -13.7,-13.3 z m -12.8,9.3 c 1.1,-0 2.5,0 3.9,0.1 1.4,0.1 2.9,0.2 4.2,0.3 1.1,0.1 1.9,0.1 2.6,-0 l 0,10 0,0.6 0.3,0 c 0.2,0.6 0.7,1.1 1.4,1.5 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1e-5 8.3,-0.4 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.9,-0.5 1.5,-1.2 1.5,-2.1 0,-0.3 -0.1,-0.5 -0.2,-0.8 l 0,-5.6 c 1.9,0.4 3.4,0.8 4.4,1.1 0.9,0.3 1.3,0.5 1.6,0.7 -0.1,0.1 -0.1,0.1 -0.4,0.3 -0.8,0.4 -2.2,0.9 -3.3,1.6 -0.5,0.3 -1,0.7 -1.3,1.3 -0.3,0.6 -0.2,1.4 0.2,2 0.7,1 2,1.6 3.5,2.4 1.6,0.8 3.4,1.6 4.9,2.5 1.5,0.9 2.8,1.9 3.3,2.7 0.2,0.4 0.3,0.7 0.2,1 -0.1,0.3 -0.3,0.8 -0.9,1.3 0,-0 -0.6,0.2 -1.5,0.1 -0.9,-0.1 -2.1,-0.3 -3.3,-0.6 -1.2,-0.3 -2.4,-0.6 -3.3,-0.8 -1,-0.3 -1.7,-0.5 -2.2,-0.5 -3.3,-0.3 -6.7,1.3 -9.9,2.7 -3.2,1.4 -6.1,2.5 -8.4,1.9 -2.3,-0.6 -3.7,-1.8 -5.2,-3.2 -1.5,-1.3 -3.1,-2.8 -5.5,-3.5 -0.8,-0.2 -2.5,-0.5 -5,-0.9 -2.4,-0.4 -5.4,-1 -8.3,-1.6 -2.9,-0.7 -5.6,-1.5 -7.6,-2.3 -1,-0.4 -1.7,-0.9 -2.2,-1.3 -0.3,-0.3 -0.4,-0.5 -0.5,-0.7 0.2,-0.1 0.6,-0.2 1.1,-0.3 1,-0.2 2.3,-0.3 3.6,-0.5 1.4,-0.2 2.7,-0.4 3.9,-0.8 0.6,-0.2 1.1,-0.4 1.5,-0.8 0.4,-0.3 0.8,-0.8 0.8,-1.4 0.1,-1 -0.4,-1.8 -1.1,-2.5 -0.6,-0.7 -1.4,-1.2 -2.1,-1.7 -0.7,-0.5 -1.3,-1 -1.6,-1.4 -0.1,-0.2 -0.2,-0.3 -0.2,-0.4 -0,-0.1 0,-0.1 0.1,-0.2 0,-0 0.1,-0 0.1,-0 0.3,-0 0.7,-0.1 1.2,-0.1 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 85.8,104.4 13.7,13.3 13.8,-13.3 z m 21.7,-0.4 h 2.5 v -2.8 c 0,-0.5 -0,-0.1 0.1,-0.4 l -2.7,-2.4 v 5.6 z m -6.1,0 h 3.1 v -8.5 c 0,-0.3 -2.7,-2.8 -3.1,-3.1 v 11.6 z m -6.6,-8.7 -0.1,8.7 3.1,0 -0,-11.6 z m -5.7,5.6 v 3.1 h 2.5 v -5.6 c -0.3,0.2 -2.5,2.2 -2.5,2.5 z M 99.8,85.4 c -4.3,1.2e-5 -8.1,-0.4 -10.9,-1.1 -1.4,-0.4 -2.5,-0.8 -3.2,-1.2 -0.7,-0.4 -0.9,-0.8 -0.9,-1 0,-0.2 0.2,-0.6 0.9,-1 0.7,-0.4 1.8,-0.8 3.2,-1.2 2.8,-0.7 6.6,-1.2 10.9,-1.2 4.3,-1.1e-5 8.1,0.4 10.9,1.1 1.4,0.4 2.5,0.8 3.2,1.2 0.7,0.4 0.9,0.8 0.9,1 0,0.2 -0.2,0.6 -0.9,1 -0.7,0.4 -1.8,0.8 -3.2,1.2 -2.8,0.7 -6.6,1.2 -10.9,1.2 z m -15,-1.5 0,38.4 c 0.1,-0.1 0.1,-0.1 0.2,-0.1 l 0,1.8 0,0.1 0,0 c 0,0.2 0.3,0.6 0.9,0.9 0.7,0.4 1.8,0.9 3.2,1.2 2.8,0.7 6.6,1.2 10.9,1.2 4.3,-1e-5 8.2,-0.5 10.9,-1.2 1.4,-0.4 2.4,-0.8 3.2,-1.2 0.7,-0.4 0.9,-0.8 0.9,-1 0,-0.1 -0,-0.2 -0.2,-0.4 l 0,-5.6 -0,0 0,-34.1 c -0.1,0.1 -0.2,0.1 -0.3,0.2 -0.9,0.5 -2.1,1 -3.5,1.3 -2.9,0.7 -6.8,1.2 -11.2,1.2 -4.3,1.1e-5 -8.3,-0.4 -11.2,-1.2 -1.4,-0.4 -2.6,-0.8 -3.5,-1.3 -0.1,-0.1 -0.2,-0.1 -0.3,-0.2 z m 14.8,6.1 14.6,14.3 -14.2,13.8 -0.8,0 L 85,104.2 99.6,90 z m -26.7,23.7 c 1.1,-0 2.5,0 3.9,0.1 1.4,0.1 2.9,0.2 4.2,0.3 1.1,0.1 1.9,0.1 2.6,-0 l 0,10 0,0.6 0.3,0 c 0.2,0.6 0.7,1.1 1.4,1.5 0.9,0.5 2.1,1 3.5,1.3 2.9,0.7 6.8,1.2 11.2,1.2 4.3,-1e-5 8.3,-0.4 11.2,-1.2 1.4,-0.4 2.6,-0.8 3.5,-1.3 0.9,-0.5 1.5,-1.2 1.5,-2.1 0,-0.3 -0.1,-0.5 -0.2,-0.8 l 0,-5.6 c 1.9,0.4 3.4,0.8 4.4,1.1 0.9,0.3 1.3,0.5 1.6,0.7 -0.1,0.1 -0.1,0.1 -0.4,0.3 -0.8,0.4 -2.2,0.9 -3.3,1.6 -0.5,0.3 -1,0.7 -1.3,1.3 -0.3,0.6 -0.2,1.4 0.2,2 0.7,1 2,1.6 3.5,2.4 1.6,0.8 3.4,1.6 4.9,2.5 1.5,0.9 2.8,1.9 3.3,2.7 0.2,0.4 0.3,0.7 0.2,1 -0.1,0.3 -0.3,0.8 -0.9,1.3 0,-0 -0.6,0.2 -1.5,0.1 -0.9,-0.1 -2.1,-0.3 -3.3,-0.6 -1.2,-0.3 -2.4,-0.6 -3.3,-0.8 -1,-0.3 -1.7,-0.5 -2.2,-0.5 -3.3,-0.3 -6.7,1.3 -9.9,2.7 -3.2,1.4 -6.1,2.5 -8.4,1.9 -2.3,-0.6 -3.7,-1.8 -5.2,-3.2 -1.5,-1.3 -3.1,-2.8 -5.5,-3.5 -0.8,-0.2 -2.5,-0.5 -5,-0.9 -2.4,-0.4 -5.4,-1 -8.3,-1.6 -2.9,-0.7 -5.6,-1.5 -7.6,-2.3 -1,-0.4 -1.7,-0.9 -2.2,-1.3 -0.3,-0.3 -0.4,-0.5 -0.5,-0.7 0.2,-0.1 0.6,-0.2 1.1,-0.3 1,-0.2 2.3,-0.3 3.6,-0.5 1.4,-0.2 2.7,-0.4 3.9,-0.8 0.6,-0.2 1.1,-0.4 1.5,-0.8 0.4,-0.3 0.8,-0.8 0.8,-1.4 0.1,-1 -0.4,-1.8 -1.1,-2.5 -0.6,-0.7 -1.4,-1.2 -2.1,-1.7 -0.7,-0.5 -1.3,-1 -1.6,-1.4 -0.1,-0.2 -0.2,-0.3 -0.2,-0.4 -0,-0.1 0,-0.1 0.1,-0.2 0,-0 0.1,-0 0.1,-0 0.3,-0 0.7,-0.1 1.2,-0.1 z"}],o["GR.IN.IC.COLLEGE/UNIVERSITY"]=[{type:"path",stroke:!1,d:"m 97.4,106.9 h -14.8 v 31.7 h 32 v -31.7 H 99.8 V 95.1 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 h -2.3 v 24.5 z m 23.3,-30.1 -9.6,0 0,-15.1 2,0 0,13.3 7.6,0 0,1.8 M 106,63.5 c 0.6,0.7 1.1,1.5 1.4,2.5 0.3,1 0.5,2.1 0.5,3.3 -1e-5,1.2 -0.2,2.4 -0.5,3.4 -0.3,1 -0.8,1.8 -1.4,2.5 -0.6,0.7 -1.4,1.2 -2.2,1.5 -0.8,0.3 -1.8,0.5 -2.9,0.5 -1.1,0 -2,-0.2 -2.9,-0.5 -0.9,-0.4 -1.6,-0.9 -2.2,-1.5 -0.6,-0.7 -1.1,-1.5 -1.4,-2.5 -0.3,-1 -0.5,-2.1 -0.5,-3.3 -10e-7,-1.2 0.2,-2.3 0.5,-3.3 0.3,-1 0.8,-1.8 1.4,-2.5 0.6,-0.7 1.3,-1.2 2.2,-1.5 0.9,-0.4 1.9,-0.5 2.9,-0.5 1.1,1.5e-5 2.1,0.2 2.9,0.5 0.9,0.4 1.6,0.9 2.2,1.5 m -0.2,5.8 c -2e-5,-2 -0.4,-3.5 -1.3,-4.5 -0.9,-1.1 -2.1,-1.6 -3.6,-1.6 -1.5,1.4e-5 -2.7,0.5 -3.6,1.6 -0.9,1.1 -1.3,2.6 -1.3,4.5 -3e-6,2 0.4,3.5 1.3,4.6 0.9,1 2.1,1.6 3.6,1.6 1.5,2e-6 2.7,-0.5 3.6,-1.6 0.9,-1.1 1.3,-2.6 1.3,-4.6 m -14,6.5 c -0.4,0.2 -0.7,0.3 -1,0.5 -0.3,0.1 -0.7,0.3 -1.2,0.4 -0.4,0.1 -0.9,0.2 -1.4,0.3 -0.5,0.1 -1,0.1 -1.6,0.1 -1.1,0 -2.1,-0.2 -3,-0.5 -0.9,-0.3 -1.7,-0.8 -2.3,-1.5 -0.7,-0.6 -1.2,-1.5 -1.5,-2.4 -0.4,-1 -0.5,-2.1 -0.5,-3.5 -10e-7,-1.2 0.2,-2.4 0.5,-3.3 0.4,-1 0.9,-1.8 1.5,-2.5 0.6,-0.7 1.4,-1.2 2.3,-1.5 0.9,-0.3 1.9,-0.5 3,-0.5 0.8,1.5e-5 1.6,0.1 2.4,0.3 0.8,0.2 1.7,0.5 2.7,1 l 0,2.4 -0.2,0 c -0.8,-0.7 -1.7,-1.2 -2.5,-1.5 -0.8,-0.3 -1.7,-0.5 -2.6,-0.5 -0.8,1.4e-5 -1.5,0.1 -2.1,0.4 -0.6,0.2 -1.2,0.6 -1.6,1.1 -0.5,0.5 -0.8,1.2 -1.1,1.9 -0.3,0.8 -0.4,1.7 -0.4,2.7 -3e-6,1.1 0.1,2 0.4,2.7 0.3,0.8 0.7,1.4 1.1,1.9 0.5,0.5 1,0.9 1.7,1.1 0.6,0.2 1.3,0.4 2,0.4 1,2e-6 1.9,-0.2 2.7,-0.5 0.8,-0.3 1.6,-0.8 2.4,-1.5 l 0.1,0 0,2.4"}],o["GR.IN.IC.SCHOOL"]=[{type:"path",stroke:!1,d:"M 98.4,96.4 H 83.7 v 31.7 h 32 V 96.4 H 100.9 V 84.6 c 0,-0.6 6.5,-3 7.5,-3.4 1.3,-0.5 6.9,-3 7.9,-3 -0.3,-0.4 -14.7,-6.3 -15.7,-6.3 H 98.4 V 96.4 z"}],o["GR.IN.IC.REST STOP"]=[{type:"path",stroke:!1,d:"m 108.4,89.6 v -0.4 l 0.6,-0.6 -0.4,1.4 -3.8,13.4 -0.2,0.8 -0.4,0.6 0,0.9 -2,6.7 7.2,0 v 19.7 h 5.2 v -19.7 h 2.7 v 19.7 h 5.2 v -19.7 h 7.1 l -1.3,-5.3 -0.2,-0.8 -4.8,-16.4 -0.5,-1.4 0.6,0.7 0.1,0.4 c 2.1,2.4 5.4,14.2 8.6,14.2 h 0.4 c 1.2,0 2.1,-1.1 2.1,-2.3 v -0.6 c 0,-0.5 -4.8,-10 -5.3,-11.6 -0.7,-2 -1.7,-4.2 -2.6,-6 -1,-2.1 -1.2,-3.8 -4.6,-3.8 h -12.4 c -3.4,0 -3.6,1.8 -4.7,3.9 -0.9,1.7 -1.9,4 -2.5,5.9 -0.6,1.6 -5.2,11.1 -5.2,11.6 v 0.6 c 0,1.3 0.6,2.3 1.9,2.3 h 0.8 c 2.4,0 6.4,-12.2 8.2,-14.2 z m 0.2,0.4 0.4,-1.5 -0.6,0.6 0,0.4 z m 15.1,-0.4 -0.1,-0.4 -0.6,-0.6 0.5,1.4 z M 69.6,88.8 h 2.3 v 43.6 h 6.1 v -25.6 h 2.7 v 25.6 h 5.9 v -43.6 h 2.3 v 16.4 h 4.6 V 86.3 l -0.3,-2.3 h -0.4 c 0,-2.3 -1.7,-4.4 -4,-4.4 H 69.6 c -3,0 -4.4,3.4 -4.4,6.5 v 19.1 h 4.4 V 88.8 z M 110.7,72.8 c 0,2.7 2.4,5.4 5,5.4 h 0.2 c 1.6,0 2.8,-0.6 3.6,-1.4 0.5,-0.4 1.8,-2.4 1.8,-3 v -1.6 c 0,-2.4 -2.8,-4.6 -5.4,-4.6 -3,-0 -5.2,2.4 -5.2,5.2 z m -36.7,1.1 c 0,2 2.8,4.4 5,4.4 h 0.2 c 4.2,0 4.3,-3.4 5.2,-3.8 V 71.6 c 0,-1.8 -2.8,-4 -5.2,-4 -2.3,0 -5.2,2.2 -5.2,4 v 2.3 z"}],o["GR.IN.IC.CONTROL VALVE"]=[{type:"path",stroke:!1,d:"m 114,114.5 h 15.7 v 4 h 9.1 v -23.6 h -9.1 V 98.8 H 114.4 c -0.4,0 -2.6,-2.6 -2.6,-3.4 v -5.6 h -9.9 v -8.2 h 12.3 v -3.6 h -28.2 v 3.6 h 12.1 v 8.3 H 89.2 v 6.6 l -0.2,-0.2 -1.8,2.4 -17.2,0.1 V 95 H 61.2 v 23.6 h 8.9 v -4 H 87 c 0.4,0 2,2.4 2.4,2.8 0.5,0.6 2.2,1.9 2.9,2.4 1.9,1.2 4.7,2.4 7.8,2.4 h 0.6 c 3.5,0 5.8,-1 8.1,-2.4 1.4,-0.8 4.8,-3.8 5.2,-5.3 z"}],o["GR.IN.IC.DAM"]=[{type:"path",stroke:!1,d:"m 68.3,89.1 c 2.3,0 3.2,-1.7 4.6,-2.6 1.1,0.8 2.2,2.6 4.4,2.6 h 0.2 c 2.6,0 3.3,-1.7 4.7,-2.6 1.4,0.9 2.2,2.6 4.7,2.6 2.4,0 3.3,-1.8 4.6,-2.6 0.6,0.4 1.1,1.1 1.9,1.6 0.4,0.2 2.2,0.9 2.2,1.3 v 6.8 C 94.1,95.8 91.8,93.8 91.5,92.6 h -0.3 c -0.3,1.1 -3,3.6 -4.5,3.6 -1.5,0 -4.1,-2.6 -4.4,-3.8 -1,0.6 -2.6,3.8 -4.6,3.8 h -0.4 c -1.2,0 -4,-2.7 -4.2,-3.7 -0.8,0.2 -2.6,3.7 -4.7,3.7 h -0.3 c -1.1,0 -1.7,-0.7 -2.4,-1.2 l -1,1.2 c 1,0.7 1.6,1.8 3.2,1.8 h 0.4 c 2.3,0 3.1,-1.8 4.6,-2.8 0.7,1.1 2.8,2.8 4.7,2.8 2.3,0 3.3,-2 4.6,-2.8 1.2,0.8 2.6,2.8 4.7,2.8 2.1,0 3.4,-2.1 4.7,-2.8 0.7,1 2.6,2.4 4,2.7 v 7 c -1.4,-0.1 -3.4,-2.4 -4,-3.5 -1.1,0.7 -2.5,3.6 -4.7,3.6 h -0.1 c -2.3,0 -4.1,-3.5 -4.7,-3.7 -0.3,1 -3,3.7 -4.1,3.7 h -0.4 c -2.2,0 -3.6,-2.9 -4.7,-3.7 -0.6,1 -2.8,3.7 -4.1,3.7 H 67.7 c -0.7,0 -1.7,-1 -2.2,-1.3 l -0.9,1.5 c 1.1,0.7 1.7,1.6 3.6,1.6 2.7,0 3.1,-1.8 4.7,-2.6 1.4,0.9 2,2.6 4.7,2.6 2.2,0 3.4,-1.8 4.6,-2.6 1.4,1 2.5,2.6 4.8,2.6 1.8,0 3.4,-2 4.4,-2.6 0.9,0.5 1,1 2,1.6 0.4,0.3 2.2,0.7 2.2,1.2 v 6.8 c -1.4,-0.3 -3.6,-2.2 -4,-3.5 -1.1,0.7 -2.5,3.8 -4.8,3.8 -1.4,0 -4.1,-2.6 -4.4,-3.8 -1.2,0.8 -2.6,3.8 -4.8,3.8 -2,0 -3.7,-3.2 -4.7,-3.8 -0.3,1 -3,3.8 -4.3,3.8 h -0.6 c -0.8,0 -1.8,-1 -2.4,-1.3 l -0.9,1.3 c 1.1,0.7 1.8,1.8 3.6,1.8 2.2,0 3.3,-1.8 4.7,-2.8 1.2,0.8 2.6,2.9 4.7,2.8 2.3,-0.1 3.3,-1.9 4.6,-2.8 1.2,0.8 2.7,2.8 4.7,2.8 1.9,0 3.4,-2 4.6,-2.8 1.6,1 1.8,2 4.1,2.5 v 5 h 17 l -1.4,-5.2 c 0.8,0.2 1,0.6 2.2,0.6 2,0 3.3,-1.9 4.6,-2.8 1.3,0.9 2.4,2.8 4.7,2.8 1.6,0 3.8,-1.8 4.4,-2.8 1.3,0.3 2.5,2.8 5.1,2.8 1.2,0 2.6,-1.4 3.4,-1.8 l -1,-1.3 c -0.7,0.4 -1.5,1.3 -2.6,1.3 -2.1,0 -3.7,-3.1 -4.7,-3.8 -0.7,1.4 -2.7,3.8 -4.7,3.8 -1.3,0 -4.3,-2.6 -4.4,-3.8 -1,0.7 -2.6,3.8 -4.7,3.8 h -0.2 c -1.1,0 -2.2,-0.9 -2.7,-1.5 -0.4,-0.4 -0.8,-2.5 -1.1,-3.2 -0.4,-1 -1.8,-5.6 -1.8,-6.6 l -0.3,-0.4 0,-0.6 -0.3,-0.4 v -0.6 l -0.3,-0.4 -5.3,-18.6 0.2,-0 -0.3,-0.4 0,-0.6 c -0.2,-0.3 -0.3,-0.3 -0.3,-0.6 v -0.4 h -5.6 v 7.8 c -1.4,-0.7 -1.2,-0.5 -2.4,-1.6 -0.1,-0.1 -1,-0.9 -1,-1 -0.4,-0.5 -0.1,-0.9 -0.8,-1.1 -0.1,1.2 -3.1,3.8 -4.3,3.8 h -0.2 c -2.5,0 -4.2,-3.6 -4.8,-3.8 -0.3,1.1 -3,3.8 -4.2,3.8 h -0.4 c -1.2,0 -4.2,-2.7 -4.2,-3.8 -0.5,0.1 -2.8,3.8 -4.4,3.8 H 67.7 c -0.7,0 -1.7,-1 -2.2,-1.3 l -0.9,1.3 c 1,0.7 1.6,1.6 3.4,1.6 h 0.3 v 0 z"}],o["GR.IN.IC.DISCHARGE OUTFALL"]=[{type:"path",stroke:!1,d:"m 63.2,111.4 v 13.4 h 73.6 V 111.7 l -3.1,0.5 -1.1,-0.1 c -2.2,0 -3.6,-0.7 -4.9,-1.6 -0.6,-0.4 -1.1,-1.1 -1.5,-1.8 -0.4,-0.6 -0.2,-2.1 -1,-2.1 h -0.4 c -0.8,0 -0.7,1.6 -1.2,2.2 -0.4,0.6 -0.9,1.2 -1.6,1.7 -1.3,1 -3,1.6 -5.1,1.6 h -0.9 c -3.2,0 -6.8,-2.1 -6.8,-5.1 -0.3,-0.2 -0.4,-0.4 -0.8,-0.4 h -0.3 c -0.7,0 -0.8,1.5 -1.1,2.1 -0.4,0.6 -1,1.4 -1.5,1.8 -1.2,1 -2.7,1.6 -4.8,1.6 h -0.9 c -3.5,0 -7.3,-2.1 -7.3,-5.4 -0.4,-0.1 -0.4,-0.2 -0.8,-0.2 h -0.3 c -0.6,0 -0.6,1.5 -1.1,2.2 -0.5,0.8 -0.7,1.1 -1.5,1.7 -1.3,1 -2.7,1.6 -4.8,1.6 H 82.9 c -3.5,0 -6.7,-2.2 -7,-5.4 -0.3,-0.1 -0.4,-0.2 -0.8,-0.2 h -0.1 c -0.7,0 -0.8,1.5 -1.2,2.2 -0.4,0.6 -0.9,1.2 -1.6,1.7 -1.4,1 -2.7,1.6 -5,1.6 h -1 c -1.2,0 -2.2,-0.4 -3,-0.8 l 0,0 z m 0,-21.6 19.5,0 0,1.2 2.7,0 0,-15.8 -2.7,0 0,1.2 -19.5,0 z M 89.7,80.9 v 0.1 c 8.1,0 16.2,1.2 20.6,4.9 2.8,2.4 3.1,4.5 3.1,9.6 0,4.1 0.5,8.3 4.5,8.3 h 0.8 c 1.7,0 2.8,-2.6 2.8,-4.3 v -0.9 c 0,-5.1 -3.3,-10.7 -5.9,-13.3 -1.6,-1.6 -3.6,-3 -6.1,-3.6 -2.2,-0.5 -6,-1.1 -8.6,-1.1 l -1.8,-0.1 -9.4,0.4 z"}],o["GR.IN.IC.GROUND WATER WELL"]=[{type:"path",stroke:!1,d:"M86,64L86,70L75,110L81,110L92,70L99,70L99,130L86,130L86,140L120,140L120,130L110,130L110,89L120,89L120,93L130,93L130,87C130,82.631 125.551,83 125.551,83L110,83L110,70L113.774,70L113.774,64L86,64Z"}],o["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 109.7,116.6 4.1,13.4 -0.2,0.1 -12.2,-8.4 8.3,-5.2 z m -19.7,0 8,5.1 -12.1,8.4 4.1,-13.6 z m 9.8,-9.8 8.8,8.2 c -1.7,0.5 -8.1,5.6 -8.8,5.6 -0.2,0 -8.2,-5.4 -8.6,-5.8 l 8.5,-8.1 z m 5.3,-4.8 3.1,9.8 -6.9,-6.4 3.7,-3.4 z m -10.5,0.1 3.8,3.3 -6.9,6.4 3.1,-9.7 z m 2.1,-1 6.4,-0 -3.2,3.2 -3.2,-3.2 z M 99.2,84.8 C 99.1,85.4 99,85.5 99,86.1 v 2 h -3 c -0.5,0 -0.8,0.3 -0.8,0.8 0,0.5 0.1,0.5 0.2,1 0.4,0.1 0.4,0.2 1,0.2 h 2.6 v 2.8 h -4.5 c -0.6,0 -1.2,0.2 -1.2,0.8 0,0.5 0.3,0.8 0.8,0.8 h 4.9 v 4.9 h -4.5 c -0.5,0 -0.5,0.1 -0.9,0.2 l -2.5,7.9 -1,3.2 -4.1,13.3 -1.1,3.1 c 0,2 -1.4,3.5 -1.4,5.5 0,0.4 0.1,0.2 0.2,0.8 h 0.5 c 0.6,0 15.1,-10.3 15.4,-10.3 0.6,0 14.2,9.4 15.8,10.5 0.4,-0.2 1,-0.4 1,-1 v -0.6 c 0,-0 -1.5,-4.4 -1.7,-5 -0.4,-1.1 -1.4,-4.3 -1.5,-5.2 l -1,-3.2 -4.1,-13.2 -0.9,-3.4 c -1,-0.4 -0.3,-2.6 -1.6,-2.6 h -4.8 v -5 h 4.8 c 0.5,0 0.8,-0.3 0.8,-0.8 0,-0.5 -0.3,-0.8 -0.8,-0.8 H 100.8 V 90.1 h 2.4 c 0.7,0 1.4,-0.4 1.4,-1 v -0.2 c 0,-0.5 -0.3,-0.8 -0.8,-0.8 h -2.9 v -2.6 c 0,-0.4 -0.6,-1 -0.8,-1 -0,-0 -0.7,0.1 -0.8,0.2 z m 6.7,-15.7 c 7,1.6 10.9,4.6 15.1,8.9 3,3 7.3,11 7.3,16.9 v 4 c 0,2.1 -1.5,7.7 -2.2,9 -0.7,1.1 -1.2,2.4 -1.9,3.6 -0.3,0.4 -2.4,3.3 -2.4,3.4 0,0.7 1,1.6 1.2,2.6 1.7,-0.4 4.8,-6.3 5.7,-8.2 1.2,-2.5 2.7,-7.8 2.7,-11.4 V 94.3 c 0,-0.1 -0.9,-4.9 -1,-5.5 -0.3,-0.9 -1.4,-3.7 -1.8,-4.8 -0.9,-2.2 -3.7,-6.4 -5.2,-8 -3.6,-3.6 -10.6,-9.2 -16.9,-9.7 l -0.4,2.8 z m -1.6,10.7 c 6,0.5 13.3,9.2 13.3,16.1 v 2.2 c 0,1.5 -1.4,5.5 -1.4,5.5 0,0.2 1.2,2.9 1.4,3.2 l 0.2,0.1 1.6,-3.4 0.1,-0.6 0.7,-5.9 0.2,-0.4 -1,-5.9 c -0.7,-0.3 -0.6,-1.4 -1.1,-2.2 -0.4,-0.8 -0.8,-1.6 -1.3,-2.3 -1.1,-1.6 -1.8,-2.6 -3.2,-3.9 -2.2,-2.2 -5.8,-4.2 -9.2,-5 l -0.3,2.8 z M 68.7,95.2 v 5.1 c 0,4.2 5.4,16.3 7.9,17 0.1,-0.5 1,-2.2 1,-2.6 0,0 -2.1,-2.9 -2.3,-3.4 -0.7,-1.3 -1.3,-2.4 -1.9,-3.8 -1,-2.6 -1.8,-6 -1.8,-9.6 v -2.4 c 0,-8 3.3,-12.9 6.9,-17.5 1.4,-1.8 4.7,-4.4 6.7,-5.6 1.4,-0.8 2.5,-1.4 4.1,-2.1 0.5,-0.2 4.5,-1.3 4.5,-1.6 l -0.2,-2.6 c -2.4,0.1 -8,2.6 -9.6,3.7 -3.2,1.9 -4.8,3.6 -7.3,6.1 -3.6,3.6 -7.8,12 -7.8,19.1 l 0,0 z m 10.7,0 v 2.9 c 0,1.9 0.2,3.1 0.8,4.5 0.2,0.4 1.5,4 1.5,4 l 0.4,-0 1.5,-2.9 c -0.9,-1.2 -1.4,-4 -1.4,-6.2 v -1.8 c 0,-3.7 2.3,-8.3 4.2,-10.3 1.8,-1.8 5.9,-5.5 9.1,-5.6 L 95,77.1 C 88,77.6 79.4,87.3 79.4,95.2 z"}],o["GR.IN.IC.TELECOMMUNICATIONS TOWER"]=[{type:"path",stroke:!1,d:"m 102.5,119.2 12,-8 2.8,9.2 1.3,4 2.1,6.9 -18.2,-12 z m -23,12 3.4,-11.7 2,-5.9 0.8,-2.6 11.9,8.2 -18,12 z m 20.4,-34.6 13,12.2 c -1.5,1 -12.3,8.5 -13.1,8.5 -0.1,0 -11.6,-7.7 -12.7,-8.5 L 99.9,96.6 z m 7.7,-7.1 0.2,0.2 1.8,5.7 2.5,8.7 -10.1,-9.3 5.6,-5.2 0,0 z m -15.5,0.6 v -0.6 l 0.4,0.2 5.4,5 -10,9.4 2.6,-9 1.6,-5 z m 2.9,-1.7 9.8,-0 -5,4.4 -4.8,-4.4 z m 3.6,-23.1 v 3.6 h -4.4 c -0.5,0 -1,0.6 -1,1 v 0.6 c 0,0.7 0.8,1 1.5,1 h 4 v 4.2 h -7.2 c -0.5,0 -1,0.6 -1,1 v 0.2 c 0,1 0.5,1.5 1.5,1.5 h 6.8 v 7 h -6.8 c -0.8,0 -1,0.3 -1.3,0.7 l -0.6,2 -4.9,15.6 -3,9.6 -3.1,9.4 -0.1,0.8 -2.9,8.7 -0.1,0.8 -0.5,2.2 c 1,0.2 0.5,0.6 1.3,0.6 h 0.2 c 0.8,0 20.1,-13.7 23.1,-15.2 2.5,1.7 22.4,15.2 23.5,15.2 0.6,0 1,-0.7 1,-1.3 0,-0.1 -1.4,-4 -1.5,-4.2 l -0.1,-0.8 -3.1,-9.7 -2.9,-9.3 -4.7,-15.7 c -0.6,-0.8 -1.4,-3.8 -1.8,-5 -0.6,-1.8 -0.5,-4.3 -2.5,-4.3 h -6.8 v -7 h 7.2 c 0.5,0 1,-0.6 1,-1 v -0.4 c 0,-0.6 -0.2,-1.3 -0.8,-1.3 h -7.4 v -4.2 h 4 c 0.7,0 1.5,-0.4 1.5,-1 v -0.6 c 0,-0.7 -0.8,-1 -1.5,-1 h -4 v -4 c 0,-0.6 -0.7,-1 -1.3,-1 -0.8,-0 -1.3,0.6 -1.3,1.4 l 0,0 z m -6.6,24.8 0.4,-0.4 -0.4,-0.2 z"}],o["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]=a("ATC"),o["GR.IN.IC.PROPANE FACILITY"]=[{type:"path",stroke:!1,d:"m 98.7,73.1 v 0.2 c 0,1 0.5,1.5 1.5,1.5 0.5,0 1.1,-0.6 1.1,-1.1 0,-0.8 -0.2,-0.8 -0.2,-1.5 -0.5,-0.1 -0.5,-0.2 -1.1,-0.2 h -0.2 c -0.5,0 -1.1,0.6 -1.1,1.1 z m -12.6,58.5 h 28.4 v 3.3 h -28.4 v -3.3 z M 75.8,119 h 48.5 v 3.3 c 0,2 -8.8,7.8 -9.8,7.8 H 85.8 c -1,0 -10,-5.8 -10,-7.6 v -3.5 l 0,0 z m 0,-27.5 c 0,-1.1 7.2,-5.8 8.5,-6.6 2.6,-1.5 7.4,-3.7 11.4,-3.7 h 8.5 c 4.1,0 9.1,2 11.6,3.7 1.3,0.9 8.5,5.4 8.5,6.6 v 4.2 H 75.8 V 91.5 l 0,0 z M 98.2,77.1 c 0.7,0 0.8,0.2 1.5,0.2 h 0.4 c 0.8,0 0.8,-0.2 1.5,-0.2 v 1.8 l 1.2,0.8 -5.5,0 c 0.3,-0.5 0.9,-0.8 0.9,-1.3 l -0,-1.3 0,0 z m -1.1,-4 c 0,-1.4 1.4,-2.4 2.8,-2.4 1.3,0 2.8,0.9 2.8,2 v 1.1 c 0,1.4 -1.6,2.4 -3,2.4 -1,0 -2.6,-1.2 -2.6,-2.4 v -0.7 h -0 z m 12.2,-8.1 h 3.5 v 3.5 h -1.8 v 6.8 c 0.7,0 2.4,0.6 2.4,1.3 v 3.7 H 109.4 V 65.1 z m -22.7,0 h 4.2 V 80.3 H 85.8 v -4.1 c 0.8,-0.2 3.1,-0.8 3.1,-1.5 v -6.1 h -2.2 v -3.5 z m 5.7,0 h 15.5 v 15.3 c -1.6,-0.4 -4.8,-0.9 -4.8,-2.6 v -0.9 c 0,-1.5 0.9,-2.1 0.9,-2.6 v -1.1 c 0,-3.2 -3,-3.2 -3.3,-4.4 h 4.2 v -1.5 h -9.6 v 1.5 h 4.2 v 0.6 c -1.9,0.1 -3.1,1.9 -3.1,4 v 0.6 c 0,1 0.9,2 0.9,2.4 v 1.3 c 0,1.4 -3.4,2.3 -4.8,2.6 V 65.1 l 0,0 z m -7.2,4.8 h 2.2 v 4 c 0,0.8 -2.1,1.2 -2.8,1.3 v 6.8 h 3 c -0.6,0.4 -2.7,1.2 -3.6,1.8 -1.2,0.7 -2.2,1.4 -3.4,2.1 -0.9,0.6 -6.1,4.7 -6.3,4.8 v 31.6 c 0,1.9 3.2,4.4 4.5,5.3 1,0.6 5.8,3.3 5.8,4.1 v 4.8 h 31.2 v -4.8 c 0,-1.6 10,-4.6 10,-10 V 91.1 c 0,-0.9 -5,-4.4 -6,-5.1 -1.2,-0.8 -2.1,-1.4 -3.3,-2.1 -0.9,-0.6 -3.2,-1.4 -3.7,-1.9 h 2.4 v -6.8 c -0.7,-0.2 -2.6,-0.5 -2.6,-1.3 v -4 h 2 V 63.5 H 85.2 v 6.3 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 114.4,134.9 0,-3.3 -28.4,0 0,3.3 z M 75.8,122.5 c 0,1.9 9,7.6 10,7.6 h 28.6 c 1,0 9.8,-5.9 9.8,-7.8 v -3.3 H 75.8 v 3.5 l 0,0 z m 0,-31 v 4.2 h 48.5 V 91.5 c 0,-1.2 -7.2,-5.7 -8.5,-6.6 -2.5,-1.7 -7.5,-3.7 -11.6,-3.7 h -8.5 c -3.9,0 -8.8,2.2 -11.4,3.7 -1.3,0.8 -8.5,5.4 -8.5,6.6 l 0,0 z M 109.4,80.3 h 4.2 v -3.7 c 0,-0.8 -1.7,-1.2 -2.4,-1.3 v -6.8 h 1.8 V 65.1 H 109.4 V 80.3 z M 86.7,68.6 h 2.2 v 6.1 c 0,0.8 -2.3,1.4 -3,1.5 v 4.2 h 5 V 65.1 h -4.2 v 3.5 z m 11.6,9.8 c 0,0.6 -0.6,0.8 -0.9,1.3 l 5.5,-0.1 -1.1,-0.8 V 77.1 c -0.7,0 -0.8,0.2 -1.5,0.2 H 99.8 c -0.8,0 -0.8,-0.2 -1.5,-0.2 l -0,1.3 0,0 z m 2.8,-6.1 c 0.1,0.7 0.2,0.8 0.2,1.6 0,0.5 -0.6,1.1 -1.1,1.1 -1,0 -1.5,-0.5 -1.5,-1.5 v -0.2 c 0,-0.5 0.6,-1.1 1.1,-1.1 h 0.2 c 0.6,0 0.6,0.1 1.1,0.2 z m -3.9,0.9 v 0.7 c 0,1.2 1.6,2.4 2.6,2.4 1.4,0 3,-1 3,-2.4 V 72.7 c 0,-1 -1.6,-2 -2.8,-2 -1.4,0 -2.8,1 -2.8,2.4 z"}],o["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"M 100,67.3 C 90.1122,72.1037 79.3336,77.3992 70,82 c -1.2,0.6 -3.8,1.3 -3.8,2.8 l -0.1,0 0,0.4 c 0,0.6 0.1,0.6 0.2,1.1 0.5,0.1 0.5,0.2 1.1,0.2 l 65,0 c 0.7,0 1.7,-0.6 1.7,-1.1 0,-2.2 -1.7,-2.4 -3.2,-3 C 119.391,76.7575 109.17,71.7941 100,67.3 Z m -0.1,3.4 c 0.2,0 24.5,12 25.9,13 l -51.6,0 0,-0.1 C 75,83 99.7,70.7 99.9,70.7 Z m 31.6,55.6 0,-3 -63.3,0 0,3 z m 2.3,6.4 0,-3 -67.7,0 0,3 z m -6.2,-40.7 2.4,0 0,-3.2 -7.9,0 0,3.2 2.1,0 -0.6,25.5 -1.5,0 0,3.8 7.9,0 0,-3.8 -1.5,0 z m -14.6,-3.2 -7.6,0 0,3.2 2.2,0 -0.9,25.4 -1.3,0 0,3.8 7.6,0 0,-3.8 -1.4,0 -0.7,-25.5 2.1,0 z m -20.8,3.1 2.3,0 0,-3.2 -7.8,0 0,3.2 2.3,0 -0.8,25.4 -1.5,0 0,3.8 7.8,0 0,-3.8 -1.7,0 z m -22.5,25.5 0,3.8 8,0 0,-3.8 -1.5,0 -0.8,-25.5 2.3,0 0,-3.2 -8,0 0,3.2 2.4,0 -0.9,25.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 74.1,83.6 h 51.6 C 124.3,82.7 100,70.7 99.8,70.7 99.6,70.7 74.9,83 74.1,83.6 l 0,0 z"}],o["GR.IN.IC.MILITARY INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"m 65.2,93.1 c 0,-0.5 15.6,-11.5 17.3,-12.8 1.5,-1.2 17.3,-12.6 17.4,-12.6 0.6,0 15.9,11.2 17.6,12.5 1.7,1.3 17.3,12.4 17.3,12.9 0,0 -6.1,18.6 -6.7,20.3 -1.2,3.4 -2.2,6.8 -3.4,10.3 -1,3 -2.7,7.2 -3.3,10 H 78.4 c -0.1,-1.7 -5.6,-18 -6.5,-20.4 -0.6,-1.4 -6.6,-20.1 -6.6,-20.1 z m 8.4,38.5 2,6.1 49,0 8.4,-26.4 6.6,-20.5 -39.7,-28.7 -39.6,28.8 13.3,40.6 0,0 z M 100,76.2 c 2.7,2.4 26.6,18.7 26.6,19.6 0,0.8 -4.1,12.7 -4.5,13.4 l -5.6,17.4 -32.5,0 c -0.9,0 -3,-7.4 -3.5,-8.7 -0.6,-1.8 -2.9,-7.8 -2.9,-9.4 L 74.3,98.9 73.5,95.5 100,76.2 z m 30.5,18 c -3.1,-2.1 -30,-22.2 -30.7,-22.2 -0.1,0 -13.8,10.1 -15.2,11.1 -2,1.4 -14.3,10.7 -15.2,10.9 v 0.7 c 0,1 2.9,7 2.9,9.3 l 8.7,26.3 37.7,0 5,-15.7 6.6,-20.4 z m -50.4,3.2 c 0.8,-0.2 8.6,-6.1 10,-7 1.2,-0.8 9.5,-7.1 10,-7.1 0,0 9,6.5 10,7.2 1.2,0.8 9.7,6.5 9.7,7.3 0,1.2 -0.4,2 -0.9,2.7 0,1.6 -2.6,8.7 -3.3,10.6 -0.5,1.4 -2.8,10.1 -3.7,10.1 H 88.1 c -0.7,0 -1.8,-4 -2,-4.8 -0.6,-1.7 -1.2,-3.3 -1.7,-5.1 -0.6,-2.1 -3.1,-8.7 -3.1,-10.3 l -0.3,0.1 -0.9,-3.7 z m -3.2,-0.7 8.8,27 28.2,-0 8.7,-27.2 c -3.2,-1.7 -21.7,-16.3 -22.9,-16.3 -0.3,0 -20.6,15 -22.9,16.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 77,96.8 c 2.3,-1.5 22.6,-16.6 22.9,-16.6 1.2,0 19.7,14.6 22.9,16.3 l -8.7,27.2 -28.3,0 -8.8,-27 z m -3.6,-1.3 0.9,3.4 3.4,9.7 c 0,1.5 2.3,7.6 2.9,9.4 0.4,1.3 2.5,8.7 3.5,8.7 l 32.5,-0 5.5,-17.4 c 0.4,-0.6 4.5,-12.6 4.5,-13.4 0,-1 -23.9,-17.2 -26.6,-19.6 L 73.5,95.5 z m 6.7,2 0.9,3.7 0.3,-0.1 c 0,1.6 2.4,8.2 3.1,10.3 0.5,1.8 1.1,3.4 1.7,5.1 0.2,0.8 1.3,4.8 2,4.8 h 23.8 c 1,0 3.3,-8.6 3.7,-10.1 0.6,-1.9 3.3,-9 3.3,-10.6 0.5,-0.7 1,-1.5 1,-2.7 0,-0.8 -8.5,-6.5 -9.7,-7.3 -1,-0.7 -9.9,-7.2 -10,-7.2 -0.5,0 -8.8,6.2 -10,7 -1.3,1 -9.2,6.8 -10,7.1 z m 43.8,17.1 -5,15.7 -37.7,-0 -8.7,-26.3 c 0,-2.3 -2.9,-8.3 -2.9,-9.3 v -0.7 c 1,-0.2 13.2,-9.5 15.2,-10.9 1.4,-1 15.1,-11.1 15.2,-11.1 0.7,0 27.6,20 30.7,22.2 l -6.6,20.4 z M 65.2,93.1 c 0,0 6,18.7 6.6,20.1 1,2.4 6.4,18.7 6.5,20.4 h 43.1 c 0.6,-2.8 2.3,-7 3.3,-10 1.2,-3.5 2.1,-6.8 3.4,-10.3 0.6,-1.7 6.7,-20.2 6.7,-20.3 0,-0.5 -15.6,-11.5 -17.3,-12.9 C 115.8,79 100.5,67.7 99.9,67.7 99.8,67.7 84.1,79.2 82.5,80.3 80.8,81.6 65.2,92.7 65.2,93.1 z"}],o["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]=[{type:"path",stroke:!1,d:"M 64.3,86.6 99.9,102.1 135.7,86.6 v 31.8 H 64.3 v -31.8 l 0,0 z m 62.5,1.9 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18,7.7 -0.5,0 -15.8,-7 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.8 v -3.2 h 71.5 v 3.2 c -2.1,0.4 -6.6,2.9 -9,3.9 z m -64.1,31.7 h 74.7 V 79.8 H 62.7 v 40.4 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 64.3,86.6 0,31.8 71.5,0 0,-31.8 -35.8,15.5 z m 0,-2 c 2,0.5 6.5,3 8.8,3.8 2.9,1.1 5.8,2.7 8.8,3.9 2,0.8 17.3,7.8 17.8,7.8 0.9,0 15.9,-6.8 18,-7.7 3.1,-1.3 5.9,-2.6 9,-3.9 2.4,-1 6.9,-3.4 9,-3.9 V 81.4 H 64.3 v 3.2 l 0,0 z"}],o["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]=[{type:"path",stroke:!1,d:"M 64.3,94.6 99.9,110.1 135.7,94.6 V 126.4 H 64.3 l 4e-4,-31.8 0,0 z m 62.5,1.9 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18.1,7.7 -0.5,0 -15.7,-6.9 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.9 v -3.2 h 71.5 v 3.2 c -2.1,0.5 -6.6,2.9 -9,3.9 z M 62.7,128.2 h 74.7 V 87.8 H 62.7 v 40.5 z m 66.1,-54.4 -5.4,0 0,13.3 -2,0 0,-13.3 -5.4,0 0,-1.8 12.8,0 0,1.8 m -14,9 c -1e-5,0.6 -0.1,1.2 -0.4,1.7 -0.3,0.6 -0.7,1.1 -1.1,1.5 -0.5,0.4 -1.2,0.8 -1.9,1 -0.7,0.2 -1.6,0.4 -2.6,0.4 -1.1,0 -2.1,-0.1 -2.9,-0.3 -0.9,-0.2 -1.8,-0.5 -2.7,-0.9 l 0,-2.5 0.1,0 c 0.8,0.6 1.6,1.1 2.7,1.5 1,0.3 1.9,0.5 2.8,0.5 1.2,10e-7 2.2,-0.2 2.9,-0.7 0.7,-0.5 1,-1.1 1,-1.9 -1e-5,-0.7 -0.2,-1.2 -0.5,-1.5 -0.3,-0.3 -0.8,-0.6 -1.5,-0.7 -0.5,-0.1 -1.1,-0.2 -1.7,-0.3 -0.6,-0.1 -1.2,-0.2 -1.9,-0.3 -1.3,-0.3 -2.3,-0.8 -3,-1.5 -0.6,-0.7 -1,-1.6 -1,-2.7 0,-1.3 0.5,-2.3 1.6,-3.1 1.1,-0.8 2.4,-1.2 4.1,-1.2 1.1,1.6e-5 2,0.1 2.9,0.3 0.9,0.2 1.7,0.5 2.4,0.8 l 0,2.4 -0.1,0 c -0.6,-0.5 -1.3,-0.9 -2.3,-1.2 -0.9,-0.3 -1.9,-0.5 -2.9,-0.5 -1.1,1.3e-5 -1.9,0.2 -2.6,0.7 -0.7,0.4 -1,1 -1,1.7 -1e-5,0.6 0.2,1.1 0.5,1.5 0.3,0.4 0.9,0.6 1.7,0.8 0.4,0.1 1,0.2 1.8,0.3 0.8,0.1 1.5,0.3 2,0.4 1.1,0.3 2,0.7 2.5,1.4 0.6,0.6 0.9,1.4 0.9,2.5 m -14.4,4.3 -6,0 0,-1.5 2,0 0,-12 -2,0 0,-1.5 6,0 0,1.5 -2,0 0,12 2,0 0,1.5 m -8.6,-7.5 c -1.5e-5,1.4 -0.3,2.6 -0.9,3.7 -0.6,1.1 -1.4,2 -2.4,2.6 -0.7,0.4 -1.5,0.7 -2.3,0.9 -0.8,0.2 -2,0.3 -3.4,0.3 l -3.8,0 0,-15.1 3.8,0 c 1.5,1.5e-5 2.6,0.1 3.5,0.3 0.9,0.2 1.6,0.5 2.2,0.9 1,0.6 1.8,1.5 2.4,2.6 0.6,1.1 0.9,2.3 0.9,3.8 m -2.1,-0 c -1.2e-5,-1.2 -0.2,-2.2 -0.6,-3 -0.4,-0.8 -1,-1.5 -1.8,-1.9 -0.6,-0.3 -1.2,-0.6 -1.9,-0.7 -0.7,-0.1 -1.5,-0.2 -2.4,-0.2 l -1.9,0 0,11.7 1.9,0 c 1,2e-6 1.8,-0.1 2.5,-0.2 0.7,-0.1 1.4,-0.4 2,-0.8 0.8,-0.5 1.3,-1.1 1.7,-1.9 0.4,-0.8 0.6,-1.8 0.6,-2.9"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 126.8,96.5 c -3.1,1.2 -5.9,2.6 -9,3.9 -2.2,0.9 -17.1,7.7 -18.1,7.7 -0.5,0 -15.7,-6.9 -17.8,-7.8 -3,-1.2 -5.9,-2.8 -8.8,-3.9 -2.3,-0.9 -6.8,-3.4 -8.8,-3.9 v -3.2 h 71.5 v 3.2 c -2.1,0.5 -6.6,2.9 -9,3.9 z m -62.5,-1.9 35.6,15.5 35.8,-15.5 V 126.4 H 64.3 l 4e-4,-31.8 0,0 z"}],o["GR.IN.IC.POST OFFICE"]=[{type:"path",stroke:!1,d:"m 74.7,92.8 24.9,10.8 L 124.7,92.8 V 115.1 H 74.7 V 92.8 l 0,0 z m 43.7,1.3 c -2.2,0.9 -4.1,1.8 -6.3,2.7 -1.5,0.6 -12,5.4 -12.6,5.4 -0.4,0 -11,-4.9 -12.5,-5.4 -2.1,-0.8 -4.1,-1.9 -6.2,-2.7 -1.6,-0.6 -4.8,-2.4 -6.2,-2.7 v -2.2 h 50 v 2.3 c -1.5,0.3 -4.6,2 -6.3,2.7 z M 73.6,116.4 H 125.8 V 88.1 H 73.6 V 116.4 z M 99.8,64.3 c 0.2,0 35.5,19.8 37.1,21.2 h -4.8 v 38.6 h -63.9 v -38.6 h -4.9 c 1.6,-1.4 6.9,-4.1 9.1,-5.3 3.1,-1.8 6,-3.4 9.1,-5.3 1.6,-1 18.3,-10.6 18.4,-10.6 z m -43.3,23.1 9.9,-0.2 v 38.4 h 67.4 v -38.4 l 9.9,0.2 c -0.5,-0.6 -43.6,-25 -43.9,-25 -0,0 -19.5,11.4 -21.7,12.5 -3.5,1.8 -7.4,4.2 -10.9,6.2 -2.7,1.6 -8.8,4.6 -10.8,6.3 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"M 99.8,64.3 C 99.8,64.3 83.1,73.9 81.5,74.9 c -3,1.8 -6,3.5 -9.1,5.3 -2.2,1.2 -7.5,4 -9.1,5.3 l 4.9,0 0,38.6 63.9,0 0,-38.7 4.8,0 c -1.6,-1.4 -36.9,-21.2 -37.1,-21.2 z M 73.6,88.1 l 52.3,0 0,28.3 -52.3,0 0,-28.3 z m 44.9,6.1 c -2.2,0.9 -4.1,1.8 -6.3,2.7 -1.5,0.6 -12,5.4 -12.6,5.4 -0.4,0 -11,-4.9 -12.5,-5.4 -2.1,-0.8 -4.1,-1.9 -6.2,-2.7 -1.6,-0.6 -4.8,-2.4 -6.2,-2.7 v -2.2 h 50 v 2.3 c -1.5,0.3 -4.6,2 -6.3,2.7 z M 74.7,92.8 99.6,103.7 124.7,92.8 V 115.1 H 74.7 V 92.8 l 0,0 z"}],o["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]=[{type:"path",stroke:!1,d:"m 114.9,121.3 0,-1.2 -30.7,0 0,1.2 z m -31.9,-2.5 -10.4,-16.7 -1,0.4 10.6,16.6 z m 13,-13.8 h 7 c 0.6,0 4.4,-6 5,-6.8 H 91 c 0.6,0.9 4.4,6.8 5,6.8 z m 15.3,12 0,-1 -23.5,0 0,1 z m 2.4,-1.6 8.6,-13.6 -0.8,-0.4 -8.5,13.3 z M 76.8,101.9 c 0,0.3 3.7,5.9 4.2,6.7 0.4,0.6 4.2,6.7 4.3,6.7 0.4,0 0.5,-0.2 0.7,-0.5 l -8.5,-13.4 c -0.2,0.1 -0.7,0.2 -0.7,0.5 z m 31,10.8 0,-1 -16.5,0 0,1 z m -19.3,-1.2 0.7,-0.4 -6.7,-10.5 -0.7,0.4 z m 22.3,-0 6.4,-10.5 -0.8,-0.3 -6.6,10.5 z m -6.4,-3 0,-1 -9.7,0 0,1 z m 2.8,-1.8 c 0,0.6 0.3,0.6 0.7,0.6 l 4.2,-6.9 -0.6,-0.4 c -0.2,0.2 -4.3,6.6 -4.3,6.7 z m -20.3,-6.3 4.1,7 c 0.3,-0.1 0.8,-0.2 0.8,-0.5 0,-0.6 -3.7,-5.6 -4,-6.9 l -1,0.4 z m -19.7,18 0.3,-2.8 c 0.1,-3.9 2,-11.4 3,-14.6 1.6,-4.7 3.2,-8.3 5.6,-12 4.4,-6.5 12,-12.4 22.8,-12.4 h 1.1 c 9.6,0 17,4.8 21.3,10.2 1.2,1.5 2.3,2.8 3.2,4.6 0.5,0.9 1,1.6 1.4,2.6 0.4,0.9 0.7,1.9 1.1,2.7 0.8,1.4 3.6,10.3 3.6,12.1 v 0.6 h 0.3 v 1 l 1.2,10.8 -0.1,2.2 H 67 l 0.2,-5 0,0 z m -2.3,-4 -0.3,2.4 -0.4,5.6 v 3.8 h 70.9 v -1 c 0,-2 0.1,-6.4 -0.2,-8.1 -0.4,-2.4 -0.5,-5.2 -1,-7.5 -0.4,-2 -2.9,-12.7 -3.9,-13.1 0,-1.6 -3.5,-7.6 -4.3,-8.8 -1.8,-2.6 -3.8,-5 -6.2,-7 -4.9,-3.9 -10.5,-7 -19.3,-7 h -1 c -11.8,0 -19.6,5.9 -24.6,12.8 -1.4,1.9 -2.4,3.8 -3.5,5.9 -1.2,2.3 -1.7,4.2 -2.6,6.7 -1.2,3 -3.4,11.4 -3.5,15.3 l 0,0 z m 52.2,4.7 c 0.4,-1.3 4.2,-6.6 5.2,-8.3 0.6,-1 5.1,-7.9 5.1,-8.2 0,-0.3 -0.6,-0.4 -0.8,-0.5 l -10.6,16.6 1.1,0.4 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 84.2,120.1 h 30.7 v 1.2 H 84.2 v -1.2 z m 3.6,-4.2 h 23.5 v 1 H 87.8 v -1 z m 3.5,-4.2 h 16.5 v 1 H 91.4 v -1 z m 3.3,-4.2 h 9.7 v 1 h -9.7 v -1 z m 22.4,11.5 -1.1,-0.4 10.6,-16.6 c 0.3,0.1 0.8,0.2 0.8,0.5 0,0.3 -4.6,7.2 -5.1,8.2 -1,1.8 -4.9,7 -5.2,8.3 z m -45.4,-16.6 1,-0.4 10.4,16.7 -0.8,0.4 -10.6,-16.6 z m 13.7,12.8 c -0.2,0 -4,-6 -4.3,-6.7 -0.5,-0.8 -4.2,-6.3 -4.2,-6.6 0,-0.3 0.4,-0.4 0.7,-0.5 l 8.5,13.3 c -0.2,0.3 -0.2,0.5 -0.7,0.5 z m 36.2,-13.8 0.8,0.4 -8.6,13.6 -0.8,-0.6 8.6,-13.4 z m -5.1,-0.6 0.8,0.3 -6.4,10.5 -1,-0.3 6.6,-10.5 z m -33.9,-0 6.7,10.5 -0.7,0.4 -6.7,-10.5 0.7,-0.4 z m 24.7,6 c 0,-0.1 4.1,-6.5 4.3,-6.7 l 0.6,0.4 -4.2,6.9 c -0.4,0 -0.7,-0.1 -0.7,-0.6 z m -19.4,-6.7 c 0.3,1.3 4,6.3 4,6.9 0,0.3 -0.6,0.4 -0.8,0.5 l -4.1,-7 1,-0.4 z m 8.2,4.9 c -0.6,0 -4.4,-6 -5,-6.8 h 17 c -0.6,0.8 -4.4,6.8 -5,6.8 h -7 z m -28.5,10.7 c 0,0.5 -0,2.8 -0.3,2.8 l -0.2,5 h 65.2 l 0.1,-2.2 -1.2,-10.8 v -1 h -0.3 v -0.6 c 0,-1.8 -2.8,-10.6 -3.6,-12.1 -0.4,-0.8 -0.7,-1.8 -1.1,-2.7 -0.5,-1 -1,-1.6 -1.5,-2.6 -0.9,-1.8 -2,-3.1 -3.2,-4.6 -4.2,-5.4 -11.6,-10.2 -21.3,-10.2 h -1 c -10.8,0 -18.5,5.8 -22.8,12.4 -2.5,3.8 -4.1,7.4 -5.7,12 -1.1,3.2 -3,10.7 -3,14.6 l 0,0 z"}],o["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]=[{type:"path",stroke:!1,d:"m 122.4,117.1 0,-1.5 -45.1,0 0,1.5 z M 74.5,114 75.6,113.4 59.8,88.8 58.8,89.4 z m 49.6,-0.6 c 0.2,0.1 1,0.5 1.3,0.5 0.2,0 14.4,-22.4 15.9,-24.6 l -1.5,-0.5 -15.7,24.6 z m -6.6,-2.6 0,-1.7 -35,0 0,1.7 z m 2.4,-3.2 c 0,0.2 1,0.8 1.1,0.9 l 12.8,-20 h 0.2 l -1.6,-0.8 c -1.3,2.4 -12.6,19.3 -12.6,20 z m -41.1,0.9 1.4,-0.8 -12.7,-20.1 -1.3,0.8 z m 33.3,-3.9 0,-1.6 -24.4,0 0,1.6 z m 3.4,-2.8 c 0,0.6 0.6,0.7 1.1,0.9 l 9.6,-15.4 -1.2,-0.6 c -0.6,2 -9.4,14.5 -9.4,15.2 z m -32.2,1 1.4,-0.6 -9.7,-15.5 -1.3,0.8 z m 23.4,-4.5 0,-1.7 -13.8,0 0,1.7 z m 5.6,-1.7 6.4,-10.3 -1.2,-0.5 -6.6,10.2 z m -24.6,0.1 1.1,-0.8 -6.5,-10.2 -1.3,0.6 z m 6.6,-4 11,0.1 c 0.6,0 6.4,-8.9 7,-10 H 87.3 l 6.9,9.9 z"}],o["GR.IN.IC.RELIGIOUS INSTITUTION"]=[{type:"path",stroke:!1,d:"m 101.2,68.1 c 7.9,0 18,3.8 21.7,8 5,5.7 7,12.3 7,22.8 V 131.9 H 101.2 V 68.1 z M 70.1,96.3 c 0,-8.4 3.4,-16.4 7.7,-20.7 3.9,-3.9 13.2,-7.5 20.9,-7.5 v 63.9 H 70.1 V 96.3 z m -2.6,38.3 h 65 V 99.3 c 0,-10.8 -2.5,-19.7 -8.1,-25.2 -4.8,-4.8 -15,-8.7 -24.6,-8.7 -8.3,0 -19.4,3.7 -23.6,7.9 -3.2,3.3 -4.3,5 -6.2,9.5 -1,2.4 -2.5,10 -2.5,13.2 v 38.5 l 0,0 z M 105.1,97.6 v 12.5 c 0,0.5 0.6,1.1 1.1,1.1 h 0.4 c 0.7,0 1.1,-0.8 1.1,-1.5 V 97.8 c 0,-0.5 -0.6,-1.1 -1.1,-1.1 H 106 c -0.5,0 -0.9,0.4 -0.9,0.9 z m -11.2,13.6 c 0.8,0 0.9,-1 0.9,-1.7 V 97.6 c 0,-0.5 -0.4,-0.9 -0.9,-0.9 h -0.6 c -0.5,0 -0.9,0.4 -0.9,0.9 v 12.5 c 0,0.5 0.6,1.1 1.1,1.1 h 0.4 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 105.1,97.6 c 0,-0.5 0.4,-0.9 0.9,-0.9 h 0.7 c 0.5,0 1.1,0.6 1.1,1.1 v 11.8 c 0,0.7 -0.4,1.5 -1.1,1.5 h -0.5 c -0.5,0 -1.1,-0.6 -1.1,-1.1 V 97.6 h 0 z m -3.9,34.4 h 28.7 V 98.9 c 0,-10.5 -2,-17.1 -7,-22.8 C 119.2,71.9 109.1,68.1 101.2,68.1 v 63.9 z M 94,111.2 H 93.5 c -0.5,0 -1.1,-0.6 -1.1,-1.1 V 97.6 c 0,-0.5 0.4,-0.9 0.9,-0.9 h 0.7 c 0.5,0 0.9,0.4 0.9,0.9 v 11.8 c 0,0.8 -0.1,1.8 -0.9,1.8 z M 70.1,96.3 v 35.7 H 98.8 V 68.1 c -7.7,0 -17,3.6 -20.9,7.5 -4.3,4.3 -7.7,12.3 -7.7,20.7 z"}],o["GR.IN.IC.CHILD DAY CARE"]=[{type:"path",stroke:!1,d:"m 76.6,100.3 c 0,1.8 1.1,3.4 3,3.4 h 0.6 c 1.4,0 2.4,-1.5 2.4,-3 0,-4.3 -6,-4.2 -6,-0.4 z m 26.5,-11.9 v 0.4 c 0,1.5 1.4,3.2 2.8,3.2 h 0.4 c 1.6,0 3,-1.2 3,-2.8 V 87.8 c 0,-1 -1.6,-2 -2.8,-2 h -0.2 c -1.5,-0 -3.2,1.4 -3.2,2.6 z m -3.2,-16.8 35.4,21.7 c -1.3,0.2 -4.6,-0.3 -4.6,0.9 v 34.9 H 69.3 V 94.1 c 0,-1.2 -3.3,-0.8 -4.6,-0.9 l 35.2,-21.7 0,0 z m -39.8,22.4 c 0.2,0.8 0.3,1.3 1.3,1.3 h 6.2 v 34.6 c 0,0.5 0.1,0.5 0.2,0.9 h 64 c 0.4,0 0.8,-0.3 0.8,-0.8 V 95.2 h 6 c 0.8,0 1.3,-0.4 1.3,-1.1 0,-0.6 -17.8,-11.2 -19.8,-12.5 -1.6,-1 -20,-12.3 -20,-12.3 -0.2,0 -36.7,22.5 -40,24.7 l 0,0 z m 20.9,14.2 5.9,4.3 -0.1,0.1 -4.8,2.2 c -0.2,-0.8 -1,-1.9 -1,-2.5 v -4.1 z m 28.4,-8.8 c 0.5,-0.8 0.6,-2.9 1,-3.1 0.4,-0.2 2.4,0.8 2.9,0.9 v 3.6 l -4.4,1.7 v -0.6 c -0,-0.9 0.5,-1 0.5,-2.4 z m -3,2 c 0,0.9 0,1.1 -0.4,1.7 V 104 c -2.4,0.2 -15.4,7.5 -17,7.5 -0.5,0 -6.5,-6.7 -7.3,-6.7 h -4.3 c -0.5,0 -2.8,5.2 -2.8,5.6 v 4.7 c 0,0.9 1.8,1.4 2,2.4 l -4.1,1.7 1.3,2.6 6.2,-2.8 c 1.5,0.8 9.3,5.6 10.5,5.6 h 0.6 c 0.8,0 1.9,-0.8 1.9,-1.5 v -0.4 c 0,-0.9 -7.3,-4.8 -8.4,-5.8 l 14,-6.3 v 8.4 h -3 v 6.7 h 8.4 v -6.7 h -2.8 v -9.9 l 13.2,-5.8 c 0,1.6 0.2,3.7 0.4,5.1 0.2,1.8 -0.6,3.9 1.5,3.9 2.1,0 1.3,-2.5 1.3,-4.3 0,-1.9 -0.2,-3.5 -0.2,-5.6 v -0.6 l 9.1,-4 -1,-2.9 -6.2,2.8 c 0.3,-0.6 0.7,-0.8 1,-1.4 0.2,-0.7 0.4,-1.2 0.7,-1.8 0.5,-1 0.9,-2.6 1.4,-3.4 l -11.4,-1.6 c -0.6,0.5 -3.2,3.3 -3.2,4.2 v 0.6 h -0.4 l -1.1,7.1 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 81,112.2 c 0,0.6 0.8,1.7 1,2.5 l 4.8,-2.2 0.2,-0.1 -6,-4.3 v 4.1 z m 28.4,-12.9 c 0,1.4 -0.6,1.6 -0.6,2.4 v 0.6 l 4.5,-1.7 v -3.6 c -0.5,-0.1 -2.6,-1 -2.9,-0.9 -0.4,0.2 -0.5,2.4 -1,3.1 z m -32.9,0.9 c 0,-3.9 6,-4 6,0.4 0,1.4 -1.1,3 -2.4,3 h -0.5 c -1.8,0 -3,-1.6 -3,-3.4 z m 29.5,2.8 0.4,-1.7 1.1,-7.1 h 0.4 v -0.6 c 0,-0.8 2.6,-3.7 3.2,-4.2 l 11.4,1.6 c -0.5,0.8 -0.9,2.4 -1.4,3.4 -0.3,0.6 -0.4,1.1 -0.7,1.8 -0.3,0.7 -0.7,0.8 -1,1.4 l 6.2,-2.8 1,2.9 -9.1,4 v 0.6 c 0,2.1 0.2,3.7 0.2,5.6 0,1.8 0.8,4.3 -1.3,4.3 -2.1,0 -1.3,-2.2 -1.5,-3.9 -0.2,-1.4 -0.4,-3.5 -0.4,-5.1 l -13.2,5.8 v 9.9 h 2.8 v 6.7 h -8.4 v -6.7 h 3 v -8.4 l -14,6.3 c 1.1,0.9 8.4,4.9 8.4,5.8 v 0.4 c 0,0.7 -1,1.5 -1.9,1.5 H 90.6 c -1.2,0 -8.9,-4.8 -10.5,-5.6 l -6.2,2.8 -1.3,-2.6 4.1,-1.7 c -0.3,-1 -2,-1.5 -2,-2.4 v -4.6 c 0,-0.4 2.3,-5.6 2.8,-5.6 h 4.3 c 0.8,0 6.8,6.7 7.3,6.7 1.5,0 14.6,-7.3 17,-7.5 v -0.9 z m -3,-14.8 c 0,-1.2 1.7,-2.6 3.2,-2.6 h 0.2 c 1.2,0 2.8,1.1 2.8,2 v 1.3 c 0,1.6 -1.4,2.8 -3,2.8 h -0.4 c -1.4,0 -2.8,-1.7 -2.8,-3.2 v -0.4 z m -38.4,4.9 c 1.3,0.1 4.6,-0.3 4.6,0.8 v 34.9 h 61.4 V 94.1 c 0,-1.2 3.3,-0.8 4.6,-0.9 l -35.4,-21.7 -35.2,21.8 0,0 z"}],o["GR.IN.IC.HELICOPTER LANDING SITE"]=[{type:"path",stroke:M,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:M,fill:!!e&&i,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"},{type:"circle",fill:!1,cx:100,cy:100,r:40}],o["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE LOCK"]=[{type:"path",fill:!1,d:"m 70,70 65,30 -65,30"}],o["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE SHIP ANCHORAGE"]=[{type:"path",fill:!1,stroke:"rgb(255, 0, 255)",d:"m 73.6,112.8 c 0.8,8 26.4,11.2 26.4,11.2 0,0 25.6,-3.2 26.4,-11.2 M 80,88 l 40,0 m -20,-12 0,48"}],o["GR.IN.IC.NATURAL GAS FACILITY"]=[{type:"path",fill:!1,d:"m 100,60.5 c -16.4,0 -29.6,13.2 -29.6,29.6 0,12.8 8.3,23.9 19.7,27.8 l 0,19.7 c 3.2,1.2 6.3,1.8 9.9,1.8 3.6,0 6.7,-0.6 9.9,-1.8 l 0,-19.8 c 11.5,-3.9 19.8,-15 19.7,-27.8 0,-16.4 -13.2,-29.6 -29.6,-29.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:35,text:"NG"}],o["GR.IN.IC.TOLL FACILITY"]=[{type:"path",stroke:!1,d:"m 69.1,112.3 c 0,-0.7 0.8,-1.7 1.4,-1.7 h 0.5 c 0.8,0 1.5,0.8 1.5,1.5 v 1.2 c 0,0.5 -0.9,1.2 -1.5,1.2 h -0.2 c -0.8,0 -1.7,-0.8 -1.7,-1.4 v -0.9 l 0,0 z m -1.1,0.5 v 0.3 c 0,1.2 1.5,2.6 2.9,2.6 1.3,0 2.8,-1.5 2.8,-2.5 v -1 c 0,-1.2 -1.4,-2.6 -2.8,-2.6 -1.7,0 -2.9,1.6 -2.9,3.2 z m 27.6,-11.6 -2,-2.8 -2.3,0 4.3,2.8 z m -29.5,17.8 c 0,-0.5 0.8,-0.9 1.4,-0.9 H 99.1 c 0.8,0 1.3,0.6 1.4,1.4 -0.6,0.1 -1,0.3 -1.7,0.3 H 68 c -0.6,0 -1.8,0 -1.8,-0.6 v -0.2 z m 9.4,-10.2 15.1,0 8.2,0.2 c 0.5,0.9 2,3 1.8,4.3 l -0.2,2.6 c -0.5,0.2 -0.5,0.3 -1,0.3 H 67.1 c -0.6,0 -0.5,-0.2 -1.1,-0.3 -0.1,-0.7 -0.3,-1 -0.3,-1.8 v -0.6 c 0,-1.1 1.5,-3.5 2,-4.4 l 7.8,-0.2 z m -5.8,-2 c 0.1,-1.1 3.5,-7.1 4.3,-7.1 h 18.4 c 1,0 4,5.8 4.3,7.1 H 69.7 z m 21.7,-8.4 2.3,-0 2,2.8 -4.3,-2.8 z m 44.3,27.8 V 73.8 c -1,0.2 -10.3,6 -11.9,7 -1.3,0.8 -11.6,6.5 -11.6,7.2 0,0 1.3,2.1 1.4,2.3 l 4.9,-2.8 v 19.2 l -0.4,0.3 c -2.9,-2 -33.4,-22 -33.6,-22 -0.1,0 -3.9,5.6 -4,6.2 l 10.8,7 -18.3,0 c -0.9,1.4 -1.9,2.4 -2.8,3.8 -0.2,0.3 -2,4.4 -2,4.6 v 0.8 h -1.2 c -0.1,0.9 -2.6,4.6 -2.6,5.4 v 0.8 c 0,1.5 0.4,2.9 1.4,3.4 -0.2,0.3 -1,1.1 -1,1.6 v 0.9 c 0,1.1 1.5,1.5 2.6,1.5 v 2.3 l 0.2,2 c 0.5,0.2 0.3,0.5 1.2,0.6 0.6,0.1 1,0.2 1.7,0.2 h 1.1 l 1.7,-0.2 0.3,-0.3 0.2,-2 0,-2.5 h 19.1 v 3.1 c 0,0.8 0.3,1.2 0.6,1.7 l 1.4,0.2 1.2,-0 c 1.7,0 3.1,-0.1 3.1,-1.8 v -3.1 c 0.8,-0.2 2.6,-0.5 2.6,-1.4 v -1.7 c 0,-0.5 -0.5,-0.7 -0.9,-0.8 0.1,-0.5 1.2,-1.1 1.2,-2.5 v -2 c 0,-1.5 -2.1,-4.1 -2.5,-5.4 h -1.2 v -0.4 c 0,-1.1 -2.2,-4.8 -2.5,-5.8 l 19,12.5 c -0.4,1.6 -2,4 -2,5.2 v 7.2 h 22.9 l 0,0 z M 95.9,114.6 H 95.7 c -1.1,0 -1.8,-0.7 -1.8,-1.7 v -0.5 c 0,-1 0.6,-1.8 1.5,-1.8 h 0.5 c 1,0 1.5,1.1 1.5,2 0,1.1 -0.5,2 -1.5,2 z m -3.1,-2.5 v 1.1 c 0,1 1.6,2.5 2.9,2.5 1.4,0 2.6,-1.3 2.6,-2.8 v -0.8 c 0,-1.2 -1.3,-2.6 -2.5,-2.6 H 95.7 c -1.4,0 -2.9,1.4 -2.9,2.6 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 114.5,107.9 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m -11.2,-7.2 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m -5.5,-3.7 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 108.9,104.5 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 92.3,93.5 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z M 86.5,89.8 c 0,0.9 -0.8,1.6 -1.8,1.6 -1,0 -1.8,-0.7 -1.8,-1.6 0,-0.9 0.8,-1.6 1.8,-1.6 1,0 1.8,0.7 1.8,1.6 z m 35.6,2.6 10.8,0 0,16.1 -10.8,0 z m -55.9,26.4 v 0.2 c 0,0.6 1.2,0.6 1.8,0.6 h 30.8 c 0.7,0 1.1,-0.2 1.7,-0.3 -0.1,-0.8 -0.6,-1.4 -1.4,-1.4 H 67.5 c -0.5,0 -1.4,0.4 -1.4,0.9 z m 26.6,-6.8 c 0,-1.2 1.5,-2.6 2.9,-2.6 h 0.2 c 1.2,0 2.5,1.4 2.5,2.6 v 0.8 c 0,1.4 -1.2,2.8 -2.6,2.8 -1.4,0 -2.9,-1.4 -2.9,-2.5 v -1 h -0 z m -24.8,0.6 c 0,-1.6 1.2,-3.2 2.9,-3.2 1.3,0 2.8,1.5 2.8,2.6 v 1.1 c 0,0.9 -1.4,2.5 -2.8,2.5 -1.4,0 -2.9,-1.4 -2.9,-2.6 v -0.3 z m -0.3,-3.8 c -0.5,1 -2,3.4 -2,4.4 v 0.6 c 0,0.9 0.2,1.1 0.3,1.8 0.5,0.1 0.5,0.3 1.1,0.3 h 32.3 c 0.6,0 0.5,-0.2 1,-0.3 l 0.2,-2.6 c 0.1,-1.2 -1.4,-3.4 -1.8,-4.3 l -8.2,-0.2 -15.1,-0 -7.8,0.2 z m 2,-2.2 h 27.1 c -0.4,-1.3 -3.3,-7.1 -4.3,-7.1 H 74 c -0.8,0 -4.2,6 -4.3,7.1 z m 26.2,7.8 c 1.1,0 1.5,-0.9 1.5,-2 0,-0.9 -0.6,-2 -1.5,-2 h -0.5 c -1,0 -1.5,0.8 -1.5,1.8 v 0.5 c 0,1 0.8,1.7 1.8,1.7 h 0.2 l 0,0 z M 69.1,112.3 v 0.9 c 0,0.6 1,1.4 1.7,1.4 h 0.2 c 0.6,0 1.5,-0.8 1.5,-1.2 v -1.2 c 0,-0.8 -0.8,-1.5 -1.5,-1.5 h -0.5 c -0.6,0 -1.4,1 -1.4,1.7 z"}],o["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]=[{type:"path",stroke:!1,d:"m 121.4,81.7 h 1.1 v 0.6 c 0,0.6 0.8,2.1 1.2,2.4 0.5,0.4 1.9,0.9 2.7,0.9 2.6,0 3.9,-1.9 3.9,-4.5 v -0.5 h -7.4 c -0.5,0 -1.2,0.8 -1.4,1.1 z m -22.6,23.5 c 0,-1.7 1.7,-3 3.4,-3 1.7,0 3.1,1.4 3.1,3.1 v 0.6 c 0,1.3 -1.7,2.6 -3.1,2.6 -1.7,0 -3.4,-1.3 -3.4,-3 v -0.5 z m -29.7,0 c 0,-1.8 1.3,-3 3.1,-3 1.7,0 3.3,1.4 3.3,3.1 v 0.3 c 0,1.6 -1.6,3 -3.4,3 -1.5,0 -3,-1.2 -3,-2.6 v -0.8 z m 3.7,-7 c 0,-0.4 1.6,-4.2 1.9,-5 0.6,-1.7 0.9,-3.6 3.3,-3.6 H 96.5 c 2.8,0 2.2,1.8 3.2,3.6 0.2,0.4 1.8,4.5 1.8,4.9 H 72.8 z m -3.7,1 c -2.1,0 -3.7,1.5 -3.7,3.6 v 9.2 c 0,1 1.7,2.3 3.1,2.3 v 5.3 c 0,1.8 1.3,3.3 3.3,3.3 1.4,0 3.1,-1.6 3.1,-2.6 v -5.9 h 24.8 v 6.2 c 0,1 1.7,2.3 3,2.3 h 0.2 c 1.4,0 3.1,-1.3 3.1,-2.6 v -5.9 c 1.9,0 3.3,-1.4 3.3,-3.3 v -8.1 c 0,-2 -1.4,-3.3 -3.2,-3.7 -1.4,-0.2 -1.1,-0.8 -1.6,-1.9 -0.4,-0.8 -0.7,-1.6 -1,-2.4 -1.2,-2.6 -2.2,-8.2 -5.6,-8.2 h -21.2 c -2.9,0 -3.5,3.3 -4.5,5.5 -0.6,1.4 -2.7,5.8 -3,7 z m 56.5,20.2 0.3,-3.3 0.5,-6.2 h 1.7 l 0.8,12.9 h 5.8 V 88.9 c 0,-0.6 -1.2,-1.9 -2,-1.9 l -0.6,0.1 -9.9,14.6 h 8.4 v 3.6 h -11.2 v 17.6 h 6.1 l -0,-0.8 0.2,-2.6 z m -16.8,-30.8 c 0.2,-0.9 1,-1.5 2,-1.6 v 2.2 h -2 c 0,1.4 0.8,2.2 2.2,2.2 v -2 h 2 c -0,1.3 -0.8,1.4 -1.4,2 h 7.8 l 0,10.2 10,-14.3 -10.1,-0.2 h -6.4 v -7.6 c 0,-1.2 -0.8,-2.2 -1.9,-2.2 h -0.4 c -2.2,0 -2,2.4 -2,4.7 0,1.3 -0.4,5.8 0.2,6.6 z m 0,0 v 0.6 h 2 v -2.2 c -1.1,0 -1.8,0.7 -2,1.6 z m 2.2,2.8 h 0.6 c 0.6,-0.6 1.4,-0.7 1.4,-2 h -2 v 2 z m 19.3,-12 0,-2 -8.8,-0 1,2 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 130.3,79.4 -7.9,-0 0.4,1.3 7.5,0 z m -8.1,22.2 9.9,-14.6 0.6,-0.1 -3.1,0.2 -10,14.3 -0.1,3.7 11.2,0 0,-3.6 z m -23.3,3.6 v 0.5 c 0,1.7 1.7,3 3.4,3 1.4,0 3.1,-1.4 3.1,-2.6 v -0.6 c 0,-1.7 -1.4,-3.1 -3.1,-3.1 -1.8,0 -3.4,1.3 -3.4,3 z m -29.7,0 v 0.8 c 0,1.4 1.5,2.6 3,2.6 1.8,0 3.4,-1.3 3.4,-3 v -0.3 c 0,-1.6 -1.6,-3.1 -3.3,-3.1 -1.8,0 -3.1,1.2 -3.1,3 z m 3.7,-7 h 28.6 c 0,-0.5 -1.5,-4.5 -1.8,-4.9 -1,-1.8 -0.4,-3.6 -3.2,-3.6 H 77.9 c -2.4,0 -2.6,1.9 -3.3,3.6 -0.2,0.8 -1.8,4.6 -1.8,5 z"}],o["GR.IN.IC.TUNNEL"]=[{type:"path",stroke:!1,d:"m 94.4,116.8 c 0,-3.5 2.6,-7.2 5.9,-7.2 3.2,0 5.6,4 5.6,7.1 v 0.8 H 94.4 v -0.7 z m 27.2,-4.7 9,-4.2 c 0.2,1.7 0.8,3.2 1,5.2 0.3,1.8 0.6,3.3 0.6,5.6 v 0.5 h -10 l -0.7,-7.1 z m -43.5,4.9 0.1,2.2 H 68 c 0,-1.6 0.3,-3.8 0.6,-5.4 0.1,-0.7 0.2,-1.8 0.5,-2.4 0.1,-0.2 0.7,-2.2 0.7,-2.4 l 9.2,3.1 -0.8,4.9 z m 39,-16.8 6.2,-6.2 c 0.6,1 1.2,1.8 1.9,2.8 0.8,1.1 1.2,2 1.8,3.1 0.6,1 2.8,5.6 2.8,6.9 l -8.7,4.2 c -0.1,-2.5 -3,-9 -4,-10.6 z m -37.9,10.4 -9.1,-3 c 0.1,-1.2 2.4,-5.9 3,-7 1.2,-2.1 3,-4.2 4,-6 l 7.6,4.4 c -0.2,0.5 -2.6,4.3 -3,5.4 -0.8,1.7 -1.6,4.9 -2.4,6.2 z M 111.2,83.2 c 2.8,0.7 9.8,7.1 11.3,9.4 l -6.3,6.2 c -0.5,-1.8 -6,-6.9 -8.2,-7.4 l 3.2,-8.2 z M 78.1,93.4 C 79.7,91 88,83.8 91,83.1 L 94.9,91 c -2.6,0.6 -7.9,5 -9.2,6.9 l -7.6,-4.5 z M 92.6,82.4 c 2.6,-0.6 4.1,-1.8 7.8,-1.8 h 1.4 c 4,0 5.3,1.2 8.1,1.8 -0,1 -1.9,5.2 -2.3,6.3 -0.6,1.4 -0.4,2 -2.2,1.5 -1.1,-0.3 -2.4,-0.6 -3.6,-0.6 h -1 L 96.1,90.3 92.6,82.4 z M 66.5,119.8 H 60.4 c -0.4,0 -0.5,0.1 -0.5,0.5 v 0.2 c 0,0.4 0.1,0.5 0.5,0.5 h 79 c 0.3,0 0.7,-0.3 0.7,-0.5 0,-0.4 -0.3,-0.7 -0.7,-0.7 h -5.7 v -1.5 c 0,-10.1 -4.9,-20.4 -9.5,-25.9 C 119.8,87 111.6,79 102.2,79 h -2 c -9.7,0 -18.8,8.4 -23.6,13.7 -5,5.6 -10.1,16.6 -10.1,27.1 l 0,0 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 79,112 -9.3,-3.1 c -0,0.2 -0.6,2.2 -0.7,2.4 -0.2,0.6 -0.4,1.7 -0.5,2.4 -0.2,1.5 -0.5,3.8 -0.5,5.4 h 10.3 l -0.1,-2.2 0.8,-4.9 z m 15.5,5.4 h 11.4 v -0.8 c 0,-3.1 -2.4,-7.1 -5.6,-7.1 -3.3,0 -5.9,3.8 -5.9,7.2 v 0.7 z m 27.9,1.7 h 10 v -0.5 c 0,-2.3 -0.4,-3.8 -0.6,-5.6 -0.3,-2 -0.9,-3.5 -1,-5.2 l -9,4.2 0.7,7.1 z m -5.2,-19 c 1.1,1.6 4,8.1 4,10.6 l 8.7,-4.2 c 0,-1.2 -2.1,-5.8 -2.8,-6.8 -0.7,-1.1 -1.1,-2 -1.8,-3.1 -0.7,-1 -1.3,-1.8 -1.9,-2.8 l -6.2,6.2 z m -37.9,10.4 c 0.7,-1.4 1.6,-4.5 2.4,-6.2 0.5,-1.1 2.9,-4.9 3,-5.4 l -7.6,-4.4 c -1,1.8 -2.8,4 -4,6 -0.6,1.1 -2.9,5.8 -3,7 l 9.1,3 z m 28.8,-19.1 c 2.1,0.5 7.6,5.6 8.2,7.4 l 6.3,-6.1 c -1.5,-2.3 -8.5,-8.8 -11.3,-9.5 l -3.2,8.2 z m -30,2 7.6,4.6 C 87,96 92.3,91.6 94.9,91 l -3.8,-7.9 c -3.1,0.7 -11.4,7.9 -13,10.3 z M 92.6,82.4 l 3.5,7.9 4.6,-0.6 h 1 c 1.3,0 2.6,0.3 3.6,0.6 1.7,0.4 1.6,-0.1 2.2,-1.5 0.4,-1.1 2.3,-5.3 2.3,-6.3 -2.8,-0.6 -4,-1.9 -8.1,-1.9 h -1.4 c -3.6,0 -5.2,1.3 -7.7,1.9 z"}],o["GR.IN.IC.PUMPING STATION"]=[{type:"path",stroke:!1,d:"m 83.2,83.8 0,1.2 0,5.6 -11.3,0 0,-0 c -0.2,0 -0.3,0 -0.5,0 -0.1,6.6e-4 -0.1,-9.6e-4 -0.2,0 -2.7,0 -4.9,0.3 -6.5,1.7 -1.4,1.2 -2,3.3 -2.1,5.9 l -0.1,0 0,1.2 c 8e-6,0.1 -0,0.2 -0,0.3 l 0,0 0,14.1 -2.8,0 0,2.4 80.8,0 0,-2.4 -2.8,0 0,-14 0,-1.6 -0.1,0 c -0.1,-2.6 -0.5,-4.6 -1.8,-5.9 -1.5,-1.4 -3.8,-1.7 -6.8,-1.7 l 0,-0 -0.3,0 c -0.2,-5.6e-4 -0.3,-0 -0.4,-0 l 0,0 -11.3,0 0,-5.6 0,-1.2 -1.2,0 -31.2,0 -1.2,0 z m 2.4,2.4 28.8,0 0,27.2 -28.8,0 0,-27.2 z M 71.2,93 c 0.1,-0 0.1,0 0.2,0 l 11.8,0 0,8.4 -7.5,0 c -0.8,-0.1 -1.4,-0.1 -2,-0 -0,0 -0,0 -0.1,0 -0,0 -0,-0 -0,0 l 0,0 c -0.5,0.1 -1.2,0.3 -1.5,0.8 -0.4,0.5 -0.4,1.1 -0.4,1.6 -0,0.4 -0,0.8 0,1.2 l -0,0 0,8.8 -6.8,0 0,-14.5 c 0,-3 0.5,-4.5 1.4,-5.3 C 67.1,93.3 68.7,93.1 71.2,93 z m 45.6,0 11.8,0 c 0.1,9.7e-4 0.1,-0 0.2,0 2.8,0.1 4.5,0.4 5.2,1.1 0.8,0.7 1.2,2.3 1.2,5.2 l 0,14.5 -6.8,0 0,-8 0,0 c -0,-0.1 -0,-0.3 -0,-0.4 0,-0.9 0.2,-1.6 -0.1,-2.5 -0.1,-0.5 -0.6,-1.2 -1.2,-1.4 -0.2,-0.1 -0.5,-0 -0.7,-0 l 0,-0.1 -9.6,0 0,-8.4 z M 74,103.8 l 9.2,0 0,10 -9.2,0 0,-8.5 0,0 c 0,-0.6 -0,-1.1 -0,-1.4 0,-0.1 -0,-0 0,-0.1 z m 42.8,0 9.2,0 c 0,0.2 0,0.8 0,1.6 l -0,0 0,8.4 -9.2,0 0,-10 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 116.8,93 11.8,0 c 0.1,9.7e-4 0.1,-0 0.2,0 2.8,0.1 4.5,0.4 5.2,1.1 0.8,0.7 1.2,2.3 1.2,5.2 l 0,14.5 -6.8,0 0,-8 0,0 c -0,-0.1 -0,-0.3 -0,-0.4 0,-0.9 0.2,-1.6 -0.1,-2.5 -0.1,-0.5 -0.6,-1.2 -1.2,-1.4 -0.2,-0.1 -0.5,-0 -0.7,-0 l 0,-0.1 -9.6,0 0,-8.4 z m -45.6,0 c 0.1,-0 0.1,0 0.2,0 l 11.8,0 0,8.4 -7.5,0 c -0.8,-0.1 -1.4,-0.1 -2,-0 -0,0 -0,0 -0.1,0 -0,0 -0,-0 -0,0 l 0,0 c -0.5,0.1 -1.2,0.3 -1.5,0.8 -0.4,0.5 -0.4,1.1 -0.4,1.6 -0,0.4 -0,0.8 0,1.2 l -0,0 0,8.8 -6.8,0 0,-14.5 c 0,-3 0.5,-4.5 1.4,-5.3 C 67.1,93.3 68.7,93.1 71.2,93 z m 14.4,-6.8 28.8,0 0,27.2 -28.8,0 0,-27.2 z"}],o["GR.IN.IC.RESERVOIR"]=[{type:"path",stroke:!1,d:"M 127.3 69.1 C 127 69.1 126.7 69.2 126.4 69.2 C 123.4 69.5 120.8 71.9 118.4 74.5 C 115.9 77 113.5 79.7 111.5 80.9 C 108.9 82.4 105.5 82.5 101.9 82.6 C 98.3 82.7 94.7 82.9 91.8 84.9 C 89.7 86.5 88.6 88.5 87.5 90.3 C 86.4 92 85.2 93.4 82.7 94.2 C 79.4 95.3 72 96.4 66.9 98.8 C 64.3 100.1 62.1 101.7 61.5 104 C 60.8 106.3 61.7 109.1 64.7 112.3 L 65.1 111.9 L 65.1 120.1 L 84.3 120.1 L 84.3 129.7 L 86.7 129.7 L 86.7 120.1 L 97.9 120.1 L 97.9 129.7 L 100.3 129.7 L 100.3 120.1 L 117.1 120.1 L 117.1 112.5 C 117.4 112.2 117.7 111.9 118 111.5 C 119 110.1 119.3 108.5 119.5 106.9 C 119.8 103.7 119.5 100.5 121.7 97.7 C 123.1 95.9 126 95.4 129.1 94.7 C 132.1 94.1 135.4 93.3 137.2 90.4 C 139.4 86.7 139.1 81.3 137.2 76.8 C 136.3 74.5 134.9 72.5 133 71.1 C 131.4 69.9 129.5 69.1 127.3 69.1 z M 127.4 70.7 C 129.2 70.7 130.7 71.3 132.1 72.3 C 133.6 73.5 134.9 75.4 135.8 77.4 C 137.5 81.5 137.6 86.6 135.8 89.6 C 134.5 91.8 131.7 92.5 128.7 93.2 C 125.7 93.8 122.4 94.3 120.5 96.7 C 117.8 100 118.2 103.7 117.9 106.7 C 117.8 108.2 117.5 109.5 116.7 110.6 C 116.5 110.8 116.3 111.1 116.1 111.3 L 65.8 111.3 L 65.9 111.3 C 63.1 108.2 62.6 106.1 63 104.4 C 63.5 102.8 65.2 101.4 67.6 100.3 C 72.3 98 79.5 96.9 83.1 95.8 C 86.1 94.8 87.7 92.9 88.8 91.1 C 90 89.3 90.9 87.5 92.8 86.2 C 95.1 84.5 98.4 84.3 102 84.2 C 105.5 84.1 109.2 84.1 112.3 82.3 C 114.7 80.8 117.1 78.1 119.5 75.6 C 121.9 73.1 124.4 71 126.6 70.8 C 126.9 70.8 127.1 70.7 127.4 70.7 z "},{type:"path",stroke:!1,fill:!!e&&i,d:"m 127.4,70.7 c 1.8,-0 3.3,0.6 4.7,1.6 1.5,1.2 2.8,3 3.7,5.1 1.7,4.1 1.9,9.2 0.1,12.2 -1.3,2.2 -4.1,3 -7.1,3.6 -3,0.6 -6.3,1.1 -8.3,3.5 -2.6,3.3 -2.3,7.1 -2.6,10 -0.1,1.5 -0.4,2.8 -1.2,3.8 -0.2,0.2 -0.4,0.5 -0.6,0.7 l -50.2,0 0,-0 c -2.8,-3 -3.3,-5.2 -2.8,-6.8 0.5,-1.6 2.1,-3 4.5,-4.2 4.8,-2.3 11.9,-3.4 15.6,-4.5 3,-1 4.5,-2.8 5.7,-4.6 1.2,-1.8 2.1,-3.6 3.9,-4.9 2.3,-1.7 5.7,-1.9 9.2,-2 3.5,-0.1 7.3,-0.1 10.3,-1.9 2.5,-1.4 4.8,-4.2 7.2,-6.7 2.4,-2.5 4.9,-4.6 7.1,-4.8 0.3,-0 0.5,-0.1 0.8,-0.1 z m -41.9,49 13.6,0 0,10 -13.6,0 z"}],o["GR.IN.IC.STORAGE TOWER"]=[{type:"path",stroke:!1,d:"m 118.3,121 0.4,5.3 0.7,12.8 h 2.9 c 0,-6.1 -1.1,-12.6 -1.1,-18.6 0,-3.4 -0.4,-6.2 -0.4,-9.6 -0.1,-5.3 0.2,-3 2.6,-6.6 l -0.3,-3.1 0,-1.1 h -4.2 V 84 c -2.5,0.6 -5.2,1.8 -8.3,2.6 -2.6,0.6 -6.4,1.4 -9.4,1.4 h -2.4 c -7.6,0 -12.2,-2.6 -18,-4 v 16.2 h -4.2 v 0.7 l -0.3,3.7 3.2,3.7 -2,30.8 h 3.1 v -3.3 l 1.4,-21.7 c 0.5,0.4 2.1,2.7 3,3.6 0.9,0.9 2.4,2.2 3.5,2.9 2.2,1.5 5.6,3.8 8.7,4.1 v 14.4 h 5.6 v -14.4 c 3.7,-0.9 6.2,-2.2 8.8,-4.3 1.4,-1.1 2.2,-1.8 3.4,-3 0.7,-0.7 2.5,-3.2 3,-3.4 v 3.1 l 0.2,3.8 z M 99.7,85.2 c 7.4,0 23,-4.4 25.7,-8.4 -2.8,-1.5 -25.1,-16 -25.3,-16 -0.4,0 -24.9,15.4 -25.5,16.2 2.6,3.5 16.6,8.2 23.3,8.2 h 1.8 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 97.9,85.2 c -4.3,0 -11.7,-2 -17,-4.3 l -0,3.2 c 5.8,1.4 10.4,4 18,4 h 2.4 c 3,0 6.9,-0.8 9.4,-1.4 3,-0.8 5.8,-2 8.3,-2.6 V 80.8 c -6,2.4 -14.4,4.4 -19.3,4.4 H 97.9 z"}],o["GR.IN.IC.SURFACE WATER INTAKE"]=[{type:"path",stroke:!1,d:"M 63.4 75.5 L 63.4 76.3 L 63.4 90.7 L 63.4 91.5 L 64.2 91.5 L 75.7 91.5 C 76.5 96.6 79.8 99.1 83.3 101 C 87.1 102.9 91.3 104.3 93.8 107.5 C 94.8 108.9 94.9 110.7 95.2 112.6 C 95.4 113.6 95.6 114.5 96.2 115.4 C 96.7 116.2 97.5 117 98.8 117.5 C 101.2 118.6 108.7 120.7 115.9 122.4 C 119.6 123.2 123.1 123.9 126 124.3 C 127.5 124.4 128.7 124.5 129.8 124.5 C 130.8 124.4 131.6 124.3 132.2 123.8 C 134.8 121.7 136.1 119.9 136.5 118.3 C 136.8 116.8 136.1 115.4 135 114.4 C 133.9 113.4 132.4 112.5 131 111.7 C 129.7 110.8 128.4 109.9 127.7 108.8 C 124.2 103.6 121 95.5 113.4 91.5 L 119 91.5 L 119.8 91.5 L 119.8 90.7 L 119.8 76.3 L 119.8 75.5 L 119 75.5 L 64.2 75.5 L 63.4 75.5 z M 65 77.1 L 118.2 77.1 L 118.2 89.9 L 109.4 89.9 L 109.4 81.1 L 73.8 81.1 L 73.8 89.9 L 65 89.9 L 65 77.1 z M 76.9 91.5 L 110.5 91.5 C 119.4 94.8 122.7 103.5 126.7 109.5 C 127.6 110.8 129 111.8 130.4 112.7 C 131.8 113.6 133.2 114.4 134.2 115.3 C 135.1 116.2 135.6 117 135.3 118.1 C 135.1 119.2 134 120.8 131.4 122.9 C 131.3 123 130.6 123.2 129.7 123.3 C 128.8 123.3 127.6 123.3 126.2 123.1 C 123.3 122.8 119.8 122.1 116.2 121.3 C 109 119.6 101.5 117.3 99.3 116.4 C 98.2 116 97.6 115.4 97.2 114.8 C 96.8 114.1 96.6 113.3 96.4 112.4 C 96.1 110.6 96 108.5 94.7 106.8 C 91.9 103.2 87.6 101.8 83.9 99.9 C 80.5 98.1 77.7 96.1 76.9 91.5 z "},{type:"path",stroke:!1,fill:!!e&&i,d:"m 76.9,91.5 33.6,0 c 8.9,3.3 12.2,12 16.2,18 0.9,1.3 2.3,2.3 3.7,3.2 1.4,0.9 2.8,1.7 3.8,2.6 0.9,0.9 1.4,1.7 1.2,2.8 -0.2,1.1 -1.3,2.7 -3.9,4.8 -0.2,0.1 -0.8,0.3 -1.7,0.4 -0.9,0 -2.2,-0 -3.6,-0.2 -2.8,-0.3 -6.4,-1 -10,-1.8 -7.2,-1.7 -14.7,-3.9 -16.9,-4.8 -1.1,-0.4 -1.6,-1 -2.1,-1.7 -0.4,-0.7 -0.6,-1.5 -0.8,-2.3 -0.3,-1.8 -0.4,-3.9 -1.7,-5.6 -2.8,-3.6 -7.1,-5 -10.8,-6.9 C 80.5,98.1 77.7,96.1 76.9,91.5 z m -11.9,-14.4 53.2,0 0,12.8 -8.8,0 0,-8.8 -35.6,0 0,8.8 -8.8,0 0,-12.8 z"}],o["GR.IN.IC.WAREHOUSE/STORAGE FACILITY"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:23,text:"STOR"}],o["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]=[{type:"path",stroke:!1,d:"m 107.2,114.8 c 1.9,0 3.9,-1 4.3,-2.4 1.5,1 1.7,2.4 4.6,2.4 h 0.4 c 1.8,0 3.8,-1.1 4.1,-2.4 h 0.4 c 0.4,1.4 2.5,2.4 4.5,2.4 h 0.4 c 2.7,0 3,-1.5 4.5,-2.4 0.4,1.4 2.6,2.4 4.5,2.4 v -1.5 c -2.2,0 -3.5,-1.6 -3.9,-3.4 h -1.5 c -0,1.8 -1.7,3.4 -3.6,3.4 h -0.4 c -2.2,0 -3.6,-1.4 -3.8,-3.4 h -1.7 l -0.2,1.3 c -1,0.7 -1.1,2 -3.3,2 h -0.4 c -3.3,0 -3.2,-3.4 -4.1,-3.4 h -1.3 c -0.2,2 -1.4,3.4 -3.6,3.4 v 1.5 z m -2.2,-33.3 h 32 v 37 h -32 V 81.5 z M 65.1,114.8 v -1.5 c 2,0 3.7,-1.6 3.8,-3.4 h 1.9 c 0,1.8 1.5,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 2.2,0 3.2,-1.6 3.6,-3.4 h 1.7 c 0,2 1.7,3.4 3.8,3.4 v 1.5 c -2,0 -4.1,-1 -4.5,-2.4 -1.4,0.9 -1.7,2.5 -4.6,2.5 h -0.6 c -2.9,0 -3.1,-1.5 -4.5,-2.4 -0.4,1.3 -2.4,2.4 -4.1,2.4 H 74.1 c -2.4,0 -3.4,-1.2 -4.5,-2.4 -0.4,1.4 -2.6,2.4 -4.5,2.4 l 0,0 z M 96.5,93.4 h 6.7 v 13.3 H 96.5 V 93.4 z m -31.4,7.9 c 2,0 3.6,-1.5 3.8,-3.4 h 1.9 c 0.2,1.8 1.4,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.7 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 1.5,0 3.4,-1.5 3.4,-2.6 v -0.8 h 1.9 c 0,1.9 1.8,3.4 3.8,3.4 v 1.5 c -3.6,0 -3.8,-2 -4.9,-2.2 -0.4,1.3 -2.5,2.2 -4.2,2.2 h -0.6 c -1.7,0 -3.8,-1 -4.1,-2.2 -1,0.3 -1.4,2.2 -4.5,2.2 H 74.1 c -2.7,0 -3,-1.3 -4.5,-2.2 -1,1.4 -2.2,2.2 -4.5,2.2 v -1.5 l 0,0 z m 0,-12 c 2,0 3.6,-1.5 3.8,-3.4 h 1.9 c 0.1,1.8 1.4,3.4 3.4,3.4 h 0.4 c 1.8,0 3.5,-1.7 3.6,-3.4 h 1.9 c 0,2 1.7,3.4 3.8,3.4 h 0.2 c 1.5,0 3.4,-1.5 3.4,-2.6 v -0.8 h 1.9 c 0,1.9 1.8,3.4 3.8,3.4 v 1.5 c -3.1,0 -3,-1 -4.7,-2 -1.4,1 -1.7,2.1 -4.4,2.1 h -0.6 c -2.7,0 -2.9,-1.1 -4.3,-2 -1.6,1 -1.6,2 -4.5,2 H 73.9 c -2.4,0 -2.9,-1.2 -4.1,-2 -1.6,1 -1.7,2 -4.7,2 v -1.5 l 0,0 z m 31.4,21.3 h 6.7 v 10.1 h 35.6 V 79.4 L 103.3,79.2 V 89.5 H 96.5 V 79.4 L 61.2,79.2 v 41.6 h 35.4 v -10.1 z m 14.2,-12.2 c 0,1.4 -1.8,2.8 -3.6,2.8 v 1.5 c 3.4,0 3.5,-1.9 4.7,-2.2 0.4,1.3 2.7,2.2 4.5,2.2 h 0.2 c 2.9,0 3,-1.3 4.3,-2.2 1.2,0.9 1.7,2.2 4.3,2.2 h 0.8 c 2.6,0 3,-1.3 4.3,-2.2 1.4,1 1.5,2.2 4.6,2.2 v -1.5 c -1.7,0 -3.8,-1.6 -3.8,-2.8 v -0.6 h -1.7 c -0.1,1.8 -1.6,3.4 -3.6,3.4 h -0.6 c -1.4,0 -3.4,-1.4 -3.4,-2.4 v -0.9 h -1.9 c 0,1.7 -1.7,3.4 -3.5,3.4 h -0.4 c -1.9,0 -3.5,-1.5 -3.6,-3.4 h -1.8 v 0.6 z m 0,-12 c 0,1.4 -1.8,2.8 -3.6,2.8 v 1.5 c 1.8,0 4,-0.9 4.3,-2.2 1.6,1.1 1.7,2.2 4.9,2.2 h 0.4 c 2.6,0 2.9,-1.3 4.3,-2.2 0.3,1.3 2.4,2.3 4.1,2.3 h 0.8 c 2.7,0 3,-1.3 4.5,-2.2 0.4,1.3 2.7,2.2 4.5,2.2 v -1.5 c -1.7,0 -3.8,-1.6 -3.8,-2.8 v -0.6 h -1.7 c -0.1,1.8 -1.6,3.4 -3.6,3.4 h -0.6 c -1.6,0 -3.4,-1.4 -3.4,-2.8 v -0.6 h -1.9 c 0,1.7 -1.7,3.4 -3.5,3.4 h -0.4 c -1.9,0 -3.5,-1.5 -3.6,-3.4 h -1.8 v 0.5 z"},{type:"path",stroke:!1,fill:!!e&&i,d:"m 65.1,114.8 c 1.9,0 4.1,-1 4.5,-2.4 1.1,1.2 2.2,2.4 4.5,2.4 h 0.6 c 1.8,0 3.8,-1.1 4.1,-2.4 1.4,1 1.6,2.4 4.5,2.4 h 0.6 c 2.8,0 3.2,-1.6 4.5,-2.4 0.4,1.4 2.5,2.4 4.5,2.4 v -1.5 c -2.1,0 -3.7,-1.4 -3.8,-3.4 h -1.6 c -0.4,1.8 -1.4,3.4 -3.6,3.4 h -0.2 c -2.1,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.8 -1.7,3.4 -3.6,3.4 H 74.1 c -1.8,0 -3.3,-1.6 -3.4,-3.4 h -1.9 c -0,1.8 -1.8,3.4 -3.8,3.4 v 1.5 l 0,0 z m 0,-13.5 v 1.5 c 2.3,0 3.6,-0.9 4.5,-2.2 1.4,1 1.8,2.2 4.5,2.2 h 0.6 c 3.1,0 3.5,-2 4.5,-2.2 0.4,1.3 2.4,2.2 4.1,2.2 h 0.6 c 1.7,0 3.8,-1 4.1,-2.2 1.1,0.3 1.2,2.2 4.9,2.2 v -1.5 c -2,0 -3.8,-1.4 -3.8,-3.4 h -1.9 v 0.8 c 0,1.2 -1.9,2.6 -3.4,2.6 h -0.2 c -2,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.6 -1.7,3.4 -3.6,3.4 H 74.1 c -2,0 -3.2,-1.5 -3.4,-3.4 h -1.9 c -0.2,1.8 -1.7,3.4 -3.8,3.4 l 0,0 z m 0,-12 v 1.5 c 3,0 3.1,-1 4.7,-2 1.2,0.9 1.7,2 4.1,2 h 0.6 c 2.9,0 2.9,-1 4.5,-2 1.4,0.9 1.6,2 4.3,2 h 0.6 c 2.7,0 2.9,-1.1 4.3,-2 1.6,1.1 1.6,2 4.7,2 v -1.5 c -2,0 -3.8,-1.4 -3.8,-3.4 h -1.9 v 0.8 c 0,1.2 -1.9,2.6 -3.4,2.6 h -0.2 c -2,0 -3.7,-1.4 -3.8,-3.4 h -1.8 c -0,1.7 -1.7,3.4 -3.6,3.4 H 74.1 c -2,0 -3.2,-1.5 -3.4,-3.4 h -1.9 c -0.2,1.8 -1.7,3.4 -3.8,3.4 l 0,0 z m 42.1,25.4 v -1.5 c 2.2,0 3.4,-1.4 3.6,-3.4 h 1.3 c 1,0 0.8,3.4 4.1,3.4 h 0.4 c 2.2,0 2.4,-1.4 3.3,-2.1 l 0.2,-1.3 h 1.7 c 0.2,2 1.6,3.4 3.8,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.5 c 0.4,1.8 1.7,3.4 3.9,3.4 v 1.5 c -1.9,0 -4.1,-1 -4.5,-2.4 -1.5,1 -1.8,2.5 -4.5,2.5 h -0.4 c -2,0 -4.1,-1 -4.5,-2.4 h -0.4 c -0.4,1.3 -2.3,2.4 -4.1,2.4 h -0.4 c -2.9,0 -3.1,-1.4 -4.7,-2.4 -0.4,1.4 -2.4,2.4 -4.3,2.4 z m 3.6,-16.8 h 1.9 c 0,1.8 1.6,3.4 3.5,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 v 0.9 c 0,1 2,2.4 3.4,2.4 h 0.6 c 1.9,0 3.4,-1.6 3.6,-3.4 h 1.7 v 0.6 c 0,1.2 2,2.8 3.8,2.8 v 1.5 c -3.1,0 -3.2,-1.2 -4.7,-2.2 -1.3,0.9 -1.7,2.2 -4.4,2.2 h -0.7 c -2.6,0 -3,-1.3 -4.3,-2.2 -1.3,1 -1.4,2.2 -4.3,2.2 h -0.2 c -1.8,0 -4.2,-1 -4.5,-2.2 -1.2,0.3 -1.2,2.2 -4.7,2.2 v -1.5 c 1.8,0 3.6,-1.4 3.6,-2.8 v -0.6 l 0,0 z m 0,-12 h 1.9 c 0,1.9 1.6,3.4 3.5,3.4 h 0.4 c 1.8,0 3.5,-1.6 3.6,-3.4 h 1.9 v 0.6 c 0,1.4 1.8,2.8 3.4,2.8 h 0.6 c 1.9,0 3.4,-1.6 3.6,-3.4 h 1.7 v 0.6 c 0,1.2 2,2.8 3.8,2.8 v 1.5 c -1.8,0 -4.2,-1 -4.5,-2.2 -1.5,1 -1.8,2.2 -4.6,2.2 h -0.7 c -1.7,0 -3.8,-1 -4.1,-2.2 -1.4,0.9 -1.7,2.2 -4.3,2.2 h -0.4 c -3.1,0 -3.2,-1.2 -4.9,-2.2 -0.4,1.3 -2.5,2.2 -4.3,2.2 v -1.5 c 1.8,0 3.6,-1.4 3.6,-2.8 v -0.6 z m -5.8,32.6 h 32 V 81.5 h -32 v 37 z m -1.7,-11.8 0,-13.3 -6.8,0 0,13.3 z"}],o["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE.TRAFFIC CONTROL POINT"]=[{type:"path",stroke:!1,d:"m 85.5,81.3 0.5,0.7 13.7,18.2 0.3,0.5 0.3,-0.5 13.7,-18.2 0.5,-0.7 -0.9,0 -27.4,0 -0.9,0 z m 1.7,0.9 25.7,0 L 100,99.3 87.2,82.2 z M 106.7,50.7 c 0,0.2 -0,0.5 -0.1,0.7 -0.1,0.2 -0.2,0.4 -0.4,0.5 -0.2,0.2 -0.4,0.3 -0.7,0.4 -0.3,0.1 -0.6,0.1 -1,0.1 l -0.7,0 0,2.1 -0.7,0 0,-5.6 1.5,0 c 0.3,5e-6 0.6,0 0.9,0.1 0.2,0.1 0.4,0.1 0.6,0.3 0.2,0.1 0.4,0.3 0.5,0.5 0.1,0.2 0.2,0.5 0.2,0.8 m -0.8,0 c -1e-5,-0.2 -0,-0.4 -0.1,-0.5 -0.1,-0.1 -0.2,-0.3 -0.3,-0.3 -0.1,-0.1 -0.3,-0.1 -0.4,-0.2 -0.2,-0 -0.3,-0.1 -0.6,-0.1 l -0.7,0 0,2.2 0.6,0 c 0.3,3e-6 0.5,-0 0.7,-0.1 0.2,-0.1 0.3,-0.1 0.5,-0.3 0.1,-0.1 0.2,-0.2 0.2,-0.4 0.1,-0.1 0.1,-0.3 0.1,-0.4 m -3.9,3.5 c -0.1,0.1 -0.3,0.1 -0.4,0.2 -0.1,0.1 -0.3,0.1 -0.4,0.2 -0.2,0 -0.3,0.1 -0.5,0.1 -0.2,0 -0.4,0.1 -0.6,0.1 -0.4,0 -0.8,-0.1 -1.1,-0.2 -0.3,-0.1 -0.6,-0.3 -0.9,-0.5 -0.2,-0.2 -0.4,-0.5 -0.6,-0.9 -0.1,-0.4 -0.2,-0.8 -0.2,-1.3 0,-0.5 0.1,-0.9 0.2,-1.2 0.1,-0.4 0.3,-0.7 0.6,-0.9 0.2,-0.2 0.5,-0.4 0.9,-0.6 0.3,-0.1 0.7,-0.2 1.1,-0.2 0.3,6e-6 0.6,0 0.9,0.1 0.3,0.1 0.6,0.2 1,0.4 l 0,0.9 -0.1,0 c -0.3,-0.3 -0.6,-0.4 -0.9,-0.6 -0.3,-0.1 -0.6,-0.2 -1,-0.2 -0.3,5e-6 -0.5,0 -0.8,0.1 -0.2,0.1 -0.4,0.2 -0.6,0.4 -0.2,0.2 -0.3,0.4 -0.4,0.7 -0.1,0.3 -0.1,0.6 -0.1,1 -10e-7,0.4 0.1,0.7 0.2,1 0.1,0.3 0.2,0.5 0.4,0.7 0.2,0.2 0.4,0.3 0.6,0.4 0.2,0.1 0.5,0.1 0.7,0.1 0.4,10e-7 0.7,-0.1 1,-0.2 0.3,-0.1 0.6,-0.3 0.9,-0.6 l 0.1,0 0,0.9 m -5.1,-4.5 -2,0 0,4.9 -0.7,0 0,-4.9 -2,0 0,-0.7 4.7,0 0,0.7 M 85.9,44.6 l 0,0.4 0,36.5 0,0.4 0.4,0 27.4,0 0.4,0 0,-0.4 0,-36.5 0,-0.4 -0.4,0 -27.4,0 -0.4,0 z m 0.9,0.9 26.5,0 0,35.6 -26.5,0 0,-35.6 z"}],o["AC.M1.RIOT"]=P("RIOT"),o["AC.M1.THREAT"]=P("?"),o["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]=P("ECEP"),o["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]=P("EICC"),o["AC.M1.EMERGENCY OPERATIONS CENTER"]=P("EOC"),o["AC.M1.EMERGENCY SHELTER"]=P("ES"),o["AC.M1.EMERGENCY STAGING AREA"]=P("SA"),o["AC.M1.EMERGENCY"]=P("EMER"),o["AC.M1.COMMERCIAL"]=P("COM"),o["AC.M1.PRODUCTION"]=P("PROD"),o["AC.M1.RETAIL"]=P("RTL"),o["AC.M1.MILITARY ARMORY"]=P("RES"),o["AC.M1.GENERATION STATION"]=P("GEN"),o["AC.M1.EVICTION"]=P("EV"),o["AC.M1.RAID"]=P("RAID"),o["GR.I.FF.CIVILIAN ROTARY WING"]=[{type:"path",stroke:M,d:"M80,70 l10,10 M120,110 l-10,-10 M80,110 l10,-10 M120,70 l-10,10 M100,115 l0,20 M95,135 l10,0",fill:!1},{type:"path",stroke:M,fill:!!e&&i,d:"m 113,90 c -0.3,8.8 -1.9,20.3 -10.8,24.6 -7.7,2 -12.3,-7.1 -13.8,-13.3 -2.6,-11.5 -2.3,-26 6.9,-34.6 6.0,-4.9 13.1,1.9 14.9,7.8 2,4.9 2.8,10.2 2.8,15.5 z"}],o["GR.IC.HOSPITAL SHIP"]=a("AH"),o["GR.IC.LAW ENFORCEMENT VESSEL"]=[{type:"path",fill:(e||!A)&&i,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],o["CY.IC.COMMAND AND CONTROL (C2)"]=a("BC2"),o["CY.IC.HERDER"]=a("HDR"),o["CY.IC.CALLBACK DOMAIN"]=a("CBD"),o["CY.IC.ZOMBIE"]=a("ZMB"),o["CY.IC.ADVANCED PERSISTENT THREAT (APT)"]=a("APT"),o["CY.IC.APT WITH C2"]=a("AC2"),o["CY.IC.APT WITH SELF PROPAGATION"]=a("ASP"),o["CY.IC.APT WITH C2 AND SELF PROPAGATION"]=a("ACS"),o["CY.IC.APT OTHER"]=a("AOT"),o["CY.IC.NON-ADVANCED PERSISTENT THREAT (NAPT)"]=a("NAPT"),o["CY.IC.NAPT WITH C2"]=a("NC2"),o["CY.IC.NAPT WITH SELF PROPAGATION"]=a("NSP"),o["CY.IC.NAPT WITH C2 AND SELF PROPAGATION"]=a("NCS"),o["CY.IC.NAPT OTHER"]=a("NOH"),o["CY.IC.NORMAL"]=a("ON"),o["CY.IC.NETWORK OUTAGE"]=a("OUT"),o["CY.IC.UNKNOWN"]=a("UNK"),o["CY.IC.IMPAIRED"]=a("IMP"),o["CY.IC.CORE ROUTER"]=a("CRT"),o["CY.IC.ROUTER TEXT"]=a("RTR"),o["CY.IC.CROSS DOMAIN SOLUTION"]=a("CDS"),o["CY.IC.MAIL SERVER"]=a("MNP"),o["CY.IC.WEB SERVER"]=a("WSR"),o["CY.IC.DOMAIN SERVER"]=a("DSR"),o["CY.IC.FILE SERVER"]=a("FSR"),o["CY.IC.PEER-TO-PEER NODE"]=a("P2P"),o["CY.IC.FIREWALL TEXT"]=a("FWL"),o["CY.IC.SWITCH TEXT"]=a("SWT"),o["CY.IC.HOST"]=a("HST"),o["CY.IC.VIRTUAL PRIVATE NETWORK (VPN)"]=a("VPN"),o["CY.IC.DEPARTMENT OF DEFENSE (DOD)"]=a("DOD"),o["CY.IC.GOVERNMENT"]=a("GOV"),o["CY.IC.CONTRACTOR"]=a("CTR"),o["CY.IC.SUPERVISORY CONTROL AND DATA ACQUISITION (SCADA)"]=a("SCD"),o["CY.IC.NON-GOVERNMENT"]=a("NGD"),o["CY.IC.INFECTION"]=a("INF"),o["CY.IC.DEGRADATION"]=a("DGD"),o["CY.IC.DATA SPOOFING"]=a("SPF"),o["CY.IC.DATA MANIPULATION"]=a("MSR"),o["CY.IC.EXFILTRATION"]=a("XFL"),o["CY.IC.POWER OUTAGE"]=a("POT"),o["CY.IC.NETWORK OUTAGE"]=a("NOT"),o["CY.IC.SERVICE OUTAGE"]=a("SOT"),o["CY.IC.DEVICE OUTAGE"]=a("DOT"),o["CY.IC.COMBAT MISSION TEAM"]=a("CMT"),o["CY.IC.NATIONAL MISSION TEAM"]=a("NMT"),o["CY.IC.CYBER PROTECTION TEAM"]=a("CPT"),o["CY.IC.INTERNET SERVICE PROVIDER"]=a("ISP"),o["CY.IC.SECURITY"]=a("SEC"),o["CY.IC.OPERATIONS"]=a("OPS"),o["CY.IC.INSIDER"]=a("INS"),o["CY.IC.NETWORK"]=a("NET"),o["CY.IC.DEFENSIVE CYBERSPACE OPERATION"]={type:"path",stroke:!1,d:"m 56.5,113 14,-23 14.1,23 z  m 59.5,0 14,-23 14,23 z  m -30.5,0 14,-23 15.5,23 z"},o["CY.IC.OFFENSIVE CYBERSPACE OPERATION"]={type:"path",stroke:!1,d:"m 61,97 h 62 V 85 l 15,15 -15,15 V 103 H 61 Z"},o["CY.IC.THREAT ACTOR"]={type:"path",strokewidth:1.5,d:"m 96.94,110.2 c 0,-1.6 1.17,-3.1 3.16,-3.1 1.9,0 3.1,1.5 3.1,3.1 0,2 -1.2,3.1 -3.1,3.5 -1.6,0 -3.16,-1.5 -3.16,-3.5 z  m 3.16,-2.3 c -1.21,0 -2.38,0.7 -2.38,2.3 0,1.6 0.78,2.7 2.38,2.7 1.5,0 2.7,-1.1 2.7,-2.7 0,-1.2 -1.2,-2.3 -2.7,-2.3 z  M 89.53,98.89 c -1.17,-1.56 -1.17,-3.51 -0.39,-5.07 1.17,-3.12 2.73,-6.24 4.68,-8.58 1.56,-1.95 3.51,-3.12 5.85,-3.51 2.33,0 3.93,0.78 5.43,2.34 3.1,2.73 5.1,6.63 6.3,10.53 0.8,1.95 0.4,2.73 -0.8,4.68 0,0 0.4,0.39 0.4,0.82 3.1,3.1 5.4,7 7.4,10.9 0.4,0.8 0.8,1.9 1.2,3.1 0.4,2.3 -1.2,4.3 -3.5,4.3 -11,0 -21.5,0 -32.03,0 -2.34,0 -4.29,-2 -3.51,-4.3 0,-1.2 0.78,-2.3 1.17,-3.5 1.95,-3.9 4.29,-7.4 7.02,-10.93 0.39,0 0.39,-0.39 0.78,-0.78 z  m 19.87,17.21 c 0,0 0,0 0,-0.4 0.4,-3.5 0.4,-7.5 0.8,-11 0,-0.7 -0.4,-0.7 -0.8,-0.7 -6.2,0 -12.46,0 -18.31,0 -1.17,0 -1.17,0.4 -1.17,1.1 0.39,2.4 0.39,5.1 0.78,7.8 0,0.8 0,2 0,3.2 6.24,0 12.5,0 18.7,0 z  M 111,96.55 c 0,-1.17 -0.4,-1.95 -0.4,-2.73 -1.2,-3.12 -2.7,-5.46 -4.7,-7.8 -0.8,-1.17 -1.5,-1.56 -2.3,-2.34 -2.4,-1.56 -4.71,-1.56 -7.05,0 -0.78,0.78 -1.56,1.17 -1.95,1.95 -2.34,2.73 -3.9,5.46 -5.07,8.19 0,0.78 -0.39,1.56 -0.39,2.73 5.46,-3.51 16.36,-3.51 21.86,0 z  m -21.08,3.12 c -2.73,2.33 -7.41,10.13 -8.58,13.63 -0.39,0.4 -0.39,1.2 -0.39,2 0,1.1 1.17,2.3 2.34,2.3 1.56,0 3.51,0 5.07,0 0.39,-1.2 0.39,-1.2 1.56,-1.5 0,-0.4 0.39,-0.4 0,-0.8 0,-3.1 -0.39,-6.3 -0.39,-9.4 -0.39,-2.3 -0.39,-2.7 1.95,-2.7 1.17,0 2.34,0 3.51,0 0,0 0,0 0,0 -1.56,-1.2 -3.12,-2.4 -5.07,-3.53 z  m 21.88,17.93 c 1.5,0 3.1,0 4.3,0 1.5,0 3.1,-1.2 2.7,-2.7 0,-1.2 -0.4,-2 -0.8,-3.1 -1.9,-4.3 -4.7,-8.2 -7.8,-11.7 0,-0.43 0,-0.43 -0.4,-0.43 -1.6,1.13 -3.1,2.33 -4.7,3.53 1.2,0 2.8,0 4.3,0 1.2,0 1.6,0.4 1.6,1.9 -0.4,2 -0.4,3.9 -0.4,5.9 -0.4,1.9 -0.4,3.5 -0.4,5.1 1.6,0.3 1.6,0.3 1.6,1.5 z  M 93.82,94.99 c 0.39,4.29 3.12,7.01 6.68,7.01 3.1,-0.4 5.8,-3.5 5.8,-6.62 C 102,94.6 98.11,94.6 93.82,94.99 Z  m 13.28,0.39 c -0.8,3.9 -2.7,7.42 -7,7.42 -4.33,-0.4 -6.28,-3.52 -7.06,-7.42 -0.39,0 -1.17,0.39 -1.56,0.39 -2.34,1.17 -2.34,1.95 -0.39,3.51 1.56,1.22 3.51,2.72 5.46,3.92 0,0 0.39,0 0.78,0 1.95,0 3.87,0 5.47,0 0.4,0 0.8,0 1.2,0 1.5,-1.2 3.5,-2.4 5,-3.53 0.4,-0.39 0.8,-0.78 1.2,-1.17 0.8,-0.78 0.8,-1.17 -0.4,-1.56 -0.8,-0.78 -1.6,-1.17 -2.7,-1.56 z  m -7,21.42 c -3.16,0 -6.67,0 -10.18,0 -0.39,0 -0.39,0.4 -0.78,0.4 0.39,0 0.39,0.4 0.78,0.4 6.63,0 13.68,0 20.28,0 0.4,0 0.8,0 0.8,-0.4 0,0 -0.4,-0.4 -0.8,-0.4 -3.1,0 -6.6,0 -10.1,0 z"},o["CY.IC.APPLICATION"]=[{type:"path",fill:i,stroke:!1,d:"m 85,85 h 30 v 30 H 85 Z"},{type:"path",fill:!1,d:"m 104.9,85 0.1,30  M 95,85 v 30  M 85,104.9 115,105  M 85,95 h 30  M 85,85 h 30 v 30 H 85 Z"}],o["CY.IC.FIREWALL"]={type:"path",fill:!1,d:"m 55.54,112.7 h 7.42 V 83.86 h 14.83 v 0 28.84 H 92.58 V 83.86 h 14.82 v 28.84 h 14.8 V 83.86 H 137 v 0 28.84 0 h 7.5"},o["CY.IC.FIRMWARE"]={type:"path",fill:!1,d:"m 100,107 5,-5  m -5,-9.13 V 107 l -5,-5  m 10.4,9.8 v 5.3  m -5.3,-5.3 v 5.3  m -5.46,-5.3 v 5.3  M 117,105.2 h -5.3  m 5.3,-5.36 h -5.3  m 5.3,-5.42 h -5.3  m -6.3,-11.5 v 5.3  m -5.3,-5.3 v 5.3  m -5.46,-5.3 v 5.3  m -6.36,16.98 h -5.3  m 5.3,-5.36 h -5.3  m 5.3,-5.42 h -5.3  m 10.05,-6 h 13.87 c 2.6,0 4.7,2.12 4.7,4.71 v 13.77 c 0,2.6 -2.1,4.7 -4.7,4.7 H 93.03 c -2.59,0 -4.71,-2.1 -4.71,-4.7 V 93.13 c 0,-2.59 2.12,-4.71 4.71,-4.71 z"},o["CY.IC.SEARCH ENGINE"]=[{type:"path",fill:!1,d:"M 111.9,107.2 101.7,96.99  m 1.9,-5.41 a 6.476,6.476 0 0 1 -6.5,6.48 6.476,6.476 0 0 1 -6.48,-6.48 6.476,6.476 0 0 1 6.48,-6.48 6.476,6.476 0 0 1 6.5,6.48 z  m -37.35,6.59 h 15.87 1.18 l -8.98,16.13 h 50.88 l -8.9,-16.13 h 0.5 17"},{type:"path",d:"M 131.4,106 145,98.17 131.4,90.33 Z  M 68.52,106 55,98.17 68.52,90.33 Z"}],o["CY.IC.SOCIAL MEDIA"]={type:"path",strokewidth:1,d:"m 73.3,108 v 10.1 h 53.4 v -9.5 h -2.2 v 7.3 H 75.52 V 108 Z  m 0,-26.08 v 10.13 h 2.22 v -7.92 h 48.98 v 7.32 h 2.2 V 81.92 Z  M 109.8,91 v 18 l 16,-8.6 z  m 1.6,2.78 11.1,6.52 -11.1,6.1 z  M 84.17,91.16 c -1.23,0 -2.38,0.24 -3.44,0.68 -1.07,0.47 -2.02,1.06 -2.77,1.86 -0.8,0.83 -1.43,1.74 -1.86,2.81 -0.48,1.07 -0.68,2.21 -0.68,3.48 0,1.31 0.2,2.51 0.64,3.61 0.43,1.1 1.02,2 1.82,2.7 0.75,0.8 1.7,1.4 2.77,1.8 1.07,0.5 2.21,0.7 3.48,0.7 0.59,0 1.19,0 1.74,-0.1 0.56,-0.1 1.19,-0.2 1.82,-0.3 V 107 c -0.55,0.1 -1.15,0.2 -1.78,0.3 -0.59,0.1 -1.19,0.2 -1.78,0.2 -1.07,0 -2.02,-0.2 -2.93,-0.6 -0.91,-0.3 -1.66,-0.8 -2.33,-1.5 -0.68,-0.7 -1.15,-1.5 -1.51,-2.4 -0.35,-0.9 -0.51,-1.9 -0.51,-3.01 0,-1.07 0.16,-1.98 0.51,-2.89 0.4,-0.95 0.91,-1.74 1.55,-2.37 0.63,-0.68 1.42,-1.19 2.29,-1.59 0.91,-0.39 1.9,-0.59 2.97,-0.59 1.11,0 2.1,0.2 3.01,0.51 0.87,0.36 1.58,0.87 2.17,1.51 0.6,0.63 1.07,1.42 1.35,2.33 0.32,0.87 0.48,1.9 0.48,3.01 0,0.59 -0.1,1.29 -0.2,1.99 -0.16,0.7 -0.4,1.4 -0.68,1.9 h -2.45 v -8.48 h -1.58 v 0.47 C 85.79,95.6 85.4,95.44 85,95.32 c -0.36,-0.12 -0.79,-0.2 -1.27,-0.2 -1.14,0 -2.17,0.48 -3,1.39 -0.84,0.91 -1.23,2.09 -1.23,3.59 0,1.5 0.36,2.7 1.03,3.6 0.67,0.9 1.58,1.3 2.69,1.3 0.59,0 1.15,-0.1 1.58,-0.3 0.48,-0.3 0.95,-0.6 1.47,-1 l 0.23,1.2 h 4.48 c 0.51,-0.7 0.91,-1.5 1.15,-2.4 0.27,-0.9 0.43,-1.8 0.43,-2.67 0,-1.3 -0.2,-2.45 -0.59,-3.52 -0.36,-1.07 -0.91,-1.98 -1.63,-2.73 -0.71,-0.75 -1.58,-1.35 -2.65,-1.78 -1.03,-0.4 -2.21,-0.64 -3.52,-0.64 z  m -0.16,5.47 c 0.4,0 0.75,0 1.07,0.11 0.36,0.12 0.71,0.24 1.15,0.44 v 5.22 c -0.36,0.3 -0.79,0.5 -1.23,0.7 -0.47,0.2 -0.91,0.3 -1.35,0.3 -0.83,0 -1.46,-0.3 -1.86,-0.8 -0.35,-0.6 -0.59,-1.4 -0.59,-2.5 0,-1.06 0.28,-1.97 0.75,-2.56 0.52,-0.64 1.19,-0.91 2.06,-0.91 z  m 16.39,-4.16 -1.11,4.27 h -3.4 v 1.39 h 3.08 l -0.99,3.77 h -3.32 v 1.3 h 3.01 l -1.07,4.3 h 1.26 l 1.11,-4.3 h 2.73 l -1,4.3 h 1.3 l 1,-4.3 h 3.5 v -1.3 h -3.1 l 0.9,-3.77 h 3.4 v -1.39 h -3 l 1,-4.27 h -1.3 l -1,4.27 h -2.8 l 1.1,-4.27 z  m -0.1,5.66 h 2.7 l -0.9,3.77 h -2.81 z"},o["CY.IC.MALWARE"]={type:"path",strokewidth:1,d:"m 106.3,81.71 c -1.4,0 -2.6,0.39 -3.6,1.08 -1,0.7 -1.7,1.77 -1.7,3.01 a 1.166,1.166 0 0 0 1.2,1.16 1.166,1.166 0 0 0 1.2,-1.16 c 0,-0.36 0.2,-0.75 0.7,-1.11 0.5,-0.37 1.3,-0.65 2.2,-0.65 a 1.166,1.166 0 0 0 1.2,-1.16 1.166,1.166 0 0 0 -1.2,-1.17 z  m -12.51,0.16 a 1.166,1.166 0 0 0 -1.17,1.17 1.166,1.166 0 0 0 1.17,1.17 c 0.88,0 1.67,0.26 2.17,0.62 0.51,0.36 0.7,0.74 0.7,1.12 a 1.166,1.166 0 0 0 1.17,1.17 1.166,1.166 0 0 0 1.17,-1.17 c 0,-1.25 -0.72,-2.33 -1.68,-3.01 -0.97,-0.69 -2.2,-1.06 -3.53,-1.07 z  m 20.71,20.33 -4,0.1 a 1.166,1.166 0 0 0 -1.2,1.1 1.166,1.166 0 0 0 1.2,1.2 l 3.1,0 4.5,3.9 a 1.166,1.166 0 0 0 1.7,-0.2 1.166,1.166 0 0 0 -0.1,-1.6 z  m -29.42,0.1 -4.74,4.2 a 1.166,1.166 0 0 0 -0.1,1.6 1.166,1.166 0 0 0 1.63,0.1 l 4.05,-3.6 3.73,0 a 1.166,1.166 0 0 0 1.16,-1.1 1.166,1.166 0 0 0 -1.16,-1.2 z  m 23.62,7.1 a 1.166,1.166 0 0 0 -0.7,0.6 1.166,1.166 0 0 0 0.4,1.6 l 3.2,1.8 2.4,3.5 a 1.166,1.166 0 0 0 1.7,0.3 1.166,1.166 0 0 0 0.3,-1.6 l -2.7,-4 -3.7,-2.1 a 1.166,1.166 0 0 0 -0.9,-0.1 z  m -17.09,0.2 a 1.166,1.166 0 0 0 -0.89,0 l -3.74,1.8 -2.87,4.2 a 1.166,1.166 0 0 0 0.31,1.7 1.166,1.166 0 0 0 1.63,-0.3 l 2.49,-3.7 3.19,-1.6 a 1.166,1.166 0 0 0 0.54,-1.5 1.166,1.166 0 0 0 -0.66,-0.6 z  M 113.5,88.05 a 1.166,1.166 0 0 0 -1.5,0.78 l -1.5,4.89 -2.5,1.79 a 1.166,1.166 0 0 0 -0.3,1.63 1.166,1.166 0 0 0 1.6,0.31 l 3.2,-2.25 1.8,-5.67 a 1.166,1.166 0 0 0 -0.8,-1.48 z  m -27.14,-0.1 a 1.166,1.166 0 0 0 -0.77,1.48 l 1.9,5.79 3.3,2.29 a 1.166,1.166 0 0 0 1.64,-0.31 1.166,1.166 0 0 0 -0.32,-1.63 l -2.68,-1.83 -1.59,-5.01 a 1.166,1.166 0 0 0 -1.48,-0.78 z  m 13.74,2.04 c -6.47,0 -11.47,6.4 -11.47,13.99 0,7.6 5,14 11.47,14 6.5,0 11.5,-6.4 11.5,-14 0,-7.59 -5,-13.99 -11.5,-13.99 z  m 0,2.34 c 4.9,0 9.1,5.08 9.1,11.65 0,6.6 -4.2,11.7 -9.1,11.7 -4.9,0 -9.14,-5.1 -9.14,-11.7 0,-6.57 4.24,-11.65 9.14,-11.65 z  m -0.1,-8 c -3.62,0 -6.57,2.96 -6.57,6.58 0,0.8 0.15,1.65 0.48,2.46 l 2.16,-0.88 c -0.21,-0.51 -0.3,-1.06 -0.3,-1.58 0,-2.38 1.87,-4.24 4.23,-4.24 2.4,0 4.2,1.86 4.2,4.24 0,0.49 0,0.99 -0.2,1.5 l 2.2,0.72 c 0.2,-0.73 0.4,-1.47 0.4,-2.22 0,-3.62 -3,-6.58 -6.6,-6.58 z"},o["CY.IC.PHISIHNG"]={type:"path",strokewidth:1,d:"m 114.3,97.64 c 0,-0.1 0,-0.16 0,-0.2 -0.1,-0.1 -0.1,-0.12 -0.1,-0.2 -0.1,0 -0.1,-0.1 -0.1,-0.11 v 0 c -0.1,0 -0.1,-0.1 -0.2,-0.12 -0.1,0 -0.1,0 -0.1,-0.1 -0.1,0 -0.2,0 -0.2,0 -0.1,0 -0.1,0 -0.2,0 v 0 H 96.95 V 98.7 H 111 L 99.94,108.9 88.83,98.7 h 3.23 v -1.85 h -5.55 v 0 c -0.1,0 -0.16,0 -0.24,0 0,0 -0.1,0 -0.11,0 0,0 -0.1,0 -0.12,0.1 0,0 -0.12,0.1 -0.16,0.12 v 0 c 0,0 0,0.1 -0.1,0.11 0,0 -0.1,0.12 -0.12,0.2 0,0 0,0.12 0,0.2 0,0 0,0.1 0,0.12 v 19.4 c 0,0 0,0 0,0.1 0,0.1 0,0.1 0,0.2 0,0.1 0.1,0.1 0.12,0.2 0,0 0,0.1 0.1,0.1 v 0 c 0.1,0.1 0.16,0.2 0.28,0.2 0,0 0,0 0,0 0.12,0.1 0.24,0.1 0.36,0.1 h 26.88 c 0.2,0 0.3,0 0.4,-0.1 0,0 0,0 0,0 0.1,0 0.2,-0.1 0.3,-0.2 v 0 c 0.1,0 0.1,-0.1 0.1,-0.1 0,-0.1 0.1,-0.1 0.1,-0.2 0.1,-0.1 0.1,-0.1 0.1,-0.2 0,-0.1 0,-0.1 0,-0.1 V 97.76 c 0,0 0,-0.1 -0.1,-0.12 z  m -26.85,2.24 8.24,7.62 -8.24,7.5 z  m 1.42,16.32 8.15,-7.5 2.33,2.2 c 0.16,0.1 0.39,0.2 0.63,0.2 0.22,0 0.42,-0.1 0.62,-0.2 l 2.3,-2.2 8.2,7.5 z  m 23.63,-1.2 -8.2,-7.6 8.2,-7.56 z  m -8.6,-25 c -1.3,-1.3 -2.3,-2.33 -2.1,-5 0.9,-0.52 1.3,-1.66 0.8,-2.6 -0.5,-0.95 -1.7,-1.3 -2.62,-0.79 -0.95,0.51 -1.3,1.65 -0.79,2.6 0.16,0.27 0.39,0.55 0.67,0.71 -0.28,3.5 1.34,5.04 2.64,6.42 1.2,1.14 2.2,2.16 2.2,4.41 0,0 0,0.1 0,0.11 h 1.2 c 0.3,0 0.5,0 0.7,0.1 0,-0.1 0,-0.11 0,-0.19 0,-3.04 -1.4,-4.49 -2.7,-5.75 z  m -1.2,9.68 c -0.8,0.52 -1.8,0.92 -2.8,0.92 -2.64,0 -4.81,-2.18 -4.81,-4.85 v -0.12 l 1.38,0.9 c 0.44,0.28 1.03,0.16 1.34,-0.27 0.28,-0.43 0.16,-1.03 -0.27,-1.34 l -2.88,-1.93 c -0.43,-0.28 -1.02,-0.16 -1.34,0.28 -0.12,0.15 -0.15,0.35 -0.15,0.51 v 1.93 c 0,3.7 2.99,6.69 6.69,6.69 2.14,0 4.04,-1 5.24,-2.56 h -1.4 c -0.4,0 -0.7,0 -1,-0.16 z"},o["CY.IC.SPEAR PHISIHNG"]={type:"path",stroke:!1,d:"m 120.7,101.2 v 14 c 0,0.1 0,0.1 0,0.2 0,0.1 -0.1,0.3 -0.1,0.4 0,0 -0.1,0.1 -0.2,0.2 0,0.1 0,0.2 -0.1,0.2 v 0 c -0.1,0.1 -0.2,0.2 -0.4,0.3 l -0.1,0.1 c -0.1,0 -0.3,0.1 -0.5,0.1 H 77.05 c -0.18,0 -0.4,-0.1 -0.58,-0.1 v -0.1 c -0.13,-0.1 -0.31,-0.2 -0.45,-0.3 0,0 0,0 0,0 -0.1,0 -0.1,-0.1 -0.1,-0.2 0,-0.1 -0.14,-0.2 -0.18,-0.2 0,-0.1 0,-0.3 0,-0.4 0,-0.1 0,-0.1 0,-0.2 V 84.75 c 0,-0.1 0,-0.13 0,-0.22 0,-0.1 0,-0.23 0,-0.32 0,-0.1 0.1,-0.18 0.18,-0.27 0,0 0,-0.13 0.1,-0.17 0,0 0,0 0,0 0.1,-0.1 0.18,-0.14 0.27,-0.18 0.1,0 0.14,-0.1 0.18,-0.14 0,0 0.14,0 0.18,0 0.14,0 0.23,-0.1 0.36,-0.1 0,0 0,0 0.1,0 h 42.19 c 0,0 0,0 0.1,0 0.1,0 0.2,0 0.3,0 0.1,0 0.2,0 0.2,0 0,0 0.1,0.1 0.2,0.13 0.1,0 0.2,0.14 0.3,0.23 v 0 c 0,0 0,0.13 0,0.17 0.1,0.1 0.2,0.18 0.2,0.27 0.1,0.1 0.1,0.23 0.1,0.32 v 0 c 0,0.1 0,0.13 0,0.22 V 95.2 h -2.9 v -7.13 l -7.6,7 H 106 l 9.6,-8.88 H 80.64 L 98.13,102.3 99.57,101 H 106 l 11.8,10.9 v -10.7 z  m -5.1,12.6 -12.8,-11.8 -3.63,3.3 c -0.27,0.3 -0.63,0.4 -0.99,0.4 -0.36,0 -0.72,-0.1 -0.99,-0.4 L 93.56,102 80.77,113.8 Z  M 78.49,111.9 91.41,100 78.49,88.07 Z  M 139.5,92.24 c -1.9,-1.39 -4.7,-1.34 -7,-0.27 -1.8,0.9 -3.1,2.47 -3.7,4.27 H 94.05 l 3.68,3.86 h 30.87 c 0.3,1.1 0.8,2.1 1.6,3 2.3,2.3 5.8,3 8.7,1.1 l 8.5,-6.08 z  m -2,8.76 c -1.6,0.9 -3.3,0.5 -4.2,-0.5 -0.5,-0.5 -0.8,-1.12 -0.8,-1.8 0,-0.1 0,-0.22 0,-0.31 0,-0.1 0,-0.22 0,-0.31 0.2,-1.13 0.9,-2.02 1.9,-2.52 1.1,-0.53 2.4,-0.53 3.3,0.1 l 4.4,2.65 z  M 89.57,100 85.62,96.19 H 80.01 V 100  m -6.1,-3.81 V 100 H 54.44 c -0.54,0 -0.99,-0.22 -1.3,-0.53 -0.31,-0.32 -0.54,-0.81 -0.54,-1.35 0.1,-1.03 0.99,-1.88 2.02,-1.93 z"},o["CY.IC.WHALE PHISHING"]={type:"path",strokewidth:1,d:"m 75.53,90.41 c -3.34,-0.1 -5.92,0.64 -7.78,2.27 -2.49,2.18 -3.45,5.73 -3.54,10.42 v 0 c -0.14,8.2 6.74,13.9 14.87,13 l -0.24,-2.2 c -7.05,0.9 -12.63,-3.8 -12.51,-10.8 0.1,-4.38 0.99,-7.23 2.81,-8.82 1.82,-1.6 4.83,-2.18 9.66,-1.44 l 0.32,-2.1 c -1.28,-0.19 -2.48,-0.31 -3.59,-0.33 z  m 4.32,-4.72 a 1.06,1.06 0 0 0 -0.92,0.96 1.06,1.06 0 0 0 -0.14,0.14 v 29.31 a 1.06,1.06 0 0 0 0.11,0.3 1.06,1.06 0 0 0 0.1,0.2 1.06,1.06 0 0 0 0.86,0.6 l 40.44,-0.1 a 1.06,1.06 0 0 0 1.1,-1.1 v 0 -29.21 0 a 1.06,1.06 0 0 0 -1.1,-1.1 z  m 2.77,2.16 H 117.4 L 99.71,103.5 Z  m 36.58,1.25 v 24.4 l -13.1,-12.9 z  m -38.29,0.1 12.74,11.6 -12.74,12.7 z  m 23.69,12.8 13.1,12.9 -35.28,0.1 12.8,-12.8 3.76,3.5 a 1.06,1.06 0 0 0 1.42,0 z  m 17.9,-20.17 c 3.7,1.06 7.1,2.29 9.8,5.43 2.7,-2.38 6,-2.93 9.4,-3.39 1.2,3.47 0.6,7.08 -2.4,8.81 -3.8,2.29 -5.2,5.64 -5.9,9.72 -1,5.6 -3.6,10.2 -9.3,12.4 -1,0.4 -2,0.6 -3,0.9 -0.1,-0.1 -0.3,-0.2 -0.4,-0.3 0.3,-0.5 0.5,-1.3 1,-1.4 6.9,-1.9 9.7,-7.2 10.6,-13.7 0.5,-3.29 1.7,-5.88 4.6,-7.62 2.5,-1.52 4.2,-3.6 3.8,-6.99 -3.4,0.34 -6.3,1.61 -8.7,4.07 -2.2,-2.76 -4.5,-5.13 -8.1,-5.85 -0.6,2.5 -0.1,4.66 1.5,6.57 1,1.19 2.1,2.2 3,3.39 3.8,4.45 1.8,10.43 -3.9,11.73 -0.8,0.2 -1.7,0.3 -2.5,0.3 -1.1,-0.1 -1.1,-0.1 -1.1,-1.7 3,0.5 5.3,-0.4 7,-2.9 1.5,-2.09 1.5,-3.87 -0.1,-5.86 -0.9,-1.1 -1.9,-2.08 -2.9,-3.09 -2.7,-2.97 -3.2,-6.45 -2.4,-10.52 z"},o["CY.IC.DOCUMENT"]={type:"path",fill:!1,d:"M 85.6,94.16 H 97.58 V 83.03  M 114.4,116.7 H 85.6 V 94.16 L 97,83.03 h 17.4 z"},o["CY.IC.CRYPTO"]={type:"path",stroke:!1,d:"m 92.23,81 v 7.56 c -0.4,0.36 -0.78,0.76 -1.14,1.19 -2.13,2.59 -3.21,5.89 -3.21,9.94 0,5.31 1.43,9.21 4.28,11.71 0,0 0,0 0.1,0.1 v 7.4 h 3.35 v -5.4 c 1.38,0.6 2.9,0.9 4.59,0.9 1.5,0 2.9,-0.3 4.3,-0.8 v 5.3 h 3.4 v -7.1 c 0.4,-0.3 0.7,-0.6 1,-0.9 1.9,-1.9 3,-4.4 3.3,-7.3 h -3.7 c -0.3,1.8 -0.9,3.3 -1.7,4.4 -1.4,2.1 -3.4,3.1 -6.2,3.1 -2.93,0 -5.16,-1 -6.67,-3 -1.48,-2 -2.23,-4.6 -2.23,-7.8 0,-3.91 0.83,-6.8 2.48,-8.69 1.66,-1.89 3.85,-2.84 6.52,-2.84 2.2,0 3.9,0.52 5.1,1.54 1.2,1.04 2.2,2.43 2.5,4.19 h 3.7 c -0.2,-2.32 -1.4,-4.39 -3.3,-6.23 -0.3,-0.26 -0.5,-0.5 -0.8,-0.72 V 81 h -3.4 v 4.99 c -1.1,-0.29 -2.5,-0.45 -3.8,-0.45 -1.87,0 -3.58,0.3 -5.09,0.91 V 81 Z"},o["CY.IC.PERSONA"]={type:"path",strokewidth:1,d:"M 96.54 81.72 L 84.26 93.66 L 84.26 118.3 L 115.7 118.3 L 115.7 81.72 L 96.54 81.72 z  M 98.53 83.74 L 113.7 83.74 L 113.7 116.3 L 86.28 116.3 L 86.28 95.11 L 95.54 95.11 C 95.38 95.72 95.29 96.38 95.29 97.05 C 95.29 98.5 95.66 99.84 96.34 101 C 94.97 102 93.76 103.4 92.91 105.1 C 91.45 107.8 91.01 111.2 91.57 114.3 C 91.61 114.8 91.98 115.2 92.42 115.2 L 111.3 115.2 C 111.7 115.2 112.1 114.8 112.2 114.4 C 112.8 111.2 112.3 107.9 110.8 105.1 C 110 103.4 108.8 102 107.4 101 C 108 99.84 108.4 98.5 108.4 97.05 C 108.4 93.08 105.5 89.89 101.8 89.89 C 100.6 89.89 99.49 90.25 98.53 90.86 L 98.53 83.74 z  M 96.51 84.57 L 96.51 92.88 C 96.46 92.95 96.42 93.02 96.38 93.08 L 87.76 93.08 L 96.51 84.57 z  M 101.8 91.79 C 104.5 91.79 106.7 94.14 106.7 97.05 C 106.7 99.96 104.5 102.3 101.8 102.3 C 99.13 102.3 96.99 99.96 96.99 97.05 C 96.99 96.36 97.12 95.71 97.34 95.11 L 98.53 95.11 L 98.53 93.21 C 99.39 92.33 100.5 91.79 101.8 91.79 z  M 97.48 102.4 C 98.65 103.5 100.2 104.2 101.8 104.2 C 103.5 104.2 105 103.5 106.2 102.4 C 107.5 103.3 108.5 104.5 109.3 105.9 C 110.5 108.2 110.9 110.6 110.6 113.2 L 93.15 113.2 C 92.87 110.6 93.23 108.2 94.4 105.9 C 95.17 104.5 96.22 103.2 97.48 102.4 z"},o["CY.IC.SERVER"]={type:"path",strokewidth:1,d:"m 112.5,110.4 c -1.2,0 -2.2,1.2 -2.2,2.1 0,1.2 1,2.4 2.2,2.4 1.1,0 2.1,-1.2 2.1,-2.4 0,-0.9 -1,-2.1 -2.1,-2.1 z  m 0,1.6 c 0.2,0 0.5,0.5 0.5,0.9 0,0 -0.3,0.4 -0.5,0.4 -0.3,0 -0.5,-0.4 -0.5,-0.4 0,-0.4 0.2,-0.9 0.5,-0.9 z  m 0,-14.24 c -1.2,0 -2.2,0.82 -2.2,2.04 0,1.2 1,2.5 2.2,2.5 1.1,0 2.1,-1.3 2.1,-2.5 0,-0.81 -1,-2.04 -2.1,-2.04 z  m 0,1.63 c 0.2,0 0.5,0.41 0.5,0.41 0,0.4 -0.3,0.8 -0.5,0.8 -0.3,0 -0.5,-0.4 -0.5,-0.8 0,0 0.2,-0.41 0.5,-0.41 z  m 0,-14.28 c -1.2,0 -2.2,0.82 -2.2,2.04 0,1.23 1,2.04 2.2,2.04 1.1,0 2.1,-0.81 2.1,-2.04 0,-1.22 -1,-2.04 -2.1,-2.04 z  m 0,1.63 c 0.2,0 0.5,0 0.5,0.41 0,0.41 -0.3,0.41 -0.5,0.41 -0.3,0 -0.5,0 -0.5,-0.41 0,-0.41 0.2,-0.41 0.5,-0.41 z  m -29.54,7.35 c -0.9,0 -1.64,0.82 -1.64,1.63 v 8.58 c 0,0.8 0.74,1.6 1.64,1.6 H 117 c 0.9,0 1.7,-0.8 1.7,-1.6 v -8.58 c 0,-0.81 -0.8,-1.63 -1.7,-1.63 z  m 0.1,1.63 H 117 v 8.58 H 83.04 Z  m -0.1,10.98 c -0.9,0 -1.59,0.9 -1.59,1.7 v 8.5 c 0,0.9 0.73,1.7 1.59,1.7 h 34.14 c 0.8,0 1.6,-0.8 1.6,-1.7 v -8.5 c 0,-0.8 -0.7,-1.7 -1.6,-1.7 z  m 0.1,1.7 H 117 v 8.5 H 83.04 Z  m 0.1,-26.96 c -0.98,0 -1.8,0.81 -1.8,1.63 v 8.16 c 0,1.23 0.82,2.04 1.8,2.04 h 33.78 c 0.9,0 1.8,-0.81 1.8,-2.04 v -8.16 c 0,-0.82 -0.9,-1.63 -1.8,-1.63 z  m 0,1.63 h 33.78 c 0,0 0.1,0 0.1,0 v 8.16 c 0,0 -0.1,0 -0.1,0 H 83.12 c -0.1,0 -0.1,0 -0.1,0 v -8.16 z"},o["CY.IC.WORKSTATION"]={type:"path",stroke:!1,d:"M 80.9,81.7 V 113 h 17.2 v 1 H 86.2 v 4 H 113 v -4 h -13 v -1 h 19 V 81.7 Z  m 1.9,2 H 117 V 111 H 82.8 Z"},o["CY.IC.MOBILE"]={type:"path",stroke:!1,d:"M 106,82 H 94.1 c -3,0 -4.2,2.4 -4.2,4.7 V 113 c 0,3 1.2,5 4.2,5 H 106 c 2,0 4,-2 4,-5 V 86.7 c 0,-2.3 -2,-4.7 -4,-4.7 z  m -7.9,32 c 0,-1 1,-1 1.9,-1 1,0 1,0 1,1 0,1 0,2 -1,2 -0.9,0 -1.9,-1 -1.9,-2 z  m -7.3,-3 V 87.8 H 108 V 111 Z  M 104,85.5 c 0,0.4 0,0.8 0,0.8 h -7.9 c -1,0 -1,-0.4 -1,-0.8 0,-0.8 0,-1.1 1,-1.1 h 7.9 c 0,0 0,0.3 0,1.1 z"},o["CY.IC.TABLET"]={type:"path",stroke:!1,d:"m 74.2,113 c 0,3 2,5 4.7,5 H 121 c 3,0 5,-2 5,-5 V 87.2 c 0,-2.7 -2,-4.7 -5,-4.7 H 78.8 c -2.6,0 -4.7,2 -4.7,4.7 z  m 4.7,2 V 84.8 H 119 V 115 Z  M 121,100 c 0,-1.2 0,-2 1,-2 1,0 2,0.8 2,2 0,1 -1,2 -2,2 -1,0 -1,-1 -1,-2 z"},o["CY.IC.LAPTOP"]={type:"path",stroke:!1,d:"m 123,81.9 v 0 H 77 c -1.2,0 -2.5,1.3 -2.5,2.9 V 109 c 0,1 1.3,3 2.5,3 h 46 c 1,0 2,-2 2,-3 V 84.8 c 0,-1.6 -1,-2.9 -2,-2.9 z  M 122,108 H 77.8 V 85.2 H 122 Z  m -52,5 c 0,3 2.9,5 6.2,5 H 123 c 4,0 7,-2 7,-5 z  m 35,3 h -8.9 v -1 h 8.9 z"},o["CY.IC.HEALTH MONITOR"]={type:"path",fill:!1,d:"m 112,98.5 h -8 l -4,6.5 -3.5,-9.9 -2.6,4.9 H 82.7 C 76.3,86.7 92.8,77 100,89 v 0 c 7,-12 24,-2.7 17,11 l -17,16 -11,-10"},o["CY.IC.SMARTVEST"]={type:"path",fill:!1,d:"m 85.3,116 c 0,0 17.7,4 29.7,-1 v 0 -14 l -4,-2.2 3,-14.2 -7,-1.6 c -1,8.6 -13.1,8.6 -14.3,0 l -6.6,1.6 2.3,14.7 -3.1,1.7 v 14 z  m 6.2,-11 h -6.2 v 1 h 6.2 z  m 0,6 h -6.2 v 1 h 6.2 z  m 23.5,-5 h -7 v 0 z  m 0,5 h -7 v 1 h 7 z  M 106,95.2 H 93.5 V 102 H 106 Z  m -10.4,3.6 h 1.6  m 2,0 h 0.8  m 2,0 h 3"},o["CY.IC.SMARTWATCH"]={type:"path",strokewidth:1,d:"M 106,88.5 105,84 c 0,-1.3 -1,-2.5 -1,-2.5 h -9.9 c -1.2,0 -2.4,1.2 -2.8,2.5 l -0.7,4.5 c -1.9,0.3 -3.5,2.3 -3.5,4.7 V 106 c 0,2 1.6,5 3.5,5 l 0.7,4 c 0.4,2 1.6,3 2.8,3 h 9.9 c 0,0 1,-1 1,-3 l 1,-4 c 3,0 4,-3 4,-5 V 93.2 c 0,-2.4 -1,-4.4 -4,-4.7 z  M 93.3,84.2 c 0.3,-0.2 0.3,-0.7 0.8,-0.7 h 9.9 c 0,0 0,0.5 0,0.7 v 4.3 H 92.9 Z  M 104,115 c 0,0 0,1 0,1 h -9.9 c -0.5,0 -0.5,-1 -0.8,-1 l -0.4,-4 H 104 Z  m 4,-9 c 0,2 -1,3 -3,3 H 91.7 C 90.2,109 89,108 89,106 V 93.2 c 0,-1.7 1.2,-2.7 2.7,-2.7 H 105 c 2,0 3,1 3,2.7 z  m 5,-7.8 v 2.8 c 0,0 -1,1 -1,1 -1,0 -1,-1 -1,-1 v -2.8 c 0,-0.5 0,-1 1,-1 0,0 1,0.5 1,1 z"},o["CY.IC.WEARABLE"]=[{type:"path",fill:!1,d:"m 93.1,81.1 h -5.4 l -10.4,9.8 6.4,6.1 4.7,-4.8 c 0.4,-0.4 1.8,0 1.8,0.8 v 26 H 111 V 93 c 0,-0.7 1,-1.1 2,-0.7 l 4,4.7 6,-6.1 -10,-9.8 h -6 c -1,2.6 -5,4.3 -7.3,4.3 -2.7,0 -5.2,-1.7 -6.6,-4.3 z"},{type:"path",fill:!1,strokewidth:2,d:"m 93.25,100.9 c 9.05,0 14.65,5.6 14.65,13.1  m -14.65,-8.4 c 5.24,0 9.95,3.7 9.95,8.4  m -9.95,-4.7 c 2.81,0 5.24,2.8 5.24,4.7  m -4.02,0 c 0,0 -0.28,0 -0.47,0 -0.19,0 -0.65,0 -0.65,0 0,-0.9 0.18,-0.9 0.65,-0.9 0.28,0 0.47,0 0.47,0.9 z"}],o["CY.IC.IOT"]={type:"path",fill:!1,strokewidth:5,d:"M 92.49,83.01 V 101.6  M 100,89.31 a 14.4,14.4 0 0 1 6.9,12.29 v 0 A 14.4,14.4 0 0 1 92.5,116 14.4,14.4 0 0 1 78.1,101.6 14.4,14.4 0 0 1 84.52,89.61  m 26.88,-4.07 h 21.3  m -10.6,0.14 V 114.3  M 67.3,84.11 v 31.59"},o["CY.IC.PRINTER"]={type:"path",strokewidth:1.5,d:"m 89.13,107.9 h 21.77 v 1.2 H 89.13 Z  M 109,97.03 h 6.8 v 1.19 H 109 Z  M 89.13,111.6 h 21.77 v 1.2 H 89.13 Z  m 27.27,6 v -6.2 h 4.4 V 93.22 h -4.4 V 82.35 H 83.59 v 10.87 h -4.35 v 18.18 h 4.35 v 6.2 z  m -1.1,-1.2 H 84.82 v -12 H 115.3 Z  M 84.82,83.51 h 30.48 v 9.67 H 84.82 Z  M 80.47,110.2 V 94.37 h 39.13 v 15.83 h -3.2 v -7 H 83.63 v 7 z"},o["CY.IC.ROUTER"]={type:"path",fill:!1,d:"m 100,81.8 c 10.1,0 18.2,8.14 18.2,18.2 0,10.1 -8.1,18.2 -18.2,18.2 -10.01,0 -18.19,-8.1 -18.19,-18.2 0,-10.02 8.14,-18.2 18.19,-18.2 z  m 3.3,8.22 -3.2,-3.21 -3.26,3.29  m 3.26,7.65 v -10.9  m 6.6,16.35 -3.2,-3.2 3.3,-3.25  m 7.6,3.25 h -10.9  m -6.66,10 3.16,3.2 3.3,-3.3  m -3.2,-7.7 v 10.9  m -6.59,-16.35 3.21,3.21 -3.29,3.24  M 85.74,100 h 10.9"},o["CY.IC.SWITCH"]={type:"path",stroke:!1,d:"M 92.85 81.63 L 88.07 87.39 L 91.08 87.39 L 91.08 98.78 C 91.06 99.01 91.05 99.24 91.05 99.47 C 91.05 101.2 91.58 102.8 92.49 104.2 L 87.09 104.2 L 87.09 101.3 L 81.33 106.1 L 83.93 108.3 L 84.46 108.7 L 87.09 110.9 L 87.09 108 L 99.59 108 C 101.4 108 103 107.5 104.4 106.5 L 104.4 112.6 L 101.4 112.6 L 103.6 115.2 L 104.1 115.7 L 106.2 118.4 L 108.4 115.7 L 108.8 115.2 L 111 112.6 L 108.2 112.6 L 108.2 100.5 L 108.1 100.5 C 108.2 100.2 108.2 99.82 108.2 99.47 C 108.2 97.7 107.6 96.05 106.7 94.69 L 112.9 94.69 L 112.9 97.63 L 115.5 95.45 L 116.1 94.99 L 118.7 92.81 L 112.9 87.99 L 112.9 90.93 L 99.59 90.93 C 97.83 90.93 96.2 91.47 94.84 92.38 L 94.84 87.39 L 97.67 87.39 L 92.85 81.63 z  M 99.59 94.69 C 102.3 94.69 104.4 96.8 104.4 99.47 C 104.4 102.2 102.3 104.2 99.59 104.2 C 96.89 104.2 94.81 102.2 94.81 99.47 L 94.84 99.47 L 94.84 98.94 C 95.1 96.52 97.09 94.69 99.59 94.69 z"},o["CY.M1.DEFENSIVE CYBERSPACE"]={type:"path",stroke:!1,d:"M 67.8,78 78.1,60.9 88.6,78 Z  M 112,78 122,60.9 132,78 Z  M 89.2,78 99.6,60.9 111,78 Z"},o["CY.M1.OFFENSIVE CYBERSPACE"]={type:"path",stroke:!1,d:"m 75,66.7 h 40 V 59 l 10,9.7 -10,9.7 V 70.6 H 75 Z"},o["CY.M1.SOCIAL"]={type:"path",fill:!1,d:"m 107,69.5 h 11  m -6,-2 v 10.9  m 4,-15.6 a 3.87,3.65 0 0 1 -4,3.6 3.87,3.65 0 0 1 -4,-3.6 3.87,3.65 0 0 1 4,-3.7 3.87,3.65 0 0 1 4,3.7 z  M 94.9,69.5 H 105  m -5.1,-2 V 78.4  M 105,62.8 a 4.91,4.64 0 0 1 -5.1,4.6 4.91,4.64 0 0 1 -4.9,-4.6 4.91,4.64 0 0 1 4.9,-4.6 4.91,4.64 0 0 1 5.1,4.6 z  m -22.6,6.7 h 10.5  m -5.4,-2 v 10.9  m 4.3,-15.6 a 3.87,3.65 0 0 1 -3.9,3.6 3.87,3.65 0 0 1 -3.9,-3.6 3.87,3.65 0 0 1 3.9,-3.7 3.87,3.65 0 0 1 3.9,3.7 z"},o["CY.M1.WIRED"]={type:"path",fill:!1,d:"M 98.3,78.9 V 68.2  M 113,78.9 V 68.2  M 84.7,78.9 V 68.2  M 78.3,67.8 H 122  M 91.9,67 V 56.3  M 107,67 V 56.3  M 91.9,67.4 V 56.7  M 107,67.4 V 56.7  M 91.9,67 V 56.3  M 107,67 V 56.3"},o["CY.M1.WIRELESS"]=[{type:"path",stroke:!1,d:"m 85.7,74.3 c 0,-1.9 2.4,-3.9 5.2,-3.9 3.1,0 5.5,2 5.5,3.9 0,2.4 -2.4,4 -5.5,4 -2.8,0 -5.2,-1.6 -5.2,-4 z"},{type:"path",fill:!1,d:"M 114,75.5 C 114,65.3 103,56.6 89.3,56.6  M 109,75.5 c 0,-8.3 -9,-15 -19.7,-15  m 13.7,15 C 103,69.6 96.8,64.9 89.3,64.9"}],o["CY.M1.RADIO FREQUENCY"]=P("RF"),o["CY.M1.OPERATING SYSTEM"]={type:"path",stroke:!1,d:"m 112.3,65.45 2.6,-0.86 c 0.1,-0.56 0.1,-1.15 0.1,-1.7 l -2.6,-1.01 c -0.1,-0.42 -0.3,-0.8 -0.5,-1.14 l 1.3,-2.5 C 113,58 112.9,57.79 112.7,57.58 112.5,57.37 112.2,57.16 112,56.99 l -2.5,1.11 c -0.4,-0.21 -0.8,-0.35 -1.1,-0.49 l -0.9,-2.67 c -0.6,-0.1 -1.1,-0.1 -1.7,0 l -1,2.6 c -0.4,0.1 -0.8,0.24 -1.2,0.42 l -2.5,-1.25 c -0.2,0.17 -0.4,0.35 -0.6,0.55 -0.2,0.18 -0.4,0.38 -0.6,0.59 l 1.1,2.57 c -0.2,0.38 -0.4,0.73 -0.5,1.14 l -2.64,0.84 c -0.1,0.59 -0.11,1.14 -0.1,1.73 l 2.64,1.01 c 0.1,0.38 0.3,0.76 0.4,1.14 l -1.28,2.5 c 0.18,0.21 0.39,0.45 0.58,0.66 0.2,0.2 0.4,0.38 0.6,0.59 l 2.6,-1.15 c 0.3,0.21 0.7,0.38 1.1,0.52 l 0.9,2.67 c 0.5,0.1 1.1,0.1 1.7,0 l 1,-2.6 c 0.4,-0.11 0.8,-0.25 1.2,-0.46 l 2.5,1.29 c 0.2,-0.18 0.4,-0.35 0.6,-0.56 0.2,-0.21 0.4,-0.41 0.6,-0.62 l -1.1,-2.57 c 0.2,-0.34 0.3,-0.73 0.5,-1.11 z  m -2.9,1.22 c -1.8,1.63 -4.5,1.56 -6.2,-0.21 -1.6,-1.74 -1.6,-4.51 0.2,-6.14 1.7,-1.66 4.5,-1.56 6.2,0.17 1.6,1.77 1.5,4.51 -0.2,6.18 z  m -12.27,6.76 2.77,-0.14 c 0.2,-0.52 0.4,-1.07 0.5,-1.63 L 98.17,70 c 0,-0.42 0,-0.84 -0.11,-1.22 l 1.88,-2.08 c -0.11,-0.28 -0.21,-0.52 -0.35,-0.76 -0.14,-0.28 -0.28,-0.52 -0.45,-0.76 l -2.78,0.41 C 96.09,65.31 95.77,65.04 95.43,64.83 L 95.29,62.02 C 94.77,61.81 94.21,61.64 93.66,61.5 l -1.67,2.25 c -0.41,0 -0.79,0 -1.21,0.14 L 88.7,61.98 c -0.24,0.11 -0.52,0.25 -0.76,0.39 -0.25,0.1 -0.49,0.27 -0.73,0.41 l 0.41,2.78 c -0.31,0.27 -0.55,0.62 -0.79,0.93 l -2.81,0.14 c -0.21,0.52 -0.38,1.08 -0.49,1.63 l 2.26,1.67 c 0,0.41 0,0.83 0.1,1.21 l -1.91,2.08 c 0.11,0.24 0.25,0.52 0.38,0.76 0.14,0.28 0.28,0.52 0.42,0.77 l 2.78,-0.42 c 0.31,0.28 0.62,0.56 0.97,0.76 l 0.1,2.81 c 0.52,0.21 1.08,0.38 1.63,0.49 l 1.7,-2.22 c 0.38,0 0.8,0 1.21,-0.14 l 2.05,1.91 c 0.28,-0.11 0.52,-0.25 0.8,-0.38 0.24,-0.11 0.48,-0.28 0.73,-0.42 l -0.42,-2.77 c 0.31,-0.28 0.55,-0.63 0.8,-0.94 z  m -3.12,0.38 c -2.12,1.14 -4.76,0.31 -5.9,-1.8 -1.11,-2.12 -0.31,-4.79 1.8,-5.9 2.15,-1.14 4.79,-0.31 5.9,1.8 1.14,2.12 0.31,4.79 -1.8,5.9 z"},o["CY.M1.CONTINUITY OF OPERATIONS"]={type:"path",strokewidth:1.5,d:"m 101.6,56.69 v 1.17 c 6.4,0.34 10.8,1.53 13.6,3.08 2.8,1.55 3.8,3.38 3.7,5.18 -0.1,1.8 -1.3,3.73 -3.7,5.33 -2.1,1.48 -5.2,2.66 -9,3.17 L 107,72 101.6,75.47 108,78 106.2,75.8 c 3.9,-0.52 7.3,-1.75 9.7,-3.39 2.5,-1.73 4.1,-3.93 4.2,-6.24 0.1,-2.31 -1.3,-4.57 -4.3,-6.25 -3,-1.68 -7.6,-2.88 -14.2,-3.23 z  M 93,55 l 1.01,2.1 c -5.57,0.7 -9.33,2.13 -11.6,4.01 -2.36,1.96 -3.02,4.49 -2.16,6.81 0.85,2.31 3.08,4.4 6.26,5.9 3.18,1.5 7.33,2.4 12.11,2.28 V 74.92 C 93.97,75.05 90,74.17 87.01,72.76 c -2.99,-1.41 -4.97,-3.35 -5.67,-5.25 -0.7,-1.9 -0.26,-3.77 1.82,-5.5 1.99,-1.64 5.54,-3.05 10.94,-3.74 L 94,61 98.6,57.31 Z"},o["CY.M1.INTERNET SERVICE PROVIDER"]=P("ISP"),o["CY.M1.FINANCE"]=P("$"),o["CY.M1.OUT OF BAND"]={type:"path",fill:!1,d:"m 112.3,67.96 a 2.714,2.714 0 0 1 -2.7,2.71 2.714,2.714 0 0 1 -2.7,-2.71 2.714,2.714 0 0 1 2.7,-2.71 2.714,2.714 0 0 1 2.7,2.71 z  m -10.5,0 a 2.714,2.714 0 0 1 -2.74,2.71 2.714,2.714 0 0 1 -2.71,-2.71 2.714,2.714 0 0 1 2.71,-2.71 2.714,2.714 0 0 1 2.74,2.71 z  m -9.66,0 a 2.714,2.714 0 0 1 -2.71,2.71 2.714,2.714 0 0 1 -2.71,-2.71 2.714,2.714 0 0 1 2.71,-2.71 2.714,2.714 0 0 1 2.71,2.71 z  m 21.46,9.63 7.7,-10.4 -7.7,-9.18  m -27.08,0 -7.82,10.31 7.59,9.27"},o["CY.M1.CLOUD"]={type:"path",fill:!1,d:"m 103,55.74 c -3,0 -5.77,1.49 -7.52,3.94 -0.44,-0.13 -0.92,-0.2 -1.41,-0.21 -2.46,0 -4.6,1.65 -5.28,4.01 -3.97,1.05 -6.36,5.12 -5.31,9.1 0.86,3.27 3.83,5.51 7.22,5.51 h 18.7 c 4,0 7.4,-3.29 7.4,-7.41 0,-3.02 -1.8,-5.75 -4.5,-6.9 -0.7,-4.6 -4.6,-8.03 -9.3,-8.04 z"},o["CY.M1.DATA"]={type:"path",fill:!1,d:"m 90.81,63.07 h 7.65 V 55.96  M 90.81,77.5 V 63.07 l 7.29,-7.11 h 11.1 V 77.5 Z"},o["CY.M2.SECURED"]={type:"path",stroke:!1,d:"m 95.66,132 h 8.74 v -3.3 c 0,-1.2 -0.5,-2.2 -1.3,-3.1 -0.9,-0.8 -1.9,-1.2 -3.1,-1.2 -1.14,0 -2.14,0.4 -3.04,1.2 -0.9,0.9 -1.3,1.9 -1.3,3.1 z  m 14.14,1.6 v 9.9 c 0,0.4 -0.2,0.8 -0.5,1.1 -0.3,0.3 -0.7,0.5 -1.1,0.5 H 91.84 c -0.45,0 -0.85,-0.2 -1.17,-0.5 -0.32,-0.3 -0.49,-0.7 -0.49,-1.1 v -9.9 c 0,-0.4 0.17,-0.8 0.49,-1.1 0.32,-0.4 0.72,-0.5 1.17,-0.5 h 0.52 v -3.3 c 0,-2.1 0.8,-3.9 2.3,-5.4 1.5,-1.5 3.3,-2.3 5.34,-2.3 2.1,0 3.9,0.8 5.4,2.3 1.5,1.5 2.2,3.3 2.2,5.4 v 3.3 h 0.6 c 0.4,0 0.8,0.1 1.1,0.5 0.3,0.3 0.5,0.7 0.5,1.1 z"},o["CY.M2.OPEN"]={type:"path",stroke:!1,d:"m 107.7,129 c 0,-1.2 0.3,-2.3 1,-3.1 0.7,-0.9 1.6,-1.3 2.6,-1.3 1,0 1.8,0.4 2.6,1.3 0.6,0.8 1,1.9 1,3.1 v 2.8 h 2.7 V 129 c 0,-2.1 -0.6,-3.9 -1.8,-5.5 -1.3,-1.5 -2.8,-2.2 -4.5,-2.2 -1.7,0 -3.2,0.7 -4.5,2.2 -1.2,1.6 -1.8,3.4 -1.8,5.5 v 2.8 h 2.7 z  m 0.7,2.9 h -0.5 v -0.5 h -3.4 v 0.5 h -8.81 v -0.5 h -3.32 v 0.5 h -0.53 c -0.48,0 -0.85,0.2 -1.17,0.5 -0.33,0.3 -0.49,0.7 -0.49,1.2 v 9.9 c 0,0.5 0.16,0.9 0.49,1.2 0.32,0.3 0.69,0.5 1.17,0.5 h 16.56 c 0.5,0 0.9,-0.2 1.2,-0.5 0.3,-0.3 0.5,-0.7 0.5,-1.2 v -9.9 c 0,-0.5 -0.2,-0.9 -0.5,-1.2 -0.3,-0.3 -0.7,-0.5 -1.2,-0.5 z"},o["CY.M2.RESPONSE ACTIONS"]=r("RA"),o["CY.M2.INTERNAL DEFENSE MEASURES"]=r("IDM"),o["CY.M2.ADVANCED PERSISTENT THREAT"]=[{type:"path",stroke:!1,d:"m 101.3,142.1 a 1.47,1.47 0 0 1 -1.42,1.5 1.47,1.47 0 0 1 -1.47,-1.5 1.47,1.47 0 0 1 1.47,-1.5 1.47,1.47 0 0 1 1.42,1.5 z  m -2.34,-3.1 -0.4,-11.6 2.34,0 -0.3,11.6 z"},{type:"path",fill:!1,d:"m 90.04,126.9 v 9.2 c 0,6.3 9.96,10.4 9.96,10.4 0,0 10,-4.1 10,-10.4 v -9.6 c -3.3,0 -8,-1.2 -10,-3.5 -2.35,2.3 -6.73,3.9 -9.96,3.9 z"}],o["CY.M2.NATION STATE"]=[{type:"path",stroke:!1,d:"m 91.16,142.9 -9.03,-10.5 9.03,-10.5 9.04,10.5 z  m 17.94,0 -8.9,-10.5 8.9,-10.5 8.8,10.5 z"},{type:"path",fill:G,strokewidth:1,d:"m 100,121.6 9.1,10.5 -9.1,10.4 -9.02,-10.4 z"}],o["CY.M2.NATION STATE SPONSORED"]=[{type:"path",fill:G,strokewidth:1,d:"m 100,121.6 9.1,10.5 -9.1,10.4 -9.02,-10.4 z"},{type:"path",stroke:!1,d:"m 91.16,142.9 -9.03,-10.5 9.03,-10.5 9.04,10.5 z  m 17.94,0 -8.9,-10.5 8.9,-10.5 8.8,10.5 z"}],o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""},o["CY.M2."]={type:"path",d:""};for(const n in o)o.hasOwnProperty(n)&&(t.hasOwnProperty(n)&&console.warn("Override of: "+n),s.call(this,o[n],O),t[n]=o[n])}var O={type:"letter",getMetadata:e,getIcons:R,iconParts:[N],icons:function(t,I,E,e){t["S-G-------"]=[],t["S-G-U-----"]=[],t["S-G-UC----"]=[E["GR.IC.COMBAT"]],t["S-G-UCD---"]=[E["GR.IC.FF.AIR DEFENCE"]],t["S-G-UCDS--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE SHORT RANGE"]],t["S-G-UCDSC-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE CHAPARRAL"]],t["S-G-UCDSS-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE STINGER"]],t["S-G-UCDSV-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.FF.MAIN GUN SYSTEM"],E["GR.IC.AIR DEFENSE VULCAN"]],t["S-G-UCDM--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"]],t["S-G-UCDML-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.LIGHT"]],t["S-G-UCDMLA"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCDMM-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.MEDIUM"]],t["S-G-UCDMH-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.MISSILE.HEAVY"]],t["S-G-UCDH--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE H/MAD"]],t["S-G-UCDHH-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE H/MAD HAWK"]],t["S-G-UCDHP-"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE MISSILE"],E["GR.IC.AIR DEFENSE H/MAD PATRIOT"]],t["S-G-UCDG--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE GUN UNIT"]],t["S-G-UCDC--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE COMPOSITE"]],t["S-G-UCDT--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE TARGETING UNIT"]],t["S-G-UCDO--"]=[E["GR.IC.FF.AIR DEFENCE"],E["GR.IC.AIR DEFENSE THEATER MISSILE DEFENSE UNIT"]],t["S-G-UCA---"]=[E["GR.IC.ARMOUR"]],t["S-G-UCAT--"]=[E["GR.IC.ARMOUR"]],t["S-G-UCATA-"]=[E["GR.IC.ARMOUR"],E["GR.M2.AIRBORNE"]],t["S-G-UCATW-"]=[E["GR.IC.ARMOUR"],E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCATWR"]=[E["GR.IC.ARMOUR"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M2.RECOVERY (MAINTENANCE)"]],t["S-G-UCATL-"]=[E["GR.IC.ARMOUR"],E["GR.M2.LIGHT"]],t["S-G-UCATM-"]=[E["GR.IC.ARMOUR"],E["GR.M2.MEDIUM"]],t["S-G-UCATH-"]=[E["GR.IC.ARMOUR"],E["GR.M2.HEAVY"]],t["S-G-UCATR-"]=[E["GR.IC.ARMOUR"],E["GR.M2.RECOVERY (MAINTENANCE)"]],t["S-G-UCAW--"]=[E["GR.IC.ARMOR, WHEELED"]],t["S-G-UCAWS-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCAWA-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.AIRBORNE"]],t["S-G-UCAWW-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCAWWR"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M2.RECOVERY (MAINTENANCE)"]],t["S-G-UCAWL-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.LIGHT"]],t["S-G-UCAWM-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.MEDIUM"]],t["S-G-UCAWH-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.HEAVY"]],t["S-G-UCAWR-"]=[E["GR.IC.ARMOR, WHEELED"],E["GR.M2.RECOVERY (MAINTENANCE)"]],t["S-G-UCAA--"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"]],t["S-G-UCAAD-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"]],t["S-G-UCAAL-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.LIGHT"]],t["S-G-UCAAM-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.AIRBORNE"]],t["S-G-UCAAS-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCAAU-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.MOUNTAIN"]],t["S-G-UCAAC-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.M2.ARCTIC"]],t["S-G-UCAAA-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"]],t["S-G-UCAAAT"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"]],t["S-G-UCAAAW"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],t["S-G-UCAAAS"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.ARMOUR"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCAAO-"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCAAOS"]=[E["GR.IC.FF.ANTITANK/ANTIARMOUR"],E["GR.IC.FF.MOTORIZED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCV---"]=[E["GR.IC.AVIATION ROTARY WING"]],t["S-G-UCVF--"]=[E["GR.IC.AVIATION FIXED WING"]],t["S-G-UCVFU-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.UTILITY"]],t["S-G-UCVFA-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.ATTACK"]],t["S-G-UCVUTP"]=[E["GR.IC.AVIATION TACTICAL AIR CONTROL PARTY"]],t["S-G-UCVUFC"]=[E["GR.IC.AVIATION FORWARD AIR CONTROLLER"]],t["S-G-UCVFR-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.RECON"]],t["S-G-UCVR--"]=e?[E["GR.IC.AVIATION ROTARY WING"],E["GR.IC.AVIATION ROTARY WING 2525C"]]:[E["GR.IC.AVIATION ROTARY WING"]],t["S-G-UCVRA-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.ATTACK"]],t["S-G-UCVRS-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.RECON"]],t["S-G-UCVRW-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.ANTISUBMARINE WARFARE"]],t["S-G-UCVRU-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"]],t["S-G-UCVRUL"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.LIGHT"]],t["S-G-UCVRUM"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.MEDIUM"]],t["S-G-UCVRUH"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UTILITY"],E["GR.M2.HEAVY"]],t["S-G-UCVRUC"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.COMMAND AND CONTROL ROTARY WING"]],t["S-G-UCVRUE"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.MEDEVAC"]],t["S-G-UCVRM-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.MINE COUNTERMEASURE"]],t["S-G-UCVS--"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.PERSONNEL RECOVERY"]],t["S-G-UCVC--"]=[E["GR.IC.AVIATION COMPOSITE"]],t["S-G-UCVV--"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]],t["S-G-UCVU--"]=[E["GR.IC.UNMANNED SYSTEMS"]],t["S-G-UCVUF-"]=[E["GR.IC.AVIATION FIXED WING"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],t["S-G-UCVUR-"]=[E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],t["S-G-UCI---"]=[E["GR.IC.FF.INFANTRY"]],t["S-G-UCIL--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.LIGHT"]],t["S-G-UCIM--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCIO--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.MOUNTAIN"]],t["S-G-UCIA--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.AIRBORNE"]],t["S-G-UCIS--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCIZ--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.ARMOUR"]],t["S-G-UCIN--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.NAVAL"]],t["S-G-UCII--"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.ARMOUR"],E["GR.IC.FF.MAIN GUN SYSTEM"]],t["S-G-UCIC--"]=[E["GR.IC.FF.INFANTRY"],E["GR.M2.ARCTIC"]],t["S-G-UCE---"]=[E["GR.IC.ENGINEER"]],t["S-G-UCEC--"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"]],t["S-G-UCECS-"]=[E["GR.IC.ENGINEER"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCECA-"]=[E["GR.IC.ENGINEER"],E["GR.M2.AIRBORNE"]],t["S-G-UCECC-"]=[E["GR.IC.ENGINEER"],E["GR.M2.ARCTIC"]],t["S-G-UCECL-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.LIGHT"]],t["S-G-UCECM-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.MEDIUM"]],t["S-G-UCECH-"]=[E["GR.IC.ENGINEER"],E["GR.M1.COMBAT"],E["GR.M2.HEAVY"]],t["S-G-UCECT-"]=[L._scale(.7,E["GR.IC.ENGINEER"]),E["GR.IC.ARMOUR"]],t["S-G-UCECW-"]=[E["GR.IC.ENGINEER"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCECO-"]=[E["GR.IC.ENGINEER"],E["GR.M2.MOUNTAIN"]],t["S-G-UCECR-"]=[E["GR.IC.ENGINEER"],E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UCEN--"]=[E["GR.IC.ENGINEER"],E["GR.M1.CONSTRUCTION"]],t["S-G-UCENN-"]=[E["GR.IC.ENGINEER"],E["GR.M1.NAVAL"]],t["S-G-UCF---"]=[E["GR.IC.FIELD ARTILLERY"]],t["S-G-UCFH--"]=[E["GR.IC.FIELD ARTILLERY"]],t["S-G-UCFHE-"]=[L._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.IC.ARMOUR"]],t["S-G-UCFHS-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCFHA-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.AIRBORNE"]],t["S-G-UCFHC-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.ARCTIC"]],t["S-G-UCFHO-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.MOUNTAIN"]],t["S-G-UCFHL-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.LIGHT"]],t["S-G-UCFHM-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.MEDIUM"]],t["S-G-UCFHH-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.HEAVY"]],t["S-G-UCFHX-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCFR--"]=[E["GR.IC.FF.FIELD ARTILLERY ROCKET"]],t["S-G-UCFRS-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"]],t["S-G-UCFRS-"]=[L._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.M1.SINGLE ROCKET LAUNCHER"],e?[]:E["GR.IC.ARMOUR"]],t["S-G-UCFRSS"]=[L._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.IC.ARMOUR"]],t["S-G-UCFRSR"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.M2.TRUCK"]],t["S-G-UCFRST"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.SINGLE ROCKET LAUNCHER"],E["GR.M2.TOWED"]],t["S-G-UCFRM-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],e?"":E["GR.M2.CROSS-COUNTRY TRUCK"]],t["S-G-UCFRMS"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.IC.ARMOUR"]],t["S-G-UCFRMR"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.M2.TRUCK"]],t["S-G-UCFRMT"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.MULTIPLE ROCKET LAUNCHER"],E["GR.M2.TOWED"]],t["S-G-UCFT--"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M2.TARGET ACQUISITION"]],t["S-G-UCFTR-"]=[L._translate(-30,10,L._scale(.6,E["GR.IC.FIELD ARTILLERY"])),E["GR.IC.RADAR"]],t["S-G-UCFTS-"]=[L._translate(0,30,L._scale(.7,E["GR.IC.FIELD ARTILLERY"])),E["GR.IC.FF.SOUND"]],t["S-G-UCFTF-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.M1.OPTICAL"],E["GR.M2.TARGET ACQUISITION"]],t["S-G-UCFTC-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.MOTORIZED"],E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UCFTCD"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UCFTCM"]=[L._scale(.8,E["GR.IC.FIELD ARTILLERY"]),E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"]],t["S-G-UCFTA-"]=[E["GR.IC.FIELD ARTILLERY"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.AVIATION ROTARY WING"],E["GR.M1.NAVAL"]],t["S-G-UCFM--"]=[E["GR.IC.MORTAR"]],t["S-G-UCFMS-"]=[E["GR.IC.MORTAR"],E["GR.M2.TRACKED"]],t["S-G-UCFMW-"]=t["S-G-UCFMSW"]=[E["GR.IC.MORTAR"],E["GR.M2.TRUCK"]],t["S-G-UCFMT-"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"]],t["S-G-UCFMTA"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M2.AIRBORNE"]],t["S-G-UCFMTS"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCFMTC"]=[E["GR.IC.MORTAR"],E["GR.M2.ARCTIC"]],t["S-G-UCFMTO"]=[E["GR.IC.MORTAR"],E["GR.M2.TOWED"],E["GR.M2.MOUNTAIN"]],t["S-G-UCFML-"]=[L._translate(0,-20,E["GR.IC.MORTAR"]),E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCFS--"]=[E["GR.IC.SURVEY"]],t["S-G-UCFSS-"]=[E["GR.IC.SURVEY"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCFSA-"]=[E["GR.IC.SURVEY"],E["GR.M2.AIRBORNE"]],t["S-G-UCFSL-"]=[E["GR.IC.SURVEY"],E["GR.M2.LIGHT"]],t["S-G-UCFSO-"]=[E["GR.IC.SURVEY"],E["GR.M2.MOUNTAIN"]],t["S-G-UCFO--"]=[E["GR.IC.METEOROLOGICAL"]],t["S-G-UCFOS-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCFOA-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.AIRBORNE"]],t["S-G-UCFOL-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.LIGHT"]],t["S-G-UCFOO-"]=[E["GR.IC.METEOROLOGICAL"],E["GR.M2.MOUNTAIN"]],t["S-G-UCR---"]=[E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UCRH--"]=[E["GR.IC.FF.HORSE"]],t["S-G-UCRV--"]=[E["GR.IC.FF.RECONNAISSANCE"],e?E["GR.M2.CAVALRY"]:[]],t["S-G-UCRVA-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"]],t["S-G-UCRVM-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCRVG-"]=[E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UCRVO-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.AVIATION ROTARY WING"]],t["S-G-UCRC--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.ARCTIC"]],t["S-G-UCRS--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M1.AIRMOBILE/AIR ASSAULT"]],t["S-G-UCRA--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.AIRBORNE"]],t["S-G-UCRO--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.MOUNTAIN"]],t["S-G-UCRL--"]=t["S-G-UCRLL-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.M2.LIGHT"]],t["S-G-UCRR--"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCRRD-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"],e?E["GR.M1.MARINE DIVISION"]:[]],t["S-G-UCRRF-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.FF.AMPHIBIOUS"],E["GR.M1.FORCE"]],t["S-G-UCRRL-"]=[E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],t["S-G-UCRX--"]=[E["GR.IC.FF.RECONNAISSANCE"],e?E["GR.M2.LONG RANGE SURVEILLANCE"]:[L._translate(0,-20,E["GR.M2.MOUNTAIN"]),E["GR.M2.LONG RANGE"]]],t["S-G-UCM---"]=[E["GR.IC.MISSILE"]],t["S-G-UCMT--"]=[E["GR.IC.MISSILE"],E["GR.M2.TACTICAL MISSILE"]],t["S-G-UCMS--"]=[E["GR.IC.MISSILE"],E["GR.M2.STRATEGIC MISSILE"]],t["S-G-UCS---"]=[E["GR.IC.SECURITY"]],t["S-G-UCSW--"]=[L._translate(0,-20,E["GR.IC.SECURITY"]),E["GR.IC.FF.AMPHIBIOUS"]],t["S-G-UCSG--"]=[E["GR.IC.SECURITY"]],t["S-G-UCSGD-"]=[E["GR.IC.SECURITY"],E["GR.IC.FF.INFANTRY"]],t["S-G-UCSGM-"]=[E["GR.IC.SECURITY"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UCSGA-"]=[E["GR.IC.SECURITY"],E["GR.IC.ARMOUR"]],t["S-G-UCSM--"]=[E["GR.IC.SECURITY"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],t["S-G-UCSR--"]=[E["GR.IC.SECURITY"],E["GR.M2.RAILROAD"]],t["S-G-UCSA--"]=[L._translate(0,-20,E["GR.IC.SECURITY"]),E["GR.IC.AVIATION ROTARY WING"]],t["S-G-F-S---"]=E["GR.IC.SURVEILLANCE"],t["S-G-UU----"]=[E["GR.IC.COMBAT SUPPORT"]],t["S-G-UUA---"]=[E["GR.IC.CBRN"]],t["S-G-UUAC--"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"]],t["S-G-UUACC-"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"]],t["S-G-UUACCK"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"],E["GR.IC.ARMOUR"]],t["S-G-UUACCM"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE/DECON"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UUACS-"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"]],t["S-G-UUACSM"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"],E["GR.IC.FF.MOTORIZED"]],t["S-G-UUACSA"]=[E["GR.IC.CBRN"],E["GR.M1.SMOKE"],E["GR.IC.ARMOUR"]],t["S-G-UUACR-"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"],E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UUACRW"]=[E["GR.IC.CBRN"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],t["S-G-UUACRS"]=[E["GR.IC.CBRN"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"],e?E["GR.M1.CHEMICAL SURVEILLANCE"]:[]],t["S-G-UUAN--"]=[E["GR.IC.CBRN"],E["GR.M1.NUCLEAR"]],t["S-G-UUAB--"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"]],t["S-G-UUABR-"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"],E["GR.IC.FF.MOTORIZED"],E["GR.IC.FF.RECONNAISSANCE"]],t["S-G-UUAD--"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"]],t["S-G-UUADT-"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.TROOP"]],t["S-G-UUADE-"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.EQUIPMENT"]],t["S-G-UUADET"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"],E["GR.M2.EQUIMENT/TROOP"]],t["S-G-UUAL--"]=[E["GR.IC.CBRN"],E["GR.M2.LABORATORY"]],t["S-G-UUM---"]=[E["GR.IC.MILITARY INTELLIGENCE"]],t["S-G-UUMA--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.UNMANNED AERIAL VEHICLE"]],t["S-G-UUMS--"]=[L._translate(-25,0,E["GR.IC.MILITARY INTELLIGENCE"]),E["GR.IC.RADIO"]],t["S-G-UUMSE-"]=[E["GR.IC.ELECTRONIC WARFARE"]],t["S-G-UUMSEA"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.RECONNAISSANCE"],E["GR.IC.ARMOUR"],E["GR.M2.WHEELED"]],t["S-G-UUMSED"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.DIRECTION FINDING"]],t["S-G-UUMSEI"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.INTERCEPT"]],t["S-G-UUMSEJ"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.JAMMING"]],t["S-G-UUMSET"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-UUMSEC"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-UUMC--"]=[E["GR.IC.COUNTER-INTELLIGENCE"]],t["S-G-UUMR--"]=[E["GR.IC.MILITARY INTELLIGENCE"]],t["S-G-UUMRG-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.RADAR"]],t["S-G-UUMRS-"]=[L._translate(0,30,L._scale(.8,E["GR.IC.MILITARY INTELLIGENCE"])),E["GR.IC.FF.SENSOR"]],t["S-G-UUMRSS"]=[L._translate(0,30,L._scale(.8,E["GR.IC.MILITARY INTELLIGENCE"])),E["GR.IC.FF.SENSOR"],E["GR.M1.SENSOR CONTROL MODULE"]],t["S-G-UUMRX-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.GROUND STATION MODULE"]],t["S-G-UUMMO-"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.METEOROLOGICAL"]],t["S-G-UUMO--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.OPERATIONS"]],t["S-G-UUMT--"]=[E["GR.IC.MILITARY INTELLIGENCE"],E["GR.M1.TACTICAL EXPLOITATION"]],t["S-G-UUMQ--"]=[E["GR.IC.INTERROGATION"]],t["S-G-UUMJ--"]=[E["GR.IC.JOINT INTELLIGENCE CENTRE"]],t["S-G-UUL---"]=[E["GR.IC.FF.MILITARY POLICE"],E["GR.IC.MILITARY POLICE"]],t["S-G-UULS--"]=[E["GR.IC.SHORE PATROL"]],t["S-G-UULM--"]=[E["GR.IC.MILITARY POLICE"]],t["S-G-UULC--"]=[E["GR.IC.LAW ENFORCEMENT"]],t["S-G-UULF--"]=[L._translate(0,-25,L._scale(.8,E["GR.IC.SHORE PATROL"])),E["GR.IC.AVIATION FIXED WING"]],t["S-G-UULD--"]=[E["GR.IC.CRIMINAL INVESTIGATION DIVISION"]],t["S-G-UUS---"]=[E["GR.IC.FF.SIGNAL"]],t["S-G-UUSA--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.AREA"]],t["S-G-UUSC--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]],t["S-G-UUSCL-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.LARGE COMMUNICATIONS CONTINGENCY PACKAGE"],E["GR.M2.AIRBORNE"]],t["S-G-UUSO--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.OPERATIONS"]],t["S-G-UUSF--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.FORWARD"]],t["S-G-UUSM--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]],t["S-G-UUSMS-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.SMALL EXTENSION NODE"]],t["S-G-UUSML-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.LARGE EXTENSION NODE"]],t["S-G-UUSMN-"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.NODE CENTRE"]],t["S-G-UUSR--"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO"]],t["S-G-UUSRS-"]=[E["GR.IC.FF.SIGNAL"],E["GR.I.FF.SATELLITE"]],t["S-G-UUSRT-"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO TELETYPE CENTRE"]],t["S-G-UUSRW-"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.RADIO RELAY"]],t["S-G-UUSS--"]=[E["GR.IC.FF.SIGNAL"],E["GR.M1.SIGNAL SUPPORT"]],t["S-G-UUSW--"]=[E["GR.IC.FF.SIGNAL"],E["GR.IC.TELEPHONE SWITCH"]],t["S-G-UUSX--"]=[E["GR.IC.ELECTRONIC RANGING"]],t["S-G-UUI---"]=[E["GR.IC.INFORMATION OPERATIONS"]],t["S-G-UUP---"]=t["S-G-UUX---"]=[E["GR.IC.FF.AMPHIBIOUS"],E["GR.M1.LANDING SUPPORT"]],t["S-G-UUE---"]=[E["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],t["S-G-UUT---"]=[E["GR.IC.TOPOGRAPHIC"]],t["S-G-UUD---"]=[E["GR.IC.DRILLING"]],t["S-G-US----"]=[E["GR.IC.COMBAT SERVICE SUPPORT"]],t["S-G-USA---"]=[E["GR.IC.ADMINISTRATIVE"]],t["S-G-USAT--"]=[E["GR.IC.ADMINISTRATIVE"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAC--"]=[E["GR.IC.ADMINISTRATIVE"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAJ--"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"]],t["S-G-USAJT-"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAJC-"]=[E["GR.IC.JUDGE ADVOCATE GENERAL"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAO--"]=[E["GR.IC.POSTAL"]],t["S-G-USAOT-"]=[E["GR.IC.POSTAL"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAOC-"]=[E["GR.IC.POSTAL"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAF--"]=[E["GR.IC.FINANCE"]],t["S-G-USAFT-"]=[E["GR.IC.FINANCE"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAFC-"]=[E["GR.IC.FINANCE"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAS--"]=[E["GR.IC.PERSONNEL SERVICES"]],t["S-G-USAST-"]=[E["GR.IC.PERSONNEL SERVICES"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USASC-"]=[E["GR.IC.PERSONNEL SERVICES"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAM--"]=[E["GR.IC.MORTUARY AFFAIRS"]],t["S-G-USAMT-"]=[E["GR.IC.MORTUARY AFFAIRS"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAMC-"]=[E["GR.IC.MORTUARY AFFAIRS"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAR--"]=[E["GR.IC.RELIGIOUS SUPPORT"]],t["S-G-USART-"]=[E["GR.IC.RELIGIOUS SUPPORT"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USARC-"]=[E["GR.IC.RELIGIOUS SUPPORT"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAP--"]=[E["GR.IC.PUBLIC AFFAIRS"]],t["S-G-USAPT-"]=[E["GR.IC.PUBLIC AFFAIRS"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAPC-"]=[E["GR.IC.PUBLIC AFFAIRS"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAPB-"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"]],t["S-G-USAPBT"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAPBC"]=[E["GR.IC.PUBLIC AFFAIRS BROADCAST"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAPM-"]=[E["GR.IC.JOINT INFORMATION BUREAU"]],t["S-G-USAPMT"]=[E["GR.IC.JOINT INFORMATION BUREAU"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAPMC"]=[E["GR.IC.JOINT INFORMATION BUREAU"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAX--"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"]],t["S-G-USAXT-"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAXC-"]=[E["GR.IC.REPLACEMENT HOLDING UNIT"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAL--"]=[E["GR.IC.LABOUR"]],t["S-G-USALT-"]=[E["GR.IC.LABOUR"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USALC-"]=[E["GR.IC.LABOUR"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAW--"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"]],t["S-G-USAWT-"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAWC-"]=[E["GR.IC.MORALE, WELFARE, AND RECREATION"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USAQ--"]=[E["GR.IC.QUARTERMASTER"]],t["S-G-USAQT-"]=[E["GR.IC.QUARTERMASTER"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USAQC-"]=[E["GR.IC.QUARTERMASTER"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USM---"]=[E["GR.IC.FF.MEDICAL"]],t["S-G-USMT--"]=[E["GR.IC.FF.MEDICAL THEATER"]],t["S-G-USMC--"]=[E["GR.IC.FF.MEDICAL CORPS"]],t["S-G-USMM--"]=[E["GR.IC.FF.MEDICAL"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t["S-G-USMMT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t["S-G-USMMC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t["S-G-USMV--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.VETERINARY"]],t["S-G-USMVT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.VETERINARY"]],t["S-G-USMVC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.VETERINARY"]],t["S-G-USMD--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.DENTAL"]],t["S-G-USMDT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.DENTAL"]],t["S-G-USMDC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.DENTAL"]],t["S-G-USMP--"]=[E["GR.IC.FF.MEDICAL"],E["GR.M2.PSYCHOLOGICAL"]],t["S-G-USMPT-"]=[E["GR.IC.FF.MEDICAL THEATER"],E["GR.M2.PSYCHOLOGICAL"]],t["S-G-USMPC-"]=[E["GR.IC.FF.MEDICAL CORPS"],E["GR.M2.PSYCHOLOGICAL"]],t["S-G-USS---"]=[E["GR.IC.FF.SUPPLY"]],t["S-G-USST--"]=[E["GR.IC.FF.SUPPLY THEATER"]],t["S-G-USSC--"]=[E["GR.IC.FF.SUPPLY CORPS"]],t["S-G-USS1--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS I"]],t["S-G-USS1T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS I"]],t["S-G-USS1C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS I"]],t["S-G-USS2--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS II"]],t["S-G-USS2T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS II"]],t["S-G-USS2C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS II"]],t["S-G-USS3--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS III"]],t["S-G-USS3T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS III"]],t["S-G-USS3C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS III"]],t["S-G-USS3A-"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS III"],L._translate(25,5,L._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],t["S-G-USS3AT"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS III"],L._translate(25,5,L._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],t["S-G-USS3AC"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS III"],L._translate(25,5,L._scale(.5,E["GR.IC.AVIATION ROTARY WING"]))],t["S-G-USS4--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS IV"]],t["S-G-USS4T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS IV"]],t["S-G-USS4C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS IV"]],t["S-G-USS5--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS V"]],t["S-G-USS5T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS V"]],t["S-G-USS5C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS V"]],t["S-G-USS6--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VI"]],t["S-G-USS6T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VI"]],t["S-G-USS6C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VI"]],t["S-G-USS7--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VII"]],t["S-G-USS7T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VII"]],t["S-G-USS7C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VII"]],t["S-G-USS8--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS VIII"]],t["S-G-USS8T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS VIII"]],t["S-G-USS8C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS VIII"]],t["S-G-USS9--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS IX"]],t["S-G-USS9T-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS IX"]],t["S-G-USS9C-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS IX"]],t["S-G-USSX--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.CLASS X"]],t["S-G-USSXT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.FF.CLASS X"]],t["S-G-USSXC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.FF.CLASS X"]],t["S-G-USSL--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.LAUNDRY/BATH"]],t["S-G-USSLT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.LAUNDRY/BATH"]],t["S-G-USSLC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.LAUNDRY/BATH"]],t["S-G-USSW--"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER"]],t["S-G-USSWT-"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.WATER"]],t["S-G-USSWC-"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.WATER"]],t["S-G-USSWP-"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER PURIFICATION"]],t["S-G-USSWPT"]=[E["GR.IC.FF.SUPPLY THEATER"],E["GR.IC.WATER PURIFICATION"]],t["S-G-USSWPC"]=[E["GR.IC.FF.SUPPLY CORPS"],E["GR.IC.WATER PURIFICATION"]],t["S-G-UST---"]=[E["GR.IC.TRANSPORTATION"]],t["S-G-USTT--"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"]],t["S-G-USTC--"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"]],t["S-G-USTM--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],t["S-G-USTMT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],t["S-G-USTMC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MOVEMENT CONTROL CENTRE"]],t["S-G-USTR--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],t["S-G-USTRT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],t["S-G-USTRC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.RAILROAD"]],t["S-G-USTS--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],t["S-G-USTST-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],t["S-G-USTSC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.NAVAL"]],t["S-G-USTA--"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],t["S-G-USTAT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],t["S-G-USTAC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],t["S-G-USTI--"]=[E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],t["S-G-USTIT-"]=[E["GR.IC.FF.THEATRE SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],t["S-G-USTIC-"]=[E["GR.IC.FF.CORPS SUPPORT"],E["GR.IC.TRANSPORTATION"],E["GR.M1.MISSILE"]],t["S-G-USX---"]=[E["GR.IC.MAINTENANCE"]],t["S-G-USXT--"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"]],t["S-G-USXC--"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"]],t["S-G-USXH--"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.HEAVY"]],t["S-G-USXHT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M2.HEAVY"]],t["S-G-USXHC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M2.HEAVY"]],t["S-G-USXR--"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.RAILROAD"]],t["S-G-USXRT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M2.RAILROAD"]],t["S-G-USXRC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M2.RAILROAD"]],t["S-G-USXO--"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.AMMUNITION"]],t["S-G-USXOT-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.AMMUNITION"]],t["S-G-USXOC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.AMMUNITION"]],t["S-G-USXOM-"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.MISSILE"]],t["S-G-USXOMT"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.MISSILE"]],t["S-G-USXOMC"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.MISSILE"]],t["S-G-USXE--"]=[E["GR.IC.MAINTENANCE"],E["GR.M1.ELECTRO-OPTICAL"]],t["S-G-USXET-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.THEATRE SUPPORT"],E["GR.M1.ELECTRO-OPTICAL"]],t["S-G-USXEC-"]=[E["GR.IC.MAINTENANCE"],E["GR.IC.FF.CORPS SUPPORT"],E["GR.M1.ELECTRO-OPTICAL"]],t["S-G-USXBDR"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.BATTLE DAMAGE REPAIR"]],t["S-G-USXPM-"]=[E["GR.IC.MAINTENANCE"],E["GR.M2.PREVENTIVE MAINTENANCE"]],t["S-G-USXP--"]=[E["GR.IC.PIPELINE"]],t["S-G-USXEP-"]=[E["GR.IC.ENVIRONMENTAL PROTECTION"]],t["S-G-UH----"]=[],t["S-G-UH1---"]=[E["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],t["S-G-UH2---"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],t["S-G-UHGL--"]=t["S-G-GL----"]=[E["GR.IC.LIAISON"]]}},i={type:"letter",getMetadata:e,getIcons:R,iconParts:[N],icons:function(t,I,E,e){t["S-G-E-----"]=[],t["S-G-EW----"]=[],t["S-G-EWM---"]=[E["GR.EQ.MISSILE LAUNCHER"]],t["S-G-EWMA--"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]],t["S-G-EWMAS-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWMASR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t["S-G-EWMASE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.SHORT RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t["S-G-EWMAI-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWMAIR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t["S-G-EWMAIE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.INTERMEDIATE RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t["S-G-EWMAL-"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"]],t["S-G-EWMALR"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t["S-G-EWMALE"]=[E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],E["GR.EQ.LONG RANGE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t["S-G-EWMAT-"]=[L._translate(0,-15,L._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"]],t["S-G-EWMATR"]=[L._translate(0,-15,L._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t["S-G-EWMATE"]=[L._translate(0,-15,L._scale(.7,E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"])),E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR THEATRE"],E["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t["S-G-EWMS--"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]],t["S-G-EWMSS-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWMSI-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWMSL-"]=[E["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],E["GR.EQ.LONG RANGE"]],t["S-G-EWMT--"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"]],t["S-G-EWMTL-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWMTM-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWMTH-"]=[E["GR.EQ.ANTITANK MISSILE LAUNCHER"],E["GR.EQ.LONG RANGE"]],t["S-G-EWS---"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"]],t["S-G-EWSL--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWSM--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWSH--"]=[E["GR.EQ.SINGLE ROCKET LAUNCHER"],E["GR.EQ.LONG RANGE"]],t["S-G-EWX---"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"]],t["S-G-EWXL--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,E["GR.EQ.SHORT RANGE"])],t["S-G-EWXM--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,E["GR.EQ.INTERMEDIATE RANGE"])],t["S-G-EWXH--"]=[E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,E["GR.EQ.LONG RANGE"])],t["S-G-EWT---"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"]],t["S-G-EWTL--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWTM--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWTH--"]=[E["GR.EQ.ANTITANK ROCKET LAUNCHER"],E["GR.EQ.LONG RANGE"]],t["S-G-EWR---"]=[E["GR.EQ.RIFLE"]],t["S-G-EWRR--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWRL--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWRH--"]=[E["GR.EQ.RIFLE"],E["GR.EQ.LONG RANGE"]],t["S-G-EWZ---"]=[E["GR.EQ.GRENADE LAUNCHER"]],t["S-G-EWZL--"]=[E["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,E["GR.EQ.SHORT RANGE"])],t["S-G-EWZM--"]=[E["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,E["GR.EQ.INTERMEDIATE RANGE"])],t["S-G-EWZH--"]=[E["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,E["GR.EQ.LONG RANGE"])],t["S-G-EWO---"]=[E["GR.EQ.MORTAR"]],t["S-G-EWOL--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWOM--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWOH--"]=[E["GR.EQ.MORTAR"],E["GR.EQ.LONG RANGE"]],t["S-G-EWH---"]=[E["GR.EQ.HOWITZER"]],t["S-G-EWHL--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWHLS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.SHORT RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWHM--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWHMS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.INTERMEDIATE RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWHH--"]=[E["GR.EQ.HOWITZER"],E["GR.EQ.LONG RANGE"]],t["S-G-EWHHS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.HOWITZER"],E["GR.EQ.LONG RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWG---"]=[E["GR.EQ.ANTITANK GUN"]],t["S-G-EWGL--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWGM--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWGH--"]=[E["GR.EQ.ANTITANK GUN"],E["GR.EQ.LONG RANGE"]],t["S-G-EWGR--"]=[E["GR.EQ.RECOILLESS GUN"]],t["S-G-EWD---"]=[E["GR.EQ.DIRECT FIRE GUN"]],t["S-G-EWDL--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWDLS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.SHORT RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWDM--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWDMS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWDH--"]=[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.LONG RANGE"]],t["S-G-EWDHS-"]=[L._translate(0,-15,L._scale(.8,[E["GR.EQ.DIRECT FIRE GUN"],E["GR.EQ.LONG RANGE"]])),E["GR.EQ.HOWITZER TRACKED"]],t["S-G-EWA---"]=[E["GR.EQ.AIR DEFENCE GUN"]],t["S-G-EWAL--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.SHORT RANGE"]],t["S-G-EWAM--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.INTERMEDIATE RANGE"]],t["S-G-EWAH--"]=[E["GR.EQ.AIR DEFENCE GUN"],E["GR.EQ.LONG RANGE"]],t["S-G-EV----"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]],t["S-G-EVA---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.ARMOURED VEHICLE"]],t["S-G-EVAT--"]=[E["GR.EQ.TANK"]],t["S-G-EVATL-"]=[E["GR.EQ.TANK"],E["GR.EQ.LIGHT TANK"]],t["S-G-EVATLR"]=t["S-G-EVATW-"]=[E["GR.EQ.TANK"],E["GR.EQ.LIGHT TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],t["S-G-EVATM-"]=[E["GR.EQ.TANK"],E["GR.EQ.MEDIUM TANK"]],t["S-G-EVATMR"]=t["S-G-EVATX-"]=[E["GR.EQ.TANK"],E["GR.EQ.MEDIUM TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],t["S-G-EVATH-"]=[E["GR.EQ.TANK"],E["GR.EQ.HEAVY TANK"]],t["S-G-EVATHR"]=t["S-G-EVATY-"]=[E["GR.EQ.TANK"],E["GR.EQ.HEAVY TANK"],E["GR.EQ.TANK RECOVERY VEHICLE"]],t["S-G-EVAA--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"]],t["S-G-EVAAR-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.TANK RECOVERY VEHICLE"]],t["S-G-EVAI--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE"]],t["S-G-EVAC--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]],t["S-G-EVAS--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER COMBAT SERVICE SUPPORT VEHICLE"]],t["S-G-EVAL--"]=[E["GR.EQ.ARMOURED FIGHTING VEHICLE"],E["GR.EQ.CROSS-COUNTRY"]],t["S-G-EVU---"]=[E["GR.EQ.UTILITY VEHICLE"]],t["S-G-EVUB--"]=[E["GR.EQ.BUS"]],t["S-G-EVUS--"]=[E["GR.EQ.SEMI-TRAILER TRUCK"]],t["S-G-EVUSL-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE LIGHT"]],t["S-G-EVUSM-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE MEDIUM"]],t["S-G-EVUSH-"]=[E["GR.EQ.SEMI-TRAILER TRUCK"],E["GR.EQ.UTILITY VEHICLE HEAVY"]],t["S-G-EVUL--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"]],t["S-G-EVUX--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"]],t["S-G-EVUR--"]=[E["GR.EQ.WATER VEHICLE"]],t["S-G-EVUT--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]],t["S-G-EVUTL-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]],t["S-G-EVUTH-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],E["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]],t["S-G-EVUA--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.MEDICAL EVACUATION"]],t["S-G-EVUAA-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.MEDICAL EVACUATION"]],t["S-G-EVE---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],L._scale(.7,E["GR.IC.ENGINEER"])],t["S-G-EVEB--"]=[E["GR.EQ.BRIDGE"]],t["S-G-EVEE--"]=[E["GR.EQ.EARTHMOVER"]],t["S-G-EVEC--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],L._scale(.6,E["GR.IC.ENGINEER"])],t["S-G-EVEM--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.MINE LAYING VEHICLE"]],t["S-G-EVEMA-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],E["GR.EQ.TANK"]],t["S-G-EVEMV-"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],t["S-G-EVEMT-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],L._translate(0,-10,E["GR.EQ.LIMITED CROSS-COUNTRY"])],t["S-G-EVEML-"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],E["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],t["S-G-EVEA--"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"]],t["S-G-EVEAA-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],E["GR.EQ.TANK"]],t["S-G-EVEAT-"]=[E["GR.EQ.MINE CLEARING EQUIPMENT"],L._translate(0,-10,E["GR.EQ.LIMITED CROSS-COUNTRY"])],t["S-G-EVEMSM"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],E["GR.EQ.MINE SCATTERABLE"]],t["S-G-EVED--"]=[E["GR.EQ.DOZER"]],t["S-G-EVEDA-"]=[E["GR.EQ.DOZER ARMORED"]],t["S-G-EVES--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],L._scale(.6,E["GR.IC.ENGINEER"])],t["S-G-EVER--"]=[E["GR.EQ.ARMOURED PERSONNEL CARRIER"],L._scale(.6,E["GR.IC.ENGINEER"]),E["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]],t["S-G-EVEH--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.LIMITED CROSS-COUNTRY"],E["GR.EQ.UTILITY VEHICLE BACKHOE"]],t["S-G-EVEF--"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"],E["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]],t["S-G-EVD---"]=[E["GR.EQ.UTILITY VEHICLE"],E["GR.EQ.CROSS-COUNTRY"],L._scale(.7,E["GR.IC.DRILLING"])],t["S-G-EVT---"]=[E["GR.EQ.TRAIN LOCOMOTIVE"]],t["S-G-EVC---"]=[E["GR.I.CIVILIAN"]],t["S-G-EVCA--"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]],t["S-G-EVCAL-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t["S-G-EVCAM-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t["S-G-EVCAH-"]=[E["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t["S-G-EVCO--"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]],t["S-G-EVCOL-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t["S-G-EVCOM-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t["S-G-EVCOH-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t["S-G-EVCM--"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],t["S-G-EVCML-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t["S-G-EVCMM-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t["S-G-EVCMH-"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t["S-G-EVCU--"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]],t["S-G-EVCUL-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t["S-G-EVCUM-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t["S-G-EVCUH-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t["S-G-EVCJ--"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]],t["S-G-EVCJL-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t["S-G-EVCJM-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t["S-G-EVCJH-"]=[E["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t["S-G-EVCT--"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCTL-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCTM-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCTH-"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCF--"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCFL-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.LIGHT"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCFM-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVCFH-"]=[E["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],E["GR.EQ.CIVILIAN VEHICLE.HEAVY"],E["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t["S-G-EVM---"]=[E["GR.EQ.PACK ANIMAL"]],t["S-G-EVS---"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE SUPPORT"]],t["S-G-EVST--"]=e?[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE TRANSLOADER"]]:[E["GR.EQ.TRAIN LOCOMOTIVE"]],t["S-G-EVSR--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE TRANSPORTER"]],t["S-G-EVSC--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE CRANE/LOADING DEVICE"]],t["S-G-EVSP--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]],t["S-G-EVSW--"]=[E["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],E["GR.EQ.MISSILE WARHEAD TRANSPORTER"]],t["S-G-ES----"]=[E["GR.EQ.SENSOR"]],t["S-G-ESR---"]=[E["GR.EQ.RADAR"]],t["S-G-ESE---"]=[E["GR.EQ.SENSOR EMPLACED"]],t["S-G-EXI---"]=[E["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]],t["S-G-EX----"]=[],t["S-G-EXL---"]=[E["GR.EQ.LASER"]],t["S-G-EXN---"]=[E["GR.EQ.CBRN EQUIPMENT"]],t["S-G-EXF---"]=[E["GR.EQ.FLAME THROWER"]],t["S-G-EXM---"]=[E["GR.EQ.LAND MINES"]],t["S-G-EXMC--"]=[E["GR.EQ.ANTIPERSONNEL LAND MINE"]],t["S-G-EXML--"]=[E["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]];var R={"E-----":0,"EWM---":140,"EWMA--":140,"EWMAS-":140,EWMASR:140,EWMASE:140,"EWMAI-":140,EWMAIR:140,EWMAIE:140,"EWMAL-":140,EWMALR:140,EWMALE:140,"EWMAT-":153,EWMATR:153,EWMATE:153,"EWMS--":140,"EWMSS-":140,"EWMSI-":140,"EWMSL-":140,"EWMT--":140,"EWMTL-":140,"EWMTM-":140,"EWMTH-":140,"EWS---":140,"EWSL--":140,"EWSM--":140,"EWSH--":140,"EWX---":140,"EWXL--":140,"EWXM--":140,"EWXH--":140,"EWT---":140,"EWTL--":140,"EWTM--":140,"EWTH--":140,"EWR---":140,"EWRL--":140,"EWRM--":140,"EWRH--":140,"EWZ---":140,"EWZL--":140,"EWZM--":140,"EWZH--":140,"EWO---":140,"EWOL--":140,"EWOM--":140,"EWOH--":140,"EWH---":140,"EWHL--":140,"EWHLS-":130,"EWHM--":140,"EWHMS-":130,"EWHH--":140,"EWHHS-":130,"EWG---":140,"EWGL--":140,"EWGM--":140,"EWGH--":140,"EWGR--":140,"EWD---":140,"EWDL--":140,"EWDLS-":130,"EWDM--":140,"EWDMS-":130,"EWDH--":140,"EWDHS-":130,"EWA---":140,"EWAL--":140,"EWAM--":140,"EWAH--":140,"EV----":129,"EVA---":129,"EVAT--":130,"EVATL-":130,EVATLR:130,"EVATM-":130,EVATMR:130,"EVATH-":130,EVATHR:130,"EVAA--":130,"EVAAR-":130,"EVAI--":130,"EVAC--":130,"EVAS--":130,"EVAL--":140,"EVU---":130,"EVAB--":130,"EVUS--":140,"EVUSL-":140,"EVUSM-":140,"EVUSH-":140,"EVUL--":140,"EVUX--":140,"EVUR--":130,"EVUTL-":130,"EVUTH-":130,"EVUA--":130,"EVUAA-":130,"EVE---":129,"EVEB--":130,"EVEE--":130,"EVEC--":140,"EVEM--":130,"EVEMA-":130,"EVEMV-":130,"EVEMT-":130,"EVEML-":140,"EVEA--":120,"EVEAA-":130,"EVEAT-":130,EVEMSM:130,"EVED--":130,"EVEDA-":130,"EVES--":130,"EVER--":130,"EVEH--":140,"EVEF--":140,"EVD---":140,"EVT--":130,"EVC---":119,"EVCA--":132.5,"EVCAL-":132.5,"EVCAM-":132.5,"EVCAH-":132.5,"EVCO--":132.5,"EVCOL-":132.5,"EVCOM-":132.5,"EVCOH-":132.5,"EVCM--":132.5,"EVCML-":132.5,"EVCMM-":132.5,"EVCMH-":132.5,"EVCU--":132.5,"EVCUL-":132.5,"EVCUM-":132.5,"EVCUH-":132.5,"EVCJ--":132.5,"EVCJL-":132.5,"EVCJM-":132.5,"EVCJH-":132.5,"EVCT--":132.5,"EVCTL-":132.5,"EVCTM-":132.5,"EVCTH-":132.5,"EVCF--":132.5,"EVCFL-":132.5,"EVCFM-":132.5,"EVCFH-":132.5,"EVM---":125,"EVS---":129,"EVST--":129,"EVSR--":129,"EVSC--":129,"EVSP--":129,"EVSW--":129,"ES----":140,"ESR---":120,"ESE---":136,"EXI---":119,"EXL---":145,"EXN---":140,"EXF---":135,"EXM---":130,"EXMC--":122,"EXML--":122};for(const C in R)R.hasOwnProperty(C)&&(I["S-G-"+C]={x1:50,x2:150,y1:50,y2:R[C]})}},M={type:"letter",getMetadata:e,getIcons:R,iconParts:[N],icons:function(t,I,E,e){t["S-G-I-----"]=[],t["S-G-IR----"]=[E["GR.IN.IC.RAW MATERIAL PRODUCTION/STORAGE"]],t["S-G-IRM---"]=[E["GR.IN.IC.MINE"]],t["S-G-IRP---"]=[E["GR.IC.FF.CLASS III"]],t["S-G-IRN---"]=[E["GR.IC.CBRN"]],t["S-G-IRNB--"]=[E["GR.IC.CBRN"],E["GR.M1.BIOLOGICAL"]],t["S-G-IRNC--"]=[E["GR.IC.CBRN"],E["GR.M1.CHEMICAL"]],t["S-G-IRNN--"]=[E["GR.IC.CBRN"],E["GR.M1.NUCLEAR"]],t["S-G-IP----"]=[E["GR.IN.IC.PROCESSING FACILITY"]],t["S-G-IPD---"]=[E["GR.IC.CBRN"],E["GR.M1.DECONTAMINATION"]],t["S-G-IE----"]=[E["GR.IC.EQUIPMENT MANUFACTURE"]],t["S-G-IU----"]=[E["GR.IN.IC.UTILITY FACILITY"]],t["S-G-IUR---"]=[E["GR.IN.IC.RESEARCH"]],t["S-G-IUT---"]=[E["GR.IN.IC.TELECOMMUNICATIONS"]],t["S-G-IUE---"]=[E["GR.IN.IC.ELECTRIC POWER"]],t["S-G-IUEN--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER NUCLEAR"]],t["S-G-IUED--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER DAM"]],t["S-G-IUEF--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER FOSSIL"]],t["S-G-IUP---"]=[E["GR.IC.WATER"]],t["S-G-IM----"]=[],t["S-G-IMF---"]=[E["GR.IN.IC.ATOMIC ENERGY"]],t["S-G-IMFA--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.ATOMIC ENERGY REACTOR"]],t["S-G-IMFP--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],t["S-G-IMFPW-"]=[E["GR.IN.IC.ATOMIC ENERGY WEAPONS GRADE"],E["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],t["S-G-IMFS--"]=[E["GR.IN.IC.ATOMIC ENERGY"],E["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]],t["S-G-IMA---"]=[E["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]],t["S-G-IME---"]=[E["GR.IC.FF.CLASS V"]],t["S-G-IMG---"]=[E["GR.EQ.TANK"]],t["S-G-IMV---"]=[E["GR.IC.MAINTENANCE"]],t["S-G-IMN---"]=[E["GR.EQ.DOZER"]],t["S-G-IMNB--"]=[E["GR.IN.IC.BRIDGE"]],t["S-G-IMC---"]=[E["GR.IC.CBRN"],E["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]],t["S-G-IMS---"]=[E["GR.IC.NAVAL"],E["GR.IN.M2.SHIP CONSTRUCTION"]],t["S-G-IMM---"]=[E["GR.IC.MISSILE"]],t["S-G-IG----"]=[E["GR.I.GOVERNMENT"]],t["S-G-IB----"]=[E["GR.IN.IC.BASE"]],t["S-G-IBA---"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],t["S-G-IBN---"]=[E["GR.IC.NAVAL"]],t["S-G-IT----"]=[E["GR.IC.TRANSPORTATION"]],t["S-G-IX----"]=[E["GR.IC.FF.MEDICAL"]],t["S-G-IXH---"]=[E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t["S-G-IRR---"]=t["S-G-IRSR--"]=[E["GR.IN.IC.SEA SURFACE INSTALLATION, OIL RIG/PLATFORM"]]}};function w(t,I,E,e,R,C){var A=I.frame,T=I.affiliation||"Friend",I=I.numberSIDC,S=E.iconColor[T],N=E.iconFillColor[T],O=E.black[T],E=E.white[T],i={};i["SE.IC.MILITARY"]=a("MIL"),i["SE.IC.MANUAL TRACK"]=a("MAN"),i["SE.IC.COMBATANT"]=[{type:"path",d:"m 86.9,110 c -3.6,2 -7.2,3.9 -10.8,5.9 2.1,2.9 6.7,3.9 10,2.1 2.6,-0.9 4.7,-3.8 3.1,-6.1 -0.8,-0.6 -1.5,-1.3 -2.3,-1.9 z m 26.3,0.1 c 3.6,2 7.2,3.9 10.8,5.9 -2.1,2.9 -6.7,3.9 -10,2.1 -2.6,-0.9 -4.7,-3.8 -3.1,-6.1 0.8,-0.6 1.5,-1.3 2.3,-1.9 z",fill:!1},{type:"path",d:"m 112.9,110 c -5.6,-4 -11.3,-7.9 -16.1,-12.5 -4.2,-4.5 -7,-9.8 -9.2,-15.1 -0.8,4.4 -0.9,9.3 2.4,13.2 3.6,4.5 8.6,8.1 13.5,11.8 2.3,1.7 4.7,3.3 7.1,4.8 0.8,-0.7 1.5,-1.5 2.3,-2.2 m -25.7,0 c 5.6,-4 11.3,-7.9 16.1,-12.5 4.2,-4.5 7,-9.8 9.2,-15.1 0.8,4.4 0.9,9.3 -2.4,13.2 -3.6,4.5 -8.6,8.1 -13.5,11.8 -2.3,1.7 -4.7,3.3 -7.1,4.8 -0.8,-0.7 -1.5,-1.5 -2.3,-2.2",fill:E,strokewidth:2}],i["SE.IC.SURFACE COMBATANT, LINE"]={type:"path",stroke:!1,d:"m 100,120 -25,-17 15,2 0,-10 5,0 0,-5 -15,0 0,-5 15,0 0,-5 10,0 0,5 15,0 0,5 -15,0 0,5 5,0 0,10 15,-2 z"},i["SE.IC.CARRIER"]={type:"path",d:"m 80,100 20,20 20,-20 -20,0 0,-20 -20,0 z"},i["SE.IC.BATTLESHIP"]=a("BB"),i["SE.IC.CIVILIAN"]=a("CIV"),i["SE.IC.CIVILIAN"].fill=(e||I||!A)&&N,i["SE.IC.CIVILIAN"].stroke=O,i["SE.IC.CIVILIAN"].strokewidth=3,i["SE.IC.CRUISER"]=a("CC"),i["SE.IC.CRUISER, GUIDED MISSILE"]=a("CG"),i["SE.IC.DESTROYER"]=a("DD"),i["SE.IC.FRIGATE"]=a("FF"),i["SE.IC.CORVETTE"]=a("FS"),i["SE.IC.LITTORAL COMBATANT SHIP"]=a("LCS"),i["SE.IC.AMPHIBIOUS WARFARE SHIP"]={type:"path",d:"m 100,120 20,0 m -20,0 -20,-20 10,0 0,-20 20,0 0,20 10,0 z"},i["SE.IC.AMPHIBIOUS FORCE FLAGSHIP"]=a("LCC"),i["SE.IC.AMPHIBIOUS ASSAULT"]=a("LA"),i["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]=a("LHA"),i["SE.IC.AMPHIBIOUS ASSAULT SHIP, MULTI-PURPOSE"]=a("LHD"),i["SE.IC.AMPHIBIOUS TRANSPORT, DOCK"]=a("LPD"),i["SE.IC.AMPHIBIOUS ASSAULT SHIP, HELICOPTER"]=a("LPH"),i["SE.IC.LANDING SHIP"]=a("LS"),i["SE.IC.LANDING CRAFT"]=a("LC"),i["SE.IC.MINE WARFARE VESSEL"]={type:"path",d:"m 98.3,81 0,4.1 c -2.4,0.3 -4.6,1.4 -6.4,2.9 l -3.5,-3.5 -2.4,2.4 3.6,3.6 c -0.9,1.3 -1.5,4.9 -1.8,6.5 l -10.8,0 0,3 3,0 20,20 20,-20 3,0 0,-3 -10,0 c -1,-1.7 -2,-5.3 -3,-6.7 l 4,-3.7 -2,-2.4 -4,3.6 c -2,-1.4 -4,-2.4 -6,-2.7 l 0,-4.1 z"},i["SE.IC.MINELAYER"]=a("ML"),i["SE.IC.MINESWEEPER"]=a("MS"),i["SE.IC.MINESWEEPER, DRONE"]=a("MSD"),i["SE.IC.MINEHUNTER"]=a("MH"),i["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]=a("MCS"),i["SE.IC.MINE COUNTERMEASURES"]=a("MCM"),i["SE.IC.SEA SURFACE DECOY"]={type:"path",d:"M 85.6,82.5 68.2,99.9 85.6,117 Z  M 109,82.5 91.4,99.9 109,117 Z  m 23,0 -17,17.4 17,17.1 z"},i["SE.IC.PATROL"]={type:"path",d:"m 80,100 20,20 20,-20 -10,0 0,-20 -20,0 0,20 z"},i["SE.IC.PATROL CRAFT"]=a("PC"),i["SE.IC.PATROL ANTI SUBMARINE WARFARE"]={type:"path",d:"m 100,120 -25,-25 5,-5 10,10 5,0 0,-20 10,0 0,20 5,0 10,-10 5,5 z"},i["SE.IC.PATROL ANTISHIP MISSILE"]=a("PM"),i["SE.IC.PATROL TORPEDO"]=a("PT"),i["SE.IC.PATROL GUN"]=a("PG"),i["SE.IC.PATROL SHIP"]=[],i["SE.IC.MILITARY SPEEDBOAT"]={type:"path",stroke:!1,d:"m 120,120 -40,0 -15,-25 15,0 5,-15 10,0 -5,15 45,0 z"},i["SE.IC.MILITARY SPEEDBOAT, RIGID-HULL INFLATABLE BOAT"]=[{type:"path",stroke:!1,d:"M 85 80 L 80 95 L 65 95 L 80 120 L 120 120 L 135 95 L 90 95 L 95 80 L 85 80 z M 87 100.7 L 93.1 100.7 C 94.6 100.7 95.7 100.8 96.4 101.1 C 97.1 101.3 97.7 101.8 98.1 102.4 C 98.5 103.1 98.7 103.8 98.7 104.7 C 98.7 105.8 98.4 106.7 97.8 107.4 C 97.1 108.1 96.2 108.5 94.9 108.7 C 95.6 109.1 96.1 109.4 96.5 109.9 C 96.9 110.3 97.4 111.1 98.1 112.2 L 99.9 115 L 96.4 115 L 94.3 111.9 C 93.6 110.8 93.1 110.1 92.8 109.8 C 92.5 109.5 92.2 109.3 91.9 109.2 C 91.6 109.1 91.2 109 90.5 109 L 89.9 109 L 89.9 115 L 87 115 L 87 100.7 z M 101.5 100.7 L 107.2 100.7 C 108.3 100.7 109.2 100.7 109.7 100.8 C 110.3 100.9 110.8 101.1 111.2 101.4 C 111.7 101.7 112 102.1 112.3 102.6 C 112.6 103.1 112.7 103.7 112.8 104.3 C 112.7 105 112.6 105.6 112.2 106.1 C 111.9 106.7 111.4 107.1 110.8 107.4 C 111.6 107.7 112.3 108.1 112.8 108.7 C 113.2 109.3 113.5 110 113.5 110.8 C 113.5 111.5 113.3 112.1 113 112.8 C 112.7 113.4 112.3 113.8 111.8 114.2 C 111.2 114.6 110.6 114.8 109.8 114.9 C 109.3 115 108.2 115 106.3 115 L 101.5 115 L 101.5 100.7 z M 104.3 103.1 L 104.3 106.4 L 106.3 106.4 C 107.4 106.4 108.1 106.3 108.3 106.3 C 108.8 106.3 109.2 106.1 109.5 105.8 C 109.8 105.5 109.9 105.1 109.9 104.7 C 109.9 104.2 109.8 103.9 109.6 103.6 C 109.3 103.3 109 103.2 108.5 103.1 C 108.2 103.1 107.4 103.1 106 103.1 L 104.3 103.1 z M 89.9 103.1 L 89.9 106.8 L 92 106.8 C 93.4 106.8 94.3 106.7 94.6 106.6 C 95 106.4 95.2 106.3 95.4 106 C 95.6 105.7 95.7 105.3 95.8 104.9 C 95.7 104.4 95.6 104 95.3 103.7 C 95.1 103.4 94.7 103.2 94.3 103.2 C 94 103.1 93.3 103.1 92.2 103.1 L 89.9 103.1 z M 104.3 108.8 L 104.3 112.6 L 107 112.6 C 108.1 112.6 108.7 112.6 109 112.5 C 109.4 112.4 109.8 112.2 110.1 111.9 C 110.3 111.6 110.5 111.2 110.5 110.7 C 110.5 110.3 110.4 109.9 110.2 109.6 C 109.9 109.3 109.6 109.1 109.3 109 C 108.9 108.8 108 108.8 106.7 108.8 L 104.3 108.8 z"},{type:"path",stroke:!1,fill:(e||!A)&&N,d:"m 87,100.7 h 6.1 c 1.5,0 2.6,0.1 3.3,0.4 0.7,0.2 1.3,0.7 1.7,1.3 0.4,0.7 0.6,1.4 0.6,2.3 0,1.1 -0.3,2 -0.9,2.7 -0.7,0.7 -1.6,1.1 -2.9,1.3 0.7,0.4 1.2,0.7 1.6,1.2 0.4,0.4 0.9,1.2 1.6,2.3 l 1.8,2.8 h -3.5 l -2.1,-3.1 c -0.7,-1.1 -1.2,-1.8 -1.5,-2.1 -0.3,-0.3 -0.6,-0.5 -0.9,-0.6 -0.3,-0.1 -0.7,-0.2 -1.4,-0.2 h -0.6 v 6 H 87 Z  m 14.5,0 h 5.7 c 1.1,0 2,0 2.5,0.1 0.6,0.1 1.1,0.3 1.5,0.6 0.5,0.3 0.8,0.7 1.1,1.2 0.3,0.5 0.4,1.1 0.5,1.7 -0.1,0.7 -0.2,1.3 -0.6,1.8 -0.3,0.6 -0.8,1 -1.4,1.3 0.8,0.3 1.5,0.7 2,1.3 0.4,0.6 0.7,1.3 0.7,2.1 0,0.7 -0.2,1.3 -0.5,2 -0.3,0.6 -0.7,1 -1.2,1.4 -0.6,0.4 -1.2,0.6 -2,0.7 -0.5,0.1 -1.6,0.1 -3.5,0.1 h -4.8 z  m 2.8,2.4 v 3.3 h 2 c 1.1,0 1.8,-0.1 2,-0.1 0.5,0 0.9,-0.2 1.2,-0.5 0.3,-0.3 0.4,-0.7 0.4,-1.1 0,-0.5 -0.1,-0.8 -0.3,-1.1 -0.3,-0.3 -0.6,-0.4 -1.1,-0.5 -0.3,0 -1.1,0 -2.5,0 z  m -14.4,0 v 3.7 H 92 c 1.4,0 2.3,-0.1 2.6,-0.2 0.4,-0.2 0.6,-0.3 0.8,-0.6 0.2,-0.3 0.3,-0.7 0.4,-1.1 -0.1,-0.5 -0.2,-0.9 -0.5,-1.2 -0.2,-0.3 -0.6,-0.5 -1,-0.5 -0.3,-0.1 -1,-0.1 -2.1,-0.1 z  m 14.4,5.7 v 3.8 h 2.7 c 1.1,0 1.7,0 2,-0.1 0.4,-0.1 0.8,-0.3 1.1,-0.6 0.2,-0.3 0.4,-0.7 0.4,-1.2 0,-0.4 -0.1,-0.8 -0.3,-1.1 -0.3,-0.3 -0.6,-0.5 -0.9,-0.6 -0.4,-0.2 -1.3,-0.2 -2.6,-0.2 z"}],i["SE.IC.MILITARY JETSKI"]={type:"path",stroke:!1,d:"m 135,105 0,15 -60,0 -10,-15 20,-25 10,0 0,10 -5,0 -5,15 z"},i["SE.IC.UNMANNED SURFACE WATER VEHICLE"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},i["SE.IC.NAVY TASK ORGANIZATION UNIT"]=[{type:"path",d:"m 110,80 15,15 0,25 M 90,80 75,95 l 0,25",fill:!1}],i["SE.IC.NAVY TASK FORCE"]=[i["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:30,text:"TF"}],i["SE.IC.NAVY TASK GROUP"]=[i["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:30,text:"TG"}],i["SE.IC.NAVY TASK UNIT"]=[i["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:30,text:"TU"}],i["SE.IC.NAVY TASK ELEMENT"]=[i["SE.IC.NAVY TASK ORGANIZATION UNIT"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:110,fontsize:30,text:"TE"}],i["SE.IC.CONVOY"]={type:"path",d:"m 80,115 -20,0 0,-35 80,0 0,35 -20,0 0,-20 -40,0 z"},i["SE.IC.NONCOMBATANT"]={type:"path",d:"m 80,100 0,-20 40,0 0,20 15,0 0,20 -70,0 0,-20 z"},i["SE.IC.AUXILIARY SHIP"]=a(e&&!I?"AR":"AA"),i["SE.IC.AMMUNITION SHIP"]=a("AE"),i["SE.IC.STORES SHIP"]=a("AF"),i["SE.IC.AUXILIARY FLAG OR COMMAND SHIP"]=a("AGF"),i["SE.IC.INTELLIGENCE COLLECTOR"]=a("AGI"),i["SE.IC.OCEAN RESEARCH SHIP"]=a("AGO"),i["SE.IC.SURVEY SHIP"]=a("AGS"),i["SE.IC.HOSPITAL SHIP"]=a("AH"),i["SE.IC.CARGO SHIP"]=a("AK"),i["SE.IC.COMBAT SUPPORT SHIP, FAST"]=a("AOE"),i["SE.IC.OILER, REPLENISHMENT"]=a("AOR"),i["SE.IC.REPAIR SHIP"]=a("AR"),i["SE.IC.SUBMARINE TENDER"]=a("AS"),i["SE.IC.TUG, OCEAN GOING"]=a("AT"),i["SE.IC.SERVICE CRAFT, YARD, GENERAL"]=a(e?"YY":"YT"),i["SE.IC.BARGE, NOT SELF-PROPELLED"]=a("YB"),i["SE.IC.BARGE, SELF-PROPELLED"]=a("YS"),i["SE.IC.TUG, HARBOUR"]=a("YT"),i["SE.IC.LAUNCH"]=a("YFT"),i["SE.IC.MERCHANT SHIP, GENERAL"]={type:"path",fill:(e||!A)&&N,d:"m 75,100 0,-35 50,0 0,35 20,0 -15,35 -60,0 -15,-35 z"},i["SE.IC.CARGO, GENERAL"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"A"}],i["SE.IC.CONTAINER SHIP"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"C"}],i["SE.IC.DREDGE"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"D"}],i["SE.IC.RADAR"]={type:"path",d:"M72,95 l30,-25 0,25 30,-25 M70,70 c0,35 15,50 50,50",fill:!1},i["SE.IC.ROLL ON-ROLL OFF"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:"45",text:"E"}],i["SE.IC.FERRY"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"F"}],i["SE.IC.HEAVY LIFT"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"H"}],i["SE.IC.HOVERCRAFT"]={type:"path",d:e?"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z":"m 90,80 0,15.6 C 78.4,96.9 70,100.6 70,105 c 0,5.5 13.4,10 30,10 16.6,0 30,-4.5 30,-10 0,-4.4 -8.4,-8.1 -20,-9.4 L 110,80 90,80 z m -15,40 50,0"},i["SE.IC.HOVERCRAFT 2525D"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"J"}],i["SE.IC.HOVERCRAFT CIVILIAN"]={type:"path",fill:(e||!A)&&N,d:e?"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z":"m 90,80 0,15.6 C 78.4,96.9 70,100.6 70,105 c 0,5.5 13.4,10 30,10 16.6,0 30,-4.5 30,-10 0,-4.4 -8.4,-8.1 -20,-9.4 L 110,80 90,80 z m -15,40 50,0"},i["SE.IC.HOVERCRAFT NONCOMBATANT"]=[{type:"path",d:"m 65,100 0,-30 5,10 60,0 5,-10 0,30 10,0 -15,35 -60,0 -15,-35 z",strokewidth:!1},e?{type:"text",alignmentBaseline:"middle",fill:E,stroke:!1,x:100,y:120,fontsize:30,text:"NC"}:[]],i["SE.IC.MERCHANT SHIP, LASH CARRIER (WITH BARGES)"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"L"}],i["SE.IC.OILER/TANKER"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"O"}],i["SE.IC.PASSENGER SHIP"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"P"}],i["SE.IC.TUG, OCEAN GOING CIVILIAN"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:103,fontsize:45,text:"T"}],i["SE.IC.TOW"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:35,text:"TW"}],i["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:35,text:"HZ"}],i["SE.IC.JUNK/DHOW"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:35,text:"QJ"}],i["SE.IC.BARGE, NOT SELF-PROPELLED CIV"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:35,text:"YB"}],i["SE.IC.HOSPITAL SHIP CIV"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"path",stroke:!1,d:"m 95,95 0,-15 10,0 0,15 15,0 0,10 -15,0 0,15 -10,0 0,-15 -15,0 0,-10 z"}],i["SE.IC.FISHING VESSEL"]={type:"path",fill:(e||!A)&&N,d:"m 75,100 0,-15 20,0 0,15 50,0 -15,35 -60,0 -15,-35 z M 105,57.4 105,100 m 30,-35 -30,35"},i["SE.IC.DRIFTER"]=[i["SE.IC.FISHING VESSEL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:30,text:"DF"}],i["SE.IC.TRAWLER"]=[i["SE.IC.FISHING VESSEL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:30,text:"TR"}],i["SE.IC.FISHING VESSEL DREDGE"]=[i["SE.IC.FISHING VESSEL"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:30,text:"DR"}],i["SE.IC.LAW ENFORCEMENT VESSEL"]=[i["SE.IC.MERCHANT SHIP, GENERAL"],{type:"path",d:"m 135,100 -15,35 -10,0 15,-35 z"}],i["SE.IC.LEISURE CRAFT, SAILING BOAT"]={type:"path",fill:(e||!A)&&N,d:"m 105,55 0,40 35,0 z m -5,-5 0,50 m 45,0 -15,35 -60,0 -15,-35 z"},i["SE.IC.LEISURE CRAFT, MOTORIZED"]={type:"path",fill:(e||!A)&&N,d:"m 70,97.4 15,-30 10,0 -15,30 65,0 -15,35 -60,0 -15,-35 z"},i["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]=[i["SE.IC.LEISURE CRAFT, MOTORIZED"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:30,text:"RB"}],i["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]=[i["SE.IC.LEISURE CRAFT, MOTORIZED"],{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:30,text:"SP"}],i["SE.IC.LEISURE CRAFT, JETSKI"]={type:"path",fill:(e||!A)&&N,d:"m 85,60 -30,45 10,15 75,0 0,-20 -60,0 10,-30 5,0 0,-10 z"},i["SE.IC.UNMANNED SURFACE WATER VEHICLE (USV)"]={type:"path",fill:!(!e&&!I)&&N,stroke:O,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},i["SE.IC.OWN SHIP"]={type:"path",fill:!1,stroke:R?S:N,d:"m 50,100 100,0 m -50,-50 0,100 m 50,-50 c 0,27.6 -22.4,50 -50,50 -27.6,0 -50,-22.4 -50,-50 0,-27.6 22.4,-50 50,-50 27.6,0 50,22.4 50,50 z"},i["SE.IC.DITCHED AIRCRAFT"]={type:"path",fill:R?S:N,stroke:R?S:N,d:"m 145,120 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 10,10 25,-30 -10,-10 10,-10 20,20 -10,35 -15,-15 -15,15 z"},i["SE.IC.PERSON IN WATER"]={type:"path",fill:R?S:N,stroke:R?S:N,d:"m 105,110 10,-10 0,-15 5,0 0,20 -10,10 z m -10,0 -10,-10 0,-15 -5,0 0,20 10,10 z m 5,-5 0,-10 -5,0 -5,-5 0,-10 5,-5 10,0 5,5 0,10 -5,5 -5,0 m -15,25 15,-15 m 45,15 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 45,15 -15,-15"},i["SE.IC.DISTRESSED VESSEL"]={type:"path",fill:R?S:N,stroke:R?S:N,d:"m 120,65 -20,20 20,-20 m -5,55 -35,-35 0,-20 45,45 z m -30,0 -15,-15 m -15,15 15,-15 m 45,15 15,-15 m 15,15 -15,-15 m -45,15 15,-15"},i["SE.IC.SEA MINELIKE"]={type:"path",fill:R?S:N,stroke:R?S:N,d:"m 117.7,75 c 3.5,-3.5 7.1,-7.1 7.1,-7.1 l 7.1,7.1 -7.1,7.1 m -49.5,0 c -3.5,-3.5 -7.1,-7.1 -7.1,-7.1 l 7.1,-7.1 7.1,7.1 M 95,70 c 0,-5 0,-10 0,-10 l 10,0 0,10 m 25,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 16.6,0 30,13.4 30,30 z"},i["SE.IC.NAVIGATIONAL"]={type:"path",fill:!1,stroke:R?S:"red",d:"m 75,90 -10,10 70,0 -10,10"},i["SE.IC.ICEBERG"]={type:"path",fill:R?S:N,stroke:R?S:N,d:"m 75,100 25,-30 25,30 -5,15 -5,-5 -15,20 -15,-20 -5,5 z m -15,0 80,0"},i["SE.IC.FUSED TRACK"]=[a("?"),{type:"path",fill:!1,d:"m 70,65 10,35 -10,35 60,0 -10,-35 10,-35 z"}],i["SE.M1.OWN SHIP"]=P("OWN"),i["SE.M1.ANTIAIR WARFARE"]=P("AAW"),i["SE.M1.ANTISUBMARINE WARFARE"]=P("ASW"),i["SE.M1.ESCORT"]=P("E"),i["SE.M1.ELECTRONIC WARFARE"]=P("EW"),i["SE.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]=P("ISR"),i["SE.M1.MINE COUNTER MEASURES"]=P("MCM"),i["SE.M1.MISSILE DEFENSE"]=P("MD"),i["SE.M1.MEDICAL"]=P("ME"),i["SE.M1.MINE COUNTERMEASURES"]=P("MCM"),i["SE.M1.MINE WARFARE"]=P("MIW"),i["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]=P("RMV"),i["SE.M1.SPECIAL OPERATIONS FORCE"]=P("SOF"),i["SE.M1.SURFACE WARFARE"]=P("SUW"),i["SE.M1.BALLISTIC MISSILE"]=P("B"),i["SE.M1.GUIDED MISSILE"]=P("G"),i["SE.M1.OTHER GUIDED MISSILE"]=P("M"),i["SE.M1.TORPEDO"]=P("T"),i["SE.M1.CYBERSPACE"]=P("CYB"),i["SE.M1.HIJACKER"]=P("HJ"),i["SE.M2.CYBERSPACE"]=r("CYB"),i["SE.M1.DRONE-EQUIPPED"]={type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},i["SE.M1.HELICOPTER-EQUIPPED"]=P("H"),i["SE.M1.BALLISTIC MISSILE DEFENSE, SHOOTER"]=P("BM"),i["SE.M1.BALLISTIC MISSILE DEFENSE, LONG- RANGE SURVEILLANCE AND TRACK (LRS&T)"]=P("ST"),i["SE.M1.SEA-BASE X-BAND"]=P("SBX"),i["SE.M1.HIJACKING/HIJACKED"]=P("H"),i["SE.M2.ANTISUBMARINE WARFARE"]=r("ASW"),i["SE.M2.MINE WARFARE"]=r("MIW"),i["SE.M2.SURFACE WARFARE"]=r("SUW"),i["SE.M2.NUCLEAR POWERED"]=r("N"),i["SE.M2.HEAVY"]=r("H"),i["SE.M2.LIGHT"]=r("L"),i["SE.M2.MEDIUM"]=r("M"),i["SE.M2.DOCK"]=r("D"),i["SE.M2.LOGISTICS"]=r("LOG"),i["SE.M2.TANK"]=r("T"),i["SE.M2.VEHICLE"]=r("V"),i["SE.M2.FAST"]=r("F"),i["SE.M2.AIR-CUSHIONED"]=r("J"),i["SE.M2.AIR-CUSHIONED (USA ONLY)"]=r("AC"),i["SE.M2.HYDROFOIL"]=r("K"),i["SE.M2.AUTONOMOUS CONTROL"]=r("AUT"),i["SE.M2.REMOTELY PILOTED"]=r("RP"),i["SE.M2.EXPENDABLE"]=r("EXP");for(const M in i)i.hasOwnProperty(M)&&(t.hasOwnProperty(M)&&console.warn("Override of: "+M),s.call(this,i[M],S),t[M]=i[M])}var G={type:"letter",getMetadata:e,getIcons:R,iconParts:[w],icons:function(t,I,E,e){t["S-S-------"]=[],t["S-S-C-----"]=[E["SE.IC.COMBATANT"]],t["S-S-CL----"]=[E["SE.IC.SURFACE COMBATANT, LINE"]],t["S-S-CLCV--"]=[E["SE.IC.CARRIER"]],t["S-S-CLBB--"]=[E["SE.IC.BATTLESHIP"]],t["S-S-CLCC--"]=[E["SE.IC.CRUISER"]],t["S-S-CLDD--"]=[E["SE.IC.DESTROYER"]],t["S-S-CLFF--"]=[E["SE.IC.FRIGATE"]],t["S-S-CLLL--"]=[E["SE.IC.LITTORAL COMBATANT SHIP"]],t["S-S-CLLLAS"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.ANTISUBMARINE WARFARE"]],t["S-S-CLLLMI"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.MINE WARFARE"]],t["S-S-CLLLSU"]=[E["SE.IC.LITTORAL COMBATANT SHIP"],E["SE.M2.SURFACE WARFARE"]],t["S-S-CA----"]=[E["SE.IC.AMPHIBIOUS WARFARE SHIP"]],t["S-S-CALA--"]=[e?E["SE.IC.AMPHIBIOUS ASSAULT"]:E["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]],t["S-S-CALS--"]=[E["SE.IC.LANDING SHIP"]],t["S-S-CALSM-"]=[E["SE.IC.LANDING SHIP"],E["SE.M2.MEDIUM"]],t["S-S-CALST-"]=[E["SE.IC.LANDING SHIP"],E["SE.M2.TANK"]],t["S-S-CALC--"]=[E["SE.IC.LANDING CRAFT"]],t["S-S-CM----"]=[E["SE.IC.MINE WARFARE VESSEL"]],t["S-S-CMML--"]=[E["SE.IC.MINELAYER"]],t["S-S-CMMS--"]=[E["SE.IC.MINESWEEPER"]],t["S-S-CMMH--"]=[E["SE.IC.MINEHUNTER"]],t["S-S-CMMA--"]=[E["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]],t["S-S-CMMD--"]=[E["SE.IC.MINESWEEPER, DRONE"]],t["S-S-CP----"]=[E["SE.IC.PATROL"]],t["S-S-CPSB--"]=[E["SE.IC.PATROL CRAFT"]],t["S-S-CPSU--"]=[E["SE.IC.PATROL ANTI SUBMARINE WARFARE"]],t["S-S-CPSUM-"]=[E["SE.IC.PATROL ANTISHIP MISSILE"]],t["S-S-CPSUT-"]=[E["SE.IC.PATROL TORPEDO"]],t["S-S-CPSUG-"]=[E["SE.IC.PATROL GUN"]],t["S-S-CH----"]=[E["SE.IC.HOVERCRAFT"]],t["S-S-G-----"]=[E["SE.IC.NAVY TASK ORGANIZATION UNIT"]],t["S-S-GF----"]=t["S-S-GT----"]=[E["SE.IC.NAVY TASK FORCE"]],t["S-S-GG----"]=[E["SE.IC.NAVY TASK GROUP"]],t["S-S-GU----"]=[E["SE.IC.NAVY TASK UNIT"]],t["S-S-GE----"]=[E["SE.IC.NAVY TASK ELEMENT"]],t["S-S-GC----"]=[E["SE.IC.CONVOY"]],t["S-S-CD----"]=[E["SE.IC.SEA SURFACE DECOY"]],t["S-S-CU----"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"]],t["S-S-CUM---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.MINE COUNTERMEASURES"]],t["S-S-CUS---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.ANTISUBMARINE WARFARE"]],t["S-S-CUN---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.SURFACE WARFARE"]],t["S-S-CUR---"]=[E["SE.IC.UNMANNED SURFACE WATER VEHICLE"],E["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]],t["S-S-N-----"]=[E["SE.IC.NONCOMBATANT"]],t["S-S-NR----"]=[E["SE.IC.AUXILIARY SHIP"]],t["S-S-NRA---"]=[E["SE.IC.AMMUNITION SHIP"]],t["S-S-NRO---"]=[E["SE.IC.OILER, REPLENISHMENT"]],t["S-S-NF----"]=t["S-S-NFT---"]=[E["SE.IC.TUG, OCEAN GOING"]],t["S-S-NI----"]=[E["SE.IC.INTELLIGENCE COLLECTOR"]],t["S-S-NM----"]=[E["SE.IC.HOSPITAL SHIP"]],t["S-S-NS----"]=[E["SE.IC.SERVICE CRAFT, YARD, GENERAL"]],t["S-S-NR----"]=[E["SE.IC.REPAIR SHIP"]],t["S-S-NTS---"]=[E["SE.IC.SUBMARINE TENDER"]],t["S-S-NH----"]=[E["SE.IC.HOVERCRAFT NONCOMBATANT"]],t["S-S-X-----"]=[],t["S-S-XM----"]=[E["SE.IC.MERCHANT SHIP, GENERAL"]],t["S-S-XMC---"]=[E["SE.IC.CARGO, GENERAL"]],t["S-S-XME---"]=t["S-S-XMR---"]=[E["SE.IC.ROLL ON-ROLL OFF"]],t["S-S-XMO---"]=[E["SE.IC.OILER/TANKER"]],t["S-S-XMT---"]=t["S-S-XMTU--"]=[E["SE.IC.TUG, OCEAN GOING CIVILIAN"]],t["S-S-XMF---"]=[E["SE.IC.FERRY"]],t["S-S-XMP---"]=[E["SE.IC.PASSENGER SHIP"]],t["S-S-XMH---"]=[E["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]],t["S-S-XMD---"]=[E["SE.IC.DREDGE"]],t["S-S-XMTO--"]=[E["SE.IC.TOW"]],t["S-S-XF----"]=[E["SE.IC.FISHING VESSEL"]],t["S-S-XFDF--"]=[E["SE.IC.DRIFTER"]],t["S-S-XFTR--"]=[E["SE.IC.TRAWLER"]],t["S-S-XFDR--"]=[E["SE.IC.FISHING VESSEL DREDGE"]],t["S-S-XR----"]=[E["SE.IC.LEISURE CRAFT, SAILING BOAT"]],t["S-S-XL----"]=[E["SE.IC.LAW ENFORCEMENT VESSEL"]],t["S-S-XH----"]=[E["SE.IC.HOVERCRAFT CIVILIAN"]],t["S-S-XA----"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED"]],t["S-S-XAR---"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]],t["S-S-XAS---"]=[E["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]],t["S-S-XP----"]=[E["SE.IC.LEISURE CRAFT, JETSKI"]],t["S-S-O-----"]=[E["SE.IC.OWN SHIP"]],t["S-S-E-----"]=[],t["S-S-ED----"]=[E["SE.IC.DITCHED AIRCRAFT"]],t["S-S-EP----"]=[E["SE.IC.PERSON IN WATER"]],t["S-S-EV----"]=[E["SE.IC.DISTRESSED VESSEL"]],t["S-S-Z-----"]=[],t["S-S-ZM----"]=[E["SE.IC.SEA MINELIKE"]],t["S-S-ZN----"]=[E["SE.IC.NAVIGATIONAL"]],t["S-S-ZI----"]=[E["SE.IC.ICEBERG"]]}};function o(t,I,E,e,R,C){var A=I.affiliation||"Friend",T=I.frame,I=I.numberSIDC,S=E.iconColor[A],N=E.iconFillColor[A],O=E.white[A],A=E.black[A],i={};i["SU.IC.MILITARY"]=a("MIL"),i["SU.IC.CIVILIAN"]=a("CIV"),i["SU.IC.CIVILIAN"].fill=(e||I||!T)&&N,i["SU.IC.CIVILIAN"].stroke=A,i["SU.IC.CIVILIAN"].strokewidth=3,i["SU.IC.MANUAL TRACK"]=a("MAN"),i["SU.IC.SUBMARINE"]={type:"path",d:"m 75,85 50,0 15,15 -15,15 -50,0 -15,-15 z"},i["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 20,0 0,-10 10,0 0,10 20,0 10,10 -10,10 z"},i["SU.IC.SUBMARINE CONVENTIONAL PROPULSION, SURFACED"]=[{type:"path",d:"m 75,110 -10,-10 10,-10 20,0 0,-10 10,0 0,10 20,0 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],i["SU.IC.SUBMARINE NUCLEAR PROPULSION"]={type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},i["SU.IC.SUBMARINE NUCLEAR PROPULSION, SURFACED"]=[{type:"path",d:"m 75,110 -10,-10 10,-10 0,-10 50,0 0,10 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],i["SU.IC.SUBMARINE ATTACK (SSN)"]={type:"text",fill:O,stroke:!1,x:100,y:110,fontsize:30,text:"A"},i["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]={type:"text",fill:O,stroke:!1,x:100,y:110,fontsize:30,text:"M"},i["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]={type:"text",fill:O,stroke:!1,x:100,y:110,fontsize:30,text:"G"},i["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]={type:"text",fill:O,stroke:!1,x:100,y:110,fontsize:30,text:"B"},i["SU.IC.SUBMARINE, SURFACED"]=[{type:"path",d:"m 75,80 50,0 15,15 -15,15 -50,0 -15,-15 z"},{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],i["SU.IC.SUBMARINE, BOTTOMED"]=[{type:"path",d:"m 75,80 50,0 15,15 -15,15 -50,0 -15,-15 z"},{type:"path",d:"m 70,120 0,-5 60,0 0,5 z"}],i["SU.IC.SUBMARINE, SNORKELING"]=[{type:"path",d:"m 75,120 -10,-10 10,-10 20,0 0,-20 10,0 0,20 20,0 10,10 -10,10 z"},{type:"path",fill:!1,d:"m 65,95 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],i["SU.IC.OTHER SUBMERSIBLE"]={type:"path",d:"m 85,90 0,-10 30,0 0,10 m 20,10 c 0,5.5 -15.7,10 -35,10 -19.3,0 -35,-4.5 -35,-10 0,-5.5 15.7,-10 35,-10 19.3,0 35,4.5 35,10 z"},i["SU.IC.OTHER SUBMERSIBLE, SURFACED"]=[i["SU.IC.OTHER SUBMERSIBLE"],{type:"path",fill:!1,d:"m 65,120 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"}],i["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]={type:"path",d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z",stroke:!1},i["SU.IC.NON-SUBMARINE"]=e&&!I?{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:100,fontsize:35,text:"NON"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:93,fontsize:23,text:"NON"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:113,fontsize:23,text:"SUB"}],i["SU.IC.DIVER, MILITARY"]={type:"path",stroke:!1,d:"M 100 80 C 93.7 80 88.3 82.7 85.8 88.3 L 85.8 88.3 L 77.8 88.3 L 77.8 105 L 85.8 105 L 85.8 104.8 C 87.3 108.2 88.8 110 92 111.7 L 92.1 111.7 L 84.2 120 L 115.8 120 L 107.9 111.7 L 108 111.7 C 111.1 110 112.8 108.3 114.3 105 L 122.2 105 L 122.2 88.3 L 114.3 88.3 L 114.3 88.3 C 111.7 82.8 106.3 80 100 80 z M 100 86.6 C 105.4 86.6 109.8 91.1 109.8 96.6 C 109.8 102.1 105.4 106.6 100 106.6 C 94.6 106.6 90.1 102.1 90.1 96.6 C 90.1 91.1 94.6 86.6 100 86.6 z M 100 89.6 C 96.2 89.6 93.1 92.7 93.1 96.6 C 93.1 100.5 96.2 103.6 100 103.6 C 103.8 103.6 106.8 100.5 106.8 96.6 C 106.8 92.7 103.8 89.6 100 89.6 z"},i["SU.IC.SUBMERSIBLE, CIVILIAN"]={type:"path",fill:(e||!T)&&N,d:"m 85,90 0,-10 30,0 0,10 m 20,10 c 0,5.5 -15.7,10 -35,10 -19.3,0 -35,-4.5 -35,-10 0,-5.5 15.7,-10 35,-10 19.3,0 35,4.5 35,10 z"},i["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV), CIVILIAN"]={type:"path",fill:(e||!T)&&N,d:"m 60,84 40,20 40,-20 0,8 -40,25 -40,-25 z"},i["SU.M1.CYBERSPACE"]=P("CYB"),i["SU.M1.HIJACKER"]=P("HJ"),i["SU.M2.CYBERSPACE"]=r("CYB"),i["SU.IC.DIVER, CIVILIAN"]={type:"path",fill:N,d:"M 114.3,94 C 114.3,102.3 107.9,109 100,109 c -7.9,0 -14.2,-6.7 -14.2,-15 0,-8.3 6.4,-15 14.2,-15 7.9,0 14.3,6.7 14.3,15 z m 0,27 14.3,15 -57,0 14.3,-15 M 125.7,79 l 14.3,0 0,30 -14.3,0 m -51.3,0 -14.3,0 0,-30 14.3,0 m 54.2,15 c 0,16.6 -12.8,30 -28.5,30 -15.7,0 -28.5,-13.4 -28.5,-30 C 71.5,77.4 84.3,64 100,64 115.7,64 128.5,77.4 128.5,94 z"},i["SU.IC.UNDERWATER WEAPON"]=a("WPN"),i["SU.IC.TORPEDO"]={type:"path",d:"m 65,105 -5,-5 5,-5 60,0 c 0,0 5,5 5,5 l 5,-5 0,10 -5,-5 -5,5 z"},i["SU.IC.IMPROVISED EXPLOSIVE DEVICE (IED)"]=a("IED"),i["SU.IC.UNDERWATER DECOY"]={type:"path",stroke:A,d:e?"M 105,110 90,95 105,80 z M 85,110 70,95 85,80 z m 40,-30 -15,15 15,15 z m -55,40 0,-5 55,0 0,5 z":"M 105,120 90,105 105,90 z M 85,120 70,105 85,90 z m 40,-30 -15,15 15,15 z m -55,-5 0,-5 55,0 0,5 z",fill:e?S:N},i["SU.IC.UNDERWATER DECOY DSymbol"]={type:"path",d:"M 85 81 L 65 98 L 85 119 L 85 81 z M 110 81 L 90 98 L 110 119 L 110 81 z M 135 81 L 115 98 L 135 119 L 135 81 z"},i["SU.IC.ECHO TRACKER CLASSIFIER (ETC)/POSSIBLE CONTACT (POSCON)"]={type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:120,fontsize:60,text:"?"},i["SU.IC.FUSED TRACK"]=[a("?"),{type:"path",fill:!1,d:"m 70,65 10,35 -10,35 60,0 -10,-35 10,-35"}],i["SU.IC.SEA MINE"]={type:"path",fill:!e&&!I||R?N:E.iconColor.Hostile,stroke:!e&&!I||R?S:A,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},i["SU.IC.SEA MINE - BOTTOM"]=[i["SU.IC.SEA MINE"],{type:"path",fill:!e&&!I||R?N:E.iconColor.Hostile,stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE - MOORED"]=[i["SU.IC.SEA MINE"],{type:"path",fill:!e&&!I||R?N:E.iconColor.Hostile,stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,130.5 l 0,7.3"}],i["SU.IC.SEA MINE - FLOATING"]=[i["SU.IC.SEA MINE"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE - RISING"]=[i["SU.IC.SEA MINE"],{type:"path",fill:I&&C?"":!e&&!I||R?N:E.iconColor.Hostile,stroke:!e&&!I||R?S:A,d:"m 100,128 -10,15 20,0 z"}],i["SU.IC.SEA MINE (IN OTHER POSITION)"]=[i["SU.IC.SEA MINE"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 130,100 15,0 M 70,100 l -15,0"}],i["SU.IC.SEA MINE - KINGFISHER"]=[i["SU.IC.SEA MINE"],{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"K"}],i["SU.IC.SEA MINE - SMALL OBJECT"]=[i["SU.IC.SEA MINE"],{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"SO"}],i["SU.IC.SEA MINE EXERCISE MINE"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"EX"},I?[]:{type:"text",alignmentBaseline:"middle",stroke:!1,fill:!e&&!I||R?S:A,x:150,y:36,fontsize:40,text:"X"}],i["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]=[i["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE EXERCISE MINE - MOORED"]=[i["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,130.5 l 0,7.3"}],i["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]=[i["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE EXERCISE MINE - RISING"]=[i["SU.IC.SEA MINE EXERCISE MINE"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 100,128 -10,15 20,0 z"}],i["SU.IC.SEA MINE DECOY"]={type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 106.6,101.6 0,26.3 -13.1,-13.1 z m -19.7,0 0,26.3 -13.1,-13.1 z m 39.4,0 0,26.3 -13.1,-13.1 13.1,-13.1 M 100,75.3 c -14.5,0 -26.3,11.8 -26.3,26.3 l 52.5,0 C 126.3,87.1 114.5,75.3 100,75.3 z m -6.6,0 0,-13.1 13.1,0 0,13.1 m -29.8,12.3 -9.3,-9.3 9.3,-9.3 9.3,9.3 m 27.9,0 9.3,-9.3 9.3,9.3 -9.3,9.3"},i["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]=[i["SU.IC.SEA MINE DECOY"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE DECOY, MOORED"]=[i["SU.IC.SEA MINE DECOY"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 75,140 50,0 M 100,100 l 0,40"}],i["SU.IC.SEA MINE NEUTRALIZED"]=[{type:"path",fill:!e&&!I||R?N:E.iconColor.Neutral,stroke:!e&&!I||R?S:A,d:"M 115.9,73 126.5,62.4 137.1,73 126.5,83.6 m -53,0 L 62.9,73 73.5,62.4 84.1,73 m 8.4,-3 0,-15 15,0 0,15 m 22.5,30 c 0,16.6 -13.4,30 -30,30 -16.6,0 -30,-13.4 -30,-30 0,-16.6 13.4,-30 30,-30 C 116.6,70 130,83.4 130,100 z"},{type:"path",strokewidth:5,stroke:C?O:A,d:"m 135,65 -70,70 m 0,-70 70,70"}],i["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]=[i["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!e&&!I||R?N:E.iconColor.Neutral,stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE NEUTRALIZED - MOORED"]=[i["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!e&&!I||R?N:E.iconColor.Neutral,stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,130.5 l 0,7.3"}],i["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]=[i["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE NEUTRALIZED - RISING"]=[i["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!e&&!I||R?N:E.iconColor.Neutral,stroke:!e&&!I||R?S:A,d:"m 100,128 -10,15 20,0 z"}],i["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]=[i["SU.IC.SEA MINE NEUTRALIZED"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 130,100 15,0 M 70,100 l -15,0"}],i["SU.IC.SEA MINE MILEC"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"E"}],i["SU.IC.SEA MINE MILEC - BOTTOM"]=[i["SU.IC.SEA MINE MILEC"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE MILEC - MOORED"]=[i["SU.IC.SEA MINE MILEC"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,128.5 l 0,9.3"}],i["SU.IC.SEA MINE MILEC - FLOATING"]=[i["SU.IC.SEA MINE MILEC"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE MINE ANCHOR"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!(!e&&!I||R)&&A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:18,text:"ANCR"}],i["SU.IC.SEA MINE MILCO"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,141,42)",stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},I?[]:{type:"text",alignmentBaseline:"middle",stroke:!1,fill:!e&&!I||R?S:A,x:100,y:103,fontsize:30,text:"#"}],i["SU.IC.SEA MINE MILCO - BOTTOM"]=[i["SU.IC.SEA MINE MILCO"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,141,42)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE MILCO - MOORED"]=[i["SU.IC.SEA MINE MILCO"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,128.5 l 0,9.3"}],i["SU.IC.SEA MINE MILCO - FLOATING"]=[i["SU.IC.SEA MINE MILCO"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"1"},i["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"2"},i["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"3"},i["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"4"},i["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:35,text:"5"},i["SU.IC.SEA MINE NEGATIVE REACQUISITION"]=[{type:"path",strokedasharray:"8,4",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"NR"}],i["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]=[i["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]=[i["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,130.5 l 0,7.3"}],i["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]=[i["SU.IC.SEA MINE NEGATIVE REACQUISITION"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.SEA MINE GENERAL OBSTRUCTOR"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(255,255,0)",stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"OB"}],i["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]=[{type:"path",fill:!e&&!I||R?N:E.iconColor.Neutral,stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",stroke:!1,fill:!e&&!I||R||C?O:A,x:100,y:112,fontsize:30,text:"OB"},{type:"path",strokewidth:5,stroke:C?O:A,d:"m 135,65 -70,70 m 0,-70 70,70"}],i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"]=[{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 113.8,127.6 -27.6,0 -13.8,-13.8 0,-27.6 13.8,-13.8 27.6,0 13.8,13.8 0,27.6 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:R||(!e&&!I||C?O:A),x:100,y:103,fontsize:30,text:"N"}],i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]=[i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 74.8,125.2 50.4,0 0,12.6 -50.4,0 z"}],i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]=[i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!e&&!I||R?N:C?A:"rgb(0, 130, 24)",stroke:!e&&!I||R?S:A,d:"m 75.5,136.8 49,0 M 100,128.5 l 0,9.3"}],i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]=[i["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"],{type:"path",fill:!1,stroke:!e&&!I||R?S:A,d:"m 75,140 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10 5,-10 5,10"}],i["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]=[{type:"path",strokedasharray:"8,4",fill:!1,stroke:!e&&!I||R?S:E.iconColor.Hostile,d:"m 85,65 30,0 20,20 0,30 -20,20 -30,0 -20,-20 0,-30 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:!e&&!I||R?S:E.iconColor.Hostile,x:100,y:103,fontsize:30,text:"UXO"}],i["SU.IC.ENVIRONMENTAL REPORT LOCATION"]=[{type:"path",fill:!1,stroke:!e&&!I||R?S:E.iconColor.Neutral,d:"m 70,70 0,60 60,0 0,-60 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:!e&&!I||R?S:E.iconColor.Neutral,x:100,y:107,fontsize:60,text:"E"}],i["SU.IC.DIVE REPORT LOCATION"]=[{type:"path",fill:!1,stroke:!e&&!I||R?S:E.iconColor.Neutral,d:"m 70,70 0,60 60,0 0,-60 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,fill:!e&&!I||R?S:E.iconColor.Neutral,x:100,y:107,fontsize:60,text:"D"}],i["SU.IC.SEABED INSTALLATION/MANMADE"]={type:"path",fill:N,stroke:A,d:"m 140,125 -80,0 10,-30 10,20 20,-50 20,50 10,-25 z"},i["SU.IC.SEABED INSTALLATION, MAN-MADE, MILITARY"]={type:"path",d:"m 75,80 0,40 50,0 0,-15 -15,0 0,-10 -20,0 0,-15 z"},i["SU.IC.SEABED INSTALLATION, MAN-MADE, NON-MILITARY"]={type:"path",fill:N,d:"m 75,80 0,40 50,0 0,-15 -15,0 0,-10 -20,0 0,-15 z"},i["SU.IC.SEABED ROCK/STONE, OBSTACLE, OTHER"]={type:"path",d:"m 140,125 -80,0 10,-30 10,20 20,-50 20,50 10,-25 z"},i["SU.IC.WRECK"]={type:"path",d:"m 125,85 0,30 m -50,-30 0,30 m 25,-40 0,45 m -40,-20 80,0"},i["SU.IC.MARINE LIFE"]={type:"path",d:"m 60,100 20,-20 45,20 15,-10 0,20 -15,-10 -45,20 z"},i["SU.IC.SEA ANOMALY"]={type:"path",fill:!1,d:"m 65,100 15,-20 20,30 20,-30 15,20 m -70,10 15,-20 20,30 20,-30 15,20"},i["SU.M1.ANTISUBMARINE WARFARE"]=P("ASW"),i["SU.M1.AUXILIARY"]=P("AUX"),i["SU.M1.COMMAND AND CONTROL"]=P("C2"),i["SU.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]=P("ISR"),i["SU.M1.MINE COUNTERMEASURES"]=P("MCM"),i["SU.M1.MINE WARFARE"]=P("MIW"),i["SU.M1.SURFACE WARFARE"]=P("SUW"),i["SU.M1.ATTACK"]=P("A"),i["SU.M1.BALLISTIC MISSILE"]=P("B"),i["SU.M1.GUIDED MISSILE"]=P("G"),i["SU.M1.OTHER GUIDED MISSILES (POINT DEFENCE)"]=P("M"),i["SU.M1.SPECIAL OPERATIONS FORCE"]=P("SOF"),i["SU.M1.POSSIBLE SUBMARINE - LOW 1"]=P("P1"),i["SU.M1.POSSIBLE SUBMARINE - LOW 2"]=P("P2"),i["SU.M1.POSSIBLE SUBMARINE - HIGH 3"]=P("P3"),i["SU.M1.POSSIBLE SUBMARINE - HIGH 4"]=P("P4"),i["SU.M1.PROBABLE SUBMARINE"]=P("PB"),i["SU.M1.CERTAIN SUBMARINE"]=P("CT"),i["SU.M1.ANTI-TORPEDO TORPEDO"]=P("ATT"),i["SU.M1.HIJACKING/HIJACKED"]=P("H"),i["SU.M2.POSSIBLE SUBMARINE - LOW 1"]=r("P1"),i["SU.M2.POSSIBLE SUBMARINE - LOW 2"]=r("P2"),i["SU.M2.POSSIBLE SUBMARINE - HIGH 3"]=r("P3"),i["SU.M2.POSSIBLE SUBMARINE - HIGH 4"]=r("P4"),i["SU.M2.PROBABLE SUBMARINE"]=r("PB"),i["SU.M2.AIR INDEPENDENT PROPULSION"]=r("AI"),i["SU.M2.CERTSUB"]=r("CT"),i["SU.M2.DIESEL PROPULSION"]=r("D"),i["SU.M2.DIESEL - TYPE 1"]=r("D1"),i["SU.M2.DIESEL - TYPE 2"]=r("D2"),i["SU.M2.DIESEL - TYPE 3"]=r("D3"),i["SU.M2.NUCLEAR POWERED"]=r("N"),i["SU.M2.NUCLEAR - TYPE 1"]=r("N1"),i["SU.M2.NUCLEAR - TYPE 2"]=r("N2"),i["SU.M2.NUCLEAR - TYPE 3"]=r("N3"),i["SU.M2.NUCLEAR - TYPE 4"]=r("N4"),i["SU.M2.NUCLEAR - TYPE 5"]=r("N5"),i["SU.M2.NUCLEAR - TYPE 6"]=r("N6"),i["SU.M2.NUCLEAR - TYPE 7"]=r("N7"),i["SU.M2.AUTONOMOUS CONTROL"]=r("AUT"),i["SU.M2.REMOTELY PILOTED"]=r("RP"),i["SU.M2.EXPENDABLE"]=r("EXP");for(const M in i)i.hasOwnProperty(M)&&(t.hasOwnProperty(M)&&console.warn("Override of: "+M),s.call(this,i[M],S),t[M]=i[M])}var n={type:"letter",getMetadata:e,getIcons:R,iconParts:[o],icons:function(t,I,E,e){t["S-U-------"]=[],t["S-U-S-----"]=[E["SU.IC.SUBMARINE"]],t["S-U-SF----"]=[E["SU.IC.SUBMARINE, SURFACED"]],t["S-U-SB----"]=[E["SU.IC.SUBMARINE, BOTTOMED"]],t["S-U-SR----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.CERTSUB"]],t["S-U-SX----"]=[E["SU.IC.NON-SUBMARINE"]],t["S-U-SN----"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"]],t["S-U-SNF---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION, SURFACED"]],t["S-U-SNA---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE ATTACK (SSN)"]],t["S-U-SNM---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]],t["S-U-SNG---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]],t["S-U-SNB---"]=[E["SU.IC.SUBMARINE NUCLEAR PROPULSION"],E["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]],t["S-U-SC----"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"]],t["S-U-SCF---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION, SURFACED"]],t["S-U-SCA---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE ATTACK (SSN)"]],t["S-U-SCM---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE MISSILE (TYPE UNKNOWN)"]],t["S-U-SCG---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE GUIDED MISSILE (SSGN)"]],t["S-U-SCB---"]=[E["SU.IC.SUBMARINE CONVENTIONAL PROPULSION"],E["SU.IC.SUBMARINE BALLISTIC MISSILE (SSBN)"]],t["S-U-SO----"]=[E["SU.IC.OTHER SUBMERSIBLE"]],t["S-U-SOF---"]=[E["SU.IC.OTHER SUBMERSIBLE, SURFACED"]],t["S-U-SU----"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],t["S-U-SUM---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.MINE COUNTERMEASURES"]],t["S-U-SUS---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.ANTISUBMARINE WARFARE"]],t["S-U-SUN---"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"],E["SU.M1.SURFACE WARFARE"]],t["S-U-S1----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - LOW 1"]],t["S-U-S2----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - LOW 2"]],t["S-U-S3----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - HIGH 3"]],t["S-U-S4----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.POSSIBLE SUBMARINE - HIGH 4"]],t["S-U-SL----"]=[E["SU.IC.SUBMARINE"],E["SU.M2.PROBABLE SUBMARINE"]],t["S-U-SK----"]=[E["SU.IC.SUBMARINE, SNORKELING"]],t["S-U-W-----"]=[E["SU.IC.UNDERWATER WEAPON"]],t["S-U-WT----"]=[E["SU.IC.TORPEDO"]],t["S-U-WM----"]=[E["SU.IC.SEA MINE"]],t["S-U-WMD---"]=[E["SU.IC.SEA MINE NEUTRALIZED"]],t["S-U-WMG---"]=[E["SU.IC.SEA MINE - BOTTOM"]],t["S-U-WMGD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]],t["S-U-WMGX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]],t["S-U-WMGE--"]=[E["SU.IC.SEA MINE MILEC - BOTTOM"]],t["S-U-WMGC--"]=[E["SU.IC.SEA MINE MILCO - BOTTOM"]],t["S-U-WMGR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]],t["S-U-WMGO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]],t["S-U-WMM---"]=[E["SU.IC.SEA MINE - MOORED"]],t["S-U-WMMD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - MOORED"]],t["S-U-WMMX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - MOORED"]],t["S-U-WMME--"]=[E["SU.IC.SEA MINE MILEC - MOORED"]],t["S-U-WMMC--"]=[E["SU.IC.SEA MINE MILCO - MOORED"]],t["S-U-WMMR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]],t["S-U-WMMO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]],t["S-U-WMF---"]=[E["SU.IC.SEA MINE - FLOATING"]],t["S-U-WMFD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]],t["S-U-WMFX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]],t["S-U-WMFE--"]=[E["SU.IC.SEA MINE MILEC - FLOATING"]],t["S-U-WMFC--"]=[E["SU.IC.SEA MINE MILCO - FLOATING"]],t["S-U-WMFR--"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]],t["S-U-WMFO--"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]],t["S-U-WMO---"]=[E["SU.IC.SEA MINE (IN OTHER POSITION)"]],t["S-U-WMOD--"]=[E["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]],t["S-U-WMX---"]=[E["SU.IC.SEA MINE EXERCISE MINE"]],t["S-U-WME---"]=[E["SU.IC.SEA MINE MILEC"]],t["S-U-WMA---"]=[E["SU.IC.SEA MINE MINE ANCHOR"]],t["S-U-WMC---"]=[E["SU.IC.SEA MINE MILCO"]],t["S-U-WMR---"]=[E["SU.IC.SEA MINE NEGATIVE REACQUISITION"]],t["S-U-WMB---"]=[E["SU.IC.SEA MINE GENERAL OBSTRUCTOR"]],t["S-U-WMBD--"]=[E["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]],t["S-U-WMN---"]=[E["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"]],t["S-U-WMS---"]=[E["SU.IC.SEA MINE - RISING"]],t["S-U-WMSX--"]=[E["SU.IC.SEA MINE EXERCISE MINE - RISING"]],t["S-U-WMSD--"]=[E["SU.IC.SEA MINE NEUTRALIZED - RISING"]],t["S-U-WV----"]=[E["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],t["S-U-WD----"]=[E["SU.IC.UNDERWATER DECOY"]],t["S-U-WDM---"]=[E["SU.IC.SEA MINE DECOY"]],t["S-U-WDMG--"]=[E["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]],t["S-U-WDMM--"]=[E["SU.IC.SEA MINE DECOY, MOORED"]],t["S-U-N-----"]=[E["SU.IC.NON-SUBMARINE"]],t["S-U-ND----"]=[E["SU.IC.DIVER, CIVILIAN"]],t["S-U-NB----"]=[],t["S-U-E-----"]=[E["SU.IC.ENVIRONMENTAL REPORT LOCATION"]],t["S-U-V-----"]=[E["SU.IC.DIVE REPORT LOCATION"]],t["S-U-X-----"]=[E["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]],t["S-U-NBS---"]=[E["SU.IC.SEABED INSTALLATION/MANMADE"]],t["S-U-NBR---"]=[E["SU.IC.SEABED ROCK/STONE, OBSTACLE, OTHER"]],t["S-U-NBW---"]=[E["SU.IC.WRECK"]],t["S-U-NM----"]=[E["SU.IC.MARINE LIFE"]],t["S-U-NA----"]=[E["SU.IC.SEA ANOMALY"]]}},h={type:"letter",getMetadata:e,getIcons:R,iconParts:[N,T],icons:function(t,I,E,e){t["S-F-------"]=[E["GR.IC.SPECIAL OPERATIONS FORCES"]],t["S-F-A-----"]=[E["AR.I.MILITARY ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-AF----"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-AFA---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.ATTACK"]],t["S-F-AFK---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.REFUEL"]],t["S-F-AFU---"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.UTILITY"]],t["S-F-AFUL--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.LIGHT"]],t["S-F-AFUM--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.MEDIUM"]],t["S-F-AFUH--"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.HEAVY"]],t["S-F-AV----"]=[E["AR.I.MILITARY FIXED WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.VSTOL"]],t["S-F-AH----"]=e?[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["GR.IC.AVIATION ROTARY WING 2525C"]]:[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-AHH---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.COMBAT SEARCH AND RESCUE"]],t["S-F-AHA---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.ATTACK"]],t["S-F-AHU---"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["SOF.M2.UTILITY"]],t["S-F-AHUL--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.LIGHT"]],t["S-F-AHUM--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.MEDIUM"]],t["S-F-AHUH--"]=[E["GR.IC.AVIATION ROTARY WING"],E["AIR.M1.SPECIAL OPERATIONS FORCES"],E["AIR.M2.HEAVY"]],t["S-F-SN----"]=t["S-F-N-----"]=[E["GR.IC.NAVAL"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-SNS---"]=t["S-F-NS----"]=[E["GR.IC.SEA-AIR-LAND"]],t["S-F-SNU---"]=t["S-F-NU----"]=[E["SOF.IC.UNDERWATER DEMOLITION TEAM"]],t["S-F-SNB---"]=t["S-F-NB----"]=[E["GR.IC.COMBATANT"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-SNN---"]=t["S-F-NN----"]=[E["GR.IC.SUBMARINE NUCLEAR PROPULSION"],E["AIR.M1.SPECIAL OPERATIONS FORCES"]],t["S-F-G-----"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.SPECIAL OPERATIONS FORCES"]],t["S-F-GS----"]=[E["GR.IC.SPECIAL FORCES"]],t["S-F-GR----"]=t["S-F-GSR---"]=[E["GR.IC.FF.INFANTRY"],E["AIR.M1.RECONNAISSANCE"],E["GR.M2.AIRBORNE"]],t["S-F-GP----"]=t["S-F-GSP---"]=[E["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]],t["S-F-GPA---"]=t["S-F-GSPA--"]=[E["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"],L._translate(0,-30,L._scale(.7,E["AR.I.MILITARY FIXED WING"]))],t["S-F-GC----"]=t["S-F-GCA---"]=[E["GR.IC.CIVIL AFFAIRS"]],t["S-F-GB----"]=t["S-F-B-----"]=[E["GR.IC.SPECIAL OPERATIONS FORCES"],E["GR.M2.SUPPORT"]]}};function Z(t,I,E,e,R,C){var I=I.affiliation||"Friend",A=E.iconColor[I],T={"SI.IC.COMMUNICATIONS":{type:"path",d:"m 93,120 14,0 0,0 m -7,-27 0,27 m 2,-25 8,2 -5,5 13,3 m -20,-10 -8,2 5,5 -14,3 m 21,-13 8,-2 -5,-5 13,-3 m -37,0 14,3 -5,5 8,2",fill:!1},"SI.IC.RADAR":{type:"path",d:"m 115,90 -15,15 0,-15 -15,15 M 80,85 c 0,25 15,35 35,35",fill:!1}};T["SI.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]=a("J"),T["SI.M1.ANTI-AIRCRAFT FIRE CONTROL"]=P("AA"),T["SI.M1.AIRBORNE SEARCH AND BOMBING"]=P("AB"),T["SI.M1.AIRBORNE INTERCEPT"]=P("AI"),T["SI.M1.ALTIMETER"]=P("AL"),T["SI.M1.AIRBORNE RECONNAISSANCE AND MAPPING"]=P("AM"),T["SI.M1.AIR TRAFFIC CONTROL"]=P("AT"),T["SI.M1.BEACON TRANSPONDER (NOT IFF)"]=P("BN"),T["SI.M1.BATTLEFIELD SURVEILLANCE"]=P("BS"),T["SI.M1.CONTROLLED APPROACH"]=P("CA"),T["SI.M1.CONTROLLED INTERCEPT"]=P("CI"),T["SI.M1.CELLULAR/MOBILE"]=P("CM"),T["SI.M1.COASTAL SURVEILLANCE"]=P("CS"),T["SI.M1.CYBER"]=P("CYB"),T["SI.M1.DECOY/MIMIC"]=P("DC"),T["SI.M1.DATA TRANSMISSION"]=P("DT"),T["SI.M1.EARTH SURVEILLANCE"]=P("ES"),T["SI.M1.EARLY WARNING"]=P("EW"),T["SI.M1.FIRE CONTROL"]=P("FC"),T["SI.M1.GROUND MAPPING"]=P("GM"),T["SI.M1.HEIGHT FINDING"]=P("HF"),T["SI.M1.HARBOR SURVEILLANCE"]=P("HS"),T["SI.M1.IDENTIFICATION, FRIEND OR FOE (INTERROGATOR)"]=P("IF"),T["SI.M1.INSTRUMENT LANDING SYSTEM"]=P("IL"),T["SI.M1.IONOSPHERIC SOUNDING"]=P("IS"),T["SI.M1.IDENTIFICATION, FRIEND OR FOE (TRANSPONDER)"]=P("IT"),T["SI.M1.BARRAGE JAMMER"]=P("JB"),T["SI.M1.CLICK JAMMER"]=P("JC"),T["SI.M1.DECEPTIVE JAMMER"]=P("JD"),T["SI.M1.FREQUENCY SWEPT JAMMER"]=P("JF"),T["SI.M1.JAMMER (GENERAL)"]=P("JG"),T["SI.M1.NOISE JAMMER"]=P("JN"),T["SI.M1.PULSED JAMMER"]=P("JP"),T["SI.M1.REPEATER JAMMER"]=P("JR"),T["SI.M1.SPOT NOISE JAMMER"]=P("JS"),T["SI.M1.TRANSPONDER JAMMER"]=P("JT"),T["SI.M1.MISSILE ACQUISITION"]=P("MA"),T["SI.M1.MISSILE CONTROL"]=P("MC"),T["SI.M1.MISSILE DOWNLINK"]=P("MD"),T["SI.M1.METEOROLOGICAL"]=P("ME"),T["SI.M1.MULTI-FUNCTION"]=P("MF"),T["SI.M1.MISSILE GUIDANCE"]=P("MG"),T["SI.M1.MISSILE HOMING"]=P("MH"),T["SI.M1.MISSILE TRACKING"]=P("MT"),T["SI.M1.NAVIGATIONAL/GENERAL"]=P("NA"),T["SI.M1.NAVIGATIONAL/DISTANCE MEASURING EQUIPMENT"]=P("ND"),T["SI.M1.NAVIGATION/TERRAIN FOLLOWING"]=P("NT"),T["SI.M1.NAVIGATIONAL/WEATHER AVOIDANCE"]=P("NW"),T["SI.M1.OMNI-LINE OF SIGHT (LOS)"]=P("OL"),T["SI.M1.PROXIMITY USE"]=P("PF"),T["SI.M1.POINT-TO-POINT LINE OF SIGHT (LOS)"]=P("PP"),T["SI.M1.INSTRUMENTATION"]=P("RI"),T["SI.M1.RANGE ONLY"]=P("RO"),T["SI.M1.SONOBUOY"]=P("SB"),T["SI.M1.SATELLITE DOWNLINK"]=P("SD"),T["SI.M1.SPACE"]=P("SP"),T["SI.M1.SURFACE SEARCH"]=P("SS"),T["SI.M1.SHELL TRACKING"]=P("ST"),T["SI.M1.SATELLITE UPLINK"]=P("SU"),T["SI.M1.TARGET ACQUISITION"]=P("TA"),T["SI.M1.TARGET ILLUMINATION"]=P("TI"),T["SI.M1.TROPOSPHERIC SCATTER"]=P("TS"),T["SI.M1.TARGET TRACKING"]=P("TT"),T["SI.M1.UNKNOWN"]=P("UN"),T["SI.M1.VIDEO REMOTING"]=P("VR"),T["SI.M1.EXPERIMENTAL"]=P("XP"),T["SI.M1.ALPHA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"A"},T["SI.M1.BRAVO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"B"},T["SI.M1.CHARLIE"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"C"},T["SI.M1.DELTA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"D"},T["SI.M1.ECHO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"E"},T["SI.M1.FOXTROT"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"F"},T["SI.M1.HOTEL"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"H"},T["SI.M1.INDY"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"I"},T["SI.M1.MIKE"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"M"},T["SI.M1.OSCAR"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"O"},T["SI.M1.PAPA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"P"},T["SI.M1.SIERRA"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"S"},T["SI.M1.TANGO"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"T"},T["SI.M1.UNIFORM"]={type:"text",stroke:!1,x:68,y:110,fontsize:25,text:"U"},T["SI.M2.ALPHA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"A"},T["SI.M2.BRAVO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"B"},T["SI.M2.CHARLIE"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"C"},T["SI.M2.CYBER"]=r("CYB"),T["SI.M2.DELTA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"D"},T["SI.M2.ECHO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"E"},T["SI.M2.FOXTROT"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"F"},T["SI.M2.GOLF"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"G"},T["SI.M2.INDY"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"I"},T["SI.M2.LIMA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"L"},T["SI.M2.MIKE"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"M"},T["SI.M2.NOVEMBER"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"N"},T["SI.M2.PAPA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"P"},T["SI.M2.SIERRA"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"S"},T["SI.M2.TANGO"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"T"},T["SI.M2.UNIFORM"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"U"},T["SI.M2.WHISKEY"]={type:"text",stroke:!1,x:132,y:110,fontsize:25,text:"W"},T["SI.M3.SPACE"]={type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"S"},T["SI.M3.GROUND"]={type:"text",stroke:!1,x:100,y:75,fontsize:25,text:"G"};for(const S in T)T.hasOwnProperty(S)&&(t.hasOwnProperty(S)&&console.warn("Override of: "+S),s.call(this,T[S],A),t[S]=T[S])}var c={type:"letter",getMetadata:e,getIcons:R,iconParts:[Z],icons:function(t,I,E,e){t["I-P-S-----"]=[],t["I-P-SC----"]=[],t["I-P-SCD---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.DELTA"],E["SI.M3.SPACE"]],t["I-P-SR----"]=[],t["I-P-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"],E["SI.M3.SPACE"]],t["I-P-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.SIERRA"],E["SI.M3.SPACE"]],t["I-P-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"],E["SI.M3.SPACE"]],t["I-P-SRM---"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"],E["SI.M3.SPACE"]],t["I-P-SRT---"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"],E["SI.M3.SPACE"]],t["I-P-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.PAPA"],E["SI.M3.SPACE"]],t["I-P-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"],E["SI.M3.SPACE"]],t["I-A-S-----"]=[],t["I-A-SC----"]=[],t["I-A-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"]],t["I-A-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],t["I-A-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],t["I-A-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],t["I-A-SR----"]=[],t["I-A-SRAI--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.INDY"]],t["I-A-SRAS--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.BRAVO"]],t["I-A-SRC---"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.INDY"]],t["I-A-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],t["I-A-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],t["I-A-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"]],t["I-A-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"]],t["I-A-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"]],t["I-A-SRMD--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.DELTA"]],t["I-A-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"]],t["I-A-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"]],t["I-A-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],t["I-A-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"]],t["I-A-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],t["I-A-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"]],t["I-A-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]],t["I-G-S-----"]=[],t["I-G-SC----"]=[],t["I-G-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"],E["SI.M3.GROUND"]],t["I-G-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"],E["SI.M3.GROUND"]],t["I-G-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"],E["SI.M3.GROUND"]],t["I-G-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"],E["SI.M3.GROUND"]],t["I-G-SCT---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.TANGO"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],t["I-G-SR----"]=[],t["I-G-SRAT--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],t["I-G-SRAA--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],t["I-G-SRB---"]=[E["SI.IC.RADAR"],E["SI.M1.BRAVO"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],t["I-G-SRCS--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.SIERRA"],E["SI.M3.GROUND"]],t["I-G-SRCA--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],t["I-G-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],t["I-G-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"],E["SI.M3.GROUND"]],t["I-G-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"],E["SI.M3.GROUND"]],t["I-G-SRH---"]=[E["SI.IC.RADAR"],E["SI.M1.HOTEL"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],t["I-G-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],t["I-G-SRMM--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ECHO"],E["SI.M3.GROUND"]],t["I-G-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],t["I-G-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"],E["SI.M3.GROUND"]],t["I-G-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],t["I-G-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"],E["SI.M3.GROUND"]],t["I-G-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],t["I-G-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"],E["SI.M3.GROUND"]],t["I-G-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"],E["SI.M3.GROUND"]],t["I-G-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"],E["SI.M3.GROUND"]],t["I-G-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"],E["SI.M3.GROUND"]],t["I-S-S-----"]=[],t["I-S-SC----"]=[],t["I-S-SCC---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.CHARLIE"],E["SI.M2.MIKE"]],t["I-S-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],t["I-S-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],t["I-S-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],t["I-S-SR----"]=[],t["I-S-SRAT--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.TANGO"]],t["I-S-SRAA--"]=[E["SI.IC.RADAR"],E["SI.M1.ALPHA"],E["SI.M2.ALPHA"]],t["I-S-SRCA--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.ALPHA"]],t["I-S-SRCI--"]=[E["SI.IC.RADAR"],E["SI.M1.CHARLIE"],E["SI.M2.INDY"]],t["I-S-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],t["I-S-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],t["I-S-SRF---"]=[E["SI.IC.RADAR"],E["SI.M1.FOXTROT"],E["SI.M2.CHARLIE"]],t["I-S-SRH---"]=[E["SI.IC.RADAR"],E["SI.M1.HOTEL"],E["SI.M2.FOXTROT"]],t["I-S-SRI---"]=[E["SI.IC.RADAR"],E["SI.M1.INDY"],E["SI.M2.FOXTROT"]],t["I-S-SRMM--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ECHO"]],t["I-S-SRMA--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.ALPHA"]],t["I-S-SRMG--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.GOLF"]],t["I-S-SRMT--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.TANGO"]],t["I-S-SRMF--"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],t["I-S-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.SIERRA"]],t["I-S-SRTA--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],t["I-S-SRTI--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.INDY"]],t["I-S-SRTT--"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.TANGO"]],t["I-S-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]],t["I-U-S-----"]=[],t["I-U-SC----"]=[],t["I-U-SCO---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.OSCAR"],E["SI.M2.LIMA"]],t["I-U-SCP---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.PAPA"],E["SI.M2.PAPA"]],t["I-U-SCS---"]=[E["SI.IC.COMMUNICATIONS"],E["SI.M1.SIERRA"],E["SI.M2.UNIFORM"]],t["I-U-SR----"]=[],t["I-U-SRD---"]=[E["SI.IC.RADAR"],E["SI.M1.DELTA"],E["SI.M2.TANGO"]],t["I-U-SRE---"]=[E["SI.IC.RADAR"],E["SI.M1.ECHO"],E["SI.M2.WHISKEY"]],t["I-U-SRM---"]=[E["SI.IC.RADAR"],E["SI.M1.MIKE"],E["SI.M2.FOXTROT"]],t["I-U-SRS---"]=[E["SI.IC.RADAR"],E["SI.M1.SIERRA"],E["SI.M2.SIERRA"]],t["I-U-SRT---"]=[E["SI.IC.RADAR"],E["SI.M1.TANGO"],E["SI.M2.ALPHA"]],t["I-U-SRU---"]=[E["SI.IC.RADAR"],E["SI.M1.UNIFORM"],E["SI.M2.NOVEMBER"]]}},y={type:"letter",getMetadata:e,getIcons:R,iconParts:[N],icons:function(t,I,E,e){t["O-V-A-----"]=[E["ST.IC.ARSON/FIRE"]],t["O-V-M-----"]=[E["ST.IC.KILLING VICTIM"]],t["O-V-MA----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.MURDER"]],t["O-V-MB----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.EXECUTION (WRONGFUL KILLING)"]],t["O-V-MC----"]=[E["ST.IC.KILLING VICTIM"],E["ST.M1.ASSASSINATION"]],t["O-V-B-----"]=[E["ST.IC.BOMB"]],t["O-V-Y-----"]=[E["ST.IC.BOOBY TRAP"]],t["O-V-D-----"]=[E["ST.IC.DRIVE-BY SHOOTING"]],t["O-V-S-----"]=[E["ST.IC.SNIPING"]],t["O-V-P-----"]=[E["ST.IC.POISONING"]],t["O-V-E-----"]=[E["ST.IC.EXPLOSION"]],t["O-V-EI----"]=[E["ST.IC.EXPLOSION"],E["ST.IC.IED"]],t["O-L-B-----"]=[E["ST.IC.BLACK LIST LOCATION"]],t["O-L-G-----"]=[E["ST.IC.GRAY LIST LOCATION"]],t["O-L-W-----"]=[E["ST.IC.WHITE LIST LOCATION"]],t["O-L-M-----"]=[E["ST.IC.MASS GRAVE LOCATION"]],t["O-O-P-----"]=[E["ST.IC.PATROLLING"]],t["O-O-R-----"]=[],t["O-O-RW----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.WILLING"]],t["O-O-RC----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.COERCED/IMPRESSED"]],t["O-O-D-----"]=[E["ST.IC.DEMONSTRATION"]],t["O-O-M-----"]=[E["ST.IC.MINE LAYING"]],t["O-O-Y-----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"]],t["O-O-YT----"]=[E["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]],t["O-O-YW----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],t["O-O-YH----"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.HOUSE-TO-HOUSE"]],t["O-O-F-----"]=[E["ST.IC.SEARCHING"]],t["O-O-S-----"]=[E["ST.IC.SPY"]],t["O-O-O-----"]=[E["ST.IC.FOOD DISTRIBUTION"]],t["O-O-E-----"]=[E["ST.IC.EXTORTION"]],t["O-O-H-----"]=[],t["O-O-HT----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],t["O-O-HA----"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],t["O-O-HV----"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],t["O-O-K-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"]],t["O-O-KA----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"],E["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],t["O-O-A-----"]=[E["ST.IC.ARREST"]],t["O-O-U-----"]=[E["ST.IC.DRUG RELATED ACTIVITIES"]],t["O-O-C-----"]=[E["ST.IC.COMPOSITE LOSS"]],t["O-O-CA----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.COMBAT"]],t["O-O-CB----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.ACCIDENT"]],t["O-O-CC----"]=[E["ST.IC.COMPOSITE LOSS"],E["ST.M1.OTHER"]],t["O-I-R-----"]=[E["ST.IC.GROUP"]],t["O-I-S-----"]=[E["ST.IC.SAFE HOUSE"]],t["O-I-G-----"]=[E["ST.IC.GRAFFITI"]],t["O-I-V-----"]=[E["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]],t["O-I-I-----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"]],t["O-I-D-----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.DRUG"]],t["O-I-F-----"]=[E["ST.IC.INTERNAL SECURITY FORCE"]],t["O-P-------"]=[E["ST.IC.INDIVIDUAL"]],t["O-P-A-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.LEADER"]],t["O-P-B-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.TARGETED"]],t["O-P-C-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.TERRORIST"]],t["O-G-------"]=[E["ST.IC.GROUP"]],t["O-G-A-----"]=[E["ST.IC.GROUP"],E["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],t["O-G-B-----"]=[E["ST.IC.GROUP"],E["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],t["O-G-C-----"]=[E["ST.IC.GROUP"],E["ST.M1.TERRORIST"]],t["O-G-D-----"]=[E["ST.IC.GROUP"],E["ST.M1.RELIGIOUS"]],t["O-G-E-----"]=[E["ST.IC.GROUP"],E["ST.M1.FOREIGN FIGHTERS"]],t["O-G-F-----"]=[E["ST.IC.GROUP"],E["ST.M1.GANG"]],t["O-R-------"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.RAPE"]],t["O-R-A-----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.RAPE"],E["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]]}};function d(t,I,E,e,R,C){var A=I.affiliation||"Friend",T="Hostile"!=A||R?E.iconColor[A]:"rgb(255, 0, 0)",S="Hostile"!=A||R?E.fillColor[A]:"rgb(255, 0, 0)",N=I.numberSIDC,O={};O["TP.DESTROY"]=e||N?[{type:"path",fill:!1,d:"m 0,45 85,46.75 m 30,16.5 85,46.75 M 0,155 85,108.25 M 115,91.75 200,45"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"D"}]:{type:"path",fill:!1,strokedasharray:"12,5",d:"M 0,155 200,45 M 0,45 200,155"},O["TP.INTERDICT"]=e||N?[{type:"path",fill:!1,d:"m 194.203,65.6674 5.49,-20.4904 -20.49,-5.4904 M 115,91.75 200,45 M 0,155 85,108.25 M 185,85 l 15,15 -15,15 m -70,-15 85,0 m -200,0 85,0"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"I"}]:{type:"path",fill:!1,d:"m 0,100 200,0 M 0,155 200,45.2 M 185,85 l 15,15 -15,15 m 9.2,-49.3 5.5,-20.5 -20.5,-5.5"},O["TP.NEUTRALIZE"]=e||N?[{type:"path",fill:!1,d:"M 115,108.25 200,155 M 0,45 85,91.75"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 115,91.75 200,45 M 0,155 85,108.25"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"N"}]:[{type:"path",fill:!1,d:"M 0,45 200,155"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 0,155 200,45"}],O["TP.SUPPRESS"]=e||N?[{type:"path",fill:!1,strokedasharray:"12,5",d:"M 115,108.25 200,155 M 0,45 85,91.75"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 115,91.75 200,45 M 0,155 85,108.25"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"S"}]:[{type:"path",fill:!1,d:"M 0,45 200,155"},{type:"path",fill:!1,strokedasharray:"12,5",d:"M 0,155 200,45"}],O["TP.DATUM"]=[{type:"path",stroke:!1,d:"m 100,50 0,50 50,0 C 150,72.3858 127.614,50 100,50 Z m 0,50 -50,0 c 0,27.614 22.3858,50 50,50 z"},{type:"circle",fill:!1,cx:100,cy:100,r:50}],O["TP.BRIEF CONTACT"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:75,y:45,fontsize:45,text:"B"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:125,y:45,fontsize:45,text:"C"}],O["TP.LOST CONTACT"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:75,y:45,fontsize:45,text:"L"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:125,y:45,fontsize:45,text:"C"}],O["TP.SINKER"]=[{type:"path",fill:!1,d:"m 100,15 0,65 M 60,15 80,0 100,15 120,0 140,15"},{type:"path",d:"M 100,100 55,80 145,80 Z"}],O["TP.TRIAL TRACK"]=[{type:"path",d:"m 65,0 70,0 m -35,80 0,-80 m 0,100 -45,-20 90,0 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:75,y:45,fontsize:45,text:"T"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:125,y:45,fontsize:45,text:"T"}],O["TP.SONOBUOY"]=[{type:"path",fill:!1,d:"M 100,60 l 0,-35 10,10 0,-45"},{type:"circle",fill:!1,cx:100,cy:100,r:40}],O["TP.SONOBUOY PATTERN CENTER"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"P"}],O["TP.SONOBUOY DIFAR"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"D"}],O["TP.SONOBUOY LOFAR"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"L"}],O["TP.SONOBUOY CASS"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"C"}],O["TP.SONOBUOY DICASS"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"S"}],O["TP.SONOBUOY BT"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"B"}],O["TP.SONOBUOY ANM"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"A"}],O["TP.SONOBUOY VLAD"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"V"}],O["TP.SONOBUOY ATAC"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"T"}],O["TP.SONOBUOY BARRA"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"BR"}],O["TP.SONOBUOY BATHYTHERMOGRAPH TRANSMITTING SONOBUOY (BT)"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"B"}],O["TP.SONOBUOY COMMAND ACTIVE MULTIBEAM SONOBUOY (CAMBS)"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"CM"}],O["TP.SONOBUOY EXPENDABLE RELIABLE ACOUSTIC PATH SONOBUOY (ERAPS)"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"E"}],O["TP.SONOBUOY RO"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"R"}],O["TP.SONOBUOY KINGPIN"]=[O["TP.SONOBUOY"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"K"}],O["TP.SONOBUOY EXPIRED"]=[O["TP.SONOBUOY"],{type:"path",fill:!1,d:"M 40,60 l 120,80 M 40,140 l 120,-80"}],O["TP.SEARCH"]={type:"path",d:"m 80,80 20,20 -20,20 40,0 -20,-20 20,-20 z M 50,150 150,50 M 50,50 150,150"},O["TP.SEARCH AREA"]=[O["TP.SEARCH"],e||N?[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:60,y:103,fontsize:45,text:"S"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:140,y:103,fontsize:45,text:"A"}]:{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"SA"}],O["TP.DIP POSITION"]=[O["TP.SEARCH"],e||N?[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:60,y:103,fontsize:45,text:"D"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:140,y:103,fontsize:45,text:"P"}]:{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"DIP"}],O["TP.SEARCH CENTER"]={type:"path",stroke:!1,d:"m 100,100 -50,10 0,-20 z m 0,0 10,50 -20,0 z m 0,0 50,-10 0,20 z m 0,0 -10,-50 20,0 z"},O["TP.REFERENCE POINT"]=[{type:"path",fill:!1,d:"M 160,160 40,160 40,40 160,40 Z"},{type:"circle",cx:100,cy:100,r:15}],O["TP.NAVIGATIONAL REFERENCE"]=!N&&e?{type:"path",fill:!1,d:"M 160,160 40,160 40,40 160,40 Z M 160,160 40,40 M 40,160 160,40"}:{type:"path",fill:!1,d:"M 160,160 40,40 M 40,160 160,40"},O["TP.SPECIAL POINT"]=[O["TP.NAVIGATIONAL REFERENCE"],{type:"circle",cx:100,cy:100,r:15}],O["TP.AIRFIELD"]=[{type:"path",fill:!1,d:"M 35,125 165,60 m -135,40 140,0"}],O["TP.DLRP"]=[O["TP.SPECIAL POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"D"}],O["TP.POINT OF INTENDED MOVEMENT"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"P"}],O["TP.PRE-LANDFALL WAYPOINT"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"PL"}],O["TP.MARSHALL POINT"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"M"}],O["TP.REFERENCE POINT WAYPOINT"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"W"}],O["TP.CORRIDOR TAB"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"C"}],O["TP.ENEMY POINT"]=[O["TP.REFERENCE POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"ENY"}],O["TP.POINT OF INTEREST"]=[{type:"path",d:"M 129.021,41.957 C 121.48,49.9458 110.986,54.4816 100,54.5 89.0432,54.4928 78.569,49.9914 71.0234,42.0469 L 100,100 Z"},{type:"circle",fill:!1,cx:100,cy:15,r:40}],O["POINT OF INTEREST – LAUNCH EVENT"]=[O["TP.POINT OF INTEREST"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:40,fontweight:"bold",text:"LE"}],O["TP.SHIP AREA OF INTEREST (AEGIS ONLY)"]={type:"circle",fill:!1,cx:100,cy:100,r:50},O["TP.ACTIVE MANOEUVRE AREA (AEGIS ONLY)"]={type:"circle",fill:!1,stroke:"rgb(254,203,47)",cx:100,cy:100,r:60},O["TP.PLAN SHIP"]=[{type:"circle",fill:S,stroke:S,cx:100,cy:100,r:15},{type:"circle",stroke:S,cx:100,cy:100,r:45,fill:!1}],O["TP.AIM POINT"]=[{type:"circle",cx:100,cy:100,r:15},{type:"circle",cx:100,cy:100,r:35,fill:!1},{type:"circle",cx:100,cy:100,r:45,fill:!1}],O["TP.DEFENDED ASSET"]={type:"path",fill:!1,d:"m 90,135 0,-30 20,0 0,30 m -50,0 0,-50 -10,0 0,-20 20,0 0,10 20,0 0,-10 20,0 0,10 20,0 0,-10 20,0 0,20 -10,0 0,50 z"},O["TP.CHEMICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"C"}],O["TP.CHEMICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"C"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:30,text:"T"}],O["TP.BIOLOGICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"B"}],O["TP.BIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"B"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:30,text:"T"}],O["TP.NUCLEAR EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"N"}],O["TP.RADIOLOGICAL EVENT"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"R"}],O["TP.RADIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"]=[{type:"path",fill:!1,d:"M 110,60 C 110,40 115,25 80,20 M 90,60 C 90,40 85,25 120,20 m -20,80 -60,-110 120,0 z"},{type:"path",d:"m 120,20 c 10,0 10,15 0,15 -10,0 -10,-15 0,-15 z M 80,35 c 10,0 10,-15 0,-15 -10,0 -10,15 0,15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:30,text:"R"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:30,text:"T"}],O["TP.DROP POINT"]={type:"path",fill:!1,d:"m 130,100 0,-40 m -60,40 0,-40 m 60,40 0,0 c 0,8.284 -6.716,15 -15,15 -8.284,0 -15,-6.716 -15,-15 m 0,0 0,0 c 0,8.284 -6.7157,15 -15,15 -8.2843,0 -15,-6.716 -15,-15 m 30,-40 0,40"},O["TP.ENTRY POINT"]={type:"path",fill:!1,d:"m 100,100 0,-50 m -35,15 35,35 35,-35 m -85,35 100,0"},O["TP.AIR DETONATION"]={type:"path",d:"m 55,150 90,0 m -35,-95 5,20 15,-10 0,15 15,5 -15,10 15,10 -15,5 5,15 -20,-5 -5,20 -10,-15 -10,20 -5,-25 -20,10 5,-15 L 55,105 70,95 60,85 70,80 70,65 85,75 90,55 100,70 Z",fill:!1},O["TP.GROUND ZERO"]={type:"path",stroke:!1,d:"M 100 28 C 100 28 65.4398 29.8261 61.6543 55 C 60.2826 64.1213 75.0115 70.4884 82.2363 71.6543 C 89.4611 72.8201 91.7277 55.3462 98.5098 56.0371 L 93 90 C 93 90 70 90 67 97 C 65.0304 101.596 100 100 100 100 C 100 100 134.97 101.596 133 97 C 130 90 107 90 107 90 L 101.49 56.0371 C 108.272 55.3462 110.539 72.8201 117.764 71.6543 C 124.988 70.4884 139.718 64.1213 138.346 55 C 134.56 29.8261 100 28 100 28 z"},O["TP.LAUNCHED TORPEDO (AEGIS ONLY)"]={type:"path",d:"m 150,90 0,20 m -10,-10 10,0 m -97,-10 84,0 c 1.662,0 3,1.338 3,3 l 0,14 c 0,1.662 -1.338,3 -3,3 l -84,0 c -1.662,0 -3,-1.338 -3,-3 l 0,-14 c 0,-1.662 1.338,-3 3,-3 z"},O["TP.MSL DETECT POINT"]={type:"path",d:"m 95,100 0,-55 -10,0 15,-15 15,15 -10,0 0,55 m -55,0 100,0"},O["TP.ACOUSTIC COUNTER MEASURE (DECOY)"]={type:"path",d:"M 107.5,55 92.5518,70 107.5,85 Z M 50,30 150,30 m -90,70 0,-5 80,0 0,5 z m 70,-45 -15,15 15,15 z M 85,55 70,70 85,85 Z m 15,-25 0,33"},O["TP.ELECTRONIC COUNTER MEASURES (ECM) DECOY"]=[{type:"path",d:"m 80,120 -20,10 20,10 z m 30,0 -20,10 20,10 0,-20 z m 30,0 -20,10 20,10 z m -25,-20 c 0,10 -10,18 -19.4,14 -9.4,-2 -13.8,-14.7 -8,-22.5 5.2,-8.2 18.4,-8.7 24.4,-0.8 2,2.6 3,5.9 3,9.3 z"},{type:"path",fill:!1,d:"m 50,50 0,100 100,0 0,-100 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:70,fontsize:30,text:"ECM"}],O["TP.IMPACT POINT"]={type:"path",d:"m 50,100 40,-10 10,-40 10,40 40,10 -40,10 -10,40 -10,-40 -40,-10"},O["TP.PREDICTED IMPACT POINT"]={type:"path",fill:!1,strokedasharray:"12,5",d:"m 50,100 40,-10 10,-40 10,40 40,10 -40,10 -10,40 -10,-40 -40,-10"},O["TP.FORMATION"]={type:"path",fill:!1,d:"m 100,50 0,100 m -50,-50 100,0"},O["TP.HARBOR"]={type:"path",fill:!1,d:"M 80,140 50,60 150,60 120,140"},O["TP.HARBOR POINT Q"]=[O["TP.HARBOR"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"Q"}],O["TP.HARBOR POINT A"]=[O["TP.HARBOR"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"A"}],O["TP.HARBOR POINT Y"]=[O["TP.HARBOR"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"Y"}],O["TP.HARBOR POINT X"]=[O["TP.HARBOR"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"X"}],O["TP.ROUTE"]={type:"path",fill:!1,d:"m 138.484,76.82 c 0,-7.4823 6.066,-13.5478 13.548,-13.548 7.483,-3e-4 13.549,6.0653 13.549,13.548 m -27.097,0 0,0 c 0,6.9484 -5.634,12.5807 -12.582,12.58 -6.948,-4e-4 -12.58,-5.6324 -12.58,-12.58 m -27.097,0 c 2e-4,-7.4823 6.0657,-13.5478 13.548,-13.548 7.483,-3e-4 13.549,6.0653 13.549,13.548 m -79.3554,0 c 2e-4,-7.4824 6.066,-13.548 13.5484,-13.548 7.4824,0 13.5482,6.0656 13.5484,13.548 m 25.1616,0 0,0 C 86.2246,83.7681 80.5918,89.4003 73.6437,89.4 66.696,89.3998 61.0638,83.7677 61.0634,76.82 m 77.4206,47.328 c 0,-7.482 6.066,-13.548 13.548,-13.548 7.483,0 13.549,6.065 13.549,13.548 m -27.097,0 0,0 c 0,6.948 -5.634,12.581 -12.582,12.58 -6.948,0 -12.58,-5.632 -12.58,-12.58 m -27.097,0 c 2e-4,-7.482 6.0657,-13.548 13.548,-13.548 7.483,0 13.549,6.065 13.549,13.548 m -79.3554,0 c 2e-4,-7.482 6.066,-13.548 13.5484,-13.548 7.4824,0 13.5482,6.066 13.5484,13.548 m 25.1616,0 0,0 c -4e-4,6.948 -5.6332,12.58 -12.5813,12.58 -6.9477,0 -12.5799,-5.632 -12.5803,-12.58 m -27.0968,-23.664 132.5184,0"},O["TP.ROUTE RENDEZVOUS"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"R"}],O["TP.ROUTE DIVERSIONS"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"D"}],O["TP.ROUTE WAYPOINT"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"W"}],O["TP.ROUTE PIM"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"M"}],O["TP.ROUTE POINT R"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"P"}],O["TP.PICKET ROUTE"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"PK"}],O["TP.POINT R ROUTE"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"R"}],O["TP.RENDEZVOUS ROUTE"]=[O["TP.ROUTE"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:160,fontsize:45,text:"RZ"}],O["TP.AIR CONTROL"]={type:"path",fill:!1,d:"m 140,165 0,-130 m -80,0 0,130"},O["TP.AIR CONTROL POINT"]=[O["TP.AIR CONTROL"],{type:"circle",cx:100,cy:100,r:15}],O["TP.COMBAT AIR PATROL (CAP)"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"C"}],O["TP.AIRBORNE EARLY WARNING (AEW)"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"W"}],O["TP.ASW FIXED WING"]=[O["TP.AIR CONTROL"],N||e?[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:32,text:e?"ASW":"AS"},{type:"path",d:e?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}]:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"F"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.ASW ROTARY WING"]=[O["TP.AIR CONTROL"],N||e?[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:32,text:"ASW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}]:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"H"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.SUCAP - FIXED WING"]=[O["TP.AIR CONTROL"],{type:"text",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:32,text:"SUW"},{type:"path",d:e?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}],O["TP.SUCAP - ROTARY WING"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:32,text:"SUW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}],O["TP.MIW - FIXED WING"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:32,text:e?"MIW":"MW"},{type:"path",d:e?"m 100,81.3203 c -1.5135,-0 -2.5365,2.6426 -2.5365,2.6426 l -0.1365,14.1465 -28.3641,29.9996 0.1484,4.604 28.5162,-18.748 -0.2929,24.43 -6.3073,6.017 -0.096,3.766 8.0313,-3.524 1.0312,3.326 0,0.02 0,-0.01 0,0.01 0,-0.02 1.0312,-3.326 8.031,3.524 -0.09,-3.766 -6.309,-6.017 -0.293,-24.43 28.518,18.748 0.146,-4.604 -28.364,-29.9996 -0.136,-14.1465 c 0,0 -1.014,-2.6416 -2.528,-2.6426 z":"M 80,88.3 C 60,80 60,120 80,111.4 L 100.2,99.9 120,111.3 C 140,120 140,80 120,88.6 l -19.8,11.3 z",stroke:!1}],O["TP.MIW - ROTARY WING"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:32,text:e?"MIW":"MW"},{type:"path",d:"m 65,80 0,40 70,-40 0,40 -70,-40",stroke:!1}],O["TP.STRIKE IP"]=[O["TP.AIR CONTROL"],N||e?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"S"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"S"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.CORRIDOR TAB POINT"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"C"},{type:"circle",cx:100,cy:100,r:15}],O["TP.AIR CONTROL RENDEZVOUS"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"RZ"}],O["TP.CAP STATION"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"C"}],O["TP.AEW STATION"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"W"}],O["TP.TACAN"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"T"},N||e?[]:{type:"circle",cx:100,cy:100,r:15}],O["TP.REPLENISHMENT STATION"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"RP"}],O["TP.TANKING"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:N||e?103:145,fontsize:45,text:"K"}],O["TP.TOMCAT"]=[O["TP.AIR CONTROL"],N||e?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"TC"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"O"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.RESCUE"]=[O["TP.AIR CONTROL"],N?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RS"}:e?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RC"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"R"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.REPLENISH"]=[O["TP.AIR CONTROL"],N||e?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RP"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"F"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.MARSHALL"]=[O["TP.AIR CONTROL"],N||e?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"M"}:[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:145,fontsize:45,text:"M"},{type:"circle",cx:100,cy:100,r:15}]],O["TP.UNMANNED AERIAL SYSTEM"]=[O["TP.AIR CONTROL"],{type:"path",stroke:!1,d:"m 70,85 30,15 30,-15 0,15 -30,15 -30,-15 z"}],O["TP.VTUA"]=[O["TP.AIR CONTROL"],{type:"path",stroke:!1,d:"m 70,95 30,15 30,-15 0,30 -30,-15 -30,15 z m 0,-25 30,15 30,-15 0,15 -30,15 -30,-15 z"}],O["TP.ORBIT"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"O"}],O["TP.ORBIT - FIGURE EIGHT"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"O"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"F8"}],O["TP.ORBIT - RACE TRACK"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"O"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"RT"}],O["TP.ORBIT - RANDOM, CLOSED"]=[O["TP.AIR CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"O"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:140,fontsize:40,text:"RC"}],O["TP.ISOLATED PERSONNEL LOCATION"]=[{type:"circle",cx:100,cy:35,r:10},{type:"path",fill:!1,d:"m 75,100 h 50  M 100,55 v 45  M 70,25 100,55 130,25"}],O["TP.ACTION POINT"]={type:"path",fill:!1,d:"m 60,45 80,0 m -40,55 -40,-55 0,-105 80,0 0,105 z"},O["TP.ACTION CHECK POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"CKP"}],O["TP.CONTACT POINT"]=N?{type:"path",fill:!1,d:"M 50,50 150,50 150,150 50,150z"}:{type:"path",fill:!1,d:"m 100,100 0,-35 -45,0 0,-75 90,0 0,75 -45,0"},O["TP.CENTRE OF MAIN EFFORT"]=[{type:"path",fill:!1,d:"m 155,100 0,-35 M 45,100 45,65 m 88,0 0,35 m -22,-35 0,35 m -22,-35 0,35 m -22,0 0,-35 m -37,70 0,-35 140,0 0,40"}],O["TP.COORDINATION POINT"]=[{type:"path",fill:!1,d:"m 65,135 70,-70 m -70,0 70,70"},{type:"circle",fill:!1,cx:100,cy:100,r:50}],O["TP.DECISION POINT"]={type:"path",fill:!1,d:"M 99.9998,25.5886 117.061,76.5192 170.77,77.0054 127.604,108.968 143.738,160.2 100,129.024 56.2624,160.2 72.3967,108.968 29.2306,77.0059 82.9403,76.5192 Z"},O["TP.DISTRESS CALL"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"SOS"}],O["TP.ENTRY CONTROL POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"EC"}],O["TP.FLY-TO-POINT (SONOBUOY)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"FTP"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,text:"SBY"}],O["TP.FLY-TO-POINT (WEAPON)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"FTP"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,text:"WPN"}],O["TP.FLY-TO-POINT (NORMAL)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"FTP"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,text:"NRM"}],O["TP.ACTION LINKUP POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"LU"}],O["TP.ACTION PASSAGE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"PP"}],O["TP.ACTION RALLY POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"RLY"}],O["TP.ACTION RELEASE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"RP"}],O["TP.ACTION START POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"SP"}],O["TP.ACTION AMNESTY POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"AMN"}],O["TP.WAYPOINT"]={type:"path",fill:!1,strokewidth:8,d:"m 65,135 70,-70 m -70,0 70,70"},O["TP.COMBATANT STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"CBT"}],O["TP.PICKET STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"PKT"}],O["TP.ASW SHIP STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"ASW"}],O["TP.REPLENISHMENT AT SEA (RAS) STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"RAS"}],O["TP.RESCUE STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"RSC"}],O["TP.SUBMARINE STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"SUB"}],O["TP.ASW SUBMARINE STATION"]=[O["TP.WAYPOINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:75,y:103,fontsize:40,text:"ASW/SUB"}],O["TP.SEA SURFACE CONTROL"]={type:"path",fill:!1,d:"m 30,60 140,0 m -140,80 140,0"},O["TP.SEA SURFACE CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"circle",cx:100,cy:100,r:15}],O["TP.(USV) CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 100,115 45,-20 0,-15 -45,20 -45,-20 0,15 z"}],O["TP.(USV)"]=[O["TP.SEA SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 55,100 45,20 45,-20 0,15 -45,20 -45,-20 z"}],O["TP.(RMV) USV CONTROL STATION"]=[O["TP.(USV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"RMV"}],O["TP.USV - ASW CONTROL STATION"]=[O["TP.(USV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"ASW"}],O["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SURFACE STATION"]=[O["TP.(USV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"MW"}],O["TP.USV - SUW CONTROL STATION"]=[O["TP.(USV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"SUW"}],O["TP.USV - MIW CONTROL STATION"]=[O["TP.(USV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"MIW"}],O["TP.ASW CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"ASW"}],O["TP.MINE WARFARE SURFACE STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"MW"}],O["TP.NON-COMBATANT SURFACE STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"NC"}],O["TP.SUW CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"SUW"}],O["TP.MIW CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"MIW"}],O["TP.PICKET CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"PK"}],O["TP.RENDEZVOUS CONTROL POINT"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RZ"}],O["TP.REPLENISHMENT AT SEA SURFACE STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RAS"}],O["TP.RESCUE CONTROL POINT"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RS"}],O["TP.REPLENISHMENT CONTROL POINT"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"RP"}],O["TP.NONCOMBATANT CONTROL STATION"]=[O["TP.SEA SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:45,text:"NC"}],O["TP.SUB SURFACE CONTROL"]=[{type:"path",fill:!1,d:"m 30,140 140,0"},{type:"path",fill:!1,strokedasharray:"12,4",d:"m 30,60 140,0"}],O["TP.SUB SURFACE CONTROL STATION"]=[O["TP.SUB SURFACE CONTROL"],{type:"circle",cx:100,cy:100,r:15}],O["TP.(UUV) CONTROL STATION"]=[O["TP.SUB SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 100,115 45,-20 0,-15 -45,20 -45,-20 0,15 z"}],O["TP.(UUV)"]=[O["TP.SUB SURFACE CONTROL"],{type:"path",stroke:!1,d:"m 55,100 45,20 45,-20 0,15 -45,20 -45,-20 z"}],O["TP.UUV - ASW CONTROL STATION"]=[O["TP.(UUV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"ASW"}],O["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SUBSURFACE STATION"]=[O["TP.(UUV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"MW"}],O["TP.UUV - SUW CONTROL STATION"]=[O["TP.(UUV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"SUW"}],O["TP.UUV - MIW CONTROL STATION"]=[O["TP.(UUV)"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:85,fontsize:40,text:"MIW"}],O["TP.SUBMARINE CONTROL STATION"]=[O["TP.SUB SURFACE CONTROL"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:120,fontsize:35,text:"SS"},{type:"path",d:"m 75,95 0,-20 50,0 0,20 z m 25,-30 0,40"}],O["TP.ASW SUBMARINE CONTROL STATION"]=[O["TP.SUB SURFACE CONTROL"],{type:"path",d:"m 68.75,105 -12.5,12.5 12.5,12.5 62.5,0 12.5,-12.5 -12.5,-12.5 z M 75,95 l 0,-20 50,0 0,20 z m 25,-30 0,40"}],O["TP.AIR CONTROL POINT (ACP)"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:80,fontsize:30,text:"ACP"}],O["TP.COMMUNICATIONS CHECKPOINT"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:80,fontsize:30,text:"CCP"}],O["TP.PULL-UP POINT"]=[{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:160,y:103,fontsize:40,text:"PUP"},{type:"path",fill:!1,d:"m 65,80 0,40 70,-40 0,40 z"}],O["TP.DOWNED AIRCREW PICKUP POINT"]=[O["TP.ACTION POINT"],{type:"circle",cx:100,cy:-35,r:12},{type:"path",fill:!1,d:"m 75,35 50,0 m -25,-45 0,45 m -30,-75 30,30 30,-30"}],O["TP.DUMMY MINEFIELD"]=[{type:"path",fill:!1,d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,-40 0,80 120,0 0,-80 z"},{type:"path",fill:!1,strokedasharray:"15,10",d:"M 160,60 100,-5 M 40,60 100,-5"}],O["TP.TARGET REFERENCE"]={type:"path",fill:!1,d:"m 50,100 100,0 m -50,-50 0,100"},O["TP.OBSERVATION POST/OUTPOST"]={type:"path",fill:!1,d:"m 100,45 47.6,82.5 -95.2,0 z"},O["TP.COMBAT OUTPOST"]={type:"path",fill:!1,d:"m 140,140 0,-12.5 m -16,12.5 0,-12.5 m -16,12.5 0,-12.5 m -48.0001,12.5 3e-4,-12.5 m 15.9993,12.5 4e-4,-12.501 m 16,12.501 3e-4,-12.5 m -46.43,-12.493 10.8256,6.25 m -2.8256,-20.107 10.8256,6.251 m -2.8257,-20.1071 10.8257,6.2506 m 13.1743,-47.8198 10.8257,6.2506 m -18.8253,7.6056 10.8256,6.2506 m -18.826,7.606 10.8257,6.2506 M 114.43,45.725 l -10.826,6.25 m 18.826,7.6064 -10.826,6.25 m 18.826,7.6064 -10.826,6.25 m 34.826,35.3192 -10.826,6.25 m 2.826,-20.106 -10.826,6.25 m 2.826,-20.1068 -10.826,6.25 M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},O["TP.OBSERVATION POST/RECONNAISSANCE"]={type:"path",fill:!1,d:"M 52.3687,127.5 123.816,86.2499 M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},O["TP.FORWARD OBSERVER POSITION"]=[{type:"path",fill:!1,d:"m 100,45 48,83 H 52.4 Z"},{type:"path",d:"m 115,100 c 0,8.284 -6.716,15 -15,15 -8.2843,0 -15,-6.716 -15,-15 0,-8.2843 6.7157,-15 15,-15 8.284,0 15,6.7157 15,15 z"}],O["TP.SENSOR OUTPOST"]=N?[{type:"path",fill:!1,d:"M 99.9998,45 l 47.6312,82.5 -95.2623,0 z"},{type:"path",stroke:!1,d:"m 100,80 c 0,7.5 12.5,20 20,20 -7.5,0 -20,12.5 -20,20 0,-7.5 -12.5,-20 -20,-20 7.5,0 20,-12.5 20,-20 z"}]:{type:"path",fill:!1,d:"m 61.1738,112.25 23.6601,0 m 30.3321,0 23.66,0 M 80,105 l 10,15 20,0 10,-15 z m 19.9998,-60 47.6312,82.5 -95.2623,0 z"},O["TP.CBRN OBSERVATION POST"]=[{type:"path",fill:!1,d:"m 99.9998,45 47.6312,82.5 -95.2623,0 z M 88,119 c 2.1824,-13.288 7.7157,-24.22 22,-29 m 1.829,29 C 109.664,105.712 104.173,94.78 90,90 M 52.3687,127.5 123.816,86.2499"},{type:"path",d:"m 91,92 c 0,2.7614 -2.2386,5 -5,5 -2.7614,0 -5,-2.2386 -5,-5 0,-2.7614 2.2386,-5 5,-5 2.7614,0 5,2.2386 5,5 z m 28.011,0 c 0,2.7678 -2.243,5.0117 -5.011,5.012 -2.768,-3e-4 -5.011,-2.2442 -5.011,-5.012 0,-2.7676 2.243,-5.0112 5.011,-5.0115 2.768,3e-4 5.011,2.2439 5.011,5.0115 z"}],O["TP.POINT OF DEPARTURE"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"PD"}],O["TP.FIXED AND PREFABRICATED"]={type:"path",d:"m 60,100 40,-65 40,65 z"},O["TP.TETRAHEDRONS"]={type:"path",fill:!1,d:"m 60,100 40,-65 40,65"},O["TP.TETRAHEDRONS MOVABLE"]={type:"path",fill:!1,d:"m 60,100 40,-65 40,65 z"},O["TP.BOOBY TRAP"]={type:"path",fill:!1,d:"M 77.2413,87.9311 100,50 122.781,87.9687 M 130,100 c 0,10.24 -13.431,18.541 -30,18.541 -16.5685,0 -30,-8.301 -30,-18.541 0,-10.2399 13.4315,-18.541 30,-18.541 16.569,0 30,8.3011 30,18.541 z"},O["TP.UNSPECIFIED MINE"]={type:"path",fill:!1,d:"m 129,100 c 0,16.016 -12.984,29 -29,29 -16.0163,0 -29,-12.984 -29,-29 0,-16.0163 12.9837,-29 29,-29 16.016,0 29,12.9837 29,29 z"},O["TP.ANTITANK MINE (AT)"]={type:"path",d:"m 129,100 c 0,16.016 -12.984,29 -29,29 -16.0163,0 -29,-12.984 -29,-29 0,-16.0163 12.9837,-29 29,-29 16.016,0 29,12.9837 29,29 z"},O["TP.(AT) ANTIHANDLING DEVICE"]=[O["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 100,130 0,65 15,-15"}],O["TP.(AT) DIRECTIONAL"]=[O["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,strokedasharray:"5,5",d:"m 100,70 0,-60"},{type:"path",fill:!1,d:"m 90,20 10,-10 10,10"}],O["TP.ANTIPERSONNEL (AP) MINES"]=[O["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 50,50 29.5,29.5 m 41,0 L 150,50"}],O["TP.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS"]=[O["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 131,100 10,0 M 50,50 79.5,79.5 m 41,0 L 150,50 m -4,50 10,0 m 5,0 10,0 m -10,-10 10,10 -10,10"}],O["TP.WIDE AREA MINES"]=[O["TP.ANTITANK MINE (AT)"],{type:"path",fill:!1,d:"m 50,110 25,40 12,-24 M 113,126 125,150 150,110"}],O["TP.PLANNED MINEFIELD"]=[{type:"path",fill:!1,strokedasharray:"15,15",d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",fill:!1,d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],O["TP.MINEFIELDS STATIC"]={type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z m 70,35 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m 35,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,0 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z"},O["TP.MINEFIELD, STATIC"]={type:"path",fill:!1,d:"m 25,65 0,70 150,0 0,-70 z"},I.notpresent&&(O["TP.MINEFIELDS STATIC"]=O["TP.PLANNED MINEFIELD"]),O["TP.ANTITANK (AT) MINEFIELD"]=[{type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",d:"m 75,100 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z m 70,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -35,0 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],O["TP.SCATTERABLE MINES"]=[O["TP.MINEFIELDS STATIC"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:50,fontsize:35,text:"S"}],O["TP.ANTIPERSONNEL (AP) MINEFIELD"]=[{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:50,fontsize:35,text:"+S"},{type:"path",fill:!1,d:"m 40,65 0,70 120,0 0,-70 z"},{type:"path",d:"M 72.0703,92.9297 80,82.3622 m -30,0 7.9297,10.5675 m 49.1403,0 7.93,-10.5675 m -30,0 7.9297,10.5675 m 49.1403,0 7.93,-10.5675 m -30,0 7.93,10.5675 M 110,100 c 0,5.523 -4.477,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z m 35,0 c 0,5.523 -4.477,10 -10,10 -5.523,0 -10,-4.477 -10,-10 0,-5.5228 4.477,-10 10,-10 5.523,0 10,4.4772 10,10 z m -70,0 c 0,5.523 -4.4772,10 -10,10 -5.5228,0 -10,-4.477 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.5228,0 10,4.4772 10,10 z"}],O["TP.SCATTERABLE MINEFIELD WITH SELF-DESTRUCT"]=[O["TP.ANTITANK (AT) MINEFIELD"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:50,fontsize:35,text:"S"}],O["TP.VOLCANO MINEFIELD"]=[O["TP.ANTITANK (AT) MINEFIELD"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:50,fontsize:35,text:"V"}],O["TP.TOWER LOW"]=[{type:"circle",stroke:!1,cx:100,cy:100,r:7},{type:"path",fill:!1,strokewidth:8,d:"m 75,105 25,-65 25,65"}],O["TP.TOWER HIGH"]=[{type:"circle",stroke:!1,cx:100,cy:100,r:7},{type:"path",fill:!1,strokewidth:8,d:"m 100,40 c 2.358,31.6754 7.162,59.2531 25,64.999 M 100,40 c -2.358,31.6754 -7.1624,59.2531 -25,65"}],O["TP.ENGINEER REGULATING POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ERP"}],O["TP.EARTHWORK/FORTIFICATION"]={type:"path",d:"m 65,65 0,70 70,0 0,-70 -70,0z"},O["TP.FORT"]={type:"path",fill:!1,d:"m 135,65 15,-15 m -15,85 15,15 M 65,135 50,150 m 15,-85 0,70 70,0 0,-70 -70,0 -15,-15"},O["TP.SURFACE SHELTER"]={type:"path",d:"m 135,135 15,0 m -100,0 15,0 m 0,-70 0,70 70,0 0,-70 -70,0"},O["TP.UNDERGROUND SHELTER"]={type:"path",d:"m 135,65 15,0 m -100,0 15,0 m 0,70 0,-70 70,0 0,70 -70,0"},O["TP.NUCLEAR DETONATIONS GROUND ZERO"]=[{type:"path",fill:!R&&"rgb(255,255,0)",d:"m 85,25 0,75 30,0 0,-75 m -50,0 c 0,-50 70,-50 70,0 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:35,text:"N"}],O["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"]=[{type:"path",strokedasharray:"5,5",fill:!R&&"rgb(255,255,0)",d:"m 85,25 0,75 30,0 0,-75 m -50,0 c 0,-50 70,-50 70,0 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:35,text:"N"}],O["TP.NUCLEAR FALLOUT PRODUCING"]=[{type:"path",fill:!1,d:"m 120,85 -15,15 m -25,0 40,-35 M 80,80 120,40 M 80,55 115,25 M 80,40 95,25 m -40,0 c 0,-60 90,-60 90,0 z m 25,0 0,75 40,0 0,-75"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:65,fontsize:35,text:"N"}],O["TP.RELEASE EVENTS BIOLOGICAL"]=[{type:"path",fill:!R&&"rgb(255,255,0)",d:"m 85,-15 0,60 -25,55 80,0 -25,-55 0,-60 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:75,fontsize:35,text:"B"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:50,y:50,fontsize:35,text:"BIO"}],O["TP.RELEASE EVENTS CHEMICAL"]=[{type:"path",fill:!R&&"rgb(255,255,0)",d:"m 85,-15 0,59.0625 C 75.7313,49.4137 70.0154,59.2975 70,70 c 0,16.5685 13.4315,30 30,30 16.569,0 30,-13.4315 30,-30 -0.01,-10.7067 -5.728,-20.5959 -15,-25.9492 L 115,-15 Z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:70,fontsize:35,text:"C"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"end",x:50,y:50,fontsize:35,text:"CML"}],O["TP.DECON SITE/POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"}],O["TP.ALTERNATE DECON SITE/POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"ALT"}],O["TP.DECON SITE/POINT (TROOPS)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"T"}],O["TP.DECON SITE/POINT (EQUIPMENT)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"E"}],O["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"E/T"}],O["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"O"}],O["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"TH"}],O["TP.MAIN EQUIPMENT DECONTAMINATION POINT/SITE"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:30,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:25,text:"(M)"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:3,fontsize:25,text:"E"}],O["TP.FORWARD TROOP DECONTAMINATION POINT/SITE"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:30,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:25,text:"(F)"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:3,fontsize:25,text:"T"}],O["TP.WOUNDED PERSONNEL DECONTAMINATION SITE"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-10,fontsize:35,text:"W"}],O["TP.AMBULANCE CONTROL POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ACP"}],O["TP.AMBULANCE LOAD POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ALP"}],O["TP.AMBULANCE RELAY POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ARP"}],O["TP.DECON POINT (MAIN) EQUIPMENT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"(M)E"}],O["TP.DECON POINT (FORWARD) TROOPS"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DCN"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:0,fontsize:35,text:"(F)T"}],O["TP.POINT/SINGLE TARGET"]={type:"path",fill:!1,d:"m 50,100 100,0 m -50,-50 0,100"},O["TP.KNOWN POINT"]=[{type:"path",fill:!1,d:"m 50,100 100,0 m -50,-50 0,100"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:110,y:70,fontsize:30,text:"KNP"}],O["TP.NUCLEAR TARGET"]={type:"path",fill:!1,d:"m 90,100 -40,0 m 50,10 0,40 m 10,-50 40,0 m -50,-10 0,-40 m 2.5,50 c 0,1.381 -1.119,2.5 -2.5,2.5 -1.3807,0 -2.5,-1.119 -2.5,-2.5 0,-1.3807 1.1193,-2.5 2.5,-2.5 1.381,0 2.5,1.1193 2.5,2.5 z"},O["TP.TARGETRECORDED (AEGIS ONLY)"]=[{type:"path",fill:!1,d:"m 0,50 0,100 200,0 0,-100 z"},{type:"path",stroke:!1,d:"m 100,90 -10,10 10,10 10,-10 z"}],O["TP.FIRE SUPPORT STATION"]=[{type:"path",fill:!1,d:"M 50,50 150,150 M 50,150 150,50"},N?{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"left",x:120,y:100,fontsize:35,text:"FSS"}:[]],O["TP.SURVEY CONTROL POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"SCP"}],O["TP.FIRING POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"FP"}],O["TP.RELOAD POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"RLP"}],O["TP.HIDE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"HP"}],O["TP.LAUNCH POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"LP"}],O["TP.AMBULANCE EXCHANGE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"AXP"}],O["TP.CANNIBALIZATION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"CAN"}],O["TP.CASUALTY COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"CCP"}],O["TP.CIVILIAN COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"CIV"}],O["TP.DETAINEE COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"DET"}],O["TP.EPW COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"EPW"}],O["TP.LOGISTICS RELEASE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"LRP"}],O["TP.MAINTENANCE COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"MCP"}],O["TP.MEDICAL EVACUATION (MEDEVAC) PICKUP POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-40,fontsize:30,text:"MEP"},{type:"path",stroke:!1,d:"m 95,-25 0,10 -10,0 0,10 10,0 0,10 10,0 0,-10 10,0 0,-10 -10,0 0,-10 z"}],O["TP.REARM, REFUEL AND RESUPPLY POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"R3P"}],O["TP.REFUEL ON THE MOVE POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ROM"}],O["TP.TRAFFIC CONTROL POST"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"TCP"}],O["TP.TRAILER TRANSFER POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"TTP"}],O["TP.UNIT MAINTENANCE COLLECTION POINT"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:25,text:"UMCP"}],O["TP.SUPPLY POINT"]={type:"path",fill:!1,d:"m 60,30 80,0 m -80,15 80,0 m -40,55 -40,-55 0,-105 80,0 0,105 z"},O["TP.NATO CLASS I"]=[O["TP.SUPPLY POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:45,text:"I"}],O["TP.NATO CLASS II"]=[O["TP.SUPPLY POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:45,text:"II"}],O["TP.NATO CLASS III"]=[O["TP.SUPPLY POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:45,text:"III"}],O["TP.NATO CLASS IV"]=[O["TP.SUPPLY POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:45,text:"IV"}],O["TP.NATO CLASS V"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 80,-10 40,0 m -32,0 0,-26.7 c 0,-17.8 24,-17.8 24,0 L 112,-10"}],O["TP.SP CLASS I"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 115,-50 c -45,5 -45,65 0,70 -20,-25 -20,-50 0,-70 z"}],O["TP.SP CLASS II"]=[O["TP.SUPPLY POINT"],{type:"path",stroke:!1,d:"m 101.143,3.91602 q 3.662,-0.26368 4.746,-1.08399 1.084,-0.84961 1.084,-4.33594 l 0,-26.68949 q 0,-3.3105 -1.084,-4.248 -1.084,-0.9668 -4.746,-1.1426 l 0,-1.1133 17.753,0 0,1.1133 q -3.662,0.1758 -4.746,1.1426 -1.084,0.9375 -1.084,4.248 l 0,26.68949 q 0,3.48633 1.084,4.33594 1.084,0.82031 4.746,1.08399 l 0,1.08398 -17.753,0 0,-1.08398 z m 8.877,-38.61332 0,0 z M 81.1035,3.91602 q 3.6621,-0.26368 4.7461,-1.08399 1.084,-0.84961 1.084,-4.33594 l 0,-26.68949 q 0,-3.3105 -1.084,-4.248 -1.084,-0.9668 -4.7461,-1.1426 l 0,-1.1133 17.7539,0 0,1.1133 q -3.6621,0.1758 -4.7461,1.1426 -1.084,0.9375 -1.084,4.248 l 0,26.68949 q 0,3.48633 1.084,4.33594 1.084,0.82031 4.7461,1.08399 l 0,1.08398 -17.7539,0 0,-1.08398 z m 8.877,-38.61332 0,0 z"}],O["TP.SP CLASS III"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,20 0,-30 -20,-40 40,0 -20,40"}],O["TP.SP CLASS IV"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,-40 0,20 m -25,10 0,-30 50,0 0,30"}],O["TP.SP CLASS V"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 80,15 0,-50 c 0,-20 40,-20 40,0 l 0,50 m -50,0 60,0"}],O["TP.SP CLASS VI"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 75,-20 50,0 m -25,15 15,25 m -15,-50 0,25 -20,25 m 30,-60 c 0,5.5228 -4.477,10 -10,10 -5.5228,0 -10,-4.4772 -10,-10 0,-5.5228 4.4772,-10 10,-10 5.523,0 10,4.4772 10,10 z"}],O["TP.SP CLASS VII"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 85,-25 c 10,-10 20,-10 30,0"},{type:"path",d:"m 129.6,-20 c 0,5.3019 -4.298,9.5999 -9.6,9.5998 -5.302,10e-5 -9.6,-4.2979 -9.6,-9.5998 0,-5.3019 4.298,-9.5999 9.6,-9.5998 5.302,-1e-4 9.6,4.2979 9.6,9.5998 z m -40.4886,0 c 0,5.0321 -4.0793,9.1114 -9.1114,9.1114 -5.0321,0 -9.1114,-4.0793 -9.1114,-9.1114 0,-5.0321 4.0793,-9.1114 9.1114,-9.1114 5.0321,0 9.1114,4.0793 9.1114,9.1114 z"}],O["TP.SP CLASS VIII"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 60,-15 80,0 m -40,-45 0,90"}],O["TP.SP CLASS IX"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 121.213,-36.2132 -7.08,7.0802 M 85.8669,-0.866982 78.7868,6.2132 m 0,-42.4264 7.0801,7.0802 m 28.2661,28.266018 7.08,7.080182 M 100,-45 l 0,10 m 0,40 0,10 m -30,-30 10,0 m 40,0 10,0 m -10,0 c 0,11.04569 -8.954,20 -20,20 -11.0457,0 -20,-8.95431 -20,-20 0,-11.0457 8.9543,-20 20,-20 11.046,0 20,8.9543 20,20 z"}],O["TP.SP CLASS X"]=[O["TP.SUPPLY POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:40,text:"CA"}],O["TP.MEDICAL SUPPLY POINT"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 100,-20 0,-40 m -40,25 80,0"}],O["TP.MORTUARY AFFAIRS COLLECTION POINT"]=[O["TP.SUPPLY POINT"],{type:"path",fill:!1,d:"m 113,-50 v 21  M 75,-40 h 50  M 67,-54 h 66 v 30 H 67 Z"}],O["TP.AMMUNITION SUPPLY POINT (ASP)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ASP"}],O["TP.AMMUNITION TRANSFER POINT (ATP)"]=[O["TP.ACTION POINT"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:-30,fontsize:35,text:"ATP"}],O["TP.TARGET HANDOVER"]=[{type:"path",strokedasharray:"10,5",fill:!1,d:"m 100,45 -15,40 -40,15 40,15 15,40 15,-40 40,-15 -40,-15 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:100,fontsize:30,text:"TH"}],O["TP.KEY TERRAIN"]=[{type:"path",fill:!1,stroke:"rgb(128,0,128)",strokewidth:6,d:"m 145,100 a 45,45 0 0 1 -45,45 45,45 0 0 1 -45,-45 45,45 0 0 1 45,-45 45,45 0 0 1 45,45 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:80,y:100,fontsize:35,text:"K",fill:"rgb(128,0,128)"}],O["TP.CONTROL POINT"]=[O["TP.ACTION POINT"],{type:"path",d:"m 131,-35 -5,-5 v 10 z  m -31.1,16 -4.8,-5 h 9.9 z  m 0,-33 -5,5 H 105 Z  m -29.9,17 5,-5 v 10 z  m 30,-16.3 V -19  M 70,-35 h 60"}],O["TP.VITAL GROUND"]=[{type:"path",fill:!1,stroke:"rgb(128,0,128)",strokewidth:6,d:"m 145,100 a 45,45 0 0 1 -45,45 45,45 0 0 1 -45,-45 45,45 0 0 1 45,-45 45,45 0 0 1 45,45 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:100,fontsize:35,text:"VG",fill:"rgb(128,0,128)"}],O["TP.BT BOUY DROP"]=[{type:"path",fill:!1,d:"m 65,45 0,110 70,0 0,-110 m -35,95 0,-95 m -35,0 70,0"},{type:"path",d:"m 104,100 c 0,2 -3,2 -4.8,2 -1.4,0 -4.1,-1 -2.7,-2.9 1.9,-1.4 4.5,-1.4 6.5,-0.4 1,0.3 1,0.7 1,1.3 z m 0,40 c 0,2 -3,2 -4.8,2 -1.4,0 -4.1,-1 -2.7,-3 1.9,-1 4.5,-1 6.5,0 1,0 1,0 1,1 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:80,y:100,fontsize:35,text:"B"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:120,y:100,fontsize:35,text:"T"}],O["TP.REPORTED BOTTOMED SUB"]={type:"path",fill:!1,d:"M 129,122.4 70.9,78.8 m 0,43.6 58.1,-43.6 m -80,-14.5 0,43.6 29,0 0,29 43.6,0 0,-29 29,0 0,-43.6"},O["TP.MOVING HAVEN"]={type:"path",d:"M 108.142,100 A 8.14167,8.14167 0 0 1 100,108.142 8.14167,8.14167 0 0 1 91.8583,100 8.14167,8.14167 0 0 1 100,91.8583 8.14167,8.14167 0 0 1 108.142,100 Z M 45,55 l 0,90 m 110,-90 0,90 m -110,-45 110,0"},O["TP.SCREEN CENTRE"]={type:"path",d:"m 100,55 0,90 m 8.142,-45 A 8.14167,8.14167 0 0 1 100,108.142 8.14167,8.14167 0 0 1 91.8583,100 8.14167,8.14167 0 0 1 100,91.8583 8.14167,8.14167 0 0 1 108.142,100 Z"},O["TP.SHORE CONTROL STATION"]={type:"path",fill:!1,d:"m 30,155 140,0 m -27,-20 2,-10 -10,5 m -78,5 -2,-10 10,5 m 35,-55 0,68 m 7.5,-76 A 7.5,7.5 0 0 1 100,74.5 7.5,7.5 0 0 1 92.5,67 7.5,7.5 0 0 1 100,59.5 7.5,7.5 0 0 1 107.5,67 Z m -52.5,8 90,0 m -90,50 c 15,25 75,25 90,0 M 40,45 50,55 60,45 70,55 80,45 l 10,10 10,-10 10,10 10,-10 10,10 10,-10 10,10 10,-10"},O["TP.DITCHED AIRCRAFT"]={type:"path",d:"m 145,120 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 10,10 25,-30 -10,-10 10,-10 20,20 -10,35 -15,-15 -15,15 z"},O["TP.PERSON IN WATER"]={type:"path",d:"m 105,110 10,-10 0,-15 5,0 0,20 -10,10 z m -10,0 -10,-10 0,-15 -5,0 0,20 10,10 z m 5,-5 0,-10 -5,0 -5,-5 0,-10 5,-5 10,0 5,5 0,10 -5,5 -5,0 m -15,25 15,-15 m 45,15 -15,-15 m -15,15 15,-15 m -75,15 15,-15 m 15,15 -15,-15 m 45,15 -15,-15"},O["TP.CLUTTER, STATIONARY OR CEASE REPORTING"]={type:"path",fill:!1,d:"m 65,135 c 23.3,-23 47,-46.7 70,-70 m -70,0 c 23.3,23.3 47,47 70,70 m -35,-4 c -19.7,0 -47.8,-8 -50,-31 3,-24.9 33.9,-32 55,-30.7 19,0.8 46,10.9 45,33.7 -5,21 -31,28 -50,28 z m 31,-31 c 0,20 -8,48 -31,50 C 75.1,147 68,116 69.3,95 70.1,76.2 80.2,48.6 103,50.2 c 21,4.9 28,31.1 28,49.8 z"},O["TP.TENTATIVE OR PROVISIONAL TRACK"]={type:"path",fill:!1,d:"M 130.902,100 A 30.9017,50 0 0 1 100,150 30.9017,50 0 0 1 69.0983,100 30.9017,50 0 0 1 100,50 30.9017,50 0 0 1 130.902,100 Z M 100,130.902 A 50,30.9017 0 0 1 50,100 50,30.9017 0 0 1 100,69.0983 50,30.9017 0 0 1 150,100 50,30.9017 0 0 1 100,130.902 Z"},O["TP.DISTRESSED VESSEL"]={type:"path",d:"m 120,65 -20,20 20,-20 m -5,55 -35,-35 0,-20 45,45 z m -30,0 -15,-15 m -15,15 15,-15 m 45,15 15,-15 m 15,15 -15,-15 m -45,15 15,-15"},O["TP.SEA MINELIKE"]={type:"path",d:"M 75,75 55,55 m 45,-15 0,25 m 25,10 20,-20 m -80,60 0,-30 20,-20 30,0 20,20 0,30 -20,20 -30,0 z"},O["TP.ICEBERG"]={type:"path",d:"m 75,100 25,-30 25,30 -5,15 -5,-5 -15,20 -15,-20 -5,5 z m -15,0 80,0"},O["TP.OIL RIG/PLATFORM"]=[{type:"path",d:"m 55,100 0,-50 m 75,50 0,40 m 20,-40 0,40 m -115,0 0,-40 130,0",fill:!1},{type:"path",d:"m 55,100 0,-15 25,0 0,15 z"}],O["TP.BOTTOM RETURN"]={type:"path",d:"m 50,100 15,-35 15,30 20,-55 20,55 15,-35 15,40 z"},O["TP.INSTALLATION/MANMADE"]={type:"path",fill:!1,d:"m 50,100 15,-35 15,30 20,-55 20,55 15,-35 15,40 z"},O["TP.WRECK, NON DANGEROUS"]={type:"path",fill:!1,d:"m 135,85 0,30 m -85,-15 100,0 m -85,-15 0,30 m 35,-40 0,50"},O["TP.WRECK, DANGEROUS"]=[O["TP.WRECK, NON DANGEROUS"],{type:"path",strokedasharray:"5,5",fill:!1,d:"m 156.547,100 c 0,16.382 -25.162,29.662 -56.202,29.662 -31.0395,0 -56.2019,-13.28 -56.2017,-29.662 0,-16.3818 25.1624,-29.6618 56.2017,-29.6618 31.039,-1e-4 56.202,13.28 56.202,29.6618 z"}],O["TP.MARINE LIFE"]={type:"path",stroke:!1,d:"m 132,75 0,50 83,-37.5 0,25 L 132,75 m -32,25 25.5,-25 0,50 z"},O["TP.SEA ANOMALY"]={type:"path",fill:!1,d:"M 150,80 130,35 100,100 70,35 50,80 m 0,20 20,-45 30,65 30,-65 20,45"},O["TP.FIX ACOUSTIC"]={type:"path",fill:!1,d:"M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},O["TP.FIX ELECTRO-MAGNETIC"]={type:"path",fill:!1,d:"m 50,90 15,20 5,-20 15,20 5,-20 20,20 5,-20 15,20 5,-20 15,20 M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},O["TP.ELECTRO MAGNETIC - MAGNETIC ANOMALY DETECTION (MAD)"]=[O["TP.FIX ELECTRO-MAGNETIC"],{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:170,fontsize:35,text:"MAD"}],O["TP.FIX ELECTRO-OPTICAL"]={type:"path",fill:!1,d:"m 150,100 c 0,6.904 -22.386,12.5 -50,12.5 -27.6142,0 -50,-5.596 -50,-12.5 0,-6.9036 22.3858,-12.5 50,-12.5 27.614,0 50,5.5964 50,12.5 z M 50,150 150,50 M 50,50 150,150 m -50,-100 0,100"},O["TP.FIRE"]={type:"text",alignmentBaseline:"middle",stroke:!1,fill:E.iconColor[A],textanchor:"middle",x:100,y:103,fontsize:35,text:"FIRE"},O["TP.INDIRECT FIRE"]={type:"path",stroke:E.iconColor[A],fill:!1,d:"m 100,60 0,80 m -40,-40 80,0"},O["TP.AMBUSH"]={type:"path",stroke:E.iconColor[A],fill:!1,d:"m 77.5,106 20,0 m -20,-12 20,0 M 75,82 95,82 m -20,36 20,0 m -25,12 20,0 M 70,70 90,70 M 80,60 c 25,15 25,65 0,80 m 45,-50 10,10 -10,10 m -25,-10 35,0"},O["TP.ROAD BLOCK"]={type:"path",stroke:E.iconColor[A],fill:!1,d:"m 73,133 60,-60 m -66,54 60,-60 m -54,0 60,60 m -66,-54 60,60"},O["TP.ROAD BLOCK (UNDER CONSTRUCTION)"]=[{type:"path",stroke:E.iconColor[A],fill:!1,strokedasharray:"5,5",d:"m 73,67 60,60 m -66,-54 60,60"},{type:"path",stroke:E.iconColor[A],fill:!1,d:"M 73,133 133,73 M 67,127 127,67"}],O["TP.VITAL AREA CENTRE"]=[{type:"path",fill:!1,d:"m 45,100 110,0 m 0,-40 0,85 M 45,60 l 0,80 m 55,-80 0,80"}],O["TP.ESTIMATED POSITION (EP)"]=[{type:"path",fill:!1,strokedasharray:"12,5",d:"M 160,160 40,160 40,40 160,40 Z"},{type:"path",fill:!1,d:"m 140,100 c 1,26 -27,47 -51.8,38 C 63.1,131 51.5,98.3 67,77.4 c 13.8,-21.9 49,-23.2 64,-2.3 6,7 9,15.9 9,24.9 z"},{type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"EP"}],O["FORWARD OBSERVER / SPOTTER POSITION"]=[{type:"circle",cx:100,cy:100,r:3},{type:"path",fill:!1,d:"m 40,135 60,-75 60,75 z"}],O["MAN MADE SPACE DEBRIS SMALL"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"M 60,110 75,100 60,90 m 50,50 -10,-15 -10,15 m 50,-50 -15,10 15,10 M 90,60 100,75 110,60"}],O["MAN MADE SPACE DEBRIS MEDIUM"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50}],O["MAN MADE SPACE DEBRIS BIG"]=[{type:"circle",cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"m 90,75 10,-15 10,15 M 75,110 60,100 75,90 m 35,35 -10,15 -10,-15 m 35,-35 15,10 -15,10"}],O["NATURAL SPACE DEBRIS SMALL"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"M 60,110 75,100 60,90 m 50,50 -10,-15 -10,15 m 50,-50 -15,10 15,10 M 90,60 100,75 110,60"}],O["NATURAL SPACE DEBRIS MEDIUM"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50}],O["NATURAL SPACE DEBRIS BIG"]=[{type:"circle",fill:!1,cx:100,cy:100,r:17},{type:"circle",fill:!1,cx:100,cy:100,r:50},{type:"path",fill:!1,d:"m 90,75 10,-15 10,15 M 75,110 60,100 75,90 m 35,35 -10,15 -10,-15 m 35,-35 15,10 -15,10"}],O["TP.M1.UNSPECIFIED"]=[{type:"circle",fill:!1,cx:55,cy:100,r:15},{type:"circle",fill:!1,cx:100,cy:100,r:15},{type:"circle",fill:!1,cx:145,cy:100,r:15}],O["TP.M1.ANTIPERSONNEL MINE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 35,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],O["TP.M1.ANTIPERSONNEL MINE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 80,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],O["TP.M1.ANTIPERSONNEL MINE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 125,75 10.6,13.3 m 18.8,0 10.6,-13.3"}],O["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"M 64.4,88.3 75,75 m -40,0 10.6,13.3 m 32.4,10 2,1.7 -2,2 z m -8,1.7 3.3,0"}],O["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"M 109,88.3 120,75 m -40,0 10.6,13.3 m 32.4,10 2,1.7 -2,2 z m -8,1.7 3,0"}],O["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"M 154,88.3 165,75 m -40,0 11,13.3 m 32,10 2,1.7 -2,2 z m -8,1.7 3,0"}],O["TP.M1.ANTITANK MINE 1"]=[{type:"circle",cx:55,cy:100,r:15}],O["TP.M1.ANTITANK MINE 2"]=[{type:"circle",cx:100,cy:100,r:15}],O["TP.M1.ANTITANK MINE 3"]=[{type:"circle",cx:145,cy:100,r:15}],O["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 55,115 0,13 6,-6"}],O["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 100,115 0,13 6,-6"}],O["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 145,115 0,13 6,-6"}],O["TP.M1.WIDE AREA ANTITANK MINE 1"]=[{type:"circle",cx:55,cy:100,r:15},{type:"path",fill:!1,d:"m 35,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],O["TP.M1.WIDE AREA ANTITANK MINE 2"]=[{type:"circle",cx:100,cy:100,r:15},{type:"path",fill:!1,d:"m 80,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],O["TP.M1.WIDE AREA ANTITANK MINE 3"]=[{type:"circle",cx:145,cy:100,r:15},{type:"path",fill:!1,d:"m 125,115 8,10 5.5,-11 m 13,0 5.5,11 8,-10"}],O["TP.M1.MINE CLUSTER 1"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 73,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],O["TP.M1.MINE CLUSTER 2"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 118,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],O["TP.M1.MINE CLUSTER 3"]=[{type:"path",fill:!1,strokedasharray:"7.5,5",d:"m 163,110 -36,0 c 0,-10 3,-20 18,-20 15,0 18,10 18,20 z"}],O["TP.M1.DISMOUNTED"]=[{type:"path",fill:!1,strokewidth:8,d:"m 140,100 -20,35 -40,0 -20,-35 20,-34.6 40,0 z"}],O["TP.M2.URBAN"]={type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"URBAN"},O["TP.M2.WATER"]={type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"WATER"},O["TP.M2.GROUND"]={type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"GROUND"},O["TP.M2.VEGETATION"]={type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"VEGETATION"},O["TP.M2.OBSTACLES"]={type:"text",alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:103,fontsize:35,text:"OBSTACLES"};for(const i in O)O.hasOwnProperty(i)&&(t.hasOwnProperty(i)&&console.warn("Override of: "+i),s.call(this,O[i],T),t[i]=O[i])}var x={type:"letter",getMetadata:e,getIcons:R,iconParts:[d],labels:function(t){t["G-T-D-----"]={},t["G-T-I-----"]={},t["G-T-N-----"]={},t["G-G-GPUUD-"]={},t["G-G-GPUUB-"]={},t["G-G-GPUUL-"]={},t["G-G-GPUUS-"]={},t["G-G-GPUY--"]={},t["G-G-GPUYP-"]={},t["G-G-GPUYD-"]={},t["G-G-GPUYL-"]={},t["G-G-GPUYC-"]={},t["G-G-GPUYS-"]={},t["G-G-GPUYB-"]={},t["G-G-GPUYA-"]={},t["G-G-GPUYV-"]={},t["G-G-GPUYT-"]={},t["G-G-GPUYR-"]={},t["G-G-GPUYK-"]={},t["G-G-GPUYX-"]={},t["G-G-GPUS--"]={},t["G-G-GPUSA-"]={},t["G-G-GPUSD-"]={},t["G-G-GPUSC-"]={},t["G-G-GPR---"]={},t["G-G-GPRN--"]={},t["G-G-GPRS--"]={},t["G-G-GPRD--"]={},t["G-G-GPRP--"]={},t["G-G-GPRM--"]={},t["G-G-GPRW--"]={},t["G-G-GPRC--"]={},t["G-G-GPRI--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:45,fontweight:"bold"}},t["G-G-GPWA--"]={},t["G-G-GPWD--"]={},t["G-G-GPWE--"]={},t["G-G-GPWG--"]={},t["G-G-GPWM--"]={},t["G-G-GPWI--"]={},t["G-G-GPWP--"]={},t["G-G-GPF---"]={},t["G-G-GPH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},t["G-G-GPHQ--"]={},t["G-G-GPHA--"]={},t["G-G-GPHY--"]={},t["G-G-GPHX--"]={},t["G-G-GPO---"]={},t["G-G-GPOZ--"]={},t["G-G-GPOD--"]={},t["G-G-GPOW--"]={},t["G-G-GPOP--"]={},t["G-G-GPOR--"]={},t["G-G-GPA---"]={},t["G-G-GPAP--"]={},t["G-G-GPAW--"]={},t["G-G-GPAK--"]={},t["G-G-GPAA--"]={},t["G-G-GPAH--"]={},t["G-G-GPAB--"]={},t["G-G-GPAC--"]={},t["G-G-GPAD--"]={},t["G-G-GPAE--"]={},t["G-G-GPAS--"]={},t["G-G-GPAT--"]={},t["G-G-GPAO--"]={},t["G-G-GPAR--"]={},t["G-G-GPAL--"]={},t["G-G-GPAF--"]={},t["G-G-GPAG--"]={},t["G-G-GPAI--"]={},t["G-G-GPAJ--"]={},t["G-G-GPAM--"]={},t["G-G-GPAN--"]={},t["G-G-GPP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},additionalInformation1:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35,fontweight:"bold"},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPK--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPC--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:40,fontsize:45,fontweight:"bold"}},t["G-G-GPPO--"]={},t["G-G-GPPD--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},t["G-G-GPPL--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPP--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPR--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPS--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-G-GPPW--"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:117,fontsize:50}},t["G-G-GPC---"]={},t["G-G-GPCU--"]={},t["G-G-GPCUR-"]={},t["G-G-GPCUA-"]={},t["G-G-GPCUS-"]={},t["G-G-GPCUM-"]={},t["G-G-GPCA--"]={},t["G-G-GPCS--"]={},t["G-G-GPCM--"]={},t["G-G-GPCP--"]={},t["G-G-GPCR--"]={},t["G-G-GPCC--"]={},t["G-G-GPCE--"]={},t["G-G-GPCN--"]={},t["G-G-GPB---"]={},t["G-G-GPBU--"]={},t["G-G-GPBUA-"]={},t["G-G-GPBUS-"]={},t["G-G-GPBUM-"]={},t["G-G-GPBS--"]={},t["G-G-GPBSA-"]={},t["G-G-APP---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},t["G-G-APC---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},t["G-G-APU---"]={},t["G-G-APD---"]={},t["G-G-PN----"]={},t["G-G-DPT---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:115,y:85,fontsize:45,fontweight:"bold"}},t["G-G-DPO---"]={},t["G-G-DPOC--"]={},t["G-G-DPOR--"]={},t["G-G-DPOF--"]={},t["G-G-DPOS--"]={},t["G-G-DPON--"]={},t["G-G-OPP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-OAOF--"]={},t["G-M-OAOM--"]={},t["G-M-OAOP--"]={},t["G-M-OB----"]={},t["G-M-OMU---"]={},t["G-M-OMT---"]={},t["G-M-OMD---"]={},t["G-M-OME---"]={},t["G-M-OMP---"]={},t["G-M-OMW---"]={},t["G-M-OFS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:55,fontsize:40},hostile:[{stroke:!1,textanchor:"end",x:35,y:110,fontsize:30,fontweight:"bold"},{stroke:!1,textanchor:"start",x:165,y:110,fontsize:30,fontweight:"bold"}],dtg:{stroke:!1,textanchor:"middle",x:100,y:175,fontsize:40}},t["G-M-OHTL--"]={altitudeDepth:{stroke:!1,textanchor:"start",x:120,y:60,fontsize:40,fontweight:"bold"}},t["G-M-OHTH--"]={altitudeDepth:{stroke:!1,textanchor:"start",x:115,y:60,fontsize:40,fontweight:"bold"}},t["G-M-BCP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-SE----"]={},t["G-M-SF----"]={},t["G-M-SS----"]={},t["G-M-SU----"]={},t["G-M-NZ----"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-M-NF----"]={},t["G-M-NEB---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-M-NEC---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-M-NDP---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDO---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-M-NDD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-F-PTS---"]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},t["G-F-PTN---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40,fontweight:"bold"}},t["G-F-PCF---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:125,y:115,fontsize:40,fontweight:"bold"}},t["G-F-PCS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-F-PCB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-F-PCR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-F-PCH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-F-PCL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PX----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PC----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PY----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PT----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PD----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PE----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PL----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PM----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PR----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PU----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PO----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PI----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PN----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PS----"]={},t["G-S-PSZ---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSB---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSF---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSG---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSH---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PSJ---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PA----"]={},t["G-S-PAS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-S-PAT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-O-ED----"]={},t["G-O-EP----"]={},t["G-O-EV----"]={},t["G-O-HM----"]={},t["G-O-HI----"]={},t["G-O-HO----"]={},t["G-O-SB----"]={},t["G-O-SBM---"]={},t["G-O-SBN---"]={},t["G-O-SBW---"]={},t["G-O-SBX---"]={},t["G-O-SM----"]={},t["G-O-SS----"]={},t["G-O-FA----"]={},t["G-O-FE----"]={},t["G-O-FO----"]={}},icons:function(t,I,E,e){t["G-T-D-----"]=E["TP.DESTROY"],I["G-T-D-----"]={x1:0,x2:200,y1:40,y2:160},t["G-T-I-----"]=E["TP.INTERDICT"],I["G-T-I-----"]={x1:0,x2:200,y1:40,y2:160},t["G-T-N-----"]=E["TP.NEUTRALIZE"],I["G-T-N-----"]={x1:0,x2:200,y1:40,y2:160},t["G-G-GPUUD-"]=E["TP.DATUM"],I["G-G-GPUUD-"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPUUB-"]=E["TP.BRIEF CONTACT"],I["G-G-GPUUB-"]={x1:50,x2:150,y1:0,y2:100},t["G-G-GPUUL-"]=E["TP.LOST CONTACT"],I["G-G-GPUUL-"]={x1:50,x2:150,y1:0,y2:100},t["G-G-GPUUS-"]=E["TP.SINKER"],I["G-G-GPUUS-"]={x1:50,x2:150,y1:0,y2:100},t["G-G-GPUY--"]=E["TP.SONOBUOY"],I["G-G-GPUY--"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYP-"]=E["TP.SONOBUOY PATTERN CENTER"],I["G-G-GPUYP-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYD-"]=E["TP.SONOBUOY DIFAR"],I["G-G-GPUYD-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYL-"]=E["TP.SONOBUOY LOFAR"],I["G-G-GPUYL-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYC-"]=E["TP.SONOBUOY CASS"],I["G-G-GPUYC-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYS-"]=E["TP.SONOBUOY DICASS"],I["G-G-GPUYS-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYB-"]=E["TP.SONOBUOY BT"],I["G-G-GPUYB-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYA-"]=E["TP.SONOBUOY ANM"],I["G-G-GPUYA-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYV-"]=E["TP.SONOBUOY VLAD"],I["G-G-GPUYV-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYT-"]=E["TP.SONOBUOY ATAC"],I["G-G-GPUYT-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYR-"]=E["TP.SONOBUOY RO"],I["G-G-GPUYR-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYK-"]=E["TP.SONOBUOY KINGPIN"],I["G-G-GPUYK-"]={x1:60,x2:140,y1:-10,y2:160},t["G-G-GPUYX-"]=E["TP.SONOBUOY EXPIRED"],I["G-G-GPUYX-"]={x1:40,x2:160,y1:-10,y2:160},t["G-G-GPUS--"]=E["TP.SEARCH"],I["G-G-GPUS--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPUSA-"]=E["TP.SEARCH AREA"],I["G-G-GPUSA-"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPUSD-"]=E["TP.DIP POSITION"],I["G-G-GPUSD-"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPUSC-"]=E["TP.SEARCH CENTER"],I["G-G-GPUSC-"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPR---"]=E["TP.REFERENCE POINT"],I["G-G-GPR---"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRN--"]=E["TP.NAVIGATIONAL REFERENCE"],I["G-G-GPRN--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRS--"]=E["TP.SPECIAL POINT"],I["G-G-GPRS--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRD--"]=E["TP.DLRP"],I["G-G-GPRD--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRP--"]=E["TP.POINT OF INTENDED MOVEMENT"],I["G-G-GPRP--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRM--"]=E["TP.MARSHALL POINT"],I["G-G-GPRM--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRW--"]=E["TP.REFERENCE POINT WAYPOINT"],I["G-G-GPRW--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRC--"]=E["TP.CORRIDOR TAB"],I["G-G-GPRC--"]={x1:40,x2:160,y1:40,y2:160},t["G-G-GPRI--"]=E["TP.POINT OF INTEREST"],I["G-G-GPRI--"]={x1:50,x2:150,y1:-25},t["G-G-GPWA--"]=E["TP.AIM POINT"],I["G-G-GPWA--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPWD--"]=E["TP.DROP POINT"],I["G-G-GPWD--"]={x1:50,x2:150,y1:50,y2:120},t["G-G-GPWE--"]=E["TP.ENTRY POINT"],I["G-G-GPWE--"]={x1:50,x2:150,y1:50},t["G-G-GPWG--"]=E["TP.GROUND ZERO"],I["G-G-GPWG--"]={x1:50,x2:150,y1:30},t["G-G-GPWM--"]=E["TP.MSL DETECT POINT"],I["G-G-GPWM--"]={x1:50,x2:150,y1:30},t["G-G-GPWI--"]=E["TP.IMPACT POINT"],I["G-G-GPWI--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPWP--"]=E["TP.PREDICTED IMPACT POINT"],I["G-G-GPWP--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPF---"]=E["TP.FORMATION"],I["G-G-GPF---"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPH---"]=E["TP.HARBOR"],I["G-G-GPH---"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPHQ--"]=E["TP.HARBOR POINT Q"],I["G-G-GPHQ--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPHA--"]=E["TP.HARBOR POINT A"],I["G-G-GPHA--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPHY--"]=E["TP.HARBOR POINT Y"],I["G-G-GPHY--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPHX--"]=E["TP.HARBOR POINT X"],I["G-G-GPHX--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPO---"]=E["TP.ROUTE"],I["G-G-GPO---"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPOZ--"]=E["TP.ROUTE RENDEZVOUS"],I["G-G-GPOZ--"]={x1:30,x2:170,y1:60,y2:170},t["G-G-GPOD--"]=E["TP.ROUTE DIVERSIONS"],I["G-G-GPOD--"]={x1:30,x2:170,y1:60,y2:170},t["G-G-GPOW--"]=E["TP.ROUTE WAYPOINT"],I["G-G-GPOW--"]={x1:30,x2:170,y1:60,y2:170},t["G-G-GPOP--"]=E["TP.ROUTE PIM"],I["G-G-GPOP--"]={x1:30,x2:170,y1:60,y2:170},t["G-G-GPOR--"]=E["TP.ROUTE POINT R"],I["G-G-GPOR--"]={x1:30,x2:170,y1:60,y2:170},t["G-G-GPA---"]=E["TP.AIR CONTROL POINT"],I["G-G-GPA---"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAP--"]=E["TP.COMBAT AIR PATROL (CAP)"],I["G-G-GPAP--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAW--"]=E["TP.AIRBORNE EARLY WARNING (AEW)"],I["G-G-GPAW--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAK--"]=E["TP.TANKING"],I["G-G-GPAK--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAA--"]=E["TP.ASW FIXED WING"],I["G-G-GPAA--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAH--"]=E["TP.ASW ROTARY WING"],I["G-G-GPAH--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAB--"]=E["TP.SUCAP - FIXED WING"],I["G-G-GPAB--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAC--"]=E["TP.SUCAP - ROTARY WING"],I["G-G-GPAC--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAD--"]=E["TP.MIW - FIXED WING"],I["G-G-GPAD--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAE--"]=E["TP.MIW - ROTARY WING"],I["G-G-GPAE--"]={x1:60,x2:140,y1:40,y2:160},t["G-G-GPAS--"]=E["TP.STRIKE IP"],I["G-G-GPAS--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAT--"]=E["TP.TACAN"],I["G-G-GPAT--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAO--"]=E["TP.TOMCAT"],I["G-G-GPAO--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAR--"]=E["TP.RESCUE"],I["G-G-GPAR--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAL--"]=E["TP.REPLENISH"],I["G-G-GPAL--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAF--"]=E["TP.UNMANNED AERIAL SYSTEM"],I["G-G-GPAF--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAG--"]=E["TP.VTUA"],I["G-G-GPAG--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAI--"]=E["TP.ORBIT"],I["G-G-GPAI--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAJ--"]=E["TP.ORBIT - FIGURE EIGHT"],I["G-G-GPAJ--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAM--"]=E["TP.ORBIT - RACE TRACK"],I["G-G-GPAM--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPAN--"]=E["TP.ORBIT - RANDOM, CLOSED"],I["G-G-GPAN--"]={x1:60,x2:140,y1:30,y2:170},t["G-G-GPP---"]=E["TP.ACTION POINT"],I["G-G-GPP---"]={x1:60,x2:140,y1:-60},t["G-G-GPPK--"]=E["TP.ACTION CHECK POINT"],I["G-G-GPPK--"]={x1:60,x2:140,y1:-60},t["G-G-GPPC--"]=E["TP.CONTACT POINT"],I["G-G-GPPC--"]={x1:55,x2:145,y1:-10},t["G-G-GPPO--"]=E["TP.COORDINATION POINT"],I["G-G-GPPO--"]={x1:50,x2:150,y1:50,y2:150},t["G-G-GPPD--"]=E["TP.DECISION POINT"],I["G-G-GPPD--"]={x1:30,x2:170,y1:25,y2:160},t["G-G-GPPL--"]=E["TP.ACTION LINKUP POINT"],I["G-G-GPPL--"]={x1:60,x2:140,y1:-60},t["G-G-GPPP--"]=E["TP.ACTION PASSAGE POINT"],I["G-G-GPPP--"]={x1:60,x2:140,y1:-60},t["G-G-GPPR--"]=E["TP.ACTION RALLY POINT"],I["G-G-GPPR--"]={x1:60,x2:140,y1:-60},t["G-G-GPPE--"]=E["TP.ACTION RELEASE POINT"],I["G-G-GPPE--"]={x1:60,x2:140,y1:-60},t["G-G-GPPS--"]=E["TP.ACTION START POINT"],I["G-G-GPPS--"]={x1:60,x2:140,y1:-60},t["G-G-GPPA--"]=E["TP.ACTION AMNESTY POINT"],I["G-G-GPPA--"]={x1:60,x2:140,y1:-60},t["G-G-GPPW--"]=E["TP.WAYPOINT"],I["G-G-GPPW--"]={x1:60,x2:140,y1:60,y2:140},t["G-G-GPC---"]=E["TP.SEA SURFACE CONTROL STATION"],I["G-G-GPC---"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCU--"]=E["TP.(USV) CONTROL STATION"],I["G-G-GPCU--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCUR-"]=E["TP.(RMV) USV CONTROL STATION"],I["G-G-GPCUR-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCUA-"]=E["TP.USV - ASW CONTROL STATION"],I["G-G-GPCUA-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCUS-"]=E["TP.USV - SUW CONTROL STATION"],I["G-G-GPCUS-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCUM-"]=E["TP.USV - MIW CONTROL STATION"],I["G-G-GPCUM-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCA--"]=E["TP.ASW CONTROL STATION"],I["G-G-GPCA--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCS--"]=E["TP.SUW CONTROL STATION"],I["G-G-GPCS--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCM--"]=E["TP.MIW CONTROL STATION"],I["G-G-GPCM--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCP--"]=E["TP.PICKET CONTROL STATION"],I["G-G-GPCP--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCR--"]=E["TP.RENDEZVOUS CONTROL POINT"],I["G-G-GPCR--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCC--"]=E["TP.RESCUE CONTROL POINT"],I["G-G-GPCC--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCE--"]=E["TP.REPLENISHMENT CONTROL POINT"],I["G-G-GPCE--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPCN--"]=E["TP.NONCOMBATANT CONTROL STATION"],I["G-G-GPCN--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPB---"]=E["TP.SUB SURFACE CONTROL STATION"],I["G-G-GPB---"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBU--"]=E["TP.(UUV) CONTROL STATION"],I["G-G-GPBU--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBUA-"]=E["TP.UUV - ASW CONTROL STATION"],I["G-G-GPBUA-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBUS-"]=E["TP.UUV - SUW CONTROL STATION"],I["G-G-GPBUS-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBUM-"]=E["TP.UUV - MIW CONTROL STATION"],I["G-G-GPBUM-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBS--"]=E["TP.SUBMARINE CONTROL STATION"],I["G-G-GPBS--"]={x1:30,x2:170,y1:60,y2:140},t["G-G-GPBSA-"]=E["TP.ASW SUBMARINE CONTROL STATION"],I["G-G-GPBSA-"]={x1:30,x2:170,y1:60,y2:140},t["G-G-APP---"]=E["TP.AIR CONTROL POINT (ACP)"],I["G-G-APP---"]={x1:50,x2:150,y1:50,y2:150},t["G-G-APC---"]=E["TP.COMMUNICATIONS CHECKPOINT"],I["G-G-APC---"]={x1:50,x2:150,y1:50,y2:150},t["G-G-APU---"]=E["TP.PULL-UP POINT"],I["G-G-APU---"]={x1:50,x2:240,y1:50,y2:150},t["G-G-APD---"]=E["TP.DOWNED AIRCREW PICKUP POINT"],I["G-G-APD---"]={x1:60,x2:140,y1:-60},t["G-G-PN----"]=E["TP.DUMMY MINEFIELD"],I["G-G-PN----"]={x1:40,x2:160,y1:-10,y2:140},t["G-G-DPT---"]=E["TP.TARGET REFERENCE"],t["G-G-DPO---"]=E["TP.OBSERVATION POST/OUTPOST"],I["G-G-DPO---"]={x1:50,x2:150,y1:40,y2:150},t["G-G-DPOC--"]=E["TP.COMBAT OUTPOST"],I["G-G-DPOC--"]={x1:50,x2:150,y1:40,y2:150},t["G-G-DPOR--"]=E["TP.OBSERVATION POST/RECONNAISSANCE"],I["G-G-DPOR--"]={x1:50,x2:150,y1:40,y2:150},t["G-G-DPOF--"]=E["TP.FORWARD OBSERVER POSITION"],I["G-G-DPOF--"]={x1:50,x2:150,y1:40,y2:150},t["G-G-DPOS--"]=E["TP.SENSOR OUTPOST"],I["G-G-DPOS--"]={x1:50,x2:150,y1:40,y2:150},t["G-G-DPON--"]=E["TP.CBRN OBSERVATION POST"],I["G-G-DPON--"]={x1:50,x2:150,y1:40,y2:150},t["G-G-OPP---"]=E["TP.POINT OF DEPARTURE"],I["G-G-OPP---"]={x1:60,x2:140,y1:-60},t["G-M-OAOF--"]=E["TP.FIXED AND PREFABRICATED"],I["G-M-OAOF--"]={x1:60,x2:140,y1:30},t["G-M-OAOM--"]=E["TP.TETRAHEDRONS"],I["G-M-OAOM--"]={x1:60,x2:140,y1:30},t["G-M-OAOP--"]=E["TP.TETRAHEDRONS MOVABLE"],I["G-M-OAOP--"]={x1:60,x2:140,y1:30},t["G-M-OB----"]=E["TP.BOOBY TRAP"],t["G-M-OMU---"]=E["TP.UNSPECIFIED MINE"],t["G-M-OMT---"]=E["TP.ANTITANK MINE (AT)"],t["G-M-OMD---"]=E["TP.(AT) ANTIHANDLING DEVICE"],I["G-M-OMD---"]={x1:60,x2:140,y1:40,y2:195},t["G-M-OME---"]=E["TP.(AT) DIRECTIONAL"],I["G-M-OME---"]={x1:60,x2:140,y1:10,y2:140},t["G-M-OMP---"]=E["TP.ANTIPERSONNEL (AP) MINES"],t["G-M-OMW---"]=E["TP.WIDE AREA MINES"],t["G-M-OFS---"]=E["TP.MINEFIELDS STATIC"],I["G-M-OFS---"]={x1:40,x2:160,y1:60,y2:140},t["G-M-OHTL--"]=E["TP.TOWER LOW"],I["G-M-OHTL--"]={x1:50,x2:150,y1:30,y2:120},t["G-M-OHTH--"]=E["TP.TOWER HIGH"],I["G-M-OHTH--"]={x1:50,x2:150,y1:30,y2:120},t["G-M-BCP---"]=E["TP.ENGINEER REGULATING POINT"],I["G-M-BCP---"]={x1:60,x2:140,y1:-60},t["G-M-SE----"]=E["TP.EARTHWORK/FORTIFICATION"],t["G-M-SF----"]=E["TP.FORT"],t["G-M-SS----"]=E["TP.SURFACE SHELTER"],t["G-M-SU----"]=E["TP.UNDERGROUND SHELTER"],t["G-M-NZ----"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],I["G-M-NZ----"]={x1:60,x2:140,y1:-20},t["G-M-NF----"]=E["TP.NUCLEAR FALLOUT PRODUCING"],I["G-M-NF----"]={x1:50,x2:150,y1:-20},t["G-M-NEB---"]=E["TP.RELEASE EVENTS BIOLOGICAL"],I["G-M-NEB---"]={x1:-10,x2:140,y1:-20},t["G-M-NEC---"]=E["TP.RELEASE EVENTS CHEMICAL"],I["G-M-NEC---"]={x1:-20,x2:140,y1:-20},t["G-M-NDP---"]=E["TP.DECON SITE/POINT"],I["G-M-NDP---"]={x1:60,x2:140,y1:-60},t["G-M-NDA---"]=E["TP.ALTERNATE DECON SITE/POINT"],I["G-M-NDA---"]={x1:60,x2:140,y1:-60},t["G-M-NDT---"]=E["TP.DECON SITE/POINT (TROOPS)"],I["G-M-NDT---"]={x1:60,x2:140,y1:-60},t["G-M-NDE---"]=E["TP.DECON SITE/POINT (EQUIPMENT)"],I["G-M-NDE---"]={x1:60,x2:140,y1:-60},t["G-M-NDB---"]=E["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],I["G-M-NDB---"]={x1:60,x2:140,y1:-60},t["G-M-NDO---"]=E["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],I["G-M-NDO---"]={x1:60,x2:140,y1:-60},t["G-M-NDD---"]=E["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],I["G-M-NDD---"]={x1:60,x2:140,y1:-60},t["G-F-PTS---"]=E["TP.POINT/SINGLE TARGET"],t["G-F-PTN---"]=E["TP.NUCLEAR TARGET"],t["G-F-PCF---"]=E["TP.FIRE SUPPORT STATION"],t["G-F-PCS---"]=E["TP.SURVEY CONTROL POINT"],I["G-F-PCS---"]={x1:60,x2:140,y1:-60},t["G-F-PCB---"]=E["TP.FIRING POINT"],I["G-F-PCB---"]={x1:60,x2:140,y1:-60},t["G-F-PCR---"]=E["TP.RELOAD POINT"],I["G-F-PCR---"]={x1:60,x2:140,y1:-60},t["G-F-PCH---"]=E["TP.HIDE POINT"],I["G-F-PCH---"]={x1:60,x2:140,y1:-60},t["G-F-PCL---"]=E["TP.LAUNCH POINT"],I["G-F-PCL---"]={x1:60,x2:140,y1:-60},t["G-S-PX----"]=E["TP.AMBULANCE EXCHANGE POINT"],I["G-S-PX----"]={x1:60,x2:140,y1:-60},t["G-S-PC----"]=E["TP.CANNIBALIZATION POINT"],I["G-S-PC----"]={x1:60,x2:140,y1:-60},t["G-S-PY----"]=E["TP.CASUALTY COLLECTION POINT"],I["G-S-PY----"]={x1:60,x2:140,y1:-60},t["G-S-PT----"]=E["TP.CIVILIAN COLLECTION POINT"],I["G-S-PT----"]={x1:60,x2:140,y1:-60},t["G-S-PD----"]=E["TP.DETAINEE COLLECTION POINT"],I["G-S-PD----"]={x1:60,x2:140,y1:-60},t["G-S-PE----"]=E["TP.EPW COLLECTION POINT"],I["G-S-PE----"]={x1:60,x2:140,y1:-60},t["G-S-PL----"]=E["TP.LOGISTICS RELEASE POINT"],I["G-S-PL----"]={x1:60,x2:140,y1:-60},t["G-S-PM----"]=E["TP.MAINTENANCE COLLECTION POINT"],I["G-S-PM----"]={x1:60,x2:140,y1:-60},t["G-S-PR----"]=E["TP.REARM, REFUEL AND RESUPPLY POINT"],I["G-S-PR----"]={x1:60,x2:140,y1:-60},t["G-S-PU----"]=E["TP.REFUEL ON THE MOVE POINT"],I["G-S-PU----"]={x1:60,x2:140,y1:-60},t["G-S-PO----"]=E["TP.TRAFFIC CONTROL POST"],I["G-S-PO----"]={x1:60,x2:140,y1:-60},t["G-S-PI----"]=E["TP.TRAILER TRANSFER POINT"],I["G-S-PI----"]={x1:60,x2:140,y1:-60},t["G-S-PN----"]=E["TP.UNIT MAINTENANCE COLLECTION POINT"],I["G-S-PN----"]={x1:60,x2:140,y1:-60},t["G-S-PSZ---"]=E["TP.SUPPLY POINT"],I["G-S-PSZ---"]={x1:60,x2:140,y1:-60},t["G-S-PSA---"]=E["TP.SP CLASS I"],I["G-S-PSA---"]={x1:60,x2:140,y1:-60},t["G-S-PSB---"]=E["TP.SP CLASS II"],I["G-S-PSB---"]={x1:60,x2:140,y1:-60},t["G-S-PSC---"]=E["TP.SP CLASS III"],I["G-S-PSC---"]={x1:60,x2:140,y1:-60},t["G-S-PSD---"]=E["TP.SP CLASS IV"],I["G-S-PSD---"]={x1:60,x2:140,y1:-60},t["G-S-PSE---"]=E["TP.SP CLASS V"],I["G-S-PSE---"]={x1:60,x2:140,y1:-60},t["G-S-PSF---"]=E["TP.SP CLASS VI"],I["G-S-PSF---"]={x1:60,x2:140,y1:-60},t["G-S-PSG---"]=E["TP.SP CLASS VII"],I["G-S-PSG---"]={x1:60,x2:140,y1:-60},t["G-S-PSH---"]=E["TP.SP CLASS VIII"],I["G-S-PSH---"]={x1:60,x2:140,y1:-60},t["G-S-PSI---"]=E["TP.SP CLASS IX"],I["G-S-PSI---"]={x1:60,x2:140,y1:-60},t["G-S-PSJ---"]=E["TP.SP CLASS X"],I["G-S-PSJ---"]={x1:60,x2:140,y1:-60},t["G-S-PAS---"]=E["TP.AMMUNITION SUPPLY POINT (ASP)"],I["G-S-PAS---"]={x1:60,x2:140,y1:-60},t["G-S-PAT---"]=E["TP.AMMUNITION TRANSFER POINT (ATP)"],I["G-S-PAT---"]={x1:60,x2:140,y1:-60},t["G-O-ED----"]=E["TP.DITCHED AIRCRAFT"],t["G-O-EP----"]=E["TP.PERSON IN WATER"],t["G-O-EV----"]=E["TP.DISTRESSED VESSEL"],t["G-O-HM----"]=E["TP.SEA MINELIKE"],I["G-O-HM----"]={x1:40,x2:160,y1:40,y2:150},t["G-O-HI----"]=E["TP.ICEBERG"],I["G-O-HI----"]={x1:50,x2:150,y1:50,y2:150},t["G-O-HO----"]=E["TP.OIL RIG/PLATFORM"],I["G-O-HO----"]={x1:30,x2:170,y1:60,y2:140},t["G-O-SB----"]=E["TP.BOTTOM RETURN"],I["G-O-SB----"]={x1:40,x2:160,y1:40,y2:100},t["G-O-SBM---"]=E["TP.INSTALLATION/MANMADE"],I["G-O-SBM---"]={x1:40,x2:160,y1:40,y2:100},t["G-O-SBN---"]=E["TP.BOTTOM RETURN"],I["G-O-SBN---"]={x1:40,x2:160,y1:40,y2:100},t["G-O-SBW---"]=E["TP.WRECK, NON DANGEROUS"],I["G-O-SBW---"]={x1:40,x2:160,y1:70,y2:130},t["G-O-SBX---"]=E["TP.WRECK, DANGEROUS"],I["G-O-SBX---"]={x1:40,x2:160,y1:70,y2:130},t["G-O-SM----"]=E["TP.MARINE LIFE"],I["G-O-SM----"]={x1:100,x2:220,y1:70,y2:130},t["G-O-SS----"]=E["TP.SEA ANOMALY"],I["G-O-SS----"]={x1:50,x2:150,y1:30,y2:120},t["G-O-FA----"]=E["TP.FIX ACOUSTIC"],t["G-O-FE----"]=E["TP.FIX ELECTRO-MAGNETIC"],t["G-O-FO----"]=E["TP.FIX ELECTRO-OPTICAL"]}};var _=[I,S,O,i,M,G,n,h,c,y,{type:"letter",getMetadata:e,getIcons:R,iconParts:[function(t,I,E,e,R,C){var I=I.affiliation||"Friend",A=E.iconColor[I],T={"2525B.ASWSUB":{type:"path",d:"m 80,85 40,0 0,-20 -40,0 z m 20,-30 0,40 m -40,15 15,15 50,0 15,-15 -15,-15 -50,0 z"},"2525B.NCBTT.STN":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:135,fontsize:30,text:"NC"}],"2525B.STN.ASWSHP":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:135,fontsize:30,text:"AS"}],"2525B.STN.PKT":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:135,fontsize:30,text:"PK"}],"2525B.STN.RSC":[{type:"path",fill:!1,d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:135,fontsize:30,text:"RS"}],"2525B.STN":{type:"path",fill:!1,d:"m 70,85 c 20,0 40,0 60,0 0,10 0,20 0,30 -20,0 -40,0 -60,0 0,-10 0,-20 0,-30 z m 30,-15 c 0,20 0,40 0,60 m 35,-5 C 120,148 82.7,149 66.8,126 49.2,105 59.1,69.2 85.2,60.1 103,53.1 124,59.4 135,74.8"},"2525B.SUB.STN":[{type:"path",d:"m 70,85 60,0 0,30 -60,0 z m 30,-15 0,60"},{type:"text",alignmentBaseline:"middle",stroke:!1,x:100,y:135,fontsize:30,text:"SS"}]};for(const S in T)T.hasOwnProperty(S)&&(t.hasOwnProperty(S)&&console.warn("Override of: "+S),s.call(this,T[S],A),t[S]=T[S])}],icons:function(t,I,E,e){t["S-S-S-----"]=E["2525B.STN"],t["S-S-SP----"]=E["2525B.STN.PKT"],t["S-S-SA----"]=E["2525B.STN.ASWSHP"],t["S-S-NN----"]=E["2525B.NCBTT.STN"],t["S-S-NNR---"]=E["2525B.STN.RSC"],t["S-U-SS----"]=E["2525B.SUB.STN"],t["S-U-SSA---"]=E["2525B.ASWSUB"],t["G-O-SBWD--"]=E["TP.WRECK, DANGEROUS"],I["G-O-SBXD--"]={x1:35,x2:165,y1:70,y2:130}}},x],c=[I,S,O,i,M,G,n,h,c,y,{type:"letter",getMetadata:e,getIcons:R,iconParts:[N,d],icons:function(t,I,E,e){t["E-I-A-----"]=[E["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]],t["E-I-AC----"]=[E["ST.IC.GROUP"],E["AC.M1.RIOT"]],t["E-I-B-----"]=[E["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]],t["E-I-BA----"]=[E["ST.IC.BOMB"],E["AC.M1.THREAT"]],t["E-I-BC----"]=[E["ST.IC.EXPLOSION"],L._scale(.6,E["ST.IC.BOMB"])],t["E-I-BD----"]=[E["ST.IC.GROUP"],E["ST.M1.LOOT"]],t["E-I-BF----"]=[E["AC.IC.SHOOTING"]],t["E-I-C-----"]=[E["AC.IC.FIRE EVENT"]],t["E-I-CA----"]=[E["AC.IC.HOT SPOT"]],t["E-I-CB----"]=[E["AC.IC.NON-REsIdENTIAL FIRE"]],t["E-I-CC----"]=[E["AC.IC.FIRE ORIGIN"]],t["E-I-CD----"]=[E["AC.IC.REsIdENTIAL FIRE"]],t["E-I-CE----"]=[E["AC.IC.SCHOOL FIRE"]],t["E-I-CF----"]=[E["AC.IC.SMOKE"]],t["E-I-CG----"]=[E["AC.IC.SPECIAL NEEDS FIRE"]],t["E-I-CH----"]=[E["AC.IC.WILD FIRE"]],t["E-I-D-----"]=[E["AC.IC.HAZARDOUS MATERIALS INCIDENT"]],t["E-I-DA----"]=[E["AC.IC.CHEMICAL AGENT"]],t["E-I-DB----"]=[E["AC.IC.CORROSIVE MATERIAL"]],t["E-I-DC----"]=[E["AC.IC.HAZARDOUS WHEN WET"]],t["E-I-DD----"]=[E["AC.IC.EXPLOSIVE MATERIAL"]],t["E-I-DE----"]=[E["AC.IC.FLAMMABLE GAS"]],t["E-I-DF----"]=[E["AC.IC.FLAMMABLE LIQUID"]],t["E-I-DG----"]=[E["AC.IC.FLAMMABLE SOLID"]],t["E-I-DH----"]=[E["AC.IC.NON-FLAMMABLE GAS"]],t["E-I-DI----"]=[E["AC.IC.ORGANIC PEROXIDE"]],t["E-I-DJ----"]=[E["AC.IC.OXIDIZER"]],t["E-I-DK----"]=[E["AC.IC.RADIOACTIVE MATERIAL"]],t["E-I-DL----"]=[E["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]],t["E-I-DM----"]=[E["AC.IC.TOXIC GAS"]],t["E-I-DN----"]=[E["AC.IC.TOXIC INFECTIOUS MATERIAL"]],t["E-I-DO----"]=[E["AC.IC.UNEXPLODED ORDNANCE"]],t["E-I-E-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.HIJACKING (AIRPLANE)"]],t["E-I-EA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.HIJACKING (AIRPLANE)"]],t["E-I-F-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.HIJACKING (BOAT)"]],t["E-I-FA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.HIJACKING (BOAT)"]],t["E-I-G-----"]=[E["ST.M1.INCIDENT"],E["GR.EQ.TRAIN LOCOMOTIVE"]],t["E-I-GA----"]=[E["ST.M1.ACCIDENT"],E["GR.EQ.TRAIN LOCOMOTIVE"]],t["E-I-GB----"]=[E["GR.EQ.TRAIN LOCOMOTIVE"],E["ST.M1.HIJACKING/HIJACKED"]],t["E-I-H-----"]=[E["ST.M1.INCIDENT"],E["ST.IC.KNOWN INSURGENT VEHICLE"]],t["E-I-HA----"]=[E["ST.M1.ACCIDENT"],E["ST.IC.KNOWN INSURGENT VEHICLE"]],t["E-N-A-----"]=[],t["E-N-AA----"]=[E["AC.IC.AFTERSHOCK"]],t["E-N-AB----"]=[E["AC.IC.AVALANCHE"]],t["E-N-AC----"]=[E["AC.IC.EARTHQUAKE EPICENTER"]],t["E-N-AD----"]=[E["AC.IC.LANDSLIDE"]],t["E-N-AE----"]=[E["AC.IC.SUBSIDENCE"]],t["W-S-WSVE--"]=[E["AC.IC.VOLCANIC ERUPTION"]],t["E-N-AG----"]=[E["AC.IC.VOLCANIC THREAT"]],t["W-S-WSD-LI"]=[E["ATMOSPHERIC.IC.DRIZZLE.INTERMITTENT LIGHT"]],t["E-N-B-----"]=[],t["E-N-BB----"]=[E["AC.IC.DROUGHT"]],t["E-N-BC----"]=[E["AC.IC.FLOOD"]],t["W-S-WSFGSO"]=[E["ATMOSPHERIC.IC.FOG.SKY OBSCURED"]],t["W-S-WSGRL-"]=[E["ATMOSPHERIC.IC.HAIL.LIGHT NOT ASSOCIATED WITH THUNDER"]],t["E-N-BF----"]=[E["AC.IC.INVERSION"]],t["W-S-WSR-LI"]=[E["ATMOSPHERIC.IC.RAIN.INTERMITTENT LIGHT"]],t["W-S-WSDSLM"]=[E["ATMOSPHERIC.IC.DUST OR SAND.LIGHT TO MODERATE"]],t["W-S-WSS-LI"]=[E["ATMOSPHERIC.IC.SNOW.INTERMITTENT LIGHT"]],t["W-S-WSTMH-"]=[E["ATMOSPHERIC.IC.STORMS.THUNDERSTORM LIGHT TO MODERATE - WITH HAIL"]],t["W-S-WST-FC"]=[E["ATMOSPHERIC.IC.STORMS.FUNNEL CLOUD (TORNADO/WATERSPOUT)"]],t["W-S-WSTSS-"]=[E["ATMOSPHERIC.IC.TROPICAL STORM SYSTEMS.TROPICAL STORM"]],t["E-N-BM----"]=[E["AC.IC.TSUNAMI"]],t["E-N-C-----"]=[],t["E-N-CA----"]=[E["AC.IC.BIRD"]],t["E-N-CB----"]=[E["AC.IC.INSECT"]],t["E-N-CC----"]=[E["AC.IC.MICROBIAL"]],t["E-N-CD----"]=[E["AC.IC.REPTILE"]],t["E-N-CE----"]=[E["AC.IC.RODENT"]],t["E-O-A-----"]=t["E-O-AA----"]=t["E-O-AB----"]=t["E-O-AC----"]=t["E-O-AD----"]=[E["GR.IC.EMERGENCY MEDICAL OPERATION"]],t["E-O-AE----"]=[E["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],E["GR.M1.MEDEVAC"]],t["E-O-AF----"]=[L._translate(0,10,L._scale(.8,E["GR.I.FF.CIVILIAN ROTARY WING"])),E["GR.M1.MEDEVAC"]],t["E-O-AG----"]=[E["AC.IC.HEALTH DEPARTMENT FACILITY"]],t["E-O-AJ----"]=[E["AC.IC.MEDICAL FACILITIES OUTPATIENT"]],t["E-O-AK----"]=[E["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]],t["E-O-AL----"]=[E["AC.IC.PHARMACY"]],t["E-O-AM----"]=[E["AC.IC.TRIAGE"]],t["E-O-B-----"]=t["E-O-BA----"]=t["E-O-BB----"]=t["E-O-BC----"]=[E["GR.IC.FF.EMERGENCY OPERATION"]],t["E-O-BD----"]=[L._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]],t["E-O-BE----"]=[L._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]],t["E-O-BF----"]=[L._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY OPERATIONS CENTER"]],t["E-O-BG----"]=[E["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]],t["E-O-BH----"]=[L._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY SHELTER"]],t["E-O-BI----"]=[L._scale(.7,E["GR.IC.FF.EMERGENCY OPERATION"]),E["AC.M1.EMERGENCY STAGING AREA"]],t["E-O-BJ----"]=[E["GR.IC.FF.EMERGENCY OPERATION"]],t["E-O-BK----"]=t["S-G-USSW--"],t["E-O-BL----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.EMERGENCY"]],t["E-O-C-----"]=t["E-O-CA----"]=t["E-O-CB----"]=t["E-O-CE----"]=[E["GR.IC.FIRE PROTECTION"]],t["E-O-CC----"]=[E["AC.IC.FIRE HYDRANT"]],t["E-O-CD----"]=[E["AC.IC.OTHER WATER SUPPLY LOCATION"]],t["E-O-D-----"]=t["E-O-DA----"]=t["E-O-DB----"]=t["E-O-DC----"]=[E["GR.IC.FF.LAW ENFORCEMENT"]],t["E-O-DD----"]=t["E-O-DDA---"]=t["E-O-DDB---"]=t["E-O-DDC---"]=[E["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],t["E-O-DE----"]=t["E-O-DEA---"]=t["E-O-DEB---"]=t["E-O-DEC---"]=[E["GR.IC.FF.BORDER PATROL"]],t["E-O-DF----"]=t["E-O-DFA---"]=t["E-O-DFB---"]=t["E-O-DFC---"]=[E["GR.IC.FF.CUSTOMS SERVICE"]],t["E-O-DG----"]=t["E-O-DGA---"]=t["E-O-DGB---"]=t["E-O-DGC---"]=[E["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],t["E-O-DH----"]=t["E-O-DHA---"]=t["E-O-DHB---"]=t["E-O-DHC---"]=[E["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],t["E-O-DI----"]=t["E-O-DIA---"]=t["E-O-DIB---"]=t["E-O-DIC---"]=[E["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],t["E-O-DJ----"]=t["E-O-DJB---"]=t["E-O-DJC---"]=[E["GR.IC.LAW ENFORCEMENT"]],t["E-O-DK----"]=[E["GR.IC.FF.PRISON"]],t["E-O-DL----"]=t["E-O-DLA---"]=t["E-O-DLB---"]=t["E-O-DLC---"]=[E["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],t["E-O-DM----"]=t["E-O-DMA---"]=t["E-O-DMB---"]=t["E-O-DMC---"]=[E["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],t["E-O-DN----"]=t["E-O-DNA---"]=t["E-O-DNC---"]=[E["GR.IC.LAW ENFORCEMENT VESSEL"]],t["E-O-DO----"]=t["E-O-DOA---"]=t["E-O-DOB---"]=t["E-O-DOC---"]=[E["GR.IC.FF.US MARSHALS SERVICE"]],t["E-O-EA----"]=[L._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.BIOLOGICAL"]],t["E-O-EB----"]=[L._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.CHEMICAL"]],t["E-O-EC----"]=[L._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.INTRUSION"]],t["E-O-ED----"]=[L._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.NUCLEAR"]],t["E-O-EE----"]=[L._scale(.6,E["GR.EQ.SENSOR"]),E["GR.M1.RADIOLOGICAL"]],t["E-F-A-----"]=[E["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]],t["E-F-AA----"]=[E["GR.IN.IC.AGRICULTURAL LABORATORY"]],t["E-F-AB----"]=[E["GR.IN.IC.ANIMAL FEEDLOT"]],t["E-F-AC----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.COMMERCIAL"]],t["E-F-AD----"]=[E["GR.IN.IC.FARM/RANCH"]],t["E-F-AE----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.PRODUCTION"]],t["E-F-AF----"]=[E["ST.IC.FOOD DISTRIBUTION"],E["AC.M1.RETAIL"]],t["E-F-AG----"]=[E["GR.IN.IC.GRAIN STORAGE"]],t["E-F-B-----"]=[E["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]],t["E-F-BA----"]=[E["GR.IN.IC.ATM"]],t["E-F-BB----"]=[E["GR.IN.IC.BANK"]],t["E-F-BC----"]=[E["GR.IN.IC.BULLION STORAGE"]],t["E-F-BD----"]=[E["GR.IN.IC.FEDERAL RESERVE BANK"]],t["E-F-BE----"]=[E["GR.IN.IC.FINANCIAL EXCHANGE"]],t["E-F-BF----"]=[E["GR.IN.IC.FINANCIAL SERVICES, OTHER"]],t["E-F-C-----"]=[E["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]],t["E-F-CA----"]=[E["GR.IN.IC.CHEMICAL PLANT"]],t["E-F-CB----"]=[E["GR.IN.IC.FIREARMS MANUFACTURER"]],t["E-F-CC----"]=[E["GR.IN.IC.FIREARMS RETAILER"]],t["E-F-CD----"]=[E["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]],t["E-F-CE----"]=[E["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]],t["E-F-CF----"]=[E["GR.IN.IC.INDUSTRIAL SITE"]],t["E-F-CG----"]=[E["GR.IN.IC.LANDFILL"]],t["E-F-CH----"]=[E["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]],t["E-F-CI----"]=[E["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]],t["E-F-CJ----"]=[E["GR.IN.IC.TOXIC RELEASE INVENTORY"]],t["E-F-D-----"]=[E["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]],t["E-F-DA----"]=[E["GR.IN.IC.COLLEGE/UNIVERSITY"]],t["E-F-DB----"]=[E["GR.IN.IC.SCHOOL"]],t["E-F-EA----"]=[L._translate(0,15,L._scale(.75,E["GR.IN.IC.ELECTRIC POWER"],!0)),E["AC.M1.GENERATION STATION"]],t["E-F-EB----"]=[E["GR.IN.IC.NATURAL GAS FACILITY"]],t["E-F-EE----"]=[E["GR.IN.IC.PROPANE FACILITY"]],t["E-F-F-----"]=[E["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]],t["E-F-G-----"]=[E["GR.IN.IC.MILITARY INFRASTRUCTURE"]],t["E-F-GA----"]=[E["GR.IN.IC.BASE"],E["AC.M1.MILITARY ARMORY"]],t["E-F-H-----"]=[E["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]],t["E-F-HA----"]=[E["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]],t["E-F-HB----"]=[E["GR.IN.IC.POST OFFICE"]],t["E-F-I-----"]=[E["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]],t["E-F-IA----"]=[E["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]],t["E-F-IB----"]=[E["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]],t["E-F-IC----"]=[E["GR.IN.IC.RECREATIONAL AREA"]],t["E-F-ID----"]=[E["GR.IN.IC.RELIGIOUS INSTITUTION"]],t["E-F-J-----"]=[E["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]],t["E-F-JA----"]=[E["GR.IN.IC.ADULT DAY CARE"]],t["E-F-JB----"]=[E["GR.IN.IC.CHILD DAY CARE"]],t["E-F-JC----"]=[E["GR.IN.IC.ELDER CARE"]],t["E-F-K-----"]=[E["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]],t["E-F-KB----"]=[E["GR.IN.IC.TELECOMMUNICATIONS TOWER"]],t["E-F-LA----"]=[E["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]],t["G-M-BCB---"]=[E["GR.IN.IC.BRIDGE"]],I["G-M-BCB---"]={x1:50,x2:150,y1:50,y2:150},t["E-F-LD----"]=[E["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],t["E-F-LE----"]=[E["GR.IC.FERRY"]],t["E-F-LF----"]=[E["GR.IN.IC.HELICOPTER LANDING SITE"]],t["W-S-ML----"]=[E["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE LOCK"]],t["E-F-LH----"]=[E["GR.IC.MAINTENANCE"]],t["E-F-LJ----"]=[E["GR.IC.RAILHEAD"]],t["E-F-LK----"]=[E["GR.IN.IC.REST STOP"]],t["W-S-HPBA--"]=[E["GR.IN.IC.TRANSPORTATION INFRASTRUCTURE SHIP ANCHORAGE"]],t["E-F-LM----"]=[E["GR.IN.IC.TOLL FACILITY"]],t["G-S-PO----"]=E["TP.TRAFFIC CONTROL POST"],I["G-S-PO----"]={x1:60,x2:140,y1:-60},t["E-F-LO----"]=[E["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]],t["E-F-LP----"]=[E["GR.IN.IC.TUNNEL"]],t["E-F-MA----"]=[E["GR.IN.IC.CONTROL VALVE"]],t["E-F-MB----"]=[E["GR.IN.IC.DAM"]],t["E-F-MC----"]=[E["GR.IN.IC.DISCHARGE OUTFALL"]],t["E-F-MD----"]=[E["GR.IN.IC.GROUND WATER WELL"]],t["E-F-ME----"]=[E["GR.IN.IC.PUMPING STATION"]],t["E-F-MF----"]=[E["GR.IN.IC.RESERVOIR"]],t["E-F-MG----"]=[E["GR.IN.IC.STORAGE TOWER"]],t["E-F-MH----"]=[E["GR.IN.IC.SURFACE WATER INTAKE"]],t["E-F-MI----"]=[E["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]],t["O-O-D-----"]=[E["ST.IC.DEMONSTRATION"]],t["O-I-R-----"]=[E["ST.IC.GROUP"]],t["O-V-B-----"]=[E["ST.IC.BOMB"]],t["O-V-P-----"]=[E["ST.IC.POISONING"]],t["O-O-HA----"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],t["O-O-HV----"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],t["O-O-HT----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],t["S-G-IXH---"]=[E["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t["S-S-NM----"]=[E["GR.IC.HOSPITAL SHIP"]],t["E-O-BK----"]=[E["GR.IC.FF.SUPPLY"],E["GR.IC.WATER"]],t["S-G-UULC--"]=[E["GR.IC.LAW ENFORCEMENT"]],t["S-S-XL----"]=[E["GR.IC.LAW ENFORCEMENT VESSEL"]],t["S-G-ES----"]=[E["GR.EQ.SENSOR"]],t["S-G-IUE---"]=[E["GR.IN.IC.ELECTRIC POWER"]],t["S-G-IUEN--"]=[E["GR.IN.IC.ELECTRIC POWER"],E["GR.IN.IC.ELECTRIC POWER NUCLEAR"]],t["S-G-IRP---"]=[E["GR.IC.FF.CLASS III"]],t["S-G-IB----"]=[E["GR.IN.IC.BASE"]],t["S-G-IUT---"]=[E["GR.IN.IC.TELECOMMUNICATIONS"]],t["S-G-IT----"]=[E["GR.IC.TRANSPORTATION"]],t["S-G-IBA---"]=[E["GR.IC.TRANSPORTATION"],E["GR.IC.AIRPORT OF DEBARKATION"]],t["S-G-IBN---"]=[E["GR.IC.NAVAL"]],t["S-G-IUP---"]=[E["GR.IC.WATER"]]}},x];function m(t,I,E){var e=this.options.sidc.substr(0,2),R=this.options.sidc.substr(2,1),C=this.options.sidc.substr(3,1),A=this.options.sidc.substr(4,2),T=this.options.sidc.substr(6,1),S=this.options.sidc.substr(7,1),N=this.options.sidc.substr(8,2),O=this.options.sidc.substr(22,1)||"0",e=("10"!=e&&"11"!=e&&"12"!=e||(I.edition="D"),"13"!=e&&"14"!=e||(I.edition="E"),13==e&&5==C&&(I.suspect=!0),I.functionid=this.options.sidc.substr(10,10));if(I._modifier1=(this.options.sidc.substr(20,1)||"0")+(e.substr(6,2)||"00"),I._modifier2=(this.options.sidc.substr(21,1)||"0")+(e.substr(8,2)||"00"),I.context=E.context[parseInt(this.options.sidc.substr(2,1))],I.affiliation={0:"Unknown",1:"Unknown",2:"Friend",3:"Friend",4:"Neutral",5:"Hostile",6:"Hostile"}[C],I.dimension={"00":"Sea","01":"Air","02":"Air","05":"Air","06":"Air",10:"Ground",11:"Ground",12:"Ground",15:"Ground",20:"Ground",30:"Sea",35:"Subsurface",36:"Subsurface",39:"Subsurface",40:"Ground",50:"Air",51:"Air",52:"Ground",53:"Sea",54:"Subsurface",60:"Ground"}[A]||"","10"!=A&&"11"!=A&&"25"!=A&&"27"!=A&&"40"!=A||(I.unit=!0),"05"!=A&&"06"!=A&&"50"!=A||(I.space=!0),"40"==A&&(I.activity=!0),"15"==A&&(I.landequipment=!0),"20"==A&&(I.installation=!0),"25"==A&&(I.controlMeasure=!0),"60"==A&&(I.cyberspace=!0),"36"==A&&!1===this.style.alternateMedal&&(I.fill=!1),"30"==A&&15e4==e.substr(0,6)&&(I.frame=!1),"1"==T&&(I.notpresent=t._dashArrays.anticipated),"0"!=C&&"2"!=C&&"5"!=C||(I.notpresent=t._dashArrays.pending),"30"==A&&16e4==e.substr(0,6)&&(I.notpresent=t._dashArrays.pending),"35"==A&&14e4==e.substr(0,6)&&(I.notpresent=t._dashArrays.pending),"35"==A&&15e4==e.substr(0,6)&&(I.notpresent=t._dashArrays.pending),"2"!=T&&"3"!=T&&"4"!=T&&"5"!=T||(I.condition=E.status[parseInt(T)]),I.baseDimension=I.dimension,I.baseAffilation=I.affiliation,"5"==C&&"1"==R&&(I.joker=!0),"6"==C&&"1"==R&&(I.faker=!0),(I.joker||I.faker)&&(I.affiliation=E.affiliation[1]),"00"==A&&(I.dimensionUnknown=!0),"00"==A&&"1"==R&&"Unknown"!=I.affiliation&&(I.affiliation=""),"27"==A&&(I.dimension="LandDismountedIndividual",I.dismounted=!0),"15"!=A&&"52"!=A||(I.dimension=E.dimension[2]),("01"==A&&"12"==e.substring(0,2)||"05"==A&&"12"==e.substring(0,2)||"11"==A||"12"==A&&"12"==e.substring(0,2)||"15"==A&&"16"==e.substring(0,2)||"30"==A&&"14"==e.substring(0,2)||"35"==A&&"12"==e.substring(0,2))&&(I.civilian=!0),"0"!=O)switch(I.civilian=!1,I.cyberspace=!1,I.installation=!1,I.landequipment=!1,I.activity=!1,I.space=!1,I.unit=!1,I.cyberspace=!1,O){case"1":I.dimension="Air",I.space=!0;break;case"2":I.dimension="Air";break;case"3":I.dimension="Ground",I.unit=!0;break;case"4":I.dimension="Sea",I.landequipment=!0;break;case"5":I.dimension="Ground",I.installation=!0;break;case"6":I.dimension="LandDismountedIndividual",I.dismounted=!0;break;case"7":I.dimension="Subsurface";break;case"8":I.dimension="Ground",I.activity=!0,I.unit=!0;break;case"9":I.dimension="Ground",I.cyberspace=!1,I.unit=!0}return"A"==O&&(I.frame=!1),-1<["1","3","5","7"].indexOf(S)&&(I.feintDummy=!0),-1<["2","3","6","7"].indexOf(S)&&(I.headquarters=!0),-1<["4","5","6","7"].indexOf(S)&&(I.taskForce=!0),N<=30&&(I.echelon=E.echelonMobility[N]),30<=N&&N<70&&(I.mobility=E.echelonMobility[N]),70<=N&&N<80&&(I.leadership=E.echelonMobility[N]),I}function U(t,I,E,e,R){var C={},A={},T={},S={};for(const N in t._iconSIDC.number)t._iconSIDC.number.hasOwnProperty(N)&&t._iconSIDC.number[N].call(this,C,A,T,S,I,E,e,R);return{icons:C,m1:A,m2:T,bbox:S}}var y={type:"number",getMetadata:m,getIcons:U,iconParts:T,icons:function(t,I,E,e,R,C,A){"01"==R&&(t[11e4]=[C["AR.I.MILITARY"]],t[110100]=[C["AR.I.FIXED-WING DSymbol"]],t[110101]=[C["AR.I.MEDICAL EVACUATION"]],t[110102]=[C["AR.I.ATTACK/STRIKE"]],t[110103]=[C["AR.I.BOMBER"]],t[110104]=[C["AR.I.FIGHTER"]],t[110105]=[C["AR.I.FIGHTER/BOMBER"]],t[110106]=[],t[110107]=[C["AR.I.CARGO"]],t[110108]=[C["AR.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t[110109]=[C["AR.I.TANKER"]],t[110110]=[C["AR.I.PATROL"]],t[110111]=[C["AR.I.RECONNAISSANCE"]],t[110112]=[C["AR.I.TRAINER"]],t[110113]=[C["AR.I.UTILITY"]],t[110114]=[C["AR.I.VSTOL"]],t[110115]=[C["AR.I.AIRBORNE COMMAND POST"]],t[110116]=[C["AR.I.AIRBORNE EARLY WARNING"]],t[110117]=[C["AR.I.ANTISURFACE WARFARE"]],t[110118]=[C["AR.I.ANTISUBMARINE WARFARE"]],t[110119]=[C["AR.I.COMMUNICATIONS"]],t[110120]=[C["AR.I.COMBAT SEARCH AND RESCUE"]],t[110121]=[C["AR.I.ELECTRONIC SUPPORT"]],t[110122]=[C["AR.I.GOVERNMENT"]],t[110123]=[C["AR.I.MINE COUNTERMEASURES"]],t[110124]=[C["AR.I.PERSONNEL RECOVERY DSymbol"]],t[110125]=[C["AR.I.SEARCH AND RESCUE"]],t[110126]=[C["AR.I.SPECIAL OPERATIONS FORCES"]],t[110127]=[C["AR.I.ULTRA LIGHT"]],t[110128]=[C["AR.I.PHOTOGRAPHIC RECONNAISSANCE"]],t[110129]=[C["AR.I.VIP"]],t[110130]=[C["AR.I.SUPRESSION OF ENEMY AIR DEFENCE"]],t[110131]=[C["AR.I.PASSENGER"]],t[110132]=[C["AR.I.ESCORT"]],t[110133]=[C["AR.I.ELECTRONIC ATTACK (EA)"]],t[110200]=[C["AR.I.MILITARY ROTARY WING"]],t[110300]=[C["AR.I.UNMANNED AERIAL VEHICLE"]],t[110400]=[C["AR.I.VERTICAL-TAKEOFF UAV (VT-UAV)"]],t[110500]=[C["AR.I.MILITARY BALLOON"]],t[110600]=[C["AR.I.MILITARY AIRSHIP"]],t[110700]=[C["AR.I.TETHERED LIGHTER THAN AIR"]],t[12e4]=[C["AR.I.CIVILIAN"]],t[120100]=[C["AR.I.CIVILIAN FIXED-WING DSymbol"]],t[120200]=[C["AR.I.CIVILIAN ROTARY WING"]],t[120300]=[C["AR.I.CIVILIAN UNMANNED AERIAL VEHICLE"]],t[120400]=[C["AR.I.CIVILIAN BALLOON"]],t[120500]=[C["AR.I.CIVILIAN AIRSHIP"]],t[120600]=[C["AR.I.CIVILIAN TETHERED LIGHTER THAN AIR"]],t[120700]=[C["AR.I.CIVILIAN MEDICAL EVACUATION"]],t[13e4]=[C["AR.I.WEAPON"]],t[130100]=[C["AR.I.BOMB"]],t[130200]=[C["AR.I.UNDERWATER DECOY DSymbol"]],t[14e4]=[C["AR.I.MANUAL TRACK"]],I["01"]=[C["AIR.M1.ATTACK"]],I["02"]=[C["AIR.M1.BOMBER"]],I["03"]=[C["AIR.M1.CARGO"]],I["04"]=[C["AIR.M1.FIGHTER"]],I["05"]=[C["AIR.M1.INTERCEPTOR"]],I["06"]=[C["AIR.M1.TANKER"]],I["07"]=[C["AIR.M1.UTILITY"]],I["08"]=[C["AIR.M1.VSTOL"]],I["09"]=[C["AIR.M1.PASSENGER"]],I[10]=[C["AIR.M1.ULTRA LIGHT"]],I[11]=[C["AIR.M1.AIRBORNE COMMAND POST"]],I[12]=[C["AIR.M1.AIRBORNE EARLY WARNING"]],I[13]=[C["AIR.M1.GOVERNMENT"]],I[14]=[C["AIR.M1.MEDEVAC"]],I[15]=[C["AIR.M1.ESCORT"]],I[16]=[C["AIR.M1.JAMMER / ELECTRONIC COUNTER-MEASURES"]],I[17]=[C["AIR.M1.PATROL"]],I[18]=[C["AIR.M1.RECONNAISSANCE"]],I[19]=[C["AIR.M1.TRAINER"]],I[20]=[C["AIR.M1.PHOTOGRAPHIC"]],I[21]=[C["AIR.M1.PERSONNEL RECOVERY"]],I[22]=[C["AIR.M1.ANTISUBMARINE WARFARE"]],I[23]=[C["AIR.M1.COMMUNICATIONS"]],I[24]=[C["AIR.M1.ELECTRONIC SUPPORT (ES)"]],I[25]=[C["AIR.M1.MINE COUNTERMEASURES"]],I[26]=[C["AIR.M1.SEARCH AND RESCUE"]],I[27]=[C["AIR.M1.SPECIAL OPERATIONS FORCES"]],I[28]=[C["AIR.M1.SURFACE WARFARE"]],I[29]=[C["AIR.M1.VIP"]],I[30]=[C["AIR.M1.COMBAT SEARCH AND RESCUE"]],I[31]=[C["AIR.M1.SUPRESSION OF ENEMY AIR DEFENCE"]],I[32]=[C["AIR.M1.ANTISURFACE WARFARE"]],I[33]=[C["AIR.M1.FIGHTER/BOMBER"]],I[34]=[C["AIR.M1.INTENSIVE CARE"]],I[35]=[C["AIR.M1.ELECTRONIC ATTACK (EA)"]],I[36]=[C["AIR.M1.MULTIMISSION"]],I[37]=[C["AIR.M1.HIJACKING"]],I[38]=[C["AIR.M1.ASW HELO-LAMPS"]],I[39]=[C["AIR.M1.ASW HELO - SH-60R"]],I[40]=[C["AIR.M1.HIJACKER"]],I[41]=[C["AIR.M1.CYBERSPACE"]],E["01"]=[C["AIR.M2.HEAVY"]],E["02"]=[C["AIR.M2.MEDIUM"]],E["03"]=[C["AIR.M2.LIGHT"]],E["04"]=[C["AIR.M2.BOOM-ONLY"]],E["05"]=[C["AIR.M2.DROUGE-ONLY"]],E["06"]=[C["AIR.M2.BOOM AND DROUGE"]],E["07"]=[C["AIR.M2.CLOSE RANGE"]],E["08"]=[C["AIR.M2.SHORT RANGE"]],E["09"]=[C["AIR.M2.MEDIUM RANGE"]],E[10]=[C["AIR.M2.LONG RANGE"]],E[11]=[C["AIR.M2.DOWNLINKED"]],E[12]=[C["AIR.M2.CYBERSPACE"]])}},x={type:"number",getMetadata:m,getIcons:U,iconParts:T,icons:function(t,I,E,e,R,C,A){"02"==R&&(t[11e4]=[C["AIR.MISSILE.ICON"]],I["01"]=[C["AIR.MISSILE.M1.AIR"]],I["02"]=[C["AIR.MISSILE.M1.SURFACE"]],I["03"]=[C["AIR.MISSILE.M1.SUBSURFACE"]],I["04"]=[C["AIR.MISSILE.M1.SPACE"]],I["05"]=[C["AIR.MISSILE.M1.ANTI-BALLISTIC"]],I["06"]=[C["AIR.MISSILE.M1.BALLISTIC"]],I["07"]=[C["AIR.MISSILE.M1.CRUISE"]],I["08"]=[C["AIR.MISSILE.M1.INTERCEPTOR"]],I["09"]=[C["AIR.M1.HYPERSONIC"]],E["01"]=[C["AIR.MISSILE.M2.AIR"]],E["02"]=[C["AIR.MISSILE.M2.SURFACE"]],E["03"]=[C["AIR.MISSILE.M2.SUBSURFACE"]],E["04"]=[C["AIR.MISSILE.M2.SPACE"]],E["05"]=[C["AIR.MISSILE.M2.LAUNCHED"]],E["06"]=[C["AIR.MISSILE.M2.MISSILE"]],E["07"]=[C["AIR.MISSILE.M2.PATRIOT"]],E["08"]=[C["AIR.MISSILE.M2.STANDARD MISSILE - 2 (SM-2)"]],E["09"]=[C["AIR.MISSILE.M2.STANDARD MISSILE - 6 (SM-6)"]],E[10]=[C["AIR.MISSILE.M2.EVOLVED SEA SPARROW MISSILE (ESSM)"]],E[11]=[C["AIR.MISSILE.M2.ROLLING AIRFRAME MISSILE (RAM)"]],E[12]=[C["AIR.MISSILE.M2.SHORT RANGE"]],E[13]=[C["AIR.MISSILE.M2.MEDIUM RANGE"]],E[14]=[C["AIR.MISSILE.M2.INTERMEDIATE RANGE"]],E[15]=[C["AIR.MISSILE.M2.LONG RANGE"]],E[16]=[C["AIR.MISSILE.M2.INTERCONTINENTAL"]])}},p={type:"number",getMetadata:m,getIcons:U,iconParts:A,icons:function(t,I,E,e,R,C,A){"05"==R&&(t[11e4]=[C["SP.I.MILITARY"]],t[110100]=[C["SP.I.SPACE VEHICLE"]],t[110200]=[C["SP.I.RE-ENTRY VEHICLE"]],t[110300]=[C["SPACE.PLANET LANDER"]],t[110400]=[C["SP.I.ORBITER SHUTTLE"]],t[110500]=[C["SP.I.CAPSULE"]],t[110600]=[C["SP.I.SATELLITE, GENERAL"]],t[110700]=[C["SP.I.SATELLITE"]],t[110800]=[C["SP.I.ANTISATELLITE WEAPON"]],t[110900]=[C["SP.I.ASTRONOMICAL SATELLITE"]],t[111e3]=[C["SP.I.BIOSATELLITE"]],t[111100]=[C["SP.I.COMMUNICATIONS SATELLITE"]],t[111200]=[C["SP.I.EARTH OBSERVATION SATELLITE"]],t[111300]=[C["SP.I.MINIATURIZED SATELLITE"]],t[111400]=[C["SP.I.NAVIGATIONAL SATELLITE"]],t[111500]=[C["SP.I.RECONNAISSANCE SATELLITE"]],t[111600]=[C["SP.I.SPACE STATION"]],t[111700]=[C["SP.I.TETHERED SATELLITE"]],t[111800]=[C["SP.I.WEATHER SATELLITE"]],t[111900]=[C["SP.I.SPACE LAUNCH VEHICLE"]],t[12e4]=[C["SP.I.CIVILIAN"]],t[120100]=[C["SP.I.CIVILIAN ORBITER SHUTTLE"]],t[120200]=[C["SP.I.CIVILIAN CAPSULE"]],t[120300]=[C["SP.I.CIVILIAN SATELLITE"]],t[120400]=[C["SP.I.CIVILIAN ASTRONOMICAL SATELLITE"]],t[120500]=[C["SP.I.CIVILIAN BIOSATELLITE"]],t[120600]=[C["SP.I.CIVILIAN COMMUNICATIONS SATELLITE"]],t[120700]=[C["SP.I.CIVILIAN EARTH OBSERVATION SATELLITE"]],t[120800]=[C["SP.I.CIVILIAN MINIATURIZED SATELLITE"]],t[120900]=[C["SP.I.CIVILIAN NAVIGATIONAL SATELLITE"]],t[121e3]=[C["SP.I.CIVILIAN SPACE STATION"]],t[121100]=[C["SP.I.CIVILIAN TETHERED SATELLITE"]],t[121200]=[C["SP.I.CIVILIAN WEATHER SATELLITE"]],t[121300]=[C["SP.I.PLANETARY LANDER"]],t[121400]=[C["SP.I.CIVILIAN SPACE VEHICLE"]],t[13e4]=[C["SP.I.MANUAL TRACK"]],I["01"]=[C["SP.M1.LOW EARTH ORBIT (LEO)"]],I["02"]=[C["SP.M1.MEDIUM EARTH ORBIT (MEO)"]],I["03"]=[C["SP.M1.HIGH EARTH ORBIT (HEO)"]],I["04"]=[C["SP.M1.GEOSYNCHRONOUS ORBIT (GSO)"]],I["05"]=[C["SP.M1.GEOSTATIONARY ORBIT (GO)"]],I["06"]=[C["SP.M1.MOLNIYA ORBIT (MO)"]],I["07"]=[C["SP.M1.CYBERSPACE"]],E["01"]=[C["SP.M2.OPTICAL"]],E["02"]=[C["SP.M2.INFRARED"]],E["03"]=[C["SP.M2.RADAR"]],E["04"]=[C["SP.M2.SIGNALS INTELLIGENCE (SIGINT)"]],E["05"]=[C["SP.M2.CYBERSPACE"]],E["06"]=[C["SP.M2.ELECTROMAGNETIC WARFARE (ASAT)"]],E["07"]=[C["SP.M2.HIGH POWER MICROWAVE"]],E["08"]=[C["SP.M2.LASER"]],E["09"]=[C["SP.M2.MAINTENANCE"]],E[10]=[C["SP.M2.MINE"]],E[11]=[C["SP.M2.REFUEL"]],E[12]=[C["SP.M2.TUG"]])}},D={type:"number",getMetadata:m,getIcons:U,iconParts:A,icons:function(t,I,E,e,R,C,A){"06"==R&&(t[11e4]=[C["SPACE.MISSILE.ICON"]],I["01"]=[C["SPACE.MISSILE.M1.BALLISTIC"]],I["02"]=[C["SPACE.MISSILE.M1.SPACE"]],I["03"]=[C["SPACE.MISSILE.M1.INTERCEPTOR"]],I["04"]=[C["SPACE.MISSILE.M1.HYPERSONIC"]],E["01"]=[C["SPACE.MISSILE.M2.SHORT RANGE"]],E["02"]=[C["SPACE.MISSILE.M2.MEDIUM RANGE"]],E["03"]=[C["SPACE.MISSILE.M2.INTERMEDIATE RANGE"]],E["04"]=[C["SPACE.MISSILE.M2.LONG RANGE"]],E["05"]=[C["SPACE.MISSILE.M2.INTERCONTINENTAL"]],E["06"]=[C["SPACE.MISSILE.M2.ARROW"]],E["07"]=[C["SPACE.MISSILE.M2.GROUND-BASED INTERCEPTOR (GBI)"]],E["08"]=[C["SPACE.MISSILE.M2.PATRIOT"]],E["09"]=[C["SPACE.MISSILE.M2.STANDARD MISSILE - TERMINAL PHASE (SM-T)"]],E[10]=[C["SPACE.MISSILE.M2.STANDARD MISSILE - 3 (SM-3)"]],E[11]=[C["SPACE.MISSILE.M2.TERMINAL HIGH-ALTITUDE AREA DEFENSE (THAAD)"]],E[12]=[C["SPACE.MISSILE.M2.SPACE"]],E[13]=[C["SPACE.MISSILE.M2.CLOSE RANGE"]],E[14]=[C["SPACE.MISSILE.M2.DEBRIS"]],E[15]=[C["SPACE.MISSILE.M2.UNKNOWN"]])}},F={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A,T){"10"==R&&(t[11e4]=[C["GR.IC.COMMAND AND CONTROL"]],t[110100]=[C["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],t[110200]=[C["GR.IC.CIVIL AFFAIRS"]],t[110300]=[C["GR.IC.CIVIL-MILITARY-COOPERATION"]],t[110400]=[C["GR.IC.INFORMATION OPERATIONS"]],t[110500]=[C["GR.IC.LIAISON"]],t[110501]=[C["GR.IC.LIAISON"],C["GR.IC.FF.RECONNAISSANCE"]],t[110600]=[C["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"]],t[110601]=[C["GR.IC.MILITARY INFORMATION SUPPORT OPERATIONS (MISO)"],C["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],t[110700]=[C["GR.IC.RADIO"]],t[110800]=[C["GR.IC.RADIO RELAY"]],t[110900]=[C["GR.IC.RADIO TELETYPE CENTRE"]],t[111e3]=[C["GR.IC.FF.SIGNAL"]],t[111001]=[C["GR.IC.FF.SIGNAL"],C["GR.IC.RADIO"]],t[111002]=[C["GR.IC.FF.SIGNAL"],C["GR.IC.RADIO RELAY"]],t[111003]=[C["GR.IC.FF.SIGNAL"],C["GR.IC.RADIO TELETYPE CENTRE"]],t[111004]=[C["GR.IC.FF.SIGNAL"],C["GR.I.FF.SATELLITE"]],t[111005]=[C["GR.IC.FF.SIGNAL"],C["GR.IC.VIDEO IMAGERY"]],t[111100]=[C["GR.I.FF.SATELLITE"]],t[111200]=[C["GR.IC.VIDEO IMAGERY"]],t[111300]=[C["GR.IC.SPACE"]],t[111400]=[C["GR.IC.SPECIAL TROOPS"]],t[111500]=[C["GR.IC.MULTI-DOMAIN"]],t[12e4]=[],t[120100]=[C["GR.IC.FF.AIR ASSAULT WITH ORGANIC LIFT"]],t[120200]=[C["GR.IC.AIR TRAFFIC SERVICES"]],t[120300]=[C["GR.IC.FF.AMPHIBIOUS"]],t[120400]=[C["GR.IC.FF.ANTITANK/ANTIARMOUR"]],t[120401]=[C["GR.IC.FF.ANTITANK/ANTIARMOUR"],C["GR.IC.ARMOUR"]],t[120402]=[C["GR.IC.FF.ANTITANK/ANTIARMOUR"],C["GR.IC.FF.MOTORIZED"]],t[120500]=[C["GR.IC.ARMOUR"]],t[120501]=[C["GR.IC.ARMOUR"],C["GR.IC.FF.RECONNAISSANCE"]],t[120502]=[C["GR.IC.ARMOUR"],C["GR.IC.FF.AMPHIBIOUS"]],t[120600]=[C["GR.IC.AVIATION ROTARY WING"]],t[120601]=[C["GR.IC.AVIATION ROTARY WING"],C["GR.IC.FF.RECONNAISSANCE"]],t[120700]=[C["GR.IC.AVIATION COMPOSITE"]],t[120800]=[C["GR.IC.AVIATION FIXED WING"]],t[120801]=[C["GR.IC.AVIATION FIXED WING"],C["GR.IC.FF.RECONNAISSANCE"]],t[120900]=[C["GR.IC.COMBAT"]],t[121e3]=[C["GR.IC.COMBINED ARMS"]],t[121100]=[C["GR.IC.FF.INFANTRY"]],t[121101]=[C["GR.IC.FF.INFANTRY"],C["GR.IC.FF.AMPHIBIOUS"]],t[121102]=[C["GR.IC.FF.INFANTRY"],C["GR.IC.ARMOUR"]],t[121103]=[C["GR.IC.FF.INFANTRY"],C["GR.IC.FF.MAIN GUN SYSTEM"]],t[121104]=[C["GR.IC.FF.INFANTRY"],C["GR.IC.FF.MOTORIZED"]],t[121105]=[C["GR.IC.FF.INFANTRY"],C["GR.IC.ARMOUR"],C["GR.IC.FF.MAIN GUN SYSTEM"]],t[121106]=[C["GR.IC.FF.MAIN GUN SYSTEM"]],t[121200]=[C["GR.IC.OBSERVER/OBSERVATION"]],t[121300]=[C["GR.IC.FF.RECONNAISSANCE"]],t[121301]=[C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.SURVEILLANCE"]],t[121302]=[C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.FF.AMPHIBIOUS"]],t[121303]=[C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.FF.MOTORIZED"]],t[121400]=[C["GR.IC.SEA-AIR-LAND"]],t[121500]=[C["GR.IC.SNIPER"]],t[121600]=[C["GR.IC.SURVEILLANCE"]],t[121700]=[C["GR.IC.SPECIAL FORCES"]],t[121800]=[C["GR.IC.SPECIAL OPERATIONS FORCES"]],t[121801]=[C["GR.IC.FIXED WING MISO"]],t[121802]=[C["GR.IC.SPECIAL OPERATIONS FORCES"],C["GR.IC.FF.INFANTRY"]],t[121803]=[C["GR.IC.COMBATANT"],C["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],t[121804]=[C["GR.IC.SUBMARINE NUCLEAR PROPULSION"],C["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],t[121805]=[C["SOF.IC.UNDERWATER DEMOLITION TEAM"]],t[121900]=[C["GR.IC.UNMANNED SYSTEMS"]],t[122e3]=[C["GR.IC.RANGER"]],t[13e4]=[],t[130100]=[C["GR.IC.FF.AIR DEFENCE"]],t[130101]=[C["GR.IC.FF.AIR DEFENCE"],C["GR.IC.FF.MAIN GUN SYSTEM"]],t[130102]=[C["GR.IC.FF.AIR DEFENCE"],C["GR.IC.MISSILE"]],t[130103]=[C["GR.IC.FF.AIR DEFENCE"],C["GR.IC.AIR AND MISSILE DEFENSE"]],t[130200]=[C["GR.IC.FIELD ARTILLERY"],C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.AVIATION ROTARY WING"],C["GR.M1.NAVAL"]],t[130300]=[C["GR.IC.FIELD ARTILLERY"]],t[130301]=[L._scale(.8,C["GR.IC.FIELD ARTILLERY"]),C["GR.IC.ARMOUR"]],t[130302]=[L._scale(.8,C["GR.IC.FIELD ARTILLERY"]),C["GR.IC.ARMOUR"],C["GR.IC.FF.RECONNAISSANCE"]],t[130303]=[L._scale(.8,C["GR.IC.FIELD ARTILLERY"]),C["GR.IC.FF.RECONNAISSANCE"]],t[130400]=[C["GR.IC.FIELD ARTILLERY OBSERVER"]],t[130500]=[C["GR.IC.JOINT FIRE SUPPORT"]],t[130600]=[C["GR.IC.METEOROLOGICAL"]],t[130700]=[C["GR.IC.MISSILE"]],t[130800]=[C["GR.IC.MORTAR"]],t[130801]=[C["GR.IC.MORTAR"],C["GR.M2.TRACKED"]],t[130802]=[C["GR.IC.MORTAR"],C["GR.M2.TRUCK"]],t[130803]=[C["GR.IC.MORTAR"],C["GR.M2.TOWED"]],t[130900]=[C["GR.IC.SURVEY"]],t[14e4]=[],t[140100]=[C["GR.IC.CBRN"]],t[140101]=[C["GR.IC.CBRN"],C["GR.IC.ARMOUR"]],t[140102]=[C["GR.IC.CBRN"],C["GR.IC.FF.MOTORIZED"]],t[140103]=[C["GR.IC.CBRN"],C["GR.IC.FF.RECONNAISSANCE"]],t[140104]=[C["GR.IC.CBRN"],C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.ARMOUR"]],t[140105]=[C["GR.IC.CBRN"],C["GR.IC.FF.RECONNAISSANCE"],C["GR.IC.FF.MOTORIZED"]],t[140106]=[C["GR.IC.CBRN"],C["GR.CHEMICAL, BIOLOGICAL, RADIOLOGICAL, NUCLEAR, AND HIGH-YIELD EXPLOSIVES"]],t[140200]=[C["GR.IC.COMBAT SUPPORT (MANOEUVRE ENHANCEMENT)"]],t[140300]=[C["GR.IC.CRIMINAL INVESTIGATION DIVISION"]],t[140400]=[C["GR.IC.DIVER, CIVILIAN"]],t[140500]=[C["GR.IC.DOG"]],t[140600]=[C["GR.IC.DRILLING"]],t[140700]=[C["GR.IC.ENGINEER"]],t[140701]=[C["GR.IC.ENGINEER MECHANIZED"]],t[140702]=[C["GR.IC.ENGINEER"],C["GR.IC.FF.MOTORIZED"]],t[140703]=[C["GR.IC.ENGINEER"],C["GR.IC.FF.RECONNAISSANCE"]],t[140800]=[C["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],t[140900]=[C["GR.IC.FIELD CAMP CONSTRUCTION"]],t[141e3]=[C["GR.IC.FIRE PROTECTION"]],t[141100]=[C["GR.IC.GEOSPATIAL SUPPORT"]],t[141200]=[C["GR.IC.MILITARY POLICE"]],t[141300]=[C["GR.IC.MINE"]],t[141400]=[C["GR.IC.MINE CLEARING"]],t[141500]=[C["GR.IC.MINE LAUNCHING"]],t[141600]=[C["GR.IC.MINE LAYING"]],t[141700]=[C["GR.IC.SECURITY"]],t[141701]=[C["GR.IC.SECURITY"],C["GR.IC.ARMOUR"]],t[141702]=[C["GR.IC.SECURITY"],C["GR.IC.FF.MOTORIZED"]],t[141800]=[C["GR.IC.SEARCH AND RESCUE"]],t[141801]=[C["GR.IC.ISOLATED PERSONNEL"]],t[141900]=[C["GR.IC.SECURITY POLICE (AIR)"]],t[142e3]=[C["GR.IC.SHORE PATROL"]],t[142100]=[C["GR.IC.TOPOGRAPHIC"]],t[142200]=[C["GR.IC.AIR AND MISSILE DEFENSE"]],t[15e4]=[],t[150100]=[C["GR.IC.FF.ANALYSIS"]],t[150200]=[C["GR.IC.COUNTER-INTELLIGENCE"]],t[150300]=[C["GR.IC.FF.DIRECTION FINDING"]],t[150400]=[C["GR.IC.ELECTRONIC RANGING"]],t[150500]=[C["GR.IC.ELECTRONIC WARFARE"]],t[150501]=[C["GR.IC.ELECTRONIC WARFARE"],C["GR.IC.FF.ANALYSIS"]],t[150502]=[C["GR.IC.ELECTRONIC WARFARE"],C["GR.IC.FF.DIRECTION FINDING"]],t[150503]=[C["GR.IC.ELECTRONIC WARFARE"],C["GR.IC.FF.INTERCEPT"]],t[150504]=[C["GR.IC.ELECTRONIC WARFARE"],C["GR.IC.FF.JAMMING"]],t[150505]=[C["GR.IC.ELECTRONIC WARFARE"],C["GR.IC.FF.SEARCH"]],t[150600]=[C["GR.IC.FF.INTERCEPT"]],t[150700]=[C["GR.IC.INTERROGATION"]],t[150800]=[C["GR.IC.FF.JAMMING"]],t[150900]=[C["GR.IC.JOINT INTELLIGENCE CENTRE"]],t[151e3]=[C["GR.IC.MILITARY INTELLIGENCE"]],t[151100]=[C["GR.IC.FF.SEARCH"]],t[151200]=[C["GR.IC.SENSOR"]],t[151300]=[C["GR.IC.MILITARY HISTORY"]],t[16e4]=[C["GR.IC.SUSTAINMENT"]],t[160100]=[C["GR.IC.ADMINISTRATIVE"]],t[160200]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS ALL"]],t[160300]=[C["GR.IC.TRANSPORTATION"],C["GR.IC.AIRPORT OF DEBARKATION"]],t[160400]=[C["GR.IC.AMMUNITION"]],t[160500]=[C["GR.IC.BAND"]],t[160501]=[C["GR.IC.ARMY MUSIC"]],t[160600]=[C["GR.IC.COMBAT SERVICE SUPPORT"]],t[160700]=[C["GR.IC.FINANCE"]],t[160800]=[C["GR.IC.JUDGE ADVOCATE GENERAL"]],t[160900]=[C["GR.IC.LABOUR"]],t[161e3]=[C["GR.IC.LAUNDRY/BATH"]],t[161100]=[C["GR.IC.MAINTENANCE"]],t[161200]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.MATERIEL"]],t[161300]=[C["GR.IC.FF.MEDICAL"]],t[161400]=[C["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t[161500]=[C["GR.IC.MORALE, WELFARE, AND RECREATION"]],t[161600]=[C["GR.IC.MORTUARY AFFAIRS"]],t[161700]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS MULTIPLE"]],t[161800]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.NATO SUPPLY CLASS I"]],t[161900]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.NATO SUPPLY CLASS II"]],t[162e3]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS III"]],t[162100]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.NATO SUPPLY CLASS IV"]],t[162200]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS V"]],t[162300]=[C["GR.IC.ORDNANCE"]],t[162400]=[C["GR.IC.PERSONNEL SERVICES"]],t[162500]=[C["GR.IC.PETROLEUM OIL LUBRICANTS"]],t[162600]=[C["GR.IC.PIPELINE"]],t[162700]=[C["GR.IC.POSTAL"]],t[162800]=[C["GR.IC.PUBLIC AFFAIRS"]],t[162900]=[C["GR.IC.QUARTERMASTER"]],t[163e3]=[C["GR.IC.RAILHEAD"]],t[163100]=[C["GR.IC.RELIGIOUS SUPPORT"]],t[163200]=[C["GR.IC.REPLACEMENT HOLDING UNIT"]],t[163300]=[C["GR.IC.SEAPORT OF DEBARKATION"]],t[163400]=[C["GR.IC.FF.SUPPLY"]],t[163500]=[C["GR.IC.JOINT INFORMATION BUREAU"]],t[163600]=[C["GR.IC.TRANSPORTATION"]],t[163601]=[C["GR.IC.TRANSPORTATION"],C["GR.IC.FLOATING CRAFT"]],t[163700]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS I"]],t[163800]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS II"]],t[163900]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS III"]],t[164e3]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS IV"]],t[164100]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS V"]],t[164200]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS VI"]],t[164300]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS VII"]],t[164400]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS VIII"]],t[164500]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS IX"]],t[164600]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.CLASS X"]],t[164700]=[C["GR.IC.WATER"]],t[164800]=[C["GR.IC.WATER PURIFICATION"]],t[164900]=[C["GR.IC.PUBLIC AFFAIRS BROADCAST"]],t[165e3]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.FF.NATO SUPPLY CLASS ALL"]],t[165100]=[C["GR.IC.INTERPRETER/TRANSLATOR"]],t[165200]=[C["GR.IC.SUPPORT"]],t[165300]=[C["GR.IC.ARMY FIELD SUPPORT"]],t[165400]=[C["GR.IC.CONTRACTING SERVICES"]],t[165500]=[C["GR.IC.PARACHUTE RIGGER"]],t[165600]=[C["GR.IC.HUMAN RESOURCES"]],t[17e4]=[],t[170100]=[C["GR.IC.NAVAL"]],t[18e4]=[],t[180100]=[C["GR.IC.ALLIED COMMAND EUROPE RAPID REACTION CORPS (ARRC)"]],t[180200]=[C["GR.IC.ALLIED COMMAND OPERATIONS"]],t[180300]=[C["GR.IC.INTERNATIONAL SECURITY ASSISTANCE FORCE (ISAF)"]],t[180400]=[C["GR.IC.MULTINATIONAL (MN)"]],t[19e4]=[C["GR.IC.FF.EMERGENCY OPERATION"]],t[2e5]=[C["GR.IC.FF.LAW ENFORCEMENT"]],t[200100]=[C["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],t[200200]=[C["GR.IC.FF.BORDER PATROL"]],t[200300]=[C["GR.IC.FF.CUSTOMS SERVICE"]],t[200400]=[C["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],t[200500]=[C["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],t[200600]=[C["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],t[200700]=[C["GR.IC.LAW ENFORCEMENT"]],t[200800]=[C["GR.IC.FF.PRISON"]],t[200900]=[C["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],t[201e3]=[C["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],t[201100]=[C["GR.IC.LAW ENFORCEMENT VESSEL"]],t[201200]=[C["GR.IC.FF.US MARSHALS SERVICE"]],t[201300]=[C["ST.IC.INTERNAL SECURITY FORCE"]],t[21e4]=[C["GR.IC.CYBER"]],I["01"]=[A?C["GR.M1.TACTICAL SATELLITE COMMUNICATIONS"]:C["GR.M1.AIRMOBILE/AIR ASSAULT"]],I["02"]=[C["GR.M1.AREA"]],I["03"]=[C["GR.M1.ATTACK"]],I["04"]=[C["GR.M1.BIOLOGICAL"]],I["05"]=[C["GR.M1.BORDER"]],I["06"]=[C["GR.M1.BRIDGING"]],I["07"]=[C["GR.M1.CHEMICAL"]],I["08"]=[C["GR.M1.CLOSE PROTECTION"]],I["09"]=[C["GR.M1.COMBAT"]],I[10]=[C["GR.M1.COMMAND AND CONTROL"]],I[11]=[C["GR.M1.COMMUNICATIONS CONTINGENCY PACKAGE"]],I[12]=[C["GR.M1.CONSTRUCTION"]],I[13]=[C["GR.M1.CROSS CULTURAL COMMUNICATION"]],I[14]=[C["GR.M1.CROWD AND RIOT CONTROL"]],I[15]=[C["GR.M1.DECONTAMINATION"]],I[16]=[C["GR.M1.DETENTION"]],I[17]=[C["GR.M1.DIRECT COMMUNICATIONS"]],I[18]=[C["GR.M1.DIVING"]],I[19]=[C["GR.M1.DIVISION"]],I[20]=[C["GR.M1.DOG"]],I[21]=[C["GR.M1.DRILLING"]],I[22]=[C["GR.M1.ELECTRO-OPTICAL"]],I[23]=[C["GR.M1.ENHANCED"]],I[24]=[C["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]],I[25]=[C["GR.M1.FIRE DIRECTION CENTRE"]],I[26]=[C["GR.M1.FORCE"]],I[27]=[C["GR.M1.FORWARD"]],I[28]=[C["GR.M1.GROUND STATION MODULE"]],I[29]=[C["GR.M1.LANDING SUPPORT"]],I[30]=[C["GR.M1.LARGE EXTENSION NODE"]],I[31]=[C["GR.M1.MAINTENANCE"]],I[32]=[C["GR.M1.METEOROLOGICAL"]],I[33]=[C["GR.M1.MINE COUNTERMEASURE"]],I[34]=[C["GR.M1.MISSILE"]],I[35]=[C["GR.M1.(MOBILE) ADVISOR AND SUPPORT"]],I[36]=[C["GR.M1.MOBILE SUBSCRIBER EQUIPMENT"]],I[37]=[C["GR.M1.MOBILITY SUPPORT"]],I[38]=[C["GR.M1.MOVEMENT CONTROL CENTRE"]],I[39]=[C["GR.M1.MULTINATIONAL"]],I[40]=[C["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]],I[41]=[C["GR.M1.MULTIPLE ROCKET LAUNCHER"]],I[42]=[C["GR.M1.NATO MEDICAL ROLE 1"]],I[43]=[C["GR.M1.NATO MEDICAL ROLE 2"]],I[44]=[C["GR.M1.NATO MEDICAL ROLE 3"]],I[45]=[C["GR.M1.NATO MEDICAL ROLE 4"]],I[46]=[C["GR.M1.NAVAL"]],I[47]=[A?C["GR.M1.UNMANNED AERIAL VEHICLE"]:C["GR.M1.NODE CENTRE"]],I[48]=[C["GR.M1.NUCLEAR"]],I[49]=[C["GR.M1.OPERATIONS"]],I[50]=[C["GR.M1.RADAR"]],I[51]=[C["GR.M1.RADIO FREQUENCY IDENTIFICATION (RFID) INTERROGATOR/ SENSOR"]],I[52]=[C["GR.M1.RADIOLOGICAL"]],I[53]=[C["GR.M1.SEARCH AND RESCUE"]],I[54]=[C["GR.M1.SECURITY"]],I[55]=[C["GR.M1.SENSOR"]],I[56]=[A?C["GR.M1.WEAPON"]:C["GR.M1.SENSOR CONTROL MODULE"]],I[57]=[C["GR.M1.SIGNALS INTELLIGENCE"]],I[58]=[A?C["GR.M1.ARMORED"]:C["GR.M1.SINGLE SHELTER SWITCH"]],I[59]=[C["GR.M1.SINGLE ROCKET LAUNCHER"]],I[60]=[C["GR.M1.SMOKE"]],I[61]=[C["GR.M1.SNIPER"]],I[62]=[C["GR.M1.SOUND RANGING"]],I[63]=[C["GR.M1.SPECIAL OPERATIONS FORCES (SOF)"]],I[64]=[C["GR.M1.SPECIAL WEAPONS AND TACTICS"]],I[65]=[C["GR.M1.SURVEY"]],I[66]=[C["GR.M1.TACTICAL EXPLOITATION"]],I[67]=[C["GR.M1.TARGET ACQUISITION"]],I[68]=[C["GR.M1.TOPOGRAPHIC"]],I[69]=[C["GR.M1.UTILITY"]],I[70]=[C["GR.M1.VIDEO IMAGERY"]],I[71]=[A?C["GR.M1.MOBILITY ASSAULT"]:C["GR.M1.ACCIDENT"]],I[72]=[A?C["GR.M1.AMPHIBIOUS WARFARE SHIP "]:C["GR.M1.OTHER"]],I[73]=[A?C["GR.M1.LOAD HANDLING SYSTEM"]:C["GR.M1.CIVILIAN"]],I[74]=[A?C["GR.M1.PALLETIZED LOAD SYSTEM"]:C["GR.M1.ANTISUBMARINE WARFARE"]],I[75]=[C["GR.M1.MEDEVAC"]],I[76]=[C["GR.M1.RANGER"]],I[77]=[C["GR.M1.SUPPORT"]],I[78]=[C["GR.M1.AVIATION"]],I[79]=[C["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"]],I[80]=[C["GR.M1.TILT-ROTOR"]],I[81]="D"==T?[C["GR.M1.COMMAND POST NODE"]]:[C["GR.M1.NATO MEDICAL ROLE 2 BASIC"]],I[82]="D"==T?[C["GR.M1.JOINT NETWORK NODE"]]:[C["GR.M1.NATO MEDICAL ROLE 2 ENHANCED"]],I[83]="D"==T?[C["GR.M1.RETRANSMISSION SITE"]]:[C["GR.M1.NATO MEDICAL ROLE 2 FORWARD"]],I[84]=[C["GR.M1.ASSAULT"]],I[85]=[C["GR.M1.WEAPONS"]],I[86]=[C["GR.M1.CRIMINAL INVESTIGATION DIVISION"]],I[87]=[C["GR.M1.DIGITAL"]],I[88]=[C["GR.M1.NETWORK OR NETWORK OPERATIONS"]],I[89]=[C["GR.M1.AIRFIELD, AERIAL PORT OF DEBARKATION, OR AERIAL PORT OF EMBARKATION"]],I[90]=[C["GR.M1.PIPELINE"]],I[91]=[C["GR.M1.POSTAL"]],I[92]=[C["GR.M1.WATER"]],I[93]=[C["GR.M1.INDEPENDENT COMMAND"]],I[94]=[C["GR.M1.THEATRE"]],I[95]=[C["GR.M1.ARMY"]],I[96]=[C["GR.M1.CORPS"]],I[97]=[C["GR.M1.BRIGADE"]],I[98]=[C["GR.IC.FF.HEADQUARTERS OR HEADQUARTERS ELEMENT"]],I[99]=[C["GR.M1.MULTI-DOMAIN"]],E["01"]=[C["GR.M2.AIRBORNE"]],E["02"]=[C["GR.M2.ARCTIC"]],E["03"]=[C["GR.M2.BATTLE DAMAGE REPAIR"]],E["04"]=[C["GR.M2.BICYCLE EQUIPPED"]],E["05"]=[C["GR.M2.CASUALTY STAGING"]],E["06"]=[C["GR.M2.CLEARING"]],E["07"]=[C["GR.M2.CLOSE RANGE"]],E["08"]=[C["GR.M2.CONTROL"]],E["09"]=[C["GR.M2.DECONTAMINATION"]],E[10]=[C["GR.M2.DEMOLITION"]],E[11]=[C["GR.M2.DENTAL"]],E[12]=[C["GR.M2.DIGITAL"]],E[13]=[C["GR.M2.ENHANCED POSITION LOCATION REPORTING SYSTEM"]],E[14]=[C["GR.M2.EQUIPMENT"]],E[15]=[C["GR.M2.HEAVY"]],E[16]=[C["GR.M2.HIGH ALTITUDE"]],E[17]=[C["GR.M2.INTERMODAL"]],E[18]=[C["GR.M2.INTENSIVE CARE"]],E[19]=[C["GR.M2.LIGHT"]],E[20]=[C["GR.M2.LABORATORY"]],E[21]=[C["GR.M2.LAUNCHER"]],E[22]=[C["GR.M2.LONG RANGE"]],E[23]=[C["GR.M2.LOW ALTITUDE"]],E[24]=[C["GR.M2.MEDIUM"]],E[25]=[C["GR.M2.MEDIUM ALTITUDE"]],E[26]=[C["GR.M2.MEDIUM RANGE"]],E[27]=[C["GR.M2.MOUNTAIN"]],E[28]=[C["GR.M2.HIGH TO MEDIUM ALTITUDE"]],E[29]=[C["GR.M2.MULTI-CHANNEL"]],E[30]=[C["GR.M2.OPTICAL"]],E[31]=[C["GR.M2.PACK ANIMAL"]],E[32]=[C["GR.M2.PATIENT EVACUATION COORDINATION"]],E[33]=[C["GR.M2.PREVENTIVE MAINTENANCE"]],E[34]=[C["GR.M2.PSYCHOLOGICAL"]],E[35]=[C["GR.M2.RADIO RELAY LINE OF SIGHT"]],E[36]=[C["GR.M2.RAILROAD"]],E[37]=[C["GR.M2.RECOVERY (UNMANNED SYSTEMS)"]],E[38]=[C["GR.M2.RECOVERY (MAINTENANCE)"]],E[39]=[C["GR.M2.RESCUE COORDINATION CENTRE"]],E[40]=[C["GR.M2.RIVERINE"]],E[41]=[C["GR.M2.SINGLE CHANNEL"]],E[42]=[C["GR.M2.SKI"]],E[43]=[C["GR.M2.SHORT RANGE"]],E[44]=[C["GR.M2.STRATEGIC"]],E[45]=[C["GR.M2.SUPPORT"]],E[46]=[C["GR.M2.TACTICAL"]],E[47]=[C["GR.M2.TOWED"]],E[48]=[C["GR.M2.TROOP"]],E[49]=[C["GR.M2.VERTICAL OR SHORT TAKE-OFF AND LANDING "]],E[50]=[C["GR.M2.VETERINARY"]],E[51]=[C["GR.M2.WHEELED"]],E[52]=[C["GR.M2.HIGH TO LOW ALTITUDE"]],E[53]=[C["GR.M2.MEDIUM TO LOW ALTITUDE"]],E[54]=[C["GR.M2.ATTACK"]],E[55]=[C["GR.M2.REFUEL"]],E[56]=[C["GR.M2.UTILITY"]],E[57]=[C["GR.M2.COMBAT SEARCH AND RESCUE"]],E[58]=[C["GR.M2.GUERILLA"]],E[59]=[C["GR.M2.AIR ASSAULT"]],E[60]=[C["GR.M2.AMPHIBIOUS"]],E[61]=[C["GR.M2.VERY HEAVY"]],E[62]=[C["GR.IC.FF.SUPPLY"]],E[63]=[C["GR.M2.CYBERSPACE"]],E[64]=[C["GR.M2.NAVY BARGE, SELF-PROPELLED"]],E[65]=[C["GR.M2.NAVY BARGE, NOT SELF-PROPELLED"]],E[66]=[C["GR.M2.LAUNCH"]],E[67]=[C["GR.M2.LANDING CRAFT"]],E[68]=[C["GR.M2.LANDING SHIP"]],E[69]=[C["GR.M2.SERVICE CRAFT/YARD"]],E[70]=[C["GR.M2.TUG HARBOR"]],E[71]=[C["GR.M2.OCEAN GOING TUG BOAT"]],E[72]=[C["GR.M2.SURFACE DEPLOYMENT AND DISTRIBUTION COMMAND"]],E[73]=[C["GR.M2.NONCOMBATANT GENERIC VESSEL"]],E[74]=[C["GR.M2.COMPOSITE"]],E[75]=[C["GR.M2.SHELTER"]],E[76]=[C["GR.M2.LIGHT AND MEDIUM"]],E[77]=[C["GR.M2.SELF-PROPELLED"]],E[78]=[C["GR.M2.SECURITY FORCE ASSISTANCE"]],E[81]=[C["GR.M2.SURGICAL"]],E[82]=[C["GR.M2.BLOOD"]],E[83]=[C["GR.M2.COMBAT AND OPERATIONAL STRESS CONTROL"]],E[84]=[C["GR.M2.JAMMING"]],E[86]=[C["GR.M2.OPTOMETRY"]],E[87]=[C["GR.M2.PREVENTIVE MEDICIN"]],E[89]=[C["GR.IC.FF.AIR DEFENCE"]])}},f={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A){"11"==R&&(t[11e4]=[C["GR.I.CIVILIAN"]],t[110100]=[C["GR.IC.ENVIRONMENTAL PROTECTION"]],t[110200]=[C["GR.IC.GOVERNMENT ORGANIZATION"]],t[110300]=[C["ST.IC.INDIVIDUAL"]],t[110400]=[C["ST.IC.GROUP"]],t[110500]=[C["ST.IC.KILLING VICTIM"]],t[110600]=[C["ST.IC.KILLING VICTIMS"]],t[110700]=[C["ST.IC.INDIVIDUAL"],C["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],t[110800]=[C["ST.IC.SPY"]],t[110900]=[C["ST.IC.COMPOSITE LOSS"]],t[111e3]=[C["GR.IC.EMERGENCY MEDICAL OPERATION"]],I["01"]=[C["ST.M1.ASSASSINATION"]],I["02"]=[C["ST.M1.EXECUTION (WRONGFUL KILLING)"]],I["03"]=[C["ST.M1.MURDER"]],I["04"]=[C["ST.M1.HIJACKING/HIJACKED"]],I["05"]=[C["ST.M1.KIDNAPPING"]],I["06"]=[C["ST.M1.PIRACY"]],I["07"]=[C["ST.M1.RAPE"]],I["08"]=[C["ST.M1.CIVILIAN"]],I["09"]=[C["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],I[10]=[C["ST.M1.FOREIGN FIGHTERS"]],I[11]=[C["ST.M1.GANG"]],I[12]=[C["ST.M1.GOVERNMENT ORGANIZATION"]],I[13]=[C["ST.M1.LEADER"]],I[14]=[C["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],I[15]=[C["ST.M1.COERCED/IMPRESSED"]],I[16]=[C["ST.M1.WILLING RECRUIT"]],I[17]=[C["ST.M1.RELIGIOUS"]],I[18]=[C["ST.M1.TARGETED"]],I[19]=[C["ST.M1.TERRORIST"]],I[20]=[C["ST.M1.SPEAKER"]],I[21]=[C["ST.M1.ACCIDENT"]],I[22]=[C["ST.M1.COMBAT"]],I[23]=[C["ST.M1.OTHER"]],I[24]=[C["ST.M1.LOOT"]],I[25]=[C["GR.M1.HIJACKER"]],I[26]=[C["GR.M1.CYBERSPACE"]],E["01"]=[C["ST.M2.LEADER OR LEADERSHIP"]],E["02"]=[C["GR.M2.CYBERSPACE"]])}},z={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A){if("15"==R){t[11e4]=[C["GR.EQ.WEAPON"]],t[110100]=[C["GR.EQ.RIFLE"]],t[110101]=[C["GR.EQ.RIFLE"],C["GR.EQ.SHORT RANGE"]],t[110102]=[C["GR.EQ.RIFLE"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110103]=[C["GR.EQ.RIFLE"],C["GR.EQ.LONG RANGE"]],t[110200]=[C["GR.EQ.MACHINE GUN"]],t[110201]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.SHORT RANGE"]],t[110202]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110203]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.LONG RANGE"]],t[110300]=[C["GR.EQ.GRENADE LAUNCHER"]],t[110301]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.SHORT RANGE"])],t[110302]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.INTERMEDIATE RANGE"])],t[110303]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.LONG RANGE"])],t[110400]=[C["GR.EQ.FLAME THROWER"]],t[110500]=[C["GR.EQ.AIR DEFENCE GUN"]],t[110501]=[C["GR.EQ.AIR DEFENCE GUN"],C["GR.EQ.SHORT RANGE"]],t[110502]=[C["GR.EQ.AIR DEFENCE GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110503]=[C["GR.EQ.AIR DEFENCE GUN"],C["GR.EQ.LONG RANGE"]],t[110600]=[C["GR.EQ.ANTITANK GUN"]],t[110601]=[C["GR.EQ.ANTITANK GUN"],C["GR.EQ.SHORT RANGE"]],t[110602]=[C["GR.EQ.ANTITANK GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110603]=[C["GR.EQ.ANTITANK GUN"],C["GR.EQ.LONG RANGE"]],t[110700]=[C["GR.EQ.DIRECT FIRE GUN"]],t[110701]=[C["GR.EQ.DIRECT FIRE GUN"],C["GR.EQ.SHORT RANGE"]],t[110702]=[C["GR.EQ.DIRECT FIRE GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110703]=[C["GR.EQ.DIRECT FIRE GUN"],C["GR.EQ.LONG RANGE"]],t[110800]=[C["GR.EQ.RECOILLESS GUN"]],t[110801]=[C["GR.EQ.RECOILLESS GUN"],C["GR.EQ.SHORT RANGE"]],t[110802]=[C["GR.EQ.RECOILLESS GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110803]=[C["GR.EQ.RECOILLESS GUN"],C["GR.EQ.LONG RANGE"]],t[110900]=[C["GR.EQ.HOWITZER"]],t[110901]=[C["GR.EQ.HOWITZER"],C["GR.EQ.SHORT RANGE"]],t[110902]=[C["GR.EQ.HOWITZER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110903]=[C["GR.EQ.HOWITZER"],C["GR.EQ.LONG RANGE"]],t[111e3]=[C["GR.EQ.MISSILE LAUNCHER"]],t[111001]=[C["GR.EQ.MISSILE LAUNCHER"],C["GR.EQ.SHORT RANGE"]],t[111002]=[C["GR.EQ.MISSILE LAUNCHER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111003]=[C["GR.EQ.MISSILE LAUNCHER"],C["GR.EQ.LONG RANGE"]],t[111100]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"]],t[111101]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.SHORT RANGE"]],t[111102]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.SHORT RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t[111103]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.SHORT RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t[111104]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111105]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.INTERMEDIATE RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t[111106]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.INTERMEDIATE RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t[111107]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.LONG RANGE"]],t[111108]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.LONG RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TLAR"]],t[111109]=[C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR"],C["GR.EQ.LONG RANGE"],C["GR.EQ.AIR DEFENCE MISSILE LAUNCHER SURFACE-TO-AIR TELAR"]],t[111200]=[C["GR.EQ.ANTITANK MISSILE LAUNCHER"]],t[111201]=[C["GR.EQ.ANTITANK MISSILE LAUNCHER"],C["GR.EQ.SHORT RANGE"]],t[111202]=[C["GR.EQ.ANTITANK MISSILE LAUNCHER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111203]=[C["GR.EQ.ANTITANK MISSILE LAUNCHER"],C["GR.EQ.LONG RANGE"]],t[111300]=[C["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"]],t[111301]=[C["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],C["GR.EQ.SHORT RANGE"]],t[111302]=[C["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111303]=[C["GR.EQ.SURFACE-TO-SURFACE MISSILE LAUNCHER"],C["GR.EQ.LONG RANGE"]],t[111400]=[C["GR.EQ.MORTAR"]],t[111401]=[C["GR.EQ.MORTAR"],C["GR.EQ.SHORT RANGE"]],t[111402]=[C["GR.EQ.MORTAR"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111403]=[C["GR.EQ.MORTAR"],C["GR.EQ.LONG RANGE"]],t[111500]=[C["GR.EQ.SINGLE ROCKET LAUNCHER"]],t[111501]=[C["GR.EQ.SINGLE ROCKET LAUNCHER"],C["GR.EQ.SHORT RANGE"]],t[111502]=[C["GR.EQ.SINGLE ROCKET LAUNCHER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111503]=[C["GR.EQ.SINGLE ROCKET LAUNCHER"],C["GR.EQ.LONG RANGE"]],t[111600]=[C["GR.EQ.MULTIPLE ROCKET LAUNCHER"]],t[111601]=[C["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,C["GR.EQ.SHORT RANGE"])],t[111602]=[C["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,C["GR.EQ.INTERMEDIATE RANGE"])],t[111603]=[C["GR.EQ.MULTIPLE ROCKET LAUNCHER"],L._translate(0,10,C["GR.EQ.LONG RANGE"])],t[111700]=[C["GR.EQ.ANTITANK ROCKET LAUNCHER"]],t[111701]=[C["GR.EQ.ANTITANK ROCKET LAUNCHER"],C["GR.EQ.SHORT RANGE"]],t[111702]=[C["GR.EQ.ANTITANK ROCKET LAUNCHER"],C["GR.EQ.INTERMEDIATE RANGE"]],t[111703]=[C["GR.EQ.ANTITANK ROCKET LAUNCHER"],C["GR.EQ.LONG RANGE"]],t[111800]=[C["GR.EQ.NON-LETHAL WEAPON"]],t[111900]=[C["GR.EQ.TASER"]],t[112e3]=[C["GR.EQ.WATER CANNON"]],t[12e4]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"]],t[120100]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.ARMOURED VEHICLE"]],t[120101]=[C["GR.EQ.ARMOURED FIGHTING VEHICLE"]],t[120102]=[C["GR.EQ.ARMOURED FIGHTING VEHICLE (AFV) COMMAND AND CONTROL"]],t[120103]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"]],t[120104]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],C["GR.EQ.MEDICAL EVACUATION"]],t[120105]=[C["GR.IC.ARMOUR"]],t[120106]=[C["GR.IC.ARMOUR"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[120107]=[C["GR.IC.ARMOUR"],C["GR.EQ.MEDICAL EVACUATION"]],t[120108]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[120109]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],C["GR.EQ.COMBAT SERVICE SUPPORT VEHICLE"]],t[120110]=[C["GR.EQ.ARMOURED FIGHTING VEHICLE"],C["GR.EQ.CROSS-COUNTRY"]],t[120111]=[C["GR.EQ.ARMOURED FIGHTING VEHICLE"],C["GR.EQ.CROSS-COUNTRY"],C["GR.IC.FF.RECONNAISSANCE EQUPIMENT"]],t[120200]=[C["GR.EQ.TANK"]],t[120201]=[C["GR.EQ.TANK"],C["GR.EQ.LIGHT TANK"]],t[120202]=[C["GR.EQ.TANK"],C["GR.EQ.MEDIUM TANK"]],t[120203]=[C["GR.EQ.TANK"],C["GR.EQ.HEAVY TANK"]],t[120300]=[C["GR.EQ.TANK"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[120301]=[C["GR.EQ.TANK"],C["GR.EQ.LIGHT TANK"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[120302]=[C["GR.EQ.TANK"],C["GR.EQ.MEDIUM TANK"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[120303]=[C["GR.EQ.TANK"],C["GR.EQ.HEAVY TANK"],C["GR.EQ.TANK RECOVERY VEHICLE"]],t[13e4]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],L._scale(.7,C["GR.IC.ENGINEER"],!0)],t[130100]=[C["GR.IN.IC.BRIDGE"]],t[130200]=[C["GR.EQ.UTILITY VEHICLE"],L._scale(.8,C["GR.IN.IC.BRIDGE"],!0)],t[130300]=[C["GR.IN.IC.BRIDGE"],C["GR.EQ.FIXED BRIDGE"]],t[130400]=[C["GR.IN.IC.BRIDGE"],C["GR.M2.RIVERINE"]],t[130500]=[C["GR.IN.IC.BRIDGE"],C["GR.EQ.FOLDING GIRDER BRIDGE"]],t[130600]=[C["GR.IN.IC.BRIDGE"],C["GR.EQ.HOLLOW DECK BRIDGE"]],t[130700]=[C["GR.IC.DRILLING"]],t[130701]=[L._scale(.7,C["GR.IC.DRILLING"],!0),C["GR.EQ.UTILITY VEHICLE"]],t[130800]=[C["GR.EQ.EARTHMOVER"]],t[130801]=[C["GR.EQ.MULTIFUNCTIONAL EARTHMOVER/DIGGER"]],t[130900]=[C["GR.EQ.MINE CLEARING EQUIPMENT"]],t[130901]=[C["GR.EQ.MINE CLEARING EQUIPMENT"],L._translate(0,-10,C["GR.EQ.LIMITED CROSS-COUNTRY"])],t[130902]=[C["GR.EQ.MINE CLEARING EQUIPMENT"],C["GR.EQ.TANK"]],t[130903]=[C["GR.EQ.ASSAULT BREACHER VEHICLE (ABV) WITH COMBAT DOZER BLADE"]],t[130904]=[C["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"],C["GR.IC.ENGINEER UTILITY VEHICLE"],C["GR.M2.MEDIUM"]],t[130905]=[C["GR.M1.ROUTE, RECONNAISSANCE, AND CLEARANCE"],C["GR.IC.ENGINEER UTILITY VEHICLE"],C["GR.M2.HEAVY"]],t[131e3]=[C["GR.IC.MINE LAYING"]],t[131001]=[C["GR.EQ.UTILITY VEHICLE"],L._translate(0,10,L._scale(.7,C["GR.IC.MINE LAYING"],!0))],t[131002]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],C["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],t[131003]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.LIMITED CROSS-COUNTRY"],C["GR.EQ.ARMORED CARRIER WITH VOLCANO"]],t[131100]=[C["GR.EQ.DOZER"]],t[131101]=[C["GR.EQ.DOZER ARMORED"]],t[131200]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],L._scale(.6,C["GR.IC.ENGINEER"],!0)],t[131300]=[C["GR.EQ.ARMOURED PERSONNEL CARRIER"],L._scale(.6,C["GR.IC.ENGINEER"],!0),C["GR.EQ.ARMOURED PERSONNEL CARRIER ENGINEER RECON VEHICLE"]],t[131400]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.LIMITED CROSS-COUNTRY"],C["GR.EQ.UTILITY VEHICLE BACKHOE"]],t[131500]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.LIMITED CROSS-COUNTRY"],L._scale(.6,C["GR.IC.ENGINEER"],!0)],t[131600]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.CROSS-COUNTRY"],C["GR.EQ.UTILITY VEHICLE FERRY TRANSPORTER"]],t[14e4]=[],t[140100]=[C["GR.EQ.UTILITY VEHICLE"]],t[140200]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.MEDICAL VEHICLE"]],t[140300]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.MEDICAL EVACUATION"]],t[140400]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.MOBILE EMERGENCY PHYSICIAN"]],t[140500]=[C["GR.EQ.BUS"]],t[140600]=[C["GR.EQ.SEMI-TRAILER TRUCK"]],t[140601]=[C["GR.EQ.SEMI-TRAILER TRUCK"],C["GR.EQ.UTILITY VEHICLE LIGHT"]],t[140602]=[C["GR.EQ.SEMI-TRAILER TRUCK"],C["GR.EQ.UTILITY VEHICLE MEDIUM"]],t[140603]=[C["GR.EQ.SEMI-TRAILER TRUCK"],C["GR.EQ.UTILITY VEHICLE HEAVY"]],t[140700]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.LIMITED CROSS-COUNTRY"]],t[140800]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.CROSS-COUNTRY"]],t[140900]=[C["GR.EQ.UTILITY VEHICLE"],L._scale(.8,C["GR.IC.FF.CLASS III"],!0)],t[141e3]=[C["GR.EQ.UTILITY VEHICLE"],L._scale(.7,C["GR.IC.WATER"],!0)],t[141100]=[C["GR.EQ.WATER VEHICLE"],C["GR.EQ.LIMITED CROSS-COUNTRY"]],t[141200]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.UTILITY VEHICLE.TOW TRUCK"]],t[141201]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],C["GR.EQ.UTILITY VEHICLE.TOW TRUCK.LIGHT"]],t[141202]=[C["GR.EQ.UTILITY VEHICLE"],C["GR.EQ.UTILITY VEHICLE.TOW TRUCK"],C["GR.EQ.UTILITY VEHICLE.TOW TRUCK.HEAVY"]],t[15e4]=[],t[150100]=[C["GR.EQ.TRAIN LOCOMOTIVE"]],t[150200]=[C["GR.EQ.RAILCAR"]],t[16e4]=[],t[160100]=[C["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"]],t[160101]=[C["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t[160102]=[C["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t[160103]=[C["GR.EQ.CIVILIAN VEHICLE.AUTOMOBILE"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t[160200]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"]],t[160201]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t[160202]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t[160203]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t[160300]=[C["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],t[160301]=[C["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t[160302]=[C["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t[160303]=[C["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t[160400]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"]],t[160401]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t[160402]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t[160403]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t[160500]=[C["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"]],t[160501]=[C["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"]],t[160502]=[C["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"]],t[160503]=[C["GR.EQ.CIVILIAN VEHICLE.JEEP TYPE VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"]],t[160600]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160601]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160602]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160603]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160700]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160701]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.LIGHT"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160702]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.MEDIUM"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160703]=[C["GR.EQ.CIVILIAN VEHICLE.OPEN-BED TRUCK"],C["GR.EQ.CIVILIAN VEHICLE.HEAVY"],C["GR.EQ.CIVILIAN VEHICLE.TRAILER"]],t[160800]=[C["ST.IC.KNOWN INSURGENT VEHICLE"]],t[160900]=[C["ST.IC.KNOWN INSURGENT VEHICLE"],C["ST.M1.DRUG"]],t[17e4]=[C["GR.IC.FF.LAW ENFORCEMENT"]],t[170100]=[C["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],t[170200]=[C["GR.IC.FF.BORDER PATROL"]],t[170300]=[C["GR.IC.FF.CUSTOMS SERVICE"]],t[170400]=[C["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],t[170500]=[C["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],t[170600]=[C["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],t[170700]=[C["GR.IC.LAW ENFORCEMENT"]],t[170800]=[C["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],t[170900]=[C["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],t[171e3]=[C["GR.IC.LAW ENFORCEMENT VESSEL"]],t[171100]=[C["GR.IC.FF.US MARSHALS SERVICE"]],t[18e4]=[C["GR.EQ.PACK ANIMAL"]],t[19e4]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE SUPPORT"]],t[190100]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE TRANSLOADER"]],t[190200]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE TRANSPORTER"]],t[190300]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE CRANE/LOADING DEVICE"]],t[190400]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE PROPELLANT TRANSPORTER"]],t[190500]=[C["GR.EQ.ARMOURED PROTECTED VEHICLE WITH LIMITED CROSS COUNTRY MOBILITY"],C["GR.EQ.MISSILE WARHEAD TRANSPORTER"]],t[2e5]=[],t[200100]=[C["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],t[200200]=[C["ST.IC.BOMB"]],t[200300]=[C["ST.IC.BOOBY TRAP"]],t[200400]=[C["GR.EQ.CBRN EQUIPMENT"]],t[200500]=[C["GR.EQ.COMPUTER SYSTEM"]],t[200600]=[C["GR.EQ.COMMAND LAUNCH EQUIPMENT (CLE)"]],t[200700]=[C["GR.EQ.GENERATOR SET"]],t[200800]=[C["GR.EQ.GROUND-BASED MIDCOURSE DEFENSE (GMD) FIRE CONTROL (GFC) CENTER"]],t[200900]=[C["GR.EQ.IN-FLIGHT INTERCEPTOR COMMUNICATIONS SYSTEM (IFICS) DATA TERMINAL (IDT)"]],t[201e3]=[C["GR.EQ.LASER"]],t[201100]=[C["GR.EQ.PSYCHOLOGICAL OPERATIONS EQUIPMENT"]],t[201200]=[C["GR.IC.SUSTAINMENT"]],t[201300]=[C["GR.EQ.TENT"]],t[201301]=[C["GR.EQ.TENT CIVILIAN"]],t[201302]=[C["GR.EQ.TENT MILITARY"]],t[201400]=[C["GR.EQ.UNIT DEPLOYMENT SHIPMENTS"]],t[201500]=[C["GR.IC.EMERGENCY MEDICAL OPERATION"]],t[201501]=[C["GR.IC.MEDICAL EVACUATION HELICOPTER"]],t[21e4]=[],t[210100]=[C["GR.EQ.LAND MINE"]],t[210200]=[C["GR.EQ.ANTIPERSONNEL LAND MINE"]],t[210300]=[C["GR.EQ.ANTITANK MINE"]],t[210400]=[C["GR.EQ.IMPROVISED EXPLOSIVE DEVICE"]],t[210500]=[C["GR.EQ.ANTIPERSONNEL LAND MINE LESS THAN LETHAL"]],t[22e4]=[],t[220100]=[C["GR.EQ.SENSOR"]],t[220200]=[C["GR.EQ.SENSOR EMPLACED"]],t[220300]=[C["GR.IC.RADAR"]],t[23e4]=[C["GR.IC.FF.EMERGENCY OPERATION"]],t[230100]=[C["GR.EQ.CIVILIAN VEHICLE.UTILITY VEHICLE"],C["GR.M1.MEDEVAC"]],t[230200]=[C["GR.IC.FIRE PROTECTION"]],t[24e4]=[C["GR.IC.MANUAL TRACK"]],t[25e4]=[C["GR.IC.AVIATION ROTARY WING"]],I["01"]=[C["GR.M1.BIOLOGICAL"]],I["02"]=[C["GR.M1.CHEMICAL"]],I["03"]=[C["GR.M1.EARLY WARNING RADAR"]],I["04"]=[C["GR.M1.INTRUSION"]],I["05"]=[C["GR.M1.NUCLEAR"]],I["06"]=[C["GR.M1.RADIOLOGICAL"]],I["07"]=[C["GR.M1.UPGRADED EARLY WARNING RADAR"]],I["08"]=[C["GR.M1.HIJACKING"]],I["09"]=[C["GR.M1.CIVILIAN"]],I[10]=[C["GR.M1.TILT-ROTOR"]],I[11]=[],I[12]=[C["GR.M1.MULTI-PURPOSE BLADE"]],I[13]=[C["GR.M1.TANK-WIDTH MINE PLOW"]],I[14]=[C["GR.M1.BRIDGING"]],I[15]=[C["GR.M1.CYBERSPACE"]],I[16]=[C["GR.M1.ARMORED"]],I[17]=[C["GR.M1.ATTACK"]],I[18]=[C["GR.M1.CARGO"]],I[19]=[C["GR.M1.MAINTENANCE"]],I[20]=[C["GR.M1.MEDEVAC"]],I[21]=[C["GR.IN.M1.PETROLEUM"]],I[22]=[C["GR.M1.UTILITY"]],I[23]=[C["GR.M1.WATER"]],I[24]=[C["GR.M1.ROBOTIC"]],E["01"]=[C["GR.M2.CYBERSPACE"]],E["02"]=[C["GR.M2.LIGHT"]],E["03"]=[C["GR.M2.MEDIUM"]],E["04"]=[C["GR.M2.RAILROAD"]],E["05"]=[C["GR.M2.TRACKED"]],E["06"]=[C["GR.M2.TRACTOR TRAILER"]],E["07"]=[C["GR.M2.WHEELED LIMITED"]],E["08"]=[C["GR.M2.WHEELED"]],E["09"]=[C["GR.M2.ROBOTIC"]];var T={11e4:140,110100:140,110101:140,110102:140,110103:140,110200:140,110201:140,110202:140,110203:140,110300:140,110301:140,110302:140,110303:140,110400:135,110500:140,110501:140,110502:140,110503:140,110600:140,110601:140,110602:140,110603:140,110700:140,110701:140,110702:140,110703:140,110800:140,110801:140,110802:140,110803:140,110900:140,110901:140,110902:140,110903:140,111e3:140,111001:140,111002:140,111003:140,111100:140,111101:140,111102:140,111103:140,111104:140,111105:140,111106:140,111107:140,111108:140,111109:140,111200:140,111201:140,111202:140,111203:140,111300:140,111301:140,111302:140,111303:140,111400:140,111401:140,111402:140,111403:140,111500:140,111501:140,111502:140,111503:140,111600:140,111601:140,111602:140,111603:140,111701:140,111702:140,111703:140,111800:140,111900:140,112e3:140,12e4:129,120100:129,120101:130,120102:130,120103:130,120104:130,120105:120,120106:120,120107:120,120108:130,120109:130,120110:140,120200:130,120201:130,120202:130,120203:130,120300:130,120301:130,120302:130,120303:130,13e4:129,130100:115,130200:130,130300:130,130400:135,130500:120,130600:120,130700:120,130701:130,130800:130,130801:130,130900:120,130901:130,130902:130,131e3:115,131001:130,131002:130,131003:140,131100:130,131101:130,131200:130,131300:130,131400:140,131500:140,131600:140,140100:130,140200:130,140300:130,140400:130,140500:130,140600:140,140601:140,140602:140,140603:140,140700:140,140800:140,140900:130,141e3:130,141100:140,141200:130,141201:130,141202:130,150100:130,150200:140,160100:132.5,160101:132.5,160102:132.5,160103:132.5,160200:132.5,160201:132.5,160202:132.5,160203:132.5,160300:132.5,160301:132.5,160302:132.5,160303:132.5,160400:132.5,160401:132.5,160402:132.5,160403:132.5,160500:132.5,160501:132.5,160502:132.5,160503:132.5,160600:132.5,160601:132.5,160602:132.5,160603:132.5,160700:132.5,160701:132.5,160702:132.5,160703:132.5,160800:115,160900:115,17e4:149.03125,170100:118.75,170200:133.21875,170300:135.21875,170400:118.75,170500:138.1875,170600:118.75,170700:118.75,170800:118,170900:118,171e3:135,171100:135,18e4:125,19e4:129,190100:129,190200:129,190300:129,190400:129,190500:129,200100:140,200200:118.75,200300:120,200400:140,200500:132,200600:118.75,200700:118.75,200800:118.75,200900:119.36222839355469,201e3:145,201100:120,201200:118,201300:124.36222076416016,201301:120,201302:120,201400:118.75,201500:140,201501:115,210100:122,210200:122,210300:122,210400:118.75,210500:122,220100:140,220200:136,220300:120,23e4:135,230100:132.5,230200:120,24e4:118.75};for(const S in T)T.hasOwnProperty(S)&&(e[S]={x1:50,x2:150,y1:50,y2:T[S]})}}},H={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A){"20"==R&&(t[11e4]=[C["GR.IC.MILITARY"]],t[110100]=[C["GR.IN.IC.AIRCRAFT PRODUCTION & ASSEMBLY"]],t[110200]=[L._scale(1.4,C["GR.IC.FF.CLASS V"])],t[110300]=[C["GR.IC.FF.CLASS V"],C["GR.IC.FF.SUPPLY"]],t[110400]=[C["GR.EQ.TANK"]],t[110500]=[C["ST.IC.BLACK LIST LOCATION"]],t[110600]=[C["GR.IC.CBRN"]],t[110700]=[C["GR.EQ.DOZER"]],t[110701]=[C["GR.IN.IC.BRIDGE"]],t[110800]=[C["GR.IC.EQUIPMENT MANUFACTURE"]],t[110900]=[C["GR.I.GOVERNMENT"]],t[111e3]=[C["ST.IC.GRAY LIST LOCATION"]],t[111100]=[C["ST.IC.MASS GRAVE LOCATION"]],t[111200]=[C["GR.IN.IC.MILITARY/CIVILIAN.MATERIEL"],C["GR.IC.FF.SUPPLY"]],t[111300]=[C["GR.IN.IC.MINE"]],t[111400]=[C["GR.EQ.MISSILE LAUNCHER"]],t[111500]=[L._scale(.8,C["AC.IC.RADIOACTIVE MATERIAL"])],t[111600]=[C["GR.IN.IC.MILITARY/CIVILIAN.PRINTED MEDIA"]],t[111700]=[C["ST.IC.SAFE HOUSE"]],t[111800]=[C["ST.IC.WHITE LIST LOCATION"]],t[111900]=[C["GR.EQ.TENT"]],t[111901]=[C["GR.EQ.TENT"],C["ST.M1.DISPLACED PERSONS, REFUGEES, AND EVACUEES"]],t[111902]=[C["GR.EQ.TENT"],C["GR.M1.TRAINING CAMP"]],t[112e3]=[C["GR.IN.IC.INDUSTRIAL SITE"],C["GR.IN.IC.WAREHOUSE/STORAGE FACILITY"]],t[112001]=[C["GR.IC.GRENADE"]],t[112100]=[C["GR.IC.FF.LAW ENFORCEMENT"]],t[112101]=[C["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],t[112102]=[C["GR.IC.FF.BORDER PATROL"]],t[112103]=[C["GR.IC.FF.CUSTOMS SERVICE"]],t[112104]=[C["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],t[112105]=[C["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],t[112106]=[C["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],t[112107]=[C["GR.IC.LAW ENFORCEMENT"]],t[112108]=[C["GR.IC.FF.PRISON"]],t[112109]=[C["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],t[112110]=[C["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],t[112111]=[C["GR.IC.LAW ENFORCEMENT VESSEL"]],t[112112]=[C["GR.IC.FF.US MARSHALS SERVICE"]],t[112200]=[C["GR.IC.FF.EMERGENCY OPERATION"]],t[112201]=[C["GR.IC.FIRE PROTECTION"]],t[112202]=[C["GR.IC.EMERGENCY MEDICAL OPERATION"]],t[112300]=[C["GR.IN.MC.HOME"]],t[12e4]=[],t[120100]=[C["GR.IN.IC.AGRICULTURE AND FOOD INFRASTRUCTURE"]],t[120101]=[C["GR.IN.IC.AGRICULTURAL LABORATORY"]],t[120102]=[C["GR.IN.IC.ANIMAL FEEDLOT"]],t[120103]=[C["ST.IC.FOOD DISTRIBUTION"],C["AC.M1.COMMERCIAL"]],t[120104]=[C["GR.IN.IC.FARM/RANCH"]],t[120105]=[C["ST.IC.FOOD DISTRIBUTION"]],t[120106]=[C["ST.IC.FOOD DISTRIBUTION"],C["AC.M1.PRODUCTION"]],t[120107]=[C["ST.IC.FOOD DISTRIBUTION"],C["AC.M1.RETAIL"]],t[120108]=[C["GR.IN.IC.GRAIN STORAGE"]],t[120200]=[C["AC.IC.BANKING FINANCE AND INSURANCE INFRASTRUCTURE"]],t[120201]=[C["GR.IN.IC.ATM"]],t[120202]=[C["GR.IN.IC.BANK"]],t[120203]=[C["GR.IN.IC.BULLION STORAGE"]],t[120204]=[C["GR.IN.IC.INFRASTRUCTURE.BANKING FINANCE AND INSURANCE  INFRASTRUCTURE.ECONOMIC INFRASTRUCTURE ASSET"]],t[120205]=[C["GR.IN.IC.FEDERAL RESERVE BANK"]],t[120206]=[C["GR.IN.IC.FINANCIAL EXCHANGE"]],t[120207]=[C["GR.IN.IC.FINANCIAL SERVICES, OTHER"]],t[120300]=[C["GR.IN.IC.COMMERCIAL INFRASTRUCTURE"]],t[120301]=[C["GR.IN.IC.CHEMICAL PLANT"]],t[120302]=[C["GR.IN.IC.FIREARMS MANUFACTURER"]],t[120303]=[C["GR.IN.IC.FIREARMS RETAILER"]],t[120304]=[C["GR.IN.IC.HAZARDOUS MATERIAL PRODUCTION"]],t[120305]=[C["GR.IN.IC.HAZARDOUS MATERIAL STORAGE"]],t[120306]=[C["GR.IN.IC.INDUSTRIAL SITE"]],t[120307]=[C["GR.IN.IC.LANDFILL"]],t[120308]=[C["GR.IN.IC.PHARMACEUTICAL MANUFACTURER"]],t[120309]=[C["GR.IN.IC.CONTAMINATED HAZARDOUS WASTE SITE"]],t[120310]=[C["GR.IN.IC.TOXIC RELEASE INVENTORY"]],t[120400]=[C["GR.IN.IC.EDUCATIONAL FACILITIES INFRASTRUCTURE"]],t[120401]=[C["GR.IN.IC.COLLEGE/UNIVERSITY"]],t[120402]=[C["GR.IN.IC.SCHOOL"]],t[120500]=[C["GR.IN.IC.ELECTRIC POWER"]],t[120501]=[L._scale(.6,C["GR.IN.IC.ELECTRIC POWER"],!0)],t[120502]=[L._translate(0,15,L._scale(.75,C["GR.IN.IC.ELECTRIC POWER"],!0)),C["AC.M1.GENERATION STATION"]],t[120503]=[C["GR.IN.IC.NATURAL GAS FACILITY"]],t[120504]=[L._scale(1.5,C["GR.IC.FF.CLASS III"])],t[120505]=[C["GR.IC.FF.CLASS III"]],t[120506]=[C["GR.IN.IC.PROPANE FACILITY"]],t[120600]=[C["GR.IN.IC.GOVERNMENT SITE INFRASTRUCTURE"]],t[120700]=[],t[120701]=[C["GR.IC.FF.MEDICAL"]],t[120702]=[C["GR.IC.FF.MEDICAL"],C["GR.IC.FF.MEDICAL TREATMENT FACILITY"]],t[120800]=[C["GR.IN.IC.MILITARY INFRASTRUCTURE"]],t[120801]=[C["GR.IN.IC.BASE"],C["AC.M1.MILITARY ARMORY"]],t[120802]=[C["GR.IN.IC.BASE"]],t[120803]=[C["GR.IN.IC.AIRPORT"]],t[120900]=[C["GR.IN.IC.POSTAL SERVICE INFRASTRUCTURE"]],t[120901]=[C["GR.IN.IC.POSTAL DISTRIBUTION CENTER"]],t[120902]=[C["GR.IN.IC.POST OFFICE"]],t[121e3]=[C["GR.IN.IC.PUBLIC VENUES INFRASTRUCTURE"]],t[121001]=[C["GR.IN.IC.ENCLOSED FACITLITY (PUBLIC VENUE)"]],t[121002]=[C["GR.IN.IC.OPEN FACILITY (OPEN VENUE)"]],t[121003]=[C["GR.IN.IC.RECREATIONAL AREA"]],t[121004]=[C["GR.IN.IC.RELIGIOUS INSTITUTION"]],t[121100]=[C["GR.IN.IC.SPECIAL NEEDS INFRASTRUCTURE"]],t[121101]=[C["GR.IN.IC.ADULT DAY CARE"]],t[121102]=[C["GR.IN.IC.CHILD DAY CARE"]],t[121103]=[C["GR.IN.IC.ELDER CARE"]],t[121200]=[C["GR.IN.IC.TELECOMMUNICATIONS INFRASTRUCTURE"]],t[121201]=[C["GR.IC.FF.BROADCAST TRANSMITTER ANTENNA"]],t[121202]=[C["GR.IN.IC.INFRASTRUCTURE.TELECOMMUNICATIONS INFRASTRUCTURE.TELECOMMUNICATIONS"]],t[121203]=[C["GR.IN.IC.TELECOMMUNICATIONS TOWER"]],t[121300]=[L._scale(1.5,C["GR.IC.TRANSPORTATION"])],t[121301]=[C["GR.IC.TRANSPORTATION"],C["GR.IC.AIRPORT OF DEBARKATION"]],t[121302]=[C["GR.IN.IC.AIR TRAFFIC CONTROL FACILITY"]],t[121303]=[C["GR.EQ.CIVILIAN VEHICLE.MULTIPLE PASSENGER VEHICLE"]],t[121304]=[C["GR.IC.FERRY"]],t[121305]=[C["GR.IN.IC.HELICOPTER LANDING SITE"]],t[121306]=[C["GR.IC.MAINTENANCE"]],t[121307]=[C["GR.IC.RAILHEAD"]],t[121308]=[C["GR.IN.IC.REST STOP"]],t[121309]=[C["GR.IC.TRANSPORTATION"],C["GR.M1.NAVAL"]],t[121310]=[C["GR.IC.NAVAL"],C["GR.M1.YARD"]],t[121311]=[C["GR.IN.IC.TOLL FACILITY"]],t[121312]=[C["GR.IN.IC.TRAFFIC INSPECTION FACILITY"]],t[121313]=[C["GR.IN.IC.TUNNEL"]],t[121400]=[C["GR.IC.WATER"]],t[121401]=[C["GR.IN.IC.CONTROL VALVE"]],t[121402]=[C["GR.IN.IC.DAM"]],t[121403]=[C["GR.IN.IC.DISCHARGE OUTFALL"]],t[121404]=[C["GR.IN.IC.GROUND WATER WELL"]],t[121405]=[C["GR.IN.IC.PUMPING STATION"]],t[121406]=[C["GR.IN.IC.RESERVOIR"]],t[121407]=[C["GR.IN.IC.STORAGE TOWER"]],t[121408]=[C["GR.IN.IC.SURFACE WATER INTAKE"]],t[121409]=[C["GR.IN.IC.WASTEWATER TREATMENT FACILITY"]],t[121410]=[C["GR.IC.WATER"]],t[121411]=[C["GR.IC.WATER PURIFICATION"]],I["01"]=[C["GR.M1.BIOLOGICAL"]],I["02"]=[C["GR.M1.CHEMICAL"]],I["03"]=[C["GR.M1.NUCLEAR"]],I["04"]=[C["GR.IN.M1.RADIOLOGICAL"]],I["05"]=[C["GR.M1.DECONTAMINATION"]],I["06"]=[C["GR.IN.M1.COAL"]],I["07"]=[C["GR.IN.M1.GEOTHERMAL"]],I["08"]=[C["GR.IN.M1.HYDROELECTRIC"]],I["09"]=[C["GR.IN.M1.NATURAL GAS"]],I[10]=[C["GR.IN.M1.PETROLEUM"]],I[11]=[C["GR.IN.M1.CIVILIAN"]],I[12]=[C["GR.IN.M1.CIVILIAN TELEPHONE"]],I[13]=[C["GR.IN.M1.CIVILIAN TELEVISION"]],I[14]=[C["GR.M1.CYBERSPACE"]],I[15]=[C["GR.M1.JOINT NETWORK NODE"]],I[16]=[C["GR.M1.COMMAND POST NODE"]],E["01"]=[C["GR.IN.M2.CHEMICAL & BIOLOGICAL WARFARE"]],E["02"]=[C["GR.IN.M2.CHEMICAL WARFARE PRODUCTION"]],E["03"]=[C["GR.IN.M2.NUCLEAR WARFARE PRODUCTION"]],E["04"]=[C["GR.IN.M2.RADIOLOGICAL WARFARE PRODUCTION"]],E["05"]=[C["GR.IN.M2.ATOMIC ENERGY REACTOR"]],E["06"]=[C["GR.IN.M2.NUCLEAR MATERIAL PRODUCTION"]],E["07"]=[C["GR.IN.M2.NUCLEAR MATERIAL STORAGE"]],E["08"]=[C["GR.IN.M2.WEAPONS GRADE PRODUCTION"]],E["09"]=[C["GR.M2.CYBERSPACE"]],E[10]=[C["GR.IN.M2.TRANSPORTATION"]])}},V={type:"number",getMetadata:m,getIcons:U,iconParts:w,icons:function(t,I,E,e,R,C,A){"30"==R&&(t[11e4]=[C["SE.IC.MILITARY"]],t[12e4]=[C["SE.IC.COMBATANT"]],t[120100]=[C["SE.IC.CARRIER"]],t[120200]=[C["SE.IC.SURFACE COMBATANT, LINE"]],t[120201]=[C["SE.IC.BATTLESHIP"]],t[120202]=[C["SE.IC.CRUISER, GUIDED MISSILE"]],t[120203]=[C["SE.IC.DESTROYER"]],t[120204]=[C["SE.IC.FRIGATE"]],t[120205]=[C["SE.IC.CORVETTE"]],t[120206]=[C["SE.IC.LITTORAL COMBATANT SHIP"]],t[120300]=[C["SE.IC.AMPHIBIOUS WARFARE SHIP"]],t[120301]=[C["SE.IC.AMPHIBIOUS FORCE FLAGSHIP"]],t[120302]=[C["SE.IC.AMPHIBIOUS ASSAULT"]],t[120303]=[C["SE.IC.AMPHIBIOUS ASSAULT SHIP, GENERAL"]],t[120304]=[C["SE.IC.AMPHIBIOUS ASSAULT SHIP, MULTI-PURPOSE"]],t[120305]=[C["SE.IC.AMPHIBIOUS ASSAULT SHIP, HELICOPTER"]],t[120306]=[C["SE.IC.AMPHIBIOUS TRANSPORT, DOCK"]],t[120307]=[C["SE.IC.LANDING SHIP"]],t[120308]=[C["SE.IC.LANDING CRAFT"]],t[120400]=[C["SE.IC.MINE WARFARE VESSEL"]],t[120401]=[C["SE.IC.MINELAYER"]],t[120402]=[C["SE.IC.MINESWEEPER"]],t[120403]=[C["SE.IC.MINESWEEPER, DRONE"]],t[120404]=[C["SE.IC.MINEHUNTER"]],t[120405]=[C["SE.IC.MINE COUNTERMEASURES"]],t[120406]=[C["SE.IC.MINE COUNTER MEASURE SUPPORT SHIP"]],t[120500]=[C["SE.IC.PATROL"]],t[120501]=[C["SE.IC.PATROL CRAFT"]],t[120502]=[C["SE.IC.PATROL GUN"]],t[120600]=[C["SE.IC.SEA SURFACE DECOY"]],t[120700]=[C["SE.IC.UNMANNED SURFACE WATER VEHICLE"]],t[120800]=[C["SE.IC.MILITARY SPEEDBOAT"]],t[120801]=[C["SE.IC.MILITARY SPEEDBOAT, RIGID-HULL INFLATABLE BOAT"]],t[120900]=[C["SE.IC.MILITARY JETSKI"]],t[121e3]=[C["SE.IC.NAVY TASK ORGANIZATION UNIT"]],t[121001]=[C["SE.IC.NAVY TASK ELEMENT"]],t[121002]=[C["SE.IC.NAVY TASK FORCE"]],t[121003]=[C["SE.IC.NAVY TASK GROUP"]],t[121004]=[C["SE.IC.NAVY TASK UNIT"]],t[121005]=[C["SE.IC.CONVOY"]],t[121100]=[C["SE.IC.RADAR"]],t[13e4]=[C["SE.IC.NONCOMBATANT"]],t[130100]=[C["SE.IC.AUXILIARY SHIP"]],t[130101]=[C["SE.IC.AMMUNITION SHIP"]],t[130102]=[C["SE.IC.STORES SHIP"]],t[130103]=[C["SE.IC.AUXILIARY FLAG OR COMMAND SHIP"]],t[130104]=[C["SE.IC.INTELLIGENCE COLLECTOR"]],t[130105]=[C["SE.IC.OCEAN RESEARCH SHIP"]],t[130106]=[C["SE.IC.SURVEY SHIP"]],t[130107]=[C["SE.IC.HOSPITAL SHIP"]],t[130108]=[C["SE.IC.CARGO SHIP"]],t[130109]=[C["SE.IC.COMBAT SUPPORT SHIP, FAST"]],t[130110]=[C["SE.IC.OILER, REPLENISHMENT"]],t[130111]=[C["SE.IC.REPAIR SHIP"]],t[130112]=[C["SE.IC.SUBMARINE TENDER"]],t[130113]=[C["SE.IC.TUG, OCEAN GOING"]],t[130200]=[C["SE.IC.SERVICE CRAFT, YARD, GENERAL"]],t[130201]=[C["SE.IC.BARGE, NOT SELF-PROPELLED"]],t[130202]=[C["SE.IC.BARGE, SELF-PROPELLED"]],t[130203]=[C["SE.IC.TUG, HARBOUR"]],t[130204]=[C["SE.IC.LAUNCH"]],t[14e4]=[C["SE.IC.CIVILIAN"]],t[140100]=[C["SE.IC.MERCHANT SHIP, GENERAL"]],t[140101]=[C["SE.IC.CARGO, GENERAL"]],t[140102]=[C["SE.IC.CONTAINER SHIP"]],t[140103]=[C["SE.IC.DREDGE"]],t[140104]=[C["SE.IC.ROLL ON-ROLL OFF"]],t[140105]=[C["SE.IC.FERRY"]],t[140106]=[C["SE.IC.HEAVY LIFT"]],t[140107]=[C["SE.IC.HOVERCRAFT 2525D"]],t[140108]=[C["SE.IC.MERCHANT SHIP, LASH CARRIER (WITH BARGES)"]],t[140109]=[C["SE.IC.OILER/TANKER"]],t[140110]=[C["SE.IC.PASSENGER SHIP"]],t[140111]=[C["SE.IC.TUG, OCEAN GOING CIVILIAN"]],t[140112]=[C["SE.IC.TOW"]],t[140113]=[C["SE.IC.TRANSPORT SHIP, HAZARDOUS MATERIAL"]],t[140114]=[C["SE.IC.JUNK/DHOW"]],t[140115]=[C["SE.IC.BARGE, NOT SELF-PROPELLED CIV"]],t[140116]=[C["SE.IC.HOSPITAL SHIP CIV"]],t[140200]=[C["SE.IC.FISHING VESSEL"]],t[140201]=[C["SE.IC.DRIFTER"]],t[140202]=[C["SE.IC.TRAWLER"]],t[140203]=[C["SE.IC.FISHING VESSEL DREDGE"]],t[140300]=[C["SE.IC.LAW ENFORCEMENT VESSEL"]],t[140400]=[C["SE.IC.LEISURE CRAFT, SAILING BOAT"]],t[140500]=[C["SE.IC.LEISURE CRAFT, MOTORIZED"]],t[140501]=[C["SE.IC.LEISURE CRAFT, MOTORIZED, RIGID-HULL INFLATABLE BOAT"]],t[140502]=[C["SE.IC.LEISURE CRAFT, MOTORIZED, SPEEDBOAT"]],t[140600]=[C["SE.IC.LEISURE CRAFT, JETSKI"]],t[140700]=[C["SE.IC.UNMANNED SURFACE WATER VEHICLE (USV)"]],t[15e4]=[C["SE.IC.OWN SHIP"]],t[16e4]=[C["SE.IC.FUSED TRACK"]],t[17e4]=[C["SE.IC.MANUAL TRACK"]],I["01"]=[C["SE.M1.OWN SHIP"]],I["02"]=[C["SE.M1.ANTIAIR WARFARE"]],I["03"]=[C["SE.M1.ANTISUBMARINE WARFARE"]],I["04"]=[C["SE.M1.ESCORT"]],I["05"]=[C["SE.M1.ELECTRONIC WARFARE"]],I["06"]=[C["SE.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]],I["07"]=[C["SE.M1.MINE COUNTER MEASURES"]],I["08"]=[C["SE.M1.MISSILE DEFENSE"]],I["09"]=[C["SE.M1.MEDICAL"]],I[10]=[C["SE.M1.MINE WARFARE"]],I[11]=[C["SE.M1.REMOTE MULTI-MISSION VEHIHLE"]],I[12]=[C["SE.M1.SPECIAL OPERATIONS FORCE"]],I[13]=[C["SE.M1.SURFACE WARFARE"]],I[14]=[C["SE.M1.BALLISTIC MISSILE"]],I[15]=[C["SE.M1.GUIDED MISSILE"]],I[16]=[C["SE.M1.OTHER GUIDED MISSILE"]],I[17]=[C["SE.M1.TORPEDO"]],I[18]=[C["SE.M1.DRONE-EQUIPPED"]],I[19]=[C["SE.M1.HELICOPTER-EQUIPPED"]],I[20]=[C["SE.M1.BALLISTIC MISSILE DEFENSE, SHOOTER"]],I[21]=[C["SE.M1.BALLISTIC MISSILE DEFENSE, LONG- RANGE SURVEILLANCE AND TRACK (LRS&T)"]],I[22]=[C["SE.M1.SEA-BASE X-BAND"]],I[23]=[C["SE.M1.HIJACKING/HIJACKED"]],I[24]=[C["SE.M1.HIJACKER"]],I[25]=[C["SE.M1.CYBERSPACE"]],E["01"]=[C["SE.M2.NUCLEAR POWERED"]],E["02"]=[C["SE.M2.HEAVY"]],E["03"]=[C["SE.M2.LIGHT"]],E["04"]=[C["SE.M2.MEDIUM"]],E["05"]=[C["SE.M2.DOCK"]],E["06"]=[C["SE.M2.LOGISTICS"]],E["07"]=[C["SE.M2.TANK"]],E["08"]=[C["SE.M2.VEHICLE"]],E["09"]=[C["SE.M2.FAST"]],E[10]=[C["SE.M2.AIR-CUSHIONED (USA ONLY)"]],E[11]=[C["SE.M2.AIR-CUSHIONED"]],E[12]=[C["SE.M2.HYDROFOIL"]],E[13]=[C["SE.M2.AUTONOMOUS CONTROL"]],E[14]=[C["SE.M2.REMOTELY PILOTED"]],E[15]=[C["SE.M2.EXPENDABLE"]],E[16]=[C["SE.M2.CYBERSPACE"]])}},J={type:"number",getMetadata:m,getIcons:U,iconParts:o,icons:function(t,I,E,e,R,C,A){"35"==R&&(t[11e4]=[C["SU.IC.MILITARY"]],t[110100]=[C["SU.IC.SUBMARINE"]],t[110101]=[C["SU.IC.SUBMARINE, SURFACED"]],t[110102]=[C["SU.IC.SUBMARINE, SNORKELING"]],t[110103]=[C["SU.IC.SUBMARINE, BOTTOMED"]],t[110200]=[C["SU.IC.OTHER SUBMERSIBLE"]],t[110300]=[C["SU.IC.NON-SUBMARINE"]],t[110400]=[C["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV)"]],t[110500]=[C["SU.IC.DIVER, MILITARY"]],t[12e4]=[C["SU.IC.CIVILIAN"]],t[120100]=[C["SU.IC.SUBMERSIBLE, CIVILIAN"]],t[120200]=[C["SU.IC.AUTONOMOUS UNDERWATER VEHICLE/ UNMANNED UNDERWATER VEHICLE (AUV/UUV), CIVILIAN"]],t[120300]=[C["SU.IC.DIVER, CIVILIAN"]],t[13e4]=[C["SU.IC.UNDERWATER WEAPON"]],t[130100]=[C["SU.IC.TORPEDO"]],t[130200]=[C["SU.IC.IMPROVISED EXPLOSIVE DEVICE (IED)"]],t[130300]=[C["SU.IC.UNDERWATER DECOY DSymbol"]],t[14e4]=[C["SU.IC.ECHO TRACKER CLASSIFIER (ETC)/POSSIBLE CONTACT (POSCON)"]],t[15e4]=[C["SU.IC.FUSED TRACK"]],t[16e4]=[C["SU.IC.MANUAL TRACK"]],t[2e5]=[C["SU.IC.SEABED INSTALLATION, MAN-MADE, MILITARY"]],t[21e4]=[C["SU.IC.SEABED INSTALLATION, MAN-MADE, NON-MILITARY"]],I["01"]=[C["SU.M1.ANTISUBMARINE WARFARE"]],I["02"]=[C["SU.M1.AUXILIARY"]],I["03"]=[C["SU.M1.COMMAND AND CONTROL"]],I["04"]=[C["SU.M1.INTELLIGENCE, SURVEILLANCE, RECONNAISSANCE"]],I["05"]=[C["SU.M1.MINE COUNTERMEASURES"]],I["06"]=[C["SU.M1.MINE WARFARE"]],I["07"]=[C["SU.M1.SURFACE WARFARE"]],I["08"]=[C["SU.M1.ATTACK"]],I["09"]=[C["SU.M1.BALLISTIC MISSILE"]],I[10]=[C["SU.M1.GUIDED MISSILE"]],I[11]=[C["SU.M1.OTHER GUIDED MISSILES (POINT DEFENCE)"]],I[12]=[C["SU.M1.SPECIAL OPERATIONS FORCE"]],I[13]=[C["SU.M1.POSSIBLE SUBMARINE - LOW 1"]],I[14]=[C["SU.M1.POSSIBLE SUBMARINE - LOW 2"]],I[15]=[C["SU.M1.POSSIBLE SUBMARINE - HIGH 3"]],I[16]=[C["SU.M1.POSSIBLE SUBMARINE - HIGH 4"]],I[17]=[C["SU.M1.PROBABLE SUBMARINE"]],I[18]=[C["SU.M1.CERTAIN SUBMARINE"]],I[19]=[C["SU.M1.ANTI-TORPEDO TORPEDO"]],I[20]=[C["SU.M1.HIJACKING/HIJACKED"]],I[21]=[C["SU.M1.HIJACKER"]],I[22]=[C["SU.M1.CYBERSPACE"]],E["01"]=[C["SU.M2.AIR INDEPENDENT PROPULSION"]],E["02"]=[C["SU.M2.DIESEL PROPULSION"]],E["03"]=[C["SU.M2.DIESEL - TYPE 1"]],E["04"]=[C["SU.M2.DIESEL - TYPE 2"]],E["05"]=[C["SU.M2.DIESEL - TYPE 3"]],E["06"]=[C["SU.M2.NUCLEAR POWERED"]],E["07"]=[C["SU.M2.NUCLEAR - TYPE 1"]],E["08"]=[C["SU.M2.NUCLEAR - TYPE 2"]],E["09"]=[C["SU.M2.NUCLEAR - TYPE 3"]],E[10]=[C["SU.M2.NUCLEAR - TYPE 4"]],E[11]=[C["SU.M2.NUCLEAR - TYPE 5"]],E[12]=[C["SU.M2.NUCLEAR - TYPE 6"]],E[13]=[C["SU.M2.NUCLEAR - TYPE 7"]],E[14]=[C["SU.M2.AUTONOMOUS CONTROL"]],E[15]=[C["SU.M2.REMOTELY PILOTED"]],E[16]=[C["SU.M2.EXPENDABLE"]],E[17]=[C["SU.M2.CYBERSPACE"]])}},q={type:"number",getMetadata:m,getIcons:U,iconParts:o,icons:function(t,I,E,e,R,C,A){"36"==R&&(t[11e4]=[C["SU.IC.SEA MINE"]],t[110100]=[C["SU.IC.SEA MINE - BOTTOM"]],t[110200]=[C["SU.IC.SEA MINE - MOORED"]],t[110300]=[C["SU.IC.SEA MINE - FLOATING"]],t[110400]=[C["SU.IC.SEA MINE - RISING"]],t[110500]=[C["SU.IC.SEA MINE (IN OTHER POSITION)"]],t[110600]=[C["SU.IC.SEA MINE - KINGFISHER"]],t[110700]=[C["SU.IC.SEA MINE - SMALL OBJECT"]],t[110800]=[C["SU.IC.SEA MINE EXERCISE MINE"]],t[110801]=[C["SU.IC.SEA MINE EXERCISE MINE - BOTTOM"]],t[110802]=[C["SU.IC.SEA MINE EXERCISE MINE - MOORED"]],t[110803]=[C["SU.IC.SEA MINE EXERCISE MINE - FLOATING"]],t[110804]=[C["SU.IC.SEA MINE EXERCISE MINE - RISING"]],t[110900]=[C["SU.IC.SEA MINE NEUTRALIZED"]],t[110901]=[C["SU.IC.SEA MINE NEUTRALIZED - BOTTOM"]],t[110902]=[C["SU.IC.SEA MINE NEUTRALIZED - MOORED"]],t[110903]=[C["SU.IC.SEA MINE NEUTRALIZED - FLOATING"]],t[110904]=[C["SU.IC.SEA MINE NEUTRALIZED - RISING"]],t[110905]=[C["SU.IC.SEA MINE (IN OTHER POSITION) NEUTRALIZED"]],t[12e4]=[C["SU.IC.UNEXPLODED EXPLOSIVE ORDNANCE"]],t[13e4]=[C["SU.IC.SEA MINE DECOY"]],t[130100]=[C["SU.IC.SEA MINE DECOY, BOTTOM/GROUND"]],t[130200]=[C["SU.IC.SEA MINE DECOY, MOORED"]],t[14e4]=[],t[140100]=[L._scale(1.3,C["SU.IC.SEA MINE MILCO"])],t[140101]=[L._scale(1.3,[C["SU.IC.SEA MINE MILCO"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]])],t[140102]=[L._scale(1.3,[C["SU.IC.SEA MINE MILCO"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]])],t[140103]=[L._scale(1.3,[C["SU.IC.SEA MINE MILCO"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]])],t[140104]=[L._scale(1.3,[C["SU.IC.SEA MINE MILCO"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]])],t[140105]=[L._scale(1.3,[C["SU.IC.SEA MINE MILCO"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]])],t[140200]=[C["SU.IC.SEA MINE MILCO - BOTTOM"]],t[140201]=[C["SU.IC.SEA MINE MILCO - BOTTOM"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],t[140202]=[C["SU.IC.SEA MINE MILCO - BOTTOM"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],t[140203]=[C["SU.IC.SEA MINE MILCO - BOTTOM"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],t[140204]=[C["SU.IC.SEA MINE MILCO - BOTTOM"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],t[140205]=[C["SU.IC.SEA MINE MILCO - BOTTOM"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],t[140300]=[C["SU.IC.SEA MINE MILCO - MOORED"]],t[140301]=[C["SU.IC.SEA MINE MILCO - MOORED"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],t[140302]=[C["SU.IC.SEA MINE MILCO - MOORED"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],t[140303]=[C["SU.IC.SEA MINE MILCO - MOORED"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],t[140304]=[C["SU.IC.SEA MINE MILCO - MOORED"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],t[140305]=[C["SU.IC.SEA MINE MILCO - MOORED"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],t[140400]=[C["SU.IC.SEA MINE MILCO - FLOATING"]],t[140401]=[C["SU.IC.SEA MINE MILCO - FLOATING"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 1"]],t[140402]=[C["SU.IC.SEA MINE MILCO - FLOATING"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 2"]],t[140403]=[C["SU.IC.SEA MINE MILCO - FLOATING"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 3"]],t[140404]=[C["SU.IC.SEA MINE MILCO - FLOATING"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 4"]],t[140405]=[C["SU.IC.SEA MINE MILCO - FLOATING"],C["SU.IC.SEA MINE MILCO - GENERAL, CONFIDENCE LEVEL 5"]],t[15e4]=[L._scale(1.3,C["SU.IC.SEA MINE MILEC"])],t[150100]=[C["SU.IC.SEA MINE MILEC - BOTTOM"]],t[150200]=[C["SU.IC.SEA MINE MILEC - MOORED"]],t[150300]=[C["SU.IC.SEA MINE MILEC - FLOATING"]],t[16e4]=[L._scale(1.3,C["SU.IC.SEA MINE NEGATIVE REACQUISITION"])],t[160100]=[C["SU.IC.SEA MINE NEGATIVE REACQUISITION - BOTTOM"]],t[160200]=[C["SU.IC.SEA MINE NEGATIVE REACQUISITION - MOORED"]],t[160300]=[C["SU.IC.SEA MINE NEGATIVE REACQUISITION - FLOATING"]],t[17e4]=[L._scale(1.3,C["SU.IC.SEA MINE GENERAL OBSTRUCTOR"])],t[170100]=[C["SU.IC.SEA MINE GENERAL OBSTRUCTOR NEUTRALIZED"]],t[18e4]=[L._scale(1.3,C["SU.IC.SEA MINE MINE ANCHOR"])],t[19e4]=[L._scale(1.3,C["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT"])],t[190100]=[C["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - BOTTOM"]],t[190200]=[C["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - MOORED"]],t[190300]=[C["SU.IC.SEA MINE NON-MINE MINE-LIKE CONTACT - FLOATING"]],t[2e5]=[C["SU.IC.ENVIRONMENTAL REPORT LOCATION"]],t[21e4]=[C["SU.IC.DIVE REPORT LOCATION"]])}},j={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A){"40"==R&&(t[11e4]=[],t[110100]=[C["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"]],t[110101]=[L._scale(1.5,C["ST.IC.ARREST"])],t[110102]=[C["ST.IC.ARSON/FIRE"]],t[110103]=[C["ST.IC.INDIVIDUAL"],C["ST.IC.ATTEMPTED CRIMINAL ACTIVITY"]],t[110104]=[C["ST.IC.DRIVE-BY SHOOTING"]],t[110105]=[C["ST.IC.DRUG RELATED ACTIVITIES"]],t[110106]=[C["ST.IC.EXTORTION"]],t[110107]=[C["ST.IC.GRAFFITI"]],t[110108]=[C["ST.IC.KILLING VICTIM"]],t[110109]=[C["ST.IC.POISONING"]],t[110110]=[C["ST.IC.RIOT"]],t[110111]=[L._scale(1.5,C["ST.IC.BOOBY TRAP"])],t[110112]=[C["ST.IC.HOUSE"],C["ST.M1.EVICTION"]],t[110113]=[C["ST.IC.BLACK MARKETING"]],t[110114]=[C["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"]],t[110115]=[C["GR.IC.FF.JAIL BREAK"]],t[110116]=[C["ST.IC.ROBBERY"]],t[110117]=[C["ST.IC.THEFT"]],t[110118]=[C["ST.IC.BURGLARY"]],t[110119]=[C["ST.IC.SMUGGLING"]],t[110120]=[C["ST.IC.ROCK THROWING"]],t[110121]=[C["ST.IC.COMPOSITE LOSS"],C["ST.M1.DEAD BODY"]],t[110122]=[C["ST.IC.SABOTAGE"]],t[110123]=[L._translate(0,10,L._scale(.8,C["AC.IC.CRIMINAL.ACTIVITY.INCIDENT"])),C["AC.M1.THREAT"]],t[110200]=[C["ST.IC.BOMB"]],t[110201]=[C["ST.IC.BOMB"],C["AC.M1.THREAT"]],t[110300]=[C["ST.IC.IED"]],t[110301]=[C["ST.IC.EXPLOSION"],C["ST.IC.IED"]],t[110302]=[L._translate(0,15,L._scale(.7,[C["ST.IC.EXPLOSION"],C["ST.IC.IED"]])),C["ST.M1.PREMATURE"]],t[110303]=[C["ST.IC.IED"],C["GR.IC.FF.SUPPLY"]],t[110304]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.IED"]],t[110400]=[C["AC.IC.SHOOTING"]],t[110401]=[C["ST.IC.SNIPING"]],t[110500]=[C["ST.IC.ILLEGAL DRUG OPERATION"]],t[110501]=[C["ST.IC.ILLEGAL DRUG OPERATION"],C["ST.M1.TRAFFICKING"]],t[110502]=[C["ST.IC.ILLEGAL DRUG OPERATION"],C["ST.M1.LABRATORY"]],t[110600]=[C["ST.IC.EXPLOSION"]],t[110601]=[C["ST.IC.EXPLOSION"],C["ST.IC.GRENADE"]],t[110602]=[C["ST.IC.EXPLOSION"],C["ST.IC.INCENDIARY"]],t[110603]=[C["ST.IC.EXPLOSION"],C["ST.IC.MINE"]],t[110604]=[C["ST.IC.EXPLOSION"],L._scale(.6,C["GR.EQ.MORTAR"],!0)],t[110605]=[C["ST.IC.EXPLOSION"],L._scale(.6,C["GR.EQ.SINGLE ROCKET LAUNCHER"],!0)],t[110606]=[L._scale(.7,C["ST.IC.BOMB"]),C["ST.IC.EXPLOSION"]],t[110700]=[C["GR.IN.MC.HOME"]],t[12e4]=[C["AC.IC.CRIMINAL.CIVIL DISTURBANCE"]],t[120100]=[C["ST.IC.DEMONSTRATION"]],t[13e4]=[],t[130100]=[C["ST.IC.PATROLLING"]],t[130200]=[C["ST.IC.PSYCHOLOGICAL OPERATIONS"]],t[130201]=[C["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"]],t[130300]=[C["ST.IC.SEARCHING"]],t[130400]=[],t[130401]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.WILLING"]],t[130402]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.COERCED/IMPRESSED"]],t[130500]=[C["ST.IC.MINE LAYING"]],t[130600]=[C["ST.IC.SPY"]],t[130700]=[C["ST.IC.WARRANT SERVED"]],t[130800]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.EXFILTRATION"]],t[130900]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.INFILTRATION"]],t[131e3]=[C["ST.IC.GROUP"],C["ST.M1.MEETING"]],t[131001]=[C["ST.IC.POLLING PLACE/ELECTION"]],t[131100]=[C["ST.IC.HOUSE"],C["ST.M1.RAID"]],t[131200]=[C["GR.IC.FF.EMERGENCY OPERATION"]],t[131201]=[L._scale(.7,C["GR.IC.FF.EMERGENCY OPERATION"]),C["AC.M1.EMERGENCY COLLECTION EVACUATION POINT"]],t[131202]=[C["ST.IC.FOOD DISTRIBUTION"]],t[131203]=[L._scale(.7,C["GR.IC.FF.EMERGENCY OPERATION"]),C["AC.M1.EMERGENCY INCIDENT COMMAND CENTER"]],t[131204]=[L._scale(.7,C["GR.IC.FF.EMERGENCY OPERATION"]),C["AC.M1.EMERGENCY OPERATIONS CENTER"]],t[131205]=[C["AC.IC.EMERGENCY PUBLIC INFORMATION CENTER"]],t[131206]=[L._scale(.7,C["GR.IC.FF.EMERGENCY OPERATION"]),C["AC.M1.EMERGENCY SHELTER"]],t[131207]=[L._scale(.7,C["GR.IC.FF.EMERGENCY OPERATION"]),C["AC.M1.EMERGENCY STAGING AREA"]],t[131208]=[C["GR.IC.FF.SUPPLY"],C["GR.IC.WATER"]],t[131300]=[C["GR.IC.EMERGENCY MEDICAL OPERATION"]],t[131301]=[C["AC.IC.EMT STATION LOCATION"]],t[131302]=[C["AC.IC.HEALTH DEPARTMENT FACILITY"]],t[131303]=[C["AC.IC.MEDICAL FACILITIES OUTPATIENT"]],t[131304]=[C["AC.IC.OPERATION/EMERGENCY MEDICAL OPERATION"]],t[131305]=[C["AC.IC.PHARMACY"]],t[131306]=[C["AC.IC.TRIAGE"]],t[131400]=[C["GR.IC.FIRE PROTECTION"]],t[131401]=[C["AC.IC.FIRE HYDRANT"]],t[131402]=[L._scale(1.5,C["GR.IC.FIRE PROTECTION"])],t[131403]=[C["AC.IC.OTHER WATER SUPPLY LOCATION"]],t[131500]=[C["GR.IC.FF.LAW ENFORCEMENT"]],t[131501]=[C["GR.IC.BUREAU OF ALCOHOL, TOBACCO, FIREARMS AND EXPLOSIVES (ATF) (DEPARTMENT OF JUSTICE)"]],t[131502]=[C["GR.IC.FF.BORDER PATROL"]],t[131503]=[C["GR.IC.FF.CUSTOMS SERVICE"]],t[131504]=[C["GR.IC.DRUG ENFORCEMENT AGENCY (DEA)"]],t[131505]=[C["GR.IC.FF.DEPARTMENT OF JUSTICE (DOJ)"]],t[131506]=[C["GR.IC.FEDERAL BUREAU OF INVESTIGATION (FBI)"]],t[131507]=[C["GR.IC.LAW ENFORCEMENT"]],t[131508]=[C["GR.IC.FF.PRISON"]],t[131509]=[C["GR.IC.UNITED STATES SECRET SERVICE(TREAS) (USSS)"]],t[131510]=[C["GR.IC.TRANSPORTATION SECURITY AGENCY (TSA)"]],t[131511]=[C["GR.IC.LAW ENFORCEMENT VESSEL"]],t[131512]=[C["GR.IC.FF.US MARSHALS SERVICE"]],t[131513]=[C["ST.IC.INTERNAL SECURITY FORCE"]],t[14e4]=[C["AC.IC.FIRE EVENT"]],t[140100]=[C["AC.IC.FIRE ORIGIN"]],t[140200]=[C["AC.IC.SMOKE"]],t[140300]=[C["AC.IC.HOT SPOT"]],t[140400]=[C["AC.IC.NON-REsIdENTIAL FIRE"]],t[140500]=[C["AC.IC.REsIdENTIAL FIRE"]],t[140600]=[C["AC.IC.SCHOOL FIRE"]],t[140700]=[C["AC.IC.SPECIAL NEEDS FIRE"]],t[140800]=[C["AC.IC.WILD FIRE"]],t[15e4]=[],t[150100]=[C["AC.IC.HAZARDOUS MATERIALS INCIDENT"]],t[150101]=[C["AC.IC.CHEMICAL AGENT"]],t[150102]=[C["AC.IC.CORROSIVE MATERIAL"]],t[150103]=[C["AC.IC.HAZARDOUS WHEN WET"]],t[150104]=[C["AC.IC.EXPLOSIVE MATERIAL"]],t[150105]=[C["AC.IC.FLAMMABLE GAS"]],t[150106]=[C["AC.IC.FLAMMABLE LIQUID"]],t[150107]=[C["AC.IC.FLAMMABLE SOLID"]],t[150108]=[C["AC.IC.NON-FLAMMABLE GAS"]],t[150109]=[C["AC.IC.ORGANIC PEROXIDE"]],t[150110]=[C["AC.IC.OXIDIZER"]],t[150111]=[C["AC.IC.RADIOACTIVE MATERIAL"]],t[150112]=[C["AC.IC.SPONTANEOUSLY COMBUSTIBLE MATERIAL"]],t[150113]=[C["AC.IC.TOXIC GAS"]],t[150114]=[C["AC.IC.TOXIC INFECTIOUS MATERIAL"]],t[150115]=[C["AC.IC.UNEXPLODED ORDNANCE"]],t[16e4]=[C["GR.IC.TRANSPORTATION"]],t[160100]=[C["ST.IC.HIJACKING (AIRPLANE)"]],t[160200]=[C["ST.IC.HIJACKING (BOAT)"]],t[160300]=[C["GR.EQ.TRAIN LOCOMOTIVE"]],t[160400]=[C["ST.IC.KNOWN INSURGENT VEHICLE"]],t[160500]=[C["ST.IC.EXPLOSION"],L._scale(.7,C["ST.IC.KNOWN INSURGENT VEHICLE"])],t[17e4]=[C["ST.IC.NATURAL EVENT"]],t[170100]=[C["ST.IC.GEOLOGIC"]],t[170101]=[C["AC.IC.AFTERSHOCK"]],t[170102]=[C["AC.IC.AVALANCHE"]],t[170103]=[C["AC.IC.EARTHQUAKE EPICENTER"]],t[170104]=[C["AC.IC.LANDSLIDE"]],t[170105]=[C["AC.IC.SUBSIDENCE"]],t[170106]=[C["AC.IC.VOLCANIC ERUPTION"]],t[170107]=[C["AC.IC.VOLCANIC THREAT"]],t[170108]=[C["AC.IC.CAVE ENTRANCE"]],t[170200]=[C["ST.IC.HYDRO-METEOROLOGICAL"]],t[170201]=[C["AC.IC.DROUGHT"]],t[170202]=[C["AC.IC.FLOOD"]],t[170203]=[C["AC.IC.TSUNAMI"]],t[170300]=[C["ST.IC.INFESTATION"]],t[170301]=[C["AC.IC.BIRD"]],t[170302]=[C["AC.IC.INSECT"]],t[170303]=[C["AC.IC.MICROBIAL"]],t[170304]=[C["AC.IC.REPTILE"]],t[170305]=[C["AC.IC.RODENT"]],t[18e4]=[],t[180100]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.LEADER"],C["ST.M2.RELIGIOUS"]],t[180200]=[C["ST.IC.INDIVIDUAL"],C["ST.M1.SPEAKER"]],t[180300]=[C["GR.IC.ISOLATED PERSONNEL"]],I["01"]=[C["ST.M1.ASSASSINATION"]],I["02"]=[C["ST.M1.EXECUTION (WRONGFUL KILLING)"]],I["03"]=[C["ST.M1.HIJACKING/HIJACKED"]],I["04"]=[C["ST.M1.HOUSE-TO-HOUSE"]],I["05"]=[C["ST.M1.KIDNAPPING"]],I["06"]=[C["ST.M1.MURDER"]],I["07"]=[C["ST.M1.PIRACY"]],I["08"]=[C["ST.M1.RAPE"]],I["09"]=[C["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],I[10]=[C["ST.M1.PIRATE"]],I[11]=[C["ST.M1.FALSE"]],I[12]=[C["ST.M1.FIND"]],I[13]=[C["ST.M1.FOUND AND CLEARED"]],I[14]=[C["ST.M1.HOAX (DECOY)"]],I[15]=[C["ST.M1.ATTEMPTED"]],I[16]=[C["ST.M1.ACCIDENT"]],I[17]=[C["ST.M1.INCIDENT"]],I[18]=[C["ST.M1.THEFT"]],I[19]=[C["GR.M1.HIJACKER"]],I[20]=[C["GR.M1.CYBERSPACE"]],I[21]=[C["AC.M1.EVICTION"]],I[22]=[C["AC.M1.RAID"]],E["01"]=[C["GR.M2.CYBERSPACE"]],E["02"]=[C["GR.M2.SECURITY FORCE ASSISTANCE"]])}},$={type:"number",getMetadata:m,getIcons:U,iconParts:Z,icons:function(t,I,E,e,R,C,A){"50"!=R&&"51"!=R&&"52"!=R&&"53"!=R&&"54"!=R||(t[11e4]=[],t[110100]=[C["SI.IC.COMMUNICATIONS"]],t[110200]=[C["SI.I.JAMMER / ELECTRONIC COUNTER-MEASURES"]],t[110300]=[C["SI.IC.RADAR"]],I["01"]=[C["SI.M1.ANTI-AIRCRAFT FIRE CONTROL"]],I["02"]=[C["SI.M1.AIRBORNE SEARCH AND BOMBING"]],I["03"]=[C["SI.M1.AIRBORNE INTERCEPT"]],I["04"]=[C["SI.M1.ALTIMETER"]],I["05"]=[C["SI.M1.AIRBORNE RECONNAISSANCE AND MAPPING"]],I["06"]=[C["SI.M1.AIR TRAFFIC CONTROL"]],I["07"]=[C["SI.M1.BEACON TRANSPONDER (NOT IFF)"]],I["08"]=[C["SI.M1.BATTLEFIELD SURVEILLANCE"]],I["09"]=[C["SI.M1.CONTROLLED APPROACH"]],I[10]=[C["SI.M1.CONTROLLED INTERCEPT"]],I[11]=[C["SI.M1.CELLULAR/MOBILE"]],I[12]=[C["SI.M1.COASTAL SURVEILLANCE"]],I[13]=[C["SI.M1.DECOY/MIMIC"]],I[14]=[C["SI.M1.DATA TRANSMISSION"]],I[15]=[C["SI.M1.EARTH SURVEILLANCE"]],I[16]=[C["SI.M1.EARLY WARNING"]],I[17]=[C["SI.M1.FIRE CONTROL"]],I[18]=[C["SI.M1.GROUND MAPPING"]],I[19]=[C["SI.M1.HEIGHT FINDING"]],I[20]=[C["SI.M1.HARBOR SURVEILLANCE"]],I[21]=[C["SI.M1.IDENTIFICATION, FRIEND OR FOE (INTERROGATOR)"]],I[22]=[C["SI.M1.INSTRUMENT LANDING SYSTEM"]],I[23]=[C["SI.M1.IONOSPHERIC SOUNDING"]],I[24]=[C["SI.M1.IDENTIFICATION, FRIEND OR FOE (TRANSPONDER)"]],I[25]=[C["SI.M1.BARRAGE JAMMER"]],I[26]=[C["SI.M1.CLICK JAMMER"]],I[27]=[C["SI.M1.DECEPTIVE JAMMER"]],I[28]=[C["SI.M1.FREQUENCY SWEPT JAMMER"]],I[29]=[C["SI.M1.JAMMER (GENERAL)"]],I[30]=[C["SI.M1.NOISE JAMMER"]],I[31]=[C["SI.M1.PULSED JAMMER"]],I[32]=[C["SI.M1.REPEATER JAMMER"]],I[33]=[C["SI.M1.SPOT NOISE JAMMER"]],I[34]=[C["SI.M1.TRANSPONDER JAMMER"]],I[35]=[C["SI.M1.MISSILE ACQUISITION"]],I[36]=[C["SI.M1.MISSILE CONTROL"]],I[37]=[C["SI.M1.MISSILE DOWNLINK"]],I[38]=[C["SI.M1.METEOROLOGICAL"]],I[39]=[C["SI.M1.MULTI-FUNCTION"]],I[40]=[C["SI.M1.MISSILE GUIDANCE"]],I[41]=[C["SI.M1.MISSILE HOMING"]],I[42]=[C["SI.M1.MISSILE TRACKING"]],I[43]=[C["SI.M1.NAVIGATIONAL/GENERAL"]],I[44]=[C["SI.M1.NAVIGATIONAL/DISTANCE MEASURING EQUIPMENT"]],I[45]=[C["SI.M1.NAVIGATION/TERRAIN FOLLOWING"]],I[46]=[C["SI.M1.NAVIGATIONAL/WEATHER AVOIDANCE"]],I[47]=[C["SI.M1.OMNI-LINE OF SIGHT (LOS)"]],I[48]=[C["SI.M1.PROXIMITY USE"]],I[49]=[C["SI.M1.POINT-TO-POINT LINE OF SIGHT (LOS)"]],I[50]=[C["SI.M1.INSTRUMENTATION"]],I[51]=[C["SI.M1.RANGE ONLY"]],I[52]=[C["SI.M1.SONOBUOY"]],I[53]=[C["SI.M1.SATELLITE DOWNLINK"]],I[54]=[C["SI.M1.SPACE"]],I[55]=[C["SI.M1.SURFACE SEARCH"]],I[56]=[C["SI.M1.SHELL TRACKING"]],I[57]=[C["SI.M1.SATELLITE UPLINK"]],I[58]=[C["SI.M1.TARGET ACQUISITION"]],I[59]=[C["SI.M1.TARGET ILLUMINATION"]],I[60]=[C["SI.M1.TROPOSPHERIC SCATTER"]],I[61]=[C["SI.M1.TARGET TRACKING"]],I[62]=[C["SI.M1.UNKNOWN"]],I[63]=[C["SI.M1.VIDEO REMOTING"]],I[64]=[C["SI.M1.EXPERIMENTAL"]],I[65]=[C["SI.M1.CYBER"]],E["01"]=[C["SI.M2.CYBER"]])}},t0={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A,T){"60"==R&&(t[11e4]=[],t[110100]="D"==T?[C["CY.IC.COMMAND AND CONTROL (C2)"]]:[C["CY.IC.COMBAT MISSION TEAM"]],t[110200]="D"==T?[C["CY.IC.HERDER"]]:[C["CY.IC.NATIONAL MISSION TEAM"]],t[110300]="D"==T?[C["CY.IC.CALLBACK DOMAIN"]]:[C["CY.IC.CYBER PROTECTION TEAM"]],t[110400]="D"==T?[C["CY.IC.ZOMBIE"]]:[],t[110500]=[],t[110600]=[C["CY.IC.DEFENSIVE CYBERSPACE OPERATION"]],t[110700]=[C["CY.IC.OFFENSIVE CYBERSPACE OPERATION"]],t[110800]=[C["CY.IC.INTERNET SERVICE PROVIDER"]],t[110900]=[C["CY.IC.SECURITY"]],t[111e3]=[C["CY.IC.OPERATIONS"]],t[12e4]="D"==T?[]:[C["CY.IC.THREAT ACTOR"]],t[120100]=[C["CY.IC.ADVANCED PERSISTENT THREAT (APT)"]],t[120101]=[C["CY.IC.APT WITH C2"]],t[120102]=[C["CY.IC.APT WITH SELF PROPAGATION"]],t[120103]=[C["CY.IC.APT WITH C2 AND SELF PROPAGATION"]],t[120104]=[C["CY.IC.APT OTHER"]],t[120200]="D"==T?[C["CY.IC.NON-ADVANCED PERSISTENT THREAT (NAPT)"]]:[C["CY.IC.INSIDER"]],t[120201]=[C["CY.IC.NAPT WITH C2"]],t[120202]=[C["CY.IC.NAPT WITH SELF PROPAGATION"]],t[120203]=[C["CY.IC.NAPT WITH C2 AND SELF PROPAGATION"]],t[120204]=[C["CY.IC.NAPT OTHER"]],t[13e4]=[],t[130100]="D"==T?[C["CY.IC.NORMAL"]]:[C["CY.IC.FIREWALL"]],t[130200]="D"==T?[C["CY.IC.NETWORK OUTAGE"]]:[C["CY.IC.FIRMWARE"]],t[130300]=[C["CY.IC.UNKNOWN"]],t[130400]=[C["CY.IC.IMPAIRED"]],t[14e4]="D"==T?[]:[C["CY.IC.APPLICATION"]],t[140100]=[C["CY.IC.CORE ROUTER"]],t[140200]=[C["CY.IC.ROUTER TEXT"]],t[140300]="D"==T?[C["CY.IC.CROSS DOMAIN SOLUTION"]]:[C["CY.IC.SEARCH ENGINE"]],t[140400]="D"==T?[C["CY.IC.MAIL SERVER"]]:[C["CY.IC.SOCIAL MEDIA"]],t[140500]=[C["CY.IC.WEB SERVER"]],t[140600]=[C["CY.IC.DOMAIN SERVER"]],t[140700]=[C["CY.IC.FILE SERVER"]],t[140800]=[C["CY.IC.PEER-TO-PEER NODE"]],t[140900]=[C["CY.IC.FIREWALL TEXT"]],t[141e3]=[C["CY.IC.SWITCH TEXT"]],t[141100]=[C["CY.IC.HOST"]],t[141200]=[C["CY.IC.VIRTUAL PRIVATE NETWORK (VPN)"]],t[15e4]=[],t[150100]="D"==T?[C["CY.IC.DEPARTMENT OF DEFENSE (DOD)"]]:[C["CY.IC.MALWARE"]],t[150200]="D"==T?[C["CY.IC.GOVERNMENT"]]:[C["CY.IC.PHISIHNG"]],t[150300]="D"==T?[C["CY.IC.CONTRACTOR"]]:[C["CY.IC.SPEAR PHISIHNG"]],t[150400]="D"==T?[C["CY.IC.SUPERVISORY CONTROL AND DATA ACQUISITION (SCADA)"]]:[C["CY.IC.WHALE PHISHING"]],t[150500]=[C["CY.IC.NON-GOVERNMENT"]],t[16e4]="D"==T?[]:[C["CY.IC.DOCUMENT"]],t[160100]="D"==T?[C["CY.IC.INFECTION"]]:[C["CY.IC.CRYPTO"]],t[160200]="D"==T?[C["CY.IC.DEGRADATION"]]:[C["CY.IC.PERSONA"]],t[160300]=[C["CY.IC.DATA SPOOFING"]],t[160400]=[C["CY.IC.DATA MANIPULATION"]],t[160500]=[C["CY.IC.EXFILTRATION"]],t[160600]=[C["CY.IC.POWER OUTAGE"]],t[160700]=[C["CY.IC.NETWORK OUTAGE"]],t[160800]=[C["CY.IC.SERVICE OUTAGE"]],t[160900]=[C["CY.IC.DEVICE OUTAGE"]],t[17e4]=[],t[170100]=[C["CY.IC.SERVER"]],t[170200]=[C["CY.IC.WORKSTATION"]],t[170300]=[],t[170301]=[C["CY.IC.MOBILE"]],t[170302]=[C["CY.IC.TABLET"]],t[170303]=[C["CY.IC.LAPTOP"]],t[170304]=[C["CY.IC.HEALTH MONITOR"]],t[170305]=[C["CY.IC.SMARTVEST"]],t[170306]=[C["CY.IC.SMARTWATCH"]],t[170307]=[C["CY.IC.WEARABLE"]],t[170400]=[C["CY.IC.IOT"]],t[170500]=[C["CY.IC.PRINTER"]],t[170600]=[C["CY.IC.ROUTER"]],t[170700]=[C["CY.IC.SWITCH"]],t[18e4]=[C["CY.IC.NETWORK"]],I["01"]=[C["CY.M1.DEFENSIVE CYBERSPACE"]],I["02"]=[C["CY.M1.OFFENSIVE CYBERSPACE"]],I["03"]=[C["CY.M1.SOCIAL"]],I["04"]=[C["CY.M1.WIRED"]],I["05"]=[C["CY.M1.WIRELESS"]],I["06"]=[C["CY.M1.RADIO FREQUENCY"]],I["07"]=[C["CY.M1.OPERATING SYSTEM"]],I["08"]=[C["CY.M1.CONTINUITY OF OPERATIONS"]],I["09"]=[C["CY.M1.INTERNET SERVICE PROVIDER"]],I[10]=[C["CY.M1.FINANCE"]],I[11]=[C["CY.M1.OUT OF BAND"]],I[12]=[C["CY.M1.CLOUD"]],I[13]=[C["CY.M1.DATA"]],E["01"]=[C["CY.M2.SECURED"]],E["02"]=[C["CY.M2.OPEN"]],E["03"]=[C["CY.M2.RESPONSE ACTIONS"]],E["04"]=[],E["05"]=[C["CY.M2.INTERNAL DEFENSE MEASURES"]],E["06"]=[C["CY.M2.ADVANCED PERSISTENT THREAT"]],E["07"]=[C["CY.M2.NATION STATE"]],E["08"]=[C["CY.M2.NATION STATE SPONSORED"]])}},I0={type:"number",getMetadata:m,getIcons:U,iconParts:N,icons:function(t,I,E,e,R,C,A){"27"==R&&(t[11e4]=[],t[110100]=[],t[110101]=[C["GR.IC.FF.INFANTRY DISMOUNTED"]],t[110102]=[C["GR.IC.FF.MEDICAL"]],t[110103]=[C["GR.IC.FF.RECONNAISSANCE DISMOUNTED"]],t[110104]=[C["GR.IC.FF.SIGNAL DISMOUNTED"]],t[110200]=[],t[110201]=[C["GR.IC.EXPLOSIVE ORDNANCE DISPOSAL"]],t[110202]=[C["GR.IC.FIELD ARTILLERY OBSERVER"]],t[110203]=[C["GR.IC.JOINT FIRE SUPPORT"]],t[110204]=[C["GR.IC.LIAISON"]],t[110205]=[C["GR.IC.MESSENGER"]],t[110206]=[C["GR.IC.MILITARY POLICE"]],t[110207]=[C["GR.IC.OBSERVER/OBSERVATION"]],t[110208]=[C["GR.IC.SECURITY"]],t[110209]=[C["GR.IC.SNIPER"]],t[110210]=[C["GR.IC.SPECIAL OPERATIONS FORCES"]],t[110211]=[C["GR.EQ.DESIGNATED MARKSMAN"]],t[110212]=[C["GR.EQ.MEDIC"]],t[110213]=[C["GR.IC.FF.SIGNAL DISMOUNTED"]],t[110214]=[C["GR.IC.FF.RECONNAISSANCE DISMOUNTED"]],t[110215]=[C["GR.IC.FF.INFANTRY DISMOUNTED"]],t[110216]=[C["GR.EQ.CLOSE PROTECTION"]],t[110217]=[C["GR.EQ.CROWD AND RIOT CONTROL"]],t[110218]=[C["GR.EQ.SPECIAL WEAPONS AND TACTICS (SWAT)"]],t[110219]=[C["GR.EQ.DEMOLITION"]],t[110220]=[C["GR.EQ.COMMANDER (CDR)"]],t[110221]=[C["GR.EQ.SECOND IN COMMAND (SIC)"]],t[110300]=[],t[110301]=[C["GR.EQ.RIFLE"]],t[110302]=[C["GR.EQ.RIFLE"],C["GR.EQ.SHORT RANGE"]],t[110303]=[C["GR.EQ.RIFLE"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110304]=[C["GR.EQ.RIFLE"],C["GR.EQ.LONG RANGE"]],t[110305]=[C["GR.EQ.MACHINE GUN"]],t[110306]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.SHORT RANGE"]],t[110307]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.INTERMEDIATE RANGE"]],t[110308]=[C["GR.EQ.MACHINE GUN"],C["GR.EQ.LONG RANGE"]],t[110309]=[C["GR.EQ.GRENADE LAUNCHER"]],t[110310]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.SHORT RANGE"])],t[110311]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.INTERMEDIATE RANGE"])],t[110312]=[C["GR.EQ.GRENADE LAUNCHER"],L._translate(0,20,C["GR.EQ.LONG RANGE"])],t[110313]=[C["GR.EQ.FLAME THROWER"]],t[110314]=[C["GR.EQ.MORTAR"]],t[110315]=[C["GR.EQ.SINGLE ROCKET LAUNCHER"]],t[110316]=[C["GR.EQ.ANTITANK ROCKET LAUNCHER"]],t[110400]=[],t[110401]=[C["GR.EQ.NON-LETHAL WEAPON"]],t[110402]=C["GR.EQ.NON-LETHAL GRENADE LAUNCHER"],t[110403]=[C["GR.EQ.TASER"]],t[12e4]=[],t[120100]=[],t[120101]=[C["GR.IC.LAW ENFORCEMENT"]],I["01"]=[C["GR.M1.CLOSE PROTECTION"]],I["02"]=[C["GR.M1.CROWD AND RIOT CONTROL"]],I["03"]=[C["GR.M1.EXPLOSIVE ORDNANCE DISPOSAL"]],I["04"]=[C["GR.M1.SECURITY"]],I["05"]=[C["GR.M1.SNIPER"]],I["06"]=[C["GR.M1.SPECIAL WEAPONS AND TACTICS"]],I["07"]=[C["ST.M1.NONGOVERNMENTAL ORGANIZATION (NGO)"]],I["08"]=[C["GR.M1.MULTINATIONAL"]],I["09"]=[C["GR.M1.MULTINATIONAL SPECIALIZED UNIT"]],I[10]=[C["ST.M1.GOVERNMENT ORGANIZATION"]],I[11]=[C["GR.M1.FIELD ARTILLERY OBSERVER"]],I[12]=[C["GR.M1.JOINT FIRE SUPPORT"]],I[13]=[C["GR.M1.LIAISON"]],I[14]=[C["GR.M1.MESSENGER"]],I[15]=[C["GR.M1.MILITARY POLICE"]],I[16]=[C["GR.M1.OBSERVER"]],I[17]=[C["GR.M1.DESIGNATED MARKSMAN"]],I[18]=[C["GR.M1.J7"]],I[19]=[C["GR.M1.J8"]],I[20]=[C["GR.M1.SIGNALER"]],I[21]=[C["GR.M1.RECONNAISSANCE"]],I[22]=[C["GR.M1.INFANTRY"]],I[23]=[C["GR.M1.COMMANDER"]],I[24]=[C["GR.M1.SECOND IN COMMAND"]],I[25]=[C["GR.M1.DEMOLITION"]],I[26]=[C["GR.M1.POLICE"]],I[27]=[C["GR.M1.OF-7"]],I[28]=[C["GR.M1.OF-8"]],I[29]=[C["GR.M1.OF-9"]],I[30]=[C["GR.M1.OF-10"]],I[31]=[C["GR.M1.OF-D"]],I[32]=[C["GR.M1.OR-1"]],I[33]=[C["GR.M1.OR-2"]],I[34]=[C["GR.M1.OR-3"]],I[35]=[C["GR.M1.OR-4"]],I[36]=[C["GR.M1.OR-5"]],I[37]=[C["GR.M1.OR-6"]],I[38]=[C["GR.M1.OR-7"]],I[39]=[C["GR.M1.OR-8"]],I[40]=[C["GR.M1.OR-9"]],I[41]=[C["GR.M1.WO-1"]],I[42]=[C["GR.M1.WO-2"]],I[43]=[C["GR.M1.WO-3"]],I[44]=[C["GR.M1.WO-4"]],I[45]=[C["GR.M1.WO-5"]],I[46]=[C["GR.M1.INDIVIDUAL"]],I[47]=[C["GR.M1.TEAM"]],I[48]=[C["GR.M1.SQUAD"]],I[49]=[C["GR.M1.SECTION"]],I[50]=[C["GR.M1.PLATOON"]],I[51]=[C["GR.M1.COMPANY"]],I[52]=[C["GR.M1.BATTALION"]],I[53]=[C["GR.M1.REGIMENT"]],I[54]=[C["GR.M1.BRIGADE"]],I[55]=[C["GR.M1.DIVISION"]],E["01"]=[C["GR.M2.AIRBORNE"]],E["02"]=[C["GR.M2.BICYCLE EQUIPPED"]],E["03"]=[C["GR.M2.VIDEO IMAGERY"]],E["04"]=[C["GR.M2.J1"]],E["05"]=[C["GR.M2.J2"]],E["06"]=[C["GR.M2.J3"]],E["07"]=[C["GR.M2.J4"]],E["08"]=[C["GR.M2.J5"]],E["09"]=[C["GR.M2.J6"]],E[10]=[C["GR.M2.J7"]],E[11]=[C["GR.M2.J8"]],E[12]=[C["GR.M2.J9"]],E[13]=[C["GR.M2.MOUNTAIN"]],E[14]=[C["GR.M2.OF-1"]],E[15]=[C["GR.M2.OF-2"]],E[16]=[C["GR.M2.OF-3"]],E[17]=[C["GR.M2.OF-4"]],E[18]=[C["GR.M2.OF-5"]],E[19]=[C["GR.M2.OF-6"]],E[20]=[C["GR.M2.OF-7"]],E[21]=[C["GR.M2.OF-8"]],E[22]=[C["GR.M2.OF-9"]],E[23]=[C["GR.M2.OF-10"]],E[24]=[C["GR.M2.OF-D"]],E[25]=[C["GR.M2.OR-1"]],E[26]=[C["GR.M2.OR-2"]],E[27]=[C["GR.M2.OR-3"]],E[28]=[C["GR.M2.OR-4"]],E[29]=[C["GR.M2.OR-5"]],E[30]=[C["GR.M2.OR-6"]],E[31]=[C["GR.M2.OR-7"]],E[32]=[C["GR.M2.OR-8"]],E[33]=[C["GR.M2.OR-9"]],E[34]=[C["GR.M2.WO-1"]],E[35]=[C["GR.M2.WO-2"]],E[36]=[C["GR.M2.WO-3"]],E[37]=[C["GR.M2.WO-4"]],E[38]=[C["GR.M2.WO-5"]],E[39]=[C["GR.M2.SKI"]])}};var E0={type:"number",getMetadata:m,getIcons:U,iconParts:d,labels:function(t){var I={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:30},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},E={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},e={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:20,fontsize:30},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}};t[130100]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},additionalInformation1:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:30},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t[130200]=I,t[130300]=I,t[130400]={},t[130500]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},t[130600]={},t[130700]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},t[130800]=I,t[130900]=I,t[131001]=E,t[131002]=E,t[131003]=E,t[131100]=I,t[131200]=I,t[131300]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:20,fontsize:40,fontweight:"bold"}},t[131301]={},t[131400]=I,t[131500]=I,t[131600]=I,t[131700]={},t[131800]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:140,y:107,fontsize:50}},t[131900]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:180,y:105,fontsize:40}},t[132e3]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},t[132100]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:100,y:100,fontsize:35,fill:"#800080",fontweight:"bold"}},t[132200]=I,t[132300]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:150,fontsize:40}},t[160100]={},t[160200]={},t[160201]={},t[160202]={},t[160203]={},t[160204]={},t[160205]={},t[160300]={uniqueDesignation:{stroke:!1,textanchor:"start",x:110,y:90,fontsize:40}},t[160400]=E,t[18e4]={},t[180100]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:120,fontsize:35}},t[180200]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:120,fontsize:35}},t[180300]={},t[180400]={},t[180500]={},t[180600]={uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:70,fontsize:35}},t[180700]={},t[180800]={},t[180900]={},t[181e3]={},t[181100]={},t[181200]={},t[181300]={},t[181400]={},t[181500]={},t[181600]={},t[181700]={},t[181800]={},t[181900]={},t[182e3]={},t[182100]={},t[182200]={},t[182300]={},t[182400]={},t[182500]={},t[182600]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:50,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:90,fontsize:40}},t[200400]={},t[200500]={},t[200600]={},t[200700]={},t[210100]={},t[210200]={},t[210300]={},t[210400]={},t[210500]={},t[210600]={altitudeDepth:{stroke:!1,textanchor:"start",x:150,y:70,fontsize:35}},t[210700]={},t[210800]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:35}},t[210900]={},t[211e3]={additionalInformation:{alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:70,fontsize:35}},t[211100]={},t[211200]={},t[211300]={},t[211400]={},t[211500]={},t[211600]={},t[211700]={},t[211800]={},t[211900]={},t[212e3]={},t[212100]={},t[212200]={},t[212300]={},t[212400]={},t[212500]={},t[212600]={},t[212700]={},t[212800]={additionalInformation:{alignmentBaseline:"middle",stroke:!1,textanchor:"middle",x:100,y:105,fontsize:45}},t[212900]={},t[212901]={},t[212902]={},t[212903]={},t[212904]={},t[213e3]={},t[213100]={},t[213200]={},t[213300]={},t[213400]={},t[213500]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213501]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213502]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213503]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213504]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213505]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213506]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213507]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213508]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213509]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213510]={},t[213511]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213512]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213513]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213514]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213515]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:70,fontsize:35},additionalInformation:{stroke:!1,textanchor:"start",x:150,y:105,fontsize:35}},t[213600]={},t[213700]={},t[213800]={},t[213900]={},t[214e3]={},t[214100]={},t[214200]={},t[214300]={},t[214400]={},t[214500]={},t[214600]={},t[214700]={},t[214800]={},t[214900]={dtg:{stroke:!1,textanchor:"start",x:180,y:75,fontsize:30},dtg1:{stroke:!1,textanchor:"start",x:180,y:100,fontsize:30},uniqueDesignation:{stroke:!1,textanchor:"start",x:180,y:125,fontsize:30}},t[215e3]={},t[215100]={},t[215200]={},t[215300]={},t[215400]={},t[215500]={},t[215600]={dtg:{stroke:!1,textanchor:"start",x:180,y:75,fontsize:30},dtg1:{stroke:!1,textanchor:"start",x:180,y:100,fontsize:30},uniqueDesignation:{stroke:!1,textanchor:"start",x:180,y:125,fontsize:30}},t[215700]={},t[215800]={},t[215900]={},t[216e3]={},t[216100]={},t[216200]={},t[216300]={},t[216400]={},t[216500]={},t[216600]={},t[216700]={},t[216800]={},t[216900]={},t[217e3]={},t[217100]={},t[217200]={},t[217300]={},t[217400]={},t[217500]={},t[217600]={},t[217700]={},t[217800]={},t[217900]={},t[218e3]={},t[218100]={},t[218200]={},t[218300]={},t[218500]={},t[218600]={},t[218700]={},t[218800]={},t[218900]={},t[219e3]={},t[219100]={},t[219200]={},t[240601]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},targetNumber:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},t[240602]={targetNumber:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},t[240603]={},t[240900]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:195,y:100,fontsize:35,fontweight:"bold"}},t[250100]=E,t[250200]=E,t[250300]=E,t[250400]=E,t[250500]=E,t[250600]={uniqueDesignation:{alignmentBaseline:"middle",stroke:!1,textanchor:"start",x:180,y:70,fontsize:35}},t[270601]={},t[270602]={},t[270603]={},t[270701]={},t[280100]={},t[280200]={},t[280201]={},t[280300]={},t[280400]={},t[280500]={},t[280600]={},t[280700]={},t[280800]=I,t[280900]={},t[281e3]={},t[281100]={},t[281200]={},t[281300]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281301]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281400]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281500]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281600]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281700]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281701]={additionalInformation:{stroke:!1,textanchor:"start",x:160,y:30,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:40,y:30,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:160,y:90,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-20,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:40,y:90,fontsize:35}},t[281800]=I,t[281801]=I,t[281802]=I,t[281803]=I,t[281804]=I,t[281805]=I,t[281806]=I,t[281807]=I,t[281808]=I,t[281809]=I,t[281901]={},t[281902]={},t[281903]={},t[282001]={altitudeDepth:{stroke:!1,textanchor:"start",x:120,y:60,fontsize:40,fontweight:"bold"}},t[282002]={altitudeDepth:{stroke:!1,textanchor:"start",x:115,y:60,fontsize:40,fontweight:"bold"}},t[320100]={},t[320101]=I,t[320102]=I,t[320103]=I,t[320104]=I,t[320200]=I,t[320300]=I,t[320400]=I,t[320500]=I,t[320600]=I,t[320700]=I,t[320800]=I,t[320900]=I,t[321e3]=I,t[321100]=I,t[321200]=I,t[321300]=I,t[321400]=I,t[321500]=I,t[321600]=I,t[321700]=e,t[321701]=e,t[321702]=e,t[321703]=e,t[321704]=e,t[321705]=e,t[321706]={},t[321707]=E,t[321708]=E,t[321709]=E,t[321710]=E,t[321711]=E,t[321712]=E,t[321713]=E,t[321714]=E,t[321715]=E,t[321716]=E,t[321800]=e,t[321900]=e,t[340300]={},t[340400]={},t[340900]={},t[341400]={},t[341600]={},t[342800]={},t[350101]={},t[350102]={},t[350103]={},t[350201]={},t[350202]={},t[350203]={}},icons:function(t,I,E,e,R,C,A){"25"==R&&(t[130100]=C["TP.ACTION POINT"],e[130100]={x1:60,x2:140,y1:-60},t[130200]=C["TP.ACTION AMNESTY POINT"],e[130200]={x1:60,x2:140,y1:-60},t[130300]=C["TP.ACTION CHECK POINT"],e[130300]={x1:60,x2:140,y1:-60},t[130400]=C["TP.CENTRE OF MAIN EFFORT"],e[130400]={x1:25,x2:175,y1:65,y2:135},t[130500]=C["TP.CONTACT POINT"],e[130500]={x1:50,x2:150,y1:50,y2:150},t[130600]=C["TP.COORDINATION POINT"],e[130600]={x1:50,x2:150,y1:50,y2:150},t[130700]=C["TP.DECISION POINT"],e[130700]={x1:30,x2:170,y1:25,y2:160},t[130800]=C["TP.DISTRESS CALL"],e[130800]={x1:60,x2:140,y1:-60},t[130900]=C["TP.ENTRY CONTROL POINT"],e[130900]={x1:60,x2:140,y1:-60},t[131e3]=[],t[131001]=C["TP.FLY-TO-POINT (SONOBUOY)"],e[131001]={x1:60,x2:140,y1:-60},t[131002]=C["TP.FLY-TO-POINT (WEAPON)"],e[131002]={x1:60,x2:140,y1:-60},t[131003]=C["TP.FLY-TO-POINT (NORMAL)"],e[131003]={x1:60,x2:140,y1:-60},t[131100]=C["TP.ACTION LINKUP POINT"],e[131100]={x1:60,x2:140,y1:-60},t[131200]=C["TP.ACTION PASSAGE POINT"],e[131200]={x1:60,x2:140,y1:-60},t[131300]=C["TP.POINT OF INTEREST"],e[131300]={x1:50,x2:150,y1:-25},t[131301]=C["POINT OF INTEREST – LAUNCH EVENT"],e[131301]={x1:50,x2:150,y1:-25},t[131400]=C["TP.ACTION RALLY POINT"],e[131400]={x1:60,x2:140,y1:-60},t[131500]=C["TP.ACTION RELEASE POINT"],e[131500]={x1:60,x2:140,y1:-60},t[131600]=C["TP.ACTION START POINT"],e[131600]={x1:60,x2:140,y1:-60},t[131700]=C["TP.SPECIAL POINT"],e[131700]={x1:40,x2:160,y1:40,y2:160},t[131800]=C["TP.WAYPOINT"],e[131800]={x1:60,x2:140,y1:60,y2:140},t[131900]=C["TP.AIRFIELD"],e[131900]={x1:35,x2:165,y1:60,y2:125},t[132e3]=C["TP.TARGET HANDOVER"],e[132e3]={x1:40,x2:160,y1:40,y2:160},t[132100]=C["TP.KEY TERRAIN"],t[132200]=C["TP.CONTROL POINT"],e[132200]={x1:60,x2:140,y1:-60},t[132300]=C["TP.VITAL GROUND"],t[160100]=C["TP.OBSERVATION POST/OUTPOST"],e[160100]={x1:50,x2:150,y1:40,y2:150},t[160200]=C["TP.OBSERVATION POST/OUTPOST"],e[160200]={x1:50,x2:150,y1:40,y2:150},t[160201]=C["TP.OBSERVATION POST/RECONNAISSANCE"],e[160201]={x1:50,x2:150,y1:40,y2:150},t[160202]=C["TP.FORWARD OBSERVER POSITION"],e[160202]={x1:50,x2:150,y1:40,y2:150},t[160203]=C["TP.CBRN OBSERVATION POST"],e[160203]={x1:50,x2:150,y1:40,y2:150},t[160204]=C["TP.SENSOR OUTPOST"],e[160204]={x1:50,x2:150,y1:40,y2:150},t[160205]=C["TP.COMBAT OUTPOST"],e[160205]={x1:50,x2:150,y1:40,y2:150},t[160300]=C["TP.TARGET REFERENCE"],t[160400]=C["TP.POINT OF DEPARTURE"],e[160400]={x1:60,x2:140,y1:-60},t[18e4]=C["TP.AIR CONTROL POINT"],e[18e4]={x1:60,x2:140,y1:40,y2:160},t[180100]=C["TP.AIR CONTROL POINT (ACP)"],e[180100]={x1:50,x2:150,y1:50,y2:150},t[180200]=C["TP.COMMUNICATIONS CHECKPOINT"],e[180200]={x1:50,x2:150,y1:50,y2:150},t[180300]=C["TP.DOWNED AIRCREW PICKUP POINT"],e[180300]={x1:60,x2:140,y1:-60},t[180400]=C["TP.PULL-UP POINT"],e[180400]={x1:50,x2:240,y1:50,y2:150},t[180500]=C["TP.AIR CONTROL RENDEZVOUS"],e[180500]={x1:60,x2:140,y1:30,y2:170},t[180600]=C["TP.TACAN"],e[180600]={x1:60,x2:140,y1:30,y2:170},t[180700]=C["TP.CAP STATION"],e[180700]={x1:60,x2:140,y1:30,y2:170},t[180800]=C["TP.AEW STATION"],e[180800]={x1:60,x2:140,y1:30,y2:170},t[180900]=C["TP.ASW FIXED WING"],t[181e3]=C["TP.STRIKE IP"],e[181e3]={x1:60,x2:140,y1:30,y2:170},t[181100]=C["TP.REPLENISHMENT STATION"],e[181100]={x1:60,x2:140,y1:30,y2:170},t[181200]=C["TP.TANKING"],e[181200]={x1:60,x2:140,y1:30,y2:170},t[181300]=C["TP.ASW ROTARY WING"],e[181300]={x1:60,x2:140,y1:40,y2:160},t[181400]=C["TP.SUCAP - FIXED WING"],e[181400]={x1:60,x2:140,y1:40,y2:160},t[181500]=C["TP.SUCAP - ROTARY WING"],e[181500]={x1:60,x2:140,y1:40,y2:160},t[181600]=C["TP.MIW - FIXED WING"],e[181600]={x1:60,x2:140,y1:40,y2:160},t[181700]=C["TP.MIW - ROTARY WING"],e[181700]={x1:60,x2:140,y1:40,y2:160},t[181800]=C["TP.TOMCAT"],e[181800]={x1:60,x2:140,y1:30,y2:170},t[181900]=C["TP.RESCUE"],e[181900]={x1:60,x2:140,y1:30,y2:170},t[182e3]=C["TP.UNMANNED AERIAL SYSTEM"],e[182e3]={x1:60,x2:140,y1:30,y2:170},t[182100]=C["TP.VTUA"],e[182100]={x1:60,x2:140,y1:30,y2:170},t[182200]=C["TP.ORBIT"],e[182200]={x1:60,x2:140,y1:30,y2:170},t[182300]=C["TP.ORBIT - FIGURE EIGHT"],e[182300]={x1:60,x2:140,y1:30,y2:170},t[182400]=C["TP.ORBIT - RACE TRACK"],e[182400]={x1:60,x2:140,y1:30,y2:170},t[182500]=C["TP.ORBIT - RANDOM, CLOSED"],e[182500]={x1:60,x2:140,y1:30,y2:170},t[182600]=C["TP.ISOLATED PERSONNEL LOCATION"],e[182600]={x1:60,x2:140,y1:20,y2:105},t[200400]=C["TP.SHIP AREA OF INTEREST (AEGIS ONLY)"],t[200500]=C["TP.ACTIVE MANOEUVRE AREA (AEGIS ONLY)"],e[200500]={x1:40,x2:160,y1:40,y2:160},t[200600]=C.TODO,t[200700]=C.TODO,t[210100]=C["TP.PLAN SHIP"],e[210100]={x1:50,x2:150,y1:50,y2:150},t[210200]=C["TP.AIM POINT"],e[210200]={x1:50,x2:150,y1:50,y2:150},t[210300]=C["TP.DEFENDED ASSET"],t[210400]=C["TP.DROP POINT"],e[210400]={x1:50,x2:150,y1:50,y2:120},t[210500]=C["TP.ENTRY POINT"],e[210500]={x1:50,x2:150,y1:50},t[210600]=C["TP.AIR DETONATION"],t[210700]=C["TP.GROUND ZERO"],e[210700]={x1:50,x2:150,y1:30},t[210800]=C["TP.IMPACT POINT"],e[210800]={x1:50,x2:150,y1:50,y2:150},t[210900]=C["TP.PREDICTED IMPACT POINT"],e[210900]={x1:50,x2:150,y1:50,y2:150},t[211e3]=C["TP.LAUNCHED TORPEDO (AEGIS ONLY)"],e[211e3]={x1:50,x2:150,y1:90,y2:110},t[211100]=C["TP.MSL DETECT POINT"],e[211100]={x1:50,x2:150,y1:30},t[211200]=C["TP.ACOUSTIC COUNTER MEASURE (DECOY)"],e[211200]={x1:50,x2:150,y1:30},t[211300]=C["TP.ELECTRONIC COUNTER MEASURES (ECM) DECOY"],e[211300]={x1:50,x2:150,y1:50,y2:150},t[211400]=C["TP.BRIEF CONTACT"],e[211400]={x1:50,x2:150,y1:0,y2:100},t[211500]=C["TP.DATUM"],e[211500]={x1:50,x2:150,y1:50,y2:150},t[211600]=C["TP.BT BOUY DROP"],e[211600]={x1:50,x2:150,y1:40,y2:160},t[211700]=C["TP.REPORTED BOTTOMED SUB"],t[211800]=C["TP.MOVING HAVEN"],e[211800]={x1:40,x2:160,y1:50,y2:150},t[211900]=C["TP.SCREEN CENTRE"],t[212e3]=C["TP.LOST CONTACT"],e[212e3]={x1:50,x2:150,y1:0,y2:100},t[212100]=C["TP.SINKER"],e[212100]={x1:50,x2:150,y1:0,y2:100},t[212200]=C["TP.TRIAL TRACK"],e[212200]={x1:50,x2:150,y1:0,y2:100},t[212300]=C["TP.FIX ACOUSTIC"],t[212400]=C["TP.FIX ELECTRO-MAGNETIC"],t[212500]=C["TP.ELECTRO MAGNETIC - MAGNETIC ANOMALY DETECTION (MAD)"],e[212500]={x1:50,x2:150,y1:50,y2:180},t[212600]=C["TP.FIX ELECTRO-OPTICAL"],t[212700]=C["TP.TARGET REFERENCE"],t[212800]=C["TP.HARBOR"],e[212800]={x1:50,x2:150,y1:50,y2:150},t[212900]=C["TP.HARBOR"],e[212900]={x1:50,x2:150,y1:50,y2:150},t[212901]=C["TP.HARBOR POINT A"],e[212901]={x1:50,x2:150,y1:50,y2:150},t[212902]=C["TP.HARBOR POINT Q"],e[212902]={x1:50,x2:150,y1:50,y2:150},t[212903]=C["TP.HARBOR POINT X"],e[212903]={x1:50,x2:150,y1:50,y2:150},t[212904]=C["TP.HARBOR POINT Y"],e[212904]={x1:50,x2:150,y1:50,y2:150},t[213e3]=C["TP.DIP POSITION"],e[213e3]={x1:50,x2:150,y1:50,y2:150},t[213100]=C["TP.SEARCH"],e[213100]={x1:50,x2:150,y1:50,y2:150},t[213200]=C["TP.SEARCH AREA"],e[213200]={x1:50,x2:150,y1:50,y2:150},t[213300]=C["TP.SEARCH CENTER"],e[213300]={x1:50,x2:150,y1:50,y2:150},t[213400]=C["TP.NAVIGATIONAL REFERENCE"],t[213500]=C["TP.SONOBUOY"],e[213500]={x1:60,x2:140,y1:-10,y2:160},t[213501]=C["TP.SONOBUOY ANM"],e[213501]={x1:60,x2:140,y1:-10,y2:160},t[213502]=C["TP.SONOBUOY ATAC"],e[213502]={x1:60,x2:140,y1:-10,y2:160},t[213503]=C["TP.SONOBUOY BARRA"],e[213503]={x1:60,x2:140,y1:-10,y2:160},t[213504]=C["TP.SONOBUOY BATHYTHERMOGRAPH TRANSMITTING SONOBUOY (BT)"],e[213504]={x1:60,x2:140,y1:-10,y2:160},t[213505]=C["TP.SONOBUOY COMMAND ACTIVE MULTIBEAM SONOBUOY (CAMBS)"],e[213505]={x1:60,x2:140,y1:-10,y2:160},t[213506]=C["TP.SONOBUOY CASS"],e[213506]={x1:60,x2:140,y1:-10,y2:160},t[213507]=C["TP.SONOBUOY DIFAR"],e[213507]={x1:60,x2:140,y1:-10,y2:160},t[213508]=C["TP.SONOBUOY DICASS"],e[213508]={x1:60,x2:140,y1:-10,y2:160},t[213509]=C["TP.SONOBUOY EXPENDABLE RELIABLE ACOUSTIC PATH SONOBUOY (ERAPS)"],e[213509]={x1:60,x2:140,y1:-10,y2:160},t[213510]=C["TP.SONOBUOY EXPIRED"],e[213510]={x1:40,x2:160,y1:-10,y2:160},t[213511]=C["TP.SONOBUOY KINGPIN"],e[213511]={x1:40,x2:160,y1:-10,y2:160},t[213512]=C["TP.SONOBUOY LOFAR"],e[213512]={x1:40,x2:160,y1:-10,y2:160},t[213513]=C["TP.SONOBUOY PATTERN CENTER"],e[213513]={x1:40,x2:160,y1:-10,y2:160},t[213514]=C["TP.SONOBUOY RO"],e[213514]={x1:40,x2:160,y1:-10,y2:160},t[213515]=C["TP.SONOBUOY VLAD"],e[213515]={x1:40,x2:160,y1:-10,y2:160},t[213600]=C["TP.REFERENCE POINT"],e[213600]={x1:40,x2:160,y1:40,y2:160},t[213700]=C["TP.SPECIAL POINT"],e[213700]={x1:40,x2:160,y1:40,y2:160},t[213800]=C["TP.NAVIGATIONAL REFERENCE"],e[213800]={x1:40,x2:160,y1:40,y2:160},t[213900]=C["TP.DLRP"],e[213900]={x1:40,x2:160,y1:40,y2:160},t[214e3]=C["FORWARD OBSERVER / SPOTTER POSITION"],e[214e3]={x1:40,x2:160,y1:60,y2:140},t[214100]=C["TP.VITAL AREA CENTRE"],e[214100]={x1:40,x2:160,y1:60,y2:140},t[214200]=C["TP.CORRIDOR TAB"],e[214200]={x1:40,x2:160,y1:40,y2:160},t[214300]=C["TP.ENEMY POINT"],e[214300]={x1:40,x2:160,y1:40,y2:160},t[214400]=C["TP.MARSHALL POINT"],e[214400]={x1:40,x2:160,y1:40,y2:160},t[214500]=C["TP.POINT OF INTENDED MOVEMENT"],e[214500]={x1:40,x2:160,y1:40,y2:160},t[214600]=C["TP.PRE-LANDFALL WAYPOINT"],e[214600]={x1:40,x2:160,y1:40,y2:160},t[214700]=C["TP.ESTIMATED POSITION (EP)"],e[214700]={x1:40,x2:160,y1:40,y2:160},t[214800]=C["TP.REFERENCE POINT WAYPOINT"],e[214800]={x1:40,x2:160,y1:40,y2:160},t[214900]=C["TP.SUB SURFACE CONTROL STATION"],e[214900]={x1:30,x2:170,y1:60,y2:140},t[215e3]=C["TP.SUBMARINE CONTROL STATION"],e[215e3]={x1:30,x2:170,y1:60,y2:140},t[215100]=C["TP.ASW SUBMARINE CONTROL STATION"],e[215100]={x1:30,x2:170,y1:60,y2:140},t[215200]=C["TP.(UUV) CONTROL STATION"],e[215200]={x1:30,x2:170,y1:60,y2:140},t[215300]=C["TP.UUV - ASW CONTROL STATION"],e[215300]={x1:30,x2:170,y1:60,y2:140},t[215400]=C["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SUBSURFACE STATION"],e[215400]={x1:30,x2:170,y1:60,y2:140},t[215500]=C["TP.UUV - SUW CONTROL STATION"],e[215500]={x1:30,x2:170,y1:60,y2:140},t[215600]=C["TP.SEA SURFACE CONTROL STATION"],e[215600]={x1:30,x2:170,y1:60,y2:140},t[215700]=C["TP.ASW CONTROL STATION"],e[215700]={x1:30,x2:170,y1:60,y2:140},t[215800]=C["TP.MINE WARFARE SURFACE STATION"],e[215800]={x1:30,x2:170,y1:60,y2:140},t[215900]=C["TP.NON-COMBATANT SURFACE STATION"],e[215900]={x1:30,x2:170,y1:60,y2:140},t[216e3]=C["TP.PICKET CONTROL STATION"],e[216e3]={x1:30,x2:170,y1:60,y2:140},t[216100]=C["TP.RENDEZVOUS CONTROL POINT"],e[216100]={x1:30,x2:170,y1:60,y2:140},t[216200]=C["TP.REPLENISHMENT AT SEA SURFACE STATION"],e[216200]={x1:30,x2:170,y1:60,y2:140},t[216300]=C["TP.RESCUE CONTROL POINT"],e[216300]={x1:30,x2:170,y1:60,y2:140},t[216400]=C["TP.SUW CONTROL STATION"],e[216400]={x1:30,x2:170,y1:60,y2:140},t[216500]=C["TP.(USV) CONTROL STATION"],e[216500]={x1:30,x2:170,y1:60,y2:140},t[216600]=C["TP.USV - ASW CONTROL STATION"],e[216600]={x1:30,x2:170,y1:60,y2:140},t[216700]=C["TP.MINE WARFARE UNMANNED UNDERWATER VEHICLE SURFACE STATION"],e[216700]={x1:30,x2:170,y1:60,y2:140},t[216800]=C["TP.(RMV) USV CONTROL STATION"],e[216800]={x1:30,x2:170,y1:60,y2:140},t[216900]=C["TP.USV - SUW CONTROL STATION"],e[216900]={x1:30,x2:170,y1:60,y2:140},t[217e3]=C["TP.SHORE CONTROL STATION"],e[217e3]={x1:40,x2:160,y1:40,y2:160},t[217100]=C["TP.ROUTE"],e[217100]={x1:30,x2:170,y1:60,y2:140},t[217200]=C["TP.ROUTE DIVERSIONS"],e[217200]={x1:30,x2:170,y1:60,y2:170},t[217300]=C["TP.ROUTE POINT R"],e[217300]={x1:30,x2:170,y1:60,y2:170},t[217400]=C["TP.PICKET ROUTE"],e[217400]={x1:30,x2:170,y1:60,y2:170},t[217500]=C["TP.POINT R ROUTE"],e[217500]={x1:30,x2:170,y1:60,y2:170},t[217600]=C["TP.RENDEZVOUS ROUTE"],e[217600]={x1:30,x2:170,y1:60,y2:170},t[217700]=C["TP.ROUTE WAYPOINT"],e[217700]={x1:30,x2:170,y1:60,y2:170},t[217800]=C["TP.CLUTTER, STATIONARY OR CEASE REPORTING"],t[217900]=C["TP.TENTATIVE OR PROVISIONAL TRACK"],t[218e3]=C["TP.DISTRESSED VESSEL"],t[218100]=C["TP.DITCHED AIRCRAFT"],t[218200]=C["TP.PERSON IN WATER"],t[218300]=C["TP.ICEBERG"],e[218300]={x1:50,x2:150,y1:50,y2:150},t[218500]=C["TP.OIL RIG/PLATFORM"],e[218500]={x1:30,x2:170,y1:60,y2:140},t[218600]=C["TP.SEA MINELIKE"],e[218600]={x1:40,x2:160,y1:40,y2:150},t[218700]=C["TP.BOTTOM RETURN"],e[218700]={x1:40,x2:160,y1:40,y2:100},t[218800]=C["TP.INSTALLATION/MANMADE"],e[218800]={x1:40,x2:160,y1:40,y2:100},t[218900]=C["TP.MARINE LIFE"],e[218900]={x1:100,x2:220,y1:70,y2:130},t[219e3]=C["TP.SEA ANOMALY"],e[219e3]={x1:50,x2:150,y1:30,y2:120},t[219100]=C["TP.WRECK, DANGEROUS"],e[219100]={x1:40,x2:160,y1:70,y2:130},t[219200]=C["TP.WRECK, NON DANGEROUS"],e[219200]={x1:40,x2:160,y1:70,y2:130},t[240601]=C["TP.POINT/SINGLE TARGET"],t[240602]=C["TP.NUCLEAR TARGET"],t[240603]=C["TP.TARGETRECORDED (AEGIS ONLY)"],e[240603]={x1:0,x2:200,y1:50,y2:150},t[240900]=C["TP.FIRE SUPPORT STATION"],e[240900]={x1:50,x2:200,y1:50,y2:150},t[250100]=C["TP.FIRING POINT"],e[250100]={x1:60,x2:140,y1:-60},t[250200]=C["TP.HIDE POINT"],e[250200]={x1:60,x2:140,y1:-60},t[250300]=C["TP.LAUNCH POINT"],e[250300]={x1:60,x2:140,y1:-60},t[250400]=C["TP.RELOAD POINT"],e[250400]={x1:60,x2:140,y1:-60},t[250500]=C["TP.SURVEY CONTROL POINT"],e[250500]={x1:60,x2:140,y1:-60},t[250600]=C["TP.KNOWN POINT"],t[270701]=C["TP.MINEFIELD, STATIC"],e[270701]={x1:25,x2:175,y1:65,y2:145},t[280100]=C.TODO,t[280200]=C["TP.ANTIPERSONNEL (AP) MINES"],t[280201]=C["TP.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS"],e[280201]={x1:40,x2:180,y1:40,y2:150},t[280300]=C["TP.ANTITANK MINE (AT)"],t[280400]=C["TP.(AT) ANTIHANDLING DEVICE"],e[280400]={x1:60,x2:140,y1:40,y2:195},t[280500]=C["TP.WIDE AREA MINES"],t[280600]=C["TP.UNSPECIFIED MINE"],t[280700]=C["TP.BOOBY TRAP"],t[280800]=C["TP.ENGINEER REGULATING POINT"],e[280800]={x1:60,x2:140,y1:-60},t[280900]=C["TP.EARTHWORK/FORTIFICATION"],t[281e3]=C["TP.SURFACE SHELTER"],t[281100]=C["TP.UNDERGROUND SHELTER"],t[281200]=C["TP.FORT"],t[281300]=C["TP.CHEMICAL EVENT"],e[281300]={x1:25,x2:175,y1:-10},t[281301]=C["TP.CHEMICAL – TOXIC INDUSTRIAL MATERIAL"],e[281301]={x1:25,x2:175,y1:-10},t[281400]=C["TP.BIOLOGICAL EVENT"],e[281400]={x1:25,x2:175,y1:-10},t[281401]=C["TP.BIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"],e[281401]={x1:25,x2:175,y1:-10},t[281500]=C["TP.NUCLEAR EVENT"],e[281500]={x1:25,x2:175,y1:-10},t[281600]=C["TP.NUCLEAR EVENT"],e[281600]={x1:25,x2:175,y1:-10},t[281700]=C["TP.RADIOLOGICAL EVENT"],e[281700]={x1:25,x2:175,y1:-10},t[281701]=C["TP.RADIOLOGICAL – TOXIC INDUSTRIAL MATERIAL"],e[281701]={x1:25,x2:175,y1:-10},t[281800]=C["TP.DECON SITE/POINT"],e[281800]={x1:60,x2:140,y1:-60},t[281801]=C["TP.ALTERNATE DECON SITE/POINT"],e[281801]={x1:60,x2:140,y1:-60},t[281802]=C["TP.DECON SITE/POINT (EQUIPMENT)"],e[281802]={x1:60,x2:140,y1:-60},t[281803]=C["TP.DECON SITE/POINT (TROOPS)"],e[281803]={x1:60,x2:140,y1:-60},t[281804]=C["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],e[281804]={x1:60,x2:140,y1:-60},t[281805]=C["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],e[281805]={x1:60,x2:140,y1:-60},t[281806]=C["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],e[281806]={x1:60,x2:140,y1:-60},t[281807]=C["TP.MAIN EQUIPMENT DECONTAMINATION POINT/SITE"],e[281807]={x1:60,x2:140,y1:-60},t[281808]=C["TP.FORWARD TROOP DECONTAMINATION POINT/SITE"],e[281808]={x1:60,x2:140,y1:-60},t[281809]=C["TP.WOUNDED PERSONNEL DECONTAMINATION SITE"],e[281809]={x1:60,x2:140,y1:-60},t[281901]=C["TP.FIXED AND PREFABRICATED"],e[281901]={x1:60,x2:140,y1:30},t[281902]=C["TP.TETRAHEDRONS"],e[281902]={x1:60,x2:140,y1:30},t[281903]=C["TP.TETRAHEDRONS MOVABLE"],e[281903]={x1:60,x2:140,y1:30},t[282001]=C["TP.TOWER LOW"],e[282001]={x1:50,x2:150,y1:30,y2:120},t[282002]=C["TP.TOWER HIGH"],e[282002]={x1:50,x2:150,y1:30,y2:120},t[320100]=C["TP.AMBULANCE EXCHANGE POINT"],e[320100]={x1:60,x2:140,y1:-60},t[320101]=C["TP.AMBULANCE EXCHANGE POINT"],e[320101]={x1:60,x2:140,y1:-60},t[320102]=C["TP.AMBULANCE CONTROL POINT"],e[320102]={x1:60,x2:140,y1:-60},t[320103]=C["TP.AMBULANCE LOAD POINT"],e[320103]={x1:60,x2:140,y1:-60},t[320104]=C["TP.AMBULANCE RELAY POINT"],e[320104]={x1:60,x2:140,y1:-60},t[320200]=C["TP.AMMUNITION SUPPLY POINT (ASP)"],e[320200]={x1:60,x2:140,y1:-60},t[320300]=C["TP.AMMUNITION TRANSFER POINT (ATP)"],e[320300]={x1:60,x2:140,y1:-60},t[320400]=C["TP.CANNIBALIZATION POINT"],e[320400]={x1:60,x2:140,y1:-60},t[320500]=C["TP.CASUALTY COLLECTION POINT"],e[320500]={x1:60,x2:140,y1:-60},t[320600]=C["TP.CIVILIAN COLLECTION POINT"],e[320600]={x1:60,x2:140,y1:-60},t[320700]=C["TP.DETAINEE COLLECTION POINT"],e[320700]={x1:60,x2:140,y1:-60},t[320800]=C["TP.EPW COLLECTION POINT"],e[320800]={x1:60,x2:140,y1:-60},t[320900]=C["TP.LOGISTICS RELEASE POINT"],e[320900]={x1:60,x2:140,y1:-60},t[321e3]=C["TP.MAINTENANCE COLLECTION POINT"],e[321e3]={x1:60,x2:140,y1:-60},t[321100]=C["TP.MEDICAL EVACUATION (MEDEVAC) PICKUP POINT"],e[321100]={x1:60,x2:140,y1:-60},t[321200]=C["TP.REARM, REFUEL AND RESUPPLY POINT"],e[321200]={x1:60,x2:140,y1:-60},t[321300]=C["TP.REFUEL ON THE MOVE POINT"],e[321300]={x1:60,x2:140,y1:-60},t[321400]=C["TP.TRAFFIC CONTROL POST"],e[321400]={x1:60,x2:140,y1:-60},t[321500]=C["TP.TRAILER TRANSFER POINT"],e[321500]={x1:60,x2:140,y1:-60},t[321600]=C["TP.UNIT MAINTENANCE COLLECTION POINT"],e[321600]={x1:60,x2:140,y1:-60},t[321700]=C["TP.SUPPLY POINT"],e[321700]={x1:60,x2:140,y1:-60},t[321701]=C["TP.NATO CLASS I"],e[321701]={x1:60,x2:140,y1:-60},t[321702]=C["TP.NATO CLASS II"],e[321702]={x1:60,x2:140,y1:-60},t[321703]=C["TP.NATO CLASS III"],e[321703]={x1:60,x2:140,y1:-60},t[321704]=C["TP.NATO CLASS IV"],e[321704]={x1:60,x2:140,y1:-60},t[321705]=C["TP.NATO CLASS V"],e[321705]={x1:60,x2:140,y1:-60},t[321706]=C["TP.SUPPLY POINT"],e[321706]={x1:60,x2:140,y1:-60},t[321707]=C["TP.SP CLASS I"],e[321707]={x1:60,x2:140,y1:-60},t[321708]=C["TP.SP CLASS II"],e[321708]={x1:60,x2:140,y1:-60},t[321709]=C["TP.SP CLASS III"],e[321709]={x1:60,x2:140,y1:-60},t[321710]=C["TP.SP CLASS IV"],e[321710]={x1:60,x2:140,y1:-60},t[321711]=C["TP.SP CLASS V"],e[321711]={x1:60,x2:140,y1:-60},t[321712]=C["TP.SP CLASS VI"],e[321712]={x1:60,x2:140,y1:-60},t[321713]=C["TP.SP CLASS VII"],e[321713]={x1:60,x2:140,y1:-60},t[321714]=C["TP.SP CLASS VIII"],e[321714]={x1:60,x2:140,y1:-60},t[321715]=C["TP.SP CLASS IX"],e[321715]={x1:60,x2:140,y1:-60},t[321716]=C["TP.SP CLASS X"],e[321716]={x1:60,x2:140,y1:-60},t[321800]=C["TP.MEDICAL SUPPLY POINT"],e[321800]={x1:60,x2:140,y1:-60},t[321900]=C["TP.MORTUARY AFFAIRS COLLECTION POINT"],e[321900]={x1:60,x2:140,y1:-60},t[340900]=C["TP.DESTROY"],e[340900]={x1:0,x2:200,y1:40,y2:160},t[341400]=C["TP.INTERDICT"],e[341400]={x1:0,x2:200,y1:40,y2:160},t[341600]=C["TP.NEUTRALIZE"],e[341600]={x1:0,x2:200,y1:40,y2:160},t[342800]=C["TP.SUPPRESS"],e[342800]={x1:0,x2:200,y1:40,y2:160},t[350101]=C["MAN MADE SPACE DEBRIS SMALL"],t[350102]=C["MAN MADE SPACE DEBRIS MEDIUM"],t[350103]=C["MAN MADE SPACE DEBRIS BIG"],t[350201]=C["NATURAL SPACE DEBRIS SMALL"],t[350202]=C["NATURAL SPACE DEBRIS MEDIUM"],t[350203]=C["NATURAL SPACE DEBRIS BIG"],I[13]=[C["TP.M1.UNSPECIFIED"]],I[14]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE 2"],C["TP.M1.ANTIPERSONNEL MINE 3"]],I[15]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],I[16]=[C["TP.M1.ANTITANK MINE 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.ANTITANK MINE 3"]],I[17]=[C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[18]=[C["TP.M1.WIDE AREA ANTITANK MINE 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[19]=[C["TP.M1.MINE CLUSTER 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.MINE CLUSTER 3"]],I[20]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.ANTIPERSONNEL MINE 3"]],I[21]=[C["TP.M1.ANTITANK MINE 1"],C["TP.M1.ANTIPERSONNEL MINE 2"],C["TP.M1.ANTITANK MINE 3"]],I[22]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.ANTIPERSONNEL MINE 3"]],I[23]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.ANTIPERSONNEL MINE 3"]],I[24]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.ANTIPERSONNEL MINE 3"]],I[25]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],I[26]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],I[27]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],I[28]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 3"]],I[29]=[C["TP.M1.ANTITANK MINE 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.ANTITANK MINE 3"]],I[30]=[C["TP.M1.ANTITANK MINE 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.ANTITANK MINE 3"]],I[31]=[C["TP.M1.ANTITANK MINE 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.ANTITANK MINE 3"]],I[32]=[C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[33]=[C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[34]=[C["TP.M1.WIDE AREA ANTITANK MINE 1"],C["TP.M1.MINE CLUSTER 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[35]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.ANTITANK MINE 3"]],I[36]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[37]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[38]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 2"],C["TP.M1.MINE CLUSTER 3"]],I[39]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[40]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[41]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.MINE CLUSTER 3"]],I[42]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[43]=[C["TP.M1.ANTIPERSONNEL MINE 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.MINE CLUSTER 3"]],I[44]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.MINE CLUSTER 3"]],I[45]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 3"]],I[46]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[47]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE 2"],C["TP.M1.MINE CLUSTER 3"]],I[48]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.WIDE AREA ANTITANK MINE 3"]],I[49]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.ANTITANK MINE WITH ANTIHANDLING DEVICE 2"],C["TP.M1.MINE CLUSTER 3"]],I[50]=[C["TP.M1.ANTIPERSONNEL MINE WITH DIRECTIONAL EFFECTS 1"],C["TP.M1.WIDE AREA ANTITANK MINE 2"],C["TP.M1.MINE CLUSTER 3"]],I[51]=C["TP.M1.DISMOUNTED"],E["01"]=C["TP.M2.URBAN"],E["02"]=C["TP.M2.WATER"],E["03"]=C["TP.M2.GROUND"],E["04"]=C["TP.M2.VEGETATION"],E["05"]=C["TP.M2.OBSTACLES"])}},e0=[y,x,p,D,F,f,z,H,V,J,q,j,$,I0,E0],R0=[y,x,p,D,F,f,z,H,V,J,q,j,$,t0,E0],y=[{type:"number",getMetadata:m,getIcons:U,iconParts:function(t,I,E,e,R,C){var I=I.affiliation||"Friend",A=E.iconColor[I],T={"COM.M1.UNMANNED AERIAL VEHICLE(UAV)":{type:"path",stroke:!1,d:"m 80,65 20,13 20,-13 0,-5 -20,10 -20,-10 z"},"COM.M1.ROBOTIC":{type:"path",d:"m 100,52.7 14.9,14.8 c 0.4,-0.3 0.9,-0.4 1.4,-0.4 1.5,0 2.7,1.2 2.7,2.7 0,1.4 -1.2,2.7 -2.7,2.7 -1.5,0 -2.7,-1.3 -2.7,-2.7 0,-0.4 0.1,-0.7 0.2,-1 l -10.4,-5.2 -2.5,8.6 c 0.2,0.1 0.4,0.2 0.6,0.3 0.7,0.5 1.2,1.3 1.2,2.3 0,1.5 -1.2,2.7 -2.7,2.7 -0.55,0 -1.06,-0.2 -1.49,-0.5 -0.73,-0.4 -1.22,-1.3 -1.22,-2.2 0,-1.2 0.77,-2.2 1.85,-2.6 l -2.53,-8.6 -10.42,5.2 c 0.12,0.3 0.18,0.6 0.18,1 0,1.5 -1.21,2.7 -2.7,2.7 -1.49,0 -2.7,-1.2 -2.7,-2.7 0,-1.5 1.21,-2.7 2.7,-2.7 0.52,0 1.01,0.1 1.42,0.4 l 14.9,-14.8 0,0 0,0 z",stroke:!1},"COM.M1.FIXED WING":{type:"path",d:"m 100,70 22,-8.7 c 11,0 11,17.4 0,17.4 L 100,70 78,78.7 c -10.9,0 -10.9,-17.4 0,-17.4 z"},"COM.M1.ROTARY WING":{type:"path",d:"m 75,60 0,15 50,-15 0,15 z"}};T["COM.M1.TILT ROTOR"]=P("TR"),T["COM.M1.VTOL"]=P("VTOL"),T["COM.M1.ATTACK"]=P("A"),T["COM.M1.ARMORED"]={type:"path",fill:!1,d:"m 90,60 20,0 c 10,0 10,15 0,15 L 90,75 C 80,75 80,60 90,60"},T["COM.M1.BALLISTIC MISSILE"]=P("BM"),T["COM.M1.CARGO"]={type:"path",fill:!1,d:"m 100,60 0,15 -15,0 0,-15 30,0 0,15 -15,0"},T["COM.M1.UTILITY"]=P("U"),T["COM.M1.LIGHT"]=P("L"),T["COM.M1.MEDIUM"]=P("M"),T["COM.M1.HEAVY"]=P("H"),T["COM.M1.CYBERSPACE"]=P("CYB"),T["COM.M1.COMMAND POST NODE"]=P("CPN"),T["COM.M1.JOINT NETWORK NODE"]=P("JNN"),T["COM.M1.RETRANSMISSION SITE"]=P("RTNS"),T["COM.M1.BRIGADE"]={type:"path",fill:!1,d:"m 107.5,62.5 -15,15  m 0,-15 15,15"},T["COM.M1.BRIDGE"]={type:"path",fill:!1,d:"m 121,78 -7,-6 H 86 l -7,6  m 42,-18 -7,7 H 86 l -7,-7"},T["COM.M1.CLOSE PROTECTION"]=P("CLP"),T["COM.M1.COMBAT"]=P("CBT"),T["COM.M1.COMMAND AND CONTROL"]=P("C2"),T["COM.M1.CROWD AND RIOT CONTROL"]=P("CRC"),T["COM.M1.EOD"]=P("EOD"),T["COM.M1.ISR"]=P("ISR"),T["COM.MQ.LASER"]={type:"path",fill:!1,d:"M 132,70.8 H 114 L 110,78 108,63.6 104,78 100,63.6 96.5,70.8 H 85.7 L 82.1,78 78.5,63.6 74.9,78 71.3,63.6 67.7,78  m 56.3,-14.4 8,7.2 -8,7.2"},T["COM.M1.MAINTENANCE"]={type:"path",fill:!1,d:"m 83,70 h 34  m 8,-7 c -10,0 -10,14 0,14  M 75,63 c 10,0 10,14 0,14"},T["COM.M1.MEDICAL"]={type:"path",stroke:!1,d:"m 95.3,55 h 9.7 v 6.8 h 7 v 9.4 h -7 V 78 h -9.7 v -6.8 h -6.8 v -9.4 h 6.8 z"},T["COM.M1.SEARCH AND RESCUE"]=P("SAR"),T["COM.M1.SECURITY"]=P("SEC"),T["COM.M1.SNIPER"]={type:"path",d:"m 75,62 h 20  m 5,16 V 62.1  M 125,62 h -20",fill:!1},T["COM.M1.SPECIAL OPERATION FORCES"]=P("SOF"),T["COM.M1.SWAT"]=P("SWAT"),T["COM.M1.GUIDED MISSILE"]=P("G"),T["COM.M1.OTHER GUIDED MISSILE"]=P("GM"),T["COM.M1.PETROLEUM"]={type:"path",d:"M 100,79 V 69 L 91,57 h 18 l -9,12",fill:!1},T["COM.M1.WATER"]={type:"path",d:"m 92,59 h 16  m -8,9.7 V 59  M 75,69 h 40 c 10,0 15,5 15,10",fill:!1},T["COM.M1.WEAPON"]=P("WPN"),T["COM.M1.CHEMICAL"]=P("C"),T["COM.M1.BIOLOGICAL"]=P("B"),T["COM.M1.RADIOLOGICAL"]=P("R"),T["COM.M1.NUKLEAR"]=P("N"),T["COM.M1.DECONTAMINATION"]=P("D"),T["COM.M1.CIVILIAN"]=P("CIV"),T["COM.M1.GOVERNMENT"]=P("GO"),T["COM.M1.ACCIDENT"]=P("ACC"),T["COM.M1.ASSASSINATION"]=P("AS"),T["COM.M1.EXECUTION"]=P("EX"),T["COM.M1.KIDNAPPING"]=P("KNP"),T["COM.M1.PIRACY"]=P("PI"),T["COM.M1.RAPE"]=P("RA"),T["COM.M1.ANTISUBMARINE WARFARE"]=P("ASW"),T["COM.M1.ESCORT"]=P("E"),T["COM.M1.MINE COUNTERMEASURES"]=P("MCM"),T["COM.M1.MINE WARFARE"]=P(e?"MIW":"MW"),T["COM.M1.SURFACE WARFARE"]=P("SUW"),T["COM.M1.INDEPENDENT COMMAND"]={type:"path",d:"m 110,59 v 16  m -8,-8 h 16  M 90,59 v 16  m 8,-8 H 82",fill:!1},T["COM.M1.COMPANY"]={type:"path",fill:!1,d:"M 100,59.6 V 78"},T["COM.M1.PLATOON"]=[{type:"circle",stroke:!1,cx:80,cy:68,r:8},{type:"circle",stroke:!1,cx:100,cy:68,r:8},{type:"circle",stroke:!1,cx:120,cy:68,r:8}],T["COM.M1.REGIMENT"]={type:"path",fill:!1,d:"m 110,60 v 18 0  M 90,60 v 18  m 10,-18 v 18"},T["COM.M1.SECTION"]=[{type:"circle",stroke:!1,cx:90,cy:68,r:8},{type:"circle",stroke:!1,cx:110,cy:68,r:8}],T["COM.M1.SQUAD"]={type:"circle",stroke:!1,cx:100,cy:68,r:8},T["COM.M1.TEAM"]=[{type:"circle",fill:!1,cx:100,cy:65,r:10},{type:"path",d:"m 90,75 l20,-20"}],T["COM.M1.BATTALION"]={type:"path",fill:!1,d:"m 105,60 v 18 0  M 95,60 v 18"},T["COM.M1.HIJACKER"]=P("HIJ"),T["COM.M1.ELECTROMAGNETIC WARFARE"]=P("EW"),T["COM.M2.AIRBORNE"]={type:"path",d:"M75,140 C75,125 100,125 100,140 C100,125 125,125 125,140",fill:!1},T["COM.M2.BICYCLE EQUIPPED"]={type:"circle",cx:100,cy:132,r:11,fill:!1},T["COM.M2.RAILROAD"]=[{type:"path",d:"M65,125 l70,0",fill:!1},{type:"circle",fill:!1,cx:70,cy:130,r:5},{type:"circle",fill:!1,cx:80,cy:130,r:5},{type:"circle",fill:!1,cx:120,cy:130,r:5},{type:"circle",fill:!1,cx:130,cy:130,r:5}],T["COM.M2.FIXED WING"]={type:"path",d:"m 100,130 22,-9 c 11,0 11,18 0,18 l -22,-9 -22,9 c -10.9,0 -10.9,-18 0,-18 z"},T["COM.M2.ROTARY WING"]={type:"path",d:"m 75,122 v 15 l 50,-15 v 15 z"},T["COM.M2.SKI"]={type:"path",d:"m 95,145 -9,-8  m 28,0 -9,8  m -15,-24 21,22  m -1,-22 -21,22",fill:!1},T["COM.M2.TRACKED"]={type:"path",d:"m 90,125 h 20 c 10,0 10,15 0,15 H 90 c -10,0 -10,-15 0,-15",fill:!1},T["COM.M2.WHEELED LIMITED"]=[{type:"circle",cx:80,cy:130,r:7,fill:!1},{type:"circle",cx:120,cy:130,r:7,fill:!1}],T["COM.M2.WHEELED"]=[{type:"circle",cx:75,cy:130,r:7,fill:!1},{type:"circle",cx:100,cy:130,r:7,fill:!1},{type:"circle",cx:125,cy:130,r:7,fill:!1}],T["COM.M2.ROBOTIC"]={type:"path",d:"M100,121.68L114.895,136.459C115.309,136.201 115.798,136.052 116.321,136.052C117.812,136.052 119.022,137.262 119.022,138.753C119.022,140.243 117.812,141.454 116.321,141.454C114.831,141.454 113.62,140.243 113.62,138.753C113.62,138.407 113.686,138.076 113.805,137.772L103.378,132.6L100.851,141.224C101.072,141.298 101.28,141.4 101.471,141.526C102.211,142.008 102.701,142.843 102.701,143.791C102.701,145.281 101.491,146.492 100,146.492C99.451,146.492 98.939,146.327 98.512,146.045C97.776,145.562 97.29,144.73 97.29,143.785C97.29,142.592 98.064,141.579 99.138,141.222L96.613,132.606L86.186,137.778C86.305,138.082 86.37,138.413 86.37,138.759C86.37,140.25 85.16,141.46 83.669,141.46C82.179,141.46 80.969,140.25 80.969,138.759C80.969,137.268 82.179,136.058 83.669,136.058C84.193,136.058 84.681,136.207 85.095,136.465L99.991,121.671L100,121.662L100,121.68Z",stroke:!1},T["COM.M2.AUTONOMOUS CONTROL"]=r("AUT"),T["COM.M2.REMOTELY PILOTED"]=r("RP"),T["COM.M2.EXPENDABLE"]=r("EXP"),T["COM.M2.MOUNTAIN"]={type:"path",stroke:!1,d:"m 87,142 10,-20 5,10 3,-5 8,15"},T["COM.M2.LONG RANGE"]=r("LR"),T["COM.M2.MEDIUM RANGE"]=r("MR"),T["COM.M2.SHORT RANGE"]=r("SR"),T["COM.M2.CLOSE RANGE"]=r("CR"),T["COM.M2.HEAVY"]=r("H"),T["COM.M2.MEDIUM"]=r("M"),T["COM.M2.LIGHT AND MEDIUM"]=r("L/M"),T["COM.M2.LIGHT"]=r("L"),T["COM.M2.CYBERSPACE"]=r("CYB"),T["COM.M2.SECURITY FORCE ASSISTANCE"]=r("SFA"),T["COM.M2.BED"]={type:"path",fill:!1,d:"m 107,125 8,6  m 15,-7 v 13  m -23,-16 v 16  m 0,-6 h 23"},T["COM.M2.MULTIFUNCTIONAL"]=r("MF");for(const S in T)T.hasOwnProperty(S)&&(t.hasOwnProperty(S)&&console.warn("Override of: "+S),s.call(this,T[S],A),t[S]=T[S])},icons:function(t,I,E,e,R,C,A){I[100]=[C["COM.M1.UNMANNED AERIAL VEHICLE(UAV)"]],I[101]=[C["COM.M1.ROBOTIC"]],I[102]=[C["COM.M1.FIXED WING"]],I[103]=[C["COM.M1.ROTARY WING"]],I[104]=[C["COM.M1.TILT ROTOR"]],I[105]=[C["COM.M1.VTOL"]],I[106]=[C["COM.M1.ATTACK"]],I[107]=[C["COM.M1.ARMORED"]],I[108]=[C["COM.M1.BALLISTIC MISSILE"]],I[109]=[C["COM.M1.BRIDGE"]],I[110]=[C["COM.M1.CARGO"]],I[111]=[C["COM.M1.UTILITY"]],I[112]=[C["COM.M1.LIGHT"]],I[113]=[C["COM.M1.MEDIUM"]],I[114]=[C["COM.M1.HEAVY"]],I[115]=[C["COM.M1.CYBERSPACE"]],I[116]=[C["COM.M1.COMMAND POST NODE"]],I[117]=[C["COM.M1.JOINT NETWORK NODE"]],I[118]=[C["COM.M1.RETRANSMISSION SITE"]],I[119]=[C["COM.M1.BRIGADE"]],I[120]=[C["COM.M1.CLOSE PROTECTION"]],I[121]=[C["COM.M1.COMBAT"]],I[122]=[C["COM.M1.COMMAND AND CONTROL"]],I[123]=[C["COM.M1.CROWD AND RIOT CONTROL"]],I[124]=[C["COM.M1.EOD"]],I[125]=[C["COM.M1.ISR"]],I[126]=[C["COM.M1.MAINTENANCE"]],I[127]=[C["COM.M1.MEDICAL"]],I[128]=[C["COM.M1.SEARCH AND RESCUE"]],I[129]=[C["COM.M1.SECURITY"]],I[130]=[C["COM.M1.SNIPER"]],I[131]=[C["COM.M1.SPECIAL OPERATION FORCES"]],I[132]=[C["COM.M1.SWAT"]],I[133]=[C["COM.M1.GUIDED MISSILE"]],I[134]=[C["COM.M1.OTHER GUIDED MISSILE"]],I[135]=[C["COM.M1.PETROLEUM"]],I[136]=[C["COM.M1.WATER"]],I[137]=[C["COM.M1.WEAPON"]],I[138]=[C["COM.M1.CHEMICAL"]],I[139]=[C["COM.M1.BIOLOGICAL"]],I[140]=[C["COM.M1.RADIOLOGICAL"]],I[141]=[C["COM.M1.NUKLEAR"]],I[142]=[C["COM.M1.DECONTAMINATION"]],I[143]=[C["COM.M1.CIVILIAN"]],I[144]=[C["COM.M1.GOVERNMENT"]],I[145]=[C["COM.M1.ACCIDENT"]],I[146]=[C["COM.M1.ASSASSINATION"]],I[147]=[C["COM.M1.EXECUTION"]],I[148]=[C["COM.M1.KIDNAPPING"]],I[149]=[C["COM.M1.PIRACY"]],I[150]=[C["COM.M1.RAPE"]],I[151]=[C["COM.M1.ANTISUBMARINE WARFARE"]],I[152]=[C["COM.M1.ESCORT"]],I[153]=[C["COM.M1.MINE COUNTERMEASURES"]],I[154]=[C["COM.M1.MINE WARFARE"]],I[155]=[C["COM.M1.SURFACE WARFARE"]],I[156]=[C["COM.M1.INDEPENDENT COMMAND"]],I[157]=[C["COM.M1.COMPANY"]],I[158]=[C["COM.M1.PLATOON"]],I[159]=[C["COM.M1.REGIMENT"]],I[160]=[C["COM.M1.SECTION"]],I[161]=[C["COM.M1.SQUAD"]],I[162]=[C["COM.M1.TEAM"]],I[163]=[C["COM.M1.BATTALION"]],I[164]=[C["COM.MQ.LASER"]],I[165]=[C["COM.M1.HIJACKER"]],I[166]=[C["COM.M1.ELECTROMAGNETIC WARFARE"]],E[100]=[C["COM.M2.AIRBORNE"]],E[101]=[C["COM.M2.BICYCLE EQUIPPED"]],E[102]=[C["COM.M2.RAILROAD"]],E[103]=[C["COM.M2.SKI"]],E[104]=[C["COM.M2.TRACKED"]],E[105]=[C["COM.M2.WHEELED LIMITED"]],E[106]=[C["COM.M2.WHEELED"]],E[107]=[C["COM.M2.FIXED WING"]],E[108]=[C["COM.M2.ROTARY WING"]],E[109]=[C["COM.M2.ROBOTIC"]],E[110]=[C["COM.M2.AUTONOMOUS CONTROL"]],E[111]=[C["COM.M2.REMOTELY PILOTED"]],E[112]=[C["COM.M2.EXPENDABLE"]],E[113]=[C["COM.M2.MOUNTAIN"]],E[114]=[C["COM.M2.LONG RANGE"]],E[115]=[C["COM.M2.MEDIUM RANGE"]],E[116]=[C["COM.M2.SHORT RANGE"]],E[117]=[C["COM.M2.CLOSE RANGE"]],E[118]=[C["COM.M2.HEAVY"]],E[119]=[C["COM.M2.MEDIUM"]],E[120]=[C["COM.M2.LIGHT AND MEDIUM"]],E[121]=[C["COM.M2.LIGHT"]],E[122]=[C["COM.M2.CYBERSPACE"]],E[123]=[C["COM.M2.SECURITY FORCE ASSISTANCE"]],E[124]=[C["COM.M2.BED"]],E[125]=[C["COM.M2.MULTIFUNCTIONAL"]]}},y,x,p,D,F,f,z,H,V,J,q,j,$,I0,t0,E0];return L.addIcons([I,S,O,i,M,G,n,h,{type:"letter",getMetadata:e,getIcons:R,iconParts:[d],labels:function(t){t["G-T-GD----"]={},t["G-T-GI----"]={},t["G-T-GN----"]={},t["G-C-MGPFE-"]={},t["G-C-MGPFA-"]={},t["G-C-MGPFO-"]={},t["G-C-MGPI--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:30,fontsize:45,fontweight:"bold"}},t["G-C-MAAP--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},t["G-C-MAAC--"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:135,fontsize:45,fontweight:"bold"}},t["G-C-MAAU--"]={},t["G-C-MAAD--"]={},t["G-C-MDN---"]={},t["G-C-MMPT--"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:115,y:85,fontsize:45,fontweight:"bold"}},t["G-C-MMPO--"]={},t["G-C-MMPOC-"]={},t["G-C-MMPOR-"]={},t["G-C-MMPOF-"]={},t["G-C-MMPOS-"]={},t["G-C-MMPON-"]={},t["G-C-MMPON-"]={},t["G-C-MMPON-"]={},t["G-C-MOPD--"]={},t["G-C-BOATD-"]={},t["G-C-BOAB--"]={},t["G-C-BOAMA-"]={},t["G-C-BOAMT-"]={},t["G-C-BOAMD-"]={},t["G-C-BOAMC-"]={},t["G-C-BOAMU-"]={},t["G-C-BOAMN-"]={},t["G-C-BOAIP-"]={},t["G-C-BOAIC-"]={},t["G-C-BOAIN-"]={},t["G-C-BOAIS-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},t["G-C-BOAIH-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},t["G-C-BOAID-"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},t["G-C-BOAV--"]={dtg:{stroke:!1,textanchor:"middle",x:100,y:165,fontsize:30,fontweight:"bold"}},t["G-C-BYCG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BSE---"]={},t["G-C-BSF---"]={},t["G-C-BSH---"]={},t["G-C-BSU---"]={},t["G-C-BWN---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-C-BWE---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-C-BWI---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-C-BWF---"]={additionalInformation:{stroke:!1,textanchor:"start",x:150,y:20,fontsize:35},dtg:{stroke:!1,textanchor:"end",x:50,y:20,fontsize:35},hostile:{stroke:!1,textanchor:"start",x:150,y:100,fontsize:35},location:{stroke:!1,textanchor:"middle",x:100,y:140,fontsize:35},quantity:{stroke:!1,textanchor:"middle",x:100,y:-25,fontsize:35},type:{stroke:!1,textanchor:"end",x:50,y:60,fontsize:35},uniqueDesignation:{stroke:!1,textanchor:"end",x:50,y:100,fontsize:35}},t["G-C-BWP---"]={},t["G-C-BWDP--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDS--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDO--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDEM-"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-BWDTF-"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-FSTP--"]={additionalInformation:{stroke:!1,textanchor:"start",x:120,y:145,fontsize:40},altitudeDepth:{stroke:!1,textanchor:"end",x:80,y:145,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40}},t["G-C-FSS---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:125,y:115,fontsize:40,fontweight:"bold"}},t["G-C-FAU---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:120,y:80,fontsize:40,fontweight:"bold"}},t["G-C-SPA---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPY---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPT---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPD---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPE---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPM---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPU---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPO---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPN---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQB--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQC--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQD--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQE--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQF--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQG--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQH--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQI--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPQJ--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPMA--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-SPMT--"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OX----"]={},t["G-C-OXRN--"]={},t["G-C-OXRD--"]={},t["G-C-OXUD--"]={},t["G-C-OXUB--"]={},t["G-C-OXUL--"]={},t["G-C-OXUS--"]={},t["G-C-OXWA--"]={},t["G-C-OXWD--"]={},t["G-C-OXWE--"]={},t["G-C-OXWG--"]={},t["G-C-OXWM--"]={},t["G-C-OXWI--"]={},t["G-C-OXWP--"]={},t["G-C-OXY---"]={},t["G-C-OXYP--"]={},t["G-C-OXYD--"]={},t["G-C-OXYL--"]={},t["G-C-OXYC--"]={},t["G-C-OXYS--"]={},t["G-C-OXYB--"]={},t["G-C-OXYA--"]={},t["G-C-OXYV--"]={},t["G-C-OXYT--"]={},t["G-C-OXYR--"]={},t["G-C-OXYK--"]={},t["G-C-OXN---"]={},t["G-C-OXH---"]={},t["G-C-OXHQ--"]={},t["G-C-OXHA--"]={},t["G-C-OXHY--"]={},t["G-C-OXHX--"]={},t["G-C-OXR---"]={},t["G-C-OXRR--"]={},t["G-C-OXRD--"]={},t["G-C-OXRW--"]={},t["G-C-OXRP--"]={},t["G-C-OXRT--"]={},t["G-C-OXSTC-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTCP"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTCA"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTR-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTH-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTS-"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXSTSA"]={dtg:{stroke:!1,textanchor:"start",x:140,y:92,fontsize:30,fontweight:"bold"},dtg1:{stroke:!1,textanchor:"start",x:140,y:128,fontsize:30,fontweight:"bold"}},t["G-C-OXS---"]={},t["G-C-OXSA--"]={},t["G-C-OXSD--"]={},t["G-C-OXSC--"]={},t["G-C-OXAC--"]={},t["G-C-OXAA--"]={},t["G-C-OXAT--"]={},t["G-C-OXAK--"]={},t["G-C-OXAF--"]={},t["G-C-OXAH--"]={},t["G-C-OXAO--"]={},t["G-C-OXAR--"]={},t["G-C-OXAP--"]={},t["G-C-OXAM--"]={},t["G-C-OXAS--"]={},t["G-C-OXAD--"]={},t["G-C-OG----"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGC---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},uniqueDesignation1:{stroke:!1,textanchor:"middle",x:100,y:10,fontsize:35,fontweight:"bold"},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGP---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:40,fontsize:45,fontweight:"bold"}},t["G-C-OGT---"]={},t["G-C-OGD---"]={uniqueDesignation:{stroke:!1,textanchor:"middle",x:100,y:115,fontsize:45,fontweight:"bold"}},t["G-C-OGL---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGN---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGR---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGS---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGI---"]={additionalInformation:{stroke:!1,textanchor:"middle",x:100,y:-70,fontsize:40},hostile:{stroke:!1,textanchor:"start",x:150,y:45,fontsize:40},uniqueDesignation:{stroke:!1,textanchor:"start",x:150,y:-30,fontsize:40},dtg:{stroke:!1,textanchor:"end",x:50,y:-30,fontsize:40},dtg1:{stroke:!1,textanchor:"end",x:50,y:10,fontsize:40}},t["G-C-OGW---"]={uniqueDesignation:{stroke:!1,textanchor:"start",x:140,y:117,fontsize:50}},t["G-O-VA----"]={},t["G-O-VR----"]={},t["G-O-VE----"]={},t["G-O-VB----"]={},t["G-O-VY----"]={},t["G-O-VD----"]={},t["G-O-VI----"]={},t["G-O-VM----"]={},t["G-O-VK----"]={},t["G-O-VS----"]={},t["G-O-VP----"]={},t["G-O-VU----"]={},t["G-O-VC----"]={},t["G-O-VH----"]={},t["G-O-VF----"]={},t["G-O-VO----"]={},t["G-O-VL----"]={},t["G-O-VX----"]={},t["G-O-VZ----"]={},t["G-O-LB----"]={},t["G-O-LG----"]={},t["G-O-LW----"]={},t["G-O-PR----"]={},t["G-O-PRB---"]={},t["G-O-PT----"]={},t["G-O-PC----"]={},t["G-O-PCU---"]={},t["G-O-PD----"]={},t["G-O-PM----"]={},t["G-O-PH----"]={},t["G-O-PHY---"]={},t["G-O-PHW---"]={},t["G-O-PHG---"]={},t["G-O-PHT---"]={},t["G-O-PG----"]={},t["G-O-PS----"]={},t["G-O-PF----"]={},t["G-O-PI----"]={},t["G-O-PE----"]={},t["G-O-PX----"]={},t["G-O-PJV---"]={},t["G-O-PJA---"]={},t["G-O-PJB---"]={},t["G-O-PK----"]={},t["G-O-PA----"]={},t["G-O-PO----"]={},t["G-O-IR----"]={},t["G-O-IS----"]={},t["G-O-IG----"]={},t["G-O-IV----"]={},t["G-O-IK----"]={},t["G-O-ID----"]={},t["G-O-IF----"]={}},icons:function(t,I,E,e){t["G-T-GD----"]=E["TP.DESTROY"],I["G-T-GD----"]={x1:0,x2:200,y1:40,y2:160},t["G-T-GI----"]=E["TP.INTERDICT"],I["G-T-GI----"]={x1:0,x2:200,y1:40,y2:160},t["G-T-GN----"]=E["TP.NEUTRALIZE"],I["G-T-GN----"]={x1:0,x2:200,y1:40,y2:160},t["G-C-MGPFE-"]=E["TP.FIX ELECTRO-MAGNETIC"],t["G-C-MGPFA-"]=E["TP.FIX ACOUSTIC"],t["G-C-MGPFO-"]=E["TP.FIX ELECTRO-OPTICAL"],t["G-C-MGPI--"]=E["TP.POINT OF INTEREST"],I["G-C-MGPI--"]={x1:50,x2:150,y1:-25},t["G-C-MAAP--"]=E["TP.AIR CONTROL POINT (ACP)"],I["G-C-MAAP--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-MAAC--"]=E["TP.COMMUNICATIONS CHECKPOINT"],I["G-C-MAAC--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-MAAU--"]=E["TP.PULL-UP POINT"],I["G-C-MAAU--"]={x1:50,x2:240,y1:50,y2:150},t["G-C-MAAD--"]=E["TP.DOWNED AIRCREW PICKUP POINT"],I["G-C-MAAD--"]={x1:60,x2:140,y1:-60},t["G-C-MDN---"]=E["TP.DUMMY MINEFIELD"],I["G-C-MDN---"]={x1:40,x2:160,y1:-10,y2:140},t["G-C-MMPT--"]=E["TP.TARGET REFERENCE"],t["G-C-MMPO--"]=E["TP.OBSERVATION POST/OUTPOST"],I["G-C-MMPO--"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MMPOC-"]=E["TP.COMBAT OUTPOST"],I["G-C-MMPOC-"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MMPOR-"]=E["TP.OBSERVATION POST/RECONNAISSANCE"],I["G-C-MMPOR-"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MMPOF-"]=E["TP.FORWARD OBSERVER POSITION"],I["G-C-MMPOF-"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MMPOS-"]=E["TP.SENSOR OUTPOST"],I["G-C-MMPOS-"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MMPON-"]=E["TP.CBRN OBSERVATION POST"],I["G-C-MMPON-"]={x1:50,x2:150,y1:40,y2:150},t["G-C-MOPD--"]=E["TP.POINT OF DEPARTURE"],I["G-C-MOPD--"]={x1:60,x2:140,y1:-60},t["G-C-BOATD-"]=E["TP.FIXED AND PREFABRICATED"],I["G-C-BOATD-"]={x1:60,x2:140,y1:30},t["G-C-BOAB--"]=E["TP.BOOBY TRAP"],t["G-C-BOAMA-"]=E["TP.ANTIPERSONNEL (AP) MINES"],t["G-C-BOAMT-"]=E["TP.ANTITANK MINE (AT)"],t["G-C-BOAMD-"]=E["TP.(AT) ANTIHANDLING DEVICE"],I["G-C-BOAMD-"]={x1:60,x2:140,y1:40,y2:195},t["G-C-BOAMC-"]=E["TP.(AT) DIRECTIONAL"],I["G-C-BOAMC-"]={x1:60,x2:140,y1:10,y2:140},t["G-C-BOAMU-"]=E["TP.UNSPECIFIED MINE"],t["G-C-BOAMW-"]=E["TP.WIDE AREA MINES"],t["G-C-BOAIP-"]=E["TP.PLANNED MINEFIELD"],I["G-C-BOAIP-"]={x1:40,x2:160,y1:60,y2:140},t["G-C-BOAIC-"]=E["TP.MINEFIELDS STATIC"],I["G-C-BOAIC-"]={x1:40,x2:160,y1:60,y2:140},t["G-C-BOAIN-"]=E["TP.ANTITANK (AT) MINEFIELD"],I["G-C-BOAIN-"]={x1:40,x2:160,y1:60,y2:140},t["G-C-BOAIS-"]=E["TP.SCATTERABLE MINES"],I["G-C-BOAIS-"]={x1:40,x2:160,y1:20,y2:140},t["G-C-BOAIH-"]=E["TP.ANTIPERSONNEL (AP) MINEFIELD"],I["G-C-BOAIH-"]={x1:40,x2:160,y1:20,y2:140},t["G-C-BOAID-"]=E["TP.SCATTERABLE MINEFIELD WITH SELF-DESTRUCT"],I["G-C-BOAID-"]={x1:40,x2:160,y1:20,y2:140},t["G-C-BOAV--"]=E["TP.VOLCANO MINEFIELD"],I["G-C-BOAV--"]={x1:40,x2:160,y1:20,y2:140},t["G-C-BYCG--"]=E["TP.ENGINEER REGULATING POINT"],I["G-C-BYCG--"]={x1:60,x2:140,y1:-60},t["G-C-BSE---"]=E["TP.EARTHWORK/FORTIFICATION"],t["G-C-BSF---"]=E["TP.FORT"],t["G-C-BSH---"]=E["TP.SURFACE SHELTER"],t["G-C-BSU---"]=E["TP.UNDERGROUND SHELTER"],t["G-C-BWN---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],I["G-C-BWN---"]={x1:60,x2:140,y1:-20},t["G-C-BWE---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO"],I["G-C-BWE---"]={x1:60,x2:140,y1:-20},t["G-C-BWI---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"],I["G-C-BWI---"]={x1:60,x2:140,y1:-20},t["G-C-BWF---"]=E["TP.NUCLEAR DETONATIONS GROUND ZERO PLANNED"],I["G-C-BWF---"]={x1:60,x2:140,y1:-20},t["G-C-BWP---"]=E["TP.NUCLEAR FALLOUT PRODUCING"],I["G-C-BWP---"]={x1:50,x2:150,y1:-20},t["G-C-BWDP--"]=E["TP.DECON SITE/POINT"],I["G-C-BWDP--"]={x1:60,x2:140,y1:-60},t["G-C-BWDA--"]=E["TP.ALTERNATE DECON SITE/POINT"],I["G-C-BWDA--"]={x1:60,x2:140,y1:-60},t["G-C-BWDT--"]=E["TP.DECON SITE/POINT (TROOPS)"],I["G-C-BWDT--"]={x1:60,x2:140,y1:-60},t["G-C-BWDE--"]=E["TP.DECON SITE/POINT (EQUIPMENT)"],I["G-C-BWDE--"]={x1:60,x2:140,y1:-60},t["G-C-BWDS--"]=E["TP.DECON SITE/POINT (EQUIPMENT AND TROOPS)"],I["G-C-BWDS--"]={x1:60,x2:140,y1:-60},t["G-C-BWDO--"]=E["TP.DECON SITE/POINT (OPERATIONAL DECONTAMINATION)"],I["G-C-BWDO--"]={x1:60,x2:140,y1:-60},t["G-C-BWDG--"]=E["TP.DECON SITE/POINT (THOROUGH DECONTAMINATION)"],I["G-C-BWDG--"]={x1:60,x2:140,y1:-60},t["G-C-BWDEM-"]=E["TP.DECON POINT (MAIN) EQUIPMENT"],I["G-C-BWDEM-"]={x1:60,x2:140,y1:-60},t["G-C-BWDTF-"]=E["TP.DECON POINT (FORWARD) TROOPS"],I["G-C-BWDTF-"]={x1:60,x2:140,y1:-60},t["G-C-FSTP--"]=E["TP.POINT/SINGLE TARGET"],t["G-C-FSS---"]=E["TP.FIRE SUPPORT STATION"],t["G-C-FAU---"]=E["TP.NUCLEAR TARGET"],t["G-C-SPA---"]=E["TP.AMBULANCE EXCHANGE POINT"],I["G-C-SPA---"]={x1:60,x2:140,y1:-60},t["G-C-SPC---"]=E["TP.CANNIBALIZATION POINT"],I["G-C-SPC---"]={x1:60,x2:140,y1:-60},t["G-C-SPY---"]=E["TP.CASUALTY COLLECTION POINT"],I["G-C-SPY---"]={x1:60,x2:140,y1:-60},t["G-C-SPT---"]=E["TP.CIVILIAN COLLECTION POINT"],I["G-C-SPT---"]={x1:60,x2:140,y1:-60},t["G-C-SPD---"]=E["TP.DETAINEE COLLECTION POINT"],I["G-C-SPD---"]={x1:60,x2:140,y1:-60},t["G-C-SPE---"]=E["TP.EPW COLLECTION POINT"],I["G-C-SPE---"]={x1:60,x2:140,y1:-60},t["G-C-SPL---"]=E["TP.LOGISTICS RELEASE POINT"],I["G-C-SPL---"]={x1:60,x2:140,y1:-60},t["G-C-SPM---"]=E["TP.MAINTENANCE COLLECTION POINT"],I["G-C-SPM---"]={x1:60,x2:140,y1:-60},t["G-C-SPR---"]=E["TP.REARM, REFUEL AND RESUPPLY POINT"],I["G-C-SPR---"]={x1:60,x2:140,y1:-60},t["G-C-SPU---"]=E["TP.REFUEL ON THE MOVE POINT"],I["G-C-SPU---"]={x1:60,x2:140,y1:-60},t["G-C-SPO---"]=E["TP.TRAFFIC CONTROL POST"],I["G-C-SPO---"]={x1:60,x2:140,y1:-60},t["G-C-SPI---"]=E["TP.TRAILER TRANSFER POINT"],I["G-C-SPI---"]={x1:60,x2:140,y1:-60},t["G-C-SPN---"]=E["TP.UNIT MAINTENANCE COLLECTION POINT"],I["G-C-SPN---"]={x1:60,x2:140,y1:-60},t["G-C-SPQT--"]=E["TP.SUPPLY POINT"],I["G-C-SPQT--"]={x1:60,x2:140,y1:-60},t["G-C-SPQA--"]=E["TP.SP CLASS I"],I["G-C-SPQA--"]={x1:60,x2:140,y1:-60},t["G-C-SPQB--"]=E["TP.SP CLASS II"],I["G-C-SPQB--"]={x1:60,x2:140,y1:-60},t["G-C-SPQC--"]=E["TP.SP CLASS III"],I["G-C-SPQC--"]={x1:60,x2:140,y1:-60},t["G-C-SPQD--"]=E["TP.SP CLASS IV"],I["G-C-SPQD--"]={x1:60,x2:140,y1:-60},t["G-C-SPQE--"]=E["TP.SP CLASS V"],I["G-C-SPQE--"]={x1:60,x2:140,y1:-60},t["G-C-SPQF--"]=E["TP.SP CLASS VI"],I["G-C-SPQF--"]={x1:60,x2:140,y1:-60},t["G-C-SPQG--"]=E["TP.SP CLASS VII"],I["G-C-SPQG--"]={x1:60,x2:140,y1:-60},t["G-C-SPQH--"]=E["TP.SP CLASS VIII"],I["G-C-SPQH--"]={x1:60,x2:140,y1:-60},t["G-C-SPQI--"]=E["TP.SP CLASS IX"],I["G-C-SPQI--"]={x1:60,x2:140,y1:-60},t["G-C-SPQJ--"]=E["TP.SP CLASS X"],I["G-C-SPQJ--"]={x1:60,x2:140,y1:-60},t["G-C-SPMA--"]=E["TP.AMMUNITION SUPPLY POINT (ASP)"],I["G-C-SPMA--"]={x1:60,x2:140,y1:-60},t["G-C-SPMT--"]=E["TP.AMMUNITION TRANSFER POINT (ATP)"],I["G-C-SPMT--"]={x1:60,x2:140,y1:-60},t["G-C-OX----"]=E["TP.SPECIAL POINT"],I["G-C-OX----"]={x1:40,x2:160,y1:40,y2:160},t["G-C-OXRN--"]=E["TP.NAVIGATIONAL REFERENCE"],I["G-C-OXRN--"]={x1:40,x2:160,y1:40,y2:160},t["G-C-OXUD--"]=E["TP.DATUM"],I["G-C-OXUD--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXUB--"]=E["TP.BRIEF CONTACT"],I["G-C-OXUB--"]={x1:50,x2:150,y1:0,y2:100},t["G-C-OXUL--"]=E["TP.LOST CONTACT"],I["G-C-OXUL--"]={x1:50,x2:150,y1:0,y2:100},t["G-C-OXUS--"]=E["TP.SINKER"],I["G-C-OXUS--"]={x1:50,x2:150,y1:0,y2:100},t["G-C-OXWA--"]=E["TP.AIM POINT"],I["G-C-OXWA--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXWD--"]=E["TP.DROP POINT"],I["G-C-OXWD--"]={x1:50,x2:150,y1:50,y2:120},t["G-C-OXWE--"]=E["TP.ENTRY POINT"],I["G-C-OXWE--"]={x1:50,x2:150,y1:50},t["G-C-OXWG--"]=E["TP.GROUND ZERO"],I["G-C-OXWG--"]={x1:50,x2:150,y1:30},t["G-C-OXWM--"]=E["TP.MSL DETECT POINT"],I["G-C-OXWM--"]={x1:50,x2:150,y1:30},t["G-C-OXWI--"]=E["TP.IMPACT POINT"],I["G-C-OXWI--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXWP--"]=E["TP.PREDICTED IMPACT POINT"],I["G-C-OXWP--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXY---"]=E["TP.SONOBUOY"],I["G-C-OXY---"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYP--"]=E["TP.SONOBUOY PATTERN CENTER"],I["G-C-OXYP--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYD--"]=E["TP.SONOBUOY DIFAR"],I["G-C-OXYD--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYL--"]=E["TP.SONOBUOY LOFAR"],I["G-C-OXYL--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYC--"]=E["TP.SONOBUOY CASS"],I["G-C-OXYC--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYS--"]=E["TP.SONOBUOY DICASS"],I["G-C-OXYS--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYB--"]=E["TP.SONOBUOY BT"],I["G-C-OXYB--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYA--"]=E["TP.SONOBUOY ANM"],I["G-C-OXYA--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYV--"]=E["TP.SONOBUOY VLAD"],I["G-C-OXYV--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYT--"]=E["TP.SONOBUOY ATAC"],I["G-C-OXYT--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYR--"]=E["TP.SONOBUOY RO"],I["G-C-OXYR--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXYK--"]=E["TP.SONOBUOY KINGPIN"],I["G-C-OXYK--"]={x1:60,x2:140,y1:-10,y2:160},t["G-C-OXN---"]=E["TP.FORMATION"],I["G-C-OXN---"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXH---"]=E["TP.HARBOR"],I["G-C-OXH---"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXHQ--"]=E["TP.HARBOR POINT Q"],I["G-C-OXHQ--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXHA--"]=E["TP.HARBOR POINT A"],I["G-C-OXHA--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXHY--"]=E["TP.HARBOR POINT Y"],I["G-C-OXHY--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXHX--"]=E["TP.HARBOR POINT X"],I["G-C-OXHX--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXR---"]=E["TP.ROUTE"],I["G-C-OXR---"]={x1:30,x2:170,y1:60,y2:140},t["G-C-OXRR--"]=E["TP.ROUTE RENDEZVOUS"],I["G-C-OXRR--"]={x1:30,x2:170,y1:60,y2:170},t["G-C-OXRD--"]=E["TP.ROUTE DIVERSIONS"],I["G-C-OXRD--"]={x1:30,x2:170,y1:60,y2:170},t["G-C-OXRW--"]=E["TP.ROUTE WAYPOINT"],I["G-C-OXRW--"]={x1:30,x2:170,y1:60,y2:170},t["G-C-OXRP--"]=E["TP.ROUTE PIM"],I["G-C-OXRP--"]={x1:30,x2:170,y1:60,y2:170},t["G-C-OXRT--"]=E["TP.ROUTE POINT R"],I["G-C-OXRT--"]={x1:30,x2:170,y1:60,y2:170},t["G-C-OXSTC-"]=E["TP.COMBATANT STATION"],I["G-C-OXSTC-"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTCP"]=E["TP.PICKET STATION"],I["G-C-OXSTCP"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTCA"]=E["TP.ASW SHIP STATION"],I["G-C-OXSTCA"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTR-"]=E["TP.REPLENISHMENT AT SEA (RAS) STATION"],I["G-C-OXSTR-"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTH-"]=E["TP.RESCUE STATION"],I["G-C-OXSTH-"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTS-"]=E["TP.SUBMARINE STATION"],I["G-C-OXSTS-"]={x1:-15,x2:140,y1:60,y2:140},t["G-C-OXSTSA"]=E["TP.ASW SUBMARINE STATION"],I["G-C-OXSTSA"]={x1:-115,x2:140,y1:60,y2:140},t["G-C-OXS---"]=E["TP.SEARCH"],I["G-C-OXS---"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXSA--"]=E["TP.SEARCH AREA"],I["G-C-OXSA--"]={x1:20,x2:150,y1:50,y2:150},t["G-C-OXSD--"]=E["TP.DIP POSITION"],I["G-C-OXSD--"]={x1:10,x2:150,y1:50,y2:150},t["G-C-OXSC--"]=E["TP.SEARCH CENTER"],I["G-C-OXSC--"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OXAC--"]=E["TP.COMBAT AIR PATROL (CAP)"],I["G-C-OXAC--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAA--"]=E["TP.AIRBORNE EARLY WARNING (AEW)"],I["G-C-OXAA--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAT--"]=E["TP.TACAN"],I["G-C-OXAT--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAK--"]=E["TP.TANKING"],I["G-C-OXAK--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAF--"]=E["TP.ASW FIXED WING"],I["G-C-OXAF--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAH--"]=E["TP.ROTARY WING"],I["G-C-OXAH--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAO--"]=E["TP.TOMCAT"],I["G-C-OXAO--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAR--"]=E["TP.RESCUE"],I["G-C-OXAR--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAP--"]=E["TP.REPLENISH"],I["G-C-OXAP--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAM--"]=E["TP.MARSHALL"],I["G-C-OXAM--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAS--"]=E["TP.STRIKE IP"],I["G-C-OXAS--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OXAD--"]=E["TP.CORRIDOR TAB POINT"],I["G-C-OXAD--"]={x1:60,x2:140,y1:40,y2:160},t["G-C-OG----"]=E["TP.ACTION POINT"],I["G-C-OG----"]={x1:60,x2:140,y1:-60},t["G-C-OGC---"]=E["TP.ACTION POINT"],I["G-C-OGC---"]={x1:60,x2:140,y1:-60},t["G-C-OGP---"]=E["TP.CONTACT POINT"],I["G-C-OGP---"]={x1:55,x2:145,y1:-10},t["G-C-OGT---"]=E["TP.COORDINATION POINT"],I["G-C-OGT---"]={x1:50,x2:150,y1:50,y2:150},t["G-C-OGD---"]=E["TP.DECISION POINT"],I["G-C-OGD---"]={x1:30,x2:170,y1:25,y2:160},t["G-C-OGL---"]=E["TP.ACTION LINKUP POINT"],I["G-C-OGL---"]={x1:60,x2:140,y1:-60},t["G-C-OGN---"]=E["TP.ACTION PASSAGE POINT"],I["G-C-OGN---"]={x1:60,x2:140,y1:-60},t["G-C-OGR---"]=E["TP.ACTION RALLY POINT"],I["G-C-OGR---"]={x1:60,x2:140,y1:-60},t["G-C-OGS---"]=E["TP.ACTION RELEASE POINT"],I["G-C-OGS---"]={x1:60,x2:140,y1:-60},t["G-C-OGI---"]=E["TP.ACTION START POINT"],I["G-C-OGI---"]={x1:60,x2:140,y1:-60},t["G-C-OGW---"]=E["TP.WAYPOINT"],I["G-C-OGW---"]={x1:60,x2:140,y1:60,y2:140},t["G-O-VA----"]=E["TP.FIRE"],t["G-O-VR----"]=E["GR.EQ.HOWITZER"],t["G-O-VE----"]=E["ST.IC.KILLING VICTIM"],t["G-O-VB----"]=E["AIR.MISSILE.IC.BOMB"],t["G-O-VY----"]=E["ST.IC.BOOBY TRAP"],t["G-O-VD----"]=E["ST.IC.DRIVE-BY SHOOTING"],t["G-O-VI----"]=E["TP.INDIRECT FIRE"],t["G-O-VM----"]=E["GR.EQ.MORTAR"],t["G-O-VK----"]=E["GR.EQ.MULTIPLE ROCKET LAUNCHER"],t["G-O-VS----"]=E["ST.IC.SNIPING"],t["G-O-VP----"]=E["ST.IC.POISONING"],t["G-O-VU----"]=E["TP.AMBUSH"],t["G-O-VC----"]=E["GR.IC.FF.CLASS V"],t["G-O-VH----"]=E["AR.I.FF.CIVILIAN ROTARY WING"],t["G-O-VF----"]=[E["GR.IC.FF.INFANTRY"],E["GR.IC.FF.MOTORIZED"]],t["G-O-VO----"]=E["GR.IC.FF.INFANTRY"],t["G-O-VL----"]=E["GR.IC.FF.RECONNAISSANCE"],t["G-O-VX----"]=E["GR.IC.FF.SIGNAL"],t["G-O-VZ----"]=E["GR.IC.FF.SUPPLY"],t["G-O-LB----"]=E["ST.IC.BLACK LIST LOCATION"],t["G-O-LG----"]=E["ST.IC.GRAY LIST LOCATION"],t["G-O-LW----"]=E["ST.IC.WHITE LIST LOCATION"],t["G-O-PR----"]=E["TP.ROAD BLOCK"],t["G-O-PRB---"]=E["TP.ROAD BLOCK (UNDER CONSTRUCTION)"],t["G-O-PT----"]=E["ST.IC.PATROLLING"],t["G-O-PC----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.WILLING"]],t["G-O-PCU---"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.COERCED/IMPRESSED"]],t["G-O-PD----"]=E["ST.IC.DEMONSTRATION"],t["G-O-PM----"]=E["ST.IC.MINE LAYING"],t["G-O-PH----"]=E["ST.IC.PSYCHOLOGICAL OPERATIONS"],t["G-O-PHY---"]=E["ST.IC.RADIO AND TELEVISION PSYCHOLOGICAL OPERATIONS"],t["G-O-PHW---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],t["G-O-PHG---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.WRITTEN PSYCHOLOGICAL OPERATIONS"]],t["G-O-PHT---"]=[E["ST.IC.PSYCHOLOGICAL OPERATIONS"],E["ST.M1.HOUSE-TO-HOUSE"]],t["G-O-PG----"]=E["ST.IC.SEARCHING"],t["G-O-PS----"]=E["ST.IC.SPY"],t["G-O-PF----"]=E["ST.IC.FOOD DISTRIBUTION"],t["G-O-PI----"]=E["GR.IC.FF.MEDICAL TREATMENT FACILITY"],t["G-O-PE----"]=[E["GR.IC.ELECTRONIC WARFARE"],E["GR.IC.FF.INTERCEPT"]],t["G-O-PX----"]=E["ST.IC.EXTORTION"],t["G-O-PJV---"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.HIJACKING/HIJACKED"]],t["G-O-PJA---"]=[E["ST.IC.HIJACKING (AIRPLANE)"],E["ST.M1.HIJACKING/HIJACKED"]],t["G-O-PJB---"]=[E["ST.IC.HIJACKING (BOAT)"],E["ST.M1.HIJACKING/HIJACKED"]],t["G-O-PK----"]=[E["ST.IC.INDIVIDUAL"],E["ST.M1.KIDNAPPING"]],t["G-O-PA----"]=E["ST.IC.ARREST"],t["G-O-PO----"]=E["ST.IC.DRUG RELATED ACTIVITIES"],t["G-O-IR----"]=E["ST.IC.GROUP"],t["G-O-IS----"]=E["ST.IC.SAFE HOUSE"],t["G-O-IG----"]=E["ST.IC.GRAFFITI"],t["G-O-IV----"]=E["ST.IC.VANDALISM/LOOT/RANSACK/PLUNDER/SACK"],t["G-O-IK----"]=E["ST.IC.KNOWN INSURGENT VEHICLE"],t["G-O-ID----"]=[E["ST.IC.KNOWN INSURGENT VEHICLE"],E["ST.M1.DRUG"]],t["G-O-IF----"]=E["ST.IC.INTERNAL SECURITY FORCE"]}}]),L.addIcons(_),L.addIcons(c),L.addIcons(e0),L.addIcons(R0),L.addIcons(y),L.Path2D=function(t,I){t.beginPath();let E,e,R,C,A,T,S,N,O,i,M;var G=I.match(/([MCLHV][^MCLHV]*)/gi);for(S=0;S<G.length;S++){if("M"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),E=parseFloat(M[0]),e=parseFloat(M[1]),O=E,i=e,t.moveTo(E,e),N=2;N<M.length;N+=2)E=parseFloat(M[N]),e=parseFloat(M[N+1]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(t.closePath(),E=O,e=i)}if("m"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),E=E?E+parseFloat(M[0]):parseFloat(M[0]),e=e?e+parseFloat(M[1]):parseFloat(M[1]),O=E,i=e,t.moveTo(E,e),N=2;N<M.length;N+=2)E+=parseFloat(M[N]),e+=parseFloat(M[N+1]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(t.closePath(),E=O,e=i)}if("L"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<M.length;N+=2)E=parseFloat(M[N]),e=parseFloat(M[N+1]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&(t.closePath(),E=O,e=i)}if("l"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<M.length;N+=2)E+=parseFloat(M[N]),e+=parseFloat(M[N+1]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("C"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<M.length;N+=6)R=parseFloat(M[N]),C=parseFloat(M[N+1]),A=parseFloat(M[N+2]),T=parseFloat(M[N+3]),E=parseFloat(M[N+4]),e=parseFloat(M[N+5]),t.bezierCurveTo(R,C,A,T,E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("c"==G[S].charAt(0)){for(M=G[S].match(/[-\d].*[\d]/)[0].split(/[\s,]/g),N=0;N<M.length;N+=6)R=E+parseFloat(M[N]),C=e+parseFloat(M[N+1]),A=E+parseFloat(M[N+2]),T=e+parseFloat(M[N+3]),E+=parseFloat(M[N+4]),e+=parseFloat(M[N+5]),t.bezierCurveTo(R,C,A,T,E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("H"==G[S].charAt(0)){for(M=G[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<M.length;N++)E=parseFloat(M[N]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("h"==G[S].charAt(0)){for(M=G[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<M.length;N++)E+=parseFloat(M[N]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("V"==G[S].charAt(0)){for(M=G[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<M.length;N++)e=parseFloat(M[N]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}if("v"==G[S].charAt(0)){for(M=G[S].match(/[-\d](.*[\d])?/)[0].split(/[\s,]/g),N=0;N<M.length;N++)e+=parseFloat(M[N]),t.lineTo(E,e);"Z"==G[S].replace(/\s/g,"").substr(-1,1).toUpperCase()&&t.closePath()}}},L});