/**
 * mind.svg.js
 * @summary     Display and operate MindMap using SVG in browser
 * @version     0.6.8
 * @copyright   season studio
 * @license     MIT
 * @time        Tue Jul 07 2020 17:07:29 GMT+0800 (GMT+08:00)
 */

var MindSVG = (function (exports) {
	'use strict';

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var runtime_1 = createCommonjsModule(function (module) {
	/**
	 * Copyright (c) 2014-present, Facebook, Inc.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	var runtime = (function (exports) {

	  var Op = Object.prototype;
	  var hasOwn = Op.hasOwnProperty;
	  var undefined$1; // More compressible than void 0.
	  var $Symbol = typeof Symbol === "function" ? Symbol : {};
	  var iteratorSymbol = $Symbol.iterator || "@@iterator";
	  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	  function wrap(innerFn, outerFn, self, tryLocsList) {
	    // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	    var generator = Object.create(protoGenerator.prototype);
	    var context = new Context(tryLocsList || []);

	    // The ._invoke method unifies the implementations of the .next,
	    // .throw, and .return methods.
	    generator._invoke = makeInvokeMethod(innerFn, self, context);

	    return generator;
	  }
	  exports.wrap = wrap;

	  // Try/catch helper to minimize deoptimizations. Returns a completion
	  // record like context.tryEntries[i].completion. This interface could
	  // have been (and was previously) designed to take a closure to be
	  // invoked without arguments, but in all the cases we care about we
	  // already have an existing method we want to call, so there's no need
	  // to create a new function object. We can even get away with assuming
	  // the method takes exactly one argument, since that happens to be true
	  // in every case, so we don't have to touch the arguments object. The
	  // only additional allocation required is the completion record, which
	  // has a stable shape and so hopefully should be cheap to allocate.
	  function tryCatch(fn, obj, arg) {
	    try {
	      return { type: "normal", arg: fn.call(obj, arg) };
	    } catch (err) {
	      return { type: "throw", arg: err };
	    }
	  }

	  var GenStateSuspendedStart = "suspendedStart";
	  var GenStateSuspendedYield = "suspendedYield";
	  var GenStateExecuting = "executing";
	  var GenStateCompleted = "completed";

	  // Returning this object from the innerFn has the same effect as
	  // breaking out of the dispatch switch statement.
	  var ContinueSentinel = {};

	  // Dummy constructor functions that we use as the .constructor and
	  // .constructor.prototype properties for functions that return Generator
	  // objects. For full spec compliance, you may wish to configure your
	  // minifier not to mangle the names of these two functions.
	  function Generator() {}
	  function GeneratorFunction() {}
	  function GeneratorFunctionPrototype() {}

	  // This is a polyfill for %IteratorPrototype% for environments that
	  // don't natively support it.
	  var IteratorPrototype = {};
	  IteratorPrototype[iteratorSymbol] = function () {
	    return this;
	  };

	  var getProto = Object.getPrototypeOf;
	  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	  if (NativeIteratorPrototype &&
	      NativeIteratorPrototype !== Op &&
	      hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	    // This environment has a native %IteratorPrototype%; use it instead
	    // of the polyfill.
	    IteratorPrototype = NativeIteratorPrototype;
	  }

	  var Gp = GeneratorFunctionPrototype.prototype =
	    Generator.prototype = Object.create(IteratorPrototype);
	  GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	  GeneratorFunctionPrototype.constructor = GeneratorFunction;
	  GeneratorFunctionPrototype[toStringTagSymbol] =
	    GeneratorFunction.displayName = "GeneratorFunction";

	  // Helper for defining the .next, .throw, and .return methods of the
	  // Iterator interface in terms of a single ._invoke method.
	  function defineIteratorMethods(prototype) {
	    ["next", "throw", "return"].forEach(function(method) {
	      prototype[method] = function(arg) {
	        return this._invoke(method, arg);
	      };
	    });
	  }

	  exports.isGeneratorFunction = function(genFun) {
	    var ctor = typeof genFun === "function" && genFun.constructor;
	    return ctor
	      ? ctor === GeneratorFunction ||
	        // For the native GeneratorFunction constructor, the best we can
	        // do is to check its .name property.
	        (ctor.displayName || ctor.name) === "GeneratorFunction"
	      : false;
	  };

	  exports.mark = function(genFun) {
	    if (Object.setPrototypeOf) {
	      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	    } else {
	      genFun.__proto__ = GeneratorFunctionPrototype;
	      if (!(toStringTagSymbol in genFun)) {
	        genFun[toStringTagSymbol] = "GeneratorFunction";
	      }
	    }
	    genFun.prototype = Object.create(Gp);
	    return genFun;
	  };

	  // Within the body of any async function, `await x` is transformed to
	  // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	  // `hasOwn.call(value, "__await")` to determine if the yielded value is
	  // meant to be awaited.
	  exports.awrap = function(arg) {
	    return { __await: arg };
	  };

	  function AsyncIterator(generator, PromiseImpl) {
	    function invoke(method, arg, resolve, reject) {
	      var record = tryCatch(generator[method], generator, arg);
	      if (record.type === "throw") {
	        reject(record.arg);
	      } else {
	        var result = record.arg;
	        var value = result.value;
	        if (value &&
	            typeof value === "object" &&
	            hasOwn.call(value, "__await")) {
	          return PromiseImpl.resolve(value.__await).then(function(value) {
	            invoke("next", value, resolve, reject);
	          }, function(err) {
	            invoke("throw", err, resolve, reject);
	          });
	        }

	        return PromiseImpl.resolve(value).then(function(unwrapped) {
	          // When a yielded Promise is resolved, its final value becomes
	          // the .value of the Promise<{value,done}> result for the
	          // current iteration.
	          result.value = unwrapped;
	          resolve(result);
	        }, function(error) {
	          // If a rejected Promise was yielded, throw the rejection back
	          // into the async generator function so it can be handled there.
	          return invoke("throw", error, resolve, reject);
	        });
	      }
	    }

	    var previousPromise;

	    function enqueue(method, arg) {
	      function callInvokeWithMethodAndArg() {
	        return new PromiseImpl(function(resolve, reject) {
	          invoke(method, arg, resolve, reject);
	        });
	      }

	      return previousPromise =
	        // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(
	          callInvokeWithMethodAndArg,
	          // Avoid propagating failures to Promises returned by later
	          // invocations of the iterator.
	          callInvokeWithMethodAndArg
	        ) : callInvokeWithMethodAndArg();
	    }

	    // Define the unified helper method that is used to implement .next,
	    // .throw, and .return (see defineIteratorMethods).
	    this._invoke = enqueue;
	  }

	  defineIteratorMethods(AsyncIterator.prototype);
	  AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	    return this;
	  };
	  exports.AsyncIterator = AsyncIterator;

	  // Note that simple async functions are implemented on top of
	  // AsyncIterator objects; they just return a Promise for the value of
	  // the final result produced by the iterator.
	  exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	    if (PromiseImpl === void 0) PromiseImpl = Promise;

	    var iter = new AsyncIterator(
	      wrap(innerFn, outerFn, self, tryLocsList),
	      PromiseImpl
	    );

	    return exports.isGeneratorFunction(outerFn)
	      ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function(result) {
	          return result.done ? result.value : iter.next();
	        });
	  };

	  function makeInvokeMethod(innerFn, self, context) {
	    var state = GenStateSuspendedStart;

	    return function invoke(method, arg) {
	      if (state === GenStateExecuting) {
	        throw new Error("Generator is already running");
	      }

	      if (state === GenStateCompleted) {
	        if (method === "throw") {
	          throw arg;
	        }

	        // Be forgiving, per 25.3.3.3.3 of the spec:
	        // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
	        return doneResult();
	      }

	      context.method = method;
	      context.arg = arg;

	      while (true) {
	        var delegate = context.delegate;
	        if (delegate) {
	          var delegateResult = maybeInvokeDelegate(delegate, context);
	          if (delegateResult) {
	            if (delegateResult === ContinueSentinel) continue;
	            return delegateResult;
	          }
	        }

	        if (context.method === "next") {
	          // Setting context._sent for legacy support of Babel's
	          // function.sent implementation.
	          context.sent = context._sent = context.arg;

	        } else if (context.method === "throw") {
	          if (state === GenStateSuspendedStart) {
	            state = GenStateCompleted;
	            throw context.arg;
	          }

	          context.dispatchException(context.arg);

	        } else if (context.method === "return") {
	          context.abrupt("return", context.arg);
	        }

	        state = GenStateExecuting;

	        var record = tryCatch(innerFn, self, context);
	        if (record.type === "normal") {
	          // If an exception is thrown from innerFn, we leave state ===
	          // GenStateExecuting and loop back for another invocation.
	          state = context.done
	            ? GenStateCompleted
	            : GenStateSuspendedYield;

	          if (record.arg === ContinueSentinel) {
	            continue;
	          }

	          return {
	            value: record.arg,
	            done: context.done
	          };

	        } else if (record.type === "throw") {
	          state = GenStateCompleted;
	          // Dispatch the exception by looping back around to the
	          // context.dispatchException(context.arg) call above.
	          context.method = "throw";
	          context.arg = record.arg;
	        }
	      }
	    };
	  }

	  // Call delegate.iterator[context.method](context.arg) and handle the
	  // result, either by returning a { value, done } result from the
	  // delegate iterator, or by modifying context.method and context.arg,
	  // setting context.delegate to null, and returning the ContinueSentinel.
	  function maybeInvokeDelegate(delegate, context) {
	    var method = delegate.iterator[context.method];
	    if (method === undefined$1) {
	      // A .throw or .return when the delegate iterator has no .throw
	      // method always terminates the yield* loop.
	      context.delegate = null;

	      if (context.method === "throw") {
	        // Note: ["return"] must be used for ES3 parsing compatibility.
	        if (delegate.iterator["return"]) {
	          // If the delegate iterator has a return method, give it a
	          // chance to clean up.
	          context.method = "return";
	          context.arg = undefined$1;
	          maybeInvokeDelegate(delegate, context);

	          if (context.method === "throw") {
	            // If maybeInvokeDelegate(context) changed context.method from
	            // "return" to "throw", let that override the TypeError below.
	            return ContinueSentinel;
	          }
	        }

	        context.method = "throw";
	        context.arg = new TypeError(
	          "The iterator does not provide a 'throw' method");
	      }

	      return ContinueSentinel;
	    }

	    var record = tryCatch(method, delegate.iterator, context.arg);

	    if (record.type === "throw") {
	      context.method = "throw";
	      context.arg = record.arg;
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    var info = record.arg;

	    if (! info) {
	      context.method = "throw";
	      context.arg = new TypeError("iterator result is not an object");
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    if (info.done) {
	      // Assign the result of the finished delegate to the temporary
	      // variable specified by delegate.resultName (see delegateYield).
	      context[delegate.resultName] = info.value;

	      // Resume execution at the desired location (see delegateYield).
	      context.next = delegate.nextLoc;

	      // If context.method was "throw" but the delegate handled the
	      // exception, let the outer generator proceed normally. If
	      // context.method was "next", forget context.arg since it has been
	      // "consumed" by the delegate iterator. If context.method was
	      // "return", allow the original .return call to continue in the
	      // outer generator.
	      if (context.method !== "return") {
	        context.method = "next";
	        context.arg = undefined$1;
	      }

	    } else {
	      // Re-yield the result returned by the delegate method.
	      return info;
	    }

	    // The delegate iterator is finished, so forget it and continue with
	    // the outer generator.
	    context.delegate = null;
	    return ContinueSentinel;
	  }

	  // Define Generator.prototype.{next,throw,return} in terms of the
	  // unified ._invoke helper method.
	  defineIteratorMethods(Gp);

	  Gp[toStringTagSymbol] = "Generator";

	  // A Generator should always return itself as the iterator object when the
	  // @@iterator function is called on it. Some browsers' implementations of the
	  // iterator prototype chain incorrectly implement this, causing the Generator
	  // object to not be returned from this call. This ensures that doesn't happen.
	  // See https://github.com/facebook/regenerator/issues/274 for more details.
	  Gp[iteratorSymbol] = function() {
	    return this;
	  };

	  Gp.toString = function() {
	    return "[object Generator]";
	  };

	  function pushTryEntry(locs) {
	    var entry = { tryLoc: locs[0] };

	    if (1 in locs) {
	      entry.catchLoc = locs[1];
	    }

	    if (2 in locs) {
	      entry.finallyLoc = locs[2];
	      entry.afterLoc = locs[3];
	    }

	    this.tryEntries.push(entry);
	  }

	  function resetTryEntry(entry) {
	    var record = entry.completion || {};
	    record.type = "normal";
	    delete record.arg;
	    entry.completion = record;
	  }

	  function Context(tryLocsList) {
	    // The root entry object (effectively a try statement without a catch
	    // or a finally block) gives us a place to store values thrown from
	    // locations where there is no enclosing try statement.
	    this.tryEntries = [{ tryLoc: "root" }];
	    tryLocsList.forEach(pushTryEntry, this);
	    this.reset(true);
	  }

	  exports.keys = function(object) {
	    var keys = [];
	    for (var key in object) {
	      keys.push(key);
	    }
	    keys.reverse();

	    // Rather than returning an object with a next method, we keep
	    // things simple and return the next function itself.
	    return function next() {
	      while (keys.length) {
	        var key = keys.pop();
	        if (key in object) {
	          next.value = key;
	          next.done = false;
	          return next;
	        }
	      }

	      // To avoid creating an additional object, we just hang the .value
	      // and .done properties off the next function object itself. This
	      // also ensures that the minifier will not anonymize the function.
	      next.done = true;
	      return next;
	    };
	  };

	  function values(iterable) {
	    if (iterable) {
	      var iteratorMethod = iterable[iteratorSymbol];
	      if (iteratorMethod) {
	        return iteratorMethod.call(iterable);
	      }

	      if (typeof iterable.next === "function") {
	        return iterable;
	      }

	      if (!isNaN(iterable.length)) {
	        var i = -1, next = function next() {
	          while (++i < iterable.length) {
	            if (hasOwn.call(iterable, i)) {
	              next.value = iterable[i];
	              next.done = false;
	              return next;
	            }
	          }

	          next.value = undefined$1;
	          next.done = true;

	          return next;
	        };

	        return next.next = next;
	      }
	    }

	    // Return an iterator with no values.
	    return { next: doneResult };
	  }
	  exports.values = values;

	  function doneResult() {
	    return { value: undefined$1, done: true };
	  }

	  Context.prototype = {
	    constructor: Context,

	    reset: function(skipTempReset) {
	      this.prev = 0;
	      this.next = 0;
	      // Resetting context._sent for legacy support of Babel's
	      // function.sent implementation.
	      this.sent = this._sent = undefined$1;
	      this.done = false;
	      this.delegate = null;

	      this.method = "next";
	      this.arg = undefined$1;

	      this.tryEntries.forEach(resetTryEntry);

	      if (!skipTempReset) {
	        for (var name in this) {
	          // Not sure about the optimal order of these conditions:
	          if (name.charAt(0) === "t" &&
	              hasOwn.call(this, name) &&
	              !isNaN(+name.slice(1))) {
	            this[name] = undefined$1;
	          }
	        }
	      }
	    },

	    stop: function() {
	      this.done = true;

	      var rootEntry = this.tryEntries[0];
	      var rootRecord = rootEntry.completion;
	      if (rootRecord.type === "throw") {
	        throw rootRecord.arg;
	      }

	      return this.rval;
	    },

	    dispatchException: function(exception) {
	      if (this.done) {
	        throw exception;
	      }

	      var context = this;
	      function handle(loc, caught) {
	        record.type = "throw";
	        record.arg = exception;
	        context.next = loc;

	        if (caught) {
	          // If the dispatched exception was caught by a catch block,
	          // then let that catch block handle the exception normally.
	          context.method = "next";
	          context.arg = undefined$1;
	        }

	        return !! caught;
	      }

	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        var record = entry.completion;

	        if (entry.tryLoc === "root") {
	          // Exception thrown outside of any try block that could handle
	          // it, so set the completion value of the entire function to
	          // throw the exception.
	          return handle("end");
	        }

	        if (entry.tryLoc <= this.prev) {
	          var hasCatch = hasOwn.call(entry, "catchLoc");
	          var hasFinally = hasOwn.call(entry, "finallyLoc");

	          if (hasCatch && hasFinally) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            } else if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else if (hasCatch) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            }

	          } else if (hasFinally) {
	            if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else {
	            throw new Error("try statement without catch or finally");
	          }
	        }
	      }
	    },

	    abrupt: function(type, arg) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc <= this.prev &&
	            hasOwn.call(entry, "finallyLoc") &&
	            this.prev < entry.finallyLoc) {
	          var finallyEntry = entry;
	          break;
	        }
	      }

	      if (finallyEntry &&
	          (type === "break" ||
	           type === "continue") &&
	          finallyEntry.tryLoc <= arg &&
	          arg <= finallyEntry.finallyLoc) {
	        // Ignore the finally entry if control is not jumping to a
	        // location outside the try/catch block.
	        finallyEntry = null;
	      }

	      var record = finallyEntry ? finallyEntry.completion : {};
	      record.type = type;
	      record.arg = arg;

	      if (finallyEntry) {
	        this.method = "next";
	        this.next = finallyEntry.finallyLoc;
	        return ContinueSentinel;
	      }

	      return this.complete(record);
	    },

	    complete: function(record, afterLoc) {
	      if (record.type === "throw") {
	        throw record.arg;
	      }

	      if (record.type === "break" ||
	          record.type === "continue") {
	        this.next = record.arg;
	      } else if (record.type === "return") {
	        this.rval = this.arg = record.arg;
	        this.method = "return";
	        this.next = "end";
	      } else if (record.type === "normal" && afterLoc) {
	        this.next = afterLoc;
	      }

	      return ContinueSentinel;
	    },

	    finish: function(finallyLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.finallyLoc === finallyLoc) {
	          this.complete(entry.completion, entry.afterLoc);
	          resetTryEntry(entry);
	          return ContinueSentinel;
	        }
	      }
	    },

	    "catch": function(tryLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc === tryLoc) {
	          var record = entry.completion;
	          if (record.type === "throw") {
	            var thrown = record.arg;
	            resetTryEntry(entry);
	          }
	          return thrown;
	        }
	      }

	      // The context.catch method must only be called with a location
	      // argument that corresponds to a known catch block.
	      throw new Error("illegal catch attempt");
	    },

	    delegateYield: function(iterable, resultName, nextLoc) {
	      this.delegate = {
	        iterator: values(iterable),
	        resultName: resultName,
	        nextLoc: nextLoc
	      };

	      if (this.method === "next") {
	        // Deliberately forget the last sent value so that we don't
	        // accidentally pass it on to the delegate.
	        this.arg = undefined$1;
	      }

	      return ContinueSentinel;
	    }
	  };

	  // Regardless of whether this script is executing as a CommonJS module
	  // or not, return the runtime object so that we can declare the variable
	  // regeneratorRuntime in the outer scope, which allows this module to be
	  // injected easily by `bin/regenerator --include-runtime script.js`.
	  return exports;

	}(
	  // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	   module.exports 
	));

	try {
	  regeneratorRuntime = runtime;
	} catch (accidentalStrictMode) {
	  // This module should not be running in strict mode, so the above
	  // assignment should always work unless something is misconfigured. Just
	  // in case runtime.js accidentally runs in strict mode, we can escape
	  // strict mode using a global Function call. This could conceivably fail
	  // if a Content Security Policy forbids using Function, but in that case
	  // the proper solution is to fix the accidental strict mode problem. If
	  // you've misconfigured your bundler to force strict mode and applied a
	  // CSP to forbid Function, and you're not willing to fix either of those
	  // problems, please detail your unique predicament in a GitHub issue.
	  Function("r", "regeneratorRuntime = r")(runtime);
	}
	});

	var regenerator = runtime_1;

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

	function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

	/**
	 * 定义常用名称空间常量
	 */
	var NS = {
	  SVG: "http://www.w3.org/2000/svg",
	  XLINK: "http://www.w3.org/1999/xlink"
	};
	/**
	 * 将名称转化为属性数据名称
	 * @param {*} _name 
	 */

	function namedData(_name) {
	  return "data-".concat(_name);
	}
	/**
	 * 检查参数是不是一个DOM节点
	 * @param {*} _node 
	 */


	function isNode(_node) {
	  return _node instanceof window.Node || _node instanceof window.HTMLElement;
	}
	/**
	 * 获取CSS的数值部分
	 * @param {*} _value 
	 */

	function cssNumber(_value) {
	  return Number((typeof _value === "string" ? _value : String(_value)).replace(/\D+/, ""));
	}
	/**
	 * 封装Node操作的类
	 */


	var ENodeClass = /*#__PURE__*/function () {
	  function ENodeClass(_tagOrNode, _ns) {
	    _classCallCheck(this, ENodeClass);

	    var node = this.node = isNode(_tagOrNode) ? _tagOrNode : _ns ? document.createElementNS(_ns, _tagOrNode) : document.createElement(_tagOrNode);
	    this.matches = (node.matches || node.matchesSelector || node.msMatchesSelector || node.mozMatchesSelector || node.webkitMatchesSelector || node.oMatchesSelector).bind(node);
	    this.dispatchEvent = node.dispatchEvent.bind(node);
	  }
	  /**
	   * 将一个现成节点和ENode封装关联
	   * @param {*} _node 
	   */


	  _createClass(ENodeClass, [{
	    key: "getRelativeRect",

	    /**
	     * 获取相对于另一个节点的当前节点空间矩形
	     * @param {*} _node 如果不给该参数，则直接给出当前节点针对自身的空间矩形
	     */
	    value: function getRelativeRect(_node) {
	      var box = this.globalRect;
	      var relNode = ENodeClass.attach(_node);

	      if (relNode) {
	        if (relNode.isSVG) {
	          var matrix = relNode.node.getScreenCTM().inverse();
	          var retMatrix = matrix.translate(box.x, box.y);
	          box.x = retMatrix.e;
	          box.y = retMatrix.f;

	          if (this.isSVG) {
	            var originRect = this.rect;
	            box.width = originRect.width;
	            box.height = originRect.height;
	          }
	        } else {
	          var relGlobalRect = relNode.globalRect;
	          box.x -= relGlobalRect.x - relNode.node.clientLeft;
	          box.y -= relGlobalRect.y - relNode.node.clientTop;
	        }
	      }

	      return box;
	    }
	    /**
	     * 设置纯HTML元素的STYLE中的大小
	     * @param {*} _width 宽度
	     * @param {*} _height 高度
	     */

	  }, {
	    key: "setSizeInStyle",
	    value: function setSizeInStyle(_width, _height) {
	      var css = window.getComputedStyle ? window.getComputedStyle(this.node) : undefined;

	      if (css) {
	        _width -= cssNumber(css.paddingLeft) + cssNumber(css.paddingRight) + cssNumber(css.borderLeftWidth) + cssNumber(css.borderRightWidth);
	        _height -= cssNumber(css.paddingTop) + cssNumber(css.paddingBottom) + cssNumber(css.borderTopWidth) + cssNumber(css.borderBottomWidth);
	      }

	      this.node.style.width = "".concat(_width, "px");
	      this.node.style.height = "".concat(_height, "px");
	    }
	    /**
	     * 将屏幕上的坐标转化为相对元素的坐标
	     * @param {*} _x 
	     * @param {*} _y 
	     */

	  }, {
	    key: "translatePoint",
	    value: function translatePoint(_x, _y) {
	      if (this.isSVG) {
	        var matrix = this.node.getScreenCTM().inverse();

	        var _matrix$translate = matrix.translate(_x, _y),
	            x = _matrix$translate.e,
	            y = _matrix$translate.f;

	        return {
	          x: x,
	          y: y
	        };
	      } else {
	        var rect = this.globalRect;
	        return {
	          x: _x - rect.x,
	          y: _y - rect.y
	        };
	      }
	    }
	    /**
	     * 获取或设置属性，传入null为参数值，则说明删除属性
	     * @param {*} _idOrMap  属性名，或者属性名和属性值构成的对象，或者属性名构成的数组
	     * @param {*} _value    属性值，如果第一参数为属性名，且不传入该参数，则获取属性；
	     *                      如果第一参数为属性名列表，则或略该参数直接批量获取属性；
	     *                      如果第一参数为属性名和属性值构成的对象，则忽略该参数
	     */

	  }, {
	    key: "attr",
	    value: function attr(_idOrMap, _value) {
	      var node = this.node;

	      if (typeof _idOrMap === "string") {
	        // 只操作单个属性的处理
	        if (_value === undefined) {
	          return node.getAttribute(_idOrMap);
	        } else if (_value === null) {
	          node.removeAttribute(_idOrMap);
	        } else {
	          node.setAttribute(_idOrMap, _value);
	        }
	      } else if (_idOrMap instanceof Array) {
	        // 批量获取属性
	        var valueList = {};

	        var _iterator = _createForOfIteratorHelper(_idOrMap),
	            _step;

	        try {
	          for (_iterator.s(); !(_step = _iterator.n()).done;) {
	            var item = _step.value;
	            valueList[item] = node.getAttribute(item);
	          }
	        } catch (err) {
	          _iterator.e(err);
	        } finally {
	          _iterator.f();
	        }

	        return valueList;
	      } else {
	        // 传入的是一个映射表
	        for (var name in _idOrMap) {
	          var value = _idOrMap[name];
	          value === null ? node.removeAttribute(name) : node.setAttribute(name, value);
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取或设置风格，传入null为参数值，则说明删除风格
	     * @param {*} _idOrMap  风格名，或者风格名和风格值构成的对象，或者风格名构成的数组
	     * @param {*} _value    风格值，如果第一参数为风格名，且不传入该参数，则获取风格；
	     *                      如果第一参数为风格名列表，则或略该参数直接批量获取风格；
	     *                      如果第一参数为风格名和风格值构成的对象，则忽略该参数
	     */

	  }, {
	    key: "style",
	    value: function style(_idOrMap, _value) {
	      var styleList = this.node.style;

	      if (typeof _idOrMap === "string") {
	        // 只操作单个风格的处理
	        if (_value === undefined) {
	          return styleList[_idOrMap];
	        } else {
	          styleList[_idOrMap] = _value;
	        }
	      } else if (_idOrMap instanceof Array) {
	        // 批量获取属性
	        var valueList = {};

	        var _iterator2 = _createForOfIteratorHelper(_idOrMap),
	            _step2;

	        try {
	          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	            var item = _step2.value;
	            valueList[item] = styleList[item];
	          }
	        } catch (err) {
	          _iterator2.e(err);
	        } finally {
	          _iterator2.f();
	        }

	        return valueList;
	      } else {
	        // 传入的是一个映射表
	        for (var name in _idOrMap) {
	          var value = _idOrMap[name];
	          styleList[name] = value;
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取或设置扩展数据，传入null为参数值，则说明删除扩展数据
	     * @param {*} _idOrMap  数据名，或者数据名和数据值构成的对象，或者数据名构成的数组
	     * @param {*} _value    数据值，如果第一参数为数据名，且不传入该参数，则获取数据；
	     *                      如果第一参数为数据名列表，则或略该参数直接批量获取数据；
	     *                      如果第一参数为数据名和数据值构成的对象，则忽略该参数
	     */

	  }, {
	    key: "data",
	    value: function data(_idOrMap, _value) {
	      var node = this.node;

	      if (typeof _idOrMap === "string") {
	        // 只操作单个属性的处理
	        if (_value === undefined) {
	          return JSON.parse(node.getAttribute(namedData(_idOrMap)));
	        } else if (_value === null) {
	          node.removeAttribute(namedData(_idOrMap));
	        } else {
	          node.setAttribute(namedData(_idOrMap), JSON.stringify(_value));
	        }
	      } else if (_idOrMap instanceof Array) {
	        // 批量获取属性
	        var valueList = {};

	        var _iterator3 = _createForOfIteratorHelper(_idOrMap),
	            _step3;

	        try {
	          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	            var item = _step3.value;
	            valueList[item] = JSON.parse(node.getAttribute(namedData(item)));
	          }
	        } catch (err) {
	          _iterator3.e(err);
	        } finally {
	          _iterator3.f();
	        }

	        return valueList;
	      } else {
	        // 传入的是一个映射表
	        for (var name in _idOrMap) {
	          var value = _idOrMap[name];
	          value === null ? node.removeAttribute(namedData(name)) : node.setAttribute(namedData(name), JSON.stringify(value));
	        }
	      }

	      return this;
	    }
	    /**
	     * 检查对象是否具有某个风格类
	     * @param {*} _name 
	     */

	  }, {
	    key: "hasClass",
	    value: function hasClass(_name) {
	      return this.matches(".".concat(_name));
	    }
	    /**
	     * 添加对象某个风格类
	     * @param {*} _name 
	     */

	  }, {
	    key: "addClass",
	    value: function addClass(_name) {
	      var classList = this.node.classList;

	      if (classList) {
	        classList.add(_name);
	      } else {
	        var classStr = this.attr("class");
	        classList = classStr ? classStr.split(/\s+/) : [];

	        if (classList.indexOf(_name) < 0) {
	          this.attr("class", "".concat(classStr, " ").concat(_name));
	        }
	      }

	      return this;
	    }
	    /**
	     * 移除对象某个风格类
	     * @param {*} _name 
	     */

	  }, {
	    key: "removeClass",
	    value: function removeClass(_name) {
	      var classList = this.node.classList;

	      if (classList) {
	        classList.remove(_name);
	      } else {
	        var classStr = this.attr("class");
	        classList = classStr ? classStr.split(/\s+/) : [];
	        var idx = classList.indexOf(_name);

	        if (idx >= 0) {
	          classList[idx] = "";
	          this.attr("class", classList.join(" "));
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取风格类型列表
	     */

	  }, {
	    key: "parent",

	    /**
	     * 查找父节点
	     * @param {*} _selector 
	     */
	    value: function parent(_selector) {
	      var parentENode;
	      var element = this.node;

	      while (element = element.parentElement) {
	        parentENode = ENodeClass.attach(element);

	        if (!_selector) {
	          break;
	        } else if (parentENode.matches(_selector)) {
	          break;
	        }
	      }

	      return parentENode;
	    }
	    /**
	     * 查找根节点
	     */

	  }, {
	    key: "firstDescendant",

	    /**
	     * 获取符合选择描述的第一个后代
	     * @param {*} _selector 
	     */
	    value: function firstDescendant(_selector) {
	      _selector = _selector || "*";
	      var node = this.node.querySelector(_selector);
	      return node ? ENodeClass.attach(node) : undefined;
	    }
	    /**
	     * 获取所有满足选择描述的后代数组
	     * @param {*} _selector 
	     */

	  }, {
	    key: "descendant",
	    value: function descendant(_selector) {
	      _selector = _selector || "*";
	      var elmList = this.node.querySelectorAll(_selector);
	      var list = [];

	      var _iterator4 = _createForOfIteratorHelper(elmList),
	          _step4;

	      try {
	        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
	          var item = _step4.value;
	          var node = ENodeClass.attach(item);

	          if (node.matches(_selector)) {
	            list.push(node);
	          }
	        }
	      } catch (err) {
	        _iterator4.e(err);
	      } finally {
	        _iterator4.f();
	      }

	      return list;
	    }
	    /**
	     * 获取所有满足选择描述的后代的迭代器
	     * @param {*} _selector 
	     */

	  }, {
	    key: "getDescandant",
	    value: /*#__PURE__*/regenerator.mark(function getDescandant(_selector) {
	      var elmList, _iterator5, _step5, item, node;

	      return regenerator.wrap(function getDescandant$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              _selector = _selector || "*";
	              elmList = this.node.querySelectorAll(_selector);
	              _iterator5 = _createForOfIteratorHelper(elmList);
	              _context.prev = 3;

	              _iterator5.s();

	            case 5:
	              if ((_step5 = _iterator5.n()).done) {
	                _context.next = 13;
	                break;
	              }

	              item = _step5.value;
	              node = ENodeClass.attach(item);

	              if (!node.matches(_selector)) {
	                _context.next = 11;
	                break;
	              }

	              _context.next = 11;
	              return node;

	            case 11:
	              _context.next = 5;
	              break;

	            case 13:
	              _context.next = 18;
	              break;

	            case 15:
	              _context.prev = 15;
	              _context.t0 = _context["catch"](3);

	              _iterator5.e(_context.t0);

	            case 18:
	              _context.prev = 18;

	              _iterator5.f();

	              return _context.finish(18);

	            case 21:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, getDescandant, this, [[3, 15, 18, 21]]);
	    })
	    /**
	     * 获取符合第一个选择描述的子代
	     * @param {*} _selector 
	     */

	  }, {
	    key: "firstChild",
	    value: function firstChild(_selector) {
	      if (_selector) {
	        var childNode;

	        var _iterator6 = _createForOfIteratorHelper(this.node.children),
	            _step6;

	        try {
	          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	            var item = _step6.value;
	            var node = ENodeClass.attach(item);

	            if (node.matches(_selector)) {
	              childNode = node;
	              break;
	            }
	          }
	        } catch (err) {
	          _iterator6.e(err);
	        } finally {
	          _iterator6.f();
	        }

	        return childNode;
	      } else {
	        return ENodeClass.attach(this.node.firstElementChild);
	      }
	    }
	    /**
	     * 获取满足选择描述的子代数组
	     * @param {*} _selector 
	     */

	  }, {
	    key: "children",
	    value: function children(_selector) {
	      var elmList = this.node.children;
	      var list = [];

	      var _iterator7 = _createForOfIteratorHelper(elmList),
	          _step7;

	      try {
	        for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
	          var item = _step7.value;
	          var node = ENodeClass.attach(item);

	          if (!_selector || node.matches(_selector)) {
	            list.push(node);
	          }
	        }
	      } catch (err) {
	        _iterator7.e(err);
	      } finally {
	        _iterator7.f();
	      }

	      return list;
	    }
	    /**
	     * 获取满足选择描述的子代迭代器
	     * @param {*} _selector 
	     */

	  }, {
	    key: "getChildren",
	    value: /*#__PURE__*/regenerator.mark(function getChildren(_selector) {
	      var elmList, _iterator8, _step8, item, node;

	      return regenerator.wrap(function getChildren$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              elmList = this.node.children;
	              _iterator8 = _createForOfIteratorHelper(elmList);
	              _context2.prev = 2;

	              _iterator8.s();

	            case 4:
	              if ((_step8 = _iterator8.n()).done) {
	                _context2.next = 12;
	                break;
	              }

	              item = _step8.value;
	              node = ENodeClass.attach(item);

	              if (!(!_selector || node.matches(_selector))) {
	                _context2.next = 10;
	                break;
	              }

	              _context2.next = 10;
	              return node;

	            case 10:
	              _context2.next = 4;
	              break;

	            case 12:
	              _context2.next = 17;
	              break;

	            case 14:
	              _context2.prev = 14;
	              _context2.t0 = _context2["catch"](2);

	              _iterator8.e(_context2.t0);

	            case 17:
	              _context2.prev = 17;

	              _iterator8.f();

	              return _context2.finish(17);

	            case 20:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, getChildren, this, [[2, 14, 17, 20]]);
	    })
	    /**
	     * 加入为一个父元素的最后一个子项
	     * @param {*} _parent 
	     */

	  }, {
	    key: "appendTo",
	    value: function appendTo(_parent) {
	      var parentNode = isNode(_parent) ? _parent : isENode(_parent) ? _parent.node : null;

	      if (parentNode) {
	        this.node.remove();
	        parentNode.appendChild(this.node);
	      }

	      return this;
	    }
	    /**
	     * 加入为一个父元素的第一个子项
	     * @param {*} _parent 
	     */

	  }, {
	    key: "insertToTop",
	    value: function insertToTop(_parent) {
	      var parentNode = isNode(_parent) ? _parent : isENode(_parent) ? _parent.node : null;

	      if (parentNode) {
	        this.node.remove();
	        parentNode.insertBefore(this.node, parentNode.firstElementChild);
	      }

	      return this;
	    }
	    /**
	     * 插入到某个元素的后面去
	     * @param {*} _sibling 
	     */

	  }, {
	    key: "insertAfter",
	    value: function insertAfter(_sibling) {
	      var siblingNode = ENodeClass.attach(_sibling);

	      if (siblingNode) {
	        var parentNode = siblingNode.parent();

	        if (parentNode) {
	          this.node.remove();
	          var nextSibling = siblingNode.node.nextSibling;
	          nextSibling ? parentNode.node.insertBefore(this.node, nextSibling) : parentNode.node.appendChild(this.node);
	        }
	      }

	      return this;
	    }
	    /**
	     * 插入到某个元素的前面去
	     * @param {*} _sibling 
	     */

	  }, {
	    key: "insertBefore",
	    value: function insertBefore(_sibling) {
	      var siblingNode = ENodeClass.attach(_sibling);

	      if (siblingNode) {
	        var parentNode = siblingNode.parent();

	        if (parentNode) {
	          this.node.remove();
	          parentNode.node.insertBefore(this.node, siblingNode.node);
	        }
	      }

	      return this;
	    }
	    /**
	     * 移除当前元素
	     */

	  }, {
	    key: "remove",
	    value: function remove() {
	      this.node.remove();
	      return this;
	    }
	    /**
	     * 转换点的坐标
	     * @param {*} _point 
	     * @param {*} _toOuter 
	     */

	  }, {
	    key: "convertPoint",
	    value: function convertPoint(_point, _toOuter) {
	      var x = _point ? _point.x || 0 : 0;
	      var y = _point ? _point.y || 0 : 0;

	      if (_toOuter) {
	        x += this.node.offsetLeft;
	        y += this.node.offsetTop;
	      } else {
	        x -= this.node.offsetLeft;
	        y -= this.node.offsetTop;
	      }

	      return {
	        x: x,
	        y: y
	      };
	    }
	    /**
	     * 添加事件监听
	     * @param {*} _event 
	     * @param {*} _fn 
	     * @param {*} _opt 
	     */

	  }, {
	    key: "on",
	    value: function on(_event, _fn, _opt) {
	      this.node.addEventListener(_event, _fn, _opt);
	      return this;
	    }
	    /**
	     * 移除事件监听
	     * @param {*} _event 
	     * @param {*} _fn 
	     * @param {*} _opt 
	     */

	  }, {
	    key: "off",
	    value: function off(_event, _fn, _opt) {
	      this.node.removeEventListener(_event, _fn, _opt);
	      return this;
	    }
	    /**
	     * 判断两个节点对象是否相同
	     * @param {*} _other 
	     */

	  }, {
	    key: "isSame",
	    value: function isSame(_other) {
	      return this.node.isSameNode(isENode(_other) ? _other.node : _other);
	    }
	    /**
	     * 创建一个子元素，并追加到最后
	     * @param {*} _tag 
	     * @param {*} _ns 
	     */

	  }, {
	    key: "createChild",
	    value: function createChild(_tag, _ns) {
	      var child = new ENodeClass(_tag, _ns);
	      child && child.appendTo(this);
	      return child;
	    }
	    /**
	     * 创建一个SVG的子元素，并追加到最后
	     * @param {*} _tag 
	     */

	  }, {
	    key: "createSVGChild",
	    value: function createSVGChild(_tag) {
	      return this.isSVG ? this.createChild(_tag, NS.SVG) : SVG().appendTo(this);
	    }
	    /**
	     * 删除所有成员
	     */

	  }, {
	    key: "clearChildren",
	    value: function clearChildren() {
	      this.node.innerHTML = "";
	      return this;
	    }
	  }, {
	    key: "id",

	    /**
	     * 获取ID
	     */
	    get: function get() {
	      var value = this.node.getAttribute("id");
	      return value || "";
	    }
	    /**
	     * 设置ID
	     */
	    ,
	    set: function set(_value) {
	      this.node.setAttribute("id", _value);
	    }
	    /**
	     * 获取标签名
	     */

	  }, {
	    key: "tagName",
	    get: function get() {
	      return this.node.tagName.toLowerCase();
	    }
	    /**
	     * 获取风格类
	     */

	  }, {
	    key: "class",
	    get: function get() {
	      var value = this.node.getAttribute("class");
	      return value || "";
	    }
	    /**
	     * 设置风格类
	     */
	    ,
	    set: function set(_value) {
	      this.node.setAttribute("class", _value);
	    }
	    /**
	     * 检查是否是SVG的成员元素
	     */

	  }, {
	    key: "isSVG",
	    get: function get() {
	      return this.node instanceof SVGElement;
	    }
	    /**
	     * 获取文本内容
	     */

	  }, {
	    key: "text",
	    get: function get() {
	      return this.node.textContent || "";
	    }
	    /**
	     * 设置文本内容
	     */
	    ,
	    set: function set(_value) {
	      if (this.isSVG) {
	        this.node.innerHTML = "";
	        this.node.appendChild(document.createTextNode(_value));
	      } else {
	        this.node.innerText = _value;
	      }
	    }
	    /**
	     * 元素的y坐标
	     */

	  }, {
	    key: "top",
	    get: function get() {
	      if (this.isSVG) {
	        return this.node.getBBox().y;
	      } else {
	        return this.node.offsetTop;
	      }
	    }
	    /**
	     * 元素的x坐标
	     */

	  }, {
	    key: "left",
	    get: function get() {
	      if (this.isSVG) {
	        return this.node.getBBox().x;
	      } else {
	        return this.node.offsetLeft;
	      }
	    }
	    /**
	     * 元素的宽度信息
	     */

	  }, {
	    key: "width",
	    get: function get() {
	      if (this.isSVG) {
	        return this.node.getBBox().width;
	      } else {
	        return this.node.offsetWidth;
	      }
	    }
	    /**
	     * 元素的高度信息
	     */

	  }, {
	    key: "height",
	    get: function get() {
	      if (this.isSVG) {
	        return this.node.getBBox().height;
	      } else {
	        return this.node.offsetHeight;
	      }
	    }
	    /**
	     * 获取当前节点相对于自身已定位坐标系的矩形
	     */

	  }, {
	    key: "rect",
	    get: function get() {
	      var node = this.node;
	      return this.isSVG ? node.getBBox() : {
	        x: node.offsetLeft,
	        y: node.offsetTop,
	        width: node.offsetWidth,
	        height: node.offsetHeight
	      };
	    }
	    /**
	     * 获取元素内部的矩形空间
	     */

	  }, {
	    key: "clientRect",
	    get: function get() {
	      var node = this.node;
	      return this.isSVG ? node.getBBox() : {
	        x: node.clientLeft,
	        y: node.clientTop,
	        width: node.clientWidth,
	        height: node.clientHeight
	      };
	    }
	    /**
	     * 获取当前节点相对于全局的空间矩形
	     */

	  }, {
	    key: "globalRect",
	    get: function get() {
	      return this.node.getBoundingClientRect();
	    }
	    /**
	     * 获取当前节点相对于父元素的空间矩形
	     */

	  }, {
	    key: "offsetRect",
	    get: function get() {
	      var node = this.node;
	      var box = this.isSVG ? node.getBoundingClientRect() : {
	        x: node.offsetLeft,
	        y: node.offsetTop,
	        width: node.offsetWidth,
	        height: node.offsetHeight
	      };
	      return box;
	    }
	  }, {
	    key: "classList",
	    get: function get() {
	      var classStr = this.attr("class");
	      return classStr ? classStr.split(/\s+/) : [];
	    }
	  }, {
	    key: "root",
	    get: function get() {
	      return this.isSVG ? ENodeClass.attach(this.node.ownerSVGElement || this.parent("body")) : this.parent("body");
	    }
	  }], [{
	    key: "attach",
	    value: function attach(_node) {
	      return isNode(_node) ? new ENodeClass(_node) : isENode(_node) ? _node : _node ? ENodeClass.attach(document.querySelector(_node)) : undefined;
	    }
	  }]);

	  return ENodeClass;
	}();
	/**
	 * 获取或创建一个ENode对象，如果不传入参数则返回ENodeClass类
	 * @param {*} _node 
	 * @param {*} _ns 
	 */

	function ENode(_node, _ns) {
	  return arguments.length <= 0 ? ENodeClass : new ENodeClass(_node, _ns);
	}
	/**
	 * 创建一个SVG的ENode对象
	 */

	function SVG() {
	  var svg = new ENodeClass("svg", NS.SVG);
	  return svg.attr({
	    xmlns: NS.SVG,
	    "xmlns:xlink": NS.XLINK,
	    version: "1.1"
	  });
	}
	/**
	 * 检查参数是不是一个ENode封装
	 * @param {*} _node 
	 */

	function isENode(_node) {
	  return _node instanceof ENodeClass;
	}

	// 基础类列表
	var BasicClassList = {};
	/**
	 * 对类做扩展
	 * @param {*} _className 类的名称
	 * @param {*} _extension 扩展项的key-value对象
	 */

	function extend(_className, _extension) {
	  if (_extension && _className in BasicClassList) {
	    var classObj = BasicClassList[_className];
	    typeof _extension === "function" && (_extension = _extension(classObj));
	    var oldValue = {};

	    for (var name in _extension) {
	      var value = _extension[name];
	      oldValue[name] = classObj[name];
	      classObj[name] = value;
	    }

	    return oldValue;
	  }
	}
	/**
	 * 扩展类的原型链
	 * @param {*} _className 类的名称
	 * @param {*} _extension  扩展项的key-value对象
	 */

	function extendPrototype(_className, _extension) {
	  if (_className in BasicClassList) {
	    var classObj = BasicClassList[_className];
	    var prototype = classObj.prototype;
	    typeof _extension === "function" && (_extension = _extension(classObj, prototype));
	    var oldValue = {};

	    for (var name in _extension) {
	      var value = _extension[name];
	      oldValue[name] = prototype[name];
	      prototype[name] = value;
	    }

	    return oldValue;
	  }
	}
	/**
	 * 扩展类的事件响应函数
	 * @param {*} _className 类的名称
	 * @param {*} _extension  扩展项的key-value对象
	 * @param {*} _exclusive 是否独占改事件
	 */

	function extendEventHandler(_className, _extension, _exclusive) {
	  if (_extension && _className in BasicClassList) {
	    var classObj = BasicClassList[_className];
	    var prototype = classObj.prototype;
	    typeof _extension === "function" && (_extension = _extension(classObj, prototype));
	    var oldValues = {};

	    for (var name in _extension) {
	      var value = _extension[name];
	      var old = oldValues[name] = prototype[name];

	      if (old && !_exclusive) {
	        if (old instanceof Array) {
	          old.unshift(value);
	        } else {
	          prototype[name] = [value, old];
	        }
	      } else {
	        prototype[name] = value;
	      }
	    }

	    return oldValues;
	  }
	}
	/**
	 * 注册可扩展类
	 * @param {*} _nameOfMap 类的名称，或者由类名称和类对象组成的数组
	 * @param {*} _class 当第1个参数时类名称时，该参数是类对象
	 */

	function registryClass(_nameOfMap, _class) {
	  if (typeof _nameOfMap === "string") {
	    BasicClassList[_nameOfMap] = _class;
	  } else if (_nameOfMap) {
	    for (var name in _nameOfMap) {
	      var value = _nameOfMap[name];
	      BasicClassList[name] = value;
	    }
	  }
	}

	var $Extend = /*#__PURE__*/Object.freeze({
		__proto__: null,
		extend: extend,
		extendPrototype: extendPrototype,
		extendEventHandler: extendEventHandler,
		registryClass: registryClass
	});

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function _createForOfIteratorHelper$1(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$1(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$1(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$1(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen); }

	function _arrayLikeToArray$1(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

	var SYMBOL_EVENT_DISPATCHER = Symbol("MindSVG.Event.Dispatcher"); // 阻止事件内部分发的变量符号名称

	var SYMBOL_EVENT_BLOCK_SIBLING = Symbol("MindSVG.Event.BlockSibling.Private"); // 对象里的事件处理程序的名称前缀

	var NAME_EVENTHANDLER_PREFIX = "_$!"; // 思维导图的标记戳

	var ATTR_EVENT_STAMP = "mind-event-stamp"; ///////////////////////////////////////////////////////////////////////////////
	// 以下定义思维导图事件名称常数
	// 请求重新布局的事件

	var EVENT_REQUIRE_LAYOUT = "mindevent.require.layout"; // 焦点发生变更

	var EVENT_FOCUS_CHANGE = "mindevent.focus.change"; // 查询附件

	var EVENT_QUERY_ATTACHMENT = "mindevent.query.attachment"; // 唤起链接

	var EVENT_INVOKE_LINK = "mindevent.invoke.link"; // 唤起备注

	var EVENT_INVOKE_NOTES = "mindevent.invoke.notes"; // 唤起标签

	var EVENT_INVOKE_LABELS = "mindevent.invoke.labels"; // 唤起图像

	var EVENT_INVOKE_IMAGE = "mindevent.invoke.image"; // 唤起扩展标记

	var EVENT_INVOKE_MARKERS = "mindevent.invoke.markers"; // 拖拽等待确认

	var EVENT_CONFIRM_DRAG = "mindevent.confirm.drag"; // 拖拽完成

	var EVENT_END_DRAG = "mindevent.end.drag"; ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 生成事件句柄的名称
	 * @param {*} _event 
	 * @param {*} _stamp 
	 */

	function namedHandler(_event, _stamp) {
	  return _stamp ? "".concat(NAME_EVENTHANDLER_PREFIX).concat(_event, "|").concat(_stamp) : "".concat(NAME_EVENTHANDLER_PREFIX).concat(_event, "|");
	}
	/**
	 * 检查一个对象的是不是具备某个事件的处理程序
	 * @param {*} _constructor 对象的构造类
	 * @param {*} _event 事件
	 * @param {*} _stamp 事件的元素标记戳，如果不传入该参数，则只要是符合事件名的就算有对应的处理程序
	 */

	function hasEventHandler(_constructor, _event, _stamp) {
	  var map = Object.getOwnPropertyNames(_constructor.prototype);

	  if (_stamp) {
	    return map.indexOf(namedHandler(_event, _stamp));
	  } else {
	    var _iterator = _createForOfIteratorHelper$1(map),
	        _step;

	    try {
	      for (_iterator.s(); !(_step = _iterator.n()).done;) {
	        var item = _step.value;

	        if (item.startsWith("".concat(NAME_EVENTHANDLER_PREFIX).concat(_event, "|"))) {
	          return true;
	        }
	      }
	    } catch (err) {
	      _iterator.e(err);
	    } finally {
	      _iterator.f();
	    }
	  }

	  return false;
	}
	/**
	 * 从对象的构造类中抽取对象的事件处理程序表
	 * @param {*} _constructor 对象的构造类
	 */

	function getEventHandlerMap(_constructor) {
	  var srcMap = Object.getOwnPropertyNames(_constructor.prototype);
	  var map = [];

	  var _iterator2 = _createForOfIteratorHelper$1(srcMap),
	      _step2;

	  try {
	    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
	      var item = _step2.value;

	      if (item.startsWith(NAME_EVENTHANDLER_PREFIX)) {
	        var event = item.substr(NAME_EVENTHANDLER_PREFIX.length).split("|")[0];
	        event.length > 0 && map.indexOf(event) < 0 && map.push(event);
	      }
	    }
	  } catch (err) {
	    _iterator2.e(err);
	  } finally {
	    _iterator2.f();
	  }

	  return map;
	}
	/**
	 * 对阻止事件冒泡和默认处理的封装
	 * @param {*} _event 要处理的事件
	 * @param {*} _prevent 是否要阻止默认处理，默认为true
	 */


	function handledEvent(_event) {
	  var _prevent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	  _prevent && _event.preventDefault();

	  _event.stopPropagation();
	}
	/**
	 * 检查事件是否来源于MindSVG组件
	 * @param {*} _event 
	 * @param {*} _mindSVG 
	 */

	function fromMindSVG(_event, _mindSVG) {
	  var target = ENode().attach(_event.target);
	  return target && (target.isSVG || target.isSame(_mindSVG.container));
	}
	/**
	 * 允许同级继续分发事件
	 * @param {*} _event 
	 */

	function continueSiblingHandler(_event) {
	  Object.isExtensible(_event) && (_event[SYMBOL_EVENT_BLOCK_SIBLING] = undefined);
	}
	/**
	 * 循环调用处理程序
	 * @param {*} _list 
	 * @param {*} _thisArg 
	 * @param {*} _args 
	 */

	function loopCallHandler(_list, _thisArg, _args) {
	  var _event = _args[0];

	  if (_list.length) {
	    continueSiblingHandler(_event);
	  } else {
	    var ret = undefined;

	    for (var idx in _list) {
	      if (_list[idx]) {
	        _args[3] = ret;
	        ret = _list[idx].apply(this, _args);

	        if (_event[SYMBOL_EVENT_BLOCK_SIBLING]) {
	          break;
	        }
	      }
	    }

	    return ret;
	  }
	}
	/**
	 * 分发主题事件的处理程序
	 * @param {*} _event 
	 */


	function mindEventDispatcher(_event) {
	  var element = _event.target;

	  if (element) {
	    var ret = undefined; // 获取事件元素的思维导图标记戳

	    var stamp = element.getAttribute(ATTR_EVENT_STAMP);

	    if (stamp) {
	      // 如果事件元素标记为思维导图的元素，且对象有对应的处理程序，则进行处理
	      var fn = this[namedHandler(_event.type, stamp)];

	      if (fn) {
	        Object.isExtensible(_event) && (_event[SYMBOL_EVENT_BLOCK_SIBLING] = true);
	        ret = fn instanceof Array ? loopCallHandler(fn, this, [_event, stamp, element, ret]) : fn.call(this, _event, stamp, element);
	      }
	    } // 如果没有标记戳，或者处理程序允许同级继续分发，就要由未标记的默认处理程序继续处理


	    if (!_event[SYMBOL_EVENT_BLOCK_SIBLING]) {
	      var _fn = this[namedHandler(_event.type)];

	      if (_fn) {
	        Object.isExtensible(_event) && (_event[SYMBOL_EVENT_BLOCK_SIBLING] = true);
	        _fn instanceof Array ? loopCallHandler(_fn, this, [_event, stamp, element, ret]) : _fn.call(this, _event, stamp, element, ret);
	      }
	    }
	  }
	}
	/**
	 * 批量关联事件处理程序
	 * @param {*} _element 被关联事件的元素
	 * @param {*} _map 处理程序集
	 * @param {*} _binder 处理程序的this对象
	 */


	function mapEventHandler(_element, _binder, _map) {
	  if (_element && _binder) {
	    var map = _map || getEventHandlerMap(_binder.constructor);

	    var dispatcher = _binder[SYMBOL_EVENT_DISPATCHER] || (_binder[SYMBOL_EVENT_DISPATCHER] = mindEventDispatcher.bind(_binder));

	    var eventBind = (_element.on || _element.addEventListener).bind(_element);

	    var _iterator3 = _createForOfIteratorHelper$1(map),
	        _step3;

	    try {
	      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	        var event = _step3.value;
	        eventBind(event, dispatcher);
	      }
	    } catch (err) {
	      _iterator3.e(err);
	    } finally {
	      _iterator3.f();
	    }
	  }
	}
	/**
	 * 触发思维导图事件
	 * @param {*} _event 
	 * @param {*} _data 
	 */

	function fireEvent(_event, _data, _defRet) {
	  if (isENode(this)) {
	    var event = new CustomEvent(_event, {
	      bubbles: true,
	      cancelable: true,
	      composed: true,
	      detail: {
	        value: _data,
	        result: _defRet
	      }
	    });
	    this.node.dispatchEvent(event);
	    return event.detail.result;
	  }
	}
	/**
	 * 获取事件关联元素的标记戳
	 * @param {*} _event 
	 */

	function eventStamp(_event) {
	  return _event && _event.target ? _event.target.getAttribute(ATTR_EVENT_STAMP) : undefined;
	}
	/**
	 * 导出事件类接口和常数
	 */

	var Constants = {
	  ATTR_EVENT_STAMP: ATTR_EVENT_STAMP,
	  EVENT_FOCUS_CHANGE: EVENT_FOCUS_CHANGE,
	  EVENT_REQUIRE_LAYOUT: EVENT_REQUIRE_LAYOUT,
	  EVENT_QUERY_ATTACHMENT: EVENT_QUERY_ATTACHMENT,
	  EVENT_CONFIRM_DRAG: EVENT_CONFIRM_DRAG,
	  EVENT_END_DRAG: EVENT_END_DRAG,
	  EVENT_INVOKE_IMAGE: EVENT_INVOKE_IMAGE,
	  EVENT_INVOKE_LABELS: EVENT_INVOKE_LABELS,
	  EVENT_INVOKE_LINK: EVENT_INVOKE_LINK,
	  EVENT_INVOKE_NOTES: EVENT_INVOKE_NOTES,
	  EVENT_INVOKE_MARKERS: EVENT_INVOKE_MARKERS
	};

	var $Event = /*#__PURE__*/Object.freeze({
		__proto__: null,
		namedHandler: namedHandler,
		hasEventHandler: hasEventHandler,
		handledEvent: handledEvent,
		fromMindSVG: fromMindSVG,
		continueSiblingHandler: continueSiblingHandler,
		mapEventHandler: mapEventHandler,
		fireEvent: fireEvent,
		eventStamp: eventStamp,
		Constants: Constants
	});

	/**
	 * 为避免参数没有使用的报错定义的空函数
	 */
	function unused() {} // 自定义错误

	var ERROR = {
	  INVALID_PARAM: function INVALID_PARAM(_str) {
	    return new Error("The parameter \"".concat(_str, "\" is invalid!"));
	  },
	  ILLEGAL_INSTANCE: function ILLEGAL_INSTANCE(_str, _type) {
	    return new Error(_type ? "\"".concat(_str, "\" is a illegal instance") : "\"".concat(_str, "\" is a illegal instance of (").concat(_type, ")"));
	  }
	};

	var _namedData, _namedData2, _namedData3, _namedData4, _namedData5, _namedData6, _namedData7, _namedData8, _namedData9, _namedData10, _namedData11, _namedData12, _namedData13, _namedData14, _namedHandler, _namedHandler2, _namedHandler3, _namedHandler4, _namedHandler5, _namedHandler6, _namedHandler7, _namedHandler8;

	function _createForOfIteratorHelper$2(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$2(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$2(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$2(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$2(o, minLen); }

	function _arrayLikeToArray$2(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

	var TIMER_CHECKER_INTERVAL = 100; // 私有成员的存储符号

	var PRIVATE_SYMBOL = Symbol("MindSVG.Private"); // ID的前缀

	var PREFIX_ID = "MID-"; // 思维导图主题项的标记戳值

	var STAMP_TOPIC_TITLE = "topic-item-title"; // 思维导图主题项折叠按钮标记戳

	var STAMP_FOLD_ICON = "topic-item-fold-icon"; // 思维导图主题项图片的标记戳

	var STAMP_TOPIC_IMAGE = "topic-item-image"; // 思维导图的LABEL更多按钮的标记戳

	var STAMP_TOPIC_LABEL_MORE = "topic-labels-more"; // 思维导图的LABEL的标记戳

	var STAMP_TOPIC_LABELS = "topic-labels"; // 思维导图的备注的标记戳

	var STAMP_TOPIC_NOTES = "topic-notes"; // 思维导图的链接的标记戳

	var STAMP_TOPIC_LINK = "topic-link"; // 思维导图的附加标记的标记戳

	var STAMP_TOPIC_MARKERS = "topic-markers"; // 加号图标的ID

	var ID_ICON_PLUS = "icon-plus"; // 减号图标的ID

	var ID_ICON_MINUS = "icon-minus"; // 更多图标的ID

	var ID_ICON_MORE = "icon-more"; // 备注图标的ID

	var ID_ICON_NOTES = "icon-notes"; // 链接图标的ID

	var ID_ICON_LINK = "icon-link"; // 默认的基础类

	var CLASS_NAME = {
	  MAIN_BASIC: "mind-main-basic",
	  MAIN_CONTAINER: "mind-main-container",
	  MAIN_SVG: "mind-svg",
	  TOPIC_GROUP_BASIC: "mind-topic-group-basic",
	  TOPIC_ITEM_G_BASIC: "mind-topic-item-group-basic",
	  TOPIC_IN_FOCUS: "mind-topic-focus",
	  TOPIC_TEXT_BASIC: "mind-text-basic",
	  TOPIC_TEXT: "mind-text",
	  TOPIC_RECT: "mind-topic",
	  TOPIC_LEVEL_PREFIX: "mind-topic-level",
	  TOPIC_CHILD_G_BASIC: "mind-topic-children-group-basic",
	  TOPIC_LINK_LINE: "mind-line",
	  TOPIC_FOLD_ICON: "mind-topic-fold-icon",
	  TOPIC_LABELS: "mind-topic-labels",
	  TOPIC_LABEL_BG: "mind-topic-label-background",
	  TOPIC_LINK: "mind-topic-link",
	  TOPIC_NOTES: "mind-topic-notes",
	  TOPIC_MARKERS: "mind-topic-markers"
	}; // 默认配置参数

	var DEFAULT_CONFIGS = {
	  paddingX: 10,
	  paddingY: 10,
	  topicMarginX: 46,
	  topicMarginY: 17,
	  contentMarginX: 6,
	  contentMarginY: 6,
	  rectRadius: 6,
	  lineBezierCtrlSize: 17,
	  subPaddingX: 6,
	  subPaddingY: 6,
	  maxLabelsPreview: 3
	}; // 右侧连接

	var CONNECT_DIRECTION_RIGHT = 0; // 左侧连接

	var CONNECT_DIRECTION_LEFT = 1; // 主题里的数据名称前缀

	var NAME_DATA_PREFIX = "_data$"; // 附件关联的前缀

	var ATTACHMENT_LINK_PREFIX = "xap:"; // 元素的附加数据名称

	var DATA_EXTEND = "extend";
	/**
	 * 生成主题数据属性的名称
	 * @param {*} _name 
	 */

	function namedData$1(_name) {
	  return "".concat(NAME_DATA_PREFIX).concat(_name);
	}
	/**
	 * 从格式化的数据属性名称中解析出数据的纯名称
	 * @param {*} _name 
	 */


	function dataPureName(_name) {
	  return _name.startsWith(NAME_DATA_PREFIX) ? _name.substr(NAME_DATA_PREFIX.length) : undefined;
	}
	/**
	 * 获取对象的私有成员空间
	 * @param {*} _this 对象实例
	 * @param {*} _key 私有成员的名称，如果不传入该参数则获取实例的全部私有成员空间
	 */


	function getPrivate(_this, _key) {
	  return _key === undefined ? _this[PRIVATE_SYMBOL] : _this[PRIVATE_SYMBOL][_key];
	}
	/**
	 * 得到符合本程序规范的ID名称
	 * @param {*} _id 人工或者数据预先指定的id，不传入该参数则自动随机生成一个id
	 */


	function mID(_id) {
	  var ret;

	  if (_id) {
	    ret = typeof _id === "string" ? _id : String(_id);

	    if (!ret.startsWith(PREFIX_ID)) {
	      ret = PREFIX_ID + ret;
	    }
	  } else {
	    ret = "".concat(PREFIX_ID).concat(Date.now()).concat(Math.random().toString(16).substr(2, 3));
	  }

	  return ret;
	}
	/**
	 * SVG预定义件类
	 */


	var Defs = /*#__PURE__*/function () {
	  function Defs(_svg) {
	    _classCallCheck(this, Defs);

	    if (!isENode(_svg)) {
	      throw ERROR.INVALID_PARAM("_svg");
	    }

	    var defs = this.defs = _svg.createSVGChild("defs");

	    if (defs) {
	      var list = Object.getOwnPropertyNames(Defs);

	      for (var idx in list) {
	        var name = list[idx];
	        var fn = Defs[name];

	        if (typeof fn === "function") {
	          var element = fn(this);

	          if (isENode(element)) {
	            element.attr("id", name);
	          }
	        }
	      }
	    }
	  }
	  /**
	   * 创建SVG的元素
	   * @param {*} _tag 元素标签
	   */


	  _createClass(Defs, [{
	    key: "createChild",
	    value: function createChild(_tag) {
	      return this.defs.createSVGChild(_tag);
	    }
	  }]);

	  return Defs;
	}();
	/**
	 * 主题项类
	 */


	_namedData = namedData$1("customData");
	_namedData2 = namedData$1("customData");
	_namedData3 = namedData$1("title");
	_namedData4 = namedData$1("title");
	_namedData5 = namedData$1("image");
	_namedData6 = namedData$1("image");
	_namedData7 = namedData$1("labels");
	_namedData8 = namedData$1("labels");
	_namedData9 = namedData$1("href");
	_namedData10 = namedData$1("href");
	_namedData11 = namedData$1("notes");
	_namedData12 = namedData$1("notes");
	_namedData13 = namedData$1("markers");
	_namedData14 = namedData$1("markers");

	var TopicItem = /*#__PURE__*/function () {
	  function TopicItem(_data, _level, _parent) {
	    _classCallCheck(this, TopicItem);

	    if (isENode(_data)) {
	      // 从既有元素封装出一个实例
	      if (_data.tagName !== "g" || !_data.hasClass(CLASS_NAME.TOPIC_ITEM_G_BASIC)) {
	        throw ERROR.ILLEGAL_INSTANCE("_data", "<g> with item group class");
	      }

	      var content = this.content = _data;
	      this.fireEvent = fireEvent.bind(content);
	      this.titleRect = content.firstDescendant(TopicItem.titleSelector);
	      this.titleText = content.firstDescendant("text.".concat(CLASS_NAME.TOPIC_TEXT));
	      this.foldIcon = content.firstDescendant("use.".concat(CLASS_NAME.TOPIC_FOLD_ICON));
	    } else if (isENode(_parent)) {
	      // 创建一个全新实例
	      var id = _parent.attr("id");

	      _data = _data || {}; // 本类只创建主题项自身的数据，主题的下属子主题数据不由本类来实例化

	      var _content = this.content = _parent.createSVGChild("g");

	      _content.attr({
	        id: id,
	        "class": "".concat(CLASS_NAME.TOPIC_ITEM_G_BASIC, " ").concat(CLASS_NAME.TOPIC_LEVEL_PREFIX).concat(_level)
	      });

	      this.fireEvent = fireEvent.bind(_content); // 创建基本的主题方框和主题文字

	      var titleRect = this.titleRect = _content.createSVGChild("rect");

	      var titleText = this.titleText = _content.createSVGChild("text");

	      titleText.text = _data.title;
	      titleText.attr(_defineProperty({
	        id: id,
	        "class": "".concat(CLASS_NAME.TOPIC_TEXT_BASIC, " ").concat(CLASS_NAME.TOPIC_TEXT)
	      }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_TITLE));
	      titleRect.attr(_defineProperty({
	        id: id,
	        "class": CLASS_NAME.TOPIC_RECT
	      }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_TITLE)); // 其余数据直接通过属性设置以保证其元素设置代码的一致性

	      var _iterator = _createForOfIteratorHelper$2(TopicItem.propertyNames()),
	          _step;

	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var property = _step.value;

	          if (property.name !== "title" && property.name in _data) {
	            this[property.fullName] = _data[property.name];
	          }
	        } // 创建预备使用的主题折叠按钮

	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }

	      if (_level > 0) {
	        (this.foldIcon = _content.createSVGChild("use")).attr(_defineProperty({
	          id: id,
	          href: "#".concat(ID_ICON_MINUS),
	          style: "display: none;",
	          "class": CLASS_NAME.TOPIC_FOLD_ICON
	        }, Constants.ATTR_EVENT_STAMP, STAMP_FOLD_ICON));
	      }
	    } else {
	      throw ERROR.INVALID_PARAM(_parent);
	    }
	  }
	  /**
	   * 转换一个名称为属性数据名称，如果不存在对应的属性数据，则返回undefined
	   * @param {*} _name 
	   */


	  _createClass(TopicItem, [{
	    key: "propertys",

	    /**
	     * 获取遍历所有属性数据的迭代器
	     */
	    value: /*#__PURE__*/regenerator.mark(function propertys() {
	      var list, _iterator2, _step2, itemName, dataName;

	      return regenerator.wrap(function propertys$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              list = Object.getOwnPropertyNames(TopicItem.prototype);
	              _iterator2 = _createForOfIteratorHelper$2(list);
	              _context.prev = 2;

	              _iterator2.s();

	            case 4:
	              if ((_step2 = _iterator2.n()).done) {
	                _context.next = 12;
	                break;
	              }

	              itemName = _step2.value;
	              dataName = dataPureName(itemName);

	              if (!dataName) {
	                _context.next = 10;
	                break;
	              }

	              _context.next = 10;
	              return {
	                name: dataName,
	                fullName: itemName,
	                value: this[itemName]
	              };

	            case 10:
	              _context.next = 4;
	              break;

	            case 12:
	              _context.next = 17;
	              break;

	            case 14:
	              _context.prev = 14;
	              _context.t0 = _context["catch"](2);

	              _iterator2.e(_context.t0);

	            case 17:
	              _context.prev = 17;

	              _iterator2.f();

	              return _context.finish(17);

	            case 20:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, propertys, this, [[2, 14, 17, 20]]);
	    })
	    /**
	     * 获取/设置主题的层级
	     * @param {*} _level 要设置的主题层级，如果不传入参数表示获取主题层级
	     */

	  }, {
	    key: "level",
	    value: function level(_level) {
	      var content = this.content;

	      if (content) {
	        var classList = content.classList;
	        var levelIdx = -1;

	        for (var idx in classList) {
	          if (classList[idx].startsWith(CLASS_NAME.TOPIC_LEVEL_PREFIX)) {
	            levelIdx = idx;
	            break;
	          }
	        }

	        if (_level === undefined) {
	          return levelIdx >= 0 ? parseInt(classList[levelIdx].substr(CLASS_NAME.TOPIC_LEVEL_PREFIX.length)) : 0;
	        } else {
	          if (levelIdx >= 0) {
	            classList[levelIdx] = "";
	          }

	          classList.push("".concat(CLASS_NAME.TOPIC_LEVEL_PREFIX).concat(_level));
	          content.attr("class", classList.join(" "));
	        }
	      }
	    }
	    /**
	     * 获取主题项的大小
	     */

	  }, {
	    key: "globalZone",

	    /**
	     * 获取内部项目的全局区域坐标信息
	     * @param {*} _item 
	     */
	    value: function globalZone(_item) {
	      var selector = TopicItem["".concat(_item, "Selector")];

	      if (selector) {
	        var node = this.content.firstDescendant(selector);
	        return node ? node.globalRect : undefined;
	      }

	      return undefined;
	    }
	    /**
	     * 获取内部项目相对于其他元素的坐标信息
	     * @param {*} _item 
	     * @param {*} _node 相对的元素，如果不传入该参数，则表示相对于MindSVG的容器元素
	     */

	  }, {
	    key: "relativeZone",
	    value: function relativeZone(_item, _node) {
	      var node;

	      if (_item) {
	        var selector = TopicItem["".concat(_item, "Selector")];

	        if (selector) {
	          node = this.content.firstDescendant(selector);
	        }
	      } else {
	        node = this.content;
	      }

	      if (node) {
	        var relNode = ENode().attach(_node) || node.parent("div.".concat(CLASS_NAME.MAIN_CONTAINER));
	        return relNode ? node.getRelativeRect(relNode) : undefined;
	      }

	      return undefined;
	    }
	    /**
	     * 获取自定义数据
	     */

	  }, {
	    key: "connectPointer",

	    /**
	     * 获取主题项的连接点坐标（相对于主题组自身坐标系）
	     * @param {*} _direction 连接方向，取值为CONNECT_DIRECTION_LEFT和CONNECT_DIRECTION_RIGHT
	     */
	    value: function connectPointer(_direction) {
	      var x;
	      var y;

	      if (this.titleRect) {
	        var box = this.titleRect.rect;
	        y = box.height >> 1;
	        x = _direction == CONNECT_DIRECTION_LEFT ? 0 : box.width;
	      } else {
	        x = 0;
	        y = 0;
	      }

	      return {
	        x: x,
	        y: y
	      };
	    }
	    /**
	     * 设置折叠
	     * @param {*} _style 不传入参数表示不现实折叠按钮，true表示已折叠，false表示未折叠
	     */

	  }, {
	    key: "fold",
	    value: function fold(_style) {
	      var foldIcon = this.foldIcon;

	      if (foldIcon) {
	        if (_style === undefined || _style === null) {
	          foldIcon.style("display", "none");
	          foldIcon.attr({
	            href: "#".concat(ID_ICON_MINUS)
	          });
	        } else {
	          foldIcon.attr({
	            href: "#".concat(_style ? ID_ICON_PLUS : ID_ICON_MINUS)
	          });
	          foldIcon.style("display", "unset");
	        }
	      }
	    }
	    /**
	     * 设置主题焦点
	     * @param {*} _focus 不传入参数或者传入true表示主题拥有焦点，否则清除主题焦点
	     */

	  }, {
	    key: "focus",
	    value: function focus() {
	      var _focus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	      var ret = undefined;
	      var content = this.content;

	      if (content) {
	        if (_focus) {
	          if (!content.hasClass(CLASS_NAME.TOPIC_IN_FOCUS)) {
	            var root = content.root;

	            if (root) {
	              var lastFocus = root.firstDescendant(TopicItem.focusItemSelector);

	              if (lastFocus) {
	                lastFocus.removeClass(CLASS_NAME.TOPIC_IN_FOCUS);
	              }
	            }

	            content.addClass(CLASS_NAME.TOPIC_IN_FOCUS);
	          }

	          ret = true;
	        } else if (content.hasClass(CLASS_NAME.TOPIC_IN_FOCUS)) {
	          content.removeClass(CLASS_NAME.TOPIC_IN_FOCUS);
	          ret = false;
	        }
	      }

	      return ret;
	    }
	    /**
	     * 检查主题是否有焦点
	     */

	  }, {
	    key: "layout",

	    /**
	     * 根据MindSVG配置布局主题项内部的元素
	     * @param {*} _mindSVG 隶属于的MindSVG对象
	     */
	    value: function layout(_mindSVG, _direction) {
	      if (!(_mindSVG instanceof MindSVG)) {
	        throw ERROR.INVALID_PARAM("_mindSVG");
	      } // 布局基本方框和文字


	      var titleText = this.titleText;
	      var titleRect = this.titleRect;

	      if (titleText && titleRect) {
	        var _mindSVG$config = _mindSVG.config(),
	            paddingX = _mindSVG$config.paddingX,
	            paddingY = _mindSVG$config.paddingY,
	            rectRadius = _mindSVG$config.rectRadius,
	            maxLabelsPreview = _mindSVG$config.maxLabelsPreview,
	            subPaddingX = _mindSVG$config.subPaddingX,
	            subPaddingY = _mindSVG$config.subPaddingY; // 先获取标题的基本大小


	        var _titleText$rect = titleText.rect,
	            textWidth = _titleText$rect.width,
	            textHeight = _titleText$rect.height;
	        var rectWidth = textWidth + (paddingX << 1);
	        var rectHeight = textHeight + (paddingY << 1); // 布局底部栏的内容物

	        var underTop = rectHeight + subPaddingY;
	        var underWidth = 0;
	        var underRightObjs = []; // 如果有标签，则布局标签

	        var labels = this.content.firstDescendant(TopicItem.labelsSelector);
	        var offsetX = subPaddingX;

	        if (labels) {
	          var textCount = 0;
	          var _textHeight = 0;

	          var _iterator3 = _createForOfIteratorHelper$2(labels.getDescandant("text")),
	              _step3;

	          try {
	            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
	              var text = _step3.value;
	              text.attr({
	                transform: "translate(".concat(offsetX, ", ").concat(subPaddingY, ")"),
	                x: null,
	                y: null,
	                style: "display: ".concat(textCount >= maxLabelsPreview ? "none" : "unset")
	              });
	              var textRect = text.rect;
	              0 === textCount && (_textHeight = textRect.height + subPaddingY + subPaddingY);

	              if (++textCount <= maxLabelsPreview) {
	                offsetX += textRect.width + subPaddingX;
	              }
	            }
	          } catch (err) {
	            _iterator3.e(err);
	          } finally {
	            _iterator3.f();
	          }

	          if (textCount > maxLabelsPreview) {
	            var _moreIcon$attr;

	            var moreIcon = labels.firstDescendant("use") || labels.createSVGChild("use");
	            moreIcon.attr((_moreIcon$attr = {
	              href: "#".concat(ID_ICON_MORE)
	            }, _defineProperty(_moreIcon$attr, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_LABEL_MORE), _defineProperty(_moreIcon$attr, "transform", "translate(".concat(offsetX, ", ").concat(subPaddingY, ")")), _moreIcon$attr));
	            offsetX += moreIcon.width + subPaddingX;
	          }

	          var labelRect = labels.firstDescendant("rect.".concat(CLASS_NAME.TOPIC_LABEL_BG));
	          labelRect && labelRect.attr({
	            x: null,
	            y: null,
	            width: offsetX,
	            height: _textHeight,
	            rx: rectRadius,
	            ry: rectRadius
	          });
	          labels.attr("transform", "translate(0, ".concat(underTop, ")"));
	          underWidth += offsetX;
	        } // 如果有链接、备注则计算链接备注占用的空间


	        for (var idx = 0; idx < 2; idx++) {
	          var obj = this.content.firstDescendant(TopicItem.underLineSelectors[idx]);

	          if (obj) {
	            var width = obj.width;
	            underWidth += width + subPaddingX;
	            underRightObjs.push({
	              obj: obj,
	              width: width
	            });
	          }
	        } // 如果有markers，则先对markers做内部布局，以计算markers要占用的空间


	        var markers = this.content.firstDescendant(TopicItem.markersSelector);
	        offsetX = 0;

	        if (markers) {
	          var _iterator4 = _createForOfIteratorHelper$2(markers.getDescandant("use")),
	              _step4;

	          try {
	            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
	              var item = _step4.value;
	              offsetX !== 0 && (offsetX += subPaddingX);
	              item.attr("transform", "translate(".concat(offsetX, ", 0)"));
	              offsetX += item.width;
	            }
	          } catch (err) {
	            _iterator4.e(err);
	          } finally {
	            _iterator4.f();
	          }

	          underWidth += offsetX + subPaddingX;
	          underRightObjs.push({
	            obj: markers,
	            width: offsetX
	          });
	        } // 根据labels、markers、链接、备注计算主题标题需要的最大长度


	        underRightObjs.length > 0 && (underWidth += subPaddingX);
	        underWidth > rectWidth && (rectWidth = underWidth); // 如果有图片，则布局图片, 如果图片的大小比当前计算的标题区大小要小，则图片居中布局

	        var img = this.content.firstDescendant(TopicItem.imageSelector);

	        if (img) {
	          var _img$rect = img.rect,
	              imgWidth = _img$rect.width,
	              imgHeight = _img$rect.height;
	          var imgLeft = 0;
	          imgWidth > rectWidth ? rectWidth = imgWidth : imgLeft = (rectWidth - imgWidth) / 2;
	          img.attr({
	            transform: "translate(".concat(imgLeft, ", -").concat(imgHeight + subPaddingY, ")"),
	            x: null,
	            y: null
	          });
	        } // 现在开始从标题下的右侧开始布局链接、备注、markers


	        offsetX = rectWidth - subPaddingX;

	        for (var _idx in underRightObjs) {
	          var _underRightObjs$_idx = underRightObjs[_idx],
	              _obj = _underRightObjs$_idx.obj,
	              _width = _underRightObjs$_idx.width;

	          if (_obj) {
	            offsetX -= _width;

	            _obj.attr({
	              transform: "translate(".concat(offsetX, ", ").concat(underTop, ")"),
	              x: null,
	              y: null
	            });

	            offsetX -= subPaddingX;
	          }
	        } // 最后根据主题的最大长度来布局主题标题文字和画框


	        var textLeft = (rectWidth - textWidth) / 2;
	        titleText.attr({
	          transform: "translate(".concat(textLeft, ", ").concat(paddingY, ")"),
	          x: null,
	          y: null
	        });
	        titleRect.attr({
	          width: rectWidth,
	          height: rectHeight,
	          rx: rectRadius,
	          ry: rectRadius,
	          x: null,
	          y: null
	        }); // 布局折叠图标

	        var foldIcon = this.foldIcon;

	        if (foldIcon) {
	          foldIcon.attr("transform", "translate(".concat(_direction === CONNECT_DIRECTION_LEFT ? 0 : rectWidth, ", ").concat(rectHeight / 2, ")"));
	        }
	      }
	    }
	  }, {
	    key: "size",
	    get: function get() {
	      var rect = this.content.rect;
	      return {
	        width: rect.width,
	        height: rect.height
	      };
	    }
	    /**
	     * 获取标题区的坐标
	     */

	  }, {
	    key: "titleZone",
	    get: function get() {
	      var titleRect = this.titleRect;

	      if (titleRect) {
	        return titleRect.getRelativeRect(titleRect.root);
	      } else {
	        return {
	          x: 0,
	          y: 0,
	          width: 0,
	          height: 0
	        };
	      }
	    }
	  }, {
	    key: _namedData,
	    get: function get() {
	      return this.content.data("customData");
	    }
	    /**
	     * 设置自定义数据
	     */

	  }, {
	    key: _namedData2,
	    set: function set(_value) {
	      this.content.data("customData", _value);
	    }
	    /**
	     * 获取标题
	     */

	  }, {
	    key: _namedData3,
	    get: function get() {
	      return this.titleText ? this.titleText.text : "";
	    }
	    /**
	     * 设置标题
	     */

	  }, {
	    key: _namedData4,
	    set: function set(_value) {
	      this.titleText && (this.titleText.text = _value);
	    }
	    /**
	     * 获取图片
	     */

	  }, {
	    key: _namedData5,
	    get: function get() {
	      var img = this.content.firstDescendant(TopicItem.imageSelector);

	      if (img) {
	        var data = {};
	        var attachment = img.data(DATA_EXTEND);
	        data.src = attachment ? attachment : img.attr("href");
	        var width = img.attr("width");
	        width && (data.width = JSON.parse(width));
	        var height = img.attr("height");
	        height && (data.height = JSON.parse(height));
	        return data;
	      }

	      return undefined;
	    }
	    /**
	     * 设置图片
	     */

	  }, {
	    key: _namedData6,
	    set: function set(_value) {
	      if (_value && _value.src) {
	        var img = this.content.firstDescendant(TopicItem.imageSelector) || this.content.createSVGChild(TopicItem.imageSelector);

	        if (img) {
	          var attrs = _defineProperty({}, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_IMAGE);

	          if (_value.width !== undefined) {
	            attrs.width = _value.width;
	          }

	          if (_value.height !== undefined) {
	            attrs.height = _value.height;
	          }

	          var src = String(_value.src);

	          if (src.startsWith(ATTACHMENT_LINK_PREFIX)) {
	            img.data(DATA_EXTEND, src);
	            src = this.fireEvent(Constants.EVENT_QUERY_ATTACHMENT, src.substr(ATTACHMENT_LINK_PREFIX.length), "");
	          } else {
	            img.data(DATA_EXTEND, null);
	          }

	          src = src.trim();

	          if (src) {
	            attrs.href = src;
	            img.attr(attrs);
	          } else {
	            img.remove();
	          }
	        }
	      } else {
	        var _img = this.content.firstDescendant(TopicItem.imageSelector);

	        _img && _img.remove();
	      }
	    }
	    /**
	     * 获取标签
	     */

	  }, {
	    key: _namedData7,
	    get: function get() {
	      var labels = this.content.firstDescendant(TopicItem.labelsSelector);

	      if (labels) {
	        var list = [];

	        var _iterator5 = _createForOfIteratorHelper$2(labels.getDescandant("text")),
	            _step5;

	        try {
	          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
	            var text = _step5.value;
	            list.push(text.text);
	          }
	        } catch (err) {
	          _iterator5.e(err);
	        } finally {
	          _iterator5.f();
	        }

	        return list;
	      }

	      return undefined;
	    }
	    /**
	     * 设置标签
	     */

	  }, {
	    key: _namedData8,
	    set: function set(_value) {
	      if (_value instanceof Array && _value.length > 0) {
	        var labels = this.content.firstDescendant(TopicItem.labelsSelector) || this.content.createSVGChild("g");

	        if (labels) {
	          var attrs = _defineProperty({
	            "class": CLASS_NAME.TOPIC_LABELS
	          }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_LABELS);

	          labels.clearChildren();
	          labels.attr(attrs);
	          var rect = labels.createSVGChild("rect");
	          attrs["class"] = CLASS_NAME.TOPIC_LABEL_BG;
	          rect.attr(attrs);
	          attrs["class"] = "".concat(CLASS_NAME.TOPIC_TEXT, " ").concat(CLASS_NAME.TOPIC_TEXT_BASIC);

	          var _iterator6 = _createForOfIteratorHelper$2(_value),
	              _step6;

	          try {
	            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	              var item = _step6.value;
	              var text = labels.createSVGChild("text");
	              text.attr(attrs);
	              text.text = item;
	            }
	          } catch (err) {
	            _iterator6.e(err);
	          } finally {
	            _iterator6.f();
	          }
	        }
	      } else {
	        var _labels = this.content.firstDescendant(TopicItem.labelsSelector);

	        _labels && _labels.remove();
	      }
	    }
	    /**
	     * 获取链接
	     */

	  }, {
	    key: _namedData9,
	    get: function get() {
	      var href = this.content.firstDescendant(TopicItem.linkSelector);

	      if (href) {
	        return href.data(DATA_EXTEND);
	      }

	      return undefined;
	    }
	    /**
	     * 设置链接
	     */

	  }, {
	    key: _namedData10,
	    set: function set(_value) {
	      if (_value && (_value = String(_value).trim())) {
	        var href = this.content.firstDescendant(TopicItem.linkSelector) || this.content.createSVGChild("use");
	        href.data(DATA_EXTEND, _value);
	        href.attr(_defineProperty({
	          "class": CLASS_NAME.TOPIC_LINK,
	          href: "#".concat(ID_ICON_LINK)
	        }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_LINK));
	      } else {
	        var _href = this.content.firstDescendant(TopicItem.linkSelector);

	        _href && _href.remove();
	      }
	    }
	    /**
	     * 获取备注
	     */

	  }, {
	    key: _namedData11,
	    get: function get() {
	      var notes = this.content.firstDescendant(TopicItem.notesSelector);

	      if (notes) {
	        return notes.data(DATA_EXTEND);
	      }

	      return undefined;
	    }
	    /**
	     * 设置备注
	     */

	  }, {
	    key: _namedData12,
	    set: function set(_value) {
	      if (_value) {
	        var notes = this.content.firstDescendant(TopicItem.notesSelector) || this.content.createSVGChild("use");
	        notes.data(DATA_EXTEND, _value);
	        notes.attr(_defineProperty({
	          "class": CLASS_NAME.TOPIC_NOTES,
	          href: "#".concat(ID_ICON_NOTES)
	        }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_NOTES));
	      } else {
	        var href = this.content.firstDescendant(TopicItem.notesSelector);
	        href && href.remove();
	      }
	    }
	    /**
	     * 获取附属标志
	     */

	  }, {
	    key: _namedData13,
	    get: function get() {
	      var markerGroup = this.content.firstDescendant(TopicItem.markersSelector);

	      if (markerGroup) {
	        var markerList = {};

	        var _iterator7 = _createForOfIteratorHelper$2(markerGroup.getDescandant("use")),
	            _step7;

	        try {
	          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
	            var item = _step7.value;
	            var itemHref = item.attr("href");

	            if (itemHref) {
	              var _itemHref$split = itemHref.split(/[#-]/),
	                  itemName = _itemHref$split[1],
	                  itemValue = _itemHref$split[2];

	              var fn = Defs["".concat(itemName, "$translate")];
	              typeof fn === 'function' && (itemValue = fn(itemValue));
	              markerList[itemName] = itemValue;
	            }
	          }
	        } catch (err) {
	          _iterator7.e(err);
	        } finally {
	          _iterator7.f();
	        }

	        return markerList;
	      }

	      return undefined;
	    }
	    /**
	     * 设置附属标志
	     */

	  }, {
	    key: _namedData14,
	    set: function set(_value) {
	      if (_value) {
	        var markerGroup = this.content.firstDescendant(TopicItem.markersSelector) || this.content.createSVGChild("g");

	        if (markerGroup) {
	          markerGroup.attr(_defineProperty({
	            "class": CLASS_NAME.TOPIC_MARKERS
	          }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_MARKERS));
	          markerGroup.clearChildren();
	          var itemCount = 0;

	          for (var itemName in _value) {
	            var itemValue = _value[itemName];
	            var fn = Defs["".concat(itemName, "$translate")];
	            typeof fn === "function" && (itemValue = fn(itemValue, true));
	            var itemNode = markerGroup.createSVGChild("use");
	            itemNode.attr(_defineProperty({
	              href: "#".concat(itemName, "-").concat(itemValue)
	            }, Constants.ATTR_EVENT_STAMP, STAMP_TOPIC_MARKERS));
	            itemCount++;
	          }

	          itemCount <= 0 && markerGroup.remove();
	        }
	      } else {
	        var _markerGroup = this.content.firstDescendant(TopicItem.markersSelector);

	        _markerGroup && _markerGroup.remove();
	      }
	    }
	  }, {
	    key: "isInFocus",
	    get: function get() {
	      return this.content && this.content.hasClass(CLASS_NAME.TOPIC_IN_FOCUS);
	    }
	  }], [{
	    key: "propertyName",
	    value: function propertyName(_name) {
	      var dest = namedData$1(_name);
	      var list = Object.getOwnPropertyNames(TopicItem.prototype);
	      return list && list.indexOf(dest) >= 0 ? dest : undefined;
	    }
	    /**
	     * 获取所有属性数据名称的迭代器
	     */

	  }, {
	    key: "propertyNames",
	    value: /*#__PURE__*/regenerator.mark(function propertyNames() {
	      var list, _iterator8, _step8, itemName, dataName;

	      return regenerator.wrap(function propertyNames$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              list = Object.getOwnPropertyNames(TopicItem.prototype);
	              _iterator8 = _createForOfIteratorHelper$2(list);
	              _context2.prev = 2;

	              _iterator8.s();

	            case 4:
	              if ((_step8 = _iterator8.n()).done) {
	                _context2.next = 12;
	                break;
	              }

	              itemName = _step8.value;
	              dataName = dataPureName(itemName);

	              if (!dataName) {
	                _context2.next = 10;
	                break;
	              }

	              _context2.next = 10;
	              return {
	                name: dataName,
	                fullName: itemName
	              };

	            case 10:
	              _context2.next = 4;
	              break;

	            case 12:
	              _context2.next = 17;
	              break;

	            case 14:
	              _context2.prev = 14;
	              _context2.t0 = _context2["catch"](2);

	              _iterator8.e(_context2.t0);

	            case 17:
	              _context2.prev = 17;

	              _iterator8.f();

	              return _context2.finish(17);

	            case 20:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, propertyNames, null, [[2, 14, 17, 20]]);
	    })
	  }]);

	  return TopicItem;
	}();
	/**
	 * 主题类
	 */


	_defineProperty(TopicItem, "imageSelector", "image");

	_defineProperty(TopicItem, "titleSelector", "rect.".concat(CLASS_NAME.TOPIC_RECT));

	_defineProperty(TopicItem, "linkSelector", "use.".concat(CLASS_NAME.TOPIC_LINK));

	_defineProperty(TopicItem, "notesSelector", "use.".concat(CLASS_NAME.TOPIC_NOTES));

	_defineProperty(TopicItem, "markersSelector", "g.".concat(CLASS_NAME.TOPIC_MARKERS));

	_defineProperty(TopicItem, "labelsSelector", "g.".concat(CLASS_NAME.TOPIC_LABELS));

	_defineProperty(TopicItem, "focusItemSelector", ".".concat(CLASS_NAME.TOPIC_IN_FOCUS));

	_defineProperty(TopicItem, "underLineSelectors", [TopicItem.linkSelector, TopicItem.notesSelector, TopicItem.markersSelector, TopicItem.labelsSelector]);

	_namedHandler = namedHandler("click", STAMP_FOLD_ICON);
	_namedHandler2 = namedHandler("click", STAMP_TOPIC_LINK);
	_namedHandler3 = namedHandler("click", STAMP_TOPIC_NOTES);
	_namedHandler4 = namedHandler("click", STAMP_TOPIC_IMAGE);
	_namedHandler5 = namedHandler("click", STAMP_TOPIC_LABELS);
	_namedHandler6 = namedHandler("click", STAMP_TOPIC_LABEL_MORE);
	_namedHandler7 = namedHandler("click", STAMP_TOPIC_MARKERS);
	_namedHandler8 = namedHandler("click");

	var Topic = /*#__PURE__*/function () {
	  function Topic(_data, _level, _parent) {
	    _classCallCheck(this, Topic);

	    var inner = this[PRIVATE_SYMBOL] = {};

	    if (isENode(_data)) {
	      // 从既有元素封装出一个实例
	      if (_data.tagName !== "g" || !_data.hasClass(CLASS_NAME.TOPIC_GROUP_BASIC)) {
	        throw ERROR.ILLEGAL_INSTANCE("_data", "<g> with group class");
	      }

	      var content = inner.content = _data;
	      this.fireEvent = fireEvent.bind(content);
	      inner.childrenGroup = content.firstDescendant(Topic.childrenGroupSelector);
	      inner.item = new TopicItem(content.firstDescendant("g.".concat(CLASS_NAME.TOPIC_ITEM_G_BASIC, "#").concat(content.attr("id"))));
	    } else if (isENode(_parent) && _parent.isSVG) {
	      // 创建一个全新实例
	      var id = mID(_data.id); // 本类的关键在于创建一个主题组用于管理主题内的全局数据，具体的主题数据由其他类实现

	      var _content2 = inner.content = _parent.createSVGChild("g");

	      _content2.attr({
	        id: id,
	        "class": CLASS_NAME.TOPIC_GROUP_BASIC
	      });

	      if (_data && _data.direction !== undefined) {
	        _content2.data("direction", _data.direction);
	      }

	      this.fireEvent = fireEvent.bind(_content2); // 创建主题项实例, 注意：子主题组要优先于主题项被创建，这样才能保证子主题连接线不会把主题项给覆盖

	      var childrenGroup = inner.childrenGroup = _content2.createSVGChild("g");

	      childrenGroup.attr({
	        id: id,
	        "class": CLASS_NAME.TOPIC_CHILD_G_BASIC
	      });
	      var item = inner.item = new TopicItem(_data, _level, _content2); // 挂载事件处理

	      mapEventHandler(item.content, this); // 创建子主题

	      var subSource = _data.children;

	      if (subSource instanceof Array) {
	        for (var idx in subSource) {
	          this.addNewChild(subSource[idx]);
	        }
	      } // 注意：此处并不创建连接线，连接线在布局的时候生成

	    }
	  } // 折叠按钮被点击，进行折叠和展开的处理


	  _createClass(Topic, [{
	    key: _namedHandler,
	    value: function value(_event, _stamp, _element) {
	      this.fold(String(_element.getAttribute("href")).indexOf(ID_ICON_MINUS) >= 0);
	      handledEvent(_event);
	    } // 唤起链接

	  }, {
	    key: _namedHandler2,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_LINK, {
	        topic: this,
	        data: this.topicData("href")
	      });
	      continueSiblingHandler(_event);
	    } // 唤起备注

	  }, {
	    key: _namedHandler3,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_NOTES, {
	        topic: this,
	        data: this.topicData("notes")
	      });
	      continueSiblingHandler(_event);
	    } // 唤起图像

	  }, {
	    key: _namedHandler4,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_IMAGE, {
	        topic: this,
	        data: this.topicData("image")
	      });
	      continueSiblingHandler(_event);
	    } // 唤起标签

	  }, {
	    key: _namedHandler5,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_LABELS, {
	        topic: this,
	        data: this.topicData("labels")
	      });
	      continueSiblingHandler(_event);
	    } // 唤起标签（更多）

	  }, {
	    key: _namedHandler6,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_LABELS, {
	        topic: this,
	        data: this.topicData("labels"),
	        more: true
	      });
	      continueSiblingHandler(_event);
	    } // 唤起图标

	  }, {
	    key: _namedHandler7,
	    value: function value(_event) {
	      this.fireEvent(Constants.EVENT_INVOKE_MARKERS, {
	        topic: this,
	        data: this.topicData("markers")
	      });
	      continueSiblingHandler(_event);
	    } // 点击了主题的标题部分

	  }, {
	    key: _namedHandler8,
	    value: function value(_event) {
	      this.focus();
	      handledEvent(_event);
	    }
	    /**
	     * 获取深度操作该主题组的细节实例
	     */

	  }, {
	    key: "direction",

	    /**
	     * 获取/设置主题的布局方向
	     */
	    value: function direction(_value) {
	      var content = getPrivate(this).content;

	      if (_value === undefined) {
	        return content.data("direction") || CONNECT_DIRECTION_RIGHT;
	      } else {
	        content.data("direction", _value);
	      }

	      return this;
	    }
	    /**
	     * 获取标题区的坐标
	     */

	  }, {
	    key: "globalZone",

	    /**
	     * 获取内部项目的全局区域坐标信息
	     * @param {*} _item 
	     */
	    value: function globalZone(_item) {
	      var item = getPrivate(this).item;
	      return item ? item.globalZone(_item) : undefined;
	    }
	    /**
	     * 获取内部项目相对于导图容器的坐标信息
	     * @param {*} _item 
	     */

	  }, {
	    key: "relativeZone",
	    value: function relativeZone(_item) {
	      var item = getPrivate(this).item;
	      return item ? item.relativeZone(_item) : undefined;
	    }
	    /**
	     * 获取主题的全区域坐标
	     */

	  }, {
	    key: "childrenTopics",

	    /**
	     * 获取子主题的实例集合的迭代器
	     */
	    value: /*#__PURE__*/regenerator.mark(function childrenTopics() {
	      var childrenGroup, nodeIterator, _iterator9, _step9, itemNode;

	      return regenerator.wrap(function childrenTopics$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              childrenGroup = getPrivate(this).childrenGroup;

	              if (!childrenGroup) {
	                _context3.next = 20;
	                break;
	              }

	              nodeIterator = childrenGroup.getChildren(Topic.contentSelector);
	              _iterator9 = _createForOfIteratorHelper$2(nodeIterator);
	              _context3.prev = 4;

	              _iterator9.s();

	            case 6:
	              if ((_step9 = _iterator9.n()).done) {
	                _context3.next = 12;
	                break;
	              }

	              itemNode = _step9.value;
	              _context3.next = 10;
	              return new Topic(itemNode);

	            case 10:
	              _context3.next = 6;
	              break;

	            case 12:
	              _context3.next = 17;
	              break;

	            case 14:
	              _context3.prev = 14;
	              _context3.t0 = _context3["catch"](4);

	              _iterator9.e(_context3.t0);

	            case 17:
	              _context3.prev = 17;

	              _iterator9.f();

	              return _context3.finish(17);

	            case 20:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, childrenTopics, this, [[4, 14, 17, 20]]);
	    })
	    /**
	     * 检查是否有子主题
	     */

	  }, {
	    key: "topicData",

	    /**
	     * 获取或设置主题自身的数据
	     * @param {*} _key 要操作的数据的名称，如果不传入参数，表示获取主题的所有数据；如果传入的是字符串，则表示获取或设置对应名称的数据；如果传入的是对象，则将对象内的成员批量设置为主题的属性
	     * @param {*} _value 
	     */
	    value: function topicData(_key, _value) {
	      var item = getPrivate(this).item;

	      if (item) {
	        if (_key === undefined) {
	          var data = {};

	          var _iterator10 = _createForOfIteratorHelper$2(item.propertys()),
	              _step10;

	          try {
	            for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
	              var property = _step10.value;
	              property.value !== undefined && property.value !== null && (data[property.name] = property.value);
	            }
	          } catch (err) {
	            _iterator10.e(err);
	          } finally {
	            _iterator10.f();
	          }

	          if (this.level === 1) {
	            data.direction = this.direction();
	          }

	          return data;
	        } else if (typeof _key === "string") {
	          var dataName = TopicItem.propertyName(_key);

	          if (dataName) {
	            if (_value === undefined) {
	              return item[dataName];
	            } else {
	              item[dataName] = _value;
	              this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	            }
	          }
	        } else {
	          var count = 0;

	          for (var itemName in _key) {
	            var _dataName = TopicItem.propertyName(itemName);

	            if (_dataName) {
	              var itemValue = _key[itemName];
	              item[_dataName] = itemValue;
	              count++;
	            }
	          }

	          count !== 0 && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取主题的所有数据
	     */

	  }, {
	    key: "isSame",

	    /**
	     * 检查是否是相同的主题
	     * @param {*} _topic 
	     */
	    value: function isSame(_topic) {
	      return _topic instanceof Topic && getPrivate(this).content.isSame(getPrivate(_topic).content);
	    }
	    /**
	     * 让主题组完成相对定位
	     * @param {*} _x 
	     * @param {*} _y 
	     */

	  }, {
	    key: "translate",
	    value: function translate(_x, _y) {
	      var content = getPrivate(this).content;
	      content && content.attr("transform", "translate(".concat(_x, ", ").concat(_y, ")"));
	      return this;
	    }
	    /**
	     * 设置/获取主题折叠
	     * @param {*} _isFold 如果不传入参数表示获取折叠的设置
	     */

	  }, {
	    key: "fold",
	    value: function fold(_isFold) {
	      var childrenGroup = getPrivate(this).childrenGroup;
	      this.focus();

	      if (_isFold === undefined) {
	        return childrenGroup && childrenGroup.style("display", "none");
	      } else {
	        childrenGroup && childrenGroup.style("display", _isFold ? "none" : "unset");
	        this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	      }

	      return this;
	    }
	    /**
	     * 设置主题是否拥有焦点
	     * @param {*} _focus true或者不传入参数表示主题拥有焦点，否则清除主题焦点
	     */

	  }, {
	    key: "focus",
	    value: function focus() {
	      var _focus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	      var item = getPrivate(this).item;

	      if (item) {
	        var ret = item.focus(_focus);

	        if (ret !== undefined) {
	          this.fireEvent(Constants.EVENT_FOCUS_CHANGE, ret ? this : null);
	        }
	      }

	      return this;
	    }
	    /**
	     * 检查主题是否有焦点
	     */

	  }, {
	    key: "addNewChild",

	    /**
	     * 添加一个新的子主题
	     * @param {*} _data 子主题的数据，如果不传入数据，则使用默认数据
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */
	    value: function addNewChild(_data) {
	      var _redraw = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	      var _value = _data ? _data.title ? _data : Object.assign({
	        title: Topic.DefaultTitle
	      }, _data) : {
	        title: Topic.DefaultTitle
	      };

	      var topic = new Topic(_value, this.level + 1, getPrivate(this).childrenGroup);
	      _redraw && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	      return topic;
	    }
	    /**
	     * 将主题从思维导图中移除
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */

	  }, {
	    key: "remove",
	    value: function remove() {
	      var _redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	      if (this.level > 0) {
	        var content = getPrivate(this).content;

	        if (content) {
	          var parentNode = content.parent(Topic.childrenGroupSelector);
	          var path = parentNode.firstDescendant("path#".concat(this.id));

	          if (path) {
	            path.remove();
	          }

	          content.remove();
	          _redraw && fireEvent.call(parentNode, Constants.EVENT_REQUIRE_LAYOUT);
	        }
	      }

	      return this;
	    }
	    /**
	     * 删除所有子主题
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */

	  }, {
	    key: "clearChildren",
	    value: function clearChildren() {
	      var _redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

	      var _iterator11 = _createForOfIteratorHelper$2(this.childrenTopics()),
	          _step11;

	      try {
	        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
	          var item = _step11.value;
	          item instanceof Topic && item.remove();
	        }
	      } catch (err) {
	        _iterator11.e(err);
	      } finally {
	        _iterator11.f();
	      }

	      _redraw && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	      return this;
	    }
	    /**
	     * 将主题加为其他主题的子主题
	     * @param {*} _parent 新的父主题
	     * @param {*} _toHead true表示加为新父主题的第一个子主题；false或不传入参数，表示加为新父主题的最后一个子主题
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */

	  }, {
	    key: "insertTo",
	    value: function insertTo(_parent, _toHead) {
	      var _redraw = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

	      if (_parent instanceof Topic) {
	        var childrenGroup = getPrivate(_parent).childrenGroup;

	        var _getPrivate = getPrivate(this),
	            content = _getPrivate.content,
	            item = _getPrivate.item;

	        if (childrenGroup && content) {
	          this.remove();
	          _toHead ? content.insertToTop(childrenGroup) : content.appendTo(childrenGroup);
	          item.level(_parent.level + 1);
	          _redraw && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	        }
	      }

	      return this;
	    }
	    /**
	     * 添加为一个主题的同级后续主题
	     * @param {*} _sibling 同级主题
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */

	  }, {
	    key: "insertNextTo",
	    value: function insertNextTo(_sibling) {
	      var _redraw = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	      if (_sibling instanceof Topic) {
	        var siblingContent = _sibling.content;

	        var _getPrivate2 = getPrivate(this),
	            content = _getPrivate2.content,
	            item = _getPrivate2.item;

	        this.remove();
	        content.insertAfter(siblingContent);
	        item.level(_sibling.level);
	        _redraw && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	      }
	    }
	    /**
	     * 将主题加为一个主题的兄弟主题
	     * @param {*} _brother 兄弟主题
	     * @param {*} _before true表示加到_brother主题之前，false或不传入该参数表示加到_brother主题之后
	     * @param {*} _redraw true或者不传入该参数表示理解重绘画面；false表示不立即重绘画面；该参数用于对思维导图一次做多项变更时减少刷新
	     */

	  }, {
	    key: "insertAsBrother",
	    value: function insertAsBrother(_brother, _before) {
	      var _redraw = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

	      if (_brother instanceof Topic) {
	        var brotherContent = getPrivate(_brother).content;

	        var _getPrivate3 = getPrivate(this),
	            content = _getPrivate3.content,
	            item = _getPrivate3.item;

	        if (brotherContent && content) {
	          this.remove();
	          _before ? content.insertBefore(brotherContent) : content.insertAfter(brotherContent);
	          item.level(_brother.level);
	          _redraw && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取主题的可见性
	     */

	  }, {
	    key: "layout",

	    /**
	     * 根据MindSVG配置布局主题项内部的元素
	     * @param {*} _mindSVG 隶属于的MindSVG对象
	     * @param {*} _foldLevel 折叠等级
	     */
	    value: function layout(_mindSVG, _foldLevel, _direction) {
	      if (!(_mindSVG instanceof MindSVG)) {
	        throw ERROR.INVALID_PARAM("_mindSVG");
	      }

	      var _getPrivate4 = getPrivate(this),
	          content = _getPrivate4.content,
	          topicItem = _getPrivate4.item,
	          childrenGroup = _getPrivate4.childrenGroup;

	      if (!content || !(topicItem instanceof TopicItem) || !childrenGroup) {
	        throw ERROR.ILLEGAL_INSTANCE("Topic");
	      } // 布局主题项


	      topicItem.layout(_mindSVG, _direction); // 确定折叠图标的显示

	      var level = topicItem.level();
	      var isFold = _foldLevel === undefined ? childrenGroup.node.style.display === "none" : _foldLevel > 0 ? _foldLevel <= level : false;
	      topicItem.fold(this.hasChild && level > 0 ? isFold : null);

	      if (isFold) {
	        // 折叠状态下就隐藏子项组，也不做子项组的布局
	        childrenGroup.node.style.display = "none";
	      } else {
	        // 显示子项组，先让子主题内部完成布局，然后让子主题在子元素组中完成布局
	        childrenGroup.node.style.display = "unset"; // 获取布局用的基本参数

	        var connectPointer = topicItem.connectPointer(CONNECT_DIRECTION_RIGHT);

	        var configs = _mindSVG.config();

	        var topicMarginRightX = configs.topicMarginX;
	        var topicMarginLeftX = 0 - connectPointer.x - topicMarginRightX;
	        var topicMarginY = configs.topicMarginY;
	        var subTopicLayoutParams = {};
	        var offsetRightY = 0;
	        var offsetLeftY = 0;
	        var direction = _direction; // 先计算子主题的基本布局参数

	        var _iterator12 = _createForOfIteratorHelper$2(this.childrenTopics()),
	            _step12;

	        try {
	          for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
	            var subItem = _step12.value;

	            if (subItem.visible) {
	              _direction === undefined && (direction = subItem.direction());
	              subItem.layout(_mindSVG, _foldLevel, direction);
	              var subOrigin = subItem.originCorner;

	              if (direction === CONNECT_DIRECTION_LEFT) {
	                // 布局在左侧的子主题
	                var translateY = subOrigin.y < 0 ? offsetLeftY - subOrigin.y : offsetLeftY;
	                var titleZone = subItem.titleZone;
	                var subHeight = subItem.size.height;
	                offsetLeftY += subHeight + topicMarginY;
	                subTopicLayoutParams[subItem.id] = {
	                  obj: subItem,
	                  x: topicMarginLeftX - titleZone.width,
	                  y: translateY,
	                  lineY: translateY + titleZone.height / 2,
	                  left: true
	                };
	              } else {
	                // 布局在右侧的子主题
	                var _translateY = subOrigin.y < 0 ? offsetRightY - subOrigin.y : offsetRightY;

	                var _subHeight = subItem.size.height;
	                offsetRightY += _subHeight + topicMarginY;
	                subTopicLayoutParams[subItem.id] = {
	                  obj: subItem,
	                  x: topicMarginRightX,
	                  y: _translateY,
	                  lineY: _translateY + subItem.titleZone.height / 2,
	                  left: false
	                };
	              }
	            }
	          } // 再计算让左右主题平衡居中布局的修正量

	        } catch (err) {
	          _iterator12.e(err);
	        } finally {
	          _iterator12.f();
	        }

	        if (offsetRightY > offsetLeftY) {
	          offsetLeftY = (offsetRightY - offsetLeftY) / 2;
	          offsetRightY = 0;
	        } else {
	          offsetRightY = (offsetLeftY - offsetRightY) / 2;
	          offsetLeftY = 0;
	        } // 执行布局，并连接主题项与子主题之间的线


	        var lineBezierCtrlSize = configs.lineBezierCtrlSize;
	        var startY = childrenGroup.height >> 1;
	        var pathDataRightPrefix = "M0 ".concat(startY, "C").concat(lineBezierCtrlSize, " ").concat(startY, " ").concat(topicMarginRightX - lineBezierCtrlSize, " ");
	        var pathDataLeftPrefix = "M".concat(0 - connectPointer.x, " ").concat(startY, "C").concat(0 - connectPointer.x - lineBezierCtrlSize, " ").concat(startY, " ").concat(topicMarginLeftX + lineBezierCtrlSize, " ");

	        for (var lineID in subTopicLayoutParams) {
	          var _subTopicLayoutParams = subTopicLayoutParams[lineID],
	              obj = _subTopicLayoutParams.obj,
	              x = _subTopicLayoutParams.x,
	              y = _subTopicLayoutParams.y,
	              endY = _subTopicLayoutParams.lineY,
	              isLeft = _subTopicLayoutParams.left;
	          var offsetY = isLeft ? offsetLeftY : offsetRightY;
	          obj.translate(x, y + offsetY);
	          endY += offsetY;
	          var path = childrenGroup.firstDescendant("path#".concat(lineID)) || childrenGroup.createSVGChild("path");
	          path.attr({
	            id: lineID,
	            d: isLeft ? "".concat(pathDataLeftPrefix).concat(endY, " ").concat(topicMarginLeftX, " ").concat(endY) : "".concat(pathDataRightPrefix).concat(endY, " ").concat(topicMarginRightX, " ").concat(endY),
	            "class": CLASS_NAME.TOPIC_LINK_LINE
	          });
	        } // 将子项组布局到与主题项连接点垂直居中的位置上去


	        childrenGroup.attr("transform", "translate(".concat(connectPointer.x, ", ").concat(0 - startY + connectPointer.y, ")"));
	      }
	    }
	    /**
	     * 文字转换
	     */

	  }, {
	    key: "toString",
	    value: function toString() {
	      return JSON.stringify(this.topicData());
	    }
	  }, {
	    key: "content",
	    get: function get() {
	      return getPrivate(this).content;
	    }
	    /**
	     * 获取父主题
	     */

	  }, {
	    key: "parent",
	    get: function get() {
	      if (this.level > 0) {
	        var content = getPrivate(this).content;
	        var parentNode = content.parent(Topic.contentSelector);
	        return parentNode ? new Topic(parentNode) : undefined;
	      }

	      return undefined;
	    }
	    /**
	     * 获取主题项的大小
	     */

	  }, {
	    key: "size",
	    get: function get() {
	      var content = getPrivate(this).content;
	      var width = 0;
	      var height = 0;

	      if (content) {
	        var box = content.rect;
	        width = box.width;
	        height = box.height;
	      }

	      return {
	        width: width,
	        height: height
	      };
	    }
	    /**
	     * 获取主题组的起始点坐标（相对于主题组自身坐标系）
	     */

	  }, {
	    key: "originCorner",
	    get: function get() {
	      var content = getPrivate(this).content;
	      var x;
	      var y;

	      if (content) {
	        var rect = content.rect;
	        x = rect.x;
	        y = rect.y;
	      } else {
	        x = 0;
	        y = 0;
	      }

	      return {
	        x: x,
	        y: y
	      };
	    }
	    /**
	     * 获取主题的ID
	     */

	  }, {
	    key: "id",
	    get: function get() {
	      var content = getPrivate(this).content;
	      return content ? content.attr("id") || "" : "";
	    }
	  }, {
	    key: "titleZone",
	    get: function get() {
	      var item = getPrivate(this).item;
	      return item ? item.titleZone : {
	        x: 0,
	        y: 0,
	        width: 0,
	        height: 0
	      };
	    }
	    /**
	     * 获取主题项内容的坐标
	     */

	  }, {
	    key: "itemZone",
	    get: function get() {
	      var item = getPrivate(this).item;
	      return item && item.content ? item.content.globalRect : {
	        x: 0,
	        y: 0,
	        width: 0,
	        height: 0
	      };
	    }
	  }, {
	    key: "totalZone",
	    get: function get() {
	      var content = getPrivate(this).content;
	      return content ? content.globalRect : {
	        x: 0,
	        y: 0,
	        width: 0,
	        height: 0
	      };
	    }
	  }, {
	    key: "hasChild",
	    get: function get() {
	      var childrenGroup = getPrivate(this).childrenGroup;
	      return childrenGroup && childrenGroup.firstDescendant(Topic.contentSelector) !== undefined;
	    }
	    /**
	     * 获取主题的等级
	     */

	  }, {
	    key: "level",
	    get: function get() {
	      var item = getPrivate(this).item;
	      return item.level();
	    }
	  }, {
	    key: "data",
	    get: function get() {
	      var value = this.topicData();

	      if (value) {
	        value.id = this.id;
	        var children = value.children = [];
	        var childrenList = this.childrenTopics();

	        var _iterator13 = _createForOfIteratorHelper$2(childrenList),
	            _step13;

	        try {
	          for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
	            var subTopic = _step13.value;
	            children.push(subTopic.data);
	          }
	        } catch (err) {
	          _iterator13.e(err);
	        } finally {
	          _iterator13.f();
	        }
	      }

	      return value;
	    }
	  }, {
	    key: "isInFocus",
	    get: function get() {
	      var item = getPrivate(this);
	      return item && item.isInFocus;
	    }
	  }, {
	    key: "visible",
	    get: function get() {
	      return getPrivate(this).content.style("display") !== "none";
	    }
	    /**
	     * 设置主题的可见性
	     */
	    ,
	    set: function set(_value) {
	      var content = getPrivate(this).content;
	      var oldValue = content.style("display") !== "none";
	      _value = _value || false;

	      if (oldValue !== _value) {
	        var display = _value ? "unset" : "none";
	        content.style("display", display);
	        var path = content.root.firstDescendant("path#".concat(content.attr("id")));

	        if (path) {
	          path.node.style.display = display;
	        }

	        if (!_value && this.isInFocus) {
	          this.focus(false);
	        }

	        _value && this.fireEvent(Constants.EVENT_REQUIRE_LAYOUT);
	      }
	    }
	    /**
	     * 获取下一个兄弟主题
	     */

	  }, {
	    key: "nextSibling",
	    get: function get() {
	      var node = this.content;

	      while (node = ENode().attach(node.node.nextSibling)) {
	        if (node.matches(Topic.contentSelector)) {
	          return new Topic(node);
	        }
	      }

	      return undefined;
	    }
	    /**
	     * 获取上一个兄弟主题
	     */

	  }, {
	    key: "previousSibling",
	    get: function get() {
	      var node = this.content;

	      while (node = ENode().attach(node.node.previousSibling)) {
	        if (node.matches(Topic.contentSelector)) {
	          return new Topic(node);
	        }
	      }

	      return undefined;
	    }
	    /**
	     * 获取第一个下级主题
	     */

	  }, {
	    key: "firstDescendant",
	    get: function get() {
	      var node = this.content.firstDescendant(Topic.contentSelector);
	      return node ? new Topic(node) : undefined;
	    }
	  }]);

	  return Topic;
	}();
	/**
	 * 获取元素所在的主题
	 * @param {*} _node 
	 */


	_defineProperty(Topic, "DefaultTitle", "默认主题");

	_defineProperty(Topic, "contentSelector", "g.".concat(CLASS_NAME.TOPIC_GROUP_BASIC));

	_defineProperty(Topic, "childrenGroupSelector", "g.".concat(CLASS_NAME.TOPIC_CHILD_G_BASIC));
	/**
	 * SVG思维导图类
	 */

	var MindSVG = /*#__PURE__*/function () {
	  function MindSVG(_parent) {
	    _classCallCheck(this, MindSVG);

	    var inner = this[PRIVATE_SYMBOL] = {
	      configs: {},
	      rootTopic: undefined,
	      container: ENode("div")
	    };
	    var parent = ENode().attach(_parent) || ENode().attach("body");
	    var container = inner.container;
	    container.attr({
	      "class": "".concat(CLASS_NAME.MAIN_BASIC, " ").concat(CLASS_NAME.MAIN_CONTAINER),
	      tabindex: "1"
	    });
	    container.appendTo(parent);
	    this.fireEvent = fireEvent.bind(container);
	    inner.timerID = setInterval(MindSVG.checkState, TIMER_CHECKER_INTERVAL, this);
	    var svg = container.firstDescendant("svg") || container.createSVGChild("svg");
	    inner.svg = svg;
	    inner.containerWidth = container.width;
	    inner.containerHeight = container.height;
	    inner.offsetX = 0;
	    inner.offsetY = 0;
	    inner.scaleRate = 1;
	    svg.attr({
	      viewBox: "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(inner.containerWidth, " ").concat(inner.containerHeight),
	      "class": CLASS_NAME.MAIN_SVG,
	      width: "100%",
	      height: "100%"
	    });
	    inner.content = undefined;
	    Object.assign(inner.configs, DEFAULT_CONFIGS); // 创建标准预定义件

	    new Defs(svg); // 关联默认处理事件

	    mapEventHandler(container, this);
	  } // 响应请求重新布局


	  _createClass(MindSVG, [{
	    key: namedHandler(Constants.EVENT_REQUIRE_LAYOUT),
	    value: function value() {
	      this.fold();
	    } // 响应在空白处点击

	  }, {
	    key: namedHandler("click"),
	    value: function value(_event) {
	      // 清除焦点
	      this.clearFocus();
	      handledEvent(_event);
	    }
	    /**
	     * 检查内部的状态
	     */

	  }, {
	    key: "release",

	    /**
	     * 释放对象，因为JS不支持析构，所有要手动调用此方法释放实例中资源占用的部分
	     */
	    value: function release() {
	      var inner = getPrivate(this);

	      if (inner.timerID) {
	        clearInterval(inner.timerID);
	        inner.timerID = undefined;
	      }
	    }
	    /**
	     * 添加事件监听
	     * @param {*} _event 
	     * @param {*} _fn 
	     * @param {*} _opt 
	     */

	  }, {
	    key: "on",
	    value: function on(_event, _fn, _opt) {
	      var container = getPrivate(this).container;

	      if (container) {
	        container.on(_event, _fn, _opt);
	      }

	      return this;
	    }
	    /**
	     * 移除事件监听
	     * @param {*} _event 
	     * @param {*} _fn 
	     * @param {*} _opt 
	     */

	  }, {
	    key: "off",
	    value: function off(_event, _fn, _opt) {
	      var container = getPrivate(this).container;

	      if (container) {
	        container.off(_event, _fn, _opt);

	        if (hasEventHandler(MindSVG, _event) && !_fn) {
	          mapEventHandler(container, this, [_event]);
	        }
	      }

	      return this;
	    }
	    /**
	     * 清除所有内容
	     */

	  }, {
	    key: "clear",
	    value: function clear() {
	      var inner = getPrivate(this);

	      if (inner.content) {
	        inner.content.remove();
	        inner.content = undefined;
	        inner.rootTopic = undefined;
	      }

	      return this;
	    }
	    /**
	     * 显示一张思维导图，执行该方法会让原来存在的思维导图被删除掉
	     * @param {*} _data 思维导图数据
	     */

	  }, {
	    key: "show",
	    value: function show(_data) {
	      var inner = getPrivate(this);

	      if (inner.svg) {
	        this.clear();
	        var content = inner.content = inner.svg.createSVGChild("g");
	        content.attr("class", CLASS_NAME.MAIN_BASIC);

	        if (_data) {
	          var rootTopic = inner.rootTopic = new Topic(_data, 0, content);
	          rootTopic.layout(this, 0);
	          this.toCenter();
	        }
	      }

	      return this;
	    }
	    /**
	     * 设置主题风格
	     * @param {String} _theme 主题风格的CSS类名称，如果不填写，则删除自定义主题改用默认风格
	     */

	  }, {
	    key: "setTheme",
	    value: function setTheme(_theme) {
	      var _getPrivate5 = getPrivate(this),
	          content = _getPrivate5.content,
	          container = _getPrivate5.container;

	      var classStr = _theme ? "".concat(CLASS_NAME.MAIN_BASIC, " ").concat(_theme) : CLASS_NAME.MAIN_BASIC;
	      content && content.attr("class", classStr);
	      container && container.attr("class", "".concat(classStr, " ").concat(CLASS_NAME.MAIN_CONTAINER));
	      return this;
	    }
	    /**
	     * 获取思维导图全部内容所占用的大小
	     * @returns {Object} 由width和height构成的大小信息
	     */

	  }, {
	    key: "config",

	    /**
	     * 获取或设置配置
	     * @param {*} _nameOrMap 配置项名称，如果不传入则获取所有配置项的结合对象
	     * @param {*} _value 配置项的值，如果不传入则表示获取配置项、如果传入null表示删除配置项（用默认值）、否则表示设置配置项
	     */
	    value: function config(_nameOrMap, _value) {
	      if (_nameOrMap === undefined) {
	        return Object.assign({}, getPrivate(this).configs);
	      } else if (typeof _nameOrMap === "string") {
	        var configs = getPrivate(this, "configs");

	        if (_value === undefined) {
	          return configs[_nameOrMap];
	        } else if (_value === null) {
	          configs[_nameOrMap] = DEFAULT_CONFIGS[_nameOrMap];
	        } else {
	          configs[_nameOrMap] = _value;
	        }
	      } else {
	        for (var itemName in _nameOrMap) {
	          this.config(String(itemName), _nameOrMap[itemName]);
	        }
	      }

	      return this;
	    }
	    /**
	     * 将整个画布或指定的主题放到视图的中间
	     */

	  }, {
	    key: "toCenter",
	    value: function toCenter(_topic) {
	      var inner = getPrivate(this);

	      if (inner.svg && this.content) {
	        var curWidth = inner.containerWidth / inner.scaleRate;
	        var curHeight = inner.containerHeight / inner.scaleRate;
	        var totalBox = this.content.rect;

	        if (_topic instanceof Topic) {
	          var topicBox = _topic.titleZone;
	          inner.offsetX = parseInt(topicBox.x - (curWidth - topicBox.width) / 2);
	          inner.offsetY = parseInt(topicBox.y - (curHeight - topicBox.height) / 2);
	        } else {
	          var topicNode = inner.svg.firstDescendant("g.".concat(CLASS_NAME.TOPIC_LEVEL_PREFIX, "0"));

	          var _topicBox = topicNode ? topicNode.rect : {
	            width: 0,
	            height: 0
	          };

	          if (totalBox.width < curWidth) {
	            inner.offsetX = totalBox.x - (curWidth - totalBox.width) / 2;
	          } else {
	            var offset = parseInt(0 - (curWidth - _topicBox.width) / 2);

	            if (totalBox.x > offset) {
	              inner.offsetX = totalBox.x;
	            } else if (curWidth + offset > totalBox.width + totalBox.x) {
	              inner.offsetX = totalBox.width + totalBox.x - curWidth;
	            } else {
	              inner.offsetX = offset;
	            }
	          }

	          if (totalBox.height < curHeight) {
	            inner.offsetY = totalBox.y - (curHeight - totalBox.height) / 2;
	          } else {
	            var _offset = parseInt(0 - (curHeight - _topicBox.height) / 2);

	            if (totalBox.y > _offset) {
	              inner.offsetY = totalBox.y;
	            } else if (curHeight + _offset > totalBox.height + totalBox.y) {
	              inner.offsetY = totalBox.height + totalBox.y - curHeight;
	            } else {
	              inner.offsetY = _offset;
	            }
	          }
	        }

	        inner.svg.attr("viewBox", "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(curWidth, " ").concat(curHeight));
	      }

	      return this;
	    }
	    /**
	     * 移动整个脑图
	     * @param {Number} _x 左坐标
	     * @param {Number} _y 右坐标
	     */

	  }, {
	    key: "move",
	    value: function move(_x, _y) {
	      var inner = getPrivate(this);

	      if (inner.svg) {
	        // 如果容器的大小发生变化，则同步修正SVG的视口
	        var curWidth = inner.containerWidth / inner.scaleRate;
	        var curHeight = inner.containerHeight / inner.scaleRate;
	        inner.offsetX = _x;
	        inner.offsetY = _y;
	        inner.svg.attr("viewBox", "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(curWidth, " ").concat(curHeight));
	      }

	      return this;
	    }
	    /**
	     * 在现有位置的基础上以一定偏移移动整个脑图
	     * @param {*} _deltaX 
	     * @param {*} _deltaY 
	     */

	  }, {
	    key: "moveBy",
	    value: function moveBy(_deltaX, _deltaY) {
	      var inner = getPrivate(this);

	      if (inner.svg) {
	        // 如果容器的大小发生变化，则同步修正SVG的视口
	        var curWidth = inner.containerWidth / inner.scaleRate;
	        var curHeight = inner.containerHeight / inner.scaleRate;
	        _deltaX = parseInt(_deltaX);
	        _deltaY = parseInt(_deltaY);

	        if (!isNaN(_deltaX)) {
	          inner.offsetX += _deltaX;
	        }

	        if (!isNaN(_deltaY)) {
	          inner.offsetY += _deltaY;
	        }

	        inner.svg.attr("viewBox", "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(curWidth, " ").concat(curHeight));
	      }

	      return this;
	    }
	    /**
	     * 在现有缩放比例的基础上按照一定比例缩放
	     * @param {*} _r 
	     */

	  }, {
	    key: "scaleBy",
	    value: function scaleBy(_r) {
	      var inner = getPrivate(this);

	      if (inner.svg) {
	        // 如果容器的大小发生变化，则同步修正SVG的视口
	        _r = parseFloat(_r);

	        if (!isNaN(_r)) {
	          this.scale(inner.scaleRate * _r);
	        }
	      }

	      return this;
	    }
	    /**
	     * 按照一定比例缩放
	     * @param {*} _r 
	     */

	  }, {
	    key: "scale",
	    value: function scale(_r) {
	      var inner = getPrivate(this);

	      if (inner.svg) {
	        // 如果容器的大小发生变化，则同步修正SVG的视口
	        _r = parseFloat(_r);

	        if (!isNaN(_r)) {
	          var deny = !isNaN(inner.configs.maxScale) && _r > inner.configs.maxScale;
	          deny = deny || !isNaN(inner.configs.minScale) && _r < inner.configs.minScale;

	          if (!deny) {
	            inner.scaleRate = _r;
	            var curWidth = inner.containerWidth / _r;
	            var curHeight = inner.containerHeight / _r;
	            inner.svg.attr("viewBox", "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(curWidth, " ").concat(curHeight));
	          }
	        }
	      }

	      return this;
	    }
	    /**
	     * 获取缩放率
	     */

	  }, {
	    key: "fold",

	    /**
	     * 折叠到某个级别
	     * @param {Number} _level 取0或小于0的值，表示不折叠
	     */
	    value: function fold(_level) {
	      var rootTopic = getPrivate(this).rootTopic;

	      if (rootTopic) {
	        if (_level > 0) {
	          this.clearFocus();
	        }

	        rootTopic.layout(this, _level);
	      }

	      return this;
	    }
	    /**
	     * 清除焦点
	     */

	  }, {
	    key: "clearFocus",
	    value: function clearFocus() {
	      var svg = getPrivate(this).svg;

	      if (svg) {
	        var lastFocus = svg.firstDescendant(TopicItem.focusItemSelector);

	        if (lastFocus) {
	          lastFocus.removeClass(CLASS_NAME.TOPIC_IN_FOCUS);
	          fireEvent.call(lastFocus, Constants.EVENT_FOCUS_CHANGE, null);
	        }
	      }

	      return this;
	    }
	    /**
	     * 根据ID获取主题
	     * @param {*} _id 主题的ID号
	     */

	  }, {
	    key: "getTopicByID",
	    value: function getTopicByID(_id) {
	      var svg = getPrivate(this).svg;

	      if (svg && _id) {
	        var element = svg.firstDescendant("".concat(Topic.contentSelector, "[id=").concat(_id, "]"));
	        return element ? new Topic(element) : undefined;
	      }
	    }
	    /**
	     * 获取主题的迭代器，可用于异步迭代主题，比如查找主题内容等等
	     */

	  }, {
	    key: "getTopicIterator",
	    value: /*#__PURE__*/regenerator.mark(function getTopicIterator() {
	      var svg, list, _iterator14, _step14, item;

	      return regenerator.wrap(function getTopicIterator$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              svg = getPrivate(this).svg;

	              if (!svg) {
	                _context4.next = 21;
	                break;
	              }

	              list = svg.getDescandant(Topic.contentSelector);
	              _iterator14 = _createForOfIteratorHelper$2(list);
	              _context4.prev = 4;

	              _iterator14.s();

	            case 6:
	              if ((_step14 = _iterator14.n()).done) {
	                _context4.next = 13;
	                break;
	              }

	              item = _step14.value;

	              if (!item) {
	                _context4.next = 11;
	                break;
	              }

	              _context4.next = 11;
	              return new Topic(item);

	            case 11:
	              _context4.next = 6;
	              break;

	            case 13:
	              _context4.next = 18;
	              break;

	            case 15:
	              _context4.prev = 15;
	              _context4.t0 = _context4["catch"](4);

	              _iterator14.e(_context4.t0);

	            case 18:
	              _context4.prev = 18;

	              _iterator14.f();

	              return _context4.finish(18);

	            case 21:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, getTopicIterator, this, [[4, 15, 18, 21]]);
	    })
	    /**
	     * 返回焦点主题
	     */

	  }, {
	    key: "getDefs",

	    /**
	     * 生成获取所有预定义元素的迭代器
	     */
	    value: /*#__PURE__*/regenerator.mark(function getDefs() {
	      var svg, _iterator15, _step15, section, _iterator16, _step16, item, itemID, _itemID$split, itemName, itemValue, fn;

	      return regenerator.wrap(function getDefs$(_context5) {
	        while (1) {
	          switch (_context5.prev = _context5.next) {
	            case 0:
	              svg = getPrivate(this).svg;

	              if (!svg) {
	                _context5.next = 39;
	                break;
	              }

	              _iterator15 = _createForOfIteratorHelper$2(svg.getDescandant("defs"));
	              _context5.prev = 3;

	              _iterator15.s();

	            case 5:
	              if ((_step15 = _iterator15.n()).done) {
	                _context5.next = 31;
	                break;
	              }

	              section = _step15.value;
	              _iterator16 = _createForOfIteratorHelper$2(section.getChildren());
	              _context5.prev = 8;

	              _iterator16.s();

	            case 10:
	              if ((_step16 = _iterator16.n()).done) {
	                _context5.next = 21;
	                break;
	              }

	              item = _step16.value;
	              itemID = item.attr("id");

	              if (!itemID) {
	                _context5.next = 19;
	                break;
	              }

	              _itemID$split = itemID.split("-"), itemName = _itemID$split[0], itemValue = _itemID$split[1];
	              fn = Defs["".concat(itemName, "$translate")];
	              typeof fn === 'function' && (itemValue = fn(itemValue));
	              _context5.next = 19;
	              return {
	                type: itemName,
	                value: itemValue,
	                node: item.node
	              };

	            case 19:
	              _context5.next = 10;
	              break;

	            case 21:
	              _context5.next = 26;
	              break;

	            case 23:
	              _context5.prev = 23;
	              _context5.t0 = _context5["catch"](8);

	              _iterator16.e(_context5.t0);

	            case 26:
	              _context5.prev = 26;

	              _iterator16.f();

	              return _context5.finish(26);

	            case 29:
	              _context5.next = 5;
	              break;

	            case 31:
	              _context5.next = 36;
	              break;

	            case 33:
	              _context5.prev = 33;
	              _context5.t1 = _context5["catch"](3);

	              _iterator15.e(_context5.t1);

	            case 36:
	              _context5.prev = 36;

	              _iterator15.f();

	              return _context5.finish(36);

	            case 39:
	            case "end":
	              return _context5.stop();
	          }
	        }
	      }, getDefs, this, [[3, 33, 36, 39], [8, 23, 26, 29]]);
	    })
	  }, {
	    key: "container",

	    /**
	     * 获取SVG所属的上层容器
	     */
	    get: function get() {
	      return getPrivate(this).container;
	    }
	    /**
	     * 获取对应的svg
	     */

	  }, {
	    key: "svg",
	    get: function get() {
	      return getPrivate(this).svg;
	    }
	    /**
	     * 获取主组
	     */

	  }, {
	    key: "content",
	    get: function get() {
	      return getPrivate(this).content;
	    }
	    /**
	     * 获取根主题
	     */

	  }, {
	    key: "rootTopic",
	    get: function get() {
	      return getPrivate(this).rootTopic;
	    }
	    /**
	     * 获取主区域的信息
	     */

	  }, {
	    key: "zone",
	    get: function get() {
	      var inner = getPrivate(this);
	      return {
	        x: inner.offsetX,
	        y: inner.offsetY,
	        width: inner.containerWidth / inner.scaleRate,
	        height: inner.containerHeight / inner.scaleRate
	      };
	    }
	    /**
	     * 获取所有思维导图的所有数据
	     */

	  }, {
	    key: "data",
	    get: function get() {
	      var rootTopic = getPrivate(this).rootTopic;
	      return rootTopic instanceof Topic ? rootTopic.data : {};
	    }
	  }, {
	    key: "totalSize",
	    get: function get() {
	      var content = getPrivate(this).content;
	      var width = 0;
	      var height = 0;

	      if (content) {
	        var box = content.rect;
	        width = box.width;
	        height = box.height;
	      }

	      return {
	        width: width,
	        height: height
	      };
	    }
	  }, {
	    key: "scaleRate",
	    get: function get() {
	      var inner = getPrivate(this);
	      return inner ? inner.scaleRate : 1;
	    }
	    /**
	     * 获取画布的统一偏移
	     */

	  }, {
	    key: "offset",
	    get: function get() {
	      var inner = getPrivate(this);
	      return inner ? {
	        x: inner.offsetX,
	        y: inner.offsetY
	      } : {
	        x: 0,
	        y: 0
	      };
	    }
	  }, {
	    key: "focusTopic",
	    get: function get() {
	      var svg = getPrivate(this).svg;

	      if (svg) {
	        var focusNode = svg.firstDescendant(TopicItem.focusItemSelector);

	        if (focusNode) {
	          focusNode = focusNode.parent(Topic.contentSelector);
	          return focusNode ? new Topic(focusNode) : undefined;
	        }
	      }

	      return undefined;
	    }
	  }], [{
	    key: "checkState",
	    value: function checkState(_this) {
	      var inner = getPrivate(_this);

	      if (inner.svg) {
	        // 如果容器的大小发生变化，则同步修正SVG的视口
	        var curWidth = inner.container.width;
	        var curHeight = inner.container.height;

	        if (curWidth !== inner.containerWidth || curHeight !== inner.containerHeight) {
	          inner.containerWidth = curWidth;
	          inner.containerHeight = curHeight;
	          curWidth /= inner.scaleRate;
	          curHeight /= inner.scaleRate;
	          inner.svg.attr("viewBox", "".concat(inner.offsetX, " ").concat(inner.offsetY, " ").concat(curWidth, " ").concat(curHeight));
	          var event = document.createEvent("UIEvents");
	          event.initUIEvent("resize", false, true, window || global, this);
	          inner.container.dispatchEvent(event);
	        }
	      }
	    }
	  }]);

	  return MindSVG;
	}(); // 注册可扩展类

	registryClass({
	  MindSVG: MindSVG,
	  Topic: Topic,
	  TopicItem: TopicItem,
	  Defs: Defs,
	  DEFAULT_CONFIGS: DEFAULT_CONFIGS
	});
	/**
	 * 导出标准常量
	 */

	var Constants$1 = {
	  ATTACHMENT_LINK_PREFIX: ATTACHMENT_LINK_PREFIX,
	  STAMP_TOPIC_TITLE: STAMP_TOPIC_TITLE,
	  STAMP_FOLD_ICON: STAMP_FOLD_ICON,
	  STAMP_TOPIC_IMAGE: STAMP_TOPIC_IMAGE,
	  STAMP_TOPIC_LABEL_MORE: STAMP_TOPIC_LABEL_MORE,
	  STAMP_TOPIC_LABELS: STAMP_TOPIC_LABELS,
	  STAMP_TOPIC_LINK: STAMP_TOPIC_LINK,
	  STAMP_TOPIC_MARKERS: STAMP_TOPIC_MARKERS,
	  STAMP_TOPIC_NOTES: STAMP_TOPIC_NOTES,
	  CONNECT_DIRECTION_LEFT: CONNECT_DIRECTION_LEFT,
	  CONNECT_DIRECTION_RIGHT: CONNECT_DIRECTION_RIGHT,
	  ID_ICON_MINUS: ID_ICON_MINUS,
	  ID_ICON_PLUS: ID_ICON_PLUS,
	  ID_ICON_MORE: ID_ICON_MORE,
	  ID_ICON_LINK: ID_ICON_LINK,
	  ID_ICON_NOTES: ID_ICON_NOTES
	};

	var _Extend$extendEventHa, _Extend$extendEventHa2;

	function _createForOfIteratorHelper$3(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$3(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$3(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$3(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$3(o, minLen); }

	function _arrayLikeToArray$3(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
	var EVENT = Constants; // 拖拽事件记录变量的符号

	var SYMBOLE_DRAG_EVENT_LOG = Symbol("mind.svg.drag.event.log"); // 拖拽显示盒的风格

	var CLASS_DRAG_BOX = "mind-topic-drag-box"; // 拖拽连接线的风格

	var CLASS_DRAG_LINE = "mind-topic-drag-line"; // 拖拽盒的强制风格

	var STYLE_DRAG_BOX_FORCED = "position: absolute;"; // 查询是否可以被拖拽

	var EVENT_QUERY_DRAGGABLE = "mindevent.query.draggable"; // 通知拖拽已启动

	var EVENT_DRAG_START = "mindevent.drag.start"; // 通知识别到一个待选的拖拽悬停元素

	var EVENT_DRAG_POTENTIAL_HOVER = "mindevent.drag.potential.hover"; // 悬停定时器的超时事件

	var TIMEOUR_HOVER = 900;
	/**
	 * 从对象中获取拖拽事件记录
	 * @param {*} _obj 
	 */

	function dragEventLog(_obj) {
	  return _obj[SYMBOLE_DRAG_EVENT_LOG] || (_obj[SYMBOLE_DRAG_EVENT_LOG] = {});
	}
	/**
	 * 准备一个拖拽盒，并对起进行锚定
	 * @param {*} _mind 
	 * @param {*} _eventLog 
	 * @param {*} _x 仅当此处开始的两个坐标参数有传入时，才会对拖拽盒进行锚定并显示
	 * @param {*} _y 
	 */


	function dragBox(_mind, _eventLog, _x, _y) {
	  // 确保有一个推拽盒
	  var container = _mind.container;
	  var boxNode = container.firstDescendant("div.".concat(CLASS_DRAG_BOX));

	  if (!boxNode) {
	    boxNode = container.createChild("div").attr("class", CLASS_DRAG_BOX);
	  } // 让拖拽盒的主题文本与被推拽的主题一致


	  var topic = _eventLog.dragingTopic;
	  topic && (boxNode.text = topic.topicData("title")); // 锚定拖拽盒的位置

	  if (_x !== undefined && _y !== undefined) {
	    var _container$translateP = container.translatePoint(_x, _y),
	        showX = _container$translateP.x,
	        showY = _container$translateP.y;

	    boxNode.attr("style", "".concat(STYLE_DRAG_BOX_FORCED, " left:").concat(showX + 3, "px; top:").concat(showY - boxNode.height / 2 - container.top, "px;"));
	  }

	  return boxNode;
	}
	/**
	 * 准备拖拽线
	 * @param {*} _mind 
	 * @param {*} _dragBox 
	 * @param {*} _eventLog 
	 */


	function dragLine(_mind, _dragBox, _eventLog) {
	  var svg = _mind.svg;
	  var line = svg.firstDescendant("path.".concat(CLASS_DRAG_LINE)) || svg.createSVGChild("path").attr("class", CLASS_DRAG_LINE);
	  var hoverTopic;

	  if (_eventLog && (hoverTopic = _eventLog.hoverTopic)) {
	    var start = hoverTopic.titleZone;
	    var endOrign = _dragBox.globalRect;

	    var _svg$translatePoint = svg.translatePoint(endOrign.x + endOrign.width / 2, endOrign.y + endOrign.height / 2),
	        endX = _svg$translatePoint.x,
	        endY = _svg$translatePoint.y;

	    line.attr({
	      d: "M".concat(start.x + start.width / 2, " ").concat(start.y + start.height / 2, "L").concat(endX, " ").concat(endY),
	      style: "display: unset;"
	    });
	  }

	  return line;
	}
	/**
	 * 悬停定时器
	 */


	function hoverTimerProc(_topic) {
	  var eventLog = dragEventLog(_topic);
	  eventLog.hoverTimer = undefined;

	  _topic.fireEvent(EVENT_DRAG_POTENTIAL_HOVER, {
	    topic: _topic
	  });
	} // 在Topic类中扩展拖拽的实现


	extendEventHandler("Topic", (_Extend$extendEventHa = {}, _defineProperty(_Extend$extendEventHa, namedHandler("mousedown", Constants$1.STAMP_TOPIC_TITLE), function (_event) {
	  var eventLog = dragEventLog(this);
	  var mouseButton = _event.which || _event.button + 1;

	  if (mouseButton === 1 && this.level > 0) {
	    eventLog.waitDrag = this.fireEvent(EVENT_QUERY_DRAGGABLE, this, true);
	    handledEvent(_event);
	  }
	}), _defineProperty(_Extend$extendEventHa, namedHandler("mousemove", Constants$1.STAMP_TOPIC_TITLE), function (_event) {
	  var eventLog = dragEventLog(this);
	  var mouseButton = _event.which || _event.button + 1;

	  if (mouseButton === 1 && eventLog.waitDrag) {
	    eventLog.waitDrag = undefined;
	    eventLog.hoverTimer && clearTimeout(eventLog.hoverTimer);
	    eventLog.hoverTimer = undefined;
	    this.fireEvent(EVENT_DRAG_START, {
	      topic: this,
	      x: _event.clientX,
	      y: _event.clientY
	    });
	  }

	  continueSiblingHandler(_event);
	}), _defineProperty(_Extend$extendEventHa, namedHandler("mouseover", Constants$1.STAMP_TOPIC_TITLE), function (_event) {
	  var eventLog = dragEventLog(this);
	  var mouseButton = _event.which || _event.button + 1;

	  if (mouseButton === 1) {
	    eventLog.hoverTimer && clearTimeout(eventLog.hoverTimer);
	    eventLog.hoverTimer = setTimeout(hoverTimerProc, TIMEOUR_HOVER, this);
	  }

	  continueSiblingHandler(_event);
	}), _defineProperty(_Extend$extendEventHa, namedHandler("mouseout", Constants$1.STAMP_TOPIC_TITLE), function (_event) {
	  var eventLog = dragEventLog(this);
	  eventLog.waitDrag = undefined;
	  eventLog.hoverTimer && clearTimeout(eventLog.hoverTimer);
	  eventLog.hoverTimer = undefined;
	  continueSiblingHandler(_event);
	}), _defineProperty(_Extend$extendEventHa, namedHandler("mouseup", Constants$1.STAMP_TOPIC_TITLE), function (_event) {
	  var eventLog = dragEventLog(this);
	  eventLog.waitDrag = undefined;
	  eventLog.hoverTimer && clearTimeout(eventLog.hoverTimer);
	  eventLog.hoverTimer = undefined;
	  continueSiblingHandler(_event);
	}), _Extend$extendEventHa)); // 在MindSVG主容器中扩展拖拽的实现

	extendEventHandler("MindSVG", (_Extend$extendEventHa2 = {}, _defineProperty(_Extend$extendEventHa2, namedHandler(EVENT_QUERY_DRAGGABLE), function (_event) {
	  _event.detail.result = this.config("draggable");
	}), _defineProperty(_Extend$extendEventHa2, namedHandler(EVENT_DRAG_START), function (_event) {
	  var eventLog = dragEventLog(this);
	  var value = _event.detail.value;
	  var topic = value.topic;
	  eventLog.dragingTopic = topic;

	  if (topic) {
	    var box = dragBox(this, eventLog, value.x, value.y);
	    eventLog.hoverTopic = topic.parent;
	    dragLine(this, box, eventLog);
	    topic.visible = false;
	  }

	  handledEvent(_event);
	}), _defineProperty(_Extend$extendEventHa2, namedHandler(EVENT_DRAG_POTENTIAL_HOVER), function (_event) {
	  var eventLog = dragEventLog(this);
	  var potentialTopic = _event.detail.value.topic;

	  if (eventLog.dragingTopic) {
	    eventLog.hoverTopic = potentialTopic;
	    var box = dragBox(this, eventLog);
	    dragLine(this, box, eventLog);
	  }

	  handledEvent(_event);
	}), _defineProperty(_Extend$extendEventHa2, namedHandler("mousemove"), function (_event) {
	  var eventLog = dragEventLog(this);
	  var button = _event.which || _event.button + 1;

	  if (button === 1 && eventLog.dragingTopic) {
	    var box = dragBox(this, eventLog, _event.clientX, _event.clientY);
	    dragLine(this, box, eventLog);
	    handledEvent(_event);
	  }
	}), _defineProperty(_Extend$extendEventHa2, namedHandler("mouseup"), function (_event) {
	  var eventLog = dragEventLog(this);
	  var button = _event.which || _event.button + 1;

	  if (button === 1 && eventLog.dragingTopic) {
	    // 隐藏拖拽盒与拖拽线
	    var box = dragBox(this, eventLog);
	    box.attr("style", "display: none;");
	    dragLine(this, box).attr("style", "display:none;"); // 发送推拽确认事件，可用于应用层历史记录或者应用层阻止对某个拖拽的生效

	    var dragingTopic = eventLog.dragingTopic;
	    var newParent = eventLog.hoverTopic;
	    var originParent = dragingTopic.parent;
	    var originSibling = dragingTopic.previousSibling;
	    var originDirection = originParent.level === 0 ? dragingTopic.direction() : null;
	    var canDrop = this.fireEvent(EVENT.EVENT_CONFIRM_DRAG, {
	      dragingTopic: dragingTopic,
	      originParent: originParent,
	      newParent: newParent
	    }, true);
	    var endEventData = undefined;

	    if (newParent && canDrop) {
	      // 计算拖拽后的主题的布局方向
	      var ptY = _event.clientY;
	      var isLeft = false;
	      var newDirection;

	      if (newParent.level === 0) {
	        if (_event.clientX < newParent.itemZone.x) {
	          newDirection = Constants$1.CONNECT_DIRECTION_LEFT;
	          isLeft = true;
	        } else {
	          newDirection = Constants$1.CONNECT_DIRECTION_RIGHT;
	        }
	      } else {
	        newDirection = null;
	      }

	      dragingTopic.direction(newDirection); // 计算拖拽后主题的临近兄弟主题

	      var prevSibling = undefined;

	      var _iterator = _createForOfIteratorHelper$3(newParent.childrenTopics()),
	          _step;

	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var sibling = _step.value;

	          if (!dragingTopic.isSame(sibling) && (!isLeft || sibling.direction() === Constants$1.CONNECT_DIRECTION_LEFT)) {
	            var rect = sibling.itemZone;

	            if (ptY < rect.y) {
	              break;
	            } else {
	              prevSibling = sibling;
	            }
	          }
	        } // 完成拖放

	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }

	      prevSibling ? eventLog.dragingTopic.insertNextTo(prevSibling, false) : eventLog.dragingTopic.insertTo(newParent, true, false);
	      endEventData = {
	        dragingTopic: dragingTopic,
	        originParent: originParent,
	        originSibling: originSibling,
	        originDirection: originDirection,
	        newParent: newParent,
	        newSibling: prevSibling,
	        newDirection: newDirection
	      };
	    }

	    dragingTopic.focus(true);
	    eventLog.dragingTopic.visible = true;
	    eventLog.dragingTopic = undefined;
	    handledEvent(_event);
	    this.fireEvent(EVENT.EVENT_END_DRAG, endEventData);
	  }
	}), _Extend$extendEventHa2)); // 扩展配置项

	extend("DEFAULT_CONFIGS", {
	  draggable: false
	}); // 导出

	var taskMap = ["start", "oct", "quarter", "3oct", "half", "5oct", "3quar", "7oct", "done", "unknown"];
	extend("Defs", {
	  $std$defs$declare: function $std$defs$declare(obj) {
	    if (obj.defs) {
	      obj.defs.node.insertAdjacentHTML('beforeend', "\n                <path id=\"".concat(Constants$1.ID_ICON_PLUS, "\" fill=\"#fff\" fill-opacity=\"0.8\" stroke=\"#000\" stroke-width=\"1\" \n                    transform=\"translate(-6, -4), scale(1.25, 1.25)\" \n                    d=\"M1 4A3 3 0 1 0 8 4A3 3 0 1 0 1 4M2.5 4L6.5 4M4.5 2L4.5 6\" />\n                <path id=\"").concat(Constants$1.ID_ICON_MINUS, "\" fill=\"#fff\" fill-opacity=\"0.8\" stroke=\"#000\" stroke-width=\"1\" \n                    transform=\"translate(-6, -4), scale(1.25, 1.25)\" \n                    d=\"M1 4A3 3 0 1 0 8 4A3 3 0 1 0 1 4M2.5 4L6.5 4\" />\n                <path id=\"").concat(Constants$1.ID_ICON_MORE, "\" fill=\"#fff\" fill-opacity=\"0.8\" stroke=\"#000\" stroke-width=\"1\" stroke-opacity=\"0.6\"\n                    d=\"M4 1H7Q10 1 10 4V7Q10 10 7 10H4Q1 10 1 7V4 Q1 1 4 1M4 3L7 5.5L4 8\" />\n                <path id=\"").concat(Constants$1.ID_ICON_NOTES, "\" fill=\"#ffd\" fill-opacity=\"0.8\" stroke=\"#000\" stroke-width=\"1\" stroke-opacity=\"0.6\"\n                    d=\"M3 1H13L18 6V20H3V1M13 1V6H18M6 4H10M6 7H10M6 10H15M6 13H15M6 16H13\" />\n                <g id=\"").concat(Constants$1.ID_ICON_LINK, "\">\n                    <rect width=\"20\" height=\"20\" rx=\"3\" ry=\"3\" fill=\"#eee\" fill-opacity=\"0.3\" stroke-width=\"0\" />\n                    <path fill=\"none\" fill-opacity=\"0.8\" stroke=\"#000\" stroke-width=\"1.5\" stroke-opacity=\"0.6\"\n                          d=\"M9 7L11 5A2 2 0 0 1 15 9L13 11M7 9L5 11A2 2 0 0 0 9 15L11 13M7 13L13 7\" />\n                </g>\n                <path id=\"priority-1\" fill=\"#f00\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M8 7L10.5 6V16\" />\n                <path id=\"priority-2\" fill=\"#f00\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M7 8C10.5 1 20 8 7 14M6 14H16\" />\n                <path id=\"priority-3\" fill=\"#f0f\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M7 7C10.5 1 20 8 10 10C21 10 10.5 21 6 12\" />\n                <path id=\"priority-4\" fill=\"#f0f\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M12 4Q10 10 6 13M5 13H15M13 8L11 16\" />\n                <path id=\"priority-5\" fill=\"#06f\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M9 4Q9 7 8 9M7 9C18 5 16 20 6 14M9 5H14\" />\n                <path id=\"priority-6\" fill=\"#06f\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M7 9C13 7 16 13 10 15C4 15 4 9 13 4\" />\n                <path id=\"priority-7\" fill=\"#093\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M7 8V6Q11 7 13 6.5Q10 12 9 16\" />\n                <path id=\"priority-8\" fill=\"#093\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M10 9C6 8 7 3 12 4C15 5 15 10 10 9C16 10 16 16.5 10 16C4 15 4 9 10 9\" />\n                <path id=\"priority-9\" fill=\"#993\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M15 10C6 16 5 3.5 12 4.5C18 6 16 17 7 16\" />\n                <path id=\"task-0\" fill=\"#fff\" fill-opacity=\"0.8\" stroke=\"#093\" stroke-width=\"1\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M8 14V5L15 10L8 15V6\" />\n                <g id=\"task-1\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 1 0 16.5 4.5L10.5 10.5\" />\n                </g>\n                <g id=\"task-2\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 1 0 19 10.5L10.5 10.5\" />\n                </g>\n                <g id=\"task-3\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 1 0 16.5 16.5L10.5 10.5\" />\n                </g>\n                <g id=\"task-4\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 0 0 10.5 19L10.5 10.5\" />\n                </g>\n                <g id=\"task-5\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 0 0 4.5 16.5L10.5 10.5\" />\n                </g>\n                <g id=\"task-6\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 0 0 2 10.5L10.5 10.5\" />\n                </g>\n                <g id=\"task-7\">\n                    <circle cx=\"10.5\" cy=\"10.5\" r=\"10\" stroke=\"none\" fill=\"#093\" fill-opacity=\"0.8\" />\n                    <path stroke=\"none\" fill=\"#fff\" fill-opacity=\"0.8\" d=\"M10.5 10.5V2A8.5 8.5 180 0 0 4.5 4.5L10.5 10.5\" />\n                </g>\n                <path id=\"task-8\" fill=\"#093\" fill-opacity=\"0.8\" stroke=\"#fff\" stroke-width=\"2\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M15 6L10 13L6 9\" />\n                <path id=\"task-9\" fill=\"#fff\" fill-opacity=\"0.8\" stroke=\"#093\" stroke-width=\"1\" stroke-opacity=\"0.8\"\n                    d=\"M1 10A9 9 0 1 1 20 10A9 9 0 1 1 1 10M7 8A3.5 3.5 0 1 1 10.5 10.5V13M10.5 14V16M9.5 15H11.5\" />\n                "));
	    }
	  },
	  priority$translate: function priority$translate(_value) {
	    _value = parseInt(_value);
	    _value = isNaN(_value) || _value < 1 ? 1 : _value > 9 ? 9 : _value;
	    return _value;
	  },
	  task$translate: function task$translate(_value, _toDefs) {
	    if (_toDefs) {
	      var ret = taskMap.indexOf(_value);
	      return ret >= 0 ? ret : 9;
	    } else {
	      var _ret = parseInt(_value);

	      return _ret >= 0 && _ret <= 9 ? taskMap[_ret] : taskMap[9];
	    }
	  }
	});

	var SYMBOL_URL = Symbol("mind.attachment.url");
	var SYMBOL_DATA = Symbol("mind.attachment.data");
	var SYMBOL_LIST = Symbol("mind.attachment.list");
	/**
	 * 附件项类
	 */

	var Attachment = /*#__PURE__*/function () {
	  function Attachment(_data) {
	    _classCallCheck(this, Attachment);

	    this[SYMBOL_DATA] = _data;
	    this[SYMBOL_URL] = _data instanceof Blob ? URL.createObjectURL(_data) : undefined;
	  }
	  /**
	   * 释放资源
	   */


	  _createClass(Attachment, [{
	    key: "release",
	    value: function release() {
	      if (this[SYMBOL_URL]) {
	        URL.revokeObjectURL(this[SYMBOL_URL]);
	        this[SYMBOL_URL] = undefined;
	      }
	    }
	    /**
	     * 获取数据体
	     */

	  }, {
	    key: "toString",

	    /**
	     * 获取字符串表示
	     */
	    value: function toString() {
	      return this[SYMBOL_DATA] instanceof Blob ? this[SYMBOL_URL] : String(this[SYMBOL_DATA]);
	    }
	  }, {
	    key: "data",
	    get: function get() {
	      return this[SYMBOL_DATA];
	    }
	  }]);

	  return Attachment;
	}();
	/**
	 * 附件集合类
	 */


	var AttachmentCollection = /*#__PURE__*/function () {
	  function AttachmentCollection() {
	    _classCallCheck(this, AttachmentCollection);

	    this[SYMBOL_LIST] = {};
	  }
	  /**
	   * 添加、删除、查询附件项
	   * @param {*} _name 附件名称，如果给出空的附件名称，则系统会随机生成一个
	   * @param {*} _data 附件的数据，如果传入null表示删除对应附件，如果不传入该参数表示查询附件
	   * @returns 查询附件时返回附件对象，删除附件时返回当前附件集合实例，添加附件时返回{name,value}组成的新附件标识
	   */


	  _createClass(AttachmentCollection, [{
	    key: "item",
	    value: function item(_name, _data) {
	      if (_data === undefined) {
	        return this[SYMBOL_LIST][_name];
	      } else if (_data === null) {
	        var old = this[SYMBOL_LIST][_name];
	        old && old.release();
	        delete this[SYMBOL_LIST][_name];
	        return this;
	      } else {
	        _name || (_name = "".concat(Date.now().toString(16), "-").concat(Math.random().toString(16).substr(2, 3)));
	        var _old = this[SYMBOL_LIST][_name];
	        _old && _old.release();
	        this[SYMBOL_LIST][_name] = new Attachment(_data);
	        return {
	          name: _name,
	          value: this[SYMBOL_LIST][_name]
	        };
	      }
	    }
	    /**
	     * 获取附件迭代器
	     */

	  }, {
	    key: "items",
	    value: /*#__PURE__*/regenerator.mark(function items() {
	      var list, name;
	      return regenerator.wrap(function items$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              list = this[SYMBOL_LIST];
	              _context.t0 = regenerator.keys(list);

	            case 2:
	              if ((_context.t1 = _context.t0()).done) {
	                _context.next = 8;
	                break;
	              }

	              name = _context.t1.value;
	              _context.next = 6;
	              return {
	                name: name,
	                value: list[name]
	              };

	            case 6:
	              _context.next = 2;
	              break;

	            case 8:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, items, this);
	    })
	    /**
	     * 清空所有附件
	     */

	  }, {
	    key: "clear",
	    value: function clear() {
	      var list = this[SYMBOL_LIST];

	      for (var name in list) {
	        list[name].release();
	      }

	      this[SYMBOL_LIST] = {};
	    }
	  }]);

	  return AttachmentCollection;
	}();

	var EVENT$1 = Constants;
	var Event = $Event;
	var Extend = $Extend;

	exports.AttachmentCollection = AttachmentCollection;
	exports.Constants = Constants$1;
	exports.ENode = ENode;
	exports.ENodeClass = ENodeClass;
	exports.ERROR = ERROR;
	exports.EVENT = EVENT$1;
	exports.Event = Event;
	exports.Extend = Extend;
	exports.MindSVG = MindSVG;
	exports.NS = NS;
	exports.SVG = SVG;
	exports.isENode = isENode;
	exports.isNode = isNode;
	exports.unused = unused;

	return exports;

}({}));
//# sourceMappingURL=mind.svg.iife.js.map
