import * as React from 'react';
import { DefaultRootState, StoreProp, GetProps, Matching, ConnectedComponent } from './types';
export interface ConnectOptions {
    /**
     * If true, use React's forwardRef to expose a ref of the wrapped component
     *
     * @default false
     */
    forwardRef?: boolean;
}
/**
* Infers the type of props that a connector will inject into a component.
*/
export interface ConnectProps {
    miniStoreForwardedRef: React.Ref<any>;
}
export interface ConnectedState<TStateProps = {}, Store = {}, TOwnProps = {}> {
    subscribed: TStateProps;
    store: Store;
    props: TOwnProps;
}
export declare function connect<TStateProps = {}, TOwnProps = {}, State = DefaultRootState>(mapStateToProps?: (state: State, ownProps: TOwnProps) => TStateProps, options?: ConnectOptions): <C extends React.ComponentType<Matching<TStateProps & StoreProp<State>, GetProps<C>>>>(WrappedComponent: C) => ConnectedComponent<C, TStateProps & StoreProp<State>, TOwnProps>;
