

# MISSING.CSS<br> The Missing CSS Stylesheet

[Docs](https://missing.style/docs/) ·
[Demo](https://missing.style/demos/) ·
[Playground](https://missing.style/playground/) ·
[Releases](https://missing.style/releases/) ·
[GitHub](https://github.com/bigskysoftware/missing) ·
[Discord](https://htmx.org/discord)

missing.css is the missing CSS library that we all wished existed. Add it to your website:

```html
<link rel="stylesheet" href="https://the.missing.style">
```

 * It starts with decent default styling for vanilla HTML, akin to **classless
   CSS** libraries.
 * It offers a small set of **components** based on well-known, semantic markup
   patterns, with ARIA where appropriate.
 * Finally, it offers a small & curated set of **utility classes** and **custom
   elements** for bespoke elements and layouts.

The goal of missing.css is to reduce needed intervention in HTML. It lets
authors

 - start with a good out-of-the-box experience,
 - customize it easily, even create multiple themes,
 - build common components using plain, semantic HTML,
 - create unique sites by applying utility classes as needed.

missing.css is not designed to be a complete styling solution for large
websites. It may serve as a basis for a more completely styled site, but does
not try to be as complete as Bootstrap or as versatile as Tailwind.
It is, however, explicitly designed to be complete enough to use for small sites, internal tools or
personal projects.

--------

[Missing.css](https://missing.style), from Big Sky Software.

Also check out [htmx](https://htmx.org) and [_hyperscript](https://hyperscript.org).
