import * as m from 'mithril';
import { ITransitionAttrs } from './Transition';
export interface ICSSTransitionAttrs extends ITransitionAttrs {
    /** CSS class base to use for enter/exit transitions */
    transitionClass?: string;
}
export declare type transitionType = 'enter' | 'exit';
export declare class CSSTransition implements m.ClassComponent<ICSSTransitionAttrs> {
    view({ attrs }: m.CVnode<ICSSTransitionAttrs>): m.Vnode<ITransitionAttrs, {}>;
    private onEnter;
    private onEntering;
    private onEntered;
    private onExit;
    private onExiting;
    private onExited;
    private removeClasses;
}
