"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var m = require("mithril");
var elClass = require("element-class");
var Transition_1 = require("./Transition");
var utils_1 = require("./utils");
var CSSTransition = /** @class */ (function () {
    function CSSTransition() {
        var _this = this;
        this.onEnter = function (node, attrs) {
            _this.removeClasses(node, attrs, 'exit');
            elClass(node).add(attrs.transitionClass + "-enter");
            utils_1.safeCall(attrs.onEnter, node);
        };
        this.onEntering = function (node, attrs) {
            _this.removeClasses(node, attrs, 'exit');
            elClass(node).add(attrs.transitionClass + "-enter-active");
            // tslint:disable-next-line:no-unused-expression
            node.scrollTop;
            utils_1.safeCall(attrs.onEntering, node);
        };
        this.onEntered = function (node, attrs) {
            _this.removeClasses(node, attrs, 'enter');
            utils_1.safeCall(attrs.onEntered, node);
        };
        this.onExit = function (node, attrs) {
            _this.removeClasses(node, attrs, 'enter');
            elClass(node).add(attrs.transitionClass + "-exit");
            utils_1.safeCall(attrs.onExit, node);
        };
        this.onExiting = function (node, attrs) {
            _this.removeClasses(node, attrs, 'enter');
            elClass(node).add(attrs.transitionClass + "-exit-active");
            // tslint:disable-next-line:no-unused-expression
            node.scrollTop;
            utils_1.safeCall(attrs.onExiting, node);
        };
        this.onExited = function (node, attrs) {
            _this.removeClasses(node, attrs, 'exit');
            utils_1.safeCall(attrs.onExited, node);
        };
    }
    CSSTransition.prototype.view = function (_a) {
        var _this = this;
        var attrs = _a.attrs;
        return m(Transition_1.Transition, __assign({}, attrs, { onEnter: function (node) { return _this.onEnter(node, attrs); }, onEntering: function (node) { return _this.onEntering(node, attrs); }, onEntered: function (node) { return _this.onEntered(node, attrs); }, onExit: function (node) { return _this.onExit(node, attrs); }, onExiting: function (node) { return _this.onExiting(node, attrs); }, onExited: function (node) { return _this.onExited(node, attrs); } }));
    };
    CSSTransition.prototype.removeClasses = function (node, attrs, type) {
        elClass(node).remove(attrs.transitionClass + "-" + type);
        elClass(node).remove(attrs.transitionClass + "-" + type + "-active");
    };
    return CSSTransition;
}());
exports.CSSTransition = CSSTransition;
