import * as m from 'mithril';
export interface ITimeout {
    enter: number;
    exit: number;
}
export interface ITransitionAttrs {
    /** Displays the content; triggers onEnter/onExit callbacks */
    isVisible?: boolean;
    /** Content to be transitioned */
    content?: m.Children | ((state: TransitionState) => m.Children);
    /** Invoked on initial component enter */
    onEnter?: (node: HTMLElement) => void;
    /** Invoked when component is entering */
    onEntering?: (node: HTMLElement) => void;
    /** Invoked when component has entered */
    onEntered?: (node: HTMLElement) => void;
    /** Invoked on initial component exit */
    onExit?: (node: HTMLElement) => void;
    /** Invoked when component is exiting */
    onExiting?: (node: HTMLElement) => void;
    /** Invoked on when component has exited */
    onExited?: (node: HTMLElement) => void;
    /** Timeouts for enter/exit transition */
    timeout: number | ITimeout;
}
export declare enum TransitionState {
    UNMOUNTED = "unmounted",
    EXITED = "exited",
    ENTERING = "entering",
    ENTERED = "entered",
    EXITING = "exiting"
}
export declare class Transition implements m.ClassComponent<ITransitionAttrs> {
    private status;
    private nextStatus;
    private node;
    private timeoutStack;
    oninit({ attrs }: m.CVnode<ITransitionAttrs>): void;
    oncreate({ attrs, dom }: m.CVnodeDOM<ITransitionAttrs>): void;
    onupdate({ attrs, dom }: m.CVnodeDOM<ITransitionAttrs>): void;
    onbeforeupdate(vnode: m.CVnode<ITransitionAttrs>, old: m.CVnode<ITransitionAttrs>): void;
    onbeforeremove(): void;
    view({ attrs }: m.CVnode<ITransitionAttrs>): m.Children;
    private getTimeouts;
    private updateStatus;
    private performEnter;
    private performExit;
    private performUnmount;
    private setTimeout;
    private clearTimeouts;
}
