# mithril-transition
[![Build Status](https://travis-ci.org/geut/mithril-transition.svg?branch=master)](https://travis-ci.org/geut/mithril-transition)
> A lightweight library for MithrilJS to create your own custom transitions based on the lifecycle of your components.

## Install

With [npm](https://npmjs.com/package/mithril-transition) and [browserify](https://www.npmjs.com/package/browserify)/[webpack](https://www.npmjs.com/package/webpack) do:

```
npm install --save mithril-transition
```

Or you can use the UMD bundle

```html
<script src="/lib/mithril-transition/dist/mithril-transition.umd.js" type="text/javascript"></script>
```

## How to use it

**mithril-transition** is a function factory that return a ```config``` function for your v-node (where you want animate it) of mithril.

Live examples:

- [with VelocityJS](https://t.co/1psrMMUqkT)

- [with pure CSS](https://jsfiddle.net/tinchoz49/ckounhoz)

## Functions

#### transition(options = {}) -> {animate}
Factory function to create a new transition. The options are defined below.

#### animate.enable()
Method to start the animation. **By default is enabled.**

#### animate.disable()
Method to disable the animation.

## Options

#### anim (required)
Callback function where you define the animation for the next/prev component.

The callback has the next parameters:

**lastElem**: The last DOM element that is removing.

**newElem**: The new DOM element that is inserting.

**direction**: This option allow to you define differents animations based of next/prev direction of the lifecycle components. Is required have at least ```useHistory``` in true.

**cbLast**: Callback to complete the remove of the lastElem. (is required call it)

**cbNew**: Callback to complete the insert of the newElem. (is required call it)

**dataState**: It will give you a state of special DOM properties (height, width) from the parent, lastElem and newElem

#### useHistory (default = true)
When is enabled the library keep the history of your components, to know if the next element in the transition is really the next element or a prev element.

#### persistHistoryAs ({string} default = null)
Save the history in the sessionStorage identified by a key.

#### classList ({object})
Before that the transition begin, the library set a list of classes for each parent|element and remove it when the transition is finished.
```javascript
default = {
    parent: 'm-transition-parent',
    lastElem: 'm-transition-last-element',
    newElem: 'm-transition-new-element',
    direction: 'm-transition-<direction>'
}
```

## On roadmap

- Add tests

## Credits

* Thanks to @dpaez to work with me the last year in a mobile project using [Mithril](http://mithril.js.org/) and exploring how to make transitions and animations with this excellent "MVC" framework.

## License

MIT
