'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

var _conditionalTag = require('mjml-core/lib/helpers/conditionalTag');

var _conditionalTag2 = _interopRequireDefault(_conditionalTag);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjAccordionTitle = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjAccordionTitle, _BodyComponent);

  function MjAccordionTitle() {
    (0, _classCallCheck3.default)(this, MjAccordionTitle);
    return (0, _possibleConstructorReturn3.default)(this, (MjAccordionTitle.__proto__ || (0, _getPrototypeOf2.default)(MjAccordionTitle)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjAccordionTitle, [{
    key: 'getStyles',
    value: function getStyles() {
      return {
        td: {
          width: '100%',
          'background-color': this.getAttribute('background-color'),
          color: this.getAttribute('color'),
          'font-size': this.getAttribute('font-size'),
          'font-family': this.getAttribute('font-family'),
          'padding-bottom': this.getAttribute('padding-bottom'),
          'padding-left': this.getAttribute('padding-left'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-top': this.getAttribute('padding-top'),
          padding: this.getAttribute('padding')
        },
        table: {
          width: '100%',
          'border-bottom': this.getAttribute('border')
        },
        td2: {
          padding: '16px',
          background: this.getAttribute('background-color'),
          'vertical-align': this.getAttribute('icon-align')
        },
        img: {
          display: 'none',
          width: this.getAttribute('icon-width'),
          height: this.getAttribute('icon-height')
        }
      };
    }
  }, {
    key: 'renderTitle',
    value: function renderTitle() {
      return '\n      <td\n        ' + this.htmlAttributes({
        class: this.getAttribute('css-class'),
        style: 'td'
      }) + '\n      >\n        ' + this.getContent() + '\n      </td>\n    ';
    }
  }, {
    key: 'renderIcons',
    value: function renderIcons() {
      return (0, _conditionalTag2.default)('\n      <td\n        ' + this.htmlAttributes({
        class: 'mj-accordion-ico',
        style: 'td2'
      }) + '\n      >\n        <img\n          ' + this.htmlAttributes({
        src: this.getAttribute('icon-wrapped-url'),
        alt: this.getAttribute('icon-wrapped-alt'),
        class: 'mj-accordion-more',
        style: 'img'
      }) + '\n        />\n        <img\n          ' + this.htmlAttributes({
        src: this.getAttribute('icon-unwrapped-url'),
        alt: this.getAttribute('icon-unwrapped-alt'),
        class: 'mj-accordion-less',
        style: 'img'
      }) + '\n        />\n      </td>\n    ', true);
    }
  }, {
    key: 'render',
    value: function render() {
      var contentElements = [this.renderTitle(), this.renderIcons()];
      var content = (this.getAttribute('icon-position') === 'right' ? contentElements : contentElements.reverse()).join('\n');

      return '\n      <div ' + this.htmlAttributes({ class: 'mj-accordion-title' }) + '>\n        <table\n          ' + this.htmlAttributes({
        'cell-spacing': '0',
        'cell-padding': '0',
        style: 'table'
      }) + '\n        >\n          <tbody>\n            <tr>\n              ' + content + '\n            </tr>\n          </tbody>\n        </table>\n      </div>\n    ';
    }
  }]);
  return MjAccordionTitle;
}(_mjmlCore.BodyComponent), _class.endingTag = true, _class.allowedAttributes = {
  'background-color': 'color',
  color: 'color',
  'font-size': 'unit(px)',
  'font-family': 'string',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}'
}, _class.defaultAttributes = {
  'font-size': '13px',
  padding: '16px'
}, _temp);
exports.default = MjAccordionTitle;
module.exports = exports['default'];