'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = require('babel-runtime/helpers/extends');

var _extends4 = _interopRequireDefault(_extends3);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

var _lodash = require('lodash');

var _conditionalTag = require('mjml-core/lib/helpers/conditionalTag');

var _conditionalTag2 = _interopRequireDefault(_conditionalTag);

var _AccordionText = require('./AccordionText');

var _AccordionText2 = _interopRequireDefault(_AccordionText);

var _AccordionTitle = require('./AccordionTitle');

var _AccordionTitle2 = _interopRequireDefault(_AccordionTitle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjAccordionElement = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjAccordionElement, _BodyComponent);

  function MjAccordionElement() {
    (0, _classCallCheck3.default)(this, MjAccordionElement);
    return (0, _possibleConstructorReturn3.default)(this, (MjAccordionElement.__proto__ || (0, _getPrototypeOf2.default)(MjAccordionElement)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjAccordionElement, [{
    key: 'getStyles',
    value: function getStyles() {
      return {
        td: {
          padding: '0px',
          'background-color': this.getAttribute('background-color')
        },
        label: {
          'font-size': '13px',
          'font-family': this.getAttribute('font-family')
        },
        input: {
          display: 'none'
        }
      };
    }
  }, {
    key: 'handleMissingChildren',
    value: function handleMissingChildren() {
      var _this2 = this;

      var children = this.props.children;

      var childrenAttr = ['border', 'icon-align', 'icon-width', 'icon-height', 'icon-position', 'icon-wrapped-url', 'icon-wrapped-alt', 'icon-unwrapped-url', 'icon-unwrapped-alt'].reduce(function (res, val) {
        return (0, _extends4.default)({}, res, (0, _defineProperty3.default)({}, val, _this2.getAttribute(val)));
      }, {});

      var result = [];

      if (!(0, _lodash.find)(children, { tagName: 'mj-accordion-title' })) {
        result.push(new _AccordionTitle2.default({
          attributes: childrenAttr,
          context: this.getChildContext()
        }).render());
      }

      result.push(this.renderChildren(children, { attributes: childrenAttr }));

      if (!(0, _lodash.find)(children, { tagName: 'mj-accordion-text' })) {
        result.push(new _AccordionText2.default({
          attributes: childrenAttr,
          context: this.getChildContext()
        }).render());
      }

      return result.join('\n');
    }
  }, {
    key: 'render',
    value: function render() {
      return '\n      <tr\n        ' + this.htmlAttributes({
        class: this.getAttribute('css-class')
      }) + '\n      >\n        <td ' + this.htmlAttributes({ style: 'td' }) + '>\n          <label\n            ' + this.htmlAttributes({
        class: 'mj-accordion-element',
        style: 'label'
      }) + '\n          >\n            ' + (0, _conditionalTag2.default)('\n              <input\n                ' + this.htmlAttributes({
        class: 'mj-accordion-checkbox',
        type: 'checkbox',
        style: 'input'
      }) + '\n              />\n            ', true) + '\n            <div>\n              ' + this.handleMissingChildren() + '\n            </div>\n          </label>\n        </td>\n      </tr>\n    ';
    }
  }]);
  return MjAccordionElement;
}(_mjmlCore.BodyComponent), _class.allowedAttributes = {
  'background-color': 'color',
  'font-family': 'string',
  'icon-align': 'enum(top,middle,bottom)',
  'icon-width': 'unit(px,%)',
  'icon-height': 'unit(px,%)',
  'icon-wrapped-url': 'string',
  'icon-wrapped-alt': 'string',
  'icon-unwrapped-url': 'string',
  'icon-unwrapped-alt': 'string',
  'icon-position': 'enum(left,right)'
}, _class.defaultAttributes = {
  title: {
    img: {
      width: '32px',
      height: '32px'
    }
  }
}, _temp);
exports.default = MjAccordionElement;
module.exports = exports['default'];