"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectSpread3 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _lodash = require("lodash");

var _conditionalTag = _interopRequireDefault(require("mjml-core/lib/helpers/conditionalTag"));

var _AccordionText = _interopRequireDefault(require("./AccordionText"));

var _AccordionTitle = _interopRequireDefault(require("./AccordionTitle"));

var MjAccordionElement = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjAccordionElement, _BodyComponent);

  function MjAccordionElement() {
    (0, _classCallCheck2["default"])(this, MjAccordionElement);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjAccordionElement).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjAccordionElement, [{
    key: "getStyles",
    value: function getStyles() {
      return {
        td: {
          padding: '0px',
          'background-color': this.getAttribute('background-color')
        },
        label: {
          'font-size': '13px',
          'font-family': this.getAttribute('font-family')
        },
        input: {
          display: 'none'
        }
      };
    }
  }, {
    key: "handleMissingChildren",
    value: function handleMissingChildren() {
      var _this = this;

      var children = this.props.children;
      var childrenAttr = ['border', 'icon-align', 'icon-width', 'icon-height', 'icon-position', 'icon-wrapped-url', 'icon-wrapped-alt', 'icon-unwrapped-url', 'icon-unwrapped-alt'].reduce(function (res, val) {
        return (0, _objectSpread3["default"])({}, res, (0, _defineProperty2["default"])({}, val, _this.getAttribute(val)));
      }, {});
      var result = [];

      if (!(0, _lodash.find)(children, {
        tagName: 'mj-accordion-title'
      })) {
        result.push(new _AccordionTitle["default"]({
          attributes: childrenAttr,
          context: this.getChildContext()
        }).render());
      }

      result.push(this.renderChildren(children, {
        attributes: childrenAttr
      }));

      if (!(0, _lodash.find)(children, {
        tagName: 'mj-accordion-text'
      })) {
        result.push(new _AccordionText["default"]({
          attributes: childrenAttr,
          context: this.getChildContext()
        }).render());
      }

      return result.join('\n');
    }
  }, {
    key: "render",
    value: function render() {
      return "\n      <tr\n        ".concat(this.htmlAttributes({
        "class": this.getAttribute('css-class')
      }), "\n      >\n        <td ").concat(this.htmlAttributes({
        style: 'td'
      }), ">\n          <label\n            ").concat(this.htmlAttributes({
        "class": 'mj-accordion-element',
        style: 'label'
      }), "\n          >\n            ").concat((0, _conditionalTag["default"])("\n              <input\n                ".concat(this.htmlAttributes({
        "class": 'mj-accordion-checkbox',
        type: 'checkbox',
        style: 'input'
      }), "\n              />\n            "), true), "\n            <div>\n              ").concat(this.handleMissingChildren(), "\n            </div>\n          </label>\n        </td>\n      </tr>\n    ");
    }
  }]);
  return MjAccordionElement;
}(_mjmlCore.BodyComponent);

exports["default"] = MjAccordionElement;
(0, _defineProperty2["default"])(MjAccordionElement, "allowedAttributes", {
  'background-color': 'color',
  'font-family': 'string',
  'icon-align': 'enum(top,middle,bottom)',
  'icon-width': 'unit(px,%)',
  'icon-height': 'unit(px,%)',
  'icon-wrapped-url': 'string',
  'icon-wrapped-alt': 'string',
  'icon-unwrapped-url': 'string',
  'icon-unwrapped-alt': 'string',
  'icon-position': 'enum(left,right)'
});
(0, _defineProperty2["default"])(MjAccordionElement, "defaultAttributes", {
  title: {
    img: {
      width: '32px',
      height: '32px'
    }
  }
});
module.exports = exports.default;