"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _conditionalTag = _interopRequireDefault(require("mjml-core/lib/helpers/conditionalTag"));

var MjAccordionTitle = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjAccordionTitle, _BodyComponent);

  function MjAccordionTitle() {
    (0, _classCallCheck2["default"])(this, MjAccordionTitle);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjAccordionTitle).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjAccordionTitle, [{
    key: "getStyles",
    value: function getStyles() {
      return {
        td: {
          width: '100%',
          'background-color': this.getAttribute('background-color'),
          color: this.getAttribute('color'),
          'font-size': this.getAttribute('font-size'),
          'font-family': this.getAttribute('font-family'),
          'padding-bottom': this.getAttribute('padding-bottom'),
          'padding-left': this.getAttribute('padding-left'),
          'padding-right': this.getAttribute('padding-right'),
          'padding-top': this.getAttribute('padding-top'),
          padding: this.getAttribute('padding')
        },
        table: {
          width: '100%',
          'border-bottom': this.getAttribute('border')
        },
        td2: {
          padding: '16px',
          background: this.getAttribute('background-color'),
          'vertical-align': this.getAttribute('icon-align')
        },
        img: {
          display: 'none',
          width: this.getAttribute('icon-width'),
          height: this.getAttribute('icon-height')
        }
      };
    }
  }, {
    key: "renderTitle",
    value: function renderTitle() {
      return "\n      <td\n        ".concat(this.htmlAttributes({
        "class": this.getAttribute('css-class'),
        style: 'td'
      }), "\n      >\n        ").concat(this.getContent(), "\n      </td>\n    ");
    }
  }, {
    key: "renderIcons",
    value: function renderIcons() {
      return (0, _conditionalTag["default"])("\n      <td\n        ".concat(this.htmlAttributes({
        "class": 'mj-accordion-ico',
        style: 'td2'
      }), "\n      >\n        <img\n          ").concat(this.htmlAttributes({
        src: this.getAttribute('icon-wrapped-url'),
        alt: this.getAttribute('icon-wrapped-alt'),
        "class": 'mj-accordion-more',
        style: 'img'
      }), "\n        />\n        <img\n          ").concat(this.htmlAttributes({
        src: this.getAttribute('icon-unwrapped-url'),
        alt: this.getAttribute('icon-unwrapped-alt'),
        "class": 'mj-accordion-less',
        style: 'img'
      }), "\n        />\n      </td>\n    "), true);
    }
  }, {
    key: "render",
    value: function render() {
      var contentElements = [this.renderTitle(), this.renderIcons()];
      var content = (this.getAttribute('icon-position') === 'right' ? contentElements : contentElements.reverse()).join('\n');
      return "\n      <div ".concat(this.htmlAttributes({
        "class": 'mj-accordion-title'
      }), ">\n        <table\n          ").concat(this.htmlAttributes({
        'cell-spacing': '0',
        'cell-padding': '0',
        style: 'table'
      }), "\n        >\n          <tbody>\n            <tr>\n              ").concat(content, "\n            </tr>\n          </tbody>\n        </table>\n      </div>\n    ");
    }
  }]);
  return MjAccordionTitle;
}(_mjmlCore.BodyComponent);

exports["default"] = MjAccordionTitle;
(0, _defineProperty2["default"])(MjAccordionTitle, "endingTag", true);
(0, _defineProperty2["default"])(MjAccordionTitle, "allowedAttributes", {
  'background-color': 'color',
  color: 'color',
  'font-size': 'unit(px)',
  'font-family': 'string',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'padding-top': 'unit(px,%)',
  padding: 'unit(px,%){1,4}'
});
(0, _defineProperty2["default"])(MjAccordionTitle, "defaultAttributes", {
  'font-size': '13px',
  padding: '16px'
});
module.exports = exports.default;