'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _class, _temp;

var _mjmlCore = require('mjml-core');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MjCarouselImage = (_temp = _class = function (_BodyComponent) {
  (0, _inherits3.default)(MjCarouselImage, _BodyComponent);

  function MjCarouselImage() {
    (0, _classCallCheck3.default)(this, MjCarouselImage);
    return (0, _possibleConstructorReturn3.default)(this, (MjCarouselImage.__proto__ || (0, _getPrototypeOf2.default)(MjCarouselImage)).apply(this, arguments));
  }

  (0, _createClass3.default)(MjCarouselImage, [{
    key: 'getStyles',
    value: function getStyles() {
      return {
        images: {
          img: {
            'border-radius': this.getAttribute('border-radius'),
            display: 'block',
            width: this.context.containerWidth,
            'max-width': '100%',
            height: 'auto'
          },
          firstImageDiv: {},
          otherImageDiv: {
            display: 'none',
            'mso-hide': 'all'
          }
        },
        radio: {
          input: {
            display: 'none',
            'mso-hide': 'all'
          }
        },
        thumbnails: {
          a: {
            border: this.getAttribute('tb-border'),
            'border-radius': this.getAttribute('tb-border-radius'),
            display: 'inline-block',
            overflow: 'hidden',
            width: this.getAttribute('tb-width')
          },
          img: {
            display: 'block',
            width: '100%',
            height: 'auto'
          }
        }
      };
    }
  }, {
    key: 'renderThumbnail',
    value: function renderThumbnail() {
      var _attributes = this.attributes,
          carouselId = _attributes.carouselId,
          src = _attributes.src,
          alt = _attributes.alt,
          width = _attributes['tb-width'],
          target = _attributes.target;

      var imgIndex = this.props.index + 1;
      var cssClass = (0, _mjmlCore.suffixCssClasses)(this.getAttribute('css-class'), 'thumbnail');

      return '\n      <a\n        ' + this.htmlAttributes({
        style: 'thumbnails.a',
        href: '#' + imgIndex,
        target: target,
        class: 'mj-carousel-thumbnail mj-carousel-' + carouselId + '-thumbnail mj-carousel-' + carouselId + '-thumbnail-' + imgIndex + ' ' + cssClass
      }) + '\n      >\n        <label ' + this.htmlAttributes({
        for: 'mj-carousel-' + carouselId + '-radio-' + imgIndex
      }) + '>\n          <img\n            ' + this.htmlAttributes({
        style: 'thumbnails.img',
        src: this.getAttribute('thumbnails-src') || src,
        alt: alt,
        width: parseInt(width, 10)
      }) + '\n          />\n        </label>\n      </a>\n    ';
    }
  }, {
    key: 'renderRadio',
    value: function renderRadio() {
      var index = this.props.index;

      var carouselId = this.getAttribute('carouselId');

      return '\n      <input\n        ' + this.htmlAttributes({
        class: 'mj-carousel-radio mj-carousel-' + carouselId + '-radio mj-carousel-' + carouselId + '-radio-' + (index + 1),
        checked: index === 0 ? 'checked' : null,
        type: 'radio',
        name: 'mj-carousel-radio-' + carouselId,
        id: 'mj-carousel-' + carouselId + '-radio-' + (index + 1),
        style: 'radio.input'
      }) + '\n      />\n    ';
    }
  }, {
    key: 'render',
    value: function render() {
      var _attributes2 = this.attributes,
          src = _attributes2.src,
          alt = _attributes2.alt,
          href = _attributes2.href,
          rel = _attributes2.rel,
          title = _attributes2.title;
      var index = this.props.index;


      var image = '\n      <img\n        ' + this.htmlAttributes({
        title: title,
        src: src,
        alt: alt,
        style: 'images.img',
        width: parseInt(this.context.containerWidth, 10),
        border: '0'
      }) + ' />\n    ';

      var cssClass = this.getAttribute('css-class') || '';

      return '\n      <div\n        ' + this.htmlAttributes({
        class: 'mj-carousel-image mj-carousel-image-' + (index + 1) + ' ' + cssClass,
        style: index === 0 ? 'images.firstImageDiv' : 'images.otherImageDiv'
      }) + '\n      >\n        ' + (href ? '<a href=' + href + ' rel=' + rel + ' target="_blank">' + image + '</a>' : image) + '\n      </div>\n    ';
    }
  }]);
  return MjCarouselImage;
}(_mjmlCore.BodyComponent), _class.endingTag = true, _class.allowedAttributes = {
  alt: 'string',
  href: 'string',
  rel: 'string',
  title: 'string',
  src: 'string',
  'thumbnails-src': 'string',
  'border-radius': 'unit(px,%){1,4}',
  'tb-border': 'string',
  'tb-border-radius': 'unit(px,%){1,4}'
}, _class.defaultAttributes = {
  target: '_blank'
}, _temp);
exports.default = MjCarouselImage;
module.exports = exports['default'];