"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var _range = _interopRequireDefault(require("lodash/range"));

var _repeat = _interopRequireDefault(require("lodash/repeat"));

var _min = _interopRequireDefault(require("lodash/min"));

var _map = _interopRequireDefault(require("lodash/map"));

var _crypto = _interopRequireDefault(require("crypto"));

var _conditionalTag = require("mjml-core/lib/helpers/conditionalTag");

var MjCarousel = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjCarousel, _BodyComponent);

  function MjCarousel() {
    var _this;

    var initialDatas = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, MjCarousel);
    _this = (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjCarousel).call(this, initialDatas));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "componentHeadStyle", function () {
      var length = _this.props.children.length;

      var _assertThisInitialize = (0, _assertThisInitialized2["default"])(_this),
          carouselId = _assertThisInitialize.carouselId;

      if (!length) return '';
      var carouselCss = "\n    .mj-carousel {\n      -webkit-user-select: none;\n      -moz-user-select: none;\n      user-select: none;\n    }\n\n    .mj-carousel-".concat(_this.carouselId, "-icons-cell {\n      display: table-cell !important;\n      width: ").concat(_this.getAttribute('icon-width'), " !important;\n    }\n\n    .mj-carousel-radio,\n    .mj-carousel-next,\n    .mj-carousel-previous {\n      display: none !important;\n    }\n\n    .mj-carousel-thumbnail,\n    .mj-carousel-next,\n    .mj-carousel-previous {\n      touch-action: manipulation;\n    }\n\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-radio:checked ").concat((0, _repeat["default"])('+ * ', i), "+ .mj-carousel-content .mj-carousel-image");
      }).join(','), " {\n      display: none !important;\n    }\n\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-radio-").concat(i + 1, ":checked ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-content .mj-carousel-image-").concat(i + 1);
      }).join(','), " {\n      display: block !important;\n    }\n\n    .mj-carousel-previous-icons,\n    .mj-carousel-next-icons,\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-radio-").concat(i + 1, ":checked ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-content .mj-carousel-next-").concat((i + 1 % length + length) % length + 1);
      }), ",\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-radio-").concat(i + 1, ":checked ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-content .mj-carousel-previous-").concat((i - 1 % length + length) % length + 1);
      }), " {\n      display: block !important;\n    }\n\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-radio-").concat(i + 1, ":checked ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-content .mj-carousel-").concat(carouselId, "-thumbnail-").concat(i + 1);
      }).join(','), " {\n      border-color: ").concat(_this.getAttribute('tb-selected-border-color'), " !important;\n    }\n\n    .mj-carousel-image img + div,\n    .mj-carousel-thumbnail img + div {\n      display: none !important;\n    }\n\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-thumbnail:hover ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-main .mj-carousel-image");
      }).join(','), " {\n      display: none !important;\n    }\n\n    .mj-carousel-thumbnail:hover {\n      border-color: ").concat(_this.getAttribute('tb-hover-border-color'), " !important;\n    }\n\n    ").concat((0, _range["default"])(0, length).map(function (i) {
        return ".mj-carousel-".concat(carouselId, "-thumbnail-").concat(i + 1, ":hover ").concat((0, _repeat["default"])('+ * ', length - i - 1), "+ .mj-carousel-main .mj-carousel-image-").concat(i + 1);
      }).join(','), " {\n      display: block !important;\n    }\n    ");
      var fallback = "\n      .mj-carousel noinput { display:block !important; }\n      .mj-carousel noinput .mj-carousel-image-1 { display: block !important;  }\n      .mj-carousel noinput .mj-carousel-arrows,\n      .mj-carousel noinput .mj-carousel-thumbnails { display: none !important; }\n\n      [owa] .mj-carousel-thumbnail { display: none !important; }\n\n      @media screen yahoo {\n          .mj-carousel-".concat(_this.carouselId, "-icons-cell,\n          .mj-carousel-previous-icons,\n          .mj-carousel-next-icons {\n              display: none !important;\n          }\n\n          .mj-carousel-").concat(carouselId, "-radio-1:checked ").concat((0, _repeat["default"])('+ *', length - 1), "+ .mj-carousel-content .mj-carousel-").concat(carouselId, "-thumbnail-1 {\n              border-color: transparent;\n          }\n      }\n    ");
      return "".concat(carouselCss, "\n").concat(fallback);
    });
    _this.carouselId = _crypto["default"].randomBytes(6).toString('hex');
    return _this;
  }

  (0, _createClass2["default"])(MjCarousel, [{
    key: "getStyles",
    value: function getStyles() {
      // eslint-disable-line class-methods-use-this
      return {
        carousel: {
          div: {
            display: 'table',
            width: '100%',
            'table-layout': 'fixed',
            'text-align': 'center',
            'font-size': '0px'
          },
          table: {
            'caption-side': 'top',
            display: 'table-caption',
            'table-layout': 'fixed',
            width: '100%'
          }
        },
        images: {
          td: {
            padding: '0px'
          }
        },
        controls: {
          div: {
            display: 'none',
            'mso-hide': 'all'
          },
          img: {
            display: 'block',
            width: this.getAttribute('icon-width'),
            height: 'auto'
          },
          td: {
            'font-size': '0px',
            display: 'none',
            'mso-hide': 'all',
            padding: '0px'
          }
        }
      };
    }
  }, {
    key: "thumbnailsWidth",
    value: function thumbnailsWidth() {
      if (!this.props.children.length) return 0;
      return this.getAttribute('tb-width') || "".concat((0, _min["default"])([this.context.parentWidth / this.props.children.length, 110]), "px");
    }
  }, {
    key: "imagesAttributes",
    value: function imagesAttributes() {
      return (0, _map["default"])(this.children, 'attributes');
    }
  }, {
    key: "generateRadios",
    value: function generateRadios() {
      return this.renderChildren(this.props.children, {
        renderer: function renderer(component) {
          return component.renderRadio();
        },
        attributes: {
          carouselId: this.carouselId
        }
      });
    }
  }, {
    key: "generateThumbnails",
    value: function generateThumbnails() {
      if (this.getAttribute('thumbnails') !== 'visible') return '';
      return this.renderChildren(this.props.children, {
        attributes: {
          'tb-border': this.getAttribute('tb-border'),
          'tb-border-radius': this.getAttribute('tb-border-radius'),
          'tb-width': this.thumbnailsWidth(),
          carouselId: this.carouselId
        },
        renderer: function renderer(component) {
          return component.renderThumbnail();
        }
      });
    }
  }, {
    key: "generateControls",
    value: function generateControls(direction, icon) {
      var _this2 = this;

      var iconWidth = parseInt(this.getAttribute('icon-width'), 10);
      return "\n      <td\n        ".concat(this.htmlAttributes({
        "class": "mj-carousel-".concat(this.carouselId, "-icons-cell"),
        style: 'controls.td'
      }), "\n      >\n        <div\n          ").concat(this.htmlAttributes({
        "class": "mj-carousel-".concat(direction, "-icons"),
        style: 'controls.div'
      }), "\n        >\n          ").concat((0, _range["default"])(1, this.props.children.length + 1).map(function (i) {
        return "\n              <label\n                ".concat(_this2.htmlAttributes({
          "for": "mj-carousel-".concat(_this2.carouselId, "-radio-").concat(i),
          "class": "mj-carousel-".concat(direction, " mj-carousel-").concat(direction, "-").concat(i)
        }), "\n              >\n                <img\n                  ").concat(_this2.htmlAttributes({
          src: icon,
          alt: direction,
          style: 'controls.img',
          width: iconWidth
        }), "\n                />\n              </label>\n            ");
      }).join(''), "\n        </div>\n      </td>\n    ");
    }
  }, {
    key: "generateImages",
    value: function generateImages() {
      return "\n      <td\n        ".concat(this.htmlAttributes({
        style: 'images.td'
      }), "\n      >\n        <div\n          ").concat(this.htmlAttributes({
        "class": 'mj-carousel-images'
      }), "\n        >\n          ").concat(this.renderChildren(this.props.children, {
        attributes: {
          'border-radius': this.getAttribute('border-radius')
        }
      }), "\n        </div>\n      </td>\n    ");
    }
  }, {
    key: "generateCarousel",
    value: function generateCarousel() {
      return "\n      <table\n        ".concat(this.htmlAttributes({
        style: 'carousel.table',
        border: '0',
        'cell-padding': '0',
        'cell-spacing': '0',
        width: '100%',
        role: 'presentation',
        "class": 'mj-carousel-main'
      }), "\n      >\n        <tbody>\n          <tr>\n            ").concat(this.generateControls('previous', this.getAttribute('left-icon')), "\n            ").concat(this.generateImages(), "\n            ").concat(this.generateControls('next', this.getAttribute('right-icon')), "\n          </tr>\n        </tbody>\n      </table>\n    ");
    }
  }, {
    key: "renderFallback",
    value: function renderFallback() {
      var children = this.props.children;
      if (children.length === 0) return '';
      return (0, _conditionalTag.msoConditionalTag)(this.renderChildren([children[0]], {
        attributes: {
          'border-radius': this.getAttribute('border-radius')
        }
      }));
    }
  }, {
    key: "render",
    value: function render() {
      return "\n      ".concat((0, _conditionalTag.msoConditionalTag)("\n        <div\n          ".concat(this.htmlAttributes({
        "class": 'mj-carousel'
      }), "\n        >\n          ").concat(this.generateRadios(), "\n          <div\n            ").concat(this.htmlAttributes({
        "class": "mj-carousel-content mj-carousel-".concat(this.carouselId, "-content"),
        style: 'carousel.div'
      }), "\n          >\n            ").concat(this.generateThumbnails(), "\n            ").concat(this.generateCarousel(), "\n          </div>\n        </div>\n      "), true), "\n      ").concat(this.renderFallback(), "\n    ");
    }
  }]);
  return MjCarousel;
}(_mjmlCore.BodyComponent);

exports["default"] = MjCarousel;
(0, _defineProperty2["default"])(MjCarousel, "allowedAttributes", {
  align: 'enum(left,center,right)',
  'border-radius': 'unit(px,%)',
  'icon-width': 'unit(px,%)',
  'left-icon': 'string',
  padding: 'unit(px,%){1,4}',
  'padding-top': 'unit(px,%)',
  'padding-bottom': 'unit(px,%)',
  'padding-left': 'unit(px,%)',
  'padding-right': 'unit(px,%)',
  'right-icon': 'string',
  thumbnails: 'enum(visible,hidden)',
  'tb-border': 'string',
  'tb-border-radius': 'unit(px,%)',
  'tb-hover-border-color': 'color',
  'tb-selected-border-color': 'color',
  'tb-width': 'unit(px,%)'
});
(0, _defineProperty2["default"])(MjCarousel, "defaultAttributes", {
  align: 'center',
  'border-radius': '6px',
  'icon-width': '44px',
  'left-icon': 'https://i.imgur.com/xTh3hln.png',
  'right-icon': 'https://i.imgur.com/os7o9kz.png',
  thumbnails: 'visible',
  'tb-border': '2px solid transparent',
  'tb-border-radius': '6px',
  'tb-hover-border-color': '#fead0d',
  'tb-selected-border-color': '#ccc'
});
module.exports = exports.default;