"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _mjmlCore = require("mjml-core");

var MjCarouselImage = /*#__PURE__*/function (_BodyComponent) {
  (0, _inherits2["default"])(MjCarouselImage, _BodyComponent);

  function MjCarouselImage() {
    (0, _classCallCheck2["default"])(this, MjCarouselImage);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MjCarouselImage).apply(this, arguments));
  }

  (0, _createClass2["default"])(MjCarouselImage, [{
    key: "getStyles",
    value: function getStyles() {
      return {
        images: {
          img: {
            'border-radius': this.getAttribute('border-radius'),
            display: 'block',
            width: this.context.containerWidth,
            'max-width': '100%',
            height: 'auto'
          },
          firstImageDiv: {},
          otherImageDiv: {
            display: 'none',
            'mso-hide': 'all'
          }
        },
        radio: {
          input: {
            display: 'none',
            'mso-hide': 'all'
          }
        },
        thumbnails: {
          a: {
            border: this.getAttribute('tb-border'),
            'border-radius': this.getAttribute('tb-border-radius'),
            display: 'inline-block',
            overflow: 'hidden',
            width: this.getAttribute('tb-width')
          },
          img: {
            display: 'block',
            width: '100%',
            height: 'auto'
          }
        }
      };
    }
  }, {
    key: "renderThumbnail",
    value: function renderThumbnail() {
      var _this$attributes = this.attributes,
          carouselId = _this$attributes.carouselId,
          src = _this$attributes.src,
          alt = _this$attributes.alt,
          width = _this$attributes['tb-width'],
          target = _this$attributes.target;
      var imgIndex = this.props.index + 1;
      var cssClass = (0, _mjmlCore.suffixCssClasses)(this.getAttribute('css-class'), 'thumbnail');
      return "\n      <a\n        ".concat(this.htmlAttributes({
        style: 'thumbnails.a',
        href: "#".concat(imgIndex),
        target: target,
        "class": "mj-carousel-thumbnail mj-carousel-".concat(carouselId, "-thumbnail mj-carousel-").concat(carouselId, "-thumbnail-").concat(imgIndex, " ").concat(cssClass)
      }), "\n      >\n        <label ").concat(this.htmlAttributes({
        "for": "mj-carousel-".concat(carouselId, "-radio-").concat(imgIndex)
      }), ">\n          <img\n            ").concat(this.htmlAttributes({
        style: 'thumbnails.img',
        src: this.getAttribute('thumbnails-src') || src,
        alt: alt,
        width: parseInt(width, 10)
      }), "\n          />\n        </label>\n      </a>\n    ");
    }
  }, {
    key: "renderRadio",
    value: function renderRadio() {
      var index = this.props.index;
      var carouselId = this.getAttribute('carouselId');
      return "\n      <input\n        ".concat(this.htmlAttributes({
        "class": "mj-carousel-radio mj-carousel-".concat(carouselId, "-radio mj-carousel-").concat(carouselId, "-radio-").concat(index + 1),
        checked: index === 0 ? 'checked' : null,
        type: 'radio',
        name: "mj-carousel-radio-".concat(carouselId),
        id: "mj-carousel-".concat(carouselId, "-radio-").concat(index + 1),
        style: 'radio.input'
      }), "\n      />\n    ");
    }
  }, {
    key: "render",
    value: function render() {
      var _this$attributes2 = this.attributes,
          src = _this$attributes2.src,
          alt = _this$attributes2.alt,
          href = _this$attributes2.href,
          rel = _this$attributes2.rel,
          title = _this$attributes2.title;
      var index = this.props.index;
      var image = "\n      <img\n        ".concat(this.htmlAttributes({
        title: title,
        src: src,
        alt: alt,
        style: 'images.img',
        width: parseInt(this.context.containerWidth, 10),
        border: '0'
      }), " />\n    ");
      var cssClass = this.getAttribute('css-class') || '';
      return "\n      <div\n        ".concat(this.htmlAttributes({
        "class": "mj-carousel-image mj-carousel-image-".concat(index + 1, " ").concat(cssClass),
        style: index === 0 ? 'images.firstImageDiv' : 'images.otherImageDiv'
      }), "\n      >\n        ").concat(href ? "<a href=".concat(href, " rel=").concat(rel, " target=\"_blank\">").concat(image, "</a>") : image, "\n      </div>\n    ");
    }
  }]);
  return MjCarouselImage;
}(_mjmlCore.BodyComponent);

exports["default"] = MjCarouselImage;
(0, _defineProperty2["default"])(MjCarouselImage, "endingTag", true);
(0, _defineProperty2["default"])(MjCarouselImage, "allowedAttributes", {
  alt: 'string',
  href: 'string',
  rel: 'string',
  title: 'string',
  src: 'string',
  'thumbnails-src': 'string',
  'border-radius': 'unit(px,%){1,4}',
  'tb-border': 'string',
  'tb-border-radius': 'unit(px,%){1,4}'
});
(0, _defineProperty2["default"])(MjCarouselImage, "defaultAttributes", {
  target: '_blank'
});
module.exports = exports.default;