'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _chokidar = require('chokidar');

var _chokidar2 = _interopRequireDefault(_chokidar);

var _glob = require('glob');

var _glob2 = _interopRequireDefault(_glob);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _mjmlCore = require('mjml-core');

var _mjmlCore2 = _interopRequireDefault(_mjmlCore);

var _fp = require('lodash/fp');

var _readFile = require('./readFile');

var _readFile2 = _interopRequireDefault(_readFile);

var _outputToFile = require('./outputToFile');

var _outputToFile2 = _interopRequireDefault(_outputToFile);

var _fileContext = require('../helpers/fileContext');

var _fileContext2 = _interopRequireDefault(_fileContext);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable no-console */
var dirty = [];

var _flatMap = _fp.flatMap.convert({ cap: false }); // eslint-disable-line no-underscore-dangle
var flatMapAndJoin = _flatMap(function (v, k) {
  return v.map(function (p) {
    return _path2.default.join(k, p);
  });
});
var flatMapKeyAndValues = (0, _fp.flow)(_flatMap(function (v, k) {
  return [k].concat((0, _toConsumableArray3.default)(v));
}), _fp.uniq);

exports.default = function (input, options) {
  console.log('Now watching: ' + input);

  var dependencies = {};
  var outputToFile = (0, _outputToFile2.default)(options.o);
  var getRelatedFiles = function getRelatedFiles(file) {
    return (0, _fp.flow)((0, _fp.pickBy)(function (v, k) {
      return k === file || v.indexOf(file) !== -1;
    }), _keys2.default)(dependencies);
  };
  var synchronyzeWatcher = function synchronyzeWatcher(filePath) {
    getRelatedFiles(filePath).forEach(function (f) {
      dependencies[f] = (0, _fileContext2.default)(f);

      if (dirty.indexOf(f) === -1) {
        dirty.push(f);
      }
    });

    var files = {
      toWatch: flatMapKeyAndValues(dependencies),
      watched: flatMapAndJoin(watcher.getWatched()) // eslint-disable-line no-use-before-define
    };

    watcher.add( // eslint-disable-line no-use-before-define
    (0, _fp.difference)(files.toWatch, files.watched));
    watcher.unwatch( // eslint-disable-line no-use-before-define
    (0, _fp.difference)(files.watched, files.toWatch));
  };
  var readAndCompile = (0, _fp.flow)(function (file) {
    return { file: file, content: (0, _readFile2.default)(file).mjml };
  }, function (args) {
    return (0, _extends3.default)({}, args, {
      compiled: (0, _mjmlCore2.default)(args.content, (0, _extends3.default)({
        filePath: args.file
      }, options.config))
    });
  }, function (args) {
    var _console;

    var errors = args.compiled.errors;


    (_console = console).warn.apply(_console, [errors].concat((0, _toConsumableArray3.default)(errors.map(function (e) {
      return e.formattedMessage;
    }))));

    return args;
  }, function (args) {
    return outputToFile(args).then(function () {
      return console.log(args.file + ' - Successfully compiled');
    }).catch(function () {
      return console.log(args.file + ' - Error while compiling file');
    });
  });

  var watcher = _chokidar2.default.watch(input).on('change', function (file) {
    return synchronyzeWatcher(_path2.default.resolve(file));
  }).on('add', function (file) {
    var filePath = _path2.default.resolve(file);

    var matchInputOption = input.reduce(function (found, file) {
      return found || (0, _glob2.default)(_path2.default.resolve(file)).minimatch.match(filePath);
    }, false);

    if (matchInputOption) {
      dependencies[filePath] = getRelatedFiles(filePath);
    }

    synchronyzeWatcher(filePath);
  }).on('unlink', function (file) {
    var filePath = _path2.default.resolve(file);

    delete dependencies[_path2.default.resolve(filePath)];

    (0, _fp.remove)(dirty, function (f) {
      return f === filePath;
    });

    synchronyzeWatcher(filePath);
  });

  setInterval(function () {
    dirty.forEach(function (f) {
      console.log(f + ' - Change detected');
      try {
        readAndCompile(f);
      } catch (e) {
        console.log(f + ' - Error while rendering the file : ', e);
      }
    });
    dirty = [];
  }, 500);

  return [];
};
/* eslint-enable no-console */


module.exports = exports['default'];