'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDirectory = undefined;

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var isDirectory = exports.isDirectory = function isDirectory(file) {
  try {
    var outputPath = _path2.default.resolve(process.cwd(), file);

    return _fs2.default.statSync(outputPath).isDirectory();
  } catch (e) {
    return false;
  }
};

var replaceExtension = function replaceExtension(input) {
  return input.replace('.mjml', input.replace('.mjml', '').match(/(.)*\.(.)+$/g) ? '' : '.html');
};

var stripPath = function stripPath(input) {
  return input.match(/[^/\\]+$/g)[0];
};

var makeGuessOutputName = function makeGuessOutputName(outputPath) {
  if (isDirectory(outputPath)) {
    return function (input) {
      return _path2.default.join(outputPath, replaceExtension(stripPath(input)));
    };
  }

  return function (input) {
    if (!outputPath) {
      return replaceExtension(stripPath(input));
    }

    return outputPath;
  };
};

exports.default = function (outputPath) {
  var guessOutputName = makeGuessOutputName(outputPath);

  return function (_ref) {
    var file = _ref.file,
        html = _ref.compiled.html;
    return new _promise2.default(function (resolve, reject) {
      var outputName = guessOutputName(file);

      _fs2.default.writeFile(outputName, html, function (err) {
        if (err) {
          return reject({ outputName: outputName, err: err });
        }

        return resolve(outputName);
      });
    });
  };
};